
! **********************************************************************
module ol_heltables_pplllla_eeexexbbxa_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(61), n3(3,597)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x4(2,4,17), t3x8(2,8,62), t3x16(2,16,170), t3x128(2,128,348)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(128,7)
  integer,           save :: exthel(128,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([2,2,4], n3(:,2), t3x4(:,:,2))
  call heltable([2,2,4], n3(:,3), t3x4(:,:,3))
  n2(1) = 4
  call heltable([2,4,8], n3(:,4), t3x8(:,:,1))
  call heltable([4,4,16], n3(:,5), t3x16(:,:,1))
  n2(2) = 8
  call heltable([2,2,4], n3(:,6), t3x4(:,:,4))
  n2(3) = 4
  call heltable([4,4,16], n3(:,7), t3x16(:,:,2))
  call heltable([2,2,4], n3(:,8), t3x4(:,:,5))
  n2(4) = 4
  call heltable([2,4,8], n3(:,9), t3x8(:,:,2))
  n2(5) = 8
  call heltable([2,4,8], n3(:,10), t3x8(:,:,3))
  call heltable([4,4,16], n3(:,11), t3x16(:,:,3))
  n2(6) = 8
  call heltable([2,4,8], n3(:,12), t3x8(:,:,4))
  n2(7) = 8
  call heltable([4,4,16], n3(:,13), t3x16(:,:,4))
  call heltable([2,4,8], n3(:,14), t3x8(:,:,5))
  call heltable([4,4,16], n3(:,15), t3x16(:,:,5))
  call heltable([2,2,4], n3(:,16), t3x4(:,:,6))
  n2(8) = 4
  call heltable([4,2,8], n3(:,17), t3x8(:,:,6))
  call heltable([4,4,16], n3(:,18), t3x16(:,:,6))
  n2(9) = 8
  call heltable([4,4,16], n3(:,19), t3x16(:,:,7))
  call heltable([4,2,8], n3(:,20), t3x8(:,:,7))
  n2(10) = 8
  call heltable([4,2,8], n3(:,21), t3x8(:,:,8))
  call heltable([4,4,16], n3(:,22), t3x16(:,:,8))
  n2(11) = 8
  call heltable([4,2,8], n3(:,23), t3x8(:,:,9))
  n2(12) = 8
  call heltable([4,4,16], n3(:,24), t3x16(:,:,9))
  call heltable([4,2,8], n3(:,25), t3x8(:,:,10))
  call heltable([2,8,16], n3(:,26), t3x16(:,:,10))
  call heltable([2,8,16], n3(:,27), t3x16(:,:,11))
  call heltable([2,8,16], n3(:,28), t3x16(:,:,12))
  call heltable([2,8,16], n3(:,29), t3x16(:,:,13))
  call heltable([2,2,4], n3(:,30), t3x4(:,:,7))
  call heltable([2,2,4], n3(:,31), t3x4(:,:,8))
  n2(13) = 4
  call heltable([2,4,8], n3(:,32), t3x8(:,:,11))
  call heltable([4,4,16], n3(:,33), t3x16(:,:,14))
  n2(14) = 8
  call heltable([2,2,4], n3(:,34), t3x4(:,:,9))
  n2(15) = 4
  call heltable([4,4,16], n3(:,35), t3x16(:,:,15))
  call heltable([2,4,8], n3(:,36), t3x8(:,:,12))
  n2(16) = 8
  call heltable([2,2,4], n3(:,37), t3x4(:,:,10))
  call heltable([4,2,8], n3(:,38), t3x8(:,:,13))
  call heltable([4,4,16], n3(:,39), t3x16(:,:,16))
  n2(17) = 8
  call heltable([2,4,8], n3(:,40), t3x8(:,:,14))
  call heltable([4,4,16], n3(:,41), t3x16(:,:,17))
  n2(18) = 8
  call heltable([2,4,8], n3(:,42), t3x8(:,:,15))
  n2(19) = 8
  call heltable([4,4,16], n3(:,43), t3x16(:,:,18))
  call heltable([2,2,4], n3(:,44), t3x4(:,:,11))
  n2(20) = 4
  call heltable([4,2,8], n3(:,45), t3x8(:,:,16))
  call heltable([4,4,16], n3(:,46), t3x16(:,:,19))
  n2(21) = 8
  call heltable([4,4,16], n3(:,47), t3x16(:,:,20))
  call heltable([4,2,8], n3(:,48), t3x8(:,:,17))
  n2(22) = 8
  call heltable([2,4,8], n3(:,49), t3x8(:,:,18))
  n2(23) = 8
  call heltable([4,2,8], n3(:,50), t3x8(:,:,19))
  call heltable([4,4,16], n3(:,51), t3x16(:,:,21))
  n2(24) = 8
  call heltable([4,2,8], n3(:,52), t3x8(:,:,20))
  n2(25) = 8
  call heltable([4,4,16], n3(:,53), t3x16(:,:,22))
  call heltable([2,8,16], n3(:,54), t3x16(:,:,23))
  call heltable([2,8,16], n3(:,55), t3x16(:,:,24))
  call heltable([2,8,16], n3(:,56), t3x16(:,:,25))
  call heltable([2,8,16], n3(:,57), t3x16(:,:,26))
  call heltable([4,2,8], n3(:,58), t3x8(:,:,21))
  call heltable([2,8,16], n3(:,59), t3x16(:,:,27))
  call heltable([2,8,16], n3(:,60), t3x16(:,:,28))
  call heltable([8,2,16], n3(:,61), t3x16(:,:,29))
  call heltable([8,2,16], n3(:,62), t3x16(:,:,30))
  call heltable([2,4,8], n3(:,63), t3x8(:,:,22))
  call heltable([2,8,16], n3(:,64), t3x16(:,:,31))
  call heltable([2,8,16], n3(:,65), t3x16(:,:,32))
  call heltable([8,2,16], n3(:,66), t3x16(:,:,33))
  call heltable([8,2,16], n3(:,67), t3x16(:,:,34))
  call heltable([4,2,8], n3(:,68), t3x8(:,:,23))
  call heltable([8,2,16], n3(:,69), t3x16(:,:,35))
  call heltable([4,2,8], n3(:,70), t3x8(:,:,24))
  n2(26) = 8
  call heltable([8,2,16], n3(:,71), t3x16(:,:,36))
  call heltable([8,2,16], n3(:,72), t3x16(:,:,37))
  call heltable([8,2,16], n3(:,73), t3x16(:,:,38))
  call heltable([2,8,16], n3(:,74), t3x16(:,:,39))
  call heltable([2,8,16], n3(:,75), t3x16(:,:,40))
  call heltable([2,8,16], n3(:,76), t3x16(:,:,41))
  call heltable([2,8,16], n3(:,77), t3x16(:,:,42))
  call heltable([2,4,8], n3(:,78), t3x8(:,:,25))
  call heltable([2,4,8], n3(:,79), t3x8(:,:,26))
  n2(27) = 8
  call heltable([2,2,4], n3(:,80), t3x4(:,:,12))
  call heltable([2,2,4], n3(:,81), t3x4(:,:,13))
  call heltable([2,4,8], n3(:,82), t3x8(:,:,27))
  call heltable([4,4,16], n3(:,83), t3x16(:,:,43))
  n2(28) = 8
  call heltable([2,2,4], n3(:,84), t3x4(:,:,14))
  n2(29) = 4
  call heltable([4,4,16], n3(:,85), t3x16(:,:,44))
  call heltable([2,2,4], n3(:,86), t3x4(:,:,15))
  n2(30) = 4
  call heltable([2,4,8], n3(:,87), t3x8(:,:,28))
  n2(31) = 8
  call heltable([2,4,8], n3(:,88), t3x8(:,:,29))
  call heltable([4,4,16], n3(:,89), t3x16(:,:,45))
  n2(32) = 8
  call heltable([2,4,8], n3(:,90), t3x8(:,:,30))
  n2(33) = 8
  call heltable([4,4,16], n3(:,91), t3x16(:,:,46))
  call heltable([4,4,16], n3(:,92), t3x16(:,:,47))
  call heltable([4,2,8], n3(:,93), t3x8(:,:,31))
  call heltable([4,4,16], n3(:,94), t3x16(:,:,48))
  n2(34) = 8
  call heltable([4,4,16], n3(:,95), t3x16(:,:,49))
  call heltable([4,2,8], n3(:,96), t3x8(:,:,32))
  n2(35) = 8
  call heltable([4,2,8], n3(:,97), t3x8(:,:,33))
  call heltable([4,4,16], n3(:,98), t3x16(:,:,50))
  n2(36) = 8
  call heltable([4,2,8], n3(:,99), t3x8(:,:,34))
  n2(37) = 8
  call heltable([4,4,16], n3(:,100), t3x16(:,:,51))
  call heltable([2,8,16], n3(:,101), t3x16(:,:,52))
  call heltable([2,8,16], n3(:,102), t3x16(:,:,53))
  call heltable([2,8,16], n3(:,103), t3x16(:,:,54))
  call heltable([2,8,16], n3(:,104), t3x16(:,:,55))
  call heltable([2,2,4], n3(:,105), t3x4(:,:,16))
  n2(38) = 4
  call heltable([4,2,8], n3(:,106), t3x8(:,:,35))
  call heltable([4,4,16], n3(:,107), t3x16(:,:,56))
  n2(39) = 8
  call heltable([2,4,8], n3(:,108), t3x8(:,:,36))
  call heltable([4,4,16], n3(:,109), t3x16(:,:,57))
  n2(40) = 8
  call heltable([4,4,16], n3(:,110), t3x16(:,:,58))
  call heltable([2,4,8], n3(:,111), t3x8(:,:,37))
  n2(41) = 8
  call heltable([4,4,16], n3(:,112), t3x16(:,:,59))
  call heltable([4,4,16], n3(:,113), t3x16(:,:,60))
  call heltable([4,2,8], n3(:,114), t3x8(:,:,38))
  n2(42) = 8
  call heltable([4,2,8], n3(:,115), t3x8(:,:,39))
  n2(43) = 8
  call heltable([2,4,8], n3(:,116), t3x8(:,:,40))
  n2(44) = 8
  call heltable([4,2,8], n3(:,117), t3x8(:,:,41))
  call heltable([4,4,16], n3(:,118), t3x16(:,:,61))
  n2(45) = 8
  call heltable([4,4,16], n3(:,119), t3x16(:,:,62))
  call heltable([4,2,8], n3(:,120), t3x8(:,:,42))
  n2(46) = 8
  call heltable([2,8,16], n3(:,121), t3x16(:,:,63))
  call heltable([2,8,16], n3(:,122), t3x16(:,:,64))
  call heltable([2,8,16], n3(:,123), t3x16(:,:,65))
  call heltable([2,8,16], n3(:,124), t3x16(:,:,66))
  call heltable([4,2,8], n3(:,125), t3x8(:,:,43))
  call heltable([2,8,16], n3(:,126), t3x16(:,:,67))
  call heltable([2,8,16], n3(:,127), t3x16(:,:,68))
  call heltable([8,2,16], n3(:,128), t3x16(:,:,69))
  call heltable([8,2,16], n3(:,129), t3x16(:,:,70))
  call heltable([2,4,8], n3(:,130), t3x8(:,:,44))
  call heltable([8,2,16], n3(:,131), t3x16(:,:,71))
  call heltable([8,2,16], n3(:,132), t3x16(:,:,72))
  call heltable([2,8,16], n3(:,133), t3x16(:,:,73))
  call heltable([2,8,16], n3(:,134), t3x16(:,:,74))
  call heltable([8,2,16], n3(:,135), t3x16(:,:,75))
  call heltable([8,2,16], n3(:,136), t3x16(:,:,76))
  call heltable([8,2,16], n3(:,137), t3x16(:,:,77))
  call heltable([8,2,16], n3(:,138), t3x16(:,:,78))
  call heltable([2,8,16], n3(:,139), t3x16(:,:,79))
  call heltable([2,8,16], n3(:,140), t3x16(:,:,80))
  call heltable([2,8,16], n3(:,141), t3x16(:,:,81))
  call heltable([2,8,16], n3(:,142), t3x16(:,:,82))
  call heltable([2,4,8], n3(:,143), t3x8(:,:,45))
  n2(47) = 8
  call heltable([2,4,8], n3(:,144), t3x8(:,:,46))
  n2(48) = 8
  call heltable([4,2,8], n3(:,145), t3x8(:,:,47))
  call heltable([4,4,16], n3(:,146), t3x16(:,:,83))
  n2(49) = 8
  call heltable([2,4,8], n3(:,147), t3x8(:,:,48))
  call heltable([4,4,16], n3(:,148), t3x16(:,:,84))
  n2(50) = 8
  call heltable([2,4,8], n3(:,149), t3x8(:,:,49))
  n2(51) = 8
  call heltable([4,4,16], n3(:,150), t3x16(:,:,85))
  call heltable([2,2,4], n3(:,151), t3x4(:,:,17))
  n2(52) = 4
  call heltable([4,2,8], n3(:,152), t3x8(:,:,50))
  call heltable([4,4,16], n3(:,153), t3x16(:,:,86))
  n2(53) = 8
  call heltable([4,4,16], n3(:,154), t3x16(:,:,87))
  call heltable([4,2,8], n3(:,155), t3x8(:,:,51))
  n2(54) = 8
  call heltable([2,4,8], n3(:,156), t3x8(:,:,52))
  n2(55) = 8
  call heltable([4,4,16], n3(:,157), t3x16(:,:,88))
  call heltable([4,4,16], n3(:,158), t3x16(:,:,89))
  call heltable([2,8,16], n3(:,159), t3x16(:,:,90))
  call heltable([2,8,16], n3(:,160), t3x16(:,:,91))
  call heltable([4,2,8], n3(:,161), t3x8(:,:,53))
  call heltable([2,8,16], n3(:,162), t3x16(:,:,92))
  call heltable([2,8,16], n3(:,163), t3x16(:,:,93))
  call heltable([8,2,16], n3(:,164), t3x16(:,:,94))
  call heltable([8,2,16], n3(:,165), t3x16(:,:,95))
  call heltable([2,4,8], n3(:,166), t3x8(:,:,54))
  call heltable([2,8,16], n3(:,167), t3x16(:,:,96))
  call heltable([2,8,16], n3(:,168), t3x16(:,:,97))
  call heltable([8,2,16], n3(:,169), t3x16(:,:,98))
  call heltable([8,2,16], n3(:,170), t3x16(:,:,99))
  call heltable([8,2,16], n3(:,171), t3x16(:,:,100))
  call heltable([8,2,16], n3(:,172), t3x16(:,:,101))
  call heltable([8,2,16], n3(:,173), t3x16(:,:,102))
  call heltable([8,2,16], n3(:,174), t3x16(:,:,103))
  call heltable([2,8,16], n3(:,175), t3x16(:,:,104))
  call heltable([2,8,16], n3(:,176), t3x16(:,:,105))
  call heltable([2,8,16], n3(:,177), t3x16(:,:,106))
  call heltable([2,8,16], n3(:,178), t3x16(:,:,107))
  call heltable([4,2,8], n3(:,179), t3x8(:,:,55))
  call heltable([4,4,16], n3(:,180), t3x16(:,:,108))
  n2(56) = 8
  call heltable([2,4,8], n3(:,181), t3x8(:,:,56))
  n2(57) = 8
  call heltable([2,4,8], n3(:,182), t3x8(:,:,57))
  n2(58) = 8
  call heltable([4,4,16], n3(:,183), t3x16(:,:,109))
  call heltable([4,4,16], n3(:,184), t3x16(:,:,110))
  call heltable([4,2,8], n3(:,185), t3x8(:,:,58))
  n2(59) = 8
  call heltable([4,2,8], n3(:,186), t3x8(:,:,59))
  n2(60) = 8
  call heltable([2,4,8], n3(:,187), t3x8(:,:,60))
  n2(61) = 8
  call heltable([4,4,16], n3(:,188), t3x16(:,:,111))
  call heltable([4,4,16], n3(:,189), t3x16(:,:,112))
  call heltable([2,8,16], n3(:,190), t3x16(:,:,113))
  call heltable([2,8,16], n3(:,191), t3x16(:,:,114))
  call heltable([4,2,8], n3(:,192), t3x8(:,:,61))
  call heltable([2,8,16], n3(:,193), t3x16(:,:,115))
  call heltable([2,8,16], n3(:,194), t3x16(:,:,116))
  call heltable([8,2,16], n3(:,195), t3x16(:,:,117))
  call heltable([8,2,16], n3(:,196), t3x16(:,:,118))
  call heltable([2,4,8], n3(:,197), t3x8(:,:,62))
  call heltable([8,2,16], n3(:,198), t3x16(:,:,119))
  call heltable([8,2,16], n3(:,199), t3x16(:,:,120))
  call heltable([2,8,16], n3(:,200), t3x16(:,:,121))
  call heltable([2,8,16], n3(:,201), t3x16(:,:,122))
  call heltable([8,2,16], n3(:,202), t3x16(:,:,123))
  call heltable([8,2,16], n3(:,203), t3x16(:,:,124))
  call heltable([8,2,16], n3(:,204), t3x16(:,:,125))
  call heltable([8,2,16], n3(:,205), t3x16(:,:,126))
  call heltable([2,8,16], n3(:,206), t3x16(:,:,127))
  call heltable([2,8,16], n3(:,207), t3x16(:,:,128))
  call heltable([2,8,16], n3(:,208), t3x16(:,:,129))
  call heltable([2,8,16], n3(:,209), t3x16(:,:,130))
  call heltable([8,2,16], n3(:,210), t3x16(:,:,131))
  call heltable([8,2,16], n3(:,211), t3x16(:,:,132))
  call heltable([8,2,16], n3(:,212), t3x16(:,:,133))
  call heltable([8,2,16], n3(:,213), t3x16(:,:,134))
  call heltable([8,2,16], n3(:,214), t3x16(:,:,135))
  call heltable([8,2,16], n3(:,215), t3x16(:,:,136))
  call heltable([2,8,16], n3(:,216), t3x16(:,:,137))
  call heltable([2,8,16], n3(:,217), t3x16(:,:,138))
  call heltable([2,8,16], n3(:,218), t3x16(:,:,139))
  call heltable([2,8,16], n3(:,219), t3x16(:,:,140))
  call heltable([8,2,16], n3(:,220), t3x16(:,:,141))
  call heltable([8,2,16], n3(:,221), t3x16(:,:,142))
  call heltable([8,2,16], n3(:,222), t3x16(:,:,143))
  call heltable([8,2,16], n3(:,223), t3x16(:,:,144))
  call heltable([8,2,16], n3(:,224), t3x16(:,:,145))
  call heltable([8,2,16], n3(:,225), t3x16(:,:,146))
  call heltable([2,8,16], n3(:,226), t3x16(:,:,147))
  call heltable([2,8,16], n3(:,227), t3x16(:,:,148))
  call heltable([2,8,16], n3(:,228), t3x16(:,:,149))
  call heltable([2,8,16], n3(:,229), t3x16(:,:,150))
  call heltable([8,2,16], n3(:,230), t3x16(:,:,151))
  call heltable([8,2,16], n3(:,231), t3x16(:,:,152))
  call heltable([8,2,16], n3(:,232), t3x16(:,:,153))
  call heltable([8,2,16], n3(:,233), t3x16(:,:,154))
  call heltable([8,2,16], n3(:,234), t3x16(:,:,155))
  call heltable([8,2,16], n3(:,235), t3x16(:,:,156))
  call heltable([8,2,16], n3(:,236), t3x16(:,:,157))
  call heltable([8,2,16], n3(:,237), t3x16(:,:,158))
  call heltable([8,2,16], n3(:,238), t3x16(:,:,159))
  call heltable([8,2,16], n3(:,239), t3x16(:,:,160))
  call heltable([8,2,16], n3(:,240), t3x16(:,:,161))
  call heltable([8,2,16], n3(:,241), t3x16(:,:,162))
  call heltable([2,8,16], n3(:,242), t3x16(:,:,163))
  call heltable([2,8,16], n3(:,243), t3x16(:,:,164))
  call heltable([8,2,16], n3(:,244), t3x16(:,:,165))
  call heltable([8,2,16], n3(:,245), t3x16(:,:,166))
  call heltable([8,2,16], n3(:,246), t3x16(:,:,167))
  call heltable([8,2,16], n3(:,247), t3x16(:,:,168))
  call heltable([2,8,16], n3(:,248), t3x16(:,:,169))
  call heltable([2,8,16], n3(:,249), t3x16(:,:,170))
  call heltable([16,8,128], n3(:,250), t3x128(:,:,1))
  call heltable([8,16,128], n3(:,251), t3x128(:,:,2))
  call heltable([16,8,128], n3(:,252), t3x128(:,:,3))
  call heltable([16,8,128], n3(:,253), t3x128(:,:,4))
  call heltable([16,8,128], n3(:,254), t3x128(:,:,5))
  call heltable([16,8,128], n3(:,255), t3x128(:,:,6))
  call heltable([8,16,128], n3(:,256), t3x128(:,:,7))
  call heltable([8,16,128], n3(:,257), t3x128(:,:,8))
  call heltable([8,16,128], n3(:,258), t3x128(:,:,9))
  call heltable([16,8,128], n3(:,259), t3x128(:,:,10))
  call heltable([8,16,128], n3(:,260), t3x128(:,:,11))
  call heltable([16,8,128], n3(:,261), t3x128(:,:,12))
  call heltable([16,8,128], n3(:,262), t3x128(:,:,13))
  call heltable([16,8,128], n3(:,263), t3x128(:,:,14))
  call heltable([16,8,128], n3(:,264), t3x128(:,:,15))
  call heltable([8,16,128], n3(:,265), t3x128(:,:,16))
  call heltable([8,16,128], n3(:,266), t3x128(:,:,17))
  call heltable([16,8,128], n3(:,267), t3x128(:,:,18))
  call heltable([8,16,128], n3(:,268), t3x128(:,:,19))
  call heltable([8,16,128], n3(:,269), t3x128(:,:,20))
  call heltable([8,16,128], n3(:,270), t3x128(:,:,21))
  call heltable([8,16,128], n3(:,271), t3x128(:,:,22))
  call heltable([8,16,128], n3(:,272), t3x128(:,:,23))
  call heltable([8,16,128], n3(:,273), t3x128(:,:,24))
  call heltable([8,16,128], n3(:,274), t3x128(:,:,25))
  call heltable([8,16,128], n3(:,275), t3x128(:,:,26))
  call heltable([16,8,128], n3(:,276), t3x128(:,:,27))
  call heltable([8,16,128], n3(:,277), t3x128(:,:,28))
  call heltable([16,8,128], n3(:,278), t3x128(:,:,29))
  call heltable([16,8,128], n3(:,279), t3x128(:,:,30))
  call heltable([16,8,128], n3(:,280), t3x128(:,:,31))
  call heltable([16,8,128], n3(:,281), t3x128(:,:,32))
  call heltable([16,8,128], n3(:,282), t3x128(:,:,33))
  call heltable([8,16,128], n3(:,283), t3x128(:,:,34))
  call heltable([8,16,128], n3(:,284), t3x128(:,:,35))
  call heltable([16,8,128], n3(:,285), t3x128(:,:,36))
  call heltable([8,16,128], n3(:,286), t3x128(:,:,37))
  call heltable([16,8,128], n3(:,287), t3x128(:,:,38))
  call heltable([16,8,128], n3(:,288), t3x128(:,:,39))
  call heltable([16,8,128], n3(:,289), t3x128(:,:,40))
  call heltable([16,8,128], n3(:,290), t3x128(:,:,41))
  call heltable([16,8,128], n3(:,291), t3x128(:,:,42))
  call heltable([8,16,128], n3(:,292), t3x128(:,:,43))
  call heltable([8,16,128], n3(:,293), t3x128(:,:,44))
  call heltable([8,16,128], n3(:,294), t3x128(:,:,45))
  call heltable([8,16,128], n3(:,295), t3x128(:,:,46))
  call heltable([8,16,128], n3(:,296), t3x128(:,:,47))
  call heltable([8,16,128], n3(:,297), t3x128(:,:,48))
  call heltable([8,16,128], n3(:,298), t3x128(:,:,49))
  call heltable([8,16,128], n3(:,299), t3x128(:,:,50))
  call heltable([8,16,128], n3(:,300), t3x128(:,:,51))
  call heltable([8,16,128], n3(:,301), t3x128(:,:,52))
  call heltable([8,16,128], n3(:,302), t3x128(:,:,53))
  call heltable([8,16,128], n3(:,303), t3x128(:,:,54))
  call heltable([8,16,128], n3(:,304), t3x128(:,:,55))
  call heltable([8,16,128], n3(:,305), t3x128(:,:,56))
  call heltable([8,16,128], n3(:,306), t3x128(:,:,57))
  call heltable([8,16,128], n3(:,307), t3x128(:,:,58))
  call heltable([8,16,128], n3(:,308), t3x128(:,:,59))
  call heltable([8,16,128], n3(:,309), t3x128(:,:,60))
  call heltable([8,16,128], n3(:,310), t3x128(:,:,61))
  call heltable([8,16,128], n3(:,311), t3x128(:,:,62))
  call heltable([8,16,128], n3(:,312), t3x128(:,:,63))
  call heltable([8,16,128], n3(:,313), t3x128(:,:,64))
  call heltable([8,16,128], n3(:,314), t3x128(:,:,65))
  call heltable([8,16,128], n3(:,315), t3x128(:,:,66))
  call heltable([8,16,128], n3(:,316), t3x128(:,:,67))
  call heltable([8,16,128], n3(:,317), t3x128(:,:,68))
  call heltable([8,16,128], n3(:,318), t3x128(:,:,69))
  call heltable([8,16,128], n3(:,319), t3x128(:,:,70))
  call heltable([8,16,128], n3(:,320), t3x128(:,:,71))
  call heltable([8,16,128], n3(:,321), t3x128(:,:,72))
  call heltable([8,16,128], n3(:,322), t3x128(:,:,73))
  call heltable([8,16,128], n3(:,323), t3x128(:,:,74))
  call heltable([8,16,128], n3(:,324), t3x128(:,:,75))
  call heltable([8,16,128], n3(:,325), t3x128(:,:,76))
  call heltable([16,8,128], n3(:,326), t3x128(:,:,77))
  call heltable([16,8,128], n3(:,327), t3x128(:,:,78))
  call heltable([16,8,128], n3(:,328), t3x128(:,:,79))
  call heltable([16,8,128], n3(:,329), t3x128(:,:,80))
  call heltable([16,8,128], n3(:,330), t3x128(:,:,81))
  call heltable([16,8,128], n3(:,331), t3x128(:,:,82))
  call heltable([16,8,128], n3(:,332), t3x128(:,:,83))
  call heltable([16,8,128], n3(:,333), t3x128(:,:,84))
  call heltable([16,8,128], n3(:,334), t3x128(:,:,85))
  call heltable([8,16,128], n3(:,335), t3x128(:,:,86))
  call heltable([16,8,128], n3(:,336), t3x128(:,:,87))
  call heltable([16,8,128], n3(:,337), t3x128(:,:,88))
  call heltable([16,8,128], n3(:,338), t3x128(:,:,89))
  call heltable([16,8,128], n3(:,339), t3x128(:,:,90))
  call heltable([8,16,128], n3(:,340), t3x128(:,:,91))
  call heltable([8,16,128], n3(:,341), t3x128(:,:,92))
  call heltable([8,16,128], n3(:,342), t3x128(:,:,93))
  call heltable([16,8,128], n3(:,343), t3x128(:,:,94))
  call heltable([8,16,128], n3(:,344), t3x128(:,:,95))
  call heltable([16,8,128], n3(:,345), t3x128(:,:,96))
  call heltable([16,8,128], n3(:,346), t3x128(:,:,97))
  call heltable([16,8,128], n3(:,347), t3x128(:,:,98))
  call heltable([16,8,128], n3(:,348), t3x128(:,:,99))
  call heltable([8,16,128], n3(:,349), t3x128(:,:,100))
  call heltable([8,16,128], n3(:,350), t3x128(:,:,101))
  call heltable([8,16,128], n3(:,351), t3x128(:,:,102))
  call heltable([8,16,128], n3(:,352), t3x128(:,:,103))
  call heltable([8,16,128], n3(:,353), t3x128(:,:,104))
  call heltable([8,16,128], n3(:,354), t3x128(:,:,105))
  call heltable([8,16,128], n3(:,355), t3x128(:,:,106))
  call heltable([8,16,128], n3(:,356), t3x128(:,:,107))
  call heltable([8,16,128], n3(:,357), t3x128(:,:,108))
  call heltable([8,16,128], n3(:,358), t3x128(:,:,109))
  call heltable([8,16,128], n3(:,359), t3x128(:,:,110))
  call heltable([16,8,128], n3(:,360), t3x128(:,:,111))
  call heltable([16,8,128], n3(:,361), t3x128(:,:,112))
  call heltable([8,16,128], n3(:,362), t3x128(:,:,113))
  call heltable([16,8,128], n3(:,363), t3x128(:,:,114))
  call heltable([16,8,128], n3(:,364), t3x128(:,:,115))
  call heltable([8,16,128], n3(:,365), t3x128(:,:,116))
  call heltable([8,16,128], n3(:,366), t3x128(:,:,117))
  call heltable([8,16,128], n3(:,367), t3x128(:,:,118))
  call heltable([8,16,128], n3(:,368), t3x128(:,:,119))
  call heltable([16,8,128], n3(:,369), t3x128(:,:,120))
  call heltable([16,8,128], n3(:,370), t3x128(:,:,121))
  call heltable([16,8,128], n3(:,371), t3x128(:,:,122))
  call heltable([16,8,128], n3(:,372), t3x128(:,:,123))
  call heltable([16,8,128], n3(:,373), t3x128(:,:,124))
  call heltable([16,8,128], n3(:,374), t3x128(:,:,125))
  call heltable([8,16,128], n3(:,375), t3x128(:,:,126))
  call heltable([16,8,128], n3(:,376), t3x128(:,:,127))
  call heltable([16,8,128], n3(:,377), t3x128(:,:,128))
  call heltable([8,16,128], n3(:,378), t3x128(:,:,129))
  call heltable([8,16,128], n3(:,379), t3x128(:,:,130))
  call heltable([8,16,128], n3(:,380), t3x128(:,:,131))
  call heltable([8,16,128], n3(:,381), t3x128(:,:,132))
  call heltable([8,16,128], n3(:,382), t3x128(:,:,133))
  call heltable([8,16,128], n3(:,383), t3x128(:,:,134))
  call heltable([8,16,128], n3(:,384), t3x128(:,:,135))
  call heltable([8,16,128], n3(:,385), t3x128(:,:,136))
  call heltable([8,16,128], n3(:,386), t3x128(:,:,137))
  call heltable([8,16,128], n3(:,387), t3x128(:,:,138))
  call heltable([8,16,128], n3(:,388), t3x128(:,:,139))
  call heltable([8,16,128], n3(:,389), t3x128(:,:,140))
  call heltable([8,16,128], n3(:,390), t3x128(:,:,141))
  call heltable([8,16,128], n3(:,391), t3x128(:,:,142))
  call heltable([8,16,128], n3(:,392), t3x128(:,:,143))
  call heltable([8,16,128], n3(:,393), t3x128(:,:,144))
  call heltable([8,16,128], n3(:,394), t3x128(:,:,145))
  call heltable([8,16,128], n3(:,395), t3x128(:,:,146))
  call heltable([8,16,128], n3(:,396), t3x128(:,:,147))
  call heltable([8,16,128], n3(:,397), t3x128(:,:,148))
  call heltable([8,16,128], n3(:,398), t3x128(:,:,149))
  call heltable([8,16,128], n3(:,399), t3x128(:,:,150))
  call heltable([8,16,128], n3(:,400), t3x128(:,:,151))
  call heltable([8,16,128], n3(:,401), t3x128(:,:,152))
  call heltable([8,16,128], n3(:,402), t3x128(:,:,153))
  call heltable([8,16,128], n3(:,403), t3x128(:,:,154))
  call heltable([8,16,128], n3(:,404), t3x128(:,:,155))
  call heltable([8,16,128], n3(:,405), t3x128(:,:,156))
  call heltable([8,16,128], n3(:,406), t3x128(:,:,157))
  call heltable([8,16,128], n3(:,407), t3x128(:,:,158))
  call heltable([8,16,128], n3(:,408), t3x128(:,:,159))
  call heltable([8,16,128], n3(:,409), t3x128(:,:,160))
  call heltable([8,16,128], n3(:,410), t3x128(:,:,161))
  call heltable([8,16,128], n3(:,411), t3x128(:,:,162))
  call heltable([8,16,128], n3(:,412), t3x128(:,:,163))
  call heltable([8,16,128], n3(:,413), t3x128(:,:,164))
  call heltable([8,16,128], n3(:,414), t3x128(:,:,165))
  call heltable([8,16,128], n3(:,415), t3x128(:,:,166))
  call heltable([8,16,128], n3(:,416), t3x128(:,:,167))
  call heltable([8,16,128], n3(:,417), t3x128(:,:,168))
  call heltable([16,8,128], n3(:,418), t3x128(:,:,169))
  call heltable([16,8,128], n3(:,419), t3x128(:,:,170))
  call heltable([16,8,128], n3(:,420), t3x128(:,:,171))
  call heltable([16,8,128], n3(:,421), t3x128(:,:,172))
  call heltable([16,8,128], n3(:,422), t3x128(:,:,173))
  call heltable([16,8,128], n3(:,423), t3x128(:,:,174))
  call heltable([16,8,128], n3(:,424), t3x128(:,:,175))
  call heltable([8,16,128], n3(:,425), t3x128(:,:,176))
  call heltable([8,16,128], n3(:,426), t3x128(:,:,177))
  call heltable([16,8,128], n3(:,427), t3x128(:,:,178))
  call heltable([8,16,128], n3(:,428), t3x128(:,:,179))
  call heltable([16,8,128], n3(:,429), t3x128(:,:,180))
  call heltable([16,8,128], n3(:,430), t3x128(:,:,181))
  call heltable([16,8,128], n3(:,431), t3x128(:,:,182))
  call heltable([8,16,128], n3(:,432), t3x128(:,:,183))
  call heltable([8,16,128], n3(:,433), t3x128(:,:,184))
  call heltable([8,16,128], n3(:,434), t3x128(:,:,185))
  call heltable([8,16,128], n3(:,435), t3x128(:,:,186))
  call heltable([8,16,128], n3(:,436), t3x128(:,:,187))
  call heltable([8,16,128], n3(:,437), t3x128(:,:,188))
  call heltable([8,16,128], n3(:,438), t3x128(:,:,189))
  call heltable([8,16,128], n3(:,439), t3x128(:,:,190))
  call heltable([16,8,128], n3(:,440), t3x128(:,:,191))
  call heltable([16,8,128], n3(:,441), t3x128(:,:,192))
  call heltable([16,8,128], n3(:,442), t3x128(:,:,193))
  call heltable([16,8,128], n3(:,443), t3x128(:,:,194))
  call heltable([8,16,128], n3(:,444), t3x128(:,:,195))
  call heltable([8,16,128], n3(:,445), t3x128(:,:,196))
  call heltable([8,16,128], n3(:,446), t3x128(:,:,197))
  call heltable([8,16,128], n3(:,447), t3x128(:,:,198))
  call heltable([8,16,128], n3(:,448), t3x128(:,:,199))
  call heltable([8,16,128], n3(:,449), t3x128(:,:,200))
  call heltable([8,16,128], n3(:,450), t3x128(:,:,201))
  call heltable([8,16,128], n3(:,451), t3x128(:,:,202))
  call heltable([8,16,128], n3(:,452), t3x128(:,:,203))
  call heltable([8,16,128], n3(:,453), t3x128(:,:,204))
  call heltable([8,16,128], n3(:,454), t3x128(:,:,205))
  call heltable([8,16,128], n3(:,455), t3x128(:,:,206))
  call heltable([8,16,128], n3(:,456), t3x128(:,:,207))
  call heltable([8,16,128], n3(:,457), t3x128(:,:,208))
  call heltable([8,16,128], n3(:,458), t3x128(:,:,209))
  call heltable([8,16,128], n3(:,459), t3x128(:,:,210))
  call heltable([8,16,128], n3(:,460), t3x128(:,:,211))
  call heltable([8,16,128], n3(:,461), t3x128(:,:,212))
  call heltable([8,16,128], n3(:,462), t3x128(:,:,213))
  call heltable([8,16,128], n3(:,463), t3x128(:,:,214))
  call heltable([8,16,128], n3(:,464), t3x128(:,:,215))
  call heltable([8,16,128], n3(:,465), t3x128(:,:,216))
  call heltable([8,16,128], n3(:,466), t3x128(:,:,217))
  call heltable([8,16,128], n3(:,467), t3x128(:,:,218))
  call heltable([8,16,128], n3(:,468), t3x128(:,:,219))
  call heltable([8,16,128], n3(:,469), t3x128(:,:,220))
  call heltable([8,16,128], n3(:,470), t3x128(:,:,221))
  call heltable([8,16,128], n3(:,471), t3x128(:,:,222))
  call heltable([8,16,128], n3(:,472), t3x128(:,:,223))
  call heltable([8,16,128], n3(:,473), t3x128(:,:,224))
  call heltable([8,16,128], n3(:,474), t3x128(:,:,225))
  call heltable([8,16,128], n3(:,475), t3x128(:,:,226))
  call heltable([16,8,128], n3(:,476), t3x128(:,:,227))
  call heltable([16,8,128], n3(:,477), t3x128(:,:,228))
  call heltable([16,8,128], n3(:,478), t3x128(:,:,229))
  call heltable([16,8,128], n3(:,479), t3x128(:,:,230))
  call heltable([16,8,128], n3(:,480), t3x128(:,:,231))
  call heltable([8,16,128], n3(:,481), t3x128(:,:,232))
  call heltable([8,16,128], n3(:,482), t3x128(:,:,233))
  call heltable([8,16,128], n3(:,483), t3x128(:,:,234))
  call heltable([8,16,128], n3(:,484), t3x128(:,:,235))
  call heltable([16,8,128], n3(:,485), t3x128(:,:,236))
  call heltable([16,8,128], n3(:,486), t3x128(:,:,237))
  call heltable([16,8,128], n3(:,487), t3x128(:,:,238))
  call heltable([16,8,128], n3(:,488), t3x128(:,:,239))
  call heltable([16,8,128], n3(:,489), t3x128(:,:,240))
  call heltable([8,16,128], n3(:,490), t3x128(:,:,241))
  call heltable([8,16,128], n3(:,491), t3x128(:,:,242))
  call heltable([8,16,128], n3(:,492), t3x128(:,:,243))
  call heltable([8,16,128], n3(:,493), t3x128(:,:,244))
  call heltable([8,16,128], n3(:,494), t3x128(:,:,245))
  call heltable([8,16,128], n3(:,495), t3x128(:,:,246))
  call heltable([8,16,128], n3(:,496), t3x128(:,:,247))
  call heltable([8,16,128], n3(:,497), t3x128(:,:,248))
  call heltable([16,8,128], n3(:,498), t3x128(:,:,249))
  call heltable([16,8,128], n3(:,499), t3x128(:,:,250))
  call heltable([16,8,128], n3(:,500), t3x128(:,:,251))
  call heltable([16,8,128], n3(:,501), t3x128(:,:,252))
  call heltable([8,16,128], n3(:,502), t3x128(:,:,253))
  call heltable([8,16,128], n3(:,503), t3x128(:,:,254))
  call heltable([8,16,128], n3(:,504), t3x128(:,:,255))
  call heltable([8,16,128], n3(:,505), t3x128(:,:,256))
  call heltable([8,16,128], n3(:,506), t3x128(:,:,257))
  call heltable([8,16,128], n3(:,507), t3x128(:,:,258))
  call heltable([8,16,128], n3(:,508), t3x128(:,:,259))
  call heltable([8,16,128], n3(:,509), t3x128(:,:,260))
  call heltable([8,16,128], n3(:,510), t3x128(:,:,261))
  call heltable([8,16,128], n3(:,511), t3x128(:,:,262))
  call heltable([8,16,128], n3(:,512), t3x128(:,:,263))
  call heltable([8,16,128], n3(:,513), t3x128(:,:,264))
  call heltable([8,16,128], n3(:,514), t3x128(:,:,265))
  call heltable([8,16,128], n3(:,515), t3x128(:,:,266))
  call heltable([8,16,128], n3(:,516), t3x128(:,:,267))
  call heltable([8,16,128], n3(:,517), t3x128(:,:,268))
  call heltable([8,16,128], n3(:,518), t3x128(:,:,269))
  call heltable([8,16,128], n3(:,519), t3x128(:,:,270))
  call heltable([8,16,128], n3(:,520), t3x128(:,:,271))
  call heltable([8,16,128], n3(:,521), t3x128(:,:,272))
  call heltable([8,16,128], n3(:,522), t3x128(:,:,273))
  call heltable([8,16,128], n3(:,523), t3x128(:,:,274))
  call heltable([8,16,128], n3(:,524), t3x128(:,:,275))
  call heltable([8,16,128], n3(:,525), t3x128(:,:,276))
  call heltable([8,16,128], n3(:,526), t3x128(:,:,277))
  call heltable([8,16,128], n3(:,527), t3x128(:,:,278))
  call heltable([8,16,128], n3(:,528), t3x128(:,:,279))
  call heltable([8,16,128], n3(:,529), t3x128(:,:,280))
  call heltable([8,16,128], n3(:,530), t3x128(:,:,281))
  call heltable([8,16,128], n3(:,531), t3x128(:,:,282))
  call heltable([8,16,128], n3(:,532), t3x128(:,:,283))
  call heltable([8,16,128], n3(:,533), t3x128(:,:,284))
  call heltable([8,16,128], n3(:,534), t3x128(:,:,285))
  call heltable([8,16,128], n3(:,535), t3x128(:,:,286))
  call heltable([8,16,128], n3(:,536), t3x128(:,:,287))
  call heltable([8,16,128], n3(:,537), t3x128(:,:,288))
  call heltable([8,16,128], n3(:,538), t3x128(:,:,289))
  call heltable([8,16,128], n3(:,539), t3x128(:,:,290))
  call heltable([8,16,128], n3(:,540), t3x128(:,:,291))
  call heltable([8,16,128], n3(:,541), t3x128(:,:,292))
  call heltable([8,16,128], n3(:,542), t3x128(:,:,293))
  call heltable([8,16,128], n3(:,543), t3x128(:,:,294))
  call heltable([8,16,128], n3(:,544), t3x128(:,:,295))
  call heltable([8,16,128], n3(:,545), t3x128(:,:,296))
  call heltable([8,16,128], n3(:,546), t3x128(:,:,297))
  call heltable([8,16,128], n3(:,547), t3x128(:,:,298))
  call heltable([8,16,128], n3(:,548), t3x128(:,:,299))
  call heltable([8,16,128], n3(:,549), t3x128(:,:,300))
  call heltable([8,16,128], n3(:,550), t3x128(:,:,301))
  call heltable([8,16,128], n3(:,551), t3x128(:,:,302))
  call heltable([8,16,128], n3(:,552), t3x128(:,:,303))
  call heltable([8,16,128], n3(:,553), t3x128(:,:,304))
  call heltable([8,16,128], n3(:,554), t3x128(:,:,305))
  call heltable([8,16,128], n3(:,555), t3x128(:,:,306))
  call heltable([8,16,128], n3(:,556), t3x128(:,:,307))
  call heltable([8,16,128], n3(:,557), t3x128(:,:,308))
  call heltable([8,16,128], n3(:,558), t3x128(:,:,309))
  call heltable([8,16,128], n3(:,559), t3x128(:,:,310))
  call heltable([8,16,128], n3(:,560), t3x128(:,:,311))
  call heltable([8,16,128], n3(:,561), t3x128(:,:,312))
  call heltable([8,16,128], n3(:,562), t3x128(:,:,313))
  call heltable([8,16,128], n3(:,563), t3x128(:,:,314))
  call heltable([8,16,128], n3(:,564), t3x128(:,:,315))
  call heltable([8,16,128], n3(:,565), t3x128(:,:,316))
  call heltable([8,16,128], n3(:,566), t3x128(:,:,317))
  call heltable([8,16,128], n3(:,567), t3x128(:,:,318))
  call heltable([8,16,128], n3(:,568), t3x128(:,:,319))
  call heltable([8,16,128], n3(:,569), t3x128(:,:,320))
  call heltable([8,16,128], n3(:,570), t3x128(:,:,321))
  call heltable([8,16,128], n3(:,571), t3x128(:,:,322))
  call heltable([8,16,128], n3(:,572), t3x128(:,:,323))
  call heltable([8,16,128], n3(:,573), t3x128(:,:,324))
  call heltable([8,16,128], n3(:,574), t3x128(:,:,325))
  call heltable([8,16,128], n3(:,575), t3x128(:,:,326))
  call heltable([8,16,128], n3(:,576), t3x128(:,:,327))
  call heltable([8,16,128], n3(:,577), t3x128(:,:,328))
  call heltable([8,16,128], n3(:,578), t3x128(:,:,329))
  call heltable([8,16,128], n3(:,579), t3x128(:,:,330))
  call heltable([8,16,128], n3(:,580), t3x128(:,:,331))
  call heltable([8,16,128], n3(:,581), t3x128(:,:,332))
  call heltable([8,16,128], n3(:,582), t3x128(:,:,333))
  call heltable([8,16,128], n3(:,583), t3x128(:,:,334))
  call heltable([8,16,128], n3(:,584), t3x128(:,:,335))
  call heltable([8,16,128], n3(:,585), t3x128(:,:,336))
  call heltable([8,16,128], n3(:,586), t3x128(:,:,337))
  call heltable([8,16,128], n3(:,587), t3x128(:,:,338))
  call heltable([8,16,128], n3(:,588), t3x128(:,:,339))
  call heltable([8,16,128], n3(:,589), t3x128(:,:,340))
  call heltable([8,16,128], n3(:,590), t3x128(:,:,341))
  call heltable([8,16,128], n3(:,591), t3x128(:,:,342))
  call heltable([8,16,128], n3(:,592), t3x128(:,:,343))
  call heltable([8,16,128], n3(:,593), t3x128(:,:,344))
  call heltable([8,16,128], n3(:,594), t3x128(:,:,345))
  call heltable([8,16,128], n3(:,595), t3x128(:,:,346))
  call heltable([8,16,128], n3(:,596), t3x128(:,:,347))
  call heltable([8,16,128], n3(:,597), t3x128(:,:,348))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_pplllla_eeexexbbxa_1
