
module ol_vamp_1_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_ew_nenexnmnmxddx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_ew_nenexnmnmxddx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_ew_nenexnmnmxddx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_nenexnmnmxddx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,4,1,2,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,1),heltab2x64(:,:,1))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,2,1,4,8,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZd,m3h2x32(:,2),heltab2x64(:,:,2))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,8,1,2,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,2,1,8,4,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,4),heltab2x64(:,:,4))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,2,1,8,4,16],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,8,4,2,1,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,4,2,1,16],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,8,2,1,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,1,2,4,8,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,9),heltab2x64(:,:,9))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,1,2,8,4,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(10),ngZd,m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_ZA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),ngZn,m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(1),n2h16(1))
  call Hloop_ZA_Q(ntryL,G0H32(2),ex2(:),G0H16(1),ngZn,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(2),n2h16(2))
  call Hloop_ZQ_A(ntryL,G0H32(3),ex3(:),G0H16(1),ngZn,m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(3),n2h16(3))
  call Hloop_ZA_Q(ntryL,G0H32(4),ex2(:),G0H16(1),ngZn,m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(4),n2h16(4))
  call Hloop_WA_Q(ntryL,G0H32(5),ex2(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(5),n2h16(5))
  call Hloop_ZA_Q(ntryL,G0H32(6),ex4(:),G0H16(1),ngZn,m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(6),n2h16(6))
  call Hloop_WA_Q(ntryL,G0H32(7),ex4(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(7),n2h16(7))
  call Hloop_ZQ_A(ntryL,G0H32(8),ex3(:),G0H16(1),ngZn,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(8),n2h16(8))
  call Hloop_ZQ_A(ntryL,G0H32(9),ex1(:),G0H16(1),ngZn,m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(9),n2h16(9))
  call Hloop_ZQ_A(ntryL,G0H32(10),ex1(:),G0H16(1),ngZn,m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(10),n2h16(10))
  call Hloop_AQ_Z(ntryL,G1H16(1),ex3(:),G1H8(1),ngZn,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H16(2),ex1(:),G1H8(2),ngZn,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_QA_Z(ntryL,G1H16(3),ex4(:),G1H8(3),ngZn,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex1(:),G1H8(4),ngZn,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_W(ntryL,G1H16(5),ex1(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_Z(ntryL,G1H16(6),ex3(:),G1H8(6),ngZn,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_W(ntryL,G1H16(7),ex3(:),G1H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_QA_Z(ntryL,G1H16(8),ex4(:),G1H8(8),ngZn,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_QA_Z(ntryL,G1H16(9),ex2(:),G1H8(9),ngZn,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_QA_Z(ntryL,G1H16(10),ex2(:),G1H8(10),ngZn,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(1),n2h4(1))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex3(:),G1H4(1),ngZn,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(2),n2h4(2))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngZn,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(3),n2h4(3))
  call Hloop_ZA_Q(ntryL,G1H8(4),ex4(:),G1H4(1),ngZn,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(4),n2h4(4))
  call Hloop_WA_Q(ntryL,G1H8(5),ex4(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(5),n2h4(5))
  call Hloop_ZA_Q(ntryL,G1H8(6),ex2(:),G1H4(1),ngZn,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(6),n2h4(6))
  call Hloop_WA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(7),n2h4(7))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),ngZn,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(8),n2h4(8))
  call Hloop_ZQ_A(ntryL,G1H8(9),ex3(:),G1H4(1),ngZn,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(9),n2h4(9))
  call Hloop_ZA_Q(ntryL,G1H8(10),ex4(:),G1H4(1),ngZn,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(10),n2h4(10))
  call Hloop_QA_Z(ntryL,G2H4(1),ex2(:),G2H2(1),ngZn,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_Z(ntryL,G2H4(2),ex4(:),G2H2(2),ngZn,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_Z(ntryL,G2H4(3),ex2(:),G2H2(3),ngZn,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H4(4),ex3(:),G2H2(4),ngZn,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_W(ntryL,G2H4(5),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_Z(ntryL,G2H4(6),ex1(:),G2H2(6),ngZn,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_W(ntryL,G2H4(7),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_Z(ntryL,G2H4(8),ex1(:),G2H2(8),ngZn,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_Z(ntryL,G2H4(9),ex4(:),G2H2(9),ngZn,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_Z(ntryL,G2H4(10),ex3(:),G2H2(10),ngZn,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(2),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(3),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(4),mass5set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(4),mass5set(:,2),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(5),mass5set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(5),mass5set(:,2),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(6),mass5set(:,1),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(7),mass5set(:,1),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(8),mass5set(:,1),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),ngZd,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),ngZd,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(2),n2h1(2))
  call Hloop_ZQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),ngZd,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(3))
  call Hloop_ZQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),ngZd,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(4),n2h1(4))
  call Hloop_ZQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),ngZd,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),ngZd,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(6),n2h1(6))
  call Hloop_ZQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),ngZd,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(7))
  call Hloop_ZQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),ngZd,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(8),n2h1(8))
  call Hloop_WQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(9))
  call Hloop_WQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(10))
  call Hloop_ZQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),ngZd,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(11))
  call Hloop_ZQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),ngZd,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(12),n2h1(12))
  call Hloop_WQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_WQ_A(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(14),n2h1(14))
  call Hloop_ZQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),ngZd,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(15))
  call Hloop_ZQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),ngZd,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(16),n2h1(16))
  call Hloop_ZQ_A(ntryL,G1H2(49),ex5(:),G1H1(1),ngZd,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(17))
  call Hloop_ZQ_A(ntryL,G1H2(50),ex5(:),G1H1(1),ngZd,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(18),n2h1(18))
  call Hloop_ZQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),ngZd,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(19))
  call Hloop_ZQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),ngZd,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(20),n2h1(20))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(5),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(6),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(7),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(8),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,3,16,4,8],[0,0,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,3,16,4,8],[0,0,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,3,8,4,16],[nMW,nMW,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,3,16,8,4],[0,0,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,8,4,3,16],[nMW,0,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,8,3,4,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,8,3,4,16],[nMW,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,17),heltab2x64(:,:,17))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,4,3,8,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,2,1,16,12],[nMZ,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,2,1,16,12],[nMW,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,12,2,1,16],[nMW,nMW,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,1,2,16,12],[nMZ,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZd,m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,2,1,12,16],[nMW,0,nMW,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,2,12,1,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(11),ngZd,m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,2,12,1,16],[nMW,0,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,1,12,2,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZd,m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[48,4,1,2,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,1),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(1),n2h16(11))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[48,4,2,1,8],[0,nMW,0,nMW,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(2),n2h16(12))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[48,4,2,1,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,3),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(3),n2h16(13))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[48,4,2,1,8],[0,nMW,0,nMW,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZl,m3h4x16(:,4),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(4),n2h16(14))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[48,2,1,8,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(5),m3h4x16(:,5),heltab2x64(:,:,31))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[48,2,1,8,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(6),m3h4x16(:,6),heltab2x64(:,:,32))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[48,1,2,4,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(7),m3h4x16(:,7),heltab2x64(:,:,33))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[48,1,2,4,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(8),m3h4x16(:,8),heltab2x64(:,:,34))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[48,1,4,8,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,9),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(9),n2h16(15))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[48,1,8,4,2],[0,nMW,0,nMW,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,10),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(10),n2h16(16))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[48,1,8,4,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,11),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(11),n2h16(17))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[48,1,8,4,2],[0,nMW,0,nMW,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZl,m3h4x16(:,12),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(12),n2h16(18))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(10)])
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,1),G1H8(1),ngZd,m3h4x8(:,1),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(1),n2h8(1))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,1),G1H8(2),ngZu,m3h4x8(:,2),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(2),35,0,G2H8(2),n2h8(2))
  call Hloop_UW_V(ntryL,G0H32(3),32,wf4(:,1),3,G1H8(3),m3h4x8(:,3),heltab2x32(:,:,13))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,1),G1H8(4),ngZd,m3h4x8(:,4),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(4),35,0,G2H8(3),n2h8(3))
  call Hloop_WA_Q(ntryL,G0H32(5),ex4(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(2),n2h16(19))
  call Hloop_ZA_Q(ntryL,G0H32(6),ex4(:),G0H16(1),ngZn,m3h2x16(:,12),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(5),n2h16(20))
  call Hloop_WA_Q(ntryL,G0H32(7),ex4(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(7),n2h16(21))
  call Hloop_ZQ_A(ntryL,G0H32(8),ex3(:),G0H16(1),ngZn,m3h2x16(:,14),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(10),n2h16(22))
  call Hloop_ZA_Q(ntryL,G0H32(9),ex2(:),G0H16(1),ngZn,m3h2x16(:,15),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(13),n2h16(23))
  call Hloop_WA_Q(ntryL,G0H32(10),ex2(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(14),n2h16(24))
  call Hloop_UW_V(ntryL,G0H32(1),32,wf4(:,2),12,G1H8(5),m3h4x8(:,5),heltab2x32(:,:,21))
  call Hloop_ZQ_A(ntryL,G0H32(2),ex1(:),G0H16(1),ngZn,m3h2x16(:,17),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(15),n2h16(25))
  call Hloop_WA_Q(ntryL,G0H32(4),ex2(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(16),n2h16(26))
  call Hloop_ZA_Q(ntryL,G0H32(11),ex2(:),G0H16(1),ngZn,m3h2x16(:,19),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(17),n2h16(27))
  call Hloop_WA_Q(ntryL,G0H32(12),ex2(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(18),n2h16(28))
  call Hloop_ZQ_A(ntryL,G0H32(13),ex1(:),G0H16(1),ngZn,m3h2x16(:,21),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(19),n2h16(29))
  call Hloop_AQ_Z(ntryL,G1H16(1),ex3(:),G1H8(6),ngZn,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_W(ntryL,G1H16(4),ex3(:),G1H8(7),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex3(:),G1H8(8),ngZn,m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_WA_Q(ntryL,G1H16(6),ex2(:),G1H8(9),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(9),50,0,G2H8(4),n2h8(4))
  call Hloop_WQ_A(ntryL,G1H16(8),ex1(:),G1H8(10),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(10),49,0,G2H8(5),n2h8(5))
  call Hloop_AQ_Z(ntryL,G1H16(9),ex1(:),G1H8(1),ngZn,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_W(ntryL,G1H16(12),ex1(:),G1H8(2),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H16(11),ex1(:),G1H8(4),ngZn,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AQ_Z(ntryL,G2H8(1),ex5(:),G2H4(1),ngZd,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_W(ntryL,G2H8(2),ex5(:),G2H4(2),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_WA_Q(ntryL,G1H8(3),ex4(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(3),n2h4(11))
  call Hloop_AQ_Z(ntryL,G2H8(3),ex5(:),G2H4(4),ngZd,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_AQ_W(ntryL,G1H16(2),ex3(:),G1H8(9),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,1),G1H4(1),ngZn,m3h4x4(:,1),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(5),n2h4(12))
  call Hloop_AZ_Q(ntryL,G1H16(7),wf4(:,1),G1H4(1),ngZl,m3h4x4(:,2),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(6),n2h4(13))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,1),G1H4(1),ngZn,m3h4x4(:,3),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(7),n2h4(14))
  call Hloop_AQ_Z(ntryL,G1H16(13),ex1(:),G1H8(10),ngZn,m3h2x8(:,20),heltab2x16(:,:,23))
  call Hloop_AQ_W(ntryL,G1H16(14),ex1(:),G1H8(3),m3h2x8(:,21),heltab2x16(:,:,24))
  call Hloop_WA_Q(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(8),n2h4(15))
  call Hloop_QA_Z(ntryL,G1H16(15),ex2(:),G1H8(5),ngZn,m3h2x8(:,22),heltab2x16(:,:,25))
  call Hloop_AQ_W(ntryL,G1H16(16),ex1(:),G1H8(11),m3h2x8(:,23),heltab2x16(:,:,26))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,2),G1H4(1),ngZn,m3h4x4(:,4),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(9),n2h4(16))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,2),G1H4(1),ngZl,m3h4x4(:,5),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(10),n2h4(17))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,2),G1H4(1),ngZn,m3h4x4(:,6),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(11),n2h4(18))
  call Hloop_ZQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngZn,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(12),n2h4(19))
  call Hloop_WA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(13),n2h4(20))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),ngZn,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(14),n2h4(21))
  call Hloop_AQ_W(ntryL,G2H8(4),ex1(:),G2H4(15),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_W(ntryL,G2H8(5),ex2(:),G2H4(16),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex3(:),G1H4(1),ngZn,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(17),n2h4(22))
  call Hloop_WA_Q(ntryL,G1H8(2),ex4(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(18),n2h4(23))
  call Hloop_ZA_Q(ntryL,G1H8(4),ex4(:),G1H4(1),ngZn,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(19),n2h4(24))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(9),mass5set(:,3),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(9),mass5set(:,4),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hloop_AQ_W(ntryL,G2H4(3),ex3(:),G2H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(10),mass5set(:,3),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),4,4)
  call Hloop_UW_V(ntryL,G1H8(9),44,wf4(:,1),3,G2H2(2),m3h4x2(:,1),heltab2x8(:,:,24))
  call Hloop_AQ_Z(ntryL,G2H4(5),ex3(:),G2H2(3),ngZn,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_W(ntryL,G2H4(6),ex3(:),G2H2(4),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_Z(ntryL,G2H4(7),ex4(:),G2H2(5),ngZn,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_ZQ_A(ntryL,G1H8(10),ex5(:),G1H4(19),ngZd,m3h2x4(:,24),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(19),51,0,G2H4(1),n2h4(25))
  call Hloop_WQ_A(ntryL,G1H8(3),ex5(:),G1H4(19),m3h2x4(:,25),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(19),51,0,G2H4(2),n2h4(26))
  call Hloop_AQ_W(ntryL,G2H4(8),ex1(:),G2H2(6),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_ZQ_A(ntryL,G1H8(5),ex5(:),G1H4(19),ngZd,m3h2x4(:,26),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(19),51,0,G2H4(3),n2h4(27))
  call Hloop_UW_V(ntryL,G1H8(11),35,wf4(:,2),12,G2H2(7),m3h4x2(:,2),heltab2x8(:,:,28))
  call Hloop_AQ_Z(ntryL,G2H4(9),ex1(:),G2H2(8),ngZn,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_W(ntryL,G2H4(10),ex1(:),G2H2(9),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_Z(ntryL,G2H4(11),ex2(:),G2H2(10),ngZn,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_Z(ntryL,G2H4(12),ex2(:),G2H2(11),ngZn,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_W(ntryL,G2H4(13),ex1(:),G2H2(12),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_Z(ntryL,G2H4(14),ex1(:),G2H2(13),ngZn,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(11),mass5set(:,5),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),4,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(12),mass5set(:,5),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hloop_QA_Z(ntryL,G2H4(17),ex4(:),G2H2(14),ngZn,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_W(ntryL,G2H4(18),ex3(:),G2H2(15),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_Z(ntryL,G2H4(19),ex3(:),G2H2(16),ngZn,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_ZQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),ngZn,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(17),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(2),ex4(:),G1H2(2),ngZn,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_ZQ_A(ntryL,G1H4(5),ex3(:),G1H2(7),ngZn,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(7),55,0,G2H2(18),n2h2(2))
  call Hloop_ZQ_A(ntryL,G1H4(6),ex3(:),G1H2(8),ngZn,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(8),55,0,G2H2(19),n2h2(3))
  call Hloop_WQ_A(ntryL,G1H4(7),ex3(:),G1H2(13),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(13),55,0,G2H2(20),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(8),ex4(:),G1H2(14),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_WQ_A(ntryL,G1H4(11),ex3(:),G1H2(19),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(21),n2h2(5))
  call Hloop_WQ_A(ntryL,G1H4(12),ex3(:),G1H2(20),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(20),55,0,G2H2(22),n2h2(6))
  call Hloop_ZA_Q(ntryL,G1H4(13),ex4(:),G1H2(25),ngZn,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(25),59,0,G2H2(23),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(14),ex3(:),G1H2(26),ngZn,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_ZA_Q(ntryL,G1H4(17),ex4(:),G1H2(31),ngZn,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(31),59,0,G2H2(24),n2h2(8))
  call Hloop_ZA_Q(ntryL,G1H4(18),ex4(:),G1H2(32),ngZn,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(32),59,0,G2H2(25),n2h2(9))
  call Hloop_WA_Q(ntryL,G1H4(19),ex4(:),G1H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(37),59,0,G2H2(26),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(20),ex3(:),G1H2(38),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_WA_Q(ntryL,G1H4(23),ex4(:),G1H2(43),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(43),59,0,G2H2(27),n2h2(11))
  call Hloop_WA_Q(ntryL,G1H4(24),ex4(:),G1H2(44),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(44),59,0,G2H2(28),n2h2(12))
  call Hloop_WQ_A(ntryL,G1H4(25),ex3(:),G1H2(49),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(49),55,0,G2H2(29),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(26),ex4(:),G1H2(50),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_WQ_A(ntryL,G1H4(29),ex3(:),G1H2(55),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(55),55,0,G2H2(30),n2h2(14))
  call Hloop_WQ_A(ntryL,G1H4(30),ex3(:),G1H2(56),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(56),55,0,G2H2(31),n2h2(15))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(52),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(58),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(60),[G1H2(54)])
  call Hloop_ZQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),ngZd,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(21))
  call Hloop_ZQ_A(ntryL,G1H2(16),ex5(:),G1H1(1),ngZd,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(22))
  call Hloop_ZQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),ngZd,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(23))
  call Hloop_ZQ_A(ntryL,G1H2(36),ex5(:),G1H1(1),ngZd,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(24))
  call Hloop_ZQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),ngZd,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(25))
  call Hloop_ZQ_A(ntryL,G1H2(52),ex5(:),G1H1(1),ngZd,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(26))
  call Hloop_ZQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),ngZd,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(27))
  call Hloop_ZQ_A(ntryL,G1H2(24),ex5(:),G1H1(1),ngZd,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(28))
  call Hloop_ZQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),ngZd,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(29))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),ngZd,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(30))
  call Hloop_ZQ_A(ntryL,G1H2(48),ex5(:),G1H1(1),ngZd,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(31))
  call Hloop_ZQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),ngZd,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(32))
  call Hloop_ZQ_A(ntryL,G1H2(58),ex5(:),G1H1(1),ngZd,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(33))
  call Hloop_ZQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),ngZd,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(34))
  call Hloop_WQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(35))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(13),mass5set(:,6),  & 
G1H2(1),G1H2(7),G1H2(8),G1H2(13),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(7),16,2)
  call Hloop_WQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(26),n2h1(36))
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(14),mass5set(:,7),  & 
G1H2(25),G1H2(31),G1H2(32),G1H2(37),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(31),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),ngZd,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(37))
  call Hloop_ZQ_A(ntryL,G1H2(46),ex5(:),G1H1(1),ngZd,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(28),n2h1(38))
  call Hloop_ZQ_A(ntryL,G1H2(35),ex5(:),G1H1(1),ngZd,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(39))
  call Hloop_WQ_A(ntryL,G1H2(39),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(40))
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(15),mass5set(:,6),  & 
G1H2(49),G1H2(55),G1H2(56),G1H2(4),G1H2(6),G1H2(10),2)
  call HG1shiftOLR(G1H2(55),16,2)
  call Hloop_WQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(41))
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(16),mass5set(:,7),  & 
G1H2(12),G1H2(18),G1H2(22),G1H2(28),G1H2(30),G1H2(34),2)
  call HG1shiftOLR(G1H2(18),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),ngZd,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(42))
  call Hloop_ZQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),ngZd,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(43))
  call Hloop_ZQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),ngZd,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(44))
  call Hloop_ZQ_A(ntryL,G1H2(53),ex5(:),G1H1(1),ngZd,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(45))
  call Hloop_ZQ_A(ntryL,G1H2(60),ex5(:),G1H1(1),ngZd,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(46))
  call Hloop_ZQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),ngZd,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(47))
  call Hloop_ZQ_A(ntryL,G1H2(59),ex5(:),G1H1(1),ngZd,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(48))
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(17),mass5set(:,8),  & 
G1H2(40),G1H2(42),G1H2(54),G1H2(3),G1H2(16),G1H2(5),2)
  call HG1shiftOLR(G1H2(42),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(17),mass5set(:,9),  & 
G1H2(36),G1H2(9),G1H2(52),G1H2(11),G1H2(24),G1H2(15),2)
  call HG1shiftOLR(G1H2(9),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(18),mass5set(:,8),  & 
G1H2(17),G1H2(48),G1H2(21),G1H2(58),G1H2(23),G1H2(27),2)
  call HG1shiftOLR(G1H2(48),16,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(19),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(2),12,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(19),mass5set(:,2),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(12),12,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(20),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(20),12,4)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(21),mass5set(:,8),  & 
G1H2(29),G1H2(33),G1H2(46),G1H2(35),G1H2(39),G1H2(41),2)
  call HG1shiftOLR(G1H2(33),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(21),mass5set(:,9),  & 
G1H2(45),G1H2(47),G1H2(51),G1H2(53),G1H2(60),G1H2(57),2)
  call HG1shiftOLR(G1H2(47),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(22),mass5set(:,8),  & 
G1H2(59),G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),2)
  call HG1shiftOLR(G1H2(61),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(23),mass5set(:,10),  & 
G1H2(66),G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),2)
  call HG1shiftOLR(G1H2(67),8,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(24),mass5set(:,11),  & 
G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),2)
  call HG1shiftOLR(G1H2(73),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(24),mass5set(:,10),  & 
G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),2)
  call HG1shiftOLR(G1H2(79),8,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(25),mass5set(:,10),  & 
G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),2)
  call HG1shiftOLR(G1H2(85),2,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(26),mass5set(:,11),  & 
G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(91),2,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(26),mass5set(:,10),  & 
G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),2)
  call HG1shiftOLR(G1H2(97),2,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(39),ngZn,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(40),ngZn,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(41),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(42),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(43),ngZn,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(25),ex3(:),G2tensor(44),ngZn,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(45),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(28),ex3(:),G2tensor(46),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(29),ex4(:),G2tensor(47),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(31),ex4(:),G2tensor(48),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hloop_WQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(49))
  call Hloop_WQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(50),n2h1(50))
  call Hloop_WQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(51))
  call Hloop_WQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(52))
  call Hloop_WQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(53),n2h1(53))
  call Hloop_WQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(54))
  call Hloop_WQ_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(55))
  call Hloop_WQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(56),n2h1(56))
  call Hloop_WQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(57))
  call Hloop_WQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(58))
  call Hloop_WQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(59),n2h1(59))
  call Hloop_WQ_A(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(60))
  call Hloop_ZQ_A(ntryL,G1H2(40),ex5(:),G1H1(1),ngZd,m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(61))
  call Hloop_ZQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),ngZd,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(62),n2h1(62))
  call Hloop_ZQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),ngZd,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(63))
  call Hloop_WQ_A(ntryL,G1H2(36),ex5(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(64))
  call Hloop_WQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(65),n2h1(65))
  call Hloop_WQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(66))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),ngZd,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(67))
  call Hloop_ZQ_A(ntryL,G1H2(48),ex5(:),G1H1(1),ngZd,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(68),n2h1(68))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),ngZd,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(69))
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,1),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(70))
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,2),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(71),n2h1(71))
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,3),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(72))
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,4),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(73))
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,5),heltab2x4(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(74),n2h1(74))
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,6),heltab2x4(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(75))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,7),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(76))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,8),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(77),n2h1(77))
  call Hloop_QZ_A(ntryL,G1H4(26),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,9),heltab2x4(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(78))
  call Hloop_ZQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),ngZd,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(79))
  call Hloop_ZQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),ngZd,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(80),n2h1(80))
  call Hloop_ZQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),ngZd,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(81))
  call Hloop_WQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(82),n2h1(82))
  call Hloop_WQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(83),n2h1(83))
  call Hloop_WQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(84))
  call Hloop_ZQ_A(ntryL,G1H2(59),ex5(:),G1H1(1),ngZd,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(85))
  call Hloop_ZQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),ngZd,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(86),n2h1(86))
  call Hloop_ZQ_A(ntryL,G1H2(65),ex5(:),G1H1(1),ngZd,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(87))
  call Hloop_ZA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),ngZn,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(88),n2h1(88))
  call Hloop_ZA_Q(ntryL,G1H2(67),ex4(:),G1H1(1),ngZn,m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(89),n2h1(89))
  call Hloop_ZA_Q(ntryL,G1H2(71),ex4(:),G1H1(1),ngZn,m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(90))
  call Hloop_WA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(91))
  call Hloop_WA_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(92),n2h1(92))
  call Hloop_WA_Q(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(93))
  call Hloop_ZA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),ngZn,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(94),n2h1(94))
  call Hloop_ZA_Q(ntryL,G1H2(79),ex4(:),G1H1(1),ngZn,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(95),n2h1(95))
  call Hloop_ZA_Q(ntryL,G1H2(83),ex4(:),G1H1(1),ngZn,m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(96))
  call Hloop_ZA_Q(ntryL,G1H2(84),ex2(:),G1H1(1),ngZn,m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(97))
  call Hloop_ZA_Q(ntryL,G1H2(85),ex2(:),G1H1(1),ngZn,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(98),n2h1(98))
  call Hloop_ZA_Q(ntryL,G1H2(89),ex2(:),G1H1(1),ngZn,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(99))
  call Hloop_WA_Q(ntryL,G1H2(90),ex2(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(100),n2h1(100))
  call Hloop_WA_Q(ntryL,G1H2(91),ex2(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(101),n2h1(101))
  call Hloop_WA_Q(ntryL,G1H2(95),ex2(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(102))
  call Hloop_ZA_Q(ntryL,G1H2(96),ex2(:),G1H1(1),ngZn,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(103))
  call Hloop_ZA_Q(ntryL,G1H2(97),ex2(:),G1H1(1),ngZn,m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(104),n2h1(104))
  call Hloop_ZA_Q(ntryL,G1H2(101),ex2(:),G1H1(1),ngZn,m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(105))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(10),G1tensor(26)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(16),G1tensor(4)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(36),G1tensor(6)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(52),G1tensor(10)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(24),G1tensor(12)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(48),G1tensor(18)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(58),G1tensor(22)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(46),G1tensor(34)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(60),G1tensor(54)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(59)])
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(27),mass5set(:,12),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(28),mass5set(:,12),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(2),G1tensor(8))
  call G_TensorShift(G1tensor(43),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(29),mass5set(:,12),  & 
G1tensor(14),G1tensor(20),G1tensor(26),G1tensor(32),G1tensor(38),G1tensor(44))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(11),mass5set(:,12),  & 
G1tensor(50),G1tensor(56),G1tensor(3),G1tensor(16),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(11),mass5set(:,5),  & 
G1tensor(36),G1tensor(6),G1tensor(9),G1tensor(52),G1tensor(10),G1tensor(11))
  call G_TensorShift(G1tensor(6),4)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(30),mass5set(:,12),  & 
G1tensor(24),G1tensor(12),G1tensor(15),G1tensor(17),G1tensor(48),G1tensor(18))
  call G_TensorShift(G1tensor(12),1)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(30),mass5set(:,5),  & 
G1tensor(21),G1tensor(58),G1tensor(22),G1tensor(23),G1tensor(27),G1tensor(28))
  call G_TensorShift(G1tensor(58),1)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(31),mass5set(:,12),  & 
G1tensor(29),G1tensor(30),G1tensor(33),G1tensor(46),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(30),1)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(12),mass5set(:,12),  & 
G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42),G1tensor(45),G1tensor(47))
  call G_TensorShift(G1tensor(40),8)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(32),mass5set(:,12),  & 
G1tensor(51),G1tensor(53),G1tensor(60),G1tensor(54),G1tensor(57),G1tensor(59))
  call G_TensorShift(G1tensor(53),4)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(33),mass5set(:,10),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(34),mass5set(:,13),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(35),mass5set(:,8),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(16),mass5set(:,14),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(36),mass5set(:,10),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(37),mass5set(:,13),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(38),mass5set(:,8),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(14),mass5set(:,14),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(39),mass5set(:,10),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(40),mass5set(:,8),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(41),mass5set(:,14),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(42),mass5set(:,10),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(13),mass5set(:,13),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(43),mass5set(:,8),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(42),mass5set(:,11),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(13),mass5set(:,6),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(43),mass5set(:,9),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(14),mass5set(:,7),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(44),mass5set(:,10),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(15),mass5set(:,13),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(45),mass5set(:,8),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(44),mass5set(:,11),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(15),mass5set(:,6),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(45),mass5set(:,9),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(16),mass5set(:,7),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(46),mass5set(:,10),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(47),mass5set(:,8),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(48),mass5set(:,10),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(49),mass5set(:,8),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(50),mass5set(:,14),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(51),mass5set(:,10),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(52),mass5set(:,8),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(9),mass5set(:,3),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),8)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(9),mass5set(:,4),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(10),mass5set(:,3),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),4)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(12),mass5set(:,5),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),8)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(17),mass5set(:,8),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(17),mass5set(:,9),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(18),mass5set(:,8),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),16)
  call Hotf_5pt_reduction_last(G2tensor(70),RedSet_5(19),mass5set(:,1),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),12)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(19),mass5set(:,2),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),12)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(20),mass5set(:,1),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),12)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(21),mass5set(:,8),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),16)
  call Hotf_5pt_reduction_last(G2tensor(82),RedSet_5(21),mass5set(:,9),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(22),mass5set(:,8),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),16)
  call Hotf_5pt_reduction_last(G2tensor(88),RedSet_5(23),mass5set(:,10),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(24),mass5set(:,11),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),8)
  call Hotf_5pt_reduction_last(G2tensor(94),RedSet_5(24),mass5set(:,10),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),8)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(25),mass5set(:,10),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),2)
  call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(26),mass5set(:,11),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),2)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(26),mass5set(:,10),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),2)
  call ol_merge_tensors(T1sum(11),[G1tensor(1)])
  call ol_merge_tensors(T1sum(12),[G1tensor(37)])
  call ol_merge_tensors(T1sum(13),[G1tensor(14)])
  call ol_merge_tensors(T1sum(14),[G1tensor(50)])
  call ol_merge_tensors(T1sum(15),[G1tensor(36)])
  call ol_merge_tensors(T1sum(16),[G1tensor(24)])
  call ol_merge_tensors(T1sum(17),[G1tensor(21)])
  call ol_merge_tensors(T1sum(18),[G1tensor(29)])
  call ol_merge_tensors(T1sum(19),[G1tensor(39)])
  call ol_merge_tensors(T1sum(20),[G1tensor(51)])
  call ol_merge_tensors(T1sum(21),[G1tensor(61)])
  call ol_merge_tensors(T1sum(22),[G1tensor(67)])
  call ol_merge_tensors(T1sum(23),[G1tensor(73)])
  call ol_merge_tensors(T1sum(24),[G1tensor(79)])
  call ol_merge_tensors(T1sum(25),[G1tensor(85)])
  call ol_merge_tensors(T1sum(26),[G1tensor(91)])
  call ol_merge_tensors(T1sum(27),[G1tensor(97)])
  call ol_merge_tensors(T1sum(28),[G1tensor(103)])
  call ol_merge_tensors(T1sum(29),[G1tensor(109)])
  call ol_merge_tensors(T1sum(30),[G1tensor(115)])
  call ol_merge_tensors(T1sum(31),[G1tensor(121)])
  call ol_merge_tensors(T1sum(32),[G1tensor(127)])
  call ol_merge_tensors(T1sum(33),[G1tensor(133)])
  call ol_merge_tensors(T1sum(34),[G1tensor(139)])
  call ol_merge_tensors(T1sum(35),[G1tensor(145)])
  call ol_merge_tensors(T1sum(36),[G1tensor(151)])
  call ol_merge_tensors(T1sum(37),[G1tensor(157)])
  call ol_merge_tensors(T1sum(38),[G1tensor(163)])
  call ol_merge_tensors(T1sum(39),[G1tensor(169)])
  call ol_merge_tensors(T1sum(40),[G1tensor(175)])
  call ol_merge_tensors(T1sum(41),[G1tensor(181)])
  call ol_merge_tensors(T1sum(42),[G1tensor(187)])
  call ol_merge_tensors(T1sum(43),[G1tensor(193)])
  call ol_merge_tensors(T1sum(44),[G1tensor(199)])
  call ol_merge_tensors(T1sum(45),[G1tensor(205)])
  call ol_merge_tensors(T1sum(46),[G1tensor(211)])
  call ol_merge_tensors(T1sum(47),[G1tensor(217)])
  call ol_merge_tensors(T1sum(48),[G1tensor(223)])
  call ol_merge_tensors(T1sum(49),[G1tensor(229)])
  call ol_merge_tensors(T1sum(50),[G1tensor(235)])
  call ol_merge_tensors(T1sum(51),[G1tensor(241)])
  call ol_merge_tensors(T1sum(52),[G1tensor(247)])
  call ol_merge_tensors(T1sum(53),[G1tensor(253)])
  call ol_merge_tensors(T1sum(54),[G1tensor(259)])
  call ol_merge_tensors(T1sum(55),[G1tensor(265)])
  call ol_merge_tensors(T1sum(56),[G1tensor(271)])
  call ol_merge_tensors(T1sum(57),[G1tensor(277)])
  call ol_merge_tensors(T1sum(58),[G1tensor(283)])
  call ol_merge_tensors(T1sum(59),[G1tensor(289)])
  call ol_merge_tensors(T1sum(60),[G1tensor(295)])
  call ol_merge_tensors(T1sum(61),[G1tensor(301)])
  call ol_merge_tensors(T1sum(62),[G1tensor(307)])
  call ol_merge_tensors(T1sum(63),[G1tensor(313)])
  call ol_merge_tensors(T1sum(64),[G1tensor(319)])
  call ol_merge_tensors(T1sum(65),[G1tensor(325)])
  call ol_merge_tensors(T1sum(66),[G1tensor(331)])
  call ol_merge_tensors(T1sum(67),[G1tensor(337)])
  call ol_merge_tensors(T1sum(68),[G1tensor(343)])
  call ol_merge_tensors(T1sum(69),[G1tensor(349)])
  call ol_merge_tensors(T1sum(70),[G1tensor(355)])
  call ol_merge_tensors(T1sum(71),[G1tensor(361)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,27),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(1),n2h32(4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,12,3,16],[0,0,0,nMZ],4,2,wf4(:,2),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),ngZd,m3h2x32(:,28),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(2),n2h32(5))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,12,3,16],[0,0,0,nMW],4,2,wf4(:,2),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,29),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(3),n2h32(6))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,12,3,16],[nMZ,nMH,nMZ,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZd,m3h2x32(:,30),heltab2x64(:,:,42))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,12,3,16],[nMW,nMW,nMW,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,31),heltab2x64(:,:,43))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,12,3,16],[nMW,nMW,nMW,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,32),heltab2x64(:,:,44))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,33),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(4),n2h32(7))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,3,12,16],[0,0,0,nMZ],4,2,wf4(:,1),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,34),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(8))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,3,12,16],[0,0,0,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,35),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(6),n2h32(9))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,3,12,16],[nMZ,nMH,nMZ,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,36),heltab2x64(:,:,48))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,3,12,16],[nMW,nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,37),heltab2x64(:,:,49))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,3,12,16],[nMW,nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,38),heltab2x64(:,:,50))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,3,16,12],[0,0,nMW,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,39),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(7),n2h32(10))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,3,16,12],[nMW,nMW,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,40),heltab2x64(:,:,52))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[48,3,4,8],[0,0,nMW,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,13),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(1),n2h16(30))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[48,3,4,8],[0,0,nMZ,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,14),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(4),n2h16(31))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[48,3,4,8],[0,0,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZl,m3h4x16(:,15),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(3),n2h16(32))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,16),heltab2x64(:,:,56))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[48,3,4,8],[nMH,nMZ,0,nMZ],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(2),m3h4x16(:,17),heltab2x64(:,:,57))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(3),m3h4x16(:,18),heltab2x64(:,:,58))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(6),m3h4x16(:,19),heltab2x64(:,:,59))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(8),m3h4x16(:,20),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[48,3,8,4],[0,0,nMW,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,21),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(4),48,0,G1H16(9),n2h16(33))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[48,3,8,4],[0,0,nMZ,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(4),ngZn,m3h4x16(:,22),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(4),48,0,G1H16(12),n2h16(34))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[48,3,8,4],[0,0,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(4),ngZl,m3h4x16(:,23),heltab2x64(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(4),48,0,G1H16(11),n2h16(35))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,24),heltab2x64(:,:,64))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[48,3,8,4],[nMH,nMZ,0,nMZ],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(5),m3h4x16(:,25),heltab2x64(:,:,65))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(6),m3h4x16(:,26),heltab2x64(:,:,66))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(2),m3h4x16(:,27),heltab2x64(:,:,67))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(5),m3h4x16(:,28),heltab2x64(:,:,68))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[48,4,3,8],[nMW,0,0,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(7),m3h4x16(:,29),heltab2x64(:,:,69))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[48,4,3,8],[nMW,0,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(10),m3h4x16(:,30),heltab2x64(:,:,70))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[48,4,3,8],[0,nMW,nMW,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,31),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(7),48,0,G1H16(13),n2h16(36))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[48,4,3,8],[0,nMW,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZl,m3h4x16(:,32),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G0H16(7),48,0,G1H16(14),n2h16(37))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,7,8,16],[nMZ,0,nMZ,0],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(5),ngZd,m3h2x32(:,41),heltab2x64(:,:,73))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,8,7,16],[nMZ,0,nMZ,0],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,42),heltab2x64(:,:,74))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,8,7,16],[nMW,0,nMW,0],4,1,wf8(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,43),heltab2x64(:,:,75))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,11,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,32))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,44),heltab2x64(:,:,76))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,11,4,16],[nMW,0,nMW,0],4,1,wf8(:,32))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,45),heltab2x64(:,:,77))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,4,11,16],[nMZ,0,nMZ,0],4,1,wf8(:,32))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZd,m3h2x32(:,46),heltab2x64(:,:,78))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,4,8,19],[nMZ,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(14),ngZd,m3h2x32(:,47),heltab2x64(:,:,79))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,8,4,19],[nMZ,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZd,m3h2x32(:,48),heltab2x64(:,:,80))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,8,4,19],[nMW,0,nMW,0],4,1,wf8(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,49),heltab2x64(:,:,81))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[35,8,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,22))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,22),G0H8(1),ngZd,m3h8x8(:,1),heltab2x64(:,:,82))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[35,8,4,16],[nMW,0,nMW,0],4,1,wf8(:,22))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,22),G0H8(2),m3h8x8(:,2),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[35,4,8,16],[nMZ,0,nMZ,0],4,1,wf8(:,22))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,22),G0H8(3),ngZd,m3h8x8(:,3),heltab2x64(:,:,84))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[48,2,1,12],[0,nMW,0,0],4,2,wf4(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,33),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(7),48,0,G1H16(15),n2h16(38))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[48,2,1,12],[0,nMZ,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZn,m3h4x16(:,34),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G0H16(7),48,0,G1H16(16),n2h16(39))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[48,2,1,12],[0,nMW,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZl,m3h4x16(:,35),heltab2x64(:,:,87))
  call Hloop_Q_A(ntryL,G0H16(7),48,0,G1H16(17),n2h16(40))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,36),heltab2x64(:,:,88))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[48,2,1,12],[nMZ,0,nMZ,nMH],4,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(8),m3h4x16(:,37),heltab2x64(:,:,89))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(9),m3h4x16(:,38),heltab2x64(:,:,90))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(18),m3h4x16(:,39),heltab2x64(:,:,91))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(19),m3h4x16(:,40),heltab2x64(:,:,92))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[48,1,2,12],[0,nMW,0,0],4,2,wf4(:,5),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,41),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(10),48,0,G1H16(20),n2h16(41))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[48,1,2,12],[0,nMZ,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(10),ngZn,m3h4x16(:,42),heltab2x64(:,:,94))
  call Hloop_A_Q(ntryL,G0H16(10),48,0,G1H16(21),n2h16(42))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[48,1,2,12],[0,nMW,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(10),ngZl,m3h4x16(:,43),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(10),48,0,G1H16(22),n2h16(43))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,44),heltab2x64(:,:,96))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[48,1,2,12],[nMZ,0,nMZ,nMH],4,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(11),m3h4x16(:,45),heltab2x64(:,:,97))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(12),m3h4x16(:,46),heltab2x64(:,:,98))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(23),m3h4x16(:,47),heltab2x64(:,:,99))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(24),m3h4x16(:,48),heltab2x64(:,:,100))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[48,1,12,2],[nMW,0,0,nMW],4,2,wf4(:,5),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(25),m3h4x16(:,49),heltab2x64(:,:,101))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[48,1,12,2],[nMW,0,0,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(26),m3h4x16(:,50),heltab2x64(:,:,102))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[48,1,12,2],[0,nMW,nMW,0],4,2,wf4(:,5),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(13),m3h4x16(:,51),heltab2x64(:,:,103))
  call Hloop_A_Q(ntryL,G0H16(13),48,0,G1H16(27),n2h16(44))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[48,1,12,2],[0,nMW,nMW,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(13),ngZl,m3h4x16(:,52),heltab2x64(:,:,104))
  call Hloop_A_Q(ntryL,G0H16(13),48,0,G1H16(28),n2h16(45))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,13,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(17),ngZd,m3h2x32(:,50),heltab2x64(:,:,105))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,2,13,16],[nMZ,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZd,m3h2x32(:,51),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,2,13,16],[nMW,0,nMW,0],4,1,wf8(:,15))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,52),heltab2x64(:,:,107))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,14,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,54))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(20),ngZd,m3h2x32(:,53),heltab2x64(:,:,108))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,14,1,16],[nMW,0,nMW,0],4,1,wf8(:,54))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,54),heltab2x64(:,:,109))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,1,14,16],[nMZ,0,nMZ,0],4,1,wf8(:,54))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(22),ngZd,m3h2x32(:,55),heltab2x64(:,:,110))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,1,2,28],[nMZ,0,nMZ,0],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(23),ngZd,m3h2x32(:,56),heltab2x64(:,:,111))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,2,1,28],[nMZ,0,nMZ,0],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(24),ngZd,m3h2x32(:,57),heltab2x64(:,:,112))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,2,1,28],[nMW,0,nMW,0],4,1,wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,58),heltab2x64(:,:,113))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[44,2,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,24))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,24),G0H8(4),ngZd,m3h8x8(:,4),heltab2x64(:,:,114))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[44,2,1,16],[nMW,0,nMW,0],4,1,wf8(:,24))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,24),G0H8(5),m3h8x8(:,5),heltab2x64(:,:,115))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[44,1,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,24))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,24),G0H8(6),ngZd,m3h8x8(:,6),heltab2x64(:,:,116))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[49,2,4,8],[0,nMZ,0,nMZ],4,1,wf8(:,18))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,18),G0H8(7),ngZn,m3h8x8(:,7),heltab2x64(:,:,117))
  call Hloop_Q_A(ntryL,G0H8(7),49,0,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[49,2,4,8],[0,nMW,0,nMW],4,1,wf8(:,18))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,18),G0H8(7),m3h8x8(:,8),heltab2x64(:,:,118))
  call Hloop_Q_A(ntryL,G0H8(7),49,0,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[49,2,8,4],[0,nMZ,0,nMZ],4,1,wf8(:,18))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,18),G0H8(7),ngZn,m3h8x8(:,9),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G0H8(7),49,0,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[50,1,4,8],[0,nMZ,0,nMZ],4,1,wf8(:,52))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,52),G0H8(7),ngZn,m3h8x8(:,10),heltab2x64(:,:,120))
  call Hloop_A_Q(ntryL,G0H8(7),50,0,G1H8(1),n2h8(9))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[50,1,8,4],[0,nMZ,0,nMZ],4,1,wf8(:,52))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,52),G0H8(7),ngZn,m3h8x8(:,11),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G0H8(7),50,0,G1H8(2),n2h8(10))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[50,1,8,4],[0,nMW,0,nMW],4,1,wf8(:,52))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,52),G0H8(7),m3h8x8(:,12),heltab2x64(:,:,122))
  call Hloop_A_Q(ntryL,G0H8(7),50,0,G1H8(4),n2h8(11))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[52,2,1,8],[nMZ,0,nMZ,0],4,1,wf8(:,12))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,12),G0H8(7),ngZn,m3h8x8(:,13),heltab2x64(:,:,123))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[52,2,1,8],[nMW,0,nMW,0],4,1,wf8(:,12))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,12),G0H8(8),m3h8x8(:,14),heltab2x64(:,:,124))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[52,1,2,8],[nMZ,0,nMZ,0],4,1,wf8(:,12))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,12),G0H8(9),ngZn,m3h8x8(:,15),heltab2x64(:,:,125))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[56,2,1,4],[nMZ,0,nMZ,0],4,1,wf8(:,35))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,35),G0H8(10),ngZn,m3h8x8(:,16),heltab2x64(:,:,126))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[56,1,2,4],[nMZ,0,nMZ,0],4,1,wf8(:,35))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,35),G0H8(11),ngZn,m3h8x8(:,17),heltab2x64(:,:,127))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[56,1,2,4],[nMW,0,nMW,0],4,1,wf8(:,35))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,35),G0H8(12),m3h8x8(:,18),heltab2x64(:,:,128))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(3),[G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(11),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(6),[G0H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(17),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(9),[G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(22),[G1H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(12),[G0H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(26),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(27)])
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,2),G1H8(9),ngZd,m3h4x8(:,6),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(9),44,0,G2H8(1),n2h8(12))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,2),G1H8(10),ngZd,m3h4x8(:,7),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(10),44,0,G2H8(2),n2h8(13))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,2),G1H8(3),ngZu,m3h4x8(:,8),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(3),44,0,G2H8(3),n2h8(14))
  call Hloop_VV_S(ntryL,G0H32(7),wf4(:,2),G0H8(13),m3h4x8(:,9),heltab2x32(:,:,30))
  call Hloop_VV_S(ntryL,G0H32(8),wf4(:,2),G0H8(14),m3h4x8(:,10),heltab2x32(:,:,31))
  call Hloop_UW_V(ntryL,G0H32(9),32,wf4(:,2),12,G1H8(5),m3h4x8(:,11),heltab2x32(:,:,32))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,1),G1H8(11),ngZd,m3h4x8(:,12),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(11),35,0,G2H8(4),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,1),G1H8(9),ngZd,m3h4x8(:,13),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(9),35,0,G2H8(5),n2h8(16))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,1),G1H8(10),ngZu,m3h4x8(:,14),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(10),35,0,G2H8(6),n2h8(17))
  call Hloop_VV_S(ntryL,G0H32(4),wf4(:,1),G0H8(15),m3h4x8(:,15),heltab2x32(:,:,36))
  call Hloop_VV_S(ntryL,G0H32(11),wf4(:,1),G0H8(16),m3h4x8(:,16),heltab2x32(:,:,37))
  call Hloop_UW_V(ntryL,G0H32(12),32,wf4(:,1),3,G1H8(3),m3h4x8(:,17),heltab2x32(:,:,38))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,1),G1H8(11),ngZu,m3h4x8(:,18),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(11),35,0,G2H8(7),n2h8(18))
  call Hloop_UW_V(ntryL,G0H32(3),32,wf4(:,1),3,G1H8(9),m3h4x8(:,19),heltab2x32(:,:,40))
  call Hloop_AZ_Q(ntryL,G1H16(3),wf4(:,1),G1H4(29),ngZl,m3h4x4(:,7),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(29),51,0,G2H4(4),n2h4(33))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,1),G1H4(30),ngZn,m3h4x4(:,8),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(30),51,0,G2H4(5),n2h4(34))
  call Hloop_SV_V(ntryL,G0H16(3),wf4(:,1),G0H4(1),m3h4x4(:,9),heltab2x16(:,:,32))
  call Hloop_SV_V(ntryL,G0H16(2),wf4(:,1),G0H4(2),m3h4x4(:,10),heltab2x16(:,:,33))
  call Hloop_UV_W(ntryL,G1H16(8),48,wf4(:,1),3,G2H4(6),m3h4x4(:,11),heltab2x16(:,:,34))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,1),G1H4(1),ngZl,m3h4x4(:,12),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(7),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,1),G1H4(2),ngZn,m3h4x4(:,13),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(2),51,0,G2H4(8),n2h4(36))
  call Hloop_SV_V(ntryL,G0H16(6),wf4(:,1),G0H4(3),m3h4x4(:,14),heltab2x16(:,:,37))
  call Hloop_SV_V(ntryL,G0H16(5),wf4(:,1),G0H4(4),m3h4x4(:,15),heltab2x16(:,:,38))
  call Hloop_UW_V(ntryL,G1H16(5),48,wf4(:,1),3,G2H4(9),m3h4x4(:,16),heltab2x16(:,:,39))
  call Hloop_WQ_A(ntryL,G1H16(10),ex3(:),G1H8(10),m3h2x8(:,24),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(10),52,0,G2H8(8),n2h8(19))
  call Hloop_AQ_W(ntryL,G1H16(14),ex3(:),G1H8(11),m3h2x8(:,25),heltab2x16(:,:,41))
  call Hloop_ZQ_A(ntryL,G0H32(5),wf8(:,9),G0H4(5),ngZn,m3h8x4(:,1),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H4(5),39,0,G1H4(8),n2h4(37))
  call Hloop_ZA_Q(ntryL,G0H32(6),ex4(:),G0H16(13),ngZn,m3h2x16(:,22),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(13),40,0,G1H16(1),n2h16(46))
  call Hloop_WA_Q(ntryL,G0H32(10),ex4(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(6),n2h16(47))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,32),G0H4(5),ngZn,m3h8x4(:,2),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H4(5),43,0,G1H4(11),n2h4(38))
  call Hloop_WA_Q(ntryL,G0H32(2),wf8(:,32),G0H4(5),m3h8x4(:,3),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H4(5),43,0,G1H4(12),n2h4(39))
  call Hloop_ZQ_A(ntryL,G0H32(13),ex3(:),G0H16(4),ngZn,m3h2x16(:,24),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(4),36,0,G1H16(9),n2h16(48))
  call Hloop_ZQ_A(ntryL,G0H32(14),ex3(:),G0H16(7),ngZn,m3h2x16(:,25),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(7),36,0,G1H16(2),n2h16(49))
  call Hloop_ZA_Q(ntryL,G0H32(15),ex4(:),G0H16(10),ngZn,m3h2x16(:,26),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H16(10),40,0,G1H16(7),n2h16(50))
  call Hloop_WA_Q(ntryL,G0H32(16),ex4(:),G0H16(3),m3h2x16(:,27),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(3),40,0,G1H16(13),n2h16(51))
  call Hloop_ZA_Q(ntryL,G0H8(1),ex4(:),G0H4(5),ngZn,m3h2x4(:,27),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G0H4(5),43,0,G1H4(18),n2h4(40))
  call Hloop_WA_Q(ntryL,G0H8(2),ex4(:),G0H4(5),m3h2x4(:,28),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G0H4(5),43,0,G1H4(19),n2h4(41))
  call Hloop_ZQ_A(ntryL,G0H8(3),ex3(:),G0H4(5),ngZn,m3h2x4(:,29),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(5),39,0,G1H4(20),n2h4(42))
  call Hloop_QA_W(ntryL,G1H16(17),ex2(:),G1H8(10),m3h2x8(:,26),heltab2x16(:,:,42))
  call Hloop_QA_Z(ntryL,G1H16(16),ex2(:),G1H8(12),ngZn,m3h2x8(:,27),heltab2x16(:,:,43))
  call Hloop_WA_Q(ntryL,G0H16(9),ex2(:),G0H8(1),m3h2x8(:,28),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G0H8(1),50,0,G1H8(13),n2h8(20))
  call Hloop_ZA_Q(ntryL,G0H16(8),ex2(:),G0H8(2),ngZn,m3h2x8(:,29),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G0H8(2),50,0,G1H8(14),n2h8(21))
  call Hloop_WA_Q(ntryL,G1H16(19),ex2(:),G1H8(15),m3h2x8(:,30),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(15),50,0,G2H8(9),n2h8(22))
  call Hloop_AQ_W(ntryL,G1H16(22),ex1(:),G1H8(15),m3h2x8(:,31),heltab2x16(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H16(21),ex1(:),G1H8(16),ngZn,m3h2x8(:,32),heltab2x16(:,:,48))
  call Hloop_WQ_A(ntryL,G0H16(12),ex1(:),G0H8(3),m3h2x8(:,33),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G0H8(3),49,0,G1H8(17),n2h8(23))
  call Hloop_ZQ_A(ntryL,G0H16(11),ex1(:),G0H8(1),ngZn,m3h2x8(:,34),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G0H8(1),49,0,G1H8(18),n2h8(24))
  call Hloop_WQ_A(ntryL,G1H16(24),ex1(:),G1H8(19),m3h2x8(:,35),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(19),49,0,G2H8(10),n2h8(25))
  call Hloop_WQ_A(ntryL,G1H16(26),ex1(:),G1H8(19),m3h2x8(:,36),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(19),49,0,G2H8(11),n2h8(26))
  call Hloop_AQ_W(ntryL,G1H16(28),ex1(:),G1H8(19),m3h2x8(:,37),heltab2x16(:,:,53))
  call Hloop_ZQ_A(ntryL,G0H32(17),wf8(:,15),G0H4(5),ngZn,m3h8x4(:,4),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H4(5),45,0,G1H4(26),n2h4(43))
  call Hloop_ZA_Q(ntryL,G0H32(18),ex2(:),G0H16(2),ngZn,m3h2x16(:,28),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(15),n2h16(52))
  call Hloop_WA_Q(ntryL,G0H32(19),ex2(:),G0H16(6),m3h2x16(:,29),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(6),34,0,G1H16(18),n2h16(53))
  call Hloop_ZA_Q(ntryL,G0H32(20),wf8(:,54),G0H4(5),ngZn,m3h8x4(:,5),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H4(5),46,0,G1H4(29),n2h4(44))
  call Hloop_WA_Q(ntryL,G0H32(21),wf8(:,54),G0H4(5),m3h8x4(:,6),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H4(5),46,0,G1H4(30),n2h4(45))
  call Hloop_ZQ_A(ntryL,G0H32(22),ex1(:),G0H16(5),ngZn,m3h2x16(:,30),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(5),33,0,G1H16(20),n2h16(54))
  call Hloop_ZQ_A(ntryL,G0H32(23),ex1(:),G0H16(13),ngZn,m3h2x16(:,31),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(23),n2h16(55))
  call Hloop_ZA_Q(ntryL,G0H32(24),ex2(:),G0H16(1),ngZn,m3h2x16(:,32),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(25),n2h16(56))
  call Hloop_WA_Q(ntryL,G0H32(25),ex2(:),G0H16(4),m3h2x16(:,33),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(4),34,0,G1H16(27),n2h16(57))
  call Hloop_ZA_Q(ntryL,G0H8(4),ex2(:),G0H4(5),ngZn,m3h2x4(:,30),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G0H4(5),46,0,G1H4(1),n2h4(46))
  call Hloop_WA_Q(ntryL,G0H8(5),ex2(:),G0H4(5),m3h2x4(:,31),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G0H4(5),46,0,G1H4(2),n2h4(47))
  call Hloop_ZQ_A(ntryL,G0H8(6),ex1(:),G0H4(5),ngZn,m3h2x4(:,32),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(5),45,0,G1H4(31),n2h4(48))
  call Hloop_QA_Z(ntryL,G1H8(6),ex2(:),G1H4(32),ngZn,m3h2x4(:,33),heltab2x8(:,:,35))
  call Hloop_QA_W(ntryL,G1H8(7),ex2(:),G1H4(33),m3h2x4(:,34),heltab2x8(:,:,36))
  call Hloop_QA_Z(ntryL,G1H8(8),ex2(:),G1H4(34),ngZn,m3h2x4(:,35),heltab2x8(:,:,37))
  call Hloop_AQ_Z(ntryL,G1H8(1),ex1(:),G1H4(35),ngZn,m3h2x4(:,36),heltab2x8(:,:,38))
  call Hloop_AQ_Z(ntryL,G1H8(2),ex1(:),G1H4(36),ngZn,m3h2x4(:,37),heltab2x8(:,:,39))
  call Hloop_AQ_W(ntryL,G1H8(4),ex1(:),G1H4(37),m3h2x4(:,38),heltab2x8(:,:,40))
  call Hloop_ZA_Q(ntryL,G0H8(7),ex2(:),G0H4(5),ngZn,m3h2x4(:,39),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G0H4(5),54,0,G1H4(38),n2h4(49))
  call Hloop_WA_Q(ntryL,G0H8(8),ex2(:),G0H4(5),m3h2x4(:,40),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G0H4(5),54,0,G1H4(39),n2h4(50))
  call Hloop_ZQ_A(ntryL,G0H8(9),ex1(:),G0H4(5),ngZn,m3h2x4(:,41),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G0H4(5),53,0,G1H4(40),n2h4(51))
  call Hloop_ZA_Q(ntryL,G0H8(10),ex2(:),G0H4(5),ngZn,m3h2x4(:,42),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G0H4(5),58,0,G1H4(41),n2h4(52))
  call Hloop_ZQ_A(ntryL,G0H8(11),ex1(:),G0H4(5),ngZn,m3h2x4(:,43),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G0H4(5),57,0,G1H4(42),n2h4(53))
  call Hloop_WQ_A(ntryL,G0H8(12),ex1(:),G0H4(5),m3h2x4(:,44),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G0H4(5),57,0,G1H4(43),n2h4(54))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(22),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(28),G0H4(1)])
  call Hloop_ZQ_A(ntryL,G1H4(3),ex3(:),G1H2(1),ngZn,m3h2x2(:,45),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(1),n2h2(16))
  call Hloop_ZQ_A(ntryL,G1H4(4),ex3(:),G1H2(7),ngZn,m3h2x2(:,46),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(7),55,0,G2H2(7),n2h2(17))
  call Hloop_WQ_A(ntryL,G1H4(9),ex3(:),G1H2(20),m3h2x2(:,47),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(20),55,0,G2H2(6),n2h2(18))
  call Hloop_WQ_A(ntryL,G1H4(10),ex3(:),G1H2(25),m3h2x2(:,48),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(25),55,0,G2H2(2),n2h2(19))
  call Hloop_ZA_Q(ntryL,G1H4(15),ex4(:),G1H2(31),ngZn,m3h2x2(:,49),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(31),59,0,G2H2(3),n2h2(20))
  call Hloop_ZA_Q(ntryL,G1H4(16),ex4(:),G1H2(44),ngZn,m3h2x2(:,50),heltab2x4(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(44),59,0,G2H2(4),n2h2(21))
  call Hloop_WA_Q(ntryL,G1H4(37),ex4(:),G1H2(49),m3h2x2(:,51),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(49),59,0,G2H2(5),n2h2(22))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(95),mass4set(:,1),  & 
G1H4(21),G1H4(22),G1H4(27),G1H4(28),G1H4(3),4)
  call HG1shiftOLR(G1H4(22),4,4)
  call Hloop_WQ_A(ntryL,G1H4(33),ex3(:),G1H2(55),m3h2x2(:,52),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(55),55,0,G2H2(8),n2h2(23))
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(88),mass4set(:,1),  & 
G1H4(4),G1H4(9),G1H4(10),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(9),8,4)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(7),mass4set(:,2),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(1),G1H8(2),8)
  call HG1shiftOLR(G1H8(7),16,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(7),mass4set(:,3),  & 
G1H8(4),G1H8(20),G1H8(21),G1H8(22),G1H8(23),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(7),mass4set(:,4),  & 
G1H8(24),G1H8(25),G1H8(26),G1H8(27),G1H8(28),8)
  call HG1shiftOLR(G1H8(25),16,8)
  call Hloop_SV_V(ntryL,G0H8(13),wf4(:,1),G0H2(1),m3h4x2(:,3),heltab2x8(:,:,47))
  call Hloop_SV_V(ntryL,G0H8(14),wf4(:,1),G0H2(2),m3h4x2(:,4),heltab2x8(:,:,48))
  call Hloop_UW_V(ntryL,G1H8(5),44,wf4(:,1),3,G2H2(9),m3h4x2(:,5),heltab2x8(:,:,49))
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(22),mass4set(:,2),  & 
G1H8(5),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(29),16,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(22),mass4set(:,3),  & 
G1H8(33),G1H8(34),G1H8(35),G1H8(36),G1H8(37),8)
  call HG1shiftOLR(G1H8(34),16,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(22),mass4set(:,4),  & 
G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(39),16,8)
  call Hloop_SV_V(ntryL,G0H8(15),wf4(:,2),G0H2(3),m3h4x2(:,6),heltab2x8(:,:,50))
  call Hloop_SV_V(ntryL,G0H8(16),wf4(:,2),G0H2(4),m3h4x2(:,7),heltab2x8(:,:,51))
  call Hloop_UW_V(ntryL,G1H8(3),35,wf4(:,2),12,G2H2(10),m3h4x2(:,8),heltab2x8(:,:,52))
  call Hloop_AQ_W(ntryL,G2H8(7),ex5(:),G2H4(10),m3h2x4(:,45),heltab2x8(:,:,53))
  call Hloop_WQ_A(ntryL,G1H8(9),ex5(:),G1H4(37),m3h2x4(:,46),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(37),51,0,G2H4(11),n2h4(55))
  call Hloop_AQ_W(ntryL,G2H4(4),ex3(:),G2H2(11),m3h2x2(:,53),heltab2x4(:,:,62))
  call Hloop_AQ_Z(ntryL,G2H4(5),ex3(:),G2H2(12),ngZn,m3h2x2(:,54),heltab2x4(:,:,63))
  call Hloop_ZQ_A(ntryL,G0H4(2),ex3(:),G0H2(5),ngZn,m3h2x2(:,55),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G0H2(5),55,0,G1H2(10),n2h2(24))
  call Hloop_QA_W(ntryL,G2H4(7),ex4(:),G2H2(13),m3h2x2(:,56),heltab2x4(:,:,65))
  call Hloop_QA_Z(ntryL,G2H4(8),ex4(:),G2H2(14),ngZn,m3h2x2(:,57),heltab2x4(:,:,66))
  call Hloop_ZA_Q(ntryL,G0H4(4),ex4(:),G0H2(5),ngZn,m3h2x2(:,58),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G0H2(5),59,0,G1H2(12),n2h2(25))
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(136),mass4set(:,5),  & 
G1H8(3),G1H8(9),G1H8(43),G1H8(44),G1H8(45),8)
  call HG1shiftOLR(G1H8(9),8,8)
  call Hloop_UW_V(ntryL,G1H8(11),52,wf4(:,1),3,G2H2(15),m3h4x2(:,9),heltab2x8(:,:,55))
  call Hloop_QA_Z(ntryL,G1H4(8),ex4(:),G1H2(18),ngZn,m3h2x2(:,59),heltab2x4(:,:,68))
  call Hloop_AQ_Z(ntryL,G1H16(1),wf8(:,9),G1H2(34),ngZn,m3h8x2(:,1),heltab2x16(:,:,54))
  call Hloop_AQ_W(ntryL,G1H16(6),wf8(:,9),G1H2(40),m3h8x2(:,2),heltab2x16(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H4(11),ex3(:),G1H2(42),ngZn,m3h2x2(:,60),heltab2x4(:,:,69))
  call Hloop_AQ_W(ntryL,G1H4(12),ex3(:),G1H2(5),m3h2x2(:,61),heltab2x4(:,:,70))
  call Hloop_QA_Z(ntryL,G1H16(9),wf8(:,32),G1H2(36),ngZn,m3h8x2(:,3),heltab2x16(:,:,56))
  call Hloop_QA_Z(ntryL,G1H16(2),ex4(:),G1H8(11),ngZn,m3h2x8(:,38),heltab2x16(:,:,57))
  call Hloop_AQ_Z(ntryL,G1H16(7),ex3(:),G1H8(46),ngZn,m3h2x8(:,39),heltab2x16(:,:,58))
  call Hloop_AQ_W(ntryL,G1H16(13),ex3(:),G1H8(47),m3h2x8(:,40),heltab2x16(:,:,59))
  call Hloop_AQ_Z(ntryL,G1H4(18),ex3(:),G1H2(9),ngZn,m3h2x2(:,62),heltab2x4(:,:,71))
  call Hloop_AQ_W(ntryL,G1H4(19),ex3(:),G1H2(15),m3h2x2(:,63),heltab2x4(:,:,72))
  call Hloop_QA_Z(ntryL,G1H4(20),ex4(:),G1H2(17),ngZn,m3h2x2(:,64),heltab2x4(:,:,73))
  call Hloop_WQ_A(ntryL,G1H8(10),ex1(:),G1H4(33),m3h2x4(:,47),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(33),51,0,G2H4(12),n2h4(56))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex1(:),G1H4(37),ngZn,m3h2x4(:,48),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(37),51,0,G2H4(13),n2h4(57))
  call Hloop_AQ_W(ntryL,G1H8(13),ex1(:),G1H4(8),m3h2x4(:,49),heltab2x8(:,:,58))
  call Hloop_AQ_Z(ntryL,G1H8(14),ex1(:),G1H4(11),ngZn,m3h2x4(:,50),heltab2x8(:,:,59))
  call Hloop_AQ_W(ntryL,G2H8(9),ex1(:),G2H4(14),m3h2x4(:,51),heltab2x8(:,:,60))
  call Hloop_WA_Q(ntryL,G1H8(15),ex2(:),G1H4(12),m3h2x4(:,52),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(12),51,0,G2H4(15),n2h4(58))
  call Hloop_ZA_Q(ntryL,G1H8(16),ex2(:),G1H4(18),ngZn,m3h2x4(:,53),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(18),51,0,G2H4(16),n2h4(59))
  call Hloop_QA_W(ntryL,G1H8(17),ex2(:),G1H4(19),m3h2x4(:,54),heltab2x8(:,:,63))
  call Hloop_QA_Z(ntryL,G1H8(18),ex2(:),G1H4(20),ngZn,m3h2x4(:,55),heltab2x8(:,:,64))
  call Hloop_QA_W(ntryL,G2H8(10),ex2(:),G2H4(17),m3h2x4(:,56),heltab2x8(:,:,65))
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(143),mass4set(:,5),  & 
G1H8(10),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(12),2,8)
  call Hloop_UW_V(ntryL,G1H8(19),49,wf4(:,2),12,G2H2(16),m3h4x2(:,10),heltab2x8(:,:,66))
  call Hloop_QA_Z(ntryL,G1H4(26),ex2(:),G1H2(48),ngZn,m3h2x2(:,65),heltab2x4(:,:,74))
  call Hloop_AQ_Z(ntryL,G1H16(15),wf8(:,15),G1H2(27),ngZn,m3h8x2(:,4),heltab2x16(:,:,60))
  call Hloop_AQ_W(ntryL,G1H16(18),wf8(:,15),G1H2(29),m3h8x2(:,5),heltab2x16(:,:,61))
  call Hloop_AQ_Z(ntryL,G1H4(29),ex1(:),G1H2(33),ngZn,m3h2x2(:,66),heltab2x4(:,:,75))
  call Hloop_AQ_W(ntryL,G1H4(30),ex1(:),G1H2(41),m3h2x2(:,67),heltab2x4(:,:,76))
  call Hloop_QA_Z(ntryL,G1H16(20),wf8(:,54),G1H2(45),ngZn,m3h8x2(:,6),heltab2x16(:,:,62))
  call Hloop_QA_Z(ntryL,G1H16(23),ex2(:),G1H8(16),ngZn,m3h2x8(:,41),heltab2x16(:,:,63))
  call Hloop_AQ_Z(ntryL,G1H16(25),ex1(:),G1H8(17),ngZn,m3h2x8(:,42),heltab2x16(:,:,64))
  call Hloop_AQ_W(ntryL,G1H16(27),ex1(:),G1H8(18),m3h2x8(:,43),heltab2x16(:,:,65))
  call Hloop_AQ_Z(ntryL,G1H4(1),ex1(:),G1H2(47),ngZn,m3h2x2(:,68),heltab2x4(:,:,77))
  call Hloop_AQ_W(ntryL,G1H4(2),ex1(:),G1H2(57),m3h2x2(:,69),heltab2x4(:,:,78))
  call Hloop_QA_Z(ntryL,G1H4(31),ex2(:),G1H2(59),ngZn,m3h2x2(:,70),heltab2x4(:,:,79))
  call Hloop_ZQ_A(ntryL,G1H4(32),ex3(:),G1H2(61),ngZn,m3h2x2(:,71),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(61),55,0,G2H2(17),n2h2(26))
  call Hloop_ZA_Q(ntryL,G1H4(34),ex4(:),G1H2(65),ngZn,m3h2x2(:,72),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(65),59,0,G2H2(19),n2h2(27))
  call Hloop_ZQ_A(ntryL,G1H4(35),ex3(:),G1H2(66),ngZn,m3h2x2(:,73),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(66),55,0,G2H2(20),n2h2(28))
  call Hloop_ZA_Q(ntryL,G1H4(36),ex4(:),G1H2(67),ngZn,m3h2x2(:,74),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(67),59,0,G2H2(22),n2h2(29))
  call Hloop_AQ_Z(ntryL,G1H4(38),ex1(:),G1H2(71),ngZn,m3h2x2(:,75),heltab2x4(:,:,84))
  call Hloop_AQ_W(ntryL,G1H4(39),ex1(:),G1H2(72),m3h2x2(:,76),heltab2x4(:,:,85))
  call Hloop_QA_Z(ntryL,G1H4(40),ex2(:),G1H2(73),ngZn,m3h2x2(:,77),heltab2x4(:,:,86))
  call Hloop_AQ_Z(ntryL,G1H4(41),ex1(:),G1H2(77),ngZn,m3h2x2(:,78),heltab2x4(:,:,87))
  call Hloop_QA_Z(ntryL,G1H4(42),ex2(:),G1H2(78),ngZn,m3h2x2(:,79),heltab2x4(:,:,88))
  call Hloop_QA_W(ntryL,G1H4(43),ex2(:),G1H2(79),m3h2x2(:,80),heltab2x4(:,:,89))
  call Hloop_WA_Q(ntryL,G1H4(21),ex4(:),G1H2(83),m3h2x2(:,81),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(83),59,0,G2H2(23),n2h2(30))
call HGT_raise_alpha_OLR(G1H4(22),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(22),ex3(:),G1H2(84),m3h2x2(:,82),heltab2x4(:,:,91))
  call Hloop_WA_Q(ntryL,G1H4(28),ex4(:),G1H2(85),m3h2x2(:,83),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(85),59,0,G2H2(25),n2h2(31))
  call Hloop_WA_Q(ntryL,G1H4(3),ex4(:),G1H2(89),m3h2x2(:,84),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(89),59,0,G2H2(26),n2h2(32))
  call Hloop_WQ_A(ntryL,G1H4(4),ex3(:),G1H2(90),m3h2x2(:,85),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(90),55,0,G2H2(28),n2h2(33))
call HGT_raise_alpha_OLR(G1H4(9),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(9),ex4(:),G1H2(91),m3h2x2(:,86),heltab2x4(:,:,95))
  call Hloop_WQ_A(ntryL,G1H4(15),ex3(:),G1H2(95),m3h2x2(:,87),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(95),55,0,G2H2(29),n2h2(34))
  call Hloop_WQ_A(ntryL,G1H4(16),ex3(:),G1H2(96),m3h2x2(:,88),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(96),55,0,G2H2(31),n2h2(35))
  call Hloop_AZ_Q(ntryL,G1H8(6),wf4(:,1),G1H2(97),ngZd,m3h4x2(:,11),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(97),47,0,G2H2(32),n2h2(36))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex5(:),G1H4(33),m3h2x4(:,57),heltab2x8(:,:,68))
  call Hloop_AZ_Q(ntryL,G1H8(1),wf4(:,1),G1H2(101),ngZd,m3h4x2(:,12),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(101),47,0,G2H2(33),n2h2(37))
  call Hloop_AZ_Q(ntryL,G1H8(2),wf4(:,1),G1H2(1),ngZd,m3h4x2(:,13),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(34),n2h2(38))
  call Hloop_AZ_Q(ntryL,G1H8(4),wf4(:,1),G1H2(7),ngZd,m3h4x2(:,14),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(35),n2h2(39))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(20),ex5(:),G1H4(37),ngZd,m3h2x4(:,58),heltab2x8(:,:,72))
  call Hloop_AZ_Q(ntryL,G1H8(22),wf4(:,1),G1H2(20),ngZd,m3h4x2(:,15),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(20),47,0,G2H2(36),n2h2(40))
  call Hloop_AZ_Q(ntryL,G1H8(23),wf4(:,1),G1H2(25),ngZd,m3h4x2(:,16),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(25),47,0,G2H2(37),n2h2(41))
  call Hloop_AZ_Q(ntryL,G1H8(24),wf4(:,1),G1H2(31),ngZu,m3h4x2(:,17),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(31),47,0,G2H2(38),n2h2(42))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(25),ex5(:),G1H4(12),m3h2x4(:,59),heltab2x8(:,:,76))
  call Hloop_AZ_Q(ntryL,G1H8(27),wf4(:,1),G1H2(44),ngZu,m3h4x2(:,18),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(39),n2h2(43))
  call Hloop_AZ_Q(ntryL,G1H8(28),wf4(:,1),G1H2(49),ngZu,m3h4x2(:,19),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(49),47,0,G2H2(40),n2h2(44))
  call Hloop_AZ_Q(ntryL,G1H8(5),wf4(:,2),G1H2(55),ngZd,m3h4x2(:,20),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(55),47,0,G2H2(41),n2h2(45))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(29),ex5(:),G1H4(18),m3h2x4(:,60),heltab2x8(:,:,80))
  call Hloop_AZ_Q(ntryL,G1H8(31),wf4(:,2),G1H2(61),ngZd,m3h4x2(:,21),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(61),47,0,G2H2(42),n2h2(46))
  call Hloop_AZ_Q(ntryL,G1H8(32),wf4(:,2),G1H2(65),ngZd,m3h4x2(:,22),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(65),47,0,G2H2(43),n2h2(47))
  call Hloop_AZ_Q(ntryL,G1H8(33),wf4(:,2),G1H2(66),ngZd,m3h4x2(:,23),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(66),47,0,G2H2(44),n2h2(48))
call HGT_raise_alpha_OLR(G1H8(34),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(34),ex5(:),G1H4(26),ngZd,m3h2x4(:,61),heltab2x8(:,:,84))
  call Hloop_AZ_Q(ntryL,G1H8(36),wf4(:,2),G1H2(67),ngZd,m3h4x2(:,24),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(67),47,0,G2H2(45),n2h2(49))
  call Hloop_AZ_Q(ntryL,G1H8(37),wf4(:,2),G1H2(83),ngZd,m3h4x2(:,25),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(83),47,0,G2H2(46),n2h2(50))
  call Hloop_AZ_Q(ntryL,G1H8(38),wf4(:,2),G1H2(85),ngZu,m3h4x2(:,26),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(85),47,0,G2H2(47),n2h2(51))
call HGT_raise_alpha_OLR(G1H8(39),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(39),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(39),ex5(:),G1H4(29),m3h2x4(:,62),heltab2x8(:,:,88))
  call Hloop_AZ_Q(ntryL,G1H8(41),wf4(:,2),G1H2(89),ngZu,m3h4x2(:,27),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(89),47,0,G2H2(48),n2h2(52))
  call Hloop_AZ_Q(ntryL,G1H8(42),wf4(:,2),G1H2(90),ngZu,m3h4x2(:,28),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(90),47,0,G2H2(49),n2h2(53))
  call Hloop_QZ_A(ntryL,G1H8(3),wf4(:,1),G1H2(95),ngZl,m3h4x2(:,29),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(95),55,0,G2H2(50),n2h2(54))
call HGT_raise_alpha_OLR(G1H8(9),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(9),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(9),ex4(:),G1H4(30),m3h2x4(:,63),heltab2x8(:,:,92))
  call Hloop_QZ_A(ntryL,G1H8(44),wf4(:,1),G1H2(96),ngZl,m3h4x2(:,30),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(96),55,0,G2H2(51),n2h2(55))
  call Hloop_QZ_A(ntryL,G1H8(45),wf4(:,1),G1H2(97),ngZl,m3h4x2(:,31),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(97),55,0,G2H2(52),n2h2(56))
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,2),G1H2(101),ngZl,m3h4x2(:,32),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(101),61,0,G2H2(53),n2h2(57))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,64),heltab2x8(:,:,96))
  call Hloop_QZ_A(ntryL,G1H8(14),wf4(:,2),G1H2(1),ngZl,m3h4x2(:,33),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(1),61,0,G2H2(54),n2h2(58))
  call Hloop_QZ_A(ntryL,G1H8(15),wf4(:,2),G1H2(7),ngZl,m3h4x2(:,34),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(7),61,0,G2H2(55),n2h2(59))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(74)])
call HGT_w2_OLR(G1H2(38),1,1,2)
call HGT_w2_invQ_OLR(G1H2(38),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(72)])
call HGT_w2_OLR(G1H2(50),1,1,2)
call HGT_w2_invQ_OLR(G1H2(50),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(5),[G1H2(11),G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(37),G1H2(19),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(60),G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(57),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(53),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(28),G1H2(6),G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(24),G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(34),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(27),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(73),[G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(82),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(100),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(94)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngZn,m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(106))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(2),ngZn,m3h2x1(:,108),heltab2x2(:,:,108))
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(107))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(21),ex4(:),G2tensor(6),m3h2x1(:,110),heltab2x2(:,:,110))
call HGT_w2_OLR(G1H2(26),1,1,2)
call HGT_w2_invQ_OLR(G1H2(26),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),ngZn,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(8),n2h1(108))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(24),ex3(:),G2tensor(45),ngZn,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hloop_WA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(109))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(27),ex3(:),G2tensor(14),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hloop_WQ_A(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(16),n2h1(110))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(30),ex4(:),G2tensor(18),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hloop_WQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(20),n2h1(111))
  call Hloop_WQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(112))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(22),mass4set(:,6),  & 
G1H2(20),G1H2(25),G1H2(31),G1H2(44),G1H2(49),2)
  call HG1shiftOLR(G1H2(25),16,2)
  call Hloop_WQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(113))
  call Hloop_WQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(114))
  call Hloop_WQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(115))
  call Hloop_WQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(116))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(7),mass4set(:,6),  & 
G1H2(55),G1H2(61),G1H2(65),G1H2(66),G1H2(67),2)
  call HG1shiftOLR(G1H2(61),16,2)
  call Hloop_WQ_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(117))
  call Hloop_WQ_A(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(118))
  call Hloop_ZQ_A(ntryL,G1H2(54),ex5(:),G1H1(1),ngZd,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(119))
  call Hloop_ZQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),ngZd,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(120))
  call Hloop_ZQ_A(ntryL,G1H2(34),ex5(:),G1H1(1),ngZd,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(121))
  call Hloop_WQ_A(ntryL,G1H2(52),ex5(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(122))
  call Hloop_ZQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),ngZd,m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(123))
  call Hloop_ZQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),ngZd,m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(124))
  call Hloop_ZQ_A(ntryL,G1H2(36),ex5(:),G1H1(1),ngZd,m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(125))
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,10),heltab2x4(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(126))
  call Hloop_QZ_A(ntryL,G1H4(24),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,11),heltab2x4(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(127))
  call Hloop_QZ_A(ntryL,G1H4(7),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,12),heltab2x4(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(26),n2h1(128))
  call Hloop_QZ_A(ntryL,G1H4(13),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,13),heltab2x4(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(129))
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(110),mass4set(:,7),  & 
G1H4(2),G1H4(31),G1H4(32),G1H4(34),G1H4(35),4)
  call HG1shiftOLR(G1H4(31),12,4)
  call Hloop_QZ_A(ntryL,G1H4(17),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,14),heltab2x4(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(130))
  call Hloop_QZ_A(ntryL,G1H4(23),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,15),heltab2x4(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(28),n2h1(131))
  call Hloop_QZ_A(ntryL,G1H4(25),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,16),heltab2x4(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(132))
  call Hloop_ZQ_A(ntryL,G1H2(46),ex5(:),G1H1(1),ngZd,m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(133))
  call Hloop_ZQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),ngZd,m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(134))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),ngZd,m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(135))
  call Hloop_WQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(136))
  call Hloop_ZQ_A(ntryL,G1H2(62),ex5(:),G1H1(1),ngZd,m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(137))
  call Hloop_ZQ_A(ntryL,G1H2(48),ex5(:),G1H1(1),ngZd,m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(138))
  call Hloop_ZQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),ngZd,m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(139))
  call Hloop_ZA_Q(ntryL,G1H2(73),ex4(:),G1H1(1),ngZn,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(140))
  call Hloop_ZA_Q(ntryL,G1H2(69),ex4(:),G1H1(1),ngZn,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(141))
  call Hloop_ZA_Q(ntryL,G1H2(82),ex4(:),G1H1(1),ngZn,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(142))
  call Hloop_WA_Q(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(143))
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(136),mass4set(:,8),  & 
G1H2(83),G1H2(85),G1H2(89),G1H2(90),G1H2(95),2)
  call HG1shiftOLR(G1H2(85),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(71),ex4(:),G1H1(1),ngZn,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(144))
  call Hloop_ZA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),ngZn,m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(145))
  call Hloop_ZA_Q(ntryL,G1H2(86),ex2(:),G1H1(1),ngZn,m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(146))
  call Hloop_ZA_Q(ntryL,G1H2(87),ex2(:),G1H1(1),ngZn,m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(147))
  call Hloop_ZA_Q(ntryL,G1H2(100),ex2(:),G1H1(1),ngZn,m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(148))
  call Hloop_WA_Q(ntryL,G1H2(92),ex2(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(149))
  call Hloop_WA_Q(ntryL,G1H2(93),ex2(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(150))
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(143),mass4set(:,8),  & 
G1H2(96),G1H2(97),G1H2(101),G1H2(1),G1H2(7),2)
  call HG1shiftOLR(G1H2(97),2,2)
  call Hloop_ZA_Q(ntryL,G1H2(98),ex2(:),G1H1(1),ngZn,m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(151))
  call Hloop_ZA_Q(ntryL,G1H2(99),ex2(:),G1H1(1),ngZn,m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(152))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(76),ngZn,m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(79),ngZn,m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(82),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(85),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(88),ngZn,m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(91),ngZn,m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(94),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(97),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hloop_ZQ_A(ntryL,G0H2(1),ex5(:),G0H1(1),ngZd,m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(1),n2h1(153))
  call Hloop_ZQ_A(ntryL,G0H2(3),ex5(:),G0H1(1),ngZd,m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(37),n2h1(154))
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(110),mass4set(:,9),  & 
G1H4(36),G1H4(38),G1H4(39),G1H4(40),G1H4(41),4)
  call HG1shiftOLR(G1H4(38),12,4)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(88),mass4set(:,10),  & 
G1H2(74),G1H2(72),G1H2(79),G1H2(8),G1H2(11),2)
  call HG1shiftOLR(G1H2(72),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(88),mass4set(:,11),  & 
G1H2(13),G1H2(37),G1H2(19),G1H2(60),G1H2(43),2)
  call HG1shiftOLR(G1H2(37),8,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(10),ex4(:),G1tensor(14),ngZn,m3h2x1(:,162),heltab2x2(:,:,162))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(95),mass4set(:,10),  & 
G1H2(56),G1H2(53),G1H2(4),G1H2(28),G1H2(6),2)
  call HG1shiftOLR(G1H2(53),4,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(95),mass4set(:,11),  & 
G1H2(24),G1H2(30),G1H2(3),G1H2(16),G1H2(58),2)
  call HG1shiftOLR(G1H2(30),4,2)
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H2(12),ex3(:),G1tensor(50),ngZn,m3h2x1(:,163),heltab2x2(:,:,163))
  call Hloop_ZQ_A(ntryL,G1H8(11),wf8(:,3),G1H1(1),ngZd,m3h8x1(:,1),heltab2x8(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(100),n2h1(155))
  call Hloop_ZQ_A(ntryL,G1H8(46),wf8(:,3),G1H1(1),ngZd,m3h8x1(:,2),heltab2x8(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(156))
  call Hloop_WQ_A(ntryL,G1H8(47),wf8(:,3),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(157))
  call Hloop_ZQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),ngZd,m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(158))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),ngZd,m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(108),n2h1(159))
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(90),mass4set(:,12),  & 
G1H4(42),G1H4(43),G1H4(21),G1H4(22),G1H4(28),4)
  call HG1shiftOLR(G1H4(43),12,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(90),mass4set(:,13),  & 
G1H4(3),G1H4(4),G1H4(9),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(4),12,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(8),wf4(:,2),G1tensor(36),m3h4x1(:,17),heltab2x4(:,:,105))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(11),wf4(:,2),G1tensor(24),m3h4x1(:,18),heltab2x4(:,:,106))
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(90),mass4set(:,14),  & 
G1H4(6),G1H4(14),G1H4(5),G1H4(24),G1H4(7),4)
  call HG1shiftOLR(G1H4(14),12,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(104),mass4set(:,12),  & 
G1H4(13),G1H4(17),G1H4(23),G1H4(25),G1H4(8),4)
  call HG1shiftOLR(G1H4(17),12,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(104),mass4set(:,13),  & 
G1H4(11),G1H4(44),G1H4(45),G1H4(46),G1H4(47),4)
  call HG1shiftOLR(G1H4(44),12,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(19),wf4(:,2),G1tensor(21),m3h4x1(:,19),heltab2x4(:,:,107))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(20),wf4(:,2),G1tensor(29),m3h4x1(:,20),heltab2x4(:,:,108))
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(104),mass4set(:,14),  & 
G1H4(19),G1H4(20),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(20),12,4)
  call Hloop_ZQ_A(ntryL,G1H8(16),wf8(:,6),G1H1(1),ngZd,m3h8x1(:,4),heltab2x8(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(160))
  call Hloop_ZQ_A(ntryL,G1H8(17),wf8(:,6),G1H1(1),ngZd,m3h8x1(:,5),heltab2x8(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(110),n2h1(161))
  call Hloop_WQ_A(ntryL,G1H8(18),wf8(:,6),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(162))
  call Hloop_ZQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),ngZd,m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(112),n2h1(163))
  call Hloop_ZQ_A(ntryL,G1H2(59),ex5(:),G1H1(1),ngZd,m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(164))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(114),ngZn,m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(115),ngZn,m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(116),ngZn,m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(117),ngZn,m3h2x1(:,171),heltab2x2(:,:,171))
  call Hloop_ZQ_A(ntryL,G1H2(77),ex3(:),G1H1(1),ngZn,m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(165))
  call Hloop_ZQ_A(ntryL,G1H2(78),ex3(:),G1H1(1),ngZn,m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(119),n2h1(166))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(120),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(121),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(28),ex4(:),G2tensor(122),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(31),ex4(:),G2tensor(123),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(32),ex5(:),G2tensor(124),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(34),ex5(:),G2tensor(125),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(35),ex5(:),G2tensor(126),ngZd,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(37),ex5(:),G2tensor(127),ngZd,m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(38),ex5(:),G2tensor(128),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(40),ex5(:),G2tensor(129),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(41),ex5(:),G2tensor(130),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(43),ex5(:),G2tensor(131),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(44),ex5(:),G2tensor(132),ngZd,m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(46),ex5(:),G2tensor(133),ngZd,m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(47),ex5(:),G2tensor(134),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(49),ex5(:),G2tensor(135),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(136),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(52),ex4(:),G2tensor(137),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(53),ex2(:),G2tensor(138),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(55),ex2(:),G2tensor(139),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hloop_WQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(140),n2h1(167))
  call Hloop_WQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(141),n2h1(168))
  call Hloop_WQ_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(169))
  call Hloop_WQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(170))
  call Hloop_WQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(144),n2h1(171))
  call Hloop_WQ_A(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(172))
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,21),heltab2x4(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(146),n2h1(173))
  call Hloop_QZ_A(ntryL,G1H4(31),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,22),heltab2x4(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(147),n2h1(174))
  call Hloop_QZ_A(ntryL,G1H4(35),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,23),heltab2x4(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(148),n2h1(175))
  call Hloop_WA_Q(ntryL,G1H2(83),ex4(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(149),n2h1(176))
  call Hloop_WA_Q(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(150),n2h1(177))
  call Hloop_WA_Q(ntryL,G1H2(95),ex4(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(151),n2h1(178))
  call Hloop_WA_Q(ntryL,G1H2(96),ex2(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(179))
  call Hloop_WA_Q(ntryL,G1H2(97),ex2(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(153),n2h1(180))
  call Hloop_WA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(154),n2h1(181))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(36),51,wf4(:,2),12,G2tensor(155),m3h4x1(:,24),heltab2x4(:,:,112))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(38),0,wf4(:,2),12,G2tensor(156),m3h4x1(:,25),heltab2x4(:,:,113))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(41),51,wf4(:,2),12,G2tensor(157),m3h4x1(:,26),heltab2x4(:,:,114))
  call Hloop_WA_Q(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(183))
  call Hloop_WA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(159),n2h1(184))
  call Hloop_WA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(160),n2h1(185))
  call Hloop_ZA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),ngZn,m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(161),n2h1(186))
  call Hloop_ZA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),ngZn,m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(162),n2h1(187))
  call Hloop_ZA_Q(ntryL,G1H2(43),ex4(:),G1H1(1),ngZn,m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(163),n2h1(188))
  call Hloop_WQ_A(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(164),n2h1(189))
  call Hloop_WQ_A(ntryL,G1H2(53),ex3(:),G1H1(1),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(165),n2h1(190))
  call Hloop_WQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(166),n2h1(191))
  call Hloop_ZQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),ngZn,m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(167),n2h1(192))
  call Hloop_ZQ_A(ntryL,G1H2(30),ex3(:),G1H1(1),ngZn,m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(168),n2h1(193))
  call Hloop_ZQ_A(ntryL,G1H2(58),ex3(:),G1H1(1),ngZn,m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(169),n2h1(194))
  call Hloop_QZ_A(ntryL,G1H4(42),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,27),heltab2x4(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(170),n2h1(195))
  call Hloop_QZ_A(ntryL,G1H4(43),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,28),heltab2x4(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(171),n2h1(196))
  call Hloop_QZ_A(ntryL,G1H4(28),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,29),heltab2x4(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(172),n2h1(197))
  call Hloop_QZ_A(ntryL,G1H4(3),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,30),heltab2x4(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(173),n2h1(198))
  call Hloop_QZ_A(ntryL,G1H4(4),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,31),heltab2x4(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(174),n2h1(199))
  call Hloop_QZ_A(ntryL,G1H4(16),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,32),heltab2x4(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(200))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(6),51,wf4(:,2),12,G2tensor(176),m3h4x1(:,33),heltab2x4(:,:,121))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(14),0,wf4(:,2),12,G2tensor(177),m3h4x1(:,34),heltab2x4(:,:,122))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(7),51,wf4(:,2),12,G2tensor(178),m3h4x1(:,35),heltab2x4(:,:,123))
  call Hloop_AZ_Q(ntryL,G1H4(13),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,36),heltab2x4(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(179),n2h1(202))
  call Hloop_AZ_Q(ntryL,G1H4(17),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,37),heltab2x4(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(180),n2h1(203))
  call Hloop_AZ_Q(ntryL,G1H4(8),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,38),heltab2x4(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(181),n2h1(204))
  call Hloop_AZ_Q(ntryL,G1H4(11),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,39),heltab2x4(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(182),n2h1(205))
  call Hloop_AZ_Q(ntryL,G1H4(44),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,40),heltab2x4(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(183),n2h1(206))
  call Hloop_AZ_Q(ntryL,G1H4(47),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,41),heltab2x4(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(184),n2h1(207))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(19),51,wf4(:,2),12,G2tensor(185),m3h4x1(:,42),heltab2x4(:,:,130))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(20),0,wf4(:,2),12,G2tensor(186),m3h4x1(:,43),heltab2x4(:,:,131))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(50),51,wf4(:,2),12,G2tensor(187),m3h4x1(:,44),heltab2x4(:,:,132))
  call ol_merge_tensors(G2tensor(44),[G2tensor(40),G1tensor(270),G1tensor(258)])
  call ol_merge_tensors(G2tensor(155),[G2tensor(42),G1tensor(264)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(53),G2tensor(46),G1tensor(36),G1tensor(164),G1tensor(11)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(48),G1tensor(21),G1tensor(276)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(50),G1tensor(152),G1tensor(52)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(156)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(75),G2tensor(54),G1tensor(306),G1tensor(168)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(194),G1tensor(23)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(198)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(206),G1tensor(28)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(60),G1tensor(210)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(278)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(282)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(284)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(288)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(290)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(294)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(71),G1tensor(296),G1tensor(213),G1tensor(177),G1tensor(171)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(72),G1tensor(300),G1tensor(108)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(74),G1tensor(302),G1tensor(195),G1tensor(189)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(77),G1tensor(308),G1tensor(111),G1tensor(69),G1tensor(63)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(78),G1tensor(312),G1tensor(240)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(314)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(318)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(320)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(324)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(326)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(330)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(332),G1tensor(62),G1tensor(13)])
  call ol_merge_tensors(G2tensor(90),[G1tensor(336)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(338),G1tensor(188),G1tensor(22)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(342)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(344),G1tensor(170),G1tensor(15)])
  call ol_merge_tensors(G2tensor(96),[G1tensor(348)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(98),G1tensor(350),G1tensor(86),G1tensor(49)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(354)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(101),G1tensor(356),G1tensor(146),G1tensor(9)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(360)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(104),G1tensor(362),G1tensor(128),G1tensor(3)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(366)])
  call ol_merge_tensors(G1tensor(68),[G1tensor(32),G1tensor(19)])
  call ol_merge_tensors(G1tensor(74),[G1tensor(25)])
  call ol_merge_tensors(G1tensor(80),[G1tensor(18),G1tensor(31)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(43)])
  call ol_merge_tensors(G1tensor(92),[G1tensor(42),G1tensor(55)])
  call ol_merge_tensors(G1tensor(98),[G1tensor(2)])
  call ol_merge_tensors(G1tensor(104),[G1tensor(5),G1tensor(8)])
  call ol_merge_tensors(G1tensor(110),[G1tensor(26)])
  call ol_merge_tensors(G1tensor(116),[G1tensor(38)])
  call ol_merge_tensors(G1tensor(122),[G1tensor(35),G1tensor(44)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(345),G1tensor(56)])
  call ol_merge_tensors(G1tensor(134),[G1tensor(54),G1tensor(16)])
  call ol_merge_tensors(G1tensor(140),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(339),G1tensor(6)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(158),G1tensor(10)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(363),G1tensor(12)])
  call ol_merge_tensors(G1tensor(176),[G1tensor(46),G1tensor(17)])
  call ol_merge_tensors(G1tensor(182),[G1tensor(48)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(357),G1tensor(58)])
  call ol_merge_tensors(G1tensor(200),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(351),G1tensor(30)])
  call ol_merge_tensors(G1tensor(212),[G1tensor(33)])
  call ol_merge_tensors(G1tensor(218),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(114),[G1tensor(224),G1tensor(41)])
  call ol_merge_tensors(G1tensor(230),[G1tensor(45)])
  call ol_merge_tensors(G1tensor(236),[G1tensor(59),G1tensor(47)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(333),G1tensor(53)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(242),G1tensor(60)])
  call ol_merge_tensors(G1tensor(248),[G1tensor(57)])
  call ol_merge_tensors(G1tensor(75),[G1tensor(64)])
  call ol_merge_tensors(G1tensor(173),[G1tensor(81),G1tensor(65)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(328),G1tensor(118),G1tensor(76),G1tensor(70)])
  call ol_merge_tensors(G1tensor(179),[G1tensor(124),G1tensor(82),G1tensor(71)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(281),G1tensor(185),G1tensor(83),G1tensor(77)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(84)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(225),G1tensor(93),G1tensor(87)])
  call ol_merge_tensors(G1tensor(99),[G1tensor(88)])
  call ol_merge_tensors(G1tensor(131),[G1tensor(105),G1tensor(89)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(292),G1tensor(232),G1tensor(100),G1tensor(94)])
  call ol_merge_tensors(G1tensor(238),[G1tensor(137),G1tensor(106),G1tensor(95)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(317),G1tensor(143),G1tensor(107),G1tensor(101)])
  call ol_merge_tensors(G1tensor(117),[G1tensor(112)])
  call ol_merge_tensors(G1tensor(215),[G1tensor(123),G1tensor(113)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(293),G1tensor(221),G1tensor(125),G1tensor(119)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(126)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(243),G1tensor(135),G1tensor(129)])
  call ol_merge_tensors(G1tensor(141),[G1tensor(130)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(280),G1tensor(250),G1tensor(142),G1tensor(136)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(153),G1tensor(147)])
  call ol_merge_tensors(G1tensor(159),[G1tensor(148)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(165),G1tensor(149)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(286),G1tensor(160),G1tensor(154)])
  call ol_merge_tensors(G2tensor(140),[G1tensor(166),G1tensor(155)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(323),G1tensor(167),G1tensor(161)])
  call ol_merge_tensors(G1tensor(183),[G1tensor(172)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(316),G1tensor(220),G1tensor(184),G1tensor(178)])
  call ol_merge_tensors(G1tensor(201),[G1tensor(190)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(207),G1tensor(191)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(322),G1tensor(202),G1tensor(196)])
  call ol_merge_tensors(G2tensor(143),[G1tensor(208),G1tensor(197)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(287),G1tensor(209),G1tensor(203)])
  call ol_merge_tensors(G1tensor(219),[G1tensor(214)])
  call ol_merge_tensors(G1tensor(231),[G1tensor(226)])
  call ol_merge_tensors(G1tensor(245),[G1tensor(237),G1tensor(227)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(329),G1tensor(251),G1tensor(239),G1tensor(233)])
  call ol_merge_tensors(G1tensor(249),[G1tensor(244)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(254)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(255)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(256)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(257)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(260)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(261)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(262)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(263)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(266)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(267)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(268)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(269)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(272)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(273)])
  call ol_merge_tensors(G2tensor(122),[G1tensor(274)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(275)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(279)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(285)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(291)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(297)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(310),G1tensor(298)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(299)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(303)])
  call ol_merge_tensors(G2tensor(146),[G1tensor(304)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(305)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(309)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(311)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(315)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(321)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(327)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(334)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(347),G1tensor(335)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(340)])
  call ol_merge_tensors(G2tensor(149),[G1tensor(341)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(346)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(352)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(365),G1tensor(353)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(358)])
  call ol_merge_tensors(G2tensor(152),[G1tensor(359)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(364)])
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(110),mass4set(:,15),  & 
G1tensor(39),G1tensor(51),G1tensor(61),G1tensor(67),G1tensor(73))
  call G_TensorShift(G1tensor(51),12)
  call Hotf_4pt_reduction_last(G2tensor(155),RedSet_4(110),mass4set(:,9),  & 
G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103))
  call G_TensorShift(G1tensor(85),12)
  call Hotf_4pt_reduction_last(G2tensor(176),RedSet_4(90),mass4set(:,14),  & 
G1tensor(109),G1tensor(115),G1tensor(121),G1tensor(127),G1tensor(133))
  call G_TensorShift(G1tensor(115),12)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(104),mass4set(:,14),  & 
G1tensor(139),G1tensor(145),G1tensor(151),G1tensor(157),G1tensor(163))
  call G_TensorShift(G1tensor(145),12)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(95),mass4set(:,1),  & 
G1tensor(169),G1tensor(175),G1tensor(181),G1tensor(187),G1tensor(193))
  call G_TensorShift(G1tensor(175),4)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(46),mass4set(:,7),  & 
G1tensor(199),G1tensor(205),G1tensor(211),G1tensor(217),G1tensor(223))
  call G_TensorShift(G1tensor(205),20)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(28),mass4set(:,16),  & 
G1tensor(229),G1tensor(235),G1tensor(241),G1tensor(247),G1tensor(253))
  call G_TensorShift(G1tensor(235),28)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(98),mass4set(:,1),  & 
G1tensor(259),G1tensor(265),G1tensor(271),G1tensor(277),G1tensor(283))
  call G_TensorShift(G1tensor(265),1)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(56),mass4set(:,7),  & 
G1tensor(289),G1tensor(295),G1tensor(301),G1tensor(307),G1tensor(313))
  call G_TensorShift(G1tensor(295),17)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(86),mass4set(:,14),  & 
G1tensor(319),G1tensor(325),G1tensor(331),G1tensor(337),G1tensor(343))
  call G_TensorShift(G1tensor(325),3)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(13),mass4set(:,16),  & 
G1tensor(349),G1tensor(355),G1tensor(361),G1tensor(270),G1tensor(258))
  call G_TensorShift(G1tensor(355),19)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(148),mass4set(:,17),  & 
G1tensor(264),G1tensor(36),G1tensor(164),G1tensor(11),G1tensor(21))
  call G_TensorShift(G1tensor(36),4)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(117),mass4set(:,18),  & 
G1tensor(276),G1tensor(152),G1tensor(52),G1tensor(156),G1tensor(306))
  call G_TensorShift(G1tensor(152),20)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(148),mass4set(:,5),  & 
G1tensor(168),G1tensor(194),G1tensor(23),G1tensor(198),G1tensor(206))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(117),mass4set(:,19),  & 
G1tensor(28),G1tensor(210),G1tensor(278),G1tensor(282),G1tensor(284))
  call G_TensorShift(G1tensor(210),20)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(136),mass4set(:,17),  & 
G1tensor(288),G1tensor(290),G1tensor(294),G1tensor(296),G1tensor(213))
  call G_TensorShift(G1tensor(290),8)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(120),mass4set(:,18),  & 
G1tensor(177),G1tensor(171),G1tensor(300),G1tensor(108),G1tensor(302))
  call G_TensorShift(G1tensor(171),24)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(51),mass4set(:,20),  & 
G1tensor(195),G1tensor(189),G1tensor(308),G1tensor(111),G1tensor(69))
  call G_TensorShift(G1tensor(189),16)
  call Hotf_4pt_reduction_last(G2tensor(110),RedSet_4(28),mass4set(:,20),  & 
G1tensor(63),G1tensor(312),G1tensor(240),G1tensor(314),G1tensor(318))
  call G_TensorShift(G1tensor(312),28)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(51),mass4set(:,16),  & 
G1tensor(320),G1tensor(324),G1tensor(326),G1tensor(330),G1tensor(332))
  call G_TensorShift(G1tensor(324),16)
  call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(1),mass4set(:,20),  & 
G1tensor(62),G1tensor(13),G1tensor(336),G1tensor(338),G1tensor(188))
  call G_TensorShift(G1tensor(13),16)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(74),mass4set(:,20),  & 
G1tensor(22),G1tensor(342),G1tensor(344),G1tensor(170),G1tensor(15))
  call G_TensorShift(G1tensor(342),28)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(149),mass4set(:,17),  & 
G1tensor(348),G1tensor(350),G1tensor(86),G1tensor(49),G1tensor(354))
  call G_TensorShift(G1tensor(350),1)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(129),mass4set(:,18),  & 
G1tensor(356),G1tensor(146),G1tensor(9),G1tensor(360),G1tensor(362))
  call G_TensorShift(G1tensor(146),17)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(149),mass4set(:,5),  & 
G1tensor(128),G1tensor(3),G1tensor(366),G1tensor(32),G1tensor(19))
  call G_TensorShift(G1tensor(3),1)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(129),mass4set(:,19),  & 
G1tensor(25),G1tensor(18),G1tensor(31),G1tensor(43),G1tensor(42))
  call G_TensorShift(G1tensor(18),17)
  call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(143),mass4set(:,17),  & 
G1tensor(55),G1tensor(2),G1tensor(5),G1tensor(8),G1tensor(26))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(132),mass4set(:,18),  & 
G1tensor(38),G1tensor(35),G1tensor(44),G1tensor(345),G1tensor(56))
  call G_TensorShift(G1tensor(35),18)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(83),mass4set(:,21),  & 
G1tensor(54),G1tensor(16),G1tensor(4),G1tensor(339),G1tensor(6))
  call G_TensorShift(G1tensor(16),2)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(137),mass4set(:,13),  & 
G1tensor(158),G1tensor(10),G1tensor(363),G1tensor(12),G1tensor(46))
  call G_TensorShift(G1tensor(10),10)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(97),mass4set(:,22),  & 
G1tensor(17),G1tensor(48),G1tensor(357),G1tensor(58),G1tensor(27))
  call G_TensorShift(G1tensor(48),1)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(140),mass4set(:,12),  & 
G1tensor(351),G1tensor(30),G1tensor(33),G1tensor(34),G1tensor(40))
  call G_TensorShift(G1tensor(30),9)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(97),mass4set(:,21),  & 
G1tensor(224),G1tensor(41),G1tensor(45),G1tensor(59),G1tensor(47))
  call G_TensorShift(G1tensor(41),1)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(140),mass4set(:,13),  & 
G1tensor(333),G1tensor(53),G1tensor(242),G1tensor(60),G1tensor(57))
  call G_TensorShift(G1tensor(53),9)
  call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(87),mass4set(:,21),  & 
G1tensor(64),G1tensor(81),G1tensor(65),G1tensor(328),G1tensor(118))
  call G_TensorShift(G1tensor(81),8)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(144),mass4set(:,13),  & 
G1tensor(76),G1tensor(70),G1tensor(124),G1tensor(82),G1tensor(71))
  call G_TensorShift(G1tensor(70),10)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(94),mass4set(:,22),  & 
G1tensor(281),G1tensor(185),G1tensor(83),G1tensor(77),G1tensor(84))
  call G_TensorShift(G1tensor(185),4)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(147),mass4set(:,12),  & 
G1tensor(225),G1tensor(93),G1tensor(87),G1tensor(88),G1tensor(105))
  call G_TensorShift(G1tensor(93),6)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(94),mass4set(:,21),  & 
G1tensor(89),G1tensor(292),G1tensor(232),G1tensor(100),G1tensor(94))
  call G_TensorShift(G1tensor(292),4)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(147),mass4set(:,13),  & 
G1tensor(137),G1tensor(106),G1tensor(95),G1tensor(317),G1tensor(143))
  call G_TensorShift(G1tensor(106),6)
  call Hotf_4pt_reduction_last(G2tensor(118),RedSet_4(150),mass4set(:,20),  & 
G1tensor(107),G1tensor(101),G1tensor(112),G1tensor(123),G1tensor(113))
  call G_TensorShift(G1tensor(101),4)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(138),mass4set(:,20),  & 
G1tensor(293),G1tensor(221),G1tensor(125),G1tensor(119),G1tensor(126))
  call G_TensorShift(G1tensor(221),8)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(138),mass4set(:,16),  & 
G1tensor(243),G1tensor(135),G1tensor(129),G1tensor(130),G1tensor(280))
  call G_TensorShift(G1tensor(135),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(96),mass4set(:,5),  & 
G1tensor(250),G1tensor(142),G1tensor(136),G1tensor(153),G1tensor(147))
  call G_TensorShift(G1tensor(142),4)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(145),mass4set(:,20),  & 
G1tensor(148),G1tensor(165),G1tensor(149),G1tensor(286),G1tensor(160))
  call G_TensorShift(G1tensor(165),2)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(145),mass4set(:,16),  & 
G1tensor(154),G1tensor(166),G1tensor(155),G1tensor(323),G1tensor(167))
  call G_TensorShift(G1tensor(166),2)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(141),mass4set(:,20),  & 
G1tensor(161),G1tensor(172),G1tensor(316),G1tensor(220),G1tensor(184))
  call G_TensorShift(G1tensor(172),2)
  call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(151),mass4set(:,20),  & 
G1tensor(178),G1tensor(190),G1tensor(207),G1tensor(191),G1tensor(322))
  call G_TensorShift(G1tensor(190),4)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(102),mass4set(:,21),  & 
G1tensor(202),G1tensor(196),G1tensor(208),G1tensor(197),G1tensor(287))
  call G_TensorShift(G1tensor(196),8)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(134),mass4set(:,20),  & 
G1tensor(209),G1tensor(203),G1tensor(214),G1tensor(226),G1tensor(237))
  call G_TensorShift(G1tensor(203),8)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(105),mass4set(:,21),  & 
G1tensor(227),G1tensor(329),G1tensor(251),G1tensor(239),G1tensor(233))
  call G_TensorShift(G1tensor(329),4)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(6),mass4set(:,20),  & 
G1tensor(244),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(10),mass4set(:,20),  & 
G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(266))
  call G_TensorShift(G1tensor(261),16)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(13),mass4set(:,20),  & 
G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(272),G1tensor(273))
  call G_TensorShift(G1tensor(268),19)
  call Hotf_4pt_reduction_last(G2tensor(108),RedSet_4(16),mass4set(:,20),  & 
G1tensor(274),G1tensor(275),G1tensor(279),G1tensor(285),G1tensor(291))
  call G_TensorShift(G1tensor(275),16)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(21),mass4set(:,20),  & 
G1tensor(297),G1tensor(310),G1tensor(298),G1tensor(299),G1tensor(303))
  call G_TensorShift(G1tensor(310),16)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(25),mass4set(:,20),  & 
G1tensor(304),G1tensor(305),G1tensor(309),G1tensor(311),G1tensor(315))
  call G_TensorShift(G1tensor(305),16)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(35),mass4set(:,20),  & 
G1tensor(321),G1tensor(327),G1tensor(334),G1tensor(347),G1tensor(335))
  call G_TensorShift(G1tensor(327),16)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(38),mass4set(:,20),  & 
G1tensor(340),G1tensor(341),G1tensor(346),G1tensor(352),G1tensor(365))
  call G_TensorShift(G1tensor(341),19)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(41),mass4set(:,20),  & 
G1tensor(353),G1tensor(358),G1tensor(359),G1tensor(364),G1tensor(367))
  call G_TensorShift(G1tensor(358),16)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(45),mass4set(:,20),  & 
G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(369),16)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(41),mass4set(:,16),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(18),mass4set(:,8),  & 
G1tensor(378),G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382))
  call G_TensorShift(G1tensor(379),16)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(45),mass4set(:,16),  & 
G1tensor(383),G1tensor(384),G1tensor(385),G1tensor(386),G1tensor(387))
  call G_TensorShift(G1tensor(384),16)
  call Hotf_4pt_reduction_last(G2tensor(140),RedSet_4(22),mass4set(:,6),  & 
G1tensor(388),G1tensor(389),G1tensor(390),G1tensor(391),G1tensor(392))
  call G_TensorShift(G1tensor(389),16)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(25),mass4set(:,16),  & 
G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396),G1tensor(397))
  call G_TensorShift(G1tensor(394),16)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(55),mass4set(:,20),  & 
G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(399),16)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(3),mass4set(:,8),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407))
  call G_TensorShift(G1tensor(404),16)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(55),mass4set(:,16),  & 
G1tensor(408),G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412))
  call G_TensorShift(G1tensor(409),16)
  call Hotf_4pt_reduction_last(G2tensor(143),RedSet_4(7),mass4set(:,6),  & 
G1tensor(413),G1tensor(414),G1tensor(415),G1tensor(416),G1tensor(417))
  call G_TensorShift(G1tensor(414),16)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(10),mass4set(:,16),  & 
G1tensor(418),G1tensor(419),G1tensor(420),G1tensor(421),G1tensor(422))
  call G_TensorShift(G1tensor(419),16)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(71),mass4set(:,20),  & 
G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426),G1tensor(427))
  call G_TensorShift(G1tensor(424),16)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(152),mass4set(:,11),  & 
G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(429),4)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(107),mass4set(:,21),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437))
  call G_TensorShift(G1tensor(434),8)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(108),mass4set(:,21),  & 
G1tensor(438),G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442))
  call G_TensorShift(G1tensor(439),8)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(109),mass4set(:,3),  & 
G1tensor(443),G1tensor(444),G1tensor(445),G1tensor(446),G1tensor(447))
  call G_TensorShift(G1tensor(444),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(152),mass4set(:,10),  & 
G1tensor(448),G1tensor(449),G1tensor(450),G1tensor(451),G1tensor(452))
  call G_TensorShift(G1tensor(449),4)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(107),mass4set(:,22),  & 
G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456),G1tensor(457))
  call G_TensorShift(G1tensor(454),8)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(108),mass4set(:,22),  & 
G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(459),8)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(109),mass4set(:,4),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467))
  call G_TensorShift(G1tensor(464),8)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(153),mass4set(:,11),  & 
G1tensor(468),G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472))
  call G_TensorShift(G1tensor(469),8)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(112),mass4set(:,21),  & 
G1tensor(473),G1tensor(474),G1tensor(475),G1tensor(476),G1tensor(477))
  call G_TensorShift(G1tensor(474),4)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(113),mass4set(:,21),  & 
G1tensor(478),G1tensor(479),G1tensor(480),G1tensor(481),G1tensor(482))
  call G_TensorShift(G1tensor(479),4)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(114),mass4set(:,3),  & 
G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486),G1tensor(487))
  call G_TensorShift(G1tensor(484),4)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(151),mass4set(:,16),  & 
G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(489),4)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(102),mass4set(:,22),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497))
  call G_TensorShift(G1tensor(494),8)
  call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(88),mass4set(:,1),  & 
G1tensor(498),G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502))
  call G_TensorShift(G1tensor(499),8)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(103),mass4set(:,5),  & 
G1tensor(503),G1tensor(504),G1tensor(505),G1tensor(506),G1tensor(507))
  call G_TensorShift(G1tensor(504),8)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(116),mass4set(:,11),  & 
G1tensor(508),G1tensor(509),G1tensor(510),G1tensor(511),G1tensor(512))
  call G_TensorShift(G1tensor(509),16)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(116),mass4set(:,10),  & 
G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516),G1tensor(517))
  call G_TensorShift(G1tensor(514),16)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(119),mass4set(:,11),  & 
G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(519),16)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(122),mass4set(:,13),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527))
  call G_TensorShift(G1tensor(524),12)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(110),mass4set(:,23),  & 
G1tensor(528),G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532))
  call G_TensorShift(G1tensor(529),12)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(123),mass4set(:,18),  & 
G1tensor(533),G1tensor(534),G1tensor(535),G1tensor(536),G1tensor(537))
  call G_TensorShift(G1tensor(534),12)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(122),mass4set(:,12),  & 
G1tensor(538),G1tensor(539),G1tensor(540),G1tensor(541),G1tensor(542))
  call G_TensorShift(G1tensor(539),12)
  call Hotf_4pt_reduction_last(G2tensor(146),RedSet_4(110),mass4set(:,7),  & 
G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546),G1tensor(547))
  call G_TensorShift(G1tensor(544),12)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(123),mass4set(:,19),  & 
G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(549),12)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(125),mass4set(:,13),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557))
  call G_TensorShift(G1tensor(554),12)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(126),mass4set(:,18),  & 
G1tensor(558),G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562))
  call G_TensorShift(G1tensor(559),12)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(128),mass4set(:,11),  & 
G1tensor(563),G1tensor(564),G1tensor(565),G1tensor(566),G1tensor(567))
  call G_TensorShift(G1tensor(564),16)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(128),mass4set(:,10),  & 
G1tensor(568),G1tensor(569),G1tensor(570),G1tensor(571),G1tensor(572))
  call G_TensorShift(G1tensor(569),16)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(131),mass4set(:,11),  & 
G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576),G1tensor(577))
  call G_TensorShift(G1tensor(574),16)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(135),mass4set(:,11),  & 
G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581),G1tensor(582))
  call G_TensorShift(G1tensor(579),8)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(136),mass4set(:,24),  & 
G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586),G1tensor(587))
  call G_TensorShift(G1tensor(584),8)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(139),mass4set(:,10),  & 
G1tensor(588),G1tensor(589),G1tensor(590),G1tensor(591),G1tensor(592))
  call G_TensorShift(G1tensor(589),8)
  call Hotf_4pt_reduction_last(G2tensor(149),RedSet_4(136),mass4set(:,8),  & 
G1tensor(593),G1tensor(594),G1tensor(595),G1tensor(596),G1tensor(597))
  call G_TensorShift(G1tensor(594),8)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(139),mass4set(:,11),  & 
G1tensor(598),G1tensor(599),G1tensor(600),G1tensor(601),G1tensor(602))
  call G_TensorShift(G1tensor(599),8)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(142),mass4set(:,11),  & 
G1tensor(603),G1tensor(604),G1tensor(605),G1tensor(606),G1tensor(607))
  call G_TensorShift(G1tensor(604),2)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(143),mass4set(:,24),  & 
G1tensor(608),G1tensor(609),G1tensor(610),G1tensor(611),G1tensor(612))
  call G_TensorShift(G1tensor(609),2)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(146),mass4set(:,10),  & 
G1tensor(613),G1tensor(614),G1tensor(615),G1tensor(616),G1tensor(617))
  call G_TensorShift(G1tensor(614),2)
  call Hotf_4pt_reduction_last(G2tensor(152),RedSet_4(143),mass4set(:,8),  & 
G1tensor(618),G1tensor(619),G1tensor(620),G1tensor(621),G1tensor(622))
  call G_TensorShift(G1tensor(619),2)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(146),mass4set(:,11),  & 
G1tensor(623),G1tensor(624),G1tensor(625),G1tensor(626),G1tensor(627))
  call G_TensorShift(G1tensor(624),2)
  call Hotf_4pt_reduction_last(G2tensor(124),RedSet_4(7),mass4set(:,2),  & 
G1tensor(628),G1tensor(629),G1tensor(630),G1tensor(631),G1tensor(632))
  call G_TensorShift(G1tensor(629),16)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(7),mass4set(:,3),  & 
G1tensor(633),G1tensor(634),G1tensor(635),G1tensor(636),G1tensor(637))
  call G_TensorShift(G1tensor(634),16)
  call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(7),mass4set(:,4),  & 
G1tensor(638),G1tensor(639),G1tensor(640),G1tensor(641),G1tensor(642))
  call G_TensorShift(G1tensor(639),16)
  call Hotf_4pt_reduction_last(G2tensor(130),RedSet_4(22),mass4set(:,2),  & 
G1tensor(643),G1tensor(644),G1tensor(645),G1tensor(646),G1tensor(647))
  call G_TensorShift(G1tensor(644),16)
  call Hotf_4pt_reduction_last(G2tensor(132),RedSet_4(22),mass4set(:,3),  & 
G1tensor(648),G1tensor(649),G1tensor(650),G1tensor(651),G1tensor(652))
  call G_TensorShift(G1tensor(649),16)
  call Hotf_4pt_reduction_last(G2tensor(134),RedSet_4(22),mass4set(:,4),  & 
G1tensor(653),G1tensor(654),G1tensor(655),G1tensor(656),G1tensor(657))
  call G_TensorShift(G1tensor(654),16)
  call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(136),mass4set(:,5),  & 
G1tensor(658),G1tensor(659),G1tensor(660),G1tensor(661),G1tensor(662))
  call G_TensorShift(G1tensor(659),8)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(143),mass4set(:,5),  & 
G1tensor(663),G1tensor(664),G1tensor(665),G1tensor(666),G1tensor(667))
  call G_TensorShift(G1tensor(664),2)
  call Hotf_4pt_reduction_last(G2tensor(158),RedSet_4(88),mass4set(:,10),  & 
G1tensor(668),G1tensor(669),G1tensor(670),G1tensor(671),G1tensor(672))
  call G_TensorShift(G1tensor(669),8)
  call Hotf_4pt_reduction_last(G2tensor(161),RedSet_4(88),mass4set(:,11),  & 
G1tensor(673),G1tensor(674),G1tensor(675),G1tensor(676),G1tensor(677))
  call G_TensorShift(G1tensor(674),8)
  call Hotf_4pt_reduction_last(G2tensor(164),RedSet_4(95),mass4set(:,10),  & 
G1tensor(678),G1tensor(679),G1tensor(680),G1tensor(681),G1tensor(682))
  call G_TensorShift(G1tensor(679),4)
  call Hotf_4pt_reduction_last(G2tensor(167),RedSet_4(95),mass4set(:,11),  & 
G1tensor(683),G1tensor(684),G1tensor(685),G1tensor(686),G1tensor(687))
  call G_TensorShift(G1tensor(684),4)
  call Hotf_4pt_reduction_last(G2tensor(170),RedSet_4(90),mass4set(:,12),  & 
G1tensor(688),G1tensor(689),G1tensor(690),G1tensor(691),G1tensor(692))
  call G_TensorShift(G1tensor(689),12)
  call Hotf_4pt_reduction_last(G2tensor(173),RedSet_4(90),mass4set(:,13),  & 
G1tensor(693),G1tensor(694),G1tensor(695),G1tensor(696),G1tensor(697))
  call G_TensorShift(G1tensor(694),12)
  call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(104),mass4set(:,12),  & 
G1tensor(698),G1tensor(699),G1tensor(700),G1tensor(701),G1tensor(702))
  call G_TensorShift(G1tensor(699),12)
  call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(104),mass4set(:,13),  & 
G1tensor(703),G1tensor(704),G1tensor(705),G1tensor(706),G1tensor(707))
  call G_TensorShift(G1tensor(704),12)
  call Hotf_4pt_reduction_last(G1tensor(39),RedSet_4(110),mass4set(:,15),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(79),RedSet_4(110),mass4set(:,9),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(109),RedSet_4(90),mass4set(:,14),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(139),RedSet_4(104),mass4set(:,14),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(169),RedSet_4(95),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(199),RedSet_4(46),mass4set(:,7),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(229),RedSet_4(28),mass4set(:,16),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(259),RedSet_4(98),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(289),RedSet_4(56),mass4set(:,7),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(319),RedSet_4(86),mass4set(:,14),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(349),RedSet_4(13),mass4set(:,16),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(264),RedSet_4(148),mass4set(:,17),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(117),mass4set(:,18),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(168),RedSet_4(148),mass4set(:,5),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(117),mass4set(:,19),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(288),RedSet_4(136),mass4set(:,17),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(177),RedSet_4(120),mass4set(:,18),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(195),RedSet_4(51),mass4set(:,20),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(63),RedSet_4(28),mass4set(:,20),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(320),RedSet_4(51),mass4set(:,16),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(62),RedSet_4(1),mass4set(:,20),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(74),mass4set(:,20),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(348),RedSet_4(149),mass4set(:,17),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(129),mass4set(:,18),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(128),RedSet_4(149),mass4set(:,5),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(25),RedSet_4(129),mass4set(:,19),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(55),RedSet_4(143),mass4set(:,17),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(132),mass4set(:,18),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(54),RedSet_4(83),mass4set(:,21),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(158),RedSet_4(137),mass4set(:,13),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(97),mass4set(:,22),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(140),mass4set(:,12),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(224),RedSet_4(97),mass4set(:,21),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(333),RedSet_4(140),mass4set(:,13),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(64),RedSet_4(87),mass4set(:,21),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(144),mass4set(:,13),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(94),mass4set(:,22),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(225),RedSet_4(147),mass4set(:,12),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(89),RedSet_4(94),mass4set(:,21),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(137),RedSet_4(147),mass4set(:,13),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(7),RedSet_4(154),mass4set(:,20),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(68),RedSet_4(84),mass4set(:,25),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(74),RedSet_4(85),mass4set(:,17),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(80),RedSet_4(86),mass4set(:,26),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(107),RedSet_4(150),mass4set(:,20),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(92),RedSet_4(88),mass4set(:,25),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(98),RedSet_4(89),mass4set(:,17),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(104),RedSet_4(90),mass4set(:,26),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(155),mass4set(:,20),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(110),RedSet_4(91),mass4set(:,21),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(92),mass4set(:,17),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(122),RedSet_4(93),mass4set(:,26),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(293),RedSet_4(138),mass4set(:,20),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(134),RedSet_4(95),mass4set(:,25),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(140),RedSet_4(96),mass4set(:,17),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(243),RedSet_4(138),mass4set(:,16),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(250),RedSet_4(96),mass4set(:,5),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(148),RedSet_4(145),mass4set(:,20),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(98),mass4set(:,25),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(182),RedSet_4(99),mass4set(:,17),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(154),RedSet_4(145),mass4set(:,16),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(200),RedSet_4(99),mass4set(:,5),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(141),mass4set(:,20),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(212),RedSet_4(100),mass4set(:,21),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(218),RedSet_4(101),mass4set(:,17),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(178),RedSet_4(151),mass4set(:,20),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(202),RedSet_4(102),mass4set(:,21),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(230),RedSet_4(103),mass4set(:,17),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(104),mass4set(:,26),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(209),RedSet_4(134),mass4set(:,20),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(227),RedSet_4(105),mass4set(:,21),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(248),RedSet_4(106),mass4set(:,17),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(75),RedSet_4(2),mass4set(:,11),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(173),RedSet_4(3),mass4set(:,24),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(4),mass4set(:,13),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(244),RedSet_4(6),mass4set(:,20),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(179),RedSet_4(7),mass4set(:,27),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(72),RedSet_4(8),mass4set(:,23),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(260),RedSet_4(10),mass4set(:,20),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(78),RedSet_4(11),mass4set(:,18),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(267),RedSet_4(13),mass4set(:,20),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(274),RedSet_4(16),mass4set(:,20),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(99),RedSet_4(17),mass4set(:,11),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(18),mass4set(:,24),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(90),RedSet_4(19),mass4set(:,13),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(297),RedSet_4(21),mass4set(:,20),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(238),RedSet_4(22),mass4set(:,27),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(23),mass4set(:,23),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(304),RedSet_4(25),mass4set(:,20),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(102),RedSet_4(26),mass4set(:,18),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(117),RedSet_4(31),mass4set(:,11),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(215),RedSet_4(32),mass4set(:,24),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(114),RedSet_4(33),mass4set(:,13),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(321),RedSet_4(35),mass4set(:,20),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(120),RedSet_4(36),mass4set(:,18),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(340),RedSet_4(38),mass4set(:,20),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(353),RedSet_4(41),mass4set(:,20),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(42),mass4set(:,11),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call Hotf_4pt_reduction_last(G1tensor(132),RedSet_4(43),mass4set(:,13),  & 
G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495))
  call Hotf_4pt_reduction_last(G1tensor(368),RedSet_4(45),mass4set(:,20),  & 
G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500))
  call Hotf_4pt_reduction_last(G1tensor(138),RedSet_4(46),mass4set(:,23),  & 
G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505))
  call Hotf_4pt_reduction_last(G1tensor(144),RedSet_4(48),mass4set(:,18),  & 
G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510))
  call Hotf_4pt_reduction_last(G1tensor(373),RedSet_4(41),mass4set(:,16),  & 
G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515))
  call Hotf_4pt_reduction_last(G1tensor(159),RedSet_4(42),mass4set(:,10),  & 
G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520))
  call Hotf_4pt_reduction_last(G1tensor(378),RedSet_4(18),mass4set(:,8),  & 
G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525))
  call Hotf_4pt_reduction_last(G1tensor(150),RedSet_4(43),mass4set(:,12),  & 
G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530))
  call Hotf_4pt_reduction_last(G1tensor(383),RedSet_4(45),mass4set(:,16),  & 
G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),G0tensor(535))
  call Hotf_4pt_reduction_last(G1tensor(388),RedSet_4(22),mass4set(:,6),  & 
G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),G0tensor(540))
  call Hotf_4pt_reduction_last(G1tensor(393),RedSet_4(25),mass4set(:,16),  & 
G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544),G0tensor(545))
  call Hotf_4pt_reduction_last(G1tensor(162),RedSet_4(48),mass4set(:,19),  & 
G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549),G0tensor(550))
  call Hotf_4pt_reduction_last(G1tensor(183),RedSet_4(52),mass4set(:,11),  & 
G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554),G0tensor(555))
  call Hotf_4pt_reduction_last(G1tensor(174),RedSet_4(53),mass4set(:,13),  & 
G0tensor(556),G0tensor(557),G0tensor(558),G0tensor(559),G0tensor(560))
  call Hotf_4pt_reduction_last(G1tensor(398),RedSet_4(55),mass4set(:,20),  & 
G0tensor(561),G0tensor(562),G0tensor(563),G0tensor(564),G0tensor(565))
  call Hotf_4pt_reduction_last(G1tensor(180),RedSet_4(56),mass4set(:,23),  & 
G0tensor(566),G0tensor(567),G0tensor(568),G0tensor(569),G0tensor(570))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(58),mass4set(:,18),  & 
G0tensor(571),G0tensor(572),G0tensor(573),G0tensor(574),G0tensor(575))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(52),mass4set(:,10),  & 
G0tensor(576),G0tensor(577),G0tensor(578),G0tensor(579),G0tensor(580))
  call Hotf_4pt_reduction_last(G1tensor(403),RedSet_4(3),mass4set(:,8),  & 
G0tensor(581),G0tensor(582),G0tensor(583),G0tensor(584),G0tensor(585))
  call Hotf_4pt_reduction_last(G1tensor(192),RedSet_4(53),mass4set(:,12),  & 
G0tensor(586),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590))
  call Hotf_4pt_reduction_last(G1tensor(408),RedSet_4(55),mass4set(:,16),  & 
G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594),G0tensor(595))
  call Hotf_4pt_reduction_last(G1tensor(413),RedSet_4(7),mass4set(:,6),  & 
G0tensor(596),G0tensor(597),G0tensor(598),G0tensor(599),G0tensor(600))
  call Hotf_4pt_reduction_last(G1tensor(418),RedSet_4(10),mass4set(:,16),  & 
G0tensor(601),G0tensor(602),G0tensor(603),G0tensor(604),G0tensor(605))
  call Hotf_4pt_reduction_last(G1tensor(204),RedSet_4(58),mass4set(:,19),  & 
G0tensor(606),G0tensor(607),G0tensor(608),G0tensor(609),G0tensor(610))
  call Hotf_4pt_reduction_last(G1tensor(219),RedSet_4(61),mass4set(:,11),  & 
G0tensor(611),G0tensor(612),G0tensor(613),G0tensor(614),G0tensor(615))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(62),mass4set(:,13),  & 
G0tensor(616),G0tensor(617),G0tensor(618),G0tensor(619),G0tensor(620))
  call Hotf_4pt_reduction_last(G1tensor(222),RedSet_4(64),mass4set(:,18),  & 
G0tensor(621),G0tensor(622),G0tensor(623),G0tensor(624),G0tensor(625))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(67),mass4set(:,11),  & 
G0tensor(626),G0tensor(627),G0tensor(628),G0tensor(629),G0tensor(630))
  call Hotf_4pt_reduction_last(G1tensor(245),RedSet_4(68),mass4set(:,24),  & 
G0tensor(631),G0tensor(632),G0tensor(633),G0tensor(634),G0tensor(635))
  call Hotf_4pt_reduction_last(G1tensor(228),RedSet_4(69),mass4set(:,13),  & 
G0tensor(636),G0tensor(637),G0tensor(638),G0tensor(639),G0tensor(640))
  call Hotf_4pt_reduction_last(G1tensor(423),RedSet_4(71),mass4set(:,20),  & 
G0tensor(641),G0tensor(642),G0tensor(643),G0tensor(644),G0tensor(645))
  call Hotf_4pt_reduction_last(G1tensor(234),RedSet_4(72),mass4set(:,18),  & 
G0tensor(646),G0tensor(647),G0tensor(648),G0tensor(649),G0tensor(650))
  call Hotf_4pt_reduction_last(G1tensor(249),RedSet_4(77),mass4set(:,11),  & 
G0tensor(651),G0tensor(652),G0tensor(653),G0tensor(654),G0tensor(655))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(78),mass4set(:,13),  & 
G0tensor(656),G0tensor(657),G0tensor(658),G0tensor(659),G0tensor(660))
  call Hotf_4pt_reduction_last(G1tensor(252),RedSet_4(80),mass4set(:,18),  & 
G0tensor(661),G0tensor(662),G0tensor(663),G0tensor(664),G0tensor(665))
  call Hotf_4pt_reduction_last(G1tensor(428),RedSet_4(152),mass4set(:,11),  & 
G0tensor(666),G0tensor(667),G0tensor(668),G0tensor(669),G0tensor(670))
  call Hotf_4pt_reduction_last(G1tensor(433),RedSet_4(107),mass4set(:,21),  & 
G0tensor(671),G0tensor(672),G0tensor(673),G0tensor(674),G0tensor(675))
  call Hotf_4pt_reduction_last(G1tensor(438),RedSet_4(108),mass4set(:,21),  & 
G0tensor(676),G0tensor(677),G0tensor(678),G0tensor(679),G0tensor(680))
  call Hotf_4pt_reduction_last(G1tensor(443),RedSet_4(109),mass4set(:,3),  & 
G0tensor(681),G0tensor(682),G0tensor(683),G0tensor(684),G0tensor(685))
  call Hotf_4pt_reduction_last(G1tensor(448),RedSet_4(152),mass4set(:,10),  & 
G0tensor(686),G0tensor(687),G0tensor(688),G0tensor(689),G0tensor(690))
  call Hotf_4pt_reduction_last(G1tensor(453),RedSet_4(107),mass4set(:,22),  & 
G0tensor(691),G0tensor(692),G0tensor(693),G0tensor(694),G0tensor(695))
  call Hotf_4pt_reduction_last(G1tensor(458),RedSet_4(108),mass4set(:,22),  & 
G0tensor(696),G0tensor(697),G0tensor(698),G0tensor(699),G0tensor(700))
  call Hotf_4pt_reduction_last(G1tensor(463),RedSet_4(109),mass4set(:,4),  & 
G0tensor(701),G0tensor(702),G0tensor(703),G0tensor(704),G0tensor(705))
  call Hotf_4pt_reduction_last(G1tensor(468),RedSet_4(153),mass4set(:,11),  & 
G0tensor(706),G0tensor(707),G0tensor(708),G0tensor(709),G0tensor(710))
  call Hotf_4pt_reduction_last(G1tensor(473),RedSet_4(112),mass4set(:,21),  & 
G0tensor(711),G0tensor(712),G0tensor(713),G0tensor(714),G0tensor(715))
  call Hotf_4pt_reduction_last(G1tensor(478),RedSet_4(113),mass4set(:,21),  & 
G0tensor(716),G0tensor(717),G0tensor(718),G0tensor(719),G0tensor(720))
  call Hotf_4pt_reduction_last(G1tensor(483),RedSet_4(114),mass4set(:,3),  & 
G0tensor(721),G0tensor(722),G0tensor(723),G0tensor(724),G0tensor(725))
  call Hotf_4pt_reduction_last(G1tensor(488),RedSet_4(151),mass4set(:,16),  & 
G0tensor(726),G0tensor(727),G0tensor(728),G0tensor(729),G0tensor(730))
  call Hotf_4pt_reduction_last(G1tensor(493),RedSet_4(102),mass4set(:,22),  & 
G0tensor(731),G0tensor(732),G0tensor(733),G0tensor(734),G0tensor(735))
  call Hotf_4pt_reduction_last(G1tensor(498),RedSet_4(88),mass4set(:,1),  & 
G0tensor(736),G0tensor(737),G0tensor(738),G0tensor(739),G0tensor(740))
  call Hotf_4pt_reduction_last(G1tensor(503),RedSet_4(103),mass4set(:,5),  & 
G0tensor(741),G0tensor(742),G0tensor(743),G0tensor(744),G0tensor(745))
  call Hotf_4pt_reduction_last(G1tensor(508),RedSet_4(116),mass4set(:,11),  & 
G0tensor(746),G0tensor(747),G0tensor(748),G0tensor(749),G0tensor(750))
  call Hotf_4pt_reduction_last(G1tensor(513),RedSet_4(116),mass4set(:,10),  & 
G0tensor(751),G0tensor(752),G0tensor(753),G0tensor(754),G0tensor(755))
  call Hotf_4pt_reduction_last(G1tensor(518),RedSet_4(119),mass4set(:,11),  & 
G0tensor(756),G0tensor(757),G0tensor(758),G0tensor(759),G0tensor(760))
  call Hotf_4pt_reduction_last(G1tensor(523),RedSet_4(122),mass4set(:,13),  & 
G0tensor(761),G0tensor(762),G0tensor(763),G0tensor(764),G0tensor(765))
  call Hotf_4pt_reduction_last(G1tensor(528),RedSet_4(110),mass4set(:,23),  & 
G0tensor(766),G0tensor(767),G0tensor(768),G0tensor(769),G0tensor(770))
  call Hotf_4pt_reduction_last(G1tensor(533),RedSet_4(123),mass4set(:,18),  & 
G0tensor(771),G0tensor(772),G0tensor(773),G0tensor(774),G0tensor(775))
  call Hotf_4pt_reduction_last(G1tensor(538),RedSet_4(122),mass4set(:,12),  & 
G0tensor(776),G0tensor(777),G0tensor(778),G0tensor(779),G0tensor(780))
  call Hotf_4pt_reduction_last(G1tensor(543),RedSet_4(110),mass4set(:,7),  & 
G0tensor(781),G0tensor(782),G0tensor(783),G0tensor(784),G0tensor(785))
  call Hotf_4pt_reduction_last(G1tensor(548),RedSet_4(123),mass4set(:,19),  & 
G0tensor(786),G0tensor(787),G0tensor(788),G0tensor(789),G0tensor(790))
  call Hotf_4pt_reduction_last(G1tensor(553),RedSet_4(125),mass4set(:,13),  & 
G0tensor(791),G0tensor(792),G0tensor(793),G0tensor(794),G0tensor(795))
  call Hotf_4pt_reduction_last(G1tensor(558),RedSet_4(126),mass4set(:,18),  & 
G0tensor(796),G0tensor(797),G0tensor(798),G0tensor(799),G0tensor(800))
  call Hotf_4pt_reduction_last(G1tensor(563),RedSet_4(128),mass4set(:,11),  & 
G0tensor(801),G0tensor(802),G0tensor(803),G0tensor(804),G0tensor(805))
  call Hotf_4pt_reduction_last(G1tensor(568),RedSet_4(128),mass4set(:,10),  & 
G0tensor(806),G0tensor(807),G0tensor(808),G0tensor(809),G0tensor(810))
  call Hotf_4pt_reduction_last(G1tensor(573),RedSet_4(131),mass4set(:,11),  & 
G0tensor(811),G0tensor(812),G0tensor(813),G0tensor(814),G0tensor(815))
  call Hotf_4pt_reduction_last(G1tensor(578),RedSet_4(135),mass4set(:,11),  & 
G0tensor(816),G0tensor(817),G0tensor(818),G0tensor(819),G0tensor(820))
  call Hotf_4pt_reduction_last(G1tensor(583),RedSet_4(136),mass4set(:,24),  & 
G0tensor(821),G0tensor(822),G0tensor(823),G0tensor(824),G0tensor(825))
  call Hotf_4pt_reduction_last(G1tensor(588),RedSet_4(139),mass4set(:,10),  & 
G0tensor(826),G0tensor(827),G0tensor(828),G0tensor(829),G0tensor(830))
  call Hotf_4pt_reduction_last(G1tensor(593),RedSet_4(136),mass4set(:,8),  & 
G0tensor(831),G0tensor(832),G0tensor(833),G0tensor(834),G0tensor(835))
  call Hotf_4pt_reduction_last(G1tensor(598),RedSet_4(139),mass4set(:,11),  & 
G0tensor(836),G0tensor(837),G0tensor(838),G0tensor(839),G0tensor(840))
  call Hotf_4pt_reduction_last(G1tensor(603),RedSet_4(142),mass4set(:,11),  & 
G0tensor(841),G0tensor(842),G0tensor(843),G0tensor(844),G0tensor(845))
  call Hotf_4pt_reduction_last(G1tensor(608),RedSet_4(143),mass4set(:,24),  & 
G0tensor(846),G0tensor(847),G0tensor(848),G0tensor(849),G0tensor(850))
  call Hotf_4pt_reduction_last(G1tensor(613),RedSet_4(146),mass4set(:,10),  & 
G0tensor(851),G0tensor(852),G0tensor(853),G0tensor(854),G0tensor(855))
  call Hotf_4pt_reduction_last(G1tensor(618),RedSet_4(143),mass4set(:,8),  & 
G0tensor(856),G0tensor(857),G0tensor(858),G0tensor(859),G0tensor(860))
  call Hotf_4pt_reduction_last(G1tensor(623),RedSet_4(146),mass4set(:,11),  & 
G0tensor(861),G0tensor(862),G0tensor(863),G0tensor(864),G0tensor(865))
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(7),mass4set(:,28),  & 
G0tensor(866),G0tensor(867),G0tensor(868),G0tensor(869),G0tensor(870))
  call Hotf_4pt_reduction_last(G1tensor(37),RedSet_4(22),mass4set(:,28),  & 
G0tensor(871),G0tensor(872),G0tensor(873),G0tensor(874),G0tensor(875))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(88),mass4set(:,29),  & 
G0tensor(876),G0tensor(877),G0tensor(878),G0tensor(879),G0tensor(880))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(95),mass4set(:,29),  & 
G0tensor(881),G0tensor(882),G0tensor(883),G0tensor(884),G0tensor(885))
  call Hotf_4pt_reduction_last(G1tensor(24),RedSet_4(90),mass4set(:,30),  & 
G0tensor(886),G0tensor(887),G0tensor(888),G0tensor(889),G0tensor(890))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(104),mass4set(:,30),  & 
G0tensor(891),G0tensor(892),G0tensor(893),G0tensor(894),G0tensor(895))
  call Hotf_4pt_reduction_last(G1tensor(628),RedSet_4(7),mass4set(:,2),  & 
G0tensor(896),G0tensor(897),G0tensor(898),G0tensor(899),G0tensor(900))
  call Hotf_4pt_reduction_last(G1tensor(633),RedSet_4(7),mass4set(:,3),  & 
G0tensor(901),G0tensor(902),G0tensor(903),G0tensor(904),G0tensor(905))
  call Hotf_4pt_reduction_last(G1tensor(638),RedSet_4(7),mass4set(:,4),  & 
G0tensor(906),G0tensor(907),G0tensor(908),G0tensor(909),G0tensor(910))
  call Hotf_4pt_reduction_last(G1tensor(643),RedSet_4(22),mass4set(:,2),  & 
G0tensor(911),G0tensor(912),G0tensor(913),G0tensor(914),G0tensor(915))
  call Hotf_4pt_reduction_last(G1tensor(648),RedSet_4(22),mass4set(:,3),  & 
G0tensor(916),G0tensor(917),G0tensor(918),G0tensor(919),G0tensor(920))
  call Hotf_4pt_reduction_last(G1tensor(653),RedSet_4(22),mass4set(:,4),  & 
G0tensor(921),G0tensor(922),G0tensor(923),G0tensor(924),G0tensor(925))
  call Hotf_4pt_reduction_last(G1tensor(658),RedSet_4(136),mass4set(:,5),  & 
G0tensor(926),G0tensor(927),G0tensor(928),G0tensor(929),G0tensor(930))
  call Hotf_4pt_reduction_last(G1tensor(663),RedSet_4(143),mass4set(:,5),  & 
G0tensor(931),G0tensor(932),G0tensor(933),G0tensor(934),G0tensor(935))
  call Hotf_4pt_reduction_last(G1tensor(668),RedSet_4(88),mass4set(:,10),  & 
G0tensor(936),G0tensor(937),G0tensor(938),G0tensor(939),G0tensor(940))
  call Hotf_4pt_reduction_last(G1tensor(673),RedSet_4(88),mass4set(:,11),  & 
G0tensor(941),G0tensor(942),G0tensor(943),G0tensor(944),G0tensor(945))
  call Hotf_4pt_reduction_last(G1tensor(678),RedSet_4(95),mass4set(:,10),  & 
G0tensor(946),G0tensor(947),G0tensor(948),G0tensor(949),G0tensor(950))
  call Hotf_4pt_reduction_last(G1tensor(683),RedSet_4(95),mass4set(:,11),  & 
G0tensor(951),G0tensor(952),G0tensor(953),G0tensor(954),G0tensor(955))
  call Hotf_4pt_reduction_last(G1tensor(688),RedSet_4(90),mass4set(:,12),  & 
G0tensor(956),G0tensor(957),G0tensor(958),G0tensor(959),G0tensor(960))
  call Hotf_4pt_reduction_last(G1tensor(693),RedSet_4(90),mass4set(:,13),  & 
G0tensor(961),G0tensor(962),G0tensor(963),G0tensor(964),G0tensor(965))
  call Hotf_4pt_reduction_last(G1tensor(698),RedSet_4(104),mass4set(:,12),  & 
G0tensor(966),G0tensor(967),G0tensor(968),G0tensor(969),G0tensor(970))
  call Hotf_4pt_reduction_last(G1tensor(703),RedSet_4(104),mass4set(:,13),  & 
G0tensor(971),G0tensor(972),G0tensor(973),G0tensor(974),G0tensor(975))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  call ol_merge_tensors(T0sum(89),[G0tensor(441)])
  call ol_merge_tensors(T0sum(90),[G0tensor(446)])
  call ol_merge_tensors(T0sum(91),[G0tensor(451)])
  call ol_merge_tensors(T0sum(92),[G0tensor(456)])
  call ol_merge_tensors(T0sum(93),[G0tensor(461)])
  call ol_merge_tensors(T0sum(94),[G0tensor(466)])
  call ol_merge_tensors(T0sum(95),[G0tensor(471)])
  call ol_merge_tensors(T0sum(96),[G0tensor(476)])
  call ol_merge_tensors(T0sum(97),[G0tensor(481)])
  call ol_merge_tensors(T0sum(98),[G0tensor(486)])
  call ol_merge_tensors(T0sum(99),[G0tensor(491)])
  call ol_merge_tensors(T0sum(100),[G0tensor(496)])
  call ol_merge_tensors(T0sum(101),[G0tensor(501)])
  call ol_merge_tensors(T0sum(102),[G0tensor(506)])
  call ol_merge_tensors(T0sum(103),[G0tensor(511)])
  call ol_merge_tensors(T0sum(104),[G0tensor(516)])
  call ol_merge_tensors(T0sum(105),[G0tensor(521)])
  call ol_merge_tensors(T0sum(106),[G0tensor(526)])
  call ol_merge_tensors(T0sum(107),[G0tensor(531)])
  call ol_merge_tensors(T0sum(108),[G0tensor(536)])
  call ol_merge_tensors(T0sum(109),[G0tensor(541)])
  call ol_merge_tensors(T0sum(110),[G0tensor(546)])
  call ol_merge_tensors(T0sum(111),[G0tensor(551)])
  call ol_merge_tensors(T0sum(112),[G0tensor(556)])
  call ol_merge_tensors(T0sum(113),[G0tensor(561)])
  call ol_merge_tensors(T0sum(114),[G0tensor(566)])
  call ol_merge_tensors(T0sum(115),[G0tensor(571)])
  call ol_merge_tensors(T0sum(116),[G0tensor(576)])
  call ol_merge_tensors(T0sum(117),[G0tensor(581)])
  call ol_merge_tensors(T0sum(118),[G0tensor(586)])
  call ol_merge_tensors(T0sum(119),[G0tensor(591)])
  call ol_merge_tensors(T0sum(120),[G0tensor(596)])
  call ol_merge_tensors(T0sum(121),[G0tensor(601)])
  call ol_merge_tensors(T0sum(122),[G0tensor(606)])
  call ol_merge_tensors(T0sum(123),[G0tensor(611)])
  call ol_merge_tensors(T0sum(124),[G0tensor(616)])
  call ol_merge_tensors(T0sum(125),[G0tensor(621)])
  call ol_merge_tensors(T0sum(126),[G0tensor(626)])
  call ol_merge_tensors(T0sum(127),[G0tensor(631)])
  call ol_merge_tensors(T0sum(128),[G0tensor(636)])
  call ol_merge_tensors(T0sum(129),[G0tensor(641)])
  call ol_merge_tensors(T0sum(130),[G0tensor(646)])
  call ol_merge_tensors(T0sum(131),[G0tensor(651)])
  call ol_merge_tensors(T0sum(132),[G0tensor(656)])
  call ol_merge_tensors(T0sum(133),[G0tensor(661)])
  call ol_merge_tensors(T0sum(134),[G0tensor(666)])
  call ol_merge_tensors(T0sum(135),[G0tensor(671)])
  call ol_merge_tensors(T0sum(136),[G0tensor(676)])
  call ol_merge_tensors(T0sum(137),[G0tensor(681)])
  call ol_merge_tensors(T0sum(138),[G0tensor(686)])
  call ol_merge_tensors(T0sum(139),[G0tensor(691)])
  call ol_merge_tensors(T0sum(140),[G0tensor(696)])
  call ol_merge_tensors(T0sum(141),[G0tensor(701)])
  call ol_merge_tensors(T0sum(142),[G0tensor(706)])
  call ol_merge_tensors(T0sum(143),[G0tensor(711)])
  call ol_merge_tensors(T0sum(144),[G0tensor(716)])
  call ol_merge_tensors(T0sum(145),[G0tensor(721)])
  call ol_merge_tensors(T0sum(146),[G0tensor(726)])
  call ol_merge_tensors(T0sum(147),[G0tensor(731)])
  call ol_merge_tensors(T0sum(148),[G0tensor(736)])
  call ol_merge_tensors(T0sum(149),[G0tensor(741)])
  call ol_merge_tensors(T0sum(150),[G0tensor(746)])
  call ol_merge_tensors(T0sum(151),[G0tensor(751)])
  call ol_merge_tensors(T0sum(152),[G0tensor(756)])
  call ol_merge_tensors(T0sum(153),[G0tensor(761)])
  call ol_merge_tensors(T0sum(154),[G0tensor(766)])
  call ol_merge_tensors(T0sum(155),[G0tensor(771)])
  call ol_merge_tensors(T0sum(156),[G0tensor(776)])
  call ol_merge_tensors(T0sum(157),[G0tensor(781)])
  call ol_merge_tensors(T0sum(158),[G0tensor(786)])
  call ol_merge_tensors(T0sum(159),[G0tensor(791)])
  call ol_merge_tensors(T0sum(160),[G0tensor(796)])
  call ol_merge_tensors(T0sum(161),[G0tensor(801)])
  call ol_merge_tensors(T0sum(162),[G0tensor(806)])
  call ol_merge_tensors(T0sum(163),[G0tensor(811)])
  call ol_merge_tensors(T0sum(164),[G0tensor(816)])
  call ol_merge_tensors(T0sum(165),[G0tensor(821)])
  call ol_merge_tensors(T0sum(166),[G0tensor(826)])
  call ol_merge_tensors(T0sum(167),[G0tensor(831)])
  call ol_merge_tensors(T0sum(168),[G0tensor(836)])
  call ol_merge_tensors(T0sum(169),[G0tensor(841)])
  call ol_merge_tensors(T0sum(170),[G0tensor(846)])
  call ol_merge_tensors(T0sum(171),[G0tensor(851)])
  call ol_merge_tensors(T0sum(172),[G0tensor(856)])
  call ol_merge_tensors(T0sum(173),[G0tensor(861)])
  call ol_merge_tensors(T0sum(174),[G0tensor(866)])
  call ol_merge_tensors(T0sum(175),[G0tensor(871)])
  call ol_merge_tensors(T0sum(176),[G0tensor(876)])
  call ol_merge_tensors(T0sum(177),[G0tensor(881)])
  call ol_merge_tensors(T0sum(178),[G0tensor(886)])
  call ol_merge_tensors(T0sum(179),[G0tensor(891)])
  call ol_merge_tensors(T0sum(180),[G0tensor(896)])
  call ol_merge_tensors(T0sum(181),[G0tensor(901)])
  call ol_merge_tensors(T0sum(182),[G0tensor(906)])
  call ol_merge_tensors(T0sum(183),[G0tensor(911)])
  call ol_merge_tensors(T0sum(184),[G0tensor(916)])
  call ol_merge_tensors(T0sum(185),[G0tensor(921)])
  call ol_merge_tensors(T0sum(186),[G0tensor(926)])
  call ol_merge_tensors(T0sum(187),[G0tensor(931)])
  call ol_merge_tensors(T0sum(188),[G0tensor(936)])
  call ol_merge_tensors(T0sum(189),[G0tensor(941)])
  call ol_merge_tensors(T0sum(190),[G0tensor(946)])
  call ol_merge_tensors(T0sum(191),[G0tensor(951)])
  call ol_merge_tensors(T0sum(192),[G0tensor(956)])
  call ol_merge_tensors(T0sum(193),[G0tensor(961)])
  call ol_merge_tensors(T0sum(194),[G0tensor(966)])
  call ol_merge_tensors(T0sum(195),[G0tensor(971)])
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,15,16],[nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,59),heltab2x64(:,:,129))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[51,4,8],[nMW,0,nMW],4,2,wf4(:,1),wf4(:,5))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,1),wf4(:,5),G0H4(5),m4h4x4x4(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[51,4,8],[nMW,0,nMW],4,2,wf4(:,1),wf4(:,3))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,1),wf4(:,3),G0H4(3),m4h4x4x4(:,2),heltab3x64(:,:,2))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[60,1,2],[nMW,0,nMW],4,2,wf4(:,2),wf4(:,5))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,2),wf4(:,5),G0H4(1),m4h4x4x4(:,3),heltab3x64(:,:,3))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[60,1,2],[nMW,0,nMW],4,2,wf4(:,2),wf4(:,3))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,2),wf4(:,3),G0H4(2),m4h4x4x4(:,4),heltab3x64(:,:,4))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,53),heltab2x64(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(7),48,0,G1H16(3),n2h16(58))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[48,3,12],[nML,nML,nML],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,54),heltab2x64(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(10),48,nML,G1H16(4),n2h16(59))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(3),m3h4x16(:,55),heltab2x64(:,:,132))
  call Hloop_Q_A(ntryL,G0H16(3),48,0,G1H16(8),n2h16(60))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[48,3,12],[nML,nML,nML],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(9),m3h4x16(:,56),heltab2x64(:,:,133))
  call Hloop_Q_A(ntryL,G0H16(9),48,nML,G1H16(11),n2h16(61))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(8),m3h4x16(:,57),heltab2x64(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(12),n2h16(62))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(12),m3h4x16(:,58),heltab2x64(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(12),48,nMT,G1H16(5),n2h16(63))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,59),heltab2x64(:,:,136))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(10),n2h16(64))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(2),m3h4x16(:,60),heltab2x64(:,:,137))
  call Hloop_Q_A(ntryL,G0H16(2),48,nMT,G1H16(14),n2h16(65))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,61),heltab2x64(:,:,138))
  call Hloop_A_Q(ntryL,G0H16(6),48,0,G1H16(17),n2h16(66))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(5),m3h4x16(:,62),heltab2x64(:,:,139))
  call Hloop_A_Q(ntryL,G0H16(5),48,nMB,G1H16(16),n2h16(67))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(13),m3h4x16(:,63),heltab2x64(:,:,140))
  call Hloop_Q_A(ntryL,G0H16(13),48,0,G1H16(19),n2h16(68))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,64),heltab2x64(:,:,141))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(22),n2h16(69))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(4),ngZn,m3h4x16(:,65),heltab2x64(:,:,142))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(21),n2h16(70))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZn,m3h4x16(:,66),heltab2x64(:,:,143))
  call Hloop_Q_A(ntryL,G0H16(7),48,0,G1H16(24),n2h16(71))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(10),ngZl,m3h4x16(:,67),heltab2x64(:,:,144))
  call Hloop_A_Q(ntryL,G0H16(10),48,0,G1H16(26),n2h16(72))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[48,3,12],[nML,nML,nML],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(3),ngZl,m3h4x16(:,68),heltab2x64(:,:,145))
  call Hloop_A_Q(ntryL,G0H16(3),48,nML,G1H16(28),n2h16(73))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(9),ngZl,m3h4x16(:,69),heltab2x64(:,:,146))
  call Hloop_Q_A(ntryL,G0H16(9),48,0,G1H16(1),n2h16(74))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[48,3,12],[nML,nML,nML],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(8),ngZl,m3h4x16(:,70),heltab2x64(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(8),48,nML,G1H16(6),n2h16(75))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(12),ngZu,m3h4x16(:,71),heltab2x64(:,:,148))
  call Hloop_A_Q(ntryL,G0H16(12),48,0,G1H16(9),n2h16(76))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(11),ngZu,m3h4x16(:,72),heltab2x64(:,:,149))
  call Hloop_A_Q(ntryL,G0H16(11),48,nMT,G1H16(2),n2h16(77))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(2),ngZu,m3h4x16(:,73),heltab2x64(:,:,150))
  call Hloop_Q_A(ntryL,G0H16(2),48,0,G1H16(7),n2h16(78))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(6),ngZu,m3h4x16(:,74),heltab2x64(:,:,151))
  call Hloop_Q_A(ntryL,G0H16(6),48,nMT,G1H16(13),n2h16(79))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(5),ngZd,m3h4x16(:,75),heltab2x64(:,:,152))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(15),n2h16(80))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(13),ngZd,m3h4x16(:,76),heltab2x64(:,:,153))
  call Hloop_A_Q(ntryL,G0H16(13),48,nMB,G1H16(18),n2h16(81))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZd,m3h4x16(:,77),heltab2x64(:,:,154))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(20),n2h16(82))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(4),ngZd,m3h4x16(:,78),heltab2x64(:,:,155))
  call Hloop_Q_A(ntryL,G0H16(4),48,nMB,G1H16(23),n2h16(83))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(25),m3h4x16(:,79),heltab2x64(:,:,156))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(27),m3h4x16(:,80),heltab2x64(:,:,157))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(29),m3h4x16(:,81),heltab2x64(:,:,158))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(30),m3h4x16(:,82),heltab2x64(:,:,159))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,5),G1H16(31),m3h4x16(:,83),heltab2x64(:,:,160))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(32),m3h4x16(:,84),heltab2x64(:,:,161))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,5),G1H16(33),m3h4x16(:,85),heltab2x64(:,:,162))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(34),m3h4x16(:,86),heltab2x64(:,:,163))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,3),G1H16(35),m3h4x16(:,87),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(36),m3h4x16(:,88),heltab2x64(:,:,165))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,3),G1H16(37),m3h4x16(:,89),heltab2x64(:,:,166))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(38),m3h4x16(:,90),heltab2x64(:,:,167))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(39),m3h4x16(:,91),heltab2x64(:,:,168))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(40),m3h4x16(:,92),heltab2x64(:,:,169))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(41),m3h4x16(:,93),heltab2x64(:,:,170))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(42),m3h4x16(:,94),heltab2x64(:,:,171))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,95),heltab2x64(:,:,172))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,96),heltab2x64(:,:,173))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(3),m3h4x16(:,97),heltab2x64(:,:,174))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(9),m3h4x16(:,98),heltab2x64(:,:,175))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(8),m3h4x16(:,99),heltab2x64(:,:,176))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(12),m3h4x16(:,100),heltab2x64(:,:,177))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(11),m3h4x16(:,101),heltab2x64(:,:,178))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(2),m3h4x16(:,102),heltab2x64(:,:,179))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(43),m3h4x16(:,103),heltab2x64(:,:,180))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(44),m3h4x16(:,104),heltab2x64(:,:,181))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(45),m3h4x16(:,105),heltab2x64(:,:,182))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(46),m3h4x16(:,106),heltab2x64(:,:,183))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(47),m3h4x16(:,107),heltab2x64(:,:,184))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(48),m3h4x16(:,108),heltab2x64(:,:,185))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(49),m3h4x16(:,109),heltab2x64(:,:,186))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(50),m3h4x16(:,110),heltab2x64(:,:,187))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,111),heltab2x64(:,:,188))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(5),m3h4x16(:,112),heltab2x64(:,:,189))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(13),m3h4x16(:,113),heltab2x64(:,:,190))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,114),heltab2x64(:,:,191))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,115),heltab2x64(:,:,192))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(14),m3h4x16(:,116),heltab2x64(:,:,193))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(15),m3h4x16(:,117),heltab2x64(:,:,194))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(16),m3h4x16(:,118),heltab2x64(:,:,195))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,60),heltab2x64(:,:,196))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(1),n2h32(11))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,12,19],[0,0,nMZ],3,2,wf4(:,2),wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,61),heltab2x64(:,:,197))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(2),n2h32(12))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,12,19],[0,0,nMW],3,2,wf4(:,2),wf8(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,62),heltab2x64(:,:,198))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(3),n2h32(13))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,12,19],[nMW,nMW,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,63),heltab2x64(:,:,199))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[35,12,16],[0,0,0],3,2,wf8(:,22),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,22),G0H8(2),m3h8x8(:,19),heltab2x64(:,:,200))
  call Hloop_A_Q(ntryL,G0H8(2),35,0,G1H8(19),n2h8(35))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[35,12,16],[0,0,nMZ],3,2,wf8(:,22),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,22),G0H8(3),ngZd,m3h8x8(:,20),heltab2x64(:,:,201))
  call Hloop_A_Q(ntryL,G0H8(3),35,0,G1H8(6),n2h8(36))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[35,12,16],[0,0,nMW],3,2,wf8(:,22),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,22),G0H8(1),m3h8x8(:,21),heltab2x64(:,:,202))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(7),n2h8(37))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[35,12,16],[nMW,nMW,0],3,2,wf8(:,22),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,22),G0H8(4),m3h8x8(:,22),heltab2x64(:,:,203))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,64),heltab2x64(:,:,204))
  call Hloop_A_Q(ntryL,G0H32(12),32,0,G1H32(4),n2h32(14))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[32,3,28],[0,0,nMZ],3,2,wf4(:,1),wf8(:,6))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,65),heltab2x64(:,:,205))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(5),n2h32(15))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[32,3,28],[0,0,nMW],3,2,wf4(:,1),wf8(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,66),heltab2x64(:,:,206))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(6),n2h32(16))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,3,28],[nMW,nMW,0],3,2,wf4(:,1),wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,67),heltab2x64(:,:,207))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[44,3,16],[0,0,0],3,2,wf8(:,24),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,24),G0H8(5),m3h8x8(:,23),heltab2x64(:,:,208))
  call Hloop_A_Q(ntryL,G0H8(5),44,0,G1H8(1),n2h8(38))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[44,3,16],[0,0,nMZ],3,2,wf8(:,24),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,24),G0H8(6),ngZd,m3h8x8(:,24),heltab2x64(:,:,209))
  call Hloop_A_Q(ntryL,G0H8(6),44,0,G1H8(2),n2h8(39))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[44,3,16],[0,0,nMW],3,2,wf8(:,24),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,24),G0H8(7),m3h8x8(:,25),heltab2x64(:,:,210))
  call Hloop_A_Q(ntryL,G0H8(7),44,0,G1H8(4),n2h8(40))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[44,3,16],[nMW,nMW,0],3,2,wf8(:,24),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,24),G0H8(8),m3h8x8(:,26),heltab2x64(:,:,211))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,15,16],[nMZ,nMZ,0],3,1,wf16(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(10),ngZd,m3h2x32(:,68),heltab2x64(:,:,212))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,15,16],[nMW,nMW,0],3,1,wf16(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,69),heltab2x64(:,:,213))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[48,7,8],[0,nMW,0],3,2,wf4(:,5),wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,119),heltab2x64(:,:,214))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(51),n2h16(84))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[48,7,8],[0,nMZ,0],3,2,wf4(:,3),wf8(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZn,m3h4x16(:,120),heltab2x64(:,:,215))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(52),n2h16(85))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[48,7,8],[0,nMW,0],3,2,wf4(:,3),wf8(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZl,m3h4x16(:,121),heltab2x64(:,:,216))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(53),n2h16(86))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[48,7,8],[nMW,0,nMW],3,2,wf4(:,5),wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(54),m3h4x16(:,122),heltab2x64(:,:,217))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[48,7,8],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(55),m3h4x16(:,123),heltab2x64(:,:,218))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[48,4,11],[0,nMW,0],3,2,wf4(:,5),wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,124),heltab2x64(:,:,219))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(56),n2h16(87))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[48,4,11],[0,nMZ,0],3,2,wf4(:,3),wf8(:,32))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZn,m3h4x16(:,125),heltab2x64(:,:,220))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(57),n2h16(88))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[48,4,11],[0,nMW,0],3,2,wf4(:,3),wf8(:,32))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZl,m3h4x16(:,126),heltab2x64(:,:,221))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(58),n2h16(89))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[48,4,11],[nMW,0,nMW],3,2,wf4(:,5),wf8(:,32))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(59),m3h4x16(:,127),heltab2x64(:,:,222))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[48,4,11],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,32))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(60),m3h4x16(:,128),heltab2x64(:,:,223))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[52,3,8],[0,0,nMZ],3,2,wf8(:,12),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,12),G0H8(9),ngZn,m3h8x8(:,27),heltab2x64(:,:,224))
  call Hloop_Q_A(ntryL,G0H8(9),52,0,G1H8(20),n2h8(41))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[52,3,8],[0,0,nMW],3,2,wf8(:,12),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,12),G0H8(10),m3h8x8(:,28),heltab2x64(:,:,225))
  call Hloop_Q_A(ntryL,G0H8(10),52,0,G1H8(22),n2h8(42))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[52,3,8],[nMW,nMW,0],3,2,wf8(:,12),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,12),G0H8(11),m3h8x8(:,29),heltab2x64(:,:,226))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[56,3,4],[0,0,nMZ],3,2,wf8(:,35),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,35),G0H8(12),ngZn,m3h8x8(:,30),heltab2x64(:,:,227))
  call Hloop_A_Q(ntryL,G0H8(12),56,0,G1H8(23),n2h8(43))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[56,3,4],[0,0,nMW],3,2,wf8(:,35),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,35),G0H8(13),m3h8x8(:,31),heltab2x64(:,:,228))
  call Hloop_A_Q(ntryL,G0H8(13),56,0,G1H8(24),n2h8(44))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[56,3,4],[nMW,nMW,0],3,2,wf8(:,35),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,35),G0H8(14),m3h8x8(:,32),heltab2x64(:,:,229))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[51,4,8],[nMZ,0,nMZ],3,1,wf16(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,2),G0H4(4),m3h16x4(:,1),heltab2x64(:,:,230))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[51,4,8],[nMW,0,nMW],3,1,wf16(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,2),G0H4(6),m3h16x4(:,2),heltab2x64(:,:,231))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[32,15,16],[0,0,0],3,1,wf16(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,70),heltab2x64(:,:,232))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(7),n2h32(17))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[32,15,16],[0,0,nMZ],3,1,wf16(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(13),ngZd,m3h2x32(:,71),heltab2x64(:,:,233))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(8),n2h32(18))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[32,15,16],[0,0,nMW],3,1,wf16(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,72),heltab2x64(:,:,234))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(9),n2h32(19))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[32,15,16],[nMW,nMW,0],3,1,wf16(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,73),heltab2x64(:,:,235))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[32,15,16],[0,0,0],3,1,wf16(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,74),heltab2x64(:,:,236))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(10),n2h32(20))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[32,15,16],[0,0,nMZ],3,1,wf16(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZd,m3h2x32(:,75),heltab2x64(:,:,237))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(11),n2h32(21))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[32,15,16],[0,0,nMW],3,1,wf16(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,76),heltab2x64(:,:,238))
  call Hloop_A_Q(ntryL,G0H32(18),32,0,G1H32(12),n2h32(22))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[32,15,16],[nMW,nMW,0],3,1,wf16(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,77),heltab2x64(:,:,239))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[51,4,8],[0,nMW,0],3,1,wf16(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,5),G0H4(7),m3h16x4(:,3),heltab2x64(:,:,240))
  call Hloop_A_Q(ntryL,G0H4(7),51,0,G1H4(2),n2h4(62))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[51,4,8],[0,nMZ,0],3,1,wf16(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,6),G0H4(7),ngZn,m3h16x4(:,4),heltab2x64(:,:,241))
  call Hloop_A_Q(ntryL,G0H4(7),51,0,G1H4(31),n2h4(63))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[51,4,8],[0,nMW,0],3,1,wf16(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,6),G0H4(7),ngZl,m3h16x4(:,5),heltab2x64(:,:,242))
  call Hloop_A_Q(ntryL,G0H4(7),51,0,G1H4(35),n2h4(64))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[51,4,8],[nMW,0,nMW],3,1,wf16(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,5),51,G1H4(36),m3h16x4(:,6),heltab2x64(:,:,243))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[51,4,8],[nMW,0,nMW],3,1,wf16(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(38),m3h16x4(:,7),heltab2x64(:,:,244))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[51,4,8],[0,nMW,0],3,1,wf16(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,7),G0H4(7),m3h16x4(:,8),heltab2x64(:,:,245))
  call Hloop_A_Q(ntryL,G0H4(7),51,0,G1H4(41),n2h4(65))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[51,4,8],[0,nMZ,0],3,1,wf16(:,8))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,8),G0H4(7),ngZn,m3h16x4(:,9),heltab2x64(:,:,246))
  call Hloop_A_Q(ntryL,G0H4(7),51,0,G1H4(42),n2h4(66))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[51,4,8],[0,nMW,0],3,1,wf16(:,8))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,8),G0H4(7),ngZl,m3h16x4(:,10),heltab2x64(:,:,247))
  call Hloop_A_Q(ntryL,G0H4(7),51,0,G1H4(43),n2h4(67))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[51,4,8],[nMW,0,nMW],3,1,wf16(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,7),51,G1H4(28),m3h16x4(:,11),heltab2x64(:,:,248))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[51,4,8],[nMW,0,nMW],3,1,wf16(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,8),51,G1H4(3),m3h16x4(:,12),heltab2x64(:,:,249))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[48,2,13],[0,nMW,0],3,2,wf4(:,5),wf8(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,129),heltab2x64(:,:,250))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(61),n2h16(90))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[48,2,13],[0,nMZ,0],3,2,wf4(:,3),wf8(:,15))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZn,m3h4x16(:,130),heltab2x64(:,:,251))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(62),n2h16(91))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[48,2,13],[0,nMW,0],3,2,wf4(:,3),wf8(:,15))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZl,m3h4x16(:,131),heltab2x64(:,:,252))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(63),n2h16(92))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[48,2,13],[nMW,0,nMW],3,2,wf4(:,5),wf8(:,15))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(64),m3h4x16(:,132),heltab2x64(:,:,253))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[48,2,13],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,15))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(65),m3h4x16(:,133),heltab2x64(:,:,254))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[49,2,12],[nMZ,0,0],3,2,wf8(:,18),wf4(:,2))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,18),G0H8(15),ngZn,m3h8x8(:,33),heltab2x64(:,:,255))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[49,2,12],[nMW,0,0],3,2,wf8(:,18),wf4(:,2))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,18),G0H8(16),m3h8x8(:,34),heltab2x64(:,:,256))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[49,2,12],[0,nMW,nMW],3,2,wf8(:,18),wf4(:,2))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,18),G0H8(2),m3h8x8(:,35),heltab2x64(:,:,257))
  call Hloop_Q_A(ntryL,G0H8(2),49,0,G1H8(25),n2h8(45))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[48,1,14],[0,nMW,0],3,2,wf4(:,5),wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,134),heltab2x64(:,:,258))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(66),n2h16(93))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[48,1,14],[0,nMZ,0],3,2,wf4(:,3),wf8(:,54))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZn,m3h4x16(:,135),heltab2x64(:,:,259))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(67),n2h16(94))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[48,1,14],[0,nMW,0],3,2,wf4(:,3),wf8(:,54))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZl,m3h4x16(:,136),heltab2x64(:,:,260))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(68),n2h16(95))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[48,1,14],[nMW,0,nMW],3,2,wf4(:,5),wf8(:,54))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(69),m3h4x16(:,137),heltab2x64(:,:,261))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[48,1,14],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,54))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(70),m3h4x16(:,138),heltab2x64(:,:,262))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[50,1,12],[nMZ,0,0],3,2,wf8(:,52),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,52),G0H8(3),ngZn,m3h8x8(:,36),heltab2x64(:,:,263))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[50,1,12],[nMW,0,0],3,2,wf8(:,52),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,52),G0H8(1),m3h8x8(:,37),heltab2x64(:,:,264))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[50,1,12],[0,nMW,nMW],3,2,wf8(:,52),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,52),G0H8(5),m3h8x8(:,38),heltab2x64(:,:,265))
  call Hloop_A_Q(ntryL,G0H8(5),50,0,G1H8(27),n2h8(46))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[60,1,2],[nMZ,0,nMZ],3,1,wf16(:,9))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,9),G0H4(7),m3h16x4(:,13),heltab2x64(:,:,266))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[60,1,2],[nMW,0,nMW],3,1,wf16(:,9))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,9),G0H4(8),m3h16x4(:,14),heltab2x64(:,:,267))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[32,15,16],[0,0,0],3,1,wf16(:,10))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,78),heltab2x64(:,:,268))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(13),n2h32(23))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[32,15,16],[0,0,nMZ],3,1,wf16(:,10))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(21),ngZd,m3h2x32(:,79),heltab2x64(:,:,269))
  call Hloop_A_Q(ntryL,G0H32(21),32,0,G1H32(14),n2h32(24))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[32,15,16],[0,0,nMW],3,1,wf16(:,10))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,80),heltab2x64(:,:,270))
  call Hloop_A_Q(ntryL,G0H32(22),32,0,G1H32(15),n2h32(25))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,15,16],[nMW,nMW,0],3,1,wf16(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,81),heltab2x64(:,:,271))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,15,16],[0,0,0],3,1,wf16(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,82),heltab2x64(:,:,272))
  call Hloop_A_Q(ntryL,G0H32(24),32,0,G1H32(16),n2h32(26))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[32,15,16],[0,0,nMZ],3,1,wf16(:,11))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),ngZd,m3h2x32(:,83),heltab2x64(:,:,273))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(17),n2h32(27))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[32,15,16],[0,0,nMW],3,1,wf16(:,11))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,84),heltab2x64(:,:,274))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(18),n2h32(28))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,15,16],[nMW,nMW,0],3,1,wf16(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,85),heltab2x64(:,:,275))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[60,1,2],[0,nMW,0],3,1,wf16(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,12),G0H4(9),m3h16x4(:,15),heltab2x64(:,:,276))
  call Hloop_A_Q(ntryL,G0H4(9),60,0,G1H4(4),n2h4(68))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[60,1,2],[0,nMZ,0],3,1,wf16(:,13))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,13),G0H4(9),ngZn,m3h16x4(:,16),heltab2x64(:,:,277))
  call Hloop_A_Q(ntryL,G0H4(9),60,0,G1H4(16),n2h4(69))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[60,1,2],[0,nMW,0],3,1,wf16(:,13))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,13),G0H4(9),ngZl,m3h16x4(:,17),heltab2x64(:,:,278))
  call Hloop_A_Q(ntryL,G0H4(9),60,0,G1H4(6),n2h4(70))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[60,1,2],[nMW,0,nMW],3,1,wf16(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,12),60,G1H4(14),m3h16x4(:,18),heltab2x64(:,:,279))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[60,1,2],[nMW,0,nMW],3,1,wf16(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,13),60,G1H4(7),m3h16x4(:,19),heltab2x64(:,:,280))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[60,1,2],[0,nMW,0],3,1,wf16(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,14),G0H4(9),m3h16x4(:,20),heltab2x64(:,:,281))
  call Hloop_A_Q(ntryL,G0H4(9),60,0,G1H4(13),n2h4(71))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[60,1,2],[0,nMZ,0],3,1,wf16(:,15))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,15),G0H4(9),ngZn,m3h16x4(:,21),heltab2x64(:,:,282))
  call Hloop_A_Q(ntryL,G0H4(9),60,0,G1H4(17),n2h4(72))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[60,1,2],[0,nMW,0],3,1,wf16(:,15))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,15),G0H4(9),ngZl,m3h16x4(:,22),heltab2x64(:,:,283))
  call Hloop_A_Q(ntryL,G0H4(9),60,0,G1H4(8),n2h4(73))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[60,1,2],[nMW,0,nMW],3,1,wf16(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,14),60,G1H4(11),m3h16x4(:,23),heltab2x64(:,:,284))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[60,1,2],[nMW,0,nMW],3,1,wf16(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,15),60,G1H4(44),m3h16x4(:,24),heltab2x64(:,:,285))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[51,4,8],[0,nMZ,0],3,1,wf16(:,16))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,16),G0H4(9),ngZn,m3h16x4(:,25),heltab2x64(:,:,286))
  call Hloop_A_Q(ntryL,G0H4(9),51,0,G1H4(47),n2h4(74))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[51,4,8],[0,nMW,0],3,1,wf16(:,16))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,16),G0H4(9),ngZl,m3h16x4(:,26),heltab2x64(:,:,287))
  call Hloop_A_Q(ntryL,G0H4(9),51,0,G1H4(19),n2h4(75))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[51,4,8],[nMW,0,nMW],3,1,wf16(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,16),51,G1H4(20),m3h16x4(:,27),heltab2x64(:,:,288))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[51,4,8],[0,nMZ,0],3,1,wf16(:,17))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,17),G0H4(9),ngZn,m3h16x4(:,28),heltab2x64(:,:,289))
  call Hloop_A_Q(ntryL,G0H4(9),51,0,G1H4(50),n2h4(76))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[51,4,8],[0,nMW,0],3,1,wf16(:,17))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,17),G0H4(9),ngZl,m3h16x4(:,29),heltab2x64(:,:,290))
  call Hloop_A_Q(ntryL,G0H4(9),51,0,G1H4(51),n2h4(77))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[51,4,8],[nMW,0,nMW],3,1,wf16(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,17),51,G1H4(52),m3h16x4(:,30),heltab2x64(:,:,291))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[60,1,2],[0,nMZ,0],3,1,wf16(:,18))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,18),G0H4(9),ngZn,m3h16x4(:,31),heltab2x64(:,:,292))
  call Hloop_A_Q(ntryL,G0H4(9),60,0,G1H4(53),n2h4(78))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[60,1,2],[0,nMW,0],3,1,wf16(:,18))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,18),G0H4(9),ngZl,m3h16x4(:,32),heltab2x64(:,:,293))
  call Hloop_A_Q(ntryL,G0H4(9),60,0,G1H4(54),n2h4(79))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[60,1,2],[nMW,0,nMW],3,1,wf16(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,18),60,G1H4(55),m3h16x4(:,33),heltab2x64(:,:,294))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[60,1,2],[0,nMZ,0],3,1,wf16(:,19))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,19),G0H4(9),ngZn,m3h16x4(:,34),heltab2x64(:,:,295))
  call Hloop_A_Q(ntryL,G0H4(9),60,0,G1H4(56),n2h4(80))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[60,1,2],[0,nMW,0],3,1,wf16(:,19))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,19),G0H4(9),ngZl,m3h16x4(:,35),heltab2x64(:,:,296))
  call Hloop_A_Q(ntryL,G0H4(9),60,0,G1H4(57),n2h4(81))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[60,1,2],[nMW,0,nMW],3,1,wf16(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,19),60,G1H4(58),m3h16x4(:,36),heltab2x64(:,:,297))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(20),G1H4(3),G1H4(28),G1H4(38),G1H4(36),G1H4(10) &
    ,G0H4(6),G0H4(3),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(55),G1H4(44),G1H4(11),G1H4(7),G1H4(14),G0H4(8) &
    ,G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(26),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(1),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(35),G1H16(33),G1H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(36),G1H16(34),G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(41),[G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(3),[G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(9),[G0H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(11),[G0H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(2),[G0H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(46),[G1H16(45),G1H16(44),G1H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(50),[G1H16(49),G1H16(48),G1H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(13),[G0H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(1),[G0H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(15),[G0H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(16),[G0H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(53),[G1H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(55),[G1H16(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(58),[G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(19),G1H4(43),G1H4(41),G1H4(35),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(47),G1H4(42),G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(63),[G1H16(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(65),[G1H16(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(68),[G1H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(70),[G1H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(54),G1H4(8),G1H4(13),G1H4(6),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(53),G1H4(17),G1H4(16)])
  call Hloop_WA_Q(ntryL,G1H4(27),ex4(:),G1H2(23),m3h2x2(:,89),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(23),59,0,G2H2(18),n2h2(60))
  call Hloop_WQ_A(ntryL,G1H4(52),ex3(:),G1H2(35),m3h2x2(:,90),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(35),55,0,G2H2(21),n2h2(61))
  call Hloop_AZ_Q(ntryL,G1H8(1),wf4(:,1),G1H2(39),ngZd,m3h4x2(:,35),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(39),47,0,G2H2(24),n2h2(62))
  call Hloop_AZ_Q(ntryL,G1H8(2),wf4(:,1),G1H2(63),ngZd,m3h4x2(:,36),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(63),47,0,G2H2(27),n2h2(63))
  call Hloop_AZ_Q(ntryL,G1H8(4),wf4(:,1),G1H2(64),ngZu,m3h4x2(:,37),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(64),47,0,G2H2(30),n2h2(64))
  call Hloop_AZ_Q(ntryL,G1H8(19),wf4(:,2),G1H2(68),ngZd,m3h4x2(:,38),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(68),47,0,G2H2(10),n2h2(65))
  call Hloop_AZ_Q(ntryL,G1H8(6),wf4(:,2),G1H2(70),ngZd,m3h4x2(:,39),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(70),47,0,G2H2(9),n2h2(66))
  call Hloop_AZ_Q(ntryL,G1H8(7),wf4(:,2),G1H2(76),ngZu,m3h4x2(:,40),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(76),47,0,G2H2(15),n2h2(67))
  call Hloop_QZ_A(ntryL,G1H8(22),wf4(:,1),G1H2(80),ngZl,m3h4x2(:,41),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(80),55,0,G2H2(16),n2h2(68))
  call Hloop_QZ_A(ntryL,G1H8(13),wf4(:,2),G1H2(88),ngZl,m3h4x2(:,42),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(88),61,0,G2H2(1),n2h2(69))
  call Hloop_VWW_V(ntryL,G0H32(7),wf4(:,1),wf4(:,2),G0H2(5),m4h4x4x2(:,1),heltab3x32(:,:,1))
  call Hloop_WQ_A(ntryL,G1H4(58),ex1(:),G1H2(94),m3h2x2(:,91),heltab2x4(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(94),61,0,G2H2(7),n2h2(70))
  call Hloop_AZ_Q(ntryL,G1H16(26),wf4(:,1),G1H4(20),ngZl,m3h4x4(:,17),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(20),51,0,G2H4(18),n2h4(82))
  call Hloop_AZ_Q(ntryL,G1H16(28),wf4(:,1),G1H4(3),ngZl,m3h4x4(:,18),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(3),51,nML,G2H4(19),n2h4(83))
  call Hloop_QZ_A(ntryL,G1H16(1),wf4(:,1),G1H4(28),ngZl,m3h4x4(:,19),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(28),51,0,G2H4(1),n2h4(84))
  call Hloop_QZ_A(ntryL,G1H16(6),wf4(:,1),G1H4(38),ngZl,m3h4x4(:,20),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(38),51,nML,G2H4(2),n2h4(85))
  call Hloop_AZ_Q(ntryL,G1H16(9),wf4(:,1),G1H4(36),ngZu,m3h4x4(:,21),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(36),51,0,G2H4(3),n2h4(86))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,1),G1H4(10),ngZu,m3h4x4(:,22),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(10),51,nMT,G2H4(9),n2h4(87))
  call Hloop_QZ_A(ntryL,G1H16(7),wf4(:,1),G1H4(55),ngZu,m3h4x4(:,23),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(6),n2h4(88))
  call Hloop_QZ_A(ntryL,G1H16(13),wf4(:,1),G1H4(44),ngZu,m3h4x4(:,24),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(44),51,nMT,G2H4(4),n2h4(89))
  call Hloop_AZ_Q(ntryL,G1H16(15),wf4(:,1),G1H4(11),ngZd,m3h4x4(:,25),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(11),51,0,G2H4(5),n2h4(90))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,1),G1H4(7),ngZd,m3h4x4(:,26),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(7),51,nMB,G2H4(7),n2h4(91))
  call Hloop_QZ_A(ntryL,G1H16(20),wf4(:,1),G1H4(14),ngZd,m3h4x4(:,27),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(14),51,0,G2H4(8),n2h4(92))
  call Hloop_QZ_A(ntryL,G1H16(23),wf4(:,1),G1H4(19),ngZd,m3h4x4(:,28),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(19),51,nMB,G2H4(11),n2h4(93))
  call Hloop_AZ_Q(ntryL,G1H16(21),wf4(:,1),G1H4(43),ngZn,m3h4x4(:,29),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(43),51,0,G2H4(10),n2h4(94))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,1),G1H4(41),ngZn,m3h4x4(:,30),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(41),51,0,G2H4(12),n2h4(95))
  call Hloop_SV_T(ntryL,G1H16(29),48,wf4(:,1),3,G2H4(13),m3h4x4(:,31),heltab2x16(:,:,80))
  call Hloop_TV_S(ntryL,G1H16(30),48,wf4(:,1),3,G2H4(14),m3h4x4(:,32),heltab2x16(:,:,81))
  call Hloop_DV_C(ntryL,G1H16(37),48,wf4(:,1),G2H4(15),m3h4x4(:,33),heltab2x16(:,:,82))
  call Hloop_CV_D(ntryL,G1H16(38),48,wf4(:,1),3,G2H4(16),m3h4x4(:,34),heltab2x16(:,:,83))
  call Hloop_UW_V(ntryL,G1H16(41),48,wf4(:,1),3,G2H4(17),m3h4x4(:,35),heltab2x16(:,:,84))
  call Hloop_UV_W(ntryL,G1H16(42),48,wf4(:,1),3,G2H4(20),m3h4x4(:,36),heltab2x16(:,:,85))
  call Hloop_SV_T(ntryL,G0H16(3),48,wf4(:,1),3,G1H4(35),m3h4x4(:,37),heltab2x16(:,:,86))
  call Hloop_TV_S(ntryL,G0H16(9),48,wf4(:,1),3,G1H4(2),m3h4x4(:,38),heltab2x16(:,:,87))
  call Hloop_VV_S(ntryL,G0H16(11),wf4(:,1),G0H4(9),m3h4x4(:,39),heltab2x16(:,:,88))
  call Hloop_VV_S(ntryL,G0H16(2),wf4(:,1),G0H4(6),m3h4x4(:,40),heltab2x16(:,:,89))
  call Hloop_SV_V(ntryL,G1H16(46),wf4(:,1),G1H4(47),m3h4x4(:,41),heltab2x16(:,:,90))
  call Hloop_VV_S(ntryL,G1H16(50),wf4(:,1),G1H4(42),m3h4x4(:,42),heltab2x16(:,:,91))
  call Hloop_SV_V(ntryL,G0H16(13),wf4(:,1),G0H4(3),m3h4x4(:,43),heltab2x16(:,:,92))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,1),G0H4(5),m3h4x4(:,44),heltab2x16(:,:,93))
  call Hloop_UW_V(ntryL,G0H16(15),48,wf4(:,1),3,G1H4(31),m3h4x4(:,45),heltab2x16(:,:,94))
  call Hloop_UV_W(ntryL,G0H16(16),48,wf4(:,1),3,G1H4(54),m3h4x4(:,46),heltab2x16(:,:,95))
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,2),G1H8(28),ngZd,m3h4x8(:,20),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(28),44,0,G2H8(1),n2h8(47))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,2),G1H8(5),ngZd,m3h4x8(:,21),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(5),44,0,G2H8(2),n2h8(48))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,2),G1H8(29),ngZu,m3h4x8(:,22),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(29),44,0,G2H8(3),n2h8(49))
  call Hloop_UW_V(ntryL,G0H32(11),32,wf4(:,2),12,G1H8(31),m3h4x8(:,23),heltab2x32(:,:,62))
  call Hloop_UW_V(ntryL,G0H8(4),35,wf4(:,2),12,G1H2(2),m3h4x2(:,43),heltab2x8(:,:,113))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,1),G1H8(32),ngZd,m3h4x8(:,24),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(32),35,0,G2H8(4),n2h8(50))
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,1),G1H8(33),ngZd,m3h4x8(:,25),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(33),35,0,G2H8(5),n2h8(51))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,1),G1H8(34),ngZu,m3h4x8(:,26),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(34),35,0,G2H8(6),n2h8(52))
  call Hloop_UW_V(ntryL,G0H32(6),32,wf4(:,1),3,G1H8(36),m3h4x8(:,27),heltab2x32(:,:,66))
  call Hloop_UW_V(ntryL,G0H8(8),44,wf4(:,1),3,G1H2(14),m3h4x2(:,44),heltab2x8(:,:,114))
  call Hloop_VS_V(ntryL,G0H32(10),wf16(:,1),G0H2(4),m3h16x2(:,1),heltab2x32(:,:,67))
  call Hloop_VS_V(ntryL,G0H32(1),wf16(:,1),G0H2(2),m3h16x2(:,2),heltab2x32(:,:,68))
  call Hloop_AQ_W(ntryL,G1H16(53),wf8(:,9),G1H2(26),m3h8x2(:,7),heltab2x16(:,:,96))
  call Hloop_AQ_Z(ntryL,G1H16(52),wf8(:,9),G1H2(38),ngZn,m3h8x2(:,8),heltab2x16(:,:,97))
  call Hloop_WQ_A(ntryL,G1H16(55),wf8(:,9),G1H2(50),m3h8x2(:,9),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(50),55,0,G2H2(6),n2h2(71))
  call Hloop_AQ_W(ntryL,G1H16(58),ex3(:),G1H8(37),m3h2x8(:,44),heltab2x16(:,:,99))
  call Hloop_AQ_Z(ntryL,G1H16(57),ex3(:),G1H8(38),ngZn,m3h2x8(:,45),heltab2x16(:,:,100))
  call Hloop_WQ_A(ntryL,G1H16(60),ex3(:),G1H8(39),m3h2x8(:,46),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(39),52,0,G2H8(7),n2h8(53))
  call Hloop_QZ_A(ntryL,G1H8(20),wf4(:,1),G1H2(15),ngZn,m3h4x2(:,45),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(15),55,0,G2H2(2),n2h2(72))
  call Hloop_UW_V(ntryL,G0H8(11),52,wf4(:,1),3,G1H2(5),m3h4x2(:,46),heltab2x8(:,:,116))
  call Hloop_AZ_Q(ntryL,G1H8(23),wf4(:,1),G1H2(32),ngZn,m3h4x2(:,47),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(32),59,0,G2H2(3),n2h2(73))
  call Hloop_AZ_Q(ntryL,G1H8(24),wf4(:,1),G1H2(29),ngZl,m3h4x2(:,48),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(29),59,0,G2H2(4),n2h2(74))
  call Hloop_UV_W(ntryL,G0H8(14),56,wf4(:,1),3,G1H2(57),m3h4x2(:,49),heltab2x8(:,:,119))
  call Hloop_ZQ_A(ntryL,G0H4(4),ex3(:),G0H2(1),ngZn,m3h2x2(:,92),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(41),n2h2(75))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf16(:,3),G1H2(22),ngZd,m3h16x2(:,3),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(22),47,0,G2H2(5),n2h2(76))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf16(:,3),G1H2(40),ngZd,m3h16x2(:,4),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(40),47,0,G2H2(8),n2h2(77))
  call Hloop_AZ_Q(ntryL,G1H32(9),wf16(:,3),G1H2(54),ngZu,m3h16x2(:,5),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(54),47,0,G2H2(11),n2h2(78))
  call Hloop_UW_V(ntryL,G0H32(15),32,wf16(:,3),15,G1H2(42),m3h16x2(:,6),heltab2x32(:,:,72))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf16(:,4),G1H2(34),ngZd,m3h16x2(:,7),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(34),47,0,G2H2(12),n2h2(79))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf16(:,4),G1H2(52),ngZd,m3h16x2(:,8),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(52),47,0,G2H2(13),n2h2(80))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf16(:,4),G1H2(21),ngZu,m3h16x2(:,9),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(21),47,0,G2H2(14),n2h2(81))
  call Hloop_UW_V(ntryL,G0H32(19),32,wf16(:,4),15,G1H2(18),m3h16x2(:,10),heltab2x32(:,:,76))
  call Hloop_AQ_W(ntryL,G1H4(51),ex3(:),G1H2(36),m3h2x2(:,93),heltab2x4(:,:,137))
  call Hloop_AQ_Z(ntryL,G1H4(50),ex3(:),G1H2(46),ngZn,m3h2x2(:,94),heltab2x4(:,:,138))
  call Hloop_QA_W(ntryL,G1H16(63),ex2(:),G1H8(41),m3h2x8(:,47),heltab2x16(:,:,102))
  call Hloop_QA_Z(ntryL,G1H16(62),ex2(:),G1H8(42),ngZn,m3h2x8(:,48),heltab2x16(:,:,103))
  call Hloop_WA_Q(ntryL,G1H16(65),ex2(:),G1H8(3),m3h2x8(:,49),heltab2x16(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(3),50,0,G2H8(8),n2h8(54))
  call Hloop_ZA_Q(ntryL,G0H8(15),ex2(:),G0H4(8),ngZn,m3h2x4(:,65),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G0H4(8),51,0,G1H4(8),n2h4(96))
  call Hloop_WA_Q(ntryL,G0H8(16),ex2(:),G0H4(2),m3h2x4(:,66),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G0H4(2),51,0,G1H4(13),n2h4(97))
  call Hloop_QA_W(ntryL,G1H8(25),ex2(:),G1H4(6),m3h2x4(:,67),heltab2x8(:,:,122))
  call Hloop_AQ_W(ntryL,G1H16(68),ex1(:),G1H8(9),m3h2x8(:,50),heltab2x16(:,:,105))
  call Hloop_AQ_Z(ntryL,G1H16(67),ex1(:),G1H8(44),ngZn,m3h2x8(:,51),heltab2x16(:,:,106))
  call Hloop_WQ_A(ntryL,G1H16(70),ex1(:),G1H8(45),m3h2x8(:,52),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(45),49,0,G2H8(9),n2h8(55))
  call Hloop_ZQ_A(ntryL,G0H8(3),ex1(:),G0H4(1),ngZn,m3h2x4(:,68),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(4),n2h4(98))
  call Hloop_WQ_A(ntryL,G0H8(1),ex1(:),G0H4(4),m3h2x4(:,69),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G0H4(4),51,0,G1H4(53),n2h4(99))
  call Hloop_AQ_W(ntryL,G1H8(27),ex1(:),G1H4(17),m3h2x4(:,70),heltab2x8(:,:,125))
  call Hloop_ZQ_A(ntryL,G0H4(7),ex1(:),G0H2(3),ngZn,m3h2x2(:,95),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G0H2(3),61,0,G1H2(33),n2h2(82))
  call Hloop_AZ_Q(ntryL,G1H32(13),wf16(:,10),G1H2(27),ngZd,m3h16x2(:,11),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(27),47,0,G2H2(17),n2h2(83))
  call Hloop_AZ_Q(ntryL,G1H32(14),wf16(:,10),G1H2(51),ngZd,m3h16x2(:,12),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(51),47,0,G2H2(19),n2h2(84))
  call Hloop_AZ_Q(ntryL,G1H32(15),wf16(:,10),G1H2(62),ngZu,m3h16x2(:,13),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(62),47,0,G2H2(20),n2h2(85))
  call Hloop_UW_V(ntryL,G0H32(23),32,wf16(:,10),15,G1H2(48),m3h16x2(:,14),heltab2x32(:,:,80))
  call Hloop_AZ_Q(ntryL,G1H32(16),wf16(:,11),G1H2(45),ngZd,m3h16x2(:,15),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(45),47,0,G2H2(22),n2h2(86))
  call Hloop_AZ_Q(ntryL,G1H32(17),wf16(:,11),G1H2(73),ngZd,m3h16x2(:,16),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(73),47,0,G2H2(23),n2h2(87))
  call Hloop_AZ_Q(ntryL,G1H32(18),wf16(:,11),G1H2(69),ngZu,m3h16x2(:,17),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(69),47,0,G2H2(26),n2h2(88))
  call Hloop_UW_V(ntryL,G0H32(9),32,wf16(:,11),15,G1H2(82),m3h16x2(:,18),heltab2x32(:,:,84))
  call Hloop_AQ_W(ntryL,G1H4(57),ex1(:),G1H2(75),m3h2x2(:,96),heltab2x4(:,:,140))
  call Hloop_AQ_Z(ntryL,G1H4(56),ex1(:),G1H2(71),ngZn,m3h2x2(:,97),heltab2x4(:,:,141))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(5),[G1H2(89)])
call HGT_w2_OLR(G1H2(84),1,1,2)
call HGT_w2_invQ_OLR(G1H2(84),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(5)])
call HGT_w2_OLR(G1H2(91),1,1,2)
call HGT_w2_invQ_OLR(G1H2(91),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(51),G2H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(17),G2H2(12),G2H2(5),G2H2(42),G2H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(19),G2H2(13),G2H2(8),G2H2(45),G2H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(20),G2H2(14),G2H2(11),G2H2(48),G2H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(18)])
call HGT_w2_OLR(G1H4(26),1,1,4)
call HGT_w2_invQ_OLR(G1H4(26),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(26)])
call HGT_w2_OLR(G1H4(29),1,1,4)
call HGT_w2_invQ_OLR(G1H4(29),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(21)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(82),[G1H2(48),G1H2(18),G1H2(42),G1H2(66),G1H2(44),G0H2(2) &
    ,G0H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(8),G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G1H4(24),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(49),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(2),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(31),G1H4(47)])
  call Hloop_WA_Q(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(209))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(25),ex3(:),G2tensor(42),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hloop_WQ_A(ntryL,G1H2(91),ex3(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(210))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(46),m3h2x1(:,221),heltab2x2(:,:,221))
call HGT_w2_OLR(G1H4(37),1,1,4)
call HGT_w2_invQ_OLR(G1H4(37),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(37),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,45),heltab2x4(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(211))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex5(:),G2tensor(50),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(23),ex5(:),G2tensor(75),ngZd,m3h2x1(:,223),heltab2x2(:,:,223))
call HGT_w2_OLR(G1H4(12),1,1,4)
call HGT_w2_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(12),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,46),heltab2x4(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(212))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(26),ex5(:),G2tensor(60),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hloop_AZ_Q(ntryL,G2H4(5),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,47),heltab2x4(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(1),n2h1(213))
  call Hloop_AZ_Q(ntryL,G2H4(3),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,48),heltab2x4(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(2),n2h1(214))
call HGT_w2_OLR(G1H4(30),1,1,4)
call HGT_w2_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(30),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,49),heltab2x4(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(215))
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,50),heltab2x4(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(216))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(54),ex2(:),G2tensor(74),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hloop_WQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(217))
  call Hloop_WQ_A(ntryL,G1H2(82),ex5(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(218))
  call Hloop_WQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(98),n2h1(219))
  call Hloop_QZ_A(ntryL,G1H4(32),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,51),heltab2x4(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(220))
  call Hloop_QZ_A(ntryL,G1H4(34),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,52),heltab2x4(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(104),n2h1(221))
  call Hloop_WA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(44),n2h1(222))
  call Hloop_WA_Q(ntryL,G1H2(101),ex2(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(155),n2h1(223))
  call Hloop_WA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(176),n2h1(224))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(39),51,wf4(:,2),12,G2tensor(185),m3h4x1(:,53),heltab2x4(:,:,150))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(40),51,wf4(:,2),12,G2tensor(120),m3h4x1(:,54),heltab2x4(:,:,151))
  call Hloop_WA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(225))
  call Hloop_ZA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),ngZn,m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(226))
  call Hloop_ZA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),ngZn,m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(56),n2h1(227))
  call Hloop_WQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(228))
  call Hloop_WQ_A(ntryL,G1H2(28),ex3(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(229))
  call Hloop_ZQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),ngZn,m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(230))
  call Hloop_ZQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),ngZn,m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(62),n2h1(231))
  call Hloop_QZ_A(ntryL,G2H4(1),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,55),heltab2x4(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(3),n2h1(232))
  call Hloop_QZ_A(ntryL,G1H4(4),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,56),heltab2x4(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(233))
  call Hloop_QZ_A(ntryL,G2H4(12),wf4(:,2),G2H1(1),ngZn,m3h4x1(:,57),heltab2x4(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(4),n2h1(234))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(17),51,wf4(:,2),12,G2tensor(65),m3h4x1(:,58),heltab2x4(:,:,155))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(17),51,wf4(:,2),12,G3tensor(5),m3h4x1(:,59),heltab2x4(:,:,156))
  call Hloop_AZ_Q(ntryL,G1H4(13),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,60),heltab2x4(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(235))
  call Hloop_AZ_Q(ntryL,G2H4(18),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,61),heltab2x4(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(6),n2h1(236))
  call Hloop_AZ_Q(ntryL,G1H4(8),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,62),heltab2x4(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(237))
  call Hloop_AZ_Q(ntryL,G2H4(10),wf4(:,2),G2H1(1),ngZn,m3h4x1(:,63),heltab2x4(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(7),n2h1(238))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(6),51,wf4(:,2),12,G2tensor(69),m3h4x1(:,64),heltab2x4(:,:,161))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(20),51,wf4(:,2),12,G3tensor(8),m3h4x1(:,65),heltab2x4(:,:,162))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(112),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(21),ex4(:),G2tensor(110),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(24),ex5(:),G2tensor(7),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(27),ex5(:),G2tensor(113),ngZd,m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(30),ex5(:),G2tensor(109),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex5(:),G2tensor(80),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(9),ex5(:),G2tensor(81),ngZd,m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(15),ex5(:),G2tensor(83),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(84),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(86),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(87),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hloop_AZ_Q(ntryL,G2H4(19),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,66),heltab2x4(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nML,G3tensor(9),n2h1(239))
  call Hloop_QZ_A(ntryL,G2H4(2),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,67),heltab2x4(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nML,G3tensor(10),n2h1(240))
  call Hloop_AZ_Q(ntryL,G2H4(9),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,68),heltab2x4(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(11),n2h1(241))
  call Hloop_QZ_A(ntryL,G2H4(6),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,69),heltab2x4(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(12),n2h1(242))
  call Hloop_QZ_A(ntryL,G2H4(4),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,70),heltab2x4(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(13),n2h1(243))
  call Hloop_AZ_Q(ntryL,G2H4(7),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,71),heltab2x4(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(14),n2h1(244))
  call Hloop_QZ_A(ntryL,G2H4(8),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,72),heltab2x4(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(15),n2h1(245))
  call Hloop_QZ_A(ntryL,G2H4(11),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,73),heltab2x4(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(16),n2h1(246))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(13),51,wf4(:,2),12,G3tensor(17),m3h4x1(:,74),heltab2x4(:,:,171))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(14),51,wf4(:,2),12,G3tensor(18),m3h4x1(:,75),heltab2x4(:,:,172))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(15),51,wf4(:,2),G3tensor(19),m3h4x1(:,76),heltab2x4(:,:,173))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(16),51,wf4(:,2),12,G3tensor(20),m3h4x1(:,77),heltab2x4(:,:,174))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(42),wf4(:,2),G1tensor(39),m3h4x1(:,78),heltab2x4(:,:,175))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(54),wf4(:,2),G1tensor(79),m3h4x1(:,79),heltab2x4(:,:,176))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,3),G2tensor(89),m3h8x1(:,7),heltab2x8(:,:,126))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H8(2),wf8(:,3),G2tensor(90),ngZd,m3h8x1(:,8),heltab2x8(:,:,127))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(3),wf8(:,3),G2tensor(92),m3h8x1(:,9),heltab2x8(:,:,128))
  call Hloop_WQ_A(ntryL,G1H8(31),wf8(:,3),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(247))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,6),G2tensor(95),m3h8x1(:,11),heltab2x8(:,:,130))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H8(5),wf8(:,6),G2tensor(96),ngZd,m3h8x1(:,12),heltab2x8(:,:,131))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(6),wf8(:,6),G2tensor(116),m3h8x1(:,13),heltab2x8(:,:,132))
  call Hloop_WQ_A(ntryL,G1H8(36),wf8(:,6),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(248))
  call Hloop_ZQ_A(ntryL,G0H2(4),ex5(:),G0H1(1),ngZd,m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(109),n2h1(249))
  call Hloop_WA_Q(ntryL,G1H8(37),wf8(:,32),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(94),n2h1(250))
  call Hloop_ZA_Q(ntryL,G1H8(38),wf8(:,32),G1H1(1),ngZn,m3h8x1(:,16),heltab2x8(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(251))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(7),wf8(:,32),G2tensor(117),m3h8x1(:,17),heltab2x8(:,:,136))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(105),ngZn,m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(118),ngZn,m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(39),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(41),ex4(:),G1tensor(139),ngZn,m3h2x1(:,254),heltab2x2(:,:,254))
  call Hloop_WQ_A(ntryL,G1H8(41),wf8(:,15),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(252))
  call Hloop_ZQ_A(ntryL,G1H8(42),wf8(:,15),G1H1(1),ngZn,m3h8x1(:,19),heltab2x8(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(253))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(8),wf8(:,15),G2tensor(70),m3h8x1(:,20),heltab2x8(:,:,139))
  call Hloop_WA_Q(ntryL,G1H8(9),wf8(:,54),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(254))
  call Hloop_ZA_Q(ntryL,G1H8(44),wf8(:,54),G1H1(1),ngZn,m3h8x1(:,22),heltab2x8(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(255))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(9),wf8(:,54),G2tensor(119),m3h8x1(:,23),heltab2x8(:,:,142))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(33),ex2(:),G1tensor(169),ngZn,m3h2x1(:,255),heltab2x2(:,:,255))
  call Hloop_WA_Q(ntryL,G1H2(75),ex2(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(256))
  call Hloop_ZA_Q(ntryL,G1H2(71),ex2(:),G1H1(1),ngZn,m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(257))
  call ol_merge_tensors(G3tensor(20),[G3tensor(19),G3tensor(18),G3tensor(17),G3tensor(8),G3tensor(5),G2tensor(141),G2tensor(123) &
    ,G2tensor(121),G1tensor(79),G1tensor(39),G1tensor(502),G1tensor(389),G1tensor(193),G1tensor(157),G1tensor(127),G0tensor(740) &
    ,G0tensor(537),G0tensor(25),G0tensor(19),G0tensor(14)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(125),G1tensor(632),G0tensor(900)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(127),G1tensor(637),G0tensor(905)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(129),G1tensor(642),G0tensor(910)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(131),G1tensor(647),G0tensor(915)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(133),G1tensor(652),G1tensor(487),G1tensor(447),G1tensor(73),G0tensor(920) &
    ,G0tensor(725),G0tensor(685),G0tensor(5)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(157),G2tensor(135),G1tensor(657),G1tensor(467),G1tensor(103),G0tensor(925) &
    ,G0tensor(705),G0tensor(10)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(137),G1tensor(662),G0tensor(930)])
  call ol_merge_tensors(G2tensor(119),[G2tensor(187),G2tensor(139),G1tensor(667),G1tensor(507),G1tensor(163),G0tensor(935) &
    ,G0tensor(745),G0tensor(20)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(148),G2tensor(142),G1tensor(547),G1tensor(392),G1tensor(247),G1tensor(223) &
    ,G0tensor(785),G0tensor(540),G0tensor(34),G0tensor(30)])
  call ol_merge_tensors(G2tensor(144),[G1tensor(414),G1tensor(337),G1tensor(283),G0tensor(597),G0tensor(49),G0tensor(40)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(145),G1tensor(417),G1tensor(270),G1tensor(313),G0tensor(600),G0tensor(54) &
    ,G0tensor(45)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(147),G1tensor(544),G1tensor(415),G1tensor(405),G1tensor(330),G0tensor(782) &
    ,G0tensor(598),G0tensor(583),G0tensor(99)])
  call ol_merge_tensors(G2tensor(150),[G1tensor(594),G1tensor(404),G1tensor(27),G1tensor(331),G0tensor(832),G0tensor(582) &
    ,G0tensor(155),G0tensor(48)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(151),G1tensor(597),G1tensor(40),G0tensor(835),G0tensor(160)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(153),G1tensor(619),G1tensor(379),G1tensor(84),G1tensor(121),G0tensor(857) &
    ,G0tensor(522),G0tensor(185),G0tensor(13)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(181),G2tensor(154),G1tensor(702),G1tensor(622),G1tensor(105),G0tensor(970) &
    ,G0tensor(860),G0tensor(190)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(156),G1tensor(640),G1tensor(449),G1tensor(85),G0tensor(908),G0tensor(687) &
    ,G0tensor(7)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(159),G1tensor(669),G1tensor(514),G1tensor(23),G0tensor(937),G0tensor(752) &
    ,G0tensor(68)])
  call ol_merge_tensors(G3tensor(15),[G3tensor(12),G3tensor(7),G3tensor(6),G3tensor(4),G3tensor(3),G3tensor(2),G3tensor(1) &
    ,G2tensor(169),G2tensor(166),G2tensor(163),G2tensor(160),G1tensor(706),G1tensor(701),G1tensor(696),G1tensor(691),G1tensor(687) &
    ,G1tensor(682),G1tensor(677),G1tensor(672),G1tensor(654),G1tensor(649),G1tensor(644),G0tensor(974),G0tensor(969),G0tensor(964) &
    ,G0tensor(959),G0tensor(955),G0tensor(950),G0tensor(945),G0tensor(940),G0tensor(922),G0tensor(917),G0tensor(912)])
  call ol_merge_tensors(G2tensor(118),[G2tensor(162),G1tensor(674),G1tensor(509),G1tensor(164),G0tensor(942),G0tensor(747) &
    ,G0tensor(58)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(165),G1tensor(679),G1tensor(660),G0tensor(947),G0tensor(928)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(168),G1tensor(684),G1tensor(519),G1tensor(294),G0tensor(952),G0tensor(757) &
    ,G0tensor(78)])
  call ol_merge_tensors(G2tensor(171),[G1tensor(689),G0tensor(957)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(172),G1tensor(692),G0tensor(960)])
  call ol_merge_tensors(G2tensor(174),[G1tensor(694),G0tensor(962)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(175),G1tensor(697),G0tensor(965)])
  call ol_merge_tensors(G2tensor(177),[G1tensor(135),G1tensor(357),G1tensor(324),G1tensor(271),G1tensor(235),G1tensor(115) &
    ,G0tensor(277),G0tensor(153),G0tensor(97),G0tensor(38),G0tensor(32),G0tensor(12)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(178),G1tensor(394),G1tensor(147),G1tensor(19),G1tensor(133),G0tensor(542) &
    ,G0tensor(285),G0tensor(125),G0tensor(15)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(180),G1tensor(699),G0tensor(967)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(183),G1tensor(704),G0tensor(972)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(184),G1tensor(707),G1tensor(612),G1tensor(143),G1tensor(71),G0tensor(975) &
    ,G0tensor(850),G0tensor(200),G0tensor(180)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(186),G1tensor(489),G1tensor(145),G0tensor(727),G0tensor(17)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(635),G1tensor(469),G1tensor(429),G1tensor(51),G0tensor(903),G0tensor(707) &
    ,G0tensor(667),G0tensor(2)])
  call ol_merge_tensors(G1tensor(477),[G1tensor(437),G1tensor(61),G0tensor(715),G0tensor(675),G0tensor(3)])
  call ol_merge_tensors(G1tensor(482),[G1tensor(442),G1tensor(67),G0tensor(720),G0tensor(680),G0tensor(4)])
  call ol_merge_tensors(G2tensor(185),[G1tensor(457),G1tensor(91),G0tensor(695),G0tensor(8)])
  call ol_merge_tensors(G2tensor(120),[G1tensor(462),G1tensor(97),G0tensor(700),G0tensor(9)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(497),G1tensor(151),G0tensor(735),G0tensor(18)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(595),G1tensor(130),G1tensor(205),G1tensor(175),G0tensor(833),G0tensor(279) &
    ,G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(374),G1tensor(166),G1tensor(83),G1tensor(355),G1tensor(325),G1tensor(181) &
    ,G0tensor(512),G0tensor(302),G0tensor(183),G0tensor(52),G0tensor(47),G0tensor(23)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(384),G1tensor(153),G1tensor(198),G1tensor(187),G0tensor(532),G0tensor(284) &
    ,G0tensor(69),G0tensor(24)])
  call ol_merge_tensors(G1tensor(377),[G1tensor(211),G0tensor(528),G0tensor(515),G0tensor(28)])
  call ol_merge_tensors(G1tensor(387),[G1tensor(282),G1tensor(217),G0tensor(549),G0tensor(535),G0tensor(74),G0tensor(29)])
  call ol_merge_tensors(G1tensor(542),[G1tensor(382),G1tensor(241),G0tensor(780),G0tensor(530),G0tensor(525),G0tensor(33)])
  call ol_merge_tensors(G1tensor(552),[G1tensor(397),G1tensor(42),G1tensor(253),G0tensor(790),G0tensor(550),G0tensor(545) &
    ,G0tensor(130),G0tensor(35)])
  call ol_merge_tensors(G2tensor(155),[G1tensor(620),G1tensor(323),G1tensor(295),G1tensor(265),G0tensor(858),G0tensor(304) &
    ,G0tensor(42),G0tensor(37)])
  call ol_merge_tensors(G1tensor(409),[G1tensor(32),G1tensor(277),G0tensor(592),G0tensor(309),G0tensor(124),G0tensor(39)])
  call ol_merge_tensors(G1tensor(549),[G1tensor(332),G1tensor(301),G0tensor(787),G0tensor(588),G0tensor(100),G0tensor(43)])
  call ol_merge_tensors(G1tensor(412),[G1tensor(43),G1tensor(307),G0tensor(609),G0tensor(595),G0tensor(129),G0tensor(44)])
  call ol_merge_tensors(G1tensor(419),[G1tensor(206),G1tensor(343),G0tensor(602),G0tensor(310),G0tensor(70),G0tensor(50)])
  call ol_merge_tensors(G1tensor(407),[G1tensor(361),G0tensor(590),G0tensor(585),G0tensor(53)])
  call ol_merge_tensors(G1tensor(422),[G1tensor(284),G1tensor(258),G0tensor(610),G0tensor(605),G0tensor(75),G0tensor(55)])
  call ol_merge_tensors(G1tensor(152),[G1tensor(36),G0tensor(62),G0tensor(57)])
  call ol_merge_tensors(G1tensor(369),[G1tensor(11),G0tensor(497),G0tensor(359),G0tensor(274),G0tensor(269),G0tensor(59)])
  call ol_merge_tensors(G1tensor(261),[G1tensor(21),G0tensor(392),G0tensor(300),G0tensor(220),G0tensor(215),G0tensor(60)])
  call ol_merge_tensors(G1tensor(517),[G1tensor(512),G1tensor(464),G1tensor(452),G1tensor(444),G1tensor(432),G1tensor(278) &
    ,G1tensor(52),G0tensor(755),G0tensor(750),G0tensor(702),G0tensor(690),G0tensor(682),G0tensor(670),G0tensor(73),G0tensor(63)])
  call ol_merge_tensors(G1tensor(372),[G1tensor(156),G0tensor(664),G0tensor(509),G0tensor(504),G0tensor(500),G0tensor(64)])
  call ol_merge_tensors(G1tensor(273),[G1tensor(266),G1tensor(306),G0tensor(575),G0tensor(405),G0tensor(400),G0tensor(395) &
    ,G0tensor(65)])
  call ol_merge_tensors(G1tensor(210),[G1tensor(194),G0tensor(72),G0tensor(67)])
  call ol_merge_tensors(G1tensor(171),[G1tensor(290),G0tensor(82),G0tensor(77)])
  call ol_merge_tensors(G1tensor(310),[G1tensor(296),G0tensor(427),G0tensor(339),G0tensor(234),G0tensor(229),G0tensor(79)])
  call ol_merge_tensors(G1tensor(327),[G1tensor(213),G0tensor(467),G0tensor(325),G0tensor(260),G0tensor(255),G0tensor(80)])
  call ol_merge_tensors(G1tensor(522),[G1tensor(484),G1tensor(472),G1tensor(300),G0tensor(760),G0tensor(722),G0tensor(710) &
    ,G0tensor(83)])
  call ol_merge_tensors(G1tensor(303),[G1tensor(108),G0tensor(649),G0tensor(449),G0tensor(439),G0tensor(430),G0tensor(84)])
  call ol_merge_tensors(G1tensor(365),[G1tensor(335),G1tensor(302),G0tensor(625),G0tensor(480),G0tensor(475),G0tensor(470) &
    ,G0tensor(85)])
  call ol_merge_tensors(G1tensor(221),[G1tensor(101),G1tensor(45),G1tensor(312),G1tensor(189),G0tensor(887),G0tensor(318) &
    ,G0tensor(293),G0tensor(262),G0tensor(237),G0tensor(222),G0tensor(163),G0tensor(92),G0tensor(87)])
  call ol_merge_tensors(G1tensor(565),[G1tensor(524),G1tensor(400),G1tensor(308),G0tensor(803),G0tensor(762),G0tensor(613) &
    ,G0tensor(563),G0tensor(553),G0tensor(88)])
  call ol_merge_tensors(G1tensor(529),[G1tensor(338),G1tensor(111),G0tensor(767),G0tensor(458),G0tensor(383),G0tensor(368) &
    ,G0tensor(104),G0tensor(89)])
  call ol_merge_tensors(G1tensor(534),[G1tensor(69),G0tensor(772),G0tensor(618),G0tensor(568),G0tensor(558),G0tensor(90)])
  call ol_merge_tensors(G1tensor(527),[G1tensor(240),G0tensor(765),G0tensor(495),G0tensor(425),G0tensor(420),G0tensor(93)])
  call ol_merge_tensors(G1tensor(532),[G1tensor(170),G1tensor(314),G0tensor(770),G0tensor(505),G0tensor(440),G0tensor(435) &
    ,G0tensor(109),G0tensor(94)])
  call ol_merge_tensors(G1tensor(537),[G1tensor(315),G1tensor(362),G1tensor(318),G0tensor(775),G0tensor(510),G0tensor(450) &
    ,G0tensor(445),G0tensor(120),G0tensor(95)])
  call ol_merge_tensors(G1tensor(570),[G1tensor(539),G1tensor(410),G1tensor(326),G0tensor(808),G0tensor(777),G0tensor(593) &
    ,G0tensor(578),G0tensor(98)])
  call ol_merge_tensors(G1tensor(169),[G1tensor(203),G1tensor(190),G1tensor(4),G1tensor(342),G1tensor(13),G0tensor(892) &
    ,G0tensor(347),G0tensor(342),G0tensor(327),G0tensor(248),G0tensor(208),G0tensor(143),G0tensor(107),G0tensor(102)])
  call ol_merge_tensors(G1tensor(575),[G1tensor(554),G1tensor(255),G1tensor(336),G0tensor(813),G0tensor(792),G0tensor(453) &
    ,G0tensor(378),G0tensor(363),G0tensor(103)])
  call ol_merge_tensors(G1tensor(559),[G1tensor(188),G0tensor(797),G0tensor(463),G0tensor(388),G0tensor(373),G0tensor(105)])
  call ol_merge_tensors(G1tensor(557),[G1tensor(344),G0tensor(795),G0tensor(660),G0tensor(640),G0tensor(635),G0tensor(108)])
  call ol_merge_tensors(G1tensor(562),[G1tensor(427),G1tensor(56),G1tensor(15),G0tensor(800),G0tensor(665),G0tensor(650) &
    ,G0tensor(645),G0tensor(140),G0tensor(110)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(705),G1tensor(146),G1tensor(350),G0tensor(973),G0tensor(117),G0tensor(112)])
  call ol_merge_tensors(G1tensor(564),[G1tensor(86),G0tensor(802),G0tensor(113)])
  call ol_merge_tensors(G1tensor(399),[G1tensor(49),G0tensor(562),G0tensor(324),G0tensor(299),G0tensor(294),G0tensor(114)])
  call ol_merge_tensors(G1tensor(305),[G1tensor(354),G0tensor(442),G0tensor(275),G0tensor(240),G0tensor(235),G0tensor(115)])
  call ol_merge_tensors(G1tensor(572),[G1tensor(567),G1tensor(31),G1tensor(9),G0tensor(810),G0tensor(805),G0tensor(128) &
    ,G0tensor(118)])
  call ol_merge_tensors(G1tensor(402),[G1tensor(360),G0tensor(624),G0tensor(574),G0tensor(569),G0tensor(565),G0tensor(119)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(700),G1tensor(18),G1tensor(3),G0tensor(968),G0tensor(127),G0tensor(122)])
  call ol_merge_tensors(G1tensor(569),[G1tensor(366),G0tensor(807),G0tensor(123)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(695),G1tensor(35),G1tensor(2),G0tensor(963),G0tensor(137),G0tensor(132)])
  call ol_merge_tensors(G1tensor(574),[G1tensor(5),G0tensor(812),G0tensor(133)])
  call ol_merge_tensors(G1tensor(254),[G1tensor(8),G0tensor(377),G0tensor(254),G0tensor(214),G0tensor(209),G0tensor(134)])
  call ol_merge_tensors(G1tensor(424),[G1tensor(26),G0tensor(642),G0tensor(360),G0tensor(345),G0tensor(340),G0tensor(135)])
  call ol_merge_tensors(G1tensor(577),[G1tensor(44),G0tensor(815),G0tensor(138)])
  call ol_merge_tensors(G1tensor(257),[G1tensor(345),G0tensor(474),G0tensor(399),G0tensor(389),G0tensor(380),G0tensor(139)])
  call ol_merge_tensors(G1tensor(10),[G1tensor(16),G0tensor(372),G0tensor(203),G0tensor(147),G0tensor(142)])
  call ol_merge_tensors(G1tensor(579),[G1tensor(339),G0tensor(817),G0tensor(362),G0tensor(213),G0tensor(144)])
  call ol_merge_tensors(G1tensor(584),[G1tensor(47),G1tensor(6),G0tensor(822),G0tensor(367),G0tensor(218),G0tensor(165) &
    ,G0tensor(145)])
  call ol_merge_tensors(G1tensor(237),[G1tensor(363),G0tensor(662),G0tensor(357),G0tensor(350),G0tensor(148)])
  call ol_merge_tensors(G1tensor(607),[G1tensor(582),G1tensor(82),G1tensor(12),G0tensor(845),G0tensor(820),G0tensor(179) &
    ,G0tensor(149)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(587),G1tensor(57),G1tensor(46),G0tensor(825),G0tensor(170),G0tensor(150)])
  call ol_merge_tensors(G1tensor(615),[G1tensor(155),G1tensor(30),G1tensor(48),G0tensor(853),G0tensor(587),G0tensor(303) &
    ,G0tensor(157),G0tensor(152)])
  call ol_merge_tensors(G1tensor(589),[G1tensor(58),G0tensor(827),G0tensor(577),G0tensor(308),G0tensor(154)])
  call ol_merge_tensors(G1tensor(142),[G1tensor(280),G1tensor(33),G0tensor(547),G0tensor(282),G0tensor(280),G0tensor(158)])
  call ol_merge_tensors(G1tensor(602),[G1tensor(592),G1tensor(60),G1tensor(34),G0tensor(840),G0tensor(830),G0tensor(169) &
    ,G0tensor(159)])
  call ol_merge_tensors(G1tensor(625),[G1tensor(149),G1tensor(53),G1tensor(41),G0tensor(863),G0tensor(557),G0tensor(288) &
    ,G0tensor(167),G0tensor(162)])
  call ol_merge_tensors(G1tensor(599),[G1tensor(59),G0tensor(837),G0tensor(552),G0tensor(298),G0tensor(164)])
  call ol_merge_tensors(G1tensor(126),[G1tensor(242),G0tensor(507),G0tensor(272),G0tensor(265),G0tensor(168)])
  call ol_merge_tensors(G1tensor(112),[G1tensor(70),G1tensor(81),G0tensor(422),G0tensor(223),G0tensor(177),G0tensor(172)])
  call ol_merge_tensors(G1tensor(139),[G1tensor(440),G1tensor(435),G1tensor(341),G1tensor(275),G1tensor(208),G1tensor(172) &
    ,G1tensor(65),G0tensor(878),G0tensor(678),G0tensor(673),G0tensor(477),G0tensor(407),G0tensor(333),G0tensor(312),G0tensor(257) &
    ,G0tensor(242),G0tensor(228),G0tensor(173)])
  call ol_merge_tensors(G1tensor(604),[G1tensor(328),G0tensor(842),G0tensor(412),G0tensor(233),G0tensor(174)])
  call ol_merge_tensors(G1tensor(609),[G1tensor(94),G1tensor(118),G0tensor(847),G0tensor(417),G0tensor(238),G0tensor(195) &
    ,G0tensor(175)])
  call ol_merge_tensors(G1tensor(184),[G1tensor(124),G0tensor(622),G0tensor(322),G0tensor(315),G0tensor(178)])
  call ol_merge_tensors(G1tensor(590),[G1tensor(129),G1tensor(93),G1tensor(185),G0tensor(828),G0tensor(527),G0tensor(278) &
    ,G0tensor(187),G0tensor(182)])
  call ol_merge_tensors(G1tensor(614),[G1tensor(136),G1tensor(77),G0tensor(852),G0tensor(517),G0tensor(283),G0tensor(184)])
  call ol_merge_tensors(G1tensor(167),[G1tensor(87),G0tensor(607),G0tensor(307),G0tensor(305),G0tensor(188)])
  call ol_merge_tensors(G1tensor(627),[G1tensor(617),G1tensor(317),G1tensor(88),G0tensor(865),G0tensor(855),G0tensor(199) &
    ,G0tensor(189)])
  call ol_merge_tensors(G1tensor(600),[G1tensor(125),G1tensor(106),G1tensor(292),G0tensor(838),G0tensor(492),G0tensor(263) &
    ,G0tensor(197),G0tensor(192)])
  call ol_merge_tensors(G1tensor(480),[G1tensor(475),G1tensor(358),G1tensor(268),G1tensor(251),G1tensor(165),G1tensor(232) &
    ,G0tensor(883),G0tensor(718),G0tensor(713),G0tensor(482),G0tensor(402),G0tensor(353),G0tensor(287),G0tensor(268),G0tensor(217) &
    ,G0tensor(202),G0tensor(193)])
  call ol_merge_tensors(G1tensor(624),[G1tensor(100),G0tensor(862),G0tensor(487),G0tensor(273),G0tensor(194)])
  call ol_merge_tensors(G1tensor(160),[G1tensor(95),G0tensor(572),G0tensor(297),G0tensor(290),G0tensor(198)])
  call ol_merge_tensors(G1tensor(191),[G1tensor(123),G0tensor(437),G0tensor(329),G0tensor(227),G0tensor(224)])
  call ol_merge_tensors(G1tensor(113),[G0tensor(447),G0tensor(232),G0tensor(225)])
  call ol_merge_tensors(G1tensor(585),[G1tensor(226),G1tensor(119),G0tensor(823),G0tensor(502),G0tensor(349),G0tensor(267) &
    ,G0tensor(264)])
  call ol_merge_tensors(G1tensor(610),[G1tensor(220),G1tensor(286),G0tensor(848),G0tensor(567),G0tensor(314),G0tensor(292) &
    ,G0tensor(289)])
  call ol_merge_tensors(G1tensor(605),[G1tensor(316),G0tensor(843),G0tensor(617),G0tensor(317),G0tensor(313)])
  call ol_merge_tensors(G1tensor(196),[G1tensor(207),G0tensor(637),G0tensor(332),G0tensor(328)])
  call ol_merge_tensors(G1tensor(322),[G0tensor(647),G0tensor(337),G0tensor(330)])
  call ol_merge_tensors(G1tensor(197),[G0tensor(627),G0tensor(338),G0tensor(334)])
  call ol_merge_tensors(G1tensor(233),[G1tensor(287),G0tensor(632),G0tensor(355),G0tensor(343),G0tensor(335)])
  call ol_merge_tensors(G1tensor(580),[G1tensor(329),G1tensor(214),G0tensor(818),G0tensor(657),G0tensor(352),G0tensor(348)])
  call ol_merge_tensors(G1tensor(239),[G0tensor(652),G0tensor(358),G0tensor(354)])
  call ol_merge_tensors(G1tensor(109),[G1tensor(426),G1tensor(401),G1tensor(371),G1tensor(347),G1tensor(311),G1tensor(299) &
    ,G1tensor(263),G1tensor(256),G0tensor(874),G0tensor(869),G0tensor(644),G0tensor(564),G0tensor(499),G0tensor(469),G0tensor(444) &
    ,G0tensor(434),G0tensor(429),G0tensor(394),G0tensor(384),G0tensor(379)])
  call ol_merge_tensors(G1tensor(511),[G1tensor(262),G0tensor(749),G0tensor(554),G0tensor(393),G0tensor(369),G0tensor(364)])
  call ol_merge_tensors(G1tensor(269),[G0tensor(560),G0tensor(403),G0tensor(375),G0tensor(370)])
  call ol_merge_tensors(G1tensor(352),[G1tensor(272),G0tensor(570),G0tensor(479),G0tensor(404),G0tensor(390),G0tensor(385)])
  call ol_merge_tensors(G1tensor(520),[G1tensor(298),G1tensor(279),G0tensor(758),G0tensor(628),G0tensor(428),G0tensor(413) &
    ,G0tensor(408)])
  call ol_merge_tensors(G1tensor(364),[G1tensor(285),G0tensor(633),G0tensor(484),G0tensor(433),G0tensor(418),G0tensor(409)])
  call ol_merge_tensors(G1tensor(291),[G0tensor(638),G0tensor(438),G0tensor(423),G0tensor(410)])
  call ol_merge_tensors(G1tensor(566),[G1tensor(309),G0tensor(804),G0tensor(489),G0tensor(443),G0tensor(419),G0tensor(414)])
  call ol_merge_tensors(G1tensor(521),[G1tensor(334),G0tensor(759),G0tensor(614),G0tensor(468),G0tensor(459),G0tensor(454)])
  call ol_merge_tensors(G1tensor(346),[G0tensor(620),G0tensor(478),G0tensor(465),G0tensor(460)])
  call ol_merge_tensors(G1tensor(510),[G1tensor(370),G1tensor(359),G0tensor(748),G0tensor(653),G0tensor(498),G0tensor(488) &
    ,G0tensor(483)])
  call ol_merge_tensors(G1tensor(367),[G0tensor(658),G0tensor(503),G0tensor(493),G0tensor(485)])
  call ol_merge_tensors(G1tensor(515),[G1tensor(385),G1tensor(375),G0tensor(753),G0tensor(533),G0tensor(518),G0tensor(513)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(390),G1tensor(380),G1tensor(376),G0tensor(538),G0tensor(523),G0tensor(514)])
  call ol_merge_tensors(G1tensor(571),[G1tensor(395),G1tensor(381),G0tensor(809),G0tensor(543),G0tensor(524),G0tensor(519)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(421),G1tensor(416),G1tensor(411),G1tensor(396),G1tensor(391),G1tensor(386) &
    ,G0tensor(604),G0tensor(599),G0tensor(594),G0tensor(544),G0tensor(539),G0tensor(534)])
  call ol_merge_tensors(G1tensor(516),[G1tensor(420),G1tensor(406),G0tensor(754),G0tensor(603),G0tensor(584),G0tensor(579)])
  call ol_merge_tensors(G1tensor(576),[G1tensor(425),G0tensor(814),G0tensor(654),G0tensor(643),G0tensor(634),G0tensor(629)])
  call ol_merge_tensors(G1tensor(434),[G1tensor(430),G0tensor(672),G0tensor(668)])
  call ol_merge_tensors(G1tensor(439),[G1tensor(431),G0tensor(677),G0tensor(669)])
  call ol_merge_tensors(G1tensor(445),[G1tensor(436),G0tensor(683),G0tensor(674)])
  call ol_merge_tensors(G1tensor(446),[G1tensor(441),G0tensor(684),G0tensor(679)])
  call ol_merge_tensors(G1tensor(454),[G1tensor(450),G0tensor(692),G0tensor(688)])
  call ol_merge_tensors(G1tensor(459),[G1tensor(451),G0tensor(697),G0tensor(689)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(500),G1tensor(495),G1tensor(460),G1tensor(455),G0tensor(738),G0tensor(733) &
    ,G0tensor(698),G0tensor(693)])
  call ol_merge_tensors(G1tensor(465),[G1tensor(456),G0tensor(703),G0tensor(694)])
  call ol_merge_tensors(G1tensor(466),[G1tensor(461),G0tensor(704),G0tensor(699)])
  call ol_merge_tensors(G1tensor(474),[G1tensor(470),G0tensor(712),G0tensor(708)])
  call ol_merge_tensors(G1tensor(479),[G1tensor(471),G0tensor(717),G0tensor(709)])
  call ol_merge_tensors(G1tensor(485),[G1tensor(476),G0tensor(723),G0tensor(714)])
  call ol_merge_tensors(G1tensor(486),[G1tensor(481),G0tensor(724),G0tensor(719)])
  call ol_merge_tensors(G1tensor(494),[G1tensor(490),G0tensor(732),G0tensor(728)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(499),G1tensor(491),G0tensor(737),G0tensor(729)])
  call ol_merge_tensors(G1tensor(504),[G1tensor(492),G0tensor(742),G0tensor(730)])
  call ol_merge_tensors(G1tensor(505),[G1tensor(496),G0tensor(743),G0tensor(734)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(661),G1tensor(506),G1tensor(501),G0tensor(929),G0tensor(744),G0tensor(739)])
  call ol_merge_tensors(G1tensor(555),[G1tensor(530),G1tensor(525),G0tensor(793),G0tensor(768),G0tensor(763)])
  call ol_merge_tensors(G1tensor(550),[G1tensor(541),G1tensor(535),G1tensor(526),G0tensor(788),G0tensor(779),G0tensor(773) &
    ,G0tensor(764)])
  call ol_merge_tensors(G1tensor(561),[G1tensor(536),G1tensor(531),G0tensor(799),G0tensor(774),G0tensor(769)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(545),G1tensor(540),G0tensor(783),G0tensor(778)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(551),G1tensor(546),G0tensor(789),G0tensor(784)])
  call ol_merge_tensors(G1tensor(560),[G1tensor(556),G0tensor(798),G0tensor(794)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(676),G1tensor(601),G1tensor(586),G1tensor(581),G0tensor(944),G0tensor(839) &
    ,G0tensor(824),G0tensor(819)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(671),G1tensor(596),G1tensor(591),G0tensor(939),G0tensor(834),G0tensor(829)])
  call ol_merge_tensors(G1tensor(626),[G1tensor(611),G1tensor(606),G0tensor(864),G0tensor(849),G0tensor(844)])
  call ol_merge_tensors(G2tensor(176),[G1tensor(621),G1tensor(616),G0tensor(859),G0tensor(854)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(48),G1tensor(639),G1tensor(634),G1tensor(629),G0tensor(907),G0tensor(902) &
    ,G0tensor(897)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(630),G0tensor(898)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(646),G1tensor(631),G0tensor(914),G0tensor(899)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(651),G1tensor(636),G0tensor(919),G0tensor(904)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(656),G1tensor(641),G0tensor(924),G0tensor(909)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(645),G0tensor(913)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(650),G0tensor(918)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(655),G0tensor(923)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(659),G0tensor(927)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(690),G1tensor(664),G0tensor(958),G0tensor(932)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(665),G0tensor(933)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(666),G0tensor(934)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(670),G0tensor(938)])
  call ol_merge_tensors(G2tensor(111),[G1tensor(675),G0tensor(943)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(680),G0tensor(948)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(681),G0tensor(949)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(685),G0tensor(953)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(686),G0tensor(954)])
  call ol_merge_tensors(G0tensor(387),[G0tensor(244),G0tensor(207),G0tensor(204)])
  call ol_merge_tensors(G0tensor(397),[G0tensor(212),G0tensor(205)])
  call ol_merge_tensors(G0tensor(382),[G0tensor(295),G0tensor(259),G0tensor(219),G0tensor(210)])
  call ol_merge_tensors(G0tensor(432),[G0tensor(344),G0tensor(270),G0tensor(239),G0tensor(230)])
  call ol_merge_tensors(G0tensor(462),[G0tensor(247),G0tensor(243)])
  call ol_merge_tensors(G0tensor(472),[G0tensor(252),G0tensor(245)])
  call ol_merge_tensors(G0tensor(452),[G0tensor(253),G0tensor(249)])
  call ol_merge_tensors(G0tensor(457),[G0tensor(320),G0tensor(258),G0tensor(250)])
  call ol_merge_tensors(G0tensor(612),[G0tensor(323),G0tensor(319)])
  call ol_merge_tensors(G0tensor(398),[G0tensor(374),G0tensor(365)])
  call ol_merge_tensors(G0tensor(448),[G0tensor(424),G0tensor(415)])
  call ol_merge_tensors(G0tensor(473),[G0tensor(464),G0tensor(455)])
  call ol_merge_tensors(G0tensor(548),[G0tensor(529),G0tensor(520),G0tensor(508),G0tensor(494),G0tensor(490)])
  call ol_merge_tensors(G0tensor(608),[G0tensor(589),G0tensor(580),G0tensor(573),G0tensor(559),G0tensor(555)])
  call ol_merge_tensors(G0tensor(623),[G0tensor(619),G0tensor(615)])
  call ol_merge_tensors(G0tensor(648),[G0tensor(639),G0tensor(630)])
  call ol_merge_tensors(G0tensor(663),[G0tensor(659),G0tensor(655)])
  call ol_merge_tensors(G0tensor(885),[G0tensor(880)])
  call ol_merge_tensors(G0tensor(894),[G0tensor(889)])
  call ol_merge_tensors(G3tensor(10),[G3tensor(9)])
  call ol_merge_tensors(G3tensor(13),[G3tensor(11)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(14)])
  call TI_triangle_red(G3tensor(20),RedBasis(93),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMW], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(89),RedBasis(2),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1)
  call TI_triangle_red(G2tensor(90),RedBasis(2),mass3set(:,3),G0tensor(46),G0tensor(51),G0tensor(56),G0tensor(61),M2L1R1,[nMZ], &
    G0tensor(66))
  call TI_triangle_red(G2tensor(92),RedBasis(2),mass3set(:,4),G0tensor(71),G0tensor(76),G0tensor(81),G0tensor(86),M2L1R1,[nMW], &
    G0tensor(91))
  call TI_triangle_red(G2tensor(95),RedBasis(8),mass3set(:,2),G0tensor(96),G0tensor(101),G0tensor(106),G0tensor(111),M2L1R1)
  call TI_triangle_red(G2tensor(96),RedBasis(8),mass3set(:,3),G0tensor(116),G0tensor(121),G0tensor(126), &
    G0tensor(131),M2L1R1,[nMZ],G0tensor(136))
  call TI_triangle_red(G2tensor(116),RedBasis(8),mass3set(:,4),G0tensor(141),G0tensor(146),G0tensor(151), &
    G0tensor(156),M2L1R1,[nMW],G0tensor(161))
  call TI_triangle_red(G2tensor(117),RedBasis(107),mass3set(:,5),G0tensor(166),G0tensor(171),G0tensor(176), &
    G0tensor(181),M2L1R1,[nMW],G0tensor(186))
  call TI_triangle_red(G2tensor(119),RedBasis(97),mass3set(:,5),G0tensor(191),G0tensor(196),G0tensor(201), &
    G0tensor(206),M2L1R1,[nMW],G0tensor(211))
  call TI_triangle_red(G2tensor(99),RedBasis(8),mass3set(:,6),G0tensor(216),G0tensor(221),G0tensor(226), &
    G0tensor(231),M2L1R1,[nMW],G0tensor(236))
  call TI_triangle_red(G2tensor(144),RedBasis(123),mass3set(:,1),G0tensor(241),G0tensor(246),G0tensor(251), &
    G0tensor(256),M2L1R1,[nMW],G0tensor(261))
  call TI_triangle_red(G2tensor(93),RedBasis(2),mass3set(:,6),G0tensor(266),G0tensor(271),G0tensor(276), &
    G0tensor(281),M2L1R1,[nMW],G0tensor(286))
  call TI_triangle_red(G2tensor(98),RedBasis(27),mass3set(:,6),G0tensor(291),G0tensor(296),G0tensor(301), &
    G0tensor(306),M2L1R1,[nMW],G0tensor(311))
  call TI_triangle_red(G2tensor(150),RedBasis(124),mass3set(:,7),G0tensor(316),G0tensor(321),G0tensor(326), &
    G0tensor(331),M2L1R1,[nMW],G0tensor(336))
  call TI_triangle_red(G2tensor(94),RedBasis(107),mass3set(:,8),G0tensor(341),G0tensor(346),G0tensor(351), &
    G0tensor(356),M2L1R1,[nMW],G0tensor(361))
  call TI_triangle_red(G2tensor(65),RedBasis(95),mass3set(:,7),G0tensor(366),G0tensor(371),G0tensor(376), &
    G0tensor(381),M2L1R1,[nMW],G0tensor(386))
  call TI_triangle_red(G2tensor(64),RedBasis(97),mass3set(:,8),G0tensor(391),G0tensor(396),G0tensor(401), &
    G0tensor(406),M2L1R1,[nMW],G0tensor(411))
  call TI_triangle_red(G2tensor(109),RedBasis(27),mass3set(:,4),G0tensor(416),G0tensor(421),G0tensor(426), &
    G0tensor(431),M2L1R1,[nMW],G0tensor(436))
  call TI_triangle_red(G2tensor(39),RedBasis(142),mass3set(:,4),G0tensor(441),G0tensor(446),G0tensor(451), &
    G0tensor(456),M2L1R1,[nMW],G0tensor(461))
  call TI_triangle_red(G3tensor(15),RedBasis(93),mass3set(:,2),G0tensor(466),G0tensor(471),G0tensor(476),G0tensor(481),M2L1R1)
  call TI_triangle_red(G2tensor(118),RedBasis(142),mass3set(:,3),G0tensor(486),G0tensor(491),G0tensor(496), &
    G0tensor(501),M2L1R1,[nMZ],G0tensor(506))
  call TI_triangle_red(G2tensor(84),RedBasis(110),mass3set(:,4),G0tensor(511),G0tensor(516),G0tensor(521), &
    G0tensor(526),M2L1R1,[nMW],G0tensor(531))
  call TI_triangle_red(G2tensor(105),RedBasis(110),mass3set(:,3),G0tensor(536),G0tensor(541),G0tensor(546), &
    G0tensor(551),M2L1R1,[nMZ],G0tensor(556))
  call TI_triangle_red(G2tensor(171),RedBasis(132),mass3set(:,8),G0tensor(561),G0tensor(566),G0tensor(571), &
    G0tensor(576),M2L1R1,[nMW],G0tensor(581))
  call TI_triangle_red(G2tensor(12),RedBasis(92),mass3set(:,8),G0tensor(586),G0tensor(591),G0tensor(596), &
    G0tensor(601),M2L1R1,[nMW],G0tensor(606))
  call TI_triangle_red(G2tensor(174),RedBasis(132),mass3set(:,9),G0tensor(611),G0tensor(616),G0tensor(621), &
    G0tensor(626),M2L1R1,[nMZ],G0tensor(631))
  call TI_triangle_red(G2tensor(14),RedBasis(92),mass3set(:,9),G0tensor(636),G0tensor(641),G0tensor(646), &
    G0tensor(651),M2L1R1,[nMZ],G0tensor(656))
  call TI_triangle_red(G2tensor(177),RedBasis(132),mass3set(:,5),G0tensor(661),G0tensor(666),G0tensor(671), &
    G0tensor(676),M2L1R1,[nMW],G0tensor(681))
  call TI_triangle_red(G2tensor(70),RedBasis(92),mass3set(:,5),G0tensor(686),G0tensor(691),G0tensor(696), &
    G0tensor(701),M2L1R1,[nMW],G0tensor(706))
  call TI_triangle_red(G2tensor(114),RedBasis(126),mass3set(:,8),G0tensor(711),G0tensor(716),G0tensor(721), &
    G0tensor(726),M2L1R1,[nMW],G0tensor(731))
  call TI_triangle_red(G2tensor(35),RedBasis(126),mass3set(:,9),G0tensor(736),G0tensor(741),G0tensor(746), &
    G0tensor(751),M2L1R1,[nMZ],G0tensor(756))
  call TI_triangle_red(G2tensor(43),RedBasis(97),mass3set(:,9),G0tensor(761),G0tensor(766),G0tensor(771), &
    G0tensor(776),M2L1R1,[nMZ],G0tensor(781))
  call TI_triangle_red(G2tensor(87),RedBasis(126),mass3set(:,5),G0tensor(786),G0tensor(791),G0tensor(796), &
    G0tensor(801),M2L1R1,[nMW],G0tensor(806))
  call TI_triangle_red(G2tensor(113),RedBasis(27),mass3set(:,3),G0tensor(811),G0tensor(816),G0tensor(821), &
    G0tensor(826),M2L1R1,[nMZ],G0tensor(831))
  call TI_triangle_red(G2tensor(185),RedBasis(86),mass3set(:,7),G0tensor(836),G0tensor(841),G0tensor(846), &
    G0tensor(851),M2L1R1,[nMW],G0tensor(856))
  call TI_triangle_red(G2tensor(120),RedBasis(84),mass3set(:,7),G0tensor(861),G0tensor(866),G0tensor(871), &
    G0tensor(876),M2L1R1,[nMW],G0tensor(881))
  call TI_triangle_red(G2tensor(69),RedBasis(99),mass3set(:,7),G0tensor(886),G0tensor(891),G0tensor(896), &
    G0tensor(901),M2L1R1,[nMW],G0tensor(906))
  call TI_triangle_red(G2tensor(40),RedBasis(110),mass3set(:,6),G0tensor(911),G0tensor(916),G0tensor(921), &
    G0tensor(926),M2L1R1,[nMW],G0tensor(931))
  call TI_triangle_red(G2tensor(112),RedBasis(91),mass3set(:,5),G0tensor(936),G0tensor(941),G0tensor(946), &
    G0tensor(951),M2L1R1,[nMW],G0tensor(956))
  call TI_triangle_red(G2tensor(42),RedBasis(94),mass3set(:,5),G0tensor(961),G0tensor(966),G0tensor(971), &
    G0tensor(740),M2L1R1,[nMW],G0tensor(537))
  call TI_triangle_red(G2tensor(155),RedBasis(117),mass3set(:,6),G0tensor(25),G0tensor(19),G0tensor(14), &
    G0tensor(900),M2L1R1,[nMW],G0tensor(905))
  call TI_triangle_red(G2tensor(68),RedBasis(99),mass3set(:,10),G0tensor(910),G0tensor(915),G0tensor(920), &
    G0tensor(725),M2L1R1,[nMZ],G0tensor(685))
  call TI_triangle_red(G2tensor(66),RedBasis(99),mass3set(:,11),G0tensor(5),G0tensor(925),G0tensor(705),G0tensor(10),M2L1R1,[nMW], &
    G0tensor(930))
  call TI_triangle_red(G2tensor(63),RedBasis(95),mass3set(:,10),G0tensor(935),G0tensor(745),G0tensor(20), &
    G0tensor(785),M2L1R1,[nMZ],G0tensor(540))
  call TI_triangle_red(G2tensor(102),RedBasis(107),mass3set(:,9),G0tensor(34),G0tensor(30),G0tensor(597), &
    G0tensor(49),M2L1R1,[nMZ],G0tensor(40))
  call TI_triangle_red(G2tensor(77),RedBasis(40),mass3set(:,6),G0tensor(600),G0tensor(54),G0tensor(45),G0tensor(782),M2L1R1,[nMW], &
    G0tensor(598))
  call TI_triangle_red(G2tensor(78),RedBasis(33),mass3set(:,6),G0tensor(583),G0tensor(99),G0tensor(832), &
    G0tensor(582),M2L1R1,[nMW],G0tensor(155))
  call TI_triangle_red(G2tensor(110),RedBasis(88),mass3set(:,5),G0tensor(48),G0tensor(835),G0tensor(160), &
    G0tensor(857),M2L1R1,[nMW],G0tensor(522))
  call TI_triangle_red(G2tensor(53),RedBasis(142),mass3set(:,6),G0tensor(185),G0tensor(13),G0tensor(970), &
    G0tensor(860),M2L1R1,[nMW],G0tensor(190))
  call TI_triangle_red(G2tensor(46),RedBasis(98),mass3set(:,5),G0tensor(908),G0tensor(687),G0tensor(7),G0tensor(937),M2L1R1,[nMW], &
    G0tensor(752))
  call TI_triangle_red(G2tensor(101),RedBasis(86),mass3set(:,11),G0tensor(68),G0tensor(974),G0tensor(969), &
    G0tensor(964),M2L1R1,[nMW],G0tensor(959))
  call TI_triangle_red(G2tensor(104),RedBasis(84),mass3set(:,11),G0tensor(955),G0tensor(950),G0tensor(945), &
    G0tensor(940),M2L1R1,[nMW],G0tensor(922))
  call TI_triangle_red(G2tensor(56),RedBasis(98),mass3set(:,9),G0tensor(917),G0tensor(912),G0tensor(942), &
    G0tensor(747),M2L1R1,[nMZ],G0tensor(58))
  call TI_triangle_red(G2tensor(44),RedBasis(98),mass3set(:,8),G0tensor(947),G0tensor(928),G0tensor(952), &
    G0tensor(757),M2L1R1,[nMW],G0tensor(78))
  call TI_triangle_red(G2tensor(176),RedBasis(115),mass3set(:,8),G0tensor(957),G0tensor(960),G0tensor(962), &
    G0tensor(965),M2L1R1,[nMW],G0tensor(277))
  call TI_triangle_red(G2tensor(54),RedBasis(123),mass3set(:,2),G0tensor(153),G0tensor(97),G0tensor(38),G0tensor(32),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(27),mass3set(:,2),G0tensor(12),G0tensor(542),G0tensor(285),G0tensor(125),M2L1R1)
  call TI_triangle_red(G2tensor(50),RedBasis(33),mass3set(:,2),G0tensor(15),G0tensor(967),G0tensor(972),G0tensor(975),M2L1R1)
  call TI_triangle_red(G2tensor(75),RedBasis(33),mass3set(:,3),G0tensor(850),G0tensor(200),G0tensor(180), &
    G0tensor(727),M2L1R1,[nMZ],G0tensor(17))
  call TI_triangle_red(G2tensor(60),RedBasis(33),mass3set(:,4),G0tensor(903),G0tensor(707),G0tensor(667),G0tensor(2),M2L1R1,[nMW], &
    G0tensor(715))
  call TI_triangle_red(G2tensor(80),RedBasis(40),mass3set(:,2),G0tensor(675),G0tensor(3),G0tensor(720),G0tensor(680),M2L1R1)
  call TI_triangle_red(G2tensor(81),RedBasis(40),mass3set(:,3),G0tensor(4),G0tensor(695),G0tensor(8),G0tensor(700),M2L1R1,[nMZ], &
    G0tensor(9))
  call TI_triangle_red(G2tensor(83),RedBasis(40),mass3set(:,4),G0tensor(735),G0tensor(18),G0tensor(833), &
    G0tensor(279),M2L1R1,[nMW],G0tensor(27))
  call TI_triangle_red(G2tensor(71),RedBasis(124),mass3set(:,11),G0tensor(22),G0tensor(512),G0tensor(302), &
    G0tensor(183),M2L1R1,[nMW],G0tensor(52))
  call TI_triangle_red(G2tensor(72),RedBasis(95),mass3set(:,11),G0tensor(47),G0tensor(23),G0tensor(532), &
    G0tensor(284),M2L1R1,[nMW],G0tensor(69))
  call TI_triangle_red(G2tensor(86),RedBasis(117),mass3set(:,4),G0tensor(24),G0tensor(528),G0tensor(515), &
    G0tensor(28),M2L1R1,[nMW],G0tensor(549))
  call TI_triangle_red(G2tensor(74),RedBasis(115),mass3set(:,5),G0tensor(535),G0tensor(74),G0tensor(29), &
    G0tensor(780),M2L1R1,[nMW],G0tensor(530))
  call TI_triangle_red(G2tensor(51),RedBasis(88),mass3set(:,8),G0tensor(525),G0tensor(33),G0tensor(790), &
    G0tensor(550),M2L1R1,[nMW],G0tensor(545))
  call TI_triangle_red(G2tensor(111),RedBasis(88),mass3set(:,9),G0tensor(130),G0tensor(35),G0tensor(858), &
    G0tensor(304),M2L1R1,[nMZ],G0tensor(42))
  call TI_triangle_red(G2tensor(57),RedBasis(91),mass3set(:,8),G0tensor(37),G0tensor(592),G0tensor(309), &
    G0tensor(124),M2L1R1,[nMW],G0tensor(39))
  call TI_triangle_red(G2tensor(59),RedBasis(94),mass3set(:,8),G0tensor(787),G0tensor(588),G0tensor(100), &
    G0tensor(43),M2L1R1,[nMW],G0tensor(609))
  call TI_triangle_red(G2tensor(106),RedBasis(91),mass3set(:,9),G0tensor(595),G0tensor(129),G0tensor(44), &
    G0tensor(602),M2L1R1,[nMZ],G0tensor(310))
  call TI_triangle_red(G2tensor(62),RedBasis(94),mass3set(:,9),G0tensor(70),G0tensor(50),G0tensor(590),G0tensor(585),M2L1R1,[nMZ], &
    G0tensor(53))
  call TI_triangle_red(G3tensor(10),RedBasis(93),mass3set(:,12),G0tensor(610),G0tensor(605),G0tensor(75), &
    G0tensor(55),M2L1R1,[nML],G0tensor(62))
  call TI_triangle_red(G3tensor(13),RedBasis(93),mass3set(:,13),G0tensor(57),G0tensor(497),G0tensor(359), &
    G0tensor(274),M2L1R1,[nMT],G0tensor(269))
  call TI_triangle_red(G3tensor(16),RedBasis(93),mass3set(:,14),G0tensor(59),G0tensor(392),G0tensor(300), &
    G0tensor(220),M2L1R1,[nMB],G0tensor(215))
  call TI_triangle_red(G1tensor(477),RedBasis(86),mass3set(:,15),G0tensor(60),G0tensor(755),G0tensor(750), &
    G0tensor(702),M2L1R1,[nMZ],G0tensor(690))
  call TI_triangle_red(G1tensor(482),RedBasis(84),mass3set(:,15),G0tensor(682),G0tensor(670),G0tensor(73), &
    G0tensor(63),M2L1R1,[nMZ],G0tensor(664))
  call TI_triangle_red(G1tensor(377),RedBasis(18),mass3set(:,11),G0tensor(509),G0tensor(504),G0tensor(500), &
    G0tensor(64),M2L1R1,[nMW],G0tensor(575))
  call TI_triangle_red(G1tensor(387),RedBasis(16),mass3set(:,11),G0tensor(405),G0tensor(400),G0tensor(395), &
    G0tensor(65),M2L1R1,[nMW],G0tensor(72))
  call TI_triangle_red(G1tensor(542),RedBasis(10),mass3set(:,8),G0tensor(67),G0tensor(82),G0tensor(77),G0tensor(427),M2L1R1,[nMW], &
    G0tensor(339))
  call TI_triangle_red(G1tensor(552),RedBasis(7),mass3set(:,11),G0tensor(234),G0tensor(229),G0tensor(79), &
    G0tensor(467),M2L1R1,[nMW],G0tensor(325))
  call TI_triangle_red(G1tensor(409),RedBasis(130),mass3set(:,5),G0tensor(260),G0tensor(255),G0tensor(80), &
    G0tensor(760),M2L1R1,[nMW],G0tensor(722))
  call TI_triangle_red(G1tensor(549),RedBasis(21),mass3set(:,11),G0tensor(710),G0tensor(83),G0tensor(649), &
    G0tensor(449),M2L1R1,[nMW],G0tensor(439))
  call TI_triangle_red(G1tensor(412),RedBasis(19),mass3set(:,11),G0tensor(430),G0tensor(84),G0tensor(625), &
    G0tensor(480),M2L1R1,[nMW],G0tensor(475))
  call TI_triangle_red(G1tensor(419),RedBasis(122),mass3set(:,5),G0tensor(470),G0tensor(85),G0tensor(887), &
    G0tensor(318),M2L1R1,[nMW],G0tensor(293))
  call TI_triangle_red(G1tensor(407),RedBasis(4),mass3set(:,8),G0tensor(262),G0tensor(237),G0tensor(222), &
    G0tensor(163),M2L1R1,[nMW],G0tensor(92))
  call TI_triangle_red(G1tensor(422),RedBasis(1),mass3set(:,11),G0tensor(87),G0tensor(803),G0tensor(762), &
    G0tensor(613),M2L1R1,[nMW],G0tensor(563))
  call TI_triangle_red(G1tensor(152),RedBasis(128),mass3set(:,10),G0tensor(553),G0tensor(88),G0tensor(767), &
    G0tensor(458),M2L1R1,[nMZ],G0tensor(383))
  call TI_triangle_red(G1tensor(369),RedBasis(94),mass3set(:,16),G0tensor(368),G0tensor(104),G0tensor(89), &
    G0tensor(772),M2L1R1,[nMZ],G0tensor(618))
  call TI_triangle_red(G1tensor(261),RedBasis(122),mass3set(:,16),G0tensor(568),G0tensor(558),G0tensor(90), &
    G0tensor(765),M2L1R1,[nMZ],G0tensor(495))
  call TI_triangle_red(G1tensor(517),RedBasis(101),mass3set(:,2),G0tensor(425),G0tensor(420),G0tensor(93),G0tensor(770),M2L1R1)
  call TI_triangle_red(G1tensor(372),RedBasis(16),mass3set(:,10),G0tensor(505),G0tensor(440),G0tensor(435), &
    G0tensor(109),M2L1R1,[nMZ],G0tensor(94))
  call TI_triangle_red(G1tensor(273),RedBasis(1),mass3set(:,10),G0tensor(775),G0tensor(510),G0tensor(450), &
    G0tensor(445),M2L1R1,[nMZ],G0tensor(120))
  call TI_triangle_red(G1tensor(210),RedBasis(128),mass3set(:,11),G0tensor(95),G0tensor(808),G0tensor(777), &
    G0tensor(593),M2L1R1,[nMW],G0tensor(578))
  call TI_triangle_red(G1tensor(171),RedBasis(124),mass3set(:,10),G0tensor(98),G0tensor(892),G0tensor(347), &
    G0tensor(342),M2L1R1,[nMZ],G0tensor(327))
  call TI_triangle_red(G1tensor(310),RedBasis(98),mass3set(:,16),G0tensor(248),G0tensor(208),G0tensor(143), &
    G0tensor(107),M2L1R1,[nMZ],G0tensor(102))
  call TI_triangle_red(G1tensor(327),RedBasis(107),mass3set(:,16),G0tensor(813),G0tensor(792),G0tensor(453), &
    G0tensor(378),M2L1R1,[nMZ],G0tensor(363))
  call TI_triangle_red(G1tensor(522),RedBasis(102),mass3set(:,2),G0tensor(103),G0tensor(797),G0tensor(463),G0tensor(388),M2L1R1)
  call TI_triangle_red(G1tensor(303),RedBasis(9),mass3set(:,10),G0tensor(373),G0tensor(105),G0tensor(795), &
    G0tensor(660),M2L1R1,[nMZ],G0tensor(640))
  call TI_triangle_red(G1tensor(365),RedBasis(13),mass3set(:,10),G0tensor(635),G0tensor(108),G0tensor(800), &
    G0tensor(665),M2L1R1,[nMZ],G0tensor(650))
  call TI_triangle_red(G1tensor(221),RedBasis(132),mass3set(:,16),G0tensor(645),G0tensor(140),G0tensor(110), &
    G0tensor(973),M2L1R1,[nMZ],G0tensor(117))
  call TI_triangle_red(G1tensor(565),RedBasis(65),mass3set(:,9),G0tensor(112),G0tensor(802),G0tensor(113), &
    G0tensor(562),M2L1R1,[nMZ],G0tensor(324))
  call TI_triangle_red(G1tensor(529),RedBasis(27),mass3set(:,17),G0tensor(299),G0tensor(294),G0tensor(114), &
    G0tensor(442),M2L1R1,[nMZ],G0tensor(275))
  call TI_triangle_red(G1tensor(534),RedBasis(21),mass3set(:,10),G0tensor(240),G0tensor(235),G0tensor(115), &
    G0tensor(810),M2L1R1,[nMZ],G0tensor(805))
  call TI_triangle_red(G1tensor(527),RedBasis(10),mass3set(:,9),G0tensor(128),G0tensor(118),G0tensor(624), &
    G0tensor(574),M2L1R1,[nMZ],G0tensor(569))
  call TI_triangle_red(G1tensor(532),RedBasis(8),mass3set(:,17),G0tensor(565),G0tensor(119),G0tensor(968), &
    G0tensor(127),M2L1R1,[nMZ],G0tensor(122))
  call TI_triangle_red(G1tensor(537),RedBasis(7),mass3set(:,10),G0tensor(807),G0tensor(123),G0tensor(963), &
    G0tensor(137),M2L1R1,[nMZ],G0tensor(132))
  call TI_triangle_red(G1tensor(570),RedBasis(65),mass3set(:,8),G0tensor(812),G0tensor(133),G0tensor(377), &
    G0tensor(254),M2L1R1,[nMW],G0tensor(214))
  call TI_triangle_red(G1tensor(169),RedBasis(126),mass3set(:,16),G0tensor(209),G0tensor(134),G0tensor(642), &
    G0tensor(360),M2L1R1,[nMZ],G0tensor(345))
  call TI_triangle_red(G1tensor(575),RedBasis(28),mass3set(:,9),G0tensor(340),G0tensor(135),G0tensor(815), &
    G0tensor(138),M2L1R1,[nMZ],G0tensor(474))
  call TI_triangle_red(G1tensor(559),RedBasis(6),mass3set(:,10),G0tensor(399),G0tensor(389),G0tensor(380), &
    G0tensor(139),M2L1R1,[nMZ],G0tensor(372))
  call TI_triangle_red(G1tensor(557),RedBasis(24),mass3set(:,9),G0tensor(203),G0tensor(147),G0tensor(142), &
    G0tensor(817),M2L1R1,[nMZ],G0tensor(362))
  call TI_triangle_red(G1tensor(562),RedBasis(23),mass3set(:,10),G0tensor(213),G0tensor(144),G0tensor(822), &
    G0tensor(367),M2L1R1,[nMZ],G0tensor(218))
  call TI_triangle_red(G1tensor(564),RedBasis(143),mass3set(:,3),G0tensor(165),G0tensor(145),G0tensor(662), &
    G0tensor(357),M2L1R1,[nMZ],G0tensor(350))
  call TI_triangle_red(G1tensor(399),RedBasis(130),mass3set(:,16),G0tensor(148),G0tensor(845),G0tensor(820), &
    G0tensor(179),M2L1R1,[nMZ],G0tensor(149))
  call TI_triangle_red(G1tensor(305),RedBasis(92),mass3set(:,16),G0tensor(825),G0tensor(170),G0tensor(150), &
    G0tensor(853),M2L1R1,[nMZ],G0tensor(587))
  call TI_triangle_red(G1tensor(572),RedBasis(105),mass3set(:,2),G0tensor(303),G0tensor(157),G0tensor(152),G0tensor(827),M2L1R1)
  call TI_triangle_red(G1tensor(402),RedBasis(19),mass3set(:,10),G0tensor(577),G0tensor(308),G0tensor(154), &
    G0tensor(547),M2L1R1,[nMZ],G0tensor(282))
  call TI_triangle_red(G1tensor(569),RedBasis(143),mass3set(:,4),G0tensor(280),G0tensor(158),G0tensor(840), &
    G0tensor(830),M2L1R1,[nMW],G0tensor(169))
  call TI_triangle_red(G1tensor(574),RedBasis(117),mass3set(:,3),G0tensor(159),G0tensor(863),G0tensor(557), &
    G0tensor(288),M2L1R1,[nMZ],G0tensor(167))
  call TI_triangle_red(G1tensor(254),RedBasis(115),mass3set(:,16),G0tensor(162),G0tensor(837),G0tensor(552), &
    G0tensor(298),M2L1R1,[nMZ],G0tensor(164))
  call TI_triangle_red(G1tensor(424),RedBasis(97),mass3set(:,16),G0tensor(507),G0tensor(272),G0tensor(265), &
    G0tensor(168),M2L1R1,[nMZ],G0tensor(422))
  call TI_triangle_red(G1tensor(577),RedBasis(106),mass3set(:,2),G0tensor(223),G0tensor(177),G0tensor(172),G0tensor(878),M2L1R1)
  call TI_triangle_red(G1tensor(257),RedBasis(3),mass3set(:,10),G0tensor(678),G0tensor(673),G0tensor(477), &
    G0tensor(407),M2L1R1,[nMZ],G0tensor(333))
  call TI_triangle_red(G1tensor(10),RedBasis(153),mass3set(:,9),G0tensor(312),G0tensor(257),G0tensor(242), &
    G0tensor(228),M2L1R1,[nMZ],G0tensor(173))
  call TI_triangle_red(G1tensor(579),RedBasis(125),mass3set(:,3),G0tensor(842),G0tensor(412),G0tensor(233), &
    G0tensor(174),M2L1R1,[nMZ],G0tensor(847))
  call TI_triangle_red(G1tensor(584),RedBasis(124),mass3set(:,15),G0tensor(417),G0tensor(238),G0tensor(195), &
    G0tensor(175),M2L1R1,[nMZ],G0tensor(622))
  call TI_triangle_red(G1tensor(237),RedBasis(109),mass3set(:,10),G0tensor(322),G0tensor(315),G0tensor(178), &
    G0tensor(828),M2L1R1,[nMZ],G0tensor(527))
  call TI_triangle_red(G1tensor(607),RedBasis(108),mass3set(:,2),G0tensor(278),G0tensor(187),G0tensor(182),G0tensor(852),M2L1R1)
  call TI_triangle_red(G1tensor(615),RedBasis(121),mass3set(:,8),G0tensor(517),G0tensor(283),G0tensor(184), &
    G0tensor(607),M2L1R1,[nMW],G0tensor(307))
  call TI_triangle_red(G1tensor(589),RedBasis(131),mass3set(:,4),G0tensor(305),G0tensor(188),G0tensor(865), &
    G0tensor(855),M2L1R1,[nMW],G0tensor(199))
  call TI_triangle_red(G1tensor(142),RedBasis(113),mass3set(:,11),G0tensor(189),G0tensor(838),G0tensor(492), &
    G0tensor(263),M2L1R1,[nMW],G0tensor(197))
  call TI_triangle_red(G1tensor(602),RedBasis(112),mass3set(:,2),G0tensor(192),G0tensor(883),G0tensor(718),G0tensor(713),M2L1R1)
  call TI_triangle_red(G1tensor(625),RedBasis(121),mass3set(:,9),G0tensor(482),G0tensor(402),G0tensor(353), &
    G0tensor(287),M2L1R1,[nMZ],G0tensor(268))
  call TI_triangle_red(G1tensor(599),RedBasis(131),mass3set(:,3),G0tensor(217),G0tensor(202),G0tensor(193), &
    G0tensor(862),M2L1R1,[nMZ],G0tensor(487))
  call TI_triangle_red(G1tensor(126),RedBasis(113),mass3set(:,10),G0tensor(273),G0tensor(194),G0tensor(572), &
    G0tensor(297),M2L1R1,[nMZ],G0tensor(290))
  call TI_triangle_red(G1tensor(112),RedBasis(145),mass3set(:,9),G0tensor(198),G0tensor(437),G0tensor(329), &
    G0tensor(227),M2L1R1,[nMZ],G0tensor(224))
  call TI_triangle_red(G1tensor(139),RedBasis(88),mass3set(:,16),G0tensor(447),G0tensor(232),G0tensor(225), &
    G0tensor(823),M2L1R1,[nMZ],G0tensor(502))
  call TI_triangle_red(G1tensor(604),RedBasis(127),mass3set(:,3),G0tensor(349),G0tensor(267),G0tensor(264), &
    G0tensor(848),M2L1R1,[nMZ],G0tensor(567))
  call TI_triangle_red(G1tensor(609),RedBasis(95),mass3set(:,15),G0tensor(314),G0tensor(292),G0tensor(289), &
    G0tensor(843),M2L1R1,[nMZ],G0tensor(617))
  call TI_triangle_red(G1tensor(184),RedBasis(116),mass3set(:,10),G0tensor(317),G0tensor(313),G0tensor(637), &
    G0tensor(332),M2L1R1,[nMZ],G0tensor(328))
  call TI_triangle_red(G1tensor(590),RedBasis(114),mass3set(:,8),G0tensor(647),G0tensor(337),G0tensor(330), &
    G0tensor(627),M2L1R1,[nMW],G0tensor(338))
  call TI_triangle_red(G1tensor(614),RedBasis(96),mass3set(:,4),G0tensor(334),G0tensor(632),G0tensor(355), &
    G0tensor(343),M2L1R1,[nMW],G0tensor(335))
  call TI_triangle_red(G1tensor(167),RedBasis(120),mass3set(:,11),G0tensor(818),G0tensor(657),G0tensor(352), &
    G0tensor(348),M2L1R1,[nMW],G0tensor(652))
  call TI_triangle_red(G1tensor(627),RedBasis(119),mass3set(:,2),G0tensor(358),G0tensor(354),G0tensor(874),G0tensor(869),M2L1R1)
  call TI_triangle_red(G1tensor(600),RedBasis(114),mass3set(:,9),G0tensor(644),G0tensor(564),G0tensor(499), &
    G0tensor(469),M2L1R1,[nMZ],G0tensor(444))
  call TI_triangle_red(G1tensor(480),RedBasis(91),mass3set(:,16),G0tensor(434),G0tensor(429),G0tensor(394), &
    G0tensor(384),M2L1R1,[nMZ],G0tensor(379))
  call TI_triangle_red(G1tensor(624),RedBasis(96),mass3set(:,3),G0tensor(749),G0tensor(554),G0tensor(393), &
    G0tensor(369),M2L1R1,[nMZ],G0tensor(364))
  call TI_triangle_red(G1tensor(160),RedBasis(120),mass3set(:,10),G0tensor(560),G0tensor(403),G0tensor(375), &
    G0tensor(370),M2L1R1,[nMZ],G0tensor(570))
  call TI_triangle_red(G1tensor(191),RedBasis(142),mass3set(:,17),G0tensor(479),G0tensor(404),G0tensor(390), &
    G0tensor(385),M2L1R1,[nMZ],G0tensor(758))
  call TI_triangle_red(G1tensor(113),RedBasis(144),mass3set(:,10),G0tensor(628),G0tensor(428),G0tensor(413), &
    G0tensor(408),M2L1R1,[nMZ],G0tensor(633))
  call TI_triangle_red(G1tensor(585),RedBasis(110),mass3set(:,17),G0tensor(484),G0tensor(433),G0tensor(418), &
    G0tensor(409),M2L1R1,[nMZ],G0tensor(638))
  call TI_triangle_red(G1tensor(610),RedBasis(117),mass3set(:,17),G0tensor(438),G0tensor(423),G0tensor(410), &
    G0tensor(804),M2L1R1,[nMZ],G0tensor(489))
  call TI_triangle_red(G1tensor(605),RedBasis(118),mass3set(:,9),G0tensor(443),G0tensor(419),G0tensor(414), &
    G0tensor(759),M2L1R1,[nMZ],G0tensor(614))
  call TI_triangle_red(G1tensor(196),RedBasis(147),mass3set(:,9),G0tensor(468),G0tensor(459),G0tensor(454), &
    G0tensor(620),M2L1R1,[nMZ],G0tensor(478))
  call TI_triangle_red(G1tensor(322),RedBasis(146),mass3set(:,10),G0tensor(465),G0tensor(460),G0tensor(748), &
    G0tensor(653),M2L1R1,[nMZ],G0tensor(498))
  call TI_triangle_red(G1tensor(197),RedBasis(100),mass3set(:,3),G0tensor(488),G0tensor(483),G0tensor(658), &
    G0tensor(503),M2L1R1,[nMZ],G0tensor(493))
  call TI_triangle_red(G1tensor(233),RedBasis(99),mass3set(:,15),G0tensor(485),G0tensor(753),G0tensor(533), &
    G0tensor(518),M2L1R1,[nMZ],G0tensor(513))
  call TI_triangle_red(G1tensor(580),RedBasis(111),mass3set(:,9),G0tensor(538),G0tensor(523),G0tensor(514), &
    G0tensor(809),M2L1R1,[nMZ],G0tensor(543))
  call TI_triangle_red(G1tensor(239),RedBasis(134),mass3set(:,3),G0tensor(524),G0tensor(519),G0tensor(604), &
    G0tensor(599),M2L1R1,[nMZ],G0tensor(594))
  call TI_triangle_red(G1tensor(109),RedBasis(33),mass3set(:,17),G0tensor(544),G0tensor(539),G0tensor(534), &
    G0tensor(754),M2L1R1,[nMZ],G0tensor(603))
  call TI_triangle_red(G1tensor(511),RedBasis(29),mass3set(:,9),G0tensor(584),G0tensor(579),G0tensor(814), &
    G0tensor(654),M2L1R1,[nMZ],G0tensor(643))
  call TI_triangle_red(G1tensor(269),RedBasis(4),mass3set(:,9),G0tensor(634),G0tensor(629),G0tensor(672), &
    G0tensor(668),M2L1R1,[nMZ],G0tensor(677))
  call TI_triangle_red(G1tensor(352),RedBasis(2),mass3set(:,17),G0tensor(669),G0tensor(683),G0tensor(674), &
    G0tensor(684),M2L1R1,[nMZ],G0tensor(679))
  call TI_triangle_red(G1tensor(520),RedBasis(41),mass3set(:,9),G0tensor(692),G0tensor(688),G0tensor(697), &
    G0tensor(689),M2L1R1,[nMZ],G0tensor(738))
  call TI_triangle_red(G1tensor(364),RedBasis(40),mass3set(:,17),G0tensor(733),G0tensor(698),G0tensor(693), &
    G0tensor(703),M2L1R1,[nMZ],G0tensor(694))
  call TI_triangle_red(G1tensor(291),RedBasis(12),mass3set(:,10),G0tensor(704),G0tensor(699),G0tensor(712), &
    G0tensor(708),M2L1R1,[nMZ],G0tensor(717))
  call TI_triangle_red(G1tensor(566),RedBasis(42),mass3set(:,9),G0tensor(709),G0tensor(723),G0tensor(714), &
    G0tensor(724),M2L1R1,[nMZ],G0tensor(719))
  call TI_triangle_red(G1tensor(521),RedBasis(52),mass3set(:,9),G0tensor(732),G0tensor(728),G0tensor(737), &
    G0tensor(729),M2L1R1,[nMZ],G0tensor(742))
  call TI_triangle_red(G1tensor(346),RedBasis(14),mass3set(:,9),G0tensor(730),G0tensor(743),G0tensor(734), &
    G0tensor(929),M2L1R1,[nMZ],G0tensor(744))
  call TI_triangle_red(G1tensor(510),RedBasis(59),mass3set(:,9),G0tensor(739),G0tensor(793),G0tensor(768), &
    G0tensor(763),M2L1R1,[nMZ],G0tensor(788))
  call TI_triangle_red(G1tensor(367),RedBasis(18),mass3set(:,10),G0tensor(779),G0tensor(773),G0tensor(764), &
    G0tensor(799),M2L1R1,[nMZ],G0tensor(774))
  call TI_triangle_red(G1tensor(515),RedBasis(59),mass3set(:,8),G0tensor(769),G0tensor(783),G0tensor(778), &
    G0tensor(789),M2L1R1,[nMW],G0tensor(784))
  call TI_triangle_red(G1tensor(571),RedBasis(42),mass3set(:,8),G0tensor(798),G0tensor(794),G0tensor(944), &
    G0tensor(839),M2L1R1,[nMW],G0tensor(824))
  call TI_triangle_red(G1tensor(516),RedBasis(29),mass3set(:,8),G0tensor(819),G0tensor(939),G0tensor(834), &
    G0tensor(829),M2L1R1,[nMW],G0tensor(864))
  call TI_triangle_red(G1tensor(576),RedBasis(74),mass3set(:,9),G0tensor(849),G0tensor(844),G0tensor(859), &
    G0tensor(854),M2L1R1,[nMZ],G0tensor(907))
  call TI_triangle_red(G1tensor(434),RedBasis(149),mass3set(:,9),G0tensor(902),G0tensor(897),G0tensor(898), &
    G0tensor(914),M2L1R1,[nMZ],G0tensor(899))
  call TI_triangle_red(G1tensor(439),RedBasis(148),mass3set(:,9),G0tensor(919),G0tensor(904),G0tensor(924), &
    G0tensor(909),M2L1R1,[nMZ],G0tensor(913))
  call TI_triangle_red(G1tensor(445),RedBasis(87),mass3set(:,3),G0tensor(918),G0tensor(923),G0tensor(927), &
    G0tensor(958),M2L1R1,[nMZ],G0tensor(932))
  call TI_triangle_red(G1tensor(446),RedBasis(85),mass3set(:,3),G0tensor(933),G0tensor(934),G0tensor(938), &
    G0tensor(943),M2L1R1,[nMZ],G0tensor(948))
  call TI_triangle_red(G1tensor(454),RedBasis(149),mass3set(:,8),G0tensor(949),G0tensor(953),G0tensor(954), &
    G0tensor(244),M2L1R1,[nMW],G0tensor(207))
  call TI_triangle_red(G1tensor(459),RedBasis(148),mass3set(:,8),G0tensor(204),G0tensor(212),G0tensor(205), &
    G0tensor(295),M2L1R1,[nMW],G0tensor(259))
  call TI_triangle_red(G1tensor(465),RedBasis(87),mass3set(:,4),G0tensor(219),G0tensor(210),G0tensor(344), &
    G0tensor(270),M2L1R1,[nMW],G0tensor(239))
  call TI_triangle_red(G1tensor(466),RedBasis(85),mass3set(:,4),G0tensor(230),G0tensor(247),G0tensor(243), &
    G0tensor(252),M2L1R1,[nMW],G0tensor(245))
  call TI_triangle_red(G1tensor(474),RedBasis(151),mass3set(:,9),G0tensor(253),G0tensor(249),G0tensor(320), &
    G0tensor(258),M2L1R1,[nMZ],G0tensor(250))
  call TI_triangle_red(G1tensor(479),RedBasis(150),mass3set(:,9),G0tensor(323),G0tensor(319),G0tensor(374), &
    G0tensor(365),M2L1R1,[nMZ],G0tensor(424))
  call TI_triangle_red(G1tensor(485),RedBasis(90),mass3set(:,3),G0tensor(415),G0tensor(464),G0tensor(455), &
    G0tensor(529),M2L1R1,[nMZ],G0tensor(520))
  call TI_triangle_red(G1tensor(486),RedBasis(89),mass3set(:,3),G0tensor(508),G0tensor(494),G0tensor(490), &
    G0tensor(589),M2L1R1,[nMZ],G0tensor(580))
  call TI_triangle_red(G1tensor(494),RedBasis(147),mass3set(:,8),G0tensor(573),G0tensor(559),G0tensor(555), &
    G0tensor(619),M2L1R1,[nMW],G0tensor(615))
  call TI_triangle_red(G1tensor(504),RedBasis(146),mass3set(:,11),G0tensor(639),G0tensor(630),G0tensor(659), &
    G0tensor(655),M2L1R1,[nMW],G0tensor(880))
  call TI_triangle_red(G1tensor(505),RedBasis(100),mass3set(:,4),G0tensor(889),G0tensor(976),G0tensor(977), &
    G0tensor(978),M2L1R1,[nMW],G0tensor(979))
  call TI_triangle_red(G1tensor(555),RedBasis(86),mass3set(:,10),G0tensor(980),G0tensor(981),G0tensor(982), &
    G0tensor(983),M2L1R1,[nMZ],G0tensor(984))
  call TI_triangle_red(G1tensor(550),RedBasis(103),mass3set(:,2),G0tensor(985),G0tensor(986),G0tensor(987),G0tensor(988),M2L1R1)
  call TI_triangle_red(G1tensor(561),RedBasis(84),mass3set(:,10),G0tensor(989),G0tensor(990),G0tensor(991), &
    G0tensor(992),M2L1R1,[nMZ],G0tensor(993))
  call TI_triangle_red(G1tensor(560),RedBasis(104),mass3set(:,2),G0tensor(994),G0tensor(995),G0tensor(996),G0tensor(997),M2L1R1)
  call TI_triangle_red(G1tensor(626),RedBasis(115),mass3set(:,9),G0tensor(998),G0tensor(999),G0tensor(1000), &
    G0tensor(1001),M2L1R1,[nMZ],G0tensor(1002))
  call ol_merge_tensors(T0sum(196),[G0tensor(1)])
  call ol_merge_tensors(T0sum(197),[G0tensor(26)])
  call ol_merge_tensors(T0sum(198),[G0tensor(46)])
  call ol_merge_tensors(T0sum(199),[G0tensor(71)])
  call ol_merge_tensors(T0sum(200),[G0tensor(96)])
  call ol_merge_tensors(T0sum(201),[G0tensor(116)])
  call ol_merge_tensors(T0sum(202),[G0tensor(141)])
  call ol_merge_tensors(T0sum(203),[G0tensor(166)])
  call ol_merge_tensors(T0sum(204),[G0tensor(191)])
  call ol_merge_tensors(T0sum(205),[G0tensor(216)])
  call ol_merge_tensors(T0sum(206),[G0tensor(241)])
  call ol_merge_tensors(T0sum(207),[G0tensor(266)])
  call ol_merge_tensors(T0sum(208),[G0tensor(291)])
  call ol_merge_tensors(T0sum(209),[G0tensor(316)])
  call ol_merge_tensors(T0sum(210),[G0tensor(341)])
  call ol_merge_tensors(T0sum(211),[G0tensor(366)])
  call ol_merge_tensors(T0sum(212),[G0tensor(391)])
  call ol_merge_tensors(T0sum(213),[G0tensor(416)])
  call ol_merge_tensors(T0sum(214),[G0tensor(441)])
  call ol_merge_tensors(T0sum(215),[G0tensor(466)])
  call ol_merge_tensors(T0sum(216),[G0tensor(486)])
  call ol_merge_tensors(T0sum(217),[G0tensor(511)])
  call ol_merge_tensors(T0sum(218),[G0tensor(536)])
  call ol_merge_tensors(T0sum(219),[G0tensor(561)])
  call ol_merge_tensors(T0sum(220),[G0tensor(586)])
  call ol_merge_tensors(T0sum(221),[G0tensor(611)])
  call ol_merge_tensors(T0sum(222),[G0tensor(636)])
  call ol_merge_tensors(T0sum(223),[G0tensor(661)])
  call ol_merge_tensors(T0sum(224),[G0tensor(686)])
  call ol_merge_tensors(T0sum(225),[G0tensor(711)])
  call ol_merge_tensors(T0sum(226),[G0tensor(736)])
  call ol_merge_tensors(T0sum(227),[G0tensor(761)])
  call ol_merge_tensors(T0sum(228),[G0tensor(786)])
  call ol_merge_tensors(T0sum(229),[G0tensor(811)])
  call ol_merge_tensors(T0sum(230),[G0tensor(60)])
  call ol_merge_tensors(T0sum(231),[G0tensor(682)])
  call ol_merge_tensors(T0sum(232),[G0tensor(836)])
  call ol_merge_tensors(T0sum(233),[G0tensor(861)])
  call ol_merge_tensors(T0sum(234),[G0tensor(886)])
  call ol_merge_tensors(T0sum(235),[G0tensor(911)])
  call ol_merge_tensors(T0sum(236),[G0tensor(936)])
  call ol_merge_tensors(T0sum(237),[G0tensor(961)])
  call ol_merge_tensors(T0sum(238),[G0tensor(509)])
  call ol_merge_tensors(T0sum(239),[G0tensor(405)])
  call ol_merge_tensors(T0sum(240),[G0tensor(67)])
  call ol_merge_tensors(T0sum(241),[G0tensor(234)])
  call ol_merge_tensors(T0sum(242),[G0tensor(25)])
  call ol_merge_tensors(T0sum(243),[G0tensor(260)])
  call ol_merge_tensors(T0sum(244),[G0tensor(710)])
  call ol_merge_tensors(T0sum(245),[G0tensor(430)])
  call ol_merge_tensors(T0sum(246),[G0tensor(470)])
  call ol_merge_tensors(T0sum(247),[G0tensor(262)])
  call ol_merge_tensors(T0sum(248),[G0tensor(87)])
  call ol_merge_tensors(T0sum(249),[G0tensor(553)])
  call ol_merge_tensors(T0sum(250),[G0tensor(368)])
  call ol_merge_tensors(T0sum(251),[G0tensor(568)])
  call ol_merge_tensors(T0sum(252),[G0tensor(425)])
  call ol_merge_tensors(T0sum(253),[G0tensor(505)])
  call ol_merge_tensors(T0sum(254),[G0tensor(775)])
  call ol_merge_tensors(T0sum(255),[G0tensor(95)])
  call ol_merge_tensors(T0sum(256),[G0tensor(98)])
  call ol_merge_tensors(T0sum(257),[G0tensor(248)])
  call ol_merge_tensors(T0sum(258),[G0tensor(813)])
  call ol_merge_tensors(T0sum(259),[G0tensor(103)])
  call ol_merge_tensors(T0sum(260),[G0tensor(373)])
  call ol_merge_tensors(T0sum(261),[G0tensor(635)])
  call ol_merge_tensors(T0sum(262),[G0tensor(645)])
  call ol_merge_tensors(T0sum(263),[G0tensor(112)])
  call ol_merge_tensors(T0sum(264),[G0tensor(299)])
  call ol_merge_tensors(T0sum(265),[G0tensor(240)])
  call ol_merge_tensors(T0sum(266),[G0tensor(128)])
  call ol_merge_tensors(T0sum(267),[G0tensor(565)])
  call ol_merge_tensors(T0sum(268),[G0tensor(807)])
  call ol_merge_tensors(T0sum(269),[G0tensor(812)])
  call ol_merge_tensors(T0sum(270),[G0tensor(209)])
  call ol_merge_tensors(T0sum(271),[G0tensor(340)])
  call ol_merge_tensors(T0sum(272),[G0tensor(399)])
  call ol_merge_tensors(T0sum(273),[G0tensor(203)])
  call ol_merge_tensors(T0sum(274),[G0tensor(213)])
  call ol_merge_tensors(T0sum(275),[G0tensor(910)])
  call ol_merge_tensors(T0sum(276),[G0tensor(165)])
  call ol_merge_tensors(T0sum(277),[G0tensor(148)])
  call ol_merge_tensors(T0sum(278),[G0tensor(825)])
  call ol_merge_tensors(T0sum(279),[G0tensor(303)])
  call ol_merge_tensors(T0sum(280),[G0tensor(577)])
  call ol_merge_tensors(T0sum(281),[G0tensor(5)])
  call ol_merge_tensors(T0sum(282),[G0tensor(280)])
  call ol_merge_tensors(T0sum(283),[G0tensor(935)])
  call ol_merge_tensors(T0sum(284),[G0tensor(159)])
  call ol_merge_tensors(T0sum(285),[G0tensor(162)])
  call ol_merge_tensors(T0sum(286),[G0tensor(507)])
  call ol_merge_tensors(T0sum(287),[G0tensor(223)])
  call ol_merge_tensors(T0sum(288),[G0tensor(678)])
  call ol_merge_tensors(T0sum(289),[G0tensor(312)])
  call ol_merge_tensors(T0sum(290),[G0tensor(842)])
  call ol_merge_tensors(T0sum(291),[G0tensor(417)])
  call ol_merge_tensors(T0sum(292),[G0tensor(322)])
  call ol_merge_tensors(T0sum(293),[G0tensor(278)])
  call ol_merge_tensors(T0sum(294),[G0tensor(34)])
  call ol_merge_tensors(T0sum(295),[G0tensor(517)])
  call ol_merge_tensors(T0sum(296),[G0tensor(305)])
  call ol_merge_tensors(T0sum(297),[G0tensor(189)])
  call ol_merge_tensors(T0sum(298),[G0tensor(192)])
  call ol_merge_tensors(T0sum(299),[G0tensor(482)])
  call ol_merge_tensors(T0sum(300),[G0tensor(217)])
  call ol_merge_tensors(T0sum(301),[G0tensor(273)])
  call ol_merge_tensors(T0sum(302),[G0tensor(198)])
  call ol_merge_tensors(T0sum(303),[G0tensor(447)])
  call ol_merge_tensors(T0sum(304),[G0tensor(349)])
  call ol_merge_tensors(T0sum(305),[G0tensor(314)])
  call ol_merge_tensors(T0sum(306),[G0tensor(317)])
  call ol_merge_tensors(T0sum(307),[G0tensor(647)])
  call ol_merge_tensors(T0sum(308),[G0tensor(334)])
  call ol_merge_tensors(T0sum(309),[G0tensor(818)])
  call ol_merge_tensors(T0sum(310),[G0tensor(358)])
  call ol_merge_tensors(T0sum(311),[G0tensor(644)])
  call ol_merge_tensors(T0sum(312),[G0tensor(434)])
  call ol_merge_tensors(T0sum(313),[G0tensor(749)])
  call ol_merge_tensors(T0sum(314),[G0tensor(560)])
  call ol_merge_tensors(T0sum(315),[G0tensor(479)])
  call ol_merge_tensors(T0sum(316),[G0tensor(628)])
  call ol_merge_tensors(T0sum(317),[G0tensor(484)])
  call ol_merge_tensors(T0sum(318),[G0tensor(438)])
  call ol_merge_tensors(T0sum(319),[G0tensor(443)])
  call ol_merge_tensors(T0sum(320),[G0tensor(468)])
  call ol_merge_tensors(T0sum(321),[G0tensor(465)])
  call ol_merge_tensors(T0sum(322),[G0tensor(488)])
  call ol_merge_tensors(T0sum(323),[G0tensor(485)])
  call ol_merge_tensors(T0sum(324),[G0tensor(538)])
  call ol_merge_tensors(T0sum(325),[G0tensor(524)])
  call ol_merge_tensors(T0sum(326),[G0tensor(544)])
  call ol_merge_tensors(T0sum(327),[G0tensor(584)])
  call ol_merge_tensors(T0sum(328),[G0tensor(634)])
  call ol_merge_tensors(T0sum(329),[G0tensor(669)])
  call ol_merge_tensors(T0sum(330),[G0tensor(692)])
  call ol_merge_tensors(T0sum(331),[G0tensor(733)])
  call ol_merge_tensors(T0sum(332),[G0tensor(704)])
  call ol_merge_tensors(T0sum(333),[G0tensor(709)])
  call ol_merge_tensors(T0sum(334),[G0tensor(732)])
  call ol_merge_tensors(T0sum(335),[G0tensor(730)])
  call ol_merge_tensors(T0sum(336),[G0tensor(739)])
  call ol_merge_tensors(T0sum(337),[G0tensor(779)])
  call ol_merge_tensors(T0sum(338),[G0tensor(769)])
  call ol_merge_tensors(T0sum(339),[G0tensor(600)])
  call ol_merge_tensors(T0sum(340),[G0tensor(798)])
  call ol_merge_tensors(T0sum(341),[G0tensor(583)])
  call ol_merge_tensors(T0sum(342),[G0tensor(819)])
  call ol_merge_tensors(T0sum(343),[G0tensor(849)])
  call ol_merge_tensors(T0sum(344),[G0tensor(902)])
  call ol_merge_tensors(T0sum(345),[G0tensor(919)])
  call ol_merge_tensors(T0sum(346),[G0tensor(918)])
  call ol_merge_tensors(T0sum(347),[G0tensor(933)])
  call ol_merge_tensors(T0sum(348),[G0tensor(949)])
  call ol_merge_tensors(T0sum(349),[G0tensor(204)])
  call ol_merge_tensors(T0sum(350),[G0tensor(48)])
  call ol_merge_tensors(T0sum(351),[G0tensor(219)])
  call ol_merge_tensors(T0sum(352),[G0tensor(230)])
  call ol_merge_tensors(T0sum(353),[G0tensor(253)])
  call ol_merge_tensors(T0sum(354),[G0tensor(323)])
  call ol_merge_tensors(T0sum(355),[G0tensor(415)])
  call ol_merge_tensors(T0sum(356),[G0tensor(508)])
  call ol_merge_tensors(T0sum(357),[G0tensor(573)])
  call ol_merge_tensors(T0sum(358),[G0tensor(185)])
  call ol_merge_tensors(T0sum(359),[G0tensor(639)])
  call ol_merge_tensors(T0sum(360),[G0tensor(889)])
  call ol_merge_tensors(T0sum(361),[G0tensor(908)])
  call ol_merge_tensors(T0sum(362),[G0tensor(980)])
  call ol_merge_tensors(T0sum(363),[G0tensor(985)])
  call ol_merge_tensors(T0sum(364),[G0tensor(989)])
  call ol_merge_tensors(T0sum(365),[G0tensor(68)])
  call ol_merge_tensors(T0sum(366),[G0tensor(955)])
  call ol_merge_tensors(T0sum(367),[G0tensor(994)])
  call ol_merge_tensors(T0sum(368),[G0tensor(917)])
  call ol_merge_tensors(T0sum(369),[G0tensor(947)])
  call ol_merge_tensors(T0sum(370),[G0tensor(998)])
  call ol_merge_tensors(T0sum(371),[G0tensor(957)])
  call ol_merge_tensors(T0sum(372),[G0tensor(153)])
  call ol_merge_tensors(T0sum(373),[G0tensor(12)])
  call ol_merge_tensors(T0sum(374),[G0tensor(15)])
  call ol_merge_tensors(T0sum(375),[G0tensor(850)])
  call ol_merge_tensors(T0sum(376),[G0tensor(903)])
  call ol_merge_tensors(T0sum(377),[G0tensor(675)])
  call ol_merge_tensors(T0sum(378),[G0tensor(4)])
  call ol_merge_tensors(T0sum(379),[G0tensor(735)])
  call ol_merge_tensors(T0sum(380),[G0tensor(22)])
  call ol_merge_tensors(T0sum(381),[G0tensor(47)])
  call ol_merge_tensors(T0sum(382),[G0tensor(24)])
  call ol_merge_tensors(T0sum(383),[G0tensor(535)])
  call ol_merge_tensors(T0sum(384),[G0tensor(525)])
  call ol_merge_tensors(T0sum(385),[G0tensor(130)])
  call ol_merge_tensors(T0sum(386),[G0tensor(37)])
  call ol_merge_tensors(T0sum(387),[G0tensor(787)])
  call ol_merge_tensors(T0sum(388),[G0tensor(595)])
  call ol_merge_tensors(T0sum(389),[G0tensor(70)])
  call ol_merge_tensors(T0sum(390),[G0tensor(387)])
  call ol_merge_tensors(T0sum(391),[G0tensor(397)])
  call ol_merge_tensors(T0sum(392),[G0tensor(382)])
  call ol_merge_tensors(T0sum(393),[G0tensor(432)])
  call ol_merge_tensors(T0sum(394),[G0tensor(462)])
  call ol_merge_tensors(T0sum(395),[G0tensor(472)])
  call ol_merge_tensors(T0sum(396),[G0tensor(452)])
  call ol_merge_tensors(T0sum(397),[G0tensor(457)])
  call ol_merge_tensors(T0sum(398),[G0tensor(612)])
  call ol_merge_tensors(T0sum(399),[G0tensor(398)])
  call ol_merge_tensors(T0sum(400),[G0tensor(448)])
  call ol_merge_tensors(T0sum(401),[G0tensor(473)])
  call ol_merge_tensors(T0sum(402),[G0tensor(548)])
  call ol_merge_tensors(T0sum(403),[G0tensor(608)])
  call ol_merge_tensors(T0sum(404),[G0tensor(623)])
  call ol_merge_tensors(T0sum(405),[G0tensor(648)])
  call ol_merge_tensors(T0sum(406),[G0tensor(663)])
  call ol_merge_tensors(T0sum(407),[G0tensor(867)])
  call ol_merge_tensors(T0sum(408),[G0tensor(868)])
  call ol_merge_tensors(T0sum(409),[G0tensor(870)])
  call ol_merge_tensors(T0sum(410),[G0tensor(872)])
  call ol_merge_tensors(T0sum(411),[G0tensor(873)])
  call ol_merge_tensors(T0sum(412),[G0tensor(875)])
  call ol_merge_tensors(T0sum(413),[G0tensor(877)])
  call ol_merge_tensors(T0sum(414),[G0tensor(879)])
  call ol_merge_tensors(T0sum(415),[G0tensor(885)])
  call ol_merge_tensors(T0sum(416),[G0tensor(882)])
  call ol_merge_tensors(T0sum(417),[G0tensor(884)])
  call ol_merge_tensors(T0sum(418),[G0tensor(888)])
  call ol_merge_tensors(T0sum(419),[G0tensor(894)])
  call ol_merge_tensors(T0sum(420),[G0tensor(890)])
  call ol_merge_tensors(T0sum(421),[G0tensor(893)])
  call ol_merge_tensors(T0sum(422),[G0tensor(895)])
  call ol_merge_tensors(T0sum(423),[G0tensor(610)])
  call ol_merge_tensors(T0sum(424),[G0tensor(57)])
  call ol_merge_tensors(T0sum(425),[G0tensor(59)])
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[60,3],[nMW,nMW],3,3,wf4(:,2),wf4(:,5),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,2),wf4(:,5),G0H4(8),m4h4x4x4(:,5),heltab3x64(:,:,5))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[60,3],[nMW,nMW],3,3,wf4(:,2),wf4(:,3),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,2),wf4(:,3),G0H4(2),m4h4x4x4(:,6),heltab3x64(:,:,6))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[60,3],[nMW,nMW],3,3,wf4(:,2),wf4(:,5),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,2),wf4(:,5),G0H4(1),m4h4x4x4(:,7),heltab3x64(:,:,7))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[60,3],[nMW,nMW],3,3,wf4(:,2),wf4(:,3),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,2),wf4(:,3),G0H4(4),m4h4x4x4(:,8),heltab3x64(:,:,8))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[51,12],[nMW,nMW],3,3,wf4(:,1),wf4(:,5),wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,1),wf4(:,5),G0H4(7),m4h4x4x4(:,9),heltab3x64(:,:,9))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[51,12],[nMW,nMW],3,3,wf4(:,1),wf4(:,3),wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,1),wf4(:,3),G0H4(3),m4h4x4x4(:,10),heltab3x64(:,:,10))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[51,12],[nMW,nMW],3,3,wf4(:,1),wf4(:,5),wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,1),wf4(:,5),G0H4(5),m4h4x4x4(:,11),heltab3x64(:,:,11))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[51,12],[nMW,nMW],3,3,wf4(:,1),wf4(:,3),wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,1),wf4(:,3),G0H4(9),m4h4x4x4(:,12),heltab3x64(:,:,12))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[48,15],[nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(3),m3h4x16(:,139),heltab2x64(:,:,298))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[48,15],[nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(4),m3h4x16(:,140),heltab2x64(:,:,299))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[48,15],[nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(8),m3h4x16(:,141),heltab2x64(:,:,300))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[48,15],[nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(11),m3h4x16(:,142),heltab2x64(:,:,301))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[48,15],[nML,nML],2,2,wf4(:,5),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,143),heltab2x64(:,:,302))
  call Hloop_Q_A(ntryL,G0H16(17),48,nML,G1H16(12),n2h16(96))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[48,15],[nMT,nMT],2,2,wf4(:,5),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,144),heltab2x64(:,:,303))
  call Hloop_Q_A(ntryL,G0H16(7),48,nMT,G1H16(5),n2h16(97))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[48,15],[nMB,nMB],2,2,wf4(:,5),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,145),heltab2x64(:,:,304))
  call Hloop_Q_A(ntryL,G0H16(10),48,nMB,G1H16(10),n2h16(98))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(8),ngZl,m3h4x16(:,146),heltab2x64(:,:,305))
  call Hloop_Q_A(ntryL,G0H16(8),48,nML,G1H16(14),n2h16(99))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(12),ngZu,m3h4x16(:,147),heltab2x64(:,:,306))
  call Hloop_Q_A(ntryL,G0H16(12),48,nMT,G1H16(17),n2h16(100))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(6),ngZd,m3h4x16(:,148),heltab2x64(:,:,307))
  call Hloop_Q_A(ntryL,G0H16(6),48,nMB,G1H16(16),n2h16(101))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(19),m3h4x16(:,149),heltab2x64(:,:,308))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(22),m3h4x16(:,150),heltab2x64(:,:,309))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(25),m3h4x16(:,151),heltab2x64(:,:,310))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(27),m3h4x16(:,152),heltab2x64(:,:,311))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(35),m3h4x16(:,153),heltab2x64(:,:,312))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(33),m3h4x16(:,154),heltab2x64(:,:,313))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(31),m3h4x16(:,155),heltab2x64(:,:,314))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(36),m3h4x16(:,156),heltab2x64(:,:,315))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(5),m3h4x16(:,157),heltab2x64(:,:,316))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,158),heltab2x64(:,:,317))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(14),m3h4x16(:,159),heltab2x64(:,:,318))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(3),m3h4x16(:,160),heltab2x64(:,:,319))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[51,12],[nML,nML],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,2),G0H4(6),ngH,m3h16x4(:,37),heltab2x64(:,:,320))
  call Hloop_Q_A(ntryL,G0H4(6),51,nML,G1H4(16),n2h4(100))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[51,12],[nMT,nMT],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,2),G0H4(6),ngH,m3h16x4(:,38),heltab2x64(:,:,321))
  call Hloop_Q_A(ntryL,G0H4(6),51,nMT,G1H4(27),n2h4(101))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[51,12],[nMB,nMB],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,2),G0H4(6),ngH,m3h16x4(:,39),heltab2x64(:,:,322))
  call Hloop_Q_A(ntryL,G0H4(6),51,nMB,G1H4(52),n2h4(102))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[51,12],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,2),G0H4(6),m3h16x4(:,40),heltab2x64(:,:,323))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[51,12],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,2),G0H4(10),m3h16x4(:,41),heltab2x64(:,:,324))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[51,12],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,2),G0H4(11),m3h16x4(:,42),heltab2x64(:,:,325))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[51,12],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,2),G0H4(12),m3h16x4(:,43),heltab2x64(:,:,326))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[51,12],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,2),51,G1H4(58),m3h16x4(:,44),heltab2x64(:,:,327))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[51,12],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,2),51,G1H4(20),m3h16x4(:,45),heltab2x64(:,:,328))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[60,3],[nML,nML],2,2,wf16(:,9),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,9),G0H4(13),ngH,m3h16x4(:,46),heltab2x64(:,:,329))
  call Hloop_Q_A(ntryL,G0H4(13),60,nML,G1H4(3),n2h4(103))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[60,3],[nMT,nMT],2,2,wf16(:,9),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,9),G0H4(13),ngH,m3h16x4(:,47),heltab2x64(:,:,330))
  call Hloop_Q_A(ntryL,G0H4(13),60,nMT,G1H4(28),n2h4(104))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[60,3],[nMB,nMB],2,2,wf16(:,9),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,9),G0H4(13),ngH,m3h16x4(:,48),heltab2x64(:,:,331))
  call Hloop_Q_A(ntryL,G0H4(13),60,nMB,G1H4(38),n2h4(105))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[60,3],[nMW,nMW],2,2,wf16(:,9),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,9),G0H4(13),m3h16x4(:,49),heltab2x64(:,:,332))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[60,3],[nMW,nMW],2,2,wf16(:,9),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,9),G0H4(14),m3h16x4(:,50),heltab2x64(:,:,333))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[60,3],[nMW,nMW],2,2,wf16(:,9),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,9),G0H4(15),m3h16x4(:,51),heltab2x64(:,:,334))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[60,3],[nMW,nMW],2,2,wf16(:,9),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,9),G0H4(16),m3h16x4(:,52),heltab2x64(:,:,335))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[60,3],[nMW,nMW],2,2,wf16(:,9),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,9),60,G1H4(36),m3h16x4(:,53),heltab2x64(:,:,336))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[60,3],[nMW,nMW],2,2,wf16(:,9),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,9),60,G1H4(10),m3h16x4(:,54),heltab2x64(:,:,337))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[44,19],[0,0],2,2,wf8(:,24),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,24),G0H8(6),m3h8x8(:,39),heltab2x64(:,:,338))
  call Hloop_A_Q(ntryL,G0H8(6),44,0,G1H8(10),n2h8(56))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[44,19],[0,nMZ],2,2,wf8(:,24),wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,24),G0H8(7),ngZd,m3h8x8(:,40),heltab2x64(:,:,339))
  call Hloop_A_Q(ntryL,G0H8(7),44,0,G1H8(12),n2h8(57))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[44,19],[0,nMW],2,2,wf8(:,24),wf8(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,24),G0H8(9),m3h8x8(:,41),heltab2x64(:,:,340))
  call Hloop_A_Q(ntryL,G0H8(9),44,0,G1H8(14),n2h8(58))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[51,12],[0,0],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(17),m3h16x4(:,55),heltab2x64(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(17),51,0,G1H4(55),n2h4(106))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[51,12],[nML,nML],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(17),m3h16x4(:,56),heltab2x64(:,:,342))
  call Hloop_Q_A(ntryL,G0H4(17),51,nML,G1H4(44),n2h4(107))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[51,12],[0,0],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(17),m3h16x4(:,57),heltab2x64(:,:,343))
  call Hloop_Q_A(ntryL,G0H4(17),51,0,G1H4(11),n2h4(108))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[51,12],[nMT,nMT],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(17),m3h16x4(:,58),heltab2x64(:,:,344))
  call Hloop_Q_A(ntryL,G0H4(17),51,nMT,G1H4(7),n2h4(109))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[51,12],[0,0],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(17),m3h16x4(:,59),heltab2x64(:,:,345))
  call Hloop_Q_A(ntryL,G0H4(17),51,0,G1H4(14),n2h4(110))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[51,12],[nMB,nMB],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(17),m3h16x4(:,60),heltab2x64(:,:,346))
  call Hloop_Q_A(ntryL,G0H4(17),51,nMB,G1H4(19),n2h4(111))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(17),ngZn,m3h16x4(:,61),heltab2x64(:,:,347))
  call Hloop_Q_A(ntryL,G0H4(17),51,0,G1H4(43),n2h4(112))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(17),ngZl,m3h16x4(:,62),heltab2x64(:,:,348))
  call Hloop_Q_A(ntryL,G0H4(17),51,0,G1H4(41),n2h4(113))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[51,12],[nML,nML],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(17),ngZl,m3h16x4(:,63),heltab2x64(:,:,349))
  call Hloop_Q_A(ntryL,G0H4(17),51,nML,G1H4(51),n2h4(114))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(17),ngZu,m3h16x4(:,64),heltab2x64(:,:,350))
  call Hloop_Q_A(ntryL,G0H4(17),51,0,G1H4(50),n2h4(115))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[51,12],[nMT,nMT],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(17),ngZu,m3h16x4(:,65),heltab2x64(:,:,351))
  call Hloop_Q_A(ntryL,G0H4(17),51,nMT,G1H4(57),n2h4(116))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(17),ngZd,m3h16x4(:,66),heltab2x64(:,:,352))
  call Hloop_Q_A(ntryL,G0H4(17),51,0,G1H4(56),n2h4(117))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[51,12],[nMB,nMB],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(17),ngZd,m3h16x4(:,67),heltab2x64(:,:,353))
  call Hloop_Q_A(ntryL,G0H4(17),51,nMB,G1H4(33),n2h4(118))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[51,12],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,5),51,G1H4(18),m3h16x4(:,68),heltab2x64(:,:,354))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[51,12],[nMH,nMZ],2,2,wf16(:,6),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(26),m3h16x4(:,69),heltab2x64(:,:,355))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[51,12],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(29),m3h16x4(:,70),heltab2x64(:,:,356))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[51,12],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,5),51,G1H4(21),m3h16x4(:,71),heltab2x64(:,:,357))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[51,12],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,5),51,G1H4(53),m3h16x4(:,72),heltab2x64(:,:,358))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[51,12],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(22),m3h16x4(:,73),heltab2x64(:,:,359))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[51,12],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(9),m3h16x4(:,74),heltab2x64(:,:,360))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[51,12],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,5),51,G1H4(15),m3h16x4(:,75),heltab2x64(:,:,361))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[51,12],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(5),m3h16x4(:,76),heltab2x64(:,:,362))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[51,12],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,5),G0H4(17),m3h16x4(:,77),heltab2x64(:,:,363))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[51,12],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,5),G0H4(18),m3h16x4(:,78),heltab2x64(:,:,364))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[51,12],[nMH,nMZ],2,2,wf16(:,6),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,6),G0H4(19),m3h16x4(:,79),heltab2x64(:,:,365))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[51,12],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,6),G0H4(20),m3h16x4(:,80),heltab2x64(:,:,366))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[51,12],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,6),G0H4(21),m3h16x4(:,81),heltab2x64(:,:,367))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[35,28],[0,0],2,2,wf8(:,22),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,22),G0H8(10),m3h8x8(:,42),heltab2x64(:,:,368))
  call Hloop_A_Q(ntryL,G0H8(10),35,0,G1H8(15),n2h8(59))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[35,28],[0,nMZ],2,2,wf8(:,22),wf8(:,6))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,22),G0H8(12),ngZd,m3h8x8(:,43),heltab2x64(:,:,369))
  call Hloop_A_Q(ntryL,G0H8(12),35,0,G1H8(11),n2h8(60))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[35,28],[0,nMW],2,2,wf8(:,22),wf8(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,22),G0H8(13),m3h8x8(:,44),heltab2x64(:,:,370))
  call Hloop_A_Q(ntryL,G0H8(13),35,0,G1H8(46),n2h8(61))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[51,12],[0,0],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(22),m3h16x4(:,82),heltab2x64(:,:,371))
  call Hloop_Q_A(ntryL,G0H4(22),51,0,G1H4(24),n2h4(119))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[51,12],[nML,nML],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(22),m3h16x4(:,83),heltab2x64(:,:,372))
  call Hloop_Q_A(ntryL,G0H4(22),51,nML,G1H4(23),n2h4(120))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[51,12],[0,0],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(22),m3h16x4(:,84),heltab2x64(:,:,373))
  call Hloop_Q_A(ntryL,G0H4(22),51,0,G1H4(25),n2h4(121))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[51,12],[nMT,nMT],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(22),m3h16x4(:,85),heltab2x64(:,:,374))
  call Hloop_Q_A(ntryL,G0H4(22),51,nMT,G1H4(45),n2h4(122))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[51,12],[0,0],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(22),m3h16x4(:,86),heltab2x64(:,:,375))
  call Hloop_Q_A(ntryL,G0H4(22),51,0,G1H4(46),n2h4(123))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[51,12],[nMB,nMB],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(22),m3h16x4(:,87),heltab2x64(:,:,376))
  call Hloop_Q_A(ntryL,G0H4(22),51,nMB,G1H4(48),n2h4(124))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[51,12],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(22),ngZn,m3h16x4(:,88),heltab2x64(:,:,377))
  call Hloop_Q_A(ntryL,G0H4(22),51,0,G1H4(49),n2h4(125))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[51,12],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(22),ngZl,m3h16x4(:,89),heltab2x64(:,:,378))
  call Hloop_Q_A(ntryL,G0H4(22),51,0,G1H4(2),n2h4(126))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[51,12],[nML,nML],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(22),ngZl,m3h16x4(:,90),heltab2x64(:,:,379))
  call Hloop_Q_A(ntryL,G0H4(22),51,nML,G1H4(35),n2h4(127))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[51,12],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(22),ngZu,m3h16x4(:,91),heltab2x64(:,:,380))
  call Hloop_Q_A(ntryL,G0H4(22),51,0,G1H4(31),n2h4(128))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[51,12],[nMT,nMT],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(22),ngZu,m3h16x4(:,92),heltab2x64(:,:,381))
  call Hloop_Q_A(ntryL,G0H4(22),51,nMT,G1H4(47),n2h4(129))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[51,12],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(22),ngZd,m3h16x4(:,93),heltab2x64(:,:,382))
  call Hloop_Q_A(ntryL,G0H4(22),51,0,G1H4(37),n2h4(130))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[51,12],[nMB,nMB],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(22),ngZd,m3h16x4(:,94),heltab2x64(:,:,383))
  call Hloop_Q_A(ntryL,G0H4(22),51,nMB,G1H4(12),n2h4(131))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[51,12],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,7),51,G1H4(30),m3h16x4(:,95),heltab2x64(:,:,384))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[51,12],[nMH,nMZ],2,2,wf16(:,8),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,8),51,G1H4(1),m3h16x4(:,96),heltab2x64(:,:,385))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[51,12],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,8),51,G1H4(32),m3h16x4(:,97),heltab2x64(:,:,386))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[51,12],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,7),51,G1H4(34),m3h16x4(:,98),heltab2x64(:,:,387))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[51,12],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,7),51,G1H4(39),m3h16x4(:,99),heltab2x64(:,:,388))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[51,12],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,8),51,G1H4(40),m3h16x4(:,100),heltab2x64(:,:,389))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[51,12],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,8),51,G1H4(4),m3h16x4(:,101),heltab2x64(:,:,390))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[51,12],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,7),51,G1H4(17),m3h16x4(:,102),heltab2x64(:,:,391))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[51,12],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,8),51,G1H4(13),m3h16x4(:,103),heltab2x64(:,:,392))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[51,12],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,7),G0H4(22),m3h16x4(:,104),heltab2x64(:,:,393))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[51,12],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,7),G0H4(23),m3h16x4(:,105),heltab2x64(:,:,394))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[51,12],[nMH,nMZ],2,2,wf16(:,8),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,8),G0H4(24),m3h16x4(:,106),heltab2x64(:,:,395))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[51,12],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,8),G0H4(25),m3h16x4(:,107),heltab2x64(:,:,396))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[51,12],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,8),G0H4(26),m3h16x4(:,108),heltab2x64(:,:,397))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[60,3],[0,0],2,2,wf16(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,12),G0H4(27),m3h16x4(:,109),heltab2x64(:,:,398))
  call Hloop_Q_A(ntryL,G0H4(27),60,0,G1H4(8),n2h4(132))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[60,3],[nML,nML],2,2,wf16(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,12),G0H4(27),m3h16x4(:,110),heltab2x64(:,:,399))
  call Hloop_Q_A(ntryL,G0H4(27),60,nML,G1H4(6),n2h4(133))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[60,3],[0,0],2,2,wf16(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,12),G0H4(27),m3h16x4(:,111),heltab2x64(:,:,400))
  call Hloop_Q_A(ntryL,G0H4(27),60,0,G1H4(42),n2h4(134))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[60,3],[nMT,nMT],2,2,wf16(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,12),G0H4(27),m3h16x4(:,112),heltab2x64(:,:,401))
  call Hloop_Q_A(ntryL,G0H4(27),60,nMT,G1H4(54),n2h4(135))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[60,3],[0,0],2,2,wf16(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,12),G0H4(27),m3h16x4(:,113),heltab2x64(:,:,402))
  call Hloop_Q_A(ntryL,G0H4(27),60,0,G1H4(59),n2h4(136))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[60,3],[nMB,nMB],2,2,wf16(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,12),G0H4(27),m3h16x4(:,114),heltab2x64(:,:,403))
  call Hloop_Q_A(ntryL,G0H4(27),60,nMB,G1H4(60),n2h4(137))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[60,3],[0,0],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,13),G0H4(27),ngZn,m3h16x4(:,115),heltab2x64(:,:,404))
  call Hloop_Q_A(ntryL,G0H4(27),60,0,G1H4(61),n2h4(138))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[60,3],[0,0],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,13),G0H4(27),ngZl,m3h16x4(:,116),heltab2x64(:,:,405))
  call Hloop_Q_A(ntryL,G0H4(27),60,0,G1H4(62),n2h4(139))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[60,3],[nML,nML],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,13),G0H4(27),ngZl,m3h16x4(:,117),heltab2x64(:,:,406))
  call Hloop_Q_A(ntryL,G0H4(27),60,nML,G1H4(63),n2h4(140))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[60,3],[0,0],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,13),G0H4(27),ngZu,m3h16x4(:,118),heltab2x64(:,:,407))
  call Hloop_Q_A(ntryL,G0H4(27),60,0,G1H4(64),n2h4(141))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[60,3],[nMT,nMT],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,13),G0H4(27),ngZu,m3h16x4(:,119),heltab2x64(:,:,408))
  call Hloop_Q_A(ntryL,G0H4(27),60,nMT,G1H4(65),n2h4(142))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[60,3],[0,0],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,13),G0H4(27),ngZd,m3h16x4(:,120),heltab2x64(:,:,409))
  call Hloop_Q_A(ntryL,G0H4(27),60,0,G1H4(66),n2h4(143))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[60,3],[nMB,nMB],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,13),G0H4(27),ngZd,m3h16x4(:,121),heltab2x64(:,:,410))
  call Hloop_Q_A(ntryL,G0H4(27),60,nMB,G1H4(67),n2h4(144))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[60,3],[nMW,nMW],2,2,wf16(:,12),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,12),60,G1H4(68),m3h16x4(:,122),heltab2x64(:,:,411))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[60,3],[nMH,nMZ],2,2,wf16(:,13),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,13),60,G1H4(69),m3h16x4(:,123),heltab2x64(:,:,412))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[60,3],[nMW,nMW],2,2,wf16(:,13),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,13),60,G1H4(70),m3h16x4(:,124),heltab2x64(:,:,413))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[60,3],[nMW,nMW],2,2,wf16(:,12),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,12),60,G1H4(71),m3h16x4(:,125),heltab2x64(:,:,414))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[60,3],[nMW,nMW],2,2,wf16(:,12),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,12),60,G1H4(72),m3h16x4(:,126),heltab2x64(:,:,415))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[60,3],[nMW,nMW],2,2,wf16(:,13),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,13),60,G1H4(73),m3h16x4(:,127),heltab2x64(:,:,416))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[60,3],[nMW,nMW],2,2,wf16(:,13),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,13),60,G1H4(74),m3h16x4(:,128),heltab2x64(:,:,417))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[60,3],[nMW,nMW],2,2,wf16(:,12),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,12),60,G1H4(75),m3h16x4(:,129),heltab2x64(:,:,418))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[60,3],[nMW,nMW],2,2,wf16(:,13),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,13),60,G1H4(76),m3h16x4(:,130),heltab2x64(:,:,419))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[60,3],[nMW,nMW],2,2,wf16(:,12),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,12),G0H4(27),m3h16x4(:,131),heltab2x64(:,:,420))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(433),h0tab(:,433),[60,3],[nMW,nMW],2,2,wf16(:,12),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,12),G0H4(28),m3h16x4(:,132),heltab2x64(:,:,421))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(434),h0tab(:,434),[60,3],[nMH,nMZ],2,2,wf16(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,13),G0H4(29),m3h16x4(:,133),heltab2x64(:,:,422))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(435),h0tab(:,435),[60,3],[nMW,nMW],2,2,wf16(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,13),G0H4(30),m3h16x4(:,134),heltab2x64(:,:,423))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(436),h0tab(:,436),[60,3],[nMW,nMW],2,2,wf16(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,13),G0H4(31),m3h16x4(:,135),heltab2x64(:,:,424))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(437),h0tab(:,437),[60,3],[0,0],2,2,wf16(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,14),G0H4(32),m3h16x4(:,136),heltab2x64(:,:,425))
  call Hloop_Q_A(ntryL,G0H4(32),60,0,G1H4(77),n2h4(145))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(438),h0tab(:,438),[60,3],[nML,nML],2,2,wf16(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,14),G0H4(32),m3h16x4(:,137),heltab2x64(:,:,426))
  call Hloop_Q_A(ntryL,G0H4(32),60,nML,G1H4(78),n2h4(146))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(439),h0tab(:,439),[60,3],[0,0],2,2,wf16(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,14),G0H4(32),m3h16x4(:,138),heltab2x64(:,:,427))
  call Hloop_Q_A(ntryL,G0H4(32),60,0,G1H4(79),n2h4(147))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(440),h0tab(:,440),[60,3],[nMT,nMT],2,2,wf16(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,14),G0H4(32),m3h16x4(:,139),heltab2x64(:,:,428))
  call Hloop_Q_A(ntryL,G0H4(32),60,nMT,G1H4(80),n2h4(148))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(441),h0tab(:,441),[60,3],[0,0],2,2,wf16(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,14),G0H4(32),m3h16x4(:,140),heltab2x64(:,:,429))
  call Hloop_Q_A(ntryL,G0H4(32),60,0,G1H4(81),n2h4(149))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(442),h0tab(:,442),[60,3],[nMB,nMB],2,2,wf16(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,14),G0H4(32),m3h16x4(:,141),heltab2x64(:,:,430))
  call Hloop_Q_A(ntryL,G0H4(32),60,nMB,G1H4(82),n2h4(150))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(443),h0tab(:,443),[60,3],[0,0],2,2,wf16(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,15),G0H4(32),ngZn,m3h16x4(:,142),heltab2x64(:,:,431))
  call Hloop_Q_A(ntryL,G0H4(32),60,0,G1H4(83),n2h4(151))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(444),h0tab(:,444),[60,3],[0,0],2,2,wf16(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,15),G0H4(32),ngZl,m3h16x4(:,143),heltab2x64(:,:,432))
  call Hloop_Q_A(ntryL,G0H4(32),60,0,G1H4(84),n2h4(152))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(445),h0tab(:,445),[60,3],[nML,nML],2,2,wf16(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,15),G0H4(32),ngZl,m3h16x4(:,144),heltab2x64(:,:,433))
  call Hloop_Q_A(ntryL,G0H4(32),60,nML,G1H4(85),n2h4(153))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(446),h0tab(:,446),[60,3],[0,0],2,2,wf16(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,15),G0H4(32),ngZu,m3h16x4(:,145),heltab2x64(:,:,434))
  call Hloop_Q_A(ntryL,G0H4(32),60,0,G1H4(86),n2h4(154))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(447),h0tab(:,447),[60,3],[nMT,nMT],2,2,wf16(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,15),G0H4(32),ngZu,m3h16x4(:,146),heltab2x64(:,:,435))
  call Hloop_Q_A(ntryL,G0H4(32),60,nMT,G1H4(87),n2h4(155))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(448),h0tab(:,448),[60,3],[0,0],2,2,wf16(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,15),G0H4(32),ngZd,m3h16x4(:,147),heltab2x64(:,:,436))
  call Hloop_Q_A(ntryL,G0H4(32),60,0,G1H4(88),n2h4(156))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(449),h0tab(:,449),[60,3],[nMB,nMB],2,2,wf16(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,15),G0H4(32),ngZd,m3h16x4(:,148),heltab2x64(:,:,437))
  call Hloop_Q_A(ntryL,G0H4(32),60,nMB,G1H4(89),n2h4(157))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(450),h0tab(:,450),[60,3],[nMW,nMW],2,2,wf16(:,14),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,14),60,G1H4(90),m3h16x4(:,149),heltab2x64(:,:,438))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(451),h0tab(:,451),[60,3],[nMH,nMZ],2,2,wf16(:,15),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,15),60,G1H4(91),m3h16x4(:,150),heltab2x64(:,:,439))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(452),h0tab(:,452),[60,3],[nMW,nMW],2,2,wf16(:,15),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,15),60,G1H4(92),m3h16x4(:,151),heltab2x64(:,:,440))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(453),h0tab(:,453),[60,3],[nMW,nMW],2,2,wf16(:,14),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,14),60,G1H4(93),m3h16x4(:,152),heltab2x64(:,:,441))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(454),h0tab(:,454),[60,3],[nMW,nMW],2,2,wf16(:,14),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,14),60,G1H4(94),m3h16x4(:,153),heltab2x64(:,:,442))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(455),h0tab(:,455),[60,3],[nMW,nMW],2,2,wf16(:,15),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,15),60,G1H4(95),m3h16x4(:,154),heltab2x64(:,:,443))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(456),h0tab(:,456),[60,3],[nMW,nMW],2,2,wf16(:,15),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,15),60,G1H4(96),m3h16x4(:,155),heltab2x64(:,:,444))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(457),h0tab(:,457),[60,3],[nMW,nMW],2,2,wf16(:,14),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,14),60,G1H4(97),m3h16x4(:,156),heltab2x64(:,:,445))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(458),h0tab(:,458),[60,3],[nMW,nMW],2,2,wf16(:,15),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,15),60,G1H4(98),m3h16x4(:,157),heltab2x64(:,:,446))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(459),h0tab(:,459),[60,3],[nMW,nMW],2,2,wf16(:,14),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,14),G0H4(32),m3h16x4(:,158),heltab2x64(:,:,447))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(460),h0tab(:,460),[60,3],[nMW,nMW],2,2,wf16(:,14),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,14),G0H4(33),m3h16x4(:,159),heltab2x64(:,:,448))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(461),h0tab(:,461),[60,3],[nMH,nMZ],2,2,wf16(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,15),G0H4(34),m3h16x4(:,160),heltab2x64(:,:,449))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(462),h0tab(:,462),[60,3],[nMW,nMW],2,2,wf16(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,15),G0H4(35),m3h16x4(:,161),heltab2x64(:,:,450))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(463),h0tab(:,463),[60,3],[nMW,nMW],2,2,wf16(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,15),G0H4(36),m3h16x4(:,162),heltab2x64(:,:,451))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(464),h0tab(:,464),[48,15],[0,0],2,2,wf4(:,5),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(9),m3h4x16(:,161),heltab2x64(:,:,452))
  call Hloop_Q_A(ntryL,G0H16(9),48,0,G1H16(34),n2h16(102))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(465),h0tab(:,465),[48,15],[nML,nML],2,2,wf4(:,5),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,162),heltab2x64(:,:,453))
  call Hloop_Q_A(ntryL,G0H16(11),48,nML,G1H16(32),n2h16(103))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(466),h0tab(:,466),[48,15],[0,0],2,2,wf4(:,5),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(2),m3h4x16(:,163),heltab2x64(:,:,454))
  call Hloop_Q_A(ntryL,G0H16(2),48,0,G1H16(39),n2h16(104))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(467),h0tab(:,467),[48,15],[nMT,nMT],2,2,wf4(:,5),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(13),m3h4x16(:,164),heltab2x64(:,:,455))
  call Hloop_Q_A(ntryL,G0H16(13),48,nMT,G1H16(40),n2h16(105))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(468),h0tab(:,468),[48,15],[0,0],2,2,wf4(:,5),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,165),heltab2x64(:,:,456))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(45),n2h16(106))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(469),h0tab(:,469),[48,15],[nMB,nMB],2,2,wf4(:,5),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(15),m3h4x16(:,166),heltab2x64(:,:,457))
  call Hloop_Q_A(ntryL,G0H16(15),48,nMB,G1H16(44),n2h16(107))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(470),h0tab(:,470),[48,15],[0,0],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(16),ngZn,m3h4x16(:,167),heltab2x64(:,:,458))
  call Hloop_Q_A(ntryL,G0H16(16),48,0,G1H16(43),n2h16(108))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(471),h0tab(:,471),[48,15],[0,0],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZl,m3h4x16(:,168),heltab2x64(:,:,459))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(49),n2h16(109))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(472),h0tab(:,472),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZl,m3h4x16(:,169),heltab2x64(:,:,460))
  call Hloop_Q_A(ntryL,G0H16(7),48,nML,G1H16(48),n2h16(110))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(473),h0tab(:,473),[48,15],[0,0],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(10),ngZu,m3h4x16(:,170),heltab2x64(:,:,461))
  call Hloop_Q_A(ntryL,G0H16(10),48,0,G1H16(47),n2h16(111))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(474),h0tab(:,474),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(8),ngZu,m3h4x16(:,171),heltab2x64(:,:,462))
  call Hloop_Q_A(ntryL,G0H16(8),48,nMT,G1H16(51),n2h16(112))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(475),h0tab(:,475),[48,15],[0,0],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(12),ngZd,m3h4x16(:,172),heltab2x64(:,:,463))
  call Hloop_Q_A(ntryL,G0H16(12),48,0,G1H16(54),n2h16(113))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(476),h0tab(:,476),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(6),ngZd,m3h4x16(:,173),heltab2x64(:,:,464))
  call Hloop_Q_A(ntryL,G0H16(6),48,nMB,G1H16(56),n2h16(114))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(477),h0tab(:,477),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(59),m3h4x16(:,174),heltab2x64(:,:,465))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(478),h0tab(:,478),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,3))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(61),m3h4x16(:,175),heltab2x64(:,:,466))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(479),h0tab(:,479),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(64),m3h4x16(:,176),heltab2x64(:,:,467))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(480),h0tab(:,480),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(66),m3h4x16(:,177),heltab2x64(:,:,468))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(481),h0tab(:,481),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(69),m3h4x16(:,178),heltab2x64(:,:,469))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(482),h0tab(:,482),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(26),m3h4x16(:,179),heltab2x64(:,:,470))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(483),h0tab(:,483),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(28),m3h4x16(:,180),heltab2x64(:,:,471))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(484),h0tab(:,484),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(1),m3h4x16(:,181),heltab2x64(:,:,472))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(485),h0tab(:,485),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(6),m3h4x16(:,182),heltab2x64(:,:,473))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(486),h0tab(:,486),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(9),m3h4x16(:,183),heltab2x64(:,:,474))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(487),h0tab(:,487),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,184),heltab2x64(:,:,475))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(488),h0tab(:,488),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(2),m3h4x16(:,185),heltab2x64(:,:,476))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(489),h0tab(:,489),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(13),m3h4x16(:,186),heltab2x64(:,:,477))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(490),h0tab(:,490),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,187),heltab2x64(:,:,478))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(491),h0tab(:,491),[56,7],[0,nMZ],2,2,wf8(:,35),wf8(:,9))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,35),G0H8(2),ngZn,m3h8x8(:,45),heltab2x64(:,:,479))
  call Hloop_A_Q(ntryL,G0H8(2),56,0,G1H8(47),n2h8(62))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(492),h0tab(:,492),[56,7],[0,nMW],2,2,wf8(:,35),wf8(:,9))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,35),G0H8(5),m3h8x8(:,46),heltab2x64(:,:,480))
  call Hloop_A_Q(ntryL,G0H8(5),56,0,G1H8(16),n2h8(63))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(493),h0tab(:,493),[48,15],[0,0],2,2,wf4(:,5),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(15),m3h4x16(:,188),heltab2x64(:,:,481))
  call Hloop_Q_A(ntryL,G0H16(15),48,0,G1H16(9),n2h16(115))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(494),h0tab(:,494),[48,15],[nML,nML],2,2,wf4(:,5),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(16),m3h4x16(:,189),heltab2x64(:,:,482))
  call Hloop_Q_A(ntryL,G0H16(16),48,nML,G1H16(2),n2h16(116))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(495),h0tab(:,495),[48,15],[0,0],2,2,wf4(:,5),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,190),heltab2x64(:,:,483))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(7),n2h16(117))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(496),h0tab(:,496),[48,15],[nMT,nMT],2,2,wf4(:,5),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,191),heltab2x64(:,:,484))
  call Hloop_Q_A(ntryL,G0H16(7),48,nMT,G1H16(13),n2h16(118))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(497),h0tab(:,497),[48,15],[0,0],2,2,wf4(:,5),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,192),heltab2x64(:,:,485))
  call Hloop_Q_A(ntryL,G0H16(10),48,0,G1H16(15),n2h16(119))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(498),h0tab(:,498),[48,15],[nMB,nMB],2,2,wf4(:,5),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(8),m3h4x16(:,193),heltab2x64(:,:,486))
  call Hloop_Q_A(ntryL,G0H16(8),48,nMB,G1H16(18),n2h16(120))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(499),h0tab(:,499),[48,15],[0,0],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(12),ngZn,m3h4x16(:,194),heltab2x64(:,:,487))
  call Hloop_Q_A(ntryL,G0H16(12),48,0,G1H16(20),n2h16(121))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(500),h0tab(:,500),[48,15],[0,0],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(6),ngZl,m3h4x16(:,195),heltab2x64(:,:,488))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(23),n2h16(122))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(501),h0tab(:,501),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(15),ngZl,m3h4x16(:,196),heltab2x64(:,:,489))
  call Hloop_Q_A(ntryL,G0H16(15),48,nML,G1H16(21),n2h16(123))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(502),h0tab(:,502),[48,15],[0,0],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(16),ngZu,m3h4x16(:,197),heltab2x64(:,:,490))
  call Hloop_Q_A(ntryL,G0H16(16),48,0,G1H16(24),n2h16(124))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(503),h0tab(:,503),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZu,m3h4x16(:,198),heltab2x64(:,:,491))
  call Hloop_Q_A(ntryL,G0H16(17),48,nMT,G1H16(29),n2h16(125))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(504),h0tab(:,504),[48,15],[0,0],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZd,m3h4x16(:,199),heltab2x64(:,:,492))
  call Hloop_Q_A(ntryL,G0H16(7),48,0,G1H16(30),n2h16(126))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(505),h0tab(:,505),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(10),ngZd,m3h4x16(:,200),heltab2x64(:,:,493))
  call Hloop_Q_A(ntryL,G0H16(10),48,nMB,G1H16(37),n2h16(127))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(506),h0tab(:,506),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(38),m3h4x16(:,201),heltab2x64(:,:,494))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(507),h0tab(:,507),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,4))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(41),m3h4x16(:,202),heltab2x64(:,:,495))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(508),h0tab(:,508),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(42),m3h4x16(:,203),heltab2x64(:,:,496))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(509),h0tab(:,509),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(46),m3h4x16(:,204),heltab2x64(:,:,497))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(510),h0tab(:,510),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(50),m3h4x16(:,205),heltab2x64(:,:,498))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(511),h0tab(:,511),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(53),m3h4x16(:,206),heltab2x64(:,:,499))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(512),h0tab(:,512),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(52),m3h4x16(:,207),heltab2x64(:,:,500))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(513),h0tab(:,513),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(55),m3h4x16(:,208),heltab2x64(:,:,501))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(514),h0tab(:,514),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(58),m3h4x16(:,209),heltab2x64(:,:,502))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(515),h0tab(:,515),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(8),m3h4x16(:,210),heltab2x64(:,:,503))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(516),h0tab(:,516),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(12),m3h4x16(:,211),heltab2x64(:,:,504))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(517),h0tab(:,517),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(6),m3h4x16(:,212),heltab2x64(:,:,505))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(518),h0tab(:,518),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(15),m3h4x16(:,213),heltab2x64(:,:,506))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(519),h0tab(:,519),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(16),m3h4x16(:,214),heltab2x64(:,:,507))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(520),h0tab(:,520),[52,11],[nMZ,0],2,2,wf8(:,12),wf8(:,32))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,12),G0H8(4),ngZn,m3h8x8(:,47),heltab2x64(:,:,508))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(521),h0tab(:,521),[52,11],[nMW,0],2,2,wf8(:,12),wf8(:,32))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,12),G0H8(8),m3h8x8(:,48),heltab2x64(:,:,509))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(522),h0tab(:,522),[60,3],[0,0],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,18),G0H4(37),ngZn,m3h16x4(:,163),heltab2x64(:,:,510))
  call Hloop_Q_A(ntryL,G0H4(37),60,0,G1H4(99),n2h4(158))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(523),h0tab(:,523),[60,3],[0,0],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,18),G0H4(37),ngZl,m3h16x4(:,164),heltab2x64(:,:,511))
  call Hloop_Q_A(ntryL,G0H4(37),60,0,G1H4(100),n2h4(159))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(524),h0tab(:,524),[60,3],[nML,nML],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,18),G0H4(37),ngZl,m3h16x4(:,165),heltab2x64(:,:,512))
  call Hloop_Q_A(ntryL,G0H4(37),60,nML,G1H4(101),n2h4(160))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(525),h0tab(:,525),[60,3],[0,0],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,18),G0H4(37),ngZu,m3h16x4(:,166),heltab2x64(:,:,513))
  call Hloop_Q_A(ntryL,G0H4(37),60,0,G1H4(102),n2h4(161))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(526),h0tab(:,526),[60,3],[nMT,nMT],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,18),G0H4(37),ngZu,m3h16x4(:,167),heltab2x64(:,:,514))
  call Hloop_Q_A(ntryL,G0H4(37),60,nMT,G1H4(103),n2h4(162))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(527),h0tab(:,527),[60,3],[0,0],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,18),G0H4(37),ngZd,m3h16x4(:,168),heltab2x64(:,:,515))
  call Hloop_Q_A(ntryL,G0H4(37),60,0,G1H4(104),n2h4(163))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(528),h0tab(:,528),[60,3],[nMB,nMB],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,18),G0H4(37),ngZd,m3h16x4(:,169),heltab2x64(:,:,516))
  call Hloop_Q_A(ntryL,G0H4(37),60,nMB,G1H4(105),n2h4(164))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(529),h0tab(:,529),[60,3],[nMH,nMZ],2,2,wf16(:,18),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,18),60,G1H4(106),m3h16x4(:,170),heltab2x64(:,:,517))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(530),h0tab(:,530),[60,3],[nMW,nMW],2,2,wf16(:,18),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,18),60,G1H4(107),m3h16x4(:,171),heltab2x64(:,:,518))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(531),h0tab(:,531),[60,3],[nMW,nMW],2,2,wf16(:,18),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,18),60,G1H4(108),m3h16x4(:,172),heltab2x64(:,:,519))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(532),h0tab(:,532),[60,3],[nMW,nMW],2,2,wf16(:,18),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,18),60,G1H4(109),m3h16x4(:,173),heltab2x64(:,:,520))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(533),h0tab(:,533),[60,3],[nMW,nMW],2,2,wf16(:,18),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,18),60,G1H4(110),m3h16x4(:,174),heltab2x64(:,:,521))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(534),h0tab(:,534),[60,3],[nMH,nMZ],2,2,wf16(:,18),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,18),G0H4(37),m3h16x4(:,175),heltab2x64(:,:,522))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(535),h0tab(:,535),[60,3],[nMW,nMW],2,2,wf16(:,18),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,18),G0H4(38),m3h16x4(:,176),heltab2x64(:,:,523))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(536),h0tab(:,536),[60,3],[nMW,nMW],2,2,wf16(:,18),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,18),G0H4(39),m3h16x4(:,177),heltab2x64(:,:,524))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(537),h0tab(:,537),[60,3],[0,0],2,2,wf16(:,19),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,19),G0H4(40),ngZn,m3h16x4(:,178),heltab2x64(:,:,525))
  call Hloop_Q_A(ntryL,G0H4(40),60,0,G1H4(111),n2h4(165))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(538),h0tab(:,538),[60,3],[0,0],2,2,wf16(:,19),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,19),G0H4(40),ngZl,m3h16x4(:,179),heltab2x64(:,:,526))
  call Hloop_Q_A(ntryL,G0H4(40),60,0,G1H4(112),n2h4(166))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(539),h0tab(:,539),[60,3],[nML,nML],2,2,wf16(:,19),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,19),G0H4(40),ngZl,m3h16x4(:,180),heltab2x64(:,:,527))
  call Hloop_Q_A(ntryL,G0H4(40),60,nML,G1H4(113),n2h4(167))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(540),h0tab(:,540),[60,3],[0,0],2,2,wf16(:,19),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,19),G0H4(40),ngZu,m3h16x4(:,181),heltab2x64(:,:,528))
  call Hloop_Q_A(ntryL,G0H4(40),60,0,G1H4(114),n2h4(168))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(541),h0tab(:,541),[60,3],[nMT,nMT],2,2,wf16(:,19),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,19),G0H4(40),ngZu,m3h16x4(:,182),heltab2x64(:,:,529))
  call Hloop_Q_A(ntryL,G0H4(40),60,nMT,G1H4(115),n2h4(169))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(542),h0tab(:,542),[60,3],[0,0],2,2,wf16(:,19),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,19),G0H4(40),ngZd,m3h16x4(:,183),heltab2x64(:,:,530))
  call Hloop_Q_A(ntryL,G0H4(40),60,0,G1H4(116),n2h4(170))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(543),h0tab(:,543),[60,3],[nMB,nMB],2,2,wf16(:,19),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,19),G0H4(40),ngZd,m3h16x4(:,184),heltab2x64(:,:,531))
  call Hloop_Q_A(ntryL,G0H4(40),60,nMB,G1H4(117),n2h4(171))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(544),h0tab(:,544),[60,3],[nMH,nMZ],2,2,wf16(:,19),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,19),60,G1H4(118),m3h16x4(:,185),heltab2x64(:,:,532))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(545),h0tab(:,545),[60,3],[nMW,nMW],2,2,wf16(:,19),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,19),60,G1H4(119),m3h16x4(:,186),heltab2x64(:,:,533))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(546),h0tab(:,546),[60,3],[nMW,nMW],2,2,wf16(:,19),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,19),60,G1H4(120),m3h16x4(:,187),heltab2x64(:,:,534))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(547),h0tab(:,547),[60,3],[nMW,nMW],2,2,wf16(:,19),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,19),60,G1H4(121),m3h16x4(:,188),heltab2x64(:,:,535))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(548),h0tab(:,548),[60,3],[nMW,nMW],2,2,wf16(:,19),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,19),60,G1H4(122),m3h16x4(:,189),heltab2x64(:,:,536))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(549),h0tab(:,549),[60,3],[nMH,nMZ],2,2,wf16(:,19),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,19),G0H4(40),m3h16x4(:,190),heltab2x64(:,:,537))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(550),h0tab(:,550),[60,3],[nMW,nMW],2,2,wf16(:,19),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,19),G0H4(41),m3h16x4(:,191),heltab2x64(:,:,538))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(551),h0tab(:,551),[60,3],[nMW,nMW],2,2,wf16(:,19),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,19),G0H4(42),m3h16x4(:,192),heltab2x64(:,:,539))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(552),h0tab(:,552),[48,15],[0,0],2,2,wf4(:,5),wf16(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,215),heltab2x64(:,:,540))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(57),n2h16(128))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(553),h0tab(:,553),[48,15],[nML,nML],2,2,wf4(:,5),wf16(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,216),heltab2x64(:,:,541))
  call Hloop_Q_A(ntryL,G0H16(7),48,nML,G1H16(60),n2h16(129))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(554),h0tab(:,554),[48,15],[0,0],2,2,wf4(:,5),wf16(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,217),heltab2x64(:,:,542))
  call Hloop_Q_A(ntryL,G0H16(10),48,0,G1H16(63),n2h16(130))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(555),h0tab(:,555),[48,15],[nMT,nMT],2,2,wf4(:,5),wf16(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,218),heltab2x64(:,:,543))
  call Hloop_Q_A(ntryL,G0H16(17),48,nMT,G1H16(62),n2h16(131))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(556),h0tab(:,556),[48,15],[0,0],2,2,wf4(:,5),wf16(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,219),heltab2x64(:,:,544))
  call Hloop_Q_A(ntryL,G0H16(7),48,0,G1H16(65),n2h16(132))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(557),h0tab(:,557),[48,15],[nMB,nMB],2,2,wf4(:,5),wf16(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,220),heltab2x64(:,:,545))
  call Hloop_Q_A(ntryL,G0H16(10),48,nMB,G1H16(68),n2h16(133))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(558),h0tab(:,558),[48,15],[0,0],2,2,wf4(:,3),wf16(:,10))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZn,m3h4x16(:,221),heltab2x64(:,:,546))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(67),n2h16(134))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(559),h0tab(:,559),[48,15],[0,0],2,2,wf4(:,3),wf16(:,10))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZl,m3h4x16(:,222),heltab2x64(:,:,547))
  call Hloop_Q_A(ntryL,G0H16(7),48,0,G1H16(70),n2h16(135))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(560),h0tab(:,560),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,10))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(10),ngZl,m3h4x16(:,223),heltab2x64(:,:,548))
  call Hloop_Q_A(ntryL,G0H16(10),48,nML,G1H16(71),n2h16(136))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(561),h0tab(:,561),[48,15],[0,0],2,2,wf4(:,3),wf16(:,10))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZu,m3h4x16(:,224),heltab2x64(:,:,549))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(72),n2h16(137))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(562),h0tab(:,562),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,10))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZu,m3h4x16(:,225),heltab2x64(:,:,550))
  call Hloop_Q_A(ntryL,G0H16(7),48,nMT,G1H16(73),n2h16(138))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(563),h0tab(:,563),[48,15],[0,0],2,2,wf4(:,3),wf16(:,10))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(10),ngZd,m3h4x16(:,226),heltab2x64(:,:,551))
  call Hloop_Q_A(ntryL,G0H16(10),48,0,G1H16(74),n2h16(139))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(564),h0tab(:,564),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,10))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZd,m3h4x16(:,227),heltab2x64(:,:,552))
  call Hloop_Q_A(ntryL,G0H16(17),48,nMB,G1H16(75),n2h16(140))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(565),h0tab(:,565),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,10))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(76),m3h4x16(:,228),heltab2x64(:,:,553))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(566),h0tab(:,566),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,10))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(77),m3h4x16(:,229),heltab2x64(:,:,554))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(567),h0tab(:,567),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,10))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(78),m3h4x16(:,230),heltab2x64(:,:,555))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(568),h0tab(:,568),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,10))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(79),m3h4x16(:,231),heltab2x64(:,:,556))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(569),h0tab(:,569),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,10))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(80),m3h4x16(:,232),heltab2x64(:,:,557))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(570),h0tab(:,570),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,10))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(81),m3h4x16(:,233),heltab2x64(:,:,558))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(571),h0tab(:,571),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,10))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(82),m3h4x16(:,234),heltab2x64(:,:,559))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(572),h0tab(:,572),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(83),m3h4x16(:,235),heltab2x64(:,:,560))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(573),h0tab(:,573),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(84),m3h4x16(:,236),heltab2x64(:,:,561))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(574),h0tab(:,574),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,237),heltab2x64(:,:,562))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(575),h0tab(:,575),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,238),heltab2x64(:,:,563))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(576),h0tab(:,576),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(17),m3h4x16(:,239),heltab2x64(:,:,564))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(577),h0tab(:,577),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(18),m3h4x16(:,240),heltab2x64(:,:,565))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(578),h0tab(:,578),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(19),m3h4x16(:,241),heltab2x64(:,:,566))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(579),h0tab(:,579),[51,12],[0,0],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(43),ngZn,m3h16x4(:,193),heltab2x64(:,:,567))
  call Hloop_Q_A(ntryL,G0H4(43),51,0,G1H4(123),n2h4(172))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(580),h0tab(:,580),[51,12],[0,0],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(43),ngZl,m3h16x4(:,194),heltab2x64(:,:,568))
  call Hloop_Q_A(ntryL,G0H4(43),51,0,G1H4(124),n2h4(173))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(581),h0tab(:,581),[51,12],[nML,nML],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(43),ngZl,m3h16x4(:,195),heltab2x64(:,:,569))
  call Hloop_Q_A(ntryL,G0H4(43),51,nML,G1H4(125),n2h4(174))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(582),h0tab(:,582),[51,12],[0,0],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(43),ngZu,m3h16x4(:,196),heltab2x64(:,:,570))
  call Hloop_Q_A(ntryL,G0H4(43),51,0,G1H4(126),n2h4(175))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(583),h0tab(:,583),[51,12],[nMT,nMT],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(43),ngZu,m3h16x4(:,197),heltab2x64(:,:,571))
  call Hloop_Q_A(ntryL,G0H4(43),51,nMT,G1H4(127),n2h4(176))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(584),h0tab(:,584),[51,12],[0,0],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(43),ngZd,m3h16x4(:,198),heltab2x64(:,:,572))
  call Hloop_Q_A(ntryL,G0H4(43),51,0,G1H4(128),n2h4(177))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(585),h0tab(:,585),[51,12],[nMB,nMB],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(43),ngZd,m3h16x4(:,199),heltab2x64(:,:,573))
  call Hloop_Q_A(ntryL,G0H4(43),51,nMB,G1H4(129),n2h4(178))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(586),h0tab(:,586),[51,12],[nMZ,nMH],2,2,wf16(:,16),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,16),51,G1H4(130),m3h16x4(:,200),heltab2x64(:,:,574))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(587),h0tab(:,587),[51,12],[nMW,nMW],2,2,wf16(:,16),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,16),51,G1H4(131),m3h16x4(:,201),heltab2x64(:,:,575))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(588),h0tab(:,588),[51,12],[nMW,nMW],2,2,wf16(:,16),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,16),51,G1H4(132),m3h16x4(:,202),heltab2x64(:,:,576))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(589),h0tab(:,589),[51,12],[nMW,nMW],2,2,wf16(:,16),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,16),51,G1H4(133),m3h16x4(:,203),heltab2x64(:,:,577))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(590),h0tab(:,590),[51,12],[nMW,nMW],2,2,wf16(:,16),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,16),51,G1H4(134),m3h16x4(:,204),heltab2x64(:,:,578))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(591),h0tab(:,591),[51,12],[nMZ,nMH],2,2,wf16(:,16),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,16),G0H4(43),m3h16x4(:,205),heltab2x64(:,:,579))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(592),h0tab(:,592),[51,12],[nMW,nMW],2,2,wf16(:,16),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,16),G0H4(44),m3h16x4(:,206),heltab2x64(:,:,580))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(593),h0tab(:,593),[51,12],[nMW,nMW],2,2,wf16(:,16),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,16),G0H4(45),m3h16x4(:,207),heltab2x64(:,:,581))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(594),h0tab(:,594),[48,15],[0,0],2,2,wf4(:,5),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,242),heltab2x64(:,:,582))
  call Hloop_Q_A(ntryL,G0H16(20),48,0,G1H16(85),n2h16(141))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(595),h0tab(:,595),[48,15],[nML,nML],2,2,wf4(:,5),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,243),heltab2x64(:,:,583))
  call Hloop_Q_A(ntryL,G0H16(20),48,nML,G1H16(86),n2h16(142))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(596),h0tab(:,596),[48,15],[0,0],2,2,wf4(:,5),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,244),heltab2x64(:,:,584))
  call Hloop_Q_A(ntryL,G0H16(20),48,0,G1H16(87),n2h16(143))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(597),h0tab(:,597),[48,15],[nMT,nMT],2,2,wf4(:,5),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,245),heltab2x64(:,:,585))
  call Hloop_Q_A(ntryL,G0H16(20),48,nMT,G1H16(88),n2h16(144))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(598),h0tab(:,598),[48,15],[0,0],2,2,wf4(:,5),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,246),heltab2x64(:,:,586))
  call Hloop_Q_A(ntryL,G0H16(20),48,0,G1H16(89),n2h16(145))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(599),h0tab(:,599),[48,15],[nMB,nMB],2,2,wf4(:,5),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,247),heltab2x64(:,:,587))
  call Hloop_Q_A(ntryL,G0H16(20),48,nMB,G1H16(90),n2h16(146))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(600),h0tab(:,600),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(20),ngZn,m3h4x16(:,248),heltab2x64(:,:,588))
  call Hloop_Q_A(ntryL,G0H16(20),48,0,G1H16(91),n2h16(147))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(601),h0tab(:,601),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(20),ngZl,m3h4x16(:,249),heltab2x64(:,:,589))
  call Hloop_Q_A(ntryL,G0H16(20),48,0,G1H16(92),n2h16(148))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(602),h0tab(:,602),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(20),ngZl,m3h4x16(:,250),heltab2x64(:,:,590))
  call Hloop_Q_A(ntryL,G0H16(20),48,nML,G1H16(93),n2h16(149))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(603),h0tab(:,603),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(20),ngZu,m3h4x16(:,251),heltab2x64(:,:,591))
  call Hloop_Q_A(ntryL,G0H16(20),48,0,G1H16(94),n2h16(150))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(604),h0tab(:,604),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(20),ngZu,m3h4x16(:,252),heltab2x64(:,:,592))
  call Hloop_Q_A(ntryL,G0H16(20),48,nMT,G1H16(95),n2h16(151))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(605),h0tab(:,605),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(20),ngZd,m3h4x16(:,253),heltab2x64(:,:,593))
  call Hloop_Q_A(ntryL,G0H16(20),48,0,G1H16(96),n2h16(152))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(606),h0tab(:,606),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(20),ngZd,m3h4x16(:,254),heltab2x64(:,:,594))
  call Hloop_Q_A(ntryL,G0H16(20),48,nMB,G1H16(97),n2h16(153))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(607),h0tab(:,607),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,11))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(98),m3h4x16(:,255),heltab2x64(:,:,595))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(608),h0tab(:,608),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,11))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(99),m3h4x16(:,256),heltab2x64(:,:,596))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(609),h0tab(:,609),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(100),m3h4x16(:,257),heltab2x64(:,:,597))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(610),h0tab(:,610),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,11))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(101),m3h4x16(:,258),heltab2x64(:,:,598))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(611),h0tab(:,611),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,11))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(102),m3h4x16(:,259),heltab2x64(:,:,599))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(612),h0tab(:,612),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(103),m3h4x16(:,260),heltab2x64(:,:,600))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(613),h0tab(:,613),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(104),m3h4x16(:,261),heltab2x64(:,:,601))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(614),h0tab(:,614),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(105),m3h4x16(:,262),heltab2x64(:,:,602))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(615),h0tab(:,615),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(106),m3h4x16(:,263),heltab2x64(:,:,603))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(616),h0tab(:,616),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,264),heltab2x64(:,:,604))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(617),h0tab(:,617),[48,15],[nMW,nMW],2,2,wf4(:,5),wf16(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(21),m3h4x16(:,265),heltab2x64(:,:,605))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(618),h0tab(:,618),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(22),m3h4x16(:,266),heltab2x64(:,:,606))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(619),h0tab(:,619),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(23),m3h4x16(:,267),heltab2x64(:,:,607))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(620),h0tab(:,620),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(24),m3h4x16(:,268),heltab2x64(:,:,608))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(621),h0tab(:,621),[51,12],[0,0],2,2,wf16(:,17),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,17),G0H4(46),ngZn,m3h16x4(:,208),heltab2x64(:,:,609))
  call Hloop_Q_A(ntryL,G0H4(46),51,0,G1H4(135),n2h4(179))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(622),h0tab(:,622),[51,12],[0,0],2,2,wf16(:,17),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,17),G0H4(46),ngZl,m3h16x4(:,209),heltab2x64(:,:,610))
  call Hloop_Q_A(ntryL,G0H4(46),51,0,G1H4(136),n2h4(180))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(623),h0tab(:,623),[51,12],[nML,nML],2,2,wf16(:,17),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,17),G0H4(46),ngZl,m3h16x4(:,210),heltab2x64(:,:,611))
  call Hloop_Q_A(ntryL,G0H4(46),51,nML,G1H4(137),n2h4(181))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(624),h0tab(:,624),[51,12],[0,0],2,2,wf16(:,17),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,17),G0H4(46),ngZu,m3h16x4(:,211),heltab2x64(:,:,612))
  call Hloop_Q_A(ntryL,G0H4(46),51,0,G1H4(138),n2h4(182))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(625),h0tab(:,625),[51,12],[nMT,nMT],2,2,wf16(:,17),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,17),G0H4(46),ngZu,m3h16x4(:,212),heltab2x64(:,:,613))
  call Hloop_Q_A(ntryL,G0H4(46),51,nMT,G1H4(139),n2h4(183))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(626),h0tab(:,626),[51,12],[0,0],2,2,wf16(:,17),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,17),G0H4(46),ngZd,m3h16x4(:,213),heltab2x64(:,:,614))
  call Hloop_Q_A(ntryL,G0H4(46),51,0,G1H4(140),n2h4(184))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(627),h0tab(:,627),[51,12],[nMB,nMB],2,2,wf16(:,17),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,17),G0H4(46),ngZd,m3h16x4(:,214),heltab2x64(:,:,615))
  call Hloop_Q_A(ntryL,G0H4(46),51,nMB,G1H4(141),n2h4(185))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(628),h0tab(:,628),[51,12],[nMZ,nMH],2,2,wf16(:,17),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,17),51,G1H4(142),m3h16x4(:,215),heltab2x64(:,:,616))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(629),h0tab(:,629),[51,12],[nMW,nMW],2,2,wf16(:,17),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,17),51,G1H4(143),m3h16x4(:,216),heltab2x64(:,:,617))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(630),h0tab(:,630),[51,12],[nMW,nMW],2,2,wf16(:,17),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,17),51,G1H4(144),m3h16x4(:,217),heltab2x64(:,:,618))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(631),h0tab(:,631),[51,12],[nMW,nMW],2,2,wf16(:,17),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,17),51,G1H4(145),m3h16x4(:,218),heltab2x64(:,:,619))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(632),h0tab(:,632),[51,12],[nMW,nMW],2,2,wf16(:,17),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,17),51,G1H4(146),m3h16x4(:,219),heltab2x64(:,:,620))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(633),h0tab(:,633),[51,12],[nMZ,nMH],2,2,wf16(:,17),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,17),G0H4(46),m3h16x4(:,220),heltab2x64(:,:,621))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(634),h0tab(:,634),[51,12],[nMW,nMW],2,2,wf16(:,17),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,17),G0H4(47),m3h16x4(:,221),heltab2x64(:,:,622))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(635),h0tab(:,635),[51,12],[nMW,nMW],2,2,wf16(:,17),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,17),G0H4(48),m3h16x4(:,222),heltab2x64(:,:,623))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(636),h0tab(:,636),[50,13],[0,nMZ],2,2,wf8(:,52),wf8(:,15))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,52),G0H8(11),ngZn,m3h8x8(:,49),heltab2x64(:,:,624))
  call Hloop_A_Q(ntryL,G0H8(11),50,0,G1H8(17),n2h8(64))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(637),h0tab(:,637),[50,13],[0,nMW],2,2,wf8(:,52),wf8(:,15))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,52),G0H8(14),m3h8x8(:,50),heltab2x64(:,:,625))
  call Hloop_A_Q(ntryL,G0H8(14),50,0,G1H8(18),n2h8(65))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(638),h0tab(:,638),[49,14],[nMZ,0],2,2,wf8(:,18),wf8(:,54))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,18),G0H8(15),ngZn,m3h8x8(:,51),heltab2x64(:,:,626))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(639),h0tab(:,639),[49,14],[nMW,0],2,2,wf8(:,18),wf8(:,54))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,18),G0H8(16),m3h8x8(:,52),heltab2x64(:,:,627))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(107),G1H4(92),G1H4(90),G1H4(70),G1H4(68) &
    ,G0H4(13),G0H4(2),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(110),G1H4(98),G1H4(97),G1H4(76),G1H4(75) &
    ,G0H4(16),G0H4(4),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(143),[G1H4(131),G1H4(32),G1H4(30),G1H4(29),G1H4(18) &
    ,G0H4(6),G0H4(3),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(146),[G1H4(134),G1H4(13),G1H4(17),G1H4(5),G1H4(15) &
    ,G0H4(12),G0H4(9),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(11),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(17),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(22),[G1H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(33),[G1H16(35),G1H16(27),G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(3),[G0H16(14),G0H16(4),G0H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(137),[G1H4(125),G1H4(35),G1H4(23),G1H4(51),G1H4(44) &
    ,G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(127),G1H4(47),G1H4(45),G1H4(57),G1H4(7) &
    ,G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(141),[G1H4(129),G1H4(12),G1H4(48),G1H4(33),G1H4(19) &
    ,G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(145),[G1H4(144),G1H4(133),G1H4(132),G1H4(4),G1H4(40) &
    ,G1H4(39),G1H4(34),G1H4(9),G1H4(22),G1H4(53),G1H4(21),G0H4(11),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(58),G0H4(26),G0H4(25),G0H4(23),G0H4(22) &
    ,G0H4(21),G0H4(20),G0H4(18),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G1H4(101),G1H4(85),G1H4(78),G1H4(63),G1H4(6) &
    ,G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(103),G1H4(87),G1H4(80),G1H4(65),G1H4(54) &
    ,G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(105),G1H4(89),G1H4(82),G1H4(67),G1H4(60) &
    ,G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(120),G1H4(109),G1H4(108),G1H4(96),G1H4(95) &
    ,G1H4(94),G1H4(93),G1H4(74),G1H4(73),G1H4(72),G1H4(71),G0H4(15),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(36),G0H4(42),G0H4(41),G0H4(39),G0H4(38) &
    ,G0H4(36),G0H4(35),G0H4(33),G0H4(32),G0H4(31),G0H4(30),G0H4(28),G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(124),G1H4(2),G1H4(24),G1H4(41),G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(126),G1H4(31),G1H4(25),G1H4(50),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(140),[G1H4(128),G1H4(37),G1H4(46),G1H4(56),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(123),G1H4(49),G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(24),[G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(100),G1H4(84),G1H4(77),G1H4(62),G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(114),[G1H4(102),G1H4(86),G1H4(79),G1H4(64),G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(104),G1H4(88),G1H4(81),G1H4(66),G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(99),G1H4(83),G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(106),G1H4(91),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(40),[G0H4(37),G0H4(34),G0H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(48),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(47),[G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(51),[G1H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(54),[G1H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(56),[G1H16(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(64),[G1H16(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(26),G1H16(69),G1H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(1),[G0H16(13),G0H16(11),G0H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(21),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G1H16(53),G1H16(50),G1H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(58),[G1H16(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(16),[G0H16(15),G0H16(12),G0H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(70),[G1H16(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(71),[G1H16(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(72),[G1H16(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(73),[G1H16(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(74),[G1H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(75),[G1H16(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(78),[G1H16(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(82),[G1H16(81),G1H16(80),G1H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(84),[G1H16(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(19),[G0H16(18),G0H16(10),G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(142),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(46),[G0H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(48),[G0H4(47),G0H4(45),G0H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(92),[G1H16(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(93),[G1H16(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(94),[G1H16(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(95),[G1H16(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(96),[G1H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(97),[G1H16(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(100),[G1H16(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(104),[G1H16(103),G1H16(102),G1H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(106),[G1H16(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(24),[G0H16(23),G0H16(21),G0H16(20)])
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(119),60,wf4(:,1),3,G2tensor(115),m3h4x1(:,80),heltab2x4(:,:,177))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(122),60,wf4(:,1),3,G2tensor(33),m3h4x1(:,81),heltab2x4(:,:,178))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(143),51,wf4(:,2),12,G2tensor(19),m3h4x1(:,82),heltab2x4(:,:,179))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(146),51,wf4(:,2),12,G2tensor(103),m3h4x1(:,83),heltab2x4(:,:,180))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(4),wf4(:,1),wf4(:,2),G1tensor(199),m4h4x4x1(:,1),heltab3x16(:,:,1))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(11),wf4(:,1),wf4(:,2),G1tensor(229),m4h4x4x1(:,2),heltab3x16(:,:,2))
  call Hloop_QS_A(ntryL,G1H16(14),wf16(:,1),G1H1(1),ngH,m3h16x1(:,1),heltab2x16(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(108),n2h1(258))
  call Hloop_QS_A(ntryL,G1H16(17),wf16(:,1),G1H1(1),ngH,m3h16x1(:,2),heltab2x16(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(23),n2h1(259))
  call Hloop_QS_A(ntryL,G1H16(16),wf16(:,1),G1H1(1),ngH,m3h16x1(:,3),heltab2x16(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(31),n2h1(260))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H16(22),wf16(:,1),G1tensor(259),m3h16x1(:,4),heltab2x16(:,:,111))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H16(33),wf16(:,1),G1tensor(289),m3h16x1(:,5),heltab2x16(:,:,112))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H16(36),wf16(:,1),G1tensor(319),m3h16x1(:,6),heltab2x16(:,:,113))
  call Hcheck_last_VT_S(ntryL,l_switch,G0H16(3),48,wf16(:,1),15,G1tensor(349),m3h16x1(:,7),heltab2x16(:,:,114))
  call Hloop_QZ_A(ntryL,G1H4(137),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,84),heltab2x4(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(24),n2h1(261))
  call Hloop_QZ_A(ntryL,G1H4(139),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,85),heltab2x4(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(100),n2h1(262))
  call Hloop_QZ_A(ntryL,G1H4(141),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,86),heltab2x4(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(107),n2h1(263))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(145),51,wf4(:,2),12,G2tensor(17),m3h4x1(:,87),heltab2x4(:,:,184))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(20),wf4(:,2),G1tensor(264),m3h4x1(:,88),heltab2x4(:,:,185))
  call Hloop_QZ_A(ntryL,G1H4(113),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,89),heltab2x4(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(20),n2h1(264))
  call Hloop_QZ_A(ntryL,G1H4(115),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,90),heltab2x4(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(3),n2h1(265))
  call Hloop_QZ_A(ntryL,G1H4(117),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,91),heltab2x4(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(1),n2h1(266))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(121),60,wf4(:,1),3,G2tensor(140),m3h4x1(:,92),heltab2x4(:,:,189))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(10),wf4(:,1),G1tensor(276),m3h4x1(:,93),heltab2x4(:,:,190))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(10),wf8(:,3),G1tensor(168),m3h8x1(:,24),heltab2x8(:,:,143))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(12),wf8(:,3),G1tensor(28),ngZd,m3h8x1(:,25),heltab2x8(:,:,144))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(14),wf8(:,3),G1tensor(288),m3h8x1(:,26),heltab2x8(:,:,145))
  call Hloop_QZ_A(ntryL,G1H4(136),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,94),heltab2x4(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(267))
  call Hloop_QZ_A(ntryL,G1H4(138),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,95),heltab2x4(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(268))
  call Hloop_QZ_A(ntryL,G1H4(140),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,96),heltab2x4(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(269))
  call Hloop_QZ_A(ntryL,G1H4(135),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,97),heltab2x4(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(270))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(1),51,wf4(:,2),12,G2tensor(143),m3h4x1(:,98),heltab2x4(:,:,195))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(24),wf4(:,2),G0tensor(1),m3h4x1(:,99),heltab2x4(:,:,196))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(15),wf8(:,6),G1tensor(177),m3h8x1(:,27),heltab2x8(:,:,146))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(11),wf8(:,6),G1tensor(195),ngZd,m3h8x1(:,28),heltab2x8(:,:,147))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(46),wf8(:,6),G1tensor(63),m3h8x1(:,29),heltab2x8(:,:,148))
  call Hloop_QZ_A(ntryL,G1H4(112),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,100),heltab2x4(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(271))
  call Hloop_QZ_A(ntryL,G1H4(114),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,101),heltab2x4(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(272))
  call Hloop_QZ_A(ntryL,G1H4(116),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,102),heltab2x4(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(273))
  call Hloop_QZ_A(ntryL,G1H4(111),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,103),heltab2x4(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(274))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(118),60,wf4(:,1),3,G2tensor(79),m3h4x1(:,104),heltab2x4(:,:,201))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(40),wf4(:,1),G0tensor(26),m3h4x1(:,105),heltab2x4(:,:,202))
  call Hloop_QZ_A(ntryL,G1H16(49),wf16(:,3),G1H1(1),ngZl,m3h16x1(:,8),heltab2x16(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(275))
  call Hloop_QZ_A(ntryL,G1H16(48),wf16(:,3),G1H1(1),ngZl,m3h16x1(:,9),heltab2x16(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(4),n2h1(276))
  call Hloop_QZ_A(ntryL,G1H16(47),wf16(:,3),G1H1(1),ngZu,m3h16x1(:,10),heltab2x16(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(82),n2h1(277))
  call Hloop_QZ_A(ntryL,G1H16(51),wf16(:,3),G1H1(1),ngZu,m3h16x1(:,11),heltab2x16(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(85),n2h1(278))
  call Hloop_QZ_A(ntryL,G1H16(54),wf16(:,3),G1H1(1),ngZd,m3h16x1(:,12),heltab2x16(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(279))
  call Hloop_QZ_A(ntryL,G1H16(56),wf16(:,3),G1H1(1),ngZd,m3h16x1(:,13),heltab2x16(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(8),n2h1(280))
  call Hloop_QZ_A(ntryL,G1H16(43),wf16(:,3),G1H1(1),ngZn,m3h16x1(:,14),heltab2x16(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(88),n2h1(281))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H16(64),48,wf16(:,3),15,G2tensor(91),m3h16x1(:,15),heltab2x16(:,:,122))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H16(61),48,wf16(:,3),15,G2tensor(45),m3h16x1(:,16),heltab2x16(:,:,123))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(28),48,wf16(:,3),15,G2tensor(16),m3h16x1(:,17),heltab2x16(:,:,124))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(6),48,wf16(:,3),15,G2tensor(97),m3h16x1(:,18),heltab2x16(:,:,125))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H16(1),wf16(:,3),G0tensor(46),m3h16x1(:,19),heltab2x16(:,:,126))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H16(2),wf16(:,3),G0tensor(71),m3h16x1(:,20),heltab2x16(:,:,127))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(47),wf8(:,9),G1tensor(320),ngZn,m3h8x1(:,30),heltab2x8(:,:,149))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(16),wf8(:,9),G1tensor(62),m3h8x1(:,31),heltab2x8(:,:,150))
  call Hloop_QZ_A(ntryL,G1H16(23),wf16(:,4),G1H1(1),ngZl,m3h16x1(:,21),heltab2x16(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(122),n2h1(282))
  call Hloop_QZ_A(ntryL,G1H16(21),wf16(:,4),G1H1(1),ngZl,m3h16x1(:,22),heltab2x16(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(18),n2h1(283))
  call Hloop_QZ_A(ntryL,G1H16(24),wf16(:,4),G1H1(1),ngZu,m3h16x1(:,23),heltab2x16(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(284))
  call Hloop_QZ_A(ntryL,G1H16(29),wf16(:,4),G1H1(1),ngZu,m3h16x1(:,24),heltab2x16(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(21),n2h1(285))
  call Hloop_QZ_A(ntryL,G1H16(30),wf16(:,4),G1H1(1),ngZd,m3h16x1(:,25),heltab2x16(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(286))
  call Hloop_QZ_A(ntryL,G1H16(37),wf16(:,4),G1H1(1),ngZd,m3h16x1(:,26),heltab2x16(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(25),n2h1(287))
  call Hloop_QZ_A(ntryL,G1H16(20),wf16(:,4),G1H1(1),ngZn,m3h16x1(:,27),heltab2x16(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(288))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H16(42),48,wf16(:,4),15,G2tensor(26),m3h16x1(:,28),heltab2x16(:,:,135))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H16(41),48,wf16(:,4),15,G2tensor(52),m3h16x1(:,29),heltab2x16(:,:,136))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(52),48,wf16(:,4),15,G2tensor(146),m3h16x1(:,30),heltab2x16(:,:,137))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(58),48,wf16(:,4),15,G2tensor(27),m3h16x1(:,31),heltab2x16(:,:,138))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H16(16),wf16(:,4),G0tensor(96),m3h16x1(:,32),heltab2x16(:,:,139))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H16(6),wf16(:,4),G0tensor(116),m3h16x1(:,33),heltab2x16(:,:,140))
  call Hloop_ZA_Q(ntryL,G0H8(4),wf8(:,32),G0H1(1),ngZn,m3h8x1(:,32),heltab2x8(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(22),n2h1(289))
  call Hloop_WA_Q(ntryL,G0H8(8),wf8(:,32),G0H1(1),m3h8x1(:,33),heltab2x8(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(348),n2h1(290))
  call Hloop_QZ_A(ntryL,G1H16(70),wf16(:,10),G1H1(1),ngZl,m3h16x1(:,34),heltab2x16(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(28),n2h1(291))
  call Hloop_QZ_A(ntryL,G1H16(71),wf16(:,10),G1H1(1),ngZl,m3h16x1(:,35),heltab2x16(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(29),n2h1(292))
  call Hloop_QZ_A(ntryL,G1H16(72),wf16(:,10),G1H1(1),ngZu,m3h16x1(:,36),heltab2x16(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(293))
  call Hloop_QZ_A(ntryL,G1H16(73),wf16(:,10),G1H1(1),ngZu,m3h16x1(:,37),heltab2x16(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(58),n2h1(294))
  call Hloop_QZ_A(ntryL,G1H16(74),wf16(:,10),G1H1(1),ngZd,m3h16x1(:,38),heltab2x16(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(295))
  call Hloop_QZ_A(ntryL,G1H16(75),wf16(:,10),G1H1(1),ngZd,m3h16x1(:,39),heltab2x16(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(36),n2h1(296))
  call Hloop_QZ_A(ntryL,G1H16(67),wf16(:,10),G1H1(1),ngZn,m3h16x1(:,40),heltab2x16(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(297))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H16(78),48,wf16(:,10),15,G2tensor(38),m3h16x1(:,41),heltab2x16(:,:,148))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H16(77),48,wf16(:,10),15,G2tensor(149),m3h16x1(:,42),heltab2x16(:,:,149))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(82),48,wf16(:,10),15,G2tensor(41),m3h16x1(:,43),heltab2x16(:,:,150))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(84),48,wf16(:,10),15,G2tensor(47),m3h16x1(:,44),heltab2x16(:,:,151))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H16(19),wf16(:,10),G0tensor(141),m3h16x1(:,45),heltab2x16(:,:,152))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H16(17),wf16(:,10),G0tensor(166),m3h16x1(:,46),heltab2x16(:,:,153))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(142),51,wf4(:,2),12,G2tensor(61),m3h4x1(:,106),heltab2x4(:,:,203))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(46),wf4(:,2),G0tensor(191),m3h4x1(:,107),heltab2x4(:,:,204))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(48),wf4(:,2),G0tensor(216),m3h4x1(:,108),heltab2x4(:,:,205))
  call Hloop_QZ_A(ntryL,G1H16(92),wf16(:,11),G1H1(1),ngZl,m3h16x1(:,47),heltab2x16(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(298))
  call Hloop_QZ_A(ntryL,G1H16(93),wf16(:,11),G1H1(1),ngZl,m3h16x1(:,48),heltab2x16(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(152),n2h1(299))
  call Hloop_QZ_A(ntryL,G1H16(94),wf16(:,11),G1H1(1),ngZu,m3h16x1(:,49),heltab2x16(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(300))
  call Hloop_QZ_A(ntryL,G1H16(95),wf16(:,11),G1H1(1),ngZu,m3h16x1(:,50),heltab2x16(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(124),n2h1(301))
  call Hloop_QZ_A(ntryL,G1H16(96),wf16(:,11),G1H1(1),ngZd,m3h16x1(:,51),heltab2x16(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(302))
  call Hloop_QZ_A(ntryL,G1H16(97),wf16(:,11),G1H1(1),ngZd,m3h16x1(:,52),heltab2x16(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(128),n2h1(303))
  call Hloop_QZ_A(ntryL,G1H16(91),wf16(:,11),G1H1(1),ngZn,m3h16x1(:,53),heltab2x16(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(130),n2h1(304))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H16(100),48,wf16(:,11),15,G2tensor(132),m3h16x1(:,54),heltab2x16(:,:,161))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H16(99),48,wf16(:,11),15,G2tensor(134),m3h16x1(:,55),heltab2x16(:,:,162))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(104),48,wf16(:,11),15,G2tensor(136),m3h16x1(:,56),heltab2x16(:,:,163))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(106),48,wf16(:,11),15,G2tensor(138),m3h16x1(:,57),heltab2x16(:,:,164))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H16(24),wf16(:,11),G0tensor(241),m3h16x1(:,58),heltab2x16(:,:,165))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H16(22),wf16(:,11),G0tensor(266),m3h16x1(:,59),heltab2x16(:,:,166))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(17),wf8(:,15),G1tensor(356),ngZn,m3h8x1(:,34),heltab2x8(:,:,153))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(18),wf8(:,15),G1tensor(128),m3h8x1(:,35),heltab2x8(:,:,154))
  call Hloop_ZA_Q(ntryL,G0H8(15),wf8(:,54),G0H1(1),ngZn,m3h8x1(:,36),heltab2x8(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(25),n2h1(305))
  call Hloop_WA_Q(ntryL,G0H8(16),wf8(:,54),G0H1(1),m3h8x1(:,37),heltab2x8(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(55),n2h1(306))
  call ol_merge_tensors(G2tensor(140),[G2tensor(33),G2tensor(115),G1tensor(276),G0tensor(13),G0tensor(916),G0tensor(801) &
    ,G0tensor(676),G0tensor(326),G0tensor(296),G0tensor(251),G0tensor(221),G0tensor(6)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(103),G2tensor(19),G1tensor(264),G0tensor(216),G0tensor(857),G0tensor(54) &
    ,G0tensor(19),G0tensor(951),G0tensor(896),G0tensor(871),G0tensor(846),G0tensor(376),G0tensor(271),G0tensor(246) &
    ,G0tensor(11)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(136),G2tensor(132),G2tensor(47),G2tensor(41),G2tensor(38),G2tensor(27) &
    ,G2tensor(146),G2tensor(26),G2tensor(97),G2tensor(16),G2tensor(91),G1tensor(349),G1tensor(319),G1tensor(289),G1tensor(259) &
    ,G1tensor(229),G1tensor(199),G0tensor(241),G0tensor(141),G0tensor(96),G0tensor(46),G0tensor(318),G0tensor(760),G0tensor(780) &
    ,G0tensor(937),G0tensor(99),G0tensor(740),G0tensor(701),G0tensor(256),G0tensor(206),G0tensor(181),G0tensor(16)])
  call ol_merge_tensors(G0tensor(979),[G0tensor(880),G0tensor(615),G0tensor(245),G0tensor(239),G0tensor(259),G0tensor(207) &
    ,G0tensor(864),G0tensor(824),G0tensor(784),G0tensor(652),G0tensor(335),G0tensor(338),G0tensor(197),G0tensor(199),G0tensor(307) &
    ,G0tensor(169),G0tensor(214),G0tensor(578),G0tensor(563),G0tensor(92),G0tensor(293),G0tensor(475),G0tensor(439),G0tensor(722) &
    ,G0tensor(325),G0tensor(339),G0tensor(72),G0tensor(575),G0tensor(609),G0tensor(39),G0tensor(545),G0tensor(530),G0tensor(549) &
    ,G0tensor(69),G0tensor(52),G0tensor(27),G0tensor(715),G0tensor(277),G0tensor(78),G0tensor(922),G0tensor(959),G0tensor(752) &
    ,G0tensor(190),G0tensor(522),G0tensor(155),G0tensor(598),G0tensor(930),G0tensor(905),G0tensor(537),G0tensor(956),G0tensor(931) &
    ,G0tensor(906),G0tensor(881),G0tensor(856),G0tensor(806),G0tensor(731),G0tensor(706),G0tensor(681),G0tensor(606),G0tensor(581) &
    ,G0tensor(531),G0tensor(461),G0tensor(436),G0tensor(411),G0tensor(386),G0tensor(361),G0tensor(336),G0tensor(311),G0tensor(286) &
    ,G0tensor(261),G0tensor(236),G0tensor(211),G0tensor(186),G0tensor(161),G0tensor(91),G0tensor(21)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(11),G2tensor(55),G2tensor(5),G0tensor(996),G0tensor(991),G0tensor(987),G0tensor(982) &
    ,G0tensor(177),G0tensor(863),G0tensor(158),G0tensor(157),G0tensor(145),G0tensor(602),G0tensor(124),G0tensor(304),G0tensor(550) &
    ,G0tensor(528),G0tensor(532),G0tensor(18),G0tensor(695),G0tensor(3),G0tensor(97),G0tensor(945),G0tensor(969),G0tensor(20) &
    ,G0tensor(705),G0tensor(920),G0tensor(476),G0tensor(76),G0tensor(51),G0tensor(31)])
  call ol_merge_tensors(G1tensor(168),[G0tensor(125),G0tensor(36)])
  call ol_merge_tensors(G0tensor(975),[G0tensor(111),G0tensor(41)])
  call ol_merge_tensors(G1tensor(28),[G0tensor(319),G0tensor(904),G0tensor(670),G0tensor(826),G0tensor(56)])
  call ol_merge_tensors(G0tensor(589),[G0tensor(943),G0tensor(63),G0tensor(727),G0tensor(131),G0tensor(61)])
  call ol_merge_tensors(G0tensor(1002),[G0tensor(993),G0tensor(984),G0tensor(580),G0tensor(520),G0tensor(424),G0tensor(250) &
    ,G0tensor(948),G0tensor(932),G0tensor(913),G0tensor(899),G0tensor(907),G0tensor(774),G0tensor(788),G0tensor(744),G0tensor(742) &
    ,G0tensor(719),G0tensor(717),G0tensor(694),G0tensor(738),G0tensor(679),G0tensor(677),G0tensor(643),G0tensor(603),G0tensor(594) &
    ,G0tensor(543),G0tensor(513),G0tensor(493),G0tensor(498),G0tensor(478),G0tensor(614),G0tensor(489),G0tensor(638),G0tensor(633) &
    ,G0tensor(758),G0tensor(570),G0tensor(364),G0tensor(379),G0tensor(444),G0tensor(328),G0tensor(617),G0tensor(567),G0tensor(502) &
    ,G0tensor(224),G0tensor(290),G0tensor(487),G0tensor(268),G0tensor(527),G0tensor(622),G0tensor(847),G0tensor(173),G0tensor(333) &
    ,G0tensor(422),G0tensor(164),G0tensor(167),G0tensor(282),G0tensor(587),G0tensor(149),G0tensor(350),G0tensor(218),G0tensor(362) &
    ,G0tensor(372),G0tensor(474),G0tensor(345),G0tensor(132),G0tensor(122),G0tensor(569),G0tensor(805),G0tensor(275),G0tensor(324) &
    ,G0tensor(117),G0tensor(650),G0tensor(640),G0tensor(363),G0tensor(102),G0tensor(327),G0tensor(120),G0tensor(94),G0tensor(495) &
    ,G0tensor(618),G0tensor(383),G0tensor(664),G0tensor(690),G0tensor(53),G0tensor(310),G0tensor(42),G0tensor(9),G0tensor(17) &
    ,G0tensor(58),G0tensor(40),G0tensor(540),G0tensor(685),G0tensor(831),G0tensor(781),G0tensor(756),G0tensor(656),G0tensor(631) &
    ,G0tensor(556),G0tensor(506),G0tensor(136),G0tensor(66)])
  call ol_merge_tensors(G1tensor(288),[G0tensor(212),G0tensor(866),G0tensor(431),G0tensor(81)])
  call ol_merge_tensors(G0tensor(252),[G0tensor(2),G0tensor(876),G0tensor(156),G0tensor(86)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(10),G2tensor(34),G2tensor(13),G0tensor(797),G0tensor(347),G0tensor(777) &
    ,G0tensor(420),G0tensor(767),G0tensor(302),G0tensor(542),G0tensor(38),G0tensor(816),G0tensor(751),G0tensor(726),G0tensor(626) &
    ,G0tensor(576),G0tensor(541),G0tensor(516),G0tensor(491),G0tensor(471),G0tensor(446),G0tensor(421),G0tensor(146),G0tensor(121) &
    ,G0tensor(101)])
  call ol_merge_tensors(G1tensor(177),[G0tensor(680),G0tensor(106)])
  call ol_merge_tensors(G1tensor(195),[G0tensor(529),G0tensor(958),G0tensor(702),G0tensor(700),G0tensor(126)])
  call ol_merge_tensors(G1tensor(63),[G0tensor(270),G0tensor(279),G0tensor(851),G0tensor(151)])
  call ol_merge_tensors(G0tensor(555),[G0tensor(205),G0tensor(954),G0tensor(100),G0tensor(309),G0tensor(512),G0tensor(970) &
    ,G0tensor(835),G0tensor(171)])
  call ol_merge_tensors(G0tensor(588),[G0tensor(526),G0tensor(176)])
  call ol_merge_tensors(G0tensor(630),[G0tensor(23),G0tensor(791),G0tensor(571),G0tensor(196)])
  call ol_merge_tensors(G0tensor(978),[G0tensor(28),G0tensor(901),G0tensor(201)])
  call ol_merge_tensors(G0tensor(77),[G0tensor(64),G0tensor(964),G0tensor(782),G0tensor(226)])
  call ol_merge_tensors(G0tensor(613),[G0tensor(480),G0tensor(467),G0tensor(65),G0tensor(940),G0tensor(582),G0tensor(281) &
    ,G0tensor(231)])
  call ol_merge_tensors(G0tensor(222),[G0tensor(449),G0tensor(950),G0tensor(306),G0tensor(276)])
  call ol_merge_tensors(G0tensor(834),[G0tensor(944),G0tensor(778),G0tensor(377),G0tensor(974),G0tensor(832),G0tensor(45) &
    ,G0tensor(301)])
  call ol_merge_tensors(G0tensor(783),[G0tensor(355),G0tensor(283),G0tensor(237),G0tensor(33),G0tensor(971),G0tensor(946) &
    ,G0tensor(451),G0tensor(346),G0tensor(321)])
  call ol_merge_tensors(G1tensor(62),[G0tensor(939),G0tensor(855),G0tensor(887),G0tensor(928),G0tensor(456),G0tensor(331)])
  call ol_merge_tensors(G1tensor(348),[G0tensor(263),G0tensor(593),G0tensor(400),G0tensor(966),G0tensor(926),G0tensor(351)])
  call ol_merge_tensors(G2tensor(130),[G2tensor(126),G2tensor(73),G2tensor(67),G2tensor(37),G2tensor(32),G2tensor(30),G2tensor(28) &
    ,G2tensor(49),G2tensor(22),G2tensor(15),G2tensor(122),G2tensor(88),G2tensor(6),G2tensor(82),G2tensor(2),G0tensor(1001) &
    ,G0tensor(869),G0tensor(713),G0tensor(852),G0tensor(585),G0tensor(43),G0tensor(707),G0tensor(200),G0tensor(967),G0tensor(32) &
    ,G0tensor(965),G0tensor(757),G0tensor(747),G0tensor(49),G0tensor(776),G0tensor(651),G0tensor(601),G0tensor(481),G0tensor(406) &
    ,G0tensor(356)])
  call ol_merge_tensors(G0tensor(337),[G0tensor(865),G0tensor(840),G0tensor(133),G0tensor(80),G0tensor(82),G0tensor(716) &
    ,G0tensor(671),G0tensor(396),G0tensor(371)])
  call ol_merge_tensors(G1tensor(128),[G0tensor(794),G0tensor(343),G0tensor(830),G0tensor(960),G0tensor(696),G0tensor(381)])
  call ol_merge_tensors(G1tensor(55),[G0tensor(348),G0tensor(84),G0tensor(255),G0tensor(10),G0tensor(900),G0tensor(401)])
  call ol_merge_tensors(G0tensor(953),[G0tensor(833),G0tensor(667),G0tensor(841),G0tensor(426)])
  call ol_merge_tensors(G0tensor(490),[G0tensor(455),G0tensor(793),G0tensor(629),G0tensor(604),G0tensor(393),G0tensor(394) &
    ,G0tensor(402),G0tensor(238),G0tensor(257),G0tensor(89),G0tensor(35),G0tensor(30),G0tensor(496)])
  call ol_merge_tensors(G1tensor(320),[G0tensor(579),G0tensor(862),G0tensor(175),G0tensor(174),G0tensor(90),G0tensor(912) &
    ,G0tensor(501)])
  call ol_merge_tensors(G0tensor(977),[G0tensor(243),G0tensor(344),G0tensor(592),G0tensor(7),G0tensor(160),G0tensor(521)])
  call ol_merge_tensors(G0tensor(938),[G0tensor(927),G0tensor(743),G0tensor(688),G0tensor(658),G0tensor(419),G0tensor(264) &
    ,G0tensor(225),G0tensor(143),G0tensor(129),G0tensor(546)])
  call ol_merge_tensors(G0tensor(728),[G0tensor(453),G0tensor(50),G0tensor(551)])
  call ol_merge_tensors(G0tensor(559),[G0tensor(29),G0tensor(515),G0tensor(891),G0tensor(796),G0tensor(591),G0tensor(566)])
  call ol_merge_tensors(G0tensor(74),[G0tensor(284),G0tensor(596)])
  call ol_merge_tensors(G0tensor(523),[G0tensor(753),G0tensor(459),G0tensor(233),G0tensor(552),G0tensor(557),G0tensor(147) &
    ,G0tensor(135),G0tensor(642),G0tensor(641),G0tensor(616)])
  call ol_merge_tensors(G0tensor(460),[G0tensor(315),G0tensor(242),G0tensor(272),G0tensor(144),G0tensor(389),G0tensor(134) &
    ,G0tensor(745),G0tensor(621)])
  call ol_merge_tensors(G0tensor(673),[G0tensor(837),G0tensor(785),G0tensor(646)])
  call ol_merge_tensors(G0tensor(838),[G0tensor(184),G0tensor(83),G0tensor(229),G0tensor(962),G0tensor(925),G0tensor(14) &
    ,G0tensor(721),G0tensor(691),G0tensor(666)])
  call ol_merge_tensors(G0tensor(564),[G0tensor(292),G0tensor(437),G0tensor(193),G0tensor(820),G0tensor(662),G0tensor(118) &
    ,G0tensor(802),G0tensor(110),G0tensor(766),G0tensor(741)])
  call ol_merge_tensors(G0tensor(1000),[G0tensor(414),G0tensor(410),G0tensor(428),G0tensor(194),G0tensor(353),G0tensor(170) &
    ,G0tensor(123),G0tensor(235),G0tensor(140),G0tensor(915),G0tensor(746)])
  call ol_merge_tensors(G1tensor(25),[G0tensor(804),G0tensor(370),G0tensor(332),G0tensor(308),G0tensor(845),G0tensor(725) &
    ,G0tensor(771)])
  call ol_merge_tensors(G0tensor(249),[G0tensor(897),G0tensor(755),G0tensor(8),G0tensor(180),G0tensor(821)])
  call ol_merge_tensors(G0tensor(657),[G0tensor(330),G0tensor(808),G0tensor(803),G0tensor(85),G0tensor(504),G0tensor(790) &
    ,G0tensor(952),G0tensor(941),G0tensor(921)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(409),G0tensor(297),G0tensor(828),G0tensor(440),G0tensor(104),G0tensor(458) &
    ,G0tensor(597)])
  call ol_merge_tensors(G0tensor(655),[G0tensor(183),G0tensor(687),G0tensor(860)])
  call ol_merge_tensors(G0tensor(374),[G0tensor(320),G0tensor(773),G0tensor(514),G0tensor(418),G0tensor(403),G0tensor(429) &
    ,G0tensor(499),G0tensor(510),G0tensor(558),G0tensor(88),G0tensor(858),G0tensor(942)])
  call ol_merge_tensors(G0tensor(720),[G0tensor(972),G0tensor(285)])
  call ol_merge_tensors(G0tensor(924),[G0tensor(898),G0tensor(699),G0tensor(454),G0tensor(390),G0tensor(313),G0tensor(232) &
    ,G0tensor(329),G0tensor(108),G0tensor(792),G0tensor(892),G0tensor(590),G0tensor(44)])
  call ol_merge_tensors(G2tensor(20),[G0tensor(605)])
  call ol_merge_tensors(G2tensor(24),[G0tensor(75)])
  call ol_merge_tensors(G2tensor(152),[G2tensor(29),G2tensor(18),G2tensor(4),G2tensor(108),G0tensor(55)])
  call ol_merge_tensors(G2tensor(3),[G0tensor(497)])
  call ol_merge_tensors(G2tensor(100),[G0tensor(359)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(58),G2tensor(21),G2tensor(85),G2tensor(23),G0tensor(274)])
  call ol_merge_tensors(G2tensor(1),[G0tensor(392)])
  call ol_merge_tensors(G2tensor(107),[G0tensor(300)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(36),G2tensor(25),G2tensor(8),G2tensor(31),G0tensor(220)])
  call ol_merge_tensors(G0tensor(698),[G0tensor(683),G0tensor(533),G0tensor(423),G0tensor(384),G0tensor(289),G0tensor(823) &
    ,G0tensor(73),G0tensor(750)])
  call ol_merge_tensors(G0tensor(210),[G0tensor(244),G0tensor(923),G0tensor(914),G0tensor(789),G0tensor(764),G0tensor(763) &
    ,G0tensor(435),G0tensor(93),G0tensor(395),G0tensor(500)])
  call ol_merge_tensors(G0tensor(988),[G0tensor(839),G0tensor(724),G0tensor(827),G0tensor(963),G0tensor(574),G0tensor(79) &
    ,G0tensor(427)])
  call ol_merge_tensors(G0tensor(986),[G0tensor(154),G0tensor(152),G0tensor(254),G0tensor(115),G0tensor(562),G0tensor(625) &
    ,G0tensor(649)])
  call ol_merge_tensors(G0tensor(247),[G0tensor(295),G0tensor(934),G0tensor(909),G0tensor(829),G0tensor(668),G0tensor(654) &
    ,G0tensor(450),G0tensor(770),G0tensor(762),G0tensor(163)])
  call ol_merge_tensors(G0tensor(539),[G0tensor(168),G0tensor(298),G0tensor(853),G0tensor(179),G0tensor(378),G0tensor(107) &
    ,G0tensor(765),G0tensor(772)])
  call ol_merge_tensors(G0tensor(992),[G0tensor(684),G0tensor(754),G0tensor(407),G0tensor(547),G0tensor(367),G0tensor(137) &
    ,G0tensor(127),G0tensor(665),G0tensor(660),G0tensor(445),G0tensor(109)])
  call ol_merge_tensors(G0tensor(653),[G0tensor(408),G0tensor(385),G0tensor(105),G0tensor(208),G0tensor(342)])
  call ol_merge_tensors(G0tensor(464),[G0tensor(258),G0tensor(712),G0tensor(689),G0tensor(795),G0tensor(463)])
  call ol_merge_tensors(G0tensor(494),[G0tensor(365),G0tensor(929),G0tensor(729),G0tensor(800),G0tensor(388)])
  call ol_merge_tensors(G0tensor(433),[G0tensor(404),G0tensor(195),G0tensor(360),G0tensor(119),G0tensor(294),G0tensor(973)])
  call ol_merge_tensors(G0tensor(981),[G0tensor(859),G0tensor(768),G0tensor(737),G0tensor(714),G0tensor(693),G0tensor(697) &
    ,G0tensor(814),G0tensor(534),G0tensor(815),G0tensor(114),G0tensor(113)])
  call ol_merge_tensors(G0tensor(990),[G0tensor(734),G0tensor(674),G0tensor(672),G0tensor(139),G0tensor(810),G0tensor(442)])
  call ol_merge_tensors(G0tensor(983),[G0tensor(799),G0tensor(708),G0tensor(703),G0tensor(142),G0tensor(968),G0tensor(624)])
  call ol_merge_tensors(G0tensor(995),[G0tensor(477),G0tensor(172),G0tensor(380),G0tensor(138)])
  call ol_merge_tensors(G0tensor(997),[G0tensor(854),G0tensor(878),G0tensor(822),G0tensor(817)])
  call ol_merge_tensors(G1tensor(356),[G0tensor(999),G0tensor(723),G0tensor(369),G0tensor(843),G0tensor(848),G0tensor(150) &
    ,G0tensor(357)])
  call ol_merge_tensors(G0tensor(844),[G0tensor(599),G0tensor(518),G0tensor(503),G0tensor(265),G0tensor(288)])
  call ol_merge_tensors(G0tensor(413),[G0tensor(267),G0tensor(227),G0tensor(187),G0tensor(412),G0tensor(228)])
  call ol_merge_tensors(G0tensor(519),[G0tensor(809),G0tensor(759),G0tensor(637),G0tensor(182),G0tensor(178)])
  call ol_merge_tensors(G0tensor(976),[G0tensor(659),G0tensor(619),G0tensor(483),G0tensor(748),G0tensor(620),G0tensor(375) &
    ,G0tensor(874),G0tensor(352),G0tensor(202),G0tensor(287),G0tensor(883),G0tensor(188),G0tensor(607)])
  call ol_merge_tensors(G0tensor(554),[G0tensor(469),G0tensor(354),G0tensor(632),G0tensor(627),G0tensor(572),G0tensor(718) &
    ,G0tensor(492)])
  call ol_merge_tensors(G2tensor(143),[G0tensor(1)])
  call ol_merge_tensors(G2tensor(79),[G0tensor(26)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(149),G2tensor(52),G2tensor(45),G0tensor(266),G0tensor(166),G0tensor(116) &
    ,G0tensor(71)])
  call ol_merge_tensors(G2tensor(61),[G0tensor(191)])
call TI_bubble_red(G2tensor(140),60,mass2set(:,1),G0tensor(291),M2L1R1,G0tensor(316))
call TI_bubble_red(G2tensor(17),51,mass2set(:,1),G0tensor(341),M2L1R1,G0tensor(366))
call TI_bubble_red(G2tensor(138),48,mass2set(:,1),G0tensor(391),M2L1R1,G0tensor(416))
call TI_bubble_red(G2tensor(9),51,mass2set(:,2),G0tensor(441),M2L1R1)
call TI_bubble_red(G2tensor(76),60,mass2set(:,2),G0tensor(466),M2L1R1)
call TI_bubble_red(G2tensor(130),48,mass2set(:,2),G0tensor(486),M2L1R1)
call TI_bubble_red(G2tensor(20),60,mass2set(:,3),G0tensor(511),M2L1R1,G0tensor(536))
call TI_bubble_red(G2tensor(24),51,mass2set(:,3),G0tensor(561),M2L1R1,G0tensor(586))
call TI_bubble_red(G2tensor(152),48,mass2set(:,3),G0tensor(611),M2L1R1,G0tensor(636))
call TI_bubble_red(G2tensor(3),60,mass2set(:,4),G0tensor(661),M2L1R1,G0tensor(686))
call TI_bubble_red(G2tensor(100),51,mass2set(:,4),G0tensor(711),M2L1R1,G0tensor(736))
call TI_bubble_red(G2tensor(124),48,mass2set(:,4),G0tensor(761),M2L1R1,G0tensor(786))
call TI_bubble_red(G2tensor(1),60,mass2set(:,5),G0tensor(811),M2L1R1,G0tensor(60))
call TI_bubble_red(G2tensor(107),51,mass2set(:,5),G0tensor(682),M2L1R1,G0tensor(836))
call TI_bubble_red(G2tensor(128),48,mass2set(:,5),G0tensor(861),M2L1R1,G0tensor(886))
call TI_bubble_red(G2tensor(143),51,mass2set(:,6),G0tensor(911),M2L1R1,G0tensor(936),G0tensor(961))
call TI_bubble_red(G2tensor(79),60,mass2set(:,6),G0tensor(509),M2L1R1,G0tensor(405),G0tensor(67))
call TI_bubble_red(G2tensor(134),48,mass2set(:,6),G0tensor(234),M2L1R1,G0tensor(25),G0tensor(260))
call TI_bubble_red(G2tensor(61),51,mass2set(:,7),G0tensor(710),M2L1R1,G0tensor(430),G0tensor(470))
  call ol_merge_tensors(G0tensor(979),[G0tensor(416),G0tensor(366),G0tensor(316)])
  call ol_merge_tensors(G0tensor(470),[G0tensor(25),G0tensor(405),G0tensor(936),G0tensor(1002)])
  call ol_merge_tensors(G0tensor(62),[G0tensor(636),G0tensor(586),G0tensor(536)])
  call ol_merge_tensors(G0tensor(269),[G0tensor(786),G0tensor(736),G0tensor(686)])
  call ol_merge_tensors(G0tensor(215),[G0tensor(886),G0tensor(836),G0tensor(60)])
  call ol_merge_tensors(G0tensor(430),[G0tensor(260),G0tensor(67),G0tensor(961)])
call TI_bubble_red(G1tensor(168),44,mass2set(:,2),G0tensor(262),M2L1R1)
call TI_bubble_red(G1tensor(28),44,mass2set(:,8),G0tensor(87),M2L1R1,G0tensor(553))
call TI_bubble_red(G1tensor(288),44,mass2set(:,9),G0tensor(368),M2L1R1,G0tensor(568))
call TI_bubble_red(G1tensor(177),35,mass2set(:,2),G0tensor(425),M2L1R1)
call TI_bubble_red(G1tensor(195),35,mass2set(:,8),G0tensor(505),M2L1R1,G0tensor(775))
call TI_bubble_red(G1tensor(63),35,mass2set(:,9),G0tensor(95),M2L1R1,G0tensor(98))
call TI_bubble_red(G1tensor(62),56,mass2set(:,9),G0tensor(248),M2L1R1,G0tensor(813))
call TI_bubble_red(G1tensor(348),52,mass2set(:,10),G0tensor(103),M2L1R1,G0tensor(373))
call TI_bubble_red(G1tensor(128),50,mass2set(:,9),G0tensor(635),M2L1R1,G0tensor(645))
call TI_bubble_red(G1tensor(55),49,mass2set(:,10),G0tensor(112),M2L1R1,G0tensor(299))
call TI_bubble_red(G1tensor(320),56,mass2set(:,8),G0tensor(240),M2L1R1,G0tensor(128))
call TI_bubble_red(G1tensor(25),49,mass2set(:,11),G0tensor(565),M2L1R1,G0tensor(807))
call TI_bubble_red(G1tensor(22),52,mass2set(:,11),G0tensor(812),M2L1R1,G0tensor(209))
call TI_bubble_red(G1tensor(356),50,mass2set(:,8),G0tensor(340),M2L1R1,G0tensor(399))
  call ol_merge_tensors(G0tensor(299),[G0tensor(645),G0tensor(373),G0tensor(813),G0tensor(98),G0tensor(568),G0tensor(979)])
  call ol_merge_tensors(G0tensor(399),[G0tensor(209),G0tensor(807),G0tensor(128),G0tensor(775),G0tensor(470),G0tensor(553)])
  call ol_merge_tensors(T0sum(426),[G0tensor(291)])
  call ol_merge_tensors(T0sum(427),[G0tensor(299)])
  call ol_merge_tensors(T0sum(428),[G0tensor(341)])
  call ol_merge_tensors(T0sum(429),[G0tensor(391)])
  call ol_merge_tensors(T0sum(430),[G0tensor(441)])
  call ol_merge_tensors(T0sum(431),[G0tensor(262)])
  call ol_merge_tensors(T0sum(432),[G0tensor(975)])
  call ol_merge_tensors(T0sum(433),[G0tensor(87)])
  call ol_merge_tensors(T0sum(434),[G0tensor(399)])
  call ol_merge_tensors(T0sum(435),[G0tensor(589)])
  call ol_merge_tensors(T0sum(436),[G0tensor(368)])
  call ol_merge_tensors(T0sum(437),[G0tensor(252)])
  call ol_merge_tensors(T0sum(438),[G0tensor(466)])
  call ol_merge_tensors(T0sum(439),[G0tensor(425)])
  call ol_merge_tensors(T0sum(440),[G0tensor(505)])
  call ol_merge_tensors(T0sum(441),[G0tensor(95)])
  call ol_merge_tensors(T0sum(442),[G0tensor(555)])
  call ol_merge_tensors(T0sum(443),[G0tensor(588)])
  call ol_merge_tensors(T0sum(444),[G0tensor(630)])
  call ol_merge_tensors(T0sum(445),[G0tensor(978)])
  call ol_merge_tensors(T0sum(446),[G0tensor(77)])
  call ol_merge_tensors(T0sum(447),[G0tensor(613)])
  call ol_merge_tensors(T0sum(448),[G0tensor(222)])
  call ol_merge_tensors(T0sum(449),[G0tensor(834)])
  call ol_merge_tensors(T0sum(450),[G0tensor(783)])
  call ol_merge_tensors(T0sum(451),[G0tensor(248)])
  call ol_merge_tensors(T0sum(452),[G0tensor(103)])
  call ol_merge_tensors(T0sum(453),[G0tensor(486)])
  call ol_merge_tensors(T0sum(454),[G0tensor(337)])
  call ol_merge_tensors(T0sum(455),[G0tensor(635)])
  call ol_merge_tensors(T0sum(456),[G0tensor(112)])
  call ol_merge_tensors(T0sum(457),[G0tensor(953)])
  call ol_merge_tensors(T0sum(458),[G0tensor(490)])
  call ol_merge_tensors(T0sum(459),[G0tensor(240)])
  call ol_merge_tensors(T0sum(460),[G0tensor(977)])
  call ol_merge_tensors(T0sum(461),[G0tensor(938)])
  call ol_merge_tensors(T0sum(462),[G0tensor(728)])
  call ol_merge_tensors(T0sum(463),[G0tensor(559)])
  call ol_merge_tensors(T0sum(464),[G0tensor(74)])
  call ol_merge_tensors(T0sum(465),[G0tensor(523)])
  call ol_merge_tensors(T0sum(466),[G0tensor(460)])
  call ol_merge_tensors(T0sum(467),[G0tensor(673)])
  call ol_merge_tensors(T0sum(468),[G0tensor(838)])
  call ol_merge_tensors(T0sum(469),[G0tensor(564)])
  call ol_merge_tensors(T0sum(470),[G0tensor(1000)])
  call ol_merge_tensors(T0sum(471),[G0tensor(565)])
  call ol_merge_tensors(T0sum(472),[G0tensor(249)])
  call ol_merge_tensors(T0sum(473),[G0tensor(657)])
  call ol_merge_tensors(T0sum(474),[G0tensor(812)])
  call ol_merge_tensors(T0sum(475),[G0tensor(655)])
  call ol_merge_tensors(T0sum(476),[G0tensor(374)])
  call ol_merge_tensors(T0sum(477),[G0tensor(720)])
  call ol_merge_tensors(T0sum(478),[G0tensor(924)])
  call ol_merge_tensors(T0sum(479),[G0tensor(511)])
  call ol_merge_tensors(T0sum(480),[G0tensor(62)])
  call ol_merge_tensors(T0sum(481),[G0tensor(561)])
  call ol_merge_tensors(T0sum(482),[G0tensor(611)])
  call ol_merge_tensors(T0sum(483),[G0tensor(661)])
  call ol_merge_tensors(T0sum(484),[G0tensor(269)])
  call ol_merge_tensors(T0sum(485),[G0tensor(711)])
  call ol_merge_tensors(T0sum(486),[G0tensor(761)])
  call ol_merge_tensors(T0sum(487),[G0tensor(811)])
  call ol_merge_tensors(T0sum(488),[G0tensor(215)])
  call ol_merge_tensors(T0sum(489),[G0tensor(682)])
  call ol_merge_tensors(T0sum(490),[G0tensor(861)])
  call ol_merge_tensors(T0sum(491),[G0tensor(698)])
  call ol_merge_tensors(T0sum(492),[G0tensor(210)])
  call ol_merge_tensors(T0sum(493),[G0tensor(988)])
  call ol_merge_tensors(T0sum(494),[G0tensor(986)])
  call ol_merge_tensors(T0sum(495),[G0tensor(247)])
  call ol_merge_tensors(T0sum(496),[G0tensor(539)])
  call ol_merge_tensors(T0sum(497),[G0tensor(992)])
  call ol_merge_tensors(T0sum(498),[G0tensor(653)])
  call ol_merge_tensors(T0sum(499),[G0tensor(464)])
  call ol_merge_tensors(T0sum(500),[G0tensor(494)])
  call ol_merge_tensors(T0sum(501),[G0tensor(433)])
  call ol_merge_tensors(T0sum(502),[G0tensor(981)])
  call ol_merge_tensors(T0sum(503),[G0tensor(990)])
  call ol_merge_tensors(T0sum(504),[G0tensor(983)])
  call ol_merge_tensors(T0sum(505),[G0tensor(995)])
  call ol_merge_tensors(T0sum(506),[G0tensor(997)])
  call ol_merge_tensors(T0sum(507),[G0tensor(340)])
  call ol_merge_tensors(T0sum(508),[G0tensor(844)])
  call ol_merge_tensors(T0sum(509),[G0tensor(413)])
  call ol_merge_tensors(T0sum(510),[G0tensor(519)])
  call ol_merge_tensors(T0sum(511),[G0tensor(976)])
  call ol_merge_tensors(T0sum(512),[G0tensor(554)])
  call ol_merge_tensors(T0sum(513),[G0tensor(911)])
  call ol_merge_tensors(T0sum(514),[G0tensor(430)])
  call ol_merge_tensors(T0sum(515),[G0tensor(509)])
  call ol_merge_tensors(T0sum(516),[G0tensor(234)])
  call ol_merge_tensors(T0sum(517),[G0tensor(710)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 44, 45, 47 ],masses2_68,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 40, 45, 47 ],masses2_48,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 40, 44, 47 ],masses2_56,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 40, 44, 45 ],masses2_54,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_68,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 32, 45, 47 ],masses2_68,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 32, 44, 47 ],masses2_74,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 32, 44, 45 ],masses2_72,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 12, 13, 15 ],masses2_70,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 32, 40, 47 ],masses2_68,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 32, 40, 45 ],masses2_66,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 8, 13, 15 ],masses2_49,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 32, 40, 44 ],masses2_68,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 8, 12, 15 ],masses2_57,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 8, 12, 13 ],masses2_55,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 35, 39, 47 ],masses2_68,RedSet_4(16),ScalarBoxes(16))
  call compute_scalar_box([ 34, 39, 47 ],masses2_48,RedSet_4(17),ScalarBoxes(17))
  call compute_scalar_box([ 34, 35, 47 ],masses2_56,RedSet_4(18),ScalarBoxes(18))
  call compute_scalar_box([ 34, 35, 39 ],masses2_54,RedSet_4(19),ScalarBoxes(19))
  call compute_scalar_box([ 1, 5, 13 ],masses2_68,RedSet_4(20),ScalarBoxes(20))
  call compute_scalar_box([ 32, 39, 47 ],masses2_68,RedSet_4(21),ScalarBoxes(21))
  call compute_scalar_box([ 32, 35, 47 ],masses2_74,RedSet_4(22),ScalarBoxes(22))
  call compute_scalar_box([ 32, 35, 39 ],masses2_72,RedSet_4(23),ScalarBoxes(23))
  call compute_scalar_box([ 3, 7, 15 ],masses2_70,RedSet_4(24),ScalarBoxes(24))
  call compute_scalar_box([ 32, 34, 47 ],masses2_68,RedSet_4(25),ScalarBoxes(25))
  call compute_scalar_box([ 32, 34, 39 ],masses2_66,RedSet_4(26),ScalarBoxes(26))
  call compute_scalar_box([ 2, 7, 15 ],masses2_49,RedSet_4(27),ScalarBoxes(27))
  call compute_scalar_box([ 32, 34, 35 ],masses2_68,RedSet_4(28),ScalarBoxes(28))
  call compute_scalar_box([ 2, 3, 15 ],masses2_57,RedSet_4(29),ScalarBoxes(29))
  call compute_scalar_box([ 2, 3, 7 ],masses2_55,RedSet_4(30),ScalarBoxes(30))
  call compute_scalar_box([ 36, 45, 47 ],masses2_48,RedSet_4(31),ScalarBoxes(31))
  call compute_scalar_box([ 36, 44, 47 ],masses2_56,RedSet_4(32),ScalarBoxes(32))
  call compute_scalar_box([ 36, 44, 45 ],masses2_54,RedSet_4(33),ScalarBoxes(33))
  call compute_scalar_box([ 8, 9, 11 ],masses2_68,RedSet_4(34),ScalarBoxes(34))
  call compute_scalar_box([ 32, 36, 47 ],masses2_68,RedSet_4(35),ScalarBoxes(35))
  call compute_scalar_box([ 32, 36, 45 ],masses2_66,RedSet_4(36),ScalarBoxes(36))
  call compute_scalar_box([ 4, 13, 15 ],masses2_49,RedSet_4(37),ScalarBoxes(37))
  call compute_scalar_box([ 32, 36, 44 ],masses2_68,RedSet_4(38),ScalarBoxes(38))
  call compute_scalar_box([ 4, 12, 15 ],masses2_57,RedSet_4(39),ScalarBoxes(39))
  call compute_scalar_box([ 4, 12, 13 ],masses2_55,RedSet_4(40),ScalarBoxes(40))
  call compute_scalar_box([ 35, 43, 47 ],masses2_68,RedSet_4(41),ScalarBoxes(41))
  call compute_scalar_box([ 34, 43, 47 ],masses2_48,RedSet_4(42),ScalarBoxes(42))
  call compute_scalar_box([ 34, 35, 43 ],masses2_54,RedSet_4(43),ScalarBoxes(43))
  call compute_scalar_box([ 1, 9, 13 ],masses2_68,RedSet_4(44),ScalarBoxes(44))
  call compute_scalar_box([ 32, 43, 47 ],masses2_68,RedSet_4(45),ScalarBoxes(45))
  call compute_scalar_box([ 32, 35, 43 ],masses2_72,RedSet_4(46),ScalarBoxes(46))
  call compute_scalar_box([ 3, 11, 15 ],masses2_70,RedSet_4(47),ScalarBoxes(47))
  call compute_scalar_box([ 32, 34, 43 ],masses2_66,RedSet_4(48),ScalarBoxes(48))
  call compute_scalar_box([ 2, 11, 15 ],masses2_49,RedSet_4(49),ScalarBoxes(49))
  call compute_scalar_box([ 2, 3, 11 ],masses2_55,RedSet_4(50),ScalarBoxes(50))
  call compute_scalar_box([ 35, 43, 47 ],masses2_61,RedSet_4(41),ScalarBoxes(51))
  call compute_scalar_box([ 34, 43, 47 ],masses2_46,RedSet_4(42),ScalarBoxes(52))
  call compute_scalar_box([ 34, 35, 47 ],masses2_52,RedSet_4(18),ScalarBoxes(53))
  call compute_scalar_box([ 34, 35, 43 ],masses2_50,RedSet_4(43),ScalarBoxes(54))
  call compute_scalar_box([ 1, 9, 13 ],masses2_61,RedSet_4(44),ScalarBoxes(55))
  call compute_scalar_box([ 32, 43, 47 ],masses2_61,RedSet_4(45),ScalarBoxes(56))
  call compute_scalar_box([ 32, 35, 47 ],masses2_65,RedSet_4(22),ScalarBoxes(57))
  call compute_scalar_box([ 32, 35, 43 ],masses2_63,RedSet_4(46),ScalarBoxes(58))
  call compute_scalar_box([ 3, 11, 15 ],masses2_62,RedSet_4(47),ScalarBoxes(59))
  call compute_scalar_box([ 32, 34, 47 ],masses2_61,RedSet_4(25),ScalarBoxes(60))
  call compute_scalar_box([ 32, 34, 43 ],masses2_59,RedSet_4(48),ScalarBoxes(61))
  call compute_scalar_box([ 2, 11, 15 ],masses2_47,RedSet_4(49),ScalarBoxes(62))
  call compute_scalar_box([ 32, 34, 35 ],masses2_61,RedSet_4(28),ScalarBoxes(63))
  call compute_scalar_box([ 2, 3, 15 ],masses2_53,RedSet_4(29),ScalarBoxes(64))
  call compute_scalar_box([ 2, 3, 11 ],masses2_51,RedSet_4(50),ScalarBoxes(65))
  call compute_scalar_box([ 44, 46, 47 ],masses2_68,RedSet_4(51),ScalarBoxes(66))
  call compute_scalar_box([ 40, 46, 47 ],masses2_48,RedSet_4(52),ScalarBoxes(67))
  call compute_scalar_box([ 40, 44, 46 ],masses2_54,RedSet_4(53),ScalarBoxes(68))
  call compute_scalar_box([ 4, 6, 7 ],masses2_68,RedSet_4(54),ScalarBoxes(69))
  call compute_scalar_box([ 32, 46, 47 ],masses2_68,RedSet_4(55),ScalarBoxes(70))
  call compute_scalar_box([ 32, 44, 46 ],masses2_72,RedSet_4(56),ScalarBoxes(71))
  call compute_scalar_box([ 12, 14, 15 ],masses2_70,RedSet_4(57),ScalarBoxes(72))
  call compute_scalar_box([ 32, 40, 46 ],masses2_66,RedSet_4(58),ScalarBoxes(73))
  call compute_scalar_box([ 8, 14, 15 ],masses2_49,RedSet_4(59),ScalarBoxes(74))
  call compute_scalar_box([ 8, 12, 14 ],masses2_55,RedSet_4(60),ScalarBoxes(75))
  call compute_scalar_box([ 44, 46, 47 ],masses2_61,RedSet_4(51),ScalarBoxes(76))
  call compute_scalar_box([ 40, 46, 47 ],masses2_46,RedSet_4(52),ScalarBoxes(77))
  call compute_scalar_box([ 40, 44, 47 ],masses2_52,RedSet_4(3),ScalarBoxes(78))
  call compute_scalar_box([ 40, 44, 46 ],masses2_50,RedSet_4(53),ScalarBoxes(79))
  call compute_scalar_box([ 4, 6, 7 ],masses2_61,RedSet_4(54),ScalarBoxes(80))
  call compute_scalar_box([ 32, 46, 47 ],masses2_61,RedSet_4(55),ScalarBoxes(81))
  call compute_scalar_box([ 32, 44, 47 ],masses2_65,RedSet_4(7),ScalarBoxes(82))
  call compute_scalar_box([ 32, 44, 46 ],masses2_63,RedSet_4(56),ScalarBoxes(83))
  call compute_scalar_box([ 12, 14, 15 ],masses2_62,RedSet_4(57),ScalarBoxes(84))
  call compute_scalar_box([ 32, 40, 47 ],masses2_61,RedSet_4(10),ScalarBoxes(85))
  call compute_scalar_box([ 32, 40, 46 ],masses2_59,RedSet_4(58),ScalarBoxes(86))
  call compute_scalar_box([ 8, 14, 15 ],masses2_47,RedSet_4(59),ScalarBoxes(87))
  call compute_scalar_box([ 32, 40, 44 ],masses2_61,RedSet_4(13),ScalarBoxes(88))
  call compute_scalar_box([ 8, 12, 15 ],masses2_53,RedSet_4(14),ScalarBoxes(89))
  call compute_scalar_box([ 8, 12, 14 ],masses2_51,RedSet_4(60),ScalarBoxes(90))
  call compute_scalar_box([ 36, 46, 47 ],masses2_48,RedSet_4(61),ScalarBoxes(91))
  call compute_scalar_box([ 36, 44, 46 ],masses2_54,RedSet_4(62),ScalarBoxes(92))
  call compute_scalar_box([ 8, 10, 11 ],masses2_68,RedSet_4(63),ScalarBoxes(93))
  call compute_scalar_box([ 32, 36, 46 ],masses2_66,RedSet_4(64),ScalarBoxes(94))
  call compute_scalar_box([ 4, 14, 15 ],masses2_49,RedSet_4(65),ScalarBoxes(95))
  call compute_scalar_box([ 4, 12, 14 ],masses2_55,RedSet_4(66),ScalarBoxes(96))
  call compute_scalar_box([ 33, 39, 47 ],masses2_48,RedSet_4(67),ScalarBoxes(97))
  call compute_scalar_box([ 33, 35, 47 ],masses2_56,RedSet_4(68),ScalarBoxes(98))
  call compute_scalar_box([ 33, 35, 39 ],masses2_54,RedSet_4(69),ScalarBoxes(99))
  call compute_scalar_box([ 2, 6, 14 ],masses2_68,RedSet_4(70),ScalarBoxes(100))
  call compute_scalar_box([ 32, 33, 47 ],masses2_68,RedSet_4(71),ScalarBoxes(101))
  call compute_scalar_box([ 32, 33, 39 ],masses2_66,RedSet_4(72),ScalarBoxes(102))
  call compute_scalar_box([ 1, 7, 15 ],masses2_49,RedSet_4(73),ScalarBoxes(103))
  call compute_scalar_box([ 32, 33, 35 ],masses2_68,RedSet_4(74),ScalarBoxes(104))
  call compute_scalar_box([ 1, 3, 15 ],masses2_57,RedSet_4(75),ScalarBoxes(105))
  call compute_scalar_box([ 1, 3, 7 ],masses2_55,RedSet_4(76),ScalarBoxes(106))
  call compute_scalar_box([ 33, 43, 47 ],masses2_48,RedSet_4(77),ScalarBoxes(107))
  call compute_scalar_box([ 33, 35, 43 ],masses2_54,RedSet_4(78),ScalarBoxes(108))
  call compute_scalar_box([ 2, 10, 14 ],masses2_68,RedSet_4(79),ScalarBoxes(109))
  call compute_scalar_box([ 32, 33, 43 ],masses2_66,RedSet_4(80),ScalarBoxes(110))
  call compute_scalar_box([ 1, 11, 15 ],masses2_49,RedSet_4(81),ScalarBoxes(111))
  call compute_scalar_box([ 1, 3, 11 ],masses2_55,RedSet_4(82),ScalarBoxes(112))
  call compute_scalar_box([ 56, 60, 61 ],masses2_55,RedSet_4(83),ScalarBoxes(113))
  call compute_scalar_box([ 48, 60, 61 ],masses2_73,RedSet_4(84),ScalarBoxes(114))
  call compute_scalar_box([ 48, 56, 61 ],masses2_67,RedSet_4(85),ScalarBoxes(115))
  call compute_scalar_box([ 48, 56, 60 ],masses2_70,RedSet_4(86),ScalarBoxes(116))
  call compute_scalar_box([ 50, 51, 55 ],masses2_55,RedSet_4(87),ScalarBoxes(117))
  call compute_scalar_box([ 48, 51, 55 ],masses2_73,RedSet_4(88),ScalarBoxes(118))
  call compute_scalar_box([ 48, 50, 55 ],masses2_67,RedSet_4(89),ScalarBoxes(119))
  call compute_scalar_box([ 48, 50, 51 ],masses2_70,RedSet_4(90),ScalarBoxes(120))
  call compute_scalar_box([ 52, 60, 61 ],masses2_55,RedSet_4(91),ScalarBoxes(121))
  call compute_scalar_box([ 48, 52, 61 ],masses2_67,RedSet_4(92),ScalarBoxes(122))
  call compute_scalar_box([ 48, 52, 60 ],masses2_70,RedSet_4(93),ScalarBoxes(123))
  call compute_scalar_box([ 50, 51, 59 ],masses2_55,RedSet_4(94),ScalarBoxes(124))
  call compute_scalar_box([ 48, 51, 59 ],masses2_73,RedSet_4(95),ScalarBoxes(125))
  call compute_scalar_box([ 48, 50, 59 ],masses2_67,RedSet_4(96),ScalarBoxes(126))
  call compute_scalar_box([ 50, 51, 59 ],masses2_51,RedSet_4(94),ScalarBoxes(127))
  call compute_scalar_box([ 48, 51, 59 ],masses2_64,RedSet_4(95),ScalarBoxes(128))
  call compute_scalar_box([ 48, 50, 59 ],masses2_60,RedSet_4(96),ScalarBoxes(129))
  call compute_scalar_box([ 48, 50, 51 ],masses2_62,RedSet_4(90),ScalarBoxes(130))
  call compute_scalar_box([ 56, 60, 62 ],masses2_55,RedSet_4(97),ScalarBoxes(131))
  call compute_scalar_box([ 48, 60, 62 ],masses2_73,RedSet_4(98),ScalarBoxes(132))
  call compute_scalar_box([ 48, 56, 62 ],masses2_67,RedSet_4(99),ScalarBoxes(133))
  call compute_scalar_box([ 56, 60, 62 ],masses2_51,RedSet_4(97),ScalarBoxes(134))
  call compute_scalar_box([ 48, 60, 62 ],masses2_64,RedSet_4(98),ScalarBoxes(135))
  call compute_scalar_box([ 48, 56, 62 ],masses2_60,RedSet_4(99),ScalarBoxes(136))
  call compute_scalar_box([ 48, 56, 60 ],masses2_62,RedSet_4(86),ScalarBoxes(137))
  call compute_scalar_box([ 52, 60, 62 ],masses2_55,RedSet_4(100),ScalarBoxes(138))
  call compute_scalar_box([ 48, 52, 62 ],masses2_67,RedSet_4(101),ScalarBoxes(139))
  call compute_scalar_box([ 49, 51, 55 ],masses2_55,RedSet_4(102),ScalarBoxes(140))
  call compute_scalar_box([ 48, 49, 55 ],masses2_67,RedSet_4(103),ScalarBoxes(141))
  call compute_scalar_box([ 48, 49, 51 ],masses2_70,RedSet_4(104),ScalarBoxes(142))
  call compute_scalar_box([ 49, 51, 59 ],masses2_55,RedSet_4(105),ScalarBoxes(143))
  call compute_scalar_box([ 48, 49, 59 ],masses2_67,RedSet_4(106),ScalarBoxes(144))
  call compute_scalar_box([ 35, 51, 55 ],masses2_55,RedSet_4(107),ScalarBoxes(145))
  call compute_scalar_box([ 32, 51, 55 ],masses2_55,RedSet_4(108),ScalarBoxes(146))
  call compute_scalar_box([ 32, 35, 55 ],masses2_45,RedSet_4(109),ScalarBoxes(147))
  call compute_scalar_box([ 32, 35, 51 ],masses2_49,RedSet_4(110),ScalarBoxes(148))
  call compute_scalar_box([ 3, 19, 23 ],masses2_54,RedSet_4(111),ScalarBoxes(149))
  call compute_scalar_box([ 35, 51, 55 ],masses2_51,RedSet_4(107),ScalarBoxes(150))
  call compute_scalar_box([ 32, 51, 55 ],masses2_51,RedSet_4(108),ScalarBoxes(151))
  call compute_scalar_box([ 32, 35, 55 ],masses2_44,RedSet_4(109),ScalarBoxes(152))
  call compute_scalar_box([ 32, 35, 51 ],masses2_47,RedSet_4(110),ScalarBoxes(153))
  call compute_scalar_box([ 3, 19, 23 ],masses2_50,RedSet_4(111),ScalarBoxes(154))
  call compute_scalar_box([ 35, 51, 59 ],masses2_55,RedSet_4(112),ScalarBoxes(155))
  call compute_scalar_box([ 32, 51, 59 ],masses2_55,RedSet_4(113),ScalarBoxes(156))
  call compute_scalar_box([ 32, 35, 59 ],masses2_45,RedSet_4(114),ScalarBoxes(157))
  call compute_scalar_box([ 3, 19, 27 ],masses2_54,RedSet_4(115),ScalarBoxes(158))
  call compute_scalar_box([ 49, 51, 55 ],masses2_51,RedSet_4(102),ScalarBoxes(159))
  call compute_scalar_box([ 48, 51, 55 ],masses2_64,RedSet_4(88),ScalarBoxes(160))
  call compute_scalar_box([ 48, 49, 55 ],masses2_60,RedSet_4(103),ScalarBoxes(161))
  call compute_scalar_box([ 48, 49, 51 ],masses2_62,RedSet_4(104),ScalarBoxes(162))
  call compute_scalar_box([ 1, 3, 7 ],masses2_51,RedSet_4(76),ScalarBoxes(163))
  call compute_scalar_box([ 40, 43, 47 ],masses2_48,RedSet_4(116),ScalarBoxes(164))
  call compute_scalar_box([ 32, 40, 43 ],masses2_66,RedSet_4(117),ScalarBoxes(165))
  call compute_scalar_box([ 8, 11, 15 ],masses2_49,RedSet_4(118),ScalarBoxes(166))
  call compute_scalar_box([ 40, 43, 47 ],masses2_46,RedSet_4(116),ScalarBoxes(167))
  call compute_scalar_box([ 32, 40, 43 ],masses2_59,RedSet_4(117),ScalarBoxes(168))
  call compute_scalar_box([ 8, 11, 15 ],masses2_47,RedSet_4(118),ScalarBoxes(169))
  call compute_scalar_box([ 36, 39, 47 ],masses2_48,RedSet_4(119),ScalarBoxes(170))
  call compute_scalar_box([ 32, 36, 39 ],masses2_66,RedSet_4(120),ScalarBoxes(171))
  call compute_scalar_box([ 4, 7, 15 ],masses2_49,RedSet_4(121),ScalarBoxes(172))
  call compute_scalar_box([ 34, 35, 51 ],masses2_54,RedSet_4(122),ScalarBoxes(173))
  call compute_scalar_box([ 32, 35, 51 ],masses2_72,RedSet_4(110),ScalarBoxes(174))
  call compute_scalar_box([ 32, 34, 51 ],masses2_66,RedSet_4(123),ScalarBoxes(175))
  call compute_scalar_box([ 2, 3, 19 ],masses2_55,RedSet_4(124),ScalarBoxes(176))
  call compute_scalar_box([ 34, 35, 51 ],masses2_50,RedSet_4(122),ScalarBoxes(177))
  call compute_scalar_box([ 32, 35, 51 ],masses2_63,RedSet_4(110),ScalarBoxes(178))
  call compute_scalar_box([ 32, 34, 51 ],masses2_59,RedSet_4(123),ScalarBoxes(179))
  call compute_scalar_box([ 2, 3, 19 ],masses2_51,RedSet_4(124),ScalarBoxes(180))
  call compute_scalar_box([ 33, 35, 51 ],masses2_54,RedSet_4(125),ScalarBoxes(181))
  call compute_scalar_box([ 32, 33, 51 ],masses2_66,RedSet_4(126),ScalarBoxes(182))
  call compute_scalar_box([ 1, 3, 19 ],masses2_55,RedSet_4(127),ScalarBoxes(183))
  call compute_scalar_box([ 34, 46, 47 ],masses2_48,RedSet_4(128),ScalarBoxes(184))
  call compute_scalar_box([ 32, 34, 46 ],masses2_66,RedSet_4(129),ScalarBoxes(185))
  call compute_scalar_box([ 2, 14, 15 ],masses2_49,RedSet_4(130),ScalarBoxes(186))
  call compute_scalar_box([ 34, 46, 47 ],masses2_46,RedSet_4(128),ScalarBoxes(187))
  call compute_scalar_box([ 32, 34, 46 ],masses2_59,RedSet_4(129),ScalarBoxes(188))
  call compute_scalar_box([ 2, 14, 15 ],masses2_47,RedSet_4(130),ScalarBoxes(189))
  call compute_scalar_box([ 33, 45, 47 ],masses2_48,RedSet_4(131),ScalarBoxes(190))
  call compute_scalar_box([ 32, 33, 45 ],masses2_66,RedSet_4(132),ScalarBoxes(191))
  call compute_scalar_box([ 1, 13, 15 ],masses2_49,RedSet_4(133),ScalarBoxes(192))
  call compute_scalar_box([ 52, 53, 55 ],masses2_68,RedSet_4(134),ScalarBoxes(193))
  call compute_scalar_box([ 48, 53, 55 ],masses2_48,RedSet_4(135),ScalarBoxes(194))
  call compute_scalar_box([ 48, 52, 55 ],masses2_56,RedSet_4(136),ScalarBoxes(195))
  call compute_scalar_box([ 48, 52, 53 ],masses2_54,RedSet_4(137),ScalarBoxes(196))
  call compute_scalar_box([ 52, 54, 55 ],masses2_61,RedSet_4(138),ScalarBoxes(197))
  call compute_scalar_box([ 48, 54, 55 ],masses2_46,RedSet_4(139),ScalarBoxes(198))
  call compute_scalar_box([ 48, 52, 55 ],masses2_52,RedSet_4(136),ScalarBoxes(199))
  call compute_scalar_box([ 48, 52, 54 ],masses2_50,RedSet_4(140),ScalarBoxes(200))
  call compute_scalar_box([ 52, 54, 55 ],masses2_68,RedSet_4(138),ScalarBoxes(201))
  call compute_scalar_box([ 48, 54, 55 ],masses2_48,RedSet_4(139),ScalarBoxes(202))
  call compute_scalar_box([ 48, 52, 54 ],masses2_54,RedSet_4(140),ScalarBoxes(203))
  call compute_scalar_box([ 49, 53, 61 ],masses2_68,RedSet_4(141),ScalarBoxes(204))
  call compute_scalar_box([ 48, 53, 61 ],masses2_48,RedSet_4(142),ScalarBoxes(205))
  call compute_scalar_box([ 48, 49, 61 ],masses2_56,RedSet_4(143),ScalarBoxes(206))
  call compute_scalar_box([ 48, 49, 53 ],masses2_54,RedSet_4(144),ScalarBoxes(207))
  call compute_scalar_box([ 49, 57, 61 ],masses2_61,RedSet_4(145),ScalarBoxes(208))
  call compute_scalar_box([ 48, 57, 61 ],masses2_46,RedSet_4(146),ScalarBoxes(209))
  call compute_scalar_box([ 48, 49, 61 ],masses2_52,RedSet_4(143),ScalarBoxes(210))
  call compute_scalar_box([ 48, 49, 57 ],masses2_50,RedSet_4(147),ScalarBoxes(211))
  call compute_scalar_box([ 49, 57, 61 ],masses2_68,RedSet_4(145),ScalarBoxes(212))
  call compute_scalar_box([ 48, 57, 61 ],masses2_48,RedSet_4(146),ScalarBoxes(213))
  call compute_scalar_box([ 48, 49, 57 ],masses2_54,RedSet_4(147),ScalarBoxes(214))
! end of process

! end do

end subroutine vamp_1

end module ol_vamp_1_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND
