
module ol_vamp_1_ppllll_ew_nenenexnexuux_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_ew_nenenexnexuux_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_ew_nenenexnexuux_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_ew_nenenexnexuux_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_ew_nenenexnexuux_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllll_ew_nenenexnexuux_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_nenenexnexuux_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZu,m3h2x32(:,1),heltab2x64(:,:,1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZu,m3h2x32(:,2),heltab2x64(:,:,2))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,1,2,4,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZu,m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,2,1,8,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZu,m3h2x32(:,4),heltab2x64(:,:,4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,1,4,2,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(5),ngZu,m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,4,1,8,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZu,m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,2,4,1,8,16],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,1,8,2,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZu,m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,2,8,1,4,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(9),ngZu,m3h2x32(:,9),heltab2x64(:,:,9))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,2,8,1,4,16],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,8,2,4,1,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(11),ngZu,m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,8,4,1,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(12),ngZu,m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,1,4,2,8,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZu,m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,1,4,2,8,16],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,1,4,8,2,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZu,m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,2,8,1,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(16),ngZu,m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,2,4,8,1,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(17),ngZu,m3h2x32(:,17),heltab2x64(:,:,17))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,1,8,2,4,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZu,m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,8,2,4,16],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,8,4,2,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(20),ngZu,m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),ngZn,m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(1),n2h16(1))
  call Hloop_ZA_Q(ntryL,G0H32(2),ex3(:),G0H16(1),ngZn,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(2),n2h16(2))
  call Hloop_ZA_Q(ntryL,G0H32(3),ex4(:),G0H16(1),ngZn,m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(3),n2h16(3))
  call Hloop_ZA_Q(ntryL,G0H32(4),ex3(:),G0H16(1),ngZn,m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(4),n2h16(4))
  call Hloop_ZA_Q(ntryL,G0H32(5),ex4(:),G0H16(1),ngZn,m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(5),n2h16(5))
  call Hloop_ZQ_A(ntryL,G0H32(6),ex2(:),G0H16(1),ngZn,m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(6),n2h16(6))
  call Hloop_WQ_A(ntryL,G0H32(7),ex2(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(7),n2h16(7))
  call Hloop_ZA_Q(ntryL,G0H32(8),ex3(:),G0H16(1),ngZn,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(8),n2h16(8))
  call Hloop_ZQ_A(ntryL,G0H32(9),ex2(:),G0H16(1),ngZn,m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(9),n2h16(9))
  call Hloop_WQ_A(ntryL,G0H32(10),ex2(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(10),n2h16(10))
  call Hloop_ZA_Q(ntryL,G0H32(11),ex4(:),G0H16(1),ngZn,m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(11),n2h16(11))
  call Hloop_ZQ_A(ntryL,G0H32(12),ex2(:),G0H16(1),ngZn,m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(12),n2h16(12))
  call Hloop_ZQ_A(ntryL,G0H32(13),ex1(:),G0H16(1),ngZn,m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(13),n2h16(13))
  call Hloop_WQ_A(ntryL,G0H32(14),ex1(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(14),n2h16(14))
  call Hloop_ZQ_A(ntryL,G0H32(15),ex1(:),G0H16(1),ngZn,m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(15),n2h16(15))
  call Hloop_ZA_Q(ntryL,G0H32(16),ex3(:),G0H16(1),ngZn,m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(16),n2h16(16))
  call Hloop_ZQ_A(ntryL,G0H32(17),ex2(:),G0H16(1),ngZn,m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(17),n2h16(17))
  call Hloop_ZQ_A(ntryL,G0H32(18),ex1(:),G0H16(1),ngZn,m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(18),n2h16(18))
  call Hloop_WQ_A(ntryL,G0H32(19),ex1(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(19),n2h16(19))
  call Hloop_ZQ_A(ntryL,G0H32(20),ex1(:),G0H16(1),ngZn,m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(20),n2h16(20))
  call Hloop_AQ_Z(ntryL,G1H16(1),ex2(:),G1H8(1),ngZn,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H16(2),ex1(:),G1H8(2),ngZn,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex1(:),G1H8(3),ngZn,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex2(:),G1H8(4),ngZn,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_Z(ntryL,G1H16(5),ex1(:),G1H8(5),ngZn,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_QA_Z(ntryL,G1H16(6),ex3(:),G1H8(6),ngZn,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_W(ntryL,G1H16(7),ex3(:),G1H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H16(8),ex1(:),G1H8(8),ngZn,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_QA_Z(ntryL,G1H16(9),ex4(:),G1H8(9),ngZn,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_QA_W(ntryL,G1H16(10),ex4(:),G1H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_Z(ntryL,G1H16(11),ex2(:),G1H8(11),ngZn,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_QA_Z(ntryL,G1H16(12),ex4(:),G1H8(12),ngZn,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_QA_Z(ntryL,G1H16(13),ex3(:),G1H8(13),ngZn,m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_QA_W(ntryL,G1H16(14),ex3(:),G1H8(14),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_QA_Z(ntryL,G1H16(15),ex3(:),G1H8(15),ngZn,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H16(16),ex2(:),G1H8(16),ngZn,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_QA_Z(ntryL,G1H16(17),ex3(:),G1H8(17),ngZn,m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_QA_Z(ntryL,G1H16(18),ex4(:),G1H8(18),ngZn,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_QA_W(ntryL,G1H16(19),ex4(:),G1H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_QA_Z(ntryL,G1H16(20),ex4(:),G1H8(20),ngZn,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(1),n2h4(1))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex2(:),G1H4(1),ngZn,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(2),n2h4(2))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex2(:),G1H4(1),ngZn,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(3),n2h4(3))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngZn,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(4),n2h4(4))
  call Hloop_ZA_Q(ntryL,G1H8(5),ex3(:),G1H4(1),ngZn,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(5),n2h4(5))
  call Hloop_ZQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngZn,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(6),n2h4(6))
  call Hloop_WQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(7),n2h4(7))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex4(:),G1H4(1),ngZn,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(8),n2h4(8))
  call Hloop_ZQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),ngZn,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(9),n2h4(9))
  call Hloop_WQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(10),n2h4(10))
  call Hloop_ZA_Q(ntryL,G1H8(11),ex3(:),G1H4(1),ngZn,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(11),n2h4(11))
  call Hloop_ZA_Q(ntryL,G1H8(12),ex3(:),G1H4(1),ngZn,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(12),n2h4(12))
  call Hloop_ZQ_A(ntryL,G1H8(13),ex2(:),G1H4(1),ngZn,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(13),n2h4(13))
  call Hloop_WQ_A(ntryL,G1H8(14),ex2(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(14),n2h4(14))
  call Hloop_ZA_Q(ntryL,G1H8(15),ex4(:),G1H4(1),ngZn,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(15),n2h4(15))
  call Hloop_ZA_Q(ntryL,G1H8(16),ex4(:),G1H4(1),ngZn,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(16),n2h4(16))
  call Hloop_ZA_Q(ntryL,G1H8(17),ex4(:),G1H4(1),ngZn,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(17),n2h4(17))
  call Hloop_ZQ_A(ntryL,G1H8(18),ex2(:),G1H4(1),ngZn,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(18),n2h4(18))
  call Hloop_WQ_A(ntryL,G1H8(19),ex2(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(19),n2h4(19))
  call Hloop_ZA_Q(ntryL,G1H8(20),ex3(:),G1H4(1),ngZn,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(20),n2h4(20))
  call Hloop_QA_Z(ntryL,G2H4(1),ex3(:),G2H2(1),ngZn,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_Z(ntryL,G2H4(2),ex4(:),G2H2(2),ngZn,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_Z(ntryL,G2H4(3),ex3(:),G2H2(3),ngZn,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_Z(ntryL,G2H4(4),ex4(:),G2H2(4),ngZn,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_Z(ntryL,G2H4(5),ex2(:),G2H2(5),ngZn,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_Z(ntryL,G2H4(6),ex4(:),G2H2(6),ngZn,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_W(ntryL,G2H4(7),ex4(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_Z(ntryL,G2H4(8),ex2(:),G2H2(8),ngZn,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_Z(ntryL,G2H4(9),ex3(:),G2H2(9),ngZn,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_W(ntryL,G2H4(10),ex3(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_Z(ntryL,G2H4(11),ex1(:),G2H2(11),ngZn,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_Z(ntryL,G2H4(12),ex1(:),G2H2(12),ngZn,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_Z(ntryL,G2H4(13),ex4(:),G2H2(13),ngZn,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_W(ntryL,G2H4(14),ex4(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_Z(ntryL,G2H4(15),ex2(:),G2H2(15),ngZn,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_Z(ntryL,G2H4(16),ex1(:),G2H2(16),ngZn,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_Z(ntryL,G2H4(17),ex1(:),G2H2(17),ngZn,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_Z(ntryL,G2H4(18),ex3(:),G2H2(18),ngZn,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_W(ntryL,G2H4(19),ex3(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_Z(ntryL,G2H4(20),ex2(:),G2H2(20),ngZn,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(2),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(3),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(4),mass5set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(5),mass5set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(6),mass5set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(6),mass5set(:,2),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(7),mass5set(:,1),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(8),mass5set(:,1),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(8),mass5set(:,2),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(9),mass5set(:,1),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(10),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(11),mass5set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(11),mass5set(:,2),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(12),mass5set(:,1),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),16,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(13),mass5set(:,1),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),16,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(14),mass5set(:,1),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(15),mass5set(:,1),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),16,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(15),mass5set(:,2),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(16),mass5set(:,1),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),ngZu,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),ngZu,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(2),n2h1(2))
  call Hloop_ZQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),ngZu,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(3))
  call Hloop_ZQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),ngZu,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(4),n2h1(4))
  call Hloop_ZQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),ngZu,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),ngZu,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(6),n2h1(6))
  call Hloop_ZQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),ngZu,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(7))
  call Hloop_ZQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),ngZu,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(8),n2h1(8))
  call Hloop_ZQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),ngZu,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(9))
  call Hloop_ZQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),ngZu,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(10))
  call Hloop_ZQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),ngZu,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(11))
  call Hloop_ZQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),ngZu,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(12),n2h1(12))
  call Hloop_WQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_WQ_A(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(14),n2h1(14))
  call Hloop_ZQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),ngZu,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(15))
  call Hloop_ZQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),ngZu,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(16),n2h1(16))
  call Hloop_ZQ_A(ntryL,G1H2(49),ex5(:),G1H1(1),ngZu,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(17))
  call Hloop_ZQ_A(ntryL,G1H2(50),ex5(:),G1H1(1),ngZu,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(18),n2h1(18))
  call Hloop_WQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(19))
  call Hloop_WQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(20),n2h1(20))
  call Hloop_ZQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),ngZu,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(21))
  call Hloop_ZQ_A(ntryL,G1H2(62),ex5(:),G1H1(1),ngZu,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(22))
  call Hloop_ZQ_A(ntryL,G1H2(67),ex5(:),G1H1(1),ngZu,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(23))
  call Hloop_ZQ_A(ntryL,G1H2(68),ex5(:),G1H1(1),ngZu,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(24))
  call Hloop_ZQ_A(ntryL,G1H2(73),ex5(:),G1H1(1),ngZu,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(25))
  call Hloop_ZQ_A(ntryL,G1H2(74),ex5(:),G1H1(1),ngZu,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(26))
  call Hloop_WQ_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(27))
  call Hloop_WQ_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(28))
  call Hloop_ZQ_A(ntryL,G1H2(85),ex5(:),G1H1(1),ngZu,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(29))
  call Hloop_ZQ_A(ntryL,G1H2(86),ex5(:),G1H1(1),ngZu,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(30))
  call Hloop_ZQ_A(ntryL,G1H2(91),ex5(:),G1H1(1),ngZu,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(31))
  call Hloop_ZQ_A(ntryL,G1H2(92),ex5(:),G1H1(1),ngZu,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(32),n2h1(32))
  call Hloop_ZQ_A(ntryL,G1H2(97),ex5(:),G1H1(1),ngZu,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(33))
  call Hloop_ZQ_A(ntryL,G1H2(98),ex5(:),G1H1(1),ngZu,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(34),n2h1(34))
  call Hloop_ZQ_A(ntryL,G1H2(103),ex5(:),G1H1(1),ngZu,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(35))
  call Hloop_ZQ_A(ntryL,G1H2(104),ex5(:),G1H1(1),ngZu,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(36),n2h1(36))
  call Hloop_WQ_A(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(37))
  call Hloop_WQ_A(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(38),n2h1(38))
  call Hloop_ZQ_A(ntryL,G1H2(115),ex5(:),G1H1(1),ngZu,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(39))
  call Hloop_ZQ_A(ntryL,G1H2(116),ex5(:),G1H1(1),ngZu,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(40),n2h1(40))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(5),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(6),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(7),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(8),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(8),mass5set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(9),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(10),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(11),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(11),mass5set(:,2),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(12),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(13),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(14),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(15),mass5set(:,1),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(15),mass5set(:,2),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(16),mass5set(:,1),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,5,16,2,8],[0,0,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZu,m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,2,8,16,5],[nMZ,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZu,m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,2,8,16,5],[nMW,0,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,2,8,5,16],[nMW,0,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,5,2,8,16],[nMW,nMW,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,8,5,2,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZu,m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,2,5,8,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZu,m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,2,5,8,16],[nMW,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,6,16,1,8],[0,0,nMZ,0,nMZ],5,1,wf4(:,5))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZu,m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,1,8,16,6],[nMZ,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(10),ngZu,m3h2x32(:,30),heltab2x64(:,:,30))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,1,8,16,6],[nMW,0,nMW,0,0],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,1,8,6,16],[nMW,0,nMW,nMW,0],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,6,1,8,16],[nMW,nMW,0,nMW,0],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,33),heltab2x64(:,:,33))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,8,6,1,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(14),ngZu,m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,6,8,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZu,m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,6,8,16],[nMW,0,0,nMW,0],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,4,2,16,9],[nMZ,0,nMZ,0,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(17),ngZu,m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,2,4,16,9],[nMZ,0,nMZ,0,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZu,m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,2,4,16,9],[nMW,0,nMW,0,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,2,4,9,16],[nMW,0,nMW,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,9,2,4,16],[nMW,nMW,0,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,4,9,2,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(9),ngZu,m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,2,9,4,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(21),ngZu,m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,2,9,4,16],[nMW,0,0,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,44),heltab2x64(:,:,44))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,4,1,16,10],[nMZ,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(23),ngZu,m3h2x32(:,45),heltab2x64(:,:,45))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,1,4,16,10],[nMZ,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(24),ngZu,m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,1,4,16,10],[nMW,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,47),heltab2x64(:,:,47))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,1,4,10,16],[nMW,0,nMW,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,48),heltab2x64(:,:,48))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,10,1,4,16],[nMW,nMW,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,49),heltab2x64(:,:,49))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,4,10,1,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(28),ngZu,m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,1,10,4,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(29),ngZu,m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,1,10,4,16],[nMW,0,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[48,2,1,4,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,1),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(1),n2h16(21))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[48,2,1,8,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,2),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(2),n2h16(22))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[48,1,2,4,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,3),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(3),n2h16(23))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[48,1,2,8,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,4),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(4),n2h16(24))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[48,2,4,1,8],[0,nMW,0,nMW,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(1),m3h4x16(:,5),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(5),n2h16(25))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[48,2,4,1,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,6),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(6),n2h16(26))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[48,2,4,1,8],[0,nMW,0,nMW,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZl,m3h4x16(:,7),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(7),n2h16(27))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[48,2,4,1,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(8),m3h4x16(:,8),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[48,2,4,1,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(9),m3h4x16(:,9),heltab2x64(:,:,61))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[48,2,8,1,4],[0,nMW,0,nMW,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(1),m3h4x16(:,10),heltab2x64(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(10),n2h16(28))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[48,2,8,1,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,11),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(11),n2h16(29))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[48,2,8,1,4],[0,nMW,0,nMW,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZl,m3h4x16(:,12),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(12),n2h16(30))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[48,2,8,1,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(13),m3h4x16(:,13),heltab2x64(:,:,65))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[48,2,8,1,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(14),m3h4x16(:,14),heltab2x64(:,:,66))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[48,1,4,2,8],[0,nMW,0,nMW,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(1),m3h4x16(:,15),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(15),n2h16(31))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[48,1,4,2,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,16),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(16),n2h16(32))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[48,1,4,2,8],[0,nMW,0,nMW,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZl,m3h4x16(:,17),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(17),n2h16(33))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[48,1,4,2,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(18),m3h4x16(:,18),heltab2x64(:,:,70))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[48,1,4,2,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(19),m3h4x16(:,19),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[48,1,8,2,4],[0,nMW,0,nMW,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(1),m3h4x16(:,20),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(20),n2h16(34))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[48,1,8,2,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,21),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(21),n2h16(35))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[48,1,8,2,4],[0,nMW,0,nMW,0],5,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZl,m3h4x16(:,22),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(22),n2h16(36))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[48,1,8,2,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(23),m3h4x16(:,23),heltab2x64(:,:,75))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[48,1,8,2,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(24),m3h4x16(:,24),heltab2x64(:,:,76))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(17),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(22),[G1H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(23)])
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,1),G1H8(1),ngZu,m3h4x8(:,1),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(1),n2h8(1))
  call Hloop_ZQ_A(ntryL,G0H32(2),ex2(:),G0H16(1),ngZn,m3h2x16(:,21),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(5),n2h16(37))
  call Hloop_WQ_A(ntryL,G0H32(3),ex2(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(8),n2h16(38))
  call Hloop_WQ_A(ntryL,G0H32(4),ex2(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(10),n2h16(39))
  call Hloop_UV_W(ntryL,G0H32(5),32,wf4(:,1),5,G1H8(2),m3h4x8(:,2),heltab2x32(:,:,25))
  call Hloop_ZA_Q(ntryL,G0H32(6),ex4(:),G0H16(1),ngZn,m3h2x16(:,24),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(13),n2h16(40))
  call Hloop_ZQ_A(ntryL,G0H32(7),ex2(:),G0H16(1),ngZn,m3h2x16(:,25),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(15),n2h16(41))
  call Hloop_WQ_A(ntryL,G0H32(8),ex2(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(18),n2h16(42))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,5),G1H8(3),ngZu,m3h4x8(:,3),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(2),n2h8(2))
  call Hloop_ZQ_A(ntryL,G0H32(10),ex1(:),G0H16(1),ngZn,m3h2x16(:,27),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(20),n2h16(43))
  call Hloop_WQ_A(ntryL,G0H32(11),ex1(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(23),n2h16(44))
  call Hloop_WQ_A(ntryL,G0H32(12),ex1(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(25),n2h16(45))
  call Hloop_UV_W(ntryL,G0H32(13),32,wf4(:,5),6,G1H8(4),m3h4x8(:,4),heltab2x32(:,:,33))
  call Hloop_ZA_Q(ntryL,G0H32(14),ex4(:),G0H16(1),ngZn,m3h2x16(:,30),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(26),n2h16(46))
  call Hloop_ZQ_A(ntryL,G0H32(15),ex1(:),G0H16(1),ngZn,m3h2x16(:,31),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(27),n2h16(47))
  call Hloop_WQ_A(ntryL,G0H32(16),ex1(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(28),n2h16(48))
  call Hloop_ZA_Q(ntryL,G0H32(17),ex3(:),G0H16(1),ngZn,m3h2x16(:,33),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(29),n2h16(49))
  call Hloop_ZQ_A(ntryL,G0H32(18),ex2(:),G0H16(1),ngZn,m3h2x16(:,34),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(30),n2h16(50))
  call Hloop_WQ_A(ntryL,G0H32(19),ex2(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(31),n2h16(51))
  call Hloop_WQ_A(ntryL,G0H32(20),ex2(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(32),n2h16(52))
  call Hloop_UV_W(ntryL,G0H32(1),32,wf4(:,4),9,G1H8(5),m3h4x8(:,5),heltab2x32(:,:,41))
  call Hloop_ZA_Q(ntryL,G0H32(9),ex3(:),G0H16(1),ngZn,m3h2x16(:,37),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(33),n2h16(53))
  call Hloop_ZQ_A(ntryL,G0H32(21),ex2(:),G0H16(1),ngZn,m3h2x16(:,38),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(34),n2h16(54))
  call Hloop_WQ_A(ntryL,G0H32(22),ex2(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(35),n2h16(55))
  call Hloop_ZA_Q(ntryL,G0H32(23),ex3(:),G0H16(1),ngZn,m3h2x16(:,40),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(36),n2h16(56))
  call Hloop_ZQ_A(ntryL,G0H32(24),ex1(:),G0H16(1),ngZn,m3h2x16(:,41),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(37),n2h16(57))
  call Hloop_WQ_A(ntryL,G0H32(25),ex1(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(38),n2h16(58))
  call Hloop_WQ_A(ntryL,G0H32(26),ex1(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(39),n2h16(59))
  call Hloop_UV_W(ntryL,G0H32(27),32,wf4(:,2),10,G1H8(6),m3h4x8(:,6),heltab2x32(:,:,49))
  call Hloop_ZA_Q(ntryL,G0H32(28),ex3(:),G0H16(1),ngZn,m3h2x16(:,44),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(40),n2h16(60))
  call Hloop_ZQ_A(ntryL,G0H32(29),ex1(:),G0H16(1),ngZn,m3h2x16(:,45),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(41),n2h16(61))
  call Hloop_WQ_A(ntryL,G0H32(30),ex1(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(42),n2h16(62))
  call Hloop_AQ_Z(ntryL,G1H16(1),ex2(:),G1H8(7),ngZn,m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_AQ_Z(ntryL,G1H16(2),ex2(:),G1H8(8),ngZn,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex1(:),G1H8(9),ngZn,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex1(:),G1H8(10),ngZn,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AQ_W(ntryL,G1H16(7),ex2(:),G1H8(11),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AQ_Z(ntryL,G1H16(6),ex2(:),G1H8(12),ngZn,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_WQ_A(ntryL,G1H16(9),ex2(:),G1H8(13),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(13),50,0,G2H8(3),n2h8(3))
  call Hloop_AQ_W(ntryL,G1H16(12),ex2(:),G1H8(14),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_AQ_Z(ntryL,G1H16(11),ex2(:),G1H8(15),ngZn,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_WQ_A(ntryL,G1H16(14),ex2(:),G1H8(16),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(16),50,0,G2H8(4),n2h8(4))
  call Hloop_AQ_W(ntryL,G1H16(17),ex1(:),G1H8(17),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H16(16),ex1(:),G1H8(18),ngZn,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_WQ_A(ntryL,G1H16(19),ex1(:),G1H8(19),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(19),49,0,G2H8(5),n2h8(5))
  call Hloop_AQ_W(ntryL,G1H16(22),ex1(:),G1H8(20),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H16(21),ex1(:),G1H8(1),ngZn,m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_WQ_A(ntryL,G1H16(24),ex1(:),G1H8(3),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(3),49,0,G2H8(6),n2h8(6))
  call Hloop_AQ_Z(ntryL,G2H8(1),ex5(:),G2H4(1),ngZu,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_Z(ntryL,G1H16(5),ex4(:),G1H8(13),ngZn,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_QA_W(ntryL,G1H16(8),ex4(:),G1H8(16),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_QA_W(ntryL,G1H16(10),ex4(:),G1H8(19),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_WQ_A(ntryL,G1H8(2),ex2(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(2),n2h4(21))
  call Hloop_AZ_Q(ntryL,G1H16(13),wf4(:,1),G1H4(1),ngZn,m3h4x4(:,1),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(3),n2h4(22))
  call Hloop_QZ_A(ntryL,G1H16(15),wf4(:,1),G1H4(1),ngZn,m3h4x4(:,2),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(4),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,1),G1H4(1),ngZl,m3h4x4(:,3),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(5),n2h4(24))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex5(:),G2H4(6),ngZu,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_Z(ntryL,G1H16(20),ex4(:),G1H8(3),ngZn,m3h2x8(:,40),heltab2x16(:,:,43))
  call Hloop_QA_W(ntryL,G1H16(23),ex4(:),G1H8(2),m3h2x8(:,41),heltab2x16(:,:,44))
  call Hloop_QA_W(ntryL,G1H16(25),ex4(:),G1H8(21),m3h2x8(:,42),heltab2x16(:,:,45))
  call Hloop_WQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(7),n2h4(25))
  call Hloop_AZ_Q(ntryL,G1H16(26),wf4(:,5),G1H4(1),ngZn,m3h4x4(:,4),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(8),n2h4(26))
  call Hloop_QZ_A(ntryL,G1H16(27),wf4(:,5),G1H4(1),ngZn,m3h4x4(:,5),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(9),n2h4(27))
  call Hloop_QZ_A(ntryL,G1H16(28),wf4(:,5),G1H4(1),ngZl,m3h4x4(:,6),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(10),n2h4(28))
  call Hloop_AQ_Z(ntryL,G1H16(29),ex2(:),G1H8(4),ngZn,m3h2x8(:,43),heltab2x16(:,:,49))
  call Hloop_QA_Z(ntryL,G1H16(30),ex3(:),G1H8(22),ngZn,m3h2x8(:,44),heltab2x16(:,:,50))
  call Hloop_QA_W(ntryL,G1H16(31),ex3(:),G1H8(23),m3h2x8(:,45),heltab2x16(:,:,51))
  call Hloop_QA_W(ntryL,G1H16(32),ex3(:),G1H8(24),m3h2x8(:,46),heltab2x16(:,:,52))
  call Hloop_WQ_A(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(11),n2h4(29))
  call Hloop_AZ_Q(ntryL,G1H16(33),wf4(:,4),G1H4(1),ngZn,m3h4x4(:,7),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(12),n2h4(30))
  call Hloop_QZ_A(ntryL,G1H16(34),wf4(:,4),G1H4(1),ngZn,m3h4x4(:,8),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(13),n2h4(31))
  call Hloop_QZ_A(ntryL,G1H16(35),wf4(:,4),G1H4(1),ngZl,m3h4x4(:,9),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(14),n2h4(32))
  call Hloop_AQ_Z(ntryL,G1H16(36),ex1(:),G1H8(5),ngZn,m3h2x8(:,47),heltab2x16(:,:,56))
  call Hloop_QA_Z(ntryL,G1H16(37),ex3(:),G1H8(25),ngZn,m3h2x8(:,48),heltab2x16(:,:,57))
  call Hloop_QA_W(ntryL,G1H16(38),ex3(:),G1H8(26),m3h2x8(:,49),heltab2x16(:,:,58))
  call Hloop_QA_W(ntryL,G1H16(39),ex3(:),G1H8(27),m3h2x8(:,50),heltab2x16(:,:,59))
  call Hloop_WQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(15),n2h4(33))
  call Hloop_AZ_Q(ntryL,G1H16(40),wf4(:,2),G1H4(1),ngZn,m3h4x4(:,10),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(16),n2h4(34))
  call Hloop_QZ_A(ntryL,G1H16(41),wf4(:,2),G1H4(1),ngZn,m3h4x4(:,11),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(17),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H16(42),wf4(:,2),G1H4(1),ngZl,m3h4x4(:,12),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(18),n2h4(36))
  call Hloop_ZQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngZn,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(19),n2h4(37))
  call Hloop_ZQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),ngZn,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(20),n2h4(38))
  call Hloop_ZQ_A(ntryL,G1H8(9),ex2(:),G1H4(1),ngZn,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(21),n2h4(39))
  call Hloop_ZQ_A(ntryL,G1H8(10),ex2(:),G1H4(1),ngZn,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(22),n2h4(40))
  call Hloop_WA_Q(ntryL,G1H8(11),ex3(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(23),n2h4(41))
  call Hloop_ZA_Q(ntryL,G1H8(12),ex3(:),G1H4(1),ngZn,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(24),n2h4(42))
  call Hloop_QA_W(ntryL,G2H8(3),ex3(:),G2H4(25),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_WA_Q(ntryL,G1H8(14),ex4(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(26),n2h4(43))
  call Hloop_ZA_Q(ntryL,G1H8(15),ex4(:),G1H4(1),ngZn,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(27),n2h4(44))
  call Hloop_QA_W(ntryL,G2H8(4),ex4(:),G2H4(28),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_WA_Q(ntryL,G1H8(17),ex3(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(29),n2h4(45))
  call Hloop_ZA_Q(ntryL,G1H8(18),ex3(:),G1H4(1),ngZn,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(30),n2h4(46))
  call Hloop_QA_W(ntryL,G2H8(5),ex3(:),G2H4(31),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_WA_Q(ntryL,G1H8(20),ex4(:),G1H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(32),n2h4(47))
  call Hloop_ZA_Q(ntryL,G1H8(1),ex4(:),G1H4(1),ngZn,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(33),n2h4(48))
  call Hloop_QA_W(ntryL,G2H8(6),ex4(:),G2H4(34),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(17),mass5set(:,3),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hloop_ZQ_A(ntryL,G1H8(13),ex5(:),G1H4(7),ngZu,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(7),58,0,G2H4(1),n2h4(49))
  call Hloop_WQ_A(ntryL,G1H8(16),ex5(:),G1H4(7),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(7),58,0,G2H4(35),n2h4(50))
  call Hloop_UV_W(ntryL,G1H8(19),42,wf4(:,1),5,G2H2(1),m3h4x2(:,1),heltab2x8(:,:,45))
  call Hloop_QA_W(ntryL,G2H4(2),ex4(:),G2H2(2),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_Z(ntryL,G2H4(3),ex2(:),G2H2(3),ngZn,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_Z(ntryL,G2H4(4),ex4(:),G2H2(4),ngZn,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_W(ntryL,G2H4(5),ex4(:),G2H2(5),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(18),mass5set(:,3),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hloop_ZQ_A(ntryL,G1H8(3),ex5(:),G1H4(13),ngZu,m3h2x4(:,45),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(13),57,0,G2H4(2),n2h4(51))
  call Hloop_WQ_A(ntryL,G1H8(2),ex5(:),G1H4(13),m3h2x4(:,46),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(13),57,0,G2H4(3),n2h4(52))
  call Hloop_UV_W(ntryL,G1H8(21),41,wf4(:,5),6,G2H2(6),m3h4x2(:,2),heltab2x8(:,:,48))
  call Hloop_QA_W(ntryL,G2H4(7),ex4(:),G2H2(7),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_Z(ntryL,G2H4(8),ex1(:),G2H2(8),ngZn,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_Z(ntryL,G2H4(9),ex4(:),G2H2(9),ngZn,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_W(ntryL,G2H4(10),ex4(:),G2H2(10),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex5(:),G1H4(13),ngZu,m3h2x4(:,47),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(13),54,0,G2H4(4),n2h4(53))
  call Hloop_ZQ_A(ntryL,G1H8(22),ex5(:),G1H4(13),ngZu,m3h2x4(:,48),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(13),54,0,G2H4(5),n2h4(54))
  call Hloop_WQ_A(ntryL,G1H8(23),ex5(:),G1H4(13),m3h2x4(:,49),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(13),54,0,G2H4(6),n2h4(55))
  call Hloop_UV_W(ntryL,G1H8(24),38,wf4(:,4),9,G2H2(11),m3h4x2(:,3),heltab2x8(:,:,52))
  call Hloop_QA_W(ntryL,G2H4(11),ex3(:),G2H2(12),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_AQ_Z(ntryL,G2H4(12),ex2(:),G2H2(13),ngZn,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_Z(ntryL,G2H4(13),ex3(:),G2H2(14),ngZn,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_W(ntryL,G2H4(14),ex3(:),G2H2(15),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_ZQ_A(ntryL,G1H8(5),ex5(:),G1H4(13),ngZu,m3h2x4(:,50),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(7),n2h4(56))
  call Hloop_ZQ_A(ntryL,G1H8(25),ex5(:),G1H4(13),ngZu,m3h2x4(:,51),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(8),n2h4(57))
  call Hloop_WQ_A(ntryL,G1H8(26),ex5(:),G1H4(13),m3h2x4(:,52),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(9),n2h4(58))
  call Hloop_UV_W(ntryL,G1H8(27),37,wf4(:,2),10,G2H2(16),m3h4x2(:,4),heltab2x8(:,:,56))
  call Hloop_QA_W(ntryL,G2H4(15),ex3(:),G2H2(17),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_Z(ntryL,G2H4(16),ex1(:),G2H2(18),ngZn,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QA_Z(ntryL,G2H4(17),ex3(:),G2H2(19),ngZn,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_W(ntryL,G2H4(18),ex3(:),G2H2(20),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QA_Z(ntryL,G2H4(19),ex3(:),G2H2(21),ngZn,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_Z(ntryL,G2H4(20),ex4(:),G2H2(22),ngZn,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QA_Z(ntryL,G2H4(21),ex3(:),G2H2(23),ngZn,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QA_Z(ntryL,G2H4(22),ex4(:),G2H2(24),ngZn,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_AQ_W(ntryL,G2H4(23),ex1(:),G2H2(25),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_Z(ntryL,G2H4(24),ex1(:),G2H2(26),ngZn,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(19),mass5set(:,4),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hloop_AQ_W(ntryL,G2H4(26),ex1(:),G2H2(27),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_Z(ntryL,G2H4(27),ex1(:),G2H2(28),ngZn,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(20),mass5set(:,4),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),4,4)
  call Hloop_AQ_W(ntryL,G2H4(29),ex2(:),G2H2(29),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_Z(ntryL,G2H4(30),ex2(:),G2H2(30),ngZn,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(21),mass5set(:,4),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hloop_AQ_W(ntryL,G2H4(32),ex2(:),G2H2(31),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AQ_Z(ntryL,G2H4(33),ex2(:),G2H2(32),ngZn,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(22),mass5set(:,4),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),4,4)
  call Hloop_ZQ_A(ntryL,G1H4(1),ex2(:),G1H2(1),ngZn,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(33),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(2),ex4(:),G1H2(2),ngZn,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_ZQ_A(ntryL,G1H4(5),ex2(:),G1H2(7),ngZn,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(7),55,0,G2H2(34),n2h2(2))
  call Hloop_ZQ_A(ntryL,G1H4(6),ex2(:),G1H2(8),ngZn,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(8),55,0,G2H2(35),n2h2(3))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex1(:),G1H2(13),ngZn,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(13),55,0,G2H2(36),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(8),ex4(:),G1H2(14),ngZn,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_ZQ_A(ntryL,G1H4(11),ex1(:),G1H2(19),ngZn,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(37),n2h2(5))
  call Hloop_ZQ_A(ntryL,G1H4(12),ex1(:),G1H2(20),ngZn,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(20),55,0,G2H2(38),n2h2(6))
  call Hloop_WQ_A(ntryL,G1H4(13),ex1(:),G1H2(25),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(25),55,0,G2H2(39),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(14),ex4(:),G1H2(26),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_WQ_A(ntryL,G1H4(17),ex1(:),G1H2(31),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(31),55,0,G2H2(40),n2h2(8))
  call Hloop_WQ_A(ntryL,G1H4(18),ex1(:),G1H2(32),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(32),55,0,G2H2(41),n2h2(9))
  call Hloop_WQ_A(ntryL,G1H4(19),ex1(:),G1H2(37),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(37),59,0,G2H2(42),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(20),ex3(:),G1H2(38),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_WQ_A(ntryL,G1H4(23),ex1(:),G1H2(43),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(43),59,0,G2H2(43),n2h2(11))
  call Hloop_WQ_A(ntryL,G1H4(24),ex1(:),G1H2(44),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(44),59,0,G2H2(44),n2h2(12))
  call Hloop_WQ_A(ntryL,G1H4(25),ex2(:),G1H2(49),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(49),55,0,G2H2(45),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(26),ex4(:),G1H2(50),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_WQ_A(ntryL,G1H4(29),ex2(:),G1H2(55),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(55),55,0,G2H2(46),n2h2(14))
  call Hloop_WQ_A(ntryL,G1H4(30),ex2(:),G1H2(56),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(56),55,0,G2H2(47),n2h2(15))
  call Hloop_WQ_A(ntryL,G1H4(31),ex2(:),G1H2(61),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(61),59,0,G2H2(48),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(32),ex3(:),G1H2(62),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_WQ_A(ntryL,G1H4(35),ex2(:),G1H2(67),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(67),59,0,G2H2(49),n2h2(17))
  call Hloop_WQ_A(ntryL,G1H4(36),ex2(:),G1H2(68),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(68),59,0,G2H2(50),n2h2(18))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(52),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(76),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(34),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(96),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(118),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(88),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(70),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(101),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(119),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(100),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(120),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(114)])
  call Hloop_ZQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),ngZu,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(41))
  call Hloop_ZQ_A(ntryL,G1H2(52),ex5(:),G1H1(1),ngZu,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(42))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),ngZu,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(43))
  call Hloop_ZQ_A(ntryL,G1H2(66),ex5(:),G1H1(1),ngZu,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(44))
  call Hloop_ZQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),ngZu,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(45))
  call Hloop_ZQ_A(ntryL,G1H2(76),ex5(:),G1H1(1),ngZu,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(46))
  call Hloop_ZQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),ngZu,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(47))
  call Hloop_ZQ_A(ntryL,G1H2(48),ex5(:),G1H1(1),ngZu,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(48))
  call Hloop_ZQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),ngZu,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(49))
  call Hloop_ZQ_A(ntryL,G1H2(106),ex5(:),G1H1(1),ngZu,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(50))
  call Hloop_ZQ_A(ntryL,G1H2(30),ex5(:),G1H1(1),ngZu,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(51))
  call Hloop_ZQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),ngZu,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(52))
  call Hloop_ZQ_A(ntryL,G1H2(34),ex5(:),G1H1(1),ngZu,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(53))
  call Hloop_ZQ_A(ntryL,G1H2(96),ex5(:),G1H1(1),ngZu,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(54))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),ngZu,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(55))
  call Hloop_ZQ_A(ntryL,G1H2(118),ex5(:),G1H1(1),ngZu,m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(56))
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(23),mass5set(:,5),  & 
G1H2(73),G1H2(74),G1H2(79),G1H2(80),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),ngZu,m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(57))
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(24),mass5set(:,5),  & 
G1H2(91),G1H2(92),G1H2(97),G1H2(98),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(92),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(102),ex5(:),G1H1(1),ngZu,m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(58))
  call Hloop_WQ_A(ntryL,G1H2(39),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(59))
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(25),mass5set(:,6),  & 
G1H2(109),G1H2(110),G1H2(115),G1H2(116),G1H2(1),G1H2(7),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(24),mass5set(:,7),  & 
G1H2(8),G1H2(13),G1H2(19),G1H2(20),G1H2(25),G1H2(31),2)
  call HG1shiftOLR(G1H2(13),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(26),mass5set(:,8),  & 
G1H2(32),G1H2(37),G1H2(43),G1H2(44),G1H2(49),G1H2(55),2)
  call HG1shiftOLR(G1H2(37),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),ngZu,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(60))
  call Hloop_ZQ_A(ntryL,G1H2(88),ex5(:),G1H1(1),ngZu,m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(61))
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(27),mass5set(:,5),  & 
G1H2(56),G1H2(61),G1H2(67),G1H2(68),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(61),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),ngZu,m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(62))
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(28),mass5set(:,5),  & 
G1H2(6),G1H2(10),G1H2(11),G1H2(12),G1H2(16),G1H2(18),2)
  call HG1shiftOLR(G1H2(10),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(72),ex5(:),G1H1(1),ngZu,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(63))
  call Hloop_WQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(44),n2h1(64))
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(29),mass5set(:,6),  & 
G1H2(22),G1H2(24),G1H2(28),G1H2(29),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(24),16,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(28),mass5set(:,7),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(46),G1H2(47),G1H2(53),2)
  call HG1shiftOLR(G1H2(41),16,2)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(30),mass5set(:,8),  & 
G1H2(54),G1H2(58),G1H2(59),G1H2(60),G1H2(64),G1H2(65),2)
  call HG1shiftOLR(G1H2(58),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),ngZu,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(65))
  call Hloop_ZQ_A(ntryL,G1H2(70),ex5(:),G1H1(1),ngZu,m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(46),n2h1(66))
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(31),mass5set(:,5),  & 
G1H2(71),G1H2(77),G1H2(78),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(77),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(69),ex5(:),G1H1(1),ngZu,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(67))
  call Hloop_ZQ_A(ntryL,G1H2(101),ex5(:),G1H1(1),ngZu,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(68))
  call Hloop_ZQ_A(ntryL,G1H2(75),ex5(:),G1H1(1),ngZu,m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(69))
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(32),mass5set(:,5),  & 
G1H2(89),G1H2(94),G1H2(95),G1H2(107),G1H2(108),G1H2(112),2)
  call HG1shiftOLR(G1H2(94),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(90),ex5(:),G1H1(1),ngZu,m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(50),n2h1(70))
  call Hloop_WQ_A(ntryL,G1H2(81),ex5(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(71))
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(33),mass5set(:,6),  & 
G1H2(113),G1H2(114),G1H2(3),G1H2(52),G1H2(17),G1H2(66),2)
  call HG1shiftOLR(G1H2(114),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(32),mass5set(:,7),  & 
G1H2(9),G1H2(76),G1H2(23),G1H2(48),G1H2(15),G1H2(106),2)
  call HG1shiftOLR(G1H2(76),16,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(34),mass5set(:,8),  & 
G1H2(30),G1H2(21),G1H2(34),G1H2(96),G1H2(27),G1H2(118),2)
  call HG1shiftOLR(G1H2(21),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(87),ex5(:),G1H1(1),ngZu,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(72))
  call Hloop_ZQ_A(ntryL,G1H2(119),ex5(:),G1H1(1),ngZu,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(73))
  call Hloop_ZQ_A(ntryL,G1H2(93),ex5(:),G1H1(1),ngZu,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(74))
  call Hloop_ZQ_A(ntryL,G1H2(100),ex5(:),G1H1(1),ngZu,m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(75))
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(35),mass5set(:,5),  & 
G1H2(33),G1H2(102),G1H2(39),G1H2(45),G1H2(88),G1H2(51),2)
  call HG1shiftOLR(G1H2(102),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(99),ex5(:),G1H1(1),ngZu,m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(56),n2h1(76))
  call Hloop_ZQ_A(ntryL,G1H2(105),ex5(:),G1H1(1),ngZu,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(77))
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(36),mass5set(:,5),  & 
G1H2(72),G1H2(57),G1H2(63),G1H2(70),G1H2(69),G1H2(101),2)
  call HG1shiftOLR(G1H2(57),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(120),ex5(:),G1H1(1),ngZu,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(78))
  call Hloop_WQ_A(ntryL,G1H2(111),ex5(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(79))
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(37),mass5set(:,6),  & 
G1H2(75),G1H2(90),G1H2(81),G1H2(87),G1H2(119),G1H2(93),2)
  call HG1shiftOLR(G1H2(90),16,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(36),mass5set(:,7),  & 
G1H2(100),G1H2(99),G1H2(105),G1H2(120),G1H2(111),G1H2(121),2)
  call HG1shiftOLR(G1H2(99),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(38),mass5set(:,8),  & 
G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),2)
  call HG1shiftOLR(G1H2(123),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(117),ex5(:),G1H1(1),ngZu,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(80))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(39),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(2),5,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(39),mass5set(:,2),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(12),5,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(40),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(20),6,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(40),mass5set(:,2),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(30),6,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(41),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),9,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(42),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),9,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(42),mass5set(:,2),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),9,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(43),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),10,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(44),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),10,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(44),mass5set(:,2),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),10,4)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(45),mass5set(:,9),  & 
G1H2(117),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),8,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(46),mass5set(:,9),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),4,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(47),mass5set(:,9),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),8,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(48),mass5set(:,9),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),4,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(19),mass5set(:,10),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),8,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(19),mass5set(:,9),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),8,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(20),mass5set(:,10),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),4,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(20),mass5set(:,9),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),4,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(21),mass5set(:,10),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),8,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(21),mass5set(:,9),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(22),mass5set(:,10),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),4,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(22),mass5set(:,9),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),4,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(33),ex4(:),G2tensor(61),ngZn,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(62),ngZn,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(63),ngZn,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(64),ngZn,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(65),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(41),ex4(:),G2tensor(66),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(42),ex3(:),G2tensor(67),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(44),ex3(:),G2tensor(68),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(45),ex4(:),G2tensor(69),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(47),ex4(:),G2tensor(70),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(71),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(50),ex3(:),G2tensor(72),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hloop_ZQ_A(ntryL,G1H2(73),ex5(:),G1H1(1),ngZu,m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(81))
  call Hloop_ZQ_A(ntryL,G1H2(74),ex5(:),G1H1(1),ngZu,m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(74),n2h1(82))
  call Hloop_ZQ_A(ntryL,G1H2(86),ex5(:),G1H1(1),ngZu,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(83))
  call Hloop_ZQ_A(ntryL,G1H2(91),ex5(:),G1H1(1),ngZu,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(84))
  call Hloop_ZQ_A(ntryL,G1H2(92),ex5(:),G1H1(1),ngZu,m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(77),n2h1(85))
  call Hloop_ZQ_A(ntryL,G1H2(104),ex5(:),G1H1(1),ngZu,m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(86))
  call Hloop_WQ_A(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(87))
  call Hloop_WQ_A(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(80),n2h1(88))
  call Hloop_WQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(89))
  call Hloop_WQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(82),n2h1(90))
  call Hloop_WQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(83),n2h1(91))
  call Hloop_WQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(92))
  call Hloop_WQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(93))
  call Hloop_WQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(86),n2h1(94))
  call Hloop_WQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(95))
  call Hloop_ZQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),ngZu,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(88),n2h1(96))
  call Hloop_ZQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),ngZu,m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(89),n2h1(97))
  call Hloop_ZQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),ngZu,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(98))
  call Hloop_ZQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),ngZu,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(99))
  call Hloop_ZQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),ngZu,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(92),n2h1(100))
  call Hloop_ZQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),ngZu,m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(101))
  call Hloop_WQ_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(94),n2h1(102))
  call Hloop_WQ_A(ntryL,G1H2(24),ex5(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(95),n2h1(103))
  call Hloop_WQ_A(ntryL,G1H2(36),ex5(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(104))
  call Hloop_WQ_A(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(105))
  call Hloop_WQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(98),n2h1(106))
  call Hloop_WQ_A(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(107))
  call Hloop_WQ_A(ntryL,G1H2(54),ex5(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(100),n2h1(108))
  call Hloop_WQ_A(ntryL,G1H2(58),ex5(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(101),n2h1(109))
  call Hloop_WQ_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(110))
  call Hloop_ZQ_A(ntryL,G1H2(71),ex5(:),G1H1(1),ngZu,m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(111))
  call Hloop_ZQ_A(ntryL,G1H2(77),ex5(:),G1H1(1),ngZu,m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(104),n2h1(112))
  call Hloop_ZQ_A(ntryL,G1H2(84),ex5(:),G1H1(1),ngZu,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(113))
  call Hloop_ZQ_A(ntryL,G1H2(89),ex5(:),G1H1(1),ngZu,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(114))
  call Hloop_ZQ_A(ntryL,G1H2(94),ex5(:),G1H1(1),ngZu,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(107),n2h1(115))
  call Hloop_ZQ_A(ntryL,G1H2(112),ex5(:),G1H1(1),ngZu,m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(108),n2h1(116))
  call Hloop_WQ_A(ntryL,G1H2(113),ex5(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(117))
  call Hloop_WQ_A(ntryL,G1H2(114),ex5(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(110),n2h1(118))
  call Hloop_WQ_A(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(119))
  call Hloop_WQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(112),n2h1(120))
  call Hloop_WQ_A(ntryL,G1H2(76),ex5(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(113),n2h1(121))
  call Hloop_WQ_A(ntryL,G1H2(106),ex5(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(122))
  call Hloop_WQ_A(ntryL,G1H2(30),ex5(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(115),n2h1(123))
  call Hloop_WQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(116),n2h1(124))
  call Hloop_WQ_A(ntryL,G1H2(118),ex5(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(125))
  call Hloop_ZQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),ngZu,m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(126))
  call Hloop_ZQ_A(ntryL,G1H2(102),ex5(:),G1H1(1),ngZu,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(119),n2h1(127))
  call Hloop_ZQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),ngZu,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(128))
  call Hloop_ZQ_A(ntryL,G1H2(72),ex5(:),G1H1(1),ngZu,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(129))
  call Hloop_ZQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),ngZu,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(122),n2h1(130))
  call Hloop_ZQ_A(ntryL,G1H2(101),ex5(:),G1H1(1),ngZu,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(131))
  call Hloop_WQ_A(ntryL,G1H2(75),ex5(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(124),n2h1(132))
  call Hloop_WQ_A(ntryL,G1H2(90),ex5(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(125),n2h1(133))
  call Hloop_WQ_A(ntryL,G1H2(93),ex5(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(134))
  call Hloop_WQ_A(ntryL,G1H2(100),ex5(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(135))
  call Hloop_WQ_A(ntryL,G1H2(99),ex5(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(128),n2h1(136))
  call Hloop_WQ_A(ntryL,G1H2(121),ex5(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(137))
  call Hloop_WQ_A(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(130),n2h1(138))
  call Hloop_WQ_A(ntryL,G1H2(123),ex5(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(131),n2h1(139))
  call Hloop_WQ_A(ntryL,G1H2(127),ex5(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(140))
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,1),heltab2x4(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(141))
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,2),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(134),n2h1(142))
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,3),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(143))
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,4),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(144))
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,5),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(137),n2h1(145))
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(146))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,7),heltab2x4(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(147))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,8),heltab2x4(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(140),n2h1(148))
  call Hloop_QZ_A(ntryL,G1H4(26),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,9),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(149))
  call Hloop_QZ_A(ntryL,G1H4(29),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,10),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(150))
  call Hloop_QZ_A(ntryL,G1H4(30),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,11),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(143),n2h1(151))
  call Hloop_QZ_A(ntryL,G1H4(36),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,12),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(152))
  call Hloop_QZ_A(ntryL,G1H4(37),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,13),heltab2x4(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(153))
  call Hloop_QZ_A(ntryL,G1H4(38),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,14),heltab2x4(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(146),n2h1(154))
  call Hloop_QZ_A(ntryL,G1H4(42),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,15),heltab2x4(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(155))
  call Hloop_QZ_A(ntryL,G1H4(43),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,16),heltab2x4(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(148),n2h1(156))
  call Hloop_QZ_A(ntryL,G1H4(44),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,17),heltab2x4(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(149),n2h1(157))
  call Hloop_QZ_A(ntryL,G1H4(48),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,18),heltab2x4(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(158))
  call Hloop_QZ_A(ntryL,G1H4(49),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,19),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(151),n2h1(159))
  call Hloop_QZ_A(ntryL,G1H4(50),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,20),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(152),n2h1(160))
  call Hloop_QZ_A(ntryL,G1H4(54),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,21),heltab2x4(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(161))
  call Hloop_QZ_A(ntryL,G1H4(55),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,22),heltab2x4(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(154),n2h1(162))
  call Hloop_QZ_A(ntryL,G1H4(56),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,23),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(155),n2h1(163))
  call Hloop_QZ_A(ntryL,G1H4(60),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,24),heltab2x4(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(164))
  call Hloop_QZ_A(ntryL,G1H4(61),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,25),heltab2x4(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(157),n2h1(165))
  call Hloop_QZ_A(ntryL,G1H4(62),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,26),heltab2x4(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(158),n2h1(166))
  call Hloop_QZ_A(ntryL,G1H4(66),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,27),heltab2x4(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(167))
  call Hloop_QZ_A(ntryL,G1H4(67),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,28),heltab2x4(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(160),n2h1(168))
  call Hloop_QZ_A(ntryL,G1H4(68),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,29),heltab2x4(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(161),n2h1(169))
  call Hloop_QZ_A(ntryL,G1H4(72),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,30),heltab2x4(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(170))
  call Hloop_ZA_Q(ntryL,G1H2(117),ex4(:),G1H1(1),ngZn,m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(163),n2h1(171))
  call Hloop_ZA_Q(ntryL,G1H2(128),ex4(:),G1H1(1),ngZn,m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(164),n2h1(172))
  call Hloop_ZA_Q(ntryL,G1H2(132),ex4(:),G1H1(1),ngZn,m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(173))
  call Hloop_ZA_Q(ntryL,G1H2(133),ex3(:),G1H1(1),ngZn,m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(166),n2h1(174))
  call Hloop_ZA_Q(ntryL,G1H2(134),ex3(:),G1H1(1),ngZn,m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(167),n2h1(175))
  call Hloop_ZA_Q(ntryL,G1H2(138),ex3(:),G1H1(1),ngZn,m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(168),n2h1(176))
  call Hloop_ZA_Q(ntryL,G1H2(139),ex4(:),G1H1(1),ngZn,m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(169),n2h1(177))
  call Hloop_ZA_Q(ntryL,G1H2(140),ex4(:),G1H1(1),ngZn,m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(170),n2h1(178))
  call Hloop_ZA_Q(ntryL,G1H2(144),ex4(:),G1H1(1),ngZn,m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(171),n2h1(179))
  call Hloop_ZA_Q(ntryL,G1H2(145),ex3(:),G1H1(1),ngZn,m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(172),n2h1(180))
  call Hloop_ZA_Q(ntryL,G1H2(146),ex3(:),G1H1(1),ngZn,m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(173),n2h1(181))
  call Hloop_ZA_Q(ntryL,G1H2(150),ex3(:),G1H1(1),ngZn,m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(174),n2h1(182))
  call Hloop_WA_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(183))
  call Hloop_WA_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(176),n2h1(184))
  call Hloop_WA_Q(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(185))
  call Hloop_ZA_Q(ntryL,G1H2(157),ex4(:),G1H1(1),ngZn,m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(178),n2h1(186))
  call Hloop_ZA_Q(ntryL,G1H2(158),ex4(:),G1H1(1),ngZn,m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(179),n2h1(187))
  call Hloop_ZA_Q(ntryL,G1H2(162),ex4(:),G1H1(1),ngZn,m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(180),n2h1(188))
  call Hloop_WA_Q(ntryL,G1H2(163),ex3(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(181),n2h1(189))
  call Hloop_WA_Q(ntryL,G1H2(164),ex3(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(182),n2h1(190))
  call Hloop_WA_Q(ntryL,G1H2(168),ex3(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(191))
  call Hloop_ZA_Q(ntryL,G1H2(169),ex3(:),G1H1(1),ngZn,m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(184),n2h1(192))
  call Hloop_ZA_Q(ntryL,G1H2(170),ex3(:),G1H1(1),ngZn,m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(185),n2h1(193))
  call Hloop_ZA_Q(ntryL,G1H2(174),ex3(:),G1H1(1),ngZn,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(186),n2h1(194))
  call Hloop_WA_Q(ntryL,G1H2(175),ex4(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(187),n2h1(195))
  call Hloop_WA_Q(ntryL,G1H2(176),ex4(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(188),n2h1(196))
  call Hloop_WA_Q(ntryL,G1H2(180),ex4(:),G1H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(189),n2h1(197))
  call Hloop_ZA_Q(ntryL,G1H2(181),ex4(:),G1H1(1),ngZn,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(190),n2h1(198))
  call Hloop_ZA_Q(ntryL,G1H2(182),ex4(:),G1H1(1),ngZn,m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(191),n2h1(199))
  call Hloop_ZA_Q(ntryL,G1H2(186),ex4(:),G1H1(1),ngZn,m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(192),n2h1(200))
  call Hloop_WA_Q(ntryL,G1H2(187),ex3(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(193),n2h1(201))
  call Hloop_WA_Q(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(194),n2h1(202))
  call Hloop_WA_Q(ntryL,G1H2(192),ex3(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(195),n2h1(203))
  call Hloop_ZA_Q(ntryL,G1H2(193),ex3(:),G1H1(1),ngZn,m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(196),n2h1(204))
  call Hloop_ZA_Q(ntryL,G1H2(194),ex3(:),G1H1(1),ngZn,m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(197),n2h1(205))
  call Hloop_ZA_Q(ntryL,G1H2(198),ex3(:),G1H1(1),ngZn,m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(198),n2h1(206))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(14),G1tensor(38)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(20),G1tensor(56)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(62)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(68)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(74)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(28),G1tensor(80)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(86)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(92)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(98)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(104)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(38),G1tensor(110)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(116)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(52),G1tensor(4)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(17),G1tensor(5)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(66),G1tensor(6)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(76),G1tensor(10)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(23),G1tensor(11)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(48),G1tensor(12)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(106),G1tensor(16)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(30),G1tensor(18)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(34),G1tensor(22)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(96),G1tensor(24)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(118),G1tensor(28)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(102),G1tensor(36)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(88),G1tensor(46)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(72),G1tensor(54)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(60)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(70),G1tensor(64)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(101),G1tensor(71)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(77)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(90),G1tensor(78)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(82)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(83)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(84)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(119),G1tensor(89)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(100),G1tensor(94)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(95)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(121),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(120),G1tensor(108)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(111)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(112)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(113)])
  call ol_merge_tensors(G2tensor(130),[G1tensor(114)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(117)])
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(49),mass5set(:,11),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(50),mass5set(:,11),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(51),mass5set(:,11),  & 
G1tensor(73),G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103))
  call G_TensorShift(G1tensor(79),4)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(52),mass5set(:,11),  & 
G1tensor(109),G1tensor(115),G1tensor(2),G1tensor(8),G1tensor(14),G1tensor(20))
  call G_TensorShift(G1tensor(115),8)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(53),mass5set(:,11),  & 
G1tensor(26),G1tensor(32),G1tensor(38),G1tensor(44),G1tensor(50),G1tensor(56))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(19),mass5set(:,11),  & 
G1tensor(62),G1tensor(68),G1tensor(74),G1tensor(80),G1tensor(86),G1tensor(92))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(19),mass5set(:,4),  & 
G1tensor(98),G1tensor(104),G1tensor(110),G1tensor(116),G1tensor(3),G1tensor(52))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(54),mass5set(:,11),  & 
G1tensor(4),G1tensor(17),G1tensor(5),G1tensor(66),G1tensor(6),G1tensor(9))
  call G_TensorShift(G1tensor(17),2)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(20),mass5set(:,11),  & 
G1tensor(76),G1tensor(10),G1tensor(23),G1tensor(11),G1tensor(48),G1tensor(12))
  call G_TensorShift(G1tensor(10),4)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(20),mass5set(:,4),  & 
G1tensor(15),G1tensor(106),G1tensor(16),G1tensor(30),G1tensor(18),G1tensor(21))
  call G_TensorShift(G1tensor(106),4)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(55),mass5set(:,11),  & 
G1tensor(34),G1tensor(22),G1tensor(96),G1tensor(24),G1tensor(27),G1tensor(118))
  call G_TensorShift(G1tensor(22),1)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(56),mass5set(:,11),  & 
G1tensor(28),G1tensor(29),G1tensor(33),G1tensor(35),G1tensor(102),G1tensor(36))
  call G_TensorShift(G1tensor(29),1)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(21),mass5set(:,11),  & 
G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42),G1tensor(45),G1tensor(88))
  call G_TensorShift(G1tensor(40),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(21),mass5set(:,4),  & 
G1tensor(46),G1tensor(47),G1tensor(51),G1tensor(53),G1tensor(72),G1tensor(54))
  call G_TensorShift(G1tensor(47),8)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(57),mass5set(:,11),  & 
G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60),G1tensor(63),G1tensor(70))
  call G_TensorShift(G1tensor(58),2)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(58),mass5set(:,11),  & 
G1tensor(64),G1tensor(65),G1tensor(69),G1tensor(101),G1tensor(71),G1tensor(75))
  call G_TensorShift(G1tensor(65),1)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(59),mass5set(:,11),  & 
G1tensor(77),G1tensor(90),G1tensor(78),G1tensor(81),G1tensor(82),G1tensor(83))
  call G_TensorShift(G1tensor(90),1)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(22),mass5set(:,11),  & 
G1tensor(84),G1tensor(87),G1tensor(119),G1tensor(89),G1tensor(93),G1tensor(100))
  call G_TensorShift(G1tensor(87),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(22),mass5set(:,4),  & 
G1tensor(94),G1tensor(95),G1tensor(99),G1tensor(105),G1tensor(107),G1tensor(120))
  call G_TensorShift(G1tensor(95),4)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(60),mass5set(:,11),  & 
G1tensor(108),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(117))
  call G_TensorShift(G1tensor(111),2)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(61),mass5set(:,9),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(29),mass5set(:,12),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(62),mass5set(:,5),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(63),mass5set(:,13),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(64),mass5set(:,9),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(33),mass5set(:,12),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(65),mass5set(:,5),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(66),mass5set(:,13),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(67),mass5set(:,9),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(37),mass5set(:,12),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(68),mass5set(:,13),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(69),mass5set(:,9),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(25),mass5set(:,12),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(70),mass5set(:,13),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(71),mass5set(:,9),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(72),mass5set(:,12),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(23),mass5set(:,5),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(73),mass5set(:,9),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(24),mass5set(:,5),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(26),mass5set(:,13),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(73),mass5set(:,10),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(25),mass5set(:,6),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(82),RedSet_5(24),mass5set(:,7),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(26),mass5set(:,8),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(74),mass5set(:,9),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(75),mass5set(:,12),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(88),RedSet_5(27),mass5set(:,5),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(42),RedSet_5(76),mass5set(:,9),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(28),mass5set(:,5),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(30),mass5set(:,13),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),16)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(76),mass5set(:,10),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),16)
  call Hotf_5pt_reduction_last(G2tensor(94),RedSet_5(29),mass5set(:,6),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),16)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(28),mass5set(:,7),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),16)
  call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(30),mass5set(:,8),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(77),mass5set(:,9),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),16)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(78),mass5set(:,12),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),16)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(31),mass5set(:,5),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(79),mass5set(:,9),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),16)
  call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(80),mass5set(:,5),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(81),mass5set(:,9),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),16)
  call Hotf_5pt_reduction_last(G2tensor(106),RedSet_5(32),mass5set(:,5),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),16)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(34),mass5set(:,13),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),16)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(81),mass5set(:,10),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(33),mass5set(:,6),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),16)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(32),mass5set(:,7),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),16)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(34),mass5set(:,8),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),16)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(82),mass5set(:,9),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(83),mass5set(:,5),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),16)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(84),mass5set(:,9),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(85),mass5set(:,12),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),16)
  call Hotf_5pt_reduction_last(G2tensor(118),RedSet_5(35),mass5set(:,5),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(422),16)
  call Hotf_5pt_reduction_last(G2tensor(56),RedSet_5(86),mass5set(:,9),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(428),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(87),mass5set(:,9),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437),G1tensor(438))
  call G_TensorShift(G1tensor(434),16)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(36),mass5set(:,5),  & 
G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444))
  call G_TensorShift(G1tensor(440),16)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(38),mass5set(:,13),  & 
G1tensor(445),G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(446),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(87),mass5set(:,10),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(452),16)
  call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(37),mass5set(:,6),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(458),16)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(36),mass5set(:,7),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G1tensor(468))
  call G_TensorShift(G1tensor(464),16)
  call Hotf_5pt_reduction_last(G2tensor(130),RedSet_5(38),mass5set(:,8),  & 
G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(470),16)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(88),mass5set(:,9),  & 
G1tensor(475),G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(476),16)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(17),mass5set(:,3),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(482),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(18),mass5set(:,3),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(488),8)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(39),mass5set(:,1),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497),G1tensor(498))
  call G_TensorShift(G1tensor(494),5)
  call Hotf_5pt_reduction_last(G2tensor(136),RedSet_5(39),mass5set(:,2),  & 
G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504))
  call G_TensorShift(G1tensor(500),5)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(40),mass5set(:,1),  & 
G1tensor(505),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(506),6)
  call Hotf_5pt_reduction_last(G2tensor(142),RedSet_5(40),mass5set(:,2),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(512),6)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(41),mass5set(:,1),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(518),9)
  call Hotf_5pt_reduction_last(G2tensor(148),RedSet_5(42),mass5set(:,1),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527),G1tensor(528))
  call G_TensorShift(G1tensor(524),9)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(42),mass5set(:,2),  & 
G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534))
  call G_TensorShift(G1tensor(530),9)
  call Hotf_5pt_reduction_last(G2tensor(154),RedSet_5(43),mass5set(:,1),  & 
G1tensor(535),G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(536),10)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(44),mass5set(:,1),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(542),10)
  call Hotf_5pt_reduction_last(G2tensor(160),RedSet_5(44),mass5set(:,2),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(548),10)
  call Hotf_5pt_reduction_last(G2tensor(163),RedSet_5(45),mass5set(:,9),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557),G1tensor(558))
  call G_TensorShift(G1tensor(554),8)
  call Hotf_5pt_reduction_last(G2tensor(166),RedSet_5(46),mass5set(:,9),  & 
G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564))
  call G_TensorShift(G1tensor(560),4)
  call Hotf_5pt_reduction_last(G2tensor(169),RedSet_5(47),mass5set(:,9),  & 
G1tensor(565),G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(566),8)
  call Hotf_5pt_reduction_last(G2tensor(172),RedSet_5(48),mass5set(:,9),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(572),4)
  call Hotf_5pt_reduction_last(G2tensor(175),RedSet_5(19),mass5set(:,10),  & 
G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581),G1tensor(582))
  call G_TensorShift(G1tensor(578),8)
  call Hotf_5pt_reduction_last(G2tensor(178),RedSet_5(19),mass5set(:,9),  & 
G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586),G1tensor(587),G1tensor(588))
  call G_TensorShift(G1tensor(584),8)
  call Hotf_5pt_reduction_last(G2tensor(181),RedSet_5(20),mass5set(:,10),  & 
G1tensor(589),G1tensor(590),G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594))
  call G_TensorShift(G1tensor(590),4)
  call Hotf_5pt_reduction_last(G2tensor(184),RedSet_5(20),mass5set(:,9),  & 
G1tensor(595),G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(596),4)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(21),mass5set(:,10),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605),G1tensor(606))
  call G_TensorShift(G1tensor(602),8)
  call Hotf_5pt_reduction_last(G2tensor(190),RedSet_5(21),mass5set(:,9),  & 
G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610),G1tensor(611),G1tensor(612))
  call G_TensorShift(G1tensor(608),8)
  call Hotf_5pt_reduction_last(G2tensor(193),RedSet_5(22),mass5set(:,10),  & 
G1tensor(613),G1tensor(614),G1tensor(615),G1tensor(616),G1tensor(617),G1tensor(618))
  call G_TensorShift(G1tensor(614),4)
  call Hotf_5pt_reduction_last(G2tensor(196),RedSet_5(22),mass5set(:,9),  & 
G1tensor(619),G1tensor(620),G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624))
  call G_TensorShift(G1tensor(620),4)
  call ol_merge_tensors(T1sum(21),[G1tensor(1)])
  call ol_merge_tensors(T1sum(22),[G1tensor(37)])
  call ol_merge_tensors(T1sum(23),[G1tensor(73)])
  call ol_merge_tensors(T1sum(24),[G1tensor(109)])
  call ol_merge_tensors(T1sum(25),[G1tensor(26)])
  call ol_merge_tensors(T1sum(26),[G1tensor(62)])
  call ol_merge_tensors(T1sum(27),[G1tensor(98)])
  call ol_merge_tensors(T1sum(28),[G1tensor(4)])
  call ol_merge_tensors(T1sum(29),[G1tensor(76)])
  call ol_merge_tensors(T1sum(30),[G1tensor(15)])
  call ol_merge_tensors(T1sum(31),[G1tensor(34)])
  call ol_merge_tensors(T1sum(32),[G1tensor(28)])
  call ol_merge_tensors(T1sum(33),[G1tensor(39)])
  call ol_merge_tensors(T1sum(34),[G1tensor(46)])
  call ol_merge_tensors(T1sum(35),[G1tensor(57)])
  call ol_merge_tensors(T1sum(36),[G1tensor(64)])
  call ol_merge_tensors(T1sum(37),[G1tensor(77)])
  call ol_merge_tensors(T1sum(38),[G1tensor(84)])
  call ol_merge_tensors(T1sum(39),[G1tensor(94)])
  call ol_merge_tensors(T1sum(40),[G1tensor(108)])
  call ol_merge_tensors(T1sum(41),[G1tensor(121)])
  call ol_merge_tensors(T1sum(42),[G1tensor(127)])
  call ol_merge_tensors(T1sum(43),[G1tensor(133)])
  call ol_merge_tensors(T1sum(44),[G1tensor(139)])
  call ol_merge_tensors(T1sum(45),[G1tensor(145)])
  call ol_merge_tensors(T1sum(46),[G1tensor(151)])
  call ol_merge_tensors(T1sum(47),[G1tensor(157)])
  call ol_merge_tensors(T1sum(48),[G1tensor(163)])
  call ol_merge_tensors(T1sum(49),[G1tensor(169)])
  call ol_merge_tensors(T1sum(50),[G1tensor(175)])
  call ol_merge_tensors(T1sum(51),[G1tensor(181)])
  call ol_merge_tensors(T1sum(52),[G1tensor(187)])
  call ol_merge_tensors(T1sum(53),[G1tensor(193)])
  call ol_merge_tensors(T1sum(54),[G1tensor(199)])
  call ol_merge_tensors(T1sum(55),[G1tensor(205)])
  call ol_merge_tensors(T1sum(56),[G1tensor(211)])
  call ol_merge_tensors(T1sum(57),[G1tensor(217)])
  call ol_merge_tensors(T1sum(58),[G1tensor(223)])
  call ol_merge_tensors(T1sum(59),[G1tensor(229)])
  call ol_merge_tensors(T1sum(60),[G1tensor(235)])
  call ol_merge_tensors(T1sum(61),[G1tensor(241)])
  call ol_merge_tensors(T1sum(62),[G1tensor(247)])
  call ol_merge_tensors(T1sum(63),[G1tensor(253)])
  call ol_merge_tensors(T1sum(64),[G1tensor(259)])
  call ol_merge_tensors(T1sum(65),[G1tensor(265)])
  call ol_merge_tensors(T1sum(66),[G1tensor(271)])
  call ol_merge_tensors(T1sum(67),[G1tensor(277)])
  call ol_merge_tensors(T1sum(68),[G1tensor(283)])
  call ol_merge_tensors(T1sum(69),[G1tensor(289)])
  call ol_merge_tensors(T1sum(70),[G1tensor(295)])
  call ol_merge_tensors(T1sum(71),[G1tensor(301)])
  call ol_merge_tensors(T1sum(72),[G1tensor(307)])
  call ol_merge_tensors(T1sum(73),[G1tensor(313)])
  call ol_merge_tensors(T1sum(74),[G1tensor(319)])
  call ol_merge_tensors(T1sum(75),[G1tensor(325)])
  call ol_merge_tensors(T1sum(76),[G1tensor(331)])
  call ol_merge_tensors(T1sum(77),[G1tensor(337)])
  call ol_merge_tensors(T1sum(78),[G1tensor(343)])
  call ol_merge_tensors(T1sum(79),[G1tensor(349)])
  call ol_merge_tensors(T1sum(80),[G1tensor(355)])
  call ol_merge_tensors(T1sum(81),[G1tensor(361)])
  call ol_merge_tensors(T1sum(82),[G1tensor(367)])
  call ol_merge_tensors(T1sum(83),[G1tensor(373)])
  call ol_merge_tensors(T1sum(84),[G1tensor(379)])
  call ol_merge_tensors(T1sum(85),[G1tensor(385)])
  call ol_merge_tensors(T1sum(86),[G1tensor(391)])
  call ol_merge_tensors(T1sum(87),[G1tensor(397)])
  call ol_merge_tensors(T1sum(88),[G1tensor(403)])
  call ol_merge_tensors(T1sum(89),[G1tensor(409)])
  call ol_merge_tensors(T1sum(90),[G1tensor(415)])
  call ol_merge_tensors(T1sum(91),[G1tensor(421)])
  call ol_merge_tensors(T1sum(92),[G1tensor(427)])
  call ol_merge_tensors(T1sum(93),[G1tensor(433)])
  call ol_merge_tensors(T1sum(94),[G1tensor(439)])
  call ol_merge_tensors(T1sum(95),[G1tensor(445)])
  call ol_merge_tensors(T1sum(96),[G1tensor(451)])
  call ol_merge_tensors(T1sum(97),[G1tensor(457)])
  call ol_merge_tensors(T1sum(98),[G1tensor(463)])
  call ol_merge_tensors(T1sum(99),[G1tensor(469)])
  call ol_merge_tensors(T1sum(100),[G1tensor(475)])
  call ol_merge_tensors(T1sum(101),[G1tensor(481)])
  call ol_merge_tensors(T1sum(102),[G1tensor(487)])
  call ol_merge_tensors(T1sum(103),[G1tensor(493)])
  call ol_merge_tensors(T1sum(104),[G1tensor(499)])
  call ol_merge_tensors(T1sum(105),[G1tensor(505)])
  call ol_merge_tensors(T1sum(106),[G1tensor(511)])
  call ol_merge_tensors(T1sum(107),[G1tensor(517)])
  call ol_merge_tensors(T1sum(108),[G1tensor(523)])
  call ol_merge_tensors(T1sum(109),[G1tensor(529)])
  call ol_merge_tensors(T1sum(110),[G1tensor(535)])
  call ol_merge_tensors(T1sum(111),[G1tensor(541)])
  call ol_merge_tensors(T1sum(112),[G1tensor(547)])
  call ol_merge_tensors(T1sum(113),[G1tensor(553)])
  call ol_merge_tensors(T1sum(114),[G1tensor(559)])
  call ol_merge_tensors(T1sum(115),[G1tensor(565)])
  call ol_merge_tensors(T1sum(116),[G1tensor(571)])
  call ol_merge_tensors(T1sum(117),[G1tensor(577)])
  call ol_merge_tensors(T1sum(118),[G1tensor(583)])
  call ol_merge_tensors(T1sum(119),[G1tensor(589)])
  call ol_merge_tensors(T1sum(120),[G1tensor(595)])
  call ol_merge_tensors(T1sum(121),[G1tensor(601)])
  call ol_merge_tensors(T1sum(122),[G1tensor(607)])
  call ol_merge_tensors(T1sum(123),[G1tensor(613)])
  call ol_merge_tensors(T1sum(124),[G1tensor(619)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,10,5,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,53),heltab2x64(:,:,77))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(1),n2h32(3))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,10,5,16],[0,0,0,nMZ],4,2,wf4(:,2),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),ngZu,m3h2x32(:,54),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(2),n2h32(4))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,10,5,16],[0,0,0,nMW],4,2,wf4(:,2),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,55),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(3),n2h32(5))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,10,5,16],[nMZ,nMH,nMZ,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(5),ngZu,m3h2x32(:,56),heltab2x64(:,:,80))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,10,5,16],[nMW,nMW,nMW,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,57),heltab2x64(:,:,81))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,10,5,16],[nMW,nMW,nMW,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,58),heltab2x64(:,:,82))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,5,10,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,59),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(4),n2h32(6))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,5,10,16],[0,0,0,nMZ],4,2,wf4(:,1),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),ngZu,m3h2x32(:,60),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(5),n2h32(7))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,5,10,16],[0,0,0,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,61),heltab2x64(:,:,85))
  call Hloop_A_Q(ntryL,G0H32(11),32,0,G1H32(6),n2h32(8))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,5,10,16],[nMZ,nMH,nMZ,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(12),ngZu,m3h2x32(:,62),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,5,10,16],[nMW,nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,63),heltab2x64(:,:,87))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,5,10,16],[nMW,nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,64),heltab2x64(:,:,88))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,5,16,10],[0,0,nMW,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,65),heltab2x64(:,:,89))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(7),n2h32(9))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,5,16,10],[nMW,nMW,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,66),heltab2x64(:,:,90))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[48,5,2,8],[0,0,nMW,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(1),m3h4x16(:,25),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(1),n2h16(63))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[48,5,2,8],[0,0,nMZ,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZn,m3h4x16(:,26),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(2),n2h16(64))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[48,5,2,8],[0,0,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZl,m3h4x16(:,27),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(3),n2h16(65))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(1),m3h4x16(:,28),heltab2x64(:,:,94))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[48,5,2,8],[nMH,nMZ,0,nMZ],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(2),m3h4x16(:,29),heltab2x64(:,:,95))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(3),m3h4x16(:,30),heltab2x64(:,:,96))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(4),m3h4x16(:,31),heltab2x64(:,:,97))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(7),m3h4x16(:,32),heltab2x64(:,:,98))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[48,2,8,5],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(4),m3h4x16(:,33),heltab2x64(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(6),n2h16(66))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[48,2,8,5],[0,nMZ,0,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(4),ngZn,m3h4x16(:,34),heltab2x64(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(9),n2h16(67))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[48,2,8,5],[0,nMW,0,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(4),ngZl,m3h4x16(:,35),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(12),n2h16(68))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(4),m3h4x16(:,36),heltab2x64(:,:,102))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[48,2,8,5],[nMZ,0,nMZ,nMH],4,2,wf4(:,3),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(5),m3h4x16(:,37),heltab2x64(:,:,103))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(6),m3h4x16(:,38),heltab2x64(:,:,104))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(11),m3h4x16(:,39),heltab2x64(:,:,105))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(14),m3h4x16(:,40),heltab2x64(:,:,106))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[48,2,5,8],[nMW,0,0,nMW],4,2,wf4(:,7),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(17),m3h4x16(:,41),heltab2x64(:,:,107))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[48,2,5,8],[nMW,0,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(16),m3h4x16(:,42),heltab2x64(:,:,108))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[48,2,5,8],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(7),m3h4x16(:,43),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G0H16(7),48,0,G1H16(19),n2h16(69))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[48,2,5,8],[0,nMW,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZl,m3h4x16(:,44),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H16(7),48,0,G1H16(22),n2h16(70))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,7,8,16],[nMZ,0,nMZ,0],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(17),ngZu,m3h2x32(:,67),heltab2x64(:,:,111))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,7,8,16],[nMW,0,nMW,0],4,1,wf8(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,68),heltab2x64(:,:,112))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,8,7,16],[nMZ,0,nMZ,0],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(19),ngZu,m3h2x32(:,69),heltab2x64(:,:,113))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,13,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,58))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(20),ngZu,m3h2x32(:,70),heltab2x64(:,:,114))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,2,13,16],[nMZ,0,nMZ,0],4,1,wf8(:,58))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZu,m3h2x32(:,71),heltab2x64(:,:,115))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,2,13,16],[nMW,0,nMW,0],4,1,wf8(:,58))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,72),heltab2x64(:,:,116))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,2,8,21],[nMZ,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(21),ngZu,m3h2x32(:,73),heltab2x64(:,:,117))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,2,8,21],[nMW,0,nMW,0],4,1,wf8(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,74),heltab2x64(:,:,118))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,8,2,21],[nMZ,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(23),ngZu,m3h2x32(:,75),heltab2x64(:,:,119))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[37,8,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,34))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,34),G0H8(1),ngZu,m3h8x8(:,1),heltab2x64(:,:,120))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[37,2,8,16],[nMZ,0,nMZ,0],4,1,wf8(:,34))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,34),G0H8(2),ngZu,m3h8x8(:,2),heltab2x64(:,:,121))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[37,2,8,16],[nMW,0,nMW,0],4,1,wf8(:,34))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,34),G0H8(3),m3h8x8(:,3),heltab2x64(:,:,122))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,6,9,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,76),heltab2x64(:,:,123))
  call Hloop_A_Q(ntryL,G0H32(24),32,0,G1H32(8),n2h32(10))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,6,9,16],[0,0,0,nMZ],4,2,wf4(:,5),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),ngZu,m3h2x32(:,77),heltab2x64(:,:,124))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(9),n2h32(11))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,6,9,16],[0,0,0,nMW],4,2,wf4(:,5),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,78),heltab2x64(:,:,125))
  call Hloop_A_Q(ntryL,G0H32(26),32,0,G1H32(10),n2h32(12))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,6,9,16],[nMZ,nMH,nMZ,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(27),ngZu,m3h2x32(:,79),heltab2x64(:,:,126))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,6,9,16],[nMW,nMW,nMW,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,80),heltab2x64(:,:,127))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,6,9,16],[nMW,nMW,nMW,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,81),heltab2x64(:,:,128))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,9,6,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,82),heltab2x64(:,:,129))
  call Hloop_A_Q(ntryL,G0H32(30),32,0,G1H32(11),n2h32(13))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,9,6,16],[0,0,0,nMZ],4,2,wf4(:,4),wf4(:,5))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),ngZu,m3h2x32(:,83),heltab2x64(:,:,130))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(12),n2h32(14))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,9,6,16],[0,0,0,nMW],4,2,wf4(:,4),wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,84),heltab2x64(:,:,131))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(13),n2h32(15))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,9,6,16],[nMZ,nMH,nMZ,0],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZu,m3h2x32(:,85),heltab2x64(:,:,132))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,9,6,16],[nMW,nMW,nMW,0],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,86),heltab2x64(:,:,133))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,9,6,16],[nMW,nMW,nMW,0],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,87),heltab2x64(:,:,134))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,6,16,9],[nMW,nMW,0,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,88),heltab2x64(:,:,135))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,6,16,9],[0,0,nMW,nMW],4,2,wf4(:,5),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,89),heltab2x64(:,:,136))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(14),n2h32(16))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[48,6,1,8],[0,0,nMW,0],4,2,wf4(:,7),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(7),m3h4x16(:,45),heltab2x64(:,:,137))
  call Hloop_A_Q(ntryL,G0H16(7),48,0,G1H16(21),n2h16(71))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[48,6,1,8],[0,0,nMZ,0],4,2,wf4(:,3),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZn,m3h4x16(:,46),heltab2x64(:,:,138))
  call Hloop_A_Q(ntryL,G0H16(7),48,0,G1H16(24),n2h16(72))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[48,6,1,8],[0,0,nMW,0],4,2,wf4(:,3),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZl,m3h4x16(:,47),heltab2x64(:,:,139))
  call Hloop_A_Q(ntryL,G0H16(7),48,0,G1H16(5),n2h16(73))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(7),m3h4x16(:,48),heltab2x64(:,:,140))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[48,6,1,8],[nMH,nMZ,0,nMZ],4,2,wf4(:,3),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(8),m3h4x16(:,49),heltab2x64(:,:,141))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(9),m3h4x16(:,50),heltab2x64(:,:,142))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(8),m3h4x16(:,51),heltab2x64(:,:,143))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(10),m3h4x16(:,52),heltab2x64(:,:,144))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[48,1,8,6],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(10),m3h4x16(:,53),heltab2x64(:,:,145))
  call Hloop_A_Q(ntryL,G0H16(10),48,0,G1H16(13),n2h16(74))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[48,1,8,6],[0,nMZ,0,0],4,2,wf4(:,3),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(10),ngZn,m3h4x16(:,54),heltab2x64(:,:,146))
  call Hloop_A_Q(ntryL,G0H16(10),48,0,G1H16(15),n2h16(75))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[48,1,8,6],[0,nMW,0,0],4,2,wf4(:,3),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(10),ngZl,m3h4x16(:,55),heltab2x64(:,:,147))
  call Hloop_A_Q(ntryL,G0H16(10),48,0,G1H16(18),n2h16(76))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(10),m3h4x16(:,56),heltab2x64(:,:,148))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[48,1,8,6],[nMZ,0,nMZ,nMH],4,2,wf4(:,3),wf4(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(11),m3h4x16(:,57),heltab2x64(:,:,149))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(12),m3h4x16(:,58),heltab2x64(:,:,150))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(20),m3h4x16(:,59),heltab2x64(:,:,151))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(23),m3h4x16(:,60),heltab2x64(:,:,152))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[48,1,6,8],[nMW,0,0,nMW],4,2,wf4(:,7),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(25),m3h4x16(:,61),heltab2x64(:,:,153))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[48,1,6,8],[nMW,0,0,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(26),m3h4x16(:,62),heltab2x64(:,:,154))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[48,1,6,8],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(13),m3h4x16(:,63),heltab2x64(:,:,155))
  call Hloop_A_Q(ntryL,G0H16(13),48,0,G1H16(27),n2h16(77))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[48,1,6,8],[0,nMW,nMW,0],4,2,wf4(:,3),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(13),ngZl,m3h4x16(:,64),heltab2x64(:,:,156))
  call Hloop_A_Q(ntryL,G0H16(13),48,0,G1H16(28),n2h16(78))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,7,8,16],[nMZ,0,nMZ,0],4,1,wf8(:,20))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(24),ngZu,m3h2x32(:,90),heltab2x64(:,:,157))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,7,8,16],[nMW,0,nMW,0],4,1,wf8(:,20))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,91),heltab2x64(:,:,158))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,8,7,16],[nMZ,0,nMZ,0],4,1,wf8(:,20))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(26),ngZu,m3h2x32(:,92),heltab2x64(:,:,159))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,14,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,85))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(30),ngZu,m3h2x32(:,93),heltab2x64(:,:,160))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,1,14,16],[nMZ,0,nMZ,0],4,1,wf8(:,85))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZu,m3h2x32(:,94),heltab2x64(:,:,161))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[32,1,14,16],[nMW,0,nMW,0],4,1,wf8(:,85))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,95),heltab2x64(:,:,162))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,1,8,22],[nMZ,0,nMZ,0],4,1,wf8(:,18))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZu,m3h2x32(:,96),heltab2x64(:,:,163))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[32,1,8,22],[nMW,0,nMW,0],4,1,wf8(:,18))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,97),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,8,1,22],[nMZ,0,nMZ,0],4,1,wf8(:,18))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(32),ngZu,m3h2x32(:,98),heltab2x64(:,:,165))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[38,8,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,48))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,48),G0H8(4),ngZu,m3h8x8(:,4),heltab2x64(:,:,166))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[38,1,8,16],[nMZ,0,nMZ,0],4,1,wf8(:,48))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,48),G0H8(5),ngZu,m3h8x8(:,5),heltab2x64(:,:,167))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[38,1,8,16],[nMW,0,nMW,0],4,1,wf8(:,48))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,48),G0H8(6),m3h8x8(:,6),heltab2x64(:,:,168))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[48,4,2,9],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(13),m3h4x16(:,65),heltab2x64(:,:,169))
  call Hloop_Q_A(ntryL,G0H16(13),48,0,G1H16(29),n2h16(79))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[48,4,2,9],[0,nMZ,0,0],4,2,wf4(:,3),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(13),ngZn,m3h4x16(:,66),heltab2x64(:,:,170))
  call Hloop_Q_A(ntryL,G0H16(13),48,0,G1H16(30),n2h16(80))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[48,4,2,9],[0,nMW,0,0],4,2,wf4(:,3),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(13),ngZl,m3h4x16(:,67),heltab2x64(:,:,171))
  call Hloop_Q_A(ntryL,G0H16(13),48,0,G1H16(31),n2h16(81))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(13),m3h4x16(:,68),heltab2x64(:,:,172))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[48,4,2,9],[nMZ,0,nMZ,nMH],4,2,wf4(:,3),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(14),m3h4x16(:,69),heltab2x64(:,:,173))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(15),m3h4x16(:,70),heltab2x64(:,:,174))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(32),m3h4x16(:,71),heltab2x64(:,:,175))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(33),m3h4x16(:,72),heltab2x64(:,:,176))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[48,2,4,9],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(16),m3h4x16(:,73),heltab2x64(:,:,177))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(34),n2h16(82))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[48,2,4,9],[0,nMZ,0,0],4,2,wf4(:,3),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(16),ngZn,m3h4x16(:,74),heltab2x64(:,:,178))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(35),n2h16(83))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[48,2,4,9],[0,nMW,0,0],4,2,wf4(:,3),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(16),ngZl,m3h4x16(:,75),heltab2x64(:,:,179))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(36),n2h16(84))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(16),m3h4x16(:,76),heltab2x64(:,:,180))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[48,2,4,9],[nMZ,0,nMZ,nMH],4,2,wf4(:,3),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(17),m3h4x16(:,77),heltab2x64(:,:,181))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(18),m3h4x16(:,78),heltab2x64(:,:,182))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(37),m3h4x16(:,79),heltab2x64(:,:,183))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(38),m3h4x16(:,80),heltab2x64(:,:,184))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[48,2,9,4],[nMW,0,0,nMW],4,2,wf4(:,7),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(39),m3h4x16(:,81),heltab2x64(:,:,185))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[48,2,9,4],[nMW,0,0,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(40),m3h4x16(:,82),heltab2x64(:,:,186))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[48,2,9,4],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(19),m3h4x16(:,83),heltab2x64(:,:,187))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(41),n2h16(85))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[48,2,9,4],[0,nMW,nMW,0],4,2,wf4(:,3),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(19),ngZl,m3h4x16(:,84),heltab2x64(:,:,188))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(42),n2h16(86))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,11,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,26))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(33),ngZu,m3h2x32(:,99),heltab2x64(:,:,189))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,11,4,16],[nMW,0,nMW,0],4,1,wf8(:,26))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,100),heltab2x64(:,:,190))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,4,11,16],[nMZ,0,nMZ,0],4,1,wf8(:,26))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(35),ngZu,m3h2x32(:,101),heltab2x64(:,:,191))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[32,13,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,68))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(36),ngZu,m3h2x32(:,102),heltab2x64(:,:,192))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[32,2,13,16],[nMZ,0,nMZ,0],4,1,wf8(:,68))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(37),ngZu,m3h2x32(:,103),heltab2x64(:,:,193))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[32,2,13,16],[nMW,0,nMW,0],4,1,wf8(:,68))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,104),heltab2x64(:,:,194))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,2,4,25],[nMZ,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(39),ngZu,m3h2x32(:,105),heltab2x64(:,:,195))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[32,2,4,25],[nMW,0,nMW,0],4,1,wf8(:,15))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,106),heltab2x64(:,:,196))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,4,2,25],[nMZ,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(41),ngZu,m3h2x32(:,107),heltab2x64(:,:,197))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[41,4,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,46))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,46),G0H8(7),ngZu,m3h8x8(:,7),heltab2x64(:,:,198))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[41,2,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,46))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,46),G0H8(8),ngZu,m3h8x8(:,8),heltab2x64(:,:,199))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[41,2,4,16],[nMW,0,nMW,0],4,1,wf8(:,46))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,46),G0H8(9),m3h8x8(:,9),heltab2x64(:,:,200))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[48,4,1,10],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(19),m3h4x16(:,85),heltab2x64(:,:,201))
  call Hloop_Q_A(ntryL,G0H16(19),48,0,G1H16(43),n2h16(87))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[48,4,1,10],[0,nMZ,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(19),ngZn,m3h4x16(:,86),heltab2x64(:,:,202))
  call Hloop_Q_A(ntryL,G0H16(19),48,0,G1H16(44),n2h16(88))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[48,4,1,10],[0,nMW,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(19),ngZl,m3h4x16(:,87),heltab2x64(:,:,203))
  call Hloop_Q_A(ntryL,G0H16(19),48,0,G1H16(45),n2h16(89))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(19),m3h4x16(:,88),heltab2x64(:,:,204))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[48,4,1,10],[nMZ,0,nMZ,nMH],4,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(20),m3h4x16(:,89),heltab2x64(:,:,205))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(21),m3h4x16(:,90),heltab2x64(:,:,206))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(46),m3h4x16(:,91),heltab2x64(:,:,207))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(47),m3h4x16(:,92),heltab2x64(:,:,208))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[48,1,4,10],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(22),m3h4x16(:,93),heltab2x64(:,:,209))
  call Hloop_A_Q(ntryL,G0H16(22),48,0,G1H16(48),n2h16(90))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[48,1,4,10],[0,nMZ,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(22),ngZn,m3h4x16(:,94),heltab2x64(:,:,210))
  call Hloop_A_Q(ntryL,G0H16(22),48,0,G1H16(49),n2h16(91))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[48,1,4,10],[0,nMW,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(22),ngZl,m3h4x16(:,95),heltab2x64(:,:,211))
  call Hloop_A_Q(ntryL,G0H16(22),48,0,G1H16(50),n2h16(92))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(22),m3h4x16(:,96),heltab2x64(:,:,212))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[48,1,4,10],[nMZ,0,nMZ,nMH],4,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(23),m3h4x16(:,97),heltab2x64(:,:,213))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(24),m3h4x16(:,98),heltab2x64(:,:,214))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(51),m3h4x16(:,99),heltab2x64(:,:,215))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(52),m3h4x16(:,100),heltab2x64(:,:,216))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[48,1,10,4],[nMW,0,0,nMW],4,2,wf4(:,7),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(53),m3h4x16(:,101),heltab2x64(:,:,217))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[48,1,10,4],[nMW,0,0,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(54),m3h4x16(:,102),heltab2x64(:,:,218))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[48,1,10,4],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(25),m3h4x16(:,103),heltab2x64(:,:,219))
  call Hloop_A_Q(ntryL,G0H16(25),48,0,G1H16(55),n2h16(93))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[48,1,10,4],[0,nMW,nMW,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(25),ngZl,m3h4x16(:,104),heltab2x64(:,:,220))
  call Hloop_A_Q(ntryL,G0H16(25),48,0,G1H16(56),n2h16(94))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[32,11,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,29))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(42),ngZu,m3h2x32(:,108),heltab2x64(:,:,221))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[32,11,4,16],[nMW,0,nMW,0],4,1,wf8(:,29))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,109),heltab2x64(:,:,222))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,4,11,16],[nMZ,0,nMZ,0],4,1,wf8(:,29))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(44),ngZu,m3h2x32(:,110),heltab2x64(:,:,223))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[32,14,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,94))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(45),ngZu,m3h2x32(:,111),heltab2x64(:,:,224))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,1,14,16],[nMZ,0,nMZ,0],4,1,wf8(:,94))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(46),ngZu,m3h2x32(:,112),heltab2x64(:,:,225))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[32,1,14,16],[nMW,0,nMW,0],4,1,wf8(:,94))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,113),heltab2x64(:,:,226))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,1,4,26],[nMZ,0,nMZ,0],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(48),ngZu,m3h2x32(:,114),heltab2x64(:,:,227))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,1,4,26],[nMW,0,nMW,0],4,1,wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,115),heltab2x64(:,:,228))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,4,1,26],[nMZ,0,nMZ,0],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(50),ngZu,m3h2x32(:,116),heltab2x64(:,:,229))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[42,4,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,36))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,36),G0H8(10),ngZu,m3h8x8(:,10),heltab2x64(:,:,230))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[42,1,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,36))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,36),G0H8(11),ngZu,m3h8x8(:,11),heltab2x64(:,:,231))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[42,1,4,16],[nMW,0,nMW,0],4,1,wf8(:,36))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,36),G0H8(12),m3h8x8(:,12),heltab2x64(:,:,232))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[49,4,2,8],[nMZ,0,nMZ,0],4,1,wf8(:,23))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,23),G0H8(13),ngZn,m3h8x8(:,13),heltab2x64(:,:,233))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[49,4,2,8],[nMW,0,nMW,0],4,1,wf8(:,23))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,23),G0H8(14),m3h8x8(:,14),heltab2x64(:,:,234))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[49,4,2,8],[0,nMZ,0,nMZ],4,1,wf8(:,23))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,23),G0H8(15),ngZn,m3h8x8(:,15),heltab2x64(:,:,235))
  call Hloop_Q_A(ntryL,G0H8(15),49,0,G1H8(6),n2h8(7))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[49,4,2,8],[0,nMW,0,nMW],4,1,wf8(:,23))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,23),G0H8(15),m3h8x8(:,16),heltab2x64(:,:,236))
  call Hloop_Q_A(ntryL,G0H8(15),49,0,G1H8(7),n2h8(8))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[49,2,4,8],[nMZ,0,nMZ,0],4,1,wf8(:,23))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,23),G0H8(15),ngZn,m3h8x8(:,17),heltab2x64(:,:,237))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[49,2,8,4],[nMZ,0,nMZ,0],4,1,wf8(:,23))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,23),G0H8(16),ngZn,m3h8x8(:,18),heltab2x64(:,:,238))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[50,4,1,8],[nMZ,0,nMZ,0],4,1,wf8(:,12))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,12),G0H8(17),ngZn,m3h8x8(:,19),heltab2x64(:,:,239))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[50,4,1,8],[nMW,0,nMW,0],4,1,wf8(:,12))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,12),G0H8(18),m3h8x8(:,20),heltab2x64(:,:,240))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[50,4,1,8],[0,nMZ,0,nMZ],4,1,wf8(:,12))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,12),G0H8(19),ngZn,m3h8x8(:,21),heltab2x64(:,:,241))
  call Hloop_Q_A(ntryL,G0H8(19),50,0,G1H8(8),n2h8(9))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[50,4,1,8],[0,nMW,0,nMW],4,1,wf8(:,12))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,12),G0H8(19),m3h8x8(:,22),heltab2x64(:,:,242))
  call Hloop_Q_A(ntryL,G0H8(19),50,0,G1H8(9),n2h8(10))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[50,1,4,8],[nMZ,0,nMZ,0],4,1,wf8(:,12))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,12),G0H8(19),ngZn,m3h8x8(:,23),heltab2x64(:,:,243))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[50,1,8,4],[nMZ,0,nMZ,0],4,1,wf8(:,12))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,12),G0H8(20),ngZn,m3h8x8(:,24),heltab2x64(:,:,244))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[52,2,1,8],[0,nMZ,0,nMZ],4,1,wf8(:,70))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,70),G0H8(21),ngZn,m3h8x8(:,25),heltab2x64(:,:,245))
  call Hloop_A_Q(ntryL,G0H8(21),52,0,G1H8(10),n2h8(11))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[52,1,2,8],[0,nMZ,0,nMZ],4,1,wf8(:,70))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,70),G0H8(21),ngZn,m3h8x8(:,26),heltab2x64(:,:,246))
  call Hloop_A_Q(ntryL,G0H8(21),52,0,G1H8(11),n2h8(12))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[52,1,8,2],[nMZ,0,nMZ,0],4,1,wf8(:,70))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,70),G0H8(21),ngZn,m3h8x8(:,27),heltab2x64(:,:,247))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[52,1,8,2],[nMW,0,nMW,0],4,1,wf8(:,70))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,70),G0H8(22),m3h8x8(:,28),heltab2x64(:,:,248))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[52,1,8,2],[0,nMZ,0,nMZ],4,1,wf8(:,70))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,70),G0H8(23),ngZn,m3h8x8(:,29),heltab2x64(:,:,249))
  call Hloop_A_Q(ntryL,G0H8(23),52,0,G1H8(12),n2h8(13))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[52,1,8,2],[0,nMW,0,nMW],4,1,wf8(:,70))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,70),G0H8(23),m3h8x8(:,30),heltab2x64(:,:,250))
  call Hloop_A_Q(ntryL,G0H8(23),52,0,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[56,2,1,4],[0,nMZ,0,nMZ],4,1,wf8(:,61))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,61),G0H8(23),ngZn,m3h8x8(:,31),heltab2x64(:,:,251))
  call Hloop_A_Q(ntryL,G0H8(23),56,0,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[56,1,2,4],[0,nMZ,0,nMZ],4,1,wf8(:,61))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,61),G0H8(23),ngZn,m3h8x8(:,32),heltab2x64(:,:,252))
  call Hloop_A_Q(ntryL,G0H8(23),56,0,G1H8(17),n2h8(16))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[56,1,4,2],[nMZ,0,nMZ,0],4,1,wf8(:,61))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,61),G0H8(23),ngZn,m3h8x8(:,33),heltab2x64(:,:,253))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[56,1,4,2],[nMW,0,nMW,0],4,1,wf8(:,61))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,61),G0H8(24),m3h8x8(:,34),heltab2x64(:,:,254))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[56,1,4,2],[0,nMZ,0,nMZ],4,1,wf8(:,61))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,61),G0H8(25),ngZn,m3h8x8(:,35),heltab2x64(:,:,255))
  call Hloop_A_Q(ntryL,G0H8(25),56,0,G1H8(18),n2h8(17))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[56,1,4,2],[0,nMW,0,nMW],4,1,wf8(:,61))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,61),G0H8(25),m3h8x8(:,36),heltab2x64(:,:,256))
  call Hloop_A_Q(ntryL,G0H8(25),56,0,G1H8(20),n2h8(18))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(3),[G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(6),[G0H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(22),[G1H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(9),[G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(12),[G0H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(26),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(15),[G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(33),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(18),[G0H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(40),[G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(45),[G1H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(21),[G0H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(47),[G1H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(50),[G1H16(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(24),[G0H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G1H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(54),[G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(56),[G1H16(55)])
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,7),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(1),n2h8(19))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,2),G1H8(13),ngZu,m3h4x8(:,8),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(13),42,0,G2H8(2),n2h8(20))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,2),G1H8(16),ngZd,m3h4x8(:,9),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(16),42,0,G2H8(3),n2h8(21))
  call Hloop_VV_S(ntryL,G0H32(5),wf4(:,2),G0H8(25),m3h4x8(:,10),heltab2x32(:,:,56))
  call Hloop_VV_S(ntryL,G0H32(6),wf4(:,2),G0H8(26),m3h4x8(:,11),heltab2x32(:,:,57))
  call Hloop_UV_W(ntryL,G0H32(7),32,wf4(:,2),10,G1H8(19),m3h4x8(:,12),heltab2x32(:,:,58))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,1),G1H8(3),ngZu,m3h4x8(:,13),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(3),37,0,G2H8(4),n2h8(22))
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,1),G1H8(2),ngZu,m3h4x8(:,14),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(2),37,0,G2H8(5),n2h8(23))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,1),G1H8(21),ngZd,m3h4x8(:,15),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(21),37,0,G2H8(6),n2h8(24))
  call Hloop_VV_S(ntryL,G0H32(12),wf4(:,1),G0H8(27),m3h4x8(:,16),heltab2x32(:,:,62))
  call Hloop_VV_S(ntryL,G0H32(13),wf4(:,1),G0H8(28),m3h4x8(:,17),heltab2x32(:,:,63))
  call Hloop_UV_W(ntryL,G0H32(14),32,wf4(:,1),5,G1H8(4),m3h4x8(:,18),heltab2x32(:,:,64))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,1),G1H8(22),ngZd,m3h4x8(:,19),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(22),37,0,G2H8(7),n2h8(25))
  call Hloop_UV_W(ntryL,G0H32(16),32,wf4(:,1),5,G1H8(23),m3h4x8(:,20),heltab2x32(:,:,66))
  call Hloop_AZ_Q(ntryL,G1H16(3),wf4(:,1),G1H4(1),ngZl,m3h4x4(:,13),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(10),n2h4(65))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,1),G1H4(2),ngZn,m3h4x4(:,14),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(11),n2h4(66))
  call Hloop_SV_V(ntryL,G0H16(3),wf4(:,1),G0H4(1),m3h4x4(:,15),heltab2x16(:,:,65))
  call Hloop_SV_V(ntryL,G0H16(2),wf4(:,1),G0H4(2),m3h4x4(:,16),heltab2x16(:,:,66))
  call Hloop_UV_W(ntryL,G1H16(7),48,wf4(:,1),5,G2H4(12),m3h4x4(:,17),heltab2x16(:,:,67))
  call Hloop_AQ_W(ntryL,G1H16(12),ex2(:),G1H8(24),m3h2x8(:,51),heltab2x16(:,:,68))
  call Hloop_AQ_Z(ntryL,G1H16(9),ex2(:),G1H8(5),ngZn,m3h2x8(:,52),heltab2x16(:,:,69))
  call Hloop_WQ_A(ntryL,G0H16(6),ex2(:),G0H8(29),m3h2x8(:,53),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G0H8(29),50,0,G1H8(25),n2h8(26))
  call Hloop_ZQ_A(ntryL,G0H16(5),ex2(:),G0H8(29),ngZn,m3h2x8(:,54),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G0H8(29),50,0,G1H8(26),n2h8(27))
  call Hloop_WQ_A(ntryL,G1H16(14),ex2(:),G1H8(27),m3h2x8(:,55),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(27),50,0,G2H8(8),n2h8(28))
  call Hloop_WQ_A(ntryL,G1H16(16),ex2(:),G1H8(1),m3h2x8(:,56),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(1),50,0,G2H8(9),n2h8(29))
  call Hloop_AQ_W(ntryL,G1H16(22),ex2(:),G1H8(13),m3h2x8(:,57),heltab2x16(:,:,74))
  call Hloop_ZQ_A(ntryL,G0H32(17),wf8(:,9),G0H4(3),ngZn,m3h8x4(:,1),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H4(3),39,0,G1H4(8),n2h4(67))
  call Hloop_WQ_A(ntryL,G0H32(18),wf8(:,9),G0H4(3),m3h8x4(:,2),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H4(3),39,0,G1H4(11),n2h4(68))
  call Hloop_ZA_Q(ntryL,G0H32(19),ex4(:),G0H16(25),ngZn,m3h2x16(:,47),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(25),40,0,G1H16(1),n2h16(95))
  call Hloop_ZA_Q(ntryL,G0H32(20),wf8(:,58),G0H4(3),ngZn,m3h8x4(:,3),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H4(3),45,0,G1H4(12),n2h4(69))
  call Hloop_ZQ_A(ntryL,G0H32(1),ex2(:),G0H16(1),ngZn,m3h2x16(:,48),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(4),n2h16(96))
  call Hloop_WQ_A(ntryL,G0H32(9),ex2(:),G0H16(4),m3h2x16(:,49),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(4),34,0,G1H16(6),n2h16(97))
  call Hloop_ZQ_A(ntryL,G0H32(21),ex2(:),G0H16(7),ngZn,m3h2x16(:,50),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(11),n2h16(98))
  call Hloop_WQ_A(ntryL,G0H32(22),ex2(:),G0H16(10),m3h2x16(:,51),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(17),n2h16(99))
  call Hloop_ZA_Q(ntryL,G0H32(23),ex4(:),G0H16(13),ngZn,m3h2x16(:,52),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(13),40,0,G1H16(19),n2h16(100))
  call Hloop_ZA_Q(ntryL,G0H8(1),ex4(:),G0H4(3),ngZn,m3h2x4(:,53),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G0H4(3),45,0,G1H4(18),n2h4(70))
  call Hloop_ZQ_A(ntryL,G0H8(2),ex2(:),G0H4(3),ngZn,m3h2x4(:,54),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G0H4(3),39,0,G1H4(19),n2h4(71))
  call Hloop_WQ_A(ntryL,G0H8(3),ex2(:),G0H4(3),m3h2x4(:,55),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G0H4(3),39,0,G1H4(20),n2h4(72))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,5),G1H8(16),ngZu,m3h4x8(:,21),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(16),38,0,G2H8(10),n2h8(30))
  call Hloop_AZ_Q(ntryL,G1H32(9),wf4(:,5),G1H8(3),ngZu,m3h4x8(:,22),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(11),n2h8(31))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,5),G1H8(2),ngZd,m3h4x8(:,23),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(12),n2h8(32))
  call Hloop_VV_S(ntryL,G0H32(27),wf4(:,5),G0H8(29),m3h4x8(:,24),heltab2x32(:,:,79))
  call Hloop_VV_S(ntryL,G0H32(28),wf4(:,5),G0H8(1),m3h4x8(:,25),heltab2x32(:,:,80))
  call Hloop_UV_W(ntryL,G0H32(29),32,wf4(:,5),6,G1H8(21),m3h4x8(:,26),heltab2x32(:,:,81))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf4(:,4),G1H8(22),ngZu,m3h4x8(:,27),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(22),41,0,G2H8(13),n2h8(33))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,4),G1H8(27),ngZu,m3h4x8(:,28),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(27),41,0,G2H8(14),n2h8(34))
  call Hloop_AZ_Q(ntryL,G1H32(13),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,29),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(1),41,0,G2H8(15),n2h8(35))
  call Hloop_VV_S(ntryL,G0H32(4),wf4(:,4),G0H8(2),m3h4x8(:,30),heltab2x32(:,:,85))
  call Hloop_VV_S(ntryL,G0H32(8),wf4(:,4),G0H8(3),m3h4x8(:,31),heltab2x32(:,:,86))
  call Hloop_UV_W(ntryL,G0H32(10),32,wf4(:,4),9,G1H8(16),m3h4x8(:,32),heltab2x32(:,:,87))
  call Hloop_UV_W(ntryL,G0H32(11),32,wf4(:,5),6,G1H8(3),m3h4x8(:,33),heltab2x32(:,:,88))
  call Hloop_AZ_Q(ntryL,G1H32(14),wf4(:,5),G1H8(2),ngZd,m3h4x8(:,34),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(16),n2h8(36))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,5),G1H4(26),ngZl,m3h4x4(:,18),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(26),54,0,G2H4(13),n2h4(73))
  call Hloop_AZ_Q(ntryL,G1H16(24),wf4(:,5),G1H4(29),ngZn,m3h4x4(:,19),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(29),54,0,G2H4(14),n2h4(74))
  call Hloop_SV_V(ntryL,G0H16(9),wf4(:,5),G0H4(3),m3h4x4(:,20),heltab2x16(:,:,77))
  call Hloop_SV_V(ntryL,G0H16(8),wf4(:,5),G0H4(4),m3h4x4(:,21),heltab2x16(:,:,78))
  call Hloop_UV_W(ntryL,G1H16(10),48,wf4(:,5),6,G2H4(15),m3h4x4(:,22),heltab2x16(:,:,79))
  call Hloop_AQ_W(ntryL,G1H16(18),ex1(:),G1H8(22),m3h2x8(:,58),heltab2x16(:,:,80))
  call Hloop_AQ_Z(ntryL,G1H16(15),ex1(:),G1H8(27),ngZn,m3h2x8(:,59),heltab2x16(:,:,81))
  call Hloop_WQ_A(ntryL,G0H16(12),ex1(:),G0H8(30),m3h2x8(:,60),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G0H8(30),49,0,G1H8(1),n2h8(37))
  call Hloop_ZQ_A(ntryL,G0H16(11),ex1(:),G0H8(30),ngZn,m3h2x8(:,61),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G0H8(30),49,0,G1H8(2),n2h8(38))
  call Hloop_WQ_A(ntryL,G1H16(23),ex1(:),G1H8(28),m3h2x8(:,62),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(28),49,0,G2H8(17),n2h8(39))
  call Hloop_WQ_A(ntryL,G1H16(26),ex1(:),G1H8(28),m3h2x8(:,63),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(28),49,0,G2H8(18),n2h8(40))
  call Hloop_AQ_W(ntryL,G1H16(28),ex1(:),G1H8(28),m3h2x8(:,64),heltab2x16(:,:,86))
  call Hloop_ZQ_A(ntryL,G0H32(24),wf8(:,20),G0H4(5),ngZn,m3h8x4(:,4),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G0H4(5),39,0,G1H4(30),n2h4(75))
  call Hloop_WQ_A(ntryL,G0H32(25),wf8(:,20),G0H4(5),m3h8x4(:,5),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G0H4(5),39,0,G1H4(36),n2h4(76))
  call Hloop_ZA_Q(ntryL,G0H32(26),ex4(:),G0H16(16),ngZn,m3h2x16(:,53),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G0H16(16),40,0,G1H16(21),n2h16(101))
  call Hloop_ZA_Q(ntryL,G0H32(30),wf8(:,85),G0H4(5),ngZn,m3h8x4(:,6),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H4(5),46,0,G1H4(37),n2h4(77))
  call Hloop_ZQ_A(ntryL,G0H32(2),ex1(:),G0H16(19),ngZn,m3h2x16(:,54),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(19),33,0,G1H16(8),n2h16(102))
  call Hloop_WQ_A(ntryL,G0H32(3),ex1(:),G0H16(22),m3h2x16(:,55),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G0H16(22),33,0,G1H16(13),n2h16(103))
  call Hloop_ZQ_A(ntryL,G0H32(15),ex1(:),G0H16(3),ngZn,m3h2x16(:,56),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G0H16(3),33,0,G1H16(20),n2h16(104))
  call Hloop_WQ_A(ntryL,G0H32(31),ex1(:),G0H16(2),m3h2x16(:,57),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(25),n2h16(105))
  call Hloop_ZA_Q(ntryL,G0H32(32),ex4(:),G0H16(6),ngZn,m3h2x16(:,58),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G0H16(6),40,0,G1H16(27),n2h16(106))
  call Hloop_ZA_Q(ntryL,G0H8(4),ex4(:),G0H4(5),ngZn,m3h2x4(:,56),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G0H4(5),46,0,G1H4(38),n2h4(78))
  call Hloop_ZQ_A(ntryL,G0H8(5),ex1(:),G0H4(5),ngZn,m3h2x4(:,57),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G0H4(5),39,0,G1H4(42),n2h4(79))
  call Hloop_WQ_A(ntryL,G0H8(6),ex1(:),G0H4(5),m3h2x4(:,58),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G0H4(5),39,0,G1H4(43),n2h4(80))
  call Hloop_QA_W(ntryL,G1H16(31),ex3(:),G1H8(29),m3h2x8(:,65),heltab2x16(:,:,87))
  call Hloop_QA_Z(ntryL,G1H16(30),ex3(:),G1H8(30),ngZn,m3h2x8(:,66),heltab2x16(:,:,88))
  call Hloop_WA_Q(ntryL,G0H16(15),ex3(:),G0H8(30),m3h2x8(:,67),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G0H8(30),52,0,G1H8(31),n2h8(41))
  call Hloop_ZA_Q(ntryL,G0H16(14),ex3(:),G0H8(4),ngZn,m3h2x8(:,68),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G0H8(4),52,0,G1H8(32),n2h8(42))
  call Hloop_WA_Q(ntryL,G1H16(33),ex3(:),G1H8(33),m3h2x8(:,69),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(33),52,0,G2H8(19),n2h8(43))
  call Hloop_AQ_W(ntryL,G1H16(36),ex2(:),G1H8(33),m3h2x8(:,70),heltab2x16(:,:,92))
  call Hloop_AQ_Z(ntryL,G1H16(35),ex2(:),G1H8(34),ngZn,m3h2x8(:,71),heltab2x16(:,:,93))
  call Hloop_WQ_A(ntryL,G0H16(18),ex2(:),G0H8(5),m3h2x8(:,72),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H8(5),50,0,G1H8(35),n2h8(44))
  call Hloop_ZQ_A(ntryL,G0H16(17),ex2(:),G0H8(6),ngZn,m3h2x8(:,73),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G0H8(6),50,0,G1H8(36),n2h8(45))
  call Hloop_WQ_A(ntryL,G1H16(38),ex2(:),G1H8(37),m3h2x8(:,74),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(37),50,0,G2H8(20),n2h8(46))
  call Hloop_WQ_A(ntryL,G1H16(40),ex2(:),G1H8(37),m3h2x8(:,75),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(37),50,0,G2H8(21),n2h8(47))
  call Hloop_AQ_W(ntryL,G1H16(42),ex2(:),G1H8(37),m3h2x8(:,76),heltab2x16(:,:,98))
  call Hloop_ZQ_A(ntryL,G0H32(33),wf8(:,26),G0H4(5),ngZn,m3h8x4(:,7),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G0H4(5),43,0,G1H4(44),n2h4(81))
  call Hloop_WQ_A(ntryL,G0H32(34),wf8(:,26),G0H4(5),m3h8x4(:,8),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G0H4(5),43,0,G1H4(48),n2h4(82))
  call Hloop_ZA_Q(ntryL,G0H32(35),ex3(:),G0H16(5),ngZn,m3h2x16(:,59),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(5),36,0,G1H16(29),n2h16(107))
  call Hloop_ZA_Q(ntryL,G0H32(36),wf8(:,68),G0H4(5),ngZn,m3h8x4(:,9),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H4(5),45,0,G1H4(49),n2h4(83))
  call Hloop_ZQ_A(ntryL,G0H32(37),ex2(:),G0H16(25),ngZn,m3h2x16(:,60),heltab2x32(:,:,103))
  call Hloop_Q_A(ntryL,G0H16(25),34,0,G1H16(32),n2h16(108))
  call Hloop_WQ_A(ntryL,G0H32(38),ex2(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,104))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(34),n2h16(109))
  call Hloop_ZQ_A(ntryL,G0H32(39),ex2(:),G0H16(4),ngZn,m3h2x16(:,62),heltab2x32(:,:,105))
  call Hloop_Q_A(ntryL,G0H16(4),34,0,G1H16(37),n2h16(110))
  call Hloop_WQ_A(ntryL,G0H32(40),ex2(:),G0H16(7),m3h2x16(:,63),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(39),n2h16(111))
  call Hloop_ZA_Q(ntryL,G0H32(41),ex3(:),G0H16(10),ngZn,m3h2x16(:,64),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(10),36,0,G1H16(41),n2h16(112))
  call Hloop_ZA_Q(ntryL,G0H8(7),ex3(:),G0H4(5),ngZn,m3h2x4(:,59),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G0H4(5),45,0,G1H4(50),n2h4(84))
  call Hloop_ZQ_A(ntryL,G0H8(8),ex2(:),G0H4(5),ngZn,m3h2x4(:,60),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G0H4(5),43,0,G1H4(54),n2h4(85))
  call Hloop_WQ_A(ntryL,G0H8(9),ex2(:),G0H4(5),m3h2x4(:,61),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G0H4(5),43,0,G1H4(55),n2h4(86))
  call Hloop_QA_W(ntryL,G1H16(45),ex3(:),G1H8(38),m3h2x8(:,77),heltab2x16(:,:,99))
  call Hloop_QA_Z(ntryL,G1H16(44),ex3(:),G1H8(39),ngZn,m3h2x8(:,78),heltab2x16(:,:,100))
  call Hloop_WA_Q(ntryL,G0H16(21),ex3(:),G0H8(30),m3h2x8(:,79),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G0H8(30),52,0,G1H8(40),n2h8(48))
  call Hloop_ZA_Q(ntryL,G0H16(20),ex3(:),G0H8(4),ngZn,m3h2x8(:,80),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G0H8(4),52,0,G1H8(41),n2h8(49))
  call Hloop_WA_Q(ntryL,G1H16(47),ex3(:),G1H8(42),m3h2x8(:,81),heltab2x16(:,:,103))
  call Hloop_A_Q(ntryL,G1H8(42),52,0,G2H8(22),n2h8(50))
  call Hloop_AQ_W(ntryL,G1H16(50),ex1(:),G1H8(42),m3h2x8(:,82),heltab2x16(:,:,104))
  call Hloop_AQ_Z(ntryL,G1H16(49),ex1(:),G1H8(43),ngZn,m3h2x8(:,83),heltab2x16(:,:,105))
  call Hloop_WQ_A(ntryL,G0H16(24),ex1(:),G0H8(5),m3h2x8(:,84),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G0H8(5),49,0,G1H8(44),n2h8(51))
  call Hloop_ZQ_A(ntryL,G0H16(23),ex1(:),G0H8(6),ngZn,m3h2x8(:,85),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G0H8(6),49,0,G1H8(45),n2h8(52))
  call Hloop_WQ_A(ntryL,G1H16(52),ex1(:),G1H8(46),m3h2x8(:,86),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(46),49,0,G2H8(23),n2h8(53))
  call Hloop_WQ_A(ntryL,G1H16(54),ex1(:),G1H8(46),m3h2x8(:,87),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(46),49,0,G2H8(24),n2h8(54))
  call Hloop_AQ_W(ntryL,G1H16(56),ex1(:),G1H8(46),m3h2x8(:,88),heltab2x16(:,:,110))
  call Hloop_ZQ_A(ntryL,G0H32(42),wf8(:,29),G0H4(5),ngZn,m3h8x4(:,10),heltab2x32(:,:,108))
  call Hloop_Q_A(ntryL,G0H4(5),43,0,G1H4(56),n2h4(87))
  call Hloop_WQ_A(ntryL,G0H32(43),wf8(:,29),G0H4(5),m3h8x4(:,11),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G0H4(5),43,0,G1H4(60),n2h4(88))
  call Hloop_ZA_Q(ntryL,G0H32(44),ex3(:),G0H16(13),ngZn,m3h2x16(:,65),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(43),n2h16(113))
  call Hloop_ZA_Q(ntryL,G0H32(45),wf8(:,94),G0H4(5),ngZn,m3h8x4(:,12),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G0H4(5),46,0,G1H4(61),n2h4(89))
  call Hloop_ZQ_A(ntryL,G0H32(46),ex1(:),G0H16(9),ngZn,m3h2x16(:,66),heltab2x32(:,:,112))
  call Hloop_Q_A(ntryL,G0H16(9),33,0,G1H16(46),n2h16(114))
  call Hloop_WQ_A(ntryL,G0H32(47),ex1(:),G0H16(8),m3h2x16(:,67),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G0H16(8),33,0,G1H16(48),n2h16(115))
  call Hloop_ZQ_A(ntryL,G0H32(48),ex1(:),G0H16(12),ngZn,m3h2x16(:,68),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H16(12),33,0,G1H16(51),n2h16(116))
  call Hloop_WQ_A(ntryL,G0H32(49),ex1(:),G0H16(11),m3h2x16(:,69),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G0H16(11),33,0,G1H16(53),n2h16(117))
  call Hloop_ZA_Q(ntryL,G0H32(50),ex3(:),G0H16(16),ngZn,m3h2x16(:,70),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(16),36,0,G1H16(55),n2h16(118))
  call Hloop_ZA_Q(ntryL,G0H8(10),ex3(:),G0H4(5),ngZn,m3h2x4(:,62),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G0H4(5),46,0,G1H4(62),n2h4(90))
  call Hloop_ZQ_A(ntryL,G0H8(11),ex1(:),G0H4(5),ngZn,m3h2x4(:,63),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G0H4(5),43,0,G1H4(66),n2h4(91))
  call Hloop_WQ_A(ntryL,G0H8(12),ex1(:),G0H4(5),m3h2x4(:,64),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G0H4(5),43,0,G1H4(67),n2h4(92))
  call Hloop_ZA_Q(ntryL,G0H8(13),ex3(:),G0H4(5),ngZn,m3h2x4(:,65),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G0H4(5),53,0,G1H4(68),n2h4(93))
  call Hloop_WA_Q(ntryL,G0H8(14),ex3(:),G0H4(5),m3h2x4(:,66),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G0H4(5),53,0,G1H4(72),n2h4(94))
  call Hloop_QA_Z(ntryL,G1H8(6),ex3(:),G1H4(1),ngZn,m3h2x4(:,67),heltab2x8(:,:,71))
  call Hloop_QA_W(ntryL,G1H8(7),ex3(:),G1H4(2),m3h2x4(:,68),heltab2x8(:,:,72))
  call Hloop_ZQ_A(ntryL,G0H8(15),ex2(:),G0H4(5),ngZn,m3h2x4(:,69),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G0H4(5),51,0,G1H4(26),n2h4(95))
  call Hloop_ZQ_A(ntryL,G0H8(16),ex2(:),G0H4(5),ngZn,m3h2x4(:,70),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G0H4(5),51,0,G1H4(29),n2h4(96))
  call Hloop_ZA_Q(ntryL,G0H8(17),ex3(:),G0H4(5),ngZn,m3h2x4(:,71),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G0H4(5),54,0,G1H4(73),n2h4(97))
  call Hloop_WA_Q(ntryL,G0H8(18),ex3(:),G0H4(5),m3h2x4(:,72),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G0H4(5),54,0,G1H4(74),n2h4(98))
  call Hloop_QA_Z(ntryL,G1H8(8),ex3(:),G1H4(75),ngZn,m3h2x4(:,73),heltab2x8(:,:,77))
  call Hloop_QA_W(ntryL,G1H8(9),ex3(:),G1H4(76),m3h2x4(:,74),heltab2x8(:,:,78))
  call Hloop_ZQ_A(ntryL,G0H8(19),ex1(:),G0H4(5),ngZn,m3h2x4(:,75),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G0H4(5),51,0,G1H4(77),n2h4(99))
  call Hloop_ZQ_A(ntryL,G0H8(20),ex1(:),G0H4(5),ngZn,m3h2x4(:,76),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G0H4(5),51,0,G1H4(78),n2h4(100))
  call Hloop_AQ_Z(ntryL,G1H8(10),ex2(:),G1H4(79),ngZn,m3h2x4(:,77),heltab2x8(:,:,81))
  call Hloop_AQ_Z(ntryL,G1H8(11),ex1(:),G1H4(80),ngZn,m3h2x4(:,78),heltab2x8(:,:,82))
  call Hloop_ZQ_A(ntryL,G0H8(21),ex1(:),G0H4(5),ngZn,m3h2x4(:,79),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G0H4(5),53,0,G1H4(81),n2h4(101))
  call Hloop_WQ_A(ntryL,G0H8(22),ex1(:),G0H4(5),m3h2x4(:,80),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G0H4(5),53,0,G1H4(82),n2h4(102))
  call Hloop_AQ_Z(ntryL,G1H8(12),ex1(:),G1H4(83),ngZn,m3h2x4(:,81),heltab2x8(:,:,85))
  call Hloop_AQ_W(ntryL,G1H8(14),ex1(:),G1H4(84),m3h2x4(:,82),heltab2x8(:,:,86))
  call Hloop_AQ_Z(ntryL,G1H8(15),ex2(:),G1H4(85),ngZn,m3h2x4(:,83),heltab2x8(:,:,87))
  call Hloop_AQ_Z(ntryL,G1H8(17),ex1(:),G1H4(86),ngZn,m3h2x4(:,84),heltab2x8(:,:,88))
  call Hloop_ZQ_A(ntryL,G0H8(23),ex1(:),G0H4(5),ngZn,m3h2x4(:,85),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G0H4(5),57,0,G1H4(87),n2h4(103))
  call Hloop_WQ_A(ntryL,G0H8(24),ex1(:),G0H4(5),m3h2x4(:,86),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G0H4(5),57,0,G1H4(88),n2h4(104))
  call Hloop_AQ_Z(ntryL,G1H8(18),ex1(:),G1H4(89),ngZn,m3h2x4(:,87),heltab2x8(:,:,91))
  call Hloop_AQ_W(ntryL,G1H8(20),ex1(:),G1H4(90),m3h2x4(:,88),heltab2x8(:,:,92))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(16),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(28),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(48)])
  call Hloop_ZQ_A(ntryL,G1H4(3),ex2(:),G1H2(73),ngZn,m3h2x2(:,73),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(73),55,0,G2H2(3),n2h2(19))
  call Hloop_ZQ_A(ntryL,G1H4(4),ex2(:),G1H2(74),ngZn,m3h2x2(:,74),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(74),55,0,G2H2(4),n2h2(20))
  call Hloop_ZQ_A(ntryL,G1H4(9),ex1(:),G1H2(86),ngZn,m3h2x2(:,75),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(86),55,0,G2H2(7),n2h2(21))
  call Hloop_ZQ_A(ntryL,G1H4(10),ex1(:),G1H2(91),ngZn,m3h2x2(:,76),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(91),55,0,G2H2(5),n2h2(22))
  call Hloop_WQ_A(ntryL,G1H4(76),ex1(:),G1H2(92),m3h2x2(:,77),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(92),55,0,G2H2(11),n2h2(23))
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(149),mass4set(:,1),  & 
G1H4(15),G1H4(16),G1H4(27),G1H4(28),G1H4(8),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hloop_WQ_A(ntryL,G1H4(21),ex1(:),G1H2(104),m3h2x2(:,78),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(104),59,0,G2H2(13),n2h2(24))
  call Hloop_WQ_A(ntryL,G1H4(22),ex1(:),G1H2(109),m3h2x2(:,79),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(109),59,0,G2H2(14),n2h2(25))
  call Hloop_WQ_A(ntryL,G1H4(2),ex2(:),G1H2(110),m3h2x2(:,80),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(110),55,0,G2H2(17),n2h2(26))
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(142),mass4set(:,1),  & 
G1H4(11),G1H4(12),G1H4(37),G1H4(44),G1H4(48),4)
  call HG1shiftOLR(G1H4(12),8,4)
  call Hloop_WQ_A(ntryL,G1H4(33),ex2(:),G1H2(7),m3h2x2(:,81),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(7),59,0,G2H2(15),n2h2(27))
  call Hloop_WQ_A(ntryL,G1H4(34),ex2(:),G1H2(8),m3h2x2(:,82),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(8),59,0,G2H2(1),n2h2(28))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(7),mass4set(:,2),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(7),16,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(7),mass4set(:,3),  & 
G1H8(11),G1H8(12),G1H8(14),G1H8(15),G1H8(17),8)
  call HG1shiftOLR(G1H8(12),16,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(7),mass4set(:,4),  & 
G1H8(18),G1H8(20),G1H8(47),G1H8(48),G1H8(49),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hloop_SV_V(ntryL,G0H8(25),wf4(:,1),G0H2(1),m3h4x2(:,5),heltab2x8(:,:,93))
  call Hloop_SV_V(ntryL,G0H8(26),wf4(:,1),G0H2(2),m3h4x2(:,6),heltab2x8(:,:,94))
  call Hloop_UV_W(ntryL,G1H8(19),42,wf4(:,1),5,G2H2(8),m3h4x2(:,7),heltab2x8(:,:,95))
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(22),mass4set(:,2),  & 
G1H8(19),G1H8(50),G1H8(51),G1H8(52),G1H8(53),8)
  call HG1shiftOLR(G1H8(50),16,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(22),mass4set(:,3),  & 
G1H8(54),G1H8(55),G1H8(56),G1H8(57),G1H8(58),8)
  call HG1shiftOLR(G1H8(55),16,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(22),mass4set(:,4),  & 
G1H8(59),G1H8(60),G1H8(61),G1H8(62),G1H8(63),8)
  call HG1shiftOLR(G1H8(60),16,8)
  call Hloop_SV_V(ntryL,G0H8(27),wf4(:,2),G0H2(3),m3h4x2(:,8),heltab2x8(:,:,96))
  call Hloop_SV_V(ntryL,G0H8(28),wf4(:,2),G0H2(4),m3h4x2(:,9),heltab2x8(:,:,97))
  call Hloop_UV_W(ntryL,G1H8(4),37,wf4(:,2),10,G2H2(9),m3h4x2(:,10),heltab2x8(:,:,98))
  call Hloop_AQ_W(ntryL,G2H8(7),ex5(:),G2H4(16),m3h2x4(:,89),heltab2x8(:,:,99))
  call Hloop_WQ_A(ntryL,G1H8(23),ex5(:),G1H4(3),m3h2x4(:,90),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(17),n2h4(105))
  call Hloop_AQ_W(ntryL,G2H4(10),ex2(:),G2H2(2),m3h2x2(:,83),heltab2x4(:,:,113))
  call Hloop_AQ_Z(ntryL,G2H4(11),ex2(:),G2H2(10),ngZn,m3h2x2(:,84),heltab2x4(:,:,114))
  call Hloop_ZQ_A(ntryL,G0H4(2),ex2(:),G0H2(5),ngZn,m3h2x2(:,85),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G0H2(5),55,0,G1H2(13),n2h2(29))
  call Hloop_WA_Q(ntryL,G1H8(24),ex4(:),G1H4(4),m3h2x4(:,91),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(4),58,0,G2H4(18),n2h4(106))
  call Hloop_ZA_Q(ntryL,G1H8(5),ex4(:),G1H4(9),ngZn,m3h2x4(:,92),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(9),58,0,G2H4(19),n2h4(107))
  call Hloop_QA_W(ntryL,G1H8(25),ex4(:),G1H4(10),m3h2x4(:,93),heltab2x8(:,:,103))
  call Hloop_QA_Z(ntryL,G1H8(26),ex4(:),G1H4(76),ngZn,m3h2x4(:,94),heltab2x8(:,:,104))
  call Hloop_QA_W(ntryL,G2H8(8),ex4(:),G2H4(20),m3h2x4(:,95),heltab2x8(:,:,105))
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(155),mass4set(:,5),  & 
G1H8(4),G1H8(23),G1H8(24),G1H8(5),G1H8(25),8)
  call HG1shiftOLR(G1H8(23),8,8)
  call Hloop_UW_V(ntryL,G1H8(13),50,wf4(:,1),5,G2H2(16),m3h4x2(:,11),heltab2x8(:,:,106))
  call Hloop_QA_Z(ntryL,G1H4(30),ex4(:),G1H2(31),ngZn,m3h2x2(:,86),heltab2x4(:,:,116))
  call Hloop_QA_W(ntryL,G1H4(36),ex4(:),G1H2(32),m3h2x2(:,87),heltab2x4(:,:,117))
  call Hloop_AQ_Z(ntryL,G1H16(1),wf8(:,9),G1H2(37),ngZn,m3h8x2(:,1),heltab2x16(:,:,111))
  call Hloop_AQ_Z(ntryL,G1H4(49),ex2(:),G1H2(55),ngZn,m3h2x2(:,88),heltab2x4(:,:,118))
  call Hloop_QA_Z(ntryL,G1H16(4),wf8(:,58),G1H2(56),ngZn,m3h8x2(:,2),heltab2x16(:,:,112))
  call Hloop_QA_W(ntryL,G1H16(6),wf8(:,58),G1H2(61),m3h8x2(:,3),heltab2x16(:,:,113))
  call Hloop_QA_Z(ntryL,G1H16(11),ex4(:),G1H8(26),ngZn,m3h2x8(:,89),heltab2x16(:,:,114))
  call Hloop_QA_W(ntryL,G1H16(17),ex4(:),G1H8(13),m3h2x8(:,90),heltab2x16(:,:,115))
  call Hloop_AQ_Z(ntryL,G1H16(19),ex2(:),G1H8(64),ngZn,m3h2x8(:,91),heltab2x16(:,:,116))
  call Hloop_AQ_Z(ntryL,G1H4(18),ex2(:),G1H2(5),ngZn,m3h2x2(:,89),heltab2x4(:,:,119))
  call Hloop_QA_Z(ntryL,G1H4(19),ex4(:),G1H2(6),ngZn,m3h2x2(:,90),heltab2x4(:,:,120))
  call Hloop_QA_W(ntryL,G1H4(20),ex4(:),G1H2(10),m3h2x2(:,91),heltab2x4(:,:,121))
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(45),mass4set(:,2),  & 
G1H8(65),G1H8(66),G1H8(67),G1H8(68),G1H8(69),8)
  call HG1shiftOLR(G1H8(66),16,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(45),mass4set(:,3),  & 
G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
  call HG1shiftOLR(G1H8(71),16,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(45),mass4set(:,4),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),8)
  call HG1shiftOLR(G1H8(76),16,8)
  call Hloop_SV_V(ntryL,G0H8(29),wf4(:,4),G0H2(5),m3h4x2(:,12),heltab2x8(:,:,107))
  call Hloop_SV_V(ntryL,G0H8(1),wf4(:,4),G0H2(6),m3h4x2(:,13),heltab2x8(:,:,108))
  call Hloop_UV_W(ntryL,G1H8(21),38,wf4(:,4),9,G2H2(18),m3h4x2(:,14),heltab2x8(:,:,109))
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(35),mass4set(:,2),  & 
G1H8(21),G1H8(80),G1H8(81),G1H8(82),G1H8(83),8)
  call HG1shiftOLR(G1H8(80),16,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(35),mass4set(:,3),  & 
G1H8(84),G1H8(85),G1H8(86),G1H8(87),G1H8(88),8)
  call HG1shiftOLR(G1H8(85),16,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(35),mass4set(:,4),  & 
G1H8(89),G1H8(90),G1H8(91),G1H8(92),G1H8(93),8)
  call HG1shiftOLR(G1H8(90),16,8)
  call Hloop_SV_V(ntryL,G0H8(2),wf4(:,5),G0H2(7),m3h4x2(:,15),heltab2x8(:,:,110))
  call Hloop_SV_V(ntryL,G0H8(3),wf4(:,5),G0H2(8),m3h4x2(:,16),heltab2x8(:,:,111))
  call Hloop_UV_W(ntryL,G1H8(16),41,wf4(:,5),6,G2H2(19),m3h4x2(:,17),heltab2x8(:,:,112))
  call Hloop_WQ_A(ntryL,G1H8(3),ex5(:),G1H4(21),m3h2x4(:,96),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(21),54,0,G2H4(21),n2h4(108))
  call Hloop_AQ_W(ntryL,G2H8(16),ex5(:),G2H4(22),m3h2x4(:,97),heltab2x8(:,:,114))
  call Hloop_AQ_W(ntryL,G2H4(13),ex1(:),G2H2(12),m3h2x2(:,92),heltab2x4(:,:,122))
  call Hloop_AQ_Z(ntryL,G2H4(14),ex1(:),G2H2(20),ngZn,m3h2x2(:,93),heltab2x4(:,:,123))
  call Hloop_ZQ_A(ntryL,G0H4(4),ex1(:),G0H2(9),ngZn,m3h2x2(:,94),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G0H2(9),55,0,G1H2(18),n2h2(30))
  call Hloop_WA_Q(ntryL,G1H8(22),ex4(:),G1H4(22),m3h2x4(:,98),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(22),57,0,G2H4(23),n2h4(109))
  call Hloop_ZA_Q(ntryL,G1H8(27),ex4(:),G1H4(2),ngZn,m3h2x4(:,99),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G1H4(2),57,0,G2H4(24),n2h4(110))
  call Hloop_QA_W(ntryL,G1H8(1),ex4(:),G1H4(33),m3h2x4(:,100),heltab2x8(:,:,117))
  call Hloop_QA_Z(ntryL,G1H8(2),ex4(:),G1H4(34),ngZn,m3h2x4(:,101),heltab2x8(:,:,118))
  call Hloop_QA_W(ntryL,G2H8(17),ex4(:),G2H4(25),m3h2x4(:,102),heltab2x8(:,:,119))
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(169),mass4set(:,5),  & 
G1H8(16),G1H8(3),G1H8(22),G1H8(27),G1H8(1),8)
  call HG1shiftOLR(G1H8(3),8,8)
  call Hloop_UW_V(ntryL,G1H8(28),49,wf4(:,5),6,G2H2(6),m3h4x2(:,18),heltab2x8(:,:,120))
  call Hloop_AQ_Z(ntryL,G1H16(21),wf8(:,20),G1H2(22),ngZn,m3h8x2(:,4),heltab2x16(:,:,117))
  call Hloop_AQ_Z(ntryL,G1H4(61),ex1(:),G1H2(24),ngZn,m3h2x2(:,95),heltab2x4(:,:,125))
  call Hloop_QA_Z(ntryL,G1H16(8),wf8(:,85),G1H2(36),ngZn,m3h8x2(:,5),heltab2x16(:,:,118))
  call Hloop_QA_W(ntryL,G1H16(13),wf8(:,85),G1H2(40),m3h8x2(:,6),heltab2x16(:,:,119))
  call Hloop_QA_Z(ntryL,G1H16(20),ex4(:),G1H8(2),ngZn,m3h2x8(:,92),heltab2x16(:,:,120))
  call Hloop_QA_W(ntryL,G1H16(25),ex4(:),G1H8(28),m3h2x8(:,93),heltab2x16(:,:,121))
  call Hloop_AQ_Z(ntryL,G1H16(27),ex1(:),G1H8(94),ngZn,m3h2x8(:,94),heltab2x16(:,:,122))
  call Hloop_AQ_Z(ntryL,G1H4(38),ex1(:),G1H2(41),ngZn,m3h2x2(:,96),heltab2x4(:,:,126))
  call Hloop_QA_Z(ntryL,G1H4(42),ex4(:),G1H2(53),ngZn,m3h2x2(:,97),heltab2x4(:,:,127))
  call Hloop_QA_W(ntryL,G1H4(43),ex4(:),G1H2(54),m3h2x2(:,98),heltab2x4(:,:,128))
  call Hloop_WQ_A(ntryL,G1H8(29),ex2(:),G1H4(3),m3h2x4(:,103),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(3),54,0,G2H4(26),n2h4(111))
  call Hloop_ZQ_A(ntryL,G1H8(30),ex2(:),G1H4(4),ngZn,m3h2x4(:,104),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(4),54,0,G2H4(27),n2h4(112))
  call Hloop_AQ_W(ntryL,G1H8(31),ex2(:),G1H4(9),m3h2x4(:,105),heltab2x8(:,:,123))
  call Hloop_AQ_Z(ntryL,G1H8(32),ex2(:),G1H4(30),ngZn,m3h2x4(:,106),heltab2x8(:,:,124))
  call Hloop_AQ_W(ntryL,G2H8(19),ex2(:),G2H4(28),m3h2x4(:,107),heltab2x8(:,:,125))
  call Hloop_WA_Q(ntryL,G1H8(33),ex3(:),G1H4(36),m3h2x4(:,108),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(36),54,0,G2H4(29),n2h4(113))
  call Hloop_ZA_Q(ntryL,G1H8(34),ex3(:),G1H4(49),ngZn,m3h2x4(:,109),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(49),54,0,G2H4(30),n2h4(114))
  call Hloop_QA_W(ntryL,G1H8(35),ex3(:),G1H4(18),m3h2x4(:,110),heltab2x8(:,:,128))
  call Hloop_QA_Z(ntryL,G1H8(36),ex3(:),G1H4(19),ngZn,m3h2x4(:,111),heltab2x8(:,:,129))
  call Hloop_QA_W(ntryL,G2H8(20),ex3(:),G2H4(31),m3h2x4(:,112),heltab2x8(:,:,130))
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(161),mass4set(:,5),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(33),8)
  call HG1shiftOLR(G1H8(30),4,8)
  call Hloop_UW_V(ntryL,G1H8(37),50,wf4(:,4),9,G2H2(21),m3h4x2(:,19),heltab2x8(:,:,131))
  call Hloop_QA_Z(ntryL,G1H4(56),ex3(:),G1H2(58),ngZn,m3h2x2(:,99),heltab2x4(:,:,129))
  call Hloop_QA_W(ntryL,G1H4(60),ex3(:),G1H2(65),m3h2x2(:,100),heltab2x4(:,:,130))
  call Hloop_AQ_Z(ntryL,G1H16(29),wf8(:,26),G1H2(71),ngZn,m3h8x2(:,7),heltab2x16(:,:,123))
  call Hloop_QA_Z(ntryL,G1H16(32),wf8(:,68),G1H2(77),ngZn,m3h8x2(:,8),heltab2x16(:,:,124))
  call Hloop_QA_W(ntryL,G1H16(34),wf8(:,68),G1H2(84),m3h8x2(:,9),heltab2x16(:,:,125))
  call Hloop_QA_Z(ntryL,G1H16(37),ex3(:),G1H8(34),ngZn,m3h2x8(:,95),heltab2x16(:,:,126))
  call Hloop_QA_W(ntryL,G1H16(39),ex3(:),G1H8(35),m3h2x8(:,96),heltab2x16(:,:,127))
  call Hloop_AQ_Z(ntryL,G1H16(41),ex2(:),G1H8(36),ngZn,m3h2x8(:,97),heltab2x16(:,:,128))
  call Hloop_AQ_Z(ntryL,G1H4(50),ex2(:),G1H2(89),ngZn,m3h2x2(:,101),heltab2x4(:,:,131))
  call Hloop_QA_Z(ntryL,G1H4(54),ex3(:),G1H2(94),ngZn,m3h2x2(:,102),heltab2x4(:,:,132))
  call Hloop_QA_W(ntryL,G1H4(55),ex3(:),G1H2(112),m3h2x2(:,103),heltab2x4(:,:,133))
  call Hloop_WQ_A(ntryL,G1H8(38),ex1(:),G1H4(20),m3h2x4(:,113),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(20),53,0,G2H4(32),n2h4(115))
  call Hloop_ZQ_A(ntryL,G1H8(39),ex1(:),G1H4(21),ngZn,m3h2x4(:,114),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(21),53,0,G2H4(33),n2h4(116))
  call Hloop_AQ_W(ntryL,G1H8(40),ex1(:),G1H4(22),m3h2x4(:,115),heltab2x8(:,:,134))
  call Hloop_AQ_Z(ntryL,G1H8(41),ex1(:),G1H4(2),ngZn,m3h2x4(:,116),heltab2x8(:,:,135))
  call Hloop_AQ_W(ntryL,G2H8(22),ex1(:),G2H4(34),m3h2x4(:,117),heltab2x8(:,:,136))
  call Hloop_WA_Q(ntryL,G1H8(42),ex3(:),G1H4(61),m3h2x4(:,118),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(61),53,0,G2H4(1),n2h4(117))
  call Hloop_ZA_Q(ntryL,G1H8(43),ex3(:),G1H4(38),ngZn,m3h2x4(:,119),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(38),53,0,G2H4(35),n2h4(118))
  call Hloop_QA_W(ntryL,G1H8(44),ex3(:),G1H4(42),m3h2x4(:,120),heltab2x8(:,:,139))
  call Hloop_QA_Z(ntryL,G1H8(45),ex3(:),G1H4(43),ngZn,m3h2x4(:,121),heltab2x8(:,:,140))
  call Hloop_QA_W(ntryL,G2H8(23),ex3(:),G2H4(2),m3h2x4(:,122),heltab2x8(:,:,141))
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(178),mass4set(:,5),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),8)
  call HG1shiftOLR(G1H8(38),4,8)
  call Hloop_UW_V(ntryL,G1H8(46),49,wf4(:,2),10,G2H2(22),m3h4x2(:,20),heltab2x8(:,:,142))
  call Hloop_AQ_Z(ntryL,G1H16(43),wf8(:,29),G1H2(113),ngZn,m3h8x2(:,10),heltab2x16(:,:,129))
  call Hloop_QA_Z(ntryL,G1H16(46),wf8(:,94),G1H2(114),ngZn,m3h8x2(:,11),heltab2x16(:,:,130))
  call Hloop_QA_W(ntryL,G1H16(48),wf8(:,94),G1H2(66),m3h8x2(:,12),heltab2x16(:,:,131))
  call Hloop_QA_Z(ntryL,G1H16(51),ex3(:),G1H8(42),ngZn,m3h2x8(:,98),heltab2x16(:,:,132))
  call Hloop_QA_W(ntryL,G1H16(53),ex3(:),G1H8(43),m3h2x8(:,99),heltab2x16(:,:,133))
  call Hloop_AQ_Z(ntryL,G1H16(55),ex1(:),G1H8(44),ngZn,m3h2x8(:,100),heltab2x16(:,:,134))
  call Hloop_AQ_Z(ntryL,G1H4(62),ex1(:),G1H2(9),ngZn,m3h2x2(:,104),heltab2x4(:,:,134))
  call Hloop_QA_Z(ntryL,G1H4(66),ex3(:),G1H2(76),ngZn,m3h2x2(:,105),heltab2x4(:,:,135))
  call Hloop_QA_W(ntryL,G1H4(67),ex3(:),G1H2(106),m3h2x2(:,106),heltab2x4(:,:,136))
  call Hloop_AQ_Z(ntryL,G1H4(68),ex2(:),G1H2(30),ngZn,m3h2x2(:,107),heltab2x4(:,:,137))
  call Hloop_AQ_W(ntryL,G1H4(72),ex2(:),G1H2(21),m3h2x2(:,108),heltab2x4(:,:,138))
  call Hloop_ZQ_A(ntryL,G1H4(1),ex2(:),G1H2(118),ngZn,m3h2x2(:,109),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(118),55,0,G2H2(23),n2h2(31))
  call Hloop_QA_Z(ntryL,G1H4(26),ex3(:),G1H2(33),ngZn,m3h2x2(:,110),heltab2x4(:,:,140))
  call Hloop_QA_Z(ntryL,G1H4(29),ex4(:),G1H2(102),ngZn,m3h2x2(:,111),heltab2x4(:,:,141))
  call Hloop_AQ_Z(ntryL,G1H4(73),ex1(:),G1H2(51),ngZn,m3h2x2(:,112),heltab2x4(:,:,142))
  call Hloop_AQ_W(ntryL,G1H4(74),ex1(:),G1H2(72),m3h2x2(:,113),heltab2x4(:,:,143))
  call Hloop_ZQ_A(ntryL,G1H4(75),ex1(:),G1H2(57),ngZn,m3h2x2(:,114),heltab2x4(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(57),55,0,G2H2(24),n2h2(32))
  call Hloop_QA_Z(ntryL,G1H4(77),ex3(:),G1H2(101),ngZn,m3h2x2(:,115),heltab2x4(:,:,145))
  call Hloop_QA_Z(ntryL,G1H4(78),ex4(:),G1H2(75),ngZn,m3h2x2(:,116),heltab2x4(:,:,146))
  call Hloop_ZQ_A(ntryL,G1H4(79),ex1(:),G1H2(90),ngZn,m3h2x2(:,117),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(90),55,0,G2H2(25),n2h2(33))
  call Hloop_ZQ_A(ntryL,G1H4(80),ex2(:),G1H2(93),ngZn,m3h2x2(:,118),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(93),55,0,G2H2(26),n2h2(34))
  call Hloop_QA_Z(ntryL,G1H4(81),ex4(:),G1H2(100),ngZn,m3h2x2(:,119),heltab2x4(:,:,149))
  call Hloop_QA_W(ntryL,G1H4(82),ex4(:),G1H2(99),m3h2x2(:,120),heltab2x4(:,:,150))
  call Hloop_ZA_Q(ntryL,G1H4(83),ex4(:),G1H2(121),ngZn,m3h2x2(:,121),heltab2x4(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(121),61,0,G2H2(27),n2h2(35))
  call Hloop_WA_Q(ntryL,G1H4(84),ex4(:),G1H2(122),m3h2x2(:,122),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(122),61,0,G2H2(28),n2h2(36))
  call Hloop_ZQ_A(ntryL,G1H4(85),ex1(:),G1H2(123),ngZn,m3h2x2(:,123),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(123),59,0,G2H2(29),n2h2(37))
  call Hloop_ZQ_A(ntryL,G1H4(86),ex2(:),G1H2(127),ngZn,m3h2x2(:,124),heltab2x4(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(127),59,0,G2H2(30),n2h2(38))
  call Hloop_QA_Z(ntryL,G1H4(87),ex3(:),G1H2(117),ngZn,m3h2x2(:,125),heltab2x4(:,:,155))
  call Hloop_QA_W(ntryL,G1H4(88),ex3(:),G1H2(128),m3h2x2(:,126),heltab2x4(:,:,156))
  call Hloop_ZA_Q(ntryL,G1H4(89),ex3(:),G1H2(132),ngZn,m3h2x2(:,127),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(132),61,0,G2H2(31),n2h2(39))
  call Hloop_WA_Q(ntryL,G1H4(90),ex3(:),G1H2(133),m3h2x2(:,128),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(133),61,0,G2H2(32),n2h2(40))
  call Hloop_WQ_A(ntryL,G1H4(15),ex1(:),G1H2(134),m3h2x2(:,129),heltab2x4(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(134),55,0,G2H2(33),n2h2(41))
call HGT_raise_alpha_OLR(G1H4(16),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(16),ex4(:),G1H2(138),m3h2x2(:,130),heltab2x4(:,:,160))
  call Hloop_WQ_A(ntryL,G1H4(28),ex1(:),G1H2(139),m3h2x2(:,131),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(139),55,0,G2H2(35),n2h2(42))
  call Hloop_WQ_A(ntryL,G1H4(8),ex1(:),G1H2(140),m3h2x2(:,132),heltab2x4(:,:,162))
  call Hloop_Q_A(ntryL,G1H2(140),55,0,G2H2(36),n2h2(43))
  call Hloop_WQ_A(ntryL,G1H4(11),ex2(:),G1H2(144),m3h2x2(:,133),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(144),55,0,G2H2(38),n2h2(44))
call HGT_raise_alpha_OLR(G1H4(12),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(12),ex4(:),G1H2(145),m3h2x2(:,134),heltab2x4(:,:,164))
  call Hloop_WQ_A(ntryL,G1H4(44),ex2(:),G1H2(146),m3h2x2(:,135),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(146),55,0,G2H2(39),n2h2(45))
  call Hloop_WQ_A(ntryL,G1H4(48),ex2(:),G1H2(150),m3h2x2(:,136),heltab2x4(:,:,166))
  call Hloop_Q_A(ntryL,G1H2(150),55,0,G2H2(41),n2h2(46))
  call Hloop_AZ_Q(ntryL,G1H8(6),wf4(:,1),G1H2(151),ngZu,m3h4x2(:,21),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(151),47,0,G2H2(42),n2h2(47))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex5(:),G1H4(3),m3h2x4(:,123),heltab2x8(:,:,144))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf4(:,1),G1H2(152),ngZu,m3h4x2(:,22),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(152),47,0,G2H2(44),n2h2(48))
  call Hloop_AZ_Q(ntryL,G1H8(10),wf4(:,1),G1H2(156),ngZu,m3h4x2(:,23),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(156),47,0,G2H2(45),n2h2(49))
  call Hloop_AZ_Q(ntryL,G1H8(11),wf4(:,1),G1H2(157),ngZu,m3h4x2(:,24),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(157),47,0,G2H2(47),n2h2(50))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(12),ex5(:),G1H4(4),ngZu,m3h2x4(:,124),heltab2x8(:,:,148))
  call Hloop_AZ_Q(ntryL,G1H8(15),wf4(:,1),G1H2(158),ngZu,m3h4x2(:,25),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(158),47,0,G2H2(48),n2h2(51))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,1),G1H2(162),ngZu,m3h4x2(:,26),heltab2x8(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(162),47,0,G2H2(50),n2h2(52))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,1),G1H2(163),ngZd,m3h4x2(:,27),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(163),47,0,G2H2(51),n2h2(53))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(20),ex5(:),G1H4(36),m3h2x4(:,125),heltab2x8(:,:,152))
  call Hloop_AZ_Q(ntryL,G1H8(48),wf4(:,1),G1H2(164),ngZd,m3h4x2(:,28),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(164),47,0,G2H2(52),n2h2(54))
  call Hloop_AZ_Q(ntryL,G1H8(49),wf4(:,1),G1H2(168),ngZd,m3h4x2(:,29),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(168),47,0,G2H2(53),n2h2(55))
  call Hloop_AZ_Q(ntryL,G1H8(19),wf4(:,2),G1H2(169),ngZu,m3h4x2(:,30),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(169),47,0,G2H2(54),n2h2(56))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(50),ex5(:),G1H4(49),m3h2x4(:,126),heltab2x8(:,:,156))
  call Hloop_AZ_Q(ntryL,G1H8(52),wf4(:,2),G1H2(170),ngZu,m3h4x2(:,31),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(170),47,0,G2H2(55),n2h2(57))
  call Hloop_AZ_Q(ntryL,G1H8(53),wf4(:,2),G1H2(174),ngZu,m3h4x2(:,32),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(174),47,0,G2H2(56),n2h2(58))
  call Hloop_AZ_Q(ntryL,G1H8(54),wf4(:,2),G1H2(175),ngZu,m3h4x2(:,33),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(175),47,0,G2H2(57),n2h2(59))
call HGT_raise_alpha_OLR(G1H8(55),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(55),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(55),ex5(:),G1H4(56),ngZu,m3h2x4(:,127),heltab2x8(:,:,160))
  call Hloop_AZ_Q(ntryL,G1H8(57),wf4(:,2),G1H2(176),ngZu,m3h4x2(:,34),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(176),47,0,G2H2(58),n2h2(60))
  call Hloop_AZ_Q(ntryL,G1H8(58),wf4(:,2),G1H2(180),ngZu,m3h4x2(:,35),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(180),47,0,G2H2(59),n2h2(61))
  call Hloop_AZ_Q(ntryL,G1H8(59),wf4(:,2),G1H2(181),ngZd,m3h4x2(:,36),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(181),47,0,G2H2(60),n2h2(62))
call HGT_raise_alpha_OLR(G1H8(60),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(60),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(60),ex5(:),G1H4(60),m3h2x4(:,128),heltab2x8(:,:,164))
  call Hloop_AZ_Q(ntryL,G1H8(62),wf4(:,2),G1H2(182),ngZd,m3h4x2(:,37),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(182),47,0,G2H2(61),n2h2(63))
  call Hloop_AZ_Q(ntryL,G1H8(63),wf4(:,2),G1H2(186),ngZd,m3h4x2(:,38),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(186),47,0,G2H2(62),n2h2(64))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,1),G1H2(187),ngZl,m3h4x2(:,39),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(187),55,0,G2H2(63),n2h2(65))
call HGT_raise_alpha_OLR(G1H8(23),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(23),ex4(:),G1H4(50),m3h2x4(:,129),heltab2x8(:,:,168))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,1),G1H2(188),ngZl,m3h4x2(:,40),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(188),55,0,G2H2(64),n2h2(66))
  call Hloop_QZ_A(ntryL,G1H8(25),wf4(:,1),G1H2(192),ngZl,m3h4x2(:,41),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G1H2(192),55,0,G2H2(65),n2h2(67))
  call Hloop_AZ_Q(ntryL,G1H8(65),wf4(:,4),G1H2(193),ngZu,m3h4x2(:,42),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(193),47,0,G2H2(66),n2h2(68))
call HGT_raise_alpha_OLR(G1H8(66),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(66),ex5(:),G1H4(54),m3h2x4(:,130),heltab2x8(:,:,172))
  call Hloop_AZ_Q(ntryL,G1H8(68),wf4(:,4),G1H2(194),ngZu,m3h4x2(:,43),heltab2x8(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(194),47,0,G2H2(67),n2h2(69))
  call Hloop_AZ_Q(ntryL,G1H8(69),wf4(:,4),G1H2(198),ngZu,m3h4x2(:,44),heltab2x8(:,:,174))
  call Hloop_A_Q(ntryL,G1H2(198),47,0,G2H2(68),n2h2(70))
  call Hloop_AZ_Q(ntryL,G1H8(70),wf4(:,4),G1H2(73),ngZu,m3h4x2(:,45),heltab2x8(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(73),47,0,G2H2(69),n2h2(71))
call HGT_raise_alpha_OLR(G1H8(71),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(71),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(71),ex5(:),G1H4(55),ngZu,m3h2x4(:,131),heltab2x8(:,:,176))
  call Hloop_AZ_Q(ntryL,G1H8(73),wf4(:,4),G1H2(74),ngZu,m3h4x2(:,46),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(74),47,0,G2H2(70),n2h2(72))
  call Hloop_AZ_Q(ntryL,G1H8(74),wf4(:,4),G1H2(86),ngZu,m3h4x2(:,47),heltab2x8(:,:,178))
  call Hloop_A_Q(ntryL,G1H2(86),47,0,G2H2(71),n2h2(73))
  call Hloop_AZ_Q(ntryL,G1H8(75),wf4(:,4),G1H2(91),ngZd,m3h4x2(:,48),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(72),n2h2(74))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(76),ex5(:),G1H4(20),m3h2x4(:,132),heltab2x8(:,:,180))
  call Hloop_AZ_Q(ntryL,G1H8(78),wf4(:,4),G1H2(92),ngZd,m3h4x2(:,49),heltab2x8(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(92),47,0,G2H2(73),n2h2(75))
  call Hloop_AZ_Q(ntryL,G1H8(79),wf4(:,4),G1H2(104),ngZd,m3h4x2(:,50),heltab2x8(:,:,182))
  call Hloop_A_Q(ntryL,G1H2(104),47,0,G2H2(74),n2h2(76))
  call Hloop_AZ_Q(ntryL,G1H8(21),wf4(:,5),G1H2(109),ngZu,m3h4x2(:,51),heltab2x8(:,:,183))
  call Hloop_A_Q(ntryL,G1H2(109),47,0,G2H2(75),n2h2(77))
call HGT_raise_alpha_OLR(G1H8(80),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(80),ex5(:),G1H4(21),m3h2x4(:,133),heltab2x8(:,:,184))
  call Hloop_AZ_Q(ntryL,G1H8(82),wf4(:,5),G1H2(110),ngZu,m3h4x2(:,52),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(110),47,0,G2H2(76),n2h2(78))
  call Hloop_AZ_Q(ntryL,G1H8(83),wf4(:,5),G1H2(7),ngZu,m3h4x2(:,53),heltab2x8(:,:,186))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(77),n2h2(79))
  call Hloop_AZ_Q(ntryL,G1H8(84),wf4(:,5),G1H2(8),ngZu,m3h4x2(:,54),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G1H2(8),47,0,G2H2(78),n2h2(80))
call HGT_raise_alpha_OLR(G1H8(85),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(85),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(85),ex5(:),G1H4(61),ngZu,m3h2x4(:,134),heltab2x8(:,:,188))
  call Hloop_AZ_Q(ntryL,G1H8(87),wf4(:,5),G1H2(118),ngZu,m3h4x2(:,55),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(118),47,0,G2H2(79),n2h2(81))
  call Hloop_AZ_Q(ntryL,G1H8(88),wf4(:,5),G1H2(57),ngZu,m3h4x2(:,56),heltab2x8(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(57),47,0,G2H2(80),n2h2(82))
  call Hloop_AZ_Q(ntryL,G1H8(89),wf4(:,5),G1H2(90),ngZd,m3h4x2(:,57),heltab2x8(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(90),47,0,G2H2(81),n2h2(83))
call HGT_raise_alpha_OLR(G1H8(90),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(90),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(90),ex5(:),G1H4(38),m3h2x4(:,135),heltab2x8(:,:,192))
  call Hloop_AZ_Q(ntryL,G1H8(92),wf4(:,5),G1H2(93),ngZd,m3h4x2(:,58),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(93),47,0,G2H2(82),n2h2(84))
  call Hloop_AZ_Q(ntryL,G1H8(93),wf4(:,5),G1H2(121),ngZd,m3h4x2(:,59),heltab2x8(:,:,194))
  call Hloop_A_Q(ntryL,G1H2(121),47,0,G2H2(83),n2h2(85))
  call Hloop_QZ_A(ntryL,G1H8(16),wf4(:,5),G1H2(122),ngZl,m3h4x2(:,60),heltab2x8(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(122),55,0,G2H2(84),n2h2(86))
call HGT_raise_alpha_OLR(G1H8(3),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(3),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(3),ex4(:),G1H4(62),m3h2x4(:,136),heltab2x8(:,:,196))
  call Hloop_QZ_A(ntryL,G1H8(27),wf4(:,5),G1H2(123),ngZl,m3h4x2(:,61),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(123),55,0,G2H2(85),n2h2(87))
  call Hloop_QZ_A(ntryL,G1H8(1),wf4(:,5),G1H2(127),ngZl,m3h4x2(:,62),heltab2x8(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(127),55,0,G2H2(86),n2h2(88))
  call Hloop_QZ_A(ntryL,G1H8(29),wf4(:,4),G1H2(132),ngZl,m3h4x2(:,63),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(132),59,0,G2H2(87),n2h2(89))
call HGT_raise_alpha_OLR(G1H8(30),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(30),ex3(:),G1H4(66),m3h2x4(:,137),heltab2x8(:,:,200))
  call Hloop_QZ_A(ntryL,G1H8(32),wf4(:,4),G1H2(133),ngZl,m3h4x2(:,64),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(133),59,0,G2H2(88),n2h2(90))
  call Hloop_QZ_A(ntryL,G1H8(33),wf4(:,4),G1H2(134),ngZl,m3h4x2(:,65),heltab2x8(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(134),59,0,G2H2(89),n2h2(91))
  call Hloop_QZ_A(ntryL,G1H8(37),wf4(:,2),G1H2(139),ngZl,m3h4x2(:,66),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(139),59,0,G2H2(90),n2h2(92))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(38),ex3(:),G1H4(67),m3h2x4(:,138),heltab2x8(:,:,204))
  call Hloop_QZ_A(ntryL,G1H8(40),wf4(:,2),G1H2(140),ngZl,m3h4x2(:,67),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(140),59,0,G2H2(91),n2h2(93))
  call Hloop_QZ_A(ntryL,G1H8(41),wf4(:,2),G1H2(144),ngZl,m3h4x2(:,68),heltab2x8(:,:,206))
  call Hloop_Q_A(ntryL,G1H2(144),59,0,G2H2(92),n2h2(94))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(43)])
call HGT_w2_OLR(G1H2(50),1,1,2)
call HGT_w2_invQ_OLR(G1H2(50),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(46)])
call HGT_w2_OLR(G1H2(62),1,1,2)
call HGT_w2_invQ_OLR(G1H2(62),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(55),[G1H2(68),G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(37),G1H2(83),G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(31),[G1H2(107),G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(56),G1H2(16),G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(54),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(32),[G1H2(48),G1H2(52),G1H2(20),G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(44),G1H2(1),G0H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(61),G1H2(64),G1H2(47),G1H2(49),G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(113),[G1H2(71),G1H2(88),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(58),[G1H2(70),G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(120),G1H2(87),G1H2(46),G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(60),G1H2(35),G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(45),G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(114),[G1H2(36),G1H2(69),G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(96),G1H2(17),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(40),G1H2(126),G1H2(111),G1H2(27),G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(112),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(125),G1H2(119),G0H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(101),[G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(142),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(161),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(148),[G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(173),[G1H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(185),[G1H2(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(197),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(191)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(2),ex2(:),G1H1(1),ngZn,m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(207))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(20),ngZn,m3h2x1(:,190),heltab2x2(:,:,190))
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(14),ex1(:),G1H1(1),ngZn,m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(28),n2h1(208))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(38),ngZn,m3h2x1(:,192),heltab2x2(:,:,192))
call HGT_w2_OLR(G1H2(26),1,1,2)
call HGT_w2_invQ_OLR(G1H2(26),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(26),ex1(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(209))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(63),ex4(:),G2tensor(4),m3h2x1(:,194),heltab2x2(:,:,194))
call HGT_w2_OLR(G1H2(38),1,1,2)
call HGT_w2_invQ_OLR(G1H2(38),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(38),ex1(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(210))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(87),ex3(:),G2tensor(8),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hloop_WQ_A(ntryL,G1H2(50),ex2(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(211))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(84),ex4(:),G2tensor(12),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hloop_WQ_A(ntryL,G1H2(62),ex2(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(212))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(90),ex3(:),G2tensor(16),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hloop_ZQ_A(ntryL,G1H2(79),ex5(:),G1H1(1),ngZu,m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(18),n2h1(213))
  call Hloop_ZQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),ngZu,m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(214))
  call Hloop_ZQ_A(ntryL,G1H2(22),ex5(:),G1H1(1),ngZu,m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(215))
  call Hloop_ZQ_A(ntryL,G1H2(97),ex5(:),G1H1(1),ngZu,m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(216))
  call Hloop_ZQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),ngZu,m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(26),n2h1(217))
  call Hloop_ZQ_A(ntryL,G1H2(77),ex5(:),G1H1(1),ngZu,m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(218))
  call Hloop_WQ_A(ntryL,G1H2(54),ex5(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(219))
  call Hloop_WQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(220))
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(45),mass4set(:,6),  & 
G1H2(146),G1H2(150),G1H2(151),G1H2(152),G1H2(156),2)
  call HG1shiftOLR(G1H2(150),16,2)
  call Hloop_WQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(221))
  call Hloop_WQ_A(ntryL,G1H2(84),ex5(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(222))
  call Hloop_WQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(223))
  call Hloop_ZQ_A(ntryL,G1H2(67),ex5(:),G1H1(1),ngZu,m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(224))
  call Hloop_ZQ_A(ntryL,G1H2(113),ex5(:),G1H1(1),ngZu,m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(225))
  call Hloop_ZQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),ngZu,m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(226))
  call Hloop_ZQ_A(ntryL,G1H2(58),ex5(:),G1H1(1),ngZu,m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(227))
  call Hloop_WQ_A(ntryL,G1H2(106),ex5(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(228))
  call Hloop_WQ_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(229))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(7),mass4set(:,6),  & 
G1H2(157),G1H2(158),G1H2(162),G1H2(163),G1H2(164),2)
  call HG1shiftOLR(G1H2(158),16,2)
  call Hloop_WQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(230))
  call Hloop_WQ_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(231))
  call Hloop_ZQ_A(ntryL,G1H2(78),ex5(:),G1H1(1),ngZu,m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(232))
  call Hloop_ZQ_A(ntryL,G1H2(24),ex5(:),G1H1(1),ngZu,m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(233))
  call Hloop_ZQ_A(ntryL,G1H2(95),ex5(:),G1H1(1),ngZu,m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(234))
  call Hloop_ZQ_A(ntryL,G1H2(114),ex5(:),G1H1(1),ngZu,m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(235))
  call Hloop_WQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(236))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(22),mass4set(:,6),  & 
G1H2(168),G1H2(169),G1H2(170),G1H2(174),G1H2(175),2)
  call HG1shiftOLR(G1H2(169),16,2)
  call Hloop_WQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(237))
  call Hloop_WQ_A(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(238))
  call Hloop_WQ_A(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(239))
  call Hloop_ZQ_A(ntryL,G1H2(39),ex5(:),G1H1(1),ngZu,m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(240))
  call Hloop_ZQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),ngZu,m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(241))
  call Hloop_WQ_A(ntryL,G1H2(112),ex5(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(242))
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(35),mass4set(:,6),  & 
G1H2(176),G1H2(180),G1H2(181),G1H2(182),G1H2(186),2)
  call HG1shiftOLR(G1H2(180),16,2)
  call Hloop_WQ_A(ntryL,G1H2(105),ex5(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(243))
  call Hloop_WQ_A(ntryL,G1H2(124),ex5(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(244))
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,31),heltab2x4(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(245))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,32),heltab2x4(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(246))
  call Hloop_QZ_A(ntryL,G1H4(7),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,33),heltab2x4(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(82),n2h1(247))
  call Hloop_QZ_A(ntryL,G1H4(13),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,34),heltab2x4(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(248))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,35),heltab2x4(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(249))
  call Hloop_QZ_A(ntryL,G1H4(17),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,36),heltab2x4(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(250))
  call Hloop_QZ_A(ntryL,G1H4(23),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,37),heltab2x4(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(88),n2h1(251))
  call Hloop_QZ_A(ntryL,G1H4(24),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,38),heltab2x4(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(252))
  call Hloop_QZ_A(ntryL,G1H4(25),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,39),heltab2x4(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(253))
  call Hloop_QZ_A(ntryL,G1H4(31),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,40),heltab2x4(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(254))
  call Hloop_QZ_A(ntryL,G1H4(32),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,41),heltab2x4(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(44),n2h1(255))
  call Hloop_QZ_A(ntryL,G1H4(35),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,42),heltab2x4(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(94),n2h1(256))
  call Hloop_QZ_A(ntryL,G1H4(39),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,43),heltab2x4(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(257))
  call Hloop_QZ_A(ntryL,G1H4(46),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,44),heltab2x4(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(100),n2h1(258))
  call Hloop_QZ_A(ntryL,G1H4(41),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,45),heltab2x4(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(259))
  call Hloop_QZ_A(ntryL,G1H4(45),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,46),heltab2x4(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(46),n2h1(260))
  call Hloop_QZ_A(ntryL,G1H4(47),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,47),heltab2x4(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(261))
  call Hloop_QZ_A(ntryL,G1H4(51),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,48),heltab2x4(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(262))
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(189),mass4set(:,7),  & 
G1H4(68),G1H4(72),G1H4(1),G1H4(26),G1H4(29),4)
  call HG1shiftOLR(G1H4(72),9,4)
  call Hloop_QZ_A(ntryL,G1H4(53),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,49),heltab2x4(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(263))
  call Hloop_QZ_A(ntryL,G1H4(57),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,50),heltab2x4(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(264))
  call Hloop_QZ_A(ntryL,G1H4(64),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,51),heltab2x4(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(265))
  call Hloop_QZ_A(ntryL,G1H4(59),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,52),heltab2x4(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(50),n2h1(266))
  call Hloop_QZ_A(ntryL,G1H4(63),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,53),heltab2x4(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(267))
  call Hloop_QZ_A(ntryL,G1H4(65),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,54),heltab2x4(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(268))
  call Hloop_QZ_A(ntryL,G1H4(69),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,55),heltab2x4(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(112),n2h1(269))
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(184),mass4set(:,7),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),10,4)
  call Hloop_QZ_A(ntryL,G1H4(71),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,56),heltab2x4(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(115),n2h1(270))
  call Hloop_ZA_Q(ntryL,G1H2(101),ex4(:),G1H1(1),ngZn,m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(271))
  call Hloop_ZA_Q(ntryL,G1H2(142),ex4(:),G1H1(1),ngZn,m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(272))
  call Hloop_ZA_Q(ntryL,G1H2(161),ex4(:),G1H1(1),ngZn,m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(273))
  call Hloop_ZA_Q(ntryL,G1H2(75),ex3(:),G1H1(1),ngZn,m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(274))
  call Hloop_ZA_Q(ntryL,G1H2(148),ex3(:),G1H1(1),ngZn,m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(275))
  call Hloop_ZA_Q(ntryL,G1H2(173),ex3(:),G1H1(1),ngZn,m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(56),n2h1(276))
  call Hloop_ZA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),ngZn,m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(277))
  call Hloop_ZA_Q(ntryL,G1H2(185),ex4(:),G1H1(1),ngZn,m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(278))
  call Hloop_ZA_Q(ntryL,G1H2(102),ex3(:),G1H1(1),ngZn,m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(279))
  call Hloop_ZA_Q(ntryL,G1H2(197),ex3(:),G1H1(1),ngZn,m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(280))
  call Hloop_WA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(124),n2h1(281))
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(149),mass4set(:,8),  & 
G1H2(187),G1H2(188),G1H2(192),G1H2(193),G1H2(194),2)
  call HG1shiftOLR(G1H2(188),8,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(155),mass4set(:,9),  & 
G1H2(198),G1H2(73),G1H2(74),G1H2(86),G1H2(91),2)
  call HG1shiftOLR(G1H2(73),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(51),ex4(:),G1H1(1),ngZn,m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(282))
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(149),mass4set(:,10),  & 
G1H2(92),G1H2(104),G1H2(109),G1H2(110),G1H2(7),2)
  call HG1shiftOLR(G1H2(104),8,2)
  call Hloop_WA_Q(ntryL,G1H2(165),ex3(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(130),n2h1(283))
  call Hloop_WA_Q(ntryL,G1H2(166),ex3(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(284))
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(161),mass4set(:,9),  & 
G1H2(8),G1H2(118),G1H2(57),G1H2(90),G1H2(93),2)
  call HG1shiftOLR(G1H2(118),4,2)
  call Hloop_ZA_Q(ntryL,G1H2(171),ex3(:),G1H1(1),ngZn,m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(285))
  call Hloop_ZA_Q(ntryL,G1H2(172),ex3(:),G1H1(1),ngZn,m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(286))
  call Hloop_WA_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(287))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(142),mass4set(:,8),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(127),G1H2(132),2)
  call HG1shiftOLR(G1H2(122),8,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(169),mass4set(:,9),  & 
G1H2(133),G1H2(134),G1H2(139),G1H2(140),G1H2(144),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),ngZn,m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(288))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(142),mass4set(:,10),  & 
G1H2(128),G1H2(99),G1H2(68),G1H2(80),G1H2(37),2)
  call HG1shiftOLR(G1H2(99),8,2)
  call Hloop_WA_Q(ntryL,G1H2(189),ex3(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(289))
  call Hloop_WA_Q(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(290))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(178),mass4set(:,9),  & 
G1H2(83),G1H2(85),G1H2(107),G1H2(98),G1H2(56),2)
  call HG1shiftOLR(G1H2(85),4,2)
  call Hloop_ZA_Q(ntryL,G1H2(195),ex3(:),G1H1(1),ngZn,m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(291))
  call Hloop_ZA_Q(ntryL,G1H2(196),ex3(:),G1H1(1),ngZn,m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(148),n2h1(292))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(151),ngZn,m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(154),ngZn,m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(157),ngZn,m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(160),ngZn,m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(163),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(166),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(169),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(172),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(175),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(178),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hloop_ZQ_A(ntryL,G0H2(1),ex5(:),G0H1(1),ngZu,m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(1),n2h1(293))
  call Hloop_ZQ_A(ntryL,G0H2(3),ex5(:),G0H1(1),ngZu,m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(37),n2h1(294))
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(184),mass4set(:,11),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),4)
  call HG1shiftOLR(G1H4(80),10,4)
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(13),ex4(:),G1tensor(73),ngZn,m3h2x1(:,267),heltab2x2(:,:,267))
  call Hotf_4pt_reduction(G2H4(18),RedSet_4(162),mass4set(:,12),  & 
G1H4(84),G1H4(85),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(85),5,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(162),mass4set(:,13),  & 
G1H4(89),G1H4(90),G1H4(15),G1H4(16),G1H4(28),4)
  call HG1shiftOLR(G1H4(90),5,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(10),wf4(:,1),G1tensor(109),m3h4x1(:,57),heltab2x4(:,:,193))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(76),wf4(:,1),G1tensor(26),m3h4x1(:,58),heltab2x4(:,:,194))
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(162),mass4set(:,14),  & 
G1H4(8),G1H4(11),G1H4(12),G1H4(44),G1H4(48),4)
  call HG1shiftOLR(G1H4(11),5,4)
  call Hloop_ZQ_A(ntryL,G1H8(26),wf8(:,3),G1H1(1),ngZu,m3h8x1(:,1),heltab2x8(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(181),n2h1(295))
  call Hloop_WQ_A(ntryL,G1H8(13),wf8(:,3),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(184),n2h1(296))
  call Hloop_ZQ_A(ntryL,G1H8(64),wf8(:,3),G1H1(1),ngZu,m3h8x1(:,3),heltab2x8(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(187),n2h1(297))
  call Hloop_ZQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),ngZu,m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(190),n2h1(298))
  call Hloop_ZQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),ngZu,m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(193),n2h1(299))
  call Hloop_ZQ_A(ntryL,G0H2(5),ex5(:),G0H1(1),ngZu,m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(62),n2h1(300))
  call Hloop_ZQ_A(ntryL,G0H2(7),ex5(:),G0H1(1),ngZu,m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(98),n2h1(301))
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(189),mass4set(:,11),  & 
G1H4(40),G1H4(52),G1H4(58),G1H4(70),G1H4(5),4)
  call HG1shiftOLR(G1H4(52),9,4)
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(18),ex4(:),G1tensor(4),ngZn,m3h2x1(:,272),heltab2x2(:,:,272))
  call Hotf_4pt_reduction(G2H4(23),RedSet_4(179),mass4set(:,12),  & 
G1H4(6),G1H4(7),G1H4(13),G1H4(14),G1H4(17),4)
  call HG1shiftOLR(G1H4(7),6,4)
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(179),mass4set(:,13),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(24),6,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(33),wf4(:,5),G1tensor(76),m3h4x1(:,59),heltab2x4(:,:,195))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(34),wf4(:,5),G1tensor(15),m3h4x1(:,60),heltab2x4(:,:,196))
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(179),mass4set(:,14),  & 
G1H4(35),G1H4(39),G1H4(46),G1H4(41),G1H4(45),4)
  call HG1shiftOLR(G1H4(39),6,4)
  call Hloop_ZQ_A(ntryL,G1H8(2),wf8(:,18),G1H1(1),ngZu,m3h8x1(:,4),heltab2x8(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(196),n2h1(302))
  call Hloop_WQ_A(ntryL,G1H8(28),wf8(:,18),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(199),n2h1(303))
  call Hloop_ZQ_A(ntryL,G1H8(94),wf8(:,18),G1H1(1),ngZu,m3h8x1(:,6),heltab2x8(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(200),n2h1(304))
  call Hloop_ZQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),ngZu,m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(201),n2h1(305))
  call Hloop_ZQ_A(ntryL,G1H2(53),ex5(:),G1H1(1),ngZu,m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(202),n2h1(306))
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(150),mass4set(:,12),  & 
G1H4(47),G1H4(51),G1H4(53),G1H4(57),G1H4(64),4)
  call HG1shiftOLR(G1H4(51),9,4)
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(150),mass4set(:,13),  & 
G1H4(59),G1H4(63),G1H4(65),G1H4(69),G1H4(71),4)
  call HG1shiftOLR(G1H4(63),9,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(9),wf4(:,4),G1tensor(34),m3h4x1(:,61),heltab2x4(:,:,197))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(30),wf4(:,4),G1tensor(28),m3h4x1(:,62),heltab2x4(:,:,198))
  call Hotf_4pt_reduction(G2H4(28),RedSet_4(150),mass4set(:,14),  & 
G1H4(10),G1H4(76),G1H4(33),G1H4(34),G1H4(9),4)
  call HG1shiftOLR(G1H4(76),9,4)
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(156),mass4set(:,12),  & 
G1H4(30),G1H4(91),G1H4(92),G1H4(93),G1H4(94),4)
  call HG1shiftOLR(G1H4(91),9,4)
  call Hotf_4pt_reduction(G2H4(30),RedSet_4(156),mass4set(:,13),  & 
G1H4(95),G1H4(96),G1H4(97),G1H4(98),G1H4(99),4)
  call HG1shiftOLR(G1H4(96),9,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(18),wf4(:,4),G1tensor(39),m3h4x1(:,63),heltab2x4(:,:,199))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(19),wf4(:,4),G1tensor(46),m3h4x1(:,64),heltab2x4(:,:,200))
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(156),mass4set(:,14),  & 
G1H4(18),G1H4(19),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(19),9,4)
  call Hloop_ZQ_A(ntryL,G1H8(34),wf8(:,15),G1H1(1),ngZu,m3h8x1(:,7),heltab2x8(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(203),n2h1(307))
  call Hloop_WQ_A(ntryL,G1H8(35),wf8(:,15),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(204),n2h1(308))
  call Hloop_ZQ_A(ntryL,G1H8(36),wf8(:,15),G1H1(1),ngZu,m3h8x1(:,9),heltab2x8(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(205),n2h1(309))
  call Hloop_ZQ_A(ntryL,G1H2(89),ex5(:),G1H1(1),ngZu,m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(206),n2h1(310))
  call Hloop_ZQ_A(ntryL,G1H2(94),ex5(:),G1H1(1),ngZu,m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(207),n2h1(311))
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(144),mass4set(:,12),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),4)
  call HG1shiftOLR(G1H4(104),10,4)
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(144),mass4set(:,13),  & 
G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(109),10,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(22),wf4(:,2),G1tensor(57),m3h4x1(:,65),heltab2x4(:,:,201))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(2),wf4(:,2),G1tensor(64),m3h4x1(:,66),heltab2x4(:,:,202))
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(144),mass4set(:,14),  & 
G1H4(22),G1H4(2),G1H4(113),G1H4(114),G1H4(115),4)
  call HG1shiftOLR(G1H4(2),10,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(170),mass4set(:,12),  & 
G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(117),10,4)
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(170),mass4set(:,13),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),4)
  call HG1shiftOLR(G1H4(122),10,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(42),wf4(:,2),G1tensor(77),m3h4x1(:,67),heltab2x4(:,:,203))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(43),wf4(:,2),G1tensor(84),m3h4x1(:,68),heltab2x4(:,:,204))
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(170),mass4set(:,14),  & 
G1H4(42),G1H4(43),G1H4(126),G1H4(127),G1H4(128),4)
  call HG1shiftOLR(G1H4(43),10,4)
  call Hloop_ZQ_A(ntryL,G1H8(42),wf8(:,6),G1H1(1),ngZu,m3h8x1(:,10),heltab2x8(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(208),n2h1(312))
  call Hloop_WQ_A(ntryL,G1H8(43),wf8(:,6),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(209),n2h1(313))
  call Hloop_ZQ_A(ntryL,G1H8(44),wf8(:,6),G1H1(1),ngZu,m3h8x1(:,12),heltab2x8(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(210),n2h1(314))
  call Hloop_ZQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),ngZu,m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(211),n2h1(315))
  call Hloop_ZQ_A(ntryL,G1H2(76),ex5(:),G1H1(1),ngZu,m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(212),n2h1(316))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(23),ex4(:),G2tensor(213),ngZn,m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(24),ex4(:),G2tensor(214),ngZn,m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(25),ex4(:),G2tensor(215),ngZn,m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(26),ex4(:),G2tensor(216),ngZn,m3h2x1(:,282),heltab2x2(:,:,282))
  call Hloop_ZQ_A(ntryL,G1H2(100),ex2(:),G1H1(1),ngZn,m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(217),n2h1(317))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(27),ex2(:),G2tensor(218),ngZn,m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(28),ex2(:),G2tensor(219),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(29),ex3(:),G2tensor(220),ngZn,m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(30),ex3(:),G2tensor(221),ngZn,m3h2x1(:,287),heltab2x2(:,:,287))
  call Hloop_ZQ_A(ntryL,G1H2(117),ex2(:),G1H1(1),ngZn,m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(222),n2h1(318))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(31),ex2(:),G2tensor(223),ngZn,m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(32),ex2(:),G2tensor(224),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(33),ex4(:),G2tensor(225),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(226),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(227),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(41),ex4(:),G2tensor(228),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(42),ex5(:),G2tensor(229),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(45),ex5(:),G2tensor(230),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(47),ex5(:),G2tensor(231),ngZu,m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(50),ex5(:),G2tensor(232),ngZu,m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(51),ex5(:),G2tensor(233),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(53),ex5(:),G2tensor(234),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(54),ex5(:),G2tensor(235),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(56),ex5(:),G2tensor(236),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(57),ex5(:),G2tensor(237),ngZu,m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(59),ex5(:),G2tensor(238),ngZu,m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(60),ex5(:),G2tensor(239),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(62),ex5(:),G2tensor(240),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(65),ex4(:),G2tensor(241),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(66),ex5(:),G2tensor(242),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(68),ex5(:),G2tensor(243),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(69),ex5(:),G2tensor(244),ngZu,m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(71),ex5(:),G2tensor(245),ngZu,m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(72),ex5(:),G2tensor(246),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(74),ex5(:),G2tensor(247),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(75),ex5(:),G2tensor(248),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(77),ex5(:),G2tensor(249),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(78),ex5(:),G2tensor(250),ngZu,m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(80),ex5(:),G2tensor(251),ngZu,m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(81),ex5(:),G2tensor(252),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(83),ex5(:),G2tensor(253),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(86),ex4(:),G2tensor(254),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(89),ex3(:),G2tensor(255),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(92),ex3(:),G2tensor(256),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hloop_WQ_A(ntryL,G1H2(146),ex5(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(257),n2h1(319))
  call Hloop_WQ_A(ntryL,G1H2(150),ex5(:),G1H1(1),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(258),n2h1(320))
  call Hloop_WQ_A(ntryL,G1H2(156),ex5(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(259),n2h1(321))
  call Hloop_WQ_A(ntryL,G1H2(157),ex5(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(260),n2h1(322))
  call Hloop_WQ_A(ntryL,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(261),n2h1(323))
  call Hloop_WQ_A(ntryL,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(262),n2h1(324))
  call Hloop_WQ_A(ntryL,G1H2(168),ex5(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(263),n2h1(325))
  call Hloop_WQ_A(ntryL,G1H2(169),ex5(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(264),n2h1(326))
  call Hloop_WQ_A(ntryL,G1H2(175),ex5(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(265),n2h1(327))
  call Hloop_WQ_A(ntryL,G1H2(176),ex5(:),G1H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(266),n2h1(328))
  call Hloop_WQ_A(ntryL,G1H2(180),ex5(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(267),n2h1(329))
  call Hloop_WQ_A(ntryL,G1H2(186),ex5(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(268),n2h1(330))
  call Hloop_QZ_A(ntryL,G1H4(68),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,69),heltab2x4(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(269),n2h1(331))
  call Hloop_QZ_A(ntryL,G1H4(72),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,70),heltab2x4(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(270),n2h1(332))
  call Hloop_QZ_A(ntryL,G1H4(29),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,71),heltab2x4(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(271),n2h1(333))
  call Hloop_QZ_A(ntryL,G1H4(73),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,72),heltab2x4(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(272),n2h1(334))
  call Hloop_QZ_A(ntryL,G1H4(74),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,73),heltab2x4(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(273),n2h1(335))
  call Hloop_QZ_A(ntryL,G1H4(78),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,74),heltab2x4(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(274),n2h1(336))
  call Hloop_WA_Q(ntryL,G1H2(187),ex4(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(275),n2h1(337))
  call Hloop_WA_Q(ntryL,G1H2(188),ex4(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(276),n2h1(338))
  call Hloop_WA_Q(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(277),n2h1(339))
  call Hloop_WA_Q(ntryL,G1H2(198),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(278),n2h1(340))
  call Hloop_WA_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(279),n2h1(341))
  call Hloop_WA_Q(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(280),n2h1(342))
  call Hloop_ZA_Q(ntryL,G1H2(92),ex4(:),G1H1(1),ngZn,m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(281),n2h1(343))
  call Hloop_ZA_Q(ntryL,G1H2(104),ex4(:),G1H1(1),ngZn,m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(282),n2h1(344))
  call Hloop_ZA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),ngZn,m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(283),n2h1(345))
  call Hloop_WA_Q(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(284),n2h1(346))
  call Hloop_WA_Q(ntryL,G1H2(118),ex3(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(285),n2h1(347))
  call Hloop_WA_Q(ntryL,G1H2(93),ex3(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(286),n2h1(348))
  call Hloop_WA_Q(ntryL,G1H2(121),ex4(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(287),n2h1(349))
  call Hloop_WA_Q(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(288),n2h1(350))
  call Hloop_WA_Q(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(289),n2h1(351))
  call Hloop_WA_Q(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(290),n2h1(352))
  call Hloop_WA_Q(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(291),n2h1(353))
  call Hloop_WA_Q(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(292),n2h1(354))
  call Hloop_ZA_Q(ntryL,G1H2(128),ex4(:),G1H1(1),ngZn,m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(293),n2h1(355))
  call Hloop_ZA_Q(ntryL,G1H2(99),ex4(:),G1H1(1),ngZn,m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(294),n2h1(356))
  call Hloop_ZA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),ngZn,m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(295),n2h1(357))
  call Hloop_WA_Q(ntryL,G1H2(83),ex3(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(296),n2h1(358))
  call Hloop_WA_Q(ntryL,G1H2(85),ex3(:),G1H1(1),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(297),n2h1(359))
  call Hloop_WA_Q(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(298),n2h1(360))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(79),53,wf4(:,2),10,G2tensor(299),m3h4x1(:,75),heltab2x4(:,:,211))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(80),0,wf4(:,2),10,G2tensor(300),m3h4x1(:,76),heltab2x4(:,:,212))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(83),53,wf4(:,2),10,G2tensor(301),m3h4x1(:,77),heltab2x4(:,:,213))
  call Hloop_AZ_Q(ntryL,G1H4(84),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,78),heltab2x4(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(302),n2h1(362))
  call Hloop_AZ_Q(ntryL,G1H4(85),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,79),heltab2x4(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(303),n2h1(363))
  call Hloop_AZ_Q(ntryL,G1H4(88),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,80),heltab2x4(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(304),n2h1(364))
  call Hloop_AZ_Q(ntryL,G1H4(89),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,81),heltab2x4(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(305),n2h1(365))
  call Hloop_AZ_Q(ntryL,G1H4(90),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,82),heltab2x4(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(306),n2h1(366))
  call Hloop_AZ_Q(ntryL,G1H4(28),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,83),heltab2x4(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(307),n2h1(367))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(8),58,wf4(:,1),5,G2tensor(308),m3h4x1(:,84),heltab2x4(:,:,220))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(11),0,wf4(:,1),5,G2tensor(309),m3h4x1(:,85),heltab2x4(:,:,221))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(48),58,wf4(:,1),5,G2tensor(310),m3h4x1(:,86),heltab2x4(:,:,222))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(40),54,wf4(:,4),9,G2tensor(311),m3h4x1(:,87),heltab2x4(:,:,223))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(52),0,wf4(:,4),9,G2tensor(312),m3h4x1(:,88),heltab2x4(:,:,224))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(5),54,wf4(:,4),9,G2tensor(313),m3h4x1(:,89),heltab2x4(:,:,225))
  call Hloop_AZ_Q(ntryL,G1H4(6),wf4(:,5),G1H1(1),ngZl,m3h4x1(:,90),heltab2x4(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(314),n2h1(370))
  call Hloop_AZ_Q(ntryL,G1H4(7),wf4(:,5),G1H1(1),ngZl,m3h4x1(:,91),heltab2x4(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(315),n2h1(371))
  call Hloop_AZ_Q(ntryL,G1H4(17),wf4(:,5),G1H1(1),ngZl,m3h4x1(:,92),heltab2x4(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(316),n2h1(372))
  call Hloop_AZ_Q(ntryL,G1H4(23),wf4(:,5),G1H1(1),ngZn,m3h4x1(:,93),heltab2x4(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(317),n2h1(373))
  call Hloop_AZ_Q(ntryL,G1H4(24),wf4(:,5),G1H1(1),ngZn,m3h4x1(:,94),heltab2x4(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(318),n2h1(374))
  call Hloop_AZ_Q(ntryL,G1H4(32),wf4(:,5),G1H1(1),ngZn,m3h4x1(:,95),heltab2x4(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(319),n2h1(375))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(35),57,wf4(:,5),6,G2tensor(320),m3h4x1(:,96),heltab2x4(:,:,232))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(39),0,wf4(:,5),6,G2tensor(321),m3h4x1(:,97),heltab2x4(:,:,233))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(45),57,wf4(:,5),6,G2tensor(322),m3h4x1(:,98),heltab2x4(:,:,234))
  call Hloop_QZ_A(ntryL,G1H4(47),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,99),heltab2x4(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(323),n2h1(377))
  call Hloop_QZ_A(ntryL,G1H4(51),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,100),heltab2x4(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(324),n2h1(378))
  call Hloop_QZ_A(ntryL,G1H4(64),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,101),heltab2x4(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(325),n2h1(379))
  call Hloop_QZ_A(ntryL,G1H4(59),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,102),heltab2x4(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(326),n2h1(380))
  call Hloop_QZ_A(ntryL,G1H4(63),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,103),heltab2x4(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(327),n2h1(381))
  call Hloop_QZ_A(ntryL,G1H4(71),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,104),heltab2x4(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(328),n2h1(382))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(10),54,wf4(:,4),9,G2tensor(329),m3h4x1(:,105),heltab2x4(:,:,241))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(76),0,wf4(:,4),9,G2tensor(330),m3h4x1(:,106),heltab2x4(:,:,242))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(9),54,wf4(:,4),9,G2tensor(331),m3h4x1(:,107),heltab2x4(:,:,243))
  call Hloop_AZ_Q(ntryL,G1H4(30),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,108),heltab2x4(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(332),n2h1(384))
  call Hloop_AZ_Q(ntryL,G1H4(91),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,109),heltab2x4(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(333),n2h1(385))
  call Hloop_AZ_Q(ntryL,G1H4(94),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,110),heltab2x4(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(334),n2h1(386))
  call Hloop_AZ_Q(ntryL,G1H4(95),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,111),heltab2x4(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(335),n2h1(387))
  call Hloop_AZ_Q(ntryL,G1H4(96),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,112),heltab2x4(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(336),n2h1(388))
  call Hloop_AZ_Q(ntryL,G1H4(99),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,113),heltab2x4(:,:,249))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(337),n2h1(389))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(18),54,wf4(:,4),9,G2tensor(338),m3h4x1(:,114),heltab2x4(:,:,250))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(19),0,wf4(:,4),9,G2tensor(339),m3h4x1(:,115),heltab2x4(:,:,251))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(102),54,wf4(:,4),9,G2tensor(340),m3h4x1(:,116),heltab2x4(:,:,252))
  call Hloop_QZ_A(ntryL,G1H4(103),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,117),heltab2x4(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(341),n2h1(391))
  call Hloop_QZ_A(ntryL,G1H4(104),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,118),heltab2x4(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(342),n2h1(392))
  call Hloop_QZ_A(ntryL,G1H4(107),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,119),heltab2x4(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(343),n2h1(393))
  call Hloop_QZ_A(ntryL,G1H4(108),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,120),heltab2x4(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(344),n2h1(394))
  call Hloop_QZ_A(ntryL,G1H4(109),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,121),heltab2x4(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(345),n2h1(395))
  call Hloop_QZ_A(ntryL,G1H4(112),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,122),heltab2x4(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(346),n2h1(396))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(22),53,wf4(:,2),10,G2tensor(347),m3h4x1(:,123),heltab2x4(:,:,259))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(2),0,wf4(:,2),10,G2tensor(348),m3h4x1(:,124),heltab2x4(:,:,260))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(115),53,wf4(:,2),10,G2tensor(349),m3h4x1(:,125),heltab2x4(:,:,261))
  call Hloop_AZ_Q(ntryL,G1H4(116),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,126),heltab2x4(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(350),n2h1(398))
  call Hloop_AZ_Q(ntryL,G1H4(117),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,127),heltab2x4(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(351),n2h1(399))
  call Hloop_AZ_Q(ntryL,G1H4(120),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,128),heltab2x4(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(352),n2h1(400))
  call Hloop_AZ_Q(ntryL,G1H4(121),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,129),heltab2x4(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(353),n2h1(401))
  call Hloop_AZ_Q(ntryL,G1H4(122),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,130),heltab2x4(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(354),n2h1(402))
  call Hloop_AZ_Q(ntryL,G1H4(125),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,131),heltab2x4(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(355),n2h1(403))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(42),53,wf4(:,2),10,G2tensor(356),m3h4x1(:,132),heltab2x4(:,:,268))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(43),0,wf4(:,2),10,G2tensor(357),m3h4x1(:,133),heltab2x4(:,:,269))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(128),53,wf4(:,2),10,G2tensor(358),m3h4x1(:,134),heltab2x4(:,:,270))
  call ol_merge_tensors(G2tensor(62),[G1tensor(486)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(492)])
  call ol_merge_tensors(G2tensor(338),[G2tensor(86),G2tensor(66),G1tensor(39),G1tensor(260),G1tensor(52)])
  call ol_merge_tensors(G2tensor(308),[G2tensor(101),G2tensor(68),G1tensor(109),G1tensor(320),G1tensor(21)])
  call ol_merge_tensors(G2tensor(356),[G2tensor(116),G2tensor(70),G1tensor(77),G1tensor(392),G1tensor(54)])
  call ol_merge_tensors(G2tensor(320),[G2tensor(131),G2tensor(72),G1tensor(76),G1tensor(470),G1tensor(120)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(218),G1tensor(50)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(222)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(230),G1tensor(86)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(234)])
  call ol_merge_tensors(G2tensor(225),[G2tensor(80),G1tensor(248),G1tensor(116)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(252)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(83),G1tensor(254),G1tensor(3)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(258)])
  call ol_merge_tensors(G2tensor(204),[G2tensor(153),G2tensor(87),G1tensor(534),G1tensor(264)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(278),G1tensor(6)])
  call ol_merge_tensors(G2tensor(90),[G1tensor(282)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(290),G1tensor(48)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(294)])
  call ol_merge_tensors(G2tensor(169),[G2tensor(95),G1tensor(308),G1tensor(30)])
  call ol_merge_tensors(G2tensor(96),[G1tensor(312)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(98),G1tensor(314),G1tensor(18)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(318)])
  call ol_merge_tensors(G2tensor(184),[G2tensor(138),G2tensor(102),G1tensor(504),G1tensor(324)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(338),G1tensor(27)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(342)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(362),G1tensor(45)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(366)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(110),G1tensor(380),G1tensor(53)])
  call ol_merge_tensors(G2tensor(111),[G1tensor(384)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(113),G1tensor(386),G1tensor(72)])
  call ol_merge_tensors(G2tensor(114),[G1tensor(390)])
  call ol_merge_tensors(G2tensor(209),[G2tensor(162),G2tensor(117),G1tensor(552),G1tensor(396)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(422),G1tensor(71)])
  call ol_merge_tensors(G2tensor(120),[G1tensor(426)])
  call ol_merge_tensors(G2tensor(122),[G1tensor(440),G1tensor(93)])
  call ol_merge_tensors(G2tensor(123),[G1tensor(444)])
  call ol_merge_tensors(G2tensor(178),[G2tensor(125),G1tensor(458),G1tensor(105)])
  call ol_merge_tensors(G2tensor(126),[G1tensor(462)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(128),G1tensor(464),G1tensor(107)])
  call ol_merge_tensors(G2tensor(129),[G1tensor(468)])
  call ol_merge_tensors(G2tensor(199),[G2tensor(144),G2tensor(132),G1tensor(516),G1tensor(474)])
  call ol_merge_tensors(G2tensor(193),[G2tensor(134),G1tensor(494),G1tensor(357),G1tensor(153),G1tensor(147)])
  call ol_merge_tensors(G2tensor(181),[G2tensor(135),G1tensor(498),G1tensor(300)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(137),G1tensor(500),G1tensor(381),G1tensor(375)])
  call ol_merge_tensors(G2tensor(202),[G2tensor(140),G1tensor(506),G1tensor(225),G1tensor(195),G1tensor(189)])
  call ol_merge_tensors(G2tensor(196),[G2tensor(141),G1tensor(510),G1tensor(450)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(143),G1tensor(512),G1tensor(249),G1tensor(243)])
  call ol_merge_tensors(G2tensor(206),[G2tensor(146),G1tensor(518),G1tensor(477),G1tensor(213),G1tensor(207)])
  call ol_merge_tensors(G2tensor(205),[G2tensor(147),G1tensor(522),G1tensor(204)])
  call ol_merge_tensors(G2tensor(207),[G2tensor(149),G1tensor(524),G1tensor(435),G1tensor(177),G1tensor(171)])
  call ol_merge_tensors(G2tensor(203),[G2tensor(150),G1tensor(528),G1tensor(240)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(152),G1tensor(530),G1tensor(459),G1tensor(453)])
  call ol_merge_tensors(G2tensor(211),[G2tensor(155),G1tensor(536),G1tensor(345),G1tensor(333),G1tensor(327)])
  call ol_merge_tensors(G2tensor(210),[G2tensor(156),G1tensor(540),G1tensor(168)])
  call ol_merge_tensors(G2tensor(212),[G2tensor(158),G1tensor(542),G1tensor(285),G1tensor(129),G1tensor(123)])
  call ol_merge_tensors(G2tensor(208),[G2tensor(159),G1tensor(546),G1tensor(372)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(161),G1tensor(548),G1tensor(309),G1tensor(303)])
  call ol_merge_tensors(G2tensor(220),[G2tensor(164),G1tensor(554),G1tensor(122),G1tensor(13)])
  call ol_merge_tensors(G2tensor(168),[G2tensor(165),G1tensor(564),G1tensor(558)])
  call ol_merge_tensors(G2tensor(215),[G2tensor(167),G1tensor(560),G1tensor(188),G1tensor(2)])
  call ol_merge_tensors(G2tensor(221),[G2tensor(170),G1tensor(566),G1tensor(170),G1tensor(85)])
  call ol_merge_tensors(G2tensor(174),[G2tensor(171),G1tensor(576),G1tensor(570)])
  call ol_merge_tensors(G2tensor(216),[G2tensor(173),G1tensor(572),G1tensor(146),G1tensor(49)])
  call ol_merge_tensors(G2tensor(176),[G1tensor(578)])
  call ol_merge_tensors(G2tensor(332),[G2tensor(177),G1tensor(582)])
  call ol_merge_tensors(G2tensor(179),[G1tensor(584),G1tensor(326),G1tensor(96)])
  call ol_merge_tensors(G2tensor(335),[G2tensor(180),G1tensor(588)])
  call ol_merge_tensors(G2tensor(182),[G1tensor(590)])
  call ol_merge_tensors(G2tensor(302),[G2tensor(183),G1tensor(594)])
  call ol_merge_tensors(G2tensor(185),[G1tensor(596),G1tensor(410),G1tensor(69)])
  call ol_merge_tensors(G2tensor(305),[G2tensor(186),G1tensor(600)])
  call ol_merge_tensors(G2tensor(224),[G2tensor(188),G1tensor(602)])
  call ol_merge_tensors(G2tensor(350),[G2tensor(189),G1tensor(606)])
  call ol_merge_tensors(G2tensor(223),[G2tensor(191),G1tensor(608),G1tensor(206),G1tensor(38)])
  call ol_merge_tensors(G2tensor(353),[G2tensor(192),G1tensor(612)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(194),G1tensor(614)])
  call ol_merge_tensors(G2tensor(314),[G2tensor(195),G1tensor(618)])
  call ol_merge_tensors(G2tensor(218),[G2tensor(197),G1tensor(620),G1tensor(266),G1tensor(5)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(198),G1tensor(624)])
  call ol_merge_tensors(G1tensor(128),[G1tensor(11),G1tensor(19)])
  call ol_merge_tensors(G1tensor(134),[G1tensor(97),G1tensor(25)])
  call ol_merge_tensors(G1tensor(140),[G1tensor(118),G1tensor(31)])
  call ol_merge_tensors(G1tensor(152),[G1tensor(42),G1tensor(55)])
  call ol_merge_tensors(G1tensor(158),[G1tensor(14),G1tensor(61)])
  call ol_merge_tensors(G1tensor(164),[G1tensor(9),G1tensor(67)])
  call ol_merge_tensors(G1tensor(176),[G1tensor(89),G1tensor(91)])
  call ol_merge_tensors(G1tensor(182),[G1tensor(56),G1tensor(103)])
  call ol_merge_tensors(G1tensor(194),[G1tensor(80),G1tensor(8)])
  call ol_merge_tensors(G1tensor(200),[G1tensor(75),G1tensor(20)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(597),G1tensor(32)])
  call ol_merge_tensors(G1tensor(212),[G1tensor(113),G1tensor(44)])
  call ol_merge_tensors(G2tensor(214),[G1tensor(224),G1tensor(74)])
  call ol_merge_tensors(G1tensor(236),[G1tensor(83),G1tensor(92)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(104)])
  call ol_merge_tensors(G2tensor(163),[G1tensor(242),G1tensor(110)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(585),G1tensor(17)])
  call ol_merge_tensors(G1tensor(272),[G1tensor(60),G1tensor(66)])
  call ol_merge_tensors(G1tensor(284),[G1tensor(23)])
  call ol_merge_tensors(G1tensor(296),[G1tensor(36),G1tensor(12)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(106)])
  call ol_merge_tensors(G2tensor(166),[G1tensor(302),G1tensor(16)])
  call ol_merge_tensors(G2tensor(145),[G1tensor(621),G1tensor(22)])
  call ol_merge_tensors(G1tensor(332),[G1tensor(35),G1tensor(24)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(573),G1tensor(29)])
  call ol_merge_tensors(G1tensor(344),[G1tensor(33)])
  call ol_merge_tensors(G1tensor(350),[G1tensor(82),G1tensor(102)])
  call ol_merge_tensors(G2tensor(222),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(213),[G1tensor(356),G1tensor(41)])
  call ol_merge_tensors(G1tensor(368),[G1tensor(70),G1tensor(88)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(172),[G1tensor(374),G1tensor(51)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(555),G1tensor(58)])
  call ol_merge_tensors(G1tensor(398),[G1tensor(59)])
  call ol_merge_tensors(G1tensor(404),[G1tensor(114),G1tensor(63)])
  call ol_merge_tensors(G2tensor(136),[G1tensor(609),G1tensor(65)])
  call ol_merge_tensors(G1tensor(416),[G1tensor(81),G1tensor(101)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(567),G1tensor(90)])
  call ol_merge_tensors(G1tensor(428),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(217),[G1tensor(87)])
  call ol_merge_tensors(G1tensor(434),[G1tensor(119)])
  call ol_merge_tensors(G1tensor(446),[G1tensor(117),G1tensor(100)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(95)])
  call ol_merge_tensors(G2tensor(175),[G1tensor(452),G1tensor(99)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(561),G1tensor(111)])
  call ol_merge_tensors(G1tensor(476),[G1tensor(112)])
  call ol_merge_tensors(G1tensor(172),[G1tensor(135),G1tensor(124)])
  call ol_merge_tensors(G1tensor(329),[G1tensor(141),G1tensor(125)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(442),G1tensor(292),G1tensor(178),G1tensor(136),G1tensor(130)])
  call ol_merge_tensors(G1tensor(335),[G1tensor(298),G1tensor(142),G1tensor(131)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(341),G1tensor(221),G1tensor(185),G1tensor(143),G1tensor(137)])
  call ol_merge_tensors(G2tensor(187),[G1tensor(144)])
  call ol_merge_tensors(G1tensor(190),[G1tensor(159),G1tensor(148)])
  call ol_merge_tensors(G1tensor(269),[G1tensor(165),G1tensor(149)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(364),G1tensor(232),G1tensor(196),G1tensor(160),G1tensor(154)])
  call ol_merge_tensors(G1tensor(370),[G1tensor(275),G1tensor(166),G1tensor(155)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(425),G1tensor(281),G1tensor(203),G1tensor(167),G1tensor(161)])
  call ol_merge_tensors(G1tensor(209),[G1tensor(183),G1tensor(173)])
  call ol_merge_tensors(G1tensor(448),[G1tensor(215),G1tensor(184),G1tensor(179)])
  call ol_merge_tensors(G2tensor(200),[G1tensor(186)])
  call ol_merge_tensors(G1tensor(413),[G1tensor(201),G1tensor(191)])
  call ol_merge_tensors(G1tensor(419),[G1tensor(238),G1tensor(202),G1tensor(197)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(219),G1tensor(208)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(406),G1tensor(280),G1tensor(274),G1tensor(220),G1tensor(214)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(231),G1tensor(226)])
  call ol_merge_tensors(G1tensor(431),[G1tensor(237),G1tensor(227)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(353),G1tensor(299),G1tensor(293),G1tensor(239),G1tensor(233)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(255),G1tensor(244)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(261),G1tensor(245)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(388),G1tensor(382),G1tensor(256),G1tensor(250)])
  call ol_merge_tensors(G2tensor(257),[G1tensor(262),G1tensor(251)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(323),G1tensor(317),G1tensor(263),G1tensor(257)])
  call ol_merge_tensors(G2tensor(190),[G1tensor(399),G1tensor(273),G1tensor(267)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(279),G1tensor(268)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(291),G1tensor(286)])
  call ol_merge_tensors(G1tensor(347),[G1tensor(297),G1tensor(287)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(315),G1tensor(304)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(321),G1tensor(305)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(466),G1tensor(460),G1tensor(316),G1tensor(310)])
  call ol_merge_tensors(G2tensor(260),[G1tensor(322),G1tensor(311)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(339),G1tensor(328)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(424),G1tensor(418),G1tensor(352),G1tensor(340),G1tensor(334)])
  call ol_merge_tensors(G1tensor(430),[G1tensor(351),G1tensor(346)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(363),G1tensor(358)])
  call ol_merge_tensors(G1tensor(401),[G1tensor(369),G1tensor(359)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(449),G1tensor(443),G1tensor(407),G1tensor(371),G1tensor(365)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(387),G1tensor(376)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(393),G1tensor(377)])
  call ol_merge_tensors(G2tensor(263),[G1tensor(394),G1tensor(383)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(473),G1tensor(467),G1tensor(395),G1tensor(389)])
  call ol_merge_tensors(G1tensor(478),[G1tensor(405),G1tensor(400)])
  call ol_merge_tensors(G2tensor(201),[G1tensor(429),G1tensor(417),G1tensor(411)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(423),G1tensor(412)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(441),G1tensor(436)])
  call ol_merge_tensors(G1tensor(479),[G1tensor(447),G1tensor(437)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(465),G1tensor(454)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(471),G1tensor(455)])
  call ol_merge_tensors(G2tensor(266),[G1tensor(472),G1tensor(461)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(482)])
  call ol_merge_tensors(G2tensor(151),[G1tensor(483)])
  call ol_merge_tensors(G2tensor(154),[G1tensor(484)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(485)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(488)])
  call ol_merge_tensors(G2tensor(157),[G1tensor(489)])
  call ol_merge_tensors(G2tensor(160),[G1tensor(490)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(491)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(495)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(496)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(497)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(501)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(502)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(503)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(507)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(508)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(509)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(513)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(514)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(515)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(519)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(526),G1tensor(520)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(521)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(525)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(527)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(531)])
  call ol_merge_tensors(G2tensor(269),[G1tensor(532)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(533)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(537)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(544),G1tensor(538)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(539)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(543)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(545)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(549)])
  call ol_merge_tensors(G2tensor(272),[G1tensor(550)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(551)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(568),G1tensor(556)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(587),G1tensor(557)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(574),G1tensor(562)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(599),G1tensor(563)])
  call ol_merge_tensors(G2tensor(121),[G1tensor(611),G1tensor(569)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(623),G1tensor(575)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(579)])
  call ol_merge_tensors(G2tensor(275),[G1tensor(580)])
  call ol_merge_tensors(G2tensor(278),[G1tensor(581)])
  call ol_merge_tensors(G2tensor(281),[G1tensor(586)])
  call ol_merge_tensors(G2tensor(130),[G1tensor(591)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(592)])
  call ol_merge_tensors(G2tensor(284),[G1tensor(593)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(598)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(603)])
  call ol_merge_tensors(G2tensor(287),[G1tensor(604)])
  call ol_merge_tensors(G2tensor(290),[G1tensor(605)])
  call ol_merge_tensors(G2tensor(293),[G1tensor(610)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(615)])
  call ol_merge_tensors(G2tensor(142),[G1tensor(616)])
  call ol_merge_tensors(G2tensor(296),[G1tensor(617)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(622)])
  call ol_merge_tensors(G2tensor(329),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(347),[G1tensor(57)])
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(184),mass4set(:,15),  & 
G1tensor(94),G1tensor(108),G1tensor(121),G1tensor(127),G1tensor(133))
  call G_TensorShift(G1tensor(108),10)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(189),mass4set(:,15),  & 
G1tensor(139),G1tensor(145),G1tensor(151),G1tensor(157),G1tensor(163))
  call G_TensorShift(G1tensor(145),9)
  call Hotf_4pt_reduction_last(G2tensor(338),RedSet_4(156),mass4set(:,14),  & 
G1tensor(169),G1tensor(175),G1tensor(181),G1tensor(187),G1tensor(193))
  call G_TensorShift(G1tensor(175),9)
  call Hotf_4pt_reduction_last(G2tensor(308),RedSet_4(162),mass4set(:,14),  & 
G1tensor(199),G1tensor(205),G1tensor(211),G1tensor(217),G1tensor(223))
  call G_TensorShift(G1tensor(205),5)
  call Hotf_4pt_reduction_last(G2tensor(356),RedSet_4(170),mass4set(:,14),  & 
G1tensor(229),G1tensor(235),G1tensor(241),G1tensor(247),G1tensor(253))
  call G_TensorShift(G1tensor(235),10)
  call Hotf_4pt_reduction_last(G2tensor(320),RedSet_4(179),mass4set(:,14),  & 
G1tensor(259),G1tensor(265),G1tensor(271),G1tensor(277),G1tensor(283))
  call G_TensorShift(G1tensor(265),6)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(153),mass4set(:,16),  & 
G1tensor(289),G1tensor(295),G1tensor(301),G1tensor(307),G1tensor(313))
  call G_TensorShift(G1tensor(295),2)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(58),mass4set(:,17),  & 
G1tensor(319),G1tensor(325),G1tensor(331),G1tensor(337),G1tensor(343))
  call G_TensorShift(G1tensor(325),18)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(155),mass4set(:,16),  & 
G1tensor(349),G1tensor(355),G1tensor(361),G1tensor(367),G1tensor(373))
  call G_TensorShift(G1tensor(355),8)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(66),mass4set(:,17),  & 
G1tensor(379),G1tensor(385),G1tensor(391),G1tensor(397),G1tensor(403))
  call G_TensorShift(G1tensor(385),24)
  call Hotf_4pt_reduction_last(G2tensor(225),RedSet_4(149),mass4set(:,1),  & 
G1tensor(409),G1tensor(415),G1tensor(421),G1tensor(427),G1tensor(433))
  call G_TensorShift(G1tensor(415),8)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(46),mass4set(:,7),  & 
G1tensor(439),G1tensor(445),G1tensor(451),G1tensor(457),G1tensor(463))
  call G_TensorShift(G1tensor(445),24)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(155),mass4set(:,5),  & 
G1tensor(469),G1tensor(475),G1tensor(481),G1tensor(487),G1tensor(493))
  call G_TensorShift(G1tensor(475),8)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(66),mass4set(:,18),  & 
G1tensor(499),G1tensor(505),G1tensor(511),G1tensor(517),G1tensor(523))
  call G_TensorShift(G1tensor(505),24)
  call Hotf_4pt_reduction_last(G2tensor(204),RedSet_4(68),mass4set(:,19),  & 
G1tensor(529),G1tensor(535),G1tensor(541),G1tensor(547),G1tensor(553))
  call G_TensorShift(G1tensor(535),25)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(159),mass4set(:,16),  & 
G1tensor(559),G1tensor(565),G1tensor(571),G1tensor(577),G1tensor(583))
  call G_TensorShift(G1tensor(565),2)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(77),mass4set(:,17),  & 
G1tensor(589),G1tensor(595),G1tensor(601),G1tensor(607),G1tensor(613))
  call G_TensorShift(G1tensor(595),18)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(161),mass4set(:,16),  & 
G1tensor(619),G1tensor(486),G1tensor(492),G1tensor(39),G1tensor(260))
  call G_TensorShift(G1tensor(486),4)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(82),mass4set(:,17),  & 
G1tensor(52),G1tensor(109),G1tensor(320),G1tensor(21),G1tensor(77))
  call G_TensorShift(G1tensor(109),20)
  call Hotf_4pt_reduction_last(G2tensor(169),RedSet_4(138),mass4set(:,1),  & 
G1tensor(392),G1tensor(54),G1tensor(76),G1tensor(470),G1tensor(120))
  call G_TensorShift(G1tensor(54),4)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(8),mass4set(:,7),  & 
G1tensor(218),G1tensor(50),G1tensor(222),G1tensor(230),G1tensor(86))
  call G_TensorShift(G1tensor(50),20)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(161),mass4set(:,5),  & 
G1tensor(234),G1tensor(248),G1tensor(116),G1tensor(252),G1tensor(254))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(82),mass4set(:,18),  & 
G1tensor(3),G1tensor(258),G1tensor(534),G1tensor(264),G1tensor(278))
  call G_TensorShift(G1tensor(258),20)
  call Hotf_4pt_reduction_last(G2tensor(184),RedSet_4(84),mass4set(:,19),  & 
G1tensor(6),G1tensor(282),G1tensor(290),G1tensor(48),G1tensor(294))
  call G_TensorShift(G1tensor(282),21)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(165),mass4set(:,16),  & 
G1tensor(308),G1tensor(30),G1tensor(312),G1tensor(314),G1tensor(18))
  call G_TensorShift(G1tensor(30),1)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(93),mass4set(:,17),  & 
G1tensor(318),G1tensor(504),G1tensor(324),G1tensor(338),G1tensor(27))
  call G_TensorShift(G1tensor(504),17)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(169),mass4set(:,16),  & 
G1tensor(342),G1tensor(362),G1tensor(45),G1tensor(366),G1tensor(380))
  call G_TensorShift(G1tensor(362),8)
  call Hotf_4pt_reduction_last(G2tensor(108),RedSet_4(107),mass4set(:,17),  & 
G1tensor(53),G1tensor(384),G1tensor(386),G1tensor(72),G1tensor(390))
  call G_TensorShift(G1tensor(384),24)
  call Hotf_4pt_reduction_last(G2tensor(227),RedSet_4(142),mass4set(:,1),  & 
G1tensor(552),G1tensor(396),G1tensor(422),G1tensor(71),G1tensor(426))
  call G_TensorShift(G1tensor(396),8)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(23),mass4set(:,7),  & 
G1tensor(440),G1tensor(93),G1tensor(444),G1tensor(458),G1tensor(105))
  call G_TensorShift(G1tensor(93),24)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(169),mass4set(:,5),  & 
G1tensor(462),G1tensor(464),G1tensor(107),G1tensor(468),G1tensor(516))
  call G_TensorShift(G1tensor(464),8)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(107),mass4set(:,18),  & 
G1tensor(474),G1tensor(494),G1tensor(357),G1tensor(153),G1tensor(147))
  call G_TensorShift(G1tensor(494),24)
  call Hotf_4pt_reduction_last(G2tensor(209),RedSet_4(109),mass4set(:,19),  & 
G1tensor(498),G1tensor(300),G1tensor(500),G1tensor(381),G1tensor(375))
  call G_TensorShift(G1tensor(300),26)
  call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(175),mass4set(:,16),  & 
G1tensor(506),G1tensor(225),G1tensor(195),G1tensor(189),G1tensor(510))
  call G_TensorShift(G1tensor(225),1)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(122),mass4set(:,17),  & 
G1tensor(450),G1tensor(512),G1tensor(249),G1tensor(243),G1tensor(518))
  call G_TensorShift(G1tensor(512),17)
  call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(178),mass4set(:,16),  & 
G1tensor(477),G1tensor(213),G1tensor(207),G1tensor(522),G1tensor(204))
  call G_TensorShift(G1tensor(213),4)
  call Hotf_4pt_reduction_last(G2tensor(123),RedSet_4(130),mass4set(:,17),  & 
G1tensor(524),G1tensor(435),G1tensor(177),G1tensor(171),G1tensor(528))
  call G_TensorShift(G1tensor(435),20)
  call Hotf_4pt_reduction_last(G2tensor(178),RedSet_4(146),mass4set(:,1),  & 
G1tensor(240),G1tensor(530),G1tensor(459),G1tensor(453),G1tensor(536))
  call G_TensorShift(G1tensor(530),4)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(36),mass4set(:,7),  & 
G1tensor(345),G1tensor(333),G1tensor(327),G1tensor(540),G1tensor(168))
  call G_TensorShift(G1tensor(333),20)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(178),mass4set(:,5),  & 
G1tensor(542),G1tensor(285),G1tensor(129),G1tensor(123),G1tensor(546))
  call G_TensorShift(G1tensor(285),4)
  call Hotf_4pt_reduction_last(G2tensor(129),RedSet_4(130),mass4set(:,18),  & 
G1tensor(372),G1tensor(548),G1tensor(309),G1tensor(303),G1tensor(554))
  call G_TensorShift(G1tensor(548),20)
  call Hotf_4pt_reduction_last(G2tensor(199),RedSet_4(132),mass4set(:,19),  & 
G1tensor(122),G1tensor(13),G1tensor(564),G1tensor(558),G1tensor(560))
  call G_TensorShift(G1tensor(13),22)
  call Hotf_4pt_reduction_last(G2tensor(193),RedSet_4(16),mass4set(:,20),  & 
G1tensor(188),G1tensor(2),G1tensor(566),G1tensor(170),G1tensor(85))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_4pt_reduction_last(G2tensor(181),RedSet_4(84),mass4set(:,20),  & 
G1tensor(576),G1tensor(570),G1tensor(572),G1tensor(146),G1tensor(49))
  call G_TensorShift(G1tensor(570),21)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(16),mass4set(:,19),  & 
G1tensor(578),G1tensor(582),G1tensor(584),G1tensor(326),G1tensor(96))
  call G_TensorShift(G1tensor(582),16)
  call Hotf_4pt_reduction_last(G2tensor(202),RedSet_4(41),mass4set(:,20),  & 
G1tensor(588),G1tensor(590),G1tensor(594),G1tensor(596),G1tensor(410))
  call G_TensorShift(G1tensor(590),16)
  call Hotf_4pt_reduction_last(G2tensor(196),RedSet_4(132),mass4set(:,20),  & 
G1tensor(69),G1tensor(600),G1tensor(602),G1tensor(606),G1tensor(608))
  call G_TensorShift(G1tensor(600),22)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(41),mass4set(:,19),  & 
G1tensor(206),G1tensor(38),G1tensor(612),G1tensor(614),G1tensor(618))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_4pt_reduction_last(G2tensor(206),RedSet_4(51),mass4set(:,20),  & 
G1tensor(620),G1tensor(266),G1tensor(5),G1tensor(624),G1tensor(11))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_4pt_reduction_last(G2tensor(205),RedSet_4(48),mass4set(:,20),  & 
G1tensor(19),G1tensor(97),G1tensor(25),G1tensor(118),G1tensor(31))
  call G_TensorShift(G1tensor(97),25)
  call Hotf_4pt_reduction_last(G2tensor(207),RedSet_4(31),mass4set(:,20),  & 
G1tensor(42),G1tensor(55),G1tensor(14),G1tensor(61),G1tensor(9))
  call G_TensorShift(G1tensor(55),16)
  call Hotf_4pt_reduction_last(G2tensor(203),RedSet_4(68),mass4set(:,20),  & 
G1tensor(67),G1tensor(89),G1tensor(91),G1tensor(56),G1tensor(103))
  call G_TensorShift(G1tensor(89),25)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(31),mass4set(:,19),  & 
G1tensor(80),G1tensor(8),G1tensor(75),G1tensor(20),G1tensor(597))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_4pt_reduction_last(G2tensor(211),RedSet_4(87),mass4set(:,20),  & 
G1tensor(32),G1tensor(113),G1tensor(44),G1tensor(224),G1tensor(74))
  call G_TensorShift(G1tensor(113),16)
  call Hotf_4pt_reduction_last(G2tensor(210),RedSet_4(28),mass4set(:,20),  & 
G1tensor(83),G1tensor(92),G1tensor(104),G1tensor(242),G1tensor(110))
  call G_TensorShift(G1tensor(92),26)
  call Hotf_4pt_reduction_last(G2tensor(212),RedSet_4(1),mass4set(:,20),  & 
G1tensor(585),G1tensor(17),G1tensor(60),G1tensor(66),G1tensor(23))
  call G_TensorShift(G1tensor(17),16)
  call Hotf_4pt_reduction_last(G2tensor(208),RedSet_4(109),mass4set(:,20),  & 
G1tensor(36),G1tensor(12),G1tensor(106),G1tensor(302),G1tensor(16))
  call G_TensorShift(G1tensor(12),26)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(1),mass4set(:,19),  & 
G1tensor(621),G1tensor(22),G1tensor(35),G1tensor(24),G1tensor(573))
  call G_TensorShift(G1tensor(22),16)
  call Hotf_4pt_reduction_last(G2tensor(220),RedSet_4(137),mass4set(:,21),  & 
G1tensor(29),G1tensor(33),G1tensor(82),G1tensor(102),G1tensor(40))
  call G_TensorShift(G1tensor(33),4)
  call Hotf_4pt_reduction_last(G2tensor(168),RedSet_4(213),mass4set(:,13),  & 
G1tensor(356),G1tensor(41),G1tensor(70),G1tensor(88),G1tensor(47))
  call G_TensorShift(G1tensor(41),12)
  call Hotf_4pt_reduction_last(G2tensor(215),RedSet_4(148),mass4set(:,21),  & 
G1tensor(374),G1tensor(51),G1tensor(555),G1tensor(58),G1tensor(59))
  call G_TensorShift(G1tensor(51),8)
  call Hotf_4pt_reduction_last(G2tensor(221),RedSet_4(145),mass4set(:,21),  & 
G1tensor(114),G1tensor(63),G1tensor(609),G1tensor(65),G1tensor(81))
  call G_TensorShift(G1tensor(63),4)
  call Hotf_4pt_reduction_last(G2tensor(174),RedSet_4(217),mass4set(:,13),  & 
G1tensor(101),G1tensor(567),G1tensor(90),G1tensor(78),G1tensor(87))
  call G_TensorShift(G1tensor(567),12)
  call Hotf_4pt_reduction_last(G2tensor(216),RedSet_4(141),mass4set(:,21),  & 
G1tensor(119),G1tensor(117),G1tensor(100),G1tensor(95),G1tensor(452))
  call G_TensorShift(G1tensor(117),8)
  call Hotf_4pt_reduction_last(G2tensor(176),RedSet_4(163),mass4set(:,22),  & 
G1tensor(99),G1tensor(561),G1tensor(111),G1tensor(112),G1tensor(135))
  call G_TensorShift(G1tensor(561),1)
  call Hotf_4pt_reduction_last(G2tensor(332),RedSet_4(156),mass4set(:,12),  & 
G1tensor(124),G1tensor(141),G1tensor(125),G1tensor(442),G1tensor(292))
  call G_TensorShift(G1tensor(141),9)
  call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(163),mass4set(:,21),  & 
G1tensor(178),G1tensor(136),G1tensor(130),G1tensor(298),G1tensor(142))
  call G_TensorShift(G1tensor(136),1)
  call Hotf_4pt_reduction_last(G2tensor(335),RedSet_4(156),mass4set(:,13),  & 
G1tensor(131),G1tensor(341),G1tensor(221),G1tensor(185),G1tensor(143))
  call G_TensorShift(G1tensor(341),9)
  call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(173),mass4set(:,22),  & 
G1tensor(137),G1tensor(144),G1tensor(159),G1tensor(148),G1tensor(165))
  call G_TensorShift(G1tensor(144),1)
  call Hotf_4pt_reduction_last(G2tensor(302),RedSet_4(162),mass4set(:,12),  & 
G1tensor(149),G1tensor(364),G1tensor(232),G1tensor(196),G1tensor(160))
  call G_TensorShift(G1tensor(364),5)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(173),mass4set(:,21),  & 
G1tensor(154),G1tensor(275),G1tensor(166),G1tensor(155),G1tensor(425))
  call G_TensorShift(G1tensor(275),1)
  call Hotf_4pt_reduction_last(G2tensor(305),RedSet_4(162),mass4set(:,13),  & 
G1tensor(281),G1tensor(203),G1tensor(167),G1tensor(161),G1tensor(183))
  call G_TensorShift(G1tensor(203),5)
  call Hotf_4pt_reduction_last(G2tensor(224),RedSet_4(151),mass4set(:,22),  & 
G1tensor(173),G1tensor(215),G1tensor(184),G1tensor(179),G1tensor(186))
  call G_TensorShift(G1tensor(215),2)
  call Hotf_4pt_reduction_last(G2tensor(350),RedSet_4(170),mass4set(:,12),  & 
G1tensor(201),G1tensor(191),G1tensor(238),G1tensor(202),G1tensor(197))
  call G_TensorShift(G1tensor(191),10)
  call Hotf_4pt_reduction_last(G2tensor(223),RedSet_4(151),mass4set(:,21),  & 
G1tensor(219),G1tensor(208),G1tensor(406),G1tensor(280),G1tensor(274))
  call G_TensorShift(G1tensor(208),2)
  call Hotf_4pt_reduction_last(G2tensor(353),RedSet_4(170),mass4set(:,13),  & 
G1tensor(220),G1tensor(214),G1tensor(231),G1tensor(226),G1tensor(237))
  call G_TensorShift(G1tensor(214),10)
  call Hotf_4pt_reduction_last(G2tensor(219),RedSet_4(157),mass4set(:,22),  & 
G1tensor(227),G1tensor(353),G1tensor(299),G1tensor(293),G1tensor(239))
  call G_TensorShift(G1tensor(353),2)
  call Hotf_4pt_reduction_last(G2tensor(314),RedSet_4(179),mass4set(:,12),  & 
G1tensor(233),G1tensor(255),G1tensor(244),G1tensor(261),G1tensor(245))
  call G_TensorShift(G1tensor(255),6)
  call Hotf_4pt_reduction_last(G2tensor(218),RedSet_4(157),mass4set(:,21),  & 
G1tensor(388),G1tensor(382),G1tensor(256),G1tensor(250),G1tensor(262))
  call G_TensorShift(G1tensor(382),2)
  call Hotf_4pt_reduction_last(G2tensor(317),RedSet_4(179),mass4set(:,13),  & 
G1tensor(251),G1tensor(323),G1tensor(317),G1tensor(263),G1tensor(257))
  call G_TensorShift(G1tensor(323),6)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(160),mass4set(:,20),  & 
G1tensor(399),G1tensor(273),G1tensor(267),G1tensor(279),G1tensor(268))
  call G_TensorShift(G1tensor(273),4)
  call Hotf_4pt_reduction_last(G2tensor(214),RedSet_4(154),mass4set(:,21),  & 
G1tensor(291),G1tensor(286),G1tensor(297),G1tensor(287),G1tensor(315))
  call G_TensorShift(G1tensor(286),8)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(163),mass4set(:,19),  & 
G1tensor(304),G1tensor(321),G1tensor(305),G1tensor(466),G1tensor(460))
  call G_TensorShift(G1tensor(321),1)
  call Hotf_4pt_reduction_last(G2tensor(163),RedSet_4(154),mass4set(:,22),  & 
G1tensor(316),G1tensor(310),G1tensor(322),G1tensor(311),G1tensor(339))
  call G_TensorShift(G1tensor(310),8)
  call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(154),mass4set(:,20),  & 
G1tensor(328),G1tensor(424),G1tensor(418),G1tensor(352),G1tensor(340))
  call G_TensorShift(G1tensor(424),8)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(173),mass4set(:,19),  & 
G1tensor(334),G1tensor(351),G1tensor(346),G1tensor(363),G1tensor(358))
  call G_TensorShift(G1tensor(351),1)
  call Hotf_4pt_reduction_last(G2tensor(166),RedSet_4(160),mass4set(:,22),  & 
G1tensor(369),G1tensor(359),G1tensor(449),G1tensor(443),G1tensor(407))
  call G_TensorShift(G1tensor(359),4)
  call Hotf_4pt_reduction_last(G2tensor(145),RedSet_4(177),mass4set(:,20),  & 
G1tensor(371),G1tensor(365),G1tensor(387),G1tensor(376),G1tensor(393))
  call G_TensorShift(G1tensor(365),4)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(218),mass4set(:,20),  & 
G1tensor(377),G1tensor(394),G1tensor(383),G1tensor(473),G1tensor(467))
  call G_TensorShift(G1tensor(394),4)
  call Hotf_4pt_reduction_last(G2tensor(222),RedSet_4(151),mass4set(:,20),  & 
G1tensor(395),G1tensor(389),G1tensor(405),G1tensor(400),G1tensor(429))
  call G_TensorShift(G1tensor(389),2)
  call Hotf_4pt_reduction_last(G2tensor(213),RedSet_4(168),mass4set(:,21),  & 
G1tensor(417),G1tensor(411),G1tensor(423),G1tensor(412),G1tensor(441))
  call G_TensorShift(G1tensor(411),8)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(151),mass4set(:,19),  & 
G1tensor(436),G1tensor(447),G1tensor(437),G1tensor(465),G1tensor(454))
  call G_TensorShift(G1tensor(447),2)
  call Hotf_4pt_reduction_last(G2tensor(172),RedSet_4(168),mass4set(:,22),  & 
G1tensor(471),G1tensor(455),G1tensor(472),G1tensor(461),G1tensor(482))
  call G_TensorShift(G1tensor(455),8)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(211),mass4set(:,20),  & 
G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(488),G1tensor(489))
  call G_TensorShift(G1tensor(484),8)
  call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(168),mass4set(:,20),  & 
G1tensor(490),G1tensor(491),G1tensor(495),G1tensor(496),G1tensor(497))
  call G_TensorShift(G1tensor(491),8)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(216),mass4set(:,20),  & 
G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(507),G1tensor(508))
  call G_TensorShift(G1tensor(502),8)
  call Hotf_4pt_reduction_last(G2tensor(217),RedSet_4(157),mass4set(:,20),  & 
G1tensor(509),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(519))
  call G_TensorShift(G1tensor(513),2)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(157),mass4set(:,19),  & 
G1tensor(526),G1tensor(520),G1tensor(521),G1tensor(525),G1tensor(527))
  call G_TensorShift(G1tensor(520),2)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(177),mass4set(:,22),  & 
G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(537),G1tensor(544))
  call G_TensorShift(G1tensor(532),4)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(214),mass4set(:,20),  & 
G1tensor(538),G1tensor(539),G1tensor(543),G1tensor(545),G1tensor(549))
  call G_TensorShift(G1tensor(539),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(6),mass4set(:,20),  & 
G1tensor(550),G1tensor(551),G1tensor(568),G1tensor(556),G1tensor(587))
  call G_TensorShift(G1tensor(551),16)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(10),mass4set(:,20),  & 
G1tensor(557),G1tensor(574),G1tensor(562),G1tensor(599),G1tensor(563))
  call G_TensorShift(G1tensor(574),16)
  call Hotf_4pt_reduction_last(G2tensor(187),RedSet_4(13),mass4set(:,20),  & 
G1tensor(611),G1tensor(569),G1tensor(623),G1tensor(575),G1tensor(579))
  call G_TensorShift(G1tensor(569),21)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(21),mass4set(:,20),  & 
G1tensor(580),G1tensor(581),G1tensor(586),G1tensor(591),G1tensor(592))
  call G_TensorShift(G1tensor(581),16)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(25),mass4set(:,20),  & 
G1tensor(593),G1tensor(598),G1tensor(603),G1tensor(604),G1tensor(605))
  call G_TensorShift(G1tensor(598),16)
  call Hotf_4pt_reduction_last(G2tensor(200),RedSet_4(38),mass4set(:,20),  & 
G1tensor(610),G1tensor(615),G1tensor(616),G1tensor(617),G1tensor(622))
  call G_TensorShift(G1tensor(615),22)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(52),mass4set(:,10),  & 
G1tensor(34),G1tensor(57),G1tensor(625),G1tensor(626),G1tensor(627))
  call G_TensorShift(G1tensor(57),16)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(55),mass4set(:,20),  & 
G1tensor(628),G1tensor(629),G1tensor(630),G1tensor(631),G1tensor(632))
  call G_TensorShift(G1tensor(629),16)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(61),mass4set(:,10),  & 
G1tensor(633),G1tensor(634),G1tensor(635),G1tensor(636),G1tensor(637))
  call G_TensorShift(G1tensor(634),16)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(65),mass4set(:,20),  & 
G1tensor(638),G1tensor(639),G1tensor(640),G1tensor(641),G1tensor(642))
  call G_TensorShift(G1tensor(639),16)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(61),mass4set(:,8),  & 
G1tensor(643),G1tensor(644),G1tensor(645),G1tensor(646),G1tensor(647))
  call G_TensorShift(G1tensor(644),16)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(62),mass4set(:,9),  & 
G1tensor(648),G1tensor(649),G1tensor(650),G1tensor(651),G1tensor(652))
  call G_TensorShift(G1tensor(649),16)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(21),mass4set(:,19),  & 
G1tensor(653),G1tensor(654),G1tensor(655),G1tensor(656),G1tensor(657))
  call G_TensorShift(G1tensor(654),16)
  call Hotf_4pt_reduction_last(G2tensor(257),RedSet_4(45),mass4set(:,6),  & 
G1tensor(658),G1tensor(659),G1tensor(660),G1tensor(661),G1tensor(662))
  call G_TensorShift(G1tensor(659),16)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(65),mass4set(:,19),  & 
G1tensor(663),G1tensor(664),G1tensor(665),G1tensor(666),G1tensor(667))
  call G_TensorShift(G1tensor(664),16)
  call Hotf_4pt_reduction_last(G2tensor(190),RedSet_4(71),mass4set(:,20),  & 
G1tensor(668),G1tensor(669),G1tensor(670),G1tensor(671),G1tensor(672))
  call G_TensorShift(G1tensor(669),16)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(72),mass4set(:,10),  & 
G1tensor(673),G1tensor(674),G1tensor(675),G1tensor(676),G1tensor(677))
  call G_TensorShift(G1tensor(674),16)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(79),mass4set(:,10),  & 
G1tensor(678),G1tensor(679),G1tensor(680),G1tensor(681),G1tensor(682))
  call G_TensorShift(G1tensor(679),16)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(79),mass4set(:,8),  & 
G1tensor(683),G1tensor(684),G1tensor(685),G1tensor(686),G1tensor(687))
  call G_TensorShift(G1tensor(684),16)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(80),mass4set(:,9),  & 
G1tensor(688),G1tensor(689),G1tensor(690),G1tensor(691),G1tensor(692))
  call G_TensorShift(G1tensor(689),16)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(6),mass4set(:,19),  & 
G1tensor(693),G1tensor(694),G1tensor(695),G1tensor(696),G1tensor(697))
  call G_TensorShift(G1tensor(694),16)
  call Hotf_4pt_reduction_last(G2tensor(260),RedSet_4(7),mass4set(:,6),  & 
G1tensor(698),G1tensor(699),G1tensor(700),G1tensor(701),G1tensor(702))
  call G_TensorShift(G1tensor(699),16)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(88),mass4set(:,10),  & 
G1tensor(703),G1tensor(704),G1tensor(705),G1tensor(706),G1tensor(707))
  call G_TensorShift(G1tensor(704),16)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(90),mass4set(:,20),  & 
G1tensor(708),G1tensor(709),G1tensor(710),G1tensor(711),G1tensor(712))
  call G_TensorShift(G1tensor(709),16)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(102),mass4set(:,10),  & 
G1tensor(713),G1tensor(714),G1tensor(715),G1tensor(716),G1tensor(717))
  call G_TensorShift(G1tensor(714),16)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(106),mass4set(:,20),  & 
G1tensor(718),G1tensor(719),G1tensor(720),G1tensor(721),G1tensor(722))
  call G_TensorShift(G1tensor(719),16)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(102),mass4set(:,8),  & 
G1tensor(723),G1tensor(724),G1tensor(725),G1tensor(726),G1tensor(727))
  call G_TensorShift(G1tensor(724),16)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(103),mass4set(:,9),  & 
G1tensor(728),G1tensor(729),G1tensor(730),G1tensor(731),G1tensor(732))
  call G_TensorShift(G1tensor(729),16)
  call Hotf_4pt_reduction_last(G2tensor(263),RedSet_4(22),mass4set(:,6),  & 
G1tensor(733),G1tensor(734),G1tensor(735),G1tensor(736),G1tensor(737))
  call G_TensorShift(G1tensor(734),16)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(106),mass4set(:,19),  & 
G1tensor(738),G1tensor(739),G1tensor(740),G1tensor(741),G1tensor(742))
  call G_TensorShift(G1tensor(739),16)
  call Hotf_4pt_reduction_last(G2tensor(201),RedSet_4(117),mass4set(:,20),  & 
G1tensor(743),G1tensor(744),G1tensor(745),G1tensor(746),G1tensor(747))
  call G_TensorShift(G1tensor(744),16)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(118),mass4set(:,10),  & 
G1tensor(748),G1tensor(749),G1tensor(750),G1tensor(751),G1tensor(752))
  call G_TensorShift(G1tensor(749),16)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(127),mass4set(:,10),  & 
G1tensor(753),G1tensor(754),G1tensor(755),G1tensor(756),G1tensor(757))
  call G_TensorShift(G1tensor(754),16)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(127),mass4set(:,8),  & 
G1tensor(758),G1tensor(759),G1tensor(760),G1tensor(761),G1tensor(762))
  call G_TensorShift(G1tensor(759),16)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(128),mass4set(:,9),  & 
G1tensor(763),G1tensor(764),G1tensor(765),G1tensor(766),G1tensor(767))
  call G_TensorShift(G1tensor(764),16)
  call Hotf_4pt_reduction_last(G2tensor(266),RedSet_4(35),mass4set(:,6),  & 
G1tensor(768),G1tensor(769),G1tensor(770),G1tensor(771),G1tensor(772))
  call G_TensorShift(G1tensor(769),16)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(219),mass4set(:,10),  & 
G1tensor(773),G1tensor(774),G1tensor(775),G1tensor(776),G1tensor(777))
  call G_TensorShift(G1tensor(774),2)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(181),mass4set(:,21),  & 
G1tensor(778),G1tensor(779),G1tensor(780),G1tensor(781),G1tensor(782))
  call G_TensorShift(G1tensor(779),8)
  call Hotf_4pt_reduction_last(G2tensor(154),RedSet_4(182),mass4set(:,21),  & 
G1tensor(783),G1tensor(784),G1tensor(785),G1tensor(786),G1tensor(787))
  call G_TensorShift(G1tensor(784),8)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(183),mass4set(:,3),  & 
G1tensor(788),G1tensor(789),G1tensor(790),G1tensor(791),G1tensor(792))
  call G_TensorShift(G1tensor(789),8)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(220),mass4set(:,10),  & 
G1tensor(793),G1tensor(794),G1tensor(795),G1tensor(796),G1tensor(797))
  call G_TensorShift(G1tensor(794),1)
  call Hotf_4pt_reduction_last(G2tensor(157),RedSet_4(186),mass4set(:,21),  & 
G1tensor(798),G1tensor(799),G1tensor(800),G1tensor(801),G1tensor(802))
  call G_TensorShift(G1tensor(799),8)
  call Hotf_4pt_reduction_last(G2tensor(160),RedSet_4(187),mass4set(:,21),  & 
G1tensor(803),G1tensor(804),G1tensor(805),G1tensor(806),G1tensor(807))
  call G_TensorShift(G1tensor(804),8)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(188),mass4set(:,3),  & 
G1tensor(808),G1tensor(809),G1tensor(810),G1tensor(811),G1tensor(812))
  call G_TensorShift(G1tensor(809),8)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(191),mass4set(:,13),  & 
G1tensor(813),G1tensor(814),G1tensor(815),G1tensor(816),G1tensor(817))
  call G_TensorShift(G1tensor(814),5)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(192),mass4set(:,23),  & 
G1tensor(818),G1tensor(819),G1tensor(820),G1tensor(821),G1tensor(822))
  call G_TensorShift(G1tensor(819),5)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(193),mass4set(:,17),  & 
G1tensor(823),G1tensor(824),G1tensor(825),G1tensor(826),G1tensor(827))
  call G_TensorShift(G1tensor(824),5)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(191),mass4set(:,12),  & 
G1tensor(828),G1tensor(829),G1tensor(830),G1tensor(831),G1tensor(832))
  call G_TensorShift(G1tensor(829),5)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(192),mass4set(:,7),  & 
G1tensor(833),G1tensor(834),G1tensor(835),G1tensor(836),G1tensor(837))
  call G_TensorShift(G1tensor(834),5)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(193),mass4set(:,18),  & 
G1tensor(838),G1tensor(839),G1tensor(840),G1tensor(841),G1tensor(842))
  call G_TensorShift(G1tensor(839),5)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(195),mass4set(:,13),  & 
G1tensor(843),G1tensor(844),G1tensor(845),G1tensor(846),G1tensor(847))
  call G_TensorShift(G1tensor(844),6)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(196),mass4set(:,23),  & 
G1tensor(848),G1tensor(849),G1tensor(850),G1tensor(851),G1tensor(852))
  call G_TensorShift(G1tensor(849),6)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(197),mass4set(:,17),  & 
G1tensor(853),G1tensor(854),G1tensor(855),G1tensor(856),G1tensor(857))
  call G_TensorShift(G1tensor(854),6)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(195),mass4set(:,12),  & 
G1tensor(858),G1tensor(859),G1tensor(860),G1tensor(861),G1tensor(862))
  call G_TensorShift(G1tensor(859),6)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(196),mass4set(:,7),  & 
G1tensor(863),G1tensor(864),G1tensor(865),G1tensor(866),G1tensor(867))
  call G_TensorShift(G1tensor(864),6)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(197),mass4set(:,18),  & 
G1tensor(868),G1tensor(869),G1tensor(870),G1tensor(871),G1tensor(872))
  call G_TensorShift(G1tensor(869),6)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(199),mass4set(:,13),  & 
G1tensor(873),G1tensor(874),G1tensor(875),G1tensor(876),G1tensor(877))
  call G_TensorShift(G1tensor(874),9)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(189),mass4set(:,23),  & 
G1tensor(878),G1tensor(879),G1tensor(880),G1tensor(881),G1tensor(882))
  call G_TensorShift(G1tensor(879),9)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(200),mass4set(:,17),  & 
G1tensor(883),G1tensor(884),G1tensor(885),G1tensor(886),G1tensor(887))
  call G_TensorShift(G1tensor(884),9)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(202),mass4set(:,13),  & 
G1tensor(888),G1tensor(889),G1tensor(890),G1tensor(891),G1tensor(892))
  call G_TensorShift(G1tensor(889),9)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(203),mass4set(:,17),  & 
G1tensor(893),G1tensor(894),G1tensor(895),G1tensor(896),G1tensor(897))
  call G_TensorShift(G1tensor(894),9)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(202),mass4set(:,12),  & 
G1tensor(898),G1tensor(899),G1tensor(900),G1tensor(901),G1tensor(902))
  call G_TensorShift(G1tensor(899),9)
  call Hotf_4pt_reduction_last(G2tensor(269),RedSet_4(189),mass4set(:,7),  & 
G1tensor(903),G1tensor(904),G1tensor(905),G1tensor(906),G1tensor(907))
  call G_TensorShift(G1tensor(904),9)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(203),mass4set(:,18),  & 
G1tensor(908),G1tensor(909),G1tensor(910),G1tensor(911),G1tensor(912))
  call G_TensorShift(G1tensor(909),9)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(205),mass4set(:,13),  & 
G1tensor(913),G1tensor(914),G1tensor(915),G1tensor(916),G1tensor(917))
  call G_TensorShift(G1tensor(914),10)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(184),mass4set(:,23),  & 
G1tensor(918),G1tensor(919),G1tensor(920),G1tensor(921),G1tensor(922))
  call G_TensorShift(G1tensor(919),10)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(206),mass4set(:,17),  & 
G1tensor(923),G1tensor(924),G1tensor(925),G1tensor(926),G1tensor(927))
  call G_TensorShift(G1tensor(924),10)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(208),mass4set(:,13),  & 
G1tensor(928),G1tensor(929),G1tensor(930),G1tensor(931),G1tensor(932))
  call G_TensorShift(G1tensor(929),10)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(209),mass4set(:,17),  & 
G1tensor(933),G1tensor(934),G1tensor(935),G1tensor(936),G1tensor(937))
  call G_TensorShift(G1tensor(934),10)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(208),mass4set(:,12),  & 
G1tensor(938),G1tensor(939),G1tensor(940),G1tensor(941),G1tensor(942))
  call G_TensorShift(G1tensor(939),10)
  call Hotf_4pt_reduction_last(G2tensor(272),RedSet_4(184),mass4set(:,7),  & 
G1tensor(943),G1tensor(944),G1tensor(945),G1tensor(946),G1tensor(947))
  call G_TensorShift(G1tensor(944),10)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(209),mass4set(:,18),  & 
G1tensor(948),G1tensor(949),G1tensor(950),G1tensor(951),G1tensor(952))
  call G_TensorShift(G1tensor(949),10)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(212),mass4set(:,10),  & 
G1tensor(953),G1tensor(954),G1tensor(955),G1tensor(956),G1tensor(957))
  call G_TensorShift(G1tensor(954),8)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(155),mass4set(:,24),  & 
G1tensor(958),G1tensor(959),G1tensor(960),G1tensor(961),G1tensor(962))
  call G_TensorShift(G1tensor(959),8)
  call Hotf_4pt_reduction_last(G2tensor(118),RedSet_4(215),mass4set(:,10),  & 
G1tensor(963),G1tensor(964),G1tensor(965),G1tensor(966),G1tensor(967))
  call G_TensorShift(G1tensor(964),4)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(161),mass4set(:,24),  & 
G1tensor(968),G1tensor(969),G1tensor(970),G1tensor(971),G1tensor(972))
  call G_TensorShift(G1tensor(969),4)
  call Hotf_4pt_reduction_last(G2tensor(121),RedSet_4(169),mass4set(:,24),  & 
G1tensor(973),G1tensor(974),G1tensor(975),G1tensor(976),G1tensor(977))
  call G_TensorShift(G1tensor(974),8)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(178),mass4set(:,24),  & 
G1tensor(978),G1tensor(979),G1tensor(980),G1tensor(981),G1tensor(982))
  call G_TensorShift(G1tensor(979),4)
  call Hotf_4pt_reduction_last(G2tensor(124),RedSet_4(154),mass4set(:,19),  & 
G1tensor(983),G1tensor(984),G1tensor(985),G1tensor(986),G1tensor(987))
  call G_TensorShift(G1tensor(984),8)
  call Hotf_4pt_reduction_last(G2tensor(275),RedSet_4(149),mass4set(:,8),  & 
G1tensor(988),G1tensor(989),G1tensor(990),G1tensor(991),G1tensor(992))
  call G_TensorShift(G1tensor(989),8)
  call Hotf_4pt_reduction_last(G2tensor(278),RedSet_4(155),mass4set(:,9),  & 
G1tensor(993),G1tensor(994),G1tensor(995),G1tensor(996),G1tensor(997))
  call G_TensorShift(G1tensor(994),8)
  call Hotf_4pt_reduction_last(G2tensor(281),RedSet_4(149),mass4set(:,10),  & 
G1tensor(998),G1tensor(999),G1tensor(1000),G1tensor(1001),G1tensor(1002))
  call G_TensorShift(G1tensor(999),8)
  call Hotf_4pt_reduction_last(G2tensor(130),RedSet_4(160),mass4set(:,19),  & 
G1tensor(1003),G1tensor(1004),G1tensor(1005),G1tensor(1006),G1tensor(1007))
  call G_TensorShift(G1tensor(1004),4)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(138),mass4set(:,8),  & 
G1tensor(1008),G1tensor(1009),G1tensor(1010),G1tensor(1011),G1tensor(1012))
  call G_TensorShift(G1tensor(1009),4)
  call Hotf_4pt_reduction_last(G2tensor(284),RedSet_4(161),mass4set(:,9),  & 
G1tensor(1013),G1tensor(1014),G1tensor(1015),G1tensor(1016),G1tensor(1017))
  call G_TensorShift(G1tensor(1014),4)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(138),mass4set(:,10),  & 
G1tensor(1018),G1tensor(1019),G1tensor(1020),G1tensor(1021),G1tensor(1022))
  call G_TensorShift(G1tensor(1019),4)
  call Hotf_4pt_reduction_last(G2tensor(133),RedSet_4(168),mass4set(:,19),  & 
G1tensor(1023),G1tensor(1024),G1tensor(1025),G1tensor(1026),G1tensor(1027))
  call G_TensorShift(G1tensor(1024),8)
  call Hotf_4pt_reduction_last(G2tensor(287),RedSet_4(142),mass4set(:,8),  & 
G1tensor(1028),G1tensor(1029),G1tensor(1030),G1tensor(1031),G1tensor(1032))
  call G_TensorShift(G1tensor(1029),8)
  call Hotf_4pt_reduction_last(G2tensor(290),RedSet_4(169),mass4set(:,9),  & 
G1tensor(1033),G1tensor(1034),G1tensor(1035),G1tensor(1036),G1tensor(1037))
  call G_TensorShift(G1tensor(1034),8)
  call Hotf_4pt_reduction_last(G2tensor(293),RedSet_4(142),mass4set(:,10),  & 
G1tensor(1038),G1tensor(1039),G1tensor(1040),G1tensor(1041),G1tensor(1042))
  call G_TensorShift(G1tensor(1039),8)
  call Hotf_4pt_reduction_last(G2tensor(139),RedSet_4(177),mass4set(:,19),  & 
G1tensor(1043),G1tensor(1044),G1tensor(1045),G1tensor(1046),G1tensor(1047))
  call G_TensorShift(G1tensor(1044),4)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(146),mass4set(:,8),  & 
G1tensor(1048),G1tensor(1049),G1tensor(1050),G1tensor(1051),G1tensor(1052))
  call G_TensorShift(G1tensor(1049),4)
  call Hotf_4pt_reduction_last(G2tensor(296),RedSet_4(178),mass4set(:,9),  & 
G1tensor(1053),G1tensor(1054),G1tensor(1055),G1tensor(1056),G1tensor(1057))
  call G_TensorShift(G1tensor(1054),4)
  call Hotf_4pt_reduction_last(G2tensor(148),RedSet_4(146),mass4set(:,10),  & 
G1tensor(1058),G1tensor(1059),G1tensor(1060),G1tensor(1061),G1tensor(1062))
  call G_TensorShift(G1tensor(1059),4)
  call Hotf_4pt_reduction_last(G2tensor(329),RedSet_4(150),mass4set(:,14),  & 
G1tensor(1063),G1tensor(1064),G1tensor(1065),G1tensor(1066),G1tensor(1067))
  call G_TensorShift(G1tensor(1064),9)
  call Hotf_4pt_reduction_last(G2tensor(347),RedSet_4(144),mass4set(:,14),  & 
G1tensor(1068),G1tensor(1069),G1tensor(1070),G1tensor(1071),G1tensor(1072))
  call G_TensorShift(G1tensor(1069),10)
  call Hotf_4pt_reduction_last(G2tensor(229),RedSet_4(7),mass4set(:,2),  & 
G1tensor(1073),G1tensor(1074),G1tensor(1075),G1tensor(1076),G1tensor(1077))
  call G_TensorShift(G1tensor(1074),16)
  call Hotf_4pt_reduction_last(G2tensor(231),RedSet_4(7),mass4set(:,3),  & 
G1tensor(1078),G1tensor(1079),G1tensor(1080),G1tensor(1081),G1tensor(1082))
  call G_TensorShift(G1tensor(1079),16)
  call Hotf_4pt_reduction_last(G2tensor(233),RedSet_4(7),mass4set(:,4),  & 
G1tensor(1083),G1tensor(1084),G1tensor(1085),G1tensor(1086),G1tensor(1087))
  call G_TensorShift(G1tensor(1084),16)
  call Hotf_4pt_reduction_last(G2tensor(235),RedSet_4(22),mass4set(:,2),  & 
G1tensor(1088),G1tensor(1089),G1tensor(1090),G1tensor(1091),G1tensor(1092))
  call G_TensorShift(G1tensor(1089),16)
  call Hotf_4pt_reduction_last(G2tensor(237),RedSet_4(22),mass4set(:,3),  & 
G1tensor(1093),G1tensor(1094),G1tensor(1095),G1tensor(1096),G1tensor(1097))
  call G_TensorShift(G1tensor(1094),16)
  call Hotf_4pt_reduction_last(G2tensor(239),RedSet_4(22),mass4set(:,4),  & 
G1tensor(1098),G1tensor(1099),G1tensor(1100),G1tensor(1101),G1tensor(1102))
  call G_TensorShift(G1tensor(1099),16)
  call Hotf_4pt_reduction_last(G2tensor(242),RedSet_4(45),mass4set(:,2),  & 
G1tensor(1103),G1tensor(1104),G1tensor(1105),G1tensor(1106),G1tensor(1107))
  call G_TensorShift(G1tensor(1104),16)
  call Hotf_4pt_reduction_last(G2tensor(244),RedSet_4(45),mass4set(:,3),  & 
G1tensor(1108),G1tensor(1109),G1tensor(1110),G1tensor(1111),G1tensor(1112))
  call G_TensorShift(G1tensor(1109),16)
  call Hotf_4pt_reduction_last(G2tensor(246),RedSet_4(45),mass4set(:,4),  & 
G1tensor(1113),G1tensor(1114),G1tensor(1115),G1tensor(1116),G1tensor(1117))
  call G_TensorShift(G1tensor(1114),16)
  call Hotf_4pt_reduction_last(G2tensor(248),RedSet_4(35),mass4set(:,2),  & 
G1tensor(1118),G1tensor(1119),G1tensor(1120),G1tensor(1121),G1tensor(1122))
  call G_TensorShift(G1tensor(1119),16)
  call Hotf_4pt_reduction_last(G2tensor(250),RedSet_4(35),mass4set(:,3),  & 
G1tensor(1123),G1tensor(1124),G1tensor(1125),G1tensor(1126),G1tensor(1127))
  call G_TensorShift(G1tensor(1124),16)
  call Hotf_4pt_reduction_last(G2tensor(252),RedSet_4(35),mass4set(:,4),  & 
G1tensor(1128),G1tensor(1129),G1tensor(1130),G1tensor(1131),G1tensor(1132))
  call G_TensorShift(G1tensor(1129),16)
  call Hotf_4pt_reduction_last(G2tensor(299),RedSet_4(184),mass4set(:,11),  & 
G1tensor(1133),G1tensor(1134),G1tensor(1135),G1tensor(1136),G1tensor(1137))
  call G_TensorShift(G1tensor(1134),10)
  call Hotf_4pt_reduction_last(G2tensor(311),RedSet_4(189),mass4set(:,11),  & 
G1tensor(1138),G1tensor(1139),G1tensor(1140),G1tensor(1141),G1tensor(1142))
  call G_TensorShift(G1tensor(1139),9)
  call Hotf_4pt_reduction_last(G2tensor(323),RedSet_4(150),mass4set(:,12),  & 
G1tensor(1143),G1tensor(1144),G1tensor(1145),G1tensor(1146),G1tensor(1147))
  call G_TensorShift(G1tensor(1144),9)
  call Hotf_4pt_reduction_last(G2tensor(326),RedSet_4(150),mass4set(:,13),  & 
G1tensor(1148),G1tensor(1149),G1tensor(1150),G1tensor(1151),G1tensor(1152))
  call G_TensorShift(G1tensor(1149),9)
  call Hotf_4pt_reduction_last(G2tensor(341),RedSet_4(144),mass4set(:,12),  & 
G1tensor(1153),G1tensor(1154),G1tensor(1155),G1tensor(1156),G1tensor(1157))
  call G_TensorShift(G1tensor(1154),10)
  call Hotf_4pt_reduction_last(G2tensor(344),RedSet_4(144),mass4set(:,13),  & 
G1tensor(1158),G1tensor(1159),G1tensor(1160),G1tensor(1161),G1tensor(1162))
  call G_TensorShift(G1tensor(1159),10)
  call Hotf_4pt_reduction_last(G1tensor(94),RedSet_4(184),mass4set(:,15),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(139),RedSet_4(189),mass4set(:,15),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(169),RedSet_4(156),mass4set(:,14),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(199),RedSet_4(162),mass4set(:,14),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(229),RedSet_4(170),mass4set(:,14),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(259),RedSet_4(179),mass4set(:,14),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(289),RedSet_4(153),mass4set(:,16),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(319),RedSet_4(58),mass4set(:,17),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(349),RedSet_4(155),mass4set(:,16),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(379),RedSet_4(66),mass4set(:,17),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(409),RedSet_4(149),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(439),RedSet_4(46),mass4set(:,7),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(469),RedSet_4(155),mass4set(:,5),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(499),RedSet_4(66),mass4set(:,18),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(529),RedSet_4(68),mass4set(:,19),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(559),RedSet_4(159),mass4set(:,16),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(589),RedSet_4(77),mass4set(:,17),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(619),RedSet_4(161),mass4set(:,16),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(82),mass4set(:,17),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(392),RedSet_4(138),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(218),RedSet_4(8),mass4set(:,7),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(234),RedSet_4(161),mass4set(:,5),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(82),mass4set(:,18),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(84),mass4set(:,19),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(308),RedSet_4(165),mass4set(:,16),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(318),RedSet_4(93),mass4set(:,17),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(342),RedSet_4(169),mass4set(:,16),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(53),RedSet_4(107),mass4set(:,17),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(552),RedSet_4(142),mass4set(:,1),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(440),RedSet_4(23),mass4set(:,7),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(462),RedSet_4(169),mass4set(:,5),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(474),RedSet_4(107),mass4set(:,18),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(498),RedSet_4(109),mass4set(:,19),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(506),RedSet_4(175),mass4set(:,16),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(450),RedSet_4(122),mass4set(:,17),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(477),RedSet_4(178),mass4set(:,16),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(524),RedSet_4(130),mass4set(:,17),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(240),RedSet_4(146),mass4set(:,1),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(345),RedSet_4(36),mass4set(:,7),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(542),RedSet_4(178),mass4set(:,5),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(372),RedSet_4(130),mass4set(:,18),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(122),RedSet_4(132),mass4set(:,19),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(188),RedSet_4(16),mass4set(:,20),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(576),RedSet_4(84),mass4set(:,20),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(578),RedSet_4(16),mass4set(:,19),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(588),RedSet_4(41),mass4set(:,20),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(132),mass4set(:,20),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(41),mass4set(:,19),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(620),RedSet_4(51),mass4set(:,20),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(19),RedSet_4(48),mass4set(:,20),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(42),RedSet_4(31),mass4set(:,20),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(67),RedSet_4(68),mass4set(:,20),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(80),RedSet_4(31),mass4set(:,19),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(32),RedSet_4(87),mass4set(:,20),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(83),RedSet_4(28),mass4set(:,20),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(585),RedSet_4(1),mass4set(:,20),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(109),mass4set(:,20),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(621),RedSet_4(1),mass4set(:,19),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(137),mass4set(:,21),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(213),mass4set(:,13),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(374),RedSet_4(148),mass4set(:,21),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(114),RedSet_4(145),mass4set(:,21),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(217),mass4set(:,13),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(119),RedSet_4(141),mass4set(:,21),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(99),RedSet_4(163),mass4set(:,22),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(124),RedSet_4(156),mass4set(:,12),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(178),RedSet_4(163),mass4set(:,21),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(156),mass4set(:,13),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(137),RedSet_4(173),mass4set(:,22),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(149),RedSet_4(162),mass4set(:,12),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(154),RedSet_4(173),mass4set(:,21),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(162),mass4set(:,13),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(173),RedSet_4(151),mass4set(:,22),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(170),mass4set(:,12),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(219),RedSet_4(151),mass4set(:,21),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(220),RedSet_4(170),mass4set(:,13),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(227),RedSet_4(157),mass4set(:,22),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(233),RedSet_4(179),mass4set(:,12),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(388),RedSet_4(157),mass4set(:,21),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(179),mass4set(:,13),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(7),RedSet_4(221),mass4set(:,20),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(128),RedSet_4(138),mass4set(:,25),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(134),RedSet_4(139),mass4set(:,16),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(140),RedSet_4(140),mass4set(:,26),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(43),RedSet_4(222),mass4set(:,20),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(152),RedSet_4(142),mass4set(:,25),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(158),RedSet_4(143),mass4set(:,16),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(164),RedSet_4(144),mass4set(:,26),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(79),RedSet_4(223),mass4set(:,20),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(146),mass4set(:,25),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(182),RedSet_4(147),mass4set(:,26),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(115),RedSet_4(224),mass4set(:,20),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(194),RedSet_4(149),mass4set(:,25),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(200),RedSet_4(150),mass4set(:,26),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(399),RedSet_4(160),mass4set(:,20),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(212),RedSet_4(152),mass4set(:,25),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(68),RedSet_4(163),mass4set(:,20),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(291),RedSet_4(154),mass4set(:,21),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(156),mass4set(:,26),  & 
G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495))
  call Hotf_4pt_reduction_last(G1tensor(304),RedSet_4(163),mass4set(:,19),  & 
G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500))
  call Hotf_4pt_reduction_last(G1tensor(316),RedSet_4(154),mass4set(:,22),  & 
G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505))
  call Hotf_4pt_reduction_last(G1tensor(328),RedSet_4(154),mass4set(:,20),  & 
G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510))
  call Hotf_4pt_reduction_last(G1tensor(272),RedSet_4(158),mass4set(:,25),  & 
G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(173),mass4set(:,20),  & 
G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520))
  call Hotf_4pt_reduction_last(G1tensor(284),RedSet_4(160),mass4set(:,21),  & 
G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(162),mass4set(:,26),  & 
G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530))
  call Hotf_4pt_reduction_last(G1tensor(334),RedSet_4(173),mass4set(:,19),  & 
G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),G0tensor(535))
  call Hotf_4pt_reduction_last(G1tensor(369),RedSet_4(160),mass4set(:,22),  & 
G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),G0tensor(540))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(177),mass4set(:,20),  & 
G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544),G0tensor(545))
  call Hotf_4pt_reduction_last(G1tensor(332),RedSet_4(164),mass4set(:,25),  & 
G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549),G0tensor(550))
  call Hotf_4pt_reduction_last(G1tensor(377),RedSet_4(218),mass4set(:,20),  & 
G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554),G0tensor(555))
  call Hotf_4pt_reduction_last(G1tensor(344),RedSet_4(166),mass4set(:,21),  & 
G0tensor(556),G0tensor(557),G0tensor(558),G0tensor(559),G0tensor(560))
  call Hotf_4pt_reduction_last(G1tensor(350),RedSet_4(167),mass4set(:,16),  & 
G0tensor(561),G0tensor(562),G0tensor(563),G0tensor(564),G0tensor(565))
  call Hotf_4pt_reduction_last(G1tensor(395),RedSet_4(151),mass4set(:,20),  & 
G0tensor(566),G0tensor(567),G0tensor(568),G0tensor(569),G0tensor(570))
  call Hotf_4pt_reduction_last(G1tensor(417),RedSet_4(168),mass4set(:,21),  & 
G0tensor(571),G0tensor(572),G0tensor(573),G0tensor(574),G0tensor(575))
  call Hotf_4pt_reduction_last(G1tensor(368),RedSet_4(170),mass4set(:,26),  & 
G0tensor(576),G0tensor(577),G0tensor(578),G0tensor(579),G0tensor(580))
  call Hotf_4pt_reduction_last(G1tensor(436),RedSet_4(151),mass4set(:,19),  & 
G0tensor(581),G0tensor(582),G0tensor(583),G0tensor(584),G0tensor(585))
  call Hotf_4pt_reduction_last(G1tensor(471),RedSet_4(168),mass4set(:,22),  & 
G0tensor(586),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590))
  call Hotf_4pt_reduction_last(G1tensor(483),RedSet_4(211),mass4set(:,20),  & 
G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594),G0tensor(595))
  call Hotf_4pt_reduction_last(G1tensor(398),RedSet_4(171),mass4set(:,21),  & 
G0tensor(596),G0tensor(597),G0tensor(598),G0tensor(599),G0tensor(600))
  call Hotf_4pt_reduction_last(G1tensor(404),RedSet_4(172),mass4set(:,16),  & 
G0tensor(601),G0tensor(602),G0tensor(603),G0tensor(604),G0tensor(605))
  call Hotf_4pt_reduction_last(G1tensor(490),RedSet_4(168),mass4set(:,20),  & 
G0tensor(606),G0tensor(607),G0tensor(608),G0tensor(609),G0tensor(610))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(174),mass4set(:,25),  & 
G0tensor(611),G0tensor(612),G0tensor(613),G0tensor(614),G0tensor(615))
  call Hotf_4pt_reduction_last(G1tensor(501),RedSet_4(216),mass4set(:,20),  & 
G0tensor(616),G0tensor(617),G0tensor(618),G0tensor(619),G0tensor(620))
  call Hotf_4pt_reduction_last(G1tensor(428),RedSet_4(176),mass4set(:,21),  & 
G0tensor(621),G0tensor(622),G0tensor(623),G0tensor(624),G0tensor(625))
  call Hotf_4pt_reduction_last(G1tensor(509),RedSet_4(157),mass4set(:,20),  & 
G0tensor(626),G0tensor(627),G0tensor(628),G0tensor(629),G0tensor(630))
  call Hotf_4pt_reduction_last(G1tensor(434),RedSet_4(177),mass4set(:,21),  & 
G0tensor(631),G0tensor(632),G0tensor(633),G0tensor(634),G0tensor(635))
  call Hotf_4pt_reduction_last(G1tensor(446),RedSet_4(179),mass4set(:,26),  & 
G0tensor(636),G0tensor(637),G0tensor(638),G0tensor(639),G0tensor(640))
  call Hotf_4pt_reduction_last(G1tensor(526),RedSet_4(157),mass4set(:,19),  & 
G0tensor(641),G0tensor(642),G0tensor(643),G0tensor(644),G0tensor(645))
  call Hotf_4pt_reduction_last(G1tensor(531),RedSet_4(177),mass4set(:,22),  & 
G0tensor(646),G0tensor(647),G0tensor(648),G0tensor(649),G0tensor(650))
  call Hotf_4pt_reduction_last(G1tensor(538),RedSet_4(214),mass4set(:,20),  & 
G0tensor(651),G0tensor(652),G0tensor(653),G0tensor(654),G0tensor(655))
  call Hotf_4pt_reduction_last(G1tensor(476),RedSet_4(180),mass4set(:,21),  & 
G0tensor(656),G0tensor(657),G0tensor(658),G0tensor(659),G0tensor(660))
  call Hotf_4pt_reduction_last(G1tensor(172),RedSet_4(2),mass4set(:,10),  & 
G0tensor(661),G0tensor(662),G0tensor(663),G0tensor(664),G0tensor(665))
  call Hotf_4pt_reduction_last(G1tensor(329),RedSet_4(3),mass4set(:,24),  & 
G0tensor(666),G0tensor(667),G0tensor(668),G0tensor(669),G0tensor(670))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(4),mass4set(:,13),  & 
G0tensor(671),G0tensor(672),G0tensor(673),G0tensor(674),G0tensor(675))
  call Hotf_4pt_reduction_last(G1tensor(550),RedSet_4(6),mass4set(:,20),  & 
G0tensor(676),G0tensor(677),G0tensor(678),G0tensor(679),G0tensor(680))
  call Hotf_4pt_reduction_last(G1tensor(335),RedSet_4(7),mass4set(:,27),  & 
G0tensor(681),G0tensor(682),G0tensor(683),G0tensor(684),G0tensor(685))
  call Hotf_4pt_reduction_last(G1tensor(132),RedSet_4(8),mass4set(:,23),  & 
G0tensor(686),G0tensor(687),G0tensor(688),G0tensor(689),G0tensor(690))
  call Hotf_4pt_reduction_last(G1tensor(557),RedSet_4(10),mass4set(:,20),  & 
G0tensor(691),G0tensor(692),G0tensor(693),G0tensor(694),G0tensor(695))
  call Hotf_4pt_reduction_last(G1tensor(138),RedSet_4(11),mass4set(:,17),  & 
G0tensor(696),G0tensor(697),G0tensor(698),G0tensor(699),G0tensor(700))
  call Hotf_4pt_reduction_last(G1tensor(611),RedSet_4(13),mass4set(:,20),  & 
G0tensor(701),G0tensor(702),G0tensor(703),G0tensor(704),G0tensor(705))
  call Hotf_4pt_reduction_last(G1tensor(190),RedSet_4(17),mass4set(:,10),  & 
G0tensor(706),G0tensor(707),G0tensor(708),G0tensor(709),G0tensor(710))
  call Hotf_4pt_reduction_last(G1tensor(269),RedSet_4(18),mass4set(:,24),  & 
G0tensor(711),G0tensor(712),G0tensor(713),G0tensor(714),G0tensor(715))
  call Hotf_4pt_reduction_last(G1tensor(150),RedSet_4(19),mass4set(:,13),  & 
G0tensor(716),G0tensor(717),G0tensor(718),G0tensor(719),G0tensor(720))
  call Hotf_4pt_reduction_last(G1tensor(580),RedSet_4(21),mass4set(:,20),  & 
G0tensor(721),G0tensor(722),G0tensor(723),G0tensor(724),G0tensor(725))
  call Hotf_4pt_reduction_last(G1tensor(370),RedSet_4(22),mass4set(:,27),  & 
G0tensor(726),G0tensor(727),G0tensor(728),G0tensor(729),G0tensor(730))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(23),mass4set(:,23),  & 
G0tensor(731),G0tensor(732),G0tensor(733),G0tensor(734),G0tensor(735))
  call Hotf_4pt_reduction_last(G1tensor(593),RedSet_4(25),mass4set(:,20),  & 
G0tensor(736),G0tensor(737),G0tensor(738),G0tensor(739),G0tensor(740))
  call Hotf_4pt_reduction_last(G1tensor(162),RedSet_4(26),mass4set(:,17),  & 
G0tensor(741),G0tensor(742),G0tensor(743),G0tensor(744),G0tensor(745))
  call Hotf_4pt_reduction_last(G1tensor(209),RedSet_4(32),mass4set(:,24),  & 
G0tensor(746),G0tensor(747),G0tensor(748),G0tensor(749),G0tensor(750))
  call Hotf_4pt_reduction_last(G1tensor(174),RedSet_4(33),mass4set(:,13),  & 
G0tensor(751),G0tensor(752),G0tensor(753),G0tensor(754),G0tensor(755))
  call Hotf_4pt_reduction_last(G1tensor(448),RedSet_4(35),mass4set(:,27),  & 
G0tensor(756),G0tensor(757),G0tensor(758),G0tensor(759),G0tensor(760))
  call Hotf_4pt_reduction_last(G1tensor(180),RedSet_4(36),mass4set(:,23),  & 
G0tensor(761),G0tensor(762),G0tensor(763),G0tensor(764),G0tensor(765))
  call Hotf_4pt_reduction_last(G1tensor(610),RedSet_4(38),mass4set(:,20),  & 
G0tensor(766),G0tensor(767),G0tensor(768),G0tensor(769),G0tensor(770))
  call Hotf_4pt_reduction_last(G1tensor(413),RedSet_4(42),mass4set(:,24),  & 
G0tensor(771),G0tensor(772),G0tensor(773),G0tensor(774),G0tensor(775))
  call Hotf_4pt_reduction_last(G1tensor(192),RedSet_4(43),mass4set(:,13),  & 
G0tensor(776),G0tensor(777),G0tensor(778),G0tensor(779),G0tensor(780))
  call Hotf_4pt_reduction_last(G1tensor(419),RedSet_4(45),mass4set(:,27),  & 
G0tensor(781),G0tensor(782),G0tensor(783),G0tensor(784),G0tensor(785))
  call Hotf_4pt_reduction_last(G1tensor(198),RedSet_4(46),mass4set(:,23),  & 
G0tensor(786),G0tensor(787),G0tensor(788),G0tensor(789),G0tensor(790))
  call Hotf_4pt_reduction_last(G1tensor(34),RedSet_4(52),mass4set(:,10),  & 
G0tensor(791),G0tensor(792),G0tensor(793),G0tensor(794),G0tensor(795))
  call Hotf_4pt_reduction_last(G1tensor(210),RedSet_4(53),mass4set(:,13),  & 
G0tensor(796),G0tensor(797),G0tensor(798),G0tensor(799),G0tensor(800))
  call Hotf_4pt_reduction_last(G1tensor(628),RedSet_4(55),mass4set(:,20),  & 
G0tensor(801),G0tensor(802),G0tensor(803),G0tensor(804),G0tensor(805))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(56),mass4set(:,23),  & 
G0tensor(806),G0tensor(807),G0tensor(808),G0tensor(809),G0tensor(810))
  call Hotf_4pt_reduction_last(G1tensor(633),RedSet_4(61),mass4set(:,10),  & 
G0tensor(811),G0tensor(812),G0tensor(813),G0tensor(814),G0tensor(815))
  call Hotf_4pt_reduction_last(G1tensor(431),RedSet_4(62),mass4set(:,24),  & 
G0tensor(816),G0tensor(817),G0tensor(818),G0tensor(819),G0tensor(820))
  call Hotf_4pt_reduction_last(G1tensor(228),RedSet_4(63),mass4set(:,13),  & 
G0tensor(821),G0tensor(822),G0tensor(823),G0tensor(824),G0tensor(825))
  call Hotf_4pt_reduction_last(G1tensor(638),RedSet_4(65),mass4set(:,20),  & 
G0tensor(826),G0tensor(827),G0tensor(828),G0tensor(829),G0tensor(830))
  call Hotf_4pt_reduction_last(G1tensor(643),RedSet_4(61),mass4set(:,8),  & 
G0tensor(831),G0tensor(832),G0tensor(833),G0tensor(834),G0tensor(835))
  call Hotf_4pt_reduction_last(G1tensor(648),RedSet_4(62),mass4set(:,9),  & 
G0tensor(836),G0tensor(837),G0tensor(838),G0tensor(839),G0tensor(840))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(63),mass4set(:,12),  & 
G0tensor(841),G0tensor(842),G0tensor(843),G0tensor(844),G0tensor(845))
  call Hotf_4pt_reduction_last(G1tensor(653),RedSet_4(21),mass4set(:,19),  & 
G0tensor(846),G0tensor(847),G0tensor(848),G0tensor(849),G0tensor(850))
  call Hotf_4pt_reduction_last(G1tensor(658),RedSet_4(45),mass4set(:,6),  & 
G0tensor(851),G0tensor(852),G0tensor(853),G0tensor(854),G0tensor(855))
  call Hotf_4pt_reduction_last(G1tensor(663),RedSet_4(65),mass4set(:,19),  & 
G0tensor(856),G0tensor(857),G0tensor(858),G0tensor(859),G0tensor(860))
  call Hotf_4pt_reduction_last(G1tensor(668),RedSet_4(71),mass4set(:,20),  & 
G0tensor(861),G0tensor(862),G0tensor(863),G0tensor(864),G0tensor(865))
  call Hotf_4pt_reduction_last(G1tensor(673),RedSet_4(72),mass4set(:,10),  & 
G0tensor(866),G0tensor(867),G0tensor(868),G0tensor(869),G0tensor(870))
  call Hotf_4pt_reduction_last(G1tensor(270),RedSet_4(73),mass4set(:,13),  & 
G0tensor(871),G0tensor(872),G0tensor(873),G0tensor(874),G0tensor(875))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(75),mass4set(:,23),  & 
G0tensor(876),G0tensor(877),G0tensor(878),G0tensor(879),G0tensor(880))
  call Hotf_4pt_reduction_last(G1tensor(678),RedSet_4(79),mass4set(:,10),  & 
G0tensor(881),G0tensor(882),G0tensor(883),G0tensor(884),G0tensor(885))
  call Hotf_4pt_reduction_last(G1tensor(347),RedSet_4(80),mass4set(:,24),  & 
G0tensor(886),G0tensor(887),G0tensor(888),G0tensor(889),G0tensor(890))
  call Hotf_4pt_reduction_last(G1tensor(288),RedSet_4(81),mass4set(:,13),  & 
G0tensor(891),G0tensor(892),G0tensor(893),G0tensor(894),G0tensor(895))
  call Hotf_4pt_reduction_last(G1tensor(683),RedSet_4(79),mass4set(:,8),  & 
G0tensor(896),G0tensor(897),G0tensor(898),G0tensor(899),G0tensor(900))
  call Hotf_4pt_reduction_last(G1tensor(688),RedSet_4(80),mass4set(:,9),  & 
G0tensor(901),G0tensor(902),G0tensor(903),G0tensor(904),G0tensor(905))
  call Hotf_4pt_reduction_last(G1tensor(306),RedSet_4(81),mass4set(:,12),  & 
G0tensor(906),G0tensor(907),G0tensor(908),G0tensor(909),G0tensor(910))
  call Hotf_4pt_reduction_last(G1tensor(693),RedSet_4(6),mass4set(:,19),  & 
G0tensor(911),G0tensor(912),G0tensor(913),G0tensor(914),G0tensor(915))
  call Hotf_4pt_reduction_last(G1tensor(698),RedSet_4(7),mass4set(:,6),  & 
G0tensor(916),G0tensor(917),G0tensor(918),G0tensor(919),G0tensor(920))
  call Hotf_4pt_reduction_last(G1tensor(703),RedSet_4(88),mass4set(:,10),  & 
G0tensor(921),G0tensor(922),G0tensor(923),G0tensor(924),G0tensor(925))
  call Hotf_4pt_reduction_last(G1tensor(330),RedSet_4(89),mass4set(:,13),  & 
G0tensor(926),G0tensor(927),G0tensor(928),G0tensor(929),G0tensor(930))
  call Hotf_4pt_reduction_last(G1tensor(708),RedSet_4(90),mass4set(:,20),  & 
G0tensor(931),G0tensor(932),G0tensor(933),G0tensor(934),G0tensor(935))
  call Hotf_4pt_reduction_last(G1tensor(336),RedSet_4(91),mass4set(:,23),  & 
G0tensor(936),G0tensor(937),G0tensor(938),G0tensor(939),G0tensor(940))
  call Hotf_4pt_reduction_last(G1tensor(430),RedSet_4(96),mass4set(:,10),  & 
G0tensor(941),G0tensor(942),G0tensor(943),G0tensor(944),G0tensor(945))
  call Hotf_4pt_reduction_last(G1tensor(348),RedSet_4(97),mass4set(:,13),  & 
G0tensor(946),G0tensor(947),G0tensor(948),G0tensor(949),G0tensor(950))
  call Hotf_4pt_reduction_last(G1tensor(354),RedSet_4(99),mass4set(:,17),  & 
G0tensor(951),G0tensor(952),G0tensor(953),G0tensor(954),G0tensor(955))
  call Hotf_4pt_reduction_last(G1tensor(713),RedSet_4(102),mass4set(:,10),  & 
G0tensor(956),G0tensor(957),G0tensor(958),G0tensor(959),G0tensor(960))
  call Hotf_4pt_reduction_last(G1tensor(401),RedSet_4(103),mass4set(:,24),  & 
G0tensor(961),G0tensor(962),G0tensor(963),G0tensor(964),G0tensor(965))
  call Hotf_4pt_reduction_last(G1tensor(360),RedSet_4(104),mass4set(:,13),  & 
G0tensor(966),G0tensor(967),G0tensor(968),G0tensor(969),G0tensor(970))
  call Hotf_4pt_reduction_last(G1tensor(718),RedSet_4(106),mass4set(:,20),  & 
G0tensor(971),G0tensor(972),G0tensor(973),G0tensor(974),G0tensor(975))
  call Hotf_4pt_reduction_last(G1tensor(723),RedSet_4(102),mass4set(:,8),  & 
G0tensor(976),G0tensor(977),G0tensor(978),G0tensor(979),G0tensor(980))
  call Hotf_4pt_reduction_last(G1tensor(728),RedSet_4(103),mass4set(:,9),  & 
G0tensor(981),G0tensor(982),G0tensor(983),G0tensor(984),G0tensor(985))
  call Hotf_4pt_reduction_last(G1tensor(378),RedSet_4(104),mass4set(:,12),  & 
G0tensor(986),G0tensor(987),G0tensor(988),G0tensor(989),G0tensor(990))
  call Hotf_4pt_reduction_last(G1tensor(733),RedSet_4(22),mass4set(:,6),  & 
G0tensor(991),G0tensor(992),G0tensor(993),G0tensor(994),G0tensor(995))
  call Hotf_4pt_reduction_last(G1tensor(738),RedSet_4(106),mass4set(:,19),  & 
G0tensor(996),G0tensor(997),G0tensor(998),G0tensor(999),G0tensor(1000))
  call Hotf_4pt_reduction_last(G1tensor(478),RedSet_4(111),mass4set(:,10),  & 
G0tensor(1001),G0tensor(1002),G0tensor(1003),G0tensor(1004),G0tensor(1005))
  call Hotf_4pt_reduction_last(G1tensor(402),RedSet_4(112),mass4set(:,13),  & 
G0tensor(1006),G0tensor(1007),G0tensor(1008),G0tensor(1009),G0tensor(1010))
  call Hotf_4pt_reduction_last(G1tensor(408),RedSet_4(114),mass4set(:,17),  & 
G0tensor(1011),G0tensor(1012),G0tensor(1013),G0tensor(1014),G0tensor(1015))
  call Hotf_4pt_reduction_last(G1tensor(743),RedSet_4(117),mass4set(:,20),  & 
G0tensor(1016),G0tensor(1017),G0tensor(1018),G0tensor(1019),G0tensor(1020))
  call Hotf_4pt_reduction_last(G1tensor(748),RedSet_4(118),mass4set(:,10),  & 
G0tensor(1021),G0tensor(1022),G0tensor(1023),G0tensor(1024),G0tensor(1025))
  call Hotf_4pt_reduction_last(G1tensor(414),RedSet_4(119),mass4set(:,13),  & 
G0tensor(1026),G0tensor(1027),G0tensor(1028),G0tensor(1029),G0tensor(1030))
  call Hotf_4pt_reduction_last(G1tensor(420),RedSet_4(120),mass4set(:,23),  & 
G0tensor(1031),G0tensor(1032),G0tensor(1033),G0tensor(1034),G0tensor(1035))
  call Hotf_4pt_reduction_last(G1tensor(432),RedSet_4(124),mass4set(:,13),  & 
G0tensor(1036),G0tensor(1037),G0tensor(1038),G0tensor(1039),G0tensor(1040))
  call Hotf_4pt_reduction_last(G1tensor(753),RedSet_4(127),mass4set(:,10),  & 
G0tensor(1041),G0tensor(1042),G0tensor(1043),G0tensor(1044),G0tensor(1045))
  call Hotf_4pt_reduction_last(G1tensor(479),RedSet_4(128),mass4set(:,24),  & 
G0tensor(1046),G0tensor(1047),G0tensor(1048),G0tensor(1049),G0tensor(1050))
  call Hotf_4pt_reduction_last(G1tensor(438),RedSet_4(129),mass4set(:,13),  & 
G0tensor(1051),G0tensor(1052),G0tensor(1053),G0tensor(1054),G0tensor(1055))
  call Hotf_4pt_reduction_last(G1tensor(758),RedSet_4(127),mass4set(:,8),  & 
G0tensor(1056),G0tensor(1057),G0tensor(1058),G0tensor(1059),G0tensor(1060))
  call Hotf_4pt_reduction_last(G1tensor(763),RedSet_4(128),mass4set(:,9),  & 
G0tensor(1061),G0tensor(1062),G0tensor(1063),G0tensor(1064),G0tensor(1065))
  call Hotf_4pt_reduction_last(G1tensor(456),RedSet_4(129),mass4set(:,12),  & 
G0tensor(1066),G0tensor(1067),G0tensor(1068),G0tensor(1069),G0tensor(1070))
  call Hotf_4pt_reduction_last(G1tensor(768),RedSet_4(35),mass4set(:,6),  & 
G0tensor(1071),G0tensor(1072),G0tensor(1073),G0tensor(1074),G0tensor(1075))
  call Hotf_4pt_reduction_last(G1tensor(480),RedSet_4(134),mass4set(:,13),  & 
G0tensor(1076),G0tensor(1077),G0tensor(1078),G0tensor(1079),G0tensor(1080))
  call Hotf_4pt_reduction_last(G1tensor(773),RedSet_4(219),mass4set(:,10),  & 
G0tensor(1081),G0tensor(1082),G0tensor(1083),G0tensor(1084),G0tensor(1085))
  call Hotf_4pt_reduction_last(G1tensor(778),RedSet_4(181),mass4set(:,21),  & 
G0tensor(1086),G0tensor(1087),G0tensor(1088),G0tensor(1089),G0tensor(1090))
  call Hotf_4pt_reduction_last(G1tensor(783),RedSet_4(182),mass4set(:,21),  & 
G0tensor(1091),G0tensor(1092),G0tensor(1093),G0tensor(1094),G0tensor(1095))
  call Hotf_4pt_reduction_last(G1tensor(788),RedSet_4(183),mass4set(:,3),  & 
G0tensor(1096),G0tensor(1097),G0tensor(1098),G0tensor(1099),G0tensor(1100))
  call Hotf_4pt_reduction_last(G1tensor(793),RedSet_4(220),mass4set(:,10),  & 
G0tensor(1101),G0tensor(1102),G0tensor(1103),G0tensor(1104),G0tensor(1105))
  call Hotf_4pt_reduction_last(G1tensor(798),RedSet_4(186),mass4set(:,21),  & 
G0tensor(1106),G0tensor(1107),G0tensor(1108),G0tensor(1109),G0tensor(1110))
  call Hotf_4pt_reduction_last(G1tensor(803),RedSet_4(187),mass4set(:,21),  & 
G0tensor(1111),G0tensor(1112),G0tensor(1113),G0tensor(1114),G0tensor(1115))
  call Hotf_4pt_reduction_last(G1tensor(808),RedSet_4(188),mass4set(:,3),  & 
G0tensor(1116),G0tensor(1117),G0tensor(1118),G0tensor(1119),G0tensor(1120))
  call Hotf_4pt_reduction_last(G1tensor(813),RedSet_4(191),mass4set(:,13),  & 
G0tensor(1121),G0tensor(1122),G0tensor(1123),G0tensor(1124),G0tensor(1125))
  call Hotf_4pt_reduction_last(G1tensor(818),RedSet_4(192),mass4set(:,23),  & 
G0tensor(1126),G0tensor(1127),G0tensor(1128),G0tensor(1129),G0tensor(1130))
  call Hotf_4pt_reduction_last(G1tensor(823),RedSet_4(193),mass4set(:,17),  & 
G0tensor(1131),G0tensor(1132),G0tensor(1133),G0tensor(1134),G0tensor(1135))
  call Hotf_4pt_reduction_last(G1tensor(828),RedSet_4(191),mass4set(:,12),  & 
G0tensor(1136),G0tensor(1137),G0tensor(1138),G0tensor(1139),G0tensor(1140))
  call Hotf_4pt_reduction_last(G1tensor(833),RedSet_4(192),mass4set(:,7),  & 
G0tensor(1141),G0tensor(1142),G0tensor(1143),G0tensor(1144),G0tensor(1145))
  call Hotf_4pt_reduction_last(G1tensor(838),RedSet_4(193),mass4set(:,18),  & 
G0tensor(1146),G0tensor(1147),G0tensor(1148),G0tensor(1149),G0tensor(1150))
  call Hotf_4pt_reduction_last(G1tensor(843),RedSet_4(195),mass4set(:,13),  & 
G0tensor(1151),G0tensor(1152),G0tensor(1153),G0tensor(1154),G0tensor(1155))
  call Hotf_4pt_reduction_last(G1tensor(848),RedSet_4(196),mass4set(:,23),  & 
G0tensor(1156),G0tensor(1157),G0tensor(1158),G0tensor(1159),G0tensor(1160))
  call Hotf_4pt_reduction_last(G1tensor(853),RedSet_4(197),mass4set(:,17),  & 
G0tensor(1161),G0tensor(1162),G0tensor(1163),G0tensor(1164),G0tensor(1165))
  call Hotf_4pt_reduction_last(G1tensor(858),RedSet_4(195),mass4set(:,12),  & 
G0tensor(1166),G0tensor(1167),G0tensor(1168),G0tensor(1169),G0tensor(1170))
  call Hotf_4pt_reduction_last(G1tensor(863),RedSet_4(196),mass4set(:,7),  & 
G0tensor(1171),G0tensor(1172),G0tensor(1173),G0tensor(1174),G0tensor(1175))
  call Hotf_4pt_reduction_last(G1tensor(868),RedSet_4(197),mass4set(:,18),  & 
G0tensor(1176),G0tensor(1177),G0tensor(1178),G0tensor(1179),G0tensor(1180))
  call Hotf_4pt_reduction_last(G1tensor(873),RedSet_4(199),mass4set(:,13),  & 
G0tensor(1181),G0tensor(1182),G0tensor(1183),G0tensor(1184),G0tensor(1185))
  call Hotf_4pt_reduction_last(G1tensor(878),RedSet_4(189),mass4set(:,23),  & 
G0tensor(1186),G0tensor(1187),G0tensor(1188),G0tensor(1189),G0tensor(1190))
  call Hotf_4pt_reduction_last(G1tensor(883),RedSet_4(200),mass4set(:,17),  & 
G0tensor(1191),G0tensor(1192),G0tensor(1193),G0tensor(1194),G0tensor(1195))
  call Hotf_4pt_reduction_last(G1tensor(888),RedSet_4(202),mass4set(:,13),  & 
G0tensor(1196),G0tensor(1197),G0tensor(1198),G0tensor(1199),G0tensor(1200))
  call Hotf_4pt_reduction_last(G1tensor(893),RedSet_4(203),mass4set(:,17),  & 
G0tensor(1201),G0tensor(1202),G0tensor(1203),G0tensor(1204),G0tensor(1205))
  call Hotf_4pt_reduction_last(G1tensor(898),RedSet_4(202),mass4set(:,12),  & 
G0tensor(1206),G0tensor(1207),G0tensor(1208),G0tensor(1209),G0tensor(1210))
  call Hotf_4pt_reduction_last(G1tensor(903),RedSet_4(189),mass4set(:,7),  & 
G0tensor(1211),G0tensor(1212),G0tensor(1213),G0tensor(1214),G0tensor(1215))
  call Hotf_4pt_reduction_last(G1tensor(908),RedSet_4(203),mass4set(:,18),  & 
G0tensor(1216),G0tensor(1217),G0tensor(1218),G0tensor(1219),G0tensor(1220))
  call Hotf_4pt_reduction_last(G1tensor(913),RedSet_4(205),mass4set(:,13),  & 
G0tensor(1221),G0tensor(1222),G0tensor(1223),G0tensor(1224),G0tensor(1225))
  call Hotf_4pt_reduction_last(G1tensor(918),RedSet_4(184),mass4set(:,23),  & 
G0tensor(1226),G0tensor(1227),G0tensor(1228),G0tensor(1229),G0tensor(1230))
  call Hotf_4pt_reduction_last(G1tensor(923),RedSet_4(206),mass4set(:,17),  & 
G0tensor(1231),G0tensor(1232),G0tensor(1233),G0tensor(1234),G0tensor(1235))
  call Hotf_4pt_reduction_last(G1tensor(928),RedSet_4(208),mass4set(:,13),  & 
G0tensor(1236),G0tensor(1237),G0tensor(1238),G0tensor(1239),G0tensor(1240))
  call Hotf_4pt_reduction_last(G1tensor(933),RedSet_4(209),mass4set(:,17),  & 
G0tensor(1241),G0tensor(1242),G0tensor(1243),G0tensor(1244),G0tensor(1245))
  call Hotf_4pt_reduction_last(G1tensor(938),RedSet_4(208),mass4set(:,12),  & 
G0tensor(1246),G0tensor(1247),G0tensor(1248),G0tensor(1249),G0tensor(1250))
  call Hotf_4pt_reduction_last(G1tensor(943),RedSet_4(184),mass4set(:,7),  & 
G0tensor(1251),G0tensor(1252),G0tensor(1253),G0tensor(1254),G0tensor(1255))
  call Hotf_4pt_reduction_last(G1tensor(948),RedSet_4(209),mass4set(:,18),  & 
G0tensor(1256),G0tensor(1257),G0tensor(1258),G0tensor(1259),G0tensor(1260))
  call Hotf_4pt_reduction_last(G1tensor(953),RedSet_4(212),mass4set(:,10),  & 
G0tensor(1261),G0tensor(1262),G0tensor(1263),G0tensor(1264),G0tensor(1265))
  call Hotf_4pt_reduction_last(G1tensor(958),RedSet_4(155),mass4set(:,24),  & 
G0tensor(1266),G0tensor(1267),G0tensor(1268),G0tensor(1269),G0tensor(1270))
  call Hotf_4pt_reduction_last(G1tensor(963),RedSet_4(215),mass4set(:,10),  & 
G0tensor(1271),G0tensor(1272),G0tensor(1273),G0tensor(1274),G0tensor(1275))
  call Hotf_4pt_reduction_last(G1tensor(968),RedSet_4(161),mass4set(:,24),  & 
G0tensor(1276),G0tensor(1277),G0tensor(1278),G0tensor(1279),G0tensor(1280))
  call Hotf_4pt_reduction_last(G1tensor(973),RedSet_4(169),mass4set(:,24),  & 
G0tensor(1281),G0tensor(1282),G0tensor(1283),G0tensor(1284),G0tensor(1285))
  call Hotf_4pt_reduction_last(G1tensor(978),RedSet_4(178),mass4set(:,24),  & 
G0tensor(1286),G0tensor(1287),G0tensor(1288),G0tensor(1289),G0tensor(1290))
  call Hotf_4pt_reduction_last(G1tensor(983),RedSet_4(154),mass4set(:,19),  & 
G0tensor(1291),G0tensor(1292),G0tensor(1293),G0tensor(1294),G0tensor(1295))
  call Hotf_4pt_reduction_last(G1tensor(988),RedSet_4(149),mass4set(:,8),  & 
G0tensor(1296),G0tensor(1297),G0tensor(1298),G0tensor(1299),G0tensor(1300))
  call Hotf_4pt_reduction_last(G1tensor(993),RedSet_4(155),mass4set(:,9),  & 
G0tensor(1301),G0tensor(1302),G0tensor(1303),G0tensor(1304),G0tensor(1305))
  call Hotf_4pt_reduction_last(G1tensor(998),RedSet_4(149),mass4set(:,10),  & 
G0tensor(1306),G0tensor(1307),G0tensor(1308),G0tensor(1309),G0tensor(1310))
  call Hotf_4pt_reduction_last(G1tensor(1003),RedSet_4(160),mass4set(:,19),  & 
G0tensor(1311),G0tensor(1312),G0tensor(1313),G0tensor(1314),G0tensor(1315))
  call Hotf_4pt_reduction_last(G1tensor(1008),RedSet_4(138),mass4set(:,8),  & 
G0tensor(1316),G0tensor(1317),G0tensor(1318),G0tensor(1319),G0tensor(1320))
  call Hotf_4pt_reduction_last(G1tensor(1013),RedSet_4(161),mass4set(:,9),  & 
G0tensor(1321),G0tensor(1322),G0tensor(1323),G0tensor(1324),G0tensor(1325))
  call Hotf_4pt_reduction_last(G1tensor(1018),RedSet_4(138),mass4set(:,10),  & 
G0tensor(1326),G0tensor(1327),G0tensor(1328),G0tensor(1329),G0tensor(1330))
  call Hotf_4pt_reduction_last(G1tensor(1023),RedSet_4(168),mass4set(:,19),  & 
G0tensor(1331),G0tensor(1332),G0tensor(1333),G0tensor(1334),G0tensor(1335))
  call Hotf_4pt_reduction_last(G1tensor(1028),RedSet_4(142),mass4set(:,8),  & 
G0tensor(1336),G0tensor(1337),G0tensor(1338),G0tensor(1339),G0tensor(1340))
  call Hotf_4pt_reduction_last(G1tensor(1033),RedSet_4(169),mass4set(:,9),  & 
G0tensor(1341),G0tensor(1342),G0tensor(1343),G0tensor(1344),G0tensor(1345))
  call Hotf_4pt_reduction_last(G1tensor(1038),RedSet_4(142),mass4set(:,10),  & 
G0tensor(1346),G0tensor(1347),G0tensor(1348),G0tensor(1349),G0tensor(1350))
  call Hotf_4pt_reduction_last(G1tensor(1043),RedSet_4(177),mass4set(:,19),  & 
G0tensor(1351),G0tensor(1352),G0tensor(1353),G0tensor(1354),G0tensor(1355))
  call Hotf_4pt_reduction_last(G1tensor(1048),RedSet_4(146),mass4set(:,8),  & 
G0tensor(1356),G0tensor(1357),G0tensor(1358),G0tensor(1359),G0tensor(1360))
  call Hotf_4pt_reduction_last(G1tensor(1053),RedSet_4(178),mass4set(:,9),  & 
G0tensor(1361),G0tensor(1362),G0tensor(1363),G0tensor(1364),G0tensor(1365))
  call Hotf_4pt_reduction_last(G1tensor(1058),RedSet_4(146),mass4set(:,10),  & 
G0tensor(1366),G0tensor(1367),G0tensor(1368),G0tensor(1369),G0tensor(1370))
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(7),mass4set(:,28),  & 
G0tensor(1371),G0tensor(1372),G0tensor(1373),G0tensor(1374),G0tensor(1375))
  call Hotf_4pt_reduction_last(G1tensor(37),RedSet_4(22),mass4set(:,28),  & 
G0tensor(1376),G0tensor(1377),G0tensor(1378),G0tensor(1379),G0tensor(1380))
  call Hotf_4pt_reduction_last(G1tensor(73),RedSet_4(142),mass4set(:,29),  & 
G0tensor(1381),G0tensor(1382),G0tensor(1383),G0tensor(1384),G0tensor(1385))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(162),mass4set(:,30),  & 
G0tensor(1386),G0tensor(1387),G0tensor(1388),G0tensor(1389),G0tensor(1390))
  call Hotf_4pt_reduction_last(G1tensor(62),RedSet_4(45),mass4set(:,28),  & 
G0tensor(1391),G0tensor(1392),G0tensor(1393),G0tensor(1394),G0tensor(1395))
  call Hotf_4pt_reduction_last(G1tensor(98),RedSet_4(35),mass4set(:,28),  & 
G0tensor(1396),G0tensor(1397),G0tensor(1398),G0tensor(1399),G0tensor(1400))
  call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(149),mass4set(:,29),  & 
G0tensor(1401),G0tensor(1402),G0tensor(1403),G0tensor(1404),G0tensor(1405))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(179),mass4set(:,30),  & 
G0tensor(1406),G0tensor(1407),G0tensor(1408),G0tensor(1409),G0tensor(1410))
  call Hotf_4pt_reduction_last(G1tensor(1063),RedSet_4(150),mass4set(:,14),  & 
G0tensor(1411),G0tensor(1412),G0tensor(1413),G0tensor(1414),G0tensor(1415))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(150),mass4set(:,30),  & 
G0tensor(1416),G0tensor(1417),G0tensor(1418),G0tensor(1419),G0tensor(1420))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(156),mass4set(:,30),  & 
G0tensor(1421),G0tensor(1422),G0tensor(1423),G0tensor(1424),G0tensor(1425))
  call Hotf_4pt_reduction_last(G1tensor(1068),RedSet_4(144),mass4set(:,14),  & 
G0tensor(1426),G0tensor(1427),G0tensor(1428),G0tensor(1429),G0tensor(1430))
  call Hotf_4pt_reduction_last(G1tensor(64),RedSet_4(144),mass4set(:,30),  & 
G0tensor(1431),G0tensor(1432),G0tensor(1433),G0tensor(1434),G0tensor(1435))
  call Hotf_4pt_reduction_last(G1tensor(84),RedSet_4(170),mass4set(:,30),  & 
G0tensor(1436),G0tensor(1437),G0tensor(1438),G0tensor(1439),G0tensor(1440))
  call Hotf_4pt_reduction_last(G1tensor(1073),RedSet_4(7),mass4set(:,2),  & 
G0tensor(1441),G0tensor(1442),G0tensor(1443),G0tensor(1444),G0tensor(1445))
  call Hotf_4pt_reduction_last(G1tensor(1078),RedSet_4(7),mass4set(:,3),  & 
G0tensor(1446),G0tensor(1447),G0tensor(1448),G0tensor(1449),G0tensor(1450))
  call Hotf_4pt_reduction_last(G1tensor(1083),RedSet_4(7),mass4set(:,4),  & 
G0tensor(1451),G0tensor(1452),G0tensor(1453),G0tensor(1454),G0tensor(1455))
  call Hotf_4pt_reduction_last(G1tensor(1088),RedSet_4(22),mass4set(:,2),  & 
G0tensor(1456),G0tensor(1457),G0tensor(1458),G0tensor(1459),G0tensor(1460))
  call Hotf_4pt_reduction_last(G1tensor(1093),RedSet_4(22),mass4set(:,3),  & 
G0tensor(1461),G0tensor(1462),G0tensor(1463),G0tensor(1464),G0tensor(1465))
  call Hotf_4pt_reduction_last(G1tensor(1098),RedSet_4(22),mass4set(:,4),  & 
G0tensor(1466),G0tensor(1467),G0tensor(1468),G0tensor(1469),G0tensor(1470))
  call Hotf_4pt_reduction_last(G1tensor(1103),RedSet_4(45),mass4set(:,2),  & 
G0tensor(1471),G0tensor(1472),G0tensor(1473),G0tensor(1474),G0tensor(1475))
  call Hotf_4pt_reduction_last(G1tensor(1108),RedSet_4(45),mass4set(:,3),  & 
G0tensor(1476),G0tensor(1477),G0tensor(1478),G0tensor(1479),G0tensor(1480))
  call Hotf_4pt_reduction_last(G1tensor(1113),RedSet_4(45),mass4set(:,4),  & 
G0tensor(1481),G0tensor(1482),G0tensor(1483),G0tensor(1484),G0tensor(1485))
  call Hotf_4pt_reduction_last(G1tensor(1118),RedSet_4(35),mass4set(:,2),  & 
G0tensor(1486),G0tensor(1487),G0tensor(1488),G0tensor(1489),G0tensor(1490))
  call Hotf_4pt_reduction_last(G1tensor(1123),RedSet_4(35),mass4set(:,3),  & 
G0tensor(1491),G0tensor(1492),G0tensor(1493),G0tensor(1494),G0tensor(1495))
  call Hotf_4pt_reduction_last(G1tensor(1128),RedSet_4(35),mass4set(:,4),  & 
G0tensor(1496),G0tensor(1497),G0tensor(1498),G0tensor(1499),G0tensor(1500))
  call Hotf_4pt_reduction_last(G1tensor(1133),RedSet_4(184),mass4set(:,11),  & 
G0tensor(1501),G0tensor(1502),G0tensor(1503),G0tensor(1504),G0tensor(1505))
  call Hotf_4pt_reduction_last(G1tensor(1138),RedSet_4(189),mass4set(:,11),  & 
G0tensor(1506),G0tensor(1507),G0tensor(1508),G0tensor(1509),G0tensor(1510))
  call Hotf_4pt_reduction_last(G1tensor(1143),RedSet_4(150),mass4set(:,12),  & 
G0tensor(1511),G0tensor(1512),G0tensor(1513),G0tensor(1514),G0tensor(1515))
  call Hotf_4pt_reduction_last(G1tensor(1148),RedSet_4(150),mass4set(:,13),  & 
G0tensor(1516),G0tensor(1517),G0tensor(1518),G0tensor(1519),G0tensor(1520))
  call Hotf_4pt_reduction_last(G1tensor(1153),RedSet_4(144),mass4set(:,12),  & 
G0tensor(1521),G0tensor(1522),G0tensor(1523),G0tensor(1524),G0tensor(1525))
  call Hotf_4pt_reduction_last(G1tensor(1158),RedSet_4(144),mass4set(:,13),  & 
G0tensor(1526),G0tensor(1527),G0tensor(1528),G0tensor(1529),G0tensor(1530))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  call ol_merge_tensors(T0sum(89),[G0tensor(441)])
  call ol_merge_tensors(T0sum(90),[G0tensor(446)])
  call ol_merge_tensors(T0sum(91),[G0tensor(451)])
  call ol_merge_tensors(T0sum(92),[G0tensor(456)])
  call ol_merge_tensors(T0sum(93),[G0tensor(461)])
  call ol_merge_tensors(T0sum(94),[G0tensor(466)])
  call ol_merge_tensors(T0sum(95),[G0tensor(471)])
  call ol_merge_tensors(T0sum(96),[G0tensor(476)])
  call ol_merge_tensors(T0sum(97),[G0tensor(481)])
  call ol_merge_tensors(T0sum(98),[G0tensor(486)])
  call ol_merge_tensors(T0sum(99),[G0tensor(491)])
  call ol_merge_tensors(T0sum(100),[G0tensor(496)])
  call ol_merge_tensors(T0sum(101),[G0tensor(501)])
  call ol_merge_tensors(T0sum(102),[G0tensor(506)])
  call ol_merge_tensors(T0sum(103),[G0tensor(511)])
  call ol_merge_tensors(T0sum(104),[G0tensor(516)])
  call ol_merge_tensors(T0sum(105),[G0tensor(521)])
  call ol_merge_tensors(T0sum(106),[G0tensor(526)])
  call ol_merge_tensors(T0sum(107),[G0tensor(531)])
  call ol_merge_tensors(T0sum(108),[G0tensor(536)])
  call ol_merge_tensors(T0sum(109),[G0tensor(541)])
  call ol_merge_tensors(T0sum(110),[G0tensor(546)])
  call ol_merge_tensors(T0sum(111),[G0tensor(551)])
  call ol_merge_tensors(T0sum(112),[G0tensor(556)])
  call ol_merge_tensors(T0sum(113),[G0tensor(561)])
  call ol_merge_tensors(T0sum(114),[G0tensor(566)])
  call ol_merge_tensors(T0sum(115),[G0tensor(571)])
  call ol_merge_tensors(T0sum(116),[G0tensor(576)])
  call ol_merge_tensors(T0sum(117),[G0tensor(581)])
  call ol_merge_tensors(T0sum(118),[G0tensor(586)])
  call ol_merge_tensors(T0sum(119),[G0tensor(591)])
  call ol_merge_tensors(T0sum(120),[G0tensor(596)])
  call ol_merge_tensors(T0sum(121),[G0tensor(601)])
  call ol_merge_tensors(T0sum(122),[G0tensor(606)])
  call ol_merge_tensors(T0sum(123),[G0tensor(611)])
  call ol_merge_tensors(T0sum(124),[G0tensor(616)])
  call ol_merge_tensors(T0sum(125),[G0tensor(621)])
  call ol_merge_tensors(T0sum(126),[G0tensor(626)])
  call ol_merge_tensors(T0sum(127),[G0tensor(631)])
  call ol_merge_tensors(T0sum(128),[G0tensor(636)])
  call ol_merge_tensors(T0sum(129),[G0tensor(641)])
  call ol_merge_tensors(T0sum(130),[G0tensor(646)])
  call ol_merge_tensors(T0sum(131),[G0tensor(651)])
  call ol_merge_tensors(T0sum(132),[G0tensor(656)])
  call ol_merge_tensors(T0sum(133),[G0tensor(661)])
  call ol_merge_tensors(T0sum(134),[G0tensor(666)])
  call ol_merge_tensors(T0sum(135),[G0tensor(671)])
  call ol_merge_tensors(T0sum(136),[G0tensor(676)])
  call ol_merge_tensors(T0sum(137),[G0tensor(681)])
  call ol_merge_tensors(T0sum(138),[G0tensor(686)])
  call ol_merge_tensors(T0sum(139),[G0tensor(691)])
  call ol_merge_tensors(T0sum(140),[G0tensor(696)])
  call ol_merge_tensors(T0sum(141),[G0tensor(701)])
  call ol_merge_tensors(T0sum(142),[G0tensor(706)])
  call ol_merge_tensors(T0sum(143),[G0tensor(711)])
  call ol_merge_tensors(T0sum(144),[G0tensor(716)])
  call ol_merge_tensors(T0sum(145),[G0tensor(721)])
  call ol_merge_tensors(T0sum(146),[G0tensor(726)])
  call ol_merge_tensors(T0sum(147),[G0tensor(731)])
  call ol_merge_tensors(T0sum(148),[G0tensor(736)])
  call ol_merge_tensors(T0sum(149),[G0tensor(741)])
  call ol_merge_tensors(T0sum(150),[G0tensor(746)])
  call ol_merge_tensors(T0sum(151),[G0tensor(751)])
  call ol_merge_tensors(T0sum(152),[G0tensor(756)])
  call ol_merge_tensors(T0sum(153),[G0tensor(761)])
  call ol_merge_tensors(T0sum(154),[G0tensor(766)])
  call ol_merge_tensors(T0sum(155),[G0tensor(771)])
  call ol_merge_tensors(T0sum(156),[G0tensor(776)])
  call ol_merge_tensors(T0sum(157),[G0tensor(781)])
  call ol_merge_tensors(T0sum(158),[G0tensor(786)])
  call ol_merge_tensors(T0sum(159),[G0tensor(791)])
  call ol_merge_tensors(T0sum(160),[G0tensor(796)])
  call ol_merge_tensors(T0sum(161),[G0tensor(801)])
  call ol_merge_tensors(T0sum(162),[G0tensor(806)])
  call ol_merge_tensors(T0sum(163),[G0tensor(811)])
  call ol_merge_tensors(T0sum(164),[G0tensor(816)])
  call ol_merge_tensors(T0sum(165),[G0tensor(821)])
  call ol_merge_tensors(T0sum(166),[G0tensor(826)])
  call ol_merge_tensors(T0sum(167),[G0tensor(831)])
  call ol_merge_tensors(T0sum(168),[G0tensor(836)])
  call ol_merge_tensors(T0sum(169),[G0tensor(841)])
  call ol_merge_tensors(T0sum(170),[G0tensor(846)])
  call ol_merge_tensors(T0sum(171),[G0tensor(851)])
  call ol_merge_tensors(T0sum(172),[G0tensor(856)])
  call ol_merge_tensors(T0sum(173),[G0tensor(861)])
  call ol_merge_tensors(T0sum(174),[G0tensor(866)])
  call ol_merge_tensors(T0sum(175),[G0tensor(871)])
  call ol_merge_tensors(T0sum(176),[G0tensor(876)])
  call ol_merge_tensors(T0sum(177),[G0tensor(881)])
  call ol_merge_tensors(T0sum(178),[G0tensor(886)])
  call ol_merge_tensors(T0sum(179),[G0tensor(891)])
  call ol_merge_tensors(T0sum(180),[G0tensor(896)])
  call ol_merge_tensors(T0sum(181),[G0tensor(901)])
  call ol_merge_tensors(T0sum(182),[G0tensor(906)])
  call ol_merge_tensors(T0sum(183),[G0tensor(911)])
  call ol_merge_tensors(T0sum(184),[G0tensor(916)])
  call ol_merge_tensors(T0sum(185),[G0tensor(921)])
  call ol_merge_tensors(T0sum(186),[G0tensor(926)])
  call ol_merge_tensors(T0sum(187),[G0tensor(931)])
  call ol_merge_tensors(T0sum(188),[G0tensor(936)])
  call ol_merge_tensors(T0sum(189),[G0tensor(941)])
  call ol_merge_tensors(T0sum(190),[G0tensor(946)])
  call ol_merge_tensors(T0sum(191),[G0tensor(951)])
  call ol_merge_tensors(T0sum(192),[G0tensor(956)])
  call ol_merge_tensors(T0sum(193),[G0tensor(961)])
  call ol_merge_tensors(T0sum(194),[G0tensor(966)])
  call ol_merge_tensors(T0sum(195),[G0tensor(971)])
  call ol_merge_tensors(T0sum(196),[G0tensor(976)])
  call ol_merge_tensors(T0sum(197),[G0tensor(981)])
  call ol_merge_tensors(T0sum(198),[G0tensor(986)])
  call ol_merge_tensors(T0sum(199),[G0tensor(991)])
  call ol_merge_tensors(T0sum(200),[G0tensor(996)])
  call ol_merge_tensors(T0sum(201),[G0tensor(1001)])
  call ol_merge_tensors(T0sum(202),[G0tensor(1006)])
  call ol_merge_tensors(T0sum(203),[G0tensor(1011)])
  call ol_merge_tensors(T0sum(204),[G0tensor(1016)])
  call ol_merge_tensors(T0sum(205),[G0tensor(1021)])
  call ol_merge_tensors(T0sum(206),[G0tensor(1026)])
  call ol_merge_tensors(T0sum(207),[G0tensor(1031)])
  call ol_merge_tensors(T0sum(208),[G0tensor(1036)])
  call ol_merge_tensors(T0sum(209),[G0tensor(1041)])
  call ol_merge_tensors(T0sum(210),[G0tensor(1046)])
  call ol_merge_tensors(T0sum(211),[G0tensor(1051)])
  call ol_merge_tensors(T0sum(212),[G0tensor(1056)])
  call ol_merge_tensors(T0sum(213),[G0tensor(1061)])
  call ol_merge_tensors(T0sum(214),[G0tensor(1066)])
  call ol_merge_tensors(T0sum(215),[G0tensor(1071)])
  call ol_merge_tensors(T0sum(216),[G0tensor(1076)])
  call ol_merge_tensors(T0sum(217),[G0tensor(1081)])
  call ol_merge_tensors(T0sum(218),[G0tensor(1086)])
  call ol_merge_tensors(T0sum(219),[G0tensor(1091)])
  call ol_merge_tensors(T0sum(220),[G0tensor(1096)])
  call ol_merge_tensors(T0sum(221),[G0tensor(1101)])
  call ol_merge_tensors(T0sum(222),[G0tensor(1106)])
  call ol_merge_tensors(T0sum(223),[G0tensor(1111)])
  call ol_merge_tensors(T0sum(224),[G0tensor(1116)])
  call ol_merge_tensors(T0sum(225),[G0tensor(1121)])
  call ol_merge_tensors(T0sum(226),[G0tensor(1126)])
  call ol_merge_tensors(T0sum(227),[G0tensor(1131)])
  call ol_merge_tensors(T0sum(228),[G0tensor(1136)])
  call ol_merge_tensors(T0sum(229),[G0tensor(1141)])
  call ol_merge_tensors(T0sum(230),[G0tensor(1146)])
  call ol_merge_tensors(T0sum(231),[G0tensor(1151)])
  call ol_merge_tensors(T0sum(232),[G0tensor(1156)])
  call ol_merge_tensors(T0sum(233),[G0tensor(1161)])
  call ol_merge_tensors(T0sum(234),[G0tensor(1166)])
  call ol_merge_tensors(T0sum(235),[G0tensor(1171)])
  call ol_merge_tensors(T0sum(236),[G0tensor(1176)])
  call ol_merge_tensors(T0sum(237),[G0tensor(1181)])
  call ol_merge_tensors(T0sum(238),[G0tensor(1186)])
  call ol_merge_tensors(T0sum(239),[G0tensor(1191)])
  call ol_merge_tensors(T0sum(240),[G0tensor(1196)])
  call ol_merge_tensors(T0sum(241),[G0tensor(1201)])
  call ol_merge_tensors(T0sum(242),[G0tensor(1206)])
  call ol_merge_tensors(T0sum(243),[G0tensor(1211)])
  call ol_merge_tensors(T0sum(244),[G0tensor(1216)])
  call ol_merge_tensors(T0sum(245),[G0tensor(1221)])
  call ol_merge_tensors(T0sum(246),[G0tensor(1226)])
  call ol_merge_tensors(T0sum(247),[G0tensor(1231)])
  call ol_merge_tensors(T0sum(248),[G0tensor(1236)])
  call ol_merge_tensors(T0sum(249),[G0tensor(1241)])
  call ol_merge_tensors(T0sum(250),[G0tensor(1246)])
  call ol_merge_tensors(T0sum(251),[G0tensor(1251)])
  call ol_merge_tensors(T0sum(252),[G0tensor(1256)])
  call ol_merge_tensors(T0sum(253),[G0tensor(1261)])
  call ol_merge_tensors(T0sum(254),[G0tensor(1266)])
  call ol_merge_tensors(T0sum(255),[G0tensor(1271)])
  call ol_merge_tensors(T0sum(256),[G0tensor(1276)])
  call ol_merge_tensors(T0sum(257),[G0tensor(1281)])
  call ol_merge_tensors(T0sum(258),[G0tensor(1286)])
  call ol_merge_tensors(T0sum(259),[G0tensor(1291)])
  call ol_merge_tensors(T0sum(260),[G0tensor(1296)])
  call ol_merge_tensors(T0sum(261),[G0tensor(1301)])
  call ol_merge_tensors(T0sum(262),[G0tensor(1306)])
  call ol_merge_tensors(T0sum(263),[G0tensor(1311)])
  call ol_merge_tensors(T0sum(264),[G0tensor(1316)])
  call ol_merge_tensors(T0sum(265),[G0tensor(1321)])
  call ol_merge_tensors(T0sum(266),[G0tensor(1326)])
  call ol_merge_tensors(T0sum(267),[G0tensor(1331)])
  call ol_merge_tensors(T0sum(268),[G0tensor(1336)])
  call ol_merge_tensors(T0sum(269),[G0tensor(1341)])
  call ol_merge_tensors(T0sum(270),[G0tensor(1346)])
  call ol_merge_tensors(T0sum(271),[G0tensor(1351)])
  call ol_merge_tensors(T0sum(272),[G0tensor(1356)])
  call ol_merge_tensors(T0sum(273),[G0tensor(1361)])
  call ol_merge_tensors(T0sum(274),[G0tensor(1366)])
  call ol_merge_tensors(T0sum(275),[G0tensor(1371)])
  call ol_merge_tensors(T0sum(276),[G0tensor(1376)])
  call ol_merge_tensors(T0sum(277),[G0tensor(1381)])
  call ol_merge_tensors(T0sum(278),[G0tensor(1386)])
  call ol_merge_tensors(T0sum(279),[G0tensor(1391)])
  call ol_merge_tensors(T0sum(280),[G0tensor(1396)])
  call ol_merge_tensors(T0sum(281),[G0tensor(1401)])
  call ol_merge_tensors(T0sum(282),[G0tensor(1406)])
  call ol_merge_tensors(T0sum(283),[G0tensor(1411)])
  call ol_merge_tensors(T0sum(284),[G0tensor(1416)])
  call ol_merge_tensors(T0sum(285),[G0tensor(1421)])
  call ol_merge_tensors(T0sum(286),[G0tensor(1426)])
  call ol_merge_tensors(T0sum(287),[G0tensor(1431)])
  call ol_merge_tensors(T0sum(288),[G0tensor(1436)])
  call ol_merge_tensors(T0sum(289),[G0tensor(1441)])
  call ol_merge_tensors(T0sum(290),[G0tensor(1446)])
  call ol_merge_tensors(T0sum(291),[G0tensor(1451)])
  call ol_merge_tensors(T0sum(292),[G0tensor(1456)])
  call ol_merge_tensors(T0sum(293),[G0tensor(1461)])
  call ol_merge_tensors(T0sum(294),[G0tensor(1466)])
  call ol_merge_tensors(T0sum(295),[G0tensor(1471)])
  call ol_merge_tensors(T0sum(296),[G0tensor(1476)])
  call ol_merge_tensors(T0sum(297),[G0tensor(1481)])
  call ol_merge_tensors(T0sum(298),[G0tensor(1486)])
  call ol_merge_tensors(T0sum(299),[G0tensor(1491)])
  call ol_merge_tensors(T0sum(300),[G0tensor(1496)])
  call ol_merge_tensors(T0sum(301),[G0tensor(1501)])
  call ol_merge_tensors(T0sum(302),[G0tensor(1506)])
  call ol_merge_tensors(T0sum(303),[G0tensor(1511)])
  call ol_merge_tensors(T0sum(304),[G0tensor(1516)])
  call ol_merge_tensors(T0sum(305),[G0tensor(1521)])
  call ol_merge_tensors(T0sum(306),[G0tensor(1526)])
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[32,15,16],[nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,117),heltab2x64(:,:,257))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[53,2,8],[nMW,0,nMW],4,2,wf4(:,1),wf4(:,7))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,1),wf4(:,7),G0H4(5),m4h4x4x4(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[53,2,8],[nMW,0,nMW],4,2,wf4(:,1),wf4(:,3))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,1),wf4(:,3),G0H4(3),m4h4x4x4(:,2),heltab3x64(:,:,2))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[32,15,16],[nMW,nMW,0],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,118),heltab2x64(:,:,258))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[54,1,8],[nMW,0,nMW],4,2,wf4(:,5),wf4(:,7))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,5),wf4(:,7),G0H4(1),m4h4x4x4(:,3),heltab3x64(:,:,3))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[54,1,8],[nMW,0,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,3),wf4(:,5),G0H4(2),m4h4x4x4(:,4),heltab3x64(:,:,4))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[57,2,4],[nMW,0,nMW],4,2,wf4(:,4),wf4(:,7))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,4),wf4(:,7),G0H4(4),m4h4x4x4(:,5),heltab3x64(:,:,5))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[57,2,4],[nMW,0,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,3),wf4(:,4),G0H4(6),m4h4x4x4(:,6),heltab3x64(:,:,6))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[58,1,4],[nMW,0,nMW],4,2,wf4(:,2),wf4(:,7))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,2),wf4(:,7),G0H4(7),m4h4x4x4(:,7),heltab3x64(:,:,7))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[58,1,4],[nMW,0,nMW],4,2,wf4(:,2),wf4(:,3))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,2),wf4(:,3),G0H4(8),m4h4x4x4(:,8),heltab3x64(:,:,8))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[48,5,10],[0,0,0],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(19),m3h4x16(:,105),heltab2x64(:,:,259))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(3),n2h16(119))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[48,5,10],[nML,nML,nML],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(22),m3h4x16(:,106),heltab2x64(:,:,260))
  call Hloop_A_Q(ntryL,G0H16(22),48,nML,G1H16(2),n2h16(120))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[48,5,10],[0,0,0],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(3),m3h4x16(:,107),heltab2x64(:,:,261))
  call Hloop_Q_A(ntryL,G0H16(3),48,0,G1H16(7),n2h16(121))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[48,5,10],[nML,nML,nML],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(2),m3h4x16(:,108),heltab2x64(:,:,262))
  call Hloop_Q_A(ntryL,G0H16(2),48,nML,G1H16(12),n2h16(122))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[48,5,10],[0,0,0],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(6),m3h4x16(:,109),heltab2x64(:,:,263))
  call Hloop_A_Q(ntryL,G0H16(6),48,0,G1H16(9),n2h16(123))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[48,5,10],[nMT,nMT,nMT],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(15),m3h4x16(:,110),heltab2x64(:,:,264))
  call Hloop_A_Q(ntryL,G0H16(15),48,nMT,G1H16(14),n2h16(124))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[48,5,10],[0,0,0],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(14),m3h4x16(:,111),heltab2x64(:,:,265))
  call Hloop_Q_A(ntryL,G0H16(14),48,0,G1H16(16),n2h16(125))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[48,5,10],[nMT,nMT,nMT],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(18),m3h4x16(:,112),heltab2x64(:,:,266))
  call Hloop_Q_A(ntryL,G0H16(18),48,nMT,G1H16(22),n2h16(126))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[48,5,10],[0,0,0],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(17),m3h4x16(:,113),heltab2x64(:,:,267))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(5),n2h16(127))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[48,5,10],[nMB,nMB,nMB],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),m3h4x16(:,114),heltab2x64(:,:,268))
  call Hloop_A_Q(ntryL,G0H16(5),48,nMB,G1H16(24),n2h16(128))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[48,5,10],[0,0,0],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(25),m3h4x16(:,115),heltab2x64(:,:,269))
  call Hloop_Q_A(ntryL,G0H16(25),48,0,G1H16(10),n2h16(129))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[48,5,10],[nMB,nMB,nMB],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(1),m3h4x16(:,116),heltab2x64(:,:,270))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(18),n2h16(130))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[48,5,10],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(4),ngZn,m3h4x16(:,117),heltab2x64(:,:,271))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(15),n2h16(131))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[48,5,10],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(7),ngZn,m3h4x16(:,118),heltab2x64(:,:,272))
  call Hloop_Q_A(ntryL,G0H16(7),48,0,G1H16(23),n2h16(132))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[48,5,10],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(10),ngZl,m3h4x16(:,119),heltab2x64(:,:,273))
  call Hloop_A_Q(ntryL,G0H16(10),48,0,G1H16(26),n2h16(133))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[48,5,10],[nML,nML,nML],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(21),ngZl,m3h4x16(:,120),heltab2x64(:,:,274))
  call Hloop_A_Q(ntryL,G0H16(21),48,nML,G1H16(28),n2h16(134))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[48,5,10],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(20),ngZl,m3h4x16(:,121),heltab2x64(:,:,275))
  call Hloop_Q_A(ntryL,G0H16(20),48,0,G1H16(31),n2h16(135))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[48,5,10],[nML,nML,nML],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(24),ngZl,m3h4x16(:,122),heltab2x64(:,:,276))
  call Hloop_Q_A(ntryL,G0H16(24),48,nML,G1H16(30),n2h16(136))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[48,5,10],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(23),ngZu,m3h4x16(:,123),heltab2x64(:,:,277))
  call Hloop_A_Q(ntryL,G0H16(23),48,0,G1H16(33),n2h16(137))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[48,5,10],[nMT,nMT,nMT],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(13),ngZu,m3h4x16(:,124),heltab2x64(:,:,278))
  call Hloop_A_Q(ntryL,G0H16(13),48,nMT,G1H16(36),n2h16(138))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[48,5,10],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(9),ngZu,m3h4x16(:,125),heltab2x64(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(9),48,0,G1H16(35),n2h16(139))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[48,5,10],[nMT,nMT,nMT],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(8),ngZu,m3h4x16(:,126),heltab2x64(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(8),48,nMT,G1H16(38),n2h16(140))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[48,5,10],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(12),ngZd,m3h4x16(:,127),heltab2x64(:,:,281))
  call Hloop_A_Q(ntryL,G0H16(12),48,0,G1H16(40),n2h16(141))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[48,5,10],[nMB,nMB,nMB],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(11),ngZd,m3h4x16(:,128),heltab2x64(:,:,282))
  call Hloop_A_Q(ntryL,G0H16(11),48,nMB,G1H16(42),n2h16(142))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[48,5,10],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(16),ngZd,m3h4x16(:,129),heltab2x64(:,:,283))
  call Hloop_Q_A(ntryL,G0H16(16),48,0,G1H16(45),n2h16(143))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[48,5,10],[nMB,nMB,nMB],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(19),ngZd,m3h4x16(:,130),heltab2x64(:,:,284))
  call Hloop_Q_A(ntryL,G0H16(19),48,nMB,G1H16(44),n2h16(144))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(47),m3h4x16(:,131),heltab2x64(:,:,285))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(50),m3h4x16(:,132),heltab2x64(:,:,286))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(49),m3h4x16(:,133),heltab2x64(:,:,287))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(52),m3h4x16(:,134),heltab2x64(:,:,288))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,7),G1H16(54),m3h4x16(:,135),heltab2x64(:,:,289))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(56),m3h4x16(:,136),heltab2x64(:,:,290))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,7),G1H16(1),m3h4x16(:,137),heltab2x64(:,:,291))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(4),m3h4x16(:,138),heltab2x64(:,:,292))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,3),G1H16(6),m3h4x16(:,139),heltab2x64(:,:,293))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(11),m3h4x16(:,140),heltab2x64(:,:,294))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,3),G1H16(17),m3h4x16(:,141),heltab2x64(:,:,295))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(19),m3h4x16(:,142),heltab2x64(:,:,296))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(21),m3h4x16(:,143),heltab2x64(:,:,297))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(8),m3h4x16(:,144),heltab2x64(:,:,298))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(13),m3h4x16(:,145),heltab2x64(:,:,299))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(20),m3h4x16(:,146),heltab2x64(:,:,300))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(22),m3h4x16(:,147),heltab2x64(:,:,301))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(3),m3h4x16(:,148),heltab2x64(:,:,302))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(2),m3h4x16(:,149),heltab2x64(:,:,303))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(6),m3h4x16(:,150),heltab2x64(:,:,304))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(15),m3h4x16(:,151),heltab2x64(:,:,305))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(14),m3h4x16(:,152),heltab2x64(:,:,306))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(18),m3h4x16(:,153),heltab2x64(:,:,307))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(17),m3h4x16(:,154),heltab2x64(:,:,308))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(25),m3h4x16(:,155),heltab2x64(:,:,309))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(27),m3h4x16(:,156),heltab2x64(:,:,310))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(29),m3h4x16(:,157),heltab2x64(:,:,311))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(32),m3h4x16(:,158),heltab2x64(:,:,312))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(34),m3h4x16(:,159),heltab2x64(:,:,313))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(37),m3h4x16(:,160),heltab2x64(:,:,314))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(39),m3h4x16(:,161),heltab2x64(:,:,315))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(41),m3h4x16(:,162),heltab2x64(:,:,316))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(5),m3h4x16(:,163),heltab2x64(:,:,317))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(25),m3h4x16(:,164),heltab2x64(:,:,318))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,165),heltab2x64(:,:,319))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(4),m3h4x16(:,166),heltab2x64(:,:,320))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(7),m3h4x16(:,167),heltab2x64(:,:,321))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(10),m3h4x16(:,168),heltab2x64(:,:,322))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(21),m3h4x16(:,169),heltab2x64(:,:,323))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[48,5,10],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(20),m3h4x16(:,170),heltab2x64(:,:,324))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[32,10,21],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,119),heltab2x64(:,:,325))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(1),n2h32(17))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[32,10,21],[0,0,nMZ],3,2,wf4(:,2),wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(12),ngZu,m3h2x32(:,120),heltab2x64(:,:,326))
  call Hloop_A_Q(ntryL,G0H32(12),32,0,G1H32(2),n2h32(18))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[32,10,21],[0,0,nMW],3,2,wf4(:,2),wf8(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,121),heltab2x64(:,:,327))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(3),n2h32(19))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[32,10,21],[nMW,nMW,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,122),heltab2x64(:,:,328))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[37,10,16],[0,0,0],3,2,wf8(:,34),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,34),G0H8(7),m3h8x8(:,37),heltab2x64(:,:,329))
  call Hloop_A_Q(ntryL,G0H8(7),37,0,G1H8(45),n2h8(71))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[37,10,16],[0,0,nMZ],3,2,wf8(:,34),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,34),G0H8(8),ngZu,m3h8x8(:,38),heltab2x64(:,:,330))
  call Hloop_A_Q(ntryL,G0H8(8),37,0,G1H8(46),n2h8(72))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[37,10,16],[0,0,nMW],3,2,wf8(:,34),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,34),G0H8(9),m3h8x8(:,39),heltab2x64(:,:,331))
  call Hloop_A_Q(ntryL,G0H8(9),37,0,G1H8(6),n2h8(73))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[37,10,16],[nMW,nMW,0],3,2,wf8(:,34),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,34),G0H8(30),m3h8x8(:,40),heltab2x64(:,:,332))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[32,5,26],[0,0,0],3,2,wf4(:,1),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,123),heltab2x64(:,:,333))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(4),n2h32(20))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[32,5,26],[0,0,nMZ],3,2,wf4(:,1),wf8(:,6))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZu,m3h2x32(:,124),heltab2x64(:,:,334))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(5),n2h32(21))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[32,5,26],[0,0,nMW],3,2,wf4(:,1),wf8(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,125),heltab2x64(:,:,335))
  call Hloop_A_Q(ntryL,G0H32(18),32,0,G1H32(6),n2h32(22))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[32,5,26],[nMW,nMW,0],3,2,wf4(:,1),wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,126),heltab2x64(:,:,336))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[42,5,16],[0,0,0],3,2,wf8(:,36),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,36),G0H8(4),m3h8x8(:,41),heltab2x64(:,:,337))
  call Hloop_A_Q(ntryL,G0H8(4),42,0,G1H8(7),n2h8(74))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[42,5,16],[0,0,nMZ],3,2,wf8(:,36),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,36),G0H8(5),ngZu,m3h8x8(:,42),heltab2x64(:,:,338))
  call Hloop_A_Q(ntryL,G0H8(5),42,0,G1H8(9),n2h8(75))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[42,5,16],[0,0,nMW],3,2,wf8(:,36),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,36),G0H8(6),m3h8x8(:,43),heltab2x64(:,:,339))
  call Hloop_A_Q(ntryL,G0H8(6),42,0,G1H8(10),n2h8(76))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[42,5,16],[nMW,nMW,0],3,2,wf8(:,36),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,36),G0H8(10),m3h8x8(:,44),heltab2x64(:,:,340))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[32,15,16],[nMZ,nMZ,0],3,1,wf16(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(20),ngZu,m3h2x32(:,127),heltab2x64(:,:,341))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[32,15,16],[nMW,nMW,0],3,1,wf16(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,128),heltab2x64(:,:,342))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[48,7,8],[0,nMW,0],3,2,wf4(:,7),wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(24),m3h4x16(:,171),heltab2x64(:,:,343))
  call Hloop_A_Q(ntryL,G0H16(24),48,0,G1H16(43),n2h16(145))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[48,7,8],[0,nMZ,0],3,2,wf4(:,3),wf8(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(23),ngZn,m3h4x16(:,172),heltab2x64(:,:,344))
  call Hloop_A_Q(ntryL,G0H16(23),48,0,G1H16(46),n2h16(146))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[48,7,8],[0,nMW,0],3,2,wf4(:,3),wf8(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(13),ngZl,m3h4x16(:,173),heltab2x64(:,:,345))
  call Hloop_A_Q(ntryL,G0H16(13),48,0,G1H16(48),n2h16(147))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[48,7,8],[nMW,0,nMW],3,2,wf4(:,7),wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(51),m3h4x16(:,174),heltab2x64(:,:,346))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[48,7,8],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(53),m3h4x16(:,175),heltab2x64(:,:,347))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[48,2,13],[0,nMW,0],3,2,wf4(:,7),wf8(:,58))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(9),m3h4x16(:,176),heltab2x64(:,:,348))
  call Hloop_A_Q(ntryL,G0H16(9),48,0,G1H16(55),n2h16(148))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[48,2,13],[0,nMZ,0],3,2,wf4(:,3),wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(8),ngZn,m3h4x16(:,177),heltab2x64(:,:,349))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(57),n2h16(149))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[48,2,13],[0,nMW,0],3,2,wf4(:,3),wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(12),ngZl,m3h4x16(:,178),heltab2x64(:,:,350))
  call Hloop_A_Q(ntryL,G0H16(12),48,0,G1H16(58),n2h16(150))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[48,2,13],[nMW,0,nMW],3,2,wf4(:,7),wf8(:,58))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(59),m3h4x16(:,179),heltab2x64(:,:,351))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[48,2,13],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,58))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(60),m3h4x16(:,180),heltab2x64(:,:,352))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[50,5,8],[0,0,nMZ],3,2,wf8(:,12),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,12),G0H8(11),ngZn,m3h8x8(:,45),heltab2x64(:,:,353))
  call Hloop_Q_A(ntryL,G0H8(11),50,0,G1H8(11),n2h8(77))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[50,5,8],[0,0,nMW],3,2,wf8(:,12),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,12),G0H8(12),m3h8x8(:,46),heltab2x64(:,:,354))
  call Hloop_Q_A(ntryL,G0H8(12),50,0,G1H8(12),n2h8(78))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[50,5,8],[nMW,nMW,0],3,2,wf8(:,12),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,12),G0H8(13),m3h8x8(:,47),heltab2x64(:,:,355))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[56,2,5],[nMZ,0,0],3,2,wf8(:,61),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,61),G0H8(14),ngZn,m3h8x8(:,48),heltab2x64(:,:,356))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[56,2,5],[nMW,0,0],3,2,wf8(:,61),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,61),G0H8(15),m3h8x8(:,49),heltab2x64(:,:,357))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[56,2,5],[0,nMW,nMW],3,2,wf8(:,61),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,61),G0H8(16),m3h8x8(:,50),heltab2x64(:,:,358))
  call Hloop_A_Q(ntryL,G0H8(16),56,0,G1H8(15),n2h8(79))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[53,2,8],[nMZ,0,nMZ],3,1,wf16(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,2),G0H4(9),m3h16x4(:,1),heltab2x64(:,:,359))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[53,2,8],[nMW,0,nMW],3,1,wf16(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,2),G0H4(10),m3h16x4(:,2),heltab2x64(:,:,360))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[32,15,16],[0,0,0],3,1,wf16(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,129),heltab2x64(:,:,361))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(7),n2h32(23))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[32,15,16],[0,0,nMZ],3,1,wf16(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(21),ngZu,m3h2x32(:,130),heltab2x64(:,:,362))
  call Hloop_A_Q(ntryL,G0H32(21),32,0,G1H32(8),n2h32(24))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[32,15,16],[0,0,nMW],3,1,wf16(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,131),heltab2x64(:,:,363))
  call Hloop_A_Q(ntryL,G0H32(22),32,0,G1H32(9),n2h32(25))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[32,15,16],[nMW,nMW,0],3,1,wf16(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,132),heltab2x64(:,:,364))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[32,15,16],[0,0,0],3,1,wf16(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,133),heltab2x64(:,:,365))
  call Hloop_A_Q(ntryL,G0H32(27),32,0,G1H32(10),n2h32(26))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[32,15,16],[0,0,nMZ],3,1,wf16(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(28),ngZu,m3h2x32(:,134),heltab2x64(:,:,366))
  call Hloop_A_Q(ntryL,G0H32(28),32,0,G1H32(11),n2h32(27))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[32,15,16],[0,0,nMW],3,1,wf16(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,135),heltab2x64(:,:,367))
  call Hloop_A_Q(ntryL,G0H32(29),32,0,G1H32(12),n2h32(28))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[32,15,16],[nMW,nMW,0],3,1,wf16(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,136),heltab2x64(:,:,368))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[53,2,8],[0,nMW,0],3,1,wf16(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,5),G0H4(11),m3h16x4(:,3),heltab2x64(:,:,369))
  call Hloop_A_Q(ntryL,G0H4(11),53,0,G1H4(68),n2h4(121))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[53,2,8],[0,nMZ,0],3,1,wf16(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,6),G0H4(11),ngZn,m3h16x4(:,4),heltab2x64(:,:,370))
  call Hloop_A_Q(ntryL,G0H4(11),53,0,G1H4(72),n2h4(122))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[53,2,8],[0,nMW,0],3,1,wf16(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,6),G0H4(11),ngZl,m3h16x4(:,5),heltab2x64(:,:,371))
  call Hloop_A_Q(ntryL,G0H4(11),53,0,G1H4(29),n2h4(123))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[53,2,8],[nMW,0,nMW],3,1,wf16(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,5),53,G1H4(73),m3h16x4(:,6),heltab2x64(:,:,372))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[53,2,8],[nMW,0,nMW],3,1,wf16(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,6),53,G1H4(74),m3h16x4(:,7),heltab2x64(:,:,373))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[53,2,8],[0,nMW,0],3,1,wf16(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,7),G0H4(11),m3h16x4(:,8),heltab2x64(:,:,374))
  call Hloop_A_Q(ntryL,G0H4(11),53,0,G1H4(78),n2h4(124))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[53,2,8],[0,nMZ,0],3,1,wf16(:,8))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,8),G0H4(11),ngZn,m3h16x4(:,9),heltab2x64(:,:,375))
  call Hloop_A_Q(ntryL,G0H4(11),53,0,G1H4(79),n2h4(125))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[53,2,8],[0,nMW,0],3,1,wf16(:,8))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,8),G0H4(11),ngZl,m3h16x4(:,10),heltab2x64(:,:,376))
  call Hloop_A_Q(ntryL,G0H4(11),53,0,G1H4(80),n2h4(126))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[53,2,8],[nMW,0,nMW],3,1,wf16(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,7),53,G1H4(83),m3h16x4(:,11),heltab2x64(:,:,377))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[53,2,8],[nMW,0,nMW],3,1,wf16(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,8),53,G1H4(84),m3h16x4(:,12),heltab2x64(:,:,378))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[48,6,9],[0,0,0],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(11),m3h4x16(:,181),heltab2x64(:,:,379))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(61),n2h16(151))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[48,6,9],[nML,nML,nML],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(16),m3h4x16(:,182),heltab2x64(:,:,380))
  call Hloop_Q_A(ntryL,G0H16(16),48,nML,G1H16(62),n2h16(152))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[48,6,9],[0,0,0],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(19),m3h4x16(:,183),heltab2x64(:,:,381))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(63),n2h16(153))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[48,6,9],[nML,nML,nML],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(24),m3h4x16(:,184),heltab2x64(:,:,382))
  call Hloop_A_Q(ntryL,G0H16(24),48,nML,G1H16(64),n2h16(154))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[48,6,9],[0,0,0],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(23),m3h4x16(:,185),heltab2x64(:,:,383))
  call Hloop_Q_A(ntryL,G0H16(23),48,0,G1H16(65),n2h16(155))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[48,6,9],[nMT,nMT,nMT],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(13),m3h4x16(:,186),heltab2x64(:,:,384))
  call Hloop_Q_A(ntryL,G0H16(13),48,nMT,G1H16(66),n2h16(156))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[48,6,9],[0,0,0],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(9),m3h4x16(:,187),heltab2x64(:,:,385))
  call Hloop_A_Q(ntryL,G0H16(9),48,0,G1H16(67),n2h16(157))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[48,6,9],[nMT,nMT,nMT],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(8),m3h4x16(:,188),heltab2x64(:,:,386))
  call Hloop_A_Q(ntryL,G0H16(8),48,nMT,G1H16(68),n2h16(158))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[48,6,9],[0,0,0],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(12),m3h4x16(:,189),heltab2x64(:,:,387))
  call Hloop_Q_A(ntryL,G0H16(12),48,0,G1H16(69),n2h16(159))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[48,6,9],[nMB,nMB,nMB],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(11),m3h4x16(:,190),heltab2x64(:,:,388))
  call Hloop_Q_A(ntryL,G0H16(11),48,nMB,G1H16(70),n2h16(160))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[48,6,9],[0,0,0],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(16),m3h4x16(:,191),heltab2x64(:,:,389))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(71),n2h16(161))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[48,6,9],[nMB,nMB,nMB],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(19),m3h4x16(:,192),heltab2x64(:,:,390))
  call Hloop_A_Q(ntryL,G0H16(19),48,nMB,G1H16(72),n2h16(162))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[48,6,9],[0,0,0],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(24),ngZn,m3h4x16(:,193),heltab2x64(:,:,391))
  call Hloop_Q_A(ntryL,G0H16(24),48,0,G1H16(73),n2h16(163))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[48,6,9],[0,0,0],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(23),ngZn,m3h4x16(:,194),heltab2x64(:,:,392))
  call Hloop_A_Q(ntryL,G0H16(23),48,0,G1H16(74),n2h16(164))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[48,6,9],[0,0,0],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(13),ngZl,m3h4x16(:,195),heltab2x64(:,:,393))
  call Hloop_Q_A(ntryL,G0H16(13),48,0,G1H16(75),n2h16(165))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[48,6,9],[nML,nML,nML],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(9),ngZl,m3h4x16(:,196),heltab2x64(:,:,394))
  call Hloop_Q_A(ntryL,G0H16(9),48,nML,G1H16(76),n2h16(166))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[48,6,9],[0,0,0],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(8),ngZl,m3h4x16(:,197),heltab2x64(:,:,395))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(77),n2h16(167))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[48,6,9],[nML,nML,nML],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(12),ngZl,m3h4x16(:,198),heltab2x64(:,:,396))
  call Hloop_A_Q(ntryL,G0H16(12),48,nML,G1H16(78),n2h16(168))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[48,6,9],[0,0,0],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(11),ngZu,m3h4x16(:,199),heltab2x64(:,:,397))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(79),n2h16(169))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[48,6,9],[nMT,nMT,nMT],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(16),ngZu,m3h4x16(:,200),heltab2x64(:,:,398))
  call Hloop_Q_A(ntryL,G0H16(16),48,nMT,G1H16(80),n2h16(170))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[48,6,9],[0,0,0],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(19),ngZu,m3h4x16(:,201),heltab2x64(:,:,399))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(81),n2h16(171))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[48,6,9],[nMT,nMT,nMT],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(24),ngZu,m3h4x16(:,202),heltab2x64(:,:,400))
  call Hloop_A_Q(ntryL,G0H16(24),48,nMT,G1H16(82),n2h16(172))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[48,6,9],[0,0,0],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(23),ngZd,m3h4x16(:,203),heltab2x64(:,:,401))
  call Hloop_Q_A(ntryL,G0H16(23),48,0,G1H16(83),n2h16(173))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[48,6,9],[nMB,nMB,nMB],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(13),ngZd,m3h4x16(:,204),heltab2x64(:,:,402))
  call Hloop_Q_A(ntryL,G0H16(13),48,nMB,G1H16(84),n2h16(174))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[48,6,9],[0,0,0],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(9),ngZd,m3h4x16(:,205),heltab2x64(:,:,403))
  call Hloop_A_Q(ntryL,G0H16(9),48,0,G1H16(85),n2h16(175))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[48,6,9],[nMB,nMB,nMB],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(8),ngZd,m3h4x16(:,206),heltab2x64(:,:,404))
  call Hloop_A_Q(ntryL,G0H16(8),48,nMB,G1H16(86),n2h16(176))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(87),m3h4x16(:,207),heltab2x64(:,:,405))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(88),m3h4x16(:,208),heltab2x64(:,:,406))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(89),m3h4x16(:,209),heltab2x64(:,:,407))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(90),m3h4x16(:,210),heltab2x64(:,:,408))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(91),m3h4x16(:,211),heltab2x64(:,:,409))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,7),G1H16(92),m3h4x16(:,212),heltab2x64(:,:,410))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(93),m3h4x16(:,213),heltab2x64(:,:,411))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,7),G1H16(94),m3h4x16(:,214),heltab2x64(:,:,412))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(95),m3h4x16(:,215),heltab2x64(:,:,413))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,3),G1H16(96),m3h4x16(:,216),heltab2x64(:,:,414))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(97),m3h4x16(:,217),heltab2x64(:,:,415))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,3),G1H16(98),m3h4x16(:,218),heltab2x64(:,:,416))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(99),m3h4x16(:,219),heltab2x64(:,:,417))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(100),m3h4x16(:,220),heltab2x64(:,:,418))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(101),m3h4x16(:,221),heltab2x64(:,:,419))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(102),m3h4x16(:,222),heltab2x64(:,:,420))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(12),m3h4x16(:,223),heltab2x64(:,:,421))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(11),m3h4x16(:,224),heltab2x64(:,:,422))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(16),m3h4x16(:,225),heltab2x64(:,:,423))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(19),m3h4x16(:,226),heltab2x64(:,:,424))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(433),h0tab(:,433),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(24),m3h4x16(:,227),heltab2x64(:,:,425))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(434),h0tab(:,434),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(23),m3h4x16(:,228),heltab2x64(:,:,426))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(435),h0tab(:,435),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(13),m3h4x16(:,229),heltab2x64(:,:,427))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(436),h0tab(:,436),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(9),m3h4x16(:,230),heltab2x64(:,:,428))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(437),h0tab(:,437),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(103),m3h4x16(:,231),heltab2x64(:,:,429))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(438),h0tab(:,438),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(104),m3h4x16(:,232),heltab2x64(:,:,430))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(439),h0tab(:,439),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(105),m3h4x16(:,233),heltab2x64(:,:,431))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(440),h0tab(:,440),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(106),m3h4x16(:,234),heltab2x64(:,:,432))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(441),h0tab(:,441),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(107),m3h4x16(:,235),heltab2x64(:,:,433))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(442),h0tab(:,442),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(108),m3h4x16(:,236),heltab2x64(:,:,434))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(443),h0tab(:,443),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(109),m3h4x16(:,237),heltab2x64(:,:,435))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(444),h0tab(:,444),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(110),m3h4x16(:,238),heltab2x64(:,:,436))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(445),h0tab(:,445),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(8),m3h4x16(:,239),heltab2x64(:,:,437))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(446),h0tab(:,446),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(26),m3h4x16(:,240),heltab2x64(:,:,438))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(447),h0tab(:,447),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(27),m3h4x16(:,241),heltab2x64(:,:,439))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(448),h0tab(:,448),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(28),m3h4x16(:,242),heltab2x64(:,:,440))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(449),h0tab(:,449),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(29),m3h4x16(:,243),heltab2x64(:,:,441))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(450),h0tab(:,450),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,7),wf4(:,5),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(30),m3h4x16(:,244),heltab2x64(:,:,442))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(451),h0tab(:,451),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(31),m3h4x16(:,245),heltab2x64(:,:,443))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(452),h0tab(:,452),[48,6,9],[nMW,nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(32),m3h4x16(:,246),heltab2x64(:,:,444))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(453),h0tab(:,453),[32,6,25],[0,0,0],3,2,wf4(:,5),wf8(:,15))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,137),heltab2x64(:,:,445))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(13),n2h32(29))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(454),h0tab(:,454),[32,6,25],[0,0,nMZ],3,2,wf4(:,5),wf8(:,15))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),ngZu,m3h2x32(:,138),heltab2x64(:,:,446))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(14),n2h32(30))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(455),h0tab(:,455),[32,6,25],[0,0,nMW],3,2,wf4(:,5),wf8(:,15))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,139),heltab2x64(:,:,447))
  call Hloop_A_Q(ntryL,G0H32(11),32,0,G1H32(15),n2h32(31))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(456),h0tab(:,456),[32,6,25],[nMW,nMW,0],3,2,wf4(:,5),wf8(:,15))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,140),heltab2x64(:,:,448))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(457),h0tab(:,457),[41,6,16],[0,0,0],3,2,wf8(:,46),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(17),m3h8x8(:,51),heltab2x64(:,:,449))
  call Hloop_A_Q(ntryL,G0H8(17),41,0,G1H8(17),n2h8(80))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(458),h0tab(:,458),[41,6,16],[0,0,nMZ],3,2,wf8(:,46),wf4(:,5))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(18),ngZu,m3h8x8(:,52),heltab2x64(:,:,450))
  call Hloop_A_Q(ntryL,G0H8(18),41,0,G1H8(18),n2h8(81))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(459),h0tab(:,459),[41,6,16],[0,0,nMW],3,2,wf8(:,46),wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(19),m3h8x8(:,53),heltab2x64(:,:,451))
  call Hloop_A_Q(ntryL,G0H8(19),41,0,G1H8(20),n2h8(82))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(460),h0tab(:,460),[41,6,16],[nMW,nMW,0],3,2,wf8(:,46),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,46),G0H8(20),m3h8x8(:,54),heltab2x64(:,:,452))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(461),h0tab(:,461),[32,9,22],[0,0,0],3,2,wf4(:,4),wf8(:,18))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,141),heltab2x64(:,:,453))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(16),n2h32(32))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(462),h0tab(:,462),[32,9,22],[0,0,nMZ],3,2,wf4(:,4),wf8(:,18))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(26),ngZu,m3h2x32(:,142),heltab2x64(:,:,454))
  call Hloop_A_Q(ntryL,G0H32(26),32,0,G1H32(17),n2h32(33))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(463),h0tab(:,463),[32,9,22],[0,0,nMW],3,2,wf4(:,4),wf8(:,18))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,143),heltab2x64(:,:,455))
  call Hloop_A_Q(ntryL,G0H32(30),32,0,G1H32(18),n2h32(34))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(464),h0tab(:,464),[32,9,22],[nMW,nMW,0],3,2,wf4(:,4),wf8(:,18))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,144),heltab2x64(:,:,456))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(465),h0tab(:,465),[38,9,16],[0,0,0],3,2,wf8(:,48),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,48),G0H8(21),m3h8x8(:,55),heltab2x64(:,:,457))
  call Hloop_A_Q(ntryL,G0H8(21),38,0,G1H8(48),n2h8(83))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(466),h0tab(:,466),[38,9,16],[0,0,nMZ],3,2,wf8(:,48),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,48),G0H8(22),ngZu,m3h8x8(:,56),heltab2x64(:,:,458))
  call Hloop_A_Q(ntryL,G0H8(22),38,0,G1H8(49),n2h8(84))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(467),h0tab(:,467),[38,9,16],[0,0,nMW],3,2,wf8(:,48),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,48),G0H8(23),m3h8x8(:,57),heltab2x64(:,:,459))
  call Hloop_A_Q(ntryL,G0H8(23),38,0,G1H8(19),n2h8(85))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(468),h0tab(:,468),[38,9,16],[nMW,nMW,0],3,2,wf8(:,48),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,48),G0H8(24),m3h8x8(:,58),heltab2x64(:,:,460))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(169)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(469),h0tab(:,469),[32,15,16],[nMZ,nMZ,0],3,1,wf16(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZu,m3h2x32(:,145),heltab2x64(:,:,461))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(169)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(470),h0tab(:,470),[32,15,16],[nMW,nMW,0],3,1,wf16(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,146),heltab2x64(:,:,462))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(471),h0tab(:,471),[48,7,8],[0,nMW,0],3,2,wf4(:,7),wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(33),m3h4x16(:,247),heltab2x64(:,:,463))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(111),n2h16(177))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(472),h0tab(:,472),[48,7,8],[0,nMZ,0],3,2,wf4(:,3),wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZn,m3h4x16(:,248),heltab2x64(:,:,464))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(112),n2h16(178))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(473),h0tab(:,473),[48,7,8],[0,nMW,0],3,2,wf4(:,3),wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZl,m3h4x16(:,249),heltab2x64(:,:,465))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(113),n2h16(179))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(474),h0tab(:,474),[48,7,8],[nMW,0,nMW],3,2,wf4(:,7),wf8(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(114),m3h4x16(:,250),heltab2x64(:,:,466))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(475),h0tab(:,475),[48,7,8],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(115),m3h4x16(:,251),heltab2x64(:,:,467))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(476),h0tab(:,476),[49,6,8],[0,0,nMZ],3,2,wf8(:,23),wf4(:,5))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,23),G0H8(25),ngZn,m3h8x8(:,59),heltab2x64(:,:,468))
  call Hloop_Q_A(ntryL,G0H8(25),49,0,G1H8(50),n2h8(86))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(477),h0tab(:,477),[49,6,8],[0,0,nMW],3,2,wf8(:,23),wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,23),G0H8(26),m3h8x8(:,60),heltab2x64(:,:,469))
  call Hloop_Q_A(ntryL,G0H8(26),49,0,G1H8(52),n2h8(87))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(478),h0tab(:,478),[49,6,8],[nMW,nMW,0],3,2,wf8(:,23),wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,23),G0H8(27),m3h8x8(:,61),heltab2x64(:,:,470))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(479),h0tab(:,479),[48,1,14],[0,nMW,0],3,2,wf4(:,7),wf8(:,85))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(33),m3h4x16(:,252),heltab2x64(:,:,471))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(116),n2h16(180))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(480),h0tab(:,480),[48,1,14],[0,nMZ,0],3,2,wf4(:,3),wf8(:,85))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZn,m3h4x16(:,253),heltab2x64(:,:,472))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(117),n2h16(181))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(481),h0tab(:,481),[48,1,14],[0,nMW,0],3,2,wf4(:,3),wf8(:,85))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZl,m3h4x16(:,254),heltab2x64(:,:,473))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(118),n2h16(182))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(482),h0tab(:,482),[48,1,14],[nMW,0,nMW],3,2,wf4(:,7),wf8(:,85))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(119),m3h4x16(:,255),heltab2x64(:,:,474))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(483),h0tab(:,483),[48,1,14],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,85))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(120),m3h4x16(:,256),heltab2x64(:,:,475))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(484),h0tab(:,484),[56,1,6],[nMZ,0,0],3,2,wf8(:,61),wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,61),G0H8(28),ngZn,m3h8x8(:,62),heltab2x64(:,:,476))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(485),h0tab(:,485),[56,1,6],[nMW,0,0],3,2,wf8(:,61),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,61),G0H8(29),m3h8x8(:,63),heltab2x64(:,:,477))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(486),h0tab(:,486),[56,1,6],[0,nMW,nMW],3,2,wf8(:,61),wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,61),G0H8(1),m3h8x8(:,64),heltab2x64(:,:,478))
  call Hloop_A_Q(ntryL,G0H8(1),56,0,G1H8(53),n2h8(88))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(172)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(487),h0tab(:,487),[54,1,8],[nMZ,0,nMZ],3,1,wf16(:,10))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,10),G0H4(11),m3h16x4(:,13),heltab2x64(:,:,479))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(172)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(488),h0tab(:,488),[54,1,8],[nMW,0,nMW],3,1,wf16(:,10))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,10),G0H4(12),m3h16x4(:,14),heltab2x64(:,:,480))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(489),h0tab(:,489),[32,15,16],[0,0,0],3,1,wf16(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,147),heltab2x64(:,:,481))
  call Hloop_A_Q(ntryL,G0H32(31),32,0,G1H32(19),n2h32(35))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(490),h0tab(:,490),[32,15,16],[0,0,nMZ],3,1,wf16(:,11))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(32),ngZu,m3h2x32(:,148),heltab2x64(:,:,482))
  call Hloop_A_Q(ntryL,G0H32(32),32,0,G1H32(20),n2h32(36))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(491),h0tab(:,491),[32,15,16],[0,0,nMW],3,1,wf16(:,11))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,149),heltab2x64(:,:,483))
  call Hloop_A_Q(ntryL,G0H32(33),32,0,G1H32(21),n2h32(37))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(492),h0tab(:,492),[32,15,16],[nMW,nMW,0],3,1,wf16(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,150),heltab2x64(:,:,484))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(493),h0tab(:,493),[32,15,16],[0,0,0],3,1,wf16(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,151),heltab2x64(:,:,485))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(22),n2h32(38))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(494),h0tab(:,494),[32,15,16],[0,0,nMZ],3,1,wf16(:,12))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(36),ngZu,m3h2x32(:,152),heltab2x64(:,:,486))
  call Hloop_A_Q(ntryL,G0H32(36),32,0,G1H32(23),n2h32(39))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(495),h0tab(:,495),[32,15,16],[0,0,nMW],3,1,wf16(:,12))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,153),heltab2x64(:,:,487))
  call Hloop_A_Q(ntryL,G0H32(37),32,0,G1H32(24),n2h32(40))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(496),h0tab(:,496),[32,15,16],[nMW,nMW,0],3,1,wf16(:,12))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,154),heltab2x64(:,:,488))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(497),h0tab(:,497),[54,1,8],[0,nMW,0],3,1,wf16(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,13),G0H4(13),m3h16x4(:,15),heltab2x64(:,:,489))
  call Hloop_A_Q(ntryL,G0H4(13),54,0,G1H4(85),n2h4(127))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(498),h0tab(:,498),[54,1,8],[0,nMZ,0],3,1,wf16(:,14))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,14),G0H4(13),ngZn,m3h16x4(:,16),heltab2x64(:,:,490))
  call Hloop_A_Q(ntryL,G0H4(13),54,0,G1H4(88),n2h4(128))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(499),h0tab(:,499),[54,1,8],[0,nMW,0],3,1,wf16(:,14))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,14),G0H4(13),ngZl,m3h16x4(:,17),heltab2x64(:,:,491))
  call Hloop_A_Q(ntryL,G0H4(13),54,0,G1H4(89),n2h4(129))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(500),h0tab(:,500),[54,1,8],[nMW,0,nMW],3,1,wf16(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,13),54,G1H4(90),m3h16x4(:,18),heltab2x64(:,:,492))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(501),h0tab(:,501),[54,1,8],[nMW,0,nMW],3,1,wf16(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,14),54,G1H4(28),m3h16x4(:,19),heltab2x64(:,:,493))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(502),h0tab(:,502),[54,1,8],[0,nMW,0],3,1,wf16(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,15),G0H4(13),m3h16x4(:,20),heltab2x64(:,:,494))
  call Hloop_A_Q(ntryL,G0H4(13),54,0,G1H4(8),n2h4(130))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(503),h0tab(:,503),[54,1,8],[0,nMZ,0],3,1,wf16(:,16))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,16),G0H4(13),ngZn,m3h16x4(:,21),heltab2x64(:,:,495))
  call Hloop_A_Q(ntryL,G0H4(13),54,0,G1H4(11),n2h4(131))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(504),h0tab(:,504),[54,1,8],[0,nMW,0],3,1,wf16(:,16))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,16),G0H4(13),ngZl,m3h16x4(:,22),heltab2x64(:,:,496))
  call Hloop_A_Q(ntryL,G0H4(13),54,0,G1H4(48),n2h4(132))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(505),h0tab(:,505),[54,1,8],[nMW,0,nMW],3,1,wf16(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,15),54,G1H4(40),m3h16x4(:,23),heltab2x64(:,:,497))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(506),h0tab(:,506),[54,1,8],[nMW,0,nMW],3,1,wf16(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,16),54,G1H4(52),m3h16x4(:,24),heltab2x64(:,:,498))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(507),h0tab(:,507),[48,4,11],[0,nMW,0],3,2,wf4(:,7),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(33),m3h4x16(:,257),heltab2x64(:,:,499))
  call Hloop_Q_A(ntryL,G0H16(33),48,0,G1H16(121),n2h16(183))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(508),h0tab(:,508),[48,4,11],[0,nMZ,0],3,2,wf4(:,3),wf8(:,26))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZn,m3h4x16(:,258),heltab2x64(:,:,500))
  call Hloop_Q_A(ntryL,G0H16(33),48,0,G1H16(122),n2h16(184))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(509),h0tab(:,509),[48,4,11],[0,nMW,0],3,2,wf4(:,3),wf8(:,26))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZl,m3h4x16(:,259),heltab2x64(:,:,501))
  call Hloop_Q_A(ntryL,G0H16(33),48,0,G1H16(123),n2h16(185))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(510),h0tab(:,510),[48,4,11],[nMW,0,nMW],3,2,wf4(:,7),wf8(:,26))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(124),m3h4x16(:,260),heltab2x64(:,:,502))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(511),h0tab(:,511),[48,4,11],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,26))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(125),m3h4x16(:,261),heltab2x64(:,:,503))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(512),h0tab(:,512),[48,2,13],[0,nMW,0],3,2,wf4(:,7),wf8(:,68))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(33),m3h4x16(:,262),heltab2x64(:,:,504))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(126),n2h16(186))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(513),h0tab(:,513),[48,2,13],[0,nMZ,0],3,2,wf4(:,3),wf8(:,68))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZn,m3h4x16(:,263),heltab2x64(:,:,505))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(127),n2h16(187))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(514),h0tab(:,514),[48,2,13],[0,nMW,0],3,2,wf4(:,3),wf8(:,68))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZl,m3h4x16(:,264),heltab2x64(:,:,506))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(128),n2h16(188))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(515),h0tab(:,515),[48,2,13],[nMW,0,nMW],3,2,wf4(:,7),wf8(:,68))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(129),m3h4x16(:,265),heltab2x64(:,:,507))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(516),h0tab(:,516),[48,2,13],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,68))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(130),m3h4x16(:,266),heltab2x64(:,:,508))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(517),h0tab(:,517),[50,4,9],[nMZ,0,0],3,2,wf8(:,12),wf4(:,4))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,12),G0H8(2),ngZn,m3h8x8(:,65),heltab2x64(:,:,509))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(518),h0tab(:,518),[50,4,9],[nMW,0,0],3,2,wf8(:,12),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,12),G0H8(3),m3h8x8(:,66),heltab2x64(:,:,510))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(519),h0tab(:,519),[50,4,9],[0,nMW,nMW],3,2,wf8(:,12),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,12),G0H8(7),m3h8x8(:,67),heltab2x64(:,:,511))
  call Hloop_Q_A(ntryL,G0H8(7),50,0,G1H8(54),n2h8(89))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(520),h0tab(:,520),[52,2,9],[nMZ,0,0],3,2,wf8(:,70),wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,70),G0H8(8),ngZn,m3h8x8(:,68),heltab2x64(:,:,512))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(521),h0tab(:,521),[52,2,9],[nMW,0,0],3,2,wf8(:,70),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,70),G0H8(9),m3h8x8(:,69),heltab2x64(:,:,513))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(522),h0tab(:,522),[52,2,9],[0,nMW,nMW],3,2,wf8(:,70),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,70),G0H8(4),m3h8x8(:,70),heltab2x64(:,:,514))
  call Hloop_A_Q(ntryL,G0H8(4),52,0,G1H8(55),n2h8(90))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(183)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(523),h0tab(:,523),[57,2,4],[nMZ,0,nMZ],3,1,wf16(:,17))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,17),G0H4(13),m3h16x4(:,25),heltab2x64(:,:,515))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(183)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(524),h0tab(:,524),[57,2,4],[nMW,0,nMW],3,1,wf16(:,17))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,17),G0H4(14),m3h16x4(:,26),heltab2x64(:,:,516))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(525),h0tab(:,525),[32,15,16],[0,0,0],3,1,wf16(:,18))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,155),heltab2x64(:,:,517))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(25),n2h32(41))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(526),h0tab(:,526),[32,15,16],[0,0,nMZ],3,1,wf16(:,18))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(40),ngZu,m3h2x32(:,156),heltab2x64(:,:,518))
  call Hloop_A_Q(ntryL,G0H32(40),32,0,G1H32(26),n2h32(42))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(527),h0tab(:,527),[32,15,16],[0,0,nMW],3,1,wf16(:,18))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,157),heltab2x64(:,:,519))
  call Hloop_A_Q(ntryL,G0H32(41),32,0,G1H32(27),n2h32(43))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(528),h0tab(:,528),[32,15,16],[nMW,nMW,0],3,1,wf16(:,18))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,158),heltab2x64(:,:,520))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(529),h0tab(:,529),[32,15,16],[0,0,0],3,1,wf16(:,19))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,159),heltab2x64(:,:,521))
  call Hloop_A_Q(ntryL,G0H32(43),32,0,G1H32(28),n2h32(44))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(530),h0tab(:,530),[32,15,16],[0,0,nMZ],3,1,wf16(:,19))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),ngZu,m3h2x32(:,160),heltab2x64(:,:,522))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(29),n2h32(45))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(531),h0tab(:,531),[32,15,16],[0,0,nMW],3,1,wf16(:,19))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,161),heltab2x64(:,:,523))
  call Hloop_A_Q(ntryL,G0H32(45),32,0,G1H32(30),n2h32(46))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(532),h0tab(:,532),[32,15,16],[nMW,nMW,0],3,1,wf16(:,19))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,162),heltab2x64(:,:,524))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(533),h0tab(:,533),[57,2,4],[0,nMW,0],3,1,wf16(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,20),G0H4(15),m3h16x4(:,27),heltab2x64(:,:,525))
  call Hloop_A_Q(ntryL,G0H4(15),57,0,G1H4(5),n2h4(133))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(189)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(534),h0tab(:,534),[57,2,4],[0,nMZ,0],3,1,wf16(:,21))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,21),G0H4(15),ngZn,m3h16x4(:,28),heltab2x64(:,:,526))
  call Hloop_A_Q(ntryL,G0H4(15),57,0,G1H4(6),n2h4(134))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(189)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(535),h0tab(:,535),[57,2,4],[0,nMW,0],3,1,wf16(:,21))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,21),G0H4(15),ngZl,m3h16x4(:,29),heltab2x64(:,:,527))
  call Hloop_A_Q(ntryL,G0H4(15),57,0,G1H4(7),n2h4(135))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(536),h0tab(:,536),[57,2,4],[nMW,0,nMW],3,1,wf16(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,20),57,G1H4(17),m3h16x4(:,30),heltab2x64(:,:,528))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(189)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(537),h0tab(:,537),[57,2,4],[nMW,0,nMW],3,1,wf16(:,21))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,21),57,G1H4(23),m3h16x4(:,31),heltab2x64(:,:,529))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(538),h0tab(:,538),[57,2,4],[0,nMW,0],3,1,wf16(:,22))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,22),G0H4(15),m3h16x4(:,32),heltab2x64(:,:,530))
  call Hloop_A_Q(ntryL,G0H4(15),57,0,G1H4(24),n2h4(136))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(539),h0tab(:,539),[57,2,4],[0,nMZ,0],3,1,wf16(:,23))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,23),G0H4(15),ngZn,m3h16x4(:,33),heltab2x64(:,:,531))
  call Hloop_A_Q(ntryL,G0H4(15),57,0,G1H4(32),n2h4(137))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(540),h0tab(:,540),[57,2,4],[0,nMW,0],3,1,wf16(:,23))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,23),G0H4(15),ngZl,m3h16x4(:,34),heltab2x64(:,:,532))
  call Hloop_A_Q(ntryL,G0H4(15),57,0,G1H4(35),n2h4(138))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(541),h0tab(:,541),[57,2,4],[nMW,0,nMW],3,1,wf16(:,22))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,22),57,G1H4(39),m3h16x4(:,35),heltab2x64(:,:,533))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(542),h0tab(:,542),[57,2,4],[nMW,0,nMW],3,1,wf16(:,23))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,23),57,G1H4(45),m3h16x4(:,36),heltab2x64(:,:,534))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(543),h0tab(:,543),[48,4,11],[0,nMW,0],3,2,wf4(:,7),wf8(:,29))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(33),m3h4x16(:,267),heltab2x64(:,:,535))
  call Hloop_Q_A(ntryL,G0H16(33),48,0,G1H16(131),n2h16(189))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(544),h0tab(:,544),[48,4,11],[0,nMZ,0],3,2,wf4(:,3),wf8(:,29))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZn,m3h4x16(:,268),heltab2x64(:,:,536))
  call Hloop_Q_A(ntryL,G0H16(33),48,0,G1H16(132),n2h16(190))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(545),h0tab(:,545),[48,4,11],[0,nMW,0],3,2,wf4(:,3),wf8(:,29))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZl,m3h4x16(:,269),heltab2x64(:,:,537))
  call Hloop_Q_A(ntryL,G0H16(33),48,0,G1H16(133),n2h16(191))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(546),h0tab(:,546),[48,4,11],[nMW,0,nMW],3,2,wf4(:,7),wf8(:,29))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(134),m3h4x16(:,270),heltab2x64(:,:,538))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(547),h0tab(:,547),[48,4,11],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,29))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(135),m3h4x16(:,271),heltab2x64(:,:,539))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(548),h0tab(:,548),[49,4,10],[nMZ,0,0],3,2,wf8(:,23),wf4(:,2))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,23),G0H8(5),ngZn,m3h8x8(:,71),heltab2x64(:,:,540))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(549),h0tab(:,549),[49,4,10],[nMW,0,0],3,2,wf8(:,23),wf4(:,2))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,23),G0H8(6),m3h8x8(:,72),heltab2x64(:,:,541))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(550),h0tab(:,550),[49,4,10],[0,nMW,nMW],3,2,wf8(:,23),wf4(:,2))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,23),G0H8(11),m3h8x8(:,73),heltab2x64(:,:,542))
  call Hloop_Q_A(ntryL,G0H8(11),49,0,G1H8(57),n2h8(91))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(551),h0tab(:,551),[48,1,14],[0,nMW,0],3,2,wf4(:,7),wf8(:,94))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(33),m3h4x16(:,272),heltab2x64(:,:,543))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(136),n2h16(192))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(552),h0tab(:,552),[48,1,14],[0,nMZ,0],3,2,wf4(:,3),wf8(:,94))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZn,m3h4x16(:,273),heltab2x64(:,:,544))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(137),n2h16(193))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(553),h0tab(:,553),[48,1,14],[0,nMW,0],3,2,wf4(:,3),wf8(:,94))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,3),G0H16(33),ngZl,m3h4x16(:,274),heltab2x64(:,:,545))
  call Hloop_A_Q(ntryL,G0H16(33),48,0,G1H16(138),n2h16(194))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(554),h0tab(:,554),[48,1,14],[nMW,0,nMW],3,2,wf4(:,7),wf8(:,94))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(139),m3h4x16(:,275),heltab2x64(:,:,546))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(555),h0tab(:,555),[48,1,14],[nMW,0,nMW],3,2,wf4(:,3),wf8(:,94))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(140),m3h4x16(:,276),heltab2x64(:,:,547))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(556),h0tab(:,556),[52,1,10],[nMZ,0,0],3,2,wf8(:,70),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,70),G0H8(12),ngZn,m3h8x8(:,74),heltab2x64(:,:,548))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(557),h0tab(:,557),[52,1,10],[nMW,0,0],3,2,wf8(:,70),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,70),G0H8(16),m3h8x8(:,75),heltab2x64(:,:,549))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(558),h0tab(:,558),[52,1,10],[0,nMW,nMW],3,2,wf8(:,70),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,70),G0H8(17),m3h8x8(:,76),heltab2x64(:,:,550))
  call Hloop_A_Q(ntryL,G0H8(17),52,0,G1H8(58),n2h8(92))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(559),h0tab(:,559),[58,1,4],[nMZ,0,nMZ],3,1,wf16(:,24))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,24),G0H4(15),m3h16x4(:,37),heltab2x64(:,:,551))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(560),h0tab(:,560),[58,1,4],[nMW,0,nMW],3,1,wf16(:,24))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,24),G0H4(16),m3h16x4(:,38),heltab2x64(:,:,552))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(561),h0tab(:,561),[32,15,16],[0,0,0],3,1,wf16(:,25))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,163),heltab2x64(:,:,553))
  call Hloop_A_Q(ntryL,G0H32(47),32,0,G1H32(31),n2h32(47))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(562),h0tab(:,562),[32,15,16],[0,0,nMZ],3,1,wf16(:,25))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(48),ngZu,m3h2x32(:,164),heltab2x64(:,:,554))
  call Hloop_A_Q(ntryL,G0H32(48),32,0,G1H32(32),n2h32(48))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(563),h0tab(:,563),[32,15,16],[0,0,nMW],3,1,wf16(:,25))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,165),heltab2x64(:,:,555))
  call Hloop_A_Q(ntryL,G0H32(49),32,0,G1H32(33),n2h32(49))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(564),h0tab(:,564),[32,15,16],[nMW,nMW,0],3,1,wf16(:,25))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,166),heltab2x64(:,:,556))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(565),h0tab(:,565),[32,15,16],[0,0,0],3,1,wf16(:,26))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,167),heltab2x64(:,:,557))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(34),n2h32(50))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(566),h0tab(:,566),[32,15,16],[0,0,nMZ],3,1,wf16(:,26))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(12),ngZu,m3h2x32(:,168),heltab2x64(:,:,558))
  call Hloop_A_Q(ntryL,G0H32(12),32,0,G1H32(35),n2h32(51))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(567),h0tab(:,567),[32,15,16],[0,0,nMW],3,1,wf16(:,26))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,169),heltab2x64(:,:,559))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(36),n2h32(52))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(568),h0tab(:,568),[32,15,16],[nMW,nMW,0],3,1,wf16(:,26))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,170),heltab2x64(:,:,560))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(569),h0tab(:,569),[58,1,4],[0,nMW,0],3,1,wf16(:,27))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,27),G0H4(17),m3h16x4(:,39),heltab2x64(:,:,561))
  call Hloop_A_Q(ntryL,G0H4(17),58,0,G1H4(47),n2h4(139))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(570),h0tab(:,570),[58,1,4],[0,nMZ,0],3,1,wf16(:,28))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,28),G0H4(17),ngZn,m3h16x4(:,40),heltab2x64(:,:,562))
  call Hloop_A_Q(ntryL,G0H4(17),58,0,G1H4(51),n2h4(140))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(571),h0tab(:,571),[58,1,4],[0,nMW,0],3,1,wf16(:,28))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,28),G0H4(17),ngZl,m3h16x4(:,41),heltab2x64(:,:,563))
  call Hloop_A_Q(ntryL,G0H4(17),58,0,G1H4(64),n2h4(141))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(572),h0tab(:,572),[58,1,4],[nMW,0,nMW],3,1,wf16(:,27))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,27),58,G1H4(59),m3h16x4(:,42),heltab2x64(:,:,564))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(573),h0tab(:,573),[58,1,4],[nMW,0,nMW],3,1,wf16(:,28))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,28),58,G1H4(63),m3h16x4(:,43),heltab2x64(:,:,565))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(574),h0tab(:,574),[58,1,4],[0,nMW,0],3,1,wf16(:,29))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,29),G0H4(17),m3h16x4(:,44),heltab2x64(:,:,566))
  call Hloop_A_Q(ntryL,G0H4(17),58,0,G1H4(71),n2h4(142))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(575),h0tab(:,575),[58,1,4],[0,nMZ,0],3,1,wf16(:,30))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,30),G0H4(17),ngZn,m3h16x4(:,45),heltab2x64(:,:,567))
  call Hloop_A_Q(ntryL,G0H4(17),58,0,G1H4(10),n2h4(143))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(576),h0tab(:,576),[58,1,4],[0,nMW,0],3,1,wf16(:,30))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,30),G0H4(17),ngZl,m3h16x4(:,46),heltab2x64(:,:,568))
  call Hloop_A_Q(ntryL,G0H4(17),58,0,G1H4(76),n2h4(144))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(577),h0tab(:,577),[58,1,4],[nMW,0,nMW],3,1,wf16(:,29))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,29),58,G1H4(9),m3h16x4(:,47),heltab2x64(:,:,569))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(578),h0tab(:,578),[58,1,4],[nMW,0,nMW],3,1,wf16(:,30))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,30),58,G1H4(30),m3h16x4(:,48),heltab2x64(:,:,570))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(579),h0tab(:,579),[53,2,8],[0,nMZ,0],3,1,wf16(:,31))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,31),G0H4(17),ngZn,m3h16x4(:,49),heltab2x64(:,:,571))
  call Hloop_A_Q(ntryL,G0H4(17),53,0,G1H4(91),n2h4(145))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(580),h0tab(:,580),[53,2,8],[0,nMW,0],3,1,wf16(:,31))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,31),G0H4(17),ngZl,m3h16x4(:,50),heltab2x64(:,:,572))
  call Hloop_A_Q(ntryL,G0H4(17),53,0,G1H4(94),n2h4(146))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(581),h0tab(:,581),[53,2,8],[nMW,0,nMW],3,1,wf16(:,31))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,31),53,G1H4(95),m3h16x4(:,51),heltab2x64(:,:,573))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(582),h0tab(:,582),[53,2,8],[0,nMZ,0],3,1,wf16(:,32))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,32),G0H4(17),ngZn,m3h16x4(:,52),heltab2x64(:,:,574))
  call Hloop_A_Q(ntryL,G0H4(17),53,0,G1H4(96),n2h4(147))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(583),h0tab(:,583),[53,2,8],[0,nMW,0],3,1,wf16(:,32))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,32),G0H4(17),ngZl,m3h16x4(:,53),heltab2x64(:,:,575))
  call Hloop_A_Q(ntryL,G0H4(17),53,0,G1H4(99),n2h4(148))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(584),h0tab(:,584),[53,2,8],[nMW,0,nMW],3,1,wf16(:,32))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,32),53,G1H4(18),m3h16x4(:,54),heltab2x64(:,:,576))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(585),h0tab(:,585),[57,2,4],[0,nMZ,0],3,1,wf16(:,33))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,33),G0H4(17),ngZn,m3h16x4(:,55),heltab2x64(:,:,577))
  call Hloop_A_Q(ntryL,G0H4(17),57,0,G1H4(19),n2h4(149))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(586),h0tab(:,586),[57,2,4],[0,nMW,0],3,1,wf16(:,33))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,33),G0H4(17),ngZl,m3h16x4(:,56),heltab2x64(:,:,578))
  call Hloop_A_Q(ntryL,G0H4(17),57,0,G1H4(102),n2h4(150))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(587),h0tab(:,587),[57,2,4],[nMW,0,nMW],3,1,wf16(:,33))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,33),57,G1H4(103),m3h16x4(:,57),heltab2x64(:,:,579))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(588),h0tab(:,588),[57,2,4],[0,nMZ,0],3,1,wf16(:,34))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,34),G0H4(17),ngZn,m3h16x4(:,58),heltab2x64(:,:,580))
  call Hloop_A_Q(ntryL,G0H4(17),57,0,G1H4(104),n2h4(151))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(589),h0tab(:,589),[57,2,4],[0,nMW,0],3,1,wf16(:,34))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,34),G0H4(17),ngZl,m3h16x4(:,59),heltab2x64(:,:,581))
  call Hloop_A_Q(ntryL,G0H4(17),57,0,G1H4(107),n2h4(152))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(590),h0tab(:,590),[57,2,4],[nMW,0,nMW],3,1,wf16(:,34))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,34),57,G1H4(108),m3h16x4(:,60),heltab2x64(:,:,582))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(591),h0tab(:,591),[54,1,8],[0,nMZ,0],3,1,wf16(:,35))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,35),G0H4(17),ngZn,m3h16x4(:,61),heltab2x64(:,:,583))
  call Hloop_A_Q(ntryL,G0H4(17),54,0,G1H4(109),n2h4(153))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(592),h0tab(:,592),[54,1,8],[0,nMW,0],3,1,wf16(:,35))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,35),G0H4(17),ngZl,m3h16x4(:,62),heltab2x64(:,:,584))
  call Hloop_A_Q(ntryL,G0H4(17),54,0,G1H4(112),n2h4(154))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(593),h0tab(:,593),[54,1,8],[nMW,0,nMW],3,1,wf16(:,35))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,35),54,G1H4(22),m3h16x4(:,63),heltab2x64(:,:,585))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(594),h0tab(:,594),[54,1,8],[0,nMZ,0],3,1,wf16(:,36))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,36),G0H4(17),ngZn,m3h16x4(:,64),heltab2x64(:,:,586))
  call Hloop_A_Q(ntryL,G0H4(17),54,0,G1H4(2),n2h4(155))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(595),h0tab(:,595),[54,1,8],[0,nMW,0],3,1,wf16(:,36))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,36),G0H4(17),ngZl,m3h16x4(:,65),heltab2x64(:,:,587))
  call Hloop_A_Q(ntryL,G0H4(17),54,0,G1H4(115),n2h4(156))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(596),h0tab(:,596),[54,1,8],[nMW,0,nMW],3,1,wf16(:,36))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,36),54,G1H4(116),m3h16x4(:,66),heltab2x64(:,:,588))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(597),h0tab(:,597),[58,1,4],[0,nMZ,0],3,1,wf16(:,37))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,37),G0H4(17),ngZn,m3h16x4(:,67),heltab2x64(:,:,589))
  call Hloop_A_Q(ntryL,G0H4(17),58,0,G1H4(117),n2h4(157))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(598),h0tab(:,598),[58,1,4],[0,nMW,0],3,1,wf16(:,37))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,37),G0H4(17),ngZl,m3h16x4(:,68),heltab2x64(:,:,590))
  call Hloop_A_Q(ntryL,G0H4(17),58,0,G1H4(120),n2h4(158))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(599),h0tab(:,599),[58,1,4],[nMW,0,nMW],3,1,wf16(:,37))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,37),58,G1H4(121),m3h16x4(:,69),heltab2x64(:,:,591))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(600),h0tab(:,600),[58,1,4],[0,nMZ,0],3,1,wf16(:,38))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,38),G0H4(17),ngZn,m3h16x4(:,70),heltab2x64(:,:,592))
  call Hloop_A_Q(ntryL,G0H4(17),58,0,G1H4(122),n2h4(159))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(601),h0tab(:,601),[58,1,4],[0,nMW,0],3,1,wf16(:,38))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,38),G0H4(17),ngZl,m3h16x4(:,71),heltab2x64(:,:,593))
  call Hloop_A_Q(ntryL,G0H4(17),58,0,G1H4(125),n2h4(160))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(602),h0tab(:,602),[58,1,4],[nMW,0,nMW],3,1,wf16(:,38))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,38),58,G1H4(42),m3h16x4(:,72),heltab2x64(:,:,594))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(22),G1H4(52),G1H4(40),G1H4(28),G1H4(90) &
    ,G1H4(27),G0H4(12),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(95),G1H4(84),G1H4(83),G1H4(74),G1H4(73) &
    ,G1H4(37),G0H4(10),G0H4(3),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(46),[G1H8(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(48),[G1H8(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(49),[G1H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(52),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(103),G1H4(45),G1H4(39),G1H4(23),G1H4(17) &
    ,G0H4(14),G0H4(6),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(121),G1H4(30),G1H4(9),G1H4(63),G1H4(59) &
    ,G0H4(16),G0H4(8),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(26),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(33),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(40),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(45),[G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(44),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G1H16(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(17),[G1H16(6),G1H16(1),G1H16(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(11),G1H16(4),G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(2),[G0H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(6),[G0H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(18),[G0H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(17),[G0H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(29),G1H16(27),G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(41),[G1H16(39),G1H16(37),G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(1),[G0H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(4),[G0H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(21),[G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(20),[G0H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(48),[G1H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(53),[G1H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(58),[G1H16(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(99),[G1H4(94),G1H4(80),G1H4(78),G1H4(29),G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(91),G1H4(79),G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(75),[G1H16(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(76),[G1H16(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(77),[G1H16(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(78),[G1H16(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(79),[G1H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(80),[G1H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(81),[G1H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(82),[G1H16(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(83),[G1H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(84),[G1H16(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(85),[G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(86),[G1H16(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(89),[G1H16(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(90),[G1H16(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(97),[G1H16(95),G1H16(93),G1H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(98),[G1H16(96),G1H16(94),G1H16(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(101),[G1H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(102),[G1H16(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(16),[G0H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(19),[G0H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(13),[G0H16(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(9),[G0H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(106),[G1H16(105),G1H16(104),G1H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(110),[G1H16(109),G1H16(108),G1H16(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(27),[G0H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(28),[G0H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(31),[G0H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(32),[G0H16(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(113),[G1H16(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(115),[G1H16(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(118),[G1H16(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(120),[G1H16(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(112),G1H4(48),G1H4(8),G1H4(89),G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(109),G1H4(11),G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(123),[G1H16(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(125),[G1H16(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(128),[G1H16(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(130),[G1H16(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(107),[G1H4(102),G1H4(35),G1H4(24),G1H4(7),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(104),[G1H4(19),G1H4(32),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(133),[G1H16(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(135),[G1H16(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(138),[G1H16(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(140),[G1H16(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(120),G1H4(76),G1H4(71),G1H4(64),G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(117),G1H4(10),G1H4(51)])
  call Hloop_WQ_A(ntryL,G1H4(116),ex1(:),G1H2(16),m3h2x2(:,137),heltab2x4(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(16),55,0,G2H2(40),n2h2(95))
  call Hloop_WQ_A(ntryL,G1H4(18),ex2(:),G1H2(103),m3h2x2(:,138),heltab2x4(:,:,272))
  call Hloop_Q_A(ntryL,G1H2(103),55,0,G2H2(43),n2h2(96))
  call Hloop_AZ_Q(ntryL,G1H8(7),wf4(:,1),G1H2(115),ngZu,m3h4x2(:,69),heltab2x8(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(115),47,0,G2H2(46),n2h2(97))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf4(:,1),G1H2(48),ngZu,m3h4x2(:,70),heltab2x8(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(48),47,0,G2H2(49),n2h2(98))
  call Hloop_AZ_Q(ntryL,G1H8(10),wf4(:,1),G1H2(52),ngZd,m3h4x2(:,71),heltab2x8(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(52),47,0,G2H2(34),n2h2(99))
  call Hloop_AZ_Q(ntryL,G1H8(45),wf4(:,2),G1H2(20),ngZu,m3h4x2(:,72),heltab2x8(:,:,222))
  call Hloop_A_Q(ntryL,G1H2(20),47,0,G2H2(37),n2h2(100))
  call Hloop_AZ_Q(ntryL,G1H8(46),wf4(:,2),G1H2(116),ngZu,m3h4x2(:,73),heltab2x8(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(116),47,0,G2H2(63),n2h2(101))
  call Hloop_AZ_Q(ntryL,G1H8(6),wf4(:,2),G1H2(44),ngZd,m3h4x2(:,74),heltab2x8(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(87),n2h2(102))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,1),G1H2(1),ngZl,m3h4x2(:,75),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(84),n2h2(103))
  call Hloop_AZ_Q(ntryL,G1H8(48),wf4(:,4),G1H2(61),ngZu,m3h4x2(:,76),heltab2x8(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(61),47,0,G2H2(90),n2h2(104))
  call Hloop_AZ_Q(ntryL,G1H8(49),wf4(:,4),G1H2(64),ngZu,m3h4x2(:,77),heltab2x8(:,:,227))
  call Hloop_A_Q(ntryL,G1H2(64),47,0,G2H2(18),n2h2(105))
  call Hloop_AZ_Q(ntryL,G1H8(19),wf4(:,4),G1H2(47),ngZd,m3h4x2(:,78),heltab2x8(:,:,228))
  call Hloop_A_Q(ntryL,G1H2(47),47,0,G2H2(8),n2h2(106))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,5),G1H2(49),ngZu,m3h4x2(:,79),heltab2x8(:,:,229))
  call Hloop_A_Q(ntryL,G1H2(49),47,0,G2H2(9),n2h2(107))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,5),G1H2(25),ngZu,m3h4x2(:,80),heltab2x8(:,:,230))
  call Hloop_A_Q(ntryL,G1H2(25),47,0,G2H2(19),n2h2(108))
  call Hloop_AZ_Q(ntryL,G1H8(20),wf4(:,5),G1H2(71),ngZd,m3h4x2(:,81),heltab2x8(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(71),47,0,G2H2(12),n2h2(109))
  call Hloop_QZ_A(ntryL,G1H8(52),wf4(:,5),G1H2(88),ngZl,m3h4x2(:,82),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(88),55,0,G2H2(16),n2h2(110))
  call Hloop_QZ_A(ntryL,G1H8(31),wf4(:,4),G1H2(4),ngZl,m3h4x2(:,83),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(4),59,0,G2H2(20),n2h2(111))
  call Hloop_QZ_A(ntryL,G1H8(39),wf4(:,2),G1H2(70),ngZl,m3h4x2(:,84),heltab2x8(:,:,234))
  call Hloop_Q_A(ntryL,G1H2(70),59,0,G2H2(21),n2h2(112))
  call Hloop_VWW_V(ntryL,G0H32(5),wf4(:,1),wf4(:,2),G0H2(9),m4h4x4x2(:,1),heltab3x32(:,:,1))
  call Hloop_VWW_V(ntryL,G0H32(6),wf4(:,4),wf4(:,5),G0H2(6),m4h4x4x2(:,2),heltab3x32(:,:,2))
  call Hloop_WQ_A(ntryL,G1H4(108),ex2(:),G1H2(12),m3h2x2(:,139),heltab2x4(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(12),59,0,G2H2(2),n2h2(113))
  call Hloop_WQ_A(ntryL,G1H4(42),ex1(:),G1H2(28),m3h2x2(:,140),heltab2x4(:,:,274))
  call Hloop_Q_A(ntryL,G1H2(28),59,0,G2H2(6),n2h2(114))
  call Hloop_AZ_Q(ntryL,G1H16(26),wf4(:,1),G1H4(43),ngZl,m3h4x4(:,23),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(43),53,0,G2H4(3),n2h4(161))
  call Hloop_AZ_Q(ntryL,G1H16(28),wf4(:,1),G1H4(128),ngZl,m3h4x4(:,24),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(128),53,nML,G2H4(4),n2h4(162))
  call Hloop_QZ_A(ntryL,G1H16(31),wf4(:,1),G1H4(22),ngZl,m3h4x4(:,25),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(22),53,0,G2H4(5),n2h4(163))
  call Hloop_QZ_A(ntryL,G1H16(30),wf4(:,1),G1H4(52),ngZl,m3h4x4(:,26),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(52),53,nML,G2H4(6),n2h4(164))
  call Hloop_AZ_Q(ntryL,G1H16(33),wf4(:,1),G1H4(40),ngZu,m3h4x4(:,27),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(40),53,0,G2H4(7),n2h4(165))
  call Hloop_AZ_Q(ntryL,G1H16(36),wf4(:,1),G1H4(28),ngZu,m3h4x4(:,28),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(28),53,nMT,G2H4(8),n2h4(166))
  call Hloop_QZ_A(ntryL,G1H16(35),wf4(:,1),G1H4(90),ngZu,m3h4x4(:,29),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(90),53,0,G2H4(9),n2h4(167))
  call Hloop_QZ_A(ntryL,G1H16(38),wf4(:,1),G1H4(27),ngZu,m3h4x4(:,30),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(27),53,nMT,G2H4(15),n2h4(168))
  call Hloop_AZ_Q(ntryL,G1H16(40),wf4(:,1),G1H4(95),ngZd,m3h4x4(:,31),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(95),53,0,G2H4(12),n2h4(169))
  call Hloop_AZ_Q(ntryL,G1H16(42),wf4(:,1),G1H4(84),ngZd,m3h4x4(:,32),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(84),53,nMB,G2H4(10),n2h4(170))
  call Hloop_QZ_A(ntryL,G1H16(45),wf4(:,1),G1H4(83),ngZd,m3h4x4(:,33),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(83),53,0,G2H4(11),n2h4(171))
  call Hloop_QZ_A(ntryL,G1H16(44),wf4(:,1),G1H4(74),ngZd,m3h4x4(:,34),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(74),53,nMB,G2H4(13),n2h4(172))
  call Hloop_AZ_Q(ntryL,G1H16(15),wf4(:,1),G1H4(73),ngZn,m3h4x4(:,35),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(73),53,0,G2H4(14),n2h4(173))
  call Hloop_QZ_A(ntryL,G1H16(23),wf4(:,1),G1H4(37),ngZn,m3h4x4(:,36),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(37),53,0,G2H4(21),n2h4(174))
  call Hloop_SV_T(ntryL,G1H16(49),48,wf4(:,1),5,G2H4(17),m3h4x4(:,37),heltab2x16(:,:,149))
  call Hloop_TV_S(ntryL,G1H16(52),48,wf4(:,1),5,G2H4(16),m3h4x4(:,38),heltab2x16(:,:,150))
  call Hloop_DV_C(ntryL,G1H16(17),48,wf4(:,1),G2H4(18),m3h4x4(:,39),heltab2x16(:,:,151))
  call Hloop_CV_D(ntryL,G1H16(19),48,wf4(:,1),5,G2H4(19),m3h4x4(:,40),heltab2x16(:,:,152))
  call Hloop_UW_V(ntryL,G1H16(13),48,wf4(:,1),5,G2H4(20),m3h4x4(:,41),heltab2x16(:,:,153))
  call Hloop_UV_W(ntryL,G1H16(20),48,wf4(:,1),5,G2H4(22),m3h4x4(:,42),heltab2x16(:,:,154))
  call Hloop_SV_T(ntryL,G0H16(2),48,wf4(:,1),5,G1H4(103),m3h4x4(:,43),heltab2x16(:,:,155))
  call Hloop_TV_S(ntryL,G0H16(6),48,wf4(:,1),5,G1H4(45),m3h4x4(:,44),heltab2x16(:,:,156))
  call Hloop_VV_S(ntryL,G0H16(18),wf4(:,1),G0H4(17),m3h4x4(:,45),heltab2x16(:,:,157))
  call Hloop_VV_S(ntryL,G0H16(17),wf4(:,1),G0H4(12),m3h4x4(:,46),heltab2x16(:,:,158))
  call Hloop_SV_V(ntryL,G1H16(32),wf4(:,1),G1H4(39),m3h4x4(:,47),heltab2x16(:,:,159))
  call Hloop_VV_S(ntryL,G1H16(41),wf4(:,1),G1H4(23),m3h4x4(:,48),heltab2x16(:,:,160))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,1),G0H4(2),m3h4x4(:,49),heltab2x16(:,:,161))
  call Hloop_SV_V(ntryL,G0H16(4),wf4(:,1),G0H4(1),m3h4x4(:,50),heltab2x16(:,:,162))
  call Hloop_UW_V(ntryL,G0H16(21),48,wf4(:,1),5,G1H4(17),m3h4x4(:,51),heltab2x16(:,:,163))
  call Hloop_UV_W(ntryL,G0H16(20),48,wf4(:,1),5,G1H4(121),m3h4x4(:,52),heltab2x16(:,:,164))
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,2),G1H8(59),ngZu,m3h4x8(:,35),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G1H8(59),42,0,G2H8(1),n2h8(93))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,2),G1H8(60),ngZu,m3h4x8(:,36),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G1H8(60),42,0,G2H8(2),n2h8(94))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,2),G1H8(62),ngZd,m3h4x8(:,37),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(62),42,0,G2H8(3),n2h8(95))
  call Hloop_UV_W(ntryL,G0H32(14),32,wf4(:,2),10,G1H8(63),m3h4x8(:,38),heltab2x32(:,:,120))
  call Hloop_UV_W(ntryL,G0H8(30),37,wf4(:,2),10,G1H2(120),m3h4x2(:,85),heltab2x8(:,:,235))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,1),G1H8(4),ngZu,m3h4x8(:,39),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(4),37,0,G2H8(4),n2h8(96))
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,1),G1H8(23),ngZu,m3h4x8(:,40),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(23),37,0,G2H8(5),n2h8(97))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,1),G1H8(5),ngZd,m3h4x8(:,41),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(5),37,0,G2H8(6),n2h8(98))
  call Hloop_UV_W(ntryL,G0H32(19),32,wf4(:,1),5,G1H8(25),m3h4x8(:,42),heltab2x32(:,:,124))
  call Hloop_UV_W(ntryL,G0H8(10),42,wf4(:,1),5,G1H2(87),m3h4x2(:,86),heltab2x8(:,:,236))
  call Hloop_VS_V(ntryL,G0H32(20),wf16(:,1),G0H2(2),m3h16x2(:,1),heltab2x32(:,:,125))
  call Hloop_VS_V(ntryL,G0H32(1),wf16(:,1),G0H2(4),m3h16x2(:,2),heltab2x32(:,:,126))
  call Hloop_AQ_W(ntryL,G1H16(48),wf8(:,9),G1H2(46),m3h8x2(:,13),heltab2x16(:,:,165))
  call Hloop_AQ_Z(ntryL,G1H16(46),wf8(:,9),G1H2(29),ngZn,m3h8x2(:,14),heltab2x16(:,:,166))
  call Hloop_WQ_A(ntryL,G1H16(53),wf8(:,9),G1H2(60),m3h8x2(:,15),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(60),55,0,G2H2(10),n2h2(115))
  call Hloop_AQ_W(ntryL,G1H16(58),ex2(:),G1H8(65),m3h2x8(:,101),heltab2x16(:,:,168))
  call Hloop_AQ_Z(ntryL,G1H16(57),ex2(:),G1H8(66),ngZn,m3h2x8(:,102),heltab2x16(:,:,169))
  call Hloop_WQ_A(ntryL,G1H16(60),ex2(:),G1H8(68),m3h2x8(:,103),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H8(68),50,0,G2H8(7),n2h8(99))
  call Hloop_QZ_A(ntryL,G1H8(11),wf4(:,1),G1H2(35),ngZn,m3h4x2(:,87),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(35),55,0,G2H2(22),n2h2(116))
  call Hloop_UW_V(ntryL,G0H8(13),50,wf4(:,1),5,G1H2(45),m3h4x2(:,88),heltab2x8(:,:,238))
  call Hloop_ZQ_A(ntryL,G0H8(14),ex2(:),G0H4(10),ngZn,m3h2x4(:,139),heltab2x8(:,:,239))
  call Hloop_Q_A(ntryL,G0H4(10),58,0,G1H4(30),n2h4(175))
  call Hloop_WQ_A(ntryL,G0H8(15),ex2(:),G0H4(3),m3h2x4(:,140),heltab2x8(:,:,240))
  call Hloop_Q_A(ntryL,G0H4(3),58,0,G1H4(9),n2h4(176))
  call Hloop_AQ_W(ntryL,G1H8(15),ex2(:),G1H4(63),m3h2x4(:,141),heltab2x8(:,:,241))
  call Hloop_ZQ_A(ntryL,G0H4(9),ex2(:),G0H2(8),ngZn,m3h2x2(:,141),heltab2x4(:,:,275))
  call Hloop_Q_A(ntryL,G0H2(8),55,0,G1H2(82),n2h2(117))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf16(:,3),G1H2(36),ngZu,m3h16x2(:,3),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(36),47,0,G2H2(3),n2h2(118))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf16(:,3),G1H2(69),ngZu,m3h16x2(:,4),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(69),47,0,G2H2(4),n2h2(119))
  call Hloop_AZ_Q(ntryL,G1H32(9),wf16(:,3),G1H2(108),ngZd,m3h16x2(:,5),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(108),47,0,G2H2(7),n2h2(120))
  call Hloop_UV_W(ntryL,G0H32(23),32,wf16(:,3),15,G1H2(3),m3h16x2(:,6),heltab2x32(:,:,130))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf16(:,4),G1H2(96),ngZu,m3h16x2(:,7),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(96),47,0,G2H2(5),n2h2(121))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf16(:,4),G1H2(17),ngZu,m3h16x2(:,8),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(11),n2h2(122))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf16(:,4),G1H2(40),ngZd,m3h16x2(:,9),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(40),47,0,G2H2(13),n2h2(123))
  call Hloop_UV_W(ntryL,G0H32(4),32,wf16(:,4),15,G1H2(126),m3h16x2(:,10),heltab2x32(:,:,134))
  call Hloop_AQ_W(ntryL,G1H4(99),ex2(:),G1H2(111),m3h2x2(:,142),heltab2x4(:,:,276))
  call Hloop_AQ_Z(ntryL,G1H4(96),ex2(:),G1H2(27),ngZn,m3h2x2(:,143),heltab2x4(:,:,277))
  call Hloop_QZ_A(ntryL,G1H16(75),wf4(:,5),G1H4(59),ngZl,m3h4x4(:,53),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(59),54,0,G2H4(23),n2h4(177))
  call Hloop_QZ_A(ntryL,G1H16(76),wf4(:,5),G1H4(94),ngZl,m3h4x4(:,54),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(94),54,nML,G2H4(24),n2h4(178))
  call Hloop_AZ_Q(ntryL,G1H16(77),wf4(:,5),G1H4(80),ngZl,m3h4x4(:,55),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H4(80),54,0,G2H4(25),n2h4(179))
  call Hloop_AZ_Q(ntryL,G1H16(78),wf4(:,5),G1H4(78),ngZl,m3h4x4(:,56),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H4(78),54,nML,G2H4(26),n2h4(180))
  call Hloop_QZ_A(ntryL,G1H16(79),wf4(:,5),G1H4(29),ngZu,m3h4x4(:,57),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(29),54,0,G2H4(27),n2h4(181))
  call Hloop_QZ_A(ntryL,G1H16(80),wf4(:,5),G1H4(68),ngZu,m3h4x4(:,58),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(68),54,nMT,G2H4(28),n2h4(182))
  call Hloop_AZ_Q(ntryL,G1H16(81),wf4(:,5),G1H4(91),ngZu,m3h4x4(:,59),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(91),54,0,G2H4(29),n2h4(183))
  call Hloop_AZ_Q(ntryL,G1H16(82),wf4(:,5),G1H4(79),ngZu,m3h4x4(:,60),heltab2x16(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(79),54,nMT,G2H4(30),n2h4(184))
  call Hloop_QZ_A(ntryL,G1H16(83),wf4(:,5),G1H4(72),ngZd,m3h4x4(:,61),heltab2x16(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(72),54,0,G2H4(31),n2h4(185))
  call Hloop_QZ_A(ntryL,G1H16(84),wf4(:,5),G1H4(112),ngZd,m3h4x4(:,62),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(112),54,nMB,G2H4(32),n2h4(186))
  call Hloop_AZ_Q(ntryL,G1H16(85),wf4(:,5),G1H4(48),ngZd,m3h4x4(:,63),heltab2x16(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(48),54,0,G2H4(33),n2h4(187))
  call Hloop_AZ_Q(ntryL,G1H16(86),wf4(:,5),G1H4(8),ngZd,m3h4x4(:,64),heltab2x16(:,:,182))
  call Hloop_A_Q(ntryL,G1H4(8),54,nMB,G2H4(34),n2h4(188))
  call Hloop_QZ_A(ntryL,G1H16(73),wf4(:,5),G1H4(89),ngZn,m3h4x4(:,65),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(89),54,0,G2H4(1),n2h4(189))
  call Hloop_AZ_Q(ntryL,G1H16(74),wf4(:,5),G1H4(85),ngZn,m3h4x4(:,66),heltab2x16(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(85),54,0,G2H4(35),n2h4(190))
  call Hloop_TV_S(ntryL,G1H16(89),48,wf4(:,5),6,G2H4(2),m3h4x4(:,67),heltab2x16(:,:,185))
  call Hloop_SV_T(ntryL,G1H16(90),48,wf4(:,5),6,G2H4(36),m3h4x4(:,68),heltab2x16(:,:,186))
  call Hloop_CV_D(ntryL,G1H16(97),48,wf4(:,5),6,G2H4(37),m3h4x4(:,69),heltab2x16(:,:,187))
  call Hloop_DV_C(ntryL,G1H16(98),48,wf4(:,5),G2H4(38),m3h4x4(:,70),heltab2x16(:,:,188))
  call Hloop_UV_W(ntryL,G1H16(101),48,wf4(:,5),6,G2H4(39),m3h4x4(:,71),heltab2x16(:,:,189))
  call Hloop_UW_V(ntryL,G1H16(102),48,wf4(:,5),6,G2H4(40),m3h4x4(:,72),heltab2x16(:,:,190))
  call Hloop_VV_S(ntryL,G0H16(16),wf4(:,5),G0H4(5),m3h4x4(:,73),heltab2x16(:,:,191))
  call Hloop_VV_S(ntryL,G0H16(19),wf4(:,5),G0H4(14),m3h4x4(:,74),heltab2x16(:,:,192))
  call Hloop_TV_S(ntryL,G0H16(13),48,wf4(:,5),6,G1H4(109),m3h4x4(:,75),heltab2x16(:,:,193))
  call Hloop_SV_T(ntryL,G0H16(9),48,wf4(:,5),6,G1H4(11),m3h4x4(:,76),heltab2x16(:,:,194))
  call Hloop_SV_V(ntryL,G1H16(106),wf4(:,5),G1H4(88),m3h4x4(:,77),heltab2x16(:,:,195))
  call Hloop_VV_S(ntryL,G1H16(110),wf4(:,5),G1H4(102),m3h4x4(:,78),heltab2x16(:,:,196))
  call Hloop_UV_W(ntryL,G0H16(27),48,wf4(:,5),6,G1H4(35),m3h4x4(:,79),heltab2x16(:,:,197))
  call Hloop_UW_V(ntryL,G0H16(28),48,wf4(:,5),6,G1H4(24),m3h4x4(:,80),heltab2x16(:,:,198))
  call Hloop_SV_V(ntryL,G0H16(31),wf4(:,5),G0H4(6),m3h4x4(:,81),heltab2x16(:,:,199))
  call Hloop_SV_V(ntryL,G0H16(32),wf4(:,5),G0H4(4),m3h4x4(:,82),heltab2x16(:,:,200))
  call Hloop_AZ_Q(ntryL,G1H32(13),wf4(:,5),G1H8(69),ngZu,m3h4x8(:,43),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G1H8(69),38,0,G2H8(8),n2h8(100))
  call Hloop_AZ_Q(ntryL,G1H32(14),wf4(:,5),G1H8(70),ngZu,m3h4x8(:,44),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G1H8(70),38,0,G2H8(9),n2h8(101))
  call Hloop_AZ_Q(ntryL,G1H32(15),wf4(:,5),G1H8(71),ngZd,m3h4x8(:,45),heltab2x32(:,:,137))
  call Hloop_A_Q(ntryL,G1H8(71),38,0,G2H8(10),n2h8(102))
  call Hloop_UV_W(ntryL,G0H32(24),32,wf4(:,5),6,G1H8(73),m3h4x8(:,46),heltab2x32(:,:,138))
  call Hloop_UV_W(ntryL,G0H8(20),41,wf4(:,5),6,G1H2(15),m3h4x2(:,89),heltab2x8(:,:,242))
  call Hloop_AZ_Q(ntryL,G1H32(16),wf4(:,4),G1H8(74),ngZu,m3h4x8(:,47),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G1H8(74),41,0,G2H8(11),n2h8(103))
  call Hloop_AZ_Q(ntryL,G1H32(17),wf4(:,4),G1H8(75),ngZu,m3h4x8(:,48),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G1H8(75),41,0,G2H8(12),n2h8(104))
  call Hloop_AZ_Q(ntryL,G1H32(18),wf4(:,4),G1H8(76),ngZd,m3h4x8(:,49),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G1H8(76),41,0,G2H8(13),n2h8(105))
  call Hloop_UV_W(ntryL,G0H32(2),32,wf4(:,4),9,G1H8(78),m3h4x8(:,50),heltab2x32(:,:,142))
  call Hloop_UV_W(ntryL,G0H8(24),38,wf4(:,4),9,G1H2(81),m3h4x2(:,90),heltab2x8(:,:,243))
  call Hloop_VS_V(ntryL,G0H32(3),wf16(:,9),G0H2(1),m3h16x2(:,11),heltab2x32(:,:,143))
  call Hloop_VS_V(ntryL,G0H32(15),wf16(:,9),G0H2(3),m3h16x2(:,12),heltab2x32(:,:,144))
  call Hloop_AQ_W(ntryL,G1H16(113),wf8(:,20),G1H2(125),m3h8x2(:,16),heltab2x16(:,:,201))
  call Hloop_AQ_Z(ntryL,G1H16(112),wf8(:,20),G1H2(119),ngZn,m3h8x2(:,17),heltab2x16(:,:,202))
  call Hloop_WQ_A(ntryL,G1H16(115),wf8(:,20),G1H2(129),m3h8x2(:,18),heltab2x16(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(129),55,0,G2H2(14),n2h2(124))
  call Hloop_QZ_A(ntryL,G1H8(50),wf4(:,5),G1H2(130),ngZn,m3h4x2(:,91),heltab2x8(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(130),55,0,G2H2(17),n2h2(125))
  call Hloop_UW_V(ntryL,G0H8(27),49,wf4(:,5),6,G1H2(131),m3h4x2(:,92),heltab2x8(:,:,245))
  call Hloop_AQ_W(ntryL,G1H16(118),ex1(:),G1H8(79),m3h2x8(:,104),heltab2x16(:,:,204))
  call Hloop_AQ_Z(ntryL,G1H16(117),ex1(:),G1H8(21),ngZn,m3h2x8(:,105),heltab2x16(:,:,205))
  call Hloop_WQ_A(ntryL,G1H16(120),ex1(:),G1H8(80),m3h2x8(:,106),heltab2x16(:,:,206))
  call Hloop_Q_A(ntryL,G1H8(80),49,0,G2H8(14),n2h8(106))
  call Hloop_ZQ_A(ntryL,G0H8(28),ex1(:),G0H4(16),ngZn,m3h2x4(:,142),heltab2x8(:,:,246))
  call Hloop_Q_A(ntryL,G0H4(16),57,0,G1H4(7),n2h4(191))
  call Hloop_WQ_A(ntryL,G0H8(29),ex1(:),G0H4(8),m3h2x4(:,143),heltab2x8(:,:,247))
  call Hloop_Q_A(ntryL,G0H4(8),57,0,G1H4(5),n2h4(192))
  call Hloop_AQ_W(ntryL,G1H8(53),ex1(:),G1H4(19),m3h2x4(:,144),heltab2x8(:,:,248))
  call Hloop_ZQ_A(ntryL,G0H4(11),ex1(:),G0H2(5),ngZn,m3h2x2(:,144),heltab2x4(:,:,278))
  call Hloop_Q_A(ntryL,G0H2(5),55,0,G1H2(135),n2h2(126))
  call Hloop_AZ_Q(ntryL,G1H32(19),wf16(:,11),G1H2(136),ngZu,m3h16x2(:,13),heltab2x32(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(136),47,0,G2H2(15),n2h2(127))
  call Hloop_AZ_Q(ntryL,G1H32(20),wf16(:,11),G1H2(137),ngZu,m3h16x2(:,14),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(137),47,0,G2H2(1),n2h2(128))
  call Hloop_AZ_Q(ntryL,G1H32(21),wf16(:,11),G1H2(141),ngZd,m3h16x2(:,15),heltab2x32(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(141),47,0,G2H2(23),n2h2(129))
  call Hloop_UV_W(ntryL,G0H32(34),32,wf16(:,11),15,G1H2(143),m3h16x2(:,16),heltab2x32(:,:,148))
  call Hloop_AZ_Q(ntryL,G1H32(22),wf16(:,12),G1H2(147),ngZu,m3h16x2(:,17),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(147),47,0,G2H2(24),n2h2(130))
  call Hloop_AZ_Q(ntryL,G1H32(23),wf16(:,12),G1H2(149),ngZu,m3h16x2(:,18),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(149),47,0,G2H2(25),n2h2(131))
  call Hloop_AZ_Q(ntryL,G1H32(24),wf16(:,12),G1H2(153),ngZd,m3h16x2(:,19),heltab2x32(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(153),47,0,G2H2(26),n2h2(132))
  call Hloop_UV_W(ntryL,G0H32(38),32,wf16(:,12),15,G1H2(154),m3h16x2(:,20),heltab2x32(:,:,152))
  call Hloop_AQ_W(ntryL,G1H4(115),ex1(:),G1H2(155),m3h2x2(:,145),heltab2x4(:,:,279))
  call Hloop_AQ_Z(ntryL,G1H4(2),ex1(:),G1H2(159),ngZn,m3h2x2(:,146),heltab2x4(:,:,280))
  call Hloop_QA_W(ntryL,G1H16(123),ex3(:),G1H8(82),m3h2x8(:,107),heltab2x16(:,:,207))
  call Hloop_QA_Z(ntryL,G1H16(122),ex3(:),G1H8(83),ngZn,m3h2x8(:,108),heltab2x16(:,:,208))
  call Hloop_WA_Q(ntryL,G1H16(125),ex3(:),G1H8(84),m3h2x8(:,109),heltab2x16(:,:,209))
  call Hloop_A_Q(ntryL,G1H8(84),52,0,G2H8(15),n2h8(107))
  call Hloop_AQ_W(ntryL,G1H16(128),ex2(:),G1H8(85),m3h2x8(:,110),heltab2x16(:,:,210))
  call Hloop_AQ_Z(ntryL,G1H16(127),ex2(:),G1H8(87),ngZn,m3h2x8(:,111),heltab2x16(:,:,211))
  call Hloop_WQ_A(ntryL,G1H16(130),ex2(:),G1H8(88),m3h2x8(:,112),heltab2x16(:,:,212))
  call Hloop_Q_A(ntryL,G1H8(88),50,0,G2H8(16),n2h8(108))
  call Hloop_ZA_Q(ntryL,G0H8(2),ex3(:),G0H4(7),ngZn,m3h2x4(:,145),heltab2x8(:,:,249))
  call Hloop_A_Q(ntryL,G0H4(7),54,0,G1H4(32),n2h4(193))
  call Hloop_WA_Q(ntryL,G0H8(3),ex3(:),G0H4(10),m3h2x4(:,146),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G0H4(10),54,0,G1H4(6),n2h4(194))
  call Hloop_QA_W(ntryL,G1H8(54),ex3(:),G1H4(120),m3h2x4(:,147),heltab2x8(:,:,251))
  call Hloop_ZQ_A(ntryL,G0H8(8),ex2(:),G0H4(3),ngZn,m3h2x4(:,148),heltab2x8(:,:,252))
  call Hloop_Q_A(ntryL,G0H4(3),54,0,G1H4(76),n2h4(195))
  call Hloop_WQ_A(ntryL,G0H8(9),ex2(:),G0H4(9),m3h2x4(:,149),heltab2x8(:,:,253))
  call Hloop_Q_A(ntryL,G0H4(9),54,0,G1H4(71),n2h4(196))
  call Hloop_AQ_W(ntryL,G1H8(55),ex2(:),G1H4(64),m3h2x4(:,150),heltab2x8(:,:,254))
  call Hloop_ZQ_A(ntryL,G0H4(13),ex2(:),G0H2(7),ngZn,m3h2x2(:,147),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G0H2(7),59,0,G1H2(160),n2h2(133))
  call Hloop_AZ_Q(ntryL,G1H32(25),wf16(:,18),G1H2(167),ngZu,m3h16x2(:,21),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(167),47,0,G2H2(27),n2h2(134))
  call Hloop_AZ_Q(ntryL,G1H32(26),wf16(:,18),G1H2(177),ngZu,m3h16x2(:,22),heltab2x32(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(177),47,0,G2H2(28),n2h2(135))
  call Hloop_AZ_Q(ntryL,G1H32(27),wf16(:,18),G1H2(178),ngZd,m3h16x2(:,23),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(178),47,0,G2H2(29),n2h2(136))
  call Hloop_UV_W(ntryL,G0H32(42),32,wf16(:,18),15,G1H2(179),m3h16x2(:,24),heltab2x32(:,:,156))
  call Hloop_AZ_Q(ntryL,G1H32(28),wf16(:,19),G1H2(183),ngZu,m3h16x2(:,25),heltab2x32(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(183),47,0,G2H2(30),n2h2(137))
  call Hloop_AZ_Q(ntryL,G1H32(29),wf16(:,19),G1H2(184),ngZu,m3h16x2(:,26),heltab2x32(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(184),47,0,G2H2(31),n2h2(138))
  call Hloop_AZ_Q(ntryL,G1H32(30),wf16(:,19),G1H2(191),ngZd,m3h16x2(:,27),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(191),47,0,G2H2(32),n2h2(139))
  call Hloop_UV_W(ntryL,G0H32(46),32,wf16(:,19),15,G1H2(2),m3h16x2(:,28),heltab2x32(:,:,160))
  call Hloop_AQ_W(ntryL,G1H4(107),ex2(:),G1H2(14),m3h2x2(:,148),heltab2x4(:,:,282))
  call Hloop_AQ_Z(ntryL,G1H4(104),ex2(:),G1H2(26),ngZn,m3h2x2(:,149),heltab2x4(:,:,283))
  call Hloop_QA_W(ntryL,G1H16(133),ex3(:),G1H8(89),m3h2x8(:,113),heltab2x16(:,:,213))
  call Hloop_QA_Z(ntryL,G1H16(132),ex3(:),G1H8(90),ngZn,m3h2x8(:,114),heltab2x16(:,:,214))
  call Hloop_WA_Q(ntryL,G1H16(135),ex3(:),G1H8(92),m3h2x8(:,115),heltab2x16(:,:,215))
  call Hloop_A_Q(ntryL,G1H8(92),52,0,G2H8(17),n2h8(109))
  call Hloop_ZA_Q(ntryL,G0H8(5),ex3(:),G0H4(16),ngZn,m3h2x4(:,151),heltab2x8(:,:,255))
  call Hloop_A_Q(ntryL,G0H4(16),53,0,G1H4(47),n2h4(197))
  call Hloop_WA_Q(ntryL,G0H8(6),ex3(:),G0H4(8),m3h2x4(:,152),heltab2x8(:,:,256))
  call Hloop_A_Q(ntryL,G0H4(8),53,0,G1H4(117),n2h4(198))
  call Hloop_QA_W(ntryL,G1H8(57),ex3(:),G1H4(10),m3h2x4(:,153),heltab2x8(:,:,257))
  call Hloop_AQ_W(ntryL,G1H16(138),ex1(:),G1H8(93),m3h2x8(:,116),heltab2x16(:,:,216))
  call Hloop_AQ_Z(ntryL,G1H16(137),ex1(:),G1H8(16),ngZn,m3h2x8(:,117),heltab2x16(:,:,217))
  call Hloop_WQ_A(ntryL,G1H16(140),ex1(:),G1H8(3),m3h2x8(:,118),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H8(3),49,0,G2H8(18),n2h8(110))
  call Hloop_ZQ_A(ntryL,G0H8(12),ex1(:),G0H4(11),ngZn,m3h2x4(:,154),heltab2x8(:,:,258))
  call Hloop_Q_A(ntryL,G0H4(11),53,0,G1H4(51),n2h4(199))
  call Hloop_WQ_A(ntryL,G0H8(16),ex1(:),G0H4(7),m3h2x4(:,155),heltab2x8(:,:,259))
  call Hloop_Q_A(ntryL,G0H4(7),53,0,G1H4(116),n2h4(200))
  call Hloop_AQ_W(ntryL,G1H8(58),ex1(:),G1H4(18),m3h2x4(:,156),heltab2x8(:,:,260))
  call Hloop_ZQ_A(ntryL,G0H4(15),ex1(:),G0H2(8),ngZn,m3h2x2(:,150),heltab2x4(:,:,284))
  call Hloop_Q_A(ntryL,G0H2(8),59,0,G1H2(38),n2h2(140))
  call Hloop_AZ_Q(ntryL,G1H32(31),wf16(:,25),G1H2(50),ngZu,m3h16x2(:,29),heltab2x32(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(50),47,0,G2H2(33),n2h2(141))
  call Hloop_AZ_Q(ntryL,G1H32(32),wf16(:,25),G1H2(62),ngZu,m3h16x2(:,30),heltab2x32(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(62),47,0,G2H2(36),n2h2(142))
  call Hloop_AZ_Q(ntryL,G1H32(33),wf16(:,25),G1H2(79),ngZd,m3h16x2(:,31),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(79),47,0,G2H2(38),n2h2(143))
  call Hloop_UV_W(ntryL,G0H32(50),32,wf16(:,25),15,G1H2(55),m3h16x2(:,32),heltab2x32(:,:,164))
  call Hloop_AZ_Q(ntryL,G1H32(34),wf16(:,26),G1H2(22),ngZu,m3h16x2(:,33),heltab2x32(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(22),47,0,G2H2(41),n2h2(144))
  call Hloop_AZ_Q(ntryL,G1H32(35),wf16(:,26),G1H2(97),ngZu,m3h16x2(:,34),heltab2x32(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(97),47,0,G2H2(42),n2h2(145))
  call Hloop_AZ_Q(ntryL,G1H32(36),wf16(:,26),G1H2(31),ngZd,m3h16x2(:,35),heltab2x32(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(31),47,0,G2H2(45),n2h2(146))
  call Hloop_UV_W(ntryL,G0H32(16),32,wf16(:,26),15,G1H2(77),m3h16x2(:,36),heltab2x32(:,:,168))
  call Hloop_AQ_W(ntryL,G1H4(125),ex1(:),G1H2(54),m3h2x2(:,151),heltab2x4(:,:,285))
  call Hloop_AQ_Z(ntryL,G1H4(122),ex1(:),G1H2(32),ngZn,m3h2x2(:,152),heltab2x4(:,:,286))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(10),G2H2(85),G2H2(64),G2H2(39),G2H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(33),G2H2(30),G2H2(27),G2H2(24),G2H2(15),G2H2(5) &
    ,G2H2(3),G2H2(76),G2H2(67),G2H2(55),G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(36),G2H2(31),G2H2(28),G2H2(25),G2H2(1),G2H2(11) &
    ,G2H2(4),G2H2(79),G2H2(70),G2H2(58),G2H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G2H2(38),G2H2(32),G2H2(29),G2H2(26),G2H2(23) &
    ,G2H2(13),G2H2(7),G2H2(82),G2H2(73),G2H2(61),G2H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(49)])
call HGT_w2_OLR(G1H4(56),1,1,4)
call HGT_w2_invQ_OLR(G1H4(56),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(56)])
call HGT_w2_OLR(G1H4(60),1,1,4)
call HGT_w2_invQ_OLR(G1H4(60),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(60)])
call HGT_w2_OLR(G1H4(50),1,1,4)
call HGT_w2_invQ_OLR(G1H4(50),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(54)])
call HGT_w2_OLR(G1H4(55),1,1,4)
call HGT_w2_invQ_OLR(G1H4(55),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G1H4(55)])
call HGT_w2_OLR(G1H4(20),1,1,4)
call HGT_w2_invQ_OLR(G1H4(20),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(21)])
call HGT_w2_OLR(G1H4(62),1,1,4)
call HGT_w2_invQ_OLR(G1H4(62),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(53)])
call HGT_w2_OLR(G1H4(66),1,1,4)
call HGT_w2_invQ_OLR(G1H4(66),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G2H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(105)])
call HGT_w2_OLR(G1H4(67),1,1,4)
call HGT_w2_invQ_OLR(G1H4(67),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(81),[G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(55),G1H2(2),G1H2(179),G1H2(154),G1H2(143) &
    ,G1H2(126),G1H2(3),G1H2(182),G1H2(174),G1H2(163),G1H2(152),G0H2(3),G0H2(4),G0H2(6),G0H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(120),[G1H2(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(155),[G1H2(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(125),[G1H2(46),G1H2(140),G1H2(127),G1H2(86),G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(159),[G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(119),[G1H2(29),G1H2(80),G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(98),[G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(111),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(131),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(27),[G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(34),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(101),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(114),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(127),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(45),G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(17),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(1),[G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(11),G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(35),G1H4(88)])
call HGT_w2_OLR(G1H2(138),1,1,2)
call HGT_w2_invQ_OLR(G1H2(138),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(138),ex1(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(86),n2h1(405))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(66),m3h2x1(:,360),heltab2x2(:,:,360))
call HGT_w2_OLR(G1H2(145),1,1,2)
call HGT_w2_invQ_OLR(G1H2(145),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(145),ex2(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(406))
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(4),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,135),heltab2x4(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(407))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(41),ex5(:),G2tensor(116),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(42),ex5(:),G2tensor(70),ngZu,m3h2x1(:,363),heltab2x2(:,:,363))
call HGT_w2_OLR(G1H4(36),1,1,4)
call HGT_w2_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(36),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,136),heltab2x4(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(131),n2h1(408))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(45),ex5(:),G2tensor(72),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hloop_AZ_Q(ntryL,G2H4(7),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,137),heltab2x4(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(1),n2h1(409))
  call Hloop_AZ_Q(ntryL,G2H4(12),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,138),heltab2x4(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(2),n2h1(410))
  call Hloop_QZ_A(ntryL,G1H4(50),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,139),heltab2x4(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(80),n2h1(411))
  call Hloop_AZ_Q(ntryL,G2H4(29),wf4(:,4),G2H1(1),ngZu,m3h4x1(:,140),heltab2x4(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(3),n2h1(412))
  call Hloop_AZ_Q(ntryL,G2H4(33),wf4(:,4),G2H1(1),ngZd,m3h4x1(:,141),heltab2x4(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(4),n2h1(413))
call HGT_w2_OLR(G1H4(61),1,1,4)
call HGT_w2_invQ_OLR(G1H4(61),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(61),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,142),heltab2x4(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(414))
call HGT_w2_OLR(G1H4(38),1,1,4)
call HGT_w2_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(38),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,143),heltab2x4(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(415))
  call Hloop_QZ_A(ntryL,G1H4(62),wf4(:,5),G1H1(1),ngZl,m3h4x1(:,144),heltab2x4(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(416))
  call Hloop_QZ_A(ntryL,G1H4(66),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,145),heltab2x4(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(417))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(91),ex3(:),G2tensor(98),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hloop_QZ_A(ntryL,G1H4(67),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,146),heltab2x4(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(418))
  call Hloop_WQ_A(ntryL,G1H2(81),ex5(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(419))
  call Hloop_WQ_A(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(110),n2h1(420))
  call Hloop_WQ_A(ntryL,G1H2(87),ex5(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(421))
  call Hloop_WQ_A(ntryL,G1H2(120),ex5(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(422))
  call Hloop_WQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(423))
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,147),heltab2x4(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(125),n2h1(424))
  call Hloop_QZ_A(ntryL,G1H4(26),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,148),heltab2x4(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(128),n2h1(425))
  call Hloop_QZ_A(ntryL,G1H4(75),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,149),heltab2x4(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(426))
  call Hloop_QZ_A(ntryL,G1H4(77),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,150),heltab2x4(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(427))
  call Hloop_WA_Q(ntryL,G1H2(155),ex4(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(134),n2h1(428))
  call Hloop_WA_Q(ntryL,G1H2(125),ex4(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(429))
  call Hloop_WA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(137),n2h1(430))
  call Hloop_ZA_Q(ntryL,G1H2(159),ex4(:),G1H1(1),ngZn,m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(140),n2h1(431))
  call Hloop_ZA_Q(ntryL,G1H2(119),ex4(:),G1H1(1),ngZn,m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(432))
  call Hloop_WA_Q(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(433))
  call Hloop_WA_Q(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(146),n2h1(434))
  call Hloop_WA_Q(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(435))
  call Hloop_WA_Q(ntryL,G1H2(131),ex4(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(149),n2h1(436))
  call Hloop_ZA_Q(ntryL,G1H2(27),ex4(:),G1H1(1),ngZn,m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(437))
  call Hloop_WA_Q(ntryL,G1H2(107),ex3(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(438))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(81),53,wf4(:,2),10,G2tensor(155),m3h4x1(:,151),heltab2x4(:,:,303))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(82),53,wf4(:,2),10,G2tensor(156),m3h4x1(:,152),heltab2x4(:,:,304))
  call Hloop_AZ_Q(ntryL,G1H4(86),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,153),heltab2x4(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(439))
  call Hloop_AZ_Q(ntryL,G1H4(87),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,154),heltab2x4(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(440))
  call Hloop_AZ_Q(ntryL,G1H4(15),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,155),heltab2x4(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(161),n2h1(441))
  call Hloop_AZ_Q(ntryL,G1H4(16),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,156),heltab2x4(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(164),n2h1(442))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(12),58,wf4(:,1),5,G2tensor(165),m3h4x1(:,157),heltab2x4(:,:,309))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(44),58,wf4(:,1),5,G2tensor(167),m3h4x1(:,158),heltab2x4(:,:,310))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(58),54,wf4(:,4),9,G2tensor(170),m3h4x1(:,159),heltab2x4(:,:,311))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(70),54,wf4(:,4),9,G2tensor(171),m3h4x1(:,160),heltab2x4(:,:,312))
  call Hloop_AZ_Q(ntryL,G1H4(13),wf4(:,5),G1H1(1),ngZl,m3h4x1(:,161),heltab2x4(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(173),n2h1(443))
  call Hloop_AZ_Q(ntryL,G1H4(14),wf4(:,5),G1H1(1),ngZl,m3h4x1(:,162),heltab2x4(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(444))
  call Hloop_AZ_Q(ntryL,G1H4(25),wf4(:,5),G1H1(1),ngZn,m3h4x1(:,163),heltab2x4(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(180),n2h1(445))
  call Hloop_AZ_Q(ntryL,G1H4(31),wf4(:,5),G1H1(1),ngZn,m3h4x1(:,164),heltab2x4(:,:,316))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(446))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(46),57,wf4(:,5),6,G2tensor(186),m3h4x1(:,165),heltab2x4(:,:,317))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(41),57,wf4(:,5),6,G2tensor(188),m3h4x1(:,166),heltab2x4(:,:,318))
  call Hloop_QZ_A(ntryL,G2H4(23),wf4(:,4),G2H1(1),ngZl,m3h4x1(:,167),heltab2x4(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(5),n2h1(447))
  call Hloop_QZ_A(ntryL,G1H4(76),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,168),heltab2x4(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(189),n2h1(448))
  call Hloop_QZ_A(ntryL,G2H4(1),wf4(:,4),G2H1(1),ngZn,m3h4x1(:,169),heltab2x4(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(6),n2h1(449))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(64),54,wf4(:,4),9,G2tensor(191),m3h4x1(:,170),heltab2x4(:,:,322))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(40),54,wf4(:,4),9,G3tensor(7),m3h4x1(:,171),heltab2x4(:,:,323))
  call Hloop_AZ_Q(ntryL,G1H4(6),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,172),heltab2x4(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(192),n2h1(450))
  call Hloop_AZ_Q(ntryL,G2H4(25),wf4(:,4),G2H1(1),ngZl,m3h4x1(:,173),heltab2x4(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(8),n2h1(451))
  call Hloop_AZ_Q(ntryL,G1H4(32),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,174),heltab2x4(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(194),n2h1(452))
  call Hloop_AZ_Q(ntryL,G2H4(35),wf4(:,4),G2H1(1),ngZn,m3h4x1(:,175),heltab2x4(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(9),n2h1(453))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(120),54,wf4(:,4),9,G2tensor(195),m3h4x1(:,176),heltab2x4(:,:,328))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(39),54,wf4(:,4),9,G3tensor(10),m3h4x1(:,177),heltab2x4(:,:,329))
  call Hloop_QZ_A(ntryL,G2H4(5),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,178),heltab2x4(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(11),n2h1(454))
  call Hloop_QZ_A(ntryL,G1H4(51),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,179),heltab2x4(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(197),n2h1(455))
  call Hloop_QZ_A(ntryL,G2H4(21),wf4(:,2),G2H1(1),ngZn,m3h4x1(:,180),heltab2x4(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(12),n2h1(456))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(18),53,wf4(:,2),10,G2tensor(198),m3h4x1(:,181),heltab2x4(:,:,333))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(20),53,wf4(:,2),10,G3tensor(13),m3h4x1(:,182),heltab2x4(:,:,334))
  call Hloop_AZ_Q(ntryL,G1H4(117),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,183),heltab2x4(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(62),n2h1(457))
  call Hloop_AZ_Q(ntryL,G2H4(3),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,184),heltab2x4(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(14),n2h1(458))
  call Hloop_AZ_Q(ntryL,G1H4(47),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,185),heltab2x4(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(459))
  call Hloop_AZ_Q(ntryL,G2H4(14),wf4(:,2),G2H1(1),ngZn,m3h4x1(:,186),heltab2x4(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(15),n2h1(460))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(10),53,wf4(:,2),10,G2tensor(338),m3h4x1(:,187),heltab2x4(:,:,339))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(22),53,wf4(:,2),10,G3tensor(16),m3h4x1(:,188),heltab2x4(:,:,340))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(308),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(356),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(46),ex5(:),G2tensor(320),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(49),ex5(:),G2tensor(74),ngZu,m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(34),ex5(:),G2tensor(75),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(37),ex5(:),G2tensor(77),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(63),ex5(:),G2tensor(78),ngZu,m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(87),ex5(:),G2tensor(225),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(84),ex4(:),G2tensor(81),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(90),ex5(:),G2tensor(4),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(18),ex5(:),G2tensor(84),ngZu,m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(8),ex5(:),G2tensor(204),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex5(:),G2tensor(89),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(19),ex5(:),G2tensor(90),ngZu,m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(12),ex5(:),G2tensor(92),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(93),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(20),ex3(:),G2tensor(169),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(21),ex3(:),G2tensor(96),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(8),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(99),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hloop_AZ_Q(ntryL,G2H4(4),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,189),heltab2x4(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nML,G3tensor(17),n2h1(461))
  call Hloop_QZ_A(ntryL,G2H4(6),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,190),heltab2x4(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nML,G3tensor(18),n2h1(462))
  call Hloop_AZ_Q(ntryL,G2H4(8),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,191),heltab2x4(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(19),n2h1(463))
  call Hloop_QZ_A(ntryL,G2H4(9),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,192),heltab2x4(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(20),n2h1(464))
  call Hloop_QZ_A(ntryL,G2H4(15),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,193),heltab2x4(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(21),n2h1(465))
  call Hloop_AZ_Q(ntryL,G2H4(10),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,194),heltab2x4(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(22),n2h1(466))
  call Hloop_QZ_A(ntryL,G2H4(11),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,195),heltab2x4(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(23),n2h1(467))
  call Hloop_QZ_A(ntryL,G2H4(13),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,196),heltab2x4(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(24),n2h1(468))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(17),53,wf4(:,2),10,G3tensor(25),m3h4x1(:,197),heltab2x4(:,:,349))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(16),53,wf4(:,2),10,G3tensor(26),m3h4x1(:,198),heltab2x4(:,:,350))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(18),53,wf4(:,2),G3tensor(27),m3h4x1(:,199),heltab2x4(:,:,351))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(19),53,wf4(:,2),10,G3tensor(28),m3h4x1(:,200),heltab2x4(:,:,352))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(23),wf4(:,2),G1tensor(94),m3h4x1(:,201),heltab2x4(:,:,353))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(121),wf4(:,2),G1tensor(139),m3h4x1(:,202),heltab2x4(:,:,354))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,3),G2tensor(184),m3h8x1(:,13),heltab2x8(:,:,261))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H8(2),wf8(:,3),G2tensor(104),ngZu,m3h8x1(:,14),heltab2x8(:,:,262))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(3),wf8(:,3),G2tensor(105),m3h8x1(:,15),heltab2x8(:,:,263))
  call Hloop_WQ_A(ntryL,G1H8(63),wf8(:,3),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(469))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,6),G2tensor(108),m3h8x1(:,17),heltab2x8(:,:,265))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H8(5),wf8(:,6),G2tensor(227),ngZu,m3h8x1(:,18),heltab2x8(:,:,266))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(6),wf8(:,6),G2tensor(111),m3h8x1(:,19),heltab2x8(:,:,267))
  call Hloop_WQ_A(ntryL,G1H8(25),wf8(:,6),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(470))
  call Hloop_ZQ_A(ntryL,G0H2(1),ex5(:),G0H1(1),ngZu,m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(169),n2h1(471))
  call Hloop_WA_Q(ntryL,G1H8(65),wf8(:,58),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(472))
  call Hloop_ZA_Q(ntryL,G1H8(66),wf8(:,58),G1H1(1),ngZn,m3h8x1(:,22),heltab2x8(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(209),n2h1(473))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(7),wf8(:,58),G2tensor(119),m3h8x1(:,23),heltab2x8(:,:,271))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(120),ngZn,m3h2x1(:,403),heltab2x2(:,:,403))
  call Hloop_QZ_A(ntryL,G1H4(30),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,203),heltab2x4(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(122),n2h1(474))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(63),58,wf4(:,1),5,G2tensor(123),m3h4x1(:,204),heltab2x4(:,:,356))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(82),ex4(:),G1tensor(199),ngZn,m3h2x1(:,404),heltab2x2(:,:,404))
  call Hloop_QZ_A(ntryL,G2H4(24),wf4(:,4),G2H1(1),ngZl,m3h4x1(:,205),heltab2x4(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nML,G3tensor(29),n2h1(475))
  call Hloop_AZ_Q(ntryL,G2H4(26),wf4(:,4),G2H1(1),ngZl,m3h4x1(:,206),heltab2x4(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nML,G3tensor(30),n2h1(476))
  call Hloop_QZ_A(ntryL,G2H4(27),wf4(:,4),G2H1(1),ngZu,m3h4x1(:,207),heltab2x4(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(31),n2h1(477))
  call Hloop_QZ_A(ntryL,G2H4(28),wf4(:,4),G2H1(1),ngZu,m3h4x1(:,208),heltab2x4(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(32),n2h1(478))
  call Hloop_AZ_Q(ntryL,G2H4(30),wf4(:,4),G2H1(1),ngZu,m3h4x1(:,209),heltab2x4(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(33),n2h1(479))
  call Hloop_QZ_A(ntryL,G2H4(31),wf4(:,4),G2H1(1),ngZd,m3h4x1(:,210),heltab2x4(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(34),n2h1(480))
  call Hloop_QZ_A(ntryL,G2H4(32),wf4(:,4),G2H1(1),ngZd,m3h4x1(:,211),heltab2x4(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(35),n2h1(481))
  call Hloop_AZ_Q(ntryL,G2H4(34),wf4(:,4),G2H1(1),ngZd,m3h4x1(:,212),heltab2x4(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(36),n2h1(482))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(2),54,wf4(:,4),9,G3tensor(37),m3h4x1(:,213),heltab2x4(:,:,365))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(36),54,wf4(:,4),9,G3tensor(38),m3h4x1(:,214),heltab2x4(:,:,366))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(37),54,wf4(:,4),9,G3tensor(39),m3h4x1(:,215),heltab2x4(:,:,367))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(38),54,wf4(:,4),G3tensor(40),m3h4x1(:,216),heltab2x4(:,:,368))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(102),wf4(:,4),G1tensor(229),m3h4x1(:,217),heltab2x4(:,:,369))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(24),wf4(:,4),G1tensor(259),m3h4x1(:,218),heltab2x4(:,:,370))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(8),wf8(:,15),G2tensor(178),m3h8x1(:,24),heltab2x8(:,:,272))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H8(9),wf8(:,15),G2tensor(126),ngZu,m3h8x1(:,25),heltab2x8(:,:,273))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(10),wf8(:,15),G2tensor(16),m3h8x1(:,26),heltab2x8(:,:,274))
  call Hloop_WQ_A(ntryL,G1H8(73),wf8(:,15),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(483))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(11),wf8(:,18),G2tensor(199),m3h8x1(:,28),heltab2x8(:,:,276))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H8(12),wf8(:,18),G2tensor(193),ngZu,m3h8x1(:,29),heltab2x8(:,:,277))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(13),wf8(:,18),G2tensor(181),m3h8x1(:,30),heltab2x8(:,:,278))
  call Hloop_WQ_A(ntryL,G1H8(78),wf8(:,18),G1H1(1),m3h8x1(:,31),heltab2x8(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(484))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(202),ngZn,m3h2x1(:,405),heltab2x2(:,:,405))
  call Hloop_WA_Q(ntryL,G1H8(79),wf8(:,85),G1H1(1),m3h8x1(:,32),heltab2x8(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(196),n2h1(485))
  call Hloop_ZA_Q(ntryL,G1H8(21),wf8(:,85),G1H1(1),ngZn,m3h8x1(:,33),heltab2x8(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(486))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(14),wf8(:,85),G2tensor(206),m3h8x1(:,34),heltab2x8(:,:,282))
  call Hloop_QZ_A(ntryL,G1H4(7),wf4(:,5),G1H1(1),ngZn,m3h4x1(:,219),heltab2x4(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(205),n2h1(487))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(19),57,wf4(:,5),6,G2tensor(207),m3h4x1(:,220),heltab2x4(:,:,372))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(135),ex4(:),G1tensor(289),ngZn,m3h2x1(:,406),heltab2x2(:,:,406))
  call Hloop_WQ_A(ntryL,G1H8(82),wf8(:,26),G1H1(1),m3h8x1(:,35),heltab2x8(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(203),n2h1(488))
  call Hloop_ZQ_A(ntryL,G1H8(83),wf8(:,26),G1H1(1),ngZn,m3h8x1(:,36),heltab2x8(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(489))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(15),wf8(:,26),G2tensor(211),m3h8x1(:,37),heltab2x8(:,:,285))
  call Hloop_WA_Q(ntryL,G1H8(85),wf8(:,68),G1H1(1),m3h8x1(:,38),heltab2x8(:,:,286))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(210),n2h1(490))
  call Hloop_ZA_Q(ntryL,G1H8(87),wf8(:,68),G1H1(1),ngZn,m3h8x1(:,39),heltab2x8(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(212),n2h1(491))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(16),wf8(:,68),G2tensor(208),m3h8x1(:,40),heltab2x8(:,:,288))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(160),ex3(:),G1tensor(319),ngZn,m3h2x1(:,407),heltab2x2(:,:,407))
  call Hloop_WA_Q(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(492))
  call Hloop_ZA_Q(ntryL,G1H2(26),ex3(:),G1H1(1),ngZn,m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(220),n2h1(493))
  call Hloop_WQ_A(ntryL,G1H8(89),wf8(:,29),G1H1(1),m3h8x1(:,41),heltab2x8(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(168),n2h1(494))
  call Hloop_ZQ_A(ntryL,G1H8(90),wf8(:,29),G1H1(1),ngZn,m3h8x1(:,42),heltab2x8(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(215),n2h1(495))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(17),wf8(:,29),G2tensor(221),m3h8x1(:,43),heltab2x8(:,:,291))
  call Hloop_WA_Q(ntryL,G1H8(93),wf8(:,94),G1H1(1),m3h8x1(:,44),heltab2x8(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(174),n2h1(496))
  call Hloop_ZA_Q(ntryL,G1H8(16),wf8(:,94),G1H1(1),ngZn,m3h8x1(:,45),heltab2x8(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(216),n2h1(497))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(18),wf8(:,94),G2tensor(176),m3h8x1(:,46),heltab2x8(:,:,294))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(38),ex3(:),G1tensor(349),ngZn,m3h2x1(:,410),heltab2x2(:,:,410))
  call Hloop_WA_Q(ntryL,G1H2(54),ex3(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(332),n2h1(498))
  call Hloop_ZA_Q(ntryL,G1H2(32),ex3(:),G1H1(1),ngZn,m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(179),n2h1(499))
  call ol_merge_tensors(G3tensor(40),[G3tensor(39),G3tensor(38),G3tensor(37),G3tensor(10),G3tensor(7),G2tensor(258),G2tensor(226) &
    ,G1tensor(259),G1tensor(229),G1tensor(1066),G1tensor(659),G1tensor(433),G1tensor(187),G0tensor(1414),G0tensor(852) &
    ,G0tensor(55),G0tensor(14)])
  call ol_merge_tensors(G3tensor(28),[G3tensor(27),G3tensor(26),G3tensor(25),G3tensor(16),G3tensor(13),G2tensor(264),G2tensor(228) &
    ,G1tensor(139),G1tensor(94),G1tensor(1071),G1tensor(734),G1tensor(426),G1tensor(247),G0tensor(1429),G0tensor(992) &
    ,G0tensor(145),G0tensor(24)])
  call ol_merge_tensors(G2tensor(184),[G2tensor(230),G1tensor(1077),G0tensor(1445)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(232),G1tensor(1082),G0tensor(1450)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(234),G1tensor(1087),G0tensor(1455)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(236),G1tensor(1092),G0tensor(1460)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(238),G1tensor(1097),G1tensor(792),G1tensor(133),G0tensor(1465),G0tensor(1100) &
    ,G0tensor(5)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(301),G2tensor(240),G1tensor(1137),G1tensor(1102),G0tensor(1505),G0tensor(1470)])
  call ol_merge_tensors(G2tensor(208),[G2tensor(119),G2tensor(340),G2tensor(310),G2tensor(255),G2tensor(241),G1tensor(664) &
    ,G1tensor(254),G1tensor(493),G1tensor(223),G1tensor(193),G0tensor(857),G0tensor(110),G0tensor(65),G0tensor(20),G0tensor(15)])
  call ol_merge_tensors(G2tensor(178),[G2tensor(243),G1tensor(1107),G0tensor(1475)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(245),G1tensor(1112),G1tensor(812),G1tensor(163),G0tensor(1480),G0tensor(1120) &
    ,G0tensor(10)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(313),G2tensor(247),G1tensor(1142),G1tensor(1117),G0tensor(1510),G0tensor(1485)])
  call ol_merge_tensors(G2tensor(199),[G2tensor(249),G1tensor(1122),G0tensor(1490)])
  call ol_merge_tensors(G2tensor(193),[G2tensor(251),G1tensor(1127),G0tensor(1495)])
  call ol_merge_tensors(G2tensor(181),[G2tensor(253),G1tensor(1132),G0tensor(1500)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(206),G2tensor(358),G2tensor(322),G2tensor(256),G2tensor(254),G1tensor(739) &
    ,G1tensor(546),G1tensor(516),G1tensor(283),G1tensor(253),G0tensor(997),G0tensor(200),G0tensor(155),G0tensor(30) &
    ,G0tensor(25)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(271),G2tensor(259),G1tensor(907),G1tensor(662),G1tensor(547),G1tensor(463) &
    ,G0tensor(1215),G0tensor(855),G0tensor(74),G0tensor(60)])
  call ol_merge_tensors(G2tensor(167),[G2tensor(261),G1tensor(699),G1tensor(120),G1tensor(217),G0tensor(917),G0tensor(100) &
    ,G0tensor(19)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(262),G1tensor(837),G1tensor(702),G1tensor(48),G1tensor(86),G0tensor(1145) &
    ,G0tensor(920),G0tensor(119),G0tensor(105)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(274),G2tensor(265),G1tensor(947),G1tensor(737),G1tensor(381),G1tensor(105) &
    ,G0tensor(1255),G0tensor(995),G0tensor(164),G0tensor(150)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(267),G1tensor(769),G1tensor(536),G1tensor(277),G0tensor(1072),G0tensor(190) &
    ,G0tensor(29)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(268),G1tensor(867),G1tensor(772),G1tensor(558),G1tensor(168),G0tensor(1175) &
    ,G0tensor(1075),G0tensor(209),G0tensor(195)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(270),G1tensor(904),G1tensor(770),G1tensor(765),G1tensor(20),G0tensor(1212) &
    ,G0tensor(1073),G0tensor(1063),G0tensor(264)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(273),G1tensor(944),G1tensor(700),G1tensor(690),G1tensor(24),G0tensor(1252) &
    ,G0tensor(918),G0tensor(903),G0tensor(289)])
  call ol_merge_tensors(G2tensor(276),[G1tensor(989),G1tensor(112),G0tensor(1297),G0tensor(324)])
  call ol_merge_tensors(G3tensor(34),[G3tensor(31),G3tensor(9),G3tensor(8),G3tensor(6),G3tensor(5),G3tensor(4),G3tensor(3) &
    ,G2tensor(283),G2tensor(277),G1tensor(1151),G1tensor(1146),G1tensor(1114),G1tensor(1109),G1tensor(1104),G1tensor(1002) &
    ,G1tensor(992),G1tensor(185),G1tensor(442),G0tensor(1519),G0tensor(1514),G0tensor(1482),G0tensor(1477),G0tensor(1472) &
    ,G0tensor(1310),G0tensor(1300),G0tensor(339),G0tensor(329)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(279),G1tensor(994),G1tensor(135),G0tensor(1302),G0tensor(325)])
  call ol_merge_tensors(G2tensor(210),[G2tensor(114),G2tensor(334),G2tensor(304),G2tensor(286),G2tensor(280),G1tensor(1017) &
    ,G1tensor(997),G1tensor(160),G1tensor(292),G0tensor(1325),G0tensor(1305),G0tensor(350),G0tensor(330)])
  call ol_merge_tensors(G2tensor(282),[G1tensor(999),G1tensor(704),G1tensor(298),G1tensor(312),G0tensor(1307),G0tensor(922) &
    ,G0tensor(334),G0tensor(123)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(285),G1tensor(1065),G1tensor(1014),G1tensor(165),G0tensor(1413),G0tensor(1322) &
    ,G0tensor(345)])
  call ol_merge_tensors(G2tensor(288),[G1tensor(1029),G1tensor(179),G0tensor(1337),G0tensor(364)])
  call ol_merge_tensors(G3tensor(23),[G3tensor(20),G3tensor(15),G3tensor(14),G3tensor(12),G3tensor(11),G3tensor(2),G3tensor(1) &
    ,G2tensor(295),G2tensor(289),G1tensor(1161),G1tensor(1156),G1tensor(1099),G1tensor(1094),G1tensor(1089),G1tensor(1042) &
    ,G1tensor(1032),G1tensor(226),G1tensor(202),G0tensor(1529),G0tensor(1524),G0tensor(1467),G0tensor(1462),G0tensor(1457) &
    ,G0tensor(1350),G0tensor(1340),G0tensor(379),G0tensor(369)])
  call ol_merge_tensors(G2tensor(207),[G2tensor(291),G1tensor(1034),G1tensor(186),G0tensor(1342),G0tensor(365)])
  call ol_merge_tensors(G2tensor(174),[G2tensor(196),G2tensor(352),G2tensor(316),G2tensor(298),G2tensor(292),G1tensor(1057) &
    ,G1tensor(1037),G1tensor(245),G1tensor(197),G0tensor(1365),G0tensor(1345),G0tensor(390),G0tensor(370)])
  call ol_merge_tensors(G2tensor(294),[G1tensor(1039),G1tensor(57),G1tensor(280),G1tensor(301),G0tensor(1347),G0tensor(792) &
    ,G0tensor(374),G0tensor(33)])
  call ol_merge_tensors(G2tensor(198),[G2tensor(297),G1tensor(1070),G1tensor(1054),G1tensor(239),G0tensor(1428),G0tensor(1362) &
    ,G0tensor(385)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(300),G1tensor(1134),G1tensor(1085),G0tensor(1502),G0tensor(1453)])
  call ol_merge_tensors(G2tensor(147),[G2tensor(303),G1tensor(1030),G1tensor(1025),G1tensor(364),G1tensor(144),G0tensor(1338) &
    ,G0tensor(1333),G0tensor(347),G0tensor(342)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(306),G1tensor(1040),G1tensor(495),G1tensor(203),G1tensor(275),G0tensor(1348) &
    ,G0tensor(1027),G0tensor(608),G0tensor(357),G0tensor(352)])
  call ol_merge_tensors(G2tensor(212),[G2tensor(209),G2tensor(337),G2tensor(307),G1tensor(972),G1tensor(962),G1tensor(183) &
    ,G1tensor(143),G1tensor(47),G0tensor(1280),G0tensor(1270),G0tensor(360),G0tensor(340),G0tensor(300)])
  call ol_merge_tensors(G2tensor(356),[G2tensor(309),G1tensor(472),G1tensor(351),G1tensor(582),G1tensor(422),G1tensor(282) &
    ,G1tensor(205),G0tensor(588),G0tensor(532),G0tensor(222),G0tensor(143),G0tensor(117),G0tensor(17)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(312),G1tensor(1139),G1tensor(1130),G0tensor(1507),G0tensor(1498)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(315),G1tensor(990),G1tensor(985),G1tensor(255),G1tensor(353),G0tensor(1298) &
    ,G0tensor(1293),G0tensor(387),G0tensor(382)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(318),G1tensor(1000),G1tensor(418),G1tensor(323),G1tensor(382),G0tensor(1308) &
    ,G0tensor(872),G0tensor(508),G0tensor(397),G0tensor(392)])
  call ol_merge_tensors(G2tensor(216),[G2tensor(30),G2tensor(355),G2tensor(319),G1tensor(982),G1tensor(977),G1tensor(257) &
    ,G1tensor(237),G1tensor(87),G0tensor(1290),G0tensor(1285),G0tensor(400),G0tensor(380),G0tensor(315)])
  call ol_merge_tensors(G2tensor(308),[G2tensor(321),G1tensor(520),G1tensor(322),G1tensor(38),G1tensor(13),G1tensor(421) &
    ,G1tensor(265),G0tensor(642),G0tensor(503),G0tensor(237),G0tensor(207),G0tensor(53),G0tensor(27)])
  call ol_merge_tensors(G2tensor(324),[G1tensor(1144),G1tensor(455),G1tensor(437),G0tensor(1512),G0tensor(987),G0tensor(587) &
    ,G0tensor(583)])
  call ol_merge_tensors(G2tensor(168),[G2tensor(203),G2tensor(343),G2tensor(325),G1tensor(1157),G1tensor(1147),G0tensor(1525) &
    ,G0tensor(1515)])
  call ol_merge_tensors(G2tensor(327),[G1tensor(1149),G1tensor(411),G1tensor(405),G0tensor(1517),G0tensor(967),G0tensor(572) &
    ,G0tensor(568)])
  call ol_merge_tensors(G2tensor(215),[G2tensor(33),G2tensor(346),G2tensor(328),G1tensor(1162),G1tensor(1152),G0tensor(1530) &
    ,G0tensor(1520)])
  call ol_merge_tensors(G2tensor(330),[G1tensor(1064),G1tensor(1024),G1tensor(184),G0tensor(1412),G0tensor(1332),G0tensor(363)])
  call ol_merge_tensors(G2tensor(221),[G2tensor(211),G2tensor(349),G2tensor(331),G1tensor(1072),G1tensor(1067),G0tensor(1430) &
    ,G0tensor(1415)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(333),G1tensor(1050),G1tensor(1045),G1tensor(141),G1tensor(561),G0tensor(1358) &
    ,G0tensor(1353),G0tensor(327),G0tensor(322)])
  call ol_merge_tensors(G2tensor(220),[G2tensor(336),G1tensor(1060),G1tensor(387),G1tensor(341),G1tensor(136),G0tensor(1368) &
    ,G0tensor(927),G0tensor(543),G0tensor(337),G0tensor(332)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(339),G1tensor(533),G1tensor(321),G1tensor(8),G1tensor(459),G1tensor(535) &
    ,G1tensor(175),G0tensor(648),G0tensor(497),G0tensor(262),G0tensor(188),G0tensor(72),G0tensor(12)])
  call ol_merge_tensors(G2tensor(342),[G1tensor(1154),G1tensor(310),G1tensor(305),G0tensor(1522),G0tensor(842),G0tensor(502) &
    ,G0tensor(498)])
  call ol_merge_tensors(G2tensor(345),[G1tensor(1159),G1tensor(286),G0tensor(1527),G0tensor(822),G0tensor(487),G0tensor(483)])
  call ol_merge_tensors(G2tensor(348),[G1tensor(1069),G1tensor(984),G1tensor(111),G0tensor(1427),G0tensor(1292),G0tensor(323)])
  call ol_merge_tensors(G2tensor(332),[G2tensor(351),G1tensor(1010),G1tensor(1005),G1tensor(191),G1tensor(215),G0tensor(1318) &
    ,G0tensor(1313),G0tensor(367),G0tensor(362)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(354),G1tensor(1020),G1tensor(267),G1tensor(214),G1tensor(208),G0tensor(1328) &
    ,G0tensor(797),G0tensor(473),G0tensor(377),G0tensor(372)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(357),G1tensor(447),G1tensor(449),G1tensor(22),G1tensor(300),G1tensor(76) &
    ,G1tensor(235),G0tensor(582),G0tensor(538),G0tensor(287),G0tensor(162),G0tensor(98),G0tensor(22)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(1080),G1tensor(774),G1tensor(108),G0tensor(1448),G0tensor(1082),G0tensor(2)])
  call ol_merge_tensors(G1tensor(782),[G1tensor(121),G0tensor(1090),G0tensor(3)])
  call ol_merge_tensors(G1tensor(787),[G1tensor(127),G0tensor(1095),G0tensor(4)])
  call ol_merge_tensors(G2tensor(90),[G1tensor(1125),G1tensor(794),G1tensor(145),G0tensor(1493),G0tensor(1102),G0tensor(7)])
  call ol_merge_tensors(G1tensor(802),[G1tensor(151),G0tensor(1110),G0tensor(8)])
  call ol_merge_tensors(G1tensor(807),[G1tensor(157),G0tensor(1115),G0tensor(9)])
  call ol_merge_tensors(G2tensor(195),[G1tensor(649),G1tensor(339),G1tensor(181),G0tensor(837),G0tensor(505),G0tensor(13)])
  call ol_merge_tensors(G2tensor(165),[G1tensor(689),G1tensor(407),G1tensor(211),G0tensor(902),G0tensor(540),G0tensor(18)])
  call ol_merge_tensors(G2tensor(338),[G1tensor(729),G1tensor(482),G1tensor(241),G0tensor(982),G0tensor(590),G0tensor(23)])
  call ol_merge_tensors(G2tensor(186),[G1tensor(764),G1tensor(544),G1tensor(271),G0tensor(1062),G0tensor(650),G0tensor(28)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(268),G1tensor(167),G1tensor(325),G1tensor(295),G0tensor(475),G0tensor(358) &
    ,G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G1tensor(629),[G1tensor(577),G1tensor(307),G0tensor(802),G0tensor(604),G0tensor(514),G0tensor(479) &
    ,G0tensor(79),G0tensor(34)])
  call ol_merge_tensors(G1tensor(574),[G1tensor(18),G1tensor(313),G0tensor(692),G0tensor(455),G0tensor(420),G0tensor(415) &
    ,G0tensor(125),G0tensor(35)])
  call ol_merge_tensors(G1tensor(789),[G1tensor(777),G1tensor(627),G1tensor(331),G0tensor(1097),G0tensor(1085),G0tensor(799) &
    ,G0tensor(795),G0tensor(38)])
  call ol_merge_tensors(G1tensor(632),[G1tensor(607),G1tensor(337),G0tensor(1014),G0tensor(879),G0tensor(809),G0tensor(805) &
    ,G0tensor(84),G0tensor(39)])
  call ol_merge_tensors(G1tensor(622),[G1tensor(579),G1tensor(563),G1tensor(27),G1tensor(343),G0tensor(770),G0tensor(705) &
    ,G0tensor(700),G0tensor(695),G0tensor(130),G0tensor(40)])
  call ol_merge_tensors(G2tensor(122),[G1tensor(385),G1tensor(355),G0tensor(485),G0tensor(47),G0tensor(42)])
  call ol_merge_tensors(G2tensor(120),[G1tensor(634),G1tensor(287),G1tensor(361),G0tensor(812),G0tensor(489),G0tensor(43)])
  call ol_merge_tensors(G1tensor(581),[G1tensor(366),G1tensor(367),G0tensor(722),G0tensor(464),G0tensor(434),G0tensor(429) &
    ,G0tensor(134),G0tensor(44)])
  call ol_merge_tensors(G1tensor(639),[G1tensor(260),G1tensor(373),G0tensor(827),G0tensor(565),G0tensor(530),G0tensor(495) &
    ,G0tensor(90),G0tensor(45)])
  call ol_merge_tensors(G1tensor(647),[G1tensor(637),G1tensor(511),G1tensor(391),G0tensor(844),G0tensor(835),G0tensor(824) &
    ,G0tensor(815),G0tensor(68),G0tensor(48)])
  call ol_merge_tensors(G1tensor(592),[G1tensor(72),G1tensor(397),G0tensor(789),G0tensor(744),G0tensor(734),G0tensor(725) &
    ,G0tensor(139),G0tensor(49)])
  call ol_merge_tensors(G1tensor(897),[G1tensor(827),G1tensor(642),G1tensor(103),G1tensor(49),G1tensor(77),G1tensor(403) &
    ,G0tensor(1205),G0tensor(1135),G0tensor(955),G0tensor(830),G0tensor(260),G0tensor(220),G0tensor(95),G0tensor(50)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(466),G1tensor(445),G1tensor(415),G0tensor(499),G0tensor(57),G0tensor(52)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(654),G1tensor(468),G1tensor(71),G1tensor(487),G1tensor(427),G0tensor(847) &
    ,G0tensor(154),G0tensor(144),G0tensor(64),G0tensor(54)])
  call ol_merge_tensors(G1tensor(869),[G1tensor(618),G1tensor(451),G0tensor(1177),G0tensor(843),G0tensor(240),G0tensor(58)])
  call ol_merge_tensors(G1tensor(657),[G1tensor(153),G1tensor(458),G1tensor(517),G1tensor(457),G0tensor(850),G0tensor(159) &
    ,G0tensor(149),G0tensor(69),G0tensor(59)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(460),G1tensor(505),G1tensor(475),G0tensor(500),G0tensor(67),G0tensor(62)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(644),G1tensor(311),G1tensor(481),G0tensor(832),G0tensor(504),G0tensor(63)])
  call ol_merge_tensors(G1tensor(912),[G1tensor(842),G1tensor(667),G1tensor(294),G1tensor(278),G1tensor(553),G1tensor(523) &
    ,G0tensor(1220),G0tensor(1150),G0tensor(860),G0tensor(120),G0tensor(115),G0tensor(75),G0tensor(70)])
  call ol_merge_tensors(G1tensor(902),[G1tensor(652),G1tensor(541),G0tensor(1210),G0tensor(845),G0tensor(840),G0tensor(73)])
  call ol_merge_tensors(G2tensor(194),[G1tensor(340),G1tensor(221),G1tensor(595),G1tensor(565),G0tensor(510),G0tensor(338) &
    ,G0tensor(82),G0tensor(77)])
  call ol_merge_tensors(G1tensor(1059),[G1tensor(674),G1tensor(250),G1tensor(571),G0tensor(1367),G0tensor(867),G0tensor(394) &
    ,G0tensor(78)])
  call ol_merge_tensors(G1tensor(598),[G1tensor(510),G1tensor(583),G0tensor(737),G0tensor(470),G0tensor(440),G0tensor(435) &
    ,G0tensor(170),G0tensor(80)])
  call ol_merge_tensors(G1tensor(677),[G1tensor(601),G0tensor(874),G0tensor(870),G0tensor(83)])
  call ol_merge_tensors(G1tensor(927),[G1tensor(887),G1tensor(605),G1tensor(110),G1tensor(31),G1tensor(518),G1tensor(613) &
    ,G0tensor(1235),G0tensor(1195),G0tensor(745),G0tensor(740),G0tensor(275),G0tensor(250),G0tensor(175),G0tensor(85)])
  call ol_merge_tensors(G2tensor(189),[G1tensor(1150),G1tensor(109),G1tensor(486),G0tensor(1518),G0tensor(520),G0tensor(92) &
    ,G0tensor(87)])
  call ol_merge_tensors(G1tensor(679),[G1tensor(492),G0tensor(882),G0tensor(524),G0tensor(88)])
  call ol_merge_tensors(G1tensor(551),[G1tensor(522),G1tensor(39),G0tensor(677),G0tensor(449),G0tensor(414),G0tensor(409) &
    ,G0tensor(179),G0tensor(89)])
  call ol_merge_tensors(G1tensor(687),[G1tensor(682),G1tensor(534),G1tensor(320),G0tensor(909),G0tensor(900),G0tensor(894) &
    ,G0tensor(885),G0tensor(113),G0tensor(93)])
  call ol_merge_tensors(G1tensor(587),[G1tensor(171),G1tensor(21),G0tensor(764),G0tensor(699),G0tensor(689),G0tensor(680) &
    ,G0tensor(184),G0tensor(94)])
  call ol_merge_tensors(G1tensor(363),[G1tensor(50),G1tensor(54),G0tensor(534),G0tensor(102),G0tensor(97)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(694),G1tensor(123),G1tensor(453),G1tensor(252),G1tensor(470),G0tensor(912) &
    ,G0tensor(199),G0tensor(189),G0tensor(109),G0tensor(99)])
  call ol_merge_tensors(G1tensor(949),[G1tensor(573),G1tensor(222),G0tensor(1257),G0tensor(908),G0tensor(290),G0tensor(103)])
  call ol_merge_tensors(G1tensor(697),[G1tensor(303),G1tensor(540),G1tensor(264),G1tensor(230),G0tensor(915),G0tensor(204) &
    ,G0tensor(194),G0tensor(114),G0tensor(104)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(1145),G1tensor(358),G1tensor(258),G1tensor(248),G0tensor(1513),G0tensor(535) &
    ,G0tensor(112),G0tensor(107)])
  call ol_merge_tensors(G2tensor(169),[G1tensor(684),G1tensor(443),G1tensor(116),G0tensor(897),G0tensor(539),G0tensor(108)])
  call ol_merge_tensors(G1tensor(832),[G1tensor(692),G1tensor(290),G0tensor(1140),G0tensor(910),G0tensor(905),G0tensor(118)])
  call ol_merge_tensors(G2tensor(180),[G1tensor(393),G1tensor(317),G1tensor(504),G1tensor(30),G0tensor(545),G0tensor(398) &
    ,G0tensor(127),G0tensor(122)])
  call ol_merge_tensors(G1tensor(709),[G1tensor(189),G1tensor(314),G0tensor(932),G0tensor(614),G0tensor(564),G0tensor(549) &
    ,G0tensor(169),G0tensor(124)])
  call ol_merge_tensors(G1tensor(809),[G1tensor(797),G1tensor(707),G1tensor(324),G0tensor(1117),G0tensor(1105),G0tensor(929) &
    ,G0tensor(925),G0tensor(128)])
  call ol_merge_tensors(G1tensor(712),[G1tensor(243),G1tensor(338),G0tensor(1034),G0tensor(954),G0tensor(939),G0tensor(935) &
    ,G0tensor(174),G0tensor(129)])
  call ol_merge_tensors(G2tensor(205),[G1tensor(429),G1tensor(384),G1tensor(362),G0tensor(570),G0tensor(137),G0tensor(132)])
  call ol_merge_tensors(G2tensor(202),[G1tensor(714),G1tensor(412),G1tensor(45),G0tensor(957),G0tensor(574),G0tensor(133)])
  call ol_merge_tensors(G1tensor(719),[G1tensor(204),G1tensor(380),G0tensor(972),G0tensor(640),G0tensor(605),G0tensor(580) &
    ,G0tensor(180),G0tensor(135)])
  call ol_merge_tensors(G1tensor(727),[G1tensor(717),G1tensor(357),G1tensor(386),G0tensor(989),G0tensor(980),G0tensor(969) &
    ,G0tensor(960),G0tensor(158),G0tensor(138)])
  call ol_merge_tensors(G1tensor(937),[G1tensor(857),G1tensor(722),G1tensor(16),G1tensor(608),G1tensor(528),G1tensor(390) &
    ,G0tensor(1245),G0tensor(1165),G0tensor(1015),G0tensor(975),G0tensor(285),G0tensor(235),G0tensor(185),G0tensor(140)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(465),G1tensor(93),G1tensor(396),G0tensor(584),G0tensor(147),G0tensor(142)])
  call ol_merge_tensors(G1tensor(839),[G1tensor(96),G1tensor(444),G0tensor(1147),G0tensor(988),G0tensor(225),G0tensor(148)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(454),G1tensor(494),G1tensor(464),G0tensor(585),G0tensor(157),G0tensor(152)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(724),G1tensor(461),G1tensor(107),G0tensor(977),G0tensor(589),G0tensor(153)])
  call ol_merge_tensors(G1tensor(952),[G1tensor(872),G1tensor(742),G1tensor(560),G1tensor(554),G1tensor(375),G1tensor(147) &
    ,G0tensor(1260),G0tensor(1180),G0tensor(1000),G0tensor(210),G0tensor(205),G0tensor(165),G0tensor(160)])
  call ol_merge_tensors(G1tensor(942),[G1tensor(732),G1tensor(500),G0tensor(1250),G0tensor(990),G0tensor(985),G0tensor(163)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(497),G1tensor(231),G1tensor(512),G1tensor(225),G0tensor(610),G0tensor(378) &
    ,G0tensor(172),G0tensor(167)])
  call ol_merge_tensors(G1tensor(1019),[G1tensor(749),G1tensor(155),G1tensor(195),G0tensor(1327),G0tensor(1022),G0tensor(354) &
    ,G0tensor(168)])
  call ol_merge_tensors(G1tensor(752),[G1tensor(249),G0tensor(1029),G0tensor(1025),G0tensor(173)])
  call ol_merge_tensors(G2tensor(197),[G1tensor(1160),G1tensor(519),G1tensor(435),G1tensor(213),G0tensor(1528),G0tensor(630) &
    ,G0tensor(182),G0tensor(177)])
  call ol_merge_tensors(G1tensor(754),[G1tensor(207),G0tensor(1042),G0tensor(634),G0tensor(178)])
  call ol_merge_tensors(G1tensor(762),[G1tensor(757),G1tensor(309),G1tensor(177),G0tensor(1069),G0tensor(1060),G0tensor(1054) &
    ,G0tensor(1045),G0tensor(203),G0tensor(183)])
  call ol_merge_tensors(G1tensor(525),[G1tensor(333),G1tensor(530),G0tensor(644),G0tensor(192),G0tensor(187)])
  call ol_merge_tensors(G1tensor(909),[G1tensor(597),G1tensor(327),G0tensor(1217),G0tensor(1068),G0tensor(265),G0tensor(193)])
  call ol_merge_tensors(G2tensor(138),[G1tensor(1155),G1tensor(527),G1tensor(548),G1tensor(285),G0tensor(1523),G0tensor(645) &
    ,G0tensor(202),G0tensor(197)])
  call ol_merge_tensors(G2tensor(96),[G1tensor(759),G1tensor(537),G1tensor(129),G0tensor(1057),G0tensor(649),G0tensor(198)])
  call ol_merge_tensors(G1tensor(862),[G1tensor(767),G1tensor(564),G0tensor(1170),G0tensor(1070),G0tensor(1065),G0tensor(208)])
  call ol_merge_tensors(G1tensor(199),[G1tensor(785),G1tensor(780),G1tensor(423),G1tensor(394),G1tensor(100),G1tensor(570) &
    ,G1tensor(2),G0tensor(1387),G0tensor(1383),G0tensor(1093),G0tensor(1088),G0tensor(573),G0tensor(552),G0tensor(527) &
    ,G0tensor(517),G0tensor(428),G0tensor(318),G0tensor(217),G0tensor(212)])
  call ol_merge_tensors(G1tensor(844),[G1tensor(814),G1tensor(715),G1tensor(635),G1tensor(586),G1tensor(594),G1tensor(566) &
    ,G0tensor(1152),G0tensor(1122),G0tensor(958),G0tensor(813),G0tensor(723),G0tensor(708),G0tensor(228),G0tensor(213)])
  call ol_merge_tensors(G1tensor(819),[G1tensor(671),G1tensor(170),G0tensor(1127),G0tensor(963),G0tensor(864),G0tensor(728) &
    ,G0tensor(713),G0tensor(214)])
  call ol_merge_tensors(G1tensor(824),[G1tensor(85),G0tensor(1132),G0tensor(968),G0tensor(733),G0tensor(718),G0tensor(215)])
  call ol_merge_tensors(G1tensor(817),[G1tensor(572),G0tensor(1125),G0tensor(950),G0tensor(895),G0tensor(890),G0tensor(218)])
  call ol_merge_tensors(G1tensor(822),[G1tensor(575),G1tensor(146),G0tensor(1130),G0tensor(940),G0tensor(704),G0tensor(690) &
    ,G0tensor(685),G0tensor(219)])
  call ol_merge_tensors(G1tensor(859),[G1tensor(829),G1tensor(725),G1tensor(655),G1tensor(645),G1tensor(612),G1tensor(584) &
    ,G0tensor(1167),G0tensor(1137),G0tensor(978),G0tensor(848),G0tensor(833),G0tensor(238),G0tensor(223)])
  call ol_merge_tensors(G2tensor(162),[G1tensor(834),G1tensor(735),G1tensor(730),G1tensor(326),G0tensor(1142),G0tensor(993) &
    ,G0tensor(983),G0tensor(224)])
  call ol_merge_tensors(G1tensor(289),[G1tensor(805),G1tensor(800),G1tensor(539),G1tensor(513),G1tensor(297),G1tensor(555) &
    ,G1tensor(600),G1tensor(590),G0tensor(1407),G0tensor(1403),G0tensor(1113),G0tensor(1108),G0tensor(652),G0tensor(637) &
    ,G0tensor(627),G0tensor(488),G0tensor(463),G0tensor(303),G0tensor(232),G0tensor(227)])
  call ol_merge_tensors(G1tensor(849),[G1tensor(746),G1tensor(596),G0tensor(1157),G0tensor(1019),G0tensor(818),G0tensor(783) &
    ,G0tensor(773),G0tensor(229)])
  call ol_merge_tensors(G1tensor(854),[G1tensor(410),G0tensor(1162),G0tensor(823),G0tensor(788),G0tensor(778),G0tensor(230)])
  call ol_merge_tensors(G1tensor(847),[G1tensor(602),G0tensor(1155),G0tensor(1080),G0tensor(1055),G0tensor(1050),G0tensor(233)])
  call ol_merge_tensors(G1tensor(852),[G1tensor(617),G1tensor(606),G0tensor(1160),G0tensor(810),G0tensor(769),G0tensor(765) &
    ,G0tensor(760),G0tensor(234)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(864),G1tensor(660),G1tensor(650),G1tensor(614),G0tensor(1172),G0tensor(853) &
    ,G0tensor(838),G0tensor(239)])
  call ol_merge_tensors(G1tensor(491),[G1tensor(406),G1tensor(97),G1tensor(266),G0tensor(1417),G0tensor(658),G0tensor(607) &
    ,G0tensor(478),G0tensor(467),G0tensor(457),G0tensor(373),G0tensor(247),G0tensor(242)])
  call ol_merge_tensors(G1tensor(874),[G1tensor(675),G1tensor(670),G1tensor(630),G1tensor(625),G1tensor(5),G0tensor(1182) &
    ,G0tensor(1003),G0tensor(868),G0tensor(863),G0tensor(803),G0tensor(793),G0tensor(243)])
  call ol_merge_tensors(G1tensor(879),[G1tensor(61),G1tensor(624),G0tensor(1187),G0tensor(1048),G0tensor(758),G0tensor(748) &
    ,G0tensor(254),G0tensor(244)])
  call ol_merge_tensors(G1tensor(884),[G1tensor(11),G0tensor(1192),G0tensor(1078),G0tensor(808),G0tensor(798),G0tensor(245)])
  call ol_merge_tensors(G1tensor(877),[G1tensor(25),G0tensor(1185),G0tensor(1030),G0tensor(780),G0tensor(775),G0tensor(248)])
  call ol_merge_tensors(G1tensor(882),[G1tensor(56),G1tensor(118),G0tensor(1190),G0tensor(1035),G0tensor(790),G0tensor(785) &
    ,G0tensor(259),G0tensor(249)])
  call ol_merge_tensors(G1tensor(319),[G1tensor(502),G1tensor(609),G1tensor(89),G1tensor(55),G0tensor(1422),G0tensor(633) &
    ,G0tensor(617),G0tensor(492),G0tensor(482),G0tensor(448),G0tensor(308),G0tensor(257),G0tensor(252)])
  call ol_merge_tensors(G1tensor(929),[G1tensor(889),G1tensor(755),G1tensor(680),G1tensor(568),G1tensor(60),G1tensor(14) &
    ,G0tensor(1237),G0tensor(1197),G0tensor(1043),G0tensor(883),G0tensor(678),G0tensor(663),G0tensor(278),G0tensor(253)])
  call ol_merge_tensors(G1tensor(894),[G1tensor(9),G0tensor(1202),G0tensor(1053),G0tensor(763),G0tensor(753),G0tensor(255)])
  call ol_merge_tensors(G1tensor(892),[G1tensor(91),G0tensor(1200),G0tensor(1040),G0tensor(825),G0tensor(820),G0tensor(258)])
  call ol_merge_tensors(G1tensor(939),[G1tensor(899),G1tensor(760),G1tensor(695),G1tensor(685),G1tensor(35),G1tensor(75) &
    ,G0tensor(1247),G0tensor(1207),G0tensor(1058),G0tensor(913),G0tensor(898),G0tensor(288),G0tensor(263)])
  call ol_merge_tensors(G1tensor(424),[G1tensor(130),G1tensor(92),G1tensor(113),G0tensor(1432),G0tensor(558),G0tensor(548) &
    ,G0tensor(507),G0tensor(437),G0tensor(422),G0tensor(333),G0tensor(272),G0tensor(267)])
  call ol_merge_tensors(G1tensor(914),[G1tensor(750),G1tensor(745),G1tensor(710),G1tensor(705),G1tensor(44),G0tensor(1222) &
    ,G0tensor(1023),G0tensor(1018),G0tensor(943),G0tensor(933),G0tensor(923),G0tensor(268)])
  call ol_merge_tensors(G1tensor(919),[G1tensor(66),G1tensor(224),G0tensor(1227),G0tensor(888),G0tensor(683),G0tensor(668) &
    ,G0tensor(279),G0tensor(269)])
  call ol_merge_tensors(G1tensor(924),[G1tensor(74),G0tensor(1232),G0tensor(948),G0tensor(938),G0tensor(928),G0tensor(270)])
  call ol_merge_tensors(G1tensor(917),[G1tensor(104),G0tensor(1225),G0tensor(875),G0tensor(720),G0tensor(715),G0tensor(273)])
  call ol_merge_tensors(G1tensor(922),[G1tensor(302),G1tensor(242),G0tensor(1230),G0tensor(880),G0tensor(735),G0tensor(730) &
    ,G0tensor(284),G0tensor(274)])
  call ol_merge_tensors(G1tensor(349),[G1tensor(484),G1tensor(389),G1tensor(82),G1tensor(12),G1tensor(17),G0tensor(1437) &
    ,G0tensor(592),G0tensor(577),G0tensor(567),G0tensor(523),G0tensor(408),G0tensor(293),G0tensor(282),G0tensor(277)])
  call ol_merge_tensors(G1tensor(934),[G1tensor(23),G0tensor(1242),G0tensor(893),G0tensor(688),G0tensor(673),G0tensor(280)])
  call ol_merge_tensors(G1tensor(932),[G1tensor(106),G0tensor(1240),G0tensor(1010),G0tensor(970),G0tensor(965),G0tensor(283)])
  call ol_merge_tensors(G1tensor(51),[G1tensor(41),G1tensor(33),G0tensor(777),G0tensor(672),G0tensor(458),G0tensor(403) &
    ,G0tensor(302),G0tensor(297),G0tensor(292)])
  call ol_merge_tensors(G1tensor(954),[G1tensor(65),G1tensor(102),G0tensor(1262),G0tensor(662),G0tensor(413),G0tensor(309) &
    ,G0tensor(294)])
  call ol_merge_tensors(G1tensor(959),[G1tensor(142),G1tensor(40),G0tensor(1267),G0tensor(667),G0tensor(418),G0tensor(335) &
    ,G0tensor(295)])
  call ol_merge_tensors(G1tensor(549),[G1tensor(489),G1tensor(70),G0tensor(1012),G0tensor(655),G0tensor(602),G0tensor(595) &
    ,G0tensor(298)])
  call ol_merge_tensors(G1tensor(967),[G1tensor(957),G1tensor(78),G1tensor(88),G0tensor(1275),G0tensor(1265),G0tensor(314) &
    ,G0tensor(299)])
  call ol_merge_tensors(G1tensor(964),[G1tensor(95),G1tensor(58),G0tensor(1272),G0tensor(707),G0tensor(433),G0tensor(319) &
    ,G0tensor(304)])
  call ol_merge_tensors(G1tensor(969),[G1tensor(425),G1tensor(59),G0tensor(1277),G0tensor(772),G0tensor(468),G0tensor(355) &
    ,G0tensor(305)])
  call ol_merge_tensors(G1tensor(117),[G1tensor(567),G1tensor(63),G0tensor(752),G0tensor(717),G0tensor(443),G0tensor(423) &
    ,G0tensor(317),G0tensor(312),G0tensor(307)])
  call ol_merge_tensors(G1tensor(974),[G1tensor(274),G1tensor(81),G0tensor(1282),G0tensor(747),G0tensor(453),G0tensor(375) &
    ,G0tensor(310)])
  call ol_merge_tensors(G1tensor(508),[G1tensor(467),G1tensor(90),G0tensor(952),G0tensor(620),G0tensor(562),G0tensor(555) &
    ,G0tensor(313)])
  call ol_merge_tensors(G1tensor(979),[G1tensor(262),G1tensor(452),G0tensor(1287),G0tensor(712),G0tensor(438),G0tensor(395) &
    ,G0tensor(320)])
  call ol_merge_tensors(G2tensor(192),[G1tensor(987),G1tensor(125),G0tensor(1295),G0tensor(328)])
  call ol_merge_tensors(G1tensor(1004),[G1tensor(159),G0tensor(1312),G0tensor(343)])
  call ol_merge_tensors(G1tensor(1009),[G1tensor(148),G0tensor(1317),G0tensor(344)])
  call ol_merge_tensors(G2tensor(158),[G1tensor(1007),G1tensor(232),G0tensor(1315),G0tensor(348)])
  call ol_merge_tensors(G2tensor(164),[G2tensor(159),G2tensor(131),G2tensor(68),G1tensor(1084),G1tensor(1079),G1tensor(1074) &
    ,G1tensor(1022),G1tensor(1012),G1tensor(161),G1tensor(196),G0tensor(1452),G0tensor(1447),G0tensor(1442),G0tensor(1330) &
    ,G0tensor(1320),G0tensor(359),G0tensor(349)])
  call ol_merge_tensors(G1tensor(744),[G1tensor(615),G1tensor(273),G1tensor(166),G0tensor(1017),G0tensor(767),G0tensor(623) &
    ,G0tensor(613),G0tensor(472),G0tensor(452),G0tensor(442),G0tensor(353)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(1027),G1tensor(238),G0tensor(1335),G0tensor(368)])
  call ol_merge_tensors(G1tensor(1044),[G1tensor(299),G0tensor(1352),G0tensor(383)])
  call ol_merge_tensors(G1tensor(1049),[G1tensor(293),G0tensor(1357),G0tensor(384)])
  call ol_merge_tensors(G2tensor(173),[G1tensor(1047),G1tensor(244),G0tensor(1355),G0tensor(388)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(177),G2tensor(153),G2tensor(83),G1tensor(1129),G1tensor(1124),G1tensor(1119) &
    ,G1tensor(1062),G1tensor(1052),G1tensor(263),G1tensor(261),G0tensor(1497),G0tensor(1492),G0tensor(1487),G0tensor(1370) &
    ,G0tensor(1360),G0tensor(399),G0tensor(389)])
  call ol_merge_tensors(G1tensor(669),[G1tensor(569),G1tensor(365),G1tensor(256),G0tensor(862),G0tensor(702),G0tensor(598) &
    ,G0tensor(542),G0tensor(513),G0tensor(417),G0tensor(402),G0tensor(393)])
  call ol_merge_tensors(G1tensor(970),[G1tensor(545),G1tensor(279),G0tensor(1278),G0tensor(807),G0tensor(654),G0tensor(477) &
    ,G0tensor(474)])
  call ol_merge_tensors(G1tensor(315),[G0tensor(817),G0tensor(625),G0tensor(493),G0tensor(490)])
  call ol_merge_tensors(G1tensor(960),[G1tensor(488),G1tensor(352),G0tensor(1268),G0tensor(877),G0tensor(594),G0tensor(512) &
    ,G0tensor(509)])
  call ol_merge_tensors(G1tensor(359),[G1tensor(346),G0tensor(907),G0tensor(537),G0tensor(533)])
  call ol_merge_tensors(G1tensor(980),[G1tensor(473),G1tensor(376),G0tensor(1288),G0tensor(937),G0tensor(554),G0tensor(547) &
    ,G0tensor(544)])
  call ol_merge_tensors(G1tensor(965),[G1tensor(543),G1tensor(383),G0tensor(1273),G0tensor(1077),G0tensor(947),G0tensor(657) &
    ,G0tensor(653),G0tensor(557),G0tensor(553)])
  call ol_merge_tensors(G1tensor(400),[G0tensor(732),G0tensor(569),G0tensor(427),G0tensor(424)])
  call ol_merge_tensors(G1tensor(441),[G0tensor(962),G0tensor(600),G0tensor(578),G0tensor(575)])
  call ol_merge_tensors(G1tensor(955),[G1tensor(503),G1tensor(485),G0tensor(1263),G0tensor(1037),G0tensor(1007),G0tensor(622) &
    ,G0tensor(618),G0tensor(597),G0tensor(593)])
  call ol_merge_tensors(G1tensor(975),[G1tensor(507),G1tensor(496),G0tensor(1283),G0tensor(1032),G0tensor(619),G0tensor(612) &
    ,G0tensor(609)])
  call ol_merge_tensors(G1tensor(514),[G0tensor(1052),G0tensor(632),G0tensor(628)])
  call ol_merge_tensors(G1tensor(515),[G0tensor(762),G0tensor(629),G0tensor(447),G0tensor(444)])
  call ol_merge_tensors(G1tensor(532),[G1tensor(521),G0tensor(1067),G0tensor(647),G0tensor(643)])
  call ol_merge_tensors(G1tensor(169),[G1tensor(721),G1tensor(711),G1tensor(641),G1tensor(631),G1tensor(604),G1tensor(591) &
    ,G1tensor(599),G1tensor(556),G0tensor(1399),G0tensor(1394),G0tensor(1379),G0tensor(1374),G0tensor(974),G0tensor(934) &
    ,G0tensor(829),G0tensor(804),G0tensor(784),G0tensor(759),G0tensor(739),G0tensor(729),G0tensor(724),G0tensor(694),G0tensor(684) &
    ,G0tensor(679)])
  call ol_merge_tensors(G1tensor(706),[G1tensor(626),G1tensor(562),G0tensor(924),G0tensor(794),G0tensor(749),G0tensor(693) &
    ,G0tensor(669),G0tensor(664)])
  call ol_merge_tensors(G1tensor(623),[G0tensor(930),G0tensor(703),G0tensor(675),G0tensor(670)])
  call ol_merge_tensors(G1tensor(751),[G1tensor(676),G1tensor(603),G0tensor(1024),G0tensor(869),G0tensor(774),G0tensor(738) &
    ,G0tensor(714),G0tensor(709)])
  call ol_merge_tensors(G1tensor(616),[G0tensor(800),G0tensor(768),G0tensor(755),G0tensor(750)])
  call ol_merge_tensors(G1tensor(681),[G1tensor(640),G1tensor(636),G0tensor(944),G0tensor(889),G0tensor(884),G0tensor(828) &
    ,G0tensor(819),G0tensor(814)])
  call ol_merge_tensors(G1tensor(691),[G1tensor(686),G1tensor(665),G1tensor(651),G1tensor(646),G0tensor(904),G0tensor(899) &
    ,G0tensor(858),G0tensor(839),G0tensor(834)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(771),G1tensor(741),G1tensor(736),G1tensor(701),G1tensor(696),G1tensor(666) &
    ,G1tensor(661),G1tensor(656),G0tensor(1074),G0tensor(999),G0tensor(994),G0tensor(919),G0tensor(914),G0tensor(859) &
    ,G0tensor(854),G0tensor(849)])
  call ol_merge_tensors(G1tensor(672),[G0tensor(1008),G0tensor(878),G0tensor(873),G0tensor(865)])
  call ol_merge_tensors(G1tensor(756),[G1tensor(720),G1tensor(716),G0tensor(1049),G0tensor(1044),G0tensor(1004),G0tensor(973) &
    ,G0tensor(964),G0tensor(959)])
  call ol_merge_tensors(G1tensor(766),[G1tensor(761),G1tensor(740),G1tensor(731),G1tensor(726),G0tensor(1064),G0tensor(1059) &
    ,G0tensor(998),G0tensor(984),G0tensor(979)])
  call ol_merge_tensors(G1tensor(747),[G0tensor(1038),G0tensor(1033),G0tensor(1028),G0tensor(1020)])
  call ol_merge_tensors(G1tensor(779),[G1tensor(775),G0tensor(1087),G0tensor(1083)])
  call ol_merge_tensors(G1tensor(784),[G1tensor(776),G0tensor(1092),G0tensor(1084)])
  call ol_merge_tensors(G1tensor(790),[G1tensor(781),G0tensor(1098),G0tensor(1089)])
  call ol_merge_tensors(G1tensor(811),[G1tensor(806),G1tensor(791),G1tensor(786),G0tensor(1119),G0tensor(1114),G0tensor(1099) &
    ,G0tensor(1094)])
  call ol_merge_tensors(G1tensor(799),[G1tensor(795),G0tensor(1107),G0tensor(1103)])
  call ol_merge_tensors(G1tensor(804),[G1tensor(796),G0tensor(1112),G0tensor(1104)])
  call ol_merge_tensors(G1tensor(810),[G1tensor(801),G0tensor(1118),G0tensor(1109)])
  call ol_merge_tensors(G1tensor(820),[G1tensor(815),G0tensor(1128),G0tensor(1123)])
  call ol_merge_tensors(G1tensor(840),[G1tensor(831),G1tensor(825),G1tensor(816),G0tensor(1148),G0tensor(1139),G0tensor(1133) &
    ,G0tensor(1124)])
  call ol_merge_tensors(G1tensor(826),[G1tensor(821),G0tensor(1134),G0tensor(1129)])
  call ol_merge_tensors(G1tensor(835),[G1tensor(830),G0tensor(1143),G0tensor(1138)])
  call ol_merge_tensors(G1tensor(841),[G1tensor(836),G0tensor(1149),G0tensor(1144)])
  call ol_merge_tensors(G1tensor(850),[G1tensor(845),G0tensor(1158),G0tensor(1153)])
  call ol_merge_tensors(G1tensor(870),[G1tensor(861),G1tensor(855),G1tensor(846),G0tensor(1178),G0tensor(1169),G0tensor(1163) &
    ,G0tensor(1154)])
  call ol_merge_tensors(G1tensor(856),[G1tensor(851),G0tensor(1164),G0tensor(1159)])
  call ol_merge_tensors(G1tensor(865),[G1tensor(860),G0tensor(1173),G0tensor(1168)])
  call ol_merge_tensors(G1tensor(871),[G1tensor(866),G0tensor(1179),G0tensor(1174)])
  call ol_merge_tensors(G1tensor(890),[G1tensor(880),G1tensor(875),G0tensor(1198),G0tensor(1188),G0tensor(1183)])
  call ol_merge_tensors(G1tensor(885),[G1tensor(876),G0tensor(1193),G0tensor(1184)])
  call ol_merge_tensors(G1tensor(896),[G1tensor(886),G1tensor(881),G0tensor(1204),G0tensor(1194),G0tensor(1189)])
  call ol_merge_tensors(G1tensor(910),[G1tensor(901),G1tensor(895),G1tensor(891),G0tensor(1218),G0tensor(1209),G0tensor(1203) &
    ,G0tensor(1199)])
  call ol_merge_tensors(G2tensor(125),[G1tensor(905),G1tensor(900),G0tensor(1213),G0tensor(1208)])
  call ol_merge_tensors(G2tensor(128),[G1tensor(911),G1tensor(906),G0tensor(1219),G0tensor(1214)])
  call ol_merge_tensors(G1tensor(930),[G1tensor(920),G1tensor(915),G0tensor(1238),G0tensor(1228),G0tensor(1223)])
  call ol_merge_tensors(G1tensor(925),[G1tensor(916),G0tensor(1233),G0tensor(1224)])
  call ol_merge_tensors(G1tensor(936),[G1tensor(926),G1tensor(921),G0tensor(1244),G0tensor(1234),G0tensor(1229)])
  call ol_merge_tensors(G1tensor(950),[G1tensor(941),G1tensor(935),G1tensor(931),G0tensor(1258),G0tensor(1249),G0tensor(1243) &
    ,G0tensor(1239)])
  call ol_merge_tensors(G2tensor(144),[G1tensor(945),G1tensor(940),G0tensor(1253),G0tensor(1248)])
  call ol_merge_tensors(G2tensor(132),[G1tensor(951),G1tensor(946),G0tensor(1259),G0tensor(1254)])
  call ol_merge_tensors(G2tensor(141),[G1tensor(1041),G1tensor(1001),G1tensor(976),G1tensor(961),G1tensor(956),G0tensor(1349) &
    ,G0tensor(1309),G0tensor(1284),G0tensor(1269),G0tensor(1264)])
  call ol_merge_tensors(G1tensor(1061),[G1tensor(1021),G1tensor(981),G1tensor(971),G1tensor(966),G0tensor(1369),G0tensor(1329) &
    ,G0tensor(1289),G0tensor(1279),G0tensor(1274)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(995),G1tensor(986),G0tensor(1303),G0tensor(1294)])
  call ol_merge_tensors(G2tensor(135),[G1tensor(1036),G1tensor(1031),G1tensor(996),G1tensor(991),G0tensor(1344),G0tensor(1339) &
    ,G0tensor(1304),G0tensor(1299)])
  call ol_merge_tensors(G2tensor(143),[G1tensor(1015),G1tensor(1006),G0tensor(1323),G0tensor(1314)])
  call ol_merge_tensors(G2tensor(146),[G1tensor(1056),G1tensor(1051),G1tensor(1016),G1tensor(1011),G0tensor(1364),G0tensor(1359) &
    ,G0tensor(1324),G0tensor(1319)])
  call ol_merge_tensors(G2tensor(149),[G1tensor(1035),G1tensor(1026),G0tensor(1343),G0tensor(1334)])
  call ol_merge_tensors(G2tensor(152),[G1tensor(1055),G1tensor(1046),G0tensor(1363),G0tensor(1354)])
  call ol_merge_tensors(G2tensor(320),[G1tensor(1075),G0tensor(1443)])
  call ol_merge_tensors(G2tensor(116),[G1tensor(1121),G1tensor(1106),G1tensor(1091),G1tensor(1076),G0tensor(1489),G0tensor(1474) &
    ,G0tensor(1459),G0tensor(1444)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(1126),G1tensor(1111),G1tensor(1096),G1tensor(1081),G0tensor(1494),G0tensor(1479) &
    ,G0tensor(1464),G0tensor(1449)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(1131),G1tensor(1116),G1tensor(1101),G1tensor(1086),G0tensor(1499),G0tensor(1484) &
    ,G0tensor(1469),G0tensor(1454)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(1090),G0tensor(1458)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(1095),G0tensor(1463)])
  call ol_merge_tensors(G2tensor(225),[G1tensor(1100),G0tensor(1468)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(1105),G0tensor(1473)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(1110),G0tensor(1478)])
  call ol_merge_tensors(G2tensor(204),[G1tensor(1115),G0tensor(1483)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(1120),G0tensor(1488)])
  call ol_merge_tensors(G2tensor(155),[G1tensor(1135),G0tensor(1503)])
  call ol_merge_tensors(G2tensor(156),[G1tensor(1136),G0tensor(1504)])
  call ol_merge_tensors(G2tensor(170),[G1tensor(1140),G0tensor(1508)])
  call ol_merge_tensors(G2tensor(171),[G1tensor(1141),G0tensor(1509)])
  call ol_merge_tensors(G0tensor(687),[G0tensor(519),G0tensor(407),G0tensor(404)])
  call ol_merge_tensors(G0tensor(697),[G0tensor(445),G0tensor(412),G0tensor(405)])
  call ol_merge_tensors(G0tensor(682),[G0tensor(550),G0tensor(529),G0tensor(419),G0tensor(410)])
  call ol_merge_tensors(G0tensor(742),[G0tensor(460),G0tensor(432),G0tensor(425)])
  call ol_merge_tensors(G0tensor(727),[G0tensor(579),G0tensor(515),G0tensor(439),G0tensor(430)])
  call ol_merge_tensors(G0tensor(757),[G0tensor(639),G0tensor(480),G0tensor(454),G0tensor(450)])
  call ol_merge_tensors(G0tensor(787),[G0tensor(484),G0tensor(462),G0tensor(459)])
  call ol_merge_tensors(G0tensor(782),[G0tensor(615),G0tensor(494),G0tensor(469),G0tensor(465)])
  call ol_merge_tensors(G0tensor(892),[G0tensor(522),G0tensor(518)])
  call ol_merge_tensors(G0tensor(887),[G0tensor(560),G0tensor(528),G0tensor(525)])
  call ol_merge_tensors(G0tensor(942),[G0tensor(624),G0tensor(563),G0tensor(559)])
  call ol_merge_tensors(G0tensor(1002),[G0tensor(659),G0tensor(603),G0tensor(599)])
  call ol_merge_tensors(G0tensor(1047),[G0tensor(660),G0tensor(638),G0tensor(635)])
  call ol_merge_tensors(G0tensor(754),[G0tensor(698),G0tensor(674),G0tensor(665)])
  call ol_merge_tensors(G0tensor(779),[G0tensor(743),G0tensor(719),G0tensor(710)])
  call ol_merge_tensors(G0tensor(1039),[G0tensor(953),G0tensor(949),G0tensor(945)])
  call ol_merge_tensors(G0tensor(1079),[G0tensor(1013),G0tensor(1009),G0tensor(1005)])
  call ol_merge_tensors(G0tensor(1404),[G0tensor(1384)])
  call ol_merge_tensors(G0tensor(1425),[G0tensor(1390)])
  call ol_merge_tensors(G0tensor(1440),[G0tensor(1410)])
  call ol_merge_tensors(G0tensor(1424),[G0tensor(1419)])
  call ol_merge_tensors(G0tensor(1435),[G0tensor(1420)])
  call ol_merge_tensors(G0tensor(1439),[G0tensor(1434)])
  call ol_merge_tensors(G3tensor(18),[G3tensor(17)])
  call ol_merge_tensors(G3tensor(21),[G3tensor(19)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(22)])
  call ol_merge_tensors(G3tensor(30),[G3tensor(29)])
  call ol_merge_tensors(G3tensor(33),[G3tensor(32)])
  call ol_merge_tensors(G3tensor(36),[G3tensor(35)])
  call TI_triangle_red(G3tensor(40),RedBasis(112),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMW], &
    G0tensor(21))
  call TI_triangle_red(G3tensor(28),RedBasis(122),mass3set(:,1),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMW], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(184),RedBasis(2),mass3set(:,2),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1)
  call TI_triangle_red(G2tensor(104),RedBasis(2),mass3set(:,3),G0tensor(71),G0tensor(76),G0tensor(81),G0tensor(86),M2L1R1,[nMZ], &
    G0tensor(91))
  call TI_triangle_red(G2tensor(105),RedBasis(2),mass3set(:,4),G0tensor(96),G0tensor(101),G0tensor(106), &
    G0tensor(111),M2L1R1,[nMW],G0tensor(116))
  call TI_triangle_red(G2tensor(108),RedBasis(8),mass3set(:,2),G0tensor(121),G0tensor(126),G0tensor(131),G0tensor(136),M2L1R1)
  call TI_triangle_red(G2tensor(227),RedBasis(8),mass3set(:,3),G0tensor(141),G0tensor(146),G0tensor(151), &
    G0tensor(156),M2L1R1,[nMZ],G0tensor(161))
  call TI_triangle_red(G2tensor(111),RedBasis(8),mass3set(:,4),G0tensor(166),G0tensor(171),G0tensor(176), &
    G0tensor(181),M2L1R1,[nMW],G0tensor(186))
  call TI_triangle_red(G2tensor(208),RedBasis(111),mass3set(:,5),G0tensor(191),G0tensor(196),G0tensor(201), &
    G0tensor(206),M2L1R1,[nMW],G0tensor(211))
  call TI_triangle_red(G2tensor(178),RedBasis(16),mass3set(:,2),G0tensor(216),G0tensor(221),G0tensor(226),G0tensor(231),M2L1R1)
  call TI_triangle_red(G2tensor(126),RedBasis(16),mass3set(:,3),G0tensor(236),G0tensor(241),G0tensor(246), &
    G0tensor(251),M2L1R1,[nMZ],G0tensor(256))
  call TI_triangle_red(G2tensor(16),RedBasis(16),mass3set(:,4),G0tensor(261),G0tensor(266),G0tensor(271), &
    G0tensor(276),M2L1R1,[nMW],G0tensor(281))
  call TI_triangle_red(G2tensor(199),RedBasis(13),mass3set(:,2),G0tensor(286),G0tensor(291),G0tensor(296),G0tensor(301),M2L1R1)
  call TI_triangle_red(G2tensor(193),RedBasis(13),mass3set(:,3),G0tensor(306),G0tensor(311),G0tensor(316), &
    G0tensor(321),M2L1R1,[nMZ],G0tensor(326))
  call TI_triangle_red(G2tensor(181),RedBasis(13),mass3set(:,4),G0tensor(331),G0tensor(336),G0tensor(341), &
    G0tensor(346),M2L1R1,[nMW],G0tensor(351))
  call TI_triangle_red(G2tensor(176),RedBasis(121),mass3set(:,5),G0tensor(356),G0tensor(361),G0tensor(366), &
    G0tensor(371),M2L1R1,[nMW],G0tensor(376))
  call TI_triangle_red(G2tensor(129),RedBasis(16),mass3set(:,6),G0tensor(381),G0tensor(386),G0tensor(391), &
    G0tensor(396),M2L1R1,[nMW],G0tensor(401))
  call TI_triangle_red(G2tensor(167),RedBasis(116),mass3set(:,1),G0tensor(406),G0tensor(411),G0tensor(416), &
    G0tensor(421),M2L1R1,[nMW],G0tensor(426))
  call TI_triangle_red(G2tensor(107),RedBasis(2),mass3set(:,6),G0tensor(431),G0tensor(436),G0tensor(441), &
    G0tensor(446),M2L1R1,[nMW],G0tensor(451))
  call TI_triangle_red(G2tensor(12),RedBasis(8),mass3set(:,6),G0tensor(456),G0tensor(461),G0tensor(466), &
    G0tensor(471),M2L1R1,[nMW],G0tensor(476))
  call TI_triangle_red(G2tensor(188),RedBasis(125),mass3set(:,1),G0tensor(481),G0tensor(486),G0tensor(491), &
    G0tensor(496),M2L1R1,[nMW],G0tensor(501))
  call TI_triangle_red(G2tensor(23),RedBasis(13),mass3set(:,6),G0tensor(506),G0tensor(511),G0tensor(516), &
    G0tensor(521),M2L1R1,[nMW],G0tensor(526))
  call TI_triangle_red(G2tensor(117),RedBasis(66),mass3set(:,6),G0tensor(531),G0tensor(536),G0tensor(541), &
    G0tensor(546),M2L1R1,[nMW],G0tensor(551))
  call TI_triangle_red(G2tensor(113),RedBasis(41),mass3set(:,6),G0tensor(556),G0tensor(561),G0tensor(566), &
    G0tensor(571),M2L1R1,[nMW],G0tensor(576))
  call TI_triangle_red(G2tensor(276),RedBasis(158),mass3set(:,4),G0tensor(581),G0tensor(586),G0tensor(591), &
    G0tensor(596),M2L1R1,[nMW],G0tensor(601))
  call TI_triangle_red(G3tensor(34),RedBasis(112),mass3set(:,2),G0tensor(606),G0tensor(611),G0tensor(616),G0tensor(621),M2L1R1)
  call TI_triangle_red(G2tensor(123),RedBasis(145),mass3set(:,7),G0tensor(626),G0tensor(631),G0tensor(636), &
    G0tensor(641),M2L1R1,[nMW],G0tensor(646))
  call TI_triangle_red(G2tensor(210),RedBasis(111),mass3set(:,8),G0tensor(651),G0tensor(656),G0tensor(661), &
    G0tensor(666),M2L1R1,[nMW],G0tensor(671))
  call TI_triangle_red(G2tensor(282),RedBasis(158),mass3set(:,3),G0tensor(676),G0tensor(681),G0tensor(686), &
    G0tensor(691),M2L1R1,[nMZ],G0tensor(696))
  call TI_triangle_red(G2tensor(191),RedBasis(151),mass3set(:,7),G0tensor(701),G0tensor(706),G0tensor(711), &
    G0tensor(716),M2L1R1,[nMW],G0tensor(721))
  call TI_triangle_red(G2tensor(288),RedBasis(153),mass3set(:,4),G0tensor(726),G0tensor(731),G0tensor(736), &
    G0tensor(741),M2L1R1,[nMW],G0tensor(746))
  call TI_triangle_red(G3tensor(23),RedBasis(122),mass3set(:,2),G0tensor(751),G0tensor(756),G0tensor(761),G0tensor(766),M2L1R1)
  call TI_triangle_red(G2tensor(207),RedBasis(150),mass3set(:,7),G0tensor(771),G0tensor(776),G0tensor(781), &
    G0tensor(786),M2L1R1,[nMW],G0tensor(791))
  call TI_triangle_red(G2tensor(174),RedBasis(121),mass3set(:,8),G0tensor(796),G0tensor(801),G0tensor(806), &
    G0tensor(811),M2L1R1,[nMW],G0tensor(816))
  call TI_triangle_red(G2tensor(294),RedBasis(153),mass3set(:,3),G0tensor(821),G0tensor(826),G0tensor(831), &
    G0tensor(836),M2L1R1,[nMZ],G0tensor(841))
  call TI_triangle_red(G2tensor(198),RedBasis(148),mass3set(:,7),G0tensor(846),G0tensor(851),G0tensor(856), &
    G0tensor(861),M2L1R1,[nMW],G0tensor(866))
  call TI_triangle_red(G2tensor(75),RedBasis(41),mass3set(:,4),G0tensor(871),G0tensor(876),G0tensor(881), &
    G0tensor(886),M2L1R1,[nMW],G0tensor(891))
  call TI_triangle_red(G2tensor(147),RedBasis(106),mass3set(:,8),G0tensor(896),G0tensor(901),G0tensor(906), &
    G0tensor(911),M2L1R1,[nMW],G0tensor(916))
  call TI_triangle_red(G2tensor(150),RedBasis(106),mass3set(:,9),G0tensor(921),G0tensor(926),G0tensor(931), &
    G0tensor(936),M2L1R1,[nMZ],G0tensor(941))
  call TI_triangle_red(G2tensor(212),RedBasis(111),mass3set(:,9),G0tensor(946),G0tensor(951),G0tensor(956), &
    G0tensor(961),M2L1R1,[nMZ],G0tensor(966))
  call TI_triangle_red(G2tensor(356),RedBasis(106),mass3set(:,5),G0tensor(971),G0tensor(976),G0tensor(981), &
    G0tensor(986),M2L1R1,[nMW],G0tensor(991))
  call TI_triangle_red(G2tensor(92),RedBasis(66),mass3set(:,4),G0tensor(996),G0tensor(1001),G0tensor(1006), &
    G0tensor(1011),M2L1R1,[nMW],G0tensor(1016))
  call TI_triangle_red(G2tensor(134),RedBasis(110),mass3set(:,8),G0tensor(1021),G0tensor(1026),G0tensor(1031), &
    G0tensor(1036),M2L1R1,[nMW],G0tensor(1041))
  call TI_triangle_red(G2tensor(140),RedBasis(110),mass3set(:,9),G0tensor(1046),G0tensor(1051),G0tensor(1056), &
    G0tensor(1061),M2L1R1,[nMZ],G0tensor(1066))
  call TI_triangle_red(G2tensor(216),RedBasis(121),mass3set(:,9),G0tensor(1071),G0tensor(1076),G0tensor(1081), &
    G0tensor(1086),M2L1R1,[nMZ],G0tensor(1091))
  call TI_triangle_red(G2tensor(308),RedBasis(110),mass3set(:,5),G0tensor(1096),G0tensor(1101),G0tensor(1106), &
    G0tensor(1111),M2L1R1,[nMW],G0tensor(1116))
  call TI_triangle_red(G2tensor(324),RedBasis(154),mass3set(:,8),G0tensor(1121),G0tensor(1126),G0tensor(1131), &
    G0tensor(1136),M2L1R1,[nMW],G0tensor(1141))
  call TI_triangle_red(G2tensor(168),RedBasis(147),mass3set(:,8),G0tensor(1146),G0tensor(1151),G0tensor(1156), &
    G0tensor(1161),M2L1R1,[nMW],G0tensor(1166))
  call TI_triangle_red(G2tensor(327),RedBasis(154),mass3set(:,9),G0tensor(1171),G0tensor(1176),G0tensor(1181), &
    G0tensor(1186),M2L1R1,[nMZ],G0tensor(1191))
  call TI_triangle_red(G2tensor(215),RedBasis(147),mass3set(:,9),G0tensor(1196),G0tensor(1201),G0tensor(1206), &
    G0tensor(1211),M2L1R1,[nMZ],G0tensor(1216))
  call TI_triangle_red(G2tensor(330),RedBasis(154),mass3set(:,5),G0tensor(1221),G0tensor(1226),G0tensor(1231), &
    G0tensor(1236),M2L1R1,[nMW],G0tensor(1241))
  call TI_triangle_red(G2tensor(221),RedBasis(147),mass3set(:,5),G0tensor(1246),G0tensor(1251),G0tensor(1256), &
    G0tensor(1261),M2L1R1,[nMW],G0tensor(1266))
  call TI_triangle_red(G2tensor(7),RedBasis(128),mass3set(:,8),G0tensor(1271),G0tensor(1276),G0tensor(1281), &
    G0tensor(1286),M2L1R1,[nMW],G0tensor(1291))
  call TI_triangle_red(G2tensor(220),RedBasis(128),mass3set(:,9),G0tensor(1296),G0tensor(1301),G0tensor(1306), &
    G0tensor(1311),M2L1R1,[nMZ],G0tensor(1316))
  call TI_triangle_red(G2tensor(8),RedBasis(128),mass3set(:,5),G0tensor(1321),G0tensor(1326),G0tensor(1331), &
    G0tensor(1336),M2L1R1,[nMW],G0tensor(1341))
  call TI_triangle_red(G2tensor(342),RedBasis(159),mass3set(:,8),G0tensor(1346),G0tensor(1351),G0tensor(1356), &
    G0tensor(1361),M2L1R1,[nMW],G0tensor(1366))
  call TI_triangle_red(G2tensor(345),RedBasis(159),mass3set(:,9),G0tensor(1371),G0tensor(1376),G0tensor(1381), &
    G0tensor(1386),M2L1R1,[nMZ],G0tensor(1391))
  call TI_triangle_red(G2tensor(348),RedBasis(159),mass3set(:,5),G0tensor(1396),G0tensor(1401),G0tensor(1406), &
    G0tensor(1411),M2L1R1,[nMW],G0tensor(1416))
  call TI_triangle_red(G2tensor(332),RedBasis(120),mass3set(:,8),G0tensor(1421),G0tensor(1426),G0tensor(1431), &
    G0tensor(1436),M2L1R1,[nMW],G0tensor(1441))
  call TI_triangle_red(G2tensor(179),RedBasis(120),mass3set(:,9),G0tensor(1446),G0tensor(1451),G0tensor(1456), &
    G0tensor(1461),M2L1R1,[nMZ],G0tensor(1466))
  call TI_triangle_red(G2tensor(99),RedBasis(120),mass3set(:,5),G0tensor(1471),G0tensor(1476),G0tensor(1481), &
    G0tensor(1486),M2L1R1,[nMW],G0tensor(1491))
  call TI_triangle_red(G2tensor(74),RedBasis(41),mass3set(:,3),G0tensor(1496),G0tensor(1501),G0tensor(1506), &
    G0tensor(1511),M2L1R1,[nMZ],G0tensor(1516))
  call TI_triangle_red(G2tensor(90),RedBasis(66),mass3set(:,3),G0tensor(1521),G0tensor(1526),G0tensor(1414), &
    G0tensor(852),M2L1R1,[nMZ],G0tensor(55))
  call TI_triangle_red(G2tensor(195),RedBasis(114),mass3set(:,7),G0tensor(14),G0tensor(1429),G0tensor(992), &
    G0tensor(145),M2L1R1,[nMW],G0tensor(24))
  call TI_triangle_red(G2tensor(165),RedBasis(118),mass3set(:,7),G0tensor(1445),G0tensor(1450),G0tensor(1455), &
    G0tensor(1460),M2L1R1,[nMW],G0tensor(1465))
  call TI_triangle_red(G2tensor(338),RedBasis(123),mass3set(:,7),G0tensor(1100),G0tensor(5),G0tensor(1505), &
    G0tensor(1470),M2L1R1,[nMW],G0tensor(857))
  call TI_triangle_red(G2tensor(186),RedBasis(126),mass3set(:,7),G0tensor(110),G0tensor(65),G0tensor(20), &
    G0tensor(15),M2L1R1,[nMW],G0tensor(1475))
  call TI_triangle_red(G2tensor(161),RedBasis(118),mass3set(:,10),G0tensor(1480),G0tensor(1120),G0tensor(10), &
    G0tensor(1510),M2L1R1,[nMZ],G0tensor(1485))
  call TI_triangle_red(G2tensor(122),RedBasis(145),mass3set(:,10),G0tensor(1490),G0tensor(1495),G0tensor(1500), &
    G0tensor(997),M2L1R1,[nMZ],G0tensor(200))
  call TI_triangle_red(G2tensor(120),RedBasis(115),mass3set(:,3),G0tensor(155),G0tensor(30),G0tensor(25), &
    G0tensor(1215),M2L1R1,[nMZ],G0tensor(855))
  call TI_triangle_red(G2tensor(86),RedBasis(158),mass3set(:,6),G0tensor(74),G0tensor(60),G0tensor(917), &
    G0tensor(100),M2L1R1,[nMW],G0tensor(19))
  call TI_triangle_red(G2tensor(66),RedBasis(113),mass3set(:,5),G0tensor(1145),G0tensor(920),G0tensor(119), &
    G0tensor(105),M2L1R1,[nMW],G0tensor(1255))
  call TI_triangle_red(G2tensor(80),RedBasis(145),mass3set(:,11),G0tensor(995),G0tensor(164),G0tensor(150), &
    G0tensor(1072),M2L1R1,[nMW],G0tensor(190))
  call TI_triangle_red(G2tensor(81),RedBasis(115),mass3set(:,4),G0tensor(29),G0tensor(1175),G0tensor(1075), &
    G0tensor(209),M2L1R1,[nMW],G0tensor(195))
  call TI_triangle_red(G2tensor(194),RedBasis(114),mass3set(:,10),G0tensor(1212),G0tensor(1073),G0tensor(1063), &
    G0tensor(264),M2L1R1,[nMZ],G0tensor(1252))
  call TI_triangle_red(G2tensor(189),RedBasis(151),mass3set(:,10),G0tensor(918),G0tensor(903),G0tensor(289), &
    G0tensor(1297),M2L1R1,[nMZ],G0tensor(324))
  call TI_triangle_red(G2tensor(98),RedBasis(117),mass3set(:,5),G0tensor(1519),G0tensor(1514),G0tensor(1482), &
    G0tensor(1477),M2L1R1,[nMW],G0tensor(1472))
  call TI_triangle_red(G2tensor(95),RedBasis(151),mass3set(:,11),G0tensor(1310),G0tensor(1300),G0tensor(339), &
    G0tensor(329),M2L1R1,[nMW],G0tensor(1302))
  call TI_triangle_red(G2tensor(169),RedBasis(119),mass3set(:,4),G0tensor(325),G0tensor(1325),G0tensor(1305), &
    G0tensor(350),M2L1R1,[nMW],G0tensor(330))
  call TI_triangle_red(G2tensor(180),RedBasis(126),mass3set(:,10),G0tensor(1307),G0tensor(922),G0tensor(334), &
    G0tensor(123),M2L1R1,[nMZ],G0tensor(1413))
  call TI_triangle_red(G2tensor(205),RedBasis(150),mass3set(:,10),G0tensor(1322),G0tensor(345),G0tensor(1337), &
    G0tensor(364),M2L1R1,[nMZ],G0tensor(1529))
  call TI_triangle_red(G2tensor(202),RedBasis(124),mass3set(:,3),G0tensor(1524),G0tensor(1467),G0tensor(1462), &
    G0tensor(1457),M2L1R1,[nMZ],G0tensor(1350))
  call TI_triangle_red(G2tensor(101),RedBasis(153),mass3set(:,6),G0tensor(1340),G0tensor(379),G0tensor(369), &
    G0tensor(1342),M2L1R1,[nMW],G0tensor(365))
  call TI_triangle_red(G2tensor(87),RedBasis(150),mass3set(:,11),G0tensor(1365),G0tensor(1345),G0tensor(390), &
    G0tensor(370),M2L1R1,[nMW],G0tensor(1347))
  call TI_triangle_red(G2tensor(93),RedBasis(124),mass3set(:,4),G0tensor(792),G0tensor(374),G0tensor(33), &
    G0tensor(1428),M2L1R1,[nMW],G0tensor(1362))
  call TI_triangle_red(G2tensor(64),RedBasis(123),mass3set(:,10),G0tensor(385),G0tensor(1502),G0tensor(1453), &
    G0tensor(1338),M2L1R1,[nMZ],G0tensor(1333))
  call TI_triangle_red(G2tensor(197),RedBasis(148),mass3set(:,10),G0tensor(347),G0tensor(342),G0tensor(1348), &
    G0tensor(1027),M2L1R1,[nMZ],G0tensor(608))
  call TI_triangle_red(G2tensor(138),RedBasis(148),mass3set(:,11),G0tensor(357),G0tensor(352),G0tensor(1280), &
    G0tensor(1270),M2L1R1,[nMW],G0tensor(360))
  call TI_triangle_red(G2tensor(96),RedBasis(127),mass3set(:,4),G0tensor(340),G0tensor(300),G0tensor(588), &
    G0tensor(532),M2L1R1,[nMW],G0tensor(222))
  call TI_triangle_red(G2tensor(162),RedBasis(54),mass3set(:,6),G0tensor(143),G0tensor(117),G0tensor(17), &
    G0tensor(1507),M2L1R1,[nMW],G0tensor(1498))
  call TI_triangle_red(G2tensor(102),RedBasis(71),mass3set(:,6),G0tensor(1298),G0tensor(1293),G0tensor(387), &
    G0tensor(382),M2L1R1,[nMW],G0tensor(1308))
  call TI_triangle_red(G2tensor(192),RedBasis(114),mass3set(:,11),G0tensor(872),G0tensor(508),G0tensor(397), &
    G0tensor(392),M2L1R1,[nMW],G0tensor(1290))
  call TI_triangle_red(G2tensor(158),RedBasis(118),mass3set(:,11),G0tensor(1285),G0tensor(400),G0tensor(380), &
    G0tensor(315),M2L1R1,[nMW],G0tensor(642))
  call TI_triangle_red(G2tensor(164),RedBasis(116),mass3set(:,2),G0tensor(503),G0tensor(237),G0tensor(207),G0tensor(53),M2L1R1)
  call TI_triangle_red(G2tensor(62),RedBasis(123),mass3set(:,11),G0tensor(27),G0tensor(1512),G0tensor(987), &
    G0tensor(587),M2L1R1,[nMW],G0tensor(583))
  call TI_triangle_red(G2tensor(173),RedBasis(126),mass3set(:,11),G0tensor(1525),G0tensor(1515),G0tensor(1517), &
    G0tensor(967),M2L1R1,[nMW],G0tensor(572))
  call TI_triangle_red(G2tensor(183),RedBasis(125),mass3set(:,2),G0tensor(568),G0tensor(1530),G0tensor(1520), &
    G0tensor(1412),M2L1R1)
  call TI_triangle_red(G2tensor(110),RedBasis(47),mass3set(:,6),G0tensor(1332),G0tensor(363),G0tensor(1430), &
    G0tensor(1415),M2L1R1,[nMW],G0tensor(1358))
  call TI_triangle_red(G2tensor(125),RedBasis(108),mass3set(:,11),G0tensor(1353),G0tensor(327),G0tensor(322), &
    G0tensor(1368),M2L1R1,[nMW],G0tensor(927))
  call TI_triangle_red(G2tensor(128),RedBasis(107),mass3set(:,11),G0tensor(543),G0tensor(337),G0tensor(332), &
    G0tensor(648),M2L1R1,[nMW],G0tensor(497))
  call TI_triangle_red(G2tensor(144),RedBasis(104),mass3set(:,11),G0tensor(262),G0tensor(188),G0tensor(72), &
    G0tensor(12),M2L1R1,[nMW],G0tensor(1522))
  call TI_triangle_red(G2tensor(132),RedBasis(102),mass3set(:,11),G0tensor(842),G0tensor(502),G0tensor(498), &
    G0tensor(1527),M2L1R1,[nMW],G0tensor(822))
  call TI_triangle_red(G2tensor(141),RedBasis(113),mass3set(:,9),G0tensor(487),G0tensor(483),G0tensor(1427), &
    G0tensor(1292),M2L1R1,[nMZ],G0tensor(323))
  call TI_triangle_red(G2tensor(137),RedBasis(115),mass3set(:,6),G0tensor(1318),G0tensor(1313),G0tensor(367), &
    G0tensor(362),M2L1R1,[nMW],G0tensor(1328))
  call TI_triangle_red(G2tensor(135),RedBasis(113),mass3set(:,8),G0tensor(797),G0tensor(473),G0tensor(377), &
    G0tensor(372),M2L1R1,[nMW],G0tensor(582))
  call TI_triangle_red(G2tensor(143),RedBasis(119),mass3set(:,6),G0tensor(538),G0tensor(287),G0tensor(162), &
    G0tensor(98),M2L1R1,[nMW],G0tensor(22))
  call TI_triangle_red(G2tensor(146),RedBasis(117),mass3set(:,8),G0tensor(1448),G0tensor(1082),G0tensor(2), &
    G0tensor(1090),M2L1R1,[nMW],G0tensor(3))
  call TI_triangle_red(G2tensor(149),RedBasis(124),mass3set(:,6),G0tensor(1095),G0tensor(4),G0tensor(1493), &
    G0tensor(1102),M2L1R1,[nMW],G0tensor(7))
  call TI_triangle_red(G2tensor(152),RedBasis(127),mass3set(:,6),G0tensor(1110),G0tensor(8),G0tensor(1115), &
    G0tensor(9),M2L1R1,[nMW],G0tensor(837))
  call TI_triangle_red(G2tensor(320),RedBasis(41),mass3set(:,2),G0tensor(505),G0tensor(13),G0tensor(902),G0tensor(540),M2L1R1)
  call TI_triangle_red(G2tensor(116),RedBasis(47),mass3set(:,2),G0tensor(18),G0tensor(982),G0tensor(590),G0tensor(23),M2L1R1)
  call TI_triangle_red(G2tensor(70),RedBasis(47),mass3set(:,3),G0tensor(1062),G0tensor(650),G0tensor(28), &
    G0tensor(475),M2L1R1,[nMZ],G0tensor(358))
  call TI_triangle_red(G2tensor(72),RedBasis(47),mass3set(:,4),G0tensor(37),G0tensor(32),G0tensor(802),G0tensor(604),M2L1R1,[nMW], &
    G0tensor(514))
  call TI_triangle_red(G2tensor(77),RedBasis(54),mass3set(:,2),G0tensor(479),G0tensor(79),G0tensor(34),G0tensor(692),M2L1R1)
  call TI_triangle_red(G2tensor(78),RedBasis(54),mass3set(:,3),G0tensor(455),G0tensor(420),G0tensor(415), &
    G0tensor(125),M2L1R1,[nMZ],G0tensor(35))
  call TI_triangle_red(G2tensor(225),RedBasis(54),mass3set(:,4),G0tensor(1097),G0tensor(1085),G0tensor(799), &
    G0tensor(795),M2L1R1,[nMW],G0tensor(38))
  call TI_triangle_red(G2tensor(4),RedBasis(71),mass3set(:,2),G0tensor(1014),G0tensor(879),G0tensor(809),G0tensor(805),M2L1R1)
  call TI_triangle_red(G2tensor(84),RedBasis(71),mass3set(:,3),G0tensor(84),G0tensor(39),G0tensor(770),G0tensor(705),M2L1R1,[nMZ], &
    G0tensor(700))
  call TI_triangle_red(G2tensor(204),RedBasis(71),mass3set(:,4),G0tensor(695),G0tensor(130),G0tensor(40), &
    G0tensor(485),M2L1R1,[nMW],G0tensor(47))
  call TI_triangle_red(G2tensor(89),RedBasis(66),mass3set(:,2),G0tensor(42),G0tensor(812),G0tensor(489),G0tensor(43),M2L1R1)
  call TI_triangle_red(G2tensor(155),RedBasis(104),mass3set(:,7),G0tensor(722),G0tensor(464),G0tensor(434), &
    G0tensor(429),M2L1R1,[nMW],G0tensor(134))
  call TI_triangle_red(G2tensor(156),RedBasis(102),mass3set(:,7),G0tensor(44),G0tensor(827),G0tensor(565), &
    G0tensor(530),M2L1R1,[nMW],G0tensor(495))
  call TI_triangle_red(G2tensor(170),RedBasis(108),mass3set(:,7),G0tensor(90),G0tensor(45),G0tensor(844), &
    G0tensor(835),M2L1R1,[nMW],G0tensor(824))
  call TI_triangle_red(G2tensor(171),RedBasis(107),mass3set(:,7),G0tensor(815),G0tensor(68),G0tensor(48), &
    G0tensor(789),M2L1R1,[nMW],G0tensor(744))
  call TI_triangle_red(G3tensor(18),RedBasis(122),mass3set(:,12),G0tensor(734),G0tensor(725),G0tensor(139), &
    G0tensor(49),M2L1R1,[nML],G0tensor(1205))
  call TI_triangle_red(G3tensor(21),RedBasis(122),mass3set(:,13),G0tensor(1135),G0tensor(955),G0tensor(830), &
    G0tensor(260),M2L1R1,[nMT],G0tensor(220))
  call TI_triangle_red(G3tensor(24),RedBasis(122),mass3set(:,14),G0tensor(95),G0tensor(50),G0tensor(499), &
    G0tensor(57),M2L1R1,[nMB],G0tensor(52))
  call TI_triangle_red(G3tensor(30),RedBasis(112),mass3set(:,12),G0tensor(847),G0tensor(154),G0tensor(144), &
    G0tensor(64),M2L1R1,[nML],G0tensor(54))
  call TI_triangle_red(G3tensor(33),RedBasis(112),mass3set(:,13),G0tensor(1177),G0tensor(843),G0tensor(240), &
    G0tensor(58),M2L1R1,[nMT],G0tensor(850))
  call TI_triangle_red(G3tensor(36),RedBasis(112),mass3set(:,14),G0tensor(159),G0tensor(149),G0tensor(69), &
    G0tensor(59),M2L1R1,[nMB],G0tensor(500))
  call TI_triangle_red(G1tensor(782),RedBasis(104),mass3set(:,15),G0tensor(67),G0tensor(62),G0tensor(832), &
    G0tensor(504),M2L1R1,[nMZ],G0tensor(63))
  call TI_triangle_red(G1tensor(787),RedBasis(102),mass3set(:,15),G0tensor(1220),G0tensor(1150),G0tensor(860), &
    G0tensor(120),M2L1R1,[nMZ],G0tensor(115))
  call TI_triangle_red(G1tensor(802),RedBasis(108),mass3set(:,15),G0tensor(75),G0tensor(70),G0tensor(1210), &
    G0tensor(845),M2L1R1,[nMZ],G0tensor(840))
  call TI_triangle_red(G1tensor(807),RedBasis(107),mass3set(:,15),G0tensor(73),G0tensor(510),G0tensor(338), &
    G0tensor(82),M2L1R1,[nMZ],G0tensor(77))
  call TI_triangle_red(G1tensor(629),RedBasis(152),mass3set(:,16),G0tensor(1367),G0tensor(867),G0tensor(394), &
    G0tensor(78),M2L1R1,[nMZ],G0tensor(737))
  call TI_triangle_red(G1tensor(574),RedBasis(144),mass3set(:,16),G0tensor(470),G0tensor(440),G0tensor(435), &
    G0tensor(170),M2L1R1,[nMZ],G0tensor(80))
  call TI_triangle_red(G1tensor(789),RedBasis(20),mass3set(:,2),G0tensor(874),G0tensor(870),G0tensor(83),G0tensor(1235),M2L1R1)
  call TI_triangle_red(G1tensor(632),RedBasis(19),mass3set(:,10),G0tensor(1195),G0tensor(745),G0tensor(740), &
    G0tensor(275),M2L1R1,[nMZ],G0tensor(250))
  call TI_triangle_red(G1tensor(622),RedBasis(1),mass3set(:,10),G0tensor(175),G0tensor(85),G0tensor(1518), &
    G0tensor(520),M2L1R1,[nMZ],G0tensor(92))
  call TI_triangle_red(G1tensor(581),RedBasis(113),mass3set(:,16),G0tensor(87),G0tensor(882),G0tensor(524), &
    G0tensor(88),M2L1R1,[nMZ],G0tensor(677))
  call TI_triangle_red(G1tensor(639),RedBasis(111),mass3set(:,16),G0tensor(449),G0tensor(414),G0tensor(409), &
    G0tensor(179),M2L1R1,[nMZ],G0tensor(89))
  call TI_triangle_red(G1tensor(647),RedBasis(24),mass3set(:,2),G0tensor(909),G0tensor(900),G0tensor(894),G0tensor(885),M2L1R1)
  call TI_triangle_red(G1tensor(592),RedBasis(9),mass3set(:,10),G0tensor(113),G0tensor(93),G0tensor(764), &
    G0tensor(699),M2L1R1,[nMZ],G0tensor(689))
  call TI_triangle_red(G1tensor(897),RedBasis(22),mass3set(:,10),G0tensor(680),G0tensor(184),G0tensor(94), &
    G0tensor(534),M2L1R1,[nMZ],G0tensor(102))
  call TI_triangle_red(G1tensor(869),RedBasis(18),mass3set(:,11),G0tensor(97),G0tensor(912),G0tensor(199), &
    G0tensor(189),M2L1R1,[nMW],G0tensor(109))
  call TI_triangle_red(G1tensor(657),RedBasis(9),mass3set(:,11),G0tensor(99),G0tensor(1257),G0tensor(908), &
    G0tensor(290),M2L1R1,[nMW],G0tensor(103))
  call TI_triangle_red(G1tensor(912),RedBasis(22),mass3set(:,11),G0tensor(915),G0tensor(204),G0tensor(194), &
    G0tensor(114),M2L1R1,[nMW],G0tensor(104))
  call TI_triangle_red(G1tensor(902),RedBasis(23),mass3set(:,8),G0tensor(1513),G0tensor(535),G0tensor(112), &
    G0tensor(107),M2L1R1,[nMW],G0tensor(897))
  call TI_triangle_red(G1tensor(1059),RedBasis(155),mass3set(:,3),G0tensor(539),G0tensor(108),G0tensor(1140), &
    G0tensor(910),M2L1R1,[nMZ],G0tensor(905))
  call TI_triangle_red(G1tensor(598),RedBasis(147),mass3set(:,16),G0tensor(118),G0tensor(545),G0tensor(398), &
    G0tensor(127),M2L1R1,[nMZ],G0tensor(122))
  call TI_triangle_red(G1tensor(677),RedBasis(25),mass3set(:,2),G0tensor(932),G0tensor(614),G0tensor(564),G0tensor(549),M2L1R1)
  call TI_triangle_red(G1tensor(927),RedBasis(7),mass3set(:,10),G0tensor(169),G0tensor(124),G0tensor(1117), &
    G0tensor(1105),M2L1R1,[nMZ],G0tensor(929))
  call TI_triangle_red(G1tensor(679),RedBasis(119),mass3set(:,3),G0tensor(925),G0tensor(128),G0tensor(1034), &
    G0tensor(954),M2L1R1,[nMZ],G0tensor(939))
  call TI_triangle_red(G1tensor(551),RedBasis(117),mass3set(:,16),G0tensor(935),G0tensor(174),G0tensor(129), &
    G0tensor(570),M2L1R1,[nMZ],G0tensor(137))
  call TI_triangle_red(G1tensor(687),RedBasis(28),mass3set(:,2),G0tensor(132),G0tensor(957),G0tensor(574),G0tensor(133),M2L1R1)
  call TI_triangle_red(G1tensor(587),RedBasis(3),mass3set(:,10),G0tensor(972),G0tensor(640),G0tensor(605), &
    G0tensor(580),M2L1R1,[nMZ],G0tensor(180))
  call TI_triangle_red(G1tensor(363),RedBasis(162),mass3set(:,6),G0tensor(135),G0tensor(989),G0tensor(980), &
    G0tensor(969),M2L1R1,[nMW],G0tensor(960))
  call TI_triangle_red(G1tensor(949),RedBasis(6),mass3set(:,11),G0tensor(158),G0tensor(138),G0tensor(1245), &
    G0tensor(1165),M2L1R1,[nMW],G0tensor(1015))
  call TI_triangle_red(G1tensor(697),RedBasis(3),mass3set(:,11),G0tensor(975),G0tensor(285),G0tensor(235), &
    G0tensor(185),M2L1R1,[nMW],G0tensor(140))
  call TI_triangle_red(G1tensor(832),RedBasis(27),mass3set(:,8),G0tensor(584),G0tensor(147),G0tensor(142), &
    G0tensor(1147),M2L1R1,[nMW],G0tensor(988))
  call TI_triangle_red(G1tensor(709),RedBasis(157),mass3set(:,16),G0tensor(225),G0tensor(148),G0tensor(585), &
    G0tensor(157),M2L1R1,[nMZ],G0tensor(152))
  call TI_triangle_red(G1tensor(809),RedBasis(30),mass3set(:,2),G0tensor(977),G0tensor(589),G0tensor(153),G0tensor(1260),M2L1R1)
  call TI_triangle_red(G1tensor(712),RedBasis(29),mass3set(:,10),G0tensor(1180),G0tensor(1000),G0tensor(210), &
    G0tensor(205),M2L1R1,[nMZ],G0tensor(165))
  call TI_triangle_red(G1tensor(719),RedBasis(121),mass3set(:,16),G0tensor(160),G0tensor(1250),G0tensor(990), &
    G0tensor(985),M2L1R1,[nMZ],G0tensor(163))
  call TI_triangle_red(G1tensor(727),RedBasis(35),mass3set(:,2),G0tensor(610),G0tensor(378),G0tensor(172),G0tensor(167),M2L1R1)
  call TI_triangle_red(G1tensor(937),RedBasis(33),mass3set(:,10),G0tensor(1327),G0tensor(1022),G0tensor(354), &
    G0tensor(168),M2L1R1,[nMZ],G0tensor(1029))
  call TI_triangle_red(G1tensor(839),RedBasis(12),mass3set(:,11),G0tensor(1025),G0tensor(173),G0tensor(1528), &
    G0tensor(630),M2L1R1,[nMW],G0tensor(182))
  call TI_triangle_red(G1tensor(952),RedBasis(33),mass3set(:,11),G0tensor(177),G0tensor(1042),G0tensor(634), &
    G0tensor(178),M2L1R1,[nMW],G0tensor(1069))
  call TI_triangle_red(G1tensor(942),RedBasis(34),mass3set(:,8),G0tensor(1060),G0tensor(1054),G0tensor(1045), &
    G0tensor(203),M2L1R1,[nMW],G0tensor(183))
  call TI_triangle_red(G1tensor(1019),RedBasis(162),mass3set(:,3),G0tensor(644),G0tensor(192),G0tensor(187), &
    G0tensor(1217),M2L1R1,[nMZ],G0tensor(1068))
  call TI_triangle_red(G1tensor(752),RedBasis(37),mass3set(:,2),G0tensor(265),G0tensor(193),G0tensor(1523),G0tensor(645),M2L1R1)
  call TI_triangle_red(G1tensor(754),RedBasis(127),mass3set(:,3),G0tensor(202),G0tensor(197),G0tensor(1057), &
    G0tensor(649),M2L1R1,[nMZ],G0tensor(198))
  call TI_triangle_red(G1tensor(762),RedBasis(40),mass3set(:,2),G0tensor(1170),G0tensor(1070),G0tensor(1065), &
    G0tensor(208),M2L1R1)
  call TI_triangle_red(G1tensor(525),RedBasis(155),mass3set(:,6),G0tensor(1387),G0tensor(1383),G0tensor(1093), &
    G0tensor(1088),M2L1R1,[nMW],G0tensor(573))
  call TI_triangle_red(G1tensor(909),RedBasis(15),mass3set(:,11),G0tensor(552),G0tensor(527),G0tensor(517), &
    G0tensor(428),M2L1R1,[nMW],G0tensor(318))
  call TI_triangle_red(G1tensor(862),RedBasis(39),mass3set(:,8),G0tensor(217),G0tensor(212),G0tensor(1152), &
    G0tensor(1122),M2L1R1,[nMW],G0tensor(958))
  call TI_triangle_red(G1tensor(199),RedBasis(106),mass3set(:,16),G0tensor(813),G0tensor(723),G0tensor(708), &
    G0tensor(228),M2L1R1,[nMZ],G0tensor(213))
  call TI_triangle_red(G1tensor(844),RedBasis(55),mass3set(:,9),G0tensor(1127),G0tensor(963),G0tensor(864), &
    G0tensor(728),M2L1R1,[nMZ],G0tensor(713))
  call TI_triangle_red(G1tensor(819),RedBasis(54),mass3set(:,17),G0tensor(214),G0tensor(1132),G0tensor(968), &
    G0tensor(733),M2L1R1,[nMZ],G0tensor(718))
  call TI_triangle_red(G1tensor(824),RedBasis(12),mass3set(:,10),G0tensor(215),G0tensor(1125),G0tensor(950), &
    G0tensor(895),M2L1R1,[nMZ],G0tensor(890))
  call TI_triangle_red(G1tensor(817),RedBasis(27),mass3set(:,9),G0tensor(218),G0tensor(1130),G0tensor(940), &
    G0tensor(704),M2L1R1,[nMZ],G0tensor(690))
  call TI_triangle_red(G1tensor(822),RedBasis(2),mass3set(:,17),G0tensor(685),G0tensor(219),G0tensor(1167), &
    G0tensor(1137),M2L1R1,[nMZ],G0tensor(978))
  call TI_triangle_red(G1tensor(859),RedBasis(55),mass3set(:,8),G0tensor(848),G0tensor(833),G0tensor(238), &
    G0tensor(223),M2L1R1,[nMW],G0tensor(1142))
  call TI_triangle_red(G1tensor(289),RedBasis(110),mass3set(:,16),G0tensor(993),G0tensor(983),G0tensor(224), &
    G0tensor(1407),M2L1R1,[nMZ],G0tensor(1403))
  call TI_triangle_red(G1tensor(849),RedBasis(71),mass3set(:,17),G0tensor(1113),G0tensor(1108),G0tensor(652), &
    G0tensor(637),M2L1R1,[nMZ],G0tensor(627))
  call TI_triangle_red(G1tensor(854),RedBasis(18),mass3set(:,10),G0tensor(488),G0tensor(463),G0tensor(303), &
    G0tensor(232),M2L1R1,[nMZ],G0tensor(227))
  call TI_triangle_red(G1tensor(847),RedBasis(39),mass3set(:,9),G0tensor(1157),G0tensor(1019),G0tensor(818), &
    G0tensor(783),M2L1R1,[nMZ],G0tensor(773))
  call TI_triangle_red(G1tensor(852),RedBasis(13),mass3set(:,17),G0tensor(229),G0tensor(1162),G0tensor(823), &
    G0tensor(788),M2L1R1,[nMZ],G0tensor(778))
  call TI_triangle_red(G1tensor(491),RedBasis(154),mass3set(:,16),G0tensor(230),G0tensor(1155),G0tensor(1080), &
    G0tensor(1055),M2L1R1,[nMZ],G0tensor(1050))
  call TI_triangle_red(G1tensor(874),RedBasis(76),mass3set(:,9),G0tensor(233),G0tensor(1160),G0tensor(810), &
    G0tensor(769),M2L1R1,[nMZ],G0tensor(765))
  call TI_triangle_red(G1tensor(879),RedBasis(66),mass3set(:,17),G0tensor(760),G0tensor(234),G0tensor(1172), &
    G0tensor(853),M2L1R1,[nMZ],G0tensor(838))
  call TI_triangle_red(G1tensor(884),RedBasis(21),mass3set(:,10),G0tensor(239),G0tensor(1417),G0tensor(658), &
    G0tensor(607),M2L1R1,[nMZ],G0tensor(478))
  call TI_triangle_red(G1tensor(877),RedBasis(17),mass3set(:,9),G0tensor(467),G0tensor(457),G0tensor(373), &
    G0tensor(247),M2L1R1,[nMZ],G0tensor(242))
  call TI_triangle_red(G1tensor(882),RedBasis(16),mass3set(:,17),G0tensor(1182),G0tensor(1003),G0tensor(868), &
    G0tensor(863),M2L1R1,[nMZ],G0tensor(803))
  call TI_triangle_red(G1tensor(319),RedBasis(128),mass3set(:,16),G0tensor(793),G0tensor(243),G0tensor(1187), &
    G0tensor(1048),M2L1R1,[nMZ],G0tensor(758))
  call TI_triangle_red(G1tensor(929),RedBasis(42),mass3set(:,9),G0tensor(748),G0tensor(254),G0tensor(244), &
    G0tensor(1192),M2L1R1,[nMZ],G0tensor(1078))
  call TI_triangle_red(G1tensor(894),RedBasis(15),mass3set(:,10),G0tensor(808),G0tensor(798),G0tensor(245), &
    G0tensor(1185),M2L1R1,[nMZ],G0tensor(1030))
  call TI_triangle_red(G1tensor(892),RedBasis(23),mass3set(:,9),G0tensor(780),G0tensor(775),G0tensor(248), &
    G0tensor(1190),M2L1R1,[nMZ],G0tensor(1035))
  call TI_triangle_red(G1tensor(939),RedBasis(42),mass3set(:,8),G0tensor(790),G0tensor(785),G0tensor(259), &
    G0tensor(249),M2L1R1,[nMW],G0tensor(1422))
  call TI_triangle_red(G1tensor(424),RedBasis(159),mass3set(:,16),G0tensor(633),G0tensor(617),G0tensor(492), &
    G0tensor(482),M2L1R1,[nMZ],G0tensor(448))
  call TI_triangle_red(G1tensor(914),RedBasis(88),mass3set(:,9),G0tensor(308),G0tensor(257),G0tensor(252), &
    G0tensor(1237),M2L1R1,[nMZ],G0tensor(1197))
  call TI_triangle_red(G1tensor(919),RedBasis(41),mass3set(:,17),G0tensor(1043),G0tensor(883),G0tensor(678), &
    G0tensor(663),M2L1R1,[nMZ],G0tensor(278))
  call TI_triangle_red(G1tensor(924),RedBasis(31),mass3set(:,10),G0tensor(253),G0tensor(1202),G0tensor(1053), &
    G0tensor(763),M2L1R1,[nMZ],G0tensor(753))
  call TI_triangle_red(G1tensor(917),RedBasis(10),mass3set(:,9),G0tensor(255),G0tensor(1200),G0tensor(1040), &
    G0tensor(825),M2L1R1,[nMZ],G0tensor(820))
  call TI_triangle_red(G1tensor(922),RedBasis(8),mass3set(:,17),G0tensor(258),G0tensor(1247),G0tensor(1207), &
    G0tensor(1058),M2L1R1,[nMZ],G0tensor(913))
  call TI_triangle_red(G1tensor(349),RedBasis(120),mass3set(:,16),G0tensor(898),G0tensor(288),G0tensor(263), &
    G0tensor(1432),M2L1R1,[nMZ],G0tensor(558))
  call TI_triangle_red(G1tensor(934),RedBasis(6),mass3set(:,10),G0tensor(548),G0tensor(507),G0tensor(437), &
    G0tensor(422),M2L1R1,[nMZ],G0tensor(333))
  call TI_triangle_red(G1tensor(932),RedBasis(34),mass3set(:,9),G0tensor(272),G0tensor(267),G0tensor(1222), &
    G0tensor(1023),M2L1R1,[nMZ],G0tensor(1018))
  call TI_triangle_red(G1tensor(51),RedBasis(183),mass3set(:,9),G0tensor(943),G0tensor(933),G0tensor(923), &
    G0tensor(268),M2L1R1,[nMZ],G0tensor(1227))
  call TI_triangle_red(G1tensor(954),RedBasis(146),mass3set(:,3),G0tensor(888),G0tensor(683),G0tensor(668), &
    G0tensor(279),M2L1R1,[nMZ],G0tensor(269))
  call TI_triangle_red(G1tensor(959),RedBasis(145),mass3set(:,15),G0tensor(1232),G0tensor(948),G0tensor(938), &
    G0tensor(928),M2L1R1,[nMZ],G0tensor(270))
  call TI_triangle_red(G1tensor(549),RedBasis(140),mass3set(:,10),G0tensor(1225),G0tensor(875),G0tensor(720), &
    G0tensor(715),M2L1R1,[nMZ],G0tensor(273))
  call TI_triangle_red(G1tensor(967),RedBasis(139),mass3set(:,2),G0tensor(1230),G0tensor(880),G0tensor(735),G0tensor(730),M2L1R1)
  call TI_triangle_red(G1tensor(964),RedBasis(149),mass3set(:,3),G0tensor(284),G0tensor(274),G0tensor(1437), &
    G0tensor(592),M2L1R1,[nMZ],G0tensor(577))
  call TI_triangle_red(G1tensor(969),RedBasis(151),mass3set(:,15),G0tensor(567),G0tensor(523),G0tensor(408), &
    G0tensor(293),M2L1R1,[nMZ],G0tensor(282))
  call TI_triangle_red(G1tensor(117),RedBasis(185),mass3set(:,9),G0tensor(277),G0tensor(1242),G0tensor(893), &
    G0tensor(688),M2L1R1,[nMZ],G0tensor(673))
  call TI_triangle_red(G1tensor(974),RedBasis(150),mass3set(:,15),G0tensor(280),G0tensor(1240),G0tensor(1010), &
    G0tensor(970),M2L1R1,[nMZ],G0tensor(965))
  call TI_triangle_red(G1tensor(508),RedBasis(143),mass3set(:,10),G0tensor(283),G0tensor(777),G0tensor(672), &
    G0tensor(458),M2L1R1,[nMZ],G0tensor(403))
  call TI_triangle_red(G1tensor(979),RedBasis(148),mass3set(:,15),G0tensor(302),G0tensor(297),G0tensor(292), &
    G0tensor(1262),M2L1R1,[nMZ],G0tensor(662))
  call TI_triangle_red(G1tensor(1004),RedBasis(163),mass3set(:,5),G0tensor(413),G0tensor(309),G0tensor(294), &
    G0tensor(1267),M2L1R1,[nMW],G0tensor(667))
  call TI_triangle_red(G1tensor(1009),RedBasis(162),mass3set(:,4),G0tensor(418),G0tensor(335),G0tensor(295), &
    G0tensor(1012),M2L1R1,[nMW],G0tensor(655))
  call TI_triangle_red(G1tensor(744),RedBasis(163),mass3set(:,16),G0tensor(602),G0tensor(595),G0tensor(298), &
    G0tensor(1275),M2L1R1,[nMZ],G0tensor(1265))
  call TI_triangle_red(G1tensor(1044),RedBasis(156),mass3set(:,5),G0tensor(314),G0tensor(299),G0tensor(1272), &
    G0tensor(707),M2L1R1,[nMW],G0tensor(433))
  call TI_triangle_red(G1tensor(1049),RedBasis(155),mass3set(:,4),G0tensor(319),G0tensor(304),G0tensor(1277), &
    G0tensor(772),M2L1R1,[nMW],G0tensor(468))
  call TI_triangle_red(G1tensor(669),RedBasis(156),mass3set(:,16),G0tensor(355),G0tensor(305),G0tensor(752), &
    G0tensor(717),M2L1R1,[nMZ],G0tensor(443))
  call TI_triangle_red(G1tensor(970),RedBasis(119),mass3set(:,17),G0tensor(423),G0tensor(317),G0tensor(312), &
    G0tensor(307),M2L1R1,[nMZ],G0tensor(1282))
  call TI_triangle_red(G1tensor(315),RedBasis(114),mass3set(:,15),G0tensor(747),G0tensor(453),G0tensor(375), &
    G0tensor(310),M2L1R1,[nMZ],G0tensor(952))
  call TI_triangle_red(G1tensor(960),RedBasis(115),mass3set(:,17),G0tensor(620),G0tensor(562),G0tensor(555), &
    G0tensor(313),M2L1R1,[nMZ],G0tensor(1287))
  call TI_triangle_red(G1tensor(359),RedBasis(163),mass3set(:,8),G0tensor(712),G0tensor(438),G0tensor(395), &
    G0tensor(320),M2L1R1,[nMW],G0tensor(1295))
  call TI_triangle_red(G1tensor(980),RedBasis(127),mass3set(:,17),G0tensor(328),G0tensor(1312),G0tensor(343), &
    G0tensor(1317),M2L1R1,[nMZ],G0tensor(344))
  call TI_triangle_red(G1tensor(965),RedBasis(142),mass3set(:,9),G0tensor(1315),G0tensor(348),G0tensor(1452), &
    G0tensor(1447),M2L1R1,[nMZ],G0tensor(1442))
  call TI_triangle_red(G1tensor(400),RedBasis(153),mass3set(:,17),G0tensor(1330),G0tensor(1320),G0tensor(359), &
    G0tensor(349),M2L1R1,[nMZ],G0tensor(1017))
  call TI_triangle_red(G1tensor(441),RedBasis(123),mass3set(:,15),G0tensor(767),G0tensor(623),G0tensor(613), &
    G0tensor(472),M2L1R1,[nMZ],G0tensor(452))
  call TI_triangle_red(G1tensor(955),RedBasis(141),mass3set(:,9),G0tensor(442),G0tensor(353),G0tensor(1335), &
    G0tensor(368),M2L1R1,[nMZ],G0tensor(1352))
  call TI_triangle_red(G1tensor(975),RedBasis(124),mass3set(:,17),G0tensor(383),G0tensor(1357),G0tensor(384), &
    G0tensor(1355),M2L1R1,[nMZ],G0tensor(388))
  call TI_triangle_red(G1tensor(514),RedBasis(156),mass3set(:,9),G0tensor(1497),G0tensor(1492),G0tensor(1487), &
    G0tensor(1370),M2L1R1,[nMZ],G0tensor(1360))
  call TI_triangle_red(G1tensor(515),RedBasis(155),mass3set(:,17),G0tensor(399),G0tensor(389),G0tensor(862), &
    G0tensor(702),M2L1R1,[nMZ],G0tensor(598))
  call TI_triangle_red(G1tensor(532),RedBasis(156),mass3set(:,8),G0tensor(542),G0tensor(513),G0tensor(417), &
    G0tensor(402),M2L1R1,[nMW],G0tensor(393))
  call TI_triangle_red(G1tensor(169),RedBasis(47),mass3set(:,17),G0tensor(1278),G0tensor(807),G0tensor(654), &
    G0tensor(477),M2L1R1,[nMZ],G0tensor(474))
  call TI_triangle_red(G1tensor(706),RedBasis(43),mass3set(:,9),G0tensor(817),G0tensor(625),G0tensor(493), &
    G0tensor(490),M2L1R1,[nMZ],G0tensor(1268))
  call TI_triangle_red(G1tensor(623),RedBasis(4),mass3set(:,9),G0tensor(877),G0tensor(594),G0tensor(512), &
    G0tensor(509),M2L1R1,[nMZ],G0tensor(907))
  call TI_triangle_red(G1tensor(751),RedBasis(56),mass3set(:,9),G0tensor(537),G0tensor(533),G0tensor(1288), &
    G0tensor(937),M2L1R1,[nMZ],G0tensor(554))
  call TI_triangle_red(G1tensor(616),RedBasis(14),mass3set(:,9),G0tensor(547),G0tensor(544),G0tensor(1273), &
    G0tensor(1077),M2L1R1,[nMZ],G0tensor(947))
  call TI_triangle_red(G1tensor(681),RedBasis(81),mass3set(:,9),G0tensor(657),G0tensor(653),G0tensor(557), &
    G0tensor(553),M2L1R1,[nMZ],G0tensor(732))
  call TI_triangle_red(G1tensor(691),RedBasis(81),mass3set(:,8),G0tensor(569),G0tensor(427),G0tensor(424), &
    G0tensor(962),M2L1R1,[nMW],G0tensor(600))
  call TI_triangle_red(G1tensor(672),RedBasis(26),mass3set(:,10),G0tensor(578),G0tensor(575),G0tensor(1263), &
    G0tensor(1037),M2L1R1,[nMZ],G0tensor(1007))
  call TI_triangle_red(G1tensor(756),RedBasis(95),mass3set(:,9),G0tensor(622),G0tensor(618),G0tensor(597), &
    G0tensor(593),M2L1R1,[nMZ],G0tensor(1283))
  call TI_triangle_red(G1tensor(766),RedBasis(95),mass3set(:,8),G0tensor(1032),G0tensor(619),G0tensor(612), &
    G0tensor(609),M2L1R1,[nMW],G0tensor(1052))
  call TI_triangle_red(G1tensor(747),RedBasis(38),mass3set(:,10),G0tensor(632),G0tensor(628),G0tensor(762), &
    G0tensor(629),M2L1R1,[nMZ],G0tensor(447))
  call TI_triangle_red(G1tensor(779),RedBasis(179),mass3set(:,9),G0tensor(444),G0tensor(1067),G0tensor(647), &
    G0tensor(643),M2L1R1,[nMZ],G0tensor(1399))
  call TI_triangle_red(G1tensor(784),RedBasis(178),mass3set(:,9),G0tensor(1394),G0tensor(1379),G0tensor(1374), &
    G0tensor(974),M2L1R1,[nMZ],G0tensor(934))
  call TI_triangle_red(G1tensor(790),RedBasis(105),mass3set(:,3),G0tensor(829),G0tensor(804),G0tensor(784), &
    G0tensor(759),M2L1R1,[nMZ],G0tensor(739))
  call TI_triangle_red(G1tensor(811),RedBasis(103),mass3set(:,3),G0tensor(729),G0tensor(724),G0tensor(694), &
    G0tensor(684),M2L1R1,[nMZ],G0tensor(679))
  call TI_triangle_red(G1tensor(799),RedBasis(181),mass3set(:,9),G0tensor(924),G0tensor(794),G0tensor(749), &
    G0tensor(693),M2L1R1,[nMZ],G0tensor(669))
  call TI_triangle_red(G1tensor(804),RedBasis(180),mass3set(:,9),G0tensor(664),G0tensor(930),G0tensor(703), &
    G0tensor(675),M2L1R1,[nMZ],G0tensor(670))
  call TI_triangle_red(G1tensor(810),RedBasis(109),mass3set(:,3),G0tensor(1024),G0tensor(869),G0tensor(774), &
    G0tensor(738),M2L1R1,[nMZ],G0tensor(714))
  call TI_triangle_red(G1tensor(820),RedBasis(131),mass3set(:,10),G0tensor(709),G0tensor(800),G0tensor(768), &
    G0tensor(755),M2L1R1,[nMZ],G0tensor(750))
  call TI_triangle_red(G1tensor(840),RedBasis(130),mass3set(:,2),G0tensor(944),G0tensor(889),G0tensor(884),G0tensor(828),M2L1R1)
  call TI_triangle_red(G1tensor(826),RedBasis(129),mass3set(:,10),G0tensor(819),G0tensor(814),G0tensor(904), &
    G0tensor(899),M2L1R1,[nMZ],G0tensor(858))
  call TI_triangle_red(G1tensor(835),RedBasis(131),mass3set(:,11),G0tensor(839),G0tensor(834),G0tensor(1074), &
    G0tensor(999),M2L1R1,[nMW],G0tensor(994))
  call TI_triangle_red(G1tensor(841),RedBasis(129),mass3set(:,11),G0tensor(919),G0tensor(914),G0tensor(859), &
    G0tensor(854),M2L1R1,[nMW],G0tensor(849))
  call TI_triangle_red(G1tensor(850),RedBasis(134),mass3set(:,10),G0tensor(1008),G0tensor(878),G0tensor(873), &
    G0tensor(865),M2L1R1,[nMZ],G0tensor(1049))
  call TI_triangle_red(G1tensor(870),RedBasis(133),mass3set(:,2),G0tensor(1044),G0tensor(1004),G0tensor(973), &
    G0tensor(964),M2L1R1)
  call TI_triangle_red(G1tensor(856),RedBasis(132),mass3set(:,10),G0tensor(959),G0tensor(1064),G0tensor(1059), &
    G0tensor(998),M2L1R1,[nMZ],G0tensor(984))
  call TI_triangle_red(G1tensor(865),RedBasis(134),mass3set(:,11),G0tensor(979),G0tensor(1038),G0tensor(1033), &
    G0tensor(1028),M2L1R1,[nMW],G0tensor(1020))
  call TI_triangle_red(G1tensor(871),RedBasis(132),mass3set(:,11),G0tensor(1087),G0tensor(1083),G0tensor(1092), &
    G0tensor(1084),M2L1R1,[nMW],G0tensor(1098))
  call TI_triangle_red(G1tensor(890),RedBasis(108),mass3set(:,10),G0tensor(1089),G0tensor(1119),G0tensor(1114), &
    G0tensor(1099),M2L1R1,[nMZ],G0tensor(1094))
  call TI_triangle_red(G1tensor(885),RedBasis(135),mass3set(:,2),G0tensor(1107),G0tensor(1103),G0tensor(1112), &
    G0tensor(1104),M2L1R1)
  call TI_triangle_red(G1tensor(896),RedBasis(107),mass3set(:,10),G0tensor(1118),G0tensor(1109),G0tensor(1128), &
    G0tensor(1123),M2L1R1,[nMZ],G0tensor(1148))
  call TI_triangle_red(G1tensor(910),RedBasis(136),mass3set(:,2),G0tensor(1139),G0tensor(1133),G0tensor(1124), &
    G0tensor(1134),M2L1R1)
  call TI_triangle_red(G1tensor(930),RedBasis(104),mass3set(:,10),G0tensor(1129),G0tensor(1143),G0tensor(1138), &
    G0tensor(1149),M2L1R1,[nMZ],G0tensor(1144))
  call TI_triangle_red(G1tensor(925),RedBasis(137),mass3set(:,2),G0tensor(1158),G0tensor(1153),G0tensor(1178), &
    G0tensor(1169),M2L1R1)
  call TI_triangle_red(G1tensor(936),RedBasis(102),mass3set(:,10),G0tensor(1163),G0tensor(1154),G0tensor(1164), &
    G0tensor(1159),M2L1R1,[nMZ],G0tensor(1173))
  call TI_triangle_red(G1tensor(950),RedBasis(138),mass3set(:,2),G0tensor(1168),G0tensor(1179),G0tensor(1174), &
    G0tensor(1198),M2L1R1)
  call TI_triangle_red(G1tensor(1061),RedBasis(117),mass3set(:,9),G0tensor(1188),G0tensor(1183),G0tensor(1193), &
    G0tensor(1184),M2L1R1,[nMZ],G0tensor(1204))
  call ol_merge_tensors(T0sum(307),[G0tensor(1)])
  call ol_merge_tensors(T0sum(308),[G0tensor(26)])
  call ol_merge_tensors(T0sum(309),[G0tensor(51)])
  call ol_merge_tensors(T0sum(310),[G0tensor(71)])
  call ol_merge_tensors(T0sum(311),[G0tensor(96)])
  call ol_merge_tensors(T0sum(312),[G0tensor(121)])
  call ol_merge_tensors(T0sum(313),[G0tensor(141)])
  call ol_merge_tensors(T0sum(314),[G0tensor(166)])
  call ol_merge_tensors(T0sum(315),[G0tensor(191)])
  call ol_merge_tensors(T0sum(316),[G0tensor(216)])
  call ol_merge_tensors(T0sum(317),[G0tensor(236)])
  call ol_merge_tensors(T0sum(318),[G0tensor(261)])
  call ol_merge_tensors(T0sum(319),[G0tensor(286)])
  call ol_merge_tensors(T0sum(320),[G0tensor(306)])
  call ol_merge_tensors(T0sum(321),[G0tensor(331)])
  call ol_merge_tensors(T0sum(322),[G0tensor(356)])
  call ol_merge_tensors(T0sum(323),[G0tensor(381)])
  call ol_merge_tensors(T0sum(324),[G0tensor(406)])
  call ol_merge_tensors(T0sum(325),[G0tensor(431)])
  call ol_merge_tensors(T0sum(326),[G0tensor(456)])
  call ol_merge_tensors(T0sum(327),[G0tensor(481)])
  call ol_merge_tensors(T0sum(328),[G0tensor(506)])
  call ol_merge_tensors(T0sum(329),[G0tensor(531)])
  call ol_merge_tensors(T0sum(330),[G0tensor(556)])
  call ol_merge_tensors(T0sum(331),[G0tensor(581)])
  call ol_merge_tensors(T0sum(332),[G0tensor(606)])
  call ol_merge_tensors(T0sum(333),[G0tensor(626)])
  call ol_merge_tensors(T0sum(334),[G0tensor(651)])
  call ol_merge_tensors(T0sum(335),[G0tensor(676)])
  call ol_merge_tensors(T0sum(336),[G0tensor(701)])
  call ol_merge_tensors(T0sum(337),[G0tensor(726)])
  call ol_merge_tensors(T0sum(338),[G0tensor(751)])
  call ol_merge_tensors(T0sum(339),[G0tensor(771)])
  call ol_merge_tensors(T0sum(340),[G0tensor(796)])
  call ol_merge_tensors(T0sum(341),[G0tensor(821)])
  call ol_merge_tensors(T0sum(342),[G0tensor(846)])
  call ol_merge_tensors(T0sum(343),[G0tensor(871)])
  call ol_merge_tensors(T0sum(344),[G0tensor(896)])
  call ol_merge_tensors(T0sum(345),[G0tensor(921)])
  call ol_merge_tensors(T0sum(346),[G0tensor(946)])
  call ol_merge_tensors(T0sum(347),[G0tensor(971)])
  call ol_merge_tensors(T0sum(348),[G0tensor(996)])
  call ol_merge_tensors(T0sum(349),[G0tensor(1021)])
  call ol_merge_tensors(T0sum(350),[G0tensor(1046)])
  call ol_merge_tensors(T0sum(351),[G0tensor(1071)])
  call ol_merge_tensors(T0sum(352),[G0tensor(1096)])
  call ol_merge_tensors(T0sum(353),[G0tensor(1121)])
  call ol_merge_tensors(T0sum(354),[G0tensor(1146)])
  call ol_merge_tensors(T0sum(355),[G0tensor(1171)])
  call ol_merge_tensors(T0sum(356),[G0tensor(1196)])
  call ol_merge_tensors(T0sum(357),[G0tensor(1221)])
  call ol_merge_tensors(T0sum(358),[G0tensor(1246)])
  call ol_merge_tensors(T0sum(359),[G0tensor(1271)])
  call ol_merge_tensors(T0sum(360),[G0tensor(1296)])
  call ol_merge_tensors(T0sum(361),[G0tensor(1321)])
  call ol_merge_tensors(T0sum(362),[G0tensor(1346)])
  call ol_merge_tensors(T0sum(363),[G0tensor(1371)])
  call ol_merge_tensors(T0sum(364),[G0tensor(1396)])
  call ol_merge_tensors(T0sum(365),[G0tensor(1421)])
  call ol_merge_tensors(T0sum(366),[G0tensor(1446)])
  call ol_merge_tensors(T0sum(367),[G0tensor(1471)])
  call ol_merge_tensors(T0sum(368),[G0tensor(1496)])
  call ol_merge_tensors(T0sum(369),[G0tensor(67)])
  call ol_merge_tensors(T0sum(370),[G0tensor(1220)])
  call ol_merge_tensors(T0sum(371),[G0tensor(1521)])
  call ol_merge_tensors(T0sum(372),[G0tensor(75)])
  call ol_merge_tensors(T0sum(373),[G0tensor(73)])
  call ol_merge_tensors(T0sum(374),[G0tensor(14)])
  call ol_merge_tensors(T0sum(375),[G0tensor(1445)])
  call ol_merge_tensors(T0sum(376),[G0tensor(1100)])
  call ol_merge_tensors(T0sum(377),[G0tensor(110)])
  call ol_merge_tensors(T0sum(378),[G0tensor(1480)])
  call ol_merge_tensors(T0sum(379),[G0tensor(1367)])
  call ol_merge_tensors(T0sum(380),[G0tensor(470)])
  call ol_merge_tensors(T0sum(381),[G0tensor(874)])
  call ol_merge_tensors(T0sum(382),[G0tensor(1195)])
  call ol_merge_tensors(T0sum(383),[G0tensor(175)])
  call ol_merge_tensors(T0sum(384),[G0tensor(1490)])
  call ol_merge_tensors(T0sum(385),[G0tensor(155)])
  call ol_merge_tensors(T0sum(386),[G0tensor(87)])
  call ol_merge_tensors(T0sum(387),[G0tensor(449)])
  call ol_merge_tensors(T0sum(388),[G0tensor(909)])
  call ol_merge_tensors(T0sum(389),[G0tensor(113)])
  call ol_merge_tensors(T0sum(390),[G0tensor(680)])
  call ol_merge_tensors(T0sum(391),[G0tensor(74)])
  call ol_merge_tensors(T0sum(392),[G0tensor(1145)])
  call ol_merge_tensors(T0sum(393),[G0tensor(97)])
  call ol_merge_tensors(T0sum(394),[G0tensor(99)])
  call ol_merge_tensors(T0sum(395),[G0tensor(995)])
  call ol_merge_tensors(T0sum(396),[G0tensor(29)])
  call ol_merge_tensors(T0sum(397),[G0tensor(915)])
  call ol_merge_tensors(T0sum(398),[G0tensor(1513)])
  call ol_merge_tensors(T0sum(399),[G0tensor(1212)])
  call ol_merge_tensors(T0sum(400),[G0tensor(539)])
  call ol_merge_tensors(T0sum(401),[G0tensor(118)])
  call ol_merge_tensors(T0sum(402),[G0tensor(932)])
  call ol_merge_tensors(T0sum(403),[G0tensor(169)])
  call ol_merge_tensors(T0sum(404),[G0tensor(918)])
  call ol_merge_tensors(T0sum(405),[G0tensor(925)])
  call ol_merge_tensors(T0sum(406),[G0tensor(935)])
  call ol_merge_tensors(T0sum(407),[G0tensor(132)])
  call ol_merge_tensors(T0sum(408),[G0tensor(972)])
  call ol_merge_tensors(T0sum(409),[G0tensor(135)])
  call ol_merge_tensors(T0sum(410),[G0tensor(1519)])
  call ol_merge_tensors(T0sum(411),[G0tensor(158)])
  call ol_merge_tensors(T0sum(412),[G0tensor(975)])
  call ol_merge_tensors(T0sum(413),[G0tensor(1310)])
  call ol_merge_tensors(T0sum(414),[G0tensor(325)])
  call ol_merge_tensors(T0sum(415),[G0tensor(584)])
  call ol_merge_tensors(T0sum(416),[G0tensor(1307)])
  call ol_merge_tensors(T0sum(417),[G0tensor(225)])
  call ol_merge_tensors(T0sum(418),[G0tensor(977)])
  call ol_merge_tensors(T0sum(419),[G0tensor(1180)])
  call ol_merge_tensors(T0sum(420),[G0tensor(1322)])
  call ol_merge_tensors(T0sum(421),[G0tensor(1524)])
  call ol_merge_tensors(T0sum(422),[G0tensor(160)])
  call ol_merge_tensors(T0sum(423),[G0tensor(610)])
  call ol_merge_tensors(T0sum(424),[G0tensor(1327)])
  call ol_merge_tensors(T0sum(425),[G0tensor(1340)])
  call ol_merge_tensors(T0sum(426),[G0tensor(1025)])
  call ol_merge_tensors(T0sum(427),[G0tensor(1365)])
  call ol_merge_tensors(T0sum(428),[G0tensor(792)])
  call ol_merge_tensors(T0sum(429),[G0tensor(177)])
  call ol_merge_tensors(T0sum(430),[G0tensor(1060)])
  call ol_merge_tensors(T0sum(431),[G0tensor(385)])
  call ol_merge_tensors(T0sum(432),[G0tensor(644)])
  call ol_merge_tensors(T0sum(433),[G0tensor(265)])
  call ol_merge_tensors(T0sum(434),[G0tensor(347)])
  call ol_merge_tensors(T0sum(435),[G0tensor(202)])
  call ol_merge_tensors(T0sum(436),[G0tensor(1170)])
  call ol_merge_tensors(T0sum(437),[G0tensor(1387)])
  call ol_merge_tensors(T0sum(438),[G0tensor(552)])
  call ol_merge_tensors(T0sum(439),[G0tensor(357)])
  call ol_merge_tensors(T0sum(440),[G0tensor(340)])
  call ol_merge_tensors(T0sum(441),[G0tensor(217)])
  call ol_merge_tensors(T0sum(442),[G0tensor(813)])
  call ol_merge_tensors(T0sum(443),[G0tensor(1127)])
  call ol_merge_tensors(T0sum(444),[G0tensor(214)])
  call ol_merge_tensors(T0sum(445),[G0tensor(215)])
  call ol_merge_tensors(T0sum(446),[G0tensor(218)])
  call ol_merge_tensors(T0sum(447),[G0tensor(685)])
  call ol_merge_tensors(T0sum(448),[G0tensor(848)])
  call ol_merge_tensors(T0sum(449),[G0tensor(143)])
  call ol_merge_tensors(T0sum(450),[G0tensor(993)])
  call ol_merge_tensors(T0sum(451),[G0tensor(1113)])
  call ol_merge_tensors(T0sum(452),[G0tensor(488)])
  call ol_merge_tensors(T0sum(453),[G0tensor(1157)])
  call ol_merge_tensors(T0sum(454),[G0tensor(229)])
  call ol_merge_tensors(T0sum(455),[G0tensor(1298)])
  call ol_merge_tensors(T0sum(456),[G0tensor(230)])
  call ol_merge_tensors(T0sum(457),[G0tensor(233)])
  call ol_merge_tensors(T0sum(458),[G0tensor(760)])
  call ol_merge_tensors(T0sum(459),[G0tensor(239)])
  call ol_merge_tensors(T0sum(460),[G0tensor(467)])
  call ol_merge_tensors(T0sum(461),[G0tensor(1182)])
  call ol_merge_tensors(T0sum(462),[G0tensor(793)])
  call ol_merge_tensors(T0sum(463),[G0tensor(748)])
  call ol_merge_tensors(T0sum(464),[G0tensor(808)])
  call ol_merge_tensors(T0sum(465),[G0tensor(780)])
  call ol_merge_tensors(T0sum(466),[G0tensor(790)])
  call ol_merge_tensors(T0sum(467),[G0tensor(633)])
  call ol_merge_tensors(T0sum(468),[G0tensor(308)])
  call ol_merge_tensors(T0sum(469),[G0tensor(1043)])
  call ol_merge_tensors(T0sum(470),[G0tensor(253)])
  call ol_merge_tensors(T0sum(471),[G0tensor(255)])
  call ol_merge_tensors(T0sum(472),[G0tensor(258)])
  call ol_merge_tensors(T0sum(473),[G0tensor(898)])
  call ol_merge_tensors(T0sum(474),[G0tensor(548)])
  call ol_merge_tensors(T0sum(475),[G0tensor(272)])
  call ol_merge_tensors(T0sum(476),[G0tensor(943)])
  call ol_merge_tensors(T0sum(477),[G0tensor(888)])
  call ol_merge_tensors(T0sum(478),[G0tensor(1232)])
  call ol_merge_tensors(T0sum(479),[G0tensor(1225)])
  call ol_merge_tensors(T0sum(480),[G0tensor(1230)])
  call ol_merge_tensors(T0sum(481),[G0tensor(284)])
  call ol_merge_tensors(T0sum(482),[G0tensor(567)])
  call ol_merge_tensors(T0sum(483),[G0tensor(277)])
  call ol_merge_tensors(T0sum(484),[G0tensor(280)])
  call ol_merge_tensors(T0sum(485),[G0tensor(283)])
  call ol_merge_tensors(T0sum(486),[G0tensor(302)])
  call ol_merge_tensors(T0sum(487),[G0tensor(872)])
  call ol_merge_tensors(T0sum(488),[G0tensor(413)])
  call ol_merge_tensors(T0sum(489),[G0tensor(418)])
  call ol_merge_tensors(T0sum(490),[G0tensor(1285)])
  call ol_merge_tensors(T0sum(491),[G0tensor(503)])
  call ol_merge_tensors(T0sum(492),[G0tensor(602)])
  call ol_merge_tensors(T0sum(493),[G0tensor(27)])
  call ol_merge_tensors(T0sum(494),[G0tensor(314)])
  call ol_merge_tensors(T0sum(495),[G0tensor(319)])
  call ol_merge_tensors(T0sum(496),[G0tensor(1525)])
  call ol_merge_tensors(T0sum(497),[G0tensor(568)])
  call ol_merge_tensors(T0sum(498),[G0tensor(355)])
  call ol_merge_tensors(T0sum(499),[G0tensor(423)])
  call ol_merge_tensors(T0sum(500),[G0tensor(747)])
  call ol_merge_tensors(T0sum(501),[G0tensor(620)])
  call ol_merge_tensors(T0sum(502),[G0tensor(712)])
  call ol_merge_tensors(T0sum(503),[G0tensor(328)])
  call ol_merge_tensors(T0sum(504),[G0tensor(1315)])
  call ol_merge_tensors(T0sum(505),[G0tensor(1330)])
  call ol_merge_tensors(T0sum(506),[G0tensor(767)])
  call ol_merge_tensors(T0sum(507),[G0tensor(442)])
  call ol_merge_tensors(T0sum(508),[G0tensor(383)])
  call ol_merge_tensors(T0sum(509),[G0tensor(1497)])
  call ol_merge_tensors(T0sum(510),[G0tensor(399)])
  call ol_merge_tensors(T0sum(511),[G0tensor(542)])
  call ol_merge_tensors(T0sum(512),[G0tensor(1278)])
  call ol_merge_tensors(T0sum(513),[G0tensor(817)])
  call ol_merge_tensors(T0sum(514),[G0tensor(877)])
  call ol_merge_tensors(T0sum(515),[G0tensor(537)])
  call ol_merge_tensors(T0sum(516),[G0tensor(547)])
  call ol_merge_tensors(T0sum(517),[G0tensor(657)])
  call ol_merge_tensors(T0sum(518),[G0tensor(569)])
  call ol_merge_tensors(T0sum(519),[G0tensor(1332)])
  call ol_merge_tensors(T0sum(520),[G0tensor(578)])
  call ol_merge_tensors(T0sum(521),[G0tensor(622)])
  call ol_merge_tensors(T0sum(522),[G0tensor(1032)])
  call ol_merge_tensors(T0sum(523),[G0tensor(632)])
  call ol_merge_tensors(T0sum(524),[G0tensor(444)])
  call ol_merge_tensors(T0sum(525),[G0tensor(1394)])
  call ol_merge_tensors(T0sum(526),[G0tensor(829)])
  call ol_merge_tensors(T0sum(527),[G0tensor(729)])
  call ol_merge_tensors(T0sum(528),[G0tensor(924)])
  call ol_merge_tensors(T0sum(529),[G0tensor(664)])
  call ol_merge_tensors(T0sum(530),[G0tensor(1024)])
  call ol_merge_tensors(T0sum(531),[G0tensor(709)])
  call ol_merge_tensors(T0sum(532),[G0tensor(944)])
  call ol_merge_tensors(T0sum(533),[G0tensor(819)])
  call ol_merge_tensors(T0sum(534),[G0tensor(839)])
  call ol_merge_tensors(T0sum(535),[G0tensor(919)])
  call ol_merge_tensors(T0sum(536),[G0tensor(1008)])
  call ol_merge_tensors(T0sum(537),[G0tensor(1044)])
  call ol_merge_tensors(T0sum(538),[G0tensor(959)])
  call ol_merge_tensors(T0sum(539),[G0tensor(979)])
  call ol_merge_tensors(T0sum(540),[G0tensor(1087)])
  call ol_merge_tensors(T0sum(541),[G0tensor(1089)])
  call ol_merge_tensors(T0sum(542),[G0tensor(1107)])
  call ol_merge_tensors(T0sum(543),[G0tensor(1118)])
  call ol_merge_tensors(T0sum(544),[G0tensor(1139)])
  call ol_merge_tensors(T0sum(545),[G0tensor(1353)])
  call ol_merge_tensors(T0sum(546),[G0tensor(543)])
  call ol_merge_tensors(T0sum(547),[G0tensor(1129)])
  call ol_merge_tensors(T0sum(548),[G0tensor(1158)])
  call ol_merge_tensors(T0sum(549),[G0tensor(1163)])
  call ol_merge_tensors(T0sum(550),[G0tensor(1168)])
  call ol_merge_tensors(T0sum(551),[G0tensor(262)])
  call ol_merge_tensors(T0sum(552),[G0tensor(842)])
  call ol_merge_tensors(T0sum(553),[G0tensor(487)])
  call ol_merge_tensors(T0sum(554),[G0tensor(1188)])
  call ol_merge_tensors(T0sum(555),[G0tensor(1318)])
  call ol_merge_tensors(T0sum(556),[G0tensor(797)])
  call ol_merge_tensors(T0sum(557),[G0tensor(538)])
  call ol_merge_tensors(T0sum(558),[G0tensor(1448)])
  call ol_merge_tensors(T0sum(559),[G0tensor(1095)])
  call ol_merge_tensors(T0sum(560),[G0tensor(1110)])
  call ol_merge_tensors(T0sum(561),[G0tensor(505)])
  call ol_merge_tensors(T0sum(562),[G0tensor(18)])
  call ol_merge_tensors(T0sum(563),[G0tensor(1062)])
  call ol_merge_tensors(T0sum(564),[G0tensor(37)])
  call ol_merge_tensors(T0sum(565),[G0tensor(479)])
  call ol_merge_tensors(T0sum(566),[G0tensor(455)])
  call ol_merge_tensors(T0sum(567),[G0tensor(1097)])
  call ol_merge_tensors(T0sum(568),[G0tensor(1014)])
  call ol_merge_tensors(T0sum(569),[G0tensor(84)])
  call ol_merge_tensors(T0sum(570),[G0tensor(695)])
  call ol_merge_tensors(T0sum(571),[G0tensor(42)])
  call ol_merge_tensors(T0sum(572),[G0tensor(722)])
  call ol_merge_tensors(T0sum(573),[G0tensor(44)])
  call ol_merge_tensors(T0sum(574),[G0tensor(90)])
  call ol_merge_tensors(T0sum(575),[G0tensor(815)])
  call ol_merge_tensors(T0sum(576),[G0tensor(687)])
  call ol_merge_tensors(T0sum(577),[G0tensor(697)])
  call ol_merge_tensors(T0sum(578),[G0tensor(682)])
  call ol_merge_tensors(T0sum(579),[G0tensor(742)])
  call ol_merge_tensors(T0sum(580),[G0tensor(727)])
  call ol_merge_tensors(T0sum(581),[G0tensor(757)])
  call ol_merge_tensors(T0sum(582),[G0tensor(787)])
  call ol_merge_tensors(T0sum(583),[G0tensor(782)])
  call ol_merge_tensors(T0sum(584),[G0tensor(892)])
  call ol_merge_tensors(T0sum(585),[G0tensor(887)])
  call ol_merge_tensors(T0sum(586),[G0tensor(942)])
  call ol_merge_tensors(T0sum(587),[G0tensor(1002)])
  call ol_merge_tensors(T0sum(588),[G0tensor(1047)])
  call ol_merge_tensors(T0sum(589),[G0tensor(754)])
  call ol_merge_tensors(T0sum(590),[G0tensor(779)])
  call ol_merge_tensors(T0sum(591),[G0tensor(1039)])
  call ol_merge_tensors(T0sum(592),[G0tensor(1079)])
  call ol_merge_tensors(T0sum(593),[G0tensor(1372)])
  call ol_merge_tensors(T0sum(594),[G0tensor(1373)])
  call ol_merge_tensors(T0sum(595),[G0tensor(1375)])
  call ol_merge_tensors(T0sum(596),[G0tensor(1377)])
  call ol_merge_tensors(T0sum(597),[G0tensor(1378)])
  call ol_merge_tensors(T0sum(598),[G0tensor(1380)])
  call ol_merge_tensors(T0sum(599),[G0tensor(1382)])
  call ol_merge_tensors(T0sum(600),[G0tensor(1404)])
  call ol_merge_tensors(T0sum(601),[G0tensor(1385)])
  call ol_merge_tensors(T0sum(602),[G0tensor(1388)])
  call ol_merge_tensors(T0sum(603),[G0tensor(1389)])
  call ol_merge_tensors(T0sum(604),[G0tensor(1425)])
  call ol_merge_tensors(T0sum(605),[G0tensor(1392)])
  call ol_merge_tensors(T0sum(606),[G0tensor(1393)])
  call ol_merge_tensors(T0sum(607),[G0tensor(1395)])
  call ol_merge_tensors(T0sum(608),[G0tensor(1397)])
  call ol_merge_tensors(T0sum(609),[G0tensor(1398)])
  call ol_merge_tensors(T0sum(610),[G0tensor(1400)])
  call ol_merge_tensors(T0sum(611),[G0tensor(1402)])
  call ol_merge_tensors(T0sum(612),[G0tensor(1405)])
  call ol_merge_tensors(T0sum(613),[G0tensor(1408)])
  call ol_merge_tensors(T0sum(614),[G0tensor(1409)])
  call ol_merge_tensors(T0sum(615),[G0tensor(1440)])
  call ol_merge_tensors(T0sum(616),[G0tensor(1418)])
  call ol_merge_tensors(T0sum(617),[G0tensor(1424)])
  call ol_merge_tensors(T0sum(618),[G0tensor(1435)])
  call ol_merge_tensors(T0sum(619),[G0tensor(1423)])
  call ol_merge_tensors(T0sum(620),[G0tensor(1433)])
  call ol_merge_tensors(T0sum(621),[G0tensor(1439)])
  call ol_merge_tensors(T0sum(622),[G0tensor(1438)])
  call ol_merge_tensors(T0sum(623),[G0tensor(734)])
  call ol_merge_tensors(T0sum(624),[G0tensor(1135)])
  call ol_merge_tensors(T0sum(625),[G0tensor(95)])
  call ol_merge_tensors(T0sum(626),[G0tensor(847)])
  call ol_merge_tensors(T0sum(627),[G0tensor(1177)])
  call ol_merge_tensors(T0sum(628),[G0tensor(159)])
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(603),h0tab(:,603),[58,5],[nMW,nMW],3,3,wf4(:,2),wf4(:,7),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,2),wf4(:,7),G0H4(10),m4h4x4x4(:,9),heltab3x64(:,:,9))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(604),h0tab(:,604),[58,5],[nMW,nMW],3,3,wf4(:,2),wf4(:,3),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,2),wf4(:,3),G0H4(3),m4h4x4x4(:,10),heltab3x64(:,:,10))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(605),h0tab(:,605),[58,5],[nMW,nMW],3,3,wf4(:,2),wf4(:,7),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,2),wf4(:,7),G0H4(9),m4h4x4x4(:,11),heltab3x64(:,:,11))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(606),h0tab(:,606),[58,5],[nMW,nMW],3,3,wf4(:,2),wf4(:,3),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,2),wf4(:,3),G0H4(13),m4h4x4x4(:,12),heltab3x64(:,:,12))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(607),h0tab(:,607),[53,10],[nMW,nMW],3,3,wf4(:,1),wf4(:,7),wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,1),wf4(:,7),G0H4(16),m4h4x4x4(:,13),heltab3x64(:,:,13))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(608),h0tab(:,608),[53,10],[nMW,nMW],3,3,wf4(:,1),wf4(:,3),wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,1),wf4(:,3),G0H4(8),m4h4x4x4(:,14),heltab3x64(:,:,14))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(609),h0tab(:,609),[53,10],[nMW,nMW],3,3,wf4(:,1),wf4(:,7),wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,1),wf4(:,7),G0H4(11),m4h4x4x4(:,15),heltab3x64(:,:,15))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(610),h0tab(:,610),[53,10],[nMW,nMW],3,3,wf4(:,1),wf4(:,3),wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,1),wf4(:,3),G0H4(7),m4h4x4x4(:,16),heltab3x64(:,:,16))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(611),h0tab(:,611),[48,15],[nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(3),m3h4x16(:,277),heltab2x64(:,:,595))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(224)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(612),h0tab(:,612),[48,15],[nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(2),m3h4x16(:,278),heltab2x64(:,:,596))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(613),h0tab(:,613),[48,15],[nMW,nMW],3,3,wf4(:,7),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(7),m3h4x16(:,279),heltab2x64(:,:,597))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(224)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(614),h0tab(:,614),[48,15],[nMW,nMW],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(12),m3h4x16(:,280),heltab2x64(:,:,598))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(615),h0tab(:,615),[54,9],[nMW,nMW],3,3,wf4(:,5),wf4(:,7),wf4(:,4))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,5),wf4(:,7),G0H4(15),m4h4x4x4(:,17),heltab3x64(:,:,17))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(226)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(616),h0tab(:,616),[54,9],[nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,3),wf4(:,5),G0H4(4),m4h4x4x4(:,18),heltab3x64(:,:,18))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(617),h0tab(:,617),[54,9],[nMW,nMW],3,3,wf4(:,5),wf4(:,7),wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,5),wf4(:,7),G0H4(6),m4h4x4x4(:,19),heltab3x64(:,:,19))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(226)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(618),h0tab(:,618),[54,9],[nMW,nMW],3,3,wf4(:,3),wf4(:,5),wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,3),wf4(:,5),G0H4(2),m4h4x4x4(:,20),heltab3x64(:,:,20))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(619),h0tab(:,619),[57,6],[nMW,nMW],3,3,wf4(:,4),wf4(:,7),wf4(:,5))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,4),wf4(:,7),G0H4(1),m4h4x4x4(:,21),heltab3x64(:,:,21))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(620),h0tab(:,620),[57,6],[nMW,nMW],3,3,wf4(:,3),wf4(:,4),wf4(:,5))
  call Hloop_SVV_S(ntryL,G0H64(1),wf4(:,3),wf4(:,4),G0H4(17),m4h4x4x4(:,22),heltab3x64(:,:,22))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(621),h0tab(:,621),[57,6],[nMW,nMW],3,3,wf4(:,4),wf4(:,7),wf4(:,5))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,4),wf4(:,7),G0H4(12),m4h4x4x4(:,23),heltab3x64(:,:,23))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(622),h0tab(:,622),[57,6],[nMW,nMW],3,3,wf4(:,3),wf4(:,4),wf4(:,5))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,3),wf4(:,4),G0H4(5),m4h4x4x4(:,24),heltab3x64(:,:,24))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(623),h0tab(:,623),[48,15],[nMW,nMW],3,3,wf4(:,7),wf4(:,4),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(9),m3h4x16(:,281),heltab2x64(:,:,599))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(624),h0tab(:,624),[48,15],[nMW,nMW],3,3,wf4(:,3),wf4(:,4),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(14),m3h4x16(:,282),heltab2x64(:,:,600))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(625),h0tab(:,625),[48,15],[nMW,nMW],3,3,wf4(:,7),wf4(:,4),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(16),m3h4x16(:,283),heltab2x64(:,:,601))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(626),h0tab(:,626),[48,15],[nMW,nMW],3,3,wf4(:,3),wf4(:,4),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(22),m3h4x16(:,284),heltab2x64(:,:,602))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(627),h0tab(:,627),[48,15],[nML,nML],2,2,wf4(:,7),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(33),m3h4x16(:,285),heltab2x64(:,:,603))
  call Hloop_Q_A(ntryL,G0H16(33),48,nML,G1H16(5),n2h16(195))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(628),h0tab(:,628),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(22),m3h4x16(:,286),heltab2x64(:,:,604))
  call Hloop_Q_A(ntryL,G0H16(22),48,nMT,G1H16(24),n2h16(196))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(629),h0tab(:,629),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(3),m3h4x16(:,287),heltab2x64(:,:,605))
  call Hloop_Q_A(ntryL,G0H16(3),48,nMB,G1H16(10),n2h16(197))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(630),h0tab(:,630),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(15),ngZl,m3h4x16(:,288),heltab2x64(:,:,606))
  call Hloop_Q_A(ntryL,G0H16(15),48,nML,G1H16(18),n2h16(198))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(631),h0tab(:,631),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(14),ngZu,m3h4x16(:,289),heltab2x64(:,:,607))
  call Hloop_Q_A(ntryL,G0H16(14),48,nMT,G1H16(47),n2h16(199))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(632),h0tab(:,632),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(5),ngZd,m3h4x16(:,290),heltab2x64(:,:,608))
  call Hloop_Q_A(ntryL,G0H16(5),48,nMB,G1H16(50),n2h16(200))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(633),h0tab(:,633),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(6),m3h4x16(:,291),heltab2x64(:,:,609))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(634),h0tab(:,634),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(1),m3h4x16(:,292),heltab2x64(:,:,610))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(635),h0tab(:,635),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(54),m3h4x16(:,293),heltab2x64(:,:,611))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(636),h0tab(:,636),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(11),m3h4x16(:,294),heltab2x64(:,:,612))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(637),h0tab(:,637),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(4),m3h4x16(:,295),heltab2x64(:,:,613))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(638),h0tab(:,638),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(56),m3h4x16(:,296),heltab2x64(:,:,614))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(639),h0tab(:,639),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(21),m3h4x16(:,297),heltab2x64(:,:,615))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(640),h0tab(:,640),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(8),m3h4x16(:,298),heltab2x64(:,:,616))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(641),h0tab(:,641),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(25),m3h4x16(:,299),heltab2x64(:,:,617))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(642),h0tab(:,642),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(7),m3h4x16(:,300),heltab2x64(:,:,618))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(643),h0tab(:,643),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(10),m3h4x16(:,301),heltab2x64(:,:,619))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(644),h0tab(:,644),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(12),m3h4x16(:,302),heltab2x64(:,:,620))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(645),h0tab(:,645),[53,10],[nML,nML],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,2),G0H4(14),ngH,m3h16x4(:,73),heltab2x64(:,:,621))
  call Hloop_Q_A(ntryL,G0H4(14),53,nML,G1H4(108),n2h4(201))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(646),h0tab(:,646),[53,10],[nMT,nMT],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,2),G0H4(14),ngH,m3h16x4(:,74),heltab2x64(:,:,622))
  call Hloop_Q_A(ntryL,G0H4(14),53,nMT,G1H4(42),n2h4(202))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(647),h0tab(:,647),[53,10],[nMB,nMB],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,2),G0H4(14),ngH,m3h16x4(:,75),heltab2x64(:,:,623))
  call Hloop_Q_A(ntryL,G0H4(14),53,nMB,G1H4(43),n2h4(203))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(648),h0tab(:,648),[53,10],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,2),G0H4(14),m3h16x4(:,76),heltab2x64(:,:,624))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(649),h0tab(:,649),[53,10],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,2),G0H4(18),m3h16x4(:,77),heltab2x64(:,:,625))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(650),h0tab(:,650),[53,10],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,2),G0H4(19),m3h16x4(:,78),heltab2x64(:,:,626))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(651),h0tab(:,651),[53,10],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,2),G0H4(20),m3h16x4(:,79),heltab2x64(:,:,627))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(652),h0tab(:,652),[53,10],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,2),53,G1H4(128),m3h16x4(:,80),heltab2x64(:,:,628))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(653),h0tab(:,653),[53,10],[nMW,nMW],2,2,wf16(:,2),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,2),53,G1H4(22),m3h16x4(:,81),heltab2x64(:,:,629))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(654),h0tab(:,654),[58,5],[nML,nML],2,2,wf16(:,24),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,24),G0H4(21),ngH,m3h16x4(:,82),heltab2x64(:,:,630))
  call Hloop_Q_A(ntryL,G0H4(21),58,nML,G1H4(52),n2h4(204))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(655),h0tab(:,655),[58,5],[nMT,nMT],2,2,wf16(:,24),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,24),G0H4(21),ngH,m3h16x4(:,83),heltab2x64(:,:,631))
  call Hloop_Q_A(ntryL,G0H4(21),58,nMT,G1H4(40),n2h4(205))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(656),h0tab(:,656),[58,5],[nMB,nMB],2,2,wf16(:,24),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,24),G0H4(21),ngH,m3h16x4(:,84),heltab2x64(:,:,632))
  call Hloop_Q_A(ntryL,G0H4(21),58,nMB,G1H4(28),n2h4(206))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(657),h0tab(:,657),[58,5],[nMW,nMW],2,2,wf16(:,24),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,24),G0H4(21),m3h16x4(:,85),heltab2x64(:,:,633))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(658),h0tab(:,658),[58,5],[nMW,nMW],2,2,wf16(:,24),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,24),G0H4(22),m3h16x4(:,86),heltab2x64(:,:,634))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(659),h0tab(:,659),[58,5],[nMW,nMW],2,2,wf16(:,24),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,24),G0H4(23),m3h16x4(:,87),heltab2x64(:,:,635))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(660),h0tab(:,660),[58,5],[nMW,nMW],2,2,wf16(:,24),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,24),G0H4(24),m3h16x4(:,88),heltab2x64(:,:,636))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(661),h0tab(:,661),[58,5],[nMW,nMW],2,2,wf16(:,24),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,24),58,G1H4(90),m3h16x4(:,89),heltab2x64(:,:,637))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(662),h0tab(:,662),[58,5],[nMW,nMW],2,2,wf16(:,24),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,24),58,G1H4(27),m3h16x4(:,90),heltab2x64(:,:,638))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(663),h0tab(:,663),[42,21],[0,0],2,2,wf8(:,36),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,36),G0H8(18),m3h8x8(:,77),heltab2x64(:,:,639))
  call Hloop_A_Q(ntryL,G0H8(18),42,0,G1H8(27),n2h8(111))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(664),h0tab(:,664),[42,21],[0,nMZ],2,2,wf8(:,36),wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,36),G0H8(19),ngZu,m3h8x8(:,78),heltab2x64(:,:,640))
  call Hloop_A_Q(ntryL,G0H8(19),42,0,G1H8(1),n2h8(112))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(665),h0tab(:,665),[42,21],[0,nMW],2,2,wf8(:,36),wf8(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,36),G0H8(21),m3h8x8(:,79),heltab2x64(:,:,641))
  call Hloop_A_Q(ntryL,G0H8(21),42,0,G1H8(29),n2h8(113))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(666),h0tab(:,666),[53,10],[0,0],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(25),m3h16x4(:,91),heltab2x64(:,:,642))
  call Hloop_Q_A(ntryL,G0H4(25),53,0,G1H4(95),n2h4(207))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(667),h0tab(:,667),[53,10],[nML,nML],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(25),m3h16x4(:,92),heltab2x64(:,:,643))
  call Hloop_Q_A(ntryL,G0H4(25),53,nML,G1H4(84),n2h4(208))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(668),h0tab(:,668),[53,10],[0,0],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(25),m3h16x4(:,93),heltab2x64(:,:,644))
  call Hloop_Q_A(ntryL,G0H4(25),53,0,G1H4(83),n2h4(209))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(669),h0tab(:,669),[53,10],[nMT,nMT],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(25),m3h16x4(:,94),heltab2x64(:,:,645))
  call Hloop_Q_A(ntryL,G0H4(25),53,nMT,G1H4(74),n2h4(210))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(670),h0tab(:,670),[53,10],[0,0],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(25),m3h16x4(:,95),heltab2x64(:,:,646))
  call Hloop_Q_A(ntryL,G0H4(25),53,0,G1H4(73),n2h4(211))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(671),h0tab(:,671),[53,10],[nMB,nMB],2,2,wf16(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(25),m3h16x4(:,96),heltab2x64(:,:,647))
  call Hloop_Q_A(ntryL,G0H4(25),53,nMB,G1H4(37),n2h4(212))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(672),h0tab(:,672),[53,10],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(25),ngZn,m3h16x4(:,97),heltab2x64(:,:,648))
  call Hloop_Q_A(ntryL,G0H4(25),53,0,G1H4(99),n2h4(213))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(673),h0tab(:,673),[53,10],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(25),ngZl,m3h16x4(:,98),heltab2x64(:,:,649))
  call Hloop_Q_A(ntryL,G0H4(25),53,0,G1H4(96),n2h4(214))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(674),h0tab(:,674),[53,10],[nML,nML],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(25),ngZl,m3h16x4(:,99),heltab2x64(:,:,650))
  call Hloop_Q_A(ntryL,G0H4(25),53,nML,G1H4(59),n2h4(215))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(675),h0tab(:,675),[53,10],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(25),ngZu,m3h16x4(:,100),heltab2x64(:,:,651))
  call Hloop_Q_A(ntryL,G0H4(25),53,0,G1H4(94),n2h4(216))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(676),h0tab(:,676),[53,10],[nMT,nMT],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(25),ngZu,m3h16x4(:,101),heltab2x64(:,:,652))
  call Hloop_Q_A(ntryL,G0H4(25),53,nMT,G1H4(80),n2h4(217))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(677),h0tab(:,677),[53,10],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(25),ngZd,m3h16x4(:,102),heltab2x64(:,:,653))
  call Hloop_Q_A(ntryL,G0H4(25),53,0,G1H4(78),n2h4(218))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(678),h0tab(:,678),[53,10],[nMB,nMB],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,6),G0H4(25),ngZd,m3h16x4(:,103),heltab2x64(:,:,654))
  call Hloop_Q_A(ntryL,G0H4(25),53,nMB,G1H4(29),n2h4(219))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(679),h0tab(:,679),[53,10],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,5),53,G1H4(68),m3h16x4(:,104),heltab2x64(:,:,655))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(680),h0tab(:,680),[53,10],[nMH,nMZ],2,2,wf16(:,6),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,6),53,G1H4(91),m3h16x4(:,105),heltab2x64(:,:,656))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(681),h0tab(:,681),[53,10],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,6),53,G1H4(79),m3h16x4(:,106),heltab2x64(:,:,657))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(682),h0tab(:,682),[53,10],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,5),53,G1H4(72),m3h16x4(:,107),heltab2x64(:,:,658))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(683),h0tab(:,683),[53,10],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,5),53,G1H4(112),m3h16x4(:,108),heltab2x64(:,:,659))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(684),h0tab(:,684),[53,10],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,6),53,G1H4(48),m3h16x4(:,109),heltab2x64(:,:,660))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(685),h0tab(:,685),[53,10],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,6),53,G1H4(8),m3h16x4(:,110),heltab2x64(:,:,661))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(686),h0tab(:,686),[53,10],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,5),53,G1H4(89),m3h16x4(:,111),heltab2x64(:,:,662))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(687),h0tab(:,687),[53,10],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,6),53,G1H4(85),m3h16x4(:,112),heltab2x64(:,:,663))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(688),h0tab(:,688),[53,10],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,5),G0H4(25),m3h16x4(:,113),heltab2x64(:,:,664))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(689),h0tab(:,689),[53,10],[nMW,nMW],2,2,wf16(:,5),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,5),G0H4(26),m3h16x4(:,114),heltab2x64(:,:,665))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(690),h0tab(:,690),[53,10],[nMH,nMZ],2,2,wf16(:,6),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,6),G0H4(27),m3h16x4(:,115),heltab2x64(:,:,666))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(691),h0tab(:,691),[53,10],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,6),G0H4(28),m3h16x4(:,116),heltab2x64(:,:,667))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(692),h0tab(:,692),[53,10],[nMW,nMW],2,2,wf16(:,6),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,6),G0H4(29),m3h16x4(:,117),heltab2x64(:,:,668))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(693),h0tab(:,693),[37,26],[0,0],2,2,wf8(:,34),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,34),G0H8(22),m3h8x8(:,80),heltab2x64(:,:,669))
  call Hloop_A_Q(ntryL,G0H8(22),37,0,G1H8(30),n2h8(114))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(694),h0tab(:,694),[37,26],[0,nMZ],2,2,wf8(:,34),wf8(:,6))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,34),G0H8(23),ngZu,m3h8x8(:,81),heltab2x64(:,:,670))
  call Hloop_A_Q(ntryL,G0H8(23),37,0,G1H8(32),n2h8(115))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(695),h0tab(:,695),[37,26],[0,nMW],2,2,wf8(:,34),wf8(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,34),G0H8(25),m3h8x8(:,82),heltab2x64(:,:,671))
  call Hloop_A_Q(ntryL,G0H8(25),37,0,G1H8(33),n2h8(116))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(696),h0tab(:,696),[53,10],[0,0],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(30),m3h16x4(:,118),heltab2x64(:,:,672))
  call Hloop_Q_A(ntryL,G0H4(30),53,0,G1H4(115),n2h4(220))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(697),h0tab(:,697),[53,10],[nML,nML],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(30),m3h16x4(:,119),heltab2x64(:,:,673))
  call Hloop_Q_A(ntryL,G0H4(30),53,nML,G1H4(2),n2h4(221))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(698),h0tab(:,698),[53,10],[0,0],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(30),m3h16x4(:,120),heltab2x64(:,:,674))
  call Hloop_Q_A(ntryL,G0H4(30),53,0,G1H4(107),n2h4(222))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(699),h0tab(:,699),[53,10],[nMT,nMT],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(30),m3h16x4(:,121),heltab2x64(:,:,675))
  call Hloop_Q_A(ntryL,G0H4(30),53,nMT,G1H4(104),n2h4(223))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(700),h0tab(:,700),[53,10],[0,0],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(30),m3h16x4(:,122),heltab2x64(:,:,676))
  call Hloop_Q_A(ntryL,G0H4(30),53,0,G1H4(125),n2h4(224))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(701),h0tab(:,701),[53,10],[nMB,nMB],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(30),m3h16x4(:,123),heltab2x64(:,:,677))
  call Hloop_Q_A(ntryL,G0H4(30),53,nMB,G1H4(122),n2h4(225))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(702),h0tab(:,702),[53,10],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(30),ngZn,m3h16x4(:,124),heltab2x64(:,:,678))
  call Hloop_Q_A(ntryL,G0H4(30),53,0,G1H4(3),n2h4(226))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(703),h0tab(:,703),[53,10],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(30),ngZl,m3h16x4(:,125),heltab2x64(:,:,679))
  call Hloop_Q_A(ntryL,G0H4(30),53,0,G1H4(49),n2h4(227))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(704),h0tab(:,704),[53,10],[nML,nML],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(30),ngZl,m3h16x4(:,126),heltab2x64(:,:,680))
  call Hloop_Q_A(ntryL,G0H4(30),53,nML,G1H4(56),n2h4(228))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(705),h0tab(:,705),[53,10],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(30),ngZu,m3h16x4(:,127),heltab2x64(:,:,681))
  call Hloop_Q_A(ntryL,G0H4(30),53,0,G1H4(60),n2h4(229))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(706),h0tab(:,706),[53,10],[nMT,nMT],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(30),ngZu,m3h16x4(:,128),heltab2x64(:,:,682))
  call Hloop_Q_A(ntryL,G0H4(30),53,nMT,G1H4(9),n2h4(230))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(707),h0tab(:,707),[53,10],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(30),ngZd,m3h16x4(:,129),heltab2x64(:,:,683))
  call Hloop_Q_A(ntryL,G0H4(30),53,0,G1H4(54),n2h4(231))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(708),h0tab(:,708),[53,10],[nMB,nMB],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,8),G0H4(30),ngZd,m3h16x4(:,130),heltab2x64(:,:,684))
  call Hloop_Q_A(ntryL,G0H4(30),53,nMB,G1H4(55),n2h4(232))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(709),h0tab(:,709),[53,10],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,7),53,G1H4(20),m3h16x4(:,131),heltab2x64(:,:,685))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(710),h0tab(:,710),[53,10],[nMH,nMZ],2,2,wf16(:,8),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,8),53,G1H4(21),m3h16x4(:,132),heltab2x64(:,:,686))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(711),h0tab(:,711),[53,10],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,8),53,G1H4(5),m3h16x4(:,133),heltab2x64(:,:,687))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(712),h0tab(:,712),[53,10],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,7),53,G1H4(53),m3h16x4(:,134),heltab2x64(:,:,688))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(713),h0tab(:,713),[53,10],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,7),53,G1H4(71),m3h16x4(:,135),heltab2x64(:,:,689))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(714),h0tab(:,714),[53,10],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,8),53,G1H4(105),m3h16x4(:,136),heltab2x64(:,:,690))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(715),h0tab(:,715),[53,10],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,8),53,G1H4(116),m3h16x4(:,137),heltab2x64(:,:,691))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(716),h0tab(:,716),[53,10],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,7),53,G1H4(57),m3h16x4(:,138),heltab2x64(:,:,692))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(717),h0tab(:,717),[53,10],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,8),53,G1H4(65),m3h16x4(:,139),heltab2x64(:,:,693))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(718),h0tab(:,718),[53,10],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,7),G0H4(30),m3h16x4(:,140),heltab2x64(:,:,694))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(719),h0tab(:,719),[53,10],[nMW,nMW],2,2,wf16(:,7),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,7),G0H4(31),m3h16x4(:,141),heltab2x64(:,:,695))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(720),h0tab(:,720),[53,10],[nMH,nMZ],2,2,wf16(:,8),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,8),G0H4(32),m3h16x4(:,142),heltab2x64(:,:,696))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(721),h0tab(:,721),[53,10],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,8),G0H4(33),m3h16x4(:,143),heltab2x64(:,:,697))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(722),h0tab(:,722),[53,10],[nMW,nMW],2,2,wf16(:,8),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,8),G0H4(34),m3h16x4(:,144),heltab2x64(:,:,698))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(723),h0tab(:,723),[58,5],[0,0],2,2,wf16(:,27),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,27),G0H4(35),m3h16x4(:,145),heltab2x64(:,:,699))
  call Hloop_Q_A(ntryL,G0H4(35),58,0,G1H4(69),n2h4(233))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(724),h0tab(:,724),[58,5],[nML,nML],2,2,wf16(:,27),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,27),G0H4(35),m3h16x4(:,146),heltab2x64(:,:,700))
  call Hloop_Q_A(ntryL,G0H4(35),58,nML,G1H4(33),n2h4(234))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(725),h0tab(:,725),[58,5],[0,0],2,2,wf16(:,27),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,27),G0H4(35),m3h16x4(:,147),heltab2x64(:,:,701))
  call Hloop_Q_A(ntryL,G0H4(35),58,0,G1H4(34),n2h4(235))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(726),h0tab(:,726),[58,5],[nMT,nMT],2,2,wf16(:,27),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,27),G0H4(35),m3h16x4(:,148),heltab2x64(:,:,702))
  call Hloop_Q_A(ntryL,G0H4(35),58,nMT,G1H4(92),n2h4(236))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(727),h0tab(:,727),[58,5],[0,0],2,2,wf16(:,27),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,27),G0H4(35),m3h16x4(:,149),heltab2x64(:,:,703))
  call Hloop_Q_A(ntryL,G0H4(35),58,0,G1H4(93),n2h4(237))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(728),h0tab(:,728),[58,5],[nMB,nMB],2,2,wf16(:,27),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,27),G0H4(35),m3h16x4(:,150),heltab2x64(:,:,704))
  call Hloop_Q_A(ntryL,G0H4(35),58,nMB,G1H4(97),n2h4(238))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(729),h0tab(:,729),[58,5],[0,0],2,2,wf16(:,28),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,28),G0H4(35),ngZn,m3h16x4(:,151),heltab2x64(:,:,705))
  call Hloop_Q_A(ntryL,G0H4(35),58,0,G1H4(98),n2h4(239))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(730),h0tab(:,730),[58,5],[0,0],2,2,wf16(:,28),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,28),G0H4(35),ngZl,m3h16x4(:,152),heltab2x64(:,:,706))
  call Hloop_Q_A(ntryL,G0H4(35),58,0,G1H4(100),n2h4(240))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(731),h0tab(:,731),[58,5],[nML,nML],2,2,wf16(:,28),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,28),G0H4(35),ngZl,m3h16x4(:,153),heltab2x64(:,:,707))
  call Hloop_Q_A(ntryL,G0H4(35),58,nML,G1H4(101),n2h4(241))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(732),h0tab(:,732),[58,5],[0,0],2,2,wf16(:,28),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,28),G0H4(35),ngZu,m3h16x4(:,154),heltab2x64(:,:,708))
  call Hloop_Q_A(ntryL,G0H4(35),58,0,G1H4(106),n2h4(242))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(733),h0tab(:,733),[58,5],[nMT,nMT],2,2,wf16(:,28),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,28),G0H4(35),ngZu,m3h16x4(:,155),heltab2x64(:,:,709))
  call Hloop_Q_A(ntryL,G0H4(35),58,nMT,G1H4(110),n2h4(243))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(734),h0tab(:,734),[58,5],[0,0],2,2,wf16(:,28),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,28),G0H4(35),ngZd,m3h16x4(:,156),heltab2x64(:,:,710))
  call Hloop_Q_A(ntryL,G0H4(35),58,0,G1H4(111),n2h4(244))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(735),h0tab(:,735),[58,5],[nMB,nMB],2,2,wf16(:,28),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,28),G0H4(35),ngZd,m3h16x4(:,157),heltab2x64(:,:,711))
  call Hloop_Q_A(ntryL,G0H4(35),58,nMB,G1H4(113),n2h4(245))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(736),h0tab(:,736),[58,5],[nMW,nMW],2,2,wf16(:,27),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,27),58,G1H4(114),m3h16x4(:,158),heltab2x64(:,:,712))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(737),h0tab(:,737),[58,5],[nMH,nMZ],2,2,wf16(:,28),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,28),58,G1H4(118),m3h16x4(:,159),heltab2x64(:,:,713))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(738),h0tab(:,738),[58,5],[nMW,nMW],2,2,wf16(:,28),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,28),58,G1H4(119),m3h16x4(:,160),heltab2x64(:,:,714))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(739),h0tab(:,739),[58,5],[nMW,nMW],2,2,wf16(:,27),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,27),58,G1H4(123),m3h16x4(:,161),heltab2x64(:,:,715))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(740),h0tab(:,740),[58,5],[nMW,nMW],2,2,wf16(:,27),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,27),58,G1H4(124),m3h16x4(:,162),heltab2x64(:,:,716))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(741),h0tab(:,741),[58,5],[nMW,nMW],2,2,wf16(:,28),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,28),58,G1H4(126),m3h16x4(:,163),heltab2x64(:,:,717))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(742),h0tab(:,742),[58,5],[nMW,nMW],2,2,wf16(:,28),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,28),58,G1H4(127),m3h16x4(:,164),heltab2x64(:,:,718))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(743),h0tab(:,743),[58,5],[nMW,nMW],2,2,wf16(:,27),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,27),58,G1H4(45),m3h16x4(:,165),heltab2x64(:,:,719))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(744),h0tab(:,744),[58,5],[nMW,nMW],2,2,wf16(:,28),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,28),58,G1H4(103),m3h16x4(:,166),heltab2x64(:,:,720))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(745),h0tab(:,745),[58,5],[nMW,nMW],2,2,wf16(:,27),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,27),G0H4(35),m3h16x4(:,167),heltab2x64(:,:,721))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(746),h0tab(:,746),[58,5],[nMW,nMW],2,2,wf16(:,27),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,27),G0H4(36),m3h16x4(:,168),heltab2x64(:,:,722))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(747),h0tab(:,747),[58,5],[nMH,nMZ],2,2,wf16(:,28),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,28),G0H4(37),m3h16x4(:,169),heltab2x64(:,:,723))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(748),h0tab(:,748),[58,5],[nMW,nMW],2,2,wf16(:,28),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,28),G0H4(38),m3h16x4(:,170),heltab2x64(:,:,724))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(749),h0tab(:,749),[58,5],[nMW,nMW],2,2,wf16(:,28),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,28),G0H4(39),m3h16x4(:,171),heltab2x64(:,:,725))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(750),h0tab(:,750),[58,5],[0,0],2,2,wf16(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,29),G0H4(40),m3h16x4(:,172),heltab2x64(:,:,726))
  call Hloop_Q_A(ntryL,G0H4(40),58,0,G1H4(17),n2h4(246))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(751),h0tab(:,751),[58,5],[nML,nML],2,2,wf16(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,29),G0H4(40),m3h16x4(:,173),heltab2x64(:,:,727))
  call Hloop_Q_A(ntryL,G0H4(40),58,nML,G1H4(39),n2h4(247))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(752),h0tab(:,752),[58,5],[0,0],2,2,wf16(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,29),G0H4(40),m3h16x4(:,174),heltab2x64(:,:,728))
  call Hloop_Q_A(ntryL,G0H4(40),58,0,G1H4(11),n2h4(248))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(753),h0tab(:,753),[58,5],[nMT,nMT],2,2,wf16(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,29),G0H4(40),m3h16x4(:,175),heltab2x64(:,:,729))
  call Hloop_Q_A(ntryL,G0H4(40),58,nMT,G1H4(109),n2h4(249))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(754),h0tab(:,754),[58,5],[0,0],2,2,wf16(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,29),G0H4(40),m3h16x4(:,176),heltab2x64(:,:,730))
  call Hloop_Q_A(ntryL,G0H4(40),58,0,G1H4(35),n2h4(250))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(755),h0tab(:,755),[58,5],[nMB,nMB],2,2,wf16(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,29),G0H4(40),m3h16x4(:,177),heltab2x64(:,:,731))
  call Hloop_Q_A(ntryL,G0H4(40),58,nMB,G1H4(88),n2h4(251))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(756),h0tab(:,756),[58,5],[0,0],2,2,wf16(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,30),G0H4(40),ngZn,m3h16x4(:,178),heltab2x64(:,:,732))
  call Hloop_Q_A(ntryL,G0H4(40),58,0,G1H4(4),n2h4(252))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(757),h0tab(:,757),[58,5],[0,0],2,2,wf16(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,30),G0H4(40),ngZl,m3h16x4(:,179),heltab2x64(:,:,733))
  call Hloop_Q_A(ntryL,G0H4(40),58,0,G1H4(36),n2h4(253))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(758),h0tab(:,758),[58,5],[nML,nML],2,2,wf16(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,30),G0H4(40),ngZl,m3h16x4(:,180),heltab2x64(:,:,734))
  call Hloop_Q_A(ntryL,G0H4(40),58,nML,G1H4(50),n2h4(254))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(759),h0tab(:,759),[58,5],[0,0],2,2,wf16(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,30),G0H4(40),ngZu,m3h16x4(:,181),heltab2x64(:,:,735))
  call Hloop_Q_A(ntryL,G0H4(40),58,0,G1H4(61),n2h4(255))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(760),h0tab(:,760),[58,5],[nMT,nMT],2,2,wf16(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,30),G0H4(40),ngZu,m3h16x4(:,182),heltab2x64(:,:,736))
  call Hloop_Q_A(ntryL,G0H4(40),58,nMT,G1H4(38),n2h4(256))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(761),h0tab(:,761),[58,5],[0,0],2,2,wf16(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,30),G0H4(40),ngZd,m3h16x4(:,183),heltab2x64(:,:,737))
  call Hloop_Q_A(ntryL,G0H4(40),58,0,G1H4(62),n2h4(257))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(762),h0tab(:,762),[58,5],[nMB,nMB],2,2,wf16(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,30),G0H4(40),ngZd,m3h16x4(:,184),heltab2x64(:,:,738))
  call Hloop_Q_A(ntryL,G0H4(40),58,nMB,G1H4(66),n2h4(258))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(763),h0tab(:,763),[58,5],[nMW,nMW],2,2,wf16(:,29),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,29),58,G1H4(67),m3h16x4(:,185),heltab2x64(:,:,739))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(764),h0tab(:,764),[58,5],[nMH,nMZ],2,2,wf16(:,30),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,30),58,G1H4(1),m3h16x4(:,186),heltab2x64(:,:,740))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(765),h0tab(:,765),[58,5],[nMW,nMW],2,2,wf16(:,30),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,30),58,G1H4(26),m3h16x4(:,187),heltab2x64(:,:,741))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(766),h0tab(:,766),[58,5],[nMW,nMW],2,2,wf16(:,29),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,29),58,G1H4(75),m3h16x4(:,188),heltab2x64(:,:,742))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(767),h0tab(:,767),[58,5],[nMW,nMW],2,2,wf16(:,29),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,29),58,G1H4(77),m3h16x4(:,189),heltab2x64(:,:,743))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(768),h0tab(:,768),[58,5],[nMW,nMW],2,2,wf16(:,30),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,30),58,G1H4(81),m3h16x4(:,190),heltab2x64(:,:,744))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(769),h0tab(:,769),[58,5],[nMW,nMW],2,2,wf16(:,30),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,30),58,G1H4(82),m3h16x4(:,191),heltab2x64(:,:,745))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(770),h0tab(:,770),[58,5],[nMW,nMW],2,2,wf16(:,29),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,29),58,G1H4(86),m3h16x4(:,192),heltab2x64(:,:,746))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(771),h0tab(:,771),[58,5],[nMW,nMW],2,2,wf16(:,30),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,30),58,G1H4(87),m3h16x4(:,193),heltab2x64(:,:,747))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(772),h0tab(:,772),[58,5],[nMW,nMW],2,2,wf16(:,29),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,29),G0H4(40),m3h16x4(:,194),heltab2x64(:,:,748))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(773),h0tab(:,773),[58,5],[nMW,nMW],2,2,wf16(:,29),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,29),G0H4(41),m3h16x4(:,195),heltab2x64(:,:,749))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(774),h0tab(:,774),[58,5],[nMH,nMZ],2,2,wf16(:,30),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,30),G0H4(42),m3h16x4(:,196),heltab2x64(:,:,750))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(775),h0tab(:,775),[58,5],[nMW,nMW],2,2,wf16(:,30),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,30),G0H4(43),m3h16x4(:,197),heltab2x64(:,:,751))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(776),h0tab(:,776),[58,5],[nMW,nMW],2,2,wf16(:,30),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,30),G0H4(44),m3h16x4(:,198),heltab2x64(:,:,752))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(777),h0tab(:,777),[48,15],[0,0],2,2,wf4(:,7),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(11),m3h4x16(:,303),heltab2x64(:,:,753))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(29),n2h16(201))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(778),h0tab(:,778),[48,15],[nML,nML],2,2,wf4(:,7),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(24),m3h4x16(:,304),heltab2x64(:,:,754))
  call Hloop_Q_A(ntryL,G0H16(24),48,nML,G1H16(27),n2h16(202))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(779),h0tab(:,779),[48,15],[0,0],2,2,wf4(:,7),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(23),m3h4x16(:,305),heltab2x64(:,:,755))
  call Hloop_Q_A(ntryL,G0H16(23),48,0,G1H16(25),n2h16(203))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(780),h0tab(:,780),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(8),m3h4x16(:,306),heltab2x64(:,:,756))
  call Hloop_Q_A(ntryL,G0H16(8),48,nMT,G1H16(39),n2h16(204))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(781),h0tab(:,781),[48,15],[0,0],2,2,wf4(:,7),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(26),m3h4x16(:,307),heltab2x64(:,:,757))
  call Hloop_Q_A(ntryL,G0H16(26),48,0,G1H16(37),n2h16(205))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(782),h0tab(:,782),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(29),m3h4x16(:,308),heltab2x64(:,:,758))
  call Hloop_Q_A(ntryL,G0H16(29),48,nMB,G1H16(34),n2h16(206))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(783),h0tab(:,783),[48,15],[0,0],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(30),ngZn,m3h4x16(:,309),heltab2x64(:,:,759))
  call Hloop_Q_A(ntryL,G0H16(30),48,0,G1H16(43),n2h16(207))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(784),h0tab(:,784),[48,15],[0,0],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(2),ngZl,m3h4x16(:,310),heltab2x64(:,:,760))
  call Hloop_Q_A(ntryL,G0H16(2),48,0,G1H16(51),n2h16(208))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(785),h0tab(:,785),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(6),ngZl,m3h4x16(:,311),heltab2x64(:,:,761))
  call Hloop_Q_A(ntryL,G0H16(6),48,nML,G1H16(55),n2h16(209))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(786),h0tab(:,786),[48,15],[0,0],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(18),ngZu,m3h4x16(:,312),heltab2x64(:,:,762))
  call Hloop_Q_A(ntryL,G0H16(18),48,0,G1H16(59),n2h16(210))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(787),h0tab(:,787),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZu,m3h4x16(:,313),heltab2x64(:,:,763))
  call Hloop_Q_A(ntryL,G0H16(17),48,nMT,G1H16(61),n2h16(211))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(788),h0tab(:,788),[48,15],[0,0],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZd,m3h4x16(:,314),heltab2x64(:,:,764))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(62),n2h16(212))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(789),h0tab(:,789),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(4),ngZd,m3h4x16(:,315),heltab2x64(:,:,765))
  call Hloop_Q_A(ntryL,G0H16(4),48,nMB,G1H16(63),n2h16(213))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(790),h0tab(:,790),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(64),m3h4x16(:,316),heltab2x64(:,:,766))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(791),h0tab(:,791),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,3))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(65),m3h4x16(:,317),heltab2x64(:,:,767))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(792),h0tab(:,792),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(66),m3h4x16(:,318),heltab2x64(:,:,768))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(793),h0tab(:,793),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(67),m3h4x16(:,319),heltab2x64(:,:,769))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(794),h0tab(:,794),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(68),m3h4x16(:,320),heltab2x64(:,:,770))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(795),h0tab(:,795),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(69),m3h4x16(:,321),heltab2x64(:,:,771))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(796),h0tab(:,796),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(70),m3h4x16(:,322),heltab2x64(:,:,772))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(797),h0tab(:,797),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(71),m3h4x16(:,323),heltab2x64(:,:,773))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(798),h0tab(:,798),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(72),m3h4x16(:,324),heltab2x64(:,:,774))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(799),h0tab(:,799),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(21),m3h4x16(:,325),heltab2x64(:,:,775))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(800),h0tab(:,800),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(20),m3h4x16(:,326),heltab2x64(:,:,776))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(801),h0tab(:,801),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(16),m3h4x16(:,327),heltab2x64(:,:,777))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(802),h0tab(:,802),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(19),m3h4x16(:,328),heltab2x64(:,:,778))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(803),h0tab(:,803),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(13),m3h4x16(:,329),heltab2x64(:,:,779))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(804),h0tab(:,804),[56,7],[0,nMZ],2,2,wf8(:,61),wf8(:,9))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,61),G0H8(26),ngZn,m3h8x8(:,83),heltab2x64(:,:,780))
  call Hloop_A_Q(ntryL,G0H8(26),56,0,G1H8(37),n2h8(117))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(805),h0tab(:,805),[56,7],[0,nMW],2,2,wf8(:,61),wf8(:,9))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,61),G0H8(1),m3h8x8(:,84),heltab2x64(:,:,781))
  call Hloop_A_Q(ntryL,G0H8(1),56,0,G1H8(38),n2h8(118))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(806),h0tab(:,806),[48,15],[0,0],2,2,wf4(:,7),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(9),m3h4x16(:,330),heltab2x64(:,:,782))
  call Hloop_Q_A(ntryL,G0H16(9),48,0,G1H16(87),n2h16(214))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(807),h0tab(:,807),[48,15],[nML,nML],2,2,wf4(:,7),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(27),m3h4x16(:,331),heltab2x64(:,:,783))
  call Hloop_Q_A(ntryL,G0H16(27),48,nML,G1H16(88),n2h16(215))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(808),h0tab(:,808),[48,15],[0,0],2,2,wf4(:,7),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(28),m3h4x16(:,332),heltab2x64(:,:,784))
  call Hloop_Q_A(ntryL,G0H16(28),48,0,G1H16(95),n2h16(216))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(809),h0tab(:,809),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(31),m3h4x16(:,333),heltab2x64(:,:,785))
  call Hloop_Q_A(ntryL,G0H16(31),48,nMT,G1H16(93),n2h16(217))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(810),h0tab(:,810),[48,15],[0,0],2,2,wf4(:,7),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(32),m3h4x16(:,334),heltab2x64(:,:,786))
  call Hloop_Q_A(ntryL,G0H16(32),48,0,G1H16(91),n2h16(218))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(811),h0tab(:,811),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(33),m3h4x16(:,335),heltab2x64(:,:,787))
  call Hloop_Q_A(ntryL,G0H16(33),48,nMB,G1H16(96),n2h16(219))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(812),h0tab(:,812),[48,15],[0,0],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(22),ngZn,m3h4x16(:,336),heltab2x64(:,:,788))
  call Hloop_Q_A(ntryL,G0H16(22),48,0,G1H16(94),n2h16(220))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(813),h0tab(:,813),[48,15],[0,0],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(3),ngZl,m3h4x16(:,337),heltab2x64(:,:,789))
  call Hloop_Q_A(ntryL,G0H16(3),48,0,G1H16(92),n2h16(221))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(814),h0tab(:,814),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(15),ngZl,m3h4x16(:,338),heltab2x64(:,:,790))
  call Hloop_Q_A(ntryL,G0H16(15),48,nML,G1H16(99),n2h16(222))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(815),h0tab(:,815),[48,15],[0,0],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(14),ngZu,m3h4x16(:,339),heltab2x64(:,:,791))
  call Hloop_Q_A(ntryL,G0H16(14),48,0,G1H16(100),n2h16(223))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(816),h0tab(:,816),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(5),ngZu,m3h4x16(:,340),heltab2x64(:,:,792))
  call Hloop_Q_A(ntryL,G0H16(5),48,nMT,G1H16(105),n2h16(224))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(817),h0tab(:,817),[48,15],[0,0],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(11),ngZd,m3h4x16(:,341),heltab2x64(:,:,793))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(104),n2h16(225))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(818),h0tab(:,818),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(24),ngZd,m3h4x16(:,342),heltab2x64(:,:,794))
  call Hloop_Q_A(ntryL,G0H16(24),48,nMB,G1H16(103),n2h16(226))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(819),h0tab(:,819),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(109),m3h4x16(:,343),heltab2x64(:,:,795))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(820),h0tab(:,820),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,4))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(108),m3h4x16(:,344),heltab2x64(:,:,796))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(821),h0tab(:,821),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(107),m3h4x16(:,345),heltab2x64(:,:,797))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(822),h0tab(:,822),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(111),m3h4x16(:,346),heltab2x64(:,:,798))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(823),h0tab(:,823),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(114),m3h4x16(:,347),heltab2x64(:,:,799))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(824),h0tab(:,824),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(116),m3h4x16(:,348),heltab2x64(:,:,800))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(825),h0tab(:,825),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(119),m3h4x16(:,349),heltab2x64(:,:,801))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(826),h0tab(:,826),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(121),m3h4x16(:,350),heltab2x64(:,:,802))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(827),h0tab(:,827),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(124),m3h4x16(:,351),heltab2x64(:,:,803))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(828),h0tab(:,828),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(23),m3h4x16(:,352),heltab2x64(:,:,804))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(829),h0tab(:,829),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(8),m3h4x16(:,353),heltab2x64(:,:,805))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(830),h0tab(:,830),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(26),m3h4x16(:,354),heltab2x64(:,:,806))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(831),h0tab(:,831),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(29),m3h4x16(:,355),heltab2x64(:,:,807))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(832),h0tab(:,832),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(30),m3h4x16(:,356),heltab2x64(:,:,808))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(833),h0tab(:,833),[50,13],[nMZ,0],2,2,wf8(:,12),wf8(:,58))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,12),G0H8(7),ngZn,m3h8x8(:,85),heltab2x64(:,:,809))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(834),h0tab(:,834),[50,13],[nMW,0],2,2,wf8(:,12),wf8(:,58))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,12),G0H8(4),m3h8x8(:,86),heltab2x64(:,:,810))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(835),h0tab(:,835),[58,5],[0,0],2,2,wf16(:,37),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,37),G0H4(45),ngZn,m3h16x4(:,199),heltab2x64(:,:,811))
  call Hloop_Q_A(ntryL,G0H4(45),58,0,G1H4(15),n2h4(259))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(836),h0tab(:,836),[58,5],[0,0],2,2,wf16(:,37),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,37),G0H4(45),ngZl,m3h16x4(:,200),heltab2x64(:,:,812))
  call Hloop_Q_A(ntryL,G0H4(45),58,0,G1H4(16),n2h4(260))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(837),h0tab(:,837),[58,5],[nML,nML],2,2,wf16(:,37),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,37),G0H4(45),ngZl,m3h16x4(:,201),heltab2x64(:,:,813))
  call Hloop_Q_A(ntryL,G0H4(45),58,nML,G1H4(12),n2h4(261))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(838),h0tab(:,838),[58,5],[0,0],2,2,wf16(:,37),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,37),G0H4(45),ngZu,m3h16x4(:,202),heltab2x64(:,:,814))
  call Hloop_Q_A(ntryL,G0H4(45),58,0,G1H4(44),n2h4(262))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(839),h0tab(:,839),[58,5],[nMT,nMT],2,2,wf16(:,37),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,37),G0H4(45),ngZu,m3h16x4(:,203),heltab2x64(:,:,815))
  call Hloop_Q_A(ntryL,G0H4(45),58,nMT,G1H4(58),n2h4(263))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(840),h0tab(:,840),[58,5],[0,0],2,2,wf16(:,37),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,37),G0H4(45),ngZd,m3h16x4(:,204),heltab2x64(:,:,816))
  call Hloop_Q_A(ntryL,G0H4(45),58,0,G1H4(70),n2h4(264))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(841),h0tab(:,841),[58,5],[nMB,nMB],2,2,wf16(:,37),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,37),G0H4(45),ngZd,m3h16x4(:,205),heltab2x64(:,:,817))
  call Hloop_Q_A(ntryL,G0H4(45),58,nMB,G1H4(13),n2h4(265))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(842),h0tab(:,842),[58,5],[nMH,nMZ],2,2,wf16(:,37),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,37),58,G1H4(14),m3h16x4(:,206),heltab2x64(:,:,818))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(843),h0tab(:,843),[58,5],[nMW,nMW],2,2,wf16(:,37),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,37),58,G1H4(25),m3h16x4(:,207),heltab2x64(:,:,819))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(844),h0tab(:,844),[58,5],[nMW,nMW],2,2,wf16(:,37),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,37),58,G1H4(31),m3h16x4(:,208),heltab2x64(:,:,820))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(845),h0tab(:,845),[58,5],[nMW,nMW],2,2,wf16(:,37),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,37),58,G1H4(46),m3h16x4(:,209),heltab2x64(:,:,821))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(846),h0tab(:,846),[58,5],[nMW,nMW],2,2,wf16(:,37),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,37),58,G1H4(41),m3h16x4(:,210),heltab2x64(:,:,822))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(847),h0tab(:,847),[58,5],[nMH,nMZ],2,2,wf16(:,37),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,37),G0H4(45),m3h16x4(:,211),heltab2x64(:,:,823))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(848),h0tab(:,848),[58,5],[nMW,nMW],2,2,wf16(:,37),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,37),G0H4(46),m3h16x4(:,212),heltab2x64(:,:,824))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(849),h0tab(:,849),[58,5],[nMW,nMW],2,2,wf16(:,37),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,37),G0H4(47),m3h16x4(:,213),heltab2x64(:,:,825))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(850),h0tab(:,850),[58,5],[0,0],2,2,wf16(:,38),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,38),G0H4(48),ngZn,m3h16x4(:,214),heltab2x64(:,:,826))
  call Hloop_Q_A(ntryL,G0H4(48),58,0,G1H4(76),n2h4(266))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(851),h0tab(:,851),[58,5],[0,0],2,2,wf16(:,38),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,38),G0H4(48),ngZl,m3h16x4(:,215),heltab2x64(:,:,827))
  call Hloop_Q_A(ntryL,G0H4(48),58,0,G1H4(64),n2h4(267))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(852),h0tab(:,852),[58,5],[nML,nML],2,2,wf16(:,38),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,38),G0H4(48),ngZl,m3h16x4(:,216),heltab2x64(:,:,828))
  call Hloop_Q_A(ntryL,G0H4(48),58,nML,G1H4(6),n2h4(268))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(853),h0tab(:,853),[58,5],[0,0],2,2,wf16(:,38),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,38),G0H4(48),ngZu,m3h16x4(:,217),heltab2x64(:,:,829))
  call Hloop_Q_A(ntryL,G0H4(48),58,0,G1H4(32),n2h4(269))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(854),h0tab(:,854),[58,5],[nMT,nMT],2,2,wf16(:,38),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,38),G0H4(48),ngZu,m3h16x4(:,218),heltab2x64(:,:,830))
  call Hloop_Q_A(ntryL,G0H4(48),58,nMT,G1H4(120),n2h4(270))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(855),h0tab(:,855),[58,5],[0,0],2,2,wf16(:,38),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,38),G0H4(48),ngZd,m3h16x4(:,219),heltab2x64(:,:,831))
  call Hloop_Q_A(ntryL,G0H4(48),58,0,G1H4(51),n2h4(271))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(856),h0tab(:,856),[58,5],[nMB,nMB],2,2,wf16(:,38),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,38),G0H4(48),ngZd,m3h16x4(:,220),heltab2x64(:,:,832))
  call Hloop_Q_A(ntryL,G0H4(48),58,nMB,G1H4(18),n2h4(272))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(857),h0tab(:,857),[58,5],[nMH,nMZ],2,2,wf16(:,38),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,38),58,G1H4(117),m3h16x4(:,221),heltab2x64(:,:,833))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(858),h0tab(:,858),[58,5],[nMW,nMW],2,2,wf16(:,38),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,38),58,G1H4(47),m3h16x4(:,222),heltab2x64(:,:,834))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(859),h0tab(:,859),[58,5],[nMW,nMW],2,2,wf16(:,38),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,38),58,G1H4(10),m3h16x4(:,223),heltab2x64(:,:,835))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(860),h0tab(:,860),[58,5],[nMW,nMW],2,2,wf16(:,38),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,38),58,G1H4(23),m3h16x4(:,224),heltab2x64(:,:,836))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(861),h0tab(:,861),[58,5],[nMW,nMW],2,2,wf16(:,38),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,38),58,G1H4(121),m3h16x4(:,225),heltab2x64(:,:,837))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(862),h0tab(:,862),[58,5],[nMH,nMZ],2,2,wf16(:,38),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,38),G0H4(48),m3h16x4(:,226),heltab2x64(:,:,838))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(863),h0tab(:,863),[58,5],[nMW,nMW],2,2,wf16(:,38),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,38),G0H4(49),m3h16x4(:,227),heltab2x64(:,:,839))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(864),h0tab(:,864),[58,5],[nMW,nMW],2,2,wf16(:,38),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,38),G0H4(50),m3h16x4(:,228),heltab2x64(:,:,840))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(865),h0tab(:,865),[48,15],[nML,nML],2,2,wf4(:,7),wf16(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(2),m3h4x16(:,357),heltab2x64(:,:,841))
  call Hloop_Q_A(ntryL,G0H16(2),48,nML,G1H16(126),n2h16(227))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(866),h0tab(:,866),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(6),m3h4x16(:,358),heltab2x64(:,:,842))
  call Hloop_Q_A(ntryL,G0H16(6),48,nMT,G1H16(129),n2h16(228))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(867),h0tab(:,867),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(18),m3h4x16(:,359),heltab2x64(:,:,843))
  call Hloop_Q_A(ntryL,G0H16(18),48,nMB,G1H16(131),n2h16(229))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(868),h0tab(:,868),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,9))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZl,m3h4x16(:,360),heltab2x64(:,:,844))
  call Hloop_Q_A(ntryL,G0H16(17),48,nML,G1H16(134),n2h16(230))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(869),h0tab(:,869),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,9))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),ngZu,m3h4x16(:,361),heltab2x64(:,:,845))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(136),n2h16(231))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(870),h0tab(:,870),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,9))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(4),ngZd,m3h4x16(:,362),heltab2x64(:,:,846))
  call Hloop_Q_A(ntryL,G0H16(4),48,nMB,G1H16(139),n2h16(232))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(871),h0tab(:,871),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,9))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(26),m3h4x16(:,363),heltab2x64(:,:,847))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(872),h0tab(:,872),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,9))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(28),m3h4x16(:,364),heltab2x64(:,:,848))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(873),h0tab(:,873),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,9))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(31),m3h4x16(:,365),heltab2x64(:,:,849))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(874),h0tab(:,874),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,9))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(30),m3h4x16(:,366),heltab2x64(:,:,850))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(875),h0tab(:,875),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,9))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(33),m3h4x16(:,367),heltab2x64(:,:,851))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(876),h0tab(:,876),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,9))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(36),m3h4x16(:,368),heltab2x64(:,:,852))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(877),h0tab(:,877),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(35),m3h4x16(:,369),heltab2x64(:,:,853))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(878),h0tab(:,878),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(38),m3h4x16(:,370),heltab2x64(:,:,854))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(879),h0tab(:,879),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,9))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(9),m3h4x16(:,371),heltab2x64(:,:,855))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(880),h0tab(:,880),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,9))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(27),m3h4x16(:,372),heltab2x64(:,:,856))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(881),h0tab(:,881),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,9))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(28),m3h4x16(:,373),heltab2x64(:,:,857))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(882),h0tab(:,882),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,9))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(31),m3h4x16(:,374),heltab2x64(:,:,858))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(883),h0tab(:,883),[57,6],[nML,nML],2,2,wf16(:,17),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,17),G0H4(51),ngH,m3h16x4(:,229),heltab2x64(:,:,859))
  call Hloop_Q_A(ntryL,G0H4(51),57,nML,G1H4(30),n2h4(273))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(884),h0tab(:,884),[57,6],[nMT,nMT],2,2,wf16(:,17),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,17),G0H4(51),ngH,m3h16x4(:,230),heltab2x64(:,:,860))
  call Hloop_Q_A(ntryL,G0H4(51),57,nMT,G1H4(63),n2h4(274))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(885),h0tab(:,885),[57,6],[nMB,nMB],2,2,wf16(:,17),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,17),G0H4(51),ngH,m3h16x4(:,231),heltab2x64(:,:,861))
  call Hloop_Q_A(ntryL,G0H4(51),57,nMB,G1H4(102),n2h4(275))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(886),h0tab(:,886),[57,6],[nMW,nMW],2,2,wf16(:,17),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,17),G0H4(51),m3h16x4(:,232),heltab2x64(:,:,862))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(887),h0tab(:,887),[57,6],[nMW,nMW],2,2,wf16(:,17),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,17),G0H4(52),m3h16x4(:,233),heltab2x64(:,:,863))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(888),h0tab(:,888),[57,6],[nMW,nMW],2,2,wf16(:,17),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,17),G0H4(53),m3h16x4(:,234),heltab2x64(:,:,864))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(889),h0tab(:,889),[57,6],[nMW,nMW],2,2,wf16(:,17),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,17),G0H4(54),m3h16x4(:,235),heltab2x64(:,:,865))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(890),h0tab(:,890),[57,6],[nMW,nMW],2,2,wf16(:,17),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,17),57,G1H4(24),m3h16x4(:,236),heltab2x64(:,:,866))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(891),h0tab(:,891),[57,6],[nMW,nMW],2,2,wf16(:,17),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,17),57,G1H4(7),m3h16x4(:,237),heltab2x64(:,:,867))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(892),h0tab(:,892),[54,9],[nML,nML],2,2,wf16(:,10),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,10),G0H4(55),ngH,m3h16x4(:,238),heltab2x64(:,:,868))
  call Hloop_Q_A(ntryL,G0H4(55),54,nML,G1H4(19),n2h4(276))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(893),h0tab(:,893),[54,9],[nMT,nMT],2,2,wf16(:,10),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,10),G0H4(55),ngH,m3h16x4(:,239),heltab2x64(:,:,869))
  call Hloop_Q_A(ntryL,G0H4(55),54,nMT,G1H4(129),n2h4(277))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(894),h0tab(:,894),[54,9],[nMB,nMB],2,2,wf16(:,10),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H64(1),wf16(:,10),G0H4(55),ngH,m3h16x4(:,240),heltab2x64(:,:,870))
  call Hloop_Q_A(ntryL,G0H4(55),54,nMB,G1H4(130),n2h4(278))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(895),h0tab(:,895),[54,9],[nMW,nMW],2,2,wf16(:,10),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,10),G0H4(55),m3h16x4(:,241),heltab2x64(:,:,871))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(896),h0tab(:,896),[54,9],[nMW,nMW],2,2,wf16(:,10),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,10),G0H4(56),m3h16x4(:,242),heltab2x64(:,:,872))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(897),h0tab(:,897),[54,9],[nMW,nMW],2,2,wf16(:,10),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H64(1),wf16(:,10),G0H4(57),m3h16x4(:,243),heltab2x64(:,:,873))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(898),h0tab(:,898),[54,9],[nMW,nMW],2,2,wf16(:,10),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,10),G0H4(58),m3h16x4(:,244),heltab2x64(:,:,874))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(899),h0tab(:,899),[54,9],[nMW,nMW],2,2,wf16(:,10),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,10),54,G1H4(131),m3h16x4(:,245),heltab2x64(:,:,875))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(900),h0tab(:,900),[54,9],[nMW,nMW],2,2,wf16(:,10),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf16(:,10),54,G1H4(132),m3h16x4(:,246),heltab2x64(:,:,876))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(901),h0tab(:,901),[38,25],[0,0],2,2,wf8(:,48),wf8(:,15))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,48),G0H8(11),m3h8x8(:,87),heltab2x64(:,:,877))
  call Hloop_A_Q(ntryL,G0H8(11),38,0,G1H8(40),n2h8(119))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(902),h0tab(:,902),[38,25],[0,nMZ],2,2,wf8(:,48),wf8(:,15))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,48),G0H8(17),ngZu,m3h8x8(:,88),heltab2x64(:,:,878))
  call Hloop_A_Q(ntryL,G0H8(17),38,0,G1H8(41),n2h8(120))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(903),h0tab(:,903),[38,25],[0,nMW],2,2,wf8(:,48),wf8(:,15))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,48),G0H8(30),m3h8x8(:,89),heltab2x64(:,:,879))
  call Hloop_A_Q(ntryL,G0H8(30),38,0,G1H8(26),n2h8(121))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(904),h0tab(:,904),[57,6],[0,0],2,2,wf16(:,20),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,20),G0H4(59),m3h16x4(:,247),heltab2x64(:,:,880))
  call Hloop_Q_A(ntryL,G0H4(59),57,0,G1H4(133),n2h4(279))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(905),h0tab(:,905),[57,6],[nML,nML],2,2,wf16(:,20),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,20),G0H4(59),m3h16x4(:,248),heltab2x64(:,:,881))
  call Hloop_Q_A(ntryL,G0H4(59),57,nML,G1H4(134),n2h4(280))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(906),h0tab(:,906),[57,6],[0,0],2,2,wf16(:,20),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,20),G0H4(59),m3h16x4(:,249),heltab2x64(:,:,882))
  call Hloop_Q_A(ntryL,G0H4(59),57,0,G1H4(135),n2h4(281))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(907),h0tab(:,907),[57,6],[nMT,nMT],2,2,wf16(:,20),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,20),G0H4(59),m3h16x4(:,250),heltab2x64(:,:,883))
  call Hloop_Q_A(ntryL,G0H4(59),57,nMT,G1H4(136),n2h4(282))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(908),h0tab(:,908),[57,6],[0,0],2,2,wf16(:,20),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,20),G0H4(59),m3h16x4(:,251),heltab2x64(:,:,884))
  call Hloop_Q_A(ntryL,G0H4(59),57,0,G1H4(137),n2h4(283))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(909),h0tab(:,909),[57,6],[nMB,nMB],2,2,wf16(:,20),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,20),G0H4(59),m3h16x4(:,252),heltab2x64(:,:,885))
  call Hloop_Q_A(ntryL,G0H4(59),57,nMB,G1H4(138),n2h4(284))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(910),h0tab(:,910),[57,6],[0,0],2,2,wf16(:,21),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,21),G0H4(59),ngZn,m3h16x4(:,253),heltab2x64(:,:,886))
  call Hloop_Q_A(ntryL,G0H4(59),57,0,G1H4(139),n2h4(285))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(911),h0tab(:,911),[57,6],[0,0],2,2,wf16(:,21),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,21),G0H4(59),ngZl,m3h16x4(:,254),heltab2x64(:,:,887))
  call Hloop_Q_A(ntryL,G0H4(59),57,0,G1H4(140),n2h4(286))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(912),h0tab(:,912),[57,6],[nML,nML],2,2,wf16(:,21),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,21),G0H4(59),ngZl,m3h16x4(:,255),heltab2x64(:,:,888))
  call Hloop_Q_A(ntryL,G0H4(59),57,nML,G1H4(141),n2h4(287))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(913),h0tab(:,913),[57,6],[0,0],2,2,wf16(:,21),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,21),G0H4(59),ngZu,m3h16x4(:,256),heltab2x64(:,:,889))
  call Hloop_Q_A(ntryL,G0H4(59),57,0,G1H4(142),n2h4(288))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(914),h0tab(:,914),[57,6],[nMT,nMT],2,2,wf16(:,21),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,21),G0H4(59),ngZu,m3h16x4(:,257),heltab2x64(:,:,890))
  call Hloop_Q_A(ntryL,G0H4(59),57,nMT,G1H4(143),n2h4(289))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(915),h0tab(:,915),[57,6],[0,0],2,2,wf16(:,21),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,21),G0H4(59),ngZd,m3h16x4(:,258),heltab2x64(:,:,891))
  call Hloop_Q_A(ntryL,G0H4(59),57,0,G1H4(144),n2h4(290))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(916),h0tab(:,916),[57,6],[nMB,nMB],2,2,wf16(:,21),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,21),G0H4(59),ngZd,m3h16x4(:,259),heltab2x64(:,:,892))
  call Hloop_Q_A(ntryL,G0H4(59),57,nMB,G1H4(145),n2h4(291))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(917),h0tab(:,917),[57,6],[nMW,nMW],2,2,wf16(:,20),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,20),57,G1H4(146),m3h16x4(:,260),heltab2x64(:,:,893))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(918),h0tab(:,918),[57,6],[nMH,nMZ],2,2,wf16(:,21),wf4(:,5))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,21),57,G1H4(147),m3h16x4(:,261),heltab2x64(:,:,894))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(919),h0tab(:,919),[57,6],[nMW,nMW],2,2,wf16(:,21),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,21),57,G1H4(148),m3h16x4(:,262),heltab2x64(:,:,895))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(920),h0tab(:,920),[57,6],[nMW,nMW],2,2,wf16(:,20),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,20),57,G1H4(149),m3h16x4(:,263),heltab2x64(:,:,896))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(921),h0tab(:,921),[57,6],[nMW,nMW],2,2,wf16(:,20),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,20),57,G1H4(150),m3h16x4(:,264),heltab2x64(:,:,897))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(922),h0tab(:,922),[57,6],[nMW,nMW],2,2,wf16(:,21),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,21),57,G1H4(151),m3h16x4(:,265),heltab2x64(:,:,898))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(923),h0tab(:,923),[57,6],[nMW,nMW],2,2,wf16(:,21),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,21),57,G1H4(152),m3h16x4(:,266),heltab2x64(:,:,899))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(924),h0tab(:,924),[57,6],[nMW,nMW],2,2,wf16(:,20),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,20),57,G1H4(153),m3h16x4(:,267),heltab2x64(:,:,900))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(925),h0tab(:,925),[57,6],[nMW,nMW],2,2,wf16(:,21),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,21),57,G1H4(154),m3h16x4(:,268),heltab2x64(:,:,901))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(926),h0tab(:,926),[57,6],[nMW,nMW],2,2,wf16(:,20),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,20),G0H4(59),m3h16x4(:,269),heltab2x64(:,:,902))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(927),h0tab(:,927),[57,6],[nMW,nMW],2,2,wf16(:,20),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,20),G0H4(60),m3h16x4(:,270),heltab2x64(:,:,903))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(928),h0tab(:,928),[57,6],[nMH,nMZ],2,2,wf16(:,21),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,21),G0H4(61),m3h16x4(:,271),heltab2x64(:,:,904))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(929),h0tab(:,929),[57,6],[nMW,nMW],2,2,wf16(:,21),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,21),G0H4(62),m3h16x4(:,272),heltab2x64(:,:,905))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(930),h0tab(:,930),[57,6],[nMW,nMW],2,2,wf16(:,21),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,21),G0H4(63),m3h16x4(:,273),heltab2x64(:,:,906))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(931),h0tab(:,931),[41,22],[0,0],2,2,wf8(:,46),wf8(:,18))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(10),m3h8x8(:,90),heltab2x64(:,:,907))
  call Hloop_A_Q(ntryL,G0H8(10),41,0,G1H8(13),n2h8(122))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(932),h0tab(:,932),[41,22],[0,nMZ],2,2,wf8(:,46),wf8(:,18))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(13),ngZu,m3h8x8(:,91),heltab2x64(:,:,908))
  call Hloop_A_Q(ntryL,G0H8(13),41,0,G1H8(64),n2h8(123))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(933),h0tab(:,933),[41,22],[0,nMW],2,2,wf8(:,46),wf8(:,18))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(14),m3h8x8(:,92),heltab2x64(:,:,909))
  call Hloop_A_Q(ntryL,G0H8(14),41,0,G1H8(2),n2h8(124))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(934),h0tab(:,934),[57,6],[0,0],2,2,wf16(:,22),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,22),G0H4(64),m3h16x4(:,274),heltab2x64(:,:,910))
  call Hloop_Q_A(ntryL,G0H4(64),57,0,G1H4(155),n2h4(292))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(935),h0tab(:,935),[57,6],[nML,nML],2,2,wf16(:,22),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,22),G0H4(64),m3h16x4(:,275),heltab2x64(:,:,911))
  call Hloop_Q_A(ntryL,G0H4(64),57,nML,G1H4(156),n2h4(293))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(936),h0tab(:,936),[57,6],[0,0],2,2,wf16(:,22),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,22),G0H4(64),m3h16x4(:,276),heltab2x64(:,:,912))
  call Hloop_Q_A(ntryL,G0H4(64),57,0,G1H4(157),n2h4(294))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(937),h0tab(:,937),[57,6],[nMT,nMT],2,2,wf16(:,22),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,22),G0H4(64),m3h16x4(:,277),heltab2x64(:,:,913))
  call Hloop_Q_A(ntryL,G0H4(64),57,nMT,G1H4(158),n2h4(295))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(938),h0tab(:,938),[57,6],[0,0],2,2,wf16(:,22),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,22),G0H4(64),m3h16x4(:,278),heltab2x64(:,:,914))
  call Hloop_Q_A(ntryL,G0H4(64),57,0,G1H4(159),n2h4(296))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(939),h0tab(:,939),[57,6],[nMB,nMB],2,2,wf16(:,22),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,22),G0H4(64),m3h16x4(:,279),heltab2x64(:,:,915))
  call Hloop_Q_A(ntryL,G0H4(64),57,nMB,G1H4(160),n2h4(297))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(940),h0tab(:,940),[57,6],[0,0],2,2,wf16(:,23),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,23),G0H4(64),ngZn,m3h16x4(:,280),heltab2x64(:,:,916))
  call Hloop_Q_A(ntryL,G0H4(64),57,0,G1H4(161),n2h4(298))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(941),h0tab(:,941),[57,6],[0,0],2,2,wf16(:,23),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,23),G0H4(64),ngZl,m3h16x4(:,281),heltab2x64(:,:,917))
  call Hloop_Q_A(ntryL,G0H4(64),57,0,G1H4(162),n2h4(299))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(942),h0tab(:,942),[57,6],[nML,nML],2,2,wf16(:,23),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,23),G0H4(64),ngZl,m3h16x4(:,282),heltab2x64(:,:,918))
  call Hloop_Q_A(ntryL,G0H4(64),57,nML,G1H4(163),n2h4(300))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(943),h0tab(:,943),[57,6],[0,0],2,2,wf16(:,23),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,23),G0H4(64),ngZu,m3h16x4(:,283),heltab2x64(:,:,919))
  call Hloop_Q_A(ntryL,G0H4(64),57,0,G1H4(164),n2h4(301))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(944),h0tab(:,944),[57,6],[nMT,nMT],2,2,wf16(:,23),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,23),G0H4(64),ngZu,m3h16x4(:,284),heltab2x64(:,:,920))
  call Hloop_Q_A(ntryL,G0H4(64),57,nMT,G1H4(165),n2h4(302))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(945),h0tab(:,945),[57,6],[0,0],2,2,wf16(:,23),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,23),G0H4(64),ngZd,m3h16x4(:,285),heltab2x64(:,:,921))
  call Hloop_Q_A(ntryL,G0H4(64),57,0,G1H4(166),n2h4(303))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(946),h0tab(:,946),[57,6],[nMB,nMB],2,2,wf16(:,23),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,23),G0H4(64),ngZd,m3h16x4(:,286),heltab2x64(:,:,922))
  call Hloop_Q_A(ntryL,G0H4(64),57,nMB,G1H4(167),n2h4(304))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(947),h0tab(:,947),[57,6],[nMW,nMW],2,2,wf16(:,22),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,22),57,G1H4(168),m3h16x4(:,287),heltab2x64(:,:,923))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(948),h0tab(:,948),[57,6],[nMH,nMZ],2,2,wf16(:,23),wf4(:,5))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,23),57,G1H4(169),m3h16x4(:,288),heltab2x64(:,:,924))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(949),h0tab(:,949),[57,6],[nMW,nMW],2,2,wf16(:,23),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,23),57,G1H4(170),m3h16x4(:,289),heltab2x64(:,:,925))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(950),h0tab(:,950),[57,6],[nMW,nMW],2,2,wf16(:,22),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,22),57,G1H4(171),m3h16x4(:,290),heltab2x64(:,:,926))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(951),h0tab(:,951),[57,6],[nMW,nMW],2,2,wf16(:,22),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,22),57,G1H4(172),m3h16x4(:,291),heltab2x64(:,:,927))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(952),h0tab(:,952),[57,6],[nMW,nMW],2,2,wf16(:,23),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,23),57,G1H4(173),m3h16x4(:,292),heltab2x64(:,:,928))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(953),h0tab(:,953),[57,6],[nMW,nMW],2,2,wf16(:,23),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,23),57,G1H4(174),m3h16x4(:,293),heltab2x64(:,:,929))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(954),h0tab(:,954),[57,6],[nMW,nMW],2,2,wf16(:,22),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,22),57,G1H4(175),m3h16x4(:,294),heltab2x64(:,:,930))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(955),h0tab(:,955),[57,6],[nMW,nMW],2,2,wf16(:,23),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,23),57,G1H4(176),m3h16x4(:,295),heltab2x64(:,:,931))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(956),h0tab(:,956),[57,6],[nMW,nMW],2,2,wf16(:,22),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,22),G0H4(64),m3h16x4(:,296),heltab2x64(:,:,932))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(957),h0tab(:,957),[57,6],[nMW,nMW],2,2,wf16(:,22),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,22),G0H4(65),m3h16x4(:,297),heltab2x64(:,:,933))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(958),h0tab(:,958),[57,6],[nMH,nMZ],2,2,wf16(:,23),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,23),G0H4(66),m3h16x4(:,298),heltab2x64(:,:,934))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(959),h0tab(:,959),[57,6],[nMW,nMW],2,2,wf16(:,23),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,23),G0H4(67),m3h16x4(:,299),heltab2x64(:,:,935))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(960),h0tab(:,960),[57,6],[nMW,nMW],2,2,wf16(:,23),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,23),G0H4(68),m3h16x4(:,300),heltab2x64(:,:,936))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(961),h0tab(:,961),[54,9],[0,0],2,2,wf16(:,13),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,13),G0H4(69),m3h16x4(:,301),heltab2x64(:,:,937))
  call Hloop_Q_A(ntryL,G0H4(69),54,0,G1H4(177),n2h4(305))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(962),h0tab(:,962),[54,9],[nML,nML],2,2,wf16(:,13),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,13),G0H4(69),m3h16x4(:,302),heltab2x64(:,:,938))
  call Hloop_Q_A(ntryL,G0H4(69),54,nML,G1H4(178),n2h4(306))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(963),h0tab(:,963),[54,9],[0,0],2,2,wf16(:,13),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,13),G0H4(69),m3h16x4(:,303),heltab2x64(:,:,939))
  call Hloop_Q_A(ntryL,G0H4(69),54,0,G1H4(179),n2h4(307))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(964),h0tab(:,964),[54,9],[nMT,nMT],2,2,wf16(:,13),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,13),G0H4(69),m3h16x4(:,304),heltab2x64(:,:,940))
  call Hloop_Q_A(ntryL,G0H4(69),54,nMT,G1H4(180),n2h4(308))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(965),h0tab(:,965),[54,9],[0,0],2,2,wf16(:,13),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,13),G0H4(69),m3h16x4(:,305),heltab2x64(:,:,941))
  call Hloop_Q_A(ntryL,G0H4(69),54,0,G1H4(181),n2h4(309))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(966),h0tab(:,966),[54,9],[nMB,nMB],2,2,wf16(:,13),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,13),G0H4(69),m3h16x4(:,306),heltab2x64(:,:,942))
  call Hloop_Q_A(ntryL,G0H4(69),54,nMB,G1H4(182),n2h4(310))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(967),h0tab(:,967),[54,9],[0,0],2,2,wf16(:,14),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,14),G0H4(69),ngZn,m3h16x4(:,307),heltab2x64(:,:,943))
  call Hloop_Q_A(ntryL,G0H4(69),54,0,G1H4(183),n2h4(311))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(968),h0tab(:,968),[54,9],[0,0],2,2,wf16(:,14),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,14),G0H4(69),ngZl,m3h16x4(:,308),heltab2x64(:,:,944))
  call Hloop_Q_A(ntryL,G0H4(69),54,0,G1H4(184),n2h4(312))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(969),h0tab(:,969),[54,9],[nML,nML],2,2,wf16(:,14),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,14),G0H4(69),ngZl,m3h16x4(:,309),heltab2x64(:,:,945))
  call Hloop_Q_A(ntryL,G0H4(69),54,nML,G1H4(185),n2h4(313))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(970),h0tab(:,970),[54,9],[0,0],2,2,wf16(:,14),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,14),G0H4(69),ngZu,m3h16x4(:,310),heltab2x64(:,:,946))
  call Hloop_Q_A(ntryL,G0H4(69),54,0,G1H4(186),n2h4(314))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(971),h0tab(:,971),[54,9],[nMT,nMT],2,2,wf16(:,14),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,14),G0H4(69),ngZu,m3h16x4(:,311),heltab2x64(:,:,947))
  call Hloop_Q_A(ntryL,G0H4(69),54,nMT,G1H4(187),n2h4(315))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(972),h0tab(:,972),[54,9],[0,0],2,2,wf16(:,14),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,14),G0H4(69),ngZd,m3h16x4(:,312),heltab2x64(:,:,948))
  call Hloop_Q_A(ntryL,G0H4(69),54,0,G1H4(188),n2h4(316))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(973),h0tab(:,973),[54,9],[nMB,nMB],2,2,wf16(:,14),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,14),G0H4(69),ngZd,m3h16x4(:,313),heltab2x64(:,:,949))
  call Hloop_Q_A(ntryL,G0H4(69),54,nMB,G1H4(189),n2h4(317))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(974),h0tab(:,974),[54,9],[nMW,nMW],2,2,wf16(:,13),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,13),54,G1H4(190),m3h16x4(:,314),heltab2x64(:,:,950))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(975),h0tab(:,975),[54,9],[nMH,nMZ],2,2,wf16(:,14),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,14),54,G1H4(191),m3h16x4(:,315),heltab2x64(:,:,951))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(976),h0tab(:,976),[54,9],[nMW,nMW],2,2,wf16(:,14),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,14),54,G1H4(192),m3h16x4(:,316),heltab2x64(:,:,952))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(977),h0tab(:,977),[54,9],[nMW,nMW],2,2,wf16(:,13),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,13),54,G1H4(193),m3h16x4(:,317),heltab2x64(:,:,953))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(978),h0tab(:,978),[54,9],[nMW,nMW],2,2,wf16(:,13),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,13),54,G1H4(194),m3h16x4(:,318),heltab2x64(:,:,954))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(979),h0tab(:,979),[54,9],[nMW,nMW],2,2,wf16(:,14),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,14),54,G1H4(195),m3h16x4(:,319),heltab2x64(:,:,955))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(980),h0tab(:,980),[54,9],[nMW,nMW],2,2,wf16(:,14),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,14),54,G1H4(196),m3h16x4(:,320),heltab2x64(:,:,956))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(981),h0tab(:,981),[54,9],[nMW,nMW],2,2,wf16(:,13),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,13),54,G1H4(197),m3h16x4(:,321),heltab2x64(:,:,957))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(982),h0tab(:,982),[54,9],[nMW,nMW],2,2,wf16(:,14),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,14),54,G1H4(198),m3h16x4(:,322),heltab2x64(:,:,958))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(983),h0tab(:,983),[54,9],[nMW,nMW],2,2,wf16(:,13),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,13),G0H4(69),m3h16x4(:,323),heltab2x64(:,:,959))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(984),h0tab(:,984),[54,9],[nMW,nMW],2,2,wf16(:,13),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,13),G0H4(70),m3h16x4(:,324),heltab2x64(:,:,960))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(985),h0tab(:,985),[54,9],[nMH,nMZ],2,2,wf16(:,14),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,14),G0H4(71),m3h16x4(:,325),heltab2x64(:,:,961))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(986),h0tab(:,986),[54,9],[nMW,nMW],2,2,wf16(:,14),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,14),G0H4(72),m3h16x4(:,326),heltab2x64(:,:,962))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(987),h0tab(:,987),[54,9],[nMW,nMW],2,2,wf16(:,14),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,14),G0H4(73),m3h16x4(:,327),heltab2x64(:,:,963))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(988),h0tab(:,988),[54,9],[0,0],2,2,wf16(:,15),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,15),G0H4(74),m3h16x4(:,328),heltab2x64(:,:,964))
  call Hloop_Q_A(ntryL,G0H4(74),54,0,G1H4(199),n2h4(318))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(989),h0tab(:,989),[54,9],[nML,nML],2,2,wf16(:,15),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,15),G0H4(74),m3h16x4(:,329),heltab2x64(:,:,965))
  call Hloop_Q_A(ntryL,G0H4(74),54,nML,G1H4(200),n2h4(319))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(990),h0tab(:,990),[54,9],[0,0],2,2,wf16(:,15),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,15),G0H4(74),m3h16x4(:,330),heltab2x64(:,:,966))
  call Hloop_Q_A(ntryL,G0H4(74),54,0,G1H4(201),n2h4(320))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(991),h0tab(:,991),[54,9],[nMT,nMT],2,2,wf16(:,15),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,15),G0H4(74),m3h16x4(:,331),heltab2x64(:,:,967))
  call Hloop_Q_A(ntryL,G0H4(74),54,nMT,G1H4(202),n2h4(321))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(992),h0tab(:,992),[54,9],[0,0],2,2,wf16(:,15),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,15),G0H4(74),m3h16x4(:,332),heltab2x64(:,:,968))
  call Hloop_Q_A(ntryL,G0H4(74),54,0,G1H4(203),n2h4(322))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(993),h0tab(:,993),[54,9],[nMB,nMB],2,2,wf16(:,15),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,15),G0H4(74),m3h16x4(:,333),heltab2x64(:,:,969))
  call Hloop_Q_A(ntryL,G0H4(74),54,nMB,G1H4(204),n2h4(323))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(994),h0tab(:,994),[54,9],[0,0],2,2,wf16(:,16),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(74),ngZn,m3h16x4(:,334),heltab2x64(:,:,970))
  call Hloop_Q_A(ntryL,G0H4(74),54,0,G1H4(205),n2h4(324))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(995),h0tab(:,995),[54,9],[0,0],2,2,wf16(:,16),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(74),ngZl,m3h16x4(:,335),heltab2x64(:,:,971))
  call Hloop_Q_A(ntryL,G0H4(74),54,0,G1H4(206),n2h4(325))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(996),h0tab(:,996),[54,9],[nML,nML],2,2,wf16(:,16),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(74),ngZl,m3h16x4(:,336),heltab2x64(:,:,972))
  call Hloop_Q_A(ntryL,G0H4(74),54,nML,G1H4(207),n2h4(326))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(997),h0tab(:,997),[54,9],[0,0],2,2,wf16(:,16),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(74),ngZu,m3h16x4(:,337),heltab2x64(:,:,973))
  call Hloop_Q_A(ntryL,G0H4(74),54,0,G1H4(208),n2h4(327))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(998),h0tab(:,998),[54,9],[nMT,nMT],2,2,wf16(:,16),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(74),ngZu,m3h16x4(:,338),heltab2x64(:,:,974))
  call Hloop_Q_A(ntryL,G0H4(74),54,nMT,G1H4(209),n2h4(328))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(999),h0tab(:,999),[54,9],[0,0],2,2,wf16(:,16),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(74),ngZd,m3h16x4(:,339),heltab2x64(:,:,975))
  call Hloop_Q_A(ntryL,G0H4(74),54,0,G1H4(210),n2h4(329))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1000),h0tab(:,1000),[54,9],[nMB,nMB],2,2,wf16(:,16),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,16),G0H4(74),ngZd,m3h16x4(:,340),heltab2x64(:,:,976))
  call Hloop_Q_A(ntryL,G0H4(74),54,nMB,G1H4(211),n2h4(330))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1001),h0tab(:,1001),[54,9],[nMW,nMW],2,2,wf16(:,15),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,15),54,G1H4(212),m3h16x4(:,341),heltab2x64(:,:,977))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1002),h0tab(:,1002),[54,9],[nMH,nMZ],2,2,wf16(:,16),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,16),54,G1H4(213),m3h16x4(:,342),heltab2x64(:,:,978))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1003),h0tab(:,1003),[54,9],[nMW,nMW],2,2,wf16(:,16),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,16),54,G1H4(214),m3h16x4(:,343),heltab2x64(:,:,979))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1004),h0tab(:,1004),[54,9],[nMW,nMW],2,2,wf16(:,15),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,15),54,G1H4(215),m3h16x4(:,344),heltab2x64(:,:,980))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1005),h0tab(:,1005),[54,9],[nMW,nMW],2,2,wf16(:,15),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,15),54,G1H4(216),m3h16x4(:,345),heltab2x64(:,:,981))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1006),h0tab(:,1006),[54,9],[nMW,nMW],2,2,wf16(:,16),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,16),54,G1H4(217),m3h16x4(:,346),heltab2x64(:,:,982))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1007),h0tab(:,1007),[54,9],[nMW,nMW],2,2,wf16(:,16),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,16),54,G1H4(218),m3h16x4(:,347),heltab2x64(:,:,983))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1008),h0tab(:,1008),[54,9],[nMW,nMW],2,2,wf16(:,15),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,15),54,G1H4(219),m3h16x4(:,348),heltab2x64(:,:,984))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1009),h0tab(:,1009),[54,9],[nMW,nMW],2,2,wf16(:,16),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,16),54,G1H4(220),m3h16x4(:,349),heltab2x64(:,:,985))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1010),h0tab(:,1010),[54,9],[nMW,nMW],2,2,wf16(:,15),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,15),G0H4(74),m3h16x4(:,350),heltab2x64(:,:,986))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1011),h0tab(:,1011),[54,9],[nMW,nMW],2,2,wf16(:,15),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,15),G0H4(75),m3h16x4(:,351),heltab2x64(:,:,987))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1012),h0tab(:,1012),[54,9],[nMH,nMZ],2,2,wf16(:,16),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,16),G0H4(76),m3h16x4(:,352),heltab2x64(:,:,988))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1013),h0tab(:,1013),[54,9],[nMW,nMW],2,2,wf16(:,16),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,16),G0H4(77),m3h16x4(:,353),heltab2x64(:,:,989))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1014),h0tab(:,1014),[54,9],[nMW,nMW],2,2,wf16(:,16),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,16),G0H4(78),m3h16x4(:,354),heltab2x64(:,:,990))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1015),h0tab(:,1015),[48,15],[0,0],2,2,wf4(:,7),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(32),m3h4x16(:,375),heltab2x64(:,:,991))
  call Hloop_Q_A(ntryL,G0H16(32),48,0,G1H16(40),n2h16(233))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1016),h0tab(:,1016),[48,15],[nML,nML],2,2,wf4(:,7),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(33),m3h4x16(:,376),heltab2x64(:,:,992))
  call Hloop_Q_A(ntryL,G0H16(33),48,nML,G1H16(42),n2h16(234))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1017),h0tab(:,1017),[48,15],[0,0],2,2,wf4(:,7),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(22),m3h4x16(:,377),heltab2x64(:,:,993))
  call Hloop_Q_A(ntryL,G0H16(22),48,0,G1H16(45),n2h16(235))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1018),h0tab(:,1018),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(3),m3h4x16(:,378),heltab2x64(:,:,994))
  call Hloop_Q_A(ntryL,G0H16(3),48,nMT,G1H16(44),n2h16(236))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1019),h0tab(:,1019),[48,15],[0,0],2,2,wf4(:,7),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(15),m3h4x16(:,379),heltab2x64(:,:,995))
  call Hloop_Q_A(ntryL,G0H16(15),48,0,G1H16(15),n2h16(237))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1020),h0tab(:,1020),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(14),m3h4x16(:,380),heltab2x64(:,:,996))
  call Hloop_Q_A(ntryL,G0H16(14),48,nMB,G1H16(23),n2h16(238))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1021),h0tab(:,1021),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(5),ngZn,m3h4x16(:,381),heltab2x64(:,:,997))
  call Hloop_Q_A(ntryL,G0H16(5),48,0,G1H16(49),n2h16(239))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1022),h0tab(:,1022),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(11),ngZl,m3h4x16(:,382),heltab2x64(:,:,998))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(52),n2h16(240))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1023),h0tab(:,1023),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(24),ngZl,m3h4x16(:,383),heltab2x64(:,:,999))
  call Hloop_Q_A(ntryL,G0H16(24),48,nML,G1H16(17),n2h16(241))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1024),h0tab(:,1024),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(2),ngZu,m3h4x16(:,384),heltab2x64(:,:,1000))
  call Hloop_Q_A(ntryL,G0H16(2),48,0,G1H16(19),n2h16(242))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1025),h0tab(:,1025),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(6),ngZu,m3h4x16(:,385),heltab2x64(:,:,1001))
  call Hloop_Q_A(ntryL,G0H16(6),48,nMT,G1H16(13),n2h16(243))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1026),h0tab(:,1026),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(18),ngZd,m3h4x16(:,386),heltab2x64(:,:,1002))
  call Hloop_Q_A(ntryL,G0H16(18),48,0,G1H16(20),n2h16(244))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1027),h0tab(:,1027),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZd,m3h4x16(:,387),heltab2x64(:,:,1003))
  call Hloop_Q_A(ntryL,G0H16(17),48,nMB,G1H16(32),n2h16(245))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1028),h0tab(:,1028),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,11))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(41),m3h4x16(:,388),heltab2x64(:,:,1004))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1029),h0tab(:,1029),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,11))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(48),m3h4x16(:,389),heltab2x64(:,:,1005))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1030),h0tab(:,1030),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(46),m3h4x16(:,390),heltab2x64(:,:,1006))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1031),h0tab(:,1031),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,11))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(53),m3h4x16(:,391),heltab2x64(:,:,1007))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1032),h0tab(:,1032),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,11))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(58),m3h4x16(:,392),heltab2x64(:,:,1008))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1033),h0tab(:,1033),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(57),m3h4x16(:,393),heltab2x64(:,:,1009))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1034),h0tab(:,1034),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(60),m3h4x16(:,394),heltab2x64(:,:,1010))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1035),h0tab(:,1035),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(75),m3h4x16(:,395),heltab2x64(:,:,1011))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1036),h0tab(:,1036),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(76),m3h4x16(:,396),heltab2x64(:,:,1012))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1037),h0tab(:,1037),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(1),m3h4x16(:,397),heltab2x64(:,:,1013))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1038),h0tab(:,1038),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(4),m3h4x16(:,398),heltab2x64(:,:,1014))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1039),h0tab(:,1039),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(32),m3h4x16(:,399),heltab2x64(:,:,1015))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1040),h0tab(:,1040),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(33),m3h4x16(:,400),heltab2x64(:,:,1016))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1041),h0tab(:,1041),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(22),m3h4x16(:,401),heltab2x64(:,:,1017))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1042),h0tab(:,1042),[56,7],[0,nMZ],2,2,wf8(:,61),wf8(:,20))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,61),G0H8(15),ngZn,m3h8x8(:,93),heltab2x64(:,:,1018))
  call Hloop_A_Q(ntryL,G0H8(15),56,0,G1H8(28),n2h8(125))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1043),h0tab(:,1043),[56,7],[0,nMW],2,2,wf8(:,61),wf8(:,20))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,61),G0H8(20),m3h8x8(:,94),heltab2x64(:,:,1019))
  call Hloop_A_Q(ntryL,G0H8(20),56,0,G1H8(94),n2h8(126))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1044),h0tab(:,1044),[57,6],[0,0],2,2,wf16(:,33),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,33),G0H4(79),ngZn,m3h16x4(:,355),heltab2x64(:,:,1020))
  call Hloop_Q_A(ntryL,G0H4(79),57,0,G1H4(221),n2h4(331))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1045),h0tab(:,1045),[57,6],[0,0],2,2,wf16(:,33),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,33),G0H4(79),ngZl,m3h16x4(:,356),heltab2x64(:,:,1021))
  call Hloop_Q_A(ntryL,G0H4(79),57,0,G1H4(222),n2h4(332))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1046),h0tab(:,1046),[57,6],[nML,nML],2,2,wf16(:,33),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,33),G0H4(79),ngZl,m3h16x4(:,357),heltab2x64(:,:,1022))
  call Hloop_Q_A(ntryL,G0H4(79),57,nML,G1H4(223),n2h4(333))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1047),h0tab(:,1047),[57,6],[0,0],2,2,wf16(:,33),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,33),G0H4(79),ngZu,m3h16x4(:,358),heltab2x64(:,:,1023))
  call Hloop_Q_A(ntryL,G0H4(79),57,0,G1H4(224),n2h4(334))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1048),h0tab(:,1048),[57,6],[nMT,nMT],2,2,wf16(:,33),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,33),G0H4(79),ngZu,m3h16x4(:,359),heltab2x64(:,:,1024))
  call Hloop_Q_A(ntryL,G0H4(79),57,nMT,G1H4(225),n2h4(335))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1049),h0tab(:,1049),[57,6],[0,0],2,2,wf16(:,33),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,33),G0H4(79),ngZd,m3h16x4(:,360),heltab2x64(:,:,1025))
  call Hloop_Q_A(ntryL,G0H4(79),57,0,G1H4(226),n2h4(336))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1050),h0tab(:,1050),[57,6],[nMB,nMB],2,2,wf16(:,33),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,33),G0H4(79),ngZd,m3h16x4(:,361),heltab2x64(:,:,1026))
  call Hloop_Q_A(ntryL,G0H4(79),57,nMB,G1H4(227),n2h4(337))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1051),h0tab(:,1051),[57,6],[nMH,nMZ],2,2,wf16(:,33),wf4(:,5))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,33),57,G1H4(228),m3h16x4(:,362),heltab2x64(:,:,1027))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1052),h0tab(:,1052),[57,6],[nMW,nMW],2,2,wf16(:,33),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,33),57,G1H4(229),m3h16x4(:,363),heltab2x64(:,:,1028))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1053),h0tab(:,1053),[57,6],[nMW,nMW],2,2,wf16(:,33),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,33),57,G1H4(230),m3h16x4(:,364),heltab2x64(:,:,1029))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1054),h0tab(:,1054),[57,6],[nMW,nMW],2,2,wf16(:,33),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,33),57,G1H4(231),m3h16x4(:,365),heltab2x64(:,:,1030))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1055),h0tab(:,1055),[57,6],[nMW,nMW],2,2,wf16(:,33),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,33),57,G1H4(232),m3h16x4(:,366),heltab2x64(:,:,1031))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1056),h0tab(:,1056),[57,6],[nMH,nMZ],2,2,wf16(:,33),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,33),G0H4(79),m3h16x4(:,367),heltab2x64(:,:,1032))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1057),h0tab(:,1057),[57,6],[nMW,nMW],2,2,wf16(:,33),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,33),G0H4(80),m3h16x4(:,368),heltab2x64(:,:,1033))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1058),h0tab(:,1058),[57,6],[nMW,nMW],2,2,wf16(:,33),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,33),G0H4(81),m3h16x4(:,369),heltab2x64(:,:,1034))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1059),h0tab(:,1059),[48,15],[0,0],2,2,wf4(:,7),wf16(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(3),m3h4x16(:,402),heltab2x64(:,:,1035))
  call Hloop_Q_A(ntryL,G0H16(3),48,0,G1H16(77),n2h16(246))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1060),h0tab(:,1060),[48,15],[nML,nML],2,2,wf4(:,7),wf16(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(15),m3h4x16(:,403),heltab2x64(:,:,1036))
  call Hloop_Q_A(ntryL,G0H16(15),48,nML,G1H16(78),n2h16(247))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1061),h0tab(:,1061),[48,15],[0,0],2,2,wf4(:,7),wf16(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(14),m3h4x16(:,404),heltab2x64(:,:,1037))
  call Hloop_Q_A(ntryL,G0H16(14),48,0,G1H16(79),n2h16(248))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1062),h0tab(:,1062),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(5),m3h4x16(:,405),heltab2x64(:,:,1038))
  call Hloop_Q_A(ntryL,G0H16(5),48,nMT,G1H16(80),n2h16(249))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1063),h0tab(:,1063),[48,15],[0,0],2,2,wf4(:,7),wf16(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(11),m3h4x16(:,406),heltab2x64(:,:,1039))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(81),n2h16(250))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1064),h0tab(:,1064),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(24),m3h4x16(:,407),heltab2x64(:,:,1040))
  call Hloop_Q_A(ntryL,G0H16(24),48,nMB,G1H16(82),n2h16(251))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1065),h0tab(:,1065),[48,15],[0,0],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(2),ngZn,m3h4x16(:,408),heltab2x64(:,:,1041))
  call Hloop_Q_A(ntryL,G0H16(2),48,0,G1H16(83),n2h16(252))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1066),h0tab(:,1066),[48,15],[0,0],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(6),ngZl,m3h4x16(:,409),heltab2x64(:,:,1042))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(84),n2h16(253))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1067),h0tab(:,1067),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(18),ngZl,m3h4x16(:,410),heltab2x64(:,:,1043))
  call Hloop_Q_A(ntryL,G0H16(18),48,nML,G1H16(85),n2h16(254))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1068),h0tab(:,1068),[48,15],[0,0],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZu,m3h4x16(:,411),heltab2x64(:,:,1044))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(86),n2h16(255))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1069),h0tab(:,1069),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(3),ngZu,m3h4x16(:,412),heltab2x64(:,:,1045))
  call Hloop_Q_A(ntryL,G0H16(3),48,nMT,G1H16(73),n2h16(256))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1070),h0tab(:,1070),[48,15],[0,0],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(15),ngZd,m3h4x16(:,413),heltab2x64(:,:,1046))
  call Hloop_Q_A(ntryL,G0H16(15),48,0,G1H16(74),n2h16(257))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1071),h0tab(:,1071),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(14),ngZd,m3h4x16(:,414),heltab2x64(:,:,1047))
  call Hloop_Q_A(ntryL,G0H16(14),48,nMB,G1H16(89),n2h16(258))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1072),h0tab(:,1072),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,12))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(90),m3h4x16(:,415),heltab2x64(:,:,1048))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1073),h0tab(:,1073),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,12))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(97),m3h4x16(:,416),heltab2x64(:,:,1049))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1074),h0tab(:,1074),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,12))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(98),m3h4x16(:,417),heltab2x64(:,:,1050))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1075),h0tab(:,1075),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(101),m3h4x16(:,418),heltab2x64(:,:,1051))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1076),h0tab(:,1076),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(102),m3h4x16(:,419),heltab2x64(:,:,1052))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1077),h0tab(:,1077),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(106),m3h4x16(:,420),heltab2x64(:,:,1053))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1078),h0tab(:,1078),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(110),m3h4x16(:,421),heltab2x64(:,:,1054))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1079),h0tab(:,1079),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(113),m3h4x16(:,422),heltab2x64(:,:,1055))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1080),h0tab(:,1080),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(112),m3h4x16(:,423),heltab2x64(:,:,1056))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1081),h0tab(:,1081),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,12))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(5),m3h4x16(:,424),heltab2x64(:,:,1057))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1082),h0tab(:,1082),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,12))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(11),m3h4x16(:,425),heltab2x64(:,:,1058))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1083),h0tab(:,1083),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,12))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(24),m3h4x16(:,426),heltab2x64(:,:,1059))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1084),h0tab(:,1084),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,12))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(2),m3h4x16(:,427),heltab2x64(:,:,1060))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1085),h0tab(:,1085),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,12))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(6),m3h4x16(:,428),heltab2x64(:,:,1061))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1086),h0tab(:,1086),[57,6],[0,0],2,2,wf16(:,34),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,34),G0H4(82),ngZn,m3h16x4(:,370),heltab2x64(:,:,1062))
  call Hloop_Q_A(ntryL,G0H4(82),57,0,G1H4(233),n2h4(338))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1087),h0tab(:,1087),[57,6],[0,0],2,2,wf16(:,34),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,34),G0H4(82),ngZl,m3h16x4(:,371),heltab2x64(:,:,1063))
  call Hloop_Q_A(ntryL,G0H4(82),57,0,G1H4(234),n2h4(339))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1088),h0tab(:,1088),[57,6],[nML,nML],2,2,wf16(:,34),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,34),G0H4(82),ngZl,m3h16x4(:,372),heltab2x64(:,:,1064))
  call Hloop_Q_A(ntryL,G0H4(82),57,nML,G1H4(235),n2h4(340))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1089),h0tab(:,1089),[57,6],[0,0],2,2,wf16(:,34),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,34),G0H4(82),ngZu,m3h16x4(:,373),heltab2x64(:,:,1065))
  call Hloop_Q_A(ntryL,G0H4(82),57,0,G1H4(236),n2h4(341))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1090),h0tab(:,1090),[57,6],[nMT,nMT],2,2,wf16(:,34),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,34),G0H4(82),ngZu,m3h16x4(:,374),heltab2x64(:,:,1066))
  call Hloop_Q_A(ntryL,G0H4(82),57,nMT,G1H4(237),n2h4(342))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1091),h0tab(:,1091),[57,6],[0,0],2,2,wf16(:,34),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,34),G0H4(82),ngZd,m3h16x4(:,375),heltab2x64(:,:,1067))
  call Hloop_Q_A(ntryL,G0H4(82),57,0,G1H4(238),n2h4(343))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1092),h0tab(:,1092),[57,6],[nMB,nMB],2,2,wf16(:,34),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,34),G0H4(82),ngZd,m3h16x4(:,376),heltab2x64(:,:,1068))
  call Hloop_Q_A(ntryL,G0H4(82),57,nMB,G1H4(239),n2h4(344))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1093),h0tab(:,1093),[57,6],[nMZ,nMH],2,2,wf16(:,34),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,34),57,G1H4(240),m3h16x4(:,377),heltab2x64(:,:,1069))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1094),h0tab(:,1094),[57,6],[nMW,nMW],2,2,wf16(:,34),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,34),57,G1H4(241),m3h16x4(:,378),heltab2x64(:,:,1070))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1095),h0tab(:,1095),[57,6],[nMW,nMW],2,2,wf16(:,34),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,34),57,G1H4(242),m3h16x4(:,379),heltab2x64(:,:,1071))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1096),h0tab(:,1096),[57,6],[nMW,nMW],2,2,wf16(:,34),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,34),57,G1H4(243),m3h16x4(:,380),heltab2x64(:,:,1072))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1097),h0tab(:,1097),[57,6],[nMW,nMW],2,2,wf16(:,34),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,34),57,G1H4(244),m3h16x4(:,381),heltab2x64(:,:,1073))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1098),h0tab(:,1098),[57,6],[nMZ,nMH],2,2,wf16(:,34),wf4(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,34),G0H4(82),m3h16x4(:,382),heltab2x64(:,:,1074))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1099),h0tab(:,1099),[57,6],[nMW,nMW],2,2,wf16(:,34),wf4(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,34),G0H4(83),m3h16x4(:,383),heltab2x64(:,:,1075))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1100),h0tab(:,1100),[57,6],[nMW,nMW],2,2,wf16(:,34),wf4(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,34),G0H4(84),m3h16x4(:,384),heltab2x64(:,:,1076))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1101),h0tab(:,1101),[49,14],[nMZ,0],2,2,wf8(:,23),wf8(:,85))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,23),G0H8(24),ngZn,m3h8x8(:,95),heltab2x64(:,:,1077))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1102),h0tab(:,1102),[49,14],[nMW,0],2,2,wf8(:,23),wf8(:,85))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,23),G0H8(27),m3h8x8(:,96),heltab2x64(:,:,1078))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1103),h0tab(:,1103),[48,15],[0,0],2,2,wf4(:,7),wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(18),m3h4x16(:,429),heltab2x64(:,:,1079))
  call Hloop_Q_A(ntryL,G0H16(18),48,0,G1H16(115),n2h16(259))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1104),h0tab(:,1104),[48,15],[nML,nML],2,2,wf4(:,7),wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(17),m3h4x16(:,430),heltab2x64(:,:,1080))
  call Hloop_Q_A(ntryL,G0H16(17),48,nML,G1H16(118),n2h16(260))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1105),h0tab(:,1105),[48,15],[0,0],2,2,wf4(:,7),wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(3),m3h4x16(:,431),heltab2x64(:,:,1081))
  call Hloop_Q_A(ntryL,G0H16(3),48,0,G1H16(117),n2h16(261))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1106),h0tab(:,1106),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(15),m3h4x16(:,432),heltab2x64(:,:,1082))
  call Hloop_Q_A(ntryL,G0H16(15),48,nMT,G1H16(120),n2h16(262))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1107),h0tab(:,1107),[48,15],[0,0],2,2,wf4(:,7),wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(14),m3h4x16(:,433),heltab2x64(:,:,1083))
  call Hloop_Q_A(ntryL,G0H16(14),48,0,G1H16(123),n2h16(263))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1108),h0tab(:,1108),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(18),m3h4x16(:,434),heltab2x64(:,:,1084))
  call Hloop_Q_A(ntryL,G0H16(18),48,nMB,G1H16(122),n2h16(264))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1109),h0tab(:,1109),[48,15],[0,0],2,2,wf4(:,3),wf16(:,18))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZn,m3h4x16(:,435),heltab2x64(:,:,1085))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(125),n2h16(265))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1110),h0tab(:,1110),[48,15],[0,0],2,2,wf4(:,3),wf16(:,18))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(3),ngZl,m3h4x16(:,436),heltab2x64(:,:,1086))
  call Hloop_Q_A(ntryL,G0H16(3),48,0,G1H16(128),n2h16(266))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1111),h0tab(:,1111),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,18))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(15),ngZl,m3h4x16(:,437),heltab2x64(:,:,1087))
  call Hloop_Q_A(ntryL,G0H16(15),48,nML,G1H16(127),n2h16(267))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1112),h0tab(:,1112),[48,15],[0,0],2,2,wf4(:,3),wf16(:,18))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(14),ngZu,m3h4x16(:,438),heltab2x64(:,:,1088))
  call Hloop_Q_A(ntryL,G0H16(14),48,0,G1H16(130),n2h16(268))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1113),h0tab(:,1113),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,18))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(18),ngZu,m3h4x16(:,439),heltab2x64(:,:,1089))
  call Hloop_Q_A(ntryL,G0H16(18),48,nMT,G1H16(133),n2h16(269))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1114),h0tab(:,1114),[48,15],[0,0],2,2,wf4(:,3),wf16(:,18))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(17),ngZd,m3h4x16(:,440),heltab2x64(:,:,1090))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(132),n2h16(270))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1115),h0tab(:,1115),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,18))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(3),ngZd,m3h4x16(:,441),heltab2x64(:,:,1091))
  call Hloop_Q_A(ntryL,G0H16(3),48,nMB,G1H16(135),n2h16(271))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1116),h0tab(:,1116),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,18))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(138),m3h4x16(:,442),heltab2x64(:,:,1092))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1117),h0tab(:,1117),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,18))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(137),m3h4x16(:,443),heltab2x64(:,:,1093))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1118),h0tab(:,1118),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,18))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(140),m3h4x16(:,444),heltab2x64(:,:,1094))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1119),h0tab(:,1119),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,18))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(141),m3h4x16(:,445),heltab2x64(:,:,1095))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1120),h0tab(:,1120),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,18))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(142),m3h4x16(:,446),heltab2x64(:,:,1096))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1121),h0tab(:,1121),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,18))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(143),m3h4x16(:,447),heltab2x64(:,:,1097))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1122),h0tab(:,1122),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,18))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(144),m3h4x16(:,448),heltab2x64(:,:,1098))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1123),h0tab(:,1123),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(145),m3h4x16(:,449),heltab2x64(:,:,1099))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1124),h0tab(:,1124),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(146),m3h4x16(:,450),heltab2x64(:,:,1100))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1125),h0tab(:,1125),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,18))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(15),m3h4x16(:,451),heltab2x64(:,:,1101))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1126),h0tab(:,1126),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,18))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(14),m3h4x16(:,452),heltab2x64(:,:,1102))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1127),h0tab(:,1127),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,18))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(18),m3h4x16(:,453),heltab2x64(:,:,1103))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1128),h0tab(:,1128),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,18))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(17),m3h4x16(:,454),heltab2x64(:,:,1104))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1129),h0tab(:,1129),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,18))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(3),m3h4x16(:,455),heltab2x64(:,:,1105))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1130),h0tab(:,1130),[52,11],[0,nMZ],2,2,wf8(:,70),wf8(:,26))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,70),G0H8(28),ngZn,m3h8x8(:,97),heltab2x64(:,:,1106))
  call Hloop_A_Q(ntryL,G0H8(28),52,0,G1H8(34),n2h8(127))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1131),h0tab(:,1131),[52,11],[0,nMW],2,2,wf8(:,70),wf8(:,26))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,70),G0H8(29),m3h8x8(:,98),heltab2x64(:,:,1107))
  call Hloop_A_Q(ntryL,G0H8(29),52,0,G1H8(35),n2h8(128))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1132),h0tab(:,1132),[48,15],[0,0],2,2,wf4(:,7),wf16(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(34),m3h4x16(:,456),heltab2x64(:,:,1108))
  call Hloop_Q_A(ntryL,G0H16(34),48,0,G1H16(147),n2h16(272))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1133),h0tab(:,1133),[48,15],[nML,nML],2,2,wf4(:,7),wf16(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(34),m3h4x16(:,457),heltab2x64(:,:,1109))
  call Hloop_Q_A(ntryL,G0H16(34),48,nML,G1H16(148),n2h16(273))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1134),h0tab(:,1134),[48,15],[0,0],2,2,wf4(:,7),wf16(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(34),m3h4x16(:,458),heltab2x64(:,:,1110))
  call Hloop_Q_A(ntryL,G0H16(34),48,0,G1H16(149),n2h16(274))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1135),h0tab(:,1135),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(34),m3h4x16(:,459),heltab2x64(:,:,1111))
  call Hloop_Q_A(ntryL,G0H16(34),48,nMT,G1H16(150),n2h16(275))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1136),h0tab(:,1136),[48,15],[0,0],2,2,wf4(:,7),wf16(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(34),m3h4x16(:,460),heltab2x64(:,:,1112))
  call Hloop_Q_A(ntryL,G0H16(34),48,0,G1H16(151),n2h16(276))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1137),h0tab(:,1137),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(34),m3h4x16(:,461),heltab2x64(:,:,1113))
  call Hloop_Q_A(ntryL,G0H16(34),48,nMB,G1H16(152),n2h16(277))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1138),h0tab(:,1138),[48,15],[0,0],2,2,wf4(:,3),wf16(:,19))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(34),ngZn,m3h4x16(:,462),heltab2x64(:,:,1114))
  call Hloop_Q_A(ntryL,G0H16(34),48,0,G1H16(153),n2h16(278))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1139),h0tab(:,1139),[48,15],[0,0],2,2,wf4(:,3),wf16(:,19))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(34),ngZl,m3h4x16(:,463),heltab2x64(:,:,1115))
  call Hloop_Q_A(ntryL,G0H16(34),48,0,G1H16(154),n2h16(279))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1140),h0tab(:,1140),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,19))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(34),ngZl,m3h4x16(:,464),heltab2x64(:,:,1116))
  call Hloop_Q_A(ntryL,G0H16(34),48,nML,G1H16(155),n2h16(280))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1141),h0tab(:,1141),[48,15],[0,0],2,2,wf4(:,3),wf16(:,19))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(34),ngZu,m3h4x16(:,465),heltab2x64(:,:,1117))
  call Hloop_Q_A(ntryL,G0H16(34),48,0,G1H16(156),n2h16(281))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1142),h0tab(:,1142),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,19))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(34),ngZu,m3h4x16(:,466),heltab2x64(:,:,1118))
  call Hloop_Q_A(ntryL,G0H16(34),48,nMT,G1H16(157),n2h16(282))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1143),h0tab(:,1143),[48,15],[0,0],2,2,wf4(:,3),wf16(:,19))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(34),ngZd,m3h4x16(:,467),heltab2x64(:,:,1119))
  call Hloop_Q_A(ntryL,G0H16(34),48,0,G1H16(158),n2h16(283))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1144),h0tab(:,1144),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,19))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(34),ngZd,m3h4x16(:,468),heltab2x64(:,:,1120))
  call Hloop_Q_A(ntryL,G0H16(34),48,nMB,G1H16(159),n2h16(284))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1145),h0tab(:,1145),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,19))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(160),m3h4x16(:,469),heltab2x64(:,:,1121))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1146),h0tab(:,1146),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,19))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(161),m3h4x16(:,470),heltab2x64(:,:,1122))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1147),h0tab(:,1147),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,19))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(162),m3h4x16(:,471),heltab2x64(:,:,1123))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1148),h0tab(:,1148),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,19))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(163),m3h4x16(:,472),heltab2x64(:,:,1124))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1149),h0tab(:,1149),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,19))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(164),m3h4x16(:,473),heltab2x64(:,:,1125))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1150),h0tab(:,1150),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,19))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(165),m3h4x16(:,474),heltab2x64(:,:,1126))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1151),h0tab(:,1151),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,19))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(166),m3h4x16(:,475),heltab2x64(:,:,1127))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1152),h0tab(:,1152),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(167),m3h4x16(:,476),heltab2x64(:,:,1128))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1153),h0tab(:,1153),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(168),m3h4x16(:,477),heltab2x64(:,:,1129))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1154),h0tab(:,1154),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,19))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(34),m3h4x16(:,478),heltab2x64(:,:,1130))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1155),h0tab(:,1155),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,19))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(35),m3h4x16(:,479),heltab2x64(:,:,1131))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1156),h0tab(:,1156),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,19))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(36),m3h4x16(:,480),heltab2x64(:,:,1132))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1157),h0tab(:,1157),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,19))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(37),m3h4x16(:,481),heltab2x64(:,:,1133))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1158),h0tab(:,1158),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,19))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(38),m3h4x16(:,482),heltab2x64(:,:,1134))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1159),h0tab(:,1159),[50,13],[nMZ,0],2,2,wf8(:,12),wf8(:,68))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,12),G0H8(2),ngZn,m3h8x8(:,99),heltab2x64(:,:,1135))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1160),h0tab(:,1160),[50,13],[nMW,0],2,2,wf8(:,12),wf8(:,68))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,12),G0H8(3),m3h8x8(:,100),heltab2x64(:,:,1136))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1161),h0tab(:,1161),[54,9],[0,0],2,2,wf16(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,35),G0H4(85),ngZn,m3h16x4(:,385),heltab2x64(:,:,1137))
  call Hloop_Q_A(ntryL,G0H4(85),54,0,G1H4(245),n2h4(345))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1162),h0tab(:,1162),[54,9],[0,0],2,2,wf16(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,35),G0H4(85),ngZl,m3h16x4(:,386),heltab2x64(:,:,1138))
  call Hloop_Q_A(ntryL,G0H4(85),54,0,G1H4(246),n2h4(346))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1163),h0tab(:,1163),[54,9],[nML,nML],2,2,wf16(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,35),G0H4(85),ngZl,m3h16x4(:,387),heltab2x64(:,:,1139))
  call Hloop_Q_A(ntryL,G0H4(85),54,nML,G1H4(247),n2h4(347))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1164),h0tab(:,1164),[54,9],[0,0],2,2,wf16(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,35),G0H4(85),ngZu,m3h16x4(:,388),heltab2x64(:,:,1140))
  call Hloop_Q_A(ntryL,G0H4(85),54,0,G1H4(248),n2h4(348))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1165),h0tab(:,1165),[54,9],[nMT,nMT],2,2,wf16(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,35),G0H4(85),ngZu,m3h16x4(:,389),heltab2x64(:,:,1141))
  call Hloop_Q_A(ntryL,G0H4(85),54,nMT,G1H4(249),n2h4(349))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1166),h0tab(:,1166),[54,9],[0,0],2,2,wf16(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,35),G0H4(85),ngZd,m3h16x4(:,390),heltab2x64(:,:,1142))
  call Hloop_Q_A(ntryL,G0H4(85),54,0,G1H4(250),n2h4(350))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1167),h0tab(:,1167),[54,9],[nMB,nMB],2,2,wf16(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,35),G0H4(85),ngZd,m3h16x4(:,391),heltab2x64(:,:,1143))
  call Hloop_Q_A(ntryL,G0H4(85),54,nMB,G1H4(251),n2h4(351))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1168),h0tab(:,1168),[54,9],[nMH,nMZ],2,2,wf16(:,35),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,35),54,G1H4(252),m3h16x4(:,392),heltab2x64(:,:,1144))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1169),h0tab(:,1169),[54,9],[nMW,nMW],2,2,wf16(:,35),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,35),54,G1H4(253),m3h16x4(:,393),heltab2x64(:,:,1145))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1170),h0tab(:,1170),[54,9],[nMW,nMW],2,2,wf16(:,35),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,35),54,G1H4(254),m3h16x4(:,394),heltab2x64(:,:,1146))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1171),h0tab(:,1171),[54,9],[nMW,nMW],2,2,wf16(:,35),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,35),54,G1H4(255),m3h16x4(:,395),heltab2x64(:,:,1147))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1172),h0tab(:,1172),[54,9],[nMW,nMW],2,2,wf16(:,35),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,35),54,G1H4(256),m3h16x4(:,396),heltab2x64(:,:,1148))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1173),h0tab(:,1173),[54,9],[nMH,nMZ],2,2,wf16(:,35),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,35),G0H4(85),m3h16x4(:,397),heltab2x64(:,:,1149))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1174),h0tab(:,1174),[54,9],[nMW,nMW],2,2,wf16(:,35),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,35),G0H4(86),m3h16x4(:,398),heltab2x64(:,:,1150))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1175),h0tab(:,1175),[54,9],[nMW,nMW],2,2,wf16(:,35),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,35),G0H4(87),m3h16x4(:,399),heltab2x64(:,:,1151))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1176),h0tab(:,1176),[54,9],[0,0],2,2,wf16(:,36),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,36),G0H4(88),ngZn,m3h16x4(:,400),heltab2x64(:,:,1152))
  call Hloop_Q_A(ntryL,G0H4(88),54,0,G1H4(257),n2h4(352))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1177),h0tab(:,1177),[54,9],[0,0],2,2,wf16(:,36),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,36),G0H4(88),ngZl,m3h16x4(:,401),heltab2x64(:,:,1153))
  call Hloop_Q_A(ntryL,G0H4(88),54,0,G1H4(258),n2h4(353))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1178),h0tab(:,1178),[54,9],[nML,nML],2,2,wf16(:,36),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,36),G0H4(88),ngZl,m3h16x4(:,402),heltab2x64(:,:,1154))
  call Hloop_Q_A(ntryL,G0H4(88),54,nML,G1H4(259),n2h4(354))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1179),h0tab(:,1179),[54,9],[0,0],2,2,wf16(:,36),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,36),G0H4(88),ngZu,m3h16x4(:,403),heltab2x64(:,:,1155))
  call Hloop_Q_A(ntryL,G0H4(88),54,0,G1H4(260),n2h4(355))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1180),h0tab(:,1180),[54,9],[nMT,nMT],2,2,wf16(:,36),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,36),G0H4(88),ngZu,m3h16x4(:,404),heltab2x64(:,:,1156))
  call Hloop_Q_A(ntryL,G0H4(88),54,nMT,G1H4(261),n2h4(356))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1181),h0tab(:,1181),[54,9],[0,0],2,2,wf16(:,36),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,36),G0H4(88),ngZd,m3h16x4(:,405),heltab2x64(:,:,1157))
  call Hloop_Q_A(ntryL,G0H4(88),54,0,G1H4(262),n2h4(357))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1182),h0tab(:,1182),[54,9],[nMB,nMB],2,2,wf16(:,36),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,36),G0H4(88),ngZd,m3h16x4(:,406),heltab2x64(:,:,1158))
  call Hloop_Q_A(ntryL,G0H4(88),54,nMB,G1H4(263),n2h4(358))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1183),h0tab(:,1183),[54,9],[nMH,nMZ],2,2,wf16(:,36),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,36),54,G1H4(264),m3h16x4(:,407),heltab2x64(:,:,1159))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1184),h0tab(:,1184),[54,9],[nMW,nMW],2,2,wf16(:,36),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,36),54,G1H4(265),m3h16x4(:,408),heltab2x64(:,:,1160))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1185),h0tab(:,1185),[54,9],[nMW,nMW],2,2,wf16(:,36),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,36),54,G1H4(266),m3h16x4(:,409),heltab2x64(:,:,1161))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1186),h0tab(:,1186),[54,9],[nMW,nMW],2,2,wf16(:,36),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,36),54,G1H4(267),m3h16x4(:,410),heltab2x64(:,:,1162))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1187),h0tab(:,1187),[54,9],[nMW,nMW],2,2,wf16(:,36),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,36),54,G1H4(268),m3h16x4(:,411),heltab2x64(:,:,1163))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1188),h0tab(:,1188),[54,9],[nMH,nMZ],2,2,wf16(:,36),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,36),G0H4(88),m3h16x4(:,412),heltab2x64(:,:,1164))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1189),h0tab(:,1189),[54,9],[nMW,nMW],2,2,wf16(:,36),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,36),G0H4(89),m3h16x4(:,413),heltab2x64(:,:,1165))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1190),h0tab(:,1190),[54,9],[nMW,nMW],2,2,wf16(:,36),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,36),G0H4(90),m3h16x4(:,414),heltab2x64(:,:,1166))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1191),h0tab(:,1191),[48,15],[0,0],2,2,wf4(:,7),wf16(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(39),m3h4x16(:,483),heltab2x64(:,:,1167))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(169),n2h16(285))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1192),h0tab(:,1192),[48,15],[nML,nML],2,2,wf4(:,7),wf16(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(39),m3h4x16(:,484),heltab2x64(:,:,1168))
  call Hloop_Q_A(ntryL,G0H16(39),48,nML,G1H16(170),n2h16(286))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1193),h0tab(:,1193),[48,15],[0,0],2,2,wf4(:,7),wf16(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(39),m3h4x16(:,485),heltab2x64(:,:,1169))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(171),n2h16(287))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1194),h0tab(:,1194),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(39),m3h4x16(:,486),heltab2x64(:,:,1170))
  call Hloop_Q_A(ntryL,G0H16(39),48,nMT,G1H16(172),n2h16(288))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1195),h0tab(:,1195),[48,15],[0,0],2,2,wf4(:,7),wf16(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(39),m3h4x16(:,487),heltab2x64(:,:,1171))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(173),n2h16(289))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1196),h0tab(:,1196),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(39),m3h4x16(:,488),heltab2x64(:,:,1172))
  call Hloop_Q_A(ntryL,G0H16(39),48,nMB,G1H16(174),n2h16(290))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1197),h0tab(:,1197),[48,15],[0,0],2,2,wf4(:,3),wf16(:,25))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(39),ngZn,m3h4x16(:,489),heltab2x64(:,:,1173))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(175),n2h16(291))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1198),h0tab(:,1198),[48,15],[0,0],2,2,wf4(:,3),wf16(:,25))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(39),ngZl,m3h4x16(:,490),heltab2x64(:,:,1174))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(176),n2h16(292))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1199),h0tab(:,1199),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,25))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(39),ngZl,m3h4x16(:,491),heltab2x64(:,:,1175))
  call Hloop_Q_A(ntryL,G0H16(39),48,nML,G1H16(177),n2h16(293))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1200),h0tab(:,1200),[48,15],[0,0],2,2,wf4(:,3),wf16(:,25))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(39),ngZu,m3h4x16(:,492),heltab2x64(:,:,1176))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(178),n2h16(294))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1201),h0tab(:,1201),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,25))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(39),ngZu,m3h4x16(:,493),heltab2x64(:,:,1177))
  call Hloop_Q_A(ntryL,G0H16(39),48,nMT,G1H16(179),n2h16(295))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1202),h0tab(:,1202),[48,15],[0,0],2,2,wf4(:,3),wf16(:,25))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(39),ngZd,m3h4x16(:,494),heltab2x64(:,:,1178))
  call Hloop_Q_A(ntryL,G0H16(39),48,0,G1H16(180),n2h16(296))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1203),h0tab(:,1203),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,25))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(39),ngZd,m3h4x16(:,495),heltab2x64(:,:,1179))
  call Hloop_Q_A(ntryL,G0H16(39),48,nMB,G1H16(181),n2h16(297))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1204),h0tab(:,1204),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,25))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(182),m3h4x16(:,496),heltab2x64(:,:,1180))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1205),h0tab(:,1205),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,25))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(183),m3h4x16(:,497),heltab2x64(:,:,1181))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1206),h0tab(:,1206),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,25))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(184),m3h4x16(:,498),heltab2x64(:,:,1182))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1207),h0tab(:,1207),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,25))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(185),m3h4x16(:,499),heltab2x64(:,:,1183))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1208),h0tab(:,1208),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,25))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(186),m3h4x16(:,500),heltab2x64(:,:,1184))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1209),h0tab(:,1209),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,25))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(187),m3h4x16(:,501),heltab2x64(:,:,1185))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1210),h0tab(:,1210),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,25))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(188),m3h4x16(:,502),heltab2x64(:,:,1186))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1211),h0tab(:,1211),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,25))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(189),m3h4x16(:,503),heltab2x64(:,:,1187))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1212),h0tab(:,1212),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,25))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(190),m3h4x16(:,504),heltab2x64(:,:,1188))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1213),h0tab(:,1213),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,25))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(39),m3h4x16(:,505),heltab2x64(:,:,1189))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1214),h0tab(:,1214),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,25))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(40),m3h4x16(:,506),heltab2x64(:,:,1190))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1215),h0tab(:,1215),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,25))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(41),m3h4x16(:,507),heltab2x64(:,:,1191))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1216),h0tab(:,1216),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,25))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(42),m3h4x16(:,508),heltab2x64(:,:,1192))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1217),h0tab(:,1217),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,25))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(43),m3h4x16(:,509),heltab2x64(:,:,1193))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1218),h0tab(:,1218),[52,11],[0,nMZ],2,2,wf8(:,70),wf8(:,29))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,70),G0H8(8),ngZn,m3h8x8(:,101),heltab2x64(:,:,1194))
  call Hloop_A_Q(ntryL,G0H8(8),52,0,G1H8(36),n2h8(129))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1219),h0tab(:,1219),[52,11],[0,nMW],2,2,wf8(:,70),wf8(:,29))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,70),G0H8(9),m3h8x8(:,102),heltab2x64(:,:,1195))
  call Hloop_A_Q(ntryL,G0H8(9),52,0,G1H8(42),n2h8(130))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1220),h0tab(:,1220),[53,10],[0,0],2,2,wf16(:,31),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,31),G0H4(91),ngZn,m3h16x4(:,415),heltab2x64(:,:,1196))
  call Hloop_Q_A(ntryL,G0H4(91),53,0,G1H4(269),n2h4(359))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1221),h0tab(:,1221),[53,10],[0,0],2,2,wf16(:,31),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,31),G0H4(91),ngZl,m3h16x4(:,416),heltab2x64(:,:,1197))
  call Hloop_Q_A(ntryL,G0H4(91),53,0,G1H4(270),n2h4(360))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1222),h0tab(:,1222),[53,10],[nML,nML],2,2,wf16(:,31),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,31),G0H4(91),ngZl,m3h16x4(:,417),heltab2x64(:,:,1198))
  call Hloop_Q_A(ntryL,G0H4(91),53,nML,G1H4(271),n2h4(361))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1223),h0tab(:,1223),[53,10],[0,0],2,2,wf16(:,31),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,31),G0H4(91),ngZu,m3h16x4(:,418),heltab2x64(:,:,1199))
  call Hloop_Q_A(ntryL,G0H4(91),53,0,G1H4(272),n2h4(362))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1224),h0tab(:,1224),[53,10],[nMT,nMT],2,2,wf16(:,31),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,31),G0H4(91),ngZu,m3h16x4(:,419),heltab2x64(:,:,1200))
  call Hloop_Q_A(ntryL,G0H4(91),53,nMT,G1H4(273),n2h4(363))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1225),h0tab(:,1225),[53,10],[0,0],2,2,wf16(:,31),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,31),G0H4(91),ngZd,m3h16x4(:,420),heltab2x64(:,:,1201))
  call Hloop_Q_A(ntryL,G0H4(91),53,0,G1H4(274),n2h4(364))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1226),h0tab(:,1226),[53,10],[nMB,nMB],2,2,wf16(:,31),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,31),G0H4(91),ngZd,m3h16x4(:,421),heltab2x64(:,:,1202))
  call Hloop_Q_A(ntryL,G0H4(91),53,nMB,G1H4(275),n2h4(365))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1227),h0tab(:,1227),[53,10],[nMH,nMZ],2,2,wf16(:,31),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf16(:,31),53,G1H4(276),m3h16x4(:,422),heltab2x64(:,:,1203))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1228),h0tab(:,1228),[53,10],[nMW,nMW],2,2,wf16(:,31),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,31),53,G1H4(277),m3h16x4(:,423),heltab2x64(:,:,1204))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1229),h0tab(:,1229),[53,10],[nMW,nMW],2,2,wf16(:,31),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,31),53,G1H4(278),m3h16x4(:,424),heltab2x64(:,:,1205))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1230),h0tab(:,1230),[53,10],[nMW,nMW],2,2,wf16(:,31),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,31),53,G1H4(279),m3h16x4(:,425),heltab2x64(:,:,1206))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1231),h0tab(:,1231),[53,10],[nMW,nMW],2,2,wf16(:,31),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,31),53,G1H4(280),m3h16x4(:,426),heltab2x64(:,:,1207))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1232),h0tab(:,1232),[53,10],[nMH,nMZ],2,2,wf16(:,31),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,31),G0H4(91),m3h16x4(:,427),heltab2x64(:,:,1208))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1233),h0tab(:,1233),[53,10],[nMW,nMW],2,2,wf16(:,31),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,31),G0H4(92),m3h16x4(:,428),heltab2x64(:,:,1209))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1234),h0tab(:,1234),[53,10],[nMW,nMW],2,2,wf16(:,31),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf16(:,31),G0H4(93),m3h16x4(:,429),heltab2x64(:,:,1210))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1235),h0tab(:,1235),[48,15],[0,0],2,2,wf4(:,7),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(44),m3h4x16(:,510),heltab2x64(:,:,1211))
  call Hloop_Q_A(ntryL,G0H16(44),48,0,G1H16(191),n2h16(298))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1236),h0tab(:,1236),[48,15],[nML,nML],2,2,wf4(:,7),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(44),m3h4x16(:,511),heltab2x64(:,:,1212))
  call Hloop_Q_A(ntryL,G0H16(44),48,nML,G1H16(192),n2h16(299))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1237),h0tab(:,1237),[48,15],[0,0],2,2,wf4(:,7),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(44),m3h4x16(:,512),heltab2x64(:,:,1213))
  call Hloop_Q_A(ntryL,G0H16(44),48,0,G1H16(193),n2h16(300))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1238),h0tab(:,1238),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(44),m3h4x16(:,513),heltab2x64(:,:,1214))
  call Hloop_Q_A(ntryL,G0H16(44),48,nMT,G1H16(194),n2h16(301))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1239),h0tab(:,1239),[48,15],[0,0],2,2,wf4(:,7),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(44),m3h4x16(:,514),heltab2x64(:,:,1215))
  call Hloop_Q_A(ntryL,G0H16(44),48,0,G1H16(195),n2h16(302))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1240),h0tab(:,1240),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(44),m3h4x16(:,515),heltab2x64(:,:,1216))
  call Hloop_Q_A(ntryL,G0H16(44),48,nMB,G1H16(196),n2h16(303))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1241),h0tab(:,1241),[48,15],[0,0],2,2,wf4(:,3),wf16(:,26))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(44),ngZn,m3h4x16(:,516),heltab2x64(:,:,1217))
  call Hloop_Q_A(ntryL,G0H16(44),48,0,G1H16(197),n2h16(304))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1242),h0tab(:,1242),[48,15],[0,0],2,2,wf4(:,3),wf16(:,26))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(44),ngZl,m3h4x16(:,517),heltab2x64(:,:,1218))
  call Hloop_Q_A(ntryL,G0H16(44),48,0,G1H16(198),n2h16(305))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1243),h0tab(:,1243),[48,15],[nML,nML],2,2,wf4(:,3),wf16(:,26))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(44),ngZl,m3h4x16(:,518),heltab2x64(:,:,1219))
  call Hloop_Q_A(ntryL,G0H16(44),48,nML,G1H16(199),n2h16(306))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1244),h0tab(:,1244),[48,15],[0,0],2,2,wf4(:,3),wf16(:,26))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(44),ngZu,m3h4x16(:,519),heltab2x64(:,:,1220))
  call Hloop_Q_A(ntryL,G0H16(44),48,0,G1H16(200),n2h16(307))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1245),h0tab(:,1245),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,26))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(44),ngZu,m3h4x16(:,520),heltab2x64(:,:,1221))
  call Hloop_Q_A(ntryL,G0H16(44),48,nMT,G1H16(201),n2h16(308))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1246),h0tab(:,1246),[48,15],[0,0],2,2,wf4(:,3),wf16(:,26))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(44),ngZd,m3h4x16(:,521),heltab2x64(:,:,1222))
  call Hloop_Q_A(ntryL,G0H16(44),48,0,G1H16(202),n2h16(309))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1247),h0tab(:,1247),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,26))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,3),G0H16(44),ngZd,m3h4x16(:,522),heltab2x64(:,:,1223))
  call Hloop_Q_A(ntryL,G0H16(44),48,nMB,G1H16(203),n2h16(310))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1248),h0tab(:,1248),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,26))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(204),m3h4x16(:,523),heltab2x64(:,:,1224))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1249),h0tab(:,1249),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,26))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(205),m3h4x16(:,524),heltab2x64(:,:,1225))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1250),h0tab(:,1250),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,26))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(206),m3h4x16(:,525),heltab2x64(:,:,1226))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1251),h0tab(:,1251),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,26))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(207),m3h4x16(:,526),heltab2x64(:,:,1227))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1252),h0tab(:,1252),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,26))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(208),m3h4x16(:,527),heltab2x64(:,:,1228))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1253),h0tab(:,1253),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,26))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(209),m3h4x16(:,528),heltab2x64(:,:,1229))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1254),h0tab(:,1254),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,26))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(210),m3h4x16(:,529),heltab2x64(:,:,1230))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1255),h0tab(:,1255),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,26))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(211),m3h4x16(:,530),heltab2x64(:,:,1231))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1256),h0tab(:,1256),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,26))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(212),m3h4x16(:,531),heltab2x64(:,:,1232))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1257),h0tab(:,1257),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,26))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(44),m3h4x16(:,532),heltab2x64(:,:,1233))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1258),h0tab(:,1258),[48,15],[nMW,nMW],2,2,wf4(:,7),wf16(:,26))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(45),m3h4x16(:,533),heltab2x64(:,:,1234))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1259),h0tab(:,1259),[48,15],[nMH,nMZ],2,2,wf4(:,3),wf16(:,26))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(46),m3h4x16(:,534),heltab2x64(:,:,1235))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1260),h0tab(:,1260),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,26))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(47),m3h4x16(:,535),heltab2x64(:,:,1236))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1261),h0tab(:,1261),[48,15],[nMW,nMW],2,2,wf4(:,3),wf16(:,26))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(48),m3h4x16(:,536),heltab2x64(:,:,1237))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1262),h0tab(:,1262),[53,10],[0,0],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,32),G0H4(94),ngZn,m3h16x4(:,430),heltab2x64(:,:,1238))
  call Hloop_Q_A(ntryL,G0H4(94),53,0,G1H4(281),n2h4(366))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1263),h0tab(:,1263),[53,10],[0,0],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,32),G0H4(94),ngZl,m3h16x4(:,431),heltab2x64(:,:,1239))
  call Hloop_Q_A(ntryL,G0H4(94),53,0,G1H4(282),n2h4(367))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1264),h0tab(:,1264),[53,10],[nML,nML],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,32),G0H4(94),ngZl,m3h16x4(:,432),heltab2x64(:,:,1240))
  call Hloop_Q_A(ntryL,G0H4(94),53,nML,G1H4(283),n2h4(368))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1265),h0tab(:,1265),[53,10],[0,0],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,32),G0H4(94),ngZu,m3h16x4(:,433),heltab2x64(:,:,1241))
  call Hloop_Q_A(ntryL,G0H4(94),53,0,G1H4(284),n2h4(369))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1266),h0tab(:,1266),[53,10],[nMT,nMT],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,32),G0H4(94),ngZu,m3h16x4(:,434),heltab2x64(:,:,1242))
  call Hloop_Q_A(ntryL,G0H4(94),53,nMT,G1H4(285),n2h4(370))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1267),h0tab(:,1267),[53,10],[0,0],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,32),G0H4(94),ngZd,m3h16x4(:,435),heltab2x64(:,:,1243))
  call Hloop_Q_A(ntryL,G0H4(94),53,0,G1H4(286),n2h4(371))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1268),h0tab(:,1268),[53,10],[nMB,nMB],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf16(:,32),G0H4(94),ngZd,m3h16x4(:,436),heltab2x64(:,:,1244))
  call Hloop_Q_A(ntryL,G0H4(94),53,nMB,G1H4(287),n2h4(372))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1269),h0tab(:,1269),[53,10],[nMZ,nMH],2,2,wf16(:,32),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,32),53,G1H4(288),m3h16x4(:,437),heltab2x64(:,:,1245))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1270),h0tab(:,1270),[53,10],[nMW,nMW],2,2,wf16(:,32),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf16(:,32),53,G1H4(289),m3h16x4(:,438),heltab2x64(:,:,1246))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1271),h0tab(:,1271),[53,10],[nMW,nMW],2,2,wf16(:,32),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,32),53,G1H4(290),m3h16x4(:,439),heltab2x64(:,:,1247))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1272),h0tab(:,1272),[53,10],[nMW,nMW],2,2,wf16(:,32),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,32),53,G1H4(291),m3h16x4(:,440),heltab2x64(:,:,1248))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1273),h0tab(:,1273),[53,10],[nMW,nMW],2,2,wf16(:,32),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,32),53,G1H4(292),m3h16x4(:,441),heltab2x64(:,:,1249))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1274),h0tab(:,1274),[53,10],[nMZ,nMH],2,2,wf16(:,32),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,32),G0H4(94),m3h16x4(:,442),heltab2x64(:,:,1250))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1275),h0tab(:,1275),[53,10],[nMW,nMW],2,2,wf16(:,32),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,32),G0H4(95),m3h16x4(:,443),heltab2x64(:,:,1251))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1276),h0tab(:,1276),[53,10],[nMW,nMW],2,2,wf16(:,32),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf16(:,32),G0H4(96),m3h16x4(:,444),heltab2x64(:,:,1252))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1277),h0tab(:,1277),[49,14],[nMZ,0],2,2,wf8(:,23),wf8(:,94))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,23),G0H8(5),ngZn,m3h8x8(:,103),heltab2x64(:,:,1253))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1278),h0tab(:,1278),[49,14],[nMW,0],2,2,wf8(:,23),wf8(:,94))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,23),G0H8(6),m3h8x8(:,104),heltab2x64(:,:,1254))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(25),G1H4(26),G1H4(67),G1H4(119),G1H4(114) &
    ,G0H4(21),G0H4(3),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(41),G1H4(87),G1H4(86),G1H4(103),G1H4(45) &
    ,G0H4(24),G0H4(13),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(289),[G1H4(277),G1H4(5),G1H4(20),G1H4(79),G1H4(68) &
    ,G0H4(14),G0H4(8),G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(292),[G1H4(280),G1H4(65),G1H4(57),G1H4(85),G1H4(89) &
    ,G0H4(20),G0H4(7),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(265),[G1H4(253),G1H4(214),G1H4(212),G1H4(192),G1H4(190) &
    ,G0H4(55),G0H4(4),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(268),[G1H4(256),G1H4(220),G1H4(219),G1H4(198),G1H4(197) &
    ,G0H4(58),G0H4(2),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(241),[G1H4(229),G1H4(170),G1H4(168),G1H4(148),G1H4(146) &
    ,G0H4(51),G0H4(17),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(244),[G1H4(232),G1H4(176),G1H4(175),G1H4(154),G1H4(153) &
    ,G0H4(54),G0H4(5),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(22),[G1H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(47),[G1H16(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(50),[G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(1),[G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(56),[G1H16(4),G1H16(11),G1H16(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(12),[G0H16(10),G0H16(7),G0H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(283),[G1H4(271),G1H4(56),G1H4(2),G1H4(59),G1H4(84) &
    ,G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(285),[G1H4(273),G1H4(9),G1H4(104),G1H4(80),G1H4(74) &
    ,G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(287),[G1H4(275),G1H4(55),G1H4(122),G1H4(29),G1H4(37) &
    ,G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(291),[G1H4(290),G1H4(279),G1H4(278),G1H4(116),G1H4(105) &
    ,G1H4(71),G1H4(53),G1H4(8),G1H4(48),G1H4(112),G1H4(72),G0H4(19),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(128),G0H4(93),G0H4(92),G0H4(34),G0H4(33) &
    ,G0H4(31),G0H4(30),G0H4(29),G0H4(28),G0H4(26),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(12),G1H4(50),G1H4(39),G1H4(101),G1H4(33) &
    ,G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(58),G1H4(38),G1H4(109),G1H4(110),G1H4(92) &
    ,G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(13),G1H4(66),G1H4(88),G1H4(113),G1H4(97) &
    ,G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(10),G1H4(46),G1H4(31),G1H4(82),G1H4(81) &
    ,G1H4(77),G1H4(75),G1H4(127),G1H4(126),G1H4(124),G1H4(123),G0H4(23),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(90),G0H4(50),G0H4(49),G0H4(47),G0H4(46) &
    ,G0H4(44),G0H4(43),G0H4(41),G0H4(40),G0H4(39),G0H4(38),G0H4(36),G0H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(282),[G1H4(270),G1H4(49),G1H4(115),G1H4(96),G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(284),[G1H4(272),G1H4(60),G1H4(107),G1H4(94),G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(286),[G1H4(274),G1H4(54),G1H4(125),G1H4(78),G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(281),[G1H4(269),G1H4(3),G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(276),[G1H4(21),G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(91),[G0H4(32),G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(16),G1H4(36),G1H4(17),G1H4(100),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(44),G1H4(61),G1H4(11),G1H4(106),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(70),G1H4(62),G1H4(35),G1H4(111),G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(15),G1H4(4),G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(14),G1H4(1),G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(48),[G0H4(45),G0H4(42),G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(51),[G1H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(55),[G1H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(59),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(61),[G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(62),[G1H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(63),[G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(66),[G1H16(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(70),[G1H16(69),G1H16(68),G1H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(72),[G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(13),[G0H16(19),G0H16(20),G0H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(92),[G1H16(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(99),[G1H16(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(100),[G1H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(105),[G1H16(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(104),[G1H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(103),[G1H16(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(107),[G1H16(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(119),[G1H16(116),G1H16(114),G1H16(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(124),[G1H16(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(30),[G0H16(29),G0H16(8),G0H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(134),[G1H16(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(136),[G1H16(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(139),[G1H16(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(33),G1H16(30),G1H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(31),[G0H16(28),G0H16(27),G0H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(235),[G1H4(223),G1H4(163),G1H4(156),G1H4(141),G1H4(134) &
    ,G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(237),[G1H4(225),G1H4(165),G1H4(158),G1H4(143),G1H4(136) &
    ,G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(239),[G1H4(227),G1H4(167),G1H4(160),G1H4(145),G1H4(138) &
    ,G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(243),[G1H4(242),G1H4(231),G1H4(230),G1H4(174),G1H4(173) &
    ,G1H4(172),G1H4(171),G1H4(152),G1H4(151),G1H4(150),G1H4(149),G0H4(53),G0H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(24),G0H4(81),G0H4(80),G0H4(68),G0H4(67),G0H4(65) &
    ,G0H4(64),G0H4(63),G0H4(62),G0H4(60),G0H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(259),[G1H4(247),G1H4(207),G1H4(200),G1H4(185),G1H4(178) &
    ,G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(261),[G1H4(249),G1H4(209),G1H4(202),G1H4(187),G1H4(180) &
    ,G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(263),[G1H4(251),G1H4(211),G1H4(204),G1H4(189),G1H4(182) &
    ,G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(267),[G1H4(266),G1H4(255),G1H4(254),G1H4(218),G1H4(217) &
    ,G1H4(216),G1H4(215),G1H4(196),G1H4(195),G1H4(194),G1H4(193),G0H4(57),G0H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(132),[G1H4(131),G0H4(90),G0H4(89),G0H4(87),G0H4(86) &
    ,G0H4(78),G0H4(77),G0H4(75),G0H4(74),G0H4(73),G0H4(72),G0H4(70),G0H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(234),[G1H4(222),G1H4(162),G1H4(155),G1H4(140) &
    ,G1H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(236),[G1H4(224),G1H4(164),G1H4(157),G1H4(142) &
    ,G1H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(238),[G1H4(226),G1H4(166),G1H4(159),G1H4(144) &
    ,G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(233),[G1H4(221),G1H4(161),G1H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(228),[G1H4(169),G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(79),[G0H4(66),G0H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(258),[G1H4(246),G1H4(206),G1H4(199),G1H4(184) &
    ,G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(260),[G1H4(248),G1H4(208),G1H4(201),G1H4(186) &
    ,G1H4(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(262),[G1H4(250),G1H4(210),G1H4(203),G1H4(188) &
    ,G1H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(257),[G1H4(245),G1H4(205),G1H4(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(264),[G1H4(252),G1H4(213),G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(88),[G0H4(85),G0H4(76),G0H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G1H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(17),[G1H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(46),[G1H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(57),G1H16(58),G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(76),[G1H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(22),[G0H16(33),G0H16(4),G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(84),[G1H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(85),[G1H16(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(86),[G1H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(73),[G1H16(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(74),[G1H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(89),[G1H16(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(98),[G1H16(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(110),[G1H16(106),G1H16(102),G1H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(112),[G1H16(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(6),[G0H16(2),G0H16(11),G0H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(84),[G0H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(128),[G1H16(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(127),[G1H16(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(130),[G1H16(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(133),[G1H16(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(132),[G1H16(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(135),[G1H16(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(140),[G1H16(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(144),[G1H16(143),G1H16(142),G1H16(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(146),[G1H16(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(3),[G0H16(17),G0H16(14),G0H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(154),[G1H16(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(155),[G1H16(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(156),[G1H16(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(157),[G1H16(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(158),[G1H16(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(159),[G1H16(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(162),[G1H16(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(166),[G1H16(165),G1H16(164),G1H16(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(168),[G1H16(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(38),[G0H16(37),G0H16(35),G0H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(176),[G1H16(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(177),[G1H16(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(178),[G1H16(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(179),[G1H16(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(180),[G1H16(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(181),[G1H16(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(184),[G1H16(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(188),[G1H16(187),G1H16(186),G1H16(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(190),[G1H16(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(43),[G0H16(42),G0H16(40),G0H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(198),[G1H16(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(199),[G1H16(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(200),[G1H16(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(201),[G1H16(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(202),[G1H16(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(203),[G1H16(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(206),[G1H16(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(210),[G1H16(209),G1H16(208),G1H16(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(212),[G1H16(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(48),[G0H16(47),G0H16(45),G0H16(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(96),[G0H4(95)])
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(47),58,wf4(:,1),5,G2tensor(335),m3h4x1(:,221),heltab2x4(:,:,373))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(121),58,wf4(:,1),5,G2tensor(182),m3h4x1(:,222),heltab2x4(:,:,374))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(289),53,wf4(:,2),10,G2tensor(302),m3h4x1(:,223),heltab2x4(:,:,375))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(292),53,wf4(:,2),10,G2tensor(185),m3h4x1(:,224),heltab2x4(:,:,376))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(2),wf4(:,1),wf4(:,2),G1tensor(379),m4h4x4x1(:,1),heltab3x16(:,:,1))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(12),wf4(:,1),wf4(:,2),G1tensor(409),m4h4x4x1(:,2),heltab3x16(:,:,2))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(265),54,wf4(:,4),9,G2tensor(305),m3h4x1(:,225),heltab2x4(:,:,377))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(268),54,wf4(:,4),9,G2tensor(224),m3h4x1(:,226),heltab2x4(:,:,378))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(241),57,wf4(:,5),6,G2tensor(350),m3h4x1(:,227),heltab2x4(:,:,379))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(244),57,wf4(:,5),6,G2tensor(223),m3h4x1(:,228),heltab2x4(:,:,380))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(14),wf4(:,4),wf4(:,5),G1tensor(439),m4h4x4x1(:,3),heltab3x16(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(22),wf4(:,4),wf4(:,5),G1tensor(469),m4h4x4x1(:,4),heltab3x16(:,:,4))
  call Hloop_QS_A(ntryL,G1H16(18),wf16(:,1),G1H1(1),ngH,m3h16x1(:,1),heltab2x16(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(353),n2h1(500))
  call Hloop_QS_A(ntryL,G1H16(47),wf16(:,1),G1H1(1),ngH,m3h16x1(:,2),heltab2x16(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(219),n2h1(501))
  call Hloop_QS_A(ntryL,G1H16(50),wf16(:,1),G1H1(1),ngH,m3h16x1(:,3),heltab2x16(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(314),n2h1(502))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H16(1),wf16(:,1),G1tensor(499),m3h16x1(:,4),heltab2x16(:,:,222))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H16(56),wf16(:,1),G1tensor(529),m3h16x1(:,5),heltab2x16(:,:,223))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H16(8),wf16(:,1),G1tensor(559),m3h16x1(:,6),heltab2x16(:,:,224))
  call Hcheck_last_VT_S(ntryL,l_switch,G0H16(12),48,wf16(:,1),15,G1tensor(589),m3h16x1(:,7),heltab2x16(:,:,225))
  call Hloop_QZ_A(ntryL,G1H4(283),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,229),heltab2x4(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(218),n2h1(503))
  call Hloop_QZ_A(ntryL,G1H4(285),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,230),heltab2x4(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(317),n2h1(504))
  call Hloop_QZ_A(ntryL,G1H4(287),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,231),heltab2x4(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(61),n2h1(505))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(291),53,wf4(:,2),10,G2tensor(214),m3h4x1(:,232),heltab2x4(:,:,384))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(22),wf4(:,2),G1tensor(619),m3h4x1(:,233),heltab2x4(:,:,385))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,234),heltab2x4(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(2),n2h1(506))
  call Hloop_QZ_A(ntryL,G1H4(120),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,235),heltab2x4(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(163),n2h1(507))
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,236),heltab2x4(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(127),n2h1(508))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(23),58,wf4(:,1),5,G2tensor(6),m3h4x1(:,237),heltab2x4(:,:,389))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(27),wf4(:,1),G1tensor(52),m3h4x1(:,238),heltab2x4(:,:,390))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(27),wf8(:,3),G1tensor(392),m3h8x1(:,47),heltab2x8(:,:,295))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(1),wf8(:,3),G1tensor(218),ngZu,m3h8x1(:,48),heltab2x8(:,:,296))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(29),wf8(:,3),G1tensor(234),m3h8x1(:,49),heltab2x8(:,:,297))
  call Hloop_QZ_A(ntryL,G1H4(282),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,239),heltab2x4(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(166),n2h1(509))
  call Hloop_QZ_A(ntryL,G1H4(284),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,240),heltab2x4(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(510))
  call Hloop_QZ_A(ntryL,G1H4(286),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,241),heltab2x4(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(511))
  call Hloop_QZ_A(ntryL,G1H4(281),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,242),heltab2x4(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(222),n2h1(512))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(276),53,wf4(:,2),10,G2tensor(213),m3h4x1(:,243),heltab2x4(:,:,395))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(91),wf4(:,2),G0tensor(1194),m3h4x1(:,244),heltab2x4(:,:,396))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(30),wf8(:,6),G1tensor(3),m3h8x1(:,50),heltab2x8(:,:,298))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(32),wf8(:,6),G1tensor(6),ngZu,m3h8x1(:,51),heltab2x8(:,:,299))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(33),wf8(:,6),G1tensor(308),m3h8x1(:,52),heltab2x8(:,:,300))
  call Hloop_QZ_A(ntryL,G1H4(64),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,245),heltab2x4(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(513))
  call Hloop_QZ_A(ntryL,G1H4(32),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,246),heltab2x4(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(172),n2h1(514))
  call Hloop_QZ_A(ntryL,G1H4(51),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,247),heltab2x4(:,:,399))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(515))
  call Hloop_QZ_A(ntryL,G1H4(76),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,248),heltab2x4(:,:,400))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(516))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(117),58,wf4(:,1),5,G2tensor(57),m3h4x1(:,249),heltab2x4(:,:,401))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(48),wf4(:,1),G0tensor(1189),m3h4x1(:,250),heltab2x4(:,:,402))
  call Hloop_QZ_A(ntryL,G1H16(51),wf16(:,3),G1H1(1),ngZl,m3h16x1(:,8),heltab2x16(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(217),n2h1(517))
  call Hloop_QZ_A(ntryL,G1H16(55),wf16(:,3),G1H1(1),ngZl,m3h16x1(:,9),heltab2x16(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nML,G2tensor(65),n2h1(518))
  call Hloop_QZ_A(ntryL,G1H16(59),wf16(:,3),G1H1(1),ngZu,m3h16x1(:,10),heltab2x16(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(519))


! end do

end subroutine vamp_1

end module ol_vamp_1_ppllll_ew_nenenexnexuux_1_/**/REALKIND
