
module ol_vamp_1_ppllll_ew_eexmmxuux_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_ew_eexmmxuux_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_ew_eexmmxuux_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_ew_eexmmxuux_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_ew_eexmmxuux_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllll_ew_eexmmxuux_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_eexmmxuux_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,4,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,4,1,2,16],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZu,m3h2x32(:,2),heltab2x64(:,:,2))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,8,4,1,2,16],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,4),heltab2x64(:,:,4))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,4,1,2,16],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(5),ngZu,m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,8,4,1,2,16],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZu,m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,4,1,2,16],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,8,4,1,2,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZu,m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,2,1,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,9),heltab2x64(:,:,9))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,2,1,4,8,16],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,4,8,16],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(11),ngZu,m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,4,8,16],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,2,1,4,8,16],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZu,m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,2,1,4,8,16],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,2,1,4,8,16],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZu,m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,2,1,4,8,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(16),ngZu,m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,4,8,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,17),heltab2x64(:,:,17))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,4,8,1,2,16],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZu,m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,4,8,1,2,16],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,4,8,1,2,16],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,4,8,1,2,16],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(21),ngZu,m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,4,8,1,2,16],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(22),ngZu,m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,4,8,1,2,16],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,4,8,1,2,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(24),ngZu,m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,2,1,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,2,1,8,4,16],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,2,1,8,4,16],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(27),ngZu,m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,2,1,8,4,16],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,2,1,8,4,16],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(29),ngZu,m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,2,1,8,4,16],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,30),heltab2x64(:,:,30))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,2,1,8,4,16],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(31),ngZu,m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,2,1,8,4,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(32),ngZu,m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,2,1,8,4,16],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,33),heltab2x64(:,:,33))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,8,4,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,8,4,2,1,16],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(35),ngZu,m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,8,4,2,1,16],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,8,4,2,1,16],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,8,4,2,1,16],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(38),ngZu,m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,8,4,2,1,16],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(39),ngZu,m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,8,4,2,1,16],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,8,4,2,1,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(41),ngZu,m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,8,4,2,1,16],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,8,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,8,2,1,16],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(44),ngZu,m3h2x32(:,44),heltab2x64(:,:,44))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,4,8,2,1,16],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,45),heltab2x64(:,:,45))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,4,8,2,1,16],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,4,8,2,1,16],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(47),ngZu,m3h2x32(:,47),heltab2x64(:,:,47))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,4,8,2,1,16],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(48),ngZu,m3h2x32(:,48),heltab2x64(:,:,48))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,4,8,2,1,16],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,49),heltab2x64(:,:,49))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,4,8,2,1,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(50),ngZu,m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,1,2,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,1,2,4,8,16],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,1,2,4,8,16],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,53),heltab2x64(:,:,53))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,1,2,4,8,16],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(54),ngZu,m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,1,2,4,8,16],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,55),heltab2x64(:,:,55))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,1,2,4,8,16],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(56),ngZu,m3h2x32(:,56),heltab2x64(:,:,56))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,1,2,4,8,16],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(57),ngZu,m3h2x32(:,57),heltab2x64(:,:,57))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,1,2,4,8,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(58),ngZu,m3h2x32(:,58),heltab2x64(:,:,58))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,1,2,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,1,2,8,4,16],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,1,2,8,4,16],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(61),m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,1,2,8,4,16],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(62),ngZu,m3h2x32(:,62),heltab2x64(:,:,62))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,1,2,8,4,16],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(63),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,1,2,8,4,16],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(64),ngZu,m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,1,2,8,4,16],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(65),ngZu,m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,1,2,8,4,16],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(66),ngZu,m3h2x32(:,66),heltab2x64(:,:,66))
  call Hloop_VA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(1),n2h16(1))
  call Hloop_ZA_Q(ntryL,G0H32(2),ex4(:),G0H16(1),ngZl,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(2),n2h16(2))
  call Hloop_VA_Q(ntryL,G0H32(3),ex4(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(3),n2h16(3))
  call Hloop_VA_Q(ntryL,G0H32(4),ex4(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(4),n2h16(4))
  call Hloop_ZA_Q(ntryL,G0H32(5),ex4(:),G0H16(1),ngZl,m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(5),n2h16(5))
  call Hloop_ZA_Q(ntryL,G0H32(6),ex4(:),G0H16(1),ngZl,m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(6),n2h16(6))
  call Hloop_VA_Q(ntryL,G0H32(7),ex4(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(7),n2h16(7))
  call Hloop_ZA_Q(ntryL,G0H32(8),ex4(:),G0H16(1),ngZl,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(8),n2h16(8))
  call Hloop_VA_Q(ntryL,G0H32(9),ex2(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(9),n2h16(9))
  call Hloop_VA_Q(ntryL,G0H32(10),ex2(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(10),n2h16(10))
  call Hloop_ZA_Q(ntryL,G0H32(11),ex2(:),G0H16(1),ngZl,m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(11),n2h16(11))
  call Hloop_VA_Q(ntryL,G0H32(12),ex2(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(12),n2h16(12))
  call Hloop_ZA_Q(ntryL,G0H32(13),ex2(:),G0H16(1),ngZl,m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(13),n2h16(13))
  call Hloop_VA_Q(ntryL,G0H32(14),ex2(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(14),n2h16(14))
  call Hloop_ZA_Q(ntryL,G0H32(15),ex2(:),G0H16(1),ngZl,m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(15),n2h16(15))
  call Hloop_ZA_Q(ntryL,G0H32(16),ex2(:),G0H16(1),ngZl,m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(16),n2h16(16))
  call Hloop_VQ_A(ntryL,G0H32(17),ex3(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(17),n2h16(17))
  call Hloop_ZQ_A(ntryL,G0H32(18),ex3(:),G0H16(1),ngZl,m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(18),n2h16(18))
  call Hloop_VQ_A(ntryL,G0H32(19),ex3(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(19),n2h16(19))
  call Hloop_VQ_A(ntryL,G0H32(20),ex3(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(20),n2h16(20))
  call Hloop_ZQ_A(ntryL,G0H32(21),ex3(:),G0H16(1),ngZl,m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(21),n2h16(21))
  call Hloop_ZQ_A(ntryL,G0H32(22),ex3(:),G0H16(1),ngZl,m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(22),n2h16(22))
  call Hloop_VQ_A(ntryL,G0H32(23),ex3(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(23),n2h16(23))
  call Hloop_ZQ_A(ntryL,G0H32(24),ex3(:),G0H16(1),ngZl,m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(24),n2h16(24))
  call Hloop_VA_Q(ntryL,G0H32(25),ex2(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(25),n2h16(25))
  call Hloop_VA_Q(ntryL,G0H32(26),ex2(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(26),n2h16(26))
  call Hloop_ZA_Q(ntryL,G0H32(27),ex2(:),G0H16(1),ngZl,m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(27),n2h16(27))
  call Hloop_VA_Q(ntryL,G0H32(28),ex2(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(28),n2h16(28))
  call Hloop_ZA_Q(ntryL,G0H32(29),ex2(:),G0H16(1),ngZl,m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(29),n2h16(29))
  call Hloop_VA_Q(ntryL,G0H32(30),ex2(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(30),n2h16(30))
  call Hloop_ZA_Q(ntryL,G0H32(31),ex2(:),G0H16(1),ngZl,m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(31),n2h16(31))
  call Hloop_ZA_Q(ntryL,G0H32(32),ex2(:),G0H16(1),ngZl,m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(32),n2h16(32))
  call Hloop_WA_Q(ntryL,G0H32(33),ex2(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(33),n2h16(33))
  call Hloop_VA_Q(ntryL,G0H32(34),ex4(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(34),n2h16(34))
  call Hloop_ZA_Q(ntryL,G0H32(35),ex4(:),G0H16(1),ngZl,m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(35),n2h16(35))
  call Hloop_VA_Q(ntryL,G0H32(36),ex4(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(36),n2h16(36))
  call Hloop_VA_Q(ntryL,G0H32(37),ex4(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(37),n2h16(37))
  call Hloop_ZA_Q(ntryL,G0H32(38),ex4(:),G0H16(1),ngZl,m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(38),n2h16(38))
  call Hloop_ZA_Q(ntryL,G0H32(39),ex4(:),G0H16(1),ngZl,m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(39),n2h16(39))
  call Hloop_VA_Q(ntryL,G0H32(40),ex4(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(40),n2h16(40))
  call Hloop_ZA_Q(ntryL,G0H32(41),ex4(:),G0H16(1),ngZl,m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(41),n2h16(41))
  call Hloop_WA_Q(ntryL,G0H32(42),ex4(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(42),n2h16(42))
  call Hloop_VQ_A(ntryL,G0H32(43),ex3(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(43),n2h16(43))
  call Hloop_ZQ_A(ntryL,G0H32(44),ex3(:),G0H16(1),ngZl,m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(44),n2h16(44))
  call Hloop_VQ_A(ntryL,G0H32(45),ex3(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(45),n2h16(45))
  call Hloop_VQ_A(ntryL,G0H32(46),ex3(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(46),n2h16(46))
  call Hloop_ZQ_A(ntryL,G0H32(47),ex3(:),G0H16(1),ngZl,m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(47),n2h16(47))
  call Hloop_ZQ_A(ntryL,G0H32(48),ex3(:),G0H16(1),ngZl,m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(48),n2h16(48))
  call Hloop_VQ_A(ntryL,G0H32(49),ex3(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(49),n2h16(49))
  call Hloop_ZQ_A(ntryL,G0H32(50),ex3(:),G0H16(1),ngZl,m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(50),n2h16(50))
  call Hloop_VQ_A(ntryL,G0H32(51),ex1(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(51),n2h16(51))
  call Hloop_VQ_A(ntryL,G0H32(52),ex1(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(52),n2h16(52))
  call Hloop_VQ_A(ntryL,G0H32(53),ex1(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(53),n2h16(53))
  call Hloop_ZQ_A(ntryL,G0H32(54),ex1(:),G0H16(1),ngZl,m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(54),n2h16(54))
  call Hloop_VQ_A(ntryL,G0H32(55),ex1(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(55),n2h16(55))
  call Hloop_ZQ_A(ntryL,G0H32(56),ex1(:),G0H16(1),ngZl,m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(56),n2h16(56))
  call Hloop_ZQ_A(ntryL,G0H32(57),ex1(:),G0H16(1),ngZl,m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(57),n2h16(57))
  call Hloop_ZQ_A(ntryL,G0H32(58),ex1(:),G0H16(1),ngZl,m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(58),n2h16(58))
  call Hloop_VQ_A(ntryL,G0H32(59),ex1(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(59),n2h16(59))
  call Hloop_VQ_A(ntryL,G0H32(60),ex1(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(60),n2h16(60))
  call Hloop_VQ_A(ntryL,G0H32(61),ex1(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(61),n2h16(61))
  call Hloop_ZQ_A(ntryL,G0H32(62),ex1(:),G0H16(1),ngZl,m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(62),n2h16(62))
  call Hloop_VQ_A(ntryL,G0H32(63),ex1(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(63),n2h16(63))
  call Hloop_ZQ_A(ntryL,G0H32(64),ex1(:),G0H16(1),ngZl,m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(64),n2h16(64))
  call Hloop_ZQ_A(ntryL,G0H32(65),ex1(:),G0H16(1),ngZl,m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(65),n2h16(65))
  call Hloop_ZQ_A(ntryL,G0H32(66),ex1(:),G0H16(1),ngZl,m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(66),n2h16(66))
  call Hloop_AQ_V(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G1H16(2),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G1H16(3),ex3(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex3(:),G1H8(4),ngZl,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_V(ntryL,G1H16(5),ex3(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_Z(ntryL,G1H16(6),ex3(:),G1H8(6),ngZl,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H16(7),ex3(:),G1H8(7),ngZl,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H16(8),ex3(:),G1H8(8),ngZl,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_V(ntryL,G1H16(9),ex1(:),G1H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_V(ntryL,G1H16(10),ex1(:),G1H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_V(ntryL,G1H16(11),ex1(:),G1H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H16(12),ex1(:),G1H8(12),ngZl,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(13),ex1(:),G1H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex1(:),G1H8(14),ngZl,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_Z(ntryL,G1H16(15),ex1(:),G1H8(15),ngZl,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H16(16),ex1(:),G1H8(16),ngZl,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_QA_V(ntryL,G1H16(17),ex4(:),G1H8(17),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_QA_V(ntryL,G1H16(18),ex4(:),G1H8(18),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_QA_V(ntryL,G1H16(19),ex4(:),G1H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_QA_Z(ntryL,G1H16(20),ex4(:),G1H8(20),ngZl,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_QA_V(ntryL,G1H16(21),ex4(:),G1H8(21),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_QA_Z(ntryL,G1H16(22),ex4(:),G1H8(22),ngZl,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_QA_Z(ntryL,G1H16(23),ex4(:),G1H8(23),ngZl,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_QA_Z(ntryL,G1H16(24),ex4(:),G1H8(24),ngZl,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AQ_V(ntryL,G1H16(25),ex1(:),G1H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AQ_V(ntryL,G1H16(26),ex1(:),G1H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_AQ_V(ntryL,G1H16(27),ex1(:),G1H8(27),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_AQ_Z(ntryL,G1H16(28),ex1(:),G1H8(28),ngZl,m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_AQ_V(ntryL,G1H16(29),ex1(:),G1H8(29),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_AQ_Z(ntryL,G1H16(30),ex1(:),G1H8(30),ngZl,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_AQ_Z(ntryL,G1H16(31),ex1(:),G1H8(31),ngZl,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H16(32),ex1(:),G1H8(32),ngZl,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_AQ_W(ntryL,G1H16(33),ex1(:),G1H8(33),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_AQ_V(ntryL,G1H16(34),ex3(:),G1H8(34),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_AQ_V(ntryL,G1H16(35),ex3(:),G1H8(35),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_AQ_Z(ntryL,G1H16(36),ex3(:),G1H8(36),ngZl,m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_AQ_V(ntryL,G1H16(37),ex3(:),G1H8(37),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_AQ_Z(ntryL,G1H16(38),ex3(:),G1H8(38),ngZl,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_AQ_V(ntryL,G1H16(39),ex3(:),G1H8(39),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_AQ_Z(ntryL,G1H16(40),ex3(:),G1H8(40),ngZl,m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_AQ_Z(ntryL,G1H16(41),ex3(:),G1H8(41),ngZl,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_AQ_W(ntryL,G1H16(42),ex3(:),G1H8(42),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_QA_V(ntryL,G1H16(43),ex4(:),G1H8(43),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_QA_V(ntryL,G1H16(44),ex4(:),G1H8(44),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_QA_Z(ntryL,G1H16(45),ex4(:),G1H8(45),ngZl,m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_QA_V(ntryL,G1H16(46),ex4(:),G1H8(46),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_QA_Z(ntryL,G1H16(47),ex4(:),G1H8(47),ngZl,m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_QA_V(ntryL,G1H16(48),ex4(:),G1H8(48),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_QA_Z(ntryL,G1H16(49),ex4(:),G1H8(49),ngZl,m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_QA_Z(ntryL,G1H16(50),ex4(:),G1H8(50),ngZl,m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_QA_V(ntryL,G1H16(51),ex2(:),G1H8(51),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_QA_V(ntryL,G1H16(52),ex2(:),G1H8(52),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_QA_Z(ntryL,G1H16(53),ex2(:),G1H8(53),ngZl,m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_QA_V(ntryL,G1H16(54),ex2(:),G1H8(54),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_QA_Z(ntryL,G1H16(55),ex2(:),G1H8(55),ngZl,m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_QA_V(ntryL,G1H16(56),ex2(:),G1H8(56),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_QA_Z(ntryL,G1H16(57),ex2(:),G1H8(57),ngZl,m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_QA_Z(ntryL,G1H16(58),ex2(:),G1H8(58),ngZl,m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_QA_V(ntryL,G1H16(59),ex2(:),G1H8(59),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_QA_V(ntryL,G1H16(60),ex2(:),G1H8(60),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_QA_Z(ntryL,G1H16(61),ex2(:),G1H8(61),ngZl,m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_QA_V(ntryL,G1H16(62),ex2(:),G1H8(62),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_QA_Z(ntryL,G1H16(63),ex2(:),G1H8(63),ngZl,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_QA_V(ntryL,G1H16(64),ex2(:),G1H8(64),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_QA_Z(ntryL,G1H16(65),ex2(:),G1H8(65),ngZl,m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_QA_Z(ntryL,G1H16(66),ex2(:),G1H8(66),ngZl,m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(1),n2h4(1))
  call Hloop_VQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(2),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(3),n2h4(3))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngZl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(4),n2h4(4))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(5),n2h4(5))
  call Hloop_ZQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngZl,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(6),n2h4(6))
  call Hloop_ZQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngZl,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(7),n2h4(7))
  call Hloop_ZQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),ngZl,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(8),n2h4(8))
  call Hloop_VQ_A(ntryL,G1H8(9),ex3(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(9),n2h4(9))
  call Hloop_VQ_A(ntryL,G1H8(10),ex3(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(10),n2h4(10))
  call Hloop_VQ_A(ntryL,G1H8(11),ex3(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(11),n2h4(11))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex3(:),G1H4(1),ngZl,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(12),n2h4(12))
  call Hloop_VQ_A(ntryL,G1H8(13),ex3(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(13),n2h4(13))
  call Hloop_ZQ_A(ntryL,G1H8(14),ex3(:),G1H4(1),ngZl,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(14),n2h4(14))
  call Hloop_ZQ_A(ntryL,G1H8(15),ex3(:),G1H4(1),ngZl,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(15),n2h4(15))
  call Hloop_ZQ_A(ntryL,G1H8(16),ex3(:),G1H4(1),ngZl,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(16),n2h4(16))
  call Hloop_VQ_A(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(17),n2h4(17))
  call Hloop_VQ_A(ntryL,G1H8(18),ex1(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(18),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(19),ex1(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(19),n2h4(19))
  call Hloop_ZQ_A(ntryL,G1H8(20),ex1(:),G1H4(1),ngZl,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(20),n2h4(20))
  call Hloop_VQ_A(ntryL,G1H8(21),ex1(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(21),n2h4(21))
  call Hloop_ZQ_A(ntryL,G1H8(22),ex1(:),G1H4(1),ngZl,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(22),n2h4(22))
  call Hloop_ZQ_A(ntryL,G1H8(23),ex1(:),G1H4(1),ngZl,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(23),n2h4(23))
  call Hloop_ZQ_A(ntryL,G1H8(24),ex1(:),G1H4(1),ngZl,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(24),n2h4(24))
  call Hloop_VA_Q(ntryL,G1H8(25),ex4(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(25),n2h4(25))
  call Hloop_VA_Q(ntryL,G1H8(26),ex4(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(26),n2h4(26))
  call Hloop_VA_Q(ntryL,G1H8(27),ex4(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(27),n2h4(27))
  call Hloop_ZA_Q(ntryL,G1H8(28),ex4(:),G1H4(1),ngZl,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(28),n2h4(28))
  call Hloop_VA_Q(ntryL,G1H8(29),ex4(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(29),n2h4(29))
  call Hloop_ZA_Q(ntryL,G1H8(30),ex4(:),G1H4(1),ngZl,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(30),n2h4(30))
  call Hloop_ZA_Q(ntryL,G1H8(31),ex4(:),G1H4(1),ngZl,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(31),n2h4(31))
  call Hloop_ZA_Q(ntryL,G1H8(32),ex4(:),G1H4(1),ngZl,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(32),n2h4(32))
  call Hloop_WA_Q(ntryL,G1H8(33),ex4(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(33),n2h4(33))
  call Hloop_VA_Q(ntryL,G1H8(34),ex2(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(34),n2h4(34))
  call Hloop_VA_Q(ntryL,G1H8(35),ex2(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(35),n2h4(35))
  call Hloop_ZA_Q(ntryL,G1H8(36),ex2(:),G1H4(1),ngZl,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(36),n2h4(36))
  call Hloop_VA_Q(ntryL,G1H8(37),ex2(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(37),n2h4(37))
  call Hloop_ZA_Q(ntryL,G1H8(38),ex2(:),G1H4(1),ngZl,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(38),n2h4(38))
  call Hloop_VA_Q(ntryL,G1H8(39),ex2(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(39),n2h4(39))
  call Hloop_ZA_Q(ntryL,G1H8(40),ex2(:),G1H4(1),ngZl,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(40),n2h4(40))
  call Hloop_ZA_Q(ntryL,G1H8(41),ex2(:),G1H4(1),ngZl,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(41),n2h4(41))
  call Hloop_WA_Q(ntryL,G1H8(42),ex2(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(42),n2h4(42))
  call Hloop_VA_Q(ntryL,G1H8(43),ex2(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(43),n2h4(43))
  call Hloop_VA_Q(ntryL,G1H8(44),ex2(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(44),n2h4(44))
  call Hloop_ZA_Q(ntryL,G1H8(45),ex2(:),G1H4(1),ngZl,m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(45),n2h4(45))
  call Hloop_VA_Q(ntryL,G1H8(46),ex2(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(46),n2h4(46))
  call Hloop_ZA_Q(ntryL,G1H8(47),ex2(:),G1H4(1),ngZl,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(47),n2h4(47))
  call Hloop_VA_Q(ntryL,G1H8(48),ex2(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(48),n2h4(48))
  call Hloop_ZA_Q(ntryL,G1H8(49),ex2(:),G1H4(1),ngZl,m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(49),n2h4(49))
  call Hloop_ZA_Q(ntryL,G1H8(50),ex2(:),G1H4(1),ngZl,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(50),n2h4(50))
  call Hloop_VQ_A(ntryL,G1H8(51),ex3(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(51),n2h4(51))
  call Hloop_VQ_A(ntryL,G1H8(52),ex3(:),G1H4(1),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(52),n2h4(52))
  call Hloop_ZQ_A(ntryL,G1H8(53),ex3(:),G1H4(1),ngZl,m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(53),n2h4(53))
  call Hloop_VQ_A(ntryL,G1H8(54),ex3(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(54),n2h4(54))
  call Hloop_ZQ_A(ntryL,G1H8(55),ex3(:),G1H4(1),ngZl,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(55),n2h4(55))
  call Hloop_VQ_A(ntryL,G1H8(56),ex3(:),G1H4(1),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(56),n2h4(56))
  call Hloop_ZQ_A(ntryL,G1H8(57),ex3(:),G1H4(1),ngZl,m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(57),n2h4(57))
  call Hloop_ZQ_A(ntryL,G1H8(58),ex3(:),G1H4(1),ngZl,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(58),n2h4(58))
  call Hloop_VA_Q(ntryL,G1H8(59),ex4(:),G1H4(1),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(59),n2h4(59))
  call Hloop_VA_Q(ntryL,G1H8(60),ex4(:),G1H4(1),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(60),n2h4(60))
  call Hloop_ZA_Q(ntryL,G1H8(61),ex4(:),G1H4(1),ngZl,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(61),n2h4(61))
  call Hloop_VA_Q(ntryL,G1H8(62),ex4(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(62),n2h4(62))
  call Hloop_ZA_Q(ntryL,G1H8(63),ex4(:),G1H4(1),ngZl,m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(63),n2h4(63))
  call Hloop_VA_Q(ntryL,G1H8(64),ex4(:),G1H4(1),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(64),n2h4(64))
  call Hloop_ZA_Q(ntryL,G1H8(65),ex4(:),G1H4(1),ngZl,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(65),n2h4(65))
  call Hloop_ZA_Q(ntryL,G1H8(66),ex4(:),G1H4(1),ngZl,m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(66),n2h4(66))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(2),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_Z(ntryL,G2H4(3),ex2(:),G2H2(3),ngZl,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(4),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_Z(ntryL,G2H4(5),ex2(:),G2H2(5),ngZl,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(6),ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_Z(ntryL,G2H4(7),ex2(:),G2H2(7),ngZl,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_Z(ntryL,G2H4(8),ex2(:),G2H2(8),ngZl,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(9),ex4(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_Z(ntryL,G2H4(10),ex4(:),G2H2(10),ngZl,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(11),ex4(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(12),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_Z(ntryL,G2H4(13),ex4(:),G2H2(13),ngZl,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_Z(ntryL,G2H4(14),ex4(:),G2H2(14),ngZl,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(15),ex4(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_Z(ntryL,G2H4(16),ex4(:),G2H2(16),ngZl,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(17),ex2(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(18),ex2(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_Z(ntryL,G2H4(19),ex2(:),G2H2(19),ngZl,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_V(ntryL,G2H4(20),ex2(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_Z(ntryL,G2H4(21),ex2(:),G2H2(21),ngZl,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_V(ntryL,G2H4(22),ex2(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_Z(ntryL,G2H4(23),ex2(:),G2H2(23),ngZl,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_Z(ntryL,G2H4(24),ex2(:),G2H2(24),ngZl,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_V(ntryL,G2H4(25),ex3(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_Z(ntryL,G2H4(26),ex3(:),G2H2(26),ngZl,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_V(ntryL,G2H4(27),ex3(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AQ_V(ntryL,G2H4(28),ex3(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AQ_Z(ntryL,G2H4(29),ex3(:),G2H2(29),ngZl,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_AQ_Z(ntryL,G2H4(30),ex3(:),G2H2(30),ngZl,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_AQ_V(ntryL,G2H4(31),ex3(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_AQ_Z(ntryL,G2H4(32),ex3(:),G2H2(32),ngZl,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_W(ntryL,G2H4(33),ex3(:),G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_V(ntryL,G2H4(34),ex1(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_V(ntryL,G2H4(35),ex1(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_V(ntryL,G2H4(36),ex1(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_Z(ntryL,G2H4(37),ex1(:),G2H2(37),ngZl,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_V(ntryL,G2H4(38),ex1(:),G2H2(38),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_Z(ntryL,G2H4(39),ex1(:),G2H2(39),ngZl,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_Z(ntryL,G2H4(40),ex1(:),G2H2(40),ngZl,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_AQ_Z(ntryL,G2H4(41),ex1(:),G2H2(41),ngZl,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_W(ntryL,G2H4(42),ex1(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AQ_V(ntryL,G2H4(43),ex1(:),G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_V(ntryL,G2H4(44),ex1(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AQ_V(ntryL,G2H4(45),ex1(:),G2H2(45),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_Z(ntryL,G2H4(46),ex1(:),G2H2(46),ngZl,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_AQ_V(ntryL,G2H4(47),ex1(:),G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AQ_Z(ntryL,G2H4(48),ex1(:),G2H2(48),ngZl,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_Z(ntryL,G2H4(49),ex1(:),G2H2(49),ngZl,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AQ_Z(ntryL,G2H4(50),ex1(:),G2H2(50),ngZl,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_QA_V(ntryL,G2H4(51),ex4(:),G2H2(51),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_QA_Z(ntryL,G2H4(52),ex4(:),G2H2(52),ngZl,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_QA_V(ntryL,G2H4(53),ex4(:),G2H2(53),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_QA_V(ntryL,G2H4(54),ex4(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QA_Z(ntryL,G2H4(55),ex4(:),G2H2(55),ngZl,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_QA_Z(ntryL,G2H4(56),ex4(:),G2H2(56),ngZl,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_QA_V(ntryL,G2H4(57),ex4(:),G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_QA_Z(ntryL,G2H4(58),ex4(:),G2H2(58),ngZl,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_AQ_V(ntryL,G2H4(59),ex3(:),G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AQ_Z(ntryL,G2H4(60),ex3(:),G2H2(60),ngZl,m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_AQ_V(ntryL,G2H4(61),ex3(:),G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_AQ_V(ntryL,G2H4(62),ex3(:),G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_AQ_Z(ntryL,G2H4(63),ex3(:),G2H2(63),ngZl,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_AQ_Z(ntryL,G2H4(64),ex3(:),G2H2(64),ngZl,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_AQ_V(ntryL,G2H4(65),ex3(:),G2H2(65),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_AQ_Z(ntryL,G2H4(66),ex3(:),G2H2(66),ngZl,m3h2x2(:,66),heltab2x4(:,:,66))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(1),mass5set(:,3),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(1),mass5set(:,2),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(1),mass5set(:,4),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(1),mass5set(:,3),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(1),mass5set(:,4),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(2),mass5set(:,1),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(2),mass5set(:,1),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(2),mass5set(:,2),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(2),mass5set(:,3),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(2),mass5set(:,2),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(2),mass5set(:,3),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(2),mass5set(:,4),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),16,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(2),mass5set(:,4),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),16,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(3),mass5set(:,1),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(3),mass5set(:,2),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),16,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(3),mass5set(:,1),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(3),mass5set(:,3),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(3),mass5set(:,2),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),16,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(3),mass5set(:,4),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),16,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(3),mass5set(:,3),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(3),mass5set(:,4),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),16,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(4),mass5set(:,1),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),16,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(4),mass5set(:,1),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(4),mass5set(:,2),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),16,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(4),mass5set(:,3),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),16,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(4),mass5set(:,2),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),16,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(4),mass5set(:,3),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),16,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(4),mass5set(:,4),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),16,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(4),mass5set(:,4),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),16,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(4),mass5set(:,5),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),16,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(5),mass5set(:,1),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),16,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(5),mass5set(:,2),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),16,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(5),mass5set(:,3),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),16,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(5),mass5set(:,1),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),16,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(5),mass5set(:,4),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),16,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(5),mass5set(:,2),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(230),16,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(5),mass5set(:,3),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(236),16,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(5),mass5set(:,4),  & 
G1H2(241),G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),2)
  call HG1shiftOLR(G1H2(242),16,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(5),mass5set(:,5),  & 
G1H2(247),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(248),16,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(6),mass5set(:,1),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(254),16,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(6),mass5set(:,2),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),2)
  call HG1shiftOLR(G1H2(260),16,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(6),mass5set(:,3),  & 
G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
  call HG1shiftOLR(G1H2(266),16,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(6),mass5set(:,1),  & 
G1H2(271),G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),2)
  call HG1shiftOLR(G1H2(272),16,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(6),mass5set(:,4),  & 
G1H2(277),G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(278),16,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(6),mass5set(:,2),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),2)
  call HG1shiftOLR(G1H2(284),16,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(6),mass5set(:,3),  & 
G1H2(289),G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),2)
  call HG1shiftOLR(G1H2(290),16,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(6),mass5set(:,4),  & 
G1H2(295),G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),2)
  call HG1shiftOLR(G1H2(296),16,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(7),mass5set(:,1),  & 
G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),2)
  call HG1shiftOLR(G1H2(302),16,2)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(7),mass5set(:,1),  & 
G1H2(307),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),16,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(7),mass5set(:,3),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),G1H2(318),2)
  call HG1shiftOLR(G1H2(314),16,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(7),mass5set(:,2),  & 
G1H2(319),G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),2)
  call HG1shiftOLR(G1H2(320),16,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(7),mass5set(:,3),  & 
G1H2(325),G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),2)
  call HG1shiftOLR(G1H2(326),16,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(7),mass5set(:,2),  & 
G1H2(331),G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),2)
  call HG1shiftOLR(G1H2(332),16,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(7),mass5set(:,4),  & 
G1H2(337),G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(338),16,2)
  call Hotf_5pt_reduction(G2H2(58),RedSet_5(7),mass5set(:,4),  & 
G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),G1H2(348),2)
  call HG1shiftOLR(G1H2(344),16,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(8),mass5set(:,1),  & 
G1H2(349),G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),2)
  call HG1shiftOLR(G1H2(350),16,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(8),mass5set(:,1),  & 
G1H2(355),G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),2)
  call HG1shiftOLR(G1H2(356),16,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(8),mass5set(:,3),  & 
G1H2(361),G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),2)
  call HG1shiftOLR(G1H2(362),16,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(8),mass5set(:,2),  & 
G1H2(367),G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(368),16,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(8),mass5set(:,3),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),G1H2(378),2)
  call HG1shiftOLR(G1H2(374),16,2)
  call Hotf_5pt_reduction(G2H2(64),RedSet_5(8),mass5set(:,2),  & 
G1H2(379),G1H2(380),G1H2(381),G1H2(382),G1H2(383),G1H2(384),2)
  call HG1shiftOLR(G1H2(380),16,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(8),mass5set(:,4),  & 
G1H2(385),G1H2(386),G1H2(387),G1H2(388),G1H2(389),G1H2(390),2)
  call HG1shiftOLR(G1H2(386),16,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(8),mass5set(:,4),  & 
G1H2(391),G1H2(392),G1H2(393),G1H2(394),G1H2(395),G1H2(396),2)
  call HG1shiftOLR(G1H2(392),16,2)
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(4),n2h1(4))
  call Hloop_ZQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),ngZu,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),ngZu,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(6),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(8),n2h1(8))
  call Hloop_ZQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),ngZu,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(9))
  call Hloop_ZQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),ngZu,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(12),n2h1(12))
  call Hloop_ZQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),ngZu,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_ZQ_A(ntryL,G1H2(38),ex5(:),G1H1(1),ngZu,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(14),n2h1(14))
  call Hloop_ZQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),ngZu,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(15))
  call Hloop_ZQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),ngZu,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(16),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(18),n2h1(18))
  call Hloop_ZQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),ngZu,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(19))
  call Hloop_ZQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),ngZu,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(20),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(24))
  call Hloop_ZQ_A(ntryL,G1H2(73),ex5(:),G1H1(1),ngZu,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(25))
  call Hloop_ZQ_A(ntryL,G1H2(74),ex5(:),G1H1(1),ngZu,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(26))
  call Hloop_ZQ_A(ntryL,G1H2(79),ex5(:),G1H1(1),ngZu,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(27))
  call Hloop_ZQ_A(ntryL,G1H2(80),ex5(:),G1H1(1),ngZu,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(86),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(30))
  call Hloop_ZQ_A(ntryL,G1H2(91),ex5(:),G1H1(1),ngZu,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(31))
  call Hloop_ZQ_A(ntryL,G1H2(92),ex5(:),G1H1(1),ngZu,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(32),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(97),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(98),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(34),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(103),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(104),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(36),n2h1(36))
  call Hloop_ZQ_A(ntryL,G1H2(109),ex5(:),G1H1(1),ngZu,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(37))
  call Hloop_ZQ_A(ntryL,G1H2(110),ex5(:),G1H1(1),ngZu,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(38),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(115),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(39))
  call Hloop_VQ_A(ntryL,G1H2(116),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(40),n2h1(40))
  call Hloop_ZQ_A(ntryL,G1H2(121),ex5(:),G1H1(1),ngZu,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(41))
  call Hloop_ZQ_A(ntryL,G1H2(122),ex5(:),G1H1(1),ngZu,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(42),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(127),ex5(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(128),ex5(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(44),n2h1(44))
  call Hloop_ZQ_A(ntryL,G1H2(133),ex5(:),G1H1(1),ngZu,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(45))
  call Hloop_ZQ_A(ntryL,G1H2(134),ex5(:),G1H1(1),ngZu,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(46),n2h1(46))
  call Hloop_ZQ_A(ntryL,G1H2(139),ex5(:),G1H1(1),ngZu,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(47))
  call Hloop_ZQ_A(ntryL,G1H2(140),ex5(:),G1H1(1),ngZu,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(48),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(145),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(49))
  call Hloop_VQ_A(ntryL,G1H2(146),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(50),n2h1(50))
  call Hloop_ZQ_A(ntryL,G1H2(151),ex5(:),G1H1(1),ngZu,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(51))
  call Hloop_ZQ_A(ntryL,G1H2(152),ex5(:),G1H1(1),ngZu,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(52),n2h1(52))
  call Hloop_VQ_A(ntryL,G1H2(157),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(53))
  call Hloop_VQ_A(ntryL,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(54),n2h1(54))
  call Hloop_VQ_A(ntryL,G1H2(163),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(55))
  call Hloop_VQ_A(ntryL,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(56),n2h1(56))
  call Hloop_ZQ_A(ntryL,G1H2(169),ex5(:),G1H1(1),ngZu,m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(57))
  call Hloop_ZQ_A(ntryL,G1H2(170),ex5(:),G1H1(1),ngZu,m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(58),n2h1(58))
  call Hloop_ZQ_A(ntryL,G1H2(175),ex5(:),G1H1(1),ngZu,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(59))
  call Hloop_ZQ_A(ntryL,G1H2(176),ex5(:),G1H1(1),ngZu,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(60),n2h1(60))
  call Hloop_VQ_A(ntryL,G1H2(181),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(61))
  call Hloop_VQ_A(ntryL,G1H2(182),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(62),n2h1(62))
  call Hloop_ZQ_A(ntryL,G1H2(187),ex5(:),G1H1(1),ngZu,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(63))
  call Hloop_ZQ_A(ntryL,G1H2(188),ex5(:),G1H1(1),ngZu,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(64),n2h1(64))
  call Hloop_WQ_A(ntryL,G1H2(193),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(65))
  call Hloop_WQ_A(ntryL,G1H2(194),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(66),n2h1(66))
  call Hloop_VQ_A(ntryL,G1H2(199),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(67))
  call Hloop_VQ_A(ntryL,G1H2(200),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(68),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(205),ex5(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(206),ex5(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(70),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H2(211),ex5(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(71))
  call Hloop_VQ_A(ntryL,G1H2(212),ex5(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(72),n2h1(72))
  call Hloop_ZQ_A(ntryL,G1H2(217),ex5(:),G1H1(1),ngZu,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(73))
  call Hloop_ZQ_A(ntryL,G1H2(218),ex5(:),G1H1(1),ngZu,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(74),n2h1(74))
  call Hloop_VQ_A(ntryL,G1H2(223),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(75))
  call Hloop_VQ_A(ntryL,G1H2(224),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(76),n2h1(76))
  call Hloop_ZQ_A(ntryL,G1H2(229),ex5(:),G1H1(1),ngZu,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(77))
  call Hloop_ZQ_A(ntryL,G1H2(230),ex5(:),G1H1(1),ngZu,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(78),n2h1(78))
  call Hloop_ZQ_A(ntryL,G1H2(235),ex5(:),G1H1(1),ngZu,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(79))
  call Hloop_ZQ_A(ntryL,G1H2(236),ex5(:),G1H1(1),ngZu,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(80),n2h1(80))
  call Hloop_ZQ_A(ntryL,G1H2(241),ex5(:),G1H1(1),ngZu,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(81))
  call Hloop_ZQ_A(ntryL,G1H2(242),ex5(:),G1H1(1),ngZu,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(82),n2h1(82))
  call Hloop_WQ_A(ntryL,G1H2(247),ex5(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(83))
  call Hloop_WQ_A(ntryL,G1H2(248),ex5(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(84),n2h1(84))
  call Hloop_VQ_A(ntryL,G1H2(253),ex5(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(85))
  call Hloop_VQ_A(ntryL,G1H2(254),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(86),n2h1(86))
  call Hloop_VQ_A(ntryL,G1H2(259),ex5(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(87))
  call Hloop_VQ_A(ntryL,G1H2(260),ex5(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(88),n2h1(88))
  call Hloop_VQ_A(ntryL,G1H2(265),ex5(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(89))
  call Hloop_VQ_A(ntryL,G1H2(266),ex5(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(90),n2h1(90))
  call Hloop_ZQ_A(ntryL,G1H2(271),ex5(:),G1H1(1),ngZu,m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(91))
  call Hloop_ZQ_A(ntryL,G1H2(272),ex5(:),G1H1(1),ngZu,m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(92),n2h1(92))
  call Hloop_VQ_A(ntryL,G1H2(277),ex5(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(93))
  call Hloop_VQ_A(ntryL,G1H2(278),ex5(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(94),n2h1(94))
  call Hloop_ZQ_A(ntryL,G1H2(283),ex5(:),G1H1(1),ngZu,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(95))
  call Hloop_ZQ_A(ntryL,G1H2(284),ex5(:),G1H1(1),ngZu,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(96),n2h1(96))
  call Hloop_ZQ_A(ntryL,G1H2(289),ex5(:),G1H1(1),ngZu,m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(97))
  call Hloop_ZQ_A(ntryL,G1H2(290),ex5(:),G1H1(1),ngZu,m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(98),n2h1(98))
  call Hloop_ZQ_A(ntryL,G1H2(295),ex5(:),G1H1(1),ngZu,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(99))
  call Hloop_ZQ_A(ntryL,G1H2(296),ex5(:),G1H1(1),ngZu,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(100),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H2(301),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(101))
  call Hloop_VQ_A(ntryL,G1H2(302),ex5(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(102),n2h1(102))
  call Hloop_ZQ_A(ntryL,G1H2(307),ex5(:),G1H1(1),ngZu,m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(103))
  call Hloop_ZQ_A(ntryL,G1H2(308),ex5(:),G1H1(1),ngZu,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(104),n2h1(104))
  call Hloop_VQ_A(ntryL,G1H2(313),ex5(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(105))
  call Hloop_VQ_A(ntryL,G1H2(314),ex5(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(106),n2h1(106))
  call Hloop_VQ_A(ntryL,G1H2(319),ex5(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(107))
  call Hloop_VQ_A(ntryL,G1H2(320),ex5(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(108),n2h1(108))
  call Hloop_ZQ_A(ntryL,G1H2(325),ex5(:),G1H1(1),ngZu,m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(109))
  call Hloop_ZQ_A(ntryL,G1H2(326),ex5(:),G1H1(1),ngZu,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(110),n2h1(110))
  call Hloop_ZQ_A(ntryL,G1H2(331),ex5(:),G1H1(1),ngZu,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(111))
  call Hloop_ZQ_A(ntryL,G1H2(332),ex5(:),G1H1(1),ngZu,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(112),n2h1(112))
  call Hloop_VQ_A(ntryL,G1H2(337),ex5(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(113))
  call Hloop_VQ_A(ntryL,G1H2(338),ex5(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(114),n2h1(114))
  call Hloop_ZQ_A(ntryL,G1H2(343),ex5(:),G1H1(1),ngZu,m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(115),n2h1(115))
  call Hloop_ZQ_A(ntryL,G1H2(344),ex5(:),G1H1(1),ngZu,m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(116),n2h1(116))
  call Hloop_VQ_A(ntryL,G1H2(349),ex5(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(117))
  call Hloop_VQ_A(ntryL,G1H2(350),ex5(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(118),n2h1(118))
  call Hloop_ZQ_A(ntryL,G1H2(355),ex5(:),G1H1(1),ngZu,m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(119),n2h1(119))
  call Hloop_ZQ_A(ntryL,G1H2(356),ex5(:),G1H1(1),ngZu,m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(120),n2h1(120))
  call Hloop_VQ_A(ntryL,G1H2(361),ex5(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(121))
  call Hloop_VQ_A(ntryL,G1H2(362),ex5(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(122),n2h1(122))
  call Hloop_VQ_A(ntryL,G1H2(367),ex5(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(123))
  call Hloop_VQ_A(ntryL,G1H2(368),ex5(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(124),n2h1(124))
  call Hloop_ZQ_A(ntryL,G1H2(373),ex5(:),G1H1(1),ngZu,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(125),n2h1(125))
  call Hloop_ZQ_A(ntryL,G1H2(374),ex5(:),G1H1(1),ngZu,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(126),n2h1(126))
  call Hloop_ZQ_A(ntryL,G1H2(379),ex5(:),G1H1(1),ngZu,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(127))
  call Hloop_ZQ_A(ntryL,G1H2(380),ex5(:),G1H1(1),ngZu,m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(128),n2h1(128))
  call Hloop_VQ_A(ntryL,G1H2(385),ex5(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(129))
  call Hloop_VQ_A(ntryL,G1H2(386),ex5(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(130),n2h1(130))
  call Hloop_ZQ_A(ntryL,G1H2(391),ex5(:),G1H1(1),ngZu,m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(131),n2h1(131))
  call Hloop_ZQ_A(ntryL,G1H2(392),ex5(:),G1H1(1),ngZu,m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(132),n2h1(132))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(1),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(1),mass5set(:,4),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(1),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(1),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(2),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(2),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(2),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(2),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(2),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(2),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(2),mass5set(:,4),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(2),mass5set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(3),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(3),mass5set(:,2),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(3),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(3),mass5set(:,3),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(3),mass5set(:,2),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(3),mass5set(:,4),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(3),mass5set(:,3),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(3),mass5set(:,4),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(4),mass5set(:,1),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(4),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(4),mass5set(:,2),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(4),mass5set(:,3),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(4),mass5set(:,2),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(4),mass5set(:,3),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(4),mass5set(:,4),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(4),mass5set(:,4),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(4),mass5set(:,5),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(5),mass5set(:,1),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(5),mass5set(:,2),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(5),mass5set(:,3),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(5),mass5set(:,1),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(5),mass5set(:,4),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(5),mass5set(:,2),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(5),mass5set(:,3),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(5),mass5set(:,4),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(5),mass5set(:,5),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(6),mass5set(:,1),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(6),mass5set(:,2),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),16)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(6),mass5set(:,3),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(6),mass5set(:,1),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(6),mass5set(:,4),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(6),mass5set(:,2),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(6),mass5set(:,3),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),16)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(6),mass5set(:,4),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),16)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(7),mass5set(:,1),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),16)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(7),mass5set(:,1),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),16)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(7),mass5set(:,3),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),16)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(7),mass5set(:,2),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),16)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(7),mass5set(:,3),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),16)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(7),mass5set(:,2),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),16)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(7),mass5set(:,4),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),16)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(7),mass5set(:,4),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),16)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(8),mass5set(:,1),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),16)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(8),mass5set(:,1),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),16)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(8),mass5set(:,3),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),16)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(8),mass5set(:,2),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),16)
  call Hotf_5pt_reduction_last(G2tensor(125),RedSet_5(8),mass5set(:,3),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(8),mass5set(:,2),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),16)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(8),mass5set(:,4),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),16)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(8),mass5set(:,4),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  call ol_merge_tensors(T1sum(45),[G1tensor(265)])
  call ol_merge_tensors(T1sum(46),[G1tensor(271)])
  call ol_merge_tensors(T1sum(47),[G1tensor(277)])
  call ol_merge_tensors(T1sum(48),[G1tensor(283)])
  call ol_merge_tensors(T1sum(49),[G1tensor(289)])
  call ol_merge_tensors(T1sum(50),[G1tensor(295)])
  call ol_merge_tensors(T1sum(51),[G1tensor(301)])
  call ol_merge_tensors(T1sum(52),[G1tensor(307)])
  call ol_merge_tensors(T1sum(53),[G1tensor(313)])
  call ol_merge_tensors(T1sum(54),[G1tensor(319)])
  call ol_merge_tensors(T1sum(55),[G1tensor(325)])
  call ol_merge_tensors(T1sum(56),[G1tensor(331)])
  call ol_merge_tensors(T1sum(57),[G1tensor(337)])
  call ol_merge_tensors(T1sum(58),[G1tensor(343)])
  call ol_merge_tensors(T1sum(59),[G1tensor(349)])
  call ol_merge_tensors(T1sum(60),[G1tensor(355)])
  call ol_merge_tensors(T1sum(61),[G1tensor(361)])
  call ol_merge_tensors(T1sum(62),[G1tensor(367)])
  call ol_merge_tensors(T1sum(63),[G1tensor(373)])
  call ol_merge_tensors(T1sum(64),[G1tensor(379)])
  call ol_merge_tensors(T1sum(65),[G1tensor(385)])
  call ol_merge_tensors(T1sum(66),[G1tensor(391)])
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,3,16,4,8],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),ngZu,m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,3,16,4,8],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,3,16,4,8],[0,0,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),ngZu,m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,3,16,4,8],[0,0,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,71),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,72),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,3,16,4,8],[0,0,0,0,nMZ],5,1,wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),ngZu,m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,3,16,4,8],[0,0,nMZ,0,0],5,1,wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,3,16,4,8],[0,0,nMZ,0,nMZ],5,1,wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZu,m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,3,16,4,8],[0,0,nMW,0,nMW],5,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,3,8,4,16],[nMW,nMW,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,77),heltab2x64(:,:,77))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,3,8,4,16],[nMW,nMW,0,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,78),heltab2x64(:,:,78))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,79),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,3,16,8,4],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,3,16,8,4],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),ngZu,m3h2x32(:,81),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,3,16,8,4],[0,0,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(16),ngZu,m3h2x32(:,82),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,83),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,3,16,8,4],[0,0,nMZ,0,0],5,1,wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,84),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(18),32,0,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,3,16,8,4],[0,0,0,0,nMZ],5,1,wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(19),ngZu,m3h2x32(:,85),heltab2x64(:,:,85))
  call Hloop_A_Q(ntryL,G0H32(19),32,0,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,3,16,8,4],[0,0,nMZ,0,nMZ],5,1,wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),ngZu,m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,8,4,3,16],[nMW,0,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,87),heltab2x64(:,:,87))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,8,4,3,16],[nMW,0,nMW,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,88),heltab2x64(:,:,88))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,89),heltab2x64(:,:,89))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,8,3,4,16],[nMZ,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(24),ngZu,m3h2x32(:,90),heltab2x64(:,:,90))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,8,3,4,16],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,91),heltab2x64(:,:,91))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,8,3,4,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(26),ngZu,m3h2x32(:,92),heltab2x64(:,:,92))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,93),heltab2x64(:,:,93))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,8,3,4,16],[nMZ,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(28),ngZu,m3h2x32(:,94),heltab2x64(:,:,94))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,8,3,4,16],[0,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,95),heltab2x64(:,:,95))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,8,3,4,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(30),ngZu,m3h2x32(:,96),heltab2x64(:,:,96))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,8,3,4,16],[nMW,0,0,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,97),heltab2x64(:,:,97))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,98),heltab2x64(:,:,98))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,4,3,8,16],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,99),heltab2x64(:,:,99))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,4,3,8,16],[nMZ,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(34),ngZu,m3h2x32(:,100),heltab2x64(:,:,100))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,4,3,8,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(35),ngZu,m3h2x32(:,101),heltab2x64(:,:,101))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,102),heltab2x64(:,:,102))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,4,3,8,16],[0,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,103),heltab2x64(:,:,103))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,4,3,8,16],[nMZ,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(38),ngZu,m3h2x32(:,104),heltab2x64(:,:,104))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,4,3,8,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(39),ngZu,m3h2x32(:,105),heltab2x64(:,:,105))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,106),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,2,1,16,12],[nMZ,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(41),ngZu,m3h2x32(:,107),heltab2x64(:,:,107))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,2,1,16,12],[0,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,108),heltab2x64(:,:,108))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,2,1,16,12],[nMZ,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(43),ngZu,m3h2x32(:,109),heltab2x64(:,:,109))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,2,1,16,12],[nMW,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,110),heltab2x64(:,:,110))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,111),heltab2x64(:,:,111))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,2,1,16,12],[nMZ,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(46),ngZu,m3h2x32(:,112),heltab2x64(:,:,112))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,2,1,16,12],[0,0,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,113),heltab2x64(:,:,113))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,2,1,16,12],[nMZ,0,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(48),ngZu,m3h2x32(:,114),heltab2x64(:,:,114))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,2,1,16,12],[nMW,0,nMW,0,0],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,115),heltab2x64(:,:,115))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,12,2,1,16],[nMW,nMW,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,116),heltab2x64(:,:,116))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,12,2,1,16],[nMW,nMW,0,nMW,0],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,117),heltab2x64(:,:,117))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,118),heltab2x64(:,:,118))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,1,2,16,12],[0,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,119),heltab2x64(:,:,119))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,1,2,16,12],[nMZ,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(54),ngZu,m3h2x32(:,120),heltab2x64(:,:,120))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,1,2,16,12],[nMZ,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(55),ngZu,m3h2x32(:,121),heltab2x64(:,:,121))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(56),m3h2x32(:,122),heltab2x64(:,:,122))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,1,2,16,12],[0,0,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(57),m3h2x32(:,123),heltab2x64(:,:,123))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,1,2,16,12],[nMZ,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(58),ngZu,m3h2x32(:,124),heltab2x64(:,:,124))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,1,2,16,12],[nMZ,0,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(59),ngZu,m3h2x32(:,125),heltab2x64(:,:,125))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,2,1,12,16],[nMW,0,nMW,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,126),heltab2x64(:,:,126))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,2,1,12,16],[nMW,0,nMW,nMW,0],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(61),m3h2x32(:,127),heltab2x64(:,:,127))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,2,12,1,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(62),m3h2x32(:,128),heltab2x64(:,:,128))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,2,12,1,16],[nMZ,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(63),ngZu,m3h2x32(:,129),heltab2x64(:,:,129))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,2,12,1,16],[0,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(64),m3h2x32(:,130),heltab2x64(:,:,130))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,2,12,1,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(65),ngZu,m3h2x32(:,131),heltab2x64(:,:,131))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,2,12,1,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(66),m3h2x32(:,132),heltab2x64(:,:,132))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,2,12,1,16],[nMZ,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZu,m3h2x32(:,133),heltab2x64(:,:,133))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,2,12,1,16],[0,0,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,134),heltab2x64(:,:,134))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,2,12,1,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZu,m3h2x32(:,135),heltab2x64(:,:,135))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,2,12,1,16],[nMW,0,0,nMW,0],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,136),heltab2x64(:,:,136))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,1,12,2,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,137),heltab2x64(:,:,137))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,1,12,2,16],[0,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,138),heltab2x64(:,:,138))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,1,12,2,16],[nMZ,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZu,m3h2x32(:,139),heltab2x64(:,:,139))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,1,12,2,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZu,m3h2x32(:,140),heltab2x64(:,:,140))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,1,12,2,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,141),heltab2x64(:,:,141))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,1,12,2,16],[0,0,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,142),heltab2x64(:,:,142))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,1,12,2,16],[nMZ,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZu,m3h2x32(:,143),heltab2x64(:,:,143))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,1,12,2,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(14),ngZu,m3h2x32(:,144),heltab2x64(:,:,144))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[48,4,1,2,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,145))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(1),n2h16(67))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[48,4,1,2,8],[0,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,146))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(2),n2h16(68))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[48,4,1,2,8],[0,nMZ,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,3),heltab2x64(:,:,147))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(3),n2h16(69))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[48,4,1,2,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,4),heltab2x64(:,:,148))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(4),n2h16(70))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[48,4,1,2,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,5),heltab2x64(:,:,149))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(5),n2h16(71))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[48,4,1,2,8],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,6),heltab2x64(:,:,150))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(6),n2h16(72))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[48,4,1,2,8],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,7),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(7),n2h16(73))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[48,4,1,2,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,8),heltab2x64(:,:,152))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(8),n2h16(74))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[48,4,2,1,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,9),heltab2x64(:,:,153))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(9),n2h16(75))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[48,4,2,1,8],[0,nMZ,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,10),heltab2x64(:,:,154))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(10),n2h16(76))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[48,4,2,1,8],[0,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,11),heltab2x64(:,:,155))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(11),n2h16(77))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[48,4,2,1,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,12),heltab2x64(:,:,156))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(12),n2h16(78))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[48,4,2,1,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,13),heltab2x64(:,:,157))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(13),n2h16(79))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[48,4,2,1,8],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,14),heltab2x64(:,:,158))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(14),n2h16(80))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[48,4,2,1,8],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,15),heltab2x64(:,:,159))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(15),n2h16(81))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[48,4,2,1,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,16),heltab2x64(:,:,160))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(16),n2h16(82))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[48,4,2,1,8],[0,nMW,0,nMW,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZn,m3h4x16(:,17),heltab2x64(:,:,161))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(17),n2h16(83))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[48,2,1,8,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(18),m3h4x16(:,18),heltab2x64(:,:,162))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[48,2,1,8,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(19),m3h4x16(:,19),heltab2x64(:,:,163))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[48,1,2,4,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(20),m3h4x16(:,20),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[48,1,2,4,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(21),m3h4x16(:,21),heltab2x64(:,:,165))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[48,1,4,8,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,22),heltab2x64(:,:,166))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(22),n2h16(84))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[48,1,4,8,2],[0,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,23),heltab2x64(:,:,167))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(23),n2h16(85))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[48,1,4,8,2],[0,nMZ,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,24),heltab2x64(:,:,168))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(24),n2h16(86))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[48,1,4,8,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,25),heltab2x64(:,:,169))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(25),n2h16(87))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[48,1,4,8,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,26),heltab2x64(:,:,170))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(26),n2h16(88))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[48,1,4,8,2],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,27),heltab2x64(:,:,171))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(27),n2h16(89))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[48,1,4,8,2],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,28),heltab2x64(:,:,172))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(28),n2h16(90))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[48,1,4,8,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,29),heltab2x64(:,:,173))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(29),n2h16(91))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[48,1,8,4,2],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,30),heltab2x64(:,:,174))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(30),n2h16(92))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[48,1,8,4,2],[0,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,31),heltab2x64(:,:,175))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(31),n2h16(93))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[48,1,8,4,2],[0,nMZ,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,32),heltab2x64(:,:,176))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(32),n2h16(94))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[48,1,8,4,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,33),heltab2x64(:,:,177))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(33),n2h16(95))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[48,1,8,4,2],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,34),heltab2x64(:,:,178))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(34),n2h16(96))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[48,1,8,4,2],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,35),heltab2x64(:,:,179))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(35),n2h16(97))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[48,1,8,4,2],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,36),heltab2x64(:,:,180))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(36),n2h16(98))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[48,1,8,4,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,37),heltab2x64(:,:,181))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(37),n2h16(99))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[48,1,8,4,2],[0,nMW,0,nMW,0],5,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZn,m3h4x16(:,38),heltab2x64(:,:,182))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(38),n2h16(100))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(21),[G1H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(26),[G1H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(33)])
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,1),G1H8(2),m3h4x8(:,2),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(2),35,0,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,1),G1H8(3),m3h4x8(:,3),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(3),35,0,G2H8(3),n2h8(3))
  call Hloop_AV_Q(ntryL,G1H32(4),wf4(:,1),G1H8(4),m3h4x8(:,4),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(4),35,0,G2H8(4),n2h8(4))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,1),G1H8(5),m3h4x8(:,5),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(5),35,0,G2H8(5),n2h8(5))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,4),G1H8(6),ngZu,m3h4x8(:,6),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(6),35,0,G2H8(6),n2h8(6))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,4),G1H8(7),ngZu,m3h4x8(:,7),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(7),35,0,G2H8(7),n2h8(7))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,4),G1H8(8),ngZu,m3h4x8(:,8),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(8),35,0,G2H8(8),n2h8(8))
  call Hloop_AZ_Q(ntryL,G1H32(9),wf4(:,4),G1H8(9),ngZu,m3h4x8(:,9),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(9),35,0,G2H8(9),n2h8(9))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,4),G1H8(10),ngZd,m3h4x8(:,10),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(10),35,0,G2H8(10),n2h8(10))
  call Hloop_UV_W(ntryL,G0H32(11),32,wf4(:,1),3,G1H8(11),m3h4x8(:,11),heltab2x32(:,:,77))
  call Hloop_UV_W(ntryL,G0H32(12),32,wf4(:,4),3,G1H8(12),m3h4x8(:,12),heltab2x32(:,:,78))
  call Hloop_AV_Q(ntryL,G1H32(11),wf4(:,1),G1H8(13),m3h4x8(:,13),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(13),35,0,G2H8(11),n2h8(11))
  call Hloop_AV_Q(ntryL,G1H32(12),wf4(:,1),G1H8(14),m3h4x8(:,14),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(14),35,0,G2H8(12),n2h8(12))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,1),G1H8(15),m3h4x8(:,15),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(15),35,0,G2H8(13),n2h8(13))
  call Hloop_AV_Q(ntryL,G1H32(14),wf4(:,1),G1H8(16),m3h4x8(:,16),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(16),35,0,G2H8(14),n2h8(14))
  call Hloop_AZ_Q(ntryL,G1H32(15),wf4(:,4),G1H8(17),ngZu,m3h4x8(:,17),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(17),35,0,G2H8(15),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H32(16),wf4(:,4),G1H8(18),ngZu,m3h4x8(:,18),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(18),35,0,G2H8(16),n2h8(16))
  call Hloop_AZ_Q(ntryL,G1H32(17),wf4(:,4),G1H8(19),ngZu,m3h4x8(:,19),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(19),35,0,G2H8(17),n2h8(17))
  call Hloop_AZ_Q(ntryL,G1H32(18),wf4(:,4),G1H8(20),ngZu,m3h4x8(:,20),heltab2x32(:,:,86))
  call Hloop_A_Q(ntryL,G1H8(20),35,0,G2H8(18),n2h8(18))
  call Hloop_WA_Q(ntryL,G0H32(21),ex4(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(39),n2h16(101))
  call Hloop_WA_Q(ntryL,G0H32(22),ex4(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(40),n2h16(102))
  call Hloop_VA_Q(ntryL,G0H32(23),ex4(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(41),n2h16(103))
  call Hloop_ZA_Q(ntryL,G0H32(24),ex4(:),G0H16(1),ngZl,m3h2x16(:,70),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(42),n2h16(104))
  call Hloop_VA_Q(ntryL,G0H32(25),ex4(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(43),n2h16(105))
  call Hloop_ZA_Q(ntryL,G0H32(26),ex4(:),G0H16(1),ngZl,m3h2x16(:,72),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(44),n2h16(106))
  call Hloop_VA_Q(ntryL,G0H32(27),ex4(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(45),n2h16(107))
  call Hloop_ZA_Q(ntryL,G0H32(28),ex4(:),G0H16(1),ngZl,m3h2x16(:,74),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(46),n2h16(108))
  call Hloop_VA_Q(ntryL,G0H32(29),ex4(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(47),n2h16(109))
  call Hloop_ZA_Q(ntryL,G0H32(30),ex4(:),G0H16(1),ngZl,m3h2x16(:,76),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(48),n2h16(110))
  call Hloop_WA_Q(ntryL,G0H32(31),ex4(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(49),n2h16(111))
  call Hloop_VQ_A(ntryL,G0H32(32),ex3(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(50),n2h16(112))
  call Hloop_VQ_A(ntryL,G0H32(33),ex3(:),G0H16(1),m3h2x16(:,79),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(51),n2h16(113))
  call Hloop_ZQ_A(ntryL,G0H32(34),ex3(:),G0H16(1),ngZl,m3h2x16(:,80),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(52),n2h16(114))
  call Hloop_ZQ_A(ntryL,G0H32(35),ex3(:),G0H16(1),ngZl,m3h2x16(:,81),heltab2x32(:,:,101))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(53),n2h16(115))
  call Hloop_VQ_A(ntryL,G0H32(36),ex3(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(54),n2h16(116))
  call Hloop_VQ_A(ntryL,G0H32(37),ex3(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,103))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(55),n2h16(117))
  call Hloop_ZQ_A(ntryL,G0H32(38),ex3(:),G0H16(1),ngZl,m3h2x16(:,84),heltab2x32(:,:,104))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(56),n2h16(118))
  call Hloop_ZQ_A(ntryL,G0H32(39),ex3(:),G0H16(1),ngZl,m3h2x16(:,85),heltab2x32(:,:,105))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(57),n2h16(119))
  call Hloop_VA_Q(ntryL,G0H32(40),ex2(:),G0H16(1),m3h2x16(:,86),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(58),n2h16(120))
  call Hloop_ZA_Q(ntryL,G0H32(41),ex2(:),G0H16(1),ngZl,m3h2x16(:,87),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(59),n2h16(121))
  call Hloop_VA_Q(ntryL,G0H32(42),ex2(:),G0H16(1),m3h2x16(:,88),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(60),n2h16(122))
  call Hloop_ZA_Q(ntryL,G0H32(43),ex2(:),G0H16(1),ngZl,m3h2x16(:,89),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(61),n2h16(123))
  call Hloop_WA_Q(ntryL,G0H32(44),ex2(:),G0H16(1),m3h2x16(:,90),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(62),n2h16(124))
  call Hloop_VA_Q(ntryL,G0H32(45),ex2(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(63),n2h16(125))
  call Hloop_ZA_Q(ntryL,G0H32(46),ex2(:),G0H16(1),ngZl,m3h2x16(:,92),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(64),n2h16(126))
  call Hloop_VA_Q(ntryL,G0H32(47),ex2(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(65),n2h16(127))
  call Hloop_ZA_Q(ntryL,G0H32(48),ex2(:),G0H16(1),ngZl,m3h2x16(:,94),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(66),n2h16(128))
  call Hloop_WA_Q(ntryL,G0H32(49),ex2(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(1),n2h16(129))
  call Hloop_UV_W(ntryL,G0H32(50),32,wf4(:,2),12,G1H8(21),m3h4x8(:,21),heltab2x32(:,:,116))
  call Hloop_UV_W(ntryL,G0H32(51),32,wf4(:,3),12,G1H8(22),m3h4x8(:,22),heltab2x32(:,:,117))
  call Hloop_VQ_A(ntryL,G0H32(52),ex1(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(2),n2h16(130))
  call Hloop_VQ_A(ntryL,G0H32(53),ex1(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(3),n2h16(131))
  call Hloop_ZQ_A(ntryL,G0H32(54),ex1(:),G0H16(1),ngZl,m3h2x16(:,98),heltab2x32(:,:,120))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(4),n2h16(132))
  call Hloop_ZQ_A(ntryL,G0H32(55),ex1(:),G0H16(1),ngZl,m3h2x16(:,99),heltab2x32(:,:,121))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(9),n2h16(133))
  call Hloop_VQ_A(ntryL,G0H32(56),ex1(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,122))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(10),n2h16(134))
  call Hloop_VQ_A(ntryL,G0H32(57),ex1(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(11),n2h16(135))
  call Hloop_ZQ_A(ntryL,G0H32(58),ex1(:),G0H16(1),ngZl,m3h2x16(:,102),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(12),n2h16(136))
  call Hloop_ZQ_A(ntryL,G0H32(59),ex1(:),G0H16(1),ngZl,m3h2x16(:,103),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(18),n2h16(137))
  call Hloop_WA_Q(ntryL,G0H32(60),ex2(:),G0H16(1),m3h2x16(:,104),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(20),n2h16(138))
  call Hloop_WA_Q(ntryL,G0H32(61),ex2(:),G0H16(1),m3h2x16(:,105),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(22),n2h16(139))
  call Hloop_VA_Q(ntryL,G0H32(62),ex2(:),G0H16(1),m3h2x16(:,106),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(23),n2h16(140))
  call Hloop_ZA_Q(ntryL,G0H32(63),ex2(:),G0H16(1),ngZl,m3h2x16(:,107),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(24),n2h16(141))
  call Hloop_VA_Q(ntryL,G0H32(64),ex2(:),G0H16(1),m3h2x16(:,108),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(25),n2h16(142))
  call Hloop_ZA_Q(ntryL,G0H32(65),ex2(:),G0H16(1),ngZl,m3h2x16(:,109),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(30),n2h16(143))
  call Hloop_VA_Q(ntryL,G0H32(66),ex2(:),G0H16(1),m3h2x16(:,110),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(31),n2h16(144))
  call Hloop_ZA_Q(ntryL,G0H32(1),ex2(:),G0H16(1),ngZl,m3h2x16(:,111),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(32),n2h16(145))
  call Hloop_VA_Q(ntryL,G0H32(2),ex2(:),G0H16(1),m3h2x16(:,112),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(33),n2h16(146))
  call Hloop_ZA_Q(ntryL,G0H32(3),ex2(:),G0H16(1),ngZl,m3h2x16(:,113),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(67),n2h16(147))
  call Hloop_WA_Q(ntryL,G0H32(4),ex2(:),G0H16(1),m3h2x16(:,114),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(68),n2h16(148))
  call Hloop_VQ_A(ntryL,G0H32(5),ex1(:),G0H16(1),m3h2x16(:,115),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(69),n2h16(149))
  call Hloop_VQ_A(ntryL,G0H32(6),ex1(:),G0H16(1),m3h2x16(:,116),heltab2x32(:,:,138))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(70),n2h16(150))
  call Hloop_ZQ_A(ntryL,G0H32(7),ex1(:),G0H16(1),ngZl,m3h2x16(:,117),heltab2x32(:,:,139))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(71),n2h16(151))
  call Hloop_ZQ_A(ntryL,G0H32(8),ex1(:),G0H16(1),ngZl,m3h2x16(:,118),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(72),n2h16(152))
  call Hloop_VQ_A(ntryL,G0H32(9),ex1(:),G0H16(1),m3h2x16(:,119),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(73),n2h16(153))
  call Hloop_VQ_A(ntryL,G0H32(10),ex1(:),G0H16(1),m3h2x16(:,120),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(74),n2h16(154))
  call Hloop_ZQ_A(ntryL,G0H32(13),ex1(:),G0H16(1),ngZl,m3h2x16(:,121),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(75),n2h16(155))
  call Hloop_ZQ_A(ntryL,G0H32(14),ex1(:),G0H16(1),ngZl,m3h2x16(:,122),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(76),n2h16(156))
  call Hloop_AQ_V(ntryL,G1H16(5),ex3(:),G1H8(23),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_AQ_V(ntryL,G1H16(6),ex3(:),G1H8(24),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_AQ_Z(ntryL,G1H16(7),ex3(:),G1H8(25),ngZl,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_AQ_Z(ntryL,G1H16(8),ex3(:),G1H8(26),ngZl,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_AQ_V(ntryL,G1H16(13),ex3(:),G1H8(27),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex3(:),G1H8(28),ngZl,m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_AQ_V(ntryL,G1H16(15),ex3(:),G1H8(29),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_AQ_Z(ntryL,G1H16(16),ex3(:),G1H8(30),ngZl,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_AQ_W(ntryL,G1H16(17),ex3(:),G1H8(31),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_WA_Q(ntryL,G1H16(19),ex2(:),G1H8(32),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(32),50,0,G2H8(19),n2h8(19))
  call Hloop_WQ_A(ntryL,G1H16(21),ex1(:),G1H8(33),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(33),49,0,G2H8(20),n2h8(20))
  call Hloop_AQ_V(ntryL,G1H16(26),ex1(:),G1H8(34),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_AQ_V(ntryL,G1H16(27),ex1(:),G1H8(35),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_AQ_Z(ntryL,G1H16(28),ex1(:),G1H8(36),ngZl,m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_AQ_Z(ntryL,G1H16(29),ex1(:),G1H8(37),ngZl,m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_AQ_V(ntryL,G1H16(34),ex1(:),G1H8(38),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_AQ_V(ntryL,G1H16(35),ex1(:),G1H8(39),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_AQ_Z(ntryL,G1H16(36),ex1(:),G1H8(40),ngZl,m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_AQ_Z(ntryL,G1H16(37),ex1(:),G1H8(41),ngZl,m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_AQ_W(ntryL,G1H16(38),ex1(:),G1H8(42),m3h2x8(:,86),heltab2x16(:,:,86))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G2H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G2H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G2H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G2H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G2H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G2H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(21)])
  call Hloop_AQ_V(ntryL,G2H8(6),ex5(:),G2H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_AQ_V(ntryL,G2H8(7),ex5(:),G2H4(2),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_AQ_Z(ntryL,G2H8(8),ex5(:),G2H4(3),ngZu,m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_AQ_Z(ntryL,G2H8(9),ex5(:),G2H4(4),ngZu,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_AQ_W(ntryL,G2H8(10),ex5(:),G2H4(5),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_WA_Q(ntryL,G1H8(12),ex4(:),G1H4(1),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(6),n2h4(67))
  call Hloop_AQ_V(ntryL,G2H8(15),ex5(:),G2H4(7),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_AQ_Z(ntryL,G2H8(16),ex5(:),G2H4(8),ngZu,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_AQ_V(ntryL,G2H8(17),ex5(:),G2H4(9),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_AQ_Z(ntryL,G2H8(18),ex5(:),G2H4(10),ngZu,m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_AQ_W(ntryL,G1H16(39),ex3(:),G1H8(43),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_AQ_W(ntryL,G1H16(40),ex3(:),G1H8(44),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_AV_Q(ntryL,G1H16(41),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(11),n2h4(68))
  call Hloop_AV_Q(ntryL,G1H16(42),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(12),n2h4(69))
  call Hloop_AV_Q(ntryL,G1H16(43),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(13),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H16(44),wf4(:,1),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(14),n2h4(71))
  call Hloop_AZ_Q(ntryL,G1H16(45),wf4(:,4),G1H4(1),ngZl,m3h4x4(:,5),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(15),n2h4(72))
  call Hloop_AZ_Q(ntryL,G1H16(46),wf4(:,4),G1H4(1),ngZl,m3h4x4(:,6),heltab2x16(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(16),n2h4(73))
  call Hloop_AZ_Q(ntryL,G1H16(47),wf4(:,4),G1H4(1),ngZl,m3h4x4(:,7),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(17),n2h4(74))
  call Hloop_AZ_Q(ntryL,G1H16(48),wf4(:,4),G1H4(1),ngZl,m3h4x4(:,8),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(18),n2h4(75))
  call Hloop_AZ_Q(ntryL,G1H16(49),wf4(:,4),G1H4(1),ngZn,m3h4x4(:,9),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(19),n2h4(76))
  call Hloop_QV_A(ntryL,G1H16(50),wf4(:,1),G1H4(1),m3h4x4(:,10),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(20),n2h4(77))
  call Hloop_QV_A(ntryL,G1H16(51),wf4(:,1),G1H4(1),m3h4x4(:,11),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(21),n2h4(78))
  call Hloop_QV_A(ntryL,G1H16(52),wf4(:,1),G1H4(1),m3h4x4(:,12),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(22),n2h4(79))
  call Hloop_QV_A(ntryL,G1H16(53),wf4(:,1),G1H4(1),m3h4x4(:,13),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(23),n2h4(80))
  call Hloop_QZ_A(ntryL,G1H16(54),wf4(:,4),G1H4(1),ngZl,m3h4x4(:,14),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(24),n2h4(81))
  call Hloop_QZ_A(ntryL,G1H16(55),wf4(:,4),G1H4(1),ngZl,m3h4x4(:,15),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(25),n2h4(82))
  call Hloop_QZ_A(ntryL,G1H16(56),wf4(:,4),G1H4(1),ngZl,m3h4x4(:,16),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(26),n2h4(83))
  call Hloop_QZ_A(ntryL,G1H16(57),wf4(:,4),G1H4(1),ngZl,m3h4x4(:,17),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(27),n2h4(84))
  call Hloop_AQ_V(ntryL,G1H16(58),ex1(:),G1H8(45),m3h2x8(:,89),heltab2x16(:,:,106))
  call Hloop_AQ_V(ntryL,G1H16(59),ex1(:),G1H8(46),m3h2x8(:,90),heltab2x16(:,:,107))
  call Hloop_AQ_Z(ntryL,G1H16(60),ex1(:),G1H8(47),ngZl,m3h2x8(:,91),heltab2x16(:,:,108))
  call Hloop_AQ_Z(ntryL,G1H16(61),ex1(:),G1H8(48),ngZl,m3h2x8(:,92),heltab2x16(:,:,109))
  call Hloop_AQ_W(ntryL,G1H16(62),ex1(:),G1H8(49),m3h2x8(:,93),heltab2x16(:,:,110))
  call Hloop_AQ_V(ntryL,G1H16(63),ex1(:),G1H8(50),m3h2x8(:,94),heltab2x16(:,:,111))
  call Hloop_AQ_V(ntryL,G1H16(64),ex1(:),G1H8(51),m3h2x8(:,95),heltab2x16(:,:,112))
  call Hloop_AQ_Z(ntryL,G1H16(65),ex1(:),G1H8(52),ngZl,m3h2x8(:,96),heltab2x16(:,:,113))
  call Hloop_AQ_Z(ntryL,G1H16(66),ex1(:),G1H8(53),ngZl,m3h2x8(:,97),heltab2x16(:,:,114))
  call Hloop_AQ_W(ntryL,G1H16(1),ex1(:),G1H8(54),m3h2x8(:,98),heltab2x16(:,:,115))
  call Hloop_WA_Q(ntryL,G1H8(22),ex2(:),G1H4(1),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(28),n2h4(85))
  call Hloop_QA_V(ntryL,G1H16(2),ex2(:),G1H8(55),m3h2x8(:,99),heltab2x16(:,:,116))
  call Hloop_QA_Z(ntryL,G1H16(3),ex2(:),G1H8(56),ngZl,m3h2x8(:,100),heltab2x16(:,:,117))
  call Hloop_QA_V(ntryL,G1H16(4),ex2(:),G1H8(57),m3h2x8(:,101),heltab2x16(:,:,118))
  call Hloop_QA_Z(ntryL,G1H16(9),ex2(:),G1H8(58),ngZl,m3h2x8(:,102),heltab2x16(:,:,119))
  call Hloop_QA_V(ntryL,G1H16(10),ex2(:),G1H8(59),m3h2x8(:,103),heltab2x16(:,:,120))
  call Hloop_QA_Z(ntryL,G1H16(11),ex2(:),G1H8(60),ngZl,m3h2x8(:,104),heltab2x16(:,:,121))
  call Hloop_QA_V(ntryL,G1H16(12),ex2(:),G1H8(61),m3h2x8(:,105),heltab2x16(:,:,122))
  call Hloop_QA_Z(ntryL,G1H16(18),ex2(:),G1H8(62),ngZl,m3h2x8(:,106),heltab2x16(:,:,123))
  call Hloop_AQ_W(ntryL,G1H16(20),ex1(:),G1H8(63),m3h2x8(:,107),heltab2x16(:,:,124))
  call Hloop_AQ_W(ntryL,G1H16(22),ex1(:),G1H8(64),m3h2x8(:,108),heltab2x16(:,:,125))
  call Hloop_AV_Q(ntryL,G1H16(23),wf4(:,2),G1H4(1),m3h4x4(:,18),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(29),n2h4(86))
  call Hloop_AV_Q(ntryL,G1H16(24),wf4(:,2),G1H4(1),m3h4x4(:,19),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(30),n2h4(87))
  call Hloop_AV_Q(ntryL,G1H16(25),wf4(:,2),G1H4(1),m3h4x4(:,20),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(31),n2h4(88))
  call Hloop_AV_Q(ntryL,G1H16(30),wf4(:,2),G1H4(1),m3h4x4(:,21),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(32),n2h4(89))
  call Hloop_AZ_Q(ntryL,G1H16(31),wf4(:,3),G1H4(1),ngZl,m3h4x4(:,22),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(33),n2h4(90))
  call Hloop_AZ_Q(ntryL,G1H16(32),wf4(:,3),G1H4(1),ngZl,m3h4x4(:,23),heltab2x16(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(34),n2h4(91))
  call Hloop_AZ_Q(ntryL,G1H16(33),wf4(:,3),G1H4(1),ngZl,m3h4x4(:,24),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(35),n2h4(92))
  call Hloop_AZ_Q(ntryL,G1H16(67),wf4(:,3),G1H4(1),ngZl,m3h4x4(:,25),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(36),n2h4(93))
  call Hloop_AZ_Q(ntryL,G1H16(68),wf4(:,3),G1H4(1),ngZn,m3h4x4(:,26),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(37),n2h4(94))
  call Hloop_QV_A(ntryL,G1H16(69),wf4(:,2),G1H4(1),m3h4x4(:,27),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(38),n2h4(95))
  call Hloop_QV_A(ntryL,G1H16(70),wf4(:,2),G1H4(1),m3h4x4(:,28),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(39),n2h4(96))
  call Hloop_QV_A(ntryL,G1H16(71),wf4(:,2),G1H4(1),m3h4x4(:,29),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(40),n2h4(97))
  call Hloop_QV_A(ntryL,G1H16(72),wf4(:,2),G1H4(1),m3h4x4(:,30),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(41),n2h4(98))
  call Hloop_QZ_A(ntryL,G1H16(73),wf4(:,3),G1H4(1),ngZl,m3h4x4(:,31),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(42),n2h4(99))
  call Hloop_QZ_A(ntryL,G1H16(74),wf4(:,3),G1H4(1),ngZl,m3h4x4(:,32),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(43),n2h4(100))
  call Hloop_QZ_A(ntryL,G1H16(75),wf4(:,3),G1H4(1),ngZl,m3h4x4(:,33),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(44),n2h4(101))
  call Hloop_QZ_A(ntryL,G1H16(76),wf4(:,3),G1H4(1),ngZl,m3h4x4(:,34),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(45),n2h4(102))
  call Hloop_VQ_A(ntryL,G1H8(23),ex1(:),G1H4(1),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(46),n2h4(103))
  call Hloop_VQ_A(ntryL,G1H8(24),ex1(:),G1H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(47),n2h4(104))
  call Hloop_ZQ_A(ntryL,G1H8(25),ex1(:),G1H4(1),ngZl,m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(48),n2h4(105))
  call Hloop_ZQ_A(ntryL,G1H8(26),ex1(:),G1H4(1),ngZl,m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(49),n2h4(106))
  call Hloop_VA_Q(ntryL,G1H8(27),ex2(:),G1H4(1),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(50),n2h4(107))
  call Hloop_ZA_Q(ntryL,G1H8(28),ex2(:),G1H4(1),ngZl,m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(51),n2h4(108))
  call Hloop_VA_Q(ntryL,G1H8(29),ex2(:),G1H4(1),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(52),n2h4(109))
  call Hloop_ZA_Q(ntryL,G1H8(30),ex2(:),G1H4(1),ngZl,m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(53),n2h4(110))
  call Hloop_WA_Q(ntryL,G1H8(31),ex2(:),G1H4(1),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(54),n2h4(111))
  call Hloop_AQ_W(ntryL,G2H8(19),ex1(:),G2H4(55),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_QA_W(ntryL,G2H8(20),ex2(:),G2H4(56),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_VQ_A(ntryL,G1H8(34),ex3(:),G1H4(1),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(57),n2h4(112))
  call Hloop_VQ_A(ntryL,G1H8(35),ex3(:),G1H4(1),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(58),n2h4(113))
  call Hloop_ZQ_A(ntryL,G1H8(36),ex3(:),G1H4(1),ngZl,m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(59),n2h4(114))
  call Hloop_ZQ_A(ntryL,G1H8(37),ex3(:),G1H4(1),ngZl,m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(60),n2h4(115))
  call Hloop_VA_Q(ntryL,G1H8(38),ex4(:),G1H4(1),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(61),n2h4(116))
  call Hloop_VA_Q(ntryL,G1H8(39),ex4(:),G1H4(1),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(62),n2h4(117))
  call Hloop_ZA_Q(ntryL,G1H8(40),ex4(:),G1H4(1),ngZl,m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(63),n2h4(118))
  call Hloop_ZA_Q(ntryL,G1H8(41),ex4(:),G1H4(1),ngZl,m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(64),n2h4(119))
  call Hloop_WA_Q(ntryL,G1H8(42),ex4(:),G1H4(1),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(65),n2h4(120))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G2H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G2H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(41)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(9),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(9),mass5set(:,6),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(9),mass5set(:,3),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(9),mass5set(:,7),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(9),mass5set(:,8),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hloop_AQ_W(ntryL,G2H4(6),ex3(:),G2H2(1),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(10),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),4,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(10),mass5set(:,3),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),4,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(10),mass5set(:,6),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),4,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(10),mass5set(:,7),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),4,4)
  call Hloop_UV_W(ntryL,G1H8(43),44,wf4(:,1),3,G2H2(2),m3h4x2(:,1),heltab2x8(:,:,98))
  call Hloop_UV_W(ntryL,G1H8(44),44,wf4(:,4),3,G2H2(3),m3h4x2(:,2),heltab2x8(:,:,99))
  call Hloop_AQ_V(ntryL,G2H4(15),ex3(:),G2H2(4),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_AQ_V(ntryL,G2H4(16),ex3(:),G2H2(5),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_AQ_Z(ntryL,G2H4(17),ex3(:),G2H2(6),ngZl,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_AQ_Z(ntryL,G2H4(18),ex3(:),G2H2(7),ngZl,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_AQ_W(ntryL,G2H4(19),ex3(:),G2H2(8),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_QA_V(ntryL,G2H4(24),ex4(:),G2H2(9),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_QA_Z(ntryL,G2H4(25),ex4(:),G2H2(10),ngZl,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QA_V(ntryL,G2H4(26),ex4(:),G2H2(11),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_QA_Z(ntryL,G2H4(27),ex4(:),G2H2(12),ngZl,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_VQ_A(ntryL,G1H8(45),ex5(:),G1H4(55),m3h2x4(:,98),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(66),n2h4(121))
  call Hloop_VQ_A(ntryL,G1H8(46),ex5(:),G1H4(55),m3h2x4(:,99),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(11),n2h4(122))
  call Hloop_ZQ_A(ntryL,G1H8(47),ex5(:),G1H4(55),ngZu,m3h2x4(:,100),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(12),n2h4(123))
  call Hloop_ZQ_A(ntryL,G1H8(48),ex5(:),G1H4(55),ngZu,m3h2x4(:,101),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(13),n2h4(124))
  call Hloop_WQ_A(ntryL,G1H8(49),ex5(:),G1H4(55),m3h2x4(:,102),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(14),n2h4(125))
  call Hloop_VQ_A(ntryL,G1H8(50),ex5(:),G1H4(55),m3h2x4(:,103),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(20),n2h4(126))
  call Hloop_VQ_A(ntryL,G1H8(51),ex5(:),G1H4(55),m3h2x4(:,104),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(21),n2h4(127))
  call Hloop_ZQ_A(ntryL,G1H8(52),ex5(:),G1H4(55),ngZu,m3h2x4(:,105),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(22),n2h4(128))
  call Hloop_ZQ_A(ntryL,G1H8(53),ex5(:),G1H4(55),ngZu,m3h2x4(:,106),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(23),n2h4(129))
  call Hloop_WQ_A(ntryL,G1H8(54),ex5(:),G1H4(55),m3h2x4(:,107),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(29),n2h4(130))
  call Hloop_AQ_W(ntryL,G2H4(28),ex1(:),G2H2(13),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_VQ_A(ntryL,G1H8(55),ex5(:),G1H4(55),m3h2x4(:,108),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(30),n2h4(131))
  call Hloop_ZQ_A(ntryL,G1H8(56),ex5(:),G1H4(55),ngZu,m3h2x4(:,109),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(31),n2h4(132))
  call Hloop_VQ_A(ntryL,G1H8(57),ex5(:),G1H4(55),m3h2x4(:,110),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(32),n2h4(133))
  call Hloop_ZQ_A(ntryL,G1H8(58),ex5(:),G1H4(55),ngZu,m3h2x4(:,111),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(38),n2h4(134))
  call Hloop_VQ_A(ntryL,G1H8(59),ex5(:),G1H4(55),m3h2x4(:,112),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(39),n2h4(135))
  call Hloop_ZQ_A(ntryL,G1H8(60),ex5(:),G1H4(55),ngZu,m3h2x4(:,113),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(40),n2h4(136))
  call Hloop_VQ_A(ntryL,G1H8(61),ex5(:),G1H4(55),m3h2x4(:,114),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(41),n2h4(137))
  call Hloop_ZQ_A(ntryL,G1H8(62),ex5(:),G1H4(55),ngZu,m3h2x4(:,115),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(1),n2h4(138))
  call Hloop_UV_W(ntryL,G1H8(63),35,wf4(:,2),12,G2H2(14),m3h4x2(:,3),heltab2x8(:,:,118))
  call Hloop_UV_W(ntryL,G1H8(64),35,wf4(:,3),12,G2H2(15),m3h4x2(:,4),heltab2x8(:,:,119))
  call Hloop_AQ_V(ntryL,G2H4(33),ex1(:),G2H2(16),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_AQ_V(ntryL,G2H4(34),ex1(:),G2H2(17),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_AQ_Z(ntryL,G2H4(35),ex1(:),G2H2(18),ngZl,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_AQ_Z(ntryL,G2H4(36),ex1(:),G2H2(19),ngZl,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_AQ_W(ntryL,G2H4(37),ex1(:),G2H2(20),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_QA_V(ntryL,G2H4(42),ex2(:),G2H2(21),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_QA_Z(ntryL,G2H4(43),ex2(:),G2H2(22),ngZl,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QA_V(ntryL,G2H4(44),ex2(:),G2H2(23),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_QA_Z(ntryL,G2H4(45),ex2(:),G2H2(24),ngZl,m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_QA_V(ntryL,G2H4(46),ex2(:),G2H2(25),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_QA_Z(ntryL,G2H4(47),ex2(:),G2H2(26),ngZl,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_QA_V(ntryL,G2H4(48),ex2(:),G2H2(27),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_QA_Z(ntryL,G2H4(49),ex2(:),G2H2(28),ngZl,m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_AQ_V(ntryL,G2H4(50),ex1(:),G2H2(29),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_AQ_V(ntryL,G2H4(51),ex1(:),G2H2(30),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AQ_Z(ntryL,G2H4(52),ex1(:),G2H2(31),ngZl,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_AQ_Z(ntryL,G2H4(53),ex1(:),G2H2(32),ngZl,m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_AQ_W(ntryL,G2H4(54),ex1(:),G2H2(33),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(11),mass5set(:,9),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),4,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(12),mass5set(:,9),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hloop_QA_V(ntryL,G2H4(57),ex4(:),G2H2(34),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_QA_Z(ntryL,G2H4(58),ex4(:),G2H2(35),ngZl,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_QA_V(ntryL,G2H4(59),ex4(:),G2H2(36),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_QA_Z(ntryL,G2H4(60),ex4(:),G2H2(37),ngZl,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_AQ_V(ntryL,G2H4(61),ex3(:),G2H2(38),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_AQ_Z(ntryL,G2H4(62),ex3(:),G2H2(39),ngZl,m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_AQ_V(ntryL,G2H4(63),ex3(:),G2H2(40),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_AQ_Z(ntryL,G2H4(64),ex3(:),G2H2(41),ngZl,m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_AQ_W(ntryL,G2H4(65),ex3(:),G2H2(42),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(43),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(2),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(7),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(7),55,0,G2H2(44),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(8),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(8),55,0,G2H2(45),n2h2(3))
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(13),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(13),55,0,G2H2(46),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(8),ex4(:),G1H2(14),ngZl,m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_VQ_A(ntryL,G1H4(11),ex3(:),G1H2(19),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(47),n2h2(5))
  call Hloop_VQ_A(ntryL,G1H4(12),ex3(:),G1H2(20),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(20),55,0,G2H2(48),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(13),ex3(:),G1H2(25),ngZl,m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(25),55,0,G2H2(49),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex4(:),G1H2(26),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_ZQ_A(ntryL,G1H4(17),ex3(:),G1H2(31),ngZl,m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(31),55,0,G2H2(50),n2h2(8))
  call Hloop_ZQ_A(ntryL,G1H4(18),ex3(:),G1H2(32),ngZl,m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(32),55,0,G2H2(51),n2h2(9))
  call Hloop_ZQ_A(ntryL,G1H4(19),ex3(:),G1H2(37),ngZl,m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(37),55,0,G2H2(52),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(20),ex4(:),G1H2(38),ngZl,m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_ZQ_A(ntryL,G1H4(23),ex3(:),G1H2(43),ngZl,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(43),55,0,G2H2(53),n2h2(11))
  call Hloop_ZQ_A(ntryL,G1H4(24),ex3(:),G1H2(44),ngZl,m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(44),55,0,G2H2(54),n2h2(12))
  call Hloop_WQ_A(ntryL,G1H4(25),ex3(:),G1H2(49),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(49),55,0,G2H2(55),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(26),ex4(:),G1H2(50),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_WQ_A(ntryL,G1H4(29),ex3(:),G1H2(55),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(55),55,0,G2H2(56),n2h2(14))
  call Hloop_WQ_A(ntryL,G1H4(30),ex3(:),G1H2(56),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(56),55,0,G2H2(57),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(31),ex4(:),G1H2(61),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(61),59,0,G2H2(58),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(32),ex3(:),G1H2(62),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_VA_Q(ntryL,G1H4(35),ex4(:),G1H2(67),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(67),59,0,G2H2(59),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(36),ex4(:),G1H2(68),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(68),59,0,G2H2(60),n2h2(18))
  call Hloop_ZA_Q(ntryL,G1H4(37),ex4(:),G1H2(73),ngZl,m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(73),59,0,G2H2(61),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(38),ex3(:),G1H2(74),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_ZA_Q(ntryL,G1H4(41),ex4(:),G1H2(79),ngZl,m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(79),59,0,G2H2(62),n2h2(20))
  call Hloop_ZA_Q(ntryL,G1H4(42),ex4(:),G1H2(80),ngZl,m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(80),59,0,G2H2(63),n2h2(21))
  call Hloop_VA_Q(ntryL,G1H4(43),ex4(:),G1H2(85),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(85),59,0,G2H2(64),n2h2(22))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(44),ex3(:),G1H2(86),ngZl,m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_VA_Q(ntryL,G1H4(47),ex4(:),G1H2(91),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(91),59,0,G2H2(65),n2h2(23))
  call Hloop_VA_Q(ntryL,G1H4(48),ex4(:),G1H2(92),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(92),59,0,G2H2(66),n2h2(24))
  call Hloop_ZA_Q(ntryL,G1H4(49),ex4(:),G1H2(97),ngZl,m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(97),59,0,G2H2(67),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(50),ex3(:),G1H2(98),ngZl,m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_ZA_Q(ntryL,G1H4(53),ex4(:),G1H2(103),ngZl,m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(103),59,0,G2H2(68),n2h2(26))
  call Hloop_ZA_Q(ntryL,G1H4(54),ex4(:),G1H2(104),ngZl,m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(104),59,0,G2H2(69),n2h2(27))
  call Hloop_WA_Q(ntryL,G1H4(55),ex4(:),G1H2(109),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(109),59,0,G2H2(70),n2h2(28))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(56),ex3(:),G1H2(110),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_WA_Q(ntryL,G1H4(59),ex4(:),G1H2(115),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(115),59,0,G2H2(71),n2h2(29))
  call Hloop_WA_Q(ntryL,G1H4(60),ex4(:),G1H2(116),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(116),59,0,G2H2(72),n2h2(30))
  call Hloop_WQ_A(ntryL,G1H4(61),ex3(:),G1H2(121),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(121),55,0,G2H2(73),n2h2(31))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(62),ex4(:),G1H2(122),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_WQ_A(ntryL,G1H4(65),ex3(:),G1H2(127),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(127),55,0,G2H2(74),n2h2(32))
  call Hloop_WQ_A(ntryL,G1H4(66),ex3(:),G1H2(128),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(128),55,0,G2H2(75),n2h2(33))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(100),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(204),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(210),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(27),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(112),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(222),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(118),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(216),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(124),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(47),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(234),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(130),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(228),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(136),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(240),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(142),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(246),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(304),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(310),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(83),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(156),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(322),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(162),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(316),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(168),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(334),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(95),[G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(174),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(93),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(328),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(180),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(340),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(186),[G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(346),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(192),[G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(119),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(258),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(131),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(264),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(123),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(137),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(276),[G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(270),[G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(143),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(288),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(282),[G1H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(141),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(294),[G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(300),[G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(159),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(352),[G1H2(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(167),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(171),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(358),[G1H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(179),[G1H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(370),[G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(185),[G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(183),[G1H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(364),[G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(382),[G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(191),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(376),[G1H2(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(388),[G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(394),[G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(14),G1H2(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(207),[G1H2(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(256),[G1H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(215),[G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(262),[G1H2(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(227),[G1H2(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(225),[G1H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(268),[G1H2(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(231),[G1H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(274),[G1H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(239),[G1H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(280),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(286),[G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(245),[G1H2(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(292),[G1H2(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(298),[G1H2(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(2),G1H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(261),[G1H2(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(269),[G1H2(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(281),[G1H2(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(279),[G1H2(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(285),[G1H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(293),[G1H2(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(299),[G1H2(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(297),[G1H2(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(321),[G1H2(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(317),[G1H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(354),[G1H2(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(333),[G1H2(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(329),[G1H2(311)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(360),[G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(339),[G1H2(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(366),[G1H2(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(341),[G1H2(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(372),[G1H2(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(345),[G1H2(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(378),[G1H2(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(347),[G1H2(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(384),[G1H2(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(390),[G1H2(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(396),[G1H2(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(369),[G1H2(351)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(365),[G1H2(353)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(381),[G1H2(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(377),[G1H2(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(387),[G1H2(363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(389),[G1H2(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(393),[G1H2(375)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(395),[G1H2(383)])
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(133))
  call Hloop_VQ_A(ntryL,G1H2(100),ex5(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(134))
  call Hloop_VQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(135))
  call Hloop_VQ_A(ntryL,G1H2(204),ex5(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(136))
  call Hloop_VQ_A(ntryL,G1H2(106),ex5(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(137))
  call Hloop_VQ_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(138))
  call Hloop_VQ_A(ntryL,G1H2(210),ex5(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(139))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),ngZu,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(140))
  call Hloop_ZQ_A(ntryL,G1H2(112),ex5(:),G1H1(1),ngZu,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(141))
  call Hloop_ZQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),ngZu,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(142))
  call Hloop_ZQ_A(ntryL,G1H2(222),ex5(:),G1H1(1),ngZu,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(143))
  call Hloop_VQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(144))
  call Hloop_VQ_A(ntryL,G1H2(118),ex5(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(145))
  call Hloop_VQ_A(ntryL,G1H2(216),ex5(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(146))
  call Hloop_ZQ_A(ntryL,G1H2(124),ex5(:),G1H1(1),ngZu,m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(147))
  call Hloop_ZQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),ngZu,m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(148))
  call Hloop_ZQ_A(ntryL,G1H2(234),ex5(:),G1H1(1),ngZu,m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(149))
  call Hloop_VQ_A(ntryL,G1H2(130),ex5(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(150))
  call Hloop_VQ_A(ntryL,G1H2(228),ex5(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(151))
  call Hloop_ZQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),ngZu,m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(152))
  call Hloop_ZQ_A(ntryL,G1H2(136),ex5(:),G1H1(1),ngZu,m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(153))
  call Hloop_ZQ_A(ntryL,G1H2(240),ex5(:),G1H1(1),ngZu,m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(154))
  call Hloop_ZQ_A(ntryL,G1H2(142),ex5(:),G1H1(1),ngZu,m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(155))
  call Hloop_ZQ_A(ntryL,G1H2(246),ex5(:),G1H1(1),ngZu,m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(156))
  call Hloop_VQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(157))
  call Hloop_VQ_A(ntryL,G1H2(304),ex5(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(158))
  call Hloop_VQ_A(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(159))
  call Hloop_VQ_A(ntryL,G1H2(150),ex5(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(160))
  call Hloop_ZQ_A(ntryL,G1H2(75),ex5(:),G1H1(1),ngZu,m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(161))
  call Hloop_ZQ_A(ntryL,G1H2(310),ex5(:),G1H1(1),ngZu,m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(162))
  call Hloop_ZQ_A(ntryL,G1H2(83),ex5(:),G1H1(1),ngZu,m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(163))
  call Hloop_ZQ_A(ntryL,G1H2(156),ex5(:),G1H1(1),ngZu,m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(164))
  call Hloop_VQ_A(ntryL,G1H2(322),ex5(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(165))
  call Hloop_VQ_A(ntryL,G1H2(89),ex5(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(166))
  call Hloop_VQ_A(ntryL,G1H2(162),ex5(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(167))
  call Hloop_VQ_A(ntryL,G1H2(87),ex5(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(168))
  call Hloop_VQ_A(ntryL,G1H2(316),ex5(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(169))
  call Hloop_VQ_A(ntryL,G1H2(168),ex5(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(170))
  call Hloop_ZQ_A(ntryL,G1H2(334),ex5(:),G1H1(1),ngZu,m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(171))
  call Hloop_ZQ_A(ntryL,G1H2(95),ex5(:),G1H1(1),ngZu,m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(172))
  call Hloop_ZQ_A(ntryL,G1H2(174),ex5(:),G1H1(1),ngZu,m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(173))
  call Hloop_ZQ_A(ntryL,G1H2(93),ex5(:),G1H1(1),ngZu,m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(174))
  call Hloop_ZQ_A(ntryL,G1H2(328),ex5(:),G1H1(1),ngZu,m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(175))
  call Hloop_ZQ_A(ntryL,G1H2(180),ex5(:),G1H1(1),ngZu,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(176))
  call Hloop_VQ_A(ntryL,G1H2(340),ex5(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(177))
  call Hloop_VQ_A(ntryL,G1H2(186),ex5(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(178))
  call Hloop_ZQ_A(ntryL,G1H2(346),ex5(:),G1H1(1),ngZu,m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(179))
  call Hloop_ZQ_A(ntryL,G1H2(192),ex5(:),G1H1(1),ngZu,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(180))
  call Hloop_VQ_A(ntryL,G1H2(105),ex5(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(181))
  call Hloop_VQ_A(ntryL,G1H2(119),ex5(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(182))
  call Hloop_VQ_A(ntryL,G1H2(258),ex5(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(183))
  call Hloop_VQ_A(ntryL,G1H2(131),ex5(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(184))
  call Hloop_VQ_A(ntryL,G1H2(264),ex5(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(185))
  call Hloop_ZQ_A(ntryL,G1H2(123),ex5(:),G1H1(1),ngZu,m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(186))
  call Hloop_ZQ_A(ntryL,G1H2(137),ex5(:),G1H1(1),ngZu,m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(187))
  call Hloop_ZQ_A(ntryL,G1H2(276),ex5(:),G1H1(1),ngZu,m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(188))
  call Hloop_VQ_A(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(189))
  call Hloop_VQ_A(ntryL,G1H2(270),ex5(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(115),n2h1(190))
  call Hloop_ZQ_A(ntryL,G1H2(143),ex5(:),G1H1(1),ngZu,m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(191))
  call Hloop_ZQ_A(ntryL,G1H2(288),ex5(:),G1H1(1),ngZu,m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(119),n2h1(192))
  call Hloop_VQ_A(ntryL,G1H2(282),ex5(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(193))
  call Hloop_ZQ_A(ntryL,G1H2(141),ex5(:),G1H1(1),ngZu,m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(194))
  call Hloop_ZQ_A(ntryL,G1H2(294),ex5(:),G1H1(1),ngZu,m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(125),n2h1(195))
  call Hloop_ZQ_A(ntryL,G1H2(300),ex5(:),G1H1(1),ngZu,m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(196))
  call Hloop_VQ_A(ntryL,G1H2(159),ex5(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(197))
  call Hloop_VQ_A(ntryL,G1H2(352),ex5(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(131),n2h1(198))
  call Hloop_VQ_A(ntryL,G1H2(167),ex5(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(199))
  call Hloop_ZQ_A(ntryL,G1H2(171),ex5(:),G1H1(1),ngZu,m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(134),n2h1(200))
  call Hloop_ZQ_A(ntryL,G1H2(358),ex5(:),G1H1(1),ngZu,m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(201))
  call Hloop_ZQ_A(ntryL,G1H2(179),ex5(:),G1H1(1),ngZu,m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(202))
  call Hloop_VQ_A(ntryL,G1H2(370),ex5(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(137),n2h1(203))
  call Hloop_VQ_A(ntryL,G1H2(185),ex5(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(204))
  call Hloop_VQ_A(ntryL,G1H2(183),ex5(:),G1H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(205))
  call Hloop_VQ_A(ntryL,G1H2(364),ex5(:),G1H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(140),n2h1(206))
  call Hloop_ZQ_A(ntryL,G1H2(382),ex5(:),G1H1(1),ngZu,m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(207))
  call Hloop_ZQ_A(ntryL,G1H2(191),ex5(:),G1H1(1),ngZu,m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(208))
  call Hloop_ZQ_A(ntryL,G1H2(189),ex5(:),G1H1(1),ngZu,m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(209))
  call Hloop_ZQ_A(ntryL,G1H2(376),ex5(:),G1H1(1),ngZu,m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(210))
  call Hloop_VQ_A(ntryL,G1H2(388),ex5(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(211))
  call Hloop_ZQ_A(ntryL,G1H2(394),ex5(:),G1H1(1),ngZu,m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(146),n2h1(212))
  call Hloop_WQ_A(ntryL,G1H2(195),ex5(:),G1H1(1),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(213))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(13),mass5set(:,10),  & 
G1H2(133),G1H2(134),G1H2(139),G1H2(140),G1H2(145),G1H2(146),2)
  call HG1shiftOLR(G1H2(134),16,2)
  call Hloop_WQ_A(ntryL,G1H2(197),ex5(:),G1H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(148),n2h1(214))
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(14),mass5set(:,11),  & 
G1H2(151),G1H2(152),G1H2(157),G1H2(158),G1H2(163),G1H2(164),2)
  call HG1shiftOLR(G1H2(152),16,2)
  call Hloop_VQ_A(ntryL,G1H2(207),ex5(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(149),n2h1(215))
  call Hloop_VQ_A(ntryL,G1H2(256),ex5(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(216))
  call Hloop_VQ_A(ntryL,G1H2(215),ex5(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(151),n2h1(217))
  call Hloop_VQ_A(ntryL,G1H2(262),ex5(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(218))
  call Hloop_VQ_A(ntryL,G1H2(227),ex5(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(219))
  call Hloop_VQ_A(ntryL,G1H2(225),ex5(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(154),n2h1(220))
  call Hloop_VQ_A(ntryL,G1H2(268),ex5(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(155),n2h1(221))
  call Hloop_ZQ_A(ntryL,G1H2(231),ex5(:),G1H1(1),ngZu,m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(222))
  call Hloop_ZQ_A(ntryL,G1H2(274),ex5(:),G1H1(1),ngZu,m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(157),n2h1(223))
  call Hloop_ZQ_A(ntryL,G1H2(239),ex5(:),G1H1(1),ngZu,m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(224))
  call Hloop_VQ_A(ntryL,G1H2(280),ex5(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(225))
  call Hloop_ZQ_A(ntryL,G1H2(286),ex5(:),G1H1(1),ngZu,m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(160),n2h1(226))
  call Hloop_ZQ_A(ntryL,G1H2(245),ex5(:),G1H1(1),ngZu,m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(161),n2h1(227))
  call Hloop_ZQ_A(ntryL,G1H2(243),ex5(:),G1H1(1),ngZu,m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(228))
  call Hloop_ZQ_A(ntryL,G1H2(292),ex5(:),G1H1(1),ngZu,m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(163),n2h1(229))
  call Hloop_ZQ_A(ntryL,G1H2(298),ex5(:),G1H1(1),ngZu,m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(164),n2h1(230))
  call Hloop_WQ_A(ntryL,G1H2(249),ex5(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(231))
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(15),mass5set(:,10),  & 
G1H2(169),G1H2(170),G1H2(175),G1H2(176),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(170),16,2)
  call Hloop_WQ_A(ntryL,G1H2(251),ex5(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(166),n2h1(232))
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(16),mass5set(:,11),  & 
G1H2(187),G1H2(188),G1H2(193),G1H2(194),G1H2(199),G1H2(200),2)
  call HG1shiftOLR(G1H2(188),16,2)
  call Hloop_VQ_A(ntryL,G1H2(261),ex5(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(167),n2h1(233))
  call Hloop_VQ_A(ntryL,G1H2(269),ex5(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(168),n2h1(234))
  call Hloop_VQ_A(ntryL,G1H2(281),ex5(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(169),n2h1(235))
  call Hloop_VQ_A(ntryL,G1H2(279),ex5(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(170),n2h1(236))
  call Hloop_ZQ_A(ntryL,G1H2(285),ex5(:),G1H1(1),ngZu,m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(171),n2h1(237))
  call Hloop_ZQ_A(ntryL,G1H2(293),ex5(:),G1H1(1),ngZu,m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(172),n2h1(238))
  call Hloop_ZQ_A(ntryL,G1H2(299),ex5(:),G1H1(1),ngZu,m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(173),n2h1(239))
  call Hloop_ZQ_A(ntryL,G1H2(297),ex5(:),G1H1(1),ngZu,m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(174),n2h1(240))
  call Hloop_VQ_A(ntryL,G1H2(321),ex5(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(241))
  call Hloop_VQ_A(ntryL,G1H2(317),ex5(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(176),n2h1(242))
  call Hloop_VQ_A(ntryL,G1H2(354),ex5(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(243))
  call Hloop_ZQ_A(ntryL,G1H2(333),ex5(:),G1H1(1),ngZu,m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(178),n2h1(244))
  call Hloop_ZQ_A(ntryL,G1H2(329),ex5(:),G1H1(1),ngZu,m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(179),n2h1(245))
  call Hloop_ZQ_A(ntryL,G1H2(360),ex5(:),G1H1(1),ngZu,m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(180),n2h1(246))
  call Hloop_VQ_A(ntryL,G1H2(339),ex5(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(181),n2h1(247))
  call Hloop_VQ_A(ntryL,G1H2(366),ex5(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(182),n2h1(248))
  call Hloop_VQ_A(ntryL,G1H2(341),ex5(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(249))
  call Hloop_VQ_A(ntryL,G1H2(372),ex5(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(184),n2h1(250))
  call Hloop_ZQ_A(ntryL,G1H2(345),ex5(:),G1H1(1),ngZu,m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(185),n2h1(251))
  call Hloop_ZQ_A(ntryL,G1H2(378),ex5(:),G1H1(1),ngZu,m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(186),n2h1(252))
  call Hloop_ZQ_A(ntryL,G1H2(347),ex5(:),G1H1(1),ngZu,m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(187),n2h1(253))
  call Hloop_ZQ_A(ntryL,G1H2(384),ex5(:),G1H1(1),ngZu,m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(188),n2h1(254))
  call Hloop_VQ_A(ntryL,G1H2(390),ex5(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(189),n2h1(255))
  call Hloop_ZQ_A(ntryL,G1H2(396),ex5(:),G1H1(1),ngZu,m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(190),n2h1(256))
  call Hloop_VQ_A(ntryL,G1H2(369),ex5(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(191),n2h1(257))
  call Hloop_VQ_A(ntryL,G1H2(365),ex5(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(192),n2h1(258))
  call Hloop_ZQ_A(ntryL,G1H2(381),ex5(:),G1H1(1),ngZu,m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(193),n2h1(259))
  call Hloop_ZQ_A(ntryL,G1H2(377),ex5(:),G1H1(1),ngZu,m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(194),n2h1(260))
  call Hloop_VQ_A(ntryL,G1H2(387),ex5(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(195),n2h1(261))
  call Hloop_VQ_A(ntryL,G1H2(389),ex5(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(196),n2h1(262))
  call Hloop_ZQ_A(ntryL,G1H2(393),ex5(:),G1H1(1),ngZu,m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(197),n2h1(263))
  call Hloop_ZQ_A(ntryL,G1H2(395),ex5(:),G1H1(1),ngZu,m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(198),n2h1(264))
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(17),mass5set(:,1),  & 
G1H2(205),G1H2(206),G1H2(211),G1H2(212),G1H2(217),G1H2(218),2)
  call HG1shiftOLR(G1H2(206),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(17),mass5set(:,2),  & 
G1H2(223),G1H2(224),G1H2(229),G1H2(230),G1H2(235),G1H2(236),2)
  call HG1shiftOLR(G1H2(224),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(17),mass5set(:,12),  & 
G1H2(241),G1H2(242),G1H2(247),G1H2(248),G1H2(253),G1H2(254),2)
  call HG1shiftOLR(G1H2(242),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(17),mass5set(:,13),  & 
G1H2(259),G1H2(260),G1H2(265),G1H2(266),G1H2(271),G1H2(272),2)
  call HG1shiftOLR(G1H2(260),16,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(17),mass5set(:,14),  & 
G1H2(277),G1H2(278),G1H2(283),G1H2(284),G1H2(289),G1H2(290),2)
  call HG1shiftOLR(G1H2(278),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(18),mass5set(:,1),  & 
G1H2(295),G1H2(296),G1H2(301),G1H2(302),G1H2(307),G1H2(308),2)
  call HG1shiftOLR(G1H2(296),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(18),mass5set(:,12),  & 
G1H2(313),G1H2(314),G1H2(319),G1H2(320),G1H2(325),G1H2(326),2)
  call HG1shiftOLR(G1H2(314),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(18),mass5set(:,2),  & 
G1H2(331),G1H2(332),G1H2(337),G1H2(338),G1H2(343),G1H2(344),2)
  call HG1shiftOLR(G1H2(332),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(18),mass5set(:,13),  & 
G1H2(349),G1H2(350),G1H2(355),G1H2(356),G1H2(361),G1H2(362),2)
  call HG1shiftOLR(G1H2(350),16,2)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(19),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(2),12,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(19),mass5set(:,2),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(12),12,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(19),mass5set(:,3),  & 
G1H4(19),G1H4(20),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(20),12,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(19),mass5set(:,4),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(30),12,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(19),mass5set(:,5),  & 
G1H4(37),G1H4(38),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(38),12,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(19),mass5set(:,1),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(48),12,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(19),mass5set(:,2),  & 
G1H4(55),G1H4(56),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(56),12,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(19),mass5set(:,3),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),12,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(19),mass5set(:,4),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),12,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(19),mass5set(:,5),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(78),12,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(20),mass5set(:,1),  & 
G1H4(83),G1H4(84),G1H4(85),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(84),12,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(20),mass5set(:,3),  & 
G1H4(89),G1H4(90),G1H4(91),G1H4(92),G1H4(93),G1H4(94),4)
  call HG1shiftOLR(G1H4(90),12,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(20),mass5set(:,2),  & 
G1H4(95),G1H4(96),G1H4(97),G1H4(98),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(96),12,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(20),mass5set(:,4),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(102),12,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(20),mass5set(:,1),  & 
G1H4(107),G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(108),12,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(20),mass5set(:,3),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(114),12,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(20),mass5set(:,2),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(120),12,4)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(20),mass5set(:,4),  & 
G1H4(125),G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(126),12,4)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(21),mass5set(:,1),  & 
G1H2(367),G1H2(368),G1H2(373),G1H2(374),G1H2(379),G1H2(380),2)
  call HG1shiftOLR(G1H2(368),16,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(21),mass5set(:,2),  & 
G1H2(385),G1H2(386),G1H2(391),G1H2(392),G1H2(1),G1H2(7),2)
  call HG1shiftOLR(G1H2(386),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(21),mass5set(:,12),  & 
G1H2(8),G1H2(13),G1H2(19),G1H2(20),G1H2(25),G1H2(31),2)
  call HG1shiftOLR(G1H2(13),16,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(21),mass5set(:,13),  & 
G1H2(32),G1H2(37),G1H2(43),G1H2(44),G1H2(49),G1H2(55),2)
  call HG1shiftOLR(G1H2(37),16,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(21),mass5set(:,14),  & 
G1H2(56),G1H2(61),G1H2(67),G1H2(68),G1H2(73),G1H2(79),2)
  call HG1shiftOLR(G1H2(61),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(22),mass5set(:,1),  & 
G1H2(80),G1H2(85),G1H2(91),G1H2(92),G1H2(97),G1H2(103),2)
  call HG1shiftOLR(G1H2(85),16,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(22),mass5set(:,12),  & 
G1H2(104),G1H2(109),G1H2(115),G1H2(116),G1H2(121),G1H2(127),2)
  call HG1shiftOLR(G1H2(109),16,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(22),mass5set(:,2),  & 
G1H2(128),G1H2(3),G1H2(4),G1H2(5),G1H2(6),G1H2(10),2)
  call HG1shiftOLR(G1H2(3),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(22),mass5set(:,13),  & 
G1H2(11),G1H2(12),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(12),16,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(23),mass5set(:,1),  & 
G1H2(21),G1H2(22),G1H2(24),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(23),mass5set(:,12),  & 
G1H2(34),G1H2(36),G1H2(39),G1H2(40),G1H2(42),G1H2(46),2)
  call HG1shiftOLR(G1H2(36),8,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(23),mass5set(:,15),  & 
G1H2(48),G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(57),2)
  call HG1shiftOLR(G1H2(51),8,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(23),mass5set(:,16),  & 
G1H2(58),G1H2(59),G1H2(60),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(59),8,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(24),mass5set(:,1),  & 
G1H2(69),G1H2(70),G1H2(72),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(24),mass5set(:,15),  & 
G1H2(81),G1H2(82),G1H2(84),G1H2(88),G1H2(90),G1H2(94),2)
  call HG1shiftOLR(G1H2(82),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(24),mass5set(:,12),  & 
G1H2(96),G1H2(99),G1H2(101),G1H2(102),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(99),8,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(24),mass5set(:,16),  & 
G1H2(111),G1H2(113),G1H2(114),G1H2(117),G1H2(120),G1H2(125),2)
  call HG1shiftOLR(G1H2(113),8,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(24),mass5set(:,17),  & 
G1H2(126),G1H2(132),G1H2(135),G1H2(138),G1H2(144),G1H2(147),2)
  call HG1shiftOLR(G1H2(132),8,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(25),mass5set(:,1),  & 
G1H2(148),G1H2(149),G1H2(153),G1H2(154),G1H2(155),G1H2(160),2)
  call HG1shiftOLR(G1H2(149),2,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(25),mass5set(:,12),  & 
G1H2(161),G1H2(165),G1H2(166),G1H2(172),G1H2(173),G1H2(177),2)
  call HG1shiftOLR(G1H2(165),2,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(25),mass5set(:,15),  & 
G1H2(178),G1H2(184),G1H2(190),G1H2(196),G1H2(198),G1H2(201),2)
  call HG1shiftOLR(G1H2(184),2,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(25),mass5set(:,16),  & 
G1H2(202),G1H2(203),G1H2(208),G1H2(209),G1H2(213),G1H2(214),2)
  call HG1shiftOLR(G1H2(203),2,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(26),mass5set(:,1),  & 
G1H2(219),G1H2(220),G1H2(221),G1H2(226),G1H2(232),G1H2(233),2)
  call HG1shiftOLR(G1H2(220),2,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(26),mass5set(:,12),  & 
G1H2(237),G1H2(238),G1H2(244),G1H2(250),G1H2(252),G1H2(255),2)
  call HG1shiftOLR(G1H2(238),2,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(26),mass5set(:,15),  & 
G1H2(257),G1H2(263),G1H2(267),G1H2(273),G1H2(275),G1H2(287),2)
  call HG1shiftOLR(G1H2(263),2,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(26),mass5set(:,16),  & 
G1H2(291),G1H2(303),G1H2(305),G1H2(306),G1H2(309),G1H2(311),2)
  call HG1shiftOLR(G1H2(303),2,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(26),mass5set(:,17),  & 
G1H2(312),G1H2(315),G1H2(318),G1H2(323),G1H2(324),G1H2(327),2)
  call HG1shiftOLR(G1H2(315),2,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(199),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex4(:),G2tensor(200),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(46),ex4(:),G2tensor(201),ngZl,m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(202),ngZl,m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex4(:),G2tensor(203),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(51),ex4(:),G2tensor(204),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(52),ex4(:),G2tensor(205),ngZl,m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(54),ex4(:),G2tensor(206),ngZl,m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(55),ex4(:),G2tensor(207),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(57),ex4(:),G2tensor(208),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(58),ex3(:),G2tensor(209),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(60),ex3(:),G2tensor(210),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(61),ex3(:),G2tensor(211),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(63),ex3(:),G2tensor(212),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(64),ex3(:),G2tensor(213),ngZl,m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(66),ex3(:),G2tensor(214),ngZl,m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(67),ex3(:),G2tensor(215),ngZl,m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(69),ex3(:),G2tensor(216),ngZl,m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(70),ex3(:),G2tensor(217),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(72),ex3(:),G2tensor(218),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(73),ex4(:),G2tensor(219),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(75),ex4(:),G2tensor(220),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hloop_WQ_A(ntryL,G1H2(133),ex5(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(221),n2h1(265))
  call Hloop_WQ_A(ntryL,G1H2(134),ex5(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(222),n2h1(266))
  call Hloop_WQ_A(ntryL,G1H2(146),ex5(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(223),n2h1(267))
  call Hloop_WQ_A(ntryL,G1H2(151),ex5(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(224),n2h1(268))
  call Hloop_WQ_A(ntryL,G1H2(152),ex5(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(225),n2h1(269))
  call Hloop_WQ_A(ntryL,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(226),n2h1(270))
  call Hloop_WQ_A(ntryL,G1H2(169),ex5(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(227),n2h1(271))
  call Hloop_WQ_A(ntryL,G1H2(170),ex5(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(228),n2h1(272))
  call Hloop_WQ_A(ntryL,G1H2(182),ex5(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(229),n2h1(273))
  call Hloop_WQ_A(ntryL,G1H2(187),ex5(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(230),n2h1(274))
  call Hloop_WQ_A(ntryL,G1H2(188),ex5(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(231),n2h1(275))
  call Hloop_WQ_A(ntryL,G1H2(200),ex5(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(232),n2h1(276))
  call Hloop_VQ_A(ntryL,G1H2(205),ex5(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(233),n2h1(277))
  call Hloop_VQ_A(ntryL,G1H2(206),ex5(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(234),n2h1(278))
  call Hloop_VQ_A(ntryL,G1H2(218),ex5(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(235),n2h1(279))
  call Hloop_VQ_A(ntryL,G1H2(223),ex5(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(236),n2h1(280))
  call Hloop_VQ_A(ntryL,G1H2(224),ex5(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(237),n2h1(281))
  call Hloop_VQ_A(ntryL,G1H2(236),ex5(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(238),n2h1(282))
  call Hloop_ZQ_A(ntryL,G1H2(241),ex5(:),G1H1(1),ngZu,m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(239),n2h1(283))
  call Hloop_ZQ_A(ntryL,G1H2(242),ex5(:),G1H1(1),ngZu,m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(240),n2h1(284))
  call Hloop_ZQ_A(ntryL,G1H2(254),ex5(:),G1H1(1),ngZu,m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(241),n2h1(285))
  call Hloop_ZQ_A(ntryL,G1H2(259),ex5(:),G1H1(1),ngZu,m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(242),n2h1(286))
  call Hloop_ZQ_A(ntryL,G1H2(260),ex5(:),G1H1(1),ngZu,m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(243),n2h1(287))
  call Hloop_ZQ_A(ntryL,G1H2(272),ex5(:),G1H1(1),ngZu,m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(244),n2h1(288))
  call Hloop_WQ_A(ntryL,G1H2(277),ex5(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(245),n2h1(289))
  call Hloop_WQ_A(ntryL,G1H2(278),ex5(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(246),n2h1(290))
  call Hloop_WQ_A(ntryL,G1H2(290),ex5(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(247),n2h1(291))
  call Hloop_VQ_A(ntryL,G1H2(295),ex5(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(248),n2h1(292))
  call Hloop_VQ_A(ntryL,G1H2(296),ex5(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(249),n2h1(293))
  call Hloop_VQ_A(ntryL,G1H2(308),ex5(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(250),n2h1(294))
  call Hloop_ZQ_A(ntryL,G1H2(313),ex5(:),G1H1(1),ngZu,m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(251),n2h1(295))
  call Hloop_ZQ_A(ntryL,G1H2(314),ex5(:),G1H1(1),ngZu,m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(252),n2h1(296))
  call Hloop_ZQ_A(ntryL,G1H2(326),ex5(:),G1H1(1),ngZu,m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(253),n2h1(297))
  call Hloop_VQ_A(ntryL,G1H2(331),ex5(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(254),n2h1(298))
  call Hloop_VQ_A(ntryL,G1H2(332),ex5(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(255),n2h1(299))
  call Hloop_VQ_A(ntryL,G1H2(344),ex5(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(256),n2h1(300))
  call Hloop_ZQ_A(ntryL,G1H2(349),ex5(:),G1H1(1),ngZu,m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(257),n2h1(301))
  call Hloop_ZQ_A(ntryL,G1H2(350),ex5(:),G1H1(1),ngZu,m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(258),n2h1(302))
  call Hloop_ZQ_A(ntryL,G1H2(362),ex5(:),G1H1(1),ngZu,m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(259),n2h1(303))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(260),n2h1(304))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(261),n2h1(305))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(262),n2h1(306))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,2),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(263),n2h1(307))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,2),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(264),n2h1(308))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,2),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(265),n2h1(309))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(266),n2h1(310))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,2),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(267),n2h1(311))
  call Hloop_QV_A(ntryL,G1H4(26),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(268),n2h1(312))
  call Hloop_QV_A(ntryL,G1H4(29),wf4(:,2),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(269),n2h1(313))
  call Hloop_QV_A(ntryL,G1H4(30),wf4(:,2),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(270),n2h1(314))
  call Hloop_QV_A(ntryL,G1H4(36),wf4(:,2),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(271),n2h1(315))
  call Hloop_QV_A(ntryL,G1H4(37),wf4(:,2),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(272),n2h1(316))
  call Hloop_QV_A(ntryL,G1H4(38),wf4(:,2),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(273),n2h1(317))
  call Hloop_QV_A(ntryL,G1H4(44),wf4(:,2),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(274),n2h1(318))
  call Hloop_QZ_A(ntryL,G1H4(47),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,16),heltab2x4(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(275),n2h1(319))
  call Hloop_QZ_A(ntryL,G1H4(48),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,17),heltab2x4(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(276),n2h1(320))
  call Hloop_QZ_A(ntryL,G1H4(54),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,18),heltab2x4(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(277),n2h1(321))
  call Hloop_QZ_A(ntryL,G1H4(55),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,19),heltab2x4(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(278),n2h1(322))
  call Hloop_QZ_A(ntryL,G1H4(56),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,20),heltab2x4(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(279),n2h1(323))
  call Hloop_QZ_A(ntryL,G1H4(62),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,21),heltab2x4(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(280),n2h1(324))
  call Hloop_QZ_A(ntryL,G1H4(65),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,22),heltab2x4(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(281),n2h1(325))
  call Hloop_QZ_A(ntryL,G1H4(66),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,23),heltab2x4(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(282),n2h1(326))
  call Hloop_QZ_A(ntryL,G1H4(70),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,24),heltab2x4(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(283),n2h1(327))
  call Hloop_QZ_A(ntryL,G1H4(71),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,25),heltab2x4(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(284),n2h1(328))
  call Hloop_QZ_A(ntryL,G1H4(72),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,26),heltab2x4(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(285),n2h1(329))
  call Hloop_QZ_A(ntryL,G1H4(76),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,27),heltab2x4(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(286),n2h1(330))
  call Hloop_QZ_A(ntryL,G1H4(77),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,28),heltab2x4(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(287),n2h1(331))
  call Hloop_QZ_A(ntryL,G1H4(78),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,29),heltab2x4(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(288),n2h1(332))
  call Hloop_QZ_A(ntryL,G1H4(82),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,30),heltab2x4(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(289),n2h1(333))
  call Hloop_QV_A(ntryL,G1H4(83),wf4(:,2),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(290),n2h1(334))
  call Hloop_QV_A(ntryL,G1H4(84),wf4(:,2),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(291),n2h1(335))
  call Hloop_QV_A(ntryL,G1H4(88),wf4(:,2),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(292),n2h1(336))
  call Hloop_QV_A(ntryL,G1H4(89),wf4(:,2),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(293),n2h1(337))
  call Hloop_QV_A(ntryL,G1H4(90),wf4(:,2),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(294),n2h1(338))
  call Hloop_QV_A(ntryL,G1H4(94),wf4(:,2),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(295),n2h1(339))
  call Hloop_QV_A(ntryL,G1H4(95),wf4(:,2),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(296),n2h1(340))
  call Hloop_QV_A(ntryL,G1H4(96),wf4(:,2),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(297),n2h1(341))
  call Hloop_QV_A(ntryL,G1H4(100),wf4(:,2),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(298),n2h1(342))
  call Hloop_QV_A(ntryL,G1H4(101),wf4(:,2),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(299),n2h1(343))
  call Hloop_QV_A(ntryL,G1H4(102),wf4(:,2),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(300),n2h1(344))
  call Hloop_QV_A(ntryL,G1H4(106),wf4(:,2),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(301),n2h1(345))
  call Hloop_QZ_A(ntryL,G1H4(107),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,43),heltab2x4(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(302),n2h1(346))
  call Hloop_QZ_A(ntryL,G1H4(108),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,44),heltab2x4(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(303),n2h1(347))
  call Hloop_QZ_A(ntryL,G1H4(112),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,45),heltab2x4(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(304),n2h1(348))
  call Hloop_QZ_A(ntryL,G1H4(113),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,46),heltab2x4(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(305),n2h1(349))
  call Hloop_QZ_A(ntryL,G1H4(114),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,47),heltab2x4(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(306),n2h1(350))
  call Hloop_QZ_A(ntryL,G1H4(118),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,48),heltab2x4(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(307),n2h1(351))
  call Hloop_QZ_A(ntryL,G1H4(119),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,49),heltab2x4(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(308),n2h1(352))
  call Hloop_QZ_A(ntryL,G1H4(120),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,50),heltab2x4(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(309),n2h1(353))
  call Hloop_QZ_A(ntryL,G1H4(124),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,51),heltab2x4(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(310),n2h1(354))
  call Hloop_QZ_A(ntryL,G1H4(125),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,52),heltab2x4(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(311),n2h1(355))
  call Hloop_QZ_A(ntryL,G1H4(126),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,53),heltab2x4(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(312),n2h1(356))
  call Hloop_QZ_A(ntryL,G1H4(130),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,54),heltab2x4(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(313),n2h1(357))
  call Hloop_VQ_A(ntryL,G1H2(367),ex5(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(314),n2h1(358))
  call Hloop_VQ_A(ntryL,G1H2(368),ex5(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(315),n2h1(359))
  call Hloop_VQ_A(ntryL,G1H2(380),ex5(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(316),n2h1(360))
  call Hloop_VQ_A(ntryL,G1H2(385),ex5(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(317),n2h1(361))
  call Hloop_VQ_A(ntryL,G1H2(386),ex5(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(318),n2h1(362))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(319),n2h1(363))
  call Hloop_ZQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),ngZu,m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(320),n2h1(364))
  call Hloop_ZQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),ngZu,m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(321),n2h1(365))
  call Hloop_ZQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),ngZu,m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(322),n2h1(366))
  call Hloop_ZQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),ngZu,m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(323),n2h1(367))
  call Hloop_ZQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),ngZu,m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(324),n2h1(368))
  call Hloop_ZQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),ngZu,m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(325),n2h1(369))
  call Hloop_WQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(326),n2h1(370))
  call Hloop_WQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(327),n2h1(371))
  call Hloop_WQ_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(328),n2h1(372))
  call Hloop_VQ_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(329),n2h1(373))
  call Hloop_VQ_A(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(330),n2h1(374))
  call Hloop_VQ_A(ntryL,G1H2(103),ex5(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(331),n2h1(375))
  call Hloop_ZQ_A(ntryL,G1H2(104),ex5(:),G1H1(1),ngZu,m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(332),n2h1(376))
  call Hloop_ZQ_A(ntryL,G1H2(109),ex5(:),G1H1(1),ngZu,m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(333),n2h1(377))
  call Hloop_ZQ_A(ntryL,G1H2(127),ex5(:),G1H1(1),ngZu,m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(334),n2h1(378))
  call Hloop_VQ_A(ntryL,G1H2(128),ex5(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(335),n2h1(379))
  call Hloop_VQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(336),n2h1(380))
  call Hloop_VQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(337),n2h1(381))
  call Hloop_ZQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),ngZu,m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(338),n2h1(382))
  call Hloop_ZQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),ngZu,m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(339),n2h1(383))
  call Hloop_ZQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),ngZu,m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(340),n2h1(384))
  call Hloop_VA_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(341),n2h1(385))
  call Hloop_VA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(342),n2h1(386))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(343),n2h1(387))
  call Hloop_ZA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),ngZl,m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(344),n2h1(388))
  call Hloop_ZA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),ngZl,m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(345),n2h1(389))
  call Hloop_ZA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),ngZl,m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(346),n2h1(390))
  call Hloop_VA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(347),n2h1(391))
  call Hloop_VA_Q(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(348),n2h1(392))
  call Hloop_VA_Q(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(349),n2h1(393))
  call Hloop_ZA_Q(ntryL,G1H2(58),ex4(:),G1H1(1),ngZl,m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(350),n2h1(394))
  call Hloop_ZA_Q(ntryL,G1H2(59),ex4(:),G1H1(1),ngZl,m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(351),n2h1(395))
  call Hloop_ZA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),ngZl,m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(352),n2h1(396))
  call Hloop_VA_Q(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(353),n2h1(397))
  call Hloop_VA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(354),n2h1(398))
  call Hloop_VA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(355),n2h1(399))
  call Hloop_VA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(356),n2h1(400))
  call Hloop_VA_Q(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(357),n2h1(401))
  call Hloop_VA_Q(ntryL,G1H2(94),ex4(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(358),n2h1(402))
  call Hloop_ZA_Q(ntryL,G1H2(96),ex4(:),G1H1(1),ngZl,m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(359),n2h1(403))
  call Hloop_ZA_Q(ntryL,G1H2(99),ex4(:),G1H1(1),ngZl,m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(360),n2h1(404))
  call Hloop_ZA_Q(ntryL,G1H2(108),ex4(:),G1H1(1),ngZl,m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(361),n2h1(405))
  call Hloop_ZA_Q(ntryL,G1H2(111),ex4(:),G1H1(1),ngZl,m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(362),n2h1(406))
  call Hloop_ZA_Q(ntryL,G1H2(113),ex4(:),G1H1(1),ngZl,m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(363),n2h1(407))
  call Hloop_ZA_Q(ntryL,G1H2(125),ex4(:),G1H1(1),ngZl,m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(364),n2h1(408))
  call Hloop_WA_Q(ntryL,G1H2(126),ex4(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(365),n2h1(409))
  call Hloop_WA_Q(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(366),n2h1(410))
  call Hloop_WA_Q(ntryL,G1H2(147),ex4(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(367),n2h1(411))
  call Hloop_VA_Q(ntryL,G1H2(148),ex2(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(368),n2h1(412))
  call Hloop_VA_Q(ntryL,G1H2(149),ex2(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(369),n2h1(413))
  call Hloop_VA_Q(ntryL,G1H2(160),ex2(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(370),n2h1(414))
  call Hloop_ZA_Q(ntryL,G1H2(161),ex2(:),G1H1(1),ngZl,m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(371),n2h1(415))
  call Hloop_ZA_Q(ntryL,G1H2(165),ex2(:),G1H1(1),ngZl,m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(372),n2h1(416))
  call Hloop_ZA_Q(ntryL,G1H2(177),ex2(:),G1H1(1),ngZl,m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(373),n2h1(417))
  call Hloop_VA_Q(ntryL,G1H2(178),ex2(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(374),n2h1(418))
  call Hloop_VA_Q(ntryL,G1H2(184),ex2(:),G1H1(1),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(375),n2h1(419))
  call Hloop_VA_Q(ntryL,G1H2(201),ex2(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(376),n2h1(420))
  call Hloop_ZA_Q(ntryL,G1H2(202),ex2(:),G1H1(1),ngZl,m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(377),n2h1(421))
  call Hloop_ZA_Q(ntryL,G1H2(203),ex2(:),G1H1(1),ngZl,m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(378),n2h1(422))
  call Hloop_ZA_Q(ntryL,G1H2(214),ex2(:),G1H1(1),ngZl,m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(379),n2h1(423))
  call Hloop_VA_Q(ntryL,G1H2(219),ex2(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(380),n2h1(424))
  call Hloop_VA_Q(ntryL,G1H2(220),ex2(:),G1H1(1),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(381),n2h1(425))
  call Hloop_VA_Q(ntryL,G1H2(233),ex2(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(382),n2h1(426))
  call Hloop_ZA_Q(ntryL,G1H2(237),ex2(:),G1H1(1),ngZl,m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(383),n2h1(427))
  call Hloop_ZA_Q(ntryL,G1H2(238),ex2(:),G1H1(1),ngZl,m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(384),n2h1(428))
  call Hloop_ZA_Q(ntryL,G1H2(255),ex2(:),G1H1(1),ngZl,m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(385),n2h1(429))
  call Hloop_VA_Q(ntryL,G1H2(257),ex2(:),G1H1(1),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(386),n2h1(430))
  call Hloop_VA_Q(ntryL,G1H2(263),ex2(:),G1H1(1),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(387),n2h1(431))
  call Hloop_VA_Q(ntryL,G1H2(287),ex2(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(388),n2h1(432))
  call Hloop_ZA_Q(ntryL,G1H2(291),ex2(:),G1H1(1),ngZl,m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(389),n2h1(433))
  call Hloop_ZA_Q(ntryL,G1H2(303),ex2(:),G1H1(1),ngZl,m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(390),n2h1(434))
  call Hloop_ZA_Q(ntryL,G1H2(311),ex2(:),G1H1(1),ngZl,m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(391),n2h1(435))
  call Hloop_WA_Q(ntryL,G1H2(312),ex2(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(392),n2h1(436))
  call Hloop_WA_Q(ntryL,G1H2(315),ex2(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(393),n2h1(437))
  call Hloop_WA_Q(ntryL,G1H2(327),ex2(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(394),n2h1(438))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(62)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(68)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(74)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(80)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(86)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(92)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(98)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(104)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(110)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(116)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(122)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(128)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(134)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(140)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(146)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(152)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(158)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(164)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(170)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(176)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(182)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(188)])
  call ol_merge_tensors(G2tensor(217),[G2tensor(66),G1tensor(194)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(200)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(206)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(212)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(218)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(224)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(230)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(236)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(242)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(248)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(254)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(260)])
  call ol_merge_tensors(G2tensor(90),[G1tensor(266)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(272)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(278)])
  call ol_merge_tensors(G2tensor(96),[G1tensor(284)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(290)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(296)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(302)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(308)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(314)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(320)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(326)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(332)])
  call ol_merge_tensors(G2tensor(114),[G1tensor(338)])
  call ol_merge_tensors(G2tensor(116),[G1tensor(344)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(350)])
  call ol_merge_tensors(G2tensor(120),[G1tensor(356)])
  call ol_merge_tensors(G2tensor(122),[G1tensor(362)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(368)])
  call ol_merge_tensors(G2tensor(126),[G1tensor(374)])
  call ol_merge_tensors(G2tensor(128),[G1tensor(380)])
  call ol_merge_tensors(G2tensor(130),[G1tensor(386)])
  call ol_merge_tensors(G2tensor(132),[G1tensor(392)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(9),G1tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(100),G1tensor(4)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(23),G1tensor(5)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(204),G1tensor(6)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(106),G1tensor(10)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(35),G1tensor(11)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(210),G1tensor(12)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(27),G1tensor(15)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(112),G1tensor(16)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(41),G1tensor(17)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(222),G1tensor(18)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(33),G1tensor(21)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(118),G1tensor(22)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(216),G1tensor(24)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(124),G1tensor(28)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(47),G1tensor(29)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(234),G1tensor(30)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(130),G1tensor(34)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(228),G1tensor(36)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(45),G1tensor(39)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(136),G1tensor(40)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(240),G1tensor(42)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(142),G1tensor(46)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(246),G1tensor(48)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(63),G1tensor(51)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(304),G1tensor(52)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(71),G1tensor(53)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(150),G1tensor(54)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(75),G1tensor(57)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(310),G1tensor(58)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(83),G1tensor(59)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(156),G1tensor(60)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(322),G1tensor(64)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(89),G1tensor(65)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(162),G1tensor(66)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(87),G1tensor(69)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(316),G1tensor(70)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(168),G1tensor(72)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(334),G1tensor(76)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(95),G1tensor(77)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(174),G1tensor(78)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(93),G1tensor(81)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(328),G1tensor(82)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(180),G1tensor(84)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(340),G1tensor(88)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(186),G1tensor(90)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(346),G1tensor(94)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(192),G1tensor(96)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(105),G1tensor(99)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(119),G1tensor(101)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(258),G1tensor(102)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(131),G1tensor(107)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(264),G1tensor(108)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(123),G1tensor(111)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(137),G1tensor(113)])
  call ol_merge_tensors(G2tensor(111),[G1tensor(276),G1tensor(114)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(129),G1tensor(117)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(270),G1tensor(120)])
  call ol_merge_tensors(G2tensor(117),[G1tensor(143),G1tensor(125)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(288),G1tensor(126)])
  call ol_merge_tensors(G2tensor(121),[G1tensor(282),G1tensor(132)])
  call ol_merge_tensors(G2tensor(123),[G1tensor(141),G1tensor(135)])
  call ol_merge_tensors(G2tensor(125),[G1tensor(294),G1tensor(138)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(300),G1tensor(144)])
  call ol_merge_tensors(G2tensor(129),[G1tensor(159),G1tensor(147)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(352),G1tensor(148)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(167),G1tensor(149)])
  call ol_merge_tensors(G2tensor(134),[G1tensor(171),G1tensor(153)])
  call ol_merge_tensors(G2tensor(135),[G1tensor(358),G1tensor(154)])
  call ol_merge_tensors(G2tensor(136),[G1tensor(179),G1tensor(155)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(370),G1tensor(160)])
  call ol_merge_tensors(G2tensor(138),[G1tensor(185),G1tensor(161)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(183),G1tensor(165)])
  call ol_merge_tensors(G2tensor(140),[G1tensor(364),G1tensor(166)])
  call ol_merge_tensors(G2tensor(141),[G1tensor(382),G1tensor(172)])
  call ol_merge_tensors(G2tensor(142),[G1tensor(191),G1tensor(173)])
  call ol_merge_tensors(G2tensor(143),[G1tensor(189),G1tensor(177)])
  call ol_merge_tensors(G2tensor(144),[G1tensor(376),G1tensor(178)])
  call ol_merge_tensors(G2tensor(145),[G1tensor(388),G1tensor(184)])
  call ol_merge_tensors(G2tensor(146),[G1tensor(394),G1tensor(190)])
  call ol_merge_tensors(G2tensor(147),[G1tensor(195)])
  call ol_merge_tensors(G2tensor(221),[G1tensor(196)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(197)])
  call ol_merge_tensors(G2tensor(224),[G1tensor(198)])
  call ol_merge_tensors(G2tensor(149),[G1tensor(207),G1tensor(201)])
  call ol_merge_tensors(G2tensor(150),[G1tensor(256),G1tensor(202)])
  call ol_merge_tensors(G2tensor(151),[G1tensor(215),G1tensor(203)])
  call ol_merge_tensors(G2tensor(152),[G1tensor(262),G1tensor(208)])
  call ol_merge_tensors(G2tensor(153),[G1tensor(227),G1tensor(209)])
  call ol_merge_tensors(G2tensor(154),[G1tensor(225),G1tensor(213)])
  call ol_merge_tensors(G2tensor(155),[G1tensor(268),G1tensor(214)])
  call ol_merge_tensors(G2tensor(156),[G1tensor(231),G1tensor(219)])
  call ol_merge_tensors(G2tensor(157),[G1tensor(274),G1tensor(220)])
  call ol_merge_tensors(G2tensor(158),[G1tensor(239),G1tensor(221)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(280),G1tensor(226)])
  call ol_merge_tensors(G2tensor(160),[G1tensor(286),G1tensor(232)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(245),G1tensor(233)])
  call ol_merge_tensors(G2tensor(162),[G1tensor(243),G1tensor(237)])
  call ol_merge_tensors(G2tensor(163),[G1tensor(292),G1tensor(238)])
  call ol_merge_tensors(G2tensor(164),[G1tensor(298),G1tensor(244)])
  call ol_merge_tensors(G2tensor(165),[G1tensor(249)])
  call ol_merge_tensors(G2tensor(227),[G1tensor(250)])
  call ol_merge_tensors(G2tensor(166),[G1tensor(251)])
  call ol_merge_tensors(G2tensor(230),[G1tensor(252)])
  call ol_merge_tensors(G2tensor(167),[G1tensor(261),G1tensor(255)])
  call ol_merge_tensors(G2tensor(168),[G1tensor(269),G1tensor(257)])
  call ol_merge_tensors(G2tensor(169),[G1tensor(281),G1tensor(263)])
  call ol_merge_tensors(G2tensor(170),[G1tensor(279),G1tensor(267)])
  call ol_merge_tensors(G2tensor(171),[G1tensor(285),G1tensor(273)])
  call ol_merge_tensors(G2tensor(172),[G1tensor(293),G1tensor(275)])
  call ol_merge_tensors(G2tensor(173),[G1tensor(299),G1tensor(287)])
  call ol_merge_tensors(G2tensor(174),[G1tensor(297),G1tensor(291)])
  call ol_merge_tensors(G2tensor(175),[G1tensor(321),G1tensor(303)])
  call ol_merge_tensors(G2tensor(176),[G1tensor(317),G1tensor(305)])
  call ol_merge_tensors(G2tensor(177),[G1tensor(354),G1tensor(306)])
  call ol_merge_tensors(G2tensor(178),[G1tensor(333),G1tensor(309)])
  call ol_merge_tensors(G2tensor(179),[G1tensor(329),G1tensor(311)])
  call ol_merge_tensors(G2tensor(180),[G1tensor(360),G1tensor(312)])
  call ol_merge_tensors(G2tensor(181),[G1tensor(339),G1tensor(315)])
  call ol_merge_tensors(G2tensor(182),[G1tensor(366),G1tensor(318)])
  call ol_merge_tensors(G2tensor(183),[G1tensor(341),G1tensor(323)])
  call ol_merge_tensors(G2tensor(184),[G1tensor(372),G1tensor(324)])
  call ol_merge_tensors(G2tensor(185),[G1tensor(345),G1tensor(327)])
  call ol_merge_tensors(G2tensor(186),[G1tensor(378),G1tensor(330)])
  call ol_merge_tensors(G2tensor(187),[G1tensor(347),G1tensor(335)])
  call ol_merge_tensors(G2tensor(188),[G1tensor(384),G1tensor(336)])
  call ol_merge_tensors(G2tensor(189),[G1tensor(390),G1tensor(342)])
  call ol_merge_tensors(G2tensor(190),[G1tensor(396),G1tensor(348)])
  call ol_merge_tensors(G2tensor(191),[G1tensor(369),G1tensor(351)])
  call ol_merge_tensors(G2tensor(192),[G1tensor(365),G1tensor(353)])
  call ol_merge_tensors(G2tensor(193),[G1tensor(381),G1tensor(357)])
  call ol_merge_tensors(G2tensor(194),[G1tensor(377),G1tensor(359)])
  call ol_merge_tensors(G2tensor(195),[G1tensor(387),G1tensor(363)])
  call ol_merge_tensors(G2tensor(196),[G1tensor(389),G1tensor(371)])
  call ol_merge_tensors(G2tensor(197),[G1tensor(393),G1tensor(375)])
  call ol_merge_tensors(G2tensor(198),[G1tensor(395),G1tensor(383)])
  call ol_merge_tensors(G2tensor(275),[G2tensor(260)])
  call ol_merge_tensors(G2tensor(278),[G2tensor(263)])
  call ol_merge_tensors(G2tensor(281),[G2tensor(266)])
  call ol_merge_tensors(G2tensor(284),[G2tensor(269)])
  call ol_merge_tensors(G2tensor(287),[G2tensor(272)])
  call ol_merge_tensors(G2tensor(302),[G2tensor(290)])
  call ol_merge_tensors(G2tensor(305),[G2tensor(293)])
  call ol_merge_tensors(G2tensor(308),[G2tensor(296)])
  call ol_merge_tensors(G2tensor(311),[G2tensor(299)])
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(27),mass5set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(27),mass5set(:,2),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),2)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(27),mass5set(:,6),  & 
G1tensor(73),G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103))
  call G_TensorShift(G1tensor(79),2)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(27),mass5set(:,3),  & 
G1tensor(109),G1tensor(115),G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139))
  call G_TensorShift(G1tensor(115),2)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(27),mass5set(:,18),  & 
G1tensor(145),G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(151),2)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(27),mass5set(:,4),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205),G1tensor(211))
  call G_TensorShift(G1tensor(187),2)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(27),mass5set(:,7),  & 
G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235),G1tensor(241),G1tensor(247))
  call G_TensorShift(G1tensor(223),2)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(27),mass5set(:,19),  & 
G1tensor(253),G1tensor(259),G1tensor(265),G1tensor(271),G1tensor(277),G1tensor(283))
  call G_TensorShift(G1tensor(259),2)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(28),mass5set(:,1),  & 
G1tensor(289),G1tensor(295),G1tensor(301),G1tensor(307),G1tensor(313),G1tensor(319))
  call G_TensorShift(G1tensor(295),8)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(28),mass5set(:,6),  & 
G1tensor(325),G1tensor(331),G1tensor(337),G1tensor(343),G1tensor(349),G1tensor(355))
  call G_TensorShift(G1tensor(331),8)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(28),mass5set(:,2),  & 
G1tensor(361),G1tensor(367),G1tensor(373),G1tensor(379),G1tensor(385),G1tensor(391))
  call G_TensorShift(G1tensor(367),8)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(28),mass5set(:,3),  & 
G1tensor(2),G1tensor(8),G1tensor(14),G1tensor(20),G1tensor(26),G1tensor(32))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(28),mass5set(:,18),  & 
G1tensor(38),G1tensor(44),G1tensor(50),G1tensor(56),G1tensor(62),G1tensor(68))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(28),mass5set(:,7),  & 
G1tensor(74),G1tensor(80),G1tensor(86),G1tensor(92),G1tensor(98),G1tensor(104))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(28),mass5set(:,4),  & 
G1tensor(110),G1tensor(116),G1tensor(122),G1tensor(128),G1tensor(134),G1tensor(140))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(28),mass5set(:,19),  & 
G1tensor(146),G1tensor(152),G1tensor(158),G1tensor(164),G1tensor(170),G1tensor(176))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(29),mass5set(:,1),  & 
G1tensor(182),G1tensor(188),G1tensor(194),G1tensor(200),G1tensor(206),G1tensor(212))
  call G_TensorShift(G1tensor(188),2)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(29),mass5set(:,2),  & 
G1tensor(218),G1tensor(224),G1tensor(230),G1tensor(236),G1tensor(242),G1tensor(248))
  call G_TensorShift(G1tensor(224),2)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(29),mass5set(:,6),  & 
G1tensor(254),G1tensor(260),G1tensor(266),G1tensor(272),G1tensor(278),G1tensor(284))
  call G_TensorShift(G1tensor(260),2)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(29),mass5set(:,3),  & 
G1tensor(290),G1tensor(296),G1tensor(302),G1tensor(308),G1tensor(314),G1tensor(320))
  call G_TensorShift(G1tensor(296),2)
  call Hotf_5pt_reduction_last(G2tensor(42),RedSet_5(29),mass5set(:,18),  & 
G1tensor(326),G1tensor(332),G1tensor(338),G1tensor(344),G1tensor(350),G1tensor(356))
  call G_TensorShift(G1tensor(332),2)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(29),mass5set(:,4),  & 
G1tensor(362),G1tensor(368),G1tensor(374),G1tensor(380),G1tensor(386),G1tensor(392))
  call G_TensorShift(G1tensor(368),2)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(29),mass5set(:,7),  & 
G1tensor(9),G1tensor(3),G1tensor(100),G1tensor(4),G1tensor(23),G1tensor(5))
  call G_TensorShift(G1tensor(3),2)
  call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(29),mass5set(:,19),  & 
G1tensor(204),G1tensor(6),G1tensor(106),G1tensor(10),G1tensor(35),G1tensor(11))
  call G_TensorShift(G1tensor(6),2)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(11),mass5set(:,1),  & 
G1tensor(210),G1tensor(12),G1tensor(27),G1tensor(15),G1tensor(112),G1tensor(16))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(11),mass5set(:,6),  & 
G1tensor(41),G1tensor(17),G1tensor(222),G1tensor(18),G1tensor(33),G1tensor(21))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(11),mass5set(:,2),  & 
G1tensor(118),G1tensor(22),G1tensor(216),G1tensor(24),G1tensor(124),G1tensor(28))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_5pt_reduction_last(G2tensor(56),RedSet_5(11),mass5set(:,3),  & 
G1tensor(47),G1tensor(29),G1tensor(234),G1tensor(30),G1tensor(130),G1tensor(34))
  call G_TensorShift(G1tensor(29),4)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(11),mass5set(:,18),  & 
G1tensor(228),G1tensor(36),G1tensor(45),G1tensor(39),G1tensor(136),G1tensor(40))
  call G_TensorShift(G1tensor(36),4)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(11),mass5set(:,7),  & 
G1tensor(240),G1tensor(42),G1tensor(142),G1tensor(46),G1tensor(246),G1tensor(48))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_5pt_reduction_last(G2tensor(62),RedSet_5(11),mass5set(:,4),  & 
G1tensor(63),G1tensor(51),G1tensor(304),G1tensor(52),G1tensor(71),G1tensor(53))
  call G_TensorShift(G1tensor(51),4)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(11),mass5set(:,19),  & 
G1tensor(150),G1tensor(54),G1tensor(75),G1tensor(57),G1tensor(310),G1tensor(58))
  call G_TensorShift(G1tensor(54),4)
  call Hotf_5pt_reduction_last(G2tensor(217),RedSet_5(11),mass5set(:,9),  & 
G1tensor(83),G1tensor(59),G1tensor(156),G1tensor(60),G1tensor(322),G1tensor(64))
  call G_TensorShift(G1tensor(59),4)
  call Hotf_5pt_reduction_last(G2tensor(68),RedSet_5(30),mass5set(:,1),  & 
G1tensor(89),G1tensor(65),G1tensor(162),G1tensor(66),G1tensor(87),G1tensor(69))
  call G_TensorShift(G1tensor(65),1)
  call Hotf_5pt_reduction_last(G2tensor(70),RedSet_5(30),mass5set(:,2),  & 
G1tensor(316),G1tensor(70),G1tensor(168),G1tensor(72),G1tensor(334),G1tensor(76))
  call G_TensorShift(G1tensor(70),1)
  call Hotf_5pt_reduction_last(G2tensor(72),RedSet_5(30),mass5set(:,3),  & 
G1tensor(95),G1tensor(77),G1tensor(174),G1tensor(78),G1tensor(93),G1tensor(81))
  call G_TensorShift(G1tensor(77),1)
  call Hotf_5pt_reduction_last(G2tensor(74),RedSet_5(30),mass5set(:,6),  & 
G1tensor(328),G1tensor(82),G1tensor(180),G1tensor(84),G1tensor(340),G1tensor(88))
  call G_TensorShift(G1tensor(82),1)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(30),mass5set(:,4),  & 
G1tensor(186),G1tensor(90),G1tensor(346),G1tensor(94),G1tensor(192),G1tensor(96))
  call G_TensorShift(G1tensor(90),1)
  call Hotf_5pt_reduction_last(G2tensor(78),RedSet_5(30),mass5set(:,18),  & 
G1tensor(105),G1tensor(99),G1tensor(119),G1tensor(101),G1tensor(258),G1tensor(102))
  call G_TensorShift(G1tensor(99),1)
  call Hotf_5pt_reduction_last(G2tensor(80),RedSet_5(30),mass5set(:,7),  & 
G1tensor(131),G1tensor(107),G1tensor(264),G1tensor(108),G1tensor(123),G1tensor(111))
  call G_TensorShift(G1tensor(107),1)
  call Hotf_5pt_reduction_last(G2tensor(82),RedSet_5(30),mass5set(:,19),  & 
G1tensor(137),G1tensor(113),G1tensor(276),G1tensor(114),G1tensor(129),G1tensor(117))
  call G_TensorShift(G1tensor(113),1)
  call Hotf_5pt_reduction_last(G2tensor(84),RedSet_5(30),mass5set(:,9),  & 
G1tensor(270),G1tensor(120),G1tensor(143),G1tensor(125),G1tensor(288),G1tensor(126))
  call G_TensorShift(G1tensor(120),1)
  call Hotf_5pt_reduction_last(G2tensor(86),RedSet_5(31),mass5set(:,1),  & 
G1tensor(282),G1tensor(132),G1tensor(141),G1tensor(135),G1tensor(294),G1tensor(138))
  call G_TensorShift(G1tensor(132),1)
  call Hotf_5pt_reduction_last(G2tensor(88),RedSet_5(31),mass5set(:,2),  & 
G1tensor(300),G1tensor(144),G1tensor(159),G1tensor(147),G1tensor(352),G1tensor(148))
  call G_TensorShift(G1tensor(144),1)
  call Hotf_5pt_reduction_last(G2tensor(90),RedSet_5(31),mass5set(:,3),  & 
G1tensor(167),G1tensor(149),G1tensor(171),G1tensor(153),G1tensor(358),G1tensor(154))
  call G_TensorShift(G1tensor(149),1)
  call Hotf_5pt_reduction_last(G2tensor(92),RedSet_5(31),mass5set(:,6),  & 
G1tensor(179),G1tensor(155),G1tensor(370),G1tensor(160),G1tensor(185),G1tensor(161))
  call G_TensorShift(G1tensor(155),1)
  call Hotf_5pt_reduction_last(G2tensor(94),RedSet_5(31),mass5set(:,4),  & 
G1tensor(183),G1tensor(165),G1tensor(364),G1tensor(166),G1tensor(382),G1tensor(172))
  call G_TensorShift(G1tensor(165),1)
  call Hotf_5pt_reduction_last(G2tensor(96),RedSet_5(31),mass5set(:,18),  & 
G1tensor(191),G1tensor(173),G1tensor(189),G1tensor(177),G1tensor(376),G1tensor(178))
  call G_TensorShift(G1tensor(173),1)
  call Hotf_5pt_reduction_last(G2tensor(98),RedSet_5(31),mass5set(:,7),  & 
G1tensor(388),G1tensor(184),G1tensor(394),G1tensor(190),G1tensor(195),G1tensor(196))
  call G_TensorShift(G1tensor(184),1)
  call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(31),mass5set(:,19),  & 
G1tensor(197),G1tensor(198),G1tensor(207),G1tensor(201),G1tensor(256),G1tensor(202))
  call G_TensorShift(G1tensor(198),1)
  call Hotf_5pt_reduction_last(G2tensor(102),RedSet_5(12),mass5set(:,1),  & 
G1tensor(215),G1tensor(203),G1tensor(262),G1tensor(208),G1tensor(227),G1tensor(209))
  call G_TensorShift(G1tensor(203),8)
  call Hotf_5pt_reduction_last(G2tensor(104),RedSet_5(12),mass5set(:,6),  & 
G1tensor(225),G1tensor(213),G1tensor(268),G1tensor(214),G1tensor(231),G1tensor(219))
  call G_TensorShift(G1tensor(213),8)
  call Hotf_5pt_reduction_last(G2tensor(106),RedSet_5(12),mass5set(:,3),  & 
G1tensor(274),G1tensor(220),G1tensor(239),G1tensor(221),G1tensor(280),G1tensor(226))
  call G_TensorShift(G1tensor(220),8)
  call Hotf_5pt_reduction_last(G2tensor(108),RedSet_5(12),mass5set(:,2),  & 
G1tensor(286),G1tensor(232),G1tensor(245),G1tensor(233),G1tensor(243),G1tensor(237))
  call G_TensorShift(G1tensor(232),8)
  call Hotf_5pt_reduction_last(G2tensor(110),RedSet_5(12),mass5set(:,7),  & 
G1tensor(292),G1tensor(238),G1tensor(298),G1tensor(244),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(238),8)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(12),mass5set(:,18),  & 
G1tensor(251),G1tensor(252),G1tensor(261),G1tensor(255),G1tensor(269),G1tensor(257))
  call G_TensorShift(G1tensor(252),8)
  call Hotf_5pt_reduction_last(G2tensor(114),RedSet_5(12),mass5set(:,4),  & 
G1tensor(281),G1tensor(263),G1tensor(279),G1tensor(267),G1tensor(285),G1tensor(273))
  call G_TensorShift(G1tensor(263),8)
  call Hotf_5pt_reduction_last(G2tensor(116),RedSet_5(12),mass5set(:,19),  & 
G1tensor(293),G1tensor(275),G1tensor(299),G1tensor(287),G1tensor(297),G1tensor(291))
  call G_TensorShift(G1tensor(275),8)
  call Hotf_5pt_reduction_last(G2tensor(118),RedSet_5(32),mass5set(:,1),  & 
G1tensor(321),G1tensor(303),G1tensor(317),G1tensor(305),G1tensor(354),G1tensor(306))
  call G_TensorShift(G1tensor(303),4)
  call Hotf_5pt_reduction_last(G2tensor(120),RedSet_5(32),mass5set(:,6),  & 
G1tensor(333),G1tensor(309),G1tensor(329),G1tensor(311),G1tensor(360),G1tensor(312))
  call G_TensorShift(G1tensor(309),4)
  call Hotf_5pt_reduction_last(G2tensor(122),RedSet_5(32),mass5set(:,3),  & 
G1tensor(339),G1tensor(315),G1tensor(366),G1tensor(318),G1tensor(341),G1tensor(323))
  call G_TensorShift(G1tensor(315),4)
  call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(32),mass5set(:,2),  & 
G1tensor(372),G1tensor(324),G1tensor(345),G1tensor(327),G1tensor(378),G1tensor(330))
  call G_TensorShift(G1tensor(324),4)
  call Hotf_5pt_reduction_last(G2tensor(126),RedSet_5(32),mass5set(:,7),  & 
G1tensor(347),G1tensor(335),G1tensor(384),G1tensor(336),G1tensor(390),G1tensor(342))
  call G_TensorShift(G1tensor(335),4)
  call Hotf_5pt_reduction_last(G2tensor(128),RedSet_5(32),mass5set(:,18),  & 
G1tensor(396),G1tensor(348),G1tensor(369),G1tensor(351),G1tensor(365),G1tensor(353))
  call G_TensorShift(G1tensor(348),4)
  call Hotf_5pt_reduction_last(G2tensor(130),RedSet_5(32),mass5set(:,4),  & 
G1tensor(381),G1tensor(357),G1tensor(377),G1tensor(359),G1tensor(387),G1tensor(363))
  call G_TensorShift(G1tensor(357),4)
  call Hotf_5pt_reduction_last(G2tensor(132),RedSet_5(32),mass5set(:,19),  & 
G1tensor(389),G1tensor(371),G1tensor(393),G1tensor(375),G1tensor(395),G1tensor(383))
  call G_TensorShift(G1tensor(371),4)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(33),mass5set(:,1),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(34),mass5set(:,1),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(35),mass5set(:,1),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(16),mass5set(:,1),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(34),mass5set(:,2),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(422),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(35),mass5set(:,2),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(428),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(16),mass5set(:,2),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437),G1tensor(438))
  call G_TensorShift(G1tensor(434),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(33),mass5set(:,12),  & 
G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444))
  call G_TensorShift(G1tensor(440),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(34),mass5set(:,12),  & 
G1tensor(445),G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(446),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(35),mass5set(:,12),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(452),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(16),mass5set(:,12),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(458),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(33),mass5set(:,15),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G1tensor(468))
  call G_TensorShift(G1tensor(464),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(34),mass5set(:,15),  & 
G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(470),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(16),mass5set(:,3),  & 
G1tensor(475),G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(476),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(34),mass5set(:,13),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(482),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(35),mass5set(:,13),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(488),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(16),mass5set(:,13),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497),G1tensor(498))
  call G_TensorShift(G1tensor(494),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(34),mass5set(:,20),  & 
G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504))
  call G_TensorShift(G1tensor(500),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(16),mass5set(:,4),  & 
G1tensor(505),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(506),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(33),mass5set(:,16),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(512),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(34),mass5set(:,16),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(518),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(16),mass5set(:,21),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527),G1tensor(528))
  call G_TensorShift(G1tensor(524),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(34),mass5set(:,22),  & 
G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534))
  call G_TensorShift(G1tensor(530),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(16),mass5set(:,23),  & 
G1tensor(535),G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(536),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(36),mass5set(:,1),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(542),16)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(37),mass5set(:,1),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(548),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(38),mass5set(:,1),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557),G1tensor(558))
  call G_TensorShift(G1tensor(554),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(14),mass5set(:,1),  & 
G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564))
  call G_TensorShift(G1tensor(560),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(36),mass5set(:,12),  & 
G1tensor(565),G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(566),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(37),mass5set(:,12),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(572),16)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(38),mass5set(:,12),  & 
G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581),G1tensor(582))
  call G_TensorShift(G1tensor(578),16)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(14),mass5set(:,12),  & 
G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586),G1tensor(587),G1tensor(588))
  call G_TensorShift(G1tensor(584),16)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(37),mass5set(:,2),  & 
G1tensor(589),G1tensor(590),G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594))
  call G_TensorShift(G1tensor(590),16)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(38),mass5set(:,2),  & 
G1tensor(595),G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(596),16)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(14),mass5set(:,2),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605),G1tensor(606))
  call G_TensorShift(G1tensor(602),16)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(36),mass5set(:,15),  & 
G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610),G1tensor(611),G1tensor(612))
  call G_TensorShift(G1tensor(608),16)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(37),mass5set(:,15),  & 
G1tensor(613),G1tensor(614),G1tensor(615),G1tensor(616),G1tensor(617),G1tensor(618))
  call G_TensorShift(G1tensor(614),16)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(14),mass5set(:,3),  & 
G1tensor(619),G1tensor(620),G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624))
  call G_TensorShift(G1tensor(620),16)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(37),mass5set(:,13),  & 
G1tensor(625),G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(626),16)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(38),mass5set(:,13),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635),G1tensor(636))
  call G_TensorShift(G1tensor(632),16)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(14),mass5set(:,13),  & 
G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640),G1tensor(641),G1tensor(642))
  call G_TensorShift(G1tensor(638),16)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(36),mass5set(:,16),  & 
G1tensor(643),G1tensor(644),G1tensor(645),G1tensor(646),G1tensor(647),G1tensor(648))
  call G_TensorShift(G1tensor(644),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(37),mass5set(:,16),  & 
G1tensor(649),G1tensor(650),G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654))
  call G_TensorShift(G1tensor(650),16)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(14),mass5set(:,21),  & 
G1tensor(655),G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(656),16)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(37),mass5set(:,20),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665),G1tensor(666))
  call G_TensorShift(G1tensor(662),16)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(14),mass5set(:,4),  & 
G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670),G1tensor(671),G1tensor(672))
  call G_TensorShift(G1tensor(668),16)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(37),mass5set(:,22),  & 
G1tensor(673),G1tensor(674),G1tensor(675),G1tensor(676),G1tensor(677),G1tensor(678))
  call G_TensorShift(G1tensor(674),16)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(14),mass5set(:,23),  & 
G1tensor(679),G1tensor(680),G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684))
  call G_TensorShift(G1tensor(680),16)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(39),mass5set(:,1),  & 
G1tensor(685),G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(686),16)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(40),mass5set(:,1),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695),G1tensor(696))
  call G_TensorShift(G1tensor(692),16)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(41),mass5set(:,1),  & 
G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700),G1tensor(701),G1tensor(702))
  call G_TensorShift(G1tensor(698),16)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(40),mass5set(:,2),  & 
G1tensor(703),G1tensor(704),G1tensor(705),G1tensor(706),G1tensor(707),G1tensor(708))
  call G_TensorShift(G1tensor(704),16)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(41),mass5set(:,2),  & 
G1tensor(709),G1tensor(710),G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714))
  call G_TensorShift(G1tensor(710),16)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(39),mass5set(:,12),  & 
G1tensor(715),G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(716),16)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(40),mass5set(:,12),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725),G1tensor(726))
  call G_TensorShift(G1tensor(722),16)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(41),mass5set(:,12),  & 
G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730),G1tensor(731),G1tensor(732))
  call G_TensorShift(G1tensor(728),16)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(39),mass5set(:,15),  & 
G1tensor(733),G1tensor(734),G1tensor(735),G1tensor(736),G1tensor(737),G1tensor(738))
  call G_TensorShift(G1tensor(734),16)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(41),mass5set(:,3),  & 
G1tensor(739),G1tensor(740),G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744))
  call G_TensorShift(G1tensor(740),16)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(40),mass5set(:,13),  & 
G1tensor(745),G1tensor(746),G1tensor(747),G1tensor(748),G1tensor(749),G1tensor(750))
  call G_TensorShift(G1tensor(746),16)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(41),mass5set(:,13),  & 
G1tensor(751),G1tensor(752),G1tensor(753),G1tensor(754),G1tensor(755),G1tensor(756))
  call G_TensorShift(G1tensor(752),16)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(41),mass5set(:,4),  & 
G1tensor(757),G1tensor(758),G1tensor(759),G1tensor(760),G1tensor(761),G1tensor(762))
  call G_TensorShift(G1tensor(758),16)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(39),mass5set(:,16),  & 
G1tensor(763),G1tensor(764),G1tensor(765),G1tensor(766),G1tensor(767),G1tensor(768))
  call G_TensorShift(G1tensor(764),16)
  call Hotf_5pt_reduction_last(G2tensor(125),RedSet_5(41),mass5set(:,21),  & 
G1tensor(769),G1tensor(770),G1tensor(771),G1tensor(772),G1tensor(773),G1tensor(774))
  call G_TensorShift(G1tensor(770),16)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(41),mass5set(:,23),  & 
G1tensor(775),G1tensor(776),G1tensor(777),G1tensor(778),G1tensor(779),G1tensor(780))
  call G_TensorShift(G1tensor(776),16)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(42),mass5set(:,1),  & 
G1tensor(781),G1tensor(782),G1tensor(783),G1tensor(784),G1tensor(785),G1tensor(786))
  call G_TensorShift(G1tensor(782),16)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(13),mass5set(:,1),  & 
G1tensor(787),G1tensor(788),G1tensor(789),G1tensor(790),G1tensor(791),G1tensor(792))
  call G_TensorShift(G1tensor(788),16)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(43),mass5set(:,1),  & 
G1tensor(793),G1tensor(794),G1tensor(795),G1tensor(796),G1tensor(797),G1tensor(798))
  call G_TensorShift(G1tensor(794),16)
  call Hotf_5pt_reduction_last(G2tensor(134),RedSet_5(42),mass5set(:,12),  & 
G1tensor(799),G1tensor(800),G1tensor(801),G1tensor(802),G1tensor(803),G1tensor(804))
  call G_TensorShift(G1tensor(800),16)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(13),mass5set(:,12),  & 
G1tensor(805),G1tensor(806),G1tensor(807),G1tensor(808),G1tensor(809),G1tensor(810))
  call G_TensorShift(G1tensor(806),16)
  call Hotf_5pt_reduction_last(G2tensor(136),RedSet_5(43),mass5set(:,12),  & 
G1tensor(811),G1tensor(812),G1tensor(813),G1tensor(814),G1tensor(815),G1tensor(816))
  call G_TensorShift(G1tensor(812),16)
  call Hotf_5pt_reduction_last(G2tensor(137),RedSet_5(13),mass5set(:,2),  & 
G1tensor(817),G1tensor(818),G1tensor(819),G1tensor(820),G1tensor(821),G1tensor(822))
  call G_TensorShift(G1tensor(818),16)
  call Hotf_5pt_reduction_last(G2tensor(138),RedSet_5(43),mass5set(:,2),  & 
G1tensor(823),G1tensor(824),G1tensor(825),G1tensor(826),G1tensor(827),G1tensor(828))
  call G_TensorShift(G1tensor(824),16)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(42),mass5set(:,15),  & 
G1tensor(829),G1tensor(830),G1tensor(831),G1tensor(832),G1tensor(833),G1tensor(834))
  call G_TensorShift(G1tensor(830),16)
  call Hotf_5pt_reduction_last(G2tensor(140),RedSet_5(13),mass5set(:,15),  & 
G1tensor(835),G1tensor(836),G1tensor(837),G1tensor(838),G1tensor(839),G1tensor(840))
  call G_TensorShift(G1tensor(836),16)
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(13),mass5set(:,13),  & 
G1tensor(841),G1tensor(842),G1tensor(843),G1tensor(844),G1tensor(845),G1tensor(846))
  call G_TensorShift(G1tensor(842),16)
  call Hotf_5pt_reduction_last(G2tensor(142),RedSet_5(43),mass5set(:,13),  & 
G1tensor(847),G1tensor(848),G1tensor(849),G1tensor(850),G1tensor(851),G1tensor(852))
  call G_TensorShift(G1tensor(848),16)
  call Hotf_5pt_reduction_last(G2tensor(143),RedSet_5(42),mass5set(:,16),  & 
G1tensor(853),G1tensor(854),G1tensor(855),G1tensor(856),G1tensor(857),G1tensor(858))
  call G_TensorShift(G1tensor(854),16)
  call Hotf_5pt_reduction_last(G2tensor(144),RedSet_5(13),mass5set(:,16),  & 
G1tensor(859),G1tensor(860),G1tensor(861),G1tensor(862),G1tensor(863),G1tensor(864))
  call G_TensorShift(G1tensor(860),16)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(13),mass5set(:,20),  & 
G1tensor(865),G1tensor(866),G1tensor(867),G1tensor(868),G1tensor(869),G1tensor(870))
  call G_TensorShift(G1tensor(866),16)
  call Hotf_5pt_reduction_last(G2tensor(146),RedSet_5(13),mass5set(:,22),  & 
G1tensor(871),G1tensor(872),G1tensor(873),G1tensor(874),G1tensor(875),G1tensor(876))
  call G_TensorShift(G1tensor(872),16)
  call Hotf_5pt_reduction_last(G2tensor(147),RedSet_5(42),mass5set(:,17),  & 
G1tensor(877),G1tensor(878),G1tensor(879),G1tensor(880),G1tensor(881),G1tensor(882))
  call G_TensorShift(G1tensor(878),16)
  call Hotf_5pt_reduction_last(G2tensor(221),RedSet_5(13),mass5set(:,10),  & 
G1tensor(883),G1tensor(884),G1tensor(885),G1tensor(886),G1tensor(887),G1tensor(888))
  call G_TensorShift(G1tensor(884),16)
  call Hotf_5pt_reduction_last(G2tensor(148),RedSet_5(43),mass5set(:,14),  & 
G1tensor(889),G1tensor(890),G1tensor(891),G1tensor(892),G1tensor(893),G1tensor(894))
  call G_TensorShift(G1tensor(890),16)
  call Hotf_5pt_reduction_last(G2tensor(224),RedSet_5(14),mass5set(:,11),  & 
G1tensor(895),G1tensor(896),G1tensor(897),G1tensor(898),G1tensor(899),G1tensor(900))
  call G_TensorShift(G1tensor(896),16)
  call Hotf_5pt_reduction_last(G2tensor(149),RedSet_5(44),mass5set(:,1),  & 
G1tensor(901),G1tensor(902),G1tensor(903),G1tensor(904),G1tensor(905),G1tensor(906))
  call G_TensorShift(G1tensor(902),16)
  call Hotf_5pt_reduction_last(G2tensor(150),RedSet_5(15),mass5set(:,1),  & 
G1tensor(907),G1tensor(908),G1tensor(909),G1tensor(910),G1tensor(911),G1tensor(912))
  call G_TensorShift(G1tensor(908),16)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(45),mass5set(:,1),  & 
G1tensor(913),G1tensor(914),G1tensor(915),G1tensor(916),G1tensor(917),G1tensor(918))
  call G_TensorShift(G1tensor(914),16)
  call Hotf_5pt_reduction_last(G2tensor(152),RedSet_5(15),mass5set(:,2),  & 
G1tensor(919),G1tensor(920),G1tensor(921),G1tensor(922),G1tensor(923),G1tensor(924))
  call G_TensorShift(G1tensor(920),16)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(45),mass5set(:,2),  & 
G1tensor(925),G1tensor(926),G1tensor(927),G1tensor(928),G1tensor(929),G1tensor(930))
  call G_TensorShift(G1tensor(926),16)
  call Hotf_5pt_reduction_last(G2tensor(154),RedSet_5(44),mass5set(:,15),  & 
G1tensor(931),G1tensor(932),G1tensor(933),G1tensor(934),G1tensor(935),G1tensor(936))
  call G_TensorShift(G1tensor(932),16)
  call Hotf_5pt_reduction_last(G2tensor(155),RedSet_5(15),mass5set(:,15),  & 
G1tensor(937),G1tensor(938),G1tensor(939),G1tensor(940),G1tensor(941),G1tensor(942))
  call G_TensorShift(G1tensor(938),16)
  call Hotf_5pt_reduction_last(G2tensor(156),RedSet_5(44),mass5set(:,12),  & 
G1tensor(943),G1tensor(944),G1tensor(945),G1tensor(946),G1tensor(947),G1tensor(948))
  call G_TensorShift(G1tensor(944),16)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(15),mass5set(:,12),  & 
G1tensor(949),G1tensor(950),G1tensor(951),G1tensor(952),G1tensor(953),G1tensor(954))
  call G_TensorShift(G1tensor(950),16)
  call Hotf_5pt_reduction_last(G2tensor(158),RedSet_5(45),mass5set(:,12),  & 
G1tensor(955),G1tensor(956),G1tensor(957),G1tensor(958),G1tensor(959),G1tensor(960))
  call G_TensorShift(G1tensor(956),16)
  call Hotf_5pt_reduction_last(G2tensor(159),RedSet_5(15),mass5set(:,20),  & 
G1tensor(961),G1tensor(962),G1tensor(963),G1tensor(964),G1tensor(965),G1tensor(966))
  call G_TensorShift(G1tensor(962),16)
  call Hotf_5pt_reduction_last(G2tensor(160),RedSet_5(15),mass5set(:,13),  & 
G1tensor(967),G1tensor(968),G1tensor(969),G1tensor(970),G1tensor(971),G1tensor(972))
  call G_TensorShift(G1tensor(968),16)
  call Hotf_5pt_reduction_last(G2tensor(161),RedSet_5(45),mass5set(:,13),  & 
G1tensor(973),G1tensor(974),G1tensor(975),G1tensor(976),G1tensor(977),G1tensor(978))
  call G_TensorShift(G1tensor(974),16)
  call Hotf_5pt_reduction_last(G2tensor(162),RedSet_5(44),mass5set(:,16),  & 
G1tensor(979),G1tensor(980),G1tensor(981),G1tensor(982),G1tensor(983),G1tensor(984))
  call G_TensorShift(G1tensor(980),16)
  call Hotf_5pt_reduction_last(G2tensor(163),RedSet_5(15),mass5set(:,16),  & 
G1tensor(985),G1tensor(986),G1tensor(987),G1tensor(988),G1tensor(989),G1tensor(990))
  call G_TensorShift(G1tensor(986),16)
  call Hotf_5pt_reduction_last(G2tensor(164),RedSet_5(15),mass5set(:,22),  & 
G1tensor(991),G1tensor(992),G1tensor(993),G1tensor(994),G1tensor(995),G1tensor(996))
  call G_TensorShift(G1tensor(992),16)
  call Hotf_5pt_reduction_last(G2tensor(165),RedSet_5(44),mass5set(:,17),  & 
G1tensor(997),G1tensor(998),G1tensor(999),G1tensor(1000),G1tensor(1001),G1tensor(1002))
  call G_TensorShift(G1tensor(998),16)
  call Hotf_5pt_reduction_last(G2tensor(227),RedSet_5(15),mass5set(:,10),  & 
G1tensor(1003),G1tensor(1004),G1tensor(1005),G1tensor(1006),G1tensor(1007),G1tensor(1008))
  call G_TensorShift(G1tensor(1004),16)
  call Hotf_5pt_reduction_last(G2tensor(166),RedSet_5(45),mass5set(:,14),  & 
G1tensor(1009),G1tensor(1010),G1tensor(1011),G1tensor(1012),G1tensor(1013),G1tensor(1014))
  call G_TensorShift(G1tensor(1010),16)
  call Hotf_5pt_reduction_last(G2tensor(230),RedSet_5(16),mass5set(:,11),  & 
G1tensor(1015),G1tensor(1016),G1tensor(1017),G1tensor(1018),G1tensor(1019),G1tensor(1020))
  call G_TensorShift(G1tensor(1016),16)
  call Hotf_5pt_reduction_last(G2tensor(167),RedSet_5(46),mass5set(:,1),  & 
G1tensor(1021),G1tensor(1022),G1tensor(1023),G1tensor(1024),G1tensor(1025),G1tensor(1026))
  call G_TensorShift(G1tensor(1022),16)
  call Hotf_5pt_reduction_last(G2tensor(168),RedSet_5(47),mass5set(:,1),  & 
G1tensor(1027),G1tensor(1028),G1tensor(1029),G1tensor(1030),G1tensor(1031),G1tensor(1032))
  call G_TensorShift(G1tensor(1028),16)
  call Hotf_5pt_reduction_last(G2tensor(169),RedSet_5(47),mass5set(:,2),  & 
G1tensor(1033),G1tensor(1034),G1tensor(1035),G1tensor(1036),G1tensor(1037),G1tensor(1038))
  call G_TensorShift(G1tensor(1034),16)
  call Hotf_5pt_reduction_last(G2tensor(170),RedSet_5(46),mass5set(:,15),  & 
G1tensor(1039),G1tensor(1040),G1tensor(1041),G1tensor(1042),G1tensor(1043),G1tensor(1044))
  call G_TensorShift(G1tensor(1040),16)
  call Hotf_5pt_reduction_last(G2tensor(171),RedSet_5(46),mass5set(:,12),  & 
G1tensor(1045),G1tensor(1046),G1tensor(1047),G1tensor(1048),G1tensor(1049),G1tensor(1050))
  call G_TensorShift(G1tensor(1046),16)
  call Hotf_5pt_reduction_last(G2tensor(172),RedSet_5(47),mass5set(:,12),  & 
G1tensor(1051),G1tensor(1052),G1tensor(1053),G1tensor(1054),G1tensor(1055),G1tensor(1056))
  call G_TensorShift(G1tensor(1052),16)
  call Hotf_5pt_reduction_last(G2tensor(173),RedSet_5(47),mass5set(:,13),  & 
G1tensor(1057),G1tensor(1058),G1tensor(1059),G1tensor(1060),G1tensor(1061),G1tensor(1062))
  call G_TensorShift(G1tensor(1058),16)
  call Hotf_5pt_reduction_last(G2tensor(174),RedSet_5(46),mass5set(:,16),  & 
G1tensor(1063),G1tensor(1064),G1tensor(1065),G1tensor(1066),G1tensor(1067),G1tensor(1068))
  call G_TensorShift(G1tensor(1064),16)
  call Hotf_5pt_reduction_last(G2tensor(175),RedSet_5(48),mass5set(:,1),  & 
G1tensor(1069),G1tensor(1070),G1tensor(1071),G1tensor(1072),G1tensor(1073),G1tensor(1074))
  call G_TensorShift(G1tensor(1070),16)
  call Hotf_5pt_reduction_last(G2tensor(176),RedSet_5(49),mass5set(:,1),  & 
G1tensor(1075),G1tensor(1076),G1tensor(1077),G1tensor(1078),G1tensor(1079),G1tensor(1080))
  call G_TensorShift(G1tensor(1076),16)
  call Hotf_5pt_reduction_last(G2tensor(177),RedSet_5(50),mass5set(:,1),  & 
G1tensor(1081),G1tensor(1082),G1tensor(1083),G1tensor(1084),G1tensor(1085),G1tensor(1086))
  call G_TensorShift(G1tensor(1082),16)
  call Hotf_5pt_reduction_last(G2tensor(178),RedSet_5(48),mass5set(:,12),  & 
G1tensor(1087),G1tensor(1088),G1tensor(1089),G1tensor(1090),G1tensor(1091),G1tensor(1092))
  call G_TensorShift(G1tensor(1088),16)
  call Hotf_5pt_reduction_last(G2tensor(179),RedSet_5(49),mass5set(:,12),  & 
G1tensor(1093),G1tensor(1094),G1tensor(1095),G1tensor(1096),G1tensor(1097),G1tensor(1098))
  call G_TensorShift(G1tensor(1094),16)
  call Hotf_5pt_reduction_last(G2tensor(180),RedSet_5(50),mass5set(:,12),  & 
G1tensor(1099),G1tensor(1100),G1tensor(1101),G1tensor(1102),G1tensor(1103),G1tensor(1104))
  call G_TensorShift(G1tensor(1100),16)
  call Hotf_5pt_reduction_last(G2tensor(181),RedSet_5(48),mass5set(:,15),  & 
G1tensor(1105),G1tensor(1106),G1tensor(1107),G1tensor(1108),G1tensor(1109),G1tensor(1110))
  call G_TensorShift(G1tensor(1106),16)
  call Hotf_5pt_reduction_last(G2tensor(182),RedSet_5(50),mass5set(:,3),  & 
G1tensor(1111),G1tensor(1112),G1tensor(1113),G1tensor(1114),G1tensor(1115),G1tensor(1116))
  call G_TensorShift(G1tensor(1112),16)
  call Hotf_5pt_reduction_last(G2tensor(183),RedSet_5(49),mass5set(:,2),  & 
G1tensor(1117),G1tensor(1118),G1tensor(1119),G1tensor(1120),G1tensor(1121),G1tensor(1122))
  call G_TensorShift(G1tensor(1118),16)
  call Hotf_5pt_reduction_last(G2tensor(184),RedSet_5(50),mass5set(:,2),  & 
G1tensor(1123),G1tensor(1124),G1tensor(1125),G1tensor(1126),G1tensor(1127),G1tensor(1128))
  call G_TensorShift(G1tensor(1124),16)
  call Hotf_5pt_reduction_last(G2tensor(185),RedSet_5(48),mass5set(:,16),  & 
G1tensor(1129),G1tensor(1130),G1tensor(1131),G1tensor(1132),G1tensor(1133),G1tensor(1134))
  call G_TensorShift(G1tensor(1130),16)
  call Hotf_5pt_reduction_last(G2tensor(186),RedSet_5(50),mass5set(:,21),  & 
G1tensor(1135),G1tensor(1136),G1tensor(1137),G1tensor(1138),G1tensor(1139),G1tensor(1140))
  call G_TensorShift(G1tensor(1136),16)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(49),mass5set(:,13),  & 
G1tensor(1141),G1tensor(1142),G1tensor(1143),G1tensor(1144),G1tensor(1145),G1tensor(1146))
  call G_TensorShift(G1tensor(1142),16)
  call Hotf_5pt_reduction_last(G2tensor(188),RedSet_5(50),mass5set(:,13),  & 
G1tensor(1147),G1tensor(1148),G1tensor(1149),G1tensor(1150),G1tensor(1151),G1tensor(1152))
  call G_TensorShift(G1tensor(1148),16)
  call Hotf_5pt_reduction_last(G2tensor(189),RedSet_5(50),mass5set(:,4),  & 
G1tensor(1153),G1tensor(1154),G1tensor(1155),G1tensor(1156),G1tensor(1157),G1tensor(1158))
  call G_TensorShift(G1tensor(1154),16)
  call Hotf_5pt_reduction_last(G2tensor(190),RedSet_5(50),mass5set(:,23),  & 
G1tensor(1159),G1tensor(1160),G1tensor(1161),G1tensor(1162),G1tensor(1163),G1tensor(1164))
  call G_TensorShift(G1tensor(1160),16)
  call Hotf_5pt_reduction_last(G2tensor(191),RedSet_5(51),mass5set(:,1),  & 
G1tensor(1165),G1tensor(1166),G1tensor(1167),G1tensor(1168),G1tensor(1169),G1tensor(1170))
  call G_TensorShift(G1tensor(1166),16)
  call Hotf_5pt_reduction_last(G2tensor(192),RedSet_5(52),mass5set(:,1),  & 
G1tensor(1171),G1tensor(1172),G1tensor(1173),G1tensor(1174),G1tensor(1175),G1tensor(1176))
  call G_TensorShift(G1tensor(1172),16)
  call Hotf_5pt_reduction_last(G2tensor(193),RedSet_5(51),mass5set(:,12),  & 
G1tensor(1177),G1tensor(1178),G1tensor(1179),G1tensor(1180),G1tensor(1181),G1tensor(1182))
  call G_TensorShift(G1tensor(1178),16)
  call Hotf_5pt_reduction_last(G2tensor(194),RedSet_5(52),mass5set(:,12),  & 
G1tensor(1183),G1tensor(1184),G1tensor(1185),G1tensor(1186),G1tensor(1187),G1tensor(1188))
  call G_TensorShift(G1tensor(1184),16)
  call Hotf_5pt_reduction_last(G2tensor(195),RedSet_5(51),mass5set(:,15),  & 
G1tensor(1189),G1tensor(1190),G1tensor(1191),G1tensor(1192),G1tensor(1193),G1tensor(1194))
  call G_TensorShift(G1tensor(1190),16)
  call Hotf_5pt_reduction_last(G2tensor(196),RedSet_5(52),mass5set(:,2),  & 
G1tensor(1195),G1tensor(1196),G1tensor(1197),G1tensor(1198),G1tensor(1199),G1tensor(1200))
  call G_TensorShift(G1tensor(1196),16)
  call Hotf_5pt_reduction_last(G2tensor(197),RedSet_5(51),mass5set(:,16),  & 
G1tensor(1201),G1tensor(1202),G1tensor(1203),G1tensor(1204),G1tensor(1205),G1tensor(1206))
  call G_TensorShift(G1tensor(1202),16)
  call Hotf_5pt_reduction_last(G2tensor(198),RedSet_5(52),mass5set(:,13),  & 
G1tensor(1207),G1tensor(1208),G1tensor(1209),G1tensor(1210),G1tensor(1211),G1tensor(1212))
  call G_TensorShift(G1tensor(1208),16)
  call Hotf_5pt_reduction_last(G2tensor(199),RedSet_5(9),mass5set(:,1),  & 
G1tensor(1213),G1tensor(1214),G1tensor(1215),G1tensor(1216),G1tensor(1217),G1tensor(1218))
  call G_TensorShift(G1tensor(1214),8)
  call Hotf_5pt_reduction_last(G2tensor(201),RedSet_5(9),mass5set(:,6),  & 
G1tensor(1219),G1tensor(1220),G1tensor(1221),G1tensor(1222),G1tensor(1223),G1tensor(1224))
  call G_TensorShift(G1tensor(1220),8)
  call Hotf_5pt_reduction_last(G2tensor(203),RedSet_5(9),mass5set(:,3),  & 
G1tensor(1225),G1tensor(1226),G1tensor(1227),G1tensor(1228),G1tensor(1229),G1tensor(1230))
  call G_TensorShift(G1tensor(1226),8)
  call Hotf_5pt_reduction_last(G2tensor(205),RedSet_5(9),mass5set(:,7),  & 
G1tensor(1231),G1tensor(1232),G1tensor(1233),G1tensor(1234),G1tensor(1235),G1tensor(1236))
  call G_TensorShift(G1tensor(1232),8)
  call Hotf_5pt_reduction_last(G2tensor(207),RedSet_5(9),mass5set(:,8),  & 
G1tensor(1237),G1tensor(1238),G1tensor(1239),G1tensor(1240),G1tensor(1241),G1tensor(1242))
  call G_TensorShift(G1tensor(1238),8)
  call Hotf_5pt_reduction_last(G2tensor(209),RedSet_5(10),mass5set(:,1),  & 
G1tensor(1243),G1tensor(1244),G1tensor(1245),G1tensor(1246),G1tensor(1247),G1tensor(1248))
  call G_TensorShift(G1tensor(1244),4)
  call Hotf_5pt_reduction_last(G2tensor(211),RedSet_5(10),mass5set(:,3),  & 
G1tensor(1249),G1tensor(1250),G1tensor(1251),G1tensor(1252),G1tensor(1253),G1tensor(1254))
  call G_TensorShift(G1tensor(1250),4)
  call Hotf_5pt_reduction_last(G2tensor(213),RedSet_5(10),mass5set(:,6),  & 
G1tensor(1255),G1tensor(1256),G1tensor(1257),G1tensor(1258),G1tensor(1259),G1tensor(1260))
  call G_TensorShift(G1tensor(1256),4)
  call Hotf_5pt_reduction_last(G2tensor(215),RedSet_5(10),mass5set(:,7),  & 
G1tensor(1261),G1tensor(1262),G1tensor(1263),G1tensor(1264),G1tensor(1265),G1tensor(1266))
  call G_TensorShift(G1tensor(1262),4)
  call Hotf_5pt_reduction_last(G2tensor(219),RedSet_5(12),mass5set(:,9),  & 
G1tensor(1267),G1tensor(1268),G1tensor(1269),G1tensor(1270),G1tensor(1271),G1tensor(1272))
  call G_TensorShift(G1tensor(1268),8)
  call Hotf_5pt_reduction_last(G2tensor(233),RedSet_5(17),mass5set(:,1),  & 
G1tensor(1273),G1tensor(1274),G1tensor(1275),G1tensor(1276),G1tensor(1277),G1tensor(1278))
  call G_TensorShift(G1tensor(1274),16)
  call Hotf_5pt_reduction_last(G2tensor(236),RedSet_5(17),mass5set(:,2),  & 
G1tensor(1279),G1tensor(1280),G1tensor(1281),G1tensor(1282),G1tensor(1283),G1tensor(1284))
  call G_TensorShift(G1tensor(1280),16)
  call Hotf_5pt_reduction_last(G2tensor(239),RedSet_5(17),mass5set(:,12),  & 
G1tensor(1285),G1tensor(1286),G1tensor(1287),G1tensor(1288),G1tensor(1289),G1tensor(1290))
  call G_TensorShift(G1tensor(1286),16)
  call Hotf_5pt_reduction_last(G2tensor(242),RedSet_5(17),mass5set(:,13),  & 
G1tensor(1291),G1tensor(1292),G1tensor(1293),G1tensor(1294),G1tensor(1295),G1tensor(1296))
  call G_TensorShift(G1tensor(1292),16)
  call Hotf_5pt_reduction_last(G2tensor(245),RedSet_5(17),mass5set(:,14),  & 
G1tensor(1297),G1tensor(1298),G1tensor(1299),G1tensor(1300),G1tensor(1301),G1tensor(1302))
  call G_TensorShift(G1tensor(1298),16)
  call Hotf_5pt_reduction_last(G2tensor(248),RedSet_5(18),mass5set(:,1),  & 
G1tensor(1303),G1tensor(1304),G1tensor(1305),G1tensor(1306),G1tensor(1307),G1tensor(1308))
  call G_TensorShift(G1tensor(1304),16)
  call Hotf_5pt_reduction_last(G2tensor(251),RedSet_5(18),mass5set(:,12),  & 
G1tensor(1309),G1tensor(1310),G1tensor(1311),G1tensor(1312),G1tensor(1313),G1tensor(1314))
  call G_TensorShift(G1tensor(1310),16)
  call Hotf_5pt_reduction_last(G2tensor(254),RedSet_5(18),mass5set(:,2),  & 
G1tensor(1315),G1tensor(1316),G1tensor(1317),G1tensor(1318),G1tensor(1319),G1tensor(1320))
  call G_TensorShift(G1tensor(1316),16)
  call Hotf_5pt_reduction_last(G2tensor(257),RedSet_5(18),mass5set(:,13),  & 
G1tensor(1321),G1tensor(1322),G1tensor(1323),G1tensor(1324),G1tensor(1325),G1tensor(1326))
  call G_TensorShift(G1tensor(1322),16)
  call Hotf_5pt_reduction_last(G2tensor(275),RedSet_5(19),mass5set(:,1),  & 
G1tensor(1327),G1tensor(1328),G1tensor(1329),G1tensor(1330),G1tensor(1331),G1tensor(1332))
  call G_TensorShift(G1tensor(1328),12)
  call Hotf_5pt_reduction_last(G2tensor(278),RedSet_5(19),mass5set(:,2),  & 
G1tensor(1333),G1tensor(1334),G1tensor(1335),G1tensor(1336),G1tensor(1337),G1tensor(1338))
  call G_TensorShift(G1tensor(1334),12)
  call Hotf_5pt_reduction_last(G2tensor(281),RedSet_5(19),mass5set(:,3),  & 
G1tensor(1339),G1tensor(1340),G1tensor(1341),G1tensor(1342),G1tensor(1343),G1tensor(1344))
  call G_TensorShift(G1tensor(1340),12)
  call Hotf_5pt_reduction_last(G2tensor(284),RedSet_5(19),mass5set(:,4),  & 
G1tensor(1345),G1tensor(1346),G1tensor(1347),G1tensor(1348),G1tensor(1349),G1tensor(1350))
  call G_TensorShift(G1tensor(1346),12)
  call Hotf_5pt_reduction_last(G2tensor(287),RedSet_5(19),mass5set(:,5),  & 
G1tensor(1351),G1tensor(1352),G1tensor(1353),G1tensor(1354),G1tensor(1355),G1tensor(1356))
  call G_TensorShift(G1tensor(1352),12)
  call Hotf_5pt_reduction_last(G2tensor(302),RedSet_5(20),mass5set(:,1),  & 
G1tensor(1357),G1tensor(1358),G1tensor(1359),G1tensor(1360),G1tensor(1361),G1tensor(1362))
  call G_TensorShift(G1tensor(1358),12)
  call Hotf_5pt_reduction_last(G2tensor(305),RedSet_5(20),mass5set(:,3),  & 
G1tensor(1363),G1tensor(1364),G1tensor(1365),G1tensor(1366),G1tensor(1367),G1tensor(1368))
  call G_TensorShift(G1tensor(1364),12)
  call Hotf_5pt_reduction_last(G2tensor(308),RedSet_5(20),mass5set(:,2),  & 
G1tensor(1369),G1tensor(1370),G1tensor(1371),G1tensor(1372),G1tensor(1373),G1tensor(1374))
  call G_TensorShift(G1tensor(1370),12)
  call Hotf_5pt_reduction_last(G2tensor(311),RedSet_5(20),mass5set(:,4),  & 
G1tensor(1375),G1tensor(1376),G1tensor(1377),G1tensor(1378),G1tensor(1379),G1tensor(1380))
  call G_TensorShift(G1tensor(1376),12)
  call Hotf_5pt_reduction_last(G2tensor(314),RedSet_5(21),mass5set(:,1),  & 
G1tensor(1381),G1tensor(1382),G1tensor(1383),G1tensor(1384),G1tensor(1385),G1tensor(1386))
  call G_TensorShift(G1tensor(1382),16)
  call Hotf_5pt_reduction_last(G2tensor(317),RedSet_5(21),mass5set(:,2),  & 
G1tensor(1387),G1tensor(1388),G1tensor(1389),G1tensor(1390),G1tensor(1391),G1tensor(1392))
  call G_TensorShift(G1tensor(1388),16)
  call Hotf_5pt_reduction_last(G2tensor(320),RedSet_5(21),mass5set(:,12),  & 
G1tensor(1393),G1tensor(1394),G1tensor(1395),G1tensor(1396),G1tensor(1397),G1tensor(1398))
  call G_TensorShift(G1tensor(1394),16)
  call Hotf_5pt_reduction_last(G2tensor(323),RedSet_5(21),mass5set(:,13),  & 
G1tensor(1399),G1tensor(1400),G1tensor(1401),G1tensor(1402),G1tensor(1403),G1tensor(1404))
  call G_TensorShift(G1tensor(1400),16)
  call Hotf_5pt_reduction_last(G2tensor(326),RedSet_5(21),mass5set(:,14),  & 
G1tensor(1405),G1tensor(1406),G1tensor(1407),G1tensor(1408),G1tensor(1409),G1tensor(1410))
  call G_TensorShift(G1tensor(1406),16)
  call Hotf_5pt_reduction_last(G2tensor(329),RedSet_5(22),mass5set(:,1),  & 
G1tensor(1411),G1tensor(1412),G1tensor(1413),G1tensor(1414),G1tensor(1415),G1tensor(1416))
  call G_TensorShift(G1tensor(1412),16)
  call Hotf_5pt_reduction_last(G2tensor(332),RedSet_5(22),mass5set(:,12),  & 
G1tensor(1417),G1tensor(1418),G1tensor(1419),G1tensor(1420),G1tensor(1421),G1tensor(1422))
  call G_TensorShift(G1tensor(1418),16)
  call Hotf_5pt_reduction_last(G2tensor(335),RedSet_5(22),mass5set(:,2),  & 
G1tensor(1423),G1tensor(1424),G1tensor(1425),G1tensor(1426),G1tensor(1427),G1tensor(1428))
  call G_TensorShift(G1tensor(1424),16)
  call Hotf_5pt_reduction_last(G2tensor(338),RedSet_5(22),mass5set(:,13),  & 
G1tensor(1429),G1tensor(1430),G1tensor(1431),G1tensor(1432),G1tensor(1433),G1tensor(1434))
  call G_TensorShift(G1tensor(1430),16)
  call Hotf_5pt_reduction_last(G2tensor(341),RedSet_5(23),mass5set(:,1),  & 
G1tensor(1435),G1tensor(1436),G1tensor(1437),G1tensor(1438),G1tensor(1439),G1tensor(1440))
  call G_TensorShift(G1tensor(1436),8)
  call Hotf_5pt_reduction_last(G2tensor(344),RedSet_5(23),mass5set(:,12),  & 
G1tensor(1441),G1tensor(1442),G1tensor(1443),G1tensor(1444),G1tensor(1445),G1tensor(1446))
  call G_TensorShift(G1tensor(1442),8)
  call Hotf_5pt_reduction_last(G2tensor(347),RedSet_5(23),mass5set(:,15),  & 
G1tensor(1447),G1tensor(1448),G1tensor(1449),G1tensor(1450),G1tensor(1451),G1tensor(1452))
  call G_TensorShift(G1tensor(1448),8)
  call Hotf_5pt_reduction_last(G2tensor(350),RedSet_5(23),mass5set(:,16),  & 
G1tensor(1453),G1tensor(1454),G1tensor(1455),G1tensor(1456),G1tensor(1457),G1tensor(1458))
  call G_TensorShift(G1tensor(1454),8)
  call Hotf_5pt_reduction_last(G2tensor(353),RedSet_5(24),mass5set(:,1),  & 
G1tensor(1459),G1tensor(1460),G1tensor(1461),G1tensor(1462),G1tensor(1463),G1tensor(1464))
  call G_TensorShift(G1tensor(1460),8)
  call Hotf_5pt_reduction_last(G2tensor(356),RedSet_5(24),mass5set(:,15),  & 
G1tensor(1465),G1tensor(1466),G1tensor(1467),G1tensor(1468),G1tensor(1469),G1tensor(1470))
  call G_TensorShift(G1tensor(1466),8)
  call Hotf_5pt_reduction_last(G2tensor(359),RedSet_5(24),mass5set(:,12),  & 
G1tensor(1471),G1tensor(1472),G1tensor(1473),G1tensor(1474),G1tensor(1475),G1tensor(1476))
  call G_TensorShift(G1tensor(1472),8)
  call Hotf_5pt_reduction_last(G2tensor(362),RedSet_5(24),mass5set(:,16),  & 
G1tensor(1477),G1tensor(1478),G1tensor(1479),G1tensor(1480),G1tensor(1481),G1tensor(1482))
  call G_TensorShift(G1tensor(1478),8)
  call Hotf_5pt_reduction_last(G2tensor(365),RedSet_5(24),mass5set(:,17),  & 
G1tensor(1483),G1tensor(1484),G1tensor(1485),G1tensor(1486),G1tensor(1487),G1tensor(1488))
  call G_TensorShift(G1tensor(1484),8)
  call Hotf_5pt_reduction_last(G2tensor(368),RedSet_5(25),mass5set(:,1),  & 
G1tensor(1489),G1tensor(1490),G1tensor(1491),G1tensor(1492),G1tensor(1493),G1tensor(1494))
  call G_TensorShift(G1tensor(1490),2)
  call Hotf_5pt_reduction_last(G2tensor(371),RedSet_5(25),mass5set(:,12),  & 
G1tensor(1495),G1tensor(1496),G1tensor(1497),G1tensor(1498),G1tensor(1499),G1tensor(1500))
  call G_TensorShift(G1tensor(1496),2)
  call Hotf_5pt_reduction_last(G2tensor(374),RedSet_5(25),mass5set(:,15),  & 
G1tensor(1501),G1tensor(1502),G1tensor(1503),G1tensor(1504),G1tensor(1505),G1tensor(1506))
  call G_TensorShift(G1tensor(1502),2)
  call Hotf_5pt_reduction_last(G2tensor(377),RedSet_5(25),mass5set(:,16),  & 
G1tensor(1507),G1tensor(1508),G1tensor(1509),G1tensor(1510),G1tensor(1511),G1tensor(1512))
  call G_TensorShift(G1tensor(1508),2)
  call Hotf_5pt_reduction_last(G2tensor(380),RedSet_5(26),mass5set(:,1),  & 
G1tensor(1513),G1tensor(1514),G1tensor(1515),G1tensor(1516),G1tensor(1517),G1tensor(1518))
  call G_TensorShift(G1tensor(1514),2)
  call Hotf_5pt_reduction_last(G2tensor(383),RedSet_5(26),mass5set(:,12),  & 
G1tensor(1519),G1tensor(1520),G1tensor(1521),G1tensor(1522),G1tensor(1523),G1tensor(1524))
  call G_TensorShift(G1tensor(1520),2)
  call Hotf_5pt_reduction_last(G2tensor(386),RedSet_5(26),mass5set(:,15),  & 
G1tensor(1525),G1tensor(1526),G1tensor(1527),G1tensor(1528),G1tensor(1529),G1tensor(1530))
  call G_TensorShift(G1tensor(1526),2)
  call Hotf_5pt_reduction_last(G2tensor(389),RedSet_5(26),mass5set(:,16),  & 
G1tensor(1531),G1tensor(1532),G1tensor(1533),G1tensor(1534),G1tensor(1535),G1tensor(1536))
  call G_TensorShift(G1tensor(1532),2)
  call Hotf_5pt_reduction_last(G2tensor(392),RedSet_5(26),mass5set(:,17),  & 
G1tensor(1537),G1tensor(1538),G1tensor(1539),G1tensor(1540),G1tensor(1541),G1tensor(1542))
  call G_TensorShift(G1tensor(1538),2)
  call ol_merge_tensors(T1sum(67),[G1tensor(1)])
  call ol_merge_tensors(T1sum(68),[G1tensor(37)])
  call ol_merge_tensors(T1sum(69),[G1tensor(73)])
  call ol_merge_tensors(T1sum(70),[G1tensor(109)])
  call ol_merge_tensors(T1sum(71),[G1tensor(145)])
  call ol_merge_tensors(T1sum(72),[G1tensor(181)])
  call ol_merge_tensors(T1sum(73),[G1tensor(217)])
  call ol_merge_tensors(T1sum(74),[G1tensor(253)])
  call ol_merge_tensors(T1sum(75),[G1tensor(289)])
  call ol_merge_tensors(T1sum(76),[G1tensor(325)])
  call ol_merge_tensors(T1sum(77),[G1tensor(361)])
  call ol_merge_tensors(T1sum(78),[G1tensor(2)])
  call ol_merge_tensors(T1sum(79),[G1tensor(38)])
  call ol_merge_tensors(T1sum(80),[G1tensor(74)])
  call ol_merge_tensors(T1sum(81),[G1tensor(110)])
  call ol_merge_tensors(T1sum(82),[G1tensor(146)])
  call ol_merge_tensors(T1sum(83),[G1tensor(182)])
  call ol_merge_tensors(T1sum(84),[G1tensor(218)])
  call ol_merge_tensors(T1sum(85),[G1tensor(254)])
  call ol_merge_tensors(T1sum(86),[G1tensor(290)])
  call ol_merge_tensors(T1sum(87),[G1tensor(326)])
  call ol_merge_tensors(T1sum(88),[G1tensor(362)])
  call ol_merge_tensors(T1sum(89),[G1tensor(9)])
  call ol_merge_tensors(T1sum(90),[G1tensor(204)])
  call ol_merge_tensors(T1sum(91),[G1tensor(210)])
  call ol_merge_tensors(T1sum(92),[G1tensor(41)])
  call ol_merge_tensors(T1sum(93),[G1tensor(118)])
  call ol_merge_tensors(T1sum(94),[G1tensor(47)])
  call ol_merge_tensors(T1sum(95),[G1tensor(228)])
  call ol_merge_tensors(T1sum(96),[G1tensor(240)])
  call ol_merge_tensors(T1sum(97),[G1tensor(63)])
  call ol_merge_tensors(T1sum(98),[G1tensor(150)])
  call ol_merge_tensors(T1sum(99),[G1tensor(83)])
  call ol_merge_tensors(T1sum(100),[G1tensor(89)])
  call ol_merge_tensors(T1sum(101),[G1tensor(316)])
  call ol_merge_tensors(T1sum(102),[G1tensor(95)])
  call ol_merge_tensors(T1sum(103),[G1tensor(328)])
  call ol_merge_tensors(T1sum(104),[G1tensor(186)])
  call ol_merge_tensors(T1sum(105),[G1tensor(105)])
  call ol_merge_tensors(T1sum(106),[G1tensor(131)])
  call ol_merge_tensors(T1sum(107),[G1tensor(137)])
  call ol_merge_tensors(T1sum(108),[G1tensor(270)])
  call ol_merge_tensors(T1sum(109),[G1tensor(282)])
  call ol_merge_tensors(T1sum(110),[G1tensor(300)])
  call ol_merge_tensors(T1sum(111),[G1tensor(167)])
  call ol_merge_tensors(T1sum(112),[G1tensor(179)])
  call ol_merge_tensors(T1sum(113),[G1tensor(183)])
  call ol_merge_tensors(T1sum(114),[G1tensor(191)])
  call ol_merge_tensors(T1sum(115),[G1tensor(388)])
  call ol_merge_tensors(T1sum(116),[G1tensor(197)])
  call ol_merge_tensors(T1sum(117),[G1tensor(215)])
  call ol_merge_tensors(T1sum(118),[G1tensor(225)])
  call ol_merge_tensors(T1sum(119),[G1tensor(274)])
  call ol_merge_tensors(T1sum(120),[G1tensor(286)])
  call ol_merge_tensors(T1sum(121),[G1tensor(292)])
  call ol_merge_tensors(T1sum(122),[G1tensor(251)])
  call ol_merge_tensors(T1sum(123),[G1tensor(281)])
  call ol_merge_tensors(T1sum(124),[G1tensor(293)])
  call ol_merge_tensors(T1sum(125),[G1tensor(321)])
  call ol_merge_tensors(T1sum(126),[G1tensor(333)])
  call ol_merge_tensors(T1sum(127),[G1tensor(339)])
  call ol_merge_tensors(T1sum(128),[G1tensor(372)])
  call ol_merge_tensors(T1sum(129),[G1tensor(347)])
  call ol_merge_tensors(T1sum(130),[G1tensor(396)])
  call ol_merge_tensors(T1sum(131),[G1tensor(381)])
  call ol_merge_tensors(T1sum(132),[G1tensor(389)])
  call ol_merge_tensors(T1sum(133),[G1tensor(397)])
  call ol_merge_tensors(T1sum(134),[G1tensor(403)])
  call ol_merge_tensors(T1sum(135),[G1tensor(409)])
  call ol_merge_tensors(T1sum(136),[G1tensor(415)])
  call ol_merge_tensors(T1sum(137),[G1tensor(421)])
  call ol_merge_tensors(T1sum(138),[G1tensor(427)])
  call ol_merge_tensors(T1sum(139),[G1tensor(433)])
  call ol_merge_tensors(T1sum(140),[G1tensor(439)])
  call ol_merge_tensors(T1sum(141),[G1tensor(445)])
  call ol_merge_tensors(T1sum(142),[G1tensor(451)])
  call ol_merge_tensors(T1sum(143),[G1tensor(457)])
  call ol_merge_tensors(T1sum(144),[G1tensor(463)])
  call ol_merge_tensors(T1sum(145),[G1tensor(469)])
  call ol_merge_tensors(T1sum(146),[G1tensor(475)])
  call ol_merge_tensors(T1sum(147),[G1tensor(481)])
  call ol_merge_tensors(T1sum(148),[G1tensor(487)])
  call ol_merge_tensors(T1sum(149),[G1tensor(493)])
  call ol_merge_tensors(T1sum(150),[G1tensor(499)])
  call ol_merge_tensors(T1sum(151),[G1tensor(505)])
  call ol_merge_tensors(T1sum(152),[G1tensor(511)])
  call ol_merge_tensors(T1sum(153),[G1tensor(517)])
  call ol_merge_tensors(T1sum(154),[G1tensor(523)])
  call ol_merge_tensors(T1sum(155),[G1tensor(529)])
  call ol_merge_tensors(T1sum(156),[G1tensor(535)])
  call ol_merge_tensors(T1sum(157),[G1tensor(541)])
  call ol_merge_tensors(T1sum(158),[G1tensor(547)])
  call ol_merge_tensors(T1sum(159),[G1tensor(553)])
  call ol_merge_tensors(T1sum(160),[G1tensor(559)])
  call ol_merge_tensors(T1sum(161),[G1tensor(565)])
  call ol_merge_tensors(T1sum(162),[G1tensor(571)])
  call ol_merge_tensors(T1sum(163),[G1tensor(577)])
  call ol_merge_tensors(T1sum(164),[G1tensor(583)])
  call ol_merge_tensors(T1sum(165),[G1tensor(589)])
  call ol_merge_tensors(T1sum(166),[G1tensor(595)])
  call ol_merge_tensors(T1sum(167),[G1tensor(601)])
  call ol_merge_tensors(T1sum(168),[G1tensor(607)])
  call ol_merge_tensors(T1sum(169),[G1tensor(613)])
  call ol_merge_tensors(T1sum(170),[G1tensor(619)])
  call ol_merge_tensors(T1sum(171),[G1tensor(625)])
  call ol_merge_tensors(T1sum(172),[G1tensor(631)])
  call ol_merge_tensors(T1sum(173),[G1tensor(637)])
  call ol_merge_tensors(T1sum(174),[G1tensor(643)])
  call ol_merge_tensors(T1sum(175),[G1tensor(649)])
  call ol_merge_tensors(T1sum(176),[G1tensor(655)])
  call ol_merge_tensors(T1sum(177),[G1tensor(661)])
  call ol_merge_tensors(T1sum(178),[G1tensor(667)])
  call ol_merge_tensors(T1sum(179),[G1tensor(673)])
  call ol_merge_tensors(T1sum(180),[G1tensor(679)])
  call ol_merge_tensors(T1sum(181),[G1tensor(685)])
  call ol_merge_tensors(T1sum(182),[G1tensor(691)])
  call ol_merge_tensors(T1sum(183),[G1tensor(697)])
  call ol_merge_tensors(T1sum(184),[G1tensor(703)])
  call ol_merge_tensors(T1sum(185),[G1tensor(709)])
  call ol_merge_tensors(T1sum(186),[G1tensor(715)])
  call ol_merge_tensors(T1sum(187),[G1tensor(721)])
  call ol_merge_tensors(T1sum(188),[G1tensor(727)])
  call ol_merge_tensors(T1sum(189),[G1tensor(733)])
  call ol_merge_tensors(T1sum(190),[G1tensor(739)])
  call ol_merge_tensors(T1sum(191),[G1tensor(745)])
  call ol_merge_tensors(T1sum(192),[G1tensor(751)])
  call ol_merge_tensors(T1sum(193),[G1tensor(757)])
  call ol_merge_tensors(T1sum(194),[G1tensor(763)])
  call ol_merge_tensors(T1sum(195),[G1tensor(769)])
  call ol_merge_tensors(T1sum(196),[G1tensor(775)])
  call ol_merge_tensors(T1sum(197),[G1tensor(781)])
  call ol_merge_tensors(T1sum(198),[G1tensor(787)])
  call ol_merge_tensors(T1sum(199),[G1tensor(793)])
  call ol_merge_tensors(T1sum(200),[G1tensor(799)])
  call ol_merge_tensors(T1sum(201),[G1tensor(805)])
  call ol_merge_tensors(T1sum(202),[G1tensor(811)])
  call ol_merge_tensors(T1sum(203),[G1tensor(817)])
  call ol_merge_tensors(T1sum(204),[G1tensor(823)])
  call ol_merge_tensors(T1sum(205),[G1tensor(829)])
  call ol_merge_tensors(T1sum(206),[G1tensor(835)])
  call ol_merge_tensors(T1sum(207),[G1tensor(841)])
  call ol_merge_tensors(T1sum(208),[G1tensor(847)])
  call ol_merge_tensors(T1sum(209),[G1tensor(853)])
  call ol_merge_tensors(T1sum(210),[G1tensor(859)])
  call ol_merge_tensors(T1sum(211),[G1tensor(865)])
  call ol_merge_tensors(T1sum(212),[G1tensor(871)])
  call ol_merge_tensors(T1sum(213),[G1tensor(877)])
  call ol_merge_tensors(T1sum(214),[G1tensor(883)])
  call ol_merge_tensors(T1sum(215),[G1tensor(889)])
  call ol_merge_tensors(T1sum(216),[G1tensor(895)])
  call ol_merge_tensors(T1sum(217),[G1tensor(901)])
  call ol_merge_tensors(T1sum(218),[G1tensor(907)])
  call ol_merge_tensors(T1sum(219),[G1tensor(913)])
  call ol_merge_tensors(T1sum(220),[G1tensor(919)])
  call ol_merge_tensors(T1sum(221),[G1tensor(925)])
  call ol_merge_tensors(T1sum(222),[G1tensor(931)])
  call ol_merge_tensors(T1sum(223),[G1tensor(937)])
  call ol_merge_tensors(T1sum(224),[G1tensor(943)])
  call ol_merge_tensors(T1sum(225),[G1tensor(949)])
  call ol_merge_tensors(T1sum(226),[G1tensor(955)])
  call ol_merge_tensors(T1sum(227),[G1tensor(961)])
  call ol_merge_tensors(T1sum(228),[G1tensor(967)])
  call ol_merge_tensors(T1sum(229),[G1tensor(973)])
  call ol_merge_tensors(T1sum(230),[G1tensor(979)])
  call ol_merge_tensors(T1sum(231),[G1tensor(985)])
  call ol_merge_tensors(T1sum(232),[G1tensor(991)])
  call ol_merge_tensors(T1sum(233),[G1tensor(997)])
  call ol_merge_tensors(T1sum(234),[G1tensor(1003)])
  call ol_merge_tensors(T1sum(235),[G1tensor(1009)])
  call ol_merge_tensors(T1sum(236),[G1tensor(1015)])
  call ol_merge_tensors(T1sum(237),[G1tensor(1021)])
  call ol_merge_tensors(T1sum(238),[G1tensor(1027)])
  call ol_merge_tensors(T1sum(239),[G1tensor(1033)])
  call ol_merge_tensors(T1sum(240),[G1tensor(1039)])
  call ol_merge_tensors(T1sum(241),[G1tensor(1045)])
  call ol_merge_tensors(T1sum(242),[G1tensor(1051)])
  call ol_merge_tensors(T1sum(243),[G1tensor(1057)])
  call ol_merge_tensors(T1sum(244),[G1tensor(1063)])
  call ol_merge_tensors(T1sum(245),[G1tensor(1069)])
  call ol_merge_tensors(T1sum(246),[G1tensor(1075)])
  call ol_merge_tensors(T1sum(247),[G1tensor(1081)])
  call ol_merge_tensors(T1sum(248),[G1tensor(1087)])
  call ol_merge_tensors(T1sum(249),[G1tensor(1093)])
  call ol_merge_tensors(T1sum(250),[G1tensor(1099)])
  call ol_merge_tensors(T1sum(251),[G1tensor(1105)])
  call ol_merge_tensors(T1sum(252),[G1tensor(1111)])
  call ol_merge_tensors(T1sum(253),[G1tensor(1117)])
  call ol_merge_tensors(T1sum(254),[G1tensor(1123)])
  call ol_merge_tensors(T1sum(255),[G1tensor(1129)])
  call ol_merge_tensors(T1sum(256),[G1tensor(1135)])
  call ol_merge_tensors(T1sum(257),[G1tensor(1141)])
  call ol_merge_tensors(T1sum(258),[G1tensor(1147)])
  call ol_merge_tensors(T1sum(259),[G1tensor(1153)])
  call ol_merge_tensors(T1sum(260),[G1tensor(1159)])
  call ol_merge_tensors(T1sum(261),[G1tensor(1165)])
  call ol_merge_tensors(T1sum(262),[G1tensor(1171)])
  call ol_merge_tensors(T1sum(263),[G1tensor(1177)])
  call ol_merge_tensors(T1sum(264),[G1tensor(1183)])
  call ol_merge_tensors(T1sum(265),[G1tensor(1189)])
  call ol_merge_tensors(T1sum(266),[G1tensor(1195)])
  call ol_merge_tensors(T1sum(267),[G1tensor(1201)])
  call ol_merge_tensors(T1sum(268),[G1tensor(1207)])
  call ol_merge_tensors(T1sum(269),[G1tensor(1213)])
  call ol_merge_tensors(T1sum(270),[G1tensor(1219)])
  call ol_merge_tensors(T1sum(271),[G1tensor(1225)])
  call ol_merge_tensors(T1sum(272),[G1tensor(1231)])
  call ol_merge_tensors(T1sum(273),[G1tensor(1237)])
  call ol_merge_tensors(T1sum(274),[G1tensor(1243)])
  call ol_merge_tensors(T1sum(275),[G1tensor(1249)])
  call ol_merge_tensors(T1sum(276),[G1tensor(1255)])
  call ol_merge_tensors(T1sum(277),[G1tensor(1261)])
  call ol_merge_tensors(T1sum(278),[G1tensor(1267)])
  call ol_merge_tensors(T1sum(279),[G1tensor(1273)])
  call ol_merge_tensors(T1sum(280),[G1tensor(1279)])
  call ol_merge_tensors(T1sum(281),[G1tensor(1285)])
  call ol_merge_tensors(T1sum(282),[G1tensor(1291)])
  call ol_merge_tensors(T1sum(283),[G1tensor(1297)])
  call ol_merge_tensors(T1sum(284),[G1tensor(1303)])
  call ol_merge_tensors(T1sum(285),[G1tensor(1309)])
  call ol_merge_tensors(T1sum(286),[G1tensor(1315)])
  call ol_merge_tensors(T1sum(287),[G1tensor(1321)])
  call ol_merge_tensors(T1sum(288),[G1tensor(1327)])
  call ol_merge_tensors(T1sum(289),[G1tensor(1333)])
  call ol_merge_tensors(T1sum(290),[G1tensor(1339)])
  call ol_merge_tensors(T1sum(291),[G1tensor(1345)])
  call ol_merge_tensors(T1sum(292),[G1tensor(1351)])
  call ol_merge_tensors(T1sum(293),[G1tensor(1357)])
  call ol_merge_tensors(T1sum(294),[G1tensor(1363)])
  call ol_merge_tensors(T1sum(295),[G1tensor(1369)])
  call ol_merge_tensors(T1sum(296),[G1tensor(1375)])
  call ol_merge_tensors(T1sum(297),[G1tensor(1381)])
  call ol_merge_tensors(T1sum(298),[G1tensor(1387)])
  call ol_merge_tensors(T1sum(299),[G1tensor(1393)])
  call ol_merge_tensors(T1sum(300),[G1tensor(1399)])
  call ol_merge_tensors(T1sum(301),[G1tensor(1405)])
  call ol_merge_tensors(T1sum(302),[G1tensor(1411)])
  call ol_merge_tensors(T1sum(303),[G1tensor(1417)])
  call ol_merge_tensors(T1sum(304),[G1tensor(1423)])
  call ol_merge_tensors(T1sum(305),[G1tensor(1429)])
  call ol_merge_tensors(T1sum(306),[G1tensor(1435)])
  call ol_merge_tensors(T1sum(307),[G1tensor(1441)])
  call ol_merge_tensors(T1sum(308),[G1tensor(1447)])
  call ol_merge_tensors(T1sum(309),[G1tensor(1453)])
  call ol_merge_tensors(T1sum(310),[G1tensor(1459)])
  call ol_merge_tensors(T1sum(311),[G1tensor(1465)])
  call ol_merge_tensors(T1sum(312),[G1tensor(1471)])
  call ol_merge_tensors(T1sum(313),[G1tensor(1477)])
  call ol_merge_tensors(T1sum(314),[G1tensor(1483)])
  call ol_merge_tensors(T1sum(315),[G1tensor(1489)])
  call ol_merge_tensors(T1sum(316),[G1tensor(1495)])
  call ol_merge_tensors(T1sum(317),[G1tensor(1501)])
  call ol_merge_tensors(T1sum(318),[G1tensor(1507)])
  call ol_merge_tensors(T1sum(319),[G1tensor(1513)])
  call ol_merge_tensors(T1sum(320),[G1tensor(1519)])
  call ol_merge_tensors(T1sum(321),[G1tensor(1525)])
  call ol_merge_tensors(T1sum(322),[G1tensor(1531)])
  call ol_merge_tensors(T1sum(323),[G1tensor(1537)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,145),heltab2x64(:,:,183))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(1),n2h32(19))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[32,12,3,16],[0,0,0,nMZ],4,2,wf4(:,2),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(16),ngZu,m3h2x32(:,146),heltab2x64(:,:,184))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(2),n2h32(20))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[32,12,3,16],[0,0,0,nMW],4,2,wf4(:,2),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,147),heltab2x64(:,:,185))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(3),n2h32(21))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[32,12,3,16],[0,0,0,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,148),heltab2x64(:,:,186))
  call Hloop_A_Q(ntryL,G0H32(18),32,0,G1H32(4),n2h32(22))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[32,12,3,16],[0,0,0,nMZ],4,2,wf4(:,3),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(19),ngZu,m3h2x32(:,149),heltab2x64(:,:,187))
  call Hloop_A_Q(ntryL,G0H32(19),32,0,G1H32(5),n2h32(23))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[32,12,3,16],[0,0,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,150),heltab2x64(:,:,188))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(6),n2h32(24))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,151),heltab2x64(:,:,189))
  call Hloop_A_Q(ntryL,G0H32(11),32,0,G1H32(7),n2h32(25))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,12,3,16],[0,0,0,nMZ],4,2,wf4(:,2),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(12),ngZu,m3h2x32(:,152),heltab2x64(:,:,190))
  call Hloop_A_Q(ntryL,G0H32(12),32,0,G1H32(8),n2h32(26))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,12,3,16],[0,0,0,nMW],4,2,wf4(:,2),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,153),heltab2x64(:,:,191))
  call Hloop_A_Q(ntryL,G0H32(21),32,0,G1H32(9),n2h32(27))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[32,12,3,16],[0,0,0,0],4,2,wf4(:,3),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,154),heltab2x64(:,:,192))
  call Hloop_A_Q(ntryL,G0H32(22),32,0,G1H32(10),n2h32(28))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[32,12,3,16],[0,0,0,nMZ],4,2,wf4(:,3),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),ngZu,m3h2x32(:,155),heltab2x64(:,:,193))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(11),n2h32(29))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[32,12,3,16],[0,0,0,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,156),heltab2x64(:,:,194))
  call Hloop_A_Q(ntryL,G0H32(24),32,0,G1H32(12),n2h32(30))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,12,3,16],[nMW,nMW,nMW,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,157),heltab2x64(:,:,195))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[32,12,3,16],[nMW,nMW,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,158),heltab2x64(:,:,196))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,12,3,16],[nMW,nMW,nMW,0],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,159),heltab2x64(:,:,197))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[32,12,3,16],[nMZ,nMH,nMZ,0],4,2,wf4(:,3),wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(28),ngZu,m3h2x32(:,160),heltab2x64(:,:,198))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,12,3,16],[nMW,nMW,nMW,0],4,2,wf4(:,3),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,161),heltab2x64(:,:,199))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,12,3,16],[nMW,nMW,nMW,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,162),heltab2x64(:,:,200))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,12,3,16],[nMW,nMW,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,163),heltab2x64(:,:,201))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,12,3,16],[nMW,nMW,nMW,0],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,164),heltab2x64(:,:,202))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,12,3,16],[nMW,nMW,nMW,0],4,2,wf4(:,3),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,165),heltab2x64(:,:,203))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,166),heltab2x64(:,:,204))
  call Hloop_A_Q(ntryL,G0H32(34),32,0,G1H32(13),n2h32(31))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,3,12,16],[0,0,0,nMZ],4,2,wf4(:,1),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZu,m3h2x32(:,167),heltab2x64(:,:,205))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(14),n2h32(32))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,3,12,16],[0,0,0,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,168),heltab2x64(:,:,206))
  call Hloop_A_Q(ntryL,G0H32(36),32,0,G1H32(15),n2h32(33))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,169),heltab2x64(:,:,207))
  call Hloop_A_Q(ntryL,G0H32(37),32,0,G1H32(16),n2h32(34))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,3,12,16],[0,0,0,nMZ],4,2,wf4(:,1),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(38),ngZu,m3h2x32(:,170),heltab2x64(:,:,208))
  call Hloop_A_Q(ntryL,G0H32(38),32,0,G1H32(17),n2h32(35))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[32,3,12,16],[0,0,0,nMW],4,2,wf4(:,1),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,171),heltab2x64(:,:,209))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(18),n2h32(36))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[32,3,12,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,172),heltab2x64(:,:,210))
  call Hloop_A_Q(ntryL,G0H32(40),32,0,G1H32(19),n2h32(37))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,3,12,16],[0,0,0,nMZ],4,2,wf4(:,4),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(41),ngZu,m3h2x32(:,173),heltab2x64(:,:,211))
  call Hloop_A_Q(ntryL,G0H32(41),32,0,G1H32(20),n2h32(38))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,3,12,16],[0,0,0,nMW],4,2,wf4(:,4),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,174),heltab2x64(:,:,212))
  call Hloop_A_Q(ntryL,G0H32(42),32,0,G1H32(21),n2h32(39))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,3,12,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,175),heltab2x64(:,:,213))
  call Hloop_A_Q(ntryL,G0H32(43),32,0,G1H32(22),n2h32(40))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,3,12,16],[0,0,0,nMZ],4,2,wf4(:,4),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),ngZu,m3h2x32(:,176),heltab2x64(:,:,214))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(23),n2h32(41))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,3,12,16],[0,0,0,nMW],4,2,wf4(:,4),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,177),heltab2x64(:,:,215))
  call Hloop_A_Q(ntryL,G0H32(45),32,0,G1H32(24),n2h32(42))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,3,12,16],[nMW,nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,178),heltab2x64(:,:,216))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,3,12,16],[nMW,nMW,nMW,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,179),heltab2x64(:,:,217))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,3,12,16],[nMW,nMW,nMW,0],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,180),heltab2x64(:,:,218))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[32,3,12,16],[nMZ,nMH,nMZ,0],4,2,wf4(:,4),wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(49),ngZu,m3h2x32(:,181),heltab2x64(:,:,219))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[32,3,12,16],[nMW,nMW,nMW,0],4,2,wf4(:,4),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,182),heltab2x64(:,:,220))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[32,3,12,16],[nMW,nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,183),heltab2x64(:,:,221))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[32,3,12,16],[nMW,nMW,nMW,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,184),heltab2x64(:,:,222))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,3,12,16],[nMW,nMW,nMW,0],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,185),heltab2x64(:,:,223))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[32,3,12,16],[nMW,nMW,nMW,0],4,2,wf4(:,4),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(54),m3h2x32(:,186),heltab2x64(:,:,224))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,3,16,12],[0,0,nMW,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,187),heltab2x64(:,:,225))
  call Hloop_A_Q(ntryL,G0H32(55),32,0,G1H32(25),n2h32(43))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[32,3,16,12],[0,0,nMW,nMW],4,2,wf4(:,1),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(56),m3h2x32(:,188),heltab2x64(:,:,226))
  call Hloop_A_Q(ntryL,G0H32(56),32,0,G1H32(26),n2h32(44))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,3,16,12],[0,0,nMW,nMW],4,2,wf4(:,4),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(57),m3h2x32(:,189),heltab2x64(:,:,227))
  call Hloop_A_Q(ntryL,G0H32(57),32,0,G1H32(27),n2h32(45))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,3,16,12],[0,0,nMW,nMW],4,2,wf4(:,4),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,190),heltab2x64(:,:,228))
  call Hloop_A_Q(ntryL,G0H32(58),32,0,G1H32(28),n2h32(46))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,3,16,12],[nMW,nMW,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,191),heltab2x64(:,:,229))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[32,3,16,12],[nMW,nMW,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,192),heltab2x64(:,:,230))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[32,3,16,12],[nMW,nMW,0,0],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(61),m3h2x32(:,193),heltab2x64(:,:,231))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[32,3,16,12],[nMW,nMW,0,0],4,2,wf4(:,4),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(62),m3h2x32(:,194),heltab2x64(:,:,232))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[48,3,4,8],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,39),heltab2x64(:,:,233))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(5),n2h16(157))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[48,3,4,8],[0,0,nMZ,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,40),heltab2x64(:,:,234))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(6),n2h16(158))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[48,3,4,8],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,41),heltab2x64(:,:,235))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(7),n2h16(159))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[48,3,4,8],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,42),heltab2x64(:,:,236))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(8),n2h16(160))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[48,3,4,8],[0,0,0,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,43),heltab2x64(:,:,237))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(13),n2h16(161))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[48,3,4,8],[0,0,nMZ,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,44),heltab2x64(:,:,238))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(14),n2h16(162))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[48,3,4,8],[0,0,0,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,45),heltab2x64(:,:,239))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(15),n2h16(163))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[48,3,4,8],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,46),heltab2x64(:,:,240))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(16),n2h16(164))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[48,3,4,8],[0,0,nMW,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZn,m3h4x16(:,47),heltab2x64(:,:,241))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(17),n2h16(165))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,48),heltab2x64(:,:,242))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(2),m3h4x16(:,49),heltab2x64(:,:,243))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(3),m3h4x16(:,50),heltab2x64(:,:,244))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[48,3,4,8],[nMH,nMZ,0,nMZ],4,2,wf4(:,6),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(4),m3h4x16(:,51),heltab2x64(:,:,245))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,52),heltab2x64(:,:,246))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(19),m3h4x16(:,53),heltab2x64(:,:,247))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(21),m3h4x16(:,54),heltab2x64(:,:,248))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(26),m3h4x16(:,55),heltab2x64(:,:,249))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[48,3,4,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(27),m3h4x16(:,56),heltab2x64(:,:,250))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[48,3,8,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,57),heltab2x64(:,:,251))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(28),n2h16(166))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[48,3,8,4],[0,0,nMZ,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,58),heltab2x64(:,:,252))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(29),n2h16(167))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[48,3,8,4],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(6),ngZl,m3h4x16(:,59),heltab2x64(:,:,253))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(34),n2h16(168))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[48,3,8,4],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(6),ngZl,m3h4x16(:,60),heltab2x64(:,:,254))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(35),n2h16(169))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[48,3,8,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,61),heltab2x64(:,:,255))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(36),n2h16(170))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[48,3,8,4],[0,0,nMZ,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,62),heltab2x64(:,:,256))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(37),n2h16(171))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[48,3,8,4],[0,0,0,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(6),ngZl,m3h4x16(:,63),heltab2x64(:,:,257))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(38),n2h16(172))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[48,3,8,4],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(6),ngZl,m3h4x16(:,64),heltab2x64(:,:,258))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(39),n2h16(173))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[48,3,8,4],[0,0,nMW,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(6),ngZn,m3h4x16(:,65),heltab2x64(:,:,259))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(40),n2h16(174))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,66),heltab2x64(:,:,260))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(7),m3h4x16(:,67),heltab2x64(:,:,261))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(8),m3h4x16(:,68),heltab2x64(:,:,262))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[48,3,8,4],[nMH,nMZ,0,nMZ],4,2,wf4(:,6),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(9),m3h4x16(:,69),heltab2x64(:,:,263))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(10),m3h4x16(:,70),heltab2x64(:,:,264))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(41),m3h4x16(:,71),heltab2x64(:,:,265))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(42),m3h4x16(:,72),heltab2x64(:,:,266))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,5),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(43),m3h4x16(:,73),heltab2x64(:,:,267))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[48,3,8,4],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(44),m3h4x16(:,74),heltab2x64(:,:,268))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[48,4,3,8],[nMW,0,0,nMW],4,2,wf4(:,5),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(45),m3h4x16(:,75),heltab2x64(:,:,269))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[48,4,3,8],[nMW,0,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(46),m3h4x16(:,76),heltab2x64(:,:,270))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[48,4,3,8],[0,nMW,nMW,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(11),ngZn,m3h4x16(:,77),heltab2x64(:,:,271))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(47),n2h16(175))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[48,4,3,8],[0,nMW,nMW,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(11),ngZn,m3h4x16(:,78),heltab2x64(:,:,272))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(48),n2h16(176))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[32,7,8,16],[0,0,0,0],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(63),m3h2x32(:,195),heltab2x64(:,:,273))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[32,7,8,16],[nMZ,0,0,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(64),ngZu,m3h2x32(:,196),heltab2x64(:,:,274))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,7,8,16],[0,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,197),heltab2x64(:,:,275))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,7,8,16],[nMZ,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(66),ngZu,m3h2x32(:,198),heltab2x64(:,:,276))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[32,7,8,16],[0,0,0,0],4,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,199),heltab2x64(:,:,277))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[32,7,8,16],[nMZ,0,0,0],4,1,wf8(:,18))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZu,m3h2x32(:,200),heltab2x64(:,:,278))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,7,8,16],[0,0,nMZ,0],4,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,201),heltab2x64(:,:,279))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[32,7,8,16],[nMZ,0,nMZ,0],4,1,wf8(:,18))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZu,m3h2x32(:,202),heltab2x64(:,:,280))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[32,8,7,16],[0,0,0,0],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,203),heltab2x64(:,:,281))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[32,8,7,16],[0,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,204),heltab2x64(:,:,282))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[32,8,7,16],[nMZ,0,0,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZu,m3h2x32(:,205),heltab2x64(:,:,283))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[32,8,7,16],[nMZ,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZu,m3h2x32(:,206),heltab2x64(:,:,284))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[32,8,7,16],[nMW,0,nMW,0],4,1,wf8(:,15))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,207),heltab2x64(:,:,285))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[32,8,7,16],[0,0,0,0],4,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,208),heltab2x64(:,:,286))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[32,8,7,16],[0,0,nMZ,0],4,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,209),heltab2x64(:,:,287))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[32,8,7,16],[nMZ,0,0,0],4,1,wf8(:,18))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(14),ngZu,m3h2x32(:,210),heltab2x64(:,:,288))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[32,8,7,16],[nMZ,0,nMZ,0],4,1,wf8(:,18))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZu,m3h2x32(:,211),heltab2x64(:,:,289))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[32,8,7,16],[nMW,0,nMW,0],4,1,wf8(:,18))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,212),heltab2x64(:,:,290))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[32,11,4,16],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,213),heltab2x64(:,:,291))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[32,11,4,16],[nMZ,0,0,0],4,1,wf8(:,60))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZu,m3h2x32(:,214),heltab2x64(:,:,292))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[32,11,4,16],[0,0,nMZ,0],4,1,wf8(:,60))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,215),heltab2x64(:,:,293))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[32,11,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,60))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(20),ngZu,m3h2x32(:,216),heltab2x64(:,:,294))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[32,11,4,16],[nMW,0,nMW,0],4,1,wf8(:,60))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,217),heltab2x64(:,:,295))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[32,11,4,16],[0,0,0,0],4,1,wf8(:,62))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,218),heltab2x64(:,:,296))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[32,11,4,16],[nMZ,0,0,0],4,1,wf8(:,62))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(21),ngZu,m3h2x32(:,219),heltab2x64(:,:,297))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[32,11,4,16],[0,0,nMZ,0],4,1,wf8(:,62))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,220),heltab2x64(:,:,298))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[32,11,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,62))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(23),ngZu,m3h2x32(:,221),heltab2x64(:,:,299))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[32,11,4,16],[nMW,0,nMW,0],4,1,wf8(:,62))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,222),heltab2x64(:,:,300))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[32,4,11,16],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,223),heltab2x64(:,:,301))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[32,4,11,16],[0,0,nMZ,0],4,1,wf8(:,60))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,224),heltab2x64(:,:,302))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[32,4,11,16],[nMZ,0,0,0],4,1,wf8(:,60))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(36),ngZu,m3h2x32(:,225),heltab2x64(:,:,303))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[32,4,11,16],[nMZ,0,nMZ,0],4,1,wf8(:,60))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(37),ngZu,m3h2x32(:,226),heltab2x64(:,:,304))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[32,4,11,16],[0,0,0,0],4,1,wf8(:,62))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,227),heltab2x64(:,:,305))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[32,4,11,16],[0,0,nMZ,0],4,1,wf8(:,62))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,228),heltab2x64(:,:,306))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[32,4,11,16],[nMZ,0,0,0],4,1,wf8(:,62))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(40),ngZu,m3h2x32(:,229),heltab2x64(:,:,307))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[32,4,11,16],[nMZ,0,nMZ,0],4,1,wf8(:,62))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(41),ngZu,m3h2x32(:,230),heltab2x64(:,:,308))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[32,4,8,19],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,231),heltab2x64(:,:,309))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[32,4,8,19],[0,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,232),heltab2x64(:,:,310))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[32,4,8,19],[nMZ,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(44),ngZu,m3h2x32(:,233),heltab2x64(:,:,311))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[32,4,8,19],[nMZ,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(45),ngZu,m3h2x32(:,234),heltab2x64(:,:,312))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[32,4,8,19],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,235),heltab2x64(:,:,313))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[32,4,8,19],[0,0,nMZ,0],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(56),m3h2x32(:,236),heltab2x64(:,:,314))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[32,4,8,19],[nMZ,0,0,0],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(57),ngZu,m3h2x32(:,237),heltab2x64(:,:,315))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[32,4,8,19],[nMZ,0,nMZ,0],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(58),ngZu,m3h2x32(:,238),heltab2x64(:,:,316))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[32,8,4,19],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(67),m3h2x32(:,239),heltab2x64(:,:,317))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[32,8,4,19],[nMZ,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(68),ngZu,m3h2x32(:,240),heltab2x64(:,:,318))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[32,8,4,19],[0,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,241),heltab2x64(:,:,319))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[32,8,4,19],[nMZ,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(70),ngZu,m3h2x32(:,242),heltab2x64(:,:,320))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[32,8,4,19],[nMW,0,nMW,0],4,1,wf8(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(71),m3h2x32(:,243),heltab2x64(:,:,321))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[32,8,4,19],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(72),m3h2x32(:,244),heltab2x64(:,:,322))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[32,8,4,19],[nMZ,0,0,0],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(73),ngZu,m3h2x32(:,245),heltab2x64(:,:,323))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[32,8,4,19],[0,0,nMZ,0],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(74),m3h2x32(:,246),heltab2x64(:,:,324))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[32,8,4,19],[nMZ,0,nMZ,0],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(75),ngZu,m3h2x32(:,247),heltab2x64(:,:,325))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[32,8,4,19],[nMW,0,nMW,0],4,1,wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(76),m3h2x32(:,248),heltab2x64(:,:,326))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[35,8,4,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,42),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,327))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[35,8,4,16],[nMZ,0,0,0],4,1,wf8(:,42))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,42),G0H8(2),ngZu,m3h8x8(:,2),heltab2x64(:,:,328))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[35,8,4,16],[0,0,nMZ,0],4,1,wf8(:,42))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,42),G0H8(3),m3h8x8(:,3),heltab2x64(:,:,329))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[35,8,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,42))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,42),G0H8(4),ngZu,m3h8x8(:,4),heltab2x64(:,:,330))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[35,8,4,16],[nMW,0,nMW,0],4,1,wf8(:,42))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,42),G0H8(5),m3h8x8(:,5),heltab2x64(:,:,331))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[35,8,4,16],[0,0,0,0],4,1,wf8(:,44))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,44),G0H8(6),m3h8x8(:,6),heltab2x64(:,:,332))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[35,8,4,16],[nMZ,0,0,0],4,1,wf8(:,44))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,44),G0H8(7),ngZu,m3h8x8(:,7),heltab2x64(:,:,333))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[35,8,4,16],[0,0,nMZ,0],4,1,wf8(:,44))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,44),G0H8(8),m3h8x8(:,8),heltab2x64(:,:,334))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[35,8,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,44))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,44),G0H8(9),ngZu,m3h8x8(:,9),heltab2x64(:,:,335))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[35,8,4,16],[nMW,0,nMW,0],4,1,wf8(:,44))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,44),G0H8(10),m3h8x8(:,10),heltab2x64(:,:,336))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[35,4,8,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,42),G0H8(11),m3h8x8(:,11),heltab2x64(:,:,337))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[35,4,8,16],[0,0,nMZ,0],4,1,wf8(:,42))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,42),G0H8(12),m3h8x8(:,12),heltab2x64(:,:,338))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[35,4,8,16],[nMZ,0,0,0],4,1,wf8(:,42))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,42),G0H8(13),ngZu,m3h8x8(:,13),heltab2x64(:,:,339))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[35,4,8,16],[nMZ,0,nMZ,0],4,1,wf8(:,42))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,42),G0H8(14),ngZu,m3h8x8(:,14),heltab2x64(:,:,340))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[35,4,8,16],[0,0,0,0],4,1,wf8(:,44))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,44),G0H8(15),m3h8x8(:,15),heltab2x64(:,:,341))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[35,4,8,16],[0,0,nMZ,0],4,1,wf8(:,44))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,44),G0H8(16),m3h8x8(:,16),heltab2x64(:,:,342))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[35,4,8,16],[nMZ,0,0,0],4,1,wf8(:,44))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,44),G0H8(17),ngZu,m3h8x8(:,17),heltab2x64(:,:,343))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[35,4,8,16],[nMZ,0,nMZ,0],4,1,wf8(:,44))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,44),G0H8(18),ngZu,m3h8x8(:,18),heltab2x64(:,:,344))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[48,2,1,12],[0,0,0,0],4,2,wf4(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,79),heltab2x64(:,:,345))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(49),n2h16(177))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[48,2,1,12],[0,nMZ,0,0],4,2,wf4(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,80),heltab2x64(:,:,346))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(50),n2h16(178))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[48,2,1,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(11),ngZl,m3h4x16(:,81),heltab2x64(:,:,347))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(51),n2h16(179))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[48,2,1,12],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(11),ngZl,m3h4x16(:,82),heltab2x64(:,:,348))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(52),n2h16(180))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[48,2,1,12],[0,0,0,0],4,2,wf4(:,5),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,83),heltab2x64(:,:,349))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(53),n2h16(181))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[48,2,1,12],[0,nMZ,0,0],4,2,wf4(:,5),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,84),heltab2x64(:,:,350))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(54),n2h16(182))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[48,2,1,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(11),ngZl,m3h4x16(:,85),heltab2x64(:,:,351))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(55),n2h16(183))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[48,2,1,12],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(11),ngZl,m3h4x16(:,86),heltab2x64(:,:,352))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(56),n2h16(184))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[48,2,1,12],[0,nMW,0,0],4,2,wf4(:,6),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(11),ngZn,m3h4x16(:,87),heltab2x64(:,:,353))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(57),n2h16(185))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,88),heltab2x64(:,:,354))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(12),m3h4x16(:,89),heltab2x64(:,:,355))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(13),m3h4x16(:,90),heltab2x64(:,:,356))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[48,2,1,12],[nMZ,0,nMZ,nMH],4,2,wf4(:,6),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(14),m3h4x16(:,91),heltab2x64(:,:,357))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(15),m3h4x16(:,92),heltab2x64(:,:,358))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(58),m3h4x16(:,93),heltab2x64(:,:,359))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(59),m3h4x16(:,94),heltab2x64(:,:,360))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(60),m3h4x16(:,95),heltab2x64(:,:,361))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[48,2,1,12],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(61),m3h4x16(:,96),heltab2x64(:,:,362))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[48,1,2,12],[0,0,0,0],4,2,wf4(:,5),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(16),m3h4x16(:,97),heltab2x64(:,:,363))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(62),n2h16(186))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[48,1,2,12],[0,nMZ,0,0],4,2,wf4(:,5),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(16),m3h4x16(:,98),heltab2x64(:,:,364))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(63),n2h16(187))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[48,1,2,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(16),ngZl,m3h4x16(:,99),heltab2x64(:,:,365))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(64),n2h16(188))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[48,1,2,12],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(16),ngZl,m3h4x16(:,100),heltab2x64(:,:,366))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(65),n2h16(189))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[48,1,2,12],[0,0,0,0],4,2,wf4(:,5),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(16),m3h4x16(:,101),heltab2x64(:,:,367))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(66),n2h16(190))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[48,1,2,12],[0,nMZ,0,0],4,2,wf4(:,5),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(16),m3h4x16(:,102),heltab2x64(:,:,368))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(1),n2h16(191))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[48,1,2,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(16),ngZl,m3h4x16(:,103),heltab2x64(:,:,369))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(2),n2h16(192))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[48,1,2,12],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(16),ngZl,m3h4x16(:,104),heltab2x64(:,:,370))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(3),n2h16(193))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[48,1,2,12],[0,nMW,0,0],4,2,wf4(:,6),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(16),ngZn,m3h4x16(:,105),heltab2x64(:,:,371))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(4),n2h16(194))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(16),m3h4x16(:,106),heltab2x64(:,:,372))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(17),m3h4x16(:,107),heltab2x64(:,:,373))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(18),m3h4x16(:,108),heltab2x64(:,:,374))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[48,1,2,12],[nMZ,0,nMZ,nMH],4,2,wf4(:,6),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(19),m3h4x16(:,109),heltab2x64(:,:,375))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(20),m3h4x16(:,110),heltab2x64(:,:,376))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(9),m3h4x16(:,111),heltab2x64(:,:,377))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(10),m3h4x16(:,112),heltab2x64(:,:,378))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,5),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(11),m3h4x16(:,113),heltab2x64(:,:,379))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[48,1,2,12],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(12),m3h4x16(:,114),heltab2x64(:,:,380))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[48,1,12,2],[nMW,0,0,nMW],4,2,wf4(:,5),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(18),m3h4x16(:,115),heltab2x64(:,:,381))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[48,1,12,2],[nMW,0,0,nMW],4,2,wf4(:,6),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(20),m3h4x16(:,116),heltab2x64(:,:,382))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[48,1,12,2],[0,nMW,nMW,0],4,2,wf4(:,6),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(21),ngZn,m3h4x16(:,117),heltab2x64(:,:,383))
  call Hloop_A_Q(ntryL,G0H16(21),48,0,G1H16(22),n2h16(195))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[48,1,12,2],[0,nMW,nMW,0],4,2,wf4(:,6),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(21),ngZn,m3h4x16(:,118),heltab2x64(:,:,384))
  call Hloop_A_Q(ntryL,G0H16(21),48,0,G1H16(23),n2h16(196))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[32,13,2,16],[0,0,0,0],4,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,249),heltab2x64(:,:,385))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[32,13,2,16],[nMZ,0,0,0],4,1,wf8(:,27))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(78),ngZu,m3h2x32(:,250),heltab2x64(:,:,386))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[32,13,2,16],[0,0,nMZ,0],4,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(79),m3h2x32(:,251),heltab2x64(:,:,387))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[32,13,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,27))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(80),ngZu,m3h2x32(:,252),heltab2x64(:,:,388))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[32,13,2,16],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,253),heltab2x64(:,:,389))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[32,13,2,16],[nMZ,0,0,0],4,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(82),ngZu,m3h2x32(:,254),heltab2x64(:,:,390))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[32,13,2,16],[0,0,nMZ,0],4,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(83),m3h2x32(:,255),heltab2x64(:,:,391))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[32,13,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(84),ngZu,m3h2x32(:,256),heltab2x64(:,:,392))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[32,2,13,16],[0,0,0,0],4,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(85),m3h2x32(:,257),heltab2x64(:,:,393))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[32,2,13,16],[0,0,nMZ,0],4,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(86),m3h2x32(:,258),heltab2x64(:,:,394))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[32,2,13,16],[nMZ,0,0,0],4,1,wf8(:,27))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(87),ngZu,m3h2x32(:,259),heltab2x64(:,:,395))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[32,2,13,16],[nMZ,0,nMZ,0],4,1,wf8(:,27))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(88),ngZu,m3h2x32(:,260),heltab2x64(:,:,396))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[32,2,13,16],[nMW,0,nMW,0],4,1,wf8(:,27))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(89),m3h2x32(:,261),heltab2x64(:,:,397))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[32,2,13,16],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(90),m3h2x32(:,262),heltab2x64(:,:,398))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[32,2,13,16],[0,0,nMZ,0],4,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(91),m3h2x32(:,263),heltab2x64(:,:,399))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[32,2,13,16],[nMZ,0,0,0],4,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(92),ngZu,m3h2x32(:,264),heltab2x64(:,:,400))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[32,2,13,16],[nMZ,0,nMZ,0],4,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(93),ngZu,m3h2x32(:,265),heltab2x64(:,:,401))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[32,2,13,16],[nMW,0,nMW,0],4,1,wf8(:,30))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,266),heltab2x64(:,:,402))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[32,14,1,16],[0,0,0,0],4,1,wf8(:,94))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(95),m3h2x32(:,267),heltab2x64(:,:,403))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[32,14,1,16],[nMZ,0,0,0],4,1,wf8(:,94))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(96),ngZu,m3h2x32(:,268),heltab2x64(:,:,404))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[32,14,1,16],[0,0,nMZ,0],4,1,wf8(:,94))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(97),m3h2x32(:,269),heltab2x64(:,:,405))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[32,14,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,94))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(98),ngZu,m3h2x32(:,270),heltab2x64(:,:,406))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[32,14,1,16],[nMW,0,nMW,0],4,1,wf8(:,94))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(99),m3h2x32(:,271),heltab2x64(:,:,407))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[32,14,1,16],[0,0,0,0],4,1,wf8(:,95))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(100),m3h2x32(:,272),heltab2x64(:,:,408))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[32,14,1,16],[nMZ,0,0,0],4,1,wf8(:,95))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(101),ngZu,m3h2x32(:,273),heltab2x64(:,:,409))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[32,14,1,16],[0,0,nMZ,0],4,1,wf8(:,95))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(102),m3h2x32(:,274),heltab2x64(:,:,410))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[32,14,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,95))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(103),ngZu,m3h2x32(:,275),heltab2x64(:,:,411))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[32,14,1,16],[nMW,0,nMW,0],4,1,wf8(:,95))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(104),m3h2x32(:,276),heltab2x64(:,:,412))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[32,1,14,16],[0,0,0,0],4,1,wf8(:,94))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(105),m3h2x32(:,277),heltab2x64(:,:,413))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[32,1,14,16],[0,0,nMZ,0],4,1,wf8(:,94))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(106),m3h2x32(:,278),heltab2x64(:,:,414))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[32,1,14,16],[nMZ,0,0,0],4,1,wf8(:,94))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(107),ngZu,m3h2x32(:,279),heltab2x64(:,:,415))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[32,1,14,16],[nMZ,0,nMZ,0],4,1,wf8(:,94))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(108),ngZu,m3h2x32(:,280),heltab2x64(:,:,416))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[32,1,14,16],[0,0,0,0],4,1,wf8(:,95))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(109),m3h2x32(:,281),heltab2x64(:,:,417))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[32,1,14,16],[0,0,nMZ,0],4,1,wf8(:,95))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(110),m3h2x32(:,282),heltab2x64(:,:,418))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[32,1,14,16],[nMZ,0,0,0],4,1,wf8(:,95))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(111),ngZu,m3h2x32(:,283),heltab2x64(:,:,419))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[32,1,14,16],[nMZ,0,nMZ,0],4,1,wf8(:,95))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(112),ngZu,m3h2x32(:,284),heltab2x64(:,:,420))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[32,1,2,28],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,285),heltab2x64(:,:,421))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[32,1,2,28],[0,0,nMZ,0],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(114),m3h2x32(:,286),heltab2x64(:,:,422))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[32,1,2,28],[nMZ,0,0,0],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(115),ngZu,m3h2x32(:,287),heltab2x64(:,:,423))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[32,1,2,28],[nMZ,0,nMZ,0],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(116),ngZu,m3h2x32(:,288),heltab2x64(:,:,424))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[32,1,2,28],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(117),m3h2x32(:,289),heltab2x64(:,:,425))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[32,1,2,28],[0,0,nMZ,0],4,1,wf8(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(118),m3h2x32(:,290),heltab2x64(:,:,426))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[32,1,2,28],[nMZ,0,0,0],4,1,wf8(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(119),ngZu,m3h2x32(:,291),heltab2x64(:,:,427))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[32,1,2,28],[nMZ,0,nMZ,0],4,1,wf8(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(120),ngZu,m3h2x32(:,292),heltab2x64(:,:,428))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[32,2,1,28],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,293),heltab2x64(:,:,429))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[32,2,1,28],[nMZ,0,0,0],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(122),ngZu,m3h2x32(:,294),heltab2x64(:,:,430))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[32,2,1,28],[0,0,nMZ,0],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(123),m3h2x32(:,295),heltab2x64(:,:,431))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[32,2,1,28],[nMZ,0,nMZ,0],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(124),ngZu,m3h2x32(:,296),heltab2x64(:,:,432))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(433),h0tab(:,433),[32,2,1,28],[nMW,0,nMW,0],4,1,wf8(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(125),m3h2x32(:,297),heltab2x64(:,:,433))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(434),h0tab(:,434),[32,2,1,28],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(126),m3h2x32(:,298),heltab2x64(:,:,434))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(435),h0tab(:,435),[32,2,1,28],[nMZ,0,0,0],4,1,wf8(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(127),ngZu,m3h2x32(:,299),heltab2x64(:,:,435))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(436),h0tab(:,436),[32,2,1,28],[0,0,nMZ,0],4,1,wf8(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(128),m3h2x32(:,300),heltab2x64(:,:,436))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(437),h0tab(:,437),[32,2,1,28],[nMZ,0,nMZ,0],4,1,wf8(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(129),ngZu,m3h2x32(:,301),heltab2x64(:,:,437))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(438),h0tab(:,438),[32,2,1,28],[nMW,0,nMW,0],4,1,wf8(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(130),m3h2x32(:,302),heltab2x64(:,:,438))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(439),h0tab(:,439),[44,2,1,16],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,46),G0H8(19),m3h8x8(:,19),heltab2x64(:,:,439))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(440),h0tab(:,440),[44,2,1,16],[nMZ,0,0,0],4,1,wf8(:,46))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,46),G0H8(20),ngZu,m3h8x8(:,20),heltab2x64(:,:,440))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(441),h0tab(:,441),[44,2,1,16],[0,0,nMZ,0],4,1,wf8(:,46))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,46),G0H8(21),m3h8x8(:,21),heltab2x64(:,:,441))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(442),h0tab(:,442),[44,2,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,46))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,46),G0H8(22),ngZu,m3h8x8(:,22),heltab2x64(:,:,442))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(443),h0tab(:,443),[44,2,1,16],[nMW,0,nMW,0],4,1,wf8(:,46))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,46),G0H8(23),m3h8x8(:,23),heltab2x64(:,:,443))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(444),h0tab(:,444),[44,2,1,16],[0,0,0,0],4,1,wf8(:,47))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,47),G0H8(24),m3h8x8(:,24),heltab2x64(:,:,444))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(445),h0tab(:,445),[44,2,1,16],[nMZ,0,0,0],4,1,wf8(:,47))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,47),G0H8(25),ngZu,m3h8x8(:,25),heltab2x64(:,:,445))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(446),h0tab(:,446),[44,2,1,16],[0,0,nMZ,0],4,1,wf8(:,47))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,47),G0H8(26),m3h8x8(:,26),heltab2x64(:,:,446))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(447),h0tab(:,447),[44,2,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,47))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,47),G0H8(27),ngZu,m3h8x8(:,27),heltab2x64(:,:,447))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(448),h0tab(:,448),[44,2,1,16],[nMW,0,nMW,0],4,1,wf8(:,47))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,47),G0H8(28),m3h8x8(:,28),heltab2x64(:,:,448))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(449),h0tab(:,449),[44,1,2,16],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,46),G0H8(29),m3h8x8(:,29),heltab2x64(:,:,449))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(450),h0tab(:,450),[44,1,2,16],[0,0,nMZ,0],4,1,wf8(:,46))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,46),G0H8(30),m3h8x8(:,30),heltab2x64(:,:,450))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(451),h0tab(:,451),[44,1,2,16],[nMZ,0,0,0],4,1,wf8(:,46))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,46),G0H8(31),ngZu,m3h8x8(:,31),heltab2x64(:,:,451))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(452),h0tab(:,452),[44,1,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,46))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,46),G0H8(32),ngZu,m3h8x8(:,32),heltab2x64(:,:,452))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(453),h0tab(:,453),[44,1,2,16],[0,0,0,0],4,1,wf8(:,47))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,47),G0H8(33),m3h8x8(:,33),heltab2x64(:,:,453))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(454),h0tab(:,454),[44,1,2,16],[0,0,nMZ,0],4,1,wf8(:,47))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,47),G0H8(34),m3h8x8(:,34),heltab2x64(:,:,454))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(455),h0tab(:,455),[44,1,2,16],[nMZ,0,0,0],4,1,wf8(:,47))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,47),G0H8(35),ngZu,m3h8x8(:,35),heltab2x64(:,:,455))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(456),h0tab(:,456),[44,1,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,47))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,47),G0H8(36),ngZu,m3h8x8(:,36),heltab2x64(:,:,456))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(457),h0tab(:,457),[49,2,4,8],[0,0,0,0],4,1,wf8(:,33))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(37),m3h8x8(:,37),heltab2x64(:,:,457))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(65),n2h8(21))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(458),h0tab(:,458),[49,2,4,8],[0,0,0,nMZ],4,1,wf8(:,33))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(37),ngZl,m3h8x8(:,38),heltab2x64(:,:,458))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(66),n2h8(22))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(459),h0tab(:,459),[49,2,4,8],[0,nMZ,0,0],4,1,wf8(:,33))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(37),m3h8x8(:,39),heltab2x64(:,:,459))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(1),n2h8(23))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(460),h0tab(:,460),[49,2,4,8],[0,nMZ,0,nMZ],4,1,wf8(:,33))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(37),ngZl,m3h8x8(:,40),heltab2x64(:,:,460))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(2),n2h8(24))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(461),h0tab(:,461),[49,2,4,8],[0,nMW,0,nMW],4,1,wf8(:,33))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(37),m3h8x8(:,41),heltab2x64(:,:,461))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(3),n2h8(25))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(462),h0tab(:,462),[49,2,4,8],[0,0,0,0],4,1,wf8(:,36))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,36),G0H8(37),m3h8x8(:,42),heltab2x64(:,:,462))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(4),n2h8(26))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(463),h0tab(:,463),[49,2,4,8],[0,0,0,nMZ],4,1,wf8(:,36))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,36),G0H8(37),ngZl,m3h8x8(:,43),heltab2x64(:,:,463))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(5),n2h8(27))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(464),h0tab(:,464),[49,2,4,8],[0,nMZ,0,0],4,1,wf8(:,36))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,36),G0H8(37),m3h8x8(:,44),heltab2x64(:,:,464))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(6),n2h8(28))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(465),h0tab(:,465),[49,2,4,8],[0,nMZ,0,nMZ],4,1,wf8(:,36))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,36),G0H8(37),ngZl,m3h8x8(:,45),heltab2x64(:,:,465))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(7),n2h8(29))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(466),h0tab(:,466),[49,2,4,8],[0,nMW,0,nMW],4,1,wf8(:,36))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,36),G0H8(37),m3h8x8(:,46),heltab2x64(:,:,466))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(8),n2h8(30))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(467),h0tab(:,467),[49,2,8,4],[0,0,0,0],4,1,wf8(:,33))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(37),m3h8x8(:,47),heltab2x64(:,:,467))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(9),n2h8(31))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(468),h0tab(:,468),[49,2,8,4],[0,0,0,nMZ],4,1,wf8(:,33))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(37),ngZl,m3h8x8(:,48),heltab2x64(:,:,468))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(10),n2h8(32))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(469),h0tab(:,469),[49,2,8,4],[0,nMZ,0,0],4,1,wf8(:,33))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(37),m3h8x8(:,49),heltab2x64(:,:,469))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(13),n2h8(33))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(470),h0tab(:,470),[49,2,8,4],[0,nMZ,0,nMZ],4,1,wf8(:,33))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(37),ngZl,m3h8x8(:,50),heltab2x64(:,:,470))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(14),n2h8(34))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(471),h0tab(:,471),[49,2,8,4],[0,0,0,0],4,1,wf8(:,36))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,36),G0H8(37),m3h8x8(:,51),heltab2x64(:,:,471))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(15),n2h8(35))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(472),h0tab(:,472),[49,2,8,4],[0,0,0,nMZ],4,1,wf8(:,36))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,36),G0H8(37),ngZl,m3h8x8(:,52),heltab2x64(:,:,472))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(16),n2h8(36))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(473),h0tab(:,473),[49,2,8,4],[0,nMZ,0,0],4,1,wf8(:,36))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,36),G0H8(37),m3h8x8(:,53),heltab2x64(:,:,473))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(17),n2h8(37))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(474),h0tab(:,474),[49,2,8,4],[0,nMZ,0,nMZ],4,1,wf8(:,36))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,36),G0H8(37),ngZl,m3h8x8(:,54),heltab2x64(:,:,474))
  call Hloop_Q_A(ntryL,G0H8(37),49,0,G1H8(18),n2h8(38))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(475),h0tab(:,475),[50,1,4,8],[0,0,0,0],4,1,wf8(:,90))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,90),G0H8(37),m3h8x8(:,55),heltab2x64(:,:,475))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(19),n2h8(39))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(476),h0tab(:,476),[50,1,4,8],[0,0,0,nMZ],4,1,wf8(:,90))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,90),G0H8(37),ngZl,m3h8x8(:,56),heltab2x64(:,:,476))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(20),n2h8(40))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(477),h0tab(:,477),[50,1,4,8],[0,nMZ,0,0],4,1,wf8(:,90))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,90),G0H8(37),m3h8x8(:,57),heltab2x64(:,:,477))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(32),n2h8(41))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(478),h0tab(:,478),[50,1,4,8],[0,nMZ,0,nMZ],4,1,wf8(:,90))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,90),G0H8(37),ngZl,m3h8x8(:,58),heltab2x64(:,:,478))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(33),n2h8(42))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(479),h0tab(:,479),[50,1,4,8],[0,0,0,0],4,1,wf8(:,91))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,91),G0H8(37),m3h8x8(:,59),heltab2x64(:,:,479))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(11),n2h8(43))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(480),h0tab(:,480),[50,1,4,8],[0,0,0,nMZ],4,1,wf8(:,91))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,91),G0H8(37),ngZl,m3h8x8(:,60),heltab2x64(:,:,480))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(21),n2h8(44))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(481),h0tab(:,481),[50,1,4,8],[0,nMZ,0,0],4,1,wf8(:,91))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,91),G0H8(37),m3h8x8(:,61),heltab2x64(:,:,481))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(12),n2h8(45))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(482),h0tab(:,482),[50,1,4,8],[0,nMZ,0,nMZ],4,1,wf8(:,91))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,91),G0H8(37),ngZl,m3h8x8(:,62),heltab2x64(:,:,482))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(22),n2h8(46))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(483),h0tab(:,483),[50,1,8,4],[0,0,0,0],4,1,wf8(:,90))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,90),G0H8(37),m3h8x8(:,63),heltab2x64(:,:,483))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(23),n2h8(47))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(484),h0tab(:,484),[50,1,8,4],[0,0,0,nMZ],4,1,wf8(:,90))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,90),G0H8(37),ngZl,m3h8x8(:,64),heltab2x64(:,:,484))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(24),n2h8(48))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(485),h0tab(:,485),[50,1,8,4],[0,nMZ,0,0],4,1,wf8(:,90))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,90),G0H8(37),m3h8x8(:,65),heltab2x64(:,:,485))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(25),n2h8(49))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(486),h0tab(:,486),[50,1,8,4],[0,nMZ,0,nMZ],4,1,wf8(:,90))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,90),G0H8(37),ngZl,m3h8x8(:,66),heltab2x64(:,:,486))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(26),n2h8(50))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(487),h0tab(:,487),[50,1,8,4],[0,nMW,0,nMW],4,1,wf8(:,90))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,90),G0H8(37),m3h8x8(:,67),heltab2x64(:,:,487))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(27),n2h8(51))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(488),h0tab(:,488),[50,1,8,4],[0,0,0,0],4,1,wf8(:,91))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,91),G0H8(37),m3h8x8(:,68),heltab2x64(:,:,488))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(28),n2h8(52))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(489),h0tab(:,489),[50,1,8,4],[0,0,0,nMZ],4,1,wf8(:,91))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,91),G0H8(37),ngZl,m3h8x8(:,69),heltab2x64(:,:,489))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(29),n2h8(53))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(490),h0tab(:,490),[50,1,8,4],[0,nMZ,0,0],4,1,wf8(:,91))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,91),G0H8(37),m3h8x8(:,70),heltab2x64(:,:,490))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(30),n2h8(54))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(491),h0tab(:,491),[50,1,8,4],[0,nMZ,0,nMZ],4,1,wf8(:,91))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,91),G0H8(37),ngZl,m3h8x8(:,71),heltab2x64(:,:,491))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(31),n2h8(55))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(492),h0tab(:,492),[50,1,8,4],[0,nMW,0,nMW],4,1,wf8(:,91))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,91),G0H8(37),m3h8x8(:,72),heltab2x64(:,:,492))
  call Hloop_A_Q(ntryL,G0H8(37),50,0,G1H8(34),n2h8(56))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(493),h0tab(:,493),[52,2,1,8],[0,0,0,0],4,1,wf8(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,21),G0H8(37),m3h8x8(:,73),heltab2x64(:,:,493))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(494),h0tab(:,494),[52,2,1,8],[nMZ,0,0,0],4,1,wf8(:,21))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,21),G0H8(38),ngZl,m3h8x8(:,74),heltab2x64(:,:,494))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(495),h0tab(:,495),[52,2,1,8],[0,0,nMZ,0],4,1,wf8(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,21),G0H8(39),m3h8x8(:,75),heltab2x64(:,:,495))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(496),h0tab(:,496),[52,2,1,8],[nMZ,0,nMZ,0],4,1,wf8(:,21))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,21),G0H8(40),ngZl,m3h8x8(:,76),heltab2x64(:,:,496))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(497),h0tab(:,497),[52,2,1,8],[nMW,0,nMW,0],4,1,wf8(:,21))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,21),G0H8(41),m3h8x8(:,77),heltab2x64(:,:,497))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(498),h0tab(:,498),[52,2,1,8],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,23),G0H8(42),m3h8x8(:,78),heltab2x64(:,:,498))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(499),h0tab(:,499),[52,2,1,8],[nMZ,0,0,0],4,1,wf8(:,23))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,23),G0H8(43),ngZl,m3h8x8(:,79),heltab2x64(:,:,499))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(500),h0tab(:,500),[52,2,1,8],[0,0,nMZ,0],4,1,wf8(:,23))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,23),G0H8(44),m3h8x8(:,80),heltab2x64(:,:,500))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(501),h0tab(:,501),[52,2,1,8],[nMZ,0,nMZ,0],4,1,wf8(:,23))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,23),G0H8(45),ngZl,m3h8x8(:,81),heltab2x64(:,:,501))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(502),h0tab(:,502),[52,2,1,8],[nMW,0,nMW,0],4,1,wf8(:,23))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,23),G0H8(46),m3h8x8(:,82),heltab2x64(:,:,502))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(503),h0tab(:,503),[52,1,2,8],[0,0,0,0],4,1,wf8(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,21),G0H8(47),m3h8x8(:,83),heltab2x64(:,:,503))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(504),h0tab(:,504),[52,1,2,8],[0,0,nMZ,0],4,1,wf8(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,21),G0H8(48),m3h8x8(:,84),heltab2x64(:,:,504))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(505),h0tab(:,505),[52,1,2,8],[nMZ,0,0,0],4,1,wf8(:,21))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,21),G0H8(49),ngZl,m3h8x8(:,85),heltab2x64(:,:,505))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(506),h0tab(:,506),[52,1,2,8],[nMZ,0,nMZ,0],4,1,wf8(:,21))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,21),G0H8(50),ngZl,m3h8x8(:,86),heltab2x64(:,:,506))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(507),h0tab(:,507),[52,1,2,8],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,23),G0H8(51),m3h8x8(:,87),heltab2x64(:,:,507))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(508),h0tab(:,508),[52,1,2,8],[0,0,nMZ,0],4,1,wf8(:,23))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,23),G0H8(52),m3h8x8(:,88),heltab2x64(:,:,508))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(509),h0tab(:,509),[52,1,2,8],[nMZ,0,0,0],4,1,wf8(:,23))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,23),G0H8(53),ngZl,m3h8x8(:,89),heltab2x64(:,:,509))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(510),h0tab(:,510),[52,1,2,8],[nMZ,0,nMZ,0],4,1,wf8(:,23))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,23),G0H8(54),ngZl,m3h8x8(:,90),heltab2x64(:,:,510))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(511),h0tab(:,511),[56,2,1,4],[0,0,0,0],4,1,wf8(:,64))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,64),G0H8(55),m3h8x8(:,91),heltab2x64(:,:,511))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(512),h0tab(:,512),[56,2,1,4],[nMZ,0,0,0],4,1,wf8(:,64))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,64),G0H8(56),ngZl,m3h8x8(:,92),heltab2x64(:,:,512))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(513),h0tab(:,513),[56,2,1,4],[0,0,nMZ,0],4,1,wf8(:,64))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,64),G0H8(57),m3h8x8(:,93),heltab2x64(:,:,513))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(514),h0tab(:,514),[56,2,1,4],[nMZ,0,nMZ,0],4,1,wf8(:,64))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,64),G0H8(58),ngZl,m3h8x8(:,94),heltab2x64(:,:,514))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(515),h0tab(:,515),[56,2,1,4],[0,0,0,0],4,1,wf8(:,65))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,65),G0H8(59),m3h8x8(:,95),heltab2x64(:,:,515))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(516),h0tab(:,516),[56,2,1,4],[nMZ,0,0,0],4,1,wf8(:,65))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,65),G0H8(60),ngZl,m3h8x8(:,96),heltab2x64(:,:,516))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(517),h0tab(:,517),[56,2,1,4],[0,0,nMZ,0],4,1,wf8(:,65))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,65),G0H8(61),m3h8x8(:,97),heltab2x64(:,:,517))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(518),h0tab(:,518),[56,2,1,4],[nMZ,0,nMZ,0],4,1,wf8(:,65))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,65),G0H8(62),ngZl,m3h8x8(:,98),heltab2x64(:,:,518))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(519),h0tab(:,519),[56,1,2,4],[0,0,0,0],4,1,wf8(:,64))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,64),G0H8(63),m3h8x8(:,99),heltab2x64(:,:,519))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(520),h0tab(:,520),[56,1,2,4],[0,0,nMZ,0],4,1,wf8(:,64))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,64),G0H8(64),m3h8x8(:,100),heltab2x64(:,:,520))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(521),h0tab(:,521),[56,1,2,4],[nMZ,0,0,0],4,1,wf8(:,64))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,64),G0H8(65),ngZl,m3h8x8(:,101),heltab2x64(:,:,521))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(522),h0tab(:,522),[56,1,2,4],[nMZ,0,nMZ,0],4,1,wf8(:,64))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,64),G0H8(66),ngZl,m3h8x8(:,102),heltab2x64(:,:,522))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(523),h0tab(:,523),[56,1,2,4],[nMW,0,nMW,0],4,1,wf8(:,64))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,64),G0H8(67),m3h8x8(:,103),heltab2x64(:,:,523))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(524),h0tab(:,524),[56,1,2,4],[0,0,0,0],4,1,wf8(:,65))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,65),G0H8(68),m3h8x8(:,104),heltab2x64(:,:,524))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(525),h0tab(:,525),[56,1,2,4],[0,0,nMZ,0],4,1,wf8(:,65))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,65),G0H8(69),m3h8x8(:,105),heltab2x64(:,:,525))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(526),h0tab(:,526),[56,1,2,4],[nMZ,0,0,0],4,1,wf8(:,65))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,65),G0H8(70),ngZl,m3h8x8(:,106),heltab2x64(:,:,526))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(527),h0tab(:,527),[56,1,2,4],[nMZ,0,nMZ,0],4,1,wf8(:,65))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,65),G0H8(71),ngZl,m3h8x8(:,107),heltab2x64(:,:,527))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(528),h0tab(:,528),[56,1,2,4],[nMW,0,nMW,0],4,1,wf8(:,65))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,65),G0H8(72),m3h8x8(:,108),heltab2x64(:,:,528))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(2),[G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(5),[G0H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(21),[G1H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(39),[G1H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(7),[G0H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(10),[G0H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(44),[G1H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(46),[G1H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(6),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(7),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(8),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(9),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(10),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(16),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(17),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(51),[G1H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G1H16(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(55),[G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(56),[G1H16(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(12),[G0H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(15),[G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(59),[G1H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(61),[G1H16(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(64),[G1H16(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(65),[G1H16(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(17),[G0H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(20),[G0H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(24),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(25),[G0H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(26),[G0H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(27),[G0H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(28),[G0H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(33),[G0H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(34),[G0H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(35),[G0H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(36),[G0H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(42),[G0H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(43),[G0H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(44),[G0H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(45),[G0H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(46),[G0H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(51),[G0H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(52),[G0H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(53),[G0H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(54),[G0H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(59),[G0H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(60),[G0H8(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(61),[G0H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(62),[G0H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(68),[G0H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(69),[G0H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(70),[G0H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(71),[G0H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(72),[G0H8(67)])
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,2),G1H8(35),m3h4x8(:,23),heltab2x32(:,:,145))
  call Hloop_A_Q(ntryL,G1H8(35),44,0,G2H8(1),n2h8(57))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,2),G1H8(36),m3h4x8(:,24),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G1H8(36),44,0,G2H8(2),n2h8(58))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,2),G1H8(37),m3h4x8(:,25),heltab2x32(:,:,147))
  call Hloop_A_Q(ntryL,G1H8(37),44,0,G2H8(3),n2h8(59))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,3),G1H8(38),ngZu,m3h4x8(:,26),heltab2x32(:,:,148))
  call Hloop_A_Q(ntryL,G1H8(38),44,0,G2H8(4),n2h8(60))
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,3),G1H8(39),ngZu,m3h4x8(:,27),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G1H8(39),44,0,G2H8(5),n2h8(61))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,3),G1H8(40),ngZd,m3h4x8(:,28),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G1H8(40),44,0,G2H8(11),n2h8(62))
  call Hloop_AV_Q(ntryL,G1H32(7),wf4(:,2),G1H8(41),m3h4x8(:,29),heltab2x32(:,:,151))
  call Hloop_A_Q(ntryL,G1H8(41),44,0,G2H8(12),n2h8(63))
  call Hloop_AV_Q(ntryL,G1H32(8),wf4(:,2),G1H8(42),m3h4x8(:,30),heltab2x32(:,:,152))
  call Hloop_A_Q(ntryL,G1H8(42),44,0,G2H8(13),n2h8(64))
  call Hloop_AV_Q(ntryL,G1H32(9),wf4(:,2),G1H8(43),m3h4x8(:,31),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G1H8(43),44,0,G2H8(14),n2h8(65))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,3),G1H8(44),ngZu,m3h4x8(:,32),heltab2x32(:,:,154))
  call Hloop_A_Q(ntryL,G1H8(44),44,0,G2H8(6),n2h8(66))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf4(:,3),G1H8(45),ngZu,m3h4x8(:,33),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G1H8(45),44,0,G2H8(7),n2h8(67))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,3),G1H8(46),ngZd,m3h4x8(:,34),heltab2x32(:,:,156))
  call Hloop_A_Q(ntryL,G1H8(46),44,0,G2H8(8),n2h8(68))
  call Hloop_VV_S(ntryL,G0H32(25),wf4(:,2),G0H8(1),m3h4x8(:,35),heltab2x32(:,:,157))
  call Hloop_VV_S(ntryL,G0H32(26),wf4(:,3),G0H8(2),m3h4x8(:,36),heltab2x32(:,:,158))
  call Hloop_VV_S(ntryL,G0H32(27),wf4(:,2),G0H8(3),m3h4x8(:,37),heltab2x32(:,:,159))
  call Hloop_VV_S(ntryL,G0H32(28),wf4(:,3),G0H8(4),m3h4x8(:,38),heltab2x32(:,:,160))
  call Hloop_VV_S(ntryL,G0H32(29),wf4(:,3),G0H8(5),m3h4x8(:,39),heltab2x32(:,:,161))
  call Hloop_UV_W(ntryL,G0H32(30),32,wf4(:,2),12,G1H8(47),m3h4x8(:,40),heltab2x32(:,:,162))
  call Hloop_UV_W(ntryL,G0H32(31),32,wf4(:,3),12,G1H8(48),m3h4x8(:,41),heltab2x32(:,:,163))
  call Hloop_UV_W(ntryL,G0H32(32),32,wf4(:,2),12,G1H8(49),m3h4x8(:,42),heltab2x32(:,:,164))
  call Hloop_UV_W(ntryL,G0H32(33),32,wf4(:,3),12,G1H8(50),m3h4x8(:,43),heltab2x32(:,:,165))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,1),G1H8(51),m3h4x8(:,44),heltab2x32(:,:,166))
  call Hloop_A_Q(ntryL,G1H8(51),35,0,G2H8(9),n2h8(69))
  call Hloop_AV_Q(ntryL,G1H32(14),wf4(:,1),G1H8(52),m3h4x8(:,45),heltab2x32(:,:,167))
  call Hloop_A_Q(ntryL,G1H8(52),35,0,G2H8(10),n2h8(70))
  call Hloop_AV_Q(ntryL,G1H32(15),wf4(:,1),G1H8(53),m3h4x8(:,46),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G1H8(53),35,0,G2H8(15),n2h8(71))
  call Hloop_AV_Q(ntryL,G1H32(16),wf4(:,1),G1H8(54),m3h4x8(:,47),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G1H8(54),35,0,G2H8(16),n2h8(72))
  call Hloop_AV_Q(ntryL,G1H32(17),wf4(:,1),G1H8(55),m3h4x8(:,48),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G1H8(55),35,0,G2H8(17),n2h8(73))
  call Hloop_AV_Q(ntryL,G1H32(18),wf4(:,1),G1H8(56),m3h4x8(:,49),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G1H8(56),35,0,G2H8(18),n2h8(74))
  call Hloop_AZ_Q(ntryL,G1H32(19),wf4(:,4),G1H8(57),ngZu,m3h4x8(:,50),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G1H8(57),35,0,G2H8(19),n2h8(75))
  call Hloop_AZ_Q(ntryL,G1H32(20),wf4(:,4),G1H8(58),ngZu,m3h4x8(:,51),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G1H8(58),35,0,G2H8(20),n2h8(76))
  call Hloop_AZ_Q(ntryL,G1H32(21),wf4(:,4),G1H8(59),ngZd,m3h4x8(:,52),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G1H8(59),35,0,G2H8(21),n2h8(77))
  call Hloop_AZ_Q(ntryL,G1H32(22),wf4(:,4),G1H8(60),ngZu,m3h4x8(:,53),heltab2x32(:,:,175))
  call Hloop_A_Q(ntryL,G1H8(60),35,0,G2H8(22),n2h8(78))
  call Hloop_AZ_Q(ntryL,G1H32(23),wf4(:,4),G1H8(61),ngZu,m3h4x8(:,54),heltab2x32(:,:,176))
  call Hloop_A_Q(ntryL,G1H8(61),35,0,G2H8(23),n2h8(79))
  call Hloop_AZ_Q(ntryL,G1H32(24),wf4(:,4),G1H8(62),ngZd,m3h4x8(:,55),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G1H8(62),35,0,G2H8(24),n2h8(80))
  call Hloop_VV_S(ntryL,G0H32(46),wf4(:,1),G0H8(11),m3h4x8(:,56),heltab2x32(:,:,178))
  call Hloop_VV_S(ntryL,G0H32(47),wf4(:,1),G0H8(12),m3h4x8(:,57),heltab2x32(:,:,179))
  call Hloop_VV_S(ntryL,G0H32(48),wf4(:,4),G0H8(13),m3h4x8(:,58),heltab2x32(:,:,180))
  call Hloop_VV_S(ntryL,G0H32(49),wf4(:,4),G0H8(14),m3h4x8(:,59),heltab2x32(:,:,181))
  call Hloop_VV_S(ntryL,G0H32(50),wf4(:,4),G0H8(19),m3h4x8(:,60),heltab2x32(:,:,182))
  call Hloop_UV_W(ntryL,G0H32(51),32,wf4(:,1),3,G1H8(63),m3h4x8(:,61),heltab2x32(:,:,183))
  call Hloop_UV_W(ntryL,G0H32(52),32,wf4(:,1),3,G1H8(64),m3h4x8(:,62),heltab2x32(:,:,184))
  call Hloop_UV_W(ntryL,G0H32(53),32,wf4(:,4),3,G1H8(65),m3h4x8(:,63),heltab2x32(:,:,185))
  call Hloop_UV_W(ntryL,G0H32(54),32,wf4(:,4),3,G1H8(66),m3h4x8(:,64),heltab2x32(:,:,186))
  call Hloop_AV_Q(ntryL,G1H32(25),wf4(:,1),G1H8(1),m3h4x8(:,65),heltab2x32(:,:,187))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(25),n2h8(81))
  call Hloop_AV_Q(ntryL,G1H32(26),wf4(:,1),G1H8(2),m3h4x8(:,66),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G1H8(2),35,0,G2H8(26),n2h8(82))
  call Hloop_AZ_Q(ntryL,G1H32(27),wf4(:,4),G1H8(3),ngZd,m3h4x8(:,67),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G1H8(3),35,0,G2H8(27),n2h8(83))
  call Hloop_AZ_Q(ntryL,G1H32(28),wf4(:,4),G1H8(9),ngZd,m3h4x8(:,68),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G1H8(9),35,0,G2H8(28),n2h8(84))
  call Hloop_UV_W(ntryL,G0H32(59),32,wf4(:,1),3,G1H8(10),m3h4x8(:,69),heltab2x32(:,:,191))
  call Hloop_UV_W(ntryL,G0H32(60),32,wf4(:,1),3,G1H8(13),m3h4x8(:,70),heltab2x32(:,:,192))
  call Hloop_UV_W(ntryL,G0H32(61),32,wf4(:,4),3,G1H8(14),m3h4x8(:,71),heltab2x32(:,:,193))
  call Hloop_UV_W(ntryL,G0H32(62),32,wf4(:,4),3,G1H8(19),m3h4x8(:,72),heltab2x32(:,:,194))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,1),G1H4(1),m3h4x4(:,35),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(2),n2h4(150))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,1),G1H4(2),m3h4x4(:,36),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(2),51,0,G2H4(3),n2h4(151))
  call Hloop_AZ_Q(ntryL,G1H16(15),wf4(:,4),G1H4(8),ngZl,m3h4x4(:,37),heltab2x16(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(8),51,0,G2H4(4),n2h4(152))
  call Hloop_AZ_Q(ntryL,G1H16(16),wf4(:,4),G1H4(11),ngZl,m3h4x4(:,38),heltab2x16(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(11),51,0,G2H4(5),n2h4(153))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,4),G1H4(12),ngZn,m3h4x4(:,39),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(12),51,0,G2H4(6),n2h4(154))
  call Hloop_SV_V(ntryL,G0H16(2),wf4(:,1),G0H4(1),m3h4x4(:,40),heltab2x16(:,:,148))
  call Hloop_SV_V(ntryL,G0H16(5),wf4(:,4),G0H4(2),m3h4x4(:,41),heltab2x16(:,:,149))
  call Hloop_SV_V(ntryL,G0H16(4),wf4(:,4),G0H4(3),m3h4x4(:,42),heltab2x16(:,:,150))
  call Hloop_UW_V(ntryL,G1H16(21),48,wf4(:,1),3,G2H4(7),m3h4x4(:,43),heltab2x16(:,:,151))
  call Hloop_UW_V(ntryL,G1H16(27),48,wf4(:,4),3,G2H4(8),m3h4x4(:,44),heltab2x16(:,:,152))
  call Hloop_QV_A(ntryL,G1H16(34),wf4(:,1),G1H4(18),m3h4x4(:,45),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(18),51,0,G2H4(9),n2h4(155))
  call Hloop_QV_A(ntryL,G1H16(35),wf4(:,1),G1H4(19),m3h4x4(:,46),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(19),51,0,G2H4(10),n2h4(156))
  call Hloop_QZ_A(ntryL,G1H16(38),wf4(:,4),G1H4(20),ngZl,m3h4x4(:,47),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(20),51,0,G2H4(15),n2h4(157))
  call Hloop_QZ_A(ntryL,G1H16(39),wf4(:,4),G1H4(26),ngZl,m3h4x4(:,48),heltab2x16(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(26),51,0,G2H4(16),n2h4(158))
  call Hloop_QZ_A(ntryL,G1H16(40),wf4(:,4),G1H4(29),ngZn,m3h4x4(:,49),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(29),51,0,G2H4(17),n2h4(159))
  call Hloop_SV_V(ntryL,G0H16(7),wf4(:,1),G0H4(4),m3h4x4(:,50),heltab2x16(:,:,158))
  call Hloop_SV_V(ntryL,G0H16(10),wf4(:,4),G0H4(5),m3h4x4(:,51),heltab2x16(:,:,159))
  call Hloop_SV_V(ntryL,G0H16(9),wf4(:,4),G0H4(6),m3h4x4(:,52),heltab2x16(:,:,160))
  call Hloop_UV_W(ntryL,G1H16(42),48,wf4(:,1),3,G2H4(18),m3h4x4(:,53),heltab2x16(:,:,161))
  call Hloop_UV_W(ntryL,G1H16(44),48,wf4(:,4),3,G2H4(19),m3h4x4(:,54),heltab2x16(:,:,162))
  call Hloop_WQ_A(ntryL,G1H16(46),ex3(:),G1H8(20),m3h2x8(:,109),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H8(20),52,0,G2H8(29),n2h8(85))
  call Hloop_AQ_W(ntryL,G1H16(47),ex3(:),G1H8(32),m3h2x8(:,110),heltab2x16(:,:,164))
  call Hloop_AQ_W(ntryL,G1H16(48),ex3(:),G1H8(33),m3h2x8(:,111),heltab2x16(:,:,165))
  call Hloop_VQ_A(ntryL,G0H32(63),wf8(:,15),G0H4(7),m3h8x4(:,1),heltab2x32(:,:,195))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(30),n2h4(160))
  call Hloop_ZQ_A(ntryL,G0H32(64),wf8(:,15),G0H4(7),ngZl,m3h8x4(:,2),heltab2x32(:,:,196))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(36),n2h4(161))
  call Hloop_VQ_A(ntryL,G0H32(65),wf8(:,15),G0H4(7),m3h8x4(:,3),heltab2x32(:,:,197))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(37),n2h4(162))
  call Hloop_ZQ_A(ntryL,G0H32(66),wf8(:,15),G0H4(7),ngZl,m3h8x4(:,4),heltab2x32(:,:,198))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(38),n2h4(163))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,18),G0H4(7),m3h8x4(:,5),heltab2x32(:,:,199))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(44),n2h4(164))
  call Hloop_ZQ_A(ntryL,G0H32(2),wf8(:,18),G0H4(7),ngZl,m3h8x4(:,6),heltab2x32(:,:,200))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(47),n2h4(165))
  call Hloop_VQ_A(ntryL,G0H32(3),wf8(:,18),G0H4(7),m3h8x4(:,7),heltab2x32(:,:,201))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(48),n2h4(166))
  call Hloop_ZQ_A(ntryL,G0H32(4),wf8(:,18),G0H4(7),ngZl,m3h8x4(:,8),heltab2x32(:,:,202))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(54),n2h4(167))
  call Hloop_VA_Q(ntryL,G0H32(5),ex4(:),G0H16(21),m3h2x16(:,123),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G0H16(21),40,0,G1H16(24),n2h16(197))
  call Hloop_VA_Q(ntryL,G0H32(6),ex4(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(25),n2h16(198))
  call Hloop_ZA_Q(ntryL,G0H32(7),ex4(:),G0H16(3),ngZl,m3h2x16(:,125),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G0H16(3),40,0,G1H16(30),n2h16(199))
  call Hloop_ZA_Q(ntryL,G0H32(8),ex4(:),G0H16(6),ngZl,m3h2x16(:,126),heltab2x32(:,:,206))
  call Hloop_A_Q(ntryL,G0H16(6),40,0,G1H16(31),n2h16(200))
  call Hloop_WA_Q(ntryL,G0H32(9),ex4(:),G0H16(8),m3h2x16(:,127),heltab2x32(:,:,207))
  call Hloop_A_Q(ntryL,G0H16(8),40,0,G1H16(32),n2h16(201))
  call Hloop_VA_Q(ntryL,G0H32(10),ex4(:),G0H16(11),m3h2x16(:,128),heltab2x32(:,:,208))
  call Hloop_A_Q(ntryL,G0H16(11),40,0,G1H16(33),n2h16(202))
  call Hloop_VA_Q(ntryL,G0H32(13),ex4(:),G0H16(13),m3h2x16(:,129),heltab2x32(:,:,209))
  call Hloop_A_Q(ntryL,G0H16(13),40,0,G1H16(67),n2h16(203))
  call Hloop_ZA_Q(ntryL,G0H32(14),ex4(:),G0H16(16),ngZl,m3h2x16(:,130),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G0H16(16),40,0,G1H16(68),n2h16(204))
  call Hloop_ZA_Q(ntryL,G0H32(15),ex4(:),G0H16(18),ngZl,m3h2x16(:,131),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G0H16(18),40,0,G1H16(69),n2h16(205))
  call Hloop_WA_Q(ntryL,G0H32(16),ex4(:),G0H16(2),m3h2x16(:,132),heltab2x32(:,:,212))
  call Hloop_A_Q(ntryL,G0H16(2),40,0,G1H16(70),n2h16(206))
  call Hloop_VA_Q(ntryL,G0H32(17),wf8(:,60),G0H4(7),m3h8x4(:,9),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(55),n2h4(168))
  call Hloop_ZA_Q(ntryL,G0H32(18),wf8(:,60),G0H4(7),ngZl,m3h8x4(:,10),heltab2x32(:,:,214))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(56),n2h4(169))
  call Hloop_VA_Q(ntryL,G0H32(19),wf8(:,60),G0H4(7),m3h8x4(:,11),heltab2x32(:,:,215))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(62),n2h4(170))
  call Hloop_ZA_Q(ntryL,G0H32(20),wf8(:,60),G0H4(7),ngZl,m3h8x4(:,12),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(65),n2h4(171))
  call Hloop_WA_Q(ntryL,G0H32(11),wf8(:,60),G0H4(7),m3h8x4(:,13),heltab2x32(:,:,217))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(66),n2h4(172))
  call Hloop_VA_Q(ntryL,G0H32(12),wf8(:,62),G0H4(7),m3h8x4(:,14),heltab2x32(:,:,218))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(70),n2h4(173))
  call Hloop_ZA_Q(ntryL,G0H32(21),wf8(:,62),G0H4(7),ngZl,m3h8x4(:,15),heltab2x32(:,:,219))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(71),n2h4(174))
  call Hloop_VA_Q(ntryL,G0H32(22),wf8(:,62),G0H4(7),m3h8x4(:,16),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(72),n2h4(175))
  call Hloop_ZA_Q(ntryL,G0H32(23),wf8(:,62),G0H4(7),ngZl,m3h8x4(:,17),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(76),n2h4(176))
  call Hloop_WA_Q(ntryL,G0H32(24),wf8(:,62),G0H4(7),m3h8x4(:,18),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(77),n2h4(177))
  call Hloop_VQ_A(ntryL,G0H32(34),ex3(:),G0H16(5),m3h2x16(:,133),heltab2x32(:,:,223))
  call Hloop_Q_A(ntryL,G0H16(5),36,0,G1H16(71),n2h16(207))
  call Hloop_VQ_A(ntryL,G0H32(35),ex3(:),G0H16(4),m3h2x16(:,134),heltab2x32(:,:,224))
  call Hloop_Q_A(ntryL,G0H16(4),36,0,G1H16(72),n2h16(208))
  call Hloop_ZQ_A(ntryL,G0H32(36),ex3(:),G0H16(7),ngZl,m3h2x16(:,135),heltab2x32(:,:,225))
  call Hloop_Q_A(ntryL,G0H16(7),36,0,G1H16(73),n2h16(209))
  call Hloop_ZQ_A(ntryL,G0H32(37),ex3(:),G0H16(10),ngZl,m3h2x16(:,136),heltab2x32(:,:,226))
  call Hloop_Q_A(ntryL,G0H16(10),36,0,G1H16(74),n2h16(210))
  call Hloop_VQ_A(ntryL,G0H32(38),ex3(:),G0H16(9),m3h2x16(:,137),heltab2x32(:,:,227))
  call Hloop_Q_A(ntryL,G0H16(9),36,0,G1H16(75),n2h16(211))
  call Hloop_VQ_A(ntryL,G0H32(39),ex3(:),G0H16(21),m3h2x16(:,138),heltab2x32(:,:,228))
  call Hloop_Q_A(ntryL,G0H16(21),36,0,G1H16(76),n2h16(212))
  call Hloop_ZQ_A(ntryL,G0H32(40),ex3(:),G0H16(1),ngZl,m3h2x16(:,139),heltab2x32(:,:,229))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(5),n2h16(213))
  call Hloop_ZQ_A(ntryL,G0H32(41),ex3(:),G0H16(3),ngZl,m3h2x16(:,140),heltab2x32(:,:,230))
  call Hloop_Q_A(ntryL,G0H16(3),36,0,G1H16(6),n2h16(214))
  call Hloop_VQ_A(ntryL,G0H32(42),ex3(:),G0H16(6),m3h2x16(:,141),heltab2x32(:,:,231))
  call Hloop_Q_A(ntryL,G0H16(6),36,0,G1H16(13),n2h16(215))
  call Hloop_VQ_A(ntryL,G0H32(43),ex3(:),G0H16(8),m3h2x16(:,142),heltab2x32(:,:,232))
  call Hloop_Q_A(ntryL,G0H16(8),36,0,G1H16(14),n2h16(216))
  call Hloop_ZQ_A(ntryL,G0H32(44),ex3(:),G0H16(11),ngZl,m3h2x16(:,143),heltab2x32(:,:,233))
  call Hloop_Q_A(ntryL,G0H16(11),36,0,G1H16(19),n2h16(217))
  call Hloop_ZQ_A(ntryL,G0H32(45),ex3(:),G0H16(13),ngZl,m3h2x16(:,144),heltab2x32(:,:,234))
  call Hloop_Q_A(ntryL,G0H16(13),36,0,G1H16(26),n2h16(218))
  call Hloop_VQ_A(ntryL,G0H32(55),ex3(:),G0H16(16),m3h2x16(:,145),heltab2x32(:,:,235))
  call Hloop_Q_A(ntryL,G0H16(16),36,0,G1H16(28),n2h16(219))
  call Hloop_VQ_A(ntryL,G0H32(56),ex3(:),G0H16(18),m3h2x16(:,146),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G0H16(18),36,0,G1H16(29),n2h16(220))
  call Hloop_ZQ_A(ntryL,G0H32(57),ex3(:),G0H16(2),ngZl,m3h2x16(:,147),heltab2x32(:,:,237))
  call Hloop_Q_A(ntryL,G0H16(2),36,0,G1H16(36),n2h16(221))
  call Hloop_ZQ_A(ntryL,G0H32(58),ex3(:),G0H16(5),ngZl,m3h2x16(:,148),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G0H16(5),36,0,G1H16(37),n2h16(222))
  call Hloop_VA_Q(ntryL,G0H32(67),ex4(:),G0H16(4),m3h2x16(:,149),heltab2x32(:,:,239))
  call Hloop_A_Q(ntryL,G0H16(4),40,0,G1H16(41),n2h16(223))
  call Hloop_ZA_Q(ntryL,G0H32(68),ex4(:),G0H16(7),ngZl,m3h2x16(:,150),heltab2x32(:,:,240))
  call Hloop_A_Q(ntryL,G0H16(7),40,0,G1H16(43),n2h16(224))
  call Hloop_VA_Q(ntryL,G0H32(69),ex4(:),G0H16(10),m3h2x16(:,151),heltab2x32(:,:,241))
  call Hloop_A_Q(ntryL,G0H16(10),40,0,G1H16(45),n2h16(225))
  call Hloop_ZA_Q(ntryL,G0H32(70),ex4(:),G0H16(9),ngZl,m3h2x16(:,152),heltab2x32(:,:,242))
  call Hloop_A_Q(ntryL,G0H16(9),40,0,G1H16(49),n2h16(226))
  call Hloop_WA_Q(ntryL,G0H32(71),ex4(:),G0H16(21),m3h2x16(:,153),heltab2x32(:,:,243))
  call Hloop_A_Q(ntryL,G0H16(21),40,0,G1H16(50),n2h16(227))
  call Hloop_VA_Q(ntryL,G0H32(72),ex4(:),G0H16(1),m3h2x16(:,154),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(53),n2h16(228))
  call Hloop_ZA_Q(ntryL,G0H32(73),ex4(:),G0H16(3),ngZl,m3h2x16(:,155),heltab2x32(:,:,245))
  call Hloop_A_Q(ntryL,G0H16(3),40,0,G1H16(54),n2h16(229))
  call Hloop_VA_Q(ntryL,G0H32(74),ex4(:),G0H16(6),m3h2x16(:,156),heltab2x32(:,:,246))
  call Hloop_A_Q(ntryL,G0H16(6),40,0,G1H16(58),n2h16(230))
  call Hloop_ZA_Q(ntryL,G0H32(75),ex4(:),G0H16(8),ngZl,m3h2x16(:,157),heltab2x32(:,:,247))
  call Hloop_A_Q(ntryL,G0H16(8),40,0,G1H16(60),n2h16(231))
  call Hloop_WA_Q(ntryL,G0H32(76),ex4(:),G0H16(11),m3h2x16(:,158),heltab2x32(:,:,248))
  call Hloop_A_Q(ntryL,G0H16(11),40,0,G1H16(62),n2h16(232))
  call Hloop_VA_Q(ntryL,G0H8(6),ex4(:),G0H4(7),m3h2x4(:,116),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(78),n2h4(178))
  call Hloop_ZA_Q(ntryL,G0H8(7),ex4(:),G0H4(7),ngZl,m3h2x4(:,117),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(82),n2h4(179))
  call Hloop_VA_Q(ntryL,G0H8(8),ex4(:),G0H4(7),m3h2x4(:,118),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(83),n2h4(180))
  call Hloop_ZA_Q(ntryL,G0H8(9),ex4(:),G0H4(7),ngZl,m3h2x4(:,119),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(84),n2h4(181))
  call Hloop_WA_Q(ntryL,G0H8(10),ex4(:),G0H4(7),m3h2x4(:,120),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G0H4(7),43,0,G1H4(88),n2h4(182))
  call Hloop_VQ_A(ntryL,G0H8(15),ex3(:),G0H4(7),m3h2x4(:,121),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(89),n2h4(183))
  call Hloop_VQ_A(ntryL,G0H8(16),ex3(:),G0H4(7),m3h2x4(:,122),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(90),n2h4(184))
  call Hloop_ZQ_A(ntryL,G0H8(17),ex3(:),G0H4(7),ngZl,m3h2x4(:,123),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(94),n2h4(185))
  call Hloop_ZQ_A(ntryL,G0H8(18),ex3(:),G0H4(7),ngZl,m3h2x4(:,124),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G0H4(7),39,0,G1H4(95),n2h4(186))
  call Hloop_QA_V(ntryL,G1H16(51),ex2(:),G1H8(23),m3h2x8(:,112),heltab2x16(:,:,166))
  call Hloop_QA_Z(ntryL,G1H16(52),ex2(:),G1H8(24),ngZl,m3h2x8(:,113),heltab2x16(:,:,167))
  call Hloop_QA_V(ntryL,G1H16(55),ex2(:),G1H8(25),m3h2x8(:,114),heltab2x16(:,:,168))
  call Hloop_QA_Z(ntryL,G1H16(56),ex2(:),G1H8(26),ngZl,m3h2x8(:,115),heltab2x16(:,:,169))
  call Hloop_QA_W(ntryL,G1H16(57),ex2(:),G1H8(27),m3h2x8(:,116),heltab2x16(:,:,170))
  call Hloop_WA_Q(ntryL,G0H16(12),ex2(:),G0H8(20),m3h2x8(:,117),heltab2x16(:,:,171))
  call Hloop_A_Q(ntryL,G0H8(20),50,0,G1H8(35),n2h8(86))
  call Hloop_WA_Q(ntryL,G0H16(15),ex2(:),G0H8(21),m3h2x8(:,118),heltab2x16(:,:,172))
  call Hloop_A_Q(ntryL,G0H8(21),50,0,G1H8(36),n2h8(87))
  call Hloop_ZA_Q(ntryL,G0H16(14),ex2(:),G0H8(22),ngZl,m3h2x8(:,119),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G0H8(22),50,0,G1H8(37),n2h8(88))
  call Hloop_WA_Q(ntryL,G1H16(59),ex2(:),G1H8(38),m3h2x8(:,120),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H8(38),50,0,G2H8(30),n2h8(89))
  call Hloop_WA_Q(ntryL,G1H16(61),ex2(:),G1H8(39),m3h2x8(:,121),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G1H8(39),50,0,G2H8(31),n2h8(90))
  call Hloop_AQ_V(ntryL,G1H16(64),ex1(:),G1H8(40),m3h2x8(:,122),heltab2x16(:,:,176))
  call Hloop_AQ_Z(ntryL,G1H16(65),ex1(:),G1H8(41),ngZl,m3h2x8(:,123),heltab2x16(:,:,177))
  call Hloop_AQ_V(ntryL,G1H16(2),ex1(:),G1H8(42),m3h2x8(:,124),heltab2x16(:,:,178))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex1(:),G1H8(43),ngZl,m3h2x8(:,125),heltab2x16(:,:,179))
  call Hloop_AQ_W(ntryL,G1H16(4),ex1(:),G1H8(44),m3h2x8(:,126),heltab2x16(:,:,180))
  call Hloop_WQ_A(ntryL,G0H16(17),ex1(:),G0H8(23),m3h2x8(:,127),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G0H8(23),49,0,G1H8(45),n2h8(91))
  call Hloop_WQ_A(ntryL,G0H16(20),ex1(:),G0H8(29),m3h2x8(:,128),heltab2x16(:,:,182))
  call Hloop_Q_A(ntryL,G0H8(29),49,0,G1H8(46),n2h8(92))
  call Hloop_ZQ_A(ntryL,G0H16(19),ex1(:),G0H8(30),ngZl,m3h2x8(:,129),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G0H8(30),49,0,G1H8(51),n2h8(93))
  call Hloop_WQ_A(ntryL,G1H16(10),ex1(:),G1H8(52),m3h2x8(:,130),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H8(52),49,0,G2H8(32),n2h8(94))
  call Hloop_WQ_A(ntryL,G1H16(12),ex1(:),G1H8(53),m3h2x8(:,131),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G1H8(53),49,0,G2H8(33),n2h8(95))
  call Hloop_WQ_A(ntryL,G1H16(20),ex1(:),G1H8(54),m3h2x8(:,132),heltab2x16(:,:,186))
  call Hloop_Q_A(ntryL,G1H8(54),49,0,G2H8(34),n2h8(96))
  call Hloop_AQ_W(ntryL,G1H16(22),ex1(:),G1H8(55),m3h2x8(:,133),heltab2x16(:,:,187))
  call Hloop_AQ_W(ntryL,G1H16(23),ex1(:),G1H8(56),m3h2x8(:,134),heltab2x16(:,:,188))
  call Hloop_VQ_A(ntryL,G0H32(77),wf8(:,27),G0H4(7),m3h8x4(:,19),heltab2x32(:,:,249))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(96),n2h4(187))
  call Hloop_ZQ_A(ntryL,G0H32(78),wf8(:,27),G0H4(7),ngZl,m3h8x4(:,20),heltab2x32(:,:,250))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(100),n2h4(188))
  call Hloop_VQ_A(ntryL,G0H32(79),wf8(:,27),G0H4(7),m3h8x4(:,21),heltab2x32(:,:,251))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(101),n2h4(189))
  call Hloop_ZQ_A(ntryL,G0H32(80),wf8(:,27),G0H4(7),ngZl,m3h8x4(:,22),heltab2x32(:,:,252))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(102),n2h4(190))
  call Hloop_VQ_A(ntryL,G0H32(81),wf8(:,30),G0H4(7),m3h8x4(:,23),heltab2x32(:,:,253))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(106),n2h4(191))
  call Hloop_ZQ_A(ntryL,G0H32(82),wf8(:,30),G0H4(7),ngZl,m3h8x4(:,24),heltab2x32(:,:,254))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(107),n2h4(192))
  call Hloop_VQ_A(ntryL,G0H32(83),wf8(:,30),G0H4(7),m3h8x4(:,25),heltab2x32(:,:,255))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(108),n2h4(193))
  call Hloop_ZQ_A(ntryL,G0H32(84),wf8(:,30),G0H4(7),ngZl,m3h8x4(:,26),heltab2x32(:,:,256))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(112),n2h4(194))
  call Hloop_VA_Q(ntryL,G0H32(85),ex2(:),G0H16(13),m3h2x16(:,159),heltab2x32(:,:,257))
  call Hloop_A_Q(ntryL,G0H16(13),34,0,G1H16(63),n2h16(233))
  call Hloop_VA_Q(ntryL,G0H32(86),ex2(:),G0H16(16),m3h2x16(:,160),heltab2x32(:,:,258))
  call Hloop_A_Q(ntryL,G0H16(16),34,0,G1H16(66),n2h16(234))
  call Hloop_ZA_Q(ntryL,G0H32(87),ex2(:),G0H16(18),ngZl,m3h2x16(:,161),heltab2x32(:,:,259))
  call Hloop_A_Q(ntryL,G0H16(18),34,0,G1H16(1),n2h16(235))
  call Hloop_ZA_Q(ntryL,G0H32(88),ex2(:),G0H16(2),ngZl,m3h2x16(:,162),heltab2x32(:,:,260))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(9),n2h16(236))
  call Hloop_WA_Q(ntryL,G0H32(89),ex2(:),G0H16(5),m3h2x16(:,163),heltab2x32(:,:,261))
  call Hloop_A_Q(ntryL,G0H16(5),34,0,G1H16(11),n2h16(237))
  call Hloop_VA_Q(ntryL,G0H32(90),ex2(:),G0H16(4),m3h2x16(:,164),heltab2x32(:,:,262))
  call Hloop_A_Q(ntryL,G0H16(4),34,0,G1H16(18),n2h16(238))
  call Hloop_VA_Q(ntryL,G0H32(91),ex2(:),G0H16(7),m3h2x16(:,165),heltab2x32(:,:,263))
  call Hloop_A_Q(ntryL,G0H16(7),34,0,G1H16(7),n2h16(239))
  call Hloop_ZA_Q(ntryL,G0H32(92),ex2(:),G0H16(10),ngZl,m3h2x16(:,166),heltab2x32(:,:,264))
  call Hloop_A_Q(ntryL,G0H16(10),34,0,G1H16(8),n2h16(240))
  call Hloop_ZA_Q(ntryL,G0H32(93),ex2(:),G0H16(9),ngZl,m3h2x16(:,167),heltab2x32(:,:,265))
  call Hloop_A_Q(ntryL,G0H16(9),34,0,G1H16(15),n2h16(241))
  call Hloop_WA_Q(ntryL,G0H32(94),ex2(:),G0H16(21),m3h2x16(:,168),heltab2x32(:,:,266))
  call Hloop_A_Q(ntryL,G0H16(21),34,0,G1H16(16),n2h16(242))
  call Hloop_VA_Q(ntryL,G0H32(95),wf8(:,94),G0H4(7),m3h8x4(:,27),heltab2x32(:,:,267))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(113),n2h4(195))
  call Hloop_ZA_Q(ntryL,G0H32(96),wf8(:,94),G0H4(7),ngZl,m3h8x4(:,28),heltab2x32(:,:,268))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(114),n2h4(196))
  call Hloop_VA_Q(ntryL,G0H32(97),wf8(:,94),G0H4(7),m3h8x4(:,29),heltab2x32(:,:,269))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(118),n2h4(197))
  call Hloop_ZA_Q(ntryL,G0H32(98),wf8(:,94),G0H4(7),ngZl,m3h8x4(:,30),heltab2x32(:,:,270))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(119),n2h4(198))
  call Hloop_WA_Q(ntryL,G0H32(99),wf8(:,94),G0H4(7),m3h8x4(:,31),heltab2x32(:,:,271))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(120),n2h4(199))
  call Hloop_VA_Q(ntryL,G0H32(100),wf8(:,95),G0H4(7),m3h8x4(:,32),heltab2x32(:,:,272))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(124),n2h4(200))
  call Hloop_ZA_Q(ntryL,G0H32(101),wf8(:,95),G0H4(7),ngZl,m3h8x4(:,33),heltab2x32(:,:,273))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(125),n2h4(201))
  call Hloop_VA_Q(ntryL,G0H32(102),wf8(:,95),G0H4(7),m3h8x4(:,34),heltab2x32(:,:,274))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(126),n2h4(202))
  call Hloop_ZA_Q(ntryL,G0H32(103),wf8(:,95),G0H4(7),ngZl,m3h8x4(:,35),heltab2x32(:,:,275))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(130),n2h4(203))
  call Hloop_WA_Q(ntryL,G0H32(104),wf8(:,95),G0H4(7),m3h8x4(:,36),heltab2x32(:,:,276))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(1),n2h4(204))
  call Hloop_VQ_A(ntryL,G0H32(105),ex1(:),G0H16(1),m3h2x16(:,169),heltab2x32(:,:,277))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(17),n2h16(243))
  call Hloop_VQ_A(ntryL,G0H32(106),ex1(:),G0H16(3),m3h2x16(:,170),heltab2x32(:,:,278))
  call Hloop_Q_A(ntryL,G0H16(3),33,0,G1H16(21),n2h16(244))
  call Hloop_ZQ_A(ntryL,G0H32(107),ex1(:),G0H16(6),ngZl,m3h2x16(:,171),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(6),33,0,G1H16(27),n2h16(245))
  call Hloop_ZQ_A(ntryL,G0H32(108),ex1(:),G0H16(8),ngZl,m3h2x16(:,172),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(8),33,0,G1H16(34),n2h16(246))
  call Hloop_VQ_A(ntryL,G0H32(109),ex1(:),G0H16(11),m3h2x16(:,173),heltab2x32(:,:,281))
  call Hloop_Q_A(ntryL,G0H16(11),33,0,G1H16(35),n2h16(247))
  call Hloop_VQ_A(ntryL,G0H32(110),ex1(:),G0H16(12),m3h2x16(:,174),heltab2x32(:,:,282))
  call Hloop_Q_A(ntryL,G0H16(12),33,0,G1H16(38),n2h16(248))
  call Hloop_ZQ_A(ntryL,G0H32(111),ex1(:),G0H16(15),ngZl,m3h2x16(:,175),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G0H16(15),33,0,G1H16(39),n2h16(249))
  call Hloop_ZQ_A(ntryL,G0H32(112),ex1(:),G0H16(14),ngZl,m3h2x16(:,176),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G0H16(14),33,0,G1H16(40),n2h16(250))
  call Hloop_VQ_A(ntryL,G0H32(113),ex1(:),G0H16(17),m3h2x16(:,177),heltab2x32(:,:,285))
  call Hloop_Q_A(ntryL,G0H16(17),33,0,G1H16(42),n2h16(251))
  call Hloop_VQ_A(ntryL,G0H32(114),ex1(:),G0H16(20),m3h2x16(:,178),heltab2x32(:,:,286))
  call Hloop_Q_A(ntryL,G0H16(20),33,0,G1H16(44),n2h16(252))
  call Hloop_ZQ_A(ntryL,G0H32(115),ex1(:),G0H16(19),ngZl,m3h2x16(:,179),heltab2x32(:,:,287))
  call Hloop_Q_A(ntryL,G0H16(19),33,0,G1H16(46),n2h16(253))
  call Hloop_ZQ_A(ntryL,G0H32(116),ex1(:),G0H16(13),ngZl,m3h2x16(:,180),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(47),n2h16(254))
  call Hloop_VQ_A(ntryL,G0H32(117),ex1(:),G0H16(16),m3h2x16(:,181),heltab2x32(:,:,289))
  call Hloop_Q_A(ntryL,G0H16(16),33,0,G1H16(48),n2h16(255))
  call Hloop_VQ_A(ntryL,G0H32(118),ex1(:),G0H16(18),m3h2x16(:,182),heltab2x32(:,:,290))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(51),n2h16(256))
  call Hloop_ZQ_A(ntryL,G0H32(119),ex1(:),G0H16(2),ngZl,m3h2x16(:,183),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(52),n2h16(257))
  call Hloop_ZQ_A(ntryL,G0H32(120),ex1(:),G0H16(5),ngZl,m3h2x16(:,184),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H16(5),33,0,G1H16(55),n2h16(258))
  call Hloop_VA_Q(ntryL,G0H32(121),ex2(:),G0H16(4),m3h2x16(:,185),heltab2x32(:,:,293))
  call Hloop_A_Q(ntryL,G0H16(4),34,0,G1H16(56),n2h16(259))
  call Hloop_ZA_Q(ntryL,G0H32(122),ex2(:),G0H16(7),ngZl,m3h2x16(:,186),heltab2x32(:,:,294))
  call Hloop_A_Q(ntryL,G0H16(7),34,0,G1H16(57),n2h16(260))
  call Hloop_VA_Q(ntryL,G0H32(123),ex2(:),G0H16(10),m3h2x16(:,187),heltab2x32(:,:,295))
  call Hloop_A_Q(ntryL,G0H16(10),34,0,G1H16(59),n2h16(261))
  call Hloop_ZA_Q(ntryL,G0H32(124),ex2(:),G0H16(9),ngZl,m3h2x16(:,188),heltab2x32(:,:,296))
  call Hloop_A_Q(ntryL,G0H16(9),34,0,G1H16(61),n2h16(262))
  call Hloop_WA_Q(ntryL,G0H32(125),ex2(:),G0H16(21),m3h2x16(:,189),heltab2x32(:,:,297))
  call Hloop_A_Q(ntryL,G0H16(21),34,0,G1H16(64),n2h16(263))
  call Hloop_VA_Q(ntryL,G0H32(126),ex2(:),G0H16(1),m3h2x16(:,190),heltab2x32(:,:,298))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(65),n2h16(264))
  call Hloop_ZA_Q(ntryL,G0H32(127),ex2(:),G0H16(3),ngZl,m3h2x16(:,191),heltab2x32(:,:,299))
  call Hloop_A_Q(ntryL,G0H16(3),34,0,G1H16(2),n2h16(265))
  call Hloop_VA_Q(ntryL,G0H32(128),ex2(:),G0H16(6),m3h2x16(:,192),heltab2x32(:,:,300))
  call Hloop_A_Q(ntryL,G0H16(6),34,0,G1H16(3),n2h16(266))
  call Hloop_ZA_Q(ntryL,G0H32(129),ex2(:),G0H16(8),ngZl,m3h2x16(:,193),heltab2x32(:,:,301))
  call Hloop_A_Q(ntryL,G0H16(8),34,0,G1H16(4),n2h16(267))
  call Hloop_WA_Q(ntryL,G0H32(130),ex2(:),G0H16(11),m3h2x16(:,194),heltab2x32(:,:,302))
  call Hloop_A_Q(ntryL,G0H16(11),34,0,G1H16(10),n2h16(268))
  call Hloop_VA_Q(ntryL,G0H8(24),ex2(:),G0H4(7),m3h2x4(:,125),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(2),n2h4(205))
  call Hloop_ZA_Q(ntryL,G0H8(25),ex2(:),G0H4(7),ngZl,m3h2x4(:,126),heltab2x8(:,:,130))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(8),n2h4(206))
  call Hloop_VA_Q(ntryL,G0H8(26),ex2(:),G0H4(7),m3h2x4(:,127),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(11),n2h4(207))
  call Hloop_ZA_Q(ntryL,G0H8(27),ex2(:),G0H4(7),ngZl,m3h2x4(:,128),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(12),n2h4(208))
  call Hloop_WA_Q(ntryL,G0H8(28),ex2(:),G0H4(7),m3h2x4(:,129),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G0H4(7),46,0,G1H4(18),n2h4(209))
  call Hloop_VQ_A(ntryL,G0H8(33),ex1(:),G0H4(7),m3h2x4(:,130),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(19),n2h4(210))
  call Hloop_VQ_A(ntryL,G0H8(34),ex1(:),G0H4(7),m3h2x4(:,131),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(20),n2h4(211))
  call Hloop_ZQ_A(ntryL,G0H8(35),ex1(:),G0H4(7),ngZl,m3h2x4(:,132),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(26),n2h4(212))
  call Hloop_ZQ_A(ntryL,G0H8(36),ex1(:),G0H4(7),ngZl,m3h2x4(:,133),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G0H4(7),45,0,G1H4(29),n2h4(213))
  call Hloop_QA_V(ntryL,G1H8(4),ex2(:),G1H4(131),m3h2x4(:,134),heltab2x8(:,:,138))
  call Hloop_QA_V(ntryL,G1H8(5),ex2(:),G1H4(132),m3h2x4(:,135),heltab2x8(:,:,139))
  call Hloop_QA_Z(ntryL,G1H8(6),ex2(:),G1H4(133),ngZl,m3h2x4(:,136),heltab2x8(:,:,140))
  call Hloop_QA_Z(ntryL,G1H8(7),ex2(:),G1H4(134),ngZl,m3h2x4(:,137),heltab2x8(:,:,141))
  call Hloop_QA_W(ntryL,G1H8(8),ex2(:),G1H4(135),m3h2x4(:,138),heltab2x8(:,:,142))
  call Hloop_QA_V(ntryL,G1H8(15),ex2(:),G1H4(136),m3h2x4(:,139),heltab2x8(:,:,143))
  call Hloop_QA_V(ntryL,G1H8(16),ex2(:),G1H4(137),m3h2x4(:,140),heltab2x8(:,:,144))
  call Hloop_QA_Z(ntryL,G1H8(17),ex2(:),G1H4(138),ngZl,m3h2x4(:,141),heltab2x8(:,:,145))
  call Hloop_QA_Z(ntryL,G1H8(18),ex2(:),G1H4(139),ngZl,m3h2x4(:,142),heltab2x8(:,:,146))
  call Hloop_AQ_V(ntryL,G1H8(11),ex1(:),G1H4(140),m3h2x4(:,143),heltab2x8(:,:,147))
  call Hloop_AQ_V(ntryL,G1H8(21),ex1(:),G1H4(141),m3h2x4(:,144),heltab2x8(:,:,148))
  call Hloop_AQ_Z(ntryL,G1H8(12),ex1(:),G1H4(142),ngZl,m3h2x4(:,145),heltab2x8(:,:,149))
  call Hloop_AQ_Z(ntryL,G1H8(22),ex1(:),G1H4(143),ngZl,m3h2x4(:,146),heltab2x8(:,:,150))
  call Hloop_AQ_V(ntryL,G1H8(28),ex1(:),G1H4(144),m3h2x4(:,147),heltab2x8(:,:,151))
  call Hloop_AQ_V(ntryL,G1H8(29),ex1(:),G1H4(145),m3h2x4(:,148),heltab2x8(:,:,152))
  call Hloop_AQ_Z(ntryL,G1H8(30),ex1(:),G1H4(146),ngZl,m3h2x4(:,149),heltab2x8(:,:,153))
  call Hloop_AQ_Z(ntryL,G1H8(31),ex1(:),G1H4(147),ngZl,m3h2x4(:,150),heltab2x8(:,:,154))
  call Hloop_AQ_W(ntryL,G1H8(34),ex1(:),G1H4(148),m3h2x4(:,151),heltab2x8(:,:,155))
  call Hloop_VA_Q(ntryL,G0H8(42),ex2(:),G0H4(7),m3h2x4(:,152),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G0H4(7),54,0,G1H4(149),n2h4(214))
  call Hloop_ZA_Q(ntryL,G0H8(43),ex2(:),G0H4(7),ngZl,m3h2x4(:,153),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G0H4(7),54,0,G1H4(150),n2h4(215))
  call Hloop_VA_Q(ntryL,G0H8(44),ex2(:),G0H4(7),m3h2x4(:,154),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G0H4(7),54,0,G1H4(151),n2h4(216))
  call Hloop_ZA_Q(ntryL,G0H8(45),ex2(:),G0H4(7),ngZl,m3h2x4(:,155),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G0H4(7),54,0,G1H4(152),n2h4(217))
  call Hloop_WA_Q(ntryL,G0H8(46),ex2(:),G0H4(7),m3h2x4(:,156),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G0H4(7),54,0,G1H4(153),n2h4(218))
  call Hloop_VQ_A(ntryL,G0H8(51),ex1(:),G0H4(7),m3h2x4(:,157),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G0H4(7),53,0,G1H4(154),n2h4(219))
  call Hloop_VQ_A(ntryL,G0H8(52),ex1(:),G0H4(7),m3h2x4(:,158),heltab2x8(:,:,162))
  call Hloop_Q_A(ntryL,G0H4(7),53,0,G1H4(155),n2h4(220))
  call Hloop_ZQ_A(ntryL,G0H8(53),ex1(:),G0H4(7),ngZl,m3h2x4(:,159),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G0H4(7),53,0,G1H4(156),n2h4(221))
  call Hloop_ZQ_A(ntryL,G0H8(54),ex1(:),G0H4(7),ngZl,m3h2x4(:,160),heltab2x8(:,:,164))
  call Hloop_Q_A(ntryL,G0H4(7),53,0,G1H4(157),n2h4(222))
  call Hloop_VA_Q(ntryL,G0H8(59),ex2(:),G0H4(7),m3h2x4(:,161),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G0H4(7),58,0,G1H4(158),n2h4(223))
  call Hloop_ZA_Q(ntryL,G0H8(60),ex2(:),G0H4(7),ngZl,m3h2x4(:,162),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G0H4(7),58,0,G1H4(159),n2h4(224))
  call Hloop_VA_Q(ntryL,G0H8(61),ex2(:),G0H4(7),m3h2x4(:,163),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G0H4(7),58,0,G1H4(160),n2h4(225))
  call Hloop_ZA_Q(ntryL,G0H8(62),ex2(:),G0H4(7),ngZl,m3h2x4(:,164),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G0H4(7),58,0,G1H4(161),n2h4(226))
  call Hloop_VQ_A(ntryL,G0H8(68),ex1(:),G0H4(7),m3h2x4(:,165),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(162),n2h4(227))
  call Hloop_VQ_A(ntryL,G0H8(69),ex1(:),G0H4(7),m3h2x4(:,166),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(163),n2h4(228))
  call Hloop_ZQ_A(ntryL,G0H8(70),ex1(:),G0H4(7),ngZl,m3h2x4(:,167),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(164),n2h4(229))
  call Hloop_ZQ_A(ntryL,G0H8(71),ex1(:),G0H4(7),ngZl,m3h2x4(:,168),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(165),n2h4(230))
  call Hloop_WQ_A(ntryL,G0H8(72),ex1(:),G0H4(7),m3h2x4(:,169),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(166),n2h4(231))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(148),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(18),G1H4(58),G0H4(5),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(7),G1H4(64),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G2H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G2H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(2),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(5),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(48),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G2H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G2H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G2H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G2H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G2H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(13),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(19),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(65),[G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G2H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(107),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(120)])
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(330),m3h2x2(:,149),heltab2x4(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(330),55,0,G2H2(14),n2h2(34))
  call Hloop_VQ_A(ntryL,G1H4(4),ex3(:),G1H2(335),m3h2x2(:,150),heltab2x4(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(335),55,0,G2H2(2),n2h2(35))
  call Hloop_VQ_A(ntryL,G1H4(9),ex3(:),G1H2(336),m3h2x2(:,151),heltab2x4(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(336),55,0,G2H2(1),n2h2(36))
  call Hloop_VQ_A(ntryL,G1H4(10),ex3(:),G1H2(342),m3h2x2(:,152),heltab2x4(:,:,206))
  call Hloop_Q_A(ntryL,G1H2(342),55,0,G2H2(15),n2h2(37))
  call Hloop_ZQ_A(ntryL,G1H4(15),ex3(:),G1H2(348),ngZl,m3h2x2(:,153),heltab2x4(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(348),55,0,G2H2(13),n2h2(38))
  call Hloop_ZQ_A(ntryL,G1H4(16),ex3(:),G1H2(351),ngZl,m3h2x2(:,154),heltab2x4(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(351),55,0,G2H2(3),n2h2(39))
  call Hloop_ZQ_A(ntryL,G1H4(21),ex3(:),G1H2(353),ngZl,m3h2x2(:,155),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(353),55,0,G2H2(4),n2h2(40))
  call Hloop_ZQ_A(ntryL,G1H4(22),ex3(:),G1H2(357),ngZl,m3h2x2(:,156),heltab2x4(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(357),55,0,G2H2(5),n2h2(41))
  call Hloop_WQ_A(ntryL,G1H4(27),ex3(:),G1H2(359),m3h2x2(:,157),heltab2x4(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(359),55,0,G2H2(6),n2h2(42))
  call Hloop_WQ_A(ntryL,G1H4(28),ex3(:),G1H2(363),m3h2x2(:,158),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(363),55,0,G2H2(7),n2h2(43))
  call Hloop_VA_Q(ntryL,G1H4(33),ex4(:),G1H2(371),m3h2x2(:,159),heltab2x4(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(371),59,0,G2H2(8),n2h2(44))
  call Hloop_VA_Q(ntryL,G1H4(34),ex4(:),G1H2(375),m3h2x2(:,160),heltab2x4(:,:,214))
  call Hloop_A_Q(ntryL,G1H2(375),59,0,G2H2(9),n2h2(45))
  call Hloop_ZA_Q(ntryL,G1H4(39),ex4(:),G1H2(383),ngZl,m3h2x2(:,161),heltab2x4(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(383),59,0,G2H2(10),n2h2(46))
  call Hloop_ZA_Q(ntryL,G1H4(40),ex4(:),G1H2(9),ngZl,m3h2x2(:,162),heltab2x4(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(9),59,0,G2H2(11),n2h2(47))
  call Hloop_VA_Q(ntryL,G1H4(45),ex4(:),G1H2(100),m3h2x2(:,163),heltab2x4(:,:,217))
  call Hloop_A_Q(ntryL,G1H2(100),59,0,G2H2(12),n2h2(48))
  call Hloop_VA_Q(ntryL,G1H4(46),ex4(:),G1H2(23),m3h2x2(:,164),heltab2x4(:,:,218))
  call Hloop_A_Q(ntryL,G1H2(23),59,0,G2H2(16),n2h2(49))
  call Hloop_ZA_Q(ntryL,G1H4(51),ex4(:),G1H2(204),ngZl,m3h2x2(:,165),heltab2x4(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(204),59,0,G2H2(17),n2h2(50))
  call Hloop_ZA_Q(ntryL,G1H4(52),ex4(:),G1H2(106),ngZl,m3h2x2(:,166),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(106),59,0,G2H2(18),n2h2(51))
  call Hloop_WA_Q(ntryL,G1H4(148),ex4(:),G1H2(35),m3h2x2(:,167),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(35),59,0,G2H2(19),n2h2(52))
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(95),mass4set(:,1),  & 
G1H4(57),G1H4(58),G1H4(63),G1H4(64),G1H4(30),4)
  call HG1shiftOLR(G1H4(58),4,4)
  call Hloop_WQ_A(ntryL,G1H4(135),ex3(:),G1H2(210),m3h2x2(:,168),heltab2x4(:,:,222))
  call Hloop_Q_A(ntryL,G1H2(210),55,0,G2H2(20),n2h2(53))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(88),mass4set(:,1),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(37),8,4)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(7),mass4set(:,2),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),8)
  call HG1shiftOLR(G1H8(58),16,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(7),mass4set(:,3),  & 
G1H8(62),G1H8(1),G1H8(2),G1H8(3),G1H8(9),8)
  call HG1shiftOLR(G1H8(1),16,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(7),mass4set(:,4),  & 
G1H8(20),G1H8(38),G1H8(39),G1H8(52),G1H8(53),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(7),mass4set(:,2),  & 
G1H8(54),G1H8(4),G1H8(5),G1H8(6),G1H8(7),8)
  call HG1shiftOLR(G1H8(4),16,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(7),mass4set(:,3),  & 
G1H8(8),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(15),16,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(7),mass4set(:,4),  & 
G1H8(11),G1H8(21),G1H8(12),G1H8(22),G1H8(28),8)
  call HG1shiftOLR(G1H8(21),16,8)
  call Hloop_SV_V(ntryL,G0H8(2),wf4(:,1),G0H2(1),m3h4x2(:,5),heltab2x8(:,:,174))
  call Hloop_SV_V(ntryL,G0H8(5),wf4(:,4),G0H2(2),m3h4x2(:,6),heltab2x8(:,:,175))
  call Hloop_SV_V(ntryL,G0H8(4),wf4(:,4),G0H2(3),m3h4x2(:,7),heltab2x8(:,:,176))
  call Hloop_UV_W(ntryL,G1H8(48),44,wf4(:,1),3,G2H2(21),m3h4x2(:,8),heltab2x8(:,:,177))
  call Hloop_UV_W(ntryL,G1H8(50),44,wf4(:,4),3,G2H2(22),m3h4x2(:,9),heltab2x8(:,:,178))
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(22),mass4set(:,2),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(34),G1H8(47),8)
  call HG1shiftOLR(G1H8(30),16,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(22),mass4set(:,3),  & 
G1H8(49),G1H8(63),G1H8(64),G1H8(10),G1H8(13),8)
  call HG1shiftOLR(G1H8(63),16,8)
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(22),mass4set(:,4),  & 
G1H8(48),G1H8(50),G1H8(67),G1H8(68),G1H8(69),8)
  call HG1shiftOLR(G1H8(50),16,8)
  call Hotf_4pt_reduction(G2H8(22),RedSet_4(22),mass4set(:,2),  & 
G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
  call HG1shiftOLR(G1H8(71),16,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(22),mass4set(:,3),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),8)
  call HG1shiftOLR(G1H8(76),16,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(22),mass4set(:,4),  & 
G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(81),16,8)
  call Hloop_SV_V(ntryL,G0H8(13),wf4(:,2),G0H2(4),m3h4x2(:,10),heltab2x8(:,:,179))
  call Hloop_SV_V(ntryL,G0H8(19),wf4(:,3),G0H2(5),m3h4x2(:,11),heltab2x8(:,:,180))
  call Hloop_SV_V(ntryL,G0H8(14),wf4(:,3),G0H2(6),m3h4x2(:,12),heltab2x8(:,:,181))
  call Hloop_UV_W(ntryL,G1H8(65),35,wf4(:,2),12,G2H2(23),m3h4x2(:,13),heltab2x8(:,:,182))
  call Hloop_UV_W(ntryL,G1H8(66),35,wf4(:,3),12,G2H2(24),m3h4x2(:,14),heltab2x8(:,:,183))
  call Hloop_AQ_W(ntryL,G2H8(27),ex5(:),G2H4(24),m3h2x4(:,170),heltab2x8(:,:,184))
  call Hloop_AQ_W(ntryL,G2H8(28),ex5(:),G2H4(25),m3h2x4(:,171),heltab2x8(:,:,185))
  call Hloop_WQ_A(ntryL,G1H8(14),ex5(:),G1H4(62),m3h2x4(:,172),heltab2x8(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(62),51,0,G2H4(26),n2h4(232))
  call Hloop_WQ_A(ntryL,G1H8(19),ex5(:),G1H4(65),m3h2x4(:,173),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H4(65),51,0,G2H4(27),n2h4(233))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(25),m3h2x2(:,169),heltab2x4(:,:,223))
  call Hloop_AQ_Z(ntryL,G2H4(5),ex3(:),G2H2(26),ngZl,m3h2x2(:,170),heltab2x4(:,:,224))
  call Hloop_AQ_W(ntryL,G2H4(6),ex3(:),G2H2(27),m3h2x2(:,171),heltab2x4(:,:,225))
  call Hloop_ZQ_A(ntryL,G0H4(3),ex3(:),G0H2(7),ngZl,m3h2x2(:,172),heltab2x4(:,:,226))
  call Hloop_Q_A(ntryL,G0H2(7),55,0,G1H2(27),n2h2(54))
  call Hloop_QA_V(ntryL,G2H4(15),ex4(:),G2H2(28),m3h2x2(:,173),heltab2x4(:,:,227))
  call Hloop_QA_Z(ntryL,G2H4(16),ex4(:),G2H2(29),ngZl,m3h2x2(:,174),heltab2x4(:,:,228))
  call Hloop_QA_W(ntryL,G2H4(17),ex4(:),G2H2(30),m3h2x2(:,175),heltab2x4(:,:,229))
  call Hloop_ZA_Q(ntryL,G0H4(6),ex4(:),G0H2(7),ngZl,m3h2x2(:,176),heltab2x4(:,:,230))
  call Hloop_A_Q(ntryL,G0H2(7),59,0,G1H2(112),n2h2(55))
  call Hotf_4pt_reduction(G2H8(29),RedSet_4(136),mass4set(:,5),  & 
G1H8(65),G1H8(66),G1H8(14),G1H8(19),G1H8(85),8)
  call HG1shiftOLR(G1H8(66),8,8)
  call Hloop_UV_W(ntryL,G1H8(32),52,wf4(:,1),3,G2H2(31),m3h4x2(:,15),heltab2x8(:,:,188))
  call Hloop_UV_W(ntryL,G1H8(33),52,wf4(:,4),3,G2H2(32),m3h4x2(:,16),heltab2x8(:,:,189))
  call Hloop_QA_V(ntryL,G1H4(44),ex4(:),G1H2(41),m3h2x2(:,177),heltab2x4(:,:,231))
  call Hloop_QA_V(ntryL,G1H4(47),ex4(:),G1H2(222),m3h2x2(:,178),heltab2x4(:,:,232))
  call Hloop_QA_Z(ntryL,G1H4(48),ex4(:),G1H2(33),ngZl,m3h2x2(:,179),heltab2x4(:,:,233))
  call Hloop_QA_Z(ntryL,G1H4(54),ex4(:),G1H2(118),ngZl,m3h2x2(:,180),heltab2x4(:,:,234))
  call Hloop_AQ_V(ntryL,G1H16(24),wf8(:,15),G1H2(216),m3h8x2(:,1),heltab2x16(:,:,189))
  call Hloop_AQ_Z(ntryL,G1H16(25),wf8(:,15),G1H2(124),ngZl,m3h8x2(:,2),heltab2x16(:,:,190))
  call Hloop_AQ_V(ntryL,G1H16(30),wf8(:,15),G1H2(47),m3h8x2(:,3),heltab2x16(:,:,191))
  call Hloop_AQ_Z(ntryL,G1H16(31),wf8(:,15),G1H2(234),ngZl,m3h8x2(:,4),heltab2x16(:,:,192))
  call Hloop_AQ_W(ntryL,G1H16(32),wf8(:,15),G1H2(130),m3h8x2(:,5),heltab2x16(:,:,193))
  call Hloop_AQ_V(ntryL,G1H16(33),wf8(:,18),G1H2(228),m3h8x2(:,6),heltab2x16(:,:,194))
  call Hloop_AQ_Z(ntryL,G1H16(67),wf8(:,18),G1H2(45),ngZl,m3h8x2(:,7),heltab2x16(:,:,195))
  call Hloop_AQ_V(ntryL,G1H16(68),wf8(:,18),G1H2(136),m3h8x2(:,8),heltab2x16(:,:,196))
  call Hloop_AQ_Z(ntryL,G1H16(69),wf8(:,18),G1H2(240),ngZl,m3h8x2(:,9),heltab2x16(:,:,197))
  call Hloop_AQ_W(ntryL,G1H16(70),wf8(:,18),G1H2(142),m3h8x2(:,10),heltab2x16(:,:,198))
  call Hloop_AQ_V(ntryL,G1H4(70),ex3(:),G1H2(246),m3h2x2(:,181),heltab2x4(:,:,235))
  call Hloop_AQ_V(ntryL,G1H4(71),ex3(:),G1H2(63),m3h2x2(:,182),heltab2x4(:,:,236))
  call Hloop_AQ_Z(ntryL,G1H4(72),ex3(:),G1H2(304),ngZl,m3h2x2(:,183),heltab2x4(:,:,237))
  call Hloop_AQ_Z(ntryL,G1H4(76),ex3(:),G1H2(71),ngZl,m3h2x2(:,184),heltab2x4(:,:,238))
  call Hloop_AQ_W(ntryL,G1H4(77),ex3(:),G1H2(150),m3h2x2(:,185),heltab2x4(:,:,239))
  call Hloop_QA_V(ntryL,G1H16(71),wf8(:,60),G1H2(75),m3h8x2(:,11),heltab2x16(:,:,199))
  call Hloop_QA_Z(ntryL,G1H16(72),wf8(:,60),G1H2(310),ngZl,m3h8x2(:,12),heltab2x16(:,:,200))
  call Hloop_QA_V(ntryL,G1H16(73),wf8(:,60),G1H2(83),m3h8x2(:,13),heltab2x16(:,:,201))
  call Hloop_QA_Z(ntryL,G1H16(74),wf8(:,60),G1H2(156),ngZl,m3h8x2(:,14),heltab2x16(:,:,202))
  call Hloop_QA_V(ntryL,G1H16(75),wf8(:,62),G1H2(322),m3h8x2(:,15),heltab2x16(:,:,203))
  call Hloop_QA_Z(ntryL,G1H16(76),wf8(:,62),G1H2(89),ngZl,m3h8x2(:,16),heltab2x16(:,:,204))
  call Hloop_QA_V(ntryL,G1H16(5),wf8(:,62),G1H2(162),m3h8x2(:,17),heltab2x16(:,:,205))
  call Hloop_QA_Z(ntryL,G1H16(6),wf8(:,62),G1H2(87),ngZl,m3h8x2(:,18),heltab2x16(:,:,206))
  call Hloop_QA_V(ntryL,G1H16(13),ex4(:),G1H8(32),m3h2x8(:,135),heltab2x16(:,:,207))
  call Hloop_QA_Z(ntryL,G1H16(14),ex4(:),G1H8(33),ngZl,m3h2x8(:,136),heltab2x16(:,:,208))
  call Hloop_QA_V(ntryL,G1H16(19),ex4(:),G1H8(86),m3h2x8(:,137),heltab2x16(:,:,209))
  call Hloop_QA_Z(ntryL,G1H16(26),ex4(:),G1H8(87),ngZl,m3h2x8(:,138),heltab2x16(:,:,210))
  call Hloop_QA_V(ntryL,G1H16(28),ex4(:),G1H8(88),m3h2x8(:,139),heltab2x16(:,:,211))
  call Hloop_QA_Z(ntryL,G1H16(29),ex4(:),G1H8(89),ngZl,m3h2x8(:,140),heltab2x16(:,:,212))
  call Hloop_QA_V(ntryL,G1H16(36),ex4(:),G1H8(90),m3h2x8(:,141),heltab2x16(:,:,213))
  call Hloop_QA_Z(ntryL,G1H16(37),ex4(:),G1H8(91),ngZl,m3h2x8(:,142),heltab2x16(:,:,214))
  call Hloop_AQ_V(ntryL,G1H16(41),ex3(:),G1H8(92),m3h2x8(:,143),heltab2x16(:,:,215))
  call Hloop_AQ_V(ntryL,G1H16(43),ex3(:),G1H8(93),m3h2x8(:,144),heltab2x16(:,:,216))
  call Hloop_AQ_Z(ntryL,G1H16(45),ex3(:),G1H8(94),ngZl,m3h2x8(:,145),heltab2x16(:,:,217))
  call Hloop_AQ_Z(ntryL,G1H16(49),ex3(:),G1H8(95),ngZl,m3h2x8(:,146),heltab2x16(:,:,218))
  call Hloop_AQ_W(ntryL,G1H16(50),ex3(:),G1H8(96),m3h2x8(:,147),heltab2x16(:,:,219))
  call Hloop_AQ_V(ntryL,G1H16(53),ex3(:),G1H8(97),m3h2x8(:,148),heltab2x16(:,:,220))
  call Hloop_AQ_V(ntryL,G1H16(54),ex3(:),G1H8(98),m3h2x8(:,149),heltab2x16(:,:,221))
  call Hloop_AQ_Z(ntryL,G1H16(58),ex3(:),G1H8(99),ngZl,m3h2x8(:,150),heltab2x16(:,:,222))
  call Hloop_AQ_Z(ntryL,G1H16(60),ex3(:),G1H8(100),ngZl,m3h2x8(:,151),heltab2x16(:,:,223))
  call Hloop_AQ_W(ntryL,G1H16(62),ex3(:),G1H8(101),m3h2x8(:,152),heltab2x16(:,:,224))
  call Hloop_AQ_V(ntryL,G1H4(78),ex3(:),G1H2(316),m3h2x2(:,186),heltab2x4(:,:,240))
  call Hloop_AQ_V(ntryL,G1H4(82),ex3(:),G1H2(168),m3h2x2(:,187),heltab2x4(:,:,241))
  call Hloop_AQ_Z(ntryL,G1H4(83),ex3(:),G1H2(334),ngZl,m3h2x2(:,188),heltab2x4(:,:,242))
  call Hloop_AQ_Z(ntryL,G1H4(84),ex3(:),G1H2(95),ngZl,m3h2x2(:,189),heltab2x4(:,:,243))
  call Hloop_AQ_W(ntryL,G1H4(88),ex3(:),G1H2(174),m3h2x2(:,190),heltab2x4(:,:,244))
  call Hloop_QA_V(ntryL,G1H4(89),ex4(:),G1H2(93),m3h2x2(:,191),heltab2x4(:,:,245))
  call Hloop_QA_Z(ntryL,G1H4(90),ex4(:),G1H2(328),ngZl,m3h2x2(:,192),heltab2x4(:,:,246))
  call Hloop_QA_V(ntryL,G1H4(94),ex4(:),G1H2(180),m3h2x2(:,193),heltab2x4(:,:,247))
  call Hloop_QA_Z(ntryL,G1H4(95),ex4(:),G1H2(340),ngZl,m3h2x2(:,194),heltab2x4(:,:,248))
  call Hloop_VQ_A(ntryL,G1H8(23),ex1(:),G1H4(66),m3h2x4(:,174),heltab2x8(:,:,190))
  call Hloop_Q_A(ntryL,G1H4(66),51,0,G2H4(28),n2h4(234))
  call Hloop_ZQ_A(ntryL,G1H8(24),ex1(:),G1H4(96),ngZl,m3h2x4(:,175),heltab2x8(:,:,191))
  call Hloop_Q_A(ntryL,G1H4(96),51,0,G2H4(33),n2h4(235))
  call Hloop_VQ_A(ntryL,G1H8(25),ex1(:),G1H4(100),m3h2x4(:,176),heltab2x8(:,:,192))
  call Hloop_Q_A(ntryL,G1H4(100),51,0,G2H4(34),n2h4(236))
  call Hloop_ZQ_A(ntryL,G1H8(26),ex1(:),G1H4(101),ngZl,m3h2x4(:,177),heltab2x8(:,:,193))
  call Hloop_Q_A(ntryL,G1H4(101),51,0,G2H4(35),n2h4(237))
  call Hloop_WQ_A(ntryL,G1H8(27),ex1(:),G1H4(102),m3h2x4(:,178),heltab2x8(:,:,194))
  call Hloop_Q_A(ntryL,G1H4(102),51,0,G2H4(36),n2h4(238))
  call Hloop_AQ_W(ntryL,G1H8(35),ex1(:),G1H4(113),m3h2x4(:,179),heltab2x8(:,:,195))
  call Hloop_AQ_W(ntryL,G1H8(36),ex1(:),G1H4(114),m3h2x4(:,180),heltab2x8(:,:,196))
  call Hloop_AQ_Z(ntryL,G1H8(37),ex1(:),G1H4(118),ngZl,m3h2x4(:,181),heltab2x8(:,:,197))
  call Hloop_AQ_W(ntryL,G2H8(30),ex1(:),G2H4(37),m3h2x4(:,182),heltab2x8(:,:,198))
  call Hloop_AQ_W(ntryL,G2H8(31),ex1(:),G2H4(42),m3h2x4(:,183),heltab2x8(:,:,199))
  call Hloop_VA_Q(ntryL,G1H8(40),ex2(:),G1H4(119),m3h2x4(:,184),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G1H4(119),51,0,G2H4(43),n2h4(239))
  call Hloop_ZA_Q(ntryL,G1H8(41),ex2(:),G1H4(120),ngZl,m3h2x4(:,185),heltab2x8(:,:,201))
  call Hloop_A_Q(ntryL,G1H4(120),51,0,G2H4(44),n2h4(240))
  call Hloop_VA_Q(ntryL,G1H8(42),ex2(:),G1H4(3),m3h2x4(:,186),heltab2x8(:,:,202))
  call Hloop_A_Q(ntryL,G1H4(3),51,0,G2H4(45),n2h4(241))
  call Hloop_ZA_Q(ntryL,G1H8(43),ex2(:),G1H4(4),ngZl,m3h2x4(:,187),heltab2x8(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(4),51,0,G2H4(46),n2h4(242))
  call Hloop_WA_Q(ntryL,G1H8(44),ex2(:),G1H4(9),m3h2x4(:,188),heltab2x8(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(9),51,0,G2H4(47),n2h4(243))
  call Hloop_QA_W(ntryL,G1H8(45),ex2(:),G1H4(10),m3h2x4(:,189),heltab2x8(:,:,205))
  call Hloop_QA_W(ntryL,G1H8(46),ex2(:),G1H4(15),m3h2x4(:,190),heltab2x8(:,:,206))
  call Hloop_QA_Z(ntryL,G1H8(51),ex2(:),G1H4(16),ngZl,m3h2x4(:,191),heltab2x8(:,:,207))
  call Hloop_QA_W(ntryL,G2H8(32),ex2(:),G2H4(48),m3h2x4(:,192),heltab2x8(:,:,208))
  call Hloop_QA_W(ntryL,G2H8(33),ex2(:),G2H4(49),m3h2x4(:,193),heltab2x8(:,:,209))
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(143),mass4set(:,5),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),8)
  call HG1shiftOLR(G1H8(24),2,8)
  call Hloop_UV_W(ntryL,G1H8(55),49,wf4(:,2),12,G2H2(33),m3h4x2(:,17),heltab2x8(:,:,210))
  call Hloop_UV_W(ntryL,G1H8(56),49,wf4(:,3),12,G2H2(34),m3h4x2(:,18),heltab2x8(:,:,211))
  call Hloop_QA_V(ntryL,G1H4(106),ex2(:),G1H2(186),m3h2x2(:,195),heltab2x4(:,:,249))
  call Hloop_QA_V(ntryL,G1H4(107),ex2(:),G1H2(346),m3h2x2(:,196),heltab2x4(:,:,250))
  call Hloop_QA_Z(ntryL,G1H4(108),ex2(:),G1H2(192),ngZl,m3h2x2(:,197),heltab2x4(:,:,251))
  call Hloop_QA_Z(ntryL,G1H4(112),ex2(:),G1H2(105),ngZl,m3h2x2(:,198),heltab2x4(:,:,252))
  call Hloop_AQ_V(ntryL,G1H16(63),wf8(:,27),G1H2(119),m3h8x2(:,19),heltab2x16(:,:,225))
  call Hloop_AQ_Z(ntryL,G1H16(66),wf8(:,27),G1H2(258),ngZl,m3h8x2(:,20),heltab2x16(:,:,226))
  call Hloop_AQ_V(ntryL,G1H16(1),wf8(:,27),G1H2(131),m3h8x2(:,21),heltab2x16(:,:,227))
  call Hloop_AQ_Z(ntryL,G1H16(9),wf8(:,27),G1H2(264),ngZl,m3h8x2(:,22),heltab2x16(:,:,228))
  call Hloop_AQ_W(ntryL,G1H16(11),wf8(:,27),G1H2(123),m3h8x2(:,23),heltab2x16(:,:,229))
  call Hloop_AQ_V(ntryL,G1H16(18),wf8(:,30),G1H2(137),m3h8x2(:,24),heltab2x16(:,:,230))
  call Hloop_AQ_Z(ntryL,G1H16(7),wf8(:,30),G1H2(276),ngZl,m3h8x2(:,25),heltab2x16(:,:,231))
  call Hloop_AQ_V(ntryL,G1H16(8),wf8(:,30),G1H2(129),m3h8x2(:,26),heltab2x16(:,:,232))
  call Hloop_AQ_Z(ntryL,G1H16(15),wf8(:,30),G1H2(270),ngZl,m3h8x2(:,27),heltab2x16(:,:,233))
  call Hloop_AQ_W(ntryL,G1H16(16),wf8(:,30),G1H2(143),m3h8x2(:,28),heltab2x16(:,:,234))
  call Hloop_AQ_V(ntryL,G1H4(124),ex1(:),G1H2(288),m3h2x2(:,199),heltab2x4(:,:,253))
  call Hloop_AQ_V(ntryL,G1H4(125),ex1(:),G1H2(282),m3h2x2(:,200),heltab2x4(:,:,254))
  call Hloop_AQ_Z(ntryL,G1H4(126),ex1(:),G1H2(141),ngZl,m3h2x2(:,201),heltab2x4(:,:,255))
  call Hloop_AQ_Z(ntryL,G1H4(130),ex1(:),G1H2(294),ngZl,m3h2x2(:,202),heltab2x4(:,:,256))
  call Hloop_AQ_W(ntryL,G1H4(1),ex1(:),G1H2(300),m3h2x2(:,203),heltab2x4(:,:,257))
  call Hloop_QA_V(ntryL,G1H16(17),wf8(:,94),G1H2(159),m3h8x2(:,29),heltab2x16(:,:,235))
  call Hloop_QA_Z(ntryL,G1H16(21),wf8(:,94),G1H2(352),ngZl,m3h8x2(:,30),heltab2x16(:,:,236))
  call Hloop_QA_V(ntryL,G1H16(27),wf8(:,94),G1H2(167),m3h8x2(:,31),heltab2x16(:,:,237))
  call Hloop_QA_Z(ntryL,G1H16(34),wf8(:,94),G1H2(171),ngZl,m3h8x2(:,32),heltab2x16(:,:,238))
  call Hloop_QA_V(ntryL,G1H16(35),wf8(:,95),G1H2(358),m3h8x2(:,33),heltab2x16(:,:,239))
  call Hloop_QA_Z(ntryL,G1H16(38),wf8(:,95),G1H2(179),ngZl,m3h8x2(:,34),heltab2x16(:,:,240))
  call Hloop_QA_V(ntryL,G1H16(39),wf8(:,95),G1H2(370),m3h8x2(:,35),heltab2x16(:,:,241))
  call Hloop_QA_Z(ntryL,G1H16(40),wf8(:,95),G1H2(185),ngZl,m3h8x2(:,36),heltab2x16(:,:,242))
  call Hloop_QA_V(ntryL,G1H16(42),ex2(:),G1H8(35),m3h2x8(:,153),heltab2x16(:,:,243))
  call Hloop_QA_Z(ntryL,G1H16(44),ex2(:),G1H8(36),ngZl,m3h2x8(:,154),heltab2x16(:,:,244))
  call Hloop_QA_V(ntryL,G1H16(46),ex2(:),G1H8(37),m3h2x8(:,155),heltab2x16(:,:,245))
  call Hloop_QA_Z(ntryL,G1H16(47),ex2(:),G1H8(40),ngZl,m3h2x8(:,156),heltab2x16(:,:,246))
  call Hloop_QA_V(ntryL,G1H16(48),ex2(:),G1H8(41),m3h2x8(:,157),heltab2x16(:,:,247))
  call Hloop_QA_Z(ntryL,G1H16(51),ex2(:),G1H8(42),ngZl,m3h2x8(:,158),heltab2x16(:,:,248))
  call Hloop_QA_V(ntryL,G1H16(52),ex2(:),G1H8(43),m3h2x8(:,159),heltab2x16(:,:,249))
  call Hloop_QA_Z(ntryL,G1H16(55),ex2(:),G1H8(44),ngZl,m3h2x8(:,160),heltab2x16(:,:,250))
  call Hloop_AQ_V(ntryL,G1H16(56),ex1(:),G1H8(45),m3h2x8(:,161),heltab2x16(:,:,251))
  call Hloop_AQ_V(ntryL,G1H16(57),ex1(:),G1H8(46),m3h2x8(:,162),heltab2x16(:,:,252))
  call Hloop_AQ_Z(ntryL,G1H16(59),ex1(:),G1H8(51),ngZl,m3h2x8(:,163),heltab2x16(:,:,253))
  call Hloop_AQ_Z(ntryL,G1H16(61),ex1(:),G1H8(55),ngZl,m3h2x8(:,164),heltab2x16(:,:,254))
  call Hloop_AQ_W(ntryL,G1H16(64),ex1(:),G1H8(56),m3h2x8(:,165),heltab2x16(:,:,255))
  call Hloop_AQ_V(ntryL,G1H16(65),ex1(:),G1H8(102),m3h2x8(:,166),heltab2x16(:,:,256))
  call Hloop_AQ_V(ntryL,G1H16(2),ex1(:),G1H8(103),m3h2x8(:,167),heltab2x16(:,:,257))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex1(:),G1H8(104),ngZl,m3h2x8(:,168),heltab2x16(:,:,258))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex1(:),G1H8(105),ngZl,m3h2x8(:,169),heltab2x16(:,:,259))
  call Hloop_AQ_W(ntryL,G1H16(10),ex1(:),G1H8(106),m3h2x8(:,170),heltab2x16(:,:,260))
  call Hloop_AQ_V(ntryL,G1H4(2),ex1(:),G1H2(183),m3h2x2(:,204),heltab2x4(:,:,258))
  call Hloop_AQ_V(ntryL,G1H4(8),ex1(:),G1H2(364),m3h2x2(:,205),heltab2x4(:,:,259))
  call Hloop_AQ_Z(ntryL,G1H4(11),ex1(:),G1H2(382),ngZl,m3h2x2(:,206),heltab2x4(:,:,260))
  call Hloop_AQ_Z(ntryL,G1H4(12),ex1(:),G1H2(191),ngZl,m3h2x2(:,207),heltab2x4(:,:,261))
  call Hloop_AQ_W(ntryL,G1H4(18),ex1(:),G1H2(189),m3h2x2(:,208),heltab2x4(:,:,262))
  call Hloop_QA_V(ntryL,G1H4(19),ex2(:),G1H2(376),m3h2x2(:,209),heltab2x4(:,:,263))
  call Hloop_QA_Z(ntryL,G1H4(20),ex2(:),G1H2(388),ngZl,m3h2x2(:,210),heltab2x4(:,:,264))
  call Hloop_QA_V(ntryL,G1H4(26),ex2(:),G1H2(394),m3h2x2(:,211),heltab2x4(:,:,265))
  call Hloop_QA_Z(ntryL,G1H4(29),ex2(:),G1H2(195),ngZl,m3h2x2(:,212),heltab2x4(:,:,266))
  call Hloop_VQ_A(ntryL,G1H4(131),ex3(:),G1H2(197),m3h2x2(:,213),heltab2x4(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(197),55,0,G2H2(35),n2h2(56))
  call Hloop_VQ_A(ntryL,G1H4(132),ex3(:),G1H2(207),m3h2x2(:,214),heltab2x4(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(207),55,0,G2H2(36),n2h2(57))
  call Hloop_ZQ_A(ntryL,G1H4(133),ex3(:),G1H2(256),ngZl,m3h2x2(:,215),heltab2x4(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(256),55,0,G2H2(37),n2h2(58))
  call Hloop_ZQ_A(ntryL,G1H4(134),ex3(:),G1H2(215),ngZl,m3h2x2(:,216),heltab2x4(:,:,270))
  call Hloop_Q_A(ntryL,G1H2(215),55,0,G2H2(38),n2h2(59))
  call Hloop_VA_Q(ntryL,G1H4(136),ex4(:),G1H2(262),m3h2x2(:,217),heltab2x4(:,:,271))
  call Hloop_A_Q(ntryL,G1H2(262),59,0,G2H2(39),n2h2(60))
  call Hloop_VA_Q(ntryL,G1H4(137),ex4(:),G1H2(227),m3h2x2(:,218),heltab2x4(:,:,272))
  call Hloop_A_Q(ntryL,G1H2(227),59,0,G2H2(40),n2h2(61))
  call Hloop_ZA_Q(ntryL,G1H4(138),ex4(:),G1H2(225),ngZl,m3h2x2(:,219),heltab2x4(:,:,273))
  call Hloop_A_Q(ntryL,G1H2(225),59,0,G2H2(41),n2h2(62))
  call Hloop_ZA_Q(ntryL,G1H4(139),ex4(:),G1H2(268),ngZl,m3h2x2(:,220),heltab2x4(:,:,274))
  call Hloop_A_Q(ntryL,G1H2(268),59,0,G2H2(42),n2h2(63))
  call Hloop_VQ_A(ntryL,G1H4(140),ex3(:),G1H2(231),m3h2x2(:,221),heltab2x4(:,:,275))
  call Hloop_Q_A(ntryL,G1H2(231),55,0,G2H2(43),n2h2(64))
  call Hloop_VQ_A(ntryL,G1H4(141),ex3(:),G1H2(274),m3h2x2(:,222),heltab2x4(:,:,276))
  call Hloop_Q_A(ntryL,G1H2(274),55,0,G2H2(45),n2h2(65))
  call Hloop_ZQ_A(ntryL,G1H4(142),ex3(:),G1H2(239),ngZl,m3h2x2(:,223),heltab2x4(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(239),55,0,G2H2(46),n2h2(66))
  call Hloop_ZQ_A(ntryL,G1H4(143),ex3(:),G1H2(280),ngZl,m3h2x2(:,224),heltab2x4(:,:,278))
  call Hloop_Q_A(ntryL,G1H2(280),55,0,G2H2(48),n2h2(67))
  call Hloop_VA_Q(ntryL,G1H4(144),ex4(:),G1H2(286),m3h2x2(:,225),heltab2x4(:,:,279))
  call Hloop_A_Q(ntryL,G1H2(286),59,0,G2H2(49),n2h2(68))
  call Hloop_VA_Q(ntryL,G1H4(145),ex4(:),G1H2(245),m3h2x2(:,226),heltab2x4(:,:,280))
  call Hloop_A_Q(ntryL,G1H2(245),59,0,G2H2(51),n2h2(69))
  call Hloop_ZA_Q(ntryL,G1H4(146),ex4(:),G1H2(243),ngZl,m3h2x2(:,227),heltab2x4(:,:,281))
  call Hloop_A_Q(ntryL,G1H2(243),59,0,G2H2(52),n2h2(70))
  call Hloop_ZA_Q(ntryL,G1H4(147),ex4(:),G1H2(292),ngZl,m3h2x2(:,228),heltab2x4(:,:,282))
  call Hloop_A_Q(ntryL,G1H2(292),59,0,G2H2(54),n2h2(71))
  call Hloop_AQ_V(ntryL,G1H4(149),ex1(:),G1H2(298),m3h2x2(:,229),heltab2x4(:,:,283))
  call Hloop_AQ_V(ntryL,G1H4(150),ex1(:),G1H2(249),m3h2x2(:,230),heltab2x4(:,:,284))
  call Hloop_AQ_Z(ntryL,G1H4(151),ex1(:),G1H2(251),ngZl,m3h2x2(:,231),heltab2x4(:,:,285))
  call Hloop_AQ_Z(ntryL,G1H4(152),ex1(:),G1H2(261),ngZl,m3h2x2(:,232),heltab2x4(:,:,286))
  call Hloop_AQ_W(ntryL,G1H4(153),ex1(:),G1H2(269),m3h2x2(:,233),heltab2x4(:,:,287))
  call Hloop_QA_V(ntryL,G1H4(154),ex2(:),G1H2(281),m3h2x2(:,234),heltab2x4(:,:,288))
  call Hloop_QA_Z(ntryL,G1H4(155),ex2(:),G1H2(279),ngZl,m3h2x2(:,235),heltab2x4(:,:,289))
  call Hloop_QA_V(ntryL,G1H4(156),ex2(:),G1H2(285),m3h2x2(:,236),heltab2x4(:,:,290))
  call Hloop_QA_Z(ntryL,G1H4(157),ex2(:),G1H2(293),ngZl,m3h2x2(:,237),heltab2x4(:,:,291))
  call Hloop_AQ_V(ntryL,G1H4(158),ex1(:),G1H2(299),m3h2x2(:,238),heltab2x4(:,:,292))
  call Hloop_AQ_V(ntryL,G1H4(159),ex1(:),G1H2(297),m3h2x2(:,239),heltab2x4(:,:,293))
  call Hloop_AQ_Z(ntryL,G1H4(160),ex1(:),G1H2(321),ngZl,m3h2x2(:,240),heltab2x4(:,:,294))
  call Hloop_AQ_Z(ntryL,G1H4(161),ex1(:),G1H2(317),ngZl,m3h2x2(:,241),heltab2x4(:,:,295))
  call Hloop_QA_V(ntryL,G1H4(162),ex2(:),G1H2(354),m3h2x2(:,242),heltab2x4(:,:,296))
  call Hloop_QA_Z(ntryL,G1H4(163),ex2(:),G1H2(333),ngZl,m3h2x2(:,243),heltab2x4(:,:,297))
  call Hloop_QA_V(ntryL,G1H4(164),ex2(:),G1H2(329),m3h2x2(:,244),heltab2x4(:,:,298))
  call Hloop_QA_Z(ntryL,G1H4(165),ex2(:),G1H2(360),ngZl,m3h2x2(:,245),heltab2x4(:,:,299))
  call Hloop_QA_W(ntryL,G1H4(166),ex2(:),G1H2(339),m3h2x2(:,246),heltab2x4(:,:,300))
  call Hloop_WA_Q(ntryL,G1H4(57),ex4(:),G1H2(366),m3h2x2(:,247),heltab2x4(:,:,301))
  call Hloop_A_Q(ntryL,G1H2(366),59,0,G2H2(55),n2h2(72))
call HGT_raise_alpha_OLR(G1H4(58),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(58),ex3(:),G1H2(341),m3h2x2(:,248),heltab2x4(:,:,302))
  call Hloop_WA_Q(ntryL,G1H4(64),ex4(:),G1H2(372),m3h2x2(:,249),heltab2x4(:,:,303))
  call Hloop_A_Q(ntryL,G1H2(372),59,0,G2H2(57),n2h2(73))
  call Hloop_WA_Q(ntryL,G1H4(30),ex4(:),G1H2(345),m3h2x2(:,250),heltab2x4(:,:,304))
  call Hloop_A_Q(ntryL,G1H2(345),59,0,G2H2(58),n2h2(74))
  call Hloop_WQ_A(ntryL,G1H4(36),ex3(:),G1H2(378),m3h2x2(:,251),heltab2x4(:,:,305))
  call Hloop_Q_A(ntryL,G1H2(378),55,0,G2H2(60),n2h2(75))
call HGT_raise_alpha_OLR(G1H4(37),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(37),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(37),ex4(:),G1H2(347),m3h2x2(:,252),heltab2x4(:,:,306))
  call Hloop_WQ_A(ntryL,G1H4(55),ex3(:),G1H2(384),m3h2x2(:,253),heltab2x4(:,:,307))
  call Hloop_Q_A(ntryL,G1H2(384),55,0,G2H2(61),n2h2(76))
  call Hloop_WQ_A(ntryL,G1H4(56),ex3(:),G1H2(390),m3h2x2(:,254),heltab2x4(:,:,308))
  call Hloop_Q_A(ntryL,G1H2(390),55,0,G2H2(63),n2h2(77))
  call Hloop_AV_Q(ntryL,G1H8(57),wf4(:,1),G1H2(396),m3h4x2(:,19),heltab2x8(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(396),47,0,G2H2(64),n2h2(78))
call HGT_raise_alpha_OLR(G1H8(58),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(58),ex5(:),G1H4(21),m3h2x4(:,194),heltab2x8(:,:,213))
  call Hloop_AV_Q(ntryL,G1H8(60),wf4(:,1),G1H2(369),m3h4x2(:,20),heltab2x8(:,:,214))
  call Hloop_A_Q(ntryL,G1H2(369),47,0,G2H2(66),n2h2(79))
  call Hloop_AV_Q(ntryL,G1H8(61),wf4(:,1),G1H2(365),m3h4x2(:,21),heltab2x8(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(365),47,0,G2H2(67),n2h2(80))
  call Hloop_AV_Q(ntryL,G1H8(62),wf4(:,1),G1H2(381),m3h4x2(:,22),heltab2x8(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(381),47,0,G2H2(69),n2h2(81))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(1),ex5(:),G1H4(22),ngZu,m3h2x4(:,195),heltab2x8(:,:,217))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,1),G1H2(377),m3h4x2(:,23),heltab2x8(:,:,218))
  call Hloop_A_Q(ntryL,G1H2(377),47,0,G2H2(70),n2h2(82))
  call Hloop_AV_Q(ntryL,G1H8(9),wf4(:,1),G1H2(387),m3h4x2(:,24),heltab2x8(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(387),47,0,G2H2(72),n2h2(83))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,1),G1H2(389),m3h4x2(:,25),heltab2x8(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(389),47,0,G2H2(73),n2h2(84))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(38),ex5(:),G1H4(27),m3h2x4(:,196),heltab2x8(:,:,221))
  call Hloop_AV_Q(ntryL,G1H8(52),wf4(:,1),G1H2(393),m3h4x2(:,26),heltab2x8(:,:,222))
  call Hloop_A_Q(ntryL,G1H2(393),47,0,G2H2(75),n2h2(85))
  call Hloop_AV_Q(ntryL,G1H8(53),wf4(:,1),G1H2(395),m3h4x2(:,27),heltab2x8(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(395),47,0,G2H2(76),n2h2(86))
  call Hloop_AZ_Q(ntryL,G1H8(54),wf4(:,4),G1H2(133),ngZu,m3h4x2(:,28),heltab2x8(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(133),47,0,G2H2(77),n2h2(87))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(4),ex5(:),G1H4(28),m3h2x4(:,197),heltab2x8(:,:,225))
  call Hloop_AZ_Q(ntryL,G1H8(6),wf4(:,4),G1H2(134),ngZu,m3h4x2(:,29),heltab2x8(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(134),47,0,G2H2(78),n2h2(88))
  call Hloop_AZ_Q(ntryL,G1H8(7),wf4(:,4),G1H2(146),ngZu,m3h4x2(:,30),heltab2x8(:,:,227))
  call Hloop_A_Q(ntryL,G1H2(146),47,0,G2H2(79),n2h2(89))
  call Hloop_AZ_Q(ntryL,G1H8(8),wf4(:,4),G1H2(151),ngZu,m3h4x2(:,31),heltab2x8(:,:,228))
  call Hloop_A_Q(ntryL,G1H2(151),47,0,G2H2(80),n2h2(90))
call HGT_raise_alpha_OLR(G1H8(15),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(15),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(15),ex5(:),G1H4(33),ngZu,m3h2x4(:,198),heltab2x8(:,:,229))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,4),G1H2(152),ngZu,m3h4x2(:,32),heltab2x8(:,:,230))
  call Hloop_A_Q(ntryL,G1H2(152),47,0,G2H2(81),n2h2(91))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,4),G1H2(164),ngZu,m3h4x2(:,33),heltab2x8(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(164),47,0,G2H2(82),n2h2(92))
  call Hloop_AZ_Q(ntryL,G1H8(11),wf4(:,4),G1H2(169),ngZd,m3h4x2(:,34),heltab2x8(:,:,232))
  call Hloop_A_Q(ntryL,G1H2(169),47,0,G2H2(83),n2h2(93))
call HGT_raise_alpha_OLR(G1H8(21),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(21),ex5(:),G1H4(34),m3h2x4(:,199),heltab2x8(:,:,233))
  call Hloop_AZ_Q(ntryL,G1H8(22),wf4(:,4),G1H2(170),ngZd,m3h4x2(:,35),heltab2x8(:,:,234))
  call Hloop_A_Q(ntryL,G1H2(170),47,0,G2H2(84),n2h2(94))
  call Hloop_AZ_Q(ntryL,G1H8(28),wf4(:,4),G1H2(182),ngZd,m3h4x2(:,36),heltab2x8(:,:,235))
  call Hloop_A_Q(ntryL,G1H2(182),47,0,G2H2(85),n2h2(95))
  call Hloop_AV_Q(ntryL,G1H8(29),wf4(:,2),G1H2(187),m3h4x2(:,37),heltab2x8(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(187),47,0,G2H2(86),n2h2(96))
call HGT_raise_alpha_OLR(G1H8(30),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(30),ex5(:),G1H4(39),m3h2x4(:,200),heltab2x8(:,:,237))
  call Hloop_AV_Q(ntryL,G1H8(34),wf4(:,2),G1H2(188),m3h4x2(:,38),heltab2x8(:,:,238))
  call Hloop_A_Q(ntryL,G1H2(188),47,0,G2H2(87),n2h2(97))
  call Hloop_AV_Q(ntryL,G1H8(47),wf4(:,2),G1H2(200),m3h4x2(:,39),heltab2x8(:,:,239))
  call Hloop_A_Q(ntryL,G1H2(200),47,0,G2H2(88),n2h2(98))
  call Hloop_AV_Q(ntryL,G1H8(49),wf4(:,2),G1H2(205),m3h4x2(:,40),heltab2x8(:,:,240))
  call Hloop_A_Q(ntryL,G1H2(205),47,0,G2H2(89),n2h2(99))
call HGT_raise_alpha_OLR(G1H8(63),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(63),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(63),ex5(:),G1H4(40),ngZu,m3h2x4(:,201),heltab2x8(:,:,241))
  call Hloop_AV_Q(ntryL,G1H8(10),wf4(:,2),G1H2(206),m3h4x2(:,41),heltab2x8(:,:,242))
  call Hloop_A_Q(ntryL,G1H2(206),47,0,G2H2(90),n2h2(100))
  call Hloop_AV_Q(ntryL,G1H8(13),wf4(:,2),G1H2(218),m3h4x2(:,42),heltab2x8(:,:,243))
  call Hloop_A_Q(ntryL,G1H2(218),47,0,G2H2(91),n2h2(101))
  call Hloop_AV_Q(ntryL,G1H8(48),wf4(:,2),G1H2(223),m3h4x2(:,43),heltab2x8(:,:,244))
  call Hloop_A_Q(ntryL,G1H2(223),47,0,G2H2(92),n2h2(102))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(50),ex5(:),G1H4(45),m3h2x4(:,202),heltab2x8(:,:,245))
  call Hloop_AV_Q(ntryL,G1H8(68),wf4(:,2),G1H2(224),m3h4x2(:,44),heltab2x8(:,:,246))
  call Hloop_A_Q(ntryL,G1H2(224),47,0,G2H2(93),n2h2(103))
  call Hloop_AV_Q(ntryL,G1H8(69),wf4(:,2),G1H2(236),m3h4x2(:,45),heltab2x8(:,:,247))
  call Hloop_A_Q(ntryL,G1H2(236),47,0,G2H2(94),n2h2(104))
  call Hloop_AZ_Q(ntryL,G1H8(70),wf4(:,3),G1H2(241),ngZu,m3h4x2(:,46),heltab2x8(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(241),47,0,G2H2(95),n2h2(105))
call HGT_raise_alpha_OLR(G1H8(71),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(71),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(71),ex5(:),G1H4(46),m3h2x4(:,203),heltab2x8(:,:,249))
  call Hloop_AZ_Q(ntryL,G1H8(73),wf4(:,3),G1H2(242),ngZu,m3h4x2(:,47),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G1H2(242),47,0,G2H2(96),n2h2(106))
  call Hloop_AZ_Q(ntryL,G1H8(74),wf4(:,3),G1H2(254),ngZu,m3h4x2(:,48),heltab2x8(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(254),47,0,G2H2(97),n2h2(107))
  call Hloop_AZ_Q(ntryL,G1H8(75),wf4(:,3),G1H2(259),ngZu,m3h4x2(:,49),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G1H2(259),47,0,G2H2(98),n2h2(108))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(76),ex5(:),G1H4(51),ngZu,m3h2x4(:,204),heltab2x8(:,:,253))
  call Hloop_AZ_Q(ntryL,G1H8(78),wf4(:,3),G1H2(260),ngZu,m3h4x2(:,50),heltab2x8(:,:,254))
  call Hloop_A_Q(ntryL,G1H2(260),47,0,G2H2(99),n2h2(109))
  call Hloop_AZ_Q(ntryL,G1H8(79),wf4(:,3),G1H2(272),ngZu,m3h4x2(:,51),heltab2x8(:,:,255))
  call Hloop_A_Q(ntryL,G1H2(272),47,0,G2H2(100),n2h2(110))
  call Hloop_AZ_Q(ntryL,G1H8(80),wf4(:,3),G1H2(277),ngZd,m3h4x2(:,52),heltab2x8(:,:,256))
  call Hloop_A_Q(ntryL,G1H2(277),47,0,G2H2(101),n2h2(111))
call HGT_raise_alpha_OLR(G1H8(81),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(81),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(81),ex5(:),G1H4(52),m3h2x4(:,205),heltab2x8(:,:,257))
  call Hloop_AZ_Q(ntryL,G1H8(83),wf4(:,3),G1H2(278),ngZd,m3h4x2(:,53),heltab2x8(:,:,258))
  call Hloop_A_Q(ntryL,G1H2(278),47,0,G2H2(102),n2h2(112))
  call Hloop_AZ_Q(ntryL,G1H8(84),wf4(:,3),G1H2(290),ngZd,m3h4x2(:,54),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(290),47,0,G2H2(103),n2h2(113))
  call Hloop_QZ_A(ntryL,G1H8(65),wf4(:,4),G1H2(295),ngZn,m3h4x2(:,55),heltab2x8(:,:,260))
  call Hloop_Q_A(ntryL,G1H2(295),55,0,G2H2(104),n2h2(114))
call HGT_raise_alpha_OLR(G1H8(66),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(66),ex4(:),G1H4(148),m3h2x4(:,206),heltab2x8(:,:,261))
  call Hloop_QZ_A(ntryL,G1H8(19),wf4(:,4),G1H2(296),ngZn,m3h4x2(:,56),heltab2x8(:,:,262))
  call Hloop_Q_A(ntryL,G1H2(296),55,0,G2H2(105),n2h2(115))
  call Hloop_QZ_A(ntryL,G1H8(85),wf4(:,4),G1H2(308),ngZn,m3h4x2(:,57),heltab2x8(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(308),55,0,G2H2(106),n2h2(116))
  call Hloop_QZ_A(ntryL,G1H8(23),wf4(:,3),G1H2(313),ngZn,m3h4x2(:,58),heltab2x8(:,:,264))
  call Hloop_Q_A(ntryL,G1H2(313),61,0,G2H2(107),n2h2(117))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(24),ex2(:),G1H4(135),m3h2x4(:,207),heltab2x8(:,:,265))
  call Hloop_QZ_A(ntryL,G1H8(26),wf4(:,3),G1H2(314),ngZn,m3h4x2(:,59),heltab2x8(:,:,266))
  call Hloop_Q_A(ntryL,G1H2(314),61,0,G2H2(108),n2h2(118))
  call Hloop_QZ_A(ntryL,G1H8(27),wf4(:,3),G1H2(326),ngZn,m3h4x2(:,60),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(326),61,0,G2H2(109),n2h2(119))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(86),[G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(98),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(269),[G1H2(135)])
call HGT_w2_OLR(G1H2(110),1,1,2)
call HGT_w2_invQ_OLR(G1H2(110),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(110),[G1H2(269)])
call HGT_w2_OLR(G1H2(122),1,1,2)
call HGT_w2_invQ_OLR(G1H2(122),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(122),[G1H2(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(174),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(284),G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(23),G1H2(158),G1H2(145),G0H2(5),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(143),[G1H2(123),G1H2(73),G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(300),[G1H2(68),G1H2(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(21),G1H2(194),G1H2(181),G0H2(2),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(142),[G1H2(130),G1H2(289),G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(229),[G1H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(246),[G1H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(228),[G1H2(216),G1H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(136),[G1H2(47),G1H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(265),[G1H2(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(304),[G1H2(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(124),G1H2(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(240),[G1H2(234),G1H2(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(337),[G1H2(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(322),[G1H2(75),G1H2(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(355),[G1H2(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(320)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(310),G1H2(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(222),[G1H2(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(162),[G1H2(83),G1H2(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(118),[G1H2(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(156),G1H2(361)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(98),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(104),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(110),[G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(93),[G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(391),[G1H2(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(288),[G1H2(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(137),[G1H2(119),G1H2(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(282),[G1H2(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(131),G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(141),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(276),[G1H2(258),G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(294),[G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(270),[G1H2(264),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(186),[G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(358),[G1H2(159),G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(192),[G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(179),[G1H2(352),G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(346),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(370),[G1H2(167),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(185),[G1H2(171),G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(281),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(53),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(279),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(107),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(285),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(293),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(120),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(298),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(88),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(249),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(251),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(117),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(261),[G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(31),G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(196),[G1H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(232),[G1H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(209),[G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(252),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(275),[G1H2(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(309),[G1H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(273),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(306),[G1H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(33),G1H2(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G2H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G2H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(103),[G2H2(94)])
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(439))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(260),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(53),ex4(:),G2tensor(263),ngZl,m3h2x1(:,409),heltab2x2(:,:,409))
call HGT_w2_OLR(G1H2(38),1,1,2)
call HGT_w2_invQ_OLR(G1H2(38),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),ngZl,m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(266),n2h1(440))
call HGT_w2_OLR(G1H2(50),1,1,2)
call HGT_w2_invQ_OLR(G1H2(50),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(269),n2h1(441))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(56),ex4(:),G2tensor(272),m3h2x1(:,412),heltab2x2(:,:,412))
call HGT_w2_OLR(G1H2(86),1,1,2)
call HGT_w2_invQ_OLR(G1H2(86),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(290),n2h1(442))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(62),ex3(:),G2tensor(293),m3h2x1(:,414),heltab2x2(:,:,414))
call HGT_w2_OLR(G1H2(98),1,1,2)
call HGT_w2_invQ_OLR(G1H2(98),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(98),ex4(:),G1H1(1),ngZl,m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(296),n2h1(443))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(68),ex3(:),G2tensor(299),ngZl,m3h2x1(:,416),heltab2x2(:,:,416))
  call Hloop_WA_Q(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(444))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(71),ex3(:),G2tensor(4),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hloop_WQ_A(ntryL,G1H2(122),ex3(:),G1H1(1),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(445))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(74),ex4(:),G2tensor(8),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hloop_WQ_A(ntryL,G1H2(174),ex5(:),G1H1(1),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(446))
  call Hloop_WQ_A(ntryL,G1H2(150),ex5(:),G1H1(1),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(447))
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(22),mass4set(:,6),  & 
G1H2(331),G1H2(332),G1H2(344),G1H2(349),G1H2(350),2)
  call HG1shiftOLR(G1H2(332),16,2)
  call Hloop_WQ_A(ntryL,G1H2(157),ex5(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(448))
  call Hloop_WQ_A(ntryL,G1H2(143),ex5(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(16),n2h1(449))
  call Hloop_WQ_A(ntryL,G1H2(189),ex5(:),G1H1(1),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(18),n2h1(450))
  call Hloop_WQ_A(ntryL,G1H2(300),ex5(:),G1H1(1),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(20),n2h1(451))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(7),mass4set(:,6),  & 
G1H2(362),G1H2(367),G1H2(368),G1H2(380),G1H2(385),2)
  call HG1shiftOLR(G1H2(367),16,2)
  call Hloop_WQ_A(ntryL,G1H2(193),ex5(:),G1H1(1),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(452))
  call Hloop_WQ_A(ntryL,G1H2(142),ex5(:),G1H1(1),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(453))
  call Hloop_VQ_A(ntryL,G1H2(229),ex5(:),G1H1(1),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(26),n2h1(454))
  call Hloop_VQ_A(ntryL,G1H2(246),ex5(:),G1H1(1),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(28),n2h1(455))
  call Hloop_VQ_A(ntryL,G1H2(228),ex5(:),G1H1(1),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(456))
  call Hloop_VQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(457))
  call Hloop_VQ_A(ntryL,G1H2(136),ex5(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(458))
  call Hloop_ZQ_A(ntryL,G1H2(265),ex5(:),G1H1(1),ngZu,m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(459))
  call Hloop_ZQ_A(ntryL,G1H2(304),ex5(:),G1H1(1),ngZu,m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(460))
  call Hloop_ZQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),ngZu,m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(461))
  call Hloop_ZQ_A(ntryL,G1H2(71),ex5(:),G1H1(1),ngZu,m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(462))
  call Hloop_ZQ_A(ntryL,G1H2(240),ex5(:),G1H1(1),ngZu,m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(44),n2h1(463))
  call Hloop_WQ_A(ntryL,G1H2(283),ex5(:),G1H1(1),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(46),n2h1(464))
  call Hloop_VQ_A(ntryL,G1H2(337),ex5(:),G1H1(1),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(465))
  call Hloop_VQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(50),n2h1(466))
  call Hloop_VQ_A(ntryL,G1H2(322),ex5(:),G1H1(1),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(467))
  call Hloop_ZQ_A(ntryL,G1H2(355),ex5(:),G1H1(1),ngZu,m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(468))
  call Hloop_ZQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),ngZu,m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(56),n2h1(469))
  call Hloop_ZQ_A(ntryL,G1H2(89),ex5(:),G1H1(1),ngZu,m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(470))
  call Hloop_VQ_A(ntryL,G1H2(222),ex5(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(471))
  call Hloop_VQ_A(ntryL,G1H2(162),ex5(:),G1H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(62),n2h1(472))
  call Hloop_ZQ_A(ntryL,G1H2(118),ex5(:),G1H1(1),ngZu,m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(473))
  call Hloop_ZQ_A(ntryL,G1H2(87),ex5(:),G1H1(1),ngZu,m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(217),n2h1(474))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,2),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(475))
  call Hloop_QV_A(ntryL,G1H4(86),wf4(:,2),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(476))
  call Hloop_QV_A(ntryL,G1H4(25),wf4(:,2),G1H1(1),m3h4x1(:,57),heltab2x4(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(477))
  call Hloop_QV_A(ntryL,G1H4(98),wf4(:,2),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(74),n2h1(478))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,2),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(479))
  call Hloop_QV_A(ntryL,G1H4(31),wf4(:,2),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(480))
  call Hloop_QV_A(ntryL,G1H4(92),wf4(:,2),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(80),n2h1(481))
  call Hloop_QV_A(ntryL,G1H4(104),wf4(:,2),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(82),n2h1(482))
  call Hloop_QV_A(ntryL,G1H4(41),wf4(:,2),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(483))
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(110),mass4set(:,7),  & 
G1H4(62),G1H4(65),G1H4(44),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(65),12,4)
  call Hloop_QV_A(ntryL,G1H4(43),wf4(:,2),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(86),n2h1(484))
  call Hloop_QZ_A(ntryL,G1H4(59),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,65),heltab2x4(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(88),n2h1(485))
  call Hloop_QZ_A(ntryL,G1H4(110),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,66),heltab2x4(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(486))
  call Hloop_QZ_A(ntryL,G1H4(69),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,67),heltab2x4(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(92),n2h1(487))
  call Hloop_QZ_A(ntryL,G1H4(122),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,68),heltab2x4(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(94),n2h1(488))
  call Hloop_QZ_A(ntryL,G1H4(75),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,69),heltab2x4(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(489))
  call Hloop_QZ_A(ntryL,G1H4(73),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,70),heltab2x4(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(98),n2h1(490))
  call Hloop_QZ_A(ntryL,G1H4(116),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,71),heltab2x4(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(100),n2h1(491))
  call Hloop_QZ_A(ntryL,G1H4(128),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,72),heltab2x4(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(492))
  call Hloop_QZ_A(ntryL,G1H4(79),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,73),heltab2x4(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(104),n2h1(493))
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(110),mass4set(:,7),  & 
G1H4(54),G1H4(70),G1H4(71),G1H4(72),G1H4(76),4)
  call HG1shiftOLR(G1H4(70),12,4)
  call Hloop_QZ_A(ntryL,G1H4(81),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,74),heltab2x4(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(494))
  call Hloop_QV_A(ntryL,G1H4(97),wf4(:,2),G1H1(1),m3h4x1(:,75),heltab2x4(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(108),n2h1(495))
  call Hloop_QV_A(ntryL,G1H4(93),wf4(:,2),G1H1(1),m3h4x1(:,76),heltab2x4(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(110),n2h1(496))
  call Hloop_QV_A(ntryL,G1H4(103),wf4(:,2),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(112),n2h1(497))
  call Hloop_QV_A(ntryL,G1H4(105),wf4(:,2),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(498))
  call Hloop_QZ_A(ntryL,G1H4(121),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,79),heltab2x4(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(116),n2h1(499))
  call Hloop_QZ_A(ntryL,G1H4(117),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,80),heltab2x4(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(500))
  call Hloop_QZ_A(ntryL,G1H4(127),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,81),heltab2x4(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(501))
  call Hloop_QZ_A(ntryL,G1H4(129),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,82),heltab2x4(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(122),n2h1(502))
  call Hloop_VQ_A(ntryL,G1H2(391),ex5(:),G1H1(1),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(124),n2h1(503))
  call Hloop_VQ_A(ntryL,G1H2(288),ex5(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(504))
  call Hloop_VQ_A(ntryL,G1H2(137),ex5(:),G1H1(1),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(128),n2h1(505))
  call Hloop_VQ_A(ntryL,G1H2(282),ex5(:),G1H1(1),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(130),n2h1(506))
  call Hloop_VQ_A(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(507))
  call Hloop_ZQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),ngZu,m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(508))
  call Hloop_ZQ_A(ntryL,G1H2(141),ex5(:),G1H1(1),ngZu,m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(509))
  call Hloop_ZQ_A(ntryL,G1H2(276),ex5(:),G1H1(1),ngZu,m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(510))
  call Hloop_ZQ_A(ntryL,G1H2(294),ex5(:),G1H1(1),ngZu,m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(511))
  call Hloop_ZQ_A(ntryL,G1H2(270),ex5(:),G1H1(1),ngZu,m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(512))
  call Hloop_WQ_A(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(513))
  call Hloop_VQ_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(514))
  call Hloop_VQ_A(ntryL,G1H2(186),ex5(:),G1H1(1),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(515))
  call Hloop_VQ_A(ntryL,G1H2(358),ex5(:),G1H1(1),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(516))
  call Hloop_ZQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),ngZu,m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(517))
  call Hloop_ZQ_A(ntryL,G1H2(192),ex5(:),G1H1(1),ngZu,m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(518))
  call Hloop_ZQ_A(ntryL,G1H2(179),ex5(:),G1H1(1),ngZu,m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(519))
  call Hloop_VQ_A(ntryL,G1H2(346),ex5(:),G1H1(1),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(520))
  call Hloop_VQ_A(ntryL,G1H2(370),ex5(:),G1H1(1),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(521))
  call Hloop_ZQ_A(ntryL,G1H2(105),ex5(:),G1H1(1),ngZu,m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(522))
  call Hloop_ZQ_A(ntryL,G1H2(185),ex5(:),G1H1(1),ngZu,m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(523))
  call Hloop_VA_Q(ntryL,G1H2(281),ex4(:),G1H1(1),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(524))
  call Hloop_VA_Q(ntryL,G1H2(53),ex4(:),G1H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(525))
  call Hloop_VA_Q(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(526))
  call Hloop_ZA_Q(ntryL,G1H2(279),ex4(:),G1H1(1),ngZl,m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(527))
  call Hloop_ZA_Q(ntryL,G1H2(64),ex4(:),G1H1(1),ngZl,m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(528))
  call Hloop_ZA_Q(ntryL,G1H2(107),ex4(:),G1H1(1),ngZl,m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(529))
  call Hloop_VA_Q(ntryL,G1H2(285),ex4(:),G1H1(1),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(530))
  call Hloop_VA_Q(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(531))
  call Hloop_ZA_Q(ntryL,G1H2(293),ex4(:),G1H1(1),ngZl,m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(532))
  call Hloop_ZA_Q(ntryL,G1H2(120),ex4(:),G1H1(1),ngZl,m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(533))
  call Hloop_VA_Q(ntryL,G1H2(298),ex4(:),G1H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(534))
  call Hloop_VA_Q(ntryL,G1H2(88),ex4(:),G1H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(535))
  call Hloop_VA_Q(ntryL,G1H2(249),ex4(:),G1H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(536))
  call Hloop_ZA_Q(ntryL,G1H2(251),ex4(:),G1H1(1),ngZl,m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(537))
  call Hloop_ZA_Q(ntryL,G1H2(117),ex4(:),G1H1(1),ngZl,m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(538))
  call Hloop_ZA_Q(ntryL,G1H2(261),ex4(:),G1H1(1),ngZl,m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(539))
  call Hloop_WA_Q(ntryL,G1H2(138),ex4(:),G1H1(1),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(540))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(136),mass4set(:,8),  & 
G1H2(386),G1H2(7),G1H2(8),G1H2(13),G1H2(31),2)
  call HG1shiftOLR(G1H2(7),8,2)
  call Hloop_VA_Q(ntryL,G1H2(153),ex2(:),G1H1(1),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(541))
  call Hloop_VA_Q(ntryL,G1H2(196),ex2(:),G1H1(1),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(542))
  call Hloop_VA_Q(ntryL,G1H2(232),ex2(:),G1H1(1),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(543))
  call Hloop_ZA_Q(ntryL,G1H2(166),ex2(:),G1H1(1),ngZl,m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(544))
  call Hloop_ZA_Q(ntryL,G1H2(209),ex2(:),G1H1(1),ngZl,m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(545))
  call Hloop_ZA_Q(ntryL,G1H2(252),ex2(:),G1H1(1),ngZl,m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(546))
  call Hloop_VA_Q(ntryL,G1H2(190),ex2(:),G1H1(1),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(547))
  call Hloop_VA_Q(ntryL,G1H2(275),ex2(:),G1H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(548))
  call Hloop_ZA_Q(ntryL,G1H2(208),ex2(:),G1H1(1),ngZl,m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(549))
  call Hloop_ZA_Q(ntryL,G1H2(309),ex2(:),G1H1(1),ngZl,m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(550))
  call Hloop_VA_Q(ntryL,G1H2(221),ex2(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(551))
  call Hloop_VA_Q(ntryL,G1H2(273),ex2(:),G1H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(552))
  call Hloop_ZA_Q(ntryL,G1H2(244),ex2(:),G1H1(1),ngZl,m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(553))
  call Hloop_ZA_Q(ntryL,G1H2(306),ex2(:),G1H1(1),ngZl,m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(554))
  call Hloop_VA_Q(ntryL,G1H2(267),ex2(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(555))
  call Hloop_ZA_Q(ntryL,G1H2(305),ex2(:),G1H1(1),ngZl,m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(556))
  call Hloop_WA_Q(ntryL,G1H2(318),ex2(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(557))
  call Hloop_WA_Q(ntryL,G1H2(323),ex2(:),G1H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(558))
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(143),mass4set(:,8),  & 
G1H2(32),G1H2(37),G1H2(55),G1H2(56),G1H2(61),2)
  call HG1shiftOLR(G1H2(37),2,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(103),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(105),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(107),ngZl,m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(15),ex4(:),G2tensor(109),ngZl,m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(111),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(113),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(115),ngZl,m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(117),ngZl,m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(119),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(121),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(123),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(125),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(127),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(129),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(131),ngZl,m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(133),ngZl,m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(134),ngZl,m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(135),ngZl,m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(136),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(137),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hloop_ZQ_A(ntryL,G0H2(3),ex5(:),G0H1(1),ngZu,m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(1),n2h1(559))
  call Hloop_ZQ_A(ntryL,G0H2(6),ex5(:),G0H1(1),ngZu,m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(37),n2h1(560))
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(110),mass4set(:,9),  & 
G1H4(77),G1H4(78),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(78),12,4)
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(110),mass4set(:,9),  & 
G1H4(88),G1H4(89),G1H4(90),G1H4(94),G1H4(95),4)
  call HG1shiftOLR(G1H4(89),12,4)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(88),mass4set(:,2),  & 
G1H2(79),G1H2(80),G1H2(85),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(80),8,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(88),mass4set(:,10),  & 
G1H2(109),G1H2(127),G1H2(128),G1H2(3),G1H2(10),2)
  call HG1shiftOLR(G1H2(127),8,2)
  call Hotf_4pt_reduction(G2H2(27),RedSet_4(88),mass4set(:,11),  & 
G1H2(11),G1H2(12),G1H2(18),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(12),8,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(27),ex4(:),G1tensor(73),ngZl,m3h2x1(:,528),heltab2x2(:,:,528))
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(95),mass4set(:,2),  & 
G1H2(30),G1H2(34),G1H2(36),G1H2(46),G1H2(48),2)
  call HG1shiftOLR(G1H2(34),4,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(95),mass4set(:,10),  & 
G1H2(51),G1H2(57),G1H2(58),G1H2(59),G1H2(66),2)
  call HG1shiftOLR(G1H2(57),4,2)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(95),mass4set(:,11),  & 
G1H2(69),G1H2(70),G1H2(78),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(70),4,2)
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H2(112),ex3(:),G1tensor(109),ngZl,m3h2x1(:,529),heltab2x2(:,:,529))
  call Hloop_VQ_A(ntryL,G1H8(32),wf8(:,3),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(561))
  call Hloop_ZQ_A(ntryL,G1H8(33),wf8(:,3),G1H1(1),ngZu,m3h8x1(:,2),heltab2x8(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(562))
  call Hloop_VQ_A(ntryL,G1H8(86),wf8(:,3),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(140),n2h1(563))
  call Hloop_ZQ_A(ntryL,G1H8(87),wf8(:,3),G1H1(1),ngZu,m3h8x1(:,4),heltab2x8(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(564))
  call Hloop_VQ_A(ntryL,G1H8(88),wf8(:,6),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,272))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(565))
  call Hloop_ZQ_A(ntryL,G1H8(89),wf8(:,6),G1H1(1),ngZu,m3h8x1(:,6),heltab2x8(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(566))
  call Hloop_VQ_A(ntryL,G1H8(90),wf8(:,6),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(567))
  call Hloop_ZQ_A(ntryL,G1H8(91),wf8(:,6),G1H1(1),ngZu,m3h8x1(:,8),heltab2x8(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(568))
  call Hloop_VQ_A(ntryL,G1H8(92),wf8(:,3),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(146),n2h1(569))
  call Hloop_VQ_A(ntryL,G1H8(93),wf8(:,3),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(570))
  call Hloop_ZQ_A(ntryL,G1H8(94),wf8(:,3),G1H1(1),ngZu,m3h8x1(:,11),heltab2x8(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(221),n2h1(571))
  call Hloop_ZQ_A(ntryL,G1H8(95),wf8(:,3),G1H1(1),ngZu,m3h8x1(:,12),heltab2x8(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(148),n2h1(572))
  call Hloop_WQ_A(ntryL,G1H8(96),wf8(:,3),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(224),n2h1(573))
  call Hloop_VQ_A(ntryL,G1H8(97),wf8(:,6),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(149),n2h1(574))
  call Hloop_VQ_A(ntryL,G1H8(98),wf8(:,6),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(575))
  call Hloop_ZQ_A(ntryL,G1H8(99),wf8(:,6),G1H1(1),ngZu,m3h8x1(:,16),heltab2x8(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(151),n2h1(576))
  call Hloop_ZQ_A(ntryL,G1H8(100),wf8(:,6),G1H1(1),ngZu,m3h8x1(:,17),heltab2x8(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(577))
  call Hloop_WQ_A(ntryL,G1H8(101),wf8(:,6),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(578))
  call Hloop_VQ_A(ntryL,G1H2(316),ex5(:),G1H1(1),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(154),n2h1(579))
  call Hloop_VQ_A(ntryL,G1H2(168),ex5(:),G1H1(1),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(155),n2h1(580))
  call Hloop_ZQ_A(ntryL,G1H2(334),ex5(:),G1H1(1),ngZu,m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(581))
  call Hloop_ZQ_A(ntryL,G1H2(95),ex5(:),G1H1(1),ngZu,m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(157),n2h1(582))
  call Hloop_VQ_A(ntryL,G1H2(93),ex5(:),G1H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(583))
  call Hloop_ZQ_A(ntryL,G1H2(328),ex5(:),G1H1(1),ngZu,m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(584))
  call Hloop_VQ_A(ntryL,G1H2(180),ex5(:),G1H1(1),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(160),n2h1(585))
  call Hloop_ZQ_A(ntryL,G1H2(340),ex5(:),G1H1(1),ngZu,m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(161),n2h1(586))
  call Hotf_4pt_reduction(G2H4(28),RedSet_4(90),mass4set(:,2),  & 
G1H4(66),G1H4(96),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(96),12,4)
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(90),mass4set(:,12),  & 
G1H4(119),G1H4(120),G1H4(3),G1H4(4),G1H4(9),4)
  call HG1shiftOLR(G1H4(120),12,4)
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(90),mass4set(:,2),  & 
G1H4(106),G1H4(107),G1H4(108),G1H4(112),G1H4(124),4)
  call HG1shiftOLR(G1H4(107),12,4)
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(90),mass4set(:,12),  & 
G1H4(125),G1H4(126),G1H4(130),G1H4(1),G1H4(2),4)
  call HG1shiftOLR(G1H4(126),12,4)
  call Hotf_4pt_reduction(G2H4(36),RedSet_4(90),mass4set(:,13),  & 
G1H4(8),G1H4(11),G1H4(12),G1H4(18),G1H4(19),4)
  call HG1shiftOLR(G1H4(11),12,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(113),wf4(:,2),G1tensor(145),m3h4x1(:,83),heltab2x4(:,:,337))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(114),wf4(:,3),G1tensor(181),m3h4x1(:,84),heltab2x4(:,:,338))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(118),wf4(:,3),G1tensor(217),m3h4x1(:,85),heltab2x4(:,:,339))
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(90),mass4set(:,14),  & 
G1H4(20),G1H4(26),G1H4(29),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(26),12,4)
  call Hotf_4pt_reduction(G2H4(42),RedSet_4(90),mass4set(:,14),  & 
G1H4(133),G1H4(134),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),12,4)
  call Hotf_4pt_reduction(G2H4(43),RedSet_4(104),mass4set(:,2),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),4)
  call HG1shiftOLR(G1H4(140),12,4)
  call Hotf_4pt_reduction(G2H4(44),RedSet_4(104),mass4set(:,12),  & 
G1H4(144),G1H4(145),G1H4(146),G1H4(147),G1H4(149),4)
  call HG1shiftOLR(G1H4(145),12,4)
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(104),mass4set(:,2),  & 
G1H4(150),G1H4(151),G1H4(152),G1H4(153),G1H4(154),4)
  call HG1shiftOLR(G1H4(151),12,4)
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(104),mass4set(:,12),  & 
G1H4(155),G1H4(156),G1H4(157),G1H4(158),G1H4(159),4)
  call HG1shiftOLR(G1H4(156),12,4)
  call Hotf_4pt_reduction(G2H4(47),RedSet_4(104),mass4set(:,13),  & 
G1H4(160),G1H4(161),G1H4(162),G1H4(163),G1H4(164),4)
  call HG1shiftOLR(G1H4(161),12,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(10),wf4(:,2),G1tensor(253),m3h4x1(:,86),heltab2x4(:,:,340))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(15),wf4(:,3),G1tensor(289),m3h4x1(:,87),heltab2x4(:,:,341))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(16),wf4(:,3),G1tensor(325),m3h4x1(:,88),heltab2x4(:,:,342))
  call Hotf_4pt_reduction(G2H4(48),RedSet_4(104),mass4set(:,14),  & 
G1H4(165),G1H4(166),G1H4(57),G1H4(58),G1H4(64),4)
  call HG1shiftOLR(G1H4(166),12,4)
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(104),mass4set(:,14),  & 
G1H4(30),G1H4(36),G1H4(37),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(36),12,4)
  call Hloop_VQ_A(ntryL,G1H8(35),wf8(:,9),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(587))
  call Hloop_ZQ_A(ntryL,G1H8(36),wf8(:,9),G1H1(1),ngZu,m3h8x1(:,20),heltab2x8(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(163),n2h1(588))
  call Hloop_VQ_A(ntryL,G1H8(37),wf8(:,9),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(164),n2h1(589))
  call Hloop_ZQ_A(ntryL,G1H8(40),wf8(:,9),G1H1(1),ngZu,m3h8x1(:,22),heltab2x8(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(590))
  call Hloop_VQ_A(ntryL,G1H8(41),wf8(:,11),G1H1(1),m3h8x1(:,23),heltab2x8(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(227),n2h1(591))
  call Hloop_ZQ_A(ntryL,G1H8(42),wf8(:,11),G1H1(1),ngZu,m3h8x1(:,24),heltab2x8(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(166),n2h1(592))
  call Hloop_VQ_A(ntryL,G1H8(43),wf8(:,11),G1H1(1),m3h8x1(:,25),heltab2x8(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(230),n2h1(593))
  call Hloop_ZQ_A(ntryL,G1H8(44),wf8(:,11),G1H1(1),ngZu,m3h8x1(:,26),heltab2x8(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(167),n2h1(594))
  call Hloop_VQ_A(ntryL,G1H8(45),wf8(:,9),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(168),n2h1(595))
  call Hloop_VQ_A(ntryL,G1H8(46),wf8(:,9),G1H1(1),m3h8x1(:,28),heltab2x8(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(169),n2h1(596))
  call Hloop_ZQ_A(ntryL,G1H8(51),wf8(:,9),G1H1(1),ngZu,m3h8x1(:,29),heltab2x8(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(170),n2h1(597))
  call Hloop_ZQ_A(ntryL,G1H8(55),wf8(:,9),G1H1(1),ngZu,m3h8x1(:,30),heltab2x8(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(171),n2h1(598))
  call Hloop_WQ_A(ntryL,G1H8(56),wf8(:,9),G1H1(1),m3h8x1(:,31),heltab2x8(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(172),n2h1(599))
  call Hloop_VQ_A(ntryL,G1H8(102),wf8(:,11),G1H1(1),m3h8x1(:,32),heltab2x8(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(173),n2h1(600))
  call Hloop_VQ_A(ntryL,G1H8(103),wf8(:,11),G1H1(1),m3h8x1(:,33),heltab2x8(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(174),n2h1(601))
  call Hloop_ZQ_A(ntryL,G1H8(104),wf8(:,11),G1H1(1),ngZu,m3h8x1(:,34),heltab2x8(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(602))
  call Hloop_ZQ_A(ntryL,G1H8(105),wf8(:,11),G1H1(1),ngZu,m3h8x1(:,35),heltab2x8(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(176),n2h1(603))
  call Hloop_WQ_A(ntryL,G1H8(106),wf8(:,11),G1H1(1),m3h8x1(:,36),heltab2x8(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(604))
  call Hloop_VQ_A(ntryL,G1H2(183),ex5(:),G1H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(178),n2h1(605))
  call Hloop_VQ_A(ntryL,G1H2(364),ex5(:),G1H1(1),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(179),n2h1(606))
  call Hloop_ZQ_A(ntryL,G1H2(382),ex5(:),G1H1(1),ngZu,m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(180),n2h1(607))
  call Hloop_ZQ_A(ntryL,G1H2(191),ex5(:),G1H1(1),ngZu,m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(181),n2h1(608))
  call Hloop_VQ_A(ntryL,G1H2(376),ex5(:),G1H1(1),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(182),n2h1(609))
  call Hloop_ZQ_A(ntryL,G1H2(388),ex5(:),G1H1(1),ngZu,m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(610))
  call Hloop_VQ_A(ntryL,G1H2(394),ex5(:),G1H1(1),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(184),n2h1(611))
  call Hloop_ZQ_A(ntryL,G1H2(195),ex5(:),G1H1(1),ngZu,m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(185),n2h1(612))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(186),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(187),ngZl,m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(188),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(189),ngZl,m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(39),ex3(:),G2tensor(190),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(40),ex3(:),G2tensor(191),ngZl,m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(41),ex3(:),G2tensor(192),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(42),ex3(:),G2tensor(193),ngZl,m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(194),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(45),ex4(:),G2tensor(195),ngZl,m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(46),ex4(:),G2tensor(196),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(197),ngZl,m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(49),ex3(:),G2tensor(198),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(51),ex3(:),G2tensor(199),ngZl,m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(52),ex3(:),G2tensor(201),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(54),ex3(:),G2tensor(203),ngZl,m3h2x1(:,561),heltab2x2(:,:,561))
  call Hloop_VQ_A(ntryL,G1H2(299),ex3(:),G1H1(1),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(205),n2h1(613))
  call Hloop_VQ_A(ntryL,G1H2(297),ex3(:),G1H1(1),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(207),n2h1(614))
  call Hloop_ZQ_A(ntryL,G1H2(321),ex3(:),G1H1(1),ngZl,m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(209),n2h1(615))
  call Hloop_ZQ_A(ntryL,G1H2(317),ex3(:),G1H1(1),ngZl,m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(211),n2h1(616))
  call Hloop_VQ_A(ntryL,G1H2(354),ex3(:),G1H1(1),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(213),n2h1(617))
  call Hloop_ZQ_A(ntryL,G1H2(333),ex3(:),G1H1(1),ngZl,m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(215),n2h1(618))
  call Hloop_VQ_A(ntryL,G1H2(329),ex3(:),G1H1(1),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(219),n2h1(619))
  call Hloop_ZQ_A(ntryL,G1H2(360),ex3(:),G1H1(1),ngZl,m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(233),n2h1(620))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(55),ex3(:),G2tensor(236),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(58),ex3(:),G2tensor(239),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(242),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(63),ex4(:),G2tensor(245),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(77),ex5(:),G2tensor(248),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(79),ex5(:),G2tensor(251),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(80),ex5(:),G2tensor(254),ngZu,m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(82),ex5(:),G2tensor(257),ngZu,m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(83),ex5(:),G2tensor(275),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(85),ex5(:),G2tensor(278),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(95),ex5(:),G2tensor(281),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(97),ex5(:),G2tensor(284),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(98),ex5(:),G2tensor(287),ngZu,m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(100),ex5(:),G2tensor(302),ngZu,m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(101),ex5(:),G2tensor(305),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(103),ex5(:),G2tensor(308),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(104),ex4(:),G2tensor(311),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(106),ex4(:),G2tensor(314),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(107),ex2(:),G2tensor(317),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(109),ex2(:),G2tensor(320),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hloop_WQ_A(ntryL,G1H2(331),ex5(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(323),n2h1(621))
  call Hloop_WQ_A(ntryL,G1H2(332),ex5(:),G1H1(1),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(326),n2h1(622))
  call Hloop_WQ_A(ntryL,G1H2(350),ex5(:),G1H1(1),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(329),n2h1(623))
  call Hloop_WQ_A(ntryL,G1H2(362),ex5(:),G1H1(1),m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(332),n2h1(624))
  call Hloop_WQ_A(ntryL,G1H2(367),ex5(:),G1H1(1),m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(335),n2h1(625))
  call Hloop_WQ_A(ntryL,G1H2(385),ex5(:),G1H1(1),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(338),n2h1(626))
  call Hloop_QV_A(ntryL,G1H4(62),wf4(:,2),G1H1(1),m3h4x1(:,89),heltab2x4(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(341),n2h1(627))
  call Hloop_QV_A(ntryL,G1H4(65),wf4(:,2),G1H1(1),m3h4x1(:,90),heltab2x4(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(344),n2h1(628))
  call Hloop_QV_A(ntryL,G1H4(48),wf4(:,2),G1H1(1),m3h4x1(:,91),heltab2x4(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(347),n2h1(629))
  call Hloop_QZ_A(ntryL,G1H4(54),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,92),heltab2x4(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(350),n2h1(630))
  call Hloop_QZ_A(ntryL,G1H4(70),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,93),heltab2x4(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(353),n2h1(631))
  call Hloop_QZ_A(ntryL,G1H4(76),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,94),heltab2x4(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(356),n2h1(632))
  call Hloop_WA_Q(ntryL,G1H2(386),ex4(:),G1H1(1),m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(359),n2h1(633))
  call Hloop_WA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(362),n2h1(634))
  call Hloop_WA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(365),n2h1(635))
  call Hloop_WA_Q(ntryL,G1H2(32),ex2(:),G1H1(1),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(368),n2h1(636))
  call Hloop_WA_Q(ntryL,G1H2(37),ex2(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(371),n2h1(637))
  call Hloop_WA_Q(ntryL,G1H2(61),ex2(:),G1H1(1),m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(374),n2h1(638))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(77),51,wf4(:,2),12,G2tensor(377),m3h4x1(:,95),heltab2x4(:,:,349))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(78),0,wf4(:,2),12,G2tensor(380),m3h4x1(:,96),heltab2x4(:,:,350))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(84),51,wf4(:,2),12,G2tensor(383),m3h4x1(:,97),heltab2x4(:,:,351))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(88),51,wf4(:,3),12,G2tensor(386),m3h4x1(:,98),heltab2x4(:,:,352))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(89),0,wf4(:,3),12,G2tensor(389),m3h4x1(:,99),heltab2x4(:,:,353))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(95),51,wf4(:,3),12,G2tensor(392),m3h4x1(:,100),heltab2x4(:,:,354))
  call Hloop_VA_Q(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(395),n2h1(641))
  call Hloop_VA_Q(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(396),n2h1(642))
  call Hloop_VA_Q(ntryL,G1H2(104),ex4(:),G1H1(1),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(397),n2h1(643))
  call Hloop_ZA_Q(ntryL,G1H2(109),ex4(:),G1H1(1),ngZl,m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(398),n2h1(644))
  call Hloop_ZA_Q(ntryL,G1H2(127),ex4(:),G1H1(1),ngZl,m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(399),n2h1(645))
  call Hloop_ZA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),ngZl,m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(400),n2h1(646))
  call Hloop_WA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(401),n2h1(647))
  call Hloop_WA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(402),n2h1(648))
  call Hloop_WA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(403),n2h1(649))
  call Hloop_VQ_A(ntryL,G1H2(30),ex3(:),G1H1(1),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(404),n2h1(650))
  call Hloop_VQ_A(ntryL,G1H2(34),ex3(:),G1H1(1),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(405),n2h1(651))
  call Hloop_VQ_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(406),n2h1(652))
  call Hloop_ZQ_A(ntryL,G1H2(51),ex3(:),G1H1(1),ngZl,m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(407),n2h1(653))
  call Hloop_ZQ_A(ntryL,G1H2(57),ex3(:),G1H1(1),ngZl,m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(408),n2h1(654))
  call Hloop_ZQ_A(ntryL,G1H2(66),ex3(:),G1H1(1),ngZl,m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(409),n2h1(655))
  call Hloop_WQ_A(ntryL,G1H2(69),ex3(:),G1H1(1),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(410),n2h1(656))
  call Hloop_WQ_A(ntryL,G1H2(70),ex3(:),G1H1(1),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(411),n2h1(657))
  call Hloop_WQ_A(ntryL,G1H2(82),ex3(:),G1H1(1),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(412),n2h1(658))
  call Hloop_QV_A(ntryL,G1H4(66),wf4(:,2),G1H1(1),m3h4x1(:,101),heltab2x4(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(413),n2h1(659))
  call Hloop_QV_A(ntryL,G1H4(96),wf4(:,2),G1H1(1),m3h4x1(:,102),heltab2x4(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(414),n2h1(660))
  call Hloop_QV_A(ntryL,G1H4(102),wf4(:,2),G1H1(1),m3h4x1(:,103),heltab2x4(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(415),n2h1(661))
  call Hloop_QV_A(ntryL,G1H4(119),wf4(:,2),G1H1(1),m3h4x1(:,104),heltab2x4(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(416),n2h1(662))
  call Hloop_QV_A(ntryL,G1H4(120),wf4(:,2),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(417),n2h1(663))
  call Hloop_QV_A(ntryL,G1H4(9),wf4(:,2),G1H1(1),m3h4x1(:,106),heltab2x4(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(418),n2h1(664))
  call Hloop_QZ_A(ntryL,G1H4(106),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,107),heltab2x4(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(419),n2h1(665))
  call Hloop_QZ_A(ntryL,G1H4(107),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,108),heltab2x4(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(420),n2h1(666))
  call Hloop_QZ_A(ntryL,G1H4(124),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,109),heltab2x4(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(421),n2h1(667))
  call Hloop_QZ_A(ntryL,G1H4(125),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,110),heltab2x4(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(422),n2h1(668))
  call Hloop_QZ_A(ntryL,G1H4(126),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,111),heltab2x4(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(423),n2h1(669))
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,112),heltab2x4(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(424),n2h1(670))
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,3),G1H1(1),ngZn,m3h4x1(:,113),heltab2x4(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(425),n2h1(671))
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,3),G1H1(1),ngZn,m3h4x1(:,114),heltab2x4(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(426),n2h1(672))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,3),G1H1(1),ngZn,m3h4x1(:,115),heltab2x4(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(427),n2h1(673))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(20),51,wf4(:,2),12,G2tensor(428),m3h4x1(:,116),heltab2x4(:,:,370))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(26),0,wf4(:,2),12,G2tensor(429),m3h4x1(:,117),heltab2x4(:,:,371))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(132),51,wf4(:,2),12,G2tensor(430),m3h4x1(:,118),heltab2x4(:,:,372))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(133),51,wf4(:,3),12,G2tensor(431),m3h4x1(:,119),heltab2x4(:,:,373))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(134),0,wf4(:,3),12,G2tensor(432),m3h4x1(:,120),heltab2x4(:,:,374))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(138),51,wf4(:,3),12,G2tensor(433),m3h4x1(:,121),heltab2x4(:,:,375))
  call Hloop_AV_Q(ntryL,G1H4(139),wf4(:,2),G1H1(1),m3h4x1(:,122),heltab2x4(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(434),n2h1(676))
  call Hloop_AV_Q(ntryL,G1H4(140),wf4(:,2),G1H1(1),m3h4x1(:,123),heltab2x4(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(435),n2h1(677))
  call Hloop_AV_Q(ntryL,G1H4(143),wf4(:,2),G1H1(1),m3h4x1(:,124),heltab2x4(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(436),n2h1(678))
  call Hloop_AV_Q(ntryL,G1H4(144),wf4(:,2),G1H1(1),m3h4x1(:,125),heltab2x4(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(437),n2h1(679))
  call Hloop_AV_Q(ntryL,G1H4(145),wf4(:,2),G1H1(1),m3h4x1(:,126),heltab2x4(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(438),n2h1(680))
  call Hloop_AV_Q(ntryL,G1H4(149),wf4(:,2),G1H1(1),m3h4x1(:,127),heltab2x4(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(439),n2h1(681))
  call Hloop_AZ_Q(ntryL,G1H4(150),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,128),heltab2x4(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(440),n2h1(682))
  call Hloop_AZ_Q(ntryL,G1H4(151),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,129),heltab2x4(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(441),n2h1(683))
  call Hloop_AZ_Q(ntryL,G1H4(154),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,130),heltab2x4(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(442),n2h1(684))
  call Hloop_AZ_Q(ntryL,G1H4(155),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,131),heltab2x4(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(443),n2h1(685))
  call Hloop_AZ_Q(ntryL,G1H4(156),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,132),heltab2x4(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(444),n2h1(686))
  call Hloop_AZ_Q(ntryL,G1H4(159),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,133),heltab2x4(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(445),n2h1(687))
  call Hloop_AZ_Q(ntryL,G1H4(160),wf4(:,3),G1H1(1),ngZn,m3h4x1(:,134),heltab2x4(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(446),n2h1(688))
  call Hloop_AZ_Q(ntryL,G1H4(161),wf4(:,3),G1H1(1),ngZn,m3h4x1(:,135),heltab2x4(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(447),n2h1(689))
  call Hloop_AZ_Q(ntryL,G1H4(164),wf4(:,3),G1H1(1),ngZn,m3h4x1(:,136),heltab2x4(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(448),n2h1(690))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(165),51,wf4(:,2),12,G2tensor(449),m3h4x1(:,137),heltab2x4(:,:,391))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(166),0,wf4(:,2),12,G2tensor(450),m3h4x1(:,138),heltab2x4(:,:,392))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(64),51,wf4(:,2),12,G2tensor(451),m3h4x1(:,139),heltab2x4(:,:,393))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(30),51,wf4(:,3),12,G2tensor(452),m3h4x1(:,140),heltab2x4(:,:,394))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(36),0,wf4(:,3),12,G2tensor(453),m3h4x1(:,141),heltab2x4(:,:,395))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(56),51,wf4(:,3),12,G2tensor(454),m3h4x1(:,142),heltab2x4(:,:,396))
  call ol_merge_tensors(G2tensor(90),[G2tensor(70),G2tensor(210),G2tensor(200),G1tensor(1360),G1tensor(1330),G1tensor(1248) &
    ,G1tensor(1218)])
  call ol_merge_tensors(G2tensor(214),[G2tensor(202),G1tensor(1260),G1tensor(1224)])
  call ol_merge_tensors(G2tensor(212),[G2tensor(204),G1tensor(1254),G1tensor(1230)])
  call ol_merge_tensors(G2tensor(216),[G2tensor(206),G1tensor(1266),G1tensor(1236)])
  call ol_merge_tensors(G2tensor(386),[G2tensor(377),G2tensor(208),G1tensor(1242)])
  call ol_merge_tensors(G2tensor(431),[G2tensor(428),G2tensor(225),G2tensor(218),G1tensor(181),G1tensor(145),G1tensor(896) &
    ,G1tensor(64)])
  call ol_merge_tensors(G2tensor(452),[G2tensor(449),G2tensor(220),G1tensor(289),G1tensor(253),G1tensor(1272)])
  call ol_merge_tensors(G2tensor(236),[G2tensor(222),G1tensor(884),G1tensor(60)])
  call ol_merge_tensors(G2tensor(223),[G1tensor(888)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(172),G2tensor(289),G2tensor(274),G2tensor(226),G1tensor(1356),G1tensor(900)])
  call ol_merge_tensors(G2tensor(228),[G1tensor(1004),G1tensor(125)])
  call ol_merge_tensors(G2tensor(229),[G1tensor(1008)])
  call ol_merge_tensors(G2tensor(231),[G1tensor(1016),G1tensor(126)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(224),G2tensor(232),G1tensor(1020)])
  call ol_merge_tensors(G2tensor(234),[G1tensor(1274)])
  call ol_merge_tensors(G2tensor(241),[G2tensor(235),G1tensor(1290),G1tensor(1278)])
  call ol_merge_tensors(G2tensor(237),[G1tensor(1280)])
  call ol_merge_tensors(G2tensor(244),[G2tensor(238),G1tensor(1296),G1tensor(1284)])
  call ol_merge_tensors(G2tensor(240),[G1tensor(1286)])
  call ol_merge_tensors(G2tensor(243),[G1tensor(1292)])
  call ol_merge_tensors(G2tensor(246),[G1tensor(1298)])
  call ol_merge_tensors(G2tensor(247),[G1tensor(1302)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(249),G1tensor(1463),G1tensor(1439),G1tensor(1304)])
  call ol_merge_tensors(G2tensor(253),[G2tensor(250),G1tensor(1314),G1tensor(1308)])
  call ol_merge_tensors(G2tensor(252),[G1tensor(1310)])
  call ol_merge_tensors(G2tensor(255),[G1tensor(1316)])
  call ol_merge_tensors(G2tensor(259),[G2tensor(256),G1tensor(1326),G1tensor(1320)])
  call ol_merge_tensors(G2tensor(258),[G1tensor(1322)])
  call ol_merge_tensors(G2tensor(178),[G2tensor(276),G2tensor(261),G1tensor(1328),G1tensor(1023),G1tensor(921),G1tensor(909) &
    ,G1tensor(903)])
  call ol_merge_tensors(G2tensor(173),[G2tensor(168),G2tensor(277),G2tensor(262),G1tensor(1332),G1tensor(588),G1tensor(564)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(279),G2tensor(264),G1tensor(1334),G1tensor(1041),G1tensor(963),G1tensor(939) &
    ,G1tensor(933)])
  call ol_merge_tensors(G2tensor(174),[G2tensor(169),G2tensor(280),G2tensor(265),G1tensor(1338),G1tensor(642),G1tensor(606)])
  call ol_merge_tensors(G2tensor(180),[G2tensor(282),G2tensor(267),G1tensor(1340),G1tensor(1047),G1tensor(969),G1tensor(951) &
    ,G1tensor(945)])
  call ol_merge_tensors(G2tensor(175),[G2tensor(170),G2tensor(283),G2tensor(268),G1tensor(1344),G1tensor(660),G1tensor(624)])
  call ol_merge_tensors(G2tensor(181),[G2tensor(285),G2tensor(270),G1tensor(1346),G1tensor(1065),G1tensor(993),G1tensor(987) &
    ,G1tensor(981)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(171),G2tensor(286),G2tensor(271),G1tensor(1350),G1tensor(684),G1tensor(672)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(288),G2tensor(273),G1tensor(1352),G1tensor(1005),G1tensor(999)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(303),G2tensor(291),G1tensor(1358),G1tensor(687),G1tensor(423),G1tensor(405) &
    ,G1tensor(399)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(162),G2tensor(304),G2tensor(292),G1tensor(1362),G1tensor(1104),G1tensor(1086)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(306),G2tensor(294),G1tensor(1364),G1tensor(717),G1tensor(483),G1tensor(447) &
    ,G1tensor(441)])
  call ol_merge_tensors(G2tensor(166),[G2tensor(163),G2tensor(307),G2tensor(295),G1tensor(1368),G1tensor(1140),G1tensor(1116)])
  call ol_merge_tensors(G2tensor(184),[G2tensor(309),G2tensor(297),G1tensor(1370),G1tensor(735),G1tensor(501),G1tensor(471) &
    ,G1tensor(465)])
  call ol_merge_tensors(G2tensor(230),[G2tensor(164),G2tensor(310),G2tensor(298),G1tensor(1374),G1tensor(1152),G1tensor(1128)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(312),G2tensor(300),G1tensor(1376),G1tensor(765),G1tensor(531),G1tensor(519) &
    ,G1tensor(513)])
  call ol_merge_tensors(G2tensor(167),[G2tensor(165),G2tensor(313),G2tensor(301),G1tensor(1380),G1tensor(1164),G1tensor(1158)])
  call ol_merge_tensors(G2tensor(315),[G1tensor(1382)])
  call ol_merge_tensors(G2tensor(322),[G2tensor(316),G1tensor(1398),G1tensor(1386)])
  call ol_merge_tensors(G2tensor(318),[G1tensor(1388)])
  call ol_merge_tensors(G2tensor(325),[G2tensor(319),G1tensor(1404),G1tensor(1392)])
  call ol_merge_tensors(G2tensor(321),[G1tensor(1394)])
  call ol_merge_tensors(G2tensor(324),[G1tensor(1400)])
  call ol_merge_tensors(G2tensor(327),[G1tensor(1406)])
  call ol_merge_tensors(G2tensor(328),[G1tensor(1410)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(330),G1tensor(1517),G1tensor(1493),G1tensor(1412)])
  call ol_merge_tensors(G2tensor(334),[G2tensor(331),G1tensor(1422),G1tensor(1416)])
  call ol_merge_tensors(G2tensor(333),[G1tensor(1418)])
  call ol_merge_tensors(G2tensor(336),[G1tensor(1424)])
  call ol_merge_tensors(G2tensor(340),[G2tensor(337),G1tensor(1434),G1tensor(1428)])
  call ol_merge_tensors(G2tensor(339),[G1tensor(1430)])
  call ol_merge_tensors(G2tensor(342),[G1tensor(1436),G1tensor(398),G1tensor(49),G1tensor(13)])
  call ol_merge_tensors(G2tensor(346),[G2tensor(343),G1tensor(1446),G1tensor(1440)])
  call ol_merge_tensors(G2tensor(345),[G1tensor(1442),G1tensor(440),G1tensor(157),G1tensor(85)])
  call ol_merge_tensors(G2tensor(348),[G1tensor(1448),G1tensor(464),G1tensor(193),G1tensor(121)])
  call ol_merge_tensors(G2tensor(352),[G2tensor(349),G1tensor(1458),G1tensor(1452)])
  call ol_merge_tensors(G2tensor(351),[G1tensor(1454),G1tensor(512),G1tensor(265),G1tensor(229)])
  call ol_merge_tensors(G2tensor(354),[G1tensor(1460),G1tensor(902),G1tensor(168),G1tensor(162)])
  call ol_merge_tensors(G2tensor(361),[G2tensor(355),G1tensor(1476),G1tensor(1464)])
  call ol_merge_tensors(G2tensor(357),[G1tensor(1466),G1tensor(932),G1tensor(346),G1tensor(174)])
  call ol_merge_tensors(G2tensor(364),[G2tensor(358),G1tensor(1482),G1tensor(1470)])
  call ol_merge_tensors(G2tensor(360),[G1tensor(1472),G1tensor(944),G1tensor(119),G1tensor(180)])
  call ol_merge_tensors(G2tensor(363),[G1tensor(1478),G1tensor(980),G1tensor(276),G1tensor(264)])
  call ol_merge_tensors(G2tensor(366),[G1tensor(1484),G1tensor(998),G1tensor(143)])
  call ol_merge_tensors(G2tensor(367),[G1tensor(1488)])
  call ol_merge_tensors(G2tensor(194),[G2tensor(369),G1tensor(1490),G1tensor(542),G1tensor(373),G1tensor(301)])
  call ol_merge_tensors(G2tensor(373),[G2tensor(370),G1tensor(1500),G1tensor(1494)])
  call ol_merge_tensors(G2tensor(195),[G2tensor(372),G1tensor(1496),G1tensor(566),G1tensor(50),G1tensor(337)])
  call ol_merge_tensors(G2tensor(196),[G2tensor(375),G1tensor(1502),G1tensor(608),G1tensor(122),G1tensor(14)])
  call ol_merge_tensors(G2tensor(379),[G2tensor(376),G1tensor(1512),G1tensor(1506)])
  call ol_merge_tensors(G2tensor(197),[G2tensor(378),G1tensor(1508),G1tensor(644),G1tensor(158),G1tensor(86)])
  call ol_merge_tensors(G2tensor(198),[G2tensor(381),G1tensor(1514),G1tensor(782),G1tensor(216),G1tensor(27)])
  call ol_merge_tensors(G2tensor(385),[G2tensor(382),G1tensor(1524),G1tensor(1518)])
  call ol_merge_tensors(G2tensor(199),[G2tensor(384),G1tensor(1520),G1tensor(800),G1tensor(45),G1tensor(222)])
  call ol_merge_tensors(G2tensor(201),[G2tensor(387),G1tensor(1526),G1tensor(830),G1tensor(304),G1tensor(234)])
  call ol_merge_tensors(G2tensor(391),[G2tensor(388),G1tensor(1536),G1tensor(1530)])
  call ol_merge_tensors(G2tensor(203),[G2tensor(390),G1tensor(1532),G1tensor(854),G1tensor(75),G1tensor(142)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(393),G1tensor(1538),G1tensor(878),G1tensor(156)])
  call ol_merge_tensors(G2tensor(394),[G1tensor(1542)])
  call ol_merge_tensors(G1tensor(79),[G1tensor(7)])
  call ol_merge_tensors(G1tensor(404),[G1tensor(200),G1tensor(19)])
  call ol_merge_tensors(G1tensor(410),[G1tensor(133),G1tensor(25)])
  call ol_merge_tensors(G1tensor(416),[G1tensor(69),G1tensor(31)])
  call ol_merge_tensors(G1tensor(151),[G1tensor(43)])
  call ol_merge_tensors(G1tensor(422),[G1tensor(236),G1tensor(55)])
  call ol_merge_tensors(G1tensor(428),[G1tensor(205),G1tensor(61)])
  call ol_merge_tensors(G1tensor(434),[G1tensor(76),G1tensor(67)])
  call ol_merge_tensors(G1tensor(446),[G1tensor(272),G1tensor(91)])
  call ol_merge_tensors(G1tensor(452),[G1tensor(241),G1tensor(97)])
  call ol_merge_tensors(G1tensor(458),[G1tensor(88),G1tensor(103)])
  call ol_merge_tensors(G1tensor(223),[G1tensor(115)])
  call ol_merge_tensors(G1tensor(470),[G1tensor(308),G1tensor(127)])
  call ol_merge_tensors(G1tensor(476),[G1tensor(81),G1tensor(139)])
  call ol_merge_tensors(G1tensor(482),[G1tensor(344),G1tensor(163)])
  call ol_merge_tensors(G1tensor(488),[G1tensor(277),G1tensor(169)])
  call ol_merge_tensors(G1tensor(494),[G1tensor(102),G1tensor(175)])
  call ol_merge_tensors(G1tensor(259),[G1tensor(187)])
  call ol_merge_tensors(G1tensor(500),[G1tensor(380),G1tensor(199)])
  call ol_merge_tensors(G1tensor(506),[G1tensor(96),G1tensor(211)])
  call ol_merge_tensors(G1tensor(518),[G1tensor(4),G1tensor(235)])
  call ol_merge_tensors(G1tensor(524),[G1tensor(111),G1tensor(247)])
  call ol_merge_tensors(G1tensor(530),[G1tensor(10),G1tensor(271)])
  call ol_merge_tensors(G1tensor(536),[G1tensor(117),G1tensor(283)])
  call ol_merge_tensors(G2tensor(205),[G1tensor(331),G1tensor(295)])
  call ol_merge_tensors(G2tensor(395),[G1tensor(548),G1tensor(208),G1tensor(307)])
  call ol_merge_tensors(G1tensor(554),[G1tensor(26),G1tensor(313)])
  call ol_merge_tensors(G2tensor(419),[G2tensor(413),G1tensor(560),G1tensor(16),G1tensor(319)])
  call ol_merge_tensors(G1tensor(572),[G1tensor(214),G1tensor(343)])
  call ol_merge_tensors(G1tensor(578),[G1tensor(98),G1tensor(349)])
  call ol_merge_tensors(G1tensor(584),[G1tensor(21),G1tensor(355)])
  call ol_merge_tensors(G2tensor(207),[G1tensor(44),G1tensor(367)])
  call ol_merge_tensors(G1tensor(590),[G1tensor(233),G1tensor(379)])
  call ol_merge_tensors(G1tensor(596),[G1tensor(134),G1tensor(385)])
  call ol_merge_tensors(G1tensor(602),[G1tensor(28),G1tensor(391)])
  call ol_merge_tensors(G2tensor(209),[G1tensor(80),G1tensor(8)])
  call ol_merge_tensors(G1tensor(614),[G1tensor(221),G1tensor(20)])
  call ol_merge_tensors(G1tensor(620),[G1tensor(34),G1tensor(32)])
  call ol_merge_tensors(G1tensor(626),[G1tensor(255),G1tensor(56)])
  call ol_merge_tensors(G1tensor(632),[G1tensor(170),G1tensor(62)])
  call ol_merge_tensors(G1tensor(638),[G1tensor(40),G1tensor(68)])
  call ol_merge_tensors(G1tensor(650),[G1tensor(244),G1tensor(92)])
  call ol_merge_tensors(G1tensor(656),[G1tensor(48),G1tensor(104)])
  call ol_merge_tensors(G2tensor(211),[G1tensor(152),G1tensor(116)])
  call ol_merge_tensors(G1tensor(662),[G1tensor(267),G1tensor(128)])
  call ol_merge_tensors(G1tensor(668),[G1tensor(53),G1tensor(140)])
  call ol_merge_tensors(G1tensor(674),[G1tensor(287),G1tensor(164)])
  call ol_merge_tensors(G1tensor(680),[G1tensor(58),G1tensor(176)])
  call ol_merge_tensors(G1tensor(260),[G1tensor(188)])
  call ol_merge_tensors(G1tensor(686),[G1tensor(230),G1tensor(194)])
  call ol_merge_tensors(G1tensor(692),[G1tensor(314),G1tensor(206)])
  call ol_merge_tensors(G1tensor(698),[G1tensor(138),G1tensor(212)])
  call ol_merge_tensors(G1tensor(332),[G1tensor(224)])
  call ol_merge_tensors(G1tensor(704),[G1tensor(386),G1tensor(242)])
  call ol_merge_tensors(G1tensor(710),[G1tensor(148),G1tensor(248)])
  call ol_merge_tensors(G1tensor(716),[G1tensor(338),G1tensor(266)])
  call ol_merge_tensors(G1tensor(722),[G1tensor(23),G1tensor(278)])
  call ol_merge_tensors(G1tensor(728),[G1tensor(161),G1tensor(284)])
  call ol_merge_tensors(G1tensor(3),[G1tensor(296)])
  call ol_merge_tensors(G1tensor(734),[G1tensor(374),G1tensor(302)])
  call ol_merge_tensors(G1tensor(740),[G1tensor(154),G1tensor(320)])
  call ol_merge_tensors(G1tensor(746),[G1tensor(35),G1tensor(350)])
  call ol_merge_tensors(G1tensor(752),[G1tensor(178),G1tensor(356)])
  call ol_merge_tensors(G1tensor(6),[G1tensor(368)])
  call ol_merge_tensors(G1tensor(758),[G1tensor(172),G1tensor(392)])
  call ol_merge_tensors(G1tensor(764),[G1tensor(106),G1tensor(100)])
  call ol_merge_tensors(G1tensor(770),[G1tensor(196),G1tensor(5)])
  call ol_merge_tensors(G1tensor(776),[G1tensor(202),G1tensor(11)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(1461),G1tensor(17),G1tensor(12)])
  call ol_merge_tensors(G2tensor(404),[G1tensor(788),G1tensor(305),G1tensor(15)])
  call ol_merge_tensors(G1tensor(794),[G1tensor(130),G1tensor(112)])
  call ol_merge_tensors(G1tensor(806),[G1tensor(311),G1tensor(18)])
  call ol_merge_tensors(G1tensor(812),[G1tensor(246),G1tensor(33)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(1467),G1tensor(36),G1tensor(22)])
  call ol_merge_tensors(G1tensor(818),[G1tensor(327),G1tensor(24)])
  call ol_merge_tensors(G1tensor(824),[G1tensor(71),G1tensor(124)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(1473),G1tensor(42),G1tensor(29)])
  call ol_merge_tensors(G1tensor(836),[G1tensor(318),G1tensor(30)])
  call ol_merge_tensors(G1tensor(842),[G1tensor(351),G1tensor(39)])
  call ol_merge_tensors(G1tensor(848),[G1tensor(310),G1tensor(136)])
  call ol_merge_tensors(G1tensor(860),[G1tensor(336),G1tensor(46)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(1479),G1tensor(54),G1tensor(51)])
  call ol_merge_tensors(G1tensor(866),[G1tensor(359),G1tensor(52)])
  call ol_merge_tensors(G1tensor(872),[G1tensor(375),G1tensor(57)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(1485),G1tensor(59)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(890),G1tensor(322)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(1515),G1tensor(82),G1tensor(65)])
  call ol_merge_tensors(G1tensor(908),[G1tensor(135),G1tensor(66)])
  call ol_merge_tensors(G1tensor(914),[G1tensor(93),G1tensor(87)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(1527),G1tensor(99),G1tensor(70)])
  call ol_merge_tensors(G1tensor(920),[G1tensor(147),G1tensor(72)])
  call ol_merge_tensors(G1tensor(926),[G1tensor(192),G1tensor(334)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(1521),G1tensor(107),G1tensor(77)])
  call ol_merge_tensors(G1tensor(938),[G1tensor(153),G1tensor(78)])
  call ol_merge_tensors(G1tensor(950),[G1tensor(160),G1tensor(84)])
  call ol_merge_tensors(G1tensor(956),[G1tensor(123),G1tensor(340)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(1533),G1tensor(113),G1tensor(90)])
  call ol_merge_tensors(G1tensor(962),[G1tensor(166),G1tensor(94)])
  call ol_merge_tensors(G1tensor(968),[G1tensor(177),G1tensor(101)])
  call ol_merge_tensors(G1tensor(974),[G1tensor(129),G1tensor(258)])
  call ol_merge_tensors(G1tensor(986),[G1tensor(190),G1tensor(108)])
  call ol_merge_tensors(G1tensor(992),[G1tensor(201),G1tensor(114)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(1539),G1tensor(120)])
  call ol_merge_tensors(G1tensor(1010),[G1tensor(288)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(1491),G1tensor(155),G1tensor(132)])
  call ol_merge_tensors(G1tensor(1022),[G1tensor(159),G1tensor(141)])
  call ol_merge_tensors(G1tensor(1028),[G1tensor(358),G1tensor(294)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(1503),G1tensor(173),G1tensor(144)])
  call ol_merge_tensors(G1tensor(1034),[G1tensor(382),G1tensor(352)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(1497),G1tensor(184),G1tensor(149)])
  call ol_merge_tensors(G1tensor(1040),[G1tensor(364),G1tensor(171)])
  call ol_merge_tensors(G1tensor(1046),[G1tensor(189),G1tensor(370)])
  call ol_merge_tensors(G1tensor(1052),[G1tensor(195),G1tensor(185)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(1509),G1tensor(198),G1tensor(165)])
  call ol_merge_tensors(G1tensor(1058),[G1tensor(256),G1tensor(376)])
  call ol_merge_tensors(G1tensor(1064),[G1tensor(207),G1tensor(394)])
  call ol_merge_tensors(G2tensor(213),[G1tensor(213),G1tensor(203)])
  call ol_merge_tensors(G2tensor(186),[G1tensor(1070),G1tensor(245),G1tensor(262)])
  call ol_merge_tensors(G1tensor(1076),[G1tensor(280),G1tensor(227)])
  call ol_merge_tensors(G2tensor(440),[G2tensor(434),G1tensor(1082),G1tensor(306),G1tensor(209)])
  call ol_merge_tensors(G2tensor(187),[G1tensor(1088),G1tensor(261),G1tensor(268)])
  call ol_merge_tensors(G1tensor(1094),[G1tensor(249),G1tensor(231)])
  call ol_merge_tensors(G1tensor(1100),[G1tensor(312),G1tensor(219)])
  call ol_merge_tensors(G2tensor(215),[G1tensor(238),G1tensor(220)])
  call ol_merge_tensors(G2tensor(188),[G1tensor(1106),G1tensor(279),G1tensor(239)])
  call ol_merge_tensors(G1tensor(1112),[G1tensor(323),G1tensor(226)])
  call ol_merge_tensors(G2tensor(219),[G1tensor(252),G1tensor(232)])
  call ol_merge_tensors(G1tensor(1118),[G1tensor(285),G1tensor(243)])
  call ol_merge_tensors(G1tensor(1124),[G1tensor(330),G1tensor(237)])
  call ol_merge_tensors(G2tensor(189),[G1tensor(1130),G1tensor(299),G1tensor(298)])
  call ol_merge_tensors(G1tensor(1136),[G1tensor(342),G1tensor(250)])
  call ol_merge_tensors(G1tensor(1142),[G1tensor(297),G1tensor(269)])
  call ol_merge_tensors(G1tensor(1148),[G1tensor(353),G1tensor(257)])
  call ol_merge_tensors(G2tensor(233),[G1tensor(275),G1tensor(263)])
  call ol_merge_tensors(G1tensor(1154),[G1tensor(363),G1tensor(273)])
  call ol_merge_tensors(G1tensor(1160),[G1tensor(383),G1tensor(291)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(1437),G1tensor(309),G1tensor(303)])
  call ol_merge_tensors(G2tensor(190),[G1tensor(1166),G1tensor(345),G1tensor(317)])
  call ol_merge_tensors(G1tensor(1172),[G1tensor(341),G1tensor(354)])
  call ol_merge_tensors(G2tensor(191),[G1tensor(1178),G1tensor(369),G1tensor(329)])
  call ol_merge_tensors(G1tensor(1184),[G1tensor(390),G1tensor(360)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(1443),G1tensor(335),G1tensor(315)])
  call ol_merge_tensors(G2tensor(192),[G1tensor(1190),G1tensor(377),G1tensor(366)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(1449),G1tensor(348),G1tensor(324)])
  call ol_merge_tensors(G1tensor(1196),[G1tensor(387),G1tensor(378)])
  call ol_merge_tensors(G2tensor(193),[G1tensor(1202),G1tensor(393),G1tensor(384)])
  call ol_merge_tensors(G1tensor(1208),[G1tensor(395),G1tensor(365)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(1455),G1tensor(371),G1tensor(357)])
  call ol_merge_tensors(G1tensor(466),[G1tensor(429),G1tensor(411),G1tensor(400)])
  call ol_merge_tensors(G1tensor(905),[G1tensor(435),G1tensor(417),G1tensor(401)])
  call ol_merge_tensors(G1tensor(444),[G1tensor(402)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(1414),G1tensor(694),G1tensor(472),G1tensor(412),G1tensor(406)])
  call ol_merge_tensors(G2tensor(248),[G1tensor(911),G1tensor(700),G1tensor(418),G1tensor(407)])
  call ol_merge_tensors(G1tensor(450),[G1tensor(408)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(1277),G1tensor(917),G1tensor(479),G1tensor(419),G1tensor(413)])
  call ol_merge_tensors(G1tensor(456),[G1tensor(414)])
  call ol_merge_tensors(G2tensor(149),[G2tensor(146),G1tensor(462),G1tensor(420)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(1426),G1tensor(706),G1tensor(502),G1tensor(430),G1tensor(424)])
  call ol_merge_tensors(G1tensor(923),[G1tensor(712),G1tensor(436),G1tensor(425)])
  call ol_merge_tensors(G1tensor(486),[G1tensor(426)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(1283),G1tensor(929),G1tensor(509),G1tensor(437),G1tensor(431)])
  call ol_merge_tensors(G1tensor(492),[G1tensor(432)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(147),G1tensor(498),G1tensor(438)])
  call ol_merge_tensors(G1tensor(514),[G1tensor(489),G1tensor(453),G1tensor(442)])
  call ol_merge_tensors(G1tensor(947),[G1tensor(495),G1tensor(459),G1tensor(443)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(1420),G1tensor(724),G1tensor(520),G1tensor(454),G1tensor(448)])
  call ol_merge_tensors(G1tensor(953),[G1tensor(730),G1tensor(460),G1tensor(449)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(1289),G1tensor(959),G1tensor(527),G1tensor(461),G1tensor(455)])
  call ol_merge_tensors(G1tensor(935),[G1tensor(507),G1tensor(477),G1tensor(467)])
  call ol_merge_tensors(G1tensor(516),[G1tensor(468)])
  call ol_merge_tensors(G1tensor(941),[G1tensor(742),G1tensor(478),G1tensor(473)])
  call ol_merge_tensors(G1tensor(522),[G1tensor(474)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(221),G1tensor(528),G1tensor(480)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(1432),G1tensor(748),G1tensor(532),G1tensor(490),G1tensor(484)])
  call ol_merge_tensors(G1tensor(971),[G1tensor(754),G1tensor(496),G1tensor(485)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(1295),G1tensor(977),G1tensor(539),G1tensor(497),G1tensor(491)])
  call ol_merge_tensors(G1tensor(965),[G1tensor(760),G1tensor(508),G1tensor(503)])
  call ol_merge_tensors(G1tensor(534),[G1tensor(504)])
  call ol_merge_tensors(G2tensor(152),[G2tensor(148),G1tensor(540),G1tensor(510)])
  call ol_merge_tensors(G1tensor(983),[G1tensor(537),G1tensor(525),G1tensor(515)])
  call ol_merge_tensors(G1tensor(989),[G1tensor(772),G1tensor(526),G1tensor(521)])
  call ol_merge_tensors(G1tensor(995),[G1tensor(778),G1tensor(538),G1tensor(533)])
  call ol_merge_tensors(G2tensor(158),[G1tensor(1071),G1tensor(591),G1tensor(549),G1tensor(543)])
  call ol_merge_tensors(G1tensor(610),[G1tensor(597),G1tensor(555),G1tensor(544)])
  call ol_merge_tensors(G1tensor(785),[G1tensor(603),G1tensor(561),G1tensor(545)])
  call ol_merge_tensors(G1tensor(570),[G1tensor(546)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(1306),G1tensor(1078),G1tensor(616),G1tensor(556),G1tensor(550)])
  call ol_merge_tensors(G2tensor(281),[G1tensor(1084),G1tensor(791),G1tensor(562),G1tensor(551)])
  call ol_merge_tensors(G1tensor(576),[G1tensor(552)])
  call ol_merge_tensors(G2tensor(128),[G1tensor(1385),G1tensor(797),G1tensor(623),G1tensor(563),G1tensor(557)])
  call ol_merge_tensors(G1tensor(582),[G1tensor(558)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(1089),G1tensor(627),G1tensor(573),G1tensor(567)])
  call ol_merge_tensors(G1tensor(646),[G1tensor(633),G1tensor(579),G1tensor(568)])
  call ol_merge_tensors(G1tensor(803),[G1tensor(639),G1tensor(585),G1tensor(569)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(1312),G1tensor(1096),G1tensor(652),G1tensor(580),G1tensor(574)])
  call ol_merge_tensors(G1tensor(1102),[G1tensor(809),G1tensor(586),G1tensor(575)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(1397),G1tensor(815),G1tensor(659),G1tensor(587),G1tensor(581)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(1318),G1tensor(1120),G1tensor(664),G1tensor(598),G1tensor(592)])
  call ol_merge_tensors(G1tensor(1126),[G1tensor(821),G1tensor(604),G1tensor(593)])
  call ol_merge_tensors(G1tensor(630),[G1tensor(594)])
  call ol_merge_tensors(G2tensor(132),[G1tensor(1391),G1tensor(827),G1tensor(671),G1tensor(605),G1tensor(599)])
  call ol_merge_tensors(G1tensor(636),[G1tensor(600)])
  call ol_merge_tensors(G2tensor(160),[G1tensor(1107),G1tensor(663),G1tensor(615),G1tensor(609)])
  call ol_merge_tensors(G1tensor(833),[G1tensor(669),G1tensor(621),G1tensor(611)])
  call ol_merge_tensors(G1tensor(648),[G1tensor(612)])
  call ol_merge_tensors(G1tensor(1114),[G1tensor(839),G1tensor(622),G1tensor(617)])
  call ol_merge_tensors(G1tensor(654),[G1tensor(618)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(1324),G1tensor(1144),G1tensor(676),G1tensor(634),G1tensor(628)])
  call ol_merge_tensors(G1tensor(1150),[G1tensor(845),G1tensor(640),G1tensor(629)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(1403),G1tensor(851),G1tensor(683),G1tensor(641),G1tensor(635)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(1131),G1tensor(675),G1tensor(651),G1tensor(645)])
  call ol_merge_tensors(G1tensor(857),[G1tensor(681),G1tensor(657),G1tensor(647)])
  call ol_merge_tensors(G1tensor(1138),[G1tensor(863),G1tensor(658),G1tensor(653)])
  call ol_merge_tensors(G1tensor(1156),[G1tensor(869),G1tensor(670),G1tensor(665)])
  call ol_merge_tensors(G1tensor(678),[G1tensor(666)])
  call ol_merge_tensors(G1tensor(1162),[G1tensor(875),G1tensor(682),G1tensor(677)])
  call ol_merge_tensors(G1tensor(736),[G1tensor(705),G1tensor(693),G1tensor(688)])
  call ol_merge_tensors(G1tensor(1025),[G1tensor(711),G1tensor(699),G1tensor(689)])
  call ol_merge_tensors(G1tensor(720),[G1tensor(690)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(1307),G1tensor(1031),G1tensor(743),G1tensor(701),G1tensor(695)])
  call ol_merge_tensors(G1tensor(726),[G1tensor(696)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(138),G1tensor(732),G1tensor(702)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(1319),G1tensor(1037),G1tensor(761),G1tensor(713),G1tensor(707)])
  call ol_merge_tensors(G1tensor(750),[G1tensor(708)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(140),G1tensor(756),G1tensor(714)])
  call ol_merge_tensors(G1tensor(766),[G1tensor(747),G1tensor(723),G1tensor(718)])
  call ol_merge_tensors(G1tensor(1049),[G1tensor(753),G1tensor(729),G1tensor(719)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(1313),G1tensor(1055),G1tensor(773),G1tensor(731),G1tensor(725)])
  call ol_merge_tensors(G1tensor(1043),[G1tensor(759),G1tensor(741),G1tensor(737)])
  call ol_merge_tensors(G1tensor(768),[G1tensor(738)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(139),G1tensor(774),G1tensor(744)])
  call ol_merge_tensors(G2tensor(217),[G1tensor(1325),G1tensor(1061),G1tensor(779),G1tensor(755),G1tensor(749)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(141),G1tensor(780),G1tensor(762)])
  call ol_merge_tensors(G1tensor(1067),[G1tensor(777),G1tensor(771),G1tensor(767)])
  call ol_merge_tensors(G2tensor(154),[G1tensor(1167),G1tensor(819),G1tensor(789),G1tensor(783)])
  call ol_merge_tensors(G1tensor(832),[G1tensor(825),G1tensor(795),G1tensor(784)])
  call ol_merge_tensors(G1tensor(804),[G1tensor(786)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(1276),G1tensor(1174),G1tensor(838),G1tensor(796),G1tensor(790)])
  call ol_merge_tensors(G1tensor(810),[G1tensor(792)])
  call ol_merge_tensors(G1tensor(816),[G1tensor(798)])
  call ol_merge_tensors(G2tensor(156),[G1tensor(1179),G1tensor(843),G1tensor(807),G1tensor(801)])
  call ol_merge_tensors(G1tensor(856),[G1tensor(849),G1tensor(813),G1tensor(802)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(1288),G1tensor(1186),G1tensor(862),G1tensor(814),G1tensor(808)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(1282),G1tensor(1198),G1tensor(868),G1tensor(826),G1tensor(820)])
  call ol_merge_tensors(G1tensor(846),[G1tensor(822)])
  call ol_merge_tensors(G1tensor(852),[G1tensor(828)])
  call ol_merge_tensors(G2tensor(155),[G1tensor(1191),G1tensor(867),G1tensor(837),G1tensor(831)])
  call ol_merge_tensors(G1tensor(858),[G1tensor(834)])
  call ol_merge_tensors(G1tensor(864),[G1tensor(840)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(1294),G1tensor(1210),G1tensor(874),G1tensor(850),G1tensor(844)])
  call ol_merge_tensors(G2tensor(157),[G1tensor(1203),G1tensor(873),G1tensor(861),G1tensor(855)])
  call ol_merge_tensors(G1tensor(876),[G1tensor(870)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(885),G1tensor(879)])
  call ol_merge_tensors(G1tensor(891),[G1tensor(880)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(897),G1tensor(881)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(1300),G1tensor(892),G1tensor(886)])
  call ol_merge_tensors(G2tensor(323),[G1tensor(898),G1tensor(887)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(1409),G1tensor(899),G1tensor(893)])
  call ol_merge_tensors(G1tensor(934),[G1tensor(927),G1tensor(915),G1tensor(904)])
  call ol_merge_tensors(G1tensor(948),[G1tensor(906)])
  call ol_merge_tensors(G2tensor(126),[G1tensor(1384),G1tensor(1030),G1tensor(940),G1tensor(916),G1tensor(910)])
  call ol_merge_tensors(G1tensor(954),[G1tensor(912)])
  call ol_merge_tensors(G1tensor(960),[G1tensor(918)])
  call ol_merge_tensors(G2tensor(130),[G1tensor(1390),G1tensor(1036),G1tensor(964),G1tensor(928),G1tensor(922)])
  call ol_merge_tensors(G1tensor(972),[G1tensor(924)])
  call ol_merge_tensors(G1tensor(978),[G1tensor(930)])
  call ol_merge_tensors(G1tensor(984),[G1tensor(936)])
  call ol_merge_tensors(G1tensor(990),[G1tensor(942)])
  call ol_merge_tensors(G1tensor(982),[G1tensor(975),G1tensor(957),G1tensor(946)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(1396),G1tensor(1054),G1tensor(988),G1tensor(958),G1tensor(952)])
  call ol_merge_tensors(G1tensor(996),[G1tensor(966)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(1402),G1tensor(1060),G1tensor(994),G1tensor(976),G1tensor(970)])
  call ol_merge_tensors(G1tensor(1011),[G1tensor(1000)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(1017),G1tensor(1001)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(1408),G1tensor(1012),G1tensor(1006)])
  call ol_merge_tensors(G2tensor(332),[G1tensor(1018),G1tensor(1007)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(1301),G1tensor(1019),G1tensor(1013)])
  call ol_merge_tensors(G1tensor(1042),[G1tensor(1035),G1tensor(1029),G1tensor(1024)])
  call ol_merge_tensors(G1tensor(1050),[G1tensor(1026)])
  call ol_merge_tensors(G1tensor(1056),[G1tensor(1032)])
  call ol_merge_tensors(G1tensor(1062),[G1tensor(1038)])
  call ol_merge_tensors(G1tensor(1068),[G1tensor(1044)])
  call ol_merge_tensors(G1tensor(1066),[G1tensor(1059),G1tensor(1053),G1tensor(1048)])
  call ol_merge_tensors(G1tensor(1119),[G1tensor(1108),G1tensor(1077),G1tensor(1072)])
  call ol_merge_tensors(G1tensor(1169),[G1tensor(1125),G1tensor(1083),G1tensor(1073)])
  call ol_merge_tensors(G1tensor(1092),[G1tensor(1074)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(1415),G1tensor(1175),G1tensor(1115),G1tensor(1085),G1tensor(1079)])
  call ol_merge_tensors(G1tensor(1098),[G1tensor(1080)])
  call ol_merge_tensors(G1tensor(1143),[G1tensor(1132),G1tensor(1095),G1tensor(1090)])
  call ol_merge_tensors(G1tensor(1181),[G1tensor(1149),G1tensor(1101),G1tensor(1091)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(1421),G1tensor(1187),G1tensor(1139),G1tensor(1103),G1tensor(1097)])
  call ol_merge_tensors(G1tensor(1193),[G1tensor(1155),G1tensor(1113),G1tensor(1109)])
  call ol_merge_tensors(G1tensor(1134),[G1tensor(1110)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(1427),G1tensor(1199),G1tensor(1157),G1tensor(1127),G1tensor(1121)])
  call ol_merge_tensors(G1tensor(1146),[G1tensor(1122)])
  call ol_merge_tensors(G1tensor(1205),[G1tensor(1161),G1tensor(1137),G1tensor(1133)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(1433),G1tensor(1211),G1tensor(1163),G1tensor(1151),G1tensor(1145)])
  call ol_merge_tensors(G1tensor(1197),[G1tensor(1192),G1tensor(1173),G1tensor(1168)])
  call ol_merge_tensors(G1tensor(1182),[G1tensor(1170)])
  call ol_merge_tensors(G1tensor(1188),[G1tensor(1176)])
  call ol_merge_tensors(G1tensor(1209),[G1tensor(1204),G1tensor(1185),G1tensor(1180)])
  call ol_merge_tensors(G1tensor(1206),[G1tensor(1194)])
  call ol_merge_tensors(G1tensor(1212),[G1tensor(1200)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(1220),G1tensor(1214)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(1215)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(1216)])
  call ol_merge_tensors(G2tensor(260),[G1tensor(1229),G1tensor(1217)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(1221)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(1222)])
  call ol_merge_tensors(G2tensor(263),[G1tensor(1235),G1tensor(1223)])
  call ol_merge_tensors(G2tensor(266),[G1tensor(1232),G1tensor(1226)])
  call ol_merge_tensors(G2tensor(111),[G1tensor(1227)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(1228)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(1233)])
  call ol_merge_tensors(G2tensor(117),[G1tensor(1234)])
  call ol_merge_tensors(G2tensor(269),[G1tensor(1238)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(1239)])
  call ol_merge_tensors(G2tensor(121),[G1tensor(1240)])
  call ol_merge_tensors(G2tensor(272),[G1tensor(1241)])
  call ol_merge_tensors(G2tensor(290),[G1tensor(1256),G1tensor(1244)])
  call ol_merge_tensors(G2tensor(123),[G1tensor(1245)])
  call ol_merge_tensors(G2tensor(125),[G1tensor(1246)])
  call ol_merge_tensors(G2tensor(293),[G1tensor(1253),G1tensor(1247)])
  call ol_merge_tensors(G2tensor(296),[G1tensor(1262),G1tensor(1250)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(1251)])
  call ol_merge_tensors(G2tensor(129),[G1tensor(1252)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(1257)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(1258)])
  call ol_merge_tensors(G2tensor(299),[G1tensor(1265),G1tensor(1259)])
  call ol_merge_tensors(G2tensor(134),[G1tensor(1263)])
  call ol_merge_tensors(G2tensor(135),[G1tensor(1264)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(1268)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(1269)])
  call ol_merge_tensors(G2tensor(242),[G1tensor(1270)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(1271)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(1281),G1tensor(1275)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(1293),G1tensor(1287)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(1299)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(1317),G1tensor(1305)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(1323),G1tensor(1311)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(68),G1tensor(1335),G1tensor(1329)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(72),G1tensor(1343),G1tensor(1331)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(74),G1tensor(1372),G1tensor(1336)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(76),G1tensor(1349),G1tensor(1337)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(78),G1tensor(1347),G1tensor(1341)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(80),G1tensor(1366),G1tensor(1342)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(82),G1tensor(1378),G1tensor(1348)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(84),G1tensor(1353)])
  call ol_merge_tensors(G2tensor(350),[G2tensor(341),G1tensor(1354)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(86),G1tensor(1355)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(108),G1tensor(1371),G1tensor(1359)])
  call ol_merge_tensors(G2tensor(118),[G2tensor(110),G1tensor(1367),G1tensor(1361)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(112),G1tensor(1377),G1tensor(1365)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(114),G1tensor(1379),G1tensor(1373)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(1389),G1tensor(1383)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(1401),G1tensor(1395)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(1407)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(1425),G1tensor(1413)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(1431),G1tensor(1419)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(1450),G1tensor(1438)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(1456),G1tensor(1444)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(1475),G1tensor(1445)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(1469),G1tensor(1451)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(1481),G1tensor(1457)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(1468),G1tensor(1462)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(1480),G1tensor(1474)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(1486)])
  call ol_merge_tensors(G2tensor(359),[G1tensor(1487)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(1504),G1tensor(1492)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(1510),G1tensor(1498)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(1523),G1tensor(1499)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(1529),G1tensor(1505)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(1535),G1tensor(1511)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(1528),G1tensor(1516)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(1534),G1tensor(1522)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(1540)])
  call ol_merge_tensors(G2tensor(368),[G1tensor(1541)])
  call ol_merge_tensors(G2tensor(422),[G2tensor(416)])
  call ol_merge_tensors(G2tensor(443),[G2tensor(437)])
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(110),mass4set(:,2),  & 
G1tensor(361),G1tensor(2),G1tensor(38),G1tensor(74),G1tensor(110))
  call G_TensorShift(G1tensor(2),12)
  call Hotf_4pt_reduction_last(G2tensor(214),RedSet_4(110),mass4set(:,3),  & 
G1tensor(146),G1tensor(182),G1tensor(218),G1tensor(254),G1tensor(290))
  call G_TensorShift(G1tensor(182),12)
  call Hotf_4pt_reduction_last(G2tensor(212),RedSet_4(110),mass4set(:,10),  & 
G1tensor(326),G1tensor(362),G1tensor(9),G1tensor(204),G1tensor(210))
  call G_TensorShift(G1tensor(362),12)
  call Hotf_4pt_reduction_last(G2tensor(216),RedSet_4(110),mass4set(:,15),  & 
G1tensor(41),G1tensor(118),G1tensor(47),G1tensor(228),G1tensor(240))
  call G_TensorShift(G1tensor(118),12)
  call Hotf_4pt_reduction_last(G2tensor(386),RedSet_4(110),mass4set(:,9),  & 
G1tensor(63),G1tensor(150),G1tensor(83),G1tensor(89),G1tensor(316))
  call G_TensorShift(G1tensor(150),12)
  call Hotf_4pt_reduction_last(G2tensor(431),RedSet_4(90),mass4set(:,14),  & 
G1tensor(95),G1tensor(328),G1tensor(186),G1tensor(105),G1tensor(131))
  call G_TensorShift(G1tensor(328),12)
  call Hotf_4pt_reduction_last(G2tensor(452),RedSet_4(104),mass4set(:,14),  & 
G1tensor(137),G1tensor(270),G1tensor(282),G1tensor(300),G1tensor(167))
  call G_TensorShift(G1tensor(270),12)
  call Hotf_4pt_reduction_last(G2tensor(236),RedSet_4(95),mass4set(:,1),  & 
G1tensor(179),G1tensor(183),G1tensor(191),G1tensor(388),G1tensor(197))
  call G_TensorShift(G1tensor(183),4)
  call Hotf_4pt_reduction_last(G2tensor(223),RedSet_4(46),mass4set(:,7),  & 
G1tensor(215),G1tensor(225),G1tensor(274),G1tensor(286),G1tensor(292))
  call G_TensorShift(G1tensor(225),20)
  call Hotf_4pt_reduction_last(G2tensor(177),RedSet_4(28),mass4set(:,16),  & 
G1tensor(251),G1tensor(281),G1tensor(293),G1tensor(321),G1tensor(333))
  call G_TensorShift(G1tensor(281),28)
  call Hotf_4pt_reduction_last(G2tensor(228),RedSet_4(98),mass4set(:,1),  & 
G1tensor(339),G1tensor(372),G1tensor(347),G1tensor(396),G1tensor(381))
  call G_TensorShift(G1tensor(372),1)
  call Hotf_4pt_reduction_last(G2tensor(229),RedSet_4(56),mass4set(:,7),  & 
G1tensor(389),G1tensor(397),G1tensor(403),G1tensor(409),G1tensor(415))
  call G_TensorShift(G1tensor(397),17)
  call Hotf_4pt_reduction_last(G2tensor(231),RedSet_4(86),mass4set(:,14),  & 
G1tensor(421),G1tensor(427),G1tensor(433),G1tensor(439),G1tensor(445))
  call G_TensorShift(G1tensor(427),3)
  call Hotf_4pt_reduction_last(G2tensor(153),RedSet_4(13),mass4set(:,16),  & 
G1tensor(451),G1tensor(457),G1tensor(463),G1tensor(469),G1tensor(475))
  call G_TensorShift(G1tensor(457),19)
  call Hotf_4pt_reduction_last(G2tensor(234),RedSet_4(148),mass4set(:,2),  & 
G1tensor(481),G1tensor(487),G1tensor(493),G1tensor(499),G1tensor(505))
  call G_TensorShift(G1tensor(487),4)
  call Hotf_4pt_reduction_last(G2tensor(241),RedSet_4(117),mass4set(:,2),  & 
G1tensor(511),G1tensor(517),G1tensor(523),G1tensor(529),G1tensor(535))
  call G_TensorShift(G1tensor(517),20)
  call Hotf_4pt_reduction_last(G2tensor(237),RedSet_4(148),mass4set(:,17),  & 
G1tensor(541),G1tensor(547),G1tensor(553),G1tensor(559),G1tensor(565))
  call G_TensorShift(G1tensor(547),4)
  call Hotf_4pt_reduction_last(G2tensor(244),RedSet_4(117),mass4set(:,17),  & 
G1tensor(571),G1tensor(577),G1tensor(583),G1tensor(589),G1tensor(595))
  call G_TensorShift(G1tensor(577),20)
  call Hotf_4pt_reduction_last(G2tensor(240),RedSet_4(148),mass4set(:,3),  & 
G1tensor(601),G1tensor(607),G1tensor(613),G1tensor(619),G1tensor(625))
  call G_TensorShift(G1tensor(607),4)
  call Hotf_4pt_reduction_last(G2tensor(243),RedSet_4(148),mass4set(:,18),  & 
G1tensor(631),G1tensor(637),G1tensor(643),G1tensor(649),G1tensor(655))
  call G_TensorShift(G1tensor(637),4)
  call Hotf_4pt_reduction_last(G2tensor(246),RedSet_4(148),mass4set(:,5),  & 
G1tensor(661),G1tensor(667),G1tensor(673),G1tensor(679),G1tensor(685))
  call G_TensorShift(G1tensor(667),4)
  call Hotf_4pt_reduction_last(G2tensor(247),RedSet_4(117),mass4set(:,19),  & 
G1tensor(691),G1tensor(697),G1tensor(703),G1tensor(709),G1tensor(715))
  call G_TensorShift(G1tensor(697),20)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(136),mass4set(:,2),  & 
G1tensor(721),G1tensor(727),G1tensor(733),G1tensor(739),G1tensor(745))
  call G_TensorShift(G1tensor(727),8)
  call Hotf_4pt_reduction_last(G2tensor(253),RedSet_4(120),mass4set(:,2),  & 
G1tensor(751),G1tensor(757),G1tensor(763),G1tensor(769),G1tensor(775))
  call G_TensorShift(G1tensor(757),24)
  call Hotf_4pt_reduction_last(G2tensor(252),RedSet_4(136),mass4set(:,3),  & 
G1tensor(781),G1tensor(787),G1tensor(793),G1tensor(799),G1tensor(805))
  call G_TensorShift(G1tensor(787),8)
  call Hotf_4pt_reduction_last(G2tensor(255),RedSet_4(136),mass4set(:,17),  & 
G1tensor(811),G1tensor(817),G1tensor(823),G1tensor(829),G1tensor(835))
  call G_TensorShift(G1tensor(817),8)
  call Hotf_4pt_reduction_last(G2tensor(259),RedSet_4(120),mass4set(:,17),  & 
G1tensor(841),G1tensor(847),G1tensor(853),G1tensor(859),G1tensor(865))
  call G_TensorShift(G1tensor(847),24)
  call Hotf_4pt_reduction_last(G2tensor(258),RedSet_4(136),mass4set(:,18),  & 
G1tensor(871),G1tensor(877),G1tensor(883),G1tensor(889),G1tensor(895))
  call G_TensorShift(G1tensor(877),8)
  call Hotf_4pt_reduction_last(G2tensor(178),RedSet_4(51),mass4set(:,2),  & 
G1tensor(901),G1tensor(907),G1tensor(913),G1tensor(919),G1tensor(925))
  call G_TensorShift(G1tensor(907),16)
  call Hotf_4pt_reduction_last(G2tensor(173),RedSet_4(28),mass4set(:,2),  & 
G1tensor(931),G1tensor(937),G1tensor(943),G1tensor(949),G1tensor(955))
  call G_TensorShift(G1tensor(937),28)
  call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(51),mass4set(:,17),  & 
G1tensor(961),G1tensor(967),G1tensor(973),G1tensor(979),G1tensor(985))
  call G_TensorShift(G1tensor(967),16)
  call Hotf_4pt_reduction_last(G2tensor(174),RedSet_4(28),mass4set(:,17),  & 
G1tensor(991),G1tensor(997),G1tensor(1003),G1tensor(1009),G1tensor(1015))
  call G_TensorShift(G1tensor(997),28)
  call Hotf_4pt_reduction_last(G2tensor(180),RedSet_4(51),mass4set(:,10),  & 
G1tensor(1021),G1tensor(1027),G1tensor(1033),G1tensor(1039),G1tensor(1045))
  call G_TensorShift(G1tensor(1027),16)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(28),mass4set(:,10),  & 
G1tensor(1051),G1tensor(1057),G1tensor(1063),G1tensor(1069),G1tensor(1075))
  call G_TensorShift(G1tensor(1057),28)
  call Hotf_4pt_reduction_last(G2tensor(181),RedSet_4(51),mass4set(:,20),  & 
G1tensor(1081),G1tensor(1087),G1tensor(1093),G1tensor(1099),G1tensor(1105))
  call G_TensorShift(G1tensor(1087),16)
  call Hotf_4pt_reduction_last(G2tensor(176),RedSet_4(28),mass4set(:,20),  & 
G1tensor(1111),G1tensor(1117),G1tensor(1123),G1tensor(1129),G1tensor(1135))
  call G_TensorShift(G1tensor(1117),28)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(51),mass4set(:,16),  & 
G1tensor(1141),G1tensor(1147),G1tensor(1153),G1tensor(1159),G1tensor(1165))
  call G_TensorShift(G1tensor(1147),16)
  call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(1),mass4set(:,2),  & 
G1tensor(1171),G1tensor(1177),G1tensor(1183),G1tensor(1189),G1tensor(1195))
  call G_TensorShift(G1tensor(1177),16)
  call Hotf_4pt_reduction_last(G2tensor(227),RedSet_4(74),mass4set(:,2),  & 
G1tensor(1201),G1tensor(1207),G1tensor(1213),G1tensor(1219),G1tensor(1225))
  call G_TensorShift(G1tensor(1207),28)
  call Hotf_4pt_reduction_last(G2tensor(183),RedSet_4(1),mass4set(:,10),  & 
G1tensor(1231),G1tensor(1237),G1tensor(1243),G1tensor(1249),G1tensor(1255))
  call G_TensorShift(G1tensor(1237),16)
  call Hotf_4pt_reduction_last(G2tensor(166),RedSet_4(74),mass4set(:,10),  & 
G1tensor(1261),G1tensor(1267),G1tensor(1273),G1tensor(1279),G1tensor(1285))
  call G_TensorShift(G1tensor(1267),28)
  call Hotf_4pt_reduction_last(G2tensor(184),RedSet_4(1),mass4set(:,17),  & 
G1tensor(1291),G1tensor(1297),G1tensor(1303),G1tensor(1309),G1tensor(1315))
  call G_TensorShift(G1tensor(1297),16)
  call Hotf_4pt_reduction_last(G2tensor(230),RedSet_4(74),mass4set(:,17),  & 
G1tensor(1321),G1tensor(1327),G1tensor(1333),G1tensor(1339),G1tensor(1345))
  call G_TensorShift(G1tensor(1327),28)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(1),mass4set(:,20),  & 
G1tensor(1351),G1tensor(1357),G1tensor(1363),G1tensor(1369),G1tensor(1375))
  call G_TensorShift(G1tensor(1357),16)
  call Hotf_4pt_reduction_last(G2tensor(167),RedSet_4(74),mass4set(:,20),  & 
G1tensor(1381),G1tensor(1387),G1tensor(1393),G1tensor(1399),G1tensor(1405))
  call G_TensorShift(G1tensor(1387),28)
  call Hotf_4pt_reduction_last(G2tensor(315),RedSet_4(149),mass4set(:,2),  & 
G1tensor(1411),G1tensor(1417),G1tensor(1423),G1tensor(1429),G1tensor(1435))
  call G_TensorShift(G1tensor(1417),1)
  call Hotf_4pt_reduction_last(G2tensor(322),RedSet_4(129),mass4set(:,2),  & 
G1tensor(1441),G1tensor(1447),G1tensor(1453),G1tensor(1459),G1tensor(1465))
  call G_TensorShift(G1tensor(1447),17)
  call Hotf_4pt_reduction_last(G2tensor(318),RedSet_4(149),mass4set(:,17),  & 
G1tensor(1471),G1tensor(1477),G1tensor(1483),G1tensor(1489),G1tensor(1495))
  call G_TensorShift(G1tensor(1477),1)
  call Hotf_4pt_reduction_last(G2tensor(325),RedSet_4(129),mass4set(:,17),  & 
G1tensor(1501),G1tensor(1507),G1tensor(1513),G1tensor(1519),G1tensor(1525))
  call G_TensorShift(G1tensor(1507),17)
  call Hotf_4pt_reduction_last(G2tensor(321),RedSet_4(149),mass4set(:,3),  & 
G1tensor(1531),G1tensor(1537),G1tensor(1360),G1tensor(1330),G1tensor(1248))
  call G_TensorShift(G1tensor(1537),1)
  call Hotf_4pt_reduction_last(G2tensor(324),RedSet_4(149),mass4set(:,18),  & 
G1tensor(1218),G1tensor(1260),G1tensor(1224),G1tensor(1254),G1tensor(1230))
  call G_TensorShift(G1tensor(1260),1)
  call Hotf_4pt_reduction_last(G2tensor(327),RedSet_4(149),mass4set(:,5),  & 
G1tensor(1266),G1tensor(1236),G1tensor(1242),G1tensor(181),G1tensor(145))
  call G_TensorShift(G1tensor(1236),1)
  call Hotf_4pt_reduction_last(G2tensor(328),RedSet_4(129),mass4set(:,19),  & 
G1tensor(896),G1tensor(64),G1tensor(289),G1tensor(253),G1tensor(1272))
  call G_TensorShift(G1tensor(64),17)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(143),mass4set(:,2),  & 
G1tensor(884),G1tensor(60),G1tensor(888),G1tensor(1356),G1tensor(900))
  call G_TensorShift(G1tensor(60),2)
  call Hotf_4pt_reduction_last(G2tensor(334),RedSet_4(132),mass4set(:,2),  & 
G1tensor(1004),G1tensor(125),G1tensor(1008),G1tensor(1016),G1tensor(126))
  call G_TensorShift(G1tensor(125),18)
  call Hotf_4pt_reduction_last(G2tensor(333),RedSet_4(143),mass4set(:,3),  & 
G1tensor(1020),G1tensor(1274),G1tensor(1290),G1tensor(1278),G1tensor(1280))
  call G_TensorShift(G1tensor(1274),2)
  call Hotf_4pt_reduction_last(G2tensor(336),RedSet_4(143),mass4set(:,17),  & 
G1tensor(1296),G1tensor(1284),G1tensor(1286),G1tensor(1292),G1tensor(1298))
  call G_TensorShift(G1tensor(1284),2)
  call Hotf_4pt_reduction_last(G2tensor(340),RedSet_4(132),mass4set(:,17),  & 
G1tensor(1302),G1tensor(1463),G1tensor(1439),G1tensor(1304),G1tensor(1314))
  call G_TensorShift(G1tensor(1463),18)
  call Hotf_4pt_reduction_last(G2tensor(339),RedSet_4(143),mass4set(:,18),  & 
G1tensor(1308),G1tensor(1310),G1tensor(1316),G1tensor(1326),G1tensor(1320))
  call G_TensorShift(G1tensor(1310),2)
  call Hotf_4pt_reduction_last(G2tensor(342),RedSet_4(83),mass4set(:,2),  & 
G1tensor(1322),G1tensor(1328),G1tensor(1023),G1tensor(921),G1tensor(909))
  call G_TensorShift(G1tensor(1328),2)
  call Hotf_4pt_reduction_last(G2tensor(346),RedSet_4(137),mass4set(:,2),  & 
G1tensor(903),G1tensor(1332),G1tensor(588),G1tensor(564),G1tensor(1334))
  call G_TensorShift(G1tensor(1332),10)
  call Hotf_4pt_reduction_last(G2tensor(345),RedSet_4(83),mass4set(:,3),  & 
G1tensor(1041),G1tensor(963),G1tensor(939),G1tensor(933),G1tensor(1338))
  call G_TensorShift(G1tensor(963),2)
  call Hotf_4pt_reduction_last(G2tensor(348),RedSet_4(83),mass4set(:,12),  & 
G1tensor(642),G1tensor(606),G1tensor(1340),G1tensor(1047),G1tensor(969))
  call G_TensorShift(G1tensor(606),2)
  call Hotf_4pt_reduction_last(G2tensor(352),RedSet_4(137),mass4set(:,12),  & 
G1tensor(951),G1tensor(945),G1tensor(1344),G1tensor(660),G1tensor(624))
  call G_TensorShift(G1tensor(945),10)
  call Hotf_4pt_reduction_last(G2tensor(351),RedSet_4(83),mass4set(:,21),  & 
G1tensor(1346),G1tensor(1065),G1tensor(993),G1tensor(987),G1tensor(981))
  call G_TensorShift(G1tensor(1065),2)
  call Hotf_4pt_reduction_last(G2tensor(354),RedSet_4(97),mass4set(:,2),  & 
G1tensor(1350),G1tensor(684),G1tensor(672),G1tensor(1352),G1tensor(1005))
  call G_TensorShift(G1tensor(684),1)
  call Hotf_4pt_reduction_last(G2tensor(361),RedSet_4(140),mass4set(:,2),  & 
G1tensor(999),G1tensor(1358),G1tensor(687),G1tensor(423),G1tensor(405))
  call G_TensorShift(G1tensor(1358),9)
  call Hotf_4pt_reduction_last(G2tensor(357),RedSet_4(97),mass4set(:,12),  & 
G1tensor(399),G1tensor(1362),G1tensor(1104),G1tensor(1086),G1tensor(1364))
  call G_TensorShift(G1tensor(1362),1)
  call Hotf_4pt_reduction_last(G2tensor(364),RedSet_4(140),mass4set(:,12),  & 
G1tensor(717),G1tensor(483),G1tensor(447),G1tensor(441),G1tensor(1368))
  call G_TensorShift(G1tensor(483),9)
  call Hotf_4pt_reduction_last(G2tensor(360),RedSet_4(97),mass4set(:,3),  & 
G1tensor(1140),G1tensor(1116),G1tensor(1370),G1tensor(735),G1tensor(501))
  call G_TensorShift(G1tensor(1116),1)
  call Hotf_4pt_reduction_last(G2tensor(363),RedSet_4(97),mass4set(:,21),  & 
G1tensor(471),G1tensor(465),G1tensor(1374),G1tensor(1152),G1tensor(1128))
  call G_TensorShift(G1tensor(465),1)
  call Hotf_4pt_reduction_last(G2tensor(366),RedSet_4(97),mass4set(:,22),  & 
G1tensor(1376),G1tensor(765),G1tensor(531),G1tensor(519),G1tensor(513))
  call G_TensorShift(G1tensor(765),1)
  call Hotf_4pt_reduction_last(G2tensor(367),RedSet_4(140),mass4set(:,13),  & 
G1tensor(1380),G1tensor(1164),G1tensor(1158),G1tensor(1382),G1tensor(1398))
  call G_TensorShift(G1tensor(1164),9)
  call Hotf_4pt_reduction_last(G2tensor(194),RedSet_4(87),mass4set(:,2),  & 
G1tensor(1386),G1tensor(1388),G1tensor(1404),G1tensor(1392),G1tensor(1394))
  call G_TensorShift(G1tensor(1388),8)
  call Hotf_4pt_reduction_last(G2tensor(373),RedSet_4(144),mass4set(:,2),  & 
G1tensor(1400),G1tensor(1406),G1tensor(1410),G1tensor(1517),G1tensor(1493))
  call G_TensorShift(G1tensor(1406),10)
  call Hotf_4pt_reduction_last(G2tensor(195),RedSet_4(87),mass4set(:,3),  & 
G1tensor(1412),G1tensor(1422),G1tensor(1416),G1tensor(1418),G1tensor(1424))
  call G_TensorShift(G1tensor(1422),8)
  call Hotf_4pt_reduction_last(G2tensor(196),RedSet_4(87),mass4set(:,12),  & 
G1tensor(1434),G1tensor(1428),G1tensor(1430),G1tensor(1436),G1tensor(398))
  call G_TensorShift(G1tensor(1428),8)
  call Hotf_4pt_reduction_last(G2tensor(379),RedSet_4(144),mass4set(:,12),  & 
G1tensor(49),G1tensor(13),G1tensor(1446),G1tensor(1440),G1tensor(1442))
  call G_TensorShift(G1tensor(13),10)
  call Hotf_4pt_reduction_last(G2tensor(197),RedSet_4(87),mass4set(:,21),  & 
G1tensor(440),G1tensor(157),G1tensor(85),G1tensor(1448),G1tensor(464))
  call G_TensorShift(G1tensor(157),8)
  call Hotf_4pt_reduction_last(G2tensor(198),RedSet_4(94),mass4set(:,2),  & 
G1tensor(193),G1tensor(121),G1tensor(1458),G1tensor(1452),G1tensor(1454))
  call G_TensorShift(G1tensor(121),4)
  call Hotf_4pt_reduction_last(G2tensor(385),RedSet_4(147),mass4set(:,2),  & 
G1tensor(512),G1tensor(265),G1tensor(229),G1tensor(1460),G1tensor(902))
  call G_TensorShift(G1tensor(265),6)
  call Hotf_4pt_reduction_last(G2tensor(199),RedSet_4(94),mass4set(:,3),  & 
G1tensor(168),G1tensor(162),G1tensor(1476),G1tensor(1464),G1tensor(1466))
  call G_TensorShift(G1tensor(162),4)
  call Hotf_4pt_reduction_last(G2tensor(201),RedSet_4(94),mass4set(:,12),  & 
G1tensor(932),G1tensor(346),G1tensor(174),G1tensor(1482),G1tensor(1470))
  call G_TensorShift(G1tensor(346),4)
  call Hotf_4pt_reduction_last(G2tensor(391),RedSet_4(147),mass4set(:,12),  & 
G1tensor(1472),G1tensor(944),G1tensor(119),G1tensor(180),G1tensor(1478))
  call G_TensorShift(G1tensor(944),6)
  call Hotf_4pt_reduction_last(G2tensor(203),RedSet_4(94),mass4set(:,21),  & 
G1tensor(980),G1tensor(276),G1tensor(264),G1tensor(1484),G1tensor(998))
  call G_TensorShift(G1tensor(276),4)
  call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(94),mass4set(:,22),  & 
G1tensor(143),G1tensor(1488),G1tensor(1490),G1tensor(542),G1tensor(373))
  call G_TensorShift(G1tensor(1488),4)
  call Hotf_4pt_reduction_last(G2tensor(394),RedSet_4(147),mass4set(:,13),  & 
G1tensor(301),G1tensor(1500),G1tensor(1494),G1tensor(1496),G1tensor(566))
  call G_TensorShift(G1tensor(1500),6)
  call Hotf_4pt_reduction_last(G2tensor(205),RedSet_4(150),mass4set(:,2),  & 
G1tensor(50),G1tensor(337),G1tensor(1502),G1tensor(608),G1tensor(122))
  call G_TensorShift(G1tensor(337),4)
  call Hotf_4pt_reduction_last(G2tensor(395),RedSet_4(88),mass4set(:,2),  & 
G1tensor(14),G1tensor(1512),G1tensor(1506),G1tensor(1508),G1tensor(644))
  call G_TensorShift(G1tensor(1512),8)
  call Hotf_4pt_reduction_last(G2tensor(419),RedSet_4(90),mass4set(:,2),  & 
G1tensor(158),G1tensor(86),G1tensor(1514),G1tensor(782),G1tensor(216))
  call G_TensorShift(G1tensor(86),12)
  call Hotf_4pt_reduction_last(G2tensor(207),RedSet_4(150),mass4set(:,17),  & 
G1tensor(27),G1tensor(1524),G1tensor(1518),G1tensor(1520),G1tensor(800))
  call G_TensorShift(G1tensor(1524),4)
  call Hotf_4pt_reduction_last(G2tensor(209),RedSet_4(150),mass4set(:,10),  & 
G1tensor(45),G1tensor(222),G1tensor(1526),G1tensor(830),G1tensor(304))
  call G_TensorShift(G1tensor(222),4)
  call Hotf_4pt_reduction_last(G2tensor(211),RedSet_4(150),mass4set(:,20),  & 
G1tensor(234),G1tensor(1536),G1tensor(1530),G1tensor(1532),G1tensor(854))
  call G_TensorShift(G1tensor(1536),4)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(138),mass4set(:,2),  & 
G1tensor(75),G1tensor(142),G1tensor(1538),G1tensor(878),G1tensor(156))
  call G_TensorShift(G1tensor(142),8)
  call Hotf_4pt_reduction_last(G2tensor(404),RedSet_4(95),mass4set(:,2),  & 
G1tensor(1542),G1tensor(7),G1tensor(200),G1tensor(19),G1tensor(133))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(138),mass4set(:,17),  & 
G1tensor(25),G1tensor(69),G1tensor(31),G1tensor(43),G1tensor(236))
  call G_TensorShift(G1tensor(69),8)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(138),mass4set(:,10),  & 
G1tensor(55),G1tensor(205),G1tensor(61),G1tensor(76),G1tensor(67))
  call G_TensorShift(G1tensor(205),8)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(138),mass4set(:,20),  & 
G1tensor(272),G1tensor(91),G1tensor(241),G1tensor(97),G1tensor(88))
  call G_TensorShift(G1tensor(91),8)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(138),mass4set(:,16),  & 
G1tensor(103),G1tensor(115),G1tensor(308),G1tensor(127),G1tensor(81))
  call G_TensorShift(G1tensor(115),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(96),mass4set(:,5),  & 
G1tensor(139),G1tensor(344),G1tensor(163),G1tensor(277),G1tensor(169))
  call G_TensorShift(G1tensor(344),4)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(145),mass4set(:,2),  & 
G1tensor(102),G1tensor(175),G1tensor(187),G1tensor(380),G1tensor(199))
  call G_TensorShift(G1tensor(175),2)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(145),mass4set(:,17),  & 
G1tensor(96),G1tensor(211),G1tensor(4),G1tensor(235),G1tensor(111))
  call G_TensorShift(G1tensor(211),2)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(145),mass4set(:,10),  & 
G1tensor(247),G1tensor(10),G1tensor(271),G1tensor(117),G1tensor(283))
  call G_TensorShift(G1tensor(10),2)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(145),mass4set(:,20),  & 
G1tensor(331),G1tensor(295),G1tensor(548),G1tensor(208),G1tensor(307))
  call G_TensorShift(G1tensor(295),2)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(145),mass4set(:,16),  & 
G1tensor(26),G1tensor(313),G1tensor(560),G1tensor(16),G1tensor(319))
  call G_TensorShift(G1tensor(313),2)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(141),mass4set(:,2),  & 
G1tensor(214),G1tensor(343),G1tensor(98),G1tensor(349),G1tensor(21))
  call G_TensorShift(G1tensor(343),2)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(141),mass4set(:,17),  & 
G1tensor(355),G1tensor(44),G1tensor(367),G1tensor(233),G1tensor(379))
  call G_TensorShift(G1tensor(44),2)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(141),mass4set(:,10),  & 
G1tensor(134),G1tensor(385),G1tensor(28),G1tensor(391),G1tensor(80))
  call G_TensorShift(G1tensor(385),2)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(141),mass4set(:,20),  & 
G1tensor(8),G1tensor(221),G1tensor(20),G1tensor(34),G1tensor(32))
  call G_TensorShift(G1tensor(221),2)
  call Hotf_4pt_reduction_last(G2tensor(213),RedSet_4(151),mass4set(:,2),  & 
G1tensor(255),G1tensor(56),G1tensor(170),G1tensor(62),G1tensor(40))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_4pt_reduction_last(G2tensor(186),RedSet_4(102),mass4set(:,2),  & 
G1tensor(68),G1tensor(244),G1tensor(92),G1tensor(48),G1tensor(104))
  call G_TensorShift(G1tensor(244),8)
  call Hotf_4pt_reduction_last(G2tensor(440),RedSet_4(104),mass4set(:,2),  & 
G1tensor(152),G1tensor(116),G1tensor(267),G1tensor(128),G1tensor(53))
  call G_TensorShift(G1tensor(116),12)
  call Hotf_4pt_reduction_last(G2tensor(187),RedSet_4(102),mass4set(:,3),  & 
G1tensor(140),G1tensor(287),G1tensor(164),G1tensor(58),G1tensor(176))
  call G_TensorShift(G1tensor(287),8)
  call Hotf_4pt_reduction_last(G2tensor(215),RedSet_4(151),mass4set(:,10),  & 
G1tensor(188),G1tensor(230),G1tensor(194),G1tensor(314),G1tensor(206))
  call G_TensorShift(G1tensor(230),4)
  call Hotf_4pt_reduction_last(G2tensor(188),RedSet_4(102),mass4set(:,12),  & 
G1tensor(138),G1tensor(212),G1tensor(224),G1tensor(386),G1tensor(242))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_4pt_reduction_last(G2tensor(219),RedSet_4(151),mass4set(:,17),  & 
G1tensor(148),G1tensor(248),G1tensor(338),G1tensor(266),G1tensor(23))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_4pt_reduction_last(G2tensor(189),RedSet_4(102),mass4set(:,21),  & 
G1tensor(278),G1tensor(161),G1tensor(284),G1tensor(296),G1tensor(374))
  call G_TensorShift(G1tensor(161),8)
  call Hotf_4pt_reduction_last(G2tensor(233),RedSet_4(151),mass4set(:,20),  & 
G1tensor(302),G1tensor(154),G1tensor(320),G1tensor(35),G1tensor(350))
  call G_TensorShift(G1tensor(154),4)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(134),mass4set(:,2),  & 
G1tensor(178),G1tensor(356),G1tensor(368),G1tensor(172),G1tensor(392))
  call G_TensorShift(G1tensor(356),8)
  call Hotf_4pt_reduction_last(G2tensor(190),RedSet_4(105),mass4set(:,2),  & 
G1tensor(106),G1tensor(100),G1tensor(196),G1tensor(5),G1tensor(202))
  call G_TensorShift(G1tensor(100),4)
  call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(105),mass4set(:,3),  & 
G1tensor(11),G1tensor(1461),G1tensor(17),G1tensor(12),G1tensor(788))
  call G_TensorShift(G1tensor(1461),4)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(134),mass4set(:,10),  & 
G1tensor(305),G1tensor(15),G1tensor(130),G1tensor(112),G1tensor(311))
  call G_TensorShift(G1tensor(15),8)
  call Hotf_4pt_reduction_last(G2tensor(192),RedSet_4(105),mass4set(:,12),  & 
G1tensor(18),G1tensor(246),G1tensor(33),G1tensor(1467),G1tensor(36))
  call G_TensorShift(G1tensor(246),4)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(134),mass4set(:,17),  & 
G1tensor(22),G1tensor(327),G1tensor(24),G1tensor(71),G1tensor(124))
  call G_TensorShift(G1tensor(327),8)
  call Hotf_4pt_reduction_last(G2tensor(193),RedSet_4(105),mass4set(:,21),  & 
G1tensor(1473),G1tensor(42),G1tensor(29),G1tensor(318),G1tensor(30))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(134),mass4set(:,20),  & 
G1tensor(351),G1tensor(39),G1tensor(310),G1tensor(136),G1tensor(336))
  call G_TensorShift(G1tensor(39),8)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(6),mass4set(:,2),  & 
G1tensor(46),G1tensor(1479),G1tensor(54),G1tensor(51),G1tensor(359))
  call G_TensorShift(G1tensor(1479),16)
  call Hotf_4pt_reduction_last(G2tensor(248),RedSet_4(7),mass4set(:,2),  & 
G1tensor(52),G1tensor(375),G1tensor(57),G1tensor(1485),G1tensor(59))
  call G_TensorShift(G1tensor(375),16)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(10),mass4set(:,2),  & 
G1tensor(890),G1tensor(322),G1tensor(1515),G1tensor(82),G1tensor(65))
  call G_TensorShift(G1tensor(322),16)
  call Hotf_4pt_reduction_last(G2tensor(149),RedSet_4(13),mass4set(:,2),  & 
G1tensor(135),G1tensor(66),G1tensor(93),G1tensor(87),G1tensor(1527))
  call G_TensorShift(G1tensor(66),19)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(6),mass4set(:,17),  & 
G1tensor(99),G1tensor(70),G1tensor(147),G1tensor(72),G1tensor(192))
  call G_TensorShift(G1tensor(70),16)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(10),mass4set(:,17),  & 
G1tensor(334),G1tensor(1521),G1tensor(107),G1tensor(77),G1tensor(153))
  call G_TensorShift(G1tensor(1521),16)
  call Hotf_4pt_reduction_last(G2tensor(150),RedSet_4(13),mass4set(:,17),  & 
G1tensor(78),G1tensor(160),G1tensor(84),G1tensor(123),G1tensor(340))
  call G_TensorShift(G1tensor(160),19)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(6),mass4set(:,10),  & 
G1tensor(1533),G1tensor(113),G1tensor(90),G1tensor(166),G1tensor(94))
  call G_TensorShift(G1tensor(113),16)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(10),mass4set(:,10),  & 
G1tensor(177),G1tensor(101),G1tensor(129),G1tensor(258),G1tensor(190))
  call G_TensorShift(G1tensor(101),16)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(13),mass4set(:,10),  & 
G1tensor(108),G1tensor(201),G1tensor(114),G1tensor(1539),G1tensor(120))
  call G_TensorShift(G1tensor(201),19)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(6),mass4set(:,20),  & 
G1tensor(288),G1tensor(1491),G1tensor(155),G1tensor(132),G1tensor(159))
  call G_TensorShift(G1tensor(1491),16)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(10),mass4set(:,20),  & 
G1tensor(141),G1tensor(358),G1tensor(294),G1tensor(1503),G1tensor(173))
  call G_TensorShift(G1tensor(358),16)
  call Hotf_4pt_reduction_last(G2tensor(152),RedSet_4(13),mass4set(:,20),  & 
G1tensor(144),G1tensor(382),G1tensor(352),G1tensor(1497),G1tensor(184))
  call G_TensorShift(G1tensor(382),19)
  call Hotf_4pt_reduction_last(G2tensor(158),RedSet_4(16),mass4set(:,2),  & 
G1tensor(149),G1tensor(364),G1tensor(171),G1tensor(189),G1tensor(370))
  call G_TensorShift(G1tensor(364),16)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(21),mass4set(:,2),  & 
G1tensor(195),G1tensor(185),G1tensor(1509),G1tensor(198),G1tensor(165))
  call G_TensorShift(G1tensor(185),16)
  call Hotf_4pt_reduction_last(G2tensor(281),RedSet_4(22),mass4set(:,2),  & 
G1tensor(256),G1tensor(376),G1tensor(207),G1tensor(394),G1tensor(213))
  call G_TensorShift(G1tensor(376),16)
  call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(25),mass4set(:,2),  & 
G1tensor(203),G1tensor(1070),G1tensor(245),G1tensor(262),G1tensor(280))
  call G_TensorShift(G1tensor(1070),16)
  call Hotf_4pt_reduction_last(G2tensor(159),RedSet_4(16),mass4set(:,10),  & 
G1tensor(227),G1tensor(1082),G1tensor(306),G1tensor(209),G1tensor(1088))
  call G_TensorShift(G1tensor(1082),16)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(21),mass4set(:,10),  & 
G1tensor(261),G1tensor(268),G1tensor(249),G1tensor(231),G1tensor(312))
  call G_TensorShift(G1tensor(268),16)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(25),mass4set(:,10),  & 
G1tensor(219),G1tensor(238),G1tensor(220),G1tensor(1106),G1tensor(279))
  call G_TensorShift(G1tensor(238),16)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(21),mass4set(:,17),  & 
G1tensor(239),G1tensor(323),G1tensor(226),G1tensor(252),G1tensor(232))
  call G_TensorShift(G1tensor(323),16)
  call Hotf_4pt_reduction_last(G2tensor(132),RedSet_4(25),mass4set(:,17),  & 
G1tensor(285),G1tensor(243),G1tensor(330),G1tensor(237),G1tensor(1130))
  call G_TensorShift(G1tensor(243),16)
  call Hotf_4pt_reduction_last(G2tensor(160),RedSet_4(16),mass4set(:,17),  & 
G1tensor(299),G1tensor(298),G1tensor(342),G1tensor(250),G1tensor(297))
  call G_TensorShift(G1tensor(298),16)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(21),mass4set(:,20),  & 
G1tensor(269),G1tensor(353),G1tensor(257),G1tensor(275),G1tensor(263))
  call G_TensorShift(G1tensor(353),16)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(25),mass4set(:,20),  & 
G1tensor(363),G1tensor(273),G1tensor(383),G1tensor(291),G1tensor(1437))
  call G_TensorShift(G1tensor(273),16)
  call Hotf_4pt_reduction_last(G2tensor(161),RedSet_4(16),mass4set(:,20),  & 
G1tensor(309),G1tensor(303),G1tensor(1166),G1tensor(345),G1tensor(317))
  call G_TensorShift(G1tensor(303),16)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(35),mass4set(:,2),  & 
G1tensor(341),G1tensor(354),G1tensor(1178),G1tensor(369),G1tensor(329))
  call G_TensorShift(G1tensor(354),16)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(38),mass4set(:,2),  & 
G1tensor(390),G1tensor(360),G1tensor(1443),G1tensor(335),G1tensor(315))
  call G_TensorShift(G1tensor(360),19)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(35),mass4set(:,17),  & 
G1tensor(1190),G1tensor(377),G1tensor(366),G1tensor(1449),G1tensor(348))
  call G_TensorShift(G1tensor(377),16)
  call Hotf_4pt_reduction_last(G2tensor(144),RedSet_4(38),mass4set(:,17),  & 
G1tensor(324),G1tensor(387),G1tensor(378),G1tensor(1202),G1tensor(393))
  call G_TensorShift(G1tensor(387),19)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(35),mass4set(:,10),  & 
G1tensor(384),G1tensor(395),G1tensor(365),G1tensor(1455),G1tensor(371))
  call G_TensorShift(G1tensor(395),16)
  call Hotf_4pt_reduction_last(G2tensor(143),RedSet_4(38),mass4set(:,10),  & 
G1tensor(357),G1tensor(429),G1tensor(411),G1tensor(400),G1tensor(435))
  call G_TensorShift(G1tensor(429),19)
  call Hotf_4pt_reduction_last(G2tensor(217),RedSet_4(35),mass4set(:,20),  & 
G1tensor(417),G1tensor(401),G1tensor(402),G1tensor(1414),G1tensor(694))
  call G_TensorShift(G1tensor(401),16)
  call Hotf_4pt_reduction_last(G2tensor(145),RedSet_4(38),mass4set(:,20),  & 
G1tensor(472),G1tensor(412),G1tensor(406),G1tensor(911),G1tensor(700))
  call G_TensorShift(G1tensor(412),19)
  call Hotf_4pt_reduction_last(G2tensor(154),RedSet_4(41),mass4set(:,2),  & 
G1tensor(418),G1tensor(407),G1tensor(408),G1tensor(1277),G1tensor(917))
  call G_TensorShift(G1tensor(407),16)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(45),mass4set(:,2),  & 
G1tensor(479),G1tensor(419),G1tensor(413),G1tensor(414),G1tensor(462))
  call G_TensorShift(G1tensor(419),16)
  call Hotf_4pt_reduction_last(G2tensor(156),RedSet_4(41),mass4set(:,10),  & 
G1tensor(420),G1tensor(1426),G1tensor(706),G1tensor(502),G1tensor(430))
  call G_TensorShift(G1tensor(1426),16)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(45),mass4set(:,10),  & 
G1tensor(424),G1tensor(712),G1tensor(436),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(712),16)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(45),mass4set(:,17),  & 
G1tensor(1283),G1tensor(929),G1tensor(509),G1tensor(437),G1tensor(431))
  call G_TensorShift(G1tensor(929),16)
  call Hotf_4pt_reduction_last(G2tensor(155),RedSet_4(41),mass4set(:,17),  & 
G1tensor(432),G1tensor(498),G1tensor(438),G1tensor(489),G1tensor(453))
  call G_TensorShift(G1tensor(498),16)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(45),mass4set(:,20),  & 
G1tensor(442),G1tensor(495),G1tensor(459),G1tensor(443),G1tensor(1420))
  call G_TensorShift(G1tensor(495),16)
  call Hotf_4pt_reduction_last(G2tensor(157),RedSet_4(41),mass4set(:,20),  & 
G1tensor(724),G1tensor(520),G1tensor(454),G1tensor(448),G1tensor(730))
  call G_TensorShift(G1tensor(520),16)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(41),mass4set(:,16),  & 
G1tensor(460),G1tensor(449),G1tensor(1289),G1tensor(959),G1tensor(527))
  call G_TensorShift(G1tensor(449),16)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(18),mass4set(:,8),  & 
G1tensor(461),G1tensor(455),G1tensor(507),G1tensor(477),G1tensor(467))
  call G_TensorShift(G1tensor(455),16)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(45),mass4set(:,16),  & 
G1tensor(468),G1tensor(742),G1tensor(478),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(742),16)
  call Hotf_4pt_reduction_last(G2tensor(323),RedSet_4(22),mass4set(:,6),  & 
G1tensor(528),G1tensor(480),G1tensor(1432),G1tensor(748),G1tensor(532))
  call G_TensorShift(G1tensor(480),16)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(25),mass4set(:,16),  & 
G1tensor(490),G1tensor(484),G1tensor(754),G1tensor(496),G1tensor(485))
  call G_TensorShift(G1tensor(484),16)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(55),mass4set(:,2),  & 
G1tensor(1295),G1tensor(977),G1tensor(539),G1tensor(497),G1tensor(491))
  call G_TensorShift(G1tensor(977),16)
  call Hotf_4pt_reduction_last(G2tensor(130),RedSet_4(55),mass4set(:,17),  & 
G1tensor(760),G1tensor(508),G1tensor(503),G1tensor(504),G1tensor(540))
  call G_TensorShift(G1tensor(508),16)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(55),mass4set(:,10),  & 
G1tensor(510),G1tensor(537),G1tensor(525),G1tensor(515),G1tensor(772))
  call G_TensorShift(G1tensor(537),16)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(55),mass4set(:,20),  & 
G1tensor(526),G1tensor(521),G1tensor(778),G1tensor(538),G1tensor(533))
  call G_TensorShift(G1tensor(521),16)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(3),mass4set(:,8),  & 
G1tensor(1071),G1tensor(591),G1tensor(549),G1tensor(543),G1tensor(597))
  call G_TensorShift(G1tensor(591),16)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(55),mass4set(:,16),  & 
G1tensor(555),G1tensor(544),G1tensor(603),G1tensor(561),G1tensor(545))
  call G_TensorShift(G1tensor(544),16)
  call Hotf_4pt_reduction_last(G2tensor(332),RedSet_4(7),mass4set(:,6),  & 
G1tensor(546),G1tensor(1306),G1tensor(1078),G1tensor(616),G1tensor(556))
  call G_TensorShift(G1tensor(1306),16)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(10),mass4set(:,16),  & 
G1tensor(550),G1tensor(1084),G1tensor(791),G1tensor(562),G1tensor(551))
  call G_TensorShift(G1tensor(1084),16)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(71),mass4set(:,2),  & 
G1tensor(552),G1tensor(1385),G1tensor(797),G1tensor(623),G1tensor(563))
  call G_TensorShift(G1tensor(1385),16)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(71),mass4set(:,10),  & 
G1tensor(557),G1tensor(558),G1tensor(1089),G1tensor(627),G1tensor(573))
  call G_TensorShift(G1tensor(558),16)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(71),mass4set(:,17),  & 
G1tensor(567),G1tensor(633),G1tensor(579),G1tensor(568),G1tensor(639))
  call G_TensorShift(G1tensor(633),16)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(71),mass4set(:,20),  & 
G1tensor(585),G1tensor(569),G1tensor(1312),G1tensor(1096),G1tensor(652))
  call G_TensorShift(G1tensor(569),16)
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(152),mass4set(:,2),  & 
G1tensor(580),G1tensor(574),G1tensor(809),G1tensor(586),G1tensor(575))
  call G_TensorShift(G1tensor(574),4)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(107),mass4set(:,2),  & 
G1tensor(1397),G1tensor(815),G1tensor(659),G1tensor(587),G1tensor(581))
  call G_TensorShift(G1tensor(815),8)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(108),mass4set(:,2),  & 
G1tensor(1318),G1tensor(1120),G1tensor(664),G1tensor(598),G1tensor(592))
  call G_TensorShift(G1tensor(1120),8)
  call Hotf_4pt_reduction_last(G2tensor(260),RedSet_4(109),mass4set(:,2),  & 
G1tensor(821),G1tensor(604),G1tensor(593),G1tensor(594),G1tensor(1391))
  call G_TensorShift(G1tensor(604),8)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(107),mass4set(:,3),  & 
G1tensor(827),G1tensor(671),G1tensor(605),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(671),8)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(108),mass4set(:,3),  & 
G1tensor(1107),G1tensor(663),G1tensor(615),G1tensor(609),G1tensor(669))
  call G_TensorShift(G1tensor(663),8)
  call Hotf_4pt_reduction_last(G2tensor(263),RedSet_4(109),mass4set(:,3),  & 
G1tensor(621),G1tensor(611),G1tensor(612),G1tensor(839),G1tensor(622))
  call G_TensorShift(G1tensor(611),8)
  call Hotf_4pt_reduction_last(G2tensor(266),RedSet_4(152),mass4set(:,10),  & 
G1tensor(617),G1tensor(618),G1tensor(1324),G1tensor(1144),G1tensor(676))
  call G_TensorShift(G1tensor(618),4)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(107),mass4set(:,12),  & 
G1tensor(634),G1tensor(628),G1tensor(845),G1tensor(640),G1tensor(629))
  call G_TensorShift(G1tensor(628),8)
  call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(108),mass4set(:,12),  & 
G1tensor(1403),G1tensor(851),G1tensor(683),G1tensor(641),G1tensor(635))
  call G_TensorShift(G1tensor(851),8)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(107),mass4set(:,21),  & 
G1tensor(1131),G1tensor(675),G1tensor(651),G1tensor(645),G1tensor(681))
  call G_TensorShift(G1tensor(675),8)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(108),mass4set(:,21),  & 
G1tensor(657),G1tensor(647),G1tensor(863),G1tensor(658),G1tensor(653))
  call G_TensorShift(G1tensor(647),8)
  call Hotf_4pt_reduction_last(G2tensor(269),RedSet_4(152),mass4set(:,11),  & 
G1tensor(869),G1tensor(670),G1tensor(665),G1tensor(666),G1tensor(875))
  call G_TensorShift(G1tensor(670),4)
  call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(107),mass4set(:,22),  & 
G1tensor(682),G1tensor(677),G1tensor(705),G1tensor(693),G1tensor(688))
  call G_TensorShift(G1tensor(677),8)
  call Hotf_4pt_reduction_last(G2tensor(121),RedSet_4(108),mass4set(:,22),  & 
G1tensor(711),G1tensor(699),G1tensor(689),G1tensor(690),G1tensor(1307))
  call G_TensorShift(G1tensor(699),8)
  call Hotf_4pt_reduction_last(G2tensor(272),RedSet_4(109),mass4set(:,4),  & 
G1tensor(1031),G1tensor(743),G1tensor(701),G1tensor(695),G1tensor(696))
  call G_TensorShift(G1tensor(743),8)
  call Hotf_4pt_reduction_last(G2tensor(290),RedSet_4(153),mass4set(:,2),  & 
G1tensor(732),G1tensor(702),G1tensor(1319),G1tensor(1037),G1tensor(761))
  call G_TensorShift(G1tensor(702),8)
  call Hotf_4pt_reduction_last(G2tensor(123),RedSet_4(112),mass4set(:,2),  & 
G1tensor(713),G1tensor(707),G1tensor(708),G1tensor(756),G1tensor(714))
  call G_TensorShift(G1tensor(707),4)
  call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(113),mass4set(:,2),  & 
G1tensor(747),G1tensor(723),G1tensor(718),G1tensor(753),G1tensor(729))
  call G_TensorShift(G1tensor(723),4)
  call Hotf_4pt_reduction_last(G2tensor(293),RedSet_4(114),mass4set(:,2),  & 
G1tensor(719),G1tensor(1313),G1tensor(1055),G1tensor(773),G1tensor(731))
  call G_TensorShift(G1tensor(1313),4)
  call Hotf_4pt_reduction_last(G2tensor(296),RedSet_4(153),mass4set(:,10),  & 
G1tensor(725),G1tensor(759),G1tensor(741),G1tensor(737),G1tensor(738))
  call G_TensorShift(G1tensor(759),8)
  call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(112),mass4set(:,12),  & 
G1tensor(774),G1tensor(744),G1tensor(1325),G1tensor(1061),G1tensor(779))
  call G_TensorShift(G1tensor(744),4)
  call Hotf_4pt_reduction_last(G2tensor(129),RedSet_4(113),mass4set(:,12),  & 
G1tensor(755),G1tensor(749),G1tensor(780),G1tensor(762),G1tensor(777))
  call G_TensorShift(G1tensor(749),4)
  call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(112),mass4set(:,3),  & 
G1tensor(771),G1tensor(767),G1tensor(1167),G1tensor(819),G1tensor(789))
  call G_TensorShift(G1tensor(767),4)
  call Hotf_4pt_reduction_last(G2tensor(133),RedSet_4(113),mass4set(:,3),  & 
G1tensor(783),G1tensor(825),G1tensor(795),G1tensor(784),G1tensor(786))
  call G_TensorShift(G1tensor(825),4)
  call Hotf_4pt_reduction_last(G2tensor(299),RedSet_4(114),mass4set(:,3),  & 
G1tensor(1276),G1tensor(1174),G1tensor(838),G1tensor(796),G1tensor(790))
  call G_TensorShift(G1tensor(1174),4)
  call Hotf_4pt_reduction_last(G2tensor(134),RedSet_4(112),mass4set(:,21),  & 
G1tensor(792),G1tensor(798),G1tensor(1179),G1tensor(843),G1tensor(807))
  call G_TensorShift(G1tensor(798),4)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(113),mass4set(:,21),  & 
G1tensor(801),G1tensor(849),G1tensor(813),G1tensor(802),G1tensor(1288))
  call G_TensorShift(G1tensor(849),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(151),mass4set(:,16),  & 
G1tensor(1186),G1tensor(862),G1tensor(814),G1tensor(808),G1tensor(1282))
  call G_TensorShift(G1tensor(862),4)
  call Hotf_4pt_reduction_last(G2tensor(137),RedSet_4(102),mass4set(:,22),  & 
G1tensor(1198),G1tensor(868),G1tensor(826),G1tensor(820),G1tensor(822))
  call G_TensorShift(G1tensor(868),8)
  call Hotf_4pt_reduction_last(G2tensor(242),RedSet_4(88),mass4set(:,1),  & 
G1tensor(828),G1tensor(1191),G1tensor(867),G1tensor(837),G1tensor(831))
  call G_TensorShift(G1tensor(1191),8)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(103),mass4set(:,5),  & 
G1tensor(834),G1tensor(840),G1tensor(1294),G1tensor(1210),G1tensor(874))
  call G_TensorShift(G1tensor(840),8)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(116),mass4set(:,2),  & 
G1tensor(850),G1tensor(844),G1tensor(1203),G1tensor(873),G1tensor(861))
  call G_TensorShift(G1tensor(844),16)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(116),mass4set(:,10),  & 
G1tensor(855),G1tensor(870),G1tensor(885),G1tensor(879),G1tensor(880))
  call G_TensorShift(G1tensor(870),16)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(116),mass4set(:,11),  & 
G1tensor(897),G1tensor(881),G1tensor(1300),G1tensor(892),G1tensor(886))
  call G_TensorShift(G1tensor(881),16)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(119),mass4set(:,2),  & 
G1tensor(898),G1tensor(887),G1tensor(1409),G1tensor(899),G1tensor(893))
  call G_TensorShift(G1tensor(887),16)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(119),mass4set(:,10),  & 
G1tensor(927),G1tensor(915),G1tensor(904),G1tensor(906),G1tensor(1384))
  call G_TensorShift(G1tensor(915),16)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(122),mass4set(:,2),  & 
G1tensor(1030),G1tensor(940),G1tensor(916),G1tensor(910),G1tensor(912))
  call G_TensorShift(G1tensor(940),12)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(123),mass4set(:,2),  & 
G1tensor(918),G1tensor(1390),G1tensor(1036),G1tensor(964),G1tensor(928))
  call G_TensorShift(G1tensor(1390),12)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(110),mass4set(:,17),  & 
G1tensor(922),G1tensor(924),G1tensor(930),G1tensor(936),G1tensor(942))
  call G_TensorShift(G1tensor(924),12)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(123),mass4set(:,17),  & 
G1tensor(975),G1tensor(957),G1tensor(946),G1tensor(1396),G1tensor(1054))
  call G_TensorShift(G1tensor(957),12)
  call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(122),mass4set(:,12),  & 
G1tensor(988),G1tensor(958),G1tensor(952),G1tensor(966),G1tensor(1402))
  call G_TensorShift(G1tensor(958),12)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(110),mass4set(:,12),  & 
G1tensor(1060),G1tensor(994),G1tensor(976),G1tensor(970),G1tensor(1000))
  call G_TensorShift(G1tensor(994),12)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(110),mass4set(:,23),  & 
G1tensor(1017),G1tensor(1001),G1tensor(1408),G1tensor(1012),G1tensor(1006))
  call G_TensorShift(G1tensor(1001),12)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(122),mass4set(:,13),  & 
G1tensor(1018),G1tensor(1007),G1tensor(1301),G1tensor(1019),G1tensor(1013))
  call G_TensorShift(G1tensor(1007),12)
  call Hotf_4pt_reduction_last(G2tensor(350),RedSet_4(110),mass4set(:,7),  & 
G1tensor(1035),G1tensor(1029),G1tensor(1024),G1tensor(1026),G1tensor(1032))
  call G_TensorShift(G1tensor(1029),12)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(123),mass4set(:,19),  & 
G1tensor(1038),G1tensor(1044),G1tensor(1059),G1tensor(1053),G1tensor(1048))
  call G_TensorShift(G1tensor(1044),12)
  call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(125),mass4set(:,2),  & 
G1tensor(1108),G1tensor(1077),G1tensor(1072),G1tensor(1125),G1tensor(1083))
  call G_TensorShift(G1tensor(1077),12)
  call Hotf_4pt_reduction_last(G2tensor(118),RedSet_4(126),mass4set(:,2),  & 
G1tensor(1073),G1tensor(1074),G1tensor(1415),G1tensor(1175),G1tensor(1115))
  call G_TensorShift(G1tensor(1074),12)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(125),mass4set(:,12),  & 
G1tensor(1085),G1tensor(1079),G1tensor(1080),G1tensor(1132),G1tensor(1095))
  call G_TensorShift(G1tensor(1079),12)
  call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(126),mass4set(:,17),  & 
G1tensor(1090),G1tensor(1149),G1tensor(1101),G1tensor(1091),G1tensor(1421))
  call G_TensorShift(G1tensor(1149),12)
  call Hotf_4pt_reduction_last(G2tensor(124),RedSet_4(128),mass4set(:,2),  & 
G1tensor(1187),G1tensor(1139),G1tensor(1103),G1tensor(1097),G1tensor(1155))
  call G_TensorShift(G1tensor(1139),16)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(128),mass4set(:,10),  & 
G1tensor(1113),G1tensor(1109),G1tensor(1110),G1tensor(1427),G1tensor(1199))
  call G_TensorShift(G1tensor(1109),16)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(128),mass4set(:,11),  & 
G1tensor(1157),G1tensor(1127),G1tensor(1121),G1tensor(1122),G1tensor(1161))
  call G_TensorShift(G1tensor(1127),16)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(131),mass4set(:,2),  & 
G1tensor(1137),G1tensor(1133),G1tensor(1433),G1tensor(1211),G1tensor(1163))
  call G_TensorShift(G1tensor(1133),16)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(131),mass4set(:,10),  & 
G1tensor(1151),G1tensor(1145),G1tensor(1192),G1tensor(1173),G1tensor(1168))
  call G_TensorShift(G1tensor(1145),16)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(135),mass4set(:,2),  & 
G1tensor(1170),G1tensor(1176),G1tensor(1204),G1tensor(1185),G1tensor(1180))
  call G_TensorShift(G1tensor(1176),8)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(135),mass4set(:,10),  & 
G1tensor(1194),G1tensor(1200),G1tensor(1220),G1tensor(1214),G1tensor(1215))
  call G_TensorShift(G1tensor(1200),8)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(136),mass4set(:,10),  & 
G1tensor(1216),G1tensor(1229),G1tensor(1217),G1tensor(1221),G1tensor(1222))
  call G_TensorShift(G1tensor(1229),8)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(136),mass4set(:,12),  & 
G1tensor(1235),G1tensor(1223),G1tensor(1232),G1tensor(1226),G1tensor(1227))
  call G_TensorShift(G1tensor(1223),8)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(136),mass4set(:,24),  & 
G1tensor(1228),G1tensor(1233),G1tensor(1234),G1tensor(1238),G1tensor(1239))
  call G_TensorShift(G1tensor(1233),8)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(139),mass4set(:,2),  & 
G1tensor(1240),G1tensor(1241),G1tensor(1256),G1tensor(1244),G1tensor(1245))
  call G_TensorShift(G1tensor(1241),8)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(139),mass4set(:,10),  & 
G1tensor(1246),G1tensor(1253),G1tensor(1247),G1tensor(1262),G1tensor(1250))
  call G_TensorShift(G1tensor(1253),8)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(139),mass4set(:,11),  & 
G1tensor(1251),G1tensor(1252),G1tensor(1257),G1tensor(1258),G1tensor(1265))
  call G_TensorShift(G1tensor(1252),8)
  call Hotf_4pt_reduction_last(G2tensor(359),RedSet_4(136),mass4set(:,8),  & 
G1tensor(1259),G1tensor(1263),G1tensor(1264),G1tensor(1268),G1tensor(1269))
  call G_TensorShift(G1tensor(1263),8)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(142),mass4set(:,2),  & 
G1tensor(1270),G1tensor(1271),G1tensor(1281),G1tensor(1275),G1tensor(1293))
  call G_TensorShift(G1tensor(1271),2)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(142),mass4set(:,10),  & 
G1tensor(1287),G1tensor(1299),G1tensor(1317),G1tensor(1305),G1tensor(1323))
  call G_TensorShift(G1tensor(1299),2)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(143),mass4set(:,10),  & 
G1tensor(1311),G1tensor(1335),G1tensor(1329),G1tensor(1343),G1tensor(1331))
  call G_TensorShift(G1tensor(1335),2)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(143),mass4set(:,12),  & 
G1tensor(1372),G1tensor(1336),G1tensor(1349),G1tensor(1337),G1tensor(1347))
  call G_TensorShift(G1tensor(1336),2)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(143),mass4set(:,24),  & 
G1tensor(1341),G1tensor(1366),G1tensor(1342),G1tensor(1378),G1tensor(1348))
  call G_TensorShift(G1tensor(1366),2)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(146),mass4set(:,2),  & 
G1tensor(1353),G1tensor(1354),G1tensor(1355),G1tensor(1371),G1tensor(1359))
  call G_TensorShift(G1tensor(1354),2)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(146),mass4set(:,10),  & 
G1tensor(1367),G1tensor(1361),G1tensor(1377),G1tensor(1365),G1tensor(1379))
  call G_TensorShift(G1tensor(1361),2)
  call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(146),mass4set(:,11),  & 
G1tensor(1373),G1tensor(1389),G1tensor(1383),G1tensor(1401),G1tensor(1395))
  call G_TensorShift(G1tensor(1389),2)
  call Hotf_4pt_reduction_last(G2tensor(368),RedSet_4(143),mass4set(:,8),  & 
G1tensor(1407),G1tensor(1425),G1tensor(1413),G1tensor(1431),G1tensor(1419))
  call G_TensorShift(G1tensor(1425),2)
  call Hotf_4pt_reduction_last(G2tensor(254),RedSet_4(7),mass4set(:,3),  & 
G1tensor(1450),G1tensor(1438),G1tensor(1456),G1tensor(1444),G1tensor(1475))
  call G_TensorShift(G1tensor(1438),16)
  call Hotf_4pt_reduction_last(G2tensor(275),RedSet_4(7),mass4set(:,4),  & 
G1tensor(1445),G1tensor(1469),G1tensor(1451),G1tensor(1481),G1tensor(1457))
  call G_TensorShift(G1tensor(1469),16)
  call Hotf_4pt_reduction_last(G2tensor(287),RedSet_4(22),mass4set(:,3),  & 
G1tensor(1468),G1tensor(1462),G1tensor(1480),G1tensor(1474),G1tensor(1486))
  call G_TensorShift(G1tensor(1462),16)
  call Hotf_4pt_reduction_last(G2tensor(305),RedSet_4(22),mass4set(:,4),  & 
G1tensor(1487),G1tensor(1504),G1tensor(1492),G1tensor(1510),G1tensor(1498))
  call G_TensorShift(G1tensor(1504),16)
  call Hotf_4pt_reduction_last(G2tensor(311),RedSet_4(136),mass4set(:,5),  & 
G1tensor(1523),G1tensor(1499),G1tensor(1529),G1tensor(1505),G1tensor(1535))
  call G_TensorShift(G1tensor(1499),8)
  call Hotf_4pt_reduction_last(G2tensor(317),RedSet_4(143),mass4set(:,5),  & 
G1tensor(1511),G1tensor(1528),G1tensor(1516),G1tensor(1534),G1tensor(1522))
  call G_TensorShift(G1tensor(1528),2)
  call Hotf_4pt_reduction_last(G2tensor(398),RedSet_4(88),mass4set(:,10),  & 
G1tensor(1540),G1tensor(1541),G1tensor(1543),G1tensor(1544),G1tensor(1545))
  call G_TensorShift(G1tensor(1541),8)
  call Hotf_4pt_reduction_last(G2tensor(401),RedSet_4(88),mass4set(:,11),  & 
G1tensor(1546),G1tensor(1547),G1tensor(1548),G1tensor(1549),G1tensor(1550))
  call G_TensorShift(G1tensor(1547),8)
  call Hotf_4pt_reduction_last(G2tensor(407),RedSet_4(95),mass4set(:,10),  & 
G1tensor(1551),G1tensor(1552),G1tensor(1553),G1tensor(1554),G1tensor(1555))
  call G_TensorShift(G1tensor(1552),4)
  call Hotf_4pt_reduction_last(G2tensor(410),RedSet_4(95),mass4set(:,11),  & 
G1tensor(1556),G1tensor(1557),G1tensor(1558),G1tensor(1559),G1tensor(1560))
  call G_TensorShift(G1tensor(1557),4)
  call Hotf_4pt_reduction_last(G2tensor(422),RedSet_4(90),mass4set(:,12),  & 
G1tensor(1561),G1tensor(1562),G1tensor(1563),G1tensor(1564),G1tensor(1565))
  call G_TensorShift(G1tensor(1562),12)
  call Hotf_4pt_reduction_last(G2tensor(425),RedSet_4(90),mass4set(:,13),  & 
G1tensor(1566),G1tensor(1567),G1tensor(1568),G1tensor(1569),G1tensor(1570))
  call G_TensorShift(G1tensor(1567),12)
  call Hotf_4pt_reduction_last(G2tensor(443),RedSet_4(104),mass4set(:,12),  & 
G1tensor(1571),G1tensor(1572),G1tensor(1573),G1tensor(1574),G1tensor(1575))
  call G_TensorShift(G1tensor(1572),12)
  call Hotf_4pt_reduction_last(G2tensor(446),RedSet_4(104),mass4set(:,13),  & 
G1tensor(1576),G1tensor(1577),G1tensor(1578),G1tensor(1579),G1tensor(1580))
  call G_TensorShift(G1tensor(1577),12)
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(110),mass4set(:,2),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(110),mass4set(:,3),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(326),RedSet_4(110),mass4set(:,10),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(110),mass4set(:,15),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(63),RedSet_4(110),mass4set(:,9),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(95),RedSet_4(90),mass4set(:,14),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(137),RedSet_4(104),mass4set(:,14),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(179),RedSet_4(95),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(215),RedSet_4(46),mass4set(:,7),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(28),mass4set(:,16),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(339),RedSet_4(98),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(389),RedSet_4(56),mass4set(:,7),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(86),mass4set(:,14),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(451),RedSet_4(13),mass4set(:,16),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(481),RedSet_4(148),mass4set(:,2),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(511),RedSet_4(117),mass4set(:,2),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(541),RedSet_4(148),mass4set(:,17),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(571),RedSet_4(117),mass4set(:,17),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(601),RedSet_4(148),mass4set(:,3),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(631),RedSet_4(148),mass4set(:,18),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(661),RedSet_4(148),mass4set(:,5),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(691),RedSet_4(117),mass4set(:,19),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(721),RedSet_4(136),mass4set(:,2),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(751),RedSet_4(120),mass4set(:,2),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(781),RedSet_4(136),mass4set(:,3),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(811),RedSet_4(136),mass4set(:,17),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(841),RedSet_4(120),mass4set(:,17),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(871),RedSet_4(136),mass4set(:,18),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(901),RedSet_4(51),mass4set(:,2),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(931),RedSet_4(28),mass4set(:,2),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(961),RedSet_4(51),mass4set(:,17),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(991),RedSet_4(28),mass4set(:,17),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(1021),RedSet_4(51),mass4set(:,10),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(1051),RedSet_4(28),mass4set(:,10),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(1081),RedSet_4(51),mass4set(:,20),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(1111),RedSet_4(28),mass4set(:,20),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(1141),RedSet_4(51),mass4set(:,16),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(1171),RedSet_4(1),mass4set(:,2),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(1201),RedSet_4(74),mass4set(:,2),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(1231),RedSet_4(1),mass4set(:,10),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(1261),RedSet_4(74),mass4set(:,10),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(1291),RedSet_4(1),mass4set(:,17),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(1321),RedSet_4(74),mass4set(:,17),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(1351),RedSet_4(1),mass4set(:,20),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(1381),RedSet_4(74),mass4set(:,20),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(1411),RedSet_4(149),mass4set(:,2),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(1441),RedSet_4(129),mass4set(:,2),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(1471),RedSet_4(149),mass4set(:,17),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(1501),RedSet_4(129),mass4set(:,17),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(1531),RedSet_4(149),mass4set(:,3),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(1218),RedSet_4(149),mass4set(:,18),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(1266),RedSet_4(149),mass4set(:,5),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(896),RedSet_4(129),mass4set(:,19),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(884),RedSet_4(143),mass4set(:,2),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(1004),RedSet_4(132),mass4set(:,2),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(1020),RedSet_4(143),mass4set(:,3),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(1296),RedSet_4(143),mass4set(:,17),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(1302),RedSet_4(132),mass4set(:,17),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(1308),RedSet_4(143),mass4set(:,18),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(1322),RedSet_4(83),mass4set(:,2),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(903),RedSet_4(137),mass4set(:,2),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(1041),RedSet_4(83),mass4set(:,3),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(642),RedSet_4(83),mass4set(:,12),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(951),RedSet_4(137),mass4set(:,12),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(1346),RedSet_4(83),mass4set(:,21),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(1350),RedSet_4(97),mass4set(:,2),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(999),RedSet_4(140),mass4set(:,2),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(399),RedSet_4(97),mass4set(:,12),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(717),RedSet_4(140),mass4set(:,12),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(1140),RedSet_4(97),mass4set(:,3),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(471),RedSet_4(97),mass4set(:,21),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(1376),RedSet_4(97),mass4set(:,22),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(1380),RedSet_4(140),mass4set(:,13),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(1386),RedSet_4(87),mass4set(:,2),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(1400),RedSet_4(144),mass4set(:,2),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(1412),RedSet_4(87),mass4set(:,3),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(1434),RedSet_4(87),mass4set(:,12),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(49),RedSet_4(144),mass4set(:,12),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(440),RedSet_4(87),mass4set(:,21),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(193),RedSet_4(94),mass4set(:,2),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(512),RedSet_4(147),mass4set(:,2),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(168),RedSet_4(94),mass4set(:,3),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(932),RedSet_4(94),mass4set(:,12),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(1472),RedSet_4(147),mass4set(:,12),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(980),RedSet_4(94),mass4set(:,21),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(143),RedSet_4(94),mass4set(:,22),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(147),mass4set(:,13),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(79),RedSet_4(154),mass4set(:,2),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(404),RedSet_4(84),mass4set(:,2),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(410),RedSet_4(85),mass4set(:,2),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(86),mass4set(:,2),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(154),mass4set(:,17),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(422),RedSet_4(84),mass4set(:,17),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(428),RedSet_4(85),mass4set(:,17),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(434),RedSet_4(86),mass4set(:,17),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(446),RedSet_4(84),mass4set(:,3),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(452),RedSet_4(85),mass4set(:,3),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(458),RedSet_4(86),mass4set(:,3),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call Hotf_4pt_reduction_last(G1tensor(223),RedSet_4(154),mass4set(:,10),  & 
G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495))
  call Hotf_4pt_reduction_last(G1tensor(470),RedSet_4(84),mass4set(:,12),  & 
G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500))
  call Hotf_4pt_reduction_last(G1tensor(476),RedSet_4(86),mass4set(:,10),  & 
G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505))
  call Hotf_4pt_reduction_last(G1tensor(482),RedSet_4(84),mass4set(:,18),  & 
G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510))
  call Hotf_4pt_reduction_last(G1tensor(488),RedSet_4(85),mass4set(:,18),  & 
G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515))
  call Hotf_4pt_reduction_last(G1tensor(494),RedSet_4(86),mass4set(:,18),  & 
G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520))
  call Hotf_4pt_reduction_last(G1tensor(259),RedSet_4(154),mass4set(:,20),  & 
G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525))
  call Hotf_4pt_reduction_last(G1tensor(500),RedSet_4(84),mass4set(:,23),  & 
G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530))
  call Hotf_4pt_reduction_last(G1tensor(506),RedSet_4(86),mass4set(:,20),  & 
G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),G0tensor(535))
  call Hotf_4pt_reduction_last(G1tensor(518),RedSet_4(84),mass4set(:,21),  & 
G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),G0tensor(540))
  call Hotf_4pt_reduction_last(G1tensor(524),RedSet_4(86),mass4set(:,15),  & 
G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544),G0tensor(545))
  call Hotf_4pt_reduction_last(G1tensor(530),RedSet_4(84),mass4set(:,25),  & 
G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549),G0tensor(550))
  call Hotf_4pt_reduction_last(G1tensor(536),RedSet_4(86),mass4set(:,26),  & 
G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554),G0tensor(555))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(150),mass4set(:,2),  & 
G0tensor(556),G0tensor(557),G0tensor(558),G0tensor(559),G0tensor(560))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(88),mass4set(:,2),  & 
G0tensor(561),G0tensor(562),G0tensor(563),G0tensor(564),G0tensor(565))
  call Hotf_4pt_reduction_last(G1tensor(554),RedSet_4(89),mass4set(:,2),  & 
G0tensor(566),G0tensor(567),G0tensor(568),G0tensor(569),G0tensor(570))
  call Hotf_4pt_reduction_last(G1tensor(158),RedSet_4(90),mass4set(:,2),  & 
G0tensor(571),G0tensor(572),G0tensor(573),G0tensor(574),G0tensor(575))
  call Hotf_4pt_reduction_last(G1tensor(572),RedSet_4(88),mass4set(:,3),  & 
G0tensor(576),G0tensor(577),G0tensor(578),G0tensor(579),G0tensor(580))
  call Hotf_4pt_reduction_last(G1tensor(578),RedSet_4(89),mass4set(:,3),  & 
G0tensor(581),G0tensor(582),G0tensor(583),G0tensor(584),G0tensor(585))
  call Hotf_4pt_reduction_last(G1tensor(584),RedSet_4(90),mass4set(:,3),  & 
G0tensor(586),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590))
  call Hotf_4pt_reduction_last(G1tensor(27),RedSet_4(150),mass4set(:,17),  & 
G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594),G0tensor(595))
  call Hotf_4pt_reduction_last(G1tensor(590),RedSet_4(88),mass4set(:,17),  & 
G0tensor(596),G0tensor(597),G0tensor(598),G0tensor(599),G0tensor(600))
  call Hotf_4pt_reduction_last(G1tensor(596),RedSet_4(89),mass4set(:,17),  & 
G0tensor(601),G0tensor(602),G0tensor(603),G0tensor(604),G0tensor(605))
  call Hotf_4pt_reduction_last(G1tensor(602),RedSet_4(90),mass4set(:,17),  & 
G0tensor(606),G0tensor(607),G0tensor(608),G0tensor(609),G0tensor(610))
  call Hotf_4pt_reduction_last(G1tensor(45),RedSet_4(150),mass4set(:,10),  & 
G0tensor(611),G0tensor(612),G0tensor(613),G0tensor(614),G0tensor(615))
  call Hotf_4pt_reduction_last(G1tensor(614),RedSet_4(88),mass4set(:,12),  & 
G0tensor(616),G0tensor(617),G0tensor(618),G0tensor(619),G0tensor(620))
  call Hotf_4pt_reduction_last(G1tensor(620),RedSet_4(90),mass4set(:,10),  & 
G0tensor(621),G0tensor(622),G0tensor(623),G0tensor(624),G0tensor(625))
  call Hotf_4pt_reduction_last(G1tensor(626),RedSet_4(88),mass4set(:,18),  & 
G0tensor(626),G0tensor(627),G0tensor(628),G0tensor(629),G0tensor(630))
  call Hotf_4pt_reduction_last(G1tensor(632),RedSet_4(89),mass4set(:,18),  & 
G0tensor(631),G0tensor(632),G0tensor(633),G0tensor(634),G0tensor(635))
  call Hotf_4pt_reduction_last(G1tensor(638),RedSet_4(90),mass4set(:,18),  & 
G0tensor(636),G0tensor(637),G0tensor(638),G0tensor(639),G0tensor(640))
  call Hotf_4pt_reduction_last(G1tensor(650),RedSet_4(88),mass4set(:,21),  & 
G0tensor(641),G0tensor(642),G0tensor(643),G0tensor(644),G0tensor(645))
  call Hotf_4pt_reduction_last(G1tensor(656),RedSet_4(90),mass4set(:,15),  & 
G0tensor(646),G0tensor(647),G0tensor(648),G0tensor(649),G0tensor(650))
  call Hotf_4pt_reduction_last(G1tensor(234),RedSet_4(150),mass4set(:,20),  & 
G0tensor(651),G0tensor(652),G0tensor(653),G0tensor(654),G0tensor(655))
  call Hotf_4pt_reduction_last(G1tensor(662),RedSet_4(88),mass4set(:,23),  & 
G0tensor(656),G0tensor(657),G0tensor(658),G0tensor(659),G0tensor(660))
  call Hotf_4pt_reduction_last(G1tensor(668),RedSet_4(90),mass4set(:,20),  & 
G0tensor(661),G0tensor(662),G0tensor(663),G0tensor(664),G0tensor(665))
  call Hotf_4pt_reduction_last(G1tensor(674),RedSet_4(88),mass4set(:,25),  & 
G0tensor(666),G0tensor(667),G0tensor(668),G0tensor(669),G0tensor(670))
  call Hotf_4pt_reduction_last(G1tensor(680),RedSet_4(90),mass4set(:,26),  & 
G0tensor(671),G0tensor(672),G0tensor(673),G0tensor(674),G0tensor(675))
  call Hotf_4pt_reduction_last(G1tensor(260),RedSet_4(155),mass4set(:,2),  & 
G0tensor(676),G0tensor(677),G0tensor(678),G0tensor(679),G0tensor(680))
  call Hotf_4pt_reduction_last(G1tensor(686),RedSet_4(91),mass4set(:,2),  & 
G0tensor(681),G0tensor(682),G0tensor(683),G0tensor(684),G0tensor(685))
  call Hotf_4pt_reduction_last(G1tensor(692),RedSet_4(92),mass4set(:,2),  & 
G0tensor(686),G0tensor(687),G0tensor(688),G0tensor(689),G0tensor(690))
  call Hotf_4pt_reduction_last(G1tensor(698),RedSet_4(93),mass4set(:,2),  & 
G0tensor(691),G0tensor(692),G0tensor(693),G0tensor(694),G0tensor(695))
  call Hotf_4pt_reduction_last(G1tensor(332),RedSet_4(155),mass4set(:,17),  & 
G0tensor(696),G0tensor(697),G0tensor(698),G0tensor(699),G0tensor(700))
  call Hotf_4pt_reduction_last(G1tensor(704),RedSet_4(92),mass4set(:,17),  & 
G0tensor(701),G0tensor(702),G0tensor(703),G0tensor(704),G0tensor(705))
  call Hotf_4pt_reduction_last(G1tensor(710),RedSet_4(93),mass4set(:,17),  & 
G0tensor(706),G0tensor(707),G0tensor(708),G0tensor(709),G0tensor(710))
  call Hotf_4pt_reduction_last(G1tensor(716),RedSet_4(91),mass4set(:,3),  & 
G0tensor(711),G0tensor(712),G0tensor(713),G0tensor(714),G0tensor(715))
  call Hotf_4pt_reduction_last(G1tensor(722),RedSet_4(92),mass4set(:,3),  & 
G0tensor(716),G0tensor(717),G0tensor(718),G0tensor(719),G0tensor(720))
  call Hotf_4pt_reduction_last(G1tensor(728),RedSet_4(93),mass4set(:,3),  & 
G0tensor(721),G0tensor(722),G0tensor(723),G0tensor(724),G0tensor(725))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(155),mass4set(:,10),  & 
G0tensor(726),G0tensor(727),G0tensor(728),G0tensor(729),G0tensor(730))
  call Hotf_4pt_reduction_last(G1tensor(734),RedSet_4(91),mass4set(:,12),  & 
G0tensor(731),G0tensor(732),G0tensor(733),G0tensor(734),G0tensor(735))
  call Hotf_4pt_reduction_last(G1tensor(740),RedSet_4(93),mass4set(:,10),  & 
G0tensor(736),G0tensor(737),G0tensor(738),G0tensor(739),G0tensor(740))
  call Hotf_4pt_reduction_last(G1tensor(746),RedSet_4(92),mass4set(:,18),  & 
G0tensor(741),G0tensor(742),G0tensor(743),G0tensor(744),G0tensor(745))
  call Hotf_4pt_reduction_last(G1tensor(752),RedSet_4(93),mass4set(:,18),  & 
G0tensor(746),G0tensor(747),G0tensor(748),G0tensor(749),G0tensor(750))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(155),mass4set(:,20),  & 
G0tensor(751),G0tensor(752),G0tensor(753),G0tensor(754),G0tensor(755))
  call Hotf_4pt_reduction_last(G1tensor(758),RedSet_4(93),mass4set(:,20),  & 
G0tensor(756),G0tensor(757),G0tensor(758),G0tensor(759),G0tensor(760))
  call Hotf_4pt_reduction_last(G1tensor(764),RedSet_4(91),mass4set(:,21),  & 
G0tensor(761),G0tensor(762),G0tensor(763),G0tensor(764),G0tensor(765))
  call Hotf_4pt_reduction_last(G1tensor(770),RedSet_4(93),mass4set(:,15),  & 
G0tensor(766),G0tensor(767),G0tensor(768),G0tensor(769),G0tensor(770))
  call Hotf_4pt_reduction_last(G1tensor(776),RedSet_4(93),mass4set(:,26),  & 
G0tensor(771),G0tensor(772),G0tensor(773),G0tensor(774),G0tensor(775))
  call Hotf_4pt_reduction_last(G1tensor(75),RedSet_4(138),mass4set(:,2),  & 
G0tensor(776),G0tensor(777),G0tensor(778),G0tensor(779),G0tensor(780))
  call Hotf_4pt_reduction_last(G1tensor(1542),RedSet_4(95),mass4set(:,2),  & 
G0tensor(781),G0tensor(782),G0tensor(783),G0tensor(784),G0tensor(785))
  call Hotf_4pt_reduction_last(G1tensor(794),RedSet_4(96),mass4set(:,2),  & 
G0tensor(786),G0tensor(787),G0tensor(788),G0tensor(789),G0tensor(790))
  call Hotf_4pt_reduction_last(G1tensor(806),RedSet_4(95),mass4set(:,3),  & 
G0tensor(791),G0tensor(792),G0tensor(793),G0tensor(794),G0tensor(795))
  call Hotf_4pt_reduction_last(G1tensor(812),RedSet_4(96),mass4set(:,3),  & 
G0tensor(796),G0tensor(797),G0tensor(798),G0tensor(799),G0tensor(800))
  call Hotf_4pt_reduction_last(G1tensor(25),RedSet_4(138),mass4set(:,17),  & 
G0tensor(801),G0tensor(802),G0tensor(803),G0tensor(804),G0tensor(805))
  call Hotf_4pt_reduction_last(G1tensor(818),RedSet_4(95),mass4set(:,17),  & 
G0tensor(806),G0tensor(807),G0tensor(808),G0tensor(809),G0tensor(810))
  call Hotf_4pt_reduction_last(G1tensor(824),RedSet_4(96),mass4set(:,17),  & 
G0tensor(811),G0tensor(812),G0tensor(813),G0tensor(814),G0tensor(815))
  call Hotf_4pt_reduction_last(G1tensor(55),RedSet_4(138),mass4set(:,10),  & 
G0tensor(816),G0tensor(817),G0tensor(818),G0tensor(819),G0tensor(820))
  call Hotf_4pt_reduction_last(G1tensor(836),RedSet_4(95),mass4set(:,12),  & 
G0tensor(821),G0tensor(822),G0tensor(823),G0tensor(824),G0tensor(825))
  call Hotf_4pt_reduction_last(G1tensor(842),RedSet_4(95),mass4set(:,18),  & 
G0tensor(826),G0tensor(827),G0tensor(828),G0tensor(829),G0tensor(830))
  call Hotf_4pt_reduction_last(G1tensor(848),RedSet_4(96),mass4set(:,18),  & 
G0tensor(831),G0tensor(832),G0tensor(833),G0tensor(834),G0tensor(835))
  call Hotf_4pt_reduction_last(G1tensor(860),RedSet_4(95),mass4set(:,21),  & 
G0tensor(836),G0tensor(837),G0tensor(838),G0tensor(839),G0tensor(840))
  call Hotf_4pt_reduction_last(G1tensor(272),RedSet_4(138),mass4set(:,20),  & 
G0tensor(841),G0tensor(842),G0tensor(843),G0tensor(844),G0tensor(845))
  call Hotf_4pt_reduction_last(G1tensor(866),RedSet_4(95),mass4set(:,23),  & 
G0tensor(846),G0tensor(847),G0tensor(848),G0tensor(849),G0tensor(850))
  call Hotf_4pt_reduction_last(G1tensor(872),RedSet_4(95),mass4set(:,25),  & 
G0tensor(851),G0tensor(852),G0tensor(853),G0tensor(854),G0tensor(855))
  call Hotf_4pt_reduction_last(G1tensor(103),RedSet_4(138),mass4set(:,16),  & 
G0tensor(856),G0tensor(857),G0tensor(858),G0tensor(859),G0tensor(860))
  call Hotf_4pt_reduction_last(G1tensor(139),RedSet_4(96),mass4set(:,5),  & 
G0tensor(861),G0tensor(862),G0tensor(863),G0tensor(864),G0tensor(865))
  call Hotf_4pt_reduction_last(G1tensor(102),RedSet_4(145),mass4set(:,2),  & 
G0tensor(866),G0tensor(867),G0tensor(868),G0tensor(869),G0tensor(870))
  call Hotf_4pt_reduction_last(G1tensor(908),RedSet_4(98),mass4set(:,2),  & 
G0tensor(871),G0tensor(872),G0tensor(873),G0tensor(874),G0tensor(875))
  call Hotf_4pt_reduction_last(G1tensor(914),RedSet_4(99),mass4set(:,2),  & 
G0tensor(876),G0tensor(877),G0tensor(878),G0tensor(879),G0tensor(880))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(145),mass4set(:,17),  & 
G0tensor(881),G0tensor(882),G0tensor(883),G0tensor(884),G0tensor(885))
  call Hotf_4pt_reduction_last(G1tensor(920),RedSet_4(98),mass4set(:,17),  & 
G0tensor(886),G0tensor(887),G0tensor(888),G0tensor(889),G0tensor(890))
  call Hotf_4pt_reduction_last(G1tensor(926),RedSet_4(99),mass4set(:,17),  & 
G0tensor(891),G0tensor(892),G0tensor(893),G0tensor(894),G0tensor(895))
  call Hotf_4pt_reduction_last(G1tensor(247),RedSet_4(145),mass4set(:,10),  & 
G0tensor(896),G0tensor(897),G0tensor(898),G0tensor(899),G0tensor(900))
  call Hotf_4pt_reduction_last(G1tensor(938),RedSet_4(98),mass4set(:,12),  & 
G0tensor(901),G0tensor(902),G0tensor(903),G0tensor(904),G0tensor(905))
  call Hotf_4pt_reduction_last(G1tensor(950),RedSet_4(98),mass4set(:,3),  & 
G0tensor(906),G0tensor(907),G0tensor(908),G0tensor(909),G0tensor(910))
  call Hotf_4pt_reduction_last(G1tensor(956),RedSet_4(99),mass4set(:,3),  & 
G0tensor(911),G0tensor(912),G0tensor(913),G0tensor(914),G0tensor(915))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(145),mass4set(:,20),  & 
G0tensor(916),G0tensor(917),G0tensor(918),G0tensor(919),G0tensor(920))
  call Hotf_4pt_reduction_last(G1tensor(962),RedSet_4(98),mass4set(:,23),  & 
G0tensor(921),G0tensor(922),G0tensor(923),G0tensor(924),G0tensor(925))
  call Hotf_4pt_reduction_last(G1tensor(968),RedSet_4(98),mass4set(:,18),  & 
G0tensor(926),G0tensor(927),G0tensor(928),G0tensor(929),G0tensor(930))
  call Hotf_4pt_reduction_last(G1tensor(974),RedSet_4(99),mass4set(:,18),  & 
G0tensor(931),G0tensor(932),G0tensor(933),G0tensor(934),G0tensor(935))
  call Hotf_4pt_reduction_last(G1tensor(986),RedSet_4(98),mass4set(:,21),  & 
G0tensor(936),G0tensor(937),G0tensor(938),G0tensor(939),G0tensor(940))
  call Hotf_4pt_reduction_last(G1tensor(992),RedSet_4(98),mass4set(:,25),  & 
G0tensor(941),G0tensor(942),G0tensor(943),G0tensor(944),G0tensor(945))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(145),mass4set(:,16),  & 
G0tensor(946),G0tensor(947),G0tensor(948),G0tensor(949),G0tensor(950))
  call Hotf_4pt_reduction_last(G1tensor(1010),RedSet_4(99),mass4set(:,5),  & 
G0tensor(951),G0tensor(952),G0tensor(953),G0tensor(954),G0tensor(955))
  call Hotf_4pt_reduction_last(G1tensor(214),RedSet_4(141),mass4set(:,2),  & 
G0tensor(956),G0tensor(957),G0tensor(958),G0tensor(959),G0tensor(960))
  call Hotf_4pt_reduction_last(G1tensor(1022),RedSet_4(100),mass4set(:,2),  & 
G0tensor(961),G0tensor(962),G0tensor(963),G0tensor(964),G0tensor(965))
  call Hotf_4pt_reduction_last(G1tensor(1028),RedSet_4(101),mass4set(:,2),  & 
G0tensor(966),G0tensor(967),G0tensor(968),G0tensor(969),G0tensor(970))
  call Hotf_4pt_reduction_last(G1tensor(355),RedSet_4(141),mass4set(:,17),  & 
G0tensor(971),G0tensor(972),G0tensor(973),G0tensor(974),G0tensor(975))
  call Hotf_4pt_reduction_last(G1tensor(1034),RedSet_4(101),mass4set(:,17),  & 
G0tensor(976),G0tensor(977),G0tensor(978),G0tensor(979),G0tensor(980))
  call Hotf_4pt_reduction_last(G1tensor(134),RedSet_4(141),mass4set(:,10),  & 
G0tensor(981),G0tensor(982),G0tensor(983),G0tensor(984),G0tensor(985))
  call Hotf_4pt_reduction_last(G1tensor(1040),RedSet_4(100),mass4set(:,12),  & 
G0tensor(986),G0tensor(987),G0tensor(988),G0tensor(989),G0tensor(990))
  call Hotf_4pt_reduction_last(G1tensor(1046),RedSet_4(100),mass4set(:,3),  & 
G0tensor(991),G0tensor(992),G0tensor(993),G0tensor(994),G0tensor(995))
  call Hotf_4pt_reduction_last(G1tensor(1052),RedSet_4(101),mass4set(:,3),  & 
G0tensor(996),G0tensor(997),G0tensor(998),G0tensor(999),G0tensor(1000))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(141),mass4set(:,20),  & 
G0tensor(1001),G0tensor(1002),G0tensor(1003),G0tensor(1004),G0tensor(1005))
  call Hotf_4pt_reduction_last(G1tensor(1058),RedSet_4(101),mass4set(:,18),  & 
G0tensor(1006),G0tensor(1007),G0tensor(1008),G0tensor(1009),G0tensor(1010))
  call Hotf_4pt_reduction_last(G1tensor(1064),RedSet_4(100),mass4set(:,21),  & 
G0tensor(1011),G0tensor(1012),G0tensor(1013),G0tensor(1014),G0tensor(1015))
  call Hotf_4pt_reduction_last(G1tensor(255),RedSet_4(151),mass4set(:,2),  & 
G0tensor(1016),G0tensor(1017),G0tensor(1018),G0tensor(1019),G0tensor(1020))
  call Hotf_4pt_reduction_last(G1tensor(68),RedSet_4(102),mass4set(:,2),  & 
G0tensor(1021),G0tensor(1022),G0tensor(1023),G0tensor(1024),G0tensor(1025))
  call Hotf_4pt_reduction_last(G1tensor(1076),RedSet_4(103),mass4set(:,2),  & 
G0tensor(1026),G0tensor(1027),G0tensor(1028),G0tensor(1029),G0tensor(1030))
  call Hotf_4pt_reduction_last(G1tensor(152),RedSet_4(104),mass4set(:,2),  & 
G0tensor(1031),G0tensor(1032),G0tensor(1033),G0tensor(1034),G0tensor(1035))
  call Hotf_4pt_reduction_last(G1tensor(140),RedSet_4(102),mass4set(:,3),  & 
G0tensor(1036),G0tensor(1037),G0tensor(1038),G0tensor(1039),G0tensor(1040))
  call Hotf_4pt_reduction_last(G1tensor(1094),RedSet_4(103),mass4set(:,3),  & 
G0tensor(1041),G0tensor(1042),G0tensor(1043),G0tensor(1044),G0tensor(1045))
  call Hotf_4pt_reduction_last(G1tensor(1100),RedSet_4(104),mass4set(:,3),  & 
G0tensor(1046),G0tensor(1047),G0tensor(1048),G0tensor(1049),G0tensor(1050))
  call Hotf_4pt_reduction_last(G1tensor(188),RedSet_4(151),mass4set(:,10),  & 
G0tensor(1051),G0tensor(1052),G0tensor(1053),G0tensor(1054),G0tensor(1055))
  call Hotf_4pt_reduction_last(G1tensor(138),RedSet_4(102),mass4set(:,12),  & 
G0tensor(1056),G0tensor(1057),G0tensor(1058),G0tensor(1059),G0tensor(1060))
  call Hotf_4pt_reduction_last(G1tensor(1112),RedSet_4(104),mass4set(:,10),  & 
G0tensor(1061),G0tensor(1062),G0tensor(1063),G0tensor(1064),G0tensor(1065))
  call Hotf_4pt_reduction_last(G1tensor(148),RedSet_4(151),mass4set(:,17),  & 
G0tensor(1066),G0tensor(1067),G0tensor(1068),G0tensor(1069),G0tensor(1070))
  call Hotf_4pt_reduction_last(G1tensor(1118),RedSet_4(103),mass4set(:,17),  & 
G0tensor(1071),G0tensor(1072),G0tensor(1073),G0tensor(1074),G0tensor(1075))
  call Hotf_4pt_reduction_last(G1tensor(1124),RedSet_4(104),mass4set(:,17),  & 
G0tensor(1076),G0tensor(1077),G0tensor(1078),G0tensor(1079),G0tensor(1080))
  call Hotf_4pt_reduction_last(G1tensor(278),RedSet_4(102),mass4set(:,21),  & 
G0tensor(1081),G0tensor(1082),G0tensor(1083),G0tensor(1084),G0tensor(1085))
  call Hotf_4pt_reduction_last(G1tensor(1136),RedSet_4(104),mass4set(:,15),  & 
G0tensor(1086),G0tensor(1087),G0tensor(1088),G0tensor(1089),G0tensor(1090))
  call Hotf_4pt_reduction_last(G1tensor(1142),RedSet_4(103),mass4set(:,18),  & 
G0tensor(1091),G0tensor(1092),G0tensor(1093),G0tensor(1094),G0tensor(1095))
  call Hotf_4pt_reduction_last(G1tensor(1148),RedSet_4(104),mass4set(:,18),  & 
G0tensor(1096),G0tensor(1097),G0tensor(1098),G0tensor(1099),G0tensor(1100))
  call Hotf_4pt_reduction_last(G1tensor(302),RedSet_4(151),mass4set(:,20),  & 
G0tensor(1101),G0tensor(1102),G0tensor(1103),G0tensor(1104),G0tensor(1105))
  call Hotf_4pt_reduction_last(G1tensor(1154),RedSet_4(104),mass4set(:,20),  & 
G0tensor(1106),G0tensor(1107),G0tensor(1108),G0tensor(1109),G0tensor(1110))
  call Hotf_4pt_reduction_last(G1tensor(1160),RedSet_4(104),mass4set(:,26),  & 
G0tensor(1111),G0tensor(1112),G0tensor(1113),G0tensor(1114),G0tensor(1115))
  call Hotf_4pt_reduction_last(G1tensor(178),RedSet_4(134),mass4set(:,2),  & 
G0tensor(1116),G0tensor(1117),G0tensor(1118),G0tensor(1119),G0tensor(1120))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(105),mass4set(:,2),  & 
G0tensor(1121),G0tensor(1122),G0tensor(1123),G0tensor(1124),G0tensor(1125))
  call Hotf_4pt_reduction_last(G1tensor(1172),RedSet_4(106),mass4set(:,2),  & 
G0tensor(1126),G0tensor(1127),G0tensor(1128),G0tensor(1129),G0tensor(1130))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(105),mass4set(:,3),  & 
G0tensor(1131),G0tensor(1132),G0tensor(1133),G0tensor(1134),G0tensor(1135))
  call Hotf_4pt_reduction_last(G1tensor(1184),RedSet_4(106),mass4set(:,3),  & 
G0tensor(1136),G0tensor(1137),G0tensor(1138),G0tensor(1139),G0tensor(1140))
  call Hotf_4pt_reduction_last(G1tensor(305),RedSet_4(134),mass4set(:,10),  & 
G0tensor(1141),G0tensor(1142),G0tensor(1143),G0tensor(1144),G0tensor(1145))
  call Hotf_4pt_reduction_last(G1tensor(18),RedSet_4(105),mass4set(:,12),  & 
G0tensor(1146),G0tensor(1147),G0tensor(1148),G0tensor(1149),G0tensor(1150))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(134),mass4set(:,17),  & 
G0tensor(1151),G0tensor(1152),G0tensor(1153),G0tensor(1154),G0tensor(1155))
  call Hotf_4pt_reduction_last(G1tensor(1196),RedSet_4(106),mass4set(:,17),  & 
G0tensor(1156),G0tensor(1157),G0tensor(1158),G0tensor(1159),G0tensor(1160))
  call Hotf_4pt_reduction_last(G1tensor(1473),RedSet_4(105),mass4set(:,21),  & 
G0tensor(1161),G0tensor(1162),G0tensor(1163),G0tensor(1164),G0tensor(1165))
  call Hotf_4pt_reduction_last(G1tensor(1208),RedSet_4(106),mass4set(:,18),  & 
G0tensor(1166),G0tensor(1167),G0tensor(1168),G0tensor(1169),G0tensor(1170))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(134),mass4set(:,20),  & 
G0tensor(1171),G0tensor(1172),G0tensor(1173),G0tensor(1174),G0tensor(1175))
  call Hotf_4pt_reduction_last(G1tensor(466),RedSet_4(2),mass4set(:,2),  & 
G0tensor(1176),G0tensor(1177),G0tensor(1178),G0tensor(1179),G0tensor(1180))
  call Hotf_4pt_reduction_last(G1tensor(905),RedSet_4(3),mass4set(:,2),  & 
G0tensor(1181),G0tensor(1182),G0tensor(1183),G0tensor(1184),G0tensor(1185))
  call Hotf_4pt_reduction_last(G1tensor(444),RedSet_4(4),mass4set(:,2),  & 
G0tensor(1186),G0tensor(1187),G0tensor(1188),G0tensor(1189),G0tensor(1190))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(6),mass4set(:,2),  & 
G0tensor(1191),G0tensor(1192),G0tensor(1193),G0tensor(1194),G0tensor(1195))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(7),mass4set(:,2),  & 
G0tensor(1196),G0tensor(1197),G0tensor(1198),G0tensor(1199),G0tensor(1200))
  call Hotf_4pt_reduction_last(G1tensor(450),RedSet_4(8),mass4set(:,2),  & 
G0tensor(1201),G0tensor(1202),G0tensor(1203),G0tensor(1204),G0tensor(1205))
  call Hotf_4pt_reduction_last(G1tensor(890),RedSet_4(10),mass4set(:,2),  & 
G0tensor(1206),G0tensor(1207),G0tensor(1208),G0tensor(1209),G0tensor(1210))
  call Hotf_4pt_reduction_last(G1tensor(456),RedSet_4(11),mass4set(:,2),  & 
G0tensor(1211),G0tensor(1212),G0tensor(1213),G0tensor(1214),G0tensor(1215))
  call Hotf_4pt_reduction_last(G1tensor(135),RedSet_4(13),mass4set(:,2),  & 
G0tensor(1216),G0tensor(1217),G0tensor(1218),G0tensor(1219),G0tensor(1220))
  call Hotf_4pt_reduction_last(G1tensor(99),RedSet_4(6),mass4set(:,17),  & 
G0tensor(1221),G0tensor(1222),G0tensor(1223),G0tensor(1224),G0tensor(1225))
  call Hotf_4pt_reduction_last(G1tensor(923),RedSet_4(7),mass4set(:,17),  & 
G0tensor(1226),G0tensor(1227),G0tensor(1228),G0tensor(1229),G0tensor(1230))
  call Hotf_4pt_reduction_last(G1tensor(486),RedSet_4(8),mass4set(:,17),  & 
G0tensor(1231),G0tensor(1232),G0tensor(1233),G0tensor(1234),G0tensor(1235))
  call Hotf_4pt_reduction_last(G1tensor(334),RedSet_4(10),mass4set(:,17),  & 
G0tensor(1236),G0tensor(1237),G0tensor(1238),G0tensor(1239),G0tensor(1240))
  call Hotf_4pt_reduction_last(G1tensor(492),RedSet_4(11),mass4set(:,17),  & 
G0tensor(1241),G0tensor(1242),G0tensor(1243),G0tensor(1244),G0tensor(1245))
  call Hotf_4pt_reduction_last(G1tensor(78),RedSet_4(13),mass4set(:,17),  & 
G0tensor(1246),G0tensor(1247),G0tensor(1248),G0tensor(1249),G0tensor(1250))
  call Hotf_4pt_reduction_last(G1tensor(514),RedSet_4(2),mass4set(:,10),  & 
G0tensor(1251),G0tensor(1252),G0tensor(1253),G0tensor(1254),G0tensor(1255))
  call Hotf_4pt_reduction_last(G1tensor(947),RedSet_4(3),mass4set(:,10),  & 
G0tensor(1256),G0tensor(1257),G0tensor(1258),G0tensor(1259),G0tensor(1260))
  call Hotf_4pt_reduction_last(G1tensor(1533),RedSet_4(6),mass4set(:,10),  & 
G0tensor(1261),G0tensor(1262),G0tensor(1263),G0tensor(1264),G0tensor(1265))
  call Hotf_4pt_reduction_last(G1tensor(953),RedSet_4(7),mass4set(:,10),  & 
G0tensor(1266),G0tensor(1267),G0tensor(1268),G0tensor(1269),G0tensor(1270))
  call Hotf_4pt_reduction_last(G1tensor(177),RedSet_4(10),mass4set(:,10),  & 
G0tensor(1271),G0tensor(1272),G0tensor(1273),G0tensor(1274),G0tensor(1275))
  call Hotf_4pt_reduction_last(G1tensor(935),RedSet_4(3),mass4set(:,12),  & 
G0tensor(1276),G0tensor(1277),G0tensor(1278),G0tensor(1279),G0tensor(1280))
  call Hotf_4pt_reduction_last(G1tensor(516),RedSet_4(4),mass4set(:,12),  & 
G0tensor(1281),G0tensor(1282),G0tensor(1283),G0tensor(1284),G0tensor(1285))
  call Hotf_4pt_reduction_last(G1tensor(941),RedSet_4(7),mass4set(:,12),  & 
G0tensor(1286),G0tensor(1287),G0tensor(1288),G0tensor(1289),G0tensor(1290))
  call Hotf_4pt_reduction_last(G1tensor(522),RedSet_4(8),mass4set(:,12),  & 
G0tensor(1291),G0tensor(1292),G0tensor(1293),G0tensor(1294),G0tensor(1295))
  call Hotf_4pt_reduction_last(G1tensor(108),RedSet_4(13),mass4set(:,10),  & 
G0tensor(1296),G0tensor(1297),G0tensor(1298),G0tensor(1299),G0tensor(1300))
  call Hotf_4pt_reduction_last(G1tensor(288),RedSet_4(6),mass4set(:,20),  & 
G0tensor(1301),G0tensor(1302),G0tensor(1303),G0tensor(1304),G0tensor(1305))
  call Hotf_4pt_reduction_last(G1tensor(971),RedSet_4(7),mass4set(:,20),  & 
G0tensor(1306),G0tensor(1307),G0tensor(1308),G0tensor(1309),G0tensor(1310))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(10),mass4set(:,20),  & 
G0tensor(1311),G0tensor(1312),G0tensor(1313),G0tensor(1314),G0tensor(1315))
  call Hotf_4pt_reduction_last(G1tensor(965),RedSet_4(7),mass4set(:,23),  & 
G0tensor(1316),G0tensor(1317),G0tensor(1318),G0tensor(1319),G0tensor(1320))
  call Hotf_4pt_reduction_last(G1tensor(534),RedSet_4(8),mass4set(:,23),  & 
G0tensor(1321),G0tensor(1322),G0tensor(1323),G0tensor(1324),G0tensor(1325))
  call Hotf_4pt_reduction_last(G1tensor(144),RedSet_4(13),mass4set(:,20),  & 
G0tensor(1326),G0tensor(1327),G0tensor(1328),G0tensor(1329),G0tensor(1330))
  call Hotf_4pt_reduction_last(G1tensor(983),RedSet_4(3),mass4set(:,24),  & 
G0tensor(1331),G0tensor(1332),G0tensor(1333),G0tensor(1334),G0tensor(1335))
  call Hotf_4pt_reduction_last(G1tensor(989),RedSet_4(7),mass4set(:,24),  & 
G0tensor(1336),G0tensor(1337),G0tensor(1338),G0tensor(1339),G0tensor(1340))
  call Hotf_4pt_reduction_last(G1tensor(995),RedSet_4(7),mass4set(:,27),  & 
G0tensor(1341),G0tensor(1342),G0tensor(1343),G0tensor(1344),G0tensor(1345))
  call Hotf_4pt_reduction_last(G1tensor(149),RedSet_4(16),mass4set(:,2),  & 
G0tensor(1346),G0tensor(1347),G0tensor(1348),G0tensor(1349),G0tensor(1350))
  call Hotf_4pt_reduction_last(G1tensor(610),RedSet_4(17),mass4set(:,2),  & 
G0tensor(1351),G0tensor(1352),G0tensor(1353),G0tensor(1354),G0tensor(1355))
  call Hotf_4pt_reduction_last(G1tensor(785),RedSet_4(18),mass4set(:,2),  & 
G0tensor(1356),G0tensor(1357),G0tensor(1358),G0tensor(1359),G0tensor(1360))
  call Hotf_4pt_reduction_last(G1tensor(570),RedSet_4(19),mass4set(:,2),  & 
G0tensor(1361),G0tensor(1362),G0tensor(1363),G0tensor(1364),G0tensor(1365))
  call Hotf_4pt_reduction_last(G1tensor(195),RedSet_4(21),mass4set(:,2),  & 
G0tensor(1366),G0tensor(1367),G0tensor(1368),G0tensor(1369),G0tensor(1370))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(22),mass4set(:,2),  & 
G0tensor(1371),G0tensor(1372),G0tensor(1373),G0tensor(1374),G0tensor(1375))
  call Hotf_4pt_reduction_last(G1tensor(576),RedSet_4(23),mass4set(:,2),  & 
G0tensor(1376),G0tensor(1377),G0tensor(1378),G0tensor(1379),G0tensor(1380))
  call Hotf_4pt_reduction_last(G1tensor(203),RedSet_4(25),mass4set(:,2),  & 
G0tensor(1381),G0tensor(1382),G0tensor(1383),G0tensor(1384),G0tensor(1385))
  call Hotf_4pt_reduction_last(G1tensor(582),RedSet_4(26),mass4set(:,2),  & 
G0tensor(1386),G0tensor(1387),G0tensor(1388),G0tensor(1389),G0tensor(1390))
  call Hotf_4pt_reduction_last(G1tensor(227),RedSet_4(16),mass4set(:,10),  & 
G0tensor(1391),G0tensor(1392),G0tensor(1393),G0tensor(1394),G0tensor(1395))
  call Hotf_4pt_reduction_last(G1tensor(646),RedSet_4(17),mass4set(:,10),  & 
G0tensor(1396),G0tensor(1397),G0tensor(1398),G0tensor(1399),G0tensor(1400))
  call Hotf_4pt_reduction_last(G1tensor(803),RedSet_4(18),mass4set(:,10),  & 
G0tensor(1401),G0tensor(1402),G0tensor(1403),G0tensor(1404),G0tensor(1405))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(21),mass4set(:,10),  & 
G0tensor(1406),G0tensor(1407),G0tensor(1408),G0tensor(1409),G0tensor(1410))
  call Hotf_4pt_reduction_last(G1tensor(1102),RedSet_4(22),mass4set(:,10),  & 
G0tensor(1411),G0tensor(1412),G0tensor(1413),G0tensor(1414),G0tensor(1415))
  call Hotf_4pt_reduction_last(G1tensor(219),RedSet_4(25),mass4set(:,10),  & 
G0tensor(1416),G0tensor(1417),G0tensor(1418),G0tensor(1419),G0tensor(1420))
  call Hotf_4pt_reduction_last(G1tensor(239),RedSet_4(21),mass4set(:,17),  & 
G0tensor(1421),G0tensor(1422),G0tensor(1423),G0tensor(1424),G0tensor(1425))
  call Hotf_4pt_reduction_last(G1tensor(1126),RedSet_4(22),mass4set(:,17),  & 
G0tensor(1426),G0tensor(1427),G0tensor(1428),G0tensor(1429),G0tensor(1430))
  call Hotf_4pt_reduction_last(G1tensor(630),RedSet_4(23),mass4set(:,17),  & 
G0tensor(1431),G0tensor(1432),G0tensor(1433),G0tensor(1434),G0tensor(1435))
  call Hotf_4pt_reduction_last(G1tensor(285),RedSet_4(25),mass4set(:,17),  & 
G0tensor(1436),G0tensor(1437),G0tensor(1438),G0tensor(1439),G0tensor(1440))
  call Hotf_4pt_reduction_last(G1tensor(636),RedSet_4(26),mass4set(:,17),  & 
G0tensor(1441),G0tensor(1442),G0tensor(1443),G0tensor(1444),G0tensor(1445))
  call Hotf_4pt_reduction_last(G1tensor(299),RedSet_4(16),mass4set(:,17),  & 
G0tensor(1446),G0tensor(1447),G0tensor(1448),G0tensor(1449),G0tensor(1450))
  call Hotf_4pt_reduction_last(G1tensor(833),RedSet_4(18),mass4set(:,12),  & 
G0tensor(1451),G0tensor(1452),G0tensor(1453),G0tensor(1454),G0tensor(1455))
  call Hotf_4pt_reduction_last(G1tensor(648),RedSet_4(19),mass4set(:,12),  & 
G0tensor(1456),G0tensor(1457),G0tensor(1458),G0tensor(1459),G0tensor(1460))
  call Hotf_4pt_reduction_last(G1tensor(1114),RedSet_4(22),mass4set(:,12),  & 
G0tensor(1461),G0tensor(1462),G0tensor(1463),G0tensor(1464),G0tensor(1465))
  call Hotf_4pt_reduction_last(G1tensor(654),RedSet_4(23),mass4set(:,12),  & 
G0tensor(1466),G0tensor(1467),G0tensor(1468),G0tensor(1469),G0tensor(1470))
  call Hotf_4pt_reduction_last(G1tensor(269),RedSet_4(21),mass4set(:,20),  & 
G0tensor(1471),G0tensor(1472),G0tensor(1473),G0tensor(1474),G0tensor(1475))
  call Hotf_4pt_reduction_last(G1tensor(1150),RedSet_4(22),mass4set(:,20),  & 
G0tensor(1476),G0tensor(1477),G0tensor(1478),G0tensor(1479),G0tensor(1480))
  call Hotf_4pt_reduction_last(G1tensor(363),RedSet_4(25),mass4set(:,20),  & 
G0tensor(1481),G0tensor(1482),G0tensor(1483),G0tensor(1484),G0tensor(1485))
  call Hotf_4pt_reduction_last(G1tensor(309),RedSet_4(16),mass4set(:,20),  & 
G0tensor(1486),G0tensor(1487),G0tensor(1488),G0tensor(1489),G0tensor(1490))
  call Hotf_4pt_reduction_last(G1tensor(857),RedSet_4(18),mass4set(:,24),  & 
G0tensor(1491),G0tensor(1492),G0tensor(1493),G0tensor(1494),G0tensor(1495))
  call Hotf_4pt_reduction_last(G1tensor(1138),RedSet_4(22),mass4set(:,24),  & 
G0tensor(1496),G0tensor(1497),G0tensor(1498),G0tensor(1499),G0tensor(1500))
  call Hotf_4pt_reduction_last(G1tensor(1156),RedSet_4(22),mass4set(:,23),  & 
G0tensor(1501),G0tensor(1502),G0tensor(1503),G0tensor(1504),G0tensor(1505))
  call Hotf_4pt_reduction_last(G1tensor(678),RedSet_4(23),mass4set(:,23),  & 
G0tensor(1506),G0tensor(1507),G0tensor(1508),G0tensor(1509),G0tensor(1510))
  call Hotf_4pt_reduction_last(G1tensor(1162),RedSet_4(22),mass4set(:,27),  & 
G0tensor(1511),G0tensor(1512),G0tensor(1513),G0tensor(1514),G0tensor(1515))
  call Hotf_4pt_reduction_last(G1tensor(736),RedSet_4(31),mass4set(:,2),  & 
G0tensor(1516),G0tensor(1517),G0tensor(1518),G0tensor(1519),G0tensor(1520))
  call Hotf_4pt_reduction_last(G1tensor(1025),RedSet_4(32),mass4set(:,2),  & 
G0tensor(1521),G0tensor(1522),G0tensor(1523),G0tensor(1524),G0tensor(1525))
  call Hotf_4pt_reduction_last(G1tensor(720),RedSet_4(33),mass4set(:,2),  & 
G0tensor(1526),G0tensor(1527),G0tensor(1528),G0tensor(1529),G0tensor(1530))
  call Hotf_4pt_reduction_last(G1tensor(341),RedSet_4(35),mass4set(:,2),  & 
G0tensor(1531),G0tensor(1532),G0tensor(1533),G0tensor(1534),G0tensor(1535))
  call Hotf_4pt_reduction_last(G1tensor(726),RedSet_4(36),mass4set(:,2),  & 
G0tensor(1536),G0tensor(1537),G0tensor(1538),G0tensor(1539),G0tensor(1540))
  call Hotf_4pt_reduction_last(G1tensor(390),RedSet_4(38),mass4set(:,2),  & 
G0tensor(1541),G0tensor(1542),G0tensor(1543),G0tensor(1544),G0tensor(1545))
  call Hotf_4pt_reduction_last(G1tensor(1190),RedSet_4(35),mass4set(:,17),  & 
G0tensor(1546),G0tensor(1547),G0tensor(1548),G0tensor(1549),G0tensor(1550))
  call Hotf_4pt_reduction_last(G1tensor(750),RedSet_4(36),mass4set(:,17),  & 
G0tensor(1551),G0tensor(1552),G0tensor(1553),G0tensor(1554),G0tensor(1555))
  call Hotf_4pt_reduction_last(G1tensor(324),RedSet_4(38),mass4set(:,17),  & 
G0tensor(1556),G0tensor(1557),G0tensor(1558),G0tensor(1559),G0tensor(1560))
  call Hotf_4pt_reduction_last(G1tensor(766),RedSet_4(31),mass4set(:,10),  & 
G0tensor(1561),G0tensor(1562),G0tensor(1563),G0tensor(1564),G0tensor(1565))
  call Hotf_4pt_reduction_last(G1tensor(1049),RedSet_4(32),mass4set(:,10),  & 
G0tensor(1566),G0tensor(1567),G0tensor(1568),G0tensor(1569),G0tensor(1570))
  call Hotf_4pt_reduction_last(G1tensor(384),RedSet_4(35),mass4set(:,10),  & 
G0tensor(1571),G0tensor(1572),G0tensor(1573),G0tensor(1574),G0tensor(1575))
  call Hotf_4pt_reduction_last(G1tensor(1043),RedSet_4(32),mass4set(:,12),  & 
G0tensor(1576),G0tensor(1577),G0tensor(1578),G0tensor(1579),G0tensor(1580))
  call Hotf_4pt_reduction_last(G1tensor(768),RedSet_4(33),mass4set(:,12),  & 
G0tensor(1581),G0tensor(1582),G0tensor(1583),G0tensor(1584),G0tensor(1585))
  call Hotf_4pt_reduction_last(G1tensor(357),RedSet_4(38),mass4set(:,10),  & 
G0tensor(1586),G0tensor(1587),G0tensor(1588),G0tensor(1589),G0tensor(1590))
  call Hotf_4pt_reduction_last(G1tensor(417),RedSet_4(35),mass4set(:,20),  & 
G0tensor(1591),G0tensor(1592),G0tensor(1593),G0tensor(1594),G0tensor(1595))
  call Hotf_4pt_reduction_last(G1tensor(472),RedSet_4(38),mass4set(:,20),  & 
G0tensor(1596),G0tensor(1597),G0tensor(1598),G0tensor(1599),G0tensor(1600))
  call Hotf_4pt_reduction_last(G1tensor(1067),RedSet_4(32),mass4set(:,24),  & 
G0tensor(1601),G0tensor(1602),G0tensor(1603),G0tensor(1604),G0tensor(1605))
  call Hotf_4pt_reduction_last(G1tensor(418),RedSet_4(41),mass4set(:,2),  & 
G0tensor(1606),G0tensor(1607),G0tensor(1608),G0tensor(1609),G0tensor(1610))
  call Hotf_4pt_reduction_last(G1tensor(832),RedSet_4(42),mass4set(:,2),  & 
G0tensor(1611),G0tensor(1612),G0tensor(1613),G0tensor(1614),G0tensor(1615))
  call Hotf_4pt_reduction_last(G1tensor(804),RedSet_4(43),mass4set(:,2),  & 
G0tensor(1616),G0tensor(1617),G0tensor(1618),G0tensor(1619),G0tensor(1620))
  call Hotf_4pt_reduction_last(G1tensor(479),RedSet_4(45),mass4set(:,2),  & 
G0tensor(1621),G0tensor(1622),G0tensor(1623),G0tensor(1624),G0tensor(1625))
  call Hotf_4pt_reduction_last(G1tensor(810),RedSet_4(46),mass4set(:,2),  & 
G0tensor(1626),G0tensor(1627),G0tensor(1628),G0tensor(1629),G0tensor(1630))
  call Hotf_4pt_reduction_last(G1tensor(816),RedSet_4(48),mass4set(:,2),  & 
G0tensor(1631),G0tensor(1632),G0tensor(1633),G0tensor(1634),G0tensor(1635))
  call Hotf_4pt_reduction_last(G1tensor(420),RedSet_4(41),mass4set(:,10),  & 
G0tensor(1636),G0tensor(1637),G0tensor(1638),G0tensor(1639),G0tensor(1640))
  call Hotf_4pt_reduction_last(G1tensor(856),RedSet_4(42),mass4set(:,10),  & 
G0tensor(1641),G0tensor(1642),G0tensor(1643),G0tensor(1644),G0tensor(1645))
  call Hotf_4pt_reduction_last(G1tensor(424),RedSet_4(45),mass4set(:,10),  & 
G0tensor(1646),G0tensor(1647),G0tensor(1648),G0tensor(1649),G0tensor(1650))
  call Hotf_4pt_reduction_last(G1tensor(1283),RedSet_4(45),mass4set(:,17),  & 
G0tensor(1651),G0tensor(1652),G0tensor(1653),G0tensor(1654),G0tensor(1655))
  call Hotf_4pt_reduction_last(G1tensor(846),RedSet_4(46),mass4set(:,17),  & 
G0tensor(1656),G0tensor(1657),G0tensor(1658),G0tensor(1659),G0tensor(1660))
  call Hotf_4pt_reduction_last(G1tensor(852),RedSet_4(48),mass4set(:,17),  & 
G0tensor(1661),G0tensor(1662),G0tensor(1663),G0tensor(1664),G0tensor(1665))
  call Hotf_4pt_reduction_last(G1tensor(432),RedSet_4(41),mass4set(:,17),  & 
G0tensor(1666),G0tensor(1667),G0tensor(1668),G0tensor(1669),G0tensor(1670))
  call Hotf_4pt_reduction_last(G1tensor(858),RedSet_4(43),mass4set(:,12),  & 
G0tensor(1671),G0tensor(1672),G0tensor(1673),G0tensor(1674),G0tensor(1675))
  call Hotf_4pt_reduction_last(G1tensor(864),RedSet_4(46),mass4set(:,12),  & 
G0tensor(1676),G0tensor(1677),G0tensor(1678),G0tensor(1679),G0tensor(1680))
  call Hotf_4pt_reduction_last(G1tensor(442),RedSet_4(45),mass4set(:,20),  & 
G0tensor(1681),G0tensor(1682),G0tensor(1683),G0tensor(1684),G0tensor(1685))
  call Hotf_4pt_reduction_last(G1tensor(724),RedSet_4(41),mass4set(:,20),  & 
G0tensor(1686),G0tensor(1687),G0tensor(1688),G0tensor(1689),G0tensor(1690))
  call Hotf_4pt_reduction_last(G1tensor(876),RedSet_4(46),mass4set(:,23),  & 
G0tensor(1691),G0tensor(1692),G0tensor(1693),G0tensor(1694),G0tensor(1695))
  call Hotf_4pt_reduction_last(G1tensor(460),RedSet_4(41),mass4set(:,16),  & 
G0tensor(1696),G0tensor(1697),G0tensor(1698),G0tensor(1699),G0tensor(1700))
  call Hotf_4pt_reduction_last(G1tensor(891),RedSet_4(42),mass4set(:,11),  & 
G0tensor(1701),G0tensor(1702),G0tensor(1703),G0tensor(1704),G0tensor(1705))
  call Hotf_4pt_reduction_last(G1tensor(461),RedSet_4(18),mass4set(:,8),  & 
G0tensor(1706),G0tensor(1707),G0tensor(1708),G0tensor(1709),G0tensor(1710))
  call Hotf_4pt_reduction_last(G1tensor(882),RedSet_4(43),mass4set(:,13),  & 
G0tensor(1711),G0tensor(1712),G0tensor(1713),G0tensor(1714),G0tensor(1715))
  call Hotf_4pt_reduction_last(G1tensor(468),RedSet_4(45),mass4set(:,16),  & 
G0tensor(1716),G0tensor(1717),G0tensor(1718),G0tensor(1719),G0tensor(1720))
  call Hotf_4pt_reduction_last(G1tensor(528),RedSet_4(22),mass4set(:,6),  & 
G0tensor(1721),G0tensor(1722),G0tensor(1723),G0tensor(1724),G0tensor(1725))
  call Hotf_4pt_reduction_last(G1tensor(490),RedSet_4(25),mass4set(:,16),  & 
G0tensor(1726),G0tensor(1727),G0tensor(1728),G0tensor(1729),G0tensor(1730))
  call Hotf_4pt_reduction_last(G1tensor(894),RedSet_4(48),mass4set(:,19),  & 
G0tensor(1731),G0tensor(1732),G0tensor(1733),G0tensor(1734),G0tensor(1735))
  call Hotf_4pt_reduction_last(G1tensor(934),RedSet_4(52),mass4set(:,2),  & 
G0tensor(1736),G0tensor(1737),G0tensor(1738),G0tensor(1739),G0tensor(1740))
  call Hotf_4pt_reduction_last(G1tensor(948),RedSet_4(53),mass4set(:,2),  & 
G0tensor(1741),G0tensor(1742),G0tensor(1743),G0tensor(1744),G0tensor(1745))
  call Hotf_4pt_reduction_last(G1tensor(1295),RedSet_4(55),mass4set(:,2),  & 
G0tensor(1746),G0tensor(1747),G0tensor(1748),G0tensor(1749),G0tensor(1750))
  call Hotf_4pt_reduction_last(G1tensor(954),RedSet_4(56),mass4set(:,2),  & 
G0tensor(1751),G0tensor(1752),G0tensor(1753),G0tensor(1754),G0tensor(1755))
  call Hotf_4pt_reduction_last(G1tensor(960),RedSet_4(58),mass4set(:,2),  & 
G0tensor(1756),G0tensor(1757),G0tensor(1758),G0tensor(1759),G0tensor(1760))
  call Hotf_4pt_reduction_last(G1tensor(760),RedSet_4(55),mass4set(:,17),  & 
G0tensor(1761),G0tensor(1762),G0tensor(1763),G0tensor(1764),G0tensor(1765))
  call Hotf_4pt_reduction_last(G1tensor(972),RedSet_4(56),mass4set(:,17),  & 
G0tensor(1766),G0tensor(1767),G0tensor(1768),G0tensor(1769),G0tensor(1770))
  call Hotf_4pt_reduction_last(G1tensor(978),RedSet_4(58),mass4set(:,17),  & 
G0tensor(1771),G0tensor(1772),G0tensor(1773),G0tensor(1774),G0tensor(1775))
  call Hotf_4pt_reduction_last(G1tensor(984),RedSet_4(53),mass4set(:,12),  & 
G0tensor(1776),G0tensor(1777),G0tensor(1778),G0tensor(1779),G0tensor(1780))
  call Hotf_4pt_reduction_last(G1tensor(990),RedSet_4(56),mass4set(:,12),  & 
G0tensor(1781),G0tensor(1782),G0tensor(1783),G0tensor(1784),G0tensor(1785))
  call Hotf_4pt_reduction_last(G1tensor(982),RedSet_4(52),mass4set(:,10),  & 
G0tensor(1786),G0tensor(1787),G0tensor(1788),G0tensor(1789),G0tensor(1790))
  call Hotf_4pt_reduction_last(G1tensor(510),RedSet_4(55),mass4set(:,10),  & 
G0tensor(1791),G0tensor(1792),G0tensor(1793),G0tensor(1794),G0tensor(1795))
  call Hotf_4pt_reduction_last(G1tensor(996),RedSet_4(56),mass4set(:,23),  & 
G0tensor(1796),G0tensor(1797),G0tensor(1798),G0tensor(1799),G0tensor(1800))
  call Hotf_4pt_reduction_last(G1tensor(526),RedSet_4(55),mass4set(:,20),  & 
G0tensor(1801),G0tensor(1802),G0tensor(1803),G0tensor(1804),G0tensor(1805))
  call Hotf_4pt_reduction_last(G1tensor(1011),RedSet_4(52),mass4set(:,11),  & 
G0tensor(1806),G0tensor(1807),G0tensor(1808),G0tensor(1809),G0tensor(1810))
  call Hotf_4pt_reduction_last(G1tensor(1071),RedSet_4(3),mass4set(:,8),  & 
G0tensor(1811),G0tensor(1812),G0tensor(1813),G0tensor(1814),G0tensor(1815))
  call Hotf_4pt_reduction_last(G1tensor(1002),RedSet_4(53),mass4set(:,13),  & 
G0tensor(1816),G0tensor(1817),G0tensor(1818),G0tensor(1819),G0tensor(1820))
  call Hotf_4pt_reduction_last(G1tensor(555),RedSet_4(55),mass4set(:,16),  & 
G0tensor(1821),G0tensor(1822),G0tensor(1823),G0tensor(1824),G0tensor(1825))
  call Hotf_4pt_reduction_last(G1tensor(546),RedSet_4(7),mass4set(:,6),  & 
G0tensor(1826),G0tensor(1827),G0tensor(1828),G0tensor(1829),G0tensor(1830))
  call Hotf_4pt_reduction_last(G1tensor(550),RedSet_4(10),mass4set(:,16),  & 
G0tensor(1831),G0tensor(1832),G0tensor(1833),G0tensor(1834),G0tensor(1835))
  call Hotf_4pt_reduction_last(G1tensor(1014),RedSet_4(58),mass4set(:,19),  & 
G0tensor(1836),G0tensor(1837),G0tensor(1838),G0tensor(1839),G0tensor(1840))
  call Hotf_4pt_reduction_last(G1tensor(1042),RedSet_4(61),mass4set(:,2),  & 
G0tensor(1841),G0tensor(1842),G0tensor(1843),G0tensor(1844),G0tensor(1845))
  call Hotf_4pt_reduction_last(G1tensor(1050),RedSet_4(62),mass4set(:,2),  & 
G0tensor(1846),G0tensor(1847),G0tensor(1848),G0tensor(1849),G0tensor(1850))
  call Hotf_4pt_reduction_last(G1tensor(1056),RedSet_4(64),mass4set(:,2),  & 
G0tensor(1851),G0tensor(1852),G0tensor(1853),G0tensor(1854),G0tensor(1855))
  call Hotf_4pt_reduction_last(G1tensor(1062),RedSet_4(64),mass4set(:,17),  & 
G0tensor(1856),G0tensor(1857),G0tensor(1858),G0tensor(1859),G0tensor(1860))
  call Hotf_4pt_reduction_last(G1tensor(1068),RedSet_4(62),mass4set(:,12),  & 
G0tensor(1861),G0tensor(1862),G0tensor(1863),G0tensor(1864),G0tensor(1865))
  call Hotf_4pt_reduction_last(G1tensor(1066),RedSet_4(61),mass4set(:,10),  & 
G0tensor(1866),G0tensor(1867),G0tensor(1868),G0tensor(1869),G0tensor(1870))
  call Hotf_4pt_reduction_last(G1tensor(1119),RedSet_4(67),mass4set(:,2),  & 
G0tensor(1871),G0tensor(1872),G0tensor(1873),G0tensor(1874),G0tensor(1875))
  call Hotf_4pt_reduction_last(G1tensor(1169),RedSet_4(68),mass4set(:,2),  & 
G0tensor(1876),G0tensor(1877),G0tensor(1878),G0tensor(1879),G0tensor(1880))
  call Hotf_4pt_reduction_last(G1tensor(1092),RedSet_4(69),mass4set(:,2),  & 
G0tensor(1881),G0tensor(1882),G0tensor(1883),G0tensor(1884),G0tensor(1885))
  call Hotf_4pt_reduction_last(G1tensor(552),RedSet_4(71),mass4set(:,2),  & 
G0tensor(1886),G0tensor(1887),G0tensor(1888),G0tensor(1889),G0tensor(1890))
  call Hotf_4pt_reduction_last(G1tensor(1098),RedSet_4(72),mass4set(:,2),  & 
G0tensor(1891),G0tensor(1892),G0tensor(1893),G0tensor(1894),G0tensor(1895))
  call Hotf_4pt_reduction_last(G1tensor(1143),RedSet_4(67),mass4set(:,10),  & 
G0tensor(1896),G0tensor(1897),G0tensor(1898),G0tensor(1899),G0tensor(1900))
  call Hotf_4pt_reduction_last(G1tensor(1181),RedSet_4(68),mass4set(:,10),  & 
G0tensor(1901),G0tensor(1902),G0tensor(1903),G0tensor(1904),G0tensor(1905))
  call Hotf_4pt_reduction_last(G1tensor(557),RedSet_4(71),mass4set(:,10),  & 
G0tensor(1906),G0tensor(1907),G0tensor(1908),G0tensor(1909),G0tensor(1910))
  call Hotf_4pt_reduction_last(G1tensor(1193),RedSet_4(68),mass4set(:,12),  & 
G0tensor(1911),G0tensor(1912),G0tensor(1913),G0tensor(1914),G0tensor(1915))
  call Hotf_4pt_reduction_last(G1tensor(1134),RedSet_4(69),mass4set(:,12),  & 
G0tensor(1916),G0tensor(1917),G0tensor(1918),G0tensor(1919),G0tensor(1920))
  call Hotf_4pt_reduction_last(G1tensor(567),RedSet_4(71),mass4set(:,17),  & 
G0tensor(1921),G0tensor(1922),G0tensor(1923),G0tensor(1924),G0tensor(1925))
  call Hotf_4pt_reduction_last(G1tensor(1146),RedSet_4(72),mass4set(:,17),  & 
G0tensor(1926),G0tensor(1927),G0tensor(1928),G0tensor(1929),G0tensor(1930))
  call Hotf_4pt_reduction_last(G1tensor(1205),RedSet_4(68),mass4set(:,24),  & 
G0tensor(1931),G0tensor(1932),G0tensor(1933),G0tensor(1934),G0tensor(1935))
  call Hotf_4pt_reduction_last(G1tensor(585),RedSet_4(71),mass4set(:,20),  & 
G0tensor(1936),G0tensor(1937),G0tensor(1938),G0tensor(1939),G0tensor(1940))
  call Hotf_4pt_reduction_last(G1tensor(1197),RedSet_4(77),mass4set(:,2),  & 
G0tensor(1941),G0tensor(1942),G0tensor(1943),G0tensor(1944),G0tensor(1945))
  call Hotf_4pt_reduction_last(G1tensor(1182),RedSet_4(78),mass4set(:,2),  & 
G0tensor(1946),G0tensor(1947),G0tensor(1948),G0tensor(1949),G0tensor(1950))
  call Hotf_4pt_reduction_last(G1tensor(1188),RedSet_4(80),mass4set(:,2),  & 
G0tensor(1951),G0tensor(1952),G0tensor(1953),G0tensor(1954),G0tensor(1955))
  call Hotf_4pt_reduction_last(G1tensor(1209),RedSet_4(77),mass4set(:,10),  & 
G0tensor(1956),G0tensor(1957),G0tensor(1958),G0tensor(1959),G0tensor(1960))
  call Hotf_4pt_reduction_last(G1tensor(1206),RedSet_4(78),mass4set(:,12),  & 
G0tensor(1961),G0tensor(1962),G0tensor(1963),G0tensor(1964),G0tensor(1965))
  call Hotf_4pt_reduction_last(G1tensor(1212),RedSet_4(80),mass4set(:,17),  & 
G0tensor(1966),G0tensor(1967),G0tensor(1968),G0tensor(1969),G0tensor(1970))
  call Hotf_4pt_reduction_last(G1tensor(580),RedSet_4(152),mass4set(:,2),  & 
G0tensor(1971),G0tensor(1972),G0tensor(1973),G0tensor(1974),G0tensor(1975))
  call Hotf_4pt_reduction_last(G1tensor(1397),RedSet_4(107),mass4set(:,2),  & 
G0tensor(1976),G0tensor(1977),G0tensor(1978),G0tensor(1979),G0tensor(1980))
  call Hotf_4pt_reduction_last(G1tensor(1318),RedSet_4(108),mass4set(:,2),  & 
G0tensor(1981),G0tensor(1982),G0tensor(1983),G0tensor(1984),G0tensor(1985))
  call Hotf_4pt_reduction_last(G1tensor(821),RedSet_4(109),mass4set(:,2),  & 
G0tensor(1986),G0tensor(1987),G0tensor(1988),G0tensor(1989),G0tensor(1990))
  call Hotf_4pt_reduction_last(G1tensor(827),RedSet_4(107),mass4set(:,3),  & 
G0tensor(1991),G0tensor(1992),G0tensor(1993),G0tensor(1994),G0tensor(1995))
  call Hotf_4pt_reduction_last(G1tensor(1107),RedSet_4(108),mass4set(:,3),  & 
G0tensor(1996),G0tensor(1997),G0tensor(1998),G0tensor(1999),G0tensor(2000))
  call Hotf_4pt_reduction_last(G1tensor(621),RedSet_4(109),mass4set(:,3),  & 
G0tensor(2001),G0tensor(2002),G0tensor(2003),G0tensor(2004),G0tensor(2005))
  call Hotf_4pt_reduction_last(G1tensor(617),RedSet_4(152),mass4set(:,10),  & 
G0tensor(2006),G0tensor(2007),G0tensor(2008),G0tensor(2009),G0tensor(2010))
  call Hotf_4pt_reduction_last(G1tensor(634),RedSet_4(107),mass4set(:,12),  & 
G0tensor(2011),G0tensor(2012),G0tensor(2013),G0tensor(2014),G0tensor(2015))
  call Hotf_4pt_reduction_last(G1tensor(1403),RedSet_4(108),mass4set(:,12),  & 
G0tensor(2016),G0tensor(2017),G0tensor(2018),G0tensor(2019),G0tensor(2020))
  call Hotf_4pt_reduction_last(G1tensor(1131),RedSet_4(107),mass4set(:,21),  & 
G0tensor(2021),G0tensor(2022),G0tensor(2023),G0tensor(2024),G0tensor(2025))
  call Hotf_4pt_reduction_last(G1tensor(657),RedSet_4(108),mass4set(:,21),  & 
G0tensor(2026),G0tensor(2027),G0tensor(2028),G0tensor(2029),G0tensor(2030))
  call Hotf_4pt_reduction_last(G1tensor(869),RedSet_4(152),mass4set(:,11),  & 
G0tensor(2031),G0tensor(2032),G0tensor(2033),G0tensor(2034),G0tensor(2035))
  call Hotf_4pt_reduction_last(G1tensor(682),RedSet_4(107),mass4set(:,22),  & 
G0tensor(2036),G0tensor(2037),G0tensor(2038),G0tensor(2039),G0tensor(2040))
  call Hotf_4pt_reduction_last(G1tensor(711),RedSet_4(108),mass4set(:,22),  & 
G0tensor(2041),G0tensor(2042),G0tensor(2043),G0tensor(2044),G0tensor(2045))
  call Hotf_4pt_reduction_last(G1tensor(1031),RedSet_4(109),mass4set(:,4),  & 
G0tensor(2046),G0tensor(2047),G0tensor(2048),G0tensor(2049),G0tensor(2050))
  call Hotf_4pt_reduction_last(G1tensor(732),RedSet_4(153),mass4set(:,2),  & 
G0tensor(2051),G0tensor(2052),G0tensor(2053),G0tensor(2054),G0tensor(2055))
  call Hotf_4pt_reduction_last(G1tensor(713),RedSet_4(112),mass4set(:,2),  & 
G0tensor(2056),G0tensor(2057),G0tensor(2058),G0tensor(2059),G0tensor(2060))
  call Hotf_4pt_reduction_last(G1tensor(747),RedSet_4(113),mass4set(:,2),  & 
G0tensor(2061),G0tensor(2062),G0tensor(2063),G0tensor(2064),G0tensor(2065))
  call Hotf_4pt_reduction_last(G1tensor(719),RedSet_4(114),mass4set(:,2),  & 
G0tensor(2066),G0tensor(2067),G0tensor(2068),G0tensor(2069),G0tensor(2070))
  call Hotf_4pt_reduction_last(G1tensor(725),RedSet_4(153),mass4set(:,10),  & 
G0tensor(2071),G0tensor(2072),G0tensor(2073),G0tensor(2074),G0tensor(2075))
  call Hotf_4pt_reduction_last(G1tensor(774),RedSet_4(112),mass4set(:,12),  & 
G0tensor(2076),G0tensor(2077),G0tensor(2078),G0tensor(2079),G0tensor(2080))
  call Hotf_4pt_reduction_last(G1tensor(755),RedSet_4(113),mass4set(:,12),  & 
G0tensor(2081),G0tensor(2082),G0tensor(2083),G0tensor(2084),G0tensor(2085))
  call Hotf_4pt_reduction_last(G1tensor(771),RedSet_4(112),mass4set(:,3),  & 
G0tensor(2086),G0tensor(2087),G0tensor(2088),G0tensor(2089),G0tensor(2090))
  call Hotf_4pt_reduction_last(G1tensor(783),RedSet_4(113),mass4set(:,3),  & 
G0tensor(2091),G0tensor(2092),G0tensor(2093),G0tensor(2094),G0tensor(2095))
  call Hotf_4pt_reduction_last(G1tensor(1276),RedSet_4(114),mass4set(:,3),  & 
G0tensor(2096),G0tensor(2097),G0tensor(2098),G0tensor(2099),G0tensor(2100))
  call Hotf_4pt_reduction_last(G1tensor(792),RedSet_4(112),mass4set(:,21),  & 
G0tensor(2101),G0tensor(2102),G0tensor(2103),G0tensor(2104),G0tensor(2105))
  call Hotf_4pt_reduction_last(G1tensor(801),RedSet_4(113),mass4set(:,21),  & 
G0tensor(2106),G0tensor(2107),G0tensor(2108),G0tensor(2109),G0tensor(2110))
  call Hotf_4pt_reduction_last(G1tensor(1186),RedSet_4(151),mass4set(:,16),  & 
G0tensor(2111),G0tensor(2112),G0tensor(2113),G0tensor(2114),G0tensor(2115))
  call Hotf_4pt_reduction_last(G1tensor(1198),RedSet_4(102),mass4set(:,22),  & 
G0tensor(2116),G0tensor(2117),G0tensor(2118),G0tensor(2119),G0tensor(2120))
  call Hotf_4pt_reduction_last(G1tensor(828),RedSet_4(88),mass4set(:,1),  & 
G0tensor(2121),G0tensor(2122),G0tensor(2123),G0tensor(2124),G0tensor(2125))
  call Hotf_4pt_reduction_last(G1tensor(834),RedSet_4(103),mass4set(:,5),  & 
G0tensor(2126),G0tensor(2127),G0tensor(2128),G0tensor(2129),G0tensor(2130))
  call Hotf_4pt_reduction_last(G1tensor(850),RedSet_4(116),mass4set(:,2),  & 
G0tensor(2131),G0tensor(2132),G0tensor(2133),G0tensor(2134),G0tensor(2135))
  call Hotf_4pt_reduction_last(G1tensor(855),RedSet_4(116),mass4set(:,10),  & 
G0tensor(2136),G0tensor(2137),G0tensor(2138),G0tensor(2139),G0tensor(2140))
  call Hotf_4pt_reduction_last(G1tensor(897),RedSet_4(116),mass4set(:,11),  & 
G0tensor(2141),G0tensor(2142),G0tensor(2143),G0tensor(2144),G0tensor(2145))
  call Hotf_4pt_reduction_last(G1tensor(898),RedSet_4(119),mass4set(:,2),  & 
G0tensor(2146),G0tensor(2147),G0tensor(2148),G0tensor(2149),G0tensor(2150))
  call Hotf_4pt_reduction_last(G1tensor(927),RedSet_4(119),mass4set(:,10),  & 
G0tensor(2151),G0tensor(2152),G0tensor(2153),G0tensor(2154),G0tensor(2155))
  call Hotf_4pt_reduction_last(G1tensor(1030),RedSet_4(122),mass4set(:,2),  & 
G0tensor(2156),G0tensor(2157),G0tensor(2158),G0tensor(2159),G0tensor(2160))
  call Hotf_4pt_reduction_last(G1tensor(918),RedSet_4(123),mass4set(:,2),  & 
G0tensor(2161),G0tensor(2162),G0tensor(2163),G0tensor(2164),G0tensor(2165))
  call Hotf_4pt_reduction_last(G1tensor(922),RedSet_4(110),mass4set(:,17),  & 
G0tensor(2166),G0tensor(2167),G0tensor(2168),G0tensor(2169),G0tensor(2170))
  call Hotf_4pt_reduction_last(G1tensor(975),RedSet_4(123),mass4set(:,17),  & 
G0tensor(2171),G0tensor(2172),G0tensor(2173),G0tensor(2174),G0tensor(2175))
  call Hotf_4pt_reduction_last(G1tensor(988),RedSet_4(122),mass4set(:,12),  & 
G0tensor(2176),G0tensor(2177),G0tensor(2178),G0tensor(2179),G0tensor(2180))
  call Hotf_4pt_reduction_last(G1tensor(1060),RedSet_4(110),mass4set(:,12),  & 
G0tensor(2181),G0tensor(2182),G0tensor(2183),G0tensor(2184),G0tensor(2185))
  call Hotf_4pt_reduction_last(G1tensor(1017),RedSet_4(110),mass4set(:,23),  & 
G0tensor(2186),G0tensor(2187),G0tensor(2188),G0tensor(2189),G0tensor(2190))
  call Hotf_4pt_reduction_last(G1tensor(1018),RedSet_4(122),mass4set(:,13),  & 
G0tensor(2191),G0tensor(2192),G0tensor(2193),G0tensor(2194),G0tensor(2195))
  call Hotf_4pt_reduction_last(G1tensor(1035),RedSet_4(110),mass4set(:,7),  & 
G0tensor(2196),G0tensor(2197),G0tensor(2198),G0tensor(2199),G0tensor(2200))
  call Hotf_4pt_reduction_last(G1tensor(1038),RedSet_4(123),mass4set(:,19),  & 
G0tensor(2201),G0tensor(2202),G0tensor(2203),G0tensor(2204),G0tensor(2205))
  call Hotf_4pt_reduction_last(G1tensor(1108),RedSet_4(125),mass4set(:,2),  & 
G0tensor(2206),G0tensor(2207),G0tensor(2208),G0tensor(2209),G0tensor(2210))
  call Hotf_4pt_reduction_last(G1tensor(1073),RedSet_4(126),mass4set(:,2),  & 
G0tensor(2211),G0tensor(2212),G0tensor(2213),G0tensor(2214),G0tensor(2215))
  call Hotf_4pt_reduction_last(G1tensor(1085),RedSet_4(125),mass4set(:,12),  & 
G0tensor(2216),G0tensor(2217),G0tensor(2218),G0tensor(2219),G0tensor(2220))
  call Hotf_4pt_reduction_last(G1tensor(1090),RedSet_4(126),mass4set(:,17),  & 
G0tensor(2221),G0tensor(2222),G0tensor(2223),G0tensor(2224),G0tensor(2225))
  call Hotf_4pt_reduction_last(G1tensor(1187),RedSet_4(128),mass4set(:,2),  & 
G0tensor(2226),G0tensor(2227),G0tensor(2228),G0tensor(2229),G0tensor(2230))
  call Hotf_4pt_reduction_last(G1tensor(1113),RedSet_4(128),mass4set(:,10),  & 
G0tensor(2231),G0tensor(2232),G0tensor(2233),G0tensor(2234),G0tensor(2235))
  call Hotf_4pt_reduction_last(G1tensor(1157),RedSet_4(128),mass4set(:,11),  & 
G0tensor(2236),G0tensor(2237),G0tensor(2238),G0tensor(2239),G0tensor(2240))
  call Hotf_4pt_reduction_last(G1tensor(1137),RedSet_4(131),mass4set(:,2),  & 
G0tensor(2241),G0tensor(2242),G0tensor(2243),G0tensor(2244),G0tensor(2245))
  call Hotf_4pt_reduction_last(G1tensor(1151),RedSet_4(131),mass4set(:,10),  & 
G0tensor(2246),G0tensor(2247),G0tensor(2248),G0tensor(2249),G0tensor(2250))
  call Hotf_4pt_reduction_last(G1tensor(1170),RedSet_4(135),mass4set(:,2),  & 
G0tensor(2251),G0tensor(2252),G0tensor(2253),G0tensor(2254),G0tensor(2255))
  call Hotf_4pt_reduction_last(G1tensor(1194),RedSet_4(135),mass4set(:,10),  & 
G0tensor(2256),G0tensor(2257),G0tensor(2258),G0tensor(2259),G0tensor(2260))
  call Hotf_4pt_reduction_last(G1tensor(1216),RedSet_4(136),mass4set(:,10),  & 
G0tensor(2261),G0tensor(2262),G0tensor(2263),G0tensor(2264),G0tensor(2265))
  call Hotf_4pt_reduction_last(G1tensor(1235),RedSet_4(136),mass4set(:,12),  & 
G0tensor(2266),G0tensor(2267),G0tensor(2268),G0tensor(2269),G0tensor(2270))
  call Hotf_4pt_reduction_last(G1tensor(1228),RedSet_4(136),mass4set(:,24),  & 
G0tensor(2271),G0tensor(2272),G0tensor(2273),G0tensor(2274),G0tensor(2275))
  call Hotf_4pt_reduction_last(G1tensor(1240),RedSet_4(139),mass4set(:,2),  & 
G0tensor(2276),G0tensor(2277),G0tensor(2278),G0tensor(2279),G0tensor(2280))
  call Hotf_4pt_reduction_last(G1tensor(1246),RedSet_4(139),mass4set(:,10),  & 
G0tensor(2281),G0tensor(2282),G0tensor(2283),G0tensor(2284),G0tensor(2285))
  call Hotf_4pt_reduction_last(G1tensor(1251),RedSet_4(139),mass4set(:,11),  & 
G0tensor(2286),G0tensor(2287),G0tensor(2288),G0tensor(2289),G0tensor(2290))
  call Hotf_4pt_reduction_last(G1tensor(1259),RedSet_4(136),mass4set(:,8),  & 
G0tensor(2291),G0tensor(2292),G0tensor(2293),G0tensor(2294),G0tensor(2295))
  call Hotf_4pt_reduction_last(G1tensor(1270),RedSet_4(142),mass4set(:,2),  & 
G0tensor(2296),G0tensor(2297),G0tensor(2298),G0tensor(2299),G0tensor(2300))
  call Hotf_4pt_reduction_last(G1tensor(1287),RedSet_4(142),mass4set(:,10),  & 
G0tensor(2301),G0tensor(2302),G0tensor(2303),G0tensor(2304),G0tensor(2305))
  call Hotf_4pt_reduction_last(G1tensor(1311),RedSet_4(143),mass4set(:,10),  & 
G0tensor(2306),G0tensor(2307),G0tensor(2308),G0tensor(2309),G0tensor(2310))
  call Hotf_4pt_reduction_last(G1tensor(1372),RedSet_4(143),mass4set(:,12),  & 
G0tensor(2311),G0tensor(2312),G0tensor(2313),G0tensor(2314),G0tensor(2315))
  call Hotf_4pt_reduction_last(G1tensor(1341),RedSet_4(143),mass4set(:,24),  & 
G0tensor(2316),G0tensor(2317),G0tensor(2318),G0tensor(2319),G0tensor(2320))
  call Hotf_4pt_reduction_last(G1tensor(1353),RedSet_4(146),mass4set(:,2),  & 
G0tensor(2321),G0tensor(2322),G0tensor(2323),G0tensor(2324),G0tensor(2325))
  call Hotf_4pt_reduction_last(G1tensor(1367),RedSet_4(146),mass4set(:,10),  & 
G0tensor(2326),G0tensor(2327),G0tensor(2328),G0tensor(2329),G0tensor(2330))
  call Hotf_4pt_reduction_last(G1tensor(1373),RedSet_4(146),mass4set(:,11),  & 
G0tensor(2331),G0tensor(2332),G0tensor(2333),G0tensor(2334),G0tensor(2335))
  call Hotf_4pt_reduction_last(G1tensor(1407),RedSet_4(143),mass4set(:,8),  & 
G0tensor(2336),G0tensor(2337),G0tensor(2338),G0tensor(2339),G0tensor(2340))
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(7),mass4set(:,28),  & 
G0tensor(2341),G0tensor(2342),G0tensor(2343),G0tensor(2344),G0tensor(2345))
  call Hotf_4pt_reduction_last(G1tensor(37),RedSet_4(22),mass4set(:,28),  & 
G0tensor(2346),G0tensor(2347),G0tensor(2348),G0tensor(2349),G0tensor(2350))
  call Hotf_4pt_reduction_last(G1tensor(73),RedSet_4(88),mass4set(:,29),  & 
G0tensor(2351),G0tensor(2352),G0tensor(2353),G0tensor(2354),G0tensor(2355))
  call Hotf_4pt_reduction_last(G1tensor(109),RedSet_4(95),mass4set(:,29),  & 
G0tensor(2356),G0tensor(2357),G0tensor(2358),G0tensor(2359),G0tensor(2360))
  call Hotf_4pt_reduction_last(G1tensor(217),RedSet_4(90),mass4set(:,30),  & 
G0tensor(2361),G0tensor(2362),G0tensor(2363),G0tensor(2364),G0tensor(2365))
  call Hotf_4pt_reduction_last(G1tensor(325),RedSet_4(104),mass4set(:,30),  & 
G0tensor(2366),G0tensor(2367),G0tensor(2368),G0tensor(2369),G0tensor(2370))
  call Hotf_4pt_reduction_last(G1tensor(1450),RedSet_4(7),mass4set(:,3),  & 
G0tensor(2371),G0tensor(2372),G0tensor(2373),G0tensor(2374),G0tensor(2375))
  call Hotf_4pt_reduction_last(G1tensor(1445),RedSet_4(7),mass4set(:,4),  & 
G0tensor(2376),G0tensor(2377),G0tensor(2378),G0tensor(2379),G0tensor(2380))
  call Hotf_4pt_reduction_last(G1tensor(1468),RedSet_4(22),mass4set(:,3),  & 
G0tensor(2381),G0tensor(2382),G0tensor(2383),G0tensor(2384),G0tensor(2385))
  call Hotf_4pt_reduction_last(G1tensor(1487),RedSet_4(22),mass4set(:,4),  & 
G0tensor(2386),G0tensor(2387),G0tensor(2388),G0tensor(2389),G0tensor(2390))
  call Hotf_4pt_reduction_last(G1tensor(1523),RedSet_4(136),mass4set(:,5),  & 
G0tensor(2391),G0tensor(2392),G0tensor(2393),G0tensor(2394),G0tensor(2395))
  call Hotf_4pt_reduction_last(G1tensor(1511),RedSet_4(143),mass4set(:,5),  & 
G0tensor(2396),G0tensor(2397),G0tensor(2398),G0tensor(2399),G0tensor(2400))
  call Hotf_4pt_reduction_last(G1tensor(1540),RedSet_4(88),mass4set(:,10),  & 
G0tensor(2401),G0tensor(2402),G0tensor(2403),G0tensor(2404),G0tensor(2405))
  call Hotf_4pt_reduction_last(G1tensor(1546),RedSet_4(88),mass4set(:,11),  & 
G0tensor(2406),G0tensor(2407),G0tensor(2408),G0tensor(2409),G0tensor(2410))
  call Hotf_4pt_reduction_last(G1tensor(1551),RedSet_4(95),mass4set(:,10),  & 
G0tensor(2411),G0tensor(2412),G0tensor(2413),G0tensor(2414),G0tensor(2415))
  call Hotf_4pt_reduction_last(G1tensor(1556),RedSet_4(95),mass4set(:,11),  & 
G0tensor(2416),G0tensor(2417),G0tensor(2418),G0tensor(2419),G0tensor(2420))
  call Hotf_4pt_reduction_last(G1tensor(1561),RedSet_4(90),mass4set(:,12),  & 
G0tensor(2421),G0tensor(2422),G0tensor(2423),G0tensor(2424),G0tensor(2425))
  call Hotf_4pt_reduction_last(G1tensor(1566),RedSet_4(90),mass4set(:,13),  & 
G0tensor(2426),G0tensor(2427),G0tensor(2428),G0tensor(2429),G0tensor(2430))
  call Hotf_4pt_reduction_last(G1tensor(1571),RedSet_4(104),mass4set(:,12),  & 
G0tensor(2431),G0tensor(2432),G0tensor(2433),G0tensor(2434),G0tensor(2435))
  call Hotf_4pt_reduction_last(G1tensor(1576),RedSet_4(104),mass4set(:,13),  & 
G0tensor(2436),G0tensor(2437),G0tensor(2438),G0tensor(2439),G0tensor(2440))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  call ol_merge_tensors(T0sum(89),[G0tensor(441)])
  call ol_merge_tensors(T0sum(90),[G0tensor(446)])
  call ol_merge_tensors(T0sum(91),[G0tensor(451)])
  call ol_merge_tensors(T0sum(92),[G0tensor(456)])
  call ol_merge_tensors(T0sum(93),[G0tensor(461)])
  call ol_merge_tensors(T0sum(94),[G0tensor(466)])
  call ol_merge_tensors(T0sum(95),[G0tensor(471)])
  call ol_merge_tensors(T0sum(96),[G0tensor(476)])
  call ol_merge_tensors(T0sum(97),[G0tensor(481)])
  call ol_merge_tensors(T0sum(98),[G0tensor(486)])
  call ol_merge_tensors(T0sum(99),[G0tensor(491)])
  call ol_merge_tensors(T0sum(100),[G0tensor(496)])
  call ol_merge_tensors(T0sum(101),[G0tensor(501)])
  call ol_merge_tensors(T0sum(102),[G0tensor(506)])
  call ol_merge_tensors(T0sum(103),[G0tensor(511)])
  call ol_merge_tensors(T0sum(104),[G0tensor(516)])
  call ol_merge_tensors(T0sum(105),[G0tensor(521)])
  call ol_merge_tensors(T0sum(106),[G0tensor(526)])
  call ol_merge_tensors(T0sum(107),[G0tensor(531)])
  call ol_merge_tensors(T0sum(108),[G0tensor(536)])
  call ol_merge_tensors(T0sum(109),[G0tensor(541)])
  call ol_merge_tensors(T0sum(110),[G0tensor(546)])
  call ol_merge_tensors(T0sum(111),[G0tensor(551)])
  call ol_merge_tensors(T0sum(112),[G0tensor(556)])
  call ol_merge_tensors(T0sum(113),[G0tensor(561)])
  call ol_merge_tensors(T0sum(114),[G0tensor(566)])
  call ol_merge_tensors(T0sum(115),[G0tensor(571)])
  call ol_merge_tensors(T0sum(116),[G0tensor(576)])
  call ol_merge_tensors(T0sum(117),[G0tensor(581)])
  call ol_merge_tensors(T0sum(118),[G0tensor(586)])
  call ol_merge_tensors(T0sum(119),[G0tensor(591)])
  call ol_merge_tensors(T0sum(120),[G0tensor(596)])
  call ol_merge_tensors(T0sum(121),[G0tensor(601)])
  call ol_merge_tensors(T0sum(122),[G0tensor(606)])
  call ol_merge_tensors(T0sum(123),[G0tensor(611)])
  call ol_merge_tensors(T0sum(124),[G0tensor(616)])
  call ol_merge_tensors(T0sum(125),[G0tensor(621)])
  call ol_merge_tensors(T0sum(126),[G0tensor(626)])
  call ol_merge_tensors(T0sum(127),[G0tensor(631)])
  call ol_merge_tensors(T0sum(128),[G0tensor(636)])
  call ol_merge_tensors(T0sum(129),[G0tensor(641)])
  call ol_merge_tensors(T0sum(130),[G0tensor(646)])
  call ol_merge_tensors(T0sum(131),[G0tensor(651)])
  call ol_merge_tensors(T0sum(132),[G0tensor(656)])
  call ol_merge_tensors(T0sum(133),[G0tensor(661)])
  call ol_merge_tensors(T0sum(134),[G0tensor(666)])
  call ol_merge_tensors(T0sum(135),[G0tensor(671)])
  call ol_merge_tensors(T0sum(136),[G0tensor(676)])
  call ol_merge_tensors(T0sum(137),[G0tensor(681)])
  call ol_merge_tensors(T0sum(138),[G0tensor(686)])
  call ol_merge_tensors(T0sum(139),[G0tensor(691)])
  call ol_merge_tensors(T0sum(140),[G0tensor(696)])
  call ol_merge_tensors(T0sum(141),[G0tensor(701)])
  call ol_merge_tensors(T0sum(142),[G0tensor(706)])
  call ol_merge_tensors(T0sum(143),[G0tensor(711)])
  call ol_merge_tensors(T0sum(144),[G0tensor(716)])
  call ol_merge_tensors(T0sum(145),[G0tensor(721)])
  call ol_merge_tensors(T0sum(146),[G0tensor(726)])
  call ol_merge_tensors(T0sum(147),[G0tensor(731)])
  call ol_merge_tensors(T0sum(148),[G0tensor(736)])
  call ol_merge_tensors(T0sum(149),[G0tensor(741)])
  call ol_merge_tensors(T0sum(150),[G0tensor(746)])
  call ol_merge_tensors(T0sum(151),[G0tensor(751)])
  call ol_merge_tensors(T0sum(152),[G0tensor(756)])
  call ol_merge_tensors(T0sum(153),[G0tensor(761)])
  call ol_merge_tensors(T0sum(154),[G0tensor(766)])
  call ol_merge_tensors(T0sum(155),[G0tensor(771)])
  call ol_merge_tensors(T0sum(156),[G0tensor(776)])
  call ol_merge_tensors(T0sum(157),[G0tensor(781)])
  call ol_merge_tensors(T0sum(158),[G0tensor(786)])
  call ol_merge_tensors(T0sum(159),[G0tensor(791)])
  call ol_merge_tensors(T0sum(160),[G0tensor(796)])
  call ol_merge_tensors(T0sum(161),[G0tensor(801)])
  call ol_merge_tensors(T0sum(162),[G0tensor(806)])
  call ol_merge_tensors(T0sum(163),[G0tensor(811)])
  call ol_merge_tensors(T0sum(164),[G0tensor(816)])
  call ol_merge_tensors(T0sum(165),[G0tensor(821)])
  call ol_merge_tensors(T0sum(166),[G0tensor(826)])
  call ol_merge_tensors(T0sum(167),[G0tensor(831)])
  call ol_merge_tensors(T0sum(168),[G0tensor(836)])
  call ol_merge_tensors(T0sum(169),[G0tensor(841)])
  call ol_merge_tensors(T0sum(170),[G0tensor(846)])
  call ol_merge_tensors(T0sum(171),[G0tensor(851)])
  call ol_merge_tensors(T0sum(172),[G0tensor(856)])
  call ol_merge_tensors(T0sum(173),[G0tensor(861)])
  call ol_merge_tensors(T0sum(174),[G0tensor(866)])
  call ol_merge_tensors(T0sum(175),[G0tensor(871)])
  call ol_merge_tensors(T0sum(176),[G0tensor(876)])
  call ol_merge_tensors(T0sum(177),[G0tensor(881)])
  call ol_merge_tensors(T0sum(178),[G0tensor(886)])
  call ol_merge_tensors(T0sum(179),[G0tensor(891)])
  call ol_merge_tensors(T0sum(180),[G0tensor(896)])
  call ol_merge_tensors(T0sum(181),[G0tensor(901)])
  call ol_merge_tensors(T0sum(182),[G0tensor(906)])
  call ol_merge_tensors(T0sum(183),[G0tensor(911)])
  call ol_merge_tensors(T0sum(184),[G0tensor(916)])
  call ol_merge_tensors(T0sum(185),[G0tensor(921)])
  call ol_merge_tensors(T0sum(186),[G0tensor(926)])
  call ol_merge_tensors(T0sum(187),[G0tensor(931)])
  call ol_merge_tensors(T0sum(188),[G0tensor(936)])
  call ol_merge_tensors(T0sum(189),[G0tensor(941)])
  call ol_merge_tensors(T0sum(190),[G0tensor(946)])
  call ol_merge_tensors(T0sum(191),[G0tensor(951)])
  call ol_merge_tensors(T0sum(192),[G0tensor(956)])
  call ol_merge_tensors(T0sum(193),[G0tensor(961)])
  call ol_merge_tensors(T0sum(194),[G0tensor(966)])
  call ol_merge_tensors(T0sum(195),[G0tensor(971)])
  call ol_merge_tensors(T0sum(196),[G0tensor(976)])
  call ol_merge_tensors(T0sum(197),[G0tensor(981)])
  call ol_merge_tensors(T0sum(198),[G0tensor(986)])
  call ol_merge_tensors(T0sum(199),[G0tensor(991)])
  call ol_merge_tensors(T0sum(200),[G0tensor(996)])
  call ol_merge_tensors(T0sum(201),[G0tensor(1001)])
  call ol_merge_tensors(T0sum(202),[G0tensor(1006)])
  call ol_merge_tensors(T0sum(203),[G0tensor(1011)])
  call ol_merge_tensors(T0sum(204),[G0tensor(1016)])
  call ol_merge_tensors(T0sum(205),[G0tensor(1021)])
  call ol_merge_tensors(T0sum(206),[G0tensor(1026)])
  call ol_merge_tensors(T0sum(207),[G0tensor(1031)])
  call ol_merge_tensors(T0sum(208),[G0tensor(1036)])
  call ol_merge_tensors(T0sum(209),[G0tensor(1041)])
  call ol_merge_tensors(T0sum(210),[G0tensor(1046)])
  call ol_merge_tensors(T0sum(211),[G0tensor(1051)])
  call ol_merge_tensors(T0sum(212),[G0tensor(1056)])
  call ol_merge_tensors(T0sum(213),[G0tensor(1061)])
  call ol_merge_tensors(T0sum(214),[G0tensor(1066)])
  call ol_merge_tensors(T0sum(215),[G0tensor(1071)])
  call ol_merge_tensors(T0sum(216),[G0tensor(1076)])
  call ol_merge_tensors(T0sum(217),[G0tensor(1081)])
  call ol_merge_tensors(T0sum(218),[G0tensor(1086)])
  call ol_merge_tensors(T0sum(219),[G0tensor(1091)])
  call ol_merge_tensors(T0sum(220),[G0tensor(1096)])
  call ol_merge_tensors(T0sum(221),[G0tensor(1101)])
  call ol_merge_tensors(T0sum(222),[G0tensor(1106)])
  call ol_merge_tensors(T0sum(223),[G0tensor(1111)])
  call ol_merge_tensors(T0sum(224),[G0tensor(1116)])
  call ol_merge_tensors(T0sum(225),[G0tensor(1121)])
  call ol_merge_tensors(T0sum(226),[G0tensor(1126)])
  call ol_merge_tensors(T0sum(227),[G0tensor(1131)])
  call ol_merge_tensors(T0sum(228),[G0tensor(1136)])
  call ol_merge_tensors(T0sum(229),[G0tensor(1141)])
  call ol_merge_tensors(T0sum(230),[G0tensor(1146)])
  call ol_merge_tensors(T0sum(231),[G0tensor(1151)])
  call ol_merge_tensors(T0sum(232),[G0tensor(1156)])
  call ol_merge_tensors(T0sum(233),[G0tensor(1161)])
  call ol_merge_tensors(T0sum(234),[G0tensor(1166)])
  call ol_merge_tensors(T0sum(235),[G0tensor(1171)])
  call ol_merge_tensors(T0sum(236),[G0tensor(1176)])
  call ol_merge_tensors(T0sum(237),[G0tensor(1181)])
  call ol_merge_tensors(T0sum(238),[G0tensor(1186)])
  call ol_merge_tensors(T0sum(239),[G0tensor(1191)])
  call ol_merge_tensors(T0sum(240),[G0tensor(1196)])
  call ol_merge_tensors(T0sum(241),[G0tensor(1201)])
  call ol_merge_tensors(T0sum(242),[G0tensor(1206)])
  call ol_merge_tensors(T0sum(243),[G0tensor(1211)])
  call ol_merge_tensors(T0sum(244),[G0tensor(1216)])
  call ol_merge_tensors(T0sum(245),[G0tensor(1221)])
  call ol_merge_tensors(T0sum(246),[G0tensor(1226)])
  call ol_merge_tensors(T0sum(247),[G0tensor(1231)])
  call ol_merge_tensors(T0sum(248),[G0tensor(1236)])
  call ol_merge_tensors(T0sum(249),[G0tensor(1241)])
  call ol_merge_tensors(T0sum(250),[G0tensor(1246)])
  call ol_merge_tensors(T0sum(251),[G0tensor(1251)])
  call ol_merge_tensors(T0sum(252),[G0tensor(1256)])
  call ol_merge_tensors(T0sum(253),[G0tensor(1261)])
  call ol_merge_tensors(T0sum(254),[G0tensor(1266)])
  call ol_merge_tensors(T0sum(255),[G0tensor(1271)])
  call ol_merge_tensors(T0sum(256),[G0tensor(1276)])
  call ol_merge_tensors(T0sum(257),[G0tensor(1281)])
  call ol_merge_tensors(T0sum(258),[G0tensor(1286)])
  call ol_merge_tensors(T0sum(259),[G0tensor(1291)])
  call ol_merge_tensors(T0sum(260),[G0tensor(1296)])
  call ol_merge_tensors(T0sum(261),[G0tensor(1301)])
  call ol_merge_tensors(T0sum(262),[G0tensor(1306)])
  call ol_merge_tensors(T0sum(263),[G0tensor(1311)])
  call ol_merge_tensors(T0sum(264),[G0tensor(1316)])
  call ol_merge_tensors(T0sum(265),[G0tensor(1321)])
  call ol_merge_tensors(T0sum(266),[G0tensor(1326)])
  call ol_merge_tensors(T0sum(267),[G0tensor(1331)])
  call ol_merge_tensors(T0sum(268),[G0tensor(1336)])
  call ol_merge_tensors(T0sum(269),[G0tensor(1341)])
  call ol_merge_tensors(T0sum(270),[G0tensor(1346)])
  call ol_merge_tensors(T0sum(271),[G0tensor(1351)])
  call ol_merge_tensors(T0sum(272),[G0tensor(1356)])
  call ol_merge_tensors(T0sum(273),[G0tensor(1361)])
  call ol_merge_tensors(T0sum(274),[G0tensor(1366)])
  call ol_merge_tensors(T0sum(275),[G0tensor(1371)])
  call ol_merge_tensors(T0sum(276),[G0tensor(1376)])
  call ol_merge_tensors(T0sum(277),[G0tensor(1381)])
  call ol_merge_tensors(T0sum(278),[G0tensor(1386)])
  call ol_merge_tensors(T0sum(279),[G0tensor(1391)])
  call ol_merge_tensors(T0sum(280),[G0tensor(1396)])
  call ol_merge_tensors(T0sum(281),[G0tensor(1401)])
  call ol_merge_tensors(T0sum(282),[G0tensor(1406)])
  call ol_merge_tensors(T0sum(283),[G0tensor(1411)])
  call ol_merge_tensors(T0sum(284),[G0tensor(1416)])
  call ol_merge_tensors(T0sum(285),[G0tensor(1421)])
  call ol_merge_tensors(T0sum(286),[G0tensor(1426)])
  call ol_merge_tensors(T0sum(287),[G0tensor(1431)])
  call ol_merge_tensors(T0sum(288),[G0tensor(1436)])
  call ol_merge_tensors(T0sum(289),[G0tensor(1441)])
  call ol_merge_tensors(T0sum(290),[G0tensor(1446)])
  call ol_merge_tensors(T0sum(291),[G0tensor(1451)])
  call ol_merge_tensors(T0sum(292),[G0tensor(1456)])
  call ol_merge_tensors(T0sum(293),[G0tensor(1461)])
  call ol_merge_tensors(T0sum(294),[G0tensor(1466)])
  call ol_merge_tensors(T0sum(295),[G0tensor(1471)])
  call ol_merge_tensors(T0sum(296),[G0tensor(1476)])
  call ol_merge_tensors(T0sum(297),[G0tensor(1481)])
  call ol_merge_tensors(T0sum(298),[G0tensor(1486)])
  call ol_merge_tensors(T0sum(299),[G0tensor(1491)])
  call ol_merge_tensors(T0sum(300),[G0tensor(1496)])
  call ol_merge_tensors(T0sum(301),[G0tensor(1501)])
  call ol_merge_tensors(T0sum(302),[G0tensor(1506)])
  call ol_merge_tensors(T0sum(303),[G0tensor(1511)])
  call ol_merge_tensors(T0sum(304),[G0tensor(1516)])
  call ol_merge_tensors(T0sum(305),[G0tensor(1521)])
  call ol_merge_tensors(T0sum(306),[G0tensor(1526)])
  call ol_merge_tensors(T0sum(307),[G0tensor(1531)])
  call ol_merge_tensors(T0sum(308),[G0tensor(1536)])
  call ol_merge_tensors(T0sum(309),[G0tensor(1541)])
  call ol_merge_tensors(T0sum(310),[G0tensor(1546)])
  call ol_merge_tensors(T0sum(311),[G0tensor(1551)])
  call ol_merge_tensors(T0sum(312),[G0tensor(1556)])
  call ol_merge_tensors(T0sum(313),[G0tensor(1561)])
  call ol_merge_tensors(T0sum(314),[G0tensor(1566)])
  call ol_merge_tensors(T0sum(315),[G0tensor(1571)])
  call ol_merge_tensors(T0sum(316),[G0tensor(1576)])
  call ol_merge_tensors(T0sum(317),[G0tensor(1581)])
  call ol_merge_tensors(T0sum(318),[G0tensor(1586)])
  call ol_merge_tensors(T0sum(319),[G0tensor(1591)])
  call ol_merge_tensors(T0sum(320),[G0tensor(1596)])
  call ol_merge_tensors(T0sum(321),[G0tensor(1601)])
  call ol_merge_tensors(T0sum(322),[G0tensor(1606)])
  call ol_merge_tensors(T0sum(323),[G0tensor(1611)])
  call ol_merge_tensors(T0sum(324),[G0tensor(1616)])
  call ol_merge_tensors(T0sum(325),[G0tensor(1621)])
  call ol_merge_tensors(T0sum(326),[G0tensor(1626)])
  call ol_merge_tensors(T0sum(327),[G0tensor(1631)])
  call ol_merge_tensors(T0sum(328),[G0tensor(1636)])
  call ol_merge_tensors(T0sum(329),[G0tensor(1641)])
  call ol_merge_tensors(T0sum(330),[G0tensor(1646)])
  call ol_merge_tensors(T0sum(331),[G0tensor(1651)])
  call ol_merge_tensors(T0sum(332),[G0tensor(1656)])
  call ol_merge_tensors(T0sum(333),[G0tensor(1661)])
  call ol_merge_tensors(T0sum(334),[G0tensor(1666)])
  call ol_merge_tensors(T0sum(335),[G0tensor(1671)])
  call ol_merge_tensors(T0sum(336),[G0tensor(1676)])
  call ol_merge_tensors(T0sum(337),[G0tensor(1681)])
  call ol_merge_tensors(T0sum(338),[G0tensor(1686)])
  call ol_merge_tensors(T0sum(339),[G0tensor(1691)])
  call ol_merge_tensors(T0sum(340),[G0tensor(1696)])
  call ol_merge_tensors(T0sum(341),[G0tensor(1701)])
  call ol_merge_tensors(T0sum(342),[G0tensor(1706)])
  call ol_merge_tensors(T0sum(343),[G0tensor(1711)])
  call ol_merge_tensors(T0sum(344),[G0tensor(1716)])
  call ol_merge_tensors(T0sum(345),[G0tensor(1721)])
  call ol_merge_tensors(T0sum(346),[G0tensor(1726)])
  call ol_merge_tensors(T0sum(347),[G0tensor(1731)])
  call ol_merge_tensors(T0sum(348),[G0tensor(1736)])
  call ol_merge_tensors(T0sum(349),[G0tensor(1741)])
  call ol_merge_tensors(T0sum(350),[G0tensor(1746)])
  call ol_merge_tensors(T0sum(351),[G0tensor(1751)])
  call ol_merge_tensors(T0sum(352),[G0tensor(1756)])
  call ol_merge_tensors(T0sum(353),[G0tensor(1761)])
  call ol_merge_tensors(T0sum(354),[G0tensor(1766)])
  call ol_merge_tensors(T0sum(355),[G0tensor(1771)])
  call ol_merge_tensors(T0sum(356),[G0tensor(1776)])
  call ol_merge_tensors(T0sum(357),[G0tensor(1781)])
  call ol_merge_tensors(T0sum(358),[G0tensor(1786)])
  call ol_merge_tensors(T0sum(359),[G0tensor(1791)])
  call ol_merge_tensors(T0sum(360),[G0tensor(1796)])
  call ol_merge_tensors(T0sum(361),[G0tensor(1801)])
  call ol_merge_tensors(T0sum(362),[G0tensor(1806)])
  call ol_merge_tensors(T0sum(363),[G0tensor(1811)])
  call ol_merge_tensors(T0sum(364),[G0tensor(1816)])
  call ol_merge_tensors(T0sum(365),[G0tensor(1821)])
  call ol_merge_tensors(T0sum(366),[G0tensor(1826)])
  call ol_merge_tensors(T0sum(367),[G0tensor(1831)])
  call ol_merge_tensors(T0sum(368),[G0tensor(1836)])
  call ol_merge_tensors(T0sum(369),[G0tensor(1841)])
  call ol_merge_tensors(T0sum(370),[G0tensor(1846)])
  call ol_merge_tensors(T0sum(371),[G0tensor(1851)])
  call ol_merge_tensors(T0sum(372),[G0tensor(1856)])
  call ol_merge_tensors(T0sum(373),[G0tensor(1861)])
  call ol_merge_tensors(T0sum(374),[G0tensor(1866)])
  call ol_merge_tensors(T0sum(375),[G0tensor(1871)])
  call ol_merge_tensors(T0sum(376),[G0tensor(1876)])
  call ol_merge_tensors(T0sum(377),[G0tensor(1881)])
  call ol_merge_tensors(T0sum(378),[G0tensor(1886)])
  call ol_merge_tensors(T0sum(379),[G0tensor(1891)])
  call ol_merge_tensors(T0sum(380),[G0tensor(1896)])
  call ol_merge_tensors(T0sum(381),[G0tensor(1901)])
  call ol_merge_tensors(T0sum(382),[G0tensor(1906)])
  call ol_merge_tensors(T0sum(383),[G0tensor(1911)])
  call ol_merge_tensors(T0sum(384),[G0tensor(1916)])
  call ol_merge_tensors(T0sum(385),[G0tensor(1921)])
  call ol_merge_tensors(T0sum(386),[G0tensor(1926)])
  call ol_merge_tensors(T0sum(387),[G0tensor(1931)])
  call ol_merge_tensors(T0sum(388),[G0tensor(1936)])
  call ol_merge_tensors(T0sum(389),[G0tensor(1941)])
  call ol_merge_tensors(T0sum(390),[G0tensor(1946)])
  call ol_merge_tensors(T0sum(391),[G0tensor(1951)])
  call ol_merge_tensors(T0sum(392),[G0tensor(1956)])
  call ol_merge_tensors(T0sum(393),[G0tensor(1961)])
  call ol_merge_tensors(T0sum(394),[G0tensor(1966)])
  call ol_merge_tensors(T0sum(395),[G0tensor(1971)])
  call ol_merge_tensors(T0sum(396),[G0tensor(1976)])
  call ol_merge_tensors(T0sum(397),[G0tensor(1981)])
  call ol_merge_tensors(T0sum(398),[G0tensor(1986)])
  call ol_merge_tensors(T0sum(399),[G0tensor(1991)])
  call ol_merge_tensors(T0sum(400),[G0tensor(1996)])
  call ol_merge_tensors(T0sum(401),[G0tensor(2001)])
  call ol_merge_tensors(T0sum(402),[G0tensor(2006)])
  call ol_merge_tensors(T0sum(403),[G0tensor(2011)])
  call ol_merge_tensors(T0sum(404),[G0tensor(2016)])
  call ol_merge_tensors(T0sum(405),[G0tensor(2021)])
  call ol_merge_tensors(T0sum(406),[G0tensor(2026)])
  call ol_merge_tensors(T0sum(407),[G0tensor(2031)])
  call ol_merge_tensors(T0sum(408),[G0tensor(2036)])
  call ol_merge_tensors(T0sum(409),[G0tensor(2041)])
  call ol_merge_tensors(T0sum(410),[G0tensor(2046)])
  call ol_merge_tensors(T0sum(411),[G0tensor(2051)])
  call ol_merge_tensors(T0sum(412),[G0tensor(2056)])
  call ol_merge_tensors(T0sum(413),[G0tensor(2061)])
  call ol_merge_tensors(T0sum(414),[G0tensor(2066)])
  call ol_merge_tensors(T0sum(415),[G0tensor(2071)])
  call ol_merge_tensors(T0sum(416),[G0tensor(2076)])
  call ol_merge_tensors(T0sum(417),[G0tensor(2081)])
  call ol_merge_tensors(T0sum(418),[G0tensor(2086)])
  call ol_merge_tensors(T0sum(419),[G0tensor(2091)])
  call ol_merge_tensors(T0sum(420),[G0tensor(2096)])
  call ol_merge_tensors(T0sum(421),[G0tensor(2101)])
  call ol_merge_tensors(T0sum(422),[G0tensor(2106)])
  call ol_merge_tensors(T0sum(423),[G0tensor(2111)])
  call ol_merge_tensors(T0sum(424),[G0tensor(2116)])
  call ol_merge_tensors(T0sum(425),[G0tensor(2121)])
  call ol_merge_tensors(T0sum(426),[G0tensor(2126)])
  call ol_merge_tensors(T0sum(427),[G0tensor(2131)])
  call ol_merge_tensors(T0sum(428),[G0tensor(2136)])
  call ol_merge_tensors(T0sum(429),[G0tensor(2141)])
  call ol_merge_tensors(T0sum(430),[G0tensor(2146)])
  call ol_merge_tensors(T0sum(431),[G0tensor(2151)])
  call ol_merge_tensors(T0sum(432),[G0tensor(2156)])
  call ol_merge_tensors(T0sum(433),[G0tensor(2161)])
  call ol_merge_tensors(T0sum(434),[G0tensor(2166)])
  call ol_merge_tensors(T0sum(435),[G0tensor(2171)])
  call ol_merge_tensors(T0sum(436),[G0tensor(2176)])
  call ol_merge_tensors(T0sum(437),[G0tensor(2181)])
  call ol_merge_tensors(T0sum(438),[G0tensor(2186)])
  call ol_merge_tensors(T0sum(439),[G0tensor(2191)])
  call ol_merge_tensors(T0sum(440),[G0tensor(2196)])
  call ol_merge_tensors(T0sum(441),[G0tensor(2201)])
  call ol_merge_tensors(T0sum(442),[G0tensor(2206)])
  call ol_merge_tensors(T0sum(443),[G0tensor(2211)])
  call ol_merge_tensors(T0sum(444),[G0tensor(2216)])
  call ol_merge_tensors(T0sum(445),[G0tensor(2221)])
  call ol_merge_tensors(T0sum(446),[G0tensor(2226)])
  call ol_merge_tensors(T0sum(447),[G0tensor(2231)])
  call ol_merge_tensors(T0sum(448),[G0tensor(2236)])
  call ol_merge_tensors(T0sum(449),[G0tensor(2241)])
  call ol_merge_tensors(T0sum(450),[G0tensor(2246)])
  call ol_merge_tensors(T0sum(451),[G0tensor(2251)])
  call ol_merge_tensors(T0sum(452),[G0tensor(2256)])
  call ol_merge_tensors(T0sum(453),[G0tensor(2261)])
  call ol_merge_tensors(T0sum(454),[G0tensor(2266)])
  call ol_merge_tensors(T0sum(455),[G0tensor(2271)])
  call ol_merge_tensors(T0sum(456),[G0tensor(2276)])
  call ol_merge_tensors(T0sum(457),[G0tensor(2281)])
  call ol_merge_tensors(T0sum(458),[G0tensor(2286)])
  call ol_merge_tensors(T0sum(459),[G0tensor(2291)])
  call ol_merge_tensors(T0sum(460),[G0tensor(2296)])
  call ol_merge_tensors(T0sum(461),[G0tensor(2301)])
  call ol_merge_tensors(T0sum(462),[G0tensor(2306)])
  call ol_merge_tensors(T0sum(463),[G0tensor(2311)])
  call ol_merge_tensors(T0sum(464),[G0tensor(2316)])
  call ol_merge_tensors(T0sum(465),[G0tensor(2321)])
  call ol_merge_tensors(T0sum(466),[G0tensor(2326)])
  call ol_merge_tensors(T0sum(467),[G0tensor(2331)])
  call ol_merge_tensors(T0sum(468),[G0tensor(2336)])
  call ol_merge_tensors(T0sum(469),[G0tensor(2341)])
  call ol_merge_tensors(T0sum(470),[G0tensor(2346)])
  call ol_merge_tensors(T0sum(471),[G0tensor(2351)])
  call ol_merge_tensors(T0sum(472),[G0tensor(2356)])
  call ol_merge_tensors(T0sum(473),[G0tensor(2361)])
  call ol_merge_tensors(T0sum(474),[G0tensor(2366)])
  call ol_merge_tensors(T0sum(475),[G0tensor(2371)])
  call ol_merge_tensors(T0sum(476),[G0tensor(2376)])
  call ol_merge_tensors(T0sum(477),[G0tensor(2381)])
  call ol_merge_tensors(T0sum(478),[G0tensor(2386)])
  call ol_merge_tensors(T0sum(479),[G0tensor(2391)])
  call ol_merge_tensors(T0sum(480),[G0tensor(2396)])
  call ol_merge_tensors(T0sum(481),[G0tensor(2401)])
  call ol_merge_tensors(T0sum(482),[G0tensor(2406)])
  call ol_merge_tensors(T0sum(483),[G0tensor(2411)])
  call ol_merge_tensors(T0sum(484),[G0tensor(2416)])
  call ol_merge_tensors(T0sum(485),[G0tensor(2421)])
  call ol_merge_tensors(T0sum(486),[G0tensor(2426)])
  call ol_merge_tensors(T0sum(487),[G0tensor(2431)])
  call ol_merge_tensors(T0sum(488),[G0tensor(2436)])
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(529),h0tab(:,529),[32,15,16],[nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,303),heltab2x64(:,:,529))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(530),h0tab(:,530),[32,15,16],[nMW,nMW,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,304),heltab2x64(:,:,530))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(531),h0tab(:,531),[32,15,16],[nMW,nMW,0],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,305),heltab2x64(:,:,531))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(532),h0tab(:,532),[32,15,16],[nMW,nMW,0],4,2,wf4(:,3),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,306),heltab2x64(:,:,532))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(533),h0tab(:,533),[51,4,8],[nMW,0,nMW],4,2,wf4(:,1),wf4(:,5))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,1),wf4(:,5),G0H4(7),m4h4x4x4(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(534),h0tab(:,534),[51,4,8],[nMW,0,nMW],4,2,wf4(:,1),wf4(:,6))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,1),wf4(:,6),G0H4(5),m4h4x4x4(:,2),heltab3x64(:,:,2))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(535),h0tab(:,535),[51,4,8],[nMW,0,nMW],4,2,wf4(:,4),wf4(:,5))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,4),wf4(:,5),G0H4(4),m4h4x4x4(:,3),heltab3x64(:,:,3))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(536),h0tab(:,536),[51,4,8],[nMW,0,nMW],4,2,wf4(:,4),wf4(:,6))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,4),wf4(:,6),G0H4(2),m4h4x4x4(:,4),heltab3x64(:,:,4))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(537),h0tab(:,537),[60,1,2],[nMW,0,nMW],4,2,wf4(:,2),wf4(:,5))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,2),wf4(:,5),G0H4(1),m4h4x4x4(:,5),heltab3x64(:,:,5))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(538),h0tab(:,538),[60,1,2],[nMW,0,nMW],4,2,wf4(:,2),wf4(:,6))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,2),wf4(:,6),G0H4(3),m4h4x4x4(:,6),heltab3x64(:,:,6))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(539),h0tab(:,539),[60,1,2],[nMW,0,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,3),wf4(:,5),G0H4(6),m4h4x4x4(:,7),heltab3x64(:,:,7))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(540),h0tab(:,540),[60,1,2],[nMW,0,nMW],4,2,wf4(:,3),wf4(:,6))
  call Hloop_VWW_V(ntryL,G0H64(1),wf4(:,3),wf4(:,6),G0H4(8),m4h4x4x4(:,8),heltab3x64(:,:,8))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(541),h0tab(:,541),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(12),m3h4x16(:,119),heltab2x64(:,:,533))
  call Hloop_A_Q(ntryL,G0H16(12),48,0,G1H16(12),n2h16(269))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(542),h0tab(:,542),[48,3,12],[nML,nML,nML],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(15),m3h4x16(:,120),heltab2x64(:,:,534))
  call Hloop_A_Q(ntryL,G0H16(15),48,nML,G1H16(20),n2h16(270))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(543),h0tab(:,543),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(14),m3h4x16(:,121),heltab2x64(:,:,535))
  call Hloop_Q_A(ntryL,G0H16(14),48,0,G1H16(22),n2h16(271))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(544),h0tab(:,544),[48,3,12],[nML,nML,nML],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,122),heltab2x64(:,:,536))
  call Hloop_Q_A(ntryL,G0H16(17),48,nML,G1H16(23),n2h16(272))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(545),h0tab(:,545),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,123),heltab2x64(:,:,537))
  call Hloop_A_Q(ntryL,G0H16(20),48,0,G1H16(24),n2h16(273))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(546),h0tab(:,546),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(19),m3h4x16(:,124),heltab2x64(:,:,538))
  call Hloop_A_Q(ntryL,G0H16(19),48,nMT,G1H16(25),n2h16(274))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(547),h0tab(:,547),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(13),m3h4x16(:,125),heltab2x64(:,:,539))
  call Hloop_Q_A(ntryL,G0H16(13),48,0,G1H16(30),n2h16(275))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(548),h0tab(:,548),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(16),m3h4x16(:,126),heltab2x64(:,:,540))
  call Hloop_Q_A(ntryL,G0H16(16),48,nMT,G1H16(31),n2h16(276))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(549),h0tab(:,549),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(18),m3h4x16(:,127),heltab2x64(:,:,541))
  call Hloop_A_Q(ntryL,G0H16(18),48,0,G1H16(32),n2h16(277))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(550),h0tab(:,550),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(2),m3h4x16(:,128),heltab2x64(:,:,542))
  call Hloop_A_Q(ntryL,G0H16(2),48,nMB,G1H16(33),n2h16(278))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(551),h0tab(:,551),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(5),m3h4x16(:,129),heltab2x64(:,:,543))
  call Hloop_Q_A(ntryL,G0H16(5),48,0,G1H16(67),n2h16(279))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(552),h0tab(:,552),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,130),heltab2x64(:,:,544))
  call Hloop_Q_A(ntryL,G0H16(4),48,nMB,G1H16(68),n2h16(280))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(553),h0tab(:,553),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(7),ngZl,m3h4x16(:,131),heltab2x64(:,:,545))
  call Hloop_A_Q(ntryL,G0H16(7),48,0,G1H16(69),n2h16(281))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(554),h0tab(:,554),[48,3,12],[nML,nML,nML],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(10),ngZl,m3h4x16(:,132),heltab2x64(:,:,546))
  call Hloop_A_Q(ntryL,G0H16(10),48,nML,G1H16(70),n2h16(282))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(555),h0tab(:,555),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(9),ngZl,m3h4x16(:,133),heltab2x64(:,:,547))
  call Hloop_Q_A(ntryL,G0H16(9),48,0,G1H16(71),n2h16(283))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(556),h0tab(:,556),[48,3,12],[nML,nML,nML],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(21),ngZl,m3h4x16(:,134),heltab2x64(:,:,548))
  call Hloop_Q_A(ntryL,G0H16(21),48,nML,G1H16(72),n2h16(284))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(557),h0tab(:,557),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZu,m3h4x16(:,135),heltab2x64(:,:,549))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(73),n2h16(285))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(558),h0tab(:,558),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(3),ngZu,m3h4x16(:,136),heltab2x64(:,:,550))
  call Hloop_A_Q(ntryL,G0H16(3),48,nMT,G1H16(74),n2h16(286))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(559),h0tab(:,559),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(6),ngZu,m3h4x16(:,137),heltab2x64(:,:,551))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(75),n2h16(287))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(560),h0tab(:,560),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(8),ngZu,m3h4x16(:,138),heltab2x64(:,:,552))
  call Hloop_Q_A(ntryL,G0H16(8),48,nMT,G1H16(76),n2h16(288))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(561),h0tab(:,561),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(11),ngZd,m3h4x16(:,139),heltab2x64(:,:,553))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(5),n2h16(289))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(562),h0tab(:,562),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(12),ngZd,m3h4x16(:,140),heltab2x64(:,:,554))
  call Hloop_A_Q(ntryL,G0H16(12),48,nMB,G1H16(6),n2h16(290))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(563),h0tab(:,563),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(15),ngZd,m3h4x16(:,141),heltab2x64(:,:,555))
  call Hloop_Q_A(ntryL,G0H16(15),48,0,G1H16(13),n2h16(291))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(564),h0tab(:,564),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(14),ngZd,m3h4x16(:,142),heltab2x64(:,:,556))
  call Hloop_Q_A(ntryL,G0H16(14),48,nMB,G1H16(14),n2h16(292))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(565),h0tab(:,565),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,143),heltab2x64(:,:,557))
  call Hloop_A_Q(ntryL,G0H16(17),48,0,G1H16(19),n2h16(293))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(566),h0tab(:,566),[48,3,12],[nML,nML,nML],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,144),heltab2x64(:,:,558))
  call Hloop_A_Q(ntryL,G0H16(20),48,nML,G1H16(26),n2h16(294))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(567),h0tab(:,567),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(19),m3h4x16(:,145),heltab2x64(:,:,559))
  call Hloop_Q_A(ntryL,G0H16(19),48,0,G1H16(28),n2h16(295))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(568),h0tab(:,568),[48,3,12],[nML,nML,nML],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(13),m3h4x16(:,146),heltab2x64(:,:,560))
  call Hloop_Q_A(ntryL,G0H16(13),48,nML,G1H16(29),n2h16(296))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(569),h0tab(:,569),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(16),m3h4x16(:,147),heltab2x64(:,:,561))
  call Hloop_A_Q(ntryL,G0H16(16),48,0,G1H16(36),n2h16(297))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(570),h0tab(:,570),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(18),m3h4x16(:,148),heltab2x64(:,:,562))
  call Hloop_A_Q(ntryL,G0H16(18),48,nMT,G1H16(37),n2h16(298))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(571),h0tab(:,571),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(2),m3h4x16(:,149),heltab2x64(:,:,563))
  call Hloop_Q_A(ntryL,G0H16(2),48,0,G1H16(41),n2h16(299))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(572),h0tab(:,572),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(5),m3h4x16(:,150),heltab2x64(:,:,564))
  call Hloop_Q_A(ntryL,G0H16(5),48,nMT,G1H16(43),n2h16(300))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(573),h0tab(:,573),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,151),heltab2x64(:,:,565))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(45),n2h16(301))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(574),h0tab(:,574),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,152),heltab2x64(:,:,566))
  call Hloop_A_Q(ntryL,G0H16(7),48,nMB,G1H16(49),n2h16(302))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(575),h0tab(:,575),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,153),heltab2x64(:,:,567))
  call Hloop_Q_A(ntryL,G0H16(10),48,0,G1H16(50),n2h16(303))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(576),h0tab(:,576),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(9),m3h4x16(:,154),heltab2x64(:,:,568))
  call Hloop_Q_A(ntryL,G0H16(9),48,nMB,G1H16(53),n2h16(304))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(577),h0tab(:,577),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(21),ngZl,m3h4x16(:,155),heltab2x64(:,:,569))
  call Hloop_A_Q(ntryL,G0H16(21),48,0,G1H16(54),n2h16(305))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(578),h0tab(:,578),[48,3,12],[nML,nML,nML],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),ngZl,m3h4x16(:,156),heltab2x64(:,:,570))
  call Hloop_A_Q(ntryL,G0H16(1),48,nML,G1H16(58),n2h16(306))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(579),h0tab(:,579),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(3),ngZl,m3h4x16(:,157),heltab2x64(:,:,571))
  call Hloop_Q_A(ntryL,G0H16(3),48,0,G1H16(60),n2h16(307))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(580),h0tab(:,580),[48,3,12],[nML,nML,nML],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(6),ngZl,m3h4x16(:,158),heltab2x64(:,:,572))
  call Hloop_Q_A(ntryL,G0H16(6),48,nML,G1H16(62),n2h16(308))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(581),h0tab(:,581),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(8),ngZu,m3h4x16(:,159),heltab2x64(:,:,573))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(63),n2h16(309))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(582),h0tab(:,582),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(11),ngZu,m3h4x16(:,160),heltab2x64(:,:,574))
  call Hloop_A_Q(ntryL,G0H16(11),48,nMT,G1H16(66),n2h16(310))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(583),h0tab(:,583),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(12),ngZu,m3h4x16(:,161),heltab2x64(:,:,575))
  call Hloop_Q_A(ntryL,G0H16(12),48,0,G1H16(1),n2h16(311))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(584),h0tab(:,584),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(15),ngZu,m3h4x16(:,162),heltab2x64(:,:,576))
  call Hloop_Q_A(ntryL,G0H16(15),48,nMT,G1H16(9),n2h16(312))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(585),h0tab(:,585),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(14),ngZd,m3h4x16(:,163),heltab2x64(:,:,577))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(11),n2h16(313))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(586),h0tab(:,586),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(17),ngZd,m3h4x16(:,164),heltab2x64(:,:,578))
  call Hloop_A_Q(ntryL,G0H16(17),48,nMB,G1H16(18),n2h16(314))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(587),h0tab(:,587),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(20),ngZd,m3h4x16(:,165),heltab2x64(:,:,579))
  call Hloop_Q_A(ntryL,G0H16(20),48,0,G1H16(7),n2h16(315))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(588),h0tab(:,588),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(19),ngZd,m3h4x16(:,166),heltab2x64(:,:,580))
  call Hloop_Q_A(ntryL,G0H16(19),48,nMB,G1H16(8),n2h16(316))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(589),h0tab(:,589),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(13),m3h4x16(:,167),heltab2x64(:,:,581))
  call Hloop_A_Q(ntryL,G0H16(13),48,0,G1H16(15),n2h16(317))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(590),h0tab(:,590),[48,3,12],[nML,nML,nML],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(16),m3h4x16(:,168),heltab2x64(:,:,582))
  call Hloop_A_Q(ntryL,G0H16(16),48,nML,G1H16(16),n2h16(318))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(591),h0tab(:,591),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(18),m3h4x16(:,169),heltab2x64(:,:,583))
  call Hloop_Q_A(ntryL,G0H16(18),48,0,G1H16(17),n2h16(319))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(592),h0tab(:,592),[48,3,12],[nML,nML,nML],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(2),m3h4x16(:,170),heltab2x64(:,:,584))
  call Hloop_Q_A(ntryL,G0H16(2),48,nML,G1H16(21),n2h16(320))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(593),h0tab(:,593),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(5),m3h4x16(:,171),heltab2x64(:,:,585))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(27),n2h16(321))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(594),h0tab(:,594),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,172),heltab2x64(:,:,586))
  call Hloop_A_Q(ntryL,G0H16(4),48,nMT,G1H16(34),n2h16(322))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(595),h0tab(:,595),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,173),heltab2x64(:,:,587))
  call Hloop_Q_A(ntryL,G0H16(7),48,0,G1H16(35),n2h16(323))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(596),h0tab(:,596),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,174),heltab2x64(:,:,588))
  call Hloop_Q_A(ntryL,G0H16(10),48,nMT,G1H16(38),n2h16(324))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(597),h0tab(:,597),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(9),m3h4x16(:,175),heltab2x64(:,:,589))
  call Hloop_A_Q(ntryL,G0H16(9),48,0,G1H16(39),n2h16(325))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(598),h0tab(:,598),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(21),m3h4x16(:,176),heltab2x64(:,:,590))
  call Hloop_A_Q(ntryL,G0H16(21),48,nMB,G1H16(40),n2h16(326))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(599),h0tab(:,599),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,177),heltab2x64(:,:,591))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(42),n2h16(327))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(600),h0tab(:,600),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(3),m3h4x16(:,178),heltab2x64(:,:,592))
  call Hloop_Q_A(ntryL,G0H16(3),48,nMB,G1H16(44),n2h16(328))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(601),h0tab(:,601),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(6),ngZl,m3h4x16(:,179),heltab2x64(:,:,593))
  call Hloop_A_Q(ntryL,G0H16(6),48,0,G1H16(46),n2h16(329))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(602),h0tab(:,602),[48,3,12],[nML,nML,nML],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(8),ngZl,m3h4x16(:,180),heltab2x64(:,:,594))
  call Hloop_A_Q(ntryL,G0H16(8),48,nML,G1H16(47),n2h16(330))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(603),h0tab(:,603),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(11),ngZl,m3h4x16(:,181),heltab2x64(:,:,595))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(48),n2h16(331))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(604),h0tab(:,604),[48,3,12],[nML,nML,nML],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(12),ngZl,m3h4x16(:,182),heltab2x64(:,:,596))
  call Hloop_Q_A(ntryL,G0H16(12),48,nML,G1H16(51),n2h16(332))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(605),h0tab(:,605),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(15),ngZu,m3h4x16(:,183),heltab2x64(:,:,597))
  call Hloop_A_Q(ntryL,G0H16(15),48,0,G1H16(52),n2h16(333))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(606),h0tab(:,606),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(14),ngZu,m3h4x16(:,184),heltab2x64(:,:,598))
  call Hloop_A_Q(ntryL,G0H16(14),48,nMT,G1H16(55),n2h16(334))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(607),h0tab(:,607),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(17),ngZu,m3h4x16(:,185),heltab2x64(:,:,599))
  call Hloop_Q_A(ntryL,G0H16(17),48,0,G1H16(56),n2h16(335))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(608),h0tab(:,608),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(20),ngZu,m3h4x16(:,186),heltab2x64(:,:,600))
  call Hloop_Q_A(ntryL,G0H16(20),48,nMT,G1H16(57),n2h16(336))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(609),h0tab(:,609),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(19),ngZd,m3h4x16(:,187),heltab2x64(:,:,601))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(59),n2h16(337))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(610),h0tab(:,610),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(13),ngZd,m3h4x16(:,188),heltab2x64(:,:,602))
  call Hloop_A_Q(ntryL,G0H16(13),48,nMB,G1H16(61),n2h16(338))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(611),h0tab(:,611),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(16),ngZd,m3h4x16(:,189),heltab2x64(:,:,603))
  call Hloop_Q_A(ntryL,G0H16(16),48,0,G1H16(64),n2h16(339))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(612),h0tab(:,612),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(18),ngZd,m3h4x16(:,190),heltab2x64(:,:,604))
  call Hloop_Q_A(ntryL,G0H16(18),48,nMB,G1H16(65),n2h16(340))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(613),h0tab(:,613),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(2),m3h4x16(:,191),heltab2x64(:,:,605))
  call Hloop_A_Q(ntryL,G0H16(2),48,0,G1H16(2),n2h16(341))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(614),h0tab(:,614),[48,3,12],[nML,nML,nML],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(5),m3h4x16(:,192),heltab2x64(:,:,606))
  call Hloop_A_Q(ntryL,G0H16(5),48,nML,G1H16(3),n2h16(342))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(615),h0tab(:,615),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,193),heltab2x64(:,:,607))
  call Hloop_Q_A(ntryL,G0H16(4),48,0,G1H16(4),n2h16(343))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(616),h0tab(:,616),[48,3,12],[nML,nML,nML],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,194),heltab2x64(:,:,608))
  call Hloop_Q_A(ntryL,G0H16(7),48,nML,G1H16(10),n2h16(344))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(617),h0tab(:,617),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,195),heltab2x64(:,:,609))
  call Hloop_A_Q(ntryL,G0H16(10),48,0,G1H16(77),n2h16(345))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(618),h0tab(:,618),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(9),m3h4x16(:,196),heltab2x64(:,:,610))
  call Hloop_A_Q(ntryL,G0H16(9),48,nMT,G1H16(78),n2h16(346))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(619),h0tab(:,619),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(21),m3h4x16(:,197),heltab2x64(:,:,611))
  call Hloop_Q_A(ntryL,G0H16(21),48,0,G1H16(79),n2h16(347))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(620),h0tab(:,620),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,198),heltab2x64(:,:,612))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(80),n2h16(348))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(621),h0tab(:,621),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(3),m3h4x16(:,199),heltab2x64(:,:,613))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(81),n2h16(349))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(622),h0tab(:,622),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,200),heltab2x64(:,:,614))
  call Hloop_A_Q(ntryL,G0H16(6),48,nMB,G1H16(82),n2h16(350))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(623),h0tab(:,623),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(8),m3h4x16(:,201),heltab2x64(:,:,615))
  call Hloop_Q_A(ntryL,G0H16(8),48,0,G1H16(83),n2h16(351))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(624),h0tab(:,624),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,202),heltab2x64(:,:,616))
  call Hloop_Q_A(ntryL,G0H16(11),48,nMB,G1H16(84),n2h16(352))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(625),h0tab(:,625),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(12),ngZn,m3h4x16(:,203),heltab2x64(:,:,617))
  call Hloop_A_Q(ntryL,G0H16(12),48,0,G1H16(85),n2h16(353))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(626),h0tab(:,626),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(15),ngZn,m3h4x16(:,204),heltab2x64(:,:,618))
  call Hloop_Q_A(ntryL,G0H16(15),48,0,G1H16(86),n2h16(354))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(627),h0tab(:,627),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(14),ngZl,m3h4x16(:,205),heltab2x64(:,:,619))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(87),n2h16(355))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(628),h0tab(:,628),[48,3,12],[nML,nML,nML],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(17),ngZl,m3h4x16(:,206),heltab2x64(:,:,620))
  call Hloop_A_Q(ntryL,G0H16(17),48,nML,G1H16(88),n2h16(356))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(629),h0tab(:,629),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(20),ngZl,m3h4x16(:,207),heltab2x64(:,:,621))
  call Hloop_Q_A(ntryL,G0H16(20),48,0,G1H16(89),n2h16(357))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(630),h0tab(:,630),[48,3,12],[nML,nML,nML],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(19),ngZl,m3h4x16(:,208),heltab2x64(:,:,622))
  call Hloop_Q_A(ntryL,G0H16(19),48,nML,G1H16(90),n2h16(358))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(631),h0tab(:,631),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(13),ngZu,m3h4x16(:,209),heltab2x64(:,:,623))
  call Hloop_A_Q(ntryL,G0H16(13),48,0,G1H16(91),n2h16(359))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(632),h0tab(:,632),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(16),ngZu,m3h4x16(:,210),heltab2x64(:,:,624))
  call Hloop_A_Q(ntryL,G0H16(16),48,nMT,G1H16(92),n2h16(360))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(633),h0tab(:,633),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(18),ngZu,m3h4x16(:,211),heltab2x64(:,:,625))
  call Hloop_Q_A(ntryL,G0H16(18),48,0,G1H16(93),n2h16(361))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(634),h0tab(:,634),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(2),ngZu,m3h4x16(:,212),heltab2x64(:,:,626))
  call Hloop_Q_A(ntryL,G0H16(2),48,nMT,G1H16(94),n2h16(362))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(635),h0tab(:,635),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),ngZd,m3h4x16(:,213),heltab2x64(:,:,627))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(95),n2h16(363))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(636),h0tab(:,636),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(4),ngZd,m3h4x16(:,214),heltab2x64(:,:,628))
  call Hloop_A_Q(ntryL,G0H16(4),48,nMB,G1H16(96),n2h16(364))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(637),h0tab(:,637),[48,3,12],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(7),ngZd,m3h4x16(:,215),heltab2x64(:,:,629))
  call Hloop_Q_A(ntryL,G0H16(7),48,0,G1H16(97),n2h16(365))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(638),h0tab(:,638),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,6),G0H16(10),ngZd,m3h4x16(:,216),heltab2x64(:,:,630))
  call Hloop_Q_A(ntryL,G0H16(10),48,nMB,G1H16(98),n2h16(366))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(639),h0tab(:,639),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(99),m3h4x16(:,217),heltab2x64(:,:,631))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(640),h0tab(:,640),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(100),m3h4x16(:,218),heltab2x64(:,:,632))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(641),h0tab(:,641),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(101),m3h4x16(:,219),heltab2x64(:,:,633))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(642),h0tab(:,642),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(102),m3h4x16(:,220),heltab2x64(:,:,634))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(643),h0tab(:,643),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(103),m3h4x16(:,221),heltab2x64(:,:,635))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(644),h0tab(:,644),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(104),m3h4x16(:,222),heltab2x64(:,:,636))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(645),h0tab(:,645),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(105),m3h4x16(:,223),heltab2x64(:,:,637))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(646),h0tab(:,646),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(106),m3h4x16(:,224),heltab2x64(:,:,638))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(647),h0tab(:,647),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(107),m3h4x16(:,225),heltab2x64(:,:,639))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(648),h0tab(:,648),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(108),m3h4x16(:,226),heltab2x64(:,:,640))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(649),h0tab(:,649),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(109),m3h4x16(:,227),heltab2x64(:,:,641))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(650),h0tab(:,650),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(110),m3h4x16(:,228),heltab2x64(:,:,642))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(651),h0tab(:,651),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(111),m3h4x16(:,229),heltab2x64(:,:,643))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(652),h0tab(:,652),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(112),m3h4x16(:,230),heltab2x64(:,:,644))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(653),h0tab(:,653),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(113),m3h4x16(:,231),heltab2x64(:,:,645))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(654),h0tab(:,654),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(114),m3h4x16(:,232),heltab2x64(:,:,646))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(655),h0tab(:,655),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,5),G1H16(115),m3h4x16(:,233),heltab2x64(:,:,647))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(656),h0tab(:,656),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(116),m3h4x16(:,234),heltab2x64(:,:,648))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(657),h0tab(:,657),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,5),G1H16(117),m3h4x16(:,235),heltab2x64(:,:,649))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(658),h0tab(:,658),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(118),m3h4x16(:,236),heltab2x64(:,:,650))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(659),h0tab(:,659),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(119),m3h4x16(:,237),heltab2x64(:,:,651))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(660),h0tab(:,660),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(120),m3h4x16(:,238),heltab2x64(:,:,652))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(661),h0tab(:,661),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(121),m3h4x16(:,239),heltab2x64(:,:,653))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(662),h0tab(:,662),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(122),m3h4x16(:,240),heltab2x64(:,:,654))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(663),h0tab(:,663),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,5),G1H16(123),m3h4x16(:,241),heltab2x64(:,:,655))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(664),h0tab(:,664),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(124),m3h4x16(:,242),heltab2x64(:,:,656))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(665),h0tab(:,665),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,5),G1H16(125),m3h4x16(:,243),heltab2x64(:,:,657))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(666),h0tab(:,666),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(126),m3h4x16(:,244),heltab2x64(:,:,658))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(667),h0tab(:,667),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(127),m3h4x16(:,245),heltab2x64(:,:,659))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(668),h0tab(:,668),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(128),m3h4x16(:,246),heltab2x64(:,:,660))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(669),h0tab(:,669),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(129),m3h4x16(:,247),heltab2x64(:,:,661))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(670),h0tab(:,670),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(130),m3h4x16(:,248),heltab2x64(:,:,662))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(671),h0tab(:,671),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,5),G1H16(131),m3h4x16(:,249),heltab2x64(:,:,663))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(672),h0tab(:,672),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(132),m3h4x16(:,250),heltab2x64(:,:,664))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(673),h0tab(:,673),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,5),G1H16(133),m3h4x16(:,251),heltab2x64(:,:,665))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(674),h0tab(:,674),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(134),m3h4x16(:,252),heltab2x64(:,:,666))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(675),h0tab(:,675),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(135),m3h4x16(:,253),heltab2x64(:,:,667))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(676),h0tab(:,676),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(136),m3h4x16(:,254),heltab2x64(:,:,668))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(677),h0tab(:,677),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(137),m3h4x16(:,255),heltab2x64(:,:,669))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(678),h0tab(:,678),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(138),m3h4x16(:,256),heltab2x64(:,:,670))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(679),h0tab(:,679),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,5),G1H16(139),m3h4x16(:,257),heltab2x64(:,:,671))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(680),h0tab(:,680),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(140),m3h4x16(:,258),heltab2x64(:,:,672))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(681),h0tab(:,681),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,5),G1H16(141),m3h4x16(:,259),heltab2x64(:,:,673))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(682),h0tab(:,682),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(142),m3h4x16(:,260),heltab2x64(:,:,674))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(683),h0tab(:,683),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(143),m3h4x16(:,261),heltab2x64(:,:,675))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(684),h0tab(:,684),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(144),m3h4x16(:,262),heltab2x64(:,:,676))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(685),h0tab(:,685),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(145),m3h4x16(:,263),heltab2x64(:,:,677))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(686),h0tab(:,686),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(146),m3h4x16(:,264),heltab2x64(:,:,678))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(687),h0tab(:,687),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(147),m3h4x16(:,265),heltab2x64(:,:,679))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(688),h0tab(:,688),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(148),m3h4x16(:,266),heltab2x64(:,:,680))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(689),h0tab(:,689),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(149),m3h4x16(:,267),heltab2x64(:,:,681))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(690),h0tab(:,690),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(150),m3h4x16(:,268),heltab2x64(:,:,682))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(691),h0tab(:,691),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(151),m3h4x16(:,269),heltab2x64(:,:,683))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(692),h0tab(:,692),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(152),m3h4x16(:,270),heltab2x64(:,:,684))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(693),h0tab(:,693),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(153),m3h4x16(:,271),heltab2x64(:,:,685))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(694),h0tab(:,694),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(154),m3h4x16(:,272),heltab2x64(:,:,686))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(695),h0tab(:,695),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(155),m3h4x16(:,273),heltab2x64(:,:,687))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(696),h0tab(:,696),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(156),m3h4x16(:,274),heltab2x64(:,:,688))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(697),h0tab(:,697),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(157),m3h4x16(:,275),heltab2x64(:,:,689))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(698),h0tab(:,698),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(158),m3h4x16(:,276),heltab2x64(:,:,690))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(699),h0tab(:,699),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(159),m3h4x16(:,277),heltab2x64(:,:,691))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(700),h0tab(:,700),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(160),m3h4x16(:,278),heltab2x64(:,:,692))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(701),h0tab(:,701),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(161),m3h4x16(:,279),heltab2x64(:,:,693))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(702),h0tab(:,702),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(162),m3h4x16(:,280),heltab2x64(:,:,694))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(703),h0tab(:,703),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(9),m3h4x16(:,281),heltab2x64(:,:,695))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(704),h0tab(:,704),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(21),m3h4x16(:,282),heltab2x64(:,:,696))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(705),h0tab(:,705),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,283),heltab2x64(:,:,697))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(706),h0tab(:,706),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(3),m3h4x16(:,284),heltab2x64(:,:,698))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(707),h0tab(:,707),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(6),m3h4x16(:,285),heltab2x64(:,:,699))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(708),h0tab(:,708),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(8),m3h4x16(:,286),heltab2x64(:,:,700))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(709),h0tab(:,709),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(11),m3h4x16(:,287),heltab2x64(:,:,701))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(710),h0tab(:,710),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(12),m3h4x16(:,288),heltab2x64(:,:,702))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(711),h0tab(:,711),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(15),m3h4x16(:,289),heltab2x64(:,:,703))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(712),h0tab(:,712),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(14),m3h4x16(:,290),heltab2x64(:,:,704))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(713),h0tab(:,713),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(17),m3h4x16(:,291),heltab2x64(:,:,705))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(714),h0tab(:,714),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(20),m3h4x16(:,292),heltab2x64(:,:,706))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(715),h0tab(:,715),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(19),m3h4x16(:,293),heltab2x64(:,:,707))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(716),h0tab(:,716),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(13),m3h4x16(:,294),heltab2x64(:,:,708))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(717),h0tab(:,717),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(16),m3h4x16(:,295),heltab2x64(:,:,709))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(718),h0tab(:,718),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(18),m3h4x16(:,296),heltab2x64(:,:,710))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(719),h0tab(:,719),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(2),m3h4x16(:,297),heltab2x64(:,:,711))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(720),h0tab(:,720),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(5),m3h4x16(:,298),heltab2x64(:,:,712))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(721),h0tab(:,721),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(4),m3h4x16(:,299),heltab2x64(:,:,713))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(722),h0tab(:,722),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(7),m3h4x16(:,300),heltab2x64(:,:,714))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(723),h0tab(:,723),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,301),heltab2x64(:,:,715))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(724),h0tab(:,724),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(22),m3h4x16(:,302),heltab2x64(:,:,716))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(725),h0tab(:,725),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(23),m3h4x16(:,303),heltab2x64(:,:,717))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(726),h0tab(:,726),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(24),m3h4x16(:,304),heltab2x64(:,:,718))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(727),h0tab(:,727),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(25),m3h4x16(:,305),heltab2x64(:,:,719))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(728),h0tab(:,728),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(26),m3h4x16(:,306),heltab2x64(:,:,720))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(729),h0tab(:,729),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(27),m3h4x16(:,307),heltab2x64(:,:,721))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(730),h0tab(:,730),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(28),m3h4x16(:,308),heltab2x64(:,:,722))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(731),h0tab(:,731),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(29),m3h4x16(:,309),heltab2x64(:,:,723))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(732),h0tab(:,732),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(30),m3h4x16(:,310),heltab2x64(:,:,724))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(733),h0tab(:,733),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(31),m3h4x16(:,311),heltab2x64(:,:,725))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(734),h0tab(:,734),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(32),m3h4x16(:,312),heltab2x64(:,:,726))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(735),h0tab(:,735),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(163),m3h4x16(:,313),heltab2x64(:,:,727))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(736),h0tab(:,736),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(164),m3h4x16(:,314),heltab2x64(:,:,728))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(737),h0tab(:,737),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(165),m3h4x16(:,315),heltab2x64(:,:,729))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(738),h0tab(:,738),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(166),m3h4x16(:,316),heltab2x64(:,:,730))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(739),h0tab(:,739),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(167),m3h4x16(:,317),heltab2x64(:,:,731))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(740),h0tab(:,740),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(168),m3h4x16(:,318),heltab2x64(:,:,732))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(741),h0tab(:,741),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(169),m3h4x16(:,319),heltab2x64(:,:,733))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(742),h0tab(:,742),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(170),m3h4x16(:,320),heltab2x64(:,:,734))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(743),h0tab(:,743),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(171),m3h4x16(:,321),heltab2x64(:,:,735))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(744),h0tab(:,744),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(172),m3h4x16(:,322),heltab2x64(:,:,736))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(745),h0tab(:,745),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(173),m3h4x16(:,323),heltab2x64(:,:,737))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(746),h0tab(:,746),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(174),m3h4x16(:,324),heltab2x64(:,:,738))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(747),h0tab(:,747),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(175),m3h4x16(:,325),heltab2x64(:,:,739))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(748),h0tab(:,748),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(176),m3h4x16(:,326),heltab2x64(:,:,740))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(749),h0tab(:,749),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(177),m3h4x16(:,327),heltab2x64(:,:,741))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(750),h0tab(:,750),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_TV_S(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(178),m3h4x16(:,328),heltab2x64(:,:,742))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(751),h0tab(:,751),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(179),m3h4x16(:,329),heltab2x64(:,:,743))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(752),h0tab(:,752),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(180),m3h4x16(:,330),heltab2x64(:,:,744))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(753),h0tab(:,753),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(181),m3h4x16(:,331),heltab2x64(:,:,745))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(754),h0tab(:,754),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(182),m3h4x16(:,332),heltab2x64(:,:,746))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(755),h0tab(:,755),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(183),m3h4x16(:,333),heltab2x64(:,:,747))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(756),h0tab(:,756),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(184),m3h4x16(:,334),heltab2x64(:,:,748))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(757),h0tab(:,757),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(185),m3h4x16(:,335),heltab2x64(:,:,749))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(758),h0tab(:,758),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(186),m3h4x16(:,336),heltab2x64(:,:,750))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(759),h0tab(:,759),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(187),m3h4x16(:,337),heltab2x64(:,:,751))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(760),h0tab(:,760),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(188),m3h4x16(:,338),heltab2x64(:,:,752))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(761),h0tab(:,761),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(189),m3h4x16(:,339),heltab2x64(:,:,753))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(762),h0tab(:,762),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(190),m3h4x16(:,340),heltab2x64(:,:,754))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(763),h0tab(:,763),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(191),m3h4x16(:,341),heltab2x64(:,:,755))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(764),h0tab(:,764),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(192),m3h4x16(:,342),heltab2x64(:,:,756))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(765),h0tab(:,765),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(193),m3h4x16(:,343),heltab2x64(:,:,757))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(766),h0tab(:,766),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(194),m3h4x16(:,344),heltab2x64(:,:,758))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(767),h0tab(:,767),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(33),m3h4x16(:,345),heltab2x64(:,:,759))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(768),h0tab(:,768),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(34),m3h4x16(:,346),heltab2x64(:,:,760))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(769),h0tab(:,769),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(35),m3h4x16(:,347),heltab2x64(:,:,761))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(770),h0tab(:,770),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(36),m3h4x16(:,348),heltab2x64(:,:,762))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(771),h0tab(:,771),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(37),m3h4x16(:,349),heltab2x64(:,:,763))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(772),h0tab(:,772),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(38),m3h4x16(:,350),heltab2x64(:,:,764))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(773),h0tab(:,773),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(39),m3h4x16(:,351),heltab2x64(:,:,765))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(774),h0tab(:,774),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(40),m3h4x16(:,352),heltab2x64(:,:,766))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(775),h0tab(:,775),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(41),m3h4x16(:,353),heltab2x64(:,:,767))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(776),h0tab(:,776),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(42),m3h4x16(:,354),heltab2x64(:,:,768))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(777),h0tab(:,777),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(43),m3h4x16(:,355),heltab2x64(:,:,769))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(778),h0tab(:,778),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(44),m3h4x16(:,356),heltab2x64(:,:,770))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(779),h0tab(:,779),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(45),m3h4x16(:,357),heltab2x64(:,:,771))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(780),h0tab(:,780),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,5),G0H16(46),m3h4x16(:,358),heltab2x64(:,:,772))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(781),h0tab(:,781),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(47),m3h4x16(:,359),heltab2x64(:,:,773))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(782),h0tab(:,782),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(48),m3h4x16(:,360),heltab2x64(:,:,774))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(783),h0tab(:,783),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(49),m3h4x16(:,361),heltab2x64(:,:,775))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(784),h0tab(:,784),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(50),m3h4x16(:,362),heltab2x64(:,:,776))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(785),h0tab(:,785),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(51),m3h4x16(:,363),heltab2x64(:,:,777))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(786),h0tab(:,786),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(52),m3h4x16(:,364),heltab2x64(:,:,778))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(787),h0tab(:,787),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(53),m3h4x16(:,365),heltab2x64(:,:,779))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(788),h0tab(:,788),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,1),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(54),m3h4x16(:,366),heltab2x64(:,:,780))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(789),h0tab(:,789),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(55),m3h4x16(:,367),heltab2x64(:,:,781))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(790),h0tab(:,790),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,1),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(56),m3h4x16(:,368),heltab2x64(:,:,782))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(791),h0tab(:,791),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(57),m3h4x16(:,369),heltab2x64(:,:,783))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(792),h0tab(:,792),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(58),m3h4x16(:,370),heltab2x64(:,:,784))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(793),h0tab(:,793),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(59),m3h4x16(:,371),heltab2x64(:,:,785))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(794),h0tab(:,794),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(60),m3h4x16(:,372),heltab2x64(:,:,786))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(795),h0tab(:,795),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(61),m3h4x16(:,373),heltab2x64(:,:,787))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(796),h0tab(:,796),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,5),G0H16(62),m3h4x16(:,374),heltab2x64(:,:,788))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(797),h0tab(:,797),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(63),m3h4x16(:,375),heltab2x64(:,:,789))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(798),h0tab(:,798),[48,3,12],[nMW,nMW,nMW],3,3,wf4(:,6),wf4(:,4),wf4(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(64),m3h4x16(:,376),heltab2x64(:,:,790))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(799),h0tab(:,799),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,307),heltab2x64(:,:,791))
  call Hloop_A_Q(ntryL,G0H32(29),32,0,G1H32(1),n2h32(47))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(800),h0tab(:,800),[32,12,19],[0,0,nMZ],3,2,wf4(:,2),wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(30),ngZu,m3h2x32(:,308),heltab2x64(:,:,792))
  call Hloop_A_Q(ntryL,G0H32(30),32,0,G1H32(2),n2h32(48))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(801),h0tab(:,801),[32,12,19],[0,0,nMW],3,2,wf4(:,2),wf8(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,309),heltab2x64(:,:,793))
  call Hloop_A_Q(ntryL,G0H32(31),32,0,G1H32(3),n2h32(49))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(802),h0tab(:,802),[32,12,19],[0,0,0],3,2,wf4(:,3),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,310),heltab2x64(:,:,794))
  call Hloop_A_Q(ntryL,G0H32(32),32,0,G1H32(4),n2h32(50))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(803),h0tab(:,803),[32,12,19],[0,0,nMZ],3,2,wf4(:,3),wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(33),ngZu,m3h2x32(:,311),heltab2x64(:,:,795))
  call Hloop_A_Q(ntryL,G0H32(33),32,0,G1H32(5),n2h32(51))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(804),h0tab(:,804),[32,12,19],[0,0,nMW],3,2,wf4(:,3),wf8(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,312),heltab2x64(:,:,796))
  call Hloop_A_Q(ntryL,G0H32(46),32,0,G1H32(6),n2h32(52))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(805),h0tab(:,805),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,313),heltab2x64(:,:,797))
  call Hloop_A_Q(ntryL,G0H32(47),32,0,G1H32(7),n2h32(53))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(806),h0tab(:,806),[32,12,19],[0,0,nMZ],3,2,wf4(:,2),wf8(:,6))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(48),ngZu,m3h2x32(:,314),heltab2x64(:,:,798))
  call Hloop_A_Q(ntryL,G0H32(48),32,0,G1H32(8),n2h32(54))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(807),h0tab(:,807),[32,12,19],[0,0,nMW],3,2,wf4(:,2),wf8(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,315),heltab2x64(:,:,799))
  call Hloop_A_Q(ntryL,G0H32(49),32,0,G1H32(9),n2h32(55))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(808),h0tab(:,808),[32,12,19],[0,0,0],3,2,wf4(:,3),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,316),heltab2x64(:,:,800))
  call Hloop_A_Q(ntryL,G0H32(50),32,0,G1H32(10),n2h32(56))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(809),h0tab(:,809),[32,12,19],[0,0,nMZ],3,2,wf4(:,3),wf8(:,6))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(51),ngZu,m3h2x32(:,317),heltab2x64(:,:,801))
  call Hloop_A_Q(ntryL,G0H32(51),32,0,G1H32(11),n2h32(57))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(810),h0tab(:,810),[32,12,19],[0,0,nMW],3,2,wf4(:,3),wf8(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,318),heltab2x64(:,:,802))
  call Hloop_A_Q(ntryL,G0H32(52),32,0,G1H32(12),n2h32(58))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(811),h0tab(:,811),[32,12,19],[nMW,nMW,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,319),heltab2x64(:,:,803))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(812),h0tab(:,812),[32,12,19],[nMW,nMW,0],3,2,wf4(:,3),wf8(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(54),m3h2x32(:,320),heltab2x64(:,:,804))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(813),h0tab(:,813),[32,12,19],[nMW,nMW,0],3,2,wf4(:,2),wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,321),heltab2x64(:,:,805))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(814),h0tab(:,814),[32,12,19],[nMW,nMW,0],3,2,wf4(:,3),wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,322),heltab2x64(:,:,806))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(815),h0tab(:,815),[35,12,16],[0,0,0],3,2,wf8(:,42),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,42),G0H8(31),m3h8x8(:,109),heltab2x64(:,:,807))
  call Hloop_A_Q(ntryL,G0H8(31),35,0,G1H8(57),n2h8(111))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(816),h0tab(:,816),[35,12,16],[0,0,nMZ],3,2,wf8(:,42),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,42),G0H8(32),ngZu,m3h8x8(:,110),heltab2x64(:,:,808))
  call Hloop_A_Q(ntryL,G0H8(32),35,0,G1H8(58),n2h8(112))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(817),h0tab(:,817),[35,12,16],[0,0,nMW],3,2,wf8(:,42),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,42),G0H8(37),m3h8x8(:,111),heltab2x64(:,:,809))
  call Hloop_A_Q(ntryL,G0H8(37),35,0,G1H8(60),n2h8(113))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(818),h0tab(:,818),[35,12,16],[0,0,0],3,2,wf8(:,42),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,42),G0H8(38),m3h8x8(:,112),heltab2x64(:,:,810))
  call Hloop_A_Q(ntryL,G0H8(38),35,0,G1H8(61),n2h8(114))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(819),h0tab(:,819),[35,12,16],[0,0,nMZ],3,2,wf8(:,42),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,42),G0H8(39),ngZu,m3h8x8(:,113),heltab2x64(:,:,811))
  call Hloop_A_Q(ntryL,G0H8(39),35,0,G1H8(62),n2h8(115))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(820),h0tab(:,820),[35,12,16],[0,0,nMW],3,2,wf8(:,42),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,42),G0H8(40),m3h8x8(:,114),heltab2x64(:,:,812))
  call Hloop_A_Q(ntryL,G0H8(40),35,0,G1H8(1),n2h8(116))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(821),h0tab(:,821),[35,12,16],[0,0,0],3,2,wf8(:,44),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,44),G0H8(41),m3h8x8(:,115),heltab2x64(:,:,813))
  call Hloop_A_Q(ntryL,G0H8(41),35,0,G1H8(3),n2h8(117))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(822),h0tab(:,822),[35,12,16],[0,0,nMZ],3,2,wf8(:,44),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,44),G0H8(47),ngZu,m3h8x8(:,116),heltab2x64(:,:,814))
  call Hloop_A_Q(ntryL,G0H8(47),35,0,G1H8(9),n2h8(118))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(823),h0tab(:,823),[35,12,16],[0,0,nMW],3,2,wf8(:,44),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,44),G0H8(48),m3h8x8(:,117),heltab2x64(:,:,815))
  call Hloop_A_Q(ntryL,G0H8(48),35,0,G1H8(20),n2h8(119))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(824),h0tab(:,824),[35,12,16],[0,0,0],3,2,wf8(:,44),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,44),G0H8(49),m3h8x8(:,118),heltab2x64(:,:,816))
  call Hloop_A_Q(ntryL,G0H8(49),35,0,G1H8(38),n2h8(120))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(825),h0tab(:,825),[35,12,16],[0,0,nMZ],3,2,wf8(:,44),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,44),G0H8(50),ngZu,m3h8x8(:,119),heltab2x64(:,:,817))
  call Hloop_A_Q(ntryL,G0H8(50),35,0,G1H8(52),n2h8(121))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(826),h0tab(:,826),[35,12,16],[0,0,nMW],3,2,wf8(:,44),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,44),G0H8(55),m3h8x8(:,120),heltab2x64(:,:,818))
  call Hloop_A_Q(ntryL,G0H8(55),35,0,G1H8(53),n2h8(122))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(827),h0tab(:,827),[35,12,16],[nMW,nMW,0],3,2,wf8(:,42),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,42),G0H8(56),m3h8x8(:,121),heltab2x64(:,:,819))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(828),h0tab(:,828),[35,12,16],[nMW,nMW,0],3,2,wf8(:,42),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,42),G0H8(57),m3h8x8(:,122),heltab2x64(:,:,820))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(829),h0tab(:,829),[35,12,16],[nMW,nMW,0],3,2,wf8(:,44),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,44),G0H8(58),m3h8x8(:,123),heltab2x64(:,:,821))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(830),h0tab(:,830),[35,12,16],[nMW,nMW,0],3,2,wf8(:,44),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,44),G0H8(63),m3h8x8(:,124),heltab2x64(:,:,822))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(831),h0tab(:,831),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(61),m3h2x32(:,323),heltab2x64(:,:,823))
  call Hloop_A_Q(ntryL,G0H32(61),32,0,G1H32(13),n2h32(59))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(832),h0tab(:,832),[32,3,28],[0,0,nMZ],3,2,wf4(:,1),wf8(:,9))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(62),ngZu,m3h2x32(:,324),heltab2x64(:,:,824))
  call Hloop_A_Q(ntryL,G0H32(62),32,0,G1H32(14),n2h32(60))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(833),h0tab(:,833),[32,3,28],[0,0,nMW],3,2,wf4(:,1),wf8(:,9))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(63),m3h2x32(:,325),heltab2x64(:,:,825))
  call Hloop_A_Q(ntryL,G0H32(63),32,0,G1H32(15),n2h32(61))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(834),h0tab(:,834),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(64),m3h2x32(:,326),heltab2x64(:,:,826))
  call Hloop_A_Q(ntryL,G0H32(64),32,0,G1H32(16),n2h32(62))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(835),h0tab(:,835),[32,3,28],[0,0,nMZ],3,2,wf4(:,1),wf8(:,11))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(65),ngZu,m3h2x32(:,327),heltab2x64(:,:,827))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(17),n2h32(63))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(836),h0tab(:,836),[32,3,28],[0,0,nMW],3,2,wf4(:,1),wf8(:,11))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(66),m3h2x32(:,328),heltab2x64(:,:,828))
  call Hloop_A_Q(ntryL,G0H32(66),32,0,G1H32(18),n2h32(64))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(837),h0tab(:,837),[32,3,28],[0,0,0],3,2,wf4(:,4),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,329),heltab2x64(:,:,829))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(19),n2h32(65))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(838),h0tab(:,838),[32,3,28],[0,0,nMZ],3,2,wf4(:,4),wf8(:,9))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),ngZu,m3h2x32(:,330),heltab2x64(:,:,830))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(20),n2h32(66))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(839),h0tab(:,839),[32,3,28],[0,0,nMW],3,2,wf4(:,4),wf8(:,9))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,331),heltab2x64(:,:,831))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(21),n2h32(67))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(840),h0tab(:,840),[32,3,28],[0,0,0],3,2,wf4(:,4),wf8(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,332),heltab2x64(:,:,832))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(22),n2h32(68))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(841),h0tab(:,841),[32,3,28],[0,0,nMZ],3,2,wf4(:,4),wf8(:,11))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),ngZu,m3h2x32(:,333),heltab2x64(:,:,833))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(23),n2h32(69))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(842),h0tab(:,842),[32,3,28],[0,0,nMW],3,2,wf4(:,4),wf8(:,11))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,334),heltab2x64(:,:,834))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(24),n2h32(70))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(843),h0tab(:,843),[32,3,28],[nMW,nMW,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,335),heltab2x64(:,:,835))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(844),h0tab(:,844),[32,3,28],[nMW,nMW,0],3,2,wf4(:,1),wf8(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,336),heltab2x64(:,:,836))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(845),h0tab(:,845),[32,3,28],[nMW,nMW,0],3,2,wf4(:,4),wf8(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,337),heltab2x64(:,:,837))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(846),h0tab(:,846),[32,3,28],[nMW,nMW,0],3,2,wf4(:,4),wf8(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,338),heltab2x64(:,:,838))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(847),h0tab(:,847),[44,3,16],[0,0,0],3,2,wf8(:,46),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(64),m3h8x8(:,125),heltab2x64(:,:,839))
  call Hloop_A_Q(ntryL,G0H8(64),44,0,G1H8(54),n2h8(123))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(848),h0tab(:,848),[44,3,16],[0,0,nMZ],3,2,wf8(:,46),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(65),ngZu,m3h8x8(:,126),heltab2x64(:,:,840))
  call Hloop_A_Q(ntryL,G0H8(65),44,0,G1H8(4),n2h8(124))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(849),h0tab(:,849),[44,3,16],[0,0,nMW],3,2,wf8(:,46),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(66),m3h8x8(:,127),heltab2x64(:,:,841))
  call Hloop_A_Q(ntryL,G0H8(66),44,0,G1H8(6),n2h8(125))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(850),h0tab(:,850),[44,3,16],[0,0,0],3,2,wf8(:,47),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,47),G0H8(67),m3h8x8(:,128),heltab2x64(:,:,842))
  call Hloop_A_Q(ntryL,G0H8(67),44,0,G1H8(7),n2h8(126))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(851),h0tab(:,851),[44,3,16],[0,0,nMZ],3,2,wf8(:,47),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,47),G0H8(6),ngZu,m3h8x8(:,129),heltab2x64(:,:,843))
  call Hloop_A_Q(ntryL,G0H8(6),44,0,G1H8(8),n2h8(127))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(852),h0tab(:,852),[44,3,16],[0,0,nMW],3,2,wf8(:,47),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,47),G0H8(7),m3h8x8(:,130),heltab2x64(:,:,844))
  call Hloop_A_Q(ntryL,G0H8(7),44,0,G1H8(15),n2h8(128))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(853),h0tab(:,853),[44,3,16],[0,0,0],3,2,wf8(:,46),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(8),m3h8x8(:,131),heltab2x64(:,:,845))
  call Hloop_A_Q(ntryL,G0H8(8),44,0,G1H8(17),n2h8(129))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(854),h0tab(:,854),[44,3,16],[0,0,nMZ],3,2,wf8(:,46),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(9),ngZu,m3h8x8(:,132),heltab2x64(:,:,846))
  call Hloop_A_Q(ntryL,G0H8(9),44,0,G1H8(18),n2h8(130))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(855),h0tab(:,855),[44,3,16],[0,0,nMW],3,2,wf8(:,46),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(10),m3h8x8(:,133),heltab2x64(:,:,847))
  call Hloop_A_Q(ntryL,G0H8(10),44,0,G1H8(11),n2h8(131))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(856),h0tab(:,856),[44,3,16],[0,0,0],3,2,wf8(:,47),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,47),G0H8(15),m3h8x8(:,134),heltab2x64(:,:,848))
  call Hloop_A_Q(ntryL,G0H8(15),44,0,G1H8(21),n2h8(132))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(857),h0tab(:,857),[44,3,16],[0,0,nMZ],3,2,wf8(:,47),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,47),G0H8(16),ngZu,m3h8x8(:,135),heltab2x64(:,:,849))
  call Hloop_A_Q(ntryL,G0H8(16),44,0,G1H8(22),n2h8(133))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(858),h0tab(:,858),[44,3,16],[0,0,nMW],3,2,wf8(:,47),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,47),G0H8(17),m3h8x8(:,136),heltab2x64(:,:,850))
  call Hloop_A_Q(ntryL,G0H8(17),44,0,G1H8(28),n2h8(134))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(859),h0tab(:,859),[44,3,16],[nMW,nMW,0],3,2,wf8(:,46),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,46),G0H8(18),m3h8x8(:,137),heltab2x64(:,:,851))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(860),h0tab(:,860),[44,3,16],[nMW,nMW,0],3,2,wf8(:,47),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,47),G0H8(20),m3h8x8(:,138),heltab2x64(:,:,852))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(861),h0tab(:,861),[44,3,16],[nMW,nMW,0],3,2,wf8(:,46),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,46),G0H8(21),m3h8x8(:,139),heltab2x64(:,:,853))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(862),h0tab(:,862),[44,3,16],[nMW,nMW,0],3,2,wf8(:,47),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,47),G0H8(22),m3h8x8(:,140),heltab2x64(:,:,854))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(863),h0tab(:,863),[32,15,16],[nMZ,nMZ,0],3,1,wf16(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZu,m3h2x32(:,339),heltab2x64(:,:,855))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(864),h0tab(:,864),[32,15,16],[nMW,nMW,0],3,1,wf16(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,340),heltab2x64(:,:,856))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(865),h0tab(:,865),[48,7,8],[0,0,0],3,2,wf4(:,5),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(65),m3h4x16(:,377),heltab2x64(:,:,857))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(195),n2h16(367))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(866),h0tab(:,866),[48,7,8],[0,nMZ,0],3,2,wf4(:,5),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(65),m3h4x16(:,378),heltab2x64(:,:,858))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(196),n2h16(368))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(867),h0tab(:,867),[48,7,8],[0,0,0],3,2,wf4(:,6),wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZl,m3h4x16(:,379),heltab2x64(:,:,859))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(197),n2h16(369))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(868),h0tab(:,868),[48,7,8],[0,nMZ,0],3,2,wf4(:,6),wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZl,m3h4x16(:,380),heltab2x64(:,:,860))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(198),n2h16(370))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(869),h0tab(:,869),[48,7,8],[0,nMW,0],3,2,wf4(:,6),wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZn,m3h4x16(:,381),heltab2x64(:,:,861))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(199),n2h16(371))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(870),h0tab(:,870),[48,7,8],[0,0,0],3,2,wf4(:,5),wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(65),m3h4x16(:,382),heltab2x64(:,:,862))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(200),n2h16(372))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(871),h0tab(:,871),[48,7,8],[0,nMZ,0],3,2,wf4(:,5),wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(65),m3h4x16(:,383),heltab2x64(:,:,863))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(201),n2h16(373))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(872),h0tab(:,872),[48,7,8],[0,0,0],3,2,wf4(:,6),wf8(:,18))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZl,m3h4x16(:,384),heltab2x64(:,:,864))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(202),n2h16(374))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(873),h0tab(:,873),[48,7,8],[0,nMZ,0],3,2,wf4(:,6),wf8(:,18))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZl,m3h4x16(:,385),heltab2x64(:,:,865))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(203),n2h16(375))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(874),h0tab(:,874),[48,7,8],[0,nMW,0],3,2,wf4(:,6),wf8(:,18))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZn,m3h4x16(:,386),heltab2x64(:,:,866))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(204),n2h16(376))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(875),h0tab(:,875),[48,7,8],[nMW,0,nMW],3,2,wf4(:,5),wf8(:,15))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(205),m3h4x16(:,387),heltab2x64(:,:,867))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(876),h0tab(:,876),[48,7,8],[nMW,0,nMW],3,2,wf4(:,6),wf8(:,15))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(206),m3h4x16(:,388),heltab2x64(:,:,868))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(877),h0tab(:,877),[48,7,8],[nMW,0,nMW],3,2,wf4(:,5),wf8(:,18))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(207),m3h4x16(:,389),heltab2x64(:,:,869))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(878),h0tab(:,878),[48,7,8],[nMW,0,nMW],3,2,wf4(:,6),wf8(:,18))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(208),m3h4x16(:,390),heltab2x64(:,:,870))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(879),h0tab(:,879),[48,4,11],[0,0,0],3,2,wf4(:,5),wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(65),m3h4x16(:,391),heltab2x64(:,:,871))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(209),n2h16(377))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(880),h0tab(:,880),[48,4,11],[0,nMZ,0],3,2,wf4(:,5),wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(65),m3h4x16(:,392),heltab2x64(:,:,872))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(210),n2h16(378))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(881),h0tab(:,881),[48,4,11],[0,0,0],3,2,wf4(:,6),wf8(:,60))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZl,m3h4x16(:,393),heltab2x64(:,:,873))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(211),n2h16(379))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(882),h0tab(:,882),[48,4,11],[0,nMZ,0],3,2,wf4(:,6),wf8(:,60))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZl,m3h4x16(:,394),heltab2x64(:,:,874))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(212),n2h16(380))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(883),h0tab(:,883),[48,4,11],[0,nMW,0],3,2,wf4(:,6),wf8(:,60))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZn,m3h4x16(:,395),heltab2x64(:,:,875))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(213),n2h16(381))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(884),h0tab(:,884),[48,4,11],[0,0,0],3,2,wf4(:,5),wf8(:,62))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(65),m3h4x16(:,396),heltab2x64(:,:,876))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(214),n2h16(382))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(885),h0tab(:,885),[48,4,11],[0,nMZ,0],3,2,wf4(:,5),wf8(:,62))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(65),m3h4x16(:,397),heltab2x64(:,:,877))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(215),n2h16(383))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(886),h0tab(:,886),[48,4,11],[0,0,0],3,2,wf4(:,6),wf8(:,62))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZl,m3h4x16(:,398),heltab2x64(:,:,878))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(216),n2h16(384))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(887),h0tab(:,887),[48,4,11],[0,nMZ,0],3,2,wf4(:,6),wf8(:,62))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZl,m3h4x16(:,399),heltab2x64(:,:,879))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(217),n2h16(385))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(888),h0tab(:,888),[48,4,11],[0,nMW,0],3,2,wf4(:,6),wf8(:,62))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,6),G0H16(65),ngZn,m3h4x16(:,400),heltab2x64(:,:,880))
  call Hloop_A_Q(ntryL,G0H16(65),48,0,G1H16(218),n2h16(386))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(889),h0tab(:,889),[48,4,11],[nMW,0,nMW],3,2,wf4(:,5),wf8(:,60))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(219),m3h4x16(:,401),heltab2x64(:,:,881))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(890),h0tab(:,890),[48,4,11],[nMW,0,nMW],3,2,wf4(:,6),wf8(:,60))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(220),m3h4x16(:,402),heltab2x64(:,:,882))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(891),h0tab(:,891),[48,4,11],[nMW,0,nMW],3,2,wf4(:,5),wf8(:,62))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(221),m3h4x16(:,403),heltab2x64(:,:,883))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(892),h0tab(:,892),[48,4,11],[nMW,0,nMW],3,2,wf4(:,6),wf8(:,62))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(222),m3h4x16(:,404),heltab2x64(:,:,884))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(893),h0tab(:,893),[52,3,8],[0,0,0],3,2,wf8(:,21),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,21),G0H8(23),m3h8x8(:,141),heltab2x64(:,:,885))
  call Hloop_Q_A(ntryL,G0H8(23),52,0,G1H8(29),n2h8(135))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(894),h0tab(:,894),[52,3,8],[0,0,nMZ],3,2,wf8(:,21),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,21),G0H8(29),ngZl,m3h8x8(:,142),heltab2x64(:,:,886))
  call Hloop_Q_A(ntryL,G0H8(29),52,0,G1H8(30),n2h8(136))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(895),h0tab(:,895),[52,3,8],[0,0,0],3,2,wf8(:,23),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,23),G0H8(30),m3h8x8(:,143),heltab2x64(:,:,887))
  call Hloop_Q_A(ntryL,G0H8(30),52,0,G1H8(34),n2h8(137))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(896),h0tab(:,896),[52,3,8],[0,0,nMZ],3,2,wf8(:,23),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,23),G0H8(24),ngZl,m3h8x8(:,144),heltab2x64(:,:,888))
  call Hloop_Q_A(ntryL,G0H8(24),52,0,G1H8(47),n2h8(138))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(897),h0tab(:,897),[52,3,8],[0,0,0],3,2,wf8(:,21),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,21),G0H8(25),m3h8x8(:,145),heltab2x64(:,:,889))
  call Hloop_Q_A(ntryL,G0H8(25),52,0,G1H8(49),n2h8(139))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(898),h0tab(:,898),[52,3,8],[0,0,nMZ],3,2,wf8(:,21),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,21),G0H8(26),ngZl,m3h8x8(:,146),heltab2x64(:,:,890))
  call Hloop_Q_A(ntryL,G0H8(26),52,0,G1H8(63),n2h8(140))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(899),h0tab(:,899),[52,3,8],[0,0,nMW],3,2,wf8(:,21),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,21),G0H8(27),m3h8x8(:,147),heltab2x64(:,:,891))
  call Hloop_Q_A(ntryL,G0H8(27),52,0,G1H8(10),n2h8(141))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(900),h0tab(:,900),[52,3,8],[0,0,0],3,2,wf8(:,23),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,23),G0H8(28),m3h8x8(:,148),heltab2x64(:,:,892))
  call Hloop_Q_A(ntryL,G0H8(28),52,0,G1H8(13),n2h8(142))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(901),h0tab(:,901),[52,3,8],[0,0,nMZ],3,2,wf8(:,23),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,23),G0H8(33),ngZl,m3h8x8(:,149),heltab2x64(:,:,893))
  call Hloop_Q_A(ntryL,G0H8(33),52,0,G1H8(48),n2h8(143))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(902),h0tab(:,902),[52,3,8],[0,0,nMW],3,2,wf8(:,23),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,23),G0H8(34),m3h8x8(:,150),heltab2x64(:,:,894))
  call Hloop_Q_A(ntryL,G0H8(34),52,0,G1H8(50),n2h8(144))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(903),h0tab(:,903),[52,3,8],[nMW,nMW,0],3,2,wf8(:,21),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,21),G0H8(35),m3h8x8(:,151),heltab2x64(:,:,895))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(904),h0tab(:,904),[52,3,8],[nMW,nMW,0],3,2,wf8(:,23),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,23),G0H8(36),m3h8x8(:,152),heltab2x64(:,:,896))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(905),h0tab(:,905),[52,3,8],[nMW,nMW,0],3,2,wf8(:,21),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,21),G0H8(42),m3h8x8(:,153),heltab2x64(:,:,897))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(906),h0tab(:,906),[52,3,8],[nMW,nMW,0],3,2,wf8(:,23),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,23),G0H8(43),m3h8x8(:,154),heltab2x64(:,:,898))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(907),h0tab(:,907),[56,3,4],[0,0,0],3,2,wf8(:,64),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,64),G0H8(44),m3h8x8(:,155),heltab2x64(:,:,899))
  call Hloop_A_Q(ntryL,G0H8(44),56,0,G1H8(68),n2h8(145))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(908),h0tab(:,908),[56,3,4],[0,0,nMZ],3,2,wf8(:,64),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,64),G0H8(45),ngZl,m3h8x8(:,156),heltab2x64(:,:,900))
  call Hloop_A_Q(ntryL,G0H8(45),56,0,G1H8(69),n2h8(146))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(909),h0tab(:,909),[56,3,4],[0,0,0],3,2,wf8(:,65),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,65),G0H8(46),m3h8x8(:,157),heltab2x64(:,:,901))
  call Hloop_A_Q(ntryL,G0H8(46),56,0,G1H8(70),n2h8(147))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(910),h0tab(:,910),[56,3,4],[0,0,nMZ],3,2,wf8(:,65),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,65),G0H8(51),ngZl,m3h8x8(:,158),heltab2x64(:,:,902))
  call Hloop_A_Q(ntryL,G0H8(51),56,0,G1H8(71),n2h8(148))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(911),h0tab(:,911),[56,3,4],[0,0,0],3,2,wf8(:,64),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,64),G0H8(52),m3h8x8(:,159),heltab2x64(:,:,903))
  call Hloop_A_Q(ntryL,G0H8(52),56,0,G1H8(73),n2h8(149))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(912),h0tab(:,912),[56,3,4],[0,0,nMZ],3,2,wf8(:,64),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,64),G0H8(53),ngZl,m3h8x8(:,160),heltab2x64(:,:,904))
  call Hloop_A_Q(ntryL,G0H8(53),56,0,G1H8(74),n2h8(150))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(913),h0tab(:,913),[56,3,4],[0,0,nMW],3,2,wf8(:,64),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,64),G0H8(54),m3h8x8(:,161),heltab2x64(:,:,905))
  call Hloop_A_Q(ntryL,G0H8(54),56,0,G1H8(75),n2h8(151))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(914),h0tab(:,914),[56,3,4],[0,0,0],3,2,wf8(:,65),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,65),G0H8(59),m3h8x8(:,162),heltab2x64(:,:,906))
  call Hloop_A_Q(ntryL,G0H8(59),56,0,G1H8(76),n2h8(152))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(915),h0tab(:,915),[56,3,4],[0,0,nMZ],3,2,wf8(:,65),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,65),G0H8(60),ngZl,m3h8x8(:,163),heltab2x64(:,:,907))
  call Hloop_A_Q(ntryL,G0H8(60),56,0,G1H8(78),n2h8(153))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(916),h0tab(:,916),[56,3,4],[0,0,nMW],3,2,wf8(:,65),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,65),G0H8(61),m3h8x8(:,164),heltab2x64(:,:,908))
  call Hloop_A_Q(ntryL,G0H8(61),56,0,G1H8(79),n2h8(154))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(917),h0tab(:,917),[56,3,4],[nMW,nMW,0],3,2,wf8(:,64),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,64),G0H8(62),m3h8x8(:,165),heltab2x64(:,:,909))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(918),h0tab(:,918),[56,3,4],[nMW,nMW,0],3,2,wf8(:,65),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,65),G0H8(68),m3h8x8(:,166),heltab2x64(:,:,910))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(919),h0tab(:,919),[56,3,4],[nMW,nMW,0],3,2,wf8(:,64),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,64),G0H8(69),m3h8x8(:,167),heltab2x64(:,:,911))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(920),h0tab(:,920),[56,3,4],[nMW,nMW,0],3,2,wf8(:,65),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,65),G0H8(70),m3h8x8(:,168),heltab2x64(:,:,912))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(921),h0tab(:,921),[51,4,8],[nMZ,0,nMZ],3,1,wf16(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,2),G0H4(9),m3h16x4(:,1),heltab2x64(:,:,913))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(922),h0tab(:,922),[51,4,8],[nMW,0,nMW],3,1,wf16(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf16(:,2),G0H4(10),m3h16x4(:,2),heltab2x64(:,:,914))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(923),h0tab(:,923),[32,15,16],[0,0,0],3,1,wf16(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,341),heltab2x64(:,:,915))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(25),n2h32(71))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(924),h0tab(:,924),[32,15,16],[0,0,nMZ],3,1,wf16(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(16),ngZu,m3h2x32(:,342),heltab2x64(:,:,916))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(26),n2h32(72))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(925),h0tab(:,925),[32,15,16],[0,0,nMW],3,1,wf16(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,343),heltab2x64(:,:,917))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(27),n2h32(73))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(926),h0tab(:,926),[32,15,16],[0,0,0],3,1,wf16(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,344),heltab2x64(:,:,918))
  call Hloop_A_Q(ntryL,G0H32(18),32,0,G1H32(28),n2h32(74))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(927),h0tab(:,927),[32,15,16],[0,0,nMZ],3,1,wf16(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(19),ngZu,m3h2x32(:,345),heltab2x64(:,:,919))
  call Hloop_A_Q(ntryL,G0H32(19),32,0,G1H32(29),n2h32(75))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(928),h0tab(:,928),[32,15,16],[0,0,nMW],3,1,wf16(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,346),heltab2x64(:,:,920))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(30),n2h32(76))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(929),h0tab(:,929),[32,15,16],[0,0,0],3,1,wf16(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,347),heltab2x64(:,:,921))
  call Hloop_A_Q(ntryL,G0H32(11),32,0,G1H32(31),n2h32(77))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(930),h0tab(:,930),[32,15,16],[0,0,nMZ],3,1,wf16(:,5))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(12),ngZu,m3h2x32(:,348),heltab2x64(:,:,922))
  call Hloop_A_Q(ntryL,G0H32(12),32,0,G1H32(32),n2h32(78))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(931),h0tab(:,931),[32,15,16],[0,0,nMW],3,1,wf16(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,349),heltab2x64(:,:,923))
  call Hloop_A_Q(ntryL,G0H32(21),32,0,G1H32(33),n2h32(79))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(932),h0tab(:,932),[32,15,16],[0,0,0],3,1,wf16(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,350),heltab2x64(:,:,924))
  call Hloop_A_Q(ntryL,G0H32(22),32,0,G1H32(34),n2h32(80))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(933),h0tab(:,933),[32,15,16],[0,0,nMZ],3,1,wf16(:,6))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),ngZu,m3h2x32(:,351),heltab2x64(:,:,925))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(35),n2h32(81))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(934),h0tab(:,934),[32,15,16],[0,0,nMW],3,1,wf16(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,352),heltab2x64(:,:,926))
  call Hloop_A_Q(ntryL,G0H32(24),32,0,G1H32(36),n2h32(82))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(935),h0tab(:,935),[32,15,16],[nMW,nMW,0],3,1,wf16(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,353),heltab2x64(:,:,927))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(936),h0tab(:,936),[32,15,16],[nMW,nMW,0],3,1,wf16(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,354),heltab2x64(:,:,928))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(937),h0tab(:,937),[32,15,16],[nMW,nMW,0],3,1,wf16(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,355),heltab2x64(:,:,929))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(938),h0tab(:,938),[32,15,16],[nMW,nMW,0],3,1,wf16(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,356),heltab2x64(:,:,930))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(939),h0tab(:,939),[32,15,16],[0,0,0],3,1,wf16(:,7))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,357),heltab2x64(:,:,931))
  call Hloop_A_Q(ntryL,G0H32(38),32,0,G1H32(37),n2h32(83))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(940),h0tab(:,940),[32,15,16],[0,0,nMZ],3,1,wf16(:,7))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(39),ngZu,m3h2x32(:,358),heltab2x64(:,:,932))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(38),n2h32(84))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(941),h0tab(:,941),[32,15,16],[0,0,nMW],3,1,wf16(:,7))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,359),heltab2x64(:,:,933))
  call Hloop_A_Q(ntryL,G0H32(40),32,0,G1H32(39),n2h32(85))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(942),h0tab(:,942),[32,15,16],[0,0,0],3,1,wf16(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,360),heltab2x64(:,:,934))
  call Hloop_A_Q(ntryL,G0H32(41),32,0,G1H32(40),n2h32(86))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(943),h0tab(:,943),[32,15,16],[0,0,nMZ],3,1,wf16(:,8))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(42),ngZu,m3h2x32(:,361),heltab2x64(:,:,935))
  call Hloop_A_Q(ntryL,G0H32(42),32,0,G1H32(41),n2h32(87))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(944),h0tab(:,944),[32,15,16],[0,0,nMW],3,1,wf16(:,8))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,362),heltab2x64(:,:,936))
  call Hloop_A_Q(ntryL,G0H32(43),32,0,G1H32(42),n2h32(88))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(945),h0tab(:,945),[32,15,16],[0,0,0],3,1,wf16(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,363),heltab2x64(:,:,937))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(43),n2h32(89))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(946),h0tab(:,946),[32,15,16],[0,0,nMZ],3,1,wf16(:,9))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(45),ngZu,m3h2x32(:,364),heltab2x64(:,:,938))
  call Hloop_A_Q(ntryL,G0H32(45),32,0,G1H32(44),n2h32(90))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(947),h0tab(:,947),[32,15,16],[0,0,nMW],3,1,wf16(:,9))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,365),heltab2x64(:,:,939))
  call Hloop_A_Q(ntryL,G0H32(55),32,0,G1H32(45),n2h32(91))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(948),h0tab(:,948),[32,15,16],[0,0,0],3,1,wf16(:,10))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(56),m3h2x32(:,366),heltab2x64(:,:,940))
  call Hloop_A_Q(ntryL,G0H32(56),32,0,G1H32(46),n2h32(92))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(949),h0tab(:,949),[32,15,16],[0,0,nMZ],3,1,wf16(:,10))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(57),ngZu,m3h2x32(:,367),heltab2x64(:,:,941))
  call Hloop_A_Q(ntryL,G0H32(57),32,0,G1H32(47),n2h32(93))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(950),h0tab(:,950),[32,15,16],[0,0,nMW],3,1,wf16(:,10))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,368),heltab2x64(:,:,942))
  call Hloop_A_Q(ntryL,G0H32(58),32,0,G1H32(48),n2h32(94))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(951),h0tab(:,951),[32,15,16],[nMW,nMW,0],3,1,wf16(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(67),m3h2x32(:,369),heltab2x64(:,:,943))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(952),h0tab(:,952),[32,15,16],[nMW,nMW,0],3,1,wf16(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(68),m3h2x32(:,370),heltab2x64(:,:,944))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(953),h0tab(:,953),[32,15,16],[nMW,nMW,0],3,1,wf16(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,371),heltab2x64(:,:,945))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(954),h0tab(:,954),[32,15,16],[nMW,nMW,0],3,1,wf16(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(70),m3h2x32(:,372),heltab2x64(:,:,946))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(955),h0tab(:,955),[51,4,8],[0,0,0],3,1,wf16(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,11),G0H4(11),m3h16x4(:,3),heltab2x64(:,:,947))
  call Hloop_A_Q(ntryL,G0H4(11),51,0,G1H4(5),n2h4(246))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(956),h0tab(:,956),[51,4,8],[0,nMZ,0],3,1,wf16(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,11),G0H4(11),m3h16x4(:,4),heltab2x64(:,:,948))
  call Hloop_A_Q(ntryL,G0H4(11),51,0,G1H4(6),n2h4(247))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(957),h0tab(:,957),[51,4,8],[0,0,0],3,1,wf16(:,12))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,12),G0H4(11),ngZl,m3h16x4(:,5),heltab2x64(:,:,949))
  call Hloop_A_Q(ntryL,G0H4(11),51,0,G1H4(7),n2h4(248))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(958),h0tab(:,958),[51,4,8],[0,nMZ,0],3,1,wf16(:,12))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,12),G0H4(11),ngZl,m3h16x4(:,6),heltab2x64(:,:,950))
  call Hloop_A_Q(ntryL,G0H4(11),51,0,G1H4(14),n2h4(249))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(959),h0tab(:,959),[51,4,8],[0,nMW,0],3,1,wf16(:,12))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,12),G0H4(11),ngZn,m3h16x4(:,7),heltab2x64(:,:,951))
  call Hloop_A_Q(ntryL,G0H4(11),51,0,G1H4(17),n2h4(250))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(960),h0tab(:,960),[51,4,8],[0,0,0],3,1,wf16(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,13),G0H4(11),m3h16x4(:,8),heltab2x64(:,:,952))
  call Hloop_A_Q(ntryL,G0H4(11),51,0,G1H4(23),n2h4(251))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(961),h0tab(:,961),[51,4,8],[0,nMZ,0],3,1,wf16(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,13),G0H4(11),m3h16x4(:,9),heltab2x64(:,:,953))
  call Hloop_A_Q(ntryL,G0H4(11),51,0,G1H4(24),n2h4(252))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(962),h0tab(:,962),[51,4,8],[0,0,0],3,1,wf16(:,14))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,14),G0H4(11),ngZl,m3h16x4(:,10),heltab2x64(:,:,954))
  call Hloop_A_Q(ntryL,G0H4(11),51,0,G1H4(32),n2h4(253))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(963),h0tab(:,963),[51,4,8],[0,nMZ,0],3,1,wf16(:,14))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf16(:,14),G0H4(11),ngZl,m3h16x4(:,11),heltab2x64(:,:,955))


! end do

end subroutine vamp_1

end module ol_vamp_1_ppllll_ew_eexmmxuux_1_/**/REALKIND
