
module ol_vamp_1_ppllll_ew_eexmmxaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_ew_eexmmxaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_ew_eexmmxaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_ew_eexmmxaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_ew_eexmmxaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllll_ew_eexmmxaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_eexmmxaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,2,1,4,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,2,1,4,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,8,2,1,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,4,1,2,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,4,1,2,8,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,4,1,2,8,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,1,2,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,8,1,2,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,8,1,2,4,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,8,1,2,4,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,8,1,2,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,4,2,1,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,2,1,8,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,2,1,8,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,2,1,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,4,8,1,2,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,4,8,1,2,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(17),m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,2,1,8,4,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,2,1,8,4,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,8,4,2,1,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,8,4,2,1,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,2,1,16,8,4],[nMW,0,nMW,nMW,0,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,1,2,4,8,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,1,2,4,8,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(21),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,1,2,16,4,8],[nMW,0,nMW,nMW,0,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(22),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,4,1,16,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(23),n2h32(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,4,1,16,2,8],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(24),n2h32(18))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,4,1,16,2,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(25),n2h32(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,4,1,16,2,8],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(26),n2h32(20))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,2,8,4,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(27),n2h32(21))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,2,8,4,1,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(28),n2h32(22))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,2,8,4,1,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(29),n2h32(23))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,2,8,4,1,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(30),n2h32(24))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,4,8,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(31),n2h32(25))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,4,8,2,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(32),n2h32(26))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,1,4,8,2,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(33),n2h32(27))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,1,4,8,2,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(34),n2h32(28))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,1,4,16,8,2],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(35),n2h32(29))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,4,16,8,2],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(36),n2h32(30))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,1,4,16,8,2],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(37),n2h32(31))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,1,4,16,8,2],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(38),n2h32(32))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,2,16,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(39),n2h32(33))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,2,16,1,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(40),n2h32(34))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,4,2,16,1,8],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(41),n2h32(35))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,4,2,16,1,8],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(42),n2h32(36))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,2,4,8,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(43),n2h32(37))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,2,4,8,1,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(44),n2h32(38))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,2,4,8,1,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(45),n2h32(39))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,2,4,8,1,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(46),n2h32(40))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,1,8,4,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(47),n2h32(41))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,1,8,4,2,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(48),n2h32(42))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,1,8,4,2,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(49),n2h32(43))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,1,8,4,2,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,54),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(50),n2h32(44))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,1,8,16,4,2],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(51),n2h32(45))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,1,8,16,4,2],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(52),n2h32(46))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,1,8,16,4,2],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(53),n2h32(47))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,1,8,16,4,2],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(54),n2h32(48))
  call Hloop_QA_V(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_QA_Z(ntryL,G1H32(2),ex4(:),G1H16(2),ngZl,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_QA_V(ntryL,G1H32(3),ex4(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_QA_Z(ntryL,G1H32(4),ex4(:),G1H16(4),ngZl,m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_AQ_V(ntryL,G1H32(5),ex3(:),G1H16(5),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_AQ_V(ntryL,G1H32(6),ex3(:),G1H16(6),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H32(7),ex3(:),G1H16(7),ngZl,m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H32(8),ex3(:),G1H16(8),ngZl,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_QA_V(ntryL,G1H32(9),ex4(:),G1H16(9),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_QA_V(ntryL,G1H32(10),ex4(:),G1H16(10),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_QA_Z(ntryL,G1H32(11),ex4(:),G1H16(11),ngZl,m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_QA_Z(ntryL,G1H32(12),ex4(:),G1H16(12),ngZl,m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_AQ_V(ntryL,G1H32(13),ex3(:),G1H16(13),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H32(14),ex3(:),G1H16(14),ngZl,m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_AQ_V(ntryL,G1H32(15),ex3(:),G1H16(15),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H32(16),ex3(:),G1H16(16),ngZl,m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_WQ_A(ntryL,G0H32(1),ex3(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(17),n2h16(1))
  call Hloop_WQ_A(ntryL,G1H32(17),ex3(:),G1H16(18),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H16(18),36,0,G2H16(1),n2h16(2))
  call Hloop_WA_Q(ntryL,G0H32(2),ex2(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(18),n2h16(3))
  call Hloop_WA_Q(ntryL,G1H32(18),ex2(:),G1H16(19),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G1H16(19),34,0,G2H16(2),n2h16(4))
  call Hloop_WA_Q(ntryL,G0H32(3),ex4(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(19),n2h16(5))
  call Hloop_WA_Q(ntryL,G1H32(19),ex4(:),G1H16(20),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G1H16(20),40,0,G2H16(3),n2h16(6))
  call Hloop_WA_Q(ntryL,G1H32(20),ex2(:),G1H16(20),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H16(20),34,0,G2H16(4),n2h16(7))
  call Hloop_WQ_A(ntryL,G0H32(4),ex1(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(20),n2h16(8))
  call Hloop_WQ_A(ntryL,G1H32(21),ex1(:),G1H16(21),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G1H16(21),33,0,G2H16(5),n2h16(9))
  call Hloop_WQ_A(ntryL,G1H32(22),ex1(:),G1H16(21),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H16(21),33,0,G2H16(6),n2h16(10))
  call Hloop_AQ_V(ntryL,G1H32(23),ex3(:),G1H16(21),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_AQ_V(ntryL,G1H32(24),ex3(:),G1H16(22),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_AQ_Z(ntryL,G1H32(25),ex3(:),G1H16(23),ngZl,m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_AQ_Z(ntryL,G1H32(26),ex3(:),G1H16(24),ngZl,m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_QA_V(ntryL,G1H32(27),ex2(:),G1H16(25),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_QA_Z(ntryL,G1H32(28),ex2(:),G1H16(26),ngZl,m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_QA_V(ntryL,G1H32(29),ex2(:),G1H16(27),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_QA_Z(ntryL,G1H32(30),ex2(:),G1H16(28),ngZl,m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_AQ_V(ntryL,G1H32(31),ex1(:),G1H16(29),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_AQ_V(ntryL,G1H32(32),ex1(:),G1H16(30),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_AQ_Z(ntryL,G1H32(33),ex1(:),G1H16(31),ngZl,m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_AQ_Z(ntryL,G1H32(34),ex1(:),G1H16(32),ngZl,m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_AQ_V(ntryL,G1H32(35),ex1(:),G1H16(33),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_AQ_V(ntryL,G1H32(36),ex1(:),G1H16(34),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_AQ_Z(ntryL,G1H32(37),ex1(:),G1H16(35),ngZl,m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_AQ_Z(ntryL,G1H32(38),ex1(:),G1H16(36),ngZl,m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_AQ_V(ntryL,G1H32(39),ex3(:),G1H16(37),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_AQ_Z(ntryL,G1H32(40),ex3(:),G1H16(38),ngZl,m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_AQ_V(ntryL,G1H32(41),ex3(:),G1H16(39),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_AQ_Z(ntryL,G1H32(42),ex3(:),G1H16(40),ngZl,m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_QA_V(ntryL,G1H32(43),ex2(:),G1H16(41),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_QA_Z(ntryL,G1H32(44),ex2(:),G1H16(42),ngZl,m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_QA_V(ntryL,G1H32(45),ex2(:),G1H16(43),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_QA_Z(ntryL,G1H32(46),ex2(:),G1H16(44),ngZl,m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_AQ_V(ntryL,G1H32(47),ex1(:),G1H16(45),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_AQ_V(ntryL,G1H32(48),ex1(:),G1H16(46),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_AQ_Z(ntryL,G1H32(49),ex1(:),G1H16(47),ngZl,m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_AQ_Z(ntryL,G1H32(50),ex1(:),G1H16(48),ngZl,m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_AQ_V(ntryL,G1H32(51),ex1(:),G1H16(49),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_AQ_V(ntryL,G1H32(52),ex1(:),G1H16(50),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_AQ_Z(ntryL,G1H32(53),ex1(:),G1H16(51),ngZl,m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_AQ_Z(ntryL,G1H32(54),ex1(:),G1H16(52),ngZl,m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_VA_Q(ntryL,G1H16(1),ex2(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(1),n2h8(1))
  call Hloop_ZA_Q(ntryL,G1H16(2),ex2(:),G1H8(1),ngZl,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(2),n2h8(2))
  call Hloop_VA_Q(ntryL,G1H16(3),ex2(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(3),n2h8(3))
  call Hloop_ZA_Q(ntryL,G1H16(4),ex2(:),G1H8(1),ngZl,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(4),n2h8(4))
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(5),n2h8(5))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(6),n2h8(6))
  call Hloop_ZQ_A(ntryL,G1H16(7),ex1(:),G1H8(1),ngZl,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(7),n2h8(7))
  call Hloop_ZQ_A(ntryL,G1H16(8),ex1(:),G1H8(1),ngZl,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(8),n2h8(8))
  call Hloop_VQ_A(ntryL,G1H16(9),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(9),n2h8(9))
  call Hloop_VQ_A(ntryL,G1H16(10),ex1(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(10),n2h8(10))
  call Hloop_ZQ_A(ntryL,G1H16(11),ex1(:),G1H8(1),ngZl,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(11),n2h8(11))
  call Hloop_ZQ_A(ntryL,G1H16(12),ex1(:),G1H8(1),ngZl,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(12),n2h8(12))
  call Hloop_VA_Q(ntryL,G1H16(13),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(13),n2h8(13))
  call Hloop_ZA_Q(ntryL,G1H16(14),ex2(:),G1H8(1),ngZl,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(14),n2h8(14))
  call Hloop_VA_Q(ntryL,G1H16(15),ex2(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(15),n2h8(15))
  call Hloop_ZA_Q(ntryL,G1H16(16),ex2(:),G1H8(1),ngZl,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(16),n2h8(16))
  call Hloop_QA_W(ntryL,G1H16(17),ex4(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_QA_W(ntryL,G2H16(1),ex4(:),G2H8(17),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AQ_W(ntryL,G1H16(18),ex1(:),G1H8(2),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_AQ_W(ntryL,G2H16(2),ex1(:),G2H8(18),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AQ_W(ntryL,G1H16(19),ex3(:),G1H8(3),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_AQ_W(ntryL,G2H16(3),ex3(:),G2H8(19),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_AQ_W(ntryL,G2H16(4),ex1(:),G2H8(20),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_QA_W(ntryL,G1H16(20),ex2(:),G1H8(4),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_QA_W(ntryL,G2H16(5),ex2(:),G2H8(21),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_QA_W(ntryL,G2H16(6),ex2(:),G2H8(22),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_VQ_A(ntryL,G1H16(21),ex1(:),G1H8(5),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(23),n2h8(17))
  call Hloop_VQ_A(ntryL,G1H16(22),ex1(:),G1H8(5),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(24),n2h8(18))
  call Hloop_ZQ_A(ntryL,G1H16(23),ex1(:),G1H8(5),ngZl,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(25),n2h8(19))
  call Hloop_ZQ_A(ntryL,G1H16(24),ex1(:),G1H8(5),ngZl,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(26),n2h8(20))
  call Hloop_VA_Q(ntryL,G1H16(25),ex4(:),G1H8(5),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(5),42,0,G2H8(27),n2h8(21))
  call Hloop_ZA_Q(ntryL,G1H16(26),ex4(:),G1H8(5),ngZl,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(5),42,0,G2H8(28),n2h8(22))
  call Hloop_VA_Q(ntryL,G1H16(27),ex4(:),G1H8(5),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(5),42,0,G2H8(29),n2h8(23))
  call Hloop_ZA_Q(ntryL,G1H16(28),ex4(:),G1H8(5),ngZl,m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(5),42,0,G2H8(30),n2h8(24))
  call Hloop_VQ_A(ntryL,G1H16(29),ex3(:),G1H8(5),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(31),n2h8(25))
  call Hloop_VQ_A(ntryL,G1H16(30),ex3(:),G1H8(5),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(32),n2h8(26))
  call Hloop_ZQ_A(ntryL,G1H16(31),ex3(:),G1H8(5),ngZl,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(33),n2h8(27))
  call Hloop_ZQ_A(ntryL,G1H16(32),ex3(:),G1H8(5),ngZl,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(34),n2h8(28))
  call Hloop_VQ_A(ntryL,G1H16(33),ex3(:),G1H8(5),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(35),n2h8(29))
  call Hloop_VQ_A(ntryL,G1H16(34),ex3(:),G1H8(5),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(36),n2h8(30))
  call Hloop_ZQ_A(ntryL,G1H16(35),ex3(:),G1H8(5),ngZl,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(37),n2h8(31))
  call Hloop_ZQ_A(ntryL,G1H16(36),ex3(:),G1H8(5),ngZl,m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(38),n2h8(32))
  call Hloop_VA_Q(ntryL,G1H16(37),ex2(:),G1H8(5),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(39),n2h8(33))
  call Hloop_ZA_Q(ntryL,G1H16(38),ex2(:),G1H8(5),ngZl,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(40),n2h8(34))
  call Hloop_VA_Q(ntryL,G1H16(39),ex2(:),G1H8(5),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(41),n2h8(35))
  call Hloop_ZA_Q(ntryL,G1H16(40),ex2(:),G1H8(5),ngZl,m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(42),n2h8(36))
  call Hloop_VQ_A(ntryL,G1H16(41),ex3(:),G1H8(5),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(5),38,0,G2H8(43),n2h8(37))
  call Hloop_ZQ_A(ntryL,G1H16(42),ex3(:),G1H8(5),ngZl,m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(5),38,0,G2H8(44),n2h8(38))
  call Hloop_VQ_A(ntryL,G1H16(43),ex3(:),G1H8(5),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(5),38,0,G2H8(45),n2h8(39))
  call Hloop_ZQ_A(ntryL,G1H16(44),ex3(:),G1H8(5),ngZl,m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(5),38,0,G2H8(46),n2h8(40))
  call Hloop_VA_Q(ntryL,G1H16(45),ex4(:),G1H8(5),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(47),n2h8(41))
  call Hloop_VA_Q(ntryL,G1H16(46),ex4(:),G1H8(5),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(48),n2h8(42))
  call Hloop_ZA_Q(ntryL,G1H16(47),ex4(:),G1H8(5),ngZl,m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(49),n2h8(43))
  call Hloop_ZA_Q(ntryL,G1H16(48),ex4(:),G1H8(5),ngZl,m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(50),n2h8(44))
  call Hloop_VA_Q(ntryL,G1H16(49),ex4(:),G1H8(5),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(51),n2h8(45))
  call Hloop_VA_Q(ntryL,G1H16(50),ex4(:),G1H8(5),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(52),n2h8(46))
  call Hloop_ZA_Q(ntryL,G1H16(51),ex4(:),G1H8(5),ngZl,m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(53),n2h8(47))
  call Hloop_ZA_Q(ntryL,G1H16(52),ex4(:),G1H8(5),ngZl,m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(54),n2h8(48))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(2),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_Z(ntryL,G2H8(3),ex1(:),G2H4(3),ngZl,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H8(4),ex1(:),G2H4(4),ngZl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_V(ntryL,G2H8(5),ex2(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_Z(ntryL,G2H8(6),ex2(:),G2H4(6),ngZl,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_Z(ntryL,G2H8(8),ex2(:),G2H4(8),ngZl,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G2H8(9),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_Z(ntryL,G2H8(10),ex2(:),G2H4(10),ngZl,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(11),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_Z(ntryL,G2H8(12),ex2(:),G2H4(12),ngZl,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_V(ntryL,G2H8(13),ex1(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_V(ntryL,G2H8(14),ex1(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_AQ_Z(ntryL,G2H8(15),ex1(:),G2H4(15),ngZl,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_Z(ntryL,G2H8(16),ex1(:),G2H4(16),ngZl,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_WQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(17),n2h4(1))
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(1),mass5set(:,1),  & 
G1H8(5),G1H8(1),G1H8(6),G1H8(7),G1H8(8),G1H8(9),8)
  call HG1shiftOLR(G1H8(1),16,8)
  call Hloop_WA_Q(ntryL,G1H8(2),ex4(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(18),n2h4(2))
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(2),mass5set(:,1),  & 
G1H8(2),G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(10),16,8)
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(19),n2h4(3))
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(3),mass5set(:,1),  & 
G1H8(3),G1H8(15),G1H8(16),G1H8(17),G1H8(18),G1H8(19),8)
  call HG1shiftOLR(G1H8(15),16,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(4),mass5set(:,2),  & 
G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),8)
  call HG1shiftOLR(G1H8(21),4,8)
  call Hloop_WQ_A(ntryL,G1H8(4),ex3(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(20),n2h4(4))
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(5),mass5set(:,1),  & 
G1H8(4),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(6),mass5set(:,2),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(7),mass5set(:,3),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(7),mass5set(:,3),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),8,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(7),mass5set(:,4),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),8,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(7),mass5set(:,4),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),8,8)
  call Hloop_AQ_V(ntryL,G2H8(27),ex3(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G2H8(28),ex3(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_Z(ntryL,G2H8(29),ex3(:),G2H4(23),ngZl,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_Z(ntryL,G2H8(30),ex3(:),G2H4(24),ngZl,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_QA_V(ntryL,G2H8(31),ex4(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_Z(ntryL,G2H8(32),ex4(:),G2H4(26),ngZl,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_V(ntryL,G2H8(33),ex4(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QA_Z(ntryL,G2H8(34),ex4(:),G2H4(28),ngZl,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hotf_5pt_reduction(G2H8(35),RedSet_5(8),mass5set(:,3),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),2,8)
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(8),mass5set(:,3),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),2,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(8),mass5set(:,4),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),2,8)
  call Hotf_5pt_reduction(G2H8(38),RedSet_5(8),mass5set(:,4),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),2,8)
  call Hotf_5pt_reduction(G2H8(39),RedSet_5(9),mass5set(:,3),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hotf_5pt_reduction(G2H8(40),RedSet_5(9),mass5set(:,4),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),8,8)
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(9),mass5set(:,3),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_5pt_reduction(G2H8(42),RedSet_5(9),mass5set(:,4),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hloop_QA_V(ntryL,G2H8(43),ex4(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QA_V(ntryL,G2H8(44),ex4(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_QA_Z(ntryL,G2H8(45),ex4(:),G2H4(31),ngZl,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_QA_Z(ntryL,G2H8(46),ex4(:),G2H4(32),ngZl,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_AQ_V(ntryL,G2H8(47),ex3(:),G2H4(33),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_AQ_Z(ntryL,G2H8(48),ex3(:),G2H4(34),ngZl,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_V(ntryL,G2H8(49),ex3(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_AQ_Z(ntryL,G2H8(50),ex3(:),G2H4(36),ngZl,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(10),mass5set(:,3),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),2,8)
  call Hotf_5pt_reduction(G2H8(52),RedSet_5(10),mass5set(:,3),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),2,8)
  call Hotf_5pt_reduction(G2H8(53),RedSet_5(10),mass5set(:,4),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),2,8)
  call Hotf_5pt_reduction(G2H8(54),RedSet_5(10),mass5set(:,4),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),2,8)
  call Hloop_WQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(37),n2h4(5))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1),-16,ex5(:),16,G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_WQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(39),n2h4(6))
  call Hloop_WQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(40),n2h4(7))
  call Hloop_WA_Q(ntryL,G1H8(2),ex4(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(41),n2h4(8))
call HGT_raise_alpha_OLR(G1H8(10),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(10),-16,ex5(:),16,G2H4(42),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_WA_Q(ntryL,G1H8(13),ex4(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(43),n2h4(9))
  call Hloop_WA_Q(ntryL,G1H8(14),ex4(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(44),n2h4(10))
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(45),n2h4(11))
call HGT_raise_alpha_OLR(G1H8(15),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(15),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(15),-16,ex5(:),16,G2H4(46),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_WA_Q(ntryL,G1H8(18),ex2(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(47),n2h4(12))
  call Hloop_WA_Q(ntryL,G1H8(19),ex2(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(48),n2h4(13))
  call Hloop_UV_W(ntryL,G1H8(20),35,ex5(:),16,G2H4(49),m3h2x4(:,49),heltab2x8(:,:,49))
call HGT_raise_alpha_OLR(G1H8(21),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(21),ex3(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_UV_W(ntryL,G1H8(24),35,ex5(:),16,G2H4(50),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_UV_W(ntryL,G1H8(25),35,ex5(:),16,G2H4(51),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_WQ_A(ntryL,G1H8(4),ex3(:),G1H4(2),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(52),n2h4(14))
call HGT_raise_alpha_OLR(G1H8(26),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(26),-16,ex5(:),16,G2H4(53),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_WQ_A(ntryL,G1H8(29),ex3(:),G1H4(2),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(54),n2h4(15))
  call Hloop_WQ_A(ntryL,G1H8(30),ex3(:),G1H4(2),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(55),n2h4(16))
  call Hloop_UW_V(ntryL,G1H8(31),35,ex5(:),16,G2H4(56),m3h2x4(:,57),heltab2x8(:,:,57))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(32),ex4(:),G1H4(2),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_UW_V(ntryL,G1H8(35),35,ex5(:),16,G2H4(57),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_UW_V(ntryL,G1H8(36),35,ex5(:),16,G2H4(58),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QV_A(ntryL,G1H8(37),ex5(:),G1H4(3),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(59),n2h4(17))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-8,0,G2H8(1),n2h8(55))
  call Hloop_QA_V(ntryL,G2H8(1),ex4(:),G2H4(60),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_QV_A(ntryL,G1H8(41),ex5(:),G1H4(3),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(61),n2h4(18))
  call Hloop_QV_A(ntryL,G1H8(42),ex5(:),G1H4(3),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(62),n2h4(19))
  call Hloop_QV_A(ntryL,G1H8(43),ex5(:),G1H4(3),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(63),n2h4(20))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-8,0,G2H8(2),n2h8(56))
  call Hloop_QA_Z(ntryL,G2H8(2),ex4(:),G2H4(64),ngZl,m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_QV_A(ntryL,G1H8(47),ex5(:),G1H4(3),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(65),n2h4(21))
  call Hloop_QV_A(ntryL,G1H8(48),ex5(:),G1H4(3),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(66),n2h4(22))
  call Hloop_QV_A(ntryL,G1H8(49),ex5(:),G1H4(3),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(67),n2h4(23))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(50),-8,0,G2H8(3),n2h8(57))
  call Hloop_QA_V(ntryL,G2H8(3),ex4(:),G2H4(68),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_QV_A(ntryL,G1H8(53),ex5(:),G1H4(3),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(69),n2h4(24))
  call Hloop_QV_A(ntryL,G1H8(54),ex5(:),G1H4(3),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(70),n2h4(25))
  call Hloop_QV_A(ntryL,G1H8(55),ex5(:),G1H4(3),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(71),n2h4(26))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(56),-8,0,G2H8(4),n2h8(58))
  call Hloop_QA_Z(ntryL,G2H8(4),ex4(:),G2H4(72),ngZl,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_QV_A(ntryL,G1H8(59),ex5(:),G1H4(3),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(73),n2h4(27))
  call Hloop_QV_A(ntryL,G1H8(60),ex5(:),G1H4(3),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(74),n2h4(28))
  call Hloop_QV_A(ntryL,G1H8(61),ex5(:),G1H4(3),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(75),n2h4(29))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(62),-2,0,G2H8(5),n2h8(59))
  call Hloop_QA_V(ntryL,G2H8(5),ex2(:),G2H4(76),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_QV_A(ntryL,G1H8(65),ex5(:),G1H4(3),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(77),n2h4(30))
  call Hloop_QV_A(ntryL,G1H8(66),ex5(:),G1H4(3),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(78),n2h4(31))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(3),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(79),n2h4(32))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(68),-2,0,G2H8(6),n2h8(60))
  call Hloop_QA_Z(ntryL,G2H8(6),ex2(:),G2H4(80),ngZl,m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_QV_A(ntryL,G1H8(71),ex5(:),G1H4(3),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(81),n2h4(33))
  call Hloop_QV_A(ntryL,G1H8(72),ex5(:),G1H4(3),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(82),n2h4(34))
  call Hloop_QV_A(ntryL,G1H8(73),ex5(:),G1H4(3),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(83),n2h4(35))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(74),-2,0,G2H8(7),n2h8(61))
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(84),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_QV_A(ntryL,G1H8(77),ex5(:),G1H4(3),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(85),n2h4(36))
  call Hloop_QV_A(ntryL,G1H8(78),ex5(:),G1H4(3),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(86),n2h4(37))
  call Hloop_QV_A(ntryL,G1H8(79),ex5(:),G1H4(3),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(87),n2h4(38))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(80),-2,0,G2H8(8),n2h8(62))
  call Hloop_QA_Z(ntryL,G2H8(8),ex2(:),G2H4(88),ngZl,m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_QV_A(ntryL,G1H8(83),ex5(:),G1H4(3),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(89),n2h4(39))
  call Hloop_QV_A(ntryL,G1H8(84),ex5(:),G1H4(3),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(90),n2h4(40))
  call Hloop_AV_Q(ntryL,G1H8(85),ex5(:),G1H4(3),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(91),n2h4(41))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(86),-8,0,G2H8(9),n2h8(63))
  call Hloop_QA_V(ntryL,G2H8(9),ex4(:),G2H4(92),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_AV_Q(ntryL,G1H8(89),ex5(:),G1H4(3),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(93),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H8(90),ex5(:),G1H4(3),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(94),n2h4(43))
  call Hloop_AV_Q(ntryL,G1H8(91),ex5(:),G1H4(3),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(95),n2h4(44))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(92),-8,0,G2H8(10),n2h8(64))
  call Hloop_QA_V(ntryL,G2H8(10),ex4(:),G2H4(96),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_AV_Q(ntryL,G1H8(95),ex5(:),G1H4(3),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(97),n2h4(45))
  call Hloop_AV_Q(ntryL,G1H8(96),ex5(:),G1H4(3),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(98),n2h4(46))
  call Hloop_AV_Q(ntryL,G1H8(97),ex5(:),G1H4(3),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(99),n2h4(47))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(98),-8,0,G2H8(11),n2h8(65))
  call Hloop_QA_Z(ntryL,G2H8(11),ex4(:),G2H4(100),ngZl,m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_AV_Q(ntryL,G1H8(101),ex5(:),G1H4(3),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(101),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H8(102),ex5(:),G1H4(3),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(102),n2h4(49))
  call Hloop_AV_Q(ntryL,G1H8(103),ex5(:),G1H4(3),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(103),n2h4(50))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-8,0,G2H8(12),n2h8(66))
  call Hloop_QA_Z(ntryL,G2H8(12),ex4(:),G2H4(104),ngZl,m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_AV_Q(ntryL,G1H8(107),ex5(:),G1H4(3),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(105),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H8(108),ex5(:),G1H4(3),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(106),n2h4(52))
  call Hloop_AV_Q(ntryL,G1H8(109),ex5(:),G1H4(3),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(107),n2h4(53))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(110),-2,0,G2H8(13),n2h8(67))
  call Hloop_QA_V(ntryL,G2H8(13),ex2(:),G2H4(108),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_AV_Q(ntryL,G1H8(113),ex5(:),G1H4(3),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(109),n2h4(54))
  call Hloop_AV_Q(ntryL,G1H8(114),ex5(:),G1H4(3),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(110),n2h4(55))
  call Hloop_AV_Q(ntryL,G1H8(115),ex5(:),G1H4(3),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(111),n2h4(56))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(116),-2,0,G2H8(14),n2h8(68))
  call Hloop_QA_Z(ntryL,G2H8(14),ex2(:),G2H4(112),ngZl,m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_AV_Q(ntryL,G1H8(119),ex5(:),G1H4(3),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(113),n2h4(57))
  call Hloop_AV_Q(ntryL,G1H8(120),ex5(:),G1H4(3),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(114),n2h4(58))
  call Hloop_AV_Q(ntryL,G1H8(121),ex5(:),G1H4(3),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(115),n2h4(59))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(122),-2,0,G2H8(15),n2h8(69))
  call Hloop_QA_V(ntryL,G2H8(15),ex2(:),G2H4(116),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_AV_Q(ntryL,G1H8(125),ex5(:),G1H4(3),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(117),n2h4(60))
  call Hloop_AV_Q(ntryL,G1H8(126),ex5(:),G1H4(3),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(118),n2h4(61))
  call Hloop_AV_Q(ntryL,G1H8(127),ex5(:),G1H4(3),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(119),n2h4(62))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(128),-2,0,G2H8(16),n2h8(70))
  call Hloop_QA_Z(ntryL,G2H8(16),ex2(:),G2H4(120),ngZl,m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_AV_Q(ntryL,G1H8(131),ex5(:),G1H4(3),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(121),n2h4(63))
  call Hloop_AV_Q(ntryL,G1H8(132),ex5(:),G1H4(3),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(3),57,0,G2H4(122),n2h4(64))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(11),mass5set(:,3),  & 
G1H4(3),G1H4(4),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(4),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(11),mass5set(:,4),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(10),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(11),mass5set(:,5),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(11),mass5set(:,6),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(12),mass5set(:,3),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(12),mass5set(:,5),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(12),mass5set(:,4),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),16,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(12),mass5set(:,6),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(46),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(13),mass5set(:,3),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(52),16,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(13),mass5set(:,5),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),16,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(13),mass5set(:,4),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(64),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(13),mass5set(:,6),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(70),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(14),mass5set(:,3),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(76),16,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(14),mass5set(:,4),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(14),mass5set(:,5),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(14),mass5set(:,6),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(94),16,4)
  call Hloop_QA_W(ntryL,G2H4(17),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_W(ntryL,G2H4(18),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_W(ntryL,G2H4(19),ex1(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_W(ntryL,G2H4(20),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(15),mass5set(:,3),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),G1H4(104),4)
  call HG1shiftOLR(G1H4(100),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(15),mass5set(:,4),  & 
G1H4(105),G1H4(106),G1H4(107),G1H4(108),G1H4(109),G1H4(110),4)
  call HG1shiftOLR(G1H4(106),16,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(15),mass5set(:,5),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(115),G1H4(116),4)
  call HG1shiftOLR(G1H4(112),16,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(15),mass5set(:,6),  & 
G1H4(117),G1H4(118),G1H4(119),G1H4(120),G1H4(121),G1H4(122),4)
  call HG1shiftOLR(G1H4(118),16,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(16),mass5set(:,3),  & 
G1H4(123),G1H4(124),G1H4(125),G1H4(126),G1H4(127),G1H4(128),4)
  call HG1shiftOLR(G1H4(124),16,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(16),mass5set(:,5),  & 
G1H4(129),G1H4(130),G1H4(131),G1H4(132),G1H4(133),G1H4(134),4)
  call HG1shiftOLR(G1H4(130),16,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(16),mass5set(:,4),  & 
G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),G1H4(140),4)
  call HG1shiftOLR(G1H4(136),16,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(16),mass5set(:,6),  & 
G1H4(141),G1H4(142),G1H4(143),G1H4(144),G1H4(145),G1H4(146),4)
  call HG1shiftOLR(G1H4(142),16,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(17),mass5set(:,3),  & 
G1H4(147),G1H4(148),G1H4(149),G1H4(150),G1H4(151),G1H4(152),4)
  call HG1shiftOLR(G1H4(148),16,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(17),mass5set(:,4),  & 
G1H4(153),G1H4(154),G1H4(155),G1H4(156),G1H4(157),G1H4(158),4)
  call HG1shiftOLR(G1H4(154),16,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(17),mass5set(:,5),  & 
G1H4(159),G1H4(160),G1H4(161),G1H4(162),G1H4(163),G1H4(164),4)
  call HG1shiftOLR(G1H4(160),16,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(17),mass5set(:,6),  & 
G1H4(165),G1H4(166),G1H4(167),G1H4(168),G1H4(169),G1H4(170),4)
  call HG1shiftOLR(G1H4(166),16,4)
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(18),mass5set(:,3),  & 
G1H4(171),G1H4(172),G1H4(173),G1H4(174),G1H4(175),G1H4(176),4)
  call HG1shiftOLR(G1H4(172),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(18),mass5set(:,5),  & 
G1H4(177),G1H4(178),G1H4(179),G1H4(180),G1H4(181),G1H4(182),4)
  call HG1shiftOLR(G1H4(178),16,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(18),mass5set(:,4),  & 
G1H4(183),G1H4(184),G1H4(185),G1H4(186),G1H4(187),G1H4(188),4)
  call HG1shiftOLR(G1H4(184),16,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(18),mass5set(:,6),  & 
G1H4(189),G1H4(190),G1H4(191),G1H4(192),G1H4(193),G1H4(194),4)
  call HG1shiftOLR(G1H4(190),16,4)
  call Hloop_QA_W(ntryL,G2H4(37),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_W(ntryL,G2H4(40),ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_W(ntryL,G2H4(41),ex3(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_W(ntryL,G2H4(44),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_W(ntryL,G2H4(45),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_W(ntryL,G2H4(48),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(4),mass5set(:,2),  & 
G1H4(195),G1H4(196),G1H4(197),G1H4(198),G1H4(199),G1H4(200),4)
  call HG1shiftOLR(G1H4(196),4,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(19),mass5set(:,1),  & 
G1H4(201),G1H4(202),G1H4(203),G1H4(204),G1H4(205),G1H4(206),4)
  call HG1shiftOLR(G1H4(202),4,4)
  call Hloop_QA_W(ntryL,G2H4(52),ex4(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_W(ntryL,G2H4(55),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(6),mass5set(:,2),  & 
G1H4(207),G1H4(208),G1H4(209),G1H4(210),G1H4(211),G1H4(212),4)
  call HG1shiftOLR(G1H4(208),8,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(20),mass5set(:,1),  & 
G1H4(213),G1H4(214),G1H4(215),G1H4(216),G1H4(217),G1H4(218),4)
  call HG1shiftOLR(G1H4(214),8,4)
  call Hloop_QA_V(ntryL,G2H4(59),ex2(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(62),ex2(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_Z(ntryL,G2H4(63),ex2(:),G2H2(15),ngZl,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_Z(ntryL,G2H4(66),ex2(:),G2H2(16),ngZl,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(67),ex2(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(70),ex2(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_Z(ntryL,G2H4(71),ex2(:),G2H2(19),ngZl,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_Z(ntryL,G2H4(74),ex2(:),G2H2(20),ngZl,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_V(ntryL,G2H4(75),ex4(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_V(ntryL,G2H4(78),ex4(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_Z(ntryL,G2H4(79),ex4(:),G2H2(23),ngZl,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_Z(ntryL,G2H4(82),ex4(:),G2H2(24),ngZl,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(83),ex4(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(86),ex4(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_Z(ntryL,G2H4(87),ex4(:),G2H2(27),ngZl,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_Z(ntryL,G2H4(90),ex4(:),G2H2(28),ngZl,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AQ_V(ntryL,G2H4(91),ex1(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_AQ_V(ntryL,G2H4(94),ex1(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_AQ_V(ntryL,G2H4(95),ex1(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_AQ_V(ntryL,G2H4(98),ex1(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_Z(ntryL,G2H4(99),ex1(:),G2H2(33),ngZl,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_Z(ntryL,G2H4(102),ex1(:),G2H2(34),ngZl,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_Z(ntryL,G2H4(103),ex1(:),G2H2(35),ngZl,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_Z(ntryL,G2H4(106),ex1(:),G2H2(36),ngZl,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_V(ntryL,G2H4(107),ex3(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_V(ntryL,G2H4(110),ex3(:),G2H2(38),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_Z(ntryL,G2H4(111),ex3(:),G2H2(39),ngZl,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_Z(ntryL,G2H4(114),ex3(:),G2H2(40),ngZl,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_AQ_V(ntryL,G2H4(115),ex3(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_V(ntryL,G2H4(118),ex3(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AQ_Z(ntryL,G2H4(119),ex3(:),G2H2(43),ngZl,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_Z(ntryL,G2H4(122),ex3(:),G2H2(44),ngZl,m3h2x2(:,44),heltab2x4(:,:,44))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(201),[G1H4(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(213),[G1H4(212)])
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(45),n2h2(1))
call HGT_OLR(G1H4(4),1,1,4)
call HGT_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(4),-16,0,G2H4(1),n2h4(65))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(47),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(9),ex3(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(48),n2h2(3))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(10),-16,0,G2H4(2),n2h4(66))
  call Hloop_AV_Q(ntryL,G2H4(2),ex5(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_VQ_A(ntryL,G1H4(14),ex3(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(50),n2h2(4))
  call Hloop_ZQ_A(ntryL,G1H4(15),ex3(:),G1H2(1),ngZl,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(51),n2h2(5))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(16),-16,0,G2H4(3),n2h4(67))
  call Hloop_AV_Q(ntryL,G2H4(3),ex5(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_ZQ_A(ntryL,G1H4(20),ex3(:),G1H2(1),ngZl,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(53),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(21),ex3(:),G1H2(1),ngZl,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(54),n2h2(7))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(22),-16,0,G2H4(4),n2h4(68))
  call Hloop_AV_Q(ntryL,G2H4(4),ex5(:),G2H2(55),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_ZQ_A(ntryL,G1H4(26),ex3(:),G1H2(1),ngZl,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(56),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(27),ex4(:),G1H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(57),n2h2(9))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(28),-16,0,G2H4(5),n2h4(69))
  call Hloop_QV_A(ntryL,G2H4(5),ex5(:),G2H2(58),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_VA_Q(ntryL,G1H4(32),ex4(:),G1H2(1),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(59),n2h2(10))
  call Hloop_ZA_Q(ntryL,G1H4(33),ex4(:),G1H2(1),ngZl,m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(60),n2h2(11))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(34),-16,0,G2H4(6),n2h4(70))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_ZA_Q(ntryL,G1H4(38),ex4(:),G1H2(1),ngZl,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(62),n2h2(12))
  call Hloop_VA_Q(ntryL,G1H4(39),ex4(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(63),n2h2(13))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(40),-16,0,G2H4(7),n2h4(71))
  call Hloop_QV_A(ntryL,G2H4(7),ex5(:),G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_VA_Q(ntryL,G1H4(44),ex4(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(65),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(45),ex4(:),G1H2(1),ngZl,m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(66),n2h2(15))
call HGT_OLR(G1H4(46),1,1,4)
call HGT_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(46),-16,0,G2H4(8),n2h4(72))
  call Hloop_QV_A(ntryL,G2H4(8),ex5(:),G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_ZA_Q(ntryL,G1H4(50),ex4(:),G1H2(1),ngZl,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(68),n2h2(16))
  call Hloop_VQ_A(ntryL,G1H4(51),ex3(:),G1H2(1),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(69),n2h2(17))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(52),-16,0,G2H4(9),n2h4(73))
  call Hloop_AV_Q(ntryL,G2H4(9),ex5(:),G2H2(70),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_VQ_A(ntryL,G1H4(56),ex3(:),G1H2(1),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(71),n2h2(18))
  call Hloop_ZQ_A(ntryL,G1H4(57),ex3(:),G1H2(1),ngZl,m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(72),n2h2(19))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(58),-16,0,G2H4(10),n2h4(74))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(73),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_ZQ_A(ntryL,G1H4(62),ex3(:),G1H2(1),ngZl,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(74),n2h2(20))
  call Hloop_VQ_A(ntryL,G1H4(63),ex3(:),G1H2(1),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(75),n2h2(21))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(64),-16,0,G2H4(11),n2h4(75))
  call Hloop_AV_Q(ntryL,G2H4(11),ex5(:),G2H2(76),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_VQ_A(ntryL,G1H4(68),ex3(:),G1H2(1),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(77),n2h2(22))
  call Hloop_ZQ_A(ntryL,G1H4(69),ex3(:),G1H2(1),ngZl,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(78),n2h2(23))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(70),-16,0,G2H4(12),n2h4(76))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_ZQ_A(ntryL,G1H4(74),ex3(:),G1H2(1),ngZl,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(80),n2h2(24))
  call Hloop_VA_Q(ntryL,G1H4(75),ex4(:),G1H2(1),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(81),n2h2(25))
call HGT_OLR(G1H4(76),1,1,4)
call HGT_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(76),-16,0,G2H4(13),n2h4(77))
  call Hloop_QV_A(ntryL,G2H4(13),ex5(:),G2H2(82),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_VA_Q(ntryL,G1H4(80),ex4(:),G1H2(1),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(83),n2h2(26))
  call Hloop_VA_Q(ntryL,G1H4(81),ex4(:),G1H2(1),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(84),n2h2(27))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(82),-16,0,G2H4(14),n2h4(78))
  call Hloop_QV_A(ntryL,G2H4(14),ex5(:),G2H2(85),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_VA_Q(ntryL,G1H4(86),ex4(:),G1H2(1),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(86),n2h2(28))
  call Hloop_ZA_Q(ntryL,G1H4(87),ex4(:),G1H2(1),ngZl,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(87),n2h2(29))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(88),-16,0,G2H4(15),n2h4(79))
  call Hloop_QV_A(ntryL,G2H4(15),ex5(:),G2H2(88),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_ZA_Q(ntryL,G1H4(92),ex4(:),G1H2(1),ngZl,m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(89),n2h2(30))
  call Hloop_ZA_Q(ntryL,G1H4(93),ex4(:),G1H2(1),ngZl,m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(90),n2h2(31))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(94),-16,0,G2H4(16),n2h4(80))
  call Hloop_QV_A(ntryL,G2H4(16),ex5(:),G2H2(91),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_ZA_Q(ntryL,G1H4(98),ex4(:),G1H2(1),ngZl,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(92),n2h2(32))
  call Hloop_VQ_A(ntryL,G1H4(99),ex1(:),G1H2(1),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(93),n2h2(33))
call HGT_OLR(G1H4(100),1,1,4)
call HGT_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(100),-16,0,G2H4(17),n2h4(81))
  call Hloop_AV_Q(ntryL,G2H4(17),ex5(:),G2H2(94),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_VQ_A(ntryL,G1H4(104),ex1(:),G1H2(1),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(95),n2h2(34))
  call Hloop_VQ_A(ntryL,G1H4(105),ex1(:),G1H2(1),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(96),n2h2(35))
call HGT_OLR(G1H4(106),1,1,4)
call HGT_invQ_OLR(G1H4(106),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(106),-16,0,G2H4(18),n2h4(82))
  call Hloop_AV_Q(ntryL,G2H4(18),ex5(:),G2H2(97),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_VQ_A(ntryL,G1H4(110),ex1(:),G1H2(1),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(98),n2h2(36))
  call Hloop_ZQ_A(ntryL,G1H4(111),ex1(:),G1H2(1),ngZl,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(99),n2h2(37))
call HGT_OLR(G1H4(112),1,1,4)
call HGT_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(112),-16,0,G2H4(19),n2h4(83))
  call Hloop_AV_Q(ntryL,G2H4(19),ex5(:),G2H2(100),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_ZQ_A(ntryL,G1H4(116),ex1(:),G1H2(1),ngZl,m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(101),n2h2(38))
  call Hloop_ZQ_A(ntryL,G1H4(117),ex1(:),G1H2(1),ngZl,m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(102),n2h2(39))
call HGT_OLR(G1H4(118),1,1,4)
call HGT_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(118),-16,0,G2H4(20),n2h4(84))
  call Hloop_AV_Q(ntryL,G2H4(20),ex5(:),G2H2(103),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_ZQ_A(ntryL,G1H4(122),ex1(:),G1H2(1),ngZl,m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(104),n2h2(40))
  call Hloop_VA_Q(ntryL,G1H4(123),ex2(:),G1H2(1),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(105),n2h2(41))
call HGT_OLR(G1H4(124),1,1,4)
call HGT_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(124),-16,0,G2H4(21),n2h4(85))
  call Hloop_QV_A(ntryL,G2H4(21),ex5(:),G2H2(106),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_VA_Q(ntryL,G1H4(128),ex2(:),G1H2(1),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(107),n2h2(42))
  call Hloop_ZA_Q(ntryL,G1H4(129),ex2(:),G1H2(1),ngZl,m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(108),n2h2(43))
call HGT_OLR(G1H4(130),1,1,4)
call HGT_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(130),-16,0,G2H4(22),n2h4(86))
  call Hloop_QV_A(ntryL,G2H4(22),ex5(:),G2H2(109),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_ZA_Q(ntryL,G1H4(134),ex2(:),G1H2(1),ngZl,m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(110),n2h2(44))
  call Hloop_VA_Q(ntryL,G1H4(135),ex2(:),G1H2(1),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(111),n2h2(45))
call HGT_OLR(G1H4(136),1,1,4)
call HGT_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(136),-16,0,G2H4(23),n2h4(87))
  call Hloop_QV_A(ntryL,G2H4(23),ex5(:),G2H2(112),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_VA_Q(ntryL,G1H4(140),ex2(:),G1H2(1),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(113),n2h2(46))
  call Hloop_ZA_Q(ntryL,G1H4(141),ex2(:),G1H2(1),ngZl,m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(114),n2h2(47))
call HGT_OLR(G1H4(142),1,1,4)
call HGT_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(142),-16,0,G2H4(24),n2h4(88))
  call Hloop_QV_A(ntryL,G2H4(24),ex5(:),G2H2(115),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_ZA_Q(ntryL,G1H4(146),ex2(:),G1H2(1),ngZl,m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(116),n2h2(48))
  call Hloop_VQ_A(ntryL,G1H4(147),ex1(:),G1H2(1),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(117),n2h2(49))
call HGT_OLR(G1H4(148),1,1,4)
call HGT_invQ_OLR(G1H4(148),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(148),-16,0,G2H4(25),n2h4(89))
  call Hloop_AV_Q(ntryL,G2H4(25),ex5(:),G2H2(118),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_VQ_A(ntryL,G1H4(152),ex1(:),G1H2(1),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(119),n2h2(50))
  call Hloop_VQ_A(ntryL,G1H4(153),ex1(:),G1H2(1),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(120),n2h2(51))
call HGT_OLR(G1H4(154),1,1,4)
call HGT_invQ_OLR(G1H4(154),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(154),-16,0,G2H4(26),n2h4(90))
  call Hloop_AV_Q(ntryL,G2H4(26),ex5(:),G2H2(121),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_VQ_A(ntryL,G1H4(158),ex1(:),G1H2(1),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(122),n2h2(52))
  call Hloop_ZQ_A(ntryL,G1H4(159),ex1(:),G1H2(1),ngZl,m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(123),n2h2(53))
call HGT_OLR(G1H4(160),1,1,4)
call HGT_invQ_OLR(G1H4(160),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(160),-16,0,G2H4(27),n2h4(91))
  call Hloop_AV_Q(ntryL,G2H4(27),ex5(:),G2H2(124),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_ZQ_A(ntryL,G1H4(164),ex1(:),G1H2(1),ngZl,m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(125),n2h2(54))
  call Hloop_ZQ_A(ntryL,G1H4(165),ex1(:),G1H2(1),ngZl,m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(126),n2h2(55))
call HGT_OLR(G1H4(166),1,1,4)
call HGT_invQ_OLR(G1H4(166),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(166),-16,0,G2H4(28),n2h4(92))
  call Hloop_AV_Q(ntryL,G2H4(28),ex5(:),G2H2(127),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_ZQ_A(ntryL,G1H4(170),ex1(:),G1H2(1),ngZl,m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(128),n2h2(56))
  call Hloop_VA_Q(ntryL,G1H4(171),ex2(:),G1H2(1),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(129),n2h2(57))
call HGT_OLR(G1H4(172),1,1,4)
call HGT_invQ_OLR(G1H4(172),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(172),-16,0,G2H4(29),n2h4(93))
  call Hloop_QV_A(ntryL,G2H4(29),ex5(:),G2H2(130),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_VA_Q(ntryL,G1H4(176),ex2(:),G1H2(1),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(131),n2h2(58))
  call Hloop_ZA_Q(ntryL,G1H4(177),ex2(:),G1H2(1),ngZl,m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(132),n2h2(59))
call HGT_OLR(G1H4(178),1,1,4)
call HGT_invQ_OLR(G1H4(178),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(178),-16,0,G2H4(30),n2h4(94))
  call Hloop_QV_A(ntryL,G2H4(30),ex5(:),G2H2(133),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_ZA_Q(ntryL,G1H4(182),ex2(:),G1H2(1),ngZl,m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(134),n2h2(60))
  call Hloop_VA_Q(ntryL,G1H4(183),ex2(:),G1H2(1),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(135),n2h2(61))
call HGT_OLR(G1H4(184),1,1,4)
call HGT_invQ_OLR(G1H4(184),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(184),-16,0,G2H4(31),n2h4(95))
  call Hloop_QV_A(ntryL,G2H4(31),ex5(:),G2H2(136),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_VA_Q(ntryL,G1H4(188),ex2(:),G1H2(1),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(137),n2h2(62))
  call Hloop_ZA_Q(ntryL,G1H4(189),ex2(:),G1H2(1),ngZl,m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(138),n2h2(63))
call HGT_OLR(G1H4(190),1,1,4)
call HGT_invQ_OLR(G1H4(190),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(190),-16,0,G2H4(32),n2h4(96))
  call Hloop_QV_A(ntryL,G2H4(32),ex5(:),G2H2(139),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_ZA_Q(ntryL,G1H4(194),ex2(:),G1H2(1),ngZl,m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(140),n2h2(64))
  call Hloop_WA_Q(ntryL,G1H4(195),ex4(:),G1H2(1),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(141),n2h2(65))
call HGT_raise_alpha_OLR(G1H4(196),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(196),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(196),ex3(:),G1H2(1),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_WA_Q(ntryL,G1H4(201),ex4(:),G1H2(2),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(2),59,0,G2H2(142),n2h2(66))
call HGT_raise_alpha_OLR(G1H4(202),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(202),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(202),ex3(:),G1H2(2),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_WA_Q(ntryL,G1H4(206),ex4(:),G1H2(3),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(143),n2h2(67))
  call Hloop_WQ_A(ntryL,G1H4(207),ex3(:),G1H2(3),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(144),n2h2(68))
call HGT_raise_alpha_OLR(G1H4(208),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(208),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(208),ex4(:),G1H2(3),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_WQ_A(ntryL,G1H4(213),ex3(:),G1H2(4),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(4),55,0,G2H2(145),n2h2(69))
call HGT_raise_alpha_OLR(G1H4(214),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(214),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(214),ex4(:),G1H2(4),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_WQ_A(ntryL,G1H4(218),ex3(:),G1H2(5),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(146),n2h2(70))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(4),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(1),mass5set(:,1),  & 
G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
  call HG1shiftOLR(G1H2(6),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(2),mass5set(:,1),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),2)
  call HG1shiftOLR(G1H2(12),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(3),mass5set(:,1),  & 
G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(18),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(5),mass5set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(7),mass5set(:,3),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(7),mass5set(:,3),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(36),8,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(7),mass5set(:,4),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(42),8,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(7),mass5set(:,4),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(48),8,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(8),mass5set(:,3),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(54),2,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(8),mass5set(:,3),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(60),2,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(8),mass5set(:,4),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),G1H2(70),2)
  call HG1shiftOLR(G1H2(66),2,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(8),mass5set(:,4),  & 
G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(72),2,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(9),mass5set(:,3),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(78),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(9),mass5set(:,4),  & 
G1H2(83),G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(84),8,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(9),mass5set(:,3),  & 
G1H2(89),G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),2)
  call HG1shiftOLR(G1H2(90),8,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(9),mass5set(:,4),  & 
G1H2(95),G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(96),8,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(10),mass5set(:,3),  & 
G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(102),2,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(10),mass5set(:,3),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),G1H2(112),2)
  call HG1shiftOLR(G1H2(108),2,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(10),mass5set(:,4),  & 
G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),G1H2(118),2)
  call HG1shiftOLR(G1H2(114),2,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(10),mass5set(:,4),  & 
G1H2(119),G1H2(120),G1H2(121),G1H2(122),G1H2(123),G1H2(124),2)
  call HG1shiftOLR(G1H2(120),2,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(11),mass5set(:,3),  & 
G1H2(125),G1H2(126),G1H2(127),G1H2(128),G1H2(129),G1H2(130),2)
  call HG1shiftOLR(G1H2(126),16,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(11),mass5set(:,4),  & 
G1H2(131),G1H2(132),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(132),16,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(11),mass5set(:,5),  & 
G1H2(137),G1H2(138),G1H2(139),G1H2(140),G1H2(141),G1H2(142),2)
  call HG1shiftOLR(G1H2(138),16,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(11),mass5set(:,6),  & 
G1H2(143),G1H2(144),G1H2(145),G1H2(146),G1H2(147),G1H2(148),2)
  call HG1shiftOLR(G1H2(144),16,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(12),mass5set(:,3),  & 
G1H2(149),G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),2)
  call HG1shiftOLR(G1H2(150),16,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(12),mass5set(:,5),  & 
G1H2(155),G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(156),16,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(12),mass5set(:,4),  & 
G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(162),16,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(12),mass5set(:,6),  & 
G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),G1H2(172),2)
  call HG1shiftOLR(G1H2(168),16,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(13),mass5set(:,3),  & 
G1H2(173),G1H2(174),G1H2(175),G1H2(176),G1H2(177),G1H2(178),2)
  call HG1shiftOLR(G1H2(174),16,2)
  call Hotf_5pt_reduction(G2H2(72),RedSet_5(13),mass5set(:,5),  & 
G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(183),G1H2(184),2)
  call HG1shiftOLR(G1H2(180),16,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(13),mass5set(:,4),  & 
G1H2(185),G1H2(186),G1H2(187),G1H2(188),G1H2(189),G1H2(190),2)
  call HG1shiftOLR(G1H2(186),16,2)
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(13),mass5set(:,6),  & 
G1H2(191),G1H2(192),G1H2(193),G1H2(194),G1H2(195),G1H2(196),2)
  call HG1shiftOLR(G1H2(192),16,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(14),mass5set(:,3),  & 
G1H2(197),G1H2(198),G1H2(199),G1H2(200),G1H2(201),G1H2(202),2)
  call HG1shiftOLR(G1H2(198),16,2)
  call Hotf_5pt_reduction(G2H2(84),RedSet_5(14),mass5set(:,4),  & 
G1H2(203),G1H2(204),G1H2(205),G1H2(206),G1H2(207),G1H2(208),2)
  call HG1shiftOLR(G1H2(204),16,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(14),mass5set(:,5),  & 
G1H2(209),G1H2(210),G1H2(211),G1H2(212),G1H2(213),G1H2(214),2)
  call HG1shiftOLR(G1H2(210),16,2)
  call Hotf_5pt_reduction(G2H2(90),RedSet_5(14),mass5set(:,6),  & 
G1H2(215),G1H2(216),G1H2(217),G1H2(218),G1H2(219),G1H2(220),2)
  call HG1shiftOLR(G1H2(216),16,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(15),mass5set(:,3),  & 
G1H2(221),G1H2(222),G1H2(223),G1H2(224),G1H2(225),G1H2(226),2)
  call HG1shiftOLR(G1H2(222),16,2)
  call Hotf_5pt_reduction(G2H2(96),RedSet_5(15),mass5set(:,4),  & 
G1H2(227),G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(228),16,2)
  call Hotf_5pt_reduction(G2H2(99),RedSet_5(15),mass5set(:,5),  & 
G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),2)
  call HG1shiftOLR(G1H2(234),16,2)
  call Hotf_5pt_reduction(G2H2(102),RedSet_5(15),mass5set(:,6),  & 
G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(240),16,2)
  call Hotf_5pt_reduction(G2H2(105),RedSet_5(16),mass5set(:,3),  & 
G1H2(245),G1H2(246),G1H2(247),G1H2(248),G1H2(249),G1H2(250),2)
  call HG1shiftOLR(G1H2(246),16,2)
  call Hotf_5pt_reduction(G2H2(108),RedSet_5(16),mass5set(:,5),  & 
G1H2(251),G1H2(252),G1H2(253),G1H2(254),G1H2(255),G1H2(256),2)
  call HG1shiftOLR(G1H2(252),16,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(16),mass5set(:,4),  & 
G1H2(257),G1H2(258),G1H2(259),G1H2(260),G1H2(261),G1H2(262),2)
  call HG1shiftOLR(G1H2(258),16,2)
  call Hotf_5pt_reduction(G2H2(114),RedSet_5(16),mass5set(:,6),  & 
G1H2(263),G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),2)
  call HG1shiftOLR(G1H2(264),16,2)
  call Hotf_5pt_reduction(G2H2(117),RedSet_5(17),mass5set(:,3),  & 
G1H2(269),G1H2(270),G1H2(271),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(270),16,2)
  call Hotf_5pt_reduction(G2H2(120),RedSet_5(17),mass5set(:,4),  & 
G1H2(275),G1H2(276),G1H2(277),G1H2(278),G1H2(279),G1H2(280),2)
  call HG1shiftOLR(G1H2(276),16,2)
  call Hotf_5pt_reduction(G2H2(123),RedSet_5(17),mass5set(:,5),  & 
G1H2(281),G1H2(282),G1H2(283),G1H2(284),G1H2(285),G1H2(286),2)
  call HG1shiftOLR(G1H2(282),16,2)
  call Hotf_5pt_reduction(G2H2(126),RedSet_5(17),mass5set(:,6),  & 
G1H2(287),G1H2(288),G1H2(289),G1H2(290),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(288),16,2)
  call Hotf_5pt_reduction(G2H2(129),RedSet_5(18),mass5set(:,3),  & 
G1H2(293),G1H2(294),G1H2(295),G1H2(296),G1H2(297),G1H2(298),2)
  call HG1shiftOLR(G1H2(294),16,2)
  call Hotf_5pt_reduction(G2H2(132),RedSet_5(18),mass5set(:,5),  & 
G1H2(299),G1H2(300),G1H2(301),G1H2(302),G1H2(303),G1H2(304),2)
  call HG1shiftOLR(G1H2(300),16,2)
  call Hotf_5pt_reduction(G2H2(135),RedSet_5(18),mass5set(:,4),  & 
G1H2(305),G1H2(306),G1H2(307),G1H2(308),G1H2(309),G1H2(310),2)
  call HG1shiftOLR(G1H2(306),16,2)
  call Hotf_5pt_reduction(G2H2(138),RedSet_5(18),mass5set(:,6),  & 
G1H2(311),G1H2(312),G1H2(313),G1H2(314),G1H2(315),G1H2(316),2)
  call HG1shiftOLR(G1H2(312),16,2)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(141),ex3(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(144),ex4(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(5),47,ex5(:),16,G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(6),0,ex5(:),16,G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(11),47,ex5(:),16,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(12),0,ex5(:),16,G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(17),47,ex5(:),16,G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(18),0,ex5(:),16,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(23),47,ex5(:),16,G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(24),0,ex5(:),16,G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hloop_VA_Q(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(16),n2h1(6))
  call Hloop_ZA_Q(ntryL,G1H2(35),ex4(:),G1H1(1),ngZl,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(7))
  call Hloop_ZA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),ngZl,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(18),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(20),n2h1(10))
  call Hloop_ZA_Q(ntryL,G1H2(47),ex4(:),G1H1(1),ngZl,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(11))
  call Hloop_ZA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),ngZl,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(22),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(53),ex2(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(54),ex2(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(24),n2h1(14))
  call Hloop_ZA_Q(ntryL,G1H2(59),ex2(:),G1H1(1),ngZl,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(15))
  call Hloop_ZA_Q(ntryL,G1H2(60),ex2(:),G1H1(1),ngZl,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(26),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(65),ex2(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(66),ex2(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(28),n2h1(18))
  call Hloop_ZA_Q(ntryL,G1H2(71),ex2(:),G1H1(1),ngZl,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(19))
  call Hloop_ZA_Q(ntryL,G1H2(72),ex2(:),G1H1(1),ngZl,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(30),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(32),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H2(83),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(34),n2h1(24))
  call Hloop_ZA_Q(ntryL,G1H2(89),ex4(:),G1H1(1),ngZl,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(25))
  call Hloop_ZA_Q(ntryL,G1H2(90),ex4(:),G1H1(1),ngZl,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(36),n2h1(26))
  call Hloop_ZA_Q(ntryL,G1H2(95),ex4(:),G1H1(1),ngZl,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(27))
  call Hloop_ZA_Q(ntryL,G1H2(96),ex4(:),G1H1(1),ngZl,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(38),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(101),ex2(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(102),ex2(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(40),n2h1(30))
  call Hloop_ZA_Q(ntryL,G1H2(107),ex2(:),G1H1(1),ngZl,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(31))
  call Hloop_ZA_Q(ntryL,G1H2(108),ex2(:),G1H1(1),ngZl,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(42),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(113),ex2(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(114),ex2(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(44),n2h1(34))
  call Hloop_ZA_Q(ntryL,G1H2(119),ex2(:),G1H1(1),ngZl,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(35))
  call Hloop_ZA_Q(ntryL,G1H2(120),ex2(:),G1H1(1),ngZl,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(46),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(125),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(126),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(48),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(131),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(132),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(50),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(137),ex5(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(138),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(52),n2h1(42))
  call Hloop_QV_A(ntryL,G1H2(143),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(144),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(54),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H2(149),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H2(150),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(56),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(155),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(156),ex5(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(58),n2h1(48))
  call Hloop_AV_Q(ntryL,G1H2(161),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(49))
  call Hloop_AV_Q(ntryL,G1H2(162),ex5(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(60),n2h1(50))
  call Hloop_AV_Q(ntryL,G1H2(167),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H2(168),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(62),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(173),ex5(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(174),ex5(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(64),n2h1(54))
  call Hloop_QV_A(ntryL,G1H2(179),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(55))
  call Hloop_QV_A(ntryL,G1H2(180),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(66),n2h1(56))
  call Hloop_QV_A(ntryL,G1H2(185),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(57))
  call Hloop_QV_A(ntryL,G1H2(186),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(68),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(191),ex5(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(192),ex5(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(70),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H2(197),ex5(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(198),ex5(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(72),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(203),ex5(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(204),ex5(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(74),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H2(209),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(210),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(76),n2h1(66))
  call Hloop_AV_Q(ntryL,G1H2(215),ex5(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(67))
  call Hloop_AV_Q(ntryL,G1H2(216),ex5(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(78),n2h1(68))
  call Hloop_QV_A(ntryL,G1H2(221),ex5(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(69))
  call Hloop_QV_A(ntryL,G1H2(222),ex5(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(80),n2h1(70))
  call Hloop_QV_A(ntryL,G1H2(227),ex5(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(71))
  call Hloop_QV_A(ntryL,G1H2(228),ex5(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(82),n2h1(72))
  call Hloop_QV_A(ntryL,G1H2(233),ex5(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(73))
  call Hloop_QV_A(ntryL,G1H2(234),ex5(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(84),n2h1(74))
  call Hloop_QV_A(ntryL,G1H2(239),ex5(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(75))
  call Hloop_QV_A(ntryL,G1H2(240),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(86),n2h1(76))
  call Hloop_AV_Q(ntryL,G1H2(245),ex5(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(246),ex5(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(88),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(251),ex5(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(252),ex5(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(90),n2h1(80))
  call Hloop_AV_Q(ntryL,G1H2(257),ex5(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(81))
  call Hloop_AV_Q(ntryL,G1H2(258),ex5(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(92),n2h1(82))
  call Hloop_AV_Q(ntryL,G1H2(263),ex5(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(83))
  call Hloop_AV_Q(ntryL,G1H2(264),ex5(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(94),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(269),ex5(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(270),ex5(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(96),n2h1(86))
  call Hloop_QV_A(ntryL,G1H2(275),ex5(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(87))
  call Hloop_QV_A(ntryL,G1H2(276),ex5(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(98),n2h1(88))
  call Hloop_QV_A(ntryL,G1H2(281),ex5(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(89))
  call Hloop_QV_A(ntryL,G1H2(282),ex5(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(100),n2h1(90))
  call Hloop_QV_A(ntryL,G1H2(287),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(91))
  call Hloop_QV_A(ntryL,G1H2(288),ex5(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(102),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(293),ex5(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(294),ex5(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(104),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H2(299),ex5(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(95))
  call Hloop_AV_Q(ntryL,G1H2(300),ex5(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(106),n2h1(96))
  call Hloop_AV_Q(ntryL,G1H2(305),ex5(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(97))
  call Hloop_AV_Q(ntryL,G1H2(306),ex5(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(108),n2h1(98))
  call Hloop_AV_Q(ntryL,G1H2(311),ex5(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H2(312),ex5(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(110),n2h1(100))
  call ol_merge_tensors(G2tensor(7),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(4)])
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(4),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),4)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(6),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(7),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(7),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(7),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(8),mass5set(:,3),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),2)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),2)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(8),mass5set(:,4),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(8),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),2)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(9),mass5set(:,3),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(9),mass5set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(9),mass5set(:,3),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(9),mass5set(:,4),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(10),mass5set(:,3),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),2)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(10),mass5set(:,3),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),2)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(10),mass5set(:,4),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),2)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(10),mass5set(:,4),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),2)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(11),mass5set(:,3),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(11),mass5set(:,4),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(11),mass5set(:,5),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(11),mass5set(:,6),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(12),mass5set(:,3),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(12),mass5set(:,5),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(12),mass5set(:,4),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(12),mass5set(:,6),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(13),mass5set(:,3),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(13),mass5set(:,5),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(13),mass5set(:,4),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(13),mass5set(:,6),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(14),mass5set(:,3),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(14),mass5set(:,4),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(14),mass5set(:,5),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(14),mass5set(:,6),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(15),mass5set(:,3),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(15),mass5set(:,4),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(15),mass5set(:,5),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(15),mass5set(:,6),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(16),mass5set(:,3),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(16),mass5set(:,5),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),16)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(16),mass5set(:,4),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(16),mass5set(:,6),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(17),mass5set(:,3),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(17),mass5set(:,4),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(17),mass5set(:,5),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),16)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(17),mass5set(:,6),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),16)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(18),mass5set(:,3),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),16)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(18),mass5set(:,5),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),16)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(18),mass5set(:,4),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),16)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(18),mass5set(:,6),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  call ol_merge_tensors(T1sum(45),[G1tensor(265)])
  call ol_merge_tensors(T1sum(46),[G1tensor(271)])
  call ol_merge_tensors(T1sum(47),[G1tensor(277)])
  call ol_merge_tensors(T1sum(48),[G1tensor(283)])
  call ol_merge_tensors(T1sum(49),[G1tensor(289)])
  call ol_merge_tensors(T1sum(50),[G1tensor(295)])
  call ol_merge_tensors(T1sum(51),[G1tensor(301)])
  call ol_merge_tensors(T1sum(52),[G1tensor(307)])
  call ol_merge_tensors(T1sum(53),[G1tensor(313)])
  call ol_merge_tensors(T1sum(54),[G1tensor(319)])
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[48,2,1,8,4],[nMW,0,nMW,0,nMW],6,0)
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(1),m4h2x2x16(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[48,1,2,4,8],[nMW,0,nMW,0,nMW],6,0)
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(2),m4h2x2x16(:,2),heltab3x64(:,:,2))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(1),n2h32(49))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,3,16,4,8],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(50))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(3),n2h32(51))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,3,16,4,8],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(4),n2h32(52))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(5),m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,68),heltab2x64(:,:,68))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,69),heltab2x64(:,:,69))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,70),heltab2x64(:,:,70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,71),heltab2x64(:,:,71))
  call Hloop_Q_A(ntryL,G0H32(3),32,0,G1H32(9),n2h32(53))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,3,8,4,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,72),heltab2x64(:,:,72))
  call Hloop_Q_A(ntryL,G0H32(3),32,0,G1H32(10),n2h32(54))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G0H32(3),32,0,G1H32(11),n2h32(55))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,3,8,4,16],[0,0,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G0H32(3),32,0,G1H32(12),n2h32(56))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(13),m3h2x32(:,75),heltab2x64(:,:,75))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(14),m3h2x32(:,76),heltab2x64(:,:,76))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,77),heltab2x64(:,:,77))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,78),heltab2x64(:,:,78))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,79),heltab2x64(:,:,79))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,80),heltab2x64(:,:,80))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(15),m3h2x32(:,81),heltab2x64(:,:,81))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(16),m3h2x32(:,82),heltab2x64(:,:,82))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,83),heltab2x64(:,:,83))
  call Hloop_Q_A(ntryL,G0H32(9),32,0,G1H32(17),n2h32(57))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,3,16,8,4],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,84),heltab2x64(:,:,84))
  call Hloop_Q_A(ntryL,G0H32(9),32,0,G1H32(18),n2h32(58))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,85),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G0H32(9),32,0,G1H32(19),n2h32(59))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,3,16,8,4],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G0H32(9),32,0,G1H32(20),n2h32(60))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,87),heltab2x64(:,:,87))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,88),heltab2x64(:,:,88))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(21),m3h2x32(:,89),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(22),m3h2x32(:,90),heltab2x64(:,:,90))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,91),heltab2x64(:,:,91))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,92),heltab2x64(:,:,92))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(23),m3h2x32(:,93),heltab2x64(:,:,93))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,94),heltab2x64(:,:,94))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,95),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(25),n2h32(61))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,4,8,3,16],[0,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,96),heltab2x64(:,:,96))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(26),n2h32(62))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,97),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(27),n2h32(63))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,4,8,3,16],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,98),heltab2x64(:,:,98))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(28),n2h32(64))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,99),heltab2x64(:,:,99))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,100),heltab2x64(:,:,100))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,101),heltab2x64(:,:,101))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,102),heltab2x64(:,:,102))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(29),m3h2x32(:,103),heltab2x64(:,:,103))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(30),m3h2x32(:,104),heltab2x64(:,:,104))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(31),m3h2x32(:,105),heltab2x64(:,:,105))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,106),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,107),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(33),n2h32(65))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,3,4,8,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,108),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(34),n2h32(66))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,109),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(35),n2h32(67))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,3,4,8,16],[0,0,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,110),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(36),n2h32(68))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(37),m3h2x32(:,111),heltab2x64(:,:,111))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,112),heltab2x64(:,:,112))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,113),heltab2x64(:,:,113))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,114),heltab2x64(:,:,114))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,115),heltab2x64(:,:,115))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,116),heltab2x64(:,:,116))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,117),heltab2x64(:,:,117))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,118),heltab2x64(:,:,118))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,119),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G0H32(21),32,0,G1H32(41),n2h32(69))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,8,4,3,16],[0,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,120),heltab2x64(:,:,120))
  call Hloop_Q_A(ntryL,G0H32(21),32,0,G1H32(42),n2h32(70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,121),heltab2x64(:,:,121))
  call Hloop_Q_A(ntryL,G0H32(21),32,0,G1H32(43),n2h32(71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,8,4,3,16],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,122),heltab2x64(:,:,122))
  call Hloop_Q_A(ntryL,G0H32(21),32,0,G1H32(44),n2h32(72))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,123),heltab2x64(:,:,123))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,124),heltab2x64(:,:,124))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,125),heltab2x64(:,:,125))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,126),heltab2x64(:,:,126))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(45),m3h2x32(:,127),heltab2x64(:,:,127))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,128),heltab2x64(:,:,128))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(47),m3h2x32(:,129),heltab2x64(:,:,129))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(48),m3h2x32(:,130),heltab2x64(:,:,130))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,8,3,4,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,131),heltab2x64(:,:,131))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,8,3,4,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(49),m3h2x32(:,132),heltab2x64(:,:,132))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,4,3,8,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,133),heltab2x64(:,:,133))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,4,3,8,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,134),heltab2x64(:,:,134))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,135),heltab2x64(:,:,135))
  call Hloop_Q_A(ntryL,G0H32(27),32,0,G1H32(51),n2h32(73))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,2,1,16,12],[0,nMZ,0,0,0],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,136),heltab2x64(:,:,136))
  call Hloop_Q_A(ntryL,G0H32(27),32,0,G1H32(52),n2h32(74))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,137),heltab2x64(:,:,137))
  call Hloop_Q_A(ntryL,G0H32(27),32,0,G1H32(53),n2h32(75))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,2,1,16,12],[0,nMZ,0,0,0],5,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,138),heltab2x64(:,:,138))
  call Hloop_Q_A(ntryL,G0H32(27),32,0,G1H32(54),n2h32(76))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,139),heltab2x64(:,:,139))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,140),heltab2x64(:,:,140))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(55),m3h2x32(:,141),heltab2x64(:,:,141))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(56),m3h2x32(:,142),heltab2x64(:,:,142))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,143),heltab2x64(:,:,143))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,144),heltab2x64(:,:,144))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(57),m3h2x32(:,145),heltab2x64(:,:,145))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,146),heltab2x64(:,:,146))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,12,2,1,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,147),heltab2x64(:,:,147))
  call Hloop_Q_A(ntryL,G0H32(31),32,0,G1H32(59),n2h32(77))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,12,2,1,16],[0,0,nMZ,0,0],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,148),heltab2x64(:,:,148))
  call Hloop_Q_A(ntryL,G0H32(31),32,0,G1H32(60),n2h32(78))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,12,2,1,16],[0,0,0,0,0],5,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,149),heltab2x64(:,:,149))
  call Hloop_Q_A(ntryL,G0H32(31),32,0,G1H32(61),n2h32(79))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,12,2,1,16],[0,0,nMZ,0,0],5,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,150),heltab2x64(:,:,150))
  call Hloop_Q_A(ntryL,G0H32(31),32,0,G1H32(62),n2h32(80))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(63),m3h2x32(:,151),heltab2x64(:,:,151))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(64),m3h2x32(:,152),heltab2x64(:,:,152))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,153),heltab2x64(:,:,153))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,154),heltab2x64(:,:,154))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,155),heltab2x64(:,:,155))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,156),heltab2x64(:,:,156))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(65),m3h2x32(:,157),heltab2x64(:,:,157))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(66),m3h2x32(:,158),heltab2x64(:,:,158))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,159),heltab2x64(:,:,159))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(67),n2h32(81))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[32,1,2,16,12],[0,nMZ,0,0,0],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,160),heltab2x64(:,:,160))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(68),n2h32(82))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,161),heltab2x64(:,:,161))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(69),n2h32(83))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[32,1,2,16,12],[0,nMZ,0,0,0],5,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,162),heltab2x64(:,:,162))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(70),n2h32(84))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,163),heltab2x64(:,:,163))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,164),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(71),m3h2x32(:,165),heltab2x64(:,:,165))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(72),m3h2x32(:,166),heltab2x64(:,:,166))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,167),heltab2x64(:,:,167))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,168),heltab2x64(:,:,168))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(73),m3h2x32(:,169),heltab2x64(:,:,169))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(74),m3h2x32(:,170),heltab2x64(:,:,170))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[32,1,2,12,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,171),heltab2x64(:,:,171))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(75),n2h32(85))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[32,1,2,12,16],[0,nMZ,0,0,0],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,172),heltab2x64(:,:,172))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(76),n2h32(86))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,1,2,12,16],[0,0,0,0,0],5,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,173),heltab2x64(:,:,173))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(77),n2h32(87))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[32,1,2,12,16],[0,nMZ,0,0,0],5,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,174),heltab2x64(:,:,174))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(78),n2h32(88))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,175),heltab2x64(:,:,175))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,176),heltab2x64(:,:,176))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,177),heltab2x64(:,:,177))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,178),heltab2x64(:,:,178))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(79),m3h2x32(:,179),heltab2x64(:,:,179))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(80),m3h2x32(:,180),heltab2x64(:,:,180))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(81),m3h2x32(:,181),heltab2x64(:,:,181))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(82),m3h2x32(:,182),heltab2x64(:,:,182))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[32,12,1,2,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,183),heltab2x64(:,:,183))
  call Hloop_A_Q(ntryL,G0H32(43),32,0,G1H32(83),n2h32(89))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[32,12,1,2,16],[0,0,nMZ,0,0],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,184),heltab2x64(:,:,184))
  call Hloop_A_Q(ntryL,G0H32(43),32,0,G1H32(84),n2h32(90))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[32,12,1,2,16],[0,0,0,0,0],5,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,185),heltab2x64(:,:,185))
  call Hloop_A_Q(ntryL,G0H32(43),32,0,G1H32(85),n2h32(91))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[32,12,1,2,16],[0,0,nMZ,0,0],5,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,186),heltab2x64(:,:,186))
  call Hloop_A_Q(ntryL,G0H32(43),32,0,G1H32(86),n2h32(92))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(87),m3h2x32(:,187),heltab2x64(:,:,187))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,188),heltab2x64(:,:,188))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,189),heltab2x64(:,:,189))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,190),heltab2x64(:,:,190))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,191),heltab2x64(:,:,191))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,192),heltab2x64(:,:,192))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(89),m3h2x32(:,193),heltab2x64(:,:,193))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(90),m3h2x32(:,194),heltab2x64(:,:,194))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,2,1,12,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,195),heltab2x64(:,:,195))
  call Hloop_Q_A(ntryL,G0H32(47),32,0,G1H32(91),n2h32(93))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[32,2,1,12,16],[0,nMZ,0,0,0],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,196),heltab2x64(:,:,196))
  call Hloop_Q_A(ntryL,G0H32(47),32,0,G1H32(92),n2h32(94))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,2,1,12,16],[0,0,0,0,0],5,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,197),heltab2x64(:,:,197))
  call Hloop_Q_A(ntryL,G0H32(47),32,0,G1H32(93),n2h32(95))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,2,1,12,16],[0,nMZ,0,0,0],5,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,198),heltab2x64(:,:,198))
  call Hloop_Q_A(ntryL,G0H32(47),32,0,G1H32(94),n2h32(96))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,199),heltab2x64(:,:,199))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,200),heltab2x64(:,:,200))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,201),heltab2x64(:,:,201))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,202),heltab2x64(:,:,202))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(95),m3h2x32(:,203),heltab2x64(:,:,203))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(96),m3h2x32(:,204),heltab2x64(:,:,204))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(97),m3h2x32(:,205),heltab2x64(:,:,205))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,206),heltab2x64(:,:,206))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[32,2,12,1,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,207),heltab2x64(:,:,207))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[32,2,12,1,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(99),m3h2x32(:,208),heltab2x64(:,:,208))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,1,12,2,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,209),heltab2x64(:,:,209))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,1,12,2,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(100),m3h2x32(:,210),heltab2x64(:,:,210))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,2,4,8,17],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,211),heltab2x64(:,:,211))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(101),n2h32(97))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,2,4,8,17],[0,0,0,nMZ,0],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,212),heltab2x64(:,:,212))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(102),n2h32(98))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,2,4,8,17],[0,nMZ,0,0,0],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,213),heltab2x64(:,:,213))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(103),n2h32(99))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,2,4,8,17],[0,nMZ,0,nMZ,0],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,214),heltab2x64(:,:,214))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(104),n2h32(100))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,8,4,2,17],[nMW,0,nMW,0,nMW],5,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(105),m3h2x32(:,215),heltab2x64(:,:,215))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,4,2,17,8],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,216),heltab2x64(:,:,216))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(106),n2h32(101))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[32,4,2,17,8],[0,0,0,nMZ,0],5,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,217),heltab2x64(:,:,217))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(107),n2h32(102))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[32,4,2,17,8],[0,nMZ,0,0,0],5,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,218),heltab2x64(:,:,218))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(108),n2h32(103))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[32,4,2,17,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,219),heltab2x64(:,:,219))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(109),n2h32(104))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[32,2,8,4,17],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,220),heltab2x64(:,:,220))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(110),n2h32(105))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,2,8,4,17],[0,0,0,nMZ,0],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,221),heltab2x64(:,:,221))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(111),n2h32(106))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[32,2,8,4,17],[0,nMZ,0,0,0],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,222),heltab2x64(:,:,222))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(112),n2h32(107))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,2,8,4,17],[0,nMZ,0,nMZ,0],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,223),heltab2x64(:,:,223))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(113),n2h32(108))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[32,4,17,2,8],[0,0,0,0,0],5,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,224),heltab2x64(:,:,224))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(114),n2h32(109))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,4,17,2,8],[0,nMZ,0,0,0],5,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,225),heltab2x64(:,:,225))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(115),n2h32(110))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,4,17,2,8],[0,0,0,nMZ,0],5,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,226),heltab2x64(:,:,226))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(116),n2h32(111))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,4,17,2,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,227),heltab2x64(:,:,227))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(117),n2h32(112))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[32,2,17,8,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(118),m3h2x32(:,228),heltab2x64(:,:,228))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[32,1,4,8,18],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,229),heltab2x64(:,:,229))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(119),n2h32(113))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[32,1,4,8,18],[0,0,0,nMZ,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,230),heltab2x64(:,:,230))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(120),n2h32(114))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[32,1,4,8,18],[0,nMZ,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,231),heltab2x64(:,:,231))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(121),n2h32(115))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[32,1,4,8,18],[0,nMZ,0,nMZ,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,232),heltab2x64(:,:,232))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(122),n2h32(116))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[32,4,1,18,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,233),heltab2x64(:,:,233))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(123),n2h32(117))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[32,4,1,18,8],[0,0,0,nMZ,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,234),heltab2x64(:,:,234))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(124),n2h32(118))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[32,4,1,18,8],[0,nMZ,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,235),heltab2x64(:,:,235))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(125),n2h32(119))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[32,4,1,18,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,236),heltab2x64(:,:,236))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(126),n2h32(120))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[32,1,8,4,18],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,237),heltab2x64(:,:,237))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(127),n2h32(121))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[32,1,8,4,18],[0,0,0,nMZ,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,238),heltab2x64(:,:,238))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(128),n2h32(122))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[32,1,8,4,18],[0,nMZ,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,239),heltab2x64(:,:,239))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(129),n2h32(123))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[32,1,8,4,18],[0,nMZ,0,nMZ,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,240),heltab2x64(:,:,240))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(130),n2h32(124))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[32,4,8,1,18],[nMW,0,nMW,0,nMW],5,1,wf4(:,20))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(131),m3h2x32(:,241),heltab2x64(:,:,241))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[32,4,18,1,8],[0,0,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,242),heltab2x64(:,:,242))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(132),n2h32(125))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[32,4,18,1,8],[0,nMZ,0,0,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,243),heltab2x64(:,:,243))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(133),n2h32(126))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[32,4,18,1,8],[0,0,0,nMZ,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,244),heltab2x64(:,:,244))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(134),n2h32(127))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[32,4,18,1,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,245),heltab2x64(:,:,245))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(135),n2h32(128))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[32,1,18,4,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,20))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(136),m3h2x32(:,246),heltab2x64(:,:,246))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[32,2,1,8,20],[nMW,0,nMW,0,nMW],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(137),m3h2x32(:,247),heltab2x64(:,:,247))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[32,8,1,2,20],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,248),heltab2x64(:,:,248))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(138),n2h32(129))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[32,8,1,2,20],[0,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,249),heltab2x64(:,:,249))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(139),n2h32(130))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[32,8,1,2,20],[0,nMZ,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,250),heltab2x64(:,:,250))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(140),n2h32(131))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[32,8,1,2,20],[0,nMZ,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,251),heltab2x64(:,:,251))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(141),n2h32(132))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[32,1,2,20,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(142),m3h2x32(:,252),heltab2x64(:,:,252))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[32,8,2,1,20],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,253),heltab2x64(:,:,253))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(143),n2h32(133))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[32,8,2,1,20],[0,nMZ,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,254),heltab2x64(:,:,254))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(144),n2h32(134))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[32,8,2,1,20],[0,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,255),heltab2x64(:,:,255))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(145),n2h32(135))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[32,8,2,1,20],[0,nMZ,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,256),heltab2x64(:,:,256))
  call Hloop_Q_A(ntryL,G0H32(53),32,0,G1H32(146),n2h32(136))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[32,1,8,20,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,257),heltab2x64(:,:,257))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(147),n2h32(137))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[32,1,8,20,2],[0,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,258),heltab2x64(:,:,258))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(148),n2h32(138))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[32,1,8,20,2],[0,nMZ,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,259),heltab2x64(:,:,259))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(149),n2h32(139))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[32,1,8,20,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,260),heltab2x64(:,:,260))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(150),n2h32(140))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[32,1,20,8,2],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,261),heltab2x64(:,:,261))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(151),n2h32(141))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[32,1,20,8,2],[0,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,262),heltab2x64(:,:,262))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(152),n2h32(142))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[32,1,20,8,2],[0,nMZ,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,263),heltab2x64(:,:,263))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(153),n2h32(143))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[32,1,20,8,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,264),heltab2x64(:,:,264))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(154),n2h32(144))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[32,4,1,2,24],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,265),heltab2x64(:,:,265))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(155),n2h32(145))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[32,4,1,2,24],[0,0,0,nMZ,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,266),heltab2x64(:,:,266))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(156),n2h32(146))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[32,4,1,2,24],[0,nMZ,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,267),heltab2x64(:,:,267))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(157),n2h32(147))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[32,4,1,2,24],[0,nMZ,0,nMZ,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,268),heltab2x64(:,:,268))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(158),n2h32(148))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[32,1,2,4,24],[nMW,0,nMW,0,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(159),m3h2x32(:,269),heltab2x64(:,:,269))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[32,4,2,1,24],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,270),heltab2x64(:,:,270))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(160),n2h32(149))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[32,4,2,1,24],[0,nMZ,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,271),heltab2x64(:,:,271))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(161),n2h32(150))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[32,4,2,1,24],[0,0,0,nMZ,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,272),heltab2x64(:,:,272))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(162),n2h32(151))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,4,2,1,24],[0,nMZ,0,nMZ,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,273),heltab2x64(:,:,273))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(163),n2h32(152))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,2,1,24,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(164),m3h2x32(:,274),heltab2x64(:,:,274))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[32,1,4,24,2],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,275),heltab2x64(:,:,275))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(165),n2h32(153))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[32,1,4,24,2],[0,0,0,nMZ,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,276),heltab2x64(:,:,276))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(166),n2h32(154))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,1,4,24,2],[0,nMZ,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,277),heltab2x64(:,:,277))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(167),n2h32(155))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[32,1,4,24,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,278),heltab2x64(:,:,278))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(168),n2h32(156))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[32,1,24,4,2],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,279),heltab2x64(:,:,279))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(169),n2h32(157))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[32,1,24,4,2],[0,0,0,nMZ,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,280),heltab2x64(:,:,280))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(170),n2h32(158))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[32,1,24,4,2],[0,nMZ,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,281),heltab2x64(:,:,281))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(171),n2h32(159))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[32,1,24,4,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,282),heltab2x64(:,:,282))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(172),n2h32(160))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[33,8,4,2,16],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(3),m3h4x16(:,1),heltab2x64(:,:,283))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[33,8,4,2,16],[nMZ,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,19),G0H16(4),ngZl,m3h4x16(:,2),heltab2x64(:,:,284))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[33,8,4,2,16],[0,0,nMZ,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(5),m3h4x16(:,3),heltab2x64(:,:,285))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[33,8,4,2,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,19))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,19),G0H16(6),ngZl,m3h4x16(:,4),heltab2x64(:,:,286))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[33,2,4,8,16],[0,nMW,0,nMW,nMW],5,1,wf4(:,19))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(7),m3h4x16(:,5),heltab2x64(:,:,287))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(1),n2h16(11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[33,2,4,16,8],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(7),m3h4x16(:,6),heltab2x64(:,:,288))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(2),n2h16(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[33,2,4,16,8],[0,0,0,0,nMZ],5,1,wf4(:,19))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(7),ngZl,m3h4x16(:,7),heltab2x64(:,:,289))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(3),n2h16(13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[33,2,4,16,8],[0,nMZ,0,0,0],5,1,wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(7),m3h4x16(:,8),heltab2x64(:,:,290))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(4),n2h16(14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[33,2,4,16,8],[0,nMZ,0,0,nMZ],5,1,wf4(:,19))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(7),ngZl,m3h4x16(:,9),heltab2x64(:,:,291))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(5),n2h16(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[33,4,8,2,16],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(7),m3h4x16(:,10),heltab2x64(:,:,292))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[33,4,8,2,16],[nMZ,0,0,0,0],5,1,wf4(:,19))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,19),G0H16(8),ngZl,m3h4x16(:,11),heltab2x64(:,:,293))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[33,4,8,2,16],[0,0,nMZ,0,0],5,1,wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,19),G0H16(9),m3h4x16(:,12),heltab2x64(:,:,294))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[33,4,8,2,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,19))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,19),G0H16(10),ngZl,m3h4x16(:,13),heltab2x64(:,:,295))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[33,2,8,16,4],[0,0,0,0,0],5,1,wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(11),m3h4x16(:,14),heltab2x64(:,:,296))
  call Hloop_Q_A(ntryL,G0H16(11),33,0,G1H16(6),n2h16(16))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[33,2,8,16,4],[0,0,0,0,nMZ],5,1,wf4(:,19))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(11),ngZl,m3h4x16(:,15),heltab2x64(:,:,297))
  call Hloop_Q_A(ntryL,G0H16(11),33,0,G1H16(7),n2h16(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[33,2,8,16,4],[0,nMZ,0,0,0],5,1,wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(11),m3h4x16(:,16),heltab2x64(:,:,298))
  call Hloop_Q_A(ntryL,G0H16(11),33,0,G1H16(8),n2h16(18))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[33,2,8,16,4],[0,nMZ,0,0,nMZ],5,1,wf4(:,19))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(11),ngZl,m3h4x16(:,17),heltab2x64(:,:,299))
  call Hloop_Q_A(ntryL,G0H16(11),33,0,G1H16(9),n2h16(19))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[33,2,16,4,8],[0,nMW,nMW,0,nMW],5,1,wf4(:,19))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,19),G0H16(11),m3h4x16(:,18),heltab2x64(:,:,300))
  call Hloop_Q_A(ntryL,G0H16(11),33,0,G1H16(10),n2h16(20))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[34,8,4,1,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,15),G0H16(11),m3h4x16(:,19),heltab2x64(:,:,301))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[34,8,4,1,16],[nMZ,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,15),G0H16(12),ngZl,m3h4x16(:,20),heltab2x64(:,:,302))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[34,8,4,1,16],[0,0,nMZ,0,0],5,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,15),G0H16(13),m3h4x16(:,21),heltab2x64(:,:,303))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[34,8,4,1,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,15),G0H16(14),ngZl,m3h4x16(:,22),heltab2x64(:,:,304))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[34,1,4,16,8],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,15),G0H16(15),m3h4x16(:,23),heltab2x64(:,:,305))
  call Hloop_A_Q(ntryL,G0H16(15),34,0,G1H16(11),n2h16(21))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[34,1,4,16,8],[0,0,0,0,nMZ],5,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf4(:,15),G0H16(15),ngZl,m3h4x16(:,24),heltab2x64(:,:,306))
  call Hloop_A_Q(ntryL,G0H16(15),34,0,G1H16(12),n2h16(22))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[34,1,4,16,8],[0,nMZ,0,0,0],5,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,15),G0H16(15),m3h4x16(:,25),heltab2x64(:,:,307))
  call Hloop_A_Q(ntryL,G0H16(15),34,0,G1H16(13),n2h16(23))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[34,1,4,16,8],[0,nMZ,0,0,nMZ],5,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf4(:,15),G0H16(15),ngZl,m3h4x16(:,26),heltab2x64(:,:,308))
  call Hloop_A_Q(ntryL,G0H16(15),34,0,G1H16(14),n2h16(24))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[34,4,8,1,16],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,15),G0H16(15),m3h4x16(:,27),heltab2x64(:,:,309))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[34,4,8,1,16],[nMZ,0,0,0,0],5,1,wf4(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,15),G0H16(16),ngZl,m3h4x16(:,28),heltab2x64(:,:,310))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[34,4,8,1,16],[0,0,nMZ,0,0],5,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,15),G0H16(17),m3h4x16(:,29),heltab2x64(:,:,311))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[34,4,8,1,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,15),G0H16(18),ngZl,m3h4x16(:,30),heltab2x64(:,:,312))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[34,1,8,4,16],[0,nMW,0,nMW,nMW],5,1,wf4(:,15))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,15),G0H16(19),m3h4x16(:,31),heltab2x64(:,:,313))
  call Hloop_A_Q(ntryL,G0H16(19),34,0,G1H16(15),n2h16(25))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[34,1,8,16,4],[0,0,0,0,0],5,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,15),G0H16(19),m3h4x16(:,32),heltab2x64(:,:,314))
  call Hloop_A_Q(ntryL,G0H16(19),34,0,G1H16(16),n2h16(26))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[34,1,8,16,4],[0,0,0,0,nMZ],5,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf4(:,15),G0H16(19),ngZl,m3h4x16(:,33),heltab2x64(:,:,315))
  call Hloop_A_Q(ntryL,G0H16(19),34,0,G1H16(17),n2h16(27))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[34,1,8,16,4],[0,nMZ,0,0,0],5,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,15),G0H16(19),m3h4x16(:,34),heltab2x64(:,:,316))
  call Hloop_A_Q(ntryL,G0H16(19),34,0,G1H16(18),n2h16(28))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[34,1,8,16,4],[0,nMZ,0,0,nMZ],5,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf4(:,15),G0H16(19),ngZl,m3h4x16(:,35),heltab2x64(:,:,317))
  call Hloop_A_Q(ntryL,G0H16(19),34,0,G1H16(19),n2h16(29))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[34,1,16,8,4],[0,nMW,nMW,0,nMW],5,1,wf4(:,15))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,15),G0H16(19),m3h4x16(:,36),heltab2x64(:,:,318))
  call Hloop_A_Q(ntryL,G0H16(19),34,0,G1H16(20),n2h16(30))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[36,8,1,2,16],[0,nMW,0,nMW,nMW],5,1,wf4(:,9))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,9),G0H16(19),m3h4x16(:,37),heltab2x64(:,:,319))
  call Hloop_Q_A(ntryL,G0H16(19),36,0,G1H16(21),n2h16(31))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[36,2,1,8,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,9),G0H16(19),m3h4x16(:,38),heltab2x64(:,:,320))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[36,2,1,8,16],[nMZ,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,9),G0H16(20),ngZl,m3h4x16(:,39),heltab2x64(:,:,321))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[36,2,1,8,16],[0,0,nMZ,0,0],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,9),G0H16(21),m3h4x16(:,40),heltab2x64(:,:,322))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[36,2,1,8,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,9),G0H16(22),ngZl,m3h4x16(:,41),heltab2x64(:,:,323))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[36,2,1,16,8],[nMW,0,nMW,nMW,0],5,1,wf4(:,9))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,9),G0H16(23),m3h4x16(:,42),heltab2x64(:,:,324))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[36,1,2,8,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,9),G0H16(24),m3h4x16(:,43),heltab2x64(:,:,325))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[36,1,2,8,16],[0,0,nMZ,0,0],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,9),G0H16(25),m3h4x16(:,44),heltab2x64(:,:,326))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[36,1,2,8,16],[nMZ,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,9),G0H16(26),ngZl,m3h4x16(:,45),heltab2x64(:,:,327))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[36,1,2,8,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,9),G0H16(27),ngZl,m3h4x16(:,46),heltab2x64(:,:,328))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[36,2,16,1,8],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,9),G0H16(28),m3h4x16(:,47),heltab2x64(:,:,329))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[36,2,16,1,8],[nMZ,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,9),G0H16(29),ngZl,m3h4x16(:,48),heltab2x64(:,:,330))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[36,2,16,1,8],[0,0,0,nMZ,0],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,9),G0H16(30),m3h4x16(:,49),heltab2x64(:,:,331))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[36,2,16,1,8],[nMZ,0,0,nMZ,0],5,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,9),G0H16(31),ngZl,m3h4x16(:,50),heltab2x64(:,:,332))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[36,1,16,2,8],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,9),G0H16(32),m3h4x16(:,51),heltab2x64(:,:,333))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[36,1,16,2,8],[0,0,0,nMZ,0],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,9),G0H16(33),m3h4x16(:,52),heltab2x64(:,:,334))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[36,1,16,2,8],[nMZ,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,9),G0H16(34),ngZl,m3h4x16(:,53),heltab2x64(:,:,335))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[36,1,16,2,8],[nMZ,0,0,nMZ,0],5,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,9),G0H16(35),ngZl,m3h4x16(:,54),heltab2x64(:,:,336))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[40,2,1,4,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(36),m3h4x16(:,55),heltab2x64(:,:,337))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[40,2,1,4,16],[nMZ,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(37),ngZl,m3h4x16(:,56),heltab2x64(:,:,338))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[40,2,1,4,16],[0,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(38),m3h4x16(:,57),heltab2x64(:,:,339))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[40,2,1,4,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(39),ngZl,m3h4x16(:,58),heltab2x64(:,:,340))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[40,4,2,1,16],[0,nMW,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(40),m3h4x16(:,59),heltab2x64(:,:,341))
  call Hloop_A_Q(ntryL,G0H16(40),40,0,G1H16(22),n2h16(32))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[40,1,2,4,16],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(40),m3h4x16(:,60),heltab2x64(:,:,342))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[40,1,2,4,16],[0,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(41),m3h4x16(:,61),heltab2x64(:,:,343))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[40,1,2,4,16],[nMZ,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(42),ngZl,m3h4x16(:,62),heltab2x64(:,:,344))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[40,1,2,4,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(43),ngZl,m3h4x16(:,63),heltab2x64(:,:,345))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[40,1,2,16,4],[nMW,0,nMW,nMW,0],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(44),m3h4x16(:,64),heltab2x64(:,:,346))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[40,2,16,1,4],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(45),m3h4x16(:,65),heltab2x64(:,:,347))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[40,2,16,1,4],[nMZ,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(46),ngZl,m3h4x16(:,66),heltab2x64(:,:,348))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[40,2,16,1,4],[0,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(47),m3h4x16(:,67),heltab2x64(:,:,349))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[40,2,16,1,4],[nMZ,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(48),ngZl,m3h4x16(:,68),heltab2x64(:,:,350))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[40,1,16,2,4],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(49),m3h4x16(:,69),heltab2x64(:,:,351))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[40,1,16,2,4],[0,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(50),m3h4x16(:,70),heltab2x64(:,:,352))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[40,1,16,2,4],[nMZ,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(51),ngZl,m3h4x16(:,71),heltab2x64(:,:,353))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[40,1,16,2,4],[nMZ,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(52),ngZl,m3h4x16(:,72),heltab2x64(:,:,354))
  call Hloop_WA_Q(ntryL,G0H16(1),ex2(:),G0H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G0H8(1),50,0,G1H8(5),n2h8(71))
  call Hloop_WQ_A(ntryL,G0H16(2),ex1(:),G0H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G0H8(1),49,0,G1H8(1),n2h8(72))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,1),G1H8(8),m3h4x8(:,1),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(8),35,0,G2H8(17),n2h8(73))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,1),G1H8(9),m3h4x8(:,2),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(9),35,0,G2H8(18),n2h8(74))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,6),G1H8(2),ngZl,m3h4x8(:,3),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(2),35,0,G2H8(19),n2h8(75))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,6),G1H8(10),ngZl,m3h4x8(:,4),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(10),35,0,G2H8(20),n2h8(76))
  call Hloop_SV_T(ntryL,G0H32(4),32,wf4(:,1),3,G1H8(13),m3h4x8(:,5),heltab2x32(:,:,63))
  call Hloop_SV_T(ntryL,G0H32(5),32,wf4(:,6),3,G1H8(14),m3h4x8(:,6),heltab2x32(:,:,64))
  call Hloop_VV_S(ntryL,G1H32(5),wf4(:,1),G1H8(3),m3h4x8(:,7),heltab2x32(:,:,65))
  call Hloop_VV_S(ntryL,G1H32(6),wf4(:,6),G1H8(15),m3h4x8(:,8),heltab2x32(:,:,66))
  call Hloop_SV_V(ntryL,G0H32(1),wf4(:,1),G0H8(1),m3h4x8(:,9),heltab2x32(:,:,67))
  call Hloop_SV_V(ntryL,G0H32(2),wf4(:,6),G0H8(2),m3h4x8(:,10),heltab2x32(:,:,68))
  call Hloop_UW_V(ntryL,G1H32(7),32,wf4(:,1),3,G2H8(21),m3h4x8(:,11),heltab2x32(:,:,69))
  call Hloop_UW_V(ntryL,G1H32(8),32,wf4(:,6),3,G2H8(22),m3h4x8(:,12),heltab2x32(:,:,70))
  call Hloop_QV_A(ntryL,G1H32(9),wf4(:,1),G1H8(18),m3h4x8(:,13),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(18),35,0,G2H8(23),n2h8(77))
  call Hloop_QV_A(ntryL,G1H32(10),wf4(:,1),G1H8(19),m3h4x8(:,14),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(19),35,0,G2H8(24),n2h8(78))
  call Hloop_QZ_A(ntryL,G1H32(11),wf4(:,6),G1H8(20),ngZl,m3h4x8(:,15),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(20),35,0,G2H8(25),n2h8(79))
  call Hloop_QZ_A(ntryL,G1H32(12),wf4(:,6),G1H8(21),ngZl,m3h4x8(:,16),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(21),35,0,G2H8(26),n2h8(80))
  call Hloop_SV_V(ntryL,G1H32(13),wf4(:,1),G1H8(24),m3h4x8(:,17),heltab2x32(:,:,75))
  call Hloop_SV_V(ntryL,G1H32(14),wf4(:,6),G1H8(25),m3h4x8(:,18),heltab2x32(:,:,76))
  call Hloop_UV_W(ntryL,G0H32(3),32,wf4(:,1),3,G1H8(4),m3h4x8(:,19),heltab2x32(:,:,77))
  call Hloop_UV_W(ntryL,G0H32(6),32,wf4(:,6),3,G1H8(26),m3h4x8(:,20),heltab2x32(:,:,78))
  call Hloop_SV_V(ntryL,G0H32(7),wf4(:,1),G0H8(3),m3h4x8(:,21),heltab2x32(:,:,79))
  call Hloop_SV_V(ntryL,G0H32(8),wf4(:,6),G0H8(4),m3h4x8(:,22),heltab2x32(:,:,80))
  call Hloop_UV_W(ntryL,G1H32(15),32,wf4(:,1),3,G2H8(27),m3h4x8(:,23),heltab2x32(:,:,81))
  call Hloop_UV_W(ntryL,G1H32(16),32,wf4(:,6),3,G2H8(28),m3h4x8(:,24),heltab2x32(:,:,82))
  call Hloop_QV_A(ntryL,G1H32(17),wf4(:,1),G1H8(29),m3h4x8(:,25),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(29),35,0,G2H8(29),n2h8(81))
  call Hloop_QV_A(ntryL,G1H32(18),wf4(:,1),G1H8(30),m3h4x8(:,26),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(30),35,0,G2H8(30),n2h8(82))
  call Hloop_QZ_A(ntryL,G1H32(19),wf4(:,6),G1H8(31),ngZl,m3h4x8(:,27),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(31),35,0,G2H8(31),n2h8(83))
  call Hloop_QZ_A(ntryL,G1H32(20),wf4(:,6),G1H8(32),ngZl,m3h4x8(:,28),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(32),35,0,G2H8(32),n2h8(84))
  call Hloop_TV_S(ntryL,G0H32(9),32,wf4(:,1),3,G1H8(35),m3h4x8(:,29),heltab2x32(:,:,87))
  call Hloop_TV_S(ntryL,G0H32(10),32,wf4(:,6),3,G1H8(36),m3h4x8(:,30),heltab2x32(:,:,88))
  call Hloop_VV_S(ntryL,G1H32(21),wf4(:,1),G1H8(37),m3h4x8(:,31),heltab2x32(:,:,89))
  call Hloop_VV_S(ntryL,G1H32(22),wf4(:,6),G1H8(38),m3h4x8(:,32),heltab2x32(:,:,90))
  call Hloop_SV_V(ntryL,G0H32(11),wf4(:,1),G0H8(5),m3h4x8(:,33),heltab2x32(:,:,91))
  call Hloop_SV_V(ntryL,G0H32(12),wf4(:,6),G0H8(6),m3h4x8(:,34),heltab2x32(:,:,92))
  call Hloop_UV_W(ntryL,G1H32(23),32,wf4(:,1),3,G2H8(33),m3h4x8(:,35),heltab2x32(:,:,93))
  call Hloop_UV_W(ntryL,G1H32(24),32,wf4(:,6),3,G2H8(34),m3h4x8(:,36),heltab2x32(:,:,94))
  call Hloop_AQ_V(ntryL,G1H32(25),ex3(:),G1H16(23),m3h2x16(:,59),heltab2x32(:,:,95))
  call Hloop_AQ_Z(ntryL,G1H32(26),ex3(:),G1H16(24),ngZl,m3h2x16(:,60),heltab2x32(:,:,96))
  call Hloop_AQ_V(ntryL,G1H32(27),ex3(:),G1H16(25),m3h2x16(:,61),heltab2x32(:,:,97))
  call Hloop_AQ_Z(ntryL,G1H32(28),ex3(:),G1H16(26),ngZl,m3h2x16(:,62),heltab2x32(:,:,98))
  call Hloop_WQ_A(ntryL,G0H32(13),ex3(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(27),n2h16(33))
  call Hloop_WQ_A(ntryL,G0H32(14),ex3(:),G0H16(2),m3h2x16(:,64),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G0H16(2),36,0,G1H16(28),n2h16(34))
  call Hloop_WQ_A(ntryL,G0H32(15),ex3(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,101))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(29),n2h16(35))
  call Hloop_WQ_A(ntryL,G0H32(16),ex3(:),G0H16(2),m3h2x16(:,66),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G0H16(2),36,0,G1H16(30),n2h16(36))
  call Hloop_WQ_A(ntryL,G1H32(29),ex3(:),G1H16(31),m3h2x16(:,67),heltab2x32(:,:,103))
  call Hloop_Q_A(ntryL,G1H16(31),36,0,G2H16(1),n2h16(37))
  call Hloop_WQ_A(ntryL,G1H32(30),ex3(:),G1H16(32),m3h2x16(:,68),heltab2x32(:,:,104))
  call Hloop_Q_A(ntryL,G1H16(32),36,0,G2H16(2),n2h16(38))
  call Hloop_WQ_A(ntryL,G1H32(31),ex3(:),G1H16(33),m3h2x16(:,69),heltab2x32(:,:,105))
  call Hloop_Q_A(ntryL,G1H16(33),36,0,G2H16(3),n2h16(39))
  call Hloop_WQ_A(ntryL,G1H32(32),ex3(:),G1H16(34),m3h2x16(:,70),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G1H16(34),36,0,G2H16(4),n2h16(40))
  call Hloop_AV_Q(ntryL,G1H32(33),wf4(:,1),G1H8(41),m3h4x8(:,37),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G1H8(41),35,0,G2H8(35),n2h8(85))
  call Hloop_AV_Q(ntryL,G1H32(34),wf4(:,1),G1H8(42),m3h4x8(:,38),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G1H8(42),35,0,G2H8(36),n2h8(86))
  call Hloop_AZ_Q(ntryL,G1H32(35),wf4(:,6),G1H8(43),ngZl,m3h4x8(:,39),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G1H8(43),35,0,G2H8(37),n2h8(87))
  call Hloop_AZ_Q(ntryL,G1H32(36),wf4(:,6),G1H8(44),ngZl,m3h4x8(:,40),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G1H8(44),35,0,G2H8(38),n2h8(88))
  call Hloop_SV_V(ntryL,G1H32(37),wf4(:,1),G1H8(47),m3h4x8(:,41),heltab2x32(:,:,111))
  call Hloop_SV_V(ntryL,G1H32(38),wf4(:,6),G1H8(48),m3h4x8(:,42),heltab2x32(:,:,112))
  call Hloop_UW_V(ntryL,G0H32(17),32,wf4(:,1),3,G1H8(49),m3h4x8(:,43),heltab2x32(:,:,113))
  call Hloop_UW_V(ntryL,G0H32(18),32,wf4(:,6),3,G1H8(50),m3h4x8(:,44),heltab2x32(:,:,114))
  call Hloop_SV_V(ntryL,G0H32(19),wf4(:,1),G0H8(7),m3h4x8(:,45),heltab2x32(:,:,115))
  call Hloop_SV_V(ntryL,G0H32(20),wf4(:,6),G0H8(8),m3h4x8(:,46),heltab2x32(:,:,116))
  call Hloop_UW_V(ntryL,G1H32(39),32,wf4(:,1),3,G2H8(39),m3h4x8(:,47),heltab2x32(:,:,117))
  call Hloop_UW_V(ntryL,G1H32(40),32,wf4(:,6),3,G2H8(40),m3h4x8(:,48),heltab2x32(:,:,118))
  call Hloop_QA_V(ntryL,G1H32(41),ex4(:),G1H16(35),m3h2x16(:,71),heltab2x32(:,:,119))
  call Hloop_QA_Z(ntryL,G1H32(42),ex4(:),G1H16(36),ngZl,m3h2x16(:,72),heltab2x32(:,:,120))
  call Hloop_QA_V(ntryL,G1H32(43),ex4(:),G1H16(37),m3h2x16(:,73),heltab2x32(:,:,121))
  call Hloop_QA_Z(ntryL,G1H32(44),ex4(:),G1H16(38),ngZl,m3h2x16(:,74),heltab2x32(:,:,122))
  call Hloop_WA_Q(ntryL,G0H32(21),ex4(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(39),n2h16(41))
  call Hloop_WA_Q(ntryL,G0H32(22),ex4(:),G0H16(2),m3h2x16(:,76),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(2),40,0,G1H16(40),n2h16(42))
  call Hloop_WA_Q(ntryL,G0H32(23),ex4(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(41),n2h16(43))
  call Hloop_WA_Q(ntryL,G0H32(24),ex4(:),G0H16(2),m3h2x16(:,78),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(2),40,0,G1H16(42),n2h16(44))
  call Hloop_WA_Q(ntryL,G1H32(45),ex4(:),G1H16(43),m3h2x16(:,79),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G1H16(43),40,0,G2H16(5),n2h16(45))
  call Hloop_WA_Q(ntryL,G1H32(46),ex4(:),G1H16(44),m3h2x16(:,80),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G1H16(44),40,0,G2H16(6),n2h16(46))
  call Hloop_WA_Q(ntryL,G1H32(47),ex4(:),G1H16(45),m3h2x16(:,81),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G1H16(45),40,0,G2H16(7),n2h16(47))
  call Hloop_WA_Q(ntryL,G1H32(48),ex4(:),G1H16(46),m3h2x16(:,82),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G1H16(46),40,0,G2H16(8),n2h16(48))
  call Hloop_WA_Q(ntryL,G0H32(25),ex4(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(47),n2h16(49))
  call Hloop_WA_Q(ntryL,G1H32(49),ex4(:),G1H16(48),m3h2x16(:,84),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G1H16(48),40,0,G2H16(9),n2h16(50))
  call Hloop_WQ_A(ntryL,G0H32(26),ex3(:),G0H16(2),m3h2x16(:,85),heltab2x32(:,:,133))
  call Hloop_Q_A(ntryL,G0H16(2),36,0,G1H16(49),n2h16(51))
  call Hloop_WQ_A(ntryL,G1H32(50),ex3(:),G1H16(50),m3h2x16(:,86),heltab2x32(:,:,134))
  call Hloop_Q_A(ntryL,G1H16(50),36,0,G2H16(10),n2h16(52))
  call Hloop_QA_V(ntryL,G1H32(51),ex2(:),G1H16(51),m3h2x16(:,87),heltab2x32(:,:,135))
  call Hloop_QA_Z(ntryL,G1H32(52),ex2(:),G1H16(52),ngZl,m3h2x16(:,88),heltab2x32(:,:,136))
  call Hloop_QA_V(ntryL,G1H32(53),ex2(:),G1H16(31),m3h2x16(:,89),heltab2x32(:,:,137))
  call Hloop_QA_Z(ntryL,G1H32(54),ex2(:),G1H16(32),ngZl,m3h2x16(:,90),heltab2x32(:,:,138))
  call Hloop_WA_Q(ntryL,G0H32(27),ex2(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(33),n2h16(53))
  call Hloop_WA_Q(ntryL,G0H32(28),ex2(:),G0H16(2),m3h2x16(:,92),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(34),n2h16(54))
  call Hloop_WA_Q(ntryL,G1H32(55),ex2(:),G1H16(43),m3h2x16(:,93),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G1H16(43),34,0,G2H16(11),n2h16(55))
  call Hloop_WA_Q(ntryL,G1H32(56),ex2(:),G1H16(44),m3h2x16(:,94),heltab2x32(:,:,142))
  call Hloop_A_Q(ntryL,G1H16(44),34,0,G2H16(12),n2h16(56))
  call Hloop_WA_Q(ntryL,G0H32(29),ex2(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,143))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(45),n2h16(57))
  call Hloop_WA_Q(ntryL,G0H32(30),ex2(:),G0H16(2),m3h2x16(:,96),heltab2x32(:,:,144))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(46),n2h16(58))
  call Hloop_WA_Q(ntryL,G1H32(57),ex2(:),G1H16(48),m3h2x16(:,97),heltab2x32(:,:,145))
  call Hloop_A_Q(ntryL,G1H16(48),34,0,G2H16(13),n2h16(59))
  call Hloop_WA_Q(ntryL,G1H32(58),ex2(:),G1H16(50),m3h2x16(:,98),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G1H16(50),34,0,G2H16(14),n2h16(60))
  call Hloop_QV_A(ntryL,G1H32(59),wf4(:,13),G1H8(53),m3h4x8(:,49),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G1H8(53),44,0,G2H8(41),n2h8(89))
  call Hloop_QV_A(ntryL,G1H32(60),wf4(:,13),G1H8(54),m3h4x8(:,50),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G1H8(54),44,0,G2H8(42),n2h8(90))
  call Hloop_QZ_A(ntryL,G1H32(61),wf4(:,16),G1H8(55),ngZl,m3h4x8(:,51),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G1H8(55),44,0,G2H8(43),n2h8(91))
  call Hloop_QZ_A(ntryL,G1H32(62),wf4(:,16),G1H8(56),ngZl,m3h4x8(:,52),heltab2x32(:,:,150))
  call Hloop_Q_A(ntryL,G1H8(56),44,0,G2H8(44),n2h8(92))
  call Hloop_SV_V(ntryL,G1H32(63),wf4(:,13),G1H8(59),m3h4x8(:,53),heltab2x32(:,:,151))
  call Hloop_SV_V(ntryL,G1H32(64),wf4(:,16),G1H8(60),m3h4x8(:,54),heltab2x32(:,:,152))
  call Hloop_UV_W(ntryL,G0H32(31),32,wf4(:,13),12,G1H8(61),m3h4x8(:,55),heltab2x32(:,:,153))
  call Hloop_UV_W(ntryL,G0H32(32),32,wf4(:,16),12,G1H8(62),m3h4x8(:,56),heltab2x32(:,:,154))
  call Hloop_SV_V(ntryL,G0H32(33),wf4(:,13),G0H8(9),m3h4x8(:,57),heltab2x32(:,:,155))
  call Hloop_SV_V(ntryL,G0H32(34),wf4(:,16),G0H8(10),m3h4x8(:,58),heltab2x32(:,:,156))
  call Hloop_UV_W(ntryL,G1H32(65),32,wf4(:,13),12,G2H8(45),m3h4x8(:,59),heltab2x32(:,:,157))
  call Hloop_UV_W(ntryL,G1H32(66),32,wf4(:,16),12,G2H8(46),m3h4x8(:,60),heltab2x32(:,:,158))
  call Hloop_AQ_V(ntryL,G1H32(67),ex1(:),G1H16(43),m3h2x16(:,99),heltab2x32(:,:,159))
  call Hloop_AQ_Z(ntryL,G1H32(68),ex1(:),G1H16(44),ngZl,m3h2x16(:,100),heltab2x32(:,:,160))
  call Hloop_AQ_V(ntryL,G1H32(69),ex1(:),G1H16(48),m3h2x16(:,101),heltab2x32(:,:,161))
  call Hloop_AQ_Z(ntryL,G1H32(70),ex1(:),G1H16(50),ngZl,m3h2x16(:,102),heltab2x32(:,:,162))
  call Hloop_WQ_A(ntryL,G0H32(35),ex1(:),G0H16(1),m3h2x16(:,103),heltab2x32(:,:,163))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(53),n2h16(61))
  call Hloop_WQ_A(ntryL,G0H32(36),ex1(:),G0H16(2),m3h2x16(:,104),heltab2x32(:,:,164))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(54),n2h16(62))
  call Hloop_WQ_A(ntryL,G1H32(71),ex1(:),G1H16(55),m3h2x16(:,105),heltab2x32(:,:,165))
  call Hloop_Q_A(ntryL,G1H16(55),33,0,G2H16(15),n2h16(63))
  call Hloop_WQ_A(ntryL,G1H32(72),ex1(:),G1H16(55),m3h2x16(:,106),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G1H16(55),33,0,G2H16(16),n2h16(64))
  call Hloop_WQ_A(ntryL,G0H32(37),ex1(:),G0H16(1),m3h2x16(:,107),heltab2x32(:,:,167))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(55),n2h16(65))
  call Hloop_WQ_A(ntryL,G0H32(38),ex1(:),G0H16(2),m3h2x16(:,108),heltab2x32(:,:,168))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(56),n2h16(66))
  call Hloop_WQ_A(ntryL,G1H32(73),ex1(:),G1H16(57),m3h2x16(:,109),heltab2x32(:,:,169))
  call Hloop_Q_A(ntryL,G1H16(57),33,0,G2H16(17),n2h16(67))
  call Hloop_WQ_A(ntryL,G1H32(74),ex1(:),G1H16(57),m3h2x16(:,110),heltab2x32(:,:,170))
  call Hloop_Q_A(ntryL,G1H16(57),33,0,G2H16(18),n2h16(68))
  call Hloop_AQ_V(ntryL,G1H32(75),ex1(:),G1H16(57),m3h2x16(:,111),heltab2x32(:,:,171))
  call Hloop_AQ_Z(ntryL,G1H32(76),ex1(:),G1H16(58),ngZl,m3h2x16(:,112),heltab2x32(:,:,172))
  call Hloop_AQ_V(ntryL,G1H32(77),ex1(:),G1H16(59),m3h2x16(:,113),heltab2x32(:,:,173))
  call Hloop_AQ_Z(ntryL,G1H32(78),ex1(:),G1H16(60),ngZl,m3h2x16(:,114),heltab2x32(:,:,174))
  call Hloop_WQ_A(ntryL,G0H32(39),ex1(:),G0H16(1),m3h2x16(:,115),heltab2x32(:,:,175))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(61),n2h16(69))
  call Hloop_WQ_A(ntryL,G0H32(40),ex1(:),G0H16(2),m3h2x16(:,116),heltab2x32(:,:,176))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(62),n2h16(70))
  call Hloop_WQ_A(ntryL,G0H32(41),ex1(:),G0H16(1),m3h2x16(:,117),heltab2x32(:,:,177))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(63),n2h16(71))
  call Hloop_WQ_A(ntryL,G0H32(42),ex1(:),G0H16(2),m3h2x16(:,118),heltab2x32(:,:,178))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(64),n2h16(72))
  call Hloop_WQ_A(ntryL,G1H32(79),ex1(:),G1H16(65),m3h2x16(:,119),heltab2x32(:,:,179))
  call Hloop_Q_A(ntryL,G1H16(65),33,0,G2H16(19),n2h16(73))
  call Hloop_WQ_A(ntryL,G1H32(80),ex1(:),G1H16(65),m3h2x16(:,120),heltab2x32(:,:,180))
  call Hloop_Q_A(ntryL,G1H16(65),33,0,G2H16(20),n2h16(74))
  call Hloop_WQ_A(ntryL,G1H32(81),ex1(:),G1H16(65),m3h2x16(:,121),heltab2x32(:,:,181))
  call Hloop_Q_A(ntryL,G1H16(65),33,0,G2H16(21),n2h16(75))
  call Hloop_WQ_A(ntryL,G1H32(82),ex1(:),G1H16(65),m3h2x16(:,122),heltab2x32(:,:,182))
  call Hloop_Q_A(ntryL,G1H16(65),33,0,G2H16(22),n2h16(76))
  call Hloop_AV_Q(ntryL,G1H32(83),wf4(:,13),G1H8(65),m3h4x8(:,61),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G1H8(65),44,0,G2H8(47),n2h8(93))
  call Hloop_AV_Q(ntryL,G1H32(84),wf4(:,13),G1H8(66),m3h4x8(:,62),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G1H8(66),44,0,G2H8(48),n2h8(94))
  call Hloop_AZ_Q(ntryL,G1H32(85),wf4(:,16),G1H8(67),ngZl,m3h4x8(:,63),heltab2x32(:,:,185))
  call Hloop_A_Q(ntryL,G1H8(67),44,0,G2H8(49),n2h8(95))
  call Hloop_AZ_Q(ntryL,G1H32(86),wf4(:,16),G1H8(68),ngZl,m3h4x8(:,64),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G1H8(68),44,0,G2H8(50),n2h8(96))
  call Hloop_SV_V(ntryL,G1H32(87),wf4(:,13),G1H8(71),m3h4x8(:,65),heltab2x32(:,:,187))
  call Hloop_SV_V(ntryL,G1H32(88),wf4(:,16),G1H8(72),m3h4x8(:,66),heltab2x32(:,:,188))
  call Hloop_UW_V(ntryL,G0H32(43),32,wf4(:,13),12,G1H8(73),m3h4x8(:,67),heltab2x32(:,:,189))
  call Hloop_UW_V(ntryL,G0H32(44),32,wf4(:,16),12,G1H8(74),m3h4x8(:,68),heltab2x32(:,:,190))
  call Hloop_SV_V(ntryL,G0H32(45),wf4(:,13),G0H8(11),m3h4x8(:,69),heltab2x32(:,:,191))
  call Hloop_SV_V(ntryL,G0H32(46),wf4(:,16),G0H8(12),m3h4x8(:,70),heltab2x32(:,:,192))
  call Hloop_UW_V(ntryL,G1H32(89),32,wf4(:,13),12,G2H8(51),m3h4x8(:,71),heltab2x32(:,:,193))
  call Hloop_UW_V(ntryL,G1H32(90),32,wf4(:,16),12,G2H8(52),m3h4x8(:,72),heltab2x32(:,:,194))
  call Hloop_QA_V(ntryL,G1H32(91),ex2(:),G1H16(65),m3h2x16(:,123),heltab2x32(:,:,195))
  call Hloop_QA_Z(ntryL,G1H32(92),ex2(:),G1H16(66),ngZl,m3h2x16(:,124),heltab2x32(:,:,196))
  call Hloop_QA_V(ntryL,G1H32(93),ex2(:),G1H16(67),m3h2x16(:,125),heltab2x32(:,:,197))
  call Hloop_QA_Z(ntryL,G1H32(94),ex2(:),G1H16(68),ngZl,m3h2x16(:,126),heltab2x32(:,:,198))
  call Hloop_WA_Q(ntryL,G0H32(47),ex2(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,199))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(69),n2h16(77))
  call Hloop_WA_Q(ntryL,G0H32(48),ex2(:),G0H16(2),m3h2x16(:,128),heltab2x32(:,:,200))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(70),n2h16(78))
  call Hloop_WA_Q(ntryL,G0H32(49),ex2(:),G0H16(1),m3h2x16(:,129),heltab2x32(:,:,201))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(71),n2h16(79))
  call Hloop_WA_Q(ntryL,G0H32(50),ex2(:),G0H16(2),m3h2x16(:,130),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(72),n2h16(80))
  call Hloop_WA_Q(ntryL,G1H32(95),ex2(:),G1H16(73),m3h2x16(:,131),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G1H16(73),34,0,G2H16(23),n2h16(81))
  call Hloop_WA_Q(ntryL,G1H32(96),ex2(:),G1H16(73),m3h2x16(:,132),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G1H16(73),34,0,G2H16(24),n2h16(82))
  call Hloop_WA_Q(ntryL,G1H32(97),ex2(:),G1H16(73),m3h2x16(:,133),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G1H16(73),34,0,G2H16(25),n2h16(83))
  call Hloop_WA_Q(ntryL,G1H32(98),ex2(:),G1H16(73),m3h2x16(:,134),heltab2x32(:,:,206))
  call Hloop_A_Q(ntryL,G1H16(73),34,0,G2H16(26),n2h16(84))
  call Hloop_WA_Q(ntryL,G0H32(51),ex2(:),G0H16(1),m3h2x16(:,135),heltab2x32(:,:,207))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(73),n2h16(85))
  call Hloop_WA_Q(ntryL,G1H32(99),ex2(:),G1H16(74),m3h2x16(:,136),heltab2x32(:,:,208))
  call Hloop_A_Q(ntryL,G1H16(74),34,0,G2H16(27),n2h16(86))
  call Hloop_WQ_A(ntryL,G0H32(52),ex1(:),G0H16(2),m3h2x16(:,137),heltab2x32(:,:,209))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(74),n2h16(87))
  call Hloop_WQ_A(ntryL,G1H32(100),ex1(:),G1H16(75),m3h2x16(:,138),heltab2x32(:,:,210))
  call Hloop_Q_A(ntryL,G1H16(75),33,0,G2H16(28),n2h16(88))
  call Hloop_QA_V(ntryL,G1H32(101),ex2(:),G1H16(75),m3h2x16(:,139),heltab2x32(:,:,211))
  call Hloop_QA_V(ntryL,G1H32(102),ex2(:),G1H16(76),m3h2x16(:,140),heltab2x32(:,:,212))
  call Hloop_QA_Z(ntryL,G1H32(103),ex2(:),G1H16(77),ngZl,m3h2x16(:,141),heltab2x32(:,:,213))
  call Hloop_QA_Z(ntryL,G1H32(104),ex2(:),G1H16(78),ngZl,m3h2x16(:,142),heltab2x32(:,:,214))
  call Hloop_WA_Q(ntryL,G1H32(105),ex4(:),G1H16(79),m3h2x16(:,143),heltab2x32(:,:,215))
  call Hloop_A_Q(ntryL,G1H16(79),40,0,G2H16(29),n2h16(89))
  call Hloop_AQ_V(ntryL,G1H32(106),ex3(:),G1H16(79),m3h2x16(:,144),heltab2x32(:,:,216))
  call Hloop_AQ_V(ntryL,G1H32(107),ex3(:),G1H16(80),m3h2x16(:,145),heltab2x32(:,:,217))
  call Hloop_AQ_Z(ntryL,G1H32(108),ex3(:),G1H16(81),ngZl,m3h2x16(:,146),heltab2x32(:,:,218))
  call Hloop_AQ_Z(ntryL,G1H32(109),ex3(:),G1H16(82),ngZl,m3h2x16(:,147),heltab2x32(:,:,219))
  call Hloop_QA_V(ntryL,G1H32(110),ex2(:),G1H16(83),m3h2x16(:,148),heltab2x32(:,:,220))
  call Hloop_QA_V(ntryL,G1H32(111),ex2(:),G1H16(84),m3h2x16(:,149),heltab2x32(:,:,221))
  call Hloop_QA_Z(ntryL,G1H32(112),ex2(:),G1H16(85),ngZl,m3h2x16(:,150),heltab2x32(:,:,222))
  call Hloop_QA_Z(ntryL,G1H32(113),ex2(:),G1H16(86),ngZl,m3h2x16(:,151),heltab2x32(:,:,223))
  call Hloop_AQ_V(ntryL,G1H32(114),ex3(:),G1H16(87),m3h2x16(:,152),heltab2x32(:,:,224))
  call Hloop_AQ_Z(ntryL,G1H32(115),ex3(:),G1H16(88),ngZl,m3h2x16(:,153),heltab2x32(:,:,225))
  call Hloop_AQ_V(ntryL,G1H32(116),ex3(:),G1H16(89),m3h2x16(:,154),heltab2x32(:,:,226))
  call Hloop_AQ_Z(ntryL,G1H32(117),ex3(:),G1H16(90),ngZl,m3h2x16(:,155),heltab2x32(:,:,227))
  call Hloop_WA_Q(ntryL,G1H32(118),ex2(:),G1H16(91),m3h2x16(:,156),heltab2x32(:,:,228))
  call Hloop_A_Q(ntryL,G1H16(91),34,0,G2H16(30),n2h16(90))
  call Hloop_AQ_V(ntryL,G1H32(119),ex1(:),G1H16(91),m3h2x16(:,157),heltab2x32(:,:,229))
  call Hloop_AQ_V(ntryL,G1H32(120),ex1(:),G1H16(92),m3h2x16(:,158),heltab2x32(:,:,230))
  call Hloop_AQ_Z(ntryL,G1H32(121),ex1(:),G1H16(93),ngZl,m3h2x16(:,159),heltab2x32(:,:,231))
  call Hloop_AQ_Z(ntryL,G1H32(122),ex1(:),G1H16(94),ngZl,m3h2x16(:,160),heltab2x32(:,:,232))
  call Hloop_AQ_V(ntryL,G1H32(123),ex3(:),G1H16(95),m3h2x16(:,161),heltab2x32(:,:,233))
  call Hloop_AQ_V(ntryL,G1H32(124),ex3(:),G1H16(96),m3h2x16(:,162),heltab2x32(:,:,234))
  call Hloop_AQ_Z(ntryL,G1H32(125),ex3(:),G1H16(97),ngZl,m3h2x16(:,163),heltab2x32(:,:,235))
  call Hloop_AQ_Z(ntryL,G1H32(126),ex3(:),G1H16(98),ngZl,m3h2x16(:,164),heltab2x32(:,:,236))
  call Hloop_AQ_V(ntryL,G1H32(127),ex1(:),G1H16(99),m3h2x16(:,165),heltab2x32(:,:,237))
  call Hloop_AQ_V(ntryL,G1H32(128),ex1(:),G1H16(100),m3h2x16(:,166),heltab2x32(:,:,238))
  call Hloop_AQ_Z(ntryL,G1H32(129),ex1(:),G1H16(101),ngZl,m3h2x16(:,167),heltab2x32(:,:,239))
  call Hloop_AQ_Z(ntryL,G1H32(130),ex1(:),G1H16(102),ngZl,m3h2x16(:,168),heltab2x32(:,:,240))
  call Hloop_WQ_A(ntryL,G1H32(131),ex3(:),G1H16(103),m3h2x16(:,169),heltab2x32(:,:,241))
  call Hloop_Q_A(ntryL,G1H16(103),36,0,G2H16(31),n2h16(91))
  call Hloop_AQ_V(ntryL,G1H32(132),ex3(:),G1H16(103),m3h2x16(:,170),heltab2x32(:,:,242))
  call Hloop_AQ_Z(ntryL,G1H32(133),ex3(:),G1H16(104),ngZl,m3h2x16(:,171),heltab2x32(:,:,243))
  call Hloop_AQ_V(ntryL,G1H32(134),ex3(:),G1H16(105),m3h2x16(:,172),heltab2x32(:,:,244))
  call Hloop_AQ_Z(ntryL,G1H32(135),ex3(:),G1H16(106),ngZl,m3h2x16(:,173),heltab2x32(:,:,245))
  call Hloop_WQ_A(ntryL,G1H32(136),ex1(:),G1H16(107),m3h2x16(:,174),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G1H16(107),33,0,G2H16(32),n2h16(92))
  call Hloop_WA_Q(ntryL,G1H32(137),ex2(:),G1H16(107),m3h2x16(:,175),heltab2x32(:,:,247))
  call Hloop_A_Q(ntryL,G1H16(107),34,0,G2H16(33),n2h16(93))
  call Hloop_QA_V(ntryL,G1H32(138),ex4(:),G1H16(107),m3h2x16(:,176),heltab2x32(:,:,248))
  call Hloop_QA_V(ntryL,G1H32(139),ex4(:),G1H16(108),m3h2x16(:,177),heltab2x32(:,:,249))
  call Hloop_QA_Z(ntryL,G1H32(140),ex4(:),G1H16(109),ngZl,m3h2x16(:,178),heltab2x32(:,:,250))
  call Hloop_QA_Z(ntryL,G1H32(141),ex4(:),G1H16(110),ngZl,m3h2x16(:,179),heltab2x32(:,:,251))
  call Hloop_WQ_A(ntryL,G1H32(142),ex1(:),G1H16(111),m3h2x16(:,180),heltab2x32(:,:,252))
  call Hloop_Q_A(ntryL,G1H16(111),33,0,G2H16(34),n2h16(94))
  call Hloop_QA_V(ntryL,G1H32(143),ex4(:),G1H16(111),m3h2x16(:,181),heltab2x32(:,:,253))
  call Hloop_QA_Z(ntryL,G1H32(144),ex4(:),G1H16(112),ngZl,m3h2x16(:,182),heltab2x32(:,:,254))
  call Hloop_QA_V(ntryL,G1H32(145),ex4(:),G1H16(113),m3h2x16(:,183),heltab2x32(:,:,255))
  call Hloop_QA_Z(ntryL,G1H32(146),ex4(:),G1H16(114),ngZl,m3h2x16(:,184),heltab2x32(:,:,256))
  call Hloop_AQ_V(ntryL,G1H32(147),ex1(:),G1H16(115),m3h2x16(:,185),heltab2x32(:,:,257))
  call Hloop_AQ_V(ntryL,G1H32(148),ex1(:),G1H16(116),m3h2x16(:,186),heltab2x32(:,:,258))
  call Hloop_AQ_Z(ntryL,G1H32(149),ex1(:),G1H16(117),ngZl,m3h2x16(:,187),heltab2x32(:,:,259))
  call Hloop_AQ_Z(ntryL,G1H32(150),ex1(:),G1H16(118),ngZl,m3h2x16(:,188),heltab2x32(:,:,260))
  call Hloop_AQ_V(ntryL,G1H32(151),ex1(:),G1H16(119),m3h2x16(:,189),heltab2x32(:,:,261))
  call Hloop_AQ_V(ntryL,G1H32(152),ex1(:),G1H16(120),m3h2x16(:,190),heltab2x32(:,:,262))
  call Hloop_AQ_Z(ntryL,G1H32(153),ex1(:),G1H16(121),ngZl,m3h2x16(:,191),heltab2x32(:,:,263))
  call Hloop_AQ_Z(ntryL,G1H32(154),ex1(:),G1H16(122),ngZl,m3h2x16(:,192),heltab2x32(:,:,264))
  call Hloop_AQ_V(ntryL,G1H32(155),ex3(:),G1H16(123),m3h2x16(:,193),heltab2x32(:,:,265))
  call Hloop_AQ_V(ntryL,G1H32(156),ex3(:),G1H16(124),m3h2x16(:,194),heltab2x32(:,:,266))
  call Hloop_AQ_Z(ntryL,G1H32(157),ex3(:),G1H16(125),ngZl,m3h2x16(:,195),heltab2x32(:,:,267))
  call Hloop_AQ_Z(ntryL,G1H32(158),ex3(:),G1H16(126),ngZl,m3h2x16(:,196),heltab2x32(:,:,268))
  call Hloop_WQ_A(ntryL,G1H32(159),ex1(:),G1H16(127),m3h2x16(:,197),heltab2x32(:,:,269))
  call Hloop_Q_A(ntryL,G1H16(127),33,0,G2H16(35),n2h16(95))
  call Hloop_AQ_V(ntryL,G1H32(160),ex3(:),G1H16(127),m3h2x16(:,198),heltab2x32(:,:,270))
  call Hloop_AQ_Z(ntryL,G1H32(161),ex3(:),G1H16(128),ngZl,m3h2x16(:,199),heltab2x32(:,:,271))
  call Hloop_AQ_V(ntryL,G1H32(162),ex3(:),G1H16(129),m3h2x16(:,200),heltab2x32(:,:,272))
  call Hloop_AQ_Z(ntryL,G1H32(163),ex3(:),G1H16(130),ngZl,m3h2x16(:,201),heltab2x32(:,:,273))
  call Hloop_WA_Q(ntryL,G1H32(164),ex2(:),G1H16(131),m3h2x16(:,202),heltab2x32(:,:,274))
  call Hloop_A_Q(ntryL,G1H16(131),34,0,G2H16(36),n2h16(96))
  call Hloop_AQ_V(ntryL,G1H32(165),ex1(:),G1H16(131),m3h2x16(:,203),heltab2x32(:,:,275))
  call Hloop_AQ_V(ntryL,G1H32(166),ex1(:),G1H16(132),m3h2x16(:,204),heltab2x32(:,:,276))
  call Hloop_AQ_Z(ntryL,G1H32(167),ex1(:),G1H16(133),ngZl,m3h2x16(:,205),heltab2x32(:,:,277))
  call Hloop_AQ_Z(ntryL,G1H32(168),ex1(:),G1H16(134),ngZl,m3h2x16(:,206),heltab2x32(:,:,278))
  call Hloop_AQ_V(ntryL,G1H32(169),ex1(:),G1H16(135),m3h2x16(:,207),heltab2x32(:,:,279))
  call Hloop_AQ_V(ntryL,G1H32(170),ex1(:),G1H16(136),m3h2x16(:,208),heltab2x32(:,:,280))
  call Hloop_AQ_Z(ntryL,G1H32(171),ex1(:),G1H16(137),ngZl,m3h2x16(:,209),heltab2x32(:,:,281))
  call Hloop_AQ_Z(ntryL,G1H32(172),ex1(:),G1H16(138),ngZl,m3h2x16(:,210),heltab2x32(:,:,282))
  call Hloop_VA_Q(ntryL,G0H16(3),ex4(:),G0H8(13),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G0H8(13),41,0,G1H8(77),n2h8(97))
  call Hloop_ZA_Q(ntryL,G0H16(4),ex4(:),G0H8(13),ngZl,m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G0H8(13),41,0,G1H8(78),n2h8(98))
  call Hloop_VA_Q(ntryL,G0H16(5),ex4(:),G0H8(13),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G0H8(13),41,0,G1H8(79),n2h8(99))
  call Hloop_ZA_Q(ntryL,G0H16(6),ex4(:),G0H8(13),ngZl,m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G0H8(13),41,0,G1H8(80),n2h8(100))
  call Hloop_QA_W(ntryL,G1H16(1),ex2(:),G1H8(83),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_QA_V(ntryL,G1H16(2),ex2(:),G1H8(84),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_QA_V(ntryL,G1H16(3),ex2(:),G1H8(85),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_QA_Z(ntryL,G1H16(4),ex2(:),G1H8(86),ngZl,m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_QA_Z(ntryL,G1H16(5),ex2(:),G1H8(89),ngZl,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_VQ_A(ntryL,G0H16(7),ex3(:),G0H8(13),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(90),n2h8(101))
  call Hloop_ZQ_A(ntryL,G0H16(8),ex3(:),G0H8(13),ngZl,m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(91),n2h8(102))
  call Hloop_VQ_A(ntryL,G0H16(9),ex3(:),G0H8(13),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(92),n2h8(103))
  call Hloop_ZQ_A(ntryL,G0H16(10),ex3(:),G0H8(13),ngZl,m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(95),n2h8(104))
  call Hloop_QA_V(ntryL,G1H16(6),ex2(:),G1H8(96),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_QA_V(ntryL,G1H16(7),ex2(:),G1H8(97),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_QA_Z(ntryL,G1H16(8),ex2(:),G1H8(98),ngZl,m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_QA_Z(ntryL,G1H16(9),ex2(:),G1H8(101),ngZl,m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_QA_W(ntryL,G1H16(10),ex2(:),G1H8(102),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_VA_Q(ntryL,G0H16(11),ex4(:),G0H8(13),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(103),n2h8(105))
  call Hloop_ZA_Q(ntryL,G0H16(12),ex4(:),G0H8(13),ngZl,m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(104),n2h8(106))
  call Hloop_VA_Q(ntryL,G0H16(13),ex4(:),G0H8(13),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(107),n2h8(107))
  call Hloop_ZA_Q(ntryL,G0H16(14),ex4(:),G0H8(13),ngZl,m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(108),n2h8(108))
  call Hloop_AQ_V(ntryL,G1H16(11),ex1(:),G1H8(109),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_AQ_V(ntryL,G1H16(12),ex1(:),G1H8(110),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_AQ_Z(ntryL,G1H16(13),ex1(:),G1H8(113),ngZl,m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex1(:),G1H8(114),ngZl,m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_VQ_A(ntryL,G0H16(15),ex3(:),G0H8(13),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G0H8(13),38,0,G1H8(115),n2h8(109))
  call Hloop_ZQ_A(ntryL,G0H16(16),ex3(:),G0H8(13),ngZl,m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G0H8(13),38,0,G1H8(116),n2h8(110))
  call Hloop_VQ_A(ntryL,G0H16(17),ex3(:),G0H8(13),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G0H8(13),38,0,G1H8(119),n2h8(111))
  call Hloop_ZQ_A(ntryL,G0H16(18),ex3(:),G0H8(13),ngZl,m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G0H8(13),38,0,G1H8(120),n2h8(112))
  call Hloop_AQ_W(ntryL,G1H16(15),ex1(:),G1H8(121),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_AQ_V(ntryL,G1H16(16),ex1(:),G1H8(122),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_AQ_V(ntryL,G1H16(17),ex1(:),G1H8(125),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_AQ_Z(ntryL,G1H16(18),ex1(:),G1H8(126),ngZl,m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_AQ_Z(ntryL,G1H16(19),ex1(:),G1H8(127),ngZl,m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_AQ_W(ntryL,G1H16(20),ex1(:),G1H8(128),m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_QA_W(ntryL,G1H16(21),ex4(:),G1H8(131),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_VA_Q(ntryL,G0H16(19),ex2(:),G0H8(13),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G0H8(13),38,0,G1H8(132),n2h8(113))
  call Hloop_ZA_Q(ntryL,G0H16(20),ex2(:),G0H8(13),ngZl,m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G0H8(13),38,0,G1H8(8),n2h8(114))
  call Hloop_VA_Q(ntryL,G0H16(21),ex2(:),G0H8(13),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G0H8(13),38,0,G1H8(9),n2h8(115))
  call Hloop_ZA_Q(ntryL,G0H16(22),ex2(:),G0H8(13),ngZl,m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G0H8(13),38,0,G1H8(2),n2h8(116))
  call Hloop_WA_Q(ntryL,G0H16(23),ex2(:),G0H8(13),m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G0H8(13),38,0,G1H8(10),n2h8(117))
  call Hloop_VQ_A(ntryL,G0H16(24),ex1(:),G0H8(13),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(18),n2h8(118))
  call Hloop_VQ_A(ntryL,G0H16(25),ex1(:),G0H8(13),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(19),n2h8(119))
  call Hloop_ZQ_A(ntryL,G0H16(26),ex1(:),G0H8(13),ngZl,m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(20),n2h8(120))
  call Hloop_ZQ_A(ntryL,G0H16(27),ex1(:),G0H8(13),ngZl,m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(21),n2h8(121))
  call Hloop_VA_Q(ntryL,G0H16(28),ex2(:),G0H8(13),m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G0H8(13),38,0,G1H8(29),n2h8(122))
  call Hloop_ZA_Q(ntryL,G0H16(29),ex2(:),G0H8(13),ngZl,m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G0H8(13),38,0,G1H8(30),n2h8(123))
  call Hloop_VA_Q(ntryL,G0H16(30),ex2(:),G0H8(13),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G0H8(13),38,0,G1H8(31),n2h8(124))
  call Hloop_ZA_Q(ntryL,G0H16(31),ex2(:),G0H8(13),ngZl,m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G0H8(13),38,0,G1H8(32),n2h8(125))
  call Hloop_VQ_A(ntryL,G0H16(32),ex1(:),G0H8(13),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(41),n2h8(126))
  call Hloop_VQ_A(ntryL,G0H16(33),ex1(:),G0H8(13),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(42),n2h8(127))
  call Hloop_ZQ_A(ntryL,G0H16(34),ex1(:),G0H8(13),ngZl,m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(43),n2h8(128))
  call Hloop_ZQ_A(ntryL,G0H16(35),ex1(:),G0H8(13),ngZl,m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G0H8(13),37,0,G1H8(44),n2h8(129))
  call Hloop_VA_Q(ntryL,G0H16(36),ex2(:),G0H8(13),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(53),n2h8(130))
  call Hloop_ZA_Q(ntryL,G0H16(37),ex2(:),G0H8(13),ngZl,m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(54),n2h8(131))
  call Hloop_VA_Q(ntryL,G0H16(38),ex2(:),G0H8(13),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(55),n2h8(132))
  call Hloop_ZA_Q(ntryL,G0H16(39),ex2(:),G0H8(13),ngZl,m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(56),n2h8(133))
  call Hloop_AQ_W(ntryL,G1H16(22),ex3(:),G1H8(65),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_VQ_A(ntryL,G0H16(40),ex1(:),G0H8(13),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(66),n2h8(134))
  call Hloop_VQ_A(ntryL,G0H16(41),ex1(:),G0H8(13),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(67),n2h8(135))
  call Hloop_ZQ_A(ntryL,G0H16(42),ex1(:),G0H8(13),ngZl,m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(68),n2h8(136))
  call Hloop_ZQ_A(ntryL,G0H16(43),ex1(:),G0H8(13),ngZl,m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(133),n2h8(137))
  call Hloop_WQ_A(ntryL,G0H16(44),ex1(:),G0H8(13),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(134),n2h8(138))
  call Hloop_VA_Q(ntryL,G0H16(45),ex2(:),G0H8(13),m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(135),n2h8(139))
  call Hloop_ZA_Q(ntryL,G0H16(46),ex2(:),G0H8(13),ngZl,m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(136),n2h8(140))
  call Hloop_VA_Q(ntryL,G0H16(47),ex2(:),G0H8(13),m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(137),n2h8(141))
  call Hloop_ZA_Q(ntryL,G0H16(48),ex2(:),G0H8(13),ngZl,m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G0H8(13),42,0,G1H8(138),n2h8(142))
  call Hloop_VQ_A(ntryL,G0H16(49),ex1(:),G0H8(13),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(139),n2h8(143))
  call Hloop_VQ_A(ntryL,G0H16(50),ex1(:),G0H8(13),m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(140),n2h8(144))
  call Hloop_ZQ_A(ntryL,G0H16(51),ex1(:),G0H8(13),ngZl,m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(141),n2h8(145))
  call Hloop_ZQ_A(ntryL,G0H16(52),ex1(:),G0H8(13),ngZl,m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(142),n2h8(146))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(131),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(52),[G2H8(51),G1H8(7),G0H8(12),G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(121),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(27),G1H8(12),G0H8(4),G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(65),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(46),[G2H8(45),G1H8(17),G0H8(10),G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(128),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(34),[G2H8(33),G1H8(23),G0H8(6),G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(83),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G2H8(39),G1H8(28),G0H8(8),G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(102),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G2H8(21),G1H8(34),G0H8(2),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(41),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(52),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(58),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(43),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(94),[G1H8(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(106),[G1H8(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(124),[G1H8(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(130),[G1H8(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G2H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G2H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(3),G1H8(14),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(25),[G2H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G2H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(4),G1H8(25),G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G2H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G2H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(37),G1H8(36),G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G2H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(38),[G2H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(49),G1H8(48),G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G2H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G2H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(62),[G1H8(61),G1H8(60),G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G2H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G2H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(74),[G1H8(73),G1H8(72),G1H8(71)])
  call Hloop_WQ_A(ntryL,G1H8(131),ex1(:),G1H4(200),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(200),45,0,G2H4(33),n2h4(101))
  call Hotf_5pt_reduction(G2H8(52),RedSet_5(21),mass5set(:,7),  & 
G1H8(6),G1H8(7),G1H8(11),G1H8(12),G1H8(16),G1H8(17),8)
  call HG1shiftOLR(G1H8(7),16,8)
  call Hloop_WA_Q(ntryL,G1H8(121),ex4(:),G1H4(212),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(212),43,0,G2H4(34),n2h4(102))
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(22),mass5set(:,7),  & 
G1H8(22),G1H8(23),G1H8(27),G1H8(28),G1H8(33),G1H8(34),8)
  call HG1shiftOLR(G1H8(23),16,8)
  call Hloop_WA_Q(ntryL,G1H8(65),ex2(:),G1H4(3),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(3),46,0,G2H4(35),n2h4(103))
  call Hotf_5pt_reduction(G2H8(46),RedSet_5(23),mass5set(:,7),  & 
G1H8(39),G1H8(40),G1H8(45),G1H8(46),G1H8(51),G1H8(57),8)
  call HG1shiftOLR(G1H8(40),16,8)
  call Hloop_UV_W(ntryL,G1H8(128),35,ex5(:),16,G2H4(36),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(24),mass5set(:,8),  & 
G1H8(64),G1H8(70),G1H8(87),G1H8(88),G1H8(93),G1H8(99),8)
  call HG1shiftOLR(G1H8(70),4,8)
  call Hloop_WQ_A(ntryL,G1H8(83),ex3(:),G1H4(4),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(4),39,0,G2H4(37),n2h4(104))
  call Hotf_5pt_reduction(G2H8(40),RedSet_5(25),mass5set(:,7),  & 
G1H8(100),G1H8(105),G1H8(112),G1H8(118),G1H8(3),G1H8(14),8)
  call HG1shiftOLR(G1H8(105),16,8)
  call Hloop_UW_V(ntryL,G1H8(102),35,ex5(:),16,G2H4(40),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(26),mass5set(:,8),  & 
G1H8(13),G1H8(4),G1H8(25),G1H8(24),G1H8(37),G1H8(36),8)
  call HG1shiftOLR(G1H8(4),8,8)
  call Hloop_QV_A(ntryL,G1H8(41),ex5(:),G1H4(8),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(8),53,0,G2H4(41),n2h4(105))
  call Hloop_QV_A(ntryL,G1H8(52),ex5(:),G1H4(9),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(9),53,0,G2H4(44),n2h4(106))
  call Hloop_QV_A(ntryL,G1H8(42),ex5(:),G1H4(10),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(10),53,0,G2H4(45),n2h4(107))
  call Hloop_QV_A(ntryL,G1H8(58),ex5(:),G1H4(14),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(14),53,0,G2H4(48),n2h4(108))
  call Hloop_QV_A(ntryL,G1H8(43),ex5(:),G1H4(15),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(15),53,0,G2H4(49),n2h4(109))
  call Hloop_QV_A(ntryL,G1H8(44),ex5(:),G1H4(16),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(16),53,0,G2H4(51),n2h4(110))
  call Hloop_QV_A(ntryL,G1H8(63),ex5(:),G1H4(20),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(20),53,0,G2H4(52),n2h4(111))
  call Hloop_QV_A(ntryL,G1H8(76),ex5(:),G1H4(21),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(21),53,0,G2H4(55),n2h4(112))
  call Hloop_QV_A(ntryL,G1H8(69),ex5(:),G1H4(22),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(22),53,0,G2H4(56),n2h4(113))
  call Hloop_QV_A(ntryL,G1H8(82),ex5(:),G1H4(26),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(26),53,0,G2H4(58),n2h4(114))
  call Hloop_QV_A(ntryL,G1H8(75),ex5(:),G1H4(27),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(27),53,0,G2H4(59),n2h4(115))
  call Hloop_QV_A(ntryL,G1H8(81),ex5(:),G1H4(28),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(28),53,0,G2H4(62),n2h4(116))
  call Hloop_AV_Q(ntryL,G1H8(29),ex5(:),G1H4(32),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(32),54,0,G2H4(63),n2h4(117))
  call Hloop_AV_Q(ntryL,G1H8(94),ex5(:),G1H4(33),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(33),54,0,G2H4(66),n2h4(118))
  call Hloop_AV_Q(ntryL,G1H8(30),ex5(:),G1H4(34),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(34),54,0,G2H4(67),n2h4(119))
  call Hloop_AV_Q(ntryL,G1H8(31),ex5(:),G1H4(38),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(38),54,0,G2H4(70),n2h4(120))
  call Hloop_AV_Q(ntryL,G1H8(106),ex5(:),G1H4(39),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(39),54,0,G2H4(71),n2h4(121))
  call Hloop_AV_Q(ntryL,G1H8(32),ex5(:),G1H4(40),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(40),54,0,G2H4(74),n2h4(122))
  call Hloop_AV_Q(ntryL,G1H8(111),ex5(:),G1H4(44),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(44),57,0,G2H4(75),n2h4(123))
  call Hloop_AV_Q(ntryL,G1H8(124),ex5(:),G1H4(45),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_A_Q(ntryL,G1H4(45),57,0,G2H4(78),n2h4(124))
  call Hloop_AV_Q(ntryL,G1H8(117),ex5(:),G1H4(46),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(46),57,0,G2H4(79),n2h4(125))
  call Hloop_AV_Q(ntryL,G1H8(130),ex5(:),G1H4(50),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H4(50),57,0,G2H4(82),n2h4(126))
  call Hloop_AV_Q(ntryL,G1H8(123),ex5(:),G1H4(51),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(51),57,0,G2H4(83),n2h4(127))
  call Hloop_AV_Q(ntryL,G1H8(129),ex5(:),G1H4(52),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G1H4(52),57,0,G2H4(86),n2h4(128))
  call Hloop_AQ_W(ntryL,G1H8(5),ex1(:),G1H4(56),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_QA_W(ntryL,G1H8(1),ex2(:),G1H4(57),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(26),mass5set(:,3),  & 
G1H8(35),G1H8(49),G1H8(48),G1H8(47),G1H8(61),G1H8(60),8)
  call HG1shiftOLR(G1H8(49),8,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(26),mass5set(:,5),  & 
G1H8(59),G1H8(73),G1H8(72),G1H8(71),G1H8(131),G1H8(121),8)
  call HG1shiftOLR(G1H8(73),8,8)
  call Hloop_SV_V(ntryL,G1H8(15),ex5(:),G1H4(58),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_QA_V(ntryL,G2H8(25),ex4(:),G2H4(87),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_QA_Z(ntryL,G2H8(26),ex4(:),G2H4(90),ngZl,m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_WA_Q(ntryL,G1H8(26),ex4(:),G1H4(62),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G1H4(62),43,0,G2H4(91),n2h4(129))
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(24),mass5set(:,3),  & 
G1H8(65),G1H8(128),G1H8(83),G1H8(102),G1H8(41),G1H8(52),8)
  call HG1shiftOLR(G1H8(128),4,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(24),mass5set(:,5),  & 
G1H8(42),G1H8(58),G1H8(43),G1H8(44),G1H8(63),G1H8(76),8)
  call HG1shiftOLR(G1H8(58),4,8)
  call Hloop_SV_V(ntryL,G1H8(38),ex5(:),G1H4(63),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_VA_Q(ntryL,G1H16(23),ex4(:),G1H8(69),m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H8(69),44,0,G2H8(53),n2h8(147))
  call Hloop_ZA_Q(ntryL,G1H16(24),ex4(:),G1H8(82),ngZl,m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G1H8(82),44,0,G2H8(54),n2h8(148))
  call Hloop_VA_Q(ntryL,G1H16(25),ex4(:),G1H8(75),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H8(75),44,0,G2H8(1),n2h8(149))
  call Hloop_ZA_Q(ntryL,G1H16(26),ex4(:),G1H8(81),ngZl,m3h2x8(:,136),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G1H8(81),44,0,G2H8(2),n2h8(150))
  call Hloop_QA_W(ntryL,G1H16(27),ex4(:),G1H8(29),m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_QA_W(ntryL,G1H16(28),ex4(:),G1H8(94),m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_QA_W(ntryL,G1H16(29),ex4(:),G1H8(30),m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_QA_W(ntryL,G1H16(30),ex4(:),G1H8(31),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_QA_W(ntryL,G2H16(1),ex4(:),G2H8(3),m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_QA_W(ntryL,G2H16(2),ex4(:),G2H8(4),m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_QA_W(ntryL,G2H16(3),ex4(:),G2H8(5),m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_QA_W(ntryL,G2H16(4),ex4(:),G2H8(6),m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_AQ_V(ntryL,G2H8(37),ex3(:),G2H4(94),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_AQ_Z(ntryL,G2H8(38),ex3(:),G2H4(95),ngZl,m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_WQ_A(ntryL,G1H8(50),ex3(:),G1H4(64),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(64),39,0,G2H4(98),n2h4(130))
  call Hloop_VQ_A(ntryL,G1H16(35),ex3(:),G1H8(106),m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H8(106),44,0,G2H8(7),n2h8(151))
  call Hloop_ZQ_A(ntryL,G1H16(36),ex3(:),G1H8(32),ngZl,m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H8(32),44,0,G2H8(8),n2h8(152))
  call Hloop_VQ_A(ntryL,G1H16(37),ex3(:),G1H8(111),m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G1H8(111),44,0,G2H8(9),n2h8(153))
  call Hloop_ZQ_A(ntryL,G1H16(38),ex3(:),G1H8(124),ngZl,m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H8(124),44,0,G2H8(10),n2h8(154))
  call Hloop_AQ_W(ntryL,G1H16(39),ex3(:),G1H8(117),m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_AQ_W(ntryL,G1H16(40),ex3(:),G1H8(130),m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_AQ_W(ntryL,G1H16(41),ex3(:),G1H8(123),m3h2x8(:,151),heltab2x16(:,:,151))
  call Hloop_AQ_W(ntryL,G1H16(42),ex3(:),G1H8(129),m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_AQ_W(ntryL,G2H16(5),ex3(:),G2H8(11),m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_AQ_W(ntryL,G2H16(6),ex3(:),G2H8(12),m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_AQ_W(ntryL,G2H16(7),ex3(:),G2H8(13),m3h2x8(:,155),heltab2x16(:,:,155))
  call Hloop_AQ_W(ntryL,G2H16(8),ex3(:),G2H8(14),m3h2x8(:,156),heltab2x16(:,:,156))
  call Hloop_AZ_Q(ntryL,G1H16(47),wf4(:,6),G1H4(68),ngZn,m3h4x4(:,1),heltab2x16(:,:,157))
  call Hloop_A_Q(ntryL,G1H4(68),43,0,G2H4(99),n2h4(131))
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(27),mass5set(:,9),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hloop_QZ_A(ntryL,G1H16(49),wf4(:,6),G1H4(69),ngZn,m3h4x4(:,2),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H4(69),39,0,G2H4(102),n2h4(132))
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(28),mass5set(:,9),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),16,16)
  call Hloop_VQ_A(ntryL,G1H16(51),ex1(:),G1H8(5),m3h2x8(:,157),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G1H8(5),35,0,G2H8(15),n2h8(155))
  call Hloop_ZQ_A(ntryL,G1H16(52),ex1(:),G1H8(1),ngZl,m3h2x8(:,158),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(16),n2h8(156))
  call Hloop_VQ_A(ntryL,G1H16(31),ex1(:),G1H8(15),m3h2x8(:,159),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G1H8(15),35,0,G2H8(51),n2h8(157))
  call Hloop_ZQ_A(ntryL,G1H16(32),ex1(:),G1H8(26),ngZl,m3h2x8(:,160),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G1H8(26),35,0,G2H8(27),n2h8(158))
  call Hloop_AQ_W(ntryL,G1H16(33),ex1(:),G1H8(38),m3h2x8(:,161),heltab2x16(:,:,163))
  call Hloop_AQ_W(ntryL,G1H16(34),ex1(:),G1H8(69),m3h2x8(:,162),heltab2x16(:,:,164))
  call Hloop_AQ_W(ntryL,G2H16(11),ex1(:),G2H8(45),m3h2x8(:,163),heltab2x16(:,:,165))
  call Hloop_AQ_W(ntryL,G2H16(12),ex1(:),G2H8(33),m3h2x8(:,164),heltab2x16(:,:,166))
  call Hloop_AQ_W(ntryL,G1H16(45),ex1(:),G1H8(82),m3h2x8(:,165),heltab2x16(:,:,167))
  call Hloop_AQ_W(ntryL,G1H16(46),ex1(:),G1H8(75),m3h2x8(:,166),heltab2x16(:,:,168))
  call Hloop_AQ_W(ntryL,G2H16(13),ex1(:),G2H8(39),m3h2x8(:,167),heltab2x16(:,:,169))
  call Hloop_AQ_W(ntryL,G2H16(14),ex1(:),G2H8(21),m3h2x8(:,168),heltab2x16(:,:,170))
  call Hloop_QA_V(ntryL,G2H8(43),ex2(:),G2H4(103),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_QA_Z(ntryL,G2H8(44),ex2(:),G2H4(106),ngZl,m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_WA_Q(ntryL,G1H8(62),ex2(:),G1H4(70),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(70),46,0,G2H4(107),n2h4(133))
  call Hloop_VA_Q(ntryL,G1H16(43),ex2(:),G1H8(81),m3h2x8(:,169),heltab2x16(:,:,171))
  call Hloop_A_Q(ntryL,G1H8(81),35,0,G2H8(17),n2h8(159))
  call Hloop_ZA_Q(ntryL,G1H16(44),ex2(:),G1H8(50),ngZl,m3h2x8(:,170),heltab2x16(:,:,172))
  call Hloop_A_Q(ntryL,G1H8(50),35,0,G2H8(18),n2h8(160))
  call Hloop_VA_Q(ntryL,G1H16(48),ex2(:),G1H8(106),m3h2x8(:,171),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H8(106),35,0,G2H8(23),n2h8(161))
  call Hloop_ZA_Q(ntryL,G1H16(50),ex2(:),G1H8(32),ngZl,m3h2x8(:,172),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H8(32),35,0,G2H8(24),n2h8(162))
  call Hloop_QA_W(ntryL,G1H16(53),ex2(:),G1H8(111),m3h2x8(:,173),heltab2x16(:,:,175))
  call Hloop_QA_W(ntryL,G1H16(54),ex2(:),G1H8(124),m3h2x8(:,174),heltab2x16(:,:,176))
  call Hloop_QA_W(ntryL,G2H16(15),ex2(:),G2H8(29),m3h2x8(:,175),heltab2x16(:,:,177))
  call Hloop_QA_W(ntryL,G2H16(16),ex2(:),G2H8(30),m3h2x8(:,176),heltab2x16(:,:,178))
  call Hloop_QA_W(ntryL,G1H16(55),ex2(:),G1H8(5),m3h2x8(:,177),heltab2x16(:,:,179))
  call Hloop_QA_W(ntryL,G1H16(56),ex2(:),G1H8(1),m3h2x8(:,178),heltab2x16(:,:,180))
  call Hloop_QA_W(ntryL,G2H16(17),ex2(:),G2H8(35),m3h2x8(:,179),heltab2x16(:,:,181))
  call Hloop_QA_W(ntryL,G2H16(18),ex2(:),G2H8(36),m3h2x8(:,180),heltab2x16(:,:,182))
  call Hloop_VA_Q(ntryL,G1H16(57),ex2(:),G1H8(15),m3h2x8(:,181),heltab2x16(:,:,183))
  call Hloop_A_Q(ntryL,G1H8(15),35,0,G2H8(41),n2h8(163))
  call Hloop_ZA_Q(ntryL,G1H16(58),ex2(:),G1H8(26),ngZl,m3h2x8(:,182),heltab2x16(:,:,184))
  call Hloop_A_Q(ntryL,G1H8(26),35,0,G2H8(42),n2h8(164))
  call Hloop_VA_Q(ntryL,G1H16(59),ex2(:),G1H8(62),m3h2x8(:,183),heltab2x16(:,:,185))
  call Hloop_A_Q(ntryL,G1H8(62),35,0,G2H8(47),n2h8(165))
  call Hloop_ZA_Q(ntryL,G1H16(60),ex2(:),G1H8(81),ngZl,m3h2x8(:,184),heltab2x16(:,:,186))
  call Hloop_A_Q(ntryL,G1H8(81),35,0,G2H8(48),n2h8(166))
  call Hloop_QA_W(ntryL,G1H16(61),ex2(:),G1H8(50),m3h2x8(:,185),heltab2x16(:,:,187))
  call Hloop_QA_W(ntryL,G1H16(62),ex2(:),G1H8(106),m3h2x8(:,186),heltab2x16(:,:,188))
  call Hloop_QA_W(ntryL,G1H16(63),ex2(:),G1H8(32),m3h2x8(:,187),heltab2x16(:,:,189))
  call Hloop_QA_W(ntryL,G1H16(64),ex2(:),G1H8(15),m3h2x8(:,188),heltab2x16(:,:,190))
  call Hloop_QA_W(ntryL,G2H16(19),ex2(:),G2H8(52),m3h2x8(:,189),heltab2x16(:,:,191))
  call Hloop_QA_W(ntryL,G2H16(20),ex2(:),G2H8(28),m3h2x8(:,190),heltab2x16(:,:,192))
  call Hloop_QA_W(ntryL,G2H16(21),ex2(:),G2H8(46),m3h2x8(:,191),heltab2x16(:,:,193))
  call Hloop_QA_W(ntryL,G2H16(22),ex2(:),G2H8(34),m3h2x8(:,192),heltab2x16(:,:,194))
  call Hloop_AQ_V(ntryL,G2H8(49),ex1(:),G2H4(110),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_AQ_Z(ntryL,G2H8(50),ex1(:),G2H4(111),ngZl,m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_WQ_A(ntryL,G1H8(74),ex1(:),G1H4(74),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(74),45,0,G2H4(114),n2h4(134))
  call Hloop_VQ_A(ntryL,G1H16(65),ex1(:),G1H8(26),m3h2x8(:,193),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G1H8(26),35,0,G2H8(40),n2h8(167))
  call Hloop_ZQ_A(ntryL,G1H16(66),ex1(:),G1H8(62),ngZl,m3h2x8(:,194),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H8(62),35,0,G2H8(22),n2h8(168))
  call Hloop_VQ_A(ntryL,G1H16(67),ex1(:),G1H8(81),m3h2x8(:,195),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(81),35,0,G2H8(19),n2h8(169))
  call Hloop_ZQ_A(ntryL,G1H16(68),ex1(:),G1H8(74),ngZl,m3h2x8(:,196),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G1H8(74),35,0,G2H8(20),n2h8(170))
  call Hloop_AQ_W(ntryL,G1H16(69),ex1(:),G1H8(26),m3h2x8(:,197),heltab2x16(:,:,199))
  call Hloop_AQ_W(ntryL,G1H16(70),ex1(:),G1H8(62),m3h2x8(:,198),heltab2x16(:,:,200))
  call Hloop_AQ_W(ntryL,G1H16(71),ex1(:),G1H8(81),m3h2x8(:,199),heltab2x16(:,:,201))
  call Hloop_AQ_W(ntryL,G1H16(72),ex1(:),G1H8(74),m3h2x8(:,200),heltab2x16(:,:,202))
  call Hloop_AQ_W(ntryL,G2H16(23),ex1(:),G2H8(25),m3h2x8(:,201),heltab2x16(:,:,203))
  call Hloop_AQ_W(ntryL,G2H16(24),ex1(:),G2H8(26),m3h2x8(:,202),heltab2x16(:,:,204))
  call Hloop_AQ_W(ntryL,G2H16(25),ex1(:),G2H8(31),m3h2x8(:,203),heltab2x16(:,:,205))
  call Hloop_AQ_W(ntryL,G2H16(26),ex1(:),G2H8(32),m3h2x8(:,204),heltab2x16(:,:,206))
  call Hloop_AZ_Q(ntryL,G1H16(73),wf4(:,16),G1H4(75),ngZn,m3h4x4(:,3),heltab2x16(:,:,207))
  call Hloop_A_Q(ntryL,G1H4(75),46,0,G2H4(115),n2h4(135))
  call Hotf_5pt_reduction(G2H16(27),RedSet_5(29),mass5set(:,9),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),16,16)
  call Hloop_QZ_A(ntryL,G1H16(74),wf4(:,16),G1H4(76),ngZn,m3h4x4(:,4),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H4(76),45,0,G2H4(118),n2h4(136))
  call Hotf_5pt_reduction(G2H16(28),RedSet_5(30),mass5set(:,9),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),16,16)
  call Hloop_VQ_A(ntryL,G1H16(75),ex3(:),G1H8(143),m3h2x8(:,205),heltab2x16(:,:,209))
  call Hloop_Q_A(ntryL,G1H8(143),38,0,G2H8(37),n2h8(171))
  call Hloop_VQ_A(ntryL,G1H16(76),ex3(:),G1H8(143),m3h2x8(:,206),heltab2x16(:,:,210))
  call Hloop_Q_A(ntryL,G1H8(143),38,0,G2H8(38),n2h8(172))
  call Hloop_ZQ_A(ntryL,G1H16(77),ex3(:),G1H8(143),ngZl,m3h2x8(:,207),heltab2x16(:,:,211))
  call Hloop_Q_A(ntryL,G1H8(143),38,0,G2H8(43),n2h8(173))
  call Hloop_ZQ_A(ntryL,G1H16(78),ex3(:),G1H8(143),ngZl,m3h2x8(:,208),heltab2x16(:,:,212))
  call Hloop_Q_A(ntryL,G1H8(143),38,0,G2H8(44),n2h8(174))
  call Hloop_AQ_W(ntryL,G2H16(29),ex3(:),G2H8(49),m3h2x8(:,209),heltab2x16(:,:,213))
  call Hloop_VA_Q(ntryL,G1H16(79),ex2(:),G1H8(143),m3h2x8(:,210),heltab2x16(:,:,214))
  call Hloop_A_Q(ntryL,G1H8(143),38,0,G2H8(50),n2h8(175))
  call Hloop_VA_Q(ntryL,G1H16(80),ex2(:),G1H8(143),m3h2x8(:,211),heltab2x16(:,:,215))
  call Hloop_A_Q(ntryL,G1H8(143),38,0,G2H8(55),n2h8(176))
  call Hloop_ZA_Q(ntryL,G1H16(81),ex2(:),G1H8(143),ngZl,m3h2x8(:,212),heltab2x16(:,:,216))
  call Hloop_A_Q(ntryL,G1H8(143),38,0,G2H8(56),n2h8(177))
  call Hloop_ZA_Q(ntryL,G1H16(82),ex2(:),G1H8(143),ngZl,m3h2x8(:,213),heltab2x16(:,:,217))
  call Hloop_A_Q(ntryL,G1H8(143),38,0,G2H8(57),n2h8(178))
  call Hloop_VA_Q(ntryL,G1H16(83),ex4(:),G1H8(143),m3h2x8(:,214),heltab2x16(:,:,218))
  call Hloop_A_Q(ntryL,G1H8(143),42,0,G2H8(58),n2h8(179))
  call Hloop_VA_Q(ntryL,G1H16(84),ex4(:),G1H8(143),m3h2x8(:,215),heltab2x16(:,:,219))
  call Hloop_A_Q(ntryL,G1H8(143),42,0,G2H8(59),n2h8(180))
  call Hloop_ZA_Q(ntryL,G1H16(85),ex4(:),G1H8(143),ngZl,m3h2x8(:,216),heltab2x16(:,:,220))
  call Hloop_A_Q(ntryL,G1H8(143),42,0,G2H8(60),n2h8(181))
  call Hloop_ZA_Q(ntryL,G1H16(86),ex4(:),G1H8(143),ngZl,m3h2x8(:,217),heltab2x16(:,:,221))
  call Hloop_A_Q(ntryL,G1H8(143),42,0,G2H8(61),n2h8(182))
  call Hloop_VQ_A(ntryL,G1H16(87),wf4(:,14),G1H4(80),m3h4x4(:,5),heltab2x16(:,:,222))
  call Hloop_Q_A(ntryL,G1H4(80),53,0,G2H4(119),n2h4(137))
  call Hloop_ZQ_A(ntryL,G1H16(88),wf4(:,14),G1H4(81),ngZl,m3h4x4(:,6),heltab2x16(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(81),53,0,G2H4(122),n2h4(138))
  call Hloop_VQ_A(ntryL,G1H16(89),wf4(:,14),G1H4(82),m3h4x4(:,7),heltab2x16(:,:,224))
  call Hloop_Q_A(ntryL,G1H4(82),53,0,G2H4(1),n2h4(139))
  call Hloop_ZQ_A(ntryL,G1H16(90),wf4(:,14),G1H4(86),ngZl,m3h4x4(:,8),heltab2x16(:,:,225))
  call Hloop_Q_A(ntryL,G1H4(86),53,0,G2H4(2),n2h4(140))
  call Hloop_AQ_W(ntryL,G2H16(30),wf4(:,14),G2H4(3),m3h4x4(:,9),heltab2x16(:,:,226))
  call Hloop_VQ_A(ntryL,G1H16(91),ex3(:),G1H8(143),m3h2x8(:,218),heltab2x16(:,:,227))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(62),n2h8(183))
  call Hloop_VQ_A(ntryL,G1H16(92),ex3(:),G1H8(143),m3h2x8(:,219),heltab2x16(:,:,228))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(63),n2h8(184))
  call Hloop_ZQ_A(ntryL,G1H16(93),ex3(:),G1H8(143),ngZl,m3h2x8(:,220),heltab2x16(:,:,229))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(64),n2h8(185))
  call Hloop_ZQ_A(ntryL,G1H16(94),ex3(:),G1H8(143),ngZl,m3h2x8(:,221),heltab2x16(:,:,230))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(65),n2h8(186))
  call Hloop_VQ_A(ntryL,G1H16(95),ex1(:),G1H8(143),m3h2x8(:,222),heltab2x16(:,:,231))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(66),n2h8(187))
  call Hloop_VQ_A(ntryL,G1H16(96),ex1(:),G1H8(143),m3h2x8(:,223),heltab2x16(:,:,232))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(67),n2h8(188))
  call Hloop_ZQ_A(ntryL,G1H16(97),ex1(:),G1H8(143),ngZl,m3h2x8(:,224),heltab2x16(:,:,233))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(68),n2h8(189))
  call Hloop_ZQ_A(ntryL,G1H16(98),ex1(:),G1H8(143),ngZl,m3h2x8(:,225),heltab2x16(:,:,234))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(69),n2h8(190))
  call Hloop_VA_Q(ntryL,G1H16(99),ex4(:),G1H8(143),m3h2x8(:,226),heltab2x16(:,:,235))
  call Hloop_A_Q(ntryL,G1H8(143),41,0,G2H8(70),n2h8(191))
  call Hloop_VA_Q(ntryL,G1H16(100),ex4(:),G1H8(143),m3h2x8(:,227),heltab2x16(:,:,236))
  call Hloop_A_Q(ntryL,G1H8(143),41,0,G2H8(71),n2h8(192))
  call Hloop_ZA_Q(ntryL,G1H16(101),ex4(:),G1H8(143),ngZl,m3h2x8(:,228),heltab2x16(:,:,237))
  call Hloop_A_Q(ntryL,G1H8(143),41,0,G2H8(72),n2h8(193))
  call Hloop_ZA_Q(ntryL,G1H16(102),ex4(:),G1H8(143),ngZl,m3h2x8(:,229),heltab2x16(:,:,238))
  call Hloop_A_Q(ntryL,G1H8(143),41,0,G2H8(73),n2h8(194))
  call Hloop_QA_W(ntryL,G2H16(31),ex4(:),G2H8(74),m3h2x8(:,230),heltab2x16(:,:,239))
  call Hloop_VA_Q(ntryL,G1H16(103),wf4(:,20),G1H4(87),m3h4x4(:,10),heltab2x16(:,:,240))
  call Hloop_A_Q(ntryL,G1H4(87),54,0,G2H4(4),n2h4(141))
  call Hloop_ZA_Q(ntryL,G1H16(104),wf4(:,20),G1H4(88),ngZl,m3h4x4(:,11),heltab2x16(:,:,241))
  call Hloop_A_Q(ntryL,G1H4(88),54,0,G2H4(5),n2h4(142))
  call Hloop_VA_Q(ntryL,G1H16(105),wf4(:,20),G1H4(92),m3h4x4(:,12),heltab2x16(:,:,242))
  call Hloop_A_Q(ntryL,G1H4(92),54,0,G2H4(6),n2h4(143))
  call Hloop_ZA_Q(ntryL,G1H16(106),wf4(:,20),G1H4(93),ngZl,m3h4x4(:,13),heltab2x16(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(93),54,0,G2H4(7),n2h4(144))
  call Hloop_QA_W(ntryL,G2H16(32),wf4(:,20),G2H4(8),m3h4x4(:,14),heltab2x16(:,:,244))
  call Hloop_AQ_W(ntryL,G2H16(33),ex1(:),G2H8(75),m3h2x8(:,231),heltab2x16(:,:,245))
  call Hloop_VQ_A(ntryL,G1H16(107),ex1(:),G1H8(143),m3h2x8(:,232),heltab2x16(:,:,246))
  call Hloop_Q_A(ntryL,G1H8(143),41,0,G2H8(76),n2h8(195))
  call Hloop_VQ_A(ntryL,G1H16(108),ex1(:),G1H8(143),m3h2x8(:,233),heltab2x16(:,:,247))
  call Hloop_Q_A(ntryL,G1H8(143),41,0,G2H8(77),n2h8(196))
  call Hloop_ZQ_A(ntryL,G1H16(109),ex1(:),G1H8(143),ngZl,m3h2x8(:,234),heltab2x16(:,:,248))
  call Hloop_Q_A(ntryL,G1H8(143),41,0,G2H8(78),n2h8(197))
  call Hloop_ZQ_A(ntryL,G1H16(110),ex1(:),G1H8(143),ngZl,m3h2x8(:,235),heltab2x16(:,:,249))
  call Hloop_Q_A(ntryL,G1H8(143),41,0,G2H8(79),n2h8(198))
  call Hloop_QA_W(ntryL,G2H16(34),ex2(:),G2H8(80),m3h2x8(:,236),heltab2x16(:,:,250))
  call Hloop_VA_Q(ntryL,G1H16(111),ex2(:),G1H8(143),m3h2x8(:,237),heltab2x16(:,:,251))
  call Hloop_A_Q(ntryL,G1H8(143),42,0,G2H8(81),n2h8(199))
  call Hloop_ZA_Q(ntryL,G1H16(112),ex2(:),G1H8(143),ngZl,m3h2x8(:,238),heltab2x16(:,:,252))
  call Hloop_A_Q(ntryL,G1H8(143),42,0,G2H8(82),n2h8(200))
  call Hloop_VA_Q(ntryL,G1H16(113),ex2(:),G1H8(143),m3h2x8(:,239),heltab2x16(:,:,253))
  call Hloop_A_Q(ntryL,G1H8(143),42,0,G2H8(83),n2h8(201))
  call Hloop_ZA_Q(ntryL,G1H16(114),ex2(:),G1H8(143),ngZl,m3h2x8(:,240),heltab2x16(:,:,254))
  call Hloop_A_Q(ntryL,G1H8(143),42,0,G2H8(84),n2h8(202))
  call Hloop_VA_Q(ntryL,G1H16(115),ex4(:),G1H8(143),m3h2x8(:,241),heltab2x16(:,:,255))
  call Hloop_A_Q(ntryL,G1H8(143),41,0,G2H8(85),n2h8(203))
  call Hloop_VA_Q(ntryL,G1H16(116),ex4(:),G1H8(143),m3h2x8(:,242),heltab2x16(:,:,256))
  call Hloop_A_Q(ntryL,G1H8(143),41,0,G2H8(86),n2h8(204))
  call Hloop_ZA_Q(ntryL,G1H16(117),ex4(:),G1H8(143),ngZl,m3h2x8(:,243),heltab2x16(:,:,257))
  call Hloop_A_Q(ntryL,G1H8(143),41,0,G2H8(87),n2h8(205))
  call Hloop_ZA_Q(ntryL,G1H16(118),ex4(:),G1H8(143),ngZl,m3h2x8(:,244),heltab2x16(:,:,258))
  call Hloop_A_Q(ntryL,G1H8(143),41,0,G2H8(88),n2h8(206))
  call Hloop_VQ_A(ntryL,G1H16(119),wf4(:,4),G1H4(94),m3h4x4(:,15),heltab2x16(:,:,259))
  call Hloop_Q_A(ntryL,G1H4(94),53,0,G2H4(9),n2h4(145))
  call Hloop_VQ_A(ntryL,G1H16(120),wf4(:,4),G1H4(98),m3h4x4(:,16),heltab2x16(:,:,260))
  call Hloop_Q_A(ntryL,G1H4(98),53,0,G2H4(10),n2h4(146))
  call Hloop_ZQ_A(ntryL,G1H16(121),wf4(:,4),G1H4(99),ngZl,m3h4x4(:,17),heltab2x16(:,:,261))
  call Hloop_Q_A(ntryL,G1H4(99),53,0,G2H4(11),n2h4(147))
  call Hloop_ZQ_A(ntryL,G1H16(122),wf4(:,4),G1H4(100),ngZl,m3h4x4(:,18),heltab2x16(:,:,262))
  call Hloop_Q_A(ntryL,G1H4(100),53,0,G2H4(12),n2h4(148))
  call Hloop_VQ_A(ntryL,G1H16(123),ex1(:),G1H8(143),m3h2x8(:,245),heltab2x16(:,:,263))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(89),n2h8(207))
  call Hloop_VQ_A(ntryL,G1H16(124),ex1(:),G1H8(143),m3h2x8(:,246),heltab2x16(:,:,264))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(90),n2h8(208))
  call Hloop_ZQ_A(ntryL,G1H16(125),ex1(:),G1H8(143),ngZl,m3h2x8(:,247),heltab2x16(:,:,265))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(91),n2h8(209))
  call Hloop_ZQ_A(ntryL,G1H16(126),ex1(:),G1H8(143),ngZl,m3h2x8(:,248),heltab2x16(:,:,266))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(92),n2h8(210))
  call Hloop_QA_W(ntryL,G2H16(35),ex2(:),G2H8(93),m3h2x8(:,249),heltab2x16(:,:,267))
  call Hloop_VA_Q(ntryL,G1H16(127),ex2(:),G1H8(143),m3h2x8(:,250),heltab2x16(:,:,268))
  call Hloop_A_Q(ntryL,G1H8(143),38,0,G2H8(94),n2h8(211))
  call Hloop_ZA_Q(ntryL,G1H16(128),ex2(:),G1H8(143),ngZl,m3h2x8(:,251),heltab2x16(:,:,269))
  call Hloop_A_Q(ntryL,G1H8(143),38,0,G2H8(95),n2h8(212))
  call Hloop_VA_Q(ntryL,G1H16(129),ex2(:),G1H8(143),m3h2x8(:,252),heltab2x16(:,:,270))
  call Hloop_A_Q(ntryL,G1H8(143),38,0,G2H8(96),n2h8(213))
  call Hloop_ZA_Q(ntryL,G1H16(130),ex2(:),G1H8(143),ngZl,m3h2x8(:,253),heltab2x16(:,:,271))
  call Hloop_A_Q(ntryL,G1H8(143),38,0,G2H8(97),n2h8(214))
  call Hloop_AQ_W(ntryL,G2H16(36),ex1(:),G2H8(98),m3h2x8(:,254),heltab2x16(:,:,272))
  call Hloop_VQ_A(ntryL,G1H16(131),ex3(:),G1H8(143),m3h2x8(:,255),heltab2x16(:,:,273))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(99),n2h8(215))
  call Hloop_VQ_A(ntryL,G1H16(132),ex3(:),G1H8(143),m3h2x8(:,256),heltab2x16(:,:,274))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(100),n2h8(216))
  call Hloop_ZQ_A(ntryL,G1H16(133),ex3(:),G1H8(143),ngZl,m3h2x8(:,257),heltab2x16(:,:,275))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(101),n2h8(217))
  call Hloop_ZQ_A(ntryL,G1H16(134),ex3(:),G1H8(143),ngZl,m3h2x8(:,258),heltab2x16(:,:,276))
  call Hloop_Q_A(ntryL,G1H8(143),37,0,G2H8(102),n2h8(218))
  call Hloop_VA_Q(ntryL,G1H16(135),wf4(:,10),G1H4(104),m3h4x4(:,19),heltab2x16(:,:,277))
  call Hloop_A_Q(ntryL,G1H4(104),57,0,G2H4(13),n2h4(149))
  call Hloop_VA_Q(ntryL,G1H16(136),wf4(:,10),G1H4(105),m3h4x4(:,20),heltab2x16(:,:,278))
  call Hloop_A_Q(ntryL,G1H4(105),57,0,G2H4(14),n2h4(150))
  call Hloop_ZA_Q(ntryL,G1H16(137),wf4(:,10),G1H4(106),ngZl,m3h4x4(:,21),heltab2x16(:,:,279))
  call Hloop_A_Q(ntryL,G1H4(106),57,0,G2H4(15),n2h4(151))
  call Hloop_ZA_Q(ntryL,G1H16(138),wf4(:,10),G1H4(110),ngZl,m3h4x4(:,22),heltab2x16(:,:,280))
  call Hloop_A_Q(ntryL,G1H4(110),57,0,G2H4(16),n2h4(152))
  call Hloop_AQ_V(ntryL,G1H8(77),ex3(:),G1H4(111),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_AQ_V(ntryL,G1H8(78),ex3(:),G1H4(112),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_AQ_Z(ntryL,G1H8(79),ex3(:),G1H4(116),ngZl,m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_AQ_Z(ntryL,G1H8(80),ex3(:),G1H4(117),ngZl,m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_VQ_A(ntryL,G1H8(84),ex3(:),G1H4(118),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(118),39,0,G2H4(17),n2h4(153))
  call Hloop_VQ_A(ntryL,G1H8(85),ex3(:),G1H4(122),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(122),39,0,G2H4(18),n2h4(154))
  call Hloop_ZQ_A(ntryL,G1H8(86),ex3(:),G1H4(123),ngZl,m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(123),39,0,G2H4(19),n2h4(155))
  call Hloop_ZQ_A(ntryL,G1H8(89),ex3(:),G1H4(124),ngZl,m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(124),39,0,G2H4(20),n2h4(156))
  call Hloop_QA_V(ntryL,G1H8(90),ex4(:),G1H4(128),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_QA_V(ntryL,G1H8(91),ex4(:),G1H4(129),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_QA_Z(ntryL,G1H8(92),ex4(:),G1H4(130),ngZl,m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_QA_Z(ntryL,G1H8(95),ex4(:),G1H4(134),ngZl,m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_VA_Q(ntryL,G1H8(96),ex4(:),G1H4(135),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(135),43,0,G2H4(21),n2h4(157))
  call Hloop_VA_Q(ntryL,G1H8(97),ex4(:),G1H4(136),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(136),43,0,G2H4(22),n2h4(158))
  call Hloop_ZA_Q(ntryL,G1H8(98),ex4(:),G1H4(140),ngZl,m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(140),43,0,G2H4(23),n2h4(159))
  call Hloop_ZA_Q(ntryL,G1H8(101),ex4(:),G1H4(141),ngZl,m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(141),43,0,G2H4(24),n2h4(160))
  call Hloop_AQ_V(ntryL,G1H8(103),ex3(:),G1H4(142),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_AQ_V(ntryL,G1H8(104),ex3(:),G1H4(146),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_AQ_Z(ntryL,G1H8(107),ex3(:),G1H4(147),ngZl,m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_AQ_Z(ntryL,G1H8(108),ex3(:),G1H4(148),ngZl,m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_VQ_A(ntryL,G1H8(109),ex3(:),G1H4(152),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_Q_A(ntryL,G1H4(152),39,0,G2H4(25),n2h4(161))
  call Hloop_VQ_A(ntryL,G1H8(110),ex3(:),G1H4(153),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_Q_A(ntryL,G1H4(153),39,0,G2H4(26),n2h4(162))
  call Hloop_ZQ_A(ntryL,G1H8(113),ex3(:),G1H4(154),ngZl,m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_Q_A(ntryL,G1H4(154),39,0,G2H4(27),n2h4(163))
  call Hloop_ZQ_A(ntryL,G1H8(114),ex3(:),G1H4(158),ngZl,m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_Q_A(ntryL,G1H4(158),39,0,G2H4(28),n2h4(164))
  call Hloop_QA_V(ntryL,G1H8(115),ex4(:),G1H4(159),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_QA_V(ntryL,G1H8(116),ex4(:),G1H4(160),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_QA_Z(ntryL,G1H8(119),ex4(:),G1H4(164),ngZl,m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_QA_Z(ntryL,G1H8(120),ex4(:),G1H4(165),ngZl,m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_VA_Q(ntryL,G1H8(122),ex4(:),G1H4(166),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_A_Q(ntryL,G1H4(166),43,0,G2H4(29),n2h4(165))
  call Hloop_VA_Q(ntryL,G1H8(125),ex4(:),G1H4(170),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G1H4(170),43,0,G2H4(30),n2h4(166))
  call Hloop_ZA_Q(ntryL,G1H8(126),ex4(:),G1H4(171),ngZl,m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_A_Q(ntryL,G1H4(171),43,0,G2H4(31),n2h4(167))
  call Hloop_ZA_Q(ntryL,G1H8(127),ex4(:),G1H4(172),ngZl,m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_A_Q(ntryL,G1H4(172),43,0,G2H4(32),n2h4(168))
  call Hloop_AQ_V(ntryL,G1H8(132),ex1(:),G1H4(176),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_AQ_V(ntryL,G1H8(8),ex1(:),G1H4(177),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_AQ_Z(ntryL,G1H8(9),ex1(:),G1H4(178),ngZl,m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_AQ_Z(ntryL,G1H8(2),ex1(:),G1H4(182),ngZl,m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_AQ_W(ntryL,G1H8(10),ex1(:),G1H4(183),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_QA_V(ntryL,G1H8(18),ex2(:),G1H4(184),m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_QA_Z(ntryL,G1H8(19),ex2(:),G1H4(188),ngZl,m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_QA_V(ntryL,G1H8(20),ex2(:),G1H4(189),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_QA_Z(ntryL,G1H8(21),ex2(:),G1H4(190),ngZl,m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_AQ_V(ntryL,G1H8(53),ex1(:),G1H4(194),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_AQ_V(ntryL,G1H8(54),ex1(:),G1H4(195),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_AQ_Z(ntryL,G1H8(55),ex1(:),G1H4(196),ngZl,m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_AQ_Z(ntryL,G1H8(56),ex1(:),G1H4(201),ngZl,m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_QA_V(ntryL,G1H8(66),ex2(:),G1H4(202),m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_QA_Z(ntryL,G1H8(67),ex2(:),G1H4(206),ngZl,m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_QA_V(ntryL,G1H8(68),ex2(:),G1H4(207),m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_QA_Z(ntryL,G1H8(133),ex2(:),G1H4(208),ngZl,m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_QA_W(ntryL,G1H8(134),ex2(:),G1H4(213),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_AV_Q(ntryL,G1H8(135),ex5(:),G1H4(214),m3h2x4(:,221),heltab2x8(:,:,221))
  call Hloop_A_Q(ntryL,G1H4(214),58,0,G2H4(123),n2h4(169))
  call Hloop_AV_Q(ntryL,G1H8(136),ex5(:),G1H4(218),m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_A_Q(ntryL,G1H4(218),58,0,G2H4(124),n2h4(170))
  call Hloop_AV_Q(ntryL,G1H8(137),ex5(:),G1H4(200),m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_A_Q(ntryL,G1H4(200),58,0,G2H4(125),n2h4(171))
  call Hloop_AV_Q(ntryL,G1H8(138),ex5(:),G1H4(212),m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_A_Q(ntryL,G1H4(212),58,0,G2H4(126),n2h4(172))
  call Hloop_QV_A(ntryL,G1H8(139),ex5(:),G1H4(3),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G1H4(3),57,0,G2H4(127),n2h4(173))
  call Hloop_QV_A(ntryL,G1H8(140),ex5(:),G1H4(4),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_Q_A(ntryL,G1H4(4),57,0,G2H4(128),n2h4(174))
  call Hloop_QV_A(ntryL,G1H8(141),ex5(:),G1H4(8),m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G1H4(8),57,0,G2H4(129),n2h4(175))
  call Hloop_QV_A(ntryL,G1H8(142),ex5(:),G1H4(9),m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_Q_A(ntryL,G1H4(9),57,0,G2H4(130),n2h4(176))
  call Hloop_WQ_A(ntryL,G1H8(6),ex1(:),G1H4(10),m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G1H4(10),45,0,G2H4(131),n2h4(177))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(7),-16,ex5(:),16,G2H4(132),m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_WQ_A(ntryL,G1H8(12),ex1(:),G1H4(14),m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(133),n2h4(178))
  call Hloop_WQ_A(ntryL,G1H8(16),ex1(:),G1H4(15),m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H4(15),45,0,G2H4(134),n2h4(179))
  call Hloop_WQ_A(ntryL,G1H8(17),ex1(:),G1H4(16),m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(16),45,0,G2H4(135),n2h4(180))
  call Hloop_WA_Q(ntryL,G1H8(22),ex4(:),G1H4(20),m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_A_Q(ntryL,G1H4(20),43,0,G2H4(136),n2h4(181))
call HGT_raise_alpha_OLR(G1H8(23),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(23),-16,ex5(:),16,G2H4(137),m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_WA_Q(ntryL,G1H8(28),ex4(:),G1H4(21),m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_A_Q(ntryL,G1H4(21),43,0,G2H4(138),n2h4(182))
  call Hloop_WA_Q(ntryL,G1H8(33),ex4(:),G1H4(22),m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_A_Q(ntryL,G1H4(22),43,0,G2H4(139),n2h4(183))
  call Hloop_WA_Q(ntryL,G1H8(34),ex4(:),G1H4(26),m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_A_Q(ntryL,G1H4(26),43,0,G2H4(140),n2h4(184))
  call Hloop_WA_Q(ntryL,G1H8(39),ex2(:),G1H4(27),m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_A_Q(ntryL,G1H4(27),46,0,G2H4(141),n2h4(185))
call HGT_raise_alpha_OLR(G1H8(40),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(40),-16,ex5(:),16,G2H4(142),m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_WA_Q(ntryL,G1H8(46),ex2(:),G1H4(28),m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_A_Q(ntryL,G1H4(28),46,0,G2H4(143),n2h4(186))
  call Hloop_WA_Q(ntryL,G1H8(51),ex2(:),G1H4(32),m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_A_Q(ntryL,G1H4(32),46,0,G2H4(144),n2h4(187))
  call Hloop_WA_Q(ntryL,G1H8(57),ex2(:),G1H4(33),m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(33),46,0,G2H4(145),n2h4(188))
  call Hloop_UV_W(ntryL,G1H8(64),35,ex5(:),16,G2H4(146),m3h2x4(:,244),heltab2x8(:,:,244))
call HGT_raise_alpha_OLR(G1H8(70),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(70),ex3(:),G1H4(34),m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_UV_W(ntryL,G1H8(88),35,ex5(:),16,G2H4(147),m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_UV_W(ntryL,G1H8(93),35,ex5(:),16,G2H4(148),m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_UV_W(ntryL,G1H8(99),35,ex5(:),16,G2H4(149),m3h2x4(:,248),heltab2x8(:,:,248))
  call Hloop_WQ_A(ntryL,G1H8(100),ex3(:),G1H4(38),m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_Q_A(ntryL,G1H4(38),39,0,G2H4(150),n2h4(189))
call HGT_raise_alpha_OLR(G1H8(105),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(105),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(105),-16,ex5(:),16,G2H4(151),m3h2x4(:,250),heltab2x8(:,:,250))
  call Hloop_WQ_A(ntryL,G1H8(118),ex3(:),G1H4(39),m3h2x4(:,251),heltab2x8(:,:,251))
  call Hloop_Q_A(ntryL,G1H4(39),39,0,G2H4(152),n2h4(190))
  call Hloop_WQ_A(ntryL,G1H8(3),ex3(:),G1H4(40),m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_Q_A(ntryL,G1H4(40),39,0,G2H4(153),n2h4(191))
  call Hloop_WQ_A(ntryL,G1H8(14),ex3(:),G1H4(44),m3h2x4(:,253),heltab2x8(:,:,253))
  call Hloop_Q_A(ntryL,G1H4(44),39,0,G2H4(154),n2h4(192))
  call Hloop_UW_V(ntryL,G1H8(13),35,ex5(:),16,G2H4(155),m3h2x4(:,254),heltab2x8(:,:,254))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(4),ex4(:),G1H4(45),m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_UW_V(ntryL,G1H8(24),35,ex5(:),16,G2H4(156),m3h2x4(:,256),heltab2x8(:,:,256))
  call Hloop_UW_V(ntryL,G1H8(37),35,ex5(:),16,G2H4(157),m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_UW_V(ntryL,G1H8(36),35,ex5(:),16,G2H4(158),m3h2x4(:,258),heltab2x8(:,:,258))
  call Hloop_AV_Q(ntryL,G1H8(35),ex5(:),G1H4(46),m3h2x4(:,259),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H4(46),51,0,G2H4(159),n2h4(193))
call HGT_OLR(G1H8(49),1,1,8)
call HGT_invQ_OLR(G1H8(49),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(49),-8,0,G2H8(103),n2h8(225))
  call Hloop_QA_V(ntryL,G2H8(103),ex4(:),G2H4(160),m3h2x4(:,260),heltab2x8(:,:,260))
  call Hloop_AV_Q(ntryL,G1H8(47),ex5(:),G1H4(50),m3h2x4(:,261),heltab2x8(:,:,261))
  call Hloop_A_Q(ntryL,G1H4(50),51,0,G2H4(161),n2h4(194))
  call Hloop_AV_Q(ntryL,G1H8(61),ex5(:),G1H4(51),m3h2x4(:,262),heltab2x8(:,:,262))
  call Hloop_A_Q(ntryL,G1H4(51),51,0,G2H4(162),n2h4(195))
  call Hloop_AV_Q(ntryL,G1H8(60),ex5(:),G1H4(52),m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G1H4(52),51,0,G2H4(163),n2h4(196))
  call Hloop_AV_Q(ntryL,G1H8(59),ex5(:),G1H4(62),m3h2x4(:,264),heltab2x8(:,:,264))
  call Hloop_A_Q(ntryL,G1H4(62),51,0,G2H4(164),n2h4(197))
call HGT_OLR(G1H8(73),1,1,8)
call HGT_invQ_OLR(G1H8(73),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(73),-8,0,G2H8(103),n2h8(226))
  call Hloop_QA_Z(ntryL,G2H8(103),ex4(:),G2H4(165),ngZl,m3h2x4(:,265),heltab2x8(:,:,265))
  call Hloop_AV_Q(ntryL,G1H8(71),ex5(:),G1H4(64),m3h2x4(:,266),heltab2x8(:,:,266))
  call Hloop_A_Q(ntryL,G1H4(64),51,0,G2H4(166),n2h4(198))
  call Hloop_AV_Q(ntryL,G1H8(131),ex5(:),G1H4(68),m3h2x4(:,267),heltab2x8(:,:,267))
  call Hloop_A_Q(ntryL,G1H4(68),51,0,G2H4(167),n2h4(199))
  call Hloop_AV_Q(ntryL,G1H8(121),ex5(:),G1H4(69),m3h2x4(:,268),heltab2x8(:,:,268))
  call Hloop_A_Q(ntryL,G1H4(69),51,0,G2H4(168),n2h4(200))
  call Hloop_QV_A(ntryL,G1H8(65),ex5(:),G1H4(70),m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G1H4(70),51,0,G2H4(169),n2h4(201))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(128),-4,0,G2H8(103),n2h8(227))
  call Hloop_AQ_V(ntryL,G2H8(103),ex3(:),G2H4(170),m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_QV_A(ntryL,G1H8(102),ex5(:),G1H4(74),m3h2x4(:,271),heltab2x8(:,:,271))
  call Hloop_Q_A(ntryL,G1H4(74),51,0,G2H4(171),n2h4(202))
  call Hloop_QV_A(ntryL,G1H8(41),ex5(:),G1H4(75),m3h2x4(:,272),heltab2x8(:,:,272))
  call Hloop_Q_A(ntryL,G1H4(75),51,0,G2H4(172),n2h4(203))
  call Hloop_QV_A(ntryL,G1H8(52),ex5(:),G1H4(76),m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G1H4(76),51,0,G2H4(173),n2h4(204))
  call Hloop_QV_A(ntryL,G1H8(42),ex5(:),G1H4(80),m3h2x4(:,274),heltab2x8(:,:,274))
  call Hloop_Q_A(ntryL,G1H4(80),51,0,G2H4(174),n2h4(205))
call HGT_OLR(G1H8(58),1,1,8)
call HGT_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(58),-4,0,G2H8(103),n2h8(228))
  call Hloop_AQ_Z(ntryL,G2H8(103),ex3(:),G2H4(175),ngZl,m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_QV_A(ntryL,G1H8(44),ex5(:),G1H4(81),m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_Q_A(ntryL,G1H4(81),51,0,G2H4(176),n2h4(206))
  call Hloop_QV_A(ntryL,G1H8(63),ex5(:),G1H4(82),m3h2x4(:,277),heltab2x8(:,:,277))
  call Hloop_Q_A(ntryL,G1H4(82),51,0,G2H4(177),n2h4(207))
  call Hloop_QV_A(ntryL,G1H8(76),ex5(:),G1H4(86),m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_Q_A(ntryL,G1H4(86),51,0,G2H4(178),n2h4(208))
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,6),G1H4(87),ngZn,m3h4x4(:,23),heltab2x16(:,:,281))
  call Hloop_A_Q(ntryL,G1H4(87),43,0,G2H4(179),n2h4(209))
call HGT_raise_alpha_OLR(G1H16(2),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(2),-16,ex5(:),16,G2H8(103),m3h2x8(:,259),heltab2x16(:,:,282))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,6),G1H4(88),ngZn,m3h4x4(:,24),heltab2x16(:,:,283))
  call Hloop_A_Q(ntryL,G1H4(88),43,0,G2H4(180),n2h4(210))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,6),G1H4(92),ngZn,m3h4x4(:,25),heltab2x16(:,:,284))
  call Hloop_A_Q(ntryL,G1H4(92),43,0,G2H4(181),n2h4(211))
  call Hloop_AZ_Q(ntryL,G1H16(6),wf4(:,6),G1H4(93),ngZn,m3h4x4(:,26),heltab2x16(:,:,285))
  call Hloop_A_Q(ntryL,G1H4(93),43,0,G2H4(182),n2h4(212))
  call Hloop_QZ_A(ntryL,G1H16(7),wf4(:,6),G1H4(94),ngZn,m3h4x4(:,27),heltab2x16(:,:,286))
  call Hloop_Q_A(ntryL,G1H4(94),39,0,G2H4(183),n2h4(213))
call HGT_raise_alpha_OLR(G1H16(8),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(8),-16,ex5(:),16,G2H8(104),m3h2x8(:,260),heltab2x16(:,:,287))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,6),G1H4(98),ngZn,m3h4x4(:,28),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G1H4(98),39,0,G2H4(184),n2h4(214))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,6),G1H4(99),ngZn,m3h4x4(:,29),heltab2x16(:,:,289))
  call Hloop_Q_A(ntryL,G1H4(99),39,0,G2H4(185),n2h4(215))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,6),G1H4(100),ngZn,m3h4x4(:,30),heltab2x16(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(100),39,0,G2H4(186),n2h4(216))
  call Hloop_AZ_Q(ntryL,G1H16(13),wf4(:,16),G1H4(104),ngZn,m3h4x4(:,31),heltab2x16(:,:,291))
  call Hloop_A_Q(ntryL,G1H4(104),46,0,G2H4(187),n2h4(217))
call HGT_raise_alpha_OLR(G1H16(14),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(14),-16,ex5(:),16,G2H8(105),m3h2x8(:,261),heltab2x16(:,:,292))
  call Hloop_AZ_Q(ntryL,G1H16(16),wf4(:,16),G1H4(105),ngZn,m3h4x4(:,32),heltab2x16(:,:,293))
  call Hloop_A_Q(ntryL,G1H4(105),46,0,G2H4(188),n2h4(218))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,16),G1H4(106),ngZn,m3h4x4(:,33),heltab2x16(:,:,294))
  call Hloop_A_Q(ntryL,G1H4(106),46,0,G2H4(189),n2h4(219))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,16),G1H4(110),ngZn,m3h4x4(:,34),heltab2x16(:,:,295))
  call Hloop_A_Q(ntryL,G1H4(110),46,0,G2H4(190),n2h4(220))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,16),G1H4(118),ngZn,m3h4x4(:,35),heltab2x16(:,:,296))
  call Hloop_Q_A(ntryL,G1H4(118),45,0,G2H4(191),n2h4(221))
call HGT_raise_alpha_OLR(G1H16(20),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(20),-16,ex5(:),16,G2H8(106),m3h2x8(:,262),heltab2x16(:,:,297))
  call Hloop_QZ_A(ntryL,G1H16(22),wf4(:,16),G1H4(122),ngZn,m3h4x4(:,36),heltab2x16(:,:,298))
  call Hloop_Q_A(ntryL,G1H4(122),45,0,G2H4(192),n2h4(222))
  call Hloop_QZ_A(ntryL,G1H16(23),wf4(:,16),G1H4(123),ngZn,m3h4x4(:,37),heltab2x16(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(123),45,0,G2H4(193),n2h4(223))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,16),G1H4(124),ngZn,m3h4x4(:,38),heltab2x16(:,:,300))
  call Hloop_Q_A(ntryL,G1H4(124),45,0,G2H4(194),n2h4(224))
call HGT_lower_alpha_OLR(G2H4(42),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(42),2,5,4)
call HGT_lower_alpha_OLR(G2H4(42),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G1H4(56)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G2H4(50),G1H4(199)])
call HGT_lower_alpha_OLR(G2H4(53),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(53),2,5,4)
call HGT_lower_alpha_OLR(G2H4(53),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G1H4(57)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(57),G1H4(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(119),[G2H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G2H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(122),[G2H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(73)])
call HGT_lower_alpha_w2_OLR(G2H4(76),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(76),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(76),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(77)])
call HGT_lower_alpha_w2_OLR(G2H4(80),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(80),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(80),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(80),[G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(81)])
call HGT_lower_alpha_w2_OLR(G2H4(84),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(84),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(84),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(85)])
call HGT_lower_alpha_w2_OLR(G2H4(88),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(88),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(88),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(105)])
call HGT_lower_alpha_w2_OLR(G2H4(108),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(108),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(108),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G2H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(109)])
call HGT_lower_alpha_w2_OLR(G2H4(112),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(112),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(112),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(112),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(113)])
call HGT_lower_alpha_w2_OLR(G2H4(116),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(116),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(116),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(116),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(117)])
call HGT_lower_alpha_w2_OLR(G2H4(120),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(120),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(120),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(120),[G2H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(194),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(195),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(196),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(201),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(184),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(188),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(189),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(190),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(202),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(206),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(207),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(208),[G1H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(176),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(177),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(178),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(182),[G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(142),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(146),[G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(147),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(148),[G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(175),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(144),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(187),[G1H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(193),[G1H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(159),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(156),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(160),[G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(164),[G1H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(168),[G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(165),[G1H4(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(192),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(146),[G1H4(63),G1H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(148),[G1H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(155),[G1H4(58),G1H4(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(157),[G1H4(216)])
call HGT_lower_alpha_OLR(G2H4(38),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(38),2,5,4)
call HGT_lower_alpha_OLR(G2H4(38),6,15,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(31),mass5set(:,1),  & 
G1H4(135),G1H4(136),G1H4(140),G1H4(141),G1H4(152),G1H4(153),4)
  call HG1shiftOLR(G1H4(136),2,4)
  call Hloop_QA_W(ntryL,G2H4(39),ex2(:),G2H2(1),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(32),mass5set(:,1),  & 
G1H4(154),G1H4(158),G1H4(166),G1H4(170),G1H4(171),G1H4(172),4)
  call HG1shiftOLR(G1H4(158),4,4)
  call Hloop_AQ_W(ntryL,G2H4(43),ex3(:),G2H2(2),m3h2x2(:,152),heltab2x4(:,:,152))
call HGT_lower_alpha_OLR(G2H4(46),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(46),2,5,4)
call HGT_lower_alpha_OLR(G2H4(46),6,15,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(33),mass5set(:,1),  & 
G1H4(214),G1H4(218),G1H4(200),G1H4(212),G1H4(3),G1H4(4),4)
  call HG1shiftOLR(G1H4(218),1,4)
  call Hloop_AQ_W(ntryL,G2H4(47),ex1(:),G2H2(3),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_UV_W(ntryL,G1H4(1),39,ex5(:),16,G2H2(4),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(34),mass5set(:,1),  & 
G1H4(8),G1H4(9),G1H4(10),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(9),4,4)
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(35),mass5set(:,1),  & 
G1H4(20),G1H4(21),G1H4(22),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(21),8,4)
  call Hloop_QA_W(ntryL,G2H4(54),ex4(:),G2H2(5),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_UW_V(ntryL,G1H4(2),43,ex5(:),16,G2H2(7),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(36),mass5set(:,1),  & 
G1H4(32),G1H4(33),G1H4(38),G1H4(39),G1H4(40),G1H4(44),4)
  call HG1shiftOLR(G1H4(33),8,4)
call HGT_lower_alpha_w2_OLR(G2H4(60),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(60),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(60),6,15,4)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(37),mass5set(:,3),  & 
G1H4(46),G1H4(50),G1H4(51),G1H4(52),G1H4(62),G1H4(64),4)
  call HG1shiftOLR(G1H4(50),2,4)
  call Hloop_QA_V(ntryL,G2H4(119),ex2(:),G2H2(9),m3h2x2(:,157),heltab2x4(:,:,157))
call HGT_lower_alpha_w2_OLR(G2H4(64),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(64),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(64),6,15,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(37),mass5set(:,10),  & 
G1H4(68),G1H4(69),G1H4(70),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(69),2,4)
  call Hloop_QA_Z(ntryL,G2H4(1),ex2(:),G2H2(11),ngZl,m3h2x2(:,158),heltab2x4(:,:,158))
call HGT_lower_alpha_w2_OLR(G2H4(68),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(68),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(68),6,15,4)
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(37),mass5set(:,4),  & 
G1H4(80),G1H4(81),G1H4(82),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(81),2,4)
  call Hloop_QA_V(ntryL,G2H4(122),ex2(:),G2H2(13),m3h2x2(:,159),heltab2x4(:,:,159))
call HGT_lower_alpha_w2_OLR(G2H4(72),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(72),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(72),6,15,4)
  call Hotf_5pt_reduction(G2H4(72),RedSet_5(37),mass5set(:,11),  & 
G1H4(92),G1H4(93),G1H4(94),G1H4(98),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(93),2,4)
  call Hloop_QA_Z(ntryL,G2H4(2),ex2(:),G2H2(15),ngZl,m3h2x2(:,160),heltab2x4(:,:,160))
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(38),mass5set(:,3),  & 
G1H4(104),G1H4(105),G1H4(106),G1H4(110),G1H4(118),G1H4(122),4)
  call HG1shiftOLR(G1H4(105),8,4)
  call Hloop_QA_V(ntryL,G2H4(9),ex4(:),G2H2(17),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hotf_5pt_reduction(G2H4(80),RedSet_5(38),mass5set(:,10),  & 
G1H4(123),G1H4(124),G1H4(56),G1H4(183),G1H4(199),G1H4(57),4)
  call HG1shiftOLR(G1H4(124),8,4)
  call Hloop_QA_Z(ntryL,G2H4(10),ex4(:),G2H2(19),ngZl,m3h2x2(:,162),heltab2x4(:,:,162))
  call Hotf_5pt_reduction(G2H4(84),RedSet_5(38),mass5set(:,4),  & 
G1H4(213),G1H4(211),G1H4(5),G1H4(6),G1H4(7),G1H4(11),4)
  call HG1shiftOLR(G1H4(211),8,4)
  call Hloop_QA_V(ntryL,G2H4(11),ex4(:),G2H2(21),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hotf_5pt_reduction(G2H4(88),RedSet_5(38),mass5set(:,11),  & 
G1H4(13),G1H4(17),G1H4(18),G1H4(19),G1H4(23),G1H4(25),4)
  call HG1shiftOLR(G1H4(17),8,4)
  call Hloop_QA_Z(ntryL,G2H4(12),ex4(:),G2H2(23),ngZl,m3h2x2(:,164),heltab2x4(:,:,164))
call HGT_lower_alpha_w2_OLR(G2H4(92),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(92),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(92),6,15,4)
  call Hotf_5pt_reduction(G2H4(92),RedSet_5(39),mass5set(:,3),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(35),G1H4(36),G1H4(37),4)
  call HG1shiftOLR(G1H4(30),1,4)
  call Hloop_AQ_V(ntryL,G2H4(4),ex1(:),G2H2(25),m3h2x2(:,165),heltab2x4(:,:,165))
call HGT_lower_alpha_w2_OLR(G2H4(96),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(96),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(96),6,15,4)
  call Hotf_5pt_reduction(G2H4(96),RedSet_5(39),mass5set(:,4),  & 
G1H4(41),G1H4(43),G1H4(47),G1H4(49),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(43),1,4)
  call Hloop_AQ_V(ntryL,G2H4(5),ex1(:),G2H2(27),m3h2x2(:,166),heltab2x4(:,:,166))
call HGT_lower_alpha_w2_OLR(G2H4(100),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(100),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(100),6,15,4)
  call Hotf_5pt_reduction(G2H4(100),RedSet_5(39),mass5set(:,10),  & 
G1H4(59),G1H4(60),G1H4(65),G1H4(71),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(60),1,4)
  call Hloop_AQ_Z(ntryL,G2H4(6),ex1(:),G2H2(29),ngZl,m3h2x2(:,167),heltab2x4(:,:,167))
call HGT_lower_alpha_w2_OLR(G2H4(104),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(104),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(104),6,15,4)
  call Hotf_5pt_reduction(G2H4(104),RedSet_5(39),mass5set(:,11),  & 
G1H4(83),G1H4(89),G1H4(90),G1H4(95),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(89),1,4)
  call Hloop_AQ_Z(ntryL,G2H4(7),ex1(:),G2H2(31),ngZl,m3h2x2(:,168),heltab2x4(:,:,168))
  call Hotf_5pt_reduction(G2H4(108),RedSet_5(40),mass5set(:,3),  & 
G1H4(103),G1H4(107),G1H4(109),G1H4(113),G1H4(114),G1H4(115),4)
  call HG1shiftOLR(G1H4(107),4,4)
  call Hloop_AQ_V(ntryL,G2H4(13),ex3(:),G2H2(33),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hotf_5pt_reduction(G2H4(112),RedSet_5(40),mass5set(:,10),  & 
G1H4(119),G1H4(121),G1H4(125),G1H4(126),G1H4(127),G1H4(131),4)
  call HG1shiftOLR(G1H4(121),4,4)
  call Hloop_AQ_Z(ntryL,G2H4(14),ex3(:),G2H2(35),ngZl,m3h2x2(:,170),heltab2x4(:,:,170))
  call Hotf_5pt_reduction(G2H4(116),RedSet_5(40),mass5set(:,4),  & 
G1H4(132),G1H4(133),G1H4(137),G1H4(139),G1H4(143),G1H4(145),4)
  call HG1shiftOLR(G1H4(133),4,4)
  call Hloop_AQ_V(ntryL,G2H4(15),ex3(:),G2H2(37),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hotf_5pt_reduction(G2H4(120),RedSet_5(40),mass5set(:,11),  & 
G1H4(149),G1H4(150),G1H4(155),G1H4(161),G1H4(162),G1H4(167),4)
  call HG1shiftOLR(G1H4(150),4,4)
  call Hloop_AQ_Z(ntryL,G2H4(16),ex3(:),G2H2(39),ngZl,m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_VQ_A(ntryL,G1H4(194),ex3(:),G1H2(5),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(5),47,0,G2H2(41),n2h2(71))
  call Hloop_VQ_A(ntryL,G1H4(12),ex3(:),G1H2(6),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(6),47,0,G2H2(43),n2h2(72))
  call Hloop_VQ_A(ntryL,G1H4(55),ex3(:),G1H2(11),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(11),47,0,G2H2(45),n2h2(73))
  call Hloop_VQ_A(ntryL,G1H4(195),ex3(:),G1H2(12),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(12),47,0,G2H2(48),n2h2(74))
  call Hloop_VQ_A(ntryL,G1H4(67),ex3(:),G1H2(17),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(17),47,0,G2H2(51),n2h2(75))
  call Hloop_ZQ_A(ntryL,G1H4(196),ex3(:),G1H2(18),ngZl,m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(18),47,0,G2H2(54),n2h2(76))
  call Hloop_ZQ_A(ntryL,G1H4(24),ex3(:),G1H2(23),ngZl,m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(23),47,0,G2H2(57),n2h2(77))
  call Hloop_ZQ_A(ntryL,G1H4(61),ex3(:),G1H2(24),ngZl,m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(24),47,0,G2H2(60),n2h2(78))
  call Hloop_ZQ_A(ntryL,G1H4(201),ex3(:),G1H2(29),ngZl,m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(29),47,0,G2H2(63),n2h2(79))
  call Hloop_ZQ_A(ntryL,G1H4(73),ex3(:),G1H2(30),ngZl,m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(30),47,0,G2H2(66),n2h2(80))
  call Hloop_VA_Q(ntryL,G1H4(184),ex4(:),G1H2(35),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_A_Q(ntryL,G1H2(35),47,0,G2H2(69),n2h2(81))
  call Hloop_VA_Q(ntryL,G1H4(42),ex4(:),G1H2(36),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(36),47,0,G2H2(72),n2h2(82))
  call Hloop_VA_Q(ntryL,G1H4(79),ex4(:),G1H2(41),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(41),47,0,G2H2(75),n2h2(83))
  call Hloop_ZA_Q(ntryL,G1H4(188),ex4(:),G1H2(42),ngZl,m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_A_Q(ntryL,G1H2(42),47,0,G2H2(78),n2h2(84))
  call Hloop_ZA_Q(ntryL,G1H4(48),ex4(:),G1H2(47),ngZl,m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_A_Q(ntryL,G1H2(47),47,0,G2H2(81),n2h2(85))
  call Hloop_ZA_Q(ntryL,G1H4(91),ex4(:),G1H2(48),ngZl,m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(48),47,0,G2H2(84),n2h2(86))
  call Hloop_VA_Q(ntryL,G1H4(189),ex4(:),G1H2(53),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(53),47,0,G2H2(87),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(85),ex4(:),G1H2(54),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(54),47,0,G2H2(90),n2h2(88))
  call Hloop_ZA_Q(ntryL,G1H4(190),ex4(:),G1H2(59),ngZl,m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(59),47,0,G2H2(93),n2h2(89))
  call Hloop_ZA_Q(ntryL,G1H4(97),ex4(:),G1H2(60),ngZl,m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(60),47,0,G2H2(96),n2h2(90))
  call Hloop_VQ_A(ntryL,G1H4(202),ex3(:),G1H2(65),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(65),47,0,G2H2(99),n2h2(91))
  call Hloop_VQ_A(ntryL,G1H4(66),ex3(:),G1H2(66),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(66),47,0,G2H2(102),n2h2(92))
  call Hloop_ZQ_A(ntryL,G1H4(206),ex3(:),G1H2(71),ngZl,m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(71),47,0,G2H2(105),n2h2(93))
  call Hloop_ZQ_A(ntryL,G1H4(72),ex3(:),G1H2(72),ngZl,m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(72),47,0,G2H2(108),n2h2(94))
  call Hloop_VQ_A(ntryL,G1H4(207),ex3(:),G1H2(77),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(77),47,0,G2H2(111),n2h2(95))
  call Hloop_ZQ_A(ntryL,G1H4(208),ex3(:),G1H2(78),ngZl,m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(78),47,0,G2H2(114),n2h2(96))
  call Hloop_VA_Q(ntryL,G1H4(176),ex4(:),G1H2(83),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_A_Q(ntryL,G1H2(83),47,0,G2H2(117),n2h2(97))
  call Hloop_VA_Q(ntryL,G1H4(84),ex4(:),G1H2(84),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(84),47,0,G2H2(120),n2h2(98))
  call Hloop_VA_Q(ntryL,G1H4(177),ex4(:),G1H2(89),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(89),47,0,G2H2(123),n2h2(99))
  call Hloop_ZA_Q(ntryL,G1H4(178),ex4(:),G1H2(90),ngZl,m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(90),47,0,G2H2(126),n2h2(100))
  call Hloop_ZA_Q(ntryL,G1H4(96),ex4(:),G1H2(95),ngZl,m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(95),47,0,G2H2(129),n2h2(101))
  call Hloop_ZA_Q(ntryL,G1H4(182),ex4(:),G1H2(96),ngZl,m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(96),47,0,G2H2(132),n2h2(102))
  call Hloop_VQ_A(ntryL,G1H4(142),ex1(:),G1H2(101),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(101),47,0,G2H2(135),n2h2(103))
  call Hloop_VQ_A(ntryL,G1H4(108),ex1(:),G1H2(102),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_Q_A(ntryL,G1H2(102),47,0,G2H2(138),n2h2(104))
  call Hloop_VQ_A(ntryL,G1H4(151),ex1(:),G1H2(107),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(107),47,0,G2H2(141),n2h2(105))
  call Hloop_VQ_A(ntryL,G1H4(146),ex1(:),G1H2(108),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(108),47,0,G2H2(144),n2h2(106))
  call Hloop_VQ_A(ntryL,G1H4(157),ex1(:),G1H2(113),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(113),47,0,G2H2(147),n2h2(107))
  call Hloop_ZQ_A(ntryL,G1H4(147),ex1(:),G1H2(114),ngZl,m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(114),47,0,G2H2(148),n2h2(108))
  call Hloop_ZQ_A(ntryL,G1H4(120),ex1(:),G1H2(119),ngZl,m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(119),47,0,G2H2(149),n2h2(109))
  call Hloop_ZQ_A(ntryL,G1H4(163),ex1(:),G1H2(120),ngZl,m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(120),47,0,G2H2(150),n2h2(110))
  call Hloop_ZQ_A(ntryL,G1H4(148),ex1(:),G1H2(125),ngZl,m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(125),47,0,G2H2(151),n2h2(111))
  call Hloop_ZQ_A(ntryL,G1H4(169),ex1(:),G1H2(126),ngZl,m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_Q_A(ntryL,G1H2(126),47,0,G2H2(152),n2h2(112))
  call Hloop_VA_Q(ntryL,G1H4(128),ex2(:),G1H2(131),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(131),47,0,G2H2(153),n2h2(113))
  call Hloop_VA_Q(ntryL,G1H4(138),ex2(:),G1H2(132),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(132),47,0,G2H2(154),n2h2(114))
  call Hloop_VA_Q(ntryL,G1H4(175),ex2(:),G1H2(137),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_A_Q(ntryL,G1H2(137),47,0,G2H2(155),n2h2(115))
  call Hloop_ZA_Q(ntryL,G1H4(130),ex2(:),G1H2(138),ngZl,m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_A_Q(ntryL,G1H2(138),47,0,G2H2(156),n2h2(116))
  call Hloop_ZA_Q(ntryL,G1H4(144),ex2(:),G1H2(143),ngZl,m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(143),47,0,G2H2(157),n2h2(117))
  call Hloop_ZA_Q(ntryL,G1H4(181),ex2(:),G1H2(144),ngZl,m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(144),47,0,G2H2(158),n2h2(118))
  call Hloop_VA_Q(ntryL,G1H4(129),ex2(:),G1H2(149),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(149),47,0,G2H2(159),n2h2(119))
  call Hloop_VA_Q(ntryL,G1H4(187),ex2(:),G1H2(150),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_A_Q(ntryL,G1H2(150),47,0,G2H2(160),n2h2(120))
  call Hloop_ZA_Q(ntryL,G1H4(134),ex2(:),G1H2(155),ngZl,m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(155),47,0,G2H2(161),n2h2(121))
  call Hloop_ZA_Q(ntryL,G1H4(193),ex2(:),G1H2(156),ngZl,m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(156),47,0,G2H2(162),n2h2(122))
  call Hloop_VQ_A(ntryL,G1H4(159),ex1(:),G1H2(161),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_Q_A(ntryL,G1H2(161),47,0,G2H2(163),n2h2(123))
  call Hloop_VQ_A(ntryL,G1H4(156),ex1(:),G1H2(162),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_Q_A(ntryL,G1H2(162),47,0,G2H2(164),n2h2(124))
  call Hloop_VQ_A(ntryL,G1H4(160),ex1(:),G1H2(167),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_Q_A(ntryL,G1H2(167),47,0,G2H2(165),n2h2(125))
  call Hloop_ZQ_A(ntryL,G1H4(164),ex1(:),G1H2(168),ngZl,m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(168),47,0,G2H2(166),n2h2(126))
  call Hloop_ZQ_A(ntryL,G1H4(168),ex1(:),G1H2(173),ngZl,m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_Q_A(ntryL,G1H2(173),47,0,G2H2(167),n2h2(127))
  call Hloop_ZQ_A(ntryL,G1H4(165),ex1(:),G1H2(174),ngZl,m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_Q_A(ntryL,G1H2(174),47,0,G2H2(168),n2h2(128))
  call Hloop_VA_Q(ntryL,G1H4(111),ex2(:),G1H2(179),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(179),47,0,G2H2(169),n2h2(129))
  call Hloop_VA_Q(ntryL,G1H4(186),ex2(:),G1H2(180),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_A_Q(ntryL,G1H2(180),47,0,G2H2(170),n2h2(130))
  call Hloop_ZA_Q(ntryL,G1H4(116),ex2(:),G1H2(185),ngZl,m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(171),n2h2(131))
  call Hloop_ZA_Q(ntryL,G1H4(192),ex2(:),G1H2(186),ngZl,m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_A_Q(ntryL,G1H2(186),47,0,G2H2(172),n2h2(132))
  call Hloop_VA_Q(ntryL,G1H4(112),ex2(:),G1H2(191),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_A_Q(ntryL,G1H2(191),47,0,G2H2(173),n2h2(133))
  call Hloop_ZA_Q(ntryL,G1H4(117),ex2(:),G1H2(192),ngZl,m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(192),47,0,G2H2(174),n2h2(134))
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(41),mass5set(:,12),  & 
G1H4(173),G1H4(174),G1H4(179),G1H4(180),G1H4(185),G1H4(191),4)
  call HG1shiftOLR(G1H4(174),4,4)
  call Hotf_5pt_reduction(G2H4(146),RedSet_5(24),mass5set(:,8),  & 
G1H4(197),G1H4(63),G1H4(198),G1H4(204),G1H4(209),G1H4(58),4)
  call HG1shiftOLR(G1H4(63),4,4)
  call Hloop_WA_Q(ntryL,G1H4(203),ex4(:),G1H2(197),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_A_Q(ntryL,G1H2(197),59,0,G2H2(175),n2h2(135))
  call Hotf_4pt_reduction(G2H4(148),RedSet_4(65),mass4set(:,1),  & 
G1H4(210),G1H4(216),G1H4(1),G1H4(2),G1H4(194),4)
  call HG1shiftOLR(G1H4(216),4,4)
  call Hloop_WA_Q(ntryL,G1H4(205),ex4(:),G1H2(198),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_A_Q(ntryL,G1H2(198),59,0,G2H2(176),n2h2(136))
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(42),mass5set(:,12),  & 
G1H4(12),G1H4(55),G1H4(195),G1H4(67),G1H4(196),G1H4(24),4)
  call HG1shiftOLR(G1H4(55),8,4)
  call Hotf_5pt_reduction(G2H4(155),RedSet_5(26),mass5set(:,8),  & 
G1H4(61),G1H4(201),G1H4(73),G1H4(184),G1H4(42),G1H4(79),4)
  call HG1shiftOLR(G1H4(201),8,4)
  call Hloop_WQ_A(ntryL,G1H4(215),ex3(:),G1H2(203),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(203),55,0,G2H2(177),n2h2(137))
  call Hotf_4pt_reduction(G2H4(157),RedSet_4(79),mass4set(:,1),  & 
G1H4(188),G1H4(48),G1H4(91),G1H4(189),G1H4(85),4)
  call HG1shiftOLR(G1H4(48),8,4)
  call Hloop_WQ_A(ntryL,G1H4(217),ex3(:),G1H2(204),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(204),55,0,G2H2(178),n2h2(138))
  call Hloop_QA_W(ntryL,G2H4(33),ex2(:),G2H2(179),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_AQ_W(ntryL,G2H4(34),ex3(:),G2H2(180),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_AQ_W(ntryL,G2H4(35),ex1(:),G2H2(181),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_QA_W(ntryL,G2H4(37),ex4(:),G2H2(182),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_QA_V(ntryL,G2H4(41),ex2(:),G2H2(183),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_QA_V(ntryL,G2H4(44),ex2(:),G2H2(184),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_QA_Z(ntryL,G2H4(45),ex2(:),G2H2(185),ngZl,m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_QA_Z(ntryL,G2H4(48),ex2(:),G2H2(186),ngZl,m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_QA_V(ntryL,G2H4(49),ex2(:),G2H2(187),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_QA_Z(ntryL,G2H4(51),ex2(:),G2H2(188),ngZl,m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_QA_V(ntryL,G2H4(52),ex4(:),G2H2(189),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_QA_V(ntryL,G2H4(55),ex4(:),G2H2(190),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_QA_Z(ntryL,G2H4(56),ex4(:),G2H2(191),ngZl,m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_QA_Z(ntryL,G2H4(58),ex4(:),G2H2(192),ngZl,m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_QA_V(ntryL,G2H4(59),ex4(:),G2H2(193),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_QA_Z(ntryL,G2H4(62),ex4(:),G2H2(194),ngZl,m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_AQ_V(ntryL,G2H4(63),ex1(:),G2H2(195),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_AQ_V(ntryL,G2H4(66),ex1(:),G2H2(196),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_AQ_V(ntryL,G2H4(67),ex1(:),G2H2(197),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_AQ_Z(ntryL,G2H4(70),ex1(:),G2H2(198),ngZl,m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_AQ_Z(ntryL,G2H4(71),ex1(:),G2H2(199),ngZl,m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_AQ_Z(ntryL,G2H4(74),ex1(:),G2H2(200),ngZl,m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_AQ_V(ntryL,G2H4(75),ex3(:),G2H2(201),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_AQ_V(ntryL,G2H4(78),ex3(:),G2H2(202),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_AQ_Z(ntryL,G2H4(79),ex3(:),G2H2(203),ngZl,m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_AQ_Z(ntryL,G2H4(82),ex3(:),G2H2(204),ngZl,m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_AQ_V(ntryL,G2H4(83),ex3(:),G2H2(205),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_AQ_Z(ntryL,G2H4(86),ex3(:),G2H2(206),ngZl,m3h2x2(:,268),heltab2x4(:,:,268))
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(22),mass5set(:,3),  & 
G1H4(190),G1H4(97),G1H4(202),G1H4(66),G1H4(206),G1H4(72),4)
  call HG1shiftOLR(G1H4(97),16,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(22),mass5set(:,13),  & 
G1H4(207),G1H4(208),G1H4(176),G1H4(84),G1H4(177),G1H4(178),4)
  call HG1shiftOLR(G1H4(208),16,4)
  call Hloop_AQ_W(ntryL,G2H4(91),ex3(:),G2H2(207),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hotf_5pt_reduction(G2H8(53),RedSet_5(43),mass5set(:,3),  & 
G1H8(143),G1H8(77),G1H8(78),G1H8(79),G1H8(80),G1H8(84),8)
  call HG1shiftOLR(G1H8(77),16,8)
  call Hotf_5pt_reduction(G2H8(54),RedSet_5(43),mass5set(:,4),  & 
G1H8(85),G1H8(86),G1H8(89),G1H8(90),G1H8(91),G1H8(92),8)
  call HG1shiftOLR(G1H8(86),16,8)
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(43),mass5set(:,3),  & 
G1H8(95),G1H8(96),G1H8(97),G1H8(98),G1H8(101),G1H8(103),8)
  call HG1shiftOLR(G1H8(96),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(43),mass5set(:,4),  & 
G1H8(104),G1H8(107),G1H8(108),G1H8(109),G1H8(110),G1H8(113),8)
  call HG1shiftOLR(G1H8(107),16,8)
  call Hloop_VV_S(ntryL,G1H8(29),wf4(:,1),G1H2(209),m3h4x2(:,1),heltab2x8(:,:,279))
  call Hloop_VV_S(ntryL,G1H8(94),wf4(:,6),G1H2(210),m3h4x2(:,2),heltab2x8(:,:,280))
  call Hloop_UW_V(ntryL,G1H8(30),44,wf4(:,1),3,G2H2(208),m3h4x2(:,3),heltab2x8(:,:,281))
  call Hloop_UW_V(ntryL,G1H8(31),44,wf4(:,6),3,G2H2(209),m3h4x2(:,4),heltab2x8(:,:,282))
  call Hloop_VV_S(ntryL,G2H8(3),wf4(:,1),G2H2(210),m3h4x2(:,5),heltab2x8(:,:,283))
  call Hloop_VV_S(ntryL,G2H8(4),wf4(:,6),G2H2(211),m3h4x2(:,6),heltab2x8(:,:,284))
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(43),mass5set(:,2),  & 
G1H8(114),G1H8(115),G1H8(116),G1H8(119),G1H8(120),G1H8(122),8)
  call HG1shiftOLR(G1H8(115),16,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(43),mass5set(:,2),  & 
G1H8(125),G1H8(126),G1H8(127),G1H8(132),G1H8(8),G1H8(9),8)
  call HG1shiftOLR(G1H8(126),16,8)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(25),mass5set(:,3),  & 
G1H4(96),G1H4(182),G1H4(142),G1H4(108),G1H4(151),G1H4(146),4)
  call HG1shiftOLR(G1H4(182),16,4)
  call Hotf_5pt_reduction(G2H4(95),RedSet_5(25),mass5set(:,13),  & 
G1H4(157),G1H4(147),G1H4(120),G1H4(163),G1H4(148),G1H4(169),4)
  call HG1shiftOLR(G1H4(147),16,4)
  call Hloop_QA_W(ntryL,G2H4(98),ex4(:),G2H2(212),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(44),mass5set(:,3),  & 
G1H8(2),G1H8(10),G1H8(18),G1H8(19),G1H8(20),G1H8(21),8)
  call HG1shiftOLR(G1H8(10),16,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(44),mass5set(:,4),  & 
G1H8(53),G1H8(54),G1H8(55),G1H8(56),G1H8(66),G1H8(67),8)
  call HG1shiftOLR(G1H8(54),16,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(44),mass5set(:,3),  & 
G1H8(68),G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),8)
  call HG1shiftOLR(G1H8(133),16,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(44),mass5set(:,4),  & 
G1H8(138),G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(6),8)
  call HG1shiftOLR(G1H8(139),16,8)
  call Hloop_VV_S(ntryL,G1H8(117),wf4(:,1),G1H2(215),m3h4x2(:,7),heltab2x8(:,:,285))
  call Hloop_VV_S(ntryL,G1H8(130),wf4(:,6),G1H2(216),m3h4x2(:,8),heltab2x8(:,:,286))
  call Hloop_UV_W(ntryL,G1H8(123),44,wf4(:,1),3,G2H2(213),m3h4x2(:,9),heltab2x8(:,:,287))
  call Hloop_UV_W(ntryL,G1H8(129),44,wf4(:,6),3,G2H2(214),m3h4x2(:,10),heltab2x8(:,:,288))
  call Hloop_VV_S(ntryL,G2H8(11),wf4(:,1),G2H2(215),m3h4x2(:,11),heltab2x8(:,:,289))
  call Hloop_VV_S(ntryL,G2H8(12),wf4(:,6),G2H2(216),m3h4x2(:,12),heltab2x8(:,:,290))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(44),mass5set(:,2),  & 
G1H8(7),G1H8(12),G1H8(16),G1H8(17),G1H8(22),G1H8(23),8)
  call HG1shiftOLR(G1H8(12),16,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(44),mass5set(:,2),  & 
G1H8(28),G1H8(33),G1H8(34),G1H8(39),G1H8(40),G1H8(46),8)
  call HG1shiftOLR(G1H8(33),16,8)
  call Hloop_AQ_W(ntryL,G2H4(99),ex3(:),G2H2(217),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_QA_W(ntryL,G2H4(102),ex4(:),G2H2(218),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(4),mass5set(:,3),  & 
G1H8(51),G1H8(57),G1H8(64),G1H8(70),G1H8(88),G1H8(93),8)
  call HG1shiftOLR(G1H8(57),12,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(4),mass5set(:,4),  & 
G1H8(99),G1H8(100),G1H8(105),G1H8(118),G1H8(3),G1H8(14),8)
  call HG1shiftOLR(G1H8(100),12,8)
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(4),mass5set(:,3),  & 
G1H8(13),G1H8(4),G1H8(24),G1H8(37),G1H8(36),G1H8(35),8)
  call HG1shiftOLR(G1H8(4),12,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(4),mass5set(:,4),  & 
G1H8(49),G1H8(47),G1H8(61),G1H8(60),G1H8(59),G1H8(73),8)
  call HG1shiftOLR(G1H8(47),12,8)
  call Hloop_VV_S(ntryL,G1H8(38),ex5(:),G1H4(128),m3h2x4(:,279),heltab2x8(:,:,291))
  call Hloop_VV_S(ntryL,G1H8(69),ex5(:),G1H4(138),m3h2x4(:,280),heltab2x8(:,:,292))
  call Hloop_VV_S(ntryL,G2H8(45),ex5(:),G2H4(50),m3h2x4(:,281),heltab2x8(:,:,293))
  call Hloop_VV_S(ntryL,G2H8(33),ex5(:),G2H4(57),m3h2x4(:,282),heltab2x8(:,:,294))
  call Hloop_UV_W(ntryL,G1H8(82),35,ex5(:),16,G2H4(61),m3h2x4(:,283),heltab2x8(:,:,295))
  call Hloop_UV_W(ntryL,G1H8(75),35,ex5(:),16,G2H4(65),m3h2x4(:,284),heltab2x8(:,:,296))
  call Hotf_5pt_reduction(G2H8(39),RedSet_5(4),mass5set(:,2),  & 
G1H8(71),G1H8(131),G1H8(121),G1H8(65),G1H8(128),G1H8(102),8)
  call HG1shiftOLR(G1H8(131),12,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(4),mass5set(:,2),  & 
G1H8(41),G1H8(52),G1H8(42),G1H8(58),G1H8(44),G1H8(63),8)
  call HG1shiftOLR(G1H8(52),12,8)
  call Hotf_5pt_reduction(G2H4(103),RedSet_5(23),mass5set(:,3),  & 
G1H4(175),G1H4(130),G1H4(144),G1H4(181),G1H4(129),G1H4(187),4)
  call HG1shiftOLR(G1H4(130),16,4)
  call Hotf_5pt_reduction(G2H4(106),RedSet_5(23),mass5set(:,13),  & 
G1H4(134),G1H4(193),G1H4(159),G1H4(156),G1H4(160),G1H4(164),4)
  call HG1shiftOLR(G1H4(193),16,4)
  call Hloop_AQ_W(ntryL,G2H4(107),ex1(:),G2H2(219),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(6),mass5set(:,3),  & 
G1H8(76),G1H8(29),G1H8(94),G1H8(30),G1H8(31),G1H8(117),8)
  call HG1shiftOLR(G1H8(29),12,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(6),mass5set(:,4),  & 
G1H8(130),G1H8(123),G1H8(129),G1H8(38),G1H8(69),G1H8(82),8)
  call HG1shiftOLR(G1H8(123),12,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(6),mass5set(:,3),  & 
G1H8(75),G1H8(144),G1H8(145),G1H8(146),G1H8(147),G1H8(148),8)
  call HG1shiftOLR(G1H8(144),12,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(6),mass5set(:,4),  & 
G1H8(149),G1H8(150),G1H8(151),G1H8(152),G1H8(153),G1H8(154),8)
  call HG1shiftOLR(G1H8(150),12,8)
  call Hloop_VV_S(ntryL,G1H8(111),ex5(:),G1H4(168),m3h2x4(:,285),heltab2x8(:,:,297))
  call Hloop_VV_S(ntryL,G1H8(124),ex5(:),G1H4(165),m3h2x4(:,286),heltab2x8(:,:,298))
  call Hloop_VV_S(ntryL,G2H8(29),ex5(:),G2H4(69),m3h2x4(:,287),heltab2x8(:,:,299))
  call Hloop_VV_S(ntryL,G2H8(30),ex5(:),G2H4(73),m3h2x4(:,288),heltab2x8(:,:,300))
  call Hloop_UW_V(ntryL,G1H8(5),35,ex5(:),16,G2H4(25),m3h2x4(:,289),heltab2x8(:,:,301))
  call Hloop_UW_V(ntryL,G1H8(1),35,ex5(:),16,G2H4(77),m3h2x4(:,290),heltab2x8(:,:,302))
  call Hotf_5pt_reduction(G2H8(35),RedSet_5(6),mass5set(:,2),  & 
G1H8(111),G1H8(124),G1H8(5),G1H8(1),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(124),12,8)
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(6),mass5set(:,2),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),12,8)
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(45),mass5set(:,3),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),16,8)
  call Hotf_5pt_reduction(G2H8(42),RedSet_5(45),mass5set(:,4),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),16,8)
  call Hotf_5pt_reduction(G2H8(47),RedSet_5(45),mass5set(:,3),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),16,8)
  call Hotf_5pt_reduction(G2H8(48),RedSet_5(45),mass5set(:,4),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),16,8)
  call Hloop_VV_S(ntryL,G1H8(50),wf4(:,13),G1H2(221),m3h4x2(:,13),heltab2x8(:,:,303))
  call Hloop_VV_S(ntryL,G1H8(106),wf4(:,16),G1H2(222),m3h4x2(:,14),heltab2x8(:,:,304))
  call Hloop_UW_V(ntryL,G1H8(32),35,wf4(:,13),12,G2H2(220),m3h4x2(:,15),heltab2x8(:,:,305))
  call Hloop_UW_V(ntryL,G1H8(15),35,wf4(:,16),12,G2H2(221),m3h4x2(:,16),heltab2x8(:,:,306))
  call Hloop_VV_S(ntryL,G2H8(52),wf4(:,13),G2H2(222),m3h4x2(:,17),heltab2x8(:,:,307))
  call Hloop_VV_S(ntryL,G2H8(28),wf4(:,16),G2H2(223),m3h4x2(:,18),heltab2x8(:,:,308))
  call Hotf_5pt_reduction(G2H8(46),RedSet_5(45),mass5set(:,2),  & 
G1H8(50),G1H8(106),G1H8(32),G1H8(15),G1H8(187),G1H8(188),8)
  call HG1shiftOLR(G1H8(106),16,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(45),mass5set(:,2),  & 
G1H8(189),G1H8(190),G1H8(191),G1H8(192),G1H8(193),G1H8(194),8)
  call HG1shiftOLR(G1H8(190),16,8)
  call Hotf_5pt_reduction(G2H4(110),RedSet_5(21),mass5set(:,3),  & 
G1H4(111),G1H4(186),G1H4(116),G1H4(192),G1H4(112),G1H4(117),4)
  call HG1shiftOLR(G1H4(186),16,4)
  call Hotf_5pt_reduction(G2H4(111),RedSet_5(21),mass5set(:,13),  & 
G1H4(203),G1H4(205),G1H4(215),G1H4(217),G1H4(219),G1H4(220),4)
  call HG1shiftOLR(G1H4(205),16,4)
  call Hloop_QA_W(ntryL,G2H4(114),ex2(:),G2H2(224),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hotf_5pt_reduction(G2H8(40),RedSet_5(46),mass5set(:,3),  & 
G1H8(195),G1H8(196),G1H8(197),G1H8(198),G1H8(199),G1H8(200),8)
  call HG1shiftOLR(G1H8(196),16,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(46),mass5set(:,4),  & 
G1H8(201),G1H8(202),G1H8(203),G1H8(204),G1H8(205),G1H8(206),8)
  call HG1shiftOLR(G1H8(202),16,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(46),mass5set(:,3),  & 
G1H8(207),G1H8(208),G1H8(209),G1H8(210),G1H8(211),G1H8(212),8)
  call HG1shiftOLR(G1H8(208),16,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(46),mass5set(:,4),  & 
G1H8(213),G1H8(214),G1H8(215),G1H8(216),G1H8(217),G1H8(218),8)
  call HG1shiftOLR(G1H8(214),16,8)
  call Hloop_VV_S(ntryL,G1H8(26),wf4(:,13),G1H2(227),m3h4x2(:,19),heltab2x8(:,:,309))
  call Hloop_VV_S(ntryL,G1H8(62),wf4(:,16),G1H2(228),m3h4x2(:,20),heltab2x8(:,:,310))
  call Hloop_UV_W(ntryL,G1H8(81),35,wf4(:,13),12,G2H2(225),m3h4x2(:,21),heltab2x8(:,:,311))
  call Hloop_UV_W(ntryL,G1H8(74),35,wf4(:,16),12,G2H2(226),m3h4x2(:,22),heltab2x8(:,:,312))
  call Hloop_VV_S(ntryL,G2H8(25),wf4(:,13),G2H2(227),m3h4x2(:,23),heltab2x8(:,:,313))
  call Hloop_VV_S(ntryL,G2H8(26),wf4(:,16),G2H2(228),m3h4x2(:,24),heltab2x8(:,:,314))
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(46),mass5set(:,2),  & 
G1H8(26),G1H8(62),G1H8(81),G1H8(74),G1H8(219),G1H8(220),8)
  call HG1shiftOLR(G1H8(62),16,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(46),mass5set(:,2),  & 
G1H8(221),G1H8(222),G1H8(223),G1H8(224),G1H8(225),G1H8(226),8)
  call HG1shiftOLR(G1H8(222),16,8)
  call Hloop_AQ_W(ntryL,G2H4(115),ex1(:),G2H2(229),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_QA_W(ntryL,G2H4(118),ex2(:),G2H2(230),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_QA_V(ntryL,G2H8(37),ex4(:),G2H4(26),m3h2x4(:,291),heltab2x8(:,:,315))
  call Hloop_QA_Z(ntryL,G2H8(38),ex4(:),G2H4(81),ngZl,m3h2x4(:,292),heltab2x8(:,:,316))
  call Hloop_QA_V(ntryL,G2H8(43),ex4(:),G2H4(27),m3h2x4(:,293),heltab2x8(:,:,317))
  call Hloop_QA_Z(ntryL,G2H8(44),ex4(:),G2H4(85),ngZl,m3h2x4(:,294),heltab2x8(:,:,318))
  call Hotf_5pt_reduction(G2H8(49),RedSet_5(3),mass5set(:,1),  & 
G1H8(227),G1H8(228),G1H8(229),G1H8(230),G1H8(231),G1H8(232),8)
  call HG1shiftOLR(G1H8(228),17,8)
  call Hloop_AQ_V(ntryL,G2H8(50),wf4(:,14),G2H2(231),m3h4x2(:,25),heltab2x8(:,:,319))
  call Hloop_AQ_Z(ntryL,G2H8(55),wf4(:,14),G2H2(232),ngZl,m3h4x2(:,26),heltab2x8(:,:,320))
  call Hloop_AQ_V(ntryL,G2H8(56),wf4(:,14),G2H2(233),m3h4x2(:,27),heltab2x8(:,:,321))
  call Hloop_AQ_Z(ntryL,G2H8(57),wf4(:,14),G2H2(234),ngZl,m3h4x2(:,28),heltab2x8(:,:,322))
  call Hloop_AQ_V(ntryL,G2H8(58),ex3(:),G2H4(28),m3h2x4(:,295),heltab2x8(:,:,323))
  call Hloop_AQ_Z(ntryL,G2H8(59),ex3(:),G2H4(89),ngZl,m3h2x4(:,296),heltab2x8(:,:,324))
  call Hloop_AQ_V(ntryL,G2H8(60),ex3(:),G2H4(93),m3h2x4(:,297),heltab2x8(:,:,325))
  call Hloop_AQ_Z(ntryL,G2H8(61),ex3(:),G2H4(97),ngZl,m3h2x4(:,298),heltab2x8(:,:,326))
  call Hloop_QA_V(ntryL,G2H8(62),ex4(:),G2H4(101),m3h2x4(:,299),heltab2x8(:,:,327))
  call Hloop_QA_Z(ntryL,G2H8(63),ex4(:),G2H4(105),ngZl,m3h2x4(:,300),heltab2x8(:,:,328))
  call Hloop_QA_V(ntryL,G2H8(64),ex4(:),G2H4(29),m3h2x4(:,301),heltab2x8(:,:,329))
  call Hloop_QA_Z(ntryL,G2H8(65),ex4(:),G2H4(109),ngZl,m3h2x4(:,302),heltab2x8(:,:,330))
  call Hloop_QA_V(ntryL,G2H8(66),wf4(:,20),G2H2(235),m3h4x2(:,29),heltab2x8(:,:,331))
  call Hloop_QA_Z(ntryL,G2H8(67),wf4(:,20),G2H2(236),ngZl,m3h4x2(:,30),heltab2x8(:,:,332))
  call Hloop_QA_V(ntryL,G2H8(68),wf4(:,20),G2H2(237),m3h4x2(:,31),heltab2x8(:,:,333))
  call Hloop_QA_Z(ntryL,G2H8(69),wf4(:,20),G2H2(238),ngZl,m3h4x2(:,32),heltab2x8(:,:,334))
  call Hloop_AQ_V(ntryL,G2H8(70),ex3(:),G2H4(30),m3h2x4(:,303),heltab2x8(:,:,335))
  call Hloop_AQ_Z(ntryL,G2H8(71),ex3(:),G2H4(113),ngZl,m3h2x4(:,304),heltab2x8(:,:,336))
  call Hloop_AQ_V(ntryL,G2H8(72),ex3(:),G2H4(31),m3h2x4(:,305),heltab2x8(:,:,337))
  call Hloop_AQ_Z(ntryL,G2H8(73),ex3(:),G2H4(117),ngZl,m3h2x4(:,306),heltab2x8(:,:,338))
  call Hotf_5pt_reduction(G2H8(74),RedSet_5(1),mass5set(:,1),  & 
G1H8(233),G1H8(234),G1H8(235),G1H8(236),G1H8(237),G1H8(238),8)
  call HG1shiftOLR(G1H8(234),18,8)
  call Hotf_5pt_reduction(G2H8(75),RedSet_5(2),mass5set(:,1),  & 
G1H8(239),G1H8(240),G1H8(241),G1H8(242),G1H8(243),G1H8(244),8)
  call HG1shiftOLR(G1H8(240),20,8)
  call Hloop_QA_V(ntryL,G2H8(76),ex2(:),G2H4(32),m3h2x4(:,307),heltab2x8(:,:,339))
  call Hloop_QA_Z(ntryL,G2H8(77),ex2(:),G2H4(121),ngZl,m3h2x4(:,308),heltab2x8(:,:,340))
  call Hloop_QA_V(ntryL,G2H8(78),ex2(:),G2H4(38),m3h2x4(:,309),heltab2x8(:,:,341))
  call Hloop_QA_Z(ntryL,G2H8(79),ex2(:),G2H4(39),ngZl,m3h2x4(:,310),heltab2x8(:,:,342))
  call Hotf_5pt_reduction(G2H8(80),RedSet_5(20),mass5set(:,1),  & 
G1H8(245),G1H8(246),G1H8(247),G1H8(248),G1H8(249),G1H8(250),8)
  call HG1shiftOLR(G1H8(246),8,8)
  call Hloop_AQ_V(ntryL,G2H8(81),ex1(:),G2H4(42),m3h2x4(:,311),heltab2x8(:,:,343))
  call Hloop_AQ_V(ntryL,G2H8(82),ex1(:),G2H4(43),m3h2x4(:,312),heltab2x8(:,:,344))
  call Hloop_AQ_Z(ntryL,G2H8(83),ex1(:),G2H4(46),ngZl,m3h2x4(:,313),heltab2x8(:,:,345))
  call Hloop_AQ_Z(ntryL,G2H8(84),ex1(:),G2H4(47),ngZl,m3h2x4(:,314),heltab2x8(:,:,346))
  call Hloop_AQ_V(ntryL,G2H8(85),wf4(:,4),G2H2(239),m3h4x2(:,33),heltab2x8(:,:,347))
  call Hloop_AQ_Z(ntryL,G2H8(86),wf4(:,4),G2H2(240),ngZl,m3h4x2(:,34),heltab2x8(:,:,348))
  call Hloop_AQ_V(ntryL,G2H8(87),wf4(:,4),G2H2(241),m3h4x2(:,35),heltab2x8(:,:,349))
  call Hloop_AQ_Z(ntryL,G2H8(88),wf4(:,4),G2H2(242),ngZl,m3h4x2(:,36),heltab2x8(:,:,350))
  call Hloop_QA_V(ntryL,G2H8(89),ex2(:),G2H4(3),m3h2x4(:,315),heltab2x8(:,:,351))
  call Hloop_QA_Z(ntryL,G2H8(90),ex2(:),G2H4(53),ngZl,m3h2x4(:,316),heltab2x8(:,:,352))
  call Hloop_QA_V(ntryL,G2H8(91),ex2(:),G2H4(54),m3h2x4(:,317),heltab2x8(:,:,353))
  call Hloop_QA_Z(ntryL,G2H8(92),ex2(:),G2H4(8),ngZl,m3h2x4(:,318),heltab2x8(:,:,354))
  call Hotf_5pt_reduction(G2H8(93),RedSet_5(5),mass5set(:,1),  & 
G1H8(251),G1H8(252),G1H8(253),G1H8(254),G1H8(255),G1H8(256),8)
  call HG1shiftOLR(G1H8(252),24,8)
  call Hloop_AQ_V(ntryL,G2H8(94),ex1(:),G2H4(60),m3h2x4(:,319),heltab2x8(:,:,355))
  call Hloop_AQ_V(ntryL,G2H8(95),ex1(:),G2H4(119),m3h2x4(:,320),heltab2x8(:,:,356))
  call Hloop_AQ_Z(ntryL,G2H8(96),ex1(:),G2H4(64),ngZl,m3h2x4(:,321),heltab2x8(:,:,357))
  call Hloop_AQ_Z(ntryL,G2H8(97),ex1(:),G2H4(1),ngZl,m3h2x4(:,322),heltab2x8(:,:,358))
  call Hotf_5pt_reduction(G2H8(98),RedSet_5(19),mass5set(:,1),  & 
G1H8(257),G1H8(258),G1H8(259),G1H8(260),G1H8(261),G1H8(262),8)
  call HG1shiftOLR(G1H8(258),4,8)
  call Hloop_QA_V(ntryL,G2H8(99),wf4(:,10),G2H2(243),m3h4x2(:,37),heltab2x8(:,:,359))
  call Hloop_QA_Z(ntryL,G2H8(100),wf4(:,10),G2H2(244),ngZl,m3h4x2(:,38),heltab2x8(:,:,360))
  call Hloop_QA_V(ntryL,G2H8(101),wf4(:,10),G2H2(245),m3h4x2(:,39),heltab2x8(:,:,361))
  call Hloop_QA_Z(ntryL,G2H8(102),wf4(:,10),G2H2(246),ngZl,m3h4x2(:,40),heltab2x8(:,:,362))
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(47),mass5set(:,3),  & 
G1H4(221),G1H4(222),G1H4(223),G1H4(224),G1H4(225),G1H4(226),4)
  call HG1shiftOLR(G1H4(222),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(47),mass5set(:,10),  & 
G1H4(227),G1H4(228),G1H4(229),G1H4(230),G1H4(231),G1H4(232),4)
  call HG1shiftOLR(G1H4(228),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(47),mass5set(:,4),  & 
G1H4(233),G1H4(234),G1H4(235),G1H4(236),G1H4(237),G1H4(238),4)
  call HG1shiftOLR(G1H4(234),8,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(47),mass5set(:,11),  & 
G1H4(239),G1H4(240),G1H4(241),G1H4(242),G1H4(243),G1H4(244),4)
  call HG1shiftOLR(G1H4(240),8,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(48),mass5set(:,3),  & 
G1H4(245),G1H4(246),G1H4(247),G1H4(248),G1H4(249),G1H4(250),4)
  call HG1shiftOLR(G1H4(246),4,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(48),mass5set(:,10),  & 
G1H4(251),G1H4(252),G1H4(253),G1H4(254),G1H4(255),G1H4(256),4)
  call HG1shiftOLR(G1H4(252),4,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(48),mass5set(:,4),  & 
G1H4(257),G1H4(258),G1H4(259),G1H4(260),G1H4(261),G1H4(262),4)
  call HG1shiftOLR(G1H4(258),4,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(48),mass5set(:,11),  & 
G1H4(263),G1H4(264),G1H4(265),G1H4(266),G1H4(267),G1H4(268),4)
  call HG1shiftOLR(G1H4(264),4,4)
  call Hloop_AQ_V(ntryL,G2H4(123),ex1(:),G2H2(247),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_AQ_V(ntryL,G2H4(124),ex1(:),G2H2(248),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_AQ_Z(ntryL,G2H4(125),ex1(:),G2H2(249),ngZl,m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_AQ_Z(ntryL,G2H4(126),ex1(:),G2H2(250),ngZl,m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_QA_V(ntryL,G2H4(127),ex2(:),G2H2(251),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_QA_Z(ntryL,G2H4(128),ex2(:),G2H2(252),ngZl,m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_QA_V(ntryL,G2H4(129),ex2(:),G2H2(253),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_QA_Z(ntryL,G2H4(130),ex2(:),G2H2(254),ngZl,m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_QA_W(ntryL,G2H4(131),ex2(:),G2H2(255),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_QA_W(ntryL,G2H4(134),ex2(:),G2H2(256),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_QA_W(ntryL,G2H4(135),ex2(:),G2H2(257),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_AQ_W(ntryL,G2H4(136),ex3(:),G2H2(258),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_AQ_W(ntryL,G2H4(139),ex3(:),G2H2(259),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_AQ_W(ntryL,G2H4(140),ex3(:),G2H2(260),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_AQ_W(ntryL,G2H4(141),ex1(:),G2H2(261),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_AQ_W(ntryL,G2H4(144),ex1(:),G2H2(262),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_AQ_W(ntryL,G2H4(145),ex1(:),G2H2(263),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hotf_4pt_reduction(G2H4(149),RedSet_4(66),mass4set(:,2),  & 
G1H4(269),G1H4(270),G1H4(271),G1H4(272),G1H4(273),4)
  call HG1shiftOLR(G1H4(270),12,4)
  call Hloop_QA_W(ntryL,G2H4(150),ex4(:),G2H2(264),m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_QA_W(ntryL,G2H4(153),ex4(:),G2H2(265),m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_QA_W(ntryL,G2H4(154),ex4(:),G2H2(266),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hotf_4pt_reduction(G2H4(158),RedSet_4(66),mass4set(:,2),  & 
G1H4(274),G1H4(275),G1H4(276),G1H4(277),G1H4(278),4)
  call HG1shiftOLR(G1H4(275),12,4)
  call Hloop_AQ_V(ntryL,G2H4(159),ex3(:),G2H2(267),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_AQ_V(ntryL,G2H4(162),ex3(:),G2H2(268),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_AQ_V(ntryL,G2H4(163),ex3(:),G2H2(269),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_AQ_Z(ntryL,G2H4(164),ex3(:),G2H2(270),ngZl,m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_AQ_Z(ntryL,G2H4(167),ex3(:),G2H2(271),ngZl,m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_AQ_Z(ntryL,G2H4(168),ex3(:),G2H2(272),ngZl,m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_QA_V(ntryL,G2H4(169),ex4(:),G2H2(273),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_QA_V(ntryL,G2H4(172),ex4(:),G2H2(274),m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_QA_V(ntryL,G2H4(173),ex4(:),G2H2(275),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_QA_Z(ntryL,G2H4(174),ex4(:),G2H2(276),ngZl,m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_QA_Z(ntryL,G2H4(177),ex4(:),G2H2(277),ngZl,m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_QA_Z(ntryL,G2H4(178),ex4(:),G2H2(278),ngZl,m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_AQ_W(ntryL,G2H4(179),ex3(:),G2H2(279),m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_AQ_W(ntryL,G2H4(181),ex3(:),G2H2(280),m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_AQ_W(ntryL,G2H4(182),ex3(:),G2H2(281),m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_QA_W(ntryL,G2H4(183),ex4(:),G2H2(282),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_QA_W(ntryL,G2H4(185),ex4(:),G2H2(283),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_QA_W(ntryL,G2H4(186),ex4(:),G2H2(284),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_AQ_W(ntryL,G2H4(187),ex1(:),G2H2(285),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_AQ_W(ntryL,G2H4(189),ex1(:),G2H2(286),m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_AQ_W(ntryL,G2H4(190),ex1(:),G2H2(287),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_QA_W(ntryL,G2H4(191),ex2(:),G2H2(288),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_QA_W(ntryL,G2H4(193),ex2(:),G2H2(289),m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_QA_W(ntryL,G2H4(194),ex2(:),G2H2(290),m3h2x2(:,320),heltab2x4(:,:,320))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(210),[G1H4(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(269),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(188),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(274),[G1H4(79)])
  call Hloop_WQ_A(ntryL,G1H4(135),ex1(:),G1H2(233),m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_Q_A(ntryL,G1H2(233),61,0,G2H2(291),n2h2(139))
call HGT_raise_alpha_OLR(G1H4(136),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(136),ex2(:),G1H2(234),m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_WQ_A(ntryL,G1H4(152),ex1(:),G1H2(239),m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_Q_A(ntryL,G1H2(239),61,0,G2H2(292),n2h2(140))
  call Hloop_WQ_A(ntryL,G1H4(153),ex1(:),G1H2(240),m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_Q_A(ntryL,G1H2(240),61,0,G2H2(293),n2h2(141))
  call Hloop_WA_Q(ntryL,G1H4(154),ex4(:),G1H2(245),m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_A_Q(ntryL,G1H2(245),59,0,G2H2(294),n2h2(142))
call HGT_raise_alpha_OLR(G1H4(158),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(158),ex3(:),G1H2(246),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_WA_Q(ntryL,G1H4(171),ex4(:),G1H2(251),m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_A_Q(ntryL,G1H2(251),59,0,G2H2(295),n2h2(143))
  call Hloop_WA_Q(ntryL,G1H4(172),ex4(:),G1H2(252),m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_A_Q(ntryL,G1H2(252),59,0,G2H2(296),n2h2(144))
  call Hloop_WA_Q(ntryL,G1H4(214),ex2(:),G1H2(257),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_A_Q(ntryL,G1H2(257),62,0,G2H2(297),n2h2(145))
call HGT_raise_alpha_OLR(G1H4(218),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(218),ex1(:),G1H2(258),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_WA_Q(ntryL,G1H4(3),ex2(:),G1H2(263),m3h2x2(:,331),heltab2x4(:,:,331))
  call Hloop_A_Q(ntryL,G1H2(263),62,0,G2H2(298),n2h2(146))
  call Hloop_WA_Q(ntryL,G1H4(4),ex2(:),G1H2(264),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_A_Q(ntryL,G1H2(264),62,0,G2H2(299),n2h2(147))
  call Hloop_WA_Q(ntryL,G1H4(8),ex4(:),G1H2(269),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_A_Q(ntryL,G1H2(269),59,0,G2H2(300),n2h2(148))
call HGT_raise_alpha_OLR(G1H4(9),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(9),ex3(:),G1H2(270),m3h2x2(:,334),heltab2x4(:,:,334))
  call Hloop_WA_Q(ntryL,G1H4(15),ex4(:),G1H2(275),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_A_Q(ntryL,G1H2(275),59,0,G2H2(301),n2h2(149))
  call Hloop_WA_Q(ntryL,G1H4(16),ex4(:),G1H2(276),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_A_Q(ntryL,G1H2(276),59,0,G2H2(302),n2h2(150))
  call Hloop_WQ_A(ntryL,G1H4(20),ex3(:),G1H2(281),m3h2x2(:,337),heltab2x4(:,:,337))
  call Hloop_Q_A(ntryL,G1H2(281),55,0,G2H2(303),n2h2(151))
call HGT_raise_alpha_OLR(G1H4(21),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(21),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(21),ex4(:),G1H2(282),m3h2x2(:,338),heltab2x4(:,:,338))
  call Hloop_WQ_A(ntryL,G1H4(27),ex3(:),G1H2(287),m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_Q_A(ntryL,G1H2(287),55,0,G2H2(304),n2h2(152))
  call Hloop_WQ_A(ntryL,G1H4(28),ex3(:),G1H2(288),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_Q_A(ntryL,G1H2(288),55,0,G2H2(305),n2h2(153))
  call Hloop_WQ_A(ntryL,G1H4(32),ex3(:),G1H2(293),m3h2x2(:,341),heltab2x4(:,:,341))
  call Hloop_Q_A(ntryL,G1H2(293),55,0,G2H2(306),n2h2(154))
call HGT_raise_alpha_OLR(G1H4(33),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(33),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(33),ex4(:),G1H2(294),m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_WQ_A(ntryL,G1H4(40),ex3(:),G1H2(299),m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_Q_A(ntryL,G1H2(299),55,0,G2H2(307),n2h2(155))
  call Hloop_WQ_A(ntryL,G1H4(44),ex3(:),G1H2(300),m3h2x2(:,344),heltab2x4(:,:,344))
  call Hloop_Q_A(ntryL,G1H2(300),55,0,G2H2(308),n2h2(156))
  call Hloop_QV_A(ntryL,G1H4(46),ex5(:),G1H2(305),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_Q_A(ntryL,G1H2(305),61,0,G2H2(309),n2h2(157))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(50),ex2(:),G1H2(306),m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_QV_A(ntryL,G1H4(62),ex5(:),G1H2(311),m3h2x2(:,347),heltab2x4(:,:,347))
  call Hloop_Q_A(ntryL,G1H2(311),61,0,G2H2(310),n2h2(158))
  call Hloop_QV_A(ntryL,G1H4(64),ex5(:),G1H2(312),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_Q_A(ntryL,G1H2(312),61,0,G2H2(311),n2h2(159))
  call Hloop_QV_A(ntryL,G1H4(68),ex5(:),G1H2(5),m3h2x2(:,349),heltab2x4(:,:,349))
  call Hloop_Q_A(ntryL,G1H2(5),61,0,G2H2(312),n2h2(160))
call HGT_raise_alpha_OLR(G1H4(69),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(69),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(69),ex2(:),G1H2(6),ngZl,m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_QV_A(ntryL,G1H4(75),ex5(:),G1H2(11),m3h2x2(:,351),heltab2x4(:,:,351))
  call Hloop_Q_A(ntryL,G1H2(11),61,0,G2H2(313),n2h2(161))
  call Hloop_QV_A(ntryL,G1H4(76),ex5(:),G1H2(12),m3h2x2(:,352),heltab2x4(:,:,352))
  call Hloop_Q_A(ntryL,G1H2(12),61,0,G2H2(314),n2h2(162))
  call Hloop_QV_A(ntryL,G1H4(80),ex5(:),G1H2(17),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_Q_A(ntryL,G1H2(17),61,0,G2H2(315),n2h2(163))
call HGT_raise_alpha_OLR(G1H4(81),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(81),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(81),ex2(:),G1H2(18),m3h2x2(:,354),heltab2x4(:,:,354))
  call Hloop_QV_A(ntryL,G1H4(87),ex5(:),G1H2(23),m3h2x2(:,355),heltab2x4(:,:,355))
  call Hloop_Q_A(ntryL,G1H2(23),61,0,G2H2(316),n2h2(164))
  call Hloop_QV_A(ntryL,G1H4(88),ex5(:),G1H2(24),m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_Q_A(ntryL,G1H2(24),61,0,G2H2(317),n2h2(165))
  call Hloop_QV_A(ntryL,G1H4(92),ex5(:),G1H2(29),m3h2x2(:,357),heltab2x4(:,:,357))
  call Hloop_Q_A(ntryL,G1H2(29),61,0,G2H2(318),n2h2(166))
call HGT_raise_alpha_OLR(G1H4(93),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(93),ex2(:),G1H2(30),ngZl,m3h2x2(:,358),heltab2x4(:,:,358))
  call Hloop_QV_A(ntryL,G1H4(99),ex5(:),G1H2(35),m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_Q_A(ntryL,G1H2(35),61,0,G2H2(319),n2h2(167))
  call Hloop_QV_A(ntryL,G1H4(100),ex5(:),G1H2(36),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hloop_Q_A(ntryL,G1H2(36),61,0,G2H2(320),n2h2(168))
  call Hloop_QV_A(ntryL,G1H4(104),ex5(:),G1H2(41),m3h2x2(:,361),heltab2x4(:,:,361))
  call Hloop_Q_A(ntryL,G1H2(41),55,0,G2H2(321),n2h2(169))
call HGT_raise_alpha_OLR(G1H4(105),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(105),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(105),ex4(:),G1H2(42),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_QV_A(ntryL,G1H4(118),ex5(:),G1H2(47),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_Q_A(ntryL,G1H2(47),55,0,G2H2(322),n2h2(170))
  call Hloop_QV_A(ntryL,G1H4(122),ex5(:),G1H2(48),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hloop_Q_A(ntryL,G1H2(48),55,0,G2H2(323),n2h2(171))
  call Hloop_QV_A(ntryL,G1H4(123),ex5(:),G1H2(53),m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_Q_A(ntryL,G1H2(53),55,0,G2H2(324),n2h2(172))
call HGT_raise_alpha_OLR(G1H4(124),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(124),ex4(:),G1H2(54),ngZl,m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_QV_A(ntryL,G1H4(199),ex5(:),G1H2(59),m3h2x2(:,367),heltab2x4(:,:,367))
  call Hloop_Q_A(ntryL,G1H2(59),55,0,G2H2(325),n2h2(173))
  call Hloop_QV_A(ntryL,G1H4(57),ex5(:),G1H2(60),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_Q_A(ntryL,G1H2(60),55,0,G2H2(326),n2h2(174))
  call Hloop_QV_A(ntryL,G1H4(213),ex5(:),G1H2(65),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_Q_A(ntryL,G1H2(65),55,0,G2H2(327),n2h2(175))
call HGT_raise_alpha_OLR(G1H4(211),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(211),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(211),ex4(:),G1H2(66),m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_QV_A(ntryL,G1H4(7),ex5(:),G1H2(71),m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_Q_A(ntryL,G1H2(71),55,0,G2H2(328),n2h2(176))
  call Hloop_QV_A(ntryL,G1H4(11),ex5(:),G1H2(72),m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_Q_A(ntryL,G1H2(72),55,0,G2H2(329),n2h2(177))
  call Hloop_QV_A(ntryL,G1H4(13),ex5(:),G1H2(77),m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_Q_A(ntryL,G1H2(77),55,0,G2H2(330),n2h2(178))
call HGT_raise_alpha_OLR(G1H4(17),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(17),ex4(:),G1H2(78),ngZl,m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_QV_A(ntryL,G1H4(23),ex5(:),G1H2(83),m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_Q_A(ntryL,G1H2(83),55,0,G2H2(331),n2h2(179))
  call Hloop_QV_A(ntryL,G1H4(25),ex5(:),G1H2(84),m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_Q_A(ntryL,G1H2(84),55,0,G2H2(332),n2h2(180))
  call Hloop_AV_Q(ntryL,G1H4(29),ex5(:),G1H2(89),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_A_Q(ntryL,G1H2(89),62,0,G2H2(333),n2h2(181))
call HGT_raise_alpha_OLR(G1H4(30),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(30),ex1(:),G1H2(90),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_AV_Q(ntryL,G1H4(36),ex5(:),G1H2(95),m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(95),62,0,G2H2(334),n2h2(182))
  call Hloop_AV_Q(ntryL,G1H4(37),ex5(:),G1H2(96),m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_A_Q(ntryL,G1H2(96),62,0,G2H2(335),n2h2(183))
  call Hloop_AV_Q(ntryL,G1H4(41),ex5(:),G1H2(101),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_A_Q(ntryL,G1H2(101),62,0,G2H2(336),n2h2(184))
call HGT_raise_alpha_OLR(G1H4(43),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(43),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(102),m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_AV_Q(ntryL,G1H4(53),ex5(:),G1H2(107),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_A_Q(ntryL,G1H2(107),62,0,G2H2(337),n2h2(185))
  call Hloop_AV_Q(ntryL,G1H4(54),ex5(:),G1H2(108),m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_A_Q(ntryL,G1H2(108),62,0,G2H2(338),n2h2(186))
  call Hloop_AV_Q(ntryL,G1H4(59),ex5(:),G1H2(113),m3h2x2(:,385),heltab2x4(:,:,385))
  call Hloop_A_Q(ntryL,G1H2(113),62,0,G2H2(339),n2h2(187))
call HGT_raise_alpha_OLR(G1H4(60),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(60),ex1(:),G1H2(114),ngZl,m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_AV_Q(ntryL,G1H4(77),ex5(:),G1H2(119),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_A_Q(ntryL,G1H2(119),62,0,G2H2(340),n2h2(188))
  call Hloop_AV_Q(ntryL,G1H4(78),ex5(:),G1H2(120),m3h2x2(:,388),heltab2x4(:,:,388))
  call Hloop_A_Q(ntryL,G1H2(120),62,0,G2H2(341),n2h2(189))
  call Hloop_AV_Q(ntryL,G1H4(83),ex5(:),G1H2(125),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_A_Q(ntryL,G1H2(125),62,0,G2H2(342),n2h2(190))
call HGT_raise_alpha_OLR(G1H4(89),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(89),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(89),ex1(:),G1H2(126),ngZl,m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_AV_Q(ntryL,G1H4(101),ex5(:),G1H2(131),m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_A_Q(ntryL,G1H2(131),62,0,G2H2(343),n2h2(191))
  call Hloop_AV_Q(ntryL,G1H4(102),ex5(:),G1H2(132),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_A_Q(ntryL,G1H2(132),62,0,G2H2(344),n2h2(192))
  call Hloop_AV_Q(ntryL,G1H4(103),ex5(:),G1H2(137),m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_A_Q(ntryL,G1H2(137),59,0,G2H2(345),n2h2(193))
call HGT_raise_alpha_OLR(G1H4(107),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(107),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(107),ex3(:),G1H2(138),m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_AV_Q(ntryL,G1H4(114),ex5(:),G1H2(143),m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_A_Q(ntryL,G1H2(143),59,0,G2H2(346),n2h2(194))
  call Hloop_AV_Q(ntryL,G1H4(115),ex5(:),G1H2(144),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_A_Q(ntryL,G1H2(144),59,0,G2H2(347),n2h2(195))
  call Hloop_AV_Q(ntryL,G1H4(119),ex5(:),G1H2(149),m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_A_Q(ntryL,G1H2(149),59,0,G2H2(348),n2h2(196))
call HGT_raise_alpha_OLR(G1H4(121),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(121),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(121),ex3(:),G1H2(150),ngZl,m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_AV_Q(ntryL,G1H4(127),ex5(:),G1H2(155),m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_A_Q(ntryL,G1H2(155),59,0,G2H2(349),n2h2(197))
  call Hloop_AV_Q(ntryL,G1H4(131),ex5(:),G1H2(156),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_A_Q(ntryL,G1H2(156),59,0,G2H2(350),n2h2(198))
  call Hloop_AV_Q(ntryL,G1H4(132),ex5(:),G1H2(161),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_A_Q(ntryL,G1H2(161),59,0,G2H2(351),n2h2(199))
call HGT_raise_alpha_OLR(G1H4(133),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(133),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(133),ex3(:),G1H2(162),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_AV_Q(ntryL,G1H4(143),ex5(:),G1H2(167),m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_A_Q(ntryL,G1H2(167),59,0,G2H2(352),n2h2(200))
  call Hloop_AV_Q(ntryL,G1H4(145),ex5(:),G1H2(168),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_A_Q(ntryL,G1H2(168),59,0,G2H2(353),n2h2(201))
  call Hloop_AV_Q(ntryL,G1H4(149),ex5(:),G1H2(173),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_A_Q(ntryL,G1H2(173),59,0,G2H2(354),n2h2(202))
call HGT_raise_alpha_OLR(G1H4(150),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(150),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(150),ex3(:),G1H2(174),ngZl,m3h2x2(:,406),heltab2x4(:,:,406))
  call Hloop_AV_Q(ntryL,G1H4(162),ex5(:),G1H2(179),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_A_Q(ntryL,G1H2(179),59,0,G2H2(355),n2h2(203))
  call Hloop_AV_Q(ntryL,G1H4(167),ex5(:),G1H2(180),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hloop_A_Q(ntryL,G1H2(180),59,0,G2H2(356),n2h2(204))
  call Hloop_WA_Q(ntryL,G1H4(173),ex4(:),G1H2(185),m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_A_Q(ntryL,G1H2(185),59,0,G2H2(357),n2h2(205))
call HGT_raise_alpha_OLR(G1H4(174),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(174),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(174),ex3(:),G1H2(186),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_WA_Q(ntryL,G1H4(185),ex4(:),G1H2(191),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_A_Q(ntryL,G1H2(191),59,0,G2H2(358),n2h2(206))
  call Hloop_WA_Q(ntryL,G1H4(191),ex4(:),G1H2(192),m3h2x2(:,412),heltab2x4(:,:,412))
  call Hloop_A_Q(ntryL,G1H2(192),59,0,G2H2(359),n2h2(207))
  call Hloop_WA_Q(ntryL,G1H4(197),ex4(:),G1H2(197),m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_A_Q(ntryL,G1H2(197),59,0,G2H2(360),n2h2(208))
call HGT_raise_alpha_OLR(G1H4(63),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(63),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(63),ex3(:),G1H2(198),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hloop_WA_Q(ntryL,G1H4(210),ex4(:),G1H2(203),m3h2x2(:,415),heltab2x4(:,:,415))
  call Hloop_A_Q(ntryL,G1H2(203),59,0,G2H2(361),n2h2(209))
  call Hloop_WA_Q(ntryL,G1H4(269),ex4(:),G1H2(204),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hloop_A_Q(ntryL,G1H2(204),59,0,G2H2(362),n2h2(210))
call HGT_raise_alpha_OLR(G1H4(216),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(216),ex3(:),G1H2(233),m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_WA_Q(ntryL,G1H4(194),ex4(:),G1H2(239),m3h2x2(:,418),heltab2x4(:,:,418))
  call Hloop_A_Q(ntryL,G1H2(239),59,0,G2H2(363),n2h2(211))
  call Hloop_WQ_A(ntryL,G1H4(12),ex3(:),G1H2(240),m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_Q_A(ntryL,G1H2(240),55,0,G2H2(364),n2h2(212))
call HGT_raise_alpha_OLR(G1H4(55),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(55),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(55),ex4(:),G1H2(245),m3h2x2(:,420),heltab2x4(:,:,420))
  call Hloop_WQ_A(ntryL,G1H4(196),ex3(:),G1H2(251),m3h2x2(:,421),heltab2x4(:,:,421))
  call Hloop_Q_A(ntryL,G1H2(251),55,0,G2H2(365),n2h2(213))
  call Hloop_WQ_A(ntryL,G1H4(24),ex3(:),G1H2(252),m3h2x2(:,422),heltab2x4(:,:,422))
  call Hloop_Q_A(ntryL,G1H2(252),55,0,G2H2(366),n2h2(214))
  call Hloop_WQ_A(ntryL,G1H4(61),ex3(:),G1H2(257),m3h2x2(:,423),heltab2x4(:,:,423))
  call Hloop_Q_A(ntryL,G1H2(257),55,0,G2H2(367),n2h2(215))
call HGT_raise_alpha_OLR(G1H4(201),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(201),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(201),ex4(:),G1H2(263),m3h2x2(:,424),heltab2x4(:,:,424))
  call Hloop_WQ_A(ntryL,G1H4(188),ex3(:),G1H2(264),m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_Q_A(ntryL,G1H2(264),55,0,G2H2(368),n2h2(216))
  call Hloop_WQ_A(ntryL,G1H4(274),ex3(:),G1H2(269),m3h2x2(:,426),heltab2x4(:,:,426))
  call Hloop_Q_A(ntryL,G1H2(269),55,0,G2H2(369),n2h2(217))
call HGT_raise_alpha_OLR(G1H4(48),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(48),ex4(:),G1H2(275),m3h2x2(:,427),heltab2x4(:,:,427))
  call Hloop_WQ_A(ntryL,G1H4(85),ex3(:),G1H2(276),m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_Q_A(ntryL,G1H2(276),55,0,G2H2(370),n2h2(218))
  call Hloop_VQ_A(ntryL,G1H4(190),ex3(:),G1H2(281),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_Q_A(ntryL,G1H2(281),47,0,G2H2(371),n2h2(219))
call HGT_OLR(G1H4(97),1,1,4)
call HGT_invQ_OLR(G1H4(97),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(97),-16,0,G2H4(68),n2h4(253))
  call Hloop_AV_Q(ntryL,G2H4(68),ex5(:),G2H2(372),m3h2x2(:,430),heltab2x4(:,:,430))
  call Hloop_VQ_A(ntryL,G1H4(206),ex3(:),G1H2(287),m3h2x2(:,431),heltab2x4(:,:,431))
  call Hloop_Q_A(ntryL,G1H2(287),47,0,G2H2(373),n2h2(220))
  call Hloop_VQ_A(ntryL,G1H4(72),ex3(:),G1H2(288),m3h2x2(:,432),heltab2x4(:,:,432))
  call Hloop_Q_A(ntryL,G1H2(288),47,0,G2H2(374),n2h2(221))
  call Hloop_ZQ_A(ntryL,G1H4(207),ex3(:),G1H2(293),ngZl,m3h2x2(:,433),heltab2x4(:,:,433))
  call Hloop_Q_A(ntryL,G1H2(293),47,0,G2H2(375),n2h2(222))
call HGT_OLR(G1H4(208),1,1,4)
call HGT_invQ_OLR(G1H4(208),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(208),-16,0,G2H4(122),n2h4(254))
  call Hloop_AV_Q(ntryL,G2H4(122),ex5(:),G2H2(376),m3h2x2(:,434),heltab2x4(:,:,434))
  call Hloop_ZQ_A(ntryL,G1H4(177),ex3(:),G1H2(299),ngZl,m3h2x2(:,435),heltab2x4(:,:,435))
  call Hloop_Q_A(ntryL,G1H2(299),47,0,G2H2(377),n2h2(223))
  call Hloop_ZQ_A(ntryL,G1H4(178),ex3(:),G1H2(300),ngZl,m3h2x2(:,436),heltab2x4(:,:,436))
  call Hloop_Q_A(ntryL,G1H2(300),47,0,G2H2(378),n2h2(224))
  call Hloop_AV_Q(ntryL,G1H8(143),wf4(:,1),G1H2(305),m3h4x2(:,41),heltab2x8(:,:,363))
  call Hloop_A_Q(ntryL,G1H2(305),47,0,G2H2(379),n2h2(225))
call HGT_OLR(G1H8(77),1,1,8)
call HGT_invQ_OLR(G1H8(77),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(77),-16,0,G2H8(53),n2h8(229))
  call Hloop_QV_A(ntryL,G2H8(53),ex5(:),G2H4(72),m3h2x4(:,323),heltab2x8(:,:,364))
  call Hloop_AV_Q(ntryL,G1H8(80),wf4(:,1),G1H2(311),m3h4x2(:,42),heltab2x8(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(311),47,0,G2H2(380),n2h2(226))
  call Hloop_AV_Q(ntryL,G1H8(84),wf4(:,1),G1H2(312),m3h4x2(:,43),heltab2x8(:,:,366))
  call Hloop_A_Q(ntryL,G1H2(312),47,0,G2H2(381),n2h2(227))
  call Hloop_AV_Q(ntryL,G1H8(85),wf4(:,1),G1H2(5),m3h4x2(:,44),heltab2x8(:,:,367))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(382),n2h2(228))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(86),-16,0,G2H8(54),n2h8(230))
  call Hloop_QV_A(ntryL,G2H8(54),ex5(:),G2H4(2),m3h2x4(:,324),heltab2x8(:,:,368))
  call Hloop_AV_Q(ntryL,G1H8(91),wf4(:,1),G1H2(11),m3h4x2(:,45),heltab2x8(:,:,369))
  call Hloop_A_Q(ntryL,G1H2(11),47,0,G2H2(383),n2h2(229))
  call Hloop_AV_Q(ntryL,G1H8(92),wf4(:,1),G1H2(12),m3h4x2(:,46),heltab2x8(:,:,370))
  call Hloop_A_Q(ntryL,G1H2(12),47,0,G2H2(384),n2h2(230))
  call Hloop_AZ_Q(ntryL,G1H8(95),wf4(:,6),G1H2(17),ngZl,m3h4x2(:,47),heltab2x8(:,:,371))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(385),n2h2(231))
call HGT_OLR(G1H8(96),1,1,8)
call HGT_invQ_OLR(G1H8(96),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(96),-16,0,G2H8(1),n2h8(231))
  call Hloop_QV_A(ntryL,G2H8(1),ex5(:),G2H4(76),m3h2x4(:,325),heltab2x8(:,:,372))
  call Hloop_AZ_Q(ntryL,G1H8(101),wf4(:,6),G1H2(23),ngZl,m3h4x2(:,48),heltab2x8(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(23),47,0,G2H2(386),n2h2(232))
  call Hloop_AZ_Q(ntryL,G1H8(103),wf4(:,6),G1H2(24),ngZl,m3h4x2(:,49),heltab2x8(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(24),47,0,G2H2(387),n2h2(233))
  call Hloop_AZ_Q(ntryL,G1H8(104),wf4(:,6),G1H2(29),ngZl,m3h4x2(:,50),heltab2x8(:,:,375))
  call Hloop_A_Q(ntryL,G1H2(29),47,0,G2H2(388),n2h2(234))
call HGT_OLR(G1H8(107),1,1,8)
call HGT_invQ_OLR(G1H8(107),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(107),-16,0,G2H8(2),n2h8(232))
  call Hloop_QV_A(ntryL,G2H8(2),ex5(:),G2H4(9),m3h2x4(:,326),heltab2x8(:,:,376))
  call Hloop_AZ_Q(ntryL,G1H8(110),wf4(:,6),G1H2(35),ngZl,m3h4x2(:,51),heltab2x8(:,:,377))
  call Hloop_A_Q(ntryL,G1H2(35),47,0,G2H2(389),n2h2(235))
  call Hloop_AZ_Q(ntryL,G1H8(113),wf4(:,6),G1H2(36),ngZl,m3h4x2(:,52),heltab2x8(:,:,378))
  call Hloop_A_Q(ntryL,G1H2(36),47,0,G2H2(390),n2h2(236))
  call Hloop_UW_V(ntryL,G1H8(114),44,wf4(:,1),3,G2H2(391),m3h4x2(:,53),heltab2x8(:,:,379))
call HGT_raise_alpha_OLR(G1H8(115),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(115),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(115),-16,ex5(:),16,G2H4(80),m3h2x4(:,327),heltab2x8(:,:,380))
  call Hloop_UW_V(ntryL,G1H8(120),44,wf4(:,1),3,G2H2(392),m3h4x2(:,54),heltab2x8(:,:,381))
  call Hloop_UW_V(ntryL,G1H8(122),44,wf4(:,1),3,G2H2(393),m3h4x2(:,55),heltab2x8(:,:,382))
  call Hloop_UW_V(ntryL,G1H8(125),44,wf4(:,6),3,G2H2(394),m3h4x2(:,56),heltab2x8(:,:,383))
call HGT_raise_alpha_OLR(G1H8(126),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(126),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(126),-16,ex5(:),16,G2H4(10),m3h2x4(:,328),heltab2x8(:,:,384))
  call Hloop_UW_V(ntryL,G1H8(8),44,wf4(:,6),3,G2H2(395),m3h4x2(:,57),heltab2x8(:,:,385))
  call Hloop_UW_V(ntryL,G1H8(9),44,wf4(:,6),3,G2H2(396),m3h4x2(:,58),heltab2x8(:,:,386))
  call Hloop_VA_Q(ntryL,G1H4(96),ex4(:),G1H2(41),m3h2x2(:,437),heltab2x4(:,:,437))
  call Hloop_A_Q(ntryL,G1H2(41),47,0,G2H2(397),n2h2(237))
call HGT_OLR(G1H4(182),1,1,4)
call HGT_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(182),-16,0,G2H4(84),n2h4(255))
  call Hloop_QV_A(ntryL,G2H4(84),ex5(:),G2H2(398),m3h2x2(:,438),heltab2x4(:,:,438))
  call Hloop_VA_Q(ntryL,G1H4(151),ex4(:),G1H2(47),m3h2x2(:,439),heltab2x4(:,:,439))
  call Hloop_A_Q(ntryL,G1H2(47),47,0,G2H2(399),n2h2(238))
  call Hloop_VA_Q(ntryL,G1H4(146),ex4(:),G1H2(48),m3h2x2(:,440),heltab2x4(:,:,440))
  call Hloop_A_Q(ntryL,G1H2(48),47,0,G2H2(400),n2h2(239))
  call Hloop_ZA_Q(ntryL,G1H4(157),ex4(:),G1H2(53),ngZl,m3h2x2(:,441),heltab2x4(:,:,441))
  call Hloop_A_Q(ntryL,G1H2(53),47,0,G2H2(401),n2h2(240))
call HGT_OLR(G1H4(147),1,1,4)
call HGT_invQ_OLR(G1H4(147),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(147),-16,0,G2H4(11),n2h4(256))
  call Hloop_QV_A(ntryL,G2H4(11),ex5(:),G2H2(402),m3h2x2(:,442),heltab2x4(:,:,442))
  call Hloop_ZA_Q(ntryL,G1H4(148),ex4(:),G1H2(59),ngZl,m3h2x2(:,443),heltab2x4(:,:,443))
  call Hloop_A_Q(ntryL,G1H2(59),47,0,G2H2(403),n2h2(241))
  call Hloop_ZA_Q(ntryL,G1H4(169),ex4(:),G1H2(60),ngZl,m3h2x2(:,444),heltab2x4(:,:,444))
  call Hloop_A_Q(ntryL,G1H2(60),47,0,G2H2(404),n2h2(242))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,1),G1H2(65),m3h4x2(:,59),heltab2x8(:,:,387))
  call Hloop_Q_A(ntryL,G1H2(65),47,0,G2H2(405),n2h2(243))
call HGT_OLR(G1H8(10),1,1,8)
call HGT_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(10),-16,0,G2H8(3),n2h8(235))
  call Hloop_AV_Q(ntryL,G2H8(3),ex5(:),G2H4(88),m3h2x4(:,329),heltab2x8(:,:,388))
  call Hloop_QV_A(ntryL,G1H8(20),wf4(:,1),G1H2(71),m3h4x2(:,60),heltab2x8(:,:,389))
  call Hloop_Q_A(ntryL,G1H2(71),47,0,G2H2(406),n2h2(244))
  call Hloop_QV_A(ntryL,G1H8(21),wf4(:,1),G1H2(72),m3h4x2(:,61),heltab2x8(:,:,390))
  call Hloop_Q_A(ntryL,G1H2(72),47,0,G2H2(407),n2h2(245))
  call Hloop_QV_A(ntryL,G1H8(53),wf4(:,1),G1H2(77),m3h4x2(:,62),heltab2x8(:,:,391))
  call Hloop_Q_A(ntryL,G1H2(77),47,0,G2H2(408),n2h2(246))
call HGT_OLR(G1H8(54),1,1,8)
call HGT_invQ_OLR(G1H8(54),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(54),-16,0,G2H8(4),n2h8(236))
  call Hloop_AV_Q(ntryL,G2H8(4),ex5(:),G2H4(12),m3h2x4(:,330),heltab2x8(:,:,392))
  call Hloop_QV_A(ntryL,G1H8(66),wf4(:,1),G1H2(83),m3h4x2(:,63),heltab2x8(:,:,393))
  call Hloop_Q_A(ntryL,G1H2(83),47,0,G2H2(409),n2h2(247))
  call Hloop_QV_A(ntryL,G1H8(67),wf4(:,1),G1H2(84),m3h4x2(:,64),heltab2x8(:,:,394))
  call Hloop_Q_A(ntryL,G1H2(84),47,0,G2H2(410),n2h2(248))
  call Hloop_QZ_A(ntryL,G1H8(68),wf4(:,6),G1H2(89),ngZl,m3h4x2(:,65),heltab2x8(:,:,395))
  call Hloop_Q_A(ntryL,G1H2(89),47,0,G2H2(411),n2h2(249))
call HGT_OLR(G1H8(133),1,1,8)
call HGT_invQ_OLR(G1H8(133),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(133),-16,0,G2H8(5),n2h8(237))
  call Hloop_AV_Q(ntryL,G2H8(5),ex5(:),G2H4(92),m3h2x4(:,331),heltab2x8(:,:,396))
  call Hloop_QZ_A(ntryL,G1H8(136),wf4(:,6),G1H2(95),ngZl,m3h4x2(:,66),heltab2x8(:,:,397))
  call Hloop_Q_A(ntryL,G1H2(95),47,0,G2H2(412),n2h2(250))
  call Hloop_QZ_A(ntryL,G1H8(137),wf4(:,6),G1H2(96),ngZl,m3h4x2(:,67),heltab2x8(:,:,398))
  call Hloop_Q_A(ntryL,G1H2(96),47,0,G2H2(413),n2h2(251))
  call Hloop_QZ_A(ntryL,G1H8(138),wf4(:,6),G1H2(101),ngZl,m3h4x2(:,68),heltab2x8(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(101),47,0,G2H2(414),n2h2(252))
call HGT_OLR(G1H8(139),1,1,8)
call HGT_invQ_OLR(G1H8(139),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(139),-16,0,G2H8(6),n2h8(238))
  call Hloop_AV_Q(ntryL,G2H8(6),ex5(:),G2H4(4),m3h2x4(:,332),heltab2x8(:,:,400))
  call Hloop_QZ_A(ntryL,G1H8(142),wf4(:,6),G1H2(107),ngZl,m3h4x2(:,69),heltab2x8(:,:,401))
  call Hloop_Q_A(ntryL,G1H2(107),47,0,G2H2(415),n2h2(253))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,6),G1H2(108),ngZl,m3h4x2(:,70),heltab2x8(:,:,402))
  call Hloop_Q_A(ntryL,G1H2(108),47,0,G2H2(416),n2h2(254))
  call Hloop_UV_W(ntryL,G1H8(7),44,wf4(:,1),3,G2H2(417),m3h4x2(:,71),heltab2x8(:,:,403))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(12),-16,ex5(:),16,G2H4(96),m3h2x4(:,333),heltab2x8(:,:,404))
  call Hloop_UV_W(ntryL,G1H8(22),44,wf4(:,1),3,G2H2(418),m3h4x2(:,72),heltab2x8(:,:,405))
  call Hloop_UV_W(ntryL,G1H8(23),44,wf4(:,1),3,G2H2(419),m3h4x2(:,73),heltab2x8(:,:,406))
  call Hloop_UV_W(ntryL,G1H8(28),44,wf4(:,6),3,G2H2(420),m3h4x2(:,74),heltab2x8(:,:,407))
call HGT_raise_alpha_OLR(G1H8(33),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(33),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(33),-16,ex5(:),16,G2H4(5),m3h2x4(:,334),heltab2x8(:,:,408))
  call Hloop_UV_W(ntryL,G1H8(40),44,wf4(:,6),3,G2H2(421),m3h4x2(:,75),heltab2x8(:,:,409))
  call Hloop_UV_W(ntryL,G1H8(46),44,wf4(:,6),3,G2H2(422),m3h4x2(:,76),heltab2x8(:,:,410))
  call Hloop_QV_A(ntryL,G1H8(51),ex5(:),G1H4(209),m3h2x4(:,335),heltab2x8(:,:,411))
  call Hloop_Q_A(ntryL,G1H4(209),51,0,G2H4(100),n2h4(257))
call HGT_OLR(G1H8(57),1,1,8)
call HGT_invQ_OLR(G1H8(57),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(57),-12,0,G2H8(7),n2h8(241))
  call Hloop_AV_Q(ntryL,G2H8(7),wf4(:,13),G2H2(423),m3h4x2(:,77),heltab2x8(:,:,412))
  call Hloop_QV_A(ntryL,G1H8(88),ex5(:),G1H4(58),m3h2x4(:,336),heltab2x8(:,:,413))
  call Hloop_Q_A(ntryL,G1H4(58),51,0,G2H4(6),n2h4(258))
  call Hloop_QV_A(ntryL,G1H8(93),ex5(:),G1H4(42),m3h2x4(:,337),heltab2x8(:,:,414))
  call Hloop_Q_A(ntryL,G1H4(42),51,0,G2H4(104),n2h4(259))
  call Hloop_QV_A(ntryL,G1H8(99),ex5(:),G1H4(79),m3h2x4(:,338),heltab2x8(:,:,415))
  call Hloop_Q_A(ntryL,G1H4(79),51,0,G2H4(7),n2h4(260))
call HGT_OLR(G1H8(100),1,1,8)
call HGT_invQ_OLR(G1H8(100),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(100),-12,0,G2H8(8),n2h8(242))
  call Hloop_AV_Q(ntryL,G2H8(8),wf4(:,13),G2H2(424),m3h4x2(:,78),heltab2x8(:,:,416))
  call Hloop_QV_A(ntryL,G1H8(3),ex5(:),G1H4(135),m3h2x4(:,339),heltab2x8(:,:,417))
  call Hloop_Q_A(ntryL,G1H4(135),51,0,G2H4(108),n2h4(261))
  call Hloop_QV_A(ntryL,G1H8(14),ex5(:),G1H4(136),m3h2x4(:,340),heltab2x8(:,:,418))
  call Hloop_Q_A(ntryL,G1H4(136),51,0,G2H4(13),n2h4(262))
  call Hloop_QV_A(ntryL,G1H8(13),ex5(:),G1H4(152),m3h2x4(:,341),heltab2x8(:,:,419))
  call Hloop_Q_A(ntryL,G1H4(152),51,0,G2H4(112),n2h4(263))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(4),-12,0,G2H8(9),n2h8(243))
  call Hloop_AZ_Q(ntryL,G2H8(9),wf4(:,16),G2H2(425),ngZl,m3h4x2(:,79),heltab2x8(:,:,420))
  call Hloop_QV_A(ntryL,G1H8(36),ex5(:),G1H4(153),m3h2x4(:,342),heltab2x8(:,:,421))
  call Hloop_Q_A(ntryL,G1H4(153),51,0,G2H4(14),n2h4(264))
  call Hloop_QV_A(ntryL,G1H8(35),ex5(:),G1H4(154),m3h2x4(:,343),heltab2x8(:,:,422))
  call Hloop_Q_A(ntryL,G1H4(154),51,0,G2H4(116),n2h4(265))
  call Hloop_QV_A(ntryL,G1H8(49),ex5(:),G1H4(158),m3h2x4(:,344),heltab2x8(:,:,423))
  call Hloop_Q_A(ntryL,G1H4(158),51,0,G2H4(15),n2h4(266))
call HGT_OLR(G1H8(47),1,1,8)
call HGT_invQ_OLR(G1H8(47),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(47),-12,0,G2H8(10),n2h8(244))
  call Hloop_AZ_Q(ntryL,G2H8(10),wf4(:,16),G2H2(426),ngZl,m3h4x2(:,80),heltab2x8(:,:,424))
  call Hloop_QV_A(ntryL,G1H8(59),ex5(:),G1H4(171),m3h2x4(:,345),heltab2x8(:,:,425))
  call Hloop_Q_A(ntryL,G1H4(171),51,0,G2H4(120),n2h4(267))
  call Hloop_QV_A(ntryL,G1H8(73),ex5(:),G1H4(172),m3h2x4(:,346),heltab2x8(:,:,426))
  call Hloop_Q_A(ntryL,G1H4(172),51,0,G2H4(16),n2h4(268))
  call Hloop_UV_W(ntryL,G1H8(71),35,ex5(:),16,G2H4(36),m3h2x4(:,347),heltab2x8(:,:,427))
call HGT_raise_alpha_OLR(G1H8(131),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(131),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(131),-12,wf4(:,13),12,G2H2(427),m3h4x2(:,81),heltab2x8(:,:,428))
  call Hloop_UV_W(ntryL,G1H8(128),35,ex5(:),16,G2H4(146),m3h2x4(:,348),heltab2x8(:,:,429))
  call Hloop_UV_W(ntryL,G1H8(102),35,ex5(:),16,G2H4(148),m3h2x4(:,349),heltab2x8(:,:,430))
  call Hloop_UV_W(ntryL,G1H8(41),35,ex5(:),16,G2H4(40),m3h2x4(:,350),heltab2x8(:,:,431))
call HGT_raise_alpha_OLR(G1H8(52),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(52),-12,wf4(:,16),12,G2H2(428),m3h4x2(:,82),heltab2x8(:,:,432))
  call Hloop_UV_W(ntryL,G1H8(44),35,ex5(:),16,G2H4(155),m3h2x4(:,351),heltab2x8(:,:,433))
  call Hloop_UV_W(ntryL,G1H8(63),35,ex5(:),16,G2H4(157),m3h2x4(:,352),heltab2x8(:,:,434))
  call Hloop_VQ_A(ntryL,G1H4(175),ex1(:),G1H2(113),m3h2x2(:,445),heltab2x4(:,:,445))
  call Hloop_Q_A(ntryL,G1H2(113),47,0,G2H2(429),n2h2(255))
call HGT_OLR(G1H4(130),1,1,4)
call HGT_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(130),-16,0,G2H4(33),n2h4(269))
  call Hloop_AV_Q(ntryL,G2H4(33),ex5(:),G2H2(430),m3h2x2(:,446),heltab2x4(:,:,446))
  call Hloop_VQ_A(ntryL,G1H4(129),ex1(:),G1H2(119),m3h2x2(:,447),heltab2x4(:,:,447))
  call Hloop_Q_A(ntryL,G1H2(119),47,0,G2H2(431),n2h2(256))
  call Hloop_VQ_A(ntryL,G1H4(187),ex1(:),G1H2(120),m3h2x2(:,448),heltab2x4(:,:,448))
  call Hloop_Q_A(ntryL,G1H2(120),47,0,G2H2(432),n2h2(257))
  call Hloop_ZQ_A(ntryL,G1H4(134),ex1(:),G1H2(125),ngZl,m3h2x2(:,449),heltab2x4(:,:,449))
  call Hloop_Q_A(ntryL,G1H2(125),47,0,G2H2(433),n2h2(258))
call HGT_OLR(G1H4(193),1,1,4)
call HGT_invQ_OLR(G1H4(193),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(193),-16,0,G2H4(34),n2h4(270))
  call Hloop_AV_Q(ntryL,G2H4(34),ex5(:),G2H2(434),m3h2x2(:,450),heltab2x4(:,:,450))
  call Hloop_ZQ_A(ntryL,G1H4(160),ex1(:),G1H2(131),ngZl,m3h2x2(:,451),heltab2x4(:,:,451))
  call Hloop_Q_A(ntryL,G1H2(131),47,0,G2H2(435),n2h2(259))
  call Hloop_ZQ_A(ntryL,G1H4(164),ex1(:),G1H2(132),ngZl,m3h2x2(:,452),heltab2x4(:,:,452))
  call Hloop_Q_A(ntryL,G1H2(132),47,0,G2H2(436),n2h2(260))
  call Hloop_AV_Q(ntryL,G1H8(76),ex5(:),G1H4(214),m3h2x4(:,353),heltab2x8(:,:,435))
  call Hloop_A_Q(ntryL,G1H4(214),51,0,G2H4(35),n2h4(271))
call HGT_OLR(G1H8(29),1,1,8)
call HGT_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(29),-12,0,G2H8(11),n2h8(247))
  call Hloop_QV_A(ntryL,G2H8(11),wf4(:,13),G2H2(437),m3h4x2(:,83),heltab2x8(:,:,436))
  call Hloop_AV_Q(ntryL,G1H8(31),ex5(:),G1H4(218),m3h2x4(:,354),heltab2x8(:,:,437))
  call Hloop_A_Q(ntryL,G1H4(218),51,0,G2H4(37),n2h4(272))
  call Hloop_AV_Q(ntryL,G1H8(117),ex5(:),G1H4(3),m3h2x4(:,355),heltab2x8(:,:,438))
  call Hloop_A_Q(ntryL,G1H4(3),51,0,G2H4(41),n2h4(273))
  call Hloop_AV_Q(ntryL,G1H8(130),ex5(:),G1H4(4),m3h2x4(:,356),heltab2x8(:,:,439))
  call Hloop_A_Q(ntryL,G1H4(4),51,0,G2H4(44),n2h4(274))
call HGT_OLR(G1H8(123),1,1,8)
call HGT_invQ_OLR(G1H8(123),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(123),-12,0,G2H8(12),n2h8(248))
  call Hloop_QV_A(ntryL,G2H8(12),wf4(:,13),G2H2(438),m3h4x2(:,84),heltab2x8(:,:,440))
  call Hloop_AV_Q(ntryL,G1H8(69),ex5(:),G1H4(8),m3h2x4(:,357),heltab2x8(:,:,441))
  call Hloop_A_Q(ntryL,G1H4(8),51,0,G2H4(45),n2h4(275))
  call Hloop_AV_Q(ntryL,G1H8(82),ex5(:),G1H4(9),m3h2x4(:,358),heltab2x8(:,:,442))
  call Hloop_A_Q(ntryL,G1H4(9),51,0,G2H4(48),n2h4(276))
  call Hloop_AV_Q(ntryL,G1H8(75),ex5(:),G1H4(15),m3h2x4(:,359),heltab2x8(:,:,443))
  call Hloop_A_Q(ntryL,G1H4(15),51,0,G2H4(49),n2h4(277))
call HGT_OLR(G1H8(144),1,1,8)
call HGT_invQ_OLR(G1H8(144),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(144),-12,0,G2H8(13),n2h8(249))
  call Hloop_QZ_A(ntryL,G2H8(13),wf4(:,16),G2H2(439),ngZl,m3h4x2(:,85),heltab2x8(:,:,444))
  call Hloop_AV_Q(ntryL,G1H8(147),ex5(:),G1H4(16),m3h2x4(:,360),heltab2x8(:,:,445))
  call Hloop_A_Q(ntryL,G1H4(16),51,0,G2H4(51),n2h4(278))
  call Hloop_AV_Q(ntryL,G1H8(148),ex5(:),G1H4(20),m3h2x4(:,361),heltab2x8(:,:,446))
  call Hloop_A_Q(ntryL,G1H4(20),51,0,G2H4(52),n2h4(279))
  call Hloop_AV_Q(ntryL,G1H8(149),ex5(:),G1H4(21),m3h2x4(:,362),heltab2x8(:,:,447))
  call Hloop_A_Q(ntryL,G1H4(21),51,0,G2H4(55),n2h4(280))
call HGT_OLR(G1H8(150),1,1,8)
call HGT_invQ_OLR(G1H8(150),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(150),-12,0,G2H8(14),n2h8(250))
  call Hloop_QZ_A(ntryL,G2H8(14),wf4(:,16),G2H2(440),ngZl,m3h4x2(:,86),heltab2x8(:,:,448))
  call Hloop_AV_Q(ntryL,G1H8(153),ex5(:),G1H4(27),m3h2x4(:,363),heltab2x8(:,:,449))
  call Hloop_A_Q(ntryL,G1H4(27),51,0,G2H4(56),n2h4(281))
  call Hloop_AV_Q(ntryL,G1H8(154),ex5(:),G1H4(28),m3h2x4(:,364),heltab2x8(:,:,450))
  call Hloop_A_Q(ntryL,G1H4(28),51,0,G2H4(58),n2h4(282))
  call Hloop_UW_V(ntryL,G1H8(111),35,ex5(:),16,G2H4(59),m3h2x4(:,365),heltab2x8(:,:,451))
call HGT_raise_alpha_OLR(G1H8(124),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(124),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(124),-12,wf4(:,13),12,G2H2(441),m3h4x2(:,87),heltab2x8(:,:,452))
  call Hloop_UW_V(ntryL,G1H8(155),35,ex5(:),16,G2H4(62),m3h2x4(:,366),heltab2x8(:,:,453))
  call Hloop_UW_V(ntryL,G1H8(156),35,ex5(:),16,G2H4(63),m3h2x4(:,367),heltab2x8(:,:,454))
  call Hloop_UW_V(ntryL,G1H8(157),35,ex5(:),16,G2H4(66),m3h2x4(:,368),heltab2x8(:,:,455))
call HGT_raise_alpha_OLR(G1H8(158),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(158),-12,wf4(:,16),12,G2H2(442),m3h4x2(:,88),heltab2x8(:,:,456))
  call Hloop_UW_V(ntryL,G1H8(161),35,ex5(:),16,G2H4(67),m3h2x4(:,369),heltab2x8(:,:,457))
  call Hloop_UW_V(ntryL,G1H8(162),35,ex5(:),16,G2H4(70),m3h2x4(:,370),heltab2x8(:,:,458))
  call Hloop_AV_Q(ntryL,G1H8(163),wf4(:,13),G1H2(137),m3h4x2(:,89),heltab2x8(:,:,459))
  call Hloop_A_Q(ntryL,G1H2(137),47,0,G2H2(443),n2h2(261))
call HGT_OLR(G1H8(164),1,1,8)
call HGT_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(164),-16,0,G2H8(15),n2h8(253))
  call Hloop_QV_A(ntryL,G2H8(15),ex5(:),G2H4(71),m3h2x4(:,371),heltab2x8(:,:,460))
  call Hloop_AV_Q(ntryL,G1H8(167),wf4(:,13),G1H2(143),m3h4x2(:,90),heltab2x8(:,:,461))
  call Hloop_A_Q(ntryL,G1H2(143),47,0,G2H2(444),n2h2(262))
  call Hloop_AV_Q(ntryL,G1H8(168),wf4(:,13),G1H2(144),m3h4x2(:,91),heltab2x8(:,:,462))
  call Hloop_A_Q(ntryL,G1H2(144),47,0,G2H2(445),n2h2(263))
  call Hloop_AV_Q(ntryL,G1H8(169),wf4(:,13),G1H2(149),m3h4x2(:,92),heltab2x8(:,:,463))
  call Hloop_A_Q(ntryL,G1H2(149),47,0,G2H2(446),n2h2(264))
call HGT_OLR(G1H8(170),1,1,8)
call HGT_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(170),-16,0,G2H8(16),n2h8(254))
  call Hloop_QV_A(ntryL,G2H8(16),ex5(:),G2H4(74),m3h2x4(:,372),heltab2x8(:,:,464))
  call Hloop_AV_Q(ntryL,G1H8(173),wf4(:,13),G1H2(155),m3h4x2(:,93),heltab2x8(:,:,465))
  call Hloop_A_Q(ntryL,G1H2(155),47,0,G2H2(447),n2h2(265))
  call Hloop_AV_Q(ntryL,G1H8(174),wf4(:,13),G1H2(156),m3h4x2(:,94),heltab2x8(:,:,466))
  call Hloop_A_Q(ntryL,G1H2(156),47,0,G2H2(448),n2h2(266))
  call Hloop_AZ_Q(ntryL,G1H8(175),wf4(:,16),G1H2(161),ngZl,m3h4x2(:,95),heltab2x8(:,:,467))
  call Hloop_A_Q(ntryL,G1H2(161),47,0,G2H2(449),n2h2(267))
call HGT_OLR(G1H8(176),1,1,8)
call HGT_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(176),-16,0,G2H8(51),n2h8(255))
  call Hloop_QV_A(ntryL,G2H8(51),ex5(:),G2H4(75),m3h2x4(:,373),heltab2x8(:,:,468))
  call Hloop_AZ_Q(ntryL,G1H8(179),wf4(:,16),G1H2(167),ngZl,m3h4x2(:,96),heltab2x8(:,:,469))
  call Hloop_A_Q(ntryL,G1H2(167),47,0,G2H2(450),n2h2(268))
  call Hloop_AZ_Q(ntryL,G1H8(180),wf4(:,16),G1H2(168),ngZl,m3h4x2(:,97),heltab2x8(:,:,470))
  call Hloop_A_Q(ntryL,G1H2(168),47,0,G2H2(451),n2h2(269))
  call Hloop_AZ_Q(ntryL,G1H8(181),wf4(:,16),G1H2(173),ngZl,m3h4x2(:,98),heltab2x8(:,:,471))
  call Hloop_A_Q(ntryL,G1H2(173),47,0,G2H2(452),n2h2(270))
call HGT_OLR(G1H8(182),1,1,8)
call HGT_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(182),-16,0,G2H8(27),n2h8(256))
  call Hloop_QV_A(ntryL,G2H8(27),ex5(:),G2H4(78),m3h2x4(:,374),heltab2x8(:,:,472))
  call Hloop_AZ_Q(ntryL,G1H8(185),wf4(:,16),G1H2(179),ngZl,m3h4x2(:,99),heltab2x8(:,:,473))
  call Hloop_A_Q(ntryL,G1H2(179),47,0,G2H2(453),n2h2(271))
  call Hloop_AZ_Q(ntryL,G1H8(186),wf4(:,16),G1H2(180),ngZl,m3h4x2(:,100),heltab2x8(:,:,474))
  call Hloop_A_Q(ntryL,G1H2(180),47,0,G2H2(454),n2h2(272))
  call Hloop_UW_V(ntryL,G1H8(50),35,wf4(:,13),12,G2H2(455),m3h4x2(:,101),heltab2x8(:,:,475))
call HGT_raise_alpha_OLR(G1H8(106),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(106),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(106),-16,ex5(:),16,G2H4(79),m3h2x4(:,375),heltab2x8(:,:,476))
  call Hloop_UW_V(ntryL,G1H8(187),35,wf4(:,13),12,G2H2(456),m3h4x2(:,102),heltab2x8(:,:,477))
  call Hloop_UW_V(ntryL,G1H8(188),35,wf4(:,13),12,G2H2(457),m3h4x2(:,103),heltab2x8(:,:,478))
  call Hloop_UW_V(ntryL,G1H8(189),35,wf4(:,16),12,G2H2(458),m3h4x2(:,104),heltab2x8(:,:,479))
call HGT_raise_alpha_OLR(G1H8(190),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(190),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(190),-16,ex5(:),16,G2H4(82),m3h2x4(:,376),heltab2x8(:,:,480))
  call Hloop_UW_V(ntryL,G1H8(193),35,wf4(:,16),12,G2H2(459),m3h4x2(:,105),heltab2x8(:,:,481))
  call Hloop_UW_V(ntryL,G1H8(194),35,wf4(:,16),12,G2H2(460),m3h4x2(:,106),heltab2x8(:,:,482))
  call Hloop_VA_Q(ntryL,G1H4(111),ex2(:),G1H2(185),m3h2x2(:,453),heltab2x4(:,:,453))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(461),n2h2(273))
call HGT_OLR(G1H4(186),1,1,4)
call HGT_invQ_OLR(G1H4(186),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(186),-16,0,G2H4(83),n2h4(283))
  call Hloop_QV_A(ntryL,G2H4(83),ex5(:),G2H2(462),m3h2x2(:,454),heltab2x4(:,:,454))
  call Hloop_VA_Q(ntryL,G1H4(112),ex2(:),G1H2(191),m3h2x2(:,455),heltab2x4(:,:,455))
  call Hloop_A_Q(ntryL,G1H2(191),47,0,G2H2(463),n2h2(274))
  call Hloop_VA_Q(ntryL,G1H4(117),ex2(:),G1H2(192),m3h2x2(:,456),heltab2x4(:,:,456))
  call Hloop_A_Q(ntryL,G1H2(192),47,0,G2H2(464),n2h2(275))
  call Hloop_ZA_Q(ntryL,G1H4(203),ex2(:),G1H2(197),ngZl,m3h2x2(:,457),heltab2x4(:,:,457))
  call Hloop_A_Q(ntryL,G1H2(197),47,0,G2H2(465),n2h2(276))
call HGT_OLR(G1H4(205),1,1,4)
call HGT_invQ_OLR(G1H4(205),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(205),-16,0,G2H4(86),n2h4(284))
  call Hloop_QV_A(ntryL,G2H4(86),ex5(:),G2H2(466),m3h2x2(:,458),heltab2x4(:,:,458))
  call Hloop_ZA_Q(ntryL,G1H4(219),ex2(:),G1H2(203),ngZl,m3h2x2(:,459),heltab2x4(:,:,459))
  call Hloop_A_Q(ntryL,G1H2(203),47,0,G2H2(467),n2h2(277))
  call Hloop_ZA_Q(ntryL,G1H4(220),ex2(:),G1H2(204),ngZl,m3h2x2(:,460),heltab2x4(:,:,460))
  call Hloop_A_Q(ntryL,G1H2(204),47,0,G2H2(468),n2h2(278))
  call Hloop_QV_A(ntryL,G1H8(195),wf4(:,13),G1H2(239),m3h4x2(:,107),heltab2x8(:,:,483))
  call Hloop_Q_A(ntryL,G1H2(239),47,0,G2H2(469),n2h2(279))
call HGT_OLR(G1H8(196),1,1,8)
call HGT_invQ_OLR(G1H8(196),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(196),-16,0,G2H8(45),n2h8(259))
  call Hloop_AV_Q(ntryL,G2H8(45),ex5(:),G2H4(87),m3h2x4(:,377),heltab2x8(:,:,484))
  call Hloop_QV_A(ntryL,G1H8(199),wf4(:,13),G1H2(240),m3h4x2(:,108),heltab2x8(:,:,485))
  call Hloop_Q_A(ntryL,G1H2(240),47,0,G2H2(470),n2h2(280))
  call Hloop_QV_A(ntryL,G1H8(200),wf4(:,13),G1H2(251),m3h4x2(:,109),heltab2x8(:,:,486))
  call Hloop_Q_A(ntryL,G1H2(251),47,0,G2H2(471),n2h2(281))
  call Hloop_QV_A(ntryL,G1H8(201),wf4(:,13),G1H2(252),m3h4x2(:,110),heltab2x8(:,:,487))
  call Hloop_Q_A(ntryL,G1H2(252),47,0,G2H2(472),n2h2(282))
call HGT_OLR(G1H8(202),1,1,8)
call HGT_invQ_OLR(G1H8(202),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(202),-16,0,G2H8(33),n2h8(260))
  call Hloop_AV_Q(ntryL,G2H8(33),ex5(:),G2H4(90),m3h2x4(:,378),heltab2x8(:,:,488))
  call Hloop_QV_A(ntryL,G1H8(205),wf4(:,13),G1H2(257),m3h4x2(:,111),heltab2x8(:,:,489))
  call Hloop_Q_A(ntryL,G1H2(257),47,0,G2H2(473),n2h2(283))
  call Hloop_QV_A(ntryL,G1H8(206),wf4(:,13),G1H2(264),m3h4x2(:,112),heltab2x8(:,:,490))
  call Hloop_Q_A(ntryL,G1H2(264),47,0,G2H2(474),n2h2(284))
  call Hloop_QZ_A(ntryL,G1H8(207),wf4(:,16),G1H2(269),ngZl,m3h4x2(:,113),heltab2x8(:,:,491))
  call Hloop_Q_A(ntryL,G1H2(269),47,0,G2H2(475),n2h2(285))
call HGT_OLR(G1H8(208),1,1,8)
call HGT_invQ_OLR(G1H8(208),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(208),-16,0,G2H8(39),n2h8(261))
  call Hloop_AV_Q(ntryL,G2H8(39),ex5(:),G2H4(91),m3h2x4(:,379),heltab2x8(:,:,492))
  call Hloop_QZ_A(ntryL,G1H8(211),wf4(:,16),G1H2(276),ngZl,m3h4x2(:,114),heltab2x8(:,:,493))
  call Hloop_Q_A(ntryL,G1H2(276),47,0,G2H2(476),n2h2(286))
  call Hloop_QZ_A(ntryL,G1H8(212),wf4(:,16),G1H2(281),ngZl,m3h4x2(:,115),heltab2x8(:,:,494))
  call Hloop_Q_A(ntryL,G1H2(281),47,0,G2H2(477),n2h2(287))
  call Hloop_QZ_A(ntryL,G1H8(213),wf4(:,16),G1H2(287),ngZl,m3h4x2(:,116),heltab2x8(:,:,495))
  call Hloop_Q_A(ntryL,G1H2(287),47,0,G2H2(478),n2h2(288))
call HGT_OLR(G1H8(214),1,1,8)
call HGT_invQ_OLR(G1H8(214),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(214),-16,0,G2H8(21),n2h8(262))
  call Hloop_AV_Q(ntryL,G2H8(21),ex5(:),G2H4(94),m3h2x4(:,380),heltab2x8(:,:,496))
  call Hloop_QZ_A(ntryL,G1H8(217),wf4(:,16),G1H2(288),ngZl,m3h4x2(:,117),heltab2x8(:,:,497))
  call Hloop_Q_A(ntryL,G1H2(288),47,0,G2H2(479),n2h2(289))
  call Hloop_QZ_A(ntryL,G1H8(218),wf4(:,16),G1H2(293),ngZl,m3h4x2(:,118),heltab2x8(:,:,498))
  call Hloop_Q_A(ntryL,G1H2(293),47,0,G2H2(480),n2h2(290))
  call Hloop_UV_W(ntryL,G1H8(26),35,wf4(:,13),12,G2H2(481),m3h4x2(:,119),heltab2x8(:,:,499))
call HGT_raise_alpha_OLR(G1H8(62),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(62),-16,ex5(:),16,G2H4(95),m3h2x4(:,381),heltab2x8(:,:,500))
  call Hloop_UV_W(ntryL,G1H8(219),35,wf4(:,13),12,G2H2(482),m3h4x2(:,120),heltab2x8(:,:,501))
  call Hloop_UV_W(ntryL,G1H8(220),35,wf4(:,13),12,G2H2(483),m3h4x2(:,121),heltab2x8(:,:,502))
  call Hloop_UV_W(ntryL,G1H8(221),35,wf4(:,16),12,G2H2(484),m3h4x2(:,122),heltab2x8(:,:,503))
call HGT_raise_alpha_OLR(G1H8(222),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(222),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(222),-16,ex5(:),16,G2H4(98),m3h2x4(:,382),heltab2x8(:,:,504))
  call Hloop_UV_W(ntryL,G1H8(225),35,wf4(:,16),12,G2H2(485),m3h4x2(:,123),heltab2x8(:,:,505))
  call Hloop_UV_W(ntryL,G1H8(226),35,wf4(:,16),12,G2H2(486),m3h4x2(:,124),heltab2x8(:,:,506))
  call Hloop_WA_Q(ntryL,G1H8(227),ex2(:),G1H4(32),m3h2x4(:,383),heltab2x8(:,:,507))
  call Hloop_A_Q(ntryL,G1H4(32),46,0,G2H4(99),n2h4(285))
call HGT_raise_alpha_OLR(G1H8(228),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(228),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(228),wf4(:,14),G1H2(299),m3h4x2(:,125),heltab2x8(:,:,508))
  call Hloop_WA_Q(ntryL,G1H8(231),ex2(:),G1H4(33),m3h2x4(:,384),heltab2x8(:,:,509))
  call Hloop_A_Q(ntryL,G1H4(33),46,0,G2H4(102),n2h4(286))
  call Hloop_WA_Q(ntryL,G1H8(232),ex2(:),G1H4(40),m3h2x4(:,385),heltab2x8(:,:,510))
  call Hloop_A_Q(ntryL,G1H4(40),46,0,G2H4(103),n2h4(287))
  call Hloop_WQ_A(ntryL,G1H8(233),ex1(:),G1H4(44),m3h2x4(:,386),heltab2x8(:,:,511))
  call Hloop_Q_A(ntryL,G1H4(44),45,0,G2H4(106),n2h4(288))
call HGT_raise_alpha_OLR(G1H8(234),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(234),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(234),wf4(:,20),G1H2(300),m3h4x2(:,126),heltab2x8(:,:,512))
  call Hloop_WQ_A(ntryL,G1H8(237),ex1(:),G1H4(46),m3h2x4(:,387),heltab2x8(:,:,513))
  call Hloop_Q_A(ntryL,G1H4(46),45,0,G2H4(107),n2h4(289))
  call Hloop_WQ_A(ntryL,G1H8(238),ex1(:),G1H4(50),m3h2x4(:,388),heltab2x8(:,:,514))
  call Hloop_Q_A(ntryL,G1H4(50),45,0,G2H4(110),n2h4(290))
  call Hloop_WA_Q(ntryL,G1H8(239),ex4(:),G1H4(62),m3h2x4(:,389),heltab2x8(:,:,515))
  call Hloop_A_Q(ntryL,G1H4(62),43,0,G2H4(111),n2h4(291))
call HGT_raise_alpha_OLR(G1H8(240),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(240),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(240),wf4(:,4),G1H2(305),m3h4x2(:,127),heltab2x8(:,:,516))
  call Hloop_WA_Q(ntryL,G1H8(243),ex4(:),G1H4(64),m3h2x4(:,390),heltab2x8(:,:,517))
  call Hloop_A_Q(ntryL,G1H4(64),43,0,G2H4(114),n2h4(292))
  call Hloop_WA_Q(ntryL,G1H8(244),ex4(:),G1H4(68),m3h2x4(:,391),heltab2x8(:,:,518))
  call Hloop_A_Q(ntryL,G1H4(68),43,0,G2H4(115),n2h4(293))
  call Hloop_WQ_A(ntryL,G1H8(245),wf4(:,4),G1H2(311),m3h4x2(:,128),heltab2x8(:,:,519))
  call Hloop_Q_A(ntryL,G1H2(311),55,0,G2H2(487),n2h2(291))
call HGT_raise_alpha_OLR(G1H8(246),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(246),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(246),ex4(:),G1H4(69),m3h2x4(:,392),heltab2x8(:,:,520))
  call Hloop_WQ_A(ntryL,G1H8(249),wf4(:,4),G1H2(312),m3h4x2(:,129),heltab2x8(:,:,521))
  call Hloop_Q_A(ntryL,G1H2(312),55,0,G2H2(488),n2h2(292))
  call Hloop_WQ_A(ntryL,G1H8(250),wf4(:,4),G1H2(5),m3h4x2(:,130),heltab2x8(:,:,522))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(489),n2h2(293))
  call Hloop_WQ_A(ntryL,G1H8(251),ex3(:),G1H4(75),m3h2x4(:,393),heltab2x8(:,:,523))
  call Hloop_Q_A(ntryL,G1H4(75),39,0,G2H4(118),n2h4(294))
call HGT_raise_alpha_OLR(G1H8(252),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(252),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(252),wf4(:,10),G1H2(11),m3h4x2(:,131),heltab2x8(:,:,524))
  call Hloop_WQ_A(ntryL,G1H8(255),ex3(:),G1H4(76),m3h2x4(:,394),heltab2x8(:,:,525))
  call Hloop_Q_A(ntryL,G1H4(76),39,0,G2H4(17),n2h4(295))
  call Hloop_WQ_A(ntryL,G1H8(256),ex3(:),G1H4(80),m3h2x4(:,395),heltab2x8(:,:,526))
  call Hloop_Q_A(ntryL,G1H4(80),39,0,G2H4(18),n2h4(296))
  call Hloop_WA_Q(ntryL,G1H8(257),wf4(:,10),G1H2(12),m3h4x2(:,132),heltab2x8(:,:,527))
  call Hloop_A_Q(ntryL,G1H2(12),59,0,G2H2(490),n2h2(294))
call HGT_raise_alpha_OLR(G1H8(258),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(258),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(258),ex3(:),G1H4(81),m3h2x4(:,396),heltab2x8(:,:,528))
  call Hloop_WA_Q(ntryL,G1H8(261),wf4(:,10),G1H2(17),m3h4x2(:,133),heltab2x8(:,:,529))
  call Hloop_A_Q(ntryL,G1H2(17),59,0,G2H2(491),n2h2(295))
  call Hloop_WA_Q(ntryL,G1H8(262),wf4(:,10),G1H2(23),m3h4x2(:,134),heltab2x8(:,:,530))
  call Hloop_A_Q(ntryL,G1H2(23),59,0,G2H2(492),n2h2(296))
  call Hloop_QV_A(ntryL,G1H4(221),ex5(:),G1H2(24),m3h2x2(:,461),heltab2x4(:,:,461))
  call Hloop_Q_A(ntryL,G1H2(24),55,0,G2H2(493),n2h2(297))
call HGT_raise_alpha_OLR(G1H4(222),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(222),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(222),ex4(:),G1H2(29),m3h2x2(:,462),heltab2x4(:,:,462))
  call Hloop_QV_A(ntryL,G1H4(225),ex5(:),G1H2(35),m3h2x2(:,463),heltab2x4(:,:,463))
  call Hloop_Q_A(ntryL,G1H2(35),55,0,G2H2(494),n2h2(298))
  call Hloop_QV_A(ntryL,G1H4(226),ex5(:),G1H2(36),m3h2x2(:,464),heltab2x4(:,:,464))
  call Hloop_Q_A(ntryL,G1H2(36),55,0,G2H2(495),n2h2(299))
  call Hloop_QV_A(ntryL,G1H4(227),ex5(:),G1H2(41),m3h2x2(:,465),heltab2x4(:,:,465))
  call Hloop_Q_A(ntryL,G1H2(41),55,0,G2H2(496),n2h2(300))
call HGT_raise_alpha_OLR(G1H4(228),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(228),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(228),ex4(:),G1H2(47),ngZl,m3h2x2(:,466),heltab2x4(:,:,466))
  call Hloop_QV_A(ntryL,G1H4(231),ex5(:),G1H2(48),m3h2x2(:,467),heltab2x4(:,:,467))
  call Hloop_Q_A(ntryL,G1H2(48),55,0,G2H2(497),n2h2(301))
  call Hloop_QV_A(ntryL,G1H4(232),ex5(:),G1H2(53),m3h2x2(:,468),heltab2x4(:,:,468))
  call Hloop_Q_A(ntryL,G1H2(53),55,0,G2H2(498),n2h2(302))
  call Hloop_QV_A(ntryL,G1H4(233),ex5(:),G1H2(59),m3h2x2(:,469),heltab2x4(:,:,469))
  call Hloop_Q_A(ntryL,G1H2(59),55,0,G2H2(499),n2h2(303))
call HGT_raise_alpha_OLR(G1H4(234),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(234),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(234),ex4(:),G1H2(60),m3h2x2(:,470),heltab2x4(:,:,470))
  call Hloop_QV_A(ntryL,G1H4(237),ex5(:),G1H2(65),m3h2x2(:,471),heltab2x4(:,:,471))
  call Hloop_Q_A(ntryL,G1H2(65),55,0,G2H2(500),n2h2(304))
  call Hloop_QV_A(ntryL,G1H4(238),ex5(:),G1H2(71),m3h2x2(:,472),heltab2x4(:,:,472))
  call Hloop_Q_A(ntryL,G1H2(71),55,0,G2H2(501),n2h2(305))
  call Hloop_QV_A(ntryL,G1H4(239),ex5(:),G1H2(72),m3h2x2(:,473),heltab2x4(:,:,473))
  call Hloop_Q_A(ntryL,G1H2(72),55,0,G2H2(502),n2h2(306))
call HGT_raise_alpha_OLR(G1H4(240),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(240),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(240),ex4(:),G1H2(77),ngZl,m3h2x2(:,474),heltab2x4(:,:,474))
  call Hloop_QV_A(ntryL,G1H4(243),ex5(:),G1H2(83),m3h2x2(:,475),heltab2x4(:,:,475))
  call Hloop_Q_A(ntryL,G1H2(83),55,0,G2H2(503),n2h2(307))
  call Hloop_QV_A(ntryL,G1H4(244),ex5(:),G1H2(84),m3h2x2(:,476),heltab2x4(:,:,476))
  call Hloop_Q_A(ntryL,G1H2(84),55,0,G2H2(504),n2h2(308))
  call Hloop_AV_Q(ntryL,G1H4(245),ex5(:),G1H2(89),m3h2x2(:,477),heltab2x4(:,:,477))
  call Hloop_A_Q(ntryL,G1H2(89),59,0,G2H2(505),n2h2(309))
call HGT_raise_alpha_OLR(G1H4(246),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(246),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(246),ex3(:),G1H2(95),m3h2x2(:,478),heltab2x4(:,:,478))
  call Hloop_AV_Q(ntryL,G1H4(249),ex5(:),G1H2(96),m3h2x2(:,479),heltab2x4(:,:,479))
  call Hloop_A_Q(ntryL,G1H2(96),59,0,G2H2(506),n2h2(310))
  call Hloop_AV_Q(ntryL,G1H4(250),ex5(:),G1H2(101),m3h2x2(:,480),heltab2x4(:,:,480))
  call Hloop_A_Q(ntryL,G1H2(101),59,0,G2H2(507),n2h2(311))
  call Hloop_AV_Q(ntryL,G1H4(251),ex5(:),G1H2(107),m3h2x2(:,481),heltab2x4(:,:,481))
  call Hloop_A_Q(ntryL,G1H2(107),59,0,G2H2(508),n2h2(312))
call HGT_raise_alpha_OLR(G1H4(252),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(252),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(252),ex3(:),G1H2(108),ngZl,m3h2x2(:,482),heltab2x4(:,:,482))
  call Hloop_AV_Q(ntryL,G1H4(255),ex5(:),G1H2(113),m3h2x2(:,483),heltab2x4(:,:,483))
  call Hloop_A_Q(ntryL,G1H2(113),59,0,G2H2(509),n2h2(313))
  call Hloop_AV_Q(ntryL,G1H4(256),ex5(:),G1H2(119),m3h2x2(:,484),heltab2x4(:,:,484))
  call Hloop_A_Q(ntryL,G1H2(119),59,0,G2H2(510),n2h2(314))
  call Hloop_AV_Q(ntryL,G1H4(257),ex5(:),G1H2(120),m3h2x2(:,485),heltab2x4(:,:,485))
  call Hloop_A_Q(ntryL,G1H2(120),59,0,G2H2(511),n2h2(315))
call HGT_raise_alpha_OLR(G1H4(258),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(258),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(258),ex3(:),G1H2(125),m3h2x2(:,486),heltab2x4(:,:,486))
  call Hloop_AV_Q(ntryL,G1H4(261),ex5(:),G1H2(131),m3h2x2(:,487),heltab2x4(:,:,487))
  call Hloop_A_Q(ntryL,G1H2(131),59,0,G2H2(512),n2h2(316))
  call Hloop_AV_Q(ntryL,G1H4(262),ex5(:),G1H2(132),m3h2x2(:,488),heltab2x4(:,:,488))
  call Hloop_A_Q(ntryL,G1H2(132),59,0,G2H2(513),n2h2(317))
  call Hloop_AV_Q(ntryL,G1H4(263),ex5(:),G1H2(137),m3h2x2(:,489),heltab2x4(:,:,489))
  call Hloop_A_Q(ntryL,G1H2(137),59,0,G2H2(514),n2h2(318))
call HGT_raise_alpha_OLR(G1H4(264),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(264),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(264),ex3(:),G1H2(143),ngZl,m3h2x2(:,490),heltab2x4(:,:,490))
  call Hloop_AV_Q(ntryL,G1H4(267),ex5(:),G1H2(144),m3h2x2(:,491),heltab2x4(:,:,491))
  call Hloop_A_Q(ntryL,G1H2(144),59,0,G2H2(515),n2h2(319))
  call Hloop_AV_Q(ntryL,G1H4(268),ex5(:),G1H2(149),m3h2x2(:,492),heltab2x4(:,:,492))
  call Hloop_A_Q(ntryL,G1H2(149),59,0,G2H2(516),n2h2(320))
call HGT_raise_alpha_OLR(G1H4(270),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(270),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(270),ex3(:),G1H2(155),m3h2x2(:,493),heltab2x4(:,:,493))
  call Hloop_WA_Q(ntryL,G1H4(273),ex4(:),G1H2(156),m3h2x2(:,494),heltab2x4(:,:,494))
  call Hloop_A_Q(ntryL,G1H2(156),59,0,G2H2(517),n2h2(321))
call HGT_raise_alpha_OLR(G1H4(275),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(275),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(275),ex4(:),G1H2(161),m3h2x2(:,495),heltab2x4(:,:,495))
  call Hloop_WQ_A(ntryL,G1H4(278),ex3(:),G1H2(167),m3h2x2(:,496),heltab2x4(:,:,496))
  call Hloop_Q_A(ntryL,G1H2(167),55,0,G2H2(518),n2h2(322))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(394),[G2H2(391),G2H2(6),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(484),[G2H2(481),G2H2(8),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(420),[G2H2(417),G2H2(10),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(458),[G2H2(455),G2H2(12),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(235),[G2H2(14),G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(236),[G2H2(16),G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(237),[G2H2(18),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(238),[G2H2(20),G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(243),[G2H2(22),G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(244),[G2H2(24),G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(245),[G2H2(26),G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(246),[G2H2(28),G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(231),[G2H2(30),G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(233),[G2H2(32),G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(232),[G2H2(34),G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(234),[G2H2(36),G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(239),[G2H2(38),G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(240),[G2H2(40),G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(241),[G2H2(42),G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(242),[G2H2(44),G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(47),G1H2(142),G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(50),G1H2(148),G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(59),G1H2(160),G1H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(65),G1H2(172),G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(71),G1H2(184),G1H2(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(77),G1H2(196),G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(83),G1H2(214),G1H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(86),G1H2(220),G1H2(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G2H2(95),G1H2(238),G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(98),G1H2(244),G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(110),[G2H2(107),G1H2(256),G1H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G2H2(113),G1H2(268),G1H2(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G2H2(119),G1H2(286),G1H2(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(128),[G2H2(122),G1H2(292),G1H2(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G2H2(131),G1H2(304),G1H2(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G2H2(137),G1H2(316),G1H2(310)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(490),[G2H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(492),[G2H2(143)])
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(487),[G2H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(489),[G2H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(179),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(255),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(180),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(258),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(181),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(261),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(182),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(264),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(184),[G1H2(44),G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(185),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(186),[G1H2(50),G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(187),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(188),[G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(189),[G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(190),[G1H2(68),G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(191),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(192),[G1H2(74),G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(193),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(194),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(195),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(196),[G1H2(86),G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(197),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(198),[G1H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(199),[G1H2(98),G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(200),[G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(201),[G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(202),[G1H2(116),G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(203),[G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(204),[G1H2(122),G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(205),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(206),[G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(134),G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(177),G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(189),G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(146),G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G1H2(183),G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G1H2(195),G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G1H2(164),G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(201),G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G1H2(170),G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G1H2(213),G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G1H2(207),G1H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G1H2(219),G1H2(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G1H2(188),G1H2(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(105),[G1H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G1H2(194),G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G1H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G1H2(206),G1H2(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(123),[G1H2(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G1H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G1H2(218),G1H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(132),[G1H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(135),[G1H2(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(138),[G1H2(230),G1H2(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G1H2(273),G1H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G1H2(279),G1H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G1H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(149),[G1H2(242),G1H2(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G1H2(285),G1H2(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(151),[G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G1H2(291),G1H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(153),[G1H2(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(154),[G1H2(260),G1H2(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(155),[G1H2(297),G1H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G1H2(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G1H2(266),G1H2(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(158),[G1H2(303),G1H2(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G1H2(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G1H2(309),G1H2(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(161),[G1H2(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G1H2(315),G1H2(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G1H2(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(164),[G1H2(278),G1H2(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(165),[G1H2(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(166),[G1H2(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G1H2(290),G1H2(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(168),[G1H2(289)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(169),[G1H2(295)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G1H2(308),G1H2(296)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(171),[G1H2(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(172),[G1H2(314),G1H2(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(173),[G1H2(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(174),[G1H2(313)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(210),[G1H2(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(209),[G2H2(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(211),[G2H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(216),[G1H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(214),[G2H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(216),[G2H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(222),[G1H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(221),[G2H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(223),[G2H2(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(228),[G1H2(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G2H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(228),[G2H2(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(385),[G2H2(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(387),[G2H2(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(388),[G2H2(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(390),[G2H2(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(396),[G2H2(393)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(411),[G2H2(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(413),[G2H2(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(414),[G2H2(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(416),[G2H2(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(422),[G2H2(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(449),[G2H2(443)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(451),[G2H2(445)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(452),[G2H2(446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(454),[G2H2(448)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(460),[G2H2(457)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(475),[G2H2(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(477),[G2H2(471)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(478),[G2H2(472)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(480),[G2H2(474)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(486),[G2H2(483)])
  call Hotf_5pt_reduction(G2H2(394),RedSet_5(43),mass5set(:,2),  & 
G1H2(168),G1H2(173),G1H2(179),G1H2(180),G1H2(185),G1H2(191),2)
  call HG1shiftOLR(G1H2(173),16,2)
  call Hotf_5pt_reduction(G2H2(484),RedSet_5(46),mass5set(:,2),  & 
G1H2(192),G1H2(197),G1H2(203),G1H2(204),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(197),16,2)
  call Hotf_5pt_reduction(G2H2(420),RedSet_5(44),mass5set(:,2),  & 
G1H2(251),G1H2(252),G1H2(257),G1H2(264),G1H2(269),G1H2(276),2)
  call HG1shiftOLR(G1H2(252),16,2)
  call Hotf_5pt_reduction(G2H2(458),RedSet_5(45),mass5set(:,2),  & 
G1H2(281),G1H2(287),G1H2(288),G1H2(293),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(287),16,2)
  call Hotf_5pt_reduction(G2H2(235),RedSet_5(49),mass5set(:,3),  & 
G1H2(5),G1H2(12),G1H2(17),G1H2(23),G1H2(24),G1H2(35),2)
  call HG1shiftOLR(G1H2(12),8,2)
  call Hotf_5pt_reduction(G2H2(236),RedSet_5(49),mass5set(:,5),  & 
G1H2(36),G1H2(41),G1H2(48),G1H2(53),G1H2(59),G1H2(65),2)
  call HG1shiftOLR(G1H2(41),8,2)
  call Hotf_5pt_reduction(G2H2(237),RedSet_5(49),mass5set(:,4),  & 
G1H2(71),G1H2(72),G1H2(83),G1H2(84),G1H2(89),G1H2(96),2)
  call HG1shiftOLR(G1H2(72),8,2)
  call Hotf_5pt_reduction(G2H2(238),RedSet_5(49),mass5set(:,6),  & 
G1H2(101),G1H2(107),G1H2(113),G1H2(119),G1H2(120),G1H2(131),2)
  call HG1shiftOLR(G1H2(107),8,2)
  call Hotf_5pt_reduction(G2H2(243),RedSet_5(50),mass5set(:,3),  & 
G1H2(132),G1H2(137),G1H2(144),G1H2(149),G1H2(156),G1H2(167),2)
  call HG1shiftOLR(G1H2(137),2,2)
  call Hotf_5pt_reduction(G2H2(244),RedSet_5(50),mass5set(:,5),  & 
G1H2(10),G1H2(16),G1H2(22),G1H2(28),G1H2(34),G1H2(40),2)
  call HG1shiftOLR(G1H2(16),2,2)
  call Hotf_5pt_reduction(G2H2(245),RedSet_5(50),mass5set(:,4),  & 
G1H2(46),G1H2(52),G1H2(58),G1H2(64),G1H2(70),G1H2(76),2)
  call HG1shiftOLR(G1H2(52),2,2)
  call Hotf_5pt_reduction(G2H2(246),RedSet_5(50),mass5set(:,6),  & 
G1H2(82),G1H2(88),G1H2(94),G1H2(100),G1H2(106),G1H2(112),2)
  call HG1shiftOLR(G1H2(88),2,2)
  call Hotf_5pt_reduction(G2H2(231),RedSet_5(51),mass5set(:,3),  & 
G1H2(118),G1H2(124),G1H2(142),G1H2(130),G1H2(148),G1H2(136),2)
  call HG1shiftOLR(G1H2(124),8,2)
  call Hotf_5pt_reduction(G2H2(233),RedSet_5(51),mass5set(:,4),  & 
G1H2(160),G1H2(154),G1H2(172),G1H2(166),G1H2(184),G1H2(178),2)
  call HG1shiftOLR(G1H2(154),8,2)
  call Hotf_5pt_reduction(G2H2(232),RedSet_5(51),mass5set(:,5),  & 
G1H2(196),G1H2(190),G1H2(214),G1H2(202),G1H2(220),G1H2(208),2)
  call HG1shiftOLR(G1H2(190),8,2)
  call Hotf_5pt_reduction(G2H2(234),RedSet_5(51),mass5set(:,6),  & 
G1H2(238),G1H2(226),G1H2(244),G1H2(232),G1H2(256),G1H2(250),2)
  call HG1shiftOLR(G1H2(226),8,2)
  call Hotf_5pt_reduction(G2H2(239),RedSet_5(52),mass5set(:,3),  & 
G1H2(268),G1H2(262),G1H2(286),G1H2(274),G1H2(292),G1H2(280),2)
  call HG1shiftOLR(G1H2(262),2,2)
  call Hotf_5pt_reduction(G2H2(240),RedSet_5(52),mass5set(:,5),  & 
G1H2(304),G1H2(298),G1H2(316),G1H2(310),G1H2(1),G1H2(3),2)
  call HG1shiftOLR(G1H2(298),2,2)
  call Hotf_5pt_reduction(G2H2(241),RedSet_5(52),mass5set(:,4),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(8),2,2)
  call Hotf_5pt_reduction(G2H2(242),RedSet_5(52),mass5set(:,6),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(25),G1H2(26),G1H2(27),2)
  call HG1shiftOLR(G1H2(20),2,2)
call HGT_OLR(G2H2(46),1,1,2)
call HGT_invQ_OLR(G2H2(46),2,5,2)
call HGT_OLR(G2H2(46),6,15,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(53),mass5set(:,3),  & 
G1H2(31),G1H2(44),G1H2(32),G1H2(33),G1H2(37),G1H2(50),2)
  call HG1shiftOLR(G1H2(44),4,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(54),mass5set(:,3),  & 
G1H2(38),G1H2(39),G1H2(43),G1H2(45),G1H2(49),G1H2(51),2)
  call HG1shiftOLR(G1H2(39),16,2)
call HGT_OLR(G2H2(49),1,1,2)
call HGT_invQ_OLR(G2H2(49),2,5,2)
call HGT_OLR(G2H2(49),6,15,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(53),mass5set(:,4),  & 
G1H2(55),G1H2(68),G1H2(56),G1H2(57),G1H2(61),G1H2(74),2)
  call HG1shiftOLR(G1H2(68),4,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(54),mass5set(:,4),  & 
G1H2(62),G1H2(63),G1H2(67),G1H2(69),G1H2(73),G1H2(75),2)
  call HG1shiftOLR(G1H2(63),16,2)
call HGT_OLR(G2H2(52),1,1,2)
call HGT_invQ_OLR(G2H2(52),2,5,2)
call HGT_OLR(G2H2(52),6,15,2)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(53),mass5set(:,5),  & 
G1H2(79),G1H2(86),G1H2(80),G1H2(81),G1H2(85),G1H2(87),2)
  call HG1shiftOLR(G1H2(86),4,2)
call HGT_OLR(G2H2(55),1,1,2)
call HGT_invQ_OLR(G2H2(55),2,5,2)
call HGT_OLR(G2H2(55),6,15,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(53),mass5set(:,6),  & 
G1H2(91),G1H2(98),G1H2(92),G1H2(93),G1H2(97),G1H2(99),2)
  call HG1shiftOLR(G1H2(98),4,2)
call HGT_OLR(G2H2(58),1,1,2)
call HGT_invQ_OLR(G2H2(58),2,5,2)
call HGT_OLR(G2H2(58),6,15,2)
  call Hotf_5pt_reduction(G2H2(58),RedSet_5(55),mass5set(:,3),  & 
G1H2(103),G1H2(116),G1H2(104),G1H2(105),G1H2(109),G1H2(122),2)
  call HG1shiftOLR(G1H2(116),8,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(56),mass5set(:,3),  & 
G1H2(110),G1H2(111),G1H2(115),G1H2(117),G1H2(121),G1H2(123),2)
  call HG1shiftOLR(G1H2(111),16,2)
call HGT_OLR(G2H2(61),1,1,2)
call HGT_invQ_OLR(G2H2(61),2,5,2)
call HGT_OLR(G2H2(61),6,15,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(55),mass5set(:,5),  & 
G1H2(127),G1H2(134),G1H2(128),G1H2(177),G1H2(129),G1H2(133),2)
  call HG1shiftOLR(G1H2(134),8,2)
call HGT_OLR(G2H2(64),1,1,2)
call HGT_invQ_OLR(G2H2(64),2,5,2)
call HGT_OLR(G2H2(64),6,15,2)
  call Hotf_5pt_reduction(G2H2(64),RedSet_5(55),mass5set(:,4),  & 
G1H2(189),G1H2(135),G1H2(139),G1H2(146),G1H2(140),G1H2(183),2)
  call HG1shiftOLR(G1H2(135),8,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(56),mass5set(:,4),  & 
G1H2(141),G1H2(145),G1H2(195),G1H2(147),G1H2(151),G1H2(164),2)
  call HG1shiftOLR(G1H2(145),16,2)
call HGT_OLR(G2H2(67),1,1,2)
call HGT_invQ_OLR(G2H2(67),2,5,2)
call HGT_OLR(G2H2(67),6,15,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(55),mass5set(:,6),  & 
G1H2(152),G1H2(201),G1H2(153),G1H2(157),G1H2(170),G1H2(158),2)
  call HG1shiftOLR(G1H2(201),8,2)
call HGT_OLR(G2H2(70),1,1,2)
call HGT_invQ_OLR(G2H2(70),2,5,2)
call HGT_OLR(G2H2(70),6,15,2)
  call Hotf_5pt_reduction(G2H2(70),RedSet_5(57),mass5set(:,3),  & 
G1H2(213),G1H2(159),G1H2(163),G1H2(207),G1H2(165),G1H2(169),2)
  call HG1shiftOLR(G1H2(159),4,2)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(58),mass5set(:,3),  & 
G1H2(219),G1H2(171),G1H2(175),G1H2(188),G1H2(176),G1H2(181),2)
  call HG1shiftOLR(G1H2(171),16,2)
call HGT_OLR(G2H2(73),1,1,2)
call HGT_invQ_OLR(G2H2(73),2,5,2)
call HGT_OLR(G2H2(73),6,15,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(57),mass5set(:,5),  & 
G1H2(194),G1H2(182),G1H2(187),G1H2(193),G1H2(199),G1H2(206),2)
  call HG1shiftOLR(G1H2(182),4,2)
call HGT_OLR(G2H2(76),1,1,2)
call HGT_invQ_OLR(G2H2(76),2,5,2)
call HGT_OLR(G2H2(76),6,15,2)
  call Hotf_5pt_reduction(G2H2(76),RedSet_5(57),mass5set(:,4),  & 
G1H2(200),G1H2(205),G1H2(211),G1H2(218),G1H2(212),G1H2(217),2)
  call HG1shiftOLR(G1H2(205),4,2)
  call Hotf_5pt_reduction(G2H2(80),RedSet_5(58),mass5set(:,4),  & 
G1H2(223),G1H2(230),G1H2(224),G1H2(273),G1H2(225),G1H2(229),2)
  call HG1shiftOLR(G1H2(230),16,2)
call HGT_OLR(G2H2(79),1,1,2)
call HGT_invQ_OLR(G2H2(79),2,5,2)
call HGT_OLR(G2H2(79),6,15,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(57),mass5set(:,6),  & 
G1H2(279),G1H2(231),G1H2(235),G1H2(242),G1H2(236),G1H2(285),2)
  call HG1shiftOLR(G1H2(231),4,2)
call HGT_OLR(G2H2(82),1,1,2)
call HGT_invQ_OLR(G2H2(82),2,5,2)
call HGT_OLR(G2H2(82),6,15,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(59),mass5set(:,3),  & 
G1H2(237),G1H2(241),G1H2(291),G1H2(243),G1H2(247),G1H2(260),2)
  call HG1shiftOLR(G1H2(241),8,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(60),mass5set(:,3),  & 
G1H2(248),G1H2(297),G1H2(249),G1H2(253),G1H2(266),G1H2(254),2)
  call HG1shiftOLR(G1H2(297),16,2)
call HGT_OLR(G2H2(85),1,1,2)
call HGT_invQ_OLR(G2H2(85),2,5,2)
call HGT_OLR(G2H2(85),6,15,2)
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(59),mass5set(:,4),  & 
G1H2(303),G1H2(255),G1H2(259),G1H2(309),G1H2(261),G1H2(265),2)
  call HG1shiftOLR(G1H2(255),8,2)
  call Hotf_5pt_reduction(G2H2(92),RedSet_5(60),mass5set(:,4),  & 
G1H2(315),G1H2(267),G1H2(271),G1H2(278),G1H2(272),G1H2(277),2)
  call HG1shiftOLR(G1H2(267),16,2)
call HGT_OLR(G2H2(88),1,1,2)
call HGT_invQ_OLR(G2H2(88),2,5,2)
call HGT_OLR(G2H2(88),6,15,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(59),mass5set(:,5),  & 
G1H2(283),G1H2(290),G1H2(284),G1H2(289),G1H2(295),G1H2(308),2)
  call HG1shiftOLR(G1H2(290),8,2)
call HGT_OLR(G2H2(91),1,1,2)
call HGT_invQ_OLR(G2H2(91),2,5,2)
call HGT_OLR(G2H2(91),6,15,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(59),mass5set(:,6),  & 
G1H2(296),G1H2(301),G1H2(314),G1H2(302),G1H2(307),G1H2(313),2)
  call HG1shiftOLR(G1H2(301),8,2)
call HGT_OLR(G2H2(94),1,1,2)
call HGT_invQ_OLR(G2H2(94),2,5,2)
call HGT_OLR(G2H2(94),6,15,2)
  call Hotf_5pt_reduction(G2H2(94),RedSet_5(61),mass5set(:,3),  & 
G1H2(209),G1H2(215),G1H2(221),G1H2(227),G1H2(317),G1H2(318),2)
  call HG1shiftOLR(G1H2(215),1,2)
  call Hotf_5pt_reduction(G2H2(101),RedSet_5(62),mass5set(:,3),  & 
G1H2(319),G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),2)
  call HG1shiftOLR(G1H2(320),16,2)
call HGT_OLR(G2H2(97),1,1,2)
call HGT_invQ_OLR(G2H2(97),2,5,2)
call HGT_OLR(G2H2(97),6,15,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(61),mass5set(:,4),  & 
G1H2(325),G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),2)
  call HG1shiftOLR(G1H2(326),1,2)
  call Hotf_5pt_reduction(G2H2(104),RedSet_5(62),mass5set(:,4),  & 
G1H2(331),G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),2)
  call HG1shiftOLR(G1H2(332),16,2)
call HGT_OLR(G2H2(100),1,1,2)
call HGT_invQ_OLR(G2H2(100),2,5,2)
call HGT_OLR(G2H2(100),6,15,2)
  call Hotf_5pt_reduction(G2H2(100),RedSet_5(61),mass5set(:,5),  & 
G1H2(337),G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(338),1,2)
call HGT_OLR(G2H2(103),1,1,2)
call HGT_invQ_OLR(G2H2(103),2,5,2)
call HGT_OLR(G2H2(103),6,15,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(61),mass5set(:,6),  & 
G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),G1H2(348),2)
  call HG1shiftOLR(G1H2(344),1,2)
call HGT_OLR(G2H2(106),1,1,2)
call HGT_invQ_OLR(G2H2(106),2,5,2)
call HGT_OLR(G2H2(106),6,15,2)
  call Hotf_5pt_reduction(G2H2(106),RedSet_5(63),mass5set(:,3),  & 
G1H2(349),G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),2)
  call HG1shiftOLR(G1H2(350),2,2)
  call Hotf_5pt_reduction(G2H2(110),RedSet_5(64),mass5set(:,3),  & 
G1H2(355),G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),2)
  call HG1shiftOLR(G1H2(356),16,2)
call HGT_OLR(G2H2(109),1,1,2)
call HGT_invQ_OLR(G2H2(109),2,5,2)
call HGT_OLR(G2H2(109),6,15,2)
  call Hotf_5pt_reduction(G2H2(109),RedSet_5(63),mass5set(:,5),  & 
G1H2(361),G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),2)
  call HG1shiftOLR(G1H2(362),2,2)
call HGT_OLR(G2H2(112),1,1,2)
call HGT_invQ_OLR(G2H2(112),2,5,2)
call HGT_OLR(G2H2(112),6,15,2)
  call Hotf_5pt_reduction(G2H2(112),RedSet_5(63),mass5set(:,4),  & 
G1H2(367),G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(368),2,2)
  call Hotf_5pt_reduction(G2H2(116),RedSet_5(64),mass5set(:,4),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),G1H2(378),2)
  call HG1shiftOLR(G1H2(374),16,2)
call HGT_OLR(G2H2(115),1,1,2)
call HGT_invQ_OLR(G2H2(115),2,5,2)
call HGT_OLR(G2H2(115),6,15,2)
  call Hotf_5pt_reduction(G2H2(115),RedSet_5(63),mass5set(:,6),  & 
G1H2(379),G1H2(380),G1H2(381),G1H2(382),G1H2(383),G1H2(384),2)
  call HG1shiftOLR(G1H2(380),2,2)
call HGT_OLR(G2H2(118),1,1,2)
call HGT_invQ_OLR(G2H2(118),2,5,2)
call HGT_OLR(G2H2(118),6,15,2)
  call Hotf_5pt_reduction(G2H2(118),RedSet_5(65),mass5set(:,3),  & 
G1H2(385),G1H2(386),G1H2(387),G1H2(388),G1H2(389),G1H2(390),2)
  call HG1shiftOLR(G1H2(386),1,2)
  call Hotf_5pt_reduction(G2H2(125),RedSet_5(66),mass5set(:,3),  & 
G1H2(391),G1H2(392),G1H2(393),G1H2(394),G1H2(395),G1H2(396),2)
  call HG1shiftOLR(G1H2(392),16,2)
call HGT_OLR(G2H2(121),1,1,2)
call HGT_invQ_OLR(G2H2(121),2,5,2)
call HGT_OLR(G2H2(121),6,15,2)
  call Hotf_5pt_reduction(G2H2(121),RedSet_5(65),mass5set(:,4),  & 
G1H2(397),G1H2(398),G1H2(399),G1H2(400),G1H2(401),G1H2(402),2)
  call HG1shiftOLR(G1H2(398),1,2)
  call Hotf_5pt_reduction(G2H2(128),RedSet_5(66),mass5set(:,4),  & 
G1H2(403),G1H2(404),G1H2(405),G1H2(406),G1H2(407),G1H2(408),2)
  call HG1shiftOLR(G1H2(404),16,2)
call HGT_OLR(G2H2(124),1,1,2)
call HGT_invQ_OLR(G2H2(124),2,5,2)
call HGT_OLR(G2H2(124),6,15,2)
  call Hotf_5pt_reduction(G2H2(124),RedSet_5(65),mass5set(:,5),  & 
G1H2(409),G1H2(410),G1H2(411),G1H2(412),G1H2(413),G1H2(414),2)
  call HG1shiftOLR(G1H2(410),1,2)
call HGT_OLR(G2H2(127),1,1,2)
call HGT_invQ_OLR(G2H2(127),2,5,2)
call HGT_OLR(G2H2(127),6,15,2)
  call Hotf_5pt_reduction(G2H2(127),RedSet_5(65),mass5set(:,6),  & 
G1H2(415),G1H2(416),G1H2(417),G1H2(418),G1H2(419),G1H2(420),2)
  call HG1shiftOLR(G1H2(416),1,2)
call HGT_OLR(G2H2(130),1,1,2)
call HGT_invQ_OLR(G2H2(130),2,5,2)
call HGT_OLR(G2H2(130),6,15,2)
  call Hotf_5pt_reduction(G2H2(130),RedSet_5(67),mass5set(:,3),  & 
G1H2(421),G1H2(422),G1H2(423),G1H2(424),G1H2(425),G1H2(426),2)
  call HG1shiftOLR(G1H2(422),2,2)
  call Hotf_5pt_reduction(G2H2(134),RedSet_5(68),mass5set(:,3),  & 
G1H2(427),G1H2(428),G1H2(429),G1H2(430),G1H2(431),G1H2(432),2)
  call HG1shiftOLR(G1H2(428),16,2)
call HGT_OLR(G2H2(133),1,1,2)
call HGT_invQ_OLR(G2H2(133),2,5,2)
call HGT_OLR(G2H2(133),6,15,2)
  call Hotf_5pt_reduction(G2H2(133),RedSet_5(67),mass5set(:,5),  & 
G1H2(433),G1H2(434),G1H2(435),G1H2(436),G1H2(437),G1H2(438),2)
  call HG1shiftOLR(G1H2(434),2,2)
call HGT_OLR(G2H2(136),1,1,2)
call HGT_invQ_OLR(G2H2(136),2,5,2)
call HGT_OLR(G2H2(136),6,15,2)
  call Hotf_5pt_reduction(G2H2(136),RedSet_5(67),mass5set(:,4),  & 
G1H2(439),G1H2(440),G1H2(441),G1H2(442),G1H2(443),G1H2(444),2)
  call HG1shiftOLR(G1H2(440),2,2)
  call Hotf_5pt_reduction(G2H2(140),RedSet_5(68),mass5set(:,4),  & 
G1H2(445),G1H2(446),G1H2(447),G1H2(448),G1H2(449),G1H2(450),2)
  call HG1shiftOLR(G1H2(446),16,2)
call HGT_OLR(G2H2(139),1,1,2)
call HGT_invQ_OLR(G2H2(139),2,5,2)
call HGT_OLR(G2H2(139),6,15,2)
  call Hotf_5pt_reduction(G2H2(139),RedSet_5(67),mass5set(:,6),  & 
G1H2(451),G1H2(452),G1H2(453),G1H2(454),G1H2(455),G1H2(456),2)
  call HG1shiftOLR(G1H2(452),2,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(69),mass5set(:,14),  & 
G1H2(457),G1H2(458),G1H2(459),G1H2(460),G1H2(461),G1H2(462),2)
  call HG1shiftOLR(G1H2(458),8,2)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(490),ex3(:),G2tensor(1),m3h2x1(:,111),heltab2x2(:,:,111))
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(101))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(492),ex3(:),G2tensor(3),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(70),mass5set(:,14),  & 
G1H2(2),G1H2(463),G1H2(464),G1H2(465),G1H2(466),G1H2(467),2)
  call HG1shiftOLR(G1H2(463),4,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(487),ex4(:),G2tensor(4),m3h2x1(:,114),heltab2x2(:,:,114))
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(102))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(489),ex4(:),G2tensor(9),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hotf_5pt_reduction(G2H2(179),RedSet_5(71),mass5set(:,15),  & 
G1H2(4),G1H2(468),G1H2(469),G1H2(470),G1H2(471),G1H2(472),2)
  call HG1shiftOLR(G1H2(468),16,2)
  call Hotf_5pt_reduction(G2H2(255),RedSet_5(21),mass5set(:,7),  & 
G1H2(473),G1H2(474),G1H2(475),G1H2(476),G1H2(477),G1H2(478),2)
  call HG1shiftOLR(G1H2(474),16,2)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(72),mass5set(:,9),  & 
G1H2(479),G1H2(480),G1H2(481),G1H2(482),G1H2(483),G1H2(484),2)
  call HG1shiftOLR(G1H2(480),16,2)
  call Hotf_5pt_reduction(G2H2(180),RedSet_5(73),mass5set(:,15),  & 
G1H2(485),G1H2(486),G1H2(487),G1H2(488),G1H2(489),G1H2(490),2)
  call HG1shiftOLR(G1H2(486),16,2)
  call Hotf_5pt_reduction(G2H2(258),RedSet_5(22),mass5set(:,7),  & 
G1H2(491),G1H2(492),G1H2(493),G1H2(494),G1H2(495),G1H2(496),2)
  call HG1shiftOLR(G1H2(492),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(74),mass5set(:,9),  & 
G1H2(497),G1H2(498),G1H2(499),G1H2(500),G1H2(501),G1H2(502),2)
  call HG1shiftOLR(G1H2(498),16,2)
  call Hotf_5pt_reduction(G2H2(181),RedSet_5(75),mass5set(:,15),  & 
G1H2(503),G1H2(504),G1H2(505),G1H2(506),G1H2(507),G1H2(508),2)
  call HG1shiftOLR(G1H2(504),16,2)
  call Hotf_5pt_reduction(G2H2(261),RedSet_5(23),mass5set(:,7),  & 
G1H2(509),G1H2(510),G1H2(511),G1H2(512),G1H2(513),G1H2(514),2)
  call HG1shiftOLR(G1H2(510),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(76),mass5set(:,9),  & 
G1H2(515),G1H2(516),G1H2(517),G1H2(518),G1H2(519),G1H2(520),2)
  call HG1shiftOLR(G1H2(516),16,2)
  call Hotf_5pt_reduction(G2H2(182),RedSet_5(77),mass5set(:,15),  & 
G1H2(521),G1H2(522),G1H2(523),G1H2(524),G1H2(525),G1H2(526),2)
  call HG1shiftOLR(G1H2(522),16,2)
  call Hotf_5pt_reduction(G2H2(264),RedSet_5(25),mass5set(:,7),  & 
G1H2(527),G1H2(528),G1H2(529),G1H2(530),G1H2(531),G1H2(532),2)
  call HG1shiftOLR(G1H2(528),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(78),mass5set(:,9),  & 
G1H2(533),G1H2(534),G1H2(535),G1H2(536),G1H2(537),G1H2(538),2)
  call HG1shiftOLR(G1H2(534),16,2)
  call Hotf_5pt_reduction(G2H2(183),RedSet_5(79),mass5set(:,3),  & 
G1H2(539),G1H2(540),G1H2(541),G1H2(542),G1H2(543),G1H2(544),2)
  call HG1shiftOLR(G1H2(540),8,2)
  call Hotf_5pt_reduction(G2H2(184),RedSet_5(80),mass5set(:,3),  & 
G1H2(545),G1H2(546),G1H2(547),G1H2(548),G1H2(549),G1H2(550),2)
  call HG1shiftOLR(G1H2(546),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(81),mass5set(:,3),  & 
G1H2(551),G1H2(552),G1H2(553),G1H2(554),G1H2(555),G1H2(556),2)
  call HG1shiftOLR(G1H2(552),8,2)
  call Hotf_5pt_reduction(G2H2(185),RedSet_5(79),mass5set(:,5),  & 
G1H2(557),G1H2(558),G1H2(559),G1H2(560),G1H2(561),G1H2(562),2)
  call HG1shiftOLR(G1H2(558),8,2)
  call Hotf_5pt_reduction(G2H2(186),RedSet_5(80),mass5set(:,5),  & 
G1H2(563),G1H2(564),G1H2(565),G1H2(566),G1H2(567),G1H2(568),2)
  call HG1shiftOLR(G1H2(564),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(81),mass5set(:,5),  & 
G1H2(569),G1H2(570),G1H2(571),G1H2(572),G1H2(573),G1H2(574),2)
  call HG1shiftOLR(G1H2(570),8,2)
  call Hotf_5pt_reduction(G2H2(187),RedSet_5(79),mass5set(:,16),  & 
G1H2(575),G1H2(576),G1H2(577),G1H2(578),G1H2(579),G1H2(580),2)
  call HG1shiftOLR(G1H2(576),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(81),mass5set(:,4),  & 
G1H2(581),G1H2(582),G1H2(583),G1H2(584),G1H2(585),G1H2(586),2)
  call HG1shiftOLR(G1H2(582),8,2)
  call Hotf_5pt_reduction(G2H2(188),RedSet_5(79),mass5set(:,17),  & 
G1H2(587),G1H2(588),G1H2(589),G1H2(590),G1H2(591),G1H2(592),2)
  call HG1shiftOLR(G1H2(588),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(81),mass5set(:,6),  & 
G1H2(593),G1H2(594),G1H2(595),G1H2(596),G1H2(597),G1H2(598),2)
  call HG1shiftOLR(G1H2(594),8,2)
  call Hotf_5pt_reduction(G2H2(189),RedSet_5(82),mass5set(:,3),  & 
G1H2(599),G1H2(600),G1H2(601),G1H2(602),G1H2(603),G1H2(604),2)
  call HG1shiftOLR(G1H2(600),2,2)
  call Hotf_5pt_reduction(G2H2(190),RedSet_5(83),mass5set(:,3),  & 
G1H2(605),G1H2(606),G1H2(607),G1H2(608),G1H2(609),G1H2(610),2)
  call HG1shiftOLR(G1H2(606),2,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(84),mass5set(:,3),  & 
G1H2(611),G1H2(612),G1H2(613),G1H2(614),G1H2(615),G1H2(616),2)
  call HG1shiftOLR(G1H2(612),2,2)
  call Hotf_5pt_reduction(G2H2(191),RedSet_5(82),mass5set(:,5),  & 
G1H2(617),G1H2(618),G1H2(619),G1H2(620),G1H2(621),G1H2(622),2)
  call HG1shiftOLR(G1H2(618),2,2)
  call Hotf_5pt_reduction(G2H2(192),RedSet_5(83),mass5set(:,5),  & 
G1H2(623),G1H2(624),G1H2(625),G1H2(626),G1H2(627),G1H2(628),2)
  call HG1shiftOLR(G1H2(624),2,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(84),mass5set(:,5),  & 
G1H2(629),G1H2(630),G1H2(631),G1H2(632),G1H2(633),G1H2(634),2)
  call HG1shiftOLR(G1H2(630),2,2)
  call Hotf_5pt_reduction(G2H2(193),RedSet_5(82),mass5set(:,16),  & 
G1H2(635),G1H2(636),G1H2(637),G1H2(638),G1H2(639),G1H2(640),2)
  call HG1shiftOLR(G1H2(636),2,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(84),mass5set(:,4),  & 
G1H2(641),G1H2(642),G1H2(643),G1H2(644),G1H2(645),G1H2(646),2)
  call HG1shiftOLR(G1H2(642),2,2)
  call Hotf_5pt_reduction(G2H2(194),RedSet_5(82),mass5set(:,17),  & 
G1H2(647),G1H2(648),G1H2(649),G1H2(650),G1H2(651),G1H2(652),2)
  call HG1shiftOLR(G1H2(648),2,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(84),mass5set(:,6),  & 
G1H2(653),G1H2(654),G1H2(655),G1H2(656),G1H2(657),G1H2(658),2)
  call HG1shiftOLR(G1H2(654),2,2)
  call Hotf_5pt_reduction(G2H2(195),RedSet_5(85),mass5set(:,3),  & 
G1H2(659),G1H2(660),G1H2(661),G1H2(662),G1H2(663),G1H2(664),2)
  call HG1shiftOLR(G1H2(660),8,2)
  call Hotf_5pt_reduction(G2H2(196),RedSet_5(86),mass5set(:,3),  & 
G1H2(665),G1H2(666),G1H2(667),G1H2(668),G1H2(669),G1H2(670),2)
  call HG1shiftOLR(G1H2(666),8,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(87),mass5set(:,3),  & 
G1H2(671),G1H2(672),G1H2(673),G1H2(674),G1H2(675),G1H2(676),2)
  call HG1shiftOLR(G1H2(672),8,2)
  call Hotf_5pt_reduction(G2H2(197),RedSet_5(85),mass5set(:,16),  & 
G1H2(677),G1H2(678),G1H2(679),G1H2(680),G1H2(681),G1H2(682),2)
  call HG1shiftOLR(G1H2(678),8,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(87),mass5set(:,4),  & 
G1H2(683),G1H2(684),G1H2(685),G1H2(686),G1H2(687),G1H2(688),2)
  call HG1shiftOLR(G1H2(684),8,2)
  call Hotf_5pt_reduction(G2H2(198),RedSet_5(85),mass5set(:,5),  & 
G1H2(689),G1H2(690),G1H2(691),G1H2(692),G1H2(693),G1H2(694),2)
  call HG1shiftOLR(G1H2(690),8,2)
  call Hotf_5pt_reduction(G2H2(199),RedSet_5(86),mass5set(:,5),  & 
G1H2(695),G1H2(696),G1H2(697),G1H2(698),G1H2(699),G1H2(700),2)
  call HG1shiftOLR(G1H2(696),8,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(87),mass5set(:,5),  & 
G1H2(701),G1H2(702),G1H2(703),G1H2(704),G1H2(705),G1H2(706),2)
  call HG1shiftOLR(G1H2(702),8,2)
  call Hotf_5pt_reduction(G2H2(200),RedSet_5(85),mass5set(:,17),  & 
G1H2(707),G1H2(708),G1H2(709),G1H2(710),G1H2(711),G1H2(712),2)
  call HG1shiftOLR(G1H2(708),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(87),mass5set(:,6),  & 
G1H2(713),G1H2(714),G1H2(715),G1H2(716),G1H2(717),G1H2(718),2)
  call HG1shiftOLR(G1H2(714),8,2)
  call Hotf_5pt_reduction(G2H2(201),RedSet_5(88),mass5set(:,3),  & 
G1H2(719),G1H2(720),G1H2(721),G1H2(722),G1H2(723),G1H2(724),2)
  call HG1shiftOLR(G1H2(720),2,2)
  call Hotf_5pt_reduction(G2H2(202),RedSet_5(89),mass5set(:,3),  & 
G1H2(725),G1H2(726),G1H2(727),G1H2(728),G1H2(729),G1H2(730),2)
  call HG1shiftOLR(G1H2(726),2,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(90),mass5set(:,3),  & 
G1H2(731),G1H2(732),G1H2(733),G1H2(734),G1H2(735),G1H2(736),2)
  call HG1shiftOLR(G1H2(732),2,2)
  call Hotf_5pt_reduction(G2H2(203),RedSet_5(88),mass5set(:,5),  & 
G1H2(737),G1H2(738),G1H2(739),G1H2(740),G1H2(741),G1H2(742),2)
  call HG1shiftOLR(G1H2(738),2,2)
  call Hotf_5pt_reduction(G2H2(204),RedSet_5(89),mass5set(:,5),  & 
G1H2(743),G1H2(744),G1H2(745),G1H2(746),G1H2(747),G1H2(748),2)
  call HG1shiftOLR(G1H2(744),2,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(90),mass5set(:,5),  & 
G1H2(749),G1H2(750),G1H2(751),G1H2(752),G1H2(753),G1H2(754),2)
  call HG1shiftOLR(G1H2(750),2,2)
  call Hotf_5pt_reduction(G2H2(205),RedSet_5(88),mass5set(:,16),  & 
G1H2(755),G1H2(756),G1H2(757),G1H2(758),G1H2(759),G1H2(760),2)
  call HG1shiftOLR(G1H2(756),2,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(90),mass5set(:,4),  & 
G1H2(761),G1H2(762),G1H2(763),G1H2(764),G1H2(765),G1H2(766),2)
  call HG1shiftOLR(G1H2(762),2,2)
  call Hotf_5pt_reduction(G2H2(206),RedSet_5(88),mass5set(:,17),  & 
G1H2(767),G1H2(768),G1H2(769),G1H2(770),G1H2(771),G1H2(772),2)
  call HG1shiftOLR(G1H2(768),2,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(90),mass5set(:,6),  & 
G1H2(773),G1H2(774),G1H2(775),G1H2(776),G1H2(777),G1H2(778),2)
  call HG1shiftOLR(G1H2(774),2,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(91),mass5set(:,3),  & 
G1H2(779),G1H2(780),G1H2(781),G1H2(782),G1H2(783),G1H2(784),2)
  call HG1shiftOLR(G1H2(780),16,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(92),mass5set(:,3),  & 
G1H2(785),G1H2(786),G1H2(787),G1H2(788),G1H2(789),G1H2(790),2)
  call HG1shiftOLR(G1H2(786),16,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(27),mass5set(:,3),  & 
G1H2(791),G1H2(792),G1H2(793),G1H2(794),G1H2(795),G1H2(796),2)
  call HG1shiftOLR(G1H2(792),16,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(91),mass5set(:,16),  & 
G1H2(797),G1H2(798),G1H2(799),G1H2(800),G1H2(801),G1H2(802),2)
  call HG1shiftOLR(G1H2(798),16,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(27),mass5set(:,4),  & 
G1H2(803),G1H2(804),G1H2(805),G1H2(806),G1H2(807),G1H2(808),2)
  call HG1shiftOLR(G1H2(804),16,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(91),mass5set(:,13),  & 
G1H2(809),G1H2(810),G1H2(811),G1H2(812),G1H2(813),G1H2(814),2)
  call HG1shiftOLR(G1H2(810),16,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(92),mass5set(:,13),  & 
G1H2(815),G1H2(816),G1H2(817),G1H2(818),G1H2(819),G1H2(820),2)
  call HG1shiftOLR(G1H2(816),16,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(27),mass5set(:,13),  & 
G1H2(821),G1H2(822),G1H2(823),G1H2(824),G1H2(825),G1H2(826),2)
  call HG1shiftOLR(G1H2(822),16,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(91),mass5set(:,18),  & 
G1H2(827),G1H2(828),G1H2(829),G1H2(830),G1H2(831),G1H2(832),2)
  call HG1shiftOLR(G1H2(828),16,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(27),mass5set(:,19),  & 
G1H2(833),G1H2(834),G1H2(835),G1H2(836),G1H2(837),G1H2(838),2)
  call HG1shiftOLR(G1H2(834),16,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(93),mass5set(:,3),  & 
G1H2(839),G1H2(840),G1H2(841),G1H2(842),G1H2(843),G1H2(844),2)
  call HG1shiftOLR(G1H2(840),16,2)
  call Hotf_5pt_reduction(G2H2(72),RedSet_5(94),mass5set(:,3),  & 
G1H2(845),G1H2(846),G1H2(847),G1H2(848),G1H2(849),G1H2(850),2)
  call HG1shiftOLR(G1H2(846),16,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(28),mass5set(:,3),  & 
G1H2(851),G1H2(852),G1H2(853),G1H2(854),G1H2(855),G1H2(856),2)
  call HG1shiftOLR(G1H2(852),16,2)
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(93),mass5set(:,13),  & 
G1H2(857),G1H2(858),G1H2(859),G1H2(860),G1H2(861),G1H2(862),2)
  call HG1shiftOLR(G1H2(858),16,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(94),mass5set(:,13),  & 
G1H2(863),G1H2(864),G1H2(865),G1H2(866),G1H2(867),G1H2(868),2)
  call HG1shiftOLR(G1H2(864),16,2)
  call Hotf_5pt_reduction(G2H2(84),RedSet_5(28),mass5set(:,13),  & 
G1H2(869),G1H2(870),G1H2(871),G1H2(872),G1H2(873),G1H2(874),2)
  call HG1shiftOLR(G1H2(870),16,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(93),mass5set(:,16),  & 
G1H2(875),G1H2(876),G1H2(877),G1H2(878),G1H2(879),G1H2(880),2)
  call HG1shiftOLR(G1H2(876),16,2)
  call Hotf_5pt_reduction(G2H2(90),RedSet_5(28),mass5set(:,4),  & 
G1H2(881),G1H2(882),G1H2(883),G1H2(884),G1H2(885),G1H2(886),2)
  call HG1shiftOLR(G1H2(882),16,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(93),mass5set(:,18),  & 
G1H2(887),G1H2(888),G1H2(889),G1H2(890),G1H2(891),G1H2(892),2)
  call HG1shiftOLR(G1H2(888),16,2)
  call Hotf_5pt_reduction(G2H2(96),RedSet_5(28),mass5set(:,19),  & 
G1H2(893),G1H2(894),G1H2(895),G1H2(896),G1H2(897),G1H2(898),2)
  call HG1shiftOLR(G1H2(894),16,2)
  call Hotf_5pt_reduction(G2H2(99),RedSet_5(95),mass5set(:,3),  & 
G1H2(899),G1H2(900),G1H2(901),G1H2(902),G1H2(903),G1H2(904),2)
  call HG1shiftOLR(G1H2(900),16,2)
  call Hotf_5pt_reduction(G2H2(102),RedSet_5(96),mass5set(:,3),  & 
G1H2(905),G1H2(906),G1H2(907),G1H2(908),G1H2(909),G1H2(910),2)
  call HG1shiftOLR(G1H2(906),16,2)
  call Hotf_5pt_reduction(G2H2(105),RedSet_5(95),mass5set(:,13),  & 
G1H2(911),G1H2(912),G1H2(913),G1H2(914),G1H2(915),G1H2(916),2)
  call HG1shiftOLR(G1H2(912),16,2)
  call Hotf_5pt_reduction(G2H2(108),RedSet_5(96),mass5set(:,13),  & 
G1H2(917),G1H2(918),G1H2(919),G1H2(920),G1H2(921),G1H2(922),2)
  call HG1shiftOLR(G1H2(918),16,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(95),mass5set(:,16),  & 
G1H2(923),G1H2(924),G1H2(925),G1H2(926),G1H2(927),G1H2(928),2)
  call HG1shiftOLR(G1H2(924),16,2)
  call Hotf_5pt_reduction(G2H2(114),RedSet_5(95),mass5set(:,18),  & 
G1H2(929),G1H2(930),G1H2(931),G1H2(932),G1H2(933),G1H2(934),2)
  call HG1shiftOLR(G1H2(930),16,2)
  call Hotf_5pt_reduction(G2H2(117),RedSet_5(97),mass5set(:,3),  & 
G1H2(935),G1H2(936),G1H2(937),G1H2(938),G1H2(939),G1H2(940),2)
  call HG1shiftOLR(G1H2(936),16,2)
  call Hotf_5pt_reduction(G2H2(120),RedSet_5(98),mass5set(:,3),  & 
G1H2(941),G1H2(942),G1H2(943),G1H2(944),G1H2(945),G1H2(946),2)
  call HG1shiftOLR(G1H2(942),16,2)
  call Hotf_5pt_reduction(G2H2(123),RedSet_5(97),mass5set(:,16),  & 
G1H2(947),G1H2(948),G1H2(949),G1H2(950),G1H2(951),G1H2(952),2)
  call HG1shiftOLR(G1H2(948),16,2)
  call Hotf_5pt_reduction(G2H2(126),RedSet_5(97),mass5set(:,13),  & 
G1H2(953),G1H2(954),G1H2(955),G1H2(956),G1H2(957),G1H2(958),2)
  call HG1shiftOLR(G1H2(954),16,2)
  call Hotf_5pt_reduction(G2H2(129),RedSet_5(98),mass5set(:,13),  & 
G1H2(959),G1H2(960),G1H2(961),G1H2(962),G1H2(963),G1H2(964),2)
  call HG1shiftOLR(G1H2(960),16,2)
  call Hotf_5pt_reduction(G2H2(132),RedSet_5(97),mass5set(:,18),  & 
G1H2(965),G1H2(966),G1H2(967),G1H2(968),G1H2(969),G1H2(970),2)
  call HG1shiftOLR(G1H2(966),16,2)
  call Hotf_5pt_reduction(G2H2(135),RedSet_5(99),mass5set(:,3),  & 
G1H2(971),G1H2(972),G1H2(973),G1H2(974),G1H2(975),G1H2(976),2)
  call HG1shiftOLR(G1H2(972),16,2)
  call Hotf_5pt_reduction(G2H2(138),RedSet_5(100),mass5set(:,3),  & 
G1H2(977),G1H2(978),G1H2(979),G1H2(980),G1H2(981),G1H2(982),2)
  call HG1shiftOLR(G1H2(978),16,2)
  call Hotf_5pt_reduction(G2H2(141),RedSet_5(29),mass5set(:,3),  & 
G1H2(983),G1H2(984),G1H2(985),G1H2(986),G1H2(987),G1H2(988),2)
  call HG1shiftOLR(G1H2(984),16,2)
  call Hotf_5pt_reduction(G2H2(144),RedSet_5(99),mass5set(:,16),  & 
G1H2(989),G1H2(990),G1H2(991),G1H2(992),G1H2(993),G1H2(994),2)
  call HG1shiftOLR(G1H2(990),16,2)
  call Hotf_5pt_reduction(G2H2(147),RedSet_5(29),mass5set(:,4),  & 
G1H2(995),G1H2(996),G1H2(997),G1H2(998),G1H2(999),G1H2(1000),2)
  call HG1shiftOLR(G1H2(996),16,2)
  call Hotf_5pt_reduction(G2H2(148),RedSet_5(99),mass5set(:,13),  & 
G1H2(1001),G1H2(1002),G1H2(1003),G1H2(1004),G1H2(1005),G1H2(1006),2)
  call HG1shiftOLR(G1H2(1002),16,2)
  call Hotf_5pt_reduction(G2H2(149),RedSet_5(100),mass5set(:,13),  & 
G1H2(1007),G1H2(1008),G1H2(1009),G1H2(1010),G1H2(1011),G1H2(1012),2)
  call HG1shiftOLR(G1H2(1008),16,2)
  call Hotf_5pt_reduction(G2H2(150),RedSet_5(29),mass5set(:,13),  & 
G1H2(1013),G1H2(1014),G1H2(1015),G1H2(1016),G1H2(1017),G1H2(1018),2)
  call HG1shiftOLR(G1H2(1014),16,2)
  call Hotf_5pt_reduction(G2H2(151),RedSet_5(99),mass5set(:,18),  & 
G1H2(1019),G1H2(1020),G1H2(1021),G1H2(1022),G1H2(1023),G1H2(1024),2)
  call HG1shiftOLR(G1H2(1020),16,2)
  call Hotf_5pt_reduction(G2H2(152),RedSet_5(29),mass5set(:,19),  & 
G1H2(1025),G1H2(1026),G1H2(1027),G1H2(1028),G1H2(1029),G1H2(1030),2)
  call HG1shiftOLR(G1H2(1026),16,2)
  call Hotf_5pt_reduction(G2H2(153),RedSet_5(101),mass5set(:,3),  & 
G1H2(1031),G1H2(1032),G1H2(1033),G1H2(1034),G1H2(1035),G1H2(1036),2)
  call HG1shiftOLR(G1H2(1032),16,2)
  call Hotf_5pt_reduction(G2H2(154),RedSet_5(102),mass5set(:,3),  & 
G1H2(1037),G1H2(1038),G1H2(1039),G1H2(1040),G1H2(1041),G1H2(1042),2)
  call HG1shiftOLR(G1H2(1038),16,2)
  call Hotf_5pt_reduction(G2H2(155),RedSet_5(30),mass5set(:,3),  & 
G1H2(1043),G1H2(1044),G1H2(1045),G1H2(1046),G1H2(1047),G1H2(1048),2)
  call HG1shiftOLR(G1H2(1044),16,2)
  call Hotf_5pt_reduction(G2H2(156),RedSet_5(101),mass5set(:,13),  & 
G1H2(1049),G1H2(1050),G1H2(1051),G1H2(1052),G1H2(1053),G1H2(1054),2)
  call HG1shiftOLR(G1H2(1050),16,2)
  call Hotf_5pt_reduction(G2H2(157),RedSet_5(102),mass5set(:,13),  & 
G1H2(1055),G1H2(1056),G1H2(1057),G1H2(1058),G1H2(1059),G1H2(1060),2)
  call HG1shiftOLR(G1H2(1056),16,2)
  call Hotf_5pt_reduction(G2H2(158),RedSet_5(30),mass5set(:,13),  & 
G1H2(1061),G1H2(1062),G1H2(1063),G1H2(1064),G1H2(1065),G1H2(1066),2)
  call HG1shiftOLR(G1H2(1062),16,2)
  call Hotf_5pt_reduction(G2H2(159),RedSet_5(101),mass5set(:,16),  & 
G1H2(1067),G1H2(1068),G1H2(1069),G1H2(1070),G1H2(1071),G1H2(1072),2)
  call HG1shiftOLR(G1H2(1068),16,2)
  call Hotf_5pt_reduction(G2H2(160),RedSet_5(30),mass5set(:,4),  & 
G1H2(1073),G1H2(1074),G1H2(1075),G1H2(1076),G1H2(1077),G1H2(1078),2)
  call HG1shiftOLR(G1H2(1074),16,2)
  call Hotf_5pt_reduction(G2H2(161),RedSet_5(101),mass5set(:,18),  & 
G1H2(1079),G1H2(1080),G1H2(1081),G1H2(1082),G1H2(1083),G1H2(1084),2)
  call HG1shiftOLR(G1H2(1080),16,2)
  call Hotf_5pt_reduction(G2H2(162),RedSet_5(30),mass5set(:,19),  & 
G1H2(1085),G1H2(1086),G1H2(1087),G1H2(1088),G1H2(1089),G1H2(1090),2)
  call HG1shiftOLR(G1H2(1086),16,2)
  call Hotf_5pt_reduction(G2H2(163),RedSet_5(103),mass5set(:,3),  & 
G1H2(1091),G1H2(1092),G1H2(1093),G1H2(1094),G1H2(1095),G1H2(1096),2)
  call HG1shiftOLR(G1H2(1092),16,2)
  call Hotf_5pt_reduction(G2H2(164),RedSet_5(104),mass5set(:,3),  & 
G1H2(1097),G1H2(1098),G1H2(1099),G1H2(1100),G1H2(1101),G1H2(1102),2)
  call HG1shiftOLR(G1H2(1098),16,2)
  call Hotf_5pt_reduction(G2H2(165),RedSet_5(103),mass5set(:,16),  & 
G1H2(1103),G1H2(1104),G1H2(1105),G1H2(1106),G1H2(1107),G1H2(1108),2)
  call HG1shiftOLR(G1H2(1104),16,2)
  call Hotf_5pt_reduction(G2H2(166),RedSet_5(103),mass5set(:,13),  & 
G1H2(1109),G1H2(1110),G1H2(1111),G1H2(1112),G1H2(1113),G1H2(1114),2)
  call HG1shiftOLR(G1H2(1110),16,2)
  call Hotf_5pt_reduction(G2H2(167),RedSet_5(104),mass5set(:,13),  & 
G1H2(1115),G1H2(1116),G1H2(1117),G1H2(1118),G1H2(1119),G1H2(1120),2)
  call HG1shiftOLR(G1H2(1116),16,2)
  call Hotf_5pt_reduction(G2H2(168),RedSet_5(103),mass5set(:,18),  & 
G1H2(1121),G1H2(1122),G1H2(1123),G1H2(1124),G1H2(1125),G1H2(1126),2)
  call HG1shiftOLR(G1H2(1122),16,2)
  call Hotf_5pt_reduction(G2H2(169),RedSet_5(105),mass5set(:,3),  & 
G1H2(1127),G1H2(1128),G1H2(1129),G1H2(1130),G1H2(1131),G1H2(1132),2)
  call HG1shiftOLR(G1H2(1128),16,2)
  call Hotf_5pt_reduction(G2H2(170),RedSet_5(106),mass5set(:,3),  & 
G1H2(1133),G1H2(1134),G1H2(1135),G1H2(1136),G1H2(1137),G1H2(1138),2)
  call HG1shiftOLR(G1H2(1134),16,2)
  call Hotf_5pt_reduction(G2H2(171),RedSet_5(105),mass5set(:,13),  & 
G1H2(1139),G1H2(1140),G1H2(1141),G1H2(1142),G1H2(1143),G1H2(1144),2)
  call HG1shiftOLR(G1H2(1140),16,2)
  call Hotf_5pt_reduction(G2H2(172),RedSet_5(106),mass5set(:,13),  & 
G1H2(1145),G1H2(1146),G1H2(1147),G1H2(1148),G1H2(1149),G1H2(1150),2)
  call HG1shiftOLR(G1H2(1146),16,2)
  call Hotf_5pt_reduction(G2H2(173),RedSet_5(105),mass5set(:,16),  & 
G1H2(1151),G1H2(1152),G1H2(1153),G1H2(1154),G1H2(1155),G1H2(1156),2)
  call HG1shiftOLR(G1H2(1152),16,2)
  call Hotf_5pt_reduction(G2H2(174),RedSet_5(105),mass5set(:,18),  & 
G1H2(1157),G1H2(1158),G1H2(1159),G1H2(1160),G1H2(1161),G1H2(1162),2)
  call HG1shiftOLR(G1H2(1158),16,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(207),ex5(:),G2tensor(11),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(210),47,ex5(:),16,G2tensor(13),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(209),ex5(:),G2tensor(5),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(211),ex5(:),G2tensor(6),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(212),ex5(:),G2tensor(15),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(216),47,ex5(:),16,G2tensor(17),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(214),ex5(:),G2tensor(19),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(216),ex5(:),G2tensor(21),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(217),ex5(:),G2tensor(23),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(218),ex5(:),G2tensor(25),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(128),51,wf4(:,13),12,G2tensor(27),m3h4x1(:,1),heltab2x4(:,:,497))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(138),51,wf4(:,16),12,G2tensor(29),m3h4x1(:,2),heltab2x4(:,:,498))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(50),wf4(:,13),G2tensor(31),m3h4x1(:,3),heltab2x4(:,:,499))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(57),wf4(:,16),G2tensor(33),m3h4x1(:,4),heltab2x4(:,:,500))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(61),wf4(:,13),G2tensor(35),m3h4x1(:,5),heltab2x4(:,:,501))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(65),wf4(:,16),G2tensor(37),m3h4x1(:,6),heltab2x4(:,:,502))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(219),ex5(:),G2tensor(39),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(168),51,wf4(:,13),12,G2tensor(41),m3h4x1(:,7),heltab2x4(:,:,503))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(165),51,wf4(:,16),12,G2tensor(43),m3h4x1(:,8),heltab2x4(:,:,504))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(69),wf4(:,13),G2tensor(45),m3h4x1(:,9),heltab2x4(:,:,505))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(73),wf4(:,16),G2tensor(47),m3h4x1(:,10),heltab2x4(:,:,506))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(25),wf4(:,13),G2tensor(49),m3h4x1(:,11),heltab2x4(:,:,507))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(77),wf4(:,16),G2tensor(51),m3h4x1(:,12),heltab2x4(:,:,508))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(222),47,ex5(:),16,G2tensor(53),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(221),ex5(:),G2tensor(55),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(223),ex5(:),G2tensor(57),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(224),ex5(:),G2tensor(59),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(228),47,ex5(:),16,G2tensor(61),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(226),ex5(:),G2tensor(63),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(228),ex5(:),G2tensor(65),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(229),ex5(:),G2tensor(67),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(230),ex5(:),G2tensor(69),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(17),mass5set(:,3),  & 
G1H4(87),G1H4(88),G1H4(92),G1H4(93),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(88),17,4)
  call Hotf_5pt_reduction(G2H4(81),RedSet_5(17),mass5set(:,5),  & 
G1H4(104),G1H4(105),G1H4(118),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(105),17,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(17),mass5set(:,4),  & 
G1H4(199),G1H4(57),G1H4(213),G1H4(211),G1H4(7),G1H4(11),4)
  call HG1shiftOLR(G1H4(57),17,4)
  call Hotf_5pt_reduction(G2H4(85),RedSet_5(17),mass5set(:,6),  & 
G1H4(13),G1H4(17),G1H4(23),G1H4(25),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(17),17,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(15),mass5set(:,3),  & 
G1H4(36),G1H4(37),G1H4(41),G1H4(43),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(37),17,4)
  call Hotf_5pt_reduction(G2H4(89),RedSet_5(15),mass5set(:,5),  & 
G1H4(59),G1H4(60),G1H4(77),G1H4(78),G1H4(83),G1H4(89),4)
  call HG1shiftOLR(G1H4(60),17,4)
  call Hotf_5pt_reduction(G2H4(93),RedSet_5(15),mass5set(:,4),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(107),G1H4(114),G1H4(115),4)
  call HG1shiftOLR(G1H4(102),17,4)
  call Hotf_5pt_reduction(G2H4(97),RedSet_5(15),mass5set(:,6),  & 
G1H4(119),G1H4(121),G1H4(127),G1H4(131),G1H4(132),G1H4(133),4)
  call HG1shiftOLR(G1H4(121),17,4)
  call Hotf_5pt_reduction(G2H4(101),RedSet_5(16),mass5set(:,3),  & 
G1H4(143),G1H4(145),G1H4(149),G1H4(150),G1H4(162),G1H4(167),4)
  call HG1shiftOLR(G1H4(145),18,4)
  call Hotf_5pt_reduction(G2H4(105),RedSet_5(16),mass5set(:,5),  & 
G1H4(173),G1H4(174),G1H4(185),G1H4(191),G1H4(197),G1H4(63),4)
  call HG1shiftOLR(G1H4(174),18,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(16),mass5set(:,4),  & 
G1H4(210),G1H4(269),G1H4(216),G1H4(194),G1H4(12),G1H4(55),4)
  call HG1shiftOLR(G1H4(269),18,4)
  call Hotf_5pt_reduction(G2H4(109),RedSet_5(16),mass5set(:,6),  & 
G1H4(196),G1H4(24),G1H4(61),G1H4(201),G1H4(188),G1H4(274),4)
  call HG1shiftOLR(G1H4(24),18,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(18),mass5set(:,3),  & 
G1H4(48),G1H4(85),G1H4(190),G1H4(97),G1H4(206),G1H4(72),4)
  call HG1shiftOLR(G1H4(85),18,4)
  call Hotf_5pt_reduction(G2H4(113),RedSet_5(18),mass5set(:,5),  & 
G1H4(207),G1H4(208),G1H4(177),G1H4(178),G1H4(96),G1H4(182),4)
  call HG1shiftOLR(G1H4(208),18,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(18),mass5set(:,4),  & 
G1H4(151),G1H4(146),G1H4(157),G1H4(147),G1H4(148),G1H4(169),4)
  call HG1shiftOLR(G1H4(146),18,4)
  call Hotf_5pt_reduction(G2H4(117),RedSet_5(18),mass5set(:,6),  & 
G1H4(209),G1H4(58),G1H4(42),G1H4(79),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(58),18,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(13),mass5set(:,3),  & 
G1H4(152),G1H4(153),G1H4(154),G1H4(158),G1H4(171),G1H4(172),4)
  call HG1shiftOLR(G1H4(153),20,4)
  call Hotf_5pt_reduction(G2H4(121),RedSet_5(13),mass5set(:,5),  & 
G1H4(175),G1H4(130),G1H4(129),G1H4(187),G1H4(134),G1H4(193),4)
  call HG1shiftOLR(G1H4(130),20,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(13),mass5set(:,4),  & 
G1H4(160),G1H4(164),G1H4(214),G1H4(218),G1H4(3),G1H4(4),4)
  call HG1shiftOLR(G1H4(164),20,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(13),mass5set(:,6),  & 
G1H4(8),G1H4(9),G1H4(15),G1H4(16),G1H4(20),G1H4(21),4)
  call HG1shiftOLR(G1H4(9),20,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(11),mass5set(:,3),  & 
G1H4(27),G1H4(28),G1H4(111),G1H4(186),G1H4(112),G1H4(117),4)
  call HG1shiftOLR(G1H4(28),20,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(11),mass5set(:,4),  & 
G1H4(203),G1H4(205),G1H4(219),G1H4(220),G1H4(32),G1H4(33),4)
  call HG1shiftOLR(G1H4(205),20,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(11),mass5set(:,5),  & 
G1H4(40),G1H4(44),G1H4(46),G1H4(50),G1H4(62),G1H4(64),4)
  call HG1shiftOLR(G1H4(44),20,4)
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(11),mass5set(:,6),  & 
G1H4(68),G1H4(75),G1H4(76),G1H4(80),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(75),20,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(12),mass5set(:,3),  & 
G1H4(225),G1H4(226),G1H4(227),G1H4(228),G1H4(231),G1H4(232),4)
  call HG1shiftOLR(G1H4(226),24,4)
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(12),mass5set(:,5),  & 
G1H4(233),G1H4(234),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(234),24,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(12),mass5set(:,4),  & 
G1H4(243),G1H4(244),G1H4(245),G1H4(246),G1H4(249),G1H4(250),4)
  call HG1shiftOLR(G1H4(244),24,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(12),mass5set(:,6),  & 
G1H4(251),G1H4(252),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(252),24,4)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(14),mass5set(:,3),  & 
G1H4(261),G1H4(262),G1H4(263),G1H4(264),G1H4(267),G1H4(268),4)
  call HG1shiftOLR(G1H4(262),24,4)
  call Hotf_5pt_reduction(G2H4(119),RedSet_5(14),mass5set(:,4),  & 
G1H4(270),G1H4(273),G1H4(275),G1H4(278),G1H4(128),G1H4(138),4)
  call HG1shiftOLR(G1H4(273),24,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(14),mass5set(:,5),  & 
G1H4(168),G1H4(165),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(165),24,4)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(14),mass5set(:,6),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(284),24,4)
  call Hotf_5pt_reduction(G2H2(247),RedSet_5(107),mass5set(:,3),  & 
G1H2(210),G1H2(216),G1H2(222),G1H2(228),G1H2(1163),G1H2(1164),2)
  call HG1shiftOLR(G1H2(216),4,2)
  call Hotf_5pt_reduction(G2H2(248),RedSet_5(107),mass5set(:,16),  & 
G1H2(1165),G1H2(1166),G1H2(1167),G1H2(1168),G1H2(1169),G1H2(1170),2)
  call HG1shiftOLR(G1H2(1166),4,2)
  call Hotf_5pt_reduction(G2H2(249),RedSet_5(107),mass5set(:,5),  & 
G1H2(1171),G1H2(1172),G1H2(1173),G1H2(1174),G1H2(1175),G1H2(1176),2)
  call HG1shiftOLR(G1H2(1172),4,2)
  call Hotf_5pt_reduction(G2H2(250),RedSet_5(107),mass5set(:,17),  & 
G1H2(1177),G1H2(1178),G1H2(1179),G1H2(1180),G1H2(1181),G1H2(1182),2)
  call HG1shiftOLR(G1H2(1178),4,2)
  call Hotf_5pt_reduction(G2H2(251),RedSet_5(108),mass5set(:,3),  & 
G1H2(1183),G1H2(1184),G1H2(1185),G1H2(1186),G1H2(1187),G1H2(1188),2)
  call HG1shiftOLR(G1H2(1184),4,2)
  call Hotf_5pt_reduction(G2H2(252),RedSet_5(108),mass5set(:,5),  & 
G1H2(1189),G1H2(1190),G1H2(1191),G1H2(1192),G1H2(1193),G1H2(1194),2)
  call HG1shiftOLR(G1H2(1190),4,2)
  call Hotf_5pt_reduction(G2H2(253),RedSet_5(108),mass5set(:,16),  & 
G1H2(1195),G1H2(1196),G1H2(1197),G1H2(1198),G1H2(1199),G1H2(1200),2)
  call HG1shiftOLR(G1H2(1196),4,2)
  call Hotf_5pt_reduction(G2H2(254),RedSet_5(108),mass5set(:,17),  & 
G1H2(1201),G1H2(1202),G1H2(1203),G1H2(1204),G1H2(1205),G1H2(1206),2)
  call HG1shiftOLR(G1H2(1202),4,2)
  call Hotf_4pt_reduction(G2H2(257),RedSet_4(8),mass4set(:,1),  & 
G1H2(1207),G1H2(1208),G1H2(1209),G1H2(1210),G1H2(1211),2)
  call HG1shiftOLR(G1H2(1208),18,2)
  call Hotf_4pt_reduction(G2H2(260),RedSet_4(23),mass4set(:,1),  & 
G1H2(1212),G1H2(1213),G1H2(1214),G1H2(1215),G1H2(1216),2)
  call HG1shiftOLR(G1H2(1213),20,2)
  call Hotf_4pt_reduction(G2H2(263),RedSet_4(37),mass4set(:,1),  & 
G1H2(1217),G1H2(1218),G1H2(1219),G1H2(1220),G1H2(1221),2)
  call HG1shiftOLR(G1H2(1218),17,2)
  call Hotf_4pt_reduction(G2H2(266),RedSet_4(51),mass4set(:,1),  & 
G1H2(1222),G1H2(1223),G1H2(1224),G1H2(1225),G1H2(1226),2)
  call HG1shiftOLR(G1H2(1223),24,2)
  call Hotf_5pt_reduction(G2H2(267),RedSet_5(26),mass5set(:,3),  & 
G1H2(1227),G1H2(1228),G1H2(1229),G1H2(1230),G1H2(1231),G1H2(1232),2)
  call HG1shiftOLR(G1H2(1228),8,2)
  call Hotf_4pt_reduction(G2H2(269),RedSet_4(66),mass4set(:,3),  & 
G1H2(1233),G1H2(1234),G1H2(1235),G1H2(1236),G1H2(1237),2)
  call HG1shiftOLR(G1H2(1234),12,2)
  call Hotf_5pt_reduction(G2H2(270),RedSet_5(26),mass5set(:,5),  & 
G1H2(1238),G1H2(1239),G1H2(1240),G1H2(1241),G1H2(1242),G1H2(1243),2)
  call HG1shiftOLR(G1H2(1239),8,2)
  call Hotf_4pt_reduction(G2H2(272),RedSet_4(66),mass4set(:,3),  & 
G1H2(1244),G1H2(1245),G1H2(1246),G1H2(1247),G1H2(1248),2)
  call HG1shiftOLR(G1H2(1245),12,2)
  call Hotf_5pt_reduction(G2H2(273),RedSet_5(24),mass5set(:,3),  & 
G1H2(1249),G1H2(1250),G1H2(1251),G1H2(1252),G1H2(1253),G1H2(1254),2)
  call HG1shiftOLR(G1H2(1250),4,2)
  call Hotf_4pt_reduction(G2H2(275),RedSet_4(66),mass4set(:,3),  & 
G1H2(1255),G1H2(1256),G1H2(1257),G1H2(1258),G1H2(1259),2)
  call HG1shiftOLR(G1H2(1256),12,2)
  call Hotf_5pt_reduction(G2H2(276),RedSet_5(24),mass5set(:,5),  & 
G1H2(1260),G1H2(1261),G1H2(1262),G1H2(1263),G1H2(1264),G1H2(1265),2)
  call HG1shiftOLR(G1H2(1261),4,2)
  call Hotf_4pt_reduction(G2H2(278),RedSet_4(66),mass4set(:,3),  & 
G1H2(1266),G1H2(1267),G1H2(1268),G1H2(1269),G1H2(1270),2)
  call HG1shiftOLR(G1H2(1267),12,2)
  call Hotf_5pt_reduction(G2H2(279),RedSet_5(27),mass5set(:,9),  & 
G1H2(1271),G1H2(1272),G1H2(1273),G1H2(1274),G1H2(1275),G1H2(1276),2)
  call HG1shiftOLR(G1H2(1272),16,2)
  call Hotf_4pt_reduction(G2H2(281),RedSet_4(151),mass4set(:,4),  & 
G1H2(1277),G1H2(1278),G1H2(1279),G1H2(1280),G1H2(1281),2)
  call HG1shiftOLR(G1H2(1278),20,2)
  call Hotf_5pt_reduction(G2H2(282),RedSet_5(28),mass5set(:,9),  & 
G1H2(1282),G1H2(1283),G1H2(1284),G1H2(1285),G1H2(1286),G1H2(1287),2)
  call HG1shiftOLR(G1H2(1283),16,2)
  call Hotf_4pt_reduction(G2H2(284),RedSet_4(164),mass4set(:,4),  & 
G1H2(1288),G1H2(1289),G1H2(1290),G1H2(1291),G1H2(1292),2)
  call HG1shiftOLR(G1H2(1289),24,2)
  call Hotf_5pt_reduction(G2H2(285),RedSet_5(29),mass5set(:,9),  & 
G1H2(1293),G1H2(1294),G1H2(1295),G1H2(1296),G1H2(1297),G1H2(1298),2)
  call HG1shiftOLR(G1H2(1294),16,2)
  call Hotf_4pt_reduction(G2H2(287),RedSet_4(190),mass4set(:,4),  & 
G1H2(1299),G1H2(1300),G1H2(1301),G1H2(1302),G1H2(1303),2)
  call HG1shiftOLR(G1H2(1300),17,2)
  call Hotf_5pt_reduction(G2H2(288),RedSet_5(30),mass5set(:,9),  & 
G1H2(1304),G1H2(1305),G1H2(1306),G1H2(1307),G1H2(1308),G1H2(1309),2)
  call HG1shiftOLR(G1H2(1305),16,2)
  call Hotf_4pt_reduction(G2H2(290),RedSet_4(202),mass4set(:,4),  & 
G1H2(1310),G1H2(1311),G1H2(1312),G1H2(1313),G1H2(1314),2)
  call HG1shiftOLR(G1H2(1311),18,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(291),ex2(:),G2tensor(71),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(293),ex2(:),G2tensor(73),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(294),ex3(:),G2tensor(75),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(296),ex3(:),G2tensor(77),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(297),ex1(:),G2tensor(79),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(299),ex1(:),G2tensor(81),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(300),ex3(:),G2tensor(83),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(302),ex3(:),G2tensor(85),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(303),ex4(:),G2tensor(87),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(305),ex4(:),G2tensor(89),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(306),ex4(:),G2tensor(91),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(308),ex4(:),G2tensor(93),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(309),ex2(:),G2tensor(95),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(311),ex2(:),G2tensor(97),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(312),ex2(:),G2tensor(99),ngZl,m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(314),ex2(:),G2tensor(101),ngZl,m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(315),ex2(:),G2tensor(103),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(317),ex2(:),G2tensor(105),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(318),ex2(:),G2tensor(107),ngZl,m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(320),ex2(:),G2tensor(109),ngZl,m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(321),ex4(:),G2tensor(111),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(323),ex4(:),G2tensor(112),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(324),ex4(:),G2tensor(113),ngZl,m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(326),ex4(:),G2tensor(114),ngZl,m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(327),ex4(:),G2tensor(115),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(329),ex4(:),G2tensor(116),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(330),ex4(:),G2tensor(117),ngZl,m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(332),ex4(:),G2tensor(118),ngZl,m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(333),ex1(:),G2tensor(119),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(335),ex1(:),G2tensor(120),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(336),ex1(:),G2tensor(121),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(338),ex1(:),G2tensor(122),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(339),ex1(:),G2tensor(123),ngZl,m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(341),ex1(:),G2tensor(124),ngZl,m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(342),ex1(:),G2tensor(125),ngZl,m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(344),ex1(:),G2tensor(126),ngZl,m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(345),ex3(:),G2tensor(127),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(347),ex3(:),G2tensor(128),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(348),ex3(:),G2tensor(129),ngZl,m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(350),ex3(:),G2tensor(130),ngZl,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(351),ex3(:),G2tensor(131),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(353),ex3(:),G2tensor(132),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(354),ex3(:),G2tensor(133),ngZl,m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(356),ex3(:),G2tensor(134),ngZl,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(357),ex3(:),G2tensor(135),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(359),ex3(:),G2tensor(136),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(360),ex3(:),G2tensor(137),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(362),ex3(:),G2tensor(138),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(364),ex4(:),G2tensor(139),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(366),ex4(:),G2tensor(140),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(367),ex4(:),G2tensor(141),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(369),ex4(:),G2tensor(142),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hotf_5pt_reduction(G2H2(371),RedSet_5(22),mass5set(:,3),  & 
G1H2(1315),G1H2(1316),G1H2(1317),G1H2(1318),G1H2(1319),G1H2(1320),2)
  call HG1shiftOLR(G1H2(1316),16,2)
  call Hotf_4pt_reduction(G2H2(374),RedSet_4(23),mass4set(:,3),  & 
G1H2(1321),G1H2(1322),G1H2(1323),G1H2(1324),G1H2(1325),2)
  call HG1shiftOLR(G1H2(1322),20,2)
  call Hotf_5pt_reduction(G2H2(375),RedSet_5(22),mass5set(:,13),  & 
G1H2(1326),G1H2(1327),G1H2(1328),G1H2(1329),G1H2(1330),G1H2(1331),2)
  call HG1shiftOLR(G1H2(1327),16,2)
  call Hotf_4pt_reduction(G2H2(378),RedSet_4(23),mass4set(:,5),  & 
G1H2(1332),G1H2(1333),G1H2(1334),G1H2(1335),G1H2(1336),2)
  call HG1shiftOLR(G1H2(1333),20,2)
  call Hotf_5pt_reduction(G2H2(385),RedSet_5(43),mass5set(:,3),  & 
G1H2(1337),G1H2(1338),G1H2(1339),G1H2(1340),G1H2(1341),G1H2(1342),2)
  call HG1shiftOLR(G1H2(1338),16,2)
  call Hotf_4pt_reduction(G2H2(387),RedSet_4(13),mass4set(:,3),  & 
G1H2(1343),G1H2(1344),G1H2(1345),G1H2(1346),G1H2(1347),2)
  call HG1shiftOLR(G1H2(1344),19,2)
  call Hotf_5pt_reduction(G2H2(388),RedSet_5(43),mass5set(:,4),  & 
G1H2(1348),G1H2(1349),G1H2(1350),G1H2(1351),G1H2(1352),G1H2(1353),2)
  call HG1shiftOLR(G1H2(1349),16,2)
  call Hotf_4pt_reduction(G2H2(390),RedSet_4(13),mass4set(:,6),  & 
G1H2(1354),G1H2(1355),G1H2(1356),G1H2(1357),G1H2(1358),2)
  call HG1shiftOLR(G1H2(1355),19,2)
  call Hotf_4pt_reduction(G2H2(396),RedSet_4(13),mass4set(:,7),  & 
G1H2(1359),G1H2(1360),G1H2(1361),G1H2(1362),G1H2(1363),2)
  call HG1shiftOLR(G1H2(1360),19,2)
  call Hotf_5pt_reduction(G2H2(397),RedSet_5(25),mass5set(:,3),  & 
G1H2(1364),G1H2(1365),G1H2(1366),G1H2(1367),G1H2(1368),G1H2(1369),2)
  call HG1shiftOLR(G1H2(1365),16,2)
  call Hotf_4pt_reduction(G2H2(400),RedSet_4(51),mass4set(:,3),  & 
G1H2(1370),G1H2(1371),G1H2(1372),G1H2(1373),G1H2(1374),2)
  call HG1shiftOLR(G1H2(1371),24,2)
  call Hotf_5pt_reduction(G2H2(401),RedSet_5(25),mass5set(:,13),  & 
G1H2(1375),G1H2(1376),G1H2(1377),G1H2(1378),G1H2(1379),G1H2(1380),2)
  call HG1shiftOLR(G1H2(1376),16,2)
  call Hotf_4pt_reduction(G2H2(404),RedSet_4(51),mass4set(:,5),  & 
G1H2(1381),G1H2(1382),G1H2(1383),G1H2(1384),G1H2(1385),2)
  call HG1shiftOLR(G1H2(1382),24,2)
  call Hotf_5pt_reduction(G2H2(411),RedSet_5(44),mass5set(:,3),  & 
G1H2(1386),G1H2(1387),G1H2(1388),G1H2(1389),G1H2(1390),G1H2(1391),2)
  call HG1shiftOLR(G1H2(1387),16,2)
  call Hotf_4pt_reduction(G2H2(413),RedSet_4(42),mass4set(:,3),  & 
G1H2(1392),G1H2(1393),G1H2(1394),G1H2(1395),G1H2(1396),2)
  call HG1shiftOLR(G1H2(1393),19,2)
  call Hotf_5pt_reduction(G2H2(414),RedSet_5(44),mass5set(:,4),  & 
G1H2(1397),G1H2(1398),G1H2(1399),G1H2(1400),G1H2(1401),G1H2(1402),2)
  call HG1shiftOLR(G1H2(1398),16,2)
  call Hotf_4pt_reduction(G2H2(416),RedSet_4(42),mass4set(:,6),  & 
G1H2(1403),G1H2(1404),G1H2(1405),G1H2(1406),G1H2(1407),2)
  call HG1shiftOLR(G1H2(1404),19,2)
  call Hotf_4pt_reduction(G2H2(422),RedSet_4(42),mass4set(:,7),  & 
G1H2(1408),G1H2(1409),G1H2(1410),G1H2(1411),G1H2(1412),2)
  call HG1shiftOLR(G1H2(1409),19,2)
  call Hotf_5pt_reduction(G2H4(100),RedSet_5(4),mass5set(:,3),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
  call HG1shiftOLR(G1H4(290),12,4)
  call Hotf_4pt_reduction(G2H4(104),RedSet_4(28),mass4set(:,3),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),4)
  call HG1shiftOLR(G1H4(296),28,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(4),mass5set(:,4),  & 
G1H4(300),G1H4(301),G1H4(302),G1H4(303),G1H4(304),G1H4(305),4)
  call HG1shiftOLR(G1H4(301),12,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(28),mass4set(:,6),  & 
G1H4(306),G1H4(307),G1H4(308),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(307),28,4)
  call Hotf_5pt_reduction(G2H4(112),RedSet_5(4),mass5set(:,3),  & 
G1H4(311),G1H4(312),G1H4(313),G1H4(314),G1H4(315),G1H4(316),4)
  call HG1shiftOLR(G1H4(312),12,4)
  call Hotf_4pt_reduction(G2H4(116),RedSet_4(28),mass4set(:,3),  & 
G1H4(317),G1H4(318),G1H4(319),G1H4(320),G1H4(321),4)
  call HG1shiftOLR(G1H4(318),28,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(4),mass5set(:,4),  & 
G1H4(322),G1H4(323),G1H4(324),G1H4(325),G1H4(326),G1H4(327),4)
  call HG1shiftOLR(G1H4(323),12,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(28),mass4set(:,6),  & 
G1H4(328),G1H4(329),G1H4(330),G1H4(331),G1H4(332),4)
  call HG1shiftOLR(G1H4(329),28,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(4),mass5set(:,2),  & 
G1H4(333),G1H4(334),G1H4(335),G1H4(336),G1H4(337),G1H4(338),4)
  call HG1shiftOLR(G1H4(334),12,4)
  call Hotf_4pt_reduction(G2H4(148),RedSet_4(28),mass4set(:,7),  & 
G1H4(339),G1H4(340),G1H4(341),G1H4(342),G1H4(343),4)
  call HG1shiftOLR(G1H4(340),28,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(4),mass5set(:,2),  & 
G1H4(344),G1H4(345),G1H4(346),G1H4(347),G1H4(348),G1H4(349),4)
  call HG1shiftOLR(G1H4(345),12,4)
  call Hotf_4pt_reduction(G2H4(157),RedSet_4(28),mass4set(:,7),  & 
G1H4(350),G1H4(351),G1H4(352),G1H4(353),G1H4(354),4)
  call HG1shiftOLR(G1H4(351),28,4)
  call Hotf_5pt_reduction(G2H2(429),RedSet_5(23),mass5set(:,3),  & 
G1H2(1413),G1H2(1414),G1H2(1415),G1H2(1416),G1H2(1417),G1H2(1418),2)
  call HG1shiftOLR(G1H2(1414),16,2)
  call Hotf_4pt_reduction(G2H2(432),RedSet_4(37),mass4set(:,3),  & 
G1H2(1419),G1H2(1420),G1H2(1421),G1H2(1422),G1H2(1423),2)
  call HG1shiftOLR(G1H2(1420),17,2)
  call Hotf_5pt_reduction(G2H2(433),RedSet_5(23),mass5set(:,13),  & 
G1H2(1424),G1H2(1425),G1H2(1426),G1H2(1427),G1H2(1428),G1H2(1429),2)
  call HG1shiftOLR(G1H2(1425),16,2)
  call Hotf_4pt_reduction(G2H2(436),RedSet_4(37),mass4set(:,5),  & 
G1H2(1430),G1H2(1431),G1H2(1432),G1H2(1433),G1H2(1434),2)
  call HG1shiftOLR(G1H2(1431),17,2)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(6),mass5set(:,3),  & 
G1H4(355),G1H4(356),G1H4(357),G1H4(358),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(356),12,4)
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(56),mass4set(:,3),  & 
G1H4(361),G1H4(362),G1H4(363),G1H4(364),G1H4(365),4)
  call HG1shiftOLR(G1H4(362),28,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(6),mass5set(:,4),  & 
G1H4(366),G1H4(367),G1H4(368),G1H4(369),G1H4(370),G1H4(371),4)
  call HG1shiftOLR(G1H4(367),12,4)
  call Hotf_4pt_reduction(G2H4(48),RedSet_4(56),mass4set(:,6),  & 
G1H4(372),G1H4(373),G1H4(374),G1H4(375),G1H4(376),4)
  call HG1shiftOLR(G1H4(373),28,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(6),mass5set(:,3),  & 
G1H4(377),G1H4(378),G1H4(379),G1H4(380),G1H4(381),G1H4(382),4)
  call HG1shiftOLR(G1H4(378),12,4)
  call Hotf_4pt_reduction(G2H4(52),RedSet_4(56),mass4set(:,3),  & 
G1H4(383),G1H4(384),G1H4(385),G1H4(386),G1H4(387),4)
  call HG1shiftOLR(G1H4(384),28,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(6),mass5set(:,4),  & 
G1H4(388),G1H4(389),G1H4(390),G1H4(391),G1H4(392),G1H4(393),4)
  call HG1shiftOLR(G1H4(389),12,4)
  call Hotf_4pt_reduction(G2H4(58),RedSet_4(56),mass4set(:,6),  & 
G1H4(394),G1H4(395),G1H4(396),G1H4(397),G1H4(398),4)
  call HG1shiftOLR(G1H4(395),28,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(6),mass5set(:,2),  & 
G1H4(399),G1H4(400),G1H4(401),G1H4(402),G1H4(403),G1H4(404),4)
  call HG1shiftOLR(G1H4(400),12,4)
  call Hotf_4pt_reduction(G2H4(63),RedSet_4(56),mass4set(:,7),  & 
G1H4(405),G1H4(406),G1H4(407),G1H4(408),G1H4(409),4)
  call HG1shiftOLR(G1H4(406),28,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(6),mass5set(:,2),  & 
G1H4(410),G1H4(411),G1H4(412),G1H4(413),G1H4(414),G1H4(415),4)
  call HG1shiftOLR(G1H4(411),12,4)
  call Hotf_4pt_reduction(G2H4(70),RedSet_4(56),mass4set(:,7),  & 
G1H4(416),G1H4(417),G1H4(418),G1H4(419),G1H4(420),4)
  call HG1shiftOLR(G1H4(417),28,4)
  call Hotf_5pt_reduction(G2H2(449),RedSet_5(45),mass5set(:,3),  & 
G1H2(1435),G1H2(1436),G1H2(1437),G1H2(1438),G1H2(1439),G1H2(1440),2)
  call HG1shiftOLR(G1H2(1436),16,2)
  call Hotf_4pt_reduction(G2H2(451),RedSet_4(56),mass4set(:,3),  & 
G1H2(1441),G1H2(1442),G1H2(1443),G1H2(1444),G1H2(1445),2)
  call HG1shiftOLR(G1H2(1442),28,2)
  call Hotf_5pt_reduction(G2H2(452),RedSet_5(45),mass5set(:,4),  & 
G1H2(1446),G1H2(1447),G1H2(1448),G1H2(1449),G1H2(1450),G1H2(1451),2)
  call HG1shiftOLR(G1H2(1447),16,2)
  call Hotf_4pt_reduction(G2H2(454),RedSet_4(56),mass4set(:,6),  & 
G1H2(1452),G1H2(1453),G1H2(1454),G1H2(1455),G1H2(1456),2)
  call HG1shiftOLR(G1H2(1453),28,2)
  call Hotf_4pt_reduction(G2H2(460),RedSet_4(56),mass4set(:,7),  & 
G1H2(1457),G1H2(1458),G1H2(1459),G1H2(1460),G1H2(1461),2)
  call HG1shiftOLR(G1H2(1458),28,2)
  call Hotf_5pt_reduction(G2H2(461),RedSet_5(21),mass5set(:,3),  & 
G1H2(1462),G1H2(1463),G1H2(1464),G1H2(1465),G1H2(1466),G1H2(1467),2)
  call HG1shiftOLR(G1H2(1463),16,2)
  call Hotf_4pt_reduction(G2H2(464),RedSet_4(8),mass4set(:,3),  & 
G1H2(1468),G1H2(1469),G1H2(1470),G1H2(1471),G1H2(1472),2)
  call HG1shiftOLR(G1H2(1469),18,2)
  call Hotf_5pt_reduction(G2H2(465),RedSet_5(21),mass5set(:,13),  & 
G1H2(1473),G1H2(1474),G1H2(1475),G1H2(1476),G1H2(1477),G1H2(1478),2)
  call HG1shiftOLR(G1H2(1474),16,2)
  call Hotf_4pt_reduction(G2H2(468),RedSet_4(8),mass4set(:,5),  & 
G1H2(1479),G1H2(1480),G1H2(1481),G1H2(1482),G1H2(1483),2)
  call HG1shiftOLR(G1H2(1480),18,2)
  call Hotf_5pt_reduction(G2H2(475),RedSet_5(46),mass5set(:,3),  & 
G1H2(1484),G1H2(1485),G1H2(1486),G1H2(1487),G1H2(1488),G1H2(1489),2)
  call HG1shiftOLR(G1H2(1485),16,2)
  call Hotf_4pt_reduction(G2H2(477),RedSet_4(28),mass4set(:,3),  & 
G1H2(1490),G1H2(1491),G1H2(1492),G1H2(1493),G1H2(1494),2)
  call HG1shiftOLR(G1H2(1491),28,2)
  call Hotf_5pt_reduction(G2H2(478),RedSet_5(46),mass5set(:,4),  & 
G1H2(1495),G1H2(1496),G1H2(1497),G1H2(1498),G1H2(1499),G1H2(1500),2)
  call HG1shiftOLR(G1H2(1496),16,2)
  call Hotf_4pt_reduction(G2H2(480),RedSet_4(28),mass4set(:,6),  & 
G1H2(1501),G1H2(1502),G1H2(1503),G1H2(1504),G1H2(1505),2)
  call HG1shiftOLR(G1H2(1502),28,2)
  call Hotf_4pt_reduction(G2H2(486),RedSet_4(28),mass4set(:,7),  & 
G1H2(1506),G1H2(1507),G1H2(1508),G1H2(1509),G1H2(1510),2)
  call HG1shiftOLR(G1H2(1507),28,2)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(99),wf4(:,14),G2tensor(143),m3h4x1(:,13),heltab2x4(:,:,509))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(103),wf4(:,14),G2tensor(144),m3h4x1(:,14),heltab2x4(:,:,510))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(106),wf4(:,20),G2tensor(145),m3h4x1(:,15),heltab2x4(:,:,511))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(110),wf4(:,20),G2tensor(146),m3h4x1(:,16),heltab2x4(:,:,512))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(111),wf4(:,4),G2tensor(147),m3h4x1(:,17),heltab2x4(:,:,513))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(115),wf4(:,4),G2tensor(148),m3h4x1(:,18),heltab2x4(:,:,514))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(118),wf4(:,10),G2tensor(149),m3h4x1(:,19),heltab2x4(:,:,515))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(18),wf4(:,10),G2tensor(150),m3h4x1(:,20),heltab2x4(:,:,516))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(493),ex4(:),G2tensor(151),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(495),ex4(:),G2tensor(152),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(496),ex4(:),G2tensor(153),ngZl,m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(498),ex4(:),G2tensor(154),ngZl,m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(499),ex4(:),G2tensor(155),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(501),ex4(:),G2tensor(156),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(502),ex4(:),G2tensor(157),ngZl,m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(504),ex4(:),G2tensor(158),ngZl,m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(505),ex3(:),G2tensor(159),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(507),ex3(:),G2tensor(160),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(508),ex3(:),G2tensor(161),ngZl,m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(510),ex3(:),G2tensor(162),ngZl,m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(511),ex3(:),G2tensor(163),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(513),ex3(:),G2tensor(164),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(514),ex3(:),G2tensor(165),ngZl,m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(516),ex3(:),G2tensor(166),ngZl,m3h2x1(:,204),heltab2x2(:,:,204))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1359),[G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1506),[G1H2(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1408),[G1H2(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1457),[G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1207),[G1H2(478)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1212),[G1H2(496)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1217),[G1H2(514)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1222),[G1H2(532)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1233),[G1H2(1232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1244),[G1H2(1243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1255),[G1H2(1254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1266),[G1H2(1265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1277),[G1H2(1276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1288),[G1H2(1287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1299),[G1H2(1298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1310),[G1H2(1309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1321),[G1H2(1320)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1332),[G1H2(1331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1343),[G1H2(1342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1354),[G1H2(1353)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1370),[G1H2(1369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1381),[G1H2(1380)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1392),[G1H2(1391)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1403),[G1H2(1402)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(295),[G1H4(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(306),[G1H4(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(317),[G1H4(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(328),[G1H4(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(339),[G1H4(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(350),[G1H4(349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1419),[G1H2(1418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1430),[G1H2(1429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(361),[G1H4(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(372),[G1H4(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(383),[G1H4(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(394),[G1H4(393)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(405),[G1H4(404)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(416),[G1H4(415)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1441),[G1H2(1440)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1452),[G1H2(1451)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1468),[G1H2(1467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1479),[G1H2(1478)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1490),[G1H2(1489)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1501),[G1H2(1500)])
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(168),47,ex5(:),16,G2tensor(167),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(173),0,ex5(:),16,G2tensor(168),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1359),47,ex5(:),16,G2tensor(169),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(192),47,ex5(:),16,G2tensor(170),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(197),0,ex5(:),16,G2tensor(171),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1506),47,ex5(:),16,G2tensor(172),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(251),47,ex5(:),16,G2tensor(173),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(252),0,ex5(:),16,G2tensor(174),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1408),47,ex5(:),16,G2tensor(175),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(281),47,ex5(:),16,G2tensor(176),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(287),0,ex5(:),16,G2tensor(177),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1457),47,ex5(:),16,G2tensor(178),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hloop_VA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(179),n2h1(107))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(180),n2h1(108))
  call Hloop_VA_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(181),n2h1(109))
  call Hloop_ZA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),ngZl,m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(182),n2h1(110))
  call Hloop_ZA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),ngZl,m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(183),n2h1(111))
  call Hloop_ZA_Q(ntryL,G1H2(65),ex4(:),G1H1(1),ngZl,m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(184),n2h1(112))
  call Hloop_VA_Q(ntryL,G1H2(71),ex4(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(185),n2h1(113))
  call Hloop_VA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(186),n2h1(114))
  call Hloop_VA_Q(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(187),n2h1(115))
  call Hloop_ZA_Q(ntryL,G1H2(101),ex4(:),G1H1(1),ngZl,m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(188),n2h1(116))
  call Hloop_ZA_Q(ntryL,G1H2(107),ex4(:),G1H1(1),ngZl,m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(189),n2h1(117))
  call Hloop_ZA_Q(ntryL,G1H2(131),ex4(:),G1H1(1),ngZl,m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(190),n2h1(118))
  call Hloop_VA_Q(ntryL,G1H2(132),ex2(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(191),n2h1(119))
  call Hloop_VA_Q(ntryL,G1H2(137),ex2(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(192),n2h1(120))
  call Hloop_VA_Q(ntryL,G1H2(167),ex2(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(193),n2h1(121))
  call Hloop_ZA_Q(ntryL,G1H2(10),ex2(:),G1H1(1),ngZl,m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(194),n2h1(122))
  call Hloop_ZA_Q(ntryL,G1H2(16),ex2(:),G1H1(1),ngZl,m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(195),n2h1(123))
  call Hloop_ZA_Q(ntryL,G1H2(40),ex2(:),G1H1(1),ngZl,m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(196),n2h1(124))
  call Hloop_VA_Q(ntryL,G1H2(46),ex2(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(197),n2h1(125))
  call Hloop_VA_Q(ntryL,G1H2(52),ex2(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(198),n2h1(126))
  call Hloop_VA_Q(ntryL,G1H2(76),ex2(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(199),n2h1(127))
  call Hloop_ZA_Q(ntryL,G1H2(82),ex2(:),G1H1(1),ngZl,m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(200),n2h1(128))
  call Hloop_ZA_Q(ntryL,G1H2(88),ex2(:),G1H1(1),ngZl,m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(201),n2h1(129))
  call Hloop_ZA_Q(ntryL,G1H2(112),ex2(:),G1H1(1),ngZl,m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(202),n2h1(130))
  call Hloop_VA_Q(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(203),n2h1(131))
  call Hloop_VA_Q(ntryL,G1H2(124),ex4(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(204),n2h1(132))
  call Hloop_VA_Q(ntryL,G1H2(136),ex4(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(205),n2h1(133))
  call Hloop_VA_Q(ntryL,G1H2(160),ex4(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(206),n2h1(134))
  call Hloop_VA_Q(ntryL,G1H2(154),ex4(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(207),n2h1(135))
  call Hloop_VA_Q(ntryL,G1H2(178),ex4(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(208),n2h1(136))
  call Hloop_ZA_Q(ntryL,G1H2(196),ex4(:),G1H1(1),ngZl,m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(209),n2h1(137))
  call Hloop_ZA_Q(ntryL,G1H2(190),ex4(:),G1H1(1),ngZl,m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(210),n2h1(138))
  call Hloop_ZA_Q(ntryL,G1H2(208),ex4(:),G1H1(1),ngZl,m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(211),n2h1(139))
  call Hloop_ZA_Q(ntryL,G1H2(238),ex4(:),G1H1(1),ngZl,m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(212),n2h1(140))
  call Hloop_ZA_Q(ntryL,G1H2(226),ex4(:),G1H1(1),ngZl,m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(213),n2h1(141))
  call Hloop_ZA_Q(ntryL,G1H2(250),ex4(:),G1H1(1),ngZl,m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(214),n2h1(142))
  call Hloop_VA_Q(ntryL,G1H2(268),ex2(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(215),n2h1(143))
  call Hloop_VA_Q(ntryL,G1H2(262),ex2(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(216),n2h1(144))
  call Hloop_VA_Q(ntryL,G1H2(280),ex2(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(217),n2h1(145))
  call Hloop_ZA_Q(ntryL,G1H2(304),ex2(:),G1H1(1),ngZl,m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(218),n2h1(146))
  call Hloop_ZA_Q(ntryL,G1H2(298),ex2(:),G1H1(1),ngZl,m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(219),n2h1(147))
  call Hloop_ZA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),ngZl,m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(220),n2h1(148))
  call Hloop_VA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(221),n2h1(149))
  call Hloop_VA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(222),n2h1(150))
  call Hloop_VA_Q(ntryL,G1H2(15),ex2(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(223),n2h1(151))
  call Hloop_ZA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),ngZl,m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(224),n2h1(152))
  call Hloop_ZA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),ngZl,m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(225),n2h1(153))
  call Hloop_ZA_Q(ntryL,G1H2(27),ex2(:),G1H1(1),ngZl,m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(226),n2h1(154))
  call Hloop_VQ_A(ntryL,G1H2(31),ex3(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(227),n2h1(155))
  call Hloop_VQ_A(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(228),n2h1(156))
  call Hloop_VQ_A(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(229),n2h1(157))
  call Hloop_QV_A(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(230),n2h1(158))
  call Hloop_QV_A(ntryL,G1H2(39),ex5(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(231),n2h1(159))
  call Hloop_QV_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(232),n2h1(160))
  call Hloop_VQ_A(ntryL,G1H2(55),ex3(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(233),n2h1(161))
  call Hloop_VQ_A(ntryL,G1H2(68),ex3(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(234),n2h1(162))
  call Hloop_VQ_A(ntryL,G1H2(74),ex3(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(235),n2h1(163))
  call Hloop_QV_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(236),n2h1(164))
  call Hloop_QV_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(237),n2h1(165))
  call Hloop_QV_A(ntryL,G1H2(75),ex5(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(238),n2h1(166))
  call Hloop_ZQ_A(ntryL,G1H2(79),ex3(:),G1H1(1),ngZl,m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(239),n2h1(167))
  call Hloop_ZQ_A(ntryL,G1H2(86),ex3(:),G1H1(1),ngZl,m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(240),n2h1(168))
  call Hloop_ZQ_A(ntryL,G1H2(87),ex3(:),G1H1(1),ngZl,m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(241),n2h1(169))
  call Hloop_ZQ_A(ntryL,G1H2(91),ex3(:),G1H1(1),ngZl,m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(242),n2h1(170))
  call Hloop_ZQ_A(ntryL,G1H2(98),ex3(:),G1H1(1),ngZl,m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(243),n2h1(171))
  call Hloop_ZQ_A(ntryL,G1H2(99),ex3(:),G1H1(1),ngZl,m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(244),n2h1(172))
  call Hloop_VA_Q(ntryL,G1H2(103),ex4(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(245),n2h1(173))
  call Hloop_VA_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(246),n2h1(174))
  call Hloop_VA_Q(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(247),n2h1(175))
  call Hloop_AV_Q(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(248),n2h1(176))
  call Hloop_AV_Q(ntryL,G1H2(111),ex5(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(249),n2h1(177))
  call Hloop_AV_Q(ntryL,G1H2(123),ex5(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(250),n2h1(178))
  call Hloop_ZA_Q(ntryL,G1H2(127),ex4(:),G1H1(1),ngZl,m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(251),n2h1(179))
  call Hloop_ZA_Q(ntryL,G1H2(134),ex4(:),G1H1(1),ngZl,m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(252),n2h1(180))
  call Hloop_ZA_Q(ntryL,G1H2(133),ex4(:),G1H1(1),ngZl,m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(253),n2h1(181))
  call Hloop_VA_Q(ntryL,G1H2(189),ex4(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(254),n2h1(182))
  call Hloop_VA_Q(ntryL,G1H2(135),ex4(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(255),n2h1(183))
  call Hloop_VA_Q(ntryL,G1H2(183),ex4(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(256),n2h1(184))
  call Hloop_AV_Q(ntryL,G1H2(141),ex5(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(257),n2h1(185))
  call Hloop_AV_Q(ntryL,G1H2(145),ex5(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(258),n2h1(186))
  call Hloop_AV_Q(ntryL,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(259),n2h1(187))
  call Hloop_ZA_Q(ntryL,G1H2(152),ex4(:),G1H1(1),ngZl,m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(260),n2h1(188))
  call Hloop_ZA_Q(ntryL,G1H2(201),ex4(:),G1H1(1),ngZl,m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(261),n2h1(189))
  call Hloop_ZA_Q(ntryL,G1H2(158),ex4(:),G1H1(1),ngZl,m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(262),n2h1(190))
  call Hloop_VQ_A(ntryL,G1H2(213),ex3(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(263),n2h1(191))
  call Hloop_VQ_A(ntryL,G1H2(159),ex3(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(264),n2h1(192))
  call Hloop_VQ_A(ntryL,G1H2(169),ex3(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(265),n2h1(193))
  call Hloop_QV_A(ntryL,G1H2(219),ex5(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(266),n2h1(194))
  call Hloop_QV_A(ntryL,G1H2(171),ex5(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(267),n2h1(195))
  call Hloop_QV_A(ntryL,G1H2(181),ex5(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(268),n2h1(196))
  call Hloop_ZQ_A(ntryL,G1H2(194),ex3(:),G1H1(1),ngZl,m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(269),n2h1(197))
  call Hloop_ZQ_A(ntryL,G1H2(182),ex3(:),G1H1(1),ngZl,m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(270),n2h1(198))
  call Hloop_ZQ_A(ntryL,G1H2(206),ex3(:),G1H1(1),ngZl,m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(271),n2h1(199))
  call Hloop_VQ_A(ntryL,G1H2(200),ex3(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(272),n2h1(200))
  call Hloop_VQ_A(ntryL,G1H2(205),ex3(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(273),n2h1(201))
  call Hloop_VQ_A(ntryL,G1H2(217),ex3(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(274),n2h1(202))
  call Hloop_QV_A(ntryL,G1H2(223),ex5(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(275),n2h1(203))
  call Hloop_QV_A(ntryL,G1H2(230),ex5(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(276),n2h1(204))
  call Hloop_QV_A(ntryL,G1H2(229),ex5(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(277),n2h1(205))
  call Hloop_ZQ_A(ntryL,G1H2(279),ex3(:),G1H1(1),ngZl,m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(278),n2h1(206))
  call Hloop_ZQ_A(ntryL,G1H2(231),ex3(:),G1H1(1),ngZl,m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(279),n2h1(207))
  call Hloop_ZQ_A(ntryL,G1H2(285),ex3(:),G1H1(1),ngZl,m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(280),n2h1(208))
  call Hloop_VA_Q(ntryL,G1H2(237),ex4(:),G1H1(1),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(281),n2h1(209))
  call Hloop_VA_Q(ntryL,G1H2(241),ex4(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(282),n2h1(210))
  call Hloop_VA_Q(ntryL,G1H2(260),ex4(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(283),n2h1(211))
  call Hloop_AV_Q(ntryL,G1H2(248),ex5(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(284),n2h1(212))
  call Hloop_AV_Q(ntryL,G1H2(297),ex5(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(285),n2h1(213))
  call Hloop_AV_Q(ntryL,G1H2(254),ex5(:),G1H1(1),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(286),n2h1(214))
  call Hloop_VA_Q(ntryL,G1H2(303),ex4(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(287),n2h1(215))
  call Hloop_VA_Q(ntryL,G1H2(255),ex4(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(288),n2h1(216))
  call Hloop_VA_Q(ntryL,G1H2(265),ex4(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(289),n2h1(217))
  call Hloop_AV_Q(ntryL,G1H2(315),ex5(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(290),n2h1(218))
  call Hloop_AV_Q(ntryL,G1H2(267),ex5(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(291),n2h1(219))
  call Hloop_AV_Q(ntryL,G1H2(277),ex5(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(292),n2h1(220))
  call Hloop_ZA_Q(ntryL,G1H2(283),ex4(:),G1H1(1),ngZl,m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(293),n2h1(221))
  call Hloop_ZA_Q(ntryL,G1H2(290),ex4(:),G1H1(1),ngZl,m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(294),n2h1(222))
  call Hloop_ZA_Q(ntryL,G1H2(308),ex4(:),G1H1(1),ngZl,m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(295),n2h1(223))
  call Hloop_ZA_Q(ntryL,G1H2(296),ex4(:),G1H1(1),ngZl,m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(296),n2h1(224))
  call Hloop_ZA_Q(ntryL,G1H2(301),ex4(:),G1H1(1),ngZl,m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(297),n2h1(225))
  call Hloop_ZA_Q(ntryL,G1H2(313),ex4(:),G1H1(1),ngZl,m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(298),n2h1(226))
  call Hloop_VQ_A(ntryL,G1H2(209),ex1(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(299),n2h1(227))
  call Hloop_VQ_A(ntryL,G1H2(215),ex1(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(300),n2h1(228))
  call Hloop_VQ_A(ntryL,G1H2(318),ex1(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(301),n2h1(229))
  call Hloop_QV_A(ntryL,G1H2(319),ex5(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(302),n2h1(230))
  call Hloop_QV_A(ntryL,G1H2(320),ex5(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(303),n2h1(231))
  call Hloop_QV_A(ntryL,G1H2(324),ex5(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(304),n2h1(232))
  call Hloop_VQ_A(ntryL,G1H2(325),ex1(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(305),n2h1(233))
  call Hloop_VQ_A(ntryL,G1H2(326),ex1(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(306),n2h1(234))
  call Hloop_VQ_A(ntryL,G1H2(330),ex1(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(307),n2h1(235))
  call Hloop_QV_A(ntryL,G1H2(331),ex5(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(308),n2h1(236))
  call Hloop_QV_A(ntryL,G1H2(332),ex5(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(309),n2h1(237))
  call Hloop_QV_A(ntryL,G1H2(336),ex5(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(310),n2h1(238))
  call Hloop_ZQ_A(ntryL,G1H2(337),ex1(:),G1H1(1),ngZl,m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(311),n2h1(239))
  call Hloop_ZQ_A(ntryL,G1H2(338),ex1(:),G1H1(1),ngZl,m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(312),n2h1(240))
  call Hloop_ZQ_A(ntryL,G1H2(342),ex1(:),G1H1(1),ngZl,m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(313),n2h1(241))
  call Hloop_ZQ_A(ntryL,G1H2(343),ex1(:),G1H1(1),ngZl,m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(314),n2h1(242))
  call Hloop_ZQ_A(ntryL,G1H2(344),ex1(:),G1H1(1),ngZl,m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(315),n2h1(243))
  call Hloop_ZQ_A(ntryL,G1H2(348),ex1(:),G1H1(1),ngZl,m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(316),n2h1(244))
  call Hloop_VA_Q(ntryL,G1H2(349),ex2(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(317),n2h1(245))
  call Hloop_VA_Q(ntryL,G1H2(350),ex2(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(318),n2h1(246))
  call Hloop_VA_Q(ntryL,G1H2(354),ex2(:),G1H1(1),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(319),n2h1(247))
  call Hloop_AV_Q(ntryL,G1H2(355),ex5(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(320),n2h1(248))
  call Hloop_AV_Q(ntryL,G1H2(356),ex5(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(321),n2h1(249))
  call Hloop_AV_Q(ntryL,G1H2(360),ex5(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(322),n2h1(250))
  call Hloop_ZA_Q(ntryL,G1H2(361),ex2(:),G1H1(1),ngZl,m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(323),n2h1(251))
  call Hloop_ZA_Q(ntryL,G1H2(362),ex2(:),G1H1(1),ngZl,m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(324),n2h1(252))
  call Hloop_ZA_Q(ntryL,G1H2(366),ex2(:),G1H1(1),ngZl,m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(325),n2h1(253))
  call Hloop_VA_Q(ntryL,G1H2(367),ex2(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(326),n2h1(254))
  call Hloop_VA_Q(ntryL,G1H2(368),ex2(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(327),n2h1(255))
  call Hloop_VA_Q(ntryL,G1H2(372),ex2(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(328),n2h1(256))
  call Hloop_AV_Q(ntryL,G1H2(373),ex5(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(329),n2h1(257))
  call Hloop_AV_Q(ntryL,G1H2(374),ex5(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(330),n2h1(258))
  call Hloop_AV_Q(ntryL,G1H2(378),ex5(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(331),n2h1(259))
  call Hloop_ZA_Q(ntryL,G1H2(379),ex2(:),G1H1(1),ngZl,m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(332),n2h1(260))
  call Hloop_ZA_Q(ntryL,G1H2(380),ex2(:),G1H1(1),ngZl,m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(333),n2h1(261))
  call Hloop_ZA_Q(ntryL,G1H2(384),ex2(:),G1H1(1),ngZl,m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(334),n2h1(262))
  call Hloop_VQ_A(ntryL,G1H2(385),ex1(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(335),n2h1(263))
  call Hloop_VQ_A(ntryL,G1H2(386),ex1(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(336),n2h1(264))
  call Hloop_VQ_A(ntryL,G1H2(390),ex1(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(337),n2h1(265))
  call Hloop_QV_A(ntryL,G1H2(391),ex5(:),G1H1(1),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(338),n2h1(266))
  call Hloop_QV_A(ntryL,G1H2(392),ex5(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(339),n2h1(267))
  call Hloop_QV_A(ntryL,G1H2(396),ex5(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(340),n2h1(268))
  call Hloop_VQ_A(ntryL,G1H2(397),ex1(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(341),n2h1(269))
  call Hloop_VQ_A(ntryL,G1H2(398),ex1(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(342),n2h1(270))
  call Hloop_VQ_A(ntryL,G1H2(402),ex1(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(343),n2h1(271))
  call Hloop_QV_A(ntryL,G1H2(403),ex5(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(344),n2h1(272))
  call Hloop_QV_A(ntryL,G1H2(404),ex5(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(345),n2h1(273))
  call Hloop_QV_A(ntryL,G1H2(408),ex5(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(346),n2h1(274))
  call Hloop_ZQ_A(ntryL,G1H2(409),ex1(:),G1H1(1),ngZl,m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(347),n2h1(275))
  call Hloop_ZQ_A(ntryL,G1H2(410),ex1(:),G1H1(1),ngZl,m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(348),n2h1(276))
  call Hloop_ZQ_A(ntryL,G1H2(414),ex1(:),G1H1(1),ngZl,m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(349),n2h1(277))
  call Hloop_ZQ_A(ntryL,G1H2(415),ex1(:),G1H1(1),ngZl,m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(350),n2h1(278))
  call Hloop_ZQ_A(ntryL,G1H2(416),ex1(:),G1H1(1),ngZl,m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(351),n2h1(279))
  call Hloop_ZQ_A(ntryL,G1H2(420),ex1(:),G1H1(1),ngZl,m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(352),n2h1(280))
  call Hloop_VA_Q(ntryL,G1H2(421),ex2(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(353),n2h1(281))
  call Hloop_VA_Q(ntryL,G1H2(422),ex2(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(354),n2h1(282))
  call Hloop_VA_Q(ntryL,G1H2(426),ex2(:),G1H1(1),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(355),n2h1(283))
  call Hloop_AV_Q(ntryL,G1H2(427),ex5(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(356),n2h1(284))
  call Hloop_AV_Q(ntryL,G1H2(428),ex5(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(357),n2h1(285))
  call Hloop_AV_Q(ntryL,G1H2(432),ex5(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(358),n2h1(286))
  call Hloop_ZA_Q(ntryL,G1H2(433),ex2(:),G1H1(1),ngZl,m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(359),n2h1(287))
  call Hloop_ZA_Q(ntryL,G1H2(434),ex2(:),G1H1(1),ngZl,m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(360),n2h1(288))
  call Hloop_ZA_Q(ntryL,G1H2(438),ex2(:),G1H1(1),ngZl,m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(361),n2h1(289))
  call Hloop_VA_Q(ntryL,G1H2(439),ex2(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(362),n2h1(290))
  call Hloop_VA_Q(ntryL,G1H2(440),ex2(:),G1H1(1),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(363),n2h1(291))
  call Hloop_VA_Q(ntryL,G1H2(444),ex2(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(364),n2h1(292))
  call Hloop_AV_Q(ntryL,G1H2(445),ex5(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(365),n2h1(293))
  call Hloop_AV_Q(ntryL,G1H2(446),ex5(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(366),n2h1(294))
  call Hloop_AV_Q(ntryL,G1H2(450),ex5(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(367),n2h1(295))
  call Hloop_ZA_Q(ntryL,G1H2(451),ex2(:),G1H1(1),ngZl,m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(368),n2h1(296))
  call Hloop_ZA_Q(ntryL,G1H2(452),ex2(:),G1H1(1),ngZl,m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(369),n2h1(297))
  call Hloop_ZA_Q(ntryL,G1H2(456),ex2(:),G1H1(1),ngZl,m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(370),n2h1(298))
  call Hloop_WA_Q(ntryL,G1H2(457),ex4(:),G1H1(1),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(371),n2h1(299))
  call Hloop_WA_Q(ntryL,G1H2(458),ex4(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(372),n2h1(300))
  call Hloop_WA_Q(ntryL,G1H2(462),ex4(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(373),n2h1(301))
  call Hloop_WQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(374),n2h1(302))
  call Hloop_WQ_A(ntryL,G1H2(463),ex3(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(375),n2h1(303))
  call Hloop_WQ_A(ntryL,G1H2(467),ex3(:),G1H1(1),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(376),n2h1(304))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(4),47,ex5(:),16,G2tensor(377),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(468),0,ex5(:),16,G2tensor(378),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(472),47,ex5(:),16,G2tensor(379),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(473),47,ex5(:),16,G2tensor(380),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(474),0,ex5(:),16,G2tensor(381),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1207),47,ex5(:),16,G2tensor(382),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(479),47,ex5(:),16,G2tensor(383),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(480),0,ex5(:),16,G2tensor(384),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(484),47,ex5(:),16,G2tensor(385),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(485),47,ex5(:),16,G2tensor(386),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(486),0,ex5(:),16,G2tensor(387),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(490),47,ex5(:),16,G2tensor(388),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(491),47,ex5(:),16,G2tensor(389),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(492),0,ex5(:),16,G2tensor(390),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1212),47,ex5(:),16,G2tensor(391),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(497),47,ex5(:),16,G2tensor(392),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(498),0,ex5(:),16,G2tensor(393),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(502),47,ex5(:),16,G2tensor(394),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(503),47,ex5(:),16,G2tensor(395),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(504),0,ex5(:),16,G2tensor(396),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(508),47,ex5(:),16,G2tensor(397),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(509),47,ex5(:),16,G2tensor(398),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(510),0,ex5(:),16,G2tensor(399),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1217),47,ex5(:),16,G2tensor(400),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(515),47,ex5(:),16,G2tensor(401),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(516),0,ex5(:),16,G2tensor(402),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(520),47,ex5(:),16,G2tensor(403),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(521),47,ex5(:),16,G2tensor(404),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(522),0,ex5(:),16,G2tensor(405),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(526),47,ex5(:),16,G2tensor(406),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(527),47,ex5(:),16,G2tensor(407),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(528),0,ex5(:),16,G2tensor(408),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1222),47,ex5(:),16,G2tensor(409),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(533),47,ex5(:),16,G2tensor(410),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(534),0,ex5(:),16,G2tensor(411),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(538),47,ex5(:),16,G2tensor(412),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hloop_VA_Q(ntryL,G1H2(539),ex4(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(413),n2h1(317))
  call Hloop_VA_Q(ntryL,G1H2(540),ex4(:),G1H1(1),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(414),n2h1(318))
  call Hloop_VA_Q(ntryL,G1H2(544),ex4(:),G1H1(1),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(415),n2h1(319))
  call Hloop_VA_Q(ntryL,G1H2(545),ex4(:),G1H1(1),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(416),n2h1(320))
  call Hloop_VA_Q(ntryL,G1H2(546),ex4(:),G1H1(1),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(417),n2h1(321))
  call Hloop_VA_Q(ntryL,G1H2(550),ex4(:),G1H1(1),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(418),n2h1(322))
  call Hloop_VA_Q(ntryL,G1H2(551),ex4(:),G1H1(1),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(419),n2h1(323))
  call Hloop_VA_Q(ntryL,G1H2(552),ex4(:),G1H1(1),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(420),n2h1(324))
  call Hloop_VA_Q(ntryL,G1H2(556),ex4(:),G1H1(1),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(421),n2h1(325))
  call Hloop_ZA_Q(ntryL,G1H2(557),ex4(:),G1H1(1),ngZl,m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(422),n2h1(326))
  call Hloop_ZA_Q(ntryL,G1H2(558),ex4(:),G1H1(1),ngZl,m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(423),n2h1(327))
  call Hloop_ZA_Q(ntryL,G1H2(562),ex4(:),G1H1(1),ngZl,m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(424),n2h1(328))
  call Hloop_ZA_Q(ntryL,G1H2(563),ex4(:),G1H1(1),ngZl,m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(425),n2h1(329))
  call Hloop_ZA_Q(ntryL,G1H2(564),ex4(:),G1H1(1),ngZl,m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(426),n2h1(330))
  call Hloop_ZA_Q(ntryL,G1H2(568),ex4(:),G1H1(1),ngZl,m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(427),n2h1(331))
  call Hloop_ZA_Q(ntryL,G1H2(569),ex4(:),G1H1(1),ngZl,m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(428),n2h1(332))
  call Hloop_ZA_Q(ntryL,G1H2(570),ex4(:),G1H1(1),ngZl,m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(429),n2h1(333))
  call Hloop_ZA_Q(ntryL,G1H2(574),ex4(:),G1H1(1),ngZl,m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(430),n2h1(334))
  call Hloop_VA_Q(ntryL,G1H2(575),ex4(:),G1H1(1),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(431),n2h1(335))
  call Hloop_VA_Q(ntryL,G1H2(576),ex4(:),G1H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(432),n2h1(336))
  call Hloop_VA_Q(ntryL,G1H2(580),ex4(:),G1H1(1),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(433),n2h1(337))
  call Hloop_VA_Q(ntryL,G1H2(581),ex4(:),G1H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(434),n2h1(338))
  call Hloop_VA_Q(ntryL,G1H2(582),ex4(:),G1H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(435),n2h1(339))
  call Hloop_VA_Q(ntryL,G1H2(586),ex4(:),G1H1(1),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(436),n2h1(340))
  call Hloop_ZA_Q(ntryL,G1H2(587),ex4(:),G1H1(1),ngZl,m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(437),n2h1(341))
  call Hloop_ZA_Q(ntryL,G1H2(588),ex4(:),G1H1(1),ngZl,m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(438),n2h1(342))
  call Hloop_ZA_Q(ntryL,G1H2(592),ex4(:),G1H1(1),ngZl,m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(439),n2h1(343))
  call Hloop_ZA_Q(ntryL,G1H2(593),ex4(:),G1H1(1),ngZl,m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(440),n2h1(344))
  call Hloop_ZA_Q(ntryL,G1H2(594),ex4(:),G1H1(1),ngZl,m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(441),n2h1(345))
  call Hloop_ZA_Q(ntryL,G1H2(598),ex4(:),G1H1(1),ngZl,m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(442),n2h1(346))
  call Hloop_VA_Q(ntryL,G1H2(599),ex2(:),G1H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(443),n2h1(347))
  call Hloop_VA_Q(ntryL,G1H2(600),ex2(:),G1H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(444),n2h1(348))
  call Hloop_VA_Q(ntryL,G1H2(604),ex2(:),G1H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(445),n2h1(349))
  call Hloop_VA_Q(ntryL,G1H2(605),ex2(:),G1H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(446),n2h1(350))
  call Hloop_VA_Q(ntryL,G1H2(606),ex2(:),G1H1(1),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(447),n2h1(351))
  call Hloop_VA_Q(ntryL,G1H2(610),ex2(:),G1H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(448),n2h1(352))
  call Hloop_VA_Q(ntryL,G1H2(611),ex2(:),G1H1(1),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(449),n2h1(353))
  call Hloop_VA_Q(ntryL,G1H2(612),ex2(:),G1H1(1),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(450),n2h1(354))
  call Hloop_VA_Q(ntryL,G1H2(616),ex2(:),G1H1(1),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(451),n2h1(355))
  call Hloop_ZA_Q(ntryL,G1H2(617),ex2(:),G1H1(1),ngZl,m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(452),n2h1(356))
  call Hloop_ZA_Q(ntryL,G1H2(618),ex2(:),G1H1(1),ngZl,m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(453),n2h1(357))
  call Hloop_ZA_Q(ntryL,G1H2(622),ex2(:),G1H1(1),ngZl,m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(454),n2h1(358))
  call Hloop_ZA_Q(ntryL,G1H2(623),ex2(:),G1H1(1),ngZl,m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(455),n2h1(359))
  call Hloop_ZA_Q(ntryL,G1H2(624),ex2(:),G1H1(1),ngZl,m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(456),n2h1(360))
  call Hloop_ZA_Q(ntryL,G1H2(628),ex2(:),G1H1(1),ngZl,m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(457),n2h1(361))
  call Hloop_ZA_Q(ntryL,G1H2(629),ex2(:),G1H1(1),ngZl,m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(458),n2h1(362))
  call Hloop_ZA_Q(ntryL,G1H2(630),ex2(:),G1H1(1),ngZl,m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(459),n2h1(363))
  call Hloop_ZA_Q(ntryL,G1H2(634),ex2(:),G1H1(1),ngZl,m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(460),n2h1(364))
  call Hloop_VA_Q(ntryL,G1H2(635),ex2(:),G1H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(461),n2h1(365))
  call Hloop_VA_Q(ntryL,G1H2(636),ex2(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(462),n2h1(366))
  call Hloop_VA_Q(ntryL,G1H2(640),ex2(:),G1H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(463),n2h1(367))
  call Hloop_VA_Q(ntryL,G1H2(641),ex2(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(464),n2h1(368))
  call Hloop_VA_Q(ntryL,G1H2(642),ex2(:),G1H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(465),n2h1(369))
  call Hloop_VA_Q(ntryL,G1H2(646),ex2(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(466),n2h1(370))
  call Hloop_ZA_Q(ntryL,G1H2(647),ex2(:),G1H1(1),ngZl,m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(467),n2h1(371))
  call Hloop_ZA_Q(ntryL,G1H2(648),ex2(:),G1H1(1),ngZl,m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(468),n2h1(372))
  call Hloop_ZA_Q(ntryL,G1H2(652),ex2(:),G1H1(1),ngZl,m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(469),n2h1(373))
  call Hloop_ZA_Q(ntryL,G1H2(653),ex2(:),G1H1(1),ngZl,m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(470),n2h1(374))
  call Hloop_ZA_Q(ntryL,G1H2(654),ex2(:),G1H1(1),ngZl,m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(471),n2h1(375))
  call Hloop_ZA_Q(ntryL,G1H2(658),ex2(:),G1H1(1),ngZl,m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(472),n2h1(376))
  call Hloop_VA_Q(ntryL,G1H2(659),ex4(:),G1H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(473),n2h1(377))
  call Hloop_VA_Q(ntryL,G1H2(660),ex4(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(474),n2h1(378))
  call Hloop_VA_Q(ntryL,G1H2(664),ex4(:),G1H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(475),n2h1(379))
  call Hloop_VA_Q(ntryL,G1H2(665),ex4(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(476),n2h1(380))
  call Hloop_VA_Q(ntryL,G1H2(666),ex4(:),G1H1(1),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(477),n2h1(381))
  call Hloop_VA_Q(ntryL,G1H2(670),ex4(:),G1H1(1),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(478),n2h1(382))
  call Hloop_VA_Q(ntryL,G1H2(671),ex4(:),G1H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(479),n2h1(383))
  call Hloop_VA_Q(ntryL,G1H2(672),ex4(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(480),n2h1(384))
  call Hloop_VA_Q(ntryL,G1H2(676),ex4(:),G1H1(1),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(481),n2h1(385))
  call Hloop_VA_Q(ntryL,G1H2(677),ex4(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(482),n2h1(386))
  call Hloop_VA_Q(ntryL,G1H2(678),ex4(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(483),n2h1(387))
  call Hloop_VA_Q(ntryL,G1H2(682),ex4(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(484),n2h1(388))
  call Hloop_VA_Q(ntryL,G1H2(683),ex4(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(485),n2h1(389))
  call Hloop_VA_Q(ntryL,G1H2(684),ex4(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(486),n2h1(390))
  call Hloop_VA_Q(ntryL,G1H2(688),ex4(:),G1H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(487),n2h1(391))
  call Hloop_ZA_Q(ntryL,G1H2(689),ex4(:),G1H1(1),ngZl,m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(488),n2h1(392))
  call Hloop_ZA_Q(ntryL,G1H2(690),ex4(:),G1H1(1),ngZl,m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(489),n2h1(393))
  call Hloop_ZA_Q(ntryL,G1H2(694),ex4(:),G1H1(1),ngZl,m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(490),n2h1(394))
  call Hloop_ZA_Q(ntryL,G1H2(695),ex4(:),G1H1(1),ngZl,m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(491),n2h1(395))
  call Hloop_ZA_Q(ntryL,G1H2(696),ex4(:),G1H1(1),ngZl,m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(492),n2h1(396))
  call Hloop_ZA_Q(ntryL,G1H2(700),ex4(:),G1H1(1),ngZl,m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(493),n2h1(397))
  call Hloop_ZA_Q(ntryL,G1H2(701),ex4(:),G1H1(1),ngZl,m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(494),n2h1(398))
  call Hloop_ZA_Q(ntryL,G1H2(702),ex4(:),G1H1(1),ngZl,m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(495),n2h1(399))
  call Hloop_ZA_Q(ntryL,G1H2(706),ex4(:),G1H1(1),ngZl,m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(496),n2h1(400))
  call Hloop_ZA_Q(ntryL,G1H2(707),ex4(:),G1H1(1),ngZl,m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(497),n2h1(401))
  call Hloop_ZA_Q(ntryL,G1H2(708),ex4(:),G1H1(1),ngZl,m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(498),n2h1(402))
  call Hloop_ZA_Q(ntryL,G1H2(712),ex4(:),G1H1(1),ngZl,m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(499),n2h1(403))
  call Hloop_ZA_Q(ntryL,G1H2(713),ex4(:),G1H1(1),ngZl,m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(500),n2h1(404))
  call Hloop_ZA_Q(ntryL,G1H2(714),ex4(:),G1H1(1),ngZl,m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(501),n2h1(405))
  call Hloop_ZA_Q(ntryL,G1H2(718),ex4(:),G1H1(1),ngZl,m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(502),n2h1(406))
  call Hloop_VA_Q(ntryL,G1H2(719),ex2(:),G1H1(1),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(503),n2h1(407))
  call Hloop_VA_Q(ntryL,G1H2(720),ex2(:),G1H1(1),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(504),n2h1(408))
  call Hloop_VA_Q(ntryL,G1H2(724),ex2(:),G1H1(1),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(505),n2h1(409))
  call Hloop_VA_Q(ntryL,G1H2(725),ex2(:),G1H1(1),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(506),n2h1(410))
  call Hloop_VA_Q(ntryL,G1H2(726),ex2(:),G1H1(1),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(507),n2h1(411))
  call Hloop_VA_Q(ntryL,G1H2(730),ex2(:),G1H1(1),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(508),n2h1(412))
  call Hloop_VA_Q(ntryL,G1H2(731),ex2(:),G1H1(1),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(509),n2h1(413))
  call Hloop_VA_Q(ntryL,G1H2(732),ex2(:),G1H1(1),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(510),n2h1(414))
  call Hloop_VA_Q(ntryL,G1H2(736),ex2(:),G1H1(1),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(511),n2h1(415))
  call Hloop_ZA_Q(ntryL,G1H2(737),ex2(:),G1H1(1),ngZl,m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(512),n2h1(416))
  call Hloop_ZA_Q(ntryL,G1H2(738),ex2(:),G1H1(1),ngZl,m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(513),n2h1(417))
  call Hloop_ZA_Q(ntryL,G1H2(742),ex2(:),G1H1(1),ngZl,m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(514),n2h1(418))
  call Hloop_ZA_Q(ntryL,G1H2(743),ex2(:),G1H1(1),ngZl,m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(515),n2h1(419))
  call Hloop_ZA_Q(ntryL,G1H2(744),ex2(:),G1H1(1),ngZl,m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(516),n2h1(420))
  call Hloop_ZA_Q(ntryL,G1H2(748),ex2(:),G1H1(1),ngZl,m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(517),n2h1(421))
  call Hloop_ZA_Q(ntryL,G1H2(749),ex2(:),G1H1(1),ngZl,m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(518),n2h1(422))
  call Hloop_ZA_Q(ntryL,G1H2(750),ex2(:),G1H1(1),ngZl,m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(519),n2h1(423))
  call Hloop_ZA_Q(ntryL,G1H2(754),ex2(:),G1H1(1),ngZl,m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(520),n2h1(424))
  call Hloop_VA_Q(ntryL,G1H2(755),ex2(:),G1H1(1),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(521),n2h1(425))
  call Hloop_VA_Q(ntryL,G1H2(756),ex2(:),G1H1(1),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(522),n2h1(426))
  call Hloop_VA_Q(ntryL,G1H2(760),ex2(:),G1H1(1),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(523),n2h1(427))
  call Hloop_VA_Q(ntryL,G1H2(761),ex2(:),G1H1(1),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(524),n2h1(428))
  call Hloop_VA_Q(ntryL,G1H2(762),ex2(:),G1H1(1),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(525),n2h1(429))
  call Hloop_VA_Q(ntryL,G1H2(766),ex2(:),G1H1(1),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(526),n2h1(430))
  call Hloop_ZA_Q(ntryL,G1H2(767),ex2(:),G1H1(1),ngZl,m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(527),n2h1(431))
  call Hloop_ZA_Q(ntryL,G1H2(768),ex2(:),G1H1(1),ngZl,m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(528),n2h1(432))
  call Hloop_ZA_Q(ntryL,G1H2(772),ex2(:),G1H1(1),ngZl,m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(529),n2h1(433))
  call Hloop_ZA_Q(ntryL,G1H2(773),ex2(:),G1H1(1),ngZl,m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(530),n2h1(434))
  call Hloop_ZA_Q(ntryL,G1H2(774),ex2(:),G1H1(1),ngZl,m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(531),n2h1(435))
  call Hloop_ZA_Q(ntryL,G1H2(778),ex2(:),G1H1(1),ngZl,m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(532),n2h1(436))
  call Hloop_QV_A(ntryL,G1H2(779),ex5(:),G1H1(1),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(533),n2h1(437))
  call Hloop_QV_A(ntryL,G1H2(780),ex5(:),G1H1(1),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(534),n2h1(438))
  call Hloop_QV_A(ntryL,G1H2(784),ex5(:),G1H1(1),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(535),n2h1(439))
  call Hloop_QV_A(ntryL,G1H2(785),ex5(:),G1H1(1),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(536),n2h1(440))
  call Hloop_QV_A(ntryL,G1H2(786),ex5(:),G1H1(1),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(537),n2h1(441))
  call Hloop_QV_A(ntryL,G1H2(790),ex5(:),G1H1(1),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(538),n2h1(442))
  call Hloop_QV_A(ntryL,G1H2(791),ex5(:),G1H1(1),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(539),n2h1(443))
  call Hloop_QV_A(ntryL,G1H2(792),ex5(:),G1H1(1),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(540),n2h1(444))
  call Hloop_QV_A(ntryL,G1H2(796),ex5(:),G1H1(1),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(541),n2h1(445))
  call Hloop_QV_A(ntryL,G1H2(797),ex5(:),G1H1(1),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(542),n2h1(446))
  call Hloop_QV_A(ntryL,G1H2(798),ex5(:),G1H1(1),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(543),n2h1(447))
  call Hloop_QV_A(ntryL,G1H2(802),ex5(:),G1H1(1),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(544),n2h1(448))
  call Hloop_QV_A(ntryL,G1H2(803),ex5(:),G1H1(1),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(545),n2h1(449))
  call Hloop_QV_A(ntryL,G1H2(804),ex5(:),G1H1(1),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(546),n2h1(450))
  call Hloop_QV_A(ntryL,G1H2(808),ex5(:),G1H1(1),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(547),n2h1(451))
  call Hloop_QV_A(ntryL,G1H2(809),ex5(:),G1H1(1),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(548),n2h1(452))
  call Hloop_QV_A(ntryL,G1H2(810),ex5(:),G1H1(1),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(549),n2h1(453))
  call Hloop_QV_A(ntryL,G1H2(814),ex5(:),G1H1(1),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(550),n2h1(454))
  call Hloop_QV_A(ntryL,G1H2(815),ex5(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(551),n2h1(455))
  call Hloop_QV_A(ntryL,G1H2(816),ex5(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(552),n2h1(456))
  call Hloop_QV_A(ntryL,G1H2(820),ex5(:),G1H1(1),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(553),n2h1(457))
  call Hloop_QV_A(ntryL,G1H2(821),ex5(:),G1H1(1),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(554),n2h1(458))
  call Hloop_QV_A(ntryL,G1H2(822),ex5(:),G1H1(1),m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(555),n2h1(459))
  call Hloop_QV_A(ntryL,G1H2(826),ex5(:),G1H1(1),m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(556),n2h1(460))
  call Hloop_QV_A(ntryL,G1H2(827),ex5(:),G1H1(1),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(557),n2h1(461))
  call Hloop_QV_A(ntryL,G1H2(828),ex5(:),G1H1(1),m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(558),n2h1(462))
  call Hloop_QV_A(ntryL,G1H2(832),ex5(:),G1H1(1),m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(559),n2h1(463))
  call Hloop_QV_A(ntryL,G1H2(833),ex5(:),G1H1(1),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(560),n2h1(464))
  call Hloop_QV_A(ntryL,G1H2(834),ex5(:),G1H1(1),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(561),n2h1(465))
  call Hloop_QV_A(ntryL,G1H2(838),ex5(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(562),n2h1(466))
  call Hloop_AV_Q(ntryL,G1H2(839),ex5(:),G1H1(1),m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(563),n2h1(467))
  call Hloop_AV_Q(ntryL,G1H2(840),ex5(:),G1H1(1),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(564),n2h1(468))
  call Hloop_AV_Q(ntryL,G1H2(844),ex5(:),G1H1(1),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(565),n2h1(469))
  call Hloop_AV_Q(ntryL,G1H2(845),ex5(:),G1H1(1),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(566),n2h1(470))
  call Hloop_AV_Q(ntryL,G1H2(846),ex5(:),G1H1(1),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(567),n2h1(471))
  call Hloop_AV_Q(ntryL,G1H2(850),ex5(:),G1H1(1),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(568),n2h1(472))
  call Hloop_AV_Q(ntryL,G1H2(851),ex5(:),G1H1(1),m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(569),n2h1(473))
  call Hloop_AV_Q(ntryL,G1H2(852),ex5(:),G1H1(1),m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(570),n2h1(474))
  call Hloop_AV_Q(ntryL,G1H2(856),ex5(:),G1H1(1),m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(571),n2h1(475))
  call Hloop_AV_Q(ntryL,G1H2(857),ex5(:),G1H1(1),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(572),n2h1(476))
  call Hloop_AV_Q(ntryL,G1H2(858),ex5(:),G1H1(1),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(573),n2h1(477))
  call Hloop_AV_Q(ntryL,G1H2(862),ex5(:),G1H1(1),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(574),n2h1(478))
  call Hloop_AV_Q(ntryL,G1H2(863),ex5(:),G1H1(1),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(575),n2h1(479))
  call Hloop_AV_Q(ntryL,G1H2(864),ex5(:),G1H1(1),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(576),n2h1(480))
  call Hloop_AV_Q(ntryL,G1H2(868),ex5(:),G1H1(1),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(577),n2h1(481))
  call Hloop_AV_Q(ntryL,G1H2(869),ex5(:),G1H1(1),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(578),n2h1(482))
  call Hloop_AV_Q(ntryL,G1H2(870),ex5(:),G1H1(1),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(579),n2h1(483))
  call Hloop_AV_Q(ntryL,G1H2(874),ex5(:),G1H1(1),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(580),n2h1(484))
  call Hloop_AV_Q(ntryL,G1H2(875),ex5(:),G1H1(1),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(581),n2h1(485))
  call Hloop_AV_Q(ntryL,G1H2(876),ex5(:),G1H1(1),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(582),n2h1(486))
  call Hloop_AV_Q(ntryL,G1H2(880),ex5(:),G1H1(1),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(583),n2h1(487))
  call Hloop_AV_Q(ntryL,G1H2(881),ex5(:),G1H1(1),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(584),n2h1(488))
  call Hloop_AV_Q(ntryL,G1H2(882),ex5(:),G1H1(1),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(585),n2h1(489))
  call Hloop_AV_Q(ntryL,G1H2(886),ex5(:),G1H1(1),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(586),n2h1(490))
  call Hloop_AV_Q(ntryL,G1H2(887),ex5(:),G1H1(1),m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(587),n2h1(491))
  call Hloop_AV_Q(ntryL,G1H2(888),ex5(:),G1H1(1),m3h2x1(:,626),heltab2x2(:,:,626))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(588),n2h1(492))
  call Hloop_AV_Q(ntryL,G1H2(892),ex5(:),G1H1(1),m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(589),n2h1(493))
  call Hloop_AV_Q(ntryL,G1H2(893),ex5(:),G1H1(1),m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(590),n2h1(494))
  call Hloop_AV_Q(ntryL,G1H2(894),ex5(:),G1H1(1),m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(591),n2h1(495))
  call Hloop_AV_Q(ntryL,G1H2(898),ex5(:),G1H1(1),m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(592),n2h1(496))
  call Hloop_QV_A(ntryL,G1H2(899),ex5(:),G1H1(1),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(593),n2h1(497))
  call Hloop_QV_A(ntryL,G1H2(900),ex5(:),G1H1(1),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(594),n2h1(498))
  call Hloop_QV_A(ntryL,G1H2(904),ex5(:),G1H1(1),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(595),n2h1(499))
  call Hloop_QV_A(ntryL,G1H2(905),ex5(:),G1H1(1),m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(596),n2h1(500))
  call Hloop_QV_A(ntryL,G1H2(906),ex5(:),G1H1(1),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(597),n2h1(501))
  call Hloop_QV_A(ntryL,G1H2(910),ex5(:),G1H1(1),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(598),n2h1(502))
  call Hloop_QV_A(ntryL,G1H2(911),ex5(:),G1H1(1),m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(599),n2h1(503))
  call Hloop_QV_A(ntryL,G1H2(912),ex5(:),G1H1(1),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(600),n2h1(504))
  call Hloop_QV_A(ntryL,G1H2(916),ex5(:),G1H1(1),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(601),n2h1(505))
  call Hloop_QV_A(ntryL,G1H2(917),ex5(:),G1H1(1),m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(602),n2h1(506))
  call Hloop_QV_A(ntryL,G1H2(918),ex5(:),G1H1(1),m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(603),n2h1(507))
  call Hloop_QV_A(ntryL,G1H2(922),ex5(:),G1H1(1),m3h2x1(:,642),heltab2x2(:,:,642))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(604),n2h1(508))
  call Hloop_QV_A(ntryL,G1H2(923),ex5(:),G1H1(1),m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(605),n2h1(509))
  call Hloop_QV_A(ntryL,G1H2(924),ex5(:),G1H1(1),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(606),n2h1(510))
  call Hloop_QV_A(ntryL,G1H2(928),ex5(:),G1H1(1),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(607),n2h1(511))
  call Hloop_QV_A(ntryL,G1H2(929),ex5(:),G1H1(1),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(608),n2h1(512))
  call Hloop_QV_A(ntryL,G1H2(930),ex5(:),G1H1(1),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(609),n2h1(513))
  call Hloop_QV_A(ntryL,G1H2(934),ex5(:),G1H1(1),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(610),n2h1(514))
  call Hloop_AV_Q(ntryL,G1H2(935),ex5(:),G1H1(1),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(611),n2h1(515))
  call Hloop_AV_Q(ntryL,G1H2(936),ex5(:),G1H1(1),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(612),n2h1(516))
  call Hloop_AV_Q(ntryL,G1H2(940),ex5(:),G1H1(1),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(613),n2h1(517))
  call Hloop_AV_Q(ntryL,G1H2(941),ex5(:),G1H1(1),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(614),n2h1(518))
  call Hloop_AV_Q(ntryL,G1H2(942),ex5(:),G1H1(1),m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(615),n2h1(519))
  call Hloop_AV_Q(ntryL,G1H2(946),ex5(:),G1H1(1),m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(616),n2h1(520))
  call Hloop_AV_Q(ntryL,G1H2(947),ex5(:),G1H1(1),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(617),n2h1(521))
  call Hloop_AV_Q(ntryL,G1H2(948),ex5(:),G1H1(1),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(618),n2h1(522))
  call Hloop_AV_Q(ntryL,G1H2(952),ex5(:),G1H1(1),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(619),n2h1(523))
  call Hloop_AV_Q(ntryL,G1H2(953),ex5(:),G1H1(1),m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(620),n2h1(524))
  call Hloop_AV_Q(ntryL,G1H2(954),ex5(:),G1H1(1),m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(621),n2h1(525))
  call Hloop_AV_Q(ntryL,G1H2(958),ex5(:),G1H1(1),m3h2x1(:,660),heltab2x2(:,:,660))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(622),n2h1(526))
  call Hloop_AV_Q(ntryL,G1H2(959),ex5(:),G1H1(1),m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(623),n2h1(527))
  call Hloop_AV_Q(ntryL,G1H2(960),ex5(:),G1H1(1),m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(624),n2h1(528))
  call Hloop_AV_Q(ntryL,G1H2(964),ex5(:),G1H1(1),m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(625),n2h1(529))
  call Hloop_AV_Q(ntryL,G1H2(965),ex5(:),G1H1(1),m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(626),n2h1(530))
  call Hloop_AV_Q(ntryL,G1H2(966),ex5(:),G1H1(1),m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(627),n2h1(531))
  call Hloop_AV_Q(ntryL,G1H2(970),ex5(:),G1H1(1),m3h2x1(:,666),heltab2x2(:,:,666))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(628),n2h1(532))
  call Hloop_QV_A(ntryL,G1H2(971),ex5(:),G1H1(1),m3h2x1(:,667),heltab2x2(:,:,667))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(629),n2h1(533))
  call Hloop_QV_A(ntryL,G1H2(972),ex5(:),G1H1(1),m3h2x1(:,668),heltab2x2(:,:,668))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(630),n2h1(534))
  call Hloop_QV_A(ntryL,G1H2(976),ex5(:),G1H1(1),m3h2x1(:,669),heltab2x2(:,:,669))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(631),n2h1(535))
  call Hloop_QV_A(ntryL,G1H2(977),ex5(:),G1H1(1),m3h2x1(:,670),heltab2x2(:,:,670))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(632),n2h1(536))
  call Hloop_QV_A(ntryL,G1H2(978),ex5(:),G1H1(1),m3h2x1(:,671),heltab2x2(:,:,671))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(633),n2h1(537))
  call Hloop_QV_A(ntryL,G1H2(982),ex5(:),G1H1(1),m3h2x1(:,672),heltab2x2(:,:,672))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(634),n2h1(538))
  call Hloop_QV_A(ntryL,G1H2(983),ex5(:),G1H1(1),m3h2x1(:,673),heltab2x2(:,:,673))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(635),n2h1(539))
  call Hloop_QV_A(ntryL,G1H2(984),ex5(:),G1H1(1),m3h2x1(:,674),heltab2x2(:,:,674))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(636),n2h1(540))
  call Hloop_QV_A(ntryL,G1H2(988),ex5(:),G1H1(1),m3h2x1(:,675),heltab2x2(:,:,675))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(637),n2h1(541))
  call Hloop_QV_A(ntryL,G1H2(989),ex5(:),G1H1(1),m3h2x1(:,676),heltab2x2(:,:,676))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(638),n2h1(542))
  call Hloop_QV_A(ntryL,G1H2(990),ex5(:),G1H1(1),m3h2x1(:,677),heltab2x2(:,:,677))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(639),n2h1(543))
  call Hloop_QV_A(ntryL,G1H2(994),ex5(:),G1H1(1),m3h2x1(:,678),heltab2x2(:,:,678))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(640),n2h1(544))
  call Hloop_QV_A(ntryL,G1H2(995),ex5(:),G1H1(1),m3h2x1(:,679),heltab2x2(:,:,679))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(641),n2h1(545))
  call Hloop_QV_A(ntryL,G1H2(996),ex5(:),G1H1(1),m3h2x1(:,680),heltab2x2(:,:,680))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(642),n2h1(546))
  call Hloop_QV_A(ntryL,G1H2(1000),ex5(:),G1H1(1),m3h2x1(:,681),heltab2x2(:,:,681))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(643),n2h1(547))
  call Hloop_QV_A(ntryL,G1H2(1001),ex5(:),G1H1(1),m3h2x1(:,682),heltab2x2(:,:,682))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(644),n2h1(548))
  call Hloop_QV_A(ntryL,G1H2(1002),ex5(:),G1H1(1),m3h2x1(:,683),heltab2x2(:,:,683))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(645),n2h1(549))
  call Hloop_QV_A(ntryL,G1H2(1006),ex5(:),G1H1(1),m3h2x1(:,684),heltab2x2(:,:,684))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(646),n2h1(550))
  call Hloop_QV_A(ntryL,G1H2(1007),ex5(:),G1H1(1),m3h2x1(:,685),heltab2x2(:,:,685))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(647),n2h1(551))
  call Hloop_QV_A(ntryL,G1H2(1008),ex5(:),G1H1(1),m3h2x1(:,686),heltab2x2(:,:,686))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(648),n2h1(552))
  call Hloop_QV_A(ntryL,G1H2(1012),ex5(:),G1H1(1),m3h2x1(:,687),heltab2x2(:,:,687))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(649),n2h1(553))
  call Hloop_QV_A(ntryL,G1H2(1013),ex5(:),G1H1(1),m3h2x1(:,688),heltab2x2(:,:,688))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(650),n2h1(554))
  call Hloop_QV_A(ntryL,G1H2(1014),ex5(:),G1H1(1),m3h2x1(:,689),heltab2x2(:,:,689))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(651),n2h1(555))
  call Hloop_QV_A(ntryL,G1H2(1018),ex5(:),G1H1(1),m3h2x1(:,690),heltab2x2(:,:,690))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(652),n2h1(556))
  call Hloop_QV_A(ntryL,G1H2(1019),ex5(:),G1H1(1),m3h2x1(:,691),heltab2x2(:,:,691))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(653),n2h1(557))
  call Hloop_QV_A(ntryL,G1H2(1020),ex5(:),G1H1(1),m3h2x1(:,692),heltab2x2(:,:,692))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(654),n2h1(558))
  call Hloop_QV_A(ntryL,G1H2(1024),ex5(:),G1H1(1),m3h2x1(:,693),heltab2x2(:,:,693))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(655),n2h1(559))
  call Hloop_QV_A(ntryL,G1H2(1025),ex5(:),G1H1(1),m3h2x1(:,694),heltab2x2(:,:,694))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(656),n2h1(560))
  call Hloop_QV_A(ntryL,G1H2(1026),ex5(:),G1H1(1),m3h2x1(:,695),heltab2x2(:,:,695))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(657),n2h1(561))
  call Hloop_QV_A(ntryL,G1H2(1030),ex5(:),G1H1(1),m3h2x1(:,696),heltab2x2(:,:,696))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(658),n2h1(562))
  call Hloop_AV_Q(ntryL,G1H2(1031),ex5(:),G1H1(1),m3h2x1(:,697),heltab2x2(:,:,697))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(659),n2h1(563))
  call Hloop_AV_Q(ntryL,G1H2(1032),ex5(:),G1H1(1),m3h2x1(:,698),heltab2x2(:,:,698))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(660),n2h1(564))
  call Hloop_AV_Q(ntryL,G1H2(1036),ex5(:),G1H1(1),m3h2x1(:,699),heltab2x2(:,:,699))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(661),n2h1(565))
  call Hloop_AV_Q(ntryL,G1H2(1037),ex5(:),G1H1(1),m3h2x1(:,700),heltab2x2(:,:,700))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(662),n2h1(566))
  call Hloop_AV_Q(ntryL,G1H2(1038),ex5(:),G1H1(1),m3h2x1(:,701),heltab2x2(:,:,701))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(663),n2h1(567))
  call Hloop_AV_Q(ntryL,G1H2(1042),ex5(:),G1H1(1),m3h2x1(:,702),heltab2x2(:,:,702))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(664),n2h1(568))
  call Hloop_AV_Q(ntryL,G1H2(1043),ex5(:),G1H1(1),m3h2x1(:,703),heltab2x2(:,:,703))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(665),n2h1(569))
  call Hloop_AV_Q(ntryL,G1H2(1044),ex5(:),G1H1(1),m3h2x1(:,704),heltab2x2(:,:,704))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(666),n2h1(570))
  call Hloop_AV_Q(ntryL,G1H2(1048),ex5(:),G1H1(1),m3h2x1(:,705),heltab2x2(:,:,705))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(667),n2h1(571))
  call Hloop_AV_Q(ntryL,G1H2(1049),ex5(:),G1H1(1),m3h2x1(:,706),heltab2x2(:,:,706))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(668),n2h1(572))
  call Hloop_AV_Q(ntryL,G1H2(1050),ex5(:),G1H1(1),m3h2x1(:,707),heltab2x2(:,:,707))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(669),n2h1(573))
  call Hloop_AV_Q(ntryL,G1H2(1054),ex5(:),G1H1(1),m3h2x1(:,708),heltab2x2(:,:,708))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(670),n2h1(574))
  call Hloop_AV_Q(ntryL,G1H2(1055),ex5(:),G1H1(1),m3h2x1(:,709),heltab2x2(:,:,709))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(671),n2h1(575))
  call Hloop_AV_Q(ntryL,G1H2(1056),ex5(:),G1H1(1),m3h2x1(:,710),heltab2x2(:,:,710))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(672),n2h1(576))
  call Hloop_AV_Q(ntryL,G1H2(1060),ex5(:),G1H1(1),m3h2x1(:,711),heltab2x2(:,:,711))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(673),n2h1(577))
  call Hloop_AV_Q(ntryL,G1H2(1061),ex5(:),G1H1(1),m3h2x1(:,712),heltab2x2(:,:,712))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(674),n2h1(578))
  call Hloop_AV_Q(ntryL,G1H2(1062),ex5(:),G1H1(1),m3h2x1(:,713),heltab2x2(:,:,713))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(675),n2h1(579))
  call Hloop_AV_Q(ntryL,G1H2(1066),ex5(:),G1H1(1),m3h2x1(:,714),heltab2x2(:,:,714))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(676),n2h1(580))
  call Hloop_AV_Q(ntryL,G1H2(1067),ex5(:),G1H1(1),m3h2x1(:,715),heltab2x2(:,:,715))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(677),n2h1(581))
  call Hloop_AV_Q(ntryL,G1H2(1068),ex5(:),G1H1(1),m3h2x1(:,716),heltab2x2(:,:,716))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(678),n2h1(582))
  call Hloop_AV_Q(ntryL,G1H2(1072),ex5(:),G1H1(1),m3h2x1(:,717),heltab2x2(:,:,717))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(679),n2h1(583))
  call Hloop_AV_Q(ntryL,G1H2(1073),ex5(:),G1H1(1),m3h2x1(:,718),heltab2x2(:,:,718))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(680),n2h1(584))
  call Hloop_AV_Q(ntryL,G1H2(1074),ex5(:),G1H1(1),m3h2x1(:,719),heltab2x2(:,:,719))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(681),n2h1(585))
  call Hloop_AV_Q(ntryL,G1H2(1078),ex5(:),G1H1(1),m3h2x1(:,720),heltab2x2(:,:,720))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(682),n2h1(586))
  call Hloop_AV_Q(ntryL,G1H2(1079),ex5(:),G1H1(1),m3h2x1(:,721),heltab2x2(:,:,721))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(683),n2h1(587))
  call Hloop_AV_Q(ntryL,G1H2(1080),ex5(:),G1H1(1),m3h2x1(:,722),heltab2x2(:,:,722))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(684),n2h1(588))
  call Hloop_AV_Q(ntryL,G1H2(1084),ex5(:),G1H1(1),m3h2x1(:,723),heltab2x2(:,:,723))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(685),n2h1(589))
  call Hloop_AV_Q(ntryL,G1H2(1085),ex5(:),G1H1(1),m3h2x1(:,724),heltab2x2(:,:,724))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(686),n2h1(590))
  call Hloop_AV_Q(ntryL,G1H2(1086),ex5(:),G1H1(1),m3h2x1(:,725),heltab2x2(:,:,725))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(687),n2h1(591))
  call Hloop_AV_Q(ntryL,G1H2(1090),ex5(:),G1H1(1),m3h2x1(:,726),heltab2x2(:,:,726))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(688),n2h1(592))
  call Hloop_QV_A(ntryL,G1H2(1091),ex5(:),G1H1(1),m3h2x1(:,727),heltab2x2(:,:,727))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(689),n2h1(593))
  call Hloop_QV_A(ntryL,G1H2(1092),ex5(:),G1H1(1),m3h2x1(:,728),heltab2x2(:,:,728))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(690),n2h1(594))
  call Hloop_QV_A(ntryL,G1H2(1096),ex5(:),G1H1(1),m3h2x1(:,729),heltab2x2(:,:,729))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(691),n2h1(595))
  call Hloop_QV_A(ntryL,G1H2(1097),ex5(:),G1H1(1),m3h2x1(:,730),heltab2x2(:,:,730))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(692),n2h1(596))
  call Hloop_QV_A(ntryL,G1H2(1098),ex5(:),G1H1(1),m3h2x1(:,731),heltab2x2(:,:,731))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(693),n2h1(597))
  call Hloop_QV_A(ntryL,G1H2(1102),ex5(:),G1H1(1),m3h2x1(:,732),heltab2x2(:,:,732))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(694),n2h1(598))
  call Hloop_QV_A(ntryL,G1H2(1103),ex5(:),G1H1(1),m3h2x1(:,733),heltab2x2(:,:,733))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(695),n2h1(599))
  call Hloop_QV_A(ntryL,G1H2(1104),ex5(:),G1H1(1),m3h2x1(:,734),heltab2x2(:,:,734))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(696),n2h1(600))
  call Hloop_QV_A(ntryL,G1H2(1108),ex5(:),G1H1(1),m3h2x1(:,735),heltab2x2(:,:,735))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(697),n2h1(601))
  call Hloop_QV_A(ntryL,G1H2(1109),ex5(:),G1H1(1),m3h2x1(:,736),heltab2x2(:,:,736))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(698),n2h1(602))
  call Hloop_QV_A(ntryL,G1H2(1110),ex5(:),G1H1(1),m3h2x1(:,737),heltab2x2(:,:,737))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(699),n2h1(603))
  call Hloop_QV_A(ntryL,G1H2(1114),ex5(:),G1H1(1),m3h2x1(:,738),heltab2x2(:,:,738))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(700),n2h1(604))
  call Hloop_QV_A(ntryL,G1H2(1115),ex5(:),G1H1(1),m3h2x1(:,739),heltab2x2(:,:,739))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(701),n2h1(605))
  call Hloop_QV_A(ntryL,G1H2(1116),ex5(:),G1H1(1),m3h2x1(:,740),heltab2x2(:,:,740))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(702),n2h1(606))
  call Hloop_QV_A(ntryL,G1H2(1120),ex5(:),G1H1(1),m3h2x1(:,741),heltab2x2(:,:,741))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(703),n2h1(607))
  call Hloop_QV_A(ntryL,G1H2(1121),ex5(:),G1H1(1),m3h2x1(:,742),heltab2x2(:,:,742))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(704),n2h1(608))
  call Hloop_QV_A(ntryL,G1H2(1122),ex5(:),G1H1(1),m3h2x1(:,743),heltab2x2(:,:,743))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(705),n2h1(609))
  call Hloop_QV_A(ntryL,G1H2(1126),ex5(:),G1H1(1),m3h2x1(:,744),heltab2x2(:,:,744))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(706),n2h1(610))
  call Hloop_AV_Q(ntryL,G1H2(1127),ex5(:),G1H1(1),m3h2x1(:,745),heltab2x2(:,:,745))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(707),n2h1(611))
  call Hloop_AV_Q(ntryL,G1H2(1128),ex5(:),G1H1(1),m3h2x1(:,746),heltab2x2(:,:,746))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(708),n2h1(612))
  call Hloop_AV_Q(ntryL,G1H2(1132),ex5(:),G1H1(1),m3h2x1(:,747),heltab2x2(:,:,747))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(709),n2h1(613))
  call Hloop_AV_Q(ntryL,G1H2(1133),ex5(:),G1H1(1),m3h2x1(:,748),heltab2x2(:,:,748))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(710),n2h1(614))
  call Hloop_AV_Q(ntryL,G1H2(1134),ex5(:),G1H1(1),m3h2x1(:,749),heltab2x2(:,:,749))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(711),n2h1(615))
  call Hloop_AV_Q(ntryL,G1H2(1138),ex5(:),G1H1(1),m3h2x1(:,750),heltab2x2(:,:,750))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(712),n2h1(616))
  call Hloop_AV_Q(ntryL,G1H2(1139),ex5(:),G1H1(1),m3h2x1(:,751),heltab2x2(:,:,751))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(713),n2h1(617))
  call Hloop_AV_Q(ntryL,G1H2(1140),ex5(:),G1H1(1),m3h2x1(:,752),heltab2x2(:,:,752))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(714),n2h1(618))
  call Hloop_AV_Q(ntryL,G1H2(1144),ex5(:),G1H1(1),m3h2x1(:,753),heltab2x2(:,:,753))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(715),n2h1(619))
  call Hloop_AV_Q(ntryL,G1H2(1145),ex5(:),G1H1(1),m3h2x1(:,754),heltab2x2(:,:,754))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(716),n2h1(620))
  call Hloop_AV_Q(ntryL,G1H2(1146),ex5(:),G1H1(1),m3h2x1(:,755),heltab2x2(:,:,755))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(717),n2h1(621))
  call Hloop_AV_Q(ntryL,G1H2(1150),ex5(:),G1H1(1),m3h2x1(:,756),heltab2x2(:,:,756))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(718),n2h1(622))
  call Hloop_AV_Q(ntryL,G1H2(1151),ex5(:),G1H1(1),m3h2x1(:,757),heltab2x2(:,:,757))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(719),n2h1(623))
  call Hloop_AV_Q(ntryL,G1H2(1152),ex5(:),G1H1(1),m3h2x1(:,758),heltab2x2(:,:,758))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(720),n2h1(624))
  call Hloop_AV_Q(ntryL,G1H2(1156),ex5(:),G1H1(1),m3h2x1(:,759),heltab2x2(:,:,759))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(721),n2h1(625))
  call Hloop_AV_Q(ntryL,G1H2(1157),ex5(:),G1H1(1),m3h2x1(:,760),heltab2x2(:,:,760))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(722),n2h1(626))
  call Hloop_AV_Q(ntryL,G1H2(1158),ex5(:),G1H1(1),m3h2x1(:,761),heltab2x2(:,:,761))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(723),n2h1(627))
  call Hloop_AV_Q(ntryL,G1H2(1162),ex5(:),G1H1(1),m3h2x1(:,762),heltab2x2(:,:,762))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(724),n2h1(628))
  call Hloop_VQ_A(ntryL,G1H4(87),wf4(:,14),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,517))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(725),n2h1(629))
  call Hloop_VQ_A(ntryL,G1H4(88),wf4(:,14),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,518))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(726),n2h1(630))
  call Hloop_VQ_A(ntryL,G1H4(100),wf4(:,14),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,519))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(727),n2h1(631))
  call Hloop_ZQ_A(ntryL,G1H4(104),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,24),heltab2x4(:,:,520))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(728),n2h1(632))
  call Hloop_ZQ_A(ntryL,G1H4(105),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,25),heltab2x4(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(729),n2h1(633))
  call Hloop_ZQ_A(ntryL,G1H4(124),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,26),heltab2x4(:,:,522))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(730),n2h1(634))
  call Hloop_VQ_A(ntryL,G1H4(199),wf4(:,14),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,523))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(731),n2h1(635))
  call Hloop_VQ_A(ntryL,G1H4(57),wf4(:,14),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,524))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(732),n2h1(636))
  call Hloop_VQ_A(ntryL,G1H4(11),wf4(:,14),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,525))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(733),n2h1(637))
  call Hloop_ZQ_A(ntryL,G1H4(13),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,30),heltab2x4(:,:,526))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(734),n2h1(638))
  call Hloop_ZQ_A(ntryL,G1H4(17),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,31),heltab2x4(:,:,527))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(735),n2h1(639))
  call Hloop_ZQ_A(ntryL,G1H4(30),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,32),heltab2x4(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(736),n2h1(640))
  call Hloop_VQ_A(ntryL,G1H4(36),wf4(:,14),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,529))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(737),n2h1(641))
  call Hloop_VQ_A(ntryL,G1H4(37),wf4(:,14),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(738),n2h1(642))
  call Hloop_VQ_A(ntryL,G1H4(54),wf4(:,14),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,531))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(739),n2h1(643))
  call Hloop_ZQ_A(ntryL,G1H4(59),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,36),heltab2x4(:,:,532))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(740),n2h1(644))
  call Hloop_ZQ_A(ntryL,G1H4(60),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,37),heltab2x4(:,:,533))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(741),n2h1(645))
  call Hloop_ZQ_A(ntryL,G1H4(89),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,38),heltab2x4(:,:,534))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(742),n2h1(646))
  call Hloop_VQ_A(ntryL,G1H4(101),wf4(:,14),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,535))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(743),n2h1(647))
  call Hloop_VQ_A(ntryL,G1H4(102),wf4(:,14),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,536))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(744),n2h1(648))
  call Hloop_VQ_A(ntryL,G1H4(115),wf4(:,14),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,537))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(745),n2h1(649))
  call Hloop_ZQ_A(ntryL,G1H4(119),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,42),heltab2x4(:,:,538))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(746),n2h1(650))
  call Hloop_ZQ_A(ntryL,G1H4(121),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,43),heltab2x4(:,:,539))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(747),n2h1(651))
  call Hloop_ZQ_A(ntryL,G1H4(133),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,44),heltab2x4(:,:,540))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(748),n2h1(652))
  call Hloop_VA_Q(ntryL,G1H4(143),wf4(:,20),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,541))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(749),n2h1(653))
  call Hloop_VA_Q(ntryL,G1H4(145),wf4(:,20),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,542))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(750),n2h1(654))
  call Hloop_VA_Q(ntryL,G1H4(167),wf4(:,20),G1H1(1),m3h4x1(:,47),heltab2x4(:,:,543))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(751),n2h1(655))
  call Hloop_ZA_Q(ntryL,G1H4(173),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,48),heltab2x4(:,:,544))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(752),n2h1(656))
  call Hloop_ZA_Q(ntryL,G1H4(174),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,49),heltab2x4(:,:,545))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(753),n2h1(657))
  call Hloop_ZA_Q(ntryL,G1H4(63),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,50),heltab2x4(:,:,546))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(754),n2h1(658))
  call Hloop_VA_Q(ntryL,G1H4(210),wf4(:,20),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,547))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(755),n2h1(659))
  call Hloop_VA_Q(ntryL,G1H4(269),wf4(:,20),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,548))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(756),n2h1(660))
  call Hloop_VA_Q(ntryL,G1H4(55),wf4(:,20),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,549))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(757),n2h1(661))
  call Hloop_ZA_Q(ntryL,G1H4(196),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,54),heltab2x4(:,:,550))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(758),n2h1(662))
  call Hloop_ZA_Q(ntryL,G1H4(24),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,55),heltab2x4(:,:,551))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(759),n2h1(663))
  call Hloop_ZA_Q(ntryL,G1H4(274),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,56),heltab2x4(:,:,552))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(760),n2h1(664))
  call Hloop_VA_Q(ntryL,G1H4(48),wf4(:,20),G1H1(1),m3h4x1(:,57),heltab2x4(:,:,553))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(761),n2h1(665))
  call Hloop_VA_Q(ntryL,G1H4(85),wf4(:,20),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,554))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(762),n2h1(666))
  call Hloop_VA_Q(ntryL,G1H4(72),wf4(:,20),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,555))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(763),n2h1(667))
  call Hloop_ZA_Q(ntryL,G1H4(207),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,60),heltab2x4(:,:,556))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(764),n2h1(668))
  call Hloop_ZA_Q(ntryL,G1H4(208),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,61),heltab2x4(:,:,557))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(765),n2h1(669))
  call Hloop_ZA_Q(ntryL,G1H4(182),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,62),heltab2x4(:,:,558))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(766),n2h1(670))
  call Hloop_VA_Q(ntryL,G1H4(151),wf4(:,20),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,559))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(767),n2h1(671))
  call Hloop_VA_Q(ntryL,G1H4(146),wf4(:,20),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,560))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(768),n2h1(672))
  call Hloop_VA_Q(ntryL,G1H4(169),wf4(:,20),G1H1(1),m3h4x1(:,65),heltab2x4(:,:,561))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(769),n2h1(673))
  call Hloop_ZA_Q(ntryL,G1H4(209),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,66),heltab2x4(:,:,562))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(770),n2h1(674))
  call Hloop_ZA_Q(ntryL,G1H4(58),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,67),heltab2x4(:,:,563))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(771),n2h1(675))
  call Hloop_ZA_Q(ntryL,G1H4(136),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,68),heltab2x4(:,:,564))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(772),n2h1(676))
  call Hloop_VQ_A(ntryL,G1H4(152),wf4(:,4),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,565))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(773),n2h1(677))
  call Hloop_VQ_A(ntryL,G1H4(153),wf4(:,4),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,566))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(774),n2h1(678))
  call Hloop_VQ_A(ntryL,G1H4(172),wf4(:,4),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,567))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(775),n2h1(679))
  call Hloop_ZQ_A(ntryL,G1H4(175),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,72),heltab2x4(:,:,568))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(776),n2h1(680))
  call Hloop_ZQ_A(ntryL,G1H4(130),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,73),heltab2x4(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(777),n2h1(681))
  call Hloop_ZQ_A(ntryL,G1H4(193),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,74),heltab2x4(:,:,570))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(778),n2h1(682))
  call Hloop_VQ_A(ntryL,G1H4(160),wf4(:,4),G1H1(1),m3h4x1(:,75),heltab2x4(:,:,571))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(779),n2h1(683))
  call Hloop_VQ_A(ntryL,G1H4(164),wf4(:,4),G1H1(1),m3h4x1(:,76),heltab2x4(:,:,572))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(780),n2h1(684))
  call Hloop_VQ_A(ntryL,G1H4(4),wf4(:,4),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,573))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(781),n2h1(685))
  call Hloop_ZQ_A(ntryL,G1H4(8),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,78),heltab2x4(:,:,574))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(782),n2h1(686))
  call Hloop_ZQ_A(ntryL,G1H4(9),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,79),heltab2x4(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(783),n2h1(687))
  call Hloop_ZQ_A(ntryL,G1H4(21),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,80),heltab2x4(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(784),n2h1(688))
  call Hloop_VQ_A(ntryL,G1H4(27),wf4(:,4),G1H1(1),m3h4x1(:,81),heltab2x4(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(785),n2h1(689))
  call Hloop_VQ_A(ntryL,G1H4(28),wf4(:,4),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,578))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(786),n2h1(690))
  call Hloop_VQ_A(ntryL,G1H4(117),wf4(:,4),G1H1(1),m3h4x1(:,83),heltab2x4(:,:,579))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(787),n2h1(691))
  call Hloop_VQ_A(ntryL,G1H4(203),wf4(:,4),G1H1(1),m3h4x1(:,84),heltab2x4(:,:,580))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(788),n2h1(692))
  call Hloop_VQ_A(ntryL,G1H4(205),wf4(:,4),G1H1(1),m3h4x1(:,85),heltab2x4(:,:,581))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(789),n2h1(693))
  call Hloop_VQ_A(ntryL,G1H4(33),wf4(:,4),G1H1(1),m3h4x1(:,86),heltab2x4(:,:,582))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(790),n2h1(694))
  call Hloop_ZQ_A(ntryL,G1H4(40),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,87),heltab2x4(:,:,583))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(791),n2h1(695))
  call Hloop_ZQ_A(ntryL,G1H4(44),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,88),heltab2x4(:,:,584))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(792),n2h1(696))
  call Hloop_ZQ_A(ntryL,G1H4(64),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,89),heltab2x4(:,:,585))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(793),n2h1(697))
  call Hloop_ZQ_A(ntryL,G1H4(68),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,90),heltab2x4(:,:,586))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(794),n2h1(698))
  call Hloop_ZQ_A(ntryL,G1H4(75),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,91),heltab2x4(:,:,587))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(795),n2h1(699))
  call Hloop_ZQ_A(ntryL,G1H4(222),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,92),heltab2x4(:,:,588))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(796),n2h1(700))
  call Hloop_VA_Q(ntryL,G1H4(225),wf4(:,10),G1H1(1),m3h4x1(:,93),heltab2x4(:,:,589))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(797),n2h1(701))
  call Hloop_VA_Q(ntryL,G1H4(226),wf4(:,10),G1H1(1),m3h4x1(:,94),heltab2x4(:,:,590))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(798),n2h1(702))
  call Hloop_VA_Q(ntryL,G1H4(232),wf4(:,10),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,591))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(799),n2h1(703))
  call Hloop_ZA_Q(ntryL,G1H4(233),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,96),heltab2x4(:,:,592))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(800),n2h1(704))
  call Hloop_ZA_Q(ntryL,G1H4(234),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,97),heltab2x4(:,:,593))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(801),n2h1(705))
  call Hloop_ZA_Q(ntryL,G1H4(240),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,98),heltab2x4(:,:,594))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(802),n2h1(706))
  call Hloop_VA_Q(ntryL,G1H4(243),wf4(:,10),G1H1(1),m3h4x1(:,99),heltab2x4(:,:,595))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(803),n2h1(707))
  call Hloop_VA_Q(ntryL,G1H4(244),wf4(:,10),G1H1(1),m3h4x1(:,100),heltab2x4(:,:,596))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(804),n2h1(708))
  call Hloop_VA_Q(ntryL,G1H4(250),wf4(:,10),G1H1(1),m3h4x1(:,101),heltab2x4(:,:,597))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(805),n2h1(709))
  call Hloop_ZA_Q(ntryL,G1H4(251),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,102),heltab2x4(:,:,598))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(806),n2h1(710))
  call Hloop_ZA_Q(ntryL,G1H4(252),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,103),heltab2x4(:,:,599))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(807),n2h1(711))
  call Hloop_ZA_Q(ntryL,G1H4(258),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,104),heltab2x4(:,:,600))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(808),n2h1(712))
  call Hloop_VA_Q(ntryL,G1H4(261),wf4(:,10),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,601))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(809),n2h1(713))
  call Hloop_VA_Q(ntryL,G1H4(262),wf4(:,10),G1H1(1),m3h4x1(:,106),heltab2x4(:,:,602))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(810),n2h1(714))
  call Hloop_VA_Q(ntryL,G1H4(268),wf4(:,10),G1H1(1),m3h4x1(:,107),heltab2x4(:,:,603))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(811),n2h1(715))
  call Hloop_VA_Q(ntryL,G1H4(270),wf4(:,10),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,604))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(812),n2h1(716))
  call Hloop_VA_Q(ntryL,G1H4(273),wf4(:,10),G1H1(1),m3h4x1(:,109),heltab2x4(:,:,605))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(813),n2h1(717))
  call Hloop_VA_Q(ntryL,G1H4(138),wf4(:,10),G1H1(1),m3h4x1(:,110),heltab2x4(:,:,606))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(814),n2h1(718))
  call Hloop_ZA_Q(ntryL,G1H4(168),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,111),heltab2x4(:,:,607))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(815),n2h1(719))
  call Hloop_ZA_Q(ntryL,G1H4(165),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,112),heltab2x4(:,:,608))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(816),n2h1(720))
  call Hloop_ZA_Q(ntryL,G1H4(282),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,113),heltab2x4(:,:,609))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(817),n2h1(721))
  call Hloop_ZA_Q(ntryL,G1H4(283),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,114),heltab2x4(:,:,610))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(818),n2h1(722))
  call Hloop_ZA_Q(ntryL,G1H4(284),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,115),heltab2x4(:,:,611))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(819),n2h1(723))
  call Hloop_ZA_Q(ntryL,G1H4(288),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,116),heltab2x4(:,:,612))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(820),n2h1(724))
  call Hloop_VQ_A(ntryL,G1H2(210),ex3(:),G1H1(1),m3h2x1(:,763),heltab2x2(:,:,763))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(821),n2h1(725))
  call Hloop_VQ_A(ntryL,G1H2(216),ex3(:),G1H1(1),m3h2x1(:,764),heltab2x2(:,:,764))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(822),n2h1(726))
  call Hloop_VQ_A(ntryL,G1H2(1164),ex3(:),G1H1(1),m3h2x1(:,765),heltab2x2(:,:,765))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(823),n2h1(727))
  call Hloop_VQ_A(ntryL,G1H2(1165),ex3(:),G1H1(1),m3h2x1(:,766),heltab2x2(:,:,766))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(824),n2h1(728))
  call Hloop_VQ_A(ntryL,G1H2(1166),ex3(:),G1H1(1),m3h2x1(:,767),heltab2x2(:,:,767))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(825),n2h1(729))
  call Hloop_VQ_A(ntryL,G1H2(1170),ex3(:),G1H1(1),m3h2x1(:,768),heltab2x2(:,:,768))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(826),n2h1(730))
  call Hloop_ZQ_A(ntryL,G1H2(1171),ex3(:),G1H1(1),ngZl,m3h2x1(:,769),heltab2x2(:,:,769))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(827),n2h1(731))
  call Hloop_ZQ_A(ntryL,G1H2(1172),ex3(:),G1H1(1),ngZl,m3h2x1(:,770),heltab2x2(:,:,770))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(828),n2h1(732))
  call Hloop_ZQ_A(ntryL,G1H2(1176),ex3(:),G1H1(1),ngZl,m3h2x1(:,771),heltab2x2(:,:,771))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(829),n2h1(733))
  call Hloop_ZQ_A(ntryL,G1H2(1177),ex3(:),G1H1(1),ngZl,m3h2x1(:,772),heltab2x2(:,:,772))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(830),n2h1(734))
  call Hloop_ZQ_A(ntryL,G1H2(1178),ex3(:),G1H1(1),ngZl,m3h2x1(:,773),heltab2x2(:,:,773))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(831),n2h1(735))
  call Hloop_ZQ_A(ntryL,G1H2(1182),ex3(:),G1H1(1),ngZl,m3h2x1(:,774),heltab2x2(:,:,774))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(832),n2h1(736))
  call Hloop_VQ_A(ntryL,G1H2(1183),ex3(:),G1H1(1),m3h2x1(:,775),heltab2x2(:,:,775))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(833),n2h1(737))
  call Hloop_VQ_A(ntryL,G1H2(1184),ex3(:),G1H1(1),m3h2x1(:,776),heltab2x2(:,:,776))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(834),n2h1(738))
  call Hloop_VQ_A(ntryL,G1H2(1188),ex3(:),G1H1(1),m3h2x1(:,777),heltab2x2(:,:,777))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(835),n2h1(739))
  call Hloop_ZQ_A(ntryL,G1H2(1189),ex3(:),G1H1(1),ngZl,m3h2x1(:,778),heltab2x2(:,:,778))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(836),n2h1(740))
  call Hloop_ZQ_A(ntryL,G1H2(1190),ex3(:),G1H1(1),ngZl,m3h2x1(:,779),heltab2x2(:,:,779))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(837),n2h1(741))
  call Hloop_ZQ_A(ntryL,G1H2(1194),ex3(:),G1H1(1),ngZl,m3h2x1(:,780),heltab2x2(:,:,780))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(838),n2h1(742))
  call Hloop_VQ_A(ntryL,G1H2(1195),ex3(:),G1H1(1),m3h2x1(:,781),heltab2x2(:,:,781))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(839),n2h1(743))
  call Hloop_VQ_A(ntryL,G1H2(1196),ex3(:),G1H1(1),m3h2x1(:,782),heltab2x2(:,:,782))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(840),n2h1(744))
  call Hloop_VQ_A(ntryL,G1H2(1200),ex3(:),G1H1(1),m3h2x1(:,783),heltab2x2(:,:,783))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(841),n2h1(745))
  call Hloop_ZQ_A(ntryL,G1H2(1201),ex3(:),G1H1(1),ngZl,m3h2x1(:,784),heltab2x2(:,:,784))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(842),n2h1(746))
  call Hloop_ZQ_A(ntryL,G1H2(1202),ex3(:),G1H1(1),ngZl,m3h2x1(:,785),heltab2x2(:,:,785))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(843),n2h1(747))
  call Hloop_ZQ_A(ntryL,G1H2(1206),ex3(:),G1H1(1),ngZl,m3h2x1(:,786),heltab2x2(:,:,786))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(844),n2h1(748))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1208),2,ex5(:),16,G2tensor(845),m3h2x1(:,787),heltab2x2(:,:,787))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1213),4,ex5(:),16,G2tensor(846),m3h2x1(:,788),heltab2x2(:,:,788))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1218),1,ex5(:),16,G2tensor(847),m3h2x1(:,789),heltab2x2(:,:,789))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1223),8,ex5(:),16,G2tensor(848),m3h2x1(:,790),heltab2x2(:,:,790))
  call Hloop_VA_Q(ntryL,G1H2(1227),ex4(:),G1H1(1),m3h2x1(:,791),heltab2x2(:,:,791))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(849),n2h1(753))
  call Hloop_VA_Q(ntryL,G1H2(1228),ex4(:),G1H1(1),m3h2x1(:,792),heltab2x2(:,:,792))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(850),n2h1(754))
  call Hloop_VA_Q(ntryL,G1H2(1233),ex4(:),G1H1(1),m3h2x1(:,793),heltab2x2(:,:,793))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(851),n2h1(755))
  call Hloop_VA_Q(ntryL,G1H2(1234),ex4(:),G1H1(1),m3h2x1(:,794),heltab2x2(:,:,794))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(852),n2h1(756))
  call Hloop_ZA_Q(ntryL,G1H2(1238),ex4(:),G1H1(1),ngZl,m3h2x1(:,795),heltab2x2(:,:,795))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(853),n2h1(757))
  call Hloop_ZA_Q(ntryL,G1H2(1239),ex4(:),G1H1(1),ngZl,m3h2x1(:,796),heltab2x2(:,:,796))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(854),n2h1(758))
  call Hloop_ZA_Q(ntryL,G1H2(1244),ex4(:),G1H1(1),ngZl,m3h2x1(:,797),heltab2x2(:,:,797))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(855),n2h1(759))
  call Hloop_ZA_Q(ntryL,G1H2(1245),ex4(:),G1H1(1),ngZl,m3h2x1(:,798),heltab2x2(:,:,798))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(856),n2h1(760))
  call Hloop_VQ_A(ntryL,G1H2(1249),ex3(:),G1H1(1),m3h2x1(:,799),heltab2x2(:,:,799))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(857),n2h1(761))
  call Hloop_VQ_A(ntryL,G1H2(1250),ex3(:),G1H1(1),m3h2x1(:,800),heltab2x2(:,:,800))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(858),n2h1(762))
  call Hloop_VQ_A(ntryL,G1H2(1255),ex3(:),G1H1(1),m3h2x1(:,801),heltab2x2(:,:,801))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(859),n2h1(763))
  call Hloop_VQ_A(ntryL,G1H2(1256),ex3(:),G1H1(1),m3h2x1(:,802),heltab2x2(:,:,802))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(860),n2h1(764))
  call Hloop_ZQ_A(ntryL,G1H2(1260),ex3(:),G1H1(1),ngZl,m3h2x1(:,803),heltab2x2(:,:,803))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(861),n2h1(765))
  call Hloop_ZQ_A(ntryL,G1H2(1261),ex3(:),G1H1(1),ngZl,m3h2x1(:,804),heltab2x2(:,:,804))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(862),n2h1(766))
  call Hloop_ZQ_A(ntryL,G1H2(1266),ex3(:),G1H1(1),ngZl,m3h2x1(:,805),heltab2x2(:,:,805))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(863),n2h1(767))
  call Hloop_ZQ_A(ntryL,G1H2(1267),ex3(:),G1H1(1),ngZl,m3h2x1(:,806),heltab2x2(:,:,806))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(864),n2h1(768))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1271),47,ex5(:),16,G2tensor(865),m3h2x1(:,807),heltab2x2(:,:,807))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1272),0,ex5(:),16,G2tensor(866),m3h2x1(:,808),heltab2x2(:,:,808))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1277),47,ex5(:),16,G2tensor(867),m3h2x1(:,809),heltab2x2(:,:,809))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1278),4,ex5(:),16,G2tensor(868),m3h2x1(:,810),heltab2x2(:,:,810))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1282),47,ex5(:),16,G2tensor(869),m3h2x1(:,811),heltab2x2(:,:,811))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1283),0,ex5(:),16,G2tensor(870),m3h2x1(:,812),heltab2x2(:,:,812))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1288),47,ex5(:),16,G2tensor(871),m3h2x1(:,813),heltab2x2(:,:,813))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1289),8,ex5(:),16,G2tensor(872),m3h2x1(:,814),heltab2x2(:,:,814))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1293),47,ex5(:),16,G2tensor(873),m3h2x1(:,815),heltab2x2(:,:,815))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1294),0,ex5(:),16,G2tensor(874),m3h2x1(:,816),heltab2x2(:,:,816))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1299),47,ex5(:),16,G2tensor(875),m3h2x1(:,817),heltab2x2(:,:,817))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1300),1,ex5(:),16,G2tensor(876),m3h2x1(:,818),heltab2x2(:,:,818))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1304),47,ex5(:),16,G2tensor(877),m3h2x1(:,819),heltab2x2(:,:,819))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1305),0,ex5(:),16,G2tensor(878),m3h2x1(:,820),heltab2x2(:,:,820))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1310),47,ex5(:),16,G2tensor(879),m3h2x1(:,821),heltab2x2(:,:,821))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1311),2,ex5(:),16,G2tensor(880),m3h2x1(:,822),heltab2x2(:,:,822))
  call Hloop_QV_A(ntryL,G1H2(1315),ex5(:),G1H1(1),m3h2x1(:,823),heltab2x2(:,:,823))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(881),n2h1(777))
  call Hloop_QV_A(ntryL,G1H2(1316),ex5(:),G1H1(1),m3h2x1(:,824),heltab2x2(:,:,824))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(882),n2h1(778))
  call Hloop_QV_A(ntryL,G1H2(1321),ex5(:),G1H1(1),m3h2x1(:,825),heltab2x2(:,:,825))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(883),n2h1(779))
  call Hloop_QV_A(ntryL,G1H2(1322),ex5(:),G1H1(1),m3h2x1(:,826),heltab2x2(:,:,826))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(884),n2h1(780))
  call Hloop_QV_A(ntryL,G1H2(1326),ex5(:),G1H1(1),m3h2x1(:,827),heltab2x2(:,:,827))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(885),n2h1(781))
  call Hloop_QV_A(ntryL,G1H2(1327),ex5(:),G1H1(1),m3h2x1(:,828),heltab2x2(:,:,828))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(886),n2h1(782))
  call Hloop_QV_A(ntryL,G1H2(1332),ex5(:),G1H1(1),m3h2x1(:,829),heltab2x2(:,:,829))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(887),n2h1(783))
  call Hloop_QV_A(ntryL,G1H2(1333),ex5(:),G1H1(1),m3h2x1(:,830),heltab2x2(:,:,830))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(888),n2h1(784))
  call Hloop_AV_Q(ntryL,G1H2(1337),ex5(:),G1H1(1),m3h2x1(:,831),heltab2x2(:,:,831))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(889),n2h1(785))
  call Hloop_AV_Q(ntryL,G1H2(1338),ex5(:),G1H1(1),m3h2x1(:,832),heltab2x2(:,:,832))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(890),n2h1(786))
  call Hloop_AV_Q(ntryL,G1H2(1343),ex5(:),G1H1(1),m3h2x1(:,833),heltab2x2(:,:,833))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(891),n2h1(787))
  call Hloop_AV_Q(ntryL,G1H2(1344),ex5(:),G1H1(1),m3h2x1(:,834),heltab2x2(:,:,834))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(892),n2h1(788))
  call Hloop_AV_Q(ntryL,G1H2(1348),ex5(:),G1H1(1),m3h2x1(:,835),heltab2x2(:,:,835))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(893),n2h1(789))
  call Hloop_AV_Q(ntryL,G1H2(1349),ex5(:),G1H1(1),m3h2x1(:,836),heltab2x2(:,:,836))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(894),n2h1(790))
  call Hloop_AV_Q(ntryL,G1H2(1354),ex5(:),G1H1(1),m3h2x1(:,837),heltab2x2(:,:,837))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(895),n2h1(791))
  call Hloop_AV_Q(ntryL,G1H2(1355),ex5(:),G1H1(1),m3h2x1(:,838),heltab2x2(:,:,838))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(896),n2h1(792))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1360),3,ex5(:),16,G2tensor(897),m3h2x1(:,839),heltab2x2(:,:,839))
  call Hloop_AV_Q(ntryL,G1H2(1364),ex5(:),G1H1(1),m3h2x1(:,840),heltab2x2(:,:,840))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(898),n2h1(794))
  call Hloop_AV_Q(ntryL,G1H2(1365),ex5(:),G1H1(1),m3h2x1(:,841),heltab2x2(:,:,841))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(899),n2h1(795))
  call Hloop_AV_Q(ntryL,G1H2(1370),ex5(:),G1H1(1),m3h2x1(:,842),heltab2x2(:,:,842))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(900),n2h1(796))
  call Hloop_AV_Q(ntryL,G1H2(1371),ex5(:),G1H1(1),m3h2x1(:,843),heltab2x2(:,:,843))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(901),n2h1(797))
  call Hloop_AV_Q(ntryL,G1H2(1375),ex5(:),G1H1(1),m3h2x1(:,844),heltab2x2(:,:,844))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(902),n2h1(798))
  call Hloop_AV_Q(ntryL,G1H2(1376),ex5(:),G1H1(1),m3h2x1(:,845),heltab2x2(:,:,845))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(903),n2h1(799))
  call Hloop_AV_Q(ntryL,G1H2(1381),ex5(:),G1H1(1),m3h2x1(:,846),heltab2x2(:,:,846))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(904),n2h1(800))
  call Hloop_AV_Q(ntryL,G1H2(1382),ex5(:),G1H1(1),m3h2x1(:,847),heltab2x2(:,:,847))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(905),n2h1(801))
  call Hloop_QV_A(ntryL,G1H2(1386),ex5(:),G1H1(1),m3h2x1(:,848),heltab2x2(:,:,848))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(906),n2h1(802))
  call Hloop_QV_A(ntryL,G1H2(1387),ex5(:),G1H1(1),m3h2x1(:,849),heltab2x2(:,:,849))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(907),n2h1(803))
  call Hloop_QV_A(ntryL,G1H2(1392),ex5(:),G1H1(1),m3h2x1(:,850),heltab2x2(:,:,850))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(908),n2h1(804))
  call Hloop_QV_A(ntryL,G1H2(1393),ex5(:),G1H1(1),m3h2x1(:,851),heltab2x2(:,:,851))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(909),n2h1(805))
  call Hloop_QV_A(ntryL,G1H2(1397),ex5(:),G1H1(1),m3h2x1(:,852),heltab2x2(:,:,852))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(910),n2h1(806))
  call Hloop_QV_A(ntryL,G1H2(1398),ex5(:),G1H1(1),m3h2x1(:,853),heltab2x2(:,:,853))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(911),n2h1(807))
  call Hloop_QV_A(ntryL,G1H2(1403),ex5(:),G1H1(1),m3h2x1(:,854),heltab2x2(:,:,854))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(912),n2h1(808))
  call Hloop_QV_A(ntryL,G1H2(1404),ex5(:),G1H1(1),m3h2x1(:,855),heltab2x2(:,:,855))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(913),n2h1(809))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1409),3,ex5(:),16,G2tensor(914),m3h2x1(:,856),heltab2x2(:,:,856))
  call Hloop_QV_A(ntryL,G1H4(289),wf4(:,13),G1H1(1),m3h4x1(:,117),heltab2x4(:,:,613))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(915),n2h1(811))
  call Hloop_QV_A(ntryL,G1H4(290),wf4(:,13),G1H1(1),m3h4x1(:,118),heltab2x4(:,:,614))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(916),n2h1(812))
  call Hloop_QV_A(ntryL,G1H4(295),wf4(:,13),G1H1(1),m3h4x1(:,119),heltab2x4(:,:,615))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(917),n2h1(813))
  call Hloop_QV_A(ntryL,G1H4(296),wf4(:,13),G1H1(1),m3h4x1(:,120),heltab2x4(:,:,616))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(918),n2h1(814))
  call Hloop_QV_A(ntryL,G1H4(300),wf4(:,13),G1H1(1),m3h4x1(:,121),heltab2x4(:,:,617))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(919),n2h1(815))
  call Hloop_QV_A(ntryL,G1H4(301),wf4(:,13),G1H1(1),m3h4x1(:,122),heltab2x4(:,:,618))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(920),n2h1(816))
  call Hloop_QV_A(ntryL,G1H4(306),wf4(:,13),G1H1(1),m3h4x1(:,123),heltab2x4(:,:,619))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(921),n2h1(817))
  call Hloop_QV_A(ntryL,G1H4(307),wf4(:,13),G1H1(1),m3h4x1(:,124),heltab2x4(:,:,620))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(922),n2h1(818))
  call Hloop_QZ_A(ntryL,G1H4(311),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,125),heltab2x4(:,:,621))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(923),n2h1(819))
  call Hloop_QZ_A(ntryL,G1H4(312),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,126),heltab2x4(:,:,622))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(924),n2h1(820))
  call Hloop_QZ_A(ntryL,G1H4(317),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,127),heltab2x4(:,:,623))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(925),n2h1(821))
  call Hloop_QZ_A(ntryL,G1H4(318),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,128),heltab2x4(:,:,624))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(926),n2h1(822))
  call Hloop_QZ_A(ntryL,G1H4(322),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,129),heltab2x4(:,:,625))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(927),n2h1(823))
  call Hloop_QZ_A(ntryL,G1H4(323),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,130),heltab2x4(:,:,626))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(928),n2h1(824))
  call Hloop_QZ_A(ntryL,G1H4(328),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,131),heltab2x4(:,:,627))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(929),n2h1(825))
  call Hloop_QZ_A(ntryL,G1H4(329),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,132),heltab2x4(:,:,628))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(930),n2h1(826))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(333),51,wf4(:,13),12,G2tensor(931),m3h4x1(:,133),heltab2x4(:,:,629))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(334),0,wf4(:,13),12,G2tensor(932),m3h4x1(:,134),heltab2x4(:,:,630))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(339),51,wf4(:,13),12,G2tensor(933),m3h4x1(:,135),heltab2x4(:,:,631))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(340),16,wf4(:,13),12,G2tensor(934),m3h4x1(:,136),heltab2x4(:,:,632))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(344),51,wf4(:,16),12,G2tensor(935),m3h4x1(:,137),heltab2x4(:,:,633))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(345),0,wf4(:,16),12,G2tensor(936),m3h4x1(:,138),heltab2x4(:,:,634))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(350),51,wf4(:,16),12,G2tensor(937),m3h4x1(:,139),heltab2x4(:,:,635))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(351),16,wf4(:,16),12,G2tensor(938),m3h4x1(:,140),heltab2x4(:,:,636))
  call Hloop_QV_A(ntryL,G1H2(1413),ex5(:),G1H1(1),m3h2x1(:,857),heltab2x2(:,:,857))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(939),n2h1(831))
  call Hloop_QV_A(ntryL,G1H2(1414),ex5(:),G1H1(1),m3h2x1(:,858),heltab2x2(:,:,858))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(940),n2h1(832))
  call Hloop_QV_A(ntryL,G1H2(1419),ex5(:),G1H1(1),m3h2x1(:,859),heltab2x2(:,:,859))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(941),n2h1(833))
  call Hloop_QV_A(ntryL,G1H2(1420),ex5(:),G1H1(1),m3h2x1(:,860),heltab2x2(:,:,860))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(942),n2h1(834))
  call Hloop_QV_A(ntryL,G1H2(1424),ex5(:),G1H1(1),m3h2x1(:,861),heltab2x2(:,:,861))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(943),n2h1(835))
  call Hloop_QV_A(ntryL,G1H2(1425),ex5(:),G1H1(1),m3h2x1(:,862),heltab2x2(:,:,862))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(944),n2h1(836))
  call Hloop_QV_A(ntryL,G1H2(1430),ex5(:),G1H1(1),m3h2x1(:,863),heltab2x2(:,:,863))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(945),n2h1(837))
  call Hloop_QV_A(ntryL,G1H2(1431),ex5(:),G1H1(1),m3h2x1(:,864),heltab2x2(:,:,864))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(946),n2h1(838))
  call Hloop_AV_Q(ntryL,G1H4(355),wf4(:,13),G1H1(1),m3h4x1(:,141),heltab2x4(:,:,637))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(947),n2h1(839))
  call Hloop_AV_Q(ntryL,G1H4(356),wf4(:,13),G1H1(1),m3h4x1(:,142),heltab2x4(:,:,638))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(948),n2h1(840))
  call Hloop_AV_Q(ntryL,G1H4(361),wf4(:,13),G1H1(1),m3h4x1(:,143),heltab2x4(:,:,639))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(949),n2h1(841))
  call Hloop_AV_Q(ntryL,G1H4(362),wf4(:,13),G1H1(1),m3h4x1(:,144),heltab2x4(:,:,640))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,0,G2tensor(950),n2h1(842))
  call Hloop_AV_Q(ntryL,G1H4(366),wf4(:,13),G1H1(1),m3h4x1(:,145),heltab2x4(:,:,641))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(951),n2h1(843))
  call Hloop_AV_Q(ntryL,G1H4(367),wf4(:,13),G1H1(1),m3h4x1(:,146),heltab2x4(:,:,642))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(952),n2h1(844))
  call Hloop_AV_Q(ntryL,G1H4(372),wf4(:,13),G1H1(1),m3h4x1(:,147),heltab2x4(:,:,643))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(953),n2h1(845))
  call Hloop_AV_Q(ntryL,G1H4(373),wf4(:,13),G1H1(1),m3h4x1(:,148),heltab2x4(:,:,644))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,0,G2tensor(954),n2h1(846))
  call Hloop_AZ_Q(ntryL,G1H4(377),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,149),heltab2x4(:,:,645))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(955),n2h1(847))
  call Hloop_AZ_Q(ntryL,G1H4(378),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,150),heltab2x4(:,:,646))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(956),n2h1(848))
  call Hloop_AZ_Q(ntryL,G1H4(383),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,151),heltab2x4(:,:,647))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(957),n2h1(849))
  call Hloop_AZ_Q(ntryL,G1H4(384),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,152),heltab2x4(:,:,648))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,0,G2tensor(958),n2h1(850))
  call Hloop_AZ_Q(ntryL,G1H4(388),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,153),heltab2x4(:,:,649))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(959),n2h1(851))
  call Hloop_AZ_Q(ntryL,G1H4(389),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,154),heltab2x4(:,:,650))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(960),n2h1(852))
  call Hloop_AZ_Q(ntryL,G1H4(394),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,155),heltab2x4(:,:,651))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(961),n2h1(853))
  call Hloop_AZ_Q(ntryL,G1H4(395),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,156),heltab2x4(:,:,652))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,0,G2tensor(962),n2h1(854))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(399),51,wf4(:,13),12,G2tensor(963),m3h4x1(:,157),heltab2x4(:,:,653))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(400),0,wf4(:,13),12,G2tensor(964),m3h4x1(:,158),heltab2x4(:,:,654))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(405),51,wf4(:,13),12,G2tensor(965),m3h4x1(:,159),heltab2x4(:,:,655))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(406),16,wf4(:,13),12,G2tensor(966),m3h4x1(:,160),heltab2x4(:,:,656))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(410),51,wf4(:,16),12,G2tensor(967),m3h4x1(:,161),heltab2x4(:,:,657))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(411),0,wf4(:,16),12,G2tensor(968),m3h4x1(:,162),heltab2x4(:,:,658))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(416),51,wf4(:,16),12,G2tensor(969),m3h4x1(:,163),heltab2x4(:,:,659))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(417),16,wf4(:,16),12,G2tensor(970),m3h4x1(:,164),heltab2x4(:,:,660))
  call Hloop_AV_Q(ntryL,G1H2(1435),ex5(:),G1H1(1),m3h2x1(:,865),heltab2x2(:,:,865))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(971),n2h1(859))
  call Hloop_AV_Q(ntryL,G1H2(1436),ex5(:),G1H1(1),m3h2x1(:,866),heltab2x2(:,:,866))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(972),n2h1(860))
  call Hloop_AV_Q(ntryL,G1H2(1441),ex5(:),G1H1(1),m3h2x1(:,867),heltab2x2(:,:,867))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(973),n2h1(861))
  call Hloop_AV_Q(ntryL,G1H2(1442),ex5(:),G1H1(1),m3h2x1(:,868),heltab2x2(:,:,868))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,0,G2tensor(974),n2h1(862))
  call Hloop_AV_Q(ntryL,G1H2(1446),ex5(:),G1H1(1),m3h2x1(:,869),heltab2x2(:,:,869))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(975),n2h1(863))
  call Hloop_AV_Q(ntryL,G1H2(1447),ex5(:),G1H1(1),m3h2x1(:,870),heltab2x2(:,:,870))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(976),n2h1(864))
  call Hloop_AV_Q(ntryL,G1H2(1452),ex5(:),G1H1(1),m3h2x1(:,871),heltab2x2(:,:,871))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(977),n2h1(865))
  call Hloop_AV_Q(ntryL,G1H2(1453),ex5(:),G1H1(1),m3h2x1(:,872),heltab2x2(:,:,872))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,0,G2tensor(978),n2h1(866))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1458),12,ex5(:),16,G2tensor(979),m3h2x1(:,873),heltab2x2(:,:,873))
  call Hloop_AV_Q(ntryL,G1H2(1462),ex5(:),G1H1(1),m3h2x1(:,874),heltab2x2(:,:,874))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(980),n2h1(868))
  call Hloop_AV_Q(ntryL,G1H2(1463),ex5(:),G1H1(1),m3h2x1(:,875),heltab2x2(:,:,875))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(981),n2h1(869))
  call Hloop_AV_Q(ntryL,G1H2(1468),ex5(:),G1H1(1),m3h2x1(:,876),heltab2x2(:,:,876))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(982),n2h1(870))
  call Hloop_AV_Q(ntryL,G1H2(1469),ex5(:),G1H1(1),m3h2x1(:,877),heltab2x2(:,:,877))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(983),n2h1(871))
  call Hloop_AV_Q(ntryL,G1H2(1473),ex5(:),G1H1(1),m3h2x1(:,878),heltab2x2(:,:,878))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(984),n2h1(872))
  call Hloop_AV_Q(ntryL,G1H2(1474),ex5(:),G1H1(1),m3h2x1(:,879),heltab2x2(:,:,879))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(985),n2h1(873))
  call Hloop_AV_Q(ntryL,G1H2(1479),ex5(:),G1H1(1),m3h2x1(:,880),heltab2x2(:,:,880))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(986),n2h1(874))
  call Hloop_AV_Q(ntryL,G1H2(1480),ex5(:),G1H1(1),m3h2x1(:,881),heltab2x2(:,:,881))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(987),n2h1(875))
  call Hloop_QV_A(ntryL,G1H2(1484),ex5(:),G1H1(1),m3h2x1(:,882),heltab2x2(:,:,882))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(988),n2h1(876))
  call Hloop_QV_A(ntryL,G1H2(1485),ex5(:),G1H1(1),m3h2x1(:,883),heltab2x2(:,:,883))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(989),n2h1(877))
  call Hloop_QV_A(ntryL,G1H2(1490),ex5(:),G1H1(1),m3h2x1(:,884),heltab2x2(:,:,884))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(990),n2h1(878))
  call Hloop_QV_A(ntryL,G1H2(1491),ex5(:),G1H1(1),m3h2x1(:,885),heltab2x2(:,:,885))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(991),n2h1(879))
  call Hloop_QV_A(ntryL,G1H2(1495),ex5(:),G1H1(1),m3h2x1(:,886),heltab2x2(:,:,886))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(992),n2h1(880))
  call Hloop_QV_A(ntryL,G1H2(1496),ex5(:),G1H1(1),m3h2x1(:,887),heltab2x2(:,:,887))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(993),n2h1(881))
  call Hloop_QV_A(ntryL,G1H2(1501),ex5(:),G1H1(1),m3h2x1(:,888),heltab2x2(:,:,888))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(994),n2h1(882))
  call Hloop_QV_A(ntryL,G1H2(1502),ex5(:),G1H1(1),m3h2x1(:,889),heltab2x2(:,:,889))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(995),n2h1(883))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1507),12,ex5(:),16,G2tensor(996),m3h2x1(:,890),heltab2x2(:,:,890))
  call ol_merge_tensors(G2tensor(71),[G2tensor(8),G1tensor(2)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(10),G1tensor(8)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(12),G1tensor(14)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(14),G1tensor(20)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(16),G1tensor(38)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(18),G1tensor(44)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(20),G1tensor(50)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(22),G1tensor(56)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(24),G1tensor(62)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(26),G1tensor(68)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(28),G1tensor(74)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(30),G1tensor(80)])
  call ol_merge_tensors(G2tensor(119),[G2tensor(32),G1tensor(86)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(34),G1tensor(92)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(36),G1tensor(98)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(38),G1tensor(104)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(40),G1tensor(110)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(42),G1tensor(116)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(44),G1tensor(122)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(46),G1tensor(128)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(48),G1tensor(134)])
  call ol_merge_tensors(G2tensor(233),[G2tensor(50),G1tensor(140)])
  call ol_merge_tensors(G2tensor(239),[G2tensor(52),G1tensor(146)])
  call ol_merge_tensors(G2tensor(242),[G2tensor(54),G1tensor(152)])
  call ol_merge_tensors(G2tensor(245),[G2tensor(56),G1tensor(158)])
  call ol_merge_tensors(G2tensor(251),[G2tensor(58),G1tensor(164)])
  call ol_merge_tensors(G2tensor(254),[G2tensor(60),G1tensor(170)])
  call ol_merge_tensors(G2tensor(260),[G2tensor(62),G1tensor(176)])
  call ol_merge_tensors(G2tensor(263),[G2tensor(64),G1tensor(182)])
  call ol_merge_tensors(G2tensor(269),[G2tensor(66),G1tensor(188)])
  call ol_merge_tensors(G2tensor(272),[G2tensor(68),G1tensor(194)])
  call ol_merge_tensors(G2tensor(278),[G2tensor(70),G1tensor(200)])
  call ol_merge_tensors(G2tensor(281),[G2tensor(72),G1tensor(206)])
  call ol_merge_tensors(G2tensor(287),[G2tensor(74),G1tensor(212)])
  call ol_merge_tensors(G2tensor(293),[G2tensor(76),G1tensor(218)])
  call ol_merge_tensors(G2tensor(296),[G2tensor(78),G1tensor(224)])
  call ol_merge_tensors(G2tensor(299),[G2tensor(80),G1tensor(230)])
  call ol_merge_tensors(G2tensor(305),[G2tensor(82),G1tensor(236)])
  call ol_merge_tensors(G2tensor(311),[G2tensor(84),G1tensor(242)])
  call ol_merge_tensors(G2tensor(314),[G2tensor(86),G1tensor(248)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(88),G1tensor(254)])
  call ol_merge_tensors(G2tensor(323),[G2tensor(90),G1tensor(260)])
  call ol_merge_tensors(G2tensor(326),[G2tensor(92),G1tensor(266)])
  call ol_merge_tensors(G2tensor(332),[G2tensor(94),G1tensor(272)])
  call ol_merge_tensors(G2tensor(335),[G2tensor(96),G1tensor(278)])
  call ol_merge_tensors(G2tensor(341),[G2tensor(98),G1tensor(284)])
  call ol_merge_tensors(G2tensor(347),[G2tensor(100),G1tensor(290)])
  call ol_merge_tensors(G2tensor(350),[G2tensor(102),G1tensor(296)])
  call ol_merge_tensors(G2tensor(353),[G2tensor(104),G1tensor(302)])
  call ol_merge_tensors(G2tensor(359),[G2tensor(106),G1tensor(308)])
  call ol_merge_tensors(G2tensor(362),[G2tensor(108),G1tensor(314)])
  call ol_merge_tensors(G2tensor(368),[G2tensor(110),G1tensor(320)])
  call ol_merge_tensors(G2tensor(377),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(380),[G2tensor(59),G1tensor(4)])
  call ol_merge_tensors(G2tensor(383),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(167),[G2tensor(6),G2tensor(5),G2tensor(13),G1tensor(6)])
  call ol_merge_tensors(G2tensor(386),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(389),[G2tensor(11),G1tensor(10)])
  call ol_merge_tensors(G2tensor(392),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(170),[G2tensor(65),G2tensor(63),G2tensor(61),G1tensor(12)])
  call ol_merge_tensors(G2tensor(395),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(398),[G2tensor(39),G1tensor(16)])
  call ol_merge_tensors(G2tensor(401),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(173),[G2tensor(21),G2tensor(19),G2tensor(17),G1tensor(18)])
  call ol_merge_tensors(G2tensor(404),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(407),[G2tensor(15),G1tensor(22)])
  call ol_merge_tensors(G2tensor(410),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(57),G2tensor(55),G2tensor(53),G1tensor(24)])
  call ol_merge_tensors(G2tensor(371),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(135),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(374),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(141),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(413),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(416),[G1tensor(52),G1tensor(40)])
  call ol_merge_tensors(G2tensor(419),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(179),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(422),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(425),[G1tensor(58),G1tensor(46)])
  call ol_merge_tensors(G2tensor(428),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(182),[G1tensor(48)])
  call ol_merge_tensors(G2tensor(431),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(434),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(185),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(437),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(440),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(188),[G1tensor(60)])
  call ol_merge_tensors(G2tensor(443),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(446),[G1tensor(76),G1tensor(64)])
  call ol_merge_tensors(G2tensor(449),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(191),[G1tensor(66)])
  call ol_merge_tensors(G2tensor(452),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(455),[G1tensor(82),G1tensor(70)])
  call ol_merge_tensors(G2tensor(458),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(194),[G1tensor(72)])
  call ol_merge_tensors(G2tensor(461),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(464),[G1tensor(77)])
  call ol_merge_tensors(G2tensor(197),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(467),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(470),[G1tensor(83)])
  call ol_merge_tensors(G2tensor(200),[G1tensor(84)])
  call ol_merge_tensors(G2tensor(473),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(476),[G1tensor(94),G1tensor(88)])
  call ol_merge_tensors(G2tensor(479),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(203),[G1tensor(90)])
  call ol_merge_tensors(G2tensor(482),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(485),[G1tensor(95)])
  call ol_merge_tensors(G2tensor(206),[G1tensor(96)])
  call ol_merge_tensors(G2tensor(488),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(491),[G1tensor(106),G1tensor(100)])
  call ol_merge_tensors(G2tensor(494),[G1tensor(101)])
  call ol_merge_tensors(G2tensor(209),[G1tensor(102)])
  call ol_merge_tensors(G2tensor(497),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(500),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(212),[G1tensor(108)])
  call ol_merge_tensors(G2tensor(503),[G1tensor(111)])
  call ol_merge_tensors(G2tensor(506),[G1tensor(124),G1tensor(112)])
  call ol_merge_tensors(G2tensor(509),[G1tensor(113)])
  call ol_merge_tensors(G2tensor(215),[G1tensor(114)])
  call ol_merge_tensors(G2tensor(512),[G1tensor(117)])
  call ol_merge_tensors(G2tensor(515),[G1tensor(130),G1tensor(118)])
  call ol_merge_tensors(G2tensor(518),[G1tensor(119)])
  call ol_merge_tensors(G2tensor(218),[G1tensor(120)])
  call ol_merge_tensors(G2tensor(521),[G1tensor(123)])
  call ol_merge_tensors(G2tensor(524),[G1tensor(125)])
  call ol_merge_tensors(G2tensor(221),[G1tensor(126)])
  call ol_merge_tensors(G2tensor(527),[G1tensor(129)])
  call ol_merge_tensors(G2tensor(530),[G1tensor(131)])
  call ol_merge_tensors(G2tensor(224),[G1tensor(132)])
  call ol_merge_tensors(G2tensor(533),[G1tensor(135)])
  call ol_merge_tensors(G2tensor(536),[G1tensor(142),G1tensor(136)])
  call ol_merge_tensors(G2tensor(539),[G1tensor(185),G1tensor(137)])
  call ol_merge_tensors(G2tensor(230),[G1tensor(150),G1tensor(138)])
  call ol_merge_tensors(G2tensor(542),[G1tensor(141)])
  call ol_merge_tensors(G2tensor(545),[G1tensor(197),G1tensor(143)])
  call ol_merge_tensors(G2tensor(236),[G1tensor(156),G1tensor(144)])
  call ol_merge_tensors(G2tensor(548),[G1tensor(147)])
  call ol_merge_tensors(G2tensor(551),[G1tensor(154),G1tensor(148)])
  call ol_merge_tensors(G2tensor(554),[G1tensor(191),G1tensor(149)])
  call ol_merge_tensors(G2tensor(557),[G1tensor(153)])
  call ol_merge_tensors(G2tensor(560),[G1tensor(203),G1tensor(155)])
  call ol_merge_tensors(G2tensor(563),[G1tensor(159)])
  call ol_merge_tensors(G2tensor(566),[G1tensor(172),G1tensor(160)])
  call ol_merge_tensors(G2tensor(569),[G1tensor(209),G1tensor(161)])
  call ol_merge_tensors(G2tensor(248),[G1tensor(168),G1tensor(162)])
  call ol_merge_tensors(G2tensor(572),[G1tensor(165)])
  call ol_merge_tensors(G2tensor(575),[G1tensor(178),G1tensor(166)])
  call ol_merge_tensors(G2tensor(578),[G1tensor(221),G1tensor(167)])
  call ol_merge_tensors(G2tensor(581),[G1tensor(171)])
  call ol_merge_tensors(G2tensor(584),[G1tensor(215),G1tensor(173)])
  call ol_merge_tensors(G2tensor(257),[G1tensor(180),G1tensor(174)])
  call ol_merge_tensors(G2tensor(587),[G1tensor(177)])
  call ol_merge_tensors(G2tensor(590),[G1tensor(227),G1tensor(179)])
  call ol_merge_tensors(G2tensor(593),[G1tensor(183)])
  call ol_merge_tensors(G2tensor(596),[G1tensor(196),G1tensor(184)])
  call ol_merge_tensors(G2tensor(266),[G1tensor(192),G1tensor(186)])
  call ol_merge_tensors(G2tensor(599),[G1tensor(189)])
  call ol_merge_tensors(G2tensor(602),[G1tensor(202),G1tensor(190)])
  call ol_merge_tensors(G2tensor(605),[G1tensor(195)])
  call ol_merge_tensors(G2tensor(275),[G1tensor(204),G1tensor(198)])
  call ol_merge_tensors(G2tensor(608),[G1tensor(201)])
  call ol_merge_tensors(G2tensor(611),[G1tensor(207)])
  call ol_merge_tensors(G2tensor(614),[G1tensor(214),G1tensor(208)])
  call ol_merge_tensors(G2tensor(284),[G1tensor(222),G1tensor(210)])
  call ol_merge_tensors(G2tensor(617),[G1tensor(213)])
  call ol_merge_tensors(G2tensor(290),[G1tensor(228),G1tensor(216)])
  call ol_merge_tensors(G2tensor(620),[G1tensor(219)])
  call ol_merge_tensors(G2tensor(623),[G1tensor(226),G1tensor(220)])
  call ol_merge_tensors(G2tensor(626),[G1tensor(225)])
  call ol_merge_tensors(G2tensor(629),[G1tensor(231)])
  call ol_merge_tensors(G2tensor(632),[G1tensor(238),G1tensor(232)])
  call ol_merge_tensors(G2tensor(635),[G1tensor(281),G1tensor(233)])
  call ol_merge_tensors(G2tensor(302),[G1tensor(246),G1tensor(234)])
  call ol_merge_tensors(G2tensor(638),[G1tensor(237)])
  call ol_merge_tensors(G2tensor(641),[G1tensor(287),G1tensor(239)])
  call ol_merge_tensors(G2tensor(308),[G1tensor(252),G1tensor(240)])
  call ol_merge_tensors(G2tensor(644),[G1tensor(243)])
  call ol_merge_tensors(G2tensor(647),[G1tensor(250),G1tensor(244)])
  call ol_merge_tensors(G2tensor(650),[G1tensor(293),G1tensor(245)])
  call ol_merge_tensors(G2tensor(653),[G1tensor(249)])
  call ol_merge_tensors(G2tensor(656),[G1tensor(299),G1tensor(251)])
  call ol_merge_tensors(G2tensor(659),[G1tensor(255)])
  call ol_merge_tensors(G2tensor(662),[G1tensor(268),G1tensor(256)])
  call ol_merge_tensors(G2tensor(665),[G1tensor(305),G1tensor(257)])
  call ol_merge_tensors(G2tensor(320),[G1tensor(264),G1tensor(258)])
  call ol_merge_tensors(G2tensor(668),[G1tensor(261)])
  call ol_merge_tensors(G2tensor(671),[G1tensor(274),G1tensor(262)])
  call ol_merge_tensors(G2tensor(674),[G1tensor(311),G1tensor(263)])
  call ol_merge_tensors(G2tensor(677),[G1tensor(267)])
  call ol_merge_tensors(G2tensor(680),[G1tensor(317),G1tensor(269)])
  call ol_merge_tensors(G2tensor(329),[G1tensor(276),G1tensor(270)])
  call ol_merge_tensors(G2tensor(683),[G1tensor(273)])
  call ol_merge_tensors(G2tensor(686),[G1tensor(323),G1tensor(275)])
  call ol_merge_tensors(G2tensor(689),[G1tensor(279)])
  call ol_merge_tensors(G2tensor(692),[G1tensor(286),G1tensor(280)])
  call ol_merge_tensors(G2tensor(338),[G1tensor(294),G1tensor(282)])
  call ol_merge_tensors(G2tensor(695),[G1tensor(285)])
  call ol_merge_tensors(G2tensor(344),[G1tensor(300),G1tensor(288)])
  call ol_merge_tensors(G2tensor(698),[G1tensor(291)])
  call ol_merge_tensors(G2tensor(701),[G1tensor(298),G1tensor(292)])
  call ol_merge_tensors(G2tensor(704),[G1tensor(297)])
  call ol_merge_tensors(G2tensor(707),[G1tensor(303)])
  call ol_merge_tensors(G2tensor(710),[G1tensor(316),G1tensor(304)])
  call ol_merge_tensors(G2tensor(356),[G1tensor(312),G1tensor(306)])
  call ol_merge_tensors(G2tensor(713),[G1tensor(309)])
  call ol_merge_tensors(G2tensor(716),[G1tensor(322),G1tensor(310)])
  call ol_merge_tensors(G2tensor(719),[G1tensor(315)])
  call ol_merge_tensors(G2tensor(365),[G1tensor(324),G1tensor(318)])
  call ol_merge_tensors(G2tensor(722),[G1tensor(321)])
  call ol_merge_tensors(G2tensor(865),[G2tensor(23)])
  call ol_merge_tensors(G2tensor(869),[G2tensor(25)])
  call ol_merge_tensors(G2tensor(935),[G2tensor(931),G2tensor(37),G2tensor(35),G2tensor(33),G2tensor(31),G2tensor(29) &
    ,G2tensor(27)])
  call ol_merge_tensors(G2tensor(967),[G2tensor(963),G2tensor(51),G2tensor(49),G2tensor(47),G2tensor(45),G2tensor(43) &
    ,G2tensor(41)])
  call ol_merge_tensors(G2tensor(873),[G2tensor(67)])
  call ol_merge_tensors(G2tensor(877),[G2tensor(69)])
  call ol_merge_tensors(G2tensor(923),[G2tensor(915)])
  call ol_merge_tensors(G2tensor(927),[G2tensor(919)])
  call ol_merge_tensors(G2tensor(955),[G2tensor(947)])
  call ol_merge_tensors(G2tensor(959),[G2tensor(951)])
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(31),mass5set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(32),mass5set(:,1),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(33),mass5set(:,1),  & 
G1tensor(73),G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103))
  call G_TensorShift(G1tensor(79),1)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(35),mass5set(:,1),  & 
G1tensor(109),G1tensor(115),G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139))
  call G_TensorShift(G1tensor(115),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(37),mass5set(:,3),  & 
G1tensor(145),G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(151),2)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(37),mass5set(:,10),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205),G1tensor(211))
  call G_TensorShift(G1tensor(187),2)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(37),mass5set(:,4),  & 
G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235),G1tensor(241),G1tensor(247))
  call G_TensorShift(G1tensor(223),2)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(37),mass5set(:,11),  & 
G1tensor(253),G1tensor(259),G1tensor(265),G1tensor(271),G1tensor(277),G1tensor(283))
  call G_TensorShift(G1tensor(259),2)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(38),mass5set(:,3),  & 
G1tensor(289),G1tensor(295),G1tensor(301),G1tensor(307),G1tensor(313),G1tensor(319))
  call G_TensorShift(G1tensor(295),8)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(38),mass5set(:,10),  & 
G1tensor(2),G1tensor(8),G1tensor(14),G1tensor(20),G1tensor(38),G1tensor(44))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(38),mass5set(:,4),  & 
G1tensor(50),G1tensor(56),G1tensor(62),G1tensor(68),G1tensor(74),G1tensor(80))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(38),mass5set(:,11),  & 
G1tensor(86),G1tensor(92),G1tensor(98),G1tensor(104),G1tensor(110),G1tensor(116))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(39),mass5set(:,3),  & 
G1tensor(122),G1tensor(128),G1tensor(134),G1tensor(140),G1tensor(146),G1tensor(152))
  call G_TensorShift(G1tensor(128),1)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(39),mass5set(:,4),  & 
G1tensor(158),G1tensor(164),G1tensor(170),G1tensor(176),G1tensor(182),G1tensor(188))
  call G_TensorShift(G1tensor(164),1)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(39),mass5set(:,10),  & 
G1tensor(194),G1tensor(200),G1tensor(206),G1tensor(212),G1tensor(218),G1tensor(224))
  call G_TensorShift(G1tensor(200),1)
  call Hotf_5pt_reduction_last(G2tensor(125),RedSet_5(39),mass5set(:,11),  & 
G1tensor(230),G1tensor(236),G1tensor(242),G1tensor(248),G1tensor(254),G1tensor(260))
  call G_TensorShift(G1tensor(236),1)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(40),mass5set(:,3),  & 
G1tensor(266),G1tensor(272),G1tensor(278),G1tensor(284),G1tensor(290),G1tensor(296))
  call G_TensorShift(G1tensor(272),4)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(40),mass5set(:,10),  & 
G1tensor(302),G1tensor(308),G1tensor(314),G1tensor(320),G1tensor(3),G1tensor(4))
  call G_TensorShift(G1tensor(308),4)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(40),mass5set(:,4),  & 
G1tensor(5),G1tensor(6),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(6),4)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(40),mass5set(:,11),  & 
G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(21),G1tensor(22))
  call G_TensorShift(G1tensor(16),4)
  call Hotf_5pt_reduction_last(G2tensor(227),RedSet_5(53),mass5set(:,3),  & 
G1tensor(23),G1tensor(24),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29))
  call G_TensorShift(G1tensor(24),4)
  call Hotf_5pt_reduction_last(G2tensor(233),RedSet_5(53),mass5set(:,4),  & 
G1tensor(30),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(239),RedSet_5(53),mass5set(:,5),  & 
G1tensor(39),G1tensor(52),G1tensor(40),G1tensor(41),G1tensor(42),G1tensor(45))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_5pt_reduction_last(G2tensor(242),RedSet_5(53),mass5set(:,6),  & 
G1tensor(58),G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(51),G1tensor(53))
  call G_TensorShift(G1tensor(46),4)
  call Hotf_5pt_reduction_last(G2tensor(245),RedSet_5(55),mass5set(:,3),  & 
G1tensor(54),G1tensor(57),G1tensor(59),G1tensor(60),G1tensor(63),G1tensor(76))
  call G_TensorShift(G1tensor(57),8)
  call Hotf_5pt_reduction_last(G2tensor(251),RedSet_5(55),mass5set(:,5),  & 
G1tensor(64),G1tensor(65),G1tensor(66),G1tensor(69),G1tensor(82),G1tensor(70))
  call G_TensorShift(G1tensor(65),8)
  call Hotf_5pt_reduction_last(G2tensor(254),RedSet_5(55),mass5set(:,4),  & 
G1tensor(71),G1tensor(72),G1tensor(75),G1tensor(77),G1tensor(78),G1tensor(81))
  call G_TensorShift(G1tensor(72),8)
  call Hotf_5pt_reduction_last(G2tensor(260),RedSet_5(55),mass5set(:,6),  & 
G1tensor(83),G1tensor(84),G1tensor(87),G1tensor(94),G1tensor(88),G1tensor(89))
  call G_TensorShift(G1tensor(84),8)
  call Hotf_5pt_reduction_last(G2tensor(263),RedSet_5(57),mass5set(:,3),  & 
G1tensor(90),G1tensor(93),G1tensor(95),G1tensor(96),G1tensor(99),G1tensor(106))
  call G_TensorShift(G1tensor(93),4)
  call Hotf_5pt_reduction_last(G2tensor(269),RedSet_5(57),mass5set(:,5),  & 
G1tensor(100),G1tensor(101),G1tensor(102),G1tensor(105),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(101),4)
  call Hotf_5pt_reduction_last(G2tensor(272),RedSet_5(57),mass5set(:,4),  & 
G1tensor(111),G1tensor(124),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(117))
  call G_TensorShift(G1tensor(124),4)
  call Hotf_5pt_reduction_last(G2tensor(278),RedSet_5(57),mass5set(:,6),  & 
G1tensor(130),G1tensor(118),G1tensor(119),G1tensor(120),G1tensor(123),G1tensor(125))
  call G_TensorShift(G1tensor(118),4)
  call Hotf_5pt_reduction_last(G2tensor(281),RedSet_5(59),mass5set(:,3),  & 
G1tensor(126),G1tensor(129),G1tensor(131),G1tensor(132),G1tensor(135),G1tensor(142))
  call G_TensorShift(G1tensor(129),8)
  call Hotf_5pt_reduction_last(G2tensor(287),RedSet_5(59),mass5set(:,4),  & 
G1tensor(136),G1tensor(185),G1tensor(137),G1tensor(150),G1tensor(138),G1tensor(141))
  call G_TensorShift(G1tensor(185),8)
  call Hotf_5pt_reduction_last(G2tensor(293),RedSet_5(59),mass5set(:,5),  & 
G1tensor(197),G1tensor(143),G1tensor(156),G1tensor(144),G1tensor(147),G1tensor(154))
  call G_TensorShift(G1tensor(143),8)
  call Hotf_5pt_reduction_last(G2tensor(296),RedSet_5(59),mass5set(:,6),  & 
G1tensor(148),G1tensor(191),G1tensor(149),G1tensor(153),G1tensor(203),G1tensor(155))
  call G_TensorShift(G1tensor(191),8)
  call Hotf_5pt_reduction_last(G2tensor(299),RedSet_5(61),mass5set(:,3),  & 
G1tensor(159),G1tensor(172),G1tensor(160),G1tensor(209),G1tensor(161),G1tensor(168))
  call G_TensorShift(G1tensor(172),1)
  call Hotf_5pt_reduction_last(G2tensor(305),RedSet_5(61),mass5set(:,4),  & 
G1tensor(162),G1tensor(165),G1tensor(178),G1tensor(166),G1tensor(221),G1tensor(167))
  call G_TensorShift(G1tensor(165),1)
  call Hotf_5pt_reduction_last(G2tensor(311),RedSet_5(61),mass5set(:,5),  & 
G1tensor(171),G1tensor(215),G1tensor(173),G1tensor(180),G1tensor(174),G1tensor(177))
  call G_TensorShift(G1tensor(215),1)
  call Hotf_5pt_reduction_last(G2tensor(314),RedSet_5(61),mass5set(:,6),  & 
G1tensor(227),G1tensor(179),G1tensor(183),G1tensor(196),G1tensor(184),G1tensor(192))
  call G_TensorShift(G1tensor(179),1)
  call Hotf_5pt_reduction_last(G2tensor(317),RedSet_5(63),mass5set(:,3),  & 
G1tensor(186),G1tensor(189),G1tensor(202),G1tensor(190),G1tensor(195),G1tensor(204))
  call G_TensorShift(G1tensor(189),2)
  call Hotf_5pt_reduction_last(G2tensor(323),RedSet_5(63),mass5set(:,5),  & 
G1tensor(198),G1tensor(201),G1tensor(207),G1tensor(214),G1tensor(208),G1tensor(222))
  call G_TensorShift(G1tensor(201),2)
  call Hotf_5pt_reduction_last(G2tensor(326),RedSet_5(63),mass5set(:,4),  & 
G1tensor(210),G1tensor(213),G1tensor(228),G1tensor(216),G1tensor(219),G1tensor(226))
  call G_TensorShift(G1tensor(213),2)
  call Hotf_5pt_reduction_last(G2tensor(332),RedSet_5(63),mass5set(:,6),  & 
G1tensor(220),G1tensor(225),G1tensor(231),G1tensor(238),G1tensor(232),G1tensor(281))
  call G_TensorShift(G1tensor(225),2)
  call Hotf_5pt_reduction_last(G2tensor(335),RedSet_5(65),mass5set(:,3),  & 
G1tensor(233),G1tensor(246),G1tensor(234),G1tensor(237),G1tensor(287),G1tensor(239))
  call G_TensorShift(G1tensor(246),1)
  call Hotf_5pt_reduction_last(G2tensor(341),RedSet_5(65),mass5set(:,4),  & 
G1tensor(252),G1tensor(240),G1tensor(243),G1tensor(250),G1tensor(244),G1tensor(293))
  call G_TensorShift(G1tensor(240),1)
  call Hotf_5pt_reduction_last(G2tensor(347),RedSet_5(65),mass5set(:,5),  & 
G1tensor(245),G1tensor(249),G1tensor(299),G1tensor(251),G1tensor(255),G1tensor(268))
  call G_TensorShift(G1tensor(249),1)
  call Hotf_5pt_reduction_last(G2tensor(350),RedSet_5(65),mass5set(:,6),  & 
G1tensor(256),G1tensor(305),G1tensor(257),G1tensor(264),G1tensor(258),G1tensor(261))
  call G_TensorShift(G1tensor(305),1)
  call Hotf_5pt_reduction_last(G2tensor(353),RedSet_5(67),mass5set(:,3),  & 
G1tensor(274),G1tensor(262),G1tensor(311),G1tensor(263),G1tensor(267),G1tensor(317))
  call G_TensorShift(G1tensor(262),2)
  call Hotf_5pt_reduction_last(G2tensor(359),RedSet_5(67),mass5set(:,5),  & 
G1tensor(269),G1tensor(276),G1tensor(270),G1tensor(273),G1tensor(323),G1tensor(275))
  call G_TensorShift(G1tensor(276),2)
  call Hotf_5pt_reduction_last(G2tensor(362),RedSet_5(67),mass5set(:,4),  & 
G1tensor(279),G1tensor(286),G1tensor(280),G1tensor(294),G1tensor(282),G1tensor(285))
  call G_TensorShift(G1tensor(286),2)
  call Hotf_5pt_reduction_last(G2tensor(368),RedSet_5(67),mass5set(:,6),  & 
G1tensor(300),G1tensor(288),G1tensor(291),G1tensor(298),G1tensor(292),G1tensor(297))
  call G_TensorShift(G1tensor(288),2)
  call Hotf_5pt_reduction_last(G2tensor(377),RedSet_5(71),mass5set(:,15),  & 
G1tensor(303),G1tensor(316),G1tensor(304),G1tensor(312),G1tensor(306),G1tensor(309))
  call G_TensorShift(G1tensor(316),16)
  call Hotf_5pt_reduction_last(G2tensor(380),RedSet_5(21),mass5set(:,7),  & 
G1tensor(322),G1tensor(310),G1tensor(315),G1tensor(324),G1tensor(318),G1tensor(321))
  call G_TensorShift(G1tensor(310),16)
  call Hotf_5pt_reduction_last(G2tensor(383),RedSet_5(72),mass5set(:,9),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),16)
  call Hotf_5pt_reduction_last(G2tensor(167),RedSet_5(43),mass5set(:,2),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),16)
  call Hotf_5pt_reduction_last(G2tensor(386),RedSet_5(73),mass5set(:,15),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),16)
  call Hotf_5pt_reduction_last(G2tensor(389),RedSet_5(22),mass5set(:,7),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),16)
  call Hotf_5pt_reduction_last(G2tensor(392),RedSet_5(74),mass5set(:,9),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),16)
  call Hotf_5pt_reduction_last(G2tensor(170),RedSet_5(46),mass5set(:,2),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),16)
  call Hotf_5pt_reduction_last(G2tensor(395),RedSet_5(75),mass5set(:,15),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),16)
  call Hotf_5pt_reduction_last(G2tensor(398),RedSet_5(23),mass5set(:,7),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),16)
  call Hotf_5pt_reduction_last(G2tensor(401),RedSet_5(76),mass5set(:,9),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(173),RedSet_5(44),mass5set(:,2),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),16)
  call Hotf_5pt_reduction_last(G2tensor(404),RedSet_5(77),mass5set(:,15),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),16)
  call Hotf_5pt_reduction_last(G2tensor(407),RedSet_5(25),mass5set(:,7),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),16)
  call Hotf_5pt_reduction_last(G2tensor(410),RedSet_5(78),mass5set(:,9),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),16)
  call Hotf_5pt_reduction_last(G2tensor(176),RedSet_5(45),mass5set(:,2),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),16)
  call Hotf_5pt_reduction_last(G2tensor(371),RedSet_5(69),mass5set(:,14),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),8)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(41),mass5set(:,12),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),4)
  call Hotf_5pt_reduction_last(G2tensor(137),RedSet_5(24),mass5set(:,8),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(422),4)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(34),mass5set(:,1),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(428),4)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(19),mass5set(:,1),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437),G1tensor(438))
  call G_TensorShift(G1tensor(434),4)
  call Hotf_5pt_reduction_last(G2tensor(374),RedSet_5(70),mass5set(:,14),  & 
G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444))
  call G_TensorShift(G1tensor(440),4)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(42),mass5set(:,12),  & 
G1tensor(445),G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(446),8)
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(26),mass5set(:,8),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(452),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(36),mass5set(:,1),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(458),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(20),mass5set(:,1),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G1tensor(468))
  call G_TensorShift(G1tensor(464),8)
  call Hotf_5pt_reduction_last(G2tensor(413),RedSet_5(79),mass5set(:,3),  & 
G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(470),8)
  call Hotf_5pt_reduction_last(G2tensor(416),RedSet_5(80),mass5set(:,3),  & 
G1tensor(475),G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(476),8)
  call Hotf_5pt_reduction_last(G2tensor(419),RedSet_5(81),mass5set(:,3),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(482),8)
  call Hotf_5pt_reduction_last(G2tensor(179),RedSet_5(49),mass5set(:,3),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(488),8)
  call Hotf_5pt_reduction_last(G2tensor(422),RedSet_5(79),mass5set(:,5),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497),G1tensor(498))
  call G_TensorShift(G1tensor(494),8)
  call Hotf_5pt_reduction_last(G2tensor(425),RedSet_5(80),mass5set(:,5),  & 
G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504))
  call G_TensorShift(G1tensor(500),8)
  call Hotf_5pt_reduction_last(G2tensor(428),RedSet_5(81),mass5set(:,5),  & 
G1tensor(505),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(506),8)
  call Hotf_5pt_reduction_last(G2tensor(182),RedSet_5(49),mass5set(:,5),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(512),8)
  call Hotf_5pt_reduction_last(G2tensor(431),RedSet_5(79),mass5set(:,16),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(518),8)
  call Hotf_5pt_reduction_last(G2tensor(434),RedSet_5(81),mass5set(:,4),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527),G1tensor(528))
  call G_TensorShift(G1tensor(524),8)
  call Hotf_5pt_reduction_last(G2tensor(185),RedSet_5(49),mass5set(:,4),  & 
G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534))
  call G_TensorShift(G1tensor(530),8)
  call Hotf_5pt_reduction_last(G2tensor(437),RedSet_5(79),mass5set(:,17),  & 
G1tensor(535),G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(536),8)
  call Hotf_5pt_reduction_last(G2tensor(440),RedSet_5(81),mass5set(:,6),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(542),8)
  call Hotf_5pt_reduction_last(G2tensor(188),RedSet_5(49),mass5set(:,6),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(548),8)
  call Hotf_5pt_reduction_last(G2tensor(443),RedSet_5(82),mass5set(:,3),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557),G1tensor(558))
  call G_TensorShift(G1tensor(554),2)
  call Hotf_5pt_reduction_last(G2tensor(446),RedSet_5(83),mass5set(:,3),  & 
G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564))
  call G_TensorShift(G1tensor(560),2)
  call Hotf_5pt_reduction_last(G2tensor(449),RedSet_5(84),mass5set(:,3),  & 
G1tensor(565),G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(566),2)
  call Hotf_5pt_reduction_last(G2tensor(191),RedSet_5(50),mass5set(:,3),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(572),2)
  call Hotf_5pt_reduction_last(G2tensor(452),RedSet_5(82),mass5set(:,5),  & 
G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581),G1tensor(582))
  call G_TensorShift(G1tensor(578),2)
  call Hotf_5pt_reduction_last(G2tensor(455),RedSet_5(83),mass5set(:,5),  & 
G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586),G1tensor(587),G1tensor(588))
  call G_TensorShift(G1tensor(584),2)
  call Hotf_5pt_reduction_last(G2tensor(458),RedSet_5(84),mass5set(:,5),  & 
G1tensor(589),G1tensor(590),G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594))
  call G_TensorShift(G1tensor(590),2)
  call Hotf_5pt_reduction_last(G2tensor(194),RedSet_5(50),mass5set(:,5),  & 
G1tensor(595),G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(596),2)
  call Hotf_5pt_reduction_last(G2tensor(461),RedSet_5(82),mass5set(:,16),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605),G1tensor(606))
  call G_TensorShift(G1tensor(602),2)
  call Hotf_5pt_reduction_last(G2tensor(464),RedSet_5(84),mass5set(:,4),  & 
G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610),G1tensor(611),G1tensor(612))
  call G_TensorShift(G1tensor(608),2)
  call Hotf_5pt_reduction_last(G2tensor(197),RedSet_5(50),mass5set(:,4),  & 
G1tensor(613),G1tensor(614),G1tensor(615),G1tensor(616),G1tensor(617),G1tensor(618))
  call G_TensorShift(G1tensor(614),2)
  call Hotf_5pt_reduction_last(G2tensor(467),RedSet_5(82),mass5set(:,17),  & 
G1tensor(619),G1tensor(620),G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624))
  call G_TensorShift(G1tensor(620),2)
  call Hotf_5pt_reduction_last(G2tensor(470),RedSet_5(84),mass5set(:,6),  & 
G1tensor(625),G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(626),2)
  call Hotf_5pt_reduction_last(G2tensor(200),RedSet_5(50),mass5set(:,6),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635),G1tensor(636))
  call G_TensorShift(G1tensor(632),2)
  call Hotf_5pt_reduction_last(G2tensor(473),RedSet_5(85),mass5set(:,3),  & 
G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640),G1tensor(641),G1tensor(642))
  call G_TensorShift(G1tensor(638),8)
  call Hotf_5pt_reduction_last(G2tensor(476),RedSet_5(86),mass5set(:,3),  & 
G1tensor(643),G1tensor(644),G1tensor(645),G1tensor(646),G1tensor(647),G1tensor(648))
  call G_TensorShift(G1tensor(644),8)
  call Hotf_5pt_reduction_last(G2tensor(479),RedSet_5(87),mass5set(:,3),  & 
G1tensor(649),G1tensor(650),G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654))
  call G_TensorShift(G1tensor(650),8)
  call Hotf_5pt_reduction_last(G2tensor(203),RedSet_5(51),mass5set(:,3),  & 
G1tensor(655),G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(656),8)
  call Hotf_5pt_reduction_last(G2tensor(482),RedSet_5(85),mass5set(:,16),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665),G1tensor(666))
  call G_TensorShift(G1tensor(662),8)
  call Hotf_5pt_reduction_last(G2tensor(485),RedSet_5(87),mass5set(:,4),  & 
G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670),G1tensor(671),G1tensor(672))
  call G_TensorShift(G1tensor(668),8)
  call Hotf_5pt_reduction_last(G2tensor(206),RedSet_5(51),mass5set(:,4),  & 
G1tensor(673),G1tensor(674),G1tensor(675),G1tensor(676),G1tensor(677),G1tensor(678))
  call G_TensorShift(G1tensor(674),8)
  call Hotf_5pt_reduction_last(G2tensor(488),RedSet_5(85),mass5set(:,5),  & 
G1tensor(679),G1tensor(680),G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684))
  call G_TensorShift(G1tensor(680),8)
  call Hotf_5pt_reduction_last(G2tensor(491),RedSet_5(86),mass5set(:,5),  & 
G1tensor(685),G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(686),8)
  call Hotf_5pt_reduction_last(G2tensor(494),RedSet_5(87),mass5set(:,5),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695),G1tensor(696))
  call G_TensorShift(G1tensor(692),8)
  call Hotf_5pt_reduction_last(G2tensor(209),RedSet_5(51),mass5set(:,5),  & 
G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700),G1tensor(701),G1tensor(702))
  call G_TensorShift(G1tensor(698),8)
  call Hotf_5pt_reduction_last(G2tensor(497),RedSet_5(85),mass5set(:,17),  & 
G1tensor(703),G1tensor(704),G1tensor(705),G1tensor(706),G1tensor(707),G1tensor(708))
  call G_TensorShift(G1tensor(704),8)
  call Hotf_5pt_reduction_last(G2tensor(500),RedSet_5(87),mass5set(:,6),  & 
G1tensor(709),G1tensor(710),G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714))
  call G_TensorShift(G1tensor(710),8)
  call Hotf_5pt_reduction_last(G2tensor(212),RedSet_5(51),mass5set(:,6),  & 
G1tensor(715),G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(716),8)
  call Hotf_5pt_reduction_last(G2tensor(503),RedSet_5(88),mass5set(:,3),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725),G1tensor(726))
  call G_TensorShift(G1tensor(722),2)
  call Hotf_5pt_reduction_last(G2tensor(506),RedSet_5(89),mass5set(:,3),  & 
G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730),G1tensor(731),G1tensor(732))
  call G_TensorShift(G1tensor(728),2)
  call Hotf_5pt_reduction_last(G2tensor(509),RedSet_5(90),mass5set(:,3),  & 
G1tensor(733),G1tensor(734),G1tensor(735),G1tensor(736),G1tensor(737),G1tensor(738))
  call G_TensorShift(G1tensor(734),2)
  call Hotf_5pt_reduction_last(G2tensor(215),RedSet_5(52),mass5set(:,3),  & 
G1tensor(739),G1tensor(740),G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744))
  call G_TensorShift(G1tensor(740),2)
  call Hotf_5pt_reduction_last(G2tensor(512),RedSet_5(88),mass5set(:,5),  & 
G1tensor(745),G1tensor(746),G1tensor(747),G1tensor(748),G1tensor(749),G1tensor(750))
  call G_TensorShift(G1tensor(746),2)
  call Hotf_5pt_reduction_last(G2tensor(515),RedSet_5(89),mass5set(:,5),  & 
G1tensor(751),G1tensor(752),G1tensor(753),G1tensor(754),G1tensor(755),G1tensor(756))
  call G_TensorShift(G1tensor(752),2)
  call Hotf_5pt_reduction_last(G2tensor(518),RedSet_5(90),mass5set(:,5),  & 
G1tensor(757),G1tensor(758),G1tensor(759),G1tensor(760),G1tensor(761),G1tensor(762))
  call G_TensorShift(G1tensor(758),2)
  call Hotf_5pt_reduction_last(G2tensor(218),RedSet_5(52),mass5set(:,5),  & 
G1tensor(763),G1tensor(764),G1tensor(765),G1tensor(766),G1tensor(767),G1tensor(768))
  call G_TensorShift(G1tensor(764),2)
  call Hotf_5pt_reduction_last(G2tensor(521),RedSet_5(88),mass5set(:,16),  & 
G1tensor(769),G1tensor(770),G1tensor(771),G1tensor(772),G1tensor(773),G1tensor(774))
  call G_TensorShift(G1tensor(770),2)
  call Hotf_5pt_reduction_last(G2tensor(524),RedSet_5(90),mass5set(:,4),  & 
G1tensor(775),G1tensor(776),G1tensor(777),G1tensor(778),G1tensor(779),G1tensor(780))
  call G_TensorShift(G1tensor(776),2)
  call Hotf_5pt_reduction_last(G2tensor(221),RedSet_5(52),mass5set(:,4),  & 
G1tensor(781),G1tensor(782),G1tensor(783),G1tensor(784),G1tensor(785),G1tensor(786))
  call G_TensorShift(G1tensor(782),2)
  call Hotf_5pt_reduction_last(G2tensor(527),RedSet_5(88),mass5set(:,17),  & 
G1tensor(787),G1tensor(788),G1tensor(789),G1tensor(790),G1tensor(791),G1tensor(792))
  call G_TensorShift(G1tensor(788),2)
  call Hotf_5pt_reduction_last(G2tensor(530),RedSet_5(90),mass5set(:,6),  & 
G1tensor(793),G1tensor(794),G1tensor(795),G1tensor(796),G1tensor(797),G1tensor(798))
  call G_TensorShift(G1tensor(794),2)
  call Hotf_5pt_reduction_last(G2tensor(224),RedSet_5(52),mass5set(:,6),  & 
G1tensor(799),G1tensor(800),G1tensor(801),G1tensor(802),G1tensor(803),G1tensor(804))
  call G_TensorShift(G1tensor(800),2)
  call Hotf_5pt_reduction_last(G2tensor(533),RedSet_5(91),mass5set(:,3),  & 
G1tensor(805),G1tensor(806),G1tensor(807),G1tensor(808),G1tensor(809),G1tensor(810))
  call G_TensorShift(G1tensor(806),16)
  call Hotf_5pt_reduction_last(G2tensor(536),RedSet_5(92),mass5set(:,3),  & 
G1tensor(811),G1tensor(812),G1tensor(813),G1tensor(814),G1tensor(815),G1tensor(816))
  call G_TensorShift(G1tensor(812),16)
  call Hotf_5pt_reduction_last(G2tensor(539),RedSet_5(27),mass5set(:,3),  & 
G1tensor(817),G1tensor(818),G1tensor(819),G1tensor(820),G1tensor(821),G1tensor(822))
  call G_TensorShift(G1tensor(818),16)
  call Hotf_5pt_reduction_last(G2tensor(230),RedSet_5(54),mass5set(:,3),  & 
G1tensor(823),G1tensor(824),G1tensor(825),G1tensor(826),G1tensor(827),G1tensor(828))
  call G_TensorShift(G1tensor(824),16)
  call Hotf_5pt_reduction_last(G2tensor(542),RedSet_5(91),mass5set(:,16),  & 
G1tensor(829),G1tensor(830),G1tensor(831),G1tensor(832),G1tensor(833),G1tensor(834))
  call G_TensorShift(G1tensor(830),16)
  call Hotf_5pt_reduction_last(G2tensor(545),RedSet_5(27),mass5set(:,4),  & 
G1tensor(835),G1tensor(836),G1tensor(837),G1tensor(838),G1tensor(839),G1tensor(840))
  call G_TensorShift(G1tensor(836),16)
  call Hotf_5pt_reduction_last(G2tensor(236),RedSet_5(54),mass5set(:,4),  & 
G1tensor(841),G1tensor(842),G1tensor(843),G1tensor(844),G1tensor(845),G1tensor(846))
  call G_TensorShift(G1tensor(842),16)
  call Hotf_5pt_reduction_last(G2tensor(548),RedSet_5(91),mass5set(:,13),  & 
G1tensor(847),G1tensor(848),G1tensor(849),G1tensor(850),G1tensor(851),G1tensor(852))
  call G_TensorShift(G1tensor(848),16)
  call Hotf_5pt_reduction_last(G2tensor(551),RedSet_5(92),mass5set(:,13),  & 
G1tensor(853),G1tensor(854),G1tensor(855),G1tensor(856),G1tensor(857),G1tensor(858))
  call G_TensorShift(G1tensor(854),16)
  call Hotf_5pt_reduction_last(G2tensor(554),RedSet_5(27),mass5set(:,13),  & 
G1tensor(859),G1tensor(860),G1tensor(861),G1tensor(862),G1tensor(863),G1tensor(864))
  call G_TensorShift(G1tensor(860),16)
  call Hotf_5pt_reduction_last(G2tensor(557),RedSet_5(91),mass5set(:,18),  & 
G1tensor(865),G1tensor(866),G1tensor(867),G1tensor(868),G1tensor(869),G1tensor(870))
  call G_TensorShift(G1tensor(866),16)
  call Hotf_5pt_reduction_last(G2tensor(560),RedSet_5(27),mass5set(:,19),  & 
G1tensor(871),G1tensor(872),G1tensor(873),G1tensor(874),G1tensor(875),G1tensor(876))
  call G_TensorShift(G1tensor(872),16)
  call Hotf_5pt_reduction_last(G2tensor(563),RedSet_5(93),mass5set(:,3),  & 
G1tensor(877),G1tensor(878),G1tensor(879),G1tensor(880),G1tensor(881),G1tensor(882))
  call G_TensorShift(G1tensor(878),16)
  call Hotf_5pt_reduction_last(G2tensor(566),RedSet_5(94),mass5set(:,3),  & 
G1tensor(883),G1tensor(884),G1tensor(885),G1tensor(886),G1tensor(887),G1tensor(888))
  call G_TensorShift(G1tensor(884),16)
  call Hotf_5pt_reduction_last(G2tensor(569),RedSet_5(28),mass5set(:,3),  & 
G1tensor(889),G1tensor(890),G1tensor(891),G1tensor(892),G1tensor(893),G1tensor(894))
  call G_TensorShift(G1tensor(890),16)
  call Hotf_5pt_reduction_last(G2tensor(248),RedSet_5(56),mass5set(:,3),  & 
G1tensor(895),G1tensor(896),G1tensor(897),G1tensor(898),G1tensor(899),G1tensor(900))
  call G_TensorShift(G1tensor(896),16)
  call Hotf_5pt_reduction_last(G2tensor(572),RedSet_5(93),mass5set(:,13),  & 
G1tensor(901),G1tensor(902),G1tensor(903),G1tensor(904),G1tensor(905),G1tensor(906))
  call G_TensorShift(G1tensor(902),16)
  call Hotf_5pt_reduction_last(G2tensor(575),RedSet_5(94),mass5set(:,13),  & 
G1tensor(907),G1tensor(908),G1tensor(909),G1tensor(910),G1tensor(911),G1tensor(912))
  call G_TensorShift(G1tensor(908),16)
  call Hotf_5pt_reduction_last(G2tensor(578),RedSet_5(28),mass5set(:,13),  & 
G1tensor(913),G1tensor(914),G1tensor(915),G1tensor(916),G1tensor(917),G1tensor(918))
  call G_TensorShift(G1tensor(914),16)
  call Hotf_5pt_reduction_last(G2tensor(581),RedSet_5(93),mass5set(:,16),  & 
G1tensor(919),G1tensor(920),G1tensor(921),G1tensor(922),G1tensor(923),G1tensor(924))
  call G_TensorShift(G1tensor(920),16)
  call Hotf_5pt_reduction_last(G2tensor(584),RedSet_5(28),mass5set(:,4),  & 
G1tensor(925),G1tensor(926),G1tensor(927),G1tensor(928),G1tensor(929),G1tensor(930))
  call G_TensorShift(G1tensor(926),16)
  call Hotf_5pt_reduction_last(G2tensor(257),RedSet_5(56),mass5set(:,4),  & 
G1tensor(931),G1tensor(932),G1tensor(933),G1tensor(934),G1tensor(935),G1tensor(936))
  call G_TensorShift(G1tensor(932),16)
  call Hotf_5pt_reduction_last(G2tensor(587),RedSet_5(93),mass5set(:,18),  & 
G1tensor(937),G1tensor(938),G1tensor(939),G1tensor(940),G1tensor(941),G1tensor(942))
  call G_TensorShift(G1tensor(938),16)
  call Hotf_5pt_reduction_last(G2tensor(590),RedSet_5(28),mass5set(:,19),  & 
G1tensor(943),G1tensor(944),G1tensor(945),G1tensor(946),G1tensor(947),G1tensor(948))
  call G_TensorShift(G1tensor(944),16)
  call Hotf_5pt_reduction_last(G2tensor(593),RedSet_5(95),mass5set(:,3),  & 
G1tensor(949),G1tensor(950),G1tensor(951),G1tensor(952),G1tensor(953),G1tensor(954))
  call G_TensorShift(G1tensor(950),16)
  call Hotf_5pt_reduction_last(G2tensor(596),RedSet_5(96),mass5set(:,3),  & 
G1tensor(955),G1tensor(956),G1tensor(957),G1tensor(958),G1tensor(959),G1tensor(960))
  call G_TensorShift(G1tensor(956),16)
  call Hotf_5pt_reduction_last(G2tensor(266),RedSet_5(58),mass5set(:,3),  & 
G1tensor(961),G1tensor(962),G1tensor(963),G1tensor(964),G1tensor(965),G1tensor(966))
  call G_TensorShift(G1tensor(962),16)
  call Hotf_5pt_reduction_last(G2tensor(599),RedSet_5(95),mass5set(:,13),  & 
G1tensor(967),G1tensor(968),G1tensor(969),G1tensor(970),G1tensor(971),G1tensor(972))
  call G_TensorShift(G1tensor(968),16)
  call Hotf_5pt_reduction_last(G2tensor(602),RedSet_5(96),mass5set(:,13),  & 
G1tensor(973),G1tensor(974),G1tensor(975),G1tensor(976),G1tensor(977),G1tensor(978))
  call G_TensorShift(G1tensor(974),16)
  call Hotf_5pt_reduction_last(G2tensor(605),RedSet_5(95),mass5set(:,16),  & 
G1tensor(979),G1tensor(980),G1tensor(981),G1tensor(982),G1tensor(983),G1tensor(984))
  call G_TensorShift(G1tensor(980),16)
  call Hotf_5pt_reduction_last(G2tensor(275),RedSet_5(58),mass5set(:,4),  & 
G1tensor(985),G1tensor(986),G1tensor(987),G1tensor(988),G1tensor(989),G1tensor(990))
  call G_TensorShift(G1tensor(986),16)
  call Hotf_5pt_reduction_last(G2tensor(608),RedSet_5(95),mass5set(:,18),  & 
G1tensor(991),G1tensor(992),G1tensor(993),G1tensor(994),G1tensor(995),G1tensor(996))
  call G_TensorShift(G1tensor(992),16)
  call Hotf_5pt_reduction_last(G2tensor(611),RedSet_5(97),mass5set(:,3),  & 
G1tensor(997),G1tensor(998),G1tensor(999),G1tensor(1000),G1tensor(1001),G1tensor(1002))
  call G_TensorShift(G1tensor(998),16)
  call Hotf_5pt_reduction_last(G2tensor(614),RedSet_5(98),mass5set(:,3),  & 
G1tensor(1003),G1tensor(1004),G1tensor(1005),G1tensor(1006),G1tensor(1007),G1tensor(1008))
  call G_TensorShift(G1tensor(1004),16)
  call Hotf_5pt_reduction_last(G2tensor(284),RedSet_5(60),mass5set(:,3),  & 
G1tensor(1009),G1tensor(1010),G1tensor(1011),G1tensor(1012),G1tensor(1013),G1tensor(1014))
  call G_TensorShift(G1tensor(1010),16)
  call Hotf_5pt_reduction_last(G2tensor(617),RedSet_5(97),mass5set(:,16),  & 
G1tensor(1015),G1tensor(1016),G1tensor(1017),G1tensor(1018),G1tensor(1019),G1tensor(1020))
  call G_TensorShift(G1tensor(1016),16)
  call Hotf_5pt_reduction_last(G2tensor(290),RedSet_5(60),mass5set(:,4),  & 
G1tensor(1021),G1tensor(1022),G1tensor(1023),G1tensor(1024),G1tensor(1025),G1tensor(1026))
  call G_TensorShift(G1tensor(1022),16)
  call Hotf_5pt_reduction_last(G2tensor(620),RedSet_5(97),mass5set(:,13),  & 
G1tensor(1027),G1tensor(1028),G1tensor(1029),G1tensor(1030),G1tensor(1031),G1tensor(1032))
  call G_TensorShift(G1tensor(1028),16)
  call Hotf_5pt_reduction_last(G2tensor(623),RedSet_5(98),mass5set(:,13),  & 
G1tensor(1033),G1tensor(1034),G1tensor(1035),G1tensor(1036),G1tensor(1037),G1tensor(1038))
  call G_TensorShift(G1tensor(1034),16)
  call Hotf_5pt_reduction_last(G2tensor(626),RedSet_5(97),mass5set(:,18),  & 
G1tensor(1039),G1tensor(1040),G1tensor(1041),G1tensor(1042),G1tensor(1043),G1tensor(1044))
  call G_TensorShift(G1tensor(1040),16)
  call Hotf_5pt_reduction_last(G2tensor(629),RedSet_5(99),mass5set(:,3),  & 
G1tensor(1045),G1tensor(1046),G1tensor(1047),G1tensor(1048),G1tensor(1049),G1tensor(1050))
  call G_TensorShift(G1tensor(1046),16)
  call Hotf_5pt_reduction_last(G2tensor(632),RedSet_5(100),mass5set(:,3),  & 
G1tensor(1051),G1tensor(1052),G1tensor(1053),G1tensor(1054),G1tensor(1055),G1tensor(1056))
  call G_TensorShift(G1tensor(1052),16)
  call Hotf_5pt_reduction_last(G2tensor(635),RedSet_5(29),mass5set(:,3),  & 
G1tensor(1057),G1tensor(1058),G1tensor(1059),G1tensor(1060),G1tensor(1061),G1tensor(1062))
  call G_TensorShift(G1tensor(1058),16)
  call Hotf_5pt_reduction_last(G2tensor(302),RedSet_5(62),mass5set(:,3),  & 
G1tensor(1063),G1tensor(1064),G1tensor(1065),G1tensor(1066),G1tensor(1067),G1tensor(1068))
  call G_TensorShift(G1tensor(1064),16)
  call Hotf_5pt_reduction_last(G2tensor(638),RedSet_5(99),mass5set(:,16),  & 
G1tensor(1069),G1tensor(1070),G1tensor(1071),G1tensor(1072),G1tensor(1073),G1tensor(1074))
  call G_TensorShift(G1tensor(1070),16)
  call Hotf_5pt_reduction_last(G2tensor(641),RedSet_5(29),mass5set(:,4),  & 
G1tensor(1075),G1tensor(1076),G1tensor(1077),G1tensor(1078),G1tensor(1079),G1tensor(1080))
  call G_TensorShift(G1tensor(1076),16)
  call Hotf_5pt_reduction_last(G2tensor(308),RedSet_5(62),mass5set(:,4),  & 
G1tensor(1081),G1tensor(1082),G1tensor(1083),G1tensor(1084),G1tensor(1085),G1tensor(1086))
  call G_TensorShift(G1tensor(1082),16)
  call Hotf_5pt_reduction_last(G2tensor(644),RedSet_5(99),mass5set(:,13),  & 
G1tensor(1087),G1tensor(1088),G1tensor(1089),G1tensor(1090),G1tensor(1091),G1tensor(1092))
  call G_TensorShift(G1tensor(1088),16)
  call Hotf_5pt_reduction_last(G2tensor(647),RedSet_5(100),mass5set(:,13),  & 
G1tensor(1093),G1tensor(1094),G1tensor(1095),G1tensor(1096),G1tensor(1097),G1tensor(1098))
  call G_TensorShift(G1tensor(1094),16)
  call Hotf_5pt_reduction_last(G2tensor(650),RedSet_5(29),mass5set(:,13),  & 
G1tensor(1099),G1tensor(1100),G1tensor(1101),G1tensor(1102),G1tensor(1103),G1tensor(1104))
  call G_TensorShift(G1tensor(1100),16)
  call Hotf_5pt_reduction_last(G2tensor(653),RedSet_5(99),mass5set(:,18),  & 
G1tensor(1105),G1tensor(1106),G1tensor(1107),G1tensor(1108),G1tensor(1109),G1tensor(1110))
  call G_TensorShift(G1tensor(1106),16)
  call Hotf_5pt_reduction_last(G2tensor(656),RedSet_5(29),mass5set(:,19),  & 
G1tensor(1111),G1tensor(1112),G1tensor(1113),G1tensor(1114),G1tensor(1115),G1tensor(1116))
  call G_TensorShift(G1tensor(1112),16)
  call Hotf_5pt_reduction_last(G2tensor(659),RedSet_5(101),mass5set(:,3),  & 
G1tensor(1117),G1tensor(1118),G1tensor(1119),G1tensor(1120),G1tensor(1121),G1tensor(1122))
  call G_TensorShift(G1tensor(1118),16)
  call Hotf_5pt_reduction_last(G2tensor(662),RedSet_5(102),mass5set(:,3),  & 
G1tensor(1123),G1tensor(1124),G1tensor(1125),G1tensor(1126),G1tensor(1127),G1tensor(1128))
  call G_TensorShift(G1tensor(1124),16)
  call Hotf_5pt_reduction_last(G2tensor(665),RedSet_5(30),mass5set(:,3),  & 
G1tensor(1129),G1tensor(1130),G1tensor(1131),G1tensor(1132),G1tensor(1133),G1tensor(1134))
  call G_TensorShift(G1tensor(1130),16)
  call Hotf_5pt_reduction_last(G2tensor(320),RedSet_5(64),mass5set(:,3),  & 
G1tensor(1135),G1tensor(1136),G1tensor(1137),G1tensor(1138),G1tensor(1139),G1tensor(1140))
  call G_TensorShift(G1tensor(1136),16)
  call Hotf_5pt_reduction_last(G2tensor(668),RedSet_5(101),mass5set(:,13),  & 
G1tensor(1141),G1tensor(1142),G1tensor(1143),G1tensor(1144),G1tensor(1145),G1tensor(1146))
  call G_TensorShift(G1tensor(1142),16)
  call Hotf_5pt_reduction_last(G2tensor(671),RedSet_5(102),mass5set(:,13),  & 
G1tensor(1147),G1tensor(1148),G1tensor(1149),G1tensor(1150),G1tensor(1151),G1tensor(1152))
  call G_TensorShift(G1tensor(1148),16)
  call Hotf_5pt_reduction_last(G2tensor(674),RedSet_5(30),mass5set(:,13),  & 
G1tensor(1153),G1tensor(1154),G1tensor(1155),G1tensor(1156),G1tensor(1157),G1tensor(1158))
  call G_TensorShift(G1tensor(1154),16)
  call Hotf_5pt_reduction_last(G2tensor(677),RedSet_5(101),mass5set(:,16),  & 
G1tensor(1159),G1tensor(1160),G1tensor(1161),G1tensor(1162),G1tensor(1163),G1tensor(1164))
  call G_TensorShift(G1tensor(1160),16)
  call Hotf_5pt_reduction_last(G2tensor(680),RedSet_5(30),mass5set(:,4),  & 
G1tensor(1165),G1tensor(1166),G1tensor(1167),G1tensor(1168),G1tensor(1169),G1tensor(1170))
  call G_TensorShift(G1tensor(1166),16)
  call Hotf_5pt_reduction_last(G2tensor(329),RedSet_5(64),mass5set(:,4),  & 
G1tensor(1171),G1tensor(1172),G1tensor(1173),G1tensor(1174),G1tensor(1175),G1tensor(1176))
  call G_TensorShift(G1tensor(1172),16)
  call Hotf_5pt_reduction_last(G2tensor(683),RedSet_5(101),mass5set(:,18),  & 
G1tensor(1177),G1tensor(1178),G1tensor(1179),G1tensor(1180),G1tensor(1181),G1tensor(1182))
  call G_TensorShift(G1tensor(1178),16)
  call Hotf_5pt_reduction_last(G2tensor(686),RedSet_5(30),mass5set(:,19),  & 
G1tensor(1183),G1tensor(1184),G1tensor(1185),G1tensor(1186),G1tensor(1187),G1tensor(1188))
  call G_TensorShift(G1tensor(1184),16)
  call Hotf_5pt_reduction_last(G2tensor(689),RedSet_5(103),mass5set(:,3),  & 
G1tensor(1189),G1tensor(1190),G1tensor(1191),G1tensor(1192),G1tensor(1193),G1tensor(1194))
  call G_TensorShift(G1tensor(1190),16)
  call Hotf_5pt_reduction_last(G2tensor(692),RedSet_5(104),mass5set(:,3),  & 
G1tensor(1195),G1tensor(1196),G1tensor(1197),G1tensor(1198),G1tensor(1199),G1tensor(1200))
  call G_TensorShift(G1tensor(1196),16)
  call Hotf_5pt_reduction_last(G2tensor(338),RedSet_5(66),mass5set(:,3),  & 
G1tensor(1201),G1tensor(1202),G1tensor(1203),G1tensor(1204),G1tensor(1205),G1tensor(1206))
  call G_TensorShift(G1tensor(1202),16)
  call Hotf_5pt_reduction_last(G2tensor(695),RedSet_5(103),mass5set(:,16),  & 
G1tensor(1207),G1tensor(1208),G1tensor(1209),G1tensor(1210),G1tensor(1211),G1tensor(1212))
  call G_TensorShift(G1tensor(1208),16)
  call Hotf_5pt_reduction_last(G2tensor(344),RedSet_5(66),mass5set(:,4),  & 
G1tensor(1213),G1tensor(1214),G1tensor(1215),G1tensor(1216),G1tensor(1217),G1tensor(1218))
  call G_TensorShift(G1tensor(1214),16)
  call Hotf_5pt_reduction_last(G2tensor(698),RedSet_5(103),mass5set(:,13),  & 
G1tensor(1219),G1tensor(1220),G1tensor(1221),G1tensor(1222),G1tensor(1223),G1tensor(1224))
  call G_TensorShift(G1tensor(1220),16)
  call Hotf_5pt_reduction_last(G2tensor(701),RedSet_5(104),mass5set(:,13),  & 
G1tensor(1225),G1tensor(1226),G1tensor(1227),G1tensor(1228),G1tensor(1229),G1tensor(1230))
  call G_TensorShift(G1tensor(1226),16)
  call Hotf_5pt_reduction_last(G2tensor(704),RedSet_5(103),mass5set(:,18),  & 
G1tensor(1231),G1tensor(1232),G1tensor(1233),G1tensor(1234),G1tensor(1235),G1tensor(1236))
  call G_TensorShift(G1tensor(1232),16)
  call Hotf_5pt_reduction_last(G2tensor(707),RedSet_5(105),mass5set(:,3),  & 
G1tensor(1237),G1tensor(1238),G1tensor(1239),G1tensor(1240),G1tensor(1241),G1tensor(1242))
  call G_TensorShift(G1tensor(1238),16)
  call Hotf_5pt_reduction_last(G2tensor(710),RedSet_5(106),mass5set(:,3),  & 
G1tensor(1243),G1tensor(1244),G1tensor(1245),G1tensor(1246),G1tensor(1247),G1tensor(1248))
  call G_TensorShift(G1tensor(1244),16)
  call Hotf_5pt_reduction_last(G2tensor(356),RedSet_5(68),mass5set(:,3),  & 
G1tensor(1249),G1tensor(1250),G1tensor(1251),G1tensor(1252),G1tensor(1253),G1tensor(1254))
  call G_TensorShift(G1tensor(1250),16)
  call Hotf_5pt_reduction_last(G2tensor(713),RedSet_5(105),mass5set(:,13),  & 
G1tensor(1255),G1tensor(1256),G1tensor(1257),G1tensor(1258),G1tensor(1259),G1tensor(1260))
  call G_TensorShift(G1tensor(1256),16)
  call Hotf_5pt_reduction_last(G2tensor(716),RedSet_5(106),mass5set(:,13),  & 
G1tensor(1261),G1tensor(1262),G1tensor(1263),G1tensor(1264),G1tensor(1265),G1tensor(1266))
  call G_TensorShift(G1tensor(1262),16)
  call Hotf_5pt_reduction_last(G2tensor(719),RedSet_5(105),mass5set(:,16),  & 
G1tensor(1267),G1tensor(1268),G1tensor(1269),G1tensor(1270),G1tensor(1271),G1tensor(1272))
  call G_TensorShift(G1tensor(1268),16)
  call Hotf_5pt_reduction_last(G2tensor(365),RedSet_5(68),mass5set(:,4),  & 
G1tensor(1273),G1tensor(1274),G1tensor(1275),G1tensor(1276),G1tensor(1277),G1tensor(1278))
  call G_TensorShift(G1tensor(1274),16)
  call Hotf_5pt_reduction_last(G2tensor(722),RedSet_5(105),mass5set(:,18),  & 
G1tensor(1279),G1tensor(1280),G1tensor(1281),G1tensor(1282),G1tensor(1283),G1tensor(1284))
  call G_TensorShift(G1tensor(1280),16)
  call Hotf_5pt_reduction_last(G2tensor(865),RedSet_5(27),mass5set(:,9),  & 
G1tensor(1285),G1tensor(1286),G1tensor(1287),G1tensor(1288),G1tensor(1289),G1tensor(1290))
  call G_TensorShift(G1tensor(1286),16)
  call Hotf_5pt_reduction_last(G2tensor(869),RedSet_5(28),mass5set(:,9),  & 
G1tensor(1291),G1tensor(1292),G1tensor(1293),G1tensor(1294),G1tensor(1295),G1tensor(1296))
  call G_TensorShift(G1tensor(1292),16)
  call Hotf_5pt_reduction_last(G2tensor(935),RedSet_5(4),mass5set(:,2),  & 
G1tensor(1297),G1tensor(1298),G1tensor(1299),G1tensor(1300),G1tensor(1301),G1tensor(1302))
  call G_TensorShift(G1tensor(1298),12)
  call Hotf_5pt_reduction_last(G2tensor(967),RedSet_5(6),mass5set(:,2),  & 
G1tensor(1303),G1tensor(1304),G1tensor(1305),G1tensor(1306),G1tensor(1307),G1tensor(1308))
  call G_TensorShift(G1tensor(1304),12)
  call Hotf_5pt_reduction_last(G2tensor(873),RedSet_5(29),mass5set(:,9),  & 
G1tensor(1309),G1tensor(1310),G1tensor(1311),G1tensor(1312),G1tensor(1313),G1tensor(1314))
  call G_TensorShift(G1tensor(1310),16)
  call Hotf_5pt_reduction_last(G2tensor(877),RedSet_5(30),mass5set(:,9),  & 
G1tensor(1315),G1tensor(1316),G1tensor(1317),G1tensor(1318),G1tensor(1319),G1tensor(1320))
  call G_TensorShift(G1tensor(1316),16)
  call Hotf_5pt_reduction_last(G2tensor(143),RedSet_5(3),mass5set(:,1),  & 
G1tensor(1321),G1tensor(1322),G1tensor(1323),G1tensor(1324),G1tensor(1325),G1tensor(1326))
  call G_TensorShift(G1tensor(1322),17)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1327),G1tensor(1328),G1tensor(1329),G1tensor(1330),G1tensor(1331),G1tensor(1332))
  call G_TensorShift(G1tensor(1328),18)
  call Hotf_5pt_reduction_last(G2tensor(147),RedSet_5(2),mass5set(:,1),  & 
G1tensor(1333),G1tensor(1334),G1tensor(1335),G1tensor(1336),G1tensor(1337),G1tensor(1338))
  call G_TensorShift(G1tensor(1334),20)
  call Hotf_5pt_reduction_last(G2tensor(149),RedSet_5(5),mass5set(:,1),  & 
G1tensor(1339),G1tensor(1340),G1tensor(1341),G1tensor(1342),G1tensor(1343),G1tensor(1344))
  call G_TensorShift(G1tensor(1340),24)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(47),mass5set(:,3),  & 
G1tensor(1345),G1tensor(1346),G1tensor(1347),G1tensor(1348),G1tensor(1349),G1tensor(1350))
  call G_TensorShift(G1tensor(1346),8)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(47),mass5set(:,10),  & 
G1tensor(1351),G1tensor(1352),G1tensor(1353),G1tensor(1354),G1tensor(1355),G1tensor(1356))
  call G_TensorShift(G1tensor(1352),8)
  call Hotf_5pt_reduction_last(G2tensor(155),RedSet_5(47),mass5set(:,4),  & 
G1tensor(1357),G1tensor(1358),G1tensor(1359),G1tensor(1360),G1tensor(1361),G1tensor(1362))
  call G_TensorShift(G1tensor(1358),8)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(47),mass5set(:,11),  & 
G1tensor(1363),G1tensor(1364),G1tensor(1365),G1tensor(1366),G1tensor(1367),G1tensor(1368))
  call G_TensorShift(G1tensor(1364),8)
  call Hotf_5pt_reduction_last(G2tensor(159),RedSet_5(48),mass5set(:,3),  & 
G1tensor(1369),G1tensor(1370),G1tensor(1371),G1tensor(1372),G1tensor(1373),G1tensor(1374))
  call G_TensorShift(G1tensor(1370),4)
  call Hotf_5pt_reduction_last(G2tensor(161),RedSet_5(48),mass5set(:,10),  & 
G1tensor(1375),G1tensor(1376),G1tensor(1377),G1tensor(1378),G1tensor(1379),G1tensor(1380))
  call G_TensorShift(G1tensor(1376),4)
  call Hotf_5pt_reduction_last(G2tensor(163),RedSet_5(48),mass5set(:,4),  & 
G1tensor(1381),G1tensor(1382),G1tensor(1383),G1tensor(1384),G1tensor(1385),G1tensor(1386))
  call G_TensorShift(G1tensor(1382),4)
  call Hotf_5pt_reduction_last(G2tensor(165),RedSet_5(48),mass5set(:,11),  & 
G1tensor(1387),G1tensor(1388),G1tensor(1389),G1tensor(1390),G1tensor(1391),G1tensor(1392))
  call G_TensorShift(G1tensor(1388),4)
  call Hotf_5pt_reduction_last(G2tensor(725),RedSet_5(17),mass5set(:,3),  & 
G1tensor(1393),G1tensor(1394),G1tensor(1395),G1tensor(1396),G1tensor(1397),G1tensor(1398))
  call G_TensorShift(G1tensor(1394),17)
  call Hotf_5pt_reduction_last(G2tensor(728),RedSet_5(17),mass5set(:,5),  & 
G1tensor(1399),G1tensor(1400),G1tensor(1401),G1tensor(1402),G1tensor(1403),G1tensor(1404))
  call G_TensorShift(G1tensor(1400),17)
  call Hotf_5pt_reduction_last(G2tensor(731),RedSet_5(17),mass5set(:,4),  & 
G1tensor(1405),G1tensor(1406),G1tensor(1407),G1tensor(1408),G1tensor(1409),G1tensor(1410))
  call G_TensorShift(G1tensor(1406),17)
  call Hotf_5pt_reduction_last(G2tensor(734),RedSet_5(17),mass5set(:,6),  & 
G1tensor(1411),G1tensor(1412),G1tensor(1413),G1tensor(1414),G1tensor(1415),G1tensor(1416))
  call G_TensorShift(G1tensor(1412),17)
  call Hotf_5pt_reduction_last(G2tensor(737),RedSet_5(15),mass5set(:,3),  & 
G1tensor(1417),G1tensor(1418),G1tensor(1419),G1tensor(1420),G1tensor(1421),G1tensor(1422))
  call G_TensorShift(G1tensor(1418),17)
  call Hotf_5pt_reduction_last(G2tensor(740),RedSet_5(15),mass5set(:,5),  & 
G1tensor(1423),G1tensor(1424),G1tensor(1425),G1tensor(1426),G1tensor(1427),G1tensor(1428))
  call G_TensorShift(G1tensor(1424),17)
  call Hotf_5pt_reduction_last(G2tensor(743),RedSet_5(15),mass5set(:,4),  & 
G1tensor(1429),G1tensor(1430),G1tensor(1431),G1tensor(1432),G1tensor(1433),G1tensor(1434))
  call G_TensorShift(G1tensor(1430),17)
  call Hotf_5pt_reduction_last(G2tensor(746),RedSet_5(15),mass5set(:,6),  & 
G1tensor(1435),G1tensor(1436),G1tensor(1437),G1tensor(1438),G1tensor(1439),G1tensor(1440))
  call G_TensorShift(G1tensor(1436),17)
  call Hotf_5pt_reduction_last(G2tensor(749),RedSet_5(16),mass5set(:,3),  & 
G1tensor(1441),G1tensor(1442),G1tensor(1443),G1tensor(1444),G1tensor(1445),G1tensor(1446))
  call G_TensorShift(G1tensor(1442),18)
  call Hotf_5pt_reduction_last(G2tensor(752),RedSet_5(16),mass5set(:,5),  & 
G1tensor(1447),G1tensor(1448),G1tensor(1449),G1tensor(1450),G1tensor(1451),G1tensor(1452))
  call G_TensorShift(G1tensor(1448),18)
  call Hotf_5pt_reduction_last(G2tensor(755),RedSet_5(16),mass5set(:,4),  & 
G1tensor(1453),G1tensor(1454),G1tensor(1455),G1tensor(1456),G1tensor(1457),G1tensor(1458))
  call G_TensorShift(G1tensor(1454),18)
  call Hotf_5pt_reduction_last(G2tensor(758),RedSet_5(16),mass5set(:,6),  & 
G1tensor(1459),G1tensor(1460),G1tensor(1461),G1tensor(1462),G1tensor(1463),G1tensor(1464))
  call G_TensorShift(G1tensor(1460),18)
  call Hotf_5pt_reduction_last(G2tensor(761),RedSet_5(18),mass5set(:,3),  & 
G1tensor(1465),G1tensor(1466),G1tensor(1467),G1tensor(1468),G1tensor(1469),G1tensor(1470))
  call G_TensorShift(G1tensor(1466),18)
  call Hotf_5pt_reduction_last(G2tensor(764),RedSet_5(18),mass5set(:,5),  & 
G1tensor(1471),G1tensor(1472),G1tensor(1473),G1tensor(1474),G1tensor(1475),G1tensor(1476))
  call G_TensorShift(G1tensor(1472),18)
  call Hotf_5pt_reduction_last(G2tensor(767),RedSet_5(18),mass5set(:,4),  & 
G1tensor(1477),G1tensor(1478),G1tensor(1479),G1tensor(1480),G1tensor(1481),G1tensor(1482))
  call G_TensorShift(G1tensor(1478),18)
  call Hotf_5pt_reduction_last(G2tensor(770),RedSet_5(18),mass5set(:,6),  & 
G1tensor(1483),G1tensor(1484),G1tensor(1485),G1tensor(1486),G1tensor(1487),G1tensor(1488))
  call G_TensorShift(G1tensor(1484),18)
  call Hotf_5pt_reduction_last(G2tensor(773),RedSet_5(13),mass5set(:,3),  & 
G1tensor(1489),G1tensor(1490),G1tensor(1491),G1tensor(1492),G1tensor(1493),G1tensor(1494))
  call G_TensorShift(G1tensor(1490),20)
  call Hotf_5pt_reduction_last(G2tensor(776),RedSet_5(13),mass5set(:,5),  & 
G1tensor(1495),G1tensor(1496),G1tensor(1497),G1tensor(1498),G1tensor(1499),G1tensor(1500))
  call G_TensorShift(G1tensor(1496),20)
  call Hotf_5pt_reduction_last(G2tensor(779),RedSet_5(13),mass5set(:,4),  & 
G1tensor(1501),G1tensor(1502),G1tensor(1503),G1tensor(1504),G1tensor(1505),G1tensor(1506))
  call G_TensorShift(G1tensor(1502),20)
  call Hotf_5pt_reduction_last(G2tensor(782),RedSet_5(13),mass5set(:,6),  & 
G1tensor(1507),G1tensor(1508),G1tensor(1509),G1tensor(1510),G1tensor(1511),G1tensor(1512))
  call G_TensorShift(G1tensor(1508),20)
  call Hotf_5pt_reduction_last(G2tensor(785),RedSet_5(11),mass5set(:,3),  & 
G1tensor(1513),G1tensor(1514),G1tensor(1515),G1tensor(1516),G1tensor(1517),G1tensor(1518))
  call G_TensorShift(G1tensor(1514),20)
  call Hotf_5pt_reduction_last(G2tensor(788),RedSet_5(11),mass5set(:,4),  & 
G1tensor(1519),G1tensor(1520),G1tensor(1521),G1tensor(1522),G1tensor(1523),G1tensor(1524))
  call G_TensorShift(G1tensor(1520),20)
  call Hotf_5pt_reduction_last(G2tensor(791),RedSet_5(11),mass5set(:,5),  & 
G1tensor(1525),G1tensor(1526),G1tensor(1527),G1tensor(1528),G1tensor(1529),G1tensor(1530))
  call G_TensorShift(G1tensor(1526),20)
  call Hotf_5pt_reduction_last(G2tensor(794),RedSet_5(11),mass5set(:,6),  & 
G1tensor(1531),G1tensor(1532),G1tensor(1533),G1tensor(1534),G1tensor(1535),G1tensor(1536))
  call G_TensorShift(G1tensor(1532),20)
  call Hotf_5pt_reduction_last(G2tensor(797),RedSet_5(12),mass5set(:,3),  & 
G1tensor(1537),G1tensor(1538),G1tensor(1539),G1tensor(1540),G1tensor(1541),G1tensor(1542))
  call G_TensorShift(G1tensor(1538),24)
  call Hotf_5pt_reduction_last(G2tensor(800),RedSet_5(12),mass5set(:,5),  & 
G1tensor(1543),G1tensor(1544),G1tensor(1545),G1tensor(1546),G1tensor(1547),G1tensor(1548))
  call G_TensorShift(G1tensor(1544),24)
  call Hotf_5pt_reduction_last(G2tensor(803),RedSet_5(12),mass5set(:,4),  & 
G1tensor(1549),G1tensor(1550),G1tensor(1551),G1tensor(1552),G1tensor(1553),G1tensor(1554))
  call G_TensorShift(G1tensor(1550),24)
  call Hotf_5pt_reduction_last(G2tensor(806),RedSet_5(12),mass5set(:,6),  & 
G1tensor(1555),G1tensor(1556),G1tensor(1557),G1tensor(1558),G1tensor(1559),G1tensor(1560))
  call G_TensorShift(G1tensor(1556),24)
  call Hotf_5pt_reduction_last(G2tensor(809),RedSet_5(14),mass5set(:,3),  & 
G1tensor(1561),G1tensor(1562),G1tensor(1563),G1tensor(1564),G1tensor(1565),G1tensor(1566))
  call G_TensorShift(G1tensor(1562),24)
  call Hotf_5pt_reduction_last(G2tensor(812),RedSet_5(14),mass5set(:,4),  & 
G1tensor(1567),G1tensor(1568),G1tensor(1569),G1tensor(1570),G1tensor(1571),G1tensor(1572))
  call G_TensorShift(G1tensor(1568),24)
  call Hotf_5pt_reduction_last(G2tensor(815),RedSet_5(14),mass5set(:,5),  & 
G1tensor(1573),G1tensor(1574),G1tensor(1575),G1tensor(1576),G1tensor(1577),G1tensor(1578))
  call G_TensorShift(G1tensor(1574),24)
  call Hotf_5pt_reduction_last(G2tensor(818),RedSet_5(14),mass5set(:,6),  & 
G1tensor(1579),G1tensor(1580),G1tensor(1581),G1tensor(1582),G1tensor(1583),G1tensor(1584))
  call G_TensorShift(G1tensor(1580),24)
  call Hotf_5pt_reduction_last(G2tensor(821),RedSet_5(107),mass5set(:,3),  & 
G1tensor(1585),G1tensor(1586),G1tensor(1587),G1tensor(1588),G1tensor(1589),G1tensor(1590))
  call G_TensorShift(G1tensor(1586),4)
  call Hotf_5pt_reduction_last(G2tensor(824),RedSet_5(107),mass5set(:,16),  & 
G1tensor(1591),G1tensor(1592),G1tensor(1593),G1tensor(1594),G1tensor(1595),G1tensor(1596))
  call G_TensorShift(G1tensor(1592),4)
  call Hotf_5pt_reduction_last(G2tensor(827),RedSet_5(107),mass5set(:,5),  & 
G1tensor(1597),G1tensor(1598),G1tensor(1599),G1tensor(1600),G1tensor(1601),G1tensor(1602))
  call G_TensorShift(G1tensor(1598),4)
  call Hotf_5pt_reduction_last(G2tensor(830),RedSet_5(107),mass5set(:,17),  & 
G1tensor(1603),G1tensor(1604),G1tensor(1605),G1tensor(1606),G1tensor(1607),G1tensor(1608))
  call G_TensorShift(G1tensor(1604),4)
  call Hotf_5pt_reduction_last(G2tensor(833),RedSet_5(108),mass5set(:,3),  & 
G1tensor(1609),G1tensor(1610),G1tensor(1611),G1tensor(1612),G1tensor(1613),G1tensor(1614))
  call G_TensorShift(G1tensor(1610),4)
  call Hotf_5pt_reduction_last(G2tensor(836),RedSet_5(108),mass5set(:,5),  & 
G1tensor(1615),G1tensor(1616),G1tensor(1617),G1tensor(1618),G1tensor(1619),G1tensor(1620))
  call G_TensorShift(G1tensor(1616),4)
  call Hotf_5pt_reduction_last(G2tensor(839),RedSet_5(108),mass5set(:,16),  & 
G1tensor(1621),G1tensor(1622),G1tensor(1623),G1tensor(1624),G1tensor(1625),G1tensor(1626))
  call G_TensorShift(G1tensor(1622),4)
  call Hotf_5pt_reduction_last(G2tensor(842),RedSet_5(108),mass5set(:,17),  & 
G1tensor(1627),G1tensor(1628),G1tensor(1629),G1tensor(1630),G1tensor(1631),G1tensor(1632))
  call G_TensorShift(G1tensor(1628),4)
  call Hotf_5pt_reduction_last(G2tensor(849),RedSet_5(26),mass5set(:,3),  & 
G1tensor(1633),G1tensor(1634),G1tensor(1635),G1tensor(1636),G1tensor(1637),G1tensor(1638))
  call G_TensorShift(G1tensor(1634),8)
  call Hotf_5pt_reduction_last(G2tensor(853),RedSet_5(26),mass5set(:,5),  & 
G1tensor(1639),G1tensor(1640),G1tensor(1641),G1tensor(1642),G1tensor(1643),G1tensor(1644))
  call G_TensorShift(G1tensor(1640),8)
  call Hotf_5pt_reduction_last(G2tensor(857),RedSet_5(24),mass5set(:,3),  & 
G1tensor(1645),G1tensor(1646),G1tensor(1647),G1tensor(1648),G1tensor(1649),G1tensor(1650))
  call G_TensorShift(G1tensor(1646),4)
  call Hotf_5pt_reduction_last(G2tensor(861),RedSet_5(24),mass5set(:,5),  & 
G1tensor(1651),G1tensor(1652),G1tensor(1653),G1tensor(1654),G1tensor(1655),G1tensor(1656))
  call G_TensorShift(G1tensor(1652),4)
  call Hotf_5pt_reduction_last(G2tensor(881),RedSet_5(22),mass5set(:,3),  & 
G1tensor(1657),G1tensor(1658),G1tensor(1659),G1tensor(1660),G1tensor(1661),G1tensor(1662))
  call G_TensorShift(G1tensor(1658),16)
  call Hotf_5pt_reduction_last(G2tensor(885),RedSet_5(22),mass5set(:,13),  & 
G1tensor(1663),G1tensor(1664),G1tensor(1665),G1tensor(1666),G1tensor(1667),G1tensor(1668))
  call G_TensorShift(G1tensor(1664),16)
  call Hotf_5pt_reduction_last(G2tensor(889),RedSet_5(43),mass5set(:,3),  & 
G1tensor(1669),G1tensor(1670),G1tensor(1671),G1tensor(1672),G1tensor(1673),G1tensor(1674))
  call G_TensorShift(G1tensor(1670),16)
  call Hotf_5pt_reduction_last(G2tensor(893),RedSet_5(43),mass5set(:,4),  & 
G1tensor(1675),G1tensor(1676),G1tensor(1677),G1tensor(1678),G1tensor(1679),G1tensor(1680))
  call G_TensorShift(G1tensor(1676),16)
  call Hotf_5pt_reduction_last(G2tensor(898),RedSet_5(25),mass5set(:,3),  & 
G1tensor(1681),G1tensor(1682),G1tensor(1683),G1tensor(1684),G1tensor(1685),G1tensor(1686))
  call G_TensorShift(G1tensor(1682),16)
  call Hotf_5pt_reduction_last(G2tensor(902),RedSet_5(25),mass5set(:,13),  & 
G1tensor(1687),G1tensor(1688),G1tensor(1689),G1tensor(1690),G1tensor(1691),G1tensor(1692))
  call G_TensorShift(G1tensor(1688),16)
  call Hotf_5pt_reduction_last(G2tensor(906),RedSet_5(44),mass5set(:,3),  & 
G1tensor(1693),G1tensor(1694),G1tensor(1695),G1tensor(1696),G1tensor(1697),G1tensor(1698))
  call G_TensorShift(G1tensor(1694),16)
  call Hotf_5pt_reduction_last(G2tensor(910),RedSet_5(44),mass5set(:,4),  & 
G1tensor(1699),G1tensor(1700),G1tensor(1701),G1tensor(1702),G1tensor(1703),G1tensor(1704))
  call G_TensorShift(G1tensor(1700),16)
  call Hotf_5pt_reduction_last(G2tensor(923),RedSet_5(4),mass5set(:,3),  & 
G1tensor(1705),G1tensor(1706),G1tensor(1707),G1tensor(1708),G1tensor(1709),G1tensor(1710))
  call G_TensorShift(G1tensor(1706),12)
  call Hotf_5pt_reduction_last(G2tensor(927),RedSet_5(4),mass5set(:,4),  & 
G1tensor(1711),G1tensor(1712),G1tensor(1713),G1tensor(1714),G1tensor(1715),G1tensor(1716))
  call G_TensorShift(G1tensor(1712),12)
  call Hotf_5pt_reduction_last(G2tensor(939),RedSet_5(23),mass5set(:,3),  & 
G1tensor(1717),G1tensor(1718),G1tensor(1719),G1tensor(1720),G1tensor(1721),G1tensor(1722))
  call G_TensorShift(G1tensor(1718),16)
  call Hotf_5pt_reduction_last(G2tensor(943),RedSet_5(23),mass5set(:,13),  & 
G1tensor(1723),G1tensor(1724),G1tensor(1725),G1tensor(1726),G1tensor(1727),G1tensor(1728))
  call G_TensorShift(G1tensor(1724),16)
  call Hotf_5pt_reduction_last(G2tensor(955),RedSet_5(6),mass5set(:,3),  & 
G1tensor(1729),G1tensor(1730),G1tensor(1731),G1tensor(1732),G1tensor(1733),G1tensor(1734))
  call G_TensorShift(G1tensor(1730),12)
  call Hotf_5pt_reduction_last(G2tensor(959),RedSet_5(6),mass5set(:,4),  & 
G1tensor(1735),G1tensor(1736),G1tensor(1737),G1tensor(1738),G1tensor(1739),G1tensor(1740))
  call G_TensorShift(G1tensor(1736),12)
  call Hotf_5pt_reduction_last(G2tensor(971),RedSet_5(45),mass5set(:,3),  & 
G1tensor(1741),G1tensor(1742),G1tensor(1743),G1tensor(1744),G1tensor(1745),G1tensor(1746))
  call G_TensorShift(G1tensor(1742),16)
  call Hotf_5pt_reduction_last(G2tensor(975),RedSet_5(45),mass5set(:,4),  & 
G1tensor(1747),G1tensor(1748),G1tensor(1749),G1tensor(1750),G1tensor(1751),G1tensor(1752))
  call G_TensorShift(G1tensor(1748),16)
  call Hotf_5pt_reduction_last(G2tensor(980),RedSet_5(21),mass5set(:,3),  & 
G1tensor(1753),G1tensor(1754),G1tensor(1755),G1tensor(1756),G1tensor(1757),G1tensor(1758))
  call G_TensorShift(G1tensor(1754),16)
  call Hotf_5pt_reduction_last(G2tensor(984),RedSet_5(21),mass5set(:,13),  & 
G1tensor(1759),G1tensor(1760),G1tensor(1761),G1tensor(1762),G1tensor(1763),G1tensor(1764))
  call G_TensorShift(G1tensor(1760),16)
  call Hotf_5pt_reduction_last(G2tensor(988),RedSet_5(46),mass5set(:,3),  & 
G1tensor(1765),G1tensor(1766),G1tensor(1767),G1tensor(1768),G1tensor(1769),G1tensor(1770))
  call G_TensorShift(G1tensor(1766),16)
  call Hotf_5pt_reduction_last(G2tensor(992),RedSet_5(46),mass5set(:,4),  & 
G1tensor(1771),G1tensor(1772),G1tensor(1773),G1tensor(1774),G1tensor(1775),G1tensor(1776))
  call G_TensorShift(G1tensor(1772),16)
  call ol_merge_tensors(T1sum(55),[G1tensor(1)])
  call ol_merge_tensors(T1sum(56),[G1tensor(37)])
  call ol_merge_tensors(T1sum(57),[G1tensor(73)])
  call ol_merge_tensors(T1sum(58),[G1tensor(109)])
  call ol_merge_tensors(T1sum(59),[G1tensor(145)])
  call ol_merge_tensors(T1sum(60),[G1tensor(181)])
  call ol_merge_tensors(T1sum(61),[G1tensor(217)])
  call ol_merge_tensors(T1sum(62),[G1tensor(253)])
  call ol_merge_tensors(T1sum(63),[G1tensor(289)])
  call ol_merge_tensors(T1sum(64),[G1tensor(2)])
  call ol_merge_tensors(T1sum(65),[G1tensor(50)])
  call ol_merge_tensors(T1sum(66),[G1tensor(86)])
  call ol_merge_tensors(T1sum(67),[G1tensor(122)])
  call ol_merge_tensors(T1sum(68),[G1tensor(158)])
  call ol_merge_tensors(T1sum(69),[G1tensor(194)])
  call ol_merge_tensors(T1sum(70),[G1tensor(230)])
  call ol_merge_tensors(T1sum(71),[G1tensor(266)])
  call ol_merge_tensors(T1sum(72),[G1tensor(302)])
  call ol_merge_tensors(T1sum(73),[G1tensor(5)])
  call ol_merge_tensors(T1sum(74),[G1tensor(15)])
  call ol_merge_tensors(T1sum(75),[G1tensor(23)])
  call ol_merge_tensors(T1sum(76),[G1tensor(30)])
  call ol_merge_tensors(T1sum(77),[G1tensor(39)])
  call ol_merge_tensors(T1sum(78),[G1tensor(58)])
  call ol_merge_tensors(T1sum(79),[G1tensor(54)])
  call ol_merge_tensors(T1sum(80),[G1tensor(64)])
  call ol_merge_tensors(T1sum(81),[G1tensor(71)])
  call ol_merge_tensors(T1sum(82),[G1tensor(83)])
  call ol_merge_tensors(T1sum(83),[G1tensor(90)])
  call ol_merge_tensors(T1sum(84),[G1tensor(100)])
  call ol_merge_tensors(T1sum(85),[G1tensor(111)])
  call ol_merge_tensors(T1sum(86),[G1tensor(130)])
  call ol_merge_tensors(T1sum(87),[G1tensor(126)])
  call ol_merge_tensors(T1sum(88),[G1tensor(136)])
  call ol_merge_tensors(T1sum(89),[G1tensor(197)])
  call ol_merge_tensors(T1sum(90),[G1tensor(148)])
  call ol_merge_tensors(T1sum(91),[G1tensor(159)])
  call ol_merge_tensors(T1sum(92),[G1tensor(162)])
  call ol_merge_tensors(T1sum(93),[G1tensor(171)])
  call ol_merge_tensors(T1sum(94),[G1tensor(227)])
  call ol_merge_tensors(T1sum(95),[G1tensor(186)])
  call ol_merge_tensors(T1sum(96),[G1tensor(198)])
  call ol_merge_tensors(T1sum(97),[G1tensor(210)])
  call ol_merge_tensors(T1sum(98),[G1tensor(220)])
  call ol_merge_tensors(T1sum(99),[G1tensor(233)])
  call ol_merge_tensors(T1sum(100),[G1tensor(252)])
  call ol_merge_tensors(T1sum(101),[G1tensor(245)])
  call ol_merge_tensors(T1sum(102),[G1tensor(256)])
  call ol_merge_tensors(T1sum(103),[G1tensor(274)])
  call ol_merge_tensors(T1sum(104),[G1tensor(269)])
  call ol_merge_tensors(T1sum(105),[G1tensor(279)])
  call ol_merge_tensors(T1sum(106),[G1tensor(300)])
  call ol_merge_tensors(T1sum(107),[G1tensor(303)])
  call ol_merge_tensors(T1sum(108),[G1tensor(322)])
  call ol_merge_tensors(T1sum(109),[G1tensor(325)])
  call ol_merge_tensors(T1sum(110),[G1tensor(331)])
  call ol_merge_tensors(T1sum(111),[G1tensor(337)])
  call ol_merge_tensors(T1sum(112),[G1tensor(343)])
  call ol_merge_tensors(T1sum(113),[G1tensor(349)])
  call ol_merge_tensors(T1sum(114),[G1tensor(355)])
  call ol_merge_tensors(T1sum(115),[G1tensor(361)])
  call ol_merge_tensors(T1sum(116),[G1tensor(367)])
  call ol_merge_tensors(T1sum(117),[G1tensor(373)])
  call ol_merge_tensors(T1sum(118),[G1tensor(379)])
  call ol_merge_tensors(T1sum(119),[G1tensor(385)])
  call ol_merge_tensors(T1sum(120),[G1tensor(391)])
  call ol_merge_tensors(T1sum(121),[G1tensor(397)])
  call ol_merge_tensors(T1sum(122),[G1tensor(403)])
  call ol_merge_tensors(T1sum(123),[G1tensor(409)])
  call ol_merge_tensors(T1sum(124),[G1tensor(415)])
  call ol_merge_tensors(T1sum(125),[G1tensor(421)])
  call ol_merge_tensors(T1sum(126),[G1tensor(427)])
  call ol_merge_tensors(T1sum(127),[G1tensor(433)])
  call ol_merge_tensors(T1sum(128),[G1tensor(439)])
  call ol_merge_tensors(T1sum(129),[G1tensor(445)])
  call ol_merge_tensors(T1sum(130),[G1tensor(451)])
  call ol_merge_tensors(T1sum(131),[G1tensor(457)])
  call ol_merge_tensors(T1sum(132),[G1tensor(463)])
  call ol_merge_tensors(T1sum(133),[G1tensor(469)])
  call ol_merge_tensors(T1sum(134),[G1tensor(475)])
  call ol_merge_tensors(T1sum(135),[G1tensor(481)])
  call ol_merge_tensors(T1sum(136),[G1tensor(487)])
  call ol_merge_tensors(T1sum(137),[G1tensor(493)])
  call ol_merge_tensors(T1sum(138),[G1tensor(499)])
  call ol_merge_tensors(T1sum(139),[G1tensor(505)])
  call ol_merge_tensors(T1sum(140),[G1tensor(511)])
  call ol_merge_tensors(T1sum(141),[G1tensor(517)])
  call ol_merge_tensors(T1sum(142),[G1tensor(523)])
  call ol_merge_tensors(T1sum(143),[G1tensor(529)])
  call ol_merge_tensors(T1sum(144),[G1tensor(535)])
  call ol_merge_tensors(T1sum(145),[G1tensor(541)])
  call ol_merge_tensors(T1sum(146),[G1tensor(547)])
  call ol_merge_tensors(T1sum(147),[G1tensor(553)])
  call ol_merge_tensors(T1sum(148),[G1tensor(559)])
  call ol_merge_tensors(T1sum(149),[G1tensor(565)])
  call ol_merge_tensors(T1sum(150),[G1tensor(571)])
  call ol_merge_tensors(T1sum(151),[G1tensor(577)])
  call ol_merge_tensors(T1sum(152),[G1tensor(583)])
  call ol_merge_tensors(T1sum(153),[G1tensor(589)])
  call ol_merge_tensors(T1sum(154),[G1tensor(595)])
  call ol_merge_tensors(T1sum(155),[G1tensor(601)])
  call ol_merge_tensors(T1sum(156),[G1tensor(607)])
  call ol_merge_tensors(T1sum(157),[G1tensor(613)])
  call ol_merge_tensors(T1sum(158),[G1tensor(619)])
  call ol_merge_tensors(T1sum(159),[G1tensor(625)])
  call ol_merge_tensors(T1sum(160),[G1tensor(631)])
  call ol_merge_tensors(T1sum(161),[G1tensor(637)])
  call ol_merge_tensors(T1sum(162),[G1tensor(643)])
  call ol_merge_tensors(T1sum(163),[G1tensor(649)])
  call ol_merge_tensors(T1sum(164),[G1tensor(655)])
  call ol_merge_tensors(T1sum(165),[G1tensor(661)])
  call ol_merge_tensors(T1sum(166),[G1tensor(667)])
  call ol_merge_tensors(T1sum(167),[G1tensor(673)])
  call ol_merge_tensors(T1sum(168),[G1tensor(679)])
  call ol_merge_tensors(T1sum(169),[G1tensor(685)])
  call ol_merge_tensors(T1sum(170),[G1tensor(691)])
  call ol_merge_tensors(T1sum(171),[G1tensor(697)])
  call ol_merge_tensors(T1sum(172),[G1tensor(703)])
  call ol_merge_tensors(T1sum(173),[G1tensor(709)])
  call ol_merge_tensors(T1sum(174),[G1tensor(715)])
  call ol_merge_tensors(T1sum(175),[G1tensor(721)])
  call ol_merge_tensors(T1sum(176),[G1tensor(727)])
  call ol_merge_tensors(T1sum(177),[G1tensor(733)])
  call ol_merge_tensors(T1sum(178),[G1tensor(739)])
  call ol_merge_tensors(T1sum(179),[G1tensor(745)])
  call ol_merge_tensors(T1sum(180),[G1tensor(751)])
  call ol_merge_tensors(T1sum(181),[G1tensor(757)])
  call ol_merge_tensors(T1sum(182),[G1tensor(763)])
  call ol_merge_tensors(T1sum(183),[G1tensor(769)])
  call ol_merge_tensors(T1sum(184),[G1tensor(775)])
  call ol_merge_tensors(T1sum(185),[G1tensor(781)])
  call ol_merge_tensors(T1sum(186),[G1tensor(787)])
  call ol_merge_tensors(T1sum(187),[G1tensor(793)])
  call ol_merge_tensors(T1sum(188),[G1tensor(799)])
  call ol_merge_tensors(T1sum(189),[G1tensor(805)])
  call ol_merge_tensors(T1sum(190),[G1tensor(811)])
  call ol_merge_tensors(T1sum(191),[G1tensor(817)])
  call ol_merge_tensors(T1sum(192),[G1tensor(823)])
  call ol_merge_tensors(T1sum(193),[G1tensor(829)])
  call ol_merge_tensors(T1sum(194),[G1tensor(835)])
  call ol_merge_tensors(T1sum(195),[G1tensor(841)])
  call ol_merge_tensors(T1sum(196),[G1tensor(847)])
  call ol_merge_tensors(T1sum(197),[G1tensor(853)])
  call ol_merge_tensors(T1sum(198),[G1tensor(859)])
  call ol_merge_tensors(T1sum(199),[G1tensor(865)])
  call ol_merge_tensors(T1sum(200),[G1tensor(871)])
  call ol_merge_tensors(T1sum(201),[G1tensor(877)])
  call ol_merge_tensors(T1sum(202),[G1tensor(883)])
  call ol_merge_tensors(T1sum(203),[G1tensor(889)])
  call ol_merge_tensors(T1sum(204),[G1tensor(895)])
  call ol_merge_tensors(T1sum(205),[G1tensor(901)])
  call ol_merge_tensors(T1sum(206),[G1tensor(907)])
  call ol_merge_tensors(T1sum(207),[G1tensor(913)])
  call ol_merge_tensors(T1sum(208),[G1tensor(919)])
  call ol_merge_tensors(T1sum(209),[G1tensor(925)])
  call ol_merge_tensors(T1sum(210),[G1tensor(931)])
  call ol_merge_tensors(T1sum(211),[G1tensor(937)])
  call ol_merge_tensors(T1sum(212),[G1tensor(943)])
  call ol_merge_tensors(T1sum(213),[G1tensor(949)])
  call ol_merge_tensors(T1sum(214),[G1tensor(955)])
  call ol_merge_tensors(T1sum(215),[G1tensor(961)])
  call ol_merge_tensors(T1sum(216),[G1tensor(967)])
  call ol_merge_tensors(T1sum(217),[G1tensor(973)])
  call ol_merge_tensors(T1sum(218),[G1tensor(979)])
  call ol_merge_tensors(T1sum(219),[G1tensor(985)])
  call ol_merge_tensors(T1sum(220),[G1tensor(991)])
  call ol_merge_tensors(T1sum(221),[G1tensor(997)])
  call ol_merge_tensors(T1sum(222),[G1tensor(1003)])
  call ol_merge_tensors(T1sum(223),[G1tensor(1009)])
  call ol_merge_tensors(T1sum(224),[G1tensor(1015)])
  call ol_merge_tensors(T1sum(225),[G1tensor(1021)])
  call ol_merge_tensors(T1sum(226),[G1tensor(1027)])
  call ol_merge_tensors(T1sum(227),[G1tensor(1033)])
  call ol_merge_tensors(T1sum(228),[G1tensor(1039)])
  call ol_merge_tensors(T1sum(229),[G1tensor(1045)])
  call ol_merge_tensors(T1sum(230),[G1tensor(1051)])
  call ol_merge_tensors(T1sum(231),[G1tensor(1057)])
  call ol_merge_tensors(T1sum(232),[G1tensor(1063)])
  call ol_merge_tensors(T1sum(233),[G1tensor(1069)])
  call ol_merge_tensors(T1sum(234),[G1tensor(1075)])
  call ol_merge_tensors(T1sum(235),[G1tensor(1081)])
  call ol_merge_tensors(T1sum(236),[G1tensor(1087)])
  call ol_merge_tensors(T1sum(237),[G1tensor(1093)])
  call ol_merge_tensors(T1sum(238),[G1tensor(1099)])
  call ol_merge_tensors(T1sum(239),[G1tensor(1105)])
  call ol_merge_tensors(T1sum(240),[G1tensor(1111)])
  call ol_merge_tensors(T1sum(241),[G1tensor(1117)])
  call ol_merge_tensors(T1sum(242),[G1tensor(1123)])
  call ol_merge_tensors(T1sum(243),[G1tensor(1129)])
  call ol_merge_tensors(T1sum(244),[G1tensor(1135)])
  call ol_merge_tensors(T1sum(245),[G1tensor(1141)])
  call ol_merge_tensors(T1sum(246),[G1tensor(1147)])
  call ol_merge_tensors(T1sum(247),[G1tensor(1153)])
  call ol_merge_tensors(T1sum(248),[G1tensor(1159)])
  call ol_merge_tensors(T1sum(249),[G1tensor(1165)])
  call ol_merge_tensors(T1sum(250),[G1tensor(1171)])
  call ol_merge_tensors(T1sum(251),[G1tensor(1177)])
  call ol_merge_tensors(T1sum(252),[G1tensor(1183)])
  call ol_merge_tensors(T1sum(253),[G1tensor(1189)])
  call ol_merge_tensors(T1sum(254),[G1tensor(1195)])
  call ol_merge_tensors(T1sum(255),[G1tensor(1201)])
  call ol_merge_tensors(T1sum(256),[G1tensor(1207)])
  call ol_merge_tensors(T1sum(257),[G1tensor(1213)])
  call ol_merge_tensors(T1sum(258),[G1tensor(1219)])
  call ol_merge_tensors(T1sum(259),[G1tensor(1225)])
  call ol_merge_tensors(T1sum(260),[G1tensor(1231)])
  call ol_merge_tensors(T1sum(261),[G1tensor(1237)])
  call ol_merge_tensors(T1sum(262),[G1tensor(1243)])
  call ol_merge_tensors(T1sum(263),[G1tensor(1249)])
  call ol_merge_tensors(T1sum(264),[G1tensor(1255)])
  call ol_merge_tensors(T1sum(265),[G1tensor(1261)])
  call ol_merge_tensors(T1sum(266),[G1tensor(1267)])
  call ol_merge_tensors(T1sum(267),[G1tensor(1273)])
  call ol_merge_tensors(T1sum(268),[G1tensor(1279)])
  call ol_merge_tensors(T1sum(269),[G1tensor(1285)])
  call ol_merge_tensors(T1sum(270),[G1tensor(1291)])
  call ol_merge_tensors(T1sum(271),[G1tensor(1297)])
  call ol_merge_tensors(T1sum(272),[G1tensor(1303)])
  call ol_merge_tensors(T1sum(273),[G1tensor(1309)])
  call ol_merge_tensors(T1sum(274),[G1tensor(1315)])
  call ol_merge_tensors(T1sum(275),[G1tensor(1321)])
  call ol_merge_tensors(T1sum(276),[G1tensor(1327)])
  call ol_merge_tensors(T1sum(277),[G1tensor(1333)])
  call ol_merge_tensors(T1sum(278),[G1tensor(1339)])
  call ol_merge_tensors(T1sum(279),[G1tensor(1345)])
  call ol_merge_tensors(T1sum(280),[G1tensor(1351)])
  call ol_merge_tensors(T1sum(281),[G1tensor(1357)])
  call ol_merge_tensors(T1sum(282),[G1tensor(1363)])
  call ol_merge_tensors(T1sum(283),[G1tensor(1369)])
  call ol_merge_tensors(T1sum(284),[G1tensor(1375)])
  call ol_merge_tensors(T1sum(285),[G1tensor(1381)])
  call ol_merge_tensors(T1sum(286),[G1tensor(1387)])
  call ol_merge_tensors(T1sum(287),[G1tensor(1393)])
  call ol_merge_tensors(T1sum(288),[G1tensor(1399)])
  call ol_merge_tensors(T1sum(289),[G1tensor(1405)])
  call ol_merge_tensors(T1sum(290),[G1tensor(1411)])
  call ol_merge_tensors(T1sum(291),[G1tensor(1417)])
  call ol_merge_tensors(T1sum(292),[G1tensor(1423)])
  call ol_merge_tensors(T1sum(293),[G1tensor(1429)])
  call ol_merge_tensors(T1sum(294),[G1tensor(1435)])
  call ol_merge_tensors(T1sum(295),[G1tensor(1441)])
  call ol_merge_tensors(T1sum(296),[G1tensor(1447)])
  call ol_merge_tensors(T1sum(297),[G1tensor(1453)])
  call ol_merge_tensors(T1sum(298),[G1tensor(1459)])
  call ol_merge_tensors(T1sum(299),[G1tensor(1465)])
  call ol_merge_tensors(T1sum(300),[G1tensor(1471)])
  call ol_merge_tensors(T1sum(301),[G1tensor(1477)])
  call ol_merge_tensors(T1sum(302),[G1tensor(1483)])
  call ol_merge_tensors(T1sum(303),[G1tensor(1489)])
  call ol_merge_tensors(T1sum(304),[G1tensor(1495)])
  call ol_merge_tensors(T1sum(305),[G1tensor(1501)])
  call ol_merge_tensors(T1sum(306),[G1tensor(1507)])
  call ol_merge_tensors(T1sum(307),[G1tensor(1513)])
  call ol_merge_tensors(T1sum(308),[G1tensor(1519)])
  call ol_merge_tensors(T1sum(309),[G1tensor(1525)])
  call ol_merge_tensors(T1sum(310),[G1tensor(1531)])
  call ol_merge_tensors(T1sum(311),[G1tensor(1537)])
  call ol_merge_tensors(T1sum(312),[G1tensor(1543)])
  call ol_merge_tensors(T1sum(313),[G1tensor(1549)])
  call ol_merge_tensors(T1sum(314),[G1tensor(1555)])
  call ol_merge_tensors(T1sum(315),[G1tensor(1561)])
  call ol_merge_tensors(T1sum(316),[G1tensor(1567)])
  call ol_merge_tensors(T1sum(317),[G1tensor(1573)])
  call ol_merge_tensors(T1sum(318),[G1tensor(1579)])
  call ol_merge_tensors(T1sum(319),[G1tensor(1585)])
  call ol_merge_tensors(T1sum(320),[G1tensor(1591)])
  call ol_merge_tensors(T1sum(321),[G1tensor(1597)])
  call ol_merge_tensors(T1sum(322),[G1tensor(1603)])
  call ol_merge_tensors(T1sum(323),[G1tensor(1609)])
  call ol_merge_tensors(T1sum(324),[G1tensor(1615)])
  call ol_merge_tensors(T1sum(325),[G1tensor(1621)])
  call ol_merge_tensors(T1sum(326),[G1tensor(1627)])
  call ol_merge_tensors(T1sum(327),[G1tensor(1633)])
  call ol_merge_tensors(T1sum(328),[G1tensor(1639)])
  call ol_merge_tensors(T1sum(329),[G1tensor(1645)])
  call ol_merge_tensors(T1sum(330),[G1tensor(1651)])
  call ol_merge_tensors(T1sum(331),[G1tensor(1657)])
  call ol_merge_tensors(T1sum(332),[G1tensor(1663)])
  call ol_merge_tensors(T1sum(333),[G1tensor(1669)])
  call ol_merge_tensors(T1sum(334),[G1tensor(1675)])
  call ol_merge_tensors(T1sum(335),[G1tensor(1681)])
  call ol_merge_tensors(T1sum(336),[G1tensor(1687)])
  call ol_merge_tensors(T1sum(337),[G1tensor(1693)])
  call ol_merge_tensors(T1sum(338),[G1tensor(1699)])
  call ol_merge_tensors(T1sum(339),[G1tensor(1705)])
  call ol_merge_tensors(T1sum(340),[G1tensor(1711)])
  call ol_merge_tensors(T1sum(341),[G1tensor(1717)])
  call ol_merge_tensors(T1sum(342),[G1tensor(1723)])
  call ol_merge_tensors(T1sum(343),[G1tensor(1729)])
  call ol_merge_tensors(T1sum(344),[G1tensor(1735)])
  call ol_merge_tensors(T1sum(345),[G1tensor(1741)])
  call ol_merge_tensors(T1sum(346),[G1tensor(1747)])
  call ol_merge_tensors(T1sum(347),[G1tensor(1753)])
  call ol_merge_tensors(T1sum(348),[G1tensor(1759)])
  call ol_merge_tensors(T1sum(349),[G1tensor(1765)])
  call ol_merge_tensors(T1sum(350),[G1tensor(1771)])
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[35,8,4,16],[nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(13),m4h2x4x8(:,1),heltab3x64(:,:,3))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[35,8,4,16],[nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),wf4(:,6),G0H8(12),m4h2x4x8(:,2),heltab3x64(:,:,4))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[35,4,8,16],[nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),wf4(:,1),G0H8(11),m4h2x4x8(:,3),heltab3x64(:,:,5))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[35,4,8,16],[nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),wf4(:,6),G0H8(4),m4h2x4x8(:,4),heltab3x64(:,:,6))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[32,4,8,19],[nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(1),m3h2x32(:,283),heltab2x64(:,:,355))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[32,4,8,19],[nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(2),m3h2x32(:,284),heltab2x64(:,:,356))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[32,8,4,19],[nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(3),m3h2x32(:,285),heltab2x64(:,:,357))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[32,8,4,19],[nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(4),m3h2x32(:,286),heltab2x64(:,:,358))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[48,3,4,8],[nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(1),m4h2x2x16(:,3),heltab3x64(:,:,7))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[48,3,4,8],[nMW,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(2),m4h2x2x16(:,4),heltab3x64(:,:,8))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[48,3,8,4],[nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(3),m4h2x2x16(:,5),heltab3x64(:,:,9))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[48,3,8,4],[nMW,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(4),m4h2x2x16(:,6),heltab3x64(:,:,10))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[48,4,3,8],[nMW,0,0,nMW],5,1,wf4(:,6))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(5),m4h2x2x16(:,7),heltab3x64(:,:,11))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[44,2,1,16],[nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),wf4(:,13),G0H8(3),m4h2x4x8(:,5),heltab3x64(:,:,12))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[44,2,1,16],[nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),wf4(:,16),G0H8(10),m4h2x4x8(:,6),heltab3x64(:,:,13))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[44,1,2,16],[nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),wf4(:,13),G0H8(9),m4h2x4x8(:,7),heltab3x64(:,:,14))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[44,1,2,16],[nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),wf4(:,16),G0H8(6),m4h2x4x8(:,8),heltab3x64(:,:,15))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[32,1,2,28],[nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(5),m3h2x32(:,287),heltab2x64(:,:,359))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[32,1,2,28],[nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,288),heltab2x64(:,:,360))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[32,2,1,28],[nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,289),heltab2x64(:,:,361))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[32,2,1,28],[nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,290),heltab2x64(:,:,362))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[48,2,1,12],[nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(6),m4h2x2x16(:,8),heltab3x64(:,:,16))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[48,2,1,12],[nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(7),m4h2x2x16(:,9),heltab3x64(:,:,17))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[48,1,2,12],[nMW,0,nMW,nMW],5,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(8),m4h2x2x16(:,10),heltab3x64(:,:,18))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[48,1,2,12],[nMW,0,nMW,nMW],5,1,wf4(:,16))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(9),m4h2x2x16(:,11),heltab3x64(:,:,19))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[48,1,12,2],[nMW,0,0,nMW],5,1,wf4(:,16))
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(10),m4h2x2x16(:,12),heltab3x64(:,:,20))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,291),heltab2x64(:,:,363))
  call Hloop_A_Q(ntryL,G0H32(53),32,0,G1H32(9),n2h32(161))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[32,12,3,16],[nML,nML,nML,nML],4,2,wf4(:,13),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,292),heltab2x64(:,:,364))
  call Hloop_A_Q(ntryL,G0H32(4),32,nML,G1H32(10),n2h32(162))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,293),heltab2x64(:,:,365))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(11),n2h32(163))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[32,12,3,16],[nML,nML,nML,nML],4,2,wf4(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,294),heltab2x64(:,:,366))
  call Hloop_Q_A(ntryL,G0H32(1),32,nML,G1H32(12),n2h32(164))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,295),heltab2x64(:,:,367))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(13),n2h32(165))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,13),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,296),heltab2x64(:,:,368))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMT,G1H32(14),n2h32(166))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,297),heltab2x64(:,:,369))
  call Hloop_Q_A(ntryL,G0H32(6),32,0,G1H32(15),n2h32(167))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,298),heltab2x64(:,:,370))
  call Hloop_Q_A(ntryL,G0H32(7),32,nMT,G1H32(16),n2h32(168))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,299),heltab2x64(:,:,371))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(17),n2h32(169))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,13),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,300),heltab2x64(:,:,372))
  call Hloop_A_Q(ntryL,G0H32(9),32,nMB,G1H32(18),n2h32(170))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,301),heltab2x64(:,:,373))
  call Hloop_Q_A(ntryL,G0H32(10),32,0,G1H32(19),n2h32(171))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,302),heltab2x64(:,:,374))
  call Hloop_Q_A(ntryL,G0H32(11),32,nMB,G1H32(20),n2h32(172))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,303),heltab2x64(:,:,375))
  call Hloop_A_Q(ntryL,G0H32(12),32,0,G1H32(21),n2h32(173))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[32,12,3,16],[nML,nML,nML,nML],4,2,wf4(:,16),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,304),heltab2x64(:,:,376))
  call Hloop_A_Q(ntryL,G0H32(13),32,nML,G1H32(22),n2h32(174))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,305),heltab2x64(:,:,377))
  call Hloop_Q_A(ntryL,G0H32(14),32,0,G1H32(23),n2h32(175))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[32,12,3,16],[nML,nML,nML,nML],4,2,wf4(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,306),heltab2x64(:,:,378))
  call Hloop_Q_A(ntryL,G0H32(15),32,nML,G1H32(24),n2h32(176))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,307),heltab2x64(:,:,379))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(25),n2h32(177))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,308),heltab2x64(:,:,380))
  call Hloop_A_Q(ntryL,G0H32(17),32,nMT,G1H32(26),n2h32(178))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,309),heltab2x64(:,:,381))
  call Hloop_Q_A(ntryL,G0H32(18),32,0,G1H32(27),n2h32(179))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,310),heltab2x64(:,:,382))
  call Hloop_Q_A(ntryL,G0H32(19),32,nMT,G1H32(28),n2h32(180))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,311),heltab2x64(:,:,383))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(29),n2h32(181))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,312),heltab2x64(:,:,384))
  call Hloop_A_Q(ntryL,G0H32(21),32,nMB,G1H32(30),n2h32(182))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,313),heltab2x64(:,:,385))
  call Hloop_Q_A(ntryL,G0H32(22),32,0,G1H32(31),n2h32(183))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,314),heltab2x64(:,:,386))
  call Hloop_Q_A(ntryL,G0H32(23),32,nMB,G1H32(32),n2h32(184))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,315),heltab2x64(:,:,387))
  call Hloop_A_Q(ntryL,G0H32(24),32,0,G1H32(33),n2h32(185))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[32,12,3,16],[nML,nML,nML,nML],4,2,wf4(:,13),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,316),heltab2x64(:,:,388))
  call Hloop_A_Q(ntryL,G0H32(25),32,nML,G1H32(34),n2h32(186))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,317),heltab2x64(:,:,389))
  call Hloop_Q_A(ntryL,G0H32(26),32,0,G1H32(35),n2h32(187))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[32,12,3,16],[nML,nML,nML,nML],4,2,wf4(:,13),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,318),heltab2x64(:,:,390))
  call Hloop_Q_A(ntryL,G0H32(27),32,nML,G1H32(36),n2h32(188))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,319),heltab2x64(:,:,391))
  call Hloop_A_Q(ntryL,G0H32(28),32,0,G1H32(37),n2h32(189))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,13),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,320),heltab2x64(:,:,392))
  call Hloop_A_Q(ntryL,G0H32(29),32,nMT,G1H32(38),n2h32(190))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,321),heltab2x64(:,:,393))
  call Hloop_Q_A(ntryL,G0H32(30),32,0,G1H32(39),n2h32(191))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,13),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,322),heltab2x64(:,:,394))
  call Hloop_Q_A(ntryL,G0H32(31),32,nMT,G1H32(40),n2h32(192))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,323),heltab2x64(:,:,395))
  call Hloop_A_Q(ntryL,G0H32(32),32,0,G1H32(41),n2h32(193))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,13),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,324),heltab2x64(:,:,396))
  call Hloop_A_Q(ntryL,G0H32(33),32,nMB,G1H32(42),n2h32(194))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[32,12,3,16],[0,0,0,0],4,2,wf4(:,13),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,325),heltab2x64(:,:,397))
  call Hloop_Q_A(ntryL,G0H32(34),32,0,G1H32(43),n2h32(195))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,13),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,326),heltab2x64(:,:,398))
  call Hloop_Q_A(ntryL,G0H32(35),32,nMB,G1H32(44),n2h32(196))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,327),heltab2x64(:,:,399))
  call Hloop_A_Q(ntryL,G0H32(36),32,0,G1H32(45),n2h32(197))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[32,12,3,16],[nML,nML,nML,nML],4,2,wf4(:,16),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,328),heltab2x64(:,:,400))
  call Hloop_A_Q(ntryL,G0H32(37),32,nML,G1H32(46),n2h32(198))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,329),heltab2x64(:,:,401))
  call Hloop_Q_A(ntryL,G0H32(38),32,0,G1H32(47),n2h32(199))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[32,12,3,16],[nML,nML,nML,nML],4,2,wf4(:,16),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,330),heltab2x64(:,:,402))
  call Hloop_Q_A(ntryL,G0H32(39),32,nML,G1H32(48),n2h32(200))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,331),heltab2x64(:,:,403))
  call Hloop_A_Q(ntryL,G0H32(40),32,0,G1H32(49),n2h32(201))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,332),heltab2x64(:,:,404))
  call Hloop_A_Q(ntryL,G0H32(41),32,nMT,G1H32(50),n2h32(202))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,333),heltab2x64(:,:,405))
  call Hloop_Q_A(ntryL,G0H32(42),32,0,G1H32(51),n2h32(203))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,334),heltab2x64(:,:,406))
  call Hloop_Q_A(ntryL,G0H32(43),32,nMT,G1H32(52),n2h32(204))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,335),heltab2x64(:,:,407))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(53),n2h32(205))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,336),heltab2x64(:,:,408))
  call Hloop_A_Q(ntryL,G0H32(45),32,nMB,G1H32(54),n2h32(206))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,337),heltab2x64(:,:,409))
  call Hloop_Q_A(ntryL,G0H32(46),32,0,G1H32(55),n2h32(207))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,338),heltab2x64(:,:,410))
  call Hloop_Q_A(ntryL,G0H32(47),32,nMB,G1H32(56),n2h32(208))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(57),m3h2x32(:,339),heltab2x64(:,:,411))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,340),heltab2x64(:,:,412))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(433),h0tab(:,433),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(59),m3h2x32(:,341),heltab2x64(:,:,413))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(434),h0tab(:,434),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,342),heltab2x64(:,:,414))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(435),h0tab(:,435),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(61),m3h2x32(:,343),heltab2x64(:,:,415))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(436),h0tab(:,436),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(62),m3h2x32(:,344),heltab2x64(:,:,416))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(437),h0tab(:,437),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(63),m3h2x32(:,345),heltab2x64(:,:,417))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(438),h0tab(:,438),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(64),m3h2x32(:,346),heltab2x64(:,:,418))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(439),h0tab(:,439),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(65),m3h2x32(:,347),heltab2x64(:,:,419))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(440),h0tab(:,440),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(66),m3h2x32(:,348),heltab2x64(:,:,420))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(441),h0tab(:,441),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(67),m3h2x32(:,349),heltab2x64(:,:,421))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(442),h0tab(:,442),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,350),heltab2x64(:,:,422))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(443),h0tab(:,443),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(69),m3h2x32(:,351),heltab2x64(:,:,423))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(444),h0tab(:,444),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(70),m3h2x32(:,352),heltab2x64(:,:,424))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(445),h0tab(:,445),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(71),m3h2x32(:,353),heltab2x64(:,:,425))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(446),h0tab(:,446),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(72),m3h2x32(:,354),heltab2x64(:,:,426))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(447),h0tab(:,447),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(73),m3h2x32(:,355),heltab2x64(:,:,427))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(448),h0tab(:,448),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(74),m3h2x32(:,356),heltab2x64(:,:,428))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(449),h0tab(:,449),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(75),m3h2x32(:,357),heltab2x64(:,:,429))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(450),h0tab(:,450),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(76),m3h2x32(:,358),heltab2x64(:,:,430))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(451),h0tab(:,451),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(77),m3h2x32(:,359),heltab2x64(:,:,431))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(452),h0tab(:,452),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(78),m3h2x32(:,360),heltab2x64(:,:,432))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(453),h0tab(:,453),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(79),m3h2x32(:,361),heltab2x64(:,:,433))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(454),h0tab(:,454),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(80),m3h2x32(:,362),heltab2x64(:,:,434))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(455),h0tab(:,455),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(81),m3h2x32(:,363),heltab2x64(:,:,435))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(456),h0tab(:,456),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(82),m3h2x32(:,364),heltab2x64(:,:,436))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(457),h0tab(:,457),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(83),m3h2x32(:,365),heltab2x64(:,:,437))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(458),h0tab(:,458),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(84),m3h2x32(:,366),heltab2x64(:,:,438))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(459),h0tab(:,459),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(85),m3h2x32(:,367),heltab2x64(:,:,439))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(460),h0tab(:,460),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(86),m3h2x32(:,368),heltab2x64(:,:,440))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(461),h0tab(:,461),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(87),m3h2x32(:,369),heltab2x64(:,:,441))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(462),h0tab(:,462),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,370),heltab2x64(:,:,442))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(463),h0tab(:,463),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(89),m3h2x32(:,371),heltab2x64(:,:,443))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(464),h0tab(:,464),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(90),m3h2x32(:,372),heltab2x64(:,:,444))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(465),h0tab(:,465),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(91),m3h2x32(:,373),heltab2x64(:,:,445))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(466),h0tab(:,466),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(92),m3h2x32(:,374),heltab2x64(:,:,446))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(467),h0tab(:,467),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(93),m3h2x32(:,375),heltab2x64(:,:,447))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(468),h0tab(:,468),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(94),m3h2x32(:,376),heltab2x64(:,:,448))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(469),h0tab(:,469),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(95),m3h2x32(:,377),heltab2x64(:,:,449))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(470),h0tab(:,470),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(96),m3h2x32(:,378),heltab2x64(:,:,450))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(471),h0tab(:,471),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,379),heltab2x64(:,:,451))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(472),h0tab(:,472),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,380),heltab2x64(:,:,452))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(473),h0tab(:,473),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,381),heltab2x64(:,:,453))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(474),h0tab(:,474),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,382),heltab2x64(:,:,454))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(475),h0tab(:,475),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,383),heltab2x64(:,:,455))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(476),h0tab(:,476),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,384),heltab2x64(:,:,456))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(477),h0tab(:,477),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,385),heltab2x64(:,:,457))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(478),h0tab(:,478),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,386),heltab2x64(:,:,458))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(479),h0tab(:,479),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(97),m3h2x32(:,387),heltab2x64(:,:,459))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(480),h0tab(:,480),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,388),heltab2x64(:,:,460))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(481),h0tab(:,481),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(99),m3h2x32(:,389),heltab2x64(:,:,461))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(482),h0tab(:,482),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(100),m3h2x32(:,390),heltab2x64(:,:,462))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(483),h0tab(:,483),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(101),m3h2x32(:,391),heltab2x64(:,:,463))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(484),h0tab(:,484),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(102),m3h2x32(:,392),heltab2x64(:,:,464))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(485),h0tab(:,485),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(103),m3h2x32(:,393),heltab2x64(:,:,465))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(486),h0tab(:,486),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(104),m3h2x32(:,394),heltab2x64(:,:,466))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(487),h0tab(:,487),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,395),heltab2x64(:,:,467))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(488),h0tab(:,488),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,396),heltab2x64(:,:,468))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(489),h0tab(:,489),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,397),heltab2x64(:,:,469))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(490),h0tab(:,490),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,398),heltab2x64(:,:,470))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(491),h0tab(:,491),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,399),heltab2x64(:,:,471))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(492),h0tab(:,492),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,400),heltab2x64(:,:,472))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(493),h0tab(:,493),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,401),heltab2x64(:,:,473))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(494),h0tab(:,494),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,402),heltab2x64(:,:,474))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(495),h0tab(:,495),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,403),heltab2x64(:,:,475))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(496),h0tab(:,496),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,404),heltab2x64(:,:,476))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(497),h0tab(:,497),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,405),heltab2x64(:,:,477))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(498),h0tab(:,498),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,406),heltab2x64(:,:,478))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(499),h0tab(:,499),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,407),heltab2x64(:,:,479))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(500),h0tab(:,500),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,408),heltab2x64(:,:,480))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(501),h0tab(:,501),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,409),heltab2x64(:,:,481))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(502),h0tab(:,502),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,410),heltab2x64(:,:,482))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(503),h0tab(:,503),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(105),m3h2x32(:,411),heltab2x64(:,:,483))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(504),h0tab(:,504),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(106),m3h2x32(:,412),heltab2x64(:,:,484))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(505),h0tab(:,505),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(107),m3h2x32(:,413),heltab2x64(:,:,485))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(506),h0tab(:,506),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(108),m3h2x32(:,414),heltab2x64(:,:,486))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(507),h0tab(:,507),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(109),m3h2x32(:,415),heltab2x64(:,:,487))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(508),h0tab(:,508),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(110),m3h2x32(:,416),heltab2x64(:,:,488))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(509),h0tab(:,509),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(111),m3h2x32(:,417),heltab2x64(:,:,489))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(510),h0tab(:,510),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(112),m3h2x32(:,418),heltab2x64(:,:,490))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(511),h0tab(:,511),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,419),heltab2x64(:,:,491))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(512),h0tab(:,512),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,420),heltab2x64(:,:,492))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(513),h0tab(:,513),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,421),heltab2x64(:,:,493))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(514),h0tab(:,514),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,422),heltab2x64(:,:,494))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(515),h0tab(:,515),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,423),heltab2x64(:,:,495))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(516),h0tab(:,516),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,424),heltab2x64(:,:,496))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(517),h0tab(:,517),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,425),heltab2x64(:,:,497))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(518),h0tab(:,518),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,426),heltab2x64(:,:,498))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(519),h0tab(:,519),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,427),heltab2x64(:,:,499))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(520),h0tab(:,520),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,428),heltab2x64(:,:,500))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(521),h0tab(:,521),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,429),heltab2x64(:,:,501))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(522),h0tab(:,522),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,430),heltab2x64(:,:,502))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(523),h0tab(:,523),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,431),heltab2x64(:,:,503))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(524),h0tab(:,524),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,432),heltab2x64(:,:,504))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(525),h0tab(:,525),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,433),heltab2x64(:,:,505))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(526),h0tab(:,526),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,434),heltab2x64(:,:,506))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(527),h0tab(:,527),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(113),m3h2x32(:,435),heltab2x64(:,:,507))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(528),h0tab(:,528),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(114),m3h2x32(:,436),heltab2x64(:,:,508))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(529),h0tab(:,529),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(115),m3h2x32(:,437),heltab2x64(:,:,509))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(530),h0tab(:,530),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(116),m3h2x32(:,438),heltab2x64(:,:,510))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(531),h0tab(:,531),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(117),m3h2x32(:,439),heltab2x64(:,:,511))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(532),h0tab(:,532),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(118),m3h2x32(:,440),heltab2x64(:,:,512))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(533),h0tab(:,533),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(119),m3h2x32(:,441),heltab2x64(:,:,513))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(534),h0tab(:,534),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(120),m3h2x32(:,442),heltab2x64(:,:,514))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(535),h0tab(:,535),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,443),heltab2x64(:,:,515))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(536),h0tab(:,536),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,444),heltab2x64(:,:,516))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(537),h0tab(:,537),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,445),heltab2x64(:,:,517))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(538),h0tab(:,538),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,446),heltab2x64(:,:,518))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(539),h0tab(:,539),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,447),heltab2x64(:,:,519))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(540),h0tab(:,540),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,448),heltab2x64(:,:,520))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(541),h0tab(:,541),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,449),heltab2x64(:,:,521))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(542),h0tab(:,542),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,450),heltab2x64(:,:,522))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(543),h0tab(:,543),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,451),heltab2x64(:,:,523))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(544),h0tab(:,544),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,452),heltab2x64(:,:,524))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(545),h0tab(:,545),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,453),heltab2x64(:,:,525))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(546),h0tab(:,546),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,454),heltab2x64(:,:,526))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(547),h0tab(:,547),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,455),heltab2x64(:,:,527))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(548),h0tab(:,548),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(54),m3h2x32(:,456),heltab2x64(:,:,528))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(549),h0tab(:,549),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,457),heltab2x64(:,:,529))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(550),h0tab(:,550),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(56),m3h2x32(:,458),heltab2x64(:,:,530))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(551),h0tab(:,551),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(121),m3h2x32(:,459),heltab2x64(:,:,531))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(552),h0tab(:,552),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(122),m3h2x32(:,460),heltab2x64(:,:,532))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(553),h0tab(:,553),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(123),m3h2x32(:,461),heltab2x64(:,:,533))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(554),h0tab(:,554),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(124),m3h2x32(:,462),heltab2x64(:,:,534))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(555),h0tab(:,555),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(125),m3h2x32(:,463),heltab2x64(:,:,535))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(556),h0tab(:,556),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(126),m3h2x32(:,464),heltab2x64(:,:,536))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(557),h0tab(:,557),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(127),m3h2x32(:,465),heltab2x64(:,:,537))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(558),h0tab(:,558),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(128),m3h2x32(:,466),heltab2x64(:,:,538))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(559),h0tab(:,559),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(57),m3h2x32(:,467),heltab2x64(:,:,539))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(560),h0tab(:,560),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,468),heltab2x64(:,:,540))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(561),h0tab(:,561),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,469),heltab2x64(:,:,541))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(562),h0tab(:,562),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,470),heltab2x64(:,:,542))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(563),h0tab(:,563),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(61),m3h2x32(:,471),heltab2x64(:,:,543))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(564),h0tab(:,564),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(62),m3h2x32(:,472),heltab2x64(:,:,544))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(565),h0tab(:,565),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(63),m3h2x32(:,473),heltab2x64(:,:,545))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(566),h0tab(:,566),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(64),m3h2x32(:,474),heltab2x64(:,:,546))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(567),h0tab(:,567),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(129),m3h2x32(:,475),heltab2x64(:,:,547))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(568),h0tab(:,568),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(130),m3h2x32(:,476),heltab2x64(:,:,548))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(569),h0tab(:,569),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(131),m3h2x32(:,477),heltab2x64(:,:,549))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(570),h0tab(:,570),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(132),m3h2x32(:,478),heltab2x64(:,:,550))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(571),h0tab(:,571),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(133),m3h2x32(:,479),heltab2x64(:,:,551))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(572),h0tab(:,572),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,13),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(134),m3h2x32(:,480),heltab2x64(:,:,552))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(573),h0tab(:,573),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(135),m3h2x32(:,481),heltab2x64(:,:,553))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(574),h0tab(:,574),[32,12,3,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,16),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(136),m3h2x32(:,482),heltab2x64(:,:,554))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(575),h0tab(:,575),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,483),heltab2x64(:,:,555))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(137),n2h32(209))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(576),h0tab(:,576),[32,3,12,16],[nML,nML,nML,nML],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,484),heltab2x64(:,:,556))
  call Hloop_A_Q(ntryL,G0H32(65),32,nML,G1H32(138),n2h32(210))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(577),h0tab(:,577),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,485),heltab2x64(:,:,557))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(139),n2h32(211))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(578),h0tab(:,578),[32,3,12,16],[nML,nML,nML,nML],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,486),heltab2x64(:,:,558))
  call Hloop_Q_A(ntryL,G0H32(65),32,nML,G1H32(140),n2h32(212))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(579),h0tab(:,579),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,487),heltab2x64(:,:,559))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(141),n2h32(213))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(580),h0tab(:,580),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,488),heltab2x64(:,:,560))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(142),n2h32(214))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(581),h0tab(:,581),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,489),heltab2x64(:,:,561))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(143),n2h32(215))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(582),h0tab(:,582),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,490),heltab2x64(:,:,562))
  call Hloop_Q_A(ntryL,G0H32(65),32,nMT,G1H32(144),n2h32(216))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(583),h0tab(:,583),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,491),heltab2x64(:,:,563))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(145),n2h32(217))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(584),h0tab(:,584),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,492),heltab2x64(:,:,564))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMB,G1H32(146),n2h32(218))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(585),h0tab(:,585),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,493),heltab2x64(:,:,565))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(147),n2h32(219))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(586),h0tab(:,586),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,494),heltab2x64(:,:,566))
  call Hloop_Q_A(ntryL,G0H32(65),32,nMB,G1H32(148),n2h32(220))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(587),h0tab(:,587),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,495),heltab2x64(:,:,567))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(149),n2h32(221))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(588),h0tab(:,588),[32,3,12,16],[nML,nML,nML,nML],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,496),heltab2x64(:,:,568))
  call Hloop_A_Q(ntryL,G0H32(65),32,nML,G1H32(150),n2h32(222))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(589),h0tab(:,589),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,497),heltab2x64(:,:,569))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(151),n2h32(223))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(590),h0tab(:,590),[32,3,12,16],[nML,nML,nML,nML],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,498),heltab2x64(:,:,570))
  call Hloop_Q_A(ntryL,G0H32(65),32,nML,G1H32(152),n2h32(224))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(591),h0tab(:,591),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,499),heltab2x64(:,:,571))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(153),n2h32(225))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(592),h0tab(:,592),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,500),heltab2x64(:,:,572))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(154),n2h32(226))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(593),h0tab(:,593),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,501),heltab2x64(:,:,573))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(155),n2h32(227))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(594),h0tab(:,594),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,502),heltab2x64(:,:,574))
  call Hloop_Q_A(ntryL,G0H32(65),32,nMT,G1H32(156),n2h32(228))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(595),h0tab(:,595),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,503),heltab2x64(:,:,575))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(157),n2h32(229))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(596),h0tab(:,596),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,504),heltab2x64(:,:,576))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMB,G1H32(158),n2h32(230))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(597),h0tab(:,597),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,505),heltab2x64(:,:,577))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(159),n2h32(231))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(598),h0tab(:,598),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,506),heltab2x64(:,:,578))
  call Hloop_Q_A(ntryL,G0H32(65),32,nMB,G1H32(160),n2h32(232))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(599),h0tab(:,599),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,507),heltab2x64(:,:,579))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(161),n2h32(233))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(600),h0tab(:,600),[32,3,12,16],[nML,nML,nML,nML],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,508),heltab2x64(:,:,580))
  call Hloop_A_Q(ntryL,G0H32(65),32,nML,G1H32(162),n2h32(234))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(601),h0tab(:,601),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,509),heltab2x64(:,:,581))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(163),n2h32(235))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(602),h0tab(:,602),[32,3,12,16],[nML,nML,nML,nML],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,510),heltab2x64(:,:,582))
  call Hloop_Q_A(ntryL,G0H32(65),32,nML,G1H32(164),n2h32(236))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(603),h0tab(:,603),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,511),heltab2x64(:,:,583))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(165),n2h32(237))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(604),h0tab(:,604),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,512),heltab2x64(:,:,584))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(166),n2h32(238))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(605),h0tab(:,605),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,513),heltab2x64(:,:,585))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(167),n2h32(239))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(606),h0tab(:,606),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,514),heltab2x64(:,:,586))
  call Hloop_Q_A(ntryL,G0H32(65),32,nMT,G1H32(168),n2h32(240))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(607),h0tab(:,607),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,515),heltab2x64(:,:,587))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(169),n2h32(241))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(608),h0tab(:,608),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,516),heltab2x64(:,:,588))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMB,G1H32(170),n2h32(242))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(609),h0tab(:,609),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,517),heltab2x64(:,:,589))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(171),n2h32(243))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(610),h0tab(:,610),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,518),heltab2x64(:,:,590))
  call Hloop_Q_A(ntryL,G0H32(65),32,nMB,G1H32(172),n2h32(244))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(611),h0tab(:,611),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,519),heltab2x64(:,:,591))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(173),n2h32(245))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(612),h0tab(:,612),[32,3,12,16],[nML,nML,nML,nML],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,520),heltab2x64(:,:,592))
  call Hloop_A_Q(ntryL,G0H32(65),32,nML,G1H32(174),n2h32(246))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(613),h0tab(:,613),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,521),heltab2x64(:,:,593))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(175),n2h32(247))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(614),h0tab(:,614),[32,3,12,16],[nML,nML,nML,nML],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,522),heltab2x64(:,:,594))
  call Hloop_Q_A(ntryL,G0H32(65),32,nML,G1H32(176),n2h32(248))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(615),h0tab(:,615),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,523),heltab2x64(:,:,595))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(177),n2h32(249))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(616),h0tab(:,616),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,524),heltab2x64(:,:,596))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(178),n2h32(250))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(617),h0tab(:,617),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,525),heltab2x64(:,:,597))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(179),n2h32(251))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(618),h0tab(:,618),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,526),heltab2x64(:,:,598))
  call Hloop_Q_A(ntryL,G0H32(65),32,nMT,G1H32(180),n2h32(252))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(619),h0tab(:,619),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,527),heltab2x64(:,:,599))
  call Hloop_A_Q(ntryL,G0H32(65),32,0,G1H32(181),n2h32(253))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(620),h0tab(:,620),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,528),heltab2x64(:,:,600))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMB,G1H32(182),n2h32(254))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(621),h0tab(:,621),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,529),heltab2x64(:,:,601))
  call Hloop_Q_A(ntryL,G0H32(65),32,0,G1H32(183),n2h32(255))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(622),h0tab(:,622),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,530),heltab2x64(:,:,602))
  call Hloop_Q_A(ntryL,G0H32(65),32,nMB,G1H32(184),n2h32(256))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(623),h0tab(:,623),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(185),m3h2x32(:,531),heltab2x64(:,:,603))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(624),h0tab(:,624),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(186),m3h2x32(:,532),heltab2x64(:,:,604))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(625),h0tab(:,625),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(187),m3h2x32(:,533),heltab2x64(:,:,605))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(626),h0tab(:,626),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(188),m3h2x32(:,534),heltab2x64(:,:,606))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(627),h0tab(:,627),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(189),m3h2x32(:,535),heltab2x64(:,:,607))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(628),h0tab(:,628),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(190),m3h2x32(:,536),heltab2x64(:,:,608))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(629),h0tab(:,629),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(191),m3h2x32(:,537),heltab2x64(:,:,609))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(630),h0tab(:,630),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(192),m3h2x32(:,538),heltab2x64(:,:,610))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(631),h0tab(:,631),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(193),m3h2x32(:,539),heltab2x64(:,:,611))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(632),h0tab(:,632),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(194),m3h2x32(:,540),heltab2x64(:,:,612))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(633),h0tab(:,633),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(195),m3h2x32(:,541),heltab2x64(:,:,613))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(634),h0tab(:,634),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(196),m3h2x32(:,542),heltab2x64(:,:,614))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(635),h0tab(:,635),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(197),m3h2x32(:,543),heltab2x64(:,:,615))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(636),h0tab(:,636),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(198),m3h2x32(:,544),heltab2x64(:,:,616))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(637),h0tab(:,637),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(199),m3h2x32(:,545),heltab2x64(:,:,617))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(638),h0tab(:,638),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(200),m3h2x32(:,546),heltab2x64(:,:,618))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(639),h0tab(:,639),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(201),m3h2x32(:,547),heltab2x64(:,:,619))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(640),h0tab(:,640),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(202),m3h2x32(:,548),heltab2x64(:,:,620))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(641),h0tab(:,641),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(203),m3h2x32(:,549),heltab2x64(:,:,621))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(642),h0tab(:,642),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(204),m3h2x32(:,550),heltab2x64(:,:,622))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(643),h0tab(:,643),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(205),m3h2x32(:,551),heltab2x64(:,:,623))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(644),h0tab(:,644),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(206),m3h2x32(:,552),heltab2x64(:,:,624))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(645),h0tab(:,645),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(207),m3h2x32(:,553),heltab2x64(:,:,625))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(646),h0tab(:,646),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(208),m3h2x32(:,554),heltab2x64(:,:,626))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(647),h0tab(:,647),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(209),m3h2x32(:,555),heltab2x64(:,:,627))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(648),h0tab(:,648),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(210),m3h2x32(:,556),heltab2x64(:,:,628))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(649),h0tab(:,649),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(211),m3h2x32(:,557),heltab2x64(:,:,629))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(650),h0tab(:,650),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(212),m3h2x32(:,558),heltab2x64(:,:,630))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(651),h0tab(:,651),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(213),m3h2x32(:,559),heltab2x64(:,:,631))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(652),h0tab(:,652),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(214),m3h2x32(:,560),heltab2x64(:,:,632))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(653),h0tab(:,653),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(215),m3h2x32(:,561),heltab2x64(:,:,633))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(654),h0tab(:,654),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(216),m3h2x32(:,562),heltab2x64(:,:,634))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(655),h0tab(:,655),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(217),m3h2x32(:,563),heltab2x64(:,:,635))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(656),h0tab(:,656),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(218),m3h2x32(:,564),heltab2x64(:,:,636))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(657),h0tab(:,657),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(219),m3h2x32(:,565),heltab2x64(:,:,637))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(658),h0tab(:,658),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(220),m3h2x32(:,566),heltab2x64(:,:,638))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(659),h0tab(:,659),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(221),m3h2x32(:,567),heltab2x64(:,:,639))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(660),h0tab(:,660),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(222),m3h2x32(:,568),heltab2x64(:,:,640))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(661),h0tab(:,661),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(223),m3h2x32(:,569),heltab2x64(:,:,641))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(662),h0tab(:,662),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(224),m3h2x32(:,570),heltab2x64(:,:,642))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(663),h0tab(:,663),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,571),heltab2x64(:,:,643))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(664),h0tab(:,664),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(66),m3h2x32(:,572),heltab2x64(:,:,644))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(665),h0tab(:,665),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(67),m3h2x32(:,573),heltab2x64(:,:,645))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(666),h0tab(:,666),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(68),m3h2x32(:,574),heltab2x64(:,:,646))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(667),h0tab(:,667),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,575),heltab2x64(:,:,647))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(668),h0tab(:,668),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(70),m3h2x32(:,576),heltab2x64(:,:,648))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(669),h0tab(:,669),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(71),m3h2x32(:,577),heltab2x64(:,:,649))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(670),h0tab(:,670),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(72),m3h2x32(:,578),heltab2x64(:,:,650))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(671),h0tab(:,671),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(225),m3h2x32(:,579),heltab2x64(:,:,651))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(672),h0tab(:,672),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(226),m3h2x32(:,580),heltab2x64(:,:,652))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(673),h0tab(:,673),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(227),m3h2x32(:,581),heltab2x64(:,:,653))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(674),h0tab(:,674),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(228),m3h2x32(:,582),heltab2x64(:,:,654))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(675),h0tab(:,675),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(229),m3h2x32(:,583),heltab2x64(:,:,655))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(676),h0tab(:,676),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(230),m3h2x32(:,584),heltab2x64(:,:,656))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(677),h0tab(:,677),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(231),m3h2x32(:,585),heltab2x64(:,:,657))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(678),h0tab(:,678),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(232),m3h2x32(:,586),heltab2x64(:,:,658))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(679),h0tab(:,679),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(73),m3h2x32(:,587),heltab2x64(:,:,659))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(680),h0tab(:,680),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(74),m3h2x32(:,588),heltab2x64(:,:,660))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(681),h0tab(:,681),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(75),m3h2x32(:,589),heltab2x64(:,:,661))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(682),h0tab(:,682),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(76),m3h2x32(:,590),heltab2x64(:,:,662))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(683),h0tab(:,683),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,591),heltab2x64(:,:,663))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(684),h0tab(:,684),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(78),m3h2x32(:,592),heltab2x64(:,:,664))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(685),h0tab(:,685),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(79),m3h2x32(:,593),heltab2x64(:,:,665))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(686),h0tab(:,686),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(80),m3h2x32(:,594),heltab2x64(:,:,666))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(687),h0tab(:,687),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,595),heltab2x64(:,:,667))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(688),h0tab(:,688),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(82),m3h2x32(:,596),heltab2x64(:,:,668))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(689),h0tab(:,689),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(83),m3h2x32(:,597),heltab2x64(:,:,669))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(690),h0tab(:,690),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(84),m3h2x32(:,598),heltab2x64(:,:,670))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(691),h0tab(:,691),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(85),m3h2x32(:,599),heltab2x64(:,:,671))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(692),h0tab(:,692),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(86),m3h2x32(:,600),heltab2x64(:,:,672))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(693),h0tab(:,693),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(87),m3h2x32(:,601),heltab2x64(:,:,673))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(694),h0tab(:,694),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(88),m3h2x32(:,602),heltab2x64(:,:,674))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(695),h0tab(:,695),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(233),m3h2x32(:,603),heltab2x64(:,:,675))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(696),h0tab(:,696),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(234),m3h2x32(:,604),heltab2x64(:,:,676))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(697),h0tab(:,697),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(235),m3h2x32(:,605),heltab2x64(:,:,677))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(698),h0tab(:,698),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(236),m3h2x32(:,606),heltab2x64(:,:,678))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(699),h0tab(:,699),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(237),m3h2x32(:,607),heltab2x64(:,:,679))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(700),h0tab(:,700),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(238),m3h2x32(:,608),heltab2x64(:,:,680))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(701),h0tab(:,701),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(239),m3h2x32(:,609),heltab2x64(:,:,681))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(702),h0tab(:,702),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(240),m3h2x32(:,610),heltab2x64(:,:,682))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(703),h0tab(:,703),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(89),m3h2x32(:,611),heltab2x64(:,:,683))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(704),h0tab(:,704),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(90),m3h2x32(:,612),heltab2x64(:,:,684))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(705),h0tab(:,705),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(91),m3h2x32(:,613),heltab2x64(:,:,685))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(706),h0tab(:,706),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(92),m3h2x32(:,614),heltab2x64(:,:,686))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(707),h0tab(:,707),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(93),m3h2x32(:,615),heltab2x64(:,:,687))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(708),h0tab(:,708),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,616),heltab2x64(:,:,688))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(709),h0tab(:,709),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(95),m3h2x32(:,617),heltab2x64(:,:,689))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(710),h0tab(:,710),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(96),m3h2x32(:,618),heltab2x64(:,:,690))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(711),h0tab(:,711),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(97),m3h2x32(:,619),heltab2x64(:,:,691))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(712),h0tab(:,712),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(98),m3h2x32(:,620),heltab2x64(:,:,692))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(713),h0tab(:,713),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(99),m3h2x32(:,621),heltab2x64(:,:,693))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(714),h0tab(:,714),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(100),m3h2x32(:,622),heltab2x64(:,:,694))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(715),h0tab(:,715),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(101),m3h2x32(:,623),heltab2x64(:,:,695))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(716),h0tab(:,716),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(102),m3h2x32(:,624),heltab2x64(:,:,696))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(717),h0tab(:,717),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,625),heltab2x64(:,:,697))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(718),h0tab(:,718),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(104),m3h2x32(:,626),heltab2x64(:,:,698))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(719),h0tab(:,719),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(241),m3h2x32(:,627),heltab2x64(:,:,699))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(720),h0tab(:,720),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(242),m3h2x32(:,628),heltab2x64(:,:,700))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(721),h0tab(:,721),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(243),m3h2x32(:,629),heltab2x64(:,:,701))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(722),h0tab(:,722),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(244),m3h2x32(:,630),heltab2x64(:,:,702))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(723),h0tab(:,723),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(245),m3h2x32(:,631),heltab2x64(:,:,703))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(724),h0tab(:,724),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(246),m3h2x32(:,632),heltab2x64(:,:,704))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(725),h0tab(:,725),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(247),m3h2x32(:,633),heltab2x64(:,:,705))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(726),h0tab(:,726),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(248),m3h2x32(:,634),heltab2x64(:,:,706))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(727),h0tab(:,727),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(105),m3h2x32(:,635),heltab2x64(:,:,707))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(728),h0tab(:,728),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(106),m3h2x32(:,636),heltab2x64(:,:,708))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(729),h0tab(:,729),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(107),m3h2x32(:,637),heltab2x64(:,:,709))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(730),h0tab(:,730),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(108),m3h2x32(:,638),heltab2x64(:,:,710))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(731),h0tab(:,731),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(109),m3h2x32(:,639),heltab2x64(:,:,711))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(732),h0tab(:,732),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(110),m3h2x32(:,640),heltab2x64(:,:,712))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(733),h0tab(:,733),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(111),m3h2x32(:,641),heltab2x64(:,:,713))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(734),h0tab(:,734),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(112),m3h2x32(:,642),heltab2x64(:,:,714))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(735),h0tab(:,735),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,643),heltab2x64(:,:,715))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(736),h0tab(:,736),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(114),m3h2x32(:,644),heltab2x64(:,:,716))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(737),h0tab(:,737),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,645),heltab2x64(:,:,717))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(738),h0tab(:,738),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(116),m3h2x32(:,646),heltab2x64(:,:,718))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(739),h0tab(:,739),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(117),m3h2x32(:,647),heltab2x64(:,:,719))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(740),h0tab(:,740),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(118),m3h2x32(:,648),heltab2x64(:,:,720))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(741),h0tab(:,741),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(119),m3h2x32(:,649),heltab2x64(:,:,721))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(742),h0tab(:,742),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(120),m3h2x32(:,650),heltab2x64(:,:,722))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(743),h0tab(:,743),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(249),m3h2x32(:,651),heltab2x64(:,:,723))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(744),h0tab(:,744),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(250),m3h2x32(:,652),heltab2x64(:,:,724))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(745),h0tab(:,745),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(251),m3h2x32(:,653),heltab2x64(:,:,725))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(746),h0tab(:,746),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(252),m3h2x32(:,654),heltab2x64(:,:,726))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(747),h0tab(:,747),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(253),m3h2x32(:,655),heltab2x64(:,:,727))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(748),h0tab(:,748),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(254),m3h2x32(:,656),heltab2x64(:,:,728))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(749),h0tab(:,749),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(255),m3h2x32(:,657),heltab2x64(:,:,729))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(750),h0tab(:,750),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(256),m3h2x32(:,658),heltab2x64(:,:,730))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(751),h0tab(:,751),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,659),heltab2x64(:,:,731))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(752),h0tab(:,752),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(122),m3h2x32(:,660),heltab2x64(:,:,732))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(753),h0tab(:,753),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(123),m3h2x32(:,661),heltab2x64(:,:,733))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(754),h0tab(:,754),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(124),m3h2x32(:,662),heltab2x64(:,:,734))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(755),h0tab(:,755),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(125),m3h2x32(:,663),heltab2x64(:,:,735))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(756),h0tab(:,756),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(126),m3h2x32(:,664),heltab2x64(:,:,736))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(757),h0tab(:,757),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(127),m3h2x32(:,665),heltab2x64(:,:,737))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(758),h0tab(:,758),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(128),m3h2x32(:,666),heltab2x64(:,:,738))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(759),h0tab(:,759),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(257),m3h2x32(:,667),heltab2x64(:,:,739))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(760),h0tab(:,760),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(258),m3h2x32(:,668),heltab2x64(:,:,740))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(761),h0tab(:,761),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(259),m3h2x32(:,669),heltab2x64(:,:,741))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(762),h0tab(:,762),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(260),m3h2x32(:,670),heltab2x64(:,:,742))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(763),h0tab(:,763),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(261),m3h2x32(:,671),heltab2x64(:,:,743))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(764),h0tab(:,764),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(262),m3h2x32(:,672),heltab2x64(:,:,744))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(765),h0tab(:,765),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(263),m3h2x32(:,673),heltab2x64(:,:,745))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(766),h0tab(:,766),[32,3,12,16],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(264),m3h2x32(:,674),heltab2x64(:,:,746))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(767),h0tab(:,767),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,675),heltab2x64(:,:,747))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(265),n2h32(257))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(768),h0tab(:,768),[32,3,16,12],[nML,nML,nML,nML],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,676),heltab2x64(:,:,748))
  call Hloop_Q_A(ntryL,G0H32(129),32,nML,G1H32(266),n2h32(258))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(769),h0tab(:,769),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,677),heltab2x64(:,:,749))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(267),n2h32(259))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(770),h0tab(:,770),[32,3,16,12],[nML,nML,nML,nML],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,678),heltab2x64(:,:,750))
  call Hloop_A_Q(ntryL,G0H32(129),32,nML,G1H32(268),n2h32(260))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(771),h0tab(:,771),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,679),heltab2x64(:,:,751))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(269),n2h32(261))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(772),h0tab(:,772),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,680),heltab2x64(:,:,752))
  call Hloop_Q_A(ntryL,G0H32(129),32,nMT,G1H32(270),n2h32(262))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(773),h0tab(:,773),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,681),heltab2x64(:,:,753))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(271),n2h32(263))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(774),h0tab(:,774),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,682),heltab2x64(:,:,754))
  call Hloop_A_Q(ntryL,G0H32(129),32,nMT,G1H32(272),n2h32(264))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(775),h0tab(:,775),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,683),heltab2x64(:,:,755))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(273),n2h32(265))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(776),h0tab(:,776),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,684),heltab2x64(:,:,756))
  call Hloop_Q_A(ntryL,G0H32(129),32,nMB,G1H32(274),n2h32(266))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(777),h0tab(:,777),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,685),heltab2x64(:,:,757))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(275),n2h32(267))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(778),h0tab(:,778),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,686),heltab2x64(:,:,758))
  call Hloop_A_Q(ntryL,G0H32(129),32,nMB,G1H32(276),n2h32(268))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(779),h0tab(:,779),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,687),heltab2x64(:,:,759))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(277),n2h32(269))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(780),h0tab(:,780),[32,3,16,12],[nML,nML,nML,nML],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,688),heltab2x64(:,:,760))
  call Hloop_Q_A(ntryL,G0H32(129),32,nML,G1H32(278),n2h32(270))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(781),h0tab(:,781),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,689),heltab2x64(:,:,761))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(279),n2h32(271))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(782),h0tab(:,782),[32,3,16,12],[nML,nML,nML,nML],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,690),heltab2x64(:,:,762))
  call Hloop_A_Q(ntryL,G0H32(129),32,nML,G1H32(280),n2h32(272))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(783),h0tab(:,783),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,691),heltab2x64(:,:,763))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(281),n2h32(273))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(784),h0tab(:,784),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,692),heltab2x64(:,:,764))
  call Hloop_Q_A(ntryL,G0H32(129),32,nMT,G1H32(282),n2h32(274))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(785),h0tab(:,785),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,693),heltab2x64(:,:,765))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(283),n2h32(275))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(786),h0tab(:,786),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,694),heltab2x64(:,:,766))
  call Hloop_A_Q(ntryL,G0H32(129),32,nMT,G1H32(284),n2h32(276))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(787),h0tab(:,787),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,695),heltab2x64(:,:,767))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(285),n2h32(277))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(788),h0tab(:,788),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,696),heltab2x64(:,:,768))
  call Hloop_Q_A(ntryL,G0H32(129),32,nMB,G1H32(286),n2h32(278))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(789),h0tab(:,789),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,697),heltab2x64(:,:,769))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(287),n2h32(279))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(790),h0tab(:,790),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,698),heltab2x64(:,:,770))
  call Hloop_A_Q(ntryL,G0H32(129),32,nMB,G1H32(288),n2h32(280))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(791),h0tab(:,791),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,699),heltab2x64(:,:,771))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(289),n2h32(281))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(792),h0tab(:,792),[32,3,16,12],[nML,nML,nML,nML],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,700),heltab2x64(:,:,772))
  call Hloop_Q_A(ntryL,G0H32(129),32,nML,G1H32(290),n2h32(282))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(793),h0tab(:,793),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,701),heltab2x64(:,:,773))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(291),n2h32(283))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(794),h0tab(:,794),[32,3,16,12],[nML,nML,nML,nML],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,702),heltab2x64(:,:,774))
  call Hloop_A_Q(ntryL,G0H32(129),32,nML,G1H32(292),n2h32(284))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(795),h0tab(:,795),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,703),heltab2x64(:,:,775))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(293),n2h32(285))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(796),h0tab(:,796),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,704),heltab2x64(:,:,776))
  call Hloop_Q_A(ntryL,G0H32(129),32,nMT,G1H32(294),n2h32(286))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(797),h0tab(:,797),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,705),heltab2x64(:,:,777))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(295),n2h32(287))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(798),h0tab(:,798),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,706),heltab2x64(:,:,778))
  call Hloop_A_Q(ntryL,G0H32(129),32,nMT,G1H32(296),n2h32(288))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(799),h0tab(:,799),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,707),heltab2x64(:,:,779))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(297),n2h32(289))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(800),h0tab(:,800),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,708),heltab2x64(:,:,780))
  call Hloop_Q_A(ntryL,G0H32(129),32,nMB,G1H32(298),n2h32(290))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(801),h0tab(:,801),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,709),heltab2x64(:,:,781))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(299),n2h32(291))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(802),h0tab(:,802),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,710),heltab2x64(:,:,782))
  call Hloop_A_Q(ntryL,G0H32(129),32,nMB,G1H32(300),n2h32(292))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(803),h0tab(:,803),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,711),heltab2x64(:,:,783))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(301),n2h32(293))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(804),h0tab(:,804),[32,3,16,12],[nML,nML,nML,nML],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,712),heltab2x64(:,:,784))
  call Hloop_Q_A(ntryL,G0H32(129),32,nML,G1H32(302),n2h32(294))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(805),h0tab(:,805),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,713),heltab2x64(:,:,785))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(303),n2h32(295))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(806),h0tab(:,806),[32,3,16,12],[nML,nML,nML,nML],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,714),heltab2x64(:,:,786))
  call Hloop_A_Q(ntryL,G0H32(129),32,nML,G1H32(304),n2h32(296))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(807),h0tab(:,807),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,715),heltab2x64(:,:,787))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(305),n2h32(297))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(808),h0tab(:,808),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,716),heltab2x64(:,:,788))
  call Hloop_Q_A(ntryL,G0H32(129),32,nMT,G1H32(306),n2h32(298))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(809),h0tab(:,809),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,717),heltab2x64(:,:,789))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(307),n2h32(299))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(810),h0tab(:,810),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,718),heltab2x64(:,:,790))
  call Hloop_A_Q(ntryL,G0H32(129),32,nMT,G1H32(308),n2h32(300))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(811),h0tab(:,811),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,719),heltab2x64(:,:,791))
  call Hloop_Q_A(ntryL,G0H32(129),32,0,G1H32(309),n2h32(301))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(812),h0tab(:,812),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,720),heltab2x64(:,:,792))
  call Hloop_Q_A(ntryL,G0H32(129),32,nMB,G1H32(310),n2h32(302))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(813),h0tab(:,813),[32,3,16,12],[0,0,0,0],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,721),heltab2x64(:,:,793))
  call Hloop_A_Q(ntryL,G0H32(129),32,0,G1H32(311),n2h32(303))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(814),h0tab(:,814),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,722),heltab2x64(:,:,794))
  call Hloop_A_Q(ntryL,G0H32(129),32,nMB,G1H32(312),n2h32(304))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(815),h0tab(:,815),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(313),m3h2x32(:,723),heltab2x64(:,:,795))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(816),h0tab(:,816),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(314),m3h2x32(:,724),heltab2x64(:,:,796))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(817),h0tab(:,817),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(315),m3h2x32(:,725),heltab2x64(:,:,797))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(818),h0tab(:,818),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(316),m3h2x32(:,726),heltab2x64(:,:,798))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(819),h0tab(:,819),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(317),m3h2x32(:,727),heltab2x64(:,:,799))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(820),h0tab(:,820),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(318),m3h2x32(:,728),heltab2x64(:,:,800))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(821),h0tab(:,821),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(319),m3h2x32(:,729),heltab2x64(:,:,801))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(822),h0tab(:,822),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(320),m3h2x32(:,730),heltab2x64(:,:,802))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(823),h0tab(:,823),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(321),m3h2x32(:,731),heltab2x64(:,:,803))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(824),h0tab(:,824),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(322),m3h2x32(:,732),heltab2x64(:,:,804))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(825),h0tab(:,825),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(323),m3h2x32(:,733),heltab2x64(:,:,805))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(826),h0tab(:,826),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(324),m3h2x32(:,734),heltab2x64(:,:,806))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(827),h0tab(:,827),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(325),m3h2x32(:,735),heltab2x64(:,:,807))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(828),h0tab(:,828),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(326),m3h2x32(:,736),heltab2x64(:,:,808))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(829),h0tab(:,829),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(327),m3h2x32(:,737),heltab2x64(:,:,809))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(830),h0tab(:,830),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(328),m3h2x32(:,738),heltab2x64(:,:,810))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(831),h0tab(:,831),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(329),m3h2x32(:,739),heltab2x64(:,:,811))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(832),h0tab(:,832),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(330),m3h2x32(:,740),heltab2x64(:,:,812))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(833),h0tab(:,833),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(331),m3h2x32(:,741),heltab2x64(:,:,813))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(834),h0tab(:,834),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(332),m3h2x32(:,742),heltab2x64(:,:,814))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(835),h0tab(:,835),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(333),m3h2x32(:,743),heltab2x64(:,:,815))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(836),h0tab(:,836),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(334),m3h2x32(:,744),heltab2x64(:,:,816))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(837),h0tab(:,837),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(335),m3h2x32(:,745),heltab2x64(:,:,817))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(838),h0tab(:,838),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(336),m3h2x32(:,746),heltab2x64(:,:,818))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(839),h0tab(:,839),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(337),m3h2x32(:,747),heltab2x64(:,:,819))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(840),h0tab(:,840),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(338),m3h2x32(:,748),heltab2x64(:,:,820))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(841),h0tab(:,841),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(339),m3h2x32(:,749),heltab2x64(:,:,821))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(842),h0tab(:,842),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(340),m3h2x32(:,750),heltab2x64(:,:,822))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(843),h0tab(:,843),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(341),m3h2x32(:,751),heltab2x64(:,:,823))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(844),h0tab(:,844),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(342),m3h2x32(:,752),heltab2x64(:,:,824))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(845),h0tab(:,845),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(343),m3h2x32(:,753),heltab2x64(:,:,825))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(846),h0tab(:,846),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(344),m3h2x32(:,754),heltab2x64(:,:,826))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(847),h0tab(:,847),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,755),heltab2x64(:,:,827))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(848),h0tab(:,848),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(130),m3h2x32(:,756),heltab2x64(:,:,828))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(849),h0tab(:,849),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(131),m3h2x32(:,757),heltab2x64(:,:,829))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(850),h0tab(:,850),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(132),m3h2x32(:,758),heltab2x64(:,:,830))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(851),h0tab(:,851),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(133),m3h2x32(:,759),heltab2x64(:,:,831))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(852),h0tab(:,852),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(134),m3h2x32(:,760),heltab2x64(:,:,832))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(853),h0tab(:,853),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(135),m3h2x32(:,761),heltab2x64(:,:,833))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(854),h0tab(:,854),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(136),m3h2x32(:,762),heltab2x64(:,:,834))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(855),h0tab(:,855),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(137),m3h2x32(:,763),heltab2x64(:,:,835))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(856),h0tab(:,856),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(138),m3h2x32(:,764),heltab2x64(:,:,836))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(857),h0tab(:,857),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(139),m3h2x32(:,765),heltab2x64(:,:,837))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(858),h0tab(:,858),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(140),m3h2x32(:,766),heltab2x64(:,:,838))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(859),h0tab(:,859),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(141),m3h2x32(:,767),heltab2x64(:,:,839))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(860),h0tab(:,860),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(142),m3h2x32(:,768),heltab2x64(:,:,840))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(861),h0tab(:,861),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(143),m3h2x32(:,769),heltab2x64(:,:,841))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(862),h0tab(:,862),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(144),m3h2x32(:,770),heltab2x64(:,:,842))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(863),h0tab(:,863),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(345),m3h2x32(:,771),heltab2x64(:,:,843))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(864),h0tab(:,864),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(346),m3h2x32(:,772),heltab2x64(:,:,844))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(865),h0tab(:,865),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(347),m3h2x32(:,773),heltab2x64(:,:,845))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(866),h0tab(:,866),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(348),m3h2x32(:,774),heltab2x64(:,:,846))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(867),h0tab(:,867),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(349),m3h2x32(:,775),heltab2x64(:,:,847))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(868),h0tab(:,868),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(350),m3h2x32(:,776),heltab2x64(:,:,848))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(869),h0tab(:,869),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(351),m3h2x32(:,777),heltab2x64(:,:,849))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(870),h0tab(:,870),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(352),m3h2x32(:,778),heltab2x64(:,:,850))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(871),h0tab(:,871),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(353),m3h2x32(:,779),heltab2x64(:,:,851))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(872),h0tab(:,872),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(354),m3h2x32(:,780),heltab2x64(:,:,852))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(873),h0tab(:,873),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(355),m3h2x32(:,781),heltab2x64(:,:,853))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(874),h0tab(:,874),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(356),m3h2x32(:,782),heltab2x64(:,:,854))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(875),h0tab(:,875),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(357),m3h2x32(:,783),heltab2x64(:,:,855))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(876),h0tab(:,876),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(358),m3h2x32(:,784),heltab2x64(:,:,856))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(877),h0tab(:,877),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(359),m3h2x32(:,785),heltab2x64(:,:,857))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(878),h0tab(:,878),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(360),m3h2x32(:,786),heltab2x64(:,:,858))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(879),h0tab(:,879),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(361),m3h2x32(:,787),heltab2x64(:,:,859))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(880),h0tab(:,880),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(362),m3h2x32(:,788),heltab2x64(:,:,860))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(881),h0tab(:,881),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(363),m3h2x32(:,789),heltab2x64(:,:,861))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(882),h0tab(:,882),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(364),m3h2x32(:,790),heltab2x64(:,:,862))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(883),h0tab(:,883),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(365),m3h2x32(:,791),heltab2x64(:,:,863))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(884),h0tab(:,884),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(366),m3h2x32(:,792),heltab2x64(:,:,864))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(885),h0tab(:,885),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(367),m3h2x32(:,793),heltab2x64(:,:,865))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(886),h0tab(:,886),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(368),m3h2x32(:,794),heltab2x64(:,:,866))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(887),h0tab(:,887),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(145),m3h2x32(:,795),heltab2x64(:,:,867))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(888),h0tab(:,888),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(146),m3h2x32(:,796),heltab2x64(:,:,868))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(889),h0tab(:,889),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(147),m3h2x32(:,797),heltab2x64(:,:,869))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(890),h0tab(:,890),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(148),m3h2x32(:,798),heltab2x64(:,:,870))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(891),h0tab(:,891),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(149),m3h2x32(:,799),heltab2x64(:,:,871))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(892),h0tab(:,892),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(150),m3h2x32(:,800),heltab2x64(:,:,872))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(893),h0tab(:,893),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(151),m3h2x32(:,801),heltab2x64(:,:,873))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(894),h0tab(:,894),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(152),m3h2x32(:,802),heltab2x64(:,:,874))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(895),h0tab(:,895),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(153),m3h2x32(:,803),heltab2x64(:,:,875))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(896),h0tab(:,896),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(154),m3h2x32(:,804),heltab2x64(:,:,876))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(897),h0tab(:,897),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(155),m3h2x32(:,805),heltab2x64(:,:,877))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(898),h0tab(:,898),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(156),m3h2x32(:,806),heltab2x64(:,:,878))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(899),h0tab(:,899),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(157),m3h2x32(:,807),heltab2x64(:,:,879))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(900),h0tab(:,900),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(158),m3h2x32(:,808),heltab2x64(:,:,880))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(901),h0tab(:,901),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(159),m3h2x32(:,809),heltab2x64(:,:,881))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(902),h0tab(:,902),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(160),m3h2x32(:,810),heltab2x64(:,:,882))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(903),h0tab(:,903),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(161),m3h2x32(:,811),heltab2x64(:,:,883))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(904),h0tab(:,904),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(162),m3h2x32(:,812),heltab2x64(:,:,884))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(905),h0tab(:,905),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(163),m3h2x32(:,813),heltab2x64(:,:,885))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(906),h0tab(:,906),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(164),m3h2x32(:,814),heltab2x64(:,:,886))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(907),h0tab(:,907),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(165),m3h2x32(:,815),heltab2x64(:,:,887))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(908),h0tab(:,908),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(166),m3h2x32(:,816),heltab2x64(:,:,888))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(909),h0tab(:,909),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(167),m3h2x32(:,817),heltab2x64(:,:,889))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(910),h0tab(:,910),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(168),m3h2x32(:,818),heltab2x64(:,:,890))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(911),h0tab(:,911),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(169),m3h2x32(:,819),heltab2x64(:,:,891))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(912),h0tab(:,912),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(170),m3h2x32(:,820),heltab2x64(:,:,892))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(913),h0tab(:,913),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(171),m3h2x32(:,821),heltab2x64(:,:,893))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(914),h0tab(:,914),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(172),m3h2x32(:,822),heltab2x64(:,:,894))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(915),h0tab(:,915),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(173),m3h2x32(:,823),heltab2x64(:,:,895))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(916),h0tab(:,916),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(174),m3h2x32(:,824),heltab2x64(:,:,896))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(917),h0tab(:,917),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(175),m3h2x32(:,825),heltab2x64(:,:,897))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(918),h0tab(:,918),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(176),m3h2x32(:,826),heltab2x64(:,:,898))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(919),h0tab(:,919),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(369),m3h2x32(:,827),heltab2x64(:,:,899))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(920),h0tab(:,920),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(370),m3h2x32(:,828),heltab2x64(:,:,900))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(921),h0tab(:,921),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(371),m3h2x32(:,829),heltab2x64(:,:,901))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(922),h0tab(:,922),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(372),m3h2x32(:,830),heltab2x64(:,:,902))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(923),h0tab(:,923),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(373),m3h2x32(:,831),heltab2x64(:,:,903))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(924),h0tab(:,924),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(374),m3h2x32(:,832),heltab2x64(:,:,904))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(925),h0tab(:,925),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(375),m3h2x32(:,833),heltab2x64(:,:,905))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(926),h0tab(:,926),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(376),m3h2x32(:,834),heltab2x64(:,:,906))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(927),h0tab(:,927),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(377),m3h2x32(:,835),heltab2x64(:,:,907))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(928),h0tab(:,928),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(378),m3h2x32(:,836),heltab2x64(:,:,908))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(929),h0tab(:,929),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(379),m3h2x32(:,837),heltab2x64(:,:,909))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(930),h0tab(:,930),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(380),m3h2x32(:,838),heltab2x64(:,:,910))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(931),h0tab(:,931),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(381),m3h2x32(:,839),heltab2x64(:,:,911))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(932),h0tab(:,932),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(382),m3h2x32(:,840),heltab2x64(:,:,912))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(933),h0tab(:,933),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(383),m3h2x32(:,841),heltab2x64(:,:,913))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(934),h0tab(:,934),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(384),m3h2x32(:,842),heltab2x64(:,:,914))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(935),h0tab(:,935),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(385),m3h2x32(:,843),heltab2x64(:,:,915))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(936),h0tab(:,936),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(386),m3h2x32(:,844),heltab2x64(:,:,916))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(937),h0tab(:,937),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(387),m3h2x32(:,845),heltab2x64(:,:,917))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(938),h0tab(:,938),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(388),m3h2x32(:,846),heltab2x64(:,:,918))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(939),h0tab(:,939),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(389),m3h2x32(:,847),heltab2x64(:,:,919))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(940),h0tab(:,940),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(390),m3h2x32(:,848),heltab2x64(:,:,920))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(941),h0tab(:,941),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(391),m3h2x32(:,849),heltab2x64(:,:,921))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(942),h0tab(:,942),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(392),m3h2x32(:,850),heltab2x64(:,:,922))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(943),h0tab(:,943),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(177),m3h2x32(:,851),heltab2x64(:,:,923))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(944),h0tab(:,944),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(178),m3h2x32(:,852),heltab2x64(:,:,924))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(945),h0tab(:,945),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(179),m3h2x32(:,853),heltab2x64(:,:,925))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(946),h0tab(:,946),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(180),m3h2x32(:,854),heltab2x64(:,:,926))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(947),h0tab(:,947),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(181),m3h2x32(:,855),heltab2x64(:,:,927))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(948),h0tab(:,948),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(182),m3h2x32(:,856),heltab2x64(:,:,928))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(949),h0tab(:,949),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(183),m3h2x32(:,857),heltab2x64(:,:,929))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(950),h0tab(:,950),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(184),m3h2x32(:,858),heltab2x64(:,:,930))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(951),h0tab(:,951),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(185),m3h2x32(:,859),heltab2x64(:,:,931))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(952),h0tab(:,952),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(186),m3h2x32(:,860),heltab2x64(:,:,932))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(953),h0tab(:,953),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(187),m3h2x32(:,861),heltab2x64(:,:,933))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(954),h0tab(:,954),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,1),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(188),m3h2x32(:,862),heltab2x64(:,:,934))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(955),h0tab(:,955),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(189),m3h2x32(:,863),heltab2x64(:,:,935))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(956),h0tab(:,956),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(190),m3h2x32(:,864),heltab2x64(:,:,936))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(957),h0tab(:,957),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(191),m3h2x32(:,865),heltab2x64(:,:,937))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(958),h0tab(:,958),[32,3,16,12],[nMW,nMW,nMW,nMW],4,2,wf4(:,6),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(192),m3h2x32(:,866),heltab2x64(:,:,938))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(959),h0tab(:,959),[32,8,3,20],[nMW,0,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(393),m3h2x32(:,867),heltab2x64(:,:,939))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(960),h0tab(:,960),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(193),m3h2x32(:,868),heltab2x64(:,:,940))
  call Hloop_A_Q(ntryL,G0H32(193),32,0,G1H32(394),n2h32(305))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(961),h0tab(:,961),[32,3,20,8],[0,0,nMZ,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(193),m3h2x32(:,869),heltab2x64(:,:,941))
  call Hloop_A_Q(ntryL,G0H32(193),32,0,G1H32(395),n2h32(306))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(962),h0tab(:,962),[32,3,20,8],[0,0,0,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(193),m3h2x32(:,870),heltab2x64(:,:,942))
  call Hloop_A_Q(ntryL,G0H32(193),32,0,G1H32(396),n2h32(307))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(963),h0tab(:,963),[32,3,20,8],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(193),m3h2x32(:,871),heltab2x64(:,:,943))
  call Hloop_A_Q(ntryL,G0H32(193),32,0,G1H32(397),n2h32(308))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(964),h0tab(:,964),[32,3,20,8],[nMW,nMW,0,nMW],4,2,wf4(:,1),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(193),m3h2x32(:,872),heltab2x64(:,:,944))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(965),h0tab(:,965),[32,3,20,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(194),m3h2x32(:,873),heltab2x64(:,:,945))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(966),h0tab(:,966),[32,3,20,8],[nMW,nMW,0,nMW],4,2,wf4(:,1),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(398),m3h2x32(:,874),heltab2x64(:,:,946))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(967),h0tab(:,967),[32,3,20,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(399),m3h2x32(:,875),heltab2x64(:,:,947))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(968),h0tab(:,968),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(195),m3h2x32(:,876),heltab2x64(:,:,948))
  call Hloop_Q_A(ntryL,G0H32(195),32,0,G1H32(400),n2h32(309))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(969),h0tab(:,969),[32,3,8,20],[0,0,nMZ,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(195),m3h2x32(:,877),heltab2x64(:,:,949))
  call Hloop_Q_A(ntryL,G0H32(195),32,0,G1H32(401),n2h32(310))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(970),h0tab(:,970),[32,3,8,20],[0,0,0,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(195),m3h2x32(:,878),heltab2x64(:,:,950))
  call Hloop_Q_A(ntryL,G0H32(195),32,0,G1H32(402),n2h32(311))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(971),h0tab(:,971),[32,3,8,20],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(195),m3h2x32(:,879),heltab2x64(:,:,951))
  call Hloop_Q_A(ntryL,G0H32(195),32,0,G1H32(403),n2h32(312))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(972),h0tab(:,972),[32,3,8,20],[nMW,nMW,0,nMW],4,2,wf4(:,1),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(195),m3h2x32(:,880),heltab2x64(:,:,952))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(973),h0tab(:,973),[32,3,8,20],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(196),m3h2x32(:,881),heltab2x64(:,:,953))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(974),h0tab(:,974),[32,3,8,20],[nMW,nMW,0,nMW],4,2,wf4(:,1),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(404),m3h2x32(:,882),heltab2x64(:,:,954))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(975),h0tab(:,975),[32,3,8,20],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(405),m3h2x32(:,883),heltab2x64(:,:,955))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(976),h0tab(:,976),[32,4,3,24],[nMW,0,0,nMW],4,2,wf4(:,6),wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(406),m3h2x32(:,884),heltab2x64(:,:,956))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(977),h0tab(:,977),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(197),m3h2x32(:,885),heltab2x64(:,:,957))
  call Hloop_Q_A(ntryL,G0H32(197),32,0,G1H32(407),n2h32(313))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(978),h0tab(:,978),[32,3,24,4],[0,0,nMZ,0],4,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(197),m3h2x32(:,886),heltab2x64(:,:,958))
  call Hloop_Q_A(ntryL,G0H32(197),32,0,G1H32(408),n2h32(314))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(979),h0tab(:,979),[32,3,24,4],[0,0,0,0],4,2,wf4(:,6),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(197),m3h2x32(:,887),heltab2x64(:,:,959))
  call Hloop_Q_A(ntryL,G0H32(197),32,0,G1H32(409),n2h32(315))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(980),h0tab(:,980),[32,3,24,4],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(197),m3h2x32(:,888),heltab2x64(:,:,960))
  call Hloop_Q_A(ntryL,G0H32(197),32,0,G1H32(410),n2h32(316))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(981),h0tab(:,981),[32,3,24,4],[nMW,nMW,0,nMW],4,2,wf4(:,1),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(197),m3h2x32(:,889),heltab2x64(:,:,961))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(982),h0tab(:,982),[32,3,24,4],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(198),m3h2x32(:,890),heltab2x64(:,:,962))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(983),h0tab(:,983),[32,3,24,4],[nMW,nMW,0,nMW],4,2,wf4(:,1),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(411),m3h2x32(:,891),heltab2x64(:,:,963))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(984),h0tab(:,984),[32,3,24,4],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(412),m3h2x32(:,892),heltab2x64(:,:,964))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(985),h0tab(:,985),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,893),heltab2x64(:,:,965))
  call Hloop_A_Q(ntryL,G0H32(199),32,0,G1H32(413),n2h32(317))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(986),h0tab(:,986),[32,3,4,24],[0,0,nMZ,0],4,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,894),heltab2x64(:,:,966))
  call Hloop_A_Q(ntryL,G0H32(199),32,0,G1H32(414),n2h32(318))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(987),h0tab(:,987),[32,3,4,24],[0,0,0,0],4,2,wf4(:,6),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,895),heltab2x64(:,:,967))
  call Hloop_A_Q(ntryL,G0H32(199),32,0,G1H32(415),n2h32(319))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(988),h0tab(:,988),[32,3,4,24],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,896),heltab2x64(:,:,968))
  call Hloop_A_Q(ntryL,G0H32(199),32,0,G1H32(416),n2h32(320))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(989),h0tab(:,989),[32,3,4,24],[nMW,nMW,0,nMW],4,2,wf4(:,1),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,897),heltab2x64(:,:,969))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(990),h0tab(:,990),[32,3,4,24],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(200),m3h2x32(:,898),heltab2x64(:,:,970))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(991),h0tab(:,991),[32,3,4,24],[nMW,nMW,0,nMW],4,2,wf4(:,1),wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(417),m3h2x32(:,899),heltab2x64(:,:,971))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(992),h0tab(:,992),[32,3,4,24],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(418),m3h2x32(:,900),heltab2x64(:,:,972))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(993),h0tab(:,993),[36,3,8,16],[0,0,nMW,nMW],4,2,wf4(:,9),wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,9),G0H16(11),m3h4x16(:,73),heltab2x64(:,:,973))
  call Hloop_Q_A(ntryL,G0H16(11),36,0,G1H16(25),n2h16(101))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(994),h0tab(:,994),[36,3,16,8],[0,0,0,0],4,2,wf4(:,9),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,9),G0H16(12),m3h4x16(:,74),heltab2x64(:,:,974))
  call Hloop_Q_A(ntryL,G0H16(12),36,0,G1H16(26),n2h16(102))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(995),h0tab(:,995),[36,3,16,8],[0,0,0,nMZ],4,2,wf4(:,9),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf4(:,9),G0H16(13),ngZl,m3h4x16(:,75),heltab2x64(:,:,975))
  call Hloop_Q_A(ntryL,G0H16(13),36,0,G1H16(27),n2h16(103))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(996),h0tab(:,996),[36,3,16,8],[0,0,0,0],4,2,wf4(:,9),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,9),G0H16(14),m3h4x16(:,76),heltab2x64(:,:,976))
  call Hloop_Q_A(ntryL,G0H16(14),36,0,G1H16(28),n2h16(104))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(997),h0tab(:,997),[36,3,16,8],[0,0,0,nMZ],4,2,wf4(:,9),wf4(:,6))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf4(:,9),G0H16(15),ngZl,m3h4x16(:,77),heltab2x64(:,:,977))
  call Hloop_Q_A(ntryL,G0H16(15),36,0,G1H16(29),n2h16(105))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(998),h0tab(:,998),[36,3,16,8],[nMW,nMW,nMW,0],4,2,wf4(:,9),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,9),G0H16(16),m3h4x16(:,78),heltab2x64(:,:,978))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(999),h0tab(:,999),[36,3,16,8],[nMW,nMW,nMW,0],4,2,wf4(:,9),wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,9),G0H16(17),m3h4x16(:,79),heltab2x64(:,:,979))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1000),h0tab(:,1000),[36,3,16,8],[nMW,nMW,nMW,0],4,2,wf4(:,9),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,9),G0H16(18),m3h4x16(:,80),heltab2x64(:,:,980))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1001),h0tab(:,1001),[36,3,16,8],[nMW,nMW,nMW,0],4,2,wf4(:,9),wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,9),G0H16(19),m3h4x16(:,81),heltab2x64(:,:,981))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1002),h0tab(:,1002),[36,8,3,16],[0,0,0,0],4,2,wf4(:,9),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,9),G0H16(20),m3h4x16(:,82),heltab2x64(:,:,982))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1003),h0tab(:,1003),[36,8,3,16],[nMZ,0,0,0],4,2,wf4(:,9),wf4(:,1))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,9),G0H16(21),ngZl,m3h4x16(:,83),heltab2x64(:,:,983))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1004),h0tab(:,1004),[36,8,3,16],[0,0,0,0],4,2,wf4(:,9),wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,9),G0H16(22),m3h4x16(:,84),heltab2x64(:,:,984))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1005),h0tab(:,1005),[36,8,3,16],[nMZ,0,0,0],4,2,wf4(:,9),wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,9),G0H16(23),ngZl,m3h4x16(:,85),heltab2x64(:,:,985))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1006),h0tab(:,1006),[36,8,3,16],[0,nMW,nMW,nMW],4,2,wf4(:,9),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,9),G0H16(24),m3h4x16(:,86),heltab2x64(:,:,986))
  call Hloop_Q_A(ntryL,G0H16(24),36,0,G1H16(30),n2h16(106))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1007),h0tab(:,1007),[36,8,3,16],[0,nMW,nMW,nMW],4,2,wf4(:,9),wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,9),G0H16(25),m3h4x16(:,87),heltab2x64(:,:,987))
  call Hloop_Q_A(ntryL,G0H16(25),36,0,G1H16(35),n2h16(107))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1008),h0tab(:,1008),[36,8,3,16],[0,nMW,nMW,nMW],4,2,wf4(:,9),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,9),G0H16(26),m3h4x16(:,88),heltab2x64(:,:,988))
  call Hloop_Q_A(ntryL,G0H16(26),36,0,G1H16(36),n2h16(108))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1009),h0tab(:,1009),[36,8,3,16],[0,nMW,nMW,nMW],4,2,wf4(:,9),wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,9),G0H16(27),m3h4x16(:,89),heltab2x64(:,:,989))
  call Hloop_Q_A(ntryL,G0H16(27),36,0,G1H16(37),n2h16(109))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1010),h0tab(:,1010),[40,3,4,16],[0,0,nMW,nMW],4,2,wf4(:,5),wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(28),m3h4x16(:,90),heltab2x64(:,:,990))
  call Hloop_A_Q(ntryL,G0H16(28),40,0,G1H16(38),n2h16(110))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1011),h0tab(:,1011),[40,3,16,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(29),m3h4x16(:,91),heltab2x64(:,:,991))
  call Hloop_A_Q(ntryL,G0H16(29),40,0,G1H16(39),n2h16(111))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1012),h0tab(:,1012),[40,3,16,4],[0,0,0,nMZ],4,2,wf4(:,5),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(30),ngZl,m3h4x16(:,92),heltab2x64(:,:,992))
  call Hloop_A_Q(ntryL,G0H16(30),40,0,G1H16(40),n2h16(112))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1013),h0tab(:,1013),[40,3,16,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(31),m3h4x16(:,93),heltab2x64(:,:,993))
  call Hloop_A_Q(ntryL,G0H16(31),40,0,G1H16(41),n2h16(113))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1014),h0tab(:,1014),[40,3,16,4],[0,0,0,nMZ],4,2,wf4(:,5),wf4(:,6))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(32),ngZl,m3h4x16(:,94),heltab2x64(:,:,994))
  call Hloop_A_Q(ntryL,G0H16(32),40,0,G1H16(42),n2h16(114))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1015),h0tab(:,1015),[40,3,16,4],[nMW,nMW,nMW,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(33),m3h4x16(:,95),heltab2x64(:,:,995))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1016),h0tab(:,1016),[40,3,16,4],[nMW,nMW,nMW,0],4,2,wf4(:,5),wf4(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(34),m3h4x16(:,96),heltab2x64(:,:,996))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1017),h0tab(:,1017),[40,3,16,4],[nMW,nMW,nMW,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(35),m3h4x16(:,97),heltab2x64(:,:,997))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1018),h0tab(:,1018),[40,3,16,4],[nMW,nMW,nMW,0],4,2,wf4(:,5),wf4(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(36),m3h4x16(:,98),heltab2x64(:,:,998))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1019),h0tab(:,1019),[40,4,3,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(37),m3h4x16(:,99),heltab2x64(:,:,999))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1020),h0tab(:,1020),[40,4,3,16],[nMZ,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(38),ngZl,m3h4x16(:,100),heltab2x64(:,:,1000))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1021),h0tab(:,1021),[40,4,3,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(39),m3h4x16(:,101),heltab2x64(:,:,1001))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1022),h0tab(:,1022),[40,4,3,16],[nMZ,0,0,0],4,2,wf4(:,5),wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(40),ngZl,m3h4x16(:,102),heltab2x64(:,:,1002))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1023),h0tab(:,1023),[40,4,3,16],[0,nMW,nMW,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(41),m3h4x16(:,103),heltab2x64(:,:,1003))
  call Hloop_A_Q(ntryL,G0H16(41),40,0,G1H16(47),n2h16(115))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1024),h0tab(:,1024),[40,4,3,16],[0,nMW,nMW,nMW],4,2,wf4(:,5),wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(42),m3h4x16(:,104),heltab2x64(:,:,1004))
  call Hloop_A_Q(ntryL,G0H16(42),40,0,G1H16(49),n2h16(116))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1025),h0tab(:,1025),[40,4,3,16],[0,nMW,nMW,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(43),m3h4x16(:,105),heltab2x64(:,:,1005))
  call Hloop_A_Q(ntryL,G0H16(43),40,0,G1H16(51),n2h16(117))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1026),h0tab(:,1026),[40,4,3,16],[0,nMW,nMW,nMW],4,2,wf4(:,5),wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(44),m3h4x16(:,106),heltab2x64(:,:,1006))
  call Hloop_A_Q(ntryL,G0H16(44),40,0,G1H16(52),n2h16(118))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1027),h0tab(:,1027),[32,7,8,16],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(201),m3h2x32(:,901),heltab2x64(:,:,1007))
  call Hloop_A_Q(ntryL,G0H32(201),32,0,G1H32(419),n2h32(321))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1028),h0tab(:,1028),[32,7,8,16],[0,nMZ,0,0],4,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(201),m3h2x32(:,902),heltab2x64(:,:,1008))
  call Hloop_A_Q(ntryL,G0H32(201),32,0,G1H32(420),n2h32(322))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1029),h0tab(:,1029),[32,7,8,16],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(201),m3h2x32(:,903),heltab2x64(:,:,1009))
  call Hloop_A_Q(ntryL,G0H32(201),32,0,G1H32(421),n2h32(323))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1030),h0tab(:,1030),[32,7,8,16],[0,nMZ,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(201),m3h2x32(:,904),heltab2x64(:,:,1010))
  call Hloop_A_Q(ntryL,G0H32(201),32,0,G1H32(422),n2h32(324))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1031),h0tab(:,1031),[32,7,8,16],[nMW,0,nMW,nMW],4,1,wf8(:,8))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(201),m3h2x32(:,905),heltab2x64(:,:,1011))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1032),h0tab(:,1032),[32,7,8,16],[nMW,0,nMW,nMW],4,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(202),m3h2x32(:,906),heltab2x64(:,:,1012))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1033),h0tab(:,1033),[32,7,8,16],[nMW,0,nMW,nMW],4,1,wf8(:,8))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(423),m3h2x32(:,907),heltab2x64(:,:,1013))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1034),h0tab(:,1034),[32,7,8,16],[nMW,0,nMW,nMW],4,1,wf8(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(424),m3h2x32(:,908),heltab2x64(:,:,1014))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1035),h0tab(:,1035),[32,8,7,16],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(203),m3h2x32(:,909),heltab2x64(:,:,1015))
  call Hloop_Q_A(ntryL,G0H32(203),32,0,G1H32(425),n2h32(325))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1036),h0tab(:,1036),[32,8,7,16],[0,nMZ,0,0],4,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(203),m3h2x32(:,910),heltab2x64(:,:,1016))
  call Hloop_Q_A(ntryL,G0H32(203),32,0,G1H32(426),n2h32(326))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1037),h0tab(:,1037),[32,8,7,16],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(203),m3h2x32(:,911),heltab2x64(:,:,1017))
  call Hloop_Q_A(ntryL,G0H32(203),32,0,G1H32(427),n2h32(327))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1038),h0tab(:,1038),[32,8,7,16],[0,nMZ,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(203),m3h2x32(:,912),heltab2x64(:,:,1018))
  call Hloop_Q_A(ntryL,G0H32(203),32,0,G1H32(428),n2h32(328))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1039),h0tab(:,1039),[32,8,7,16],[nMW,0,nMW,nMW],4,1,wf8(:,8))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(203),m3h2x32(:,913),heltab2x64(:,:,1019))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1040),h0tab(:,1040),[32,8,7,16],[nMW,0,nMW,nMW],4,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(204),m3h2x32(:,914),heltab2x64(:,:,1020))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1041),h0tab(:,1041),[32,8,7,16],[nMW,0,nMW,nMW],4,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(429),m3h2x32(:,915),heltab2x64(:,:,1021))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1042),h0tab(:,1042),[32,8,7,16],[nMW,0,nMW,nMW],4,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(430),m3h2x32(:,916),heltab2x64(:,:,1022))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1043),h0tab(:,1043),[32,11,4,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(205),m3h2x32(:,917),heltab2x64(:,:,1023))
  call Hloop_Q_A(ntryL,G0H32(205),32,0,G1H32(431),n2h32(329))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1044),h0tab(:,1044),[32,11,4,16],[0,nMZ,0,0],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(205),m3h2x32(:,918),heltab2x64(:,:,1024))
  call Hloop_Q_A(ntryL,G0H32(205),32,0,G1H32(432),n2h32(330))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1045),h0tab(:,1045),[32,11,4,16],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(205),m3h2x32(:,919),heltab2x64(:,:,1025))
  call Hloop_Q_A(ntryL,G0H32(205),32,0,G1H32(433),n2h32(331))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1046),h0tab(:,1046),[32,11,4,16],[0,nMZ,0,0],4,1,wf8(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(205),m3h2x32(:,920),heltab2x64(:,:,1026))
  call Hloop_Q_A(ntryL,G0H32(205),32,0,G1H32(434),n2h32(332))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1047),h0tab(:,1047),[32,11,4,16],[nMW,0,nMW,nMW],4,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(205),m3h2x32(:,921),heltab2x64(:,:,1027))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1048),h0tab(:,1048),[32,11,4,16],[nMW,0,nMW,nMW],4,1,wf8(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(206),m3h2x32(:,922),heltab2x64(:,:,1028))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1049),h0tab(:,1049),[32,11,4,16],[nMW,0,nMW,nMW],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(435),m3h2x32(:,923),heltab2x64(:,:,1029))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1050),h0tab(:,1050),[32,11,4,16],[nMW,0,nMW,nMW],4,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(436),m3h2x32(:,924),heltab2x64(:,:,1030))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1051),h0tab(:,1051),[32,4,11,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(207),m3h2x32(:,925),heltab2x64(:,:,1031))
  call Hloop_A_Q(ntryL,G0H32(207),32,0,G1H32(437),n2h32(333))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1052),h0tab(:,1052),[32,4,11,16],[0,nMZ,0,0],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(207),m3h2x32(:,926),heltab2x64(:,:,1032))
  call Hloop_A_Q(ntryL,G0H32(207),32,0,G1H32(438),n2h32(334))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1053),h0tab(:,1053),[32,4,11,16],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(207),m3h2x32(:,927),heltab2x64(:,:,1033))
  call Hloop_A_Q(ntryL,G0H32(207),32,0,G1H32(439),n2h32(335))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1054),h0tab(:,1054),[32,4,11,16],[0,nMZ,0,0],4,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(207),m3h2x32(:,928),heltab2x64(:,:,1034))
  call Hloop_A_Q(ntryL,G0H32(207),32,0,G1H32(440),n2h32(336))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1055),h0tab(:,1055),[32,4,11,16],[nMW,0,nMW,nMW],4,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(207),m3h2x32(:,929),heltab2x64(:,:,1035))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1056),h0tab(:,1056),[32,4,11,16],[nMW,0,nMW,nMW],4,1,wf8(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(208),m3h2x32(:,930),heltab2x64(:,:,1036))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1057),h0tab(:,1057),[32,4,11,16],[nMW,0,nMW,nMW],4,1,wf8(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(441),m3h2x32(:,931),heltab2x64(:,:,1037))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1058),h0tab(:,1058),[32,4,11,16],[nMW,0,nMW,nMW],4,1,wf8(:,5))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(442),m3h2x32(:,932),heltab2x64(:,:,1038))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1059),h0tab(:,1059),[32,2,17,12],[0,0,0,0],4,2,wf4(:,14),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(209),m3h2x32(:,933),heltab2x64(:,:,1039))
  call Hloop_Q_A(ntryL,G0H32(209),32,0,G1H32(443),n2h32(337))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1060),h0tab(:,1060),[32,2,17,12],[0,nMZ,0,0],4,2,wf4(:,14),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(209),m3h2x32(:,934),heltab2x64(:,:,1040))
  call Hloop_Q_A(ntryL,G0H32(209),32,0,G1H32(444),n2h32(338))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1061),h0tab(:,1061),[32,2,17,12],[0,0,0,0],4,2,wf4(:,14),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(209),m3h2x32(:,935),heltab2x64(:,:,1041))
  call Hloop_Q_A(ntryL,G0H32(209),32,0,G1H32(445),n2h32(339))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1062),h0tab(:,1062),[32,2,17,12],[0,nMZ,0,0],4,2,wf4(:,14),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(209),m3h2x32(:,936),heltab2x64(:,:,1042))
  call Hloop_Q_A(ntryL,G0H32(209),32,0,G1H32(446),n2h32(340))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1063),h0tab(:,1063),[32,2,17,12],[nMW,0,nMW,nMW],4,2,wf4(:,14),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(209),m3h2x32(:,937),heltab2x64(:,:,1043))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1064),h0tab(:,1064),[32,2,17,12],[nMW,0,nMW,nMW],4,2,wf4(:,14),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(210),m3h2x32(:,938),heltab2x64(:,:,1044))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1065),h0tab(:,1065),[32,2,17,12],[nMW,0,nMW,nMW],4,2,wf4(:,14),wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(447),m3h2x32(:,939),heltab2x64(:,:,1045))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1066),h0tab(:,1066),[32,2,17,12],[nMW,0,nMW,nMW],4,2,wf4(:,14),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(448),m3h2x32(:,940),heltab2x64(:,:,1046))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1067),h0tab(:,1067),[32,2,12,17],[nMW,0,0,nMW],4,2,wf4(:,16),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(449),m3h2x32(:,941),heltab2x64(:,:,1047))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1068),h0tab(:,1068),[32,12,2,17],[0,0,0,0],4,2,wf4(:,13),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(211),m3h2x32(:,942),heltab2x64(:,:,1048))
  call Hloop_Q_A(ntryL,G0H32(211),32,0,G1H32(450),n2h32(341))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1069),h0tab(:,1069),[32,12,2,17],[0,0,nMZ,0],4,2,wf4(:,13),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(211),m3h2x32(:,943),heltab2x64(:,:,1049))
  call Hloop_Q_A(ntryL,G0H32(211),32,0,G1H32(451),n2h32(342))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1070),h0tab(:,1070),[32,12,2,17],[0,0,0,0],4,2,wf4(:,16),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(211),m3h2x32(:,944),heltab2x64(:,:,1050))
  call Hloop_Q_A(ntryL,G0H32(211),32,0,G1H32(452),n2h32(343))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1071),h0tab(:,1071),[32,12,2,17],[0,0,nMZ,0],4,2,wf4(:,16),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(211),m3h2x32(:,945),heltab2x64(:,:,1051))
  call Hloop_Q_A(ntryL,G0H32(211),32,0,G1H32(453),n2h32(344))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1072),h0tab(:,1072),[32,12,2,17],[nMW,nMW,0,nMW],4,2,wf4(:,13),wf4(:,14))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(211),m3h2x32(:,946),heltab2x64(:,:,1052))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1073),h0tab(:,1073),[32,12,2,17],[nMW,nMW,0,nMW],4,2,wf4(:,16),wf4(:,14))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(212),m3h2x32(:,947),heltab2x64(:,:,1053))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1074),h0tab(:,1074),[32,12,2,17],[nMW,nMW,0,nMW],4,2,wf4(:,13),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(454),m3h2x32(:,948),heltab2x64(:,:,1054))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1075),h0tab(:,1075),[32,12,2,17],[nMW,nMW,0,nMW],4,2,wf4(:,16),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(455),m3h2x32(:,949),heltab2x64(:,:,1055))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1076),h0tab(:,1076),[32,1,18,12],[0,0,0,0],4,2,wf4(:,20),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(213),m3h2x32(:,950),heltab2x64(:,:,1056))
  call Hloop_A_Q(ntryL,G0H32(213),32,0,G1H32(456),n2h32(345))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1077),h0tab(:,1077),[32,1,18,12],[0,nMZ,0,0],4,2,wf4(:,20),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(213),m3h2x32(:,951),heltab2x64(:,:,1057))
  call Hloop_A_Q(ntryL,G0H32(213),32,0,G1H32(457),n2h32(346))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1078),h0tab(:,1078),[32,1,18,12],[0,0,0,0],4,2,wf4(:,20),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(213),m3h2x32(:,952),heltab2x64(:,:,1058))
  call Hloop_A_Q(ntryL,G0H32(213),32,0,G1H32(458),n2h32(347))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1079),h0tab(:,1079),[32,1,18,12],[0,nMZ,0,0],4,2,wf4(:,20),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(213),m3h2x32(:,953),heltab2x64(:,:,1059))
  call Hloop_A_Q(ntryL,G0H32(213),32,0,G1H32(459),n2h32(348))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1080),h0tab(:,1080),[32,1,18,12],[nMW,0,nMW,nMW],4,2,wf4(:,20),wf4(:,13))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(213),m3h2x32(:,954),heltab2x64(:,:,1060))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1081),h0tab(:,1081),[32,1,18,12],[nMW,0,nMW,nMW],4,2,wf4(:,20),wf4(:,16))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(214),m3h2x32(:,955),heltab2x64(:,:,1061))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1082),h0tab(:,1082),[32,1,18,12],[nMW,0,nMW,nMW],4,2,wf4(:,20),wf4(:,13))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(460),m3h2x32(:,956),heltab2x64(:,:,1062))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1083),h0tab(:,1083),[32,1,18,12],[nMW,0,nMW,nMW],4,2,wf4(:,20),wf4(:,16))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(461),m3h2x32(:,957),heltab2x64(:,:,1063))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1084),h0tab(:,1084),[32,1,12,18],[nMW,0,0,nMW],4,2,wf4(:,16),wf4(:,20))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(462),m3h2x32(:,958),heltab2x64(:,:,1064))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1085),h0tab(:,1085),[32,12,1,18],[0,0,0,0],4,2,wf4(:,13),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(215),m3h2x32(:,959),heltab2x64(:,:,1065))


! end do

end subroutine vamp_1

end module ol_vamp_1_ppllll_ew_eexmmxaa_1_/**/REALKIND
