
module ol_vamp_1_ppllll_ew_eeexexbbx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_ew_eeexexbbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_ew_eeexexbbx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_ew_eeexexbbx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_ew_eeexexbbx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllll_ew_eeexexbbx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_eeexexbbx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,2,1,4,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZd,m3h2x32(:,2),heltab2x64(:,:,2))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,2,1,4,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,8,2,1,4,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,4),heltab2x64(:,:,4))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,2,1,4,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(5),ngZd,m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,8,2,1,4,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,2,1,4,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,8,2,1,4,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,1,2,8,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,9),heltab2x64(:,:,9))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,1,2,8,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,4,1,2,8,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(11),ngZd,m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,4,1,2,8,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,4,1,2,8,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZd,m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,1,2,8,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,1,2,8,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZd,m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,1,2,8,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(16),ngZd,m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,8,1,2,4,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,17),heltab2x64(:,:,17))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,8,1,2,4,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZd,m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,8,1,2,4,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,8,1,2,4,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,8,1,2,4,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(21),ngZd,m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,8,1,2,4,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(22),ngZd,m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,8,1,2,4,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,8,1,2,4,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(24),ngZd,m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,4,2,1,8,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,4,2,1,8,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,4,2,1,8,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(27),ngZd,m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,4,2,1,8,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,4,2,1,8,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(29),ngZd,m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,4,2,1,8,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,30),heltab2x64(:,:,30))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,4,2,1,8,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(31),ngZd,m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,4,2,1,8,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(32),ngZd,m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,8,1,4,2,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,33),heltab2x64(:,:,33))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,8,1,4,2,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(34),ngZd,m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,8,1,4,2,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,8,1,4,2,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,8,1,4,2,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(37),ngZd,m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,8,1,4,2,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(38),ngZd,m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,8,1,4,2,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,8,1,4,2,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(40),ngZd,m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,2,4,1,8,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,2,4,1,8,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,2,4,1,8,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(43),ngZd,m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,2,4,1,8,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,44),heltab2x64(:,:,44))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,2,4,1,8,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(45),ngZd,m3h2x32(:,45),heltab2x64(:,:,45))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,2,4,1,8,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,2,4,1,8,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(47),ngZd,m3h2x32(:,47),heltab2x64(:,:,47))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,2,4,1,8,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(48),ngZd,m3h2x32(:,48),heltab2x64(:,:,48))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,2,4,1,8,16],[nMW,0,nMW,0,nMW,nMT],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,49),heltab2x64(:,:,49))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,4,1,8,2,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,4,1,8,2,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(51),ngZd,m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,4,1,8,2,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,4,1,8,2,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,53),heltab2x64(:,:,53))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,4,1,8,2,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(54),ngZd,m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,4,1,8,2,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(55),ngZd,m3h2x32(:,55),heltab2x64(:,:,55))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,4,1,8,2,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(56),m3h2x32(:,56),heltab2x64(:,:,56))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,4,1,8,2,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(57),ngZd,m3h2x32(:,57),heltab2x64(:,:,57))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,2,8,1,4,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,58),heltab2x64(:,:,58))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,2,8,1,4,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,2,8,1,4,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(60),ngZd,m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,2,8,1,4,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(61),m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,2,8,1,4,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(62),ngZd,m3h2x32(:,62),heltab2x64(:,:,62))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,2,8,1,4,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(63),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,2,8,1,4,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(64),ngZd,m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,2,8,1,4,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(65),ngZd,m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,2,8,1,4,16],[nMW,0,nMW,0,nMW,nMT],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(66),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,8,2,4,1,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(67),m3h2x32(:,67),heltab2x64(:,:,67))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,8,2,4,1,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(68),ngZd,m3h2x32(:,68),heltab2x64(:,:,68))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,8,2,4,1,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,69),heltab2x64(:,:,69))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,8,2,4,1,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(70),m3h2x32(:,70),heltab2x64(:,:,70))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,8,2,4,1,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(71),ngZd,m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,8,2,4,1,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(72),ngZd,m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,8,2,4,1,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(73),m3h2x32(:,73),heltab2x64(:,:,73))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,8,2,4,1,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(74),ngZd,m3h2x32(:,74),heltab2x64(:,:,74))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,2,8,4,1,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(75),m3h2x32(:,75),heltab2x64(:,:,75))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,2,8,4,1,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(76),m3h2x32(:,76),heltab2x64(:,:,76))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,2,8,4,1,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(77),ngZd,m3h2x32(:,77),heltab2x64(:,:,77))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,2,8,4,1,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(78),m3h2x32(:,78),heltab2x64(:,:,78))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,2,8,4,1,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(79),ngZd,m3h2x32(:,79),heltab2x64(:,:,79))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,2,8,4,1,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(80),m3h2x32(:,80),heltab2x64(:,:,80))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,2,8,4,1,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(81),ngZd,m3h2x32(:,81),heltab2x64(:,:,81))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,2,8,4,1,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(82),ngZd,m3h2x32(:,82),heltab2x64(:,:,82))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,1,4,2,8,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(83),m3h2x32(:,83),heltab2x64(:,:,83))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,1,4,2,8,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(84),m3h2x32(:,84),heltab2x64(:,:,84))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,1,4,2,8,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(85),m3h2x32(:,85),heltab2x64(:,:,85))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,1,4,2,8,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(86),ngZd,m3h2x32(:,86),heltab2x64(:,:,86))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,1,4,2,8,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(87),m3h2x32(:,87),heltab2x64(:,:,87))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,1,4,2,8,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(88),ngZd,m3h2x32(:,88),heltab2x64(:,:,88))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,1,4,2,8,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(89),ngZd,m3h2x32(:,89),heltab2x64(:,:,89))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,1,4,2,8,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(90),ngZd,m3h2x32(:,90),heltab2x64(:,:,90))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,1,4,2,8,16],[nMW,0,nMW,0,nMW,nMT],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(91),m3h2x32(:,91),heltab2x64(:,:,91))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,1,4,8,2,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(92),m3h2x32(:,92),heltab2x64(:,:,92))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,1,4,8,2,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(93),m3h2x32(:,93),heltab2x64(:,:,93))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,1,4,8,2,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,94),heltab2x64(:,:,94))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,1,4,8,2,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(95),ngZd,m3h2x32(:,95),heltab2x64(:,:,95))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,1,4,8,2,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(96),m3h2x32(:,96),heltab2x64(:,:,96))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,1,4,8,2,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(97),ngZd,m3h2x32(:,97),heltab2x64(:,:,97))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,1,4,8,2,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(98),ngZd,m3h2x32(:,98),heltab2x64(:,:,98))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,1,4,8,2,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(99),ngZd,m3h2x32(:,99),heltab2x64(:,:,99))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,4,2,8,1,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(100),m3h2x32(:,100),heltab2x64(:,:,100))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,4,2,8,1,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(101),ngZd,m3h2x32(:,101),heltab2x64(:,:,101))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,4,2,8,1,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(102),m3h2x32(:,102),heltab2x64(:,:,102))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,4,2,8,1,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,103),heltab2x64(:,:,103))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,4,2,8,1,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(104),ngZd,m3h2x32(:,104),heltab2x64(:,:,104))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,4,2,8,1,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(105),ngZd,m3h2x32(:,105),heltab2x64(:,:,105))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,4,2,8,1,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(106),m3h2x32(:,106),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,4,2,8,1,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(107),ngZd,m3h2x32(:,107),heltab2x64(:,:,107))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,2,4,8,1,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(108),m3h2x32(:,108),heltab2x64(:,:,108))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,2,4,8,1,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(109),m3h2x32(:,109),heltab2x64(:,:,109))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,2,4,8,1,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(110),ngZd,m3h2x32(:,110),heltab2x64(:,:,110))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,2,4,8,1,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(111),m3h2x32(:,111),heltab2x64(:,:,111))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,2,4,8,1,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(112),ngZd,m3h2x32(:,112),heltab2x64(:,:,112))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,2,4,8,1,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,113),heltab2x64(:,:,113))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,2,4,8,1,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(114),ngZd,m3h2x32(:,114),heltab2x64(:,:,114))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,2,4,8,1,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(115),ngZd,m3h2x32(:,115),heltab2x64(:,:,115))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,1,8,2,4,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(116),m3h2x32(:,116),heltab2x64(:,:,116))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,1,8,2,4,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(117),m3h2x32(:,117),heltab2x64(:,:,117))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,1,8,2,4,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(118),m3h2x32(:,118),heltab2x64(:,:,118))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,1,8,2,4,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(119),ngZd,m3h2x32(:,119),heltab2x64(:,:,119))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,1,8,2,4,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(120),m3h2x32(:,120),heltab2x64(:,:,120))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,1,8,2,4,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(121),ngZd,m3h2x32(:,121),heltab2x64(:,:,121))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,1,8,2,4,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(122),ngZd,m3h2x32(:,122),heltab2x64(:,:,122))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,1,8,2,4,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(123),ngZd,m3h2x32(:,123),heltab2x64(:,:,123))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,1,8,2,4,16],[nMW,0,nMW,0,nMW,nMT],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(124),m3h2x32(:,124),heltab2x64(:,:,124))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,1,8,4,2,16],[0,0,0,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(125),m3h2x32(:,125),heltab2x64(:,:,125))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,1,8,4,2,16],[0,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(126),m3h2x32(:,126),heltab2x64(:,:,126))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,1,8,4,2,16],[0,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(127),m3h2x32(:,127),heltab2x64(:,:,127))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,1,8,4,2,16],[nMZ,0,0,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(128),ngZd,m3h2x32(:,128),heltab2x64(:,:,128))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,1,8,4,2,16],[0,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,129),heltab2x64(:,:,129))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,1,8,4,2,16],[nMZ,0,nMZ,0,0,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(130),ngZd,m3h2x32(:,130),heltab2x64(:,:,130))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,1,8,4,2,16],[nMZ,0,0,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(131),ngZd,m3h2x32(:,131),heltab2x64(:,:,131))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,1,8,4,2,16],[nMZ,0,nMZ,0,nMZ,nMB],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(132),ngZd,m3h2x32(:,132),heltab2x64(:,:,132))
  call Hloop_VA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(1),n2h16(1))
  call Hloop_ZA_Q(ntryL,G0H32(2),ex4(:),G0H16(1),ngZl,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(2),n2h16(2))
  call Hloop_VA_Q(ntryL,G0H32(3),ex4(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(3),n2h16(3))
  call Hloop_VA_Q(ntryL,G0H32(4),ex4(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(4),n2h16(4))
  call Hloop_ZA_Q(ntryL,G0H32(5),ex4(:),G0H16(1),ngZl,m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(5),n2h16(5))
  call Hloop_ZA_Q(ntryL,G0H32(6),ex4(:),G0H16(1),ngZl,m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(6),n2h16(6))
  call Hloop_VA_Q(ntryL,G0H32(7),ex4(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(7),n2h16(7))
  call Hloop_ZA_Q(ntryL,G0H32(8),ex4(:),G0H16(1),ngZl,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(8),n2h16(8))
  call Hloop_VA_Q(ntryL,G0H32(9),ex3(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(9),n2h16(9))
  call Hloop_VA_Q(ntryL,G0H32(10),ex3(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(10),n2h16(10))
  call Hloop_ZA_Q(ntryL,G0H32(11),ex3(:),G0H16(1),ngZl,m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(11),n2h16(11))
  call Hloop_VA_Q(ntryL,G0H32(12),ex3(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(12),n2h16(12))
  call Hloop_ZA_Q(ntryL,G0H32(13),ex3(:),G0H16(1),ngZl,m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(13),n2h16(13))
  call Hloop_VA_Q(ntryL,G0H32(14),ex3(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(14),n2h16(14))
  call Hloop_ZA_Q(ntryL,G0H32(15),ex3(:),G0H16(1),ngZl,m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(15),n2h16(15))
  call Hloop_ZA_Q(ntryL,G0H32(16),ex3(:),G0H16(1),ngZl,m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(16),n2h16(16))
  call Hloop_VA_Q(ntryL,G0H32(17),ex4(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(17),n2h16(17))
  call Hloop_ZA_Q(ntryL,G0H32(18),ex4(:),G0H16(1),ngZl,m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(18),n2h16(18))
  call Hloop_VA_Q(ntryL,G0H32(19),ex4(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(19),n2h16(19))
  call Hloop_VA_Q(ntryL,G0H32(20),ex4(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(20),n2h16(20))
  call Hloop_ZA_Q(ntryL,G0H32(21),ex4(:),G0H16(1),ngZl,m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(21),n2h16(21))
  call Hloop_ZA_Q(ntryL,G0H32(22),ex4(:),G0H16(1),ngZl,m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(22),n2h16(22))
  call Hloop_VA_Q(ntryL,G0H32(23),ex4(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(23),n2h16(23))
  call Hloop_ZA_Q(ntryL,G0H32(24),ex4(:),G0H16(1),ngZl,m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(24),n2h16(24))
  call Hloop_VA_Q(ntryL,G0H32(25),ex3(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(25),n2h16(25))
  call Hloop_VA_Q(ntryL,G0H32(26),ex3(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(26),n2h16(26))
  call Hloop_ZA_Q(ntryL,G0H32(27),ex3(:),G0H16(1),ngZl,m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(27),n2h16(27))
  call Hloop_VA_Q(ntryL,G0H32(28),ex3(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(28),n2h16(28))
  call Hloop_ZA_Q(ntryL,G0H32(29),ex3(:),G0H16(1),ngZl,m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(29),n2h16(29))
  call Hloop_VA_Q(ntryL,G0H32(30),ex3(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(30),n2h16(30))
  call Hloop_ZA_Q(ntryL,G0H32(31),ex3(:),G0H16(1),ngZl,m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(31),n2h16(31))
  call Hloop_ZA_Q(ntryL,G0H32(32),ex3(:),G0H16(1),ngZl,m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(32),n2h16(32))
  call Hloop_VA_Q(ntryL,G0H32(33),ex4(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(33),n2h16(33))
  call Hloop_ZA_Q(ntryL,G0H32(34),ex4(:),G0H16(1),ngZl,m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(34),n2h16(34))
  call Hloop_VA_Q(ntryL,G0H32(35),ex4(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(35),n2h16(35))
  call Hloop_VA_Q(ntryL,G0H32(36),ex4(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(36),n2h16(36))
  call Hloop_ZA_Q(ntryL,G0H32(37),ex4(:),G0H16(1),ngZl,m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(37),n2h16(37))
  call Hloop_ZA_Q(ntryL,G0H32(38),ex4(:),G0H16(1),ngZl,m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(38),n2h16(38))
  call Hloop_VA_Q(ntryL,G0H32(39),ex4(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(39),n2h16(39))
  call Hloop_ZA_Q(ntryL,G0H32(40),ex4(:),G0H16(1),ngZl,m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(40),n2h16(40))
  call Hloop_VQ_A(ntryL,G0H32(41),ex2(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(41),n2h16(41))
  call Hloop_VQ_A(ntryL,G0H32(42),ex2(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(42),n2h16(42))
  call Hloop_ZQ_A(ntryL,G0H32(43),ex2(:),G0H16(1),ngZl,m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(43),n2h16(43))
  call Hloop_VQ_A(ntryL,G0H32(44),ex2(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(44),n2h16(44))
  call Hloop_ZQ_A(ntryL,G0H32(45),ex2(:),G0H16(1),ngZl,m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(45),n2h16(45))
  call Hloop_VQ_A(ntryL,G0H32(46),ex2(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(46),n2h16(46))
  call Hloop_ZQ_A(ntryL,G0H32(47),ex2(:),G0H16(1),ngZl,m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(47),n2h16(47))
  call Hloop_ZQ_A(ntryL,G0H32(48),ex2(:),G0H16(1),ngZl,m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(48),n2h16(48))
  call Hloop_WQ_A(ntryL,G0H32(49),ex2(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(49),n2h16(49))
  call Hloop_VA_Q(ntryL,G0H32(50),ex3(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(50),n2h16(50))
  call Hloop_ZA_Q(ntryL,G0H32(51),ex3(:),G0H16(1),ngZl,m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(51),n2h16(51))
  call Hloop_VA_Q(ntryL,G0H32(52),ex3(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(52),n2h16(52))
  call Hloop_VA_Q(ntryL,G0H32(53),ex3(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(53),n2h16(53))
  call Hloop_ZA_Q(ntryL,G0H32(54),ex3(:),G0H16(1),ngZl,m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(54),n2h16(54))
  call Hloop_ZA_Q(ntryL,G0H32(55),ex3(:),G0H16(1),ngZl,m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(55),n2h16(55))
  call Hloop_VA_Q(ntryL,G0H32(56),ex3(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(56),n2h16(56))
  call Hloop_ZA_Q(ntryL,G0H32(57),ex3(:),G0H16(1),ngZl,m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(57),n2h16(57))
  call Hloop_VQ_A(ntryL,G0H32(58),ex2(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(58),n2h16(58))
  call Hloop_VQ_A(ntryL,G0H32(59),ex2(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(59),n2h16(59))
  call Hloop_ZQ_A(ntryL,G0H32(60),ex2(:),G0H16(1),ngZl,m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(60),n2h16(60))
  call Hloop_VQ_A(ntryL,G0H32(61),ex2(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(61),n2h16(61))
  call Hloop_ZQ_A(ntryL,G0H32(62),ex2(:),G0H16(1),ngZl,m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(62),n2h16(62))
  call Hloop_VQ_A(ntryL,G0H32(63),ex2(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(63),n2h16(63))
  call Hloop_ZQ_A(ntryL,G0H32(64),ex2(:),G0H16(1),ngZl,m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(64),n2h16(64))
  call Hloop_ZQ_A(ntryL,G0H32(65),ex2(:),G0H16(1),ngZl,m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(65),n2h16(65))
  call Hloop_WQ_A(ntryL,G0H32(66),ex2(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(66),n2h16(66))
  call Hloop_VA_Q(ntryL,G0H32(67),ex4(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(67),n2h16(67))
  call Hloop_ZA_Q(ntryL,G0H32(68),ex4(:),G0H16(1),ngZl,m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(68),n2h16(68))
  call Hloop_VA_Q(ntryL,G0H32(69),ex4(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(69),n2h16(69))
  call Hloop_VA_Q(ntryL,G0H32(70),ex4(:),G0H16(1),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(70),n2h16(70))
  call Hloop_ZA_Q(ntryL,G0H32(71),ex4(:),G0H16(1),ngZl,m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(71),n2h16(71))
  call Hloop_ZA_Q(ntryL,G0H32(72),ex4(:),G0H16(1),ngZl,m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(72),n2h16(72))
  call Hloop_VA_Q(ntryL,G0H32(73),ex4(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(73),n2h16(73))
  call Hloop_ZA_Q(ntryL,G0H32(74),ex4(:),G0H16(1),ngZl,m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(74),n2h16(74))
  call Hloop_VQ_A(ntryL,G0H32(75),ex2(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(75),n2h16(75))
  call Hloop_VQ_A(ntryL,G0H32(76),ex2(:),G0H16(1),m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(76),n2h16(76))
  call Hloop_ZQ_A(ntryL,G0H32(77),ex2(:),G0H16(1),ngZl,m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(77),n2h16(77))
  call Hloop_VQ_A(ntryL,G0H32(78),ex2(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(78),n2h16(78))
  call Hloop_ZQ_A(ntryL,G0H32(79),ex2(:),G0H16(1),ngZl,m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(79),n2h16(79))
  call Hloop_VQ_A(ntryL,G0H32(80),ex2(:),G0H16(1),m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(80),n2h16(80))
  call Hloop_ZQ_A(ntryL,G0H32(81),ex2(:),G0H16(1),ngZl,m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(81),n2h16(81))
  call Hloop_ZQ_A(ntryL,G0H32(82),ex2(:),G0H16(1),ngZl,m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(82),n2h16(82))
  call Hloop_VQ_A(ntryL,G0H32(83),ex1(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(83),n2h16(83))
  call Hloop_VQ_A(ntryL,G0H32(84),ex1(:),G0H16(1),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(84),n2h16(84))
  call Hloop_VQ_A(ntryL,G0H32(85),ex1(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(85),n2h16(85))
  call Hloop_ZQ_A(ntryL,G0H32(86),ex1(:),G0H16(1),ngZl,m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(86),n2h16(86))
  call Hloop_VQ_A(ntryL,G0H32(87),ex1(:),G0H16(1),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(87),n2h16(87))
  call Hloop_ZQ_A(ntryL,G0H32(88),ex1(:),G0H16(1),ngZl,m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(88),n2h16(88))
  call Hloop_ZQ_A(ntryL,G0H32(89),ex1(:),G0H16(1),ngZl,m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(89),n2h16(89))
  call Hloop_ZQ_A(ntryL,G0H32(90),ex1(:),G0H16(1),ngZl,m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(90),n2h16(90))
  call Hloop_WQ_A(ntryL,G0H32(91),ex1(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(91),n2h16(91))
  call Hloop_VQ_A(ntryL,G0H32(92),ex1(:),G0H16(1),m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(92),n2h16(92))
  call Hloop_VQ_A(ntryL,G0H32(93),ex1(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(93),n2h16(93))
  call Hloop_VQ_A(ntryL,G0H32(94),ex1(:),G0H16(1),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(94),n2h16(94))
  call Hloop_ZQ_A(ntryL,G0H32(95),ex1(:),G0H16(1),ngZl,m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(95),n2h16(95))
  call Hloop_VQ_A(ntryL,G0H32(96),ex1(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(96),n2h16(96))
  call Hloop_ZQ_A(ntryL,G0H32(97),ex1(:),G0H16(1),ngZl,m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(97),n2h16(97))
  call Hloop_ZQ_A(ntryL,G0H32(98),ex1(:),G0H16(1),ngZl,m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(98),n2h16(98))
  call Hloop_ZQ_A(ntryL,G0H32(99),ex1(:),G0H16(1),ngZl,m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(99),n2h16(99))
  call Hloop_VA_Q(ntryL,G0H32(100),ex3(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(100),n2h16(100))
  call Hloop_ZA_Q(ntryL,G0H32(101),ex3(:),G0H16(1),ngZl,m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(101),n2h16(101))
  call Hloop_VA_Q(ntryL,G0H32(102),ex3(:),G0H16(1),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(102),n2h16(102))
  call Hloop_VA_Q(ntryL,G0H32(103),ex3(:),G0H16(1),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(103),n2h16(103))
  call Hloop_ZA_Q(ntryL,G0H32(104),ex3(:),G0H16(1),ngZl,m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(104),n2h16(104))
  call Hloop_ZA_Q(ntryL,G0H32(105),ex3(:),G0H16(1),ngZl,m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(105),n2h16(105))
  call Hloop_VA_Q(ntryL,G0H32(106),ex3(:),G0H16(1),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(106),n2h16(106))
  call Hloop_ZA_Q(ntryL,G0H32(107),ex3(:),G0H16(1),ngZl,m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(107),n2h16(107))
  call Hloop_VQ_A(ntryL,G0H32(108),ex2(:),G0H16(1),m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(108),n2h16(108))
  call Hloop_VQ_A(ntryL,G0H32(109),ex2(:),G0H16(1),m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(109),n2h16(109))
  call Hloop_ZQ_A(ntryL,G0H32(110),ex2(:),G0H16(1),ngZl,m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(110),n2h16(110))
  call Hloop_VQ_A(ntryL,G0H32(111),ex2(:),G0H16(1),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(111),n2h16(111))
  call Hloop_ZQ_A(ntryL,G0H32(112),ex2(:),G0H16(1),ngZl,m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(112),n2h16(112))
  call Hloop_VQ_A(ntryL,G0H32(113),ex2(:),G0H16(1),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(113),n2h16(113))
  call Hloop_ZQ_A(ntryL,G0H32(114),ex2(:),G0H16(1),ngZl,m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(114),n2h16(114))
  call Hloop_ZQ_A(ntryL,G0H32(115),ex2(:),G0H16(1),ngZl,m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(115),n2h16(115))
  call Hloop_VQ_A(ntryL,G0H32(116),ex1(:),G0H16(1),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(116),n2h16(116))
  call Hloop_VQ_A(ntryL,G0H32(117),ex1(:),G0H16(1),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(117),n2h16(117))
  call Hloop_VQ_A(ntryL,G0H32(118),ex1(:),G0H16(1),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(118),n2h16(118))
  call Hloop_ZQ_A(ntryL,G0H32(119),ex1(:),G0H16(1),ngZl,m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(119),n2h16(119))
  call Hloop_VQ_A(ntryL,G0H32(120),ex1(:),G0H16(1),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(120),n2h16(120))
  call Hloop_ZQ_A(ntryL,G0H32(121),ex1(:),G0H16(1),ngZl,m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(121),n2h16(121))
  call Hloop_ZQ_A(ntryL,G0H32(122),ex1(:),G0H16(1),ngZl,m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(122),n2h16(122))
  call Hloop_ZQ_A(ntryL,G0H32(123),ex1(:),G0H16(1),ngZl,m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(123),n2h16(123))
  call Hloop_WQ_A(ntryL,G0H32(124),ex1(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(124),n2h16(124))
  call Hloop_VQ_A(ntryL,G0H32(125),ex1(:),G0H16(1),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(125),n2h16(125))
  call Hloop_VQ_A(ntryL,G0H32(126),ex1(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(126),n2h16(126))
  call Hloop_VQ_A(ntryL,G0H32(127),ex1(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(127),n2h16(127))
  call Hloop_ZQ_A(ntryL,G0H32(128),ex1(:),G0H16(1),ngZl,m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(128),n2h16(128))
  call Hloop_VQ_A(ntryL,G0H32(129),ex1(:),G0H16(1),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(129),n2h16(129))
  call Hloop_ZQ_A(ntryL,G0H32(130),ex1(:),G0H16(1),ngZl,m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(130),n2h16(130))
  call Hloop_ZQ_A(ntryL,G0H32(131),ex1(:),G0H16(1),ngZl,m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(131),n2h16(131))
  call Hloop_ZQ_A(ntryL,G0H32(132),ex1(:),G0H16(1),ngZl,m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(132),n2h16(132))
  call Hloop_AQ_V(ntryL,G1H16(1),ex2(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G1H16(2),ex2(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G1H16(3),ex2(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex2(:),G1H8(4),ngZl,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_V(ntryL,G1H16(5),ex2(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_Z(ntryL,G1H16(6),ex2(:),G1H8(6),ngZl,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H16(7),ex2(:),G1H8(7),ngZl,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H16(8),ex2(:),G1H8(8),ngZl,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_V(ntryL,G1H16(9),ex1(:),G1H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_V(ntryL,G1H16(10),ex1(:),G1H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_V(ntryL,G1H16(11),ex1(:),G1H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H16(12),ex1(:),G1H8(12),ngZl,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(13),ex1(:),G1H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex1(:),G1H8(14),ngZl,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_Z(ntryL,G1H16(15),ex1(:),G1H8(15),ngZl,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H16(16),ex1(:),G1H8(16),ngZl,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_V(ntryL,G1H16(17),ex1(:),G1H8(17),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_V(ntryL,G1H16(18),ex1(:),G1H8(18),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AQ_V(ntryL,G1H16(19),ex1(:),G1H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_AQ_Z(ntryL,G1H16(20),ex1(:),G1H8(20),ngZl,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AQ_V(ntryL,G1H16(21),ex1(:),G1H8(21),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_AQ_Z(ntryL,G1H16(22),ex1(:),G1H8(22),ngZl,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_AQ_Z(ntryL,G1H16(23),ex1(:),G1H8(23),ngZl,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AQ_Z(ntryL,G1H16(24),ex1(:),G1H8(24),ngZl,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AQ_V(ntryL,G1H16(25),ex2(:),G1H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AQ_V(ntryL,G1H16(26),ex2(:),G1H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_AQ_V(ntryL,G1H16(27),ex2(:),G1H8(27),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_AQ_Z(ntryL,G1H16(28),ex2(:),G1H8(28),ngZl,m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_AQ_V(ntryL,G1H16(29),ex2(:),G1H8(29),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_AQ_Z(ntryL,G1H16(30),ex2(:),G1H8(30),ngZl,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_AQ_Z(ntryL,G1H16(31),ex2(:),G1H8(31),ngZl,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H16(32),ex2(:),G1H8(32),ngZl,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_AQ_V(ntryL,G1H16(33),ex1(:),G1H8(33),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_AQ_V(ntryL,G1H16(34),ex1(:),G1H8(34),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_AQ_V(ntryL,G1H16(35),ex1(:),G1H8(35),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_AQ_Z(ntryL,G1H16(36),ex1(:),G1H8(36),ngZl,m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_AQ_V(ntryL,G1H16(37),ex1(:),G1H8(37),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_AQ_Z(ntryL,G1H16(38),ex1(:),G1H8(38),ngZl,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_AQ_Z(ntryL,G1H16(39),ex1(:),G1H8(39),ngZl,m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_AQ_Z(ntryL,G1H16(40),ex1(:),G1H8(40),ngZl,m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_QA_V(ntryL,G1H16(41),ex3(:),G1H8(41),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_QA_V(ntryL,G1H16(42),ex3(:),G1H8(42),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_QA_V(ntryL,G1H16(43),ex3(:),G1H8(43),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_QA_Z(ntryL,G1H16(44),ex3(:),G1H8(44),ngZl,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_QA_V(ntryL,G1H16(45),ex3(:),G1H8(45),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_QA_Z(ntryL,G1H16(46),ex3(:),G1H8(46),ngZl,m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_QA_Z(ntryL,G1H16(47),ex3(:),G1H8(47),ngZl,m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_QA_Z(ntryL,G1H16(48),ex3(:),G1H8(48),ngZl,m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_QA_W(ntryL,G1H16(49),ex3(:),G1H8(49),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_AQ_V(ntryL,G1H16(50),ex1(:),G1H8(50),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_AQ_V(ntryL,G1H16(51),ex1(:),G1H8(51),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_AQ_V(ntryL,G1H16(52),ex1(:),G1H8(52),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_AQ_Z(ntryL,G1H16(53),ex1(:),G1H8(53),ngZl,m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_AQ_V(ntryL,G1H16(54),ex1(:),G1H8(54),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AQ_Z(ntryL,G1H16(55),ex1(:),G1H8(55),ngZl,m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H16(56),ex1(:),G1H8(56),ngZl,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_AQ_Z(ntryL,G1H16(57),ex1(:),G1H8(57),ngZl,m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_QA_V(ntryL,G1H16(58),ex4(:),G1H8(58),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_QA_V(ntryL,G1H16(59),ex4(:),G1H8(59),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_QA_V(ntryL,G1H16(60),ex4(:),G1H8(60),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_QA_Z(ntryL,G1H16(61),ex4(:),G1H8(61),ngZl,m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_QA_V(ntryL,G1H16(62),ex4(:),G1H8(62),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_QA_Z(ntryL,G1H16(63),ex4(:),G1H8(63),ngZl,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_QA_Z(ntryL,G1H16(64),ex4(:),G1H8(64),ngZl,m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_QA_Z(ntryL,G1H16(65),ex4(:),G1H8(65),ngZl,m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_QA_W(ntryL,G1H16(66),ex4(:),G1H8(66),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_AQ_V(ntryL,G1H16(67),ex2(:),G1H8(67),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_AQ_V(ntryL,G1H16(68),ex2(:),G1H8(68),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_AQ_Z(ntryL,G1H16(69),ex2(:),G1H8(69),ngZl,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_AQ_V(ntryL,G1H16(70),ex2(:),G1H8(70),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_AQ_Z(ntryL,G1H16(71),ex2(:),G1H8(71),ngZl,m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_AQ_V(ntryL,G1H16(72),ex2(:),G1H8(72),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_AQ_Z(ntryL,G1H16(73),ex2(:),G1H8(73),ngZl,m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_AQ_Z(ntryL,G1H16(74),ex2(:),G1H8(74),ngZl,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_QA_V(ntryL,G1H16(75),ex4(:),G1H8(75),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_QA_Z(ntryL,G1H16(76),ex4(:),G1H8(76),ngZl,m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_QA_V(ntryL,G1H16(77),ex4(:),G1H8(77),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_QA_V(ntryL,G1H16(78),ex4(:),G1H8(78),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_QA_Z(ntryL,G1H16(79),ex4(:),G1H8(79),ngZl,m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_QA_Z(ntryL,G1H16(80),ex4(:),G1H8(80),ngZl,m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_QA_V(ntryL,G1H16(81),ex4(:),G1H8(81),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_QA_Z(ntryL,G1H16(82),ex4(:),G1H8(82),ngZl,m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_QA_V(ntryL,G1H16(83),ex3(:),G1H8(83),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_QA_V(ntryL,G1H16(84),ex3(:),G1H8(84),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_QA_Z(ntryL,G1H16(85),ex3(:),G1H8(85),ngZl,m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_QA_V(ntryL,G1H16(86),ex3(:),G1H8(86),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_QA_Z(ntryL,G1H16(87),ex3(:),G1H8(87),ngZl,m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_QA_V(ntryL,G1H16(88),ex3(:),G1H8(88),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_QA_Z(ntryL,G1H16(89),ex3(:),G1H8(89),ngZl,m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_QA_Z(ntryL,G1H16(90),ex3(:),G1H8(90),ngZl,m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_QA_W(ntryL,G1H16(91),ex3(:),G1H8(91),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_QA_V(ntryL,G1H16(92),ex3(:),G1H8(92),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_QA_Z(ntryL,G1H16(93),ex3(:),G1H8(93),ngZl,m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_QA_V(ntryL,G1H16(94),ex3(:),G1H8(94),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_QA_V(ntryL,G1H16(95),ex3(:),G1H8(95),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_QA_Z(ntryL,G1H16(96),ex3(:),G1H8(96),ngZl,m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_QA_Z(ntryL,G1H16(97),ex3(:),G1H8(97),ngZl,m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_QA_V(ntryL,G1H16(98),ex3(:),G1H8(98),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_QA_Z(ntryL,G1H16(99),ex3(:),G1H8(99),ngZl,m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_AQ_V(ntryL,G1H16(100),ex2(:),G1H8(100),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_AQ_V(ntryL,G1H16(101),ex2(:),G1H8(101),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_AQ_Z(ntryL,G1H16(102),ex2(:),G1H8(102),ngZl,m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_AQ_V(ntryL,G1H16(103),ex2(:),G1H8(103),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_AQ_Z(ntryL,G1H16(104),ex2(:),G1H8(104),ngZl,m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_AQ_V(ntryL,G1H16(105),ex2(:),G1H8(105),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_AQ_Z(ntryL,G1H16(106),ex2(:),G1H8(106),ngZl,m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_AQ_Z(ntryL,G1H16(107),ex2(:),G1H8(107),ngZl,m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_QA_V(ntryL,G1H16(108),ex3(:),G1H8(108),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_QA_Z(ntryL,G1H16(109),ex3(:),G1H8(109),ngZl,m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_QA_V(ntryL,G1H16(110),ex3(:),G1H8(110),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_QA_V(ntryL,G1H16(111),ex3(:),G1H8(111),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_QA_Z(ntryL,G1H16(112),ex3(:),G1H8(112),ngZl,m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_QA_Z(ntryL,G1H16(113),ex3(:),G1H8(113),ngZl,m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_QA_V(ntryL,G1H16(114),ex3(:),G1H8(114),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_QA_Z(ntryL,G1H16(115),ex3(:),G1H8(115),ngZl,m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_QA_V(ntryL,G1H16(116),ex4(:),G1H8(116),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_QA_V(ntryL,G1H16(117),ex4(:),G1H8(117),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_QA_Z(ntryL,G1H16(118),ex4(:),G1H8(118),ngZl,m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_QA_V(ntryL,G1H16(119),ex4(:),G1H8(119),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_QA_Z(ntryL,G1H16(120),ex4(:),G1H8(120),ngZl,m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_QA_V(ntryL,G1H16(121),ex4(:),G1H8(121),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_QA_Z(ntryL,G1H16(122),ex4(:),G1H8(122),ngZl,m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_QA_Z(ntryL,G1H16(123),ex4(:),G1H8(123),ngZl,m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_QA_W(ntryL,G1H16(124),ex4(:),G1H8(124),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_QA_V(ntryL,G1H16(125),ex4(:),G1H8(125),m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_QA_Z(ntryL,G1H16(126),ex4(:),G1H8(126),ngZl,m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_QA_V(ntryL,G1H16(127),ex4(:),G1H8(127),m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_QA_V(ntryL,G1H16(128),ex4(:),G1H8(128),m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_QA_Z(ntryL,G1H16(129),ex4(:),G1H8(129),ngZl,m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_QA_Z(ntryL,G1H16(130),ex4(:),G1H8(130),ngZl,m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_QA_V(ntryL,G1H16(131),ex4(:),G1H8(131),m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_QA_Z(ntryL,G1H16(132),ex4(:),G1H8(132),ngZl,m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(1),n2h4(1))
  call Hloop_VQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(2),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(3),n2h4(3))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngZl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(4),n2h4(4))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(5),n2h4(5))
  call Hloop_ZQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngZl,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(6),n2h4(6))
  call Hloop_ZQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngZl,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(7),n2h4(7))
  call Hloop_ZQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),ngZl,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(8),n2h4(8))
  call Hloop_VQ_A(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(9),n2h4(9))
  call Hloop_VQ_A(ntryL,G1H8(10),ex2(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(10),n2h4(10))
  call Hloop_VQ_A(ntryL,G1H8(11),ex2(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(11),n2h4(11))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex2(:),G1H4(1),ngZl,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(12),n2h4(12))
  call Hloop_VQ_A(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(13),n2h4(13))
  call Hloop_ZQ_A(ntryL,G1H8(14),ex2(:),G1H4(1),ngZl,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(14),n2h4(14))
  call Hloop_ZQ_A(ntryL,G1H8(15),ex2(:),G1H4(1),ngZl,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(15),n2h4(15))
  call Hloop_ZQ_A(ntryL,G1H8(16),ex2(:),G1H4(1),ngZl,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(16),n2h4(16))
  call Hloop_VQ_A(ntryL,G1H8(17),ex2(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(17),n2h4(17))
  call Hloop_VQ_A(ntryL,G1H8(18),ex2(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(18),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(19),ex2(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(19),n2h4(19))
  call Hloop_ZQ_A(ntryL,G1H8(20),ex2(:),G1H4(1),ngZl,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(20),n2h4(20))
  call Hloop_VQ_A(ntryL,G1H8(21),ex2(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(21),n2h4(21))
  call Hloop_ZQ_A(ntryL,G1H8(22),ex2(:),G1H4(1),ngZl,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(22),n2h4(22))
  call Hloop_ZQ_A(ntryL,G1H8(23),ex2(:),G1H4(1),ngZl,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(23),n2h4(23))
  call Hloop_ZQ_A(ntryL,G1H8(24),ex2(:),G1H4(1),ngZl,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(24),n2h4(24))
  call Hloop_VQ_A(ntryL,G1H8(25),ex1(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(25),n2h4(25))
  call Hloop_VQ_A(ntryL,G1H8(26),ex1(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(26),n2h4(26))
  call Hloop_VQ_A(ntryL,G1H8(27),ex1(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(27),n2h4(27))
  call Hloop_ZQ_A(ntryL,G1H8(28),ex1(:),G1H4(1),ngZl,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(28),n2h4(28))
  call Hloop_VQ_A(ntryL,G1H8(29),ex1(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(29),n2h4(29))
  call Hloop_ZQ_A(ntryL,G1H8(30),ex1(:),G1H4(1),ngZl,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(30),n2h4(30))
  call Hloop_ZQ_A(ntryL,G1H8(31),ex1(:),G1H4(1),ngZl,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(31),n2h4(31))
  call Hloop_ZQ_A(ntryL,G1H8(32),ex1(:),G1H4(1),ngZl,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(32),n2h4(32))
  call Hloop_VA_Q(ntryL,G1H8(33),ex3(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(33),n2h4(33))
  call Hloop_VA_Q(ntryL,G1H8(34),ex3(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(34),n2h4(34))
  call Hloop_VA_Q(ntryL,G1H8(35),ex3(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(35),n2h4(35))
  call Hloop_ZA_Q(ntryL,G1H8(36),ex3(:),G1H4(1),ngZl,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(36),n2h4(36))
  call Hloop_VA_Q(ntryL,G1H8(37),ex3(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(37),n2h4(37))
  call Hloop_ZA_Q(ntryL,G1H8(38),ex3(:),G1H4(1),ngZl,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(38),n2h4(38))
  call Hloop_ZA_Q(ntryL,G1H8(39),ex3(:),G1H4(1),ngZl,m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(39),n2h4(39))
  call Hloop_ZA_Q(ntryL,G1H8(40),ex3(:),G1H4(1),ngZl,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(40),n2h4(40))
  call Hloop_VQ_A(ntryL,G1H8(41),ex1(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(41),n2h4(41))
  call Hloop_VQ_A(ntryL,G1H8(42),ex1(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(42),n2h4(42))
  call Hloop_VQ_A(ntryL,G1H8(43),ex1(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(43),n2h4(43))
  call Hloop_ZQ_A(ntryL,G1H8(44),ex1(:),G1H4(1),ngZl,m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(44),n2h4(44))
  call Hloop_VQ_A(ntryL,G1H8(45),ex1(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(45),n2h4(45))
  call Hloop_ZQ_A(ntryL,G1H8(46),ex1(:),G1H4(1),ngZl,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(46),n2h4(46))
  call Hloop_ZQ_A(ntryL,G1H8(47),ex1(:),G1H4(1),ngZl,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(47),n2h4(47))
  call Hloop_ZQ_A(ntryL,G1H8(48),ex1(:),G1H4(1),ngZl,m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(48),n2h4(48))
  call Hloop_WQ_A(ntryL,G1H8(49),ex1(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(49),n2h4(49))
  call Hloop_VA_Q(ntryL,G1H8(50),ex4(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(50),n2h4(50))
  call Hloop_VA_Q(ntryL,G1H8(51),ex4(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(51),n2h4(51))
  call Hloop_VA_Q(ntryL,G1H8(52),ex4(:),G1H4(1),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(52),n2h4(52))
  call Hloop_ZA_Q(ntryL,G1H8(53),ex4(:),G1H4(1),ngZl,m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(53),n2h4(53))
  call Hloop_VA_Q(ntryL,G1H8(54),ex4(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(54),n2h4(54))
  call Hloop_ZA_Q(ntryL,G1H8(55),ex4(:),G1H4(1),ngZl,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(55),n2h4(55))
  call Hloop_ZA_Q(ntryL,G1H8(56),ex4(:),G1H4(1),ngZl,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(56),n2h4(56))
  call Hloop_ZA_Q(ntryL,G1H8(57),ex4(:),G1H4(1),ngZl,m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(57),n2h4(57))
  call Hloop_VQ_A(ntryL,G1H8(58),ex1(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(58),n2h4(58))
  call Hloop_VQ_A(ntryL,G1H8(59),ex1(:),G1H4(1),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(59),n2h4(59))
  call Hloop_VQ_A(ntryL,G1H8(60),ex1(:),G1H4(1),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(60),n2h4(60))
  call Hloop_ZQ_A(ntryL,G1H8(61),ex1(:),G1H4(1),ngZl,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(61),n2h4(61))
  call Hloop_VQ_A(ntryL,G1H8(62),ex1(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(62),n2h4(62))
  call Hloop_ZQ_A(ntryL,G1H8(63),ex1(:),G1H4(1),ngZl,m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(63),n2h4(63))
  call Hloop_ZQ_A(ntryL,G1H8(64),ex1(:),G1H4(1),ngZl,m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(64),n2h4(64))
  call Hloop_ZQ_A(ntryL,G1H8(65),ex1(:),G1H4(1),ngZl,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(65),n2h4(65))
  call Hloop_WQ_A(ntryL,G1H8(66),ex1(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(66),n2h4(66))
  call Hloop_VA_Q(ntryL,G1H8(67),ex3(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(67),n2h4(67))
  call Hloop_VA_Q(ntryL,G1H8(68),ex3(:),G1H4(1),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(68),n2h4(68))
  call Hloop_ZA_Q(ntryL,G1H8(69),ex3(:),G1H4(1),ngZl,m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(69),n2h4(69))
  call Hloop_VA_Q(ntryL,G1H8(70),ex3(:),G1H4(1),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(70),n2h4(70))
  call Hloop_ZA_Q(ntryL,G1H8(71),ex3(:),G1H4(1),ngZl,m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(71),n2h4(71))
  call Hloop_VA_Q(ntryL,G1H8(72),ex3(:),G1H4(1),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(72),n2h4(72))
  call Hloop_ZA_Q(ntryL,G1H8(73),ex3(:),G1H4(1),ngZl,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(73),n2h4(73))
  call Hloop_ZA_Q(ntryL,G1H8(74),ex3(:),G1H4(1),ngZl,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(74),n2h4(74))
  call Hloop_VA_Q(ntryL,G1H8(75),ex3(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(75),n2h4(75))
  call Hloop_ZA_Q(ntryL,G1H8(76),ex3(:),G1H4(1),ngZl,m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(76),n2h4(76))
  call Hloop_VA_Q(ntryL,G1H8(77),ex3(:),G1H4(1),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(77),n2h4(77))
  call Hloop_VA_Q(ntryL,G1H8(78),ex3(:),G1H4(1),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(78),n2h4(78))
  call Hloop_ZA_Q(ntryL,G1H8(79),ex3(:),G1H4(1),ngZl,m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(79),n2h4(79))
  call Hloop_ZA_Q(ntryL,G1H8(80),ex3(:),G1H4(1),ngZl,m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(80),n2h4(80))
  call Hloop_VA_Q(ntryL,G1H8(81),ex3(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(81),n2h4(81))
  call Hloop_ZA_Q(ntryL,G1H8(82),ex3(:),G1H4(1),ngZl,m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(82),n2h4(82))
  call Hloop_VQ_A(ntryL,G1H8(83),ex2(:),G1H4(1),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(83),n2h4(83))
  call Hloop_VQ_A(ntryL,G1H8(84),ex2(:),G1H4(1),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(84),n2h4(84))
  call Hloop_ZQ_A(ntryL,G1H8(85),ex2(:),G1H4(1),ngZl,m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(85),n2h4(85))
  call Hloop_VQ_A(ntryL,G1H8(86),ex2(:),G1H4(1),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(86),n2h4(86))
  call Hloop_ZQ_A(ntryL,G1H8(87),ex2(:),G1H4(1),ngZl,m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(87),n2h4(87))
  call Hloop_VQ_A(ntryL,G1H8(88),ex2(:),G1H4(1),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(88),n2h4(88))
  call Hloop_ZQ_A(ntryL,G1H8(89),ex2(:),G1H4(1),ngZl,m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(89),n2h4(89))
  call Hloop_ZQ_A(ntryL,G1H8(90),ex2(:),G1H4(1),ngZl,m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(90),n2h4(90))
  call Hloop_WQ_A(ntryL,G1H8(91),ex2(:),G1H4(1),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(91),n2h4(91))
  call Hloop_VA_Q(ntryL,G1H8(92),ex4(:),G1H4(1),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(92),n2h4(92))
  call Hloop_ZA_Q(ntryL,G1H8(93),ex4(:),G1H4(1),ngZl,m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(93),n2h4(93))
  call Hloop_VA_Q(ntryL,G1H8(94),ex4(:),G1H4(1),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(94),n2h4(94))
  call Hloop_VA_Q(ntryL,G1H8(95),ex4(:),G1H4(1),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(95),n2h4(95))
  call Hloop_ZA_Q(ntryL,G1H8(96),ex4(:),G1H4(1),ngZl,m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(96),n2h4(96))
  call Hloop_ZA_Q(ntryL,G1H8(97),ex4(:),G1H4(1),ngZl,m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(97),n2h4(97))
  call Hloop_VA_Q(ntryL,G1H8(98),ex4(:),G1H4(1),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(98),n2h4(98))
  call Hloop_ZA_Q(ntryL,G1H8(99),ex4(:),G1H4(1),ngZl,m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(99),n2h4(99))
  call Hloop_VA_Q(ntryL,G1H8(100),ex4(:),G1H4(1),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(100),n2h4(100))
  call Hloop_VA_Q(ntryL,G1H8(101),ex4(:),G1H4(1),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(101),n2h4(101))
  call Hloop_ZA_Q(ntryL,G1H8(102),ex4(:),G1H4(1),ngZl,m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(102),n2h4(102))
  call Hloop_VA_Q(ntryL,G1H8(103),ex4(:),G1H4(1),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(103),n2h4(103))
  call Hloop_ZA_Q(ntryL,G1H8(104),ex4(:),G1H4(1),ngZl,m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(104),n2h4(104))
  call Hloop_VA_Q(ntryL,G1H8(105),ex4(:),G1H4(1),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(105),n2h4(105))
  call Hloop_ZA_Q(ntryL,G1H8(106),ex4(:),G1H4(1),ngZl,m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(106),n2h4(106))
  call Hloop_ZA_Q(ntryL,G1H8(107),ex4(:),G1H4(1),ngZl,m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(107),n2h4(107))
  call Hloop_VA_Q(ntryL,G1H8(108),ex4(:),G1H4(1),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(108),n2h4(108))
  call Hloop_ZA_Q(ntryL,G1H8(109),ex4(:),G1H4(1),ngZl,m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(109),n2h4(109))
  call Hloop_VA_Q(ntryL,G1H8(110),ex4(:),G1H4(1),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(110),n2h4(110))
  call Hloop_VA_Q(ntryL,G1H8(111),ex4(:),G1H4(1),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(111),n2h4(111))
  call Hloop_ZA_Q(ntryL,G1H8(112),ex4(:),G1H4(1),ngZl,m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(112),n2h4(112))
  call Hloop_ZA_Q(ntryL,G1H8(113),ex4(:),G1H4(1),ngZl,m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(113),n2h4(113))
  call Hloop_VA_Q(ntryL,G1H8(114),ex4(:),G1H4(1),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(114),n2h4(114))
  call Hloop_ZA_Q(ntryL,G1H8(115),ex4(:),G1H4(1),ngZl,m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(115),n2h4(115))
  call Hloop_VQ_A(ntryL,G1H8(116),ex2(:),G1H4(1),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(116),n2h4(116))
  call Hloop_VQ_A(ntryL,G1H8(117),ex2(:),G1H4(1),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(117),n2h4(117))
  call Hloop_ZQ_A(ntryL,G1H8(118),ex2(:),G1H4(1),ngZl,m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(118),n2h4(118))
  call Hloop_VQ_A(ntryL,G1H8(119),ex2(:),G1H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(119),n2h4(119))
  call Hloop_ZQ_A(ntryL,G1H8(120),ex2(:),G1H4(1),ngZl,m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(120),n2h4(120))
  call Hloop_VQ_A(ntryL,G1H8(121),ex2(:),G1H4(1),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(121),n2h4(121))
  call Hloop_ZQ_A(ntryL,G1H8(122),ex2(:),G1H4(1),ngZl,m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(122),n2h4(122))
  call Hloop_ZQ_A(ntryL,G1H8(123),ex2(:),G1H4(1),ngZl,m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(123),n2h4(123))
  call Hloop_WQ_A(ntryL,G1H8(124),ex2(:),G1H4(1),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(124),n2h4(124))
  call Hloop_VA_Q(ntryL,G1H8(125),ex3(:),G1H4(1),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(125),n2h4(125))
  call Hloop_ZA_Q(ntryL,G1H8(126),ex3(:),G1H4(1),ngZl,m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(126),n2h4(126))
  call Hloop_VA_Q(ntryL,G1H8(127),ex3(:),G1H4(1),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(127),n2h4(127))
  call Hloop_VA_Q(ntryL,G1H8(128),ex3(:),G1H4(1),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(128),n2h4(128))
  call Hloop_ZA_Q(ntryL,G1H8(129),ex3(:),G1H4(1),ngZl,m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(129),n2h4(129))
  call Hloop_ZA_Q(ntryL,G1H8(130),ex3(:),G1H4(1),ngZl,m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(130),n2h4(130))
  call Hloop_VA_Q(ntryL,G1H8(131),ex3(:),G1H4(1),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(131),n2h4(131))
  call Hloop_ZA_Q(ntryL,G1H8(132),ex3(:),G1H4(1),ngZl,m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(132),n2h4(132))
  call Hloop_QA_V(ntryL,G2H4(1),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(2),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_Z(ntryL,G2H4(3),ex3(:),G2H2(3),ngZl,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(4),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_Z(ntryL,G2H4(5),ex3(:),G2H2(5),ngZl,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(6),ex3(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_Z(ntryL,G2H4(7),ex3(:),G2H2(7),ngZl,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_Z(ntryL,G2H4(8),ex3(:),G2H2(8),ngZl,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(9),ex4(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_Z(ntryL,G2H4(10),ex4(:),G2H2(10),ngZl,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(11),ex4(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(12),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_Z(ntryL,G2H4(13),ex4(:),G2H2(13),ngZl,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_Z(ntryL,G2H4(14),ex4(:),G2H2(14),ngZl,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(15),ex4(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_Z(ntryL,G2H4(16),ex4(:),G2H2(16),ngZl,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(17),ex3(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(18),ex3(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_Z(ntryL,G2H4(19),ex3(:),G2H2(19),ngZl,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_V(ntryL,G2H4(20),ex3(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_Z(ntryL,G2H4(21),ex3(:),G2H2(21),ngZl,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_V(ntryL,G2H4(22),ex3(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_Z(ntryL,G2H4(23),ex3(:),G2H2(23),ngZl,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_Z(ntryL,G2H4(24),ex3(:),G2H2(24),ngZl,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(25),ex4(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_Z(ntryL,G2H4(26),ex4(:),G2H2(26),ngZl,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_V(ntryL,G2H4(27),ex4(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_V(ntryL,G2H4(28),ex4(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_Z(ntryL,G2H4(29),ex4(:),G2H2(29),ngZl,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_Z(ntryL,G2H4(30),ex4(:),G2H2(30),ngZl,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_V(ntryL,G2H4(31),ex4(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_Z(ntryL,G2H4(32),ex4(:),G2H2(32),ngZl,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_V(ntryL,G2H4(33),ex2(:),G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_V(ntryL,G2H4(34),ex2(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_Z(ntryL,G2H4(35),ex2(:),G2H2(35),ngZl,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_V(ntryL,G2H4(36),ex2(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_Z(ntryL,G2H4(37),ex2(:),G2H2(37),ngZl,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_V(ntryL,G2H4(38),ex2(:),G2H2(38),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_Z(ntryL,G2H4(39),ex2(:),G2H2(39),ngZl,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_Z(ntryL,G2H4(40),ex2(:),G2H2(40),ngZl,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QA_V(ntryL,G2H4(41),ex4(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_QA_Z(ntryL,G2H4(42),ex4(:),G2H2(42),ngZl,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_QA_V(ntryL,G2H4(43),ex4(:),G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_QA_V(ntryL,G2H4(44),ex4(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_QA_Z(ntryL,G2H4(45),ex4(:),G2H2(45),ngZl,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_QA_Z(ntryL,G2H4(46),ex4(:),G2H2(46),ngZl,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_QA_V(ntryL,G2H4(47),ex4(:),G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_QA_Z(ntryL,G2H4(48),ex4(:),G2H2(48),ngZl,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_QA_W(ntryL,G2H4(49),ex4(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AQ_V(ntryL,G2H4(50),ex2(:),G2H2(50),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_AQ_V(ntryL,G2H4(51),ex2(:),G2H2(51),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_Z(ntryL,G2H4(52),ex2(:),G2H2(52),ngZl,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AQ_V(ntryL,G2H4(53),ex2(:),G2H2(53),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_AQ_Z(ntryL,G2H4(54),ex2(:),G2H2(54),ngZl,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AQ_V(ntryL,G2H4(55),ex2(:),G2H2(55),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_AQ_Z(ntryL,G2H4(56),ex2(:),G2H2(56),ngZl,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AQ_Z(ntryL,G2H4(57),ex2(:),G2H2(57),ngZl,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_QA_V(ntryL,G2H4(58),ex3(:),G2H2(58),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_QA_Z(ntryL,G2H4(59),ex3(:),G2H2(59),ngZl,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_QA_V(ntryL,G2H4(60),ex3(:),G2H2(60),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_QA_V(ntryL,G2H4(61),ex3(:),G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_QA_Z(ntryL,G2H4(62),ex3(:),G2H2(62),ngZl,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_QA_Z(ntryL,G2H4(63),ex3(:),G2H2(63),ngZl,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_QA_V(ntryL,G2H4(64),ex3(:),G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QA_Z(ntryL,G2H4(65),ex3(:),G2H2(65),ngZl,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_QA_W(ntryL,G2H4(66),ex3(:),G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_AQ_V(ntryL,G2H4(67),ex1(:),G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_AQ_V(ntryL,G2H4(68),ex1(:),G2H2(68),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_AQ_V(ntryL,G2H4(69),ex1(:),G2H2(69),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_AQ_Z(ntryL,G2H4(70),ex1(:),G2H2(70),ngZl,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_AQ_V(ntryL,G2H4(71),ex1(:),G2H2(71),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_AQ_Z(ntryL,G2H4(72),ex1(:),G2H2(72),ngZl,m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_AQ_Z(ntryL,G2H4(73),ex1(:),G2H2(73),ngZl,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_AQ_Z(ntryL,G2H4(74),ex1(:),G2H2(74),ngZl,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_AQ_V(ntryL,G2H4(75),ex1(:),G2H2(75),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_AQ_V(ntryL,G2H4(76),ex1(:),G2H2(76),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_AQ_V(ntryL,G2H4(77),ex1(:),G2H2(77),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_AQ_Z(ntryL,G2H4(78),ex1(:),G2H2(78),ngZl,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_AQ_V(ntryL,G2H4(79),ex1(:),G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_AQ_Z(ntryL,G2H4(80),ex1(:),G2H2(80),ngZl,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_AQ_Z(ntryL,G2H4(81),ex1(:),G2H2(81),ngZl,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_AQ_Z(ntryL,G2H4(82),ex1(:),G2H2(82),ngZl,m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_QA_V(ntryL,G2H4(83),ex4(:),G2H2(83),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_QA_Z(ntryL,G2H4(84),ex4(:),G2H2(84),ngZl,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QA_V(ntryL,G2H4(85),ex4(:),G2H2(85),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_QA_V(ntryL,G2H4(86),ex4(:),G2H2(86),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_QA_Z(ntryL,G2H4(87),ex4(:),G2H2(87),ngZl,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_QA_Z(ntryL,G2H4(88),ex4(:),G2H2(88),ngZl,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_QA_V(ntryL,G2H4(89),ex4(:),G2H2(89),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_QA_Z(ntryL,G2H4(90),ex4(:),G2H2(90),ngZl,m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_QA_W(ntryL,G2H4(91),ex4(:),G2H2(91),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_AQ_V(ntryL,G2H4(92),ex2(:),G2H2(92),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AQ_V(ntryL,G2H4(93),ex2(:),G2H2(93),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_AQ_Z(ntryL,G2H4(94),ex2(:),G2H2(94),ngZl,m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_AQ_V(ntryL,G2H4(95),ex2(:),G2H2(95),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_AQ_Z(ntryL,G2H4(96),ex2(:),G2H2(96),ngZl,m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_AQ_V(ntryL,G2H4(97),ex2(:),G2H2(97),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_AQ_Z(ntryL,G2H4(98),ex2(:),G2H2(98),ngZl,m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_AQ_Z(ntryL,G2H4(99),ex2(:),G2H2(99),ngZl,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_AQ_V(ntryL,G2H4(100),ex1(:),G2H2(100),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_AQ_V(ntryL,G2H4(101),ex1(:),G2H2(101),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_AQ_V(ntryL,G2H4(102),ex1(:),G2H2(102),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_AQ_Z(ntryL,G2H4(103),ex1(:),G2H2(103),ngZl,m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_AQ_V(ntryL,G2H4(104),ex1(:),G2H2(104),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_AQ_Z(ntryL,G2H4(105),ex1(:),G2H2(105),ngZl,m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_AQ_Z(ntryL,G2H4(106),ex1(:),G2H2(106),ngZl,m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_AQ_Z(ntryL,G2H4(107),ex1(:),G2H2(107),ngZl,m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_AQ_V(ntryL,G2H4(108),ex1(:),G2H2(108),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_AQ_V(ntryL,G2H4(109),ex1(:),G2H2(109),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_AQ_V(ntryL,G2H4(110),ex1(:),G2H2(110),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_AQ_Z(ntryL,G2H4(111),ex1(:),G2H2(111),ngZl,m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_AQ_V(ntryL,G2H4(112),ex1(:),G2H2(112),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_AQ_Z(ntryL,G2H4(113),ex1(:),G2H2(113),ngZl,m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_AQ_Z(ntryL,G2H4(114),ex1(:),G2H2(114),ngZl,m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_AQ_Z(ntryL,G2H4(115),ex1(:),G2H2(115),ngZl,m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_QA_V(ntryL,G2H4(116),ex3(:),G2H2(116),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_QA_Z(ntryL,G2H4(117),ex3(:),G2H2(117),ngZl,m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_QA_V(ntryL,G2H4(118),ex3(:),G2H2(118),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_QA_V(ntryL,G2H4(119),ex3(:),G2H2(119),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_QA_Z(ntryL,G2H4(120),ex3(:),G2H2(120),ngZl,m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_QA_Z(ntryL,G2H4(121),ex3(:),G2H2(121),ngZl,m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_QA_V(ntryL,G2H4(122),ex3(:),G2H2(122),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_QA_Z(ntryL,G2H4(123),ex3(:),G2H2(123),ngZl,m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_QA_W(ntryL,G2H4(124),ex3(:),G2H2(124),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_AQ_V(ntryL,G2H4(125),ex2(:),G2H2(125),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_AQ_V(ntryL,G2H4(126),ex2(:),G2H2(126),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_AQ_Z(ntryL,G2H4(127),ex2(:),G2H2(127),ngZl,m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_AQ_V(ntryL,G2H4(128),ex2(:),G2H2(128),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_AQ_Z(ntryL,G2H4(129),ex2(:),G2H2(129),ngZl,m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_AQ_V(ntryL,G2H4(130),ex2(:),G2H2(130),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_AQ_Z(ntryL,G2H4(131),ex2(:),G2H2(131),ngZl,m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_AQ_Z(ntryL,G2H4(132),ex2(:),G2H2(132),ngZl,m3h2x2(:,132),heltab2x4(:,:,132))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(1),mass5set(:,3),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(1),mass5set(:,2),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(1),mass5set(:,4),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(1),mass5set(:,3),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(1),mass5set(:,4),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(2),mass5set(:,1),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(2),mass5set(:,1),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(2),mass5set(:,2),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(2),mass5set(:,3),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(2),mass5set(:,2),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(2),mass5set(:,3),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(2),mass5set(:,4),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),16,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(2),mass5set(:,4),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),16,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(3),mass5set(:,1),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(3),mass5set(:,2),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),16,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(3),mass5set(:,1),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(3),mass5set(:,3),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(3),mass5set(:,2),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),16,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(3),mass5set(:,4),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),16,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(3),mass5set(:,3),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(3),mass5set(:,4),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),16,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(4),mass5set(:,1),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),16,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(4),mass5set(:,1),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(4),mass5set(:,2),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),16,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(4),mass5set(:,3),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),16,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(4),mass5set(:,2),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),16,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(4),mass5set(:,3),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),16,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(4),mass5set(:,4),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),16,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(4),mass5set(:,4),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),16,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(5),mass5set(:,1),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),16,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(5),mass5set(:,2),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),16,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(5),mass5set(:,1),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),16,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(5),mass5set(:,3),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),16,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(5),mass5set(:,2),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),16,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(5),mass5set(:,4),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),16,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(5),mass5set(:,3),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(230),16,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(5),mass5set(:,4),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(236),16,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(6),mass5set(:,1),  & 
G1H2(241),G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),2)
  call HG1shiftOLR(G1H2(242),16,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(6),mass5set(:,1),  & 
G1H2(247),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(248),16,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(6),mass5set(:,2),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(254),16,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(6),mass5set(:,3),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),2)
  call HG1shiftOLR(G1H2(260),16,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(6),mass5set(:,2),  & 
G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
  call HG1shiftOLR(G1H2(266),16,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(6),mass5set(:,3),  & 
G1H2(271),G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),2)
  call HG1shiftOLR(G1H2(272),16,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(6),mass5set(:,4),  & 
G1H2(277),G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(278),16,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(6),mass5set(:,4),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),2)
  call HG1shiftOLR(G1H2(284),16,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(6),mass5set(:,5),  & 
G1H2(289),G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),2)
  call HG1shiftOLR(G1H2(290),16,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(7),mass5set(:,1),  & 
G1H2(295),G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),2)
  call HG1shiftOLR(G1H2(296),16,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(7),mass5set(:,2),  & 
G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),2)
  call HG1shiftOLR(G1H2(302),16,2)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(7),mass5set(:,1),  & 
G1H2(307),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),16,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(7),mass5set(:,3),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),G1H2(318),2)
  call HG1shiftOLR(G1H2(314),16,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(7),mass5set(:,2),  & 
G1H2(319),G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),2)
  call HG1shiftOLR(G1H2(320),16,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(7),mass5set(:,4),  & 
G1H2(325),G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),2)
  call HG1shiftOLR(G1H2(326),16,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(7),mass5set(:,3),  & 
G1H2(331),G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),2)
  call HG1shiftOLR(G1H2(332),16,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(7),mass5set(:,4),  & 
G1H2(337),G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(338),16,2)
  call Hotf_5pt_reduction(G2H2(58),RedSet_5(8),mass5set(:,1),  & 
G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),G1H2(348),2)
  call HG1shiftOLR(G1H2(344),16,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(8),mass5set(:,1),  & 
G1H2(349),G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),2)
  call HG1shiftOLR(G1H2(350),16,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(8),mass5set(:,2),  & 
G1H2(355),G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),2)
  call HG1shiftOLR(G1H2(356),16,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(8),mass5set(:,3),  & 
G1H2(361),G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),2)
  call HG1shiftOLR(G1H2(362),16,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(8),mass5set(:,2),  & 
G1H2(367),G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(368),16,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(8),mass5set(:,3),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),G1H2(378),2)
  call HG1shiftOLR(G1H2(374),16,2)
  call Hotf_5pt_reduction(G2H2(64),RedSet_5(8),mass5set(:,4),  & 
G1H2(379),G1H2(380),G1H2(381),G1H2(382),G1H2(383),G1H2(384),2)
  call HG1shiftOLR(G1H2(380),16,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(8),mass5set(:,4),  & 
G1H2(385),G1H2(386),G1H2(387),G1H2(388),G1H2(389),G1H2(390),2)
  call HG1shiftOLR(G1H2(386),16,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(8),mass5set(:,5),  & 
G1H2(391),G1H2(392),G1H2(393),G1H2(394),G1H2(395),G1H2(396),2)
  call HG1shiftOLR(G1H2(392),16,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(9),mass5set(:,1),  & 
G1H2(397),G1H2(398),G1H2(399),G1H2(400),G1H2(401),G1H2(402),2)
  call HG1shiftOLR(G1H2(398),16,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(9),mass5set(:,2),  & 
G1H2(403),G1H2(404),G1H2(405),G1H2(406),G1H2(407),G1H2(408),2)
  call HG1shiftOLR(G1H2(404),16,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(9),mass5set(:,3),  & 
G1H2(409),G1H2(410),G1H2(411),G1H2(412),G1H2(413),G1H2(414),2)
  call HG1shiftOLR(G1H2(410),16,2)
  call Hotf_5pt_reduction(G2H2(70),RedSet_5(9),mass5set(:,1),  & 
G1H2(415),G1H2(416),G1H2(417),G1H2(418),G1H2(419),G1H2(420),2)
  call HG1shiftOLR(G1H2(416),16,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(9),mass5set(:,4),  & 
G1H2(421),G1H2(422),G1H2(423),G1H2(424),G1H2(425),G1H2(426),2)
  call HG1shiftOLR(G1H2(422),16,2)
  call Hotf_5pt_reduction(G2H2(72),RedSet_5(9),mass5set(:,2),  & 
G1H2(427),G1H2(428),G1H2(429),G1H2(430),G1H2(431),G1H2(432),2)
  call HG1shiftOLR(G1H2(428),16,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(9),mass5set(:,3),  & 
G1H2(433),G1H2(434),G1H2(435),G1H2(436),G1H2(437),G1H2(438),2)
  call HG1shiftOLR(G1H2(434),16,2)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(9),mass5set(:,4),  & 
G1H2(439),G1H2(440),G1H2(441),G1H2(442),G1H2(443),G1H2(444),2)
  call HG1shiftOLR(G1H2(440),16,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(10),mass5set(:,1),  & 
G1H2(445),G1H2(446),G1H2(447),G1H2(448),G1H2(449),G1H2(450),2)
  call HG1shiftOLR(G1H2(446),16,2)
  call Hotf_5pt_reduction(G2H2(76),RedSet_5(10),mass5set(:,3),  & 
G1H2(451),G1H2(452),G1H2(453),G1H2(454),G1H2(455),G1H2(456),2)
  call HG1shiftOLR(G1H2(452),16,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(10),mass5set(:,2),  & 
G1H2(457),G1H2(458),G1H2(459),G1H2(460),G1H2(461),G1H2(462),2)
  call HG1shiftOLR(G1H2(458),16,2)
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(10),mass5set(:,1),  & 
G1H2(463),G1H2(464),G1H2(465),G1H2(466),G1H2(467),G1H2(468),2)
  call HG1shiftOLR(G1H2(464),16,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(10),mass5set(:,4),  & 
G1H2(469),G1H2(470),G1H2(471),G1H2(472),G1H2(473),G1H2(474),2)
  call HG1shiftOLR(G1H2(470),16,2)
  call Hotf_5pt_reduction(G2H2(80),RedSet_5(10),mass5set(:,3),  & 
G1H2(475),G1H2(476),G1H2(477),G1H2(478),G1H2(479),G1H2(480),2)
  call HG1shiftOLR(G1H2(476),16,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(10),mass5set(:,2),  & 
G1H2(481),G1H2(482),G1H2(483),G1H2(484),G1H2(485),G1H2(486),2)
  call HG1shiftOLR(G1H2(482),16,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(10),mass5set(:,4),  & 
G1H2(487),G1H2(488),G1H2(489),G1H2(490),G1H2(491),G1H2(492),2)
  call HG1shiftOLR(G1H2(488),16,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(11),mass5set(:,1),  & 
G1H2(493),G1H2(494),G1H2(495),G1H2(496),G1H2(497),G1H2(498),2)
  call HG1shiftOLR(G1H2(494),16,2)
  call Hotf_5pt_reduction(G2H2(84),RedSet_5(11),mass5set(:,1),  & 
G1H2(499),G1H2(500),G1H2(501),G1H2(502),G1H2(503),G1H2(504),2)
  call HG1shiftOLR(G1H2(500),16,2)
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(11),mass5set(:,3),  & 
G1H2(505),G1H2(506),G1H2(507),G1H2(508),G1H2(509),G1H2(510),2)
  call HG1shiftOLR(G1H2(506),16,2)
  call Hotf_5pt_reduction(G2H2(86),RedSet_5(11),mass5set(:,2),  & 
G1H2(511),G1H2(512),G1H2(513),G1H2(514),G1H2(515),G1H2(516),2)
  call HG1shiftOLR(G1H2(512),16,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(11),mass5set(:,3),  & 
G1H2(517),G1H2(518),G1H2(519),G1H2(520),G1H2(521),G1H2(522),2)
  call HG1shiftOLR(G1H2(518),16,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(11),mass5set(:,2),  & 
G1H2(523),G1H2(524),G1H2(525),G1H2(526),G1H2(527),G1H2(528),2)
  call HG1shiftOLR(G1H2(524),16,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(11),mass5set(:,4),  & 
G1H2(529),G1H2(530),G1H2(531),G1H2(532),G1H2(533),G1H2(534),2)
  call HG1shiftOLR(G1H2(530),16,2)
  call Hotf_5pt_reduction(G2H2(90),RedSet_5(11),mass5set(:,4),  & 
G1H2(535),G1H2(536),G1H2(537),G1H2(538),G1H2(539),G1H2(540),2)
  call HG1shiftOLR(G1H2(536),16,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(11),mass5set(:,5),  & 
G1H2(541),G1H2(542),G1H2(543),G1H2(544),G1H2(545),G1H2(546),2)
  call HG1shiftOLR(G1H2(542),16,2)
  call Hotf_5pt_reduction(G2H2(92),RedSet_5(12),mass5set(:,1),  & 
G1H2(547),G1H2(548),G1H2(549),G1H2(550),G1H2(551),G1H2(552),2)
  call HG1shiftOLR(G1H2(548),16,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(12),mass5set(:,3),  & 
G1H2(553),G1H2(554),G1H2(555),G1H2(556),G1H2(557),G1H2(558),2)
  call HG1shiftOLR(G1H2(554),16,2)
  call Hotf_5pt_reduction(G2H2(94),RedSet_5(12),mass5set(:,1),  & 
G1H2(559),G1H2(560),G1H2(561),G1H2(562),G1H2(563),G1H2(564),2)
  call HG1shiftOLR(G1H2(560),16,2)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(12),mass5set(:,2),  & 
G1H2(565),G1H2(566),G1H2(567),G1H2(568),G1H2(569),G1H2(570),2)
  call HG1shiftOLR(G1H2(566),16,2)
  call Hotf_5pt_reduction(G2H2(96),RedSet_5(12),mass5set(:,3),  & 
G1H2(571),G1H2(572),G1H2(573),G1H2(574),G1H2(575),G1H2(576),2)
  call HG1shiftOLR(G1H2(572),16,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(12),mass5set(:,4),  & 
G1H2(577),G1H2(578),G1H2(579),G1H2(580),G1H2(581),G1H2(582),2)
  call HG1shiftOLR(G1H2(578),16,2)
  call Hotf_5pt_reduction(G2H2(98),RedSet_5(12),mass5set(:,2),  & 
G1H2(583),G1H2(584),G1H2(585),G1H2(586),G1H2(587),G1H2(588),2)
  call HG1shiftOLR(G1H2(584),16,2)
  call Hotf_5pt_reduction(G2H2(99),RedSet_5(12),mass5set(:,4),  & 
G1H2(589),G1H2(590),G1H2(591),G1H2(592),G1H2(593),G1H2(594),2)
  call HG1shiftOLR(G1H2(590),16,2)
  call Hotf_5pt_reduction(G2H2(100),RedSet_5(13),mass5set(:,1),  & 
G1H2(595),G1H2(596),G1H2(597),G1H2(598),G1H2(599),G1H2(600),2)
  call HG1shiftOLR(G1H2(596),16,2)
  call Hotf_5pt_reduction(G2H2(101),RedSet_5(13),mass5set(:,2),  & 
G1H2(601),G1H2(602),G1H2(603),G1H2(604),G1H2(605),G1H2(606),2)
  call HG1shiftOLR(G1H2(602),16,2)
  call Hotf_5pt_reduction(G2H2(102),RedSet_5(13),mass5set(:,3),  & 
G1H2(607),G1H2(608),G1H2(609),G1H2(610),G1H2(611),G1H2(612),2)
  call HG1shiftOLR(G1H2(608),16,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(13),mass5set(:,1),  & 
G1H2(613),G1H2(614),G1H2(615),G1H2(616),G1H2(617),G1H2(618),2)
  call HG1shiftOLR(G1H2(614),16,2)
  call Hotf_5pt_reduction(G2H2(104),RedSet_5(13),mass5set(:,4),  & 
G1H2(619),G1H2(620),G1H2(621),G1H2(622),G1H2(623),G1H2(624),2)
  call HG1shiftOLR(G1H2(620),16,2)
  call Hotf_5pt_reduction(G2H2(105),RedSet_5(13),mass5set(:,2),  & 
G1H2(625),G1H2(626),G1H2(627),G1H2(628),G1H2(629),G1H2(630),2)
  call HG1shiftOLR(G1H2(626),16,2)
  call Hotf_5pt_reduction(G2H2(106),RedSet_5(13),mass5set(:,3),  & 
G1H2(631),G1H2(632),G1H2(633),G1H2(634),G1H2(635),G1H2(636),2)
  call HG1shiftOLR(G1H2(632),16,2)
  call Hotf_5pt_reduction(G2H2(107),RedSet_5(13),mass5set(:,4),  & 
G1H2(637),G1H2(638),G1H2(639),G1H2(640),G1H2(641),G1H2(642),2)
  call HG1shiftOLR(G1H2(638),16,2)
  call Hotf_5pt_reduction(G2H2(108),RedSet_5(14),mass5set(:,1),  & 
G1H2(643),G1H2(644),G1H2(645),G1H2(646),G1H2(647),G1H2(648),2)
  call HG1shiftOLR(G1H2(644),16,2)
  call Hotf_5pt_reduction(G2H2(109),RedSet_5(14),mass5set(:,3),  & 
G1H2(649),G1H2(650),G1H2(651),G1H2(652),G1H2(653),G1H2(654),2)
  call HG1shiftOLR(G1H2(650),16,2)
  call Hotf_5pt_reduction(G2H2(110),RedSet_5(14),mass5set(:,2),  & 
G1H2(655),G1H2(656),G1H2(657),G1H2(658),G1H2(659),G1H2(660),2)
  call HG1shiftOLR(G1H2(656),16,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(14),mass5set(:,1),  & 
G1H2(661),G1H2(662),G1H2(663),G1H2(664),G1H2(665),G1H2(666),2)
  call HG1shiftOLR(G1H2(662),16,2)
  call Hotf_5pt_reduction(G2H2(112),RedSet_5(14),mass5set(:,4),  & 
G1H2(667),G1H2(668),G1H2(669),G1H2(670),G1H2(671),G1H2(672),2)
  call HG1shiftOLR(G1H2(668),16,2)
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(14),mass5set(:,3),  & 
G1H2(673),G1H2(674),G1H2(675),G1H2(676),G1H2(677),G1H2(678),2)
  call HG1shiftOLR(G1H2(674),16,2)
  call Hotf_5pt_reduction(G2H2(114),RedSet_5(14),mass5set(:,2),  & 
G1H2(679),G1H2(680),G1H2(681),G1H2(682),G1H2(683),G1H2(684),2)
  call HG1shiftOLR(G1H2(680),16,2)
  call Hotf_5pt_reduction(G2H2(115),RedSet_5(14),mass5set(:,4),  & 
G1H2(685),G1H2(686),G1H2(687),G1H2(688),G1H2(689),G1H2(690),2)
  call HG1shiftOLR(G1H2(686),16,2)
  call Hotf_5pt_reduction(G2H2(116),RedSet_5(15),mass5set(:,1),  & 
G1H2(691),G1H2(692),G1H2(693),G1H2(694),G1H2(695),G1H2(696),2)
  call HG1shiftOLR(G1H2(692),16,2)
  call Hotf_5pt_reduction(G2H2(117),RedSet_5(15),mass5set(:,1),  & 
G1H2(697),G1H2(698),G1H2(699),G1H2(700),G1H2(701),G1H2(702),2)
  call HG1shiftOLR(G1H2(698),16,2)
  call Hotf_5pt_reduction(G2H2(118),RedSet_5(15),mass5set(:,3),  & 
G1H2(703),G1H2(704),G1H2(705),G1H2(706),G1H2(707),G1H2(708),2)
  call HG1shiftOLR(G1H2(704),16,2)
  call Hotf_5pt_reduction(G2H2(119),RedSet_5(15),mass5set(:,2),  & 
G1H2(709),G1H2(710),G1H2(711),G1H2(712),G1H2(713),G1H2(714),2)
  call HG1shiftOLR(G1H2(710),16,2)
  call Hotf_5pt_reduction(G2H2(120),RedSet_5(15),mass5set(:,3),  & 
G1H2(715),G1H2(716),G1H2(717),G1H2(718),G1H2(719),G1H2(720),2)
  call HG1shiftOLR(G1H2(716),16,2)
  call Hotf_5pt_reduction(G2H2(121),RedSet_5(15),mass5set(:,2),  & 
G1H2(721),G1H2(722),G1H2(723),G1H2(724),G1H2(725),G1H2(726),2)
  call HG1shiftOLR(G1H2(722),16,2)
  call Hotf_5pt_reduction(G2H2(122),RedSet_5(15),mass5set(:,4),  & 
G1H2(727),G1H2(728),G1H2(729),G1H2(730),G1H2(731),G1H2(732),2)
  call HG1shiftOLR(G1H2(728),16,2)
  call Hotf_5pt_reduction(G2H2(123),RedSet_5(15),mass5set(:,4),  & 
G1H2(733),G1H2(734),G1H2(735),G1H2(736),G1H2(737),G1H2(738),2)
  call HG1shiftOLR(G1H2(734),16,2)
  call Hotf_5pt_reduction(G2H2(124),RedSet_5(15),mass5set(:,5),  & 
G1H2(739),G1H2(740),G1H2(741),G1H2(742),G1H2(743),G1H2(744),2)
  call HG1shiftOLR(G1H2(740),16,2)
  call Hotf_5pt_reduction(G2H2(125),RedSet_5(16),mass5set(:,1),  & 
G1H2(745),G1H2(746),G1H2(747),G1H2(748),G1H2(749),G1H2(750),2)
  call HG1shiftOLR(G1H2(746),16,2)
  call Hotf_5pt_reduction(G2H2(126),RedSet_5(16),mass5set(:,3),  & 
G1H2(751),G1H2(752),G1H2(753),G1H2(754),G1H2(755),G1H2(756),2)
  call HG1shiftOLR(G1H2(752),16,2)
  call Hotf_5pt_reduction(G2H2(127),RedSet_5(16),mass5set(:,1),  & 
G1H2(757),G1H2(758),G1H2(759),G1H2(760),G1H2(761),G1H2(762),2)
  call HG1shiftOLR(G1H2(758),16,2)
  call Hotf_5pt_reduction(G2H2(128),RedSet_5(16),mass5set(:,2),  & 
G1H2(763),G1H2(764),G1H2(765),G1H2(766),G1H2(767),G1H2(768),2)
  call HG1shiftOLR(G1H2(764),16,2)
  call Hotf_5pt_reduction(G2H2(129),RedSet_5(16),mass5set(:,3),  & 
G1H2(769),G1H2(770),G1H2(771),G1H2(772),G1H2(773),G1H2(774),2)
  call HG1shiftOLR(G1H2(770),16,2)
  call Hotf_5pt_reduction(G2H2(130),RedSet_5(16),mass5set(:,4),  & 
G1H2(775),G1H2(776),G1H2(777),G1H2(778),G1H2(779),G1H2(780),2)
  call HG1shiftOLR(G1H2(776),16,2)
  call Hotf_5pt_reduction(G2H2(131),RedSet_5(16),mass5set(:,2),  & 
G1H2(781),G1H2(782),G1H2(783),G1H2(784),G1H2(785),G1H2(786),2)
  call HG1shiftOLR(G1H2(782),16,2)
  call Hotf_5pt_reduction(G2H2(132),RedSet_5(16),mass5set(:,4),  & 
G1H2(787),G1H2(788),G1H2(789),G1H2(790),G1H2(791),G1H2(792),2)
  call HG1shiftOLR(G1H2(788),16,2)
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(1),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(3),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(4),n2h1(4))
  call Hloop_ZQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),ngZd,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(5),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),ngZd,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(6),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(7),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(8),n2h1(8))
  call Hloop_ZQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),ngZd,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(9),n2h1(9))
  call Hloop_ZQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(10),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(11),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(12),n2h1(12))
  call Hloop_ZQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),ngZd,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(13),n2h1(13))
  call Hloop_ZQ_A(ntryL,G1H2(38),ex5(:),G1H1(1),ngZd,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(14),n2h1(14))
  call Hloop_ZQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),ngZd,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(15),n2h1(15))
  call Hloop_ZQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),ngZd,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(16),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(17),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(18),n2h1(18))
  call Hloop_ZQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),ngZd,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(19),n2h1(19))
  call Hloop_ZQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),ngZd,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(20),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(21),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(22),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(23),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(24),n2h1(24))
  call Hloop_ZQ_A(ntryL,G1H2(73),ex5(:),G1H1(1),ngZd,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(25),n2h1(25))
  call Hloop_ZQ_A(ntryL,G1H2(74),ex5(:),G1H1(1),ngZd,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(26),n2h1(26))
  call Hloop_ZQ_A(ntryL,G1H2(79),ex5(:),G1H1(1),ngZd,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(27),n2h1(27))
  call Hloop_ZQ_A(ntryL,G1H2(80),ex5(:),G1H1(1),ngZd,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(28),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(29),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(86),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(30),n2h1(30))
  call Hloop_ZQ_A(ntryL,G1H2(91),ex5(:),G1H1(1),ngZd,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(31),n2h1(31))
  call Hloop_ZQ_A(ntryL,G1H2(92),ex5(:),G1H1(1),ngZd,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(32),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(97),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(33),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(98),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(34),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(103),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(35),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(104),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(36),n2h1(36))
  call Hloop_ZQ_A(ntryL,G1H2(109),ex5(:),G1H1(1),ngZd,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(37),n2h1(37))
  call Hloop_ZQ_A(ntryL,G1H2(110),ex5(:),G1H1(1),ngZd,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(38),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(115),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(39),n2h1(39))
  call Hloop_VQ_A(ntryL,G1H2(116),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(40),n2h1(40))
  call Hloop_ZQ_A(ntryL,G1H2(121),ex5(:),G1H1(1),ngZd,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(41),n2h1(41))
  call Hloop_ZQ_A(ntryL,G1H2(122),ex5(:),G1H1(1),ngZd,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(42),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(127),ex5(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(43),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(128),ex5(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(44),n2h1(44))
  call Hloop_ZQ_A(ntryL,G1H2(133),ex5(:),G1H1(1),ngZd,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(45),n2h1(45))
  call Hloop_ZQ_A(ntryL,G1H2(134),ex5(:),G1H1(1),ngZd,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(46),n2h1(46))
  call Hloop_ZQ_A(ntryL,G1H2(139),ex5(:),G1H1(1),ngZd,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(47),n2h1(47))
  call Hloop_ZQ_A(ntryL,G1H2(140),ex5(:),G1H1(1),ngZd,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(48),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(145),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(49),n2h1(49))
  call Hloop_VQ_A(ntryL,G1H2(146),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(50),n2h1(50))
  call Hloop_ZQ_A(ntryL,G1H2(151),ex5(:),G1H1(1),ngZd,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(51),n2h1(51))
  call Hloop_ZQ_A(ntryL,G1H2(152),ex5(:),G1H1(1),ngZd,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(52),n2h1(52))
  call Hloop_VQ_A(ntryL,G1H2(157),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(53),n2h1(53))
  call Hloop_VQ_A(ntryL,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(54),n2h1(54))
  call Hloop_VQ_A(ntryL,G1H2(163),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(55),n2h1(55))
  call Hloop_VQ_A(ntryL,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(56),n2h1(56))
  call Hloop_ZQ_A(ntryL,G1H2(169),ex5(:),G1H1(1),ngZd,m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(57),n2h1(57))
  call Hloop_ZQ_A(ntryL,G1H2(170),ex5(:),G1H1(1),ngZd,m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(58),n2h1(58))
  call Hloop_ZQ_A(ntryL,G1H2(175),ex5(:),G1H1(1),ngZd,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(59),n2h1(59))
  call Hloop_ZQ_A(ntryL,G1H2(176),ex5(:),G1H1(1),ngZd,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(60),n2h1(60))
  call Hloop_VQ_A(ntryL,G1H2(181),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(61),n2h1(61))
  call Hloop_VQ_A(ntryL,G1H2(182),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(62),n2h1(62))
  call Hloop_ZQ_A(ntryL,G1H2(187),ex5(:),G1H1(1),ngZd,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(63),n2h1(63))
  call Hloop_ZQ_A(ntryL,G1H2(188),ex5(:),G1H1(1),ngZd,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(64),n2h1(64))
  call Hloop_VQ_A(ntryL,G1H2(193),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(65),n2h1(65))
  call Hloop_VQ_A(ntryL,G1H2(194),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(66),n2h1(66))
  call Hloop_VQ_A(ntryL,G1H2(199),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(67),n2h1(67))
  call Hloop_VQ_A(ntryL,G1H2(200),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(68),n2h1(68))
  call Hloop_ZQ_A(ntryL,G1H2(205),ex5(:),G1H1(1),ngZd,m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(69),n2h1(69))
  call Hloop_ZQ_A(ntryL,G1H2(206),ex5(:),G1H1(1),ngZd,m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(70),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H2(211),ex5(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(71),n2h1(71))
  call Hloop_VQ_A(ntryL,G1H2(212),ex5(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(72),n2h1(72))
  call Hloop_ZQ_A(ntryL,G1H2(217),ex5(:),G1H1(1),ngZd,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(73),n2h1(73))
  call Hloop_ZQ_A(ntryL,G1H2(218),ex5(:),G1H1(1),ngZd,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(74),n2h1(74))
  call Hloop_VQ_A(ntryL,G1H2(223),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(75),n2h1(75))
  call Hloop_VQ_A(ntryL,G1H2(224),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(76),n2h1(76))
  call Hloop_ZQ_A(ntryL,G1H2(229),ex5(:),G1H1(1),ngZd,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(77),n2h1(77))
  call Hloop_ZQ_A(ntryL,G1H2(230),ex5(:),G1H1(1),ngZd,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(78),n2h1(78))
  call Hloop_ZQ_A(ntryL,G1H2(235),ex5(:),G1H1(1),ngZd,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(79),n2h1(79))
  call Hloop_ZQ_A(ntryL,G1H2(236),ex5(:),G1H1(1),ngZd,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(80),n2h1(80))
  call Hloop_VQ_A(ntryL,G1H2(241),ex5(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(81),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(242),ex5(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(82),n2h1(82))
  call Hloop_ZQ_A(ntryL,G1H2(247),ex5(:),G1H1(1),ngZd,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(83),n2h1(83))
  call Hloop_ZQ_A(ntryL,G1H2(248),ex5(:),G1H1(1),ngZd,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(84),n2h1(84))
  call Hloop_VQ_A(ntryL,G1H2(253),ex5(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(85),n2h1(85))
  call Hloop_VQ_A(ntryL,G1H2(254),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(86),n2h1(86))
  call Hloop_VQ_A(ntryL,G1H2(259),ex5(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(87),n2h1(87))
  call Hloop_VQ_A(ntryL,G1H2(260),ex5(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(88),n2h1(88))
  call Hloop_ZQ_A(ntryL,G1H2(265),ex5(:),G1H1(1),ngZd,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(89),n2h1(89))
  call Hloop_ZQ_A(ntryL,G1H2(266),ex5(:),G1H1(1),ngZd,m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(90),n2h1(90))
  call Hloop_ZQ_A(ntryL,G1H2(271),ex5(:),G1H1(1),ngZd,m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(91),n2h1(91))
  call Hloop_ZQ_A(ntryL,G1H2(272),ex5(:),G1H1(1),ngZd,m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(92),n2h1(92))
  call Hloop_VQ_A(ntryL,G1H2(277),ex5(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(93),n2h1(93))
  call Hloop_VQ_A(ntryL,G1H2(278),ex5(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(94),n2h1(94))
  call Hloop_ZQ_A(ntryL,G1H2(283),ex5(:),G1H1(1),ngZd,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(95),n2h1(95))
  call Hloop_ZQ_A(ntryL,G1H2(284),ex5(:),G1H1(1),ngZd,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(96),n2h1(96))
  call Hloop_WQ_A(ntryL,G1H2(289),ex5(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(97),n2h1(97))
  call Hloop_WQ_A(ntryL,G1H2(290),ex5(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(98),n2h1(98))
  call Hloop_VQ_A(ntryL,G1H2(295),ex5(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(99),n2h1(99))
  call Hloop_VQ_A(ntryL,G1H2(296),ex5(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(100),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H2(301),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(101),n2h1(101))
  call Hloop_VQ_A(ntryL,G1H2(302),ex5(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(102),n2h1(102))
  call Hloop_ZQ_A(ntryL,G1H2(307),ex5(:),G1H1(1),ngZd,m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(103),n2h1(103))
  call Hloop_ZQ_A(ntryL,G1H2(308),ex5(:),G1H1(1),ngZd,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(104),n2h1(104))
  call Hloop_VQ_A(ntryL,G1H2(313),ex5(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(105),n2h1(105))
  call Hloop_VQ_A(ntryL,G1H2(314),ex5(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(106),n2h1(106))
  call Hloop_ZQ_A(ntryL,G1H2(319),ex5(:),G1H1(1),ngZd,m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(107),n2h1(107))
  call Hloop_ZQ_A(ntryL,G1H2(320),ex5(:),G1H1(1),ngZd,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(108),n2h1(108))
  call Hloop_VQ_A(ntryL,G1H2(325),ex5(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(109),n2h1(109))
  call Hloop_VQ_A(ntryL,G1H2(326),ex5(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(110),n2h1(110))
  call Hloop_ZQ_A(ntryL,G1H2(331),ex5(:),G1H1(1),ngZd,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(111),n2h1(111))
  call Hloop_ZQ_A(ntryL,G1H2(332),ex5(:),G1H1(1),ngZd,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(112),n2h1(112))
  call Hloop_ZQ_A(ntryL,G1H2(337),ex5(:),G1H1(1),ngZd,m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(113),n2h1(113))
  call Hloop_ZQ_A(ntryL,G1H2(338),ex5(:),G1H1(1),ngZd,m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(114),n2h1(114))
  call Hloop_VQ_A(ntryL,G1H2(343),ex5(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(115),n2h1(115))
  call Hloop_VQ_A(ntryL,G1H2(344),ex5(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(116),n2h1(116))
  call Hloop_ZQ_A(ntryL,G1H2(349),ex5(:),G1H1(1),ngZd,m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(117),n2h1(117))
  call Hloop_ZQ_A(ntryL,G1H2(350),ex5(:),G1H1(1),ngZd,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(118),n2h1(118))
  call Hloop_VQ_A(ntryL,G1H2(355),ex5(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(119),n2h1(119))
  call Hloop_VQ_A(ntryL,G1H2(356),ex5(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(120),n2h1(120))
  call Hloop_VQ_A(ntryL,G1H2(361),ex5(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(121),n2h1(121))
  call Hloop_VQ_A(ntryL,G1H2(362),ex5(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(122),n2h1(122))
  call Hloop_ZQ_A(ntryL,G1H2(367),ex5(:),G1H1(1),ngZd,m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(123),n2h1(123))
  call Hloop_ZQ_A(ntryL,G1H2(368),ex5(:),G1H1(1),ngZd,m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(124),n2h1(124))
  call Hloop_ZQ_A(ntryL,G1H2(373),ex5(:),G1H1(1),ngZd,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(125),n2h1(125))
  call Hloop_ZQ_A(ntryL,G1H2(374),ex5(:),G1H1(1),ngZd,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(126),n2h1(126))
  call Hloop_VQ_A(ntryL,G1H2(379),ex5(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(127),n2h1(127))
  call Hloop_VQ_A(ntryL,G1H2(380),ex5(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(128),n2h1(128))
  call Hloop_ZQ_A(ntryL,G1H2(385),ex5(:),G1H1(1),ngZd,m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(129),n2h1(129))
  call Hloop_ZQ_A(ntryL,G1H2(386),ex5(:),G1H1(1),ngZd,m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(130),n2h1(130))
  call Hloop_WQ_A(ntryL,G1H2(391),ex5(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(131),n2h1(131))
  call Hloop_WQ_A(ntryL,G1H2(392),ex5(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(132),n2h1(132))
  call Hloop_VQ_A(ntryL,G1H2(397),ex5(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(133),n2h1(133))
  call Hloop_VQ_A(ntryL,G1H2(398),ex5(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(134),n2h1(134))
  call Hloop_VQ_A(ntryL,G1H2(403),ex5(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(135),n2h1(135))
  call Hloop_VQ_A(ntryL,G1H2(404),ex5(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(136),n2h1(136))
  call Hloop_VQ_A(ntryL,G1H2(409),ex5(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(137),n2h1(137))
  call Hloop_VQ_A(ntryL,G1H2(410),ex5(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(138),n2h1(138))
  call Hloop_ZQ_A(ntryL,G1H2(415),ex5(:),G1H1(1),ngZd,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(139),n2h1(139))
  call Hloop_ZQ_A(ntryL,G1H2(416),ex5(:),G1H1(1),ngZd,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(140),n2h1(140))
  call Hloop_VQ_A(ntryL,G1H2(421),ex5(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(141),n2h1(141))
  call Hloop_VQ_A(ntryL,G1H2(422),ex5(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(142),n2h1(142))
  call Hloop_ZQ_A(ntryL,G1H2(427),ex5(:),G1H1(1),ngZd,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(143),n2h1(143))
  call Hloop_ZQ_A(ntryL,G1H2(428),ex5(:),G1H1(1),ngZd,m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(144),n2h1(144))
  call Hloop_ZQ_A(ntryL,G1H2(433),ex5(:),G1H1(1),ngZd,m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(145),n2h1(145))
  call Hloop_ZQ_A(ntryL,G1H2(434),ex5(:),G1H1(1),ngZd,m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(146),n2h1(146))
  call Hloop_ZQ_A(ntryL,G1H2(439),ex5(:),G1H1(1),ngZd,m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(147),n2h1(147))
  call Hloop_ZQ_A(ntryL,G1H2(440),ex5(:),G1H1(1),ngZd,m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(148),n2h1(148))
  call Hloop_VQ_A(ntryL,G1H2(445),ex5(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(149),n2h1(149))
  call Hloop_VQ_A(ntryL,G1H2(446),ex5(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(150),n2h1(150))
  call Hloop_VQ_A(ntryL,G1H2(451),ex5(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(151),n2h1(151))
  call Hloop_VQ_A(ntryL,G1H2(452),ex5(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(152),n2h1(152))
  call Hloop_VQ_A(ntryL,G1H2(457),ex5(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(153),n2h1(153))
  call Hloop_VQ_A(ntryL,G1H2(458),ex5(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(154),n2h1(154))
  call Hloop_ZQ_A(ntryL,G1H2(463),ex5(:),G1H1(1),ngZd,m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(155),n2h1(155))
  call Hloop_ZQ_A(ntryL,G1H2(464),ex5(:),G1H1(1),ngZd,m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(156),n2h1(156))
  call Hloop_VQ_A(ntryL,G1H2(469),ex5(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(157),n2h1(157))
  call Hloop_VQ_A(ntryL,G1H2(470),ex5(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(158),n2h1(158))
  call Hloop_ZQ_A(ntryL,G1H2(475),ex5(:),G1H1(1),ngZd,m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(159),n2h1(159))
  call Hloop_ZQ_A(ntryL,G1H2(476),ex5(:),G1H1(1),ngZd,m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(160),n2h1(160))
  call Hloop_ZQ_A(ntryL,G1H2(481),ex5(:),G1H1(1),ngZd,m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(161),n2h1(161))
  call Hloop_ZQ_A(ntryL,G1H2(482),ex5(:),G1H1(1),ngZd,m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(162),n2h1(162))
  call Hloop_ZQ_A(ntryL,G1H2(487),ex5(:),G1H1(1),ngZd,m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(163),n2h1(163))
  call Hloop_ZQ_A(ntryL,G1H2(488),ex5(:),G1H1(1),ngZd,m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(164),n2h1(164))
  call Hloop_VQ_A(ntryL,G1H2(493),ex5(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(165),n2h1(165))
  call Hloop_VQ_A(ntryL,G1H2(494),ex5(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(166),n2h1(166))
  call Hloop_ZQ_A(ntryL,G1H2(499),ex5(:),G1H1(1),ngZd,m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(167),n2h1(167))
  call Hloop_ZQ_A(ntryL,G1H2(500),ex5(:),G1H1(1),ngZd,m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(168),n2h1(168))
  call Hloop_VQ_A(ntryL,G1H2(505),ex5(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(169),n2h1(169))
  call Hloop_VQ_A(ntryL,G1H2(506),ex5(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(170),n2h1(170))
  call Hloop_VQ_A(ntryL,G1H2(511),ex5(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(171),n2h1(171))
  call Hloop_VQ_A(ntryL,G1H2(512),ex5(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(172),n2h1(172))
  call Hloop_ZQ_A(ntryL,G1H2(517),ex5(:),G1H1(1),ngZd,m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(173),n2h1(173))
  call Hloop_ZQ_A(ntryL,G1H2(518),ex5(:),G1H1(1),ngZd,m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(174),n2h1(174))
  call Hloop_ZQ_A(ntryL,G1H2(523),ex5(:),G1H1(1),ngZd,m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(175),n2h1(175))
  call Hloop_ZQ_A(ntryL,G1H2(524),ex5(:),G1H1(1),ngZd,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(176),n2h1(176))
  call Hloop_VQ_A(ntryL,G1H2(529),ex5(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(177),n2h1(177))
  call Hloop_VQ_A(ntryL,G1H2(530),ex5(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(178),n2h1(178))
  call Hloop_ZQ_A(ntryL,G1H2(535),ex5(:),G1H1(1),ngZd,m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(179),n2h1(179))
  call Hloop_ZQ_A(ntryL,G1H2(536),ex5(:),G1H1(1),ngZd,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(180),n2h1(180))
  call Hloop_WQ_A(ntryL,G1H2(541),ex5(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(181),n2h1(181))
  call Hloop_WQ_A(ntryL,G1H2(542),ex5(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(182),n2h1(182))
  call Hloop_VQ_A(ntryL,G1H2(547),ex5(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(183),n2h1(183))
  call Hloop_VQ_A(ntryL,G1H2(548),ex5(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(184),n2h1(184))
  call Hloop_VQ_A(ntryL,G1H2(553),ex5(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(185),n2h1(185))
  call Hloop_VQ_A(ntryL,G1H2(554),ex5(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(186),n2h1(186))
  call Hloop_ZQ_A(ntryL,G1H2(559),ex5(:),G1H1(1),ngZd,m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(187),n2h1(187))
  call Hloop_ZQ_A(ntryL,G1H2(560),ex5(:),G1H1(1),ngZd,m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(188),n2h1(188))
  call Hloop_VQ_A(ntryL,G1H2(565),ex5(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(189),n2h1(189))
  call Hloop_VQ_A(ntryL,G1H2(566),ex5(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(190),n2h1(190))
  call Hloop_ZQ_A(ntryL,G1H2(571),ex5(:),G1H1(1),ngZd,m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(191),n2h1(191))
  call Hloop_ZQ_A(ntryL,G1H2(572),ex5(:),G1H1(1),ngZd,m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(192),n2h1(192))
  call Hloop_VQ_A(ntryL,G1H2(577),ex5(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(193),n2h1(193))
  call Hloop_VQ_A(ntryL,G1H2(578),ex5(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(194),n2h1(194))
  call Hloop_ZQ_A(ntryL,G1H2(583),ex5(:),G1H1(1),ngZd,m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(195),n2h1(195))
  call Hloop_ZQ_A(ntryL,G1H2(584),ex5(:),G1H1(1),ngZd,m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(196),n2h1(196))
  call Hloop_ZQ_A(ntryL,G1H2(589),ex5(:),G1H1(1),ngZd,m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(197),n2h1(197))
  call Hloop_ZQ_A(ntryL,G1H2(590),ex5(:),G1H1(1),ngZd,m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(198),n2h1(198))
  call Hloop_VQ_A(ntryL,G1H2(595),ex5(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(199),n2h1(199))
  call Hloop_VQ_A(ntryL,G1H2(596),ex5(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(200),n2h1(200))
  call Hloop_VQ_A(ntryL,G1H2(601),ex5(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(201),n2h1(201))
  call Hloop_VQ_A(ntryL,G1H2(602),ex5(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(202),n2h1(202))
  call Hloop_VQ_A(ntryL,G1H2(607),ex5(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(203),n2h1(203))
  call Hloop_VQ_A(ntryL,G1H2(608),ex5(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(204),n2h1(204))
  call Hloop_ZQ_A(ntryL,G1H2(613),ex5(:),G1H1(1),ngZd,m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(205),n2h1(205))
  call Hloop_ZQ_A(ntryL,G1H2(614),ex5(:),G1H1(1),ngZd,m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(206),n2h1(206))
  call Hloop_VQ_A(ntryL,G1H2(619),ex5(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(207),n2h1(207))
  call Hloop_VQ_A(ntryL,G1H2(620),ex5(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(208),n2h1(208))
  call Hloop_ZQ_A(ntryL,G1H2(625),ex5(:),G1H1(1),ngZd,m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(209),n2h1(209))
  call Hloop_ZQ_A(ntryL,G1H2(626),ex5(:),G1H1(1),ngZd,m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(210),n2h1(210))
  call Hloop_ZQ_A(ntryL,G1H2(631),ex5(:),G1H1(1),ngZd,m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(211),n2h1(211))
  call Hloop_ZQ_A(ntryL,G1H2(632),ex5(:),G1H1(1),ngZd,m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(212),n2h1(212))
  call Hloop_ZQ_A(ntryL,G1H2(637),ex5(:),G1H1(1),ngZd,m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(213),n2h1(213))
  call Hloop_ZQ_A(ntryL,G1H2(638),ex5(:),G1H1(1),ngZd,m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(214),n2h1(214))
  call Hloop_VQ_A(ntryL,G1H2(643),ex5(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(215),n2h1(215))
  call Hloop_VQ_A(ntryL,G1H2(644),ex5(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(216),n2h1(216))
  call Hloop_VQ_A(ntryL,G1H2(649),ex5(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(217),n2h1(217))
  call Hloop_VQ_A(ntryL,G1H2(650),ex5(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(218),n2h1(218))
  call Hloop_VQ_A(ntryL,G1H2(655),ex5(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(219),n2h1(219))
  call Hloop_VQ_A(ntryL,G1H2(656),ex5(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(220),n2h1(220))
  call Hloop_ZQ_A(ntryL,G1H2(661),ex5(:),G1H1(1),ngZd,m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(221),n2h1(221))
  call Hloop_ZQ_A(ntryL,G1H2(662),ex5(:),G1H1(1),ngZd,m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(222),n2h1(222))
  call Hloop_VQ_A(ntryL,G1H2(667),ex5(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(223),n2h1(223))
  call Hloop_VQ_A(ntryL,G1H2(668),ex5(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(224),n2h1(224))
  call Hloop_ZQ_A(ntryL,G1H2(673),ex5(:),G1H1(1),ngZd,m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(225),n2h1(225))
  call Hloop_ZQ_A(ntryL,G1H2(674),ex5(:),G1H1(1),ngZd,m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(226),n2h1(226))
  call Hloop_ZQ_A(ntryL,G1H2(679),ex5(:),G1H1(1),ngZd,m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(227),n2h1(227))
  call Hloop_ZQ_A(ntryL,G1H2(680),ex5(:),G1H1(1),ngZd,m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(228),n2h1(228))
  call Hloop_ZQ_A(ntryL,G1H2(685),ex5(:),G1H1(1),ngZd,m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(229),n2h1(229))
  call Hloop_ZQ_A(ntryL,G1H2(686),ex5(:),G1H1(1),ngZd,m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(230),n2h1(230))
  call Hloop_VQ_A(ntryL,G1H2(691),ex5(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(231),n2h1(231))
  call Hloop_VQ_A(ntryL,G1H2(692),ex5(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(232),n2h1(232))
  call Hloop_ZQ_A(ntryL,G1H2(697),ex5(:),G1H1(1),ngZd,m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(233),n2h1(233))
  call Hloop_ZQ_A(ntryL,G1H2(698),ex5(:),G1H1(1),ngZd,m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(234),n2h1(234))
  call Hloop_VQ_A(ntryL,G1H2(703),ex5(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(235),n2h1(235))
  call Hloop_VQ_A(ntryL,G1H2(704),ex5(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(236),n2h1(236))
  call Hloop_VQ_A(ntryL,G1H2(709),ex5(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(237),n2h1(237))
  call Hloop_VQ_A(ntryL,G1H2(710),ex5(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(238),n2h1(238))
  call Hloop_ZQ_A(ntryL,G1H2(715),ex5(:),G1H1(1),ngZd,m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(239),n2h1(239))
  call Hloop_ZQ_A(ntryL,G1H2(716),ex5(:),G1H1(1),ngZd,m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(240),n2h1(240))
  call Hloop_ZQ_A(ntryL,G1H2(721),ex5(:),G1H1(1),ngZd,m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(241),n2h1(241))
  call Hloop_ZQ_A(ntryL,G1H2(722),ex5(:),G1H1(1),ngZd,m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(242),n2h1(242))
  call Hloop_VQ_A(ntryL,G1H2(727),ex5(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(243),n2h1(243))
  call Hloop_VQ_A(ntryL,G1H2(728),ex5(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(244),n2h1(244))
  call Hloop_ZQ_A(ntryL,G1H2(733),ex5(:),G1H1(1),ngZd,m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(245),n2h1(245))
  call Hloop_ZQ_A(ntryL,G1H2(734),ex5(:),G1H1(1),ngZd,m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(246),n2h1(246))
  call Hloop_WQ_A(ntryL,G1H2(739),ex5(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(247),n2h1(247))
  call Hloop_WQ_A(ntryL,G1H2(740),ex5(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(248),n2h1(248))
  call Hloop_VQ_A(ntryL,G1H2(745),ex5(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(249),n2h1(249))
  call Hloop_VQ_A(ntryL,G1H2(746),ex5(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(250),n2h1(250))
  call Hloop_VQ_A(ntryL,G1H2(751),ex5(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(251),n2h1(251))
  call Hloop_VQ_A(ntryL,G1H2(752),ex5(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(252),n2h1(252))
  call Hloop_ZQ_A(ntryL,G1H2(757),ex5(:),G1H1(1),ngZd,m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(253),n2h1(253))
  call Hloop_ZQ_A(ntryL,G1H2(758),ex5(:),G1H1(1),ngZd,m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(254),n2h1(254))
  call Hloop_VQ_A(ntryL,G1H2(763),ex5(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(255),n2h1(255))
  call Hloop_VQ_A(ntryL,G1H2(764),ex5(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(256),n2h1(256))
  call Hloop_ZQ_A(ntryL,G1H2(769),ex5(:),G1H1(1),ngZd,m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(257),n2h1(257))
  call Hloop_ZQ_A(ntryL,G1H2(770),ex5(:),G1H1(1),ngZd,m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(258),n2h1(258))
  call Hloop_VQ_A(ntryL,G1H2(775),ex5(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(259),n2h1(259))
  call Hloop_VQ_A(ntryL,G1H2(776),ex5(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(260),n2h1(260))
  call Hloop_ZQ_A(ntryL,G1H2(781),ex5(:),G1H1(1),ngZd,m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(261),n2h1(261))
  call Hloop_ZQ_A(ntryL,G1H2(782),ex5(:),G1H1(1),ngZd,m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(262),n2h1(262))
  call Hloop_ZQ_A(ntryL,G1H2(787),ex5(:),G1H1(1),ngZd,m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(263),n2h1(263))
  call Hloop_ZQ_A(ntryL,G1H2(788),ex5(:),G1H1(1),ngZd,m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(264),n2h1(264))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(1),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(1),mass5set(:,4),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(1),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(1),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(2),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(2),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(2),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(2),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(2),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(2),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(2),mass5set(:,4),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(2),mass5set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(3),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(3),mass5set(:,2),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(3),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(3),mass5set(:,3),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(3),mass5set(:,2),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(3),mass5set(:,4),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(3),mass5set(:,3),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(3),mass5set(:,4),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(4),mass5set(:,1),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(4),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(4),mass5set(:,2),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(4),mass5set(:,3),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(4),mass5set(:,2),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(4),mass5set(:,3),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(4),mass5set(:,4),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(4),mass5set(:,4),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(5),mass5set(:,1),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(5),mass5set(:,2),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(5),mass5set(:,1),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(5),mass5set(:,3),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(5),mass5set(:,2),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(5),mass5set(:,4),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(5),mass5set(:,3),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(5),mass5set(:,4),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(6),mass5set(:,1),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(6),mass5set(:,1),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(6),mass5set(:,2),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(6),mass5set(:,3),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),16)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(6),mass5set(:,2),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(6),mass5set(:,3),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(6),mass5set(:,4),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(6),mass5set(:,4),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(6),mass5set(:,5),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),16)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(7),mass5set(:,1),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),16)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(7),mass5set(:,2),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),16)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(7),mass5set(:,1),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),16)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(7),mass5set(:,3),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),16)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(7),mass5set(:,2),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),16)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(7),mass5set(:,4),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),16)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(7),mass5set(:,3),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),16)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(7),mass5set(:,4),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),16)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(8),mass5set(:,1),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),16)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(8),mass5set(:,1),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),16)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(8),mass5set(:,2),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),16)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(8),mass5set(:,3),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),16)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(8),mass5set(:,2),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),16)
  call Hotf_5pt_reduction_last(G2tensor(125),RedSet_5(8),mass5set(:,3),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(8),mass5set(:,4),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),16)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(8),mass5set(:,4),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),16)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(8),mass5set(:,5),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),16)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(9),mass5set(:,1),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),16)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(9),mass5set(:,2),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),16)
  call Hotf_5pt_reduction_last(G2tensor(137),RedSet_5(9),mass5set(:,3),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),16)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(9),mass5set(:,1),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),16)
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(9),mass5set(:,4),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(422),16)
  call Hotf_5pt_reduction_last(G2tensor(143),RedSet_5(9),mass5set(:,2),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(428),16)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(9),mass5set(:,3),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437),G1tensor(438))
  call G_TensorShift(G1tensor(434),16)
  call Hotf_5pt_reduction_last(G2tensor(147),RedSet_5(9),mass5set(:,4),  & 
G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444))
  call G_TensorShift(G1tensor(440),16)
  call Hotf_5pt_reduction_last(G2tensor(149),RedSet_5(10),mass5set(:,1),  & 
G1tensor(445),G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(446),16)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(10),mass5set(:,3),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(452),16)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(10),mass5set(:,2),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(458),16)
  call Hotf_5pt_reduction_last(G2tensor(155),RedSet_5(10),mass5set(:,1),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G1tensor(468))
  call G_TensorShift(G1tensor(464),16)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(10),mass5set(:,4),  & 
G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(470),16)
  call Hotf_5pt_reduction_last(G2tensor(159),RedSet_5(10),mass5set(:,3),  & 
G1tensor(475),G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(476),16)
  call Hotf_5pt_reduction_last(G2tensor(161),RedSet_5(10),mass5set(:,2),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(482),16)
  call Hotf_5pt_reduction_last(G2tensor(163),RedSet_5(10),mass5set(:,4),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(488),16)
  call Hotf_5pt_reduction_last(G2tensor(165),RedSet_5(11),mass5set(:,1),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497),G1tensor(498))
  call G_TensorShift(G1tensor(494),16)
  call Hotf_5pt_reduction_last(G2tensor(167),RedSet_5(11),mass5set(:,1),  & 
G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504))
  call G_TensorShift(G1tensor(500),16)
  call Hotf_5pt_reduction_last(G2tensor(169),RedSet_5(11),mass5set(:,3),  & 
G1tensor(505),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(506),16)
  call Hotf_5pt_reduction_last(G2tensor(171),RedSet_5(11),mass5set(:,2),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(512),16)
  call Hotf_5pt_reduction_last(G2tensor(173),RedSet_5(11),mass5set(:,3),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(518),16)
  call Hotf_5pt_reduction_last(G2tensor(175),RedSet_5(11),mass5set(:,2),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527),G1tensor(528))
  call G_TensorShift(G1tensor(524),16)
  call Hotf_5pt_reduction_last(G2tensor(177),RedSet_5(11),mass5set(:,4),  & 
G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534))
  call G_TensorShift(G1tensor(530),16)
  call Hotf_5pt_reduction_last(G2tensor(179),RedSet_5(11),mass5set(:,4),  & 
G1tensor(535),G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(536),16)
  call Hotf_5pt_reduction_last(G2tensor(181),RedSet_5(11),mass5set(:,5),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(542),16)
  call Hotf_5pt_reduction_last(G2tensor(183),RedSet_5(12),mass5set(:,1),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(548),16)
  call Hotf_5pt_reduction_last(G2tensor(185),RedSet_5(12),mass5set(:,3),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557),G1tensor(558))
  call G_TensorShift(G1tensor(554),16)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(12),mass5set(:,1),  & 
G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564))
  call G_TensorShift(G1tensor(560),16)
  call Hotf_5pt_reduction_last(G2tensor(189),RedSet_5(12),mass5set(:,2),  & 
G1tensor(565),G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(566),16)
  call Hotf_5pt_reduction_last(G2tensor(191),RedSet_5(12),mass5set(:,3),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(572),16)
  call Hotf_5pt_reduction_last(G2tensor(193),RedSet_5(12),mass5set(:,4),  & 
G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581),G1tensor(582))
  call G_TensorShift(G1tensor(578),16)
  call Hotf_5pt_reduction_last(G2tensor(195),RedSet_5(12),mass5set(:,2),  & 
G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586),G1tensor(587),G1tensor(588))
  call G_TensorShift(G1tensor(584),16)
  call Hotf_5pt_reduction_last(G2tensor(197),RedSet_5(12),mass5set(:,4),  & 
G1tensor(589),G1tensor(590),G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594))
  call G_TensorShift(G1tensor(590),16)
  call Hotf_5pt_reduction_last(G2tensor(199),RedSet_5(13),mass5set(:,1),  & 
G1tensor(595),G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(596),16)
  call Hotf_5pt_reduction_last(G2tensor(201),RedSet_5(13),mass5set(:,2),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605),G1tensor(606))
  call G_TensorShift(G1tensor(602),16)
  call Hotf_5pt_reduction_last(G2tensor(203),RedSet_5(13),mass5set(:,3),  & 
G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610),G1tensor(611),G1tensor(612))
  call G_TensorShift(G1tensor(608),16)
  call Hotf_5pt_reduction_last(G2tensor(205),RedSet_5(13),mass5set(:,1),  & 
G1tensor(613),G1tensor(614),G1tensor(615),G1tensor(616),G1tensor(617),G1tensor(618))
  call G_TensorShift(G1tensor(614),16)
  call Hotf_5pt_reduction_last(G2tensor(207),RedSet_5(13),mass5set(:,4),  & 
G1tensor(619),G1tensor(620),G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624))
  call G_TensorShift(G1tensor(620),16)
  call Hotf_5pt_reduction_last(G2tensor(209),RedSet_5(13),mass5set(:,2),  & 
G1tensor(625),G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(626),16)
  call Hotf_5pt_reduction_last(G2tensor(211),RedSet_5(13),mass5set(:,3),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635),G1tensor(636))
  call G_TensorShift(G1tensor(632),16)
  call Hotf_5pt_reduction_last(G2tensor(213),RedSet_5(13),mass5set(:,4),  & 
G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640),G1tensor(641),G1tensor(642))
  call G_TensorShift(G1tensor(638),16)
  call Hotf_5pt_reduction_last(G2tensor(215),RedSet_5(14),mass5set(:,1),  & 
G1tensor(643),G1tensor(644),G1tensor(645),G1tensor(646),G1tensor(647),G1tensor(648))
  call G_TensorShift(G1tensor(644),16)
  call Hotf_5pt_reduction_last(G2tensor(217),RedSet_5(14),mass5set(:,3),  & 
G1tensor(649),G1tensor(650),G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654))
  call G_TensorShift(G1tensor(650),16)
  call Hotf_5pt_reduction_last(G2tensor(219),RedSet_5(14),mass5set(:,2),  & 
G1tensor(655),G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(656),16)
  call Hotf_5pt_reduction_last(G2tensor(221),RedSet_5(14),mass5set(:,1),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665),G1tensor(666))
  call G_TensorShift(G1tensor(662),16)
  call Hotf_5pt_reduction_last(G2tensor(223),RedSet_5(14),mass5set(:,4),  & 
G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670),G1tensor(671),G1tensor(672))
  call G_TensorShift(G1tensor(668),16)
  call Hotf_5pt_reduction_last(G2tensor(225),RedSet_5(14),mass5set(:,3),  & 
G1tensor(673),G1tensor(674),G1tensor(675),G1tensor(676),G1tensor(677),G1tensor(678))
  call G_TensorShift(G1tensor(674),16)
  call Hotf_5pt_reduction_last(G2tensor(227),RedSet_5(14),mass5set(:,2),  & 
G1tensor(679),G1tensor(680),G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684))
  call G_TensorShift(G1tensor(680),16)
  call Hotf_5pt_reduction_last(G2tensor(229),RedSet_5(14),mass5set(:,4),  & 
G1tensor(685),G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(686),16)
  call Hotf_5pt_reduction_last(G2tensor(231),RedSet_5(15),mass5set(:,1),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695),G1tensor(696))
  call G_TensorShift(G1tensor(692),16)
  call Hotf_5pt_reduction_last(G2tensor(233),RedSet_5(15),mass5set(:,1),  & 
G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700),G1tensor(701),G1tensor(702))
  call G_TensorShift(G1tensor(698),16)
  call Hotf_5pt_reduction_last(G2tensor(235),RedSet_5(15),mass5set(:,3),  & 
G1tensor(703),G1tensor(704),G1tensor(705),G1tensor(706),G1tensor(707),G1tensor(708))
  call G_TensorShift(G1tensor(704),16)
  call Hotf_5pt_reduction_last(G2tensor(237),RedSet_5(15),mass5set(:,2),  & 
G1tensor(709),G1tensor(710),G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714))
  call G_TensorShift(G1tensor(710),16)
  call Hotf_5pt_reduction_last(G2tensor(239),RedSet_5(15),mass5set(:,3),  & 
G1tensor(715),G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(716),16)
  call Hotf_5pt_reduction_last(G2tensor(241),RedSet_5(15),mass5set(:,2),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725),G1tensor(726))
  call G_TensorShift(G1tensor(722),16)
  call Hotf_5pt_reduction_last(G2tensor(243),RedSet_5(15),mass5set(:,4),  & 
G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730),G1tensor(731),G1tensor(732))
  call G_TensorShift(G1tensor(728),16)
  call Hotf_5pt_reduction_last(G2tensor(245),RedSet_5(15),mass5set(:,4),  & 
G1tensor(733),G1tensor(734),G1tensor(735),G1tensor(736),G1tensor(737),G1tensor(738))
  call G_TensorShift(G1tensor(734),16)
  call Hotf_5pt_reduction_last(G2tensor(247),RedSet_5(15),mass5set(:,5),  & 
G1tensor(739),G1tensor(740),G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744))
  call G_TensorShift(G1tensor(740),16)
  call Hotf_5pt_reduction_last(G2tensor(249),RedSet_5(16),mass5set(:,1),  & 
G1tensor(745),G1tensor(746),G1tensor(747),G1tensor(748),G1tensor(749),G1tensor(750))
  call G_TensorShift(G1tensor(746),16)
  call Hotf_5pt_reduction_last(G2tensor(251),RedSet_5(16),mass5set(:,3),  & 
G1tensor(751),G1tensor(752),G1tensor(753),G1tensor(754),G1tensor(755),G1tensor(756))
  call G_TensorShift(G1tensor(752),16)
  call Hotf_5pt_reduction_last(G2tensor(253),RedSet_5(16),mass5set(:,1),  & 
G1tensor(757),G1tensor(758),G1tensor(759),G1tensor(760),G1tensor(761),G1tensor(762))
  call G_TensorShift(G1tensor(758),16)
  call Hotf_5pt_reduction_last(G2tensor(255),RedSet_5(16),mass5set(:,2),  & 
G1tensor(763),G1tensor(764),G1tensor(765),G1tensor(766),G1tensor(767),G1tensor(768))
  call G_TensorShift(G1tensor(764),16)
  call Hotf_5pt_reduction_last(G2tensor(257),RedSet_5(16),mass5set(:,3),  & 
G1tensor(769),G1tensor(770),G1tensor(771),G1tensor(772),G1tensor(773),G1tensor(774))
  call G_TensorShift(G1tensor(770),16)
  call Hotf_5pt_reduction_last(G2tensor(259),RedSet_5(16),mass5set(:,4),  & 
G1tensor(775),G1tensor(776),G1tensor(777),G1tensor(778),G1tensor(779),G1tensor(780))
  call G_TensorShift(G1tensor(776),16)
  call Hotf_5pt_reduction_last(G2tensor(261),RedSet_5(16),mass5set(:,2),  & 
G1tensor(781),G1tensor(782),G1tensor(783),G1tensor(784),G1tensor(785),G1tensor(786))
  call G_TensorShift(G1tensor(782),16)
  call Hotf_5pt_reduction_last(G2tensor(263),RedSet_5(16),mass5set(:,4),  & 
G1tensor(787),G1tensor(788),G1tensor(789),G1tensor(790),G1tensor(791),G1tensor(792))
  call G_TensorShift(G1tensor(788),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  call ol_merge_tensors(T1sum(45),[G1tensor(265)])
  call ol_merge_tensors(T1sum(46),[G1tensor(271)])
  call ol_merge_tensors(T1sum(47),[G1tensor(277)])
  call ol_merge_tensors(T1sum(48),[G1tensor(283)])
  call ol_merge_tensors(T1sum(49),[G1tensor(289)])
  call ol_merge_tensors(T1sum(50),[G1tensor(295)])
  call ol_merge_tensors(T1sum(51),[G1tensor(301)])
  call ol_merge_tensors(T1sum(52),[G1tensor(307)])
  call ol_merge_tensors(T1sum(53),[G1tensor(313)])
  call ol_merge_tensors(T1sum(54),[G1tensor(319)])
  call ol_merge_tensors(T1sum(55),[G1tensor(325)])
  call ol_merge_tensors(T1sum(56),[G1tensor(331)])
  call ol_merge_tensors(T1sum(57),[G1tensor(337)])
  call ol_merge_tensors(T1sum(58),[G1tensor(343)])
  call ol_merge_tensors(T1sum(59),[G1tensor(349)])
  call ol_merge_tensors(T1sum(60),[G1tensor(355)])
  call ol_merge_tensors(T1sum(61),[G1tensor(361)])
  call ol_merge_tensors(T1sum(62),[G1tensor(367)])
  call ol_merge_tensors(T1sum(63),[G1tensor(373)])
  call ol_merge_tensors(T1sum(64),[G1tensor(379)])
  call ol_merge_tensors(T1sum(65),[G1tensor(385)])
  call ol_merge_tensors(T1sum(66),[G1tensor(391)])
  call ol_merge_tensors(T1sum(67),[G1tensor(397)])
  call ol_merge_tensors(T1sum(68),[G1tensor(403)])
  call ol_merge_tensors(T1sum(69),[G1tensor(409)])
  call ol_merge_tensors(T1sum(70),[G1tensor(415)])
  call ol_merge_tensors(T1sum(71),[G1tensor(421)])
  call ol_merge_tensors(T1sum(72),[G1tensor(427)])
  call ol_merge_tensors(T1sum(73),[G1tensor(433)])
  call ol_merge_tensors(T1sum(74),[G1tensor(439)])
  call ol_merge_tensors(T1sum(75),[G1tensor(445)])
  call ol_merge_tensors(T1sum(76),[G1tensor(451)])
  call ol_merge_tensors(T1sum(77),[G1tensor(457)])
  call ol_merge_tensors(T1sum(78),[G1tensor(463)])
  call ol_merge_tensors(T1sum(79),[G1tensor(469)])
  call ol_merge_tensors(T1sum(80),[G1tensor(475)])
  call ol_merge_tensors(T1sum(81),[G1tensor(481)])
  call ol_merge_tensors(T1sum(82),[G1tensor(487)])
  call ol_merge_tensors(T1sum(83),[G1tensor(493)])
  call ol_merge_tensors(T1sum(84),[G1tensor(499)])
  call ol_merge_tensors(T1sum(85),[G1tensor(505)])
  call ol_merge_tensors(T1sum(86),[G1tensor(511)])
  call ol_merge_tensors(T1sum(87),[G1tensor(517)])
  call ol_merge_tensors(T1sum(88),[G1tensor(523)])
  call ol_merge_tensors(T1sum(89),[G1tensor(529)])
  call ol_merge_tensors(T1sum(90),[G1tensor(535)])
  call ol_merge_tensors(T1sum(91),[G1tensor(541)])
  call ol_merge_tensors(T1sum(92),[G1tensor(547)])
  call ol_merge_tensors(T1sum(93),[G1tensor(553)])
  call ol_merge_tensors(T1sum(94),[G1tensor(559)])
  call ol_merge_tensors(T1sum(95),[G1tensor(565)])
  call ol_merge_tensors(T1sum(96),[G1tensor(571)])
  call ol_merge_tensors(T1sum(97),[G1tensor(577)])
  call ol_merge_tensors(T1sum(98),[G1tensor(583)])
  call ol_merge_tensors(T1sum(99),[G1tensor(589)])
  call ol_merge_tensors(T1sum(100),[G1tensor(595)])
  call ol_merge_tensors(T1sum(101),[G1tensor(601)])
  call ol_merge_tensors(T1sum(102),[G1tensor(607)])
  call ol_merge_tensors(T1sum(103),[G1tensor(613)])
  call ol_merge_tensors(T1sum(104),[G1tensor(619)])
  call ol_merge_tensors(T1sum(105),[G1tensor(625)])
  call ol_merge_tensors(T1sum(106),[G1tensor(631)])
  call ol_merge_tensors(T1sum(107),[G1tensor(637)])
  call ol_merge_tensors(T1sum(108),[G1tensor(643)])
  call ol_merge_tensors(T1sum(109),[G1tensor(649)])
  call ol_merge_tensors(T1sum(110),[G1tensor(655)])
  call ol_merge_tensors(T1sum(111),[G1tensor(661)])
  call ol_merge_tensors(T1sum(112),[G1tensor(667)])
  call ol_merge_tensors(T1sum(113),[G1tensor(673)])
  call ol_merge_tensors(T1sum(114),[G1tensor(679)])
  call ol_merge_tensors(T1sum(115),[G1tensor(685)])
  call ol_merge_tensors(T1sum(116),[G1tensor(691)])
  call ol_merge_tensors(T1sum(117),[G1tensor(697)])
  call ol_merge_tensors(T1sum(118),[G1tensor(703)])
  call ol_merge_tensors(T1sum(119),[G1tensor(709)])
  call ol_merge_tensors(T1sum(120),[G1tensor(715)])
  call ol_merge_tensors(T1sum(121),[G1tensor(721)])
  call ol_merge_tensors(T1sum(122),[G1tensor(727)])
  call ol_merge_tensors(T1sum(123),[G1tensor(733)])
  call ol_merge_tensors(T1sum(124),[G1tensor(739)])
  call ol_merge_tensors(T1sum(125),[G1tensor(745)])
  call ol_merge_tensors(T1sum(126),[G1tensor(751)])
  call ol_merge_tensors(T1sum(127),[G1tensor(757)])
  call ol_merge_tensors(T1sum(128),[G1tensor(763)])
  call ol_merge_tensors(T1sum(129),[G1tensor(769)])
  call ol_merge_tensors(T1sum(130),[G1tensor(775)])
  call ol_merge_tensors(T1sum(131),[G1tensor(781)])
  call ol_merge_tensors(T1sum(132),[G1tensor(787)])
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,5,16,2,8],[nMB,nMB,0,0,0],5,1,wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,133),heltab2x64(:,:,133))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,5,16,2,8],[nMB,nMB,0,0,nMZ],5,1,wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),ngZd,m3h2x32(:,134),heltab2x64(:,:,134))
  call Hloop_A_Q(ntryL,G0H32(2),32,nMB,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,5,16,2,8],[nMB,nMB,nMZ,0,0],5,1,wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,135),heltab2x64(:,:,135))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMB,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,5,16,2,8],[nMB,nMB,nMZ,0,nMZ],5,1,wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,136),heltab2x64(:,:,136))
  call Hloop_A_Q(ntryL,G0H32(4),32,nMB,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,5,16,2,8],[nMB,nMB,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,137),heltab2x64(:,:,137))
  call Hloop_A_Q(ntryL,G0H32(5),32,nMB,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,5,16,2,8],[nMB,nMB,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,138),heltab2x64(:,:,138))
  call Hloop_A_Q(ntryL,G0H32(6),32,nMB,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,5,16,2,8],[nMB,nMB,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,139),heltab2x64(:,:,139))
  call Hloop_A_Q(ntryL,G0H32(7),32,nMB,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,5,16,2,8],[nMB,nMB,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,140),heltab2x64(:,:,140))
  call Hloop_A_Q(ntryL,G0H32(8),32,nMB,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,5,8,2,16],[nMH,nMZ,0,0,nMB],5,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(9),ngH,m3h2x32(:,141),heltab2x64(:,:,141))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,5,8,2,16],[nMH,nMZ,0,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(10),ngH,m3h2x32(:,142),heltab2x64(:,:,142))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,2,8,16,5],[0,0,0,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,143),heltab2x64(:,:,143))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,2,8,16,5],[0,0,nMZ,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,144),heltab2x64(:,:,144))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,2,8,16,5],[nMZ,0,0,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZd,m3h2x32(:,145),heltab2x64(:,:,145))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,2,8,16,5],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(14),ngZd,m3h2x32(:,146),heltab2x64(:,:,146))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,2,8,16,5],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,147),heltab2x64(:,:,147))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,2,8,16,5],[0,0,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,148),heltab2x64(:,:,148))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,2,8,16,5],[0,0,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,149),heltab2x64(:,:,149))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,2,8,16,5],[nMZ,0,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZd,m3h2x32(:,150),heltab2x64(:,:,150))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,2,8,16,5],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(19),ngZd,m3h2x32(:,151),heltab2x64(:,:,151))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,2,8,16,5],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,152),heltab2x64(:,:,152))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[32,2,8,5,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,153),heltab2x64(:,:,153))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[32,2,8,5,16],[0,0,nMZ,nMH,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,154),heltab2x64(:,:,154))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[32,2,8,5,16],[nMZ,0,nMZ,nMH,nMB],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(23),ngZd,m3h2x32(:,155),heltab2x64(:,:,155))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,2,8,5,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,156),heltab2x64(:,:,156))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,2,8,5,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,157),heltab2x64(:,:,157))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,2,8,5,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,158),heltab2x64(:,:,158))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,5,2,8,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(27),ngPbt,m3h2x32(:,159),heltab2x64(:,:,159))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,5,2,8,16],[nMH,nMZ,0,0,nMB],5,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(28),ngH,m3h2x32(:,160),heltab2x64(:,:,160))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,5,2,8,16],[nMH,nMZ,0,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(29),ngH,m3h2x32(:,161),heltab2x64(:,:,161))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[32,5,2,8,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(30),ngPbt,m3h2x32(:,162),heltab2x64(:,:,162))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,5,2,8,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,163),heltab2x64(:,:,163))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[32,5,2,8,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,164),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,8,2,5,16],[0,0,nMZ,nMH,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,165),heltab2x64(:,:,165))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[32,8,2,5,16],[nMZ,0,nMZ,nMH,nMB],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(34),ngZd,m3h2x32(:,166),heltab2x64(:,:,166))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[32,8,5,2,16],[0,0,0,0,nMB],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,167),heltab2x64(:,:,167))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[32,8,5,2,16],[nMZ,0,0,0,nMB],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(36),ngZd,m3h2x32(:,168),heltab2x64(:,:,168))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[32,8,5,2,16],[0,0,0,nMZ,nMB],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,169),heltab2x64(:,:,169))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[32,8,5,2,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(38),ngZd,m3h2x32(:,170),heltab2x64(:,:,170))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[32,8,5,2,16],[0,0,0,0,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,171),heltab2x64(:,:,171))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[32,8,5,2,16],[nMZ,0,0,0,nMB],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(40),ngZd,m3h2x32(:,172),heltab2x64(:,:,172))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[32,8,5,2,16],[0,0,0,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,173),heltab2x64(:,:,173))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[32,8,5,2,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(42),ngZd,m3h2x32(:,174),heltab2x64(:,:,174))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,2,5,8,16],[0,0,0,0,nMB],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,175),heltab2x64(:,:,175))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[32,2,5,8,16],[0,0,0,nMZ,nMB],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,176),heltab2x64(:,:,176))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[32,2,5,8,16],[nMZ,0,0,0,nMB],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(45),ngZd,m3h2x32(:,177),heltab2x64(:,:,177))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[32,2,5,8,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(46),ngZd,m3h2x32(:,178),heltab2x64(:,:,178))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[32,2,5,8,16],[0,0,0,0,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,179),heltab2x64(:,:,179))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[32,2,5,8,16],[0,0,0,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,180),heltab2x64(:,:,180))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[32,2,5,8,16],[nMZ,0,0,0,nMB],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(49),ngZd,m3h2x32(:,181),heltab2x64(:,:,181))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[32,2,5,8,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(50),ngZd,m3h2x32(:,182),heltab2x64(:,:,182))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,2,5,8,16],[nMW,0,0,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,183),heltab2x64(:,:,183))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[32,6,16,1,8],[nMB,nMB,0,0,0],5,1,wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,184),heltab2x64(:,:,184))
  call Hloop_A_Q(ntryL,G0H32(52),32,nMB,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[32,6,16,1,8],[nMB,nMB,0,0,nMZ],5,1,wf4(:,11))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(53),ngZd,m3h2x32(:,185),heltab2x64(:,:,185))
  call Hloop_A_Q(ntryL,G0H32(53),32,nMB,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[32,6,16,1,8],[nMB,nMB,nMZ,0,0],5,1,wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(54),m3h2x32(:,186),heltab2x64(:,:,186))
  call Hloop_A_Q(ntryL,G0H32(54),32,nMB,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[32,6,16,1,8],[nMB,nMB,nMZ,0,nMZ],5,1,wf4(:,11))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(55),ngZd,m3h2x32(:,187),heltab2x64(:,:,187))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMB,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[32,6,16,1,8],[nMB,nMB,0,0,0],5,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(56),m3h2x32(:,188),heltab2x64(:,:,188))
  call Hloop_A_Q(ntryL,G0H32(56),32,nMB,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,6,16,1,8],[nMB,nMB,0,0,nMZ],5,1,wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(57),ngZd,m3h2x32(:,189),heltab2x64(:,:,189))
  call Hloop_A_Q(ntryL,G0H32(57),32,nMB,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,6,16,1,8],[nMB,nMB,nMZ,0,0],5,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,190),heltab2x64(:,:,190))
  call Hloop_A_Q(ntryL,G0H32(58),32,nMB,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,6,16,1,8],[nMB,nMB,nMZ,0,nMZ],5,1,wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(59),ngZd,m3h2x32(:,191),heltab2x64(:,:,191))
  call Hloop_A_Q(ntryL,G0H32(59),32,nMB,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[32,6,8,1,16],[nMH,nMZ,0,0,nMB],5,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(60),ngH,m3h2x32(:,192),heltab2x64(:,:,192))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[32,6,8,1,16],[nMH,nMZ,0,nMZ,nMB],5,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(61),ngH,m3h2x32(:,193),heltab2x64(:,:,193))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[32,1,8,16,6],[0,0,0,nMB,nMB],5,1,wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(62),m3h2x32(:,194),heltab2x64(:,:,194))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,1,8,16,6],[0,0,nMZ,nMB,nMB],5,1,wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(63),m3h2x32(:,195),heltab2x64(:,:,195))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[32,1,8,16,6],[nMZ,0,0,nMB,nMB],5,1,wf4(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(64),ngZd,m3h2x32(:,196),heltab2x64(:,:,196))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,1,8,16,6],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(65),ngZd,m3h2x32(:,197),heltab2x64(:,:,197))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[32,1,8,16,6],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(66),m3h2x32(:,198),heltab2x64(:,:,198))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,1,8,16,6],[0,0,0,nMB,nMB],5,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(67),m3h2x32(:,199),heltab2x64(:,:,199))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,1,8,16,6],[0,0,nMZ,nMB,nMB],5,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(68),m3h2x32(:,200),heltab2x64(:,:,200))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,1,8,16,6],[nMZ,0,0,nMB,nMB],5,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(69),ngZd,m3h2x32(:,201),heltab2x64(:,:,201))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,1,8,16,6],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(70),ngZd,m3h2x32(:,202),heltab2x64(:,:,202))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,1,8,16,6],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(71),m3h2x32(:,203),heltab2x64(:,:,203))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[32,1,8,6,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(72),m3h2x32(:,204),heltab2x64(:,:,204))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,1,8,6,16],[0,0,nMZ,nMH,nMB],5,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(73),m3h2x32(:,205),heltab2x64(:,:,205))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,1,8,6,16],[nMZ,0,nMZ,nMH,nMB],5,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(74),ngZd,m3h2x32(:,206),heltab2x64(:,:,206))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,1,8,6,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(75),m3h2x32(:,207),heltab2x64(:,:,207))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,1,8,6,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(76),m3h2x32(:,208),heltab2x64(:,:,208))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[32,1,8,6,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,209),heltab2x64(:,:,209))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[32,6,1,8,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,11))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(78),ngPbt,m3h2x32(:,210),heltab2x64(:,:,210))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,6,1,8,16],[nMH,nMZ,0,0,nMB],5,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(79),ngH,m3h2x32(:,211),heltab2x64(:,:,211))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,6,1,8,16],[nMH,nMZ,0,nMZ,nMB],5,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(80),ngH,m3h2x32(:,212),heltab2x64(:,:,212))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,6,1,8,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(81),ngPbt,m3h2x32(:,213),heltab2x64(:,:,213))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,6,1,8,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(82),m3h2x32(:,214),heltab2x64(:,:,214))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,6,1,8,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(83),m3h2x32(:,215),heltab2x64(:,:,215))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,8,1,6,16],[0,0,nMZ,nMH,nMB],5,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(84),m3h2x32(:,216),heltab2x64(:,:,216))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,8,1,6,16],[nMZ,0,nMZ,nMH,nMB],5,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(85),ngZd,m3h2x32(:,217),heltab2x64(:,:,217))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,8,6,1,16],[0,0,0,0,nMB],5,1,wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(86),m3h2x32(:,218),heltab2x64(:,:,218))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[32,8,6,1,16],[nMZ,0,0,0,nMB],5,1,wf4(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(87),ngZd,m3h2x32(:,219),heltab2x64(:,:,219))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[32,8,6,1,16],[0,0,0,nMZ,nMB],5,1,wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(88),m3h2x32(:,220),heltab2x64(:,:,220))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[32,8,6,1,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(89),ngZd,m3h2x32(:,221),heltab2x64(:,:,221))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[32,8,6,1,16],[0,0,0,0,nMB],5,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(90),m3h2x32(:,222),heltab2x64(:,:,222))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,8,6,1,16],[nMZ,0,0,0,nMB],5,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(91),ngZd,m3h2x32(:,223),heltab2x64(:,:,223))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[32,8,6,1,16],[0,0,0,nMZ,nMB],5,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(92),m3h2x32(:,224),heltab2x64(:,:,224))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,8,6,1,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(93),ngZd,m3h2x32(:,225),heltab2x64(:,:,225))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[32,1,6,8,16],[0,0,0,0,nMB],5,1,wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,226),heltab2x64(:,:,226))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,1,6,8,16],[0,0,0,nMZ,nMB],5,1,wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(95),m3h2x32(:,227),heltab2x64(:,:,227))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,1,6,8,16],[nMZ,0,0,0,nMB],5,1,wf4(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(96),ngZd,m3h2x32(:,228),heltab2x64(:,:,228))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,1,6,8,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(97),ngZd,m3h2x32(:,229),heltab2x64(:,:,229))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[32,1,6,8,16],[0,0,0,0,nMB],5,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(98),m3h2x32(:,230),heltab2x64(:,:,230))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[32,1,6,8,16],[0,0,0,nMZ,nMB],5,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(99),m3h2x32(:,231),heltab2x64(:,:,231))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[32,1,6,8,16],[nMZ,0,0,0,nMB],5,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(100),ngZd,m3h2x32(:,232),heltab2x64(:,:,232))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[32,1,6,8,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(101),ngZd,m3h2x32(:,233),heltab2x64(:,:,233))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[32,1,6,8,16],[nMW,0,0,nMW,nMT],5,1,wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(102),m3h2x32(:,234),heltab2x64(:,:,234))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[32,4,2,16,9],[0,0,0,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,235),heltab2x64(:,:,235))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[32,4,2,16,9],[nMZ,0,0,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(104),ngZd,m3h2x32(:,236),heltab2x64(:,:,236))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[32,4,2,16,9],[0,0,nMZ,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(105),m3h2x32(:,237),heltab2x64(:,:,237))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[32,4,2,16,9],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(106),ngZd,m3h2x32(:,238),heltab2x64(:,:,238))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[32,4,2,16,9],[0,0,0,nMB,nMB],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(107),m3h2x32(:,239),heltab2x64(:,:,239))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[32,4,2,16,9],[nMZ,0,0,nMB,nMB],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(108),ngZd,m3h2x32(:,240),heltab2x64(:,:,240))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[32,4,2,16,9],[0,0,nMZ,nMB,nMB],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(109),m3h2x32(:,241),heltab2x64(:,:,241))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[32,4,2,16,9],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(110),ngZd,m3h2x32(:,242),heltab2x64(:,:,242))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[32,9,4,2,16],[nMH,nMZ,0,0,nMB],5,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(111),ngH,m3h2x32(:,243),heltab2x64(:,:,243))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[32,9,4,2,16],[nMH,nMZ,0,nMZ,nMB],5,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(112),ngH,m3h2x32(:,244),heltab2x64(:,:,244))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[32,2,4,16,9],[0,0,0,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,245),heltab2x64(:,:,245))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[32,2,4,16,9],[0,0,nMZ,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(114),m3h2x32(:,246),heltab2x64(:,:,246))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[32,2,4,16,9],[nMZ,0,0,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(115),ngZd,m3h2x32(:,247),heltab2x64(:,:,247))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[32,2,4,16,9],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(116),ngZd,m3h2x32(:,248),heltab2x64(:,:,248))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[32,2,4,16,9],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(117),m3h2x32(:,249),heltab2x64(:,:,249))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[32,2,4,16,9],[0,0,0,nMB,nMB],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(118),m3h2x32(:,250),heltab2x64(:,:,250))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[32,2,4,16,9],[0,0,nMZ,nMB,nMB],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(119),m3h2x32(:,251),heltab2x64(:,:,251))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[32,2,4,16,9],[nMZ,0,0,nMB,nMB],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(120),ngZd,m3h2x32(:,252),heltab2x64(:,:,252))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[32,2,4,16,9],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(121),ngZd,m3h2x32(:,253),heltab2x64(:,:,253))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[32,2,4,16,9],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(122),m3h2x32(:,254),heltab2x64(:,:,254))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[32,2,4,9,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(123),m3h2x32(:,255),heltab2x64(:,:,255))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[32,2,4,9,16],[0,0,nMZ,nMH,nMB],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(124),m3h2x32(:,256),heltab2x64(:,:,256))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[32,2,4,9,16],[nMZ,0,nMZ,nMH,nMB],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(125),ngZd,m3h2x32(:,257),heltab2x64(:,:,257))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[32,2,4,9,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(126),m3h2x32(:,258),heltab2x64(:,:,258))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[32,2,4,9,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(127),m3h2x32(:,259),heltab2x64(:,:,259))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[32,2,4,9,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(128),m3h2x32(:,260),heltab2x64(:,:,260))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[32,9,2,4,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(129),ngPbt,m3h2x32(:,261),heltab2x64(:,:,261))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[32,9,2,4,16],[nMH,nMZ,0,0,nMB],5,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(130),ngH,m3h2x32(:,262),heltab2x64(:,:,262))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[32,9,2,4,16],[nMH,nMZ,0,nMZ,nMB],5,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(131),ngH,m3h2x32(:,263),heltab2x64(:,:,263))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[32,9,2,4,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(132),ngPbt,m3h2x32(:,264),heltab2x64(:,:,264))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[32,9,2,4,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,265),heltab2x64(:,:,265))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[32,9,2,4,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,266),heltab2x64(:,:,266))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[32,4,2,9,16],[0,0,nMZ,nMH,nMB],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,267),heltab2x64(:,:,267))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[32,4,2,9,16],[nMZ,0,nMZ,nMH,nMB],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,268),heltab2x64(:,:,268))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[32,4,9,2,16],[0,0,0,0,nMB],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,269),heltab2x64(:,:,269))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[32,4,9,2,16],[nMZ,0,0,0,nMB],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,270),heltab2x64(:,:,270))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[32,4,9,2,16],[0,0,0,nMZ,nMB],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,271),heltab2x64(:,:,271))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[32,4,9,2,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,272),heltab2x64(:,:,272))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[32,4,9,2,16],[0,0,0,0,nMB],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,273),heltab2x64(:,:,273))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[32,4,9,2,16],[nMZ,0,0,0,nMB],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(53),ngZd,m3h2x32(:,274),heltab2x64(:,:,274))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,4,9,2,16],[0,0,0,nMZ,nMB],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(54),m3h2x32(:,275),heltab2x64(:,:,275))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,4,9,2,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(55),ngZd,m3h2x32(:,276),heltab2x64(:,:,276))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[32,2,9,4,16],[0,0,0,0,nMB],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(56),m3h2x32(:,277),heltab2x64(:,:,277))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[32,2,9,4,16],[0,0,0,nMZ,nMB],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(57),m3h2x32(:,278),heltab2x64(:,:,278))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,2,9,4,16],[nMZ,0,0,0,nMB],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(58),ngZd,m3h2x32(:,279),heltab2x64(:,:,279))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[32,2,9,4,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(59),ngZd,m3h2x32(:,280),heltab2x64(:,:,280))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[32,2,9,4,16],[0,0,0,0,nMB],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(133),m3h2x32(:,281),heltab2x64(:,:,281))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[32,2,9,4,16],[0,0,0,nMZ,nMB],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(134),m3h2x32(:,282),heltab2x64(:,:,282))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[32,2,9,4,16],[nMZ,0,0,0,nMB],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(135),ngZd,m3h2x32(:,283),heltab2x64(:,:,283))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[32,2,9,4,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(136),ngZd,m3h2x32(:,284),heltab2x64(:,:,284))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[32,2,9,4,16],[nMW,0,0,nMW,nMT],5,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(137),m3h2x32(:,285),heltab2x64(:,:,285))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[32,4,1,16,10],[0,0,0,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(138),m3h2x32(:,286),heltab2x64(:,:,286))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[32,4,1,16,10],[nMZ,0,0,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(139),ngZd,m3h2x32(:,287),heltab2x64(:,:,287))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[32,4,1,16,10],[0,0,nMZ,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(140),m3h2x32(:,288),heltab2x64(:,:,288))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[32,4,1,16,10],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(141),ngZd,m3h2x32(:,289),heltab2x64(:,:,289))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[32,4,1,16,10],[0,0,0,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(142),m3h2x32(:,290),heltab2x64(:,:,290))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[32,4,1,16,10],[nMZ,0,0,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(143),ngZd,m3h2x32(:,291),heltab2x64(:,:,291))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[32,4,1,16,10],[0,0,nMZ,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(144),m3h2x32(:,292),heltab2x64(:,:,292))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[32,4,1,16,10],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(145),ngZd,m3h2x32(:,293),heltab2x64(:,:,293))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[32,10,4,1,16],[nMH,nMZ,0,0,nMB],5,1,wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(146),ngH,m3h2x32(:,294),heltab2x64(:,:,294))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[32,10,4,1,16],[nMH,nMZ,0,nMZ,nMB],5,1,wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(147),ngH,m3h2x32(:,295),heltab2x64(:,:,295))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[32,1,4,16,10],[0,0,0,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(148),m3h2x32(:,296),heltab2x64(:,:,296))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[32,1,4,16,10],[0,0,nMZ,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(149),m3h2x32(:,297),heltab2x64(:,:,297))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[32,1,4,16,10],[nMZ,0,0,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(150),ngZd,m3h2x32(:,298),heltab2x64(:,:,298))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[32,1,4,16,10],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(151),ngZd,m3h2x32(:,299),heltab2x64(:,:,299))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[32,1,4,16,10],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(152),m3h2x32(:,300),heltab2x64(:,:,300))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[32,1,4,16,10],[0,0,0,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(153),m3h2x32(:,301),heltab2x64(:,:,301))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[32,1,4,16,10],[0,0,nMZ,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(154),m3h2x32(:,302),heltab2x64(:,:,302))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[32,1,4,16,10],[nMZ,0,0,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(155),ngZd,m3h2x32(:,303),heltab2x64(:,:,303))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[32,1,4,16,10],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(156),ngZd,m3h2x32(:,304),heltab2x64(:,:,304))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[32,1,4,16,10],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(157),m3h2x32(:,305),heltab2x64(:,:,305))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[32,1,4,10,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(158),m3h2x32(:,306),heltab2x64(:,:,306))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[32,1,4,10,16],[0,0,nMZ,nMH,nMB],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(159),m3h2x32(:,307),heltab2x64(:,:,307))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[32,1,4,10,16],[nMZ,0,nMZ,nMH,nMB],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(160),ngZd,m3h2x32(:,308),heltab2x64(:,:,308))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[32,1,4,10,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(161),m3h2x32(:,309),heltab2x64(:,:,309))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[32,1,4,10,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(162),m3h2x32(:,310),heltab2x64(:,:,310))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[32,1,4,10,16],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(163),m3h2x32(:,311),heltab2x64(:,:,311))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[32,10,1,4,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(164),ngPbt,m3h2x32(:,312),heltab2x64(:,:,312))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[32,10,1,4,16],[nMH,nMZ,0,0,nMB],5,1,wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(165),ngH,m3h2x32(:,313),heltab2x64(:,:,313))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[32,10,1,4,16],[nMH,nMZ,0,nMZ,nMB],5,1,wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(166),ngH,m3h2x32(:,314),heltab2x64(:,:,314))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[32,10,1,4,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(167),ngPbt,m3h2x32(:,315),heltab2x64(:,:,315))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[32,10,1,4,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(168),m3h2x32(:,316),heltab2x64(:,:,316))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[32,10,1,4,16],[nMW,nMW,0,nMW,nMT],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(169),m3h2x32(:,317),heltab2x64(:,:,317))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[32,4,1,10,16],[0,0,nMZ,nMH,nMB],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(170),m3h2x32(:,318),heltab2x64(:,:,318))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[32,4,1,10,16],[nMZ,0,nMZ,nMH,nMB],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(171),ngZd,m3h2x32(:,319),heltab2x64(:,:,319))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[32,4,10,1,16],[0,0,0,0,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(172),m3h2x32(:,320),heltab2x64(:,:,320))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[32,4,10,1,16],[nMZ,0,0,0,nMB],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(173),ngZd,m3h2x32(:,321),heltab2x64(:,:,321))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[32,4,10,1,16],[0,0,0,nMZ,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(174),m3h2x32(:,322),heltab2x64(:,:,322))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[32,4,10,1,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(175),ngZd,m3h2x32(:,323),heltab2x64(:,:,323))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[32,4,10,1,16],[0,0,0,0,nMB],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(176),m3h2x32(:,324),heltab2x64(:,:,324))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[32,4,10,1,16],[nMZ,0,0,0,nMB],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(177),ngZd,m3h2x32(:,325),heltab2x64(:,:,325))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[32,4,10,1,16],[0,0,0,nMZ,nMB],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(178),m3h2x32(:,326),heltab2x64(:,:,326))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[32,4,10,1,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(179),ngZd,m3h2x32(:,327),heltab2x64(:,:,327))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[32,1,10,4,16],[0,0,0,0,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(180),m3h2x32(:,328),heltab2x64(:,:,328))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[32,1,10,4,16],[0,0,0,nMZ,nMB],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(181),m3h2x32(:,329),heltab2x64(:,:,329))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[32,1,10,4,16],[nMZ,0,0,0,nMB],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(182),ngZd,m3h2x32(:,330),heltab2x64(:,:,330))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[32,1,10,4,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(183),ngZd,m3h2x32(:,331),heltab2x64(:,:,331))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[32,1,10,4,16],[0,0,0,0,nMB],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(184),m3h2x32(:,332),heltab2x64(:,:,332))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[32,1,10,4,16],[0,0,0,nMZ,nMB],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(185),m3h2x32(:,333),heltab2x64(:,:,333))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[32,1,10,4,16],[nMZ,0,0,0,nMB],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(186),ngZd,m3h2x32(:,334),heltab2x64(:,:,334))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[32,1,10,4,16],[nMZ,0,0,nMZ,nMB],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(187),ngZd,m3h2x32(:,335),heltab2x64(:,:,335))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[32,1,10,4,16],[nMW,0,0,nMW,nMT],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(188),m3h2x32(:,336),heltab2x64(:,:,336))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[48,4,1,2,8],[nMZ,0,0,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,337))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[48,4,1,2,8],[nMZ,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(2),m3h4x16(:,2),heltab2x64(:,:,338))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[48,2,1,4,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(3),m3h4x16(:,3),heltab2x64(:,:,339))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(1),n2h16(133))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[48,2,1,4,8],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(3),m3h4x16(:,4),heltab2x64(:,:,340))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(2),n2h16(134))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[48,2,1,4,8],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(3),m3h4x16(:,5),heltab2x64(:,:,341))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(3),n2h16(135))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[48,2,1,4,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(3),m3h4x16(:,6),heltab2x64(:,:,342))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(4),n2h16(136))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[48,2,1,4,8],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(3),ngZl,m3h4x16(:,7),heltab2x64(:,:,343))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(5),n2h16(137))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[48,2,1,4,8],[0,0,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(3),ngZl,m3h4x16(:,8),heltab2x64(:,:,344))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(6),n2h16(138))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[48,2,1,4,8],[0,nMZ,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(3),ngZl,m3h4x16(:,9),heltab2x64(:,:,345))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(7),n2h16(139))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[48,2,1,4,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(3),ngZl,m3h4x16(:,10),heltab2x64(:,:,346))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(8),n2h16(140))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[48,4,2,1,8],[nMZ,0,0,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(3),m3h4x16(:,11),heltab2x64(:,:,347))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[48,4,2,1,8],[nMZ,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(4),m3h4x16(:,12),heltab2x64(:,:,348))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[48,2,1,8,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,13),heltab2x64(:,:,349))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(9),n2h16(141))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[48,2,1,8,4],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,14),heltab2x64(:,:,350))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(10),n2h16(142))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[48,2,1,8,4],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,15),heltab2x64(:,:,351))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(11),n2h16(143))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[48,2,1,8,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,16),heltab2x64(:,:,352))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(12),n2h16(144))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[48,2,1,8,4],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,17),heltab2x64(:,:,353))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(13),n2h16(145))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[48,2,1,8,4],[0,0,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,18),heltab2x64(:,:,354))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(14),n2h16(146))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[48,2,1,8,4],[0,nMZ,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,19),heltab2x64(:,:,355))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(15),n2h16(147))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[48,2,1,8,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,20),heltab2x64(:,:,356))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(16),n2h16(148))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[48,1,2,4,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,21),heltab2x64(:,:,357))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(17),n2h16(149))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[48,1,2,4,8],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,22),heltab2x64(:,:,358))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(18),n2h16(150))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[48,1,2,4,8],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,23),heltab2x64(:,:,359))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(19),n2h16(151))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[48,1,2,4,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,24),heltab2x64(:,:,360))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(20),n2h16(152))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[48,1,2,4,8],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,25),heltab2x64(:,:,361))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(21),n2h16(153))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[48,1,2,4,8],[0,0,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,26),heltab2x64(:,:,362))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(22),n2h16(154))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[48,1,2,4,8],[0,nMZ,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,27),heltab2x64(:,:,363))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(23),n2h16(155))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[48,1,2,4,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,28),heltab2x64(:,:,364))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(24),n2h16(156))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[48,1,2,8,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,29),heltab2x64(:,:,365))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(25),n2h16(157))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[48,1,2,8,4],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,30),heltab2x64(:,:,366))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(26),n2h16(158))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[48,1,2,8,4],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,31),heltab2x64(:,:,367))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(27),n2h16(159))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[48,1,2,8,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,32),heltab2x64(:,:,368))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(28),n2h16(160))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[48,1,2,8,4],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,33),heltab2x64(:,:,369))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(29),n2h16(161))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[48,1,2,8,4],[0,0,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,34),heltab2x64(:,:,370))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(30),n2h16(162))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[48,1,2,8,4],[0,nMZ,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,35),heltab2x64(:,:,371))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(31),n2h16(163))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[48,1,2,8,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,36),heltab2x64(:,:,372))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(32),n2h16(164))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[48,2,4,1,8],[nMZ,0,0,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(5),m3h4x16(:,37),heltab2x64(:,:,373))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[48,2,4,1,8],[nMZ,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(6),m3h4x16(:,38),heltab2x64(:,:,374))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[48,2,4,1,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(7),m3h4x16(:,39),heltab2x64(:,:,375))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[48,2,4,1,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(8),m3h4x16(:,40),heltab2x64(:,:,376))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(33),n2h16(165))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[48,2,4,1,8],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(8),m3h4x16(:,41),heltab2x64(:,:,377))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(34),n2h16(166))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[48,2,4,1,8],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(8),m3h4x16(:,42),heltab2x64(:,:,378))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(35),n2h16(167))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[48,2,4,1,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(8),m3h4x16(:,43),heltab2x64(:,:,379))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(36),n2h16(168))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[48,2,4,1,8],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(8),ngZl,m3h4x16(:,44),heltab2x64(:,:,380))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(37),n2h16(169))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[48,2,4,1,8],[0,nMZ,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(8),ngZl,m3h4x16(:,45),heltab2x64(:,:,381))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(38),n2h16(170))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[48,2,4,1,8],[0,0,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(8),ngZl,m3h4x16(:,46),heltab2x64(:,:,382))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(39),n2h16(171))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[48,2,4,1,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(8),ngZl,m3h4x16(:,47),heltab2x64(:,:,383))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(40),n2h16(172))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[48,2,4,1,8],[0,nMW,0,nMW,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(8),ngZn,m3h4x16(:,48),heltab2x64(:,:,384))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(41),n2h16(173))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[48,2,4,1,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(42),m3h4x16(:,49),heltab2x64(:,:,385))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[48,2,4,1,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(43),m3h4x16(:,50),heltab2x64(:,:,386))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[48,2,8,1,4],[nMZ,0,0,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(8),m3h4x16(:,51),heltab2x64(:,:,387))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[48,2,8,1,4],[nMZ,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(9),m3h4x16(:,52),heltab2x64(:,:,388))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[48,2,8,1,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(10),m3h4x16(:,53),heltab2x64(:,:,389))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[48,2,8,1,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(11),m3h4x16(:,54),heltab2x64(:,:,390))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(44),n2h16(174))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[48,2,8,1,4],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(11),m3h4x16(:,55),heltab2x64(:,:,391))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(45),n2h16(175))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[48,2,8,1,4],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(11),m3h4x16(:,56),heltab2x64(:,:,392))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(46),n2h16(176))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[48,2,8,1,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(11),m3h4x16(:,57),heltab2x64(:,:,393))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(47),n2h16(177))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[48,2,8,1,4],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(11),ngZl,m3h4x16(:,58),heltab2x64(:,:,394))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(48),n2h16(178))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[48,2,8,1,4],[0,nMZ,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(11),ngZl,m3h4x16(:,59),heltab2x64(:,:,395))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(49),n2h16(179))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[48,2,8,1,4],[0,0,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(11),ngZl,m3h4x16(:,60),heltab2x64(:,:,396))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(50),n2h16(180))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[48,2,8,1,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(11),ngZl,m3h4x16(:,61),heltab2x64(:,:,397))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(51),n2h16(181))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[48,2,8,1,4],[0,nMW,0,nMW,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(11),ngZn,m3h4x16(:,62),heltab2x64(:,:,398))
  call Hloop_A_Q(ntryL,G0H16(11),48,0,G1H16(52),n2h16(182))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[48,2,8,1,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(53),m3h4x16(:,63),heltab2x64(:,:,399))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[48,2,8,1,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(54),m3h4x16(:,64),heltab2x64(:,:,400))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[48,1,4,2,8],[nMZ,0,0,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(11),m3h4x16(:,65),heltab2x64(:,:,401))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[48,1,4,2,8],[nMZ,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(12),m3h4x16(:,66),heltab2x64(:,:,402))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[48,1,4,2,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(13),m3h4x16(:,67),heltab2x64(:,:,403))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[48,1,4,2,8],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(14),m3h4x16(:,68),heltab2x64(:,:,404))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(55),n2h16(183))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[48,1,4,2,8],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(14),m3h4x16(:,69),heltab2x64(:,:,405))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(56),n2h16(184))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[48,1,4,2,8],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(14),m3h4x16(:,70),heltab2x64(:,:,406))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(57),n2h16(185))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[48,1,4,2,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(14),m3h4x16(:,71),heltab2x64(:,:,407))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(58),n2h16(186))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[48,1,4,2,8],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(14),ngZl,m3h4x16(:,72),heltab2x64(:,:,408))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(59),n2h16(187))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[48,1,4,2,8],[0,0,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(14),ngZl,m3h4x16(:,73),heltab2x64(:,:,409))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(60),n2h16(188))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[48,1,4,2,8],[0,nMZ,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(14),ngZl,m3h4x16(:,74),heltab2x64(:,:,410))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(61),n2h16(189))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[48,1,4,2,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(14),ngZl,m3h4x16(:,75),heltab2x64(:,:,411))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(62),n2h16(190))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[48,1,4,2,8],[0,nMW,0,nMW,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(14),ngZn,m3h4x16(:,76),heltab2x64(:,:,412))
  call Hloop_A_Q(ntryL,G0H16(14),48,0,G1H16(63),n2h16(191))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[48,1,4,2,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(64),m3h4x16(:,77),heltab2x64(:,:,413))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[48,1,4,2,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(65),m3h4x16(:,78),heltab2x64(:,:,414))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[48,1,4,8,2],[nMZ,0,0,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(14),m3h4x16(:,79),heltab2x64(:,:,415))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[48,1,4,8,2],[nMZ,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(15),m3h4x16(:,80),heltab2x64(:,:,416))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[48,1,8,2,4],[nMZ,0,0,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(16),m3h4x16(:,81),heltab2x64(:,:,417))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[48,1,8,2,4],[nMZ,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(17),m3h4x16(:,82),heltab2x64(:,:,418))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[48,1,8,2,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(18),m3h4x16(:,83),heltab2x64(:,:,419))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[48,1,8,2,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(19),m3h4x16(:,84),heltab2x64(:,:,420))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(66),n2h16(192))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[48,1,8,2,4],[0,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(19),m3h4x16(:,85),heltab2x64(:,:,421))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(67),n2h16(193))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[48,1,8,2,4],[0,nMZ,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(19),m3h4x16(:,86),heltab2x64(:,:,422))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(68),n2h16(194))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[48,1,8,2,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(19),m3h4x16(:,87),heltab2x64(:,:,423))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(69),n2h16(195))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[48,1,8,2,4],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(19),ngZl,m3h4x16(:,88),heltab2x64(:,:,424))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(70),n2h16(196))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[48,1,8,2,4],[0,0,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(19),ngZl,m3h4x16(:,89),heltab2x64(:,:,425))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(71),n2h16(197))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[48,1,8,2,4],[0,nMZ,0,0,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(19),ngZl,m3h4x16(:,90),heltab2x64(:,:,426))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(72),n2h16(198))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[48,1,8,2,4],[0,nMZ,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(19),ngZl,m3h4x16(:,91),heltab2x64(:,:,427))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(73),n2h16(199))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[48,1,8,2,4],[0,nMW,0,nMW,0],5,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(19),ngZn,m3h4x16(:,92),heltab2x64(:,:,428))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(74),n2h16(200))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[48,1,8,2,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(75),m3h4x16(:,93),heltab2x64(:,:,429))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[48,1,8,2,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(76),m3h4x16(:,94),heltab2x64(:,:,430))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[48,1,8,4,2],[nMZ,0,0,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(19),m3h4x16(:,95),heltab2x64(:,:,431))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[48,1,8,4,2],[nMZ,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(20),m3h4x16(:,96),heltab2x64(:,:,432))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(21),[G1H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(22),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(43),[G1H16(42),G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(39),[G1H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(40),[G1H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(54),[G1H16(53),G0H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(48),[G1H16(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(50),[G1H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(51),[G1H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(65),[G1H16(64),G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(59),[G1H16(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(61),[G1H16(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(62),[G1H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(76),[G1H16(75),G0H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(70),[G1H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(71),[G1H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(72),[G1H16(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(73),[G1H16(69)])
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,4),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G1H8(1),37,nMB,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,4),G1H8(2),m3h4x8(:,2),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G1H8(2),37,nMB,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,4),G1H8(3),m3h4x8(:,3),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G1H8(3),37,nMB,G2H8(3),n2h8(3))
  call Hloop_AV_Q(ntryL,G1H32(4),wf4(:,4),G1H8(4),m3h4x8(:,4),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G1H8(4),37,nMB,G2H8(4),n2h8(4))
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,1),G1H8(5),ngZd,m3h4x8(:,5),heltab2x32(:,:,137))
  call Hloop_A_Q(ntryL,G1H8(5),37,nMB,G2H8(5),n2h8(5))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,1),G1H8(6),ngZd,m3h4x8(:,6),heltab2x32(:,:,138))
  call Hloop_A_Q(ntryL,G1H8(6),37,nMB,G2H8(6),n2h8(6))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,1),G1H8(7),ngZd,m3h4x8(:,7),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G1H8(7),37,nMB,G2H8(7),n2h8(7))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,1),G1H8(8),ngZd,m3h4x8(:,8),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G1H8(8),37,nMB,G2H8(8),n2h8(8))
  call Hloop_SV_V(ntryL,G0H32(9),wf4(:,1),G0H8(1),m3h4x8(:,9),heltab2x32(:,:,141))
  call Hloop_SV_V(ntryL,G0H32(10),wf4(:,1),G0H8(2),m3h4x8(:,10),heltab2x32(:,:,142))
  call Hloop_VQ_A(ntryL,G0H32(11),ex2(:),G0H16(7),m3h2x16(:,133),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(77),n2h16(201))
  call Hloop_VQ_A(ntryL,G0H32(12),ex2(:),G0H16(10),m3h2x16(:,134),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(78),n2h16(202))
  call Hloop_ZQ_A(ntryL,G0H32(13),ex2(:),G0H16(13),ngZl,m3h2x16(:,135),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(79),n2h16(203))
  call Hloop_ZQ_A(ntryL,G0H32(14),ex2(:),G0H16(18),ngZl,m3h2x16(:,136),heltab2x32(:,:,146))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(80),n2h16(204))
  call Hloop_WQ_A(ntryL,G0H32(15),ex2(:),G0H16(7),m3h2x16(:,137),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(81),n2h16(205))
  call Hloop_VQ_A(ntryL,G0H32(16),ex2(:),G0H16(10),m3h2x16(:,138),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(82),n2h16(206))
  call Hloop_VQ_A(ntryL,G0H32(17),ex2(:),G0H16(13),m3h2x16(:,139),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(83),n2h16(207))
  call Hloop_ZQ_A(ntryL,G0H32(18),ex2(:),G0H16(18),ngZl,m3h2x16(:,140),heltab2x32(:,:,150))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(84),n2h16(208))
  call Hloop_ZQ_A(ntryL,G0H32(19),ex2(:),G0H16(7),ngZl,m3h2x16(:,141),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(85),n2h16(209))
  call Hloop_WQ_A(ntryL,G0H32(20),ex2(:),G0H16(10),m3h2x16(:,142),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(86),n2h16(210))
  call Hloop_WQ_A(ntryL,G0H32(21),ex2(:),G0H16(13),m3h2x16(:,143),heltab2x32(:,:,153))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(87),n2h16(211))
  call Hloop_VQ_A(ntryL,G0H32(22),ex2(:),G0H16(18),m3h2x16(:,144),heltab2x32(:,:,154))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(88),n2h16(212))
  call Hloop_ZQ_A(ntryL,G0H32(23),ex2(:),G0H16(7),ngZl,m3h2x16(:,145),heltab2x32(:,:,155))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(89),n2h16(213))
  call Hloop_WQ_A(ntryL,G0H32(24),ex2(:),G0H16(10),m3h2x16(:,146),heltab2x32(:,:,156))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(90),n2h16(214))
  call Hloop_WQ_A(ntryL,G0H32(25),ex2(:),G0H16(13),m3h2x16(:,147),heltab2x32(:,:,157))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(91),n2h16(215))
  call Hloop_WQ_A(ntryL,G0H32(26),ex2(:),G0H16(18),m3h2x16(:,148),heltab2x32(:,:,158))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(92),n2h16(216))
  call Hloop_SV_V(ntryL,G0H32(27),wf4(:,4),G0H8(3),m3h4x8(:,11),heltab2x32(:,:,159))
  call Hloop_SV_V(ntryL,G0H32(28),wf4(:,1),G0H8(4),m3h4x8(:,12),heltab2x32(:,:,160))
  call Hloop_SV_V(ntryL,G0H32(29),wf4(:,1),G0H8(5),m3h4x8(:,13),heltab2x32(:,:,161))
  call Hloop_SV_V(ntryL,G0H32(30),wf4(:,1),G0H8(6),m3h4x8(:,14),heltab2x32(:,:,162))
  call Hloop_UW_V(ntryL,G0H32(31),32,wf4(:,4),5,G1H8(9),m3h4x8(:,15),heltab2x32(:,:,163))
  call Hloop_UW_V(ntryL,G0H32(32),32,wf4(:,1),5,G1H8(10),m3h4x8(:,16),heltab2x32(:,:,164))
  call Hloop_VA_Q(ntryL,G0H32(33),ex4(:),G0H16(7),m3h2x16(:,149),heltab2x32(:,:,165))
  call Hloop_A_Q(ntryL,G0H16(7),40,0,G1H16(93),n2h16(217))
  call Hloop_ZA_Q(ntryL,G0H32(34),ex4(:),G0H16(10),ngZl,m3h2x16(:,150),heltab2x32(:,:,166))
  call Hloop_A_Q(ntryL,G0H16(10),40,0,G1H16(94),n2h16(218))
  call Hloop_VA_Q(ntryL,G0H32(35),ex4(:),G0H16(13),m3h2x16(:,151),heltab2x32(:,:,167))
  call Hloop_A_Q(ntryL,G0H16(13),40,0,G1H16(95),n2h16(219))
  call Hloop_ZA_Q(ntryL,G0H32(36),ex4(:),G0H16(18),ngZl,m3h2x16(:,152),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G0H16(18),40,0,G1H16(96),n2h16(220))
  call Hloop_VA_Q(ntryL,G0H32(37),ex4(:),G0H16(7),m3h2x16(:,153),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G0H16(7),40,0,G1H16(97),n2h16(221))
  call Hloop_ZA_Q(ntryL,G0H32(38),ex4(:),G0H16(10),ngZl,m3h2x16(:,154),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G0H16(10),40,0,G1H16(98),n2h16(222))
  call Hloop_VA_Q(ntryL,G0H32(39),ex4(:),G0H16(13),m3h2x16(:,155),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G0H16(13),40,0,G1H16(99),n2h16(223))
  call Hloop_ZA_Q(ntryL,G0H32(40),ex4(:),G0H16(18),ngZl,m3h2x16(:,156),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G0H16(18),40,0,G1H16(100),n2h16(224))
  call Hloop_VA_Q(ntryL,G0H32(41),ex4(:),G0H16(7),m3h2x16(:,157),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G0H16(7),40,0,G1H16(101),n2h16(225))
  call Hloop_ZA_Q(ntryL,G0H32(42),ex4(:),G0H16(10),ngZl,m3h2x16(:,158),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G0H16(10),40,0,G1H16(102),n2h16(226))
  call Hloop_VQ_A(ntryL,G0H32(43),ex2(:),G0H16(13),m3h2x16(:,159),heltab2x32(:,:,175))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(103),n2h16(227))
  call Hloop_VQ_A(ntryL,G0H32(44),ex2(:),G0H16(18),m3h2x16(:,160),heltab2x32(:,:,176))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(104),n2h16(228))
  call Hloop_ZQ_A(ntryL,G0H32(45),ex2(:),G0H16(7),ngZl,m3h2x16(:,161),heltab2x32(:,:,177))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(105),n2h16(229))
  call Hloop_ZQ_A(ntryL,G0H32(46),ex2(:),G0H16(10),ngZl,m3h2x16(:,162),heltab2x32(:,:,178))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(106),n2h16(230))
  call Hloop_VQ_A(ntryL,G0H32(47),ex2(:),G0H16(13),m3h2x16(:,163),heltab2x32(:,:,179))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(107),n2h16(231))
  call Hloop_VQ_A(ntryL,G0H32(48),ex2(:),G0H16(18),m3h2x16(:,164),heltab2x32(:,:,180))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(108),n2h16(232))
  call Hloop_ZQ_A(ntryL,G0H32(49),ex2(:),G0H16(7),ngZl,m3h2x16(:,165),heltab2x32(:,:,181))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(109),n2h16(233))
  call Hloop_ZQ_A(ntryL,G0H32(50),ex2(:),G0H16(10),ngZl,m3h2x16(:,166),heltab2x32(:,:,182))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(110),n2h16(234))
  call Hloop_WQ_A(ntryL,G0H32(51),ex2(:),G0H16(13),m3h2x16(:,167),heltab2x32(:,:,183))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(111),n2h16(235))
  call Hloop_AV_Q(ntryL,G1H32(9),wf4(:,11),G1H8(11),m3h4x8(:,17),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G1H8(11),38,nMB,G2H8(9),n2h8(9))
  call Hloop_AV_Q(ntryL,G1H32(10),wf4(:,11),G1H8(12),m3h4x8(:,18),heltab2x32(:,:,185))
  call Hloop_A_Q(ntryL,G1H8(12),38,nMB,G2H8(10),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H32(11),wf4(:,11),G1H8(13),m3h4x8(:,19),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G1H8(13),38,nMB,G2H8(11),n2h8(11))
  call Hloop_AV_Q(ntryL,G1H32(12),wf4(:,11),G1H8(14),m3h4x8(:,20),heltab2x32(:,:,187))
  call Hloop_A_Q(ntryL,G1H8(14),38,nMB,G2H8(12),n2h8(12))
  call Hloop_AZ_Q(ntryL,G1H32(13),wf4(:,9),G1H8(15),ngZd,m3h4x8(:,21),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G1H8(15),38,nMB,G2H8(13),n2h8(13))
  call Hloop_AZ_Q(ntryL,G1H32(14),wf4(:,9),G1H8(16),ngZd,m3h4x8(:,22),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G1H8(16),38,nMB,G2H8(14),n2h8(14))
  call Hloop_AZ_Q(ntryL,G1H32(15),wf4(:,9),G1H8(17),ngZd,m3h4x8(:,23),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G1H8(17),38,nMB,G2H8(15),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H32(16),wf4(:,9),G1H8(18),ngZd,m3h4x8(:,24),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G1H8(18),38,nMB,G2H8(16),n2h8(16))
  call Hloop_SV_V(ntryL,G0H32(60),wf4(:,9),G0H8(7),m3h4x8(:,25),heltab2x32(:,:,192))
  call Hloop_SV_V(ntryL,G0H32(61),wf4(:,9),G0H8(8),m3h4x8(:,26),heltab2x32(:,:,193))
  call Hloop_VQ_A(ntryL,G0H32(62),ex1(:),G0H16(18),m3h2x16(:,168),heltab2x32(:,:,194))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(112),n2h16(236))
  call Hloop_VQ_A(ntryL,G0H32(63),ex1(:),G0H16(7),m3h2x16(:,169),heltab2x32(:,:,195))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(113),n2h16(237))
  call Hloop_ZQ_A(ntryL,G0H32(64),ex1(:),G0H16(10),ngZl,m3h2x16(:,170),heltab2x32(:,:,196))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(114),n2h16(238))
  call Hloop_ZQ_A(ntryL,G0H32(65),ex1(:),G0H16(13),ngZl,m3h2x16(:,171),heltab2x32(:,:,197))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(115),n2h16(239))
  call Hloop_WQ_A(ntryL,G0H32(66),ex1(:),G0H16(18),m3h2x16(:,172),heltab2x32(:,:,198))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(116),n2h16(240))
  call Hloop_VQ_A(ntryL,G0H32(67),ex1(:),G0H16(7),m3h2x16(:,173),heltab2x32(:,:,199))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(117),n2h16(241))
  call Hloop_VQ_A(ntryL,G0H32(68),ex1(:),G0H16(10),m3h2x16(:,174),heltab2x32(:,:,200))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(118),n2h16(242))
  call Hloop_ZQ_A(ntryL,G0H32(69),ex1(:),G0H16(13),ngZl,m3h2x16(:,175),heltab2x32(:,:,201))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(119),n2h16(243))
  call Hloop_ZQ_A(ntryL,G0H32(70),ex1(:),G0H16(18),ngZl,m3h2x16(:,176),heltab2x32(:,:,202))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(120),n2h16(244))
  call Hloop_WQ_A(ntryL,G0H32(71),ex1(:),G0H16(7),m3h2x16(:,177),heltab2x32(:,:,203))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(121),n2h16(245))
  call Hloop_WQ_A(ntryL,G0H32(72),ex1(:),G0H16(10),m3h2x16(:,178),heltab2x32(:,:,204))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(122),n2h16(246))
  call Hloop_VQ_A(ntryL,G0H32(73),ex1(:),G0H16(13),m3h2x16(:,179),heltab2x32(:,:,205))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(123),n2h16(247))
  call Hloop_ZQ_A(ntryL,G0H32(74),ex1(:),G0H16(18),ngZl,m3h2x16(:,180),heltab2x32(:,:,206))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(124),n2h16(248))
  call Hloop_WQ_A(ntryL,G0H32(75),ex1(:),G0H16(7),m3h2x16(:,181),heltab2x32(:,:,207))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(125),n2h16(249))
  call Hloop_WQ_A(ntryL,G0H32(76),ex1(:),G0H16(10),m3h2x16(:,182),heltab2x32(:,:,208))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(126),n2h16(250))
  call Hloop_WQ_A(ntryL,G0H32(77),ex1(:),G0H16(13),m3h2x16(:,183),heltab2x32(:,:,209))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(127),n2h16(251))
  call Hloop_SV_V(ntryL,G0H32(78),wf4(:,11),G0H8(9),m3h4x8(:,27),heltab2x32(:,:,210))
  call Hloop_SV_V(ntryL,G0H32(79),wf4(:,9),G0H8(10),m3h4x8(:,28),heltab2x32(:,:,211))
  call Hloop_SV_V(ntryL,G0H32(80),wf4(:,9),G0H8(11),m3h4x8(:,29),heltab2x32(:,:,212))
  call Hloop_SV_V(ntryL,G0H32(81),wf4(:,9),G0H8(12),m3h4x8(:,30),heltab2x32(:,:,213))
  call Hloop_UW_V(ntryL,G0H32(82),32,wf4(:,11),6,G1H8(19),m3h4x8(:,31),heltab2x32(:,:,214))
  call Hloop_UW_V(ntryL,G0H32(83),32,wf4(:,9),6,G1H8(20),m3h4x8(:,32),heltab2x32(:,:,215))
  call Hloop_VA_Q(ntryL,G0H32(84),ex4(:),G0H16(18),m3h2x16(:,184),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G0H16(18),40,0,G1H16(128),n2h16(252))
  call Hloop_ZA_Q(ntryL,G0H32(85),ex4(:),G0H16(7),ngZl,m3h2x16(:,185),heltab2x32(:,:,217))
  call Hloop_A_Q(ntryL,G0H16(7),40,0,G1H16(129),n2h16(253))
  call Hloop_VA_Q(ntryL,G0H32(86),ex4(:),G0H16(10),m3h2x16(:,186),heltab2x32(:,:,218))
  call Hloop_A_Q(ntryL,G0H16(10),40,0,G1H16(130),n2h16(254))
  call Hloop_ZA_Q(ntryL,G0H32(87),ex4(:),G0H16(13),ngZl,m3h2x16(:,187),heltab2x32(:,:,219))
  call Hloop_A_Q(ntryL,G0H16(13),40,0,G1H16(131),n2h16(255))
  call Hloop_VA_Q(ntryL,G0H32(88),ex4(:),G0H16(18),m3h2x16(:,188),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G0H16(18),40,0,G1H16(132),n2h16(256))
  call Hloop_ZA_Q(ntryL,G0H32(89),ex4(:),G0H16(7),ngZl,m3h2x16(:,189),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G0H16(7),40,0,G1H16(1),n2h16(257))
  call Hloop_VA_Q(ntryL,G0H32(90),ex4(:),G0H16(10),m3h2x16(:,190),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G0H16(10),40,0,G1H16(2),n2h16(258))
  call Hloop_ZA_Q(ntryL,G0H32(91),ex4(:),G0H16(13),ngZl,m3h2x16(:,191),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G0H16(13),40,0,G1H16(3),n2h16(259))
  call Hloop_VA_Q(ntryL,G0H32(92),ex4(:),G0H16(18),m3h2x16(:,192),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G0H16(18),40,0,G1H16(4),n2h16(260))
  call Hloop_ZA_Q(ntryL,G0H32(93),ex4(:),G0H16(7),ngZl,m3h2x16(:,193),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G0H16(7),40,0,G1H16(9),n2h16(261))
  call Hloop_VQ_A(ntryL,G0H32(94),ex1(:),G0H16(10),m3h2x16(:,194),heltab2x32(:,:,226))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(10),n2h16(262))
  call Hloop_VQ_A(ntryL,G0H32(95),ex1(:),G0H16(13),m3h2x16(:,195),heltab2x32(:,:,227))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(11),n2h16(263))
  call Hloop_ZQ_A(ntryL,G0H32(96),ex1(:),G0H16(18),ngZl,m3h2x16(:,196),heltab2x32(:,:,228))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(12),n2h16(264))
  call Hloop_ZQ_A(ntryL,G0H32(97),ex1(:),G0H16(7),ngZl,m3h2x16(:,197),heltab2x32(:,:,229))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(17),n2h16(265))
  call Hloop_VQ_A(ntryL,G0H32(98),ex1(:),G0H16(10),m3h2x16(:,198),heltab2x32(:,:,230))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(18),n2h16(266))
  call Hloop_VQ_A(ntryL,G0H32(99),ex1(:),G0H16(13),m3h2x16(:,199),heltab2x32(:,:,231))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(19),n2h16(267))
  call Hloop_ZQ_A(ntryL,G0H32(100),ex1(:),G0H16(18),ngZl,m3h2x16(:,200),heltab2x32(:,:,232))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(20),n2h16(268))
  call Hloop_ZQ_A(ntryL,G0H32(101),ex1(:),G0H16(7),ngZl,m3h2x16(:,201),heltab2x32(:,:,233))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(25),n2h16(269))
  call Hloop_WQ_A(ntryL,G0H32(102),ex1(:),G0H16(10),m3h2x16(:,202),heltab2x32(:,:,234))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(26),n2h16(270))
  call Hloop_VA_Q(ntryL,G0H32(103),ex3(:),G0H16(13),m3h2x16(:,203),heltab2x32(:,:,235))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(27),n2h16(271))
  call Hloop_ZA_Q(ntryL,G0H32(104),ex3(:),G0H16(18),ngZl,m3h2x16(:,204),heltab2x32(:,:,236))
  call Hloop_A_Q(ntryL,G0H16(18),36,0,G1H16(28),n2h16(272))
  call Hloop_VA_Q(ntryL,G0H32(105),ex3(:),G0H16(7),m3h2x16(:,205),heltab2x32(:,:,237))
  call Hloop_A_Q(ntryL,G0H16(7),36,0,G1H16(42),n2h16(273))
  call Hloop_ZA_Q(ntryL,G0H32(106),ex3(:),G0H16(10),ngZl,m3h2x16(:,206),heltab2x32(:,:,238))
  call Hloop_A_Q(ntryL,G0H16(10),36,0,G1H16(33),n2h16(274))
  call Hloop_VA_Q(ntryL,G0H32(107),ex3(:),G0H16(13),m3h2x16(:,207),heltab2x32(:,:,239))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(34),n2h16(275))
  call Hloop_ZA_Q(ntryL,G0H32(108),ex3(:),G0H16(18),ngZl,m3h2x16(:,208),heltab2x32(:,:,240))
  call Hloop_A_Q(ntryL,G0H16(18),36,0,G1H16(35),n2h16(276))
  call Hloop_VA_Q(ntryL,G0H32(109),ex3(:),G0H16(7),m3h2x16(:,209),heltab2x32(:,:,241))
  call Hloop_A_Q(ntryL,G0H16(7),36,0,G1H16(36),n2h16(277))
  call Hloop_ZA_Q(ntryL,G0H32(110),ex3(:),G0H16(10),ngZl,m3h2x16(:,210),heltab2x32(:,:,242))
  call Hloop_A_Q(ntryL,G0H16(10),36,0,G1H16(53),n2h16(278))
  call Hloop_SV_V(ntryL,G0H32(111),wf4(:,8),G0H8(13),m3h4x8(:,33),heltab2x32(:,:,243))
  call Hloop_SV_V(ntryL,G0H32(112),wf4(:,8),G0H8(14),m3h4x8(:,34),heltab2x32(:,:,244))
  call Hloop_VQ_A(ntryL,G0H32(113),ex2(:),G0H16(13),m3h2x16(:,211),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(44),n2h16(279))
  call Hloop_VQ_A(ntryL,G0H32(114),ex2(:),G0H16(18),m3h2x16(:,212),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(45),n2h16(280))
  call Hloop_ZQ_A(ntryL,G0H32(115),ex2(:),G0H16(7),ngZl,m3h2x16(:,213),heltab2x32(:,:,247))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(46),n2h16(281))
  call Hloop_ZQ_A(ntryL,G0H32(116),ex2(:),G0H16(10),ngZl,m3h2x16(:,214),heltab2x32(:,:,248))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(47),n2h16(282))
  call Hloop_WQ_A(ntryL,G0H32(117),ex2(:),G0H16(13),m3h2x16(:,215),heltab2x32(:,:,249))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(64),n2h16(283))
  call Hloop_VQ_A(ntryL,G0H32(118),ex2(:),G0H16(18),m3h2x16(:,216),heltab2x32(:,:,250))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(55),n2h16(284))
  call Hloop_VQ_A(ntryL,G0H32(119),ex2(:),G0H16(7),m3h2x16(:,217),heltab2x32(:,:,251))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(56),n2h16(285))
  call Hloop_ZQ_A(ntryL,G0H32(120),ex2(:),G0H16(10),ngZl,m3h2x16(:,218),heltab2x32(:,:,252))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(57),n2h16(286))
  call Hloop_ZQ_A(ntryL,G0H32(121),ex2(:),G0H16(13),ngZl,m3h2x16(:,219),heltab2x32(:,:,253))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(58),n2h16(287))
  call Hloop_WQ_A(ntryL,G0H32(122),ex2(:),G0H16(18),m3h2x16(:,220),heltab2x32(:,:,254))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(75),n2h16(288))
  call Hloop_WQ_A(ntryL,G0H32(123),ex2(:),G0H16(7),m3h2x16(:,221),heltab2x32(:,:,255))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(66),n2h16(289))
  call Hloop_VQ_A(ntryL,G0H32(124),ex2(:),G0H16(10),m3h2x16(:,222),heltab2x32(:,:,256))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(67),n2h16(290))
  call Hloop_ZQ_A(ntryL,G0H32(125),ex2(:),G0H16(13),ngZl,m3h2x16(:,223),heltab2x32(:,:,257))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(68),n2h16(291))
  call Hloop_WQ_A(ntryL,G0H32(126),ex2(:),G0H16(18),m3h2x16(:,224),heltab2x32(:,:,258))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(69),n2h16(292))
  call Hloop_WQ_A(ntryL,G0H32(127),ex2(:),G0H16(7),m3h2x16(:,225),heltab2x32(:,:,259))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(133),n2h16(293))
  call Hloop_WQ_A(ntryL,G0H32(128),ex2(:),G0H16(10),m3h2x16(:,226),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(134),n2h16(294))
  call Hloop_SV_V(ntryL,G0H32(129),wf4(:,10),G0H8(15),m3h4x8(:,35),heltab2x32(:,:,261))
  call Hloop_SV_V(ntryL,G0H32(130),wf4(:,8),G0H8(16),m3h4x8(:,36),heltab2x32(:,:,262))
  call Hloop_SV_V(ntryL,G0H32(131),wf4(:,8),G0H8(17),m3h4x8(:,37),heltab2x32(:,:,263))
  call Hloop_SV_V(ntryL,G0H32(132),wf4(:,8),G0H8(18),m3h4x8(:,38),heltab2x32(:,:,264))
  call Hloop_UW_V(ntryL,G0H32(1),32,wf4(:,10),9,G1H8(21),m3h4x8(:,39),heltab2x32(:,:,265))
  call Hloop_UW_V(ntryL,G0H32(2),32,wf4(:,8),9,G1H8(22),m3h4x8(:,40),heltab2x32(:,:,266))
  call Hloop_VA_Q(ntryL,G0H32(3),ex3(:),G0H16(13),m3h2x16(:,227),heltab2x32(:,:,267))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(135),n2h16(295))
  call Hloop_ZA_Q(ntryL,G0H32(4),ex3(:),G0H16(18),ngZl,m3h2x16(:,228),heltab2x32(:,:,268))
  call Hloop_A_Q(ntryL,G0H16(18),36,0,G1H16(136),n2h16(296))
  call Hloop_VA_Q(ntryL,G0H32(5),ex3(:),G0H16(7),m3h2x16(:,229),heltab2x32(:,:,269))
  call Hloop_A_Q(ntryL,G0H16(7),36,0,G1H16(137),n2h16(297))
  call Hloop_ZA_Q(ntryL,G0H32(6),ex3(:),G0H16(10),ngZl,m3h2x16(:,230),heltab2x32(:,:,270))
  call Hloop_A_Q(ntryL,G0H16(10),36,0,G1H16(138),n2h16(298))
  call Hloop_VA_Q(ntryL,G0H32(7),ex3(:),G0H16(13),m3h2x16(:,231),heltab2x32(:,:,271))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(139),n2h16(299))
  call Hloop_ZA_Q(ntryL,G0H32(8),ex3(:),G0H16(18),ngZl,m3h2x16(:,232),heltab2x32(:,:,272))
  call Hloop_A_Q(ntryL,G0H16(18),36,0,G1H16(140),n2h16(300))
  call Hloop_VA_Q(ntryL,G0H32(52),ex3(:),G0H16(7),m3h2x16(:,233),heltab2x32(:,:,273))
  call Hloop_A_Q(ntryL,G0H16(7),36,0,G1H16(141),n2h16(301))
  call Hloop_ZA_Q(ntryL,G0H32(53),ex3(:),G0H16(10),ngZl,m3h2x16(:,234),heltab2x32(:,:,274))
  call Hloop_A_Q(ntryL,G0H16(10),36,0,G1H16(142),n2h16(302))
  call Hloop_VA_Q(ntryL,G0H32(54),ex3(:),G0H16(13),m3h2x16(:,235),heltab2x32(:,:,275))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(143),n2h16(303))
  call Hloop_ZA_Q(ntryL,G0H32(55),ex3(:),G0H16(18),ngZl,m3h2x16(:,236),heltab2x32(:,:,276))
  call Hloop_A_Q(ntryL,G0H16(18),36,0,G1H16(144),n2h16(304))
  call Hloop_VQ_A(ntryL,G0H32(56),ex2(:),G0H16(7),m3h2x16(:,237),heltab2x32(:,:,277))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(145),n2h16(305))
  call Hloop_VQ_A(ntryL,G0H32(57),ex2(:),G0H16(10),m3h2x16(:,238),heltab2x32(:,:,278))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(146),n2h16(306))
  call Hloop_ZQ_A(ntryL,G0H32(58),ex2(:),G0H16(13),ngZl,m3h2x16(:,239),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(147),n2h16(307))
  call Hloop_ZQ_A(ntryL,G0H32(59),ex2(:),G0H16(18),ngZl,m3h2x16(:,240),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(148),n2h16(308))
  call Hloop_VQ_A(ntryL,G0H32(133),ex2(:),G0H16(7),m3h2x16(:,241),heltab2x32(:,:,281))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(149),n2h16(309))
  call Hloop_VQ_A(ntryL,G0H32(134),ex2(:),G0H16(10),m3h2x16(:,242),heltab2x32(:,:,282))
  call Hloop_Q_A(ntryL,G0H16(10),34,0,G1H16(150),n2h16(310))
  call Hloop_ZQ_A(ntryL,G0H32(135),ex2(:),G0H16(13),ngZl,m3h2x16(:,243),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G0H16(13),34,0,G1H16(151),n2h16(311))
  call Hloop_ZQ_A(ntryL,G0H32(136),ex2(:),G0H16(18),ngZl,m3h2x16(:,244),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(152),n2h16(312))
  call Hloop_WQ_A(ntryL,G0H32(137),ex2(:),G0H16(7),m3h2x16(:,245),heltab2x32(:,:,285))
  call Hloop_Q_A(ntryL,G0H16(7),34,0,G1H16(153),n2h16(313))
  call Hloop_VA_Q(ntryL,G0H32(138),ex3(:),G0H16(10),m3h2x16(:,246),heltab2x32(:,:,286))
  call Hloop_A_Q(ntryL,G0H16(10),36,0,G1H16(154),n2h16(314))
  call Hloop_ZA_Q(ntryL,G0H32(139),ex3(:),G0H16(13),ngZl,m3h2x16(:,247),heltab2x32(:,:,287))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(155),n2h16(315))
  call Hloop_VA_Q(ntryL,G0H32(140),ex3(:),G0H16(18),m3h2x16(:,248),heltab2x32(:,:,288))
  call Hloop_A_Q(ntryL,G0H16(18),36,0,G1H16(156),n2h16(316))
  call Hloop_ZA_Q(ntryL,G0H32(141),ex3(:),G0H16(7),ngZl,m3h2x16(:,249),heltab2x32(:,:,289))
  call Hloop_A_Q(ntryL,G0H16(7),36,0,G1H16(157),n2h16(317))
  call Hloop_VA_Q(ntryL,G0H32(142),ex3(:),G0H16(10),m3h2x16(:,250),heltab2x32(:,:,290))
  call Hloop_A_Q(ntryL,G0H16(10),36,0,G1H16(158),n2h16(318))
  call Hloop_ZA_Q(ntryL,G0H32(143),ex3(:),G0H16(13),ngZl,m3h2x16(:,251),heltab2x32(:,:,291))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(159),n2h16(319))
  call Hloop_VA_Q(ntryL,G0H32(144),ex3(:),G0H16(18),m3h2x16(:,252),heltab2x32(:,:,292))
  call Hloop_A_Q(ntryL,G0H16(18),36,0,G1H16(160),n2h16(320))
  call Hloop_ZA_Q(ntryL,G0H32(145),ex3(:),G0H16(7),ngZl,m3h2x16(:,253),heltab2x32(:,:,293))
  call Hloop_A_Q(ntryL,G0H16(7),36,0,G1H16(161),n2h16(321))
  call Hloop_SV_V(ntryL,G0H32(146),wf4(:,2),G0H8(19),m3h4x8(:,41),heltab2x32(:,:,294))
  call Hloop_SV_V(ntryL,G0H32(147),wf4(:,2),G0H8(20),m3h4x8(:,42),heltab2x32(:,:,295))
  call Hloop_VQ_A(ntryL,G0H32(148),ex1(:),G0H16(10),m3h2x16(:,254),heltab2x32(:,:,296))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(162),n2h16(322))
  call Hloop_VQ_A(ntryL,G0H32(149),ex1(:),G0H16(13),m3h2x16(:,255),heltab2x32(:,:,297))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(163),n2h16(323))
  call Hloop_ZQ_A(ntryL,G0H32(150),ex1(:),G0H16(18),ngZl,m3h2x16(:,256),heltab2x32(:,:,298))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(164),n2h16(324))
  call Hloop_ZQ_A(ntryL,G0H32(151),ex1(:),G0H16(7),ngZl,m3h2x16(:,257),heltab2x32(:,:,299))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(165),n2h16(325))
  call Hloop_WQ_A(ntryL,G0H32(152),ex1(:),G0H16(10),m3h2x16(:,258),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(166),n2h16(326))
  call Hloop_VQ_A(ntryL,G0H32(153),ex1(:),G0H16(13),m3h2x16(:,259),heltab2x32(:,:,301))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(167),n2h16(327))
  call Hloop_VQ_A(ntryL,G0H32(154),ex1(:),G0H16(18),m3h2x16(:,260),heltab2x32(:,:,302))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(168),n2h16(328))
  call Hloop_ZQ_A(ntryL,G0H32(155),ex1(:),G0H16(7),ngZl,m3h2x16(:,261),heltab2x32(:,:,303))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(169),n2h16(329))
  call Hloop_ZQ_A(ntryL,G0H32(156),ex1(:),G0H16(10),ngZl,m3h2x16(:,262),heltab2x32(:,:,304))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(170),n2h16(330))
  call Hloop_WQ_A(ntryL,G0H32(157),ex1(:),G0H16(13),m3h2x16(:,263),heltab2x32(:,:,305))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(171),n2h16(331))
  call Hloop_WQ_A(ntryL,G0H32(158),ex1(:),G0H16(18),m3h2x16(:,264),heltab2x32(:,:,306))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(172),n2h16(332))
  call Hloop_VQ_A(ntryL,G0H32(159),ex1(:),G0H16(7),m3h2x16(:,265),heltab2x32(:,:,307))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(173),n2h16(333))
  call Hloop_ZQ_A(ntryL,G0H32(160),ex1(:),G0H16(10),ngZl,m3h2x16(:,266),heltab2x32(:,:,308))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(174),n2h16(334))
  call Hloop_WQ_A(ntryL,G0H32(161),ex1(:),G0H16(13),m3h2x16(:,267),heltab2x32(:,:,309))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(175),n2h16(335))
  call Hloop_WQ_A(ntryL,G0H32(162),ex1(:),G0H16(18),m3h2x16(:,268),heltab2x32(:,:,310))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(176),n2h16(336))
  call Hloop_WQ_A(ntryL,G0H32(163),ex1(:),G0H16(7),m3h2x16(:,269),heltab2x32(:,:,311))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(177),n2h16(337))
  call Hloop_SV_V(ntryL,G0H32(164),wf4(:,5),G0H8(21),m3h4x8(:,43),heltab2x32(:,:,312))
  call Hloop_SV_V(ntryL,G0H32(165),wf4(:,2),G0H8(22),m3h4x8(:,44),heltab2x32(:,:,313))
  call Hloop_SV_V(ntryL,G0H32(166),wf4(:,2),G0H8(23),m3h4x8(:,45),heltab2x32(:,:,314))
  call Hloop_SV_V(ntryL,G0H32(167),wf4(:,2),G0H8(24),m3h4x8(:,46),heltab2x32(:,:,315))
  call Hloop_UW_V(ntryL,G0H32(168),32,wf4(:,5),10,G1H8(23),m3h4x8(:,47),heltab2x32(:,:,316))
  call Hloop_UW_V(ntryL,G0H32(169),32,wf4(:,2),10,G1H8(24),m3h4x8(:,48),heltab2x32(:,:,317))
  call Hloop_VA_Q(ntryL,G0H32(170),ex3(:),G0H16(10),m3h2x16(:,270),heltab2x32(:,:,318))
  call Hloop_A_Q(ntryL,G0H16(10),36,0,G1H16(178),n2h16(338))
  call Hloop_ZA_Q(ntryL,G0H32(171),ex3(:),G0H16(13),ngZl,m3h2x16(:,271),heltab2x32(:,:,319))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(179),n2h16(339))
  call Hloop_VA_Q(ntryL,G0H32(172),ex3(:),G0H16(18),m3h2x16(:,272),heltab2x32(:,:,320))
  call Hloop_A_Q(ntryL,G0H16(18),36,0,G1H16(180),n2h16(340))
  call Hloop_ZA_Q(ntryL,G0H32(173),ex3(:),G0H16(7),ngZl,m3h2x16(:,273),heltab2x32(:,:,321))
  call Hloop_A_Q(ntryL,G0H16(7),36,0,G1H16(181),n2h16(341))
  call Hloop_VA_Q(ntryL,G0H32(174),ex3(:),G0H16(10),m3h2x16(:,274),heltab2x32(:,:,322))
  call Hloop_A_Q(ntryL,G0H16(10),36,0,G1H16(182),n2h16(342))
  call Hloop_ZA_Q(ntryL,G0H32(175),ex3(:),G0H16(13),ngZl,m3h2x16(:,275),heltab2x32(:,:,323))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(183),n2h16(343))
  call Hloop_VA_Q(ntryL,G0H32(176),ex3(:),G0H16(18),m3h2x16(:,276),heltab2x32(:,:,324))
  call Hloop_A_Q(ntryL,G0H16(18),36,0,G1H16(184),n2h16(344))
  call Hloop_ZA_Q(ntryL,G0H32(177),ex3(:),G0H16(7),ngZl,m3h2x16(:,277),heltab2x32(:,:,325))
  call Hloop_A_Q(ntryL,G0H16(7),36,0,G1H16(185),n2h16(345))
  call Hloop_VA_Q(ntryL,G0H32(178),ex3(:),G0H16(10),m3h2x16(:,278),heltab2x32(:,:,326))
  call Hloop_A_Q(ntryL,G0H16(10),36,0,G1H16(186),n2h16(346))
  call Hloop_ZA_Q(ntryL,G0H32(179),ex3(:),G0H16(13),ngZl,m3h2x16(:,279),heltab2x32(:,:,327))
  call Hloop_A_Q(ntryL,G0H16(13),36,0,G1H16(187),n2h16(347))
  call Hloop_VQ_A(ntryL,G0H32(180),ex1(:),G0H16(18),m3h2x16(:,280),heltab2x32(:,:,328))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(188),n2h16(348))
  call Hloop_VQ_A(ntryL,G0H32(181),ex1(:),G0H16(7),m3h2x16(:,281),heltab2x32(:,:,329))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(189),n2h16(349))
  call Hloop_ZQ_A(ntryL,G0H32(182),ex1(:),G0H16(10),ngZl,m3h2x16(:,282),heltab2x32(:,:,330))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(190),n2h16(350))
  call Hloop_ZQ_A(ntryL,G0H32(183),ex1(:),G0H16(13),ngZl,m3h2x16(:,283),heltab2x32(:,:,331))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(191),n2h16(351))
  call Hloop_VQ_A(ntryL,G0H32(184),ex1(:),G0H16(18),m3h2x16(:,284),heltab2x32(:,:,332))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(192),n2h16(352))
  call Hloop_VQ_A(ntryL,G0H32(185),ex1(:),G0H16(7),m3h2x16(:,285),heltab2x32(:,:,333))
  call Hloop_Q_A(ntryL,G0H16(7),33,0,G1H16(193),n2h16(353))
  call Hloop_ZQ_A(ntryL,G0H32(186),ex1(:),G0H16(10),ngZl,m3h2x16(:,286),heltab2x32(:,:,334))
  call Hloop_Q_A(ntryL,G0H16(10),33,0,G1H16(194),n2h16(354))
  call Hloop_ZQ_A(ntryL,G0H32(187),ex1(:),G0H16(13),ngZl,m3h2x16(:,287),heltab2x32(:,:,335))
  call Hloop_Q_A(ntryL,G0H16(13),33,0,G1H16(195),n2h16(355))
  call Hloop_WQ_A(ntryL,G0H32(188),ex1(:),G0H16(18),m3h2x16(:,288),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G0H16(18),33,0,G1H16(196),n2h16(356))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex3(:),G0H8(25),ngZl,m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G0H8(25),52,0,G1H8(25),n2h8(17))
  call Hloop_ZA_Q(ntryL,G0H16(2),ex3(:),G0H8(25),ngZl,m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G0H8(25),52,0,G1H8(26),n2h8(18))
  call Hloop_AQ_V(ntryL,G1H16(5),ex2(:),G1H8(27),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_AQ_V(ntryL,G1H16(6),ex2(:),G1H8(28),m3h2x8(:,136),heltab2x16(:,:,136))
  call Hloop_AQ_Z(ntryL,G1H16(7),ex2(:),G1H8(29),ngZl,m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_AQ_Z(ntryL,G1H16(8),ex2(:),G1H8(30),ngZl,m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_ZA_Q(ntryL,G0H16(3),ex3(:),G0H8(25),ngZl,m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G0H8(25),52,0,G1H8(31),n2h8(19))
  call Hloop_ZA_Q(ntryL,G0H16(4),ex3(:),G0H8(25),ngZl,m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G0H8(25),52,0,G1H8(32),n2h8(20))
  call Hloop_AQ_V(ntryL,G1H16(13),ex2(:),G1H8(33),m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_AQ_V(ntryL,G1H16(14),ex2(:),G1H8(34),m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_AQ_Z(ntryL,G1H16(15),ex2(:),G1H8(35),ngZl,m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_AQ_Z(ntryL,G1H16(16),ex2(:),G1H8(36),ngZl,m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_AQ_V(ntryL,G1H16(21),ex1(:),G1H8(37),m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_AQ_V(ntryL,G1H16(22),ex1(:),G1H8(38),m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_AQ_Z(ntryL,G1H16(23),ex1(:),G1H8(39),ngZl,m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_AQ_Z(ntryL,G1H16(24),ex1(:),G1H8(40),ngZl,m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_AQ_V(ntryL,G1H16(29),ex1(:),G1H8(41),m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_AQ_V(ntryL,G1H16(30),ex1(:),G1H8(42),m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_AQ_Z(ntryL,G1H16(31),ex1(:),G1H8(43),ngZl,m3h2x8(:,151),heltab2x16(:,:,151))
  call Hloop_AQ_Z(ntryL,G1H16(32),ex1(:),G1H8(44),ngZl,m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_ZQ_A(ntryL,G0H16(5),ex2(:),G0H8(25),ngZl,m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G0H8(25),50,0,G1H8(45),n2h8(21))
  call Hloop_ZQ_A(ntryL,G0H16(6),ex2(:),G0H8(25),ngZl,m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G0H8(25),50,0,G1H8(46),n2h8(22))
  call Hloop_WQ_A(ntryL,G1H16(43),ex2(:),G1H8(47),m3h2x8(:,155),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H8(47),50,0,G2H8(17),n2h8(23))
  call Hloop_AQ_V(ntryL,G1H16(37),ex2(:),G1H8(48),m3h2x8(:,156),heltab2x16(:,:,156))
  call Hloop_AQ_Z(ntryL,G1H16(38),ex2(:),G1H8(49),ngZl,m3h2x8(:,157),heltab2x16(:,:,157))
  call Hloop_AQ_V(ntryL,G1H16(39),ex2(:),G1H8(50),m3h2x8(:,158),heltab2x16(:,:,158))
  call Hloop_AQ_Z(ntryL,G1H16(40),ex2(:),G1H8(51),ngZl,m3h2x8(:,159),heltab2x16(:,:,159))
  call Hloop_AQ_W(ntryL,G1H16(41),ex2(:),G1H8(52),m3h2x8(:,160),heltab2x16(:,:,160))
  call Hloop_ZQ_A(ntryL,G0H16(8),ex2(:),G0H8(25),ngZl,m3h2x8(:,161),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G0H8(25),50,0,G1H8(53),n2h8(24))
  call Hloop_ZQ_A(ntryL,G0H16(9),ex2(:),G0H8(25),ngZl,m3h2x8(:,162),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G0H8(25),50,0,G1H8(54),n2h8(25))
  call Hloop_WQ_A(ntryL,G1H16(54),ex2(:),G1H8(55),m3h2x8(:,163),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H8(55),50,0,G2H8(18),n2h8(26))
  call Hloop_AQ_V(ntryL,G1H16(48),ex2(:),G1H8(56),m3h2x8(:,164),heltab2x16(:,:,164))
  call Hloop_AQ_Z(ntryL,G1H16(49),ex2(:),G1H8(57),ngZl,m3h2x8(:,165),heltab2x16(:,:,165))
  call Hloop_AQ_V(ntryL,G1H16(50),ex2(:),G1H8(58),m3h2x8(:,166),heltab2x16(:,:,166))
  call Hloop_AQ_Z(ntryL,G1H16(51),ex2(:),G1H8(59),ngZl,m3h2x8(:,167),heltab2x16(:,:,167))
  call Hloop_AQ_W(ntryL,G1H16(52),ex2(:),G1H8(60),m3h2x8(:,168),heltab2x16(:,:,168))
  call Hloop_ZQ_A(ntryL,G0H16(11),ex1(:),G0H8(25),ngZl,m3h2x8(:,169),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G0H8(25),49,0,G1H8(61),n2h8(27))
  call Hloop_ZQ_A(ntryL,G0H16(12),ex1(:),G0H8(25),ngZl,m3h2x8(:,170),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G0H8(25),49,0,G1H8(62),n2h8(28))
  call Hloop_WQ_A(ntryL,G1H16(65),ex1(:),G1H8(63),m3h2x8(:,171),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H8(63),49,0,G2H8(19),n2h8(29))
  call Hloop_AQ_V(ntryL,G1H16(59),ex1(:),G1H8(64),m3h2x8(:,172),heltab2x16(:,:,172))
  call Hloop_AQ_V(ntryL,G1H16(60),ex1(:),G1H8(65),m3h2x8(:,173),heltab2x16(:,:,173))
  call Hloop_AQ_Z(ntryL,G1H16(61),ex1(:),G1H8(66),ngZl,m3h2x8(:,174),heltab2x16(:,:,174))
  call Hloop_AQ_Z(ntryL,G1H16(62),ex1(:),G1H8(67),ngZl,m3h2x8(:,175),heltab2x16(:,:,175))
  call Hloop_AQ_W(ntryL,G1H16(63),ex1(:),G1H8(68),m3h2x8(:,176),heltab2x16(:,:,176))
  call Hloop_ZQ_A(ntryL,G0H16(14),ex1(:),G0H8(25),ngZl,m3h2x8(:,177),heltab2x16(:,:,177))
  call Hloop_Q_A(ntryL,G0H8(25),49,0,G1H8(69),n2h8(30))
  call Hloop_ZQ_A(ntryL,G0H16(15),ex1(:),G0H8(25),ngZl,m3h2x8(:,178),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G0H8(25),49,0,G1H8(70),n2h8(31))
  call Hloop_ZQ_A(ntryL,G0H16(16),ex1(:),G0H8(25),ngZl,m3h2x8(:,179),heltab2x16(:,:,179))
  call Hloop_Q_A(ntryL,G0H8(25),49,0,G1H8(71),n2h8(32))
  call Hloop_ZQ_A(ntryL,G0H16(17),ex1(:),G0H8(25),ngZl,m3h2x8(:,180),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G0H8(25),49,0,G1H8(72),n2h8(33))
  call Hloop_WQ_A(ntryL,G1H16(76),ex1(:),G1H8(73),m3h2x8(:,181),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H8(73),49,0,G2H8(20),n2h8(34))
  call Hloop_AQ_V(ntryL,G1H16(70),ex1(:),G1H8(74),m3h2x8(:,182),heltab2x16(:,:,182))
  call Hloop_AQ_V(ntryL,G1H16(71),ex1(:),G1H8(75),m3h2x8(:,183),heltab2x16(:,:,183))
  call Hloop_AQ_Z(ntryL,G1H16(72),ex1(:),G1H8(76),ngZl,m3h2x8(:,184),heltab2x16(:,:,184))
  call Hloop_AQ_Z(ntryL,G1H16(73),ex1(:),G1H8(77),ngZl,m3h2x8(:,185),heltab2x16(:,:,185))
  call Hloop_AQ_W(ntryL,G1H16(74),ex1(:),G1H8(78),m3h2x8(:,186),heltab2x16(:,:,186))
  call Hloop_ZQ_A(ntryL,G0H16(19),ex1(:),G0H8(25),ngZl,m3h2x8(:,187),heltab2x16(:,:,187))
  call Hloop_Q_A(ntryL,G0H8(25),49,0,G1H8(79),n2h8(35))
  call Hloop_ZQ_A(ntryL,G0H16(20),ex1(:),G0H8(25),ngZl,m3h2x8(:,188),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G0H8(25),49,0,G1H8(80),n2h8(36))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(9),G0H8(6),G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G2H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G2H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G2H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G2H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(19),G0H8(12),G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(21),G0H8(18),G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(23),G0H8(24),G0H8(21)])
  call Hloop_AQ_V(ntryL,G2H8(5),ex5(:),G2H4(1),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_AQ_V(ntryL,G2H8(6),ex5(:),G2H4(2),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_AQ_Z(ntryL,G2H8(7),ex5(:),G2H4(3),ngZd,m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_AQ_Z(ntryL,G2H8(8),ex5(:),G2H4(4),ngZd,m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_ZA_Q(ntryL,G0H8(1),ex4(:),G0H4(1),ngZl,m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G0H4(1),45,0,G1H4(1),n2h4(133))
  call Hloop_ZA_Q(ntryL,G0H8(2),ex4(:),G0H4(1),ngZl,m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G0H4(1),45,0,G1H4(2),n2h4(134))
  call Hloop_QA_V(ntryL,G1H16(77),ex4(:),G1H8(81),m3h2x8(:,189),heltab2x16(:,:,189))
  call Hloop_QA_Z(ntryL,G1H16(78),ex4(:),G1H8(82),ngZl,m3h2x8(:,190),heltab2x16(:,:,190))
  call Hloop_QA_V(ntryL,G1H16(79),ex4(:),G1H8(83),m3h2x8(:,191),heltab2x16(:,:,191))
  call Hloop_QA_Z(ntryL,G1H16(80),ex4(:),G1H8(84),ngZl,m3h2x8(:,192),heltab2x16(:,:,192))
  call Hloop_QA_W(ntryL,G1H16(81),ex4(:),G1H8(85),m3h2x8(:,193),heltab2x16(:,:,193))
  call Hloop_QA_V(ntryL,G1H16(82),ex4(:),G1H8(86),m3h2x8(:,194),heltab2x16(:,:,194))
  call Hloop_QA_Z(ntryL,G1H16(83),ex4(:),G1H8(87),ngZl,m3h2x8(:,195),heltab2x16(:,:,195))
  call Hloop_QA_V(ntryL,G1H16(84),ex4(:),G1H8(88),m3h2x8(:,196),heltab2x16(:,:,196))
  call Hloop_QA_Z(ntryL,G1H16(85),ex4(:),G1H8(89),ngZl,m3h2x8(:,197),heltab2x16(:,:,197))
  call Hloop_QA_W(ntryL,G1H16(86),ex4(:),G1H8(90),m3h2x8(:,198),heltab2x16(:,:,198))
  call Hloop_QA_W(ntryL,G1H16(87),ex4(:),G1H8(91),m3h2x8(:,199),heltab2x16(:,:,199))
  call Hloop_QA_Z(ntryL,G1H16(88),ex4(:),G1H8(92),ngZl,m3h2x8(:,200),heltab2x16(:,:,200))
  call Hloop_QA_Z(ntryL,G1H16(89),ex4(:),G1H8(93),ngZl,m3h2x8(:,201),heltab2x16(:,:,201))
  call Hloop_QA_W(ntryL,G1H16(90),ex4(:),G1H8(94),m3h2x8(:,202),heltab2x16(:,:,202))
  call Hloop_QA_W(ntryL,G1H16(91),ex4(:),G1H8(95),m3h2x8(:,203),heltab2x16(:,:,203))
  call Hloop_QA_W(ntryL,G1H16(92),ex4(:),G1H8(96),m3h2x8(:,204),heltab2x16(:,:,204))
  call Hloop_WQ_A(ntryL,G1H8(10),ex2(:),G1H4(3),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(3),39,0,G2H4(5),n2h4(135))
  call Hloop_ZQ_A(ntryL,G0H8(4),ex2(:),G0H4(1),ngZl,m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(3),n2h4(136))
  call Hloop_ZQ_A(ntryL,G0H8(5),ex2(:),G0H4(1),ngZl,m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(4),n2h4(137))
  call Hloop_AQ_Z(ntryL,G1H16(93),ex2(:),G1H8(97),ngZl,m3h2x8(:,205),heltab2x16(:,:,205))
  call Hloop_AQ_Z(ntryL,G1H16(94),ex2(:),G1H8(98),ngZl,m3h2x8(:,206),heltab2x16(:,:,206))
  call Hloop_AV_Q(ntryL,G1H16(95),wf4(:,4),G1H4(5),m3h4x4(:,1),heltab2x16(:,:,207))
  call Hloop_A_Q(ntryL,G1H4(5),45,0,G2H4(6),n2h4(138))
  call Hloop_AV_Q(ntryL,G1H16(96),wf4(:,4),G1H4(5),m3h4x4(:,2),heltab2x16(:,:,208))
  call Hloop_A_Q(ntryL,G1H4(5),45,0,G2H4(7),n2h4(139))
  call Hloop_AV_Q(ntryL,G1H16(97),wf4(:,4),G1H4(5),m3h4x4(:,3),heltab2x16(:,:,209))
  call Hloop_A_Q(ntryL,G1H4(5),45,0,G2H4(8),n2h4(140))
  call Hloop_AV_Q(ntryL,G1H16(98),wf4(:,4),G1H4(5),m3h4x4(:,4),heltab2x16(:,:,210))
  call Hloop_A_Q(ntryL,G1H4(5),45,0,G2H4(9),n2h4(141))
  call Hloop_AZ_Q(ntryL,G1H16(99),wf4(:,1),G1H4(5),ngZl,m3h4x4(:,5),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G1H4(5),45,0,G2H4(10),n2h4(142))
  call Hloop_AZ_Q(ntryL,G1H16(100),wf4(:,1),G1H4(5),ngZl,m3h4x4(:,6),heltab2x16(:,:,212))
  call Hloop_A_Q(ntryL,G1H4(5),45,0,G2H4(11),n2h4(143))
  call Hloop_AZ_Q(ntryL,G1H16(101),wf4(:,1),G1H4(5),ngZl,m3h4x4(:,7),heltab2x16(:,:,213))
  call Hloop_A_Q(ntryL,G1H4(5),45,0,G2H4(12),n2h4(144))
  call Hloop_AZ_Q(ntryL,G1H16(102),wf4(:,1),G1H4(5),ngZl,m3h4x4(:,8),heltab2x16(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(5),45,0,G2H4(13),n2h4(145))
  call Hloop_QV_A(ntryL,G1H16(103),wf4(:,4),G1H4(5),m3h4x4(:,9),heltab2x16(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(14),n2h4(146))
  call Hloop_QV_A(ntryL,G1H16(104),wf4(:,4),G1H4(5),m3h4x4(:,10),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(15),n2h4(147))
  call Hloop_QV_A(ntryL,G1H16(105),wf4(:,4),G1H4(5),m3h4x4(:,11),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(16),n2h4(148))
  call Hloop_QV_A(ntryL,G1H16(106),wf4(:,4),G1H4(5),m3h4x4(:,12),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(17),n2h4(149))
  call Hloop_QZ_A(ntryL,G1H16(107),wf4(:,1),G1H4(5),ngZl,m3h4x4(:,13),heltab2x16(:,:,219))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(18),n2h4(150))
  call Hloop_QZ_A(ntryL,G1H16(108),wf4(:,1),G1H4(5),ngZl,m3h4x4(:,14),heltab2x16(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(19),n2h4(151))
  call Hloop_QZ_A(ntryL,G1H16(109),wf4(:,1),G1H4(5),ngZl,m3h4x4(:,15),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(20),n2h4(152))
  call Hloop_QZ_A(ntryL,G1H16(110),wf4(:,1),G1H4(5),ngZl,m3h4x4(:,16),heltab2x16(:,:,222))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(21),n2h4(153))
  call Hloop_QZ_A(ntryL,G1H16(111),wf4(:,1),G1H4(5),ngZn,m3h4x4(:,17),heltab2x16(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(5),39,0,G2H4(22),n2h4(154))
  call Hloop_AQ_V(ntryL,G2H8(13),ex5(:),G2H4(23),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_AQ_V(ntryL,G2H8(14),ex5(:),G2H4(24),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_AQ_Z(ntryL,G2H8(15),ex5(:),G2H4(25),ngZd,m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_AQ_Z(ntryL,G2H8(16),ex5(:),G2H4(26),ngZd,m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_ZA_Q(ntryL,G0H8(7),ex4(:),G0H4(1),ngZl,m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G0H4(1),46,0,G1H4(5),n2h4(155))
  call Hloop_ZA_Q(ntryL,G0H8(8),ex4(:),G0H4(1),ngZl,m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G0H4(1),46,0,G1H4(6),n2h4(156))
  call Hloop_QA_V(ntryL,G1H16(112),ex4(:),G1H8(99),m3h2x8(:,207),heltab2x16(:,:,224))
  call Hloop_QA_Z(ntryL,G1H16(113),ex4(:),G1H8(100),ngZl,m3h2x8(:,208),heltab2x16(:,:,225))
  call Hloop_QA_V(ntryL,G1H16(114),ex4(:),G1H8(101),m3h2x8(:,209),heltab2x16(:,:,226))
  call Hloop_QA_Z(ntryL,G1H16(115),ex4(:),G1H8(102),ngZl,m3h2x8(:,210),heltab2x16(:,:,227))
  call Hloop_QA_W(ntryL,G1H16(116),ex4(:),G1H8(103),m3h2x8(:,211),heltab2x16(:,:,228))
  call Hloop_QA_V(ntryL,G1H16(117),ex4(:),G1H8(104),m3h2x8(:,212),heltab2x16(:,:,229))
  call Hloop_QA_Z(ntryL,G1H16(118),ex4(:),G1H8(105),ngZl,m3h2x8(:,213),heltab2x16(:,:,230))
  call Hloop_QA_V(ntryL,G1H16(119),ex4(:),G1H8(106),m3h2x8(:,214),heltab2x16(:,:,231))
  call Hloop_QA_Z(ntryL,G1H16(120),ex4(:),G1H8(107),ngZl,m3h2x8(:,215),heltab2x16(:,:,232))
  call Hloop_QA_W(ntryL,G1H16(121),ex4(:),G1H8(108),m3h2x8(:,216),heltab2x16(:,:,233))
  call Hloop_QA_W(ntryL,G1H16(122),ex4(:),G1H8(109),m3h2x8(:,217),heltab2x16(:,:,234))
  call Hloop_QA_Z(ntryL,G1H16(123),ex4(:),G1H8(110),ngZl,m3h2x8(:,218),heltab2x16(:,:,235))
  call Hloop_QA_Z(ntryL,G1H16(124),ex4(:),G1H8(111),ngZl,m3h2x8(:,219),heltab2x16(:,:,236))
  call Hloop_QA_W(ntryL,G1H16(125),ex4(:),G1H8(112),m3h2x8(:,220),heltab2x16(:,:,237))
  call Hloop_QA_W(ntryL,G1H16(126),ex4(:),G1H8(113),m3h2x8(:,221),heltab2x16(:,:,238))
  call Hloop_QA_W(ntryL,G1H16(127),ex4(:),G1H8(114),m3h2x8(:,222),heltab2x16(:,:,239))
  call Hloop_WQ_A(ntryL,G1H8(20),ex1(:),G1H4(7),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(7),39,0,G2H4(27),n2h4(157))
  call Hloop_ZQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),ngZl,m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(7),n2h4(158))
  call Hloop_ZQ_A(ntryL,G0H8(11),ex1(:),G0H4(1),ngZl,m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(8),n2h4(159))
  call Hloop_AQ_Z(ntryL,G1H16(128),ex1(:),G1H8(115),ngZl,m3h2x8(:,223),heltab2x16(:,:,240))
  call Hloop_AQ_Z(ntryL,G1H16(129),ex1(:),G1H8(116),ngZl,m3h2x8(:,224),heltab2x16(:,:,241))
  call Hloop_AV_Q(ntryL,G1H16(130),wf4(:,11),G1H4(9),m3h4x4(:,18),heltab2x16(:,:,242))
  call Hloop_A_Q(ntryL,G1H4(9),46,0,G2H4(28),n2h4(160))
  call Hloop_AV_Q(ntryL,G1H16(131),wf4(:,11),G1H4(9),m3h4x4(:,19),heltab2x16(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(9),46,0,G2H4(29),n2h4(161))
  call Hloop_AV_Q(ntryL,G1H16(132),wf4(:,11),G1H4(9),m3h4x4(:,20),heltab2x16(:,:,244))
  call Hloop_A_Q(ntryL,G1H4(9),46,0,G2H4(30),n2h4(162))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,11),G1H4(9),m3h4x4(:,21),heltab2x16(:,:,245))
  call Hloop_A_Q(ntryL,G1H4(9),46,0,G2H4(31),n2h4(163))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,9),G1H4(9),ngZl,m3h4x4(:,22),heltab2x16(:,:,246))
  call Hloop_A_Q(ntryL,G1H4(9),46,0,G2H4(32),n2h4(164))
  call Hloop_AZ_Q(ntryL,G1H16(3),wf4(:,9),G1H4(9),ngZl,m3h4x4(:,23),heltab2x16(:,:,247))
  call Hloop_A_Q(ntryL,G1H4(9),46,0,G2H4(33),n2h4(165))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,9),G1H4(9),ngZl,m3h4x4(:,24),heltab2x16(:,:,248))
  call Hloop_A_Q(ntryL,G1H4(9),46,0,G2H4(34),n2h4(166))
  call Hloop_AZ_Q(ntryL,G1H16(9),wf4(:,9),G1H4(9),ngZl,m3h4x4(:,25),heltab2x16(:,:,249))
  call Hloop_A_Q(ntryL,G1H4(9),46,0,G2H4(35),n2h4(167))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,11),G1H4(9),m3h4x4(:,26),heltab2x16(:,:,250))
  call Hloop_Q_A(ntryL,G1H4(9),39,0,G2H4(36),n2h4(168))
  call Hloop_QV_A(ntryL,G1H16(11),wf4(:,11),G1H4(9),m3h4x4(:,27),heltab2x16(:,:,251))
  call Hloop_Q_A(ntryL,G1H4(9),39,0,G2H4(37),n2h4(169))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,11),G1H4(9),m3h4x4(:,28),heltab2x16(:,:,252))
  call Hloop_Q_A(ntryL,G1H4(9),39,0,G2H4(38),n2h4(170))
  call Hloop_QV_A(ntryL,G1H16(17),wf4(:,11),G1H4(9),m3h4x4(:,29),heltab2x16(:,:,253))
  call Hloop_Q_A(ntryL,G1H4(9),39,0,G2H4(39),n2h4(171))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,9),G1H4(9),ngZl,m3h4x4(:,30),heltab2x16(:,:,254))
  call Hloop_Q_A(ntryL,G1H4(9),39,0,G2H4(40),n2h4(172))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,9),G1H4(9),ngZl,m3h4x4(:,31),heltab2x16(:,:,255))
  call Hloop_Q_A(ntryL,G1H4(9),39,0,G2H4(41),n2h4(173))
  call Hloop_QZ_A(ntryL,G1H16(20),wf4(:,9),G1H4(9),ngZl,m3h4x4(:,32),heltab2x16(:,:,256))
  call Hloop_Q_A(ntryL,G1H4(9),39,0,G2H4(42),n2h4(174))
  call Hloop_QZ_A(ntryL,G1H16(25),wf4(:,9),G1H4(9),ngZl,m3h4x4(:,33),heltab2x16(:,:,257))
  call Hloop_Q_A(ntryL,G1H4(9),39,0,G2H4(43),n2h4(175))
  call Hloop_QZ_A(ntryL,G1H16(26),wf4(:,9),G1H4(9),ngZn,m3h4x4(:,34),heltab2x16(:,:,258))
  call Hloop_Q_A(ntryL,G1H4(9),39,0,G2H4(44),n2h4(176))
  call Hloop_AQ_V(ntryL,G1H16(27),ex2(:),G1H8(117),m3h2x8(:,225),heltab2x16(:,:,259))
  call Hloop_AQ_V(ntryL,G1H16(28),ex2(:),G1H8(118),m3h2x8(:,226),heltab2x16(:,:,260))
  call Hloop_AQ_Z(ntryL,G1H16(42),ex2(:),G1H8(119),ngZl,m3h2x8(:,227),heltab2x16(:,:,261))
  call Hloop_AQ_Z(ntryL,G1H16(33),ex2(:),G1H8(120),ngZl,m3h2x8(:,228),heltab2x16(:,:,262))
  call Hloop_AQ_V(ntryL,G1H16(34),ex2(:),G1H8(121),m3h2x8(:,229),heltab2x16(:,:,263))
  call Hloop_AQ_V(ntryL,G1H16(35),ex2(:),G1H8(122),m3h2x8(:,230),heltab2x16(:,:,264))
  call Hloop_AQ_Z(ntryL,G1H16(36),ex2(:),G1H8(123),ngZl,m3h2x8(:,231),heltab2x16(:,:,265))
  call Hloop_AQ_Z(ntryL,G1H16(53),ex2(:),G1H8(124),ngZl,m3h2x8(:,232),heltab2x16(:,:,266))
  call Hloop_ZA_Q(ntryL,G0H8(13),ex3(:),G0H4(1),ngZl,m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G0H4(1),45,0,G1H4(9),n2h4(177))
  call Hloop_ZA_Q(ntryL,G0H8(14),ex3(:),G0H4(1),ngZl,m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G0H4(1),45,0,G1H4(10),n2h4(178))
  call Hloop_QA_V(ntryL,G1H16(44),ex3(:),G1H8(125),m3h2x8(:,233),heltab2x16(:,:,267))
  call Hloop_QA_Z(ntryL,G1H16(45),ex3(:),G1H8(126),ngZl,m3h2x8(:,234),heltab2x16(:,:,268))
  call Hloop_QA_V(ntryL,G1H16(46),ex3(:),G1H8(127),m3h2x8(:,235),heltab2x16(:,:,269))
  call Hloop_QA_Z(ntryL,G1H16(47),ex3(:),G1H8(128),ngZl,m3h2x8(:,236),heltab2x16(:,:,270))
  call Hloop_QA_W(ntryL,G1H16(64),ex3(:),G1H8(129),m3h2x8(:,237),heltab2x16(:,:,271))
  call Hloop_QA_V(ntryL,G1H16(55),ex3(:),G1H8(130),m3h2x8(:,238),heltab2x16(:,:,272))
  call Hloop_QA_Z(ntryL,G1H16(56),ex3(:),G1H8(131),ngZl,m3h2x8(:,239),heltab2x16(:,:,273))
  call Hloop_QA_V(ntryL,G1H16(57),ex3(:),G1H8(132),m3h2x8(:,240),heltab2x16(:,:,274))
  call Hloop_QA_Z(ntryL,G1H16(58),ex3(:),G1H8(1),ngZl,m3h2x8(:,241),heltab2x16(:,:,275))
  call Hloop_QA_W(ntryL,G1H16(75),ex3(:),G1H8(2),m3h2x8(:,242),heltab2x16(:,:,276))
  call Hloop_QA_W(ntryL,G1H16(66),ex3(:),G1H8(3),m3h2x8(:,243),heltab2x16(:,:,277))
  call Hloop_QA_Z(ntryL,G1H16(67),ex3(:),G1H8(4),ngZl,m3h2x8(:,244),heltab2x16(:,:,278))
  call Hloop_QA_Z(ntryL,G1H16(68),ex3(:),G1H8(5),ngZl,m3h2x8(:,245),heltab2x16(:,:,279))
  call Hloop_QA_W(ntryL,G1H16(69),ex3(:),G1H8(6),m3h2x8(:,246),heltab2x16(:,:,280))
  call Hloop_QA_W(ntryL,G1H16(133),ex3(:),G1H8(7),m3h2x8(:,247),heltab2x16(:,:,281))
  call Hloop_QA_W(ntryL,G1H16(134),ex3(:),G1H8(8),m3h2x8(:,248),heltab2x16(:,:,282))
  call Hloop_WQ_A(ntryL,G1H8(22),ex2(:),G1H4(11),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(11),43,0,G2H4(45),n2h4(179))
  call Hloop_ZQ_A(ntryL,G0H8(16),ex2(:),G0H4(1),ngZl,m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(11),n2h4(180))
  call Hloop_ZQ_A(ntryL,G0H8(17),ex2(:),G0H4(1),ngZl,m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(12),n2h4(181))
  call Hloop_AQ_Z(ntryL,G1H16(135),ex2(:),G1H8(11),ngZl,m3h2x8(:,249),heltab2x16(:,:,283))
  call Hloop_AQ_Z(ntryL,G1H16(136),ex2(:),G1H8(12),ngZl,m3h2x8(:,250),heltab2x16(:,:,284))
  call Hloop_AV_Q(ntryL,G1H16(137),wf4(:,10),G1H4(13),m3h4x4(:,35),heltab2x16(:,:,285))
  call Hloop_A_Q(ntryL,G1H4(13),45,0,G2H4(46),n2h4(182))
  call Hloop_AV_Q(ntryL,G1H16(138),wf4(:,10),G1H4(13),m3h4x4(:,36),heltab2x16(:,:,286))
  call Hloop_A_Q(ntryL,G1H4(13),45,0,G2H4(47),n2h4(183))
  call Hloop_AV_Q(ntryL,G1H16(139),wf4(:,10),G1H4(13),m3h4x4(:,37),heltab2x16(:,:,287))
  call Hloop_A_Q(ntryL,G1H4(13),45,0,G2H4(48),n2h4(184))
  call Hloop_AV_Q(ntryL,G1H16(140),wf4(:,10),G1H4(13),m3h4x4(:,38),heltab2x16(:,:,288))
  call Hloop_A_Q(ntryL,G1H4(13),45,0,G2H4(49),n2h4(185))
  call Hloop_AZ_Q(ntryL,G1H16(141),wf4(:,8),G1H4(13),ngZl,m3h4x4(:,39),heltab2x16(:,:,289))
  call Hloop_A_Q(ntryL,G1H4(13),45,0,G2H4(50),n2h4(186))
  call Hloop_AZ_Q(ntryL,G1H16(142),wf4(:,8),G1H4(13),ngZl,m3h4x4(:,40),heltab2x16(:,:,290))
  call Hloop_A_Q(ntryL,G1H4(13),45,0,G2H4(51),n2h4(187))
  call Hloop_AZ_Q(ntryL,G1H16(143),wf4(:,8),G1H4(13),ngZl,m3h4x4(:,41),heltab2x16(:,:,291))
  call Hloop_A_Q(ntryL,G1H4(13),45,0,G2H4(52),n2h4(188))
  call Hloop_AZ_Q(ntryL,G1H16(144),wf4(:,8),G1H4(13),ngZl,m3h4x4(:,42),heltab2x16(:,:,292))
  call Hloop_A_Q(ntryL,G1H4(13),45,0,G2H4(53),n2h4(189))
  call Hloop_QV_A(ntryL,G1H16(145),wf4(:,10),G1H4(13),m3h4x4(:,43),heltab2x16(:,:,293))
  call Hloop_Q_A(ntryL,G1H4(13),43,0,G2H4(54),n2h4(190))
  call Hloop_QV_A(ntryL,G1H16(146),wf4(:,10),G1H4(13),m3h4x4(:,44),heltab2x16(:,:,294))
  call Hloop_Q_A(ntryL,G1H4(13),43,0,G2H4(55),n2h4(191))
  call Hloop_QV_A(ntryL,G1H16(147),wf4(:,10),G1H4(13),m3h4x4(:,45),heltab2x16(:,:,295))
  call Hloop_Q_A(ntryL,G1H4(13),43,0,G2H4(56),n2h4(192))
  call Hloop_QV_A(ntryL,G1H16(148),wf4(:,10),G1H4(13),m3h4x4(:,46),heltab2x16(:,:,296))
  call Hloop_Q_A(ntryL,G1H4(13),43,0,G2H4(57),n2h4(193))
  call Hloop_QZ_A(ntryL,G1H16(149),wf4(:,8),G1H4(13),ngZl,m3h4x4(:,47),heltab2x16(:,:,297))
  call Hloop_Q_A(ntryL,G1H4(13),43,0,G2H4(58),n2h4(194))
  call Hloop_QZ_A(ntryL,G1H16(150),wf4(:,8),G1H4(13),ngZl,m3h4x4(:,48),heltab2x16(:,:,298))
  call Hloop_Q_A(ntryL,G1H4(13),43,0,G2H4(59),n2h4(195))
  call Hloop_QZ_A(ntryL,G1H16(151),wf4(:,8),G1H4(13),ngZl,m3h4x4(:,49),heltab2x16(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(13),43,0,G2H4(60),n2h4(196))
  call Hloop_QZ_A(ntryL,G1H16(152),wf4(:,8),G1H4(13),ngZl,m3h4x4(:,50),heltab2x16(:,:,300))
  call Hloop_Q_A(ntryL,G1H4(13),43,0,G2H4(61),n2h4(197))
  call Hloop_QZ_A(ntryL,G1H16(153),wf4(:,8),G1H4(13),ngZn,m3h4x4(:,51),heltab2x16(:,:,301))
  call Hloop_Q_A(ntryL,G1H4(13),43,0,G2H4(62),n2h4(198))
  call Hloop_AQ_V(ntryL,G1H16(154),ex1(:),G1H8(13),m3h2x8(:,251),heltab2x16(:,:,302))
  call Hloop_AQ_V(ntryL,G1H16(155),ex1(:),G1H8(14),m3h2x8(:,252),heltab2x16(:,:,303))
  call Hloop_AQ_Z(ntryL,G1H16(156),ex1(:),G1H8(15),ngZl,m3h2x8(:,253),heltab2x16(:,:,304))
  call Hloop_AQ_Z(ntryL,G1H16(157),ex1(:),G1H8(16),ngZl,m3h2x8(:,254),heltab2x16(:,:,305))
  call Hloop_AQ_V(ntryL,G1H16(158),ex1(:),G1H8(17),m3h2x8(:,255),heltab2x16(:,:,306))
  call Hloop_AQ_V(ntryL,G1H16(159),ex1(:),G1H8(18),m3h2x8(:,256),heltab2x16(:,:,307))
  call Hloop_AQ_Z(ntryL,G1H16(160),ex1(:),G1H8(47),ngZl,m3h2x8(:,257),heltab2x16(:,:,308))
  call Hloop_AQ_Z(ntryL,G1H16(161),ex1(:),G1H8(55),ngZl,m3h2x8(:,258),heltab2x16(:,:,309))
  call Hloop_ZA_Q(ntryL,G0H8(19),ex3(:),G0H4(1),ngZl,m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G0H4(1),46,0,G1H4(13),n2h4(199))
  call Hloop_ZA_Q(ntryL,G0H8(20),ex3(:),G0H4(1),ngZl,m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G0H4(1),46,0,G1H4(14),n2h4(200))
  call Hloop_QA_V(ntryL,G1H16(162),ex3(:),G1H8(63),m3h2x8(:,259),heltab2x16(:,:,310))
  call Hloop_QA_Z(ntryL,G1H16(163),ex3(:),G1H8(73),ngZl,m3h2x8(:,260),heltab2x16(:,:,311))
  call Hloop_QA_V(ntryL,G1H16(164),ex3(:),G1H8(9),m3h2x8(:,261),heltab2x16(:,:,312))
  call Hloop_QA_Z(ntryL,G1H16(165),ex3(:),G1H8(19),ngZl,m3h2x8(:,262),heltab2x16(:,:,313))
  call Hloop_QA_W(ntryL,G1H16(166),ex3(:),G1H8(21),m3h2x8(:,263),heltab2x16(:,:,314))
  call Hloop_QA_V(ntryL,G1H16(167),ex3(:),G1H8(23),m3h2x8(:,264),heltab2x16(:,:,315))
  call Hloop_QA_Z(ntryL,G1H16(168),ex3(:),G1H8(10),ngZl,m3h2x8(:,265),heltab2x16(:,:,316))
  call Hloop_QA_V(ntryL,G1H16(169),ex3(:),G1H8(20),m3h2x8(:,266),heltab2x16(:,:,317))
  call Hloop_QA_Z(ntryL,G1H16(170),ex3(:),G1H8(22),ngZl,m3h2x8(:,267),heltab2x16(:,:,318))
  call Hloop_QA_W(ntryL,G1H16(171),ex3(:),G1H8(133),m3h2x8(:,268),heltab2x16(:,:,319))
  call Hloop_QA_W(ntryL,G1H16(172),ex3(:),G1H8(134),m3h2x8(:,269),heltab2x16(:,:,320))
  call Hloop_QA_Z(ntryL,G1H16(173),ex3(:),G1H8(135),ngZl,m3h2x8(:,270),heltab2x16(:,:,321))
  call Hloop_QA_Z(ntryL,G1H16(174),ex3(:),G1H8(136),ngZl,m3h2x8(:,271),heltab2x16(:,:,322))
  call Hloop_QA_W(ntryL,G1H16(175),ex3(:),G1H8(137),m3h2x8(:,272),heltab2x16(:,:,323))
  call Hloop_QA_W(ntryL,G1H16(176),ex3(:),G1H8(138),m3h2x8(:,273),heltab2x16(:,:,324))
  call Hloop_QA_W(ntryL,G1H16(177),ex3(:),G1H8(139),m3h2x8(:,274),heltab2x16(:,:,325))
  call Hloop_WQ_A(ntryL,G1H8(24),ex1(:),G1H4(15),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_Q_A(ntryL,G1H4(15),43,0,G2H4(63),n2h4(201))
  call Hloop_ZQ_A(ntryL,G0H8(22),ex1(:),G0H4(1),ngZl,m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(15),n2h4(202))
  call Hloop_ZQ_A(ntryL,G0H8(23),ex1(:),G0H4(1),ngZl,m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(16),n2h4(203))
  call Hloop_AQ_Z(ntryL,G1H16(178),ex1(:),G1H8(24),ngZl,m3h2x8(:,275),heltab2x16(:,:,326))
  call Hloop_AQ_Z(ntryL,G1H16(179),ex1(:),G1H8(140),ngZl,m3h2x8(:,276),heltab2x16(:,:,327))
  call Hloop_AV_Q(ntryL,G1H16(180),wf4(:,5),G1H4(17),m3h4x4(:,52),heltab2x16(:,:,328))
  call Hloop_A_Q(ntryL,G1H4(17),46,0,G2H4(64),n2h4(204))
  call Hloop_AV_Q(ntryL,G1H16(181),wf4(:,5),G1H4(17),m3h4x4(:,53),heltab2x16(:,:,329))
  call Hloop_A_Q(ntryL,G1H4(17),46,0,G2H4(65),n2h4(205))
  call Hloop_AV_Q(ntryL,G1H16(182),wf4(:,5),G1H4(17),m3h4x4(:,54),heltab2x16(:,:,330))
  call Hloop_A_Q(ntryL,G1H4(17),46,0,G2H4(66),n2h4(206))
  call Hloop_AV_Q(ntryL,G1H16(183),wf4(:,5),G1H4(17),m3h4x4(:,55),heltab2x16(:,:,331))
  call Hloop_A_Q(ntryL,G1H4(17),46,0,G2H4(67),n2h4(207))
  call Hloop_AZ_Q(ntryL,G1H16(184),wf4(:,2),G1H4(17),ngZl,m3h4x4(:,56),heltab2x16(:,:,332))
  call Hloop_A_Q(ntryL,G1H4(17),46,0,G2H4(68),n2h4(208))
  call Hloop_AZ_Q(ntryL,G1H16(185),wf4(:,2),G1H4(17),ngZl,m3h4x4(:,57),heltab2x16(:,:,333))
  call Hloop_A_Q(ntryL,G1H4(17),46,0,G2H4(69),n2h4(209))
  call Hloop_AZ_Q(ntryL,G1H16(186),wf4(:,2),G1H4(17),ngZl,m3h4x4(:,58),heltab2x16(:,:,334))
  call Hloop_A_Q(ntryL,G1H4(17),46,0,G2H4(70),n2h4(210))
  call Hloop_AZ_Q(ntryL,G1H16(187),wf4(:,2),G1H4(17),ngZl,m3h4x4(:,59),heltab2x16(:,:,335))
  call Hloop_A_Q(ntryL,G1H4(17),46,0,G2H4(71),n2h4(211))
  call Hloop_QV_A(ntryL,G1H16(188),wf4(:,5),G1H4(17),m3h4x4(:,60),heltab2x16(:,:,336))
  call Hloop_Q_A(ntryL,G1H4(17),43,0,G2H4(72),n2h4(212))
  call Hloop_QV_A(ntryL,G1H16(189),wf4(:,5),G1H4(17),m3h4x4(:,61),heltab2x16(:,:,337))
  call Hloop_Q_A(ntryL,G1H4(17),43,0,G2H4(73),n2h4(213))
  call Hloop_QV_A(ntryL,G1H16(190),wf4(:,5),G1H4(17),m3h4x4(:,62),heltab2x16(:,:,338))
  call Hloop_Q_A(ntryL,G1H4(17),43,0,G2H4(74),n2h4(214))
  call Hloop_QV_A(ntryL,G1H16(191),wf4(:,5),G1H4(17),m3h4x4(:,63),heltab2x16(:,:,339))
  call Hloop_Q_A(ntryL,G1H4(17),43,0,G2H4(75),n2h4(215))
  call Hloop_QZ_A(ntryL,G1H16(192),wf4(:,2),G1H4(17),ngZl,m3h4x4(:,64),heltab2x16(:,:,340))
  call Hloop_Q_A(ntryL,G1H4(17),43,0,G2H4(76),n2h4(216))
  call Hloop_QZ_A(ntryL,G1H16(193),wf4(:,2),G1H4(17),ngZl,m3h4x4(:,65),heltab2x16(:,:,341))
  call Hloop_Q_A(ntryL,G1H4(17),43,0,G2H4(77),n2h4(217))
  call Hloop_QZ_A(ntryL,G1H16(194),wf4(:,2),G1H4(17),ngZl,m3h4x4(:,66),heltab2x16(:,:,342))
  call Hloop_Q_A(ntryL,G1H4(17),43,0,G2H4(78),n2h4(218))
  call Hloop_QZ_A(ntryL,G1H16(195),wf4(:,2),G1H4(17),ngZl,m3h4x4(:,67),heltab2x16(:,:,343))
  call Hloop_Q_A(ntryL,G1H4(17),43,0,G2H4(79),n2h4(219))
  call Hloop_QZ_A(ntryL,G1H16(196),wf4(:,2),G1H4(17),ngZn,m3h4x4(:,68),heltab2x16(:,:,344))
  call Hloop_Q_A(ntryL,G1H4(17),43,0,G2H4(80),n2h4(220))
  call Hloop_AQ_V(ntryL,G1H8(25),ex1(:),G1H4(17),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_AQ_Z(ntryL,G1H8(26),ex1(:),G1H4(18),ngZl,m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_VQ_A(ntryL,G1H8(27),ex1(:),G1H4(19),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(19),51,0,G2H4(81),n2h4(221))
  call Hloop_VQ_A(ntryL,G1H8(28),ex1(:),G1H4(19),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(19),51,0,G2H4(82),n2h4(222))
  call Hloop_ZQ_A(ntryL,G1H8(29),ex1(:),G1H4(19),ngZl,m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(19),51,0,G2H4(83),n2h4(223))
  call Hloop_ZQ_A(ntryL,G1H8(30),ex1(:),G1H4(19),ngZl,m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(19),51,0,G2H4(84),n2h4(224))
  call Hloop_AQ_V(ntryL,G1H8(31),ex2(:),G1H4(19),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_AQ_Z(ntryL,G1H8(32),ex2(:),G1H4(20),ngZl,m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_VQ_A(ntryL,G1H8(33),ex1(:),G1H4(21),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(85),n2h4(225))
  call Hloop_VQ_A(ntryL,G1H8(34),ex1(:),G1H4(21),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(86),n2h4(226))
  call Hloop_ZQ_A(ntryL,G1H8(35),ex1(:),G1H4(21),ngZl,m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(87),n2h4(227))
  call Hloop_ZQ_A(ntryL,G1H8(36),ex1(:),G1H4(21),ngZl,m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(88),n2h4(228))
  call Hloop_VQ_A(ntryL,G1H8(37),ex2(:),G1H4(21),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(89),n2h4(229))
  call Hloop_VQ_A(ntryL,G1H8(38),ex2(:),G1H4(21),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(90),n2h4(230))
  call Hloop_ZQ_A(ntryL,G1H8(39),ex2(:),G1H4(21),ngZl,m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(91),n2h4(231))
  call Hloop_ZQ_A(ntryL,G1H8(40),ex2(:),G1H4(21),ngZl,m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(92),n2h4(232))
  call Hloop_VQ_A(ntryL,G1H8(41),ex2(:),G1H4(21),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(93),n2h4(233))
  call Hloop_VQ_A(ntryL,G1H8(42),ex2(:),G1H4(21),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(94),n2h4(234))
  call Hloop_ZQ_A(ntryL,G1H8(43),ex2(:),G1H4(21),ngZl,m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(95),n2h4(235))
  call Hloop_ZQ_A(ntryL,G1H8(44),ex2(:),G1H4(21),ngZl,m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(96),n2h4(236))
  call Hloop_QA_V(ntryL,G1H8(45),ex3(:),G1H4(21),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_QA_Z(ntryL,G1H8(46),ex3(:),G1H4(22),ngZl,m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_QA_W(ntryL,G2H8(17),ex3(:),G2H4(97),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_VA_Q(ntryL,G1H8(48),ex3(:),G1H4(23),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(23),54,0,G2H4(98),n2h4(237))
  call Hloop_ZA_Q(ntryL,G1H8(49),ex3(:),G1H4(23),ngZl,m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(23),54,0,G2H4(99),n2h4(238))
  call Hloop_VA_Q(ntryL,G1H8(50),ex3(:),G1H4(23),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(23),54,0,G2H4(100),n2h4(239))
  call Hloop_ZA_Q(ntryL,G1H8(51),ex3(:),G1H4(23),ngZl,m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G1H4(23),54,0,G2H4(101),n2h4(240))
  call Hloop_WA_Q(ntryL,G1H8(52),ex3(:),G1H4(23),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(23),54,0,G2H4(102),n2h4(241))
  call Hloop_QA_V(ntryL,G1H8(53),ex4(:),G1H4(23),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_QA_Z(ntryL,G1H8(54),ex4(:),G1H4(24),ngZl,m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_QA_W(ntryL,G2H8(18),ex4(:),G2H4(103),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_VA_Q(ntryL,G1H8(56),ex4(:),G1H4(25),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H4(25),58,0,G2H4(104),n2h4(242))
  call Hloop_ZA_Q(ntryL,G1H8(57),ex4(:),G1H4(25),ngZl,m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H4(25),58,0,G2H4(105),n2h4(243))
  call Hloop_VA_Q(ntryL,G1H8(58),ex4(:),G1H4(25),m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_A_Q(ntryL,G1H4(25),58,0,G2H4(106),n2h4(244))
  call Hloop_ZA_Q(ntryL,G1H8(59),ex4(:),G1H4(25),ngZl,m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G1H4(25),58,0,G2H4(107),n2h4(245))
  call Hloop_WA_Q(ntryL,G1H8(60),ex4(:),G1H4(25),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_A_Q(ntryL,G1H4(25),58,0,G2H4(108),n2h4(246))
  call Hloop_QA_V(ntryL,G1H8(61),ex3(:),G1H4(25),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_QA_Z(ntryL,G1H8(62),ex3(:),G1H4(26),ngZl,m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_QA_W(ntryL,G2H8(19),ex3(:),G2H4(109),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_VA_Q(ntryL,G1H8(64),ex3(:),G1H4(27),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G1H4(27),53,0,G2H4(110),n2h4(247))
  call Hloop_VA_Q(ntryL,G1H8(65),ex3(:),G1H4(27),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_A_Q(ntryL,G1H4(27),53,0,G2H4(111),n2h4(248))
  call Hloop_ZA_Q(ntryL,G1H8(66),ex3(:),G1H4(27),ngZl,m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_A_Q(ntryL,G1H4(27),53,0,G2H4(112),n2h4(249))
  call Hloop_ZA_Q(ntryL,G1H8(67),ex3(:),G1H4(27),ngZl,m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(27),53,0,G2H4(113),n2h4(250))
  call Hloop_WA_Q(ntryL,G1H8(68),ex3(:),G1H4(27),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(27),53,0,G2H4(114),n2h4(251))
  call Hloop_QA_V(ntryL,G1H8(69),ex3(:),G1H4(27),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_QA_Z(ntryL,G1H8(70),ex3(:),G1H4(28),ngZl,m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_QA_V(ntryL,G1H8(71),ex4(:),G1H4(29),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_QA_Z(ntryL,G1H8(72),ex4(:),G1H4(30),ngZl,m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_QA_W(ntryL,G2H8(20),ex4(:),G2H4(115),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_VA_Q(ntryL,G1H8(74),ex4(:),G1H4(31),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_A_Q(ntryL,G1H4(31),57,0,G2H4(116),n2h4(252))
  call Hloop_VA_Q(ntryL,G1H8(75),ex4(:),G1H4(31),m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_A_Q(ntryL,G1H4(31),57,0,G2H4(117),n2h4(253))
  call Hloop_ZA_Q(ntryL,G1H8(76),ex4(:),G1H4(31),ngZl,m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_A_Q(ntryL,G1H4(31),57,0,G2H4(118),n2h4(254))
  call Hloop_ZA_Q(ntryL,G1H8(77),ex4(:),G1H4(31),ngZl,m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_A_Q(ntryL,G1H4(31),57,0,G2H4(119),n2h4(255))
  call Hloop_WA_Q(ntryL,G1H8(78),ex4(:),G1H4(31),m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(31),57,0,G2H4(120),n2h4(256))
  call Hloop_QA_V(ntryL,G1H8(79),ex4(:),G1H4(31),m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_QA_Z(ntryL,G1H8(80),ex4(:),G1H4(32),ngZl,m3h2x4(:,216),heltab2x8(:,:,216))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G2H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G2H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G2H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(58),[G2H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G2H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G2H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G2H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G2H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G2H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G2H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G2H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(77),[G2H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G2H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(79),[G2H4(75)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(17),mass5set(:,6),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(17),mass5set(:,7),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(17),mass5set(:,8),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(46),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(17),mass5set(:,9),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(52),8,4)
  call Hloop_AQ_V(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_AQ_Z(ntryL,G1H4(2),ex2(:),G1H2(2),ngZl,m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_VQ_A(ntryL,G1H8(81),ex5(:),G1H4(1),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(1),58,nMB,G2H4(121),n2h4(257))
  call Hloop_ZQ_A(ntryL,G1H8(82),ex5(:),G1H4(2),ngZd,m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(2),58,nMB,G2H4(122),n2h4(258))
  call Hloop_VQ_A(ntryL,G1H8(83),ex5(:),G1H4(1),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_Q_A(ntryL,G1H4(1),58,nMB,G2H4(123),n2h4(259))
  call Hloop_ZQ_A(ntryL,G1H8(84),ex5(:),G1H4(2),ngZd,m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(2),58,nMB,G2H4(124),n2h4(260))
  call Hloop_WQ_A(ntryL,G1H8(85),ex5(:),G1H4(1),m3h2x4(:,221),heltab2x8(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(1),58,nMT,G2H4(125),n2h4(261))
  call Hloop_VQ_A(ntryL,G1H8(86),ex5(:),G1H4(2),m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_Q_A(ntryL,G1H4(2),58,nMB,G2H4(126),n2h4(262))
  call Hloop_ZQ_A(ntryL,G1H8(87),ex5(:),G1H4(1),ngZd,m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(1),58,nMB,G2H4(127),n2h4(263))
  call Hloop_VQ_A(ntryL,G1H8(88),ex5(:),G1H4(2),m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G1H4(2),58,nMB,G2H4(128),n2h4(264))
  call Hloop_ZQ_A(ntryL,G1H8(89),ex5(:),G1H4(1),ngZd,m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G1H4(1),58,nMB,G2H4(129),n2h4(265))
  call Hloop_WQ_A(ntryL,G1H8(90),ex5(:),G1H4(2),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_Q_A(ntryL,G1H4(2),58,nMT,G2H4(130),n2h4(266))
  call Hloop_VV_S(ntryL,G1H8(91),wf4(:,4),G1H2(7),m3h4x2(:,1),heltab2x8(:,:,227))
  call Hloop_VV_S(ntryL,G1H8(92),wf4(:,1),G1H2(8),m3h4x2(:,2),heltab2x8(:,:,228))
  call Hloop_VV_S(ntryL,G1H8(93),wf4(:,1),G1H2(13),m3h4x2(:,3),heltab2x8(:,:,229))
  call Hloop_VV_S(ntryL,G1H8(94),wf4(:,1),G1H2(14),m3h4x2(:,4),heltab2x8(:,:,230))
  call Hloop_UW_V(ntryL,G1H8(95),42,wf4(:,4),5,G2H2(1),m3h4x2(:,5),heltab2x8(:,:,231))
  call Hloop_UW_V(ntryL,G1H8(96),42,wf4(:,1),5,G2H2(2),m3h4x2(:,6),heltab2x8(:,:,232))
  call Hloop_QA_W(ntryL,G2H4(5),ex4(:),G2H2(3),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_QA_V(ntryL,G1H4(3),ex4(:),G1H2(19),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_QA_Z(ntryL,G1H4(4),ex4(:),G1H2(20),ngZl,m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_VV_S(ntryL,G1H8(97),wf4(:,1),G1H2(25),m3h4x2(:,7),heltab2x8(:,:,233))
  call Hloop_VV_S(ntryL,G1H8(98),wf4(:,1),G1H2(26),m3h4x2(:,8),heltab2x8(:,:,234))
  call Hloop_AQ_V(ntryL,G2H4(10),ex2(:),G2H2(4),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_AQ_V(ntryL,G2H4(11),ex2(:),G2H2(5),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_AQ_Z(ntryL,G2H4(12),ex2(:),G2H2(6),ngZl,m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_AQ_Z(ntryL,G2H4(13),ex2(:),G2H2(7),ngZl,m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_QA_V(ntryL,G2H4(18),ex4(:),G2H2(8),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_QA_Z(ntryL,G2H4(19),ex4(:),G2H2(9),ngZl,m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_QA_V(ntryL,G2H4(20),ex4(:),G2H2(10),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_QA_Z(ntryL,G2H4(21),ex4(:),G2H2(11),ngZl,m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_QA_W(ntryL,G2H4(22),ex4(:),G2H2(12),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(18),mass5set(:,6),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(18),mass5set(:,7),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(60),8,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(18),mass5set(:,8),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(18),mass5set(:,9),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),8,4)
  call Hloop_AQ_V(ntryL,G1H4(5),ex1(:),G1H2(31),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_AQ_Z(ntryL,G1H4(6),ex1(:),G1H2(32),ngZl,m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_VQ_A(ntryL,G1H8(99),ex5(:),G1H4(5),m3h2x4(:,227),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H4(5),57,nMB,G2H4(131),n2h4(267))
  call Hloop_ZQ_A(ntryL,G1H8(100),ex5(:),G1H4(6),ngZd,m3h2x4(:,228),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H4(6),57,nMB,G2H4(132),n2h4(268))
  call Hloop_VQ_A(ntryL,G1H8(101),ex5(:),G1H4(5),m3h2x4(:,229),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H4(5),57,nMB,G2H4(6),n2h4(269))
  call Hloop_ZQ_A(ntryL,G1H8(102),ex5(:),G1H4(6),ngZd,m3h2x4(:,230),heltab2x8(:,:,238))
  call Hloop_Q_A(ntryL,G1H4(6),57,nMB,G2H4(7),n2h4(270))
  call Hloop_WQ_A(ntryL,G1H8(103),ex5(:),G1H4(5),m3h2x4(:,231),heltab2x8(:,:,239))
  call Hloop_Q_A(ntryL,G1H4(5),57,nMT,G2H4(8),n2h4(271))
  call Hloop_VQ_A(ntryL,G1H8(104),ex5(:),G1H4(6),m3h2x4(:,232),heltab2x8(:,:,240))
  call Hloop_Q_A(ntryL,G1H4(6),57,nMB,G2H4(9),n2h4(272))
  call Hloop_ZQ_A(ntryL,G1H8(105),ex5(:),G1H4(5),ngZd,m3h2x4(:,233),heltab2x8(:,:,241))
  call Hloop_Q_A(ntryL,G1H4(5),57,nMB,G2H4(14),n2h4(273))
  call Hloop_VQ_A(ntryL,G1H8(106),ex5(:),G1H4(6),m3h2x4(:,234),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G1H4(6),57,nMB,G2H4(15),n2h4(274))
  call Hloop_ZQ_A(ntryL,G1H8(107),ex5(:),G1H4(5),ngZd,m3h2x4(:,235),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G1H4(5),57,nMB,G2H4(16),n2h4(275))
  call Hloop_WQ_A(ntryL,G1H8(108),ex5(:),G1H4(6),m3h2x4(:,236),heltab2x8(:,:,244))
  call Hloop_Q_A(ntryL,G1H4(6),57,nMT,G2H4(17),n2h4(276))
  call Hloop_VV_S(ntryL,G1H8(109),wf4(:,11),G1H2(37),m3h4x2(:,9),heltab2x8(:,:,245))
  call Hloop_VV_S(ntryL,G1H8(110),wf4(:,9),G1H2(38),m3h4x2(:,10),heltab2x8(:,:,246))
  call Hloop_VV_S(ntryL,G1H8(111),wf4(:,9),G1H2(43),m3h4x2(:,11),heltab2x8(:,:,247))
  call Hloop_VV_S(ntryL,G1H8(112),wf4(:,9),G1H2(44),m3h4x2(:,12),heltab2x8(:,:,248))
  call Hloop_UW_V(ntryL,G1H8(113),41,wf4(:,11),6,G2H2(13),m3h4x2(:,13),heltab2x8(:,:,249))
  call Hloop_UW_V(ntryL,G1H8(114),41,wf4(:,9),6,G2H2(14),m3h4x2(:,14),heltab2x8(:,:,250))
  call Hloop_QA_W(ntryL,G2H4(27),ex4(:),G2H2(15),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_QA_V(ntryL,G1H4(7),ex4(:),G1H2(49),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_QA_Z(ntryL,G1H4(8),ex4(:),G1H2(50),ngZl,m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_VV_S(ntryL,G1H8(115),wf4(:,9),G1H2(55),m3h4x2(:,15),heltab2x8(:,:,251))
  call Hloop_VV_S(ntryL,G1H8(116),wf4(:,9),G1H2(56),m3h4x2(:,16),heltab2x8(:,:,252))
  call Hloop_AQ_V(ntryL,G2H4(32),ex1(:),G2H2(16),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_AQ_V(ntryL,G2H4(33),ex1(:),G2H2(17),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_AQ_Z(ntryL,G2H4(34),ex1(:),G2H2(18),ngZl,m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_AQ_Z(ntryL,G2H4(35),ex1(:),G2H2(19),ngZl,m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_QA_V(ntryL,G2H4(40),ex4(:),G2H2(20),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_QA_Z(ntryL,G2H4(41),ex4(:),G2H2(21),ngZl,m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_QA_V(ntryL,G2H4(42),ex4(:),G2H2(22),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_QA_Z(ntryL,G2H4(43),ex4(:),G2H2(23),ngZl,m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_QA_W(ntryL,G2H4(44),ex4(:),G2H2(24),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_VQ_A(ntryL,G1H8(117),ex5(:),G1H4(5),m3h2x4(:,237),heltab2x8(:,:,253))
  call Hloop_Q_A(ntryL,G1H4(5),54,nMB,G2H4(28),n2h4(277))
  call Hloop_VQ_A(ntryL,G1H8(118),ex5(:),G1H4(6),m3h2x4(:,238),heltab2x8(:,:,254))
  call Hloop_Q_A(ntryL,G1H4(6),54,nMB,G2H4(29),n2h4(278))
  call Hloop_ZQ_A(ntryL,G1H8(119),ex5(:),G1H4(7),ngZd,m3h2x4(:,239),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G1H4(7),54,nMB,G2H4(30),n2h4(279))
  call Hloop_ZQ_A(ntryL,G1H8(120),ex5(:),G1H4(8),ngZd,m3h2x4(:,240),heltab2x8(:,:,256))
  call Hloop_Q_A(ntryL,G1H4(8),54,nMB,G2H4(31),n2h4(280))
  call Hloop_VQ_A(ntryL,G1H8(121),ex5(:),G1H4(5),m3h2x4(:,241),heltab2x8(:,:,257))
  call Hloop_Q_A(ntryL,G1H4(5),54,nMB,G2H4(36),n2h4(281))
  call Hloop_VQ_A(ntryL,G1H8(122),ex5(:),G1H4(6),m3h2x4(:,242),heltab2x8(:,:,258))
  call Hloop_Q_A(ntryL,G1H4(6),54,nMB,G2H4(37),n2h4(282))
  call Hloop_ZQ_A(ntryL,G1H8(123),ex5(:),G1H4(7),ngZd,m3h2x4(:,243),heltab2x8(:,:,259))
  call Hloop_Q_A(ntryL,G1H4(7),54,nMB,G2H4(38),n2h4(283))
  call Hloop_ZQ_A(ntryL,G1H8(124),ex5(:),G1H4(8),ngZd,m3h2x4(:,244),heltab2x8(:,:,260))
  call Hloop_Q_A(ntryL,G1H4(8),54,nMB,G2H4(39),n2h4(284))
  call Hloop_AQ_V(ntryL,G1H4(9),ex2(:),G1H2(61),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_AQ_Z(ntryL,G1H4(10),ex2(:),G1H2(62),ngZl,m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_VQ_A(ntryL,G1H8(125),ex5(:),G1H4(5),m3h2x4(:,245),heltab2x8(:,:,261))
  call Hloop_Q_A(ntryL,G1H4(5),54,nMB,G2H4(46),n2h4(285))
  call Hloop_ZQ_A(ntryL,G1H8(126),ex5(:),G1H4(6),ngZd,m3h2x4(:,246),heltab2x8(:,:,262))
  call Hloop_Q_A(ntryL,G1H4(6),54,nMB,G2H4(47),n2h4(286))
  call Hloop_VQ_A(ntryL,G1H8(127),ex5(:),G1H4(7),m3h2x4(:,247),heltab2x8(:,:,263))
  call Hloop_Q_A(ntryL,G1H4(7),54,nMB,G2H4(48),n2h4(287))
  call Hloop_ZQ_A(ntryL,G1H8(128),ex5(:),G1H4(8),ngZd,m3h2x4(:,248),heltab2x8(:,:,264))
  call Hloop_Q_A(ntryL,G1H4(8),54,nMB,G2H4(49),n2h4(288))
  call Hloop_WQ_A(ntryL,G1H8(129),ex5(:),G1H4(9),m3h2x4(:,249),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G1H4(9),54,nMT,G2H4(54),n2h4(289))
  call Hloop_VQ_A(ntryL,G1H8(130),ex5(:),G1H4(10),m3h2x4(:,250),heltab2x8(:,:,266))
  call Hloop_Q_A(ntryL,G1H4(10),54,nMB,G2H4(55),n2h4(290))
  call Hloop_ZQ_A(ntryL,G1H8(131),ex5(:),G1H4(5),ngZd,m3h2x4(:,251),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(5),54,nMB,G2H4(56),n2h4(291))
  call Hloop_VQ_A(ntryL,G1H8(132),ex5(:),G1H4(6),m3h2x4(:,252),heltab2x8(:,:,268))
  call Hloop_Q_A(ntryL,G1H4(6),54,nMB,G2H4(57),n2h4(292))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex5(:),G1H4(7),ngZd,m3h2x4(:,253),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G1H4(7),54,nMB,G2H4(64),n2h4(293))
  call Hloop_WQ_A(ntryL,G1H8(2),ex5(:),G1H4(8),m3h2x4(:,254),heltab2x8(:,:,270))
  call Hloop_Q_A(ntryL,G1H4(8),54,nMT,G2H4(65),n2h4(294))
  call Hloop_VV_S(ntryL,G1H8(3),wf4(:,10),G1H2(67),m3h4x2(:,17),heltab2x8(:,:,271))
  call Hloop_VV_S(ntryL,G1H8(4),wf4(:,8),G1H2(68),m3h4x2(:,18),heltab2x8(:,:,272))
  call Hloop_VV_S(ntryL,G1H8(5),wf4(:,8),G1H2(73),m3h4x2(:,19),heltab2x8(:,:,273))
  call Hloop_VV_S(ntryL,G1H8(6),wf4(:,8),G1H2(74),m3h4x2(:,20),heltab2x8(:,:,274))
  call Hloop_UW_V(ntryL,G1H8(7),38,wf4(:,10),9,G2H2(25),m3h4x2(:,21),heltab2x8(:,:,275))
  call Hloop_UW_V(ntryL,G1H8(8),38,wf4(:,8),9,G2H2(26),m3h4x2(:,22),heltab2x8(:,:,276))
  call Hloop_QA_W(ntryL,G2H4(45),ex3(:),G2H2(27),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_QA_V(ntryL,G1H4(11),ex3(:),G1H2(79),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_QA_Z(ntryL,G1H4(12),ex3(:),G1H2(80),ngZl,m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_VV_S(ntryL,G1H8(11),wf4(:,8),G1H2(85),m3h4x2(:,23),heltab2x8(:,:,277))
  call Hloop_VV_S(ntryL,G1H8(12),wf4(:,8),G1H2(86),m3h4x2(:,24),heltab2x8(:,:,278))
  call Hloop_AQ_V(ntryL,G2H4(50),ex2(:),G2H2(28),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_AQ_V(ntryL,G2H4(51),ex2(:),G2H2(29),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_AQ_Z(ntryL,G2H4(52),ex2(:),G2H2(30),ngZl,m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_AQ_Z(ntryL,G2H4(53),ex2(:),G2H2(31),ngZl,m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_QA_V(ntryL,G2H4(58),ex3(:),G2H2(32),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_QA_Z(ntryL,G2H4(59),ex3(:),G2H2(33),ngZl,m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_QA_V(ntryL,G2H4(60),ex3(:),G2H2(34),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_QA_Z(ntryL,G2H4(61),ex3(:),G2H2(35),ngZl,m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_QA_W(ntryL,G2H4(62),ex3(:),G2H2(36),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_VQ_A(ntryL,G1H8(13),ex5(:),G1H4(9),m3h2x4(:,255),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G1H4(9),53,nMB,G2H4(66),n2h4(295))
  call Hloop_VQ_A(ntryL,G1H8(14),ex5(:),G1H4(10),m3h2x4(:,256),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G1H4(10),53,nMB,G2H4(67),n2h4(296))
  call Hloop_ZQ_A(ntryL,G1H8(15),ex5(:),G1H4(5),ngZd,m3h2x4(:,257),heltab2x8(:,:,281))
  call Hloop_Q_A(ntryL,G1H4(5),53,nMB,G2H4(72),n2h4(297))
  call Hloop_ZQ_A(ntryL,G1H8(16),ex5(:),G1H4(6),ngZd,m3h2x4(:,258),heltab2x8(:,:,282))
  call Hloop_Q_A(ntryL,G1H4(6),53,nMB,G2H4(73),n2h4(298))
  call Hloop_VQ_A(ntryL,G1H8(17),ex5(:),G1H4(7),m3h2x4(:,259),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMB,G2H4(74),n2h4(299))
  call Hloop_VQ_A(ntryL,G1H8(18),ex5(:),G1H4(8),m3h2x4(:,260),heltab2x8(:,:,284))
  call Hloop_Q_A(ntryL,G1H4(8),53,nMB,G2H4(75),n2h4(300))
  call Hloop_ZQ_A(ntryL,G1H8(47),ex5(:),G1H4(11),ngZd,m3h2x4(:,261),heltab2x8(:,:,285))
  call Hloop_Q_A(ntryL,G1H4(11),53,nMB,G2H4(1),n2h4(301))
  call Hloop_ZQ_A(ntryL,G1H8(55),ex5(:),G1H4(12),ngZd,m3h2x4(:,262),heltab2x8(:,:,286))
  call Hloop_Q_A(ntryL,G1H4(12),53,nMB,G2H4(2),n2h4(302))
  call Hloop_AQ_V(ntryL,G1H4(13),ex1(:),G1H2(91),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_AQ_Z(ntryL,G1H4(14),ex1(:),G1H2(92),ngZl,m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_VQ_A(ntryL,G1H8(63),ex5(:),G1H4(9),m3h2x4(:,263),heltab2x8(:,:,287))
  call Hloop_Q_A(ntryL,G1H4(9),53,nMB,G2H4(3),n2h4(303))
  call Hloop_ZQ_A(ntryL,G1H8(73),ex5(:),G1H4(10),ngZd,m3h2x4(:,264),heltab2x8(:,:,288))
  call Hloop_Q_A(ntryL,G1H4(10),53,nMB,G2H4(4),n2h4(304))
  call Hloop_VQ_A(ntryL,G1H8(9),ex5(:),G1H4(5),m3h2x4(:,265),heltab2x8(:,:,289))
  call Hloop_Q_A(ntryL,G1H4(5),53,nMB,G2H4(5),n2h4(305))
  call Hloop_ZQ_A(ntryL,G1H8(19),ex5(:),G1H4(6),ngZd,m3h2x4(:,266),heltab2x8(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(6),53,nMB,G2H4(10),n2h4(306))
  call Hloop_WQ_A(ntryL,G1H8(21),ex5(:),G1H4(7),m3h2x4(:,267),heltab2x8(:,:,291))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(11),n2h4(307))
  call Hloop_VQ_A(ntryL,G1H8(23),ex5(:),G1H4(8),m3h2x4(:,268),heltab2x8(:,:,292))
  call Hloop_Q_A(ntryL,G1H4(8),53,nMB,G2H4(12),n2h4(308))
  call Hloop_ZQ_A(ntryL,G1H8(10),ex5(:),G1H4(11),ngZd,m3h2x4(:,269),heltab2x8(:,:,293))
  call Hloop_Q_A(ntryL,G1H4(11),53,nMB,G2H4(13),n2h4(309))
  call Hloop_VQ_A(ntryL,G1H8(20),ex5(:),G1H4(12),m3h2x4(:,270),heltab2x8(:,:,294))
  call Hloop_Q_A(ntryL,G1H4(12),53,nMB,G2H4(18),n2h4(310))
  call Hloop_ZQ_A(ntryL,G1H8(22),ex5(:),G1H4(13),ngZd,m3h2x4(:,271),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G1H4(13),53,nMB,G2H4(19),n2h4(311))
  call Hloop_WQ_A(ntryL,G1H8(133),ex5(:),G1H4(14),m3h2x4(:,272),heltab2x8(:,:,296))
  call Hloop_Q_A(ntryL,G1H4(14),53,nMT,G2H4(20),n2h4(312))
  call Hloop_VV_S(ntryL,G1H8(134),wf4(:,5),G1H2(97),m3h4x2(:,25),heltab2x8(:,:,297))
  call Hloop_VV_S(ntryL,G1H8(135),wf4(:,2),G1H2(98),m3h4x2(:,26),heltab2x8(:,:,298))
  call Hloop_VV_S(ntryL,G1H8(136),wf4(:,2),G1H2(103),m3h4x2(:,27),heltab2x8(:,:,299))
  call Hloop_VV_S(ntryL,G1H8(137),wf4(:,2),G1H2(104),m3h4x2(:,28),heltab2x8(:,:,300))
  call Hloop_UW_V(ntryL,G1H8(138),37,wf4(:,5),10,G2H2(37),m3h4x2(:,29),heltab2x8(:,:,301))
  call Hloop_UW_V(ntryL,G1H8(139),37,wf4(:,2),10,G2H2(38),m3h4x2(:,30),heltab2x8(:,:,302))
  call Hloop_QA_W(ntryL,G2H4(63),ex3(:),G2H2(39),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_QA_V(ntryL,G1H4(15),ex3(:),G1H2(109),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_QA_Z(ntryL,G1H4(16),ex3(:),G1H2(110),ngZl,m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_VV_S(ntryL,G1H8(24),wf4(:,2),G1H2(115),m3h4x2(:,31),heltab2x8(:,:,303))
  call Hloop_VV_S(ntryL,G1H8(140),wf4(:,2),G1H2(116),m3h4x2(:,32),heltab2x8(:,:,304))
  call Hloop_AQ_V(ntryL,G2H4(68),ex1(:),G2H2(40),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_AQ_V(ntryL,G2H4(69),ex1(:),G2H2(41),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_AQ_Z(ntryL,G2H4(70),ex1(:),G2H2(42),ngZl,m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_AQ_Z(ntryL,G2H4(71),ex1(:),G2H2(43),ngZl,m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_QA_V(ntryL,G2H4(76),ex3(:),G2H2(44),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_QA_Z(ntryL,G2H4(77),ex3(:),G2H2(45),ngZl,m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_QA_V(ntryL,G2H4(78),ex3(:),G2H2(46),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_QA_Z(ntryL,G2H4(79),ex3(:),G2H2(47),ngZl,m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_QA_W(ntryL,G2H4(80),ex3(:),G2H2(48),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_VQ_A(ntryL,G1H4(17),ex2(:),G1H2(121),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(121),55,0,G2H2(49),n2h2(1))
  call Hloop_ZQ_A(ntryL,G1H4(18),ex2(:),G1H2(122),ngZl,m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(122),55,0,G2H2(50),n2h2(2))
  call Hloop_QA_V(ntryL,G2H4(81),ex3(:),G2H2(51),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_QA_Z(ntryL,G2H4(82),ex3(:),G2H2(52),ngZl,m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_QA_V(ntryL,G2H4(83),ex3(:),G2H2(53),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_QA_Z(ntryL,G2H4(84),ex3(:),G2H2(54),ngZl,m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_VQ_A(ntryL,G1H4(19),ex1(:),G1H2(127),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(127),55,0,G2H2(55),n2h2(3))
  call Hloop_ZQ_A(ntryL,G1H4(20),ex1(:),G1H2(128),ngZl,m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(128),55,0,G2H2(56),n2h2(4))
  call Hloop_QA_V(ntryL,G2H4(85),ex4(:),G2H2(57),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_QA_Z(ntryL,G2H4(86),ex4(:),G2H2(58),ngZl,m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_QA_V(ntryL,G2H4(87),ex4(:),G2H2(59),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_QA_Z(ntryL,G2H4(88),ex4(:),G2H2(60),ngZl,m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_QA_V(ntryL,G2H4(89),ex3(:),G2H2(61),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_QA_Z(ntryL,G2H4(90),ex3(:),G2H2(62),ngZl,m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_QA_V(ntryL,G2H4(91),ex3(:),G2H2(63),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_QA_Z(ntryL,G2H4(92),ex3(:),G2H2(64),ngZl,m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_QA_V(ntryL,G2H4(93),ex4(:),G2H2(65),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_QA_Z(ntryL,G2H4(94),ex4(:),G2H2(66),ngZl,m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_QA_V(ntryL,G2H4(95),ex4(:),G2H2(67),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_QA_Z(ntryL,G2H4(96),ex4(:),G2H2(68),ngZl,m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_VQ_A(ntryL,G1H4(21),ex1(:),G1H2(133),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(133),55,0,G2H2(69),n2h2(5))
  call Hloop_ZQ_A(ntryL,G1H4(22),ex1(:),G1H2(134),ngZl,m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(134),55,0,G2H2(70),n2h2(6))
  call Hotf_5pt_reduction(G2H4(97),RedSet_5(19),mass5set(:,10),  & 
G1H4(9),G1H4(10),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(10),8,4)
  call Hloop_AQ_V(ntryL,G2H4(98),ex1(:),G2H2(71),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_AQ_V(ntryL,G2H4(99),ex1(:),G2H2(72),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_AQ_Z(ntryL,G2H4(100),ex1(:),G2H2(73),ngZl,m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_AQ_Z(ntryL,G2H4(101),ex1(:),G2H2(74),ngZl,m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_AQ_W(ntryL,G2H4(102),ex1(:),G2H2(75),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_VQ_A(ntryL,G1H4(23),ex1(:),G1H2(139),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_Q_A(ntryL,G1H2(139),59,0,G2H2(76),n2h2(7))
  call Hloop_ZQ_A(ntryL,G1H4(24),ex1(:),G1H2(140),ngZl,m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(140),59,0,G2H2(77),n2h2(8))
  call Hotf_5pt_reduction(G2H4(103),RedSet_5(20),mass5set(:,10),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),4,4)
  call Hloop_AQ_V(ntryL,G2H4(104),ex1(:),G2H2(78),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_AQ_V(ntryL,G2H4(105),ex1(:),G2H2(79),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_AQ_Z(ntryL,G2H4(106),ex1(:),G2H2(80),ngZl,m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_AQ_Z(ntryL,G2H4(107),ex1(:),G2H2(81),ngZl,m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_AQ_W(ntryL,G2H4(108),ex1(:),G2H2(82),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_VQ_A(ntryL,G1H4(25),ex2(:),G1H2(145),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(145),55,0,G2H2(83),n2h2(9))
  call Hloop_ZQ_A(ntryL,G1H4(26),ex2(:),G1H2(146),ngZl,m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(146),55,0,G2H2(84),n2h2(10))
  call Hotf_5pt_reduction(G2H4(109),RedSet_5(21),mass5set(:,10),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hloop_AQ_V(ntryL,G2H4(110),ex2(:),G2H2(85),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_AQ_Z(ntryL,G2H4(111),ex2(:),G2H2(86),ngZl,m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_AQ_V(ntryL,G2H4(112),ex2(:),G2H2(87),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_AQ_Z(ntryL,G2H4(113),ex2(:),G2H2(88),ngZl,m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_AQ_W(ntryL,G2H4(114),ex2(:),G2H2(89),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_VA_Q(ntryL,G1H4(27),ex4(:),G1H2(151),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_A_Q(ntryL,G1H2(151),61,0,G2H2(90),n2h2(11))
  call Hloop_ZA_Q(ntryL,G1H4(28),ex4(:),G1H2(152),ngZl,m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(152),61,0,G2H2(91),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(29),ex2(:),G1H2(157),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(157),59,0,G2H2(92),n2h2(13))
  call Hloop_ZQ_A(ntryL,G1H4(30),ex2(:),G1H2(158),ngZl,m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(158),59,0,G2H2(93),n2h2(14))
  call Hotf_5pt_reduction(G2H4(115),RedSet_5(22),mass5set(:,10),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(24),4,4)
  call Hloop_AQ_V(ntryL,G2H4(116),ex2(:),G2H2(94),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_AQ_Z(ntryL,G2H4(117),ex2(:),G2H2(95),ngZl,m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_AQ_V(ntryL,G2H4(118),ex2(:),G2H2(96),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_AQ_Z(ntryL,G2H4(119),ex2(:),G2H2(97),ngZl,m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_AQ_W(ntryL,G2H4(120),ex2(:),G2H2(98),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_VA_Q(ntryL,G1H4(31),ex3(:),G1H2(163),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_A_Q(ntryL,G1H2(163),61,0,G2H2(99),n2h2(15))
  call Hloop_ZA_Q(ntryL,G1H4(32),ex3(:),G1H2(164),ngZl,m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_A_Q(ntryL,G1H2(164),61,0,G2H2(100),n2h2(16))
  call Hloop_VQ_A(ntryL,G1H4(33),ex2(:),G1H2(169),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(169),55,0,G2H2(101),n2h2(17))
call HGT_raise_alpha_OLR(G1H4(34),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(34),ex4(:),G1H2(170),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_VQ_A(ntryL,G1H4(37),ex2(:),G1H2(175),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_Q_A(ntryL,G1H2(175),55,0,G2H2(102),n2h2(18))
  call Hloop_VQ_A(ntryL,G1H4(38),ex2(:),G1H2(176),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(176),55,0,G2H2(103),n2h2(19))
  call Hloop_VQ_A(ntryL,G1H4(39),ex2(:),G1H2(181),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(181),55,0,G2H2(104),n2h2(20))
call HGT_raise_alpha_OLR(G1H4(40),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(40),ex4(:),G1H2(182),ngZl,m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_VQ_A(ntryL,G1H4(43),ex2(:),G1H2(187),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(187),55,0,G2H2(105),n2h2(21))
  call Hloop_VQ_A(ntryL,G1H4(44),ex2(:),G1H2(188),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_Q_A(ntryL,G1H2(188),55,0,G2H2(106),n2h2(22))
  call Hloop_ZQ_A(ntryL,G1H4(45),ex2(:),G1H2(193),ngZl,m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(193),55,0,G2H2(107),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(46),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(46),ex4(:),G1H2(194),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_ZQ_A(ntryL,G1H4(49),ex2(:),G1H2(199),ngZl,m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(199),55,0,G2H2(108),n2h2(24))
  call Hloop_ZQ_A(ntryL,G1H4(50),ex2(:),G1H2(200),ngZl,m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(200),55,0,G2H2(109),n2h2(25))
  call Hloop_ZQ_A(ntryL,G1H4(51),ex2(:),G1H2(205),ngZl,m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(205),55,0,G2H2(110),n2h2(26))
call HGT_raise_alpha_OLR(G1H4(52),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(52),ex4(:),G1H2(206),ngZl,m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_ZQ_A(ntryL,G1H4(55),ex2(:),G1H2(211),ngZl,m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(211),55,0,G2H2(111),n2h2(27))
  call Hloop_ZQ_A(ntryL,G1H4(56),ex2(:),G1H2(212),ngZl,m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(212),55,0,G2H2(112),n2h2(28))
  call Hloop_VQ_A(ntryL,G1H4(1),ex1(:),G1H2(217),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(217),55,0,G2H2(113),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(218),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_VQ_A(ntryL,G1H4(57),ex1(:),G1H2(223),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(223),55,0,G2H2(114),n2h2(30))
  call Hloop_VQ_A(ntryL,G1H4(58),ex1(:),G1H2(224),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_Q_A(ntryL,G1H2(224),55,0,G2H2(115),n2h2(31))
  call Hloop_VQ_A(ntryL,G1H4(59),ex1(:),G1H2(229),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(229),55,0,G2H2(116),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(60),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(60),ex4(:),G1H2(230),ngZl,m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_VQ_A(ntryL,G1H4(63),ex1(:),G1H2(235),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(235),55,0,G2H2(117),n2h2(33))
  call Hloop_VQ_A(ntryL,G1H4(64),ex1(:),G1H2(236),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_Q_A(ntryL,G1H2(236),55,0,G2H2(118),n2h2(34))
  call Hloop_ZQ_A(ntryL,G1H4(65),ex1(:),G1H2(241),ngZl,m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(241),55,0,G2H2(119),n2h2(35))
call HGT_raise_alpha_OLR(G1H4(66),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(66),ex4(:),G1H2(242),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_ZQ_A(ntryL,G1H4(69),ex1(:),G1H2(247),ngZl,m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(247),55,0,G2H2(120),n2h2(36))
  call Hloop_ZQ_A(ntryL,G1H4(70),ex1(:),G1H2(248),ngZl,m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(248),55,0,G2H2(121),n2h2(37))
  call Hloop_ZQ_A(ntryL,G1H4(71),ex1(:),G1H2(253),ngZl,m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(253),55,0,G2H2(122),n2h2(38))
call HGT_raise_alpha_OLR(G1H4(72),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(72),ex4(:),G1H2(254),ngZl,m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_ZQ_A(ntryL,G1H4(75),ex1(:),G1H2(259),ngZl,m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(259),55,0,G2H2(123),n2h2(39))
  call Hloop_ZQ_A(ntryL,G1H4(76),ex1(:),G1H2(260),ngZl,m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_Q_A(ntryL,G1H2(260),55,0,G2H2(124),n2h2(40))
  call Hloop_WQ_A(ntryL,G1H4(9),ex1(:),G1H2(265),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(265),55,0,G2H2(125),n2h2(41))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(10),ex4(:),G1H2(266),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_WQ_A(ntryL,G1H4(7),ex1(:),G1H2(271),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_Q_A(ntryL,G1H2(271),55,0,G2H2(126),n2h2(42))
  call Hloop_WQ_A(ntryL,G1H4(8),ex1(:),G1H2(272),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_Q_A(ntryL,G1H2(272),55,0,G2H2(127),n2h2(43))
  call Hloop_WQ_A(ntryL,G1H4(11),ex1(:),G1H2(277),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(277),59,0,G2H2(128),n2h2(44))
call HGT_raise_alpha_OLR(G1H4(12),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(12),ex3(:),G1H2(278),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_WQ_A(ntryL,G1H4(15),ex1(:),G1H2(283),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(283),59,0,G2H2(129),n2h2(45))
  call Hloop_WQ_A(ntryL,G1H4(16),ex1(:),G1H2(284),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_Q_A(ntryL,G1H2(284),59,0,G2H2(130),n2h2(46))
  call Hloop_WQ_A(ntryL,G1H4(17),ex2(:),G1H2(289),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(289),55,0,G2H2(131),n2h2(47))
call HGT_raise_alpha_OLR(G1H4(18),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(18),ex4(:),G1H2(290),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_WQ_A(ntryL,G1H4(21),ex2(:),G1H2(295),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(295),55,0,G2H2(132),n2h2(48))
  call Hloop_WQ_A(ntryL,G1H4(22),ex2(:),G1H2(296),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_Q_A(ntryL,G1H2(296),55,0,G2H2(133),n2h2(49))
  call Hloop_WQ_A(ntryL,G1H4(23),ex2(:),G1H2(301),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(301),59,0,G2H2(134),n2h2(50))
call HGT_raise_alpha_OLR(G1H4(24),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(24),ex3(:),G1H2(302),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_WQ_A(ntryL,G1H4(27),ex2(:),G1H2(307),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_Q_A(ntryL,G1H2(307),59,0,G2H2(135),n2h2(51))
  call Hloop_WQ_A(ntryL,G1H4(28),ex2(:),G1H2(308),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_Q_A(ntryL,G1H2(308),59,0,G2H2(136),n2h2(52))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(346),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(119),[G1H2(101),G1H2(23),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(402),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(358),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(131),[G1H2(107),G1H2(35),G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(408),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(27),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(352),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(137),[G1H2(113),G1H2(41),G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(420),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(364),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(414),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(370),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(143),[G1H2(125),G1H2(47),G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(432),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(382),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(426),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(376),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(438),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(388),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(444),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(496),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(167),[G1H2(149),G1H2(71),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(300),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(502),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(179),[G1H2(155),G1H2(83),G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(312),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(514),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(185),[G1H2(161),G1H2(89),G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(306),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(508),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(318),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(526),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(191),[G1H2(173),G1H2(95),G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(324),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(93),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(520),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(336),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(532),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(330),[G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(538),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(342),[G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(694),[G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(198),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(712),[G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(204),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(123),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(700),[G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(210),[G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(706),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(216),[G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(724),[G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(222),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(730),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(228),[G1H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(141),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(718),[G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(234),[G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(736),[G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(240),[G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(159),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(244),[G1H2(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(600),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(171),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(250),[G1H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(618),[G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(256),[G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(606),[G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(183),[G1H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(262),[G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(612),[G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(268),[G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(630),[G1H2(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(274),[G1H2(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(636),[G1H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(280),[G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(624),[G1H2(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(286),[G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(642),[G1H2(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(201),[G1H2(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(748),[G1H2(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(215),G1H2(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(766),[G1H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(227),G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(219),[G1H2(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(760),[G1H2(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(233),G1H2(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(225),[G1H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(754),[G1H2(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(784),[G1H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(239),G1H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(778),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(237),[G1H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(772),[G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(790),[G1H2(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(255),[G1H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(263),G1H2(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(648),[G1H2(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(267),[G1H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(275),G1H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(666),[G1H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(281),G1H2(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(660),[G1H2(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(279),[G1H2(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(654),[G1H2(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(287),G1H2(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(684),[G1H2(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(285),[G1H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(678),[G1H2(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(672),[G1H2(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(690),[G1H2(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(25),G1H2(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(303),[G1H2(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(550),[G1H2(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(317),G1H2(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(568),[G1H2(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(329),G1H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(321),[G1H2(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(562),[G1H2(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(335),G1H2(311)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(327),[G1H2(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(556),[G1H2(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(586),[G1H2(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(341),G1H2(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(580),[G1H2(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(339),[G1H2(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(574),[G1H2(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(592),[G1H2(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(357),[G1H2(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(365),G1H2(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(450),[G1H2(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(369),[G1H2(351)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(377),G1H2(353)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(468),[G1H2(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(383),G1H2(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(462),[G1H2(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(381),[G1H2(363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(456),[G1H2(366)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(389),G1H2(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(486),[G1H2(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(387),[G1H2(375)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(480),[G1H2(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(474),[G1H2(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(492),[G1H2(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(1),G1H2(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(405),[G1H2(399)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(448),[G1H2(400)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(413),G1H2(401)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(460),[G1H2(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(425),G1H2(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(423),[G1H2(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(454),[G1H2(412)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(429),[G1H2(417)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(466),[G1H2(418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(437),G1H2(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(472),[G1H2(424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(484),[G1H2(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(443),G1H2(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(441),[G1H2(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(478),[G1H2(436)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(490),[G1H2(442)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(459),[G1H2(447)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(653),[G1H2(647),G1H2(455),G1H2(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(471),[G1H2(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(671),[G1H2(659),G1H2(473),G1H2(461)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(483),[G1H2(465)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(677),[G1H2(665),G1H2(479),G1H2(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(489),[G1H2(477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(689),[G1H2(683),G1H2(491),G1H2(485)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(513),[G1H2(495)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(509),G1H2(497)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(552),[G1H2(498)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(525),[G1H2(501)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(521),G1H2(503)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(564),[G1H2(504)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(531),[G1H2(507)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(558),[G1H2(510)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(533),G1H2(515)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(570),[G1H2(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(537),[G1H2(519)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(576),[G1H2(522)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(539),G1H2(527)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(588),[G1H2(528)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(582),[G1H2(534)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(594),[G1H2(540)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(544)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(545)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(37),G1H2(546)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(567),[G1H2(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(755),[G1H2(749),G1H2(557),G1H2(551)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(579),[G1H2(555)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(585),[G1H2(561)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(773),[G1H2(761),G1H2(575),G1H2(563)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(779),[G1H2(767),G1H2(581),G1H2(569)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(591),[G1H2(573)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(791),[G1H2(785),G1H2(593),G1H2(587)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(603),[G1H2(597)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(646),[G1H2(598)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(611),G1H2(599)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(658),[G1H2(604)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(623),G1H2(605)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(621),[G1H2(609)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(652),[G1H2(610)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(627),[G1H2(615)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(664),[G1H2(616)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G1H2(635),G1H2(617)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(670),[G1H2(622)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(682),[G1H2(628)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(641),G1H2(629)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(639),[G1H2(633)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(676),[G1H2(634)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(688),[G1H2(640)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(657),[G1H2(645)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(669),[G1H2(651)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(681),[G1H2(663)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(687),[G1H2(675)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(711),[G1H2(693)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(707),G1H2(695)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(750),[G1H2(696)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(723),[G1H2(699)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(719),G1H2(701)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(762),[G1H2(702)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(729),[G1H2(705)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(756),[G1H2(708)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(731),G1H2(713)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(768),[G1H2(714)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(735),[G1H2(717)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(774),[G1H2(720)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(737),G1H2(725)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(786),[G1H2(726)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(780),[G1H2(732)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(792),[G1H2(738)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(742)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(743)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(13),G1H2(744)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(765),[G1H2(747)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(777),[G1H2(753)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(783),[G1H2(759)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(789),[G1H2(771)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(74),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(104),[G1H2(97)])
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(1),n2h1(265))
  call Hloop_VQ_A(ntryL,G1H2(346),ex5(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(3),n2h1(266))
  call Hloop_VQ_A(ntryL,G1H2(119),ex5(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(5),n2h1(267))
  call Hloop_VQ_A(ntryL,G1H2(402),ex5(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(7),n2h1(268))
  call Hloop_VQ_A(ntryL,G1H2(358),ex5(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(9),n2h1(269))
  call Hloop_VQ_A(ntryL,G1H2(131),ex5(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(11),n2h1(270))
  call Hloop_VQ_A(ntryL,G1H2(408),ex5(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(13),n2h1(271))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),ngZd,m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(15),n2h1(272))
  call Hloop_ZQ_A(ntryL,G1H2(352),ex5(:),G1H1(1),ngZd,m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(17),n2h1(273))
  call Hloop_ZQ_A(ntryL,G1H2(137),ex5(:),G1H1(1),ngZd,m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(19),n2h1(274))
  call Hloop_ZQ_A(ntryL,G1H2(420),ex5(:),G1H1(1),ngZd,m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(21),n2h1(275))
  call Hloop_VQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(23),n2h1(276))
  call Hloop_VQ_A(ntryL,G1H2(364),ex5(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(25),n2h1(277))
  call Hloop_VQ_A(ntryL,G1H2(414),ex5(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(27),n2h1(278))
  call Hloop_ZQ_A(ntryL,G1H2(370),ex5(:),G1H1(1),ngZd,m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(29),n2h1(279))
  call Hloop_ZQ_A(ntryL,G1H2(143),ex5(:),G1H1(1),ngZd,m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(31),n2h1(280))
  call Hloop_ZQ_A(ntryL,G1H2(432),ex5(:),G1H1(1),ngZd,m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(33),n2h1(281))
  call Hloop_VQ_A(ntryL,G1H2(382),ex5(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(35),n2h1(282))
  call Hloop_VQ_A(ntryL,G1H2(426),ex5(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(37),n2h1(283))
  call Hloop_ZQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),ngZd,m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(39),n2h1(284))
  call Hloop_ZQ_A(ntryL,G1H2(376),ex5(:),G1H1(1),ngZd,m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(41),n2h1(285))
  call Hloop_ZQ_A(ntryL,G1H2(438),ex5(:),G1H1(1),ngZd,m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(43),n2h1(286))
  call Hloop_ZQ_A(ntryL,G1H2(388),ex5(:),G1H1(1),ngZd,m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(45),n2h1(287))
  call Hloop_ZQ_A(ntryL,G1H2(444),ex5(:),G1H1(1),ngZd,m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(47),n2h1(288))
  call Hloop_VQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(49),n2h1(289))
  call Hloop_VQ_A(ntryL,G1H2(496),ex5(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(51),n2h1(290))
  call Hloop_VQ_A(ntryL,G1H2(167),ex5(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(53),n2h1(291))
  call Hloop_VQ_A(ntryL,G1H2(300),ex5(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(55),n2h1(292))
  call Hloop_ZQ_A(ntryL,G1H2(75),ex5(:),G1H1(1),ngZd,m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(57),n2h1(293))
  call Hloop_ZQ_A(ntryL,G1H2(502),ex5(:),G1H1(1),ngZd,m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(59),n2h1(294))
  call Hloop_ZQ_A(ntryL,G1H2(179),ex5(:),G1H1(1),ngZd,m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(61),n2h1(295))
  call Hloop_ZQ_A(ntryL,G1H2(312),ex5(:),G1H1(1),ngZd,m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(63),n2h1(296))
  call Hloop_VQ_A(ntryL,G1H2(514),ex5(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(65),n2h1(297))
  call Hloop_VQ_A(ntryL,G1H2(185),ex5(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(67),n2h1(298))
  call Hloop_VQ_A(ntryL,G1H2(306),ex5(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(69),n2h1(299))
  call Hloop_VQ_A(ntryL,G1H2(87),ex5(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(71),n2h1(300))
  call Hloop_VQ_A(ntryL,G1H2(508),ex5(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(73),n2h1(301))
  call Hloop_VQ_A(ntryL,G1H2(318),ex5(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(75),n2h1(302))
  call Hloop_ZQ_A(ntryL,G1H2(526),ex5(:),G1H1(1),ngZd,m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(77),n2h1(303))
  call Hloop_ZQ_A(ntryL,G1H2(191),ex5(:),G1H1(1),ngZd,m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(79),n2h1(304))
  call Hloop_ZQ_A(ntryL,G1H2(324),ex5(:),G1H1(1),ngZd,m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(81),n2h1(305))
  call Hloop_ZQ_A(ntryL,G1H2(93),ex5(:),G1H1(1),ngZd,m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(83),n2h1(306))
  call Hloop_ZQ_A(ntryL,G1H2(520),ex5(:),G1H1(1),ngZd,m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(85),n2h1(307))
  call Hloop_ZQ_A(ntryL,G1H2(336),ex5(:),G1H1(1),ngZd,m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(87),n2h1(308))
  call Hloop_VQ_A(ntryL,G1H2(532),ex5(:),G1H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(89),n2h1(309))
  call Hloop_VQ_A(ntryL,G1H2(330),ex5(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(91),n2h1(310))
  call Hloop_ZQ_A(ntryL,G1H2(538),ex5(:),G1H1(1),ngZd,m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(93),n2h1(311))
  call Hloop_ZQ_A(ntryL,G1H2(342),ex5(:),G1H1(1),ngZd,m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(95),n2h1(312))
  call Hloop_VQ_A(ntryL,G1H2(105),ex5(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(97),n2h1(313))
  call Hloop_VQ_A(ntryL,G1H2(694),ex5(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(99),n2h1(314))
  call Hloop_VQ_A(ntryL,G1H2(198),ex5(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(101),n2h1(315))
  call Hloop_VQ_A(ntryL,G1H2(712),ex5(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(103),n2h1(316))
  call Hloop_VQ_A(ntryL,G1H2(204),ex5(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(105),n2h1(317))
  call Hloop_ZQ_A(ntryL,G1H2(123),ex5(:),G1H1(1),ngZd,m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(107),n2h1(318))
  call Hloop_ZQ_A(ntryL,G1H2(700),ex5(:),G1H1(1),ngZd,m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(109),n2h1(319))
  call Hloop_ZQ_A(ntryL,G1H2(210),ex5(:),G1H1(1),ngZd,m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(111),n2h1(320))
  call Hloop_VQ_A(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(113),n2h1(321))
  call Hloop_VQ_A(ntryL,G1H2(706),ex5(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(115),n2h1(322))
  call Hloop_VQ_A(ntryL,G1H2(216),ex5(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(117),n2h1(323))
  call Hloop_ZQ_A(ntryL,G1H2(724),ex5(:),G1H1(1),ngZd,m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(119),n2h1(324))
  call Hloop_ZQ_A(ntryL,G1H2(222),ex5(:),G1H1(1),ngZd,m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(121),n2h1(325))
  call Hloop_VQ_A(ntryL,G1H2(730),ex5(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(123),n2h1(326))
  call Hloop_VQ_A(ntryL,G1H2(228),ex5(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(125),n2h1(327))
  call Hloop_ZQ_A(ntryL,G1H2(141),ex5(:),G1H1(1),ngZd,m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(127),n2h1(328))
  call Hloop_ZQ_A(ntryL,G1H2(718),ex5(:),G1H1(1),ngZd,m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(129),n2h1(329))
  call Hloop_ZQ_A(ntryL,G1H2(234),ex5(:),G1H1(1),ngZd,m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(131),n2h1(330))
  call Hloop_ZQ_A(ntryL,G1H2(736),ex5(:),G1H1(1),ngZd,m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(133),n2h1(331))
  call Hloop_ZQ_A(ntryL,G1H2(240),ex5(:),G1H1(1),ngZd,m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(135),n2h1(332))
  call Hloop_VQ_A(ntryL,G1H2(159),ex5(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(137),n2h1(333))
  call Hloop_VQ_A(ntryL,G1H2(244),ex5(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(139),n2h1(334))
  call Hloop_VQ_A(ntryL,G1H2(600),ex5(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(141),n2h1(335))
  call Hloop_ZQ_A(ntryL,G1H2(171),ex5(:),G1H1(1),ngZd,m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(143),n2h1(336))
  call Hloop_ZQ_A(ntryL,G1H2(250),ex5(:),G1H1(1),ngZd,m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(145),n2h1(337))
  call Hloop_ZQ_A(ntryL,G1H2(618),ex5(:),G1H1(1),ngZd,m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(147),n2h1(338))
  call Hloop_VQ_A(ntryL,G1H2(256),ex5(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(149),n2h1(339))
  call Hloop_VQ_A(ntryL,G1H2(606),ex5(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(151),n2h1(340))
  call Hloop_VQ_A(ntryL,G1H2(183),ex5(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(153),n2h1(341))
  call Hloop_VQ_A(ntryL,G1H2(262),ex5(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(155),n2h1(342))
  call Hloop_VQ_A(ntryL,G1H2(612),ex5(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(157),n2h1(343))
  call Hloop_ZQ_A(ntryL,G1H2(268),ex5(:),G1H1(1),ngZd,m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(159),n2h1(344))
  call Hloop_ZQ_A(ntryL,G1H2(630),ex5(:),G1H1(1),ngZd,m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(161),n2h1(345))
  call Hloop_ZQ_A(ntryL,G1H2(189),ex5(:),G1H1(1),ngZd,m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(163),n2h1(346))
  call Hloop_ZQ_A(ntryL,G1H2(274),ex5(:),G1H1(1),ngZd,m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(165),n2h1(347))
  call Hloop_ZQ_A(ntryL,G1H2(636),ex5(:),G1H1(1),ngZd,m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(167),n2h1(348))
  call Hloop_VQ_A(ntryL,G1H2(280),ex5(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(169),n2h1(349))
  call Hloop_VQ_A(ntryL,G1H2(624),ex5(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(171),n2h1(350))
  call Hloop_ZQ_A(ntryL,G1H2(286),ex5(:),G1H1(1),ngZd,m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(173),n2h1(351))
  call Hloop_ZQ_A(ntryL,G1H2(642),ex5(:),G1H1(1),ngZd,m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(175),n2h1(352))
  call Hloop_VQ_A(ntryL,G1H2(201),ex5(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(177),n2h1(353))
  call Hloop_VQ_A(ntryL,G1H2(748),ex5(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(179),n2h1(354))
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(23),mass5set(:,1),  & 
G1H2(313),G1H2(314),G1H2(319),G1H2(320),G1H2(325),G1H2(326),2)
  call HG1shiftOLR(G1H2(314),16,2)
  call Hloop_VQ_A(ntryL,G1H2(766),ex5(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(181),n2h1(355))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(23),mass5set(:,2),  & 
G1H2(331),G1H2(332),G1H2(337),G1H2(338),G1H2(343),G1H2(344),2)
  call HG1shiftOLR(G1H2(332),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(219),ex5(:),G1H1(1),ngZd,m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(183),n2h1(356))
  call Hloop_ZQ_A(ntryL,G1H2(760),ex5(:),G1H1(1),ngZd,m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(185),n2h1(357))
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(23),mass5set(:,11),  & 
G1H2(349),G1H2(350),G1H2(355),G1H2(356),G1H2(361),G1H2(362),2)
  call HG1shiftOLR(G1H2(350),16,2)
  call Hloop_VQ_A(ntryL,G1H2(225),ex5(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(187),n2h1(358))
  call Hloop_VQ_A(ntryL,G1H2(754),ex5(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(189),n2h1(359))
  call Hloop_ZQ_A(ntryL,G1H2(784),ex5(:),G1H1(1),ngZd,m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(191),n2h1(360))
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(23),mass5set(:,12),  & 
G1H2(367),G1H2(368),G1H2(373),G1H2(374),G1H2(379),G1H2(380),2)
  call HG1shiftOLR(G1H2(368),16,2)
  call Hloop_VQ_A(ntryL,G1H2(778),ex5(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(193),n2h1(361))
  call Hloop_ZQ_A(ntryL,G1H2(237),ex5(:),G1H1(1),ngZd,m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(195),n2h1(362))
  call Hloop_ZQ_A(ntryL,G1H2(772),ex5(:),G1H1(1),ngZd,m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(197),n2h1(363))
  call Hloop_ZQ_A(ntryL,G1H2(790),ex5(:),G1H1(1),ngZd,m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(199),n2h1(364))
  call Hloop_VQ_A(ntryL,G1H2(255),ex5(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(201),n2h1(365))
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(24),mass5set(:,1),  & 
G1H2(385),G1H2(386),G1H2(391),G1H2(392),G1H2(397),G1H2(398),2)
  call HG1shiftOLR(G1H2(386),16,2)
  call Hloop_VQ_A(ntryL,G1H2(648),ex5(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(203),n2h1(366))
  call Hloop_ZQ_A(ntryL,G1H2(267),ex5(:),G1H1(1),ngZd,m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(205),n2h1(367))
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(24),mass5set(:,11),  & 
G1H2(403),G1H2(404),G1H2(409),G1H2(410),G1H2(415),G1H2(416),2)
  call HG1shiftOLR(G1H2(404),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(666),ex5(:),G1H1(1),ngZd,m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(207),n2h1(368))
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(24),mass5set(:,2),  & 
G1H2(421),G1H2(422),G1H2(427),G1H2(428),G1H2(433),G1H2(434),2)
  call HG1shiftOLR(G1H2(422),16,2)
  call Hloop_VQ_A(ntryL,G1H2(660),ex5(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(209),n2h1(369))
  call Hloop_VQ_A(ntryL,G1H2(279),ex5(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(211),n2h1(370))
  call Hloop_VQ_A(ntryL,G1H2(654),ex5(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(213),n2h1(371))
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(24),mass5set(:,12),  & 
G1H2(439),G1H2(440),G1H2(445),G1H2(446),G1H2(451),G1H2(452),2)
  call HG1shiftOLR(G1H2(440),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(684),ex5(:),G1H1(1),ngZd,m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(215),n2h1(372))
  call Hloop_ZQ_A(ntryL,G1H2(285),ex5(:),G1H1(1),ngZd,m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(217),n2h1(373))
  call Hloop_ZQ_A(ntryL,G1H2(678),ex5(:),G1H1(1),ngZd,m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(219),n2h1(374))
  call Hloop_VQ_A(ntryL,G1H2(672),ex5(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(221),n2h1(375))
  call Hloop_ZQ_A(ntryL,G1H2(690),ex5(:),G1H1(1),ngZd,m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(223),n2h1(376))
  call Hloop_WQ_A(ntryL,G1H2(291),ex5(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(225),n2h1(377))
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(25),mass5set(:,13),  & 
G1H2(457),G1H2(458),G1H2(463),G1H2(464),G1H2(469),G1H2(470),2)
  call HG1shiftOLR(G1H2(458),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(24),mass5set(:,14),  & 
G1H2(475),G1H2(476),G1H2(481),G1H2(482),G1H2(487),G1H2(488),2)
  call HG1shiftOLR(G1H2(476),16,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(26),mass5set(:,15),  & 
G1H2(493),G1H2(494),G1H2(499),G1H2(500),G1H2(505),G1H2(506),2)
  call HG1shiftOLR(G1H2(494),16,2)
  call Hloop_VQ_A(ntryL,G1H2(303),ex5(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(227),n2h1(378))
  call Hloop_VQ_A(ntryL,G1H2(550),ex5(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(229),n2h1(379))
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(27),mass5set(:,1),  & 
G1H2(511),G1H2(512),G1H2(517),G1H2(518),G1H2(523),G1H2(524),2)
  call HG1shiftOLR(G1H2(512),16,2)
  call Hloop_VQ_A(ntryL,G1H2(568),ex5(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(231),n2h1(380))
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(27),mass5set(:,2),  & 
G1H2(529),G1H2(530),G1H2(535),G1H2(536),G1H2(541),G1H2(542),2)
  call HG1shiftOLR(G1H2(530),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(321),ex5(:),G1H1(1),ngZd,m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(233),n2h1(381))
  call Hloop_ZQ_A(ntryL,G1H2(562),ex5(:),G1H1(1),ngZd,m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(235),n2h1(382))
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(27),mass5set(:,11),  & 
G1H2(547),G1H2(548),G1H2(553),G1H2(554),G1H2(559),G1H2(560),2)
  call HG1shiftOLR(G1H2(548),16,2)
  call Hloop_VQ_A(ntryL,G1H2(327),ex5(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(237),n2h1(383))
  call Hloop_VQ_A(ntryL,G1H2(556),ex5(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(239),n2h1(384))
  call Hloop_ZQ_A(ntryL,G1H2(586),ex5(:),G1H1(1),ngZd,m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(241),n2h1(385))
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(27),mass5set(:,12),  & 
G1H2(565),G1H2(566),G1H2(571),G1H2(572),G1H2(577),G1H2(578),2)
  call HG1shiftOLR(G1H2(566),16,2)
  call Hloop_VQ_A(ntryL,G1H2(580),ex5(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(243),n2h1(386))
  call Hloop_ZQ_A(ntryL,G1H2(339),ex5(:),G1H1(1),ngZd,m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(245),n2h1(387))
  call Hloop_ZQ_A(ntryL,G1H2(574),ex5(:),G1H1(1),ngZd,m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(247),n2h1(388))
  call Hloop_ZQ_A(ntryL,G1H2(592),ex5(:),G1H1(1),ngZd,m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(249),n2h1(389))
  call Hloop_VQ_A(ntryL,G1H2(357),ex5(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(251),n2h1(390))
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(28),mass5set(:,1),  & 
G1H2(583),G1H2(584),G1H2(589),G1H2(590),G1H2(595),G1H2(596),2)
  call HG1shiftOLR(G1H2(584),16,2)
  call Hloop_VQ_A(ntryL,G1H2(450),ex5(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(253),n2h1(391))
  call Hloop_ZQ_A(ntryL,G1H2(369),ex5(:),G1H1(1),ngZd,m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(255),n2h1(392))
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(28),mass5set(:,11),  & 
G1H2(601),G1H2(602),G1H2(607),G1H2(608),G1H2(613),G1H2(614),2)
  call HG1shiftOLR(G1H2(602),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(468),ex5(:),G1H1(1),ngZd,m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(257),n2h1(393))
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(28),mass5set(:,2),  & 
G1H2(619),G1H2(620),G1H2(625),G1H2(626),G1H2(631),G1H2(632),2)
  call HG1shiftOLR(G1H2(620),16,2)
  call Hloop_VQ_A(ntryL,G1H2(462),ex5(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(259),n2h1(394))
  call Hloop_VQ_A(ntryL,G1H2(381),ex5(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(261),n2h1(395))
  call Hloop_VQ_A(ntryL,G1H2(456),ex5(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(263),n2h1(396))
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(28),mass5set(:,12),  & 
G1H2(637),G1H2(638),G1H2(643),G1H2(644),G1H2(649),G1H2(650),2)
  call HG1shiftOLR(G1H2(638),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(486),ex5(:),G1H1(1),ngZd,m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(265),n2h1(397))
  call Hloop_ZQ_A(ntryL,G1H2(387),ex5(:),G1H1(1),ngZd,m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(266),n2h1(398))
  call Hloop_ZQ_A(ntryL,G1H2(480),ex5(:),G1H1(1),ngZd,m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(267),n2h1(399))
  call Hloop_VQ_A(ntryL,G1H2(474),ex5(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(268),n2h1(400))
  call Hloop_ZQ_A(ntryL,G1H2(492),ex5(:),G1H1(1),ngZd,m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(269),n2h1(401))
  call Hloop_WQ_A(ntryL,G1H2(393),ex5(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(270),n2h1(402))
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(29),mass5set(:,13),  & 
G1H2(655),G1H2(656),G1H2(661),G1H2(662),G1H2(667),G1H2(668),2)
  call HG1shiftOLR(G1H2(656),16,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(28),mass5set(:,14),  & 
G1H2(673),G1H2(674),G1H2(679),G1H2(680),G1H2(685),G1H2(686),2)
  call HG1shiftOLR(G1H2(674),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(30),mass5set(:,15),  & 
G1H2(691),G1H2(692),G1H2(697),G1H2(698),G1H2(703),G1H2(704),2)
  call HG1shiftOLR(G1H2(692),16,2)
  call Hloop_VQ_A(ntryL,G1H2(405),ex5(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(271),n2h1(403))
  call Hloop_VQ_A(ntryL,G1H2(448),ex5(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(272),n2h1(404))
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(31),mass5set(:,1),  & 
G1H2(709),G1H2(710),G1H2(715),G1H2(716),G1H2(721),G1H2(722),2)
  call HG1shiftOLR(G1H2(710),16,2)
  call Hloop_VQ_A(ntryL,G1H2(460),ex5(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(273),n2h1(405))
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(31),mass5set(:,2),  & 
G1H2(727),G1H2(728),G1H2(733),G1H2(734),G1H2(739),G1H2(740),2)
  call HG1shiftOLR(G1H2(728),16,2)
  call Hloop_VQ_A(ntryL,G1H2(423),ex5(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(274),n2h1(406))
  call Hloop_VQ_A(ntryL,G1H2(454),ex5(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(275),n2h1(407))
  call Hloop_ZQ_A(ntryL,G1H2(429),ex5(:),G1H1(1),ngZd,m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(276),n2h1(408))
  call Hloop_ZQ_A(ntryL,G1H2(466),ex5(:),G1H1(1),ngZd,m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(277),n2h1(409))
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(31),mass5set(:,11),  & 
G1H2(745),G1H2(746),G1H2(751),G1H2(752),G1H2(757),G1H2(758),2)
  call HG1shiftOLR(G1H2(746),16,2)
  call Hloop_VQ_A(ntryL,G1H2(472),ex5(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(278),n2h1(410))
  call Hloop_ZQ_A(ntryL,G1H2(484),ex5(:),G1H1(1),ngZd,m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(279),n2h1(411))
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(31),mass5set(:,12),  & 
G1H2(763),G1H2(764),G1H2(769),G1H2(770),G1H2(775),G1H2(776),2)
  call HG1shiftOLR(G1H2(764),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(441),ex5(:),G1H1(1),ngZd,m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(280),n2h1(412))
  call Hloop_ZQ_A(ntryL,G1H2(478),ex5(:),G1H1(1),ngZd,m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(281),n2h1(413))
  call Hloop_ZQ_A(ntryL,G1H2(490),ex5(:),G1H1(1),ngZd,m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(282),n2h1(414))
  call Hloop_VQ_A(ntryL,G1H2(459),ex5(:),G1H1(1),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(283),n2h1(415))
  call Hloop_VQ_A(ntryL,G1H2(653),ex5(:),G1H1(1),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(284),n2h1(416))
  call Hloop_VQ_A(ntryL,G1H2(471),ex5(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(285),n2h1(417))
  call Hloop_VQ_A(ntryL,G1H2(671),ex5(:),G1H1(1),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(286),n2h1(418))
  call Hloop_ZQ_A(ntryL,G1H2(483),ex5(:),G1H1(1),ngZd,m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(287),n2h1(419))
  call Hloop_ZQ_A(ntryL,G1H2(677),ex5(:),G1H1(1),ngZd,m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(288),n2h1(420))
  call Hloop_ZQ_A(ntryL,G1H2(489),ex5(:),G1H1(1),ngZd,m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(289),n2h1(421))
  call Hloop_ZQ_A(ntryL,G1H2(689),ex5(:),G1H1(1),ngZd,m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(290),n2h1(422))
  call Hloop_VQ_A(ntryL,G1H2(513),ex5(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(291),n2h1(423))
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(32),mass5set(:,1),  & 
G1H2(781),G1H2(782),G1H2(787),G1H2(788),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(782),16,2)
  call Hloop_VQ_A(ntryL,G1H2(552),ex5(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(292),n2h1(424))
  call Hloop_ZQ_A(ntryL,G1H2(525),ex5(:),G1H1(1),ngZd,m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(293),n2h1(425))
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(32),mass5set(:,11),  & 
G1H2(127),G1H2(128),G1H2(133),G1H2(134),G1H2(139),G1H2(140),2)
  call HG1shiftOLR(G1H2(128),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(564),ex5(:),G1H1(1),ngZd,m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(294),n2h1(426))
  call Hloop_VQ_A(ntryL,G1H2(531),ex5(:),G1H1(1),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(295),n2h1(427))
  call Hloop_VQ_A(ntryL,G1H2(558),ex5(:),G1H1(1),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(296),n2h1(428))
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(32),mass5set(:,2),  & 
G1H2(145),G1H2(146),G1H2(151),G1H2(152),G1H2(157),G1H2(158),2)
  call HG1shiftOLR(G1H2(146),16,2)
  call Hloop_VQ_A(ntryL,G1H2(570),ex5(:),G1H1(1),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(297),n2h1(429))
  call Hloop_ZQ_A(ntryL,G1H2(537),ex5(:),G1H1(1),ngZd,m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(298),n2h1(430))
  call Hloop_ZQ_A(ntryL,G1H2(576),ex5(:),G1H1(1),ngZd,m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(299),n2h1(431))
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(32),mass5set(:,12),  & 
G1H2(163),G1H2(164),G1H2(169),G1H2(175),G1H2(176),G1H2(181),2)
  call HG1shiftOLR(G1H2(164),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(588),ex5(:),G1H1(1),ngZd,m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(300),n2h1(432))
  call Hloop_VQ_A(ntryL,G1H2(582),ex5(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(301),n2h1(433))
  call Hloop_ZQ_A(ntryL,G1H2(594),ex5(:),G1H1(1),ngZd,m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(302),n2h1(434))
  call Hloop_WQ_A(ntryL,G1H2(543),ex5(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(303),n2h1(435))
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(33),mass5set(:,13),  & 
G1H2(187),G1H2(188),G1H2(193),G1H2(199),G1H2(200),G1H2(205),2)
  call HG1shiftOLR(G1H2(188),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(32),mass5set(:,14),  & 
G1H2(211),G1H2(212),G1H2(217),G1H2(223),G1H2(224),G1H2(229),2)
  call HG1shiftOLR(G1H2(212),16,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(34),mass5set(:,15),  & 
G1H2(235),G1H2(236),G1H2(241),G1H2(247),G1H2(248),G1H2(253),2)
  call HG1shiftOLR(G1H2(236),16,2)
  call Hloop_VQ_A(ntryL,G1H2(567),ex5(:),G1H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(304),n2h1(436))
  call Hloop_VQ_A(ntryL,G1H2(755),ex5(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(305),n2h1(437))
  call Hloop_VQ_A(ntryL,G1H2(579),ex5(:),G1H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(306),n2h1(438))
  call Hloop_ZQ_A(ntryL,G1H2(585),ex5(:),G1H1(1),ngZd,m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(307),n2h1(439))
  call Hloop_ZQ_A(ntryL,G1H2(773),ex5(:),G1H1(1),ngZd,m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(308),n2h1(440))
  call Hloop_VQ_A(ntryL,G1H2(779),ex5(:),G1H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(309),n2h1(441))
  call Hloop_ZQ_A(ntryL,G1H2(591),ex5(:),G1H1(1),ngZd,m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(310),n2h1(442))
  call Hloop_ZQ_A(ntryL,G1H2(791),ex5(:),G1H1(1),ngZd,m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(311),n2h1(443))
  call Hloop_VQ_A(ntryL,G1H2(603),ex5(:),G1H1(1),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(312),n2h1(444))
  call Hloop_VQ_A(ntryL,G1H2(646),ex5(:),G1H1(1),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(313),n2h1(445))
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(35),mass5set(:,1),  & 
G1H2(259),G1H2(260),G1H2(265),G1H2(271),G1H2(272),G1H2(277),2)
  call HG1shiftOLR(G1H2(260),16,2)
  call Hloop_VQ_A(ntryL,G1H2(658),ex5(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(314),n2h1(446))
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(35),mass5set(:,2),  & 
G1H2(283),G1H2(284),G1H2(289),G1H2(295),G1H2(296),G1H2(301),2)
  call HG1shiftOLR(G1H2(284),16,2)
  call Hloop_VQ_A(ntryL,G1H2(621),ex5(:),G1H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(315),n2h1(447))
  call Hloop_VQ_A(ntryL,G1H2(652),ex5(:),G1H1(1),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(316),n2h1(448))
  call Hloop_ZQ_A(ntryL,G1H2(627),ex5(:),G1H1(1),ngZd,m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(317),n2h1(449))
  call Hloop_ZQ_A(ntryL,G1H2(664),ex5(:),G1H1(1),ngZd,m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(318),n2h1(450))
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(35),mass5set(:,11),  & 
G1H2(307),G1H2(308),G1H2(3),G1H2(4),G1H2(101),G1H2(23),2)
  call HG1shiftOLR(G1H2(308),16,2)
  call Hloop_VQ_A(ntryL,G1H2(670),ex5(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(319),n2h1(451))
  call Hloop_ZQ_A(ntryL,G1H2(682),ex5(:),G1H1(1),ngZd,m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(320),n2h1(452))
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(35),mass5set(:,12),  & 
G1H2(5),G1H2(6),G1H2(10),G1H2(107),G1H2(35),G1H2(11),2)
  call HG1shiftOLR(G1H2(6),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(639),ex5(:),G1H1(1),ngZd,m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(321),n2h1(453))
  call Hloop_ZQ_A(ntryL,G1H2(676),ex5(:),G1H1(1),ngZd,m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(322),n2h1(454))
  call Hloop_ZQ_A(ntryL,G1H2(688),ex5(:),G1H1(1),ngZd,m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(323),n2h1(455))
  call Hloop_VQ_A(ntryL,G1H2(657),ex5(:),G1H1(1),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(324),n2h1(456))
  call Hloop_VQ_A(ntryL,G1H2(669),ex5(:),G1H1(1),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(325),n2h1(457))
  call Hloop_ZQ_A(ntryL,G1H2(681),ex5(:),G1H1(1),ngZd,m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(326),n2h1(458))
  call Hloop_ZQ_A(ntryL,G1H2(687),ex5(:),G1H1(1),ngZd,m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(327),n2h1(459))
  call Hloop_VQ_A(ntryL,G1H2(711),ex5(:),G1H1(1),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(328),n2h1(460))
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(36),mass5set(:,1),  & 
G1H2(12),G1H2(15),G1H2(16),G1H2(113),G1H2(41),G1H2(17),2)
  call HG1shiftOLR(G1H2(15),16,2)
  call Hloop_VQ_A(ntryL,G1H2(750),ex5(:),G1H1(1),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(329),n2h1(461))
  call Hloop_ZQ_A(ntryL,G1H2(723),ex5(:),G1H1(1),ngZd,m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(330),n2h1(462))
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(36),mass5set(:,11),  & 
G1H2(18),G1H2(21),G1H2(22),G1H2(24),G1H2(28),G1H2(125),2)
  call HG1shiftOLR(G1H2(21),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(762),ex5(:),G1H1(1),ngZd,m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(331),n2h1(463))
  call Hloop_VQ_A(ntryL,G1H2(729),ex5(:),G1H1(1),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(332),n2h1(464))
  call Hloop_VQ_A(ntryL,G1H2(756),ex5(:),G1H1(1),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(333),n2h1(465))
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(36),mass5set(:,2),  & 
G1H2(47),G1H2(29),G1H2(30),G1H2(34),G1H2(36),G1H2(39),2)
  call HG1shiftOLR(G1H2(29),16,2)
  call Hloop_VQ_A(ntryL,G1H2(768),ex5(:),G1H1(1),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(334),n2h1(466))
  call Hloop_ZQ_A(ntryL,G1H2(735),ex5(:),G1H1(1),ngZd,m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(335),n2h1(467))
  call Hloop_ZQ_A(ntryL,G1H2(774),ex5(:),G1H1(1),ngZd,m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(336),n2h1(468))
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(36),mass5set(:,12),  & 
G1H2(40),G1H2(42),G1H2(46),G1H2(48),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(42),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(786),ex5(:),G1H1(1),ngZd,m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(337),n2h1(469))
  call Hloop_VQ_A(ntryL,G1H2(780),ex5(:),G1H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(338),n2h1(470))
  call Hloop_ZQ_A(ntryL,G1H2(792),ex5(:),G1H1(1),ngZd,m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(339),n2h1(471))
  call Hloop_WQ_A(ntryL,G1H2(741),ex5(:),G1H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(340),n2h1(472))
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(37),mass5set(:,13),  & 
G1H2(149),G1H2(71),G1H2(53),G1H2(54),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(71),16,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(36),mass5set(:,14),  & 
G1H2(155),G1H2(83),G1H2(59),G1H2(60),G1H2(64),G1H2(161),2)
  call HG1shiftOLR(G1H2(83),16,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(38),mass5set(:,15),  & 
G1H2(89),G1H2(65),G1H2(66),G1H2(69),G1H2(70),G1H2(72),2)
  call HG1shiftOLR(G1H2(65),16,2)
  call Hloop_VQ_A(ntryL,G1H2(765),ex5(:),G1H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(341),n2h1(473))
  call Hloop_VQ_A(ntryL,G1H2(777),ex5(:),G1H1(1),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(342),n2h1(474))
  call Hloop_ZQ_A(ntryL,G1H2(783),ex5(:),G1H1(1),ngZd,m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(343),n2h1(475))
  call Hloop_ZQ_A(ntryL,G1H2(789),ex5(:),G1H1(1),ngZd,m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(344),n2h1(476))
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(345),n2h1(477))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),ngZd,m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(346),n2h1(478))
  call Hotf_5pt_reduction(G2H4(121),RedSet_5(39),mass5set(:,16),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(30),5,4)
  call Hotf_5pt_reduction(G2H4(122),RedSet_5(39),mass5set(:,17),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(38),5,4)
  call Hotf_5pt_reduction(G2H4(123),RedSet_5(39),mass5set(:,18),  & 
G1H4(45),G1H4(46),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(46),5,4)
  call Hotf_5pt_reduction(G2H4(124),RedSet_5(39),mass5set(:,19),  & 
G1H4(55),G1H4(56),G1H4(1),G1H4(2),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(56),5,4)
  call Hotf_5pt_reduction(G2H4(125),RedSet_5(39),mass5set(:,20),  & 
G1H4(59),G1H4(60),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(60),5,4)
  call Hotf_5pt_reduction(G2H4(126),RedSet_5(39),mass5set(:,16),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(70),5,4)
  call Hotf_5pt_reduction(G2H4(127),RedSet_5(39),mass5set(:,17),  & 
G1H4(9),G1H4(10),G1H4(7),G1H4(8),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(10),5,4)
  call Hotf_5pt_reduction(G2H4(128),RedSet_5(39),mass5set(:,18),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(16),5,4)
  call Hotf_5pt_reduction(G2H4(129),RedSet_5(39),mass5set(:,19),  & 
G1H4(23),G1H4(24),G1H4(27),G1H4(28),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(24),5,4)
  call Hotf_5pt_reduction(G2H4(130),RedSet_5(39),mass5set(:,20),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),5,4)
  call Hloop_SQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),ngPtb,m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(347),n2h1(479))
  call Hloop_SQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),ngH,m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(348),n2h1(480))
  call Hloop_SQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),ngH,m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(349),n2h1(481))
  call Hloop_VQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(350),n2h1(482))
  call Hloop_ZQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),ngZd,m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(351),n2h1(483))
  call Hloop_SQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),ngH,m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(352),n2h1(484))
  call Hloop_SQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),ngH,m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(353),n2h1(485))
  call Hloop_VQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(354),n2h1(486))
  call Hloop_ZQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),ngZd,m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(355),n2h1(487))
  call Hotf_5pt_reduction(G2H4(131),RedSet_5(40),mass5set(:,16),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),6,4)
  call Hotf_5pt_reduction(G2H4(132),RedSet_5(40),mass5set(:,17),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),6,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(40),mass5set(:,18),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),6,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(40),mass5set(:,19),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),6,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(40),mass5set(:,20),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),6,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(40),mass5set(:,16),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),6,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(40),mass5set(:,17),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),6,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(40),mass5set(:,18),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),6,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(40),mass5set(:,19),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),6,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(40),mass5set(:,20),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),6,4)
  call Hloop_SQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),ngPtb,m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(356),n2h1(488))
  call Hloop_SQ_A(ntryL,G1H2(38),ex5(:),G1H1(1),ngH,m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(357),n2h1(489))
  call Hloop_SQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),ngH,m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(358),n2h1(490))
  call Hloop_VQ_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(359),n2h1(491))
  call Hloop_ZQ_A(ntryL,G1H2(50),ex5(:),G1H1(1),ngZd,m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(360),n2h1(492))
  call Hloop_SQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),ngH,m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(361),n2h1(493))
  call Hloop_SQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),ngH,m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(362),n2h1(494))
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(41),mass5set(:,16),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),9,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(41),mass5set(:,18),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),9,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(41),mass5set(:,17),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),9,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(41),mass5set(:,19),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),9,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(41),mass5set(:,16),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),9,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(41),mass5set(:,18),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),9,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(41),mass5set(:,17),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),9,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(41),mass5set(:,19),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),9,4)
  call Hloop_VQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(363),n2h1(495))
  call Hloop_ZQ_A(ntryL,G1H2(62),ex5(:),G1H1(1),ngZd,m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(364),n2h1(496))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(42),mass5set(:,16),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),9,4)
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(42),mass5set(:,17),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),9,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(42),mass5set(:,18),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),9,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(42),mass5set(:,19),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),9,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(42),mass5set(:,20),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),9,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(42),mass5set(:,16),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),9,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(42),mass5set(:,17),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),9,4)
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(42),mass5set(:,18),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),9,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(42),mass5set(:,19),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),9,4)
  call Hotf_5pt_reduction(G2H4(65),RedSet_5(42),mass5set(:,20),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
  call HG1shiftOLR(G1H4(248),9,4)
  call Hloop_SQ_A(ntryL,G1H2(74),ex5(:),G1H1(1),ngPtb,m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(365),n2h1(497))
  call Hloop_SQ_A(ntryL,G1H2(68),ex5(:),G1H1(1),ngH,m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(366),n2h1(498))
  call Hloop_SQ_A(ntryL,G1H2(73),ex5(:),G1H1(1),ngH,m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(367),n2h1(499))
  call Hloop_VQ_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(368),n2h1(500))
  call Hloop_ZQ_A(ntryL,G1H2(80),ex5(:),G1H1(1),ngZd,m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(369),n2h1(501))
  call Hloop_SQ_A(ntryL,G1H2(85),ex5(:),G1H1(1),ngH,m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(370),n2h1(502))
  call Hloop_SQ_A(ntryL,G1H2(86),ex5(:),G1H1(1),ngH,m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(371),n2h1(503))
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(43),mass5set(:,16),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(254),10,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(43),mass5set(:,18),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
  call HG1shiftOLR(G1H4(260),10,4)
  call Hotf_5pt_reduction(G2H4(72),RedSet_5(43),mass5set(:,17),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
  call HG1shiftOLR(G1H4(266),10,4)
  call Hotf_5pt_reduction(G2H4(73),RedSet_5(43),mass5set(:,19),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
  call HG1shiftOLR(G1H4(272),10,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(43),mass5set(:,16),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(278),10,4)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(43),mass5set(:,18),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(284),10,4)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(43),mass5set(:,17),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
  call HG1shiftOLR(G1H4(290),10,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(43),mass5set(:,19),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),G1H4(300),4)
  call HG1shiftOLR(G1H4(296),10,4)
  call Hloop_VQ_A(ntryL,G1H2(91),ex5(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(372),n2h1(504))
  call Hloop_ZQ_A(ntryL,G1H2(92),ex5(:),G1H1(1),ngZd,m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(373),n2h1(505))
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(44),mass5set(:,16),  & 
G1H4(301),G1H4(302),G1H4(303),G1H4(304),G1H4(305),G1H4(306),4)
  call HG1shiftOLR(G1H4(302),10,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(44),mass5set(:,17),  & 
G1H4(307),G1H4(308),G1H4(309),G1H4(310),G1H4(311),G1H4(312),4)
  call HG1shiftOLR(G1H4(308),10,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(44),mass5set(:,18),  & 
G1H4(313),G1H4(314),G1H4(315),G1H4(316),G1H4(317),G1H4(318),4)
  call HG1shiftOLR(G1H4(314),10,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(44),mass5set(:,19),  & 
G1H4(319),G1H4(320),G1H4(321),G1H4(322),G1H4(323),G1H4(324),4)
  call HG1shiftOLR(G1H4(320),10,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(44),mass5set(:,20),  & 
G1H4(325),G1H4(326),G1H4(327),G1H4(328),G1H4(329),G1H4(330),4)
  call HG1shiftOLR(G1H4(326),10,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(44),mass5set(:,16),  & 
G1H4(331),G1H4(332),G1H4(333),G1H4(334),G1H4(335),G1H4(336),4)
  call HG1shiftOLR(G1H4(332),10,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(44),mass5set(:,17),  & 
G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(338),10,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(44),mass5set(:,18),  & 
G1H4(343),G1H4(344),G1H4(345),G1H4(346),G1H4(347),G1H4(348),4)
  call HG1shiftOLR(G1H4(344),10,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(44),mass5set(:,19),  & 
G1H4(349),G1H4(350),G1H4(351),G1H4(352),G1H4(353),G1H4(354),4)
  call HG1shiftOLR(G1H4(350),10,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(44),mass5set(:,20),  & 
G1H4(355),G1H4(356),G1H4(357),G1H4(358),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(356),10,4)
  call Hloop_SQ_A(ntryL,G1H2(104),ex5(:),G1H1(1),ngPtb,m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(374),n2h1(506))
  call Hloop_SQ_A(ntryL,G1H2(98),ex5(:),G1H1(1),ngH,m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(375),n2h1(507))
  call Hloop_SQ_A(ntryL,G1H2(103),ex5(:),G1H1(1),ngH,m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(376),n2h1(508))
  call Hloop_VQ_A(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(377),n2h1(509))
  call Hloop_ZQ_A(ntryL,G1H2(110),ex5(:),G1H1(1),ngZd,m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(378),n2h1(510))
  call Hloop_SQ_A(ntryL,G1H2(115),ex5(:),G1H1(1),ngH,m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(379),n2h1(511))
  call Hloop_SQ_A(ntryL,G1H2(116),ex5(:),G1H1(1),ngH,m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(380),n2h1(512))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(49),ex4(:),G2tensor(381),ngZl,m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(382),ngZl,m3h2x1(:,514),heltab2x2(:,:,514))
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(45),mass5set(:,21),  & 
G1H2(76),G1H2(173),G1H2(95),G1H2(77),G1H2(78),G1H2(81),2)
  call HG1shiftOLR(G1H2(173),8,2)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(45),mass5set(:,22),  & 
G1H2(82),G1H2(84),G1H2(88),G1H2(90),G1H2(94),G1H2(96),2)
  call HG1shiftOLR(G1H2(84),8,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(45),mass5set(:,23),  & 
G1H2(99),G1H2(100),G1H2(102),G1H2(106),G1H2(108),G1H2(111),2)
  call HG1shiftOLR(G1H2(100),8,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(45),mass5set(:,24),  & 
G1H2(112),G1H2(114),G1H2(117),G1H2(118),G1H2(120),G1H2(124),2)
  call HG1shiftOLR(G1H2(114),8,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(55),ex4(:),G2tensor(383),ngZl,m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(56),ex4(:),G2tensor(384),ngZl,m3h2x1(:,516),heltab2x2(:,:,516))
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(46),mass5set(:,21),  & 
G1H2(126),G1H2(130),G1H2(132),G1H2(135),G1H2(136),G1H2(138),2)
  call HG1shiftOLR(G1H2(130),4,2)
  call Hotf_5pt_reduction(G2H2(58),RedSet_5(46),mass5set(:,22),  & 
G1H2(142),G1H2(144),G1H2(147),G1H2(148),G1H2(150),G1H2(153),2)
  call HG1shiftOLR(G1H2(144),4,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(46),mass5set(:,23),  & 
G1H2(154),G1H2(156),G1H2(160),G1H2(162),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(156),4,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(46),mass5set(:,24),  & 
G1H2(168),G1H2(172),G1H2(174),G1H2(177),G1H2(178),G1H2(180),2)
  call HG1shiftOLR(G1H2(172),4,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(47),mass5set(:,21),  & 
G1H2(184),G1H2(186),G1H2(190),G1H2(192),G1H2(195),G1H2(196),2)
  call HG1shiftOLR(G1H2(186),8,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(47),mass5set(:,22),  & 
G1H2(215),G1H2(197),G1H2(202),G1H2(227),G1H2(203),G1H2(207),2)
  call HG1shiftOLR(G1H2(197),8,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(47),mass5set(:,23),  & 
G1H2(208),G1H2(233),G1H2(209),G1H2(213),G1H2(214),G1H2(220),2)
  call HG1shiftOLR(G1H2(233),8,2)
  call Hotf_5pt_reduction(G2H2(64),RedSet_5(47),mass5set(:,24),  & 
G1H2(239),G1H2(221),G1H2(226),G1H2(231),G1H2(232),G1H2(238),2)
  call HG1shiftOLR(G1H2(221),8,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(48),mass5set(:,21),  & 
G1H2(243),G1H2(263),G1H2(245),G1H2(246),G1H2(249),G1H2(275),2)
  call HG1shiftOLR(G1H2(263),4,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(48),mass5set(:,22),  & 
G1H2(251),G1H2(252),G1H2(281),G1H2(257),G1H2(258),G1H2(261),2)
  call HG1shiftOLR(G1H2(252),4,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(48),mass5set(:,23),  & 
G1H2(264),G1H2(287),G1H2(269),G1H2(270),G1H2(273),G1H2(276),2)
  call HG1shiftOLR(G1H2(287),4,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(48),mass5set(:,24),  & 
G1H2(282),G1H2(288),G1H2(292),G1H2(293),G1H2(294),G1H2(297),2)
  call HG1shiftOLR(G1H2(288),4,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(69),ex4(:),G2tensor(385),ngZl,m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(70),ex4(:),G2tensor(386),ngZl,m3h2x1(:,518),heltab2x2(:,:,518))
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(19),mass5set(:,21),  & 
G1H2(298),G1H2(317),G1H2(299),G1H2(304),G1H2(329),G1H2(305),2)
  call HG1shiftOLR(G1H2(317),8,2)
  call Hotf_5pt_reduction(G2H2(72),RedSet_5(19),mass5set(:,23),  & 
G1H2(309),G1H2(310),G1H2(335),G1H2(311),G1H2(315),G1H2(316),2)
  call HG1shiftOLR(G1H2(310),8,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(19),mass5set(:,22),  & 
G1H2(322),G1H2(341),G1H2(323),G1H2(328),G1H2(333),G1H2(334),2)
  call HG1shiftOLR(G1H2(341),8,2)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(19),mass5set(:,24),  & 
G1H2(340),G1H2(345),G1H2(365),G1H2(347),G1H2(348),G1H2(351),2)
  call HG1shiftOLR(G1H2(345),8,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(19),mass5set(:,25),  & 
G1H2(377),G1H2(353),G1H2(354),G1H2(383),G1H2(359),G1H2(360),2)
  call HG1shiftOLR(G1H2(353),8,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(76),ex3(:),G2tensor(387),ngZl,m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(77),ex3(:),G2tensor(388),ngZl,m3h2x1(:,520),heltab2x2(:,:,520))
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(20),mass5set(:,21),  & 
G1H2(363),G1H2(366),G1H2(389),G1H2(371),G1H2(372),G1H2(375),2)
  call HG1shiftOLR(G1H2(366),4,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(20),mass5set(:,23),  & 
G1H2(378),G1H2(384),G1H2(390),G1H2(394),G1H2(395),G1H2(396),2)
  call HG1shiftOLR(G1H2(384),4,2)
  call Hotf_5pt_reduction(G2H2(80),RedSet_5(20),mass5set(:,22),  & 
G1H2(399),G1H2(400),G1H2(413),G1H2(401),G1H2(406),G1H2(425),2)
  call HG1shiftOLR(G1H2(400),4,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(20),mass5set(:,24),  & 
G1H2(407),G1H2(411),G1H2(412),G1H2(417),G1H2(418),G1H2(437),2)
  call HG1shiftOLR(G1H2(411),4,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(20),mass5set(:,25),  & 
G1H2(419),G1H2(424),G1H2(430),G1H2(443),G1H2(431),G1H2(435),2)
  call HG1shiftOLR(G1H2(424),4,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(83),ex4(:),G2tensor(389),ngZl,m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(84),ex4(:),G2tensor(390),ngZl,m3h2x1(:,522),heltab2x2(:,:,522))
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(21),mass5set(:,21),  & 
G1H2(436),G1H2(442),G1H2(447),G1H2(647),G1H2(455),G1H2(449),2)
  call HG1shiftOLR(G1H2(442),8,2)
  call Hotf_5pt_reduction(G2H2(86),RedSet_5(21),mass5set(:,22),  & 
G1H2(453),G1H2(659),G1H2(473),G1H2(461),G1H2(465),G1H2(665),2)
  call HG1shiftOLR(G1H2(659),8,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(21),mass5set(:,23),  & 
G1H2(479),G1H2(467),G1H2(477),G1H2(683),G1H2(491),G1H2(485),2)
  call HG1shiftOLR(G1H2(467),8,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(21),mass5set(:,24),  & 
G1H2(495),G1H2(509),G1H2(497),G1H2(498),G1H2(501),G1H2(521),2)
  call HG1shiftOLR(G1H2(509),8,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(21),mass5set(:,25),  & 
G1H2(503),G1H2(504),G1H2(507),G1H2(510),G1H2(533),G1H2(515),2)
  call HG1shiftOLR(G1H2(504),8,2)
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(90),ex2(:),G2tensor(391),ngZl,m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(91),ex2(:),G2tensor(392),ngZl,m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(92),ex3(:),G2tensor(393),ngZl,m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(93),ex3(:),G2tensor(394),ngZl,m3h2x1(:,526),heltab2x2(:,:,526))
  call Hotf_5pt_reduction(G2H2(94),RedSet_5(22),mass5set(:,21),  & 
G1H2(516),G1H2(519),G1H2(522),G1H2(539),G1H2(527),G1H2(528),2)
  call HG1shiftOLR(G1H2(519),4,2)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(22),mass5set(:,22),  & 
G1H2(534),G1H2(540),G1H2(544),G1H2(545),G1H2(546),G1H2(549),2)
  call HG1shiftOLR(G1H2(540),4,2)
  call Hotf_5pt_reduction(G2H2(96),RedSet_5(22),mass5set(:,23),  & 
G1H2(749),G1H2(557),G1H2(551),G1H2(555),G1H2(561),G1H2(761),2)
  call HG1shiftOLR(G1H2(557),4,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(22),mass5set(:,24),  & 
G1H2(575),G1H2(563),G1H2(767),G1H2(581),G1H2(569),G1H2(573),2)
  call HG1shiftOLR(G1H2(563),4,2)
  call Hotf_5pt_reduction(G2H2(98),RedSet_5(22),mass5set(:,25),  & 
G1H2(785),G1H2(593),G1H2(587),G1H2(597),G1H2(598),G1H2(611),2)
  call HG1shiftOLR(G1H2(593),4,2)
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(99),ex2(:),G2tensor(395),ngZl,m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(100),ex2(:),G2tensor(396),ngZl,m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(101),ex4(:),G2tensor(397),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(103),ex4(:),G2tensor(398),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(104),ex4(:),G2tensor(399),ngZl,m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(106),ex4(:),G2tensor(400),ngZl,m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(107),ex4(:),G2tensor(401),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(109),ex4(:),G2tensor(402),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(110),ex4(:),G2tensor(403),ngZl,m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(112),ex4(:),G2tensor(404),ngZl,m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(113),ex4(:),G2tensor(405),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(115),ex4(:),G2tensor(406),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(116),ex4(:),G2tensor(407),ngZl,m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(118),ex4(:),G2tensor(408),ngZl,m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(119),ex4(:),G2tensor(409),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(121),ex4(:),G2tensor(410),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(122),ex4(:),G2tensor(411),ngZl,m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(124),ex4(:),G2tensor(412),ngZl,m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(125),ex4(:),G2tensor(413),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(127),ex4(:),G2tensor(414),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(128),ex3(:),G2tensor(415),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(130),ex3(:),G2tensor(416),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(131),ex4(:),G2tensor(417),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(133),ex4(:),G2tensor(418),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(134),ex3(:),G2tensor(419),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(136),ex3(:),G2tensor(420),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hloop_VQ_A(ntryL,G1H2(313),ex5(:),G1H1(1),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(421),n2h1(513))
  call Hloop_VQ_A(ntryL,G1H2(314),ex5(:),G1H1(1),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(422),n2h1(514))
  call Hloop_VQ_A(ntryL,G1H2(326),ex5(:),G1H1(1),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(423),n2h1(515))
  call Hloop_VQ_A(ntryL,G1H2(331),ex5(:),G1H1(1),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(424),n2h1(516))
  call Hloop_VQ_A(ntryL,G1H2(332),ex5(:),G1H1(1),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(425),n2h1(517))
  call Hloop_VQ_A(ntryL,G1H2(344),ex5(:),G1H1(1),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(426),n2h1(518))
  call Hloop_ZQ_A(ntryL,G1H2(349),ex5(:),G1H1(1),ngZd,m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(427),n2h1(519))
  call Hloop_ZQ_A(ntryL,G1H2(350),ex5(:),G1H1(1),ngZd,m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(428),n2h1(520))
  call Hloop_ZQ_A(ntryL,G1H2(362),ex5(:),G1H1(1),ngZd,m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(429),n2h1(521))
  call Hloop_ZQ_A(ntryL,G1H2(367),ex5(:),G1H1(1),ngZd,m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(430),n2h1(522))
  call Hloop_ZQ_A(ntryL,G1H2(368),ex5(:),G1H1(1),ngZd,m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(431),n2h1(523))
  call Hloop_ZQ_A(ntryL,G1H2(380),ex5(:),G1H1(1),ngZd,m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(432),n2h1(524))
  call Hloop_VQ_A(ntryL,G1H2(385),ex5(:),G1H1(1),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(433),n2h1(525))
  call Hloop_VQ_A(ntryL,G1H2(386),ex5(:),G1H1(1),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(434),n2h1(526))
  call Hloop_VQ_A(ntryL,G1H2(398),ex5(:),G1H1(1),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(435),n2h1(527))
  call Hloop_ZQ_A(ntryL,G1H2(403),ex5(:),G1H1(1),ngZd,m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(436),n2h1(528))
  call Hloop_ZQ_A(ntryL,G1H2(404),ex5(:),G1H1(1),ngZd,m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(437),n2h1(529))
  call Hloop_ZQ_A(ntryL,G1H2(416),ex5(:),G1H1(1),ngZd,m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(438),n2h1(530))
  call Hloop_VQ_A(ntryL,G1H2(421),ex5(:),G1H1(1),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(439),n2h1(531))
  call Hloop_VQ_A(ntryL,G1H2(422),ex5(:),G1H1(1),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(440),n2h1(532))
  call Hloop_VQ_A(ntryL,G1H2(434),ex5(:),G1H1(1),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(441),n2h1(533))
  call Hloop_ZQ_A(ntryL,G1H2(439),ex5(:),G1H1(1),ngZd,m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(442),n2h1(534))
  call Hloop_ZQ_A(ntryL,G1H2(440),ex5(:),G1H1(1),ngZd,m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(443),n2h1(535))
  call Hloop_ZQ_A(ntryL,G1H2(452),ex5(:),G1H1(1),ngZd,m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(444),n2h1(536))
  call Hloop_WQ_A(ntryL,G1H2(457),ex5(:),G1H1(1),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(445),n2h1(537))
  call Hloop_WQ_A(ntryL,G1H2(458),ex5(:),G1H1(1),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(446),n2h1(538))
  call Hloop_WQ_A(ntryL,G1H2(470),ex5(:),G1H1(1),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(447),n2h1(539))
  call Hloop_WQ_A(ntryL,G1H2(475),ex5(:),G1H1(1),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(448),n2h1(540))
  call Hloop_WQ_A(ntryL,G1H2(476),ex5(:),G1H1(1),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(449),n2h1(541))
  call Hloop_WQ_A(ntryL,G1H2(488),ex5(:),G1H1(1),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(450),n2h1(542))
  call Hloop_WQ_A(ntryL,G1H2(493),ex5(:),G1H1(1),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(451),n2h1(543))
  call Hloop_WQ_A(ntryL,G1H2(494),ex5(:),G1H1(1),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(452),n2h1(544))
  call Hloop_WQ_A(ntryL,G1H2(506),ex5(:),G1H1(1),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(453),n2h1(545))
  call Hloop_VQ_A(ntryL,G1H2(511),ex5(:),G1H1(1),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(454),n2h1(546))
  call Hloop_VQ_A(ntryL,G1H2(512),ex5(:),G1H1(1),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(455),n2h1(547))
  call Hloop_VQ_A(ntryL,G1H2(524),ex5(:),G1H1(1),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(456),n2h1(548))
  call Hloop_VQ_A(ntryL,G1H2(529),ex5(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(457),n2h1(549))
  call Hloop_VQ_A(ntryL,G1H2(530),ex5(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(458),n2h1(550))
  call Hloop_VQ_A(ntryL,G1H2(542),ex5(:),G1H1(1),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(459),n2h1(551))
  call Hloop_ZQ_A(ntryL,G1H2(547),ex5(:),G1H1(1),ngZd,m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(460),n2h1(552))
  call Hloop_ZQ_A(ntryL,G1H2(548),ex5(:),G1H1(1),ngZd,m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(461),n2h1(553))
  call Hloop_ZQ_A(ntryL,G1H2(560),ex5(:),G1H1(1),ngZd,m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(462),n2h1(554))
  call Hloop_ZQ_A(ntryL,G1H2(565),ex5(:),G1H1(1),ngZd,m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(463),n2h1(555))
  call Hloop_ZQ_A(ntryL,G1H2(566),ex5(:),G1H1(1),ngZd,m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(464),n2h1(556))
  call Hloop_ZQ_A(ntryL,G1H2(578),ex5(:),G1H1(1),ngZd,m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(465),n2h1(557))
  call Hloop_VQ_A(ntryL,G1H2(583),ex5(:),G1H1(1),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(466),n2h1(558))
  call Hloop_VQ_A(ntryL,G1H2(584),ex5(:),G1H1(1),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(467),n2h1(559))
  call Hloop_VQ_A(ntryL,G1H2(596),ex5(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(468),n2h1(560))
  call Hloop_ZQ_A(ntryL,G1H2(601),ex5(:),G1H1(1),ngZd,m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(469),n2h1(561))
  call Hloop_ZQ_A(ntryL,G1H2(602),ex5(:),G1H1(1),ngZd,m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(470),n2h1(562))
  call Hloop_ZQ_A(ntryL,G1H2(614),ex5(:),G1H1(1),ngZd,m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(471),n2h1(563))
  call Hloop_VQ_A(ntryL,G1H2(619),ex5(:),G1H1(1),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(472),n2h1(564))
  call Hloop_VQ_A(ntryL,G1H2(620),ex5(:),G1H1(1),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(473),n2h1(565))
  call Hloop_VQ_A(ntryL,G1H2(632),ex5(:),G1H1(1),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(474),n2h1(566))
  call Hloop_ZQ_A(ntryL,G1H2(637),ex5(:),G1H1(1),ngZd,m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(475),n2h1(567))
  call Hloop_ZQ_A(ntryL,G1H2(638),ex5(:),G1H1(1),ngZd,m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(476),n2h1(568))
  call Hloop_ZQ_A(ntryL,G1H2(650),ex5(:),G1H1(1),ngZd,m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(477),n2h1(569))
  call Hloop_WQ_A(ntryL,G1H2(655),ex5(:),G1H1(1),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(478),n2h1(570))
  call Hloop_WQ_A(ntryL,G1H2(656),ex5(:),G1H1(1),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(479),n2h1(571))
  call Hloop_WQ_A(ntryL,G1H2(668),ex5(:),G1H1(1),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(480),n2h1(572))
  call Hloop_WQ_A(ntryL,G1H2(673),ex5(:),G1H1(1),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(481),n2h1(573))
  call Hloop_WQ_A(ntryL,G1H2(674),ex5(:),G1H1(1),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(482),n2h1(574))
  call Hloop_WQ_A(ntryL,G1H2(686),ex5(:),G1H1(1),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(483),n2h1(575))
  call Hloop_WQ_A(ntryL,G1H2(691),ex5(:),G1H1(1),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(484),n2h1(576))
  call Hloop_WQ_A(ntryL,G1H2(692),ex5(:),G1H1(1),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(485),n2h1(577))
  call Hloop_WQ_A(ntryL,G1H2(704),ex5(:),G1H1(1),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(486),n2h1(578))
  call Hloop_VQ_A(ntryL,G1H2(709),ex5(:),G1H1(1),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(487),n2h1(579))
  call Hloop_VQ_A(ntryL,G1H2(710),ex5(:),G1H1(1),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(488),n2h1(580))
  call Hloop_VQ_A(ntryL,G1H2(722),ex5(:),G1H1(1),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(489),n2h1(581))
  call Hloop_VQ_A(ntryL,G1H2(727),ex5(:),G1H1(1),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(490),n2h1(582))
  call Hloop_VQ_A(ntryL,G1H2(728),ex5(:),G1H1(1),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(491),n2h1(583))
  call Hloop_VQ_A(ntryL,G1H2(740),ex5(:),G1H1(1),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(492),n2h1(584))
  call Hloop_ZQ_A(ntryL,G1H2(745),ex5(:),G1H1(1),ngZd,m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(493),n2h1(585))
  call Hloop_ZQ_A(ntryL,G1H2(746),ex5(:),G1H1(1),ngZd,m3h2x1(:,626),heltab2x2(:,:,626))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(494),n2h1(586))
  call Hloop_ZQ_A(ntryL,G1H2(758),ex5(:),G1H1(1),ngZd,m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(495),n2h1(587))
  call Hloop_ZQ_A(ntryL,G1H2(763),ex5(:),G1H1(1),ngZd,m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(496),n2h1(588))
  call Hloop_ZQ_A(ntryL,G1H2(764),ex5(:),G1H1(1),ngZd,m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(497),n2h1(589))
  call Hloop_ZQ_A(ntryL,G1H2(776),ex5(:),G1H1(1),ngZd,m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(498),n2h1(590))
  call Hloop_VQ_A(ntryL,G1H2(781),ex5(:),G1H1(1),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(499),n2h1(591))
  call Hloop_VQ_A(ntryL,G1H2(782),ex5(:),G1H1(1),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(500),n2h1(592))
  call Hloop_VQ_A(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(501),n2h1(593))
  call Hloop_ZQ_A(ntryL,G1H2(127),ex5(:),G1H1(1),ngZd,m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(502),n2h1(594))
  call Hloop_ZQ_A(ntryL,G1H2(128),ex5(:),G1H1(1),ngZd,m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(503),n2h1(595))
  call Hloop_ZQ_A(ntryL,G1H2(140),ex5(:),G1H1(1),ngZd,m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(504),n2h1(596))
  call Hloop_VQ_A(ntryL,G1H2(145),ex5(:),G1H1(1),m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(505),n2h1(597))
  call Hloop_VQ_A(ntryL,G1H2(146),ex5(:),G1H1(1),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(506),n2h1(598))
  call Hloop_VQ_A(ntryL,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(507),n2h1(599))
  call Hloop_ZQ_A(ntryL,G1H2(163),ex5(:),G1H1(1),ngZd,m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(508),n2h1(600))
  call Hloop_ZQ_A(ntryL,G1H2(164),ex5(:),G1H1(1),ngZd,m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(509),n2h1(601))
  call Hloop_ZQ_A(ntryL,G1H2(181),ex5(:),G1H1(1),ngZd,m3h2x1(:,642),heltab2x2(:,:,642))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(510),n2h1(602))
  call Hloop_WQ_A(ntryL,G1H2(187),ex5(:),G1H1(1),m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(511),n2h1(603))
  call Hloop_WQ_A(ntryL,G1H2(188),ex5(:),G1H1(1),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(512),n2h1(604))
  call Hloop_WQ_A(ntryL,G1H2(205),ex5(:),G1H1(1),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(513),n2h1(605))
  call Hloop_WQ_A(ntryL,G1H2(211),ex5(:),G1H1(1),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(514),n2h1(606))
  call Hloop_WQ_A(ntryL,G1H2(212),ex5(:),G1H1(1),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(515),n2h1(607))
  call Hloop_WQ_A(ntryL,G1H2(229),ex5(:),G1H1(1),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(516),n2h1(608))
  call Hloop_WQ_A(ntryL,G1H2(235),ex5(:),G1H1(1),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(517),n2h1(609))
  call Hloop_WQ_A(ntryL,G1H2(236),ex5(:),G1H1(1),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(518),n2h1(610))
  call Hloop_WQ_A(ntryL,G1H2(253),ex5(:),G1H1(1),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(519),n2h1(611))
  call Hloop_VQ_A(ntryL,G1H2(259),ex5(:),G1H1(1),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(520),n2h1(612))
  call Hloop_VQ_A(ntryL,G1H2(260),ex5(:),G1H1(1),m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(521),n2h1(613))
  call Hloop_VQ_A(ntryL,G1H2(277),ex5(:),G1H1(1),m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(522),n2h1(614))
  call Hloop_VQ_A(ntryL,G1H2(283),ex5(:),G1H1(1),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(523),n2h1(615))
  call Hloop_VQ_A(ntryL,G1H2(284),ex5(:),G1H1(1),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(524),n2h1(616))
  call Hloop_VQ_A(ntryL,G1H2(301),ex5(:),G1H1(1),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(525),n2h1(617))
  call Hloop_ZQ_A(ntryL,G1H2(307),ex5(:),G1H1(1),ngZd,m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(526),n2h1(618))
  call Hloop_ZQ_A(ntryL,G1H2(308),ex5(:),G1H1(1),ngZd,m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(527),n2h1(619))
  call Hloop_ZQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),ngZd,m3h2x1(:,660),heltab2x2(:,:,660))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(528),n2h1(620))
  call Hloop_ZQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),ngZd,m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(529),n2h1(621))
  call Hloop_ZQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),ngZd,m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(530),n2h1(622))
  call Hloop_ZQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),ngZd,m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(531),n2h1(623))
  call Hloop_VQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(532),n2h1(624))
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(533),n2h1(625))
  call Hloop_VQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,666),heltab2x2(:,:,666))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(534),n2h1(626))
  call Hloop_ZQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),ngZd,m3h2x1(:,667),heltab2x2(:,:,667))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(535),n2h1(627))
  call Hloop_ZQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),ngZd,m3h2x1(:,668),heltab2x2(:,:,668))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(536),n2h1(628))
  call Hloop_ZQ_A(ntryL,G1H2(125),ex5(:),G1H1(1),ngZd,m3h2x1(:,669),heltab2x2(:,:,669))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(537),n2h1(629))
  call Hloop_VQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,670),heltab2x2(:,:,670))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(538),n2h1(630))
  call Hloop_VQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,671),heltab2x2(:,:,671))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(539),n2h1(631))
  call Hloop_VQ_A(ntryL,G1H2(39),ex5(:),G1H1(1),m3h2x1(:,672),heltab2x2(:,:,672))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(540),n2h1(632))
  call Hloop_ZQ_A(ntryL,G1H2(40),ex5(:),G1H1(1),ngZd,m3h2x1(:,673),heltab2x2(:,:,673))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(541),n2h1(633))
  call Hloop_ZQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),ngZd,m3h2x1(:,674),heltab2x2(:,:,674))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(542),n2h1(634))
  call Hloop_ZQ_A(ntryL,G1H2(52),ex5(:),G1H1(1),ngZd,m3h2x1(:,675),heltab2x2(:,:,675))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(543),n2h1(635))
  call Hloop_WQ_A(ntryL,G1H2(149),ex5(:),G1H1(1),m3h2x1(:,676),heltab2x2(:,:,676))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(544),n2h1(636))
  call Hloop_WQ_A(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,677),heltab2x2(:,:,677))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(545),n2h1(637))
  call Hloop_WQ_A(ntryL,G1H2(58),ex5(:),G1H1(1),m3h2x1(:,678),heltab2x2(:,:,678))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(546),n2h1(638))
  call Hloop_WQ_A(ntryL,G1H2(155),ex5(:),G1H1(1),m3h2x1(:,679),heltab2x2(:,:,679))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(547),n2h1(639))
  call Hloop_WQ_A(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,680),heltab2x2(:,:,680))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(548),n2h1(640))
  call Hloop_WQ_A(ntryL,G1H2(161),ex5(:),G1H1(1),m3h2x1(:,681),heltab2x2(:,:,681))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(549),n2h1(641))
  call Hloop_WQ_A(ntryL,G1H2(89),ex5(:),G1H1(1),m3h2x1(:,682),heltab2x2(:,:,682))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(550),n2h1(642))
  call Hloop_WQ_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,683),heltab2x2(:,:,683))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(551),n2h1(643))
  call Hloop_WQ_A(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,684),heltab2x2(:,:,684))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(552),n2h1(644))
  call Hloop_QV_A(ntryL,G1H4(29),wf4(:,4),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(553),n2h1(645))
  call Hloop_QV_A(ntryL,G1H4(30),wf4(:,4),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(554),n2h1(646))
  call Hloop_QV_A(ntryL,G1H4(34),wf4(:,4),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(555),n2h1(647))
  call Hloop_QV_A(ntryL,G1H4(37),wf4(:,4),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(556),n2h1(648))
  call Hloop_QV_A(ntryL,G1H4(38),wf4(:,4),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(557),n2h1(649))
  call Hloop_QV_A(ntryL,G1H4(44),wf4(:,4),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(558),n2h1(650))
  call Hloop_QV_A(ntryL,G1H4(45),wf4(:,4),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(559),n2h1(651))
  call Hloop_QV_A(ntryL,G1H4(46),wf4(:,4),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(560),n2h1(652))
  call Hloop_QV_A(ntryL,G1H4(52),wf4(:,4),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(561),n2h1(653))
  call Hloop_QV_A(ntryL,G1H4(55),wf4(:,4),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(562),n2h1(654))
  call Hloop_QV_A(ntryL,G1H4(56),wf4(:,4),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(563),n2h1(655))
  call Hloop_QV_A(ntryL,G1H4(58),wf4(:,4),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(564),n2h1(656))
  call Hloop_QV_A(ntryL,G1H4(59),wf4(:,4),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(565),n2h1(657))
  call Hloop_QV_A(ntryL,G1H4(60),wf4(:,4),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMT,G2tensor(566),n2h1(658))
  call Hloop_QV_A(ntryL,G1H4(66),wf4(:,4),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(567),n2h1(659))
  call Hloop_QZ_A(ntryL,G1H4(69),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,16),heltab2x4(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(568),n2h1(660))
  call Hloop_QZ_A(ntryL,G1H4(70),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,17),heltab2x4(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(569),n2h1(661))
  call Hloop_QZ_A(ntryL,G1H4(76),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,18),heltab2x4(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(570),n2h1(662))
  call Hloop_QZ_A(ntryL,G1H4(9),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,19),heltab2x4(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(571),n2h1(663))
  call Hloop_QZ_A(ntryL,G1H4(10),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,20),heltab2x4(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(572),n2h1(664))
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,21),heltab2x4(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(573),n2h1(665))
  call Hloop_QZ_A(ntryL,G1H4(15),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,22),heltab2x4(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(574),n2h1(666))
  call Hloop_QZ_A(ntryL,G1H4(16),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,23),heltab2x4(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(575),n2h1(667))
  call Hloop_QZ_A(ntryL,G1H4(22),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,24),heltab2x4(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(576),n2h1(668))
  call Hloop_QZ_A(ntryL,G1H4(23),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,25),heltab2x4(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(577),n2h1(669))
  call Hloop_QZ_A(ntryL,G1H4(24),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,26),heltab2x4(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(578),n2h1(670))
  call Hloop_QZ_A(ntryL,G1H4(78),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,27),heltab2x4(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(579),n2h1(671))
  call Hloop_QZ_A(ntryL,G1H4(79),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,28),heltab2x4(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(580),n2h1(672))
  call Hloop_QZ_A(ntryL,G1H4(80),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,29),heltab2x4(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMT,G2tensor(581),n2h1(673))
  call Hloop_QZ_A(ntryL,G1H4(84),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,30),heltab2x4(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(582),n2h1(674))
  call Hloop_QV_A(ntryL,G1H4(85),wf4(:,11),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(583),n2h1(675))
  call Hloop_QV_A(ntryL,G1H4(86),wf4(:,11),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(584),n2h1(676))
  call Hloop_QV_A(ntryL,G1H4(90),wf4(:,11),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(585),n2h1(677))
  call Hloop_QV_A(ntryL,G1H4(91),wf4(:,11),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(586),n2h1(678))
  call Hloop_QV_A(ntryL,G1H4(92),wf4(:,11),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(587),n2h1(679))
  call Hloop_QV_A(ntryL,G1H4(96),wf4(:,11),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(588),n2h1(680))
  call Hloop_QV_A(ntryL,G1H4(97),wf4(:,11),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(589),n2h1(681))
  call Hloop_QV_A(ntryL,G1H4(98),wf4(:,11),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(590),n2h1(682))
  call Hloop_QV_A(ntryL,G1H4(102),wf4(:,11),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(591),n2h1(683))
  call Hloop_QV_A(ntryL,G1H4(103),wf4(:,11),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(592),n2h1(684))
  call Hloop_QV_A(ntryL,G1H4(104),wf4(:,11),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(593),n2h1(685))
  call Hloop_QV_A(ntryL,G1H4(108),wf4(:,11),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(594),n2h1(686))
  call Hloop_QV_A(ntryL,G1H4(109),wf4(:,11),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(595),n2h1(687))
  call Hloop_QV_A(ntryL,G1H4(110),wf4(:,11),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(596),n2h1(688))
  call Hloop_QV_A(ntryL,G1H4(114),wf4(:,11),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(597),n2h1(689))
  call Hloop_QZ_A(ntryL,G1H4(115),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,46),heltab2x4(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(598),n2h1(690))
  call Hloop_QZ_A(ntryL,G1H4(116),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,47),heltab2x4(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(599),n2h1(691))
  call Hloop_QZ_A(ntryL,G1H4(120),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,48),heltab2x4(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(600),n2h1(692))
  call Hloop_QZ_A(ntryL,G1H4(121),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,49),heltab2x4(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(601),n2h1(693))
  call Hloop_QZ_A(ntryL,G1H4(122),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,50),heltab2x4(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(602),n2h1(694))
  call Hloop_QZ_A(ntryL,G1H4(126),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,51),heltab2x4(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(603),n2h1(695))
  call Hloop_QZ_A(ntryL,G1H4(127),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,52),heltab2x4(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(604),n2h1(696))
  call Hloop_QZ_A(ntryL,G1H4(128),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,53),heltab2x4(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(605),n2h1(697))
  call Hloop_QZ_A(ntryL,G1H4(132),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,54),heltab2x4(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(606),n2h1(698))
  call Hloop_QZ_A(ntryL,G1H4(133),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,55),heltab2x4(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(607),n2h1(699))
  call Hloop_QZ_A(ntryL,G1H4(134),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,56),heltab2x4(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(608),n2h1(700))
  call Hloop_QZ_A(ntryL,G1H4(138),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,57),heltab2x4(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(609),n2h1(701))
  call Hloop_QZ_A(ntryL,G1H4(139),wf4(:,9),G1H1(1),ngZu,m3h4x1(:,58),heltab2x4(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(610),n2h1(702))
  call Hloop_QZ_A(ntryL,G1H4(140),wf4(:,9),G1H1(1),ngZu,m3h4x1(:,59),heltab2x4(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(611),n2h1(703))
  call Hloop_QZ_A(ntryL,G1H4(144),wf4(:,9),G1H1(1),ngZu,m3h4x1(:,60),heltab2x4(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(612),n2h1(704))
  call Hloop_QV_A(ntryL,G1H4(145),wf4(:,10),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(613),n2h1(705))
  call Hloop_QV_A(ntryL,G1H4(146),wf4(:,10),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(614),n2h1(706))
  call Hloop_QV_A(ntryL,G1H4(150),wf4(:,10),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(615),n2h1(707))
  call Hloop_QV_A(ntryL,G1H4(151),wf4(:,10),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(616),n2h1(708))
  call Hloop_QV_A(ntryL,G1H4(152),wf4(:,10),G1H1(1),m3h4x1(:,65),heltab2x4(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(617),n2h1(709))
  call Hloop_QV_A(ntryL,G1H4(156),wf4(:,10),G1H1(1),m3h4x1(:,66),heltab2x4(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(618),n2h1(710))
  call Hloop_QV_A(ntryL,G1H4(157),wf4(:,10),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(619),n2h1(711))
  call Hloop_QV_A(ntryL,G1H4(158),wf4(:,10),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(620),n2h1(712))
  call Hloop_QV_A(ntryL,G1H4(162),wf4(:,10),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(621),n2h1(713))
  call Hloop_QV_A(ntryL,G1H4(163),wf4(:,10),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(622),n2h1(714))
  call Hloop_QV_A(ntryL,G1H4(164),wf4(:,10),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(623),n2h1(715))
  call Hloop_QV_A(ntryL,G1H4(168),wf4(:,10),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(624),n2h1(716))
  call Hloop_QZ_A(ntryL,G1H4(169),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,73),heltab2x4(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(625),n2h1(717))
  call Hloop_QZ_A(ntryL,G1H4(170),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,74),heltab2x4(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(626),n2h1(718))
  call Hloop_QZ_A(ntryL,G1H4(174),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,75),heltab2x4(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(627),n2h1(719))
  call Hloop_QZ_A(ntryL,G1H4(175),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,76),heltab2x4(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(628),n2h1(720))
  call Hloop_QZ_A(ntryL,G1H4(176),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,77),heltab2x4(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(629),n2h1(721))
  call Hloop_QZ_A(ntryL,G1H4(180),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,78),heltab2x4(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(630),n2h1(722))
  call Hloop_QZ_A(ntryL,G1H4(181),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,79),heltab2x4(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(631),n2h1(723))
  call Hloop_QZ_A(ntryL,G1H4(182),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,80),heltab2x4(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(632),n2h1(724))
  call Hloop_QZ_A(ntryL,G1H4(186),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,81),heltab2x4(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(633),n2h1(725))
  call Hloop_QZ_A(ntryL,G1H4(187),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,82),heltab2x4(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(634),n2h1(726))
  call Hloop_QZ_A(ntryL,G1H4(188),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,83),heltab2x4(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(635),n2h1(727))
  call Hloop_QZ_A(ntryL,G1H4(192),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,84),heltab2x4(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(636),n2h1(728))
  call Hloop_QV_A(ntryL,G1H4(193),wf4(:,10),G1H1(1),m3h4x1(:,85),heltab2x4(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(637),n2h1(729))
  call Hloop_QV_A(ntryL,G1H4(194),wf4(:,10),G1H1(1),m3h4x1(:,86),heltab2x4(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(638),n2h1(730))
  call Hloop_QV_A(ntryL,G1H4(198),wf4(:,10),G1H1(1),m3h4x1(:,87),heltab2x4(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(639),n2h1(731))
  call Hloop_QV_A(ntryL,G1H4(199),wf4(:,10),G1H1(1),m3h4x1(:,88),heltab2x4(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(640),n2h1(732))
  call Hloop_QV_A(ntryL,G1H4(200),wf4(:,10),G1H1(1),m3h4x1(:,89),heltab2x4(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(641),n2h1(733))
  call Hloop_QV_A(ntryL,G1H4(204),wf4(:,10),G1H1(1),m3h4x1(:,90),heltab2x4(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(642),n2h1(734))
  call Hloop_QV_A(ntryL,G1H4(205),wf4(:,10),G1H1(1),m3h4x1(:,91),heltab2x4(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(643),n2h1(735))
  call Hloop_QV_A(ntryL,G1H4(206),wf4(:,10),G1H1(1),m3h4x1(:,92),heltab2x4(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(644),n2h1(736))
  call Hloop_QV_A(ntryL,G1H4(210),wf4(:,10),G1H1(1),m3h4x1(:,93),heltab2x4(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(645),n2h1(737))
  call Hloop_QV_A(ntryL,G1H4(211),wf4(:,10),G1H1(1),m3h4x1(:,94),heltab2x4(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(646),n2h1(738))
  call Hloop_QV_A(ntryL,G1H4(212),wf4(:,10),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(647),n2h1(739))
  call Hloop_QV_A(ntryL,G1H4(216),wf4(:,10),G1H1(1),m3h4x1(:,96),heltab2x4(:,:,384))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(648),n2h1(740))
  call Hloop_QV_A(ntryL,G1H4(217),wf4(:,10),G1H1(1),m3h4x1(:,97),heltab2x4(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(649),n2h1(741))
  call Hloop_QV_A(ntryL,G1H4(218),wf4(:,10),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(650),n2h1(742))
  call Hloop_QV_A(ntryL,G1H4(222),wf4(:,10),G1H1(1),m3h4x1(:,99),heltab2x4(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(651),n2h1(743))
  call Hloop_QZ_A(ntryL,G1H4(223),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,100),heltab2x4(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(652),n2h1(744))
  call Hloop_QZ_A(ntryL,G1H4(224),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,101),heltab2x4(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(653),n2h1(745))
  call Hloop_QZ_A(ntryL,G1H4(228),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,102),heltab2x4(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(654),n2h1(746))
  call Hloop_QZ_A(ntryL,G1H4(229),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,103),heltab2x4(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(655),n2h1(747))
  call Hloop_QZ_A(ntryL,G1H4(230),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,104),heltab2x4(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(656),n2h1(748))
  call Hloop_QZ_A(ntryL,G1H4(234),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,105),heltab2x4(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(657),n2h1(749))
  call Hloop_QZ_A(ntryL,G1H4(235),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,106),heltab2x4(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(658),n2h1(750))
  call Hloop_QZ_A(ntryL,G1H4(236),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,107),heltab2x4(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(659),n2h1(751))
  call Hloop_QZ_A(ntryL,G1H4(240),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,108),heltab2x4(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(660),n2h1(752))
  call Hloop_QZ_A(ntryL,G1H4(241),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,109),heltab2x4(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(661),n2h1(753))
  call Hloop_QZ_A(ntryL,G1H4(242),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,110),heltab2x4(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(662),n2h1(754))
  call Hloop_QZ_A(ntryL,G1H4(246),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,111),heltab2x4(:,:,399))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(663),n2h1(755))
  call Hloop_QZ_A(ntryL,G1H4(247),wf4(:,8),G1H1(1),ngZu,m3h4x1(:,112),heltab2x4(:,:,400))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(664),n2h1(756))
  call Hloop_QZ_A(ntryL,G1H4(248),wf4(:,8),G1H1(1),ngZu,m3h4x1(:,113),heltab2x4(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(665),n2h1(757))
  call Hloop_QZ_A(ntryL,G1H4(252),wf4(:,8),G1H1(1),ngZu,m3h4x1(:,114),heltab2x4(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(666),n2h1(758))
  call Hloop_QV_A(ntryL,G1H4(253),wf4(:,5),G1H1(1),m3h4x1(:,115),heltab2x4(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(667),n2h1(759))
  call Hloop_QV_A(ntryL,G1H4(254),wf4(:,5),G1H1(1),m3h4x1(:,116),heltab2x4(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(668),n2h1(760))
  call Hloop_QV_A(ntryL,G1H4(258),wf4(:,5),G1H1(1),m3h4x1(:,117),heltab2x4(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(669),n2h1(761))
  call Hloop_QV_A(ntryL,G1H4(259),wf4(:,5),G1H1(1),m3h4x1(:,118),heltab2x4(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(670),n2h1(762))
  call Hloop_QV_A(ntryL,G1H4(260),wf4(:,5),G1H1(1),m3h4x1(:,119),heltab2x4(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(671),n2h1(763))
  call Hloop_QV_A(ntryL,G1H4(264),wf4(:,5),G1H1(1),m3h4x1(:,120),heltab2x4(:,:,408))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(672),n2h1(764))
  call Hloop_QV_A(ntryL,G1H4(265),wf4(:,5),G1H1(1),m3h4x1(:,121),heltab2x4(:,:,409))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(673),n2h1(765))
  call Hloop_QV_A(ntryL,G1H4(266),wf4(:,5),G1H1(1),m3h4x1(:,122),heltab2x4(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(674),n2h1(766))
  call Hloop_QV_A(ntryL,G1H4(270),wf4(:,5),G1H1(1),m3h4x1(:,123),heltab2x4(:,:,411))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(675),n2h1(767))
  call Hloop_QV_A(ntryL,G1H4(271),wf4(:,5),G1H1(1),m3h4x1(:,124),heltab2x4(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(676),n2h1(768))
  call Hloop_QV_A(ntryL,G1H4(272),wf4(:,5),G1H1(1),m3h4x1(:,125),heltab2x4(:,:,413))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(677),n2h1(769))
  call Hloop_QV_A(ntryL,G1H4(276),wf4(:,5),G1H1(1),m3h4x1(:,126),heltab2x4(:,:,414))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(678),n2h1(770))
  call Hloop_QZ_A(ntryL,G1H4(277),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,127),heltab2x4(:,:,415))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(679),n2h1(771))
  call Hloop_QZ_A(ntryL,G1H4(278),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,128),heltab2x4(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(680),n2h1(772))
  call Hloop_QZ_A(ntryL,G1H4(282),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,129),heltab2x4(:,:,417))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(681),n2h1(773))
  call Hloop_QZ_A(ntryL,G1H4(283),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,130),heltab2x4(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(682),n2h1(774))
  call Hloop_QZ_A(ntryL,G1H4(284),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,131),heltab2x4(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(683),n2h1(775))
  call Hloop_QZ_A(ntryL,G1H4(288),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,132),heltab2x4(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(684),n2h1(776))
  call Hloop_QZ_A(ntryL,G1H4(289),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,133),heltab2x4(:,:,421))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(685),n2h1(777))
  call Hloop_QZ_A(ntryL,G1H4(290),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,134),heltab2x4(:,:,422))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(686),n2h1(778))
  call Hloop_QZ_A(ntryL,G1H4(294),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,135),heltab2x4(:,:,423))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(687),n2h1(779))
  call Hloop_QZ_A(ntryL,G1H4(295),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,136),heltab2x4(:,:,424))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(688),n2h1(780))
  call Hloop_QZ_A(ntryL,G1H4(296),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,137),heltab2x4(:,:,425))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(689),n2h1(781))
  call Hloop_QZ_A(ntryL,G1H4(300),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,138),heltab2x4(:,:,426))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(690),n2h1(782))
  call Hloop_QV_A(ntryL,G1H4(301),wf4(:,5),G1H1(1),m3h4x1(:,139),heltab2x4(:,:,427))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(691),n2h1(783))
  call Hloop_QV_A(ntryL,G1H4(302),wf4(:,5),G1H1(1),m3h4x1(:,140),heltab2x4(:,:,428))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(692),n2h1(784))
  call Hloop_QV_A(ntryL,G1H4(306),wf4(:,5),G1H1(1),m3h4x1(:,141),heltab2x4(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(693),n2h1(785))
  call Hloop_QV_A(ntryL,G1H4(307),wf4(:,5),G1H1(1),m3h4x1(:,142),heltab2x4(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(694),n2h1(786))
  call Hloop_QV_A(ntryL,G1H4(308),wf4(:,5),G1H1(1),m3h4x1(:,143),heltab2x4(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(695),n2h1(787))
  call Hloop_QV_A(ntryL,G1H4(312),wf4(:,5),G1H1(1),m3h4x1(:,144),heltab2x4(:,:,432))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(696),n2h1(788))
  call Hloop_QV_A(ntryL,G1H4(313),wf4(:,5),G1H1(1),m3h4x1(:,145),heltab2x4(:,:,433))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(697),n2h1(789))
  call Hloop_QV_A(ntryL,G1H4(314),wf4(:,5),G1H1(1),m3h4x1(:,146),heltab2x4(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(698),n2h1(790))
  call Hloop_QV_A(ntryL,G1H4(318),wf4(:,5),G1H1(1),m3h4x1(:,147),heltab2x4(:,:,435))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(699),n2h1(791))
  call Hloop_QV_A(ntryL,G1H4(319),wf4(:,5),G1H1(1),m3h4x1(:,148),heltab2x4(:,:,436))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(700),n2h1(792))
  call Hloop_QV_A(ntryL,G1H4(320),wf4(:,5),G1H1(1),m3h4x1(:,149),heltab2x4(:,:,437))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(701),n2h1(793))
  call Hloop_QV_A(ntryL,G1H4(324),wf4(:,5),G1H1(1),m3h4x1(:,150),heltab2x4(:,:,438))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(702),n2h1(794))
  call Hloop_QV_A(ntryL,G1H4(325),wf4(:,5),G1H1(1),m3h4x1(:,151),heltab2x4(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(703),n2h1(795))
  call Hloop_QV_A(ntryL,G1H4(326),wf4(:,5),G1H1(1),m3h4x1(:,152),heltab2x4(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(704),n2h1(796))
  call Hloop_QV_A(ntryL,G1H4(330),wf4(:,5),G1H1(1),m3h4x1(:,153),heltab2x4(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(705),n2h1(797))
  call Hloop_QZ_A(ntryL,G1H4(331),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,154),heltab2x4(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(706),n2h1(798))
  call Hloop_QZ_A(ntryL,G1H4(332),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,155),heltab2x4(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(707),n2h1(799))
  call Hloop_QZ_A(ntryL,G1H4(336),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,156),heltab2x4(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(708),n2h1(800))
  call Hloop_QZ_A(ntryL,G1H4(337),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,157),heltab2x4(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(709),n2h1(801))
  call Hloop_QZ_A(ntryL,G1H4(338),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,158),heltab2x4(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(710),n2h1(802))
  call Hloop_QZ_A(ntryL,G1H4(342),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,159),heltab2x4(:,:,447))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(711),n2h1(803))
  call Hloop_QZ_A(ntryL,G1H4(343),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,160),heltab2x4(:,:,448))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(712),n2h1(804))
  call Hloop_QZ_A(ntryL,G1H4(344),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,161),heltab2x4(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(713),n2h1(805))
  call Hloop_QZ_A(ntryL,G1H4(348),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,162),heltab2x4(:,:,450))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(714),n2h1(806))
  call Hloop_QZ_A(ntryL,G1H4(349),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,163),heltab2x4(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(715),n2h1(807))
  call Hloop_QZ_A(ntryL,G1H4(350),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,164),heltab2x4(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(716),n2h1(808))
  call Hloop_QZ_A(ntryL,G1H4(354),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,165),heltab2x4(:,:,453))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(717),n2h1(809))
  call Hloop_QZ_A(ntryL,G1H4(355),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,166),heltab2x4(:,:,454))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(718),n2h1(810))
  call Hloop_QZ_A(ntryL,G1H4(356),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,167),heltab2x4(:,:,455))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(719),n2h1(811))
  call Hloop_QZ_A(ntryL,G1H4(360),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,168),heltab2x4(:,:,456))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(720),n2h1(812))
  call Hloop_VA_Q(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,685),heltab2x2(:,:,685))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(721),n2h1(813))
  call Hloop_VA_Q(ntryL,G1H2(173),ex4(:),G1H1(1),m3h2x1(:,686),heltab2x2(:,:,686))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(722),n2h1(814))
  call Hloop_VA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,687),heltab2x2(:,:,687))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(723),n2h1(815))
  call Hloop_ZA_Q(ntryL,G1H2(82),ex4(:),G1H1(1),ngZl,m3h2x1(:,688),heltab2x2(:,:,688))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(724),n2h1(816))
  call Hloop_ZA_Q(ntryL,G1H2(84),ex4(:),G1H1(1),ngZl,m3h2x1(:,689),heltab2x2(:,:,689))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(725),n2h1(817))
  call Hloop_ZA_Q(ntryL,G1H2(96),ex4(:),G1H1(1),ngZl,m3h2x1(:,690),heltab2x2(:,:,690))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(726),n2h1(818))
  call Hloop_VA_Q(ntryL,G1H2(99),ex4(:),G1H1(1),m3h2x1(:,691),heltab2x2(:,:,691))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(727),n2h1(819))
  call Hloop_VA_Q(ntryL,G1H2(100),ex4(:),G1H1(1),m3h2x1(:,692),heltab2x2(:,:,692))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(728),n2h1(820))
  call Hloop_VA_Q(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,693),heltab2x2(:,:,693))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(729),n2h1(821))
  call Hloop_ZA_Q(ntryL,G1H2(112),ex4(:),G1H1(1),ngZl,m3h2x1(:,694),heltab2x2(:,:,694))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(730),n2h1(822))
  call Hloop_ZA_Q(ntryL,G1H2(114),ex4(:),G1H1(1),ngZl,m3h2x1(:,695),heltab2x2(:,:,695))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(731),n2h1(823))
  call Hloop_ZA_Q(ntryL,G1H2(124),ex4(:),G1H1(1),ngZl,m3h2x1(:,696),heltab2x2(:,:,696))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(732),n2h1(824))
  call Hloop_VA_Q(ntryL,G1H2(126),ex3(:),G1H1(1),m3h2x1(:,697),heltab2x2(:,:,697))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(733),n2h1(825))
  call Hloop_VA_Q(ntryL,G1H2(130),ex3(:),G1H1(1),m3h2x1(:,698),heltab2x2(:,:,698))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(734),n2h1(826))
  call Hloop_VA_Q(ntryL,G1H2(138),ex3(:),G1H1(1),m3h2x1(:,699),heltab2x2(:,:,699))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(735),n2h1(827))
  call Hloop_ZA_Q(ntryL,G1H2(142),ex3(:),G1H1(1),ngZl,m3h2x1(:,700),heltab2x2(:,:,700))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(736),n2h1(828))
  call Hloop_ZA_Q(ntryL,G1H2(144),ex3(:),G1H1(1),ngZl,m3h2x1(:,701),heltab2x2(:,:,701))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(737),n2h1(829))
  call Hloop_ZA_Q(ntryL,G1H2(153),ex3(:),G1H1(1),ngZl,m3h2x1(:,702),heltab2x2(:,:,702))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(738),n2h1(830))
  call Hloop_VA_Q(ntryL,G1H2(154),ex3(:),G1H1(1),m3h2x1(:,703),heltab2x2(:,:,703))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(739),n2h1(831))
  call Hloop_VA_Q(ntryL,G1H2(156),ex3(:),G1H1(1),m3h2x1(:,704),heltab2x2(:,:,704))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(740),n2h1(832))
  call Hloop_VA_Q(ntryL,G1H2(166),ex3(:),G1H1(1),m3h2x1(:,705),heltab2x2(:,:,705))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(741),n2h1(833))
  call Hloop_ZA_Q(ntryL,G1H2(168),ex3(:),G1H1(1),ngZl,m3h2x1(:,706),heltab2x2(:,:,706))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(742),n2h1(834))
  call Hloop_ZA_Q(ntryL,G1H2(172),ex3(:),G1H1(1),ngZl,m3h2x1(:,707),heltab2x2(:,:,707))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(743),n2h1(835))
  call Hloop_ZA_Q(ntryL,G1H2(180),ex3(:),G1H1(1),ngZl,m3h2x1(:,708),heltab2x2(:,:,708))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(744),n2h1(836))
  call Hloop_VA_Q(ntryL,G1H2(184),ex4(:),G1H1(1),m3h2x1(:,709),heltab2x2(:,:,709))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(745),n2h1(837))
  call Hloop_VA_Q(ntryL,G1H2(186),ex4(:),G1H1(1),m3h2x1(:,710),heltab2x2(:,:,710))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(746),n2h1(838))
  call Hloop_VA_Q(ntryL,G1H2(196),ex4(:),G1H1(1),m3h2x1(:,711),heltab2x2(:,:,711))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(747),n2h1(839))
  call Hloop_ZA_Q(ntryL,G1H2(215),ex4(:),G1H1(1),ngZl,m3h2x1(:,712),heltab2x2(:,:,712))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(748),n2h1(840))
  call Hloop_ZA_Q(ntryL,G1H2(197),ex4(:),G1H1(1),ngZl,m3h2x1(:,713),heltab2x2(:,:,713))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(749),n2h1(841))
  call Hloop_ZA_Q(ntryL,G1H2(207),ex4(:),G1H1(1),ngZl,m3h2x1(:,714),heltab2x2(:,:,714))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(750),n2h1(842))
  call Hloop_VA_Q(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,715),heltab2x2(:,:,715))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(751),n2h1(843))
  call Hloop_VA_Q(ntryL,G1H2(233),ex4(:),G1H1(1),m3h2x1(:,716),heltab2x2(:,:,716))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(752),n2h1(844))
  call Hloop_VA_Q(ntryL,G1H2(220),ex4(:),G1H1(1),m3h2x1(:,717),heltab2x2(:,:,717))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(753),n2h1(845))
  call Hloop_ZA_Q(ntryL,G1H2(239),ex4(:),G1H1(1),ngZl,m3h2x1(:,718),heltab2x2(:,:,718))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(754),n2h1(846))
  call Hloop_ZA_Q(ntryL,G1H2(221),ex4(:),G1H1(1),ngZl,m3h2x1(:,719),heltab2x2(:,:,719))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(755),n2h1(847))
  call Hloop_ZA_Q(ntryL,G1H2(238),ex4(:),G1H1(1),ngZl,m3h2x1(:,720),heltab2x2(:,:,720))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(756),n2h1(848))
  call Hloop_VA_Q(ntryL,G1H2(243),ex3(:),G1H1(1),m3h2x1(:,721),heltab2x2(:,:,721))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(757),n2h1(849))
  call Hloop_VA_Q(ntryL,G1H2(263),ex3(:),G1H1(1),m3h2x1(:,722),heltab2x2(:,:,722))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(758),n2h1(850))
  call Hloop_VA_Q(ntryL,G1H2(275),ex3(:),G1H1(1),m3h2x1(:,723),heltab2x2(:,:,723))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(759),n2h1(851))
  call Hloop_ZA_Q(ntryL,G1H2(251),ex3(:),G1H1(1),ngZl,m3h2x1(:,724),heltab2x2(:,:,724))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(760),n2h1(852))
  call Hloop_ZA_Q(ntryL,G1H2(252),ex3(:),G1H1(1),ngZl,m3h2x1(:,725),heltab2x2(:,:,725))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(761),n2h1(853))
  call Hloop_ZA_Q(ntryL,G1H2(261),ex3(:),G1H1(1),ngZl,m3h2x1(:,726),heltab2x2(:,:,726))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(762),n2h1(854))
  call Hloop_VA_Q(ntryL,G1H2(264),ex3(:),G1H1(1),m3h2x1(:,727),heltab2x2(:,:,727))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(763),n2h1(855))
  call Hloop_VA_Q(ntryL,G1H2(287),ex3(:),G1H1(1),m3h2x1(:,728),heltab2x2(:,:,728))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(764),n2h1(856))
  call Hloop_VA_Q(ntryL,G1H2(276),ex3(:),G1H1(1),m3h2x1(:,729),heltab2x2(:,:,729))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(765),n2h1(857))
  call Hloop_ZA_Q(ntryL,G1H2(282),ex3(:),G1H1(1),ngZl,m3h2x1(:,730),heltab2x2(:,:,730))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(766),n2h1(858))
  call Hloop_ZA_Q(ntryL,G1H2(288),ex3(:),G1H1(1),ngZl,m3h2x1(:,731),heltab2x2(:,:,731))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(767),n2h1(859))
  call Hloop_ZA_Q(ntryL,G1H2(297),ex3(:),G1H1(1),ngZl,m3h2x1(:,732),heltab2x2(:,:,732))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(768),n2h1(860))
  call Hloop_VA_Q(ntryL,G1H2(298),ex4(:),G1H1(1),m3h2x1(:,733),heltab2x2(:,:,733))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(769),n2h1(861))
  call Hloop_VA_Q(ntryL,G1H2(317),ex4(:),G1H1(1),m3h2x1(:,734),heltab2x2(:,:,734))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(770),n2h1(862))
  call Hloop_VA_Q(ntryL,G1H2(305),ex4(:),G1H1(1),m3h2x1(:,735),heltab2x2(:,:,735))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(771),n2h1(863))
  call Hloop_VA_Q(ntryL,G1H2(309),ex4(:),G1H1(1),m3h2x1(:,736),heltab2x2(:,:,736))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(772),n2h1(864))
  call Hloop_VA_Q(ntryL,G1H2(310),ex4(:),G1H1(1),m3h2x1(:,737),heltab2x2(:,:,737))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(773),n2h1(865))
  call Hloop_VA_Q(ntryL,G1H2(316),ex4(:),G1H1(1),m3h2x1(:,738),heltab2x2(:,:,738))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(774),n2h1(866))
  call Hloop_ZA_Q(ntryL,G1H2(322),ex4(:),G1H1(1),ngZl,m3h2x1(:,739),heltab2x2(:,:,739))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(775),n2h1(867))
  call Hloop_ZA_Q(ntryL,G1H2(341),ex4(:),G1H1(1),ngZl,m3h2x1(:,740),heltab2x2(:,:,740))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(776),n2h1(868))
  call Hloop_ZA_Q(ntryL,G1H2(334),ex4(:),G1H1(1),ngZl,m3h2x1(:,741),heltab2x2(:,:,741))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(777),n2h1(869))
  call Hloop_ZA_Q(ntryL,G1H2(340),ex4(:),G1H1(1),ngZl,m3h2x1(:,742),heltab2x2(:,:,742))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(778),n2h1(870))
  call Hloop_ZA_Q(ntryL,G1H2(345),ex4(:),G1H1(1),ngZl,m3h2x1(:,743),heltab2x2(:,:,743))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(779),n2h1(871))
  call Hloop_ZA_Q(ntryL,G1H2(351),ex4(:),G1H1(1),ngZl,m3h2x1(:,744),heltab2x2(:,:,744))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(780),n2h1(872))
  call Hloop_WA_Q(ntryL,G1H2(377),ex4(:),G1H1(1),m3h2x1(:,745),heltab2x2(:,:,745))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(781),n2h1(873))
  call Hloop_WA_Q(ntryL,G1H2(353),ex4(:),G1H1(1),m3h2x1(:,746),heltab2x2(:,:,746))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(782),n2h1(874))
  call Hloop_WA_Q(ntryL,G1H2(360),ex4(:),G1H1(1),m3h2x1(:,747),heltab2x2(:,:,747))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(783),n2h1(875))
  call Hloop_VA_Q(ntryL,G1H2(363),ex3(:),G1H1(1),m3h2x1(:,748),heltab2x2(:,:,748))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(784),n2h1(876))
  call Hloop_VA_Q(ntryL,G1H2(366),ex3(:),G1H1(1),m3h2x1(:,749),heltab2x2(:,:,749))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(785),n2h1(877))
  call Hloop_VA_Q(ntryL,G1H2(375),ex3(:),G1H1(1),m3h2x1(:,750),heltab2x2(:,:,750))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(786),n2h1(878))
  call Hloop_VA_Q(ntryL,G1H2(378),ex3(:),G1H1(1),m3h2x1(:,751),heltab2x2(:,:,751))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(787),n2h1(879))
  call Hloop_VA_Q(ntryL,G1H2(384),ex3(:),G1H1(1),m3h2x1(:,752),heltab2x2(:,:,752))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(788),n2h1(880))
  call Hloop_VA_Q(ntryL,G1H2(396),ex3(:),G1H1(1),m3h2x1(:,753),heltab2x2(:,:,753))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(789),n2h1(881))
  call Hloop_ZA_Q(ntryL,G1H2(399),ex3(:),G1H1(1),ngZl,m3h2x1(:,754),heltab2x2(:,:,754))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(790),n2h1(882))
  call Hloop_ZA_Q(ntryL,G1H2(400),ex3(:),G1H1(1),ngZl,m3h2x1(:,755),heltab2x2(:,:,755))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(791),n2h1(883))
  call Hloop_ZA_Q(ntryL,G1H2(425),ex3(:),G1H1(1),ngZl,m3h2x1(:,756),heltab2x2(:,:,756))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(792),n2h1(884))
  call Hloop_ZA_Q(ntryL,G1H2(407),ex3(:),G1H1(1),ngZl,m3h2x1(:,757),heltab2x2(:,:,757))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(793),n2h1(885))
  call Hloop_ZA_Q(ntryL,G1H2(411),ex3(:),G1H1(1),ngZl,m3h2x1(:,758),heltab2x2(:,:,758))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(794),n2h1(886))
  call Hloop_ZA_Q(ntryL,G1H2(437),ex3(:),G1H1(1),ngZl,m3h2x1(:,759),heltab2x2(:,:,759))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(795),n2h1(887))
  call Hloop_WA_Q(ntryL,G1H2(419),ex3(:),G1H1(1),m3h2x1(:,760),heltab2x2(:,:,760))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(796),n2h1(888))
  call Hloop_WA_Q(ntryL,G1H2(424),ex3(:),G1H1(1),m3h2x1(:,761),heltab2x2(:,:,761))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(797),n2h1(889))
  call Hloop_WA_Q(ntryL,G1H2(435),ex3(:),G1H1(1),m3h2x1(:,762),heltab2x2(:,:,762))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(798),n2h1(890))
  call Hloop_VA_Q(ntryL,G1H2(436),ex4(:),G1H1(1),m3h2x1(:,763),heltab2x2(:,:,763))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(799),n2h1(891))
  call Hloop_VA_Q(ntryL,G1H2(442),ex4(:),G1H1(1),m3h2x1(:,764),heltab2x2(:,:,764))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(800),n2h1(892))
  call Hloop_VA_Q(ntryL,G1H2(449),ex4(:),G1H1(1),m3h2x1(:,765),heltab2x2(:,:,765))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(801),n2h1(893))
  call Hloop_ZA_Q(ntryL,G1H2(453),ex4(:),G1H1(1),ngZl,m3h2x1(:,766),heltab2x2(:,:,766))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(802),n2h1(894))
  call Hloop_ZA_Q(ntryL,G1H2(659),ex4(:),G1H1(1),ngZl,m3h2x1(:,767),heltab2x2(:,:,767))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(803),n2h1(895))
  call Hloop_ZA_Q(ntryL,G1H2(665),ex4(:),G1H1(1),ngZl,m3h2x1(:,768),heltab2x2(:,:,768))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(804),n2h1(896))
  call Hloop_VA_Q(ntryL,G1H2(479),ex4(:),G1H1(1),m3h2x1(:,769),heltab2x2(:,:,769))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(805),n2h1(897))
  call Hloop_VA_Q(ntryL,G1H2(467),ex4(:),G1H1(1),m3h2x1(:,770),heltab2x2(:,:,770))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(806),n2h1(898))
  call Hloop_VA_Q(ntryL,G1H2(485),ex4(:),G1H1(1),m3h2x1(:,771),heltab2x2(:,:,771))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(807),n2h1(899))
  call Hloop_ZA_Q(ntryL,G1H2(495),ex4(:),G1H1(1),ngZl,m3h2x1(:,772),heltab2x2(:,:,772))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(808),n2h1(900))
  call Hloop_ZA_Q(ntryL,G1H2(509),ex4(:),G1H1(1),ngZl,m3h2x1(:,773),heltab2x2(:,:,773))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(809),n2h1(901))
  call Hloop_ZA_Q(ntryL,G1H2(521),ex4(:),G1H1(1),ngZl,m3h2x1(:,774),heltab2x2(:,:,774))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(810),n2h1(902))
  call Hloop_WA_Q(ntryL,G1H2(503),ex4(:),G1H1(1),m3h2x1(:,775),heltab2x2(:,:,775))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(811),n2h1(903))
  call Hloop_WA_Q(ntryL,G1H2(504),ex4(:),G1H1(1),m3h2x1(:,776),heltab2x2(:,:,776))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(812),n2h1(904))
  call Hloop_WA_Q(ntryL,G1H2(515),ex4(:),G1H1(1),m3h2x1(:,777),heltab2x2(:,:,777))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(813),n2h1(905))
  call Hloop_VA_Q(ntryL,G1H2(516),ex3(:),G1H1(1),m3h2x1(:,778),heltab2x2(:,:,778))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(814),n2h1(906))
  call Hloop_VA_Q(ntryL,G1H2(519),ex3(:),G1H1(1),m3h2x1(:,779),heltab2x2(:,:,779))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(815),n2h1(907))
  call Hloop_VA_Q(ntryL,G1H2(528),ex3(:),G1H1(1),m3h2x1(:,780),heltab2x2(:,:,780))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(816),n2h1(908))
  call Hloop_ZA_Q(ntryL,G1H2(534),ex3(:),G1H1(1),ngZl,m3h2x1(:,781),heltab2x2(:,:,781))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(817),n2h1(909))
  call Hloop_ZA_Q(ntryL,G1H2(540),ex3(:),G1H1(1),ngZl,m3h2x1(:,782),heltab2x2(:,:,782))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(818),n2h1(910))
  call Hloop_ZA_Q(ntryL,G1H2(549),ex3(:),G1H1(1),ngZl,m3h2x1(:,783),heltab2x2(:,:,783))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(819),n2h1(911))
  call Hloop_VA_Q(ntryL,G1H2(749),ex3(:),G1H1(1),m3h2x1(:,784),heltab2x2(:,:,784))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(820),n2h1(912))
  call Hloop_VA_Q(ntryL,G1H2(557),ex3(:),G1H1(1),m3h2x1(:,785),heltab2x2(:,:,785))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(821),n2h1(913))
  call Hloop_VA_Q(ntryL,G1H2(761),ex3(:),G1H1(1),m3h2x1(:,786),heltab2x2(:,:,786))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(822),n2h1(914))
  call Hloop_ZA_Q(ntryL,G1H2(575),ex3(:),G1H1(1),ngZl,m3h2x1(:,787),heltab2x2(:,:,787))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(823),n2h1(915))
  call Hloop_ZA_Q(ntryL,G1H2(563),ex3(:),G1H1(1),ngZl,m3h2x1(:,788),heltab2x2(:,:,788))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(824),n2h1(916))
  call Hloop_ZA_Q(ntryL,G1H2(573),ex3(:),G1H1(1),ngZl,m3h2x1(:,789),heltab2x2(:,:,789))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(825),n2h1(917))
  call Hloop_WA_Q(ntryL,G1H2(785),ex3(:),G1H1(1),m3h2x1(:,790),heltab2x2(:,:,790))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(826),n2h1(918))
  call Hloop_WA_Q(ntryL,G1H2(593),ex3(:),G1H1(1),m3h2x1(:,791),heltab2x2(:,:,791))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(827),n2h1(919))
  call Hloop_WA_Q(ntryL,G1H2(611),ex3(:),G1H1(1),m3h2x1(:,792),heltab2x2(:,:,792))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(828),n2h1(920))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(62)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(68)])
  call ol_merge_tensors(G2tensor(381),[G2tensor(26),G1tensor(74)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(80)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(86)])
  call ol_merge_tensors(G2tensor(382),[G2tensor(32),G1tensor(92)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(98)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(104)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(110)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(116)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(122)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(128)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(134)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(140)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(146)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(152)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(158)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(164)])
  call ol_merge_tensors(G2tensor(383),[G2tensor(58),G1tensor(170)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(176)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(182)])
  call ol_merge_tensors(G2tensor(384),[G2tensor(64),G1tensor(188)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(194)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(200)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(206)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(212)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(218)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(224)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(230)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(236)])
  call ol_merge_tensors(G2tensor(769),[G2tensor(82),G1tensor(242)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(248)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(254)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(260)])
  call ol_merge_tensors(G2tensor(385),[G2tensor(90),G1tensor(266)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(272)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(278)])
  call ol_merge_tensors(G2tensor(386),[G2tensor(96),G1tensor(284)])
  call ol_merge_tensors(G2tensor(413),[G2tensor(98),G1tensor(290)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(296)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(302)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(308)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(314)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(320)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(326)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(332)])
  call ol_merge_tensors(G2tensor(114),[G1tensor(338)])
  call ol_merge_tensors(G2tensor(784),[G2tensor(116),G1tensor(344)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(350)])
  call ol_merge_tensors(G2tensor(120),[G1tensor(356)])
  call ol_merge_tensors(G2tensor(122),[G1tensor(362)])
  call ol_merge_tensors(G2tensor(387),[G2tensor(124),G1tensor(368)])
  call ol_merge_tensors(G2tensor(126),[G1tensor(374)])
  call ol_merge_tensors(G2tensor(128),[G1tensor(380)])
  call ol_merge_tensors(G2tensor(388),[G2tensor(130),G1tensor(386)])
  call ol_merge_tensors(G2tensor(415),[G2tensor(132),G1tensor(392)])
  call ol_merge_tensors(G2tensor(134),[G1tensor(398)])
  call ol_merge_tensors(G2tensor(136),[G1tensor(404)])
  call ol_merge_tensors(G2tensor(138),[G1tensor(410)])
  call ol_merge_tensors(G2tensor(140),[G1tensor(416)])
  call ol_merge_tensors(G2tensor(142),[G1tensor(422)])
  call ol_merge_tensors(G2tensor(144),[G1tensor(428)])
  call ol_merge_tensors(G2tensor(146),[G1tensor(434)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(440)])
  call ol_merge_tensors(G2tensor(150),[G1tensor(446)])
  call ol_merge_tensors(G2tensor(152),[G1tensor(452)])
  call ol_merge_tensors(G2tensor(154),[G1tensor(458)])
  call ol_merge_tensors(G2tensor(156),[G1tensor(464)])
  call ol_merge_tensors(G2tensor(158),[G1tensor(470)])
  call ol_merge_tensors(G2tensor(160),[G1tensor(476)])
  call ol_merge_tensors(G2tensor(162),[G1tensor(482)])
  call ol_merge_tensors(G2tensor(164),[G1tensor(488)])
  call ol_merge_tensors(G2tensor(799),[G2tensor(166),G1tensor(494)])
  call ol_merge_tensors(G2tensor(168),[G1tensor(500)])
  call ol_merge_tensors(G2tensor(170),[G1tensor(506)])
  call ol_merge_tensors(G2tensor(172),[G1tensor(512)])
  call ol_merge_tensors(G2tensor(174),[G1tensor(518)])
  call ol_merge_tensors(G2tensor(389),[G2tensor(176),G1tensor(524)])
  call ol_merge_tensors(G2tensor(178),[G1tensor(530)])
  call ol_merge_tensors(G2tensor(390),[G2tensor(180),G1tensor(536)])
  call ol_merge_tensors(G2tensor(417),[G2tensor(182),G1tensor(542)])
  call ol_merge_tensors(G2tensor(184),[G1tensor(548)])
  call ol_merge_tensors(G2tensor(186),[G1tensor(554)])
  call ol_merge_tensors(G2tensor(188),[G1tensor(560)])
  call ol_merge_tensors(G2tensor(190),[G1tensor(566)])
  call ol_merge_tensors(G2tensor(192),[G1tensor(572)])
  call ol_merge_tensors(G2tensor(194),[G1tensor(578)])
  call ol_merge_tensors(G2tensor(391),[G2tensor(196),G1tensor(584)])
  call ol_merge_tensors(G2tensor(392),[G2tensor(198),G1tensor(590)])
  call ol_merge_tensors(G2tensor(200),[G1tensor(596)])
  call ol_merge_tensors(G2tensor(202),[G1tensor(602)])
  call ol_merge_tensors(G2tensor(204),[G1tensor(608)])
  call ol_merge_tensors(G2tensor(206),[G1tensor(614)])
  call ol_merge_tensors(G2tensor(208),[G1tensor(620)])
  call ol_merge_tensors(G2tensor(210),[G1tensor(626)])
  call ol_merge_tensors(G2tensor(212),[G1tensor(632)])
  call ol_merge_tensors(G2tensor(214),[G1tensor(638)])
  call ol_merge_tensors(G2tensor(216),[G1tensor(644)])
  call ol_merge_tensors(G2tensor(218),[G1tensor(650)])
  call ol_merge_tensors(G2tensor(220),[G1tensor(656)])
  call ol_merge_tensors(G2tensor(222),[G1tensor(662)])
  call ol_merge_tensors(G2tensor(224),[G1tensor(668)])
  call ol_merge_tensors(G2tensor(226),[G1tensor(674)])
  call ol_merge_tensors(G2tensor(228),[G1tensor(680)])
  call ol_merge_tensors(G2tensor(230),[G1tensor(686)])
  call ol_merge_tensors(G2tensor(814),[G2tensor(232),G1tensor(692)])
  call ol_merge_tensors(G2tensor(234),[G1tensor(698)])
  call ol_merge_tensors(G2tensor(236),[G1tensor(704)])
  call ol_merge_tensors(G2tensor(238),[G1tensor(710)])
  call ol_merge_tensors(G2tensor(240),[G1tensor(716)])
  call ol_merge_tensors(G2tensor(393),[G2tensor(242),G1tensor(722)])
  call ol_merge_tensors(G2tensor(244),[G1tensor(728)])
  call ol_merge_tensors(G2tensor(394),[G2tensor(246),G1tensor(734)])
  call ol_merge_tensors(G2tensor(419),[G2tensor(248),G1tensor(740)])
  call ol_merge_tensors(G2tensor(250),[G1tensor(746)])
  call ol_merge_tensors(G2tensor(252),[G1tensor(752)])
  call ol_merge_tensors(G2tensor(254),[G1tensor(758)])
  call ol_merge_tensors(G2tensor(256),[G1tensor(764)])
  call ol_merge_tensors(G2tensor(258),[G1tensor(770)])
  call ol_merge_tensors(G2tensor(260),[G1tensor(776)])
  call ol_merge_tensors(G2tensor(395),[G2tensor(262),G1tensor(782)])
  call ol_merge_tensors(G2tensor(396),[G2tensor(264),G1tensor(788)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(9),G1tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(346),G1tensor(4)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(119),G1tensor(101),G1tensor(23),G1tensor(5)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(402),G1tensor(6)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(358),G1tensor(10)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(131),G1tensor(107),G1tensor(35),G1tensor(11)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(408),G1tensor(12)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(27),G1tensor(15)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(352),G1tensor(16)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(137),G1tensor(113),G1tensor(41),G1tensor(17)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(420),G1tensor(18)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(33),G1tensor(21)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(364),G1tensor(22)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(414),G1tensor(24)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(370),G1tensor(28)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(143),G1tensor(125),G1tensor(47),G1tensor(29)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(432),G1tensor(30)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(382),G1tensor(34)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(426),G1tensor(36)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(45),G1tensor(39)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(376),G1tensor(40)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(438),G1tensor(42)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(388),G1tensor(46)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(444),G1tensor(48)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(63),G1tensor(51)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(496),G1tensor(52)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(167),G1tensor(149),G1tensor(71),G1tensor(53)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(300),G1tensor(54)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(75),G1tensor(57)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(502),G1tensor(58)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(179),G1tensor(155),G1tensor(83),G1tensor(59)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(312),G1tensor(60)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(514),G1tensor(64)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(185),G1tensor(161),G1tensor(89),G1tensor(65)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(306),G1tensor(66)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(87),G1tensor(69)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(508),G1tensor(70)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(318),G1tensor(72)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(526),G1tensor(76)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(191),G1tensor(173),G1tensor(95),G1tensor(77)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(324),G1tensor(78)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(93),G1tensor(81)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(520),G1tensor(82)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(336),G1tensor(84)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(532),G1tensor(88)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(330),G1tensor(90)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(538),G1tensor(94)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(342),G1tensor(96)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(105),G1tensor(99)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(694),G1tensor(100)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(198),G1tensor(102)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(712),G1tensor(106)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(204),G1tensor(108)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(123),G1tensor(111)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(700),G1tensor(112)])
  call ol_merge_tensors(G2tensor(111),[G1tensor(210),G1tensor(114)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(129),G1tensor(117)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(706),G1tensor(118)])
  call ol_merge_tensors(G2tensor(117),[G1tensor(216),G1tensor(120)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(724),G1tensor(124)])
  call ol_merge_tensors(G2tensor(121),[G1tensor(222),G1tensor(126)])
  call ol_merge_tensors(G2tensor(123),[G1tensor(730),G1tensor(130)])
  call ol_merge_tensors(G2tensor(125),[G1tensor(228),G1tensor(132)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(141),G1tensor(135)])
  call ol_merge_tensors(G2tensor(129),[G1tensor(718),G1tensor(136)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(234),G1tensor(138)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(736),G1tensor(142)])
  call ol_merge_tensors(G2tensor(135),[G1tensor(240),G1tensor(144)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(159),G1tensor(147)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(244),G1tensor(148)])
  call ol_merge_tensors(G2tensor(141),[G1tensor(600),G1tensor(150)])
  call ol_merge_tensors(G2tensor(143),[G1tensor(171),G1tensor(153)])
  call ol_merge_tensors(G2tensor(145),[G1tensor(250),G1tensor(154)])
  call ol_merge_tensors(G2tensor(147),[G1tensor(618),G1tensor(156)])
  call ol_merge_tensors(G2tensor(149),[G1tensor(256),G1tensor(160)])
  call ol_merge_tensors(G2tensor(151),[G1tensor(606),G1tensor(162)])
  call ol_merge_tensors(G2tensor(153),[G1tensor(183),G1tensor(165)])
  call ol_merge_tensors(G2tensor(155),[G1tensor(262),G1tensor(166)])
  call ol_merge_tensors(G2tensor(157),[G1tensor(612),G1tensor(168)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(268),G1tensor(172)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(630),G1tensor(174)])
  call ol_merge_tensors(G2tensor(163),[G1tensor(189),G1tensor(177)])
  call ol_merge_tensors(G2tensor(165),[G1tensor(274),G1tensor(178)])
  call ol_merge_tensors(G2tensor(167),[G1tensor(636),G1tensor(180)])
  call ol_merge_tensors(G2tensor(169),[G1tensor(280),G1tensor(184)])
  call ol_merge_tensors(G2tensor(171),[G1tensor(624),G1tensor(186)])
  call ol_merge_tensors(G2tensor(173),[G1tensor(286),G1tensor(190)])
  call ol_merge_tensors(G2tensor(175),[G1tensor(642),G1tensor(192)])
  call ol_merge_tensors(G2tensor(177),[G1tensor(201),G1tensor(195)])
  call ol_merge_tensors(G2tensor(179),[G1tensor(748),G1tensor(196)])
  call ol_merge_tensors(G2tensor(421),[G1tensor(215),G1tensor(197)])
  call ol_merge_tensors(G2tensor(181),[G1tensor(766),G1tensor(202)])
  call ol_merge_tensors(G2tensor(424),[G1tensor(227),G1tensor(203)])
  call ol_merge_tensors(G2tensor(183),[G1tensor(219),G1tensor(207)])
  call ol_merge_tensors(G2tensor(185),[G1tensor(760),G1tensor(208)])
  call ol_merge_tensors(G2tensor(427),[G1tensor(233),G1tensor(209)])
  call ol_merge_tensors(G2tensor(187),[G1tensor(225),G1tensor(213)])
  call ol_merge_tensors(G2tensor(189),[G1tensor(754),G1tensor(214)])
  call ol_merge_tensors(G2tensor(191),[G1tensor(784),G1tensor(220)])
  call ol_merge_tensors(G2tensor(430),[G1tensor(239),G1tensor(221)])
  call ol_merge_tensors(G2tensor(193),[G1tensor(778),G1tensor(226)])
  call ol_merge_tensors(G2tensor(195),[G1tensor(237),G1tensor(231)])
  call ol_merge_tensors(G2tensor(197),[G1tensor(772),G1tensor(232)])
  call ol_merge_tensors(G2tensor(199),[G1tensor(790),G1tensor(238)])
  call ol_merge_tensors(G2tensor(201),[G1tensor(255),G1tensor(243)])
  call ol_merge_tensors(G2tensor(433),[G1tensor(263),G1tensor(245)])
  call ol_merge_tensors(G2tensor(203),[G1tensor(648),G1tensor(246)])
  call ol_merge_tensors(G2tensor(205),[G1tensor(267),G1tensor(249)])
  call ol_merge_tensors(G2tensor(436),[G1tensor(275),G1tensor(251)])
  call ol_merge_tensors(G2tensor(207),[G1tensor(666),G1tensor(252)])
  call ol_merge_tensors(G2tensor(439),[G1tensor(281),G1tensor(257)])
  call ol_merge_tensors(G2tensor(209),[G1tensor(660),G1tensor(258)])
  call ol_merge_tensors(G2tensor(211),[G1tensor(279),G1tensor(261)])
  call ol_merge_tensors(G2tensor(213),[G1tensor(654),G1tensor(264)])
  call ol_merge_tensors(G2tensor(442),[G1tensor(287),G1tensor(269)])
  call ol_merge_tensors(G2tensor(215),[G1tensor(684),G1tensor(270)])
  call ol_merge_tensors(G2tensor(217),[G1tensor(285),G1tensor(273)])
  call ol_merge_tensors(G2tensor(219),[G1tensor(678),G1tensor(276)])
  call ol_merge_tensors(G2tensor(221),[G1tensor(672),G1tensor(282)])
  call ol_merge_tensors(G2tensor(223),[G1tensor(690),G1tensor(288)])
  call ol_merge_tensors(G2tensor(225),[G1tensor(291)])
  call ol_merge_tensors(G2tensor(445),[G1tensor(292)])
  call ol_merge_tensors(G2tensor(448),[G1tensor(293)])
  call ol_merge_tensors(G2tensor(451),[G2tensor(365),G1tensor(294)])
  call ol_merge_tensors(G2tensor(227),[G1tensor(303),G1tensor(297)])
  call ol_merge_tensors(G2tensor(229),[G1tensor(550),G1tensor(298)])
  call ol_merge_tensors(G2tensor(454),[G1tensor(317),G1tensor(299)])
  call ol_merge_tensors(G2tensor(231),[G1tensor(568),G1tensor(304)])
  call ol_merge_tensors(G2tensor(457),[G1tensor(329),G1tensor(305)])
  call ol_merge_tensors(G2tensor(233),[G1tensor(321),G1tensor(309)])
  call ol_merge_tensors(G2tensor(235),[G1tensor(562),G1tensor(310)])
  call ol_merge_tensors(G2tensor(460),[G1tensor(335),G1tensor(311)])
  call ol_merge_tensors(G2tensor(237),[G1tensor(327),G1tensor(315)])
  call ol_merge_tensors(G2tensor(239),[G1tensor(556),G1tensor(316)])
  call ol_merge_tensors(G2tensor(241),[G1tensor(586),G1tensor(322)])
  call ol_merge_tensors(G2tensor(463),[G1tensor(341),G1tensor(323)])
  call ol_merge_tensors(G2tensor(243),[G1tensor(580),G1tensor(328)])
  call ol_merge_tensors(G2tensor(245),[G1tensor(339),G1tensor(333)])
  call ol_merge_tensors(G2tensor(247),[G1tensor(574),G1tensor(334)])
  call ol_merge_tensors(G2tensor(249),[G1tensor(592),G1tensor(340)])
  call ol_merge_tensors(G2tensor(251),[G1tensor(357),G1tensor(345)])
  call ol_merge_tensors(G2tensor(466),[G1tensor(365),G1tensor(347)])
  call ol_merge_tensors(G2tensor(253),[G1tensor(450),G1tensor(348)])
  call ol_merge_tensors(G2tensor(255),[G1tensor(369),G1tensor(351)])
  call ol_merge_tensors(G2tensor(469),[G1tensor(377),G1tensor(353)])
  call ol_merge_tensors(G2tensor(257),[G1tensor(468),G1tensor(354)])
  call ol_merge_tensors(G2tensor(472),[G1tensor(383),G1tensor(359)])
  call ol_merge_tensors(G2tensor(259),[G1tensor(462),G1tensor(360)])
  call ol_merge_tensors(G2tensor(261),[G1tensor(381),G1tensor(363)])
  call ol_merge_tensors(G2tensor(263),[G1tensor(456),G1tensor(366)])
  call ol_merge_tensors(G2tensor(475),[G1tensor(389),G1tensor(371)])
  call ol_merge_tensors(G2tensor(265),[G1tensor(486),G1tensor(372)])
  call ol_merge_tensors(G2tensor(266),[G1tensor(387),G1tensor(375)])
  call ol_merge_tensors(G2tensor(267),[G1tensor(480),G1tensor(378)])
  call ol_merge_tensors(G2tensor(268),[G1tensor(474),G1tensor(384)])
  call ol_merge_tensors(G2tensor(269),[G1tensor(492),G1tensor(390)])
  call ol_merge_tensors(G2tensor(270),[G1tensor(393)])
  call ol_merge_tensors(G2tensor(478),[G1tensor(394)])
  call ol_merge_tensors(G2tensor(481),[G1tensor(395)])
  call ol_merge_tensors(G2tensor(484),[G2tensor(347),G1tensor(396)])
  call ol_merge_tensors(G2tensor(271),[G1tensor(405),G1tensor(399)])
  call ol_merge_tensors(G2tensor(272),[G1tensor(448),G1tensor(400)])
  call ol_merge_tensors(G2tensor(487),[G1tensor(413),G1tensor(401)])
  call ol_merge_tensors(G2tensor(273),[G1tensor(460),G1tensor(406)])
  call ol_merge_tensors(G2tensor(490),[G1tensor(425),G1tensor(407)])
  call ol_merge_tensors(G2tensor(274),[G1tensor(423),G1tensor(411)])
  call ol_merge_tensors(G2tensor(275),[G1tensor(454),G1tensor(412)])
  call ol_merge_tensors(G2tensor(276),[G1tensor(429),G1tensor(417)])
  call ol_merge_tensors(G2tensor(277),[G1tensor(466),G1tensor(418)])
  call ol_merge_tensors(G2tensor(493),[G1tensor(437),G1tensor(419)])
  call ol_merge_tensors(G2tensor(278),[G1tensor(472),G1tensor(424)])
  call ol_merge_tensors(G2tensor(279),[G1tensor(484),G1tensor(430)])
  call ol_merge_tensors(G2tensor(496),[G1tensor(443),G1tensor(431)])
  call ol_merge_tensors(G2tensor(280),[G1tensor(441),G1tensor(435)])
  call ol_merge_tensors(G2tensor(281),[G1tensor(478),G1tensor(436)])
  call ol_merge_tensors(G2tensor(282),[G1tensor(490),G1tensor(442)])
  call ol_merge_tensors(G2tensor(283),[G1tensor(459),G1tensor(447)])
  call ol_merge_tensors(G2tensor(284),[G1tensor(653),G1tensor(647),G1tensor(455),G1tensor(449)])
  call ol_merge_tensors(G2tensor(285),[G1tensor(471),G1tensor(453)])
  call ol_merge_tensors(G2tensor(286),[G1tensor(671),G1tensor(659),G1tensor(473),G1tensor(461)])
  call ol_merge_tensors(G2tensor(287),[G1tensor(483),G1tensor(465)])
  call ol_merge_tensors(G2tensor(288),[G1tensor(677),G1tensor(665),G1tensor(479),G1tensor(467)])
  call ol_merge_tensors(G2tensor(289),[G1tensor(489),G1tensor(477)])
  call ol_merge_tensors(G2tensor(290),[G1tensor(689),G1tensor(683),G1tensor(491),G1tensor(485)])
  call ol_merge_tensors(G2tensor(291),[G1tensor(513),G1tensor(495)])
  call ol_merge_tensors(G2tensor(499),[G1tensor(509),G1tensor(497)])
  call ol_merge_tensors(G2tensor(292),[G1tensor(552),G1tensor(498)])
  call ol_merge_tensors(G2tensor(293),[G1tensor(525),G1tensor(501)])
  call ol_merge_tensors(G2tensor(502),[G1tensor(521),G1tensor(503)])
  call ol_merge_tensors(G2tensor(294),[G1tensor(564),G1tensor(504)])
  call ol_merge_tensors(G2tensor(295),[G1tensor(531),G1tensor(507)])
  call ol_merge_tensors(G2tensor(296),[G1tensor(558),G1tensor(510)])
  call ol_merge_tensors(G2tensor(505),[G1tensor(533),G1tensor(515)])
  call ol_merge_tensors(G2tensor(297),[G1tensor(570),G1tensor(516)])
  call ol_merge_tensors(G2tensor(298),[G1tensor(537),G1tensor(519)])
  call ol_merge_tensors(G2tensor(299),[G1tensor(576),G1tensor(522)])
  call ol_merge_tensors(G2tensor(508),[G1tensor(539),G1tensor(527)])
  call ol_merge_tensors(G2tensor(300),[G1tensor(588),G1tensor(528)])
  call ol_merge_tensors(G2tensor(301),[G1tensor(582),G1tensor(534)])
  call ol_merge_tensors(G2tensor(302),[G1tensor(594),G1tensor(540)])
  call ol_merge_tensors(G2tensor(303),[G1tensor(543)])
  call ol_merge_tensors(G2tensor(511),[G1tensor(544)])
  call ol_merge_tensors(G2tensor(514),[G1tensor(545)])
  call ol_merge_tensors(G2tensor(517),[G2tensor(374),G1tensor(546)])
  call ol_merge_tensors(G2tensor(304),[G1tensor(567),G1tensor(549)])
  call ol_merge_tensors(G2tensor(305),[G1tensor(755),G1tensor(749),G1tensor(557),G1tensor(551)])
  call ol_merge_tensors(G2tensor(306),[G1tensor(579),G1tensor(555)])
  call ol_merge_tensors(G2tensor(307),[G1tensor(585),G1tensor(561)])
  call ol_merge_tensors(G2tensor(308),[G1tensor(773),G1tensor(761),G1tensor(575),G1tensor(563)])
  call ol_merge_tensors(G2tensor(309),[G1tensor(779),G1tensor(767),G1tensor(581),G1tensor(569)])
  call ol_merge_tensors(G2tensor(310),[G1tensor(591),G1tensor(573)])
  call ol_merge_tensors(G2tensor(311),[G1tensor(791),G1tensor(785),G1tensor(593),G1tensor(587)])
  call ol_merge_tensors(G2tensor(312),[G1tensor(603),G1tensor(597)])
  call ol_merge_tensors(G2tensor(313),[G1tensor(646),G1tensor(598)])
  call ol_merge_tensors(G2tensor(520),[G1tensor(611),G1tensor(599)])
  call ol_merge_tensors(G2tensor(314),[G1tensor(658),G1tensor(604)])
  call ol_merge_tensors(G2tensor(523),[G1tensor(623),G1tensor(605)])
  call ol_merge_tensors(G2tensor(315),[G1tensor(621),G1tensor(609)])
  call ol_merge_tensors(G2tensor(316),[G1tensor(652),G1tensor(610)])
  call ol_merge_tensors(G2tensor(317),[G1tensor(627),G1tensor(615)])
  call ol_merge_tensors(G2tensor(318),[G1tensor(664),G1tensor(616)])
  call ol_merge_tensors(G2tensor(526),[G1tensor(635),G1tensor(617)])
  call ol_merge_tensors(G2tensor(319),[G1tensor(670),G1tensor(622)])
  call ol_merge_tensors(G2tensor(320),[G1tensor(682),G1tensor(628)])
  call ol_merge_tensors(G2tensor(529),[G1tensor(641),G1tensor(629)])
  call ol_merge_tensors(G2tensor(321),[G1tensor(639),G1tensor(633)])
  call ol_merge_tensors(G2tensor(322),[G1tensor(676),G1tensor(634)])
  call ol_merge_tensors(G2tensor(323),[G1tensor(688),G1tensor(640)])
  call ol_merge_tensors(G2tensor(324),[G1tensor(657),G1tensor(645)])
  call ol_merge_tensors(G2tensor(325),[G1tensor(669),G1tensor(651)])
  call ol_merge_tensors(G2tensor(326),[G1tensor(681),G1tensor(663)])
  call ol_merge_tensors(G2tensor(327),[G1tensor(687),G1tensor(675)])
  call ol_merge_tensors(G2tensor(328),[G1tensor(711),G1tensor(693)])
  call ol_merge_tensors(G2tensor(532),[G1tensor(707),G1tensor(695)])
  call ol_merge_tensors(G2tensor(329),[G1tensor(750),G1tensor(696)])
  call ol_merge_tensors(G2tensor(330),[G1tensor(723),G1tensor(699)])
  call ol_merge_tensors(G2tensor(535),[G1tensor(719),G1tensor(701)])
  call ol_merge_tensors(G2tensor(331),[G1tensor(762),G1tensor(702)])
  call ol_merge_tensors(G2tensor(332),[G1tensor(729),G1tensor(705)])
  call ol_merge_tensors(G2tensor(333),[G1tensor(756),G1tensor(708)])
  call ol_merge_tensors(G2tensor(538),[G1tensor(731),G1tensor(713)])
  call ol_merge_tensors(G2tensor(334),[G1tensor(768),G1tensor(714)])
  call ol_merge_tensors(G2tensor(335),[G1tensor(735),G1tensor(717)])
  call ol_merge_tensors(G2tensor(336),[G1tensor(774),G1tensor(720)])
  call ol_merge_tensors(G2tensor(541),[G1tensor(737),G1tensor(725)])
  call ol_merge_tensors(G2tensor(337),[G1tensor(786),G1tensor(726)])
  call ol_merge_tensors(G2tensor(338),[G1tensor(780),G1tensor(732)])
  call ol_merge_tensors(G2tensor(339),[G1tensor(792),G1tensor(738)])
  call ol_merge_tensors(G2tensor(340),[G1tensor(741)])
  call ol_merge_tensors(G2tensor(544),[G1tensor(742)])
  call ol_merge_tensors(G2tensor(547),[G1tensor(743)])
  call ol_merge_tensors(G2tensor(550),[G2tensor(356),G1tensor(744)])
  call ol_merge_tensors(G2tensor(341),[G1tensor(765),G1tensor(747)])
  call ol_merge_tensors(G2tensor(342),[G1tensor(777),G1tensor(753)])
  call ol_merge_tensors(G2tensor(343),[G1tensor(783),G1tensor(759)])
  call ol_merge_tensors(G2tensor(344),[G1tensor(789),G1tensor(771)])
  call ol_merge_tensors(G2tensor(568),[G2tensor(553)])
  call ol_merge_tensors(G2tensor(571),[G2tensor(556)])
  call ol_merge_tensors(G2tensor(574),[G2tensor(559)])
  call ol_merge_tensors(G2tensor(577),[G2tensor(562)])
  call ol_merge_tensors(G2tensor(580),[G2tensor(565)])
  call ol_merge_tensors(G2tensor(598),[G2tensor(583)])
  call ol_merge_tensors(G2tensor(601),[G2tensor(586)])
  call ol_merge_tensors(G2tensor(604),[G2tensor(589)])
  call ol_merge_tensors(G2tensor(607),[G2tensor(592)])
  call ol_merge_tensors(G2tensor(610),[G2tensor(595)])
  call ol_merge_tensors(G2tensor(625),[G2tensor(613)])
  call ol_merge_tensors(G2tensor(628),[G2tensor(616)])
  call ol_merge_tensors(G2tensor(631),[G2tensor(619)])
  call ol_merge_tensors(G2tensor(634),[G2tensor(622)])
  call ol_merge_tensors(G2tensor(652),[G2tensor(637)])
  call ol_merge_tensors(G2tensor(655),[G2tensor(640)])
  call ol_merge_tensors(G2tensor(658),[G2tensor(643)])
  call ol_merge_tensors(G2tensor(661),[G2tensor(646)])
  call ol_merge_tensors(G2tensor(664),[G2tensor(649)])
  call ol_merge_tensors(G2tensor(679),[G2tensor(667)])
  call ol_merge_tensors(G2tensor(682),[G2tensor(670)])
  call ol_merge_tensors(G2tensor(685),[G2tensor(673)])
  call ol_merge_tensors(G2tensor(688),[G2tensor(676)])
  call ol_merge_tensors(G2tensor(706),[G2tensor(691)])
  call ol_merge_tensors(G2tensor(709),[G2tensor(694)])
  call ol_merge_tensors(G2tensor(712),[G2tensor(697)])
  call ol_merge_tensors(G2tensor(715),[G2tensor(700)])
  call ol_merge_tensors(G2tensor(718),[G2tensor(703)])
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(49),mass5set(:,21),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(49),mass5set(:,26),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),4)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(49),mass5set(:,27),  & 
G1tensor(73),G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103))
  call G_TensorShift(G1tensor(79),4)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(49),mass5set(:,28),  & 
G1tensor(109),G1tensor(115),G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139))
  call G_TensorShift(G1tensor(115),4)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(49),mass5set(:,29),  & 
G1tensor(145),G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(151),4)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(49),mass5set(:,30),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205),G1tensor(211))
  call G_TensorShift(G1tensor(187),4)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(49),mass5set(:,31),  & 
G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235),G1tensor(241),G1tensor(247))
  call G_TensorShift(G1tensor(223),4)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(49),mass5set(:,32),  & 
G1tensor(253),G1tensor(259),G1tensor(265),G1tensor(271),G1tensor(277),G1tensor(283))
  call G_TensorShift(G1tensor(259),4)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(50),mass5set(:,21),  & 
G1tensor(289),G1tensor(295),G1tensor(301),G1tensor(307),G1tensor(313),G1tensor(319))
  call G_TensorShift(G1tensor(295),8)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(50),mass5set(:,27),  & 
G1tensor(325),G1tensor(331),G1tensor(337),G1tensor(343),G1tensor(349),G1tensor(355))
  call G_TensorShift(G1tensor(331),8)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(50),mass5set(:,26),  & 
G1tensor(361),G1tensor(367),G1tensor(373),G1tensor(379),G1tensor(385),G1tensor(391))
  call G_TensorShift(G1tensor(367),8)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(50),mass5set(:,28),  & 
G1tensor(397),G1tensor(403),G1tensor(409),G1tensor(415),G1tensor(421),G1tensor(427))
  call G_TensorShift(G1tensor(403),8)
  call Hotf_5pt_reduction_last(G2tensor(381),RedSet_5(50),mass5set(:,29),  & 
G1tensor(433),G1tensor(439),G1tensor(445),G1tensor(451),G1tensor(457),G1tensor(463))
  call G_TensorShift(G1tensor(439),8)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(50),mass5set(:,31),  & 
G1tensor(469),G1tensor(475),G1tensor(481),G1tensor(487),G1tensor(493),G1tensor(499))
  call G_TensorShift(G1tensor(475),8)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(50),mass5set(:,30),  & 
G1tensor(505),G1tensor(511),G1tensor(517),G1tensor(523),G1tensor(529),G1tensor(535))
  call G_TensorShift(G1tensor(511),8)
  call Hotf_5pt_reduction_last(G2tensor(382),RedSet_5(50),mass5set(:,32),  & 
G1tensor(541),G1tensor(547),G1tensor(553),G1tensor(559),G1tensor(565),G1tensor(571))
  call G_TensorShift(G1tensor(547),8)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(51),mass5set(:,21),  & 
G1tensor(577),G1tensor(583),G1tensor(589),G1tensor(595),G1tensor(601),G1tensor(607))
  call G_TensorShift(G1tensor(583),4)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(51),mass5set(:,26),  & 
G1tensor(613),G1tensor(619),G1tensor(625),G1tensor(631),G1tensor(637),G1tensor(643))
  call G_TensorShift(G1tensor(619),4)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(51),mass5set(:,27),  & 
G1tensor(649),G1tensor(655),G1tensor(661),G1tensor(667),G1tensor(673),G1tensor(679))
  call G_TensorShift(G1tensor(655),4)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(51),mass5set(:,28),  & 
G1tensor(685),G1tensor(691),G1tensor(697),G1tensor(703),G1tensor(709),G1tensor(715))
  call G_TensorShift(G1tensor(691),4)
  call Hotf_5pt_reduction_last(G2tensor(42),RedSet_5(51),mass5set(:,29),  & 
G1tensor(721),G1tensor(727),G1tensor(733),G1tensor(739),G1tensor(745),G1tensor(751))
  call G_TensorShift(G1tensor(727),4)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(51),mass5set(:,30),  & 
G1tensor(757),G1tensor(763),G1tensor(769),G1tensor(775),G1tensor(781),G1tensor(787))
  call G_TensorShift(G1tensor(763),4)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(51),mass5set(:,31),  & 
G1tensor(2),G1tensor(8),G1tensor(14),G1tensor(20),G1tensor(26),G1tensor(32))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(51),mass5set(:,32),  & 
G1tensor(38),G1tensor(44),G1tensor(50),G1tensor(56),G1tensor(62),G1tensor(68))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(52),mass5set(:,21),  & 
G1tensor(74),G1tensor(80),G1tensor(86),G1tensor(92),G1tensor(98),G1tensor(104))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(52),mass5set(:,27),  & 
G1tensor(110),G1tensor(116),G1tensor(122),G1tensor(128),G1tensor(134),G1tensor(140))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(52),mass5set(:,26),  & 
G1tensor(146),G1tensor(152),G1tensor(158),G1tensor(164),G1tensor(170),G1tensor(176))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(56),RedSet_5(52),mass5set(:,28),  & 
G1tensor(182),G1tensor(188),G1tensor(194),G1tensor(200),G1tensor(206),G1tensor(212))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(383),RedSet_5(52),mass5set(:,29),  & 
G1tensor(218),G1tensor(224),G1tensor(230),G1tensor(236),G1tensor(242),G1tensor(248))
  call G_TensorShift(G1tensor(224),8)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(52),mass5set(:,31),  & 
G1tensor(254),G1tensor(260),G1tensor(266),G1tensor(272),G1tensor(278),G1tensor(284))
  call G_TensorShift(G1tensor(260),8)
  call Hotf_5pt_reduction_last(G2tensor(62),RedSet_5(52),mass5set(:,30),  & 
G1tensor(290),G1tensor(296),G1tensor(302),G1tensor(308),G1tensor(314),G1tensor(320))
  call G_TensorShift(G1tensor(296),8)
  call Hotf_5pt_reduction_last(G2tensor(384),RedSet_5(52),mass5set(:,32),  & 
G1tensor(326),G1tensor(332),G1tensor(338),G1tensor(344),G1tensor(350),G1tensor(356))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_5pt_reduction_last(G2tensor(66),RedSet_5(53),mass5set(:,21),  & 
G1tensor(362),G1tensor(368),G1tensor(374),G1tensor(380),G1tensor(386),G1tensor(392))
  call G_TensorShift(G1tensor(368),2)
  call Hotf_5pt_reduction_last(G2tensor(68),RedSet_5(53),mass5set(:,26),  & 
G1tensor(398),G1tensor(404),G1tensor(410),G1tensor(416),G1tensor(422),G1tensor(428))
  call G_TensorShift(G1tensor(404),2)
  call Hotf_5pt_reduction_last(G2tensor(70),RedSet_5(53),mass5set(:,27),  & 
G1tensor(434),G1tensor(440),G1tensor(446),G1tensor(452),G1tensor(458),G1tensor(464))
  call G_TensorShift(G1tensor(440),2)
  call Hotf_5pt_reduction_last(G2tensor(72),RedSet_5(53),mass5set(:,28),  & 
G1tensor(470),G1tensor(476),G1tensor(482),G1tensor(488),G1tensor(494),G1tensor(500))
  call G_TensorShift(G1tensor(476),2)
  call Hotf_5pt_reduction_last(G2tensor(74),RedSet_5(53),mass5set(:,29),  & 
G1tensor(506),G1tensor(512),G1tensor(518),G1tensor(524),G1tensor(530),G1tensor(536))
  call G_TensorShift(G1tensor(512),2)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(53),mass5set(:,30),  & 
G1tensor(542),G1tensor(548),G1tensor(554),G1tensor(560),G1tensor(566),G1tensor(572))
  call G_TensorShift(G1tensor(548),2)
  call Hotf_5pt_reduction_last(G2tensor(78),RedSet_5(53),mass5set(:,31),  & 
G1tensor(578),G1tensor(584),G1tensor(590),G1tensor(596),G1tensor(602),G1tensor(608))
  call G_TensorShift(G1tensor(584),2)
  call Hotf_5pt_reduction_last(G2tensor(80),RedSet_5(53),mass5set(:,32),  & 
G1tensor(614),G1tensor(620),G1tensor(626),G1tensor(632),G1tensor(638),G1tensor(644))
  call G_TensorShift(G1tensor(620),2)
  call Hotf_5pt_reduction_last(G2tensor(769),RedSet_5(19),mass5set(:,21),  & 
G1tensor(650),G1tensor(656),G1tensor(662),G1tensor(668),G1tensor(674),G1tensor(680))
  call G_TensorShift(G1tensor(656),8)
  call Hotf_5pt_reduction_last(G2tensor(84),RedSet_5(19),mass5set(:,27),  & 
G1tensor(686),G1tensor(692),G1tensor(698),G1tensor(704),G1tensor(710),G1tensor(716))
  call G_TensorShift(G1tensor(692),8)
  call Hotf_5pt_reduction_last(G2tensor(86),RedSet_5(19),mass5set(:,26),  & 
G1tensor(722),G1tensor(728),G1tensor(734),G1tensor(740),G1tensor(746),G1tensor(752))
  call G_TensorShift(G1tensor(728),8)
  call Hotf_5pt_reduction_last(G2tensor(88),RedSet_5(19),mass5set(:,28),  & 
G1tensor(758),G1tensor(764),G1tensor(770),G1tensor(776),G1tensor(782),G1tensor(788))
  call G_TensorShift(G1tensor(764),8)
  call Hotf_5pt_reduction_last(G2tensor(385),RedSet_5(19),mass5set(:,29),  & 
G1tensor(9),G1tensor(3),G1tensor(346),G1tensor(4),G1tensor(119),G1tensor(101))
  call G_TensorShift(G1tensor(3),8)
  call Hotf_5pt_reduction_last(G2tensor(92),RedSet_5(19),mass5set(:,31),  & 
G1tensor(23),G1tensor(5),G1tensor(402),G1tensor(6),G1tensor(358),G1tensor(10))
  call G_TensorShift(G1tensor(5),8)
  call Hotf_5pt_reduction_last(G2tensor(94),RedSet_5(19),mass5set(:,30),  & 
G1tensor(131),G1tensor(107),G1tensor(35),G1tensor(11),G1tensor(408),G1tensor(12))
  call G_TensorShift(G1tensor(107),8)
  call Hotf_5pt_reduction_last(G2tensor(386),RedSet_5(19),mass5set(:,32),  & 
G1tensor(27),G1tensor(15),G1tensor(352),G1tensor(16),G1tensor(137),G1tensor(113))
  call G_TensorShift(G1tensor(15),8)
  call Hotf_5pt_reduction_last(G2tensor(413),RedSet_5(19),mass5set(:,10),  & 
G1tensor(41),G1tensor(17),G1tensor(420),G1tensor(18),G1tensor(33),G1tensor(21))
  call G_TensorShift(G1tensor(17),8)
  call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(54),mass5set(:,21),  & 
G1tensor(364),G1tensor(22),G1tensor(414),G1tensor(24),G1tensor(370),G1tensor(28))
  call G_TensorShift(G1tensor(22),2)
  call Hotf_5pt_reduction_last(G2tensor(102),RedSet_5(54),mass5set(:,26),  & 
G1tensor(143),G1tensor(125),G1tensor(47),G1tensor(29),G1tensor(432),G1tensor(30))
  call G_TensorShift(G1tensor(125),2)
  call Hotf_5pt_reduction_last(G2tensor(104),RedSet_5(54),mass5set(:,27),  & 
G1tensor(382),G1tensor(34),G1tensor(426),G1tensor(36),G1tensor(45),G1tensor(39))
  call G_TensorShift(G1tensor(34),2)
  call Hotf_5pt_reduction_last(G2tensor(106),RedSet_5(54),mass5set(:,28),  & 
G1tensor(376),G1tensor(40),G1tensor(438),G1tensor(42),G1tensor(388),G1tensor(46))
  call G_TensorShift(G1tensor(40),2)
  call Hotf_5pt_reduction_last(G2tensor(108),RedSet_5(54),mass5set(:,29),  & 
G1tensor(444),G1tensor(48),G1tensor(63),G1tensor(51),G1tensor(496),G1tensor(52))
  call G_TensorShift(G1tensor(48),2)
  call Hotf_5pt_reduction_last(G2tensor(110),RedSet_5(54),mass5set(:,30),  & 
G1tensor(167),G1tensor(149),G1tensor(71),G1tensor(53),G1tensor(300),G1tensor(54))
  call G_TensorShift(G1tensor(149),2)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(54),mass5set(:,31),  & 
G1tensor(75),G1tensor(57),G1tensor(502),G1tensor(58),G1tensor(179),G1tensor(155))
  call G_TensorShift(G1tensor(57),2)
  call Hotf_5pt_reduction_last(G2tensor(114),RedSet_5(54),mass5set(:,32),  & 
G1tensor(83),G1tensor(59),G1tensor(312),G1tensor(60),G1tensor(514),G1tensor(64))
  call G_TensorShift(G1tensor(59),2)
  call Hotf_5pt_reduction_last(G2tensor(784),RedSet_5(20),mass5set(:,21),  & 
G1tensor(185),G1tensor(161),G1tensor(89),G1tensor(65),G1tensor(306),G1tensor(66))
  call G_TensorShift(G1tensor(161),4)
  call Hotf_5pt_reduction_last(G2tensor(118),RedSet_5(20),mass5set(:,27),  & 
G1tensor(87),G1tensor(69),G1tensor(508),G1tensor(70),G1tensor(318),G1tensor(72))
  call G_TensorShift(G1tensor(69),4)
  call Hotf_5pt_reduction_last(G2tensor(120),RedSet_5(20),mass5set(:,26),  & 
G1tensor(526),G1tensor(76),G1tensor(191),G1tensor(173),G1tensor(95),G1tensor(77))
  call G_TensorShift(G1tensor(76),4)
  call Hotf_5pt_reduction_last(G2tensor(122),RedSet_5(20),mass5set(:,28),  & 
G1tensor(324),G1tensor(78),G1tensor(93),G1tensor(81),G1tensor(520),G1tensor(82))
  call G_TensorShift(G1tensor(78),4)
  call Hotf_5pt_reduction_last(G2tensor(387),RedSet_5(20),mass5set(:,29),  & 
G1tensor(336),G1tensor(84),G1tensor(532),G1tensor(88),G1tensor(330),G1tensor(90))
  call G_TensorShift(G1tensor(84),4)
  call Hotf_5pt_reduction_last(G2tensor(126),RedSet_5(20),mass5set(:,31),  & 
G1tensor(538),G1tensor(94),G1tensor(342),G1tensor(96),G1tensor(105),G1tensor(99))
  call G_TensorShift(G1tensor(94),4)
  call Hotf_5pt_reduction_last(G2tensor(128),RedSet_5(20),mass5set(:,30),  & 
G1tensor(694),G1tensor(100),G1tensor(198),G1tensor(102),G1tensor(712),G1tensor(106))
  call G_TensorShift(G1tensor(100),4)
  call Hotf_5pt_reduction_last(G2tensor(388),RedSet_5(20),mass5set(:,32),  & 
G1tensor(204),G1tensor(108),G1tensor(123),G1tensor(111),G1tensor(700),G1tensor(112))
  call G_TensorShift(G1tensor(108),4)
  call Hotf_5pt_reduction_last(G2tensor(415),RedSet_5(20),mass5set(:,10),  & 
G1tensor(210),G1tensor(114),G1tensor(129),G1tensor(117),G1tensor(706),G1tensor(118))
  call G_TensorShift(G1tensor(114),4)
  call Hotf_5pt_reduction_last(G2tensor(134),RedSet_5(55),mass5set(:,21),  & 
G1tensor(216),G1tensor(120),G1tensor(724),G1tensor(124),G1tensor(222),G1tensor(126))
  call G_TensorShift(G1tensor(120),1)
  call Hotf_5pt_reduction_last(G2tensor(136),RedSet_5(55),mass5set(:,26),  & 
G1tensor(730),G1tensor(130),G1tensor(228),G1tensor(132),G1tensor(141),G1tensor(135))
  call G_TensorShift(G1tensor(130),1)
  call Hotf_5pt_reduction_last(G2tensor(138),RedSet_5(55),mass5set(:,28),  & 
G1tensor(718),G1tensor(136),G1tensor(234),G1tensor(138),G1tensor(736),G1tensor(142))
  call G_TensorShift(G1tensor(136),1)
  call Hotf_5pt_reduction_last(G2tensor(140),RedSet_5(55),mass5set(:,27),  & 
G1tensor(240),G1tensor(144),G1tensor(159),G1tensor(147),G1tensor(244),G1tensor(148))
  call G_TensorShift(G1tensor(144),1)
  call Hotf_5pt_reduction_last(G2tensor(142),RedSet_5(55),mass5set(:,30),  & 
G1tensor(600),G1tensor(150),G1tensor(171),G1tensor(153),G1tensor(250),G1tensor(154))
  call G_TensorShift(G1tensor(150),1)
  call Hotf_5pt_reduction_last(G2tensor(144),RedSet_5(55),mass5set(:,29),  & 
G1tensor(618),G1tensor(156),G1tensor(256),G1tensor(160),G1tensor(606),G1tensor(162))
  call G_TensorShift(G1tensor(156),1)
  call Hotf_5pt_reduction_last(G2tensor(146),RedSet_5(55),mass5set(:,31),  & 
G1tensor(183),G1tensor(165),G1tensor(262),G1tensor(166),G1tensor(612),G1tensor(168))
  call G_TensorShift(G1tensor(165),1)
  call Hotf_5pt_reduction_last(G2tensor(148),RedSet_5(55),mass5set(:,32),  & 
G1tensor(268),G1tensor(172),G1tensor(630),G1tensor(174),G1tensor(189),G1tensor(177))
  call G_TensorShift(G1tensor(172),1)
  call Hotf_5pt_reduction_last(G2tensor(150),RedSet_5(56),mass5set(:,21),  & 
G1tensor(274),G1tensor(178),G1tensor(636),G1tensor(180),G1tensor(280),G1tensor(184))
  call G_TensorShift(G1tensor(178),1)
  call Hotf_5pt_reduction_last(G2tensor(152),RedSet_5(56),mass5set(:,28),  & 
G1tensor(624),G1tensor(186),G1tensor(286),G1tensor(190),G1tensor(642),G1tensor(192))
  call G_TensorShift(G1tensor(186),1)
  call Hotf_5pt_reduction_last(G2tensor(154),RedSet_5(56),mass5set(:,26),  & 
G1tensor(201),G1tensor(195),G1tensor(748),G1tensor(196),G1tensor(215),G1tensor(197))
  call G_TensorShift(G1tensor(195),1)
  call Hotf_5pt_reduction_last(G2tensor(156),RedSet_5(56),mass5set(:,27),  & 
G1tensor(766),G1tensor(202),G1tensor(227),G1tensor(203),G1tensor(219),G1tensor(207))
  call G_TensorShift(G1tensor(202),1)
  call Hotf_5pt_reduction_last(G2tensor(158),RedSet_5(56),mass5set(:,30),  & 
G1tensor(760),G1tensor(208),G1tensor(233),G1tensor(209),G1tensor(225),G1tensor(213))
  call G_TensorShift(G1tensor(208),1)
  call Hotf_5pt_reduction_last(G2tensor(160),RedSet_5(56),mass5set(:,31),  & 
G1tensor(754),G1tensor(214),G1tensor(784),G1tensor(220),G1tensor(239),G1tensor(221))
  call G_TensorShift(G1tensor(214),1)
  call Hotf_5pt_reduction_last(G2tensor(162),RedSet_5(56),mass5set(:,29),  & 
G1tensor(778),G1tensor(226),G1tensor(237),G1tensor(231),G1tensor(772),G1tensor(232))
  call G_TensorShift(G1tensor(226),1)
  call Hotf_5pt_reduction_last(G2tensor(164),RedSet_5(56),mass5set(:,32),  & 
G1tensor(790),G1tensor(238),G1tensor(255),G1tensor(243),G1tensor(263),G1tensor(245))
  call G_TensorShift(G1tensor(238),1)
  call Hotf_5pt_reduction_last(G2tensor(799),RedSet_5(21),mass5set(:,21),  & 
G1tensor(648),G1tensor(246),G1tensor(267),G1tensor(249),G1tensor(275),G1tensor(251))
  call G_TensorShift(G1tensor(246),8)
  call Hotf_5pt_reduction_last(G2tensor(168),RedSet_5(21),mass5set(:,27),  & 
G1tensor(666),G1tensor(252),G1tensor(281),G1tensor(257),G1tensor(660),G1tensor(258))
  call G_TensorShift(G1tensor(252),8)
  call Hotf_5pt_reduction_last(G2tensor(170),RedSet_5(21),mass5set(:,28),  & 
G1tensor(279),G1tensor(261),G1tensor(654),G1tensor(264),G1tensor(287),G1tensor(269))
  call G_TensorShift(G1tensor(261),8)
  call Hotf_5pt_reduction_last(G2tensor(172),RedSet_5(21),mass5set(:,26),  & 
G1tensor(684),G1tensor(270),G1tensor(285),G1tensor(273),G1tensor(678),G1tensor(276))
  call G_TensorShift(G1tensor(270),8)
  call Hotf_5pt_reduction_last(G2tensor(174),RedSet_5(21),mass5set(:,31),  & 
G1tensor(672),G1tensor(282),G1tensor(690),G1tensor(288),G1tensor(291),G1tensor(292))
  call G_TensorShift(G1tensor(282),8)
  call Hotf_5pt_reduction_last(G2tensor(389),RedSet_5(21),mass5set(:,29),  & 
G1tensor(293),G1tensor(294),G1tensor(303),G1tensor(297),G1tensor(550),G1tensor(298))
  call G_TensorShift(G1tensor(294),8)
  call Hotf_5pt_reduction_last(G2tensor(178),RedSet_5(21),mass5set(:,30),  & 
G1tensor(317),G1tensor(299),G1tensor(568),G1tensor(304),G1tensor(329),G1tensor(305))
  call G_TensorShift(G1tensor(299),8)
  call Hotf_5pt_reduction_last(G2tensor(390),RedSet_5(21),mass5set(:,32),  & 
G1tensor(321),G1tensor(309),G1tensor(562),G1tensor(310),G1tensor(335),G1tensor(311))
  call G_TensorShift(G1tensor(309),8)
  call Hotf_5pt_reduction_last(G2tensor(417),RedSet_5(21),mass5set(:,10),  & 
G1tensor(327),G1tensor(315),G1tensor(556),G1tensor(316),G1tensor(586),G1tensor(322))
  call G_TensorShift(G1tensor(315),8)
  call Hotf_5pt_reduction_last(G2tensor(184),RedSet_5(57),mass5set(:,21),  & 
G1tensor(341),G1tensor(323),G1tensor(580),G1tensor(328),G1tensor(339),G1tensor(333))
  call G_TensorShift(G1tensor(323),2)
  call Hotf_5pt_reduction_last(G2tensor(186),RedSet_5(57),mass5set(:,28),  & 
G1tensor(574),G1tensor(334),G1tensor(592),G1tensor(340),G1tensor(357),G1tensor(345))
  call G_TensorShift(G1tensor(334),2)
  call Hotf_5pt_reduction_last(G2tensor(188),RedSet_5(57),mass5set(:,27),  & 
G1tensor(365),G1tensor(347),G1tensor(450),G1tensor(348),G1tensor(369),G1tensor(351))
  call G_TensorShift(G1tensor(347),2)
  call Hotf_5pt_reduction_last(G2tensor(190),RedSet_5(57),mass5set(:,26),  & 
G1tensor(377),G1tensor(353),G1tensor(468),G1tensor(354),G1tensor(383),G1tensor(359))
  call G_TensorShift(G1tensor(353),2)
  call Hotf_5pt_reduction_last(G2tensor(192),RedSet_5(57),mass5set(:,31),  & 
G1tensor(462),G1tensor(360),G1tensor(381),G1tensor(363),G1tensor(456),G1tensor(366))
  call G_TensorShift(G1tensor(360),2)
  call Hotf_5pt_reduction_last(G2tensor(194),RedSet_5(57),mass5set(:,30),  & 
G1tensor(389),G1tensor(371),G1tensor(486),G1tensor(372),G1tensor(387),G1tensor(375))
  call G_TensorShift(G1tensor(371),2)
  call Hotf_5pt_reduction_last(G2tensor(391),RedSet_5(57),mass5set(:,29),  & 
G1tensor(480),G1tensor(378),G1tensor(474),G1tensor(384),G1tensor(492),G1tensor(390))
  call G_TensorShift(G1tensor(378),2)
  call Hotf_5pt_reduction_last(G2tensor(392),RedSet_5(57),mass5set(:,32),  & 
G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396),G1tensor(405),G1tensor(399))
  call G_TensorShift(G1tensor(394),2)
  call Hotf_5pt_reduction_last(G2tensor(200),RedSet_5(58),mass5set(:,21),  & 
G1tensor(448),G1tensor(400),G1tensor(413),G1tensor(401),G1tensor(460),G1tensor(406))
  call G_TensorShift(G1tensor(400),1)
  call Hotf_5pt_reduction_last(G2tensor(202),RedSet_5(58),mass5set(:,26),  & 
G1tensor(425),G1tensor(407),G1tensor(423),G1tensor(411),G1tensor(454),G1tensor(412))
  call G_TensorShift(G1tensor(407),1)
  call Hotf_5pt_reduction_last(G2tensor(204),RedSet_5(58),mass5set(:,28),  & 
G1tensor(429),G1tensor(417),G1tensor(466),G1tensor(418),G1tensor(437),G1tensor(419))
  call G_TensorShift(G1tensor(417),1)
  call Hotf_5pt_reduction_last(G2tensor(206),RedSet_5(58),mass5set(:,27),  & 
G1tensor(472),G1tensor(424),G1tensor(484),G1tensor(430),G1tensor(443),G1tensor(431))
  call G_TensorShift(G1tensor(424),1)
  call Hotf_5pt_reduction_last(G2tensor(208),RedSet_5(58),mass5set(:,30),  & 
G1tensor(441),G1tensor(435),G1tensor(478),G1tensor(436),G1tensor(490),G1tensor(442))
  call G_TensorShift(G1tensor(435),1)
  call Hotf_5pt_reduction_last(G2tensor(210),RedSet_5(58),mass5set(:,29),  & 
G1tensor(459),G1tensor(447),G1tensor(653),G1tensor(647),G1tensor(455),G1tensor(449))
  call G_TensorShift(G1tensor(447),1)
  call Hotf_5pt_reduction_last(G2tensor(212),RedSet_5(58),mass5set(:,31),  & 
G1tensor(471),G1tensor(453),G1tensor(671),G1tensor(659),G1tensor(473),G1tensor(461))
  call G_TensorShift(G1tensor(453),1)
  call Hotf_5pt_reduction_last(G2tensor(214),RedSet_5(58),mass5set(:,32),  & 
G1tensor(483),G1tensor(465),G1tensor(677),G1tensor(665),G1tensor(479),G1tensor(467))
  call G_TensorShift(G1tensor(465),1)
  call Hotf_5pt_reduction_last(G2tensor(216),RedSet_5(59),mass5set(:,21),  & 
G1tensor(489),G1tensor(477),G1tensor(689),G1tensor(683),G1tensor(491),G1tensor(485))
  call G_TensorShift(G1tensor(477),1)
  call Hotf_5pt_reduction_last(G2tensor(218),RedSet_5(59),mass5set(:,28),  & 
G1tensor(513),G1tensor(495),G1tensor(509),G1tensor(497),G1tensor(552),G1tensor(498))
  call G_TensorShift(G1tensor(495),1)
  call Hotf_5pt_reduction_last(G2tensor(220),RedSet_5(59),mass5set(:,26),  & 
G1tensor(525),G1tensor(501),G1tensor(521),G1tensor(503),G1tensor(564),G1tensor(504))
  call G_TensorShift(G1tensor(501),1)
  call Hotf_5pt_reduction_last(G2tensor(222),RedSet_5(59),mass5set(:,27),  & 
G1tensor(531),G1tensor(507),G1tensor(558),G1tensor(510),G1tensor(533),G1tensor(515))
  call G_TensorShift(G1tensor(507),1)
  call Hotf_5pt_reduction_last(G2tensor(224),RedSet_5(59),mass5set(:,30),  & 
G1tensor(570),G1tensor(516),G1tensor(537),G1tensor(519),G1tensor(576),G1tensor(522))
  call G_TensorShift(G1tensor(516),1)
  call Hotf_5pt_reduction_last(G2tensor(226),RedSet_5(59),mass5set(:,31),  & 
G1tensor(539),G1tensor(527),G1tensor(588),G1tensor(528),G1tensor(582),G1tensor(534))
  call G_TensorShift(G1tensor(527),1)
  call Hotf_5pt_reduction_last(G2tensor(228),RedSet_5(59),mass5set(:,29),  & 
G1tensor(594),G1tensor(540),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(540),1)
  call Hotf_5pt_reduction_last(G2tensor(230),RedSet_5(59),mass5set(:,32),  & 
G1tensor(567),G1tensor(549),G1tensor(755),G1tensor(749),G1tensor(557),G1tensor(551))
  call G_TensorShift(G1tensor(549),1)
  call Hotf_5pt_reduction_last(G2tensor(814),RedSet_5(22),mass5set(:,21),  & 
G1tensor(579),G1tensor(555),G1tensor(585),G1tensor(561),G1tensor(773),G1tensor(761))
  call G_TensorShift(G1tensor(555),4)
  call Hotf_5pt_reduction_last(G2tensor(234),RedSet_5(22),mass5set(:,27),  & 
G1tensor(575),G1tensor(563),G1tensor(779),G1tensor(767),G1tensor(581),G1tensor(569))
  call G_TensorShift(G1tensor(563),4)
  call Hotf_5pt_reduction_last(G2tensor(236),RedSet_5(22),mass5set(:,28),  & 
G1tensor(591),G1tensor(573),G1tensor(791),G1tensor(785),G1tensor(593),G1tensor(587))
  call G_TensorShift(G1tensor(573),4)
  call Hotf_5pt_reduction_last(G2tensor(238),RedSet_5(22),mass5set(:,26),  & 
G1tensor(603),G1tensor(597),G1tensor(646),G1tensor(598),G1tensor(611),G1tensor(599))
  call G_TensorShift(G1tensor(597),4)
  call Hotf_5pt_reduction_last(G2tensor(240),RedSet_5(22),mass5set(:,31),  & 
G1tensor(658),G1tensor(604),G1tensor(623),G1tensor(605),G1tensor(621),G1tensor(609))
  call G_TensorShift(G1tensor(604),4)
  call Hotf_5pt_reduction_last(G2tensor(393),RedSet_5(22),mass5set(:,29),  & 
G1tensor(652),G1tensor(610),G1tensor(627),G1tensor(615),G1tensor(664),G1tensor(616))
  call G_TensorShift(G1tensor(610),4)
  call Hotf_5pt_reduction_last(G2tensor(244),RedSet_5(22),mass5set(:,30),  & 
G1tensor(635),G1tensor(617),G1tensor(670),G1tensor(622),G1tensor(682),G1tensor(628))
  call G_TensorShift(G1tensor(617),4)
  call Hotf_5pt_reduction_last(G2tensor(394),RedSet_5(22),mass5set(:,32),  & 
G1tensor(641),G1tensor(629),G1tensor(639),G1tensor(633),G1tensor(676),G1tensor(634))
  call G_TensorShift(G1tensor(629),4)
  call Hotf_5pt_reduction_last(G2tensor(419),RedSet_5(22),mass5set(:,10),  & 
G1tensor(688),G1tensor(640),G1tensor(657),G1tensor(645),G1tensor(669),G1tensor(651))
  call G_TensorShift(G1tensor(640),4)
  call Hotf_5pt_reduction_last(G2tensor(250),RedSet_5(60),mass5set(:,21),  & 
G1tensor(681),G1tensor(663),G1tensor(687),G1tensor(675),G1tensor(711),G1tensor(693))
  call G_TensorShift(G1tensor(663),2)
  call Hotf_5pt_reduction_last(G2tensor(252),RedSet_5(60),mass5set(:,28),  & 
G1tensor(707),G1tensor(695),G1tensor(750),G1tensor(696),G1tensor(723),G1tensor(699))
  call G_TensorShift(G1tensor(695),2)
  call Hotf_5pt_reduction_last(G2tensor(254),RedSet_5(60),mass5set(:,27),  & 
G1tensor(719),G1tensor(701),G1tensor(762),G1tensor(702),G1tensor(729),G1tensor(705))
  call G_TensorShift(G1tensor(701),2)
  call Hotf_5pt_reduction_last(G2tensor(256),RedSet_5(60),mass5set(:,26),  & 
G1tensor(756),G1tensor(708),G1tensor(731),G1tensor(713),G1tensor(768),G1tensor(714))
  call G_TensorShift(G1tensor(708),2)
  call Hotf_5pt_reduction_last(G2tensor(258),RedSet_5(60),mass5set(:,31),  & 
G1tensor(735),G1tensor(717),G1tensor(774),G1tensor(720),G1tensor(737),G1tensor(725))
  call G_TensorShift(G1tensor(717),2)
  call Hotf_5pt_reduction_last(G2tensor(260),RedSet_5(60),mass5set(:,30),  & 
G1tensor(786),G1tensor(726),G1tensor(780),G1tensor(732),G1tensor(792),G1tensor(738))
  call G_TensorShift(G1tensor(726),2)
  call Hotf_5pt_reduction_last(G2tensor(395),RedSet_5(60),mass5set(:,29),  & 
G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744),G1tensor(765),G1tensor(747))
  call G_TensorShift(G1tensor(742),2)
  call Hotf_5pt_reduction_last(G2tensor(396),RedSet_5(60),mass5set(:,32),  & 
G1tensor(777),G1tensor(753),G1tensor(783),G1tensor(759),G1tensor(789),G1tensor(771))
  call G_TensorShift(G1tensor(753),2)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(61),mass5set(:,1),  & 
G1tensor(793),G1tensor(794),G1tensor(795),G1tensor(796),G1tensor(797),G1tensor(798))
  call G_TensorShift(G1tensor(794),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(29),mass5set(:,1),  & 
G1tensor(799),G1tensor(800),G1tensor(801),G1tensor(802),G1tensor(803),G1tensor(804))
  call G_TensorShift(G1tensor(800),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(62),mass5set(:,1),  & 
G1tensor(805),G1tensor(806),G1tensor(807),G1tensor(808),G1tensor(809),G1tensor(810))
  call G_TensorShift(G1tensor(806),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(63),mass5set(:,1),  & 
G1tensor(811),G1tensor(812),G1tensor(813),G1tensor(814),G1tensor(815),G1tensor(816))
  call G_TensorShift(G1tensor(812),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(29),mass5set(:,2),  & 
G1tensor(817),G1tensor(818),G1tensor(819),G1tensor(820),G1tensor(821),G1tensor(822))
  call G_TensorShift(G1tensor(818),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(62),mass5set(:,2),  & 
G1tensor(823),G1tensor(824),G1tensor(825),G1tensor(826),G1tensor(827),G1tensor(828))
  call G_TensorShift(G1tensor(824),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(63),mass5set(:,2),  & 
G1tensor(829),G1tensor(830),G1tensor(831),G1tensor(832),G1tensor(833),G1tensor(834))
  call G_TensorShift(G1tensor(830),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(61),mass5set(:,11),  & 
G1tensor(835),G1tensor(836),G1tensor(837),G1tensor(838),G1tensor(839),G1tensor(840))
  call G_TensorShift(G1tensor(836),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(29),mass5set(:,11),  & 
G1tensor(841),G1tensor(842),G1tensor(843),G1tensor(844),G1tensor(845),G1tensor(846))
  call G_TensorShift(G1tensor(842),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(62),mass5set(:,11),  & 
G1tensor(847),G1tensor(848),G1tensor(849),G1tensor(850),G1tensor(851),G1tensor(852))
  call G_TensorShift(G1tensor(848),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(63),mass5set(:,11),  & 
G1tensor(853),G1tensor(854),G1tensor(855),G1tensor(856),G1tensor(857),G1tensor(858))
  call G_TensorShift(G1tensor(854),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(61),mass5set(:,33),  & 
G1tensor(859),G1tensor(860),G1tensor(861),G1tensor(862),G1tensor(863),G1tensor(864))
  call G_TensorShift(G1tensor(860),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(29),mass5set(:,33),  & 
G1tensor(865),G1tensor(866),G1tensor(867),G1tensor(868),G1tensor(869),G1tensor(870))
  call G_TensorShift(G1tensor(866),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(63),mass5set(:,3),  & 
G1tensor(871),G1tensor(872),G1tensor(873),G1tensor(874),G1tensor(875),G1tensor(876))
  call G_TensorShift(G1tensor(872),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(29),mass5set(:,12),  & 
G1tensor(877),G1tensor(878),G1tensor(879),G1tensor(880),G1tensor(881),G1tensor(882))
  call G_TensorShift(G1tensor(878),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(62),mass5set(:,12),  & 
G1tensor(883),G1tensor(884),G1tensor(885),G1tensor(886),G1tensor(887),G1tensor(888))
  call G_TensorShift(G1tensor(884),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(63),mass5set(:,12),  & 
G1tensor(889),G1tensor(890),G1tensor(891),G1tensor(892),G1tensor(893),G1tensor(894))
  call G_TensorShift(G1tensor(890),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(29),mass5set(:,34),  & 
G1tensor(895),G1tensor(896),G1tensor(897),G1tensor(898),G1tensor(899),G1tensor(900))
  call G_TensorShift(G1tensor(896),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(63),mass5set(:,4),  & 
G1tensor(901),G1tensor(902),G1tensor(903),G1tensor(904),G1tensor(905),G1tensor(906))
  call G_TensorShift(G1tensor(902),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(61),mass5set(:,35),  & 
G1tensor(907),G1tensor(908),G1tensor(909),G1tensor(910),G1tensor(911),G1tensor(912))
  call G_TensorShift(G1tensor(908),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(29),mass5set(:,35),  & 
G1tensor(913),G1tensor(914),G1tensor(915),G1tensor(916),G1tensor(917),G1tensor(918))
  call G_TensorShift(G1tensor(914),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(63),mass5set(:,36),  & 
G1tensor(919),G1tensor(920),G1tensor(921),G1tensor(922),G1tensor(923),G1tensor(924))
  call G_TensorShift(G1tensor(920),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(29),mass5set(:,37),  & 
G1tensor(925),G1tensor(926),G1tensor(927),G1tensor(928),G1tensor(929),G1tensor(930))
  call G_TensorShift(G1tensor(926),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(63),mass5set(:,38),  & 
G1tensor(931),G1tensor(932),G1tensor(933),G1tensor(934),G1tensor(935),G1tensor(936))
  call G_TensorShift(G1tensor(932),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(64),mass5set(:,1),  & 
G1tensor(937),G1tensor(938),G1tensor(939),G1tensor(940),G1tensor(941),G1tensor(942))
  call G_TensorShift(G1tensor(938),16)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(33),mass5set(:,1),  & 
G1tensor(943),G1tensor(944),G1tensor(945),G1tensor(946),G1tensor(947),G1tensor(948))
  call G_TensorShift(G1tensor(944),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(65),mass5set(:,1),  & 
G1tensor(949),G1tensor(950),G1tensor(951),G1tensor(952),G1tensor(953),G1tensor(954))
  call G_TensorShift(G1tensor(950),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(66),mass5set(:,1),  & 
G1tensor(955),G1tensor(956),G1tensor(957),G1tensor(958),G1tensor(959),G1tensor(960))
  call G_TensorShift(G1tensor(956),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(64),mass5set(:,11),  & 
G1tensor(961),G1tensor(962),G1tensor(963),G1tensor(964),G1tensor(965),G1tensor(966))
  call G_TensorShift(G1tensor(962),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(33),mass5set(:,11),  & 
G1tensor(967),G1tensor(968),G1tensor(969),G1tensor(970),G1tensor(971),G1tensor(972))
  call G_TensorShift(G1tensor(968),16)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(65),mass5set(:,11),  & 
G1tensor(973),G1tensor(974),G1tensor(975),G1tensor(976),G1tensor(977),G1tensor(978))
  call G_TensorShift(G1tensor(974),16)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(66),mass5set(:,11),  & 
G1tensor(979),G1tensor(980),G1tensor(981),G1tensor(982),G1tensor(983),G1tensor(984))
  call G_TensorShift(G1tensor(980),16)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(33),mass5set(:,2),  & 
G1tensor(985),G1tensor(986),G1tensor(987),G1tensor(988),G1tensor(989),G1tensor(990))
  call G_TensorShift(G1tensor(986),16)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(65),mass5set(:,2),  & 
G1tensor(991),G1tensor(992),G1tensor(993),G1tensor(994),G1tensor(995),G1tensor(996))
  call G_TensorShift(G1tensor(992),16)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(66),mass5set(:,2),  & 
G1tensor(997),G1tensor(998),G1tensor(999),G1tensor(1000),G1tensor(1001),G1tensor(1002))
  call G_TensorShift(G1tensor(998),16)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(64),mass5set(:,33),  & 
G1tensor(1003),G1tensor(1004),G1tensor(1005),G1tensor(1006),G1tensor(1007),G1tensor(1008))
  call G_TensorShift(G1tensor(1004),16)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(33),mass5set(:,33),  & 
G1tensor(1009),G1tensor(1010),G1tensor(1011),G1tensor(1012),G1tensor(1013),G1tensor(1014))
  call G_TensorShift(G1tensor(1010),16)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(66),mass5set(:,3),  & 
G1tensor(1015),G1tensor(1016),G1tensor(1017),G1tensor(1018),G1tensor(1019),G1tensor(1020))
  call G_TensorShift(G1tensor(1016),16)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(33),mass5set(:,12),  & 
G1tensor(1021),G1tensor(1022),G1tensor(1023),G1tensor(1024),G1tensor(1025),G1tensor(1026))
  call G_TensorShift(G1tensor(1022),16)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(65),mass5set(:,12),  & 
G1tensor(1027),G1tensor(1028),G1tensor(1029),G1tensor(1030),G1tensor(1031),G1tensor(1032))
  call G_TensorShift(G1tensor(1028),16)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(66),mass5set(:,12),  & 
G1tensor(1033),G1tensor(1034),G1tensor(1035),G1tensor(1036),G1tensor(1037),G1tensor(1038))
  call G_TensorShift(G1tensor(1034),16)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(64),mass5set(:,35),  & 
G1tensor(1039),G1tensor(1040),G1tensor(1041),G1tensor(1042),G1tensor(1043),G1tensor(1044))
  call G_TensorShift(G1tensor(1040),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(33),mass5set(:,35),  & 
G1tensor(1045),G1tensor(1046),G1tensor(1047),G1tensor(1048),G1tensor(1049),G1tensor(1050))
  call G_TensorShift(G1tensor(1046),16)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(66),mass5set(:,36),  & 
G1tensor(1051),G1tensor(1052),G1tensor(1053),G1tensor(1054),G1tensor(1055),G1tensor(1056))
  call G_TensorShift(G1tensor(1052),16)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(33),mass5set(:,34),  & 
G1tensor(1057),G1tensor(1058),G1tensor(1059),G1tensor(1060),G1tensor(1061),G1tensor(1062))
  call G_TensorShift(G1tensor(1058),16)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(66),mass5set(:,4),  & 
G1tensor(1063),G1tensor(1064),G1tensor(1065),G1tensor(1066),G1tensor(1067),G1tensor(1068))
  call G_TensorShift(G1tensor(1064),16)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(33),mass5set(:,37),  & 
G1tensor(1069),G1tensor(1070),G1tensor(1071),G1tensor(1072),G1tensor(1073),G1tensor(1074))
  call G_TensorShift(G1tensor(1070),16)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(66),mass5set(:,38),  & 
G1tensor(1075),G1tensor(1076),G1tensor(1077),G1tensor(1078),G1tensor(1079),G1tensor(1080))
  call G_TensorShift(G1tensor(1076),16)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(67),mass5set(:,1),  & 
G1tensor(1081),G1tensor(1082),G1tensor(1083),G1tensor(1084),G1tensor(1085),G1tensor(1086))
  call G_TensorShift(G1tensor(1082),16)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(37),mass5set(:,1),  & 
G1tensor(1087),G1tensor(1088),G1tensor(1089),G1tensor(1090),G1tensor(1091),G1tensor(1092))
  call G_TensorShift(G1tensor(1088),16)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(68),mass5set(:,1),  & 
G1tensor(1093),G1tensor(1094),G1tensor(1095),G1tensor(1096),G1tensor(1097),G1tensor(1098))
  call G_TensorShift(G1tensor(1094),16)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(37),mass5set(:,2),  & 
G1tensor(1099),G1tensor(1100),G1tensor(1101),G1tensor(1102),G1tensor(1103),G1tensor(1104))
  call G_TensorShift(G1tensor(1100),16)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(68),mass5set(:,2),  & 
G1tensor(1105),G1tensor(1106),G1tensor(1107),G1tensor(1108),G1tensor(1109),G1tensor(1110))
  call G_TensorShift(G1tensor(1106),16)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(67),mass5set(:,11),  & 
G1tensor(1111),G1tensor(1112),G1tensor(1113),G1tensor(1114),G1tensor(1115),G1tensor(1116))
  call G_TensorShift(G1tensor(1112),16)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(37),mass5set(:,11),  & 
G1tensor(1117),G1tensor(1118),G1tensor(1119),G1tensor(1120),G1tensor(1121),G1tensor(1122))
  call G_TensorShift(G1tensor(1118),16)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(68),mass5set(:,11),  & 
G1tensor(1123),G1tensor(1124),G1tensor(1125),G1tensor(1126),G1tensor(1127),G1tensor(1128))
  call G_TensorShift(G1tensor(1124),16)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(67),mass5set(:,33),  & 
G1tensor(1129),G1tensor(1130),G1tensor(1131),G1tensor(1132),G1tensor(1133),G1tensor(1134))
  call G_TensorShift(G1tensor(1130),16)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(37),mass5set(:,33),  & 
G1tensor(1135),G1tensor(1136),G1tensor(1137),G1tensor(1138),G1tensor(1139),G1tensor(1140))
  call G_TensorShift(G1tensor(1136),16)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(68),mass5set(:,3),  & 
G1tensor(1141),G1tensor(1142),G1tensor(1143),G1tensor(1144),G1tensor(1145),G1tensor(1146))
  call G_TensorShift(G1tensor(1142),16)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(37),mass5set(:,12),  & 
G1tensor(1147),G1tensor(1148),G1tensor(1149),G1tensor(1150),G1tensor(1151),G1tensor(1152))
  call G_TensorShift(G1tensor(1148),16)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(68),mass5set(:,12),  & 
G1tensor(1153),G1tensor(1154),G1tensor(1155),G1tensor(1156),G1tensor(1157),G1tensor(1158))
  call G_TensorShift(G1tensor(1154),16)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(37),mass5set(:,34),  & 
G1tensor(1159),G1tensor(1160),G1tensor(1161),G1tensor(1162),G1tensor(1163),G1tensor(1164))
  call G_TensorShift(G1tensor(1160),16)
  call Hotf_5pt_reduction_last(G2tensor(125),RedSet_5(68),mass5set(:,4),  & 
G1tensor(1165),G1tensor(1166),G1tensor(1167),G1tensor(1168),G1tensor(1169),G1tensor(1170))
  call G_TensorShift(G1tensor(1166),16)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(67),mass5set(:,35),  & 
G1tensor(1171),G1tensor(1172),G1tensor(1173),G1tensor(1174),G1tensor(1175),G1tensor(1176))
  call G_TensorShift(G1tensor(1172),16)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(37),mass5set(:,35),  & 
G1tensor(1177),G1tensor(1178),G1tensor(1179),G1tensor(1180),G1tensor(1181),G1tensor(1182))
  call G_TensorShift(G1tensor(1178),16)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(68),mass5set(:,36),  & 
G1tensor(1183),G1tensor(1184),G1tensor(1185),G1tensor(1186),G1tensor(1187),G1tensor(1188))
  call G_TensorShift(G1tensor(1184),16)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(37),mass5set(:,37),  & 
G1tensor(1189),G1tensor(1190),G1tensor(1191),G1tensor(1192),G1tensor(1193),G1tensor(1194))
  call G_TensorShift(G1tensor(1190),16)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(68),mass5set(:,38),  & 
G1tensor(1195),G1tensor(1196),G1tensor(1197),G1tensor(1198),G1tensor(1199),G1tensor(1200))
  call G_TensorShift(G1tensor(1196),16)
  call Hotf_5pt_reduction_last(G2tensor(137),RedSet_5(69),mass5set(:,1),  & 
G1tensor(1201),G1tensor(1202),G1tensor(1203),G1tensor(1204),G1tensor(1205),G1tensor(1206))
  call G_TensorShift(G1tensor(1202),16)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(25),mass5set(:,1),  & 
G1tensor(1207),G1tensor(1208),G1tensor(1209),G1tensor(1210),G1tensor(1211),G1tensor(1212))
  call G_TensorShift(G1tensor(1208),16)
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(70),mass5set(:,1),  & 
G1tensor(1213),G1tensor(1214),G1tensor(1215),G1tensor(1216),G1tensor(1217),G1tensor(1218))
  call G_TensorShift(G1tensor(1214),16)
  call Hotf_5pt_reduction_last(G2tensor(143),RedSet_5(69),mass5set(:,11),  & 
G1tensor(1219),G1tensor(1220),G1tensor(1221),G1tensor(1222),G1tensor(1223),G1tensor(1224))
  call G_TensorShift(G1tensor(1220),16)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(25),mass5set(:,11),  & 
G1tensor(1225),G1tensor(1226),G1tensor(1227),G1tensor(1228),G1tensor(1229),G1tensor(1230))
  call G_TensorShift(G1tensor(1226),16)
  call Hotf_5pt_reduction_last(G2tensor(147),RedSet_5(70),mass5set(:,11),  & 
G1tensor(1231),G1tensor(1232),G1tensor(1233),G1tensor(1234),G1tensor(1235),G1tensor(1236))
  call G_TensorShift(G1tensor(1232),16)
  call Hotf_5pt_reduction_last(G2tensor(149),RedSet_5(25),mass5set(:,2),  & 
G1tensor(1237),G1tensor(1238),G1tensor(1239),G1tensor(1240),G1tensor(1241),G1tensor(1242))
  call G_TensorShift(G1tensor(1238),16)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(70),mass5set(:,2),  & 
G1tensor(1243),G1tensor(1244),G1tensor(1245),G1tensor(1246),G1tensor(1247),G1tensor(1248))
  call G_TensorShift(G1tensor(1244),16)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(69),mass5set(:,33),  & 
G1tensor(1249),G1tensor(1250),G1tensor(1251),G1tensor(1252),G1tensor(1253),G1tensor(1254))
  call G_TensorShift(G1tensor(1250),16)
  call Hotf_5pt_reduction_last(G2tensor(155),RedSet_5(25),mass5set(:,33),  & 
G1tensor(1255),G1tensor(1256),G1tensor(1257),G1tensor(1258),G1tensor(1259),G1tensor(1260))
  call G_TensorShift(G1tensor(1256),16)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(70),mass5set(:,3),  & 
G1tensor(1261),G1tensor(1262),G1tensor(1263),G1tensor(1264),G1tensor(1265),G1tensor(1266))
  call G_TensorShift(G1tensor(1262),16)
  call Hotf_5pt_reduction_last(G2tensor(159),RedSet_5(25),mass5set(:,12),  & 
G1tensor(1267),G1tensor(1268),G1tensor(1269),G1tensor(1270),G1tensor(1271),G1tensor(1272))
  call G_TensorShift(G1tensor(1268),16)
  call Hotf_5pt_reduction_last(G2tensor(161),RedSet_5(70),mass5set(:,12),  & 
G1tensor(1273),G1tensor(1274),G1tensor(1275),G1tensor(1276),G1tensor(1277),G1tensor(1278))
  call G_TensorShift(G1tensor(1274),16)
  call Hotf_5pt_reduction_last(G2tensor(163),RedSet_5(69),mass5set(:,35),  & 
G1tensor(1279),G1tensor(1280),G1tensor(1281),G1tensor(1282),G1tensor(1283),G1tensor(1284))
  call G_TensorShift(G1tensor(1280),16)
  call Hotf_5pt_reduction_last(G2tensor(165),RedSet_5(25),mass5set(:,35),  & 
G1tensor(1285),G1tensor(1286),G1tensor(1287),G1tensor(1288),G1tensor(1289),G1tensor(1290))
  call G_TensorShift(G1tensor(1286),16)
  call Hotf_5pt_reduction_last(G2tensor(167),RedSet_5(70),mass5set(:,36),  & 
G1tensor(1291),G1tensor(1292),G1tensor(1293),G1tensor(1294),G1tensor(1295),G1tensor(1296))
  call G_TensorShift(G1tensor(1292),16)
  call Hotf_5pt_reduction_last(G2tensor(169),RedSet_5(25),mass5set(:,34),  & 
G1tensor(1297),G1tensor(1298),G1tensor(1299),G1tensor(1300),G1tensor(1301),G1tensor(1302))
  call G_TensorShift(G1tensor(1298),16)
  call Hotf_5pt_reduction_last(G2tensor(171),RedSet_5(70),mass5set(:,4),  & 
G1tensor(1303),G1tensor(1304),G1tensor(1305),G1tensor(1306),G1tensor(1307),G1tensor(1308))
  call G_TensorShift(G1tensor(1304),16)
  call Hotf_5pt_reduction_last(G2tensor(173),RedSet_5(25),mass5set(:,37),  & 
G1tensor(1309),G1tensor(1310),G1tensor(1311),G1tensor(1312),G1tensor(1313),G1tensor(1314))
  call G_TensorShift(G1tensor(1310),16)
  call Hotf_5pt_reduction_last(G2tensor(175),RedSet_5(70),mass5set(:,38),  & 
G1tensor(1315),G1tensor(1316),G1tensor(1317),G1tensor(1318),G1tensor(1319),G1tensor(1320))
  call G_TensorShift(G1tensor(1316),16)
  call Hotf_5pt_reduction_last(G2tensor(177),RedSet_5(71),mass5set(:,1),  & 
G1tensor(1321),G1tensor(1322),G1tensor(1323),G1tensor(1324),G1tensor(1325),G1tensor(1326))
  call G_TensorShift(G1tensor(1322),16)
  call Hotf_5pt_reduction_last(G2tensor(179),RedSet_5(72),mass5set(:,1),  & 
G1tensor(1327),G1tensor(1328),G1tensor(1329),G1tensor(1330),G1tensor(1331),G1tensor(1332))
  call G_TensorShift(G1tensor(1328),16)
  call Hotf_5pt_reduction_last(G2tensor(421),RedSet_5(23),mass5set(:,1),  & 
G1tensor(1333),G1tensor(1334),G1tensor(1335),G1tensor(1336),G1tensor(1337),G1tensor(1338))
  call G_TensorShift(G1tensor(1334),16)
  call Hotf_5pt_reduction_last(G2tensor(181),RedSet_5(72),mass5set(:,2),  & 
G1tensor(1339),G1tensor(1340),G1tensor(1341),G1tensor(1342),G1tensor(1343),G1tensor(1344))
  call G_TensorShift(G1tensor(1340),16)
  call Hotf_5pt_reduction_last(G2tensor(424),RedSet_5(23),mass5set(:,2),  & 
G1tensor(1345),G1tensor(1346),G1tensor(1347),G1tensor(1348),G1tensor(1349),G1tensor(1350))
  call G_TensorShift(G1tensor(1346),16)
  call Hotf_5pt_reduction_last(G2tensor(183),RedSet_5(71),mass5set(:,11),  & 
G1tensor(1351),G1tensor(1352),G1tensor(1353),G1tensor(1354),G1tensor(1355),G1tensor(1356))
  call G_TensorShift(G1tensor(1352),16)
  call Hotf_5pt_reduction_last(G2tensor(185),RedSet_5(72),mass5set(:,11),  & 
G1tensor(1357),G1tensor(1358),G1tensor(1359),G1tensor(1360),G1tensor(1361),G1tensor(1362))
  call G_TensorShift(G1tensor(1358),16)
  call Hotf_5pt_reduction_last(G2tensor(427),RedSet_5(23),mass5set(:,11),  & 
G1tensor(1363),G1tensor(1364),G1tensor(1365),G1tensor(1366),G1tensor(1367),G1tensor(1368))
  call G_TensorShift(G1tensor(1364),16)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(71),mass5set(:,33),  & 
G1tensor(1369),G1tensor(1370),G1tensor(1371),G1tensor(1372),G1tensor(1373),G1tensor(1374))
  call G_TensorShift(G1tensor(1370),16)
  call Hotf_5pt_reduction_last(G2tensor(189),RedSet_5(72),mass5set(:,33),  & 
G1tensor(1375),G1tensor(1376),G1tensor(1377),G1tensor(1378),G1tensor(1379),G1tensor(1380))
  call G_TensorShift(G1tensor(1376),16)
  call Hotf_5pt_reduction_last(G2tensor(191),RedSet_5(72),mass5set(:,12),  & 
G1tensor(1381),G1tensor(1382),G1tensor(1383),G1tensor(1384),G1tensor(1385),G1tensor(1386))
  call G_TensorShift(G1tensor(1382),16)
  call Hotf_5pt_reduction_last(G2tensor(430),RedSet_5(23),mass5set(:,12),  & 
G1tensor(1387),G1tensor(1388),G1tensor(1389),G1tensor(1390),G1tensor(1391),G1tensor(1392))
  call G_TensorShift(G1tensor(1388),16)
  call Hotf_5pt_reduction_last(G2tensor(193),RedSet_5(72),mass5set(:,34),  & 
G1tensor(1393),G1tensor(1394),G1tensor(1395),G1tensor(1396),G1tensor(1397),G1tensor(1398))
  call G_TensorShift(G1tensor(1394),16)
  call Hotf_5pt_reduction_last(G2tensor(195),RedSet_5(71),mass5set(:,35),  & 
G1tensor(1399),G1tensor(1400),G1tensor(1401),G1tensor(1402),G1tensor(1403),G1tensor(1404))
  call G_TensorShift(G1tensor(1400),16)
  call Hotf_5pt_reduction_last(G2tensor(197),RedSet_5(72),mass5set(:,35),  & 
G1tensor(1405),G1tensor(1406),G1tensor(1407),G1tensor(1408),G1tensor(1409),G1tensor(1410))
  call G_TensorShift(G1tensor(1406),16)
  call Hotf_5pt_reduction_last(G2tensor(199),RedSet_5(72),mass5set(:,37),  & 
G1tensor(1411),G1tensor(1412),G1tensor(1413),G1tensor(1414),G1tensor(1415),G1tensor(1416))
  call G_TensorShift(G1tensor(1412),16)
  call Hotf_5pt_reduction_last(G2tensor(201),RedSet_5(73),mass5set(:,1),  & 
G1tensor(1417),G1tensor(1418),G1tensor(1419),G1tensor(1420),G1tensor(1421),G1tensor(1422))
  call G_TensorShift(G1tensor(1418),16)
  call Hotf_5pt_reduction_last(G2tensor(433),RedSet_5(24),mass5set(:,1),  & 
G1tensor(1423),G1tensor(1424),G1tensor(1425),G1tensor(1426),G1tensor(1427),G1tensor(1428))
  call G_TensorShift(G1tensor(1424),16)
  call Hotf_5pt_reduction_last(G2tensor(203),RedSet_5(26),mass5set(:,1),  & 
G1tensor(1429),G1tensor(1430),G1tensor(1431),G1tensor(1432),G1tensor(1433),G1tensor(1434))
  call G_TensorShift(G1tensor(1430),16)
  call Hotf_5pt_reduction_last(G2tensor(205),RedSet_5(73),mass5set(:,11),  & 
G1tensor(1435),G1tensor(1436),G1tensor(1437),G1tensor(1438),G1tensor(1439),G1tensor(1440))
  call G_TensorShift(G1tensor(1436),16)
  call Hotf_5pt_reduction_last(G2tensor(436),RedSet_5(24),mass5set(:,11),  & 
G1tensor(1441),G1tensor(1442),G1tensor(1443),G1tensor(1444),G1tensor(1445),G1tensor(1446))
  call G_TensorShift(G1tensor(1442),16)
  call Hotf_5pt_reduction_last(G2tensor(207),RedSet_5(26),mass5set(:,11),  & 
G1tensor(1447),G1tensor(1448),G1tensor(1449),G1tensor(1450),G1tensor(1451),G1tensor(1452))
  call G_TensorShift(G1tensor(1448),16)
  call Hotf_5pt_reduction_last(G2tensor(439),RedSet_5(24),mass5set(:,2),  & 
G1tensor(1453),G1tensor(1454),G1tensor(1455),G1tensor(1456),G1tensor(1457),G1tensor(1458))
  call G_TensorShift(G1tensor(1454),16)
  call Hotf_5pt_reduction_last(G2tensor(209),RedSet_5(26),mass5set(:,2),  & 
G1tensor(1459),G1tensor(1460),G1tensor(1461),G1tensor(1462),G1tensor(1463),G1tensor(1464))
  call G_TensorShift(G1tensor(1460),16)
  call Hotf_5pt_reduction_last(G2tensor(211),RedSet_5(73),mass5set(:,33),  & 
G1tensor(1465),G1tensor(1466),G1tensor(1467),G1tensor(1468),G1tensor(1469),G1tensor(1470))
  call G_TensorShift(G1tensor(1466),16)
  call Hotf_5pt_reduction_last(G2tensor(213),RedSet_5(26),mass5set(:,3),  & 
G1tensor(1471),G1tensor(1472),G1tensor(1473),G1tensor(1474),G1tensor(1475),G1tensor(1476))
  call G_TensorShift(G1tensor(1472),16)
  call Hotf_5pt_reduction_last(G2tensor(442),RedSet_5(24),mass5set(:,12),  & 
G1tensor(1477),G1tensor(1478),G1tensor(1479),G1tensor(1480),G1tensor(1481),G1tensor(1482))
  call G_TensorShift(G1tensor(1478),16)
  call Hotf_5pt_reduction_last(G2tensor(215),RedSet_5(26),mass5set(:,12),  & 
G1tensor(1483),G1tensor(1484),G1tensor(1485),G1tensor(1486),G1tensor(1487),G1tensor(1488))
  call G_TensorShift(G1tensor(1484),16)
  call Hotf_5pt_reduction_last(G2tensor(217),RedSet_5(73),mass5set(:,35),  & 
G1tensor(1489),G1tensor(1490),G1tensor(1491),G1tensor(1492),G1tensor(1493),G1tensor(1494))
  call G_TensorShift(G1tensor(1490),16)
  call Hotf_5pt_reduction_last(G2tensor(219),RedSet_5(26),mass5set(:,36),  & 
G1tensor(1495),G1tensor(1496),G1tensor(1497),G1tensor(1498),G1tensor(1499),G1tensor(1500))
  call G_TensorShift(G1tensor(1496),16)
  call Hotf_5pt_reduction_last(G2tensor(221),RedSet_5(26),mass5set(:,4),  & 
G1tensor(1501),G1tensor(1502),G1tensor(1503),G1tensor(1504),G1tensor(1505),G1tensor(1506))
  call G_TensorShift(G1tensor(1502),16)
  call Hotf_5pt_reduction_last(G2tensor(223),RedSet_5(26),mass5set(:,38),  & 
G1tensor(1507),G1tensor(1508),G1tensor(1509),G1tensor(1510),G1tensor(1511),G1tensor(1512))
  call G_TensorShift(G1tensor(1508),16)
  call Hotf_5pt_reduction_last(G2tensor(225),RedSet_5(73),mass5set(:,39),  & 
G1tensor(1513),G1tensor(1514),G1tensor(1515),G1tensor(1516),G1tensor(1517),G1tensor(1518))
  call G_TensorShift(G1tensor(1514),16)
  call Hotf_5pt_reduction_last(G2tensor(445),RedSet_5(25),mass5set(:,13),  & 
G1tensor(1519),G1tensor(1520),G1tensor(1521),G1tensor(1522),G1tensor(1523),G1tensor(1524))
  call G_TensorShift(G1tensor(1520),16)
  call Hotf_5pt_reduction_last(G2tensor(448),RedSet_5(24),mass5set(:,14),  & 
G1tensor(1525),G1tensor(1526),G1tensor(1527),G1tensor(1528),G1tensor(1529),G1tensor(1530))
  call G_TensorShift(G1tensor(1526),16)
  call Hotf_5pt_reduction_last(G2tensor(451),RedSet_5(26),mass5set(:,15),  & 
G1tensor(1531),G1tensor(1532),G1tensor(1533),G1tensor(1534),G1tensor(1535),G1tensor(1536))
  call G_TensorShift(G1tensor(1532),16)
  call Hotf_5pt_reduction_last(G2tensor(227),RedSet_5(74),mass5set(:,1),  & 
G1tensor(1537),G1tensor(1538),G1tensor(1539),G1tensor(1540),G1tensor(1541),G1tensor(1542))
  call G_TensorShift(G1tensor(1538),16)
  call Hotf_5pt_reduction_last(G2tensor(229),RedSet_5(75),mass5set(:,1),  & 
G1tensor(1543),G1tensor(1544),G1tensor(1545),G1tensor(1546),G1tensor(1547),G1tensor(1548))
  call G_TensorShift(G1tensor(1544),16)
  call Hotf_5pt_reduction_last(G2tensor(454),RedSet_5(27),mass5set(:,1),  & 
G1tensor(1549),G1tensor(1550),G1tensor(1551),G1tensor(1552),G1tensor(1553),G1tensor(1554))
  call G_TensorShift(G1tensor(1550),16)
  call Hotf_5pt_reduction_last(G2tensor(231),RedSet_5(75),mass5set(:,2),  & 
G1tensor(1555),G1tensor(1556),G1tensor(1557),G1tensor(1558),G1tensor(1559),G1tensor(1560))
  call G_TensorShift(G1tensor(1556),16)
  call Hotf_5pt_reduction_last(G2tensor(457),RedSet_5(27),mass5set(:,2),  & 
G1tensor(1561),G1tensor(1562),G1tensor(1563),G1tensor(1564),G1tensor(1565),G1tensor(1566))
  call G_TensorShift(G1tensor(1562),16)
  call Hotf_5pt_reduction_last(G2tensor(233),RedSet_5(74),mass5set(:,11),  & 
G1tensor(1567),G1tensor(1568),G1tensor(1569),G1tensor(1570),G1tensor(1571),G1tensor(1572))
  call G_TensorShift(G1tensor(1568),16)
  call Hotf_5pt_reduction_last(G2tensor(235),RedSet_5(75),mass5set(:,11),  & 
G1tensor(1573),G1tensor(1574),G1tensor(1575),G1tensor(1576),G1tensor(1577),G1tensor(1578))
  call G_TensorShift(G1tensor(1574),16)
  call Hotf_5pt_reduction_last(G2tensor(460),RedSet_5(27),mass5set(:,11),  & 
G1tensor(1579),G1tensor(1580),G1tensor(1581),G1tensor(1582),G1tensor(1583),G1tensor(1584))
  call G_TensorShift(G1tensor(1580),16)
  call Hotf_5pt_reduction_last(G2tensor(237),RedSet_5(74),mass5set(:,33),  & 
G1tensor(1585),G1tensor(1586),G1tensor(1587),G1tensor(1588),G1tensor(1589),G1tensor(1590))
  call G_TensorShift(G1tensor(1586),16)
  call Hotf_5pt_reduction_last(G2tensor(239),RedSet_5(75),mass5set(:,33),  & 
G1tensor(1591),G1tensor(1592),G1tensor(1593),G1tensor(1594),G1tensor(1595),G1tensor(1596))
  call G_TensorShift(G1tensor(1592),16)
  call Hotf_5pt_reduction_last(G2tensor(241),RedSet_5(75),mass5set(:,12),  & 
G1tensor(1597),G1tensor(1598),G1tensor(1599),G1tensor(1600),G1tensor(1601),G1tensor(1602))
  call G_TensorShift(G1tensor(1598),16)
  call Hotf_5pt_reduction_last(G2tensor(463),RedSet_5(27),mass5set(:,12),  & 
G1tensor(1603),G1tensor(1604),G1tensor(1605),G1tensor(1606),G1tensor(1607),G1tensor(1608))
  call G_TensorShift(G1tensor(1604),16)
  call Hotf_5pt_reduction_last(G2tensor(243),RedSet_5(75),mass5set(:,34),  & 
G1tensor(1609),G1tensor(1610),G1tensor(1611),G1tensor(1612),G1tensor(1613),G1tensor(1614))
  call G_TensorShift(G1tensor(1610),16)
  call Hotf_5pt_reduction_last(G2tensor(245),RedSet_5(74),mass5set(:,35),  & 
G1tensor(1615),G1tensor(1616),G1tensor(1617),G1tensor(1618),G1tensor(1619),G1tensor(1620))
  call G_TensorShift(G1tensor(1616),16)
  call Hotf_5pt_reduction_last(G2tensor(247),RedSet_5(75),mass5set(:,35),  & 
G1tensor(1621),G1tensor(1622),G1tensor(1623),G1tensor(1624),G1tensor(1625),G1tensor(1626))
  call G_TensorShift(G1tensor(1622),16)
  call Hotf_5pt_reduction_last(G2tensor(249),RedSet_5(75),mass5set(:,37),  & 
G1tensor(1627),G1tensor(1628),G1tensor(1629),G1tensor(1630),G1tensor(1631),G1tensor(1632))
  call G_TensorShift(G1tensor(1628),16)
  call Hotf_5pt_reduction_last(G2tensor(251),RedSet_5(76),mass5set(:,1),  & 
G1tensor(1633),G1tensor(1634),G1tensor(1635),G1tensor(1636),G1tensor(1637),G1tensor(1638))
  call G_TensorShift(G1tensor(1634),16)
  call Hotf_5pt_reduction_last(G2tensor(466),RedSet_5(28),mass5set(:,1),  & 
G1tensor(1639),G1tensor(1640),G1tensor(1641),G1tensor(1642),G1tensor(1643),G1tensor(1644))
  call G_TensorShift(G1tensor(1640),16)
  call Hotf_5pt_reduction_last(G2tensor(253),RedSet_5(30),mass5set(:,1),  & 
G1tensor(1645),G1tensor(1646),G1tensor(1647),G1tensor(1648),G1tensor(1649),G1tensor(1650))
  call G_TensorShift(G1tensor(1646),16)
  call Hotf_5pt_reduction_last(G2tensor(255),RedSet_5(76),mass5set(:,11),  & 
G1tensor(1651),G1tensor(1652),G1tensor(1653),G1tensor(1654),G1tensor(1655),G1tensor(1656))
  call G_TensorShift(G1tensor(1652),16)
  call Hotf_5pt_reduction_last(G2tensor(469),RedSet_5(28),mass5set(:,11),  & 
G1tensor(1657),G1tensor(1658),G1tensor(1659),G1tensor(1660),G1tensor(1661),G1tensor(1662))
  call G_TensorShift(G1tensor(1658),16)
  call Hotf_5pt_reduction_last(G2tensor(257),RedSet_5(30),mass5set(:,11),  & 
G1tensor(1663),G1tensor(1664),G1tensor(1665),G1tensor(1666),G1tensor(1667),G1tensor(1668))
  call G_TensorShift(G1tensor(1664),16)
  call Hotf_5pt_reduction_last(G2tensor(472),RedSet_5(28),mass5set(:,2),  & 
G1tensor(1669),G1tensor(1670),G1tensor(1671),G1tensor(1672),G1tensor(1673),G1tensor(1674))
  call G_TensorShift(G1tensor(1670),16)
  call Hotf_5pt_reduction_last(G2tensor(259),RedSet_5(30),mass5set(:,2),  & 
G1tensor(1675),G1tensor(1676),G1tensor(1677),G1tensor(1678),G1tensor(1679),G1tensor(1680))
  call G_TensorShift(G1tensor(1676),16)
  call Hotf_5pt_reduction_last(G2tensor(261),RedSet_5(76),mass5set(:,33),  & 
G1tensor(1681),G1tensor(1682),G1tensor(1683),G1tensor(1684),G1tensor(1685),G1tensor(1686))
  call G_TensorShift(G1tensor(1682),16)
  call Hotf_5pt_reduction_last(G2tensor(263),RedSet_5(30),mass5set(:,3),  & 
G1tensor(1687),G1tensor(1688),G1tensor(1689),G1tensor(1690),G1tensor(1691),G1tensor(1692))
  call G_TensorShift(G1tensor(1688),16)
  call Hotf_5pt_reduction_last(G2tensor(475),RedSet_5(28),mass5set(:,12),  & 
G1tensor(1693),G1tensor(1694),G1tensor(1695),G1tensor(1696),G1tensor(1697),G1tensor(1698))
  call G_TensorShift(G1tensor(1694),16)
  call Hotf_5pt_reduction_last(G2tensor(265),RedSet_5(30),mass5set(:,12),  & 
G1tensor(1699),G1tensor(1700),G1tensor(1701),G1tensor(1702),G1tensor(1703),G1tensor(1704))
  call G_TensorShift(G1tensor(1700),16)
  call Hotf_5pt_reduction_last(G2tensor(266),RedSet_5(76),mass5set(:,35),  & 
G1tensor(1705),G1tensor(1706),G1tensor(1707),G1tensor(1708),G1tensor(1709),G1tensor(1710))
  call G_TensorShift(G1tensor(1706),16)
  call Hotf_5pt_reduction_last(G2tensor(267),RedSet_5(30),mass5set(:,36),  & 
G1tensor(1711),G1tensor(1712),G1tensor(1713),G1tensor(1714),G1tensor(1715),G1tensor(1716))
  call G_TensorShift(G1tensor(1712),16)
  call Hotf_5pt_reduction_last(G2tensor(268),RedSet_5(30),mass5set(:,4),  & 
G1tensor(1717),G1tensor(1718),G1tensor(1719),G1tensor(1720),G1tensor(1721),G1tensor(1722))
  call G_TensorShift(G1tensor(1718),16)
  call Hotf_5pt_reduction_last(G2tensor(269),RedSet_5(30),mass5set(:,38),  & 
G1tensor(1723),G1tensor(1724),G1tensor(1725),G1tensor(1726),G1tensor(1727),G1tensor(1728))
  call G_TensorShift(G1tensor(1724),16)
  call Hotf_5pt_reduction_last(G2tensor(270),RedSet_5(76),mass5set(:,39),  & 
G1tensor(1729),G1tensor(1730),G1tensor(1731),G1tensor(1732),G1tensor(1733),G1tensor(1734))
  call G_TensorShift(G1tensor(1730),16)
  call Hotf_5pt_reduction_last(G2tensor(478),RedSet_5(29),mass5set(:,13),  & 
G1tensor(1735),G1tensor(1736),G1tensor(1737),G1tensor(1738),G1tensor(1739),G1tensor(1740))
  call G_TensorShift(G1tensor(1736),16)
  call Hotf_5pt_reduction_last(G2tensor(481),RedSet_5(28),mass5set(:,14),  & 
G1tensor(1741),G1tensor(1742),G1tensor(1743),G1tensor(1744),G1tensor(1745),G1tensor(1746))
  call G_TensorShift(G1tensor(1742),16)
  call Hotf_5pt_reduction_last(G2tensor(484),RedSet_5(30),mass5set(:,15),  & 
G1tensor(1747),G1tensor(1748),G1tensor(1749),G1tensor(1750),G1tensor(1751),G1tensor(1752))
  call G_TensorShift(G1tensor(1748),16)
  call Hotf_5pt_reduction_last(G2tensor(271),RedSet_5(77),mass5set(:,1),  & 
G1tensor(1753),G1tensor(1754),G1tensor(1755),G1tensor(1756),G1tensor(1757),G1tensor(1758))
  call G_TensorShift(G1tensor(1754),16)
  call Hotf_5pt_reduction_last(G2tensor(272),RedSet_5(78),mass5set(:,1),  & 
G1tensor(1759),G1tensor(1760),G1tensor(1761),G1tensor(1762),G1tensor(1763),G1tensor(1764))
  call G_TensorShift(G1tensor(1760),16)
  call Hotf_5pt_reduction_last(G2tensor(487),RedSet_5(31),mass5set(:,1),  & 
G1tensor(1765),G1tensor(1766),G1tensor(1767),G1tensor(1768),G1tensor(1769),G1tensor(1770))
  call G_TensorShift(G1tensor(1766),16)
  call Hotf_5pt_reduction_last(G2tensor(273),RedSet_5(78),mass5set(:,2),  & 
G1tensor(1771),G1tensor(1772),G1tensor(1773),G1tensor(1774),G1tensor(1775),G1tensor(1776))
  call G_TensorShift(G1tensor(1772),16)
  call Hotf_5pt_reduction_last(G2tensor(490),RedSet_5(31),mass5set(:,2),  & 
G1tensor(1777),G1tensor(1778),G1tensor(1779),G1tensor(1780),G1tensor(1781),G1tensor(1782))
  call G_TensorShift(G1tensor(1778),16)
  call Hotf_5pt_reduction_last(G2tensor(274),RedSet_5(77),mass5set(:,33),  & 
G1tensor(1783),G1tensor(1784),G1tensor(1785),G1tensor(1786),G1tensor(1787),G1tensor(1788))
  call G_TensorShift(G1tensor(1784),16)
  call Hotf_5pt_reduction_last(G2tensor(275),RedSet_5(78),mass5set(:,33),  & 
G1tensor(1789),G1tensor(1790),G1tensor(1791),G1tensor(1792),G1tensor(1793),G1tensor(1794))
  call G_TensorShift(G1tensor(1790),16)
  call Hotf_5pt_reduction_last(G2tensor(276),RedSet_5(77),mass5set(:,11),  & 
G1tensor(1795),G1tensor(1796),G1tensor(1797),G1tensor(1798),G1tensor(1799),G1tensor(1800))
  call G_TensorShift(G1tensor(1796),16)
  call Hotf_5pt_reduction_last(G2tensor(277),RedSet_5(78),mass5set(:,11),  & 
G1tensor(1801),G1tensor(1802),G1tensor(1803),G1tensor(1804),G1tensor(1805),G1tensor(1806))
  call G_TensorShift(G1tensor(1802),16)
  call Hotf_5pt_reduction_last(G2tensor(493),RedSet_5(31),mass5set(:,11),  & 
G1tensor(1807),G1tensor(1808),G1tensor(1809),G1tensor(1810),G1tensor(1811),G1tensor(1812))
  call G_TensorShift(G1tensor(1808),16)
  call Hotf_5pt_reduction_last(G2tensor(278),RedSet_5(78),mass5set(:,34),  & 
G1tensor(1813),G1tensor(1814),G1tensor(1815),G1tensor(1816),G1tensor(1817),G1tensor(1818))
  call G_TensorShift(G1tensor(1814),16)
  call Hotf_5pt_reduction_last(G2tensor(279),RedSet_5(78),mass5set(:,12),  & 
G1tensor(1819),G1tensor(1820),G1tensor(1821),G1tensor(1822),G1tensor(1823),G1tensor(1824))
  call G_TensorShift(G1tensor(1820),16)
  call Hotf_5pt_reduction_last(G2tensor(496),RedSet_5(31),mass5set(:,12),  & 
G1tensor(1825),G1tensor(1826),G1tensor(1827),G1tensor(1828),G1tensor(1829),G1tensor(1830))
  call G_TensorShift(G1tensor(1826),16)
  call Hotf_5pt_reduction_last(G2tensor(280),RedSet_5(77),mass5set(:,35),  & 
G1tensor(1831),G1tensor(1832),G1tensor(1833),G1tensor(1834),G1tensor(1835),G1tensor(1836))
  call G_TensorShift(G1tensor(1832),16)
  call Hotf_5pt_reduction_last(G2tensor(281),RedSet_5(78),mass5set(:,35),  & 
G1tensor(1837),G1tensor(1838),G1tensor(1839),G1tensor(1840),G1tensor(1841),G1tensor(1842))
  call G_TensorShift(G1tensor(1838),16)
  call Hotf_5pt_reduction_last(G2tensor(282),RedSet_5(78),mass5set(:,37),  & 
G1tensor(1843),G1tensor(1844),G1tensor(1845),G1tensor(1846),G1tensor(1847),G1tensor(1848))
  call G_TensorShift(G1tensor(1844),16)
  call Hotf_5pt_reduction_last(G2tensor(283),RedSet_5(79),mass5set(:,1),  & 
G1tensor(1849),G1tensor(1850),G1tensor(1851),G1tensor(1852),G1tensor(1853),G1tensor(1854))
  call G_TensorShift(G1tensor(1850),16)
  call Hotf_5pt_reduction_last(G2tensor(284),RedSet_5(80),mass5set(:,1),  & 
G1tensor(1855),G1tensor(1856),G1tensor(1857),G1tensor(1858),G1tensor(1859),G1tensor(1860))
  call G_TensorShift(G1tensor(1856),16)
  call Hotf_5pt_reduction_last(G2tensor(285),RedSet_5(79),mass5set(:,33),  & 
G1tensor(1861),G1tensor(1862),G1tensor(1863),G1tensor(1864),G1tensor(1865),G1tensor(1866))
  call G_TensorShift(G1tensor(1862),16)
  call Hotf_5pt_reduction_last(G2tensor(286),RedSet_5(80),mass5set(:,2),  & 
G1tensor(1867),G1tensor(1868),G1tensor(1869),G1tensor(1870),G1tensor(1871),G1tensor(1872))
  call G_TensorShift(G1tensor(1868),16)
  call Hotf_5pt_reduction_last(G2tensor(287),RedSet_5(79),mass5set(:,11),  & 
G1tensor(1873),G1tensor(1874),G1tensor(1875),G1tensor(1876),G1tensor(1877),G1tensor(1878))
  call G_TensorShift(G1tensor(1874),16)
  call Hotf_5pt_reduction_last(G2tensor(288),RedSet_5(80),mass5set(:,11),  & 
G1tensor(1879),G1tensor(1880),G1tensor(1881),G1tensor(1882),G1tensor(1883),G1tensor(1884))
  call G_TensorShift(G1tensor(1880),16)
  call Hotf_5pt_reduction_last(G2tensor(289),RedSet_5(79),mass5set(:,35),  & 
G1tensor(1885),G1tensor(1886),G1tensor(1887),G1tensor(1888),G1tensor(1889),G1tensor(1890))
  call G_TensorShift(G1tensor(1886),16)
  call Hotf_5pt_reduction_last(G2tensor(290),RedSet_5(80),mass5set(:,12),  & 
G1tensor(1891),G1tensor(1892),G1tensor(1893),G1tensor(1894),G1tensor(1895),G1tensor(1896))
  call G_TensorShift(G1tensor(1892),16)
  call Hotf_5pt_reduction_last(G2tensor(291),RedSet_5(81),mass5set(:,1),  & 
G1tensor(1897),G1tensor(1898),G1tensor(1899),G1tensor(1900),G1tensor(1901),G1tensor(1902))
  call G_TensorShift(G1tensor(1898),16)
  call Hotf_5pt_reduction_last(G2tensor(499),RedSet_5(32),mass5set(:,1),  & 
G1tensor(1903),G1tensor(1904),G1tensor(1905),G1tensor(1906),G1tensor(1907),G1tensor(1908))
  call G_TensorShift(G1tensor(1904),16)
  call Hotf_5pt_reduction_last(G2tensor(292),RedSet_5(34),mass5set(:,1),  & 
G1tensor(1909),G1tensor(1910),G1tensor(1911),G1tensor(1912),G1tensor(1913),G1tensor(1914))
  call G_TensorShift(G1tensor(1910),16)
  call Hotf_5pt_reduction_last(G2tensor(293),RedSet_5(81),mass5set(:,11),  & 
G1tensor(1915),G1tensor(1916),G1tensor(1917),G1tensor(1918),G1tensor(1919),G1tensor(1920))
  call G_TensorShift(G1tensor(1916),16)
  call Hotf_5pt_reduction_last(G2tensor(502),RedSet_5(32),mass5set(:,11),  & 
G1tensor(1921),G1tensor(1922),G1tensor(1923),G1tensor(1924),G1tensor(1925),G1tensor(1926))
  call G_TensorShift(G1tensor(1922),16)
  call Hotf_5pt_reduction_last(G2tensor(294),RedSet_5(34),mass5set(:,11),  & 
G1tensor(1927),G1tensor(1928),G1tensor(1929),G1tensor(1930),G1tensor(1931),G1tensor(1932))
  call G_TensorShift(G1tensor(1928),16)
  call Hotf_5pt_reduction_last(G2tensor(295),RedSet_5(81),mass5set(:,33),  & 
G1tensor(1933),G1tensor(1934),G1tensor(1935),G1tensor(1936),G1tensor(1937),G1tensor(1938))
  call G_TensorShift(G1tensor(1934),16)
  call Hotf_5pt_reduction_last(G2tensor(296),RedSet_5(34),mass5set(:,3),  & 
G1tensor(1939),G1tensor(1940),G1tensor(1941),G1tensor(1942),G1tensor(1943),G1tensor(1944))
  call G_TensorShift(G1tensor(1940),16)
  call Hotf_5pt_reduction_last(G2tensor(505),RedSet_5(32),mass5set(:,2),  & 
G1tensor(1945),G1tensor(1946),G1tensor(1947),G1tensor(1948),G1tensor(1949),G1tensor(1950))
  call G_TensorShift(G1tensor(1946),16)
  call Hotf_5pt_reduction_last(G2tensor(297),RedSet_5(34),mass5set(:,2),  & 
G1tensor(1951),G1tensor(1952),G1tensor(1953),G1tensor(1954),G1tensor(1955),G1tensor(1956))
  call G_TensorShift(G1tensor(1952),16)
  call Hotf_5pt_reduction_last(G2tensor(298),RedSet_5(81),mass5set(:,35),  & 
G1tensor(1957),G1tensor(1958),G1tensor(1959),G1tensor(1960),G1tensor(1961),G1tensor(1962))
  call G_TensorShift(G1tensor(1958),16)
  call Hotf_5pt_reduction_last(G2tensor(299),RedSet_5(34),mass5set(:,36),  & 
G1tensor(1963),G1tensor(1964),G1tensor(1965),G1tensor(1966),G1tensor(1967),G1tensor(1968))
  call G_TensorShift(G1tensor(1964),16)
  call Hotf_5pt_reduction_last(G2tensor(508),RedSet_5(32),mass5set(:,12),  & 
G1tensor(1969),G1tensor(1970),G1tensor(1971),G1tensor(1972),G1tensor(1973),G1tensor(1974))
  call G_TensorShift(G1tensor(1970),16)
  call Hotf_5pt_reduction_last(G2tensor(300),RedSet_5(34),mass5set(:,12),  & 
G1tensor(1975),G1tensor(1976),G1tensor(1977),G1tensor(1978),G1tensor(1979),G1tensor(1980))
  call G_TensorShift(G1tensor(1976),16)
  call Hotf_5pt_reduction_last(G2tensor(301),RedSet_5(34),mass5set(:,4),  & 
G1tensor(1981),G1tensor(1982),G1tensor(1983),G1tensor(1984),G1tensor(1985),G1tensor(1986))
  call G_TensorShift(G1tensor(1982),16)
  call Hotf_5pt_reduction_last(G2tensor(302),RedSet_5(34),mass5set(:,38),  & 
G1tensor(1987),G1tensor(1988),G1tensor(1989),G1tensor(1990),G1tensor(1991),G1tensor(1992))
  call G_TensorShift(G1tensor(1988),16)
  call Hotf_5pt_reduction_last(G2tensor(303),RedSet_5(81),mass5set(:,39),  & 
G1tensor(1993),G1tensor(1994),G1tensor(1995),G1tensor(1996),G1tensor(1997),G1tensor(1998))
  call G_TensorShift(G1tensor(1994),16)
  call Hotf_5pt_reduction_last(G2tensor(511),RedSet_5(33),mass5set(:,13),  & 
G1tensor(1999),G1tensor(2000),G1tensor(2001),G1tensor(2002),G1tensor(2003),G1tensor(2004))
  call G_TensorShift(G1tensor(2000),16)
  call Hotf_5pt_reduction_last(G2tensor(514),RedSet_5(32),mass5set(:,14),  & 
G1tensor(2005),G1tensor(2006),G1tensor(2007),G1tensor(2008),G1tensor(2009),G1tensor(2010))
  call G_TensorShift(G1tensor(2006),16)
  call Hotf_5pt_reduction_last(G2tensor(517),RedSet_5(34),mass5set(:,15),  & 
G1tensor(2011),G1tensor(2012),G1tensor(2013),G1tensor(2014),G1tensor(2015),G1tensor(2016))
  call G_TensorShift(G1tensor(2012),16)
  call Hotf_5pt_reduction_last(G2tensor(304),RedSet_5(82),mass5set(:,1),  & 
G1tensor(2017),G1tensor(2018),G1tensor(2019),G1tensor(2020),G1tensor(2021),G1tensor(2022))
  call G_TensorShift(G1tensor(2018),16)
  call Hotf_5pt_reduction_last(G2tensor(305),RedSet_5(83),mass5set(:,1),  & 
G1tensor(2023),G1tensor(2024),G1tensor(2025),G1tensor(2026),G1tensor(2027),G1tensor(2028))
  call G_TensorShift(G1tensor(2024),16)
  call Hotf_5pt_reduction_last(G2tensor(306),RedSet_5(82),mass5set(:,33),  & 
G1tensor(2029),G1tensor(2030),G1tensor(2031),G1tensor(2032),G1tensor(2033),G1tensor(2034))
  call G_TensorShift(G1tensor(2030),16)
  call Hotf_5pt_reduction_last(G2tensor(307),RedSet_5(82),mass5set(:,11),  & 
G1tensor(2035),G1tensor(2036),G1tensor(2037),G1tensor(2038),G1tensor(2039),G1tensor(2040))
  call G_TensorShift(G1tensor(2036),16)
  call Hotf_5pt_reduction_last(G2tensor(308),RedSet_5(83),mass5set(:,11),  & 
G1tensor(2041),G1tensor(2042),G1tensor(2043),G1tensor(2044),G1tensor(2045),G1tensor(2046))
  call G_TensorShift(G1tensor(2042),16)
  call Hotf_5pt_reduction_last(G2tensor(309),RedSet_5(83),mass5set(:,2),  & 
G1tensor(2047),G1tensor(2048),G1tensor(2049),G1tensor(2050),G1tensor(2051),G1tensor(2052))
  call G_TensorShift(G1tensor(2048),16)
  call Hotf_5pt_reduction_last(G2tensor(310),RedSet_5(82),mass5set(:,35),  & 
G1tensor(2053),G1tensor(2054),G1tensor(2055),G1tensor(2056),G1tensor(2057),G1tensor(2058))
  call G_TensorShift(G1tensor(2054),16)
  call Hotf_5pt_reduction_last(G2tensor(311),RedSet_5(83),mass5set(:,12),  & 
G1tensor(2059),G1tensor(2060),G1tensor(2061),G1tensor(2062),G1tensor(2063),G1tensor(2064))
  call G_TensorShift(G1tensor(2060),16)
  call Hotf_5pt_reduction_last(G2tensor(312),RedSet_5(84),mass5set(:,1),  & 
G1tensor(2065),G1tensor(2066),G1tensor(2067),G1tensor(2068),G1tensor(2069),G1tensor(2070))
  call G_TensorShift(G1tensor(2066),16)
  call Hotf_5pt_reduction_last(G2tensor(313),RedSet_5(85),mass5set(:,1),  & 
G1tensor(2071),G1tensor(2072),G1tensor(2073),G1tensor(2074),G1tensor(2075),G1tensor(2076))
  call G_TensorShift(G1tensor(2072),16)
  call Hotf_5pt_reduction_last(G2tensor(520),RedSet_5(35),mass5set(:,1),  & 
G1tensor(2077),G1tensor(2078),G1tensor(2079),G1tensor(2080),G1tensor(2081),G1tensor(2082))
  call G_TensorShift(G1tensor(2078),16)
  call Hotf_5pt_reduction_last(G2tensor(314),RedSet_5(85),mass5set(:,2),  & 
G1tensor(2083),G1tensor(2084),G1tensor(2085),G1tensor(2086),G1tensor(2087),G1tensor(2088))
  call G_TensorShift(G1tensor(2084),16)
  call Hotf_5pt_reduction_last(G2tensor(523),RedSet_5(35),mass5set(:,2),  & 
G1tensor(2089),G1tensor(2090),G1tensor(2091),G1tensor(2092),G1tensor(2093),G1tensor(2094))
  call G_TensorShift(G1tensor(2090),16)
  call Hotf_5pt_reduction_last(G2tensor(315),RedSet_5(84),mass5set(:,33),  & 
G1tensor(2095),G1tensor(2096),G1tensor(2097),G1tensor(2098),G1tensor(2099),G1tensor(2100))
  call G_TensorShift(G1tensor(2096),16)
  call Hotf_5pt_reduction_last(G2tensor(316),RedSet_5(85),mass5set(:,33),  & 
G1tensor(2101),G1tensor(2102),G1tensor(2103),G1tensor(2104),G1tensor(2105),G1tensor(2106))
  call G_TensorShift(G1tensor(2102),16)
  call Hotf_5pt_reduction_last(G2tensor(317),RedSet_5(84),mass5set(:,11),  & 
G1tensor(2107),G1tensor(2108),G1tensor(2109),G1tensor(2110),G1tensor(2111),G1tensor(2112))
  call G_TensorShift(G1tensor(2108),16)
  call Hotf_5pt_reduction_last(G2tensor(318),RedSet_5(85),mass5set(:,11),  & 
G1tensor(2113),G1tensor(2114),G1tensor(2115),G1tensor(2116),G1tensor(2117),G1tensor(2118))
  call G_TensorShift(G1tensor(2114),16)
  call Hotf_5pt_reduction_last(G2tensor(526),RedSet_5(35),mass5set(:,11),  & 
G1tensor(2119),G1tensor(2120),G1tensor(2121),G1tensor(2122),G1tensor(2123),G1tensor(2124))
  call G_TensorShift(G1tensor(2120),16)
  call Hotf_5pt_reduction_last(G2tensor(319),RedSet_5(85),mass5set(:,34),  & 
G1tensor(2125),G1tensor(2126),G1tensor(2127),G1tensor(2128),G1tensor(2129),G1tensor(2130))
  call G_TensorShift(G1tensor(2126),16)
  call Hotf_5pt_reduction_last(G2tensor(320),RedSet_5(85),mass5set(:,12),  & 
G1tensor(2131),G1tensor(2132),G1tensor(2133),G1tensor(2134),G1tensor(2135),G1tensor(2136))
  call G_TensorShift(G1tensor(2132),16)
  call Hotf_5pt_reduction_last(G2tensor(529),RedSet_5(35),mass5set(:,12),  & 
G1tensor(2137),G1tensor(2138),G1tensor(2139),G1tensor(2140),G1tensor(2141),G1tensor(2142))
  call G_TensorShift(G1tensor(2138),16)
  call Hotf_5pt_reduction_last(G2tensor(321),RedSet_5(84),mass5set(:,35),  & 
G1tensor(2143),G1tensor(2144),G1tensor(2145),G1tensor(2146),G1tensor(2147),G1tensor(2148))
  call G_TensorShift(G1tensor(2144),16)
  call Hotf_5pt_reduction_last(G2tensor(322),RedSet_5(85),mass5set(:,35),  & 
G1tensor(2149),G1tensor(2150),G1tensor(2151),G1tensor(2152),G1tensor(2153),G1tensor(2154))
  call G_TensorShift(G1tensor(2150),16)
  call Hotf_5pt_reduction_last(G2tensor(323),RedSet_5(85),mass5set(:,37),  & 
G1tensor(2155),G1tensor(2156),G1tensor(2157),G1tensor(2158),G1tensor(2159),G1tensor(2160))
  call G_TensorShift(G1tensor(2156),16)
  call Hotf_5pt_reduction_last(G2tensor(324),RedSet_5(86),mass5set(:,1),  & 
G1tensor(2161),G1tensor(2162),G1tensor(2163),G1tensor(2164),G1tensor(2165),G1tensor(2166))
  call G_TensorShift(G1tensor(2162),16)
  call Hotf_5pt_reduction_last(G2tensor(325),RedSet_5(86),mass5set(:,33),  & 
G1tensor(2167),G1tensor(2168),G1tensor(2169),G1tensor(2170),G1tensor(2171),G1tensor(2172))
  call G_TensorShift(G1tensor(2168),16)
  call Hotf_5pt_reduction_last(G2tensor(326),RedSet_5(86),mass5set(:,11),  & 
G1tensor(2173),G1tensor(2174),G1tensor(2175),G1tensor(2176),G1tensor(2177),G1tensor(2178))
  call G_TensorShift(G1tensor(2174),16)
  call Hotf_5pt_reduction_last(G2tensor(327),RedSet_5(86),mass5set(:,35),  & 
G1tensor(2179),G1tensor(2180),G1tensor(2181),G1tensor(2182),G1tensor(2183),G1tensor(2184))
  call G_TensorShift(G1tensor(2180),16)
  call Hotf_5pt_reduction_last(G2tensor(328),RedSet_5(87),mass5set(:,1),  & 
G1tensor(2185),G1tensor(2186),G1tensor(2187),G1tensor(2188),G1tensor(2189),G1tensor(2190))
  call G_TensorShift(G1tensor(2186),16)
  call Hotf_5pt_reduction_last(G2tensor(532),RedSet_5(36),mass5set(:,1),  & 
G1tensor(2191),G1tensor(2192),G1tensor(2193),G1tensor(2194),G1tensor(2195),G1tensor(2196))
  call G_TensorShift(G1tensor(2192),16)
  call Hotf_5pt_reduction_last(G2tensor(329),RedSet_5(38),mass5set(:,1),  & 
G1tensor(2197),G1tensor(2198),G1tensor(2199),G1tensor(2200),G1tensor(2201),G1tensor(2202))
  call G_TensorShift(G1tensor(2198),16)
  call Hotf_5pt_reduction_last(G2tensor(330),RedSet_5(87),mass5set(:,11),  & 
G1tensor(2203),G1tensor(2204),G1tensor(2205),G1tensor(2206),G1tensor(2207),G1tensor(2208))
  call G_TensorShift(G1tensor(2204),16)
  call Hotf_5pt_reduction_last(G2tensor(535),RedSet_5(36),mass5set(:,11),  & 
G1tensor(2209),G1tensor(2210),G1tensor(2211),G1tensor(2212),G1tensor(2213),G1tensor(2214))
  call G_TensorShift(G1tensor(2210),16)
  call Hotf_5pt_reduction_last(G2tensor(331),RedSet_5(38),mass5set(:,11),  & 
G1tensor(2215),G1tensor(2216),G1tensor(2217),G1tensor(2218),G1tensor(2219),G1tensor(2220))
  call G_TensorShift(G1tensor(2216),16)
  call Hotf_5pt_reduction_last(G2tensor(332),RedSet_5(87),mass5set(:,33),  & 
G1tensor(2221),G1tensor(2222),G1tensor(2223),G1tensor(2224),G1tensor(2225),G1tensor(2226))
  call G_TensorShift(G1tensor(2222),16)
  call Hotf_5pt_reduction_last(G2tensor(333),RedSet_5(38),mass5set(:,3),  & 
G1tensor(2227),G1tensor(2228),G1tensor(2229),G1tensor(2230),G1tensor(2231),G1tensor(2232))
  call G_TensorShift(G1tensor(2228),16)
  call Hotf_5pt_reduction_last(G2tensor(538),RedSet_5(36),mass5set(:,2),  & 
G1tensor(2233),G1tensor(2234),G1tensor(2235),G1tensor(2236),G1tensor(2237),G1tensor(2238))
  call G_TensorShift(G1tensor(2234),16)
  call Hotf_5pt_reduction_last(G2tensor(334),RedSet_5(38),mass5set(:,2),  & 
G1tensor(2239),G1tensor(2240),G1tensor(2241),G1tensor(2242),G1tensor(2243),G1tensor(2244))
  call G_TensorShift(G1tensor(2240),16)
  call Hotf_5pt_reduction_last(G2tensor(335),RedSet_5(87),mass5set(:,35),  & 
G1tensor(2245),G1tensor(2246),G1tensor(2247),G1tensor(2248),G1tensor(2249),G1tensor(2250))
  call G_TensorShift(G1tensor(2246),16)
  call Hotf_5pt_reduction_last(G2tensor(336),RedSet_5(38),mass5set(:,36),  & 
G1tensor(2251),G1tensor(2252),G1tensor(2253),G1tensor(2254),G1tensor(2255),G1tensor(2256))
  call G_TensorShift(G1tensor(2252),16)
  call Hotf_5pt_reduction_last(G2tensor(541),RedSet_5(36),mass5set(:,12),  & 
G1tensor(2257),G1tensor(2258),G1tensor(2259),G1tensor(2260),G1tensor(2261),G1tensor(2262))
  call G_TensorShift(G1tensor(2258),16)
  call Hotf_5pt_reduction_last(G2tensor(337),RedSet_5(38),mass5set(:,12),  & 
G1tensor(2263),G1tensor(2264),G1tensor(2265),G1tensor(2266),G1tensor(2267),G1tensor(2268))
  call G_TensorShift(G1tensor(2264),16)
  call Hotf_5pt_reduction_last(G2tensor(338),RedSet_5(38),mass5set(:,4),  & 
G1tensor(2269),G1tensor(2270),G1tensor(2271),G1tensor(2272),G1tensor(2273),G1tensor(2274))
  call G_TensorShift(G1tensor(2270),16)
  call Hotf_5pt_reduction_last(G2tensor(339),RedSet_5(38),mass5set(:,38),  & 
G1tensor(2275),G1tensor(2276),G1tensor(2277),G1tensor(2278),G1tensor(2279),G1tensor(2280))
  call G_TensorShift(G1tensor(2276),16)
  call Hotf_5pt_reduction_last(G2tensor(340),RedSet_5(87),mass5set(:,39),  & 
G1tensor(2281),G1tensor(2282),G1tensor(2283),G1tensor(2284),G1tensor(2285),G1tensor(2286))
  call G_TensorShift(G1tensor(2282),16)
  call Hotf_5pt_reduction_last(G2tensor(544),RedSet_5(37),mass5set(:,13),  & 
G1tensor(2287),G1tensor(2288),G1tensor(2289),G1tensor(2290),G1tensor(2291),G1tensor(2292))
  call G_TensorShift(G1tensor(2288),16)
  call Hotf_5pt_reduction_last(G2tensor(547),RedSet_5(36),mass5set(:,14),  & 
G1tensor(2293),G1tensor(2294),G1tensor(2295),G1tensor(2296),G1tensor(2297),G1tensor(2298))
  call G_TensorShift(G1tensor(2294),16)
  call Hotf_5pt_reduction_last(G2tensor(550),RedSet_5(38),mass5set(:,15),  & 
G1tensor(2299),G1tensor(2300),G1tensor(2301),G1tensor(2302),G1tensor(2303),G1tensor(2304))
  call G_TensorShift(G1tensor(2300),16)
  call Hotf_5pt_reduction_last(G2tensor(341),RedSet_5(88),mass5set(:,1),  & 
G1tensor(2305),G1tensor(2306),G1tensor(2307),G1tensor(2308),G1tensor(2309),G1tensor(2310))
  call G_TensorShift(G1tensor(2306),16)
  call Hotf_5pt_reduction_last(G2tensor(342),RedSet_5(88),mass5set(:,33),  & 
G1tensor(2311),G1tensor(2312),G1tensor(2313),G1tensor(2314),G1tensor(2315),G1tensor(2316))
  call G_TensorShift(G1tensor(2312),16)
  call Hotf_5pt_reduction_last(G2tensor(343),RedSet_5(88),mass5set(:,11),  & 
G1tensor(2317),G1tensor(2318),G1tensor(2319),G1tensor(2320),G1tensor(2321),G1tensor(2322))
  call G_TensorShift(G1tensor(2318),16)
  call Hotf_5pt_reduction_last(G2tensor(344),RedSet_5(88),mass5set(:,35),  & 
G1tensor(2323),G1tensor(2324),G1tensor(2325),G1tensor(2326),G1tensor(2327),G1tensor(2328))
  call G_TensorShift(G1tensor(2324),16)
  call Hotf_5pt_reduction_last(G2tensor(345),RedSet_5(75),mass5set(:,40),  & 
G1tensor(2329),G1tensor(2330),G1tensor(2331),G1tensor(2332),G1tensor(2333),G1tensor(2334))
  call G_TensorShift(G1tensor(2330),16)
  call Hotf_5pt_reduction_last(G2tensor(346),RedSet_5(75),mass5set(:,41),  & 
G1tensor(2335),G1tensor(2336),G1tensor(2337),G1tensor(2338),G1tensor(2339),G1tensor(2340))
  call G_TensorShift(G1tensor(2336),16)
  call Hotf_5pt_reduction_last(G2tensor(348),RedSet_5(30),mass5set(:,42),  & 
G1tensor(2341),G1tensor(2342),G1tensor(2343),G1tensor(2344),G1tensor(2345),G1tensor(2346))
  call G_TensorShift(G1tensor(2342),16)
  call Hotf_5pt_reduction_last(G2tensor(349),RedSet_5(30),mass5set(:,43),  & 
G1tensor(2347),G1tensor(2348),G1tensor(2349),G1tensor(2350),G1tensor(2351),G1tensor(2352))
  call G_TensorShift(G1tensor(2348),16)
  call Hotf_5pt_reduction_last(G2tensor(350),RedSet_5(33),mass5set(:,40),  & 
G1tensor(2353),G1tensor(2354),G1tensor(2355),G1tensor(2356),G1tensor(2357),G1tensor(2358))
  call G_TensorShift(G1tensor(2354),16)
  call Hotf_5pt_reduction_last(G2tensor(351),RedSet_5(33),mass5set(:,41),  & 
G1tensor(2359),G1tensor(2360),G1tensor(2361),G1tensor(2362),G1tensor(2363),G1tensor(2364))
  call G_TensorShift(G1tensor(2360),16)
  call Hotf_5pt_reduction_last(G2tensor(352),RedSet_5(63),mass5set(:,42),  & 
G1tensor(2365),G1tensor(2366),G1tensor(2367),G1tensor(2368),G1tensor(2369),G1tensor(2370))
  call G_TensorShift(G1tensor(2366),16)
  call Hotf_5pt_reduction_last(G2tensor(353),RedSet_5(63),mass5set(:,43),  & 
G1tensor(2371),G1tensor(2372),G1tensor(2373),G1tensor(2374),G1tensor(2375),G1tensor(2376))
  call G_TensorShift(G1tensor(2372),16)
  call Hotf_5pt_reduction_last(G2tensor(354),RedSet_5(85),mass5set(:,40),  & 
G1tensor(2377),G1tensor(2378),G1tensor(2379),G1tensor(2380),G1tensor(2381),G1tensor(2382))
  call G_TensorShift(G1tensor(2378),16)
  call Hotf_5pt_reduction_last(G2tensor(355),RedSet_5(85),mass5set(:,41),  & 
G1tensor(2383),G1tensor(2384),G1tensor(2385),G1tensor(2386),G1tensor(2387),G1tensor(2388))
  call G_TensorShift(G1tensor(2384),16)
  call Hotf_5pt_reduction_last(G2tensor(357),RedSet_5(38),mass5set(:,42),  & 
G1tensor(2389),G1tensor(2390),G1tensor(2391),G1tensor(2392),G1tensor(2393),G1tensor(2394))
  call G_TensorShift(G1tensor(2390),16)
  call Hotf_5pt_reduction_last(G2tensor(358),RedSet_5(38),mass5set(:,43),  & 
G1tensor(2395),G1tensor(2396),G1tensor(2397),G1tensor(2398),G1tensor(2399),G1tensor(2400))
  call G_TensorShift(G1tensor(2396),16)
  call Hotf_5pt_reduction_last(G2tensor(359),RedSet_5(25),mass5set(:,40),  & 
G1tensor(2401),G1tensor(2402),G1tensor(2403),G1tensor(2404),G1tensor(2405),G1tensor(2406))
  call G_TensorShift(G1tensor(2402),16)
  call Hotf_5pt_reduction_last(G2tensor(360),RedSet_5(25),mass5set(:,41),  & 
G1tensor(2407),G1tensor(2408),G1tensor(2409),G1tensor(2410),G1tensor(2411),G1tensor(2412))
  call G_TensorShift(G1tensor(2408),16)
  call Hotf_5pt_reduction_last(G2tensor(361),RedSet_5(68),mass5set(:,42),  & 
G1tensor(2413),G1tensor(2414),G1tensor(2415),G1tensor(2416),G1tensor(2417),G1tensor(2418))
  call G_TensorShift(G1tensor(2414),16)
  call Hotf_5pt_reduction_last(G2tensor(362),RedSet_5(68),mass5set(:,43),  & 
G1tensor(2419),G1tensor(2420),G1tensor(2421),G1tensor(2422),G1tensor(2423),G1tensor(2424))
  call G_TensorShift(G1tensor(2420),16)
  call Hotf_5pt_reduction_last(G2tensor(363),RedSet_5(72),mass5set(:,40),  & 
G1tensor(2425),G1tensor(2426),G1tensor(2427),G1tensor(2428),G1tensor(2429),G1tensor(2430))
  call G_TensorShift(G1tensor(2426),16)
  call Hotf_5pt_reduction_last(G2tensor(364),RedSet_5(72),mass5set(:,41),  & 
G1tensor(2431),G1tensor(2432),G1tensor(2433),G1tensor(2434),G1tensor(2435),G1tensor(2436))
  call G_TensorShift(G1tensor(2432),16)
  call Hotf_5pt_reduction_last(G2tensor(366),RedSet_5(26),mass5set(:,42),  & 
G1tensor(2437),G1tensor(2438),G1tensor(2439),G1tensor(2440),G1tensor(2441),G1tensor(2442))
  call G_TensorShift(G1tensor(2438),16)
  call Hotf_5pt_reduction_last(G2tensor(367),RedSet_5(26),mass5set(:,43),  & 
G1tensor(2443),G1tensor(2444),G1tensor(2445),G1tensor(2446),G1tensor(2447),G1tensor(2448))
  call G_TensorShift(G1tensor(2444),16)
  call Hotf_5pt_reduction_last(G2tensor(368),RedSet_5(37),mass5set(:,40),  & 
G1tensor(2449),G1tensor(2450),G1tensor(2451),G1tensor(2452),G1tensor(2453),G1tensor(2454))
  call G_TensorShift(G1tensor(2450),16)
  call Hotf_5pt_reduction_last(G2tensor(369),RedSet_5(37),mass5set(:,41),  & 
G1tensor(2455),G1tensor(2456),G1tensor(2457),G1tensor(2458),G1tensor(2459),G1tensor(2460))
  call G_TensorShift(G1tensor(2456),16)
  call Hotf_5pt_reduction_last(G2tensor(370),RedSet_5(70),mass5set(:,42),  & 
G1tensor(2461),G1tensor(2462),G1tensor(2463),G1tensor(2464),G1tensor(2465),G1tensor(2466))
  call G_TensorShift(G1tensor(2462),16)
  call Hotf_5pt_reduction_last(G2tensor(371),RedSet_5(70),mass5set(:,43),  & 
G1tensor(2467),G1tensor(2468),G1tensor(2469),G1tensor(2470),G1tensor(2471),G1tensor(2472))
  call G_TensorShift(G1tensor(2468),16)
  call Hotf_5pt_reduction_last(G2tensor(372),RedSet_5(78),mass5set(:,40),  & 
G1tensor(2473),G1tensor(2474),G1tensor(2475),G1tensor(2476),G1tensor(2477),G1tensor(2478))
  call G_TensorShift(G1tensor(2474),16)
  call Hotf_5pt_reduction_last(G2tensor(373),RedSet_5(78),mass5set(:,41),  & 
G1tensor(2479),G1tensor(2480),G1tensor(2481),G1tensor(2482),G1tensor(2483),G1tensor(2484))
  call G_TensorShift(G1tensor(2480),16)
  call Hotf_5pt_reduction_last(G2tensor(375),RedSet_5(34),mass5set(:,42),  & 
G1tensor(2485),G1tensor(2486),G1tensor(2487),G1tensor(2488),G1tensor(2489),G1tensor(2490))
  call G_TensorShift(G1tensor(2486),16)
  call Hotf_5pt_reduction_last(G2tensor(376),RedSet_5(34),mass5set(:,43),  & 
G1tensor(2491),G1tensor(2492),G1tensor(2493),G1tensor(2494),G1tensor(2495),G1tensor(2496))
  call G_TensorShift(G1tensor(2492),16)
  call Hotf_5pt_reduction_last(G2tensor(377),RedSet_5(29),mass5set(:,40),  & 
G1tensor(2497),G1tensor(2498),G1tensor(2499),G1tensor(2500),G1tensor(2501),G1tensor(2502))
  call G_TensorShift(G1tensor(2498),16)
  call Hotf_5pt_reduction_last(G2tensor(378),RedSet_5(29),mass5set(:,41),  & 
G1tensor(2503),G1tensor(2504),G1tensor(2505),G1tensor(2506),G1tensor(2507),G1tensor(2508))
  call G_TensorShift(G1tensor(2504),16)
  call Hotf_5pt_reduction_last(G2tensor(379),RedSet_5(66),mass5set(:,42),  & 
G1tensor(2509),G1tensor(2510),G1tensor(2511),G1tensor(2512),G1tensor(2513),G1tensor(2514))
  call G_TensorShift(G1tensor(2510),16)
  call Hotf_5pt_reduction_last(G2tensor(380),RedSet_5(66),mass5set(:,43),  & 
G1tensor(2515),G1tensor(2516),G1tensor(2517),G1tensor(2518),G1tensor(2519),G1tensor(2520))
  call G_TensorShift(G1tensor(2516),16)
  call Hotf_5pt_reduction_last(G2tensor(397),RedSet_5(17),mass5set(:,6),  & 
G1tensor(2521),G1tensor(2522),G1tensor(2523),G1tensor(2524),G1tensor(2525),G1tensor(2526))
  call G_TensorShift(G1tensor(2522),8)
  call Hotf_5pt_reduction_last(G2tensor(399),RedSet_5(17),mass5set(:,7),  & 
G1tensor(2527),G1tensor(2528),G1tensor(2529),G1tensor(2530),G1tensor(2531),G1tensor(2532))
  call G_TensorShift(G1tensor(2528),8)
  call Hotf_5pt_reduction_last(G2tensor(401),RedSet_5(17),mass5set(:,8),  & 
G1tensor(2533),G1tensor(2534),G1tensor(2535),G1tensor(2536),G1tensor(2537),G1tensor(2538))
  call G_TensorShift(G1tensor(2534),8)
  call Hotf_5pt_reduction_last(G2tensor(403),RedSet_5(17),mass5set(:,9),  & 
G1tensor(2539),G1tensor(2540),G1tensor(2541),G1tensor(2542),G1tensor(2543),G1tensor(2544))
  call G_TensorShift(G1tensor(2540),8)
  call Hotf_5pt_reduction_last(G2tensor(405),RedSet_5(18),mass5set(:,6),  & 
G1tensor(2545),G1tensor(2546),G1tensor(2547),G1tensor(2548),G1tensor(2549),G1tensor(2550))
  call G_TensorShift(G1tensor(2546),8)
  call Hotf_5pt_reduction_last(G2tensor(407),RedSet_5(18),mass5set(:,7),  & 
G1tensor(2551),G1tensor(2552),G1tensor(2553),G1tensor(2554),G1tensor(2555),G1tensor(2556))
  call G_TensorShift(G1tensor(2552),8)
  call Hotf_5pt_reduction_last(G2tensor(409),RedSet_5(18),mass5set(:,8),  & 
G1tensor(2557),G1tensor(2558),G1tensor(2559),G1tensor(2560),G1tensor(2561),G1tensor(2562))
  call G_TensorShift(G1tensor(2558),8)
  call Hotf_5pt_reduction_last(G2tensor(411),RedSet_5(18),mass5set(:,9),  & 
G1tensor(2563),G1tensor(2564),G1tensor(2565),G1tensor(2566),G1tensor(2567),G1tensor(2568))
  call G_TensorShift(G1tensor(2564),8)
  call Hotf_5pt_reduction_last(G2tensor(568),RedSet_5(39),mass5set(:,16),  & 
G1tensor(2569),G1tensor(2570),G1tensor(2571),G1tensor(2572),G1tensor(2573),G1tensor(2574))
  call G_TensorShift(G1tensor(2570),5)
  call Hotf_5pt_reduction_last(G2tensor(571),RedSet_5(39),mass5set(:,17),  & 
G1tensor(2575),G1tensor(2576),G1tensor(2577),G1tensor(2578),G1tensor(2579),G1tensor(2580))
  call G_TensorShift(G1tensor(2576),5)
  call Hotf_5pt_reduction_last(G2tensor(574),RedSet_5(39),mass5set(:,18),  & 
G1tensor(2581),G1tensor(2582),G1tensor(2583),G1tensor(2584),G1tensor(2585),G1tensor(2586))
  call G_TensorShift(G1tensor(2582),5)
  call Hotf_5pt_reduction_last(G2tensor(577),RedSet_5(39),mass5set(:,19),  & 
G1tensor(2587),G1tensor(2588),G1tensor(2589),G1tensor(2590),G1tensor(2591),G1tensor(2592))
  call G_TensorShift(G1tensor(2588),5)
  call Hotf_5pt_reduction_last(G2tensor(580),RedSet_5(39),mass5set(:,20),  & 
G1tensor(2593),G1tensor(2594),G1tensor(2595),G1tensor(2596),G1tensor(2597),G1tensor(2598))
  call G_TensorShift(G1tensor(2594),5)
  call Hotf_5pt_reduction_last(G2tensor(598),RedSet_5(40),mass5set(:,16),  & 
G1tensor(2599),G1tensor(2600),G1tensor(2601),G1tensor(2602),G1tensor(2603),G1tensor(2604))
  call G_TensorShift(G1tensor(2600),6)
  call Hotf_5pt_reduction_last(G2tensor(601),RedSet_5(40),mass5set(:,17),  & 
G1tensor(2605),G1tensor(2606),G1tensor(2607),G1tensor(2608),G1tensor(2609),G1tensor(2610))
  call G_TensorShift(G1tensor(2606),6)
  call Hotf_5pt_reduction_last(G2tensor(604),RedSet_5(40),mass5set(:,18),  & 
G1tensor(2611),G1tensor(2612),G1tensor(2613),G1tensor(2614),G1tensor(2615),G1tensor(2616))
  call G_TensorShift(G1tensor(2612),6)
  call Hotf_5pt_reduction_last(G2tensor(607),RedSet_5(40),mass5set(:,19),  & 
G1tensor(2617),G1tensor(2618),G1tensor(2619),G1tensor(2620),G1tensor(2621),G1tensor(2622))
  call G_TensorShift(G1tensor(2618),6)
  call Hotf_5pt_reduction_last(G2tensor(610),RedSet_5(40),mass5set(:,20),  & 
G1tensor(2623),G1tensor(2624),G1tensor(2625),G1tensor(2626),G1tensor(2627),G1tensor(2628))
  call G_TensorShift(G1tensor(2624),6)
  call Hotf_5pt_reduction_last(G2tensor(625),RedSet_5(41),mass5set(:,16),  & 
G1tensor(2629),G1tensor(2630),G1tensor(2631),G1tensor(2632),G1tensor(2633),G1tensor(2634))
  call G_TensorShift(G1tensor(2630),9)
  call Hotf_5pt_reduction_last(G2tensor(628),RedSet_5(41),mass5set(:,18),  & 
G1tensor(2635),G1tensor(2636),G1tensor(2637),G1tensor(2638),G1tensor(2639),G1tensor(2640))
  call G_TensorShift(G1tensor(2636),9)
  call Hotf_5pt_reduction_last(G2tensor(631),RedSet_5(41),mass5set(:,17),  & 
G1tensor(2641),G1tensor(2642),G1tensor(2643),G1tensor(2644),G1tensor(2645),G1tensor(2646))
  call G_TensorShift(G1tensor(2642),9)
  call Hotf_5pt_reduction_last(G2tensor(634),RedSet_5(41),mass5set(:,19),  & 
G1tensor(2647),G1tensor(2648),G1tensor(2649),G1tensor(2650),G1tensor(2651),G1tensor(2652))
  call G_TensorShift(G1tensor(2648),9)
  call Hotf_5pt_reduction_last(G2tensor(652),RedSet_5(42),mass5set(:,16),  & 
G1tensor(2653),G1tensor(2654),G1tensor(2655),G1tensor(2656),G1tensor(2657),G1tensor(2658))
  call G_TensorShift(G1tensor(2654),9)
  call Hotf_5pt_reduction_last(G2tensor(655),RedSet_5(42),mass5set(:,17),  & 
G1tensor(2659),G1tensor(2660),G1tensor(2661),G1tensor(2662),G1tensor(2663),G1tensor(2664))
  call G_TensorShift(G1tensor(2660),9)
  call Hotf_5pt_reduction_last(G2tensor(658),RedSet_5(42),mass5set(:,18),  & 
G1tensor(2665),G1tensor(2666),G1tensor(2667),G1tensor(2668),G1tensor(2669),G1tensor(2670))
  call G_TensorShift(G1tensor(2666),9)
  call Hotf_5pt_reduction_last(G2tensor(661),RedSet_5(42),mass5set(:,19),  & 
G1tensor(2671),G1tensor(2672),G1tensor(2673),G1tensor(2674),G1tensor(2675),G1tensor(2676))
  call G_TensorShift(G1tensor(2672),9)
  call Hotf_5pt_reduction_last(G2tensor(664),RedSet_5(42),mass5set(:,20),  & 
G1tensor(2677),G1tensor(2678),G1tensor(2679),G1tensor(2680),G1tensor(2681),G1tensor(2682))
  call G_TensorShift(G1tensor(2678),9)
  call Hotf_5pt_reduction_last(G2tensor(679),RedSet_5(43),mass5set(:,16),  & 
G1tensor(2683),G1tensor(2684),G1tensor(2685),G1tensor(2686),G1tensor(2687),G1tensor(2688))
  call G_TensorShift(G1tensor(2684),10)
  call Hotf_5pt_reduction_last(G2tensor(682),RedSet_5(43),mass5set(:,18),  & 
G1tensor(2689),G1tensor(2690),G1tensor(2691),G1tensor(2692),G1tensor(2693),G1tensor(2694))
  call G_TensorShift(G1tensor(2690),10)
  call Hotf_5pt_reduction_last(G2tensor(685),RedSet_5(43),mass5set(:,17),  & 
G1tensor(2695),G1tensor(2696),G1tensor(2697),G1tensor(2698),G1tensor(2699),G1tensor(2700))
  call G_TensorShift(G1tensor(2696),10)
  call Hotf_5pt_reduction_last(G2tensor(688),RedSet_5(43),mass5set(:,19),  & 
G1tensor(2701),G1tensor(2702),G1tensor(2703),G1tensor(2704),G1tensor(2705),G1tensor(2706))
  call G_TensorShift(G1tensor(2702),10)
  call Hotf_5pt_reduction_last(G2tensor(706),RedSet_5(44),mass5set(:,16),  & 
G1tensor(2707),G1tensor(2708),G1tensor(2709),G1tensor(2710),G1tensor(2711),G1tensor(2712))
  call G_TensorShift(G1tensor(2708),10)
  call Hotf_5pt_reduction_last(G2tensor(709),RedSet_5(44),mass5set(:,17),  & 
G1tensor(2713),G1tensor(2714),G1tensor(2715),G1tensor(2716),G1tensor(2717),G1tensor(2718))
  call G_TensorShift(G1tensor(2714),10)
  call Hotf_5pt_reduction_last(G2tensor(712),RedSet_5(44),mass5set(:,18),  & 
G1tensor(2719),G1tensor(2720),G1tensor(2721),G1tensor(2722),G1tensor(2723),G1tensor(2724))
  call G_TensorShift(G1tensor(2720),10)
  call Hotf_5pt_reduction_last(G2tensor(715),RedSet_5(44),mass5set(:,19),  & 
G1tensor(2725),G1tensor(2726),G1tensor(2727),G1tensor(2728),G1tensor(2729),G1tensor(2730))
  call G_TensorShift(G1tensor(2726),10)
  call Hotf_5pt_reduction_last(G2tensor(718),RedSet_5(44),mass5set(:,20),  & 
G1tensor(2731),G1tensor(2732),G1tensor(2733),G1tensor(2734),G1tensor(2735),G1tensor(2736))
  call G_TensorShift(G1tensor(2732),10)
  call Hotf_5pt_reduction_last(G2tensor(721),RedSet_5(45),mass5set(:,21),  & 
G1tensor(2737),G1tensor(2738),G1tensor(2739),G1tensor(2740),G1tensor(2741),G1tensor(2742))
  call G_TensorShift(G1tensor(2738),8)
  call Hotf_5pt_reduction_last(G2tensor(724),RedSet_5(45),mass5set(:,22),  & 
G1tensor(2743),G1tensor(2744),G1tensor(2745),G1tensor(2746),G1tensor(2747),G1tensor(2748))
  call G_TensorShift(G1tensor(2744),8)
  call Hotf_5pt_reduction_last(G2tensor(727),RedSet_5(45),mass5set(:,23),  & 
G1tensor(2749),G1tensor(2750),G1tensor(2751),G1tensor(2752),G1tensor(2753),G1tensor(2754))
  call G_TensorShift(G1tensor(2750),8)
  call Hotf_5pt_reduction_last(G2tensor(730),RedSet_5(45),mass5set(:,24),  & 
G1tensor(2755),G1tensor(2756),G1tensor(2757),G1tensor(2758),G1tensor(2759),G1tensor(2760))
  call G_TensorShift(G1tensor(2756),8)
  call Hotf_5pt_reduction_last(G2tensor(733),RedSet_5(46),mass5set(:,21),  & 
G1tensor(2761),G1tensor(2762),G1tensor(2763),G1tensor(2764),G1tensor(2765),G1tensor(2766))
  call G_TensorShift(G1tensor(2762),4)
  call Hotf_5pt_reduction_last(G2tensor(736),RedSet_5(46),mass5set(:,22),  & 
G1tensor(2767),G1tensor(2768),G1tensor(2769),G1tensor(2770),G1tensor(2771),G1tensor(2772))
  call G_TensorShift(G1tensor(2768),4)
  call Hotf_5pt_reduction_last(G2tensor(739),RedSet_5(46),mass5set(:,23),  & 
G1tensor(2773),G1tensor(2774),G1tensor(2775),G1tensor(2776),G1tensor(2777),G1tensor(2778))
  call G_TensorShift(G1tensor(2774),4)
  call Hotf_5pt_reduction_last(G2tensor(742),RedSet_5(46),mass5set(:,24),  & 
G1tensor(2779),G1tensor(2780),G1tensor(2781),G1tensor(2782),G1tensor(2783),G1tensor(2784))
  call G_TensorShift(G1tensor(2780),4)
  call Hotf_5pt_reduction_last(G2tensor(745),RedSet_5(47),mass5set(:,21),  & 
G1tensor(2785),G1tensor(2786),G1tensor(2787),G1tensor(2788),G1tensor(2789),G1tensor(2790))
  call G_TensorShift(G1tensor(2786),8)
  call Hotf_5pt_reduction_last(G2tensor(748),RedSet_5(47),mass5set(:,22),  & 
G1tensor(2791),G1tensor(2792),G1tensor(2793),G1tensor(2794),G1tensor(2795),G1tensor(2796))
  call G_TensorShift(G1tensor(2792),8)
  call Hotf_5pt_reduction_last(G2tensor(751),RedSet_5(47),mass5set(:,23),  & 
G1tensor(2797),G1tensor(2798),G1tensor(2799),G1tensor(2800),G1tensor(2801),G1tensor(2802))
  call G_TensorShift(G1tensor(2798),8)
  call Hotf_5pt_reduction_last(G2tensor(754),RedSet_5(47),mass5set(:,24),  & 
G1tensor(2803),G1tensor(2804),G1tensor(2805),G1tensor(2806),G1tensor(2807),G1tensor(2808))
  call G_TensorShift(G1tensor(2804),8)
  call Hotf_5pt_reduction_last(G2tensor(757),RedSet_5(48),mass5set(:,21),  & 
G1tensor(2809),G1tensor(2810),G1tensor(2811),G1tensor(2812),G1tensor(2813),G1tensor(2814))
  call G_TensorShift(G1tensor(2810),4)
  call Hotf_5pt_reduction_last(G2tensor(760),RedSet_5(48),mass5set(:,22),  & 
G1tensor(2815),G1tensor(2816),G1tensor(2817),G1tensor(2818),G1tensor(2819),G1tensor(2820))
  call G_TensorShift(G1tensor(2816),4)
  call Hotf_5pt_reduction_last(G2tensor(763),RedSet_5(48),mass5set(:,23),  & 
G1tensor(2821),G1tensor(2822),G1tensor(2823),G1tensor(2824),G1tensor(2825),G1tensor(2826))
  call G_TensorShift(G1tensor(2822),4)
  call Hotf_5pt_reduction_last(G2tensor(766),RedSet_5(48),mass5set(:,24),  & 
G1tensor(2827),G1tensor(2828),G1tensor(2829),G1tensor(2830),G1tensor(2831),G1tensor(2832))
  call G_TensorShift(G1tensor(2828),4)
  call Hotf_5pt_reduction_last(G2tensor(772),RedSet_5(19),mass5set(:,23),  & 
G1tensor(2833),G1tensor(2834),G1tensor(2835),G1tensor(2836),G1tensor(2837),G1tensor(2838))
  call G_TensorShift(G1tensor(2834),8)
  call Hotf_5pt_reduction_last(G2tensor(775),RedSet_5(19),mass5set(:,22),  & 
G1tensor(2839),G1tensor(2840),G1tensor(2841),G1tensor(2842),G1tensor(2843),G1tensor(2844))
  call G_TensorShift(G1tensor(2840),8)
  call Hotf_5pt_reduction_last(G2tensor(778),RedSet_5(19),mass5set(:,24),  & 
G1tensor(2845),G1tensor(2846),G1tensor(2847),G1tensor(2848),G1tensor(2849),G1tensor(2850))
  call G_TensorShift(G1tensor(2846),8)
  call Hotf_5pt_reduction_last(G2tensor(781),RedSet_5(19),mass5set(:,25),  & 
G1tensor(2851),G1tensor(2852),G1tensor(2853),G1tensor(2854),G1tensor(2855),G1tensor(2856))
  call G_TensorShift(G1tensor(2852),8)
  call Hotf_5pt_reduction_last(G2tensor(787),RedSet_5(20),mass5set(:,23),  & 
G1tensor(2857),G1tensor(2858),G1tensor(2859),G1tensor(2860),G1tensor(2861),G1tensor(2862))
  call G_TensorShift(G1tensor(2858),4)
  call Hotf_5pt_reduction_last(G2tensor(790),RedSet_5(20),mass5set(:,22),  & 
G1tensor(2863),G1tensor(2864),G1tensor(2865),G1tensor(2866),G1tensor(2867),G1tensor(2868))
  call G_TensorShift(G1tensor(2864),4)
  call Hotf_5pt_reduction_last(G2tensor(793),RedSet_5(20),mass5set(:,24),  & 
G1tensor(2869),G1tensor(2870),G1tensor(2871),G1tensor(2872),G1tensor(2873),G1tensor(2874))
  call G_TensorShift(G1tensor(2870),4)
  call Hotf_5pt_reduction_last(G2tensor(796),RedSet_5(20),mass5set(:,25),  & 
G1tensor(2875),G1tensor(2876),G1tensor(2877),G1tensor(2878),G1tensor(2879),G1tensor(2880))
  call G_TensorShift(G1tensor(2876),4)
  call Hotf_5pt_reduction_last(G2tensor(802),RedSet_5(21),mass5set(:,22),  & 
G1tensor(2881),G1tensor(2882),G1tensor(2883),G1tensor(2884),G1tensor(2885),G1tensor(2886))
  call G_TensorShift(G1tensor(2882),8)
  call Hotf_5pt_reduction_last(G2tensor(805),RedSet_5(21),mass5set(:,23),  & 
G1tensor(2887),G1tensor(2888),G1tensor(2889),G1tensor(2890),G1tensor(2891),G1tensor(2892))
  call G_TensorShift(G1tensor(2888),8)
  call Hotf_5pt_reduction_last(G2tensor(808),RedSet_5(21),mass5set(:,24),  & 
G1tensor(2893),G1tensor(2894),G1tensor(2895),G1tensor(2896),G1tensor(2897),G1tensor(2898))
  call G_TensorShift(G1tensor(2894),8)
  call Hotf_5pt_reduction_last(G2tensor(811),RedSet_5(21),mass5set(:,25),  & 
G1tensor(2899),G1tensor(2900),G1tensor(2901),G1tensor(2902),G1tensor(2903),G1tensor(2904))
  call G_TensorShift(G1tensor(2900),8)
  call Hotf_5pt_reduction_last(G2tensor(817),RedSet_5(22),mass5set(:,22),  & 
G1tensor(2905),G1tensor(2906),G1tensor(2907),G1tensor(2908),G1tensor(2909),G1tensor(2910))
  call G_TensorShift(G1tensor(2906),4)
  call Hotf_5pt_reduction_last(G2tensor(820),RedSet_5(22),mass5set(:,23),  & 
G1tensor(2911),G1tensor(2912),G1tensor(2913),G1tensor(2914),G1tensor(2915),G1tensor(2916))
  call G_TensorShift(G1tensor(2912),4)
  call Hotf_5pt_reduction_last(G2tensor(823),RedSet_5(22),mass5set(:,24),  & 
G1tensor(2917),G1tensor(2918),G1tensor(2919),G1tensor(2920),G1tensor(2921),G1tensor(2922))
  call G_TensorShift(G1tensor(2918),4)
  call Hotf_5pt_reduction_last(G2tensor(826),RedSet_5(22),mass5set(:,25),  & 
G1tensor(2923),G1tensor(2924),G1tensor(2925),G1tensor(2926),G1tensor(2927),G1tensor(2928))
  call G_TensorShift(G1tensor(2924),4)
  call ol_merge_tensors(T1sum(133),[G1tensor(1)])
  call ol_merge_tensors(T1sum(134),[G1tensor(37)])
  call ol_merge_tensors(T1sum(135),[G1tensor(73)])
  call ol_merge_tensors(T1sum(136),[G1tensor(109)])
  call ol_merge_tensors(T1sum(137),[G1tensor(145)])
  call ol_merge_tensors(T1sum(138),[G1tensor(181)])
  call ol_merge_tensors(T1sum(139),[G1tensor(217)])
  call ol_merge_tensors(T1sum(140),[G1tensor(253)])
  call ol_merge_tensors(T1sum(141),[G1tensor(289)])
  call ol_merge_tensors(T1sum(142),[G1tensor(325)])
  call ol_merge_tensors(T1sum(143),[G1tensor(361)])
  call ol_merge_tensors(T1sum(144),[G1tensor(397)])
  call ol_merge_tensors(T1sum(145),[G1tensor(433)])
  call ol_merge_tensors(T1sum(146),[G1tensor(469)])
  call ol_merge_tensors(T1sum(147),[G1tensor(505)])
  call ol_merge_tensors(T1sum(148),[G1tensor(541)])
  call ol_merge_tensors(T1sum(149),[G1tensor(577)])
  call ol_merge_tensors(T1sum(150),[G1tensor(613)])
  call ol_merge_tensors(T1sum(151),[G1tensor(649)])
  call ol_merge_tensors(T1sum(152),[G1tensor(685)])
  call ol_merge_tensors(T1sum(153),[G1tensor(721)])
  call ol_merge_tensors(T1sum(154),[G1tensor(757)])
  call ol_merge_tensors(T1sum(155),[G1tensor(2)])
  call ol_merge_tensors(T1sum(156),[G1tensor(38)])
  call ol_merge_tensors(T1sum(157),[G1tensor(74)])
  call ol_merge_tensors(T1sum(158),[G1tensor(110)])
  call ol_merge_tensors(T1sum(159),[G1tensor(146)])
  call ol_merge_tensors(T1sum(160),[G1tensor(182)])
  call ol_merge_tensors(T1sum(161),[G1tensor(218)])
  call ol_merge_tensors(T1sum(162),[G1tensor(254)])
  call ol_merge_tensors(T1sum(163),[G1tensor(290)])
  call ol_merge_tensors(T1sum(164),[G1tensor(326)])
  call ol_merge_tensors(T1sum(165),[G1tensor(362)])
  call ol_merge_tensors(T1sum(166),[G1tensor(398)])
  call ol_merge_tensors(T1sum(167),[G1tensor(434)])
  call ol_merge_tensors(T1sum(168),[G1tensor(470)])
  call ol_merge_tensors(T1sum(169),[G1tensor(506)])
  call ol_merge_tensors(T1sum(170),[G1tensor(542)])
  call ol_merge_tensors(T1sum(171),[G1tensor(578)])
  call ol_merge_tensors(T1sum(172),[G1tensor(614)])
  call ol_merge_tensors(T1sum(173),[G1tensor(650)])
  call ol_merge_tensors(T1sum(174),[G1tensor(686)])
  call ol_merge_tensors(T1sum(175),[G1tensor(722)])
  call ol_merge_tensors(T1sum(176),[G1tensor(758)])
  call ol_merge_tensors(T1sum(177),[G1tensor(9)])
  call ol_merge_tensors(T1sum(178),[G1tensor(23)])
  call ol_merge_tensors(T1sum(179),[G1tensor(131)])
  call ol_merge_tensors(T1sum(180),[G1tensor(27)])
  call ol_merge_tensors(T1sum(181),[G1tensor(41)])
  call ol_merge_tensors(T1sum(182),[G1tensor(364)])
  call ol_merge_tensors(T1sum(183),[G1tensor(143)])
  call ol_merge_tensors(T1sum(184),[G1tensor(382)])
  call ol_merge_tensors(T1sum(185),[G1tensor(376)])
  call ol_merge_tensors(T1sum(186),[G1tensor(444)])
  call ol_merge_tensors(T1sum(187),[G1tensor(167)])
  call ol_merge_tensors(T1sum(188),[G1tensor(75)])
  call ol_merge_tensors(T1sum(189),[G1tensor(83)])
  call ol_merge_tensors(T1sum(190),[G1tensor(185)])
  call ol_merge_tensors(T1sum(191),[G1tensor(87)])
  call ol_merge_tensors(T1sum(192),[G1tensor(526)])
  call ol_merge_tensors(T1sum(193),[G1tensor(324)])
  call ol_merge_tensors(T1sum(194),[G1tensor(336)])
  call ol_merge_tensors(T1sum(195),[G1tensor(538)])
  call ol_merge_tensors(T1sum(196),[G1tensor(694)])
  call ol_merge_tensors(T1sum(197),[G1tensor(204)])
  call ol_merge_tensors(T1sum(198),[G1tensor(210)])
  call ol_merge_tensors(T1sum(199),[G1tensor(216)])
  call ol_merge_tensors(T1sum(200),[G1tensor(730)])
  call ol_merge_tensors(T1sum(201),[G1tensor(718)])
  call ol_merge_tensors(T1sum(202),[G1tensor(240)])
  call ol_merge_tensors(T1sum(203),[G1tensor(600)])
  call ol_merge_tensors(T1sum(204),[G1tensor(618)])
  call ol_merge_tensors(T1sum(205),[G1tensor(183)])
  call ol_merge_tensors(T1sum(206),[G1tensor(268)])
  call ol_merge_tensors(T1sum(207),[G1tensor(274)])
  call ol_merge_tensors(T1sum(208),[G1tensor(624)])
  call ol_merge_tensors(T1sum(209),[G1tensor(201)])
  call ol_merge_tensors(T1sum(210),[G1tensor(766)])
  call ol_merge_tensors(T1sum(211),[G1tensor(760)])
  call ol_merge_tensors(T1sum(212),[G1tensor(754)])
  call ol_merge_tensors(T1sum(213),[G1tensor(778)])
  call ol_merge_tensors(T1sum(214),[G1tensor(790)])
  call ol_merge_tensors(T1sum(215),[G1tensor(648)])
  call ol_merge_tensors(T1sum(216),[G1tensor(666)])
  call ol_merge_tensors(T1sum(217),[G1tensor(279)])
  call ol_merge_tensors(T1sum(218),[G1tensor(684)])
  call ol_merge_tensors(T1sum(219),[G1tensor(672)])
  call ol_merge_tensors(T1sum(220),[G1tensor(293)])
  call ol_merge_tensors(T1sum(221),[G1tensor(317)])
  call ol_merge_tensors(T1sum(222),[G1tensor(321)])
  call ol_merge_tensors(T1sum(223),[G1tensor(327)])
  call ol_merge_tensors(T1sum(224),[G1tensor(341)])
  call ol_merge_tensors(T1sum(225),[G1tensor(574)])
  call ol_merge_tensors(T1sum(226),[G1tensor(365)])
  call ol_merge_tensors(T1sum(227),[G1tensor(377)])
  call ol_merge_tensors(T1sum(228),[G1tensor(462)])
  call ol_merge_tensors(T1sum(229),[G1tensor(389)])
  call ol_merge_tensors(T1sum(230),[G1tensor(480)])
  call ol_merge_tensors(T1sum(231),[G1tensor(393)])
  call ol_merge_tensors(T1sum(232),[G1tensor(448)])
  call ol_merge_tensors(T1sum(233),[G1tensor(425)])
  call ol_merge_tensors(T1sum(234),[G1tensor(429)])
  call ol_merge_tensors(T1sum(235),[G1tensor(472)])
  call ol_merge_tensors(T1sum(236),[G1tensor(441)])
  call ol_merge_tensors(T1sum(237),[G1tensor(459)])
  call ol_merge_tensors(T1sum(238),[G1tensor(471)])
  call ol_merge_tensors(T1sum(239),[G1tensor(483)])
  call ol_merge_tensors(T1sum(240),[G1tensor(489)])
  call ol_merge_tensors(T1sum(241),[G1tensor(513)])
  call ol_merge_tensors(T1sum(242),[G1tensor(525)])
  call ol_merge_tensors(T1sum(243),[G1tensor(531)])
  call ol_merge_tensors(T1sum(244),[G1tensor(570)])
  call ol_merge_tensors(T1sum(245),[G1tensor(539)])
  call ol_merge_tensors(T1sum(246),[G1tensor(594)])
  call ol_merge_tensors(T1sum(247),[G1tensor(567)])
  call ol_merge_tensors(T1sum(248),[G1tensor(579)])
  call ol_merge_tensors(T1sum(249),[G1tensor(575)])
  call ol_merge_tensors(T1sum(250),[G1tensor(591)])
  call ol_merge_tensors(T1sum(251),[G1tensor(603)])
  call ol_merge_tensors(T1sum(252),[G1tensor(658)])
  call ol_merge_tensors(T1sum(253),[G1tensor(652)])
  call ol_merge_tensors(T1sum(254),[G1tensor(635)])
  call ol_merge_tensors(T1sum(255),[G1tensor(641)])
  call ol_merge_tensors(T1sum(256),[G1tensor(688)])
  call ol_merge_tensors(T1sum(257),[G1tensor(681)])
  call ol_merge_tensors(T1sum(258),[G1tensor(707)])
  call ol_merge_tensors(T1sum(259),[G1tensor(719)])
  call ol_merge_tensors(T1sum(260),[G1tensor(756)])
  call ol_merge_tensors(T1sum(261),[G1tensor(735)])
  call ol_merge_tensors(T1sum(262),[G1tensor(786)])
  call ol_merge_tensors(T1sum(263),[G1tensor(741)])
  call ol_merge_tensors(T1sum(264),[G1tensor(777)])
  call ol_merge_tensors(T1sum(265),[G1tensor(793)])
  call ol_merge_tensors(T1sum(266),[G1tensor(799)])
  call ol_merge_tensors(T1sum(267),[G1tensor(805)])
  call ol_merge_tensors(T1sum(268),[G1tensor(811)])
  call ol_merge_tensors(T1sum(269),[G1tensor(817)])
  call ol_merge_tensors(T1sum(270),[G1tensor(823)])
  call ol_merge_tensors(T1sum(271),[G1tensor(829)])
  call ol_merge_tensors(T1sum(272),[G1tensor(835)])
  call ol_merge_tensors(T1sum(273),[G1tensor(841)])
  call ol_merge_tensors(T1sum(274),[G1tensor(847)])
  call ol_merge_tensors(T1sum(275),[G1tensor(853)])
  call ol_merge_tensors(T1sum(276),[G1tensor(859)])
  call ol_merge_tensors(T1sum(277),[G1tensor(865)])
  call ol_merge_tensors(T1sum(278),[G1tensor(871)])
  call ol_merge_tensors(T1sum(279),[G1tensor(877)])
  call ol_merge_tensors(T1sum(280),[G1tensor(883)])
  call ol_merge_tensors(T1sum(281),[G1tensor(889)])
  call ol_merge_tensors(T1sum(282),[G1tensor(895)])
  call ol_merge_tensors(T1sum(283),[G1tensor(901)])
  call ol_merge_tensors(T1sum(284),[G1tensor(907)])
  call ol_merge_tensors(T1sum(285),[G1tensor(913)])
  call ol_merge_tensors(T1sum(286),[G1tensor(919)])
  call ol_merge_tensors(T1sum(287),[G1tensor(925)])
  call ol_merge_tensors(T1sum(288),[G1tensor(931)])
  call ol_merge_tensors(T1sum(289),[G1tensor(937)])
  call ol_merge_tensors(T1sum(290),[G1tensor(943)])
  call ol_merge_tensors(T1sum(291),[G1tensor(949)])
  call ol_merge_tensors(T1sum(292),[G1tensor(955)])
  call ol_merge_tensors(T1sum(293),[G1tensor(961)])
  call ol_merge_tensors(T1sum(294),[G1tensor(967)])
  call ol_merge_tensors(T1sum(295),[G1tensor(973)])
  call ol_merge_tensors(T1sum(296),[G1tensor(979)])
  call ol_merge_tensors(T1sum(297),[G1tensor(985)])
  call ol_merge_tensors(T1sum(298),[G1tensor(991)])
  call ol_merge_tensors(T1sum(299),[G1tensor(997)])
  call ol_merge_tensors(T1sum(300),[G1tensor(1003)])
  call ol_merge_tensors(T1sum(301),[G1tensor(1009)])
  call ol_merge_tensors(T1sum(302),[G1tensor(1015)])
  call ol_merge_tensors(T1sum(303),[G1tensor(1021)])
  call ol_merge_tensors(T1sum(304),[G1tensor(1027)])
  call ol_merge_tensors(T1sum(305),[G1tensor(1033)])
  call ol_merge_tensors(T1sum(306),[G1tensor(1039)])
  call ol_merge_tensors(T1sum(307),[G1tensor(1045)])
  call ol_merge_tensors(T1sum(308),[G1tensor(1051)])
  call ol_merge_tensors(T1sum(309),[G1tensor(1057)])
  call ol_merge_tensors(T1sum(310),[G1tensor(1063)])
  call ol_merge_tensors(T1sum(311),[G1tensor(1069)])
  call ol_merge_tensors(T1sum(312),[G1tensor(1075)])
  call ol_merge_tensors(T1sum(313),[G1tensor(1081)])
  call ol_merge_tensors(T1sum(314),[G1tensor(1087)])
  call ol_merge_tensors(T1sum(315),[G1tensor(1093)])
  call ol_merge_tensors(T1sum(316),[G1tensor(1099)])
  call ol_merge_tensors(T1sum(317),[G1tensor(1105)])
  call ol_merge_tensors(T1sum(318),[G1tensor(1111)])
  call ol_merge_tensors(T1sum(319),[G1tensor(1117)])
  call ol_merge_tensors(T1sum(320),[G1tensor(1123)])
  call ol_merge_tensors(T1sum(321),[G1tensor(1129)])
  call ol_merge_tensors(T1sum(322),[G1tensor(1135)])
  call ol_merge_tensors(T1sum(323),[G1tensor(1141)])
  call ol_merge_tensors(T1sum(324),[G1tensor(1147)])
  call ol_merge_tensors(T1sum(325),[G1tensor(1153)])
  call ol_merge_tensors(T1sum(326),[G1tensor(1159)])
  call ol_merge_tensors(T1sum(327),[G1tensor(1165)])
  call ol_merge_tensors(T1sum(328),[G1tensor(1171)])
  call ol_merge_tensors(T1sum(329),[G1tensor(1177)])
  call ol_merge_tensors(T1sum(330),[G1tensor(1183)])
  call ol_merge_tensors(T1sum(331),[G1tensor(1189)])
  call ol_merge_tensors(T1sum(332),[G1tensor(1195)])
  call ol_merge_tensors(T1sum(333),[G1tensor(1201)])
  call ol_merge_tensors(T1sum(334),[G1tensor(1207)])
  call ol_merge_tensors(T1sum(335),[G1tensor(1213)])
  call ol_merge_tensors(T1sum(336),[G1tensor(1219)])
  call ol_merge_tensors(T1sum(337),[G1tensor(1225)])
  call ol_merge_tensors(T1sum(338),[G1tensor(1231)])
  call ol_merge_tensors(T1sum(339),[G1tensor(1237)])
  call ol_merge_tensors(T1sum(340),[G1tensor(1243)])
  call ol_merge_tensors(T1sum(341),[G1tensor(1249)])
  call ol_merge_tensors(T1sum(342),[G1tensor(1255)])
  call ol_merge_tensors(T1sum(343),[G1tensor(1261)])
  call ol_merge_tensors(T1sum(344),[G1tensor(1267)])
  call ol_merge_tensors(T1sum(345),[G1tensor(1273)])
  call ol_merge_tensors(T1sum(346),[G1tensor(1279)])
  call ol_merge_tensors(T1sum(347),[G1tensor(1285)])
  call ol_merge_tensors(T1sum(348),[G1tensor(1291)])
  call ol_merge_tensors(T1sum(349),[G1tensor(1297)])
  call ol_merge_tensors(T1sum(350),[G1tensor(1303)])
  call ol_merge_tensors(T1sum(351),[G1tensor(1309)])
  call ol_merge_tensors(T1sum(352),[G1tensor(1315)])
  call ol_merge_tensors(T1sum(353),[G1tensor(1321)])
  call ol_merge_tensors(T1sum(354),[G1tensor(1327)])
  call ol_merge_tensors(T1sum(355),[G1tensor(1333)])
  call ol_merge_tensors(T1sum(356),[G1tensor(1339)])
  call ol_merge_tensors(T1sum(357),[G1tensor(1345)])
  call ol_merge_tensors(T1sum(358),[G1tensor(1351)])
  call ol_merge_tensors(T1sum(359),[G1tensor(1357)])
  call ol_merge_tensors(T1sum(360),[G1tensor(1363)])
  call ol_merge_tensors(T1sum(361),[G1tensor(1369)])
  call ol_merge_tensors(T1sum(362),[G1tensor(1375)])
  call ol_merge_tensors(T1sum(363),[G1tensor(1381)])
  call ol_merge_tensors(T1sum(364),[G1tensor(1387)])
  call ol_merge_tensors(T1sum(365),[G1tensor(1393)])
  call ol_merge_tensors(T1sum(366),[G1tensor(1399)])
  call ol_merge_tensors(T1sum(367),[G1tensor(1405)])
  call ol_merge_tensors(T1sum(368),[G1tensor(1411)])
  call ol_merge_tensors(T1sum(369),[G1tensor(1417)])
  call ol_merge_tensors(T1sum(370),[G1tensor(1423)])
  call ol_merge_tensors(T1sum(371),[G1tensor(1429)])
  call ol_merge_tensors(T1sum(372),[G1tensor(1435)])
  call ol_merge_tensors(T1sum(373),[G1tensor(1441)])
  call ol_merge_tensors(T1sum(374),[G1tensor(1447)])
  call ol_merge_tensors(T1sum(375),[G1tensor(1453)])
  call ol_merge_tensors(T1sum(376),[G1tensor(1459)])
  call ol_merge_tensors(T1sum(377),[G1tensor(1465)])
  call ol_merge_tensors(T1sum(378),[G1tensor(1471)])
  call ol_merge_tensors(T1sum(379),[G1tensor(1477)])
  call ol_merge_tensors(T1sum(380),[G1tensor(1483)])
  call ol_merge_tensors(T1sum(381),[G1tensor(1489)])
  call ol_merge_tensors(T1sum(382),[G1tensor(1495)])
  call ol_merge_tensors(T1sum(383),[G1tensor(1501)])
  call ol_merge_tensors(T1sum(384),[G1tensor(1507)])
  call ol_merge_tensors(T1sum(385),[G1tensor(1513)])
  call ol_merge_tensors(T1sum(386),[G1tensor(1519)])
  call ol_merge_tensors(T1sum(387),[G1tensor(1525)])
  call ol_merge_tensors(T1sum(388),[G1tensor(1531)])
  call ol_merge_tensors(T1sum(389),[G1tensor(1537)])
  call ol_merge_tensors(T1sum(390),[G1tensor(1543)])
  call ol_merge_tensors(T1sum(391),[G1tensor(1549)])
  call ol_merge_tensors(T1sum(392),[G1tensor(1555)])
  call ol_merge_tensors(T1sum(393),[G1tensor(1561)])
  call ol_merge_tensors(T1sum(394),[G1tensor(1567)])
  call ol_merge_tensors(T1sum(395),[G1tensor(1573)])
  call ol_merge_tensors(T1sum(396),[G1tensor(1579)])
  call ol_merge_tensors(T1sum(397),[G1tensor(1585)])
  call ol_merge_tensors(T1sum(398),[G1tensor(1591)])
  call ol_merge_tensors(T1sum(399),[G1tensor(1597)])
  call ol_merge_tensors(T1sum(400),[G1tensor(1603)])
  call ol_merge_tensors(T1sum(401),[G1tensor(1609)])
  call ol_merge_tensors(T1sum(402),[G1tensor(1615)])
  call ol_merge_tensors(T1sum(403),[G1tensor(1621)])
  call ol_merge_tensors(T1sum(404),[G1tensor(1627)])
  call ol_merge_tensors(T1sum(405),[G1tensor(1633)])
  call ol_merge_tensors(T1sum(406),[G1tensor(1639)])
  call ol_merge_tensors(T1sum(407),[G1tensor(1645)])
  call ol_merge_tensors(T1sum(408),[G1tensor(1651)])
  call ol_merge_tensors(T1sum(409),[G1tensor(1657)])
  call ol_merge_tensors(T1sum(410),[G1tensor(1663)])
  call ol_merge_tensors(T1sum(411),[G1tensor(1669)])
  call ol_merge_tensors(T1sum(412),[G1tensor(1675)])
  call ol_merge_tensors(T1sum(413),[G1tensor(1681)])
  call ol_merge_tensors(T1sum(414),[G1tensor(1687)])
  call ol_merge_tensors(T1sum(415),[G1tensor(1693)])
  call ol_merge_tensors(T1sum(416),[G1tensor(1699)])
  call ol_merge_tensors(T1sum(417),[G1tensor(1705)])
  call ol_merge_tensors(T1sum(418),[G1tensor(1711)])
  call ol_merge_tensors(T1sum(419),[G1tensor(1717)])
  call ol_merge_tensors(T1sum(420),[G1tensor(1723)])
  call ol_merge_tensors(T1sum(421),[G1tensor(1729)])
  call ol_merge_tensors(T1sum(422),[G1tensor(1735)])
  call ol_merge_tensors(T1sum(423),[G1tensor(1741)])
  call ol_merge_tensors(T1sum(424),[G1tensor(1747)])
  call ol_merge_tensors(T1sum(425),[G1tensor(1753)])
  call ol_merge_tensors(T1sum(426),[G1tensor(1759)])
  call ol_merge_tensors(T1sum(427),[G1tensor(1765)])
  call ol_merge_tensors(T1sum(428),[G1tensor(1771)])
  call ol_merge_tensors(T1sum(429),[G1tensor(1777)])
  call ol_merge_tensors(T1sum(430),[G1tensor(1783)])
  call ol_merge_tensors(T1sum(431),[G1tensor(1789)])
  call ol_merge_tensors(T1sum(432),[G1tensor(1795)])
  call ol_merge_tensors(T1sum(433),[G1tensor(1801)])
  call ol_merge_tensors(T1sum(434),[G1tensor(1807)])
  call ol_merge_tensors(T1sum(435),[G1tensor(1813)])
  call ol_merge_tensors(T1sum(436),[G1tensor(1819)])
  call ol_merge_tensors(T1sum(437),[G1tensor(1825)])
  call ol_merge_tensors(T1sum(438),[G1tensor(1831)])
  call ol_merge_tensors(T1sum(439),[G1tensor(1837)])
  call ol_merge_tensors(T1sum(440),[G1tensor(1843)])
  call ol_merge_tensors(T1sum(441),[G1tensor(1849)])
  call ol_merge_tensors(T1sum(442),[G1tensor(1855)])
  call ol_merge_tensors(T1sum(443),[G1tensor(1861)])
  call ol_merge_tensors(T1sum(444),[G1tensor(1867)])
  call ol_merge_tensors(T1sum(445),[G1tensor(1873)])
  call ol_merge_tensors(T1sum(446),[G1tensor(1879)])
  call ol_merge_tensors(T1sum(447),[G1tensor(1885)])
  call ol_merge_tensors(T1sum(448),[G1tensor(1891)])
  call ol_merge_tensors(T1sum(449),[G1tensor(1897)])
  call ol_merge_tensors(T1sum(450),[G1tensor(1903)])
  call ol_merge_tensors(T1sum(451),[G1tensor(1909)])
  call ol_merge_tensors(T1sum(452),[G1tensor(1915)])
  call ol_merge_tensors(T1sum(453),[G1tensor(1921)])
  call ol_merge_tensors(T1sum(454),[G1tensor(1927)])
  call ol_merge_tensors(T1sum(455),[G1tensor(1933)])
  call ol_merge_tensors(T1sum(456),[G1tensor(1939)])
  call ol_merge_tensors(T1sum(457),[G1tensor(1945)])
  call ol_merge_tensors(T1sum(458),[G1tensor(1951)])
  call ol_merge_tensors(T1sum(459),[G1tensor(1957)])
  call ol_merge_tensors(T1sum(460),[G1tensor(1963)])
  call ol_merge_tensors(T1sum(461),[G1tensor(1969)])
  call ol_merge_tensors(T1sum(462),[G1tensor(1975)])
  call ol_merge_tensors(T1sum(463),[G1tensor(1981)])
  call ol_merge_tensors(T1sum(464),[G1tensor(1987)])
  call ol_merge_tensors(T1sum(465),[G1tensor(1993)])
  call ol_merge_tensors(T1sum(466),[G1tensor(1999)])
  call ol_merge_tensors(T1sum(467),[G1tensor(2005)])
  call ol_merge_tensors(T1sum(468),[G1tensor(2011)])
  call ol_merge_tensors(T1sum(469),[G1tensor(2017)])
  call ol_merge_tensors(T1sum(470),[G1tensor(2023)])
  call ol_merge_tensors(T1sum(471),[G1tensor(2029)])
  call ol_merge_tensors(T1sum(472),[G1tensor(2035)])
  call ol_merge_tensors(T1sum(473),[G1tensor(2041)])
  call ol_merge_tensors(T1sum(474),[G1tensor(2047)])
  call ol_merge_tensors(T1sum(475),[G1tensor(2053)])
  call ol_merge_tensors(T1sum(476),[G1tensor(2059)])
  call ol_merge_tensors(T1sum(477),[G1tensor(2065)])
  call ol_merge_tensors(T1sum(478),[G1tensor(2071)])
  call ol_merge_tensors(T1sum(479),[G1tensor(2077)])
  call ol_merge_tensors(T1sum(480),[G1tensor(2083)])
  call ol_merge_tensors(T1sum(481),[G1tensor(2089)])
  call ol_merge_tensors(T1sum(482),[G1tensor(2095)])
  call ol_merge_tensors(T1sum(483),[G1tensor(2101)])
  call ol_merge_tensors(T1sum(484),[G1tensor(2107)])
  call ol_merge_tensors(T1sum(485),[G1tensor(2113)])
  call ol_merge_tensors(T1sum(486),[G1tensor(2119)])
  call ol_merge_tensors(T1sum(487),[G1tensor(2125)])
  call ol_merge_tensors(T1sum(488),[G1tensor(2131)])
  call ol_merge_tensors(T1sum(489),[G1tensor(2137)])
  call ol_merge_tensors(T1sum(490),[G1tensor(2143)])
  call ol_merge_tensors(T1sum(491),[G1tensor(2149)])
  call ol_merge_tensors(T1sum(492),[G1tensor(2155)])
  call ol_merge_tensors(T1sum(493),[G1tensor(2161)])
  call ol_merge_tensors(T1sum(494),[G1tensor(2167)])
  call ol_merge_tensors(T1sum(495),[G1tensor(2173)])
  call ol_merge_tensors(T1sum(496),[G1tensor(2179)])
  call ol_merge_tensors(T1sum(497),[G1tensor(2185)])
  call ol_merge_tensors(T1sum(498),[G1tensor(2191)])
  call ol_merge_tensors(T1sum(499),[G1tensor(2197)])
  call ol_merge_tensors(T1sum(500),[G1tensor(2203)])
  call ol_merge_tensors(T1sum(501),[G1tensor(2209)])
  call ol_merge_tensors(T1sum(502),[G1tensor(2215)])
  call ol_merge_tensors(T1sum(503),[G1tensor(2221)])
  call ol_merge_tensors(T1sum(504),[G1tensor(2227)])
  call ol_merge_tensors(T1sum(505),[G1tensor(2233)])
  call ol_merge_tensors(T1sum(506),[G1tensor(2239)])
  call ol_merge_tensors(T1sum(507),[G1tensor(2245)])
  call ol_merge_tensors(T1sum(508),[G1tensor(2251)])
  call ol_merge_tensors(T1sum(509),[G1tensor(2257)])
  call ol_merge_tensors(T1sum(510),[G1tensor(2263)])
  call ol_merge_tensors(T1sum(511),[G1tensor(2269)])
  call ol_merge_tensors(T1sum(512),[G1tensor(2275)])
  call ol_merge_tensors(T1sum(513),[G1tensor(2281)])
  call ol_merge_tensors(T1sum(514),[G1tensor(2287)])
  call ol_merge_tensors(T1sum(515),[G1tensor(2293)])
  call ol_merge_tensors(T1sum(516),[G1tensor(2299)])
  call ol_merge_tensors(T1sum(517),[G1tensor(2305)])
  call ol_merge_tensors(T1sum(518),[G1tensor(2311)])
  call ol_merge_tensors(T1sum(519),[G1tensor(2317)])
  call ol_merge_tensors(T1sum(520),[G1tensor(2323)])
  call ol_merge_tensors(T1sum(521),[G1tensor(2329)])
  call ol_merge_tensors(T1sum(522),[G1tensor(2335)])
  call ol_merge_tensors(T1sum(523),[G1tensor(2341)])
  call ol_merge_tensors(T1sum(524),[G1tensor(2347)])
  call ol_merge_tensors(T1sum(525),[G1tensor(2353)])
  call ol_merge_tensors(T1sum(526),[G1tensor(2359)])
  call ol_merge_tensors(T1sum(527),[G1tensor(2365)])
  call ol_merge_tensors(T1sum(528),[G1tensor(2371)])
  call ol_merge_tensors(T1sum(529),[G1tensor(2377)])
  call ol_merge_tensors(T1sum(530),[G1tensor(2383)])
  call ol_merge_tensors(T1sum(531),[G1tensor(2389)])
  call ol_merge_tensors(T1sum(532),[G1tensor(2395)])
  call ol_merge_tensors(T1sum(533),[G1tensor(2401)])
  call ol_merge_tensors(T1sum(534),[G1tensor(2407)])
  call ol_merge_tensors(T1sum(535),[G1tensor(2413)])
  call ol_merge_tensors(T1sum(536),[G1tensor(2419)])
  call ol_merge_tensors(T1sum(537),[G1tensor(2425)])
  call ol_merge_tensors(T1sum(538),[G1tensor(2431)])
  call ol_merge_tensors(T1sum(539),[G1tensor(2437)])
  call ol_merge_tensors(T1sum(540),[G1tensor(2443)])
  call ol_merge_tensors(T1sum(541),[G1tensor(2449)])
  call ol_merge_tensors(T1sum(542),[G1tensor(2455)])
  call ol_merge_tensors(T1sum(543),[G1tensor(2461)])
  call ol_merge_tensors(T1sum(544),[G1tensor(2467)])
  call ol_merge_tensors(T1sum(545),[G1tensor(2473)])
  call ol_merge_tensors(T1sum(546),[G1tensor(2479)])
  call ol_merge_tensors(T1sum(547),[G1tensor(2485)])
  call ol_merge_tensors(T1sum(548),[G1tensor(2491)])
  call ol_merge_tensors(T1sum(549),[G1tensor(2497)])
  call ol_merge_tensors(T1sum(550),[G1tensor(2503)])
  call ol_merge_tensors(T1sum(551),[G1tensor(2509)])
  call ol_merge_tensors(T1sum(552),[G1tensor(2515)])
  call ol_merge_tensors(T1sum(553),[G1tensor(2521)])
  call ol_merge_tensors(T1sum(554),[G1tensor(2527)])
  call ol_merge_tensors(T1sum(555),[G1tensor(2533)])
  call ol_merge_tensors(T1sum(556),[G1tensor(2539)])
  call ol_merge_tensors(T1sum(557),[G1tensor(2545)])
  call ol_merge_tensors(T1sum(558),[G1tensor(2551)])
  call ol_merge_tensors(T1sum(559),[G1tensor(2557)])
  call ol_merge_tensors(T1sum(560),[G1tensor(2563)])
  call ol_merge_tensors(T1sum(561),[G1tensor(2569)])
  call ol_merge_tensors(T1sum(562),[G1tensor(2575)])
  call ol_merge_tensors(T1sum(563),[G1tensor(2581)])
  call ol_merge_tensors(T1sum(564),[G1tensor(2587)])
  call ol_merge_tensors(T1sum(565),[G1tensor(2593)])
  call ol_merge_tensors(T1sum(566),[G1tensor(2599)])
  call ol_merge_tensors(T1sum(567),[G1tensor(2605)])
  call ol_merge_tensors(T1sum(568),[G1tensor(2611)])
  call ol_merge_tensors(T1sum(569),[G1tensor(2617)])
  call ol_merge_tensors(T1sum(570),[G1tensor(2623)])
  call ol_merge_tensors(T1sum(571),[G1tensor(2629)])
  call ol_merge_tensors(T1sum(572),[G1tensor(2635)])
  call ol_merge_tensors(T1sum(573),[G1tensor(2641)])
  call ol_merge_tensors(T1sum(574),[G1tensor(2647)])
  call ol_merge_tensors(T1sum(575),[G1tensor(2653)])
  call ol_merge_tensors(T1sum(576),[G1tensor(2659)])
  call ol_merge_tensors(T1sum(577),[G1tensor(2665)])
  call ol_merge_tensors(T1sum(578),[G1tensor(2671)])
  call ol_merge_tensors(T1sum(579),[G1tensor(2677)])
  call ol_merge_tensors(T1sum(580),[G1tensor(2683)])
  call ol_merge_tensors(T1sum(581),[G1tensor(2689)])
  call ol_merge_tensors(T1sum(582),[G1tensor(2695)])
  call ol_merge_tensors(T1sum(583),[G1tensor(2701)])
  call ol_merge_tensors(T1sum(584),[G1tensor(2707)])
  call ol_merge_tensors(T1sum(585),[G1tensor(2713)])
  call ol_merge_tensors(T1sum(586),[G1tensor(2719)])
  call ol_merge_tensors(T1sum(587),[G1tensor(2725)])
  call ol_merge_tensors(T1sum(588),[G1tensor(2731)])
  call ol_merge_tensors(T1sum(589),[G1tensor(2737)])
  call ol_merge_tensors(T1sum(590),[G1tensor(2743)])
  call ol_merge_tensors(T1sum(591),[G1tensor(2749)])
  call ol_merge_tensors(T1sum(592),[G1tensor(2755)])
  call ol_merge_tensors(T1sum(593),[G1tensor(2761)])
  call ol_merge_tensors(T1sum(594),[G1tensor(2767)])
  call ol_merge_tensors(T1sum(595),[G1tensor(2773)])
  call ol_merge_tensors(T1sum(596),[G1tensor(2779)])
  call ol_merge_tensors(T1sum(597),[G1tensor(2785)])
  call ol_merge_tensors(T1sum(598),[G1tensor(2791)])
  call ol_merge_tensors(T1sum(599),[G1tensor(2797)])
  call ol_merge_tensors(T1sum(600),[G1tensor(2803)])
  call ol_merge_tensors(T1sum(601),[G1tensor(2809)])
  call ol_merge_tensors(T1sum(602),[G1tensor(2815)])
  call ol_merge_tensors(T1sum(603),[G1tensor(2821)])
  call ol_merge_tensors(T1sum(604),[G1tensor(2827)])
  call ol_merge_tensors(T1sum(605),[G1tensor(2833)])
  call ol_merge_tensors(T1sum(606),[G1tensor(2839)])
  call ol_merge_tensors(T1sum(607),[G1tensor(2845)])
  call ol_merge_tensors(T1sum(608),[G1tensor(2851)])
  call ol_merge_tensors(T1sum(609),[G1tensor(2857)])
  call ol_merge_tensors(T1sum(610),[G1tensor(2863)])
  call ol_merge_tensors(T1sum(611),[G1tensor(2869)])
  call ol_merge_tensors(T1sum(612),[G1tensor(2875)])
  call ol_merge_tensors(T1sum(613),[G1tensor(2881)])
  call ol_merge_tensors(T1sum(614),[G1tensor(2887)])
  call ol_merge_tensors(T1sum(615),[G1tensor(2893)])
  call ol_merge_tensors(T1sum(616),[G1tensor(2899)])
  call ol_merge_tensors(T1sum(617),[G1tensor(2905)])
  call ol_merge_tensors(T1sum(618),[G1tensor(2911)])
  call ol_merge_tensors(T1sum(619),[G1tensor(2917)])
  call ol_merge_tensors(T1sum(620),[G1tensor(2923)])
  Gcoeff(:)%j = (c(106)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(433),h0tab(:,433),[32,10,5,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,5),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngH,m3h2x32(:,337),heltab2x64(:,:,433))
  call Hloop_A_Q(ntryL,G0H32(9),32,nMB,G1H32(1),n2h32(17))
  Gcoeff(:)%j = (-(c(106)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(434),h0tab(:,434),[32,10,5,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,5),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),ngX,m3h2x32(:,338),heltab2x64(:,:,434))
  call Hloop_A_Q(ntryL,G0H32(10),32,nMB,G1H32(2),n2h32(18))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(435),h0tab(:,435),[32,10,5,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,5),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),ngPbt,m3h2x32(:,339),heltab2x64(:,:,435))
  call Hloop_A_Q(ntryL,G0H32(11),32,nMT,G1H32(3),n2h32(19))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(436),h0tab(:,436),[32,10,5,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,2),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(12),ngH,m3h2x32(:,340),heltab2x64(:,:,436))
  call Hloop_A_Q(ntryL,G0H32(12),32,nMB,G1H32(4),n2h32(20))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(437),h0tab(:,437),[32,10,5,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,2),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(13),ngX,m3h2x32(:,341),heltab2x64(:,:,437))
  call Hloop_A_Q(ntryL,G0H32(13),32,nMB,G1H32(5),n2h32(21))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(438),h0tab(:,438),[32,10,5,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,2),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),ngPbt,m3h2x32(:,342),heltab2x64(:,:,438))
  call Hloop_A_Q(ntryL,G0H32(14),32,nMT,G1H32(6),n2h32(22))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(439),h0tab(:,439),[32,10,5,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,5),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),ngH,m3h2x32(:,343),heltab2x64(:,:,439))
  call Hloop_A_Q(ntryL,G0H32(15),32,nMB,G1H32(7),n2h32(23))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(440),h0tab(:,440),[32,10,5,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,5),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(16),ngX,m3h2x32(:,344),heltab2x64(:,:,440))
  call Hloop_A_Q(ntryL,G0H32(16),32,nMB,G1H32(8),n2h32(24))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(441),h0tab(:,441),[32,10,5,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngPbt,m3h2x32(:,345),heltab2x64(:,:,441))
  call Hloop_A_Q(ntryL,G0H32(17),32,nMT,G1H32(9),n2h32(25))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(442),h0tab(:,442),[32,10,5,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,2),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(18),ngH,m3h2x32(:,346),heltab2x64(:,:,442))
  call Hloop_A_Q(ntryL,G0H32(18),32,nMB,G1H32(10),n2h32(26))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(443),h0tab(:,443),[32,10,5,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,2),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(19),ngX,m3h2x32(:,347),heltab2x64(:,:,443))
  call Hloop_A_Q(ntryL,G0H32(19),32,nMB,G1H32(11),n2h32(27))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(444),h0tab(:,444),[32,10,5,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,2),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),ngPbt,m3h2x32(:,348),heltab2x64(:,:,444))
  call Hloop_A_Q(ntryL,G0H32(20),32,nMT,G1H32(12),n2h32(28))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(445),h0tab(:,445),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(21),ngPbt,m3h2x32(:,349),heltab2x64(:,:,445))
  Gcoeff(:)%j = (-(c(156)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(446),h0tab(:,446),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(22),ngPbt,m3h2x32(:,350),heltab2x64(:,:,446))
  Gcoeff(:)%j = (-(c(156)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(447),h0tab(:,447),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(23),ngPbt,m3h2x32(:,351),heltab2x64(:,:,447))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(448),h0tab(:,448),[32,10,5,16],[nMH,nMZ,nMH,nMB],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(24),ngH,m3h2x32(:,352),heltab2x64(:,:,448))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(449),h0tab(:,449),[32,10,5,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(25),ngX,m3h2x32(:,353),heltab2x64(:,:,449))
  Gcoeff(:)%j = (c(145)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(450),h0tab(:,450),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(26),ngPbt,m3h2x32(:,354),heltab2x64(:,:,450))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(451),h0tab(:,451),[32,10,5,16],[nMB,nMB,nMB,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,355),heltab2x64(:,:,451))
  call Hloop_A_Q(ntryL,G0H32(27),32,nMB,G1H32(13),n2h32(29))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(452),h0tab(:,452),[32,10,5,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,5),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(28),ngZd,m3h2x32(:,356),heltab2x64(:,:,452))
  call Hloop_A_Q(ntryL,G0H32(28),32,nMB,G1H32(14),n2h32(30))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(453),h0tab(:,453),[32,10,5,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,5),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,357),heltab2x64(:,:,453))
  call Hloop_A_Q(ntryL,G0H32(29),32,nMT,G1H32(15),n2h32(31))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(454),h0tab(:,454),[32,10,5,16],[nMB,nMB,nMB,0],4,2,wf4(:,2),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,358),heltab2x64(:,:,454))
  call Hloop_A_Q(ntryL,G0H32(30),32,nMB,G1H32(16),n2h32(32))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(455),h0tab(:,455),[32,10,5,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,2),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(31),ngZd,m3h2x32(:,359),heltab2x64(:,:,455))
  call Hloop_A_Q(ntryL,G0H32(31),32,nMB,G1H32(17),n2h32(33))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(456),h0tab(:,456),[32,10,5,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,2),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,360),heltab2x64(:,:,456))
  call Hloop_A_Q(ntryL,G0H32(32),32,nMT,G1H32(18),n2h32(34))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(457),h0tab(:,457),[32,10,5,16],[nMB,nMB,nMB,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,361),heltab2x64(:,:,457))
  call Hloop_A_Q(ntryL,G0H32(33),32,nMB,G1H32(19),n2h32(35))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(458),h0tab(:,458),[32,10,5,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,5),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(34),ngZd,m3h2x32(:,362),heltab2x64(:,:,458))
  call Hloop_A_Q(ntryL,G0H32(34),32,nMB,G1H32(20),n2h32(36))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(459),h0tab(:,459),[32,10,5,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,5),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,363),heltab2x64(:,:,459))
  call Hloop_A_Q(ntryL,G0H32(35),32,nMT,G1H32(21),n2h32(37))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(460),h0tab(:,460),[32,10,5,16],[nMB,nMB,nMB,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,364),heltab2x64(:,:,460))
  call Hloop_A_Q(ntryL,G0H32(36),32,nMB,G1H32(22),n2h32(38))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(461),h0tab(:,461),[32,10,5,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,2),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(37),ngZd,m3h2x32(:,365),heltab2x64(:,:,461))
  call Hloop_A_Q(ntryL,G0H32(37),32,nMB,G1H32(23),n2h32(39))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(462),h0tab(:,462),[32,10,5,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,2),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,366),heltab2x64(:,:,462))
  call Hloop_A_Q(ntryL,G0H32(38),32,nMT,G1H32(24),n2h32(40))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(463),h0tab(:,463),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(39),ngPbt,m3h2x32(:,367),heltab2x64(:,:,463))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(464),h0tab(:,464),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(40),ngPbt,m3h2x32(:,368),heltab2x64(:,:,464))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(465),h0tab(:,465),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(41),ngPbt,m3h2x32(:,369),heltab2x64(:,:,465))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(466),h0tab(:,466),[32,10,5,16],[nMH,nMZ,nMH,nMB],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(42),ngH,m3h2x32(:,370),heltab2x64(:,:,466))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(467),h0tab(:,467),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(43),ngPbt,m3h2x32(:,371),heltab2x64(:,:,467))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(468),h0tab(:,468),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,372),heltab2x64(:,:,468))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(469),h0tab(:,469),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,373),heltab2x64(:,:,469))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(470),h0tab(:,470),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,374),heltab2x64(:,:,470))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(471),h0tab(:,471),[32,10,5,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(47),ngZd,m3h2x32(:,375),heltab2x64(:,:,471))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(472),h0tab(:,472),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,376),heltab2x64(:,:,472))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(473),h0tab(:,473),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(49),ngPbt,m3h2x32(:,377),heltab2x64(:,:,473))
  Gcoeff(:)%j = (c(150)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(474),h0tab(:,474),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(50),ngPbt,m3h2x32(:,378),heltab2x64(:,:,474))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(475),h0tab(:,475),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(51),ngPbt,m3h2x32(:,379),heltab2x64(:,:,475))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(476),h0tab(:,476),[32,10,5,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(60),ngX,m3h2x32(:,380),heltab2x64(:,:,476))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(477),h0tab(:,477),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(61),ngPbt,m3h2x32(:,381),heltab2x64(:,:,477))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(478),h0tab(:,478),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(62),m3h2x32(:,382),heltab2x64(:,:,478))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(479),h0tab(:,479),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(63),m3h2x32(:,383),heltab2x64(:,:,479))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(480),h0tab(:,480),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(64),m3h2x32(:,384),heltab2x64(:,:,480))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(481),h0tab(:,481),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,385),heltab2x64(:,:,481))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(482),h0tab(:,482),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(66),ngPbt,m3h2x32(:,386),heltab2x64(:,:,482))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(483),h0tab(:,483),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(67),ngPbt,m3h2x32(:,387),heltab2x64(:,:,483))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(484),h0tab(:,484),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(68),ngPbt,m3h2x32(:,388),heltab2x64(:,:,484))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(485),h0tab(:,485),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(69),ngPbt,m3h2x32(:,389),heltab2x64(:,:,485))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(486),h0tab(:,486),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(70),m3h2x32(:,390),heltab2x64(:,:,486))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(487),h0tab(:,487),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(71),m3h2x32(:,391),heltab2x64(:,:,487))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(488),h0tab(:,488),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(72),m3h2x32(:,392),heltab2x64(:,:,488))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(489),h0tab(:,489),[32,10,5,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(73),ngZd,m3h2x32(:,393),heltab2x64(:,:,489))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(490),h0tab(:,490),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(74),m3h2x32(:,394),heltab2x64(:,:,490))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(491),h0tab(:,491),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(75),m3h2x32(:,395),heltab2x64(:,:,491))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(492),h0tab(:,492),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(76),m3h2x32(:,396),heltab2x64(:,:,492))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(493),h0tab(:,493),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,397),heltab2x64(:,:,493))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(494),h0tab(:,494),[32,10,5,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(78),m3h2x32(:,398),heltab2x64(:,:,494))
  Gcoeff(:)%j = (c(106)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(495),h0tab(:,495),[32,5,10,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,4),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(79),ngH,m3h2x32(:,399),heltab2x64(:,:,495))
  call Hloop_A_Q(ntryL,G0H32(79),32,nMB,G1H32(25),n2h32(41))
  Gcoeff(:)%j = (-(c(106)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(496),h0tab(:,496),[32,5,10,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,4),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(80),ngX,m3h2x32(:,400),heltab2x64(:,:,496))
  call Hloop_A_Q(ntryL,G0H32(80),32,nMB,G1H32(26),n2h32(42))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(497),h0tab(:,497),[32,5,10,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,4),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(81),ngPbt,m3h2x32(:,401),heltab2x64(:,:,497))
  call Hloop_A_Q(ntryL,G0H32(81),32,nMT,G1H32(27),n2h32(43))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(498),h0tab(:,498),[32,5,10,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,4),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(82),ngH,m3h2x32(:,402),heltab2x64(:,:,498))
  call Hloop_A_Q(ntryL,G0H32(82),32,nMB,G1H32(28),n2h32(44))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(499),h0tab(:,499),[32,5,10,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,4),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(83),ngX,m3h2x32(:,403),heltab2x64(:,:,499))
  call Hloop_A_Q(ntryL,G0H32(83),32,nMB,G1H32(29),n2h32(45))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(500),h0tab(:,500),[32,5,10,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,4),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(84),ngPbt,m3h2x32(:,404),heltab2x64(:,:,500))
  call Hloop_A_Q(ntryL,G0H32(84),32,nMT,G1H32(30),n2h32(46))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(501),h0tab(:,501),[32,5,10,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,1),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(85),ngH,m3h2x32(:,405),heltab2x64(:,:,501))
  call Hloop_A_Q(ntryL,G0H32(85),32,nMB,G1H32(31),n2h32(47))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(502),h0tab(:,502),[32,5,10,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,1),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(86),ngX,m3h2x32(:,406),heltab2x64(:,:,502))
  call Hloop_A_Q(ntryL,G0H32(86),32,nMB,G1H32(32),n2h32(48))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(503),h0tab(:,503),[32,5,10,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,1),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(87),ngPbt,m3h2x32(:,407),heltab2x64(:,:,503))
  call Hloop_A_Q(ntryL,G0H32(87),32,nMT,G1H32(33),n2h32(49))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(504),h0tab(:,504),[32,5,10,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,1),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(88),ngH,m3h2x32(:,408),heltab2x64(:,:,504))
  call Hloop_A_Q(ntryL,G0H32(88),32,nMB,G1H32(34),n2h32(50))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(505),h0tab(:,505),[32,5,10,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,1),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(89),ngX,m3h2x32(:,409),heltab2x64(:,:,505))
  call Hloop_A_Q(ntryL,G0H32(89),32,nMB,G1H32(35),n2h32(51))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(506),h0tab(:,506),[32,5,10,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(90),ngPbt,m3h2x32(:,410),heltab2x64(:,:,506))
  call Hloop_A_Q(ntryL,G0H32(90),32,nMT,G1H32(36),n2h32(52))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(507),h0tab(:,507),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(91),ngPbt,m3h2x32(:,411),heltab2x64(:,:,507))
  Gcoeff(:)%j = (-(c(156)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(508),h0tab(:,508),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(92),ngPbt,m3h2x32(:,412),heltab2x64(:,:,508))
  Gcoeff(:)%j = (-(c(156)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(509),h0tab(:,509),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(93),ngPbt,m3h2x32(:,413),heltab2x64(:,:,509))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(510),h0tab(:,510),[32,5,10,16],[nMH,nMZ,nMH,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(94),ngH,m3h2x32(:,414),heltab2x64(:,:,510))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(511),h0tab(:,511),[32,5,10,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(95),ngX,m3h2x32(:,415),heltab2x64(:,:,511))
  Gcoeff(:)%j = (c(145)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(512),h0tab(:,512),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(96),ngPbt,m3h2x32(:,416),heltab2x64(:,:,512))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(513),h0tab(:,513),[32,5,10,16],[nMB,nMB,nMB,0],4,2,wf4(:,4),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(97),m3h2x32(:,417),heltab2x64(:,:,513))
  call Hloop_A_Q(ntryL,G0H32(97),32,nMB,G1H32(37),n2h32(53))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(514),h0tab(:,514),[32,5,10,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,4),wf4(:,5))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(98),ngZd,m3h2x32(:,418),heltab2x64(:,:,514))
  call Hloop_A_Q(ntryL,G0H32(98),32,nMB,G1H32(38),n2h32(54))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(515),h0tab(:,515),[32,5,10,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,4),wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(99),m3h2x32(:,419),heltab2x64(:,:,515))
  call Hloop_A_Q(ntryL,G0H32(99),32,nMT,G1H32(39),n2h32(55))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(516),h0tab(:,516),[32,5,10,16],[nMB,nMB,nMB,0],4,2,wf4(:,4),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(100),m3h2x32(:,420),heltab2x64(:,:,516))
  call Hloop_A_Q(ntryL,G0H32(100),32,nMB,G1H32(40),n2h32(56))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(517),h0tab(:,517),[32,5,10,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,4),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(101),ngZd,m3h2x32(:,421),heltab2x64(:,:,517))
  call Hloop_A_Q(ntryL,G0H32(101),32,nMB,G1H32(41),n2h32(57))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(518),h0tab(:,518),[32,5,10,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,4),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(102),m3h2x32(:,422),heltab2x64(:,:,518))
  call Hloop_A_Q(ntryL,G0H32(102),32,nMT,G1H32(42),n2h32(58))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(519),h0tab(:,519),[32,5,10,16],[nMB,nMB,nMB,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,423),heltab2x64(:,:,519))
  call Hloop_A_Q(ntryL,G0H32(103),32,nMB,G1H32(43),n2h32(59))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(520),h0tab(:,520),[32,5,10,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,1),wf4(:,5))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(104),ngZd,m3h2x32(:,424),heltab2x64(:,:,520))
  call Hloop_A_Q(ntryL,G0H32(104),32,nMB,G1H32(44),n2h32(60))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(521),h0tab(:,521),[32,5,10,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,1),wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(105),m3h2x32(:,425),heltab2x64(:,:,521))
  call Hloop_A_Q(ntryL,G0H32(105),32,nMT,G1H32(45),n2h32(61))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(522),h0tab(:,522),[32,5,10,16],[nMB,nMB,nMB,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(106),m3h2x32(:,426),heltab2x64(:,:,522))
  call Hloop_A_Q(ntryL,G0H32(106),32,nMB,G1H32(46),n2h32(62))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(523),h0tab(:,523),[32,5,10,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,1),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(107),ngZd,m3h2x32(:,427),heltab2x64(:,:,523))
  call Hloop_A_Q(ntryL,G0H32(107),32,nMB,G1H32(47),n2h32(63))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(524),h0tab(:,524),[32,5,10,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(108),m3h2x32(:,428),heltab2x64(:,:,524))
  call Hloop_A_Q(ntryL,G0H32(108),32,nMT,G1H32(48),n2h32(64))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(525),h0tab(:,525),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(109),ngPbt,m3h2x32(:,429),heltab2x64(:,:,525))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(526),h0tab(:,526),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(110),ngPbt,m3h2x32(:,430),heltab2x64(:,:,526))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(527),h0tab(:,527),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(111),ngPbt,m3h2x32(:,431),heltab2x64(:,:,527))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(528),h0tab(:,528),[32,5,10,16],[nMH,nMZ,nMH,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(112),ngH,m3h2x32(:,432),heltab2x64(:,:,528))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(529),h0tab(:,529),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(113),ngPbt,m3h2x32(:,433),heltab2x64(:,:,529))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(530),h0tab(:,530),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(114),m3h2x32(:,434),heltab2x64(:,:,530))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(531),h0tab(:,531),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,435),heltab2x64(:,:,531))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(532),h0tab(:,532),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(116),m3h2x32(:,436),heltab2x64(:,:,532))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(533),h0tab(:,533),[32,5,10,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(117),ngZd,m3h2x32(:,437),heltab2x64(:,:,533))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(534),h0tab(:,534),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(118),m3h2x32(:,438),heltab2x64(:,:,534))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(535),h0tab(:,535),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(119),ngPbt,m3h2x32(:,439),heltab2x64(:,:,535))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(536),h0tab(:,536),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(120),ngPbt,m3h2x32(:,440),heltab2x64(:,:,536))
  Gcoeff(:)%j = (c(150)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(537),h0tab(:,537),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(121),ngPbt,m3h2x32(:,441),heltab2x64(:,:,537))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(538),h0tab(:,538),[32,5,10,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(122),ngX,m3h2x32(:,442),heltab2x64(:,:,538))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(539),h0tab(:,539),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(123),ngPbt,m3h2x32(:,443),heltab2x64(:,:,539))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(540),h0tab(:,540),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(124),m3h2x32(:,444),heltab2x64(:,:,540))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(541),h0tab(:,541),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(125),m3h2x32(:,445),heltab2x64(:,:,541))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(542),h0tab(:,542),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(126),m3h2x32(:,446),heltab2x64(:,:,542))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(543),h0tab(:,543),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(127),m3h2x32(:,447),heltab2x64(:,:,543))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(544),h0tab(:,544),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(128),ngPbt,m3h2x32(:,448),heltab2x64(:,:,544))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(545),h0tab(:,545),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(129),ngPbt,m3h2x32(:,449),heltab2x64(:,:,545))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(546),h0tab(:,546),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(130),ngPbt,m3h2x32(:,450),heltab2x64(:,:,546))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(547),h0tab(:,547),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(131),ngPbt,m3h2x32(:,451),heltab2x64(:,:,547))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(548),h0tab(:,548),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(132),m3h2x32(:,452),heltab2x64(:,:,548))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(549),h0tab(:,549),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,453),heltab2x64(:,:,549))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(550),h0tab(:,550),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,454),heltab2x64(:,:,550))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(551),h0tab(:,551),[32,5,10,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,455),heltab2x64(:,:,551))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(552),h0tab(:,552),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,456),heltab2x64(:,:,552))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(553),h0tab(:,553),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,457),heltab2x64(:,:,553))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(554),h0tab(:,554),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,458),heltab2x64(:,:,554))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(555),h0tab(:,555),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,459),heltab2x64(:,:,555))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(556),h0tab(:,556),[32,5,10,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,460),heltab2x64(:,:,556))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(557),h0tab(:,557),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,4),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(52),ngPbt,m3h2x32(:,461),heltab2x64(:,:,557))
  call Hloop_A_Q(ntryL,G0H32(52),32,nMT,G1H32(49),n2h32(65))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(558),h0tab(:,558),[32,5,16,10],[nMB,nMB,nMH,nMZ],4,2,wf4(:,4),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(53),ngX,m3h2x32(:,462),heltab2x64(:,:,558))
  call Hloop_A_Q(ntryL,G0H32(53),32,nMB,G1H32(50),n2h32(66))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(559),h0tab(:,559),[32,5,16,10],[nMB,nMB,nMZ,nMH],4,2,wf4(:,4),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(54),ngH,m3h2x32(:,463),heltab2x64(:,:,559))
  call Hloop_A_Q(ntryL,G0H32(54),32,nMB,G1H32(51),n2h32(67))
  Gcoeff(:)%j = (-(c(155)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(560),h0tab(:,560),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,4),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(55),ngPbt,m3h2x32(:,464),heltab2x64(:,:,560))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(52),n2h32(68))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(561),h0tab(:,561),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,1),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(56),ngPbt,m3h2x32(:,465),heltab2x64(:,:,561))
  call Hloop_A_Q(ntryL,G0H32(56),32,nMT,G1H32(53),n2h32(69))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(562),h0tab(:,562),[32,5,16,10],[nMB,nMB,nMH,nMZ],4,2,wf4(:,1),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(57),ngX,m3h2x32(:,466),heltab2x64(:,:,562))
  call Hloop_A_Q(ntryL,G0H32(57),32,nMB,G1H32(54),n2h32(70))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(563),h0tab(:,563),[32,5,16,10],[nMB,nMB,nMZ,nMH],4,2,wf4(:,1),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(58),ngH,m3h2x32(:,467),heltab2x64(:,:,563))
  call Hloop_A_Q(ntryL,G0H32(58),32,nMB,G1H32(55),n2h32(71))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(564),h0tab(:,564),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(59),ngPbt,m3h2x32(:,468),heltab2x64(:,:,564))
  call Hloop_A_Q(ntryL,G0H32(59),32,nMT,G1H32(56),n2h32(72))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(565),h0tab(:,565),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(133),ngPbt,m3h2x32(:,469),heltab2x64(:,:,565))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(566),h0tab(:,566),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(134),ngPbt,m3h2x32(:,470),heltab2x64(:,:,566))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(567),h0tab(:,567),[32,5,16,10],[nMZ,nMH,nMB,nMB],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(135),ngX,m3h2x32(:,471),heltab2x64(:,:,567))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(568),h0tab(:,568),[32,5,16,10],[nMH,nMZ,nMB,nMB],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(136),ngH,m3h2x32(:,472),heltab2x64(:,:,568))
  Gcoeff(:)%j = (-(c(155)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(569),h0tab(:,569),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(137),ngPbt,m3h2x32(:,473),heltab2x64(:,:,569))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(570),h0tab(:,570),[32,5,16,10],[nMZ,nMH,nMB,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(138),ngX,m3h2x32(:,474),heltab2x64(:,:,570))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(571),h0tab(:,571),[32,5,16,10],[nMH,nMZ,nMB,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(139),ngH,m3h2x32(:,475),heltab2x64(:,:,571))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(572),h0tab(:,572),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(140),ngPbt,m3h2x32(:,476),heltab2x64(:,:,572))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(573),h0tab(:,573),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,4),wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(141),m3h2x32(:,477),heltab2x64(:,:,573))
  call Hloop_A_Q(ntryL,G0H32(141),32,nMT,G1H32(57),n2h32(73))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(574),h0tab(:,574),[32,5,16,10],[nMB,nMB,nMH,nMZ],4,2,wf4(:,4),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(142),ngZd,m3h2x32(:,478),heltab2x64(:,:,574))
  call Hloop_A_Q(ntryL,G0H32(142),32,nMB,G1H32(58),n2h32(74))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(575),h0tab(:,575),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,4),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(143),m3h2x32(:,479),heltab2x64(:,:,575))
  call Hloop_A_Q(ntryL,G0H32(143),32,nMT,G1H32(59),n2h32(75))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(576),h0tab(:,576),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,1),wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(144),m3h2x32(:,480),heltab2x64(:,:,576))
  call Hloop_A_Q(ntryL,G0H32(144),32,nMT,G1H32(60),n2h32(76))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(577),h0tab(:,577),[32,5,16,10],[nMB,nMB,nMH,nMZ],4,2,wf4(:,1),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(145),ngZd,m3h2x32(:,481),heltab2x64(:,:,577))
  call Hloop_A_Q(ntryL,G0H32(145),32,nMB,G1H32(61),n2h32(77))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(578),h0tab(:,578),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(146),m3h2x32(:,482),heltab2x64(:,:,578))
  call Hloop_A_Q(ntryL,G0H32(146),32,nMT,G1H32(62),n2h32(78))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(579),h0tab(:,579),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,4),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(147),ngPbt,m3h2x32(:,483),heltab2x64(:,:,579))
  call Hloop_A_Q(ntryL,G0H32(147),32,nMT,G1H32(63),n2h32(79))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(580),h0tab(:,580),[32,5,16,10],[nMB,nMB,nMZ,nMH],4,2,wf4(:,4),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(148),ngH,m3h2x32(:,484),heltab2x64(:,:,580))
  call Hloop_A_Q(ntryL,G0H32(148),32,nMB,G1H32(64),n2h32(80))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(581),h0tab(:,581),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,4),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(149),ngPbt,m3h2x32(:,485),heltab2x64(:,:,581))
  call Hloop_A_Q(ntryL,G0H32(149),32,nMT,G1H32(65),n2h32(81))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(582),h0tab(:,582),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,1),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(150),ngPbt,m3h2x32(:,486),heltab2x64(:,:,582))
  call Hloop_A_Q(ntryL,G0H32(150),32,nMT,G1H32(66),n2h32(82))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(583),h0tab(:,583),[32,5,16,10],[nMB,nMB,nMZ,nMH],4,2,wf4(:,1),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(151),ngH,m3h2x32(:,487),heltab2x64(:,:,583))
  call Hloop_A_Q(ntryL,G0H32(151),32,nMB,G1H32(67),n2h32(83))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(584),h0tab(:,584),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(152),ngPbt,m3h2x32(:,488),heltab2x64(:,:,584))
  call Hloop_A_Q(ntryL,G0H32(152),32,nMT,G1H32(68),n2h32(84))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(585),h0tab(:,585),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(153),m3h2x32(:,489),heltab2x64(:,:,585))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(586),h0tab(:,586),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(154),m3h2x32(:,490),heltab2x64(:,:,586))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(587),h0tab(:,587),[32,5,16,10],[nMZ,nMH,nMB,nMB],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(155),ngZd,m3h2x32(:,491),heltab2x64(:,:,587))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(588),h0tab(:,588),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(156),m3h2x32(:,492),heltab2x64(:,:,588))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(589),h0tab(:,589),[32,5,16,10],[nMZ,nMH,nMB,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(157),ngZd,m3h2x32(:,493),heltab2x64(:,:,589))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(590),h0tab(:,590),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(158),m3h2x32(:,494),heltab2x64(:,:,590))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(591),h0tab(:,591),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(159),ngPbt,m3h2x32(:,495),heltab2x64(:,:,591))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(592),h0tab(:,592),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(160),ngPbt,m3h2x32(:,496),heltab2x64(:,:,592))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(593),h0tab(:,593),[32,5,16,10],[nMH,nMZ,nMB,nMB],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(161),ngH,m3h2x32(:,497),heltab2x64(:,:,593))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(594),h0tab(:,594),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(162),ngPbt,m3h2x32(:,498),heltab2x64(:,:,594))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(595),h0tab(:,595),[32,5,16,10],[nMH,nMZ,nMB,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(163),ngH,m3h2x32(:,499),heltab2x64(:,:,595))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(596),h0tab(:,596),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(164),ngPbt,m3h2x32(:,500),heltab2x64(:,:,596))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(597),h0tab(:,597),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,4),wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(165),m3h2x32(:,501),heltab2x64(:,:,597))
  call Hloop_A_Q(ntryL,G0H32(165),32,nMT,G1H32(69),n2h32(85))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(598),h0tab(:,598),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,4),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(166),m3h2x32(:,502),heltab2x64(:,:,598))
  call Hloop_A_Q(ntryL,G0H32(166),32,nMT,G1H32(70),n2h32(86))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(599),h0tab(:,599),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,1),wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(167),m3h2x32(:,503),heltab2x64(:,:,599))
  call Hloop_A_Q(ntryL,G0H32(167),32,nMT,G1H32(71),n2h32(87))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(600),h0tab(:,600),[32,5,16,10],[nMT,nMT,nMW,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(168),m3h2x32(:,504),heltab2x64(:,:,600))
  call Hloop_A_Q(ntryL,G0H32(168),32,nMT,G1H32(72),n2h32(88))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(601),h0tab(:,601),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(169),m3h2x32(:,505),heltab2x64(:,:,601))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(602),h0tab(:,602),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(170),m3h2x32(:,506),heltab2x64(:,:,602))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(603),h0tab(:,603),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(171),m3h2x32(:,507),heltab2x64(:,:,603))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(604),h0tab(:,604),[32,5,16,10],[nMW,nMW,nMT,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(172),m3h2x32(:,508),heltab2x64(:,:,604))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(570)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(605),h0tab(:,605),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(5),m3h4x16(:,97),heltab2x64(:,:,605))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(606),h0tab(:,606),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,36),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(6),m3h4x16(:,98),heltab2x64(:,:,606))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(607),h0tab(:,607),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(7),m3h4x16(:,99),heltab2x64(:,:,607))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(608),h0tab(:,608),[48,5,2,8],[nMH,nMZ,0,nMZ],4,2,wf4(:,36),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(8),m3h4x16(:,100),heltab2x64(:,:,608))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(609),h0tab(:,609),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,36),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(13),m3h4x16(:,101),heltab2x64(:,:,609))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(570)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(610),h0tab(:,610),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(7),m3h4x16(:,102),heltab2x64(:,:,610))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(611),h0tab(:,611),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(10),m3h4x16(:,103),heltab2x64(:,:,611))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(612),h0tab(:,612),[48,5,2,8],[0,0,0,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(13),m3h4x16(:,104),heltab2x64(:,:,612))
  call Hloop_A_Q(ntryL,G0H16(13),48,0,G1H16(14),n2h16(357))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(613),h0tab(:,613),[48,5,2,8],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(18),m3h4x16(:,105),heltab2x64(:,:,613))
  call Hloop_A_Q(ntryL,G0H16(18),48,0,G1H16(15),n2h16(358))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(614),h0tab(:,614),[48,5,2,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(1),ngZl,m3h4x16(:,106),heltab2x64(:,:,614))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(16),n2h16(359))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(615),h0tab(:,615),[48,5,2,8],[0,0,nMZ,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(2),ngZl,m3h4x16(:,107),heltab2x64(:,:,615))
  call Hloop_A_Q(ntryL,G0H16(2),48,0,G1H16(21),n2h16(360))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(616),h0tab(:,616),[48,5,2,8],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(3),m3h4x16(:,108),heltab2x64(:,:,616))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(22),n2h16(361))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(617),h0tab(:,617),[48,5,2,8],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(4),m3h4x16(:,109),heltab2x64(:,:,617))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(23),n2h16(362))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(618),h0tab(:,618),[48,5,2,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZl,m3h4x16(:,110),heltab2x64(:,:,618))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(24),n2h16(363))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(619),h0tab(:,619),[48,5,2,8],[0,0,nMZ,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(6),ngZl,m3h4x16(:,111),heltab2x64(:,:,619))
  call Hloop_A_Q(ntryL,G0H16(6),48,0,G1H16(29),n2h16(364))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(620),h0tab(:,620),[48,5,2,8],[0,0,nMW,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(8),ngZn,m3h4x16(:,112),heltab2x64(:,:,620))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(30),n2h16(365))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(621),h0tab(:,621),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(9),m3h4x16(:,113),heltab2x64(:,:,621))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(622),h0tab(:,622),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(11),m3h4x16(:,114),heltab2x64(:,:,622))
  Gcoeff(:)%j = (c(131)*M(1,:)%j) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(623),h0tab(:,623),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(12),m3h4x16(:,115),heltab2x64(:,:,623))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(624),h0tab(:,624),[48,5,2,8],[nMH,nMZ,0,nMZ],4,2,wf4(:,7),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(14),m3h4x16(:,116),heltab2x64(:,:,624))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(625),h0tab(:,625),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(15),m3h4x16(:,117),heltab2x64(:,:,625))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(626),h0tab(:,626),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(31),m3h4x16(:,118),heltab2x64(:,:,626))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(627),h0tab(:,627),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(32),m3h4x16(:,119),heltab2x64(:,:,627))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(628),h0tab(:,628),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(43),m3h4x16(:,120),heltab2x64(:,:,628))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(629),h0tab(:,629),[48,5,2,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(37),m3h4x16(:,121),heltab2x64(:,:,629))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(570)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(630),h0tab(:,630),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(38),m3h4x16(:,122),heltab2x64(:,:,630))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(631),h0tab(:,631),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(39),m3h4x16(:,123),heltab2x64(:,:,631))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(632),h0tab(:,632),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(40),m3h4x16(:,124),heltab2x64(:,:,632))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(633),h0tab(:,633),[48,2,8,5],[nMZ,0,nMZ,nMH],4,2,wf4(:,36),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(41),m3h4x16(:,125),heltab2x64(:,:,633))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(634),h0tab(:,634),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(54),m3h4x16(:,126),heltab2x64(:,:,634))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(570)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(635),h0tab(:,635),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(16),m3h4x16(:,127),heltab2x64(:,:,635))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(636),h0tab(:,636),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(17),m3h4x16(:,128),heltab2x64(:,:,636))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(637),h0tab(:,637),[48,2,8,5],[0,0,0,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(19),m3h4x16(:,129),heltab2x64(:,:,637))
  call Hloop_A_Q(ntryL,G0H16(19),48,0,G1H16(48),n2h16(366))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(638),h0tab(:,638),[48,2,8,5],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(20),m3h4x16(:,130),heltab2x64(:,:,638))
  call Hloop_A_Q(ntryL,G0H16(20),48,0,G1H16(49),n2h16(367))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(639),h0tab(:,639),[48,2,8,5],[0,0,0,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(13),ngZl,m3h4x16(:,131),heltab2x64(:,:,639))
  call Hloop_A_Q(ntryL,G0H16(13),48,0,G1H16(50),n2h16(368))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(640),h0tab(:,640),[48,2,8,5],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(18),ngZl,m3h4x16(:,132),heltab2x64(:,:,640))
  call Hloop_A_Q(ntryL,G0H16(18),48,0,G1H16(51),n2h16(369))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(641),h0tab(:,641),[48,2,8,5],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,133),heltab2x64(:,:,641))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(52),n2h16(370))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(642),h0tab(:,642),[48,2,8,5],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(2),m3h4x16(:,134),heltab2x64(:,:,642))
  call Hloop_A_Q(ntryL,G0H16(2),48,0,G1H16(65),n2h16(371))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(643),h0tab(:,643),[48,2,8,5],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(3),ngZl,m3h4x16(:,135),heltab2x64(:,:,643))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(59),n2h16(372))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(644),h0tab(:,644),[48,2,8,5],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(4),ngZl,m3h4x16(:,136),heltab2x64(:,:,644))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(60),n2h16(373))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(645),h0tab(:,645),[48,2,8,5],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(5),ngZn,m3h4x16(:,137),heltab2x64(:,:,645))
  call Hloop_A_Q(ntryL,G0H16(5),48,0,G1H16(61),n2h16(374))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(646),h0tab(:,646),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(6),m3h4x16(:,138),heltab2x64(:,:,646))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(647),h0tab(:,647),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(8),m3h4x16(:,139),heltab2x64(:,:,647))
  Gcoeff(:)%j = (c(131)*M(1,:)%j) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(648),h0tab(:,648),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(19),m3h4x16(:,140),heltab2x64(:,:,648))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(649),h0tab(:,649),[48,2,8,5],[nMZ,0,nMZ,nMH],4,2,wf4(:,7),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(20),m3h4x16(:,141),heltab2x64(:,:,649))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(650),h0tab(:,650),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(13),m3h4x16(:,142),heltab2x64(:,:,650))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(651),h0tab(:,651),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(62),m3h4x16(:,143),heltab2x64(:,:,651))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(652),h0tab(:,652),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(63),m3h4x16(:,144),heltab2x64(:,:,652))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(653),h0tab(:,653),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(76),m3h4x16(:,145),heltab2x64(:,:,653))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(654),h0tab(:,654),[48,2,8,5],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(70),m3h4x16(:,146),heltab2x64(:,:,654))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(570)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(655),h0tab(:,655),[48,2,5,8],[nMZ,0,0,nMZ],4,2,wf4(:,3),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(18),m3h4x16(:,147),heltab2x64(:,:,655))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(656),h0tab(:,656),[48,2,5,8],[nMZ,0,0,nMZ],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,148),heltab2x64(:,:,656))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(657),h0tab(:,657),[48,2,5,8],[nMW,0,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(2),m3h4x16(:,149),heltab2x64(:,:,657))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(658),h0tab(:,658),[48,2,5,8],[nMW,0,0,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(71),m3h4x16(:,150),heltab2x64(:,:,658))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(659),h0tab(:,659),[48,2,5,8],[nMW,0,0,nMW],4,2,wf4(:,7),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(72),m3h4x16(:,151),heltab2x64(:,:,659))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(660),h0tab(:,660),[48,2,5,8],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(3),ngZn,m3h4x16(:,152),heltab2x64(:,:,660))
  call Hloop_A_Q(ntryL,G0H16(3),48,0,G1H16(73),n2h16(375))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(661),h0tab(:,661),[48,2,5,8],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(4),ngZn,m3h4x16(:,153),heltab2x64(:,:,661))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(74),n2h16(376))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(662),h0tab(:,662),[32,7,8,16],[0,0,0,nMB],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(173),m3h2x32(:,509),heltab2x64(:,:,662))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(663),h0tab(:,663),[32,7,8,16],[nMZ,0,0,nMB],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(174),ngZd,m3h2x32(:,510),heltab2x64(:,:,663))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(664),h0tab(:,664),[32,7,8,16],[0,0,nMZ,nMB],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(175),m3h2x32(:,511),heltab2x64(:,:,664))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(665),h0tab(:,665),[32,7,8,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(176),ngZd,m3h2x32(:,512),heltab2x64(:,:,665))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(666),h0tab(:,666),[32,7,8,16],[nMW,0,nMW,nMT],4,1,wf8(:,15))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(177),m3h2x32(:,513),heltab2x64(:,:,666))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(667),h0tab(:,667),[32,7,8,16],[0,0,0,nMB],4,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(178),m3h2x32(:,514),heltab2x64(:,:,667))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(668),h0tab(:,668),[32,7,8,16],[nMZ,0,0,nMB],4,1,wf8(:,18))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(179),ngZd,m3h2x32(:,515),heltab2x64(:,:,668))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(669),h0tab(:,669),[32,7,8,16],[0,0,nMZ,nMB],4,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(180),m3h2x32(:,516),heltab2x64(:,:,669))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(670),h0tab(:,670),[32,7,8,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,18))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(181),ngZd,m3h2x32(:,517),heltab2x64(:,:,670))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(671),h0tab(:,671),[32,7,8,16],[nMW,0,nMW,nMT],4,1,wf8(:,18))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(182),m3h2x32(:,518),heltab2x64(:,:,671))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(672),h0tab(:,672),[32,8,7,16],[0,0,0,nMB],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(183),m3h2x32(:,519),heltab2x64(:,:,672))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(673),h0tab(:,673),[32,8,7,16],[0,0,nMZ,nMB],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(184),m3h2x32(:,520),heltab2x64(:,:,673))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(674),h0tab(:,674),[32,8,7,16],[nMZ,0,0,nMB],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(185),ngZd,m3h2x32(:,521),heltab2x64(:,:,674))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(675),h0tab(:,675),[32,8,7,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(186),ngZd,m3h2x32(:,522),heltab2x64(:,:,675))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(676),h0tab(:,676),[32,8,7,16],[0,0,0,nMB],4,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(187),m3h2x32(:,523),heltab2x64(:,:,676))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(677),h0tab(:,677),[32,8,7,16],[0,0,nMZ,nMB],4,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(188),m3h2x32(:,524),heltab2x64(:,:,677))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(678),h0tab(:,678),[32,8,7,16],[nMZ,0,0,nMB],4,1,wf8(:,18))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,525),heltab2x64(:,:,678))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(679),h0tab(:,679),[32,8,7,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,18))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(10),ngZd,m3h2x32(:,526),heltab2x64(:,:,679))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(680),h0tab(:,680),[32,13,2,16],[0,0,0,nMB],4,1,wf8(:,110))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,527),heltab2x64(:,:,680))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(681),h0tab(:,681),[32,13,2,16],[nMZ,0,0,nMB],4,1,wf8(:,110))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(12),ngZd,m3h2x32(:,528),heltab2x64(:,:,681))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(682),h0tab(:,682),[32,13,2,16],[0,0,nMZ,nMB],4,1,wf8(:,110))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,529),heltab2x64(:,:,682))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(683),h0tab(:,683),[32,13,2,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,110))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(14),ngZd,m3h2x32(:,530),heltab2x64(:,:,683))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(684),h0tab(:,684),[32,13,2,16],[0,0,0,nMB],4,1,wf8(:,112))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,531),heltab2x64(:,:,684))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(685),h0tab(:,685),[32,13,2,16],[nMZ,0,0,nMB],4,1,wf8(:,112))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(16),ngZd,m3h2x32(:,532),heltab2x64(:,:,685))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(686),h0tab(:,686),[32,13,2,16],[0,0,nMZ,nMB],4,1,wf8(:,112))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,533),heltab2x64(:,:,686))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(687),h0tab(:,687),[32,13,2,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,112))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZd,m3h2x32(:,534),heltab2x64(:,:,687))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(688),h0tab(:,688),[32,2,13,16],[0,0,0,nMB],4,1,wf8(:,110))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,535),heltab2x64(:,:,688))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(689),h0tab(:,689),[32,2,13,16],[0,0,nMZ,nMB],4,1,wf8(:,110))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,536),heltab2x64(:,:,689))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(690),h0tab(:,690),[32,2,13,16],[nMZ,0,0,nMB],4,1,wf8(:,110))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(27),ngZd,m3h2x32(:,537),heltab2x64(:,:,690))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(691),h0tab(:,691),[32,2,13,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,110))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(28),ngZd,m3h2x32(:,538),heltab2x64(:,:,691))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(692),h0tab(:,692),[32,2,13,16],[nMW,0,nMW,nMT],4,1,wf8(:,110))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,539),heltab2x64(:,:,692))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(693),h0tab(:,693),[32,2,13,16],[0,0,0,nMB],4,1,wf8(:,112))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,540),heltab2x64(:,:,693))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(694),h0tab(:,694),[32,2,13,16],[0,0,nMZ,nMB],4,1,wf8(:,112))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,541),heltab2x64(:,:,694))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(695),h0tab(:,695),[32,2,13,16],[nMZ,0,0,nMB],4,1,wf8(:,112))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(32),ngZd,m3h2x32(:,542),heltab2x64(:,:,695))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(696),h0tab(:,696),[32,2,13,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,112))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(33),ngZd,m3h2x32(:,543),heltab2x64(:,:,696))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(697),h0tab(:,697),[32,2,13,16],[nMW,0,nMW,nMT],4,1,wf8(:,112))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,544),heltab2x64(:,:,697))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(698),h0tab(:,698),[32,2,8,21],[0,0,0,nMB],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,545),heltab2x64(:,:,698))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(699),h0tab(:,699),[32,2,8,21],[0,0,nMZ,nMB],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,546),heltab2x64(:,:,699))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(700),h0tab(:,700),[32,2,8,21],[nMZ,0,0,nMB],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(37),ngZd,m3h2x32(:,547),heltab2x64(:,:,700))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(701),h0tab(:,701),[32,2,8,21],[nMZ,0,nMZ,nMB],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(38),ngZd,m3h2x32(:,548),heltab2x64(:,:,701))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(702),h0tab(:,702),[32,2,8,21],[nMW,0,nMW,nMT],4,1,wf8(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(79),m3h2x32(:,549),heltab2x64(:,:,702))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(703),h0tab(:,703),[32,2,8,21],[0,0,0,nMB],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(80),m3h2x32(:,550),heltab2x64(:,:,703))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(704),h0tab(:,704),[32,2,8,21],[0,0,nMZ,nMB],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,551),heltab2x64(:,:,704))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(705),h0tab(:,705),[32,2,8,21],[nMZ,0,0,nMB],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(82),ngZd,m3h2x32(:,552),heltab2x64(:,:,705))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(706),h0tab(:,706),[32,2,8,21],[nMZ,0,nMZ,nMB],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(83),ngZd,m3h2x32(:,553),heltab2x64(:,:,706))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(707),h0tab(:,707),[32,2,8,21],[nMW,0,nMW,nMT],4,1,wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(84),m3h2x32(:,554),heltab2x64(:,:,707))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(708),h0tab(:,708),[32,8,2,21],[0,0,0,nMB],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(85),m3h2x32(:,555),heltab2x64(:,:,708))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(709),h0tab(:,709),[32,8,2,21],[nMZ,0,0,nMB],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(86),ngZd,m3h2x32(:,556),heltab2x64(:,:,709))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(710),h0tab(:,710),[32,8,2,21],[0,0,nMZ,nMB],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(87),m3h2x32(:,557),heltab2x64(:,:,710))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(711),h0tab(:,711),[32,8,2,21],[nMZ,0,nMZ,nMB],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(88),ngZd,m3h2x32(:,558),heltab2x64(:,:,711))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(712),h0tab(:,712),[32,8,2,21],[0,0,0,nMB],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(89),m3h2x32(:,559),heltab2x64(:,:,712))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(713),h0tab(:,713),[32,8,2,21],[nMZ,0,0,nMB],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(90),ngZd,m3h2x32(:,560),heltab2x64(:,:,713))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(714),h0tab(:,714),[32,8,2,21],[0,0,nMZ,nMB],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(97),m3h2x32(:,561),heltab2x64(:,:,714))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(715),h0tab(:,715),[32,8,2,21],[nMZ,0,nMZ,nMB],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(98),ngZd,m3h2x32(:,562),heltab2x64(:,:,715))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(716),h0tab(:,716),[37,8,2,16],[0,0,0,nMB],4,1,wf8(:,66))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,66),G0H8(25),m3h8x8(:,1),heltab2x64(:,:,716))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(717),h0tab(:,717),[37,8,2,16],[nMZ,0,0,nMB],4,1,wf8(:,66))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,66),G0H8(6),ngZd,m3h8x8(:,2),heltab2x64(:,:,717))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(718),h0tab(:,718),[37,8,2,16],[0,0,nMZ,nMB],4,1,wf8(:,66))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,66),G0H8(3),m3h8x8(:,3),heltab2x64(:,:,718))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(719),h0tab(:,719),[37,8,2,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,66))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,66),G0H8(12),ngZd,m3h8x8(:,4),heltab2x64(:,:,719))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(720),h0tab(:,720),[37,8,2,16],[0,0,0,nMB],4,1,wf8(:,68))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,68),G0H8(9),m3h8x8(:,5),heltab2x64(:,:,720))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(721),h0tab(:,721),[37,8,2,16],[nMZ,0,0,nMB],4,1,wf8(:,68))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,68),G0H8(18),ngZd,m3h8x8(:,6),heltab2x64(:,:,721))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(722),h0tab(:,722),[37,8,2,16],[0,0,nMZ,nMB],4,1,wf8(:,68))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,68),G0H8(15),m3h8x8(:,7),heltab2x64(:,:,722))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(723),h0tab(:,723),[37,8,2,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,68))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,68),G0H8(24),ngZd,m3h8x8(:,8),heltab2x64(:,:,723))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(724),h0tab(:,724),[37,2,8,16],[0,0,0,nMB],4,1,wf8(:,66))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,66),G0H8(21),m3h8x8(:,9),heltab2x64(:,:,724))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(725),h0tab(:,725),[37,2,8,16],[0,0,nMZ,nMB],4,1,wf8(:,66))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,66),G0H8(1),m3h8x8(:,10),heltab2x64(:,:,725))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(726),h0tab(:,726),[37,2,8,16],[nMZ,0,0,nMB],4,1,wf8(:,66))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,66),G0H8(2),ngZd,m3h8x8(:,11),heltab2x64(:,:,726))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(727),h0tab(:,727),[37,2,8,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,66))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,66),G0H8(4),ngZd,m3h8x8(:,12),heltab2x64(:,:,727))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(728),h0tab(:,728),[37,2,8,16],[nMW,0,nMW,nMT],4,1,wf8(:,66))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,66),G0H8(5),m3h8x8(:,13),heltab2x64(:,:,728))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(729),h0tab(:,729),[37,2,8,16],[0,0,0,nMB],4,1,wf8(:,68))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,68),G0H8(7),m3h8x8(:,14),heltab2x64(:,:,729))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(730),h0tab(:,730),[37,2,8,16],[0,0,nMZ,nMB],4,1,wf8(:,68))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,68),G0H8(8),m3h8x8(:,15),heltab2x64(:,:,730))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(731),h0tab(:,731),[37,2,8,16],[nMZ,0,0,nMB],4,1,wf8(:,68))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,68),G0H8(10),ngZd,m3h8x8(:,16),heltab2x64(:,:,731))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(732),h0tab(:,732),[37,2,8,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,68))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,68),G0H8(11),ngZd,m3h8x8(:,17),heltab2x64(:,:,732))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(733),h0tab(:,733),[37,2,8,16],[nMW,0,nMW,nMT],4,1,wf8(:,68))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,68),G0H8(13),m3h8x8(:,18),heltab2x64(:,:,733))
  Gcoeff(:)%j = (-(c(106)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(734),h0tab(:,734),[32,6,9,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,11),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(99),ngH,m3h2x32(:,563),heltab2x64(:,:,734))
  call Hloop_A_Q(ntryL,G0H32(99),32,nMB,G1H32(73),n2h32(89))
  Gcoeff(:)%j = (c(106)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(735),h0tab(:,735),[32,6,9,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,11),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(100),ngX,m3h2x32(:,564),heltab2x64(:,:,735))
  call Hloop_A_Q(ntryL,G0H32(100),32,nMB,G1H32(74),n2h32(90))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(736),h0tab(:,736),[32,6,9,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,11),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(101),ngPbt,m3h2x32(:,565),heltab2x64(:,:,736))
  call Hloop_A_Q(ntryL,G0H32(101),32,nMT,G1H32(75),n2h32(91))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(737),h0tab(:,737),[32,6,9,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,9),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(102),ngH,m3h2x32(:,566),heltab2x64(:,:,737))
  call Hloop_A_Q(ntryL,G0H32(102),32,nMB,G1H32(76),n2h32(92))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(738),h0tab(:,738),[32,6,9,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,9),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),ngX,m3h2x32(:,567),heltab2x64(:,:,738))
  call Hloop_A_Q(ntryL,G0H32(103),32,nMB,G1H32(77),n2h32(93))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(739),h0tab(:,739),[32,6,9,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,9),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(104),ngPbt,m3h2x32(:,568),heltab2x64(:,:,739))
  call Hloop_A_Q(ntryL,G0H32(104),32,nMT,G1H32(78),n2h32(94))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(740),h0tab(:,740),[32,6,9,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,11),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(105),ngH,m3h2x32(:,569),heltab2x64(:,:,740))
  call Hloop_A_Q(ntryL,G0H32(105),32,nMB,G1H32(79),n2h32(95))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(741),h0tab(:,741),[32,6,9,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,11),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(106),ngX,m3h2x32(:,570),heltab2x64(:,:,741))
  call Hloop_A_Q(ntryL,G0H32(106),32,nMB,G1H32(80),n2h32(96))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(742),h0tab(:,742),[32,6,9,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,11),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(107),ngPbt,m3h2x32(:,571),heltab2x64(:,:,742))
  call Hloop_A_Q(ntryL,G0H32(107),32,nMT,G1H32(81),n2h32(97))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(743),h0tab(:,743),[32,6,9,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,9),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(108),ngH,m3h2x32(:,572),heltab2x64(:,:,743))
  call Hloop_A_Q(ntryL,G0H32(108),32,nMB,G1H32(82),n2h32(98))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(744),h0tab(:,744),[32,6,9,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,9),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(52),ngX,m3h2x32(:,573),heltab2x64(:,:,744))
  call Hloop_A_Q(ntryL,G0H32(52),32,nMB,G1H32(83),n2h32(99))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(745),h0tab(:,745),[32,6,9,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,9),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(53),ngPbt,m3h2x32(:,574),heltab2x64(:,:,745))
  call Hloop_A_Q(ntryL,G0H32(53),32,nMT,G1H32(84),n2h32(100))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(746),h0tab(:,746),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(54),ngPbt,m3h2x32(:,575),heltab2x64(:,:,746))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(747),h0tab(:,747),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(55),ngPbt,m3h2x32(:,576),heltab2x64(:,:,747))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(748),h0tab(:,748),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(56),ngPbt,m3h2x32(:,577),heltab2x64(:,:,748))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(749),h0tab(:,749),[32,6,9,16],[nMH,nMZ,nMH,nMB],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(57),ngH,m3h2x32(:,578),heltab2x64(:,:,749))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(750),h0tab(:,750),[32,6,9,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(58),ngX,m3h2x32(:,579),heltab2x64(:,:,750))
  Gcoeff(:)%j = (-(c(145)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(751),h0tab(:,751),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(59),ngPbt,m3h2x32(:,580),heltab2x64(:,:,751))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(752),h0tab(:,752),[32,6,9,16],[nMB,nMB,nMB,0],4,2,wf4(:,11),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(141),m3h2x32(:,581),heltab2x64(:,:,752))
  call Hloop_A_Q(ntryL,G0H32(141),32,nMB,G1H32(85),n2h32(101))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(753),h0tab(:,753),[32,6,9,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,11),wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(142),ngZd,m3h2x32(:,582),heltab2x64(:,:,753))
  call Hloop_A_Q(ntryL,G0H32(142),32,nMB,G1H32(86),n2h32(102))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(754),h0tab(:,754),[32,6,9,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,11),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(143),m3h2x32(:,583),heltab2x64(:,:,754))
  call Hloop_A_Q(ntryL,G0H32(143),32,nMT,G1H32(87),n2h32(103))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(755),h0tab(:,755),[32,6,9,16],[nMB,nMB,nMB,0],4,2,wf4(:,9),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(144),m3h2x32(:,584),heltab2x64(:,:,755))
  call Hloop_A_Q(ntryL,G0H32(144),32,nMB,G1H32(88),n2h32(104))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(756),h0tab(:,756),[32,6,9,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,9),wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(145),ngZd,m3h2x32(:,585),heltab2x64(:,:,756))
  call Hloop_A_Q(ntryL,G0H32(145),32,nMB,G1H32(89),n2h32(105))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(757),h0tab(:,757),[32,6,9,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,9),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(146),m3h2x32(:,586),heltab2x64(:,:,757))
  call Hloop_A_Q(ntryL,G0H32(146),32,nMT,G1H32(90),n2h32(106))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(758),h0tab(:,758),[32,6,9,16],[nMB,nMB,nMB,0],4,2,wf4(:,11),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(147),m3h2x32(:,587),heltab2x64(:,:,758))
  call Hloop_A_Q(ntryL,G0H32(147),32,nMB,G1H32(91),n2h32(107))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(759),h0tab(:,759),[32,6,9,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,11),wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(148),ngZd,m3h2x32(:,588),heltab2x64(:,:,759))
  call Hloop_A_Q(ntryL,G0H32(148),32,nMB,G1H32(92),n2h32(108))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(760),h0tab(:,760),[32,6,9,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,11),wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(149),m3h2x32(:,589),heltab2x64(:,:,760))
  call Hloop_A_Q(ntryL,G0H32(149),32,nMT,G1H32(93),n2h32(109))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(761),h0tab(:,761),[32,6,9,16],[nMB,nMB,nMB,0],4,2,wf4(:,9),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(150),m3h2x32(:,590),heltab2x64(:,:,761))
  call Hloop_A_Q(ntryL,G0H32(150),32,nMB,G1H32(94),n2h32(110))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(762),h0tab(:,762),[32,6,9,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,9),wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(151),ngZd,m3h2x32(:,591),heltab2x64(:,:,762))
  call Hloop_A_Q(ntryL,G0H32(151),32,nMB,G1H32(95),n2h32(111))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(763),h0tab(:,763),[32,6,9,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,9),wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(152),m3h2x32(:,592),heltab2x64(:,:,763))
  call Hloop_A_Q(ntryL,G0H32(152),32,nMT,G1H32(96),n2h32(112))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(764),h0tab(:,764),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(165),ngPbt,m3h2x32(:,593),heltab2x64(:,:,764))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(765),h0tab(:,765),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(166),ngPbt,m3h2x32(:,594),heltab2x64(:,:,765))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(766),h0tab(:,766),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(167),ngPbt,m3h2x32(:,595),heltab2x64(:,:,766))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(767),h0tab(:,767),[32,6,9,16],[nMH,nMZ,nMH,nMB],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(168),ngH,m3h2x32(:,596),heltab2x64(:,:,767))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(768),h0tab(:,768),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(99),ngPbt,m3h2x32(:,597),heltab2x64(:,:,768))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(769),h0tab(:,769),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(100),m3h2x32(:,598),heltab2x64(:,:,769))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(770),h0tab(:,770),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(101),m3h2x32(:,599),heltab2x64(:,:,770))
  Gcoeff(:)%j = (c(150)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(771),h0tab(:,771),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(102),m3h2x32(:,600),heltab2x64(:,:,771))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(772),h0tab(:,772),[32,6,9,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(103),ngZd,m3h2x32(:,601),heltab2x64(:,:,772))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(773),h0tab(:,773),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(104),m3h2x32(:,602),heltab2x64(:,:,773))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(774),h0tab(:,774),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(105),ngPbt,m3h2x32(:,603),heltab2x64(:,:,774))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(775),h0tab(:,775),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(106),ngPbt,m3h2x32(:,604),heltab2x64(:,:,775))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(776),h0tab(:,776),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(107),ngPbt,m3h2x32(:,605),heltab2x64(:,:,776))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(777),h0tab(:,777),[32,6,9,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(108),ngX,m3h2x32(:,606),heltab2x64(:,:,777))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(778),h0tab(:,778),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(52),ngPbt,m3h2x32(:,607),heltab2x64(:,:,778))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(779),h0tab(:,779),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,608),heltab2x64(:,:,779))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(780),h0tab(:,780),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(141),m3h2x32(:,609),heltab2x64(:,:,780))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(781),h0tab(:,781),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(142),m3h2x32(:,610),heltab2x64(:,:,781))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(782),h0tab(:,782),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(143),m3h2x32(:,611),heltab2x64(:,:,782))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(783),h0tab(:,783),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(144),ngPbt,m3h2x32(:,612),heltab2x64(:,:,783))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(784),h0tab(:,784),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(145),ngPbt,m3h2x32(:,613),heltab2x64(:,:,784))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(785),h0tab(:,785),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(146),ngPbt,m3h2x32(:,614),heltab2x64(:,:,785))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(786),h0tab(:,786),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(147),ngPbt,m3h2x32(:,615),heltab2x64(:,:,786))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(787),h0tab(:,787),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(148),m3h2x32(:,616),heltab2x64(:,:,787))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(788),h0tab(:,788),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(149),m3h2x32(:,617),heltab2x64(:,:,788))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(789),h0tab(:,789),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(150),m3h2x32(:,618),heltab2x64(:,:,789))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(790),h0tab(:,790),[32,6,9,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(151),ngZd,m3h2x32(:,619),heltab2x64(:,:,790))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(791),h0tab(:,791),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(152),m3h2x32(:,620),heltab2x64(:,:,791))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(792),h0tab(:,792),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(189),m3h2x32(:,621),heltab2x64(:,:,792))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(793),h0tab(:,793),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(190),m3h2x32(:,622),heltab2x64(:,:,793))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(794),h0tab(:,794),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(191),m3h2x32(:,623),heltab2x64(:,:,794))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(795),h0tab(:,795),[32,6,9,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(192),m3h2x32(:,624),heltab2x64(:,:,795))
  Gcoeff(:)%j = (-(c(106)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(796),h0tab(:,796),[32,9,6,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,10),wf4(:,11))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngH,m3h2x32(:,625),heltab2x64(:,:,796))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMB,G1H32(97),n2h32(113))
  Gcoeff(:)%j = (c(106)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(797),h0tab(:,797),[32,9,6,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,10),wf4(:,11))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngX,m3h2x32(:,626),heltab2x64(:,:,797))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMB,G1H32(98),n2h32(114))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(798),h0tab(:,798),[32,9,6,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,10),wf4(:,11))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngPbt,m3h2x32(:,627),heltab2x64(:,:,798))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMT,G1H32(99),n2h32(115))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(799),h0tab(:,799),[32,9,6,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,10),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngH,m3h2x32(:,628),heltab2x64(:,:,799))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMB,G1H32(100),n2h32(116))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(800),h0tab(:,800),[32,9,6,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,10),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngX,m3h2x32(:,629),heltab2x64(:,:,800))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMB,G1H32(101),n2h32(117))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(801),h0tab(:,801),[32,9,6,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,10),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngPbt,m3h2x32(:,630),heltab2x64(:,:,801))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMT,G1H32(102),n2h32(118))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(802),h0tab(:,802),[32,9,6,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,8),wf4(:,11))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngH,m3h2x32(:,631),heltab2x64(:,:,802))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMB,G1H32(103),n2h32(119))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(803),h0tab(:,803),[32,9,6,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,8),wf4(:,11))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngX,m3h2x32(:,632),heltab2x64(:,:,803))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMB,G1H32(104),n2h32(120))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(804),h0tab(:,804),[32,9,6,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,8),wf4(:,11))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngPbt,m3h2x32(:,633),heltab2x64(:,:,804))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMT,G1H32(105),n2h32(121))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(805),h0tab(:,805),[32,9,6,16],[nMB,nMB,nMB,nMH],4,2,wf4(:,8),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngH,m3h2x32(:,634),heltab2x64(:,:,805))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMB,G1H32(106),n2h32(122))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(806),h0tab(:,806),[32,9,6,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,8),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngX,m3h2x32(:,635),heltab2x64(:,:,806))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMB,G1H32(107),n2h32(123))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(807),h0tab(:,807),[32,9,6,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,8),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(193),ngPbt,m3h2x32(:,636),heltab2x64(:,:,807))
  call Hloop_A_Q(ntryL,G0H32(193),32,nMT,G1H32(108),n2h32(124))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(808),h0tab(:,808),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,11))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(193),ngPbt,m3h2x32(:,637),heltab2x64(:,:,808))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(809),h0tab(:,809),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(194),ngPbt,m3h2x32(:,638),heltab2x64(:,:,809))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(810),h0tab(:,810),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,11))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(195),ngPbt,m3h2x32(:,639),heltab2x64(:,:,810))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(811),h0tab(:,811),[32,9,6,16],[nMH,nMZ,nMH,nMB],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(196),ngH,m3h2x32(:,640),heltab2x64(:,:,811))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(812),h0tab(:,812),[32,9,6,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(197),ngX,m3h2x32(:,641),heltab2x64(:,:,812))
  Gcoeff(:)%j = (-(c(145)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(813),h0tab(:,813),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(198),ngPbt,m3h2x32(:,642),heltab2x64(:,:,813))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(814),h0tab(:,814),[32,9,6,16],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,643),heltab2x64(:,:,814))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMB,G1H32(109),n2h32(125))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(815),h0tab(:,815),[32,9,6,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,10),wf4(:,11))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),ngZd,m3h2x32(:,644),heltab2x64(:,:,815))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMB,G1H32(110),n2h32(126))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(816),h0tab(:,816),[32,9,6,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,10),wf4(:,11))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,645),heltab2x64(:,:,816))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMT,G1H32(111),n2h32(127))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(817),h0tab(:,817),[32,9,6,16],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,646),heltab2x64(:,:,817))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMB,G1H32(112),n2h32(128))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(818),h0tab(:,818),[32,9,6,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,10),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),ngZd,m3h2x32(:,647),heltab2x64(:,:,818))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMB,G1H32(113),n2h32(129))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(819),h0tab(:,819),[32,9,6,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,10),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,648),heltab2x64(:,:,819))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMT,G1H32(114),n2h32(130))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(820),h0tab(:,820),[32,9,6,16],[nMB,nMB,nMB,0],4,2,wf4(:,8),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,649),heltab2x64(:,:,820))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMB,G1H32(115),n2h32(131))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(821),h0tab(:,821),[32,9,6,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,8),wf4(:,11))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),ngZd,m3h2x32(:,650),heltab2x64(:,:,821))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMB,G1H32(116),n2h32(132))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(822),h0tab(:,822),[32,9,6,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,8),wf4(:,11))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,651),heltab2x64(:,:,822))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMT,G1H32(117),n2h32(133))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(823),h0tab(:,823),[32,9,6,16],[nMB,nMB,nMB,0],4,2,wf4(:,8),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,652),heltab2x64(:,:,823))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMB,G1H32(118),n2h32(134))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(824),h0tab(:,824),[32,9,6,16],[nMB,nMB,nMB,nMZ],4,2,wf4(:,8),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),ngZd,m3h2x32(:,653),heltab2x64(:,:,824))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMB,G1H32(119),n2h32(135))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(825),h0tab(:,825),[32,9,6,16],[nMT,nMT,nMT,nMW],4,2,wf4(:,8),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,654),heltab2x64(:,:,825))
  call Hloop_A_Q(ntryL,G0H32(199),32,nMT,G1H32(120),n2h32(136))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(826),h0tab(:,826),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,11))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(199),ngPbt,m3h2x32(:,655),heltab2x64(:,:,826))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(827),h0tab(:,827),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(200),ngPbt,m3h2x32(:,656),heltab2x64(:,:,827))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(828),h0tab(:,828),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,11))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(201),ngPbt,m3h2x32(:,657),heltab2x64(:,:,828))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(829),h0tab(:,829),[32,9,6,16],[nMH,nMZ,nMH,nMB],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(202),ngH,m3h2x32(:,658),heltab2x64(:,:,829))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(830),h0tab(:,830),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(203),ngPbt,m3h2x32(:,659),heltab2x64(:,:,830))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(831),h0tab(:,831),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(204),m3h2x32(:,660),heltab2x64(:,:,831))
  Gcoeff(:)%j = (c(150)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(832),h0tab(:,832),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(205),m3h2x32(:,661),heltab2x64(:,:,832))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(833),h0tab(:,833),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(206),m3h2x32(:,662),heltab2x64(:,:,833))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(834),h0tab(:,834),[32,9,6,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(207),ngZd,m3h2x32(:,663),heltab2x64(:,:,834))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(835),h0tab(:,835),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(208),m3h2x32(:,664),heltab2x64(:,:,835))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(836),h0tab(:,836),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,11))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(209),ngPbt,m3h2x32(:,665),heltab2x64(:,:,836))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(837),h0tab(:,837),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(210),ngPbt,m3h2x32(:,666),heltab2x64(:,:,837))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(838),h0tab(:,838),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,11))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(211),ngPbt,m3h2x32(:,667),heltab2x64(:,:,838))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(839),h0tab(:,839),[32,9,6,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(212),ngX,m3h2x32(:,668),heltab2x64(:,:,839))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(840),h0tab(:,840),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(213),ngPbt,m3h2x32(:,669),heltab2x64(:,:,840))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(841),h0tab(:,841),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(214),m3h2x32(:,670),heltab2x64(:,:,841))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(842),h0tab(:,842),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(215),m3h2x32(:,671),heltab2x64(:,:,842))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(843),h0tab(:,843),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(216),m3h2x32(:,672),heltab2x64(:,:,843))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(844),h0tab(:,844),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(217),m3h2x32(:,673),heltab2x64(:,:,844))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(845),h0tab(:,845),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,11))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(218),ngPbt,m3h2x32(:,674),heltab2x64(:,:,845))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(846),h0tab(:,846),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(219),ngPbt,m3h2x32(:,675),heltab2x64(:,:,846))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(847),h0tab(:,847),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,11))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(220),ngPbt,m3h2x32(:,676),heltab2x64(:,:,847))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(848),h0tab(:,848),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(221),ngPbt,m3h2x32(:,677),heltab2x64(:,:,848))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(849),h0tab(:,849),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(222),m3h2x32(:,678),heltab2x64(:,:,849))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(850),h0tab(:,850),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(223),m3h2x32(:,679),heltab2x64(:,:,850))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(851),h0tab(:,851),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(224),m3h2x32(:,680),heltab2x64(:,:,851))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(852),h0tab(:,852),[32,9,6,16],[nMZ,nMH,nMZ,nMB],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(225),ngZd,m3h2x32(:,681),heltab2x64(:,:,852))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(853),h0tab(:,853),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(226),m3h2x32(:,682),heltab2x64(:,:,853))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(854),h0tab(:,854),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(227),m3h2x32(:,683),heltab2x64(:,:,854))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(855),h0tab(:,855),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,10),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(228),m3h2x32(:,684),heltab2x64(:,:,855))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(856),h0tab(:,856),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(229),m3h2x32(:,685),heltab2x64(:,:,856))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(857),h0tab(:,857),[32,9,6,16],[nMW,nMW,nMW,nMT],4,2,wf4(:,8),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(230),m3h2x32(:,686),heltab2x64(:,:,857))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(858),h0tab(:,858),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(231),ngPbt,m3h2x32(:,687),heltab2x64(:,:,858))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(859),h0tab(:,859),[32,6,16,9],[nMZ,nMH,nMB,nMB],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(232),ngX,m3h2x32(:,688),heltab2x64(:,:,859))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(860),h0tab(:,860),[32,6,16,9],[nMH,nMZ,nMB,nMB],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(233),ngH,m3h2x32(:,689),heltab2x64(:,:,860))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(861),h0tab(:,861),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(234),ngPbt,m3h2x32(:,690),heltab2x64(:,:,861))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(862),h0tab(:,862),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(235),ngPbt,m3h2x32(:,691),heltab2x64(:,:,862))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(863),h0tab(:,863),[32,6,16,9],[nMZ,nMH,nMB,nMB],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(236),ngX,m3h2x32(:,692),heltab2x64(:,:,863))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(864),h0tab(:,864),[32,6,16,9],[nMH,nMZ,nMB,nMB],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(237),ngH,m3h2x32(:,693),heltab2x64(:,:,864))
  Gcoeff(:)%j = (-(c(156)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(865),h0tab(:,865),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(238),ngPbt,m3h2x32(:,694),heltab2x64(:,:,865))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(866),h0tab(:,866),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,11),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(239),ngPbt,m3h2x32(:,695),heltab2x64(:,:,866))
  call Hloop_A_Q(ntryL,G0H32(239),32,nMT,G1H32(121),n2h32(137))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(867),h0tab(:,867),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,9),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(239),ngPbt,m3h2x32(:,696),heltab2x64(:,:,867))
  call Hloop_A_Q(ntryL,G0H32(239),32,nMT,G1H32(122),n2h32(138))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(868),h0tab(:,868),[32,6,16,9],[nMB,nMB,nMH,nMZ],4,2,wf4(:,11),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(239),ngX,m3h2x32(:,697),heltab2x64(:,:,868))
  call Hloop_A_Q(ntryL,G0H32(239),32,nMB,G1H32(123),n2h32(139))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(869),h0tab(:,869),[32,6,16,9],[nMB,nMB,nMZ,nMH],4,2,wf4(:,11),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(239),ngH,m3h2x32(:,698),heltab2x64(:,:,869))
  call Hloop_A_Q(ntryL,G0H32(239),32,nMB,G1H32(124),n2h32(140))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(870),h0tab(:,870),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,11),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(239),ngPbt,m3h2x32(:,699),heltab2x64(:,:,870))
  call Hloop_A_Q(ntryL,G0H32(239),32,nMT,G1H32(125),n2h32(141))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(871),h0tab(:,871),[32,6,16,9],[nMB,nMB,nMH,nMZ],4,2,wf4(:,9),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(239),ngX,m3h2x32(:,700),heltab2x64(:,:,871))
  call Hloop_A_Q(ntryL,G0H32(239),32,nMB,G1H32(126),n2h32(142))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(872),h0tab(:,872),[32,6,16,9],[nMB,nMB,nMZ,nMH],4,2,wf4(:,9),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(239),ngH,m3h2x32(:,701),heltab2x64(:,:,872))
  call Hloop_A_Q(ntryL,G0H32(239),32,nMB,G1H32(127),n2h32(143))
  Gcoeff(:)%j = (-(c(156)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(873),h0tab(:,873),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,9),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(239),ngPbt,m3h2x32(:,702),heltab2x64(:,:,873))
  call Hloop_A_Q(ntryL,G0H32(239),32,nMT,G1H32(128),n2h32(144))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(874),h0tab(:,874),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(239),m3h2x32(:,703),heltab2x64(:,:,874))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(875),h0tab(:,875),[32,6,16,9],[nMZ,nMH,nMB,nMB],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(240),ngZd,m3h2x32(:,704),heltab2x64(:,:,875))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(876),h0tab(:,876),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(241),m3h2x32(:,705),heltab2x64(:,:,876))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(877),h0tab(:,877),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(242),m3h2x32(:,706),heltab2x64(:,:,877))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(878),h0tab(:,878),[32,6,16,9],[nMZ,nMH,nMB,nMB],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(243),ngZd,m3h2x32(:,707),heltab2x64(:,:,878))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(879),h0tab(:,879),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(244),m3h2x32(:,708),heltab2x64(:,:,879))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(880),h0tab(:,880),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(245),ngPbt,m3h2x32(:,709),heltab2x64(:,:,880))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(881),h0tab(:,881),[32,6,16,9],[nMH,nMZ,nMB,nMB],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(246),ngH,m3h2x32(:,710),heltab2x64(:,:,881))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(882),h0tab(:,882),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(247),ngPbt,m3h2x32(:,711),heltab2x64(:,:,882))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(883),h0tab(:,883),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(248),ngPbt,m3h2x32(:,712),heltab2x64(:,:,883))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(884),h0tab(:,884),[32,6,16,9],[nMH,nMZ,nMB,nMB],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(249),ngH,m3h2x32(:,713),heltab2x64(:,:,884))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(885),h0tab(:,885),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(250),ngPbt,m3h2x32(:,714),heltab2x64(:,:,885))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(886),h0tab(:,886),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,11),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),m3h2x32(:,715),heltab2x64(:,:,886))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMT,G1H32(129),n2h32(145))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(887),h0tab(:,887),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,9),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),m3h2x32(:,716),heltab2x64(:,:,887))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMT,G1H32(130),n2h32(146))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(888),h0tab(:,888),[32,6,16,9],[nMB,nMB,nMH,nMZ],4,2,wf4(:,11),wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),ngZd,m3h2x32(:,717),heltab2x64(:,:,888))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMB,G1H32(131),n2h32(147))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(889),h0tab(:,889),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,11),wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),m3h2x32(:,718),heltab2x64(:,:,889))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMT,G1H32(132),n2h32(148))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(890),h0tab(:,890),[32,6,16,9],[nMB,nMB,nMH,nMZ],4,2,wf4(:,9),wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),ngZd,m3h2x32(:,719),heltab2x64(:,:,890))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMB,G1H32(133),n2h32(149))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(891),h0tab(:,891),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,9),wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),m3h2x32(:,720),heltab2x64(:,:,891))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMT,G1H32(134),n2h32(150))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(892),h0tab(:,892),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,11),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),ngPbt,m3h2x32(:,721),heltab2x64(:,:,892))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMT,G1H32(135),n2h32(151))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(893),h0tab(:,893),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,9),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),ngPbt,m3h2x32(:,722),heltab2x64(:,:,893))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMT,G1H32(136),n2h32(152))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(894),h0tab(:,894),[32,6,16,9],[nMB,nMB,nMZ,nMH],4,2,wf4(:,11),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),ngH,m3h2x32(:,723),heltab2x64(:,:,894))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMB,G1H32(137),n2h32(153))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(895),h0tab(:,895),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,11),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),ngPbt,m3h2x32(:,724),heltab2x64(:,:,895))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMT,G1H32(138),n2h32(154))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(896),h0tab(:,896),[32,6,16,9],[nMB,nMB,nMZ,nMH],4,2,wf4(:,9),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),ngH,m3h2x32(:,725),heltab2x64(:,:,896))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMB,G1H32(139),n2h32(155))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(897),h0tab(:,897),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,9),wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H64(1),ex6(:),G0H32(251),ngPbt,m3h2x32(:,726),heltab2x64(:,:,897))
  call Hloop_A_Q(ntryL,G0H32(251),32,nMT,G1H32(140),n2h32(156))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(898),h0tab(:,898),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,11),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(251),m3h2x32(:,727),heltab2x64(:,:,898))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(899),h0tab(:,899),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,9),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(252),m3h2x32(:,728),heltab2x64(:,:,899))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(900),h0tab(:,900),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,11),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(253),m3h2x32(:,729),heltab2x64(:,:,900))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(901),h0tab(:,901),[32,6,16,9],[nMW,nMW,nMT,nMT],4,2,wf4(:,9),wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(254),m3h2x32(:,730),heltab2x64(:,:,901))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(902),h0tab(:,902),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,11),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(255),m3h2x32(:,731),heltab2x64(:,:,902))
  call Hloop_A_Q(ntryL,G0H32(255),32,nMT,G1H32(141),n2h32(157))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(903),h0tab(:,903),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,9),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(255),m3h2x32(:,732),heltab2x64(:,:,903))
  call Hloop_A_Q(ntryL,G0H32(255),32,nMT,G1H32(142),n2h32(158))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(904),h0tab(:,904),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,11),wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(255),m3h2x32(:,733),heltab2x64(:,:,904))
  call Hloop_A_Q(ntryL,G0H32(255),32,nMT,G1H32(143),n2h32(159))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(905),h0tab(:,905),[32,6,16,9],[nMT,nMT,nMW,nMW],4,2,wf4(:,9),wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(255),m3h2x32(:,734),heltab2x64(:,:,905))
  call Hloop_A_Q(ntryL,G0H32(255),32,nMT,G1H32(144),n2h32(160))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(587)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(906),h0tab(:,906),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(77),m3h4x16(:,154),heltab2x64(:,:,906))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(907),h0tab(:,907),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,36),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(78),m3h4x16(:,155),heltab2x64(:,:,907))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(908),h0tab(:,908),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,9))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(79),m3h4x16(:,156),heltab2x64(:,:,908))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(909),h0tab(:,909),[48,6,1,8],[nMH,nMZ,0,nMZ],4,2,wf4(:,36),wf4(:,9))
  call Hloop_VS_T(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(80),m3h4x16(:,157),heltab2x64(:,:,909))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(910),h0tab(:,910),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,36),wf4(:,9))
  call Hloop_VT_S(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(81),m3h4x16(:,158),heltab2x64(:,:,910))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(587)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(911),h0tab(:,911),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(5),m3h4x16(:,159),heltab2x64(:,:,911))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(912),h0tab(:,912),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,3),wf4(:,9))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(3),m3h4x16(:,160),heltab2x64(:,:,912))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(913),h0tab(:,913),[48,6,1,8],[0,0,0,0],4,2,wf4(:,6),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(4),m3h4x16(:,161),heltab2x64(:,:,913))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(82),n2h16(377))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(914),h0tab(:,914),[48,6,1,8],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(4),m3h4x16(:,162),heltab2x64(:,:,914))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(83),n2h16(378))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(915),h0tab(:,915),[48,6,1,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(4),ngZl,m3h4x16(:,163),heltab2x64(:,:,915))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(84),n2h16(379))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(916),h0tab(:,916),[48,6,1,8],[0,0,nMZ,0],4,2,wf4(:,7),wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(4),ngZl,m3h4x16(:,164),heltab2x64(:,:,916))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(85),n2h16(380))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(917),h0tab(:,917),[48,6,1,8],[0,0,0,0],4,2,wf4(:,6),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(4),m3h4x16(:,165),heltab2x64(:,:,917))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(86),n2h16(381))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(918),h0tab(:,918),[48,6,1,8],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(4),m3h4x16(:,166),heltab2x64(:,:,918))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(87),n2h16(382))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(919),h0tab(:,919),[48,6,1,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(4),ngZl,m3h4x16(:,167),heltab2x64(:,:,919))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(88),n2h16(383))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(920),h0tab(:,920),[48,6,1,8],[0,0,nMZ,0],4,2,wf4(:,7),wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(4),ngZl,m3h4x16(:,168),heltab2x64(:,:,920))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(89),n2h16(384))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(921),h0tab(:,921),[48,6,1,8],[0,0,nMW,0],4,2,wf4(:,7),wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(4),ngZn,m3h4x16(:,169),heltab2x64(:,:,921))
  call Hloop_A_Q(ntryL,G0H16(4),48,0,G1H16(90),n2h16(385))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(922),h0tab(:,922),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(4),m3h4x16(:,170),heltab2x64(:,:,922))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(923),h0tab(:,923),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(21),m3h4x16(:,171),heltab2x64(:,:,923))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(924),h0tab(:,924),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,9))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,6),G0H16(22),m3h4x16(:,172),heltab2x64(:,:,924))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(925),h0tab(:,925),[48,6,1,8],[nMH,nMZ,0,nMZ],4,2,wf4(:,7),wf4(:,9))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(23),m3h4x16(:,173),heltab2x64(:,:,925))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(926),h0tab(:,926),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,9))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,7),G0H16(24),m3h4x16(:,174),heltab2x64(:,:,926))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(927),h0tab(:,927),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(91),m3h4x16(:,175),heltab2x64(:,:,927))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(928),h0tab(:,928),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(92),m3h4x16(:,176),heltab2x64(:,:,928))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(929),h0tab(:,929),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,6),wf4(:,9))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(93),m3h4x16(:,177),heltab2x64(:,:,929))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(930),h0tab(:,930),[48,6,1,8],[nMW,nMW,0,nMW],4,2,wf4(:,7),wf4(:,9))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(94),m3h4x16(:,178),heltab2x64(:,:,930))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(587)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(931),h0tab(:,931),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,11))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(95),m3h4x16(:,179),heltab2x64(:,:,931))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(932),h0tab(:,932),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,11))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(96),m3h4x16(:,180),heltab2x64(:,:,932))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(933),h0tab(:,933),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,9))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(97),m3h4x16(:,181),heltab2x64(:,:,933))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(934),h0tab(:,934),[48,1,8,6],[nMZ,0,nMZ,nMH],4,2,wf4(:,36),wf4(:,9))
  call Hloop_TS_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(98),m3h4x16(:,182),heltab2x64(:,:,934))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(935),h0tab(:,935),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,9))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(99),m3h4x16(:,183),heltab2x64(:,:,935))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(587)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(936),h0tab(:,936),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(25),m3h4x16(:,184),heltab2x64(:,:,936))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(937),h0tab(:,937),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,9))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(26),m3h4x16(:,185),heltab2x64(:,:,937))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(938),h0tab(:,938),[48,1,8,6],[0,0,0,0],4,2,wf4(:,6),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(27),m3h4x16(:,186),heltab2x64(:,:,938))
  call Hloop_A_Q(ntryL,G0H16(27),48,0,G1H16(100),n2h16(386))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(939),h0tab(:,939),[48,1,8,6],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(27),m3h4x16(:,187),heltab2x64(:,:,939))
  call Hloop_A_Q(ntryL,G0H16(27),48,0,G1H16(101),n2h16(387))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(940),h0tab(:,940),[48,1,8,6],[0,0,0,0],4,2,wf4(:,7),wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(27),ngZl,m3h4x16(:,188),heltab2x64(:,:,940))
  call Hloop_A_Q(ntryL,G0H16(27),48,0,G1H16(102),n2h16(388))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(941),h0tab(:,941),[48,1,8,6],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(27),ngZl,m3h4x16(:,189),heltab2x64(:,:,941))
  call Hloop_A_Q(ntryL,G0H16(27),48,0,G1H16(103),n2h16(389))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(942),h0tab(:,942),[48,1,8,6],[0,0,0,0],4,2,wf4(:,6),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(27),m3h4x16(:,190),heltab2x64(:,:,942))
  call Hloop_A_Q(ntryL,G0H16(27),48,0,G1H16(104),n2h16(390))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(943),h0tab(:,943),[48,1,8,6],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(27),m3h4x16(:,191),heltab2x64(:,:,943))
  call Hloop_A_Q(ntryL,G0H16(27),48,0,G1H16(105),n2h16(391))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(944),h0tab(:,944),[48,1,8,6],[0,0,0,0],4,2,wf4(:,7),wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(27),ngZl,m3h4x16(:,192),heltab2x64(:,:,944))
  call Hloop_A_Q(ntryL,G0H16(27),48,0,G1H16(106),n2h16(392))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(945),h0tab(:,945),[48,1,8,6],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(27),ngZl,m3h4x16(:,193),heltab2x64(:,:,945))
  call Hloop_A_Q(ntryL,G0H16(27),48,0,G1H16(107),n2h16(393))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(946),h0tab(:,946),[48,1,8,6],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(27),ngZn,m3h4x16(:,194),heltab2x64(:,:,946))
  call Hloop_A_Q(ntryL,G0H16(27),48,0,G1H16(108),n2h16(394))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(947),h0tab(:,947),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(27),m3h4x16(:,195),heltab2x64(:,:,947))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(948),h0tab(:,948),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(28),m3h4x16(:,196),heltab2x64(:,:,948))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(949),h0tab(:,949),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,9))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(29),m3h4x16(:,197),heltab2x64(:,:,949))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(950),h0tab(:,950),[48,1,8,6],[nMZ,0,nMZ,nMH],4,2,wf4(:,7),wf4(:,9))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(30),m3h4x16(:,198),heltab2x64(:,:,950))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(951),h0tab(:,951),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,9))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(31),m3h4x16(:,199),heltab2x64(:,:,951))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(952),h0tab(:,952),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(109),m3h4x16(:,200),heltab2x64(:,:,952))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(953),h0tab(:,953),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(110),m3h4x16(:,201),heltab2x64(:,:,953))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(954),h0tab(:,954),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,9))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(111),m3h4x16(:,202),heltab2x64(:,:,954))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(955),h0tab(:,955),[48,1,8,6],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,9))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(112),m3h4x16(:,203),heltab2x64(:,:,955))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(587)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(956),h0tab(:,956),[48,1,6,8],[nMZ,0,0,nMZ],4,2,wf4(:,3),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(32),m3h4x16(:,204),heltab2x64(:,:,956))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(957),h0tab(:,957),[48,1,6,8],[nMZ,0,0,nMZ],4,2,wf4(:,3),wf4(:,9))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(33),m3h4x16(:,205),heltab2x64(:,:,957))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(958),h0tab(:,958),[48,1,6,8],[nMW,0,0,nMW],4,2,wf4(:,3),wf4(:,9))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(34),m3h4x16(:,206),heltab2x64(:,:,958))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(959),h0tab(:,959),[48,1,6,8],[nMW,0,0,nMW],4,2,wf4(:,6),wf4(:,9))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(113),m3h4x16(:,207),heltab2x64(:,:,959))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(960),h0tab(:,960),[48,1,6,8],[nMW,0,0,nMW],4,2,wf4(:,7),wf4(:,9))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(114),m3h4x16(:,208),heltab2x64(:,:,960))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(961),h0tab(:,961),[48,1,6,8],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(35),ngZn,m3h4x16(:,209),heltab2x64(:,:,961))
  call Hloop_A_Q(ntryL,G0H16(35),48,0,G1H16(115),n2h16(395))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(962),h0tab(:,962),[48,1,6,8],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(35),ngZn,m3h4x16(:,210),heltab2x64(:,:,962))
  call Hloop_A_Q(ntryL,G0H16(35),48,0,G1H16(116),n2h16(396))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(963),h0tab(:,963),[32,7,8,16],[0,0,0,nMB],4,1,wf8(:,38))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(255),m3h2x32(:,735),heltab2x64(:,:,963))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(964),h0tab(:,964),[32,7,8,16],[nMZ,0,0,nMB],4,1,wf8(:,38))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(256),ngZd,m3h2x32(:,736),heltab2x64(:,:,964))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(965),h0tab(:,965),[32,7,8,16],[0,0,nMZ,nMB],4,1,wf8(:,38))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(257),m3h2x32(:,737),heltab2x64(:,:,965))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(966),h0tab(:,966),[32,7,8,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,38))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(258),ngZd,m3h2x32(:,738),heltab2x64(:,:,966))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(967),h0tab(:,967),[32,7,8,16],[nMW,0,nMW,nMT],4,1,wf8(:,38))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(259),m3h2x32(:,739),heltab2x64(:,:,967))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(968),h0tab(:,968),[32,7,8,16],[0,0,0,nMB],4,1,wf8(:,40))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(260),m3h2x32(:,740),heltab2x64(:,:,968))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(969),h0tab(:,969),[32,7,8,16],[nMZ,0,0,nMB],4,1,wf8(:,40))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(261),ngZd,m3h2x32(:,741),heltab2x64(:,:,969))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(970),h0tab(:,970),[32,7,8,16],[0,0,nMZ,nMB],4,1,wf8(:,40))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(262),m3h2x32(:,742),heltab2x64(:,:,970))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(971),h0tab(:,971),[32,7,8,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,40))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(263),ngZd,m3h2x32(:,743),heltab2x64(:,:,971))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(972),h0tab(:,972),[32,7,8,16],[nMW,0,nMW,nMT],4,1,wf8(:,40))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(264),m3h2x32(:,744),heltab2x64(:,:,972))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(973),h0tab(:,973),[32,8,7,16],[0,0,0,nMB],4,1,wf8(:,38))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(265),m3h2x32(:,745),heltab2x64(:,:,973))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(974),h0tab(:,974),[32,8,7,16],[0,0,nMZ,nMB],4,1,wf8(:,38))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(266),m3h2x32(:,746),heltab2x64(:,:,974))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(975),h0tab(:,975),[32,8,7,16],[nMZ,0,0,nMB],4,1,wf8(:,38))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(267),ngZd,m3h2x32(:,747),heltab2x64(:,:,975))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(976),h0tab(:,976),[32,8,7,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,38))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(268),ngZd,m3h2x32(:,748),heltab2x64(:,:,976))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(977),h0tab(:,977),[32,8,7,16],[0,0,0,nMB],4,1,wf8(:,40))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(269),m3h2x32(:,749),heltab2x64(:,:,977))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(978),h0tab(:,978),[32,8,7,16],[0,0,nMZ,nMB],4,1,wf8(:,40))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(270),m3h2x32(:,750),heltab2x64(:,:,978))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(979),h0tab(:,979),[32,8,7,16],[nMZ,0,0,nMB],4,1,wf8(:,40))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(271),ngZd,m3h2x32(:,751),heltab2x64(:,:,979))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(980),h0tab(:,980),[32,8,7,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,40))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(272),ngZd,m3h2x32(:,752),heltab2x64(:,:,980))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(981),h0tab(:,981),[32,14,1,16],[0,0,0,nMB],4,1,wf8(:,150))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(273),m3h2x32(:,753),heltab2x64(:,:,981))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(982),h0tab(:,982),[32,14,1,16],[nMZ,0,0,nMB],4,1,wf8(:,150))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(274),ngZd,m3h2x32(:,754),heltab2x64(:,:,982))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(983),h0tab(:,983),[32,14,1,16],[0,0,nMZ,nMB],4,1,wf8(:,150))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(275),m3h2x32(:,755),heltab2x64(:,:,983))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(984),h0tab(:,984),[32,14,1,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,150))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(276),ngZd,m3h2x32(:,756),heltab2x64(:,:,984))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(985),h0tab(:,985),[32,14,1,16],[0,0,0,nMB],4,1,wf8(:,151))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(277),m3h2x32(:,757),heltab2x64(:,:,985))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(986),h0tab(:,986),[32,14,1,16],[nMZ,0,0,nMB],4,1,wf8(:,151))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(278),ngZd,m3h2x32(:,758),heltab2x64(:,:,986))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(987),h0tab(:,987),[32,14,1,16],[0,0,nMZ,nMB],4,1,wf8(:,151))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(279),m3h2x32(:,759),heltab2x64(:,:,987))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(988),h0tab(:,988),[32,14,1,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,151))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(280),ngZd,m3h2x32(:,760),heltab2x64(:,:,988))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(989),h0tab(:,989),[32,1,14,16],[0,0,0,nMB],4,1,wf8(:,150))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(281),m3h2x32(:,761),heltab2x64(:,:,989))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(990),h0tab(:,990),[32,1,14,16],[0,0,nMZ,nMB],4,1,wf8(:,150))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(282),m3h2x32(:,762),heltab2x64(:,:,990))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(991),h0tab(:,991),[32,1,14,16],[nMZ,0,0,nMB],4,1,wf8(:,150))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(283),ngZd,m3h2x32(:,763),heltab2x64(:,:,991))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(992),h0tab(:,992),[32,1,14,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,150))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(284),ngZd,m3h2x32(:,764),heltab2x64(:,:,992))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(993),h0tab(:,993),[32,1,14,16],[nMW,0,nMW,nMT],4,1,wf8(:,150))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(285),m3h2x32(:,765),heltab2x64(:,:,993))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(994),h0tab(:,994),[32,1,14,16],[0,0,0,nMB],4,1,wf8(:,151))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(286),m3h2x32(:,766),heltab2x64(:,:,994))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(995),h0tab(:,995),[32,1,14,16],[0,0,nMZ,nMB],4,1,wf8(:,151))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(287),m3h2x32(:,767),heltab2x64(:,:,995))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(996),h0tab(:,996),[32,1,14,16],[nMZ,0,0,nMB],4,1,wf8(:,151))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(288),ngZd,m3h2x32(:,768),heltab2x64(:,:,996))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(997),h0tab(:,997),[32,1,14,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,151))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(289),ngZd,m3h2x32(:,769),heltab2x64(:,:,997))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(998),h0tab(:,998),[32,1,14,16],[nMW,0,nMW,nMT],4,1,wf8(:,151))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(290),m3h2x32(:,770),heltab2x64(:,:,998))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(999),h0tab(:,999),[32,1,8,22],[0,0,0,nMB],4,1,wf8(:,33))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(291),m3h2x32(:,771),heltab2x64(:,:,999))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1000),h0tab(:,1000),[32,1,8,22],[0,0,nMZ,nMB],4,1,wf8(:,33))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(292),m3h2x32(:,772),heltab2x64(:,:,1000))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1001),h0tab(:,1001),[32,1,8,22],[nMZ,0,0,nMB],4,1,wf8(:,33))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(293),ngZd,m3h2x32(:,773),heltab2x64(:,:,1001))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1002),h0tab(:,1002),[32,1,8,22],[nMZ,0,nMZ,nMB],4,1,wf8(:,33))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(294),ngZd,m3h2x32(:,774),heltab2x64(:,:,1002))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1003),h0tab(:,1003),[32,1,8,22],[nMW,0,nMW,nMT],4,1,wf8(:,33))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(295),m3h2x32(:,775),heltab2x64(:,:,1003))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1004),h0tab(:,1004),[32,1,8,22],[0,0,0,nMB],4,1,wf8(:,35))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(296),m3h2x32(:,776),heltab2x64(:,:,1004))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1005),h0tab(:,1005),[32,1,8,22],[0,0,nMZ,nMB],4,1,wf8(:,35))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(297),m3h2x32(:,777),heltab2x64(:,:,1005))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1006),h0tab(:,1006),[32,1,8,22],[nMZ,0,0,nMB],4,1,wf8(:,35))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(298),ngZd,m3h2x32(:,778),heltab2x64(:,:,1006))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1007),h0tab(:,1007),[32,1,8,22],[nMZ,0,nMZ,nMB],4,1,wf8(:,35))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(299),ngZd,m3h2x32(:,779),heltab2x64(:,:,1007))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1008),h0tab(:,1008),[32,1,8,22],[nMW,0,nMW,nMT],4,1,wf8(:,35))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(300),m3h2x32(:,780),heltab2x64(:,:,1008))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1009),h0tab(:,1009),[32,8,1,22],[0,0,0,nMB],4,1,wf8(:,33))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(301),m3h2x32(:,781),heltab2x64(:,:,1009))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1010),h0tab(:,1010),[32,8,1,22],[nMZ,0,0,nMB],4,1,wf8(:,33))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(302),ngZd,m3h2x32(:,782),heltab2x64(:,:,1010))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1011),h0tab(:,1011),[32,8,1,22],[0,0,nMZ,nMB],4,1,wf8(:,33))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(303),m3h2x32(:,783),heltab2x64(:,:,1011))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1012),h0tab(:,1012),[32,8,1,22],[nMZ,0,nMZ,nMB],4,1,wf8(:,33))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(304),ngZd,m3h2x32(:,784),heltab2x64(:,:,1012))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1013),h0tab(:,1013),[32,8,1,22],[0,0,0,nMB],4,1,wf8(:,35))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(305),m3h2x32(:,785),heltab2x64(:,:,1013))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1014),h0tab(:,1014),[32,8,1,22],[nMZ,0,0,nMB],4,1,wf8(:,35))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(306),ngZd,m3h2x32(:,786),heltab2x64(:,:,1014))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1015),h0tab(:,1015),[32,8,1,22],[0,0,nMZ,nMB],4,1,wf8(:,35))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(307),m3h2x32(:,787),heltab2x64(:,:,1015))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1016),h0tab(:,1016),[32,8,1,22],[nMZ,0,nMZ,nMB],4,1,wf8(:,35))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(308),ngZd,m3h2x32(:,788),heltab2x64(:,:,1016))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1017),h0tab(:,1017),[38,8,1,16],[0,0,0,nMB],4,1,wf8(:,92))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,92),G0H8(14),m3h8x8(:,19),heltab2x64(:,:,1017))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1018),h0tab(:,1018),[38,8,1,16],[nMZ,0,0,nMB],4,1,wf8(:,92))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,92),G0H8(16),ngZd,m3h8x8(:,20),heltab2x64(:,:,1018))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1019),h0tab(:,1019),[38,8,1,16],[0,0,nMZ,nMB],4,1,wf8(:,92))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,92),G0H8(17),m3h8x8(:,21),heltab2x64(:,:,1019))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1020),h0tab(:,1020),[38,8,1,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,92))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,92),G0H8(19),ngZd,m3h8x8(:,22),heltab2x64(:,:,1020))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1021),h0tab(:,1021),[38,8,1,16],[0,0,0,nMB],4,1,wf8(:,93))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,93),G0H8(20),m3h8x8(:,23),heltab2x64(:,:,1021))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1022),h0tab(:,1022),[38,8,1,16],[nMZ,0,0,nMB],4,1,wf8(:,93))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,93),G0H8(22),ngZd,m3h8x8(:,24),heltab2x64(:,:,1022))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1023),h0tab(:,1023),[38,8,1,16],[0,0,nMZ,nMB],4,1,wf8(:,93))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,93),G0H8(23),m3h8x8(:,25),heltab2x64(:,:,1023))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1024),h0tab(:,1024),[38,8,1,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,93))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,93),G0H8(26),ngZd,m3h8x8(:,26),heltab2x64(:,:,1024))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1025),h0tab(:,1025),[38,1,8,16],[0,0,0,nMB],4,1,wf8(:,92))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,92),G0H8(27),m3h8x8(:,27),heltab2x64(:,:,1025))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1026),h0tab(:,1026),[38,1,8,16],[0,0,nMZ,nMB],4,1,wf8(:,92))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,92),G0H8(28),m3h8x8(:,28),heltab2x64(:,:,1026))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1027),h0tab(:,1027),[38,1,8,16],[nMZ,0,0,nMB],4,1,wf8(:,92))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,92),G0H8(29),ngZd,m3h8x8(:,29),heltab2x64(:,:,1027))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1028),h0tab(:,1028),[38,1,8,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,92))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,92),G0H8(30),ngZd,m3h8x8(:,30),heltab2x64(:,:,1028))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1029),h0tab(:,1029),[38,1,8,16],[nMW,0,nMW,nMT],4,1,wf8(:,92))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,92),G0H8(31),m3h8x8(:,31),heltab2x64(:,:,1029))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1030),h0tab(:,1030),[38,1,8,16],[0,0,0,nMB],4,1,wf8(:,93))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,93),G0H8(32),m3h8x8(:,32),heltab2x64(:,:,1030))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1031),h0tab(:,1031),[38,1,8,16],[0,0,nMZ,nMB],4,1,wf8(:,93))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,93),G0H8(33),m3h8x8(:,33),heltab2x64(:,:,1031))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1032),h0tab(:,1032),[38,1,8,16],[nMZ,0,0,nMB],4,1,wf8(:,93))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,93),G0H8(34),ngZd,m3h8x8(:,34),heltab2x64(:,:,1032))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1033),h0tab(:,1033),[38,1,8,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,93))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,93),G0H8(35),ngZd,m3h8x8(:,35),heltab2x64(:,:,1033))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1034),h0tab(:,1034),[38,1,8,16],[nMW,0,nMW,nMT],4,1,wf8(:,93))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,93),G0H8(36),m3h8x8(:,36),heltab2x64(:,:,1034))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1035),h0tab(:,1035),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,10))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(117),m3h4x16(:,211),heltab2x64(:,:,1035))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1036),h0tab(:,1036),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,10))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(118),m3h4x16(:,212),heltab2x64(:,:,1036))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1037),h0tab(:,1037),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(119),m3h4x16(:,213),heltab2x64(:,:,1037))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1038),h0tab(:,1038),[48,4,2,9],[nMZ,0,nMZ,nMH],4,2,wf4(:,36),wf4(:,8))
  call Hloop_TS_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(120),m3h4x16(:,214),heltab2x64(:,:,1038))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1039),h0tab(:,1039),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(121),m3h4x16(:,215),heltab2x64(:,:,1039))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1040),h0tab(:,1040),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,10))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(35),m3h4x16(:,216),heltab2x64(:,:,1040))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1041),h0tab(:,1041),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(36),m3h4x16(:,217),heltab2x64(:,:,1041))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(548)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1042),h0tab(:,1042),[48,4,2,9],[0,0,0,0],4,2,wf4(:,6),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(37),m3h4x16(:,218),heltab2x64(:,:,1042))
  call Hloop_Q_A(ntryL,G0H16(37),48,0,G1H16(122),n2h16(397))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(548)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1043),h0tab(:,1043),[48,4,2,9],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(37),m3h4x16(:,219),heltab2x64(:,:,1043))
  call Hloop_Q_A(ntryL,G0H16(37),48,0,G1H16(123),n2h16(398))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1044),h0tab(:,1044),[48,4,2,9],[0,0,0,0],4,2,wf4(:,7),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(37),ngZl,m3h4x16(:,220),heltab2x64(:,:,1044))
  call Hloop_Q_A(ntryL,G0H16(37),48,0,G1H16(124),n2h16(399))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1045),h0tab(:,1045),[48,4,2,9],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(37),ngZl,m3h4x16(:,221),heltab2x64(:,:,1045))
  call Hloop_Q_A(ntryL,G0H16(37),48,0,G1H16(125),n2h16(400))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1046),h0tab(:,1046),[48,4,2,9],[0,0,0,0],4,2,wf4(:,6),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(37),m3h4x16(:,222),heltab2x64(:,:,1046))
  call Hloop_Q_A(ntryL,G0H16(37),48,0,G1H16(126),n2h16(401))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1047),h0tab(:,1047),[48,4,2,9],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(37),m3h4x16(:,223),heltab2x64(:,:,1047))
  call Hloop_Q_A(ntryL,G0H16(37),48,0,G1H16(127),n2h16(402))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1048),h0tab(:,1048),[48,4,2,9],[0,0,0,0],4,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(37),ngZl,m3h4x16(:,224),heltab2x64(:,:,1048))
  call Hloop_Q_A(ntryL,G0H16(37),48,0,G1H16(128),n2h16(403))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1049),h0tab(:,1049),[48,4,2,9],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(37),ngZl,m3h4x16(:,225),heltab2x64(:,:,1049))
  call Hloop_Q_A(ntryL,G0H16(37),48,0,G1H16(129),n2h16(404))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1050),h0tab(:,1050),[48,4,2,9],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(37),ngZn,m3h4x16(:,226),heltab2x64(:,:,1050))
  call Hloop_Q_A(ntryL,G0H16(37),48,0,G1H16(130),n2h16(405))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(548)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1051),h0tab(:,1051),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(37),m3h4x16(:,227),heltab2x64(:,:,1051))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1052),h0tab(:,1052),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(38),m3h4x16(:,228),heltab2x64(:,:,1052))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1053),h0tab(:,1053),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(39),m3h4x16(:,229),heltab2x64(:,:,1053))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1054),h0tab(:,1054),[48,4,2,9],[nMZ,0,nMZ,nMH],4,2,wf4(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(40),m3h4x16(:,230),heltab2x64(:,:,1054))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1055),h0tab(:,1055),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(41),m3h4x16(:,231),heltab2x64(:,:,1055))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(548)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1056),h0tab(:,1056),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(131),m3h4x16(:,232),heltab2x64(:,:,1056))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1057),h0tab(:,1057),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(132),m3h4x16(:,233),heltab2x64(:,:,1057))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1058),h0tab(:,1058),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(1),m3h4x16(:,234),heltab2x64(:,:,1058))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1059),h0tab(:,1059),[48,4,2,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(2),m3h4x16(:,235),heltab2x64(:,:,1059))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1060),h0tab(:,1060),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,10))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(3),m3h4x16(:,236),heltab2x64(:,:,1060))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1061),h0tab(:,1061),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,10))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(4),m3h4x16(:,237),heltab2x64(:,:,1061))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1062),h0tab(:,1062),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(9),m3h4x16(:,238),heltab2x64(:,:,1062))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1063),h0tab(:,1063),[48,2,4,9],[nMZ,0,nMZ,nMH],4,2,wf4(:,36),wf4(:,8))
  call Hloop_TS_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(10),m3h4x16(:,239),heltab2x64(:,:,1063))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1064),h0tab(:,1064),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(11),m3h4x16(:,240),heltab2x64(:,:,1064))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1065),h0tab(:,1065),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,10))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(42),m3h4x16(:,241),heltab2x64(:,:,1065))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1066),h0tab(:,1066),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(43),m3h4x16(:,242),heltab2x64(:,:,1066))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(548)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1067),h0tab(:,1067),[48,2,4,9],[0,0,0,0],4,2,wf4(:,6),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(44),m3h4x16(:,243),heltab2x64(:,:,1067))
  call Hloop_A_Q(ntryL,G0H16(44),48,0,G1H16(12),n2h16(406))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(548)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1068),h0tab(:,1068),[48,2,4,9],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(44),m3h4x16(:,244),heltab2x64(:,:,1068))
  call Hloop_A_Q(ntryL,G0H16(44),48,0,G1H16(17),n2h16(407))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1069),h0tab(:,1069),[48,2,4,9],[0,0,0,0],4,2,wf4(:,7),wf4(:,10))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(44),ngZl,m3h4x16(:,245),heltab2x64(:,:,1069))
  call Hloop_A_Q(ntryL,G0H16(44),48,0,G1H16(18),n2h16(408))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1070),h0tab(:,1070),[48,2,4,9],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,10))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(44),ngZl,m3h4x16(:,246),heltab2x64(:,:,1070))
  call Hloop_A_Q(ntryL,G0H16(44),48,0,G1H16(19),n2h16(409))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1071),h0tab(:,1071),[48,2,4,9],[0,0,0,0],4,2,wf4(:,6),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(44),m3h4x16(:,247),heltab2x64(:,:,1071))
  call Hloop_A_Q(ntryL,G0H16(44),48,0,G1H16(20),n2h16(410))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1072),h0tab(:,1072),[48,2,4,9],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(44),m3h4x16(:,248),heltab2x64(:,:,1072))
  call Hloop_A_Q(ntryL,G0H16(44),48,0,G1H16(25),n2h16(411))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1073),h0tab(:,1073),[48,2,4,9],[0,0,0,0],4,2,wf4(:,7),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(44),ngZl,m3h4x16(:,249),heltab2x64(:,:,1073))
  call Hloop_A_Q(ntryL,G0H16(44),48,0,G1H16(26),n2h16(412))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1074),h0tab(:,1074),[48,2,4,9],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(44),ngZl,m3h4x16(:,250),heltab2x64(:,:,1074))
  call Hloop_A_Q(ntryL,G0H16(44),48,0,G1H16(27),n2h16(413))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1075),h0tab(:,1075),[48,2,4,9],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(44),ngZn,m3h4x16(:,251),heltab2x64(:,:,1075))
  call Hloop_A_Q(ntryL,G0H16(44),48,0,G1H16(28),n2h16(414))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(548)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1076),h0tab(:,1076),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(44),m3h4x16(:,252),heltab2x64(:,:,1076))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1077),h0tab(:,1077),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(45),m3h4x16(:,253),heltab2x64(:,:,1077))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1078),h0tab(:,1078),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(46),m3h4x16(:,254),heltab2x64(:,:,1078))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1079),h0tab(:,1079),[48,2,4,9],[nMZ,0,nMZ,nMH],4,2,wf4(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(47),m3h4x16(:,255),heltab2x64(:,:,1079))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1080),h0tab(:,1080),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(48),m3h4x16(:,256),heltab2x64(:,:,1080))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(548)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1081),h0tab(:,1081),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(42),m3h4x16(:,257),heltab2x64(:,:,1081))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1082),h0tab(:,1082),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(33),m3h4x16(:,258),heltab2x64(:,:,1082))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1083),h0tab(:,1083),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,8))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(34),m3h4x16(:,259),heltab2x64(:,:,1083))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1084),h0tab(:,1084),[48,2,4,9],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,8))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(35),m3h4x16(:,260),heltab2x64(:,:,1084))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1085),h0tab(:,1085),[48,2,9,4],[nMZ,0,0,nMZ],4,2,wf4(:,3),wf4(:,10))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(49),m3h4x16(:,261),heltab2x64(:,:,1085))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1086),h0tab(:,1086),[48,2,9,4],[nMZ,0,0,nMZ],4,2,wf4(:,3),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(50),m3h4x16(:,262),heltab2x64(:,:,1086))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1087),h0tab(:,1087),[48,2,9,4],[nMW,0,0,nMW],4,2,wf4(:,3),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(51),m3h4x16(:,263),heltab2x64(:,:,1087))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1088),h0tab(:,1088),[48,2,9,4],[nMW,0,0,nMW],4,2,wf4(:,6),wf4(:,8))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(36),m3h4x16(:,264),heltab2x64(:,:,1088))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1089),h0tab(:,1089),[48,2,9,4],[nMW,0,0,nMW],4,2,wf4(:,7),wf4(:,8))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(53),m3h4x16(:,265),heltab2x64(:,:,1089))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1090),h0tab(:,1090),[48,2,9,4],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,10))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(52),ngZn,m3h4x16(:,266),heltab2x64(:,:,1090))
  call Hloop_A_Q(ntryL,G0H16(52),48,0,G1H16(44),n2h16(415))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1091),h0tab(:,1091),[48,2,9,4],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(52),ngZn,m3h4x16(:,267),heltab2x64(:,:,1091))
  call Hloop_A_Q(ntryL,G0H16(52),48,0,G1H16(45),n2h16(416))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1092),h0tab(:,1092),[32,11,4,16],[0,0,0,nMB],4,1,wf8(:,49))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(309),m3h2x32(:,789),heltab2x64(:,:,1092))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1093),h0tab(:,1093),[32,11,4,16],[nMZ,0,0,nMB],4,1,wf8(:,49))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(310),ngZd,m3h2x32(:,790),heltab2x64(:,:,1093))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1094),h0tab(:,1094),[32,11,4,16],[0,0,nMZ,nMB],4,1,wf8(:,49))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(311),m3h2x32(:,791),heltab2x64(:,:,1094))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1095),h0tab(:,1095),[32,11,4,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,49))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(312),ngZd,m3h2x32(:,792),heltab2x64(:,:,1095))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1096),h0tab(:,1096),[32,11,4,16],[nMW,0,nMW,nMT],4,1,wf8(:,49))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(313),m3h2x32(:,793),heltab2x64(:,:,1096))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1097),h0tab(:,1097),[32,11,4,16],[0,0,0,nMB],4,1,wf8(:,52))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(314),m3h2x32(:,794),heltab2x64(:,:,1097))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1098),h0tab(:,1098),[32,11,4,16],[nMZ,0,0,nMB],4,1,wf8(:,52))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(315),ngZd,m3h2x32(:,795),heltab2x64(:,:,1098))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1099),h0tab(:,1099),[32,11,4,16],[0,0,nMZ,nMB],4,1,wf8(:,52))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(316),m3h2x32(:,796),heltab2x64(:,:,1099))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1100),h0tab(:,1100),[32,11,4,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,52))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(317),ngZd,m3h2x32(:,797),heltab2x64(:,:,1100))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1101),h0tab(:,1101),[32,11,4,16],[nMW,0,nMW,nMT],4,1,wf8(:,52))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(318),m3h2x32(:,798),heltab2x64(:,:,1101))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1102),h0tab(:,1102),[32,4,11,16],[0,0,0,nMB],4,1,wf8(:,49))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(319),m3h2x32(:,799),heltab2x64(:,:,1102))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1103),h0tab(:,1103),[32,4,11,16],[0,0,nMZ,nMB],4,1,wf8(:,49))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(320),m3h2x32(:,800),heltab2x64(:,:,1103))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1104),h0tab(:,1104),[32,4,11,16],[nMZ,0,0,nMB],4,1,wf8(:,49))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(321),ngZd,m3h2x32(:,801),heltab2x64(:,:,1104))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1105),h0tab(:,1105),[32,4,11,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,49))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(322),ngZd,m3h2x32(:,802),heltab2x64(:,:,1105))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1106),h0tab(:,1106),[32,4,11,16],[0,0,0,nMB],4,1,wf8(:,52))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(323),m3h2x32(:,803),heltab2x64(:,:,1106))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1107),h0tab(:,1107),[32,4,11,16],[0,0,nMZ,nMB],4,1,wf8(:,52))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(324),m3h2x32(:,804),heltab2x64(:,:,1107))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1108),h0tab(:,1108),[32,4,11,16],[nMZ,0,0,nMB],4,1,wf8(:,52))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(325),ngZd,m3h2x32(:,805),heltab2x64(:,:,1108))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1109),h0tab(:,1109),[32,4,11,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,52))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(326),ngZd,m3h2x32(:,806),heltab2x64(:,:,1109))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1110),h0tab(:,1110),[32,13,2,16],[0,0,0,nMB],4,1,wf8(:,123))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(327),m3h2x32(:,807),heltab2x64(:,:,1110))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1111),h0tab(:,1111),[32,13,2,16],[nMZ,0,0,nMB],4,1,wf8(:,123))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(328),ngZd,m3h2x32(:,808),heltab2x64(:,:,1111))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1112),h0tab(:,1112),[32,13,2,16],[0,0,nMZ,nMB],4,1,wf8(:,123))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(329),m3h2x32(:,809),heltab2x64(:,:,1112))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1113),h0tab(:,1113),[32,13,2,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,123))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(330),ngZd,m3h2x32(:,810),heltab2x64(:,:,1113))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1114),h0tab(:,1114),[32,13,2,16],[0,0,0,nMB],4,1,wf8(:,124))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(331),m3h2x32(:,811),heltab2x64(:,:,1114))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1115),h0tab(:,1115),[32,13,2,16],[nMZ,0,0,nMB],4,1,wf8(:,124))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(332),ngZd,m3h2x32(:,812),heltab2x64(:,:,1115))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1116),h0tab(:,1116),[32,13,2,16],[0,0,nMZ,nMB],4,1,wf8(:,124))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(333),m3h2x32(:,813),heltab2x64(:,:,1116))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1117),h0tab(:,1117),[32,13,2,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,124))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(334),ngZd,m3h2x32(:,814),heltab2x64(:,:,1117))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1118),h0tab(:,1118),[32,2,13,16],[0,0,0,nMB],4,1,wf8(:,123))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(335),m3h2x32(:,815),heltab2x64(:,:,1118))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1119),h0tab(:,1119),[32,2,13,16],[0,0,nMZ,nMB],4,1,wf8(:,123))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(336),m3h2x32(:,816),heltab2x64(:,:,1119))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1120),h0tab(:,1120),[32,2,13,16],[nMZ,0,0,nMB],4,1,wf8(:,123))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(337),ngZd,m3h2x32(:,817),heltab2x64(:,:,1120))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1121),h0tab(:,1121),[32,2,13,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,123))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(338),ngZd,m3h2x32(:,818),heltab2x64(:,:,1121))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1122),h0tab(:,1122),[32,2,13,16],[nMW,0,nMW,nMT],4,1,wf8(:,123))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(339),m3h2x32(:,819),heltab2x64(:,:,1122))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1123),h0tab(:,1123),[32,2,13,16],[0,0,0,nMB],4,1,wf8(:,124))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(340),m3h2x32(:,820),heltab2x64(:,:,1123))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1124),h0tab(:,1124),[32,2,13,16],[0,0,nMZ,nMB],4,1,wf8(:,124))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(341),m3h2x32(:,821),heltab2x64(:,:,1124))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1125),h0tab(:,1125),[32,2,13,16],[nMZ,0,0,nMB],4,1,wf8(:,124))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(342),ngZd,m3h2x32(:,822),heltab2x64(:,:,1125))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1126),h0tab(:,1126),[32,2,13,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,124))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(343),ngZd,m3h2x32(:,823),heltab2x64(:,:,1126))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1127),h0tab(:,1127),[32,2,13,16],[nMW,0,nMW,nMT],4,1,wf8(:,124))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(344),m3h2x32(:,824),heltab2x64(:,:,1127))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1128),h0tab(:,1128),[32,2,4,25],[0,0,0,nMB],4,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(345),m3h2x32(:,825),heltab2x64(:,:,1128))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1129),h0tab(:,1129),[32,2,4,25],[0,0,nMZ,nMB],4,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(346),m3h2x32(:,826),heltab2x64(:,:,1129))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1130),h0tab(:,1130),[32,2,4,25],[nMZ,0,0,nMB],4,1,wf8(:,27))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(347),ngZd,m3h2x32(:,827),heltab2x64(:,:,1130))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1131),h0tab(:,1131),[32,2,4,25],[nMZ,0,nMZ,nMB],4,1,wf8(:,27))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(348),ngZd,m3h2x32(:,828),heltab2x64(:,:,1131))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1132),h0tab(:,1132),[32,2,4,25],[nMW,0,nMW,nMT],4,1,wf8(:,27))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(349),m3h2x32(:,829),heltab2x64(:,:,1132))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1133),h0tab(:,1133),[32,2,4,25],[0,0,0,nMB],4,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(350),m3h2x32(:,830),heltab2x64(:,:,1133))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1134),h0tab(:,1134),[32,2,4,25],[0,0,nMZ,nMB],4,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(351),m3h2x32(:,831),heltab2x64(:,:,1134))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1135),h0tab(:,1135),[32,2,4,25],[nMZ,0,0,nMB],4,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(352),ngZd,m3h2x32(:,832),heltab2x64(:,:,1135))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1136),h0tab(:,1136),[32,2,4,25],[nMZ,0,nMZ,nMB],4,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(353),ngZd,m3h2x32(:,833),heltab2x64(:,:,1136))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1137),h0tab(:,1137),[32,2,4,25],[nMW,0,nMW,nMT],4,1,wf8(:,30))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(354),m3h2x32(:,834),heltab2x64(:,:,1137))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1138),h0tab(:,1138),[32,4,2,25],[0,0,0,nMB],4,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(355),m3h2x32(:,835),heltab2x64(:,:,1138))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1139),h0tab(:,1139),[32,4,2,25],[nMZ,0,0,nMB],4,1,wf8(:,27))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(356),ngZd,m3h2x32(:,836),heltab2x64(:,:,1139))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1140),h0tab(:,1140),[32,4,2,25],[0,0,nMZ,nMB],4,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(357),m3h2x32(:,837),heltab2x64(:,:,1140))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1141),h0tab(:,1141),[32,4,2,25],[nMZ,0,nMZ,nMB],4,1,wf8(:,27))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(358),ngZd,m3h2x32(:,838),heltab2x64(:,:,1141))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1142),h0tab(:,1142),[32,4,2,25],[0,0,0,nMB],4,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(359),m3h2x32(:,839),heltab2x64(:,:,1142))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1143),h0tab(:,1143),[32,4,2,25],[nMZ,0,0,nMB],4,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(360),ngZd,m3h2x32(:,840),heltab2x64(:,:,1143))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1144),h0tab(:,1144),[32,4,2,25],[0,0,nMZ,nMB],4,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(361),m3h2x32(:,841),heltab2x64(:,:,1144))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1145),h0tab(:,1145),[32,4,2,25],[nMZ,0,nMZ,nMB],4,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(362),ngZd,m3h2x32(:,842),heltab2x64(:,:,1145))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1146),h0tab(:,1146),[41,4,2,16],[0,0,0,nMB],4,1,wf8(:,88))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,88),G0H8(37),m3h8x8(:,37),heltab2x64(:,:,1146))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1147),h0tab(:,1147),[41,4,2,16],[nMZ,0,0,nMB],4,1,wf8(:,88))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,88),G0H8(38),ngZd,m3h8x8(:,38),heltab2x64(:,:,1147))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1148),h0tab(:,1148),[41,4,2,16],[0,0,nMZ,nMB],4,1,wf8(:,88))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,88),G0H8(39),m3h8x8(:,39),heltab2x64(:,:,1148))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1149),h0tab(:,1149),[41,4,2,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,88))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,88),G0H8(40),ngZd,m3h8x8(:,40),heltab2x64(:,:,1149))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1150),h0tab(:,1150),[41,4,2,16],[0,0,0,nMB],4,1,wf8(:,90))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,90),G0H8(41),m3h8x8(:,41),heltab2x64(:,:,1150))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1151),h0tab(:,1151),[41,4,2,16],[nMZ,0,0,nMB],4,1,wf8(:,90))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,90),G0H8(42),ngZd,m3h8x8(:,42),heltab2x64(:,:,1151))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1152),h0tab(:,1152),[41,4,2,16],[0,0,nMZ,nMB],4,1,wf8(:,90))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,90),G0H8(43),m3h8x8(:,43),heltab2x64(:,:,1152))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1153),h0tab(:,1153),[41,4,2,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,90))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,90),G0H8(44),ngZd,m3h8x8(:,44),heltab2x64(:,:,1153))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1154),h0tab(:,1154),[41,2,4,16],[0,0,0,nMB],4,1,wf8(:,88))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,88),G0H8(45),m3h8x8(:,45),heltab2x64(:,:,1154))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1155),h0tab(:,1155),[41,2,4,16],[0,0,nMZ,nMB],4,1,wf8(:,88))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,88),G0H8(46),m3h8x8(:,46),heltab2x64(:,:,1155))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1156),h0tab(:,1156),[41,2,4,16],[nMZ,0,0,nMB],4,1,wf8(:,88))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,88),G0H8(47),ngZd,m3h8x8(:,47),heltab2x64(:,:,1156))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1157),h0tab(:,1157),[41,2,4,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,88))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,88),G0H8(48),ngZd,m3h8x8(:,48),heltab2x64(:,:,1157))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1158),h0tab(:,1158),[41,2,4,16],[nMW,0,nMW,nMT],4,1,wf8(:,88))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,88),G0H8(49),m3h8x8(:,49),heltab2x64(:,:,1158))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1159),h0tab(:,1159),[41,2,4,16],[0,0,0,nMB],4,1,wf8(:,90))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,90),G0H8(50),m3h8x8(:,50),heltab2x64(:,:,1159))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1160),h0tab(:,1160),[41,2,4,16],[0,0,nMZ,nMB],4,1,wf8(:,90))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,90),G0H8(51),m3h8x8(:,51),heltab2x64(:,:,1160))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1161),h0tab(:,1161),[41,2,4,16],[nMZ,0,0,nMB],4,1,wf8(:,90))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,90),G0H8(52),ngZd,m3h8x8(:,52),heltab2x64(:,:,1161))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1162),h0tab(:,1162),[41,2,4,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,90))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,90),G0H8(53),ngZd,m3h8x8(:,53),heltab2x64(:,:,1162))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1163),h0tab(:,1163),[41,2,4,16],[nMW,0,nMW,nMT],4,1,wf8(:,90))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,90),G0H8(54),m3h8x8(:,54),heltab2x64(:,:,1163))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(597)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1164),h0tab(:,1164),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(46),m3h4x16(:,268),heltab2x64(:,:,1164))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1165),h0tab(:,1165),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(47),m3h4x16(:,269),heltab2x64(:,:,1165))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1166),h0tab(:,1166),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(64),m3h4x16(:,270),heltab2x64(:,:,1166))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1167),h0tab(:,1167),[48,4,1,10],[nMZ,0,nMZ,nMH],4,2,wf4(:,36),wf4(:,2))
  call Hloop_TS_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(55),m3h4x16(:,271),heltab2x64(:,:,1167))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1168),h0tab(:,1168),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(56),m3h4x16(:,272),heltab2x64(:,:,1168))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(597)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1169),h0tab(:,1169),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(52),m3h4x16(:,273),heltab2x64(:,:,1169))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1170),h0tab(:,1170),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(53),m3h4x16(:,274),heltab2x64(:,:,1170))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1171),h0tab(:,1171),[48,4,1,10],[0,0,0,0],4,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(54),m3h4x16(:,275),heltab2x64(:,:,1171))
  call Hloop_Q_A(ntryL,G0H16(54),48,0,G1H16(57),n2h16(417))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1172),h0tab(:,1172),[48,4,1,10],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(54),m3h4x16(:,276),heltab2x64(:,:,1172))
  call Hloop_Q_A(ntryL,G0H16(54),48,0,G1H16(58),n2h16(418))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1173),h0tab(:,1173),[48,4,1,10],[0,0,0,0],4,2,wf4(:,7),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(54),ngZl,m3h4x16(:,277),heltab2x64(:,:,1173))
  call Hloop_Q_A(ntryL,G0H16(54),48,0,G1H16(75),n2h16(419))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1174),h0tab(:,1174),[48,4,1,10],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(54),ngZl,m3h4x16(:,278),heltab2x64(:,:,1174))
  call Hloop_Q_A(ntryL,G0H16(54),48,0,G1H16(66),n2h16(420))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1175),h0tab(:,1175),[48,4,1,10],[0,0,0,0],4,2,wf4(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(54),m3h4x16(:,279),heltab2x64(:,:,1175))
  call Hloop_Q_A(ntryL,G0H16(54),48,0,G1H16(67),n2h16(421))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1176),h0tab(:,1176),[48,4,1,10],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(54),m3h4x16(:,280),heltab2x64(:,:,1176))
  call Hloop_Q_A(ntryL,G0H16(54),48,0,G1H16(68),n2h16(422))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1177),h0tab(:,1177),[48,4,1,10],[0,0,0,0],4,2,wf4(:,7),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(54),ngZl,m3h4x16(:,281),heltab2x64(:,:,1177))
  call Hloop_Q_A(ntryL,G0H16(54),48,0,G1H16(69),n2h16(423))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1178),h0tab(:,1178),[48,4,1,10],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(54),ngZl,m3h4x16(:,282),heltab2x64(:,:,1178))
  call Hloop_Q_A(ntryL,G0H16(54),48,0,G1H16(133),n2h16(424))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1179),h0tab(:,1179),[48,4,1,10],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(54),ngZn,m3h4x16(:,283),heltab2x64(:,:,1179))
  call Hloop_Q_A(ntryL,G0H16(54),48,0,G1H16(134),n2h16(425))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1180),h0tab(:,1180),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(54),m3h4x16(:,284),heltab2x64(:,:,1180))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1181),h0tab(:,1181),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(55),m3h4x16(:,285),heltab2x64(:,:,1181))
  Gcoeff(:)%j = (c(131)*M(1,:)%j) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1182),h0tab(:,1182),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(56),m3h4x16(:,286),heltab2x64(:,:,1182))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1183),h0tab(:,1183),[48,4,1,10],[nMZ,0,nMZ,nMH],4,2,wf4(:,7),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(57),m3h4x16(:,287),heltab2x64(:,:,1183))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1184),h0tab(:,1184),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(58),m3h4x16(:,288),heltab2x64(:,:,1184))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1185),h0tab(:,1185),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(135),m3h4x16(:,289),heltab2x64(:,:,1185))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1186),h0tab(:,1186),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(136),m3h4x16(:,290),heltab2x64(:,:,1186))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1187),h0tab(:,1187),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(137),m3h4x16(:,291),heltab2x64(:,:,1187))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1188),h0tab(:,1188),[48,4,1,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(138),m3h4x16(:,292),heltab2x64(:,:,1188))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(597)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1189),h0tab(:,1189),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(139),m3h4x16(:,293),heltab2x64(:,:,1189))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1190),h0tab(:,1190),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(140),m3h4x16(:,294),heltab2x64(:,:,1190))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1191),h0tab(:,1191),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(141),m3h4x16(:,295),heltab2x64(:,:,1191))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1192),h0tab(:,1192),[48,1,4,10],[nMZ,0,nMZ,nMH],4,2,wf4(:,36),wf4(:,2))
  call Hloop_TS_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(142),m3h4x16(:,296),heltab2x64(:,:,1192))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1193),h0tab(:,1193),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,36),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H64(1),0,wf4(:,36),48,G1H16(143),m3h4x16(:,297),heltab2x64(:,:,1193))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(597)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1194),h0tab(:,1194),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(59),m3h4x16(:,298),heltab2x64(:,:,1194))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1195),h0tab(:,1195),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(60),m3h4x16(:,299),heltab2x64(:,:,1195))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1196),h0tab(:,1196),[48,1,4,10],[0,0,0,0],4,2,wf4(:,6),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(61),m3h4x16(:,300),heltab2x64(:,:,1196))
  call Hloop_A_Q(ntryL,G0H16(61),48,0,G1H16(144),n2h16(426))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1197),h0tab(:,1197),[48,1,4,10],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(61),m3h4x16(:,301),heltab2x64(:,:,1197))
  call Hloop_A_Q(ntryL,G0H16(61),48,0,G1H16(145),n2h16(427))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1198),h0tab(:,1198),[48,1,4,10],[0,0,0,0],4,2,wf4(:,7),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(61),ngZl,m3h4x16(:,302),heltab2x64(:,:,1198))
  call Hloop_A_Q(ntryL,G0H16(61),48,0,G1H16(146),n2h16(428))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1199),h0tab(:,1199),[48,1,4,10],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(61),ngZl,m3h4x16(:,303),heltab2x64(:,:,1199))
  call Hloop_A_Q(ntryL,G0H16(61),48,0,G1H16(147),n2h16(429))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1200),h0tab(:,1200),[48,1,4,10],[0,0,0,0],4,2,wf4(:,6),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(61),m3h4x16(:,304),heltab2x64(:,:,1200))
  call Hloop_A_Q(ntryL,G0H16(61),48,0,G1H16(148),n2h16(430))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1201),h0tab(:,1201),[48,1,4,10],[0,nMZ,0,0],4,2,wf4(:,6),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(61),m3h4x16(:,305),heltab2x64(:,:,1201))
  call Hloop_A_Q(ntryL,G0H16(61),48,0,G1H16(149),n2h16(431))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1202),h0tab(:,1202),[48,1,4,10],[0,0,0,0],4,2,wf4(:,7),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(61),ngZl,m3h4x16(:,306),heltab2x64(:,:,1202))
  call Hloop_A_Q(ntryL,G0H16(61),48,0,G1H16(150),n2h16(432))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1203),h0tab(:,1203),[48,1,4,10],[0,nMZ,0,0],4,2,wf4(:,7),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(61),ngZl,m3h4x16(:,307),heltab2x64(:,:,1203))
  call Hloop_A_Q(ntryL,G0H16(61),48,0,G1H16(151),n2h16(433))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1204),h0tab(:,1204),[48,1,4,10],[0,nMW,0,0],4,2,wf4(:,7),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(61),ngZn,m3h4x16(:,308),heltab2x64(:,:,1204))
  call Hloop_A_Q(ntryL,G0H16(61),48,0,G1H16(152),n2h16(434))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1205),h0tab(:,1205),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(61),m3h4x16(:,309),heltab2x64(:,:,1205))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1206),h0tab(:,1206),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,5))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(62),m3h4x16(:,310),heltab2x64(:,:,1206))
  Gcoeff(:)%j = (c(131)*M(1,:)%j) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1207),h0tab(:,1207),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,6),G0H16(63),m3h4x16(:,311),heltab2x64(:,:,1207))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1208),h0tab(:,1208),[48,1,4,10],[nMZ,0,nMZ,nMH],4,2,wf4(:,7),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(64),m3h4x16(:,312),heltab2x64(:,:,1208))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1209),h0tab(:,1209),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,7),G0H16(65),m3h4x16(:,313),heltab2x64(:,:,1209))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1210),h0tab(:,1210),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,5))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(153),m3h4x16(:,314),heltab2x64(:,:,1210))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1211),h0tab(:,1211),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,5))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(154),m3h4x16(:,315),heltab2x64(:,:,1211))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1212),h0tab(:,1212),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,6),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(155),m3h4x16(:,316),heltab2x64(:,:,1212))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1213),h0tab(:,1213),[48,1,4,10],[nMW,0,nMW,nMW],4,2,wf4(:,7),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(156),m3h4x16(:,317),heltab2x64(:,:,1213))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(597)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1214),h0tab(:,1214),[48,1,10,4],[nMZ,0,0,nMZ],4,2,wf4(:,3),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(66),m3h4x16(:,318),heltab2x64(:,:,1214))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1215),h0tab(:,1215),[48,1,10,4],[nMZ,0,0,nMZ],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(67),m3h4x16(:,319),heltab2x64(:,:,1215))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1216),h0tab(:,1216),[48,1,10,4],[nMW,0,0,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H64(1),wf4(:,3),G0H16(68),m3h4x16(:,320),heltab2x64(:,:,1216))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1217),h0tab(:,1217),[48,1,10,4],[nMW,0,0,nMW],4,2,wf4(:,6),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,6),48,G1H16(157),m3h4x16(:,321),heltab2x64(:,:,1217))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1218),h0tab(:,1218),[48,1,10,4],[nMW,0,0,nMW],4,2,wf4(:,7),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(158),m3h4x16(:,322),heltab2x64(:,:,1218))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1219),h0tab(:,1219),[48,1,10,4],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(69),ngZn,m3h4x16(:,323),heltab2x64(:,:,1219))
  call Hloop_A_Q(ntryL,G0H16(69),48,0,G1H16(159),n2h16(435))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1220),h0tab(:,1220),[48,1,10,4],[0,nMW,nMW,0],4,2,wf4(:,7),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(69),ngZn,m3h4x16(:,324),heltab2x64(:,:,1220))
  call Hloop_A_Q(ntryL,G0H16(69),48,0,G1H16(160),n2h16(436))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1221),h0tab(:,1221),[32,11,4,16],[0,0,0,nMB],4,1,wf8(:,56))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(363),m3h2x32(:,843),heltab2x64(:,:,1221))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1222),h0tab(:,1222),[32,11,4,16],[nMZ,0,0,nMB],4,1,wf8(:,56))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(364),ngZd,m3h2x32(:,844),heltab2x64(:,:,1222))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1223),h0tab(:,1223),[32,11,4,16],[0,0,nMZ,nMB],4,1,wf8(:,56))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(365),m3h2x32(:,845),heltab2x64(:,:,1223))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1224),h0tab(:,1224),[32,11,4,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,56))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(366),ngZd,m3h2x32(:,846),heltab2x64(:,:,1224))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1225),h0tab(:,1225),[32,11,4,16],[nMW,0,nMW,nMT],4,1,wf8(:,56))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(367),m3h2x32(:,847),heltab2x64(:,:,1225))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1226),h0tab(:,1226),[32,11,4,16],[0,0,0,nMB],4,1,wf8(:,58))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(368),m3h2x32(:,848),heltab2x64(:,:,1226))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1227),h0tab(:,1227),[32,11,4,16],[nMZ,0,0,nMB],4,1,wf8(:,58))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(369),ngZd,m3h2x32(:,849),heltab2x64(:,:,1227))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1228),h0tab(:,1228),[32,11,4,16],[0,0,nMZ,nMB],4,1,wf8(:,58))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(370),m3h2x32(:,850),heltab2x64(:,:,1228))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1229),h0tab(:,1229),[32,11,4,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,58))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(371),ngZd,m3h2x32(:,851),heltab2x64(:,:,1229))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1230),h0tab(:,1230),[32,11,4,16],[nMW,0,nMW,nMT],4,1,wf8(:,58))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(372),m3h2x32(:,852),heltab2x64(:,:,1230))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1231),h0tab(:,1231),[32,4,11,16],[0,0,0,nMB],4,1,wf8(:,56))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(373),m3h2x32(:,853),heltab2x64(:,:,1231))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1232),h0tab(:,1232),[32,4,11,16],[0,0,nMZ,nMB],4,1,wf8(:,56))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(374),m3h2x32(:,854),heltab2x64(:,:,1232))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1233),h0tab(:,1233),[32,4,11,16],[nMZ,0,0,nMB],4,1,wf8(:,56))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(375),ngZd,m3h2x32(:,855),heltab2x64(:,:,1233))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1234),h0tab(:,1234),[32,4,11,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,56))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(376),ngZd,m3h2x32(:,856),heltab2x64(:,:,1234))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1235),h0tab(:,1235),[32,4,11,16],[0,0,0,nMB],4,1,wf8(:,58))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(377),m3h2x32(:,857),heltab2x64(:,:,1235))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1236),h0tab(:,1236),[32,4,11,16],[0,0,nMZ,nMB],4,1,wf8(:,58))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(378),m3h2x32(:,858),heltab2x64(:,:,1236))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1237),h0tab(:,1237),[32,4,11,16],[nMZ,0,0,nMB],4,1,wf8(:,58))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(379),ngZd,m3h2x32(:,859),heltab2x64(:,:,1237))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1238),h0tab(:,1238),[32,4,11,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,58))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(380),ngZd,m3h2x32(:,860),heltab2x64(:,:,1238))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1239),h0tab(:,1239),[32,14,1,16],[0,0,0,nMB],4,1,wf8(:,161))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(381),m3h2x32(:,861),heltab2x64(:,:,1239))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1240),h0tab(:,1240),[32,14,1,16],[nMZ,0,0,nMB],4,1,wf8(:,161))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(382),ngZd,m3h2x32(:,862),heltab2x64(:,:,1240))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1241),h0tab(:,1241),[32,14,1,16],[0,0,nMZ,nMB],4,1,wf8(:,161))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(383),m3h2x32(:,863),heltab2x64(:,:,1241))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1242),h0tab(:,1242),[32,14,1,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,161))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(384),ngZd,m3h2x32(:,864),heltab2x64(:,:,1242))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1243),h0tab(:,1243),[32,14,1,16],[0,0,0,nMB],4,1,wf8(:,162))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(385),m3h2x32(:,865),heltab2x64(:,:,1243))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1244),h0tab(:,1244),[32,14,1,16],[nMZ,0,0,nMB],4,1,wf8(:,162))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(386),ngZd,m3h2x32(:,866),heltab2x64(:,:,1244))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1245),h0tab(:,1245),[32,14,1,16],[0,0,nMZ,nMB],4,1,wf8(:,162))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(387),m3h2x32(:,867),heltab2x64(:,:,1245))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1246),h0tab(:,1246),[32,14,1,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,162))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(388),ngZd,m3h2x32(:,868),heltab2x64(:,:,1246))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1247),h0tab(:,1247),[32,1,14,16],[0,0,0,nMB],4,1,wf8(:,161))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(389),m3h2x32(:,869),heltab2x64(:,:,1247))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1248),h0tab(:,1248),[32,1,14,16],[0,0,nMZ,nMB],4,1,wf8(:,161))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(390),m3h2x32(:,870),heltab2x64(:,:,1248))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1249),h0tab(:,1249),[32,1,14,16],[nMZ,0,0,nMB],4,1,wf8(:,161))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(391),ngZd,m3h2x32(:,871),heltab2x64(:,:,1249))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1250),h0tab(:,1250),[32,1,14,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,161))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(392),ngZd,m3h2x32(:,872),heltab2x64(:,:,1250))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1251),h0tab(:,1251),[32,1,14,16],[nMW,0,nMW,nMT],4,1,wf8(:,161))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(393),m3h2x32(:,873),heltab2x64(:,:,1251))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1252),h0tab(:,1252),[32,1,14,16],[0,0,0,nMB],4,1,wf8(:,162))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(394),m3h2x32(:,874),heltab2x64(:,:,1252))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1253),h0tab(:,1253),[32,1,14,16],[0,0,nMZ,nMB],4,1,wf8(:,162))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(395),m3h2x32(:,875),heltab2x64(:,:,1253))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1254),h0tab(:,1254),[32,1,14,16],[nMZ,0,0,nMB],4,1,wf8(:,162))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(396),ngZd,m3h2x32(:,876),heltab2x64(:,:,1254))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1255),h0tab(:,1255),[32,1,14,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,162))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(397),ngZd,m3h2x32(:,877),heltab2x64(:,:,1255))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1256),h0tab(:,1256),[32,1,14,16],[nMW,0,nMW,nMT],4,1,wf8(:,162))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(398),m3h2x32(:,878),heltab2x64(:,:,1256))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1257),h0tab(:,1257),[32,1,4,26],[0,0,0,nMB],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(399),m3h2x32(:,879),heltab2x64(:,:,1257))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1258),h0tab(:,1258),[32,1,4,26],[0,0,nMZ,nMB],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(400),m3h2x32(:,880),heltab2x64(:,:,1258))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1259),h0tab(:,1259),[32,1,4,26],[nMZ,0,0,nMB],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(401),ngZd,m3h2x32(:,881),heltab2x64(:,:,1259))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1260),h0tab(:,1260),[32,1,4,26],[nMZ,0,nMZ,nMB],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(402),ngZd,m3h2x32(:,882),heltab2x64(:,:,1260))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1261),h0tab(:,1261),[32,1,4,26],[nMW,0,nMW,nMT],4,1,wf8(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(403),m3h2x32(:,883),heltab2x64(:,:,1261))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1262),h0tab(:,1262),[32,1,4,26],[0,0,0,nMB],4,1,wf8(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(404),m3h2x32(:,884),heltab2x64(:,:,1262))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1263),h0tab(:,1263),[32,1,4,26],[0,0,nMZ,nMB],4,1,wf8(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(405),m3h2x32(:,885),heltab2x64(:,:,1263))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1264),h0tab(:,1264),[32,1,4,26],[nMZ,0,0,nMB],4,1,wf8(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(406),ngZd,m3h2x32(:,886),heltab2x64(:,:,1264))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1265),h0tab(:,1265),[32,1,4,26],[nMZ,0,nMZ,nMB],4,1,wf8(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(407),ngZd,m3h2x32(:,887),heltab2x64(:,:,1265))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1266),h0tab(:,1266),[32,1,4,26],[nMW,0,nMW,nMT],4,1,wf8(:,11))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(408),m3h2x32(:,888),heltab2x64(:,:,1266))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1267),h0tab(:,1267),[32,4,1,26],[0,0,0,nMB],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(409),m3h2x32(:,889),heltab2x64(:,:,1267))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1268),h0tab(:,1268),[32,4,1,26],[nMZ,0,0,nMB],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(410),ngZd,m3h2x32(:,890),heltab2x64(:,:,1268))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1269),h0tab(:,1269),[32,4,1,26],[0,0,nMZ,nMB],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(411),m3h2x32(:,891),heltab2x64(:,:,1269))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1270),h0tab(:,1270),[32,4,1,26],[nMZ,0,nMZ,nMB],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(412),ngZd,m3h2x32(:,892),heltab2x64(:,:,1270))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1271),h0tab(:,1271),[32,4,1,26],[0,0,0,nMB],4,1,wf8(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(413),m3h2x32(:,893),heltab2x64(:,:,1271))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1272),h0tab(:,1272),[32,4,1,26],[nMZ,0,0,nMB],4,1,wf8(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(414),ngZd,m3h2x32(:,894),heltab2x64(:,:,1272))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1273),h0tab(:,1273),[32,4,1,26],[0,0,nMZ,nMB],4,1,wf8(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(415),m3h2x32(:,895),heltab2x64(:,:,1273))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1274),h0tab(:,1274),[32,4,1,26],[nMZ,0,nMZ,nMB],4,1,wf8(:,11))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(416),ngZd,m3h2x32(:,896),heltab2x64(:,:,1274))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1275),h0tab(:,1275),[42,4,1,16],[0,0,0,nMB],4,1,wf8(:,70))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,70),G0H8(55),m3h8x8(:,55),heltab2x64(:,:,1275))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1276),h0tab(:,1276),[42,4,1,16],[nMZ,0,0,nMB],4,1,wf8(:,70))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,70),G0H8(56),ngZd,m3h8x8(:,56),heltab2x64(:,:,1276))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1277),h0tab(:,1277),[42,4,1,16],[0,0,nMZ,nMB],4,1,wf8(:,70))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,70),G0H8(57),m3h8x8(:,57),heltab2x64(:,:,1277))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1278),h0tab(:,1278),[42,4,1,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,70))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,70),G0H8(58),ngZd,m3h8x8(:,58),heltab2x64(:,:,1278))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1279),h0tab(:,1279),[42,4,1,16],[0,0,0,nMB],4,1,wf8(:,71))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,71),G0H8(59),m3h8x8(:,59),heltab2x64(:,:,1279))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1280),h0tab(:,1280),[42,4,1,16],[nMZ,0,0,nMB],4,1,wf8(:,71))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,71),G0H8(60),ngZd,m3h8x8(:,60),heltab2x64(:,:,1280))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1281),h0tab(:,1281),[42,4,1,16],[0,0,nMZ,nMB],4,1,wf8(:,71))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,71),G0H8(61),m3h8x8(:,61),heltab2x64(:,:,1281))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1282),h0tab(:,1282),[42,4,1,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,71))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,71),G0H8(62),ngZd,m3h8x8(:,62),heltab2x64(:,:,1282))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1283),h0tab(:,1283),[42,1,4,16],[0,0,0,nMB],4,1,wf8(:,70))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,70),G0H8(63),m3h8x8(:,63),heltab2x64(:,:,1283))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1284),h0tab(:,1284),[42,1,4,16],[0,0,nMZ,nMB],4,1,wf8(:,70))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,70),G0H8(64),m3h8x8(:,64),heltab2x64(:,:,1284))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1285),h0tab(:,1285),[42,1,4,16],[nMZ,0,0,nMB],4,1,wf8(:,70))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,70),G0H8(65),ngZd,m3h8x8(:,65),heltab2x64(:,:,1285))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1286),h0tab(:,1286),[42,1,4,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,70))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,70),G0H8(66),ngZd,m3h8x8(:,66),heltab2x64(:,:,1286))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1287),h0tab(:,1287),[42,1,4,16],[nMW,0,nMW,nMT],4,1,wf8(:,70))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,70),G0H8(67),m3h8x8(:,67),heltab2x64(:,:,1287))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1288),h0tab(:,1288),[42,1,4,16],[0,0,0,nMB],4,1,wf8(:,71))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,71),G0H8(68),m3h8x8(:,68),heltab2x64(:,:,1288))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1289),h0tab(:,1289),[42,1,4,16],[0,0,nMZ,nMB],4,1,wf8(:,71))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,71),G0H8(69),m3h8x8(:,69),heltab2x64(:,:,1289))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1290),h0tab(:,1290),[42,1,4,16],[nMZ,0,0,nMB],4,1,wf8(:,71))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,71),G0H8(70),ngZd,m3h8x8(:,70),heltab2x64(:,:,1290))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1291),h0tab(:,1291),[42,1,4,16],[nMZ,0,nMZ,nMB],4,1,wf8(:,71))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,71),G0H8(71),ngZd,m3h8x8(:,71),heltab2x64(:,:,1291))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1292),h0tab(:,1292),[42,1,4,16],[nMW,0,nMW,nMT],4,1,wf8(:,71))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,71),G0H8(72),m3h8x8(:,72),heltab2x64(:,:,1292))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1293),h0tab(:,1293),[49,4,2,8],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,43),G0H8(73),m3h8x8(:,73),heltab2x64(:,:,1293))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1294),h0tab(:,1294),[49,4,2,8],[nMZ,0,0,0],4,1,wf8(:,43))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,43),G0H8(74),ngZl,m3h8x8(:,74),heltab2x64(:,:,1294))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1295),h0tab(:,1295),[49,4,2,8],[0,0,nMZ,0],4,1,wf8(:,43))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,43),G0H8(75),m3h8x8(:,75),heltab2x64(:,:,1295))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1296),h0tab(:,1296),[49,4,2,8],[nMZ,0,nMZ,0],4,1,wf8(:,43))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,43),G0H8(76),ngZl,m3h8x8(:,76),heltab2x64(:,:,1296))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1297),h0tab(:,1297),[49,4,2,8],[nMW,0,nMW,0],4,1,wf8(:,43))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,43),G0H8(77),m3h8x8(:,77),heltab2x64(:,:,1297))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1298),h0tab(:,1298),[49,4,2,8],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,46),G0H8(78),m3h8x8(:,78),heltab2x64(:,:,1298))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1299),h0tab(:,1299),[49,4,2,8],[nMZ,0,0,0],4,1,wf8(:,46))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,46),G0H8(79),ngZl,m3h8x8(:,79),heltab2x64(:,:,1299))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1300),h0tab(:,1300),[49,4,2,8],[0,0,nMZ,0],4,1,wf8(:,46))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,46),G0H8(80),m3h8x8(:,80),heltab2x64(:,:,1300))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1301),h0tab(:,1301),[49,4,2,8],[nMZ,0,nMZ,0],4,1,wf8(:,46))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,46),G0H8(81),ngZl,m3h8x8(:,81),heltab2x64(:,:,1301))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1302),h0tab(:,1302),[49,4,2,8],[nMW,0,nMW,0],4,1,wf8(:,46))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,46),G0H8(82),m3h8x8(:,82),heltab2x64(:,:,1302))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1303),h0tab(:,1303),[49,4,2,8],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,43),G0H8(83),m3h8x8(:,83),heltab2x64(:,:,1303))
  call Hloop_Q_A(ntryL,G0H8(83),49,0,G1H8(25),n2h8(37))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1304),h0tab(:,1304),[49,4,2,8],[0,0,0,nMZ],4,1,wf8(:,43))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,43),G0H8(83),ngZl,m3h8x8(:,84),heltab2x64(:,:,1304))
  call Hloop_Q_A(ntryL,G0H8(83),49,0,G1H8(26),n2h8(38))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1305),h0tab(:,1305),[49,4,2,8],[0,nMZ,0,0],4,1,wf8(:,43))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,43),G0H8(83),m3h8x8(:,85),heltab2x64(:,:,1305))
  call Hloop_Q_A(ntryL,G0H8(83),49,0,G1H8(27),n2h8(39))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1306),h0tab(:,1306),[49,4,2,8],[0,nMZ,0,nMZ],4,1,wf8(:,43))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,43),G0H8(83),ngZl,m3h8x8(:,86),heltab2x64(:,:,1306))
  call Hloop_Q_A(ntryL,G0H8(83),49,0,G1H8(28),n2h8(40))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1307),h0tab(:,1307),[49,4,2,8],[0,nMW,0,nMW],4,1,wf8(:,43))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,43),G0H8(83),m3h8x8(:,87),heltab2x64(:,:,1307))
  call Hloop_Q_A(ntryL,G0H8(83),49,0,G1H8(29),n2h8(41))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1308),h0tab(:,1308),[49,4,2,8],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,46),G0H8(83),m3h8x8(:,88),heltab2x64(:,:,1308))
  call Hloop_Q_A(ntryL,G0H8(83),49,0,G1H8(30),n2h8(42))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1309),h0tab(:,1309),[49,4,2,8],[0,0,0,nMZ],4,1,wf8(:,46))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,46),G0H8(83),ngZl,m3h8x8(:,89),heltab2x64(:,:,1309))
  call Hloop_Q_A(ntryL,G0H8(83),49,0,G1H8(31),n2h8(43))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1310),h0tab(:,1310),[49,4,2,8],[0,nMZ,0,0],4,1,wf8(:,46))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,46),G0H8(83),m3h8x8(:,90),heltab2x64(:,:,1310))
  call Hloop_Q_A(ntryL,G0H8(83),49,0,G1H8(32),n2h8(44))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1311),h0tab(:,1311),[49,4,2,8],[0,nMZ,0,nMZ],4,1,wf8(:,46))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,46),G0H8(83),ngZl,m3h8x8(:,91),heltab2x64(:,:,1311))
  call Hloop_Q_A(ntryL,G0H8(83),49,0,G1H8(33),n2h8(45))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1312),h0tab(:,1312),[49,4,2,8],[0,nMW,0,nMW],4,1,wf8(:,46))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,46),G0H8(83),m3h8x8(:,92),heltab2x64(:,:,1312))
  call Hloop_Q_A(ntryL,G0H8(83),49,0,G1H8(34),n2h8(46))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1313),h0tab(:,1313),[49,2,4,8],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,43),G0H8(83),m3h8x8(:,93),heltab2x64(:,:,1313))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1314),h0tab(:,1314),[49,2,4,8],[0,0,nMZ,0],4,1,wf8(:,43))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,43),G0H8(84),m3h8x8(:,94),heltab2x64(:,:,1314))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1315),h0tab(:,1315),[49,2,4,8],[nMZ,0,0,0],4,1,wf8(:,43))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,43),G0H8(85),ngZl,m3h8x8(:,95),heltab2x64(:,:,1315))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1316),h0tab(:,1316),[49,2,4,8],[nMZ,0,nMZ,0],4,1,wf8(:,43))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,43),G0H8(86),ngZl,m3h8x8(:,96),heltab2x64(:,:,1316))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1317),h0tab(:,1317),[49,2,4,8],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,46),G0H8(87),m3h8x8(:,97),heltab2x64(:,:,1317))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1318),h0tab(:,1318),[49,2,4,8],[0,0,nMZ,0],4,1,wf8(:,46))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,46),G0H8(88),m3h8x8(:,98),heltab2x64(:,:,1318))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1319),h0tab(:,1319),[49,2,4,8],[nMZ,0,0,0],4,1,wf8(:,46))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,46),G0H8(89),ngZl,m3h8x8(:,99),heltab2x64(:,:,1319))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1320),h0tab(:,1320),[49,2,4,8],[nMZ,0,nMZ,0],4,1,wf8(:,46))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,46),G0H8(90),ngZl,m3h8x8(:,100),heltab2x64(:,:,1320))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1321),h0tab(:,1321),[49,2,8,4],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,43),G0H8(91),m3h8x8(:,101),heltab2x64(:,:,1321))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1322),h0tab(:,1322),[49,2,8,4],[0,0,nMZ,0],4,1,wf8(:,43))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,43),G0H8(92),m3h8x8(:,102),heltab2x64(:,:,1322))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1323),h0tab(:,1323),[49,2,8,4],[nMZ,0,0,0],4,1,wf8(:,43))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,43),G0H8(93),ngZl,m3h8x8(:,103),heltab2x64(:,:,1323))


! end do

end subroutine vamp_1

end module ol_vamp_1_ppllll_ew_eeexexbbx_1_/**/REALKIND
