
module ol_colourmatrix_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 3]

  K2(1,:) = [ 3]

  KL(1,:) = [ 3]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND



module ol_forced_parameters_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 64 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(64) ! physical helicity states
  integer(intkind2), save :: nhflip = 64    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,64) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(148)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,15), wf8(8,90), wf16(16,19), wf64(64,64)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(57), c(56)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*eQED**4
    f( 2) = (CI*countertermnorm*eQED**6)/3._/**/REALKIND
    f( 3) = CI*countertermnorm*eQED**6
    f( 4) = (eQED**6*integralnorm*SwB)/9._/**/REALKIND
    f( 5) = eQED**6*integralnorm*SwB
    f( 6) = (eQED**6*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 7) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 8) = (eQED**6*integralnorm*SwB)/(sw**6*8._/**/REALKIND)
    f( 9) = (cw*eQED**6*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f(10) = (eQED**6*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f(11) = (eQED**6*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(12) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f(13) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(14) = (cw*eQED**6*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f(15) = (cw*eQED**6*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(16) = (cw**3*eQED**6*integralnorm*SwB)/sw**3
    f(17) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(18) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(19) = (eQED**6*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(20) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(21) = (eQED**6*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(22) = (cw**2*eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(23) = (cw**2*eQED**6*integralnorm*SwB)/sw**2
    f(24) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(25) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(26) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(27) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(28) = (cw*eQED**6*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(29) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(30) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(31) = (eQED**6*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(32) = (eQED**6*integralnorm*MW**2*sw*SwB)/cw
    f(33) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(34) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(35) = -((eQED**6*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(36) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(37) = (eQED**6*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(38) = (eQED**6*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(39) = (eQED**6*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(40) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(41) = -((eQED**6*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(42) = -((eQED**6*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(43) = -((eQED**6*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(44) = (eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(45) = (2*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(46) = (eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(47) = (4*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(48) = (2*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(49) = eQED**6*integralnorm*SwF
    f(50) = 2*eQED**6*integralnorm*SwF
    f(51) = 3*eQED**6*integralnorm*SwF
    f(52) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(53) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(54) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(55) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(56) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(57) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ f(4), f(5), f(6), f(7), f(8), f(9), f(10), f(11), f(12), f(13), f(14), f(15), f(16), f(17), f(18), f(19), f(20), f(21) &
    , f(22), f(23), f(24), f(25), f(26), f(27), f(28), f(29), f(30), f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38), f(39) &
    , f(40), f(41), f(42), f(43), 3*f(44), 3*f(45), f(46), 3*f(47), f(48), f(49), 3*f(49), f(50), 3*f(50), f(51), 3*f(52), 3*f(53) &
    , f(54), f(55), 3*f(56), 3*f(57) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(2) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(3) = 1 /((L(5,19))+L(6,19))
  den(6) = 1 /((L(5,28))+L(6,28))
  den(9) = 1 /((L(5,48) - MZ2)+L(6,48))
  den(10) = 1 /((L(5,7))+L(6,7))
  den(13) = 1 /((L(5,52))+L(6,52))
  den(16) = 1 /((L(5,13))+L(6,13))
  den(19) = 1 /((L(5,49))+L(6,49))
  den(22) = 1 /((L(5,35))+L(6,35))
  den(25) = 1 /((L(5,44))+L(6,44))
  den(28) = 1 /((L(5,48))+L(6,48))
  den(30) = 1 /((L(5,11))+L(6,11))
  den(34) = 1 /((L(5,56))+L(6,56))
  den(37) = 1 /((L(5,12))+L(6,12))
  den(42) = 1 /((L(5,50))+L(6,50))
  den(45) = 1 /((L(5,14))+L(6,14))
  den(49) = 1 /((L(5,3))+L(6,3))
  den(86) = 1 /((L(5,15) - MH2)+L(6,15))
  den(89) = 1 /((L(5,51) - MH2)+L(6,51))
  den(91) = 1 /((L(5,15) - MZ2)+L(6,15))
  den(94) = 1 /((L(5,51))+L(6,51))
  den(96) = 1 /((L(5,51) - MZ2)+L(6,51))
  den(101) = 1 /((L(5,60) - MH2)+L(6,60))
  den(105) = 1 /((L(5,60))+L(6,60))
  den(107) = 1 /((L(5,60) - MZ2)+L(6,60))

  ! denominators
  den(4) = den(1)*den(3)
  den(5) = den(2)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(1)*den(7)
  den(11) = den(1)*den(10)
  den(12) = den(9)*den(11)
  den(14) = den(9)*den(13)
  den(15) = den(1)*den(14)
  den(17) = den(2)*den(16)
  den(18) = den(9)*den(17)
  den(20) = den(9)*den(19)
  den(21) = den(2)*den(20)
  den(23) = den(1)*den(22)
  den(24) = den(2)*den(23)
  den(26) = den(2)*den(25)
  den(27) = den(1)*den(26)
  den(29) = den(11)*den(28)
  den(31) = den(1)*den(30)
  den(32) = den(28)*den(31)
  den(33) = den(9)*den(31)
  den(35) = den(9)*den(34)
  den(36) = den(1)*den(35)
  den(38) = den(4)*den(37)
  den(39) = den(6)*den(37)
  den(40) = den(1)*den(39)
  den(41) = den(17)*den(28)
  den(43) = den(9)*den(42)
  den(44) = den(2)*den(43)
  den(46) = den(2)*den(45)
  den(47) = den(28)*den(46)
  den(48) = den(9)*den(46)
  den(50) = den(3)*den(49)
  den(51) = den(2)*den(50)
  den(52) = den(7)*den(49)
  den(53) = den(1)*den(49)
  den(54) = den(26)*den(53)
  den(55) = den(1)**2
  den(56) = den(26)*den(55)
  den(57) = den(7)*den(53)
  den(58) = den(7)*den(55)
  den(59) = den(2)*den(37)
  den(60) = den(23)*den(59)
  den(61) = den(2)**2
  den(62) = den(23)*den(61)
  den(63) = den(4)*den(59)
  den(64) = den(4)*den(61)
  den(65) = den(4)*den(26)
  den(66) = den(7)*den(23)
  den(67) = den(35)*den(55)
  den(68) = den(14)*den(55)
  den(69) = den(11)*den(35)
  den(70) = den(14)*den(31)
  den(71) = den(9)*den(28)
  den(72) = den(31)*den(71)
  den(73) = den(9)**2
  den(74) = den(31)*den(73)
  den(75) = den(11)*den(71)
  den(76) = den(11)*den(73)
  den(77) = den(17)*den(43)
  den(78) = den(20)*den(46)
  den(79) = den(43)*den(61)
  den(80) = den(46)*den(71)
  den(81) = den(46)*den(73)
  den(82) = den(20)*den(61)
  den(83) = den(17)*den(71)
  den(84) = den(17)*den(73)
  den(85) = den(1)*den(2)
  den(87) = den(85)*den(86)
  den(88) = den(1)*den(9)
  den(90) = den(88)*den(89)
  den(92) = den(11)*den(91)
  den(93) = den(31)*den(91)
  den(95) = den(4)*den(94)
  den(97) = den(4)*den(96)
  den(98) = den(23)*den(94)
  den(99) = den(23)*den(96)
  den(100) = den(2)*den(9)
  den(102) = den(100)*den(101)
  den(103) = den(17)*den(91)
  den(104) = den(46)*den(91)
  den(106) = den(7)*den(105)
  den(108) = den(7)*den(107)
  den(109) = den(26)*den(105)
  den(110) = den(26)*den(107)
  den(111) = den(20)*den(96)
  den(112) = den(43)*den(96)
  den(113) = den(14)*den(107)
  den(114) = den(35)*den(107)
  den(115) = den(1)*den(28)
  den(116) = den(2)*den(28)
  den(117) = den(1)*den(2)*den(28)
  den(118) = den(1)*den(2)*den(9)
  den(119) = den(1)*den(116)
  den(120) = den(1)*den(100)
  den(121) = den(2)*den(115)
  den(122) = den(2)*den(88)
  den(123) = den(28)*den(85)
  den(124) = den(9)*den(85)
  den(125) = den(28)*den(87)
  den(126) = den(9)*den(87)
  den(127) = den(2)*den(90)
  den(128) = den(1)*den(102)
  den(129) = den(2)*den(95)
  den(130) = den(2)*den(97)
  den(131) = den(2)*den(98)
  den(132) = den(2)*den(99)
  den(133) = den(1)*den(106)
  den(134) = den(1)*den(108)
  den(135) = den(1)*den(109)
  den(136) = den(1)*den(110)
  den(137) = den(28)*den(92)
  den(138) = den(9)*den(92)
  den(139) = den(28)*den(93)
  den(140) = den(9)*den(93)
  den(141) = den(1)*den(113)
  den(142) = den(1)*den(114)
  den(143) = den(28)*den(103)
  den(144) = den(9)*den(103)
  den(145) = den(2)*den(111)
  den(146) = den(28)*den(104)
  den(147) = den(9)*den(104)
  den(148) = den(2)*den(112)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_nenexnmnmxddx_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,64))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
  A(1:hel_states,1:64)%j = 0
  A(1:hel_states,1:64)%e = 0
  A(1:hel_states,1:64)%hf = 0
  A(1:hel_states,1:64)%s = 0
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppllll_ew_nenexnmnmxddx_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e anti-nu_e nu_mu anti-nu_mu down anti-down -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppllll_ew_nenexnmnmxddx_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllll_ew_nenexnmnmxddx_1, only: &
    & external_perm_ppllll_ew_nenexnmnmxddx_1, &
    & external_perm_inv_ppllll_ew_nenexnmnmxddx_1, &
    & extcomb_perm_ppllll_ew_nenexnmnmxddx_1, &
    & average_factor_ppllll_ew_nenexnmnmxddx_1
  use ol_external_ppllll_ew_nenexnmnmxddx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppllll_ew_nenexnmnmxddx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(22)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(22)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,64))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppllll_ew_nenexnmnmxddx_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_Z(gZn,ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_Z(gZn,ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_ZQ_A(gZd,ntry, wf4(:,1), ex5(:), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,2), wf8(:,2), n3(:,4), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 19, ZERO, 0_intkind1, wf8(:,3), n2(1))
  call vert_ZQ_A(gZd,ntry, wf4(:,2), ex5(:), wf8(:,4), n3(:,5), t3x8(:,:,3))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,1), wf8(:,5), n3(:,6), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,4), 28, ZERO, 0_intkind1, wf8(:,6), n2(2))
  call vert_QA_Z(gZd,ntry, ex5(:), ex6(:), wf4(:,3), n3(:,7), t3x4(:,:,3))
  call vert_ZQ_A(gZn,ntry, wf4(:,1), ex3(:), wf8(:,7), n3(:,8), t3x8(:,:,5))
  call vert_AZ_Q(gZn,ntry, ex4(:), wf4(:,3), wf8(:,8), n3(:,9), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), 7, ZERO, 0_intkind1, wf8(:,9), n2(3))
  call vert_ZQ_A(gZn,ntry, wf4(:,3), ex3(:), wf8(:,10), n3(:,10), t3x8(:,:,7))
  call vert_AZ_Q(gZn,ntry, ex4(:), wf4(:,1), wf8(:,11), n3(:,11), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,10), 52, ZERO, 0_intkind1, wf8(:,12), n2(4))
  call vert_ZQ_A(gZn,ntry, wf4(:,2), ex1(:), wf8(:,13), n3(:,12), t3x8(:,:,9))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,3), wf8(:,14), n3(:,13), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,13), 13, ZERO, 0_intkind1, wf8(:,15), n2(5))
  call vert_ZQ_A(gZn,ntry, wf4(:,3), ex1(:), wf8(:,16), n3(:,14), t3x8(:,:,11))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,2), wf8(:,17), n3(:,15), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,16), 49, ZERO, 0_intkind1, wf8(:,18), n2(6))
  call counter_AZ_Q(EWctVdd,ntry, ex6(:), wf4(:,2), wf8(:,19), n3(:,16), t3x8(:,:,13))
  call counter_AZ_Q(EWctVdd,ntry, ex6(:), wf4(:,1), wf8(:,20), n3(:,17), t3x8(:,:,14))
  call counter_ZQ_A(EWctVdd,ntry, wf4(:,2), ex5(:), wf8(:,21), n3(:,18), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,5), 35, ZERO, 0_intkind1, wf8(:,22), n2(7))
  call counter_ZQ_A(EWctVdd,ntry, wf4(:,1), ex5(:), wf8(:,23), n3(:,19), t3x8(:,:,16))
  call prop_A_Q(ntry, wf8(:,2), 44, ZERO, 0_intkind1, wf8(:,24), n2(8))
  call counter_QA_Z(EWctVdd,ntry, ex5(:), ex6(:), wf4(:,4), n3(:,20), t3x4(:,:,4))
  call vert_AZ_Q(gZn,ntry, ex4(:), wf4(:,4), wf8(:,25), n3(:,21), t3x8(:,:,17))
  call vert_ZQ_A(gZn,ntry, wf4(:,4), ex3(:), wf8(:,26), n3(:,22), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,26), 52, ZERO, 0_intkind1, wf8(:,27), n2(9))
  call vert_QA_V(ntry, ex5(:), ex6(:), wf4(:,5), n3(:,23), t3x4(:,:,5))
  call counter_AZ_Q(EWctAnn,ntry, ex4(:), wf4(:,5), wf8(:,28), n3(:,24), t3x8(:,:,19))
  call counter_AZ_Q(EWctVnn,ntry, ex4(:), wf4(:,3), wf8(:,29), n3(:,25), t3x8(:,:,20))
  call counter_AZ_Q(EWctVnn,ntry, ex4(:), wf4(:,1), wf8(:,30), n3(:,26), t3x8(:,:,21))
  call counter_ZQ_A(EWctAnn,ntry, wf4(:,5), ex3(:), wf8(:,31), n3(:,27), t3x8(:,:,22))
  call prop_A_Q(ntry, wf8(:,11), 11, ZERO, 0_intkind1, wf8(:,32), n2(10))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,3), ex3(:), wf8(:,33), n3(:,28), t3x8(:,:,23))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,1), ex3(:), wf8(:,34), n3(:,29), t3x8(:,:,24))
  call prop_A_Q(ntry, wf8(:,8), 56, ZERO, 0_intkind1, wf8(:,35), n2(11))
  call counter_QA_Z(EWctAnn,ntry, ex3(:), ex4(:), wf4(:,6), n3(:,30), t3x4(:,:,6))
  call vert_AV_Q(ntry, ex6(:), wf4(:,6), wf8(:,36), n3(:,31), t3x8(:,:,25))
  call counter_QA_Z(EWctVnn,ntry, ex3(:), ex4(:), wf4(:,7), n3(:,32), t3x4(:,:,7))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,7), wf8(:,37), n3(:,33), t3x8(:,:,26))
  call vert_VQ_A(ntry, wf4(:,6), ex5(:), wf8(:,38), n3(:,34), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,38), 28, ZERO, 0_intkind1, wf8(:,39), n2(12))
  call vert_ZQ_A(gZd,ntry, wf4(:,7), ex5(:), wf8(:,40), n3(:,35), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,40), 28, ZERO, 0_intkind1, wf8(:,41), n2(13))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,4), wf8(:,42), n3(:,36), t3x8(:,:,29))
  call vert_ZQ_A(gZn,ntry, wf4(:,4), ex1(:), wf8(:,43), n3(:,37), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,43), 49, ZERO, 0_intkind1, wf8(:,44), n2(14))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,7), wf8(:,45), n3(:,38), t3x8(:,:,31))
  call vert_ZQ_A(gZn,ntry, wf4(:,7), ex1(:), wf8(:,46), n3(:,39), t3x8(:,:,32))
  call prop_Q_A(ntry, wf8(:,46), 13, ZERO, 0_intkind1, wf8(:,47), n2(15))
  call counter_AZ_Q(EWctAnn,ntry, ex2(:), wf4(:,5), wf8(:,48), n3(:,40), t3x8(:,:,33))
  call counter_AZ_Q(EWctVnn,ntry, ex2(:), wf4(:,3), wf8(:,49), n3(:,41), t3x8(:,:,34))
  call counter_AZ_Q(EWctVnn,ntry, ex2(:), wf4(:,2), wf8(:,50), n3(:,42), t3x8(:,:,35))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,2), ex1(:), wf8(:,51), n3(:,43), t3x8(:,:,36))
  call prop_A_Q(ntry, wf8(:,14), 50, ZERO, 0_intkind1, wf8(:,52), n2(16))
  call counter_ZQ_A(EWctAnn,ntry, wf4(:,5), ex1(:), wf8(:,53), n3(:,44), t3x8(:,:,37))
  call prop_A_Q(ntry, wf8(:,17), 14, ZERO, 0_intkind1, wf8(:,54), n2(17))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,3), ex1(:), wf8(:,55), n3(:,45), t3x8(:,:,38))
  call counter_QA_Z(EWctAnn,ntry, ex1(:), ex2(:), wf4(:,8), n3(:,46), t3x4(:,:,8))
  call vert_VQ_A(ntry, wf4(:,8), ex5(:), wf8(:,56), n3(:,47), t3x8(:,:,39))
  call prop_Q_A(ntry, wf8(:,56), 19, ZERO, 0_intkind1, wf8(:,57), n2(18))
  call counter_QA_Z(EWctVnn,ntry, ex1(:), ex2(:), wf4(:,9), n3(:,48), t3x4(:,:,9))
  call vert_ZQ_A(gZd,ntry, wf4(:,9), ex5(:), wf8(:,58), n3(:,49), t3x8(:,:,40))
  call prop_Q_A(ntry, wf8(:,58), 19, ZERO, 0_intkind1, wf8(:,59), n2(19))
  call vert_AV_Q(ntry, ex6(:), wf4(:,8), wf8(:,60), n3(:,50), t3x8(:,:,41))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,9), wf8(:,61), n3(:,51), t3x8(:,:,42))
  call vert_ZQ_A(gZn,ntry, wf4(:,9), ex3(:), wf8(:,62), n3(:,52), t3x8(:,:,43))
  call prop_Q_A(ntry, wf8(:,62), 7, ZERO, 0_intkind1, wf8(:,63), n2(20))
  call vert_AZ_Q(gZn,ntry, ex4(:), wf4(:,9), wf8(:,64), n3(:,53), t3x8(:,:,44))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 3, wf4(:,10), n2(21))
  call vert_VQ_A(ntry, wf4(:,10), ex5(:), wf8(:,65), n3(:,54), t3x8(:,:,45))
  call counter_V_V(EWctZZ,ntry, wf4(:,1), 3, wf4(:,11), n2(22))
  call vert_ZQ_A(gZd,ntry, wf4(:,11), ex5(:), wf8(:,66), n3(:,55), t3x8(:,:,46))
  call vert_AV_Q(ntry, ex6(:), wf4(:,10), wf8(:,67), n3(:,56), t3x8(:,:,47))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,11), wf8(:,68), n3(:,57), t3x8(:,:,48))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 12, wf4(:,12), n2(23))
  call vert_VQ_A(ntry, wf4(:,12), ex5(:), wf8(:,69), n3(:,58), t3x8(:,:,49))
  call counter_V_V(EWctZZ,ntry, wf4(:,2), 12, wf4(:,13), n2(24))
  call vert_ZQ_A(gZd,ntry, wf4(:,13), ex5(:), wf8(:,70), n3(:,59), t3x8(:,:,50))
  call vert_AV_Q(ntry, ex6(:), wf4(:,12), wf8(:,71), n3(:,60), t3x8(:,:,51))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,13), wf8(:,72), n3(:,61), t3x8(:,:,52))
  call counter_Q_A_LR(EWctdd,ntry, wf8(:,3), 19, wf8(:,73), n2(25))
  call counter_Q_A_LR(EWctdd,ntry, wf8(:,6), 28, wf8(:,74), n2(26))
  call vert_ZQ_A(gZn,ntry, wf4(:,11), ex3(:), wf8(:,75), n3(:,62), t3x8(:,:,53))
  call vert_AZ_Q(gZn,ntry, ex4(:), wf4(:,11), wf8(:,76), n3(:,63), t3x8(:,:,54))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,9), 7, wf8(:,77), n2(27))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,12), 52, wf8(:,78), n2(28))
  call counter_V_V(EWctAZ,ntry, wf4(:,5), 48, wf4(:,14), n2(29))
  call vert_ZQ_A(gZn,ntry, wf4(:,14), ex3(:), wf8(:,79), n3(:,64), t3x8(:,:,55))
  call counter_V_V(EWctZZ,ntry, wf4(:,3), 48, wf4(:,15), n2(30))
  call vert_ZQ_A(gZn,ntry, wf4(:,15), ex3(:), wf8(:,80), n3(:,65), t3x8(:,:,56))
  call vert_AZ_Q(gZn,ntry, ex4(:), wf4(:,14), wf8(:,81), n3(:,66), t3x8(:,:,57))
  call vert_AZ_Q(gZn,ntry, ex4(:), wf4(:,15), wf8(:,82), n3(:,67), t3x8(:,:,58))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,15), 13, wf8(:,83), n2(31))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,18), 49, wf8(:,84), n2(32))
  call vert_ZQ_A(gZn,ntry, wf4(:,13), ex1(:), wf8(:,85), n3(:,68), t3x8(:,:,59))
  call vert_ZQ_A(gZn,ntry, wf4(:,14), ex1(:), wf8(:,86), n3(:,69), t3x8(:,:,60))
  call vert_ZQ_A(gZn,ntry, wf4(:,15), ex1(:), wf8(:,87), n3(:,70), t3x8(:,:,61))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,13), wf8(:,88), n3(:,71), t3x8(:,:,62))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,14), wf8(:,89), n3(:,72), t3x8(:,:,63))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,15), wf8(:,90), n3(:,73), t3x8(:,:,64))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,2), wf16(:,1), n3(:,74), t3x16(:,:,1))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,3), wf16(:,2), n3(:,75), t3x16(:,:,2))
  call vert_QA_Z(gZn,ntry, wf8(:,9), ex4(:), wf16(:,3), n3(:,76), t3x16(:,:,3))
  call vert_QA_Z(gZn,ntry, ex3(:), wf8(:,32), wf16(:,4), n3(:,77), t3x16(:,:,4))
  call vert_QA_V(ntry, wf8(:,3), ex6(:), wf16(:,5), n3(:,78), t3x16(:,:,5))
  call vert_QA_Z(gZd,ntry, wf8(:,3), ex6(:), wf16(:,6), n3(:,79), t3x16(:,:,6))
  call vert_QA_V(ntry, ex5(:), wf8(:,22), wf16(:,7), n3(:,80), t3x16(:,:,7))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,22), wf16(:,8), n3(:,81), t3x16(:,:,8))
  call vert_VV_S(ntry, wf4(:,2), wf4(:,3), wf16(:,9), n3(:,82), t3x16(:,:,9))
  call vert_QA_Z(gZn,ntry, wf8(:,15), ex2(:), wf16(:,10), n3(:,83), t3x16(:,:,10))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,54), wf16(:,11), n3(:,84), t3x16(:,:,11))
  call vert_QA_V(ntry, wf8(:,6), ex6(:), wf16(:,12), n3(:,85), t3x16(:,:,12))
  call vert_QA_Z(gZd,ntry, wf8(:,6), ex6(:), wf16(:,13), n3(:,86), t3x16(:,:,13))
  call vert_QA_V(ntry, ex5(:), wf8(:,24), wf16(:,14), n3(:,87), t3x16(:,:,14))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,24), wf16(:,15), n3(:,88), t3x16(:,:,15))
  call vert_QA_Z(gZn,ntry, wf8(:,18), ex2(:), wf16(:,16), n3(:,89), t3x16(:,:,16))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,52), wf16(:,17), n3(:,90), t3x16(:,:,17))
  call vert_QA_Z(gZn,ntry, wf8(:,12), ex4(:), wf16(:,18), n3(:,91), t3x16(:,:,18))
  call vert_QA_Z(gZn,ntry, ex3(:), wf8(:,35), wf16(:,19), n3(:,92), t3x16(:,:,19))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,1), n3(:,93), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,6), A(:,2), n3(:,94), t3x64(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,9), A(:,3), n3(:,95), t3x64(:,:,3), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,4), n3(:,96), t3x64(:,:,4), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,15), A(:,5), n3(:,97), t3x64(:,:,5), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,18), A(:,6), n3(:,98), t3x64(:,:,6), nhel, den(21))

    call Hcont_QA(nsync, wf8(:,3), wf8(:,19), A(:,7), n3(:,99), t3x64(:,:,7), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,20), A(:,8), n3(:,100), t3x64(:,:,8), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,22), A(:,9), n3(:,101), t3x64(:,:,9), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,24), A(:,10), n3(:,102), t3x64(:,:,10), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,25), A(:,11), n3(:,103), t3x64(:,:,11), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,27), A(:,12), n3(:,104), t3x64(:,:,12), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,28), A(:,13), n3(:,105), t3x64(:,:,13), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,29), A(:,14), n3(:,106), t3x64(:,:,14), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,30), A(:,15), n3(:,107), t3x64(:,:,15), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,32), A(:,16), n3(:,108), t3x64(:,:,16), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,33), A(:,17), n3(:,109), t3x64(:,:,17), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,35), A(:,18), n3(:,110), t3x64(:,:,18), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,36), A(:,19), n3(:,111), t3x64(:,:,19), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,37), A(:,20), n3(:,112), t3x64(:,:,20), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,39), A(:,21), n3(:,113), t3x64(:,:,21), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,41), A(:,22), n3(:,114), t3x64(:,:,22), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,42), A(:,23), n3(:,115), t3x64(:,:,23), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,44), A(:,24), n3(:,116), t3x64(:,:,24), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,45), A(:,25), n3(:,117), t3x64(:,:,25), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,47), A(:,26), n3(:,118), t3x64(:,:,26), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,48), A(:,27), n3(:,119), t3x64(:,:,27), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,49), A(:,28), n3(:,120), t3x64(:,:,28), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,50), A(:,29), n3(:,121), t3x64(:,:,29), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,52), A(:,30), n3(:,122), t3x64(:,:,30), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,54), A(:,31), n3(:,123), t3x64(:,:,31), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,55), A(:,32), n3(:,124), t3x64(:,:,32), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,57), A(:,33), n3(:,125), t3x64(:,:,33), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,59), A(:,34), n3(:,126), t3x64(:,:,34), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,60), A(:,35), n3(:,127), t3x64(:,:,35), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,61), A(:,36), n3(:,128), t3x64(:,:,36), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,63), A(:,37), n3(:,129), t3x64(:,:,37), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,64), A(:,38), n3(:,130), t3x64(:,:,38), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,65), A(:,39), n3(:,131), t3x64(:,:,39), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,66), A(:,40), n3(:,132), t3x64(:,:,40), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,67), A(:,41), n3(:,133), t3x64(:,:,41), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,68), A(:,42), n3(:,134), t3x64(:,:,42), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,69), A(:,43), n3(:,135), t3x64(:,:,43), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,70), A(:,44), n3(:,136), t3x64(:,:,44), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,71), A(:,45), n3(:,137), t3x64(:,:,45), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,72), A(:,46), n3(:,138), t3x64(:,:,46), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,73), A(:,47), n3(:,139), t3x64(:,:,47), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,74), A(:,48), n3(:,140), t3x64(:,:,48), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,75), A(:,49), n3(:,141), t3x64(:,:,49), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,76), A(:,50), n3(:,142), t3x64(:,:,50), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,77), A(:,51), n3(:,143), t3x64(:,:,51), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,78), A(:,52), n3(:,144), t3x64(:,:,52), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,79), A(:,53), n3(:,145), t3x64(:,:,53), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,80), A(:,54), n3(:,146), t3x64(:,:,54), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,81), A(:,55), n3(:,147), t3x64(:,:,55), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,82), A(:,56), n3(:,148), t3x64(:,:,56), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,83), A(:,57), n3(:,149), t3x64(:,:,57), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,84), A(:,58), n3(:,150), t3x64(:,:,58), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,85), A(:,59), n3(:,151), t3x64(:,:,59), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,86), A(:,60), n3(:,152), t3x64(:,:,60), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,87), A(:,61), n3(:,153), t3x64(:,:,61), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,88), A(:,62), n3(:,154), t3x64(:,:,62), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,89), A(:,63), n3(:,155), t3x64(:,:,63), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,90), A(:,64), n3(:,156), t3x64(:,:,64), nhel, den(84))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j+A(j,2)%j+A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,6)%j)*f(1)

  M2(1)%j = (A(j,13)%j+A(j,16)%j+A(j,19)%j+A(j,21)%j+A(j,27)%j+A(j,31)%j+A(j,33)%j+A(j,35)%j-A(j,39)%j-A(j,41)%j-A(j,43)%j &
       -A(j,45)%j-A(j,53)%j-A(j,55)%j-A(j,60)%j-A(j,63)%j)*f(2)+(A(j,7)%j+A(j,8)%j+A(j,9)%j+A(j,10)%j+A(j,11)%j+A(j,12)%j &
       +A(j,14)%j+A(j,15)%j+A(j,17)%j+A(j,18)%j+A(j,20)%j+A(j,22)%j+A(j,23)%j+A(j,24)%j+A(j,25)%j+A(j,26)%j+A(j,28)%j+A(j,29)%j &
       +A(j,30)%j+A(j,32)%j+A(j,34)%j+A(j,36)%j+A(j,37)%j+A(j,38)%j-A(j,40)%j-A(j,42)%j-A(j,44)%j-A(j,46)%j-A(j,47)%j-A(j,48)%j &
       -A(j,49)%j-A(j,50)%j-A(j,51)%j-A(j,52)%j-A(j,54)%j-A(j,56)%j-A(j,57)%j-A(j,58)%j-A(j,59)%j-A(j,61)%j-A(j,62)%j &
       -A(j,64)%j)*f(3)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu


! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_ppllll_ew_nenexnmnmxddx_1_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for nu_e anti-nu_e nu_mu anti-nu_mu down anti-down -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for nu_e anti-nu_e nu_mu anti-nu_mu down anti-down -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,6)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for ppllll_ew_nenexnmnmxddx_1:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_ppllll_ew_nenexnmnmxddx_1, only: &
    & external_perm_inv_ppllll_ew_nenexnmnmxddx_1
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 6
    r = external_perm_inv_ppllll_ew_nenexnmnmxddx_1(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
        case(6)
          call assign_helicity_flip(ex6(:)%hf,ex6(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(64,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mflip(1)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 1
    do j = 1, 1
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_ppllll_ew_nenexnmnmxddx_1_/**/REALKIND
