
module ol_colourmatrix_ppllll_ew_eeexexaa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 1]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 1]

  K2(1,:) = [ 1]

  KL(1,:) = [ 1]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllll_ew_eeexexaa_1_/**/REALKIND



module ol_forced_parameters_ppllll_ew_eeexexaa_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllll_ew_eeexexaa_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppllll_ew_eeexexaa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 64 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(64) ! physical helicity states
  integer(intkind2), save :: nhflip = 64    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,64) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(1088)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,81), wf8(8,344), wf16(16,390), wf64(64,730)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(72), c(68)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppllll_ew_eeexexaa_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppllll_ew_eeexexaa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllll_ew_eeexexaa_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*eQED**4
    f( 2) = CI*countertermnorm*eQED**6
    f( 3) = CI*countertermnorm*eQED**6*EWctR2AAAA
    f( 4) = CI*countertermnorm*eQED**6*EWctR2AAAZ
    f( 5) = CI*countertermnorm*eQED**6*EWctR2AAZZ
    f( 6) = (CI*countertermnorm*eQED**6*EWctHAA*MW)/(cw**2*sw)
    f( 7) = eQED**6*integralnorm*SwB
    f( 8) = 2*eQED**6*integralnorm*SwB
    f( 9) = 4*eQED**6*integralnorm*SwB
    f(10) = eQED**6*integralnorm*MW**2*SwB
    f(11) = 2*eQED**6*integralnorm*MW**2*SwB
    f(12) = eQED**6*integralnorm*MW**4*SwB
    f(13) = (eQED**6*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(14) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f(15) = (cw*eQED**6*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(16) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f(17) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(18) = (eQED**6*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(19) = (cw**2*eQED**6*integralnorm*SwB)/sw**2
    f(20) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(21) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2)
    f(22) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(23) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(24) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(25) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2)
    f(26) = (cw**2*eQED**6*integralnorm*MW**2*SwB)/sw**2
    f(27) = (eQED**6*integralnorm*MH**2*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(28) = (eQED**6*integralnorm*MW**4*SwB)/(cw**2*sw**2)
    f(29) = (cw*eQED**6*integralnorm*SwB)/sw
    f(30) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(31) = (cw*eQED**6*integralnorm*MW**2*SwB)/sw
    f(32) = (eQED**6*integralnorm*MW**2*sw*SwB)/cw
    f(33) = (2*eQED**6*integralnorm*MW**2*sw*SwB)/cw
    f(34) = (eQED**6*integralnorm*MW**4*sw*SwB)/cw
    f(35) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(36) = (2*eQED**6*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(37) = (eQED**6*integralnorm*MW**4*sw**2*SwB)/cw**2
    f(38) = (eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**2*2._/**/REALKIND)
    f(39) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(40) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(41) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(42) = (-2*eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw)
    f(43) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(44) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(45) = (eQED**6*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(46) = (eQED**6*integralnorm*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND)
    f(47) = (eQED**6*integralnorm*(cw - sw)**2*(cw + sw)**2*SwB)/(cw**2*sw**2)
    f(48) = (eQED**6*integralnorm*MW**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(49) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*2._/**/REALKIND))
    f(50) = (eQED**6*integralnorm*MW**2*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND)
    f(51) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/cw**2)
    f(52) = (eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(53) = (2*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(54) = (eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(55) = (2*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(56) = (eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(57) = (16*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(58) = (2*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(59) = (8*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(60) = (eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(61) = (32*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(62) = (4*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(63) = (16*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(64) = (2*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(65) = (8*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(66) = eQED**6*integralnorm*SwF
    f(67) = (4*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(68) = 2*eQED**6*integralnorm*SwF
    f(69) = 3*eQED**6*integralnorm*SwF
    f(70) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(71) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(72) = (2*eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)

  c = [ f(7), f(8), f(9), f(10), f(11), f(12), f(13), f(14), f(15), f(16), f(17), f(18), f(19), f(20), f(21), f(22), f(23), f(24) &
    , f(25), f(26), f(27), f(28), f(29), f(30), f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38), f(39), f(40), f(41), f(42) &
    , f(43), f(44), f(45), f(46), f(47), f(48), f(49), f(50), f(51), 3*f(52), 3*f(53), 3*f(54), 3*f(55), 3*f(56), 3*f(57), 3*f(58) &
    , 3*f(59), 3*f(60), 3*f(61), 3*f(62), 3*f(63), 3*f(64), 3*f(65), f(66), 3*f(66), 3*f(67), f(68), 3*f(68), f(69), 3*f(70) &
    , f(71), 3*f(72) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5))+L(6,5))
  den(2) = 1 /((L(5,18))+L(6,18))
  den(3) = 1 /((L(5,40))+L(6,40))
  den(6) = 1 /((L(5,5) - MZ2)+L(6,5))
  den(9) = 1 /((L(5,13))+L(6,13))
  den(14) = 1 /((L(5,34))+L(6,34))
  den(15) = 1 /((L(5,24))+L(6,24))
  den(20) = 1 /((L(5,7))+L(6,7))
  den(29) = 1 /((L(5,17))+L(6,17))
  den(30) = 1 /((L(5,6))+L(6,6))
  den(33) = 1 /((L(5,6) - MZ2)+L(6,6))
  den(36) = 1 /((L(5,14))+L(6,14))
  den(41) = 1 /((L(5,33))+L(6,33))
  den(54) = 1 /((L(5,9))+L(6,9))
  den(55) = 1 /((L(5,36))+L(6,36))
  den(58) = 1 /((L(5,9) - MZ2)+L(6,9))
  den(65) = 1 /((L(5,20))+L(6,20))
  den(70) = 1 /((L(5,11))+L(6,11))
  den(79) = 1 /((L(5,10))+L(6,10))
  den(82) = 1 /((L(5,10) - MZ2)+L(6,10))
  den(101) = 1 /((L(5,21))+L(6,21))
  den(104) = 1 /((L(5,21) - MZ2)+L(6,21))
  den(107) = 1 /((L(5,38))+L(6,38))
  den(110) = 1 /((L(5,38) - MZ2)+L(6,38))
  den(117) = 1 /((L(5,42))+L(6,42))
  den(120) = 1 /((L(5,42) - MZ2)+L(6,42))
  den(123) = 1 /((L(5,37))+L(6,37))
  den(126) = 1 /((L(5,37) - MZ2)+L(6,37))
  den(129) = 1 /((L(5,22))+L(6,22))
  den(132) = 1 /((L(5,22) - MZ2)+L(6,22))
  den(139) = 1 /((L(5,41))+L(6,41))
  den(142) = 1 /((L(5,41) - MZ2)+L(6,41))
  den(157) = 1 /((L(5,26))+L(6,26))
  den(160) = 1 /((L(5,26) - MZ2)+L(6,26))
  den(163) = 1 /((L(5,25))+L(6,25))
  den(166) = 1 /((L(5,25) - MZ2)+L(6,25))
  den(181) = 1 /((L(5,48) - MH2)+L(6,48))
  den(183) = 1 /((L(5,50))+L(6,50))
  den(191) = 1 /((L(5,49))+L(6,49))
  den(222) = 1 /((L(5,56))+L(6,56))
  den(229) = 1 /((L(5,52))+L(6,52))
  den(269) = 1 /((L(5,58))+L(6,58))
  den(272) = 1 /((L(5,58) - MZ2)+L(6,58))
  den(278) = 1 /((L(5,45))+L(6,45))
  den(284) = 1 /((L(5,23))+L(6,23))
  den(308) = 1 /((L(5,29))+L(6,29))
  den(314) = 1 /((L(5,39))+L(6,39))
  den(344) = 1 /((L(5,46))+L(6,46))
  den(351) = 1 /((L(5,57))+L(6,57))
  den(354) = 1 /((L(5,57) - MZ2)+L(6,57))
  den(375) = 1 /((L(5,30))+L(6,30))
  den(415) = 1 /((L(5,54))+L(6,54))
  den(418) = 1 /((L(5,54) - MZ2)+L(6,54))
  den(429) = 1 /((L(5,27))+L(6,27))
  den(457) = 1 /((L(5,43))+L(6,43))
  den(492) = 1 /((L(5,53))+L(6,53))
  den(495) = 1 /((L(5,53) - MZ2)+L(6,53))
  den(680) = 1 /((L(5,15) - MH2)+L(6,15))
  den(682) = 1 /((L(5,15))+L(6,15))
  den(684) = 1 /((L(5,15) - MZ2)+L(6,15))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(2)*den(10)
  den(12) = den(6)*den(9)
  den(13) = den(2)*den(12)
  den(16) = den(1)*den(14)
  den(17) = den(15)*den(16)
  den(18) = den(6)*den(14)
  den(19) = den(15)*den(18)
  den(21) = den(1)*den(20)
  den(22) = den(15)*den(21)
  den(23) = den(6)*den(20)
  den(24) = den(15)*den(23)
  den(25) = den(10)*den(14)
  den(26) = den(12)*den(14)
  den(27) = den(3)*den(21)
  den(28) = den(3)*den(23)
  den(31) = den(29)*den(30)
  den(32) = den(3)*den(31)
  den(34) = den(29)*den(33)
  den(35) = den(3)*den(34)
  den(37) = den(30)*den(36)
  den(38) = den(29)*den(37)
  den(39) = den(33)*den(36)
  den(40) = den(29)*den(39)
  den(42) = den(30)*den(41)
  den(43) = den(15)*den(42)
  den(44) = den(33)*den(41)
  den(45) = den(15)*den(44)
  den(46) = den(20)*den(30)
  den(47) = den(15)*den(46)
  den(48) = den(20)*den(33)
  den(49) = den(15)*den(48)
  den(50) = den(37)*den(41)
  den(51) = den(39)*den(41)
  den(52) = den(3)*den(46)
  den(53) = den(3)*den(48)
  den(56) = den(2)*den(54)
  den(57) = den(55)*den(56)
  den(59) = den(2)*den(58)
  den(60) = den(55)*den(59)
  den(61) = den(9)*den(54)
  den(62) = den(2)*den(61)
  den(63) = den(9)*den(58)
  den(64) = den(2)*den(63)
  den(66) = den(14)*den(54)
  den(67) = den(65)*den(66)
  den(68) = den(14)*den(58)
  den(69) = den(65)*den(68)
  den(71) = den(54)*den(70)
  den(72) = den(65)*den(71)
  den(73) = den(58)*den(70)
  den(74) = den(65)*den(73)
  den(75) = den(14)*den(61)
  den(76) = den(14)*den(63)
  den(77) = den(55)*den(71)
  den(78) = den(55)*den(73)
  den(80) = den(29)*den(79)
  den(81) = den(55)*den(80)
  den(83) = den(29)*den(82)
  den(84) = den(55)*den(83)
  den(85) = den(36)*den(79)
  den(86) = den(29)*den(85)
  den(87) = den(36)*den(82)
  den(88) = den(29)*den(87)
  den(89) = den(41)*den(79)
  den(90) = den(65)*den(89)
  den(91) = den(41)*den(82)
  den(92) = den(65)*den(91)
  den(93) = den(70)*den(79)
  den(94) = den(65)*den(93)
  den(95) = den(70)*den(82)
  den(96) = den(65)*den(95)
  den(97) = den(41)*den(85)
  den(98) = den(41)*den(87)
  den(99) = den(55)*den(93)
  den(100) = den(55)*den(95)
  den(102) = den(29)*den(101)
  den(103) = den(14)*den(102)
  den(105) = den(29)*den(104)
  den(106) = den(14)*den(105)
  den(108) = den(14)*den(107)
  den(109) = den(29)*den(108)
  den(111) = den(14)*den(110)
  den(112) = den(29)*den(111)
  den(113) = den(55)*den(107)
  den(114) = den(29)*den(113)
  den(115) = den(55)*den(110)
  den(116) = den(29)*den(115)
  den(118) = den(3)*den(117)
  den(119) = den(29)*den(118)
  den(121) = den(3)*den(120)
  den(122) = den(29)*den(121)
  den(124) = den(41)*den(123)
  den(125) = den(2)*den(124)
  den(127) = den(41)*den(126)
  den(128) = den(2)*den(127)
  den(130) = den(2)*den(129)
  den(131) = den(41)*den(130)
  den(133) = den(2)*den(132)
  den(134) = den(41)*den(133)
  den(135) = den(55)*den(123)
  den(136) = den(2)*den(135)
  den(137) = den(55)*den(126)
  den(138) = den(2)*den(137)
  den(140) = den(3)*den(139)
  den(141) = den(2)*den(140)
  den(143) = den(3)*den(142)
  den(144) = den(2)*den(143)
  den(145) = den(65)*den(129)
  den(146) = den(41)*den(145)
  den(147) = den(65)*den(132)
  den(148) = den(41)*den(147)
  den(149) = den(65)*den(101)
  den(150) = den(14)*den(149)
  den(151) = den(65)*den(104)
  den(152) = den(14)*den(151)
  den(153) = den(3)*den(149)
  den(154) = den(3)*den(151)
  den(155) = den(65)*den(140)
  den(156) = den(65)*den(143)
  den(158) = den(15)*den(157)
  den(159) = den(41)*den(158)
  den(161) = den(15)*den(160)
  den(162) = den(41)*den(161)
  den(164) = den(15)*den(163)
  den(165) = den(14)*den(164)
  den(167) = den(15)*den(166)
  den(168) = den(14)*den(167)
  den(169) = den(15)*den(135)
  den(170) = den(15)*den(137)
  den(171) = den(55)*den(164)
  den(172) = den(55)*den(167)
  den(173) = den(1)*den(79)
  den(174) = den(1)*den(82)
  den(175) = den(6)*den(79)
  den(176) = den(6)*den(82)
  den(177) = den(30)*den(54)
  den(178) = den(33)*den(54)
  den(179) = den(30)*den(58)
  den(180) = den(33)*den(58)
  den(182) = den(176)*den(181)
  den(184) = den(2)*den(183)
  den(185) = den(1)*den(184)
  den(186) = den(6)*den(184)
  den(187) = den(14)*den(183)
  den(188) = den(1)*den(187)
  den(189) = den(6)*den(187)
  den(190) = den(180)*den(181)
  den(192) = den(29)*den(191)
  den(193) = den(30)*den(192)
  den(194) = den(33)*den(192)
  den(195) = den(41)*den(191)
  den(196) = den(30)*den(195)
  den(197) = den(33)*den(195)
  den(198) = den(54)*den(184)
  den(199) = den(58)*den(184)
  den(200) = den(54)*den(187)
  den(201) = den(58)*den(187)
  den(202) = den(79)*den(192)
  den(203) = den(82)*den(192)
  den(204) = den(79)*den(195)
  den(205) = den(82)*den(195)
  den(206) = den(29)*den(163)
  den(207) = den(14)*den(206)
  den(208) = den(29)*den(166)
  den(209) = den(14)*den(208)
  den(210) = den(14)*den(117)
  den(211) = den(29)*den(210)
  den(212) = den(14)*den(120)
  den(213) = den(29)*den(212)
  den(214) = den(41)*den(139)
  den(215) = den(2)*den(214)
  den(216) = den(41)*den(142)
  den(217) = den(2)*den(216)
  den(218) = den(2)*den(157)
  den(219) = den(41)*den(218)
  den(220) = den(2)*den(160)
  den(221) = den(41)*den(220)
  den(223) = den(15)*den(222)
  den(224) = den(1)*den(223)
  den(225) = den(6)*den(223)
  den(226) = den(3)*den(222)
  den(227) = den(1)*den(226)
  den(228) = den(6)*den(226)
  den(230) = den(65)*den(229)
  den(231) = den(54)*den(230)
  den(232) = den(58)*den(230)
  den(233) = den(55)*den(229)
  den(234) = den(54)*den(233)
  den(235) = den(58)*den(233)
  den(236) = den(55)*den(206)
  den(237) = den(55)*den(208)
  den(238) = den(3)*den(102)
  den(239) = den(3)*den(105)
  den(240) = den(65)*den(214)
  den(241) = den(65)*den(216)
  den(242) = den(15)*den(124)
  den(243) = den(15)*den(127)
  den(244) = den(30)*den(223)
  den(245) = den(33)*den(223)
  den(246) = den(30)*den(226)
  den(247) = den(33)*den(226)
  den(248) = den(79)*den(230)
  den(249) = den(82)*den(230)
  den(250) = den(79)*den(233)
  den(251) = den(82)*den(233)
  den(252) = den(55)*den(218)
  den(253) = den(55)*den(220)
  den(254) = den(3)*den(130)
  den(255) = den(3)*den(133)
  den(256) = den(65)*den(210)
  den(257) = den(65)*den(212)
  den(258) = den(65)*den(118)
  den(259) = den(65)*den(121)
  den(260) = den(3)*den(145)
  den(261) = den(3)*den(147)
  den(262) = den(15)*den(108)
  den(263) = den(15)*den(111)
  den(264) = den(55)*den(158)
  den(265) = den(55)*den(161)
  den(266) = den(15)*den(113)
  den(267) = den(15)*den(115)
  den(268) = den(2)*den(3)
  den(270) = den(268)*den(269)
  den(271) = den(1)*den(270)
  den(273) = den(268)*den(272)
  den(274) = den(1)*den(273)
  den(275) = den(6)*den(270)
  den(276) = den(6)*den(273)
  den(277) = den(1)*den(3)
  den(279) = den(277)*den(278)
  den(280) = den(2)*den(279)
  den(281) = den(3)*den(6)
  den(282) = den(278)*den(281)
  den(283) = den(2)*den(282)
  den(285) = den(4)*den(284)
  den(286) = den(3)*den(285)
  den(287) = den(7)*den(284)
  den(288) = den(3)*den(287)
  den(289) = den(1)**2
  den(290) = den(184)*den(289)
  den(291) = den(1)*den(6)
  den(292) = den(184)*den(291)
  den(293) = den(6)**2
  den(294) = den(184)*den(293)
  den(295) = den(2)**2
  den(296) = den(10)*den(295)
  den(297) = den(12)*den(295)
  den(298) = den(10)*den(184)
  den(299) = den(12)*den(184)
  den(300) = den(14)*den(15)
  den(301) = den(269)*den(300)
  den(302) = den(1)*den(301)
  den(303) = den(272)*den(300)
  den(304) = den(1)*den(303)
  den(305) = den(6)*den(301)
  den(306) = den(6)*den(303)
  den(307) = den(1)*den(15)
  den(309) = den(307)*den(308)
  den(310) = den(14)*den(309)
  den(311) = den(6)*den(15)
  den(312) = den(308)*den(311)
  den(313) = den(14)*den(312)
  den(315) = den(16)*den(314)
  den(316) = den(15)*den(315)
  den(317) = den(18)*den(314)
  den(318) = den(15)*den(317)
  den(319) = den(223)*den(289)
  den(320) = den(223)*den(291)
  den(321) = den(223)*den(293)
  den(322) = den(21)*den(223)
  den(323) = den(23)*den(223)
  den(324) = den(15)**2
  den(325) = den(21)*den(324)
  den(326) = den(23)*den(324)
  den(327) = den(187)*den(289)
  den(328) = den(187)*den(291)
  den(329) = den(187)*den(293)
  den(330) = den(14)**2
  den(331) = den(10)*den(330)
  den(332) = den(12)*den(330)
  den(333) = den(10)*den(187)
  den(334) = den(12)*den(187)
  den(335) = den(226)*den(289)
  den(336) = den(226)*den(291)
  den(337) = den(226)*den(293)
  den(338) = den(21)*den(226)
  den(339) = den(23)*den(226)
  den(340) = den(3)**2
  den(341) = den(21)*den(340)
  den(342) = den(23)*den(340)
  den(343) = den(3)*den(30)
  den(345) = den(343)*den(344)
  den(346) = den(29)*den(345)
  den(347) = den(3)*den(33)
  den(348) = den(344)*den(347)
  den(349) = den(29)*den(348)
  den(350) = den(3)*den(29)
  den(352) = den(350)*den(351)
  den(353) = den(30)*den(352)
  den(355) = den(350)*den(354)
  den(356) = den(30)*den(355)
  den(357) = den(33)*den(352)
  den(358) = den(33)*den(355)
  den(359) = den(31)*den(284)
  den(360) = den(3)*den(359)
  den(361) = den(34)*den(284)
  den(362) = den(3)*den(361)
  den(363) = den(29)**2
  den(364) = den(37)*den(363)
  den(365) = den(39)*den(363)
  den(366) = den(30)**2
  den(367) = den(192)*den(366)
  den(368) = den(30)*den(33)
  den(369) = den(192)*den(368)
  den(370) = den(33)**2
  den(371) = den(192)*den(370)
  den(372) = den(37)*den(192)
  den(373) = den(39)*den(192)
  den(374) = den(15)*den(30)
  den(376) = den(374)*den(375)
  den(377) = den(41)*den(376)
  den(378) = den(15)*den(33)
  den(379) = den(375)*den(378)
  den(380) = den(41)*den(379)
  den(381) = den(15)*den(41)
  den(382) = den(351)*den(381)
  den(383) = den(30)*den(382)
  den(384) = den(354)*den(381)
  den(385) = den(30)*den(384)
  den(386) = den(33)*den(382)
  den(387) = den(33)*den(384)
  den(388) = den(42)*den(314)
  den(389) = den(15)*den(388)
  den(390) = den(44)*den(314)
  den(391) = den(15)*den(390)
  den(392) = den(223)*den(366)
  den(393) = den(223)*den(368)
  den(394) = den(223)*den(370)
  den(395) = den(46)*den(223)
  den(396) = den(48)*den(223)
  den(397) = den(46)*den(324)
  den(398) = den(48)*den(324)
  den(399) = den(41)**2
  den(400) = den(37)*den(399)
  den(401) = den(39)*den(399)
  den(402) = den(195)*den(366)
  den(403) = den(195)*den(368)
  den(404) = den(195)*den(370)
  den(405) = den(37)*den(195)
  den(406) = den(39)*den(195)
  den(407) = den(226)*den(366)
  den(408) = den(226)*den(368)
  den(409) = den(226)*den(370)
  den(410) = den(46)*den(226)
  den(411) = den(48)*den(226)
  den(412) = den(46)*den(340)
  den(413) = den(48)*den(340)
  den(414) = den(2)*den(55)
  den(416) = den(414)*den(415)
  den(417) = den(54)*den(416)
  den(419) = den(414)*den(418)
  den(420) = den(54)*den(419)
  den(421) = den(58)*den(416)
  den(422) = den(58)*den(419)
  den(423) = den(54)*den(55)
  den(424) = den(278)*den(423)
  den(425) = den(2)*den(424)
  den(426) = den(55)*den(58)
  den(427) = den(278)*den(426)
  den(428) = den(2)*den(427)
  den(430) = den(56)*den(429)
  den(431) = den(55)*den(430)
  den(432) = den(59)*den(429)
  den(433) = den(55)*den(432)
  den(434) = den(54)**2
  den(435) = den(184)*den(434)
  den(436) = den(54)*den(58)
  den(437) = den(184)*den(436)
  den(438) = den(58)**2
  den(439) = den(184)*den(438)
  den(440) = den(61)*den(295)
  den(441) = den(63)*den(295)
  den(442) = den(61)*den(184)
  den(443) = den(63)*den(184)
  den(444) = den(14)*den(65)
  den(445) = den(415)*den(444)
  den(446) = den(54)*den(445)
  den(447) = den(418)*den(444)
  den(448) = den(54)*den(447)
  den(449) = den(58)*den(445)
  den(450) = den(58)*den(447)
  den(451) = den(54)*den(65)
  den(452) = den(308)*den(451)
  den(453) = den(14)*den(452)
  den(454) = den(58)*den(65)
  den(455) = den(308)*den(454)
  den(456) = den(14)*den(455)
  den(458) = den(66)*den(457)
  den(459) = den(65)*den(458)
  den(460) = den(68)*den(457)
  den(461) = den(65)*den(460)
  den(462) = den(230)*den(434)
  den(463) = den(230)*den(436)
  den(464) = den(230)*den(438)
  den(465) = den(71)*den(230)
  den(466) = den(73)*den(230)
  den(467) = den(65)**2
  den(468) = den(71)*den(467)
  den(469) = den(73)*den(467)
  den(470) = den(187)*den(434)
  den(471) = den(187)*den(436)
  den(472) = den(187)*den(438)
  den(473) = den(61)*den(330)
  den(474) = den(63)*den(330)
  den(475) = den(61)*den(187)
  den(476) = den(63)*den(187)
  den(477) = den(233)*den(434)
  den(478) = den(233)*den(436)
  den(479) = den(233)*den(438)
  den(480) = den(71)*den(233)
  den(481) = den(73)*den(233)
  den(482) = den(55)**2
  den(483) = den(71)*den(482)
  den(484) = den(73)*den(482)
  den(485) = den(55)*den(79)
  den(486) = den(344)*den(485)
  den(487) = den(29)*den(486)
  den(488) = den(55)*den(82)
  den(489) = den(344)*den(488)
  den(490) = den(29)*den(489)
  den(491) = den(29)*den(55)
  den(493) = den(491)*den(492)
  den(494) = den(79)*den(493)
  den(496) = den(491)*den(495)
  den(497) = den(79)*den(496)
  den(498) = den(82)*den(493)
  den(499) = den(82)*den(496)
  den(500) = den(80)*den(429)
  den(501) = den(55)*den(500)
  den(502) = den(83)*den(429)
  den(503) = den(55)*den(502)
  den(504) = den(85)*den(363)
  den(505) = den(87)*den(363)
  den(506) = den(79)**2
  den(507) = den(192)*den(506)
  den(508) = den(79)*den(82)
  den(509) = den(192)*den(508)
  den(510) = den(82)**2
  den(511) = den(192)*den(510)
  den(512) = den(85)*den(192)
  den(513) = den(87)*den(192)
  den(514) = den(65)*den(79)
  den(515) = den(375)*den(514)
  den(516) = den(41)*den(515)
  den(517) = den(65)*den(82)
  den(518) = den(375)*den(517)
  den(519) = den(41)*den(518)
  den(520) = den(41)*den(65)
  den(521) = den(492)*den(520)
  den(522) = den(79)*den(521)
  den(523) = den(495)*den(520)
  den(524) = den(79)*den(523)
  den(525) = den(82)*den(521)
  den(526) = den(82)*den(523)
  den(527) = den(89)*den(457)
  den(528) = den(65)*den(527)
  den(529) = den(91)*den(457)
  den(530) = den(65)*den(529)
  den(531) = den(230)*den(506)
  den(532) = den(230)*den(508)
  den(533) = den(230)*den(510)
  den(534) = den(93)*den(230)
  den(535) = den(95)*den(230)
  den(536) = den(93)*den(467)
  den(537) = den(95)*den(467)
  den(538) = den(85)*den(399)
  den(539) = den(87)*den(399)
  den(540) = den(195)*den(506)
  den(541) = den(195)*den(508)
  den(542) = den(195)*den(510)
  den(543) = den(85)*den(195)
  den(544) = den(87)*den(195)
  den(545) = den(233)*den(506)
  den(546) = den(233)*den(508)
  den(547) = den(233)*den(510)
  den(548) = den(93)*den(233)
  den(549) = den(95)*den(233)
  den(550) = den(93)*den(482)
  den(551) = den(95)*den(482)
  den(552) = den(210)*den(363)
  den(553) = den(212)*den(363)
  den(554) = den(108)*den(363)
  den(555) = den(111)*den(363)
  den(556) = den(206)*den(330)
  den(557) = den(208)*den(330)
  den(558) = den(102)*den(330)
  den(559) = den(105)*den(330)
  den(560) = den(102)*den(210)
  den(561) = den(102)*den(212)
  den(562) = den(105)*den(210)
  den(563) = den(105)*den(212)
  den(564) = den(108)*den(206)
  den(565) = den(108)*den(208)
  den(566) = den(111)*den(206)
  den(567) = den(111)*den(208)
  den(568) = den(113)*den(363)
  den(569) = den(115)*den(363)
  den(570) = den(206)*den(482)
  den(571) = den(208)*den(482)
  den(572) = den(113)*den(206)
  den(573) = den(113)*den(208)
  den(574) = den(115)*den(206)
  den(575) = den(115)*den(208)
  den(576) = den(118)*den(363)
  den(577) = den(121)*den(363)
  den(578) = den(102)*den(118)
  den(579) = den(105)*den(118)
  den(580) = den(102)*den(121)
  den(581) = den(105)*den(121)
  den(582) = den(102)*den(340)
  den(583) = den(105)*den(340)
  den(584) = den(218)*den(399)
  den(585) = den(220)*den(399)
  den(586) = den(130)*den(399)
  den(587) = den(133)*den(399)
  den(588) = den(214)*den(295)
  den(589) = den(216)*den(295)
  den(590) = den(124)*den(295)
  den(591) = den(127)*den(295)
  den(592) = den(124)*den(218)
  den(593) = den(124)*den(220)
  den(594) = den(127)*den(218)
  den(595) = den(127)*den(220)
  den(596) = den(130)*den(214)
  den(597) = den(130)*den(216)
  den(598) = den(133)*den(214)
  den(599) = den(133)*den(216)
  den(600) = den(218)*den(482)
  den(601) = den(220)*den(482)
  den(602) = den(135)*den(218)
  den(603) = den(135)*den(220)
  den(604) = den(137)*den(218)
  den(605) = den(137)*den(220)
  den(606) = den(135)*den(295)
  den(607) = den(137)*den(295)
  den(608) = den(130)*den(140)
  den(609) = den(133)*den(140)
  den(610) = den(130)*den(143)
  den(611) = den(133)*den(143)
  den(612) = den(130)*den(340)
  den(613) = den(133)*den(340)
  den(614) = den(140)*den(295)
  den(615) = den(143)*den(295)
  den(616) = den(145)*den(399)
  den(617) = den(147)*den(399)
  den(618) = den(214)*den(467)
  den(619) = den(216)*den(467)
  den(620) = den(145)*den(214)
  den(621) = den(145)*den(216)
  den(622) = den(147)*den(214)
  den(623) = den(147)*den(216)
  den(624) = den(210)*den(467)
  den(625) = den(212)*den(467)
  den(626) = den(149)*den(210)
  den(627) = den(149)*den(212)
  den(628) = den(151)*den(210)
  den(629) = den(151)*den(212)
  den(630) = den(149)*den(330)
  den(631) = den(151)*den(330)
  den(632) = den(118)*den(149)
  den(633) = den(121)*den(149)
  den(634) = den(118)*den(151)
  den(635) = den(121)*den(151)
  den(636) = den(140)*den(145)
  den(637) = den(140)*den(147)
  den(638) = den(143)*den(145)
  den(639) = den(143)*den(147)
  den(640) = den(118)*den(467)
  den(641) = den(121)*den(467)
  den(642) = den(145)*den(340)
  den(643) = den(147)*den(340)
  den(644) = den(140)*den(467)
  den(645) = den(143)*den(467)
  den(646) = den(149)*den(340)
  den(647) = den(151)*den(340)
  den(648) = den(158)*den(399)
  den(649) = den(161)*den(399)
  den(650) = den(124)*den(158)
  den(651) = den(127)*den(158)
  den(652) = den(124)*den(161)
  den(653) = den(127)*den(161)
  den(654) = den(124)*den(324)
  den(655) = den(127)*den(324)
  den(656) = den(108)*den(164)
  den(657) = den(111)*den(164)
  den(658) = den(108)*den(167)
  den(659) = den(111)*den(167)
  den(660) = den(108)*den(324)
  den(661) = den(111)*den(324)
  den(662) = den(164)*den(330)
  den(663) = den(167)*den(330)
  den(664) = den(135)*den(158)
  den(665) = den(135)*den(161)
  den(666) = den(137)*den(158)
  den(667) = den(137)*den(161)
  den(668) = den(113)*den(164)
  den(669) = den(115)*den(164)
  den(670) = den(113)*den(167)
  den(671) = den(115)*den(167)
  den(672) = den(158)*den(482)
  den(673) = den(161)*den(482)
  den(674) = den(113)*den(324)
  den(675) = den(115)*den(324)
  den(676) = den(164)*den(482)
  den(677) = den(167)*den(482)
  den(678) = den(135)*den(324)
  den(679) = den(137)*den(324)
  den(681) = den(176)*den(680)
  den(683) = den(21)*den(682)
  den(685) = den(21)*den(684)
  den(686) = den(23)*den(682)
  den(687) = den(23)*den(684)
  den(688) = den(21)*den(284)
  den(689) = den(23)*den(284)
  den(690) = den(21)*den(314)
  den(691) = den(23)*den(314)
  den(692) = den(10)*den(682)
  den(693) = den(10)*den(684)
  den(694) = den(12)*den(682)
  den(695) = den(12)*den(684)
  den(696) = den(10)*den(308)
  den(697) = den(12)*den(308)
  den(698) = den(10)*den(278)
  den(699) = den(12)*den(278)
  den(700) = den(180)*den(680)
  den(701) = den(46)*den(682)
  den(702) = den(46)*den(684)
  den(703) = den(48)*den(682)
  den(704) = den(48)*den(684)
  den(705) = den(46)*den(284)
  den(706) = den(48)*den(284)
  den(707) = den(46)*den(314)
  den(708) = den(48)*den(314)
  den(709) = den(37)*den(682)
  den(710) = den(39)*den(682)
  den(711) = den(37)*den(684)
  den(712) = den(39)*den(684)
  den(713) = den(37)*den(375)
  den(714) = den(39)*den(375)
  den(715) = den(37)*den(344)
  den(716) = den(39)*den(344)
  den(717) = den(71)*den(682)
  den(718) = den(71)*den(684)
  den(719) = den(73)*den(682)
  den(720) = den(73)*den(684)
  den(721) = den(71)*den(429)
  den(722) = den(73)*den(429)
  den(723) = den(71)*den(457)
  den(724) = den(73)*den(457)
  den(725) = den(61)*den(682)
  den(726) = den(61)*den(684)
  den(727) = den(63)*den(682)
  den(728) = den(63)*den(684)
  den(729) = den(61)*den(308)
  den(730) = den(63)*den(308)
  den(731) = den(61)*den(278)
  den(732) = den(63)*den(278)
  den(733) = den(93)*den(682)
  den(734) = den(93)*den(684)
  den(735) = den(95)*den(682)
  den(736) = den(95)*den(684)
  den(737) = den(93)*den(429)
  den(738) = den(95)*den(429)
  den(739) = den(93)*den(457)
  den(740) = den(95)*den(457)
  den(741) = den(85)*den(682)
  den(742) = den(87)*den(682)
  den(743) = den(85)*den(684)
  den(744) = den(87)*den(684)
  den(745) = den(85)*den(375)
  den(746) = den(87)*den(375)
  den(747) = den(85)*den(344)
  den(748) = den(87)*den(344)
  den(749) = den(102)*den(284)
  den(750) = den(105)*den(284)
  den(751) = den(102)*den(308)
  den(752) = den(105)*den(308)
  den(753) = den(206)*den(429)
  den(754) = den(208)*den(429)
  den(755) = den(206)*den(308)
  den(756) = den(208)*den(308)
  den(757) = den(192)*den(492)
  den(758) = den(192)*den(495)
  den(759) = den(192)*den(351)
  den(760) = den(192)*den(354)
  den(761) = den(130)*den(284)
  den(762) = den(133)*den(284)
  den(763) = den(218)*den(429)
  den(764) = den(220)*den(429)
  den(765) = den(130)*den(375)
  den(766) = den(133)*den(375)
  den(767) = den(218)*den(375)
  den(768) = den(220)*den(375)
  den(769) = den(184)*den(415)
  den(770) = den(184)*den(418)
  den(771) = den(184)*den(269)
  den(772) = den(184)*den(272)
  den(773) = den(149)*den(284)
  den(774) = den(151)*den(284)
  den(775) = den(145)*den(284)
  den(776) = den(147)*den(284)
  den(777) = den(149)*den(308)
  den(778) = den(151)*den(308)
  den(779) = den(230)*den(492)
  den(780) = den(230)*den(495)
  den(781) = den(145)*den(375)
  den(782) = den(147)*den(375)
  den(783) = den(230)*den(415)
  den(784) = den(230)*den(418)
  den(785) = den(164)*den(429)
  den(786) = den(167)*den(429)
  den(787) = den(158)*den(429)
  den(788) = den(161)*den(429)
  den(789) = den(164)*den(308)
  den(790) = den(167)*den(308)
  den(791) = den(223)*den(351)
  den(792) = den(223)*den(354)
  den(793) = den(158)*den(375)
  den(794) = den(161)*den(375)
  den(795) = den(223)*den(269)
  den(796) = den(223)*den(272)
  den(797) = den(124)*den(314)
  den(798) = den(127)*den(314)
  den(799) = den(124)*den(278)
  den(800) = den(127)*den(278)
  den(801) = den(214)*den(457)
  den(802) = den(216)*den(457)
  den(803) = den(214)*den(278)
  den(804) = den(216)*den(278)
  den(805) = den(195)*den(492)
  den(806) = den(195)*den(495)
  den(807) = den(195)*den(351)
  den(808) = den(195)*den(354)
  den(809) = den(108)*den(314)
  den(810) = den(111)*den(314)
  den(811) = den(210)*den(457)
  den(812) = den(212)*den(457)
  den(813) = den(108)*den(344)
  den(814) = den(111)*den(344)
  den(815) = den(210)*den(344)
  den(816) = den(212)*den(344)
  den(817) = den(187)*den(415)
  den(818) = den(187)*den(418)
  den(819) = den(187)*den(269)
  den(820) = den(187)*den(272)
  den(821) = den(135)*den(314)
  den(822) = den(137)*den(314)
  den(823) = den(113)*den(314)
  den(824) = den(115)*den(314)
  den(825) = den(135)*den(278)
  den(826) = den(137)*den(278)
  den(827) = den(233)*den(492)
  den(828) = den(233)*den(495)
  den(829) = den(113)*den(344)
  den(830) = den(115)*den(344)
  den(831) = den(233)*den(415)
  den(832) = den(233)*den(418)
  den(833) = den(140)*den(457)
  den(834) = den(143)*den(457)
  den(835) = den(118)*den(457)
  den(836) = den(121)*den(457)
  den(837) = den(140)*den(278)
  den(838) = den(143)*den(278)
  den(839) = den(226)*den(351)
  den(840) = den(226)*den(354)
  den(841) = den(118)*den(344)
  den(842) = den(121)*den(344)
  den(843) = den(226)*den(269)
  den(844) = den(226)*den(272)
  den(845) = den(1)*den(2)*den(3)
  den(846) = den(2)*den(3)*den(6)
  den(847) = den(1)*den(218)
  den(848) = den(1)*den(220)
  den(849) = den(6)*den(218)
  den(850) = den(6)*den(220)
  den(851) = den(1)*den(14)*den(15)
  den(852) = den(6)*den(14)*den(15)
  den(853) = den(1)*den(158)
  den(854) = den(1)*den(161)
  den(855) = den(6)*den(158)
  den(856) = den(6)*den(161)
  den(857) = den(1)*den(210)
  den(858) = den(1)*den(212)
  den(859) = den(6)*den(210)
  den(860) = den(6)*den(212)
  den(861) = den(1)*den(118)
  den(862) = den(1)*den(121)
  den(863) = den(6)*den(118)
  den(864) = den(6)*den(121)
  den(865) = den(3)*den(29)*den(30)
  den(866) = den(3)*den(29)*den(33)
  den(867) = den(30)*den(206)
  den(868) = den(30)*den(208)
  den(869) = den(33)*den(206)
  den(870) = den(33)*den(208)
  den(871) = den(15)*den(30)*den(41)
  den(872) = den(15)*den(33)*den(41)
  den(873) = den(30)*den(164)
  den(874) = den(33)*den(164)
  den(875) = den(30)*den(167)
  den(876) = den(33)*den(167)
  den(877) = den(30)*den(214)
  den(878) = den(30)*den(216)
  den(879) = den(33)*den(214)
  den(880) = den(33)*den(216)
  den(881) = den(30)*den(140)
  den(882) = den(33)*den(140)
  den(883) = den(30)*den(143)
  den(884) = den(33)*den(143)
  den(885) = den(2)*den(54)*den(55)
  den(886) = den(2)*den(55)*den(58)
  den(887) = den(54)*den(130)
  den(888) = den(54)*den(133)
  den(889) = den(58)*den(130)
  den(890) = den(58)*den(133)
  den(891) = den(14)*den(54)*den(65)
  den(892) = den(14)*den(58)*den(65)
  den(893) = den(54)*den(145)
  den(894) = den(54)*den(147)
  den(895) = den(58)*den(145)
  den(896) = den(58)*den(147)
  den(897) = den(54)*den(108)
  den(898) = den(54)*den(111)
  den(899) = den(58)*den(108)
  den(900) = den(58)*den(111)
  den(901) = den(54)*den(113)
  den(902) = den(54)*den(115)
  den(903) = den(58)*den(113)
  den(904) = den(58)*den(115)
  den(905) = den(29)*den(55)*den(79)
  den(906) = den(29)*den(55)*den(82)
  den(907) = den(79)*den(102)
  den(908) = den(79)*den(105)
  den(909) = den(82)*den(102)
  den(910) = den(82)*den(105)
  den(911) = den(41)*den(65)*den(79)
  den(912) = den(41)*den(65)*den(82)
  den(913) = den(79)*den(149)
  den(914) = den(82)*den(149)
  den(915) = den(79)*den(151)
  den(916) = den(82)*den(151)
  den(917) = den(79)*den(124)
  den(918) = den(79)*den(127)
  den(919) = den(82)*den(124)
  den(920) = den(82)*den(127)
  den(921) = den(79)*den(135)
  den(922) = den(82)*den(135)
  den(923) = den(79)*den(137)
  den(924) = den(82)*den(137)
  den(925) = den(14)*den(29)
  den(926) = den(2)*den(41)
  den(927) = den(3)*den(65)
  den(928) = den(15)*den(55)
  den(929) = den(2)*den(698)
  den(930) = den(2)*den(699)
  den(931) = den(1)*den(771)
  den(932) = den(1)*den(772)
  den(933) = den(6)*den(771)
  den(934) = den(6)*den(772)
  den(935) = den(15)*den(690)
  den(936) = den(15)*den(691)
  den(937) = den(1)*den(795)
  den(938) = den(1)*den(796)
  den(939) = den(6)*den(795)
  den(940) = den(6)*den(796)
  den(941) = den(14)*den(696)
  den(942) = den(14)*den(697)
  den(943) = den(1)*den(819)
  den(944) = den(1)*den(820)
  den(945) = den(6)*den(819)
  den(946) = den(6)*den(820)
  den(947) = den(3)*den(688)
  den(948) = den(3)*den(689)
  den(949) = den(1)*den(843)
  den(950) = den(1)*den(844)
  den(951) = den(6)*den(843)
  den(952) = den(6)*den(844)
  den(953) = den(30)*den(759)
  den(954) = den(30)*den(760)
  den(955) = den(33)*den(759)
  den(956) = den(33)*den(760)
  den(957) = den(29)*den(715)
  den(958) = den(29)*den(716)
  den(959) = den(15)*den(707)
  den(960) = den(15)*den(708)
  den(961) = den(30)*den(791)
  den(962) = den(33)*den(791)
  den(963) = den(30)*den(792)
  den(964) = den(33)*den(792)
  den(965) = den(30)*den(807)
  den(966) = den(30)*den(808)
  den(967) = den(33)*den(807)
  den(968) = den(33)*den(808)
  den(969) = den(41)*den(713)
  den(970) = den(41)*den(714)
  den(971) = den(3)*den(705)
  den(972) = den(3)*den(706)
  den(973) = den(30)*den(839)
  den(974) = den(33)*den(839)
  den(975) = den(30)*den(840)
  den(976) = den(33)*den(840)
  den(977) = den(2)*den(731)
  den(978) = den(2)*den(732)
  den(979) = den(54)*den(769)
  den(980) = den(54)*den(770)
  den(981) = den(58)*den(769)
  den(982) = den(58)*den(770)
  den(983) = den(65)*den(723)
  den(984) = den(65)*den(724)
  den(985) = den(54)*den(783)
  den(986) = den(54)*den(784)
  den(987) = den(58)*den(783)
  den(988) = den(58)*den(784)
  den(989) = den(14)*den(729)
  den(990) = den(14)*den(730)
  den(991) = den(54)*den(817)
  den(992) = den(54)*den(818)
  den(993) = den(58)*den(817)
  den(994) = den(58)*den(818)
  den(995) = den(55)*den(721)
  den(996) = den(55)*den(722)
  den(997) = den(54)*den(831)
  den(998) = den(54)*den(832)
  den(999) = den(58)*den(831)
  den(1000) = den(58)*den(832)
  den(1001) = den(79)*den(757)
  den(1002) = den(79)*den(758)
  den(1003) = den(82)*den(757)
  den(1004) = den(82)*den(758)
  den(1005) = den(29)*den(747)
  den(1006) = den(29)*den(748)
  den(1007) = den(65)*den(739)
  den(1008) = den(65)*den(740)
  den(1009) = den(79)*den(779)
  den(1010) = den(82)*den(779)
  den(1011) = den(79)*den(780)
  den(1012) = den(82)*den(780)
  den(1013) = den(79)*den(805)
  den(1014) = den(79)*den(806)
  den(1015) = den(82)*den(805)
  den(1016) = den(82)*den(806)
  den(1017) = den(41)*den(745)
  den(1018) = den(41)*den(746)
  den(1019) = den(55)*den(737)
  den(1020) = den(55)*den(738)
  den(1021) = den(79)*den(827)
  den(1022) = den(82)*den(827)
  den(1023) = den(79)*den(828)
  den(1024) = den(82)*den(828)
  den(1025) = den(14)*den(751)
  den(1026) = den(14)*den(752)
  den(1027) = den(14)*den(755)
  den(1028) = den(14)*den(756)
  den(1029) = den(29)*den(813)
  den(1030) = den(29)*den(814)
  den(1031) = den(29)*den(815)
  den(1032) = den(29)*den(816)
  den(1033) = den(55)*den(753)
  den(1034) = den(55)*den(754)
  den(1035) = den(29)*den(829)
  den(1036) = den(29)*den(830)
  den(1037) = den(3)*den(749)
  den(1038) = den(3)*den(750)
  den(1039) = den(29)*den(841)
  den(1040) = den(29)*den(842)
  den(1041) = den(2)*den(799)
  den(1042) = den(2)*den(800)
  den(1043) = den(2)*den(803)
  den(1044) = den(2)*den(804)
  den(1045) = den(41)*den(765)
  den(1046) = den(41)*den(766)
  den(1047) = den(41)*den(767)
  den(1048) = den(41)*den(768)
  den(1049) = den(2)*den(825)
  den(1050) = den(2)*den(826)
  den(1051) = den(55)*den(763)
  den(1052) = den(55)*den(764)
  den(1053) = den(2)*den(837)
  den(1054) = den(2)*den(838)
  den(1055) = den(3)*den(761)
  den(1056) = den(3)*den(762)
  den(1057) = den(65)*den(801)
  den(1058) = den(65)*den(802)
  den(1059) = den(41)*den(781)
  den(1060) = den(41)*den(782)
  den(1061) = den(14)*den(777)
  den(1062) = den(14)*den(778)
  den(1063) = den(65)*den(811)
  den(1064) = den(65)*den(812)
  den(1065) = den(3)*den(773)
  den(1066) = den(3)*den(774)
  den(1067) = den(65)*den(833)
  den(1068) = den(65)*den(834)
  den(1069) = den(3)*den(775)
  den(1070) = den(3)*den(776)
  den(1071) = den(65)*den(835)
  den(1072) = den(65)*den(836)
  den(1073) = den(15)*den(797)
  den(1074) = den(15)*den(798)
  den(1075) = den(41)*den(793)
  den(1076) = den(41)*den(794)
  den(1077) = den(14)*den(789)
  den(1078) = den(14)*den(790)
  den(1079) = den(15)*den(809)
  den(1080) = den(15)*den(810)
  den(1081) = den(15)*den(821)
  den(1082) = den(15)*den(822)
  den(1083) = den(55)*den(785)
  den(1084) = den(55)*den(786)
  den(1085) = den(15)*den(823)
  den(1086) = den(15)*den(824)
  den(1087) = den(55)*den(787)
  den(1088) = den(55)*den(788)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_eeexexaa_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,730))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
  A(1:hel_states,1:730)%j = 0
  A(1:hel_states,1:730)%e = 0
  A(1:hel_states,1:730)%hf = 0
  A(1:hel_states,1:730)%s = 0
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppllll_ew_eeexexaa_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e- e+ e+ gamma gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppllll_ew_eeexexaa_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllll_ew_eeexexaa_1, only: &
    & external_perm_ppllll_ew_eeexexaa_1, &
    & external_perm_inv_ppllll_ew_eeexexaa_1, &
    & extcomb_perm_ppllll_ew_eeexexaa_1, &
    & average_factor_ppllll_ew_eeexexaa_1
  use ol_external_ppllll_ew_eeexexaa_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllll_ew_eeexexaa_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllll_ew_eeexexaa_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppllll_ew_eeexexaa_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(22)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(22)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,730))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppllll_ew_eeexexaa_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex3(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VQ_A(ntry, ex5(:), ex2(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_Q_A(ntry, wf4(:,2), 18, ZERO, 0_intkind1, wf4(:,4), n2(1))
  call prop_A_Q(ntry, wf4(:,3), 40, ZERO, 0_intkind1, wf4(:,5), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_QA_Z(gZl,ntry, ex1(:), ex3(:), wf4(:,6), n3(:,5), t3x4(:,:,4))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), wf4(:,4), wf16(:,2), n3(:,6), t3x16(:,:,2))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,1), n3(:,7), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex6(:), wf4(:,4), wf8(:,2), n3(:,8), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,1), 13, ZERO, 0_intkind1, wf8(:,3), n2(3))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,6), wf8(:,4), n3(:,9), t3x8(:,:,3))
  call prop_A_Q(ntry, wf8(:,4), 13, ZERO, 0_intkind1, wf8(:,5), n2(4))
  call vert_VQ_A(ntry, ex6(:), ex2(:), wf4(:,7), n3(:,10), t3x4(:,:,5))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,8), n3(:,11), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,7), 34, ZERO, 0_intkind1, wf4(:,9), n2(5))
  call prop_A_Q(ntry, wf4(:,8), 24, ZERO, 0_intkind1, wf4(:,10), n2(6))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,9), wf16(:,3), n3(:,12), t3x16(:,:,3))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), wf4(:,9), wf16(:,4), n3(:,13), t3x16(:,:,4))
  call vert_VQ_A(ntry, wf4(:,1), ex2(:), wf8(:,6), n3(:,14), t3x8(:,:,4))
  call vert_AV_Q(ntry, wf4(:,10), ex6(:), wf8(:,7), n3(:,15), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,6), 7, ZERO, 0_intkind1, wf8(:,8), n2(7))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), ex2(:), wf8(:,9), n3(:,16), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,9), 7, ZERO, 0_intkind1, wf8(:,10), n2(8))
  call vert_VQ_A(ntry, ex5(:), wf4(:,9), wf8(:,11), n3(:,17), t3x8(:,:,7))
  call vert_AV_Q(ntry, wf4(:,5), ex5(:), wf8(:,12), n3(:,18), t3x8(:,:,8))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,11), n3(:,19), t3x4(:,:,7))
  call vert_QA_V(ntry, ex2(:), ex3(:), wf4(:,12), n3(:,20), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,11), 17, ZERO, 0_intkind1, wf4(:,13), n2(9))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,13), wf16(:,5), n3(:,21), t3x16(:,:,5))
  call vert_QA_Z(gZl,ntry, ex2(:), ex3(:), wf4(:,14), n3(:,22), t3x4(:,:,9))
  call vert_ZQ_A(gZl,ntry, wf4(:,14), wf4(:,13), wf16(:,6), n3(:,23), t3x16(:,:,6))
  call vert_AV_Q(ntry, ex4(:), wf4(:,12), wf8(:,13), n3(:,24), t3x8(:,:,9))
  call vert_VQ_A(ntry, ex6(:), wf4(:,13), wf8(:,14), n3(:,25), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,13), 14, ZERO, 0_intkind1, wf8(:,15), n2(10))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,14), wf8(:,16), n3(:,26), t3x8(:,:,11))
  call prop_A_Q(ntry, wf8(:,16), 14, ZERO, 0_intkind1, wf8(:,17), n2(11))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,15), n3(:,27), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,15), 33, ZERO, 0_intkind1, wf4(:,16), n2(12))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,16), wf16(:,7), n3(:,28), t3x16(:,:,7))
  call vert_ZQ_A(gZl,ntry, wf4(:,14), wf4(:,16), wf16(:,8), n3(:,29), t3x16(:,:,8))
  call vert_VQ_A(ntry, wf4(:,12), ex1(:), wf8(:,18), n3(:,30), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,18), 7, ZERO, 0_intkind1, wf8(:,19), n2(13))
  call vert_ZQ_A(gZl,ntry, wf4(:,14), ex1(:), wf8(:,20), n3(:,31), t3x8(:,:,13))
  call prop_Q_A(ntry, wf8(:,20), 7, ZERO, 0_intkind1, wf8(:,21), n2(14))
  call vert_VQ_A(ntry, ex5(:), wf4(:,16), wf8(:,22), n3(:,32), t3x8(:,:,14))
  call vert_QA_V(ntry, ex1(:), ex4(:), wf4(:,17), n3(:,33), t3x4(:,:,11))
  call vert_AV_Q(ntry, ex3(:), ex6(:), wf4(:,18), n3(:,34), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,18), 36, ZERO, 0_intkind1, wf4(:,19), n2(15))
  call vert_VQ_A(ntry, wf4(:,17), wf4(:,4), wf16(:,9), n3(:,35), t3x16(:,:,9))
  call vert_QA_Z(gZl,ntry, ex1(:), ex4(:), wf4(:,20), n3(:,36), t3x4(:,:,13))
  call vert_ZQ_A(gZl,ntry, wf4(:,20), wf4(:,4), wf16(:,10), n3(:,37), t3x16(:,:,10))
  call vert_AV_Q(ntry, ex3(:), wf4(:,17), wf8(:,23), n3(:,38), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,23), 13, ZERO, 0_intkind1, wf8(:,24), n2(16))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,20), wf8(:,25), n3(:,39), t3x8(:,:,16))
  call prop_A_Q(ntry, wf8(:,25), 13, ZERO, 0_intkind1, wf8(:,26), n2(17))
  call vert_AV_Q(ntry, ex3(:), ex5(:), wf4(:,21), n3(:,40), t3x4(:,:,14))
  call prop_A_Q(ntry, wf4(:,21), 20, ZERO, 0_intkind1, wf4(:,22), n2(18))
  call vert_VQ_A(ntry, wf4(:,17), wf4(:,9), wf16(:,11), n3(:,41), t3x16(:,:,11))
  call vert_ZQ_A(gZl,ntry, wf4(:,20), wf4(:,9), wf16(:,12), n3(:,42), t3x16(:,:,12))
  call vert_VQ_A(ntry, wf4(:,17), ex2(:), wf8(:,27), n3(:,43), t3x8(:,:,17))
  call vert_AV_Q(ntry, wf4(:,22), ex6(:), wf8(:,28), n3(:,44), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,27), 11, ZERO, 0_intkind1, wf8(:,29), n2(19))
  call vert_ZQ_A(gZl,ntry, wf4(:,20), ex2(:), wf8(:,30), n3(:,45), t3x8(:,:,19))
  call prop_Q_A(ntry, wf8(:,30), 11, ZERO, 0_intkind1, wf8(:,31), n2(20))
  call vert_AV_Q(ntry, wf4(:,19), ex5(:), wf8(:,32), n3(:,46), t3x8(:,:,20))
  call vert_QA_V(ntry, ex2(:), ex4(:), wf4(:,23), n3(:,47), t3x4(:,:,15))
  call vert_VQ_A(ntry, wf4(:,23), wf4(:,13), wf16(:,13), n3(:,48), t3x16(:,:,13))
  call vert_QA_Z(gZl,ntry, ex2(:), ex4(:), wf4(:,24), n3(:,49), t3x4(:,:,16))
  call vert_ZQ_A(gZl,ntry, wf4(:,24), wf4(:,13), wf16(:,14), n3(:,50), t3x16(:,:,14))
  call vert_AV_Q(ntry, ex3(:), wf4(:,23), wf8(:,33), n3(:,51), t3x8(:,:,21))
  call prop_A_Q(ntry, wf8(:,33), 14, ZERO, 0_intkind1, wf8(:,34), n2(21))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,24), wf8(:,35), n3(:,52), t3x8(:,:,22))
  call prop_A_Q(ntry, wf8(:,35), 14, ZERO, 0_intkind1, wf8(:,36), n2(22))
  call vert_VQ_A(ntry, wf4(:,23), wf4(:,16), wf16(:,15), n3(:,53), t3x16(:,:,15))
  call vert_ZQ_A(gZl,ntry, wf4(:,24), wf4(:,16), wf16(:,16), n3(:,54), t3x16(:,:,16))
  call vert_VQ_A(ntry, wf4(:,23), ex1(:), wf8(:,37), n3(:,55), t3x8(:,:,23))
  call prop_Q_A(ntry, wf8(:,37), 11, ZERO, 0_intkind1, wf8(:,38), n2(23))
  call vert_ZQ_A(gZl,ntry, wf4(:,24), ex1(:), wf8(:,39), n3(:,56), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,39), 11, ZERO, 0_intkind1, wf8(:,40), n2(24))
  call vert_QA_V(ntry, wf4(:,13), ex3(:), wf8(:,41), n3(:,57), t3x8(:,:,25))
  call vert_QA_V(ntry, wf4(:,9), ex4(:), wf8(:,42), n3(:,58), t3x8(:,:,26))
  call vert_QA_Z(gZl,ntry, wf4(:,13), ex3(:), wf8(:,43), n3(:,59), t3x8(:,:,27))
  call vert_QA_Z(gZl,ntry, wf4(:,9), ex4(:), wf8(:,44), n3(:,60), t3x8(:,:,28))
  call vert_QA_V(ntry, wf4(:,9), ex3(:), wf8(:,45), n3(:,61), t3x8(:,:,29))
  call vert_QA_V(ntry, wf4(:,13), ex4(:), wf8(:,46), n3(:,62), t3x8(:,:,30))
  call vert_QA_Z(gZl,ntry, wf4(:,9), ex3(:), wf8(:,47), n3(:,63), t3x8(:,:,31))
  call vert_QA_Z(gZl,ntry, wf4(:,13), ex4(:), wf8(:,48), n3(:,64), t3x8(:,:,32))
  call vert_QA_V(ntry, ex2(:), wf4(:,19), wf8(:,49), n3(:,65), t3x8(:,:,33))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,19), wf8(:,50), n3(:,66), t3x8(:,:,34))
  call vert_QA_V(ntry, ex2(:), wf4(:,5), wf8(:,51), n3(:,67), t3x8(:,:,35))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,5), wf8(:,52), n3(:,68), t3x8(:,:,36))
  call vert_QA_V(ntry, wf4(:,16), ex3(:), wf8(:,53), n3(:,69), t3x8(:,:,37))
  call vert_QA_V(ntry, wf4(:,4), ex4(:), wf8(:,54), n3(:,70), t3x8(:,:,38))
  call vert_QA_Z(gZl,ntry, wf4(:,16), ex3(:), wf8(:,55), n3(:,71), t3x8(:,:,39))
  call vert_QA_Z(gZl,ntry, wf4(:,4), ex4(:), wf8(:,56), n3(:,72), t3x8(:,:,40))
  call vert_QA_V(ntry, wf4(:,4), ex3(:), wf8(:,57), n3(:,73), t3x8(:,:,41))
  call vert_QA_V(ntry, wf4(:,16), ex4(:), wf8(:,58), n3(:,74), t3x8(:,:,42))
  call vert_QA_Z(gZl,ntry, wf4(:,4), ex3(:), wf8(:,59), n3(:,75), t3x8(:,:,43))
  call vert_QA_Z(gZl,ntry, wf4(:,16), ex4(:), wf8(:,60), n3(:,76), t3x8(:,:,44))
  call vert_QA_V(ntry, ex1(:), wf4(:,19), wf8(:,61), n3(:,77), t3x8(:,:,45))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,19), wf8(:,62), n3(:,78), t3x8(:,:,46))
  call vert_QA_V(ntry, ex1(:), wf4(:,5), wf8(:,63), n3(:,79), t3x8(:,:,47))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,5), wf8(:,64), n3(:,80), t3x8(:,:,48))
  call vert_QA_V(ntry, ex2(:), wf4(:,22), wf8(:,65), n3(:,81), t3x8(:,:,49))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,22), wf8(:,66), n3(:,82), t3x8(:,:,50))
  call vert_QA_V(ntry, ex1(:), wf4(:,22), wf8(:,67), n3(:,83), t3x8(:,:,51))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,22), wf8(:,68), n3(:,84), t3x8(:,:,52))
  call vert_QA_V(ntry, ex2(:), wf4(:,10), wf8(:,69), n3(:,85), t3x8(:,:,53))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,10), wf8(:,70), n3(:,86), t3x8(:,:,54))
  call vert_QA_V(ntry, ex1(:), wf4(:,10), wf8(:,71), n3(:,87), t3x8(:,:,55))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,10), wf8(:,72), n3(:,88), t3x8(:,:,56))
  call counter_VVV_V(ntry, wf4(:,1), ex5(:), ex6(:), wf16(:,17), n4(:,1), t4x16(:,:,1))
  call counter_VVV_V(ntry, wf4(:,6), ex5(:), ex6(:), wf16(:,18), n4(:,2), t4x16(:,:,2))
  call counter_VVV_V(ntry, wf4(:,17), ex5(:), ex6(:), wf16(:,19), n4(:,3), t4x16(:,:,3))
  call counter_VVV_V(ntry, wf4(:,20), ex5(:), ex6(:), wf16(:,20), n4(:,4), t4x16(:,:,4))
  call counter_VV_S(ntry, ex5(:), ex6(:), wf4(:,25), n3(:,89), t3x4(:,:,17))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,24), wf16(:,21), n3(:,90), t3x16(:,:,17))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,1), wf4(:,4), wf16(:,22), n3(:,91), t3x16(:,:,18))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,6), wf4(:,4), wf16(:,23), n3(:,92), t3x16(:,:,19))
  call counter_ZQ_A(EWctAee,ntry, ex6(:), wf4(:,4), wf8(:,73), n3(:,93), t3x8(:,:,57))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,1), wf4(:,9), wf16(:,24), n3(:,94), t3x16(:,:,20))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,6), wf4(:,9), wf16(:,25), n3(:,95), t3x16(:,:,21))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,10), ex6(:), wf8(:,74), n3(:,96), t3x8(:,:,58))
  call counter_ZQ_A(EWctAee,ntry, ex5(:), wf4(:,9), wf8(:,75), n3(:,97), t3x8(:,:,59))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,5), ex5(:), wf8(:,76), n3(:,98), t3x8(:,:,60))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,1), wf8(:,77), n3(:,99), t3x8(:,:,61))
  call prop_Q_A(ntry, wf8(:,2), 50, ZERO, 0_intkind1, wf8(:,78), n2(25))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,6), wf8(:,79), n3(:,100), t3x8(:,:,62))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), ex6(:), wf4(:,26), n3(:,101), t3x4(:,:,18))
  call prop_A_Q(ntry, wf4(:,26), 40, ZERO, 0_intkind1, wf4(:,27), n2(26))
  call prop_Q_A(ntry, wf8(:,11), 50, ZERO, 0_intkind1, wf8(:,80), n2(27))
  call vert_AV_Q(ntry, wf4(:,27), ex5(:), wf8(:,81), n3(:,102), t3x8(:,:,63))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), ex5(:), wf4(:,28), n3(:,103), t3x4(:,:,19))
  call prop_A_Q(ntry, wf4(:,28), 24, ZERO, 0_intkind1, wf4(:,29), n2(28))
  call vert_AV_Q(ntry, wf4(:,29), ex6(:), wf8(:,82), n3(:,104), t3x8(:,:,64))
  call vert_VV_S(ntry, wf4(:,14), wf4(:,20), wf16(:,26), n3(:,105), t3x16(:,:,22))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,12), wf4(:,13), wf16(:,27), n3(:,106), t3x16(:,:,23))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,14), wf4(:,13), wf16(:,28), n3(:,107), t3x16(:,:,24))
  call counter_ZQ_A(EWctAee,ntry, ex6(:), wf4(:,13), wf8(:,83), n3(:,108), t3x8(:,:,65))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,12), wf4(:,16), wf16(:,29), n3(:,109), t3x16(:,:,25))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,14), wf4(:,16), wf16(:,30), n3(:,110), t3x16(:,:,26))
  call counter_ZQ_A(EWctAee,ntry, ex5(:), wf4(:,16), wf8(:,84), n3(:,111), t3x8(:,:,66))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,12), wf8(:,85), n3(:,112), t3x8(:,:,67))
  call prop_Q_A(ntry, wf8(:,14), 49, ZERO, 0_intkind1, wf8(:,86), n2(29))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,14), wf8(:,87), n3(:,113), t3x8(:,:,68))
  call prop_Q_A(ntry, wf8(:,22), 49, ZERO, 0_intkind1, wf8(:,88), n2(30))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,17), wf4(:,4), wf16(:,31), n3(:,114), t3x16(:,:,27))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,20), wf4(:,4), wf16(:,32), n3(:,115), t3x16(:,:,28))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,17), wf4(:,9), wf16(:,33), n3(:,116), t3x16(:,:,29))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,20), wf4(:,9), wf16(:,34), n3(:,117), t3x16(:,:,30))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,22), ex6(:), wf8(:,89), n3(:,118), t3x8(:,:,69))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,19), ex5(:), wf8(:,90), n3(:,119), t3x8(:,:,70))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,23), wf4(:,13), wf16(:,35), n3(:,120), t3x16(:,:,31))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,24), wf4(:,13), wf16(:,36), n3(:,121), t3x16(:,:,32))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,23), wf4(:,16), wf16(:,37), n3(:,122), t3x16(:,:,33))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,24), wf4(:,16), wf16(:,38), n3(:,123), t3x16(:,:,34))
  call counter_QA_Z(EWctAee,ntry, wf4(:,9), ex4(:), wf8(:,91), n3(:,124), t3x8(:,:,71))
  call counter_QA_Z(EWctVee,ntry, wf4(:,9), ex4(:), wf8(:,92), n3(:,125), t3x8(:,:,72))
  call counter_QA_Z(EWctAee,ntry, wf4(:,13), ex4(:), wf8(:,93), n3(:,126), t3x8(:,:,73))
  call counter_QA_Z(EWctVee,ntry, wf4(:,13), ex4(:), wf8(:,94), n3(:,127), t3x8(:,:,74))
  call vert_QA_V(ntry, ex2(:), wf4(:,27), wf8(:,95), n3(:,128), t3x8(:,:,75))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,27), wf8(:,96), n3(:,129), t3x8(:,:,76))
  call counter_QA_Z(EWctAee,ntry, wf4(:,4), ex4(:), wf8(:,97), n3(:,130), t3x8(:,:,77))
  call counter_QA_Z(EWctVee,ntry, wf4(:,4), ex4(:), wf8(:,98), n3(:,131), t3x8(:,:,78))
  call counter_QA_Z(EWctAee,ntry, wf4(:,16), ex4(:), wf8(:,99), n3(:,132), t3x8(:,:,79))
  call counter_QA_Z(EWctVee,ntry, wf4(:,16), ex4(:), wf8(:,100), n3(:,133), t3x8(:,:,80))
  call vert_QA_V(ntry, ex1(:), wf4(:,27), wf8(:,101), n3(:,134), t3x8(:,:,81))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,27), wf8(:,102), n3(:,135), t3x8(:,:,82))
  call vert_QA_V(ntry, ex2(:), wf4(:,29), wf8(:,103), n3(:,136), t3x8(:,:,83))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,29), wf8(:,104), n3(:,137), t3x8(:,:,84))
  call vert_QA_V(ntry, ex1(:), wf4(:,29), wf8(:,105), n3(:,138), t3x8(:,:,85))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,29), wf8(:,106), n3(:,139), t3x8(:,:,86))
  call counter_AZ_Q(EWctAee,ntry, ex3(:), wf4(:,17), wf8(:,107), n3(:,140), t3x8(:,:,87))
  call counter_AZ_Q(EWctVee,ntry, ex3(:), wf4(:,20), wf8(:,108), n3(:,141), t3x8(:,:,88))
  call counter_AZ_Q(EWctAee,ntry, ex3(:), ex6(:), wf4(:,30), n3(:,142), t3x4(:,:,20))
  call prop_A_Q(ntry, wf4(:,30), 36, ZERO, 0_intkind1, wf4(:,31), n2(31))
  call vert_AV_Q(ntry, wf4(:,31), ex5(:), wf8(:,109), n3(:,143), t3x8(:,:,89))
  call counter_AZ_Q(EWctAee,ntry, ex3(:), ex5(:), wf4(:,32), n3(:,144), t3x4(:,:,21))
  call prop_A_Q(ntry, wf4(:,32), 20, ZERO, 0_intkind1, wf4(:,33), n2(32))
  call vert_AV_Q(ntry, wf4(:,33), ex6(:), wf8(:,110), n3(:,145), t3x8(:,:,90))
  call counter_AZ_Q(EWctAee,ntry, ex3(:), wf4(:,23), wf8(:,111), n3(:,146), t3x8(:,:,91))
  call counter_AZ_Q(EWctVee,ntry, ex3(:), wf4(:,24), wf8(:,112), n3(:,147), t3x8(:,:,92))
  call counter_QA_Z(EWctAee,ntry, wf4(:,9), ex3(:), wf8(:,113), n3(:,148), t3x8(:,:,93))
  call counter_QA_Z(EWctVee,ntry, wf4(:,9), ex3(:), wf8(:,114), n3(:,149), t3x8(:,:,94))
  call counter_QA_Z(EWctAee,ntry, wf4(:,13), ex3(:), wf8(:,115), n3(:,150), t3x8(:,:,95))
  call counter_QA_Z(EWctVee,ntry, wf4(:,13), ex3(:), wf8(:,116), n3(:,151), t3x8(:,:,96))
  call vert_QA_V(ntry, ex2(:), wf4(:,31), wf8(:,117), n3(:,152), t3x8(:,:,97))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,31), wf8(:,118), n3(:,153), t3x8(:,:,98))
  call counter_QA_Z(EWctAee,ntry, wf4(:,4), ex3(:), wf8(:,119), n3(:,154), t3x8(:,:,99))
  call counter_QA_Z(EWctVee,ntry, wf4(:,4), ex3(:), wf8(:,120), n3(:,155), t3x8(:,:,100))
  call counter_QA_Z(EWctAee,ntry, wf4(:,16), ex3(:), wf8(:,121), n3(:,156), t3x8(:,:,101))
  call counter_QA_Z(EWctVee,ntry, wf4(:,16), ex3(:), wf8(:,122), n3(:,157), t3x8(:,:,102))
  call vert_QA_V(ntry, ex1(:), wf4(:,31), wf8(:,123), n3(:,158), t3x8(:,:,103))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,31), wf8(:,124), n3(:,159), t3x8(:,:,104))
  call vert_QA_V(ntry, ex2(:), wf4(:,33), wf8(:,125), n3(:,160), t3x8(:,:,105))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,33), wf8(:,126), n3(:,161), t3x8(:,:,106))
  call vert_QA_V(ntry, ex1(:), wf4(:,33), wf8(:,127), n3(:,162), t3x8(:,:,107))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,33), wf8(:,128), n3(:,163), t3x8(:,:,108))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,1), ex2(:), wf8(:,129), n3(:,164), t3x8(:,:,109))
  call prop_A_Q(ntry, wf8(:,7), 56, ZERO, 0_intkind1, wf8(:,130), n2(33))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,6), ex2(:), wf8(:,131), n3(:,165), t3x8(:,:,110))
  call counter_ZQ_A(EWctAee,ntry, ex6(:), ex2(:), wf4(:,34), n3(:,166), t3x4(:,:,22))
  call prop_Q_A(ntry, wf4(:,34), 34, ZERO, 0_intkind1, wf4(:,35), n2(34))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,35), wf16(:,39), n3(:,167), t3x16(:,:,35))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), wf4(:,35), wf16(:,40), n3(:,168), t3x16(:,:,36))
  call prop_A_Q(ntry, wf8(:,12), 56, ZERO, 0_intkind1, wf8(:,132), n2(35))
  call vert_VQ_A(ntry, ex5(:), wf4(:,35), wf8(:,133), n3(:,169), t3x8(:,:,111))
  call counter_ZQ_A(EWctAee,ntry, ex5(:), ex2(:), wf4(:,36), n3(:,170), t3x4(:,:,23))
  call prop_Q_A(ntry, wf4(:,36), 18, ZERO, 0_intkind1, wf4(:,37), n2(36))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,37), wf16(:,41), n3(:,171), t3x16(:,:,37))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), wf4(:,37), wf16(:,42), n3(:,172), t3x16(:,:,38))
  call vert_VQ_A(ntry, ex6(:), wf4(:,37), wf8(:,134), n3(:,173), t3x8(:,:,112))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,17), ex2(:), wf8(:,135), n3(:,174), t3x8(:,:,113))
  call prop_A_Q(ntry, wf8(:,28), 52, ZERO, 0_intkind1, wf8(:,136), n2(37))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,20), ex2(:), wf8(:,137), n3(:,175), t3x8(:,:,114))
  call vert_VQ_A(ntry, wf4(:,17), wf4(:,35), wf16(:,43), n3(:,176), t3x16(:,:,39))
  call vert_ZQ_A(gZl,ntry, wf4(:,20), wf4(:,35), wf16(:,44), n3(:,177), t3x16(:,:,40))
  call prop_A_Q(ntry, wf8(:,32), 52, ZERO, 0_intkind1, wf8(:,138), n2(38))
  call vert_VQ_A(ntry, wf4(:,17), wf4(:,37), wf16(:,45), n3(:,178), t3x16(:,:,41))
  call vert_ZQ_A(gZl,ntry, wf4(:,20), wf4(:,37), wf16(:,46), n3(:,179), t3x16(:,:,42))
  call counter_QA_Z(EWctAee,ntry, ex2(:), wf4(:,19), wf8(:,139), n3(:,180), t3x8(:,:,115))
  call counter_QA_Z(EWctVee,ntry, ex2(:), wf4(:,19), wf8(:,140), n3(:,181), t3x8(:,:,116))
  call counter_QA_Z(EWctAee,ntry, ex2(:), wf4(:,5), wf8(:,141), n3(:,182), t3x8(:,:,117))
  call counter_QA_Z(EWctVee,ntry, ex2(:), wf4(:,5), wf8(:,142), n3(:,183), t3x8(:,:,118))
  call vert_QA_V(ntry, wf4(:,35), ex4(:), wf8(:,143), n3(:,184), t3x8(:,:,119))
  call vert_QA_Z(gZl,ntry, wf4(:,35), ex4(:), wf8(:,144), n3(:,185), t3x8(:,:,120))
  call vert_QA_V(ntry, wf4(:,35), ex3(:), wf8(:,145), n3(:,186), t3x8(:,:,121))
  call vert_QA_Z(gZl,ntry, wf4(:,35), ex3(:), wf8(:,146), n3(:,187), t3x8(:,:,122))
  call counter_QA_Z(EWctAee,ntry, ex2(:), wf4(:,22), wf8(:,147), n3(:,188), t3x8(:,:,123))
  call counter_QA_Z(EWctVee,ntry, ex2(:), wf4(:,22), wf8(:,148), n3(:,189), t3x8(:,:,124))
  call counter_QA_Z(EWctAee,ntry, ex2(:), wf4(:,10), wf8(:,149), n3(:,190), t3x8(:,:,125))
  call counter_QA_Z(EWctVee,ntry, ex2(:), wf4(:,10), wf8(:,150), n3(:,191), t3x8(:,:,126))
  call vert_QA_V(ntry, wf4(:,37), ex4(:), wf8(:,151), n3(:,192), t3x8(:,:,127))
  call vert_QA_Z(gZl,ntry, wf4(:,37), ex4(:), wf8(:,152), n3(:,193), t3x8(:,:,128))
  call vert_QA_V(ntry, wf4(:,37), ex3(:), wf8(:,153), n3(:,194), t3x8(:,:,129))
  call vert_QA_Z(gZl,ntry, wf4(:,37), ex3(:), wf8(:,154), n3(:,195), t3x8(:,:,130))
  call counter_QA_Z(EWctAee,ntry, ex2(:), ex4(:), wf4(:,38), n3(:,196), t3x4(:,:,24))
  call vert_VQ_A(ntry, wf4(:,38), wf4(:,13), wf16(:,47), n3(:,197), t3x16(:,:,43))
  call counter_QA_Z(EWctVee,ntry, ex2(:), ex4(:), wf4(:,39), n3(:,198), t3x4(:,:,25))
  call vert_ZQ_A(gZl,ntry, wf4(:,39), wf4(:,13), wf16(:,48), n3(:,199), t3x16(:,:,44))
  call vert_AV_Q(ntry, ex3(:), wf4(:,38), wf8(:,155), n3(:,200), t3x8(:,:,131))
  call prop_A_Q(ntry, wf8(:,155), 14, ZERO, 0_intkind1, wf8(:,156), n2(39))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,39), wf8(:,157), n3(:,201), t3x8(:,:,132))
  call prop_A_Q(ntry, wf8(:,157), 14, ZERO, 0_intkind1, wf8(:,158), n2(40))
  call vert_VQ_A(ntry, wf4(:,38), wf4(:,16), wf16(:,49), n3(:,202), t3x16(:,:,45))
  call vert_ZQ_A(gZl,ntry, wf4(:,39), wf4(:,16), wf16(:,50), n3(:,203), t3x16(:,:,46))
  call vert_VQ_A(ntry, wf4(:,38), ex1(:), wf8(:,159), n3(:,204), t3x8(:,:,133))
  call prop_Q_A(ntry, wf8(:,159), 11, ZERO, 0_intkind1, wf8(:,160), n2(41))
  call vert_ZQ_A(gZl,ntry, wf4(:,39), ex1(:), wf8(:,161), n3(:,205), t3x8(:,:,134))
  call prop_Q_A(ntry, wf8(:,161), 11, ZERO, 0_intkind1, wf8(:,162), n2(42))
  call counter_QA_Z(EWctAee,ntry, ex2(:), ex3(:), wf4(:,40), n3(:,206), t3x4(:,:,26))
  call vert_VQ_A(ntry, wf4(:,40), wf4(:,13), wf16(:,51), n3(:,207), t3x16(:,:,47))
  call counter_QA_Z(EWctVee,ntry, ex2(:), ex3(:), wf4(:,41), n3(:,208), t3x4(:,:,27))
  call vert_ZQ_A(gZl,ntry, wf4(:,41), wf4(:,13), wf16(:,52), n3(:,209), t3x16(:,:,48))
  call vert_AV_Q(ntry, ex4(:), wf4(:,40), wf8(:,163), n3(:,210), t3x8(:,:,135))
  call prop_A_Q(ntry, wf8(:,163), 14, ZERO, 0_intkind1, wf8(:,164), n2(43))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,41), wf8(:,165), n3(:,211), t3x8(:,:,136))
  call prop_A_Q(ntry, wf8(:,165), 14, ZERO, 0_intkind1, wf8(:,166), n2(44))
  call vert_VQ_A(ntry, wf4(:,40), wf4(:,16), wf16(:,53), n3(:,212), t3x16(:,:,49))
  call vert_ZQ_A(gZl,ntry, wf4(:,41), wf4(:,16), wf16(:,54), n3(:,213), t3x16(:,:,50))
  call vert_VQ_A(ntry, wf4(:,40), ex1(:), wf8(:,167), n3(:,214), t3x8(:,:,137))
  call prop_Q_A(ntry, wf8(:,167), 7, ZERO, 0_intkind1, wf8(:,168), n2(45))
  call vert_ZQ_A(gZl,ntry, wf4(:,41), ex1(:), wf8(:,169), n3(:,215), t3x8(:,:,138))
  call prop_Q_A(ntry, wf8(:,169), 7, ZERO, 0_intkind1, wf8(:,170), n2(46))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,12), ex1(:), wf8(:,171), n3(:,216), t3x8(:,:,139))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,14), ex1(:), wf8(:,172), n3(:,217), t3x8(:,:,140))
  call counter_ZQ_A(EWctAee,ntry, ex6(:), ex1(:), wf4(:,42), n3(:,218), t3x4(:,:,28))
  call prop_Q_A(ntry, wf4(:,42), 33, ZERO, 0_intkind1, wf4(:,43), n2(47))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,43), wf16(:,55), n3(:,219), t3x16(:,:,51))
  call vert_ZQ_A(gZl,ntry, wf4(:,14), wf4(:,43), wf16(:,56), n3(:,220), t3x16(:,:,52))
  call vert_VQ_A(ntry, ex5(:), wf4(:,43), wf8(:,173), n3(:,221), t3x8(:,:,141))
  call counter_ZQ_A(EWctAee,ntry, ex5(:), ex1(:), wf4(:,44), n3(:,222), t3x4(:,:,29))
  call prop_Q_A(ntry, wf4(:,44), 17, ZERO, 0_intkind1, wf4(:,45), n2(48))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,45), wf16(:,57), n3(:,223), t3x16(:,:,53))
  call vert_ZQ_A(gZl,ntry, wf4(:,14), wf4(:,45), wf16(:,58), n3(:,224), t3x16(:,:,54))
  call vert_VQ_A(ntry, ex6(:), wf4(:,45), wf8(:,174), n3(:,225), t3x8(:,:,142))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,23), ex1(:), wf8(:,175), n3(:,226), t3x8(:,:,143))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,24), ex1(:), wf8(:,176), n3(:,227), t3x8(:,:,144))
  call vert_VQ_A(ntry, wf4(:,23), wf4(:,43), wf16(:,59), n3(:,228), t3x16(:,:,55))
  call vert_ZQ_A(gZl,ntry, wf4(:,24), wf4(:,43), wf16(:,60), n3(:,229), t3x16(:,:,56))
  call vert_VQ_A(ntry, wf4(:,23), wf4(:,45), wf16(:,61), n3(:,230), t3x16(:,:,57))
  call vert_ZQ_A(gZl,ntry, wf4(:,24), wf4(:,45), wf16(:,62), n3(:,231), t3x16(:,:,58))
  call counter_QA_Z(EWctAee,ntry, ex1(:), wf4(:,19), wf8(:,177), n3(:,232), t3x8(:,:,145))
  call counter_QA_Z(EWctVee,ntry, ex1(:), wf4(:,19), wf8(:,178), n3(:,233), t3x8(:,:,146))
  call counter_QA_Z(EWctAee,ntry, ex1(:), wf4(:,5), wf8(:,179), n3(:,234), t3x8(:,:,147))
  call counter_QA_Z(EWctVee,ntry, ex1(:), wf4(:,5), wf8(:,180), n3(:,235), t3x8(:,:,148))
  call vert_QA_V(ntry, wf4(:,43), ex3(:), wf8(:,181), n3(:,236), t3x8(:,:,149))
  call vert_QA_Z(gZl,ntry, wf4(:,43), ex3(:), wf8(:,182), n3(:,237), t3x8(:,:,150))
  call vert_QA_V(ntry, wf4(:,43), ex4(:), wf8(:,183), n3(:,238), t3x8(:,:,151))
  call vert_QA_Z(gZl,ntry, wf4(:,43), ex4(:), wf8(:,184), n3(:,239), t3x8(:,:,152))
  call counter_QA_Z(EWctAee,ntry, ex1(:), wf4(:,22), wf8(:,185), n3(:,240), t3x8(:,:,153))
  call counter_QA_Z(EWctVee,ntry, ex1(:), wf4(:,22), wf8(:,186), n3(:,241), t3x8(:,:,154))
  call counter_QA_Z(EWctAee,ntry, ex1(:), wf4(:,10), wf8(:,187), n3(:,242), t3x8(:,:,155))
  call counter_QA_Z(EWctVee,ntry, ex1(:), wf4(:,10), wf8(:,188), n3(:,243), t3x8(:,:,156))
  call vert_QA_V(ntry, wf4(:,45), ex3(:), wf8(:,189), n3(:,244), t3x8(:,:,157))
  call vert_QA_Z(gZl,ntry, wf4(:,45), ex3(:), wf8(:,190), n3(:,245), t3x8(:,:,158))
  call vert_QA_V(ntry, wf4(:,45), ex4(:), wf8(:,191), n3(:,246), t3x8(:,:,159))
  call vert_QA_Z(gZl,ntry, wf4(:,45), ex4(:), wf8(:,192), n3(:,247), t3x8(:,:,160))
  call counter_QA_Z(EWctAee,ntry, ex1(:), ex4(:), wf4(:,46), n3(:,248), t3x4(:,:,30))
  call vert_VQ_A(ntry, wf4(:,46), wf4(:,4), wf16(:,63), n3(:,249), t3x16(:,:,59))
  call counter_QA_Z(EWctVee,ntry, ex1(:), ex4(:), wf4(:,47), n3(:,250), t3x4(:,:,31))
  call vert_ZQ_A(gZl,ntry, wf4(:,47), wf4(:,4), wf16(:,64), n3(:,251), t3x16(:,:,60))
  call vert_AV_Q(ntry, ex3(:), wf4(:,46), wf8(:,193), n3(:,252), t3x8(:,:,161))
  call prop_A_Q(ntry, wf8(:,193), 13, ZERO, 0_intkind1, wf8(:,194), n2(49))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,47), wf8(:,195), n3(:,253), t3x8(:,:,162))
  call prop_A_Q(ntry, wf8(:,195), 13, ZERO, 0_intkind1, wf8(:,196), n2(50))
  call vert_VQ_A(ntry, wf4(:,46), wf4(:,9), wf16(:,65), n3(:,254), t3x16(:,:,61))
  call vert_ZQ_A(gZl,ntry, wf4(:,47), wf4(:,9), wf16(:,66), n3(:,255), t3x16(:,:,62))
  call vert_VQ_A(ntry, wf4(:,46), ex2(:), wf8(:,197), n3(:,256), t3x8(:,:,163))
  call prop_Q_A(ntry, wf8(:,197), 11, ZERO, 0_intkind1, wf8(:,198), n2(51))
  call vert_ZQ_A(gZl,ntry, wf4(:,47), ex2(:), wf8(:,199), n3(:,257), t3x8(:,:,164))
  call prop_Q_A(ntry, wf8(:,199), 11, ZERO, 0_intkind1, wf8(:,200), n2(52))
  call counter_QA_Z(EWctAee,ntry, ex1(:), ex3(:), wf4(:,48), n3(:,258), t3x4(:,:,32))
  call vert_VQ_A(ntry, wf4(:,48), wf4(:,4), wf16(:,67), n3(:,259), t3x16(:,:,63))
  call counter_QA_Z(EWctVee,ntry, ex1(:), ex3(:), wf4(:,49), n3(:,260), t3x4(:,:,33))
  call vert_ZQ_A(gZl,ntry, wf4(:,49), wf4(:,4), wf16(:,68), n3(:,261), t3x16(:,:,64))
  call vert_AV_Q(ntry, ex4(:), wf4(:,48), wf8(:,201), n3(:,262), t3x8(:,:,165))
  call prop_A_Q(ntry, wf8(:,201), 13, ZERO, 0_intkind1, wf8(:,202), n2(53))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,49), wf8(:,203), n3(:,263), t3x8(:,:,166))
  call prop_A_Q(ntry, wf8(:,203), 13, ZERO, 0_intkind1, wf8(:,204), n2(54))
  call vert_VQ_A(ntry, wf4(:,48), wf4(:,9), wf16(:,69), n3(:,264), t3x16(:,:,65))
  call vert_ZQ_A(gZl,ntry, wf4(:,49), wf4(:,9), wf16(:,70), n3(:,265), t3x16(:,:,66))
  call vert_VQ_A(ntry, wf4(:,48), ex2(:), wf8(:,205), n3(:,266), t3x8(:,:,167))
  call prop_Q_A(ntry, wf8(:,205), 7, ZERO, 0_intkind1, wf8(:,206), n2(55))
  call vert_ZQ_A(gZl,ntry, wf4(:,49), ex2(:), wf8(:,207), n3(:,267), t3x8(:,:,168))
  call prop_Q_A(ntry, wf8(:,207), 7, ZERO, 0_intkind1, wf8(:,208), n2(56))
  call vert_QA_V(ntry, wf4(:,4), wf4(:,5), wf16(:,71), n3(:,268), t3x16(:,:,67))
  call counter_V_V(EWctAA,ntry, wf4(:,1), 5, wf4(:,50), n2(57))
  call vert_QA_Z(gZl,ntry, wf4(:,4), wf4(:,5), wf16(:,72), n3(:,269), t3x16(:,:,68))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 5, wf4(:,51), n2(58))
  call counter_V_V(EWctAZ,ntry, wf4(:,6), 5, wf4(:,52), n2(59))
  call counter_V_V(EWctZZ,ntry, wf4(:,6), 5, wf4(:,53), n2(60))
  call vert_AV_Q(ntry, wf4(:,5), wf4(:,1), wf16(:,73), n3(:,270), t3x16(:,:,69))
  call counter_Q_A_LR(EWctee,ntry, wf4(:,4), 18, wf4(:,54), n2(61))
  call prop_A_Q(ntry, wf16(:,73), 45, ZERO, 0_intkind1, wf16(:,74), n2(62))
  call vert_AZ_Q(gZl,ntry, wf4(:,5), wf4(:,6), wf16(:,75), n3(:,271), t3x16(:,:,70))
  call prop_A_Q(ntry, wf16(:,75), 45, ZERO, 0_intkind1, wf16(:,76), n2(63))
  call counter_A_Q_LR(EWctee,ntry, wf4(:,5), 40, wf4(:,55), n2(64))
  call prop_Q_A(ntry, wf16(:,1), 23, ZERO, 0_intkind1, wf16(:,77), n2(65))
  call prop_Q_A(ntry, wf16(:,2), 23, ZERO, 0_intkind1, wf16(:,78), n2(66))
  call vert_AV_Q(ntry, ex4(:), wf4(:,50), wf8(:,209), n3(:,272), t3x8(:,:,169))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,51), wf8(:,210), n3(:,273), t3x8(:,:,170))
  call vert_AV_Q(ntry, ex4(:), wf4(:,52), wf8(:,211), n3(:,274), t3x8(:,:,171))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,53), wf8(:,212), n3(:,275), t3x8(:,:,172))
  call prop_Q_A(ntry, wf4(:,54), 18, ZERO, 0_intkind1, wf4(:,56), n2(67))
  call vert_VQ_A(ntry, ex6(:), wf4(:,56), wf8(:,213), n3(:,276), t3x8(:,:,173))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,3), 13, wf8(:,214), n2(68))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,5), 13, wf8(:,215), n2(69))
  call vert_QA_V(ntry, wf4(:,9), wf4(:,10), wf16(:,79), n3(:,277), t3x16(:,:,71))
  call vert_QA_Z(gZl,ntry, wf4(:,9), wf4(:,10), wf16(:,80), n3(:,278), t3x16(:,:,72))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,1), wf16(:,81), n3(:,279), t3x16(:,:,73))
  call counter_Q_A_LR(EWctee,ntry, wf4(:,9), 34, wf4(:,57), n2(70))
  call prop_A_Q(ntry, wf16(:,81), 29, ZERO, 0_intkind1, wf16(:,82), n2(71))
  call vert_AZ_Q(gZl,ntry, wf4(:,10), wf4(:,6), wf16(:,83), n3(:,280), t3x16(:,:,74))
  call prop_A_Q(ntry, wf16(:,83), 29, ZERO, 0_intkind1, wf16(:,84), n2(72))
  call counter_A_Q_LR(EWctee,ntry, wf4(:,10), 24, wf4(:,58), n2(73))
  call prop_Q_A(ntry, wf16(:,3), 39, ZERO, 0_intkind1, wf16(:,85), n2(74))
  call prop_Q_A(ntry, wf16(:,4), 39, ZERO, 0_intkind1, wf16(:,86), n2(75))
  call vert_VQ_A(ntry, wf4(:,50), ex2(:), wf8(:,216), n3(:,281), t3x8(:,:,174))
  call vert_ZQ_A(gZl,ntry, wf4(:,51), ex2(:), wf8(:,217), n3(:,282), t3x8(:,:,175))
  call vert_VQ_A(ntry, wf4(:,52), ex2(:), wf8(:,218), n3(:,283), t3x8(:,:,176))
  call vert_ZQ_A(gZl,ntry, wf4(:,53), ex2(:), wf8(:,219), n3(:,284), t3x8(:,:,177))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,8), 7, wf8(:,220), n2(76))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,10), 7, wf8(:,221), n2(77))
  call prop_A_Q(ntry, wf4(:,58), 24, ZERO, 0_intkind1, wf4(:,59), n2(78))
  call vert_AV_Q(ntry, wf4(:,59), ex6(:), wf8(:,222), n3(:,285), t3x8(:,:,178))
  call prop_Q_A(ntry, wf4(:,57), 34, ZERO, 0_intkind1, wf4(:,60), n2(79))
  call vert_VQ_A(ntry, ex5(:), wf4(:,60), wf8(:,223), n3(:,286), t3x8(:,:,179))
  call prop_A_Q(ntry, wf4(:,55), 40, ZERO, 0_intkind1, wf4(:,61), n2(80))
  call vert_AV_Q(ntry, wf4(:,61), ex5(:), wf8(:,224), n3(:,287), t3x8(:,:,180))
  call vert_AV_Q(ntry, wf4(:,5), wf4(:,12), wf16(:,87), n3(:,288), t3x16(:,:,75))
  call counter_Q_A_LR(EWctee,ntry, wf4(:,13), 17, wf4(:,62), n2(81))
  call prop_A_Q(ntry, wf16(:,87), 46, ZERO, 0_intkind1, wf16(:,88), n2(82))
  call vert_AZ_Q(gZl,ntry, wf4(:,5), wf4(:,14), wf16(:,89), n3(:,289), t3x16(:,:,76))
  call prop_A_Q(ntry, wf16(:,89), 46, ZERO, 0_intkind1, wf16(:,90), n2(83))
  call vert_QA_V(ntry, wf4(:,13), wf4(:,5), wf16(:,91), n3(:,290), t3x16(:,:,77))
  call counter_V_V(EWctAA,ntry, wf4(:,12), 6, wf4(:,63), n2(84))
  call vert_QA_Z(gZl,ntry, wf4(:,13), wf4(:,5), wf16(:,92), n3(:,291), t3x16(:,:,78))
  call counter_V_V(EWctAZ,ntry, wf4(:,12), 6, wf4(:,64), n2(85))
  call counter_V_V(EWctAZ,ntry, wf4(:,14), 6, wf4(:,65), n2(86))
  call counter_V_V(EWctZZ,ntry, wf4(:,14), 6, wf4(:,66), n2(87))
  call prop_Q_A(ntry, wf16(:,5), 23, ZERO, 0_intkind1, wf16(:,93), n2(88))
  call prop_Q_A(ntry, wf16(:,6), 23, ZERO, 0_intkind1, wf16(:,94), n2(89))
  call prop_Q_A(ntry, wf4(:,62), 17, ZERO, 0_intkind1, wf4(:,67), n2(90))
  call vert_VQ_A(ntry, ex6(:), wf4(:,67), wf8(:,225), n3(:,292), t3x8(:,:,181))
  call vert_AV_Q(ntry, ex4(:), wf4(:,63), wf8(:,226), n3(:,293), t3x8(:,:,182))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,64), wf8(:,227), n3(:,294), t3x8(:,:,183))
  call vert_AV_Q(ntry, ex4(:), wf4(:,65), wf8(:,228), n3(:,295), t3x8(:,:,184))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,66), wf8(:,229), n3(:,296), t3x8(:,:,185))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,15), 14, wf8(:,230), n2(91))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,17), 14, wf8(:,231), n2(92))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,12), wf16(:,95), n3(:,297), t3x16(:,:,79))
  call counter_Q_A_LR(EWctee,ntry, wf4(:,16), 33, wf4(:,68), n2(93))
  call prop_A_Q(ntry, wf16(:,95), 30, ZERO, 0_intkind1, wf16(:,96), n2(94))
  call vert_AZ_Q(gZl,ntry, wf4(:,10), wf4(:,14), wf16(:,97), n3(:,298), t3x16(:,:,80))
  call prop_A_Q(ntry, wf16(:,97), 30, ZERO, 0_intkind1, wf16(:,98), n2(95))
  call vert_QA_V(ntry, wf4(:,16), wf4(:,10), wf16(:,99), n3(:,299), t3x16(:,:,81))
  call vert_QA_Z(gZl,ntry, wf4(:,16), wf4(:,10), wf16(:,100), n3(:,300), t3x16(:,:,82))
  call prop_Q_A(ntry, wf16(:,7), 39, ZERO, 0_intkind1, wf16(:,101), n2(96))
  call prop_Q_A(ntry, wf16(:,8), 39, ZERO, 0_intkind1, wf16(:,102), n2(97))
  call vert_VQ_A(ntry, wf4(:,63), ex1(:), wf8(:,232), n3(:,301), t3x8(:,:,186))
  call vert_VQ_A(ntry, wf4(:,65), ex1(:), wf8(:,233), n3(:,302), t3x8(:,:,187))
  call vert_ZQ_A(gZl,ntry, wf4(:,64), ex1(:), wf8(:,234), n3(:,303), t3x8(:,:,188))
  call vert_ZQ_A(gZl,ntry, wf4(:,66), ex1(:), wf8(:,235), n3(:,304), t3x8(:,:,189))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,19), 7, wf8(:,236), n2(98))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,21), 7, wf8(:,237), n2(99))
  call prop_Q_A(ntry, wf4(:,68), 33, ZERO, 0_intkind1, wf4(:,69), n2(100))
  call vert_VQ_A(ntry, ex5(:), wf4(:,69), wf8(:,238), n3(:,305), t3x8(:,:,190))
  call vert_QA_V(ntry, wf4(:,4), wf4(:,19), wf16(:,103), n3(:,306), t3x16(:,:,83))
  call counter_V_V(EWctAA,ntry, wf4(:,17), 9, wf4(:,70), n2(101))
  call vert_QA_Z(gZl,ntry, wf4(:,4), wf4(:,19), wf16(:,104), n3(:,307), t3x16(:,:,84))
  call counter_V_V(EWctAZ,ntry, wf4(:,17), 9, wf4(:,71), n2(102))
  call counter_V_V(EWctAZ,ntry, wf4(:,20), 9, wf4(:,72), n2(103))
  call counter_V_V(EWctZZ,ntry, wf4(:,20), 9, wf4(:,73), n2(104))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,17), wf16(:,105), n3(:,308), t3x16(:,:,85))
  call prop_A_Q(ntry, wf16(:,105), 45, ZERO, 0_intkind1, wf16(:,106), n2(105))
  call vert_AZ_Q(gZl,ntry, wf4(:,19), wf4(:,20), wf16(:,107), n3(:,309), t3x16(:,:,86))
  call prop_A_Q(ntry, wf16(:,107), 45, ZERO, 0_intkind1, wf16(:,108), n2(106))
  call counter_A_Q_LR(EWctee,ntry, wf4(:,19), 36, wf4(:,74), n2(107))
  call prop_Q_A(ntry, wf16(:,9), 27, ZERO, 0_intkind1, wf16(:,109), n2(108))
  call prop_Q_A(ntry, wf16(:,10), 27, ZERO, 0_intkind1, wf16(:,110), n2(109))
  call vert_AV_Q(ntry, ex3(:), wf4(:,70), wf8(:,239), n3(:,310), t3x8(:,:,191))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,71), wf8(:,240), n3(:,311), t3x8(:,:,192))
  call vert_AV_Q(ntry, ex3(:), wf4(:,72), wf8(:,241), n3(:,312), t3x8(:,:,193))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,73), wf8(:,242), n3(:,313), t3x8(:,:,194))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,24), 13, wf8(:,243), n2(110))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,26), 13, wf8(:,244), n2(111))
  call vert_QA_V(ntry, wf4(:,9), wf4(:,22), wf16(:,111), n3(:,314), t3x16(:,:,87))
  call vert_QA_Z(gZl,ntry, wf4(:,9), wf4(:,22), wf16(:,112), n3(:,315), t3x16(:,:,88))
  call vert_AV_Q(ntry, wf4(:,22), wf4(:,17), wf16(:,113), n3(:,316), t3x16(:,:,89))
  call prop_A_Q(ntry, wf16(:,113), 29, ZERO, 0_intkind1, wf16(:,114), n2(112))
  call vert_AZ_Q(gZl,ntry, wf4(:,22), wf4(:,20), wf16(:,115), n3(:,317), t3x16(:,:,90))
  call prop_A_Q(ntry, wf16(:,115), 29, ZERO, 0_intkind1, wf16(:,116), n2(113))
  call counter_A_Q_LR(EWctee,ntry, wf4(:,22), 20, wf4(:,75), n2(114))
  call prop_Q_A(ntry, wf16(:,11), 43, ZERO, 0_intkind1, wf16(:,117), n2(115))
  call prop_Q_A(ntry, wf16(:,12), 43, ZERO, 0_intkind1, wf16(:,118), n2(116))
  call vert_VQ_A(ntry, wf4(:,70), ex2(:), wf8(:,245), n3(:,318), t3x8(:,:,195))
  call vert_ZQ_A(gZl,ntry, wf4(:,71), ex2(:), wf8(:,246), n3(:,319), t3x8(:,:,196))
  call vert_VQ_A(ntry, wf4(:,72), ex2(:), wf8(:,247), n3(:,320), t3x8(:,:,197))
  call vert_ZQ_A(gZl,ntry, wf4(:,73), ex2(:), wf8(:,248), n3(:,321), t3x8(:,:,198))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,29), 11, wf8(:,249), n2(117))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,31), 11, wf8(:,250), n2(118))
  call prop_A_Q(ntry, wf4(:,75), 20, ZERO, 0_intkind1, wf4(:,76), n2(119))
  call vert_AV_Q(ntry, wf4(:,76), ex6(:), wf8(:,251), n3(:,322), t3x8(:,:,199))
  call prop_A_Q(ntry, wf4(:,74), 36, ZERO, 0_intkind1, wf4(:,77), n2(120))
  call vert_AV_Q(ntry, wf4(:,77), ex5(:), wf8(:,252), n3(:,323), t3x8(:,:,200))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,23), wf16(:,119), n3(:,324), t3x16(:,:,91))
  call prop_A_Q(ntry, wf16(:,119), 46, ZERO, 0_intkind1, wf16(:,120), n2(121))
  call vert_AZ_Q(gZl,ntry, wf4(:,19), wf4(:,24), wf16(:,121), n3(:,325), t3x16(:,:,92))
  call prop_A_Q(ntry, wf16(:,121), 46, ZERO, 0_intkind1, wf16(:,122), n2(122))
  call vert_QA_V(ntry, wf4(:,13), wf4(:,19), wf16(:,123), n3(:,326), t3x16(:,:,93))
  call counter_V_V(EWctAA,ntry, wf4(:,23), 10, wf4(:,78), n2(123))
  call vert_QA_Z(gZl,ntry, wf4(:,13), wf4(:,19), wf16(:,124), n3(:,327), t3x16(:,:,94))
  call counter_V_V(EWctAZ,ntry, wf4(:,23), 10, wf4(:,79), n2(124))
  call counter_V_V(EWctAZ,ntry, wf4(:,24), 10, wf4(:,80), n2(125))
  call counter_V_V(EWctZZ,ntry, wf4(:,24), 10, wf4(:,81), n2(126))
  call prop_Q_A(ntry, wf16(:,13), 27, ZERO, 0_intkind1, wf16(:,125), n2(127))
  call prop_Q_A(ntry, wf16(:,14), 27, ZERO, 0_intkind1, wf16(:,126), n2(128))
  call vert_AV_Q(ntry, ex3(:), wf4(:,78), wf8(:,253), n3(:,328), t3x8(:,:,201))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,79), wf8(:,254), n3(:,329), t3x8(:,:,202))
  call vert_AV_Q(ntry, ex3(:), wf4(:,80), wf8(:,255), n3(:,330), t3x8(:,:,203))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,81), wf8(:,256), n3(:,331), t3x8(:,:,204))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,34), 14, wf8(:,257), n2(129))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,36), 14, wf8(:,258), n2(130))
  call vert_AV_Q(ntry, wf4(:,22), wf4(:,23), wf16(:,127), n3(:,332), t3x16(:,:,95))
  call prop_A_Q(ntry, wf16(:,127), 30, ZERO, 0_intkind1, wf16(:,128), n2(131))
  call vert_AZ_Q(gZl,ntry, wf4(:,22), wf4(:,24), wf16(:,129), n3(:,333), t3x16(:,:,96))
  call prop_A_Q(ntry, wf16(:,129), 30, ZERO, 0_intkind1, wf16(:,130), n2(132))
  call vert_QA_V(ntry, wf4(:,16), wf4(:,22), wf16(:,131), n3(:,334), t3x16(:,:,97))
  call vert_QA_Z(gZl,ntry, wf4(:,16), wf4(:,22), wf16(:,132), n3(:,335), t3x16(:,:,98))
  call prop_Q_A(ntry, wf16(:,15), 43, ZERO, 0_intkind1, wf16(:,133), n2(133))
  call prop_Q_A(ntry, wf16(:,16), 43, ZERO, 0_intkind1, wf16(:,134), n2(134))
  call vert_VQ_A(ntry, wf4(:,78), ex1(:), wf8(:,259), n3(:,336), t3x8(:,:,205))
  call vert_VQ_A(ntry, wf4(:,80), ex1(:), wf8(:,260), n3(:,337), t3x8(:,:,206))
  call vert_ZQ_A(gZl,ntry, wf4(:,79), ex1(:), wf8(:,261), n3(:,338), t3x8(:,:,207))
  call vert_ZQ_A(gZl,ntry, wf4(:,81), ex1(:), wf8(:,262), n3(:,339), t3x8(:,:,208))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,38), 11, wf8(:,263), n2(135))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,40), 11, wf8(:,264), n2(136))
  call vert_QA_V(ntry, wf4(:,67), ex3(:), wf8(:,265), n3(:,340), t3x8(:,:,209))
  call vert_QA_Z(gZl,ntry, wf4(:,67), ex3(:), wf8(:,266), n3(:,341), t3x8(:,:,210))
  call vert_QA_V(ntry, wf4(:,67), ex4(:), wf8(:,267), n3(:,342), t3x8(:,:,211))
  call vert_QA_Z(gZl,ntry, wf4(:,67), ex4(:), wf8(:,268), n3(:,343), t3x8(:,:,212))
  call vert_QA_V(ntry, wf4(:,60), ex3(:), wf8(:,269), n3(:,344), t3x8(:,:,213))
  call vert_QA_Z(gZl,ntry, wf4(:,60), ex3(:), wf8(:,270), n3(:,345), t3x8(:,:,214))
  call vert_QA_V(ntry, wf4(:,60), ex4(:), wf8(:,271), n3(:,346), t3x8(:,:,215))
  call vert_QA_Z(gZl,ntry, wf4(:,60), ex4(:), wf8(:,272), n3(:,347), t3x8(:,:,216))
  call counter_V_V(EWctAA,ntry, wf8(:,41), 21, wf8(:,273), n2(137))
  call counter_V_V(EWctAZ,ntry, wf8(:,41), 21, wf8(:,274), n2(138))
  call counter_V_V(EWctAZ,ntry, wf8(:,43), 21, wf8(:,275), n2(139))
  call counter_V_V(EWctZZ,ntry, wf8(:,43), 21, wf8(:,276), n2(140))
  call counter_V_V(EWctAA,ntry, wf8(:,45), 38, wf8(:,277), n2(141))
  call counter_V_V(EWctAZ,ntry, wf8(:,45), 38, wf8(:,278), n2(142))
  call counter_V_V(EWctAZ,ntry, wf8(:,47), 38, wf8(:,279), n2(143))
  call counter_V_V(EWctZZ,ntry, wf8(:,47), 38, wf8(:,280), n2(144))
  call vert_QA_V(ntry, ex2(:), wf4(:,77), wf8(:,281), n3(:,348), t3x8(:,:,217))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,77), wf8(:,282), n3(:,349), t3x8(:,:,218))
  call counter_V_V(EWctAA,ntry, wf8(:,49), 38, wf8(:,283), n2(145))
  call counter_V_V(EWctAZ,ntry, wf8(:,49), 38, wf8(:,284), n2(146))
  call counter_V_V(EWctAZ,ntry, wf8(:,50), 38, wf8(:,285), n2(147))
  call counter_V_V(EWctZZ,ntry, wf8(:,50), 38, wf8(:,286), n2(148))
  call counter_V_V(EWctAA,ntry, wf8(:,51), 42, wf8(:,287), n2(149))
  call counter_V_V(EWctAZ,ntry, wf8(:,51), 42, wf8(:,288), n2(150))
  call counter_V_V(EWctAZ,ntry, wf8(:,52), 42, wf8(:,289), n2(151))
  call counter_V_V(EWctZZ,ntry, wf8(:,52), 42, wf8(:,290), n2(152))
  call vert_QA_V(ntry, ex2(:), wf4(:,61), wf8(:,291), n3(:,350), t3x8(:,:,219))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,61), wf8(:,292), n3(:,351), t3x8(:,:,220))
  call vert_QA_V(ntry, wf4(:,69), ex3(:), wf8(:,293), n3(:,352), t3x8(:,:,221))
  call vert_QA_Z(gZl,ntry, wf4(:,69), ex3(:), wf8(:,294), n3(:,353), t3x8(:,:,222))
  call vert_QA_V(ntry, wf4(:,69), ex4(:), wf8(:,295), n3(:,354), t3x8(:,:,223))
  call vert_QA_Z(gZl,ntry, wf4(:,69), ex4(:), wf8(:,296), n3(:,355), t3x8(:,:,224))
  call vert_QA_V(ntry, wf4(:,56), ex3(:), wf8(:,297), n3(:,356), t3x8(:,:,225))
  call vert_QA_Z(gZl,ntry, wf4(:,56), ex3(:), wf8(:,298), n3(:,357), t3x8(:,:,226))
  call vert_QA_V(ntry, wf4(:,56), ex4(:), wf8(:,299), n3(:,358), t3x8(:,:,227))
  call vert_QA_Z(gZl,ntry, wf4(:,56), ex4(:), wf8(:,300), n3(:,359), t3x8(:,:,228))
  call counter_V_V(EWctAA,ntry, wf8(:,53), 37, wf8(:,301), n2(153))
  call counter_V_V(EWctAZ,ntry, wf8(:,53), 37, wf8(:,302), n2(154))
  call counter_V_V(EWctAZ,ntry, wf8(:,55), 37, wf8(:,303), n2(155))
  call counter_V_V(EWctZZ,ntry, wf8(:,55), 37, wf8(:,304), n2(156))
  call counter_V_V(EWctAA,ntry, wf8(:,57), 22, wf8(:,305), n2(157))
  call counter_V_V(EWctAZ,ntry, wf8(:,57), 22, wf8(:,306), n2(158))
  call counter_V_V(EWctAZ,ntry, wf8(:,59), 22, wf8(:,307), n2(159))
  call counter_V_V(EWctZZ,ntry, wf8(:,59), 22, wf8(:,308), n2(160))
  call vert_QA_V(ntry, ex1(:), wf4(:,77), wf8(:,309), n3(:,360), t3x8(:,:,229))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,77), wf8(:,310), n3(:,361), t3x8(:,:,230))
  call counter_V_V(EWctAA,ntry, wf8(:,61), 37, wf8(:,311), n2(161))
  call counter_V_V(EWctAZ,ntry, wf8(:,61), 37, wf8(:,312), n2(162))
  call counter_V_V(EWctAZ,ntry, wf8(:,62), 37, wf8(:,313), n2(163))
  call counter_V_V(EWctZZ,ntry, wf8(:,62), 37, wf8(:,314), n2(164))
  call counter_V_V(EWctAA,ntry, wf8(:,63), 41, wf8(:,315), n2(165))
  call counter_V_V(EWctAZ,ntry, wf8(:,63), 41, wf8(:,316), n2(166))
  call counter_V_V(EWctAZ,ntry, wf8(:,64), 41, wf8(:,317), n2(167))
  call counter_V_V(EWctZZ,ntry, wf8(:,64), 41, wf8(:,318), n2(168))
  call vert_QA_V(ntry, ex1(:), wf4(:,61), wf8(:,319), n3(:,362), t3x8(:,:,231))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,61), wf8(:,320), n3(:,363), t3x8(:,:,232))
  call vert_QA_V(ntry, ex2(:), wf4(:,76), wf8(:,321), n3(:,364), t3x8(:,:,233))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,76), wf8(:,322), n3(:,365), t3x8(:,:,234))
  call counter_V_V(EWctAA,ntry, wf8(:,65), 22, wf8(:,323), n2(169))
  call counter_V_V(EWctAZ,ntry, wf8(:,65), 22, wf8(:,324), n2(170))
  call counter_V_V(EWctAZ,ntry, wf8(:,66), 22, wf8(:,325), n2(171))
  call counter_V_V(EWctZZ,ntry, wf8(:,66), 22, wf8(:,326), n2(172))
  call vert_QA_V(ntry, ex1(:), wf4(:,76), wf8(:,327), n3(:,366), t3x8(:,:,235))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,76), wf8(:,328), n3(:,367), t3x8(:,:,236))
  call counter_V_V(EWctAA,ntry, wf8(:,67), 21, wf8(:,329), n2(173))
  call counter_V_V(EWctAZ,ntry, wf8(:,67), 21, wf8(:,330), n2(174))
  call counter_V_V(EWctAZ,ntry, wf8(:,68), 21, wf8(:,331), n2(175))
  call counter_V_V(EWctZZ,ntry, wf8(:,68), 21, wf8(:,332), n2(176))
  call counter_V_V(EWctAA,ntry, wf8(:,69), 26, wf8(:,333), n2(177))
  call counter_V_V(EWctAZ,ntry, wf8(:,69), 26, wf8(:,334), n2(178))
  call counter_V_V(EWctAZ,ntry, wf8(:,70), 26, wf8(:,335), n2(179))
  call counter_V_V(EWctZZ,ntry, wf8(:,70), 26, wf8(:,336), n2(180))
  call vert_QA_V(ntry, ex2(:), wf4(:,59), wf8(:,337), n3(:,368), t3x8(:,:,237))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,59), wf8(:,338), n3(:,369), t3x8(:,:,238))
  call counter_V_V(EWctAA,ntry, wf8(:,71), 25, wf8(:,339), n2(181))
  call counter_V_V(EWctAZ,ntry, wf8(:,71), 25, wf8(:,340), n2(182))
  call counter_V_V(EWctAZ,ntry, wf8(:,72), 25, wf8(:,341), n2(183))
  call counter_V_V(EWctZZ,ntry, wf8(:,72), 25, wf8(:,342), n2(184))
  call vert_QA_V(ntry, ex1(:), wf4(:,59), wf8(:,343), n3(:,370), t3x8(:,:,239))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,59), wf8(:,344), n3(:,371), t3x8(:,:,240))
  call vert_QA_V(ntry, wf8(:,8), ex4(:), wf16(:,135), n3(:,372), t3x16(:,:,99))
  call vert_QA_Z(gZl,ntry, wf8(:,8), ex4(:), wf16(:,136), n3(:,373), t3x16(:,:,100))
  call vert_QA_V(ntry, wf8(:,10), ex4(:), wf16(:,137), n3(:,374), t3x16(:,:,101))
  call vert_QA_Z(gZl,ntry, wf8(:,10), ex4(:), wf16(:,138), n3(:,375), t3x16(:,:,102))
  call vert_VQ_A(ntry, ex5(:), wf8(:,8), wf16(:,139), n3(:,376), t3x16(:,:,103))
  call prop_Q_A(ntry, wf16(:,139), 23, ZERO, 0_intkind1, wf16(:,140), n2(185))
  call vert_VQ_A(ntry, ex5(:), wf8(:,10), wf16(:,141), n3(:,377), t3x16(:,:,104))
  call prop_Q_A(ntry, wf16(:,141), 23, ZERO, 0_intkind1, wf16(:,142), n2(186))
  call vert_VQ_A(ntry, ex6(:), wf8(:,8), wf16(:,143), n3(:,378), t3x16(:,:,105))
  call prop_Q_A(ntry, wf16(:,143), 39, ZERO, 0_intkind1, wf16(:,144), n2(187))
  call vert_VQ_A(ntry, ex6(:), wf8(:,10), wf16(:,145), n3(:,379), t3x16(:,:,106))
  call prop_Q_A(ntry, wf16(:,145), 39, ZERO, 0_intkind1, wf16(:,146), n2(188))
  call vert_QA_V(ntry, ex2(:), wf8(:,3), wf16(:,147), n3(:,380), t3x16(:,:,107))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,3), wf16(:,148), n3(:,381), t3x16(:,:,108))
  call vert_QA_V(ntry, ex2(:), wf8(:,5), wf16(:,149), n3(:,382), t3x16(:,:,109))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,5), wf16(:,150), n3(:,383), t3x16(:,:,110))
  call vert_AV_Q(ntry, wf8(:,3), ex5(:), wf16(:,151), n3(:,384), t3x16(:,:,111))
  call prop_A_Q(ntry, wf16(:,151), 29, ZERO, 0_intkind1, wf16(:,152), n2(189))
  call vert_AV_Q(ntry, wf8(:,5), ex5(:), wf16(:,153), n3(:,385), t3x16(:,:,112))
  call prop_A_Q(ntry, wf16(:,153), 29, ZERO, 0_intkind1, wf16(:,154), n2(190))
  call vert_AV_Q(ntry, wf8(:,3), ex6(:), wf16(:,155), n3(:,386), t3x16(:,:,113))
  call prop_A_Q(ntry, wf16(:,155), 45, ZERO, 0_intkind1, wf16(:,156), n2(191))
  call vert_AV_Q(ntry, wf8(:,5), ex6(:), wf16(:,157), n3(:,387), t3x16(:,:,114))
  call prop_A_Q(ntry, wf16(:,157), 45, ZERO, 0_intkind1, wf16(:,158), n2(192))
  call vert_QA_V(ntry, wf8(:,19), ex4(:), wf16(:,159), n3(:,388), t3x16(:,:,115))
  call vert_QA_Z(gZl,ntry, wf8(:,19), ex4(:), wf16(:,160), n3(:,389), t3x16(:,:,116))
  call vert_QA_V(ntry, wf8(:,21), ex4(:), wf16(:,161), n3(:,390), t3x16(:,:,117))
  call vert_QA_Z(gZl,ntry, wf8(:,21), ex4(:), wf16(:,162), n3(:,391), t3x16(:,:,118))
  call vert_VQ_A(ntry, ex5(:), wf8(:,19), wf16(:,163), n3(:,392), t3x16(:,:,119))
  call prop_Q_A(ntry, wf16(:,163), 23, ZERO, 0_intkind1, wf16(:,164), n2(193))
  call vert_VQ_A(ntry, ex5(:), wf8(:,21), wf16(:,165), n3(:,393), t3x16(:,:,120))
  call prop_Q_A(ntry, wf16(:,165), 23, ZERO, 0_intkind1, wf16(:,166), n2(194))
  call vert_VQ_A(ntry, ex6(:), wf8(:,19), wf16(:,167), n3(:,394), t3x16(:,:,121))
  call prop_Q_A(ntry, wf16(:,167), 39, ZERO, 0_intkind1, wf16(:,168), n2(195))
  call vert_VQ_A(ntry, ex6(:), wf8(:,21), wf16(:,169), n3(:,395), t3x16(:,:,122))
  call prop_Q_A(ntry, wf16(:,169), 39, ZERO, 0_intkind1, wf16(:,170), n2(196))
  call vert_QA_V(ntry, ex1(:), wf8(:,15), wf16(:,171), n3(:,396), t3x16(:,:,123))
  call vert_QA_V(ntry, ex1(:), wf8(:,17), wf16(:,172), n3(:,397), t3x16(:,:,124))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,15), wf16(:,173), n3(:,398), t3x16(:,:,125))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,17), wf16(:,174), n3(:,399), t3x16(:,:,126))
  call vert_AV_Q(ntry, wf8(:,15), ex5(:), wf16(:,175), n3(:,400), t3x16(:,:,127))
  call prop_A_Q(ntry, wf16(:,175), 30, ZERO, 0_intkind1, wf16(:,176), n2(197))
  call vert_AV_Q(ntry, wf8(:,17), ex5(:), wf16(:,177), n3(:,401), t3x16(:,:,128))
  call prop_A_Q(ntry, wf16(:,177), 30, ZERO, 0_intkind1, wf16(:,178), n2(198))
  call vert_AV_Q(ntry, wf8(:,15), ex6(:), wf16(:,179), n3(:,402), t3x16(:,:,129))
  call prop_A_Q(ntry, wf16(:,179), 46, ZERO, 0_intkind1, wf16(:,180), n2(199))
  call vert_AV_Q(ntry, wf8(:,17), ex6(:), wf16(:,181), n3(:,403), t3x16(:,:,130))
  call prop_A_Q(ntry, wf16(:,181), 46, ZERO, 0_intkind1, wf16(:,182), n2(200))
  call vert_QA_V(ntry, wf8(:,29), ex3(:), wf16(:,183), n3(:,404), t3x16(:,:,131))
  call vert_QA_Z(gZl,ntry, wf8(:,29), ex3(:), wf16(:,184), n3(:,405), t3x16(:,:,132))
  call vert_QA_V(ntry, wf8(:,31), ex3(:), wf16(:,185), n3(:,406), t3x16(:,:,133))
  call vert_QA_Z(gZl,ntry, wf8(:,31), ex3(:), wf16(:,186), n3(:,407), t3x16(:,:,134))
  call vert_VQ_A(ntry, ex5(:), wf8(:,29), wf16(:,187), n3(:,408), t3x16(:,:,135))
  call prop_Q_A(ntry, wf16(:,187), 27, ZERO, 0_intkind1, wf16(:,188), n2(201))
  call vert_VQ_A(ntry, ex5(:), wf8(:,31), wf16(:,189), n3(:,409), t3x16(:,:,136))
  call prop_Q_A(ntry, wf16(:,189), 27, ZERO, 0_intkind1, wf16(:,190), n2(202))
  call vert_VQ_A(ntry, ex6(:), wf8(:,29), wf16(:,191), n3(:,410), t3x16(:,:,137))
  call prop_Q_A(ntry, wf16(:,191), 43, ZERO, 0_intkind1, wf16(:,192), n2(203))
  call vert_VQ_A(ntry, ex6(:), wf8(:,31), wf16(:,193), n3(:,411), t3x16(:,:,138))
  call prop_Q_A(ntry, wf16(:,193), 43, ZERO, 0_intkind1, wf16(:,194), n2(204))
  call vert_QA_V(ntry, ex2(:), wf8(:,24), wf16(:,195), n3(:,412), t3x16(:,:,139))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,24), wf16(:,196), n3(:,413), t3x16(:,:,140))
  call vert_QA_V(ntry, ex2(:), wf8(:,26), wf16(:,197), n3(:,414), t3x16(:,:,141))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,26), wf16(:,198), n3(:,415), t3x16(:,:,142))
  call vert_AV_Q(ntry, wf8(:,24), ex5(:), wf16(:,199), n3(:,416), t3x16(:,:,143))
  call prop_A_Q(ntry, wf16(:,199), 29, ZERO, 0_intkind1, wf16(:,200), n2(205))
  call vert_AV_Q(ntry, wf8(:,26), ex5(:), wf16(:,201), n3(:,417), t3x16(:,:,144))
  call prop_A_Q(ntry, wf16(:,201), 29, ZERO, 0_intkind1, wf16(:,202), n2(206))
  call vert_AV_Q(ntry, wf8(:,24), ex6(:), wf16(:,203), n3(:,418), t3x16(:,:,145))
  call prop_A_Q(ntry, wf16(:,203), 45, ZERO, 0_intkind1, wf16(:,204), n2(207))
  call vert_AV_Q(ntry, wf8(:,26), ex6(:), wf16(:,205), n3(:,419), t3x16(:,:,146))
  call prop_A_Q(ntry, wf16(:,205), 45, ZERO, 0_intkind1, wf16(:,206), n2(208))
  call vert_QA_V(ntry, wf8(:,38), ex3(:), wf16(:,207), n3(:,420), t3x16(:,:,147))
  call vert_QA_Z(gZl,ntry, wf8(:,38), ex3(:), wf16(:,208), n3(:,421), t3x16(:,:,148))
  call vert_QA_V(ntry, wf8(:,40), ex3(:), wf16(:,209), n3(:,422), t3x16(:,:,149))
  call vert_QA_Z(gZl,ntry, wf8(:,40), ex3(:), wf16(:,210), n3(:,423), t3x16(:,:,150))
  call vert_VQ_A(ntry, ex5(:), wf8(:,38), wf16(:,211), n3(:,424), t3x16(:,:,151))
  call prop_Q_A(ntry, wf16(:,211), 27, ZERO, 0_intkind1, wf16(:,212), n2(209))
  call vert_VQ_A(ntry, ex5(:), wf8(:,40), wf16(:,213), n3(:,425), t3x16(:,:,152))
  call prop_Q_A(ntry, wf16(:,213), 27, ZERO, 0_intkind1, wf16(:,214), n2(210))
  call vert_VQ_A(ntry, ex6(:), wf8(:,38), wf16(:,215), n3(:,426), t3x16(:,:,153))
  call prop_Q_A(ntry, wf16(:,215), 43, ZERO, 0_intkind1, wf16(:,216), n2(211))
  call vert_VQ_A(ntry, ex6(:), wf8(:,40), wf16(:,217), n3(:,427), t3x16(:,:,154))
  call prop_Q_A(ntry, wf16(:,217), 43, ZERO, 0_intkind1, wf16(:,218), n2(212))
  call vert_QA_V(ntry, ex1(:), wf8(:,34), wf16(:,219), n3(:,428), t3x16(:,:,155))
  call vert_QA_V(ntry, ex1(:), wf8(:,36), wf16(:,220), n3(:,429), t3x16(:,:,156))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,34), wf16(:,221), n3(:,430), t3x16(:,:,157))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,36), wf16(:,222), n3(:,431), t3x16(:,:,158))
  call vert_AV_Q(ntry, wf8(:,34), ex5(:), wf16(:,223), n3(:,432), t3x16(:,:,159))
  call prop_A_Q(ntry, wf16(:,223), 30, ZERO, 0_intkind1, wf16(:,224), n2(213))
  call vert_AV_Q(ntry, wf8(:,36), ex5(:), wf16(:,225), n3(:,433), t3x16(:,:,160))
  call prop_A_Q(ntry, wf16(:,225), 30, ZERO, 0_intkind1, wf16(:,226), n2(214))
  call vert_AV_Q(ntry, wf8(:,34), ex6(:), wf16(:,227), n3(:,434), t3x16(:,:,161))
  call prop_A_Q(ntry, wf16(:,227), 46, ZERO, 0_intkind1, wf16(:,228), n2(215))
  call vert_AV_Q(ntry, wf8(:,36), ex6(:), wf16(:,229), n3(:,435), t3x16(:,:,162))
  call prop_A_Q(ntry, wf16(:,229), 46, ZERO, 0_intkind1, wf16(:,230), n2(216))
  call vert_VQ_A(ntry, wf8(:,41), ex2(:), wf16(:,231), n3(:,436), t3x16(:,:,163))
  call prop_Q_A(ntry, wf16(:,231), 23, ZERO, 0_intkind1, wf16(:,232), n2(217))
  call vert_ZQ_A(gZl,ntry, wf8(:,43), ex2(:), wf16(:,233), n3(:,437), t3x16(:,:,164))
  call prop_Q_A(ntry, wf16(:,233), 23, ZERO, 0_intkind1, wf16(:,234), n2(218))
  call vert_AV_Q(ntry, ex4(:), wf8(:,41), wf16(:,235), n3(:,438), t3x16(:,:,165))
  call prop_A_Q(ntry, wf16(:,235), 29, ZERO, 0_intkind1, wf16(:,236), n2(219))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,43), wf16(:,237), n3(:,439), t3x16(:,:,166))
  call prop_A_Q(ntry, wf16(:,237), 29, ZERO, 0_intkind1, wf16(:,238), n2(220))
  call vert_VQ_A(ntry, wf8(:,46), ex2(:), wf16(:,239), n3(:,440), t3x16(:,:,167))
  call prop_Q_A(ntry, wf16(:,239), 27, ZERO, 0_intkind1, wf16(:,240), n2(221))
  call vert_ZQ_A(gZl,ntry, wf8(:,48), ex2(:), wf16(:,241), n3(:,441), t3x16(:,:,168))
  call prop_Q_A(ntry, wf16(:,241), 27, ZERO, 0_intkind1, wf16(:,242), n2(222))
  call vert_AV_Q(ntry, ex3(:), wf8(:,46), wf16(:,243), n3(:,442), t3x16(:,:,169))
  call prop_A_Q(ntry, wf16(:,243), 29, ZERO, 0_intkind1, wf16(:,244), n2(223))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,48), wf16(:,245), n3(:,443), t3x16(:,:,170))
  call prop_A_Q(ntry, wf16(:,245), 29, ZERO, 0_intkind1, wf16(:,246), n2(224))
  call vert_QA_V(ntry, wf8(:,86), ex3(:), wf16(:,247), n3(:,444), t3x16(:,:,171))
  call vert_QA_Z(gZl,ntry, wf8(:,86), ex3(:), wf16(:,248), n3(:,445), t3x16(:,:,172))
  call vert_QA_V(ntry, wf8(:,86), ex4(:), wf16(:,249), n3(:,446), t3x16(:,:,173))
  call vert_QA_Z(gZl,ntry, wf8(:,86), ex4(:), wf16(:,250), n3(:,447), t3x16(:,:,174))
  call vert_VQ_A(ntry, wf8(:,57), ex1(:), wf16(:,251), n3(:,448), t3x16(:,:,175))
  call prop_Q_A(ntry, wf16(:,251), 23, ZERO, 0_intkind1, wf16(:,252), n2(225))
  call vert_ZQ_A(gZl,ntry, wf8(:,59), ex1(:), wf16(:,253), n3(:,449), t3x16(:,:,176))
  call prop_Q_A(ntry, wf16(:,253), 23, ZERO, 0_intkind1, wf16(:,254), n2(226))
  call vert_VQ_A(ntry, wf8(:,54), ex1(:), wf16(:,255), n3(:,450), t3x16(:,:,177))
  call prop_Q_A(ntry, wf16(:,255), 27, ZERO, 0_intkind1, wf16(:,256), n2(227))
  call vert_ZQ_A(gZl,ntry, wf8(:,56), ex1(:), wf16(:,257), n3(:,451), t3x16(:,:,178))
  call prop_Q_A(ntry, wf16(:,257), 27, ZERO, 0_intkind1, wf16(:,258), n2(228))
  call vert_AV_Q(ntry, ex4(:), wf8(:,57), wf16(:,259), n3(:,452), t3x16(:,:,179))
  call prop_A_Q(ntry, wf16(:,259), 30, ZERO, 0_intkind1, wf16(:,260), n2(229))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,59), wf16(:,261), n3(:,453), t3x16(:,:,180))
  call prop_A_Q(ntry, wf16(:,261), 30, ZERO, 0_intkind1, wf16(:,262), n2(230))
  call vert_AV_Q(ntry, ex3(:), wf8(:,54), wf16(:,263), n3(:,454), t3x16(:,:,181))
  call prop_A_Q(ntry, wf16(:,263), 30, ZERO, 0_intkind1, wf16(:,264), n2(231))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,56), wf16(:,265), n3(:,455), t3x16(:,:,182))
  call prop_A_Q(ntry, wf16(:,265), 30, ZERO, 0_intkind1, wf16(:,266), n2(232))
  call vert_QA_V(ntry, wf8(:,78), ex3(:), wf16(:,267), n3(:,456), t3x16(:,:,183))
  call vert_QA_Z(gZl,ntry, wf8(:,78), ex3(:), wf16(:,268), n3(:,457), t3x16(:,:,184))
  call vert_QA_V(ntry, wf8(:,78), ex4(:), wf16(:,269), n3(:,458), t3x16(:,:,185))
  call vert_QA_Z(gZl,ntry, wf8(:,78), ex4(:), wf16(:,270), n3(:,459), t3x16(:,:,186))
  call vert_VQ_A(ntry, wf8(:,67), ex2(:), wf16(:,271), n3(:,460), t3x16(:,:,187))
  call prop_Q_A(ntry, wf16(:,271), 23, ZERO, 0_intkind1, wf16(:,272), n2(233))
  call vert_ZQ_A(gZl,ntry, wf8(:,68), ex2(:), wf16(:,273), n3(:,461), t3x16(:,:,188))
  call prop_Q_A(ntry, wf16(:,273), 23, ZERO, 0_intkind1, wf16(:,274), n2(234))
  call vert_VQ_A(ntry, wf8(:,65), ex1(:), wf16(:,275), n3(:,462), t3x16(:,:,189))
  call prop_Q_A(ntry, wf16(:,275), 23, ZERO, 0_intkind1, wf16(:,276), n2(235))
  call vert_ZQ_A(gZl,ntry, wf8(:,66), ex1(:), wf16(:,277), n3(:,463), t3x16(:,:,190))
  call prop_Q_A(ntry, wf16(:,277), 23, ZERO, 0_intkind1, wf16(:,278), n2(236))
  call vert_AV_Q(ntry, ex4(:), wf8(:,67), wf16(:,279), n3(:,464), t3x16(:,:,191))
  call prop_A_Q(ntry, wf16(:,279), 29, ZERO, 0_intkind1, wf16(:,280), n2(237))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,68), wf16(:,281), n3(:,465), t3x16(:,:,192))
  call prop_A_Q(ntry, wf16(:,281), 29, ZERO, 0_intkind1, wf16(:,282), n2(238))
  call vert_QA_V(ntry, ex1(:), wf8(:,136), wf16(:,283), n3(:,466), t3x16(:,:,193))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,136), wf16(:,284), n3(:,467), t3x16(:,:,194))
  call vert_AV_Q(ntry, ex4(:), wf8(:,65), wf16(:,285), n3(:,468), t3x16(:,:,195))
  call prop_A_Q(ntry, wf16(:,285), 30, ZERO, 0_intkind1, wf16(:,286), n2(239))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,66), wf16(:,287), n3(:,469), t3x16(:,:,196))
  call prop_A_Q(ntry, wf16(:,287), 30, ZERO, 0_intkind1, wf16(:,288), n2(240))
  call vert_QA_V(ntry, ex2(:), wf8(:,136), wf16(:,289), n3(:,470), t3x16(:,:,197))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,136), wf16(:,290), n3(:,471), t3x16(:,:,198))
  call vert_VQ_A(ntry, wf8(:,71), ex2(:), wf16(:,291), n3(:,472), t3x16(:,:,199))
  call prop_Q_A(ntry, wf16(:,291), 27, ZERO, 0_intkind1, wf16(:,292), n2(241))
  call vert_ZQ_A(gZl,ntry, wf8(:,72), ex2(:), wf16(:,293), n3(:,473), t3x16(:,:,200))
  call prop_Q_A(ntry, wf16(:,293), 27, ZERO, 0_intkind1, wf16(:,294), n2(242))
  call vert_VQ_A(ntry, wf8(:,69), ex1(:), wf16(:,295), n3(:,474), t3x16(:,:,201))
  call prop_Q_A(ntry, wf16(:,295), 27, ZERO, 0_intkind1, wf16(:,296), n2(243))
  call vert_ZQ_A(gZl,ntry, wf8(:,70), ex1(:), wf16(:,297), n3(:,475), t3x16(:,:,202))
  call prop_Q_A(ntry, wf16(:,297), 27, ZERO, 0_intkind1, wf16(:,298), n2(244))
  call vert_AV_Q(ntry, ex3(:), wf8(:,71), wf16(:,299), n3(:,476), t3x16(:,:,203))
  call prop_A_Q(ntry, wf16(:,299), 29, ZERO, 0_intkind1, wf16(:,300), n2(245))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,72), wf16(:,301), n3(:,477), t3x16(:,:,204))
  call prop_A_Q(ntry, wf16(:,301), 29, ZERO, 0_intkind1, wf16(:,302), n2(246))
  call vert_QA_V(ntry, ex1(:), wf8(:,130), wf16(:,303), n3(:,478), t3x16(:,:,205))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,130), wf16(:,304), n3(:,479), t3x16(:,:,206))
  call vert_AV_Q(ntry, ex3(:), wf8(:,69), wf16(:,305), n3(:,480), t3x16(:,:,207))
  call prop_A_Q(ntry, wf16(:,305), 30, ZERO, 0_intkind1, wf16(:,306), n2(247))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,70), wf16(:,307), n3(:,481), t3x16(:,:,208))
  call prop_A_Q(ntry, wf16(:,307), 30, ZERO, 0_intkind1, wf16(:,308), n2(248))
  call vert_QA_V(ntry, ex2(:), wf8(:,130), wf16(:,309), n3(:,482), t3x16(:,:,209))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,130), wf16(:,310), n3(:,483), t3x16(:,:,210))
  call vert_VQ_A(ntry, wf8(:,53), ex2(:), wf16(:,311), n3(:,484), t3x16(:,:,211))
  call prop_Q_A(ntry, wf16(:,311), 39, ZERO, 0_intkind1, wf16(:,312), n2(249))
  call vert_ZQ_A(gZl,ntry, wf8(:,55), ex2(:), wf16(:,313), n3(:,485), t3x16(:,:,212))
  call prop_Q_A(ntry, wf16(:,313), 39, ZERO, 0_intkind1, wf16(:,314), n2(250))
  call vert_AV_Q(ntry, ex4(:), wf8(:,53), wf16(:,315), n3(:,486), t3x16(:,:,213))
  call prop_A_Q(ntry, wf16(:,315), 45, ZERO, 0_intkind1, wf16(:,316), n2(251))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,55), wf16(:,317), n3(:,487), t3x16(:,:,214))
  call prop_A_Q(ntry, wf16(:,317), 45, ZERO, 0_intkind1, wf16(:,318), n2(252))
  call vert_VQ_A(ntry, wf8(:,58), ex2(:), wf16(:,319), n3(:,488), t3x16(:,:,215))
  call prop_Q_A(ntry, wf16(:,319), 43, ZERO, 0_intkind1, wf16(:,320), n2(253))
  call vert_ZQ_A(gZl,ntry, wf8(:,60), ex2(:), wf16(:,321), n3(:,489), t3x16(:,:,216))
  call prop_Q_A(ntry, wf16(:,321), 43, ZERO, 0_intkind1, wf16(:,322), n2(254))
  call vert_AV_Q(ntry, ex3(:), wf8(:,58), wf16(:,323), n3(:,490), t3x16(:,:,217))
  call prop_A_Q(ntry, wf16(:,323), 45, ZERO, 0_intkind1, wf16(:,324), n2(255))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,60), wf16(:,325), n3(:,491), t3x16(:,:,218))
  call prop_A_Q(ntry, wf16(:,325), 45, ZERO, 0_intkind1, wf16(:,326), n2(256))
  call vert_QA_V(ntry, wf8(:,88), ex3(:), wf16(:,327), n3(:,492), t3x16(:,:,219))
  call vert_QA_Z(gZl,ntry, wf8(:,88), ex3(:), wf16(:,328), n3(:,493), t3x16(:,:,220))
  call vert_QA_V(ntry, wf8(:,88), ex4(:), wf16(:,329), n3(:,494), t3x16(:,:,221))
  call vert_QA_Z(gZl,ntry, wf8(:,88), ex4(:), wf16(:,330), n3(:,495), t3x16(:,:,222))
  call vert_VQ_A(ntry, wf8(:,45), ex1(:), wf16(:,331), n3(:,496), t3x16(:,:,223))
  call prop_Q_A(ntry, wf16(:,331), 39, ZERO, 0_intkind1, wf16(:,332), n2(257))
  call vert_ZQ_A(gZl,ntry, wf8(:,47), ex1(:), wf16(:,333), n3(:,497), t3x16(:,:,224))
  call prop_Q_A(ntry, wf16(:,333), 39, ZERO, 0_intkind1, wf16(:,334), n2(258))
  call vert_VQ_A(ntry, wf8(:,42), ex1(:), wf16(:,335), n3(:,498), t3x16(:,:,225))
  call prop_Q_A(ntry, wf16(:,335), 43, ZERO, 0_intkind1, wf16(:,336), n2(259))
  call vert_ZQ_A(gZl,ntry, wf8(:,44), ex1(:), wf16(:,337), n3(:,499), t3x16(:,:,226))
  call prop_Q_A(ntry, wf16(:,337), 43, ZERO, 0_intkind1, wf16(:,338), n2(260))
  call vert_AV_Q(ntry, ex4(:), wf8(:,45), wf16(:,339), n3(:,500), t3x16(:,:,227))
  call prop_A_Q(ntry, wf16(:,339), 46, ZERO, 0_intkind1, wf16(:,340), n2(261))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,47), wf16(:,341), n3(:,501), t3x16(:,:,228))
  call prop_A_Q(ntry, wf16(:,341), 46, ZERO, 0_intkind1, wf16(:,342), n2(262))
  call vert_AV_Q(ntry, ex3(:), wf8(:,42), wf16(:,343), n3(:,502), t3x16(:,:,229))
  call prop_A_Q(ntry, wf16(:,343), 46, ZERO, 0_intkind1, wf16(:,344), n2(263))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,44), wf16(:,345), n3(:,503), t3x16(:,:,230))
  call prop_A_Q(ntry, wf16(:,345), 46, ZERO, 0_intkind1, wf16(:,346), n2(264))
  call vert_QA_V(ntry, wf8(:,80), ex3(:), wf16(:,347), n3(:,504), t3x16(:,:,231))
  call vert_QA_Z(gZl,ntry, wf8(:,80), ex3(:), wf16(:,348), n3(:,505), t3x16(:,:,232))
  call vert_QA_V(ntry, wf8(:,80), ex4(:), wf16(:,349), n3(:,506), t3x16(:,:,233))
  call vert_QA_Z(gZl,ntry, wf8(:,80), ex4(:), wf16(:,350), n3(:,507), t3x16(:,:,234))
  call vert_VQ_A(ntry, wf8(:,61), ex2(:), wf16(:,351), n3(:,508), t3x16(:,:,235))
  call prop_Q_A(ntry, wf16(:,351), 39, ZERO, 0_intkind1, wf16(:,352), n2(265))
  call vert_ZQ_A(gZl,ntry, wf8(:,62), ex2(:), wf16(:,353), n3(:,509), t3x16(:,:,236))
  call prop_Q_A(ntry, wf16(:,353), 39, ZERO, 0_intkind1, wf16(:,354), n2(266))
  call vert_VQ_A(ntry, wf8(:,49), ex1(:), wf16(:,355), n3(:,510), t3x16(:,:,237))
  call prop_Q_A(ntry, wf16(:,355), 39, ZERO, 0_intkind1, wf16(:,356), n2(267))
  call vert_ZQ_A(gZl,ntry, wf8(:,50), ex1(:), wf16(:,357), n3(:,511), t3x16(:,:,238))
  call prop_Q_A(ntry, wf16(:,357), 39, ZERO, 0_intkind1, wf16(:,358), n2(268))
  call vert_AV_Q(ntry, ex4(:), wf8(:,61), wf16(:,359), n3(:,512), t3x16(:,:,239))
  call prop_A_Q(ntry, wf16(:,359), 45, ZERO, 0_intkind1, wf16(:,360), n2(269))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,62), wf16(:,361), n3(:,513), t3x16(:,:,240))
  call prop_A_Q(ntry, wf16(:,361), 45, ZERO, 0_intkind1, wf16(:,362), n2(270))
  call vert_QA_V(ntry, ex1(:), wf8(:,138), wf16(:,363), n3(:,514), t3x16(:,:,241))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,138), wf16(:,364), n3(:,515), t3x16(:,:,242))
  call vert_AV_Q(ntry, ex4(:), wf8(:,49), wf16(:,365), n3(:,516), t3x16(:,:,243))
  call prop_A_Q(ntry, wf16(:,365), 46, ZERO, 0_intkind1, wf16(:,366), n2(271))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,50), wf16(:,367), n3(:,517), t3x16(:,:,244))
  call prop_A_Q(ntry, wf16(:,367), 46, ZERO, 0_intkind1, wf16(:,368), n2(272))
  call vert_QA_V(ntry, ex2(:), wf8(:,138), wf16(:,369), n3(:,518), t3x16(:,:,245))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,138), wf16(:,370), n3(:,519), t3x16(:,:,246))
  call vert_VQ_A(ntry, wf8(:,63), ex2(:), wf16(:,371), n3(:,520), t3x16(:,:,247))
  call prop_Q_A(ntry, wf16(:,371), 43, ZERO, 0_intkind1, wf16(:,372), n2(273))
  call vert_ZQ_A(gZl,ntry, wf8(:,64), ex2(:), wf16(:,373), n3(:,521), t3x16(:,:,248))
  call prop_Q_A(ntry, wf16(:,373), 43, ZERO, 0_intkind1, wf16(:,374), n2(274))
  call vert_VQ_A(ntry, wf8(:,51), ex1(:), wf16(:,375), n3(:,522), t3x16(:,:,249))
  call prop_Q_A(ntry, wf16(:,375), 43, ZERO, 0_intkind1, wf16(:,376), n2(275))
  call vert_ZQ_A(gZl,ntry, wf8(:,52), ex1(:), wf16(:,377), n3(:,523), t3x16(:,:,250))
  call prop_Q_A(ntry, wf16(:,377), 43, ZERO, 0_intkind1, wf16(:,378), n2(276))
  call vert_AV_Q(ntry, ex3(:), wf8(:,63), wf16(:,379), n3(:,524), t3x16(:,:,251))
  call prop_A_Q(ntry, wf16(:,379), 45, ZERO, 0_intkind1, wf16(:,380), n2(277))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,64), wf16(:,381), n3(:,525), t3x16(:,:,252))
  call prop_A_Q(ntry, wf16(:,381), 45, ZERO, 0_intkind1, wf16(:,382), n2(278))
  call vert_QA_V(ntry, ex1(:), wf8(:,132), wf16(:,383), n3(:,526), t3x16(:,:,253))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,132), wf16(:,384), n3(:,527), t3x16(:,:,254))
  call vert_AV_Q(ntry, ex3(:), wf8(:,51), wf16(:,385), n3(:,528), t3x16(:,:,255))
  call prop_A_Q(ntry, wf16(:,385), 46, ZERO, 0_intkind1, wf16(:,386), n2(279))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,52), wf16(:,387), n3(:,529), t3x16(:,:,256))
  call prop_A_Q(ntry, wf16(:,387), 46, ZERO, 0_intkind1, wf16(:,388), n2(280))
  call vert_QA_V(ntry, ex2(:), wf8(:,132), wf16(:,389), n3(:,530), t3x16(:,:,257))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,132), wf16(:,390), n3(:,531), t3x16(:,:,258))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,5), wf16(:,1), A(:,1), n3(:,532), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,2), A(:,2), n3(:,533), t3x64(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,3), n3(:,534), t3x64(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,5), A(:,4), n3(:,535), t3x64(:,:,4), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,3), A(:,5), n3(:,536), t3x64(:,:,5), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,4), A(:,6), n3(:,537), t3x64(:,:,6), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,8), A(:,7), n3(:,538), t3x64(:,:,7), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,10), A(:,8), n3(:,539), t3x64(:,:,8), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,11), A(:,9), n3(:,540), t3x64(:,:,9), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,11), A(:,10), n3(:,541), t3x64(:,:,10), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,12), A(:,11), n3(:,542), t3x64(:,:,11), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,12), A(:,12), n3(:,543), t3x64(:,:,12), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,5), A(:,13), n3(:,544), t3x64(:,:,13), nhel, den(32))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,6), A(:,14), n3(:,545), t3x64(:,:,14), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,15), A(:,15), n3(:,546), t3x64(:,:,15), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,17), A(:,16), n3(:,547), t3x64(:,:,16), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,7), A(:,17), n3(:,548), t3x64(:,:,17), nhel, den(43))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,8), A(:,18), n3(:,549), t3x64(:,:,18), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,19), A(:,19), n3(:,550), t3x64(:,:,19), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,21), A(:,20), n3(:,551), t3x64(:,:,20), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,22), A(:,21), n3(:,552), t3x64(:,:,21), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,22), A(:,22), n3(:,553), t3x64(:,:,22), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,19), A(:,23), n3(:,554), t3x64(:,:,23), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,21), A(:,24), n3(:,555), t3x64(:,:,24), nhel, den(53))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,9), A(:,25), n3(:,556), t3x64(:,:,25), nhel, den(57))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,10), A(:,26), n3(:,557), t3x64(:,:,26), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,24), A(:,27), n3(:,558), t3x64(:,:,27), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,26), A(:,28), n3(:,559), t3x64(:,:,28), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,11), A(:,29), n3(:,560), t3x64(:,:,29), nhel, den(67))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,12), A(:,30), n3(:,561), t3x64(:,:,30), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,29), A(:,31), n3(:,562), t3x64(:,:,31), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,31), A(:,32), n3(:,563), t3x64(:,:,32), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,24), A(:,33), n3(:,564), t3x64(:,:,33), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,26), A(:,34), n3(:,565), t3x64(:,:,34), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,32), A(:,35), n3(:,566), t3x64(:,:,35), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,32), A(:,36), n3(:,567), t3x64(:,:,36), nhel, den(78))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,13), A(:,37), n3(:,568), t3x64(:,:,37), nhel, den(81))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,14), A(:,38), n3(:,569), t3x64(:,:,38), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,34), A(:,39), n3(:,570), t3x64(:,:,39), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,36), A(:,40), n3(:,571), t3x64(:,:,40), nhel, den(88))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,15), A(:,41), n3(:,572), t3x64(:,:,41), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,16), A(:,42), n3(:,573), t3x64(:,:,42), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,38), A(:,43), n3(:,574), t3x64(:,:,43), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,40), A(:,44), n3(:,575), t3x64(:,:,44), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,34), A(:,45), n3(:,576), t3x64(:,:,45), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,36), A(:,46), n3(:,577), t3x64(:,:,46), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,38), A(:,47), n3(:,578), t3x64(:,:,47), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,40), A(:,48), n3(:,579), t3x64(:,:,48), nhel, den(100))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,42), A(:,49), n3(:,580), t3x64(:,:,49), nhel, den(103))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,44), A(:,50), n3(:,581), t3x64(:,:,50), nhel, den(106))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,46), A(:,51), n3(:,582), t3x64(:,:,51), nhel, den(109))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,48), A(:,52), n3(:,583), t3x64(:,:,52), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,49), A(:,53), n3(:,584), t3x64(:,:,53), nhel, den(114))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,50), A(:,54), n3(:,585), t3x64(:,:,54), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,51), A(:,55), n3(:,586), t3x64(:,:,55), nhel, den(119))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,52), A(:,56), n3(:,587), t3x64(:,:,56), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,54), A(:,57), n3(:,588), t3x64(:,:,57), nhel, den(125))
    call Hcont_VV(nsync, wf8(:,55), wf8(:,56), A(:,58), n3(:,589), t3x64(:,:,58), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,57), wf8(:,58), A(:,59), n3(:,590), t3x64(:,:,59), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,59), wf8(:,60), A(:,60), n3(:,591), t3x64(:,:,60), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,61), A(:,61), n3(:,592), t3x64(:,:,61), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,62), A(:,62), n3(:,593), t3x64(:,:,62), nhel, den(138))
    call Hcont_VV(nsync, wf8(:,57), wf8(:,63), A(:,63), n3(:,594), t3x64(:,:,63), nhel, den(141))
    call Hcont_VV(nsync, wf8(:,59), wf8(:,64), A(:,64), n3(:,595), t3x64(:,:,64), nhel, den(144))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,65), A(:,65), n3(:,596), t3x64(:,:,65), nhel, den(146))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,66), A(:,66), n3(:,597), t3x64(:,:,66), nhel, den(148))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,67), A(:,67), n3(:,598), t3x64(:,:,67), nhel, den(150))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,68), A(:,68), n3(:,599), t3x64(:,:,68), nhel, den(152))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,67), A(:,69), n3(:,600), t3x64(:,:,69), nhel, den(153))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,68), A(:,70), n3(:,601), t3x64(:,:,70), nhel, den(154))
    call Hcont_VV(nsync, wf8(:,63), wf8(:,65), A(:,71), n3(:,602), t3x64(:,:,71), nhel, den(155))
    call Hcont_VV(nsync, wf8(:,64), wf8(:,66), A(:,72), n3(:,603), t3x64(:,:,72), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,69), A(:,73), n3(:,604), t3x64(:,:,73), nhel, den(159))
    call Hcont_VV(nsync, wf8(:,55), wf8(:,70), A(:,74), n3(:,605), t3x64(:,:,74), nhel, den(162))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,71), A(:,75), n3(:,606), t3x64(:,:,75), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,72), A(:,76), n3(:,607), t3x64(:,:,76), nhel, den(168))
    call Hcont_VV(nsync, wf8(:,61), wf8(:,69), A(:,77), n3(:,608), t3x64(:,:,77), nhel, den(169))
    call Hcont_VV(nsync, wf8(:,62), wf8(:,70), A(:,78), n3(:,609), t3x64(:,:,78), nhel, den(170))
    call Hcont_VV(nsync, wf8(:,49), wf8(:,71), A(:,79), n3(:,610), t3x64(:,:,79), nhel, den(171))
    call Hcont_VV(nsync, wf8(:,50), wf8(:,72), A(:,80), n3(:,611), t3x64(:,:,80), nhel, den(172))

    call Hcont_VV(nsync, wf4(:,23), wf16(:,17), A(:,81), n3(:,612), t3x64(:,:,81), nhel, den(173))
    call Hcont_VV(nsync, wf4(:,24), wf16(:,17), A(:,82), n3(:,613), t3x64(:,:,82), nhel, den(174))
    call Hcont_VV(nsync, wf4(:,23), wf16(:,18), A(:,83), n3(:,614), t3x64(:,:,83), nhel, den(175))
    call Hcont_VV(nsync, wf4(:,24), wf16(:,18), A(:,84), n3(:,615), t3x64(:,:,84), nhel, den(176))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,19), A(:,85), n3(:,616), t3x64(:,:,85), nhel, den(177))
    call Hcont_VV(nsync, wf4(:,14), wf16(:,19), A(:,86), n3(:,617), t3x64(:,:,86), nhel, den(178))
    call Hcont_VV(nsync, wf4(:,12), wf16(:,20), A(:,87), n3(:,618), t3x64(:,:,87), nhel, den(179))
    call Hcont_VV(nsync, wf4(:,14), wf16(:,20), A(:,88), n3(:,619), t3x64(:,:,88), nhel, den(180))
    call Hcont_SS(nsync, wf4(:,25), wf16(:,21), A(:,89), n3(:,620), t3x64(:,:,89), nhel, den(182))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,22), A(:,90), n3(:,621), t3x64(:,:,90), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,23), A(:,91), n3(:,622), t3x64(:,:,91), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,73), A(:,92), n3(:,623), t3x64(:,:,92), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,73), A(:,93), n3(:,624), t3x64(:,:,93), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,24), A(:,94), n3(:,625), t3x64(:,:,94), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,25), A(:,95), n3(:,626), t3x64(:,:,95), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,74), A(:,96), n3(:,627), t3x64(:,:,96), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,74), A(:,97), n3(:,628), t3x64(:,:,97), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,75), A(:,98), n3(:,629), t3x64(:,:,98), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,75), A(:,99), n3(:,630), t3x64(:,:,99), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,76), A(:,100), n3(:,631), t3x64(:,:,100), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,76), A(:,101), n3(:,632), t3x64(:,:,101), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,77), wf8(:,78), A(:,102), n3(:,633), t3x64(:,:,102), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,79), A(:,103), n3(:,634), t3x64(:,:,103), nhel, den(186))
    call Hcont_QA(nsync, wf16(:,1), wf4(:,27), A(:,104), n3(:,635), t3x64(:,:,104), nhel, den(5))
    call Hcont_QA(nsync, wf16(:,2), wf4(:,27), A(:,105), n3(:,636), t3x64(:,:,105), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,77), wf8(:,80), A(:,106), n3(:,637), t3x64(:,:,106), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,79), wf8(:,80), A(:,107), n3(:,638), t3x64(:,:,107), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,81), A(:,108), n3(:,639), t3x64(:,:,108), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,81), A(:,109), n3(:,640), t3x64(:,:,109), nhel, den(28))
    call Hcont_QA(nsync, wf16(:,3), wf4(:,29), A(:,110), n3(:,641), t3x64(:,:,110), nhel, den(17))
    call Hcont_QA(nsync, wf16(:,4), wf4(:,29), A(:,111), n3(:,642), t3x64(:,:,111), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,82), A(:,112), n3(:,643), t3x64(:,:,112), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,82), A(:,113), n3(:,644), t3x64(:,:,113), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,25), wf16(:,26), A(:,114), n3(:,645), t3x64(:,:,114), nhel, den(190))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,27), A(:,115), n3(:,646), t3x64(:,:,115), nhel, den(32))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,28), A(:,116), n3(:,647), t3x64(:,:,116), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,83), A(:,117), n3(:,648), t3x64(:,:,117), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,83), A(:,118), n3(:,649), t3x64(:,:,118), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,29), A(:,119), n3(:,650), t3x64(:,:,119), nhel, den(43))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,30), A(:,120), n3(:,651), t3x64(:,:,120), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,74), A(:,121), n3(:,652), t3x64(:,:,121), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,74), A(:,122), n3(:,653), t3x64(:,:,122), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,84), A(:,123), n3(:,654), t3x64(:,:,123), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,84), A(:,124), n3(:,655), t3x64(:,:,124), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,76), A(:,125), n3(:,656), t3x64(:,:,125), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,76), A(:,126), n3(:,657), t3x64(:,:,126), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,86), A(:,127), n3(:,658), t3x64(:,:,127), nhel, den(193))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,87), A(:,128), n3(:,659), t3x64(:,:,128), nhel, den(194))
    call Hcont_QA(nsync, wf16(:,5), wf4(:,27), A(:,129), n3(:,660), t3x64(:,:,129), nhel, den(32))
    call Hcont_QA(nsync, wf16(:,6), wf4(:,27), A(:,130), n3(:,661), t3x64(:,:,130), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,88), A(:,131), n3(:,662), t3x64(:,:,131), nhel, den(196))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,88), A(:,132), n3(:,663), t3x64(:,:,132), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,81), A(:,133), n3(:,664), t3x64(:,:,133), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,81), A(:,134), n3(:,665), t3x64(:,:,134), nhel, den(53))
    call Hcont_QA(nsync, wf16(:,7), wf4(:,29), A(:,135), n3(:,666), t3x64(:,:,135), nhel, den(43))
    call Hcont_QA(nsync, wf16(:,8), wf4(:,29), A(:,136), n3(:,667), t3x64(:,:,136), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,82), A(:,137), n3(:,668), t3x64(:,:,137), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,82), A(:,138), n3(:,669), t3x64(:,:,138), nhel, den(49))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,31), A(:,139), n3(:,670), t3x64(:,:,139), nhel, den(57))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,32), A(:,140), n3(:,671), t3x64(:,:,140), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,73), A(:,141), n3(:,672), t3x64(:,:,141), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,73), A(:,142), n3(:,673), t3x64(:,:,142), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,33), A(:,143), n3(:,674), t3x64(:,:,143), nhel, den(67))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,34), A(:,144), n3(:,675), t3x64(:,:,144), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,89), A(:,145), n3(:,676), t3x64(:,:,145), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,89), A(:,146), n3(:,677), t3x64(:,:,146), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,75), A(:,147), n3(:,678), t3x64(:,:,147), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,75), A(:,148), n3(:,679), t3x64(:,:,148), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,90), A(:,149), n3(:,680), t3x64(:,:,149), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,90), A(:,150), n3(:,681), t3x64(:,:,150), nhel, den(78))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,35), A(:,151), n3(:,682), t3x64(:,:,151), nhel, den(81))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,36), A(:,152), n3(:,683), t3x64(:,:,152), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,83), A(:,153), n3(:,684), t3x64(:,:,153), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,83), A(:,154), n3(:,685), t3x64(:,:,154), nhel, den(88))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,37), A(:,155), n3(:,686), t3x64(:,:,155), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,38), A(:,156), n3(:,687), t3x64(:,:,156), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,89), A(:,157), n3(:,688), t3x64(:,:,157), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,89), A(:,158), n3(:,689), t3x64(:,:,158), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,84), A(:,159), n3(:,690), t3x64(:,:,159), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,84), A(:,160), n3(:,691), t3x64(:,:,160), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,90), A(:,161), n3(:,692), t3x64(:,:,161), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,90), A(:,162), n3(:,693), t3x64(:,:,162), nhel, den(100))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,91), A(:,163), n3(:,694), t3x64(:,:,163), nhel, den(103))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,92), A(:,164), n3(:,695), t3x64(:,:,164), nhel, den(106))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,93), A(:,165), n3(:,696), t3x64(:,:,165), nhel, den(109))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,94), A(:,166), n3(:,697), t3x64(:,:,166), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,49), wf8(:,93), A(:,167), n3(:,698), t3x64(:,:,167), nhel, den(114))
    call Hcont_VV(nsync, wf8(:,50), wf8(:,94), A(:,168), n3(:,699), t3x64(:,:,168), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,95), A(:,169), n3(:,700), t3x64(:,:,169), nhel, den(119))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,96), A(:,170), n3(:,701), t3x64(:,:,170), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,97), A(:,171), n3(:,702), t3x64(:,:,171), nhel, den(125))
    call Hcont_VV(nsync, wf8(:,55), wf8(:,98), A(:,172), n3(:,703), t3x64(:,:,172), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,57), wf8(:,99), A(:,173), n3(:,704), t3x64(:,:,173), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,59), wf8(:,100), A(:,174), n3(:,705), t3x64(:,:,174), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,61), wf8(:,97), A(:,175), n3(:,706), t3x64(:,:,175), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,62), wf8(:,98), A(:,176), n3(:,707), t3x64(:,:,176), nhel, den(138))
    call Hcont_VV(nsync, wf8(:,57), wf8(:,101), A(:,177), n3(:,708), t3x64(:,:,177), nhel, den(141))
    call Hcont_VV(nsync, wf8(:,59), wf8(:,102), A(:,178), n3(:,709), t3x64(:,:,178), nhel, den(144))
    call Hcont_VV(nsync, wf8(:,65), wf8(:,99), A(:,179), n3(:,710), t3x64(:,:,179), nhel, den(146))
    call Hcont_VV(nsync, wf8(:,66), wf8(:,100), A(:,180), n3(:,711), t3x64(:,:,180), nhel, den(148))
    call Hcont_VV(nsync, wf8(:,67), wf8(:,91), A(:,181), n3(:,712), t3x64(:,:,181), nhel, den(150))
    call Hcont_VV(nsync, wf8(:,68), wf8(:,92), A(:,182), n3(:,713), t3x64(:,:,182), nhel, den(152))
    call Hcont_VV(nsync, wf8(:,67), wf8(:,95), A(:,183), n3(:,714), t3x64(:,:,183), nhel, den(153))
    call Hcont_VV(nsync, wf8(:,68), wf8(:,96), A(:,184), n3(:,715), t3x64(:,:,184), nhel, den(154))
    call Hcont_VV(nsync, wf8(:,65), wf8(:,101), A(:,185), n3(:,716), t3x64(:,:,185), nhel, den(155))
    call Hcont_VV(nsync, wf8(:,66), wf8(:,102), A(:,186), n3(:,717), t3x64(:,:,186), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,103), A(:,187), n3(:,718), t3x64(:,:,187), nhel, den(159))
    call Hcont_VV(nsync, wf8(:,55), wf8(:,104), A(:,188), n3(:,719), t3x64(:,:,188), nhel, den(162))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,105), A(:,189), n3(:,720), t3x64(:,:,189), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,106), A(:,190), n3(:,721), t3x64(:,:,190), nhel, den(168))
    call Hcont_VV(nsync, wf8(:,61), wf8(:,103), A(:,191), n3(:,722), t3x64(:,:,191), nhel, den(169))
    call Hcont_VV(nsync, wf8(:,62), wf8(:,104), A(:,192), n3(:,723), t3x64(:,:,192), nhel, den(170))
    call Hcont_VV(nsync, wf8(:,49), wf8(:,105), A(:,193), n3(:,724), t3x64(:,:,193), nhel, den(171))
    call Hcont_VV(nsync, wf8(:,50), wf8(:,106), A(:,194), n3(:,725), t3x64(:,:,194), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,107), A(:,195), n3(:,726), t3x64(:,:,195), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,108), A(:,196), n3(:,727), t3x64(:,:,196), nhel, den(199))
    call Hcont_QA(nsync, wf16(:,9), wf4(:,31), A(:,197), n3(:,728), t3x64(:,:,197), nhel, den(57))
    call Hcont_QA(nsync, wf16(:,10), wf4(:,31), A(:,198), n3(:,729), t3x64(:,:,198), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,107), A(:,199), n3(:,730), t3x64(:,:,199), nhel, den(200))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,108), A(:,200), n3(:,731), t3x64(:,:,200), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,109), A(:,201), n3(:,732), t3x64(:,:,201), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,109), A(:,202), n3(:,733), t3x64(:,:,202), nhel, den(78))
    call Hcont_QA(nsync, wf16(:,11), wf4(:,33), A(:,203), n3(:,734), t3x64(:,:,203), nhel, den(67))
    call Hcont_QA(nsync, wf16(:,12), wf4(:,33), A(:,204), n3(:,735), t3x64(:,:,204), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,110), A(:,205), n3(:,736), t3x64(:,:,205), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,110), A(:,206), n3(:,737), t3x64(:,:,206), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,111), A(:,207), n3(:,738), t3x64(:,:,207), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,112), A(:,208), n3(:,739), t3x64(:,:,208), nhel, den(203))
    call Hcont_QA(nsync, wf16(:,13), wf4(:,31), A(:,209), n3(:,740), t3x64(:,:,209), nhel, den(81))
    call Hcont_QA(nsync, wf16(:,14), wf4(:,31), A(:,210), n3(:,741), t3x64(:,:,210), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,111), A(:,211), n3(:,742), t3x64(:,:,211), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,112), A(:,212), n3(:,743), t3x64(:,:,212), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,109), A(:,213), n3(:,744), t3x64(:,:,213), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,109), A(:,214), n3(:,745), t3x64(:,:,214), nhel, den(100))
    call Hcont_QA(nsync, wf16(:,15), wf4(:,33), A(:,215), n3(:,746), t3x64(:,:,215), nhel, den(90))
    call Hcont_QA(nsync, wf16(:,16), wf4(:,33), A(:,216), n3(:,747), t3x64(:,:,216), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,110), A(:,217), n3(:,748), t3x64(:,:,217), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,110), A(:,218), n3(:,749), t3x64(:,:,218), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,113), A(:,219), n3(:,750), t3x64(:,:,219), nhel, den(207))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,114), A(:,220), n3(:,751), t3x64(:,:,220), nhel, den(209))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,115), A(:,221), n3(:,752), t3x64(:,:,221), nhel, den(211))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,116), A(:,222), n3(:,753), t3x64(:,:,222), nhel, den(213))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,115), A(:,223), n3(:,754), t3x64(:,:,223), nhel, den(119))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,116), A(:,224), n3(:,755), t3x64(:,:,224), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,117), A(:,225), n3(:,756), t3x64(:,:,225), nhel, den(114))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,118), A(:,226), n3(:,757), t3x64(:,:,226), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,119), A(:,227), n3(:,758), t3x64(:,:,227), nhel, den(215))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,120), A(:,228), n3(:,759), t3x64(:,:,228), nhel, den(217))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,121), A(:,229), n3(:,760), t3x64(:,:,229), nhel, den(219))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,122), A(:,230), n3(:,761), t3x64(:,:,230), nhel, den(221))
    call Hcont_VV(nsync, wf8(:,63), wf8(:,119), A(:,231), n3(:,762), t3x64(:,:,231), nhel, den(141))
    call Hcont_VV(nsync, wf8(:,64), wf8(:,120), A(:,232), n3(:,763), t3x64(:,:,232), nhel, den(144))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,123), A(:,233), n3(:,764), t3x64(:,:,233), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,124), A(:,234), n3(:,765), t3x64(:,:,234), nhel, den(138))
    call Hcont_VV(nsync, wf8(:,69), wf8(:,121), A(:,235), n3(:,766), t3x64(:,:,235), nhel, den(159))
    call Hcont_VV(nsync, wf8(:,70), wf8(:,122), A(:,236), n3(:,767), t3x64(:,:,236), nhel, den(162))
    call Hcont_VV(nsync, wf8(:,71), wf8(:,113), A(:,237), n3(:,768), t3x64(:,:,237), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,72), wf8(:,114), A(:,238), n3(:,769), t3x64(:,:,238), nhel, den(168))
    call Hcont_VV(nsync, wf8(:,71), wf8(:,117), A(:,239), n3(:,770), t3x64(:,:,239), nhel, den(171))
    call Hcont_VV(nsync, wf8(:,72), wf8(:,118), A(:,240), n3(:,771), t3x64(:,:,240), nhel, den(172))
    call Hcont_VV(nsync, wf8(:,69), wf8(:,123), A(:,241), n3(:,772), t3x64(:,:,241), nhel, den(169))
    call Hcont_VV(nsync, wf8(:,70), wf8(:,124), A(:,242), n3(:,773), t3x64(:,:,242), nhel, den(170))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,125), A(:,243), n3(:,774), t3x64(:,:,243), nhel, den(146))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,126), A(:,244), n3(:,775), t3x64(:,:,244), nhel, den(148))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,127), A(:,245), n3(:,776), t3x64(:,:,245), nhel, den(150))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,128), A(:,246), n3(:,777), t3x64(:,:,246), nhel, den(152))
    call Hcont_VV(nsync, wf8(:,63), wf8(:,125), A(:,247), n3(:,778), t3x64(:,:,247), nhel, den(155))
    call Hcont_VV(nsync, wf8(:,64), wf8(:,126), A(:,248), n3(:,779), t3x64(:,:,248), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,127), A(:,249), n3(:,780), t3x64(:,:,249), nhel, den(153))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,128), A(:,250), n3(:,781), t3x64(:,:,250), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,129), wf8(:,130), A(:,251), n3(:,782), t3x64(:,:,251), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,131), A(:,252), n3(:,783), t3x64(:,:,252), nhel, den(225))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,39), A(:,253), n3(:,784), t3x64(:,:,253), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,40), A(:,254), n3(:,785), t3x64(:,:,254), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,129), wf8(:,132), A(:,255), n3(:,786), t3x64(:,:,255), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,131), wf8(:,132), A(:,256), n3(:,787), t3x64(:,:,256), nhel, den(228))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,133), A(:,257), n3(:,788), t3x64(:,:,257), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,133), A(:,258), n3(:,789), t3x64(:,:,258), nhel, den(26))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,41), A(:,259), n3(:,790), t3x64(:,:,259), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,42), A(:,260), n3(:,791), t3x64(:,:,260), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,134), A(:,261), n3(:,792), t3x64(:,:,261), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,134), A(:,262), n3(:,793), t3x64(:,:,262), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,135), wf8(:,136), A(:,263), n3(:,794), t3x64(:,:,263), nhel, den(231))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,137), A(:,264), n3(:,795), t3x64(:,:,264), nhel, den(232))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,43), A(:,265), n3(:,796), t3x64(:,:,265), nhel, den(67))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,44), A(:,266), n3(:,797), t3x64(:,:,266), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,135), wf8(:,138), A(:,267), n3(:,798), t3x64(:,:,267), nhel, den(234))
    call Hcont_QA(nsync, wf8(:,137), wf8(:,138), A(:,268), n3(:,799), t3x64(:,:,268), nhel, den(235))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,133), A(:,269), n3(:,800), t3x64(:,:,269), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,133), A(:,270), n3(:,801), t3x64(:,:,270), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,45), A(:,271), n3(:,802), t3x64(:,:,271), nhel, den(57))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,46), A(:,272), n3(:,803), t3x64(:,:,272), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,134), A(:,273), n3(:,804), t3x64(:,:,273), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,134), A(:,274), n3(:,805), t3x64(:,:,274), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,139), A(:,275), n3(:,806), t3x64(:,:,275), nhel, den(236))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,140), A(:,276), n3(:,807), t3x64(:,:,276), nhel, den(237))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,141), A(:,277), n3(:,808), t3x64(:,:,277), nhel, den(238))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,142), A(:,278), n3(:,809), t3x64(:,:,278), nhel, den(239))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,143), A(:,279), n3(:,810), t3x64(:,:,279), nhel, den(103))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,144), A(:,280), n3(:,811), t3x64(:,:,280), nhel, den(106))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,145), A(:,281), n3(:,812), t3x64(:,:,281), nhel, den(109))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,146), A(:,282), n3(:,813), t3x64(:,:,282), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,147), A(:,283), n3(:,814), t3x64(:,:,283), nhel, den(240))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,148), A(:,284), n3(:,815), t3x64(:,:,284), nhel, den(241))
    call Hcont_VV(nsync, wf8(:,67), wf8(:,141), A(:,285), n3(:,816), t3x64(:,:,285), nhel, den(153))
    call Hcont_VV(nsync, wf8(:,68), wf8(:,142), A(:,286), n3(:,817), t3x64(:,:,286), nhel, den(154))
    call Hcont_VV(nsync, wf8(:,63), wf8(:,147), A(:,287), n3(:,818), t3x64(:,:,287), nhel, den(155))
    call Hcont_VV(nsync, wf8(:,64), wf8(:,148), A(:,288), n3(:,819), t3x64(:,:,288), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,67), wf8(:,143), A(:,289), n3(:,820), t3x64(:,:,289), nhel, den(150))
    call Hcont_VV(nsync, wf8(:,68), wf8(:,144), A(:,290), n3(:,821), t3x64(:,:,290), nhel, den(152))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,149), A(:,291), n3(:,822), t3x64(:,:,291), nhel, den(242))
    call Hcont_VV(nsync, wf8(:,55), wf8(:,150), A(:,292), n3(:,823), t3x64(:,:,292), nhel, den(243))
    call Hcont_VV(nsync, wf8(:,61), wf8(:,149), A(:,293), n3(:,824), t3x64(:,:,293), nhel, den(169))
    call Hcont_VV(nsync, wf8(:,62), wf8(:,150), A(:,294), n3(:,825), t3x64(:,:,294), nhel, den(170))
    call Hcont_VV(nsync, wf8(:,71), wf8(:,139), A(:,295), n3(:,826), t3x64(:,:,295), nhel, den(171))
    call Hcont_VV(nsync, wf8(:,72), wf8(:,140), A(:,296), n3(:,827), t3x64(:,:,296), nhel, den(172))
    call Hcont_VV(nsync, wf8(:,71), wf8(:,145), A(:,297), n3(:,828), t3x64(:,:,297), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,72), wf8(:,146), A(:,298), n3(:,829), t3x64(:,:,298), nhel, den(168))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,151), A(:,299), n3(:,830), t3x64(:,:,299), nhel, den(125))
    call Hcont_VV(nsync, wf8(:,55), wf8(:,152), A(:,300), n3(:,831), t3x64(:,:,300), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,153), A(:,301), n3(:,832), t3x64(:,:,301), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,154), A(:,302), n3(:,833), t3x64(:,:,302), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,61), wf8(:,151), A(:,303), n3(:,834), t3x64(:,:,303), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,62), wf8(:,152), A(:,304), n3(:,835), t3x64(:,:,304), nhel, den(138))
    call Hcont_VV(nsync, wf8(:,63), wf8(:,153), A(:,305), n3(:,836), t3x64(:,:,305), nhel, den(141))
    call Hcont_VV(nsync, wf8(:,64), wf8(:,154), A(:,306), n3(:,837), t3x64(:,:,306), nhel, den(144))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,47), A(:,307), n3(:,838), t3x64(:,:,307), nhel, den(81))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,48), A(:,308), n3(:,839), t3x64(:,:,308), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,156), A(:,309), n3(:,840), t3x64(:,:,309), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,158), A(:,310), n3(:,841), t3x64(:,:,310), nhel, den(88))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,49), A(:,311), n3(:,842), t3x64(:,:,311), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,50), A(:,312), n3(:,843), t3x64(:,:,312), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,160), A(:,313), n3(:,844), t3x64(:,:,313), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,162), A(:,314), n3(:,845), t3x64(:,:,314), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,156), A(:,315), n3(:,846), t3x64(:,:,315), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,158), A(:,316), n3(:,847), t3x64(:,:,316), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,160), A(:,317), n3(:,848), t3x64(:,:,317), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,162), A(:,318), n3(:,849), t3x64(:,:,318), nhel, den(100))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,51), A(:,319), n3(:,850), t3x64(:,:,319), nhel, den(32))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,52), A(:,320), n3(:,851), t3x64(:,:,320), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,164), A(:,321), n3(:,852), t3x64(:,:,321), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,166), A(:,322), n3(:,853), t3x64(:,:,322), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,53), A(:,323), n3(:,854), t3x64(:,:,323), nhel, den(43))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,54), A(:,324), n3(:,855), t3x64(:,:,324), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,168), A(:,325), n3(:,856), t3x64(:,:,325), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,170), A(:,326), n3(:,857), t3x64(:,:,326), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,164), A(:,327), n3(:,858), t3x64(:,:,327), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,166), A(:,328), n3(:,859), t3x64(:,:,328), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,168), A(:,329), n3(:,860), t3x64(:,:,329), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,170), A(:,330), n3(:,861), t3x64(:,:,330), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,171), A(:,331), n3(:,862), t3x64(:,:,331), nhel, den(244))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,172), A(:,332), n3(:,863), t3x64(:,:,332), nhel, den(245))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,55), A(:,333), n3(:,864), t3x64(:,:,333), nhel, den(43))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,56), A(:,334), n3(:,865), t3x64(:,:,334), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,171), A(:,335), n3(:,866), t3x64(:,:,335), nhel, den(246))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,172), A(:,336), n3(:,867), t3x64(:,:,336), nhel, den(247))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,173), A(:,337), n3(:,868), t3x64(:,:,337), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,173), A(:,338), n3(:,869), t3x64(:,:,338), nhel, den(51))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,57), A(:,339), n3(:,870), t3x64(:,:,339), nhel, den(32))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,58), A(:,340), n3(:,871), t3x64(:,:,340), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,174), A(:,341), n3(:,872), t3x64(:,:,341), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,174), A(:,342), n3(:,873), t3x64(:,:,342), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,175), A(:,343), n3(:,874), t3x64(:,:,343), nhel, den(248))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,176), A(:,344), n3(:,875), t3x64(:,:,344), nhel, den(249))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,59), A(:,345), n3(:,876), t3x64(:,:,345), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,60), A(:,346), n3(:,877), t3x64(:,:,346), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,175), A(:,347), n3(:,878), t3x64(:,:,347), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,176), A(:,348), n3(:,879), t3x64(:,:,348), nhel, den(251))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,173), A(:,349), n3(:,880), t3x64(:,:,349), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,173), A(:,350), n3(:,881), t3x64(:,:,350), nhel, den(98))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,61), A(:,351), n3(:,882), t3x64(:,:,351), nhel, den(81))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,62), A(:,352), n3(:,883), t3x64(:,:,352), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,174), A(:,353), n3(:,884), t3x64(:,:,353), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,174), A(:,354), n3(:,885), t3x64(:,:,354), nhel, den(88))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,177), A(:,355), n3(:,886), t3x64(:,:,355), nhel, den(252))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,178), A(:,356), n3(:,887), t3x64(:,:,356), nhel, den(253))
    call Hcont_VV(nsync, wf8(:,57), wf8(:,179), A(:,357), n3(:,888), t3x64(:,:,357), nhel, den(254))
    call Hcont_VV(nsync, wf8(:,59), wf8(:,180), A(:,358), n3(:,889), t3x64(:,:,358), nhel, den(255))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,181), A(:,359), n3(:,890), t3x64(:,:,359), nhel, den(125))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,182), A(:,360), n3(:,891), t3x64(:,:,360), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,57), wf8(:,183), A(:,361), n3(:,892), t3x64(:,:,361), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,59), wf8(:,184), A(:,362), n3(:,893), t3x64(:,:,362), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,185), A(:,363), n3(:,894), t3x64(:,:,363), nhel, den(256))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,186), A(:,364), n3(:,895), t3x64(:,:,364), nhel, den(257))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,185), A(:,365), n3(:,896), t3x64(:,:,365), nhel, den(258))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,186), A(:,366), n3(:,897), t3x64(:,:,366), nhel, den(259))
    call Hcont_VV(nsync, wf8(:,65), wf8(:,179), A(:,367), n3(:,898), t3x64(:,:,367), nhel, den(260))
    call Hcont_VV(nsync, wf8(:,66), wf8(:,180), A(:,368), n3(:,899), t3x64(:,:,368), nhel, den(261))
    call Hcont_VV(nsync, wf8(:,65), wf8(:,183), A(:,369), n3(:,900), t3x64(:,:,369), nhel, den(146))
    call Hcont_VV(nsync, wf8(:,66), wf8(:,184), A(:,370), n3(:,901), t3x64(:,:,370), nhel, den(148))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,187), A(:,371), n3(:,902), t3x64(:,:,371), nhel, den(262))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,188), A(:,372), n3(:,903), t3x64(:,:,372), nhel, den(263))
    call Hcont_VV(nsync, wf8(:,69), wf8(:,177), A(:,373), n3(:,904), t3x64(:,:,373), nhel, den(264))
    call Hcont_VV(nsync, wf8(:,70), wf8(:,178), A(:,374), n3(:,905), t3x64(:,:,374), nhel, den(265))
    call Hcont_VV(nsync, wf8(:,49), wf8(:,187), A(:,375), n3(:,906), t3x64(:,:,375), nhel, den(266))
    call Hcont_VV(nsync, wf8(:,50), wf8(:,188), A(:,376), n3(:,907), t3x64(:,:,376), nhel, den(267))
    call Hcont_VV(nsync, wf8(:,69), wf8(:,181), A(:,377), n3(:,908), t3x64(:,:,377), nhel, den(159))
    call Hcont_VV(nsync, wf8(:,70), wf8(:,182), A(:,378), n3(:,909), t3x64(:,:,378), nhel, den(162))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,189), A(:,379), n3(:,910), t3x64(:,:,379), nhel, den(103))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,190), A(:,380), n3(:,911), t3x64(:,:,380), nhel, den(106))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,191), A(:,381), n3(:,912), t3x64(:,:,381), nhel, den(109))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,192), A(:,382), n3(:,913), t3x64(:,:,382), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,49), wf8(:,191), A(:,383), n3(:,914), t3x64(:,:,383), nhel, den(114))
    call Hcont_VV(nsync, wf8(:,50), wf8(:,192), A(:,384), n3(:,915), t3x64(:,:,384), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,189), A(:,385), n3(:,916), t3x64(:,:,385), nhel, den(119))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,190), A(:,386), n3(:,917), t3x64(:,:,386), nhel, den(122))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,63), A(:,387), n3(:,918), t3x64(:,:,387), nhel, den(57))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,64), A(:,388), n3(:,919), t3x64(:,:,388), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,194), A(:,389), n3(:,920), t3x64(:,:,389), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,196), A(:,390), n3(:,921), t3x64(:,:,390), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,65), A(:,391), n3(:,922), t3x64(:,:,391), nhel, den(67))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,66), A(:,392), n3(:,923), t3x64(:,:,392), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,198), A(:,393), n3(:,924), t3x64(:,:,393), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,200), A(:,394), n3(:,925), t3x64(:,:,394), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,194), A(:,395), n3(:,926), t3x64(:,:,395), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,196), A(:,396), n3(:,927), t3x64(:,:,396), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,198), A(:,397), n3(:,928), t3x64(:,:,397), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,200), A(:,398), n3(:,929), t3x64(:,:,398), nhel, den(78))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,67), A(:,399), n3(:,930), t3x64(:,:,399), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,68), A(:,400), n3(:,931), t3x64(:,:,400), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,202), A(:,401), n3(:,932), t3x64(:,:,401), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,204), A(:,402), n3(:,933), t3x64(:,:,402), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,69), A(:,403), n3(:,934), t3x64(:,:,403), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,70), A(:,404), n3(:,935), t3x64(:,:,404), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,206), A(:,405), n3(:,936), t3x64(:,:,405), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,208), A(:,406), n3(:,937), t3x64(:,:,406), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,202), A(:,407), n3(:,938), t3x64(:,:,407), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,204), A(:,408), n3(:,939), t3x64(:,:,408), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,206), A(:,409), n3(:,940), t3x64(:,:,409), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,208), A(:,410), n3(:,941), t3x64(:,:,410), nhel, den(28))
    call Hcont_VV(nsync, wf16(:,71), wf4(:,50), A(:,411), n3(:,942), t3x64(:,:,411), nhel, den(271))
    call Hcont_VV(nsync, wf16(:,72), wf4(:,51), A(:,412), n3(:,943), t3x64(:,:,412), nhel, den(274))
    call Hcont_VV(nsync, wf16(:,71), wf4(:,52), A(:,413), n3(:,944), t3x64(:,:,413), nhel, den(275))
    call Hcont_VV(nsync, wf16(:,72), wf4(:,53), A(:,414), n3(:,945), t3x64(:,:,414), nhel, den(276))
    call Hcont_QA(nsync, wf4(:,54), wf16(:,74), A(:,415), n3(:,946), t3x64(:,:,415), nhel, den(280))
    call Hcont_QA(nsync, wf4(:,54), wf16(:,76), A(:,416), n3(:,947), t3x64(:,:,416), nhel, den(283))
    call Hcont_QA(nsync, wf4(:,55), wf16(:,77), A(:,417), n3(:,948), t3x64(:,:,417), nhel, den(286))
    call Hcont_QA(nsync, wf4(:,55), wf16(:,78), A(:,418), n3(:,949), t3x64(:,:,418), nhel, den(288))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,209), A(:,419), n3(:,950), t3x64(:,:,419), nhel, den(290))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,210), A(:,420), n3(:,951), t3x64(:,:,420), nhel, den(292))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,211), A(:,421), n3(:,952), t3x64(:,:,421), nhel, den(292))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,212), A(:,422), n3(:,953), t3x64(:,:,422), nhel, den(294))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,213), A(:,423), n3(:,954), t3x64(:,:,423), nhel, den(296))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,213), A(:,424), n3(:,955), t3x64(:,:,424), nhel, den(297))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,214), A(:,425), n3(:,956), t3x64(:,:,425), nhel, den(298))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,215), A(:,426), n3(:,957), t3x64(:,:,426), nhel, den(299))
    call Hcont_VV(nsync, wf4(:,50), wf16(:,79), A(:,427), n3(:,958), t3x64(:,:,427), nhel, den(302))
    call Hcont_VV(nsync, wf4(:,51), wf16(:,80), A(:,428), n3(:,959), t3x64(:,:,428), nhel, den(304))
    call Hcont_VV(nsync, wf4(:,52), wf16(:,79), A(:,429), n3(:,960), t3x64(:,:,429), nhel, den(305))
    call Hcont_VV(nsync, wf4(:,53), wf16(:,80), A(:,430), n3(:,961), t3x64(:,:,430), nhel, den(306))
    call Hcont_QA(nsync, wf4(:,57), wf16(:,82), A(:,431), n3(:,962), t3x64(:,:,431), nhel, den(310))
    call Hcont_QA(nsync, wf4(:,57), wf16(:,84), A(:,432), n3(:,963), t3x64(:,:,432), nhel, den(313))
    call Hcont_QA(nsync, wf4(:,58), wf16(:,85), A(:,433), n3(:,964), t3x64(:,:,433), nhel, den(316))
    call Hcont_QA(nsync, wf4(:,58), wf16(:,86), A(:,434), n3(:,965), t3x64(:,:,434), nhel, den(318))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,216), A(:,435), n3(:,966), t3x64(:,:,435), nhel, den(319))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,217), A(:,436), n3(:,967), t3x64(:,:,436), nhel, den(320))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,218), A(:,437), n3(:,968), t3x64(:,:,437), nhel, den(320))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,219), A(:,438), n3(:,969), t3x64(:,:,438), nhel, den(321))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,220), A(:,439), n3(:,970), t3x64(:,:,439), nhel, den(322))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,221), A(:,440), n3(:,971), t3x64(:,:,440), nhel, den(323))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,222), A(:,441), n3(:,972), t3x64(:,:,441), nhel, den(325))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,222), A(:,442), n3(:,973), t3x64(:,:,442), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,209), A(:,443), n3(:,974), t3x64(:,:,443), nhel, den(327))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,210), A(:,444), n3(:,975), t3x64(:,:,444), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,211), A(:,445), n3(:,976), t3x64(:,:,445), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,212), A(:,446), n3(:,977), t3x64(:,:,446), nhel, den(329))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,223), A(:,447), n3(:,978), t3x64(:,:,447), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,223), A(:,448), n3(:,979), t3x64(:,:,448), nhel, den(332))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,214), A(:,449), n3(:,980), t3x64(:,:,449), nhel, den(333))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,215), A(:,450), n3(:,981), t3x64(:,:,450), nhel, den(334))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,216), A(:,451), n3(:,982), t3x64(:,:,451), nhel, den(335))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,217), A(:,452), n3(:,983), t3x64(:,:,452), nhel, den(336))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,218), A(:,453), n3(:,984), t3x64(:,:,453), nhel, den(336))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,219), A(:,454), n3(:,985), t3x64(:,:,454), nhel, den(337))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,220), A(:,455), n3(:,986), t3x64(:,:,455), nhel, den(338))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,221), A(:,456), n3(:,987), t3x64(:,:,456), nhel, den(339))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,224), A(:,457), n3(:,988), t3x64(:,:,457), nhel, den(341))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,224), A(:,458), n3(:,989), t3x64(:,:,458), nhel, den(342))
    call Hcont_QA(nsync, wf4(:,62), wf16(:,88), A(:,459), n3(:,990), t3x64(:,:,459), nhel, den(346))
    call Hcont_QA(nsync, wf4(:,62), wf16(:,90), A(:,460), n3(:,991), t3x64(:,:,460), nhel, den(349))
    call Hcont_VV(nsync, wf16(:,91), wf4(:,63), A(:,461), n3(:,992), t3x64(:,:,461), nhel, den(353))
    call Hcont_VV(nsync, wf16(:,92), wf4(:,64), A(:,462), n3(:,993), t3x64(:,:,462), nhel, den(356))
    call Hcont_VV(nsync, wf16(:,91), wf4(:,65), A(:,463), n3(:,994), t3x64(:,:,463), nhel, den(357))
    call Hcont_VV(nsync, wf16(:,92), wf4(:,66), A(:,464), n3(:,995), t3x64(:,:,464), nhel, den(358))
    call Hcont_QA(nsync, wf4(:,55), wf16(:,93), A(:,465), n3(:,996), t3x64(:,:,465), nhel, den(360))
    call Hcont_QA(nsync, wf4(:,55), wf16(:,94), A(:,466), n3(:,997), t3x64(:,:,466), nhel, den(362))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,225), A(:,467), n3(:,998), t3x64(:,:,467), nhel, den(364))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,225), A(:,468), n3(:,999), t3x64(:,:,468), nhel, den(365))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,226), A(:,469), n3(:,1000), t3x64(:,:,469), nhel, den(367))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,227), A(:,470), n3(:,1001), t3x64(:,:,470), nhel, den(369))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,228), A(:,471), n3(:,1002), t3x64(:,:,471), nhel, den(369))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,229), A(:,472), n3(:,1003), t3x64(:,:,472), nhel, den(371))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,230), A(:,473), n3(:,1004), t3x64(:,:,473), nhel, den(372))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,231), A(:,474), n3(:,1005), t3x64(:,:,474), nhel, den(373))
    call Hcont_QA(nsync, wf4(:,68), wf16(:,96), A(:,475), n3(:,1006), t3x64(:,:,475), nhel, den(377))
    call Hcont_QA(nsync, wf4(:,68), wf16(:,98), A(:,476), n3(:,1007), t3x64(:,:,476), nhel, den(380))
    call Hcont_VV(nsync, wf4(:,63), wf16(:,99), A(:,477), n3(:,1008), t3x64(:,:,477), nhel, den(383))
    call Hcont_VV(nsync, wf4(:,64), wf16(:,100), A(:,478), n3(:,1009), t3x64(:,:,478), nhel, den(385))
    call Hcont_VV(nsync, wf4(:,65), wf16(:,99), A(:,479), n3(:,1010), t3x64(:,:,479), nhel, den(386))
    call Hcont_VV(nsync, wf4(:,66), wf16(:,100), A(:,480), n3(:,1011), t3x64(:,:,480), nhel, den(387))
    call Hcont_QA(nsync, wf4(:,58), wf16(:,101), A(:,481), n3(:,1012), t3x64(:,:,481), nhel, den(389))
    call Hcont_QA(nsync, wf4(:,58), wf16(:,102), A(:,482), n3(:,1013), t3x64(:,:,482), nhel, den(391))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,232), A(:,483), n3(:,1014), t3x64(:,:,483), nhel, den(392))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,233), A(:,484), n3(:,1015), t3x64(:,:,484), nhel, den(393))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,234), A(:,485), n3(:,1016), t3x64(:,:,485), nhel, den(393))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,235), A(:,486), n3(:,1017), t3x64(:,:,486), nhel, den(394))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,236), A(:,487), n3(:,1018), t3x64(:,:,487), nhel, den(395))
    call Hcont_QA(nsync, wf8(:,130), wf8(:,237), A(:,488), n3(:,1019), t3x64(:,:,488), nhel, den(396))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,222), A(:,489), n3(:,1020), t3x64(:,:,489), nhel, den(397))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,222), A(:,490), n3(:,1021), t3x64(:,:,490), nhel, den(398))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,238), A(:,491), n3(:,1022), t3x64(:,:,491), nhel, den(400))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,238), A(:,492), n3(:,1023), t3x64(:,:,492), nhel, den(401))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,226), A(:,493), n3(:,1024), t3x64(:,:,493), nhel, den(402))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,227), A(:,494), n3(:,1025), t3x64(:,:,494), nhel, den(403))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,228), A(:,495), n3(:,1026), t3x64(:,:,495), nhel, den(403))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,229), A(:,496), n3(:,1027), t3x64(:,:,496), nhel, den(404))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,230), A(:,497), n3(:,1028), t3x64(:,:,497), nhel, den(405))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,231), A(:,498), n3(:,1029), t3x64(:,:,498), nhel, den(406))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,232), A(:,499), n3(:,1030), t3x64(:,:,499), nhel, den(407))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,233), A(:,500), n3(:,1031), t3x64(:,:,500), nhel, den(408))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,234), A(:,501), n3(:,1032), t3x64(:,:,501), nhel, den(408))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,235), A(:,502), n3(:,1033), t3x64(:,:,502), nhel, den(409))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,236), A(:,503), n3(:,1034), t3x64(:,:,503), nhel, den(410))
    call Hcont_QA(nsync, wf8(:,132), wf8(:,237), A(:,504), n3(:,1035), t3x64(:,:,504), nhel, den(411))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,224), A(:,505), n3(:,1036), t3x64(:,:,505), nhel, den(412))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,224), A(:,506), n3(:,1037), t3x64(:,:,506), nhel, den(413))
    call Hcont_VV(nsync, wf16(:,103), wf4(:,70), A(:,507), n3(:,1038), t3x64(:,:,507), nhel, den(417))
    call Hcont_VV(nsync, wf16(:,104), wf4(:,71), A(:,508), n3(:,1039), t3x64(:,:,508), nhel, den(420))
    call Hcont_VV(nsync, wf16(:,103), wf4(:,72), A(:,509), n3(:,1040), t3x64(:,:,509), nhel, den(421))
    call Hcont_VV(nsync, wf16(:,104), wf4(:,73), A(:,510), n3(:,1041), t3x64(:,:,510), nhel, den(422))
    call Hcont_QA(nsync, wf4(:,54), wf16(:,106), A(:,511), n3(:,1042), t3x64(:,:,511), nhel, den(425))
    call Hcont_QA(nsync, wf4(:,54), wf16(:,108), A(:,512), n3(:,1043), t3x64(:,:,512), nhel, den(428))
    call Hcont_QA(nsync, wf4(:,74), wf16(:,109), A(:,513), n3(:,1044), t3x64(:,:,513), nhel, den(431))
    call Hcont_QA(nsync, wf4(:,74), wf16(:,110), A(:,514), n3(:,1045), t3x64(:,:,514), nhel, den(433))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,239), A(:,515), n3(:,1046), t3x64(:,:,515), nhel, den(435))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,240), A(:,516), n3(:,1047), t3x64(:,:,516), nhel, den(437))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,241), A(:,517), n3(:,1048), t3x64(:,:,517), nhel, den(437))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,242), A(:,518), n3(:,1049), t3x64(:,:,518), nhel, den(439))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,213), A(:,519), n3(:,1050), t3x64(:,:,519), nhel, den(440))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,213), A(:,520), n3(:,1051), t3x64(:,:,520), nhel, den(441))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,243), A(:,521), n3(:,1052), t3x64(:,:,521), nhel, den(442))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,244), A(:,522), n3(:,1053), t3x64(:,:,522), nhel, den(443))
    call Hcont_VV(nsync, wf4(:,70), wf16(:,111), A(:,523), n3(:,1054), t3x64(:,:,523), nhel, den(446))
    call Hcont_VV(nsync, wf4(:,71), wf16(:,112), A(:,524), n3(:,1055), t3x64(:,:,524), nhel, den(448))
    call Hcont_VV(nsync, wf4(:,72), wf16(:,111), A(:,525), n3(:,1056), t3x64(:,:,525), nhel, den(449))
    call Hcont_VV(nsync, wf4(:,73), wf16(:,112), A(:,526), n3(:,1057), t3x64(:,:,526), nhel, den(450))
    call Hcont_QA(nsync, wf4(:,57), wf16(:,114), A(:,527), n3(:,1058), t3x64(:,:,527), nhel, den(453))
    call Hcont_QA(nsync, wf4(:,57), wf16(:,116), A(:,528), n3(:,1059), t3x64(:,:,528), nhel, den(456))
    call Hcont_QA(nsync, wf4(:,75), wf16(:,117), A(:,529), n3(:,1060), t3x64(:,:,529), nhel, den(459))
    call Hcont_QA(nsync, wf4(:,75), wf16(:,118), A(:,530), n3(:,1061), t3x64(:,:,530), nhel, den(461))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,245), A(:,531), n3(:,1062), t3x64(:,:,531), nhel, den(462))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,246), A(:,532), n3(:,1063), t3x64(:,:,532), nhel, den(463))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,247), A(:,533), n3(:,1064), t3x64(:,:,533), nhel, den(463))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,248), A(:,534), n3(:,1065), t3x64(:,:,534), nhel, den(464))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,249), A(:,535), n3(:,1066), t3x64(:,:,535), nhel, den(465))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,250), A(:,536), n3(:,1067), t3x64(:,:,536), nhel, den(466))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,251), A(:,537), n3(:,1068), t3x64(:,:,537), nhel, den(468))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,251), A(:,538), n3(:,1069), t3x64(:,:,538), nhel, den(469))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,239), A(:,539), n3(:,1070), t3x64(:,:,539), nhel, den(470))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,240), A(:,540), n3(:,1071), t3x64(:,:,540), nhel, den(471))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,241), A(:,541), n3(:,1072), t3x64(:,:,541), nhel, den(471))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,242), A(:,542), n3(:,1073), t3x64(:,:,542), nhel, den(472))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,223), A(:,543), n3(:,1074), t3x64(:,:,543), nhel, den(473))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,223), A(:,544), n3(:,1075), t3x64(:,:,544), nhel, den(474))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,243), A(:,545), n3(:,1076), t3x64(:,:,545), nhel, den(475))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,244), A(:,546), n3(:,1077), t3x64(:,:,546), nhel, den(476))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,245), A(:,547), n3(:,1078), t3x64(:,:,547), nhel, den(477))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,246), A(:,548), n3(:,1079), t3x64(:,:,548), nhel, den(478))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,247), A(:,549), n3(:,1080), t3x64(:,:,549), nhel, den(478))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,248), A(:,550), n3(:,1081), t3x64(:,:,550), nhel, den(479))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,249), A(:,551), n3(:,1082), t3x64(:,:,551), nhel, den(480))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,250), A(:,552), n3(:,1083), t3x64(:,:,552), nhel, den(481))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,252), A(:,553), n3(:,1084), t3x64(:,:,553), nhel, den(483))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,252), A(:,554), n3(:,1085), t3x64(:,:,554), nhel, den(484))
    call Hcont_QA(nsync, wf4(:,62), wf16(:,120), A(:,555), n3(:,1086), t3x64(:,:,555), nhel, den(487))
    call Hcont_QA(nsync, wf4(:,62), wf16(:,122), A(:,556), n3(:,1087), t3x64(:,:,556), nhel, den(490))
    call Hcont_VV(nsync, wf16(:,123), wf4(:,78), A(:,557), n3(:,1088), t3x64(:,:,557), nhel, den(494))
    call Hcont_VV(nsync, wf16(:,124), wf4(:,79), A(:,558), n3(:,1089), t3x64(:,:,558), nhel, den(497))
    call Hcont_VV(nsync, wf16(:,123), wf4(:,80), A(:,559), n3(:,1090), t3x64(:,:,559), nhel, den(498))
    call Hcont_VV(nsync, wf16(:,124), wf4(:,81), A(:,560), n3(:,1091), t3x64(:,:,560), nhel, den(499))
    call Hcont_QA(nsync, wf4(:,74), wf16(:,125), A(:,561), n3(:,1092), t3x64(:,:,561), nhel, den(501))
    call Hcont_QA(nsync, wf4(:,74), wf16(:,126), A(:,562), n3(:,1093), t3x64(:,:,562), nhel, den(503))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,225), A(:,563), n3(:,1094), t3x64(:,:,563), nhel, den(504))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,225), A(:,564), n3(:,1095), t3x64(:,:,564), nhel, den(505))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,253), A(:,565), n3(:,1096), t3x64(:,:,565), nhel, den(507))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,254), A(:,566), n3(:,1097), t3x64(:,:,566), nhel, den(509))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,255), A(:,567), n3(:,1098), t3x64(:,:,567), nhel, den(509))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,256), A(:,568), n3(:,1099), t3x64(:,:,568), nhel, den(511))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,257), A(:,569), n3(:,1100), t3x64(:,:,569), nhel, den(512))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,258), A(:,570), n3(:,1101), t3x64(:,:,570), nhel, den(513))
    call Hcont_QA(nsync, wf4(:,68), wf16(:,128), A(:,571), n3(:,1102), t3x64(:,:,571), nhel, den(516))
    call Hcont_QA(nsync, wf4(:,68), wf16(:,130), A(:,572), n3(:,1103), t3x64(:,:,572), nhel, den(519))
    call Hcont_VV(nsync, wf4(:,78), wf16(:,131), A(:,573), n3(:,1104), t3x64(:,:,573), nhel, den(522))
    call Hcont_VV(nsync, wf4(:,79), wf16(:,132), A(:,574), n3(:,1105), t3x64(:,:,574), nhel, den(524))
    call Hcont_VV(nsync, wf4(:,80), wf16(:,131), A(:,575), n3(:,1106), t3x64(:,:,575), nhel, den(525))
    call Hcont_VV(nsync, wf4(:,81), wf16(:,132), A(:,576), n3(:,1107), t3x64(:,:,576), nhel, den(526))
    call Hcont_QA(nsync, wf4(:,75), wf16(:,133), A(:,577), n3(:,1108), t3x64(:,:,577), nhel, den(528))
    call Hcont_QA(nsync, wf4(:,75), wf16(:,134), A(:,578), n3(:,1109), t3x64(:,:,578), nhel, den(530))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,259), A(:,579), n3(:,1110), t3x64(:,:,579), nhel, den(531))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,260), A(:,580), n3(:,1111), t3x64(:,:,580), nhel, den(532))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,261), A(:,581), n3(:,1112), t3x64(:,:,581), nhel, den(532))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,262), A(:,582), n3(:,1113), t3x64(:,:,582), nhel, den(533))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,263), A(:,583), n3(:,1114), t3x64(:,:,583), nhel, den(534))
    call Hcont_QA(nsync, wf8(:,136), wf8(:,264), A(:,584), n3(:,1115), t3x64(:,:,584), nhel, den(535))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,251), A(:,585), n3(:,1116), t3x64(:,:,585), nhel, den(536))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,251), A(:,586), n3(:,1117), t3x64(:,:,586), nhel, den(537))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,238), A(:,587), n3(:,1118), t3x64(:,:,587), nhel, den(538))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,238), A(:,588), n3(:,1119), t3x64(:,:,588), nhel, den(539))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,253), A(:,589), n3(:,1120), t3x64(:,:,589), nhel, den(540))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,254), A(:,590), n3(:,1121), t3x64(:,:,590), nhel, den(541))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,255), A(:,591), n3(:,1122), t3x64(:,:,591), nhel, den(541))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,256), A(:,592), n3(:,1123), t3x64(:,:,592), nhel, den(542))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,257), A(:,593), n3(:,1124), t3x64(:,:,593), nhel, den(543))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,258), A(:,594), n3(:,1125), t3x64(:,:,594), nhel, den(544))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,259), A(:,595), n3(:,1126), t3x64(:,:,595), nhel, den(545))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,260), A(:,596), n3(:,1127), t3x64(:,:,596), nhel, den(546))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,261), A(:,597), n3(:,1128), t3x64(:,:,597), nhel, den(546))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,262), A(:,598), n3(:,1129), t3x64(:,:,598), nhel, den(547))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,263), A(:,599), n3(:,1130), t3x64(:,:,599), nhel, den(548))
    call Hcont_QA(nsync, wf8(:,138), wf8(:,264), A(:,600), n3(:,1131), t3x64(:,:,600), nhel, den(549))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,252), A(:,601), n3(:,1132), t3x64(:,:,601), nhel, den(550))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,252), A(:,602), n3(:,1133), t3x64(:,:,602), nhel, den(551))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,265), A(:,603), n3(:,1134), t3x64(:,:,603), nhel, den(552))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,266), A(:,604), n3(:,1135), t3x64(:,:,604), nhel, den(553))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,267), A(:,605), n3(:,1136), t3x64(:,:,605), nhel, den(554))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,268), A(:,606), n3(:,1137), t3x64(:,:,606), nhel, den(555))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,269), A(:,607), n3(:,1138), t3x64(:,:,607), nhel, den(556))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,270), A(:,608), n3(:,1139), t3x64(:,:,608), nhel, den(557))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,271), A(:,609), n3(:,1140), t3x64(:,:,609), nhel, den(558))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,272), A(:,610), n3(:,1141), t3x64(:,:,610), nhel, den(559))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,273), A(:,611), n3(:,1142), t3x64(:,:,611), nhel, den(560))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,274), A(:,612), n3(:,1143), t3x64(:,:,612), nhel, den(561))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,275), A(:,613), n3(:,1144), t3x64(:,:,613), nhel, den(562))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,276), A(:,614), n3(:,1145), t3x64(:,:,614), nhel, den(563))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,277), A(:,615), n3(:,1146), t3x64(:,:,615), nhel, den(564))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,278), A(:,616), n3(:,1147), t3x64(:,:,616), nhel, den(565))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,279), A(:,617), n3(:,1148), t3x64(:,:,617), nhel, den(566))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,280), A(:,618), n3(:,1149), t3x64(:,:,618), nhel, den(567))
    call Hcont_VV(nsync, wf8(:,49), wf8(:,267), A(:,619), n3(:,1150), t3x64(:,:,619), nhel, den(568))
    call Hcont_VV(nsync, wf8(:,50), wf8(:,268), A(:,620), n3(:,1151), t3x64(:,:,620), nhel, den(569))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,281), A(:,621), n3(:,1152), t3x64(:,:,621), nhel, den(570))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,282), A(:,622), n3(:,1153), t3x64(:,:,622), nhel, den(571))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,283), A(:,623), n3(:,1154), t3x64(:,:,623), nhel, den(572))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,284), A(:,624), n3(:,1155), t3x64(:,:,624), nhel, den(573))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,285), A(:,625), n3(:,1156), t3x64(:,:,625), nhel, den(574))
    call Hcont_VV(nsync, wf8(:,48), wf8(:,286), A(:,626), n3(:,1157), t3x64(:,:,626), nhel, den(575))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,265), A(:,627), n3(:,1158), t3x64(:,:,627), nhel, den(576))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,266), A(:,628), n3(:,1159), t3x64(:,:,628), nhel, den(577))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,287), A(:,629), n3(:,1160), t3x64(:,:,629), nhel, den(578))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,288), A(:,630), n3(:,1161), t3x64(:,:,630), nhel, den(579))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,289), A(:,631), n3(:,1162), t3x64(:,:,631), nhel, den(580))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,290), A(:,632), n3(:,1163), t3x64(:,:,632), nhel, den(581))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,291), A(:,633), n3(:,1164), t3x64(:,:,633), nhel, den(582))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,292), A(:,634), n3(:,1165), t3x64(:,:,634), nhel, den(583))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,293), A(:,635), n3(:,1166), t3x64(:,:,635), nhel, den(584))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,294), A(:,636), n3(:,1167), t3x64(:,:,636), nhel, den(585))
    call Hcont_VV(nsync, wf8(:,57), wf8(:,295), A(:,637), n3(:,1168), t3x64(:,:,637), nhel, den(586))
    call Hcont_VV(nsync, wf8(:,59), wf8(:,296), A(:,638), n3(:,1169), t3x64(:,:,638), nhel, den(587))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,297), A(:,639), n3(:,1170), t3x64(:,:,639), nhel, den(588))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,298), A(:,640), n3(:,1171), t3x64(:,:,640), nhel, den(589))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,299), A(:,641), n3(:,1172), t3x64(:,:,641), nhel, den(590))
    call Hcont_VV(nsync, wf8(:,55), wf8(:,300), A(:,642), n3(:,1173), t3x64(:,:,642), nhel, den(591))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,301), A(:,643), n3(:,1174), t3x64(:,:,643), nhel, den(592))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,302), A(:,644), n3(:,1175), t3x64(:,:,644), nhel, den(593))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,303), A(:,645), n3(:,1176), t3x64(:,:,645), nhel, den(594))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,304), A(:,646), n3(:,1177), t3x64(:,:,646), nhel, den(595))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,305), A(:,647), n3(:,1178), t3x64(:,:,647), nhel, den(596))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,306), A(:,648), n3(:,1179), t3x64(:,:,648), nhel, den(597))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,307), A(:,649), n3(:,1180), t3x64(:,:,649), nhel, den(598))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,308), A(:,650), n3(:,1181), t3x64(:,:,650), nhel, den(599))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,309), A(:,651), n3(:,1182), t3x64(:,:,651), nhel, den(600))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,310), A(:,652), n3(:,1183), t3x64(:,:,652), nhel, den(601))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,311), A(:,653), n3(:,1184), t3x64(:,:,653), nhel, den(602))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,312), A(:,654), n3(:,1185), t3x64(:,:,654), nhel, den(603))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,313), A(:,655), n3(:,1186), t3x64(:,:,655), nhel, den(604))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,314), A(:,656), n3(:,1187), t3x64(:,:,656), nhel, den(605))
    call Hcont_VV(nsync, wf8(:,61), wf8(:,299), A(:,657), n3(:,1188), t3x64(:,:,657), nhel, den(606))
    call Hcont_VV(nsync, wf8(:,62), wf8(:,300), A(:,658), n3(:,1189), t3x64(:,:,658), nhel, den(607))
    call Hcont_VV(nsync, wf8(:,57), wf8(:,315), A(:,659), n3(:,1190), t3x64(:,:,659), nhel, den(608))
    call Hcont_VV(nsync, wf8(:,59), wf8(:,316), A(:,660), n3(:,1191), t3x64(:,:,660), nhel, den(609))
    call Hcont_VV(nsync, wf8(:,57), wf8(:,317), A(:,661), n3(:,1192), t3x64(:,:,661), nhel, den(610))
    call Hcont_VV(nsync, wf8(:,59), wf8(:,318), A(:,662), n3(:,1193), t3x64(:,:,662), nhel, den(611))
    call Hcont_VV(nsync, wf8(:,57), wf8(:,319), A(:,663), n3(:,1194), t3x64(:,:,663), nhel, den(612))
    call Hcont_VV(nsync, wf8(:,59), wf8(:,320), A(:,664), n3(:,1195), t3x64(:,:,664), nhel, den(613))
    call Hcont_VV(nsync, wf8(:,63), wf8(:,297), A(:,665), n3(:,1196), t3x64(:,:,665), nhel, den(614))
    call Hcont_VV(nsync, wf8(:,64), wf8(:,298), A(:,666), n3(:,1197), t3x64(:,:,666), nhel, den(615))
    call Hcont_VV(nsync, wf8(:,65), wf8(:,295), A(:,667), n3(:,1198), t3x64(:,:,667), nhel, den(616))
    call Hcont_VV(nsync, wf8(:,66), wf8(:,296), A(:,668), n3(:,1199), t3x64(:,:,668), nhel, den(617))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,321), A(:,669), n3(:,1200), t3x64(:,:,669), nhel, den(618))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,322), A(:,670), n3(:,1201), t3x64(:,:,670), nhel, den(619))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,323), A(:,671), n3(:,1202), t3x64(:,:,671), nhel, den(620))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,324), A(:,672), n3(:,1203), t3x64(:,:,672), nhel, den(621))
    call Hcont_VV(nsync, wf8(:,58), wf8(:,325), A(:,673), n3(:,1204), t3x64(:,:,673), nhel, den(622))
    call Hcont_VV(nsync, wf8(:,60), wf8(:,326), A(:,674), n3(:,1205), t3x64(:,:,674), nhel, den(623))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,327), A(:,675), n3(:,1206), t3x64(:,:,675), nhel, den(624))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,328), A(:,676), n3(:,1207), t3x64(:,:,676), nhel, den(625))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,329), A(:,677), n3(:,1208), t3x64(:,:,677), nhel, den(626))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,330), A(:,678), n3(:,1209), t3x64(:,:,678), nhel, den(627))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,331), A(:,679), n3(:,1210), t3x64(:,:,679), nhel, den(628))
    call Hcont_VV(nsync, wf8(:,44), wf8(:,332), A(:,680), n3(:,1211), t3x64(:,:,680), nhel, den(629))
    call Hcont_VV(nsync, wf8(:,67), wf8(:,271), A(:,681), n3(:,1212), t3x64(:,:,681), nhel, den(630))
    call Hcont_VV(nsync, wf8(:,68), wf8(:,272), A(:,682), n3(:,1213), t3x64(:,:,682), nhel, den(631))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,329), A(:,683), n3(:,1214), t3x64(:,:,683), nhel, den(632))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,330), A(:,684), n3(:,1215), t3x64(:,:,684), nhel, den(633))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,331), A(:,685), n3(:,1216), t3x64(:,:,685), nhel, den(634))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,332), A(:,686), n3(:,1217), t3x64(:,:,686), nhel, den(635))
    call Hcont_VV(nsync, wf8(:,65), wf8(:,315), A(:,687), n3(:,1218), t3x64(:,:,687), nhel, den(636))
    call Hcont_VV(nsync, wf8(:,66), wf8(:,316), A(:,688), n3(:,1219), t3x64(:,:,688), nhel, den(637))
    call Hcont_VV(nsync, wf8(:,65), wf8(:,317), A(:,689), n3(:,1220), t3x64(:,:,689), nhel, den(638))
    call Hcont_VV(nsync, wf8(:,66), wf8(:,318), A(:,690), n3(:,1221), t3x64(:,:,690), nhel, den(639))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,327), A(:,691), n3(:,1222), t3x64(:,:,691), nhel, den(640))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,328), A(:,692), n3(:,1223), t3x64(:,:,692), nhel, den(641))
    call Hcont_VV(nsync, wf8(:,65), wf8(:,319), A(:,693), n3(:,1224), t3x64(:,:,693), nhel, den(642))
    call Hcont_VV(nsync, wf8(:,66), wf8(:,320), A(:,694), n3(:,1225), t3x64(:,:,694), nhel, den(643))
    call Hcont_VV(nsync, wf8(:,63), wf8(:,321), A(:,695), n3(:,1226), t3x64(:,:,695), nhel, den(644))
    call Hcont_VV(nsync, wf8(:,64), wf8(:,322), A(:,696), n3(:,1227), t3x64(:,:,696), nhel, den(645))
    call Hcont_VV(nsync, wf8(:,67), wf8(:,291), A(:,697), n3(:,1228), t3x64(:,:,697), nhel, den(646))
    call Hcont_VV(nsync, wf8(:,68), wf8(:,292), A(:,698), n3(:,1229), t3x64(:,:,698), nhel, den(647))
    call Hcont_VV(nsync, wf8(:,69), wf8(:,293), A(:,699), n3(:,1230), t3x64(:,:,699), nhel, den(648))
    call Hcont_VV(nsync, wf8(:,70), wf8(:,294), A(:,700), n3(:,1231), t3x64(:,:,700), nhel, den(649))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,333), A(:,701), n3(:,1232), t3x64(:,:,701), nhel, den(650))
    call Hcont_VV(nsync, wf8(:,55), wf8(:,334), A(:,702), n3(:,1233), t3x64(:,:,702), nhel, den(651))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,335), A(:,703), n3(:,1234), t3x64(:,:,703), nhel, den(652))
    call Hcont_VV(nsync, wf8(:,55), wf8(:,336), A(:,704), n3(:,1235), t3x64(:,:,704), nhel, den(653))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,337), A(:,705), n3(:,1236), t3x64(:,:,705), nhel, den(654))
    call Hcont_VV(nsync, wf8(:,55), wf8(:,338), A(:,706), n3(:,1237), t3x64(:,:,706), nhel, den(655))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,339), A(:,707), n3(:,1238), t3x64(:,:,707), nhel, den(656))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,340), A(:,708), n3(:,1239), t3x64(:,:,708), nhel, den(657))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,341), A(:,709), n3(:,1240), t3x64(:,:,709), nhel, den(658))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,342), A(:,710), n3(:,1241), t3x64(:,:,710), nhel, den(659))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,343), A(:,711), n3(:,1242), t3x64(:,:,711), nhel, den(660))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,344), A(:,712), n3(:,1243), t3x64(:,:,712), nhel, den(661))
    call Hcont_VV(nsync, wf8(:,71), wf8(:,269), A(:,713), n3(:,1244), t3x64(:,:,713), nhel, den(662))
    call Hcont_VV(nsync, wf8(:,72), wf8(:,270), A(:,714), n3(:,1245), t3x64(:,:,714), nhel, den(663))
    call Hcont_VV(nsync, wf8(:,69), wf8(:,311), A(:,715), n3(:,1246), t3x64(:,:,715), nhel, den(664))
    call Hcont_VV(nsync, wf8(:,70), wf8(:,312), A(:,716), n3(:,1247), t3x64(:,:,716), nhel, den(665))
    call Hcont_VV(nsync, wf8(:,69), wf8(:,313), A(:,717), n3(:,1248), t3x64(:,:,717), nhel, den(666))
    call Hcont_VV(nsync, wf8(:,70), wf8(:,314), A(:,718), n3(:,1249), t3x64(:,:,718), nhel, den(667))
    call Hcont_VV(nsync, wf8(:,49), wf8(:,339), A(:,719), n3(:,1250), t3x64(:,:,719), nhel, den(668))
    call Hcont_VV(nsync, wf8(:,50), wf8(:,340), A(:,720), n3(:,1251), t3x64(:,:,720), nhel, den(669))
    call Hcont_VV(nsync, wf8(:,49), wf8(:,341), A(:,721), n3(:,1252), t3x64(:,:,721), nhel, den(670))
    call Hcont_VV(nsync, wf8(:,50), wf8(:,342), A(:,722), n3(:,1253), t3x64(:,:,722), nhel, den(671))
    call Hcont_VV(nsync, wf8(:,69), wf8(:,309), A(:,723), n3(:,1254), t3x64(:,:,723), nhel, den(672))
    call Hcont_VV(nsync, wf8(:,70), wf8(:,310), A(:,724), n3(:,1255), t3x64(:,:,724), nhel, den(673))
    call Hcont_VV(nsync, wf8(:,49), wf8(:,343), A(:,725), n3(:,1256), t3x64(:,:,725), nhel, den(674))
    call Hcont_VV(nsync, wf8(:,50), wf8(:,344), A(:,726), n3(:,1257), t3x64(:,:,726), nhel, den(675))
    call Hcont_VV(nsync, wf8(:,71), wf8(:,281), A(:,727), n3(:,1258), t3x64(:,:,727), nhel, den(676))
    call Hcont_VV(nsync, wf8(:,72), wf8(:,282), A(:,728), n3(:,1259), t3x64(:,:,728), nhel, den(677))
    call Hcont_VV(nsync, wf8(:,61), wf8(:,337), A(:,729), n3(:,1260), t3x64(:,:,729), nhel, den(678))
    call Hcont_VV(nsync, wf8(:,62), wf8(:,338), A(:,730), n3(:,1261), t3x64(:,:,730), nhel, den(679))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,1)%j-A(j,2)%j-A(j,3)%j-A(j,4)%j-A(j,5)%j-A(j,6)%j-A(j,7)%j-A(j,8)%j-A(j,9)%j-A(j,10)%j-A(j,11)%j-A(j,12)%j &
       +A(j,13)%j+A(j,14)%j+A(j,15)%j+A(j,16)%j+A(j,17)%j+A(j,18)%j+A(j,19)%j+A(j,20)%j+A(j,21)%j+A(j,22)%j+A(j,23)%j+A(j,24)%j &
       +A(j,25)%j+A(j,26)%j+A(j,27)%j+A(j,28)%j+A(j,29)%j+A(j,30)%j+A(j,31)%j+A(j,32)%j+A(j,33)%j+A(j,34)%j+A(j,35)%j+A(j,36)%j &
       -A(j,37)%j-A(j,38)%j-A(j,39)%j-A(j,40)%j-A(j,41)%j-A(j,42)%j-A(j,43)%j-A(j,44)%j-A(j,45)%j-A(j,46)%j-A(j,47)%j-A(j,48)%j &
       -A(j,49)%j-A(j,50)%j+A(j,51)%j+A(j,52)%j+A(j,53)%j+A(j,54)%j-A(j,55)%j-A(j,56)%j-A(j,57)%j-A(j,58)%j+A(j,59)%j+A(j,60)%j &
       -A(j,61)%j-A(j,62)%j+A(j,63)%j+A(j,64)%j+A(j,65)%j+A(j,66)%j-A(j,67)%j-A(j,68)%j-A(j,69)%j-A(j,70)%j+A(j,71)%j+A(j,72)%j &
       -A(j,73)%j-A(j,74)%j+A(j,75)%j+A(j,76)%j-A(j,77)%j-A(j,78)%j+A(j,79)%j+A(j,80)%j)*f(1)

  M2(1)%j = (-A(j,90)%j-A(j,91)%j-A(j,92)%j-A(j,93)%j-A(j,94)%j-A(j,95)%j-A(j,96)%j-A(j,97)%j-A(j,98)%j-A(j,99)%j-A(j,100)%j &
       -A(j,101)%j-A(j,102)%j-A(j,103)%j-A(j,104)%j-A(j,105)%j-A(j,106)%j-A(j,107)%j-A(j,108)%j-A(j,109)%j-A(j,110)%j-A(j,111)%j &
       -A(j,112)%j-A(j,113)%j+A(j,115)%j+A(j,116)%j+A(j,117)%j+A(j,118)%j+A(j,119)%j+A(j,120)%j+A(j,121)%j+A(j,122)%j+A(j,123)%j &
       +A(j,124)%j+A(j,125)%j+A(j,126)%j+A(j,127)%j+A(j,128)%j+A(j,129)%j+A(j,130)%j+A(j,131)%j+A(j,132)%j+A(j,133)%j+A(j,134)%j &
       +A(j,135)%j+A(j,136)%j+A(j,137)%j+A(j,138)%j+A(j,139)%j+A(j,140)%j+A(j,141)%j+A(j,142)%j+A(j,143)%j+A(j,144)%j+A(j,145)%j &
       +A(j,146)%j+A(j,147)%j+A(j,148)%j+A(j,149)%j+A(j,150)%j-A(j,151)%j-A(j,152)%j-A(j,153)%j-A(j,154)%j-A(j,155)%j-A(j,156)%j &
       -A(j,157)%j-A(j,158)%j-A(j,159)%j-A(j,160)%j-A(j,161)%j-A(j,162)%j-A(j,163)%j-A(j,164)%j+A(j,165)%j+A(j,166)%j+A(j,167)%j &
       +A(j,168)%j-A(j,169)%j-A(j,170)%j-A(j,171)%j-A(j,172)%j+A(j,173)%j+A(j,174)%j-A(j,175)%j-A(j,176)%j+A(j,177)%j+A(j,178)%j &
       +A(j,179)%j+A(j,180)%j-A(j,181)%j-A(j,182)%j-A(j,183)%j-A(j,184)%j+A(j,185)%j+A(j,186)%j-A(j,187)%j-A(j,188)%j+A(j,189)%j &
       +A(j,190)%j-A(j,191)%j-A(j,192)%j+A(j,193)%j+A(j,194)%j+A(j,195)%j+A(j,196)%j+A(j,197)%j+A(j,198)%j+A(j,199)%j+A(j,200)%j &
       +A(j,201)%j+A(j,202)%j+A(j,203)%j+A(j,204)%j+A(j,205)%j+A(j,206)%j-A(j,207)%j-A(j,208)%j-A(j,209)%j-A(j,210)%j-A(j,211)%j &
       -A(j,212)%j-A(j,213)%j-A(j,214)%j-A(j,215)%j-A(j,216)%j-A(j,217)%j-A(j,218)%j+A(j,219)%j+A(j,220)%j-A(j,221)%j-A(j,222)%j &
       -A(j,223)%j-A(j,224)%j+A(j,225)%j+A(j,226)%j+A(j,227)%j+A(j,228)%j-A(j,229)%j-A(j,230)%j+A(j,231)%j+A(j,232)%j-A(j,233)%j &
       -A(j,234)%j-A(j,235)%j-A(j,236)%j+A(j,237)%j+A(j,238)%j+A(j,239)%j+A(j,240)%j-A(j,241)%j-A(j,242)%j+A(j,243)%j+A(j,244)%j &
       -A(j,245)%j-A(j,246)%j+A(j,247)%j+A(j,248)%j-A(j,249)%j-A(j,250)%j-A(j,251)%j-A(j,252)%j-A(j,253)%j-A(j,254)%j-A(j,255)%j &
       -A(j,256)%j-A(j,257)%j-A(j,258)%j-A(j,259)%j-A(j,260)%j-A(j,261)%j-A(j,262)%j+A(j,263)%j+A(j,264)%j+A(j,265)%j+A(j,266)%j &
       +A(j,267)%j+A(j,268)%j+A(j,269)%j+A(j,270)%j+A(j,271)%j+A(j,272)%j+A(j,273)%j+A(j,274)%j+A(j,275)%j+A(j,276)%j-A(j,277)%j &
       -A(j,278)%j-A(j,279)%j-A(j,280)%j+A(j,281)%j+A(j,282)%j+A(j,283)%j+A(j,284)%j-A(j,285)%j-A(j,286)%j+A(j,287)%j+A(j,288)%j &
       -A(j,289)%j-A(j,290)%j-A(j,291)%j-A(j,292)%j-A(j,293)%j-A(j,294)%j+A(j,295)%j+A(j,296)%j+A(j,297)%j+A(j,298)%j-A(j,299)%j &
       -A(j,300)%j+A(j,301)%j+A(j,302)%j-A(j,303)%j-A(j,304)%j+A(j,305)%j+A(j,306)%j-A(j,307)%j-A(j,308)%j-A(j,309)%j-A(j,310)%j &
       -A(j,311)%j-A(j,312)%j-A(j,313)%j-A(j,314)%j-A(j,315)%j-A(j,316)%j-A(j,317)%j-A(j,318)%j+A(j,319)%j+A(j,320)%j+A(j,321)%j &
       +A(j,322)%j+A(j,323)%j+A(j,324)%j+A(j,325)%j+A(j,326)%j+A(j,327)%j+A(j,328)%j+A(j,329)%j+A(j,330)%j+A(j,331)%j+A(j,332)%j &
       +A(j,333)%j+A(j,334)%j+A(j,335)%j+A(j,336)%j+A(j,337)%j+A(j,338)%j+A(j,339)%j+A(j,340)%j+A(j,341)%j+A(j,342)%j-A(j,343)%j &
       -A(j,344)%j-A(j,345)%j-A(j,346)%j-A(j,347)%j-A(j,348)%j-A(j,349)%j-A(j,350)%j-A(j,351)%j-A(j,352)%j-A(j,353)%j-A(j,354)%j &
       -A(j,355)%j-A(j,356)%j+A(j,357)%j+A(j,358)%j-A(j,359)%j-A(j,360)%j+A(j,361)%j+A(j,362)%j-A(j,363)%j-A(j,364)%j-A(j,365)%j &
       -A(j,366)%j+A(j,367)%j+A(j,368)%j+A(j,369)%j+A(j,370)%j+A(j,371)%j+A(j,372)%j-A(j,373)%j-A(j,374)%j+A(j,375)%j+A(j,376)%j &
       -A(j,377)%j-A(j,378)%j-A(j,379)%j-A(j,380)%j+A(j,381)%j+A(j,382)%j+A(j,383)%j+A(j,384)%j-A(j,385)%j-A(j,386)%j+A(j,387)%j &
       +A(j,388)%j+A(j,389)%j+A(j,390)%j+A(j,391)%j+A(j,392)%j+A(j,393)%j+A(j,394)%j+A(j,395)%j+A(j,396)%j+A(j,397)%j+A(j,398)%j &
       -A(j,399)%j-A(j,400)%j-A(j,401)%j-A(j,402)%j-A(j,403)%j-A(j,404)%j-A(j,405)%j-A(j,406)%j-A(j,407)%j-A(j,408)%j-A(j,409)%j &
       -A(j,410)%j+A(j,411)%j+A(j,412)%j+A(j,413)%j+A(j,414)%j+A(j,415)%j+A(j,416)%j+A(j,417)%j+A(j,418)%j+A(j,419)%j+A(j,420)%j &
       +A(j,421)%j+A(j,422)%j+A(j,423)%j+A(j,424)%j+A(j,425)%j+A(j,426)%j+A(j,427)%j+A(j,428)%j+A(j,429)%j+A(j,430)%j+A(j,431)%j &
       +A(j,432)%j+A(j,433)%j+A(j,434)%j+A(j,435)%j+A(j,436)%j+A(j,437)%j+A(j,438)%j+A(j,439)%j+A(j,440)%j+A(j,441)%j+A(j,442)%j &
       +A(j,443)%j+A(j,444)%j+A(j,445)%j+A(j,446)%j+A(j,447)%j+A(j,448)%j+A(j,449)%j+A(j,450)%j+A(j,451)%j+A(j,452)%j+A(j,453)%j &
       +A(j,454)%j+A(j,455)%j+A(j,456)%j+A(j,457)%j+A(j,458)%j-A(j,459)%j-A(j,460)%j-A(j,461)%j-A(j,462)%j-A(j,463)%j-A(j,464)%j &
       -A(j,465)%j-A(j,466)%j-A(j,467)%j-A(j,468)%j-A(j,469)%j-A(j,470)%j-A(j,471)%j-A(j,472)%j-A(j,473)%j-A(j,474)%j-A(j,475)%j &
       -A(j,476)%j-A(j,477)%j-A(j,478)%j-A(j,479)%j-A(j,480)%j-A(j,481)%j-A(j,482)%j-A(j,483)%j-A(j,484)%j-A(j,485)%j-A(j,486)%j &
       -A(j,487)%j-A(j,488)%j-A(j,489)%j-A(j,490)%j-A(j,491)%j-A(j,492)%j-A(j,493)%j-A(j,494)%j-A(j,495)%j-A(j,496)%j-A(j,497)%j &
       -A(j,498)%j-A(j,499)%j-A(j,500)%j-A(j,501)%j-A(j,502)%j-A(j,503)%j-A(j,504)%j-A(j,505)%j-A(j,506)%j-A(j,507)%j-A(j,508)%j &
       -A(j,509)%j-A(j,510)%j-A(j,511)%j-A(j,512)%j-A(j,513)%j-A(j,514)%j-A(j,515)%j-A(j,516)%j-A(j,517)%j-A(j,518)%j-A(j,519)%j &
       -A(j,520)%j-A(j,521)%j-A(j,522)%j-A(j,523)%j-A(j,524)%j-A(j,525)%j-A(j,526)%j-A(j,527)%j-A(j,528)%j-A(j,529)%j-A(j,530)%j &
       -A(j,531)%j-A(j,532)%j-A(j,533)%j-A(j,534)%j-A(j,535)%j-A(j,536)%j-A(j,537)%j-A(j,538)%j-A(j,539)%j-A(j,540)%j-A(j,541)%j &
       -A(j,542)%j-A(j,543)%j-A(j,544)%j-A(j,545)%j-A(j,546)%j-A(j,547)%j-A(j,548)%j-A(j,549)%j-A(j,550)%j-A(j,551)%j-A(j,552)%j &
       -A(j,553)%j-A(j,554)%j+A(j,555)%j+A(j,556)%j+A(j,557)%j+A(j,558)%j+A(j,559)%j+A(j,560)%j+A(j,561)%j+A(j,562)%j+A(j,563)%j &
       +A(j,564)%j+A(j,565)%j+A(j,566)%j+A(j,567)%j+A(j,568)%j+A(j,569)%j+A(j,570)%j+A(j,571)%j+A(j,572)%j+A(j,573)%j+A(j,574)%j &
       +A(j,575)%j+A(j,576)%j+A(j,577)%j+A(j,578)%j+A(j,579)%j+A(j,580)%j+A(j,581)%j+A(j,582)%j+A(j,583)%j+A(j,584)%j+A(j,585)%j &
       +A(j,586)%j+A(j,587)%j+A(j,588)%j+A(j,589)%j+A(j,590)%j+A(j,591)%j+A(j,592)%j+A(j,593)%j+A(j,594)%j+A(j,595)%j+A(j,596)%j &
       +A(j,597)%j+A(j,598)%j+A(j,599)%j+A(j,600)%j+A(j,601)%j+A(j,602)%j+A(j,603)%j+A(j,604)%j-A(j,605)%j-A(j,606)%j-A(j,607)%j &
       -A(j,608)%j+A(j,609)%j+A(j,610)%j+A(j,611)%j+A(j,612)%j+A(j,613)%j+A(j,614)%j-A(j,615)%j-A(j,616)%j-A(j,617)%j-A(j,618)%j &
       -A(j,619)%j-A(j,620)%j-A(j,621)%j-A(j,622)%j-A(j,623)%j-A(j,624)%j-A(j,625)%j-A(j,626)%j+A(j,627)%j+A(j,628)%j+A(j,629)%j &
       +A(j,630)%j+A(j,631)%j+A(j,632)%j+A(j,633)%j+A(j,634)%j+A(j,635)%j+A(j,636)%j-A(j,637)%j-A(j,638)%j-A(j,639)%j-A(j,640)%j &
       +A(j,641)%j+A(j,642)%j+A(j,643)%j+A(j,644)%j+A(j,645)%j+A(j,646)%j-A(j,647)%j-A(j,648)%j-A(j,649)%j-A(j,650)%j+A(j,651)%j &
       +A(j,652)%j+A(j,653)%j+A(j,654)%j+A(j,655)%j+A(j,656)%j+A(j,657)%j+A(j,658)%j-A(j,659)%j-A(j,660)%j-A(j,661)%j-A(j,662)%j &
       -A(j,663)%j-A(j,664)%j-A(j,665)%j-A(j,666)%j-A(j,667)%j-A(j,668)%j-A(j,669)%j-A(j,670)%j-A(j,671)%j-A(j,672)%j-A(j,673)%j &
       -A(j,674)%j+A(j,675)%j+A(j,676)%j+A(j,677)%j+A(j,678)%j+A(j,679)%j+A(j,680)%j+A(j,681)%j+A(j,682)%j+A(j,683)%j+A(j,684)%j &
       +A(j,685)%j+A(j,686)%j-A(j,687)%j-A(j,688)%j-A(j,689)%j-A(j,690)%j+A(j,691)%j+A(j,692)%j-A(j,693)%j-A(j,694)%j-A(j,695)%j &
       -A(j,696)%j+A(j,697)%j+A(j,698)%j+A(j,699)%j+A(j,700)%j+A(j,701)%j+A(j,702)%j+A(j,703)%j+A(j,704)%j+A(j,705)%j+A(j,706)%j &
       -A(j,707)%j-A(j,708)%j-A(j,709)%j-A(j,710)%j-A(j,711)%j-A(j,712)%j-A(j,713)%j-A(j,714)%j+A(j,715)%j+A(j,716)%j+A(j,717)%j &
       +A(j,718)%j-A(j,719)%j-A(j,720)%j-A(j,721)%j-A(j,722)%j+A(j,723)%j+A(j,724)%j-A(j,725)%j-A(j,726)%j-A(j,727)%j-A(j,728)%j &
       +A(j,729)%j+A(j,730)%j)*f(2)+(-A(j,81)%j+A(j,85)%j)*f(3)+(-A(j,82)%j-A(j,83)%j+A(j,86)%j+A(j,87)%j)*f(4)+(-A(j,84)%j &
       +A(j,88)%j)*f(5)+(A(j,89)%j-A(j,114)%j)*f(6)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexaa_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexaa_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu


! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexaa_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_ppllll_ew_eeexexaa_1_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for e- e- e+ e+ gamma gamma -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for e- e- e+ e+ gamma gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,6)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for ppllll_ew_eeexexaa_1:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_ppllll_ew_eeexexaa_1, only: &
    & external_perm_inv_ppllll_ew_eeexexaa_1
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 6
    r = external_perm_inv_ppllll_ew_eeexexaa_1(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
        case(6)
          call assign_helicity_flip(ex6(:)%hf,ex6(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(64,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexaa_1_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mflip(1)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 1
    do j = 1, 1
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_ppllll_ew_eeexexaa_1_/**/REALKIND
