
module ol_vamp_3_ppllll_ew_nexnmemxuux_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_3(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_ew_nexnmemxuux_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_ew_nexnmemxuux_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllll_ew_nexnmemxuux_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllll_ew_nexnmemxuux_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,35) :: G0
  complex(REALKIND), dimension(4,5,4,65) :: G1
  complex(REALKIND), dimension(1,18) :: G0tensor
  complex(REALKIND), dimension(5,6) :: G1tensor
  complex(REALKIND), dimension(15,55) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,119),Q(:,58),G1(:,:,:,1))
  call check_last_TV_S(l_switch,G1(:,:,:,1),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,1))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,119),Q(:,58),G1(:,:,:,2))
  call check_last_TV_S(l_switch,G1(:,:,:,2),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,2))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,119),Q(:,58),G1(:,:,:,3))
  call check_last_CV_D(l_switch,G1(:,:,:,3),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,3))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,119),Q(:,58),G1(:,:,:,4))
  call check_last_CV_D(l_switch,G1(:,:,:,4),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,4))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,119),G1(:,:,:,5))
  call check_last_DV_C(l_switch,G1(:,:,:,5),Q(:,58),wf(:,1),G2tensor(:,5))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,119),G1(:,:,:,6))
  call check_last_DV_C(l_switch,G1(:,:,:,6),Q(:,58),wf(:,1),G2tensor(:,6))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,119),Q(:,58),G1(:,:,:,7))
  call check_last_UW_V(l_switch,G1(:,:,:,7),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,7))
  call loop_VV_S(G0(:,:,:,1),wf(:,119),G0(:,:,:,2))
  call check_last_SV_V(l_switch,G0(:,:,:,2),wf(:,1),G0tensor(:,1))
  call check_last_SV_V(l_switch,G0(:,:,:,2),wf(:,1),G0tensor(:,2))
  call loop_VV_S(G0(:,:,:,1),wf(:,119),G0(:,:,:,3))
  call check_last_SV_V(l_switch,G0(:,:,:,3),wf(:,1),G0tensor(:,3))
  call loop_QW_A(G0(:,:,:,1),wf(:,120),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,58),ZERO,G1(:,:,:,8))
  call loop_QW_A(G1(:,:,:,8),wf(:,1),G1(:,:,:,9))
  call check_last_Q_A(l_switch,G1(:,:,:,9),Q(:,63),ZERO,G2tensor(:,8))
  call loop_QW_A(G1(:,:,:,8),wf(:,1),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,63),ML,G2tensor(:,9))
  call loop_QW_A(G0(:,:,:,1),wf(:,120),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,58),MT,G1(:,:,:,11))
  call loop_QW_A(G1(:,:,:,11),wf(:,1),G1(:,:,:,12))
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,63),MB,G2tensor(:,10))
  call loop_QW_A(G0(:,:,:,1),wf(:,121),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,58),ZERO,G1(:,:,:,13))
  call loop_QW_A(G1(:,:,:,13),wf(:,1),G1(:,:,:,14))
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,63),ZERO,G2tensor(:,11))
  call loop_QW_A(G1(:,:,:,13),wf(:,1),G1(:,:,:,15))
  call check_last_Q_A(l_switch,G1(:,:,:,15),Q(:,63),ML,G2tensor(:,12))
  call loop_QW_A(G0(:,:,:,1),wf(:,121),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,58),MT,G1(:,:,:,16))
  call loop_QW_A(G1(:,:,:,16),wf(:,1),G1(:,:,:,17))
  call check_last_Q_A(l_switch,G1(:,:,:,17),Q(:,63),MB,G2tensor(:,13))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,120),Q(:,58),G1(:,:,:,18))
  call check_last_TV_S(l_switch,G1(:,:,:,18),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,14))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,120),Q(:,58),G1(:,:,:,19))
  call check_last_TV_S(l_switch,G1(:,:,:,19),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,15))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,121),Q(:,58),G1(:,:,:,20))
  call check_last_TV_S(l_switch,G1(:,:,:,20),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,16))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,121),Q(:,58),G1(:,:,:,21))
  call check_last_TV_S(l_switch,G1(:,:,:,21),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,17))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,120),Q(:,58),G1(:,:,:,22))
  call check_last_CV_D(l_switch,G1(:,:,:,22),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,18))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,120),Q(:,58),G1(:,:,:,23))
  call check_last_CV_D(l_switch,G1(:,:,:,23),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,19))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,120),G1(:,:,:,24))
  call check_last_DV_C(l_switch,G1(:,:,:,24),Q(:,58),wf(:,1),G2tensor(:,20))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,120),G1(:,:,:,25))
  call check_last_DV_C(l_switch,G1(:,:,:,25),Q(:,58),wf(:,1),G2tensor(:,21))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,121),Q(:,58),G1(:,:,:,26))
  call check_last_CV_D(l_switch,G1(:,:,:,26),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,22))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,121),Q(:,58),G1(:,:,:,27))
  call check_last_CV_D(l_switch,G1(:,:,:,27),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,23))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,121),G1(:,:,:,28))
  call check_last_DV_C(l_switch,G1(:,:,:,28),Q(:,58),wf(:,1),G2tensor(:,24))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,121),G1(:,:,:,29))
  call check_last_DV_C(l_switch,G1(:,:,:,29),Q(:,58),wf(:,1),G2tensor(:,25))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,120),Q(:,58),G1(:,:,:,30))
  call check_last_UW_V(l_switch,G1(:,:,:,30),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,26))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,121),Q(:,58),G1(:,:,:,31))
  call check_last_UW_V(l_switch,G1(:,:,:,31),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,27))
  call loop_VV_S(G0(:,:,:,1),wf(:,120),G0(:,:,:,8))
  call check_last_SV_V(l_switch,G0(:,:,:,8),wf(:,1),G0tensor(:,4))
  call check_last_SV_V(l_switch,G0(:,:,:,8),wf(:,1),G0tensor(:,5))
  call loop_VV_S(G0(:,:,:,1),wf(:,120),G0(:,:,:,9))
  call check_last_SV_V(l_switch,G0(:,:,:,9),wf(:,1),G0tensor(:,6))
  call loop_VV_S(G0(:,:,:,1),wf(:,121),G0(:,:,:,10))
  call check_last_SV_V(l_switch,G0(:,:,:,10),wf(:,1),G0tensor(:,7))
  call check_last_SV_V(l_switch,G0(:,:,:,10),wf(:,1),G0tensor(:,8))
  call loop_VV_S(G0(:,:,:,1),wf(:,121),G0(:,:,:,11))
  call check_last_SV_V(l_switch,G0(:,:,:,11),wf(:,1),G0tensor(:,9))
  call loop_ZQ_A(G0(:,:,:,1),wf(:,56),G0(:,:,:,12),gZl)
  call loop_Q_A(G0(:,:,:,12),Q(:,52),ZERO,G1(:,:,:,32))
  call check_last_QA_Z(l_switch,G1(:,:,:,32),wf(:,18),G1tensor(:,1),gZl)
  call loop_WQ_A(G0(:,:,:,1),wf(:,56),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,52),ZERO,G1(:,:,:,33))
  call check_last_QA_W(l_switch,G1(:,:,:,33),wf(:,18),G1tensor(:,2))
  call loop_ZQ_A(G0(:,:,:,1),wf(:,57),G0(:,:,:,14),gZl)
  call loop_Q_A(G0(:,:,:,14),Q(:,52),ZERO,G1(:,:,:,34))
  call check_last_QA_Z(l_switch,G1(:,:,:,34),wf(:,18),G1tensor(:,3),gZl)
  call loop_WQ_A(G0(:,:,:,1),wf(:,57),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,52),ZERO,G1(:,:,:,35))
  call check_last_QA_W(l_switch,G1(:,:,:,35),wf(:,18),G1tensor(:,4))
  call loop_AW_Q(G0(:,:,:,1),wf(:,116),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,53),ZERO,G1(:,:,:,36))
  call loop_AW_Q(G1(:,:,:,36),wf(:,2),G1(:,:,:,37))
  call check_last_A_Q(l_switch,G1(:,:,:,37),Q(:,63),ZERO,G2tensor(:,28))
  call loop_AW_Q(G1(:,:,:,36),wf(:,2),G1(:,:,:,38))
  call check_last_A_Q(l_switch,G1(:,:,:,38),Q(:,63),ML,G2tensor(:,29))
  call loop_AW_Q(G0(:,:,:,1),wf(:,116),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,53),MT,G1(:,:,:,39))
  call loop_AW_Q(G1(:,:,:,39),wf(:,2),G1(:,:,:,40))
  call check_last_A_Q(l_switch,G1(:,:,:,40),Q(:,63),MB,G2tensor(:,30))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,116),Q(:,53),G1(:,:,:,41))
  call check_last_TV_S(l_switch,G1(:,:,:,41),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,31))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,116),Q(:,53),G1(:,:,:,42))
  call check_last_TV_S(l_switch,G1(:,:,:,42),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,32))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,116),G1(:,:,:,43))
  call check_last_DV_C(l_switch,G1(:,:,:,43),Q(:,53),wf(:,2),G2tensor(:,33))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,116),G1(:,:,:,44))
  call check_last_DV_C(l_switch,G1(:,:,:,44),Q(:,53),wf(:,2),G2tensor(:,34))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,116),Q(:,53),G1(:,:,:,45))
  call check_last_CV_D(l_switch,G1(:,:,:,45),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,35))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,116),Q(:,53),G1(:,:,:,46))
  call check_last_CV_D(l_switch,G1(:,:,:,46),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,36))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,116),Q(:,53),G1(:,:,:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,37))
  call loop_VV_S(G0(:,:,:,1),wf(:,116),G0(:,:,:,18))
  call check_last_SV_V(l_switch,G0(:,:,:,18),wf(:,2),G0tensor(:,10))
  call check_last_SV_V(l_switch,G0(:,:,:,18),wf(:,2),G0tensor(:,11))
  call loop_VV_S(G0(:,:,:,1),wf(:,116),G0(:,:,:,19))
  call check_last_SV_V(l_switch,G0(:,:,:,19),wf(:,2),G0tensor(:,12))
  call loop_QW_A(G0(:,:,:,1),wf(:,117),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,53),ZERO,G1(:,:,:,48))
  call loop_QW_A(G1(:,:,:,48),wf(:,2),G1(:,:,:,49))
  call check_last_Q_A(l_switch,G1(:,:,:,49),Q(:,63),ZERO,G2tensor(:,38))
  call loop_QW_A(G0(:,:,:,1),wf(:,117),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,53),ML,G1(:,:,:,50))
  call loop_QW_A(G1(:,:,:,50),wf(:,2),G1(:,:,:,51))
  call check_last_Q_A(l_switch,G1(:,:,:,51),Q(:,63),ZERO,G2tensor(:,39))
  call loop_QW_A(G0(:,:,:,1),wf(:,117),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,53),MB,G1(:,:,:,52))
  call loop_QW_A(G1(:,:,:,52),wf(:,2),G1(:,:,:,53))
  call check_last_Q_A(l_switch,G1(:,:,:,53),Q(:,63),MT,G2tensor(:,40))
  call loop_QW_A(G0(:,:,:,1),wf(:,118),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,53),ZERO,G1(:,:,:,54))
  call loop_QW_A(G1(:,:,:,54),wf(:,2),G1(:,:,:,55))
  call check_last_Q_A(l_switch,G1(:,:,:,55),Q(:,63),ZERO,G2tensor(:,41))
  call loop_QW_A(G0(:,:,:,1),wf(:,118),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,53),ML,G1(:,:,:,56))
  call loop_QW_A(G1(:,:,:,56),wf(:,2),G1(:,:,:,57))
  call check_last_Q_A(l_switch,G1(:,:,:,57),Q(:,63),ZERO,G2tensor(:,42))
  call loop_QW_A(G0(:,:,:,1),wf(:,118),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,53),MB,G1(:,:,:,58))
  call loop_QW_A(G1(:,:,:,58),wf(:,2),G1(:,:,:,59))
  call check_last_Q_A(l_switch,G1(:,:,:,59),Q(:,63),MT,G2tensor(:,43))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,117),Q(:,53),G1(:,:,:,60))
  call check_last_SV_T(l_switch,G1(:,:,:,60),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,44))
  call check_last_SV_T(l_switch,G1(:,:,:,60),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,45))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,118),Q(:,53),G1(:,:,:,61))
  call check_last_SV_T(l_switch,G1(:,:,:,61),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,46))
  call check_last_SV_T(l_switch,G1(:,:,:,61),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,47))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,117),Q(:,53),G1(:,:,:,62))
  call check_last_CV_D(l_switch,G1(:,:,:,62),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,48))
  call check_last_CV_D(l_switch,G1(:,:,:,62),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,49))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,117),G1(:,:,:,63))
  call check_last_DV_C(l_switch,G1(:,:,:,63),Q(:,53),wf(:,2),G2tensor(:,50))
  call check_last_DV_C(l_switch,G1(:,:,:,63),Q(:,53),wf(:,2),G2tensor(:,51))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,118),Q(:,53),G1(:,:,:,64))
  call check_last_CV_D(l_switch,G1(:,:,:,64),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,52))
  call check_last_CV_D(l_switch,G1(:,:,:,64),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,53))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,118),G1(:,:,:,65))
  call check_last_DV_C(l_switch,G1(:,:,:,65),Q(:,53),wf(:,2),G2tensor(:,54))
  call check_last_DV_C(l_switch,G1(:,:,:,65),Q(:,53),wf(:,2),G2tensor(:,55))
  call loop_VV_S(G0(:,:,:,1),wf(:,117),G0(:,:,:,26))
  call check_last_SV_V(l_switch,G0(:,:,:,26),wf(:,2),G0tensor(:,13))
  call loop_SV_V(G0(:,:,:,1),wf(:,117),G0(:,:,:,27))
  call check_last_VV_S(l_switch,G0(:,:,:,27),wf(:,2),G0tensor(:,14))
  call loop_SV_V(G0(:,:,:,1),wf(:,117),G0(:,:,:,28))
  call check_last_VV_S(l_switch,G0(:,:,:,28),wf(:,2),G0tensor(:,15))
  call loop_VV_S(G0(:,:,:,1),wf(:,118),G0(:,:,:,29))
  call check_last_SV_V(l_switch,G0(:,:,:,29),wf(:,2),G0tensor(:,16))
  call loop_SV_V(G0(:,:,:,1),wf(:,118),G0(:,:,:,30))
  call check_last_VV_S(l_switch,G0(:,:,:,30),wf(:,2),G0tensor(:,17))
  call loop_SV_V(G0(:,:,:,1),wf(:,118),G0(:,:,:,31))
  call check_last_VV_S(l_switch,G0(:,:,:,31),wf(:,2),G0tensor(:,18))
  call loop_QA_Z(G0(:,:,:,1),wf(:,22),G0(:,:,:,32),gZn)
  call loop_ZQ_A(G0(:,:,:,32),wf(:,59),G0(:,:,:,33),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,33),Q(:,63),ZERO,G1tensor(:,5))
  call loop_QA_W(G0(:,:,:,1),wf(:,22),G0(:,:,:,34))
  call loop_WQ_A(G0(:,:,:,34),wf(:,59),G0(:,:,:,35))
  call check_last_Q_A(l_switch,G0(:,:,:,35),Q(:,63),ZERO,G1tensor(:,6))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(22)*M(1))) * den(130)
  T2sum(1:15,111) = T2sum(1:15,111) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(22)*M(1))) * den(130)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(48)*M(1))) * den(130)
  T2sum(1:15,130) = T2sum(1:15,130) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(28)*M(1))) * den(130)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(48)*M(1))) * den(130)
  T2sum(1:15,130) = T2sum(1:15,130) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(28)*M(1))) * den(130)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(28)*M(1)) * den(130)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(51)*M(1))) * den(130)
  T2sum(1:1,113) = T2sum(1:1,113) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(2)*M(1))) * den(130)
  T1sum(1:1,10) = T1sum(1:1,10) + Gcoeff * G0tensor(:,2)
  Gcoeff = (-(c(34)*M(1))) * den(130)
  T2sum(1:1,111) = T2sum(1:1,111) + Gcoeff * G0tensor(:,3)
  Gcoeff = (c(82)*M(1)) * den(131)
  T2sum(1:15,131) = T2sum(1:15,131) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(77)*M(1)) * den(131)
  T2sum(1:15,128) = T2sum(1:15,128) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(83)*M(1)) * den(131)
  T2sum(1:15,131) = T2sum(1:15,131) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(78)*M(1)) * den(131)
  T2sum(1:15,129) = T2sum(1:15,129) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(84)*M(1))) * den(132)
  T2sum(1:15,131) = T2sum(1:15,131) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(80)*M(1))) * den(132)
  T2sum(1:15,128) = T2sum(1:15,128) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(85)*M(1))) * den(132)
  T2sum(1:15,131) = T2sum(1:15,131) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(81)*M(1))) * den(132)
  T2sum(1:15,129) = T2sum(1:15,129) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(20)*M(1)) * den(131)
  T2sum(1:15,111) = T2sum(1:15,111) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(20)*M(1)) * den(131)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(22)*M(1))) * den(132)
  T2sum(1:15,111) = T2sum(1:15,111) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(22)*M(1))) * den(132)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(47)*M(1)) * den(131)
  T2sum(1:15,130) = T2sum(1:15,130) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(27)*M(1)) * den(131)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(47)*M(1)) * den(131)
  T2sum(1:15,130) = T2sum(1:15,130) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(27)*M(1)) * den(131)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(48)*M(1))) * den(132)
  T2sum(1:15,130) = T2sum(1:15,130) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(28)*M(1))) * den(132)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(48)*M(1))) * den(132)
  T2sum(1:15,130) = T2sum(1:15,130) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(28)*M(1))) * den(132)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(27)*M(1))) * den(131)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(28)*M(1)) * den(132)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(50)*M(1)) * den(131)
  T2sum(1:1,113) = T2sum(1:1,113) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(1)*M(1)) * den(131)
  T1sum(1:1,10) = T1sum(1:1,10) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(33)*M(1)) * den(131)
  T2sum(1:1,111) = T2sum(1:1,111) + Gcoeff * G0tensor(:,6)
  Gcoeff = (-(c(51)*M(1))) * den(132)
  T2sum(1:1,113) = T2sum(1:1,113) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(2)*M(1))) * den(132)
  T1sum(1:1,10) = T1sum(1:1,10) + Gcoeff * G0tensor(:,8)
  Gcoeff = (-(c(34)*M(1))) * den(132)
  T2sum(1:1,111) = T2sum(1:1,111) + Gcoeff * G0tensor(:,9)
  Gcoeff = (-(c(47)*M(1))) * den(89)
  T1sum(1:5,20) = T1sum(1:5,20) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(23)*M(1))) * den(89)
  T1sum(1:5,21) = T1sum(1:5,21) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(48)*M(1)) * den(90)
  T1sum(1:5,20) = T1sum(1:5,20) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(24)*M(1)) * den(90)
  T1sum(1:5,21) = T1sum(1:5,21) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(84)*M(1))) * den(137)
  T2sum(1:15,127) = T2sum(1:15,127) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(80)*M(1))) * den(137)
  T2sum(1:15,123) = T2sum(1:15,123) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(85)*M(1))) * den(137)
  T2sum(1:15,127) = T2sum(1:15,127) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(81)*M(1))) * den(137)
  T2sum(1:15,124) = T2sum(1:15,124) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(22)*M(1))) * den(137)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(22)*M(1))) * den(137)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(48)*M(1))) * den(137)
  T2sum(1:15,125) = T2sum(1:15,125) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(28)*M(1))) * den(137)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(48)*M(1))) * den(137)
  T2sum(1:15,125) = T2sum(1:15,125) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(28)*M(1))) * den(137)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(28)*M(1)) * den(137)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(51)*M(1))) * den(137)
  T2sum(1:1,116) = T2sum(1:1,116) + Gcoeff * G0tensor(:,10)
  Gcoeff = (-(c(2)*M(1))) * den(137)
  T2sum(1:1,126) = T2sum(1:1,126) + Gcoeff * G0tensor(:,11)
  Gcoeff = (-(c(34)*M(1))) * den(137)
  T2sum(1:1,114) = T2sum(1:1,114) + Gcoeff * G0tensor(:,12)
  Gcoeff = (c(82)*M(1)) * den(140)
  T2sum(1:15,127) = T2sum(1:15,127) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(77)*M(1)) * den(140)
  T2sum(1:15,133) = T2sum(1:15,133) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(83)*M(1)) * den(140)
  T2sum(1:15,127) = T2sum(1:15,127) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(78)*M(1)) * den(140)
  T2sum(1:15,134) = T2sum(1:15,134) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(84)*M(1))) * den(141)
  T2sum(1:15,127) = T2sum(1:15,127) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(80)*M(1))) * den(141)
  T2sum(1:15,133) = T2sum(1:15,133) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(85)*M(1))) * den(141)
  T2sum(1:15,127) = T2sum(1:15,127) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(81)*M(1))) * den(141)
  T2sum(1:15,134) = T2sum(1:15,134) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(20)*M(1)) * den(140)
  T2sum(1:15,135) = T2sum(1:15,135) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(20)*M(1)) * den(140)
  T2sum(1:15,126) = T2sum(1:15,126) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(22)*M(1))) * den(141)
  T2sum(1:15,135) = T2sum(1:15,135) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(22)*M(1))) * den(141)
  T2sum(1:15,126) = T2sum(1:15,126) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(47)*M(1)) * den(140)
  T2sum(1:15,116) = T2sum(1:15,116) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(27)*M(1)) * den(140)
  T2sum(1:15,126) = T2sum(1:15,126) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(47)*M(1)) * den(140)
  T2sum(1:15,116) = T2sum(1:15,116) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(27)*M(1)) * den(140)
  T2sum(1:15,126) = T2sum(1:15,126) + Gcoeff * G2tensor(:,51)
  Gcoeff = (-(c(48)*M(1))) * den(141)
  T2sum(1:15,116) = T2sum(1:15,116) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(28)*M(1))) * den(141)
  T2sum(1:15,126) = T2sum(1:15,126) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(48)*M(1))) * den(141)
  T2sum(1:15,116) = T2sum(1:15,116) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(28)*M(1))) * den(141)
  T2sum(1:15,126) = T2sum(1:15,126) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(50)*M(1)) * den(140)
  T2sum(1:1,116) = T2sum(1:1,116) + Gcoeff * G0tensor(:,13)
  Gcoeff = (c(1)*M(1)) * den(140)
  T2sum(1:1,115) = T2sum(1:1,115) + Gcoeff * G0tensor(:,14)
  Gcoeff = (c(33)*M(1)) * den(140)
  T2sum(1:1,135) = T2sum(1:1,135) + Gcoeff * G0tensor(:,15)
  Gcoeff = (-(c(51)*M(1))) * den(141)
  T2sum(1:1,116) = T2sum(1:1,116) + Gcoeff * G0tensor(:,16)
  Gcoeff = (-(c(2)*M(1))) * den(141)
  T2sum(1:1,115) = T2sum(1:1,115) + Gcoeff * G0tensor(:,17)
  Gcoeff = (-(c(34)*M(1))) * den(141)
  T2sum(1:1,135) = T2sum(1:1,135) + Gcoeff * G0tensor(:,18)
  Gcoeff = (c(48)*M(1)) * den(91)
  T1sum(1:5,22) = T1sum(1:5,22) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(24)*M(1)) * den(91)
  T1sum(1:5,23) = T1sum(1:5,23) + Gcoeff * G1tensor(:,6)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_3

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_3_ppllll_ew_nexnmemxuux_2_/**/REALKIND
