
module ol_vamp_1_ppllll_ew_nmnmxeexaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_ew_nmnmxeexaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_ew_nmnmxeexaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_ew_nmnmxeexaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_ew_nmnmxeexaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllll_ew_nmnmxeexaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_nmnmxeexaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,8,4,1,2,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(3),m3h2x32(:,4),heltab2x64(:,:,4))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,4,8,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(4),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,1,2,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G0H32(3),32,0,G1H32(5),n2h32(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,2,1,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(6),n2h32(4))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,8,2,1,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,9),heltab2x64(:,:,9))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,8,2,1,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,16,4,8],[nMW,0,nMW,nMW,0,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,1,2,8,4,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,1,2,8,4,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(9),m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,1,2,16,8,4],[nMW,0,nMW,nMW,0,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(10),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,2,8,4,1,16],[0,nMW,0,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(11),n2h32(5))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,2,16,1,4,8],[nMW,0,0,nMW,0,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(12),m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,1,4,8,2,16],[0,nMW,0,nMW,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(13),n2h32(6))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,1,4,8,16,2],[0,nMW,0,nMW,nMW,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(14),n2h32(7))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,16,2,8,4],[nMW,0,0,nMW,0,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(15),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,16,4,8,2],[0,nMW,nMW,0,nMW,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(16),n2h32(8))
  call Hloop_QA_Z(ntryL,G1H32(1),ex4(:),G1H16(1),ngZl,m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H32(2),ex3(:),G1H16(2),ngZl,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_WA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(3),n2h16(1))
  call Hloop_WA_Q(ntryL,G1H32(3),ex4(:),G1H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(4),40,0,G2H16(1),n2h16(2))
  call Hloop_WA_Q(ntryL,G0H32(2),ex2(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(4),n2h16(3))
  call Hloop_WA_Q(ntryL,G1H32(4),ex2(:),G1H16(5),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(5),34,0,G2H16(2),n2h16(4))
  call Hloop_QA_Z(ntryL,G1H32(5),ex4(:),G1H16(5),ngZl,m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H32(6),ex3(:),G1H16(6),ngZl,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_WQ_A(ntryL,G0H32(3),ex3(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(7),n2h16(5))
  call Hloop_WQ_A(ntryL,G1H32(7),ex3(:),G1H16(8),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(8),36,0,G2H16(3),n2h16(6))
  call Hloop_WA_Q(ntryL,G1H32(8),ex2(:),G1H16(8),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(8),34,0,G2H16(4),n2h16(7))
  call Hloop_WQ_A(ntryL,G0H32(4),ex1(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(8),n2h16(8))
  call Hloop_WQ_A(ntryL,G1H32(9),ex1(:),G1H16(9),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(9),33,0,G2H16(5),n2h16(9))
  call Hloop_WQ_A(ntryL,G1H32(10),ex1(:),G1H16(9),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(9),33,0,G2H16(6),n2h16(10))
  call Hloop_QA_W(ntryL,G1H32(11),ex2(:),G1H16(9),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_WA_Q(ntryL,G1H32(12),ex2(:),G1H16(10),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(10),34,0,G2H16(7),n2h16(11))
  call Hloop_AQ_W(ntryL,G1H32(13),ex1(:),G1H16(10),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_AQ_W(ntryL,G1H32(14),ex1(:),G1H16(11),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_WQ_A(ntryL,G1H32(15),ex1(:),G1H16(12),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(12),33,0,G2H16(8),n2h16(12))
  call Hloop_AQ_W(ntryL,G1H32(16),ex1(:),G1H16(12),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_ZA_Q(ntryL,G1H16(1),ex2(:),G1H8(1),ngZn,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(1),n2h8(1))
  call Hloop_ZQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),ngZn,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(2),n2h8(2))
  call Hloop_AQ_W(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_W(ntryL,G2H16(1),ex3(:),G2H8(3),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_W(ntryL,G1H16(4),ex1(:),G1H8(2),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_W(ntryL,G2H16(2),ex1(:),G2H8(4),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_ZQ_A(ntryL,G1H16(5),ex1(:),G1H8(3),ngZn,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(3),41,0,G2H8(5),n2h8(3))
  call Hloop_ZA_Q(ntryL,G1H16(6),ex2(:),G1H8(3),ngZn,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(6),n2h8(4))
  call Hloop_QA_W(ntryL,G1H16(7),ex4(:),G1H8(3),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_QA_W(ntryL,G2H16(3),ex4(:),G2H8(7),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_W(ntryL,G2H16(4),ex1(:),G2H8(8),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_QA_W(ntryL,G1H16(8),ex2(:),G1H8(4),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_QA_W(ntryL,G2H16(5),ex2(:),G2H8(9),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_QA_W(ntryL,G2H16(6),ex2(:),G2H8(10),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_WA_Q(ntryL,G1H16(9),ex4(:),G1H8(5),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(5),42,0,G2H8(11),n2h8(5))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),8,16)
  call Hloop_WQ_A(ntryL,G1H16(10),ex3(:),G1H8(5),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(12),n2h8(6))
  call Hloop_WQ_A(ntryL,G1H16(11),ex3(:),G1H8(5),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(13),n2h8(7))
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(2),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(13),16)
  call HG1shiftOLR(G1H16(8),4,16)
  call Hloop_UW_V(ntryL,G1H16(12),33,ex5(:),16,G2H8(14),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AV_Q(ntryL,G1H16(1),ex5(:),G1H8(5),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(5),50,0,G2H8(15),n2h8(8))
call HGT_raise_alpha_OLR(G1H16(2),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_WA_Q(ntryL,G1H16(2),ex4(:),G1H8(5),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AV_Q(ntryL,G1H16(4),ex5(:),G1H8(6),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(6),50,0,G2H8(16),n2h8(9))
  call Hloop_AV_Q(ntryL,G1H16(5),ex5(:),G1H8(6),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(6),50,0,G2H8(17),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H16(6),ex5(:),G1H8(6),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(6),50,0,G2H8(18),n2h8(11))
  call Hloop_QV_A(ntryL,G1H16(7),ex5(:),G1H8(6),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(6),49,0,G2H8(19),n2h8(12))
call HGT_raise_alpha_OLR(G1H16(8),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_WQ_A(ntryL,G1H16(8),ex3(:),G1H8(6),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_QV_A(ntryL,G1H16(10),ex5(:),G1H8(7),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(20),n2h8(13))
  call Hloop_QV_A(ntryL,G1H16(11),ex5(:),G1H8(7),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(21),n2h8(14))
  call Hloop_QV_A(ntryL,G1H16(13),ex5(:),G1H8(7),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(22),n2h8(15))
  call Hloop_AQ_Z(ntryL,G2H8(1),ex1(:),G2H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_Z(ntryL,G2H8(2),ex2(:),G2H4(2),ngZn,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_WQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(3),n2h4(1))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(3),mass5set(:,2),  & 
G1H8(7),G1H8(1),G1H8(8),G1H8(9),G1H8(10),G1H8(11),8)
  call HG1shiftOLR(G1H8(1),16,8)
  call Hloop_WQ_A(ntryL,G1H8(2),ex3(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(4),n2h4(2))
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(4),mass5set(:,2),  & 
G1H8(2),G1H8(12),G1H8(13),G1H8(14),G1H8(15),G1H8(16),8)
  call HG1shiftOLR(G1H8(12),16,8)
  call Hloop_QA_Z(ntryL,G2H8(5),ex2(:),G2H4(5),ngZn,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_Z(ntryL,G2H8(6),ex1(:),G2H4(6),ngZn,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(7),n2h4(3))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(5),mass5set(:,2),  & 
G1H8(3),G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(21),8)
  call HG1shiftOLR(G1H8(17),16,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(6),mass5set(:,3),  & 
G1H8(22),G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),8)
  call HG1shiftOLR(G1H8(23),8,8)
  call Hloop_WA_Q(ntryL,G1H8(4),ex4(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(8),n2h4(4))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(7),mass5set(:,2),  & 
G1H8(4),G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(28),16,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(8),mass5set(:,3),  & 
G1H8(33),G1H8(34),G1H8(35),G1H8(36),G1H8(37),G1H8(38),8)
  call HG1shiftOLR(G1H8(34),4,8)
  call Hloop_AQ_W(ntryL,G2H8(11),ex3(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_W(ntryL,G2H8(12),ex4(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_W(ntryL,G2H8(13),ex4(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(9),mass5set(:,4),  & 
G1H8(39),G1H8(40),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(40),2,8)
  call Hloop_AQ_W(ntryL,G2H8(15),ex1(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_W(ntryL,G2H8(17),ex1(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_W(ntryL,G2H8(18),ex1(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_W(ntryL,G2H8(19),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_QA_W(ntryL,G2H8(21),ex2(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_QA_W(ntryL,G2H8(22),ex2(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_WQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(18),n2h4(5))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(1),-16,ex5(:),16,G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_WQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(20),n2h4(6))
  call Hloop_WQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(21),n2h4(7))
  call Hloop_WQ_A(ntryL,G1H8(2),ex3(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(22),n2h4(8))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(12),-16,ex5(:),16,G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_WQ_A(ntryL,G1H8(15),ex3(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(24),n2h4(9))
  call Hloop_WQ_A(ntryL,G1H8(16),ex3(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(25),n2h4(10))
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(26),n2h4(11))
call HGT_raise_alpha_OLR(G1H8(17),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(17),-16,ex5(:),16,G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_WA_Q(ntryL,G1H8(20),ex2(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(28),n2h4(12))
  call Hloop_WA_Q(ntryL,G1H8(21),ex2(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(29),n2h4(13))
  call Hloop_UW_V(ntryL,G1H8(22),35,ex5(:),16,G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
call HGT_raise_alpha_OLR(G1H8(23),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(23),ex4(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_UW_V(ntryL,G1H8(26),35,ex5(:),16,G2H4(31),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_UW_V(ntryL,G1H8(27),35,ex5(:),16,G2H4(32),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_WA_Q(ntryL,G1H8(4),ex4(:),G1H4(2),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(2),43,0,G2H4(33),n2h4(14))
call HGT_raise_alpha_OLR(G1H8(28),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(28),-16,ex5(:),16,G2H4(34),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_WA_Q(ntryL,G1H8(31),ex4(:),G1H4(2),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(2),43,0,G2H4(35),n2h4(15))
  call Hloop_WA_Q(ntryL,G1H8(32),ex4(:),G1H4(2),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(2),43,0,G2H4(36),n2h4(16))
  call Hloop_UV_W(ntryL,G1H8(33),35,ex5(:),16,G2H4(37),m3h2x4(:,38),heltab2x8(:,:,38))
call HGT_raise_alpha_OLR(G1H8(34),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(34),ex3(:),G1H4(2),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_UV_W(ntryL,G1H8(37),35,ex5(:),16,G2H4(38),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_UV_W(ntryL,G1H8(38),35,ex5(:),16,G2H4(39),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_WQ_A(ntryL,G1H8(39),ex3(:),G1H4(3),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(40),n2h4(17))
call HGT_OLR(G1H8(40),1,1,8)
call HGT_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(40),-2,0,G2H8(1),n2h8(22))
  call Hloop_QA_W(ntryL,G2H8(1),ex2(:),G2H4(41),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_WQ_A(ntryL,G1H8(43),ex3(:),G1H4(3),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(42),n2h4(18))
  call Hloop_WQ_A(ntryL,G1H8(44),ex3(:),G1H4(3),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(3),53,0,G2H4(43),n2h4(19))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(10),mass5set(:,5),  & 
G1H4(3),G1H4(4),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(4),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(11),mass5set(:,5),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(10),16,4)
  call Hloop_QA_W(ntryL,G2H4(3),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_W(ntryL,G2H4(4),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(12),mass5set(:,5),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(13),mass5set(:,5),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),16,4)
  call Hloop_AQ_W(ntryL,G2H4(7),ex1(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_W(ntryL,G2H4(8),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(14),mass5set(:,6),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),16,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(15),mass5set(:,6),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),16,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(15),mass5set(:,6),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),2,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(1),mass5set(:,1),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(46),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(16),mass5set(:,7),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(52),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(2),mass5set(:,1),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),4,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(17),mass5set(:,7),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(64),4,4)
  call Hloop_QA_W(ntryL,G2H4(18),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_W(ntryL,G2H4(21),ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_W(ntryL,G2H4(22),ex4(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_W(ntryL,G2H4(25),ex4(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_W(ntryL,G2H4(26),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_W(ntryL,G2H4(29),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(6),mass5set(:,3),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(70),8,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(18),mass5set(:,2),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(76),8,4)
  call Hloop_AQ_W(ntryL,G2H4(33),ex3(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_W(ntryL,G2H4(36),ex3(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(8),mass5set(:,3),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),4,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(19),mass5set(:,2),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),4,4)
  call Hloop_QA_W(ntryL,G2H4(40),ex4(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_W(ntryL,G2H4(43),ex4(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(86)])
  call Hloop_ZQ_A(ntryL,G1H4(3),ex3(:),G1H2(1),ngZl,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(15),n2h2(1))
call HGT_OLR(G1H4(4),1,1,4)
call HGT_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(4),-16,0,G2H4(1),n2h4(20))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_ZQ_A(ntryL,G1H4(8),ex3(:),G1H2(1),ngZl,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(17),n2h2(2))
  call Hloop_ZA_Q(ntryL,G1H4(9),ex4(:),G1H2(1),ngZl,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(18),n2h2(3))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(10),-16,0,G2H4(2),n2h4(21))
  call Hloop_QV_A(ntryL,G2H4(2),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_ZA_Q(ntryL,G1H4(14),ex4(:),G1H2(1),ngZl,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(20),n2h2(4))
  call Hloop_ZQ_A(ntryL,G1H4(15),ex3(:),G1H2(1),ngZl,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(21),n2h2(5))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(16),-16,0,G2H4(3),n2h4(22))
  call Hloop_AV_Q(ntryL,G2H4(3),ex5(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_ZQ_A(ntryL,G1H4(20),ex3(:),G1H2(1),ngZl,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(23),n2h2(6))
  call Hloop_ZA_Q(ntryL,G1H4(21),ex4(:),G1H2(1),ngZl,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(24),n2h2(7))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(22),-16,0,G2H4(4),n2h4(23))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_ZA_Q(ntryL,G1H4(26),ex4(:),G1H2(1),ngZl,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(26),n2h2(8))
  call Hloop_WQ_A(ntryL,G1H4(27),ex1(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(27),n2h2(9))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(28),-16,0,G2H4(5),n2h4(24))
  call Hloop_AV_Q(ntryL,G2H4(5),ex5(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_WQ_A(ntryL,G1H4(32),ex1(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(29),n2h2(10))
  call Hloop_WA_Q(ntryL,G1H4(33),ex2(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(30),n2h2(11))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(34),-16,0,G2H4(6),n2h4(25))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_WA_Q(ntryL,G1H4(38),ex2(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(32),n2h2(12))
  call Hloop_UW_V(ntryL,G1H4(39),45,ex5(:),16,G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(40),-2,0,G2H4(7),n2h4(26))
  call Hloop_QA_W(ntryL,G2H4(7),ex2(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_UW_V(ntryL,G1H4(44),45,ex5(:),16,G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_WQ_A(ntryL,G1H4(45),ex3(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(36),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(46),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(46),ex4(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_WQ_A(ntryL,G1H4(51),ex3(:),G1H2(2),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(2),55,0,G2H2(37),n2h2(14))
call HGT_raise_alpha_OLR(G1H4(52),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(52),ex4(:),G1H2(2),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_WQ_A(ntryL,G1H4(56),ex3(:),G1H2(3),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(38),n2h2(15))
  call Hloop_WA_Q(ntryL,G1H4(57),ex4(:),G1H2(3),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(39),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(58),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(58),ex3(:),G1H2(3),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_WA_Q(ntryL,G1H4(63),ex4(:),G1H2(4),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(4),59,0,G2H2(40),n2h2(17))
call HGT_raise_alpha_OLR(G1H4(64),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(64),ex3(:),G1H2(4),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_WA_Q(ntryL,G1H4(68),ex4(:),G1H2(5),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(5),59,0,G2H2(41),n2h2(18))
  call Hloop_WQ_A(ntryL,G1H4(69),ex3(:),G1H2(5),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(42),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(70),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(70),ex4(:),G1H2(5),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_WQ_A(ntryL,G1H4(75),ex3(:),G1H2(6),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(43),n2h2(20))
call HGT_raise_alpha_OLR(G1H4(76),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(76),ex4(:),G1H2(6),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_WQ_A(ntryL,G1H4(80),ex3(:),G1H2(7),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(7),55,0,G2H2(44),n2h2(21))
  call Hloop_WA_Q(ntryL,G1H4(81),ex4(:),G1H2(7),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(7),59,0,G2H2(45),n2h2(22))
call HGT_raise_alpha_OLR(G1H4(82),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(82),ex3(:),G1H2(7),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_WA_Q(ntryL,G1H4(87),ex4(:),G1H2(8),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(8),59,0,G2H2(46),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(88),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(88),ex3(:),G1H2(8),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_WA_Q(ntryL,G1H4(92),ex4(:),G1H2(9),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(9),59,0,G2H2(47),n2h2(24))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(4),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(3),mass5set(:,2),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(10),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(4),mass5set(:,2),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(16),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(5),mass5set(:,2),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(7),mass5set(:,2),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(9),mass5set(:,4),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),2,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(10),mass5set(:,5),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(11),mass5set(:,5),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(12),mass5set(:,5),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(13),mass5set(:,5),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(14),mass5set(:,6),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),16,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(15),mass5set(:,6),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),16,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(15),mass5set(:,6),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),2,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(39),ex3(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(42),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(45),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(9),47,ex5(:),16,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(10),0,ex5(:),16,G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(15),47,ex5(:),16,G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(16),0,ex5(:),16,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(21),47,ex5(:),16,G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(22),0,ex5(:),16,G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(27),47,ex5(:),16,G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(28),0,ex5(:),16,G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hloop_WA_Q(ntryL,G1H2(33),ex2(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(34),ex2(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(18),n2h1(6))
  call Hloop_QV_A(ntryL,G1H2(39),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(7))
  call Hloop_QV_A(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(20),n2h1(8))
  call Hloop_AV_Q(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(9))
  call Hloop_AV_Q(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(10))
  call Hloop_QV_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(11))
  call Hloop_QV_A(ntryL,G1H2(52),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(12))
  call Hloop_AV_Q(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(58),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(14))
  call Hloop_QV_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(15))
  call Hloop_QV_A(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(70),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(18))
  call Hloop_WA_Q(ntryL,G1H2(75),ex2(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(19))
  call Hloop_WA_Q(ntryL,G1H2(76),ex2(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(32),n2h1(20))
  call ol_merge_tensors(G2tensor(9),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(4)])
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,2),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(4),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(7),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(2),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(6),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(8),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(9),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),2)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(10),mass5set(:,5),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(11),mass5set(:,5),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(12),mass5set(:,5),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(13),mass5set(:,5),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(14),mass5set(:,6),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(15),mass5set(:,6),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(15),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[48,2,1,4,8],[nMW,0,nMW,0,nMW],6,0)
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(1),m4h2x2x16(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[48,1,2,8,4],[nMW,0,nMW,0,nMW],6,0)
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(2),m4h2x2x16(:,2),heltab3x64(:,:,2))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(1),n2h32(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,3,16,4,8],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(10))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(3),m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,3,16,4,8],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(4),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G0H32(4),32,0,G1H32(5),n2h32(11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,3,8,4,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(6),n2h32(12))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,3,8,4,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(9),n2h32(13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,3,16,8,4],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(10),n2h32(14))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,3,16,8,4],[nMW,nMW,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(12),m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(13),n2h32(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,4,8,3,16],[0,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(14),n2h32(16))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(15),m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,4,8,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(16),m3h2x32(:,44),heltab2x64(:,:,44))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,3,4,8,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,47),heltab2x64(:,:,47))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,48),heltab2x64(:,:,48))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,49),heltab2x64(:,:,49))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,3,4,8,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G0H32(11),32,0,G1H32(21),n2h32(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,8,4,3,16],[0,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G0H32(11),32,0,G1H32(22),n2h32(20))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,53),heltab2x64(:,:,53))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(23),m3h2x32(:,55),heltab2x64(:,:,55))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,8,4,3,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,56),heltab2x64(:,:,56))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,8,3,4,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,57),heltab2x64(:,:,57))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,8,3,4,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(25),m3h2x32(:,58),heltab2x64(:,:,58))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,4,3,8,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,4,3,8,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,2,1,16,12],[0,nMW,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G0H32(15),32,0,G1H32(27),n2h32(21))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,2,1,16,12],[0,nMW,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H32(15),32,0,G1H32(28),n2h32(22))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(29),m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(30),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,67),heltab2x64(:,:,67))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,68),heltab2x64(:,:,68))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(31),m3h2x32(:,69),heltab2x64(:,:,69))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,70),heltab2x64(:,:,70))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,12,2,1,16],[0,0,nMW,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,71),heltab2x64(:,:,71))
  call Hloop_Q_A(ntryL,G0H32(19),32,0,G1H32(33),n2h32(23))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,12,2,1,16],[0,0,nMW,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,72),heltab2x64(:,:,72))
  call Hloop_Q_A(ntryL,G0H32(19),32,0,G1H32(34),n2h32(24))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(35),m3h2x32(:,73),heltab2x64(:,:,73))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(36),m3h2x32(:,74),heltab2x64(:,:,74))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,75),heltab2x64(:,:,75))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,76),heltab2x64(:,:,76))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,77),heltab2x64(:,:,77))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,78),heltab2x64(:,:,78))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(37),m3h2x32(:,79),heltab2x64(:,:,79))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,80),heltab2x64(:,:,80))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,1,2,16,12],[0,nMW,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,81),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(39),n2h32(25))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,1,2,16,12],[0,nMW,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,82),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(40),n2h32(26))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,83),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,84),heltab2x64(:,:,84))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(41),m3h2x32(:,85),heltab2x64(:,:,85))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(42),m3h2x32(:,86),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,87),heltab2x64(:,:,87))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,88),heltab2x64(:,:,88))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(43),m3h2x32(:,89),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(44),m3h2x32(:,90),heltab2x64(:,:,90))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,1,2,12,16],[0,nMW,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G0H32(27),32,0,G1H32(45),n2h32(27))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,1,2,12,16],[0,nMW,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,92),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G0H32(27),32,0,G1H32(46),n2h32(28))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,93),heltab2x64(:,:,93))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,94),heltab2x64(:,:,94))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,95),heltab2x64(:,:,95))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,96),heltab2x64(:,:,96))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(47),m3h2x32(:,97),heltab2x64(:,:,97))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(48),m3h2x32(:,98),heltab2x64(:,:,98))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(49),m3h2x32(:,99),heltab2x64(:,:,99))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,100),heltab2x64(:,:,100))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,12,1,2,16],[0,0,nMW,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,101),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G0H32(31),32,0,G1H32(51),n2h32(29))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,12,1,2,16],[0,0,nMW,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,102),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G0H32(31),32,0,G1H32(52),n2h32(30))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(53),m3h2x32(:,103),heltab2x64(:,:,103))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,104),heltab2x64(:,:,104))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,105),heltab2x64(:,:,105))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,106),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,107),heltab2x64(:,:,107))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,108),heltab2x64(:,:,108))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(55),m3h2x32(:,109),heltab2x64(:,:,109))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(56),m3h2x32(:,110),heltab2x64(:,:,110))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,2,1,12,16],[0,nMW,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,111),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G0H32(35),32,0,G1H32(57),n2h32(31))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,2,1,12,16],[0,nMW,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_Q_A(ntryL,G0H32(35),32,0,G1H32(58),n2h32(32))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,113),heltab2x64(:,:,113))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,114),heltab2x64(:,:,114))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,115),heltab2x64(:,:,115))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,116),heltab2x64(:,:,116))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(59),m3h2x32(:,117),heltab2x64(:,:,117))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,118),heltab2x64(:,:,118))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(61),m3h2x32(:,119),heltab2x64(:,:,119))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(62),m3h2x32(:,120),heltab2x64(:,:,120))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,1,16,2,12],[0,nMW,nMW,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,121),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(63),n2h32(33))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,1,16,2,12],[0,nMW,nMW,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,122),heltab2x64(:,:,122))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(64),n2h32(34))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,123),heltab2x64(:,:,123))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,124),heltab2x64(:,:,124))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(65),m3h2x32(:,125),heltab2x64(:,:,125))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(66),m3h2x32(:,126),heltab2x64(:,:,126))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,1,16,12,2],[nMW,0,0,0,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(67),m3h2x32(:,127),heltab2x64(:,:,127))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,1,16,12,2],[nMW,0,0,0,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,128),heltab2x64(:,:,128))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,129),heltab2x64(:,:,129))
  call Hloop_A_Q(ntryL,G0H32(41),32,0,G1H32(69),n2h32(35))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,130),heltab2x64(:,:,130))
  call Hloop_A_Q(ntryL,G0H32(41),32,0,G1H32(70),n2h32(36))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,131),heltab2x64(:,:,131))
  call Hloop_A_Q(ntryL,G0H32(41),32,0,G1H32(71),n2h32(37))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,132),heltab2x64(:,:,132))
  call Hloop_A_Q(ntryL,G0H32(41),32,0,G1H32(72),n2h32(38))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,2,16,1,12],[0,nMW,nMW,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,133),heltab2x64(:,:,133))
  call Hloop_Q_A(ntryL,G0H32(41),32,0,G1H32(73),n2h32(39))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,2,16,1,12],[0,nMW,nMW,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,134),heltab2x64(:,:,134))
  call Hloop_Q_A(ntryL,G0H32(41),32,0,G1H32(74),n2h32(40))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,135),heltab2x64(:,:,135))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,136),heltab2x64(:,:,136))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(75),m3h2x32(:,137),heltab2x64(:,:,137))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(76),m3h2x32(:,138),heltab2x64(:,:,138))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,2,12,1,16],[0,nMW,nMW,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,139),heltab2x64(:,:,139))
  call Hloop_Q_A(ntryL,G0H32(43),32,0,G1H32(77),n2h32(41))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,2,12,1,16],[0,nMW,nMW,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,140),heltab2x64(:,:,140))
  call Hloop_Q_A(ntryL,G0H32(43),32,0,G1H32(78),n2h32(42))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,2,12,1,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,141),heltab2x64(:,:,141))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,2,12,1,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,142),heltab2x64(:,:,142))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,2,12,1,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(79),m3h2x32(:,143),heltab2x64(:,:,143))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,2,12,1,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(80),m3h2x32(:,144),heltab2x64(:,:,144))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,1,12,16,2],[nMW,0,0,0,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(81),m3h2x32(:,145),heltab2x64(:,:,145))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,1,12,16,2],[nMW,0,0,0,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(82),m3h2x32(:,146),heltab2x64(:,:,146))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,147),heltab2x64(:,:,147))
  call Hloop_A_Q(ntryL,G0H32(45),32,0,G1H32(83),n2h32(43))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,148),heltab2x64(:,:,148))
  call Hloop_A_Q(ntryL,G0H32(45),32,0,G1H32(84),n2h32(44))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,149),heltab2x64(:,:,149))
  call Hloop_A_Q(ntryL,G0H32(45),32,0,G1H32(85),n2h32(45))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,150),heltab2x64(:,:,150))
  call Hloop_A_Q(ntryL,G0H32(45),32,0,G1H32(86),n2h32(46))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[32,1,12,2,16],[0,nMW,nMW,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,151),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G0H32(45),32,0,G1H32(87),n2h32(47))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[32,1,12,2,16],[0,nMW,nMW,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,152),heltab2x64(:,:,152))
  call Hloop_A_Q(ntryL,G0H32(45),32,0,G1H32(88),n2h32(48))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[32,1,12,2,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,153),heltab2x64(:,:,153))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,1,12,2,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,154),heltab2x64(:,:,154))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,1,12,2,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(89),m3h2x32(:,155),heltab2x64(:,:,155))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,1,12,2,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(90),m3h2x32(:,156),heltab2x64(:,:,156))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,8,1,2,20],[0,nMZ,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,157),heltab2x64(:,:,157))
  call Hloop_Q_A(ntryL,G0H32(47),32,0,G1H32(91),n2h32(49))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,1,2,8,20],[nMW,0,nMW,0,nMW],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(92),m3h2x32(:,158),heltab2x64(:,:,158))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,8,2,1,20],[0,nMZ,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,159),heltab2x64(:,:,159))
  call Hloop_Q_A(ntryL,G0H32(47),32,0,G1H32(93),n2h32(50))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[32,2,1,20,8],[nMW,0,nMW,0,nMW],5,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(94),m3h2x32(:,160),heltab2x64(:,:,160))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,1,20,8,2],[0,nMW,0,nMW,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,161),heltab2x64(:,:,161))
  call Hloop_A_Q(ntryL,G0H32(47),32,0,G1H32(95),n2h32(51))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[32,2,1,4,24],[nMW,0,nMW,0,nMW],5,1,wf4(:,9))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(96),m3h2x32(:,162),heltab2x64(:,:,162))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,4,1,2,24],[0,nMZ,0,nMZ,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,163),heltab2x64(:,:,163))
  call Hloop_A_Q(ntryL,G0H32(47),32,0,G1H32(97),n2h32(52))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[32,1,2,24,4],[nMW,0,nMW,0,nMW],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,164),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[32,4,2,1,24],[0,nMZ,0,nMZ,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,165),heltab2x64(:,:,165))
  call Hloop_A_Q(ntryL,G0H32(47),32,0,G1H32(99),n2h32(53))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[32,1,4,24,2],[0,nMW,0,nMW,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,166),heltab2x64(:,:,166))
  call Hloop_A_Q(ntryL,G0H32(47),32,0,G1H32(100),n2h32(54))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[36,2,1,8,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,8),G0H16(3),ngZl,m3h4x16(:,1),heltab2x64(:,:,167))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[36,8,2,1,16],[0,nMW,0,nMW,nMW],5,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(4),m3h4x16(:,2),heltab2x64(:,:,168))
  call Hloop_Q_A(ntryL,G0H16(4),36,0,G1H16(12),n2h16(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[36,1,2,8,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,8),G0H16(4),ngZl,m3h4x16(:,3),heltab2x64(:,:,169))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[36,1,2,16,8],[nMW,0,nMW,nMW,0],5,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,8),G0H16(5),m3h4x16(:,4),heltab2x64(:,:,170))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[36,1,16,2,8],[nMW,0,0,nMW,0],5,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,8),G0H16(6),m3h4x16(:,5),heltab2x64(:,:,171))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[40,4,1,2,16],[0,nMW,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,6),heltab2x64(:,:,172))
  call Hloop_A_Q(ntryL,G0H16(7),40,0,G1H16(1),n2h16(16))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[40,2,1,4,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(7),ngZl,m3h4x16(:,7),heltab2x64(:,:,173))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[40,2,1,16,4],[nMW,0,nMW,nMW,0],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(8),m3h4x16(:,8),heltab2x64(:,:,174))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[40,1,2,4,16],[nMZ,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(9),ngZl,m3h4x16(:,9),heltab2x64(:,:,175))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[40,2,16,1,4],[nMW,0,0,nMW,0],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,10),heltab2x64(:,:,176))
  call Hloop_AV_Q(ntryL,G1H16(3),ex5(:),G1H8(7),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(7),50,0,G2H8(2),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(9),ex5(:),G1H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(3),n2h8(24))
  call Hloop_WA_Q(ntryL,G0H16(1),ex2(:),G0H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G0H8(1),50,0,G1H8(10),n2h8(25))
  call Hloop_WQ_A(ntryL,G0H16(2),ex1(:),G0H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G0H8(1),49,0,G1H8(11),n2h8(26))
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,1),G1H8(2),ngZl,m3h4x8(:,1),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(2),35,0,G2H8(4),n2h8(27))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,1),G1H8(12),ngZl,m3h4x8(:,2),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(12),35,0,G2H8(5),n2h8(28))
  call Hloop_SV_T(ntryL,G0H32(2),32,wf4(:,1),3,G1H8(15),m3h4x8(:,3),heltab2x32(:,:,23))
  call Hloop_VV_S(ntryL,G1H32(3),wf4(:,1),G1H8(16),m3h4x8(:,4),heltab2x32(:,:,24))
  call Hloop_SV_V(ntryL,G0H32(3),wf4(:,1),G0H8(1),m3h4x8(:,5),heltab2x32(:,:,25))
  call Hloop_UW_V(ntryL,G1H32(4),32,wf4(:,1),3,G2H8(6),m3h4x8(:,6),heltab2x32(:,:,26))
  call Hloop_QZ_A(ntryL,G1H32(5),wf4(:,1),G1H8(3),ngZl,m3h4x8(:,7),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(3),35,0,G2H8(7),n2h8(29))
  call Hloop_QZ_A(ntryL,G1H32(6),wf4(:,1),G1H8(17),ngZl,m3h4x8(:,8),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(17),35,0,G2H8(8),n2h8(30))
  call Hloop_SV_V(ntryL,G1H32(7),wf4(:,1),G1H8(20),m3h4x8(:,9),heltab2x32(:,:,29))
  call Hloop_UV_W(ntryL,G0H32(1),32,wf4(:,1),3,G1H8(21),m3h4x8(:,10),heltab2x32(:,:,30))
  call Hloop_SV_V(ntryL,G0H32(4),wf4(:,1),G0H8(2),m3h4x8(:,11),heltab2x32(:,:,31))
  call Hloop_UV_W(ntryL,G1H32(8),32,wf4(:,1),3,G2H8(9),m3h4x8(:,12),heltab2x32(:,:,32))
  call Hloop_QZ_A(ntryL,G1H32(9),wf4(:,1),G1H8(22),ngZl,m3h4x8(:,13),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(22),35,0,G2H8(10),n2h8(31))
  call Hloop_QZ_A(ntryL,G1H32(10),wf4(:,1),G1H8(23),ngZl,m3h4x8(:,14),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(23),35,0,G2H8(11),n2h8(32))
  call Hloop_TV_S(ntryL,G0H32(5),32,wf4(:,1),3,G1H8(26),m3h4x8(:,15),heltab2x32(:,:,35))
  call Hloop_VV_S(ntryL,G1H32(11),wf4(:,1),G1H8(27),m3h4x8(:,16),heltab2x32(:,:,36))
  call Hloop_SV_V(ntryL,G0H32(6),wf4(:,1),G0H8(3),m3h4x8(:,17),heltab2x32(:,:,37))
  call Hloop_UV_W(ntryL,G1H32(12),32,wf4(:,1),3,G2H8(12),m3h4x8(:,18),heltab2x32(:,:,38))
  call Hloop_AQ_V(ntryL,G1H32(13),ex3(:),G1H16(2),m3h2x16(:,21),heltab2x32(:,:,39))
  call Hloop_AQ_Z(ntryL,G1H32(14),ex3(:),G1H16(4),ngZl,m3h2x16(:,22),heltab2x32(:,:,40))
  call Hloop_WQ_A(ntryL,G0H32(7),ex3(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(5),n2h16(17))
  call Hloop_WQ_A(ntryL,G0H32(8),ex3(:),G0H16(2),m3h2x16(:,24),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G0H16(2),36,0,G1H16(6),n2h16(18))
  call Hloop_WQ_A(ntryL,G1H32(15),ex3(:),G1H16(7),m3h2x16(:,25),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(7),36,0,G2H16(1),n2h16(19))
  call Hloop_WQ_A(ntryL,G1H32(16),ex3(:),G1H16(8),m3h2x16(:,26),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H16(8),36,0,G2H16(2),n2h16(20))
  call Hloop_AZ_Q(ntryL,G1H32(17),wf4(:,1),G1H8(4),ngZl,m3h4x8(:,19),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(4),35,0,G2H8(13),n2h8(33))
  call Hloop_AZ_Q(ntryL,G1H32(18),wf4(:,1),G1H8(28),ngZl,m3h4x8(:,20),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(28),35,0,G2H8(14),n2h8(34))
  call Hloop_SV_V(ntryL,G1H32(19),wf4(:,1),G1H8(31),m3h4x8(:,21),heltab2x32(:,:,47))
  call Hloop_UW_V(ntryL,G0H32(9),32,wf4(:,1),3,G1H8(32),m3h4x8(:,22),heltab2x32(:,:,48))
  call Hloop_SV_V(ntryL,G0H32(10),wf4(:,1),G0H8(4),m3h4x8(:,23),heltab2x32(:,:,49))
  call Hloop_UW_V(ntryL,G1H32(20),32,wf4(:,1),3,G2H8(15),m3h4x8(:,24),heltab2x32(:,:,50))
  call Hloop_QA_V(ntryL,G1H32(21),ex4(:),G1H16(10),m3h2x16(:,27),heltab2x32(:,:,51))
  call Hloop_QA_Z(ntryL,G1H32(22),ex4(:),G1H16(11),ngZl,m3h2x16(:,28),heltab2x32(:,:,52))
  call Hloop_WA_Q(ntryL,G0H32(11),ex4(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(13),n2h16(21))
  call Hloop_WA_Q(ntryL,G0H32(12),ex4(:),G0H16(2),m3h2x16(:,30),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(2),40,0,G1H16(3),n2h16(22))
  call Hloop_WA_Q(ntryL,G1H32(23),ex4(:),G1H16(9),m3h2x16(:,31),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H16(9),40,0,G2H16(3),n2h16(23))
  call Hloop_WA_Q(ntryL,G1H32(24),ex4(:),G1H16(7),m3h2x16(:,32),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H16(7),40,0,G2H16(4),n2h16(24))
  call Hloop_WA_Q(ntryL,G0H32(13),ex4(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(8),n2h16(25))
  call Hloop_WA_Q(ntryL,G1H32(25),ex4(:),G1H16(9),m3h2x16(:,34),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G1H16(9),40,0,G2H16(5),n2h16(26))
  call Hloop_WQ_A(ntryL,G0H32(14),ex3(:),G0H16(2),m3h2x16(:,35),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(2),36,0,G1H16(7),n2h16(27))
  call Hloop_WQ_A(ntryL,G1H32(26),ex3(:),G1H16(9),m3h2x16(:,36),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H16(9),36,0,G2H16(6),n2h16(28))
  call Hloop_QA_W(ntryL,G1H32(27),ex2(:),G1H16(9),m3h2x16(:,37),heltab2x32(:,:,61))
  call Hloop_QA_W(ntryL,G1H32(28),ex2(:),G1H16(14),m3h2x16(:,38),heltab2x32(:,:,62))
  call Hloop_WA_Q(ntryL,G0H32(15),ex2(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(15),n2h16(29))
  call Hloop_WA_Q(ntryL,G0H32(16),ex2(:),G0H16(2),m3h2x16(:,40),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(16),n2h16(30))
  call Hloop_WA_Q(ntryL,G1H32(29),ex2(:),G1H16(17),m3h2x16(:,41),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H16(17),34,0,G2H16(7),n2h16(31))
  call Hloop_WA_Q(ntryL,G1H32(30),ex2(:),G1H16(17),m3h2x16(:,42),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H16(17),34,0,G2H16(8),n2h16(32))
  call Hloop_WA_Q(ntryL,G0H32(17),ex2(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(17),n2h16(33))
  call Hloop_WA_Q(ntryL,G0H32(18),ex2(:),G0H16(2),m3h2x16(:,44),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(18),n2h16(34))
  call Hloop_WA_Q(ntryL,G1H32(31),ex2(:),G1H16(19),m3h2x16(:,45),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H16(19),34,0,G2H16(9),n2h16(35))
  call Hloop_WA_Q(ntryL,G1H32(32),ex2(:),G1H16(19),m3h2x16(:,46),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G1H16(19),34,0,G2H16(10),n2h16(36))
  call Hloop_QV_A(ntryL,G1H32(33),wf4(:,10),G1H8(33),m3h4x8(:,25),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(33),44,0,G2H8(17),n2h8(35))
  call Hloop_QZ_A(ntryL,G1H32(34),wf4(:,11),G1H8(34),ngZl,m3h4x8(:,26),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(34),44,0,G2H8(18),n2h8(36))
  call Hloop_SV_V(ntryL,G1H32(35),wf4(:,10),G1H8(37),m3h4x8(:,27),heltab2x32(:,:,73))
  call Hloop_SV_V(ntryL,G1H32(36),wf4(:,11),G1H8(38),m3h4x8(:,28),heltab2x32(:,:,74))
  call Hloop_UW_V(ntryL,G0H32(19),32,wf4(:,10),12,G1H8(39),m3h4x8(:,29),heltab2x32(:,:,75))
  call Hloop_UW_V(ntryL,G0H32(20),32,wf4(:,11),12,G1H8(40),m3h4x8(:,30),heltab2x32(:,:,76))
  call Hloop_SV_V(ntryL,G0H32(21),wf4(:,10),G0H8(5),m3h4x8(:,31),heltab2x32(:,:,77))
  call Hloop_SV_V(ntryL,G0H32(22),wf4(:,11),G0H8(6),m3h4x8(:,32),heltab2x32(:,:,78))
  call Hloop_UW_V(ntryL,G1H32(37),32,wf4(:,10),12,G2H8(19),m3h4x8(:,33),heltab2x32(:,:,79))
  call Hloop_UW_V(ntryL,G1H32(38),32,wf4(:,11),12,G2H8(21),m3h4x8(:,34),heltab2x32(:,:,80))
  call Hloop_AQ_W(ntryL,G1H32(39),ex1(:),G1H16(19),m3h2x16(:,47),heltab2x32(:,:,81))
  call Hloop_AQ_W(ntryL,G1H32(40),ex1(:),G1H16(20),m3h2x16(:,48),heltab2x32(:,:,82))
  call Hloop_WQ_A(ntryL,G0H32(23),ex1(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(21),n2h16(37))
  call Hloop_WQ_A(ntryL,G0H32(24),ex1(:),G0H16(2),m3h2x16(:,50),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(22),n2h16(38))
  call Hloop_WQ_A(ntryL,G1H32(41),ex1(:),G1H16(23),m3h2x16(:,51),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(11),n2h16(39))
  call Hloop_WQ_A(ntryL,G1H32(42),ex1(:),G1H16(23),m3h2x16(:,52),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(12),n2h16(40))
  call Hloop_WQ_A(ntryL,G0H32(25),ex1(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(23),n2h16(41))
  call Hloop_WQ_A(ntryL,G0H32(26),ex1(:),G0H16(2),m3h2x16(:,54),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(24),n2h16(42))
  call Hloop_WQ_A(ntryL,G1H32(43),ex1(:),G1H16(25),m3h2x16(:,55),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(13),n2h16(43))
  call Hloop_WQ_A(ntryL,G1H32(44),ex1(:),G1H16(25),m3h2x16(:,56),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(14),n2h16(44))
  call Hloop_AQ_W(ntryL,G1H32(45),ex1(:),G1H16(25),m3h2x16(:,57),heltab2x32(:,:,91))
  call Hloop_AQ_W(ntryL,G1H32(46),ex1(:),G1H16(26),m3h2x16(:,58),heltab2x32(:,:,92))
  call Hloop_WQ_A(ntryL,G0H32(27),ex1(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(27),n2h16(45))
  call Hloop_WQ_A(ntryL,G0H32(28),ex1(:),G0H16(2),m3h2x16(:,60),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(28),n2h16(46))
  call Hloop_WQ_A(ntryL,G0H32(29),ex1(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(29),n2h16(47))
  call Hloop_WQ_A(ntryL,G0H32(30),ex1(:),G0H16(2),m3h2x16(:,62),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(30),n2h16(48))
  call Hloop_WQ_A(ntryL,G1H32(47),ex1(:),G1H16(31),m3h2x16(:,63),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G1H16(31),33,0,G2H16(15),n2h16(49))
  call Hloop_WQ_A(ntryL,G1H32(48),ex1(:),G1H16(31),m3h2x16(:,64),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H16(31),33,0,G2H16(16),n2h16(50))
  call Hloop_WQ_A(ntryL,G1H32(49),ex1(:),G1H16(31),m3h2x16(:,65),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G1H16(31),33,0,G2H16(17),n2h16(51))
  call Hloop_WQ_A(ntryL,G1H32(50),ex1(:),G1H16(31),m3h2x16(:,66),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G1H16(31),33,0,G2H16(18),n2h16(52))
  call Hloop_AV_Q(ntryL,G1H32(51),wf4(:,10),G1H8(43),m3h4x8(:,35),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(43),44,0,G2H8(22),n2h8(37))
  call Hloop_AZ_Q(ntryL,G1H32(52),wf4(:,11),G1H8(44),ngZl,m3h4x8(:,36),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G1H8(44),44,0,G2H8(1),n2h8(38))
  call Hloop_SV_V(ntryL,G1H32(53),wf4(:,10),G1H8(7),m3h4x8(:,37),heltab2x32(:,:,103))
  call Hloop_SV_V(ntryL,G1H32(54),wf4(:,11),G1H8(1),m3h4x8(:,38),heltab2x32(:,:,104))
  call Hloop_UV_W(ntryL,G0H32(31),32,wf4(:,10),12,G1H8(2),m3h4x8(:,39),heltab2x32(:,:,105))
  call Hloop_UV_W(ntryL,G0H32(32),32,wf4(:,11),12,G1H8(12),m3h4x8(:,40),heltab2x32(:,:,106))
  call Hloop_SV_V(ntryL,G0H32(33),wf4(:,10),G0H8(7),m3h4x8(:,41),heltab2x32(:,:,107))
  call Hloop_SV_V(ntryL,G0H32(34),wf4(:,11),G0H8(8),m3h4x8(:,42),heltab2x32(:,:,108))
  call Hloop_UV_W(ntryL,G1H32(55),32,wf4(:,10),12,G2H8(23),m3h4x8(:,43),heltab2x32(:,:,109))
  call Hloop_UV_W(ntryL,G1H32(56),32,wf4(:,11),12,G2H8(24),m3h4x8(:,44),heltab2x32(:,:,110))
  call Hloop_QA_W(ntryL,G1H32(57),ex2(:),G1H16(31),m3h2x16(:,67),heltab2x32(:,:,111))
  call Hloop_QA_W(ntryL,G1H32(58),ex2(:),G1H16(32),m3h2x16(:,68),heltab2x32(:,:,112))
  call Hloop_WA_Q(ntryL,G0H32(35),ex2(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(33),n2h16(53))
  call Hloop_WA_Q(ntryL,G0H32(36),ex2(:),G0H16(2),m3h2x16(:,70),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(34),n2h16(54))
  call Hloop_WA_Q(ntryL,G0H32(37),ex2(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(35),n2h16(55))
  call Hloop_WA_Q(ntryL,G0H32(38),ex2(:),G0H16(2),m3h2x16(:,72),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(36),n2h16(56))
  call Hloop_WA_Q(ntryL,G1H32(59),ex2(:),G1H16(37),m3h2x16(:,73),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G1H16(37),34,0,G2H16(19),n2h16(57))
  call Hloop_WA_Q(ntryL,G1H32(60),ex2(:),G1H16(37),m3h2x16(:,74),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G1H16(37),34,0,G2H16(20),n2h16(58))
  call Hloop_WA_Q(ntryL,G1H32(61),ex2(:),G1H16(37),m3h2x16(:,75),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G1H16(37),34,0,G2H16(21),n2h16(59))
  call Hloop_WA_Q(ntryL,G1H32(62),ex2(:),G1H16(37),m3h2x16(:,76),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G1H16(37),34,0,G2H16(22),n2h16(60))
  call Hloop_AQ_W(ntryL,G1H32(63),ex1(:),G1H16(37),m3h2x16(:,77),heltab2x32(:,:,121))
  call Hloop_AQ_W(ntryL,G1H32(64),ex1(:),G1H16(38),m3h2x16(:,78),heltab2x32(:,:,122))
  call Hloop_WQ_A(ntryL,G0H32(39),ex1(:),G0H16(1),m3h2x16(:,79),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(39),n2h16(61))
  call Hloop_WQ_A(ntryL,G0H32(40),ex1(:),G0H16(2),m3h2x16(:,80),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(40),n2h16(62))
  call Hloop_WQ_A(ntryL,G1H32(65),ex1(:),G1H16(41),m3h2x16(:,81),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G1H16(41),33,0,G2H16(23),n2h16(63))
  call Hloop_WQ_A(ntryL,G1H32(66),ex1(:),G1H16(41),m3h2x16(:,82),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G1H16(41),33,0,G2H16(24),n2h16(64))
  call Hloop_WQ_A(ntryL,G1H32(67),ex1(:),G1H16(41),m3h2x16(:,83),heltab2x32(:,:,127))
  call Hloop_Q_A(ntryL,G1H16(41),33,0,G2H16(25),n2h16(65))
  call Hloop_WQ_A(ntryL,G1H32(68),ex1(:),G1H16(41),m3h2x16(:,84),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G1H16(41),33,0,G2H16(26),n2h16(66))
  call Hloop_AQ_W(ntryL,G1H32(69),ex1(:),G1H16(41),m3h2x16(:,85),heltab2x32(:,:,129))
  call Hloop_AQ_W(ntryL,G1H32(70),ex1(:),G1H16(42),m3h2x16(:,86),heltab2x32(:,:,130))
  call Hloop_AQ_W(ntryL,G1H32(71),ex1(:),G1H16(43),m3h2x16(:,87),heltab2x32(:,:,131))
  call Hloop_AQ_W(ntryL,G1H32(72),ex1(:),G1H16(44),m3h2x16(:,88),heltab2x32(:,:,132))
  call Hloop_QA_W(ntryL,G1H32(73),ex2(:),G1H16(45),m3h2x16(:,89),heltab2x32(:,:,133))
  call Hloop_QA_W(ntryL,G1H32(74),ex2(:),G1H16(46),m3h2x16(:,90),heltab2x32(:,:,134))
  call Hloop_WA_Q(ntryL,G0H32(41),ex2(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(47),n2h16(67))
  call Hloop_WA_Q(ntryL,G0H32(42),ex2(:),G0H16(2),m3h2x16(:,92),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(48),n2h16(68))
  call Hloop_WA_Q(ntryL,G1H32(75),ex2(:),G1H16(49),m3h2x16(:,93),heltab2x32(:,:,137))
  call Hloop_A_Q(ntryL,G1H16(49),34,0,G2H16(27),n2h16(69))
  call Hloop_WA_Q(ntryL,G1H32(76),ex2(:),G1H16(49),m3h2x16(:,94),heltab2x32(:,:,138))
  call Hloop_A_Q(ntryL,G1H16(49),34,0,G2H16(28),n2h16(70))
  call Hloop_QA_W(ntryL,G1H32(77),ex2(:),G1H16(49),m3h2x16(:,95),heltab2x32(:,:,139))
  call Hloop_QA_W(ntryL,G1H32(78),ex2(:),G1H16(50),m3h2x16(:,96),heltab2x32(:,:,140))
  call Hloop_WA_Q(ntryL,G0H32(43),ex2(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(51),n2h16(71))
  call Hloop_WA_Q(ntryL,G0H32(44),ex2(:),G0H16(2),m3h2x16(:,98),heltab2x32(:,:,142))
  call Hloop_A_Q(ntryL,G0H16(2),34,0,G1H16(52),n2h16(72))
  call Hloop_WA_Q(ntryL,G1H32(79),ex2(:),G1H16(53),m3h2x16(:,99),heltab2x32(:,:,143))
  call Hloop_A_Q(ntryL,G1H16(53),34,0,G2H16(29),n2h16(73))
  call Hloop_WA_Q(ntryL,G1H32(80),ex2(:),G1H16(53),m3h2x16(:,100),heltab2x32(:,:,144))
  call Hloop_A_Q(ntryL,G1H16(53),34,0,G2H16(30),n2h16(74))
  call Hloop_WQ_A(ntryL,G1H32(81),ex1(:),G1H16(53),m3h2x16(:,101),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G1H16(53),33,0,G2H16(31),n2h16(75))
  call Hloop_WQ_A(ntryL,G1H32(82),ex1(:),G1H16(53),m3h2x16(:,102),heltab2x32(:,:,146))
  call Hloop_Q_A(ntryL,G1H16(53),33,0,G2H16(32),n2h16(76))
  call Hloop_AQ_W(ntryL,G1H32(83),ex1(:),G1H16(53),m3h2x16(:,103),heltab2x32(:,:,147))
  call Hloop_AQ_W(ntryL,G1H32(84),ex1(:),G1H16(54),m3h2x16(:,104),heltab2x32(:,:,148))
  call Hloop_AQ_W(ntryL,G1H32(85),ex1(:),G1H16(55),m3h2x16(:,105),heltab2x32(:,:,149))
  call Hloop_AQ_W(ntryL,G1H32(86),ex1(:),G1H16(56),m3h2x16(:,106),heltab2x32(:,:,150))
  call Hloop_AQ_W(ntryL,G1H32(87),ex1(:),G1H16(57),m3h2x16(:,107),heltab2x32(:,:,151))
  call Hloop_AQ_W(ntryL,G1H32(88),ex1(:),G1H16(58),m3h2x16(:,108),heltab2x32(:,:,152))
  call Hloop_WQ_A(ntryL,G0H32(45),ex1(:),G0H16(1),m3h2x16(:,109),heltab2x32(:,:,153))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(59),n2h16(77))
  call Hloop_WQ_A(ntryL,G0H32(46),ex1(:),G0H16(2),m3h2x16(:,110),heltab2x32(:,:,154))
  call Hloop_Q_A(ntryL,G0H16(2),33,0,G1H16(60),n2h16(78))
  call Hloop_WQ_A(ntryL,G1H32(89),ex1(:),G1H16(61),m3h2x16(:,111),heltab2x32(:,:,155))
  call Hloop_Q_A(ntryL,G1H16(61),33,0,G2H16(33),n2h16(79))
  call Hloop_WQ_A(ntryL,G1H32(90),ex1(:),G1H16(61),m3h2x16(:,112),heltab2x32(:,:,156))
  call Hloop_Q_A(ntryL,G1H16(61),33,0,G2H16(34),n2h16(80))
  call Hloop_QA_Z(ntryL,G1H32(91),ex4(:),G1H16(61),ngZl,m3h2x16(:,113),heltab2x32(:,:,157))
  call Hloop_WQ_A(ntryL,G1H32(92),ex1(:),G1H16(62),m3h2x16(:,114),heltab2x32(:,:,158))
  call Hloop_Q_A(ntryL,G1H16(62),33,0,G2H16(35),n2h16(81))
  call Hloop_QA_Z(ntryL,G1H32(93),ex4(:),G1H16(62),ngZl,m3h2x16(:,115),heltab2x32(:,:,159))
  call Hloop_WA_Q(ntryL,G1H32(94),ex2(:),G1H16(63),m3h2x16(:,116),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G1H16(63),34,0,G2H16(36),n2h16(82))
  call Hloop_AQ_W(ntryL,G1H32(95),ex1(:),G1H16(63),m3h2x16(:,117),heltab2x32(:,:,161))
  call Hloop_WA_Q(ntryL,G1H32(96),ex2(:),G1H16(64),m3h2x16(:,118),heltab2x32(:,:,162))
  call Hloop_A_Q(ntryL,G1H16(64),34,0,G2H16(37),n2h16(83))
  call Hloop_AQ_Z(ntryL,G1H32(97),ex3(:),G1H16(64),ngZl,m3h2x16(:,119),heltab2x32(:,:,163))
  call Hloop_WQ_A(ntryL,G1H32(98),ex1(:),G1H16(65),m3h2x16(:,120),heltab2x32(:,:,164))
  call Hloop_Q_A(ntryL,G1H16(65),33,0,G2H16(38),n2h16(84))
  call Hloop_AQ_Z(ntryL,G1H32(99),ex3(:),G1H16(65),ngZl,m3h2x16(:,121),heltab2x32(:,:,165))
  call Hloop_AQ_W(ntryL,G1H32(100),ex1(:),G1H16(66),m3h2x16(:,122),heltab2x32(:,:,166))
  call Hloop_ZA_Q(ntryL,G0H16(3),ex2(:),G0H8(9),ngZn,m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(9),38,0,G1H8(3),n2h8(39))
  call Hloop_QA_W(ntryL,G1H16(12),ex4(:),G1H8(17),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_ZQ_A(ntryL,G0H16(4),ex1(:),G0H8(9),ngZn,m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G0H8(9),37,0,G1H8(22),n2h8(40))
  call Hloop_WQ_A(ntryL,G0H16(5),ex1(:),G0H8(9),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G0H8(9),37,0,G1H8(23),n2h8(41))
  call Hloop_WQ_A(ntryL,G0H16(6),ex1(:),G0H8(9),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G0H8(9),37,0,G1H8(4),n2h8(42))
  call Hloop_AQ_W(ntryL,G1H16(1),ex3(:),G1H8(28),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_ZA_Q(ntryL,G0H16(7),ex2(:),G0H8(9),ngZn,m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G0H8(9),42,0,G1H8(33),n2h8(43))
  call Hloop_WA_Q(ntryL,G0H16(8),ex2(:),G0H8(9),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G0H8(9),42,0,G1H8(34),n2h8(44))
  call Hloop_ZQ_A(ntryL,G0H16(9),ex1(:),G0H8(9),ngZn,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G0H8(9),41,0,G1H8(43),n2h8(45))
  call Hloop_WA_Q(ntryL,G0H16(10),ex2(:),G0H8(9),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G0H8(9),42,0,G1H8(44),n2h8(46))
call HGT_w2_OLR(G1H8(5),1,1,8)
call HGT_w2_invQ_OLR(G1H8(5),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(44)])
call HGT_w2_OLR(G1H8(6),1,1,8)
call HGT_w2_invQ_OLR(G1H8(6),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(23),G1H8(9),G0H8(8),G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G1H8(14),G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G2H8(19),G1H8(19),G0H8(6),G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(25),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G1H8(30),G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G1H8(36),G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G2H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(39),G1H8(38),G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G2H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(2),G1H8(1),G1H8(7)])
  call Hloop_AV_Q(ntryL,G1H8(5),ex5(:),G1H4(50),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(50),58,0,G2H4(8),n2h4(35))
  call Hloop_AQ_W(ntryL,G2H8(16),ex1(:),G2H4(9),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_QV_A(ntryL,G1H8(6),ex5(:),G1H4(62),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(62),53,0,G2H4(10),n2h4(36))
  call Hloop_QA_W(ntryL,G2H8(20),ex2(:),G2H4(11),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_WQ_A(ntryL,G1H8(28),ex1(:),G1H4(74),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(74),45,0,G2H4(12),n2h4(37))
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(20),mass5set(:,8),  & 
G1H8(44),G1H8(4),G1H8(8),G1H8(9),G1H8(14),G1H8(18),8)
  call HG1shiftOLR(G1H8(4),16,8)
  call Hloop_WQ_A(ntryL,G1H8(13),ex3(:),G1H4(86),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(86),39,0,G2H4(14),n2h4(38))
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(21),mass5set(:,8),  & 
G1H8(19),G1H8(25),G1H8(30),G1H8(36),G1H8(15),G1H8(20),8)
  call HG1shiftOLR(G1H8(25),16,8)
  call Hloop_WA_Q(ntryL,G1H8(17),ex2(:),G1H4(3),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(3),46,0,G2H4(15),n2h4(39))
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(22),mass5set(:,8),  & 
G1H8(26),G1H8(31),G1H8(39),G1H8(38),G1H8(37),G1H8(2),8)
  call HG1shiftOLR(G1H8(31),16,8)
  call Hloop_UW_V(ntryL,G1H8(24),35,ex5(:),16,G2H4(17),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(23),mass5set(:,9),  & 
G1H8(1),G1H8(7),G1H8(5),G1H8(6),G1H8(28),G1H8(13),8)
  call HG1shiftOLR(G1H8(7),8,8)
  call Hloop_WA_Q(ntryL,G1H8(29),ex4(:),G1H4(4),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(4),43,0,G2H4(18),n2h4(40))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(24),mass5set(:,8),  & 
G1H8(17),G1H8(24),G1H8(29),G1H8(45),G1H8(46),G1H8(47),8)
  call HG1shiftOLR(G1H8(24),16,8)
  call Hloop_UV_W(ntryL,G1H8(35),35,ex5(:),16,G2H4(21),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(25),mass5set(:,9),  & 
G1H8(35),G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(48),4,8)
  call Hloop_WQ_A(ntryL,G1H8(41),ex3(:),G1H4(8),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(8),53,0,G2H4(22),n2h4(41))
  call Hloop_WQ_A(ntryL,G1H8(42),ex3(:),G1H4(9),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(9),53,0,G2H4(25),n2h4(42))
  call Hloop_AQ_W(ntryL,G2H8(2),ex1(:),G2H4(26),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QA_W(ntryL,G2H8(3),ex2(:),G2H4(29),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_AQ_W(ntryL,G1H8(10),ex1(:),G1H4(10),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QA_W(ntryL,G1H8(11),ex2(:),G1H4(14),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(23),mass5set(:,10),  & 
G1H8(41),G1H8(42),G1H8(10),G1H8(11),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(42),8,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(23),mass5set(:,11),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),8,8)
  call Hloop_SV_V(ntryL,G1H8(16),ex5(:),G1H4(15),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_QA_V(ntryL,G2H8(7),ex4(:),G2H4(30),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_QA_Z(ntryL,G2H8(8),ex4(:),G2H4(32),ngZl,m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_WA_Q(ntryL,G1H8(21),ex4(:),G1H4(16),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(16),43,0,G2H4(33),n2h4(43))
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(25),mass5set(:,10),  & 
G1H8(16),G1H8(21),G1H8(61),G1H8(62),G1H8(63),G1H8(64),8)
  call HG1shiftOLR(G1H8(21),4,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(25),mass5set(:,11),  & 
G1H8(65),G1H8(66),G1H8(67),G1H8(68),G1H8(69),G1H8(70),8)
  call HG1shiftOLR(G1H8(66),4,8)
  call Hloop_SV_V(ntryL,G1H8(27),ex5(:),G1H4(20),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_VA_Q(ntryL,G1H16(2),ex4(:),G1H8(27),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(27),44,0,G2H8(23),n2h8(47))
  call Hloop_ZA_Q(ntryL,G1H16(4),ex4(:),G1H8(27),ngZl,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(27),44,0,G2H8(19),n2h8(48))
  call Hloop_QA_W(ntryL,G1H16(5),ex4(:),G1H8(27),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_QA_W(ntryL,G1H16(6),ex4(:),G1H8(71),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_QA_W(ntryL,G2H16(1),ex4(:),G2H8(17),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_QA_W(ntryL,G2H16(2),ex4(:),G2H8(22),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_AQ_V(ntryL,G2H8(13),ex3(:),G2H4(36),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_AQ_Z(ntryL,G2H8(14),ex3(:),G2H4(37),ngZl,m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_WQ_A(ntryL,G1H8(32),ex3(:),G1H4(21),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(21),39,0,G2H4(39),n2h4(44))
  call Hloop_VQ_A(ntryL,G1H16(10),ex3(:),G1H8(32),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(32),44,0,G2H8(16),n2h8(49))
  call Hloop_ZQ_A(ntryL,G1H16(11),ex3(:),G1H8(32),ngZl,m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(32),44,0,G2H8(20),n2h8(50))
  call Hloop_AQ_W(ntryL,G1H16(13),ex3(:),G1H8(32),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_AQ_W(ntryL,G1H16(3),ex3(:),G1H8(72),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_AQ_W(ntryL,G2H16(3),ex3(:),G2H8(24),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_AQ_W(ntryL,G2H16(4),ex3(:),G2H8(15),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AZ_Q(ntryL,G1H16(8),wf4(:,1),G1H4(22),ngZn,m3h4x4(:,1),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(22),43,0,G2H4(40),n2h4(45))
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(26),mass5set(:,1),  & 
G1H16(12),G1H16(1),G1H16(2),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(1),16,16)
  call Hloop_QZ_A(ntryL,G1H16(7),wf4(:,1),G1H4(26),ngZn,m3h4x4(:,2),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(26),39,0,G2H4(43),n2h4(46))
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(27),mass5set(:,1),  & 
G1H16(10),G1H16(11),G1H16(13),G1H16(3),G1H16(8),G1H16(7),16)
  call HG1shiftOLR(G1H16(11),16,16)
  call Hloop_WQ_A(ntryL,G1H16(9),ex1(:),G1H8(73),m3h2x8(:,55),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(73),35,0,G2H8(21),n2h8(51))
  call Hloop_WQ_A(ntryL,G1H16(14),ex1(:),G1H8(73),m3h2x8(:,56),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(73),35,0,G2H8(6),n2h8(52))
  call Hloop_AQ_W(ntryL,G1H16(15),ex1(:),G1H8(73),m3h2x8(:,57),heltab2x16(:,:,59))
  call Hloop_AQ_W(ntryL,G1H16(16),ex1(:),G1H8(74),m3h2x8(:,58),heltab2x16(:,:,60))
  call Hloop_AQ_W(ntryL,G2H16(7),ex1(:),G2H8(9),m3h2x8(:,59),heltab2x16(:,:,61))
  call Hloop_AQ_W(ntryL,G2H16(8),ex1(:),G2H8(12),m3h2x8(:,60),heltab2x16(:,:,62))
  call Hloop_AQ_W(ntryL,G1H16(17),ex1(:),G1H8(75),m3h2x8(:,61),heltab2x16(:,:,63))
  call Hloop_AQ_W(ntryL,G1H16(18),ex1(:),G1H8(76),m3h2x8(:,62),heltab2x16(:,:,64))
  call Hloop_AQ_W(ntryL,G2H16(9),ex1(:),G2H8(2),m3h2x8(:,63),heltab2x16(:,:,65))
  call Hloop_AQ_W(ntryL,G2H16(10),ex1(:),G2H8(3),m3h2x8(:,64),heltab2x16(:,:,66))
  call Hloop_QA_W(ntryL,G2H8(18),ex2(:),G2H4(1),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_WA_Q(ntryL,G1H8(40),ex2(:),G1H4(27),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(27),46,0,G2H4(2),n2h4(47))
  call Hloop_WA_Q(ntryL,G1H16(19),ex2(:),G1H8(40),m3h2x8(:,65),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(40),35,0,G2H8(4),n2h8(53))
  call Hloop_WA_Q(ntryL,G1H16(20),ex2(:),G1H8(40),m3h2x8(:,66),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(40),35,0,G2H8(5),n2h8(54))
  call Hloop_QA_W(ntryL,G1H16(21),ex2(:),G1H8(40),m3h2x8(:,67),heltab2x16(:,:,69))
  call Hloop_QA_W(ntryL,G1H16(22),ex2(:),G1H8(77),m3h2x8(:,68),heltab2x16(:,:,70))
  call Hloop_QA_W(ntryL,G2H16(11),ex2(:),G2H8(7),m3h2x8(:,69),heltab2x16(:,:,71))
  call Hloop_QA_W(ntryL,G2H16(12),ex2(:),G2H8(8),m3h2x8(:,70),heltab2x16(:,:,72))
  call Hloop_QA_W(ntryL,G1H16(23),ex2(:),G1H8(78),m3h2x8(:,71),heltab2x16(:,:,73))
  call Hloop_QA_W(ntryL,G1H16(24),ex2(:),G1H8(79),m3h2x8(:,72),heltab2x16(:,:,74))
  call Hloop_QA_W(ntryL,G2H16(13),ex2(:),G2H8(10),m3h2x8(:,73),heltab2x16(:,:,75))
  call Hloop_QA_W(ntryL,G2H16(14),ex2(:),G2H8(11),m3h2x8(:,74),heltab2x16(:,:,76))
  call Hloop_WA_Q(ntryL,G1H16(25),ex2(:),G1H8(80),m3h2x8(:,75),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(80),35,0,G2H8(13),n2h8(55))
  call Hloop_WA_Q(ntryL,G1H16(26),ex2(:),G1H8(80),m3h2x8(:,76),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(80),35,0,G2H8(14),n2h8(56))
  call Hloop_QA_W(ntryL,G1H16(27),ex2(:),G1H8(80),m3h2x8(:,77),heltab2x16(:,:,79))
  call Hloop_QA_W(ntryL,G1H16(28),ex2(:),G1H8(81),m3h2x8(:,78),heltab2x16(:,:,80))
  call Hloop_QA_W(ntryL,G1H16(29),ex2(:),G1H8(82),m3h2x8(:,79),heltab2x16(:,:,81))
  call Hloop_QA_W(ntryL,G1H16(30),ex2(:),G1H8(83),m3h2x8(:,80),heltab2x16(:,:,82))
  call Hloop_QA_W(ntryL,G2H16(15),ex2(:),G2H8(18),m3h2x8(:,81),heltab2x16(:,:,83))
  call Hloop_QA_W(ntryL,G2H16(16),ex2(:),G2H8(25),m3h2x8(:,82),heltab2x16(:,:,84))
  call Hloop_QA_W(ntryL,G2H16(17),ex2(:),G2H8(26),m3h2x8(:,83),heltab2x16(:,:,85))
  call Hloop_QA_W(ntryL,G2H16(18),ex2(:),G2H8(27),m3h2x8(:,84),heltab2x16(:,:,86))
  call Hloop_AQ_W(ntryL,G2H8(1),ex1(:),G2H4(3),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_WQ_A(ntryL,G1H8(12),ex1(:),G1H4(28),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(28),45,0,G2H4(4),n2h4(48))
  call Hloop_WQ_A(ntryL,G1H16(31),ex1(:),G1H8(12),m3h2x8(:,85),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(12),35,0,G2H8(1),n2h8(57))
  call Hloop_WQ_A(ntryL,G1H16(32),ex1(:),G1H8(12),m3h2x8(:,86),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(12),35,0,G2H8(28),n2h8(58))
  call Hloop_AQ_W(ntryL,G1H16(33),ex1(:),G1H8(12),m3h2x8(:,87),heltab2x16(:,:,89))
  call Hloop_AQ_W(ntryL,G1H16(34),ex1(:),G1H8(84),m3h2x8(:,88),heltab2x16(:,:,90))
  call Hloop_AQ_W(ntryL,G1H16(35),ex1(:),G1H8(85),m3h2x8(:,89),heltab2x16(:,:,91))
  call Hloop_AQ_W(ntryL,G1H16(36),ex1(:),G1H8(86),m3h2x8(:,90),heltab2x16(:,:,92))
  call Hloop_AQ_W(ntryL,G2H16(19),ex1(:),G2H8(29),m3h2x8(:,91),heltab2x16(:,:,93))
  call Hloop_AQ_W(ntryL,G2H16(20),ex1(:),G2H8(30),m3h2x8(:,92),heltab2x16(:,:,94))
  call Hloop_AQ_W(ntryL,G2H16(21),ex1(:),G2H8(31),m3h2x8(:,93),heltab2x16(:,:,95))
  call Hloop_AQ_W(ntryL,G2H16(22),ex1(:),G2H8(32),m3h2x8(:,94),heltab2x16(:,:,96))
  call Hloop_UW_V(ntryL,G1H16(37),33,ex5(:),16,G2H8(33),m3h2x8(:,95),heltab2x16(:,:,97))
  call Hloop_UW_V(ntryL,G1H16(38),33,ex5(:),16,G2H8(34),m3h2x8(:,96),heltab2x16(:,:,98))
  call Hloop_QV_A(ntryL,G1H16(39),ex5(:),G1H8(87),m3h2x8(:,97),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(87),49,0,G2H8(35),n2h8(59))
  call Hloop_QV_A(ntryL,G1H16(40),ex5(:),G1H8(87),m3h2x8(:,98),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(87),49,0,G2H8(36),n2h8(60))
  call Hotf_5pt_reduction(G2H16(23),RedSet_5(2),mass5set(:,1),  & 
G1H16(9),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),12,16)
  call Hotf_5pt_reduction(G2H16(24),RedSet_5(2),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),12,16)
  call Hotf_5pt_reduction(G2H16(25),RedSet_5(28),mass5set(:,7),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(26),2,16)
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(28),mass5set(:,7),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
  call HG1shiftOLR(G1H16(32),2,16)
  call Hloop_VV_S(ntryL,G1H16(41),ex5(:),G1H8(87),m3h2x8(:,99),heltab2x16(:,:,101))
  call Hloop_VV_S(ntryL,G1H16(42),ex5(:),G1H8(88),m3h2x8(:,100),heltab2x16(:,:,102))
  call Hloop_UW_V(ntryL,G1H16(43),33,ex5(:),16,G2H8(37),m3h2x8(:,101),heltab2x16(:,:,103))
  call Hloop_UW_V(ntryL,G1H16(44),33,ex5(:),16,G2H8(38),m3h2x8(:,102),heltab2x16(:,:,104))
  call Hloop_UV_W(ntryL,G1H16(45),34,ex5(:),16,G2H8(39),m3h2x8(:,103),heltab2x16(:,:,105))
  call Hloop_UV_W(ntryL,G1H16(46),34,ex5(:),16,G2H8(40),m3h2x8(:,104),heltab2x16(:,:,106))
  call Hloop_AV_Q(ntryL,G1H16(47),ex5(:),G1H8(89),m3h2x8(:,105),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G1H8(89),50,0,G2H8(41),n2h8(61))
  call Hloop_AV_Q(ntryL,G1H16(48),ex5(:),G1H8(89),m3h2x8(:,106),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G1H8(89),50,0,G2H8(42),n2h8(62))
  call Hotf_5pt_reduction(G2H16(27),RedSet_5(1),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),12,16)
  call Hotf_5pt_reduction(G2H16(28),RedSet_5(1),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),12,16)
  call Hloop_UV_W(ntryL,G1H16(49),34,wf4(:,10),12,G2H4(5),m3h4x4(:,3),heltab2x16(:,:,109))
  call Hloop_UV_W(ntryL,G1H16(50),34,wf4(:,11),12,G2H4(6),m3h4x4(:,4),heltab2x16(:,:,110))
  call Hloop_AV_Q(ntryL,G1H16(51),wf4(:,10),G1H4(32),m3h4x4(:,5),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(32),46,0,G2H4(7),n2h4(49))
  call Hloop_AZ_Q(ntryL,G1H16(52),wf4(:,11),G1H4(33),ngZl,m3h4x4(:,6),heltab2x16(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(33),46,0,G2H4(44),n2h4(50))
  call Hotf_5pt_reduction(G2H16(29),RedSet_5(29),mass5set(:,1),  & 
G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(67),G1H16(68),16)
  call HG1shiftOLR(G1H16(50),16,16)
  call Hotf_5pt_reduction(G2H16(30),RedSet_5(29),mass5set(:,1),  & 
G1H16(69),G1H16(70),G1H16(71),G1H16(72),G1H16(73),G1H16(74),16)
  call HG1shiftOLR(G1H16(70),16,16)
  call Hotf_5pt_reduction(G2H16(31),RedSet_5(30),mass5set(:,7),  & 
G1H16(75),G1H16(76),G1H16(77),G1H16(78),G1H16(79),G1H16(80),16)
  call HG1shiftOLR(G1H16(76),2,16)
  call Hotf_5pt_reduction(G2H16(32),RedSet_5(30),mass5set(:,7),  & 
G1H16(81),G1H16(82),G1H16(83),G1H16(84),G1H16(85),G1H16(86),16)
  call HG1shiftOLR(G1H16(82),2,16)
  call Hloop_VV_S(ntryL,G1H16(53),wf4(:,10),G1H4(34),m3h4x4(:,7),heltab2x16(:,:,113))
  call Hloop_VV_S(ntryL,G1H16(54),wf4(:,11),G1H4(38),m3h4x4(:,8),heltab2x16(:,:,114))
  call Hloop_UW_V(ntryL,G1H16(55),33,wf4(:,10),12,G2H4(45),m3h4x4(:,9),heltab2x16(:,:,115))
  call Hloop_UW_V(ntryL,G1H16(56),33,wf4(:,11),12,G2H4(46),m3h4x4(:,10),heltab2x16(:,:,116))
  call Hloop_UW_V(ntryL,G1H16(57),33,wf4(:,10),12,G2H4(47),m3h4x4(:,11),heltab2x16(:,:,117))
  call Hloop_UW_V(ntryL,G1H16(58),33,wf4(:,11),12,G2H4(48),m3h4x4(:,12),heltab2x16(:,:,118))
  call Hloop_QV_A(ntryL,G1H16(59),wf4(:,10),G1H4(39),m3h4x4(:,13),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(39),45,0,G2H4(49),n2h4(51))
  call Hloop_QZ_A(ntryL,G1H16(60),wf4(:,11),G1H4(40),ngZl,m3h4x4(:,14),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(40),45,0,G2H4(50),n2h4(52))
  call Hotf_5pt_reduction(G2H16(33),RedSet_5(31),mass5set(:,1),  & 
G1H16(53),G1H16(54),G1H16(55),G1H16(56),G1H16(57),G1H16(58),16)
  call HG1shiftOLR(G1H16(54),16,16)
  call Hotf_5pt_reduction(G2H16(34),RedSet_5(31),mass5set(:,1),  & 
G1H16(59),G1H16(60),G1H16(87),G1H16(88),G1H16(89),G1H16(90),16)
  call HG1shiftOLR(G1H16(60),16,16)
  call Hloop_ZQ_A(ntryL,G1H16(61),ex1(:),G1H8(89),ngZn,m3h2x8(:,107),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G1H8(89),41,0,G2H8(43),n2h8(63))
  call Hloop_QA_W(ntryL,G2H16(35),ex2(:),G2H8(44),m3h2x8(:,108),heltab2x16(:,:,122))
  call Hloop_ZA_Q(ntryL,G1H16(62),ex2(:),G1H8(89),ngZn,m3h2x8(:,109),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(89),42,0,G2H8(45),n2h8(64))
  call Hloop_AQ_W(ntryL,G2H16(36),ex1(:),G2H8(46),m3h2x8(:,110),heltab2x16(:,:,124))
  call Hloop_WQ_A(ntryL,G1H16(63),wf4(:,4),G1H4(44),m3h4x4(:,15),heltab2x16(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(44),53,0,G2H4(51),n2h4(53))
  call Hloop_AQ_W(ntryL,G2H16(37),ex1(:),G2H8(47),m3h2x8(:,111),heltab2x16(:,:,126))
  call Hloop_ZQ_A(ntryL,G1H16(64),ex1(:),G1H8(89),ngZn,m3h2x8(:,112),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G1H8(89),37,0,G2H8(48),n2h8(65))
  call Hloop_QA_W(ntryL,G2H16(38),ex2(:),G2H8(49),m3h2x8(:,113),heltab2x16(:,:,128))
  call Hloop_ZA_Q(ntryL,G1H16(65),ex2(:),G1H8(89),ngZn,m3h2x8(:,114),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G1H8(89),38,0,G2H8(50),n2h8(66))
  call Hloop_WQ_A(ntryL,G1H16(66),ex3(:),G1H8(89),m3h2x8(:,115),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H8(89),37,0,G2H8(51),n2h8(67))
  call Hloop_AQ_Z(ntryL,G1H8(3),ex1(:),G1H4(45),ngZn,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_QA_Z(ntryL,G1H8(22),ex2(:),G1H4(46),ngZn,m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_QA_W(ntryL,G1H8(23),ex2(:),G1H4(51),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_AQ_Z(ntryL,G1H8(33),ex1(:),G1H4(52),ngZn,m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_AQ_W(ntryL,G1H8(34),ex1(:),G1H4(56),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_QA_Z(ntryL,G1H8(43),ex2(:),G1H4(57),ngZn,m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_WQ_A(ntryL,G1H8(44),ex1(:),G1H4(58),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(58),45,0,G2H4(52),n2h4(54))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(4),-16,ex5(:),16,G2H4(53),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_WQ_A(ntryL,G1H8(9),ex1(:),G1H4(63),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(63),45,0,G2H4(54),n2h4(55))
  call Hloop_WQ_A(ntryL,G1H8(14),ex1(:),G1H4(64),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(64),45,0,G2H4(55),n2h4(56))
  call Hloop_WQ_A(ntryL,G1H8(18),ex1(:),G1H4(68),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(68),45,0,G2H4(56),n2h4(57))
  call Hloop_WQ_A(ntryL,G1H8(19),ex3(:),G1H4(69),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(69),39,0,G2H4(57),n2h4(58))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(25),-16,ex5(:),16,G2H4(58),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_WQ_A(ntryL,G1H8(36),ex3(:),G1H4(70),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(70),39,0,G2H4(59),n2h4(59))
  call Hloop_WQ_A(ntryL,G1H8(15),ex3(:),G1H4(75),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(75),39,0,G2H4(60),n2h4(60))
  call Hloop_WQ_A(ntryL,G1H8(20),ex3(:),G1H4(76),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(76),39,0,G2H4(61),n2h4(61))
  call Hloop_WA_Q(ntryL,G1H8(26),ex2(:),G1H4(80),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(80),46,0,G2H4(62),n2h4(62))
call HGT_raise_alpha_OLR(G1H8(31),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(31),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(31),-16,ex5(:),16,G2H4(63),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_WA_Q(ntryL,G1H8(38),ex2(:),G1H4(81),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(81),46,0,G2H4(64),n2h4(63))
  call Hloop_WA_Q(ntryL,G1H8(37),ex2(:),G1H4(82),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(82),46,0,G2H4(65),n2h4(64))
  call Hloop_WA_Q(ntryL,G1H8(2),ex2(:),G1H4(87),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(87),46,0,G2H4(66),n2h4(65))
  call Hloop_UW_V(ntryL,G1H8(1),35,ex5(:),16,G2H4(67),m3h2x4(:,95),heltab2x8(:,:,95))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(7),ex4(:),G1H4(88),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_UW_V(ntryL,G1H8(6),35,ex5(:),16,G2H4(68),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_UW_V(ntryL,G1H8(28),35,ex5(:),16,G2H4(69),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_UW_V(ntryL,G1H8(13),35,ex5(:),16,G2H4(70),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_WA_Q(ntryL,G1H8(17),ex4(:),G1H4(92),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(92),43,0,G2H4(71),n2h4(66))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(24),-16,ex5(:),16,G2H4(72),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_WA_Q(ntryL,G1H8(45),ex4(:),G1H4(50),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(50),43,0,G2H4(73),n2h4(67))
  call Hloop_WA_Q(ntryL,G1H8(46),ex4(:),G1H4(62),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(62),43,0,G2H4(74),n2h4(68))
  call Hloop_WA_Q(ntryL,G1H8(47),ex4(:),G1H4(74),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(74),43,0,G2H4(75),n2h4(69))
  call Hloop_UV_W(ntryL,G1H8(35),35,ex5(:),16,G2H4(76),m3h2x4(:,105),heltab2x8(:,:,105))
call HGT_raise_alpha_OLR(G1H8(48),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(48),ex3(:),G1H4(86),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_UV_W(ntryL,G1H8(50),35,ex5(:),16,G2H4(77),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_UV_W(ntryL,G1H8(51),35,ex5(:),16,G2H4(78),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_UV_W(ntryL,G1H8(52),35,ex5(:),16,G2H4(79),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_AV_Q(ntryL,G1H8(41),ex5(:),G1H4(3),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(3),51,0,G2H4(80),n2h4(70))
call HGT_OLR(G1H8(42),1,1,8)
call HGT_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(42),-8,0,G2H8(52),n2h8(74))
  call Hloop_QA_V(ntryL,G2H8(52),ex4(:),G2H4(81),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_AV_Q(ntryL,G1H8(11),ex5(:),G1H4(4),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(4),51,0,G2H4(82),n2h4(71))
  call Hloop_AV_Q(ntryL,G1H8(53),ex5(:),G1H4(8),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(8),51,0,G2H4(83),n2h4(72))
  call Hloop_AV_Q(ntryL,G1H8(54),ex5(:),G1H4(9),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G1H4(9),51,0,G2H4(84),n2h4(73))
  call Hloop_AV_Q(ntryL,G1H8(55),ex5(:),G1H4(16),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(16),51,0,G2H4(85),n2h4(74))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(56),-8,0,G2H8(52),n2h8(75))
  call Hloop_QA_Z(ntryL,G2H8(52),ex4(:),G2H4(86),ngZl,m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_AV_Q(ntryL,G1H8(58),ex5(:),G1H4(21),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(21),51,0,G2H4(87),n2h4(75))
  call Hloop_AV_Q(ntryL,G1H8(59),ex5(:),G1H4(22),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(22),51,0,G2H4(88),n2h4(76))
  call Hloop_AV_Q(ntryL,G1H8(60),ex5(:),G1H4(26),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(26),51,0,G2H4(89),n2h4(77))
  call Hloop_QV_A(ntryL,G1H8(16),ex5(:),G1H4(27),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(27),51,0,G2H4(90),n2h4(78))
call HGT_OLR(G1H8(21),1,1,8)
call HGT_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(21),-4,0,G2H8(52),n2h8(76))
  call Hloop_AQ_V(ntryL,G2H8(52),ex3(:),G2H4(91),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_QV_A(ntryL,G1H8(62),ex5(:),G1H4(28),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(28),51,0,G2H4(92),n2h4(79))
  call Hloop_QV_A(ntryL,G1H8(63),ex5(:),G1H4(32),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(32),51,0,G2H4(93),n2h4(80))
  call Hloop_QV_A(ntryL,G1H8(64),ex5(:),G1H4(33),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(33),51,0,G2H4(94),n2h4(81))
  call Hloop_QV_A(ntryL,G1H8(65),ex5(:),G1H4(39),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(39),51,0,G2H4(95),n2h4(82))
call HGT_OLR(G1H8(66),1,1,8)
call HGT_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(66),-4,0,G2H8(52),n2h8(77))
  call Hloop_AQ_Z(ntryL,G2H8(52),ex3(:),G2H4(96),ngZl,m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_QV_A(ntryL,G1H8(68),ex5(:),G1H4(40),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(40),51,0,G2H4(97),n2h4(83))
  call Hloop_QV_A(ntryL,G1H8(69),ex5(:),G1H4(44),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G1H4(44),51,0,G2H4(98),n2h4(84))
  call Hloop_QV_A(ntryL,G1H8(70),ex5(:),G1H4(58),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(58),51,0,G2H4(99),n2h4(85))
  call Hloop_AZ_Q(ntryL,G1H16(12),wf4(:,1),G1H4(63),ngZn,m3h4x4(:,16),heltab2x16(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(63),43,0,G2H4(100),n2h4(86))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(1),-16,ex5(:),16,G2H8(52),m3h2x8(:,116),heltab2x16(:,:,132))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,1),G1H4(64),ngZn,m3h4x4(:,17),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(64),43,0,G2H4(101),n2h4(87))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,1),G1H4(68),ngZn,m3h4x4(:,18),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(68),43,0,G2H4(102),n2h4(88))
  call Hloop_AZ_Q(ntryL,G1H16(6),wf4(:,1),G1H4(69),ngZn,m3h4x4(:,19),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(69),43,0,G2H4(103),n2h4(89))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,1),G1H4(70),ngZn,m3h4x4(:,20),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(70),39,0,G2H4(104),n2h4(90))
call HGT_raise_alpha_OLR(G1H16(11),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(11),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(11),-16,ex5(:),16,G2H8(53),m3h2x8(:,117),heltab2x16(:,:,137))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,1),G1H4(75),ngZn,m3h4x4(:,21),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(75),39,0,G2H4(105),n2h4(91))
  call Hloop_QZ_A(ntryL,G1H16(8),wf4(:,1),G1H4(76),ngZn,m3h4x4(:,22),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(76),39,0,G2H4(106),n2h4(92))
  call Hloop_QZ_A(ntryL,G1H16(7),wf4(:,1),G1H4(80),ngZn,m3h4x4(:,23),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(80),39,0,G2H4(107),n2h4(93))
  call Hloop_QV_A(ntryL,G1H16(9),ex5(:),G1H8(89),m3h2x8(:,118),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H8(89),49,0,G2H8(54),n2h8(78))
call HGT_raise_alpha_OLR(G1H16(14),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(14),-12,wf4(:,10),12,G2H4(108),m3h4x4(:,24),heltab2x16(:,:,142))
  call Hloop_QV_A(ntryL,G1H16(16),ex5(:),G1H8(3),m3h2x8(:,119),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G1H8(3),49,0,G2H8(55),n2h8(79))
  call Hloop_QV_A(ntryL,G1H16(17),ex5(:),G1H8(22),m3h2x8(:,120),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G1H8(22),49,0,G2H8(56),n2h8(80))
  call Hloop_QV_A(ntryL,G1H16(18),ex5(:),G1H8(23),m3h2x8(:,121),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H8(23),49,0,G2H8(57),n2h8(81))
  call Hloop_QV_A(ntryL,G1H16(19),ex5(:),G1H8(33),m3h2x8(:,122),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H8(33),49,0,G2H8(58),n2h8(82))
call HGT_raise_alpha_OLR(G1H16(20),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(20),-12,wf4(:,11),12,G2H4(109),m3h4x4(:,25),heltab2x16(:,:,147))
  call Hloop_QV_A(ntryL,G1H16(22),ex5(:),G1H8(34),m3h2x8(:,123),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H8(34),49,0,G2H8(59),n2h8(83))
  call Hloop_QV_A(ntryL,G1H16(23),ex5(:),G1H8(43),m3h2x8(:,124),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H8(43),49,0,G2H8(60),n2h8(84))
  call Hloop_QV_A(ntryL,G1H16(24),ex5(:),G1H8(44),m3h2x8(:,125),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H8(44),49,0,G2H8(61),n2h8(85))
  call Hloop_QV_A(ntryL,G1H16(25),ex5(:),G1H8(4),m3h2x8(:,126),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G1H8(4),49,0,G2H8(62),n2h8(86))
call HGT_raise_alpha_OLR(G1H16(26),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_WA_Q(ntryL,G1H16(26),ex2(:),G1H8(9),m3h2x8(:,127),heltab2x16(:,:,152))
  call Hloop_QV_A(ntryL,G1H16(28),ex5(:),G1H8(14),m3h2x8(:,128),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G1H8(14),49,0,G2H8(63),n2h8(87))
  call Hloop_QV_A(ntryL,G1H16(29),ex5(:),G1H8(18),m3h2x8(:,129),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G1H8(18),49,0,G2H8(64),n2h8(88))
  call Hloop_QV_A(ntryL,G1H16(30),ex5(:),G1H8(19),m3h2x8(:,130),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H8(19),49,0,G2H8(65),n2h8(89))
  call Hloop_QV_A(ntryL,G1H16(31),ex5(:),G1H8(25),m3h2x8(:,131),heltab2x16(:,:,156))
  call Hloop_Q_A(ntryL,G1H8(25),49,0,G2H8(66),n2h8(90))
call HGT_raise_alpha_OLR(G1H16(32),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_WA_Q(ntryL,G1H16(32),ex2(:),G1H8(36),m3h2x8(:,132),heltab2x16(:,:,157))
  call Hloop_QV_A(ntryL,G1H16(34),ex5(:),G1H8(15),m3h2x8(:,133),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H8(15),49,0,G2H8(67),n2h8(91))
  call Hloop_QV_A(ntryL,G1H16(35),ex5(:),G1H8(20),m3h2x8(:,134),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G1H8(20),49,0,G2H8(68),n2h8(92))
  call Hloop_QV_A(ntryL,G1H16(36),ex5(:),G1H8(26),m3h2x8(:,135),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H8(26),49,0,G2H8(69),n2h8(93))
  call Hloop_AV_Q(ntryL,G1H16(37),ex5(:),G1H8(31),m3h2x8(:,136),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G1H8(31),50,0,G2H8(70),n2h8(94))
call HGT_raise_alpha_OLR(G1H16(38),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(38),-12,wf4(:,10),12,G2H4(110),m3h4x4(:,26),heltab2x16(:,:,162))
  call Hloop_AV_Q(ntryL,G1H16(40),ex5(:),G1H8(38),m3h2x8(:,137),heltab2x16(:,:,163))
  call Hloop_A_Q(ntryL,G1H8(38),50,0,G2H8(71),n2h8(95))
  call Hloop_AV_Q(ntryL,G1H16(41),ex5(:),G1H8(37),m3h2x8(:,138),heltab2x16(:,:,164))
  call Hloop_A_Q(ntryL,G1H8(37),50,0,G2H8(72),n2h8(96))
  call Hloop_AV_Q(ntryL,G1H16(42),ex5(:),G1H8(2),m3h2x8(:,139),heltab2x16(:,:,165))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(73),n2h8(97))
  call Hloop_AV_Q(ntryL,G1H16(43),ex5(:),G1H8(1),m3h2x8(:,140),heltab2x16(:,:,166))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(74),n2h8(98))
call HGT_raise_alpha_OLR(G1H16(44),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(44),-12,wf4(:,11),12,G2H4(111),m3h4x4(:,27),heltab2x16(:,:,167))
  call Hloop_AV_Q(ntryL,G1H16(46),ex5(:),G1H8(7),m3h2x8(:,141),heltab2x16(:,:,168))
  call Hloop_A_Q(ntryL,G1H8(7),50,0,G2H8(75),n2h8(99))
  call Hloop_AV_Q(ntryL,G1H16(47),ex5(:),G1H8(6),m3h2x8(:,142),heltab2x16(:,:,169))
  call Hloop_A_Q(ntryL,G1H8(6),50,0,G2H8(76),n2h8(100))
  call Hloop_AV_Q(ntryL,G1H16(48),ex5(:),G1H8(28),m3h2x8(:,143),heltab2x16(:,:,170))
  call Hloop_A_Q(ntryL,G1H8(28),50,0,G2H8(77),n2h8(101))
  call Hloop_AV_Q(ntryL,G1H16(49),wf4(:,10),G1H4(81),m3h4x4(:,28),heltab2x16(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(81),46,0,G2H4(112),n2h4(94))
call HGT_raise_alpha_OLR(G1H16(50),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(50),-16,ex5(:),16,G2H8(78),m3h2x8(:,144),heltab2x16(:,:,172))
  call Hloop_AV_Q(ntryL,G1H16(52),wf4(:,10),G1H4(82),m3h4x4(:,29),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H4(82),46,0,G2H4(113),n2h4(95))
  call Hloop_AV_Q(ntryL,G1H16(67),wf4(:,10),G1H4(87),m3h4x4(:,30),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H4(87),46,0,G2H4(114),n2h4(96))
  call Hloop_AV_Q(ntryL,G1H16(68),wf4(:,10),G1H4(92),m3h4x4(:,31),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G1H4(92),46,0,G2H4(115),n2h4(97))
  call Hloop_AZ_Q(ntryL,G1H16(69),wf4(:,11),G1H4(50),ngZl,m3h4x4(:,32),heltab2x16(:,:,176))
  call Hloop_A_Q(ntryL,G1H4(50),46,0,G2H4(116),n2h4(98))
call HGT_raise_alpha_OLR(G1H16(70),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(70),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(70),-16,ex5(:),16,G2H8(79),m3h2x8(:,145),heltab2x16(:,:,177))
  call Hloop_AZ_Q(ntryL,G1H16(72),wf4(:,11),G1H4(62),ngZl,m3h4x4(:,33),heltab2x16(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(62),46,0,G2H4(117),n2h4(99))
  call Hloop_AZ_Q(ntryL,G1H16(73),wf4(:,11),G1H4(74),ngZl,m3h4x4(:,34),heltab2x16(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(74),46,0,G2H4(118),n2h4(100))
  call Hloop_AZ_Q(ntryL,G1H16(74),wf4(:,11),G1H4(3),ngZl,m3h4x4(:,35),heltab2x16(:,:,180))
  call Hloop_A_Q(ntryL,G1H4(3),46,0,G2H4(119),n2h4(101))
  call Hloop_QV_A(ntryL,G1H16(75),wf4(:,10),G1H4(4),m3h4x4(:,36),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(120),n2h4(102))
call HGT_raise_alpha_OLR(G1H16(76),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(76),2,5,16)
  call Hloop_WA_Q(ntryL,G1H16(76),ex2(:),G1H8(13),m3h2x8(:,146),heltab2x16(:,:,182))
  call Hloop_QV_A(ntryL,G1H16(78),wf4(:,10),G1H4(8),m3h4x4(:,37),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(8),45,0,G2H4(121),n2h4(103))
  call Hloop_QV_A(ntryL,G1H16(79),wf4(:,10),G1H4(9),m3h4x4(:,38),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(9),45,0,G2H4(122),n2h4(104))
  call Hloop_QV_A(ntryL,G1H16(80),wf4(:,10),G1H4(16),m3h4x4(:,39),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(16),45,0,G2H4(123),n2h4(105))
  call Hloop_QZ_A(ntryL,G1H16(81),wf4(:,11),G1H4(21),ngZl,m3h4x4(:,40),heltab2x16(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(21),45,0,G2H4(124),n2h4(106))
call HGT_raise_alpha_OLR(G1H16(82),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(82),2,5,16)
  call Hloop_WA_Q(ntryL,G1H16(82),ex2(:),G1H8(17),m3h2x8(:,147),heltab2x16(:,:,187))
  call Hloop_QZ_A(ntryL,G1H16(84),wf4(:,11),G1H4(22),ngZl,m3h4x4(:,41),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(22),45,0,G2H4(125),n2h4(107))
  call Hloop_QZ_A(ntryL,G1H16(85),wf4(:,11),G1H4(26),ngZl,m3h4x4(:,42),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G1H4(26),45,0,G2H4(126),n2h4(108))
  call Hloop_QZ_A(ntryL,G1H16(86),wf4(:,11),G1H4(27),ngZl,m3h4x4(:,43),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G1H4(27),45,0,G2H4(127),n2h4(109))
  call Hloop_QV_A(ntryL,G1H16(53),wf4(:,10),G1H4(28),m3h4x4(:,44),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G1H4(28),45,0,G2H4(128),n2h4(110))
call HGT_raise_alpha_OLR(G1H16(54),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(54),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(54),-16,ex5(:),16,G2H8(80),m3h2x8(:,148),heltab2x16(:,:,192))
  call Hloop_QV_A(ntryL,G1H16(56),wf4(:,10),G1H4(32),m3h4x4(:,45),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G1H4(32),45,0,G2H4(129),n2h4(111))
  call Hloop_QV_A(ntryL,G1H16(57),wf4(:,10),G1H4(33),m3h4x4(:,46),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G1H4(33),45,0,G2H4(130),n2h4(112))
  call Hloop_QV_A(ntryL,G1H16(58),wf4(:,10),G1H4(39),m3h4x4(:,47),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(39),45,0,G2H4(131),n2h4(113))
  call Hloop_QZ_A(ntryL,G1H16(59),wf4(:,11),G1H4(40),ngZl,m3h4x4(:,48),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H4(40),45,0,G2H4(132),n2h4(114))
call HGT_raise_alpha_OLR(G1H16(60),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(60),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(60),-16,ex5(:),16,G2H8(81),m3h2x8(:,149),heltab2x16(:,:,197))
  call Hloop_QZ_A(ntryL,G1H16(88),wf4(:,11),G1H4(44),ngZl,m3h4x4(:,49),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(44),45,0,G2H4(133),n2h4(115))
  call Hloop_QZ_A(ntryL,G1H16(89),wf4(:,11),G1H4(58),ngZl,m3h4x4(:,50),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G1H4(58),45,0,G2H4(134),n2h4(116))
  call Hloop_QZ_A(ntryL,G1H16(90),wf4(:,11),G1H4(63),ngZl,m3h4x4(:,51),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G1H4(63),45,0,G2H4(135),n2h4(117))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(13),G1H4(73),G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(16),G1H4(85),G1H4(61)])
call HGT_lower_alpha_OLR(G2H4(23),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(23),2,5,4)
call HGT_lower_alpha_OLR(G2H4(23),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(10)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(56)])
call HGT_lower_alpha_OLR(G2H4(34),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(34),2,5,4)
call HGT_lower_alpha_OLR(G2H4(34),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(14)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G1H4(71)])
call HGT_lower_alpha_w2_OLR(G2H4(41),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(41),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(41),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(5),G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(47),G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(45),G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G1H4(15),G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G1H4(20),G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(116),[G2H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(118),[G2H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(119),[G2H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(124),[G2H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(126),[G2H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(127),[G2H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(132),[G2H4(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(134),[G2H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(135),[G2H4(131)])
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(32),mass5set(:,2),  & 
G1H4(64),G1H4(68),G1H4(69),G1H4(70),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(68),8,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(33),mass5set(:,2),  & 
G1H4(80),G1H4(81),G1H4(82),G1H4(87),G1H4(92),G1H4(50),4)
  call HG1shiftOLR(G1H4(81),4,4)
call HGT_lower_alpha_OLR(G2H4(19),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(19),2,5,4)
call HGT_lower_alpha_OLR(G2H4(19),6,15,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(34),mass5set(:,2),  & 
G1H4(62),G1H4(74),G1H4(3),G1H4(4),G1H4(8),G1H4(9),4)
  call HG1shiftOLR(G1H4(74),2,4)
  call Hloop_QA_W(ntryL,G2H4(20),ex2(:),G2H2(1),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(35),mass5set(:,2),  & 
G1H4(16),G1H4(21),G1H4(22),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(21),8,4)
  call Hloop_QA_W(ntryL,G2H4(24),ex4(:),G2H2(2),m3h2x2(:,57),heltab2x4(:,:,57))
call HGT_lower_alpha_OLR(G2H4(27),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(27),2,5,4)
call HGT_lower_alpha_OLR(G2H4(27),6,15,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(36),mass5set(:,2),  & 
G1H4(32),G1H4(33),G1H4(39),G1H4(40),G1H4(44),G1H4(58),4)
  call HG1shiftOLR(G1H4(33),1,4)
  call Hloop_AQ_W(ntryL,G2H4(28),ex1(:),G2H2(3),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_UW_V(ntryL,G1H4(1),43,ex5(:),16,G2H2(4),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(37),mass5set(:,2),  & 
G1H4(63),G1H4(73),G1H4(49),G1H4(85),G1H4(61),G1H4(10),4)
  call HG1shiftOLR(G1H4(73),4,4)
  call Hloop_AQ_W(ntryL,G2H4(35),ex3(:),G2H2(5),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_UV_W(ntryL,G1H4(2),39,ex5(:),16,G2H2(7),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(38),mass5set(:,12),  & 
G1H4(56),G1H4(14),G1H4(51),G1H4(71),G1H4(5),G1H4(7),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hloop_QA_W(ntryL,G2H4(51),ex4(:),G2H2(9),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_ZQ_A(ntryL,G1H4(52),ex3(:),G1H2(9),ngZl,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(9),47,0,G2H2(11),n2h2(25))
  call Hloop_ZQ_A(ntryL,G1H4(6),ex3(:),G1H2(10),ngZl,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(10),47,0,G2H2(13),n2h2(26))
  call Hloop_ZQ_A(ntryL,G1H4(19),ex3(:),G1H2(15),ngZl,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(15),47,0,G2H2(15),n2h2(27))
  call Hloop_ZA_Q(ntryL,G1H4(46),ex4(:),G1H2(16),ngZl,m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(16),47,0,G2H2(18),n2h2(28))
  call Hloop_ZA_Q(ntryL,G1H4(12),ex4(:),G1H2(21),ngZl,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(21),47,0,G2H2(21),n2h2(29))
  call Hloop_ZA_Q(ntryL,G1H4(25),ex4(:),G1H2(22),ngZl,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(22),47,0,G2H2(24),n2h2(30))
  call Hloop_ZQ_A(ntryL,G1H4(57),ex3(:),G1H2(27),ngZl,m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(27),47,0,G2H2(27),n2h2(31))
  call Hloop_ZQ_A(ntryL,G1H4(18),ex3(:),G1H2(28),ngZl,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(28),47,0,G2H2(30),n2h2(32))
  call Hloop_ZA_Q(ntryL,G1H4(45),ex4(:),G1H2(33),ngZl,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(33),47,0,G2H2(33),n2h2(33))
  call Hloop_ZA_Q(ntryL,G1H4(24),ex4(:),G1H2(34),ngZl,m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(34),47,0,G2H2(36),n2h2(34))
  call Hloop_WQ_A(ntryL,G1H4(29),ex1(:),G1H2(39),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(39),47,0,G2H2(39),n2h2(35))
  call Hloop_WQ_A(ntryL,G1H4(30),ex1(:),G1H2(40),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(40),47,0,G2H2(42),n2h2(36))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(29),mass5set(:,4),  & 
G1H4(11),G1H4(13),G1H4(17),G1H4(23),G1H4(31),G1H4(37),4)
  call HG1shiftOLR(G1H4(13),16,4)
  call Hloop_WA_Q(ntryL,G1H4(35),ex2(:),G1H2(45),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(45),47,0,G2H2(45),n2h2(37))
  call Hloop_WA_Q(ntryL,G1H4(36),ex2(:),G1H2(46),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(46),47,0,G2H2(48),n2h2(38))
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(31),mass5set(:,4),  & 
G1H4(43),G1H4(47),G1H4(48),G1H4(55),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(47),16,4)
  call Hloop_UW_V(ntryL,G1H4(41),45,ex5(:),16,G2H2(49),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_UW_V(ntryL,G1H4(42),45,ex5(:),16,G2H2(50),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(30),mass5set(:,13),  & 
G1H4(67),G1H4(15),G1H4(72),G1H4(78),G1H4(83),G1H4(20),4)
  call HG1shiftOLR(G1H4(15),2,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(39),mass5set(:,14),  & 
G1H4(84),G1H4(90),G1H4(34),G1H4(1),G1H4(2),G1H4(52),4)
  call HG1shiftOLR(G1H4(90),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(40),mass5set(:,2),  & 
G1H4(6),G1H4(19),G1H4(46),G1H4(12),G1H4(25),G1H4(57),4)
  call HG1shiftOLR(G1H4(19),8,4)
  call Hloop_WQ_A(ntryL,G1H4(53),ex3(:),G1H2(51),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(51),55,0,G2H2(51),n2h2(39))
  call Hloop_WQ_A(ntryL,G1H4(54),ex3(:),G1H2(52),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(52),55,0,G2H2(52),n2h2(40))
  call Hloop_WQ_A(ntryL,G1H4(79),ex3(:),G1H2(57),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(57),55,0,G2H2(53),n2h2(41))
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(41),mass5set(:,14),  & 
G1H4(18),G1H4(45),G1H4(24),G1H4(29),G1H4(30),G1H4(35),4)
  call HG1shiftOLR(G1H4(45),4,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(42),mass5set(:,2),  & 
G1H4(36),G1H4(41),G1H4(42),G1H4(53),G1H4(54),G1H4(79),4)
  call HG1shiftOLR(G1H4(41),4,4)
  call Hloop_WA_Q(ntryL,G1H4(65),ex4(:),G1H2(58),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(58),59,0,G2H2(54),n2h2(42))
  call Hloop_WA_Q(ntryL,G1H4(66),ex4(:),G1H2(63),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(63),59,0,G2H2(55),n2h2(43))
  call Hloop_WA_Q(ntryL,G1H4(91),ex4(:),G1H2(64),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(64),59,0,G2H2(56),n2h2(44))
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(23),mass5set(:,9),  & 
G1H4(65),G1H4(66),G1H4(91),G1H4(93),G1H4(94),G1H4(95),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hloop_WQ_A(ntryL,G1H4(77),ex3(:),G1H2(69),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(69),55,0,G2H2(57),n2h2(45))
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(93),mass4set(:,1),  & 
G1H4(77),G1H4(96),G1H4(97),G1H4(98),G1H4(99),4)
  call HG1shiftOLR(G1H4(96),8,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(43),mass5set(:,12),  & 
G1H4(100),G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),4)
  call HG1shiftOLR(G1H4(101),4,4)
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(25),mass5set(:,9),  & 
G1H4(106),G1H4(107),G1H4(108),G1H4(109),G1H4(110),G1H4(111),4)
  call HG1shiftOLR(G1H4(107),4,4)
  call Hloop_WA_Q(ntryL,G1H4(89),ex4(:),G1H2(70),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(70),59,0,G2H2(58),n2h2(46))
  call Hotf_4pt_reduction(G2H4(78),RedSet_4(102),mass4set(:,1),  & 
G1H4(89),G1H4(112),G1H4(113),G1H4(114),G1H4(115),4)
  call HG1shiftOLR(G1H4(112),4,4)
  call Hloop_AQ_W(ntryL,G2H4(8),ex1(:),G2H2(59),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_QA_W(ntryL,G2H4(10),ex2(:),G2H2(60),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_QA_W(ntryL,G2H4(12),ex2(:),G2H2(61),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_QA_W(ntryL,G2H4(14),ex4(:),G2H2(62),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_AQ_W(ntryL,G2H4(15),ex1(:),G2H2(63),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_AQ_W(ntryL,G2H4(18),ex3(:),G2H2(64),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_QA_W(ntryL,G2H4(22),ex4(:),G2H2(65),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_QA_W(ntryL,G2H4(25),ex4(:),G2H2(66),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(24),mass5set(:,10),  & 
G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),G1H4(121),4)
  call HG1shiftOLR(G1H4(117),16,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(24),mass5set(:,15),  & 
G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),G1H4(127),4)
  call HG1shiftOLR(G1H4(123),16,4)
  call Hloop_AQ_W(ntryL,G2H4(33),ex3(:),G2H2(67),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(44),mass5set(:,10),  & 
G1H8(24),G1H8(45),G1H8(46),G1H8(47),G1H8(35),G1H8(48),8)
  call HG1shiftOLR(G1H8(45),16,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(44),mass5set(:,16),  & 
G1H8(50),G1H8(51),G1H8(52),G1H8(41),G1H8(42),G1H8(11),8)
  call HG1shiftOLR(G1H8(51),16,8)
  call Hloop_VV_S(ntryL,G1H8(27),wf4(:,1),G1H2(75),m3h4x2(:,1),heltab2x8(:,:,130))
  call Hloop_UW_V(ntryL,G1H8(71),44,wf4(:,1),3,G2H2(68),m3h4x2(:,2),heltab2x8(:,:,131))
  call Hloop_VV_S(ntryL,G2H8(17),wf4(:,1),G2H2(69),m3h4x2(:,3),heltab2x8(:,:,132))
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(44),mass5set(:,3),  & 
G1H8(53),G1H8(54),G1H8(55),G1H8(56),G1H8(58),G1H8(59),8)
  call HG1shiftOLR(G1H8(54),16,8)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(21),mass5set(:,10),  & 
G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),G1H4(133),4)
  call HG1shiftOLR(G1H4(129),16,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(21),mass5set(:,15),  & 
G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),4)
  call HG1shiftOLR(G1H4(135),16,4)
  call Hloop_QA_W(ntryL,G2H4(39),ex4(:),G2H2(70),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(45),mass5set(:,10),  & 
G1H8(60),G1H8(16),G1H8(21),G1H8(62),G1H8(63),G1H8(64),8)
  call HG1shiftOLR(G1H8(16),16,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(45),mass5set(:,16),  & 
G1H8(65),G1H8(66),G1H8(68),G1H8(69),G1H8(70),G1H8(89),8)
  call HG1shiftOLR(G1H8(66),16,8)
  call Hloop_VV_S(ntryL,G1H8(32),wf4(:,1),G1H2(76),m3h4x2(:,4),heltab2x8(:,:,133))
  call Hloop_UV_W(ntryL,G1H8(72),44,wf4(:,1),3,G2H2(71),m3h4x2(:,5),heltab2x8(:,:,134))
  call Hloop_VV_S(ntryL,G2H8(24),wf4(:,1),G2H2(72),m3h4x2(:,6),heltab2x8(:,:,135))
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(45),mass5set(:,3),  & 
G1H8(3),G1H8(22),G1H8(23),G1H8(33),G1H8(34),G1H8(43),8)
  call HG1shiftOLR(G1H8(22),16,8)
  call Hloop_AQ_W(ntryL,G2H4(40),ex3(:),G2H2(73),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_QA_W(ntryL,G2H4(43),ex4(:),G2H2(74),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(6),mass5set(:,17),  & 
G1H8(44),G1H8(4),G1H8(14),G1H8(18),G1H8(19),G1H8(25),8)
  call HG1shiftOLR(G1H8(4),12,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(6),mass5set(:,17),  & 
G1H8(15),G1H8(20),G1H8(26),G1H8(31),G1H8(38),G1H8(37),8)
  call HG1shiftOLR(G1H8(20),12,8)
  call Hloop_VV_S(ntryL,G1H8(73),ex5(:),G1H4(140),m3h2x4(:,130),heltab2x8(:,:,136))
  call Hloop_VV_S(ntryL,G1H8(74),ex5(:),G1H4(141),m3h2x4(:,131),heltab2x8(:,:,137))
  call Hloop_VV_S(ntryL,G2H8(9),ex5(:),G2H4(13),m3h2x4(:,132),heltab2x8(:,:,138))
  call Hloop_VV_S(ntryL,G2H8(12),ex5(:),G2H4(16),m3h2x4(:,133),heltab2x8(:,:,139))
  call Hloop_UW_V(ntryL,G1H8(75),35,ex5(:),16,G2H4(17),m3h2x4(:,134),heltab2x8(:,:,140))
  call Hloop_UW_V(ntryL,G1H8(76),35,ex5(:),16,G2H4(42),m3h2x4(:,135),heltab2x8(:,:,141))
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(6),mass5set(:,3),  & 
G1H8(2),G1H8(1),G1H8(7),G1H8(6),G1H8(28),G1H8(27),8)
  call HG1shiftOLR(G1H8(1),12,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(6),mass5set(:,3),  & 
G1H8(71),G1H8(32),G1H8(72),G1H8(73),G1H8(74),G1H8(75),8)
  call HG1shiftOLR(G1H8(32),12,8)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(22),mass5set(:,18),  & 
G1H4(142),G1H4(143),G1H4(144),G1H4(145),G1H4(146),G1H4(147),4)
  call HG1shiftOLR(G1H4(143),16,4)
  call Hloop_AQ_W(ntryL,G2H4(2),ex1(:),G2H2(75),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(8),mass5set(:,17),  & 
G1H8(76),G1H8(90),G1H8(91),G1H8(92),G1H8(93),G1H8(94),8)
  call HG1shiftOLR(G1H8(90),12,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(8),mass5set(:,17),  & 
G1H8(95),G1H8(96),G1H8(97),G1H8(98),G1H8(99),G1H8(100),8)
  call HG1shiftOLR(G1H8(96),12,8)
  call Hloop_VV_S(ntryL,G1H8(40),ex5(:),G1H4(148),m3h2x4(:,136),heltab2x8(:,:,142))
  call Hloop_VV_S(ntryL,G1H8(77),ex5(:),G1H4(149),m3h2x4(:,137),heltab2x8(:,:,143))
  call Hloop_VV_S(ntryL,G2H8(7),ex5(:),G2H4(5),m3h2x4(:,138),heltab2x8(:,:,144))
  call Hloop_VV_S(ntryL,G2H8(8),ex5(:),G2H4(47),m3h2x4(:,139),heltab2x8(:,:,145))
  call Hloop_UV_W(ntryL,G1H8(78),35,ex5(:),16,G2H4(45),m3h2x4(:,140),heltab2x8(:,:,146))
  call Hloop_UV_W(ntryL,G1H8(79),35,ex5(:),16,G2H4(7),m3h2x4(:,141),heltab2x8(:,:,147))
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(8),mass5set(:,3),  & 
G1H8(40),G1H8(77),G1H8(78),G1H8(79),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(77),12,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(8),mass5set(:,3),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),12,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(46),mass5set(:,17),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),16,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(46),mass5set(:,17),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),16,8)
  call Hloop_VV_S(ntryL,G1H8(80),wf4(:,10),G1H2(9),m3h4x2(:,7),heltab2x8(:,:,148))
  call Hloop_VV_S(ntryL,G1H8(81),wf4(:,11),G1H2(10),m3h4x2(:,8),heltab2x8(:,:,149))
  call Hloop_UV_W(ntryL,G1H8(82),35,wf4(:,10),12,G2H2(76),m3h4x2(:,9),heltab2x8(:,:,150))
  call Hloop_UV_W(ntryL,G1H8(83),35,wf4(:,11),12,G2H2(77),m3h4x2(:,10),heltab2x8(:,:,151))
  call Hloop_VV_S(ntryL,G2H8(18),wf4(:,10),G2H2(78),m3h4x2(:,11),heltab2x8(:,:,152))
  call Hloop_VV_S(ntryL,G2H8(25),wf4(:,11),G2H2(79),m3h4x2(:,12),heltab2x8(:,:,153))
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(46),mass5set(:,3),  & 
G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(121),G1H8(122),8)
  call HG1shiftOLR(G1H8(81),16,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(46),mass5set(:,3),  & 
G1H8(123),G1H8(124),G1H8(125),G1H8(126),G1H8(127),G1H8(128),8)
  call HG1shiftOLR(G1H8(124),16,8)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(20),mass5set(:,18),  & 
G1H4(150),G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),4)
  call HG1shiftOLR(G1H4(151),16,4)
  call Hloop_QA_W(ntryL,G2H4(4),ex2(:),G2H2(80),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(47),mass5set(:,17),  & 
G1H8(129),G1H8(130),G1H8(131),G1H8(132),G1H8(133),G1H8(134),8)
  call HG1shiftOLR(G1H8(130),16,8)
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(47),mass5set(:,17),  & 
G1H8(135),G1H8(136),G1H8(137),G1H8(138),G1H8(139),G1H8(140),8)
  call HG1shiftOLR(G1H8(136),16,8)
  call Hloop_VV_S(ntryL,G1H8(12),wf4(:,10),G1H2(15),m3h4x2(:,13),heltab2x8(:,:,154))
  call Hloop_VV_S(ntryL,G1H8(84),wf4(:,11),G1H2(16),m3h4x2(:,14),heltab2x8(:,:,155))
  call Hloop_UW_V(ntryL,G1H8(85),35,wf4(:,10),12,G2H2(81),m3h4x2(:,15),heltab2x8(:,:,156))
  call Hloop_UW_V(ntryL,G1H8(86),35,wf4(:,11),12,G2H2(82),m3h4x2(:,16),heltab2x8(:,:,157))
  call Hloop_VV_S(ntryL,G2H8(29),wf4(:,10),G2H2(83),m3h4x2(:,17),heltab2x8(:,:,158))
  call Hloop_VV_S(ntryL,G2H8(30),wf4(:,11),G2H2(84),m3h4x2(:,18),heltab2x8(:,:,159))
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(47),mass5set(:,3),  & 
G1H8(12),G1H8(84),G1H8(85),G1H8(86),G1H8(141),G1H8(142),8)
  call HG1shiftOLR(G1H8(84),16,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(47),mass5set(:,3),  & 
G1H8(143),G1H8(144),G1H8(145),G1H8(146),G1H8(147),G1H8(148),8)
  call HG1shiftOLR(G1H8(144),16,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(2),mass5set(:,4),  & 
G1H8(149),G1H8(150),G1H8(151),G1H8(152),G1H8(153),G1H8(154),8)
  call HG1shiftOLR(G1H8(150),12,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(2),mass5set(:,4),  & 
G1H8(155),G1H8(156),G1H8(157),G1H8(158),G1H8(159),G1H8(160),8)
  call HG1shiftOLR(G1H8(156),12,8)
  call Hloop_QA_W(ntryL,G2H8(35),ex2(:),G2H4(49),m3h2x4(:,142),heltab2x8(:,:,160))
  call Hloop_QA_W(ntryL,G2H8(36),ex2(:),G2H4(112),m3h2x4(:,143),heltab2x8(:,:,161))
  call Hloop_SV_V(ntryL,G1H8(87),wf4(:,10),G1H2(21),m3h4x2(:,19),heltab2x8(:,:,162))
  call Hloop_SV_V(ntryL,G1H8(88),wf4(:,11),G1H2(22),m3h4x2(:,20),heltab2x8(:,:,163))
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(28),mass5set(:,13),  & 
G1H8(87),G1H8(88),G1H8(161),G1H8(162),G1H8(163),G1H8(164),8)
  call HG1shiftOLR(G1H8(88),2,8)
  call Hotf_5pt_reduction(G2H8(38),RedSet_5(28),mass5set(:,13),  & 
G1H8(165),G1H8(166),G1H8(167),G1H8(168),G1H8(169),G1H8(170),8)
  call HG1shiftOLR(G1H8(166),2,8)
  call Hotf_5pt_reduction(G2H8(39),RedSet_5(1),mass5set(:,4),  & 
G1H8(171),G1H8(172),G1H8(173),G1H8(174),G1H8(175),G1H8(176),8)
  call HG1shiftOLR(G1H8(172),12,8)
  call Hotf_5pt_reduction(G2H8(40),RedSet_5(1),mass5set(:,4),  & 
G1H8(177),G1H8(178),G1H8(179),G1H8(180),G1H8(181),G1H8(182),8)
  call HG1shiftOLR(G1H8(178),12,8)
  call Hloop_AQ_W(ntryL,G2H8(41),ex1(:),G2H4(114),m3h2x4(:,144),heltab2x8(:,:,164))
  call Hloop_AQ_W(ntryL,G2H8(42),ex1(:),G2H4(115),m3h2x4(:,145),heltab2x8(:,:,165))
  call Hloop_AQ_W(ntryL,G2H4(44),ex1(:),G2H2(85),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_SV_V(ntryL,G1H4(38),ex5(:),G1H2(27),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_QA_W(ntryL,G2H4(50),ex2(:),G2H2(86),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_QA_Z(ntryL,G2H8(43),ex2(:),G2H4(120),ngZn,m3h2x4(:,146),heltab2x8(:,:,166))
  call Hotf_5pt_reduction(G2H8(44),RedSet_5(7),mass5set(:,2),  & 
G1H8(183),G1H8(184),G1H8(185),G1H8(186),G1H8(187),G1H8(188),8)
  call HG1shiftOLR(G1H8(184),20,8)
  call Hloop_AQ_Z(ntryL,G2H8(45),ex1(:),G2H4(122),ngZn,m3h2x4(:,147),heltab2x8(:,:,167))
  call Hotf_5pt_reduction(G2H8(46),RedSet_5(18),mass5set(:,2),  & 
G1H8(189),G1H8(190),G1H8(191),G1H8(192),G1H8(193),G1H8(194),8)
  call HG1shiftOLR(G1H8(190),8,8)
  call Hotf_5pt_reduction(G2H8(47),RedSet_5(4),mass5set(:,2),  & 
G1H8(195),G1H8(196),G1H8(197),G1H8(198),G1H8(199),G1H8(200),8)
  call HG1shiftOLR(G1H8(196),24,8)
  call Hloop_QA_Z(ntryL,G2H8(48),ex2(:),G2H4(123),ngZn,m3h2x4(:,148),heltab2x8(:,:,168))
  call Hotf_5pt_reduction(G2H8(49),RedSet_5(19),mass5set(:,2),  & 
G1H8(201),G1H8(202),G1H8(203),G1H8(204),G1H8(205),G1H8(206),8)
  call HG1shiftOLR(G1H8(202),4,8)
  call Hloop_AQ_Z(ntryL,G2H8(50),ex1(:),G2H4(128),ngZn,m3h2x4(:,149),heltab2x8(:,:,169))
  call Hloop_QA_W(ntryL,G2H8(51),wf4(:,9),G2H2(87),m3h4x2(:,21),heltab2x8(:,:,170))
  call Hloop_QA_W(ntryL,G2H4(52),ex2(:),G2H2(88),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_QA_W(ntryL,G2H4(55),ex2(:),G2H2(89),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_QA_W(ntryL,G2H4(56),ex2(:),G2H2(90),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_QA_W(ntryL,G2H4(57),ex4(:),G2H2(91),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_QA_W(ntryL,G2H4(60),ex4(:),G2H2(92),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_QA_W(ntryL,G2H4(61),ex4(:),G2H2(93),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_AQ_W(ntryL,G2H4(62),ex1(:),G2H2(94),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_AQ_W(ntryL,G2H4(65),ex1(:),G2H2(95),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_AQ_W(ntryL,G2H4(66),ex1(:),G2H2(96),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hotf_4pt_reduction(G2H4(70),RedSet_4(94),mass4set(:,2),  & 
G1H4(38),G1H4(156),G1H4(157),G1H4(158),G1H4(159),4)
  call HG1shiftOLR(G1H4(156),12,4)
  call Hloop_AQ_W(ntryL,G2H4(71),ex3(:),G2H2(97),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_AQ_W(ntryL,G2H4(74),ex3(:),G2H2(98),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_AQ_W(ntryL,G2H4(75),ex3(:),G2H2(99),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hotf_4pt_reduction(G2H4(79),RedSet_4(94),mass4set(:,2),  & 
G1H4(160),G1H4(161),G1H4(162),G1H4(163),G1H4(164),4)
  call HG1shiftOLR(G1H4(161),12,4)
  call Hloop_AQ_V(ntryL,G2H4(80),ex3(:),G2H2(100),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_AQ_V(ntryL,G2H4(83),ex3(:),G2H2(101),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_AQ_V(ntryL,G2H4(84),ex3(:),G2H2(102),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_AQ_Z(ntryL,G2H4(85),ex3(:),G2H2(103),ngZl,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_AQ_Z(ntryL,G2H4(88),ex3(:),G2H2(104),ngZl,m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_AQ_Z(ntryL,G2H4(89),ex3(:),G2H2(105),ngZl,m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_QA_V(ntryL,G2H4(90),ex4(:),G2H2(106),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_QA_V(ntryL,G2H4(93),ex4(:),G2H2(107),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_QA_V(ntryL,G2H4(94),ex4(:),G2H2(108),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_QA_Z(ntryL,G2H4(95),ex4(:),G2H2(109),ngZl,m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_QA_Z(ntryL,G2H4(98),ex4(:),G2H2(110),ngZl,m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_QA_Z(ntryL,G2H4(99),ex4(:),G2H2(111),ngZl,m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_AQ_W(ntryL,G2H4(100),ex3(:),G2H2(112),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_AQ_W(ntryL,G2H4(102),ex3(:),G2H2(113),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_AQ_W(ntryL,G2H4(103),ex3(:),G2H2(114),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_QA_W(ntryL,G2H4(104),ex4(:),G2H2(115),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_QA_W(ntryL,G2H4(106),ex4(:),G2H2(116),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_QA_W(ntryL,G2H4(107),ex4(:),G2H2(117),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_QA_W(ntryL,G2H8(54),ex2(:),G2H4(130),m3h2x4(:,150),heltab2x8(:,:,171))
  call Hloop_QA_W(ntryL,G2H8(56),ex2(:),G2H4(131),m3h2x4(:,151),heltab2x8(:,:,172))
  call Hloop_QA_W(ntryL,G2H8(57),ex2(:),G2H4(31),m3h2x4(:,152),heltab2x8(:,:,173))
  call Hloop_QA_W(ntryL,G2H8(58),ex2(:),G2H4(38),m3h2x4(:,153),heltab2x8(:,:,174))
  call Hloop_QA_W(ntryL,G2H8(60),ex2(:),G2H4(19),m3h2x4(:,154),heltab2x8(:,:,175))
  call Hloop_QA_W(ntryL,G2H8(61),ex2(:),G2H4(20),m3h2x4(:,155),heltab2x8(:,:,176))
  call Hotf_5pt_reduction(G2H8(62),RedSet_5(28),mass5set(:,7),  & 
G1H8(207),G1H8(208),G1H8(209),G1H8(210),G1H8(211),G1H8(212),8)
  call HG1shiftOLR(G1H8(208),2,8)
  call Hotf_4pt_reduction(G2H8(64),RedSet_4(115),mass4set(:,3),  & 
G1H8(213),G1H8(214),G1H8(215),G1H8(216),G1H8(217),8)
  call HG1shiftOLR(G1H8(214),2,8)
  call Hotf_4pt_reduction(G2H8(65),RedSet_4(86),mass4set(:,3),  & 
G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(219),14,8)
  call Hotf_5pt_reduction(G2H8(66),RedSet_5(28),mass5set(:,7),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),2,8)
  call Hotf_4pt_reduction(G2H8(68),RedSet_4(115),mass4set(:,3),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),8)
  call HG1shiftOLR(G1H8(230),2,8)
  call Hotf_4pt_reduction(G2H8(69),RedSet_4(86),mass4set(:,3),  & 
G1H8(234),G1H8(235),G1H8(236),G1H8(237),G1H8(238),8)
  call HG1shiftOLR(G1H8(235),14,8)
  call Hloop_AQ_W(ntryL,G2H8(70),ex1(:),G2H4(23),m3h2x4(:,156),heltab2x8(:,:,177))
  call Hloop_AQ_W(ntryL,G2H8(72),ex1(:),G2H4(24),m3h2x4(:,157),heltab2x8(:,:,178))
  call Hloop_AQ_W(ntryL,G2H8(73),ex1(:),G2H4(27),m3h2x4(:,158),heltab2x8(:,:,179))
  call Hloop_AQ_W(ntryL,G2H8(74),ex1(:),G2H4(28),m3h2x4(:,159),heltab2x8(:,:,180))
  call Hloop_AQ_W(ntryL,G2H8(76),ex1(:),G2H4(34),m3h2x4(:,160),heltab2x8(:,:,181))
  call Hloop_AQ_W(ntryL,G2H8(77),ex1(:),G2H4(35),m3h2x4(:,161),heltab2x8(:,:,182))
  call Hloop_AQ_W(ntryL,G2H4(116),ex1(:),G2H2(118),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_AQ_W(ntryL,G2H4(118),ex1(:),G2H2(119),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_AQ_W(ntryL,G2H4(119),ex1(:),G2H2(120),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hotf_5pt_reduction(G2H4(124),RedSet_5(30),mass5set(:,7),  & 
G1H4(165),G1H4(166),G1H4(167),G1H4(168),G1H4(169),G1H4(170),4)
  call HG1shiftOLR(G1H4(166),2,4)
  call Hotf_4pt_reduction(G2H4(126),RedSet_4(115),mass4set(:,3),  & 
G1H4(171),G1H4(172),G1H4(173),G1H4(174),G1H4(175),4)
  call HG1shiftOLR(G1H4(172),2,4)
  call Hotf_4pt_reduction(G2H4(127),RedSet_4(177),mass4set(:,3),  & 
G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(177),18,4)
  call Hloop_QA_W(ntryL,G2H4(132),ex2(:),G2H2(121),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_QA_W(ntryL,G2H4(134),ex2(:),G2H2(122),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_QA_W(ntryL,G2H4(135),ex2(:),G2H2(123),m3h2x2(:,139),heltab2x4(:,:,139))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(160),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(213),[G1H8(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(218),[G1H8(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(229),[G1H8(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(234),[G1H8(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(171),[G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(176),[G1H4(170)])
  call Hloop_WQ_A(ntryL,G1H4(64),ex3(:),G1H2(28),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(28),55,0,G2H2(124),n2h2(47))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(68),ex4(:),G1H2(33),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_WQ_A(ntryL,G1H4(75),ex3(:),G1H2(34),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(34),55,0,G2H2(125),n2h2(48))
  call Hloop_WQ_A(ntryL,G1H4(76),ex3(:),G1H2(39),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(39),55,0,G2H2(126),n2h2(49))
  call Hloop_WA_Q(ntryL,G1H4(80),ex4(:),G1H2(40),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(40),59,0,G2H2(127),n2h2(50))
call HGT_raise_alpha_OLR(G1H4(81),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(81),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(81),ex3(:),G1H2(45),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_WA_Q(ntryL,G1H4(92),ex4(:),G1H2(46),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(46),59,0,G2H2(128),n2h2(51))
  call Hloop_WA_Q(ntryL,G1H4(50),ex4(:),G1H2(51),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(51),59,0,G2H2(129),n2h2(52))
  call Hloop_WQ_A(ntryL,G1H4(62),ex1(:),G1H2(52),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(52),61,0,G2H2(130),n2h2(53))
call HGT_raise_alpha_OLR(G1H4(74),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(74),ex2(:),G1H2(57),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_WQ_A(ntryL,G1H4(8),ex1(:),G1H2(58),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(58),61,0,G2H2(131),n2h2(54))
  call Hloop_WQ_A(ntryL,G1H4(9),ex1(:),G1H2(63),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(63),61,0,G2H2(132),n2h2(55))
  call Hloop_WQ_A(ntryL,G1H4(16),ex3(:),G1H2(64),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(64),55,0,G2H2(133),n2h2(56))
call HGT_raise_alpha_OLR(G1H4(21),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(21),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(21),ex4(:),G1H2(69),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_WQ_A(ntryL,G1H4(27),ex3(:),G1H2(70),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(70),55,0,G2H2(134),n2h2(57))
  call Hloop_WQ_A(ntryL,G1H4(28),ex3(:),G1H2(28),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(28),55,0,G2H2(135),n2h2(58))
  call Hloop_WA_Q(ntryL,G1H4(32),ex2(:),G1H2(34),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(34),62,0,G2H2(136),n2h2(59))
call HGT_raise_alpha_OLR(G1H4(33),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(33),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(33),ex1(:),G1H2(39),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_WA_Q(ntryL,G1H4(44),ex2(:),G1H2(40),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(40),62,0,G2H2(137),n2h2(60))
  call Hloop_WA_Q(ntryL,G1H4(58),ex2(:),G1H2(46),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(46),62,0,G2H2(138),n2h2(61))
  call Hloop_WA_Q(ntryL,G1H4(63),ex4(:),G1H2(51),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(51),59,0,G2H2(139),n2h2(62))
call HGT_raise_alpha_OLR(G1H4(73),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(73),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(73),ex3(:),G1H2(52),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_WA_Q(ntryL,G1H4(61),ex4(:),G1H2(58),m3h2x2(:,162),heltab2x4(:,:,162))



end subroutine vamp_1

end module ol_vamp_1_ppllll_ew_nmnmxeexaa_1_/**/REALKIND
