
module ol_vamp_1_ppllll_ew_nexnmnmxeudx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_ew_nexnmnmxeudx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_ew_nexnmnmxeudx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_ew_nexnmnmxeudx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_ew_nexnmnmxeudx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllll_ew_nexnmnmxeudx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_nexnmnmxeudx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(42)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,1,2,4,16],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,1,2,4,16],[0,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,2),heltab2x64(:,:,2))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,1,2,4,16],[nMZ,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,2,1,8,16],[nMZ,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,4),heltab2x64(:,:,4))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,4,2,1,8,16],[nMW,0,nMW,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,4,2,1,8,16],[nMW,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,1,4,2,16],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,2,4,1,8,16],[nMZ,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,2,8,1,16],[nMZ,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,9),heltab2x64(:,:,9))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,2,8,1,16],[nMW,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,4,8,1,16],[nMZ,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(11),ngZd,m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,1,8,2,4,16],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,1,8,2,4,16],[nMZ,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZd,m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,1,8,4,2,16],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_WQ_A(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(1),n2h16(1))
  call Hloop_VQ_A(ntryL,G0H32(2),ex4(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(2),n2h16(2))
  call Hloop_ZQ_A(ntryL,G0H32(3),ex4(:),G0H16(1),ngZl,m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(3),n2h16(3))
  call Hloop_ZA_Q(ntryL,G0H32(4),ex3(:),G0H16(1),ngZn,m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(4),n2h16(4))
  call Hloop_WA_Q(ntryL,G0H32(5),ex3(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(5),n2h16(5))
  call Hloop_WA_Q(ntryL,G0H32(6),ex3(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(6),n2h16(6))
  call Hloop_WQ_A(ntryL,G0H32(7),ex4(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(7),n2h16(7))
  call Hloop_ZQ_A(ntryL,G0H32(8),ex2(:),G0H16(1),ngZn,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(8),n2h16(8))
  call Hloop_ZA_Q(ntryL,G0H32(9),ex3(:),G0H16(1),ngZn,m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(9),n2h16(9))
  call Hloop_WA_Q(ntryL,G0H32(10),ex3(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(10),n2h16(10))
  call Hloop_ZQ_A(ntryL,G0H32(11),ex2(:),G0H16(1),ngZn,m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(11),n2h16(11))
  call Hloop_WA_Q(ntryL,G0H32(12),ex1(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(12),n2h16(12))
  call Hloop_ZA_Q(ntryL,G0H32(13),ex1(:),G0H16(1),ngZn,m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(13),n2h16(13))
  call Hloop_WA_Q(ntryL,G0H32(14),ex1(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(14),n2h16(14))
  call Hloop_QA_Z(ntryL,G1H16(1),ex1(:),G1H8(1),ngZn,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_QA_W(ntryL,G1H16(2),ex1(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_QA_W(ntryL,G1H16(3),ex1(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex2(:),G1H8(4),ngZn,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_W(ntryL,G1H16(5),ex2(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_W(ntryL,G1H16(6),ex2(:),G1H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_Z(ntryL,G1H16(7),ex1(:),G1H8(7),ngZn,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_QA_Z(ntryL,G1H16(8),ex3(:),G1H8(8),ngZn,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_Z(ntryL,G1H16(9),ex2(:),G1H8(9),ngZn,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_W(ntryL,G1H16(10),ex2(:),G1H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_QA_Z(ntryL,G1H16(11),ex3(:),G1H8(11),ngZn,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H16(12),ex4(:),G1H8(12),ngZl,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_W(ntryL,G1H16(13),ex4(:),G1H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex4(:),G1H8(14),ngZl,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex2(:),G1H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(1),n2h4(1))
  call Hloop_WQ_A(ntryL,G1H8(2),ex2(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(2),n2h4(2))
  call Hloop_WQ_A(ntryL,G1H8(3),ex2(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(3),n2h4(3))
  call Hloop_ZA_Q(ntryL,G1H8(4),ex1(:),G1H4(1),ngZn,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(4),n2h4(4))
  call Hloop_WA_Q(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(5),n2h4(5))
  call Hloop_WA_Q(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(6),n2h4(6))
  call Hloop_ZA_Q(ntryL,G1H8(7),ex3(:),G1H4(1),ngZn,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(7),n2h4(7))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex1(:),G1H4(1),ngZn,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(8),n2h4(8))
  call Hloop_ZQ_A(ntryL,G1H8(9),ex4(:),G1H4(1),ngZl,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),46,0,G2H4(9),n2h4(9))
  call Hloop_WQ_A(ntryL,G1H8(10),ex4(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),46,0,G2H4(10),n2h4(10))
  call Hloop_ZQ_A(ntryL,G1H8(11),ex4(:),G1H4(1),ngZl,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),46,0,G2H4(11),n2h4(11))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex2(:),G1H4(1),ngZn,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(12),n2h4(12))
  call Hloop_WQ_A(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(13),n2h4(13))
  call Hloop_ZA_Q(ntryL,G1H8(14),ex3(:),G1H4(1),ngZn,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(14),n2h4(14))
  call Hloop_QA_Z(ntryL,G2H4(1),ex3(:),G2H2(1),ngZn,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_W(ntryL,G2H4(2),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_W(ntryL,G2H4(3),ex3(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_W(ntryL,G2H4(4),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(5),ex4(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_Z(ntryL,G2H4(6),ex4(:),G2H2(6),ngZl,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_Z(ntryL,G2H4(7),ex2(:),G2H2(7),ngZn,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_W(ntryL,G2H4(8),ex4(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_W(ntryL,G2H4(9),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_Z(ntryL,G2H4(10),ex1(:),G2H2(10),ngZn,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_W(ntryL,G2H4(11),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_Z(ntryL,G2H4(12),ex3(:),G2H2(12),ngZn,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_W(ntryL,G2H4(13),ex3(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_Z(ntryL,G2H4(14),ex2(:),G2H2(14),ngZn,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,3),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,4),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(2),mass5set(:,5),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(2),mass5set(:,5),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(3),mass5set(:,1),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(4),mass5set(:,4),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(5),mass5set(:,4),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(5),mass5set(:,5),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(6),mass5set(:,4),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(7),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(7),mass5set(:,3),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(8),mass5set(:,1),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),ngZu,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),ngZu,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(2),n2h1(2))
  call Hloop_WQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(3))
  call Hloop_WQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(4),n2h1(4))
  call Hloop_WQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(5))
  call Hloop_WQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(6),n2h1(6))
  call Hloop_WQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(7))
  call Hloop_WQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(8),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(10))
  call Hloop_ZQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),ngZu,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(11))
  call Hloop_ZQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),ngZu,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(12),n2h1(12))
  call Hloop_ZQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),ngZu,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_ZQ_A(ntryL,G1H2(38),ex5(:),G1H1(1),ngZu,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(14),n2h1(14))
  call Hloop_WQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(15))
  call Hloop_WQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(16),n2h1(16))
  call Hloop_WQ_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(17))
  call Hloop_WQ_A(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(18),n2h1(18))
  call Hloop_ZQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),ngZu,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(19))
  call Hloop_ZQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),ngZu,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(20),n2h1(20))
  call Hloop_WQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(21))
  call Hloop_WQ_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(22))
  call Hloop_ZQ_A(ntryL,G1H2(67),ex5(:),G1H1(1),ngZu,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(23))
  call Hloop_ZQ_A(ntryL,G1H2(68),ex5(:),G1H1(1),ngZu,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(24))
  call Hloop_WQ_A(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(25))
  call Hloop_WQ_A(ntryL,G1H2(74),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(26))
  call Hloop_ZQ_A(ntryL,G1H2(79),ex5(:),G1H1(1),ngZu,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(27))
  call Hloop_ZQ_A(ntryL,G1H2(80),ex5(:),G1H1(1),ngZu,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(28))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(2),mass5set(:,4),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,5),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(2),mass5set(:,5),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(3),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(4),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(5),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(5),mass5set(:,5),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(6),mass5set(:,4),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(7),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(7),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(8),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,6,16,1,8],[0,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,6,16,1,8],[0,0,nMZ,0,nMW],5,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,6,16,1,8],[0,0,nMW,0,nMZ],5,1,wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,6,8,1,16],[nMW,nMW,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,8,16,6],[nMW,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,8,16,6],[nMW,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,1,8,16,6],[nMZ,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZd,m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,1,8,6,16],[nMZ,0,nMW,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,6,1,8,16],[nMW,nMW,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,6,1,8,16],[nMW,nMW,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,8,1,6,16],[0,0,nMW,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,8,1,6,16],[nMZ,0,nMW,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(12),ngZd,m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,8,6,1,16],[0,0,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,8,6,1,16],[nMW,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,8,6,1,16],[nMZ,0,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,1,6,8,16],[nMW,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,30),heltab2x64(:,:,30))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,1,6,8,16],[nMW,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,1,6,8,16],[nMZ,0,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZd,m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,4,2,16,9],[nMZ,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(16),ngZd,m3h2x32(:,33),heltab2x64(:,:,33))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,9,4,2,16],[nMW,nMZ,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,2,4,16,9],[nMZ,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZd,m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,2,4,9,16],[nMZ,0,nMZ,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(19),ngZd,m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,9,2,4,16],[nMW,nMZ,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,9,2,4,16],[0,nMW,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,9,2,4,16],[nMZ,nMW,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(22),ngZd,m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,4,2,9,16],[nMZ,0,nMZ,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(23),ngZd,m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,4,2,9,16],[nMW,0,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,4,2,9,16],[nMW,0,nMW,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,9,2,16],[nMW,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,2,9,4,16],[nMZ,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(27),ngZd,m3h2x32(:,44),heltab2x64(:,:,44))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[48,4,2,1,8],[nMZ,0,nMZ,0,nMW],5,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(1),m3h4x16(:,1),heltab2x64(:,:,45))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[48,4,2,1,8],[nMW,0,nMW,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(2),m3h4x16(:,2),heltab2x64(:,:,46))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[48,4,2,1,8],[nMW,0,nMW,0,nMZ],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(3),m3h4x16(:,3),heltab2x64(:,:,47))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[48,2,1,8,4],[0,nMW,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,4),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(4),n2h16(15))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[48,1,2,4,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,5),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(5),n2h16(16))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[48,2,4,1,8],[nMZ,0,nMZ,0,nMW],5,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(6),m3h4x16(:,6),heltab2x64(:,:,50))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[48,2,8,1,4],[0,nMW,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,7),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(7),n2h16(17))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[48,1,4,2,8],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,8),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(8),n2h16(18))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[48,1,8,2,4],[nMW,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(9),m3h4x16(:,9),heltab2x64(:,:,53))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[48,1,8,2,4],[nMZ,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(10),m3h4x16(:,10),heltab2x64(:,:,54))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[48,1,8,4,2],[nMW,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(11),m3h4x16(:,11),heltab2x64(:,:,55))
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,2),G1H8(1),ngZd,m3h4x8(:,1),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(1),n2h8(1))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,2),G1H8(2),ngZu,m3h4x8(:,2),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(2),n2h8(2))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,2),G1H8(3),ngZd,m3h4x8(:,3),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(3),38,0,G2H8(3),n2h8(3))
  call Hloop_UW_V(ntryL,G0H32(4),32,wf4(:,2),6,G1H8(4),m3h4x8(:,4),heltab2x32(:,:,18))
  call Hloop_WA_Q(ntryL,G0H32(5),ex1(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(12),n2h16(19))
  call Hloop_WA_Q(ntryL,G0H32(6),ex1(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(13),n2h16(20))
  call Hloop_ZA_Q(ntryL,G0H32(7),ex1(:),G0H16(1),ngZn,m3h2x16(:,17),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(14),n2h16(21))
  call Hloop_ZA_Q(ntryL,G0H32(8),ex1(:),G0H16(1),ngZn,m3h2x16(:,18),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(15),n2h16(22))
  call Hloop_UW_V(ntryL,G0H32(9),32,wf4(:,2),6,G1H8(5),m3h4x8(:,5),heltab2x32(:,:,23))
  call Hloop_UW_V(ntryL,G0H32(10),32,wf4(:,2),6,G1H8(6),m3h4x8(:,6),heltab2x32(:,:,24))
  call Hloop_VQ_A(ntryL,G0H32(11),ex4(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(16),n2h16(23))
  call Hloop_ZQ_A(ntryL,G0H32(12),ex4(:),G0H16(1),ngZl,m3h2x16(:,20),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(17),n2h16(24))
  call Hloop_VQ_A(ntryL,G0H32(13),ex4(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(18),n2h16(25))
  call Hloop_WQ_A(ntryL,G0H32(14),ex4(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(19),n2h16(26))
  call Hloop_ZQ_A(ntryL,G0H32(1),ex4(:),G0H16(1),ngZl,m3h2x16(:,23),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(20),n2h16(27))
  call Hloop_WA_Q(ntryL,G0H32(2),ex1(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(21),n2h16(28))
  call Hloop_WA_Q(ntryL,G0H32(3),ex1(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(22),n2h16(29))
  call Hloop_ZA_Q(ntryL,G0H32(15),ex1(:),G0H16(1),ngZn,m3h2x16(:,26),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(23),n2h16(30))
  call Hloop_ZA_Q(ntryL,G0H32(16),ex3(:),G0H16(1),ngZn,m3h2x16(:,27),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(24),n2h16(31))
  call Hloop_UV_W(ntryL,G0H32(17),32,wf4(:,1),9,G1H8(7),m3h4x8(:,7),heltab2x32(:,:,34))
  call Hloop_ZQ_A(ntryL,G0H32(18),ex2(:),G0H16(1),ngZn,m3h2x16(:,28),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(25),n2h16(32))
  call Hloop_ZQ_A(ntryL,G0H32(19),ex2(:),G0H16(1),ngZn,m3h2x16(:,29),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(26),n2h16(33))
  call Hloop_UV_W(ntryL,G0H32(20),32,wf4(:,1),9,G1H8(8),m3h4x8(:,8),heltab2x32(:,:,37))
  call Hloop_UW_V(ntryL,G0H32(21),32,wf4(:,1),9,G1H8(9),m3h4x8(:,9),heltab2x32(:,:,38))
  call Hloop_UW_V(ntryL,G0H32(22),32,wf4(:,1),9,G1H8(10),m3h4x8(:,10),heltab2x32(:,:,39))
  call Hloop_ZA_Q(ntryL,G0H32(23),ex3(:),G0H16(1),ngZn,m3h2x16(:,30),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(27),n2h16(34))
  call Hloop_WA_Q(ntryL,G0H32(24),ex3(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(28),n2h16(35))
  call Hloop_WA_Q(ntryL,G0H32(25),ex3(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(29),n2h16(36))
  call Hloop_WA_Q(ntryL,G0H32(26),ex3(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(30),n2h16(37))
  call Hloop_ZQ_A(ntryL,G0H32(27),ex2(:),G0H16(1),ngZn,m3h2x16(:,34),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(31),n2h16(38))
  call Hloop_ZA_Q(ntryL,G1H16(1),ex3(:),G1H8(11),ngZn,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(11),52,0,G2H8(4),n2h8(4))
  call Hloop_WA_Q(ntryL,G1H16(2),ex3(:),G1H8(12),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(12),52,0,G2H8(5),n2h8(5))
  call Hloop_WA_Q(ntryL,G1H16(3),ex3(:),G1H8(13),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(13),52,0,G2H8(6),n2h8(6))
  call Hloop_AQ_W(ntryL,G1H16(4),ex2(:),G1H8(14),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_QA_Z(ntryL,G1H16(5),ex1(:),G1H8(1),ngZn,m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_ZQ_A(ntryL,G1H16(6),ex2(:),G1H8(2),ngZn,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(2),50,0,G2H8(7),n2h8(7))
  call Hloop_AQ_W(ntryL,G1H16(7),ex2(:),G1H8(3),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_QA_Z(ntryL,G1H16(8),ex1(:),G1H8(11),ngZn,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_WA_Q(ntryL,G1H16(9),ex1(:),G1H8(12),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(12),49,0,G2H8(8),n2h8(8))
  call Hloop_ZA_Q(ntryL,G1H16(10),ex1(:),G1H8(13),ngZn,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(13),49,0,G2H8(9),n2h8(9))
  call Hloop_WA_Q(ntryL,G1H16(11),ex1(:),G1H8(2),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(2),49,0,G2H8(10),n2h8(10))
  call Hloop_AQ_W(ntryL,G2H8(1),ex5(:),G2H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex5(:),G2H4(2),ngZu,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_W(ntryL,G2H8(3),ex5(:),G2H4(3),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_WQ_A(ntryL,G1H8(4),ex4(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),46,0,G2H4(4),n2h4(15))
  call Hloop_AQ_V(ntryL,G1H16(12),ex4(:),G1H8(12),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_AQ_Z(ntryL,G1H16(13),ex4(:),G1H8(13),ngZl,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_AQ_W(ntryL,G1H16(14),ex4(:),G1H8(2),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_AQ_W(ntryL,G1H16(15),ex4(:),G1H8(4),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_WA_Q(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(5),n2h4(16))
  call Hloop_WA_Q(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(6),n2h4(17))
  call Hloop_QA_W(ntryL,G1H16(16),ex1(:),G1H8(5),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_QA_W(ntryL,G1H16(17),ex1(:),G1H8(6),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,2),G1H4(1),ngZl,m3h4x4(:,1),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),46,0,G2H4(7),n2h4(18))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,2),G1H4(1),ngZn,m3h4x4(:,2),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),46,0,G2H4(8),n2h4(19))
  call Hloop_QZ_A(ntryL,G1H16(20),wf4(:,2),G1H4(1),ngZl,m3h4x4(:,3),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),46,0,G2H4(9),n2h4(20))
  call Hloop_AZ_Q(ntryL,G1H16(21),wf4(:,2),G1H4(1),ngZl,m3h4x4(:,4),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(10),n2h4(21))
  call Hloop_AZ_Q(ntryL,G1H16(22),wf4(:,2),G1H4(1),ngZl,m3h4x4(:,5),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(11),n2h4(22))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf4(:,2),G1H4(1),ngZn,m3h4x4(:,6),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(12),n2h4(23))
  call Hloop_AQ_Z(ntryL,G1H16(24),ex2(:),G1H8(15),ngZn,m3h2x8(:,32),heltab2x16(:,:,38))
  call Hloop_ZA_Q(ntryL,G1H8(7),ex3(:),G1H4(1),ngZn,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(13),n2h4(24))
  call Hloop_QA_Z(ntryL,G1H16(25),ex3(:),G1H8(7),ngZn,m3h2x8(:,33),heltab2x16(:,:,39))
  call Hloop_QA_Z(ntryL,G1H16(26),ex3(:),G1H8(16),ngZn,m3h2x8(:,34),heltab2x16(:,:,40))
  call Hloop_ZQ_A(ntryL,G1H8(8),ex2(:),G1H4(1),ngZn,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(14),n2h4(25))
  call Hloop_WQ_A(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(15),n2h4(26))
  call Hloop_WQ_A(ntryL,G1H8(10),ex2(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(16),n2h4(27))
  call Hloop_AQ_Z(ntryL,G1H16(27),ex2(:),G1H8(8),ngZn,m3h2x8(:,35),heltab2x16(:,:,41))
  call Hloop_AQ_W(ntryL,G1H16(28),ex2(:),G1H8(9),m3h2x8(:,36),heltab2x16(:,:,42))
  call Hloop_AQ_W(ntryL,G1H16(29),ex2(:),G1H8(10),m3h2x8(:,37),heltab2x16(:,:,43))
  call Hloop_AW_Q(ntryL,G1H16(30),wf4(:,1),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(17),n2h4(28))
  call Hloop_QW_A(ntryL,G1H16(31),wf4(:,1),G1H4(1),m3h4x4(:,8),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(18),n2h4(29))
  call Hloop_AQ_Z(ntryL,G2H8(4),ex2(:),G2H4(19),ngZn,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_AQ_W(ntryL,G2H8(5),ex2(:),G2H4(20),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_AQ_W(ntryL,G2H8(6),ex2(:),G2H4(21),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_WA_Q(ntryL,G1H8(14),ex1(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(22),n2h4(30))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex2(:),G1H4(1),ngZn,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(23),n2h4(31))
  call Hloop_QA_Z(ntryL,G2H8(7),ex3(:),G2H4(24),ngZn,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_WQ_A(ntryL,G1H8(3),ex4(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(25),n2h4(32))
  call Hloop_ZA_Q(ntryL,G1H8(11),ex3(:),G1H4(1),ngZn,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(26),n2h4(33))
  call Hloop_AQ_Z(ntryL,G2H8(8),ex4(:),G2H4(27),ngZl,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_AQ_W(ntryL,G2H8(9),ex4(:),G2H4(28),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_Z(ntryL,G2H8(10),ex4(:),G2H4(29),ngZl,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(9),mass5set(:,2),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(9),mass5set(:,6),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(9),mass5set(:,7),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hloop_QA_Z(ntryL,G2H4(4),ex1(:),G2H2(1),ngZn,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_VQ_A(ntryL,G1H8(12),ex5(:),G1H4(19),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(19),57,0,G2H4(1),n2h4(34))
  call Hloop_ZQ_A(ntryL,G1H8(13),ex5(:),G1H4(19),ngZu,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(19),57,0,G2H4(2),n2h4(35))
  call Hloop_WQ_A(ntryL,G1H8(2),ex5(:),G1H4(19),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(19),57,0,G2H4(3),n2h4(36))
  call Hloop_UV_W(ntryL,G1H8(4),41,wf4(:,2),6,G2H2(2),m3h4x2(:,1),heltab2x8(:,:,39))
  call Hloop_AQ_V(ntryL,G2H4(5),ex4(:),G2H2(3),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_Z(ntryL,G2H4(6),ex4(:),G2H2(4),ngZl,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_UV_W(ntryL,G1H8(5),41,wf4(:,2),6,G2H2(5),m3h4x2(:,2),heltab2x8(:,:,40))
  call Hloop_UV_W(ntryL,G1H8(6),41,wf4(:,2),6,G2H2(6),m3h4x2(:,3),heltab2x8(:,:,41))
  call Hloop_QA_W(ntryL,G2H4(7),ex1(:),G2H2(7),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_Z(ntryL,G2H4(8),ex1(:),G2H2(8),ngZn,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_W(ntryL,G2H4(9),ex1(:),G2H2(9),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_V(ntryL,G2H4(10),ex4(:),G2H2(10),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_Z(ntryL,G2H4(11),ex4(:),G2H2(11),ngZl,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_W(ntryL,G2H4(12),ex4(:),G2H2(12),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_ZQ_A(ntryL,G1H8(15),ex5(:),G1H4(19),ngZu,m3h2x4(:,39),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(19),54,0,G2H4(4),n2h4(37))
  call Hloop_AQ_Z(ntryL,G2H4(13),ex2(:),G2H2(13),ngZn,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_ZQ_A(ntryL,G1H8(7),ex5(:),G1H4(19),ngZu,m3h2x4(:,40),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(19),54,0,G2H4(5),n2h4(38))
  call Hloop_UW_V(ntryL,G1H8(16),38,wf4(:,1),9,G2H2(14),m3h4x2(:,4),heltab2x8(:,:,44))
  call Hloop_QA_Z(ntryL,G2H4(14),ex3(:),G2H2(15),ngZn,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_W(ntryL,G2H4(15),ex3(:),G2H2(16),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_W(ntryL,G2H4(16),ex3(:),G2H2(17),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_UW_V(ntryL,G1H8(8),38,wf4(:,1),9,G2H2(18),m3h4x2(:,5),heltab2x8(:,:,45))
  call Hloop_UV_W(ntryL,G1H8(9),38,wf4(:,1),9,G2H2(19),m3h4x2(:,6),heltab2x8(:,:,46))
  call Hloop_UV_W(ntryL,G1H8(10),38,wf4(:,1),9,G2H2(20),m3h4x2(:,7),heltab2x8(:,:,47))
  call Hloop_AQ_Z(ntryL,G2H4(17),ex2(:),G2H2(21),ngZn,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_W(ntryL,G2H4(18),ex3(:),G2H2(22),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(10),mass5set(:,8),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(10),mass5set(:,5),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(10),mass5set(:,9),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hloop_AQ_Z(ntryL,G2H4(22),ex4(:),G2H2(23),ngZl,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_Z(ntryL,G2H4(23),ex3(:),G2H2(24),ngZn,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(11),mass5set(:,8),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hloop_QA_Z(ntryL,G2H4(25),ex1(:),G2H2(25),ngZn,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_Z(ntryL,G2H4(26),ex2(:),G2H2(26),ngZn,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(12),mass5set(:,10),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),4,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(12),mass5set(:,11),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),4,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(13),mass5set(:,10),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),2,4)
  call Hloop_WA_Q(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(27),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(2),ex4(:),G1H2(2),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_WA_Q(ntryL,G1H4(5),ex1(:),G1H2(7),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(7),55,0,G2H2(28),n2h2(2))
  call Hloop_WA_Q(ntryL,G1H4(6),ex1(:),G1H2(8),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(8),55,0,G2H2(29),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(7),ex1(:),G1H2(13),ngZn,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(13),55,0,G2H2(30),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(8),ex4(:),G1H2(14),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_ZA_Q(ntryL,G1H4(11),ex1(:),G1H2(19),ngZn,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(19),55,0,G2H2(31),n2h2(5))
  call Hloop_ZA_Q(ntryL,G1H4(12),ex1(:),G1H2(20),ngZn,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(20),55,0,G2H2(32),n2h2(6))
  call Hloop_WA_Q(ntryL,G1H4(13),ex1(:),G1H2(25),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(25),55,0,G2H2(33),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(14),ex4(:),G1H2(26),ngZl,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_WA_Q(ntryL,G1H4(17),ex1(:),G1H2(31),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(31),55,0,G2H2(34),n2h2(8))
  call Hloop_WA_Q(ntryL,G1H4(18),ex1(:),G1H2(32),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(32),55,0,G2H2(35),n2h2(9))
  call Hloop_ZA_Q(ntryL,G1H4(19),ex1(:),G1H2(37),ngZn,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(37),55,0,G2H2(36),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(20),ex4(:),G1H2(38),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_ZA_Q(ntryL,G1H4(23),ex1(:),G1H2(43),ngZn,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(43),55,0,G2H2(37),n2h2(11))
  call Hloop_ZA_Q(ntryL,G1H4(24),ex1(:),G1H2(44),ngZn,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(44),55,0,G2H2(38),n2h2(12))
  call Hloop_WA_Q(ntryL,G1H4(25),ex1(:),G1H2(49),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(39),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(26),ex4(:),G1H2(50),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_WA_Q(ntryL,G1H4(29),ex1(:),G1H2(55),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(55),55,0,G2H2(40),n2h2(14))
  call Hloop_WA_Q(ntryL,G1H4(30),ex1(:),G1H2(56),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(56),55,0,G2H2(41),n2h2(15))
  call Hloop_WA_Q(ntryL,G1H4(31),ex1(:),G1H2(61),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(61),55,0,G2H2(42),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(32),ex4(:),G1H2(62),ngZl,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_WA_Q(ntryL,G1H4(35),ex1(:),G1H2(67),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(67),55,0,G2H2(43),n2h2(17))
  call Hloop_WA_Q(ntryL,G1H4(36),ex1(:),G1H2(68),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(68),55,0,G2H2(44),n2h2(18))
  call Hloop_ZA_Q(ntryL,G1H4(37),ex1(:),G1H2(73),ngZn,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(73),55,0,G2H2(45),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(38),ex4(:),G1H2(74),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_ZA_Q(ntryL,G1H4(41),ex1(:),G1H2(79),ngZn,m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(79),55,0,G2H2(46),n2h2(20))
  call Hloop_ZA_Q(ntryL,G1H4(42),ex1(:),G1H2(80),ngZn,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(80),55,0,G2H2(47),n2h2(21))
  call Hloop_ZQ_A(ntryL,G1H4(43),ex2(:),G1H2(1),ngZn,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(48),n2h2(22))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(44),ex3(:),G1H2(7),ngZn,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_ZQ_A(ntryL,G1H4(47),ex2(:),G1H2(8),ngZn,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(8),59,0,G2H2(49),n2h2(23))
  call Hloop_ZQ_A(ntryL,G1H4(48),ex2(:),G1H2(13),ngZn,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(13),59,0,G2H2(50),n2h2(24))
  call Hloop_WQ_A(ntryL,G1H4(49),ex2(:),G1H2(19),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(19),59,0,G2H2(51),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(50),ex3(:),G1H2(20),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_WQ_A(ntryL,G1H4(53),ex2(:),G1H2(25),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(25),59,0,G2H2(52),n2h2(26))
  call Hloop_WQ_A(ntryL,G1H4(54),ex2(:),G1H2(31),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(31),59,0,G2H2(53),n2h2(27))
  call Hloop_ZA_Q(ntryL,G1H4(55),ex3(:),G1H2(32),ngZn,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(32),61,0,G2H2(54),n2h2(28))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(56),ex2(:),G1H2(37),ngZn,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_ZA_Q(ntryL,G1H4(59),ex3(:),G1H2(43),ngZn,m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(43),61,0,G2H2(55),n2h2(29))
  call Hloop_ZA_Q(ntryL,G1H4(60),ex3(:),G1H2(44),ngZn,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(44),61,0,G2H2(56),n2h2(30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(70),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(76),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(54),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(60),G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(82),G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(66),G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(78)])
  call Hloop_ZQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),ngZu,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(29))
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(14),mass5set(:,12),  & 
G1H2(49),G1H2(55),G1H2(56),G1H2(61),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(55),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),ngZu,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(30))
  call Hloop_ZQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),ngZu,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(31))
  call Hloop_WQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(32))
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(14),mass5set(:,13),  & 
G1H2(73),G1H2(79),G1H2(80),G1H2(1),G1H2(8),G1H2(13),2)
  call HG1shiftOLR(G1H2(79),16,2)
  call Hloop_WQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(33))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(15),mass5set(:,14),  & 
G1H2(19),G1H2(25),G1H2(31),G1H2(32),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(25),16,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(14),mass5set(:,15),  & 
G1H2(70),G1H2(4),G1H2(6),G1H2(9),G1H2(10),G1H2(12),2)
  call HG1shiftOLR(G1H2(4),16,2)
  call Hloop_WQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(34))
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(15),mass5set(:,16),  & 
G1H2(76),G1H2(16),G1H2(18),G1H2(22),G1H2(54),G1H2(24),2)
  call HG1shiftOLR(G1H2(16),16,2)
  call Hloop_WQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(35))
  call Hloop_WQ_A(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(36))
  call Hloop_WQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(37))
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(16),mass5set(:,17),  & 
G1H2(28),G1H2(30),G1H2(34),G1H2(60),G1H2(36),G1H2(82),2)
  call HG1shiftOLR(G1H2(30),16,2)
  call Hloop_VQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(38))
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(17),mass5set(:,18),  & 
G1H2(40),G1H2(66),G1H2(48),G1H2(52),G1H2(58),G1H2(72),2)
  call HG1shiftOLR(G1H2(66),16,2)
  call Hloop_VQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(39))
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(16),mass5set(:,5),  & 
G1H2(78),G1H2(3),G1H2(5),G1H2(42),G1H2(15),G1H2(11),2)
  call HG1shiftOLR(G1H2(3),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),ngZu,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(40))
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(17),mass5set(:,19),  & 
G1H2(17),G1H2(21),G1H2(46),G1H2(23),G1H2(27),G1H2(29),2)
  call HG1shiftOLR(G1H2(21),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(35),ex5(:),G1H1(1),ngZu,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(41))
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(16),mass5set(:,20),  & 
G1H2(33),G1H2(35),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(35),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(39),ex5(:),G1H1(1),ngZu,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(42))
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(18),mass5set(:,12),  & 
G1H2(39),G1H2(89),G1H2(90),G1H2(91),G1H2(92),G1H2(93),2)
  call HG1shiftOLR(G1H2(89),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),ngZu,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(43))
  call Hloop_WQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(44))
  call Hloop_WQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(45))
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(19),mass5set(:,17),  & 
G1H2(41),G1H2(45),G1H2(47),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(45),16,2)
  call Hloop_WQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(46))
  call Hloop_WQ_A(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(47))
  call Hloop_WQ_A(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(48))
  call Hloop_ZQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),ngZu,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(49))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(20),mass5set(:,19),  & 
G1H2(51),G1H2(64),G1H2(53),G1H2(57),G1H2(97),G1H2(98),2)
  call HG1shiftOLR(G1H2(64),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(59),ex5(:),G1H1(1),ngZu,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(50))
  call Hloop_WQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(51))
  call Hloop_WQ_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(52))
  call Hloop_ZQ_A(ntryL,G1H2(69),ex5(:),G1H1(1),ngZu,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(53))
  call Hloop_ZQ_A(ntryL,G1H2(71),ex5(:),G1H1(1),ngZu,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(54))
  call Hloop_ZQ_A(ntryL,G1H2(84),ex5(:),G1H1(1),ngZu,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(55))
  call Hloop_WQ_A(ntryL,G1H2(75),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(56))
  call Hloop_WQ_A(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(57))
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(21),mass5set(:,16),  & 
G1H2(59),G1H2(63),G1H2(65),G1H2(69),G1H2(71),G1H2(84),2)
  call HG1shiftOLR(G1H2(63),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(81),ex5(:),G1H1(1),ngZu,m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(44),n2h1(58))
  call Hloop_ZQ_A(ntryL,G1H2(83),ex5(:),G1H1(1),ngZu,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(59))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(22),mass5set(:,21),  & 
G1H4(1),G1H4(2),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(2),6,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(22),mass5set(:,1),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(12),6,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(22),mass5set(:,3),  & 
G1H4(19),G1H4(20),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(20),6,4)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(23),mass5set(:,22),  & 
G1H2(75),G1H2(77),G1H2(81),G1H2(83),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(77),16,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(23),mass5set(:,23),  & 
G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(102),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(23),mass5set(:,24),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),G1H2(112),2)
  call HG1shiftOLR(G1H2(108),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(24),mass5set(:,21),  & 
G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),G1H2(118),2)
  call HG1shiftOLR(G1H2(114),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(24),mass5set(:,23),  & 
G1H2(119),G1H2(120),G1H2(121),G1H2(122),G1H2(123),G1H2(124),2)
  call HG1shiftOLR(G1H2(120),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(24),mass5set(:,24),  & 
G1H2(125),G1H2(126),G1H2(127),G1H2(128),G1H2(129),G1H2(130),2)
  call HG1shiftOLR(G1H2(126),16,2)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(25),mass5set(:,4),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(30),9,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(26),mass5set(:,4),  & 
G1H4(37),G1H4(38),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(38),9,4)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(27),mass5set(:,23),  & 
G1H2(131),G1H2(132),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(132),16,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(28),mass5set(:,24),  & 
G1H2(137),G1H2(138),G1H2(139),G1H2(140),G1H2(141),G1H2(142),2)
  call HG1shiftOLR(G1H2(138),16,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(29),mass5set(:,25),  & 
G1H2(143),G1H2(144),G1H2(145),G1H2(146),G1H2(147),G1H2(148),2)
  call HG1shiftOLR(G1H2(144),4,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(30),mass5set(:,26),  & 
G1H2(149),G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),2)
  call HG1shiftOLR(G1H2(150),8,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(31),mass5set(:,25),  & 
G1H2(155),G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(156),4,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(32),mass5set(:,26),  & 
G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(162),8,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(27),ex4(:),G2tensor(46),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(29),ex4(:),G2tensor(47),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(30),ex4(:),G2tensor(48),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(32),ex4(:),G2tensor(49),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(33),ex4(:),G2tensor(50),ngZl,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(51),ngZl,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(52),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(53),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(54),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(41),ex4(:),G2tensor(55),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(42),ex4(:),G2tensor(56),ngZl,m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(44),ex4(:),G2tensor(57),ngZl,m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(45),ex4(:),G2tensor(58),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(47),ex4(:),G2tensor(59),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(60),ngZn,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(50),ex3(:),G2tensor(61),ngZn,m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(51),ex3(:),G2tensor(62),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(53),ex3(:),G2tensor(63),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(54),ex2(:),G2tensor(64),ngZn,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(56),ex2(:),G2tensor(65),ngZn,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hloop_ZQ_A(ntryL,G1H2(49),ex5(:),G1H1(1),ngZu,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(60))
  call Hloop_ZQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),ngZu,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(67),n2h1(61))
  call Hloop_ZQ_A(ntryL,G1H2(68),ex5(:),G1H1(1),ngZu,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(62))
  call Hloop_WQ_A(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(63))
  call Hloop_WQ_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(70),n2h1(64))
  call Hloop_WQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(65))
  call Hloop_WQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(66))
  call Hloop_WQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(73),n2h1(67))
  call Hloop_WQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(74),n2h1(68))
  call Hloop_WQ_A(ntryL,G1H2(70),ex5(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(69))
  call Hloop_WQ_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(76),n2h1(70))
  call Hloop_WQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(71))
  call Hloop_WQ_A(ntryL,G1H2(76),ex5(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(72))
  call Hloop_WQ_A(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(79),n2h1(73))
  call Hloop_WQ_A(ntryL,G1H2(24),ex5(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(80),n2h1(74))
  call Hloop_WQ_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(75))
  call Hloop_WQ_A(ntryL,G1H2(30),ex5(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(82),n2h1(76))
  call Hloop_WQ_A(ntryL,G1H2(82),ex5(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(77))
  call Hloop_VQ_A(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(78))
  call Hloop_VQ_A(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(85),n2h1(79))
  call Hloop_VQ_A(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(86),n2h1(80))
  call Hloop_VQ_A(ntryL,G1H2(78),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(88),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(83))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),ngZu,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(84))
  call Hloop_ZQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),ngZu,m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(91),n2h1(85))
  call Hloop_ZQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),ngZu,m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(92),n2h1(86))
  call Hloop_ZQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),ngZu,m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(87))
  call Hloop_ZQ_A(ntryL,G1H2(35),ex5(:),G1H1(1),ngZu,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(94),n2h1(88))
  call Hloop_ZQ_A(ntryL,G1H2(88),ex5(:),G1H1(1),ngZu,m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(89))
  call Hloop_ZQ_A(ntryL,G1H2(39),ex5(:),G1H1(1),ngZu,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(90))
  call Hloop_ZQ_A(ntryL,G1H2(89),ex5(:),G1H1(1),ngZu,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(97),n2h1(91))
  call Hloop_ZQ_A(ntryL,G1H2(93),ex5(:),G1H1(1),ngZu,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(98),n2h1(92))
  call Hloop_WQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(93))
  call Hloop_WQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(100),n2h1(94))
  call Hloop_WQ_A(ntryL,G1H2(96),ex5(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(95))
  call Hloop_ZQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),ngZu,m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(96))
  call Hloop_ZQ_A(ntryL,G1H2(64),ex5(:),G1H1(1),ngZu,m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(103),n2h1(97))
  call Hloop_ZQ_A(ntryL,G1H2(98),ex5(:),G1H1(1),ngZu,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(104),n2h1(98))
  call Hloop_WQ_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(99))
  call Hloop_WQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(106),n2h1(100))
  call Hloop_WQ_A(ntryL,G1H2(84),ex5(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(101))
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,1),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(108),n2h1(102))
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,2),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(109),n2h1(103))
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,3),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(110),n2h1(104))
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,4),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(105))
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,5),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(112),n2h1(106))
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,6),heltab2x4(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(107))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,7),heltab2x4(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(108))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,8),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(115),n2h1(109))
  call Hloop_QZ_A(ntryL,G1H4(26),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,9),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(116),n2h1(110))
  call Hloop_WQ_A(ntryL,G1H2(75),ex5(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(111))
  call Hloop_WQ_A(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(118),n2h1(112))
  call Hloop_WQ_A(ntryL,G1H2(100),ex5(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(119),n2h1(113))
  call Hloop_ZQ_A(ntryL,G1H2(101),ex5(:),G1H1(1),ngZu,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(114))
  call Hloop_ZQ_A(ntryL,G1H2(102),ex5(:),G1H1(1),ngZu,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(121),n2h1(115))
  call Hloop_ZQ_A(ntryL,G1H2(106),ex5(:),G1H1(1),ngZu,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(122),n2h1(116))
  call Hloop_WQ_A(ntryL,G1H2(107),ex5(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(117))
  call Hloop_WQ_A(ntryL,G1H2(108),ex5(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(124),n2h1(118))
  call Hloop_WQ_A(ntryL,G1H2(112),ex5(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(125),n2h1(119))
  call Hloop_VQ_A(ntryL,G1H2(113),ex5(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(120))
  call Hloop_VQ_A(ntryL,G1H2(114),ex5(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(127),n2h1(121))
  call Hloop_VQ_A(ntryL,G1H2(118),ex5(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(128),n2h1(122))
  call Hloop_ZQ_A(ntryL,G1H2(119),ex5(:),G1H1(1),ngZu,m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(123))
  call Hloop_ZQ_A(ntryL,G1H2(120),ex5(:),G1H1(1),ngZu,m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(130),n2h1(124))
  call Hloop_ZQ_A(ntryL,G1H2(124),ex5(:),G1H1(1),ngZu,m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(131),n2h1(125))
  call Hloop_WQ_A(ntryL,G1H2(125),ex5(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(126))
  call Hloop_WQ_A(ntryL,G1H2(126),ex5(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(133),n2h1(127))
  call Hloop_WQ_A(ntryL,G1H2(130),ex5(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(134),n2h1(128))
  call Hloop_QW_A(ntryL,G1H4(29),wf4(:,1),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(129))
  call Hloop_QW_A(ntryL,G1H4(30),wf4(:,1),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(136),n2h1(130))
  call Hloop_QW_A(ntryL,G1H4(36),wf4(:,1),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(137),n2h1(131))
  call Hloop_QW_A(ntryL,G1H4(37),wf4(:,1),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(132))
  call Hloop_QW_A(ntryL,G1H4(38),wf4(:,1),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(139),n2h1(133))
  call Hloop_QW_A(ntryL,G1H4(44),wf4(:,1),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(140),n2h1(134))
  call Hloop_ZQ_A(ntryL,G1H2(131),ex5(:),G1H1(1),ngZu,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(135))
  call Hloop_ZQ_A(ntryL,G1H2(132),ex5(:),G1H1(1),ngZu,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(142),n2h1(136))
  call Hloop_ZQ_A(ntryL,G1H2(136),ex5(:),G1H1(1),ngZu,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(137))
  call Hloop_WQ_A(ntryL,G1H2(137),ex5(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(138))
  call Hloop_WQ_A(ntryL,G1H2(138),ex5(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(145),n2h1(139))
  call Hloop_WQ_A(ntryL,G1H2(142),ex5(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(146),n2h1(140))
  call Hloop_ZA_Q(ntryL,G1H2(143),ex3(:),G1H1(1),ngZn,m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(141))
  call Hloop_ZA_Q(ntryL,G1H2(144),ex3(:),G1H1(1),ngZn,m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(148),n2h1(142))
  call Hloop_ZA_Q(ntryL,G1H2(148),ex3(:),G1H1(1),ngZn,m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(149),n2h1(143))
  call Hloop_ZQ_A(ntryL,G1H2(149),ex4(:),G1H1(1),ngZl,m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(144))
  call Hloop_ZQ_A(ntryL,G1H2(150),ex4(:),G1H1(1),ngZl,m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(151),n2h1(145))
  call Hloop_ZQ_A(ntryL,G1H2(154),ex4(:),G1H1(1),ngZl,m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(146))
  call Hloop_ZA_Q(ntryL,G1H2(155),ex3(:),G1H1(1),ngZn,m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(147))
  call Hloop_ZA_Q(ntryL,G1H2(156),ex3(:),G1H1(1),ngZn,m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(154),n2h1(148))
  call Hloop_ZA_Q(ntryL,G1H2(160),ex3(:),G1H1(1),ngZn,m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(155),n2h1(149))
  call Hloop_ZQ_A(ntryL,G1H2(161),ex4(:),G1H1(1),ngZl,m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(150))
  call Hloop_ZQ_A(ntryL,G1H2(162),ex4(:),G1H1(1),ngZl,m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(157),n2h1(151))
  call Hloop_ZQ_A(ntryL,G1H2(166),ex4(:),G1H1(1),ngZl,m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(152))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(8),G1tensor(20)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(10),G1tensor(26)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(12),G1tensor(32)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(16),G1tensor(44)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(62)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(24),G1tensor(68)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(26),G1tensor(74)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(28),G1tensor(80)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(70),G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(42),G1tensor(6)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(15),G1tensor(9)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(76),G1tensor(16)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(46),G1tensor(22)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(54),G1tensor(24)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(90),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(60),G1tensor(36)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(96),[G1tensor(82),G1tensor(40)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(66),G1tensor(48)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(64),G1tensor(52)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(84),G1tensor(72)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(77)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(83)])
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(33),mass5set(:,10),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(33),mass5set(:,27),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),4)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(33),mass5set(:,11),  & 
G1tensor(73),G1tensor(79),G1tensor(2),G1tensor(8),G1tensor(14),G1tensor(20))
  call G_TensorShift(G1tensor(79),4)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(10),mass5set(:,8),  & 
G1tensor(26),G1tensor(32),G1tensor(38),G1tensor(44),G1tensor(50),G1tensor(56))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(10),mass5set(:,5),  & 
G1tensor(62),G1tensor(68),G1tensor(74),G1tensor(80),G1tensor(3),G1tensor(70))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(56),RedSet_5(10),mass5set(:,9),  & 
G1tensor(4),G1tensor(5),G1tensor(42),G1tensor(6),G1tensor(15),G1tensor(9))
  call G_TensorShift(G1tensor(5),8)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(34),mass5set(:,10),  & 
G1tensor(10),G1tensor(11),G1tensor(12),G1tensor(76),G1tensor(16),G1tensor(17))
  call G_TensorShift(G1tensor(11),2)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(11),mass5set(:,8),  & 
G1tensor(18),G1tensor(21),G1tensor(46),G1tensor(22),G1tensor(23),G1tensor(54))
  call G_TensorShift(G1tensor(21),8)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(35),mass5set(:,8),  & 
G1tensor(24),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30),G1tensor(33))
  call G_TensorShift(G1tensor(27),1)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(35),mass5set(:,9),  & 
G1tensor(34),G1tensor(35),G1tensor(60),G1tensor(36),G1tensor(39),G1tensor(82))
  call G_TensorShift(G1tensor(35),1)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(36),mass5set(:,8),  & 
G1tensor(40),G1tensor(41),G1tensor(45),G1tensor(47),G1tensor(66),G1tensor(48))
  call G_TensorShift(G1tensor(41),1)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(12),mass5set(:,10),  & 
G1tensor(51),G1tensor(64),G1tensor(52),G1tensor(53),G1tensor(57),G1tensor(58))
  call G_TensorShift(G1tensor(64),4)
  call Hotf_5pt_reduction_last(G2tensor(62),RedSet_5(12),mass5set(:,11),  & 
G1tensor(59),G1tensor(63),G1tensor(65),G1tensor(69),G1tensor(71),G1tensor(84))
  call G_TensorShift(G1tensor(63),4)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(13),mass5set(:,10),  & 
G1tensor(72),G1tensor(75),G1tensor(77),G1tensor(78),G1tensor(81),G1tensor(83))
  call G_TensorShift(G1tensor(75),2)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(37),mass5set(:,26),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(66),RedSet_5(14),mass5set(:,12),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(38),mass5set(:,23),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(15),mass5set(:,28),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(37),mass5set(:,13),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(14),mass5set(:,13),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(38),mass5set(:,22),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(72),RedSet_5(15),mass5set(:,14),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(14),mass5set(:,15),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(38),mass5set(:,24),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(78),RedSet_5(15),mass5set(:,16),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(39),mass5set(:,29),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(17),mass5set(:,30),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(40),mass5set(:,24),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(16),mass5set(:,17),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(39),mass5set(:,31),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(84),RedSet_5(17),mass5set(:,18),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(40),mass5set(:,21),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(16),mass5set(:,5),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(39),mass5set(:,25),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(90),RedSet_5(17),mass5set(:,19),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(40),mass5set(:,23),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(16),mass5set(:,20),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(41),mass5set(:,26),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(96),RedSet_5(18),mass5set(:,12),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(42),mass5set(:,23),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(43),mass5set(:,29),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(44),mass5set(:,24),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(19),mass5set(:,17),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(45),mass5set(:,29),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(20),mass5set(:,30),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(46),mass5set(:,24),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(45),mass5set(:,25),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(102),RedSet_5(20),mass5set(:,19),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(46),mass5set(:,23),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(47),mass5set(:,29),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),16)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(48),mass5set(:,24),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(49),mass5set(:,26),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),16)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(50),mass5set(:,23),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(21),mass5set(:,28),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),16)
  call Hotf_5pt_reduction_last(G2tensor(42),RedSet_5(49),mass5set(:,13),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(50),mass5set(:,24),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),16)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(21),mass5set(:,16),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),16)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(51),mass5set(:,26),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(52),mass5set(:,23),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),16)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(9),mass5set(:,2),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),8)
  call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(9),mass5set(:,6),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),8)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(9),mass5set(:,7),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),8)
  call Hotf_5pt_reduction_last(G2tensor(108),RedSet_5(22),mass5set(:,21),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),6)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(22),mass5set(:,1),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),6)
  call Hotf_5pt_reduction_last(G2tensor(114),RedSet_5(22),mass5set(:,3),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),6)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(23),mass5set(:,22),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),16)
  call Hotf_5pt_reduction_last(G2tensor(120),RedSet_5(23),mass5set(:,23),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),16)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(23),mass5set(:,24),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),16)
  call Hotf_5pt_reduction_last(G2tensor(126),RedSet_5(24),mass5set(:,21),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),16)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(24),mass5set(:,23),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),16)
  call Hotf_5pt_reduction_last(G2tensor(132),RedSet_5(24),mass5set(:,24),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(422),16)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(25),mass5set(:,4),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(428),9)
  call Hotf_5pt_reduction_last(G2tensor(138),RedSet_5(26),mass5set(:,4),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437),G1tensor(438))
  call G_TensorShift(G1tensor(434),9)
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(27),mass5set(:,23),  & 
G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444))
  call G_TensorShift(G1tensor(440),16)
  call Hotf_5pt_reduction_last(G2tensor(144),RedSet_5(28),mass5set(:,24),  & 
G1tensor(445),G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(446),16)
  call Hotf_5pt_reduction_last(G2tensor(147),RedSet_5(29),mass5set(:,25),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(452),4)
  call Hotf_5pt_reduction_last(G2tensor(150),RedSet_5(30),mass5set(:,26),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(458),8)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(31),mass5set(:,25),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G1tensor(468))
  call G_TensorShift(G1tensor(464),4)
  call Hotf_5pt_reduction_last(G2tensor(156),RedSet_5(32),mass5set(:,26),  & 
G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(470),8)
  call ol_merge_tensors(T1sum(15),[G1tensor(1)])
  call ol_merge_tensors(T1sum(16),[G1tensor(37)])
  call ol_merge_tensors(T1sum(17),[G1tensor(73)])
  call ol_merge_tensors(T1sum(18),[G1tensor(26)])
  call ol_merge_tensors(T1sum(19),[G1tensor(62)])
  call ol_merge_tensors(T1sum(20),[G1tensor(4)])
  call ol_merge_tensors(T1sum(21),[G1tensor(10)])
  call ol_merge_tensors(T1sum(22),[G1tensor(18)])
  call ol_merge_tensors(T1sum(23),[G1tensor(24)])
  call ol_merge_tensors(T1sum(24),[G1tensor(34)])
  call ol_merge_tensors(T1sum(25),[G1tensor(40)])
  call ol_merge_tensors(T1sum(26),[G1tensor(51)])
  call ol_merge_tensors(T1sum(27),[G1tensor(59)])
  call ol_merge_tensors(T1sum(28),[G1tensor(72)])
  call ol_merge_tensors(T1sum(29),[G1tensor(85)])
  call ol_merge_tensors(T1sum(30),[G1tensor(91)])
  call ol_merge_tensors(T1sum(31),[G1tensor(97)])
  call ol_merge_tensors(T1sum(32),[G1tensor(103)])
  call ol_merge_tensors(T1sum(33),[G1tensor(109)])
  call ol_merge_tensors(T1sum(34),[G1tensor(115)])
  call ol_merge_tensors(T1sum(35),[G1tensor(121)])
  call ol_merge_tensors(T1sum(36),[G1tensor(127)])
  call ol_merge_tensors(T1sum(37),[G1tensor(133)])
  call ol_merge_tensors(T1sum(38),[G1tensor(139)])
  call ol_merge_tensors(T1sum(39),[G1tensor(145)])
  call ol_merge_tensors(T1sum(40),[G1tensor(151)])
  call ol_merge_tensors(T1sum(41),[G1tensor(157)])
  call ol_merge_tensors(T1sum(42),[G1tensor(163)])
  call ol_merge_tensors(T1sum(43),[G1tensor(169)])
  call ol_merge_tensors(T1sum(44),[G1tensor(175)])
  call ol_merge_tensors(T1sum(45),[G1tensor(181)])
  call ol_merge_tensors(T1sum(46),[G1tensor(187)])
  call ol_merge_tensors(T1sum(47),[G1tensor(193)])
  call ol_merge_tensors(T1sum(48),[G1tensor(199)])
  call ol_merge_tensors(T1sum(49),[G1tensor(205)])
  call ol_merge_tensors(T1sum(50),[G1tensor(211)])
  call ol_merge_tensors(T1sum(51),[G1tensor(217)])
  call ol_merge_tensors(T1sum(52),[G1tensor(223)])
  call ol_merge_tensors(T1sum(53),[G1tensor(229)])
  call ol_merge_tensors(T1sum(54),[G1tensor(235)])
  call ol_merge_tensors(T1sum(55),[G1tensor(241)])
  call ol_merge_tensors(T1sum(56),[G1tensor(247)])
  call ol_merge_tensors(T1sum(57),[G1tensor(253)])
  call ol_merge_tensors(T1sum(58),[G1tensor(259)])
  call ol_merge_tensors(T1sum(59),[G1tensor(265)])
  call ol_merge_tensors(T1sum(60),[G1tensor(271)])
  call ol_merge_tensors(T1sum(61),[G1tensor(277)])
  call ol_merge_tensors(T1sum(62),[G1tensor(283)])
  call ol_merge_tensors(T1sum(63),[G1tensor(289)])
  call ol_merge_tensors(T1sum(64),[G1tensor(295)])
  call ol_merge_tensors(T1sum(65),[G1tensor(301)])
  call ol_merge_tensors(T1sum(66),[G1tensor(307)])
  call ol_merge_tensors(T1sum(67),[G1tensor(313)])
  call ol_merge_tensors(T1sum(68),[G1tensor(319)])
  call ol_merge_tensors(T1sum(69),[G1tensor(325)])
  call ol_merge_tensors(T1sum(70),[G1tensor(331)])
  call ol_merge_tensors(T1sum(71),[G1tensor(337)])
  call ol_merge_tensors(T1sum(72),[G1tensor(343)])
  call ol_merge_tensors(T1sum(73),[G1tensor(349)])
  call ol_merge_tensors(T1sum(74),[G1tensor(355)])
  call ol_merge_tensors(T1sum(75),[G1tensor(361)])
  call ol_merge_tensors(T1sum(76),[G1tensor(367)])
  call ol_merge_tensors(T1sum(77),[G1tensor(373)])
  call ol_merge_tensors(T1sum(78),[G1tensor(379)])
  call ol_merge_tensors(T1sum(79),[G1tensor(385)])
  call ol_merge_tensors(T1sum(80),[G1tensor(391)])
  call ol_merge_tensors(T1sum(81),[G1tensor(397)])
  call ol_merge_tensors(T1sum(82),[G1tensor(403)])
  call ol_merge_tensors(T1sum(83),[G1tensor(409)])
  call ol_merge_tensors(T1sum(84),[G1tensor(415)])
  call ol_merge_tensors(T1sum(85),[G1tensor(421)])
  call ol_merge_tensors(T1sum(86),[G1tensor(427)])
  call ol_merge_tensors(T1sum(87),[G1tensor(433)])
  call ol_merge_tensors(T1sum(88),[G1tensor(439)])
  call ol_merge_tensors(T1sum(89),[G1tensor(445)])
  call ol_merge_tensors(T1sum(90),[G1tensor(451)])
  call ol_merge_tensors(T1sum(91),[G1tensor(457)])
  call ol_merge_tensors(T1sum(92),[G1tensor(463)])
  call ol_merge_tensors(T1sum(93),[G1tensor(469)])
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,6,9,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,45),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(1),n2h32(4))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,6,9,16],[0,0,0,nMZ],4,2,wf4(:,2),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),ngZd,m3h2x32(:,46),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(2),n2h32(5))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,6,9,16],[nMW,nMW,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,47),heltab2x64(:,:,58))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,6,9,16],[nMZ,nMH,nMW,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZd,m3h2x32(:,48),heltab2x64(:,:,59))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,6,9,16],[nMW,nMW,nMZ,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,49),heltab2x64(:,:,60))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,6,9,16],[nMW,nMW,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,50),heltab2x64(:,:,61))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,6,9,16],[nMW,nMW,nMZ,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,51),heltab2x64(:,:,62))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,9,6,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,52),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G0H32(11),32,0,G1H32(3),n2h32(6))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,9,6,16],[0,0,0,nMZ],4,2,wf4(:,1),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(12),ngZd,m3h2x32(:,53),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G0H32(12),32,0,G1H32(4),n2h32(7))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,9,6,16],[0,nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,54),heltab2x64(:,:,65))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,9,6,16],[nMW,nMH,nMZ,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,55),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,9,6,16],[nMZ,nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,56),heltab2x64(:,:,67))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,9,6,16],[0,nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,57),heltab2x64(:,:,68))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,9,6,16],[nMZ,nMW,nMW,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,58),heltab2x64(:,:,69))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,6,16,9],[0,0,0,nMW],4,2,wf4(:,2),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,59),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(5),n2h32(8))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,6,16,9],[0,0,nMW,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,60),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(6),n2h32(9))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,6,16,9],[0,0,nMZ,nMW],4,2,wf4(:,2),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,61),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(7),n2h32(10))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,6,16,9],[0,0,nMW,nMZ],4,2,wf4(:,2),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(18),ngZd,m3h2x32(:,62),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(18),32,0,G1H32(8),n2h32(11))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[48,6,1,8],[0,0,nMZ,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,12),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(1),n2h16(39))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[48,6,1,8],[nMW,nMW,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,13),heltab2x64(:,:,75))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[48,6,1,8],[nMH,nMZ,0,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(2),m3h4x16(:,14),heltab2x64(:,:,76))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[48,6,1,8],[nMW,nMW,0,nMZ],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H64(1),wf4(:,3),G0H16(3),m3h4x16(:,15),heltab2x64(:,:,77))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[48,6,1,8],[nMW,nMW,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(2),m3h4x16(:,16),heltab2x64(:,:,78))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[48,6,1,8],[nMW,nMW,0,nMZ],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(3),m3h4x16(:,17),heltab2x64(:,:,79))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[48,1,8,6],[0,nMZ,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,3),G0H16(4),m3h4x16(:,18),heltab2x64(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(4),48,0,G1H16(4),n2h16(40))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[48,1,8,6],[nMW,0,nMZ,nMH],4,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(4),m3h4x16(:,19),heltab2x64(:,:,81))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[48,1,8,6],[nMZ,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(5),m3h4x16(:,20),heltab2x64(:,:,82))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[48,1,8,6],[nMZ,0,nMW,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(5),m3h4x16(:,21),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[48,1,6,8],[nMW,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(6),m3h4x16(:,22),heltab2x64(:,:,84))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[48,1,6,8],[nMZ,0,0,nMW],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(7),m3h4x16(:,23),heltab2x64(:,:,85))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[48,1,6,8],[nMW,0,0,nMZ],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(8),m3h4x16(:,24),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,7,8,16],[nMW,0,0,0],4,1,wf8(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,63),heltab2x64(:,:,87))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,7,8,16],[nMW,0,nMZ,0],4,1,wf8(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,64),heltab2x64(:,:,88))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,7,8,16],[nMZ,0,nMW,0],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(21),ngZd,m3h2x32(:,65),heltab2x64(:,:,89))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,8,7,16],[0,0,nMW,0],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,66),heltab2x64(:,:,90))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,8,7,16],[nMW,0,nMZ,0],4,1,wf8(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,67),heltab2x64(:,:,91))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,8,7,16],[nMZ,0,nMW,0],4,1,wf8(:,9))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(24),ngZd,m3h2x32(:,68),heltab2x64(:,:,92))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,14,1,16],[0,0,nMW,0],4,1,wf8(:,44))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,69),heltab2x64(:,:,93))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,14,1,16],[nMW,0,nMZ,0],4,1,wf8(:,44))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,70),heltab2x64(:,:,94))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,14,1,16],[nMZ,0,nMW,0],4,1,wf8(:,44))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(27),ngZd,m3h2x32(:,71),heltab2x64(:,:,95))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,1,14,16],[nMW,0,0,0],4,1,wf8(:,44))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,72),heltab2x64(:,:,96))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,1,14,16],[nMW,0,nMZ,0],4,1,wf8(:,44))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,73),heltab2x64(:,:,97))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,1,14,16],[nMZ,0,nMW,0],4,1,wf8(:,44))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(11),ngZd,m3h2x32(:,74),heltab2x64(:,:,98))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,1,8,22],[nMW,0,0,0],4,1,wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,75),heltab2x64(:,:,99))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,1,8,22],[nMW,0,nMZ,0],4,1,wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,76),heltab2x64(:,:,100))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,1,8,22],[nMZ,0,nMW,0],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(16),ngZd,m3h2x32(:,77),heltab2x64(:,:,101))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,8,1,22],[0,0,nMW,0],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,78),heltab2x64(:,:,102))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,8,1,22],[nMW,0,nMZ,0],4,1,wf8(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,79),heltab2x64(:,:,103))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,8,1,22],[nMZ,0,nMW,0],4,1,wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(28),ngZd,m3h2x32(:,80),heltab2x64(:,:,104))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[38,8,1,16],[0,0,nMW,0],4,1,wf8(:,21))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,21),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,105))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[38,8,1,16],[nMW,0,nMZ,0],4,1,wf8(:,21))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,21),G0H8(2),m3h8x8(:,2),heltab2x64(:,:,106))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[38,8,1,16],[nMZ,0,nMW,0],4,1,wf8(:,21))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,21),G0H8(3),ngZd,m3h8x8(:,3),heltab2x64(:,:,107))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[38,1,8,16],[nMW,0,0,0],4,1,wf8(:,21))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,21),G0H8(4),m3h8x8(:,4),heltab2x64(:,:,108))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[38,1,8,16],[nMW,0,nMZ,0],4,1,wf8(:,21))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,21),G0H8(5),m3h8x8(:,5),heltab2x64(:,:,109))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[38,1,8,16],[nMZ,0,nMW,0],4,1,wf8(:,21))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,21),G0H8(6),ngZd,m3h8x8(:,6),heltab2x64(:,:,110))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[48,4,2,9],[0,nMZ,0,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,3),G0H16(6),m3h4x16(:,25),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G0H16(6),48,0,G1H16(9),n2h16(41))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[48,4,2,9],[nMZ,0,nMZ,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(6),m3h4x16(:,26),heltab2x64(:,:,112))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[48,4,2,9],[nMW,0,nMW,nMH],4,2,wf4(:,3),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(7),m3h4x16(:,27),heltab2x64(:,:,113))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[48,4,2,9],[nMZ,0,nMZ,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(10),m3h4x16(:,28),heltab2x64(:,:,114))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[48,4,2,9],[nMW,0,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(11),m3h4x16(:,29),heltab2x64(:,:,115))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[48,4,2,9],[nMW,0,nMW,nMZ],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(12),m3h4x16(:,30),heltab2x64(:,:,116))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[48,2,4,9],[0,nMW,0,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,3),G0H16(8),m3h4x16(:,31),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(8),48,0,G1H16(13),n2h16(42))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[48,2,4,9],[nMZ,0,nMZ,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),wf4(:,3),G0H16(8),m3h4x16(:,32),heltab2x64(:,:,118))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[48,2,4,9],[nMZ,0,nMZ,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(14),m3h4x16(:,33),heltab2x64(:,:,119))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[48,2,9,4],[nMZ,0,0,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(15),m3h4x16(:,34),heltab2x64(:,:,120))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[48,2,9,4],[0,nMW,nMZ,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,3),G0H16(9),m3h4x16(:,35),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(9),48,0,G1H16(16),n2h16(43))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,11,4,16],[0,0,nMW,0],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,81),heltab2x64(:,:,122))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,11,4,16],[nMW,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,82),heltab2x64(:,:,123))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,11,4,16],[nMZ,0,nMW,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(31),ngZd,m3h2x32(:,83),heltab2x64(:,:,124))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,4,11,16],[nMW,0,0,0],4,1,wf8(:,15))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,84),heltab2x64(:,:,125))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,4,11,16],[nMW,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,85),heltab2x64(:,:,126))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,4,11,16],[nMZ,0,nMW,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(34),ngZd,m3h2x32(:,86),heltab2x64(:,:,127))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,2,4,25],[nMZ,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(35),ngZd,m3h2x32(:,87),heltab2x64(:,:,128))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,4,2,25],[nMZ,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(36),ngZd,m3h2x32(:,88),heltab2x64(:,:,129))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,4,2,25],[nMW,0,nMW,0],4,1,wf8(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,89),heltab2x64(:,:,130))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[41,4,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,19))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,19),G0H8(7),ngZu,m3h8x8(:,7),heltab2x64(:,:,131))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[41,2,4,16],[nMZ,0,nMZ,0],4,1,wf8(:,19))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,19),G0H8(8),ngZu,m3h8x8(:,8),heltab2x64(:,:,132))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[41,2,4,16],[nMW,0,nMW,0],4,1,wf8(:,19))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,19),G0H8(9),m3h8x8(:,9),heltab2x64(:,:,133))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[49,4,2,8],[nMZ,0,nMZ,0],4,1,wf8(:,12))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,12),G0H8(10),ngZl,m3h8x8(:,10),heltab2x64(:,:,134))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[49,4,2,8],[nMW,0,nMW,0],4,1,wf8(:,12))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,12),G0H8(11),m3h8x8(:,11),heltab2x64(:,:,135))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[49,2,4,8],[nMZ,0,nMZ,0],4,1,wf8(:,12))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,12),G0H8(12),ngZl,m3h8x8(:,12),heltab2x64(:,:,136))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[52,2,1,8],[0,nMW,0,0],4,1,wf8(:,30))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,30),G0H8(13),m3h8x8(:,13),heltab2x64(:,:,137))
  call Hloop_A_Q(ntryL,G0H8(13),52,0,G1H8(14),n2h8(11))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[52,2,1,8],[0,nMZ,0,nMW],4,1,wf8(:,30))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,30),G0H8(13),m3h8x8(:,14),heltab2x64(:,:,138))
  call Hloop_A_Q(ntryL,G0H8(13),52,0,G1H8(1),n2h8(12))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[52,2,1,8],[0,nMW,0,nMZ],4,1,wf8(:,30))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,30),G0H8(13),ngZl,m3h8x8(:,15),heltab2x64(:,:,139))
  call Hloop_A_Q(ntryL,G0H8(13),52,0,G1H8(3),n2h8(13))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[52,1,8,2],[nMZ,0,nMW,0],4,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,30),G0H8(13),ngZl,m3h8x8(:,16),heltab2x64(:,:,140))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[52,1,8,2],[nMW,0,nMZ,0],4,1,wf8(:,30))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,30),G0H8(14),m3h8x8(:,17),heltab2x64(:,:,141))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[56,1,2,4],[0,nMZ,0,nMZ],4,1,wf8(:,42))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,42),G0H8(15),ngZn,m3h8x8(:,18),heltab2x64(:,:,142))
  call Hloop_Q_A(ntryL,G0H8(15),56,0,G1H8(11),n2h8(14))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[56,1,2,4],[0,nMW,0,nMW],4,1,wf8(:,42))
  call Hloop_WQ_A(ntryL,G0H64(1),wf8(:,42),G0H8(15),m3h8x8(:,19),heltab2x64(:,:,143))
  call Hloop_Q_A(ntryL,G0H8(15),56,0,G1H8(12),n2h8(15))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[56,1,4,2],[0,nMZ,0,nMZ],4,1,wf8(:,42))
  call Hloop_ZQ_A(ntryL,G0H64(1),wf8(:,42),G0H8(15),ngZn,m3h8x8(:,20),heltab2x64(:,:,144))
  call Hloop_Q_A(ntryL,G0H8(15),56,0,G1H8(13),n2h8(16))
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,2),G1H8(2),ngZd,m3h4x8(:,11),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(1),n2h8(17))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,2),G1H8(4),ngZd,m3h4x8(:,12),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(4),38,0,G2H8(2),n2h8(18))
  call Hloop_VV_S(ntryL,G0H32(6),wf4(:,2),G0H8(15),m3h4x8(:,13),heltab2x32(:,:,47))
  call Hloop_VV_S(ntryL,G0H32(7),wf4(:,2),G0H8(16),m3h4x8(:,14),heltab2x32(:,:,48))
  call Hloop_VV_S(ntryL,G0H32(8),wf4(:,2),G0H8(17),m3h4x8(:,15),heltab2x32(:,:,49))
  call Hloop_UW_V(ntryL,G0H32(9),32,wf4(:,2),6,G1H8(5),m3h4x8(:,16),heltab2x32(:,:,50))
  call Hloop_UW_V(ntryL,G0H32(10),32,wf4(:,2),6,G1H8(6),m3h4x8(:,17),heltab2x32(:,:,51))
  call Hloop_AW_Q(ntryL,G1H32(3),wf4(:,1),G1H8(15),m3h4x8(:,18),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(15),41,0,G2H8(3),n2h8(19))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,1),G1H8(7),m3h4x8(:,19),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(7),41,0,G2H8(4),n2h8(20))
  call Hloop_VV_S(ntryL,G0H32(13),wf4(:,1),G0H8(18),m3h4x8(:,20),heltab2x32(:,:,54))
  call Hloop_VV_S(ntryL,G0H32(14),wf4(:,1),G0H8(19),m3h4x8(:,21),heltab2x32(:,:,55))
  call Hloop_VV_S(ntryL,G0H32(1),wf4(:,1),G0H8(20),m3h4x8(:,22),heltab2x32(:,:,56))
  call Hloop_UW_V(ntryL,G0H32(2),32,wf4(:,1),9,G1H8(16),m3h4x8(:,23),heltab2x32(:,:,57))
  call Hloop_UW_V(ntryL,G0H32(3),32,wf4(:,1),9,G1H8(8),m3h4x8(:,24),heltab2x32(:,:,58))
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,2),G1H8(9),ngZu,m3h4x8(:,25),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(9),38,0,G2H8(5),n2h8(21))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,2),G1H8(10),ngZd,m3h4x8(:,26),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(10),38,0,G2H8(6),n2h8(22))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,2),G1H8(2),ngZu,m3h4x8(:,27),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(7),n2h8(23))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,2),G1H8(4),ngZd,m3h4x8(:,28),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(4),38,0,G2H8(8),n2h8(24))
  call Hloop_QZ_A(ntryL,G1H16(1),wf4(:,2),G1H4(47),ngZn,m3h4x4(:,9),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(47),54,0,G2H4(6),n2h4(49))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,10),heltab2x16(:,:,47))
  call Hloop_SV_V(ntryL,G0H16(2),wf4(:,2),G0H4(2),m3h4x4(:,11),heltab2x16(:,:,48))
  call Hloop_SV_V(ntryL,G0H16(3),wf4(:,2),G0H4(3),m3h4x4(:,12),heltab2x16(:,:,49))
  call Hloop_UW_V(ntryL,G1H16(2),48,wf4(:,2),6,G2H4(7),m3h4x4(:,13),heltab2x16(:,:,50))
  call Hloop_UW_V(ntryL,G1H16(3),48,wf4(:,2),6,G2H4(8),m3h4x4(:,14),heltab2x16(:,:,51))
  call Hloop_QA_Z(ntryL,G1H16(4),ex1(:),G1H8(15),ngZn,m3h2x8(:,38),heltab2x16(:,:,52))
  call Hloop_WA_Q(ntryL,G0H16(4),ex1(:),G0H8(21),m3h2x8(:,39),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G0H8(21),49,0,G1H8(7),n2h8(25))
  call Hloop_ZA_Q(ntryL,G0H16(5),ex1(:),G0H8(21),ngZn,m3h2x8(:,40),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G0H8(21),49,0,G1H8(9),n2h8(26))
  call Hloop_ZA_Q(ntryL,G1H16(5),ex1(:),G1H8(10),ngZn,m3h2x8(:,41),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(10),49,0,G2H8(9),n2h8(27))
  call Hloop_WA_Q(ntryL,G1H16(6),ex1(:),G1H8(2),m3h2x8(:,42),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(2),49,0,G2H8(10),n2h8(28))
  call Hloop_ZA_Q(ntryL,G1H16(7),ex1(:),G1H8(4),ngZn,m3h2x8(:,43),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(4),49,0,G2H8(11),n2h8(29))
  call Hloop_WA_Q(ntryL,G1H16(8),ex1(:),G1H8(10),m3h2x8(:,44),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(10),49,0,G2H8(12),n2h8(30))
  call Hloop_WA_Q(ntryL,G0H32(19),wf8(:,9),G0H4(4),m3h8x4(:,1),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H4(4),39,0,G1H4(48),n2h4(50))
  call Hloop_WA_Q(ntryL,G0H32(20),wf8(:,9),G0H4(4),m3h8x4(:,2),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H4(4),39,0,G1H4(49),n2h4(51))
  call Hloop_ZA_Q(ntryL,G0H32(21),wf8(:,9),G0H4(4),ngZn,m3h8x4(:,3),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H4(4),39,0,G1H4(50),n2h4(52))
  call Hloop_VQ_A(ntryL,G0H32(22),ex4(:),G0H16(9),m3h2x16(:,35),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H16(9),40,0,G1H16(17),n2h16(44))
  call Hloop_WQ_A(ntryL,G0H32(23),ex4(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(18),n2h16(45))
  call Hloop_ZQ_A(ntryL,G0H32(24),ex4(:),G0H16(2),ngZl,m3h2x16(:,37),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H16(2),40,0,G1H16(19),n2h16(46))
  call Hloop_VQ_A(ntryL,G0H32(25),wf8(:,44),G0H4(4),m3h8x4(:,4),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H4(4),46,0,G1H4(53),n2h4(53))
  call Hloop_WQ_A(ntryL,G0H32(26),wf8(:,44),G0H4(4),m3h8x4(:,5),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G0H4(4),46,0,G1H4(54),n2h4(54))
  call Hloop_ZQ_A(ntryL,G0H32(27),wf8(:,44),G0H4(4),ngZl,m3h8x4(:,6),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H4(4),46,0,G1H4(55),n2h4(55))
  call Hloop_WA_Q(ntryL,G0H32(4),ex1(:),G0H16(3),m3h2x16(:,38),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G0H16(3),33,0,G1H16(20),n2h16(47))
  call Hloop_WA_Q(ntryL,G0H32(5),ex1(:),G0H16(4),m3h2x16(:,39),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(4),33,0,G1H16(21),n2h16(48))
  call Hloop_ZA_Q(ntryL,G0H32(11),ex1(:),G0H16(5),ngZn,m3h2x16(:,40),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(5),33,0,G1H16(22),n2h16(49))
  call Hloop_WA_Q(ntryL,G0H32(12),ex1(:),G0H16(9),m3h2x16(:,41),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(9),33,0,G1H16(23),n2h16(50))
  call Hloop_WA_Q(ntryL,G0H32(15),ex1(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(24),n2h16(51))
  call Hloop_ZA_Q(ntryL,G0H32(16),ex1(:),G0H16(2),ngZn,m3h2x16(:,43),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(2),33,0,G1H16(25),n2h16(52))
  call Hloop_VQ_A(ntryL,G0H32(17),ex4(:),G0H16(3),m3h2x16(:,44),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(3),40,0,G1H16(26),n2h16(53))
  call Hloop_WQ_A(ntryL,G0H32(18),ex4(:),G0H16(4),m3h2x16(:,45),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G0H16(4),40,0,G1H16(27),n2h16(54))
  call Hloop_ZQ_A(ntryL,G0H32(28),ex4(:),G0H16(5),ngZl,m3h2x16(:,46),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(5),40,0,G1H16(28),n2h16(55))
  call Hloop_VQ_A(ntryL,G0H8(1),ex4(:),G0H4(4),m3h2x4(:,41),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G0H4(4),46,0,G1H4(56),n2h4(56))
  call Hloop_WQ_A(ntryL,G0H8(2),ex4(:),G0H4(4),m3h2x4(:,42),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G0H4(4),46,0,G1H4(59),n2h4(57))
  call Hloop_ZQ_A(ntryL,G0H8(3),ex4(:),G0H4(4),ngZl,m3h2x4(:,43),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G0H4(4),46,0,G1H4(60),n2h4(58))
  call Hloop_WA_Q(ntryL,G0H8(4),ex1(:),G0H4(4),m3h2x4(:,44),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G0H4(4),39,0,G1H4(1),n2h4(59))
  call Hloop_WA_Q(ntryL,G0H8(5),ex1(:),G0H4(4),m3h2x4(:,45),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G0H4(4),39,0,G1H4(2),n2h4(60))
  call Hloop_ZA_Q(ntryL,G0H8(6),ex1(:),G0H4(4),ngZn,m3h2x4(:,46),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G0H4(4),39,0,G1H4(8),n2h4(61))
  call Hloop_QA_Z(ntryL,G1H16(9),ex3(:),G1H8(2),ngZn,m3h2x8(:,45),heltab2x16(:,:,59))
  call Hloop_ZA_Q(ntryL,G0H16(6),ex3(:),G0H8(21),ngZn,m3h2x8(:,46),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(21),52,0,G1H8(4),n2h8(31))
  call Hloop_WA_Q(ntryL,G0H16(7),ex3(:),G0H8(1),m3h2x8(:,47),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G0H8(1),52,0,G1H8(10),n2h8(32))
  call Hloop_ZA_Q(ntryL,G1H16(10),ex3(:),G1H8(17),ngZn,m3h2x8(:,48),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(17),52,0,G2H8(13),n2h8(33))
  call Hloop_WA_Q(ntryL,G1H16(11),ex3(:),G1H8(17),m3h2x8(:,49),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(17),52,0,G2H8(14),n2h8(34))
  call Hloop_WA_Q(ntryL,G1H16(12),ex3(:),G1H8(17),m3h2x8(:,50),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(17),52,0,G2H8(15),n2h8(35))
  call Hloop_AQ_W(ntryL,G1H16(13),ex2(:),G1H8(17),m3h2x8(:,51),heltab2x16(:,:,65))
  call Hloop_ZQ_A(ntryL,G0H16(8),ex2(:),G0H8(2),ngZn,m3h2x8(:,52),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G0H8(2),50,0,G1H8(18),n2h8(36))
  call Hloop_ZQ_A(ntryL,G1H16(14),ex2(:),G1H8(19),ngZn,m3h2x8(:,53),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(19),50,0,G2H8(16),n2h8(37))
  call Hloop_ZQ_A(ntryL,G1H16(15),ex2(:),G1H8(19),ngZn,m3h2x8(:,54),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(19),50,0,G2H8(17),n2h8(38))
  call Hloop_AQ_W(ntryL,G1H16(16),ex2(:),G1H8(19),m3h2x8(:,55),heltab2x16(:,:,69))
  call Hloop_VQ_A(ntryL,G0H32(29),wf8(:,15),G0H4(4),m3h8x4(:,7),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H4(4),43,0,G1H4(11),n2h4(62))
  call Hloop_WQ_A(ntryL,G0H32(30),wf8(:,15),G0H4(4),m3h8x4(:,8),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G0H4(4),43,0,G1H4(12),n2h4(63))
  call Hloop_ZQ_A(ntryL,G0H32(31),wf8(:,15),G0H4(4),ngZl,m3h8x4(:,9),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H4(4),43,0,G1H4(18),n2h4(64))
  call Hloop_WA_Q(ntryL,G0H32(32),ex3(:),G0H16(9),m3h2x16(:,47),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(9),36,0,G1H16(29),n2h16(56))
  call Hloop_WA_Q(ntryL,G0H32(33),ex3(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(30),n2h16(57))
  call Hloop_ZA_Q(ntryL,G0H32(34),ex3(:),G0H16(2),ngZn,m3h2x16(:,49),heltab2x32(:,:,86))
  call Hloop_A_Q(ntryL,G0H16(2),36,0,G1H16(31),n2h16(58))
  call Hloop_ZQ_A(ntryL,G0H32(35),ex2(:),G0H16(3),ngZn,m3h2x16(:,50),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G0H16(3),34,0,G1H16(1),n2h16(59))
  call Hloop_ZA_Q(ntryL,G0H32(36),ex3(:),G0H16(4),ngZn,m3h2x16(:,51),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G0H16(4),36,0,G1H16(2),n2h16(60))
  call Hloop_WA_Q(ntryL,G0H32(37),ex3(:),G0H16(5),m3h2x16(:,52),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G0H16(5),36,0,G1H16(3),n2h16(61))
  call Hloop_ZA_Q(ntryL,G0H8(7),ex3(:),G0H4(4),ngZn,m3h2x4(:,47),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G0H4(4),45,0,G1H4(19),n2h4(65))
  call Hloop_ZQ_A(ntryL,G0H8(8),ex2(:),G0H4(4),ngZn,m3h2x4(:,48),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G0H4(4),43,0,G1H4(20),n2h4(66))
  call Hloop_WQ_A(ntryL,G0H8(9),ex2(:),G0H4(4),m3h2x4(:,49),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G0H4(4),43,0,G1H4(26),n2h4(67))
  call Hloop_ZA_Q(ntryL,G0H8(10),ex3(:),G0H4(4),ngZn,m3h2x4(:,50),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G0H4(4),53,0,G1H4(29),n2h4(68))
  call Hloop_WA_Q(ntryL,G0H8(11),ex3(:),G0H4(4),m3h2x4(:,51),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G0H4(4),53,0,G1H4(30),n2h4(69))
  call Hloop_ZQ_A(ntryL,G0H8(12),ex2(:),G0H4(4),ngZn,m3h2x4(:,52),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G0H4(4),51,0,G1H4(36),n2h4(70))
  call Hloop_AQ_W(ntryL,G1H8(14),ex2(:),G1H4(37),m3h2x4(:,53),heltab2x8(:,:,60))
  call Hloop_AQ_Z(ntryL,G1H8(1),ex2(:),G1H4(38),ngZn,m3h2x4(:,54),heltab2x8(:,:,61))
  call Hloop_AQ_W(ntryL,G1H8(3),ex2(:),G1H4(44),m3h2x4(:,55),heltab2x8(:,:,62))
  call Hloop_ZA_Q(ntryL,G0H8(13),ex1(:),G0H4(4),ngZn,m3h2x4(:,56),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G0H4(4),53,0,G1H4(47),n2h4(71))
  call Hloop_WA_Q(ntryL,G0H8(14),ex1(:),G0H4(4),m3h2x4(:,57),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G0H4(4),53,0,G1H4(61),n2h4(72))
  call Hloop_QA_Z(ntryL,G1H8(11),ex1(:),G1H4(62),ngZn,m3h2x4(:,58),heltab2x8(:,:,65))
  call Hloop_QA_W(ntryL,G1H8(12),ex1(:),G1H4(63),m3h2x4(:,59),heltab2x8(:,:,66))
  call Hloop_QA_Z(ntryL,G1H8(13),ex1(:),G1H4(64),ngZn,m3h2x4(:,60),heltab2x8(:,:,67))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(28),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(34),G0H4(3)])
  call Hloop_WA_Q(ntryL,G1H4(3),ex1(:),G1H2(49),m3h2x2(:,74),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(15),n2h2(31))
  call Hloop_WA_Q(ntryL,G1H4(4),ex1(:),G1H2(55),m3h2x2(:,75),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(55),55,0,G2H2(16),n2h2(32))
  call Hloop_ZA_Q(ntryL,G1H4(9),ex1(:),G1H2(68),ngZn,m3h2x2(:,76),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(68),55,0,G2H2(5),n2h2(33))
  call Hloop_ZA_Q(ntryL,G1H4(10),ex1(:),G1H2(73),ngZn,m3h2x2(:,77),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(73),55,0,G2H2(17),n2h2(34))
  call Hloop_WA_Q(ntryL,G1H4(15),ex1(:),G1H2(79),m3h2x2(:,78),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(79),55,0,G2H2(6),n2h2(35))
  call Hloop_WA_Q(ntryL,G1H4(16),ex1(:),G1H2(13),m3h2x2(:,79),heltab2x4(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(13),55,0,G2H2(18),n2h2(36))
  call Hloop_ZA_Q(ntryL,G1H4(38),ex1(:),G1H2(19),ngZn,m3h2x2(:,80),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(19),55,0,G2H2(3),n2h2(37))
  call Hloop_ZA_Q(ntryL,G1H4(40),ex1(:),G1H2(25),ngZn,m3h2x2(:,81),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(25),55,0,G2H2(19),n2h2(38))
  call Hloop_WA_Q(ntryL,G1H4(37),ex1(:),G1H2(44),m3h2x2(:,82),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(44),55,0,G2H2(4),n2h2(39))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(88),mass4set(:,1),  & 
G1H4(21),G1H4(22),G1H4(27),G1H4(28),G1H4(33),4)
  call HG1shiftOLR(G1H4(22),8,4)
  call Hloop_WA_Q(ntryL,G1H4(44),ex1(:),G1H2(70),m3h2x2(:,83),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(70),55,0,G2H2(20),n2h2(40))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(88),mass4set(:,2),  & 
G1H4(34),G1H4(3),G1H4(4),G1H4(9),G1H4(10),4)
  call HG1shiftOLR(G1H4(3),8,4)
  call Hloop_ZA_Q(ntryL,G1H4(39),ex1(:),G1H2(4),ngZn,m3h2x2(:,84),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(4),55,0,G2H2(13),n2h2(41))
  call Hloop_ZQ_A(ntryL,G1H4(45),ex2(:),G1H2(12),ngZn,m3h2x2(:,85),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(12),59,0,G2H2(14),n2h2(42))
  call Hloop_ZQ_A(ntryL,G1H4(46),ex2(:),G1H2(76),ngZn,m3h2x2(:,86),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(76),59,0,G2H2(1),n2h2(43))
  call Hloop_WQ_A(ntryL,G1H4(51),ex2(:),G1H2(16),m3h2x2(:,87),heltab2x4(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(16),59,0,G2H2(2),n2h2(44))
  call Hloop_WQ_A(ntryL,G1H4(52),ex2(:),G1H2(24),m3h2x2(:,88),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(24),59,0,G2H2(7),n2h2(45))
  call Hloop_ZA_Q(ntryL,G1H4(57),ex3(:),G1H2(28),ngZn,m3h2x2(:,89),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(28),61,0,G2H2(8),n2h2(46))
  call Hloop_ZA_Q(ntryL,G1H4(58),ex3(:),G1H2(30),ngZn,m3h2x2(:,90),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(30),61,0,G2H2(9),n2h2(47))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(22),mass4set(:,3),  & 
G1H8(14),G1H8(1),G1H8(3),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(1),16,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(22),mass4set(:,4),  & 
G1H8(13),G1H8(20),G1H8(21),G1H8(22),G1H8(23),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hloop_SV_V(ntryL,G0H8(15),wf4(:,1),G0H2(1),m3h4x2(:,8),heltab2x8(:,:,68))
  call Hloop_SV_V(ntryL,G0H8(16),wf4(:,1),G0H2(2),m3h4x2(:,9),heltab2x8(:,:,69))
  call Hloop_SV_V(ntryL,G0H8(17),wf4(:,1),G0H2(3),m3h4x2(:,10),heltab2x8(:,:,70))
  call Hloop_UV_W(ntryL,G1H8(5),38,wf4(:,1),9,G2H2(10),m3h4x2(:,11),heltab2x8(:,:,71))
  call Hloop_UV_W(ntryL,G1H8(6),38,wf4(:,1),9,G2H2(11),m3h4x2(:,12),heltab2x8(:,:,72))
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(7),mass4set(:,3),  & 
G1H8(5),G1H8(6),G1H8(24),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(6),16,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(7),mass4set(:,4),  & 
G1H8(27),G1H8(28),G1H8(29),G1H8(30),G1H8(31),8)
  call HG1shiftOLR(G1H8(28),16,8)
  call Hloop_SV_V(ntryL,G0H8(18),wf4(:,2),G0H2(4),m3h4x2(:,13),heltab2x8(:,:,73))
  call Hloop_SV_V(ntryL,G0H8(19),wf4(:,2),G0H2(5),m3h4x2(:,14),heltab2x8(:,:,74))
  call Hloop_SV_V(ntryL,G0H8(20),wf4(:,2),G0H2(6),m3h4x2(:,15),heltab2x8(:,:,75))
  call Hloop_UV_W(ntryL,G1H8(16),41,wf4(:,2),6,G2H2(12),m3h4x2(:,16),heltab2x8(:,:,76))
  call Hloop_UV_W(ntryL,G1H8(8),41,wf4(:,2),6,G2H2(21),m3h4x2(:,17),heltab2x8(:,:,77))
  call Hloop_AQ_V(ntryL,G2H8(5),ex5(:),G2H4(9),m3h2x4(:,61),heltab2x8(:,:,78))
  call Hloop_AQ_W(ntryL,G2H8(6),ex5(:),G2H4(10),m3h2x4(:,62),heltab2x8(:,:,79))
  call Hloop_AQ_Z(ntryL,G2H8(7),ex5(:),G2H4(11),ngZu,m3h2x4(:,63),heltab2x8(:,:,80))
  call Hloop_AQ_W(ntryL,G2H8(8),ex5(:),G2H4(12),m3h2x4(:,64),heltab2x8(:,:,81))
  call Hloop_QA_Z(ntryL,G2H4(6),ex1(:),G2H2(22),ngZn,m3h2x2(:,91),heltab2x4(:,:,106))
  call Hloop_ZA_Q(ntryL,G0H4(2),ex1(:),G0H2(7),ngZn,m3h2x2(:,92),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G0H2(7),55,0,G1H2(82),n2h2(48))
  call Hloop_ZQ_A(ntryL,G1H8(15),ex4(:),G1H4(15),ngZl,m3h2x4(:,65),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(15),57,0,G2H4(13),n2h4(73))
  call Hloop_AQ_Z(ntryL,G1H8(7),ex4(:),G1H4(16),ngZl,m3h2x4(:,66),heltab2x8(:,:,83))
  call Hloop_AQ_W(ntryL,G1H8(9),ex4(:),G1H4(38),m3h2x4(:,67),heltab2x8(:,:,84))
  call Hloop_AQ_W(ntryL,G2H8(9),ex4(:),G2H4(14),m3h2x4(:,68),heltab2x8(:,:,85))
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(140),mass4set(:,5),  & 
G1H8(16),G1H8(8),G1H8(15),G1H8(7),G1H8(9),8)
  call HG1shiftOLR(G1H8(8),8,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(140),mass4set(:,6),  & 
G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(33),8,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(140),mass4set(:,7),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hloop_AQ_V(ntryL,G1H4(48),ex4(:),G1H2(40),m3h2x2(:,93),heltab2x4(:,:,108))
  call Hloop_AQ_Z(ntryL,G1H4(49),ex4(:),G1H2(66),ngZl,m3h2x2(:,94),heltab2x4(:,:,109))
  call Hloop_AQ_W(ntryL,G1H4(50),ex4(:),G1H2(72),m3h2x2(:,95),heltab2x4(:,:,110))
  call Hloop_QA_W(ntryL,G1H16(17),wf8(:,9),G1H2(78),m3h8x2(:,1),heltab2x16(:,:,70))
  call Hloop_QA_Z(ntryL,G1H16(18),wf8(:,9),G1H2(3),ngZn,m3h8x2(:,2),heltab2x16(:,:,71))
  call Hloop_QA_W(ntryL,G1H16(19),wf8(:,9),G1H2(11),m3h8x2(:,3),heltab2x16(:,:,72))
  call Hloop_QA_W(ntryL,G1H4(53),ex1(:),G1H2(17),m3h2x2(:,96),heltab2x4(:,:,111))
  call Hloop_QA_Z(ntryL,G1H4(54),ex1(:),G1H2(21),ngZn,m3h2x2(:,97),heltab2x4(:,:,112))
  call Hloop_QA_W(ntryL,G1H4(55),ex1(:),G1H2(29),m3h2x2(:,98),heltab2x4(:,:,113))
  call Hloop_AQ_V(ntryL,G1H16(20),wf8(:,44),G1H2(33),m3h8x2(:,4),heltab2x16(:,:,73))
  call Hloop_AQ_Z(ntryL,G1H16(21),wf8(:,44),G1H2(35),ngZl,m3h8x2(:,5),heltab2x16(:,:,74))
  call Hloop_AQ_W(ntryL,G1H16(22),wf8(:,44),G1H2(88),m3h8x2(:,6),heltab2x16(:,:,75))
  call Hloop_AQ_V(ntryL,G1H16(23),ex4(:),G1H8(42),m3h2x8(:,56),heltab2x16(:,:,76))
  call Hloop_AQ_Z(ntryL,G1H16(24),ex4(:),G1H8(43),ngZl,m3h2x8(:,57),heltab2x16(:,:,77))
  call Hloop_AQ_W(ntryL,G1H16(25),ex4(:),G1H8(44),m3h2x8(:,58),heltab2x16(:,:,78))
  call Hloop_QA_W(ntryL,G1H16(26),ex1(:),G1H8(45),m3h2x8(:,59),heltab2x16(:,:,79))
  call Hloop_QA_Z(ntryL,G1H16(27),ex1(:),G1H8(46),ngZn,m3h2x8(:,60),heltab2x16(:,:,80))
  call Hloop_QA_W(ntryL,G1H16(28),ex1(:),G1H8(47),m3h2x8(:,61),heltab2x16(:,:,81))
  call Hloop_QA_W(ntryL,G1H4(56),ex1(:),G1H2(39),m3h2x2(:,99),heltab2x4(:,:,114))
  call Hloop_QA_Z(ntryL,G1H4(59),ex1(:),G1H2(89),ngZn,m3h2x2(:,100),heltab2x4(:,:,115))
  call Hloop_QA_W(ntryL,G1H4(60),ex1(:),G1H2(93),m3h2x2(:,101),heltab2x4(:,:,116))
  call Hloop_AQ_V(ntryL,G1H4(1),ex4(:),G1H2(41),m3h2x2(:,102),heltab2x4(:,:,117))
  call Hloop_AQ_Z(ntryL,G1H4(2),ex4(:),G1H2(45),ngZl,m3h2x2(:,103),heltab2x4(:,:,118))
  call Hloop_AQ_W(ntryL,G1H4(8),ex4(:),G1H2(96),m3h2x2(:,104),heltab2x4(:,:,119))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex2(:),G1H4(40),ngZn,m3h2x4(:,69),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(40),54,0,G2H4(15),n2h4(74))
  call Hloop_AQ_Z(ntryL,G1H8(4),ex2(:),G1H4(37),ngZn,m3h2x4(:,70),heltab2x8(:,:,87))
  call Hloop_AQ_W(ntryL,G1H8(10),ex2(:),G1H4(44),m3h2x4(:,71),heltab2x8(:,:,88))
  call Hloop_AQ_Z(ntryL,G2H8(13),ex2(:),G2H4(16),ngZn,m3h2x4(:,72),heltab2x8(:,:,89))
  call Hloop_AQ_W(ntryL,G2H8(14),ex2(:),G2H4(17),m3h2x4(:,73),heltab2x8(:,:,90))
  call Hloop_AQ_W(ntryL,G2H8(15),ex2(:),G2H4(18),m3h2x4(:,74),heltab2x8(:,:,91))
  call Hloop_WA_Q(ntryL,G1H8(17),ex3(:),G1H4(39),m3h2x4(:,75),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(39),54,0,G2H4(19),n2h4(75))
  call Hloop_QA_Z(ntryL,G1H8(18),ex3(:),G1H4(45),ngZn,m3h2x4(:,76),heltab2x8(:,:,93))
  call Hloop_QA_Z(ntryL,G2H8(16),ex3(:),G2H4(20),ngZn,m3h2x4(:,77),heltab2x8(:,:,94))
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(136),mass4set(:,6),  & 
G1H8(2),G1H8(4),G1H8(10),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(4),4,8)
  call Hloop_UV_W(ntryL,G1H8(19),50,wf4(:,1),9,G2H2(23),m3h4x2(:,18),heltab2x8(:,:,95))
  call Hloop_QA_W(ntryL,G1H4(11),ex3(:),G1H2(51),m3h2x2(:,105),heltab2x4(:,:,120))
  call Hloop_QA_Z(ntryL,G1H4(12),ex3(:),G1H2(64),ngZn,m3h2x2(:,106),heltab2x4(:,:,121))
  call Hloop_QA_W(ntryL,G1H4(18),ex3(:),G1H2(98),m3h2x2(:,107),heltab2x4(:,:,122))
  call Hloop_AQ_V(ntryL,G1H16(29),wf8(:,15),G1H2(59),m3h8x2(:,7),heltab2x16(:,:,82))
  call Hloop_AQ_Z(ntryL,G1H16(30),wf8(:,15),G1H2(63),ngZl,m3h8x2(:,8),heltab2x16(:,:,83))
  call Hloop_AQ_W(ntryL,G1H16(31),wf8(:,15),G1H2(84),m3h8x2(:,9),heltab2x16(:,:,84))
  call Hloop_QA_Z(ntryL,G1H16(1),ex3(:),G1H8(19),ngZn,m3h2x8(:,62),heltab2x16(:,:,85))
  call Hloop_AQ_Z(ntryL,G1H16(2),ex2(:),G1H8(48),ngZn,m3h2x8(:,63),heltab2x16(:,:,86))
  call Hloop_AQ_W(ntryL,G1H16(3),ex2(:),G1H8(49),m3h2x8(:,64),heltab2x16(:,:,87))
  call Hloop_AQ_Z(ntryL,G1H4(19),ex2(:),G1H2(75),ngZn,m3h2x2(:,108),heltab2x4(:,:,123))
  call Hloop_QA_Z(ntryL,G1H4(20),ex3(:),G1H2(77),ngZn,m3h2x2(:,109),heltab2x4(:,:,124))
  call Hloop_QA_W(ntryL,G1H4(26),ex3(:),G1H2(100),m3h2x2(:,110),heltab2x4(:,:,125))
  call Hloop_AQ_Z(ntryL,G1H4(29),ex2(:),G1H2(101),ngZn,m3h2x2(:,111),heltab2x4(:,:,126))
  call Hloop_AQ_W(ntryL,G1H4(30),ex2(:),G1H2(102),m3h2x2(:,112),heltab2x4(:,:,127))
  call Hloop_QA_Z(ntryL,G1H4(36),ex3(:),G1H2(106),ngZn,m3h2x2(:,113),heltab2x4(:,:,128))
  call Hloop_AQ_W(ntryL,G1H4(47),ex4(:),G1H2(107),m3h2x2(:,114),heltab2x4(:,:,129))
  call Hloop_AQ_Z(ntryL,G1H4(61),ex4(:),G1H2(108),ngZl,m3h2x2(:,115),heltab2x4(:,:,130))
  call Hloop_ZQ_A(ntryL,G1H4(62),ex2(:),G1H2(112),ngZn,m3h2x2(:,116),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(112),59,0,G2H2(24),n2h2(49))
  call Hloop_WQ_A(ntryL,G1H4(63),ex2(:),G1H2(113),m3h2x2(:,117),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(113),59,0,G2H2(25),n2h2(50))
  call Hloop_ZA_Q(ntryL,G1H4(64),ex3(:),G1H2(114),ngZn,m3h2x2(:,118),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(114),61,0,G2H2(26),n2h2(51))
  call Hloop_WA_Q(ntryL,G1H4(21),ex1(:),G1H2(118),m3h2x2(:,119),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(118),55,0,G2H2(27),n2h2(52))
call HGT_raise_alpha_OLR(G1H4(22),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(22),ex4(:),G1H2(119),m3h2x2(:,120),heltab2x4(:,:,135))
  call Hloop_WA_Q(ntryL,G1H4(28),ex1(:),G1H2(120),m3h2x2(:,121),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(120),55,0,G2H2(29),n2h2(53))
  call Hloop_WA_Q(ntryL,G1H4(33),ex1(:),G1H2(124),m3h2x2(:,122),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(124),55,0,G2H2(30),n2h2(54))
  call Hloop_WA_Q(ntryL,G1H4(34),ex1(:),G1H2(125),m3h2x2(:,123),heltab2x4(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(125),55,0,G2H2(32),n2h2(55))
call HGT_raise_alpha_OLR(G1H4(3),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(3),ex4(:),G1H2(126),ngZl,m3h2x2(:,124),heltab2x4(:,:,139))
  call Hloop_WA_Q(ntryL,G1H4(9),ex1(:),G1H2(130),m3h2x2(:,125),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(130),55,0,G2H2(33),n2h2(56))
  call Hloop_WA_Q(ntryL,G1H4(10),ex1(:),G1H2(131),m3h2x2(:,126),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(131),55,0,G2H2(35),n2h2(57))
  call Hloop_AW_Q(ntryL,G1H8(14),wf4(:,1),G1H2(132),m3h4x2(:,19),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(132),47,0,G2H2(36),n2h2(58))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(1),ex5(:),G1H4(46),m3h2x4(:,78),heltab2x8(:,:,97))
  call Hloop_AW_Q(ntryL,G1H8(11),wf4(:,1),G1H2(136),m3h4x2(:,20),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(136),47,0,G2H2(38),n2h2(59))
  call Hloop_AW_Q(ntryL,G1H8(12),wf4(:,1),G1H2(137),m3h4x2(:,21),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(137),47,0,G2H2(39),n2h2(60))
  call Hloop_AW_Q(ntryL,G1H8(13),wf4(:,1),G1H2(138),m3h4x2(:,22),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(138),47,0,G2H2(41),n2h2(61))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(20),ex5(:),G1H4(51),ngZu,m3h2x4(:,79),heltab2x8(:,:,101))
  call Hloop_AW_Q(ntryL,G1H8(22),wf4(:,1),G1H2(142),m3h4x2(:,23),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(142),47,0,G2H2(42),n2h2(62))
  call Hloop_AW_Q(ntryL,G1H8(23),wf4(:,1),G1H2(143),m3h4x2(:,24),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(143),47,0,G2H2(44),n2h2(63))
  call Hloop_AZ_Q(ntryL,G1H8(5),wf4(:,2),G1H2(144),ngZu,m3h4x2(:,25),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(144),47,0,G2H2(45),n2h2(64))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(6),ex5(:),G1H4(52),m3h2x4(:,80),heltab2x8(:,:,105))
  call Hloop_AZ_Q(ntryL,G1H8(25),wf4(:,2),G1H2(148),ngZu,m3h4x2(:,26),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(148),47,0,G2H2(47),n2h2(65))
  call Hloop_AZ_Q(ntryL,G1H8(26),wf4(:,2),G1H2(149),ngZu,m3h4x2(:,27),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(149),47,0,G2H2(48),n2h2(66))
  call Hloop_AZ_Q(ntryL,G1H8(27),wf4(:,2),G1H2(150),ngZu,m3h4x2(:,28),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(150),47,0,G2H2(50),n2h2(67))
call HGT_raise_alpha_OLR(G1H8(28),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(28),ex5(:),G1H4(57),ngZu,m3h2x4(:,81),heltab2x8(:,:,109))
  call Hloop_AZ_Q(ntryL,G1H8(30),wf4(:,2),G1H2(154),ngZu,m3h4x2(:,29),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(154),47,0,G2H2(51),n2h2(68))
  call Hloop_AZ_Q(ntryL,G1H8(31),wf4(:,2),G1H2(155),ngZu,m3h4x2(:,30),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(155),47,0,G2H2(53),n2h2(69))
  call Hloop_AZ_Q(ntryL,G1H8(16),wf4(:,2),G1H2(156),ngZl,m3h4x2(:,31),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(156),55,0,G2H2(54),n2h2(70))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(8),ex4(:),G1H4(58),m3h2x4(:,82),heltab2x8(:,:,113))
  call Hloop_AZ_Q(ntryL,G1H8(7),wf4(:,2),G1H2(160),ngZl,m3h4x2(:,32),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(160),55,0,G2H2(56),n2h2(71))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf4(:,2),G1H2(161),ngZl,m3h4x2(:,33),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(161),55,0,G2H2(57),n2h2(72))
  call Hloop_AZ_Q(ntryL,G1H8(32),wf4(:,2),G1H2(162),ngZn,m3h4x2(:,34),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(162),55,0,G2H2(58),n2h2(73))
call HGT_raise_alpha_OLR(G1H8(33),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(33),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(33),ex4(:),G1H4(15),m3h2x4(:,83),heltab2x8(:,:,117))
  call Hloop_AZ_Q(ntryL,G1H8(35),wf4(:,2),G1H2(166),ngZn,m3h4x2(:,35),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(166),55,0,G2H2(59),n2h2(74))
  call Hloop_AZ_Q(ntryL,G1H8(36),wf4(:,2),G1H2(49),ngZn,m3h4x2(:,36),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(60),n2h2(75))
  call Hloop_AZ_Q(ntryL,G1H8(37),wf4(:,2),G1H2(55),ngZl,m3h4x2(:,37),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(55),55,0,G2H2(61),n2h2(76))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(38),ex4(:),G1H4(48),ngZl,m3h2x4(:,84),heltab2x8(:,:,121))
  call Hloop_AZ_Q(ntryL,G1H8(40),wf4(:,2),G1H2(68),ngZl,m3h4x2(:,38),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(68),55,0,G2H2(62),n2h2(77))
  call Hloop_AZ_Q(ntryL,G1H8(41),wf4(:,2),G1H2(73),ngZl,m3h4x2(:,39),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(73),55,0,G2H2(63),n2h2(78))
  call Hloop_QW_A(ntryL,G1H8(2),wf4(:,1),G1H2(79),m3h4x2(:,40),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(79),59,0,G2H2(64),n2h2(79))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(4),ex3(:),G1H4(49),m3h2x4(:,85),heltab2x8(:,:,125))
  call Hloop_QW_A(ntryL,G1H8(17),wf4(:,1),G1H2(13),m3h4x2(:,41),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(13),59,0,G2H2(65),n2h2(80))
  call Hloop_QW_A(ntryL,G1H8(18),wf4(:,1),G1H2(19),m3h4x2(:,42),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(19),59,0,G2H2(66),n2h2(81))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(50)])
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(108)])
call HGT_w2_OLR(G1H2(20),1,1,2)
call HGT_w2_invQ_OLR(G1H2(20),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(107)])
call HGT_w2_OLR(G1H2(37),1,1,2)
call HGT_w2_invQ_OLR(G1H2(37),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(92),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(100),[G1H2(6),G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(32),G1H2(8),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(78),[G1H2(99),G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(98),[G1H2(140),G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(69),G1H2(22),G1H2(10),G0H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(111),G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(94),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(116),G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(42),G1H2(58),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(122),G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(97),G1H2(86),G1H2(27),G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(135),G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(134),[G1H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(141),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(104),G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(88),[G1H2(129),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(109),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(159),G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(165),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(101),[G1H2(163)])
call HGT_w2_OLR(G1H2(26),1,1,2)
call HGT_w2_invQ_OLR(G1H2(26),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(26),ex1(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(8),n2h1(153))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(28),ex4(:),G2tensor(10),m3h2x1(:,159),heltab2x2(:,:,159))
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(14),ex1(:),G1H1(1),ngZn,m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(154))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(31),ex4(:),G2tensor(16),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(24),ngZl,m3h2x1(:,162),heltab2x2(:,:,162))
call HGT_w2_OLR(G1H2(38),1,1,2)
call HGT_w2_invQ_OLR(G1H2(38),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(38),ex1(:),G1H1(1),ngZn,m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(26),n2h1(155))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(28),m3h2x1(:,164),heltab2x2(:,:,164))
call HGT_w2_OLR(G1H2(62),1,1,2)
call HGT_w2_invQ_OLR(G1H2(62),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(62),ex1(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(156))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(4),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(6),ngZl,m3h2x1(:,167),heltab2x2(:,:,167))
call HGT_w2_OLR(G1H2(74),1,1,2)
call HGT_w2_invQ_OLR(G1H2(74),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(74),ex1(:),G1H1(1),ngZn,m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(157))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(46),ex4(:),G2tensor(54),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hloop_ZQ_A(ntryL,G1H2(7),ex2(:),G1H1(1),ngZn,m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(56),n2h1(158))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(49),ex3(:),G2tensor(14),ngZn,m3h2x1(:,171),heltab2x2(:,:,171))
  call Hloop_WQ_A(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(159))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(52),ex3(:),G2tensor(18),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hloop_ZA_Q(ntryL,G1H2(37),ex3(:),G1H1(1),ngZn,m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(20),n2h1(160))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(55),ex2(:),G2tensor(22),ngZn,m3h2x1(:,175),heltab2x2(:,:,175))
  call Hloop_ZQ_A(ntryL,G1H2(77),ex5(:),G1H1(1),ngZu,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(161))
  call Hloop_ZQ_A(ntryL,G1H2(64),ex5(:),G1H1(1),ngZu,m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(62),n2h1(162))
  call Hloop_ZQ_A(ntryL,G1H2(92),ex5(:),G1H1(1),ngZu,m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(163))
  call Hloop_WQ_A(ntryL,G1H2(100),ex5(:),G1H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(164))
  call Hloop_WQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(165))
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(7),mass4set(:,8),  & 
G1H2(25),G1H2(44),G1H2(70),G1H2(4),G1H2(12),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hloop_WQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(166))
  call Hloop_WQ_A(ntryL,G1H2(78),ex5(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(167))
  call Hloop_WQ_A(ntryL,G1H2(98),ex5(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(168))
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(7),mass4set(:,9),  & 
G1H2(76),G1H2(16),G1H2(24),G1H2(28),G1H2(30),2)
  call HG1shiftOLR(G1H2(16),16,2)
  call Hloop_WQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(169))
  call Hloop_WQ_A(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(170))
  call Hloop_WQ_A(ntryL,G1H2(94),ex5(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(171))
  call Hloop_WQ_A(ntryL,G1H2(84),ex5(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(172))
  call Hloop_VQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(173))
  call Hloop_VQ_A(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(174))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(22),mass4set(:,1),  & 
G1H2(112),G1H2(113),G1H2(114),G1H2(118),G1H2(120),2)
  call HG1shiftOLR(G1H2(113),16,2)
  call Hloop_VQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(175))
  call Hloop_VQ_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(176))
  call Hloop_ZQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),ngZu,m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(177))
  call Hloop_ZQ_A(ntryL,G1H2(66),ex5(:),G1H1(1),ngZu,m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(178))
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(22),mass4set(:,10),  & 
G1H2(124),G1H2(125),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(125),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(85),ex5(:),G1H1(1),ngZu,m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(179))
  call Hloop_ZQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),ngZu,m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(180))
  call Hloop_ZQ_A(ntryL,G1H2(75),ex5(:),G1H1(1),ngZu,m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(181))
  call Hloop_ZQ_A(ntryL,G1H2(134),ex5(:),G1H1(1),ngZu,m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(182))
  call Hloop_WQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(183))
  call Hloop_WQ_A(ntryL,G1H2(141),ex5(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(184))
  call Hloop_ZQ_A(ntryL,G1H2(89),ex5(:),G1H1(1),ngZu,m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(185))
  call Hloop_ZQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),ngZu,m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(186))
  call Hloop_WQ_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(187))
  call Hloop_WQ_A(ntryL,G1H2(88),ex5(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(188))
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,16),heltab2x4(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(189))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,17),heltab2x4(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(190))
  call Hloop_QZ_A(ntryL,G1H4(17),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,18),heltab2x4(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(191))
  call Hloop_QZ_A(ntryL,G1H4(13),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,19),heltab2x4(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(192))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,20),heltab2x4(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(193))
  call Hloop_QZ_A(ntryL,G1H4(23),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,21),heltab2x4(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(194))
  call Hloop_QZ_A(ntryL,G1H4(24),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,22),heltab2x4(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(195))
  call Hloop_QZ_A(ntryL,G1H4(25),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,23),heltab2x4(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(196))
  call Hloop_WQ_A(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(197))
  call Hloop_WQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(198))
  call Hloop_ZQ_A(ntryL,G1H2(103),ex5(:),G1H1(1),ngZu,m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(199))
  call Hloop_ZQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),ngZu,m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(200))
  call Hloop_WQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(201))
  call Hloop_VQ_A(ntryL,G1H2(115),ex5(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))



end subroutine vamp_1

end module ol_vamp_1_ppllll_ew_nexnmnmxeudx_1_/**/REALKIND
