
module ol_vamp_1_ppllll_ew_nexnmemxuux_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_ew_nexnmemxuux_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_ew_nexnmemxuux_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllll_ew_nexnmemxuux_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllll_ew_nexnmemxuux_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,133) :: G0
  complex(REALKIND), dimension(4,5,4,369) :: G1
  complex(REALKIND), dimension(4,15,4,307) :: G2
  complex(REALKIND), dimension(4,35,4,46) :: G3
  complex(REALKIND), dimension(5,77) :: G1tensor
  complex(REALKIND), dimension(15,149) :: G2tensor
  complex(REALKIND), dimension(35,151) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VQ_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,16),ZERO,G1(:,:,:,1))
  call loop_QA_V(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call check_last_VWW_V(l_switch,G1(:,:,:,2),wf(:,1),wf(:,2),G1tensor(:,1))
  call loop_VV_S(G1(:,:,:,2),wf(:,2),G1(:,:,:,3))
  call check_last_SV_V(l_switch,G1(:,:,:,3),wf(:,1),G1tensor(:,2))
  call loop_UV_W(G1(:,:,:,2),Q(:,48),wf(:,2),Q(:,10),G2(:,:,:,1))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,1))
  call loop_WA_Q(G2(:,:,:,1),wf(:,0),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,59),ZERO,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,-2),G3tensor(:,2))
  call loop_VA_Q(G1(:,:,:,2),wf(:,-3),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,56),ZERO,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,11),G2tensor(:,1))
  call loop_AQ_W(G2(:,:,:,3),wf(:,-1),G2(:,:,:,4))
  call check_last_UV_W(l_switch,G2(:,:,:,4),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,3))
  call loop_WA_Q(G2(:,:,:,4),wf(:,0),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,59),ZERO,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,-2),G3tensor(:,4))
  call loop_VA_Q(G1(:,:,:,2),wf(:,18),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,59),ZERO,G2(:,:,:,6))
  call check_last_AQ_V(l_switch,G2(:,:,:,6),wf(:,-2),G2tensor(:,2))
  call loop_QA_Z(G1(:,:,:,1),wf(:,-5),G1(:,:,:,6),gZu)
  call check_last_VWW_V(l_switch,G1(:,:,:,6),wf(:,1),wf(:,2),G1tensor(:,3))
  call loop_VV_S(G1(:,:,:,6),wf(:,2),G1(:,:,:,7))
  call check_last_SV_V(l_switch,G1(:,:,:,7),wf(:,1),G1tensor(:,4))
  call loop_UV_W(G1(:,:,:,6),Q(:,48),wf(:,2),Q(:,10),G2(:,:,:,7))
  call check_last_UV_W(l_switch,G2(:,:,:,7),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,5))
  call loop_WA_Q(G2(:,:,:,7),wf(:,0),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,59),ZERO,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-2),G3tensor(:,6))
  call loop_VV_S(G1(:,:,:,6),wf(:,1),G1(:,:,:,8))
  call check_last_SV_V(l_switch,G1(:,:,:,8),wf(:,2),G1tensor(:,5))
  call loop_UW_V(G1(:,:,:,6),Q(:,48),wf(:,1),Q(:,5),G2(:,:,:,9))
  call check_last_UW_V(l_switch,G2(:,:,:,9),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,7))
  call loop_WQ_A(G2(:,:,:,9),wf(:,-1),G2(:,:,:,10))
  call loop_Q_A(G2(:,:,:,10),Q(:,55),ZERO,G3(:,:,:,4))
  call check_last_QA_V(l_switch,G3(:,:,:,4),wf(:,-3),G3tensor(:,8))
  call loop_ZQ_A(G1(:,:,:,6),wf(:,11),G1(:,:,:,9),gZl)
  call loop_Q_A(G1(:,:,:,9),Q(:,55),ZERO,G2(:,:,:,11))
  call check_last_QA_V(l_switch,G2(:,:,:,11),wf(:,-3),G2tensor(:,3))
  call loop_ZA_Q(G1(:,:,:,6),wf(:,-3),G1(:,:,:,10),gZl)
  call loop_A_Q(G1(:,:,:,10),Q(:,56),ZERO,G2(:,:,:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,12),wf(:,11),G2tensor(:,4))
  call loop_AQ_W(G2(:,:,:,12),wf(:,-1),G2(:,:,:,13))
  call check_last_UV_W(l_switch,G2(:,:,:,13),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,9))
  call loop_WA_Q(G2(:,:,:,13),wf(:,0),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,59),ZERO,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,-2),G3tensor(:,10))
  call loop_ZQ_A(G1(:,:,:,6),wf(:,-1),G1(:,:,:,11),gZn)
  call loop_Q_A(G1(:,:,:,11),Q(:,50),ZERO,G2(:,:,:,15))
  call loop_QA_W(G2(:,:,:,15),wf(:,-3),G2(:,:,:,16))
  call check_last_UV_W(l_switch,G2(:,:,:,16),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,11))
  call loop_WA_Q(G2(:,:,:,16),wf(:,0),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,59),ZERO,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,-2),G3tensor(:,12))
  call loop_QW_A(G2(:,:,:,15),wf(:,1),G2(:,:,:,18))
  call loop_Q_A(G2(:,:,:,18),Q(:,55),ZERO,G3(:,:,:,7))
  call check_last_QA_V(l_switch,G3(:,:,:,7),wf(:,-3),G3tensor(:,13))
  call loop_ZA_Q(G1(:,:,:,6),wf(:,18),G1(:,:,:,12),gZl)
  call loop_A_Q(G1(:,:,:,12),Q(:,59),ZERO,G2(:,:,:,19))
  call check_last_AQ_V(l_switch,G2(:,:,:,19),wf(:,-2),G2tensor(:,5))
  call loop_ZQ_A(G1(:,:,:,6),wf(:,-2),G1(:,:,:,13),gZl)
  call loop_Q_A(G1(:,:,:,13),Q(:,52),ZERO,G2(:,:,:,20))
  call check_last_QA_V(l_switch,G2(:,:,:,20),wf(:,18),G2tensor(:,6))
  call loop_QA_W(G2(:,:,:,20),wf(:,0),G2(:,:,:,21))
  call check_last_UW_V(l_switch,G2(:,:,:,21),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,14))
  call loop_WQ_A(G2(:,:,:,21),wf(:,-1),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,55),ZERO,G3(:,:,:,8))
  call check_last_QA_V(l_switch,G3(:,:,:,8),wf(:,-3),G3tensor(:,15))
  call loop_ZA_Q(G1(:,:,:,6),wf(:,0),G1(:,:,:,14),gZn)
  call loop_A_Q(G1(:,:,:,14),Q(:,49),ZERO,G2(:,:,:,23))
  call loop_AQ_W(G2(:,:,:,23),wf(:,-2),G2(:,:,:,24))
  call check_last_UW_V(l_switch,G2(:,:,:,24),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,16))
  call loop_WQ_A(G2(:,:,:,24),wf(:,-1),G2(:,:,:,25))
  call loop_Q_A(G2(:,:,:,25),Q(:,55),ZERO,G3(:,:,:,9))
  call check_last_QA_V(l_switch,G3(:,:,:,9),wf(:,-3),G3tensor(:,17))
  call loop_AW_Q(G2(:,:,:,23),wf(:,2),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,59),ZERO,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,-2),G3tensor(:,18))
  call loop_QA_W(G1(:,:,:,1),wf(:,26),G1(:,:,:,15))
  call check_last_UV_W(l_switch,G1(:,:,:,15),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,7))
  call loop_WA_Q(G1(:,:,:,15),wf(:,0),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,59),ZERO,G2(:,:,:,27))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,-2),G2tensor(:,8))
  call loop_QW_A(G1(:,:,:,1),wf(:,1),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,21),ZERO,G2(:,:,:,28))
  call loop_QA_W(G2(:,:,:,28),wf(:,-5),G2(:,:,:,29))
  call check_last_UW_V(l_switch,G2(:,:,:,29),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,19))
  call loop_WQ_A(G2(:,:,:,29),wf(:,-1),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,55),ZERO,G3(:,:,:,11))
  call check_last_QA_V(l_switch,G3(:,:,:,11),wf(:,-3),G3tensor(:,20))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,32),ZERO,G1(:,:,:,18))
  call loop_AQ_Z(G1(:,:,:,18),wf(:,-4),G1(:,:,:,19),gZu)
  call check_last_VWW_V(l_switch,G1(:,:,:,19),wf(:,1),wf(:,2),G1tensor(:,6))
  call loop_VV_S(G1(:,:,:,19),wf(:,1),G1(:,:,:,20))
  call check_last_SV_V(l_switch,G1(:,:,:,20),wf(:,2),G1tensor(:,7))
  call loop_UW_V(G1(:,:,:,19),Q(:,48),wf(:,1),Q(:,5),G2(:,:,:,31))
  call check_last_UW_V(l_switch,G2(:,:,:,31),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,21))
  call loop_WQ_A(G2(:,:,:,31),wf(:,-1),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,55),ZERO,G3(:,:,:,12))
  call check_last_QA_V(l_switch,G3(:,:,:,12),wf(:,-3),G3tensor(:,22))
  call loop_VV_S(G1(:,:,:,19),wf(:,2),G1(:,:,:,21))
  call check_last_SV_V(l_switch,G1(:,:,:,21),wf(:,1),G1tensor(:,8))
  call loop_UV_W(G1(:,:,:,19),Q(:,48),wf(:,2),Q(:,10),G2(:,:,:,33))
  call check_last_UV_W(l_switch,G2(:,:,:,33),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,23))
  call loop_WA_Q(G2(:,:,:,33),wf(:,0),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,59),ZERO,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,-2),G3tensor(:,24))
  call loop_ZA_Q(G1(:,:,:,19),wf(:,-3),G1(:,:,:,22),gZl)
  call loop_A_Q(G1(:,:,:,22),Q(:,56),ZERO,G2(:,:,:,35))
  call check_last_AQ_V(l_switch,G2(:,:,:,35),wf(:,11),G2tensor(:,9))
  call loop_AQ_W(G2(:,:,:,35),wf(:,-1),G2(:,:,:,36))
  call check_last_UV_W(l_switch,G2(:,:,:,36),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,25))
  call loop_WA_Q(G2(:,:,:,36),wf(:,0),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,59),ZERO,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,-2),G3tensor(:,26))
  call loop_ZQ_A(G1(:,:,:,19),wf(:,11),G1(:,:,:,23),gZl)
  call loop_Q_A(G1(:,:,:,23),Q(:,55),ZERO,G2(:,:,:,38))
  call check_last_QA_V(l_switch,G2(:,:,:,38),wf(:,-3),G2tensor(:,10))
  call loop_ZQ_A(G1(:,:,:,19),wf(:,-1),G1(:,:,:,24),gZn)
  call loop_Q_A(G1(:,:,:,24),Q(:,50),ZERO,G2(:,:,:,39))
  call loop_QA_W(G2(:,:,:,39),wf(:,-3),G2(:,:,:,40))
  call check_last_UV_W(l_switch,G2(:,:,:,40),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,27))
  call loop_WA_Q(G2(:,:,:,40),wf(:,0),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,59),ZERO,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,-2),G3tensor(:,28))
  call loop_QW_A(G2(:,:,:,39),wf(:,1),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,55),ZERO,G3(:,:,:,16))
  call check_last_QA_V(l_switch,G3(:,:,:,16),wf(:,-3),G3tensor(:,29))
  call loop_ZQ_A(G1(:,:,:,19),wf(:,-2),G1(:,:,:,25),gZl)
  call loop_Q_A(G1(:,:,:,25),Q(:,52),ZERO,G2(:,:,:,43))
  call check_last_QA_V(l_switch,G2(:,:,:,43),wf(:,18),G2tensor(:,11))
  call loop_QA_W(G2(:,:,:,43),wf(:,0),G2(:,:,:,44))
  call check_last_UW_V(l_switch,G2(:,:,:,44),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,30))
  call loop_WQ_A(G2(:,:,:,44),wf(:,-1),G2(:,:,:,45))
  call loop_Q_A(G2(:,:,:,45),Q(:,55),ZERO,G3(:,:,:,17))
  call check_last_QA_V(l_switch,G3(:,:,:,17),wf(:,-3),G3tensor(:,31))
  call loop_ZA_Q(G1(:,:,:,19),wf(:,18),G1(:,:,:,26),gZl)
  call loop_A_Q(G1(:,:,:,26),Q(:,59),ZERO,G2(:,:,:,46))
  call check_last_AQ_V(l_switch,G2(:,:,:,46),wf(:,-2),G2tensor(:,12))
  call loop_ZA_Q(G1(:,:,:,19),wf(:,0),G1(:,:,:,27),gZn)
  call loop_A_Q(G1(:,:,:,27),Q(:,49),ZERO,G2(:,:,:,47))
  call loop_AQ_W(G2(:,:,:,47),wf(:,-2),G2(:,:,:,48))
  call check_last_UW_V(l_switch,G2(:,:,:,48),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,32))
  call loop_WQ_A(G2(:,:,:,48),wf(:,-1),G2(:,:,:,49))
  call loop_Q_A(G2(:,:,:,49),Q(:,55),ZERO,G3(:,:,:,18))
  call check_last_QA_V(l_switch,G3(:,:,:,18),wf(:,-3),G3tensor(:,33))
  call loop_AW_Q(G2(:,:,:,47),wf(:,2),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,59),ZERO,G3(:,:,:,19))
  call check_last_AQ_V(l_switch,G3(:,:,:,19),wf(:,-2),G3tensor(:,34))
  call loop_AW_Q(G1(:,:,:,18),wf(:,2),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,42),ZERO,G2(:,:,:,51))
  call check_last_AQ_V(l_switch,G2(:,:,:,51),wf(:,8),G2tensor(:,13))
  call loop_AW_Q(G2(:,:,:,51),wf(:,1),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,47),ZERO,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,-4),G3tensor(:,35))
  call loop_AQ_W(G2(:,:,:,51),wf(:,-4),G2(:,:,:,53))
  call check_last_UV_W(l_switch,G2(:,:,:,53),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,36))
  call loop_WA_Q(G2(:,:,:,53),wf(:,0),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,59),ZERO,G3(:,:,:,21))
  call check_last_AQ_V(l_switch,G3(:,:,:,21),wf(:,-2),G3tensor(:,37))
  call loop_AQ_W(G1(:,:,:,18),wf(:,8),G1(:,:,:,29))
  call check_last_UW_V(l_switch,G1(:,:,:,29),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,14))
  call loop_WQ_A(G1(:,:,:,29),wf(:,-1),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,55),ZERO,G2(:,:,:,55))
  call check_last_QA_V(l_switch,G2(:,:,:,55),wf(:,-3),G2tensor(:,15))
  call loop_AV_Q(G1(:,:,:,18),wf(:,4),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,47),ZERO,G2(:,:,:,56))
  call check_last_AQ_V(l_switch,G2(:,:,:,56),wf(:,-4),G2tensor(:,16))
  call loop_AZ_Q(G1(:,:,:,18),wf(:,4),G1(:,:,:,32),gZu)
  call loop_A_Q(G1(:,:,:,32),Q(:,47),ZERO,G2(:,:,:,57))
  call check_last_AQ_V(l_switch,G2(:,:,:,57),wf(:,-4),G2tensor(:,17))
  call loop_AQ_V(G1(:,:,:,18),wf(:,-4),G1(:,:,:,33))
  call loop_VV_S(G1(:,:,:,33),wf(:,2),G1(:,:,:,34))
  call check_last_SV_V(l_switch,G1(:,:,:,34),wf(:,1),G1tensor(:,9))
  call loop_UV_W(G1(:,:,:,33),Q(:,48),wf(:,2),Q(:,10),G2(:,:,:,58))
  call check_last_UV_W(l_switch,G2(:,:,:,58),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,38))
  call loop_WA_Q(G2(:,:,:,58),wf(:,0),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,59),ZERO,G3(:,:,:,22))
  call check_last_AQ_V(l_switch,G3(:,:,:,22),wf(:,-2),G3tensor(:,39))
  call loop_VA_Q(G1(:,:,:,33),wf(:,-3),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,56),ZERO,G2(:,:,:,60))
  call check_last_AQ_V(l_switch,G2(:,:,:,60),wf(:,11),G2tensor(:,18))
  call loop_AQ_W(G2(:,:,:,60),wf(:,-1),G2(:,:,:,61))
  call check_last_UV_W(l_switch,G2(:,:,:,61),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,40))
  call loop_WA_Q(G2(:,:,:,61),wf(:,0),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,59),ZERO,G3(:,:,:,23))
  call check_last_AQ_V(l_switch,G3(:,:,:,23),wf(:,-2),G3tensor(:,41))
  call loop_VA_Q(G1(:,:,:,33),wf(:,18),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,59),ZERO,G2(:,:,:,63))
  call check_last_AQ_V(l_switch,G2(:,:,:,63),wf(:,-2),G2tensor(:,19))
  call loop_AV_Q(G1(:,:,:,18),wf(:,108),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,47),ZERO,G2(:,:,:,64))
  call check_last_AQ_V(l_switch,G2(:,:,:,64),wf(:,-4),G2tensor(:,20))
  call loop_AZ_Q(G1(:,:,:,18),wf(:,109),G1(:,:,:,38),gZu)
  call loop_A_Q(G1(:,:,:,38),Q(:,47),ZERO,G2(:,:,:,65))
  call check_last_AQ_V(l_switch,G2(:,:,:,65),wf(:,-4),G2tensor(:,21))
  call loop_AZ_Q(G1(:,:,:,18),wf(:,110),G1(:,:,:,39),gZu)
  call loop_A_Q(G1(:,:,:,39),Q(:,47),ZERO,G2(:,:,:,66))
  call check_last_AQ_V(l_switch,G2(:,:,:,66),wf(:,-4),G2tensor(:,22))
  call loop_AV_Q(G1(:,:,:,18),wf(:,112),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,47),ZERO,G2(:,:,:,67))
  call check_last_AQ_V(l_switch,G2(:,:,:,67),wf(:,-4),G2tensor(:,23))
  call loop_AZ_Q(G1(:,:,:,18),wf(:,113),G1(:,:,:,41),gZu)
  call loop_A_Q(G1(:,:,:,41),Q(:,47),ZERO,G2(:,:,:,68))
  call check_last_AQ_V(l_switch,G2(:,:,:,68),wf(:,-4),G2tensor(:,24))
  call loop_AZ_Q(G1(:,:,:,18),wf(:,114),G1(:,:,:,42),gZu)
  call loop_A_Q(G1(:,:,:,42),Q(:,47),ZERO,G2(:,:,:,69))
  call check_last_AQ_V(l_switch,G2(:,:,:,69),wf(:,-4),G2tensor(:,25))
  call loop_ZQ_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4),gZu)
  call loop_Q_A(G0(:,:,:,4),Q(:,16),ZERO,G1(:,:,:,43))
  call loop_QA_Z(G1(:,:,:,43),wf(:,-5),G1(:,:,:,44),gZu)
  call check_last_VWW_V(l_switch,G1(:,:,:,44),wf(:,1),wf(:,2),G1tensor(:,10))
  call check_last_VS_V(l_switch,G1(:,:,:,44),wf(:,107),G1tensor(:,11))
  call loop_QA_W(G1(:,:,:,43),wf(:,26),G1(:,:,:,45))
  call check_last_UV_W(l_switch,G1(:,:,:,45),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,26))
  call loop_WQ_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,16),ZERO,G1(:,:,:,46))
  call loop_QA_W(G1(:,:,:,46),wf(:,-5),G1(:,:,:,47))
  call check_last_WWV_V(l_switch,G1(:,:,:,47),wf(:,1),wf(:,2),G1tensor(:,12))
  call check_last_VS_V(l_switch,G1(:,:,:,47),wf(:,107),G1tensor(:,13))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,48),wf(:,4),Q(:,15),G2tensor(:,27))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,48),wf(:,108),Q(:,15),G2tensor(:,28))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,48),wf(:,109),Q(:,15),G2tensor(:,29))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,48),wf(:,110),Q(:,15),G2tensor(:,30))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,48),wf(:,112),Q(:,15),G2tensor(:,31))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,48),wf(:,113),Q(:,15),G2tensor(:,32))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,48),wf(:,114),Q(:,15),G2tensor(:,33))
  call loop_QA_Z(G1(:,:,:,46),wf(:,26),G1(:,:,:,48),gZd)
  call check_last_UW_V(l_switch,G1(:,:,:,48),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,34))
  call loop_QW_A(G1(:,:,:,46),wf(:,2),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,26),ZERO,G2(:,:,:,70))
  call loop_QA_Z(G2(:,:,:,70),wf(:,-5),G2(:,:,:,71),gZu)
  call check_last_UW_V(l_switch,G2(:,:,:,71),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,42))
  call loop_WWV_V(G0(:,:,:,1),wf(:,3),wf(:,1),G0(:,:,:,6))
  call loop_WQ_A(G0(:,:,:,6),wf(:,-1),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,55),ZERO,G1(:,:,:,50))
  call check_last_QA_V(l_switch,G1(:,:,:,50),wf(:,-3),G1tensor(:,14))
  call check_last_UW_V(l_switch,G0(:,:,:,6),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,15))
  call loop_QA_W(G0(:,:,:,1),wf(:,-3),G0(:,:,:,8))
  call loop_WWV_V(G0(:,:,:,8),wf(:,1),wf(:,3),G0(:,:,:,9))
  call loop_ZQ_A(G0(:,:,:,9),wf(:,-1),G0(:,:,:,10),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,10),Q(:,63),ZERO,G1tensor(:,16))
  call loop_WWV_V(G0(:,:,:,8),wf(:,1),wf(:,5),G0(:,:,:,11))
  call loop_ZQ_A(G0(:,:,:,11),wf(:,-1),G0(:,:,:,12),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,12),Q(:,63),ZERO,G1tensor(:,17))
  call loop_UW_V(G0(:,:,:,8),Q(:,8),wf(:,3),Q(:,48),G1(:,:,:,51))
  call loop_WQ_A(G1(:,:,:,51),wf(:,11),G1(:,:,:,52))
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,63),ZERO,G2tensor(:,35))
  call loop_UW_V(G0(:,:,:,8),Q(:,8),wf(:,5),Q(:,48),G1(:,:,:,53))
  call loop_WQ_A(G1(:,:,:,53),wf(:,11),G1(:,:,:,54))
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,63),ZERO,G2tensor(:,36))
  call loop_VS_V(G0(:,:,:,8),wf(:,74),G0(:,:,:,13))
  call loop_ZQ_A(G0(:,:,:,13),wf(:,-1),G0(:,:,:,14),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,14),Q(:,63),ZERO,G1tensor(:,18))
  call loop_VS_V(G0(:,:,:,8),wf(:,76),G0(:,:,:,15))
  call loop_ZQ_A(G0(:,:,:,15),wf(:,-1),G0(:,:,:,16),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,16),Q(:,63),ZERO,G1tensor(:,19))
  call loop_UV_W(G0(:,:,:,8),Q(:,8),wf(:,77),Q(:,53),G1(:,:,:,55))
  call loop_ZQ_A(G1(:,:,:,55),wf(:,-1),G1(:,:,:,56),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,56),Q(:,63),ZERO,G2tensor(:,37))
  call loop_UV_W(G0(:,:,:,8),Q(:,8),wf(:,79),Q(:,53),G1(:,:,:,57))
  call loop_ZQ_A(G1(:,:,:,57),wf(:,-1),G1(:,:,:,58),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,58),Q(:,63),ZERO,G2tensor(:,38))
  call loop_VV_S(G0(:,:,:,8),wf(:,1),G0(:,:,:,17))
  call loop_SV_V(G0(:,:,:,17),wf(:,5),G0(:,:,:,18))
  call loop_ZQ_A(G0(:,:,:,18),wf(:,-1),G0(:,:,:,19),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,19),Q(:,63),ZERO,G1tensor(:,20))
  call loop_WA_Q(G0(:,:,:,8),wf(:,-5),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,40),ZERO,G1(:,:,:,59))
  call loop_AQ_W(G1(:,:,:,59),wf(:,-4),G1(:,:,:,60))
  call loop_WQ_A(G1(:,:,:,60),wf(:,11),G1(:,:,:,61))
  call check_last_Q_A(l_switch,G1(:,:,:,61),Q(:,63),ZERO,G2tensor(:,39))
  call loop_AQ_Z(G1(:,:,:,59),wf(:,8),G1(:,:,:,62),gZd)
  call loop_ZQ_A(G1(:,:,:,62),wf(:,-1),G1(:,:,:,63),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,63),Q(:,63),ZERO,G2tensor(:,40))
  call loop_AW_Q(G1(:,:,:,59),wf(:,1),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,45),ZERO,G2(:,:,:,72))
  call loop_AQ_Z(G2(:,:,:,72),wf(:,-4),G2(:,:,:,73),gZu)
  call loop_ZQ_A(G2(:,:,:,73),wf(:,-1),G2(:,:,:,74),gZn)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,63),ZERO,G3tensor(:,43))
  call loop_UV_W(G0(:,:,:,8),Q(:,8),wf(:,111),Q(:,53),G1(:,:,:,65))
  call loop_ZQ_A(G1(:,:,:,65),wf(:,-1),G1(:,:,:,66),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,63),ZERO,G2tensor(:,41))
  call loop_WQ_A(G0(:,:,:,8),wf(:,8),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,29),ZERO,G1(:,:,:,67))
  call loop_QA_Z(G1(:,:,:,67),wf(:,-5),G1(:,:,:,68),gZu)
  call loop_ZQ_A(G1(:,:,:,68),wf(:,-1),G1(:,:,:,69),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,69),Q(:,63),ZERO,G2tensor(:,42))
  call loop_UV_W(G0(:,:,:,8),Q(:,8),wf(:,1),Q(:,5),G1(:,:,:,70))
  call loop_ZA_Q(G1(:,:,:,70),wf(:,-5),G1(:,:,:,71),gZu)
  call loop_A_Q(G1(:,:,:,71),Q(:,45),ZERO,G2(:,:,:,75))
  call loop_AQ_Z(G2(:,:,:,75),wf(:,-4),G2(:,:,:,76),gZu)
  call loop_ZQ_A(G2(:,:,:,76),wf(:,-1),G2(:,:,:,77),gZn)
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,63),ZERO,G3tensor(:,44))
  call loop_ZQ_A(G1(:,:,:,70),wf(:,-4),G1(:,:,:,72),gZu)
  call loop_Q_A(G1(:,:,:,72),Q(:,29),ZERO,G2(:,:,:,78))
  call loop_QA_Z(G2(:,:,:,78),wf(:,-5),G2(:,:,:,79),gZu)
  call loop_ZQ_A(G2(:,:,:,79),wf(:,-1),G2(:,:,:,80),gZn)
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,63),ZERO,G3tensor(:,45))
  call loop_UV_W(G0(:,:,:,8),Q(:,8),wf(:,116),Q(:,53),G1(:,:,:,73))
  call loop_ZQ_A(G1(:,:,:,73),wf(:,-1),G1(:,:,:,74),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,74),Q(:,63),ZERO,G2tensor(:,43))
  call loop_UV_W(G0(:,:,:,8),Q(:,8),wf(:,117),Q(:,53),G1(:,:,:,75))
  call loop_ZQ_A(G1(:,:,:,75),wf(:,-1),G1(:,:,:,76),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,76),Q(:,63),ZERO,G2tensor(:,44))
  call loop_UV_W(G0(:,:,:,8),Q(:,8),wf(:,118),Q(:,53),G1(:,:,:,77))
  call loop_ZQ_A(G1(:,:,:,77),wf(:,-1),G1(:,:,:,78),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,78),Q(:,63),ZERO,G2tensor(:,45))
  call loop_WQ_A(G0(:,:,:,8),wf(:,-2),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,12),ZERO,G1(:,:,:,79))
  call loop_QA_Z(G1(:,:,:,79),wf(:,22),G1(:,:,:,80),gZn)
  call loop_ZQ_A(G1(:,:,:,80),wf(:,-1),G1(:,:,:,81),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,81),Q(:,63),ZERO,G2tensor(:,46))
  call loop_QA_Z(G0(:,:,:,1),wf(:,-3),G0(:,:,:,23),gZl)
  call loop_WWV_V(G0(:,:,:,23),wf(:,3),wf(:,1),G0(:,:,:,24))
  call loop_WQ_A(G0(:,:,:,24),wf(:,-1),G0(:,:,:,25))
  call check_last_Q_A(l_switch,G0(:,:,:,25),Q(:,63),ZERO,G1tensor(:,21))
  call loop_WWV_V(G0(:,:,:,23),wf(:,5),wf(:,1),G0(:,:,:,26))
  call loop_WQ_A(G0(:,:,:,26),wf(:,-1),G0(:,:,:,27))
  call check_last_Q_A(l_switch,G0(:,:,:,27),Q(:,63),ZERO,G1tensor(:,22))
  call loop_ZQ_A(G0(:,:,:,23),wf(:,15),G0(:,:,:,28),gZn)
  call loop_Q_A(G0(:,:,:,28),Q(:,58),ZERO,G1(:,:,:,82))
  call loop_QW_A(G1(:,:,:,82),wf(:,1),G1(:,:,:,83))
  call check_last_Q_A(l_switch,G1(:,:,:,83),Q(:,63),ZERO,G2tensor(:,47))
  call loop_VS_V(G0(:,:,:,23),wf(:,74),G0(:,:,:,29))
  call loop_WQ_A(G0(:,:,:,29),wf(:,-1),G0(:,:,:,30))
  call check_last_Q_A(l_switch,G0(:,:,:,30),Q(:,63),ZERO,G1tensor(:,23))
  call loop_VS_V(G0(:,:,:,23),wf(:,76),G0(:,:,:,31))
  call loop_WQ_A(G0(:,:,:,31),wf(:,-1),G0(:,:,:,32))
  call check_last_Q_A(l_switch,G0(:,:,:,32),Q(:,63),ZERO,G1tensor(:,24))
  call loop_UW_V(G0(:,:,:,23),Q(:,8),wf(:,77),Q(:,53),G1(:,:,:,84))
  call loop_WQ_A(G1(:,:,:,84),wf(:,-1),G1(:,:,:,85))
  call check_last_Q_A(l_switch,G1(:,:,:,85),Q(:,63),ZERO,G2tensor(:,48))
  call loop_UW_V(G0(:,:,:,23),Q(:,8),wf(:,79),Q(:,53),G1(:,:,:,86))
  call loop_WQ_A(G1(:,:,:,86),wf(:,-1),G1(:,:,:,87))
  call check_last_Q_A(l_switch,G1(:,:,:,87),Q(:,63),ZERO,G2tensor(:,49))
  call loop_VV_S(G0(:,:,:,23),wf(:,1),G0(:,:,:,33))
  call loop_SV_V(G0(:,:,:,33),wf(:,3),G0(:,:,:,34))
  call loop_WQ_A(G0(:,:,:,34),wf(:,-1),G0(:,:,:,35))
  call check_last_Q_A(l_switch,G0(:,:,:,35),Q(:,63),ZERO,G1tensor(:,25))
  call loop_SV_V(G0(:,:,:,33),wf(:,5),G0(:,:,:,36))
  call loop_WQ_A(G0(:,:,:,36),wf(:,-1),G0(:,:,:,37))
  call check_last_Q_A(l_switch,G0(:,:,:,37),Q(:,63),ZERO,G1tensor(:,26))
  call loop_UW_V(G0(:,:,:,23),Q(:,8),wf(:,1),Q(:,5),G1(:,:,:,88))
  call loop_UV_W(G1(:,:,:,88),Q(:,13),wf(:,3),Q(:,48),G2(:,:,:,81))
  call loop_WQ_A(G2(:,:,:,81),wf(:,-1),G2(:,:,:,82))
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,63),ZERO,G3tensor(:,46))
  call loop_UV_W(G1(:,:,:,88),Q(:,13),wf(:,5),Q(:,48),G2(:,:,:,83))
  call loop_WQ_A(G2(:,:,:,83),wf(:,-1),G2(:,:,:,84))
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,63),ZERO,G3tensor(:,47))
  call loop_WQ_A(G1(:,:,:,88),wf(:,-4),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,29),ZERO,G2(:,:,:,85))
  call loop_QA_W(G2(:,:,:,85),wf(:,-5),G2(:,:,:,86))
  call loop_WQ_A(G2(:,:,:,86),wf(:,-1),G2(:,:,:,87))
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,63),ZERO,G3tensor(:,48))
  call loop_ZQ_A(G0(:,:,:,23),wf(:,-4),G0(:,:,:,38),gZu)
  call loop_Q_A(G0(:,:,:,38),Q(:,24),ZERO,G1(:,:,:,90))
  call loop_QA_Z(G1(:,:,:,90),wf(:,-5),G1(:,:,:,91),gZu)
  call loop_ZQ_A(G1(:,:,:,91),wf(:,11),G1(:,:,:,92),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,92),Q(:,63),ZERO,G2tensor(:,50))
  call loop_QW_A(G1(:,:,:,90),wf(:,1),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,29),ZERO,G2(:,:,:,88))
  call loop_QA_W(G2(:,:,:,88),wf(:,-5),G2(:,:,:,89))
  call loop_WQ_A(G2(:,:,:,89),wf(:,-1),G2(:,:,:,90))
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,63),ZERO,G3tensor(:,49))
  call loop_ZA_Q(G0(:,:,:,23),wf(:,-5),G0(:,:,:,39),gZu)
  call loop_A_Q(G0(:,:,:,39),Q(:,40),ZERO,G1(:,:,:,94))
  call loop_AQ_Z(G1(:,:,:,94),wf(:,-4),G1(:,:,:,95),gZu)
  call loop_ZQ_A(G1(:,:,:,95),wf(:,11),G1(:,:,:,96),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,96),Q(:,63),ZERO,G2tensor(:,51))
  call loop_AQ_W(G1(:,:,:,94),wf(:,8),G1(:,:,:,97))
  call loop_WQ_A(G1(:,:,:,97),wf(:,-1),G1(:,:,:,98))
  call check_last_Q_A(l_switch,G1(:,:,:,98),Q(:,63),ZERO,G2tensor(:,52))
  call loop_UW_V(G0(:,:,:,23),Q(:,8),wf(:,111),Q(:,53),G1(:,:,:,99))
  call loop_WQ_A(G1(:,:,:,99),wf(:,-1),G1(:,:,:,100))
  call check_last_Q_A(l_switch,G1(:,:,:,100),Q(:,63),ZERO,G2tensor(:,53))
  call loop_ZQ_A(G0(:,:,:,23),wf(:,8),G0(:,:,:,40),gZd)
  call loop_Q_A(G0(:,:,:,40),Q(:,29),ZERO,G1(:,:,:,101))
  call loop_QA_W(G1(:,:,:,101),wf(:,-5),G1(:,:,:,102))
  call loop_WQ_A(G1(:,:,:,102),wf(:,-1),G1(:,:,:,103))
  call check_last_Q_A(l_switch,G1(:,:,:,103),Q(:,63),ZERO,G2tensor(:,54))
  call loop_UW_V(G0(:,:,:,23),Q(:,8),wf(:,116),Q(:,53),G1(:,:,:,104))
  call loop_WQ_A(G1(:,:,:,104),wf(:,-1),G1(:,:,:,105))
  call check_last_Q_A(l_switch,G1(:,:,:,105),Q(:,63),ZERO,G2tensor(:,55))
  call loop_UW_V(G0(:,:,:,23),Q(:,8),wf(:,117),Q(:,53),G1(:,:,:,106))
  call loop_WQ_A(G1(:,:,:,106),wf(:,-1),G1(:,:,:,107))
  call check_last_Q_A(l_switch,G1(:,:,:,107),Q(:,63),ZERO,G2tensor(:,56))
  call loop_UW_V(G0(:,:,:,23),Q(:,8),wf(:,118),Q(:,53),G1(:,:,:,108))
  call loop_WQ_A(G1(:,:,:,108),wf(:,-1),G1(:,:,:,109))
  call check_last_Q_A(l_switch,G1(:,:,:,109),Q(:,63),ZERO,G2tensor(:,57))
  call loop_ZQ_A(G0(:,:,:,23),wf(:,-2),G0(:,:,:,41),gZl)
  call loop_Q_A(G0(:,:,:,41),Q(:,12),ZERO,G1(:,:,:,110))
  call loop_QA_W(G1(:,:,:,110),wf(:,22),G1(:,:,:,111))
  call loop_WQ_A(G1(:,:,:,111),wf(:,-1),G1(:,:,:,112))
  call check_last_Q_A(l_switch,G1(:,:,:,112),Q(:,63),ZERO,G2tensor(:,58))
  call loop_WWV_V(G0(:,:,:,1),wf(:,5),wf(:,1),G0(:,:,:,42))
  call loop_WQ_A(G0(:,:,:,42),wf(:,-1),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,55),ZERO,G1(:,:,:,113))
  call check_last_QA_V(l_switch,G1(:,:,:,113),wf(:,-3),G1tensor(:,27))
  call check_last_UW_V(l_switch,G0(:,:,:,42),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,28))
  call loop_WWV_V(G0(:,:,:,1),wf(:,3),wf(:,2),G0(:,:,:,44))
  call loop_WA_Q(G0(:,:,:,44),wf(:,0),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,59),ZERO,G1(:,:,:,114))
  call check_last_AQ_V(l_switch,G1(:,:,:,114),wf(:,-2),G1tensor(:,29))
  call check_last_UV_W(l_switch,G0(:,:,:,44),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,30))
  call loop_AQ_W(G0(:,:,:,1),wf(:,-2),G0(:,:,:,46))
  call loop_WWV_V(G0(:,:,:,46),wf(:,2),wf(:,3),G0(:,:,:,47))
  call loop_ZA_Q(G0(:,:,:,47),wf(:,0),G0(:,:,:,48),gZn)
  call check_last_A_Q(l_switch,G0(:,:,:,48),Q(:,63),ZERO,G1tensor(:,31))
  call loop_WWV_V(G0(:,:,:,46),wf(:,2),wf(:,5),G0(:,:,:,49))
  call loop_ZA_Q(G0(:,:,:,49),wf(:,0),G0(:,:,:,50),gZn)
  call check_last_A_Q(l_switch,G0(:,:,:,50),Q(:,63),ZERO,G1tensor(:,32))
  call loop_VS_V(G0(:,:,:,46),wf(:,68),G0(:,:,:,51))
  call loop_ZA_Q(G0(:,:,:,51),wf(:,0),G0(:,:,:,52),gZn)
  call check_last_A_Q(l_switch,G0(:,:,:,52),Q(:,63),ZERO,G1tensor(:,33))
  call loop_VS_V(G0(:,:,:,46),wf(:,70),G0(:,:,:,53))
  call loop_ZA_Q(G0(:,:,:,53),wf(:,0),G0(:,:,:,54),gZn)
  call check_last_A_Q(l_switch,G0(:,:,:,54),Q(:,63),ZERO,G1tensor(:,34))
  call loop_UW_V(G0(:,:,:,46),Q(:,4),wf(:,71),Q(:,58),G1(:,:,:,115))
  call loop_ZA_Q(G1(:,:,:,115),wf(:,0),G1(:,:,:,116),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,116),Q(:,63),ZERO,G2tensor(:,59))
  call loop_UW_V(G0(:,:,:,46),Q(:,4),wf(:,73),Q(:,58),G1(:,:,:,117))
  call loop_ZA_Q(G1(:,:,:,117),wf(:,0),G1(:,:,:,118),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,118),Q(:,63),ZERO,G2tensor(:,60))
  call loop_VV_S(G0(:,:,:,46),wf(:,3),G0(:,:,:,55))
  call loop_SV_V(G0(:,:,:,55),wf(:,2),G0(:,:,:,56))
  call loop_ZA_Q(G0(:,:,:,56),wf(:,0),G0(:,:,:,57),gZn)
  call check_last_A_Q(l_switch,G0(:,:,:,57),Q(:,63),ZERO,G1tensor(:,35))
  call loop_VV_S(G0(:,:,:,46),wf(:,5),G0(:,:,:,58))
  call loop_SV_V(G0(:,:,:,58),wf(:,2),G0(:,:,:,59))
  call loop_ZA_Q(G0(:,:,:,59),wf(:,0),G0(:,:,:,60),gZn)
  call check_last_A_Q(l_switch,G0(:,:,:,60),Q(:,63),ZERO,G1tensor(:,36))
  call loop_UV_W(G0(:,:,:,46),Q(:,4),wf(:,3),Q(:,48),G1(:,:,:,119))
  call loop_UW_V(G1(:,:,:,119),Q(:,52),wf(:,2),Q(:,10),G2(:,:,:,91))
  call loop_ZA_Q(G2(:,:,:,91),wf(:,0),G2(:,:,:,92),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,92),Q(:,63),ZERO,G3tensor(:,50))
  call loop_WQ_A(G1(:,:,:,119),wf(:,-1),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,54),ZERO,G2(:,:,:,93))
  call loop_QA_Z(G2(:,:,:,93),wf(:,-3),G2(:,:,:,94),gZl)
  call loop_ZA_Q(G2(:,:,:,94),wf(:,0),G2(:,:,:,95),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,95),Q(:,63),ZERO,G3tensor(:,51))
  call loop_UV_W(G0(:,:,:,46),Q(:,4),wf(:,5),Q(:,48),G1(:,:,:,121))
  call loop_UW_V(G1(:,:,:,121),Q(:,52),wf(:,2),Q(:,10),G2(:,:,:,96))
  call loop_ZA_Q(G2(:,:,:,96),wf(:,0),G2(:,:,:,97),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,97),Q(:,63),ZERO,G3tensor(:,52))
  call loop_WQ_A(G1(:,:,:,121),wf(:,-1),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,54),ZERO,G2(:,:,:,98))
  call loop_QA_Z(G2(:,:,:,98),wf(:,-3),G2(:,:,:,99),gZl)
  call loop_ZA_Q(G2(:,:,:,99),wf(:,0),G2(:,:,:,100),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,63),ZERO,G3tensor(:,53))
  call loop_VV_S(G0(:,:,:,46),wf(:,2),G0(:,:,:,61))
  call loop_SV_V(G0(:,:,:,61),wf(:,5),G0(:,:,:,62))
  call loop_ZA_Q(G0(:,:,:,62),wf(:,0),G0(:,:,:,63),gZn)
  call check_last_A_Q(l_switch,G0(:,:,:,63),Q(:,63),ZERO,G1tensor(:,37))
  call loop_UW_V(G0(:,:,:,46),Q(:,4),wf(:,115),Q(:,58),G1(:,:,:,123))
  call loop_ZA_Q(G1(:,:,:,123),wf(:,0),G1(:,:,:,124),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,124),Q(:,63),ZERO,G2tensor(:,61))
  call loop_WA_Q(G0(:,:,:,46),wf(:,26),G0(:,:,:,64))
  call loop_A_Q(G0(:,:,:,64),Q(:,46),ZERO,G1(:,:,:,125))
  call loop_AQ_Z(G1(:,:,:,125),wf(:,-4),G1(:,:,:,126),gZu)
  call loop_ZA_Q(G1(:,:,:,126),wf(:,0),G1(:,:,:,127),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,127),Q(:,63),ZERO,G2tensor(:,62))
  call loop_WQ_A(G0(:,:,:,46),wf(:,-4),G0(:,:,:,65))
  call loop_Q_A(G0(:,:,:,65),Q(:,20),ZERO,G1(:,:,:,128))
  call loop_QA_Z(G1(:,:,:,128),wf(:,26),G1(:,:,:,129),gZd)
  call loop_ZA_Q(G1(:,:,:,129),wf(:,0),G1(:,:,:,130),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,130),Q(:,63),ZERO,G2tensor(:,63))
  call loop_QW_A(G1(:,:,:,128),wf(:,2),G1(:,:,:,131))
  call loop_Q_A(G1(:,:,:,131),Q(:,30),ZERO,G2(:,:,:,101))
  call loop_QA_Z(G2(:,:,:,101),wf(:,-5),G2(:,:,:,102),gZu)
  call loop_ZA_Q(G2(:,:,:,102),wf(:,0),G2(:,:,:,103),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,103),Q(:,63),ZERO,G3tensor(:,54))
  call loop_QA_W(G1(:,:,:,128),wf(:,-5),G1(:,:,:,132))
  call loop_UW_V(G1(:,:,:,132),Q(:,52),wf(:,2),Q(:,10),G2(:,:,:,104))
  call loop_ZA_Q(G2(:,:,:,104),wf(:,0),G2(:,:,:,105),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,105),Q(:,63),ZERO,G3tensor(:,55))
  call loop_WQ_A(G1(:,:,:,132),wf(:,-1),G1(:,:,:,133))
  call loop_Q_A(G1(:,:,:,133),Q(:,54),ZERO,G2(:,:,:,106))
  call loop_QA_Z(G2(:,:,:,106),wf(:,-3),G2(:,:,:,107),gZl)
  call loop_ZA_Q(G2(:,:,:,107),wf(:,0),G2(:,:,:,108),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,63),ZERO,G3tensor(:,56))
  call loop_UW_V(G0(:,:,:,46),Q(:,4),wf(:,2),Q(:,10),G1(:,:,:,134))
  call loop_ZA_Q(G1(:,:,:,134),wf(:,-5),G1(:,:,:,135),gZu)
  call loop_A_Q(G1(:,:,:,135),Q(:,46),ZERO,G2(:,:,:,109))
  call loop_AQ_Z(G2(:,:,:,109),wf(:,-4),G2(:,:,:,110),gZu)
  call loop_ZA_Q(G2(:,:,:,110),wf(:,0),G2(:,:,:,111),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,111),Q(:,63),ZERO,G3tensor(:,57))
  call loop_ZQ_A(G1(:,:,:,134),wf(:,-4),G1(:,:,:,136),gZu)
  call loop_Q_A(G1(:,:,:,136),Q(:,30),ZERO,G2(:,:,:,112))
  call loop_QA_Z(G2(:,:,:,112),wf(:,-5),G2(:,:,:,113),gZu)
  call loop_ZA_Q(G2(:,:,:,113),wf(:,0),G2(:,:,:,114),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,63),ZERO,G3tensor(:,58))
  call loop_UW_V(G0(:,:,:,46),Q(:,4),wf(:,119),Q(:,58),G1(:,:,:,137))
  call loop_ZA_Q(G1(:,:,:,137),wf(:,0),G1(:,:,:,138),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,138),Q(:,63),ZERO,G2tensor(:,64))
  call loop_UW_V(G0(:,:,:,46),Q(:,4),wf(:,120),Q(:,58),G1(:,:,:,139))
  call loop_ZA_Q(G1(:,:,:,139),wf(:,0),G1(:,:,:,140),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,140),Q(:,63),ZERO,G2tensor(:,65))
  call loop_UW_V(G0(:,:,:,46),Q(:,4),wf(:,121),Q(:,58),G1(:,:,:,141))
  call loop_ZA_Q(G1(:,:,:,141),wf(:,0),G1(:,:,:,142),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,142),Q(:,63),ZERO,G2tensor(:,66))
  call loop_WQ_A(G0(:,:,:,46),wf(:,15),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,54),ZERO,G1(:,:,:,143))
  call loop_QA_Z(G1(:,:,:,143),wf(:,-3),G1(:,:,:,144),gZl)
  call loop_ZA_Q(G1(:,:,:,144),wf(:,0),G1(:,:,:,145),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,145),Q(:,63),ZERO,G2tensor(:,67))
  call loop_WA_Q(G0(:,:,:,46),wf(:,-3),G0(:,:,:,67))
  call loop_A_Q(G0(:,:,:,67),Q(:,12),ZERO,G1(:,:,:,146))
  call loop_AQ_Z(G1(:,:,:,146),wf(:,15),G1(:,:,:,147),gZn)
  call loop_ZA_Q(G1(:,:,:,147),wf(:,0),G1(:,:,:,148),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,148),Q(:,63),ZERO,G2tensor(:,68))
  call loop_AQ_Z(G1(:,:,:,146),wf(:,-1),G1(:,:,:,149),gZn)
  call loop_ZA_Q(G1(:,:,:,149),wf(:,-5),G1(:,:,:,150),gZu)
  call loop_A_Q(G1(:,:,:,150),Q(:,46),ZERO,G2(:,:,:,115))
  call loop_AQ_Z(G2(:,:,:,115),wf(:,-4),G2(:,:,:,116),gZu)
  call loop_ZA_Q(G2(:,:,:,116),wf(:,0),G2(:,:,:,117),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,117),Q(:,63),ZERO,G3tensor(:,59))
  call loop_ZQ_A(G1(:,:,:,149),wf(:,-4),G1(:,:,:,151),gZu)
  call loop_Q_A(G1(:,:,:,151),Q(:,30),ZERO,G2(:,:,:,118))
  call loop_QA_Z(G2(:,:,:,118),wf(:,-5),G2(:,:,:,119),gZu)
  call loop_ZA_Q(G2(:,:,:,119),wf(:,0),G2(:,:,:,120),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,120),Q(:,63),ZERO,G3tensor(:,60))
  call loop_WQ_A(G0(:,:,:,46),wf(:,-1),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,6),ZERO,G1(:,:,:,152))
  call loop_QA_Z(G1(:,:,:,152),wf(:,47),G1(:,:,:,153),gZl)
  call loop_ZA_Q(G1(:,:,:,153),wf(:,0),G1(:,:,:,154),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,154),Q(:,63),ZERO,G2tensor(:,69))
  call loop_QA_Z(G1(:,:,:,152),wf(:,48),G1(:,:,:,155),gZl)
  call loop_ZA_Q(G1(:,:,:,155),wf(:,0),G1(:,:,:,156),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,156),Q(:,63),ZERO,G2tensor(:,70))
  call loop_QV_A(G1(:,:,:,152),wf(:,3),G1(:,:,:,157))
  call loop_Q_A(G1(:,:,:,157),Q(:,54),ZERO,G2(:,:,:,121))
  call loop_QA_Z(G2(:,:,:,121),wf(:,-3),G2(:,:,:,122),gZl)
  call loop_ZA_Q(G2(:,:,:,122),wf(:,0),G2(:,:,:,123),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,123),Q(:,63),ZERO,G3tensor(:,61))
  call loop_QZ_A(G1(:,:,:,152),wf(:,5),G1(:,:,:,158),gZl)
  call loop_Q_A(G1(:,:,:,158),Q(:,54),ZERO,G2(:,:,:,124))
  call loop_QA_Z(G2(:,:,:,124),wf(:,-3),G2(:,:,:,125),gZl)
  call loop_ZA_Q(G2(:,:,:,125),wf(:,0),G2(:,:,:,126),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,126),Q(:,63),ZERO,G3tensor(:,62))
  call loop_QA_Z(G1(:,:,:,152),wf(:,-3),G1(:,:,:,159),gZl)
  call loop_ZA_Q(G1(:,:,:,159),wf(:,-5),G1(:,:,:,160),gZu)
  call loop_A_Q(G1(:,:,:,160),Q(:,46),ZERO,G2(:,:,:,127))
  call loop_AQ_Z(G2(:,:,:,127),wf(:,-4),G2(:,:,:,128),gZu)
  call loop_ZA_Q(G2(:,:,:,128),wf(:,0),G2(:,:,:,129),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,129),Q(:,63),ZERO,G3tensor(:,63))
  call loop_ZQ_A(G1(:,:,:,159),wf(:,-4),G1(:,:,:,161),gZu)
  call loop_Q_A(G1(:,:,:,161),Q(:,30),ZERO,G2(:,:,:,130))
  call loop_QA_Z(G2(:,:,:,130),wf(:,-5),G2(:,:,:,131),gZu)
  call loop_ZA_Q(G2(:,:,:,131),wf(:,0),G2(:,:,:,132),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,63),ZERO,G3tensor(:,64))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,-2),G0(:,:,:,69),gZl)
  call loop_WWV_V(G0(:,:,:,69),wf(:,3),wf(:,2),G0(:,:,:,70))
  call loop_WA_Q(G0(:,:,:,70),wf(:,0),G0(:,:,:,71))
  call check_last_A_Q(l_switch,G0(:,:,:,71),Q(:,63),ZERO,G1tensor(:,38))
  call loop_WWV_V(G0(:,:,:,69),wf(:,5),wf(:,2),G0(:,:,:,72))
  call loop_WA_Q(G0(:,:,:,72),wf(:,0),G0(:,:,:,73))
  call check_last_A_Q(l_switch,G0(:,:,:,73),Q(:,63),ZERO,G1tensor(:,39))
  call loop_VS_V(G0(:,:,:,69),wf(:,68),G0(:,:,:,74))
  call loop_WA_Q(G0(:,:,:,74),wf(:,0),G0(:,:,:,75))
  call check_last_A_Q(l_switch,G0(:,:,:,75),Q(:,63),ZERO,G1tensor(:,40))
  call loop_VS_V(G0(:,:,:,69),wf(:,70),G0(:,:,:,76))
  call loop_WA_Q(G0(:,:,:,76),wf(:,0),G0(:,:,:,77))
  call check_last_A_Q(l_switch,G0(:,:,:,77),Q(:,63),ZERO,G1tensor(:,41))
  call loop_UV_W(G0(:,:,:,69),Q(:,4),wf(:,71),Q(:,58),G1(:,:,:,162))
  call loop_WA_Q(G1(:,:,:,162),wf(:,0),G1(:,:,:,163))
  call check_last_A_Q(l_switch,G1(:,:,:,163),Q(:,63),ZERO,G2tensor(:,71))
  call loop_UV_W(G0(:,:,:,69),Q(:,4),wf(:,73),Q(:,58),G1(:,:,:,164))
  call loop_WA_Q(G1(:,:,:,164),wf(:,0),G1(:,:,:,165))
  call check_last_A_Q(l_switch,G1(:,:,:,165),Q(:,63),ZERO,G2tensor(:,72))
  call loop_VV_S(G0(:,:,:,69),wf(:,5),G0(:,:,:,78))
  call loop_SV_V(G0(:,:,:,78),wf(:,2),G0(:,:,:,79))
  call loop_WA_Q(G0(:,:,:,79),wf(:,0),G0(:,:,:,80))
  call check_last_A_Q(l_switch,G0(:,:,:,80),Q(:,63),ZERO,G1tensor(:,42))
  call loop_VV_S(G0(:,:,:,69),wf(:,2),G0(:,:,:,81))
  call loop_SV_V(G0(:,:,:,81),wf(:,3),G0(:,:,:,82))
  call loop_WA_Q(G0(:,:,:,82),wf(:,0),G0(:,:,:,83))
  call check_last_A_Q(l_switch,G0(:,:,:,83),Q(:,63),ZERO,G1tensor(:,43))
  call loop_SV_V(G0(:,:,:,81),wf(:,5),G0(:,:,:,84))
  call loop_WA_Q(G0(:,:,:,84),wf(:,0),G0(:,:,:,85))
  call check_last_A_Q(l_switch,G0(:,:,:,85),Q(:,63),ZERO,G1tensor(:,44))
  call loop_UV_W(G0(:,:,:,69),Q(:,4),wf(:,2),Q(:,10),G1(:,:,:,166))
  call loop_UW_V(G1(:,:,:,166),Q(:,14),wf(:,3),Q(:,48),G2(:,:,:,133))
  call loop_WA_Q(G2(:,:,:,133),wf(:,0),G2(:,:,:,134))
  call check_last_A_Q(l_switch,G2(:,:,:,134),Q(:,63),ZERO,G3tensor(:,65))
  call loop_UW_V(G1(:,:,:,166),Q(:,14),wf(:,5),Q(:,48),G2(:,:,:,135))
  call loop_WA_Q(G2(:,:,:,135),wf(:,0),G2(:,:,:,136))
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,63),ZERO,G3tensor(:,66))
  call loop_WA_Q(G1(:,:,:,166),wf(:,-5),G1(:,:,:,167))
  call loop_A_Q(G1(:,:,:,167),Q(:,46),ZERO,G2(:,:,:,137))
  call loop_AQ_W(G2(:,:,:,137),wf(:,-4),G2(:,:,:,138))
  call loop_WA_Q(G2(:,:,:,138),wf(:,0),G2(:,:,:,139))
  call check_last_A_Q(l_switch,G2(:,:,:,139),Q(:,63),ZERO,G3tensor(:,67))
  call loop_UV_W(G0(:,:,:,69),Q(:,4),wf(:,115),Q(:,58),G1(:,:,:,168))
  call loop_WA_Q(G1(:,:,:,168),wf(:,0),G1(:,:,:,169))
  call check_last_A_Q(l_switch,G1(:,:,:,169),Q(:,63),ZERO,G2tensor(:,73))
  call loop_ZA_Q(G0(:,:,:,69),wf(:,26),G0(:,:,:,86),gZd)
  call loop_A_Q(G0(:,:,:,86),Q(:,46),ZERO,G1(:,:,:,170))
  call loop_AQ_W(G1(:,:,:,170),wf(:,-4),G1(:,:,:,171))
  call loop_WA_Q(G1(:,:,:,171),wf(:,0),G1(:,:,:,172))
  call check_last_A_Q(l_switch,G1(:,:,:,172),Q(:,63),ZERO,G2tensor(:,74))
  call loop_ZQ_A(G0(:,:,:,69),wf(:,-4),G0(:,:,:,87),gZu)
  call loop_Q_A(G0(:,:,:,87),Q(:,20),ZERO,G1(:,:,:,173))
  call loop_QA_W(G1(:,:,:,173),wf(:,26),G1(:,:,:,174))
  call loop_WA_Q(G1(:,:,:,174),wf(:,0),G1(:,:,:,175))
  call check_last_A_Q(l_switch,G1(:,:,:,175),Q(:,63),ZERO,G2tensor(:,75))
  call loop_QA_Z(G1(:,:,:,173),wf(:,-5),G1(:,:,:,176),gZu)
  call loop_UV_W(G1(:,:,:,176),Q(:,52),wf(:,2),Q(:,10),G2(:,:,:,140))
  call loop_WA_Q(G2(:,:,:,140),wf(:,0),G2(:,:,:,141))
  call check_last_A_Q(l_switch,G2(:,:,:,141),Q(:,63),ZERO,G3tensor(:,68))
  call loop_ZQ_A(G1(:,:,:,176),wf(:,-1),G1(:,:,:,177),gZn)
  call loop_Q_A(G1(:,:,:,177),Q(:,54),ZERO,G2(:,:,:,142))
  call loop_QA_W(G2(:,:,:,142),wf(:,-3),G2(:,:,:,143))
  call loop_WA_Q(G2(:,:,:,143),wf(:,0),G2(:,:,:,144))
  call check_last_A_Q(l_switch,G2(:,:,:,144),Q(:,63),ZERO,G3tensor(:,69))
  call loop_ZA_Q(G0(:,:,:,69),wf(:,-5),G0(:,:,:,88),gZu)
  call loop_A_Q(G0(:,:,:,88),Q(:,36),ZERO,G1(:,:,:,178))
  call loop_AW_Q(G1(:,:,:,178),wf(:,2),G1(:,:,:,179))
  call loop_A_Q(G1(:,:,:,179),Q(:,46),ZERO,G2(:,:,:,145))
  call loop_AQ_W(G2(:,:,:,145),wf(:,-4),G2(:,:,:,146))
  call loop_WA_Q(G2(:,:,:,146),wf(:,0),G2(:,:,:,147))
  call check_last_A_Q(l_switch,G2(:,:,:,147),Q(:,63),ZERO,G3tensor(:,70))
  call loop_AQ_Z(G1(:,:,:,178),wf(:,-4),G1(:,:,:,180),gZu)
  call loop_UV_W(G1(:,:,:,180),Q(:,52),wf(:,2),Q(:,10),G2(:,:,:,148))
  call loop_WA_Q(G2(:,:,:,148),wf(:,0),G2(:,:,:,149))
  call check_last_A_Q(l_switch,G2(:,:,:,149),Q(:,63),ZERO,G3tensor(:,71))
  call loop_ZQ_A(G1(:,:,:,180),wf(:,-1),G1(:,:,:,181),gZn)
  call loop_Q_A(G1(:,:,:,181),Q(:,54),ZERO,G2(:,:,:,150))
  call loop_QA_W(G2(:,:,:,150),wf(:,-3),G2(:,:,:,151))
  call loop_WA_Q(G2(:,:,:,151),wf(:,0),G2(:,:,:,152))
  call check_last_A_Q(l_switch,G2(:,:,:,152),Q(:,63),ZERO,G3tensor(:,72))
  call loop_UV_W(G0(:,:,:,69),Q(:,4),wf(:,119),Q(:,58),G1(:,:,:,182))
  call loop_WA_Q(G1(:,:,:,182),wf(:,0),G1(:,:,:,183))
  call check_last_A_Q(l_switch,G1(:,:,:,183),Q(:,63),ZERO,G2tensor(:,76))
  call loop_UV_W(G0(:,:,:,69),Q(:,4),wf(:,120),Q(:,58),G1(:,:,:,184))
  call loop_WA_Q(G1(:,:,:,184),wf(:,0),G1(:,:,:,185))
  call check_last_A_Q(l_switch,G1(:,:,:,185),Q(:,63),ZERO,G2tensor(:,77))
  call loop_UV_W(G0(:,:,:,69),Q(:,4),wf(:,121),Q(:,58),G1(:,:,:,186))
  call loop_WA_Q(G1(:,:,:,186),wf(:,0),G1(:,:,:,187))
  call check_last_A_Q(l_switch,G1(:,:,:,187),Q(:,63),ZERO,G2tensor(:,78))
  call loop_ZQ_A(G0(:,:,:,69),wf(:,15),G0(:,:,:,89),gZn)
  call loop_Q_A(G0(:,:,:,89),Q(:,54),ZERO,G1(:,:,:,188))
  call loop_QA_W(G1(:,:,:,188),wf(:,-3),G1(:,:,:,189))
  call loop_WA_Q(G1(:,:,:,189),wf(:,0),G1(:,:,:,190))
  call check_last_A_Q(l_switch,G1(:,:,:,190),Q(:,63),ZERO,G2tensor(:,79))
  call loop_ZA_Q(G0(:,:,:,69),wf(:,-3),G0(:,:,:,90),gZl)
  call loop_A_Q(G0(:,:,:,90),Q(:,12),ZERO,G1(:,:,:,191))
  call loop_AQ_W(G1(:,:,:,191),wf(:,15),G1(:,:,:,192))
  call loop_WA_Q(G1(:,:,:,192),wf(:,0),G1(:,:,:,193))
  call check_last_A_Q(l_switch,G1(:,:,:,193),Q(:,63),ZERO,G2tensor(:,80))
  call loop_AQ_W(G1(:,:,:,191),wf(:,-1),G1(:,:,:,194))
  call loop_UW_V(G1(:,:,:,194),Q(:,14),wf(:,3),Q(:,48),G2(:,:,:,153))
  call loop_WA_Q(G2(:,:,:,153),wf(:,0),G2(:,:,:,154))
  call check_last_A_Q(l_switch,G2(:,:,:,154),Q(:,63),ZERO,G3tensor(:,73))
  call loop_UW_V(G1(:,:,:,194),Q(:,14),wf(:,5),Q(:,48),G2(:,:,:,155))
  call loop_WA_Q(G2(:,:,:,155),wf(:,0),G2(:,:,:,156))
  call check_last_A_Q(l_switch,G2(:,:,:,156),Q(:,63),ZERO,G3tensor(:,74))
  call loop_WA_Q(G1(:,:,:,194),wf(:,-5),G1(:,:,:,195))
  call loop_A_Q(G1(:,:,:,195),Q(:,46),ZERO,G2(:,:,:,157))
  call loop_AQ_W(G2(:,:,:,157),wf(:,-4),G2(:,:,:,158))
  call loop_WA_Q(G2(:,:,:,158),wf(:,0),G2(:,:,:,159))
  call check_last_A_Q(l_switch,G2(:,:,:,159),Q(:,63),ZERO,G3tensor(:,75))
  call loop_ZQ_A(G0(:,:,:,69),wf(:,-1),G0(:,:,:,91),gZn)
  call loop_Q_A(G0(:,:,:,91),Q(:,6),ZERO,G1(:,:,:,196))
  call loop_QA_W(G1(:,:,:,196),wf(:,47),G1(:,:,:,197))
  call loop_WA_Q(G1(:,:,:,197),wf(:,0),G1(:,:,:,198))
  call check_last_A_Q(l_switch,G1(:,:,:,198),Q(:,63),ZERO,G2tensor(:,81))
  call loop_QA_W(G1(:,:,:,196),wf(:,48),G1(:,:,:,199))
  call loop_WA_Q(G1(:,:,:,199),wf(:,0),G1(:,:,:,200))
  call check_last_A_Q(l_switch,G1(:,:,:,200),Q(:,63),ZERO,G2tensor(:,82))
  call loop_QZ_A(G1(:,:,:,196),wf(:,5),G1(:,:,:,201),gZn)
  call loop_Q_A(G1(:,:,:,201),Q(:,54),ZERO,G2(:,:,:,160))
  call loop_QA_W(G2(:,:,:,160),wf(:,-3),G2(:,:,:,161))
  call loop_WA_Q(G2(:,:,:,161),wf(:,0),G2(:,:,:,162))
  call check_last_A_Q(l_switch,G2(:,:,:,162),Q(:,63),ZERO,G3tensor(:,76))
  call loop_QA_W(G1(:,:,:,196),wf(:,-3),G1(:,:,:,202))
  call loop_UW_V(G1(:,:,:,202),Q(:,14),wf(:,3),Q(:,48),G2(:,:,:,163))
  call loop_WA_Q(G2(:,:,:,163),wf(:,0),G2(:,:,:,164))
  call check_last_A_Q(l_switch,G2(:,:,:,164),Q(:,63),ZERO,G3tensor(:,77))
  call loop_UW_V(G1(:,:,:,202),Q(:,14),wf(:,5),Q(:,48),G2(:,:,:,165))
  call loop_WA_Q(G2(:,:,:,165),wf(:,0),G2(:,:,:,166))
  call check_last_A_Q(l_switch,G2(:,:,:,166),Q(:,63),ZERO,G3tensor(:,78))
  call loop_WA_Q(G1(:,:,:,202),wf(:,-5),G1(:,:,:,203))
  call loop_A_Q(G1(:,:,:,203),Q(:,46),ZERO,G2(:,:,:,167))
  call loop_AQ_W(G2(:,:,:,167),wf(:,-4),G2(:,:,:,168))
  call loop_WA_Q(G2(:,:,:,168),wf(:,0),G2(:,:,:,169))
  call check_last_A_Q(l_switch,G2(:,:,:,169),Q(:,63),ZERO,G3tensor(:,79))
  call loop_WWV_V(G0(:,:,:,1),wf(:,5),wf(:,2),G0(:,:,:,92))
  call loop_WA_Q(G0(:,:,:,92),wf(:,0),G0(:,:,:,93))
  call loop_A_Q(G0(:,:,:,93),Q(:,59),ZERO,G1(:,:,:,204))
  call check_last_AQ_V(l_switch,G1(:,:,:,204),wf(:,-2),G1tensor(:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,92),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,46))
  call loop_AW_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,94))
  call loop_A_Q(G0(:,:,:,94),Q(:,10),ZERO,G1(:,:,:,205))
  call loop_AV_Q(G1(:,:,:,205),wf(:,3),G1(:,:,:,206))
  call loop_A_Q(G1(:,:,:,206),Q(:,58),ZERO,G2(:,:,:,170))
  call loop_AW_Q(G2(:,:,:,170),wf(:,1),G2(:,:,:,171))
  call check_last_A_Q(l_switch,G2(:,:,:,171),Q(:,63),ZERO,G3tensor(:,80))
  call loop_AZ_Q(G1(:,:,:,205),wf(:,5),G1(:,:,:,207),gZl)
  call loop_A_Q(G1(:,:,:,207),Q(:,58),ZERO,G2(:,:,:,172))
  call loop_AW_Q(G2(:,:,:,172),wf(:,1),G2(:,:,:,173))
  call check_last_A_Q(l_switch,G2(:,:,:,173),Q(:,63),ZERO,G3tensor(:,81))
  call loop_AZ_Q(G1(:,:,:,205),wf(:,5),G1(:,:,:,208),gZd)
  call loop_A_Q(G1(:,:,:,208),Q(:,58),ZERO,G2(:,:,:,174))
  call loop_AW_Q(G2(:,:,:,174),wf(:,1),G2(:,:,:,175))
  call check_last_A_Q(l_switch,G2(:,:,:,175),Q(:,63),ZERO,G3tensor(:,82))
  call loop_AQ_W(G1(:,:,:,205),wf(:,-4),G1(:,:,:,209))
  call loop_WA_Q(G1(:,:,:,209),wf(:,-5),G1(:,:,:,210))
  call loop_A_Q(G1(:,:,:,210),Q(:,58),ZERO,G2(:,:,:,176))
  call loop_AW_Q(G2(:,:,:,176),wf(:,1),G2(:,:,:,177))
  call check_last_A_Q(l_switch,G2(:,:,:,177),Q(:,63),ZERO,G3tensor(:,83))
  call loop_AQ_Z(G1(:,:,:,205),wf(:,56),G1(:,:,:,211),gZl)
  call loop_ZA_Q(G1(:,:,:,211),wf(:,0),G1(:,:,:,212),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,212),Q(:,63),ZERO,G2tensor(:,83))
  call loop_AQ_Z(G1(:,:,:,205),wf(:,57),G1(:,:,:,213),gZl)
  call loop_ZA_Q(G1(:,:,:,213),wf(:,0),G1(:,:,:,214),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,214),Q(:,63),ZERO,G2tensor(:,84))
  call loop_AQ_Z(G1(:,:,:,205),wf(:,-2),G1(:,:,:,215),gZl)
  call loop_ZA_Q(G1(:,:,:,215),wf(:,-5),G1(:,:,:,216),gZu)
  call loop_A_Q(G1(:,:,:,216),Q(:,46),ZERO,G2(:,:,:,178))
  call loop_AQ_Z(G2(:,:,:,178),wf(:,-4),G2(:,:,:,179),gZu)
  call loop_ZA_Q(G2(:,:,:,179),wf(:,0),G2(:,:,:,180),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,180),Q(:,63),ZERO,G3tensor(:,84))
  call loop_ZQ_A(G1(:,:,:,215),wf(:,-4),G1(:,:,:,217),gZu)
  call loop_Q_A(G1(:,:,:,217),Q(:,30),ZERO,G2(:,:,:,181))
  call loop_QA_Z(G2(:,:,:,181),wf(:,-5),G2(:,:,:,182),gZu)
  call loop_ZA_Q(G2(:,:,:,182),wf(:,0),G2(:,:,:,183),gZn)
  call check_last_A_Q(l_switch,G2(:,:,:,183),Q(:,63),ZERO,G3tensor(:,85))
  call loop_AW_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,95))
  call loop_A_Q(G0(:,:,:,95),Q(:,10),ML,G1(:,:,:,218))
  call loop_AV_Q(G1(:,:,:,218),wf(:,3),G1(:,:,:,219))
  call loop_A_Q(G1(:,:,:,219),Q(:,58),ML,G2(:,:,:,184))
  call loop_AW_Q(G2(:,:,:,184),wf(:,1),G2(:,:,:,185))
  call check_last_A_Q(l_switch,G2(:,:,:,185),Q(:,63),ZERO,G3tensor(:,86))
  call loop_AZ_Q(G1(:,:,:,218),wf(:,5),G1(:,:,:,220),gZl)
  call loop_A_Q(G1(:,:,:,220),Q(:,58),ML,G2(:,:,:,186))
  call loop_AW_Q(G2(:,:,:,186),wf(:,1),G2(:,:,:,187))
  call check_last_A_Q(l_switch,G2(:,:,:,187),Q(:,63),ZERO,G3tensor(:,87))
  call loop_QW_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,96))
  call loop_Q_A(G0(:,:,:,96),Q(:,10),ZERO,G1(:,:,:,221))
  call loop_QV_A(G1(:,:,:,221),wf(:,3),G1(:,:,:,222))
  call loop_Q_A(G1(:,:,:,222),Q(:,58),ZERO,G2(:,:,:,188))
  call loop_QW_A(G2(:,:,:,188),wf(:,1),G2(:,:,:,189))
  call check_last_Q_A(l_switch,G2(:,:,:,189),Q(:,63),ZERO,G3tensor(:,88))
  call loop_QZ_A(G1(:,:,:,221),wf(:,5),G1(:,:,:,223),gZn)
  call loop_Q_A(G1(:,:,:,223),Q(:,58),ZERO,G2(:,:,:,190))
  call loop_QW_A(G2(:,:,:,190),wf(:,1),G2(:,:,:,191))
  call check_last_Q_A(l_switch,G2(:,:,:,191),Q(:,63),ZERO,G3tensor(:,89))
  call loop_QW_A(G2(:,:,:,190),wf(:,1),G2(:,:,:,192))
  call check_last_Q_A(l_switch,G2(:,:,:,192),Q(:,63),ML,G3tensor(:,90))
  call loop_QZ_A(G1(:,:,:,221),wf(:,5),G1(:,:,:,224),gZu)
  call loop_Q_A(G1(:,:,:,224),Q(:,58),ZERO,G2(:,:,:,193))
  call loop_QW_A(G2(:,:,:,193),wf(:,1),G2(:,:,:,194))
  call check_last_Q_A(l_switch,G2(:,:,:,194),Q(:,63),ZERO,G3tensor(:,91))
  call loop_QA_Z(G1(:,:,:,221),wf(:,-5),G1(:,:,:,225),gZu)
  call loop_ZQ_A(G1(:,:,:,225),wf(:,-4),G1(:,:,:,226),gZu)
  call loop_Q_A(G1(:,:,:,226),Q(:,58),ZERO,G2(:,:,:,195))
  call loop_QW_A(G2(:,:,:,195),wf(:,1),G2(:,:,:,196))
  call check_last_Q_A(l_switch,G2(:,:,:,196),Q(:,63),ZERO,G3tensor(:,92))
  call loop_QA_Z(G1(:,:,:,221),wf(:,22),G1(:,:,:,227),gZn)
  call loop_ZQ_A(G1(:,:,:,227),wf(:,-2),G1(:,:,:,228),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,228),Q(:,63),ZERO,G2tensor(:,85))
  call loop_QW_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,97))
  call loop_Q_A(G0(:,:,:,97),Q(:,10),MT,G1(:,:,:,229))
  call loop_QV_A(G1(:,:,:,229),wf(:,3),G1(:,:,:,230))
  call loop_Q_A(G1(:,:,:,230),Q(:,58),MT,G2(:,:,:,197))
  call loop_QW_A(G2(:,:,:,197),wf(:,1),G2(:,:,:,198))
  call check_last_Q_A(l_switch,G2(:,:,:,198),Q(:,63),MB,G3tensor(:,93))
  call loop_QZ_A(G1(:,:,:,229),wf(:,5),G1(:,:,:,231),gZu)
  call loop_Q_A(G1(:,:,:,231),Q(:,58),MT,G2(:,:,:,199))
  call loop_QW_A(G2(:,:,:,199),wf(:,1),G2(:,:,:,200))
  call check_last_Q_A(l_switch,G2(:,:,:,200),Q(:,63),MB,G3tensor(:,94))
  call loop_AW_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,98))
  call loop_A_Q(G0(:,:,:,98),Q(:,10),MB,G1(:,:,:,232))
  call loop_AV_Q(G1(:,:,:,232),wf(:,3),G1(:,:,:,233))
  call loop_A_Q(G1(:,:,:,233),Q(:,58),MB,G2(:,:,:,201))
  call loop_AW_Q(G2(:,:,:,201),wf(:,1),G2(:,:,:,202))
  call check_last_A_Q(l_switch,G2(:,:,:,202),Q(:,63),MT,G3tensor(:,95))
  call loop_AZ_Q(G1(:,:,:,232),wf(:,5),G1(:,:,:,234),gZd)
  call loop_A_Q(G1(:,:,:,234),Q(:,58),MB,G2(:,:,:,203))
  call loop_AW_Q(G2(:,:,:,203),wf(:,1),G2(:,:,:,204))
  call check_last_A_Q(l_switch,G2(:,:,:,204),Q(:,63),MT,G3tensor(:,96))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,235))
  call loop_SV_T(G1(:,:,:,235),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,205))
  call check_last_SV_T(l_switch,G2(:,:,:,205),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,97))
  call check_last_SV_T(l_switch,G2(:,:,:,205),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,98))
  call loop_SV_T(G1(:,:,:,235),Q(:,10),wf(:,5),Q(:,48),G2(:,:,:,206))
  call check_last_SV_T(l_switch,G2(:,:,:,206),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,99))
  call check_last_SV_T(l_switch,G2(:,:,:,206),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,100))
  call loop_SV_V(G1(:,:,:,235),wf(:,3),G1(:,:,:,236))
  call check_last_VV_S(l_switch,G1(:,:,:,236),wf(:,1),G1tensor(:,47))
  call loop_SV_V(G1(:,:,:,235),wf(:,5),G1(:,:,:,237))
  call check_last_VV_S(l_switch,G1(:,:,:,237),wf(:,1),G1tensor(:,48))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,238))
  call loop_SV_T(G1(:,:,:,238),Q(:,10),wf(:,5),Q(:,48),G2(:,:,:,207))
  call check_last_TV_S(l_switch,G2(:,:,:,207),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,101))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,239))
  call loop_TV_S(G1(:,:,:,239),Q(:,10),wf(:,5),Q(:,48),G2(:,:,:,208))
  call check_last_TV_S(l_switch,G2(:,:,:,208),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,102))
  call loop_SV_V(G1(:,:,:,239),wf(:,5),G1(:,:,:,240))
  call check_last_VV_S(l_switch,G1(:,:,:,240),wf(:,1),G1tensor(:,49))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,2),G1(:,:,:,241))
  call loop_DV_C(G1(:,:,:,241),Q(:,10),wf(:,3),G2(:,:,:,209))
  call check_last_DV_C(l_switch,G2(:,:,:,209),Q(:,58),wf(:,1),G3tensor(:,103))
  call check_last_DV_C(l_switch,G2(:,:,:,209),Q(:,58),wf(:,1),G3tensor(:,104))
  call loop_DV_C(G1(:,:,:,241),Q(:,10),wf(:,5),G2(:,:,:,210))
  call check_last_DV_C(l_switch,G2(:,:,:,210),Q(:,58),wf(:,1),G3tensor(:,105))
  call check_last_DV_C(l_switch,G2(:,:,:,210),Q(:,58),wf(:,1),G3tensor(:,106))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,242))
  call loop_CV_D(G1(:,:,:,242),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,211))
  call check_last_CV_D(l_switch,G2(:,:,:,211),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,107))
  call check_last_CV_D(l_switch,G2(:,:,:,211),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,108))
  call loop_CV_D(G1(:,:,:,242),Q(:,10),wf(:,5),Q(:,48),G2(:,:,:,212))
  call check_last_CV_D(l_switch,G2(:,:,:,212),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,109))
  call check_last_CV_D(l_switch,G2(:,:,:,212),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,110))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,243))
  call loop_UW_V(G1(:,:,:,243),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,213))
  call check_last_UV_W(l_switch,G2(:,:,:,213),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,111))
  call check_last_UV_W(l_switch,G2(:,:,:,213),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,112))
  call loop_WA_Q(G2(:,:,:,213),wf(:,0),G2(:,:,:,214))
  call loop_A_Q(G2(:,:,:,214),Q(:,59),ZERO,G3(:,:,:,24))
  call check_last_AQ_V(l_switch,G3(:,:,:,24),wf(:,-2),G3tensor(:,113))
  call loop_UW_V(G1(:,:,:,243),Q(:,10),wf(:,5),Q(:,48),G2(:,:,:,215))
  call check_last_UV_W(l_switch,G2(:,:,:,215),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,114))
  call check_last_UV_W(l_switch,G2(:,:,:,215),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,115))
  call loop_WA_Q(G2(:,:,:,215),wf(:,0),G2(:,:,:,216))
  call loop_A_Q(G2(:,:,:,216),Q(:,59),ZERO,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,-2),G3tensor(:,116))
  call loop_VV_S(G1(:,:,:,243),wf(:,3),G1(:,:,:,244))
  call check_last_SV_V(l_switch,G1(:,:,:,244),wf(:,1),G1tensor(:,50))
  call check_last_SV_V(l_switch,G1(:,:,:,244),wf(:,1),G1tensor(:,51))
  call loop_VV_S(G1(:,:,:,243),wf(:,5),G1(:,:,:,245))
  call check_last_SV_V(l_switch,G1(:,:,:,245),wf(:,1),G1tensor(:,52))
  call check_last_SV_V(l_switch,G1(:,:,:,245),wf(:,1),G1tensor(:,53))
  call loop_WA_Q(G1(:,:,:,243),wf(:,-5),G1(:,:,:,246))
  call loop_A_Q(G1(:,:,:,246),Q(:,42),ZERO,G2(:,:,:,217))
  call loop_AQ_W(G2(:,:,:,217),wf(:,-4),G2(:,:,:,218))
  call check_last_UV_W(l_switch,G2(:,:,:,218),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,117))
  call check_last_UV_W(l_switch,G2(:,:,:,218),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,118))
  call loop_WA_Q(G2(:,:,:,218),wf(:,0),G2(:,:,:,219))
  call loop_A_Q(G2(:,:,:,219),Q(:,59),ZERO,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,-2),G3tensor(:,119))
  call loop_WA_Q(G1(:,:,:,243),wf(:,22),G1(:,:,:,247))
  call loop_A_Q(G1(:,:,:,247),Q(:,59),ZERO,G2(:,:,:,220))
  call check_last_AQ_V(l_switch,G2(:,:,:,220),wf(:,-2),G2tensor(:,86))
  call check_last_AQ_Z(l_switch,G2(:,:,:,220),wf(:,-2),G2tensor(:,87),gZl)
  call loop_WQ_A(G1(:,:,:,243),wf(:,56),G1(:,:,:,248))
  call loop_Q_A(G1(:,:,:,248),Q(:,62),ZERO,G2(:,:,:,221))
  call check_last_QA_Z(l_switch,G2(:,:,:,221),wf(:,0),G2tensor(:,88),gZn)
  call loop_WQ_A(G1(:,:,:,243),wf(:,57),G1(:,:,:,249))
  call loop_Q_A(G1(:,:,:,249),Q(:,62),ZERO,G2(:,:,:,222))
  call check_last_QA_Z(l_switch,G2(:,:,:,222),wf(:,0),G2tensor(:,89),gZn)
  call loop_WA_Q(G1(:,:,:,243),wf(:,0),G1(:,:,:,250))
  call loop_A_Q(G1(:,:,:,250),Q(:,11),ZERO,G2(:,:,:,223))
  call loop_AV_Q(G2(:,:,:,223),wf(:,3),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,59),ZERO,G3(:,:,:,27))
  call check_last_AQ_V(l_switch,G3(:,:,:,27),wf(:,-2),G3tensor(:,120))
  call loop_AZ_Q(G2(:,:,:,223),wf(:,5),G2(:,:,:,225),gZl)
  call loop_A_Q(G2(:,:,:,225),Q(:,59),ZERO,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,-2),G3tensor(:,121))
  call loop_WQ_A(G1(:,:,:,243),wf(:,-2),G1(:,:,:,251))
  call loop_Q_A(G1(:,:,:,251),Q(:,14),ZERO,G2(:,:,:,226))
  call loop_QZ_A(G2(:,:,:,226),wf(:,5),G2(:,:,:,227),gZn)
  call loop_Q_A(G2(:,:,:,227),Q(:,62),ZERO,G3(:,:,:,29))
  call check_last_QA_Z(l_switch,G3(:,:,:,29),wf(:,0),G3tensor(:,122),gZn)
  call loop_SV_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,99))
  call loop_VV_S(G0(:,:,:,99),wf(:,3),G0(:,:,:,100))
  call check_last_SV_T(l_switch,G0(:,:,:,100),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,54))
  call loop_VV_S(G0(:,:,:,99),wf(:,5),G0(:,:,:,101))
  call check_last_SV_T(l_switch,G0(:,:,:,101),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,55))
  call loop_UW_V(G0(:,:,:,99),Q(:,10),wf(:,3),Q(:,48),G1(:,:,:,252))
  call check_last_VV_S(l_switch,G1(:,:,:,252),wf(:,1),G1tensor(:,56))
  call loop_UW_V(G0(:,:,:,99),Q(:,10),wf(:,5),Q(:,48),G1(:,:,:,253))
  call check_last_VV_S(l_switch,G1(:,:,:,253),wf(:,1),G1tensor(:,57))
  call loop_WA_Q(G0(:,:,:,99),wf(:,-5),G0(:,:,:,102))
  call loop_A_Q(G0(:,:,:,102),Q(:,42),ZERO,G1(:,:,:,254))
  call loop_AQ_W(G1(:,:,:,254),wf(:,-4),G1(:,:,:,255))
  call check_last_VV_S(l_switch,G1(:,:,:,255),wf(:,1),G1tensor(:,58))
  call loop_SV_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,103))
  call loop_VV_S(G0(:,:,:,103),wf(:,5),G0(:,:,:,104))
  call check_last_TV_S(l_switch,G0(:,:,:,104),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,59))
  call loop_ZA_Q(G0(:,:,:,103),wf(:,-5),G0(:,:,:,105),gZu)
  call loop_A_Q(G0(:,:,:,105),Q(:,42),ZERO,G1(:,:,:,256))
  call loop_AQ_Z(G1(:,:,:,256),wf(:,-4),G1(:,:,:,257),gZu)
  call check_last_VV_S(l_switch,G1(:,:,:,257),wf(:,1),G1tensor(:,60))
  call loop_ZQ_A(G0(:,:,:,103),wf(:,-4),G0(:,:,:,106),gZu)
  call loop_Q_A(G0(:,:,:,106),Q(:,26),ZERO,G1(:,:,:,258))
  call loop_QA_Z(G1(:,:,:,258),wf(:,-5),G1(:,:,:,259),gZu)
  call check_last_VV_S(l_switch,G1(:,:,:,259),wf(:,1),G1tensor(:,61))
  call loop_VV_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,107))
  call loop_SV_T(G0(:,:,:,107),Q(:,10),wf(:,3),Q(:,48),G1(:,:,:,260))
  call check_last_SV_V(l_switch,G1(:,:,:,260),wf(:,1),G1tensor(:,62))
  call check_last_SV_V(l_switch,G1(:,:,:,260),wf(:,1),G1tensor(:,63))
  call loop_SV_T(G0(:,:,:,107),Q(:,10),wf(:,5),Q(:,48),G1(:,:,:,261))
  call check_last_SV_V(l_switch,G1(:,:,:,261),wf(:,1),G1tensor(:,64))
  call check_last_SV_V(l_switch,G1(:,:,:,261),wf(:,1),G1tensor(:,65))
  call loop_SV_V(G0(:,:,:,107),wf(:,3),G0(:,:,:,108))
  call check_last_UV_W(l_switch,G0(:,:,:,108),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,66))
  call check_last_UV_W(l_switch,G0(:,:,:,108),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,67))
  call loop_WA_Q(G0(:,:,:,108),wf(:,0),G0(:,:,:,109))
  call loop_A_Q(G0(:,:,:,109),Q(:,59),ZERO,G1(:,:,:,262))
  call check_last_AQ_V(l_switch,G1(:,:,:,262),wf(:,-2),G1tensor(:,68))
  call loop_SV_V(G0(:,:,:,107),wf(:,5),G0(:,:,:,110))
  call check_last_UV_W(l_switch,G0(:,:,:,110),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,69))
  call check_last_UV_W(l_switch,G0(:,:,:,110),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,70))
  call loop_WA_Q(G0(:,:,:,110),wf(:,0),G0(:,:,:,111))
  call loop_A_Q(G0(:,:,:,111),Q(:,59),ZERO,G1(:,:,:,263))
  call check_last_AQ_V(l_switch,G1(:,:,:,263),wf(:,-2),G1tensor(:,71))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,264))
  call loop_VV_S(G1(:,:,:,264),wf(:,5),G1(:,:,:,265))
  call check_last_SV_V(l_switch,G1(:,:,:,265),wf(:,1),G1tensor(:,72))
  call loop_ZA_Q(G1(:,:,:,264),wf(:,-5),G1(:,:,:,266),gZu)
  call loop_A_Q(G1(:,:,:,266),Q(:,42),ZERO,G2(:,:,:,228))
  call loop_AQ_Z(G2(:,:,:,228),wf(:,-4),G2(:,:,:,229),gZu)
  call check_last_UW_V(l_switch,G2(:,:,:,229),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,123))
  call loop_ZQ_A(G1(:,:,:,264),wf(:,-4),G1(:,:,:,267),gZu)
  call loop_Q_A(G1(:,:,:,267),Q(:,26),ZERO,G2(:,:,:,230))
  call loop_QA_Z(G2(:,:,:,230),wf(:,-5),G2(:,:,:,231),gZu)
  call check_last_UW_V(l_switch,G2(:,:,:,231),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,124))
  call loop_ZA_Q(G1(:,:,:,264),wf(:,22),G1(:,:,:,268),gZn)
  call loop_A_Q(G1(:,:,:,268),Q(:,59),ZERO,G2(:,:,:,232))
  call check_last_AQ_W(l_switch,G2(:,:,:,232),wf(:,-2),G2tensor(:,90))
  call loop_ZQ_A(G1(:,:,:,264),wf(:,56),G1(:,:,:,269),gZl)
  call loop_Q_A(G1(:,:,:,269),Q(:,62),ZERO,G2(:,:,:,233))
  call check_last_QA_W(l_switch,G2(:,:,:,233),wf(:,0),G2tensor(:,91))
  call loop_ZQ_A(G1(:,:,:,264),wf(:,57),G1(:,:,:,270),gZl)
  call loop_Q_A(G1(:,:,:,270),Q(:,62),ZERO,G2(:,:,:,234))
  call check_last_QA_W(l_switch,G2(:,:,:,234),wf(:,0),G2tensor(:,92))
  call loop_ZQ_A(G1(:,:,:,264),wf(:,-2),G1(:,:,:,271),gZl)
  call loop_Q_A(G1(:,:,:,271),Q(:,14),ZERO,G2(:,:,:,235))
  call loop_QV_A(G2(:,:,:,235),wf(:,3),G2(:,:,:,236))
  call loop_Q_A(G2(:,:,:,236),Q(:,62),ZERO,G3(:,:,:,30))
  call check_last_QA_W(l_switch,G3(:,:,:,30),wf(:,0),G3tensor(:,125))
  call loop_QZ_A(G2(:,:,:,235),wf(:,5),G2(:,:,:,237),gZl)
  call loop_Q_A(G2(:,:,:,237),Q(:,62),ZERO,G3(:,:,:,31))
  call check_last_QA_W(l_switch,G3(:,:,:,31),wf(:,0),G3tensor(:,126))
  call loop_VV_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,112))
  call loop_SV_V(G0(:,:,:,112),wf(:,5),G0(:,:,:,113))
  call check_last_UW_V(l_switch,G0(:,:,:,113),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,73))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,8),G0(:,:,:,114),gZd)
  call loop_ZA_Q(G0(:,:,:,114),wf(:,-5),G0(:,:,:,115),gZu)
  call loop_A_Q(G0(:,:,:,115),Q(:,53),ZERO,G1(:,:,:,272))
  call loop_AW_Q(G1(:,:,:,272),wf(:,2),G1(:,:,:,273))
  call check_last_A_Q(l_switch,G1(:,:,:,273),Q(:,63),ZERO,G2tensor(:,93))
  call loop_VQ_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,116))
  call loop_Q_A(G0(:,:,:,116),Q(:,21),ZERO,G1(:,:,:,274))
  call loop_QA_W(G1(:,:,:,274),wf(:,-5),G1(:,:,:,275))
  call check_last_UW_V(l_switch,G1(:,:,:,275),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,94))
  call loop_WQ_A(G1(:,:,:,275),wf(:,-1),G1(:,:,:,276))
  call loop_Q_A(G1(:,:,:,276),Q(:,55),ZERO,G2(:,:,:,238))
  call check_last_QA_V(l_switch,G2(:,:,:,238),wf(:,-3),G2tensor(:,95))
  call loop_WQ_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,117))
  call loop_Q_A(G0(:,:,:,117),Q(:,21),ZERO,G1(:,:,:,277))
  call loop_QA_Z(G1(:,:,:,277),wf(:,-5),G1(:,:,:,278),gZu)
  call check_last_UV_W(l_switch,G1(:,:,:,278),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,96))
  call loop_ZQ_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,118),gZd)
  call loop_Q_A(G0(:,:,:,118),Q(:,21),ZERO,G1(:,:,:,279))
  call loop_QA_W(G1(:,:,:,279),wf(:,-5),G1(:,:,:,280))
  call check_last_UW_V(l_switch,G1(:,:,:,280),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,97))
  call loop_VA_Q(G0(:,:,:,1),wf(:,26),G0(:,:,:,119))
  call loop_A_Q(G0(:,:,:,119),Q(:,42),ZERO,G1(:,:,:,281))
  call loop_AW_Q(G1(:,:,:,281),wf(:,1),G1(:,:,:,282))
  call loop_A_Q(G1(:,:,:,282),Q(:,47),ZERO,G2(:,:,:,239))
  call check_last_AQ_V(l_switch,G2(:,:,:,239),wf(:,-4),G2tensor(:,98))
  call loop_AQ_W(G1(:,:,:,281),wf(:,-4),G1(:,:,:,283))
  call check_last_UV_W(l_switch,G1(:,:,:,283),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,99))
  call loop_WA_Q(G1(:,:,:,283),wf(:,0),G1(:,:,:,284))
  call loop_A_Q(G1(:,:,:,284),Q(:,59),ZERO,G2(:,:,:,240))
  call check_last_AQ_V(l_switch,G2(:,:,:,240),wf(:,-2),G2tensor(:,100))
  call check_last_AQ_V(l_switch,G1(:,:,:,281),wf(:,8),G1tensor(:,74))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,-4),G0(:,:,:,120),gZu)
  call loop_ZA_Q(G0(:,:,:,120),wf(:,26),G0(:,:,:,121),gZd)
  call loop_A_Q(G0(:,:,:,121),Q(:,58),ZERO,G1(:,:,:,285))
  call loop_AW_Q(G1(:,:,:,285),wf(:,1),G1(:,:,:,286))
  call check_last_A_Q(l_switch,G1(:,:,:,286),Q(:,63),ZERO,G2tensor(:,101))
  call loop_ZA_Q(G0(:,:,:,120),wf(:,-5),G0(:,:,:,122),gZu)
  call loop_A_Q(G0(:,:,:,122),Q(:,48),ZERO,G1(:,:,:,287))
  call loop_AV_Q(G1(:,:,:,287),wf(:,4),G1(:,:,:,288))
  call check_last_A_Q(l_switch,G1(:,:,:,288),Q(:,63),ZERO,G2tensor(:,102))
  call loop_AZ_Q(G1(:,:,:,287),wf(:,4),G1(:,:,:,289),gZu)
  call check_last_A_Q(l_switch,G1(:,:,:,289),Q(:,63),ZERO,G2tensor(:,103))
  call loop_AV_Q(G1(:,:,:,287),wf(:,108),G1(:,:,:,290))
  call check_last_A_Q(l_switch,G1(:,:,:,290),Q(:,63),ZERO,G2tensor(:,104))
  call loop_AZ_Q(G1(:,:,:,287),wf(:,109),G1(:,:,:,291),gZu)
  call check_last_A_Q(l_switch,G1(:,:,:,291),Q(:,63),ZERO,G2tensor(:,105))
  call loop_AZ_Q(G1(:,:,:,287),wf(:,110),G1(:,:,:,292),gZu)
  call check_last_A_Q(l_switch,G1(:,:,:,292),Q(:,63),ZERO,G2tensor(:,106))
  call loop_AV_Q(G1(:,:,:,287),wf(:,112),G1(:,:,:,293))
  call check_last_A_Q(l_switch,G1(:,:,:,293),Q(:,63),ZERO,G2tensor(:,107))
  call loop_AZ_Q(G1(:,:,:,287),wf(:,113),G1(:,:,:,294),gZu)
  call check_last_A_Q(l_switch,G1(:,:,:,294),Q(:,63),ZERO,G2tensor(:,108))
  call loop_AZ_Q(G1(:,:,:,287),wf(:,114),G1(:,:,:,295),gZu)
  call check_last_A_Q(l_switch,G1(:,:,:,295),Q(:,63),ZERO,G2tensor(:,109))
  call loop_UV_W(G0(:,:,:,120),Q(:,16),wf(:,2),Q(:,10),G1(:,:,:,296))
  call loop_WA_Q(G1(:,:,:,296),wf(:,-5),G1(:,:,:,297))
  call loop_A_Q(G1(:,:,:,297),Q(:,58),ZERO,G2(:,:,:,241))
  call loop_AW_Q(G2(:,:,:,241),wf(:,1),G2(:,:,:,242))
  call check_last_A_Q(l_switch,G2(:,:,:,242),Q(:,63),ZERO,G3tensor(:,127))
  call loop_AQ_W(G0(:,:,:,1),wf(:,-4),G0(:,:,:,123))
  call loop_WA_Q(G0(:,:,:,123),wf(:,-5),G0(:,:,:,124))
  call loop_A_Q(G0(:,:,:,124),Q(:,48),ZERO,G1(:,:,:,298))
  call loop_AV_Q(G1(:,:,:,298),wf(:,4),G1(:,:,:,299))
  call check_last_A_Q(l_switch,G1(:,:,:,299),Q(:,63),ZERO,G2tensor(:,110))
  call loop_AZ_Q(G1(:,:,:,298),wf(:,4),G1(:,:,:,300),gZd)
  call check_last_A_Q(l_switch,G1(:,:,:,300),Q(:,63),ZERO,G2tensor(:,111))
  call loop_AV_Q(G1(:,:,:,298),wf(:,108),G1(:,:,:,301))
  call check_last_A_Q(l_switch,G1(:,:,:,301),Q(:,63),ZERO,G2tensor(:,112))
  call loop_AZ_Q(G1(:,:,:,298),wf(:,109),G1(:,:,:,302),gZd)
  call check_last_A_Q(l_switch,G1(:,:,:,302),Q(:,63),ZERO,G2tensor(:,113))
  call loop_AZ_Q(G1(:,:,:,298),wf(:,110),G1(:,:,:,303),gZd)
  call check_last_A_Q(l_switch,G1(:,:,:,303),Q(:,63),ZERO,G2tensor(:,114))
  call loop_AV_Q(G1(:,:,:,298),wf(:,112),G1(:,:,:,304))
  call check_last_A_Q(l_switch,G1(:,:,:,304),Q(:,63),ZERO,G2tensor(:,115))
  call loop_AZ_Q(G1(:,:,:,298),wf(:,113),G1(:,:,:,305),gZd)
  call check_last_A_Q(l_switch,G1(:,:,:,305),Q(:,63),ZERO,G2tensor(:,116))
  call loop_AZ_Q(G1(:,:,:,298),wf(:,114),G1(:,:,:,306),gZd)
  call check_last_A_Q(l_switch,G1(:,:,:,306),Q(:,63),ZERO,G2tensor(:,117))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,125))
  call loop_A_Q(G0(:,:,:,125),Q(:,8),ZERO,G1(:,:,:,307))
  call loop_AV_Q(G1(:,:,:,307),wf(:,3),G1(:,:,:,308))
  call loop_A_Q(G1(:,:,:,308),Q(:,56),ZERO,G2(:,:,:,243))
  call check_last_AQ_V(l_switch,G2(:,:,:,243),wf(:,11),G2tensor(:,118))
  call loop_AQ_W(G2(:,:,:,243),wf(:,-1),G2(:,:,:,244))
  call check_last_UV_W(l_switch,G2(:,:,:,244),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,128))
  call loop_WA_Q(G2(:,:,:,244),wf(:,0),G2(:,:,:,245))
  call loop_A_Q(G2(:,:,:,245),Q(:,59),ZERO,G3(:,:,:,32))
  call check_last_AQ_V(l_switch,G3(:,:,:,32),wf(:,-2),G3tensor(:,129))
  call loop_AZ_Q(G1(:,:,:,307),wf(:,5),G1(:,:,:,309),gZl)
  call loop_A_Q(G1(:,:,:,309),Q(:,56),ZERO,G2(:,:,:,246))
  call check_last_AQ_V(l_switch,G2(:,:,:,246),wf(:,11),G2tensor(:,119))
  call loop_AQ_W(G2(:,:,:,246),wf(:,-1),G2(:,:,:,247))
  call check_last_UV_W(l_switch,G2(:,:,:,247),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,130))
  call loop_WA_Q(G2(:,:,:,247),wf(:,0),G2(:,:,:,248))
  call loop_A_Q(G2(:,:,:,248),Q(:,59),ZERO,G3(:,:,:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,33),wf(:,-2),G3tensor(:,131))
  call loop_AQ_W(G1(:,:,:,307),wf(:,15),G1(:,:,:,310))
  call check_last_UV_W(l_switch,G1(:,:,:,310),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,120))
  call loop_WA_Q(G1(:,:,:,310),wf(:,0),G1(:,:,:,311))
  call loop_A_Q(G1(:,:,:,311),Q(:,59),ZERO,G2(:,:,:,249))
  call check_last_AQ_V(l_switch,G2(:,:,:,249),wf(:,-2),G2tensor(:,121))
  call loop_AQ_W(G1(:,:,:,307),wf(:,-1),G1(:,:,:,312))
  call loop_VV_S(G1(:,:,:,312),wf(:,3),G1(:,:,:,313))
  call check_last_SV_V(l_switch,G1(:,:,:,313),wf(:,1),G1tensor(:,75))
  call loop_VV_S(G1(:,:,:,312),wf(:,5),G1(:,:,:,314))
  call check_last_SV_V(l_switch,G1(:,:,:,314),wf(:,1),G1tensor(:,76))
  call loop_UW_V(G1(:,:,:,312),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,250))
  call check_last_UV_W(l_switch,G2(:,:,:,250),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,132))
  call loop_WA_Q(G2(:,:,:,250),wf(:,0),G2(:,:,:,251))
  call loop_A_Q(G2(:,:,:,251),Q(:,59),ZERO,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,-2),G3tensor(:,133))
  call loop_UW_V(G1(:,:,:,312),Q(:,10),wf(:,5),Q(:,48),G2(:,:,:,252))
  call check_last_UV_W(l_switch,G2(:,:,:,252),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,134))
  call loop_WA_Q(G2(:,:,:,252),wf(:,0),G2(:,:,:,253))
  call loop_A_Q(G2(:,:,:,253),Q(:,59),ZERO,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,-2),G3tensor(:,135))
  call loop_WA_Q(G1(:,:,:,312),wf(:,-5),G1(:,:,:,315))
  call loop_A_Q(G1(:,:,:,315),Q(:,42),ZERO,G2(:,:,:,254))
  call loop_AQ_W(G2(:,:,:,254),wf(:,-4),G2(:,:,:,255))
  call check_last_UV_W(l_switch,G2(:,:,:,255),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,136))
  call loop_WA_Q(G2(:,:,:,255),wf(:,0),G2(:,:,:,256))
  call loop_A_Q(G2(:,:,:,256),Q(:,59),ZERO,G3(:,:,:,36))
  call check_last_AQ_V(l_switch,G3(:,:,:,36),wf(:,-2),G3tensor(:,137))
  call loop_WA_Q(G1(:,:,:,312),wf(:,22),G1(:,:,:,316))
  call loop_A_Q(G1(:,:,:,316),Q(:,59),ZERO,G2(:,:,:,257))
  call check_last_AQ_V(l_switch,G2(:,:,:,257),wf(:,-2),G2tensor(:,122))
  call loop_WA_Q(G1(:,:,:,312),wf(:,0),G1(:,:,:,317))
  call loop_A_Q(G1(:,:,:,317),Q(:,11),ZERO,G2(:,:,:,258))
  call loop_AV_Q(G2(:,:,:,258),wf(:,3),G2(:,:,:,259))
  call loop_A_Q(G2(:,:,:,259),Q(:,59),ZERO,G3(:,:,:,37))
  call check_last_AQ_V(l_switch,G3(:,:,:,37),wf(:,-2),G3tensor(:,138))
  call loop_AZ_Q(G2(:,:,:,258),wf(:,5),G2(:,:,:,260),gZl)
  call loop_A_Q(G2(:,:,:,260),Q(:,59),ZERO,G3(:,:,:,38))
  call check_last_AQ_V(l_switch,G3(:,:,:,38),wf(:,-2),G3tensor(:,139))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,126),gZl)
  call loop_A_Q(G0(:,:,:,126),Q(:,8),ZERO,G1(:,:,:,318))
  call loop_AV_Q(G1(:,:,:,318),wf(:,3),G1(:,:,:,319))
  call loop_A_Q(G1(:,:,:,319),Q(:,56),ZERO,G2(:,:,:,261))
  call check_last_AQ_Z(l_switch,G2(:,:,:,261),wf(:,11),G2tensor(:,123),gZl)
  call loop_AZ_Q(G1(:,:,:,318),wf(:,5),G1(:,:,:,320),gZl)
  call loop_A_Q(G1(:,:,:,320),Q(:,56),ZERO,G2(:,:,:,262))
  call check_last_AQ_Z(l_switch,G2(:,:,:,262),wf(:,11),G2tensor(:,124),gZl)
  call loop_AQ_W(G1(:,:,:,318),wf(:,15),G1(:,:,:,321))
  call check_last_UV_W(l_switch,G1(:,:,:,321),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,125))
  call loop_AW_Q(G1(:,:,:,318),wf(:,77),G1(:,:,:,322))
  call loop_A_Q(G1(:,:,:,322),Q(:,61),ZERO,G2(:,:,:,263))
  call check_last_AQ_Z(l_switch,G2(:,:,:,263),wf(:,-1),G2tensor(:,126),gZn)
  call loop_AW_Q(G1(:,:,:,318),wf(:,79),G1(:,:,:,323))
  call loop_A_Q(G1(:,:,:,323),Q(:,61),ZERO,G2(:,:,:,264))
  call check_last_AQ_Z(l_switch,G2(:,:,:,264),wf(:,-1),G2tensor(:,127),gZn)
  call loop_AW_Q(G1(:,:,:,318),wf(:,1),G1(:,:,:,324))
  call loop_A_Q(G1(:,:,:,324),Q(:,13),ZERO,G2(:,:,:,265))
  call loop_AZ_Q(G2(:,:,:,265),wf(:,5),G2(:,:,:,266),gZn)
  call loop_A_Q(G2(:,:,:,266),Q(:,61),ZERO,G3(:,:,:,39))
  call check_last_AQ_Z(l_switch,G3(:,:,:,39),wf(:,-1),G3tensor(:,140),gZn)
  call loop_AW_Q(G1(:,:,:,318),wf(:,111),G1(:,:,:,325))
  call loop_A_Q(G1(:,:,:,325),Q(:,61),ZERO,G2(:,:,:,267))
  call check_last_AQ_Z(l_switch,G2(:,:,:,267),wf(:,-1),G2tensor(:,128),gZn)
  call loop_AW_Q(G1(:,:,:,318),wf(:,116),G1(:,:,:,326))
  call loop_A_Q(G1(:,:,:,326),Q(:,61),ZERO,G2(:,:,:,268))
  call check_last_AQ_Z(l_switch,G2(:,:,:,268),wf(:,-1),G2tensor(:,129),gZn)
  call loop_AW_Q(G1(:,:,:,318),wf(:,117),G1(:,:,:,327))
  call loop_A_Q(G1(:,:,:,327),Q(:,61),ZERO,G2(:,:,:,269))
  call check_last_AQ_Z(l_switch,G2(:,:,:,269),wf(:,-1),G2tensor(:,130),gZn)
  call loop_AW_Q(G1(:,:,:,318),wf(:,118),G1(:,:,:,328))
  call loop_A_Q(G1(:,:,:,328),Q(:,61),ZERO,G2(:,:,:,270))
  call check_last_AQ_Z(l_switch,G2(:,:,:,270),wf(:,-1),G2tensor(:,131),gZn)
  call loop_AQ_W(G1(:,:,:,318),wf(:,-1),G1(:,:,:,329))
  call loop_WQ_A(G1(:,:,:,329),wf(:,56),G1(:,:,:,330))
  call loop_Q_A(G1(:,:,:,330),Q(:,62),ZERO,G2(:,:,:,271))
  call check_last_QA_Z(l_switch,G2(:,:,:,271),wf(:,0),G2tensor(:,132),gZn)
  call loop_WQ_A(G1(:,:,:,329),wf(:,57),G1(:,:,:,331))
  call loop_Q_A(G1(:,:,:,331),Q(:,62),ZERO,G2(:,:,:,272))
  call check_last_QA_Z(l_switch,G2(:,:,:,272),wf(:,0),G2tensor(:,133),gZn)
  call loop_WQ_A(G1(:,:,:,329),wf(:,-2),G1(:,:,:,332))
  call loop_Q_A(G1(:,:,:,332),Q(:,14),ZERO,G2(:,:,:,273))
  call loop_QZ_A(G2(:,:,:,273),wf(:,5),G2(:,:,:,274),gZn)
  call loop_Q_A(G2(:,:,:,274),Q(:,62),ZERO,G3(:,:,:,40))
  call check_last_QA_Z(l_switch,G3(:,:,:,40),wf(:,0),G3tensor(:,141),gZn)
  call loop_WA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,127))
  call loop_A_Q(G0(:,:,:,127),Q(:,8),ZERO,G1(:,:,:,333))
  call loop_AZ_Q(G1(:,:,:,333),wf(:,5),G1(:,:,:,334),gZn)
  call loop_A_Q(G1(:,:,:,334),Q(:,56),ZERO,G2(:,:,:,275))
  call check_last_AQ_W(l_switch,G2(:,:,:,275),wf(:,11),G2tensor(:,134))
  call loop_AQ_Z(G1(:,:,:,333),wf(:,15),G1(:,:,:,335),gZn)
  call check_last_UW_V(l_switch,G1(:,:,:,335),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,135))
  call loop_AQ_Z(G1(:,:,:,333),wf(:,-1),G1(:,:,:,336),gZn)
  call loop_ZQ_A(G1(:,:,:,336),wf(:,56),G1(:,:,:,337),gZl)
  call loop_Q_A(G1(:,:,:,337),Q(:,62),ZERO,G2(:,:,:,276))
  call check_last_QA_W(l_switch,G2(:,:,:,276),wf(:,0),G2tensor(:,136))
  call loop_ZQ_A(G1(:,:,:,336),wf(:,57),G1(:,:,:,338),gZl)
  call loop_Q_A(G1(:,:,:,338),Q(:,62),ZERO,G2(:,:,:,277))
  call check_last_QA_W(l_switch,G2(:,:,:,277),wf(:,0),G2tensor(:,137))
  call loop_ZQ_A(G1(:,:,:,336),wf(:,-2),G1(:,:,:,339),gZl)
  call loop_Q_A(G1(:,:,:,339),Q(:,14),ZERO,G2(:,:,:,278))
  call loop_QV_A(G2(:,:,:,278),wf(:,3),G2(:,:,:,279))
  call loop_Q_A(G2(:,:,:,279),Q(:,62),ZERO,G3(:,:,:,41))
  call check_last_QA_W(l_switch,G3(:,:,:,41),wf(:,0),G3tensor(:,142))
  call loop_QZ_A(G2(:,:,:,278),wf(:,5),G2(:,:,:,280),gZl)
  call loop_Q_A(G2(:,:,:,280),Q(:,62),ZERO,G3(:,:,:,42))
  call check_last_QA_W(l_switch,G3(:,:,:,42),wf(:,0),G3tensor(:,143))
  call loop_WA_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,128))
  call loop_A_Q(G0(:,:,:,128),Q(:,13),ZERO,G1(:,:,:,340))
  call loop_AV_Q(G1(:,:,:,340),wf(:,3),G1(:,:,:,341))
  call loop_A_Q(G1(:,:,:,341),Q(:,61),ZERO,G2(:,:,:,281))
  call check_last_AQ_W(l_switch,G2(:,:,:,281),wf(:,-1),G2tensor(:,138))
  call loop_AZ_Q(G1(:,:,:,340),wf(:,5),G1(:,:,:,342),gZl)
  call loop_A_Q(G1(:,:,:,342),Q(:,61),ZERO,G2(:,:,:,282))
  call check_last_AQ_W(l_switch,G2(:,:,:,282),wf(:,-1),G2tensor(:,139))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,129),gZn)
  call loop_A_Q(G0(:,:,:,129),Q(:,13),ZERO,G1(:,:,:,343))
  call loop_AZ_Q(G1(:,:,:,343),wf(:,5),G1(:,:,:,344),gZn)
  call loop_A_Q(G1(:,:,:,344),Q(:,61),ZERO,G2(:,:,:,283))
  call check_last_AQ_Z(l_switch,G2(:,:,:,283),wf(:,-1),G2tensor(:,140),gZn)
  call loop_QA_W(G0(:,:,:,1),wf(:,44),G0(:,:,:,130))
  call loop_UV_W(G0(:,:,:,130),Q(:,13),wf(:,3),Q(:,48),G1(:,:,:,345))
  call loop_WQ_A(G1(:,:,:,345),wf(:,-1),G1(:,:,:,346))
  call check_last_Q_A(l_switch,G1(:,:,:,346),Q(:,63),ZERO,G2tensor(:,141))
  call loop_UV_W(G0(:,:,:,130),Q(:,13),wf(:,5),Q(:,48),G1(:,:,:,347))
  call loop_WQ_A(G1(:,:,:,347),wf(:,-1),G1(:,:,:,348))
  call check_last_Q_A(l_switch,G1(:,:,:,348),Q(:,63),ZERO,G2tensor(:,142))
  call loop_WQ_A(G0(:,:,:,130),wf(:,-4),G0(:,:,:,131))
  call loop_Q_A(G0(:,:,:,131),Q(:,29),ZERO,G1(:,:,:,349))
  call loop_QA_W(G1(:,:,:,349),wf(:,-5),G1(:,:,:,350))
  call loop_WQ_A(G1(:,:,:,350),wf(:,-1),G1(:,:,:,351))
  call check_last_Q_A(l_switch,G1(:,:,:,351),Q(:,63),ZERO,G2tensor(:,143))
  call loop_QW_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,132))
  call loop_Q_A(G0(:,:,:,132),Q(:,5),ZERO,G1(:,:,:,352))
  call loop_QA_Z(G1(:,:,:,352),wf(:,47),G1(:,:,:,353),gZl)
  call loop_ZQ_A(G1(:,:,:,353),wf(:,-1),G1(:,:,:,354),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,354),Q(:,63),ZERO,G2tensor(:,144))
  call loop_QA_Z(G1(:,:,:,352),wf(:,48),G1(:,:,:,355),gZl)
  call loop_ZQ_A(G1(:,:,:,355),wf(:,-1),G1(:,:,:,356),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,356),Q(:,63),ZERO,G2tensor(:,145))
  call loop_QV_A(G1(:,:,:,352),wf(:,3),G1(:,:,:,357))
  call loop_Q_A(G1(:,:,:,357),Q(:,53),ZERO,G2(:,:,:,284))
  call loop_QA_Z(G2(:,:,:,284),wf(:,-3),G2(:,:,:,285),gZl)
  call loop_ZQ_A(G2(:,:,:,285),wf(:,-1),G2(:,:,:,286),gZn)
  call check_last_Q_A(l_switch,G2(:,:,:,286),Q(:,63),ZERO,G3tensor(:,144))
  call loop_QZ_A(G1(:,:,:,352),wf(:,5),G1(:,:,:,358),gZl)
  call loop_Q_A(G1(:,:,:,358),Q(:,53),ZERO,G2(:,:,:,287))
  call loop_QA_Z(G2(:,:,:,287),wf(:,-3),G2(:,:,:,288),gZl)
  call loop_ZQ_A(G2(:,:,:,288),wf(:,-1),G2(:,:,:,289),gZn)
  call check_last_Q_A(l_switch,G2(:,:,:,289),Q(:,63),ZERO,G3tensor(:,145))
  call loop_QA_Z(G1(:,:,:,352),wf(:,-3),G1(:,:,:,359),gZl)
  call loop_ZA_Q(G1(:,:,:,359),wf(:,-5),G1(:,:,:,360),gZu)
  call loop_A_Q(G1(:,:,:,360),Q(:,45),ZERO,G2(:,:,:,290))
  call loop_AQ_Z(G2(:,:,:,290),wf(:,-4),G2(:,:,:,291),gZu)
  call loop_ZQ_A(G2(:,:,:,291),wf(:,-1),G2(:,:,:,292),gZn)
  call check_last_Q_A(l_switch,G2(:,:,:,292),Q(:,63),ZERO,G3tensor(:,146))
  call loop_ZQ_A(G1(:,:,:,359),wf(:,-4),G1(:,:,:,361),gZu)
  call loop_Q_A(G1(:,:,:,361),Q(:,29),ZERO,G2(:,:,:,293))
  call loop_QA_Z(G2(:,:,:,293),wf(:,-5),G2(:,:,:,294),gZu)
  call loop_ZQ_A(G2(:,:,:,294),wf(:,-1),G2(:,:,:,295),gZn)
  call check_last_Q_A(l_switch,G2(:,:,:,295),Q(:,63),ZERO,G3tensor(:,147))
  call loop_VA_Q(G0(:,:,:,1),wf(:,47),G0(:,:,:,133))
  call loop_A_Q(G0(:,:,:,133),Q(:,56),ZERO,G1(:,:,:,362))
  call loop_AQ_W(G1(:,:,:,362),wf(:,-1),G1(:,:,:,363))
  call check_last_UV_W(l_switch,G1(:,:,:,363),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,146))
  call loop_WA_Q(G1(:,:,:,363),wf(:,0),G1(:,:,:,364))
  call loop_A_Q(G1(:,:,:,364),Q(:,59),ZERO,G2(:,:,:,296))
  call check_last_AQ_V(l_switch,G2(:,:,:,296),wf(:,-2),G2tensor(:,147))
  call check_last_AQ_V(l_switch,G1(:,:,:,362),wf(:,11),G1tensor(:,77))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,1),Q(:,5),G1(:,:,:,365))
  call loop_WA_Q(G1(:,:,:,365),wf(:,47),G1(:,:,:,366))
  call loop_A_Q(G1(:,:,:,366),Q(:,61),ZERO,G2(:,:,:,297))
  call check_last_AQ_Z(l_switch,G2(:,:,:,297),wf(:,-1),G2tensor(:,148),gZn)
  call loop_WA_Q(G1(:,:,:,365),wf(:,48),G1(:,:,:,367))
  call loop_A_Q(G1(:,:,:,367),Q(:,61),ZERO,G2(:,:,:,298))
  call check_last_AQ_Z(l_switch,G2(:,:,:,298),wf(:,-1),G2tensor(:,149),gZn)
  call loop_UV_W(G1(:,:,:,365),Q(:,5),wf(:,3),Q(:,48),G2(:,:,:,299))
  call loop_WA_Q(G2(:,:,:,299),wf(:,-3),G2(:,:,:,300))
  call loop_A_Q(G2(:,:,:,300),Q(:,61),ZERO,G3(:,:,:,43))
  call check_last_AQ_Z(l_switch,G3(:,:,:,43),wf(:,-1),G3tensor(:,148),gZn)
  call loop_UV_W(G1(:,:,:,365),Q(:,5),wf(:,5),Q(:,48),G2(:,:,:,301))
  call loop_WA_Q(G2(:,:,:,301),wf(:,-3),G2(:,:,:,302))
  call loop_A_Q(G2(:,:,:,302),Q(:,61),ZERO,G3(:,:,:,44))
  call check_last_AQ_Z(l_switch,G3(:,:,:,44),wf(:,-1),G3tensor(:,149),gZn)
  call loop_WA_Q(G1(:,:,:,365),wf(:,-3),G1(:,:,:,368))
  call loop_A_Q(G1(:,:,:,368),Q(:,13),ZERO,G2(:,:,:,303))
  call loop_AZ_Q(G2(:,:,:,303),wf(:,5),G2(:,:,:,304),gZn)
  call loop_A_Q(G2(:,:,:,304),Q(:,61),ZERO,G3(:,:,:,45))
  call check_last_AQ_Z(l_switch,G3(:,:,:,45),wf(:,-1),G3tensor(:,150),gZn)
  call loop_WQ_A(G1(:,:,:,365),wf(:,-4),G1(:,:,:,369))
  call loop_Q_A(G1(:,:,:,369),Q(:,21),ZERO,G2(:,:,:,305))
  call loop_QA_W(G2(:,:,:,305),wf(:,-5),G2(:,:,:,306))
  call loop_WA_Q(G2(:,:,:,306),wf(:,-3),G2(:,:,:,307))
  call loop_A_Q(G2(:,:,:,307),Q(:,61),ZERO,G3(:,:,:,46))
  call check_last_AQ_Z(l_switch,G3(:,:,:,46),wf(:,-1),G3tensor(:,151),gZn)

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(46)*M(1))) * den(4)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(39)*M(1))) * den(4)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(39)*M(1))) * den(4)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,6)
  Gcoeff = (-(c(28)*M(1))) * den(4)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(5)*M(1)) * den(4)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(47)*M(1)) * den(53)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(39)*M(1))) * den(53)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,16)
  Gcoeff = (-(c(39)*M(1))) * den(53)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(40)*M(1)) * den(57)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,27)
  Gcoeff = (-(c(28)*M(1))) * den(57)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,17)
  Gcoeff = (-(c(28)*M(1))) * den(57)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(47)*M(1)) * den(46)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,29)
  Gcoeff = (-(c(39)*M(1))) * den(46)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,31)
  Gcoeff = (-(c(39)*M(1))) * den(46)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(40)*M(1)) * den(50)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,45)
  Gcoeff = (-(c(28)*M(1))) * den(50)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,32)
  Gcoeff = (-(c(28)*M(1))) * den(50)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(82)*M(1)) * den(114)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(77)*M(1)) * den(114)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,86)
  Gcoeff = (-(c(79)*M(1))) * den(114)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,88)
  Gcoeff = (-(c(76)*M(1))) * den(114)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,93)
  Gcoeff = (c(76)*M(1)) * den(114)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(75)*M(1)) * den(114)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,95)
  Gcoeff = (-(c(84)*M(1))) * den(115)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,89)
  Gcoeff = (-(c(80)*M(1))) * den(115)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,90)
  Gcoeff = (-(c(84)*M(1))) * den(115)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,81)
  Gcoeff = (-(c(80)*M(1))) * den(115)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,87)
  Gcoeff = (-(c(85)*M(1))) * den(115)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,91)
  Gcoeff = (-(c(81)*M(1))) * den(115)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,94)
  Gcoeff = (-(c(85)*M(1))) * den(115)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,82)
  Gcoeff = (-(c(81)*M(1))) * den(115)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,96)
  Gcoeff = (-(c(20)*M(1))) * den(114)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,97)
  Gcoeff = (-(c(20)*M(1))) * den(114)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,98)
  Gcoeff = (-(c(8)*M(1))) * den(115)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,101)
  Gcoeff = (c(8)*M(1)) * den(115)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,102)
  Gcoeff = (c(55)*M(1)) * den(115)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,99)
  Gcoeff = (c(55)*M(1)) * den(115)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,100)
  Gcoeff = (c(47)*M(1)) * den(114)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,103)
  Gcoeff = (c(27)*M(1)) * den(114)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,104)
  Gcoeff = (-(c(47)*M(1))) * den(114)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,107)
  Gcoeff = (-(c(27)*M(1))) * den(114)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,108)
  Gcoeff = (c(40)*M(1)) * den(115)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,105)
  Gcoeff = (c(13)*M(1)) * den(115)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,106)
  Gcoeff = (-(c(40)*M(1))) * den(115)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,109)
  Gcoeff = (-(c(13)*M(1))) * den(115)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,110)
  Gcoeff = (c(47)*M(1)) * den(114)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,111)
  Gcoeff = (c(27)*M(1)) * den(114)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,112)
  Gcoeff = (c(40)*M(1)) * den(115)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(13)*M(1)) * den(115)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,115)
  Gcoeff = (-(c(31)*M(1))) * den(114)
  T3sum(1:5,6) = T3sum(1:5,6) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(42)*M(1)) * den(115)
  T3sum(1:5,8) = T3sum(1:5,8) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(43)*M(1)) * den(115)
  T3sum(1:5,6) = T3sum(1:5,6) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(31)*M(1)) * den(114)
  T3sum(1:5,6) = T3sum(1:5,6) + Gcoeff * G1tensor(:,47)
  Gcoeff = (-(c(42)*M(1))) * den(115)
  T3sum(1:5,9) = T3sum(1:5,9) + Gcoeff * G1tensor(:,49)
  Gcoeff = (-(c(43)*M(1))) * den(115)
  T3sum(1:5,6) = T3sum(1:5,6) + Gcoeff * G1tensor(:,48)
  Gcoeff = (-(c(50)*M(1))) * den(114)
  T3sum(1:5,10) = T3sum(1:5,10) + Gcoeff * G1tensor(:,62)
  Gcoeff = (-(c(1)*M(1))) * den(114)
  T3sum(1:5,7) = T3sum(1:5,7) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(65)*M(1)) * den(115)
  T3sum(1:5,10) = T3sum(1:5,10) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(66)*M(1)) * den(115)
  T3sum(1:5,7) = T3sum(1:5,7) + Gcoeff * G1tensor(:,65)
  Gcoeff = (-(c(33)*M(1))) * den(114)
  T3sum(1:5,6) = T3sum(1:5,6) + Gcoeff * G1tensor(:,56)
  Gcoeff = (-(c(17)*M(1))) * den(115)
  T3sum(1:5,6) = T3sum(1:5,6) + Gcoeff * G1tensor(:,57)
  Gcoeff = (-(c(50)*M(1))) * den(114)
  T3sum(1:5,10) = T3sum(1:5,10) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(50)*M(1)) * den(114)
  T3sum(1:5,7) = T3sum(1:5,7) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(54)*M(1)) * den(115)
  T3sum(1:5,10) = T3sum(1:5,10) + Gcoeff * G1tensor(:,52)
  Gcoeff = (-(c(15)*M(1))) * den(115)
  T3sum(1:5,8) = T3sum(1:5,8) + Gcoeff * G1tensor(:,72)
  Gcoeff = (-(c(54)*M(1))) * den(115)
  T3sum(1:5,7) = T3sum(1:5,7) + Gcoeff * G1tensor(:,53)
  Gcoeff = (-(c(50)*M(1))) * den(114)
  T3sum(1:5,10) = T3sum(1:5,10) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(50)*M(1)) * den(114)
  T3sum(1:5,7) = T3sum(1:5,7) + Gcoeff * G1tensor(:,67)
  Gcoeff = (c(54)*M(1)) * den(115)
  T3sum(1:5,10) = T3sum(1:5,10) + Gcoeff * G1tensor(:,69)
  Gcoeff = (-(c(15)*M(1))) * den(115)
  T3sum(1:5,9) = T3sum(1:5,9) + Gcoeff * G1tensor(:,73)
  Gcoeff = (-(c(54)*M(1))) * den(115)
  T3sum(1:5,7) = T3sum(1:5,7) + Gcoeff * G1tensor(:,70)
  Gcoeff = (-(c(19)*M(1))) * den(10)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(24)*M(1)) * den(10)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(23)*M(1)) * den(10)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(20)*M(1))) * den(10)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(11)*M(1)) * den(10)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(11)*M(1)) * den(10)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,97)
  Gcoeff = (-(c(19)*M(1))) * den(27)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(24)*M(1)) * den(27)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,101)
  Gcoeff = (c(23)*M(1)) * den(27)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(20)*M(1))) * den(27)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(11)*M(1)) * den(27)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(11)*M(1)) * den(27)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(36)*M(1))) * den(99)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,11)
  Gcoeff = (-(c(7)*M(1))) * den(99)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(45)*M(1)) * den(61)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(47)*M(1)) * den(61)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,102)
  Gcoeff = (-(c(20)*M(1))) * den(61)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,110)
  Gcoeff = (c(38)*M(1)) * den(64)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(40)*M(1)) * den(64)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(11)*M(1)) * den(64)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,111)
  Gcoeff = (c(24)*M(1)) * den(61)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(6)*M(1)) * den(64)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(21)*M(1)) * den(4)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(24)*M(1)) * den(4)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,92)
  Gcoeff = (-(c(49)*M(1))) * den(4)
  T3sum(1:5,13) = T3sum(1:5,13) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(53)*M(1)) * den(4)
  T3sum(1:5,14) = T3sum(1:5,14) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(53)*M(1)) * den(4)
  T3sum(1:5,15) = T3sum(1:5,15) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(2)*M(1))) * den(4)
  T3sum(1:5,16) = T3sum(1:5,16) + Gcoeff * G1tensor(:,60)
  Gcoeff = (-(c(7)*M(1))) * den(4)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(46)*M(1)) * den(4)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(39)*M(1)) * den(4)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(39)*M(1)) * den(4)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(28)*M(1)) * den(4)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,123)
  Gcoeff = (c(24)*M(1)) * den(4)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,117)
  Gcoeff = (c(6)*M(1)) * den(4)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(4)*M(1)) * den(4)
  T3sum(1:35,19) = T3sum(1:35,19) + Gcoeff * G3tensor(:,83)
  Gcoeff = (-(c(49)*M(1))) * den(4)
  T3sum(1:5,20) = T3sum(1:5,20) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(53)*M(1)) * den(4)
  T3sum(1:5,21) = T3sum(1:5,21) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(53)*M(1)) * den(4)
  T3sum(1:5,22) = T3sum(1:5,22) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(2)*M(1))) * den(4)
  T3sum(1:5,23) = T3sum(1:5,23) + Gcoeff * G1tensor(:,61)
  Gcoeff = (c(46)*M(1)) * den(4)
  T3sum(1:35,20) = T3sum(1:35,20) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(39)*M(1)) * den(4)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(39)*M(1)) * den(4)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(28)*M(1)) * den(4)
  T3sum(1:35,23) = T3sum(1:35,23) + Gcoeff * G3tensor(:,124)
  Gcoeff = (c(23)*M(1)) * den(4)
  T3sum(1:35,24) = T3sum(1:35,24) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(11)*M(1)) * den(4)
  T3sum(1:35,25) = T3sum(1:35,25) + Gcoeff * G3tensor(:,127)
  Gcoeff = (c(23)*M(1)) * den(4)
  T3sum(1:35,26) = T3sum(1:35,26) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(11)*M(1)) * den(4)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,42)
  Gcoeff = (-(c(47)*M(1))) * den(13)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,118)
  Gcoeff = (-(c(47)*M(1))) * den(13)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,123)
  Gcoeff = (c(48)*M(1)) * den(14)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(48)*M(1)) * den(14)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,124)
  Gcoeff = (c(24)*M(1)) * den(14)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,134)
  Gcoeff = (c(23)*M(1)) * den(13)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(11)*M(1)) * den(14)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(23)*M(1))) * den(30)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,138)
  Gcoeff = (c(48)*M(1)) * den(31)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,140)
  Gcoeff = (c(24)*M(1)) * den(31)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,139)
  Gcoeff = (c(23)*M(1)) * den(30)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,141)
  Gcoeff = (c(11)*M(1)) * den(31)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,142)
  Gcoeff = (c(48)*M(1)) * den(17)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(48)*M(1))) * den(17)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,120)
  Gcoeff = (c(40)*M(1)) * den(17)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,135)
  Gcoeff = (c(40)*M(1)) * den(17)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,125)
  Gcoeff = (-(c(47)*M(1))) * den(34)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,144)
  Gcoeff = (c(48)*M(1)) * den(36)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,145)
  Gcoeff = (c(47)*M(1)) * den(34)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,146)
  Gcoeff = (-(c(39)*M(1))) * den(34)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,148)
  Gcoeff = (c(40)*M(1)) * den(36)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,149)
  Gcoeff = (c(53)*M(1)) * den(55)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(53)*M(1)) * den(55)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,23)
  Gcoeff = (-(c(2)*M(1))) * den(58)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,19)
  Gcoeff = (-(c(2)*M(1))) * den(58)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(47)*M(1)) * den(55)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(40)*M(1)) * den(58)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(39)*M(1)) * den(55)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(39)*M(1)) * den(55)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(28)*M(1)) * den(58)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(28)*M(1)) * den(58)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(47)*M(1))) * den(53)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,144)
  Gcoeff = (c(48)*M(1)) * den(57)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,145)
  Gcoeff = (c(39)*M(1)) * den(53)
  T3sum(1:35,29) = T3sum(1:35,29) + Gcoeff * G3tensor(:,148)
  Gcoeff = (c(28)*M(1)) * den(57)
  T3sum(1:35,29) = T3sum(1:35,29) + Gcoeff * G3tensor(:,149)
  Gcoeff = (c(48)*M(1)) * den(57)
  T3sum(1:35,30) = T3sum(1:35,30) + Gcoeff * G3tensor(:,140)
  Gcoeff = (c(50)*M(1)) * den(53)
  T3sum(1:5,31) = T3sum(1:5,31) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(53)*M(1)) * den(53)
  T3sum(1:5,32) = T3sum(1:5,32) + Gcoeff * G1tensor(:,25)
  Gcoeff = (-(c(54)*M(1))) * den(57)
  T3sum(1:5,31) = T3sum(1:5,31) + Gcoeff * G1tensor(:,76)
  Gcoeff = (-(c(36)*M(1))) * den(57)
  T1sum(1:5,7) = T1sum(1:5,7) + Gcoeff * G1tensor(:,20)
  Gcoeff = (-(c(2)*M(1))) * den(57)
  T3sum(1:5,32) = T3sum(1:5,32) + Gcoeff * G1tensor(:,26)
  Gcoeff = (-(c(47)*M(1))) * den(53)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,132)
  Gcoeff = (c(39)*M(1)) * den(53)
  T3sum(1:35,32) = T3sum(1:35,32) + Gcoeff * G3tensor(:,46)
  Gcoeff = (-(c(40)*M(1))) * den(57)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,134)
  Gcoeff = (c(28)*M(1)) * den(57)
  T3sum(1:35,32) = T3sum(1:35,32) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(47)*M(1)) * den(53)
  T3sum(1:35,33) = T3sum(1:35,33) + Gcoeff * G3tensor(:,128)
  Gcoeff = (-(c(48)*M(1))) * den(57)
  T3sum(1:35,33) = T3sum(1:35,33) + Gcoeff * G3tensor(:,130)
  Gcoeff = (c(40)*M(1)) * den(57)
  T3sum(1:35,35) = T3sum(1:35,35) + Gcoeff * G3tensor(:,150)
  Gcoeff = (-(c(45)*M(1))) * den(100)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(47)*M(1))) * den(100)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,104)
  Gcoeff = (c(20)*M(1)) * den(100)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,112)
  Gcoeff = (c(46)*M(1)) * den(101)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(48)*M(1)) * den(101)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,105)
  Gcoeff = (c(24)*M(1)) * den(101)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,113)
  Gcoeff = (-(c(24)*M(1))) * den(100)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(11)*M(1)) * den(101)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(46)*M(1)) * den(12)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(47)*M(1))) * den(12)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(47)*M(1))) * den(12)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(48)*M(1)) * den(12)
  T2sum(1:15,42) = T2sum(1:15,42) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(46)*M(1)) * den(12)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(47)*M(1))) * den(12)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(47)*M(1))) * den(12)
  T2sum(1:15,45) = T2sum(1:15,45) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(48)*M(1)) * den(12)
  T2sum(1:15,46) = T2sum(1:15,46) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(4)*M(1)) * den(12)
  T2sum(1:15,47) = T2sum(1:15,47) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(46)*M(1)) * den(102)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(48)*M(1)) * den(102)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,106)
  Gcoeff = (c(24)*M(1)) * den(102)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(11)*M(1)) * den(102)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(4)*M(1)) * den(29)
  T2sum(1:15,50) = T2sum(1:15,50) + Gcoeff * G2tensor(:,143)
  Gcoeff = (c(24)*M(1)) * den(103)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,128)
  Gcoeff = (c(11)*M(1)) * den(103)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(11)*M(1)) * den(103)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(20)*M(1)) * den(9)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(24)*M(1)) * den(9)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(24)*M(1)) * den(9)
  T2sum(1:15,53) = T2sum(1:15,53) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(23)*M(1))) * den(9)
  T2sum(1:15,54) = T2sum(1:15,54) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(24)*M(1)) * den(9)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(24)*M(1)) * den(9)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(24)*M(1)) * den(1)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,43)
  Gcoeff = (c(47)*M(1)) * den(1)
  T3sum(1:35,37) = T3sum(1:35,37) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(40)*M(1)) * den(1)
  T3sum(1:35,38) = T3sum(1:35,38) + Gcoeff * G3tensor(:,44)
  Gcoeff = (-(c(23)*M(1))) * den(1)
  T3sum(1:35,39) = T3sum(1:35,39) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(24)*M(1)) * den(1)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(47)*M(1)) * den(1)
  T3sum(1:35,41) = T3sum(1:35,41) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(40)*M(1)) * den(1)
  T3sum(1:35,42) = T3sum(1:35,42) + Gcoeff * G3tensor(:,45)
  Gcoeff = (-(c(24)*M(1))) * den(1)
  T3sum(1:35,43) = T3sum(1:35,43) + Gcoeff * G3tensor(:,136)
  Gcoeff = (c(11)*M(1)) * den(1)
  T3sum(1:35,44) = T3sum(1:35,44) + Gcoeff * G3tensor(:,48)
  Gcoeff = (-(c(46)*M(1))) * den(1)
  T3sum(1:35,45) = T3sum(1:35,45) + Gcoeff * G3tensor(:,40)
  Gcoeff = (-(c(39)*M(1))) * den(1)
  T3sum(1:35,46) = T3sum(1:35,46) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(47)*M(1)) * den(1)
  T3sum(1:35,47) = T3sum(1:35,47) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(46)*M(1))) * den(1)
  T3sum(1:35,49) = T3sum(1:35,49) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(39)*M(1))) * den(1)
  T3sum(1:35,50) = T3sum(1:35,50) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(47)*M(1)) * den(1)
  T3sum(1:35,51) = T3sum(1:35,51) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(11)*M(1)) * den(1)
  T3sum(1:35,53) = T3sum(1:35,53) + Gcoeff * G3tensor(:,151)
  Gcoeff = (-(c(47)*M(1))) * den(1)
  T3sum(1:35,54) = T3sum(1:35,54) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(48)*M(1)) * den(1)
  T3sum(1:35,55) = T3sum(1:35,55) + Gcoeff * G3tensor(:,146)
  Gcoeff = (-(c(47)*M(1))) * den(1)
  T3sum(1:35,56) = T3sum(1:35,56) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(48)*M(1)) * den(1)
  T3sum(1:35,57) = T3sum(1:35,57) + Gcoeff * G3tensor(:,147)
  Gcoeff = (c(48)*M(1)) * den(24)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,85)
  Gcoeff = (-(c(48)*M(1))) * den(24)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(40)*M(1)) * den(24)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,90)
  Gcoeff = (c(40)*M(1)) * den(24)
  T2sum(1:15,64) = T2sum(1:15,64) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(47)*M(1))) * den(39)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(48)*M(1)) * den(41)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(39)*M(1))) * den(39)
  T2sum(1:15,70) = T2sum(1:15,70) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(39)*M(1))) * den(39)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(40)*M(1)) * den(41)
  T2sum(1:15,70) = T2sum(1:15,70) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(40)*M(1)) * den(41)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(53)*M(1)) * den(48)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(53)*M(1)) * den(48)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,40)
  Gcoeff = (-(c(2)*M(1))) * den(51)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,34)
  Gcoeff = (-(c(2)*M(1))) * den(51)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(39)*M(1)) * den(48)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(39)*M(1)) * den(48)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(28)*M(1)) * den(51)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(28)*M(1)) * den(51)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(53)*M(1)) * den(46)
  T3sum(1:5,59) = T3sum(1:5,59) + Gcoeff * G1tensor(:,35)
  Gcoeff = (-(c(36)*M(1))) * den(50)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,42)
  Gcoeff = (-(c(2)*M(1))) * den(50)
  T3sum(1:5,59) = T3sum(1:5,59) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(39)*M(1)) * den(46)
  T3sum(1:35,59) = T3sum(1:35,59) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(28)*M(1)) * den(50)
  T3sum(1:35,59) = T3sum(1:35,59) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(50)*M(1)) * den(46)
  T3sum(1:5,61) = T3sum(1:5,61) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(53)*M(1)) * den(46)
  T3sum(1:5,62) = T3sum(1:5,62) + Gcoeff * G1tensor(:,43)
  Gcoeff = (-(c(54)*M(1))) * den(50)
  T3sum(1:5,61) = T3sum(1:5,61) + Gcoeff * G1tensor(:,71)
  Gcoeff = (-(c(36)*M(1))) * den(50)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,37)
  Gcoeff = (-(c(2)*M(1))) * den(50)
  T3sum(1:5,62) = T3sum(1:5,62) + Gcoeff * G1tensor(:,44)
  Gcoeff = (-(c(47)*M(1))) * den(46)
  T3sum(1:35,61) = T3sum(1:35,61) + Gcoeff * G3tensor(:,113)
  Gcoeff = (c(39)*M(1)) * den(46)
  T3sum(1:35,62) = T3sum(1:35,62) + Gcoeff * G3tensor(:,65)
  Gcoeff = (-(c(40)*M(1))) * den(50)
  T3sum(1:35,61) = T3sum(1:35,61) + Gcoeff * G3tensor(:,116)
  Gcoeff = (c(28)*M(1)) * den(50)
  T3sum(1:35,62) = T3sum(1:35,62) + Gcoeff * G3tensor(:,66)
  Gcoeff = (c(47)*M(1)) * den(46)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,120)
  Gcoeff = (-(c(39)*M(1))) * den(46)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,125)
  Gcoeff = (-(c(48)*M(1))) * den(50)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,121)
  Gcoeff = (c(40)*M(1)) * den(50)
  T3sum(1:35,65) = T3sum(1:35,65) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(40)*M(1)) * den(50)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,126)
  Gcoeff = (-(c(45)*M(1))) * den(104)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(47)*M(1))) * den(104)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(20)*M(1)) * den(104)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,115)
  Gcoeff = (c(46)*M(1)) * den(105)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(48)*M(1)) * den(105)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(24)*M(1)) * den(105)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,116)
  Gcoeff = (-(c(24)*M(1))) * den(104)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(11)*M(1)) * den(105)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(46)*M(1)) * den(19)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(47)*M(1))) * den(19)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(47)*M(1))) * den(19)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(46)*M(1)) * den(19)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(47)*M(1))) * den(19)
  T2sum(1:15,79) = T2sum(1:15,79) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(47)*M(1))) * den(19)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(46)*M(1)) * den(106)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(48)*M(1)) * den(106)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,109)
  Gcoeff = (c(24)*M(1)) * den(106)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(11)*M(1)) * den(106)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(11)*M(1)) * den(107)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(11)*M(1)) * den(107)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(20)*M(1)) * den(26)
  T2sum(1:15,85) = T2sum(1:15,85) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(24)*M(1)) * den(26)
  T2sum(1:15,86) = T2sum(1:15,86) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(24)*M(1)) * den(26)
  T2sum(1:15,87) = T2sum(1:15,87) + Gcoeff * G2tensor(:,74)
  Gcoeff = (-(c(23)*M(1))) * den(26)
  T2sum(1:15,88) = T2sum(1:15,88) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(24)*M(1)) * den(26)
  T2sum(1:15,89) = T2sum(1:15,89) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(24)*M(1)) * den(26)
  T2sum(1:15,90) = T2sum(1:15,90) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(23)*M(1))) * den(2)
  T3sum(1:35,66) = T3sum(1:35,66) + Gcoeff * G3tensor(:,37)
  Gcoeff = (c(24)*M(1)) * den(2)
  T3sum(1:35,67) = T3sum(1:35,67) + Gcoeff * G3tensor(:,70)
  Gcoeff = (c(47)*M(1)) * den(2)
  T3sum(1:35,68) = T3sum(1:35,68) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(40)*M(1)) * den(2)
  T3sum(1:35,69) = T3sum(1:35,69) + Gcoeff * G3tensor(:,57)
  Gcoeff = (-(c(24)*M(1))) * den(2)
  T3sum(1:35,70) = T3sum(1:35,70) + Gcoeff * G3tensor(:,119)
  Gcoeff = (c(11)*M(1)) * den(2)
  T3sum(1:35,71) = T3sum(1:35,71) + Gcoeff * G3tensor(:,67)
  Gcoeff = (c(24)*M(1)) * den(2)
  T3sum(1:35,72) = T3sum(1:35,72) + Gcoeff * G3tensor(:,54)
  Gcoeff = (c(47)*M(1)) * den(2)
  T3sum(1:35,73) = T3sum(1:35,73) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(40)*M(1)) * den(2)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,58)
  Gcoeff = (-(c(46)*M(1))) * den(2)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(39)*M(1))) * den(2)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(47)*M(1)) * den(2)
  T3sum(1:35,77) = T3sum(1:35,77) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(40)*M(1)) * den(2)
  T3sum(1:35,78) = T3sum(1:35,78) + Gcoeff * G3tensor(:,68)
  Gcoeff = (c(11)*M(1)) * den(2)
  T3sum(1:35,79) = T3sum(1:35,79) + Gcoeff * G3tensor(:,55)
  Gcoeff = (-(c(46)*M(1))) * den(2)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,39)
  Gcoeff = (-(c(39)*M(1))) * den(2)
  T3sum(1:35,81) = T3sum(1:35,81) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(47)*M(1)) * den(2)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(40)*M(1)) * den(2)
  T3sum(1:35,83) = T3sum(1:35,83) + Gcoeff * G3tensor(:,71)
  Gcoeff = (-(c(47)*M(1))) * den(2)
  T3sum(1:35,84) = T3sum(1:35,84) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(48)*M(1)) * den(2)
  T3sum(1:35,85) = T3sum(1:35,85) + Gcoeff * G3tensor(:,84)
  Gcoeff = (-(c(47)*M(1))) * den(2)
  T3sum(1:35,86) = T3sum(1:35,86) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(48)*M(1)) * den(2)
  T3sum(1:35,87) = T3sum(1:35,87) + Gcoeff * G3tensor(:,85)
  Gcoeff = (c(48)*M(1)) * den(108)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(40)*M(1)) * den(108)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(40)*M(1)) * den(108)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(47)*M(1))) * den(109)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(48)*M(1)) * den(110)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,131)
  Gcoeff = (-(c(39)*M(1))) * den(109)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(39)*M(1))) * den(109)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(40)*M(1)) * den(110)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(40)*M(1)) * den(110)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(48)*M(1)) * den(23)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,122)
  Gcoeff = (c(48)*M(1)) * den(23)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(48)*M(1)) * den(23)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(40)*M(1)) * den(111)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(40)*M(1)) * den(111)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(39)*M(1))) * den(112)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(39)*M(1))) * den(112)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(40)*M(1)) * den(113)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(40)*M(1)) * den(113)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(48)*M(1)) * den(16)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(48)*M(1)) * den(16)
  T2sum(1:15,97) = T2sum(1:15,97) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(48)*M(1)) * den(16)
  T2sum(1:15,98) = T2sum(1:15,98) + Gcoeff * G2tensor(:,121)
  Gcoeff = (c(48)*M(1)) * den(16)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(48)*M(1)) * den(16)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(47)*M(1))) * den(38)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,132)
  Gcoeff = (-(c(47)*M(1))) * den(38)
  T2sum(1:15,105) = T2sum(1:15,105) + Gcoeff * G2tensor(:,136)
  Gcoeff = (c(48)*M(1)) * den(40)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,133)
  Gcoeff = (c(48)*M(1)) * den(40)
  T2sum(1:15,105) = T2sum(1:15,105) + Gcoeff * G2tensor(:,137)
  Gcoeff = (-(c(47)*M(1))) * den(33)
  T2sum(1:15,106) = T2sum(1:15,106) + Gcoeff * G2tensor(:,147)
  Gcoeff = (-(c(47)*M(1))) * den(33)
  T2sum(1:15,109) = T2sum(1:15,109) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(47)*M(1))) * den(33)
  T2sum(1:15,110) = T2sum(1:15,110) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(48)*M(1)) * den(35)
  T2sum(1:15,109) = T2sum(1:15,109) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(48)*M(1)) * den(35)
  T2sum(1:15,110) = T2sum(1:15,110) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(47)*M(1))) * den(3)
  T3sum(1:35,89) = T3sum(1:35,89) + Gcoeff * G3tensor(:,129)
  Gcoeff = (c(48)*M(1)) * den(6)
  T3sum(1:35,89) = T3sum(1:35,89) + Gcoeff * G3tensor(:,131)
  Gcoeff = (-(c(47)*M(1))) * den(3)
  T3sum(1:35,92) = T3sum(1:35,92) + Gcoeff * G3tensor(:,138)
  Gcoeff = (c(48)*M(1)) * den(6)
  T3sum(1:35,92) = T3sum(1:35,92) + Gcoeff * G3tensor(:,139)
  Gcoeff = (-(c(47)*M(1))) * den(3)
  T3sum(1:35,95) = T3sum(1:35,95) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(48)*M(1)) * den(6)
  T3sum(1:35,96) = T3sum(1:35,96) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(48)*M(1)) * den(6)
  T3sum(1:35,95) = T3sum(1:35,95) + Gcoeff * G3tensor(:,62)
  Gcoeff = (c(47)*M(1)) * den(3)
  T3sum(1:35,97) = T3sum(1:35,97) + Gcoeff * G3tensor(:,51)
  Gcoeff = (c(40)*M(1)) * den(6)
  T3sum(1:35,97) = T3sum(1:35,97) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(47)*M(1)) * den(3)
  T3sum(1:35,98) = T3sum(1:35,98) + Gcoeff * G3tensor(:,77)
  Gcoeff = (c(40)*M(1)) * den(6)
  T3sum(1:35,98) = T3sum(1:35,98) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(47)*M(1)) * den(3)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,133)
  Gcoeff = (c(47)*M(1)) * den(3)
  T3sum(1:35,100) = T3sum(1:35,100) + Gcoeff * G3tensor(:,73)
  Gcoeff = (c(40)*M(1)) * den(6)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,135)
  Gcoeff = (c(40)*M(1)) * den(6)
  T3sum(1:35,100) = T3sum(1:35,100) + Gcoeff * G3tensor(:,74)
  Gcoeff = (-(c(47)*M(1))) * den(3)
  T3sum(1:35,101) = T3sum(1:35,101) + Gcoeff * G3tensor(:,142)
  Gcoeff = (c(48)*M(1)) * den(6)
  T3sum(1:35,102) = T3sum(1:35,102) + Gcoeff * G3tensor(:,141)
  Gcoeff = (c(48)*M(1)) * den(6)
  T3sum(1:35,101) = T3sum(1:35,101) + Gcoeff * G3tensor(:,143)
  Gcoeff = (c(46)*M(1))
  T3sum(1:35,103) = T3sum(1:35,103) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(47)*M(1)))
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(47)*M(1)))
  T3sum(1:35,105) = T3sum(1:35,105) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(46)*M(1))
  T3sum(1:35,108) = T3sum(1:35,108) + Gcoeff * G3tensor(:,41)
  Gcoeff = (-(c(47)*M(1)))
  T3sum(1:35,109) = T3sum(1:35,109) + Gcoeff * G3tensor(:,26)
  Gcoeff = (-(c(47)*M(1)))
  T3sum(1:35,110) = T3sum(1:35,110) + Gcoeff * G3tensor(:,15)
  Gcoeff = (-(c(47)*M(1)))
  T3sum(1:35,112) = T3sum(1:35,112) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(48)*M(1))
  T3sum(1:35,113) = T3sum(1:35,113) + Gcoeff * G3tensor(:,72)
  Gcoeff = (-(c(47)*M(1)))
  T3sum(1:35,114) = T3sum(1:35,114) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(48)*M(1))
  T3sum(1:35,115) = T3sum(1:35,115) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(24)*M(1))
  T3sum(1:35,116) = T3sum(1:35,116) + Gcoeff * G3tensor(:,56)
  Gcoeff = (-(c(47)*M(1)))
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(48)*M(1))
  T3sum(1:35,118) = T3sum(1:35,118) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(24)*M(1))
  T3sum(1:35,119) = T3sum(1:35,119) + Gcoeff * G3tensor(:,79)
  Gcoeff = (c(48)*M(1))
  T3sum(1:35,120) = T3sum(1:35,120) + Gcoeff * G3tensor(:,59)
  Gcoeff = (c(24)*M(1))
  T3sum(1:35,121) = T3sum(1:35,121) + Gcoeff * G3tensor(:,137)
  Gcoeff = (c(24)*M(1))
  T3sum(1:35,122) = T3sum(1:35,122) + Gcoeff * G3tensor(:,75)
  Gcoeff = (-(c(47)*M(1)))
  T3sum(1:35,123) = T3sum(1:35,123) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(48)*M(1))
  T3sum(1:35,124) = T3sum(1:35,124) + Gcoeff * G3tensor(:,64)
  Gcoeff = (c(48)*M(1))
  T3sum(1:35,125) = T3sum(1:35,125) + Gcoeff * G3tensor(:,60)
  Gcoeff = (-(c(47)*M(1))) * den(116)
  T2sum(1:5,113) = T2sum(1:5,113) + Gcoeff * G1tensor(:,30)
  Gcoeff = (-(c(40)*M(1))) * den(117)
  T2sum(1:5,113) = T2sum(1:5,113) + Gcoeff * G1tensor(:,46)
  Gcoeff = (-(c(47)*M(1))) * den(118)
  T2sum(1:5,116) = T2sum(1:5,116) + Gcoeff * G1tensor(:,15)
  Gcoeff = (-(c(40)*M(1))) * den(119)
  T2sum(1:5,116) = T2sum(1:5,116) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(18)*M(1)) * den(72)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,74)
  Gcoeff = (-(c(47)*M(1))) * den(76)
  T1sum(1:5,14) = T1sum(1:5,14) + Gcoeff * G1tensor(:,77)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllll_ew_nexnmemxuux_2_/**/REALKIND
