
module ol_vamp_1_ppllll_ew_eeexexaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_ew_eeexexaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_ew_eeexexaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_ew_eeexexaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_ew_eeexexaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllll_ew_eeexexaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_eeexexaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,4,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,4,1,2,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,8,4,1,2,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,4,8,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,2,1,4,8,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,2,1,4,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,8,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,8,1,2,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,4,8,1,2,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,4,8,1,2,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,2,1,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,2,1,8,4,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,2,1,8,4,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,2,1,8,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,8,4,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,8,4,2,1,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,8,4,2,1,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,8,4,2,1,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,4,8,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,4,8,2,1,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(22),n2h32(22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,4,8,2,1,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(23),n2h32(23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,4,8,2,1,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(24),n2h32(24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,2,1,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(25),n2h32(25))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,2,1,16,4,8],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(26),n2h32(26))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,2,1,16,4,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(27),n2h32(27))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,2,1,16,4,8],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(28),n2h32(28))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,2,1,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(29),n2h32(29))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,2,1,16,8,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(30),n2h32(30))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,2,1,16,8,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(31),n2h32(31))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,2,1,16,8,4],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(32),n2h32(32))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,1,2,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(33),n2h32(33))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,1,2,4,8,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(34),n2h32(34))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,2,4,8,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(35),n2h32(35))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,2,4,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(36),n2h32(36))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,1,2,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(37),n2h32(37))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,1,2,8,4,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(38),n2h32(38))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,1,2,8,4,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(39),n2h32(39))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,2,8,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(40),n2h32(40))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,1,2,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(41),n2h32(41))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,1,2,16,4,8],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(42),n2h32(42))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,1,2,16,4,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(43),n2h32(43))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,1,2,16,4,8],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(44),n2h32(44))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,1,2,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(45),n2h32(45))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,1,2,16,8,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(46),n2h32(46))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,1,2,16,8,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(47),n2h32(47))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,1,2,16,8,4],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(48),n2h32(48))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,8,1,4,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(49),n2h32(49))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,8,1,4,2,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(50),n2h32(50))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,8,1,4,2,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(51),n2h32(51))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,8,1,4,2,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(52),n2h32(52))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,8,1,4,2,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,8,1,4,2,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(53),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,2,4,1,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(54),n2h32(53))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,2,4,1,8,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(55),n2h32(54))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,2,4,1,8,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(56),n2h32(55))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,2,4,1,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(57),n2h32(56))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,2,4,1,8,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,2,4,1,8,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,4,1,8,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G0H32(3),32,0,G1H32(59),n2h32(57))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,4,1,8,2,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H32(3),32,0,G1H32(60),n2h32(58))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,4,1,8,2,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,63),heltab2x64(:,:,63))
  call Hloop_Q_A(ntryL,G0H32(3),32,0,G1H32(61),n2h32(59))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,4,1,8,2,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,64),heltab2x64(:,:,64))
  call Hloop_Q_A(ntryL,G0H32(3),32,0,G1H32(62),n2h32(60))
  Gcoeff(:)%j = (c(8)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,4,1,8,2,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,4,1,8,2,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(63),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,2,8,1,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(64),n2h32(61))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,2,8,1,4,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(65),n2h32(62))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,2,8,1,4,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(66),n2h32(63))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,2,8,1,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(67),n2h32(64))
  Gcoeff(:)%j = (c(8)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,2,8,1,4,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,2,8,1,4,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,8,2,4,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(69),n2h32(65))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,8,2,4,1,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(70),n2h32(66))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,8,2,4,1,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(71),n2h32(67))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,8,2,4,1,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_Q_A(ntryL,G0H32(5),32,0,G1H32(72),n2h32(68))
  Gcoeff(:)%j = (c(8)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,8,2,4,1,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,77),heltab2x64(:,:,77))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,8,2,4,1,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(73),m3h2x32(:,78),heltab2x64(:,:,78))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,2,8,16,1,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,79),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(74),n2h32(69))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,2,8,16,1,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(75),n2h32(70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,2,8,16,1,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,81),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(76),n2h32(71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,2,8,16,1,4],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,82),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(77),n2h32(72))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,2,8,16,1,4],[nMW,0,nMW,nMW,0,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(78),m3h2x32(:,83),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,1,4,2,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,84),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(79),n2h32(73))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,1,4,2,8,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,85),heltab2x64(:,:,85))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(80),n2h32(74))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,1,4,2,8,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(81),n2h32(75))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,1,4,2,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,87),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(82),n2h32(76))
  Gcoeff(:)%j = (c(8)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,1,4,2,8,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,88),heltab2x64(:,:,88))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,1,4,2,8,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(83),m3h2x32(:,89),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,1,4,16,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,90),heltab2x64(:,:,90))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(84),n2h32(77))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,1,4,16,2,8],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(85),n2h32(78))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,1,4,16,2,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,92),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(86),n2h32(79))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,1,4,16,2,8],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,93),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(87),n2h32(80))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,1,4,16,2,8],[nMW,0,nMW,nMW,0,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,94),heltab2x64(:,:,94))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,4,2,8,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,95),heltab2x64(:,:,95))
  call Hloop_Q_A(ntryL,G0H32(7),32,0,G1H32(89),n2h32(81))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,4,2,8,1,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,96),heltab2x64(:,:,96))
  call Hloop_Q_A(ntryL,G0H32(7),32,0,G1H32(90),n2h32(82))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,4,2,8,1,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,97),heltab2x64(:,:,97))
  call Hloop_Q_A(ntryL,G0H32(7),32,0,G1H32(91),n2h32(83))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,4,2,8,1,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,98),heltab2x64(:,:,98))
  call Hloop_Q_A(ntryL,G0H32(7),32,0,G1H32(92),n2h32(84))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,4,2,8,1,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,99),heltab2x64(:,:,99))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,4,2,8,1,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(93),m3h2x32(:,100),heltab2x64(:,:,100))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,2,4,16,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,101),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(94),n2h32(85))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,2,4,16,1,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,102),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(95),n2h32(86))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,2,4,16,1,8],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,103),heltab2x64(:,:,103))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(96),n2h32(87))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,2,4,16,1,8],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,104),heltab2x64(:,:,104))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(97),n2h32(88))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,2,4,16,1,8],[nMW,0,nMW,nMW,0,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,105),heltab2x64(:,:,105))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,1,8,2,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,106),heltab2x64(:,:,106))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(99),n2h32(89))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,1,8,2,4,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,107),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(100),n2h32(90))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,1,8,2,4,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,108),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(101),n2h32(91))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,1,8,2,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,109),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(102),n2h32(92))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,1,8,2,4,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,110),heltab2x64(:,:,110))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,1,8,2,4,16],[nMW,0,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(103),m3h2x32(:,111),heltab2x64(:,:,111))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,1,8,16,2,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(104),n2h32(93))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,1,8,16,2,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,113),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(105),n2h32(94))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,1,8,16,2,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,114),heltab2x64(:,:,114))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(106),n2h32(95))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,1,8,16,2,4],[0,nMZ,0,0,nMZ,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,115),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(107),n2h32(96))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,1,8,16,2,4],[nMW,0,nMW,nMW,0,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(108),m3h2x32(:,116),heltab2x64(:,:,116))
  call Hloop_QA_V(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_QA_Z(ntryL,G1H32(2),ex4(:),G1H16(2),ngZl,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_QA_V(ntryL,G1H32(3),ex4(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_QA_Z(ntryL,G1H32(4),ex4(:),G1H16(4),ngZl,m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_AQ_V(ntryL,G1H32(5),ex2(:),G1H16(5),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_AQ_V(ntryL,G1H32(6),ex2(:),G1H16(6),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H32(7),ex2(:),G1H16(7),ngZl,m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H32(8),ex2(:),G1H16(8),ngZl,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_QA_V(ntryL,G1H32(9),ex3(:),G1H16(9),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_QA_Z(ntryL,G1H32(10),ex3(:),G1H16(10),ngZl,m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_QA_V(ntryL,G1H32(11),ex3(:),G1H16(11),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_QA_Z(ntryL,G1H32(12),ex3(:),G1H16(12),ngZl,m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_AQ_V(ntryL,G1H32(13),ex2(:),G1H16(13),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_AQ_V(ntryL,G1H32(14),ex2(:),G1H16(14),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_AQ_Z(ntryL,G1H32(15),ex2(:),G1H16(15),ngZl,m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H32(16),ex2(:),G1H16(16),ngZl,m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_QA_V(ntryL,G1H32(17),ex4(:),G1H16(17),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_QA_Z(ntryL,G1H32(18),ex4(:),G1H16(18),ngZl,m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_QA_V(ntryL,G1H32(19),ex4(:),G1H16(19),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_QA_Z(ntryL,G1H32(20),ex4(:),G1H16(20),ngZl,m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_QA_V(ntryL,G1H32(21),ex3(:),G1H16(21),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_QA_Z(ntryL,G1H32(22),ex3(:),G1H16(22),ngZl,m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_QA_V(ntryL,G1H32(23),ex3(:),G1H16(23),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_QA_Z(ntryL,G1H32(24),ex3(:),G1H16(24),ngZl,m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_AQ_V(ntryL,G1H32(25),ex2(:),G1H16(25),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_AQ_V(ntryL,G1H32(26),ex2(:),G1H16(26),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_AQ_Z(ntryL,G1H32(27),ex2(:),G1H16(27),ngZl,m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_AQ_Z(ntryL,G1H32(28),ex2(:),G1H16(28),ngZl,m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_AQ_V(ntryL,G1H32(29),ex2(:),G1H16(29),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_AQ_V(ntryL,G1H32(30),ex2(:),G1H16(30),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_AQ_Z(ntryL,G1H32(31),ex2(:),G1H16(31),ngZl,m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H32(32),ex2(:),G1H16(32),ngZl,m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_AQ_V(ntryL,G1H32(33),ex1(:),G1H16(33),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_AQ_V(ntryL,G1H32(34),ex1(:),G1H16(34),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H32(35),ex1(:),G1H16(35),ngZl,m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_AQ_Z(ntryL,G1H32(36),ex1(:),G1H16(36),ngZl,m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_AQ_V(ntryL,G1H32(37),ex1(:),G1H16(37),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_AQ_V(ntryL,G1H32(38),ex1(:),G1H16(38),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_AQ_Z(ntryL,G1H32(39),ex1(:),G1H16(39),ngZl,m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_AQ_Z(ntryL,G1H32(40),ex1(:),G1H16(40),ngZl,m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_AQ_V(ntryL,G1H32(41),ex1(:),G1H16(41),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_AQ_V(ntryL,G1H32(42),ex1(:),G1H16(42),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_AQ_Z(ntryL,G1H32(43),ex1(:),G1H16(43),ngZl,m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_AQ_Z(ntryL,G1H32(44),ex1(:),G1H16(44),ngZl,m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_AQ_V(ntryL,G1H32(45),ex1(:),G1H16(45),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_AQ_V(ntryL,G1H32(46),ex1(:),G1H16(46),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_AQ_Z(ntryL,G1H32(47),ex1(:),G1H16(47),ngZl,m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H32(48),ex1(:),G1H16(48),ngZl,m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_QA_V(ntryL,G1H32(49),ex4(:),G1H16(49),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_QA_V(ntryL,G1H32(50),ex4(:),G1H16(50),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_QA_Z(ntryL,G1H32(51),ex4(:),G1H16(51),ngZl,m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_QA_Z(ntryL,G1H32(52),ex4(:),G1H16(52),ngZl,m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_WA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(53),n2h16(1))
  call Hloop_WA_Q(ntryL,G1H32(53),ex4(:),G1H16(54),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H16(54),40,0,G2H16(1),n2h16(2))
  call Hloop_AQ_V(ntryL,G1H32(54),ex2(:),G1H16(54),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H32(55),ex2(:),G1H16(55),ngZl,m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_AQ_V(ntryL,G1H32(56),ex2(:),G1H16(56),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_AQ_Z(ntryL,G1H32(57),ex2(:),G1H16(57),ngZl,m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_WQ_A(ntryL,G0H32(2),ex2(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(58),n2h16(3))
  call Hloop_WQ_A(ntryL,G1H32(58),ex2(:),G1H16(59),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H16(59),34,0,G2H16(2),n2h16(4))
  call Hloop_QA_V(ntryL,G1H32(59),ex3(:),G1H16(59),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_QA_V(ntryL,G1H32(60),ex3(:),G1H16(60),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_QA_Z(ntryL,G1H32(61),ex3(:),G1H16(61),ngZl,m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_QA_Z(ntryL,G1H32(62),ex3(:),G1H16(62),ngZl,m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_WA_Q(ntryL,G0H32(3),ex3(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(63),n2h16(5))
  call Hloop_WA_Q(ntryL,G1H32(63),ex3(:),G1H16(64),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H16(64),36,0,G2H16(3),n2h16(6))
  call Hloop_AQ_V(ntryL,G1H32(64),ex2(:),G1H16(64),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_AQ_Z(ntryL,G1H32(65),ex2(:),G1H16(65),ngZl,m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_AQ_V(ntryL,G1H32(66),ex2(:),G1H16(66),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_AQ_Z(ntryL,G1H32(67),ex2(:),G1H16(67),ngZl,m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_WQ_A(ntryL,G0H32(4),ex2(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(68),n2h16(7))
  call Hloop_WQ_A(ntryL,G1H32(68),ex2(:),G1H16(69),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H16(69),34,0,G2H16(4),n2h16(8))
  call Hloop_QA_V(ntryL,G1H32(69),ex4(:),G1H16(69),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_QA_Z(ntryL,G1H32(70),ex4(:),G1H16(70),ngZl,m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_QA_V(ntryL,G1H32(71),ex4(:),G1H16(71),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_QA_Z(ntryL,G1H32(72),ex4(:),G1H16(72),ngZl,m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_WA_Q(ntryL,G0H32(5),ex4(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(73),n2h16(9))
  call Hloop_WA_Q(ntryL,G1H32(73),ex4(:),G1H16(74),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G1H16(74),40,0,G2H16(5),n2h16(10))
  call Hloop_AQ_V(ntryL,G1H32(74),ex2(:),G1H16(74),m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_AQ_Z(ntryL,G1H32(75),ex2(:),G1H16(75),ngZl,m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_AQ_V(ntryL,G1H32(76),ex2(:),G1H16(76),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_AQ_Z(ntryL,G1H32(77),ex2(:),G1H16(77),ngZl,m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_WQ_A(ntryL,G1H32(78),ex2(:),G1H16(78),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H16(78),34,0,G2H16(6),n2h16(11))
  call Hloop_AQ_V(ntryL,G1H32(79),ex1(:),G1H16(78),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_AQ_V(ntryL,G1H32(80),ex1(:),G1H16(79),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_AQ_Z(ntryL,G1H32(81),ex1(:),G1H16(80),ngZl,m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_AQ_Z(ntryL,G1H32(82),ex1(:),G1H16(81),ngZl,m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_WQ_A(ntryL,G0H32(6),ex1(:),G0H16(1),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(82),n2h16(12))
  call Hloop_WQ_A(ntryL,G1H32(83),ex1(:),G1H16(83),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H16(83),33,0,G2H16(7),n2h16(13))
  call Hloop_AQ_V(ntryL,G1H32(84),ex1(:),G1H16(83),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_AQ_V(ntryL,G1H32(85),ex1(:),G1H16(84),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_AQ_Z(ntryL,G1H32(86),ex1(:),G1H16(85),ngZl,m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_AQ_Z(ntryL,G1H32(87),ex1(:),G1H16(86),ngZl,m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_WQ_A(ntryL,G1H32(88),ex1(:),G1H16(87),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G1H16(87),33,0,G2H16(8),n2h16(14))
  call Hloop_QA_V(ntryL,G1H32(89),ex3(:),G1H16(87),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_QA_Z(ntryL,G1H32(90),ex3(:),G1H16(88),ngZl,m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_QA_V(ntryL,G1H32(91),ex3(:),G1H16(89),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_QA_Z(ntryL,G1H32(92),ex3(:),G1H16(90),ngZl,m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_WA_Q(ntryL,G0H32(7),ex3(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(91),n2h16(15))
  call Hloop_WA_Q(ntryL,G1H32(93),ex3(:),G1H16(92),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G1H16(92),36,0,G2H16(9),n2h16(16))
  call Hloop_AQ_V(ntryL,G1H32(94),ex2(:),G1H16(92),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_AQ_Z(ntryL,G1H32(95),ex2(:),G1H16(93),ngZl,m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_AQ_V(ntryL,G1H32(96),ex2(:),G1H16(94),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_AQ_Z(ntryL,G1H32(97),ex2(:),G1H16(95),ngZl,m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_WQ_A(ntryL,G1H32(98),ex2(:),G1H16(96),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_Q_A(ntryL,G1H16(96),34,0,G2H16(10),n2h16(17))
  call Hloop_AQ_V(ntryL,G1H32(99),ex1(:),G1H16(96),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_AQ_V(ntryL,G1H32(100),ex1(:),G1H16(97),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_AQ_Z(ntryL,G1H32(101),ex1(:),G1H16(98),ngZl,m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_AQ_Z(ntryL,G1H32(102),ex1(:),G1H16(99),ngZl,m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_WQ_A(ntryL,G0H32(8),ex1(:),G0H16(1),m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(100),n2h16(18))
  call Hloop_WQ_A(ntryL,G1H32(103),ex1(:),G1H16(101),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G1H16(101),33,0,G2H16(11),n2h16(19))
  call Hloop_AQ_V(ntryL,G1H32(104),ex1(:),G1H16(101),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_AQ_V(ntryL,G1H32(105),ex1(:),G1H16(102),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_AQ_Z(ntryL,G1H32(106),ex1(:),G1H16(103),ngZl,m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_AQ_Z(ntryL,G1H32(107),ex1(:),G1H16(104),ngZl,m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_WQ_A(ntryL,G1H32(108),ex1(:),G1H16(105),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G1H16(105),33,0,G2H16(12),n2h16(20))
  call Hloop_VA_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(1),n2h8(1))
  call Hloop_ZA_Q(ntryL,G1H16(2),ex3(:),G1H8(1),ngZl,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(2),n2h8(2))
  call Hloop_VA_Q(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(3),n2h8(3))
  call Hloop_ZA_Q(ntryL,G1H16(4),ex3(:),G1H8(1),ngZl,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(4),n2h8(4))
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(5),n2h8(5))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(6),n2h8(6))
  call Hloop_ZQ_A(ntryL,G1H16(7),ex1(:),G1H8(1),ngZl,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(7),n2h8(7))
  call Hloop_ZQ_A(ntryL,G1H16(8),ex1(:),G1H8(1),ngZl,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(8),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(9),ex4(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(9),n2h8(9))
  call Hloop_ZA_Q(ntryL,G1H16(10),ex4(:),G1H8(1),ngZl,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(10),n2h8(10))
  call Hloop_VA_Q(ntryL,G1H16(11),ex4(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(11),n2h8(11))
  call Hloop_ZA_Q(ntryL,G1H16(12),ex4(:),G1H8(1),ngZl,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(12),n2h8(12))
  call Hloop_VQ_A(ntryL,G1H16(13),ex1(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(13),n2h8(13))
  call Hloop_VQ_A(ntryL,G1H16(14),ex1(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(14),n2h8(14))
  call Hloop_ZQ_A(ntryL,G1H16(15),ex1(:),G1H8(1),ngZl,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(15),n2h8(15))
  call Hloop_ZQ_A(ntryL,G1H16(16),ex1(:),G1H8(1),ngZl,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(16),n2h8(16))
  call Hloop_VA_Q(ntryL,G1H16(17),ex3(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(17),n2h8(17))
  call Hloop_ZA_Q(ntryL,G1H16(18),ex3(:),G1H8(1),ngZl,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(18),n2h8(18))
  call Hloop_VA_Q(ntryL,G1H16(19),ex3(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(19),n2h8(19))
  call Hloop_ZA_Q(ntryL,G1H16(20),ex3(:),G1H8(1),ngZl,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(20),n2h8(20))
  call Hloop_VA_Q(ntryL,G1H16(21),ex4(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(21),n2h8(21))
  call Hloop_ZA_Q(ntryL,G1H16(22),ex4(:),G1H8(1),ngZl,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(22),n2h8(22))
  call Hloop_VA_Q(ntryL,G1H16(23),ex4(:),G1H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(23),n2h8(23))
  call Hloop_ZA_Q(ntryL,G1H16(24),ex4(:),G1H8(1),ngZl,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(24),n2h8(24))
  call Hloop_VQ_A(ntryL,G1H16(25),ex1(:),G1H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(25),n2h8(25))
  call Hloop_VQ_A(ntryL,G1H16(26),ex1(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(26),n2h8(26))
  call Hloop_ZQ_A(ntryL,G1H16(27),ex1(:),G1H8(1),ngZl,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(27),n2h8(27))
  call Hloop_ZQ_A(ntryL,G1H16(28),ex1(:),G1H8(1),ngZl,m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(28),n2h8(28))
  call Hloop_VQ_A(ntryL,G1H16(29),ex1(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(29),n2h8(29))
  call Hloop_VQ_A(ntryL,G1H16(30),ex1(:),G1H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(30),n2h8(30))
  call Hloop_ZQ_A(ntryL,G1H16(31),ex1(:),G1H8(1),ngZl,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(31),n2h8(31))
  call Hloop_ZQ_A(ntryL,G1H16(32),ex1(:),G1H8(1),ngZl,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(32),n2h8(32))
  call Hloop_VQ_A(ntryL,G1H16(33),ex2(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(33),n2h8(33))
  call Hloop_VQ_A(ntryL,G1H16(34),ex2(:),G1H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(34),n2h8(34))
  call Hloop_ZQ_A(ntryL,G1H16(35),ex2(:),G1H8(1),ngZl,m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(35),n2h8(35))
  call Hloop_ZQ_A(ntryL,G1H16(36),ex2(:),G1H8(1),ngZl,m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(36),n2h8(36))
  call Hloop_VQ_A(ntryL,G1H16(37),ex2(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(37),n2h8(37))
  call Hloop_VQ_A(ntryL,G1H16(38),ex2(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(38),n2h8(38))
  call Hloop_ZQ_A(ntryL,G1H16(39),ex2(:),G1H8(1),ngZl,m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(39),n2h8(39))
  call Hloop_ZQ_A(ntryL,G1H16(40),ex2(:),G1H8(1),ngZl,m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(40),n2h8(40))
  call Hloop_VQ_A(ntryL,G1H16(41),ex2(:),G1H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(41),n2h8(41))
  call Hloop_VQ_A(ntryL,G1H16(42),ex2(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(42),n2h8(42))
  call Hloop_ZQ_A(ntryL,G1H16(43),ex2(:),G1H8(1),ngZl,m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(43),n2h8(43))
  call Hloop_ZQ_A(ntryL,G1H16(44),ex2(:),G1H8(1),ngZl,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(44),n2h8(44))
  call Hloop_VQ_A(ntryL,G1H16(45),ex2(:),G1H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(45),n2h8(45))
  call Hloop_VQ_A(ntryL,G1H16(46),ex2(:),G1H8(1),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(46),n2h8(46))
  call Hloop_ZQ_A(ntryL,G1H16(47),ex2(:),G1H8(1),ngZl,m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(47),n2h8(47))
  call Hloop_ZQ_A(ntryL,G1H16(48),ex2(:),G1H8(1),ngZl,m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(48),n2h8(48))
  call Hloop_VQ_A(ntryL,G1H16(49),ex1(:),G1H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(49),n2h8(49))
  call Hloop_VQ_A(ntryL,G1H16(50),ex1(:),G1H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(50),n2h8(50))
  call Hloop_ZQ_A(ntryL,G1H16(51),ex1(:),G1H8(1),ngZl,m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(51),n2h8(51))
  call Hloop_ZQ_A(ntryL,G1H16(52),ex1(:),G1H8(1),ngZl,m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(52),n2h8(52))
  call Hloop_AQ_W(ntryL,G1H16(53),ex1(:),G1H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_AQ_W(ntryL,G2H16(1),ex1(:),G2H8(53),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_VA_Q(ntryL,G1H16(54),ex3(:),G1H8(2),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(54),n2h8(53))
  call Hloop_ZA_Q(ntryL,G1H16(55),ex3(:),G1H8(2),ngZl,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(55),n2h8(54))
  call Hloop_VA_Q(ntryL,G1H16(56),ex3(:),G1H8(2),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(56),n2h8(55))
  call Hloop_ZA_Q(ntryL,G1H16(57),ex3(:),G1H8(2),ngZl,m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(57),n2h8(56))
  call Hloop_QA_W(ntryL,G1H16(58),ex3(:),G1H8(2),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_QA_W(ntryL,G2H16(2),ex3(:),G2H8(58),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_VQ_A(ntryL,G1H16(59),ex1(:),G1H8(3),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(3),37,0,G2H8(59),n2h8(57))
  call Hloop_VQ_A(ntryL,G1H16(60),ex1(:),G1H8(3),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H8(3),37,0,G2H8(60),n2h8(58))
  call Hloop_ZQ_A(ntryL,G1H16(61),ex1(:),G1H8(3),ngZl,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(3),37,0,G2H8(61),n2h8(59))
  call Hloop_ZQ_A(ntryL,G1H16(62),ex1(:),G1H8(3),ngZl,m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(3),37,0,G2H8(62),n2h8(60))
  call Hloop_AQ_W(ntryL,G1H16(63),ex1(:),G1H8(3),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_AQ_W(ntryL,G2H16(3),ex1(:),G2H8(63),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_VA_Q(ntryL,G1H16(64),ex4(:),G1H8(4),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(4),42,0,G2H8(64),n2h8(61))
  call Hloop_ZA_Q(ntryL,G1H16(65),ex4(:),G1H8(4),ngZl,m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(4),42,0,G2H8(65),n2h8(62))
  call Hloop_VA_Q(ntryL,G1H16(66),ex4(:),G1H8(4),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(4),42,0,G2H8(66),n2h8(63))
  call Hloop_ZA_Q(ntryL,G1H16(67),ex4(:),G1H8(4),ngZl,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(4),42,0,G2H8(67),n2h8(64))
  call Hloop_QA_W(ntryL,G1H16(68),ex4(:),G1H8(4),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_QA_W(ntryL,G2H16(4),ex4(:),G2H8(68),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_VQ_A(ntryL,G1H16(69),ex2(:),G1H8(5),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(5),42,0,G2H8(69),n2h8(65))
  call Hloop_ZQ_A(ntryL,G1H16(70),ex2(:),G1H8(5),ngZl,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(5),42,0,G2H8(70),n2h8(66))
  call Hloop_VQ_A(ntryL,G1H16(71),ex2(:),G1H8(5),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(5),42,0,G2H8(71),n2h8(67))
  call Hloop_ZQ_A(ntryL,G1H16(72),ex2(:),G1H8(5),ngZl,m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(5),42,0,G2H8(72),n2h8(68))
  call Hloop_AQ_W(ntryL,G1H16(73),ex2(:),G1H8(5),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_AQ_W(ntryL,G2H16(5),ex2(:),G2H8(73),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_VA_Q(ntryL,G1H16(74),ex4(:),G1H8(6),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(6),42,0,G2H8(74),n2h8(69))
  call Hloop_ZA_Q(ntryL,G1H16(75),ex4(:),G1H8(6),ngZl,m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(6),42,0,G2H8(75),n2h8(70))
  call Hloop_VA_Q(ntryL,G1H16(76),ex4(:),G1H8(6),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(6),42,0,G2H8(76),n2h8(71))
  call Hloop_ZA_Q(ntryL,G1H16(77),ex4(:),G1H8(6),ngZl,m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(6),42,0,G2H8(77),n2h8(72))
  call Hloop_QA_W(ntryL,G2H16(6),ex4(:),G2H8(78),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_VA_Q(ntryL,G1H16(78),ex3(:),G1H8(6),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(6),37,0,G2H8(79),n2h8(73))
  call Hloop_VA_Q(ntryL,G1H16(79),ex3(:),G1H8(6),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(6),37,0,G2H8(80),n2h8(74))
  call Hloop_ZA_Q(ntryL,G1H16(80),ex3(:),G1H8(6),ngZl,m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H8(6),37,0,G2H8(81),n2h8(75))
  call Hloop_ZA_Q(ntryL,G1H16(81),ex3(:),G1H8(6),ngZl,m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(6),37,0,G2H8(82),n2h8(76))
  call Hloop_QA_W(ntryL,G1H16(82),ex3(:),G1H8(6),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_QA_W(ntryL,G2H16(7),ex3(:),G2H8(83),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_VA_Q(ntryL,G1H16(83),ex3(:),G1H8(7),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(7),37,0,G2H8(84),n2h8(77))
  call Hloop_VA_Q(ntryL,G1H16(84),ex3(:),G1H8(7),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(7),37,0,G2H8(85),n2h8(78))
  call Hloop_ZA_Q(ntryL,G1H16(85),ex3(:),G1H8(7),ngZl,m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(7),37,0,G2H8(86),n2h8(79))
  call Hloop_ZA_Q(ntryL,G1H16(86),ex3(:),G1H8(7),ngZl,m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(7),37,0,G2H8(87),n2h8(80))
  call Hloop_QA_W(ntryL,G2H16(8),ex3(:),G2H8(88),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_VQ_A(ntryL,G1H16(87),ex2(:),G1H8(7),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(7),38,0,G2H8(89),n2h8(81))
  call Hloop_ZQ_A(ntryL,G1H16(88),ex2(:),G1H8(7),ngZl,m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(7),38,0,G2H8(90),n2h8(82))
  call Hloop_VQ_A(ntryL,G1H16(89),ex2(:),G1H8(7),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(7),38,0,G2H8(91),n2h8(83))
  call Hloop_ZQ_A(ntryL,G1H16(90),ex2(:),G1H8(7),ngZl,m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(7),38,0,G2H8(92),n2h8(84))
  call Hloop_AQ_W(ntryL,G1H16(91),ex2(:),G1H8(7),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_AQ_W(ntryL,G2H16(9),ex2(:),G2H8(93),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_VA_Q(ntryL,G1H16(92),ex3(:),G1H8(8),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(8),38,0,G2H8(94),n2h8(85))
  call Hloop_ZA_Q(ntryL,G1H16(93),ex3(:),G1H8(8),ngZl,m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G1H8(8),38,0,G2H8(95),n2h8(86))
  call Hloop_VA_Q(ntryL,G1H16(94),ex3(:),G1H8(8),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_A_Q(ntryL,G1H8(8),38,0,G2H8(96),n2h8(87))
  call Hloop_ZA_Q(ntryL,G1H16(95),ex3(:),G1H8(8),ngZl,m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(8),38,0,G2H8(97),n2h8(88))
  call Hloop_QA_W(ntryL,G2H16(10),ex3(:),G2H8(98),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_VA_Q(ntryL,G1H16(96),ex4(:),G1H8(8),m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(8),41,0,G2H8(99),n2h8(89))
  call Hloop_VA_Q(ntryL,G1H16(97),ex4(:),G1H8(8),m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G1H8(8),41,0,G2H8(100),n2h8(90))
  call Hloop_ZA_Q(ntryL,G1H16(98),ex4(:),G1H8(8),ngZl,m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G1H8(8),41,0,G2H8(101),n2h8(91))
  call Hloop_ZA_Q(ntryL,G1H16(99),ex4(:),G1H8(8),ngZl,m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G1H8(8),41,0,G2H8(102),n2h8(92))
  call Hloop_QA_W(ntryL,G1H16(100),ex4(:),G1H8(8),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_QA_W(ntryL,G2H16(11),ex4(:),G2H8(103),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_VA_Q(ntryL,G1H16(101),ex4(:),G1H8(9),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_A_Q(ntryL,G1H8(9),41,0,G2H8(104),n2h8(93))
  call Hloop_VA_Q(ntryL,G1H16(102),ex4(:),G1H8(9),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H8(9),41,0,G2H8(105),n2h8(94))
  call Hloop_ZA_Q(ntryL,G1H16(103),ex4(:),G1H8(9),ngZl,m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_A_Q(ntryL,G1H8(9),41,0,G2H8(106),n2h8(95))
  call Hloop_ZA_Q(ntryL,G1H16(104),ex4(:),G1H8(9),ngZl,m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_A_Q(ntryL,G1H8(9),41,0,G2H8(107),n2h8(96))
  call Hloop_QA_W(ntryL,G2H16(12),ex4(:),G2H8(108),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(2),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_Z(ntryL,G2H8(3),ex1(:),G2H4(3),ngZl,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H8(4),ex1(:),G2H4(4),ngZl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_V(ntryL,G2H8(5),ex3(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_Z(ntryL,G2H8(6),ex3(:),G2H4(6),ngZl,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H8(7),ex3(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_Z(ntryL,G2H8(8),ex3(:),G2H4(8),ngZl,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_V(ntryL,G2H8(9),ex1(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_Z(ntryL,G2H8(11),ex1(:),G2H4(11),ngZl,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_Z(ntryL,G2H8(12),ex1(:),G2H4(12),ngZl,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(13),ex4(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_Z(ntryL,G2H8(14),ex4(:),G2H4(14),ngZl,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(15),ex4(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_QA_Z(ntryL,G2H8(16),ex4(:),G2H4(16),ngZl,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(17),ex2(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(18),ex2(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_Z(ntryL,G2H8(19),ex2(:),G2H4(19),ngZl,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_Z(ntryL,G2H8(20),ex2(:),G2H4(20),ngZl,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G2H8(21),ex2(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G2H8(22),ex2(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_Z(ntryL,G2H8(23),ex2(:),G2H4(23),ngZl,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_Z(ntryL,G2H8(24),ex2(:),G2H4(24),ngZl,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(1),mass5set(:,1),  & 
G1H8(9),G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(10),8,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(1),mass5set(:,1),  & 
G1H8(15),G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(16),8,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(1),mass5set(:,2),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(22),8,8)
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(1),mass5set(:,2),  & 
G1H8(27),G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(28),8,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(1),mass5set(:,1),  & 
G1H8(33),G1H8(34),G1H8(35),G1H8(36),G1H8(37),G1H8(38),8)
  call HG1shiftOLR(G1H8(34),4,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(1),mass5set(:,1),  & 
G1H8(39),G1H8(40),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(40),4,8)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(1),mass5set(:,2),  & 
G1H8(45),G1H8(46),G1H8(47),G1H8(48),G1H8(49),G1H8(50),8)
  call HG1shiftOLR(G1H8(46),4,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(1),mass5set(:,2),  & 
G1H8(51),G1H8(52),G1H8(53),G1H8(54),G1H8(55),G1H8(56),8)
  call HG1shiftOLR(G1H8(52),4,8)
  call Hloop_QA_V(ntryL,G2H8(33),ex3(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_Z(ntryL,G2H8(34),ex3(:),G2H4(26),ngZl,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_V(ntryL,G2H8(35),ex3(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QA_Z(ntryL,G2H8(36),ex3(:),G2H4(28),ngZl,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QA_V(ntryL,G2H8(37),ex4(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QA_Z(ntryL,G2H8(38),ex4(:),G2H4(30),ngZl,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_QA_V(ntryL,G2H8(39),ex4(:),G2H4(31),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_QA_Z(ntryL,G2H8(40),ex4(:),G2H4(32),ngZl,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(2),mass5set(:,1),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(58),8,8)
  call Hotf_5pt_reduction(G2H8(42),RedSet_5(2),mass5set(:,1),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(64),8,8)
  call Hotf_5pt_reduction(G2H8(43),RedSet_5(2),mass5set(:,2),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
  call HG1shiftOLR(G1H8(70),8,8)
  call Hotf_5pt_reduction(G2H8(44),RedSet_5(2),mass5set(:,2),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(76),8,8)
  call Hotf_5pt_reduction(G2H8(45),RedSet_5(2),mass5set(:,1),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(82),4,8)
  call Hotf_5pt_reduction(G2H8(46),RedSet_5(2),mass5set(:,1),  & 
G1H8(87),G1H8(88),G1H8(89),G1H8(90),G1H8(91),G1H8(92),8)
  call HG1shiftOLR(G1H8(88),4,8)
  call Hotf_5pt_reduction(G2H8(47),RedSet_5(2),mass5set(:,2),  & 
G1H8(93),G1H8(94),G1H8(95),G1H8(96),G1H8(97),G1H8(98),8)
  call HG1shiftOLR(G1H8(94),4,8)
  call Hotf_5pt_reduction(G2H8(48),RedSet_5(2),mass5set(:,2),  & 
G1H8(99),G1H8(100),G1H8(101),G1H8(102),G1H8(103),G1H8(104),8)
  call HG1shiftOLR(G1H8(100),4,8)
  call Hloop_QA_V(ntryL,G2H8(49),ex3(:),G2H4(33),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_QA_Z(ntryL,G2H8(50),ex3(:),G2H4(34),ngZl,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_QA_V(ntryL,G2H8(51),ex3(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_QA_Z(ntryL,G2H8(52),ex3(:),G2H4(36),ngZl,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_WA_Q(ntryL,G1H8(1),ex3(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(37),n2h4(1))
  call Hotf_5pt_reduction(G2H8(53),RedSet_5(3),mass5set(:,3),  & 
G1H8(1),G1H8(105),G1H8(106),G1H8(107),G1H8(108),G1H8(109),8)
  call HG1shiftOLR(G1H8(105),16,8)
  call Hloop_AQ_V(ntryL,G2H8(54),ex1(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_AQ_V(ntryL,G2H8(55),ex1(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_AQ_Z(ntryL,G2H8(56),ex1(:),G2H4(40),ngZl,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_AQ_Z(ntryL,G2H8(57),ex1(:),G2H4(41),ngZl,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_WQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(42),n2h4(2))
  call Hotf_5pt_reduction(G2H8(58),RedSet_5(4),mass5set(:,3),  & 
G1H8(2),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),16,8)
  call Hloop_QA_V(ntryL,G2H8(59),ex4(:),G2H4(43),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_QA_Z(ntryL,G2H8(60),ex4(:),G2H4(44),ngZl,m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_QA_V(ntryL,G2H8(61),ex4(:),G2H4(45),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_QA_Z(ntryL,G2H8(62),ex4(:),G2H4(46),ngZl,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_WA_Q(ntryL,G1H8(3),ex4(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(47),n2h4(3))
  call Hotf_5pt_reduction(G2H8(63),RedSet_5(5),mass5set(:,3),  & 
G1H8(3),G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),8)
  call HG1shiftOLR(G1H8(115),16,8)
  call Hloop_AQ_V(ntryL,G2H8(64),ex1(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_AQ_V(ntryL,G2H8(65),ex1(:),G2H4(49),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_AQ_Z(ntryL,G2H8(66),ex1(:),G2H4(50),ngZl,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_AQ_Z(ntryL,G2H8(67),ex1(:),G2H4(51),ngZl,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_WQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(52),n2h4(4))
  call Hotf_5pt_reduction(G2H8(68),RedSet_5(6),mass5set(:,3),  & 
G1H8(4),G1H8(120),G1H8(121),G1H8(122),G1H8(123),G1H8(124),8)
  call HG1shiftOLR(G1H8(120),16,8)
  call Hloop_QA_V(ntryL,G2H8(69),ex3(:),G2H4(53),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_QA_V(ntryL,G2H8(70),ex3(:),G2H4(54),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_QA_Z(ntryL,G2H8(71),ex3(:),G2H4(55),ngZl,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_QA_Z(ntryL,G2H8(72),ex3(:),G2H4(56),ngZl,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_WA_Q(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(57),n2h4(5))
  call Hotf_5pt_reduction(G2H8(73),RedSet_5(7),mass5set(:,3),  & 
G1H8(5),G1H8(125),G1H8(126),G1H8(127),G1H8(128),G1H8(129),8)
  call HG1shiftOLR(G1H8(125),16,8)
  call Hotf_5pt_reduction(G2H8(74),RedSet_5(8),mass5set(:,1),  & 
G1H8(130),G1H8(131),G1H8(132),G1H8(133),G1H8(134),G1H8(135),8)
  call HG1shiftOLR(G1H8(131),4,8)
  call Hotf_5pt_reduction(G2H8(75),RedSet_5(8),mass5set(:,2),  & 
G1H8(136),G1H8(137),G1H8(138),G1H8(139),G1H8(140),G1H8(141),8)
  call HG1shiftOLR(G1H8(137),4,8)
  call Hotf_5pt_reduction(G2H8(76),RedSet_5(8),mass5set(:,1),  & 
G1H8(142),G1H8(143),G1H8(144),G1H8(145),G1H8(146),G1H8(147),8)
  call HG1shiftOLR(G1H8(143),4,8)
  call Hotf_5pt_reduction(G2H8(77),RedSet_5(8),mass5set(:,2),  & 
G1H8(148),G1H8(149),G1H8(150),G1H8(151),G1H8(152),G1H8(153),8)
  call HG1shiftOLR(G1H8(149),4,8)
  call Hotf_5pt_reduction(G2H8(78),RedSet_5(8),mass5set(:,4),  & 
G1H8(154),G1H8(155),G1H8(156),G1H8(157),G1H8(158),G1H8(159),8)
  call HG1shiftOLR(G1H8(155),4,8)
  call Hloop_AQ_V(ntryL,G2H8(79),ex2(:),G2H4(58),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_AQ_Z(ntryL,G2H8(80),ex2(:),G2H4(59),ngZl,m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_AQ_V(ntryL,G2H8(81),ex2(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_AQ_Z(ntryL,G2H8(82),ex2(:),G2H4(61),ngZl,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_WQ_A(ntryL,G1H8(6),ex2(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(62),n2h4(6))
  call Hotf_5pt_reduction(G2H8(83),RedSet_5(9),mass5set(:,3),  & 
G1H8(6),G1H8(160),G1H8(161),G1H8(162),G1H8(163),G1H8(164),8)
  call HG1shiftOLR(G1H8(160),16,8)
  call Hotf_5pt_reduction(G2H8(84),RedSet_5(10),mass5set(:,1),  & 
G1H8(165),G1H8(166),G1H8(167),G1H8(168),G1H8(169),G1H8(170),8)
  call HG1shiftOLR(G1H8(166),8,8)
  call Hotf_5pt_reduction(G2H8(85),RedSet_5(10),mass5set(:,1),  & 
G1H8(171),G1H8(172),G1H8(173),G1H8(174),G1H8(175),G1H8(176),8)
  call HG1shiftOLR(G1H8(172),8,8)
  call Hotf_5pt_reduction(G2H8(86),RedSet_5(10),mass5set(:,2),  & 
G1H8(177),G1H8(178),G1H8(179),G1H8(180),G1H8(181),G1H8(182),8)
  call HG1shiftOLR(G1H8(178),8,8)
  call Hotf_5pt_reduction(G2H8(87),RedSet_5(10),mass5set(:,2),  & 
G1H8(183),G1H8(184),G1H8(185),G1H8(186),G1H8(187),G1H8(188),8)
  call HG1shiftOLR(G1H8(184),8,8)
  call Hotf_5pt_reduction(G2H8(88),RedSet_5(10),mass5set(:,4),  & 
G1H8(189),G1H8(190),G1H8(191),G1H8(192),G1H8(193),G1H8(194),8)
  call HG1shiftOLR(G1H8(190),8,8)
  call Hloop_QA_V(ntryL,G2H8(89),ex4(:),G2H4(63),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_QA_V(ntryL,G2H8(90),ex4(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_QA_Z(ntryL,G2H8(91),ex4(:),G2H4(65),ngZl,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_QA_Z(ntryL,G2H8(92),ex4(:),G2H4(66),ngZl,m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_WA_Q(ntryL,G1H8(7),ex4(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(67),n2h4(7))
  call Hotf_5pt_reduction(G2H8(93),RedSet_5(11),mass5set(:,3),  & 
G1H8(7),G1H8(195),G1H8(196),G1H8(197),G1H8(198),G1H8(199),8)
  call HG1shiftOLR(G1H8(195),16,8)
  call Hotf_5pt_reduction(G2H8(94),RedSet_5(12),mass5set(:,1),  & 
G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),G1H8(205),8)
  call HG1shiftOLR(G1H8(201),8,8)
  call Hotf_5pt_reduction(G2H8(95),RedSet_5(12),mass5set(:,2),  & 
G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),G1H8(211),8)
  call HG1shiftOLR(G1H8(207),8,8)
  call Hotf_5pt_reduction(G2H8(96),RedSet_5(12),mass5set(:,1),  & 
G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),G1H8(217),8)
  call HG1shiftOLR(G1H8(213),8,8)
  call Hotf_5pt_reduction(G2H8(97),RedSet_5(12),mass5set(:,2),  & 
G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),G1H8(223),8)
  call HG1shiftOLR(G1H8(219),8,8)
  call Hotf_5pt_reduction(G2H8(98),RedSet_5(12),mass5set(:,4),  & 
G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),G1H8(229),8)
  call HG1shiftOLR(G1H8(225),8,8)
  call Hloop_AQ_V(ntryL,G2H8(99),ex2(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_AQ_Z(ntryL,G2H8(100),ex2(:),G2H4(69),ngZl,m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_AQ_V(ntryL,G2H8(101),ex2(:),G2H4(70),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_AQ_Z(ntryL,G2H8(102),ex2(:),G2H4(71),ngZl,m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_WQ_A(ntryL,G1H8(8),ex2(:),G1H4(1),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(72),n2h4(8))
  call Hotf_5pt_reduction(G2H8(103),RedSet_5(13),mass5set(:,3),  & 
G1H8(8),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),16,8)
  call Hotf_5pt_reduction(G2H8(104),RedSet_5(14),mass5set(:,1),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),4,8)
  call Hotf_5pt_reduction(G2H8(105),RedSet_5(14),mass5set(:,1),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),4,8)
  call Hotf_5pt_reduction(G2H8(106),RedSet_5(14),mass5set(:,2),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(248),4,8)
  call Hotf_5pt_reduction(G2H8(107),RedSet_5(14),mass5set(:,2),  & 
G1H8(253),G1H8(254),G1H8(255),G1H8(256),G1H8(257),G1H8(258),8)
  call HG1shiftOLR(G1H8(254),4,8)
  call Hotf_5pt_reduction(G2H8(108),RedSet_5(14),mass5set(:,4),  & 
G1H8(259),G1H8(260),G1H8(261),G1H8(262),G1H8(263),G1H8(264),8)
  call HG1shiftOLR(G1H8(260),4,8)
  call Hloop_QV_A(ntryL,G1H8(9),ex5(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(73),n2h4(9))
call HGT_OLR(G1H8(10),1,1,8)
call HGT_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(10),-8,0,G2H8(1),n2h8(97))
  call Hloop_QA_V(ntryL,G2H8(1),ex4(:),G2H4(74),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_QV_A(ntryL,G1H8(13),ex5(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(75),n2h4(10))
  call Hloop_QV_A(ntryL,G1H8(14),ex5(:),G1H4(1),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(76),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(15),ex5(:),G1H4(1),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(77),n2h4(12))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(16),-8,0,G2H8(2),n2h8(98))
  call Hloop_QA_Z(ntryL,G2H8(2),ex4(:),G2H4(78),ngZl,m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_QV_A(ntryL,G1H8(19),ex5(:),G1H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(79),n2h4(13))
  call Hloop_QV_A(ntryL,G1H8(20),ex5(:),G1H4(1),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(80),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(21),ex5(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(81),n2h4(15))
call HGT_OLR(G1H8(22),1,1,8)
call HGT_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(22),-8,0,G2H8(3),n2h8(99))
  call Hloop_QA_V(ntryL,G2H8(3),ex4(:),G2H4(82),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_QV_A(ntryL,G1H8(25),ex5(:),G1H4(1),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(83),n2h4(16))
  call Hloop_QV_A(ntryL,G1H8(26),ex5(:),G1H4(1),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(84),n2h4(17))
  call Hloop_QV_A(ntryL,G1H8(27),ex5(:),G1H4(1),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(85),n2h4(18))
call HGT_OLR(G1H8(28),1,1,8)
call HGT_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(28),-8,0,G2H8(4),n2h8(100))
  call Hloop_QA_Z(ntryL,G2H8(4),ex4(:),G2H4(86),ngZl,m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_QV_A(ntryL,G1H8(31),ex5(:),G1H4(1),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(87),n2h4(19))
  call Hloop_QV_A(ntryL,G1H8(32),ex5(:),G1H4(1),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(88),n2h4(20))
  call Hloop_QV_A(ntryL,G1H8(33),ex5(:),G1H4(1),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(89),n2h4(21))
call HGT_OLR(G1H8(34),1,1,8)
call HGT_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(34),-4,0,G2H8(5),n2h8(101))
  call Hloop_QA_V(ntryL,G2H8(5),ex3(:),G2H4(90),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_QV_A(ntryL,G1H8(37),ex5(:),G1H4(1),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(91),n2h4(22))
  call Hloop_QV_A(ntryL,G1H8(38),ex5(:),G1H4(1),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(92),n2h4(23))
  call Hloop_QV_A(ntryL,G1H8(39),ex5(:),G1H4(1),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(93),n2h4(24))
call HGT_OLR(G1H8(40),1,1,8)
call HGT_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(40),-4,0,G2H8(6),n2h8(102))
  call Hloop_QA_Z(ntryL,G2H8(6),ex3(:),G2H4(94),ngZl,m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_QV_A(ntryL,G1H8(43),ex5(:),G1H4(1),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(95),n2h4(25))
  call Hloop_QV_A(ntryL,G1H8(44),ex5(:),G1H4(1),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(96),n2h4(26))
  call Hloop_QV_A(ntryL,G1H8(45),ex5(:),G1H4(1),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(97),n2h4(27))
call HGT_OLR(G1H8(46),1,1,8)
call HGT_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(46),-4,0,G2H8(7),n2h8(103))
  call Hloop_QA_V(ntryL,G2H8(7),ex3(:),G2H4(98),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_QV_A(ntryL,G1H8(49),ex5(:),G1H4(1),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(99),n2h4(28))
  call Hloop_QV_A(ntryL,G1H8(50),ex5(:),G1H4(1),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(100),n2h4(29))
  call Hloop_QV_A(ntryL,G1H8(51),ex5(:),G1H4(1),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(101),n2h4(30))
call HGT_OLR(G1H8(52),1,1,8)
call HGT_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(52),-4,0,G2H8(8),n2h8(104))
  call Hloop_QA_Z(ntryL,G2H8(8),ex3(:),G2H4(102),ngZl,m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_QV_A(ntryL,G1H8(55),ex5(:),G1H4(1),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(103),n2h4(31))
  call Hloop_QV_A(ntryL,G1H8(56),ex5(:),G1H4(1),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(104),n2h4(32))
  call Hloop_QV_A(ntryL,G1H8(57),ex5(:),G1H4(1),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(105),n2h4(33))
call HGT_OLR(G1H8(58),1,1,8)
call HGT_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(58),-8,0,G2H8(9),n2h8(105))
  call Hloop_QA_V(ntryL,G2H8(9),ex4(:),G2H4(106),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_QV_A(ntryL,G1H8(61),ex5(:),G1H4(1),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(107),n2h4(34))
  call Hloop_QV_A(ntryL,G1H8(62),ex5(:),G1H4(1),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(108),n2h4(35))
  call Hloop_QV_A(ntryL,G1H8(63),ex5(:),G1H4(1),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(109),n2h4(36))
call HGT_OLR(G1H8(64),1,1,8)
call HGT_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(64),-8,0,G2H8(10),n2h8(106))
  call Hloop_QA_Z(ntryL,G2H8(10),ex4(:),G2H4(110),ngZl,m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(1),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(111),n2h4(37))
  call Hloop_QV_A(ntryL,G1H8(68),ex5(:),G1H4(1),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(112),n2h4(38))
  call Hloop_QV_A(ntryL,G1H8(69),ex5(:),G1H4(1),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(113),n2h4(39))
call HGT_OLR(G1H8(70),1,1,8)
call HGT_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(70),-8,0,G2H8(11),n2h8(107))
  call Hloop_QA_V(ntryL,G2H8(11),ex4(:),G2H4(114),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_QV_A(ntryL,G1H8(73),ex5(:),G1H4(1),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(115),n2h4(40))
  call Hloop_QV_A(ntryL,G1H8(74),ex5(:),G1H4(1),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(116),n2h4(41))
  call Hloop_QV_A(ntryL,G1H8(75),ex5(:),G1H4(1),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(117),n2h4(42))
call HGT_OLR(G1H8(76),1,1,8)
call HGT_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(76),-8,0,G2H8(12),n2h8(108))
  call Hloop_QA_Z(ntryL,G2H8(12),ex4(:),G2H4(118),ngZl,m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_QV_A(ntryL,G1H8(79),ex5(:),G1H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(119),n2h4(43))
  call Hloop_QV_A(ntryL,G1H8(80),ex5(:),G1H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(120),n2h4(44))
  call Hloop_QV_A(ntryL,G1H8(81),ex5(:),G1H4(1),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(121),n2h4(45))
call HGT_OLR(G1H8(82),1,1,8)
call HGT_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(82),-4,0,G2H8(13),n2h8(109))
  call Hloop_QA_V(ntryL,G2H8(13),ex3(:),G2H4(122),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_QV_A(ntryL,G1H8(85),ex5(:),G1H4(1),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(123),n2h4(46))
  call Hloop_QV_A(ntryL,G1H8(86),ex5(:),G1H4(1),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(124),n2h4(47))
  call Hloop_QV_A(ntryL,G1H8(87),ex5(:),G1H4(1),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(125),n2h4(48))
call HGT_OLR(G1H8(88),1,1,8)
call HGT_invQ_OLR(G1H8(88),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(88),-4,0,G2H8(14),n2h8(110))
  call Hloop_QA_Z(ntryL,G2H8(14),ex3(:),G2H4(126),ngZl,m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_QV_A(ntryL,G1H8(91),ex5(:),G1H4(1),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(127),n2h4(49))
  call Hloop_QV_A(ntryL,G1H8(92),ex5(:),G1H4(1),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(128),n2h4(50))
  call Hloop_QV_A(ntryL,G1H8(93),ex5(:),G1H4(1),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(129),n2h4(51))
call HGT_OLR(G1H8(94),1,1,8)
call HGT_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(94),-4,0,G2H8(15),n2h8(111))
  call Hloop_QA_V(ntryL,G2H8(15),ex3(:),G2H4(130),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_QV_A(ntryL,G1H8(97),ex5(:),G1H4(1),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(131),n2h4(52))
  call Hloop_QV_A(ntryL,G1H8(98),ex5(:),G1H4(1),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(132),n2h4(53))
  call Hloop_QV_A(ntryL,G1H8(99),ex5(:),G1H4(1),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(133),n2h4(54))
call HGT_OLR(G1H8(100),1,1,8)
call HGT_invQ_OLR(G1H8(100),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(100),-4,0,G2H8(16),n2h8(112))
  call Hloop_QA_Z(ntryL,G2H8(16),ex3(:),G2H4(134),ngZl,m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_QV_A(ntryL,G1H8(103),ex5(:),G1H4(1),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(135),n2h4(55))
  call Hloop_QV_A(ntryL,G1H8(104),ex5(:),G1H4(1),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(136),n2h4(56))
  call Hloop_WA_Q(ntryL,G1H8(1),ex3(:),G1H4(1),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(137),n2h4(57))
call HGT_raise_alpha_OLR(G1H8(105),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(105),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(105),-16,ex5(:),16,G2H4(138),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_WA_Q(ntryL,G1H8(108),ex3(:),G1H4(1),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(139),n2h4(58))
  call Hloop_WA_Q(ntryL,G1H8(109),ex3(:),G1H4(1),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(140),n2h4(59))
  call Hloop_WQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(141),n2h4(60))
call HGT_raise_alpha_OLR(G1H8(110),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(110),-16,ex5(:),16,G2H4(142),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_WQ_A(ntryL,G1H8(113),ex1(:),G1H4(1),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(143),n2h4(61))
  call Hloop_WQ_A(ntryL,G1H8(114),ex1(:),G1H4(1),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(144),n2h4(62))
  call Hloop_WA_Q(ntryL,G1H8(3),ex4(:),G1H4(1),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(145),n2h4(63))
call HGT_raise_alpha_OLR(G1H8(115),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(115),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(115),-16,ex5(:),16,G2H4(146),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_WA_Q(ntryL,G1H8(118),ex4(:),G1H4(1),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(147),n2h4(64))
  call Hloop_WA_Q(ntryL,G1H8(119),ex4(:),G1H4(1),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(1),45,0,G2H4(148),n2h4(65))
  call Hloop_WQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(149),n2h4(66))
call HGT_raise_alpha_OLR(G1H8(120),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(120),-16,ex5(:),16,G2H4(150),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_WQ_A(ntryL,G1H8(123),ex1(:),G1H4(1),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(151),n2h4(67))
  call Hloop_WQ_A(ntryL,G1H8(124),ex1(:),G1H4(1),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(152),n2h4(68))
  call Hloop_WA_Q(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(153),n2h4(69))
call HGT_raise_alpha_OLR(G1H8(125),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(125),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(125),-16,ex5(:),16,G2H4(154),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_WA_Q(ntryL,G1H8(128),ex3(:),G1H4(1),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(155),n2h4(70))
  call Hloop_WA_Q(ntryL,G1H8(129),ex3(:),G1H4(1),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(156),n2h4(71))
  call Hloop_AV_Q(ntryL,G1H8(130),ex5(:),G1H4(1),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(157),n2h4(72))
call HGT_OLR(G1H8(131),1,1,8)
call HGT_invQ_OLR(G1H8(131),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(131),-4,0,G2H8(17),n2h8(118))
  call Hloop_QA_V(ntryL,G2H8(17),ex3(:),G2H4(158),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_AV_Q(ntryL,G1H8(134),ex5(:),G1H4(1),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(159),n2h4(73))
  call Hloop_AV_Q(ntryL,G1H8(135),ex5(:),G1H4(1),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(160),n2h4(74))
  call Hloop_AV_Q(ntryL,G1H8(136),ex5(:),G1H4(1),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(161),n2h4(75))
call HGT_OLR(G1H8(137),1,1,8)
call HGT_invQ_OLR(G1H8(137),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(137),-4,0,G2H8(18),n2h8(119))
  call Hloop_QA_V(ntryL,G2H8(18),ex3(:),G2H4(162),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_AV_Q(ntryL,G1H8(140),ex5(:),G1H4(1),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(163),n2h4(76))
  call Hloop_AV_Q(ntryL,G1H8(141),ex5(:),G1H4(1),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(164),n2h4(77))
  call Hloop_AV_Q(ntryL,G1H8(142),ex5(:),G1H4(1),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(165),n2h4(78))
call HGT_OLR(G1H8(143),1,1,8)
call HGT_invQ_OLR(G1H8(143),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(143),-4,0,G2H8(19),n2h8(120))
  call Hloop_QA_Z(ntryL,G2H8(19),ex3(:),G2H4(166),ngZl,m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_AV_Q(ntryL,G1H8(146),ex5(:),G1H4(1),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(167),n2h4(79))
  call Hloop_AV_Q(ntryL,G1H8(147),ex5(:),G1H4(1),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(168),n2h4(80))
  call Hloop_AV_Q(ntryL,G1H8(148),ex5(:),G1H4(1),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(169),n2h4(81))
call HGT_OLR(G1H8(149),1,1,8)
call HGT_invQ_OLR(G1H8(149),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(149),-4,0,G2H8(20),n2h8(121))
  call Hloop_QA_Z(ntryL,G2H8(20),ex3(:),G2H4(170),ngZl,m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_AV_Q(ntryL,G1H8(152),ex5(:),G1H4(1),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(171),n2h4(82))
  call Hloop_AV_Q(ntryL,G1H8(153),ex5(:),G1H4(1),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(172),n2h4(83))
  call Hloop_UW_V(ntryL,G1H8(154),42,ex5(:),16,G2H4(173),m3h2x4(:,173),heltab2x8(:,:,173))
call HGT_raise_alpha_OLR(G1H8(155),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(155),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(155),ex3(:),G1H4(1),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_UW_V(ntryL,G1H8(158),42,ex5(:),16,G2H4(174),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_UW_V(ntryL,G1H8(159),42,ex5(:),16,G2H4(175),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_WQ_A(ntryL,G1H8(6),ex2(:),G1H4(2),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(176),n2h4(84))
call HGT_raise_alpha_OLR(G1H8(160),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(160),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(160),-16,ex5(:),16,G2H4(177),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_WQ_A(ntryL,G1H8(163),ex2(:),G1H4(2),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(178),n2h4(85))
  call Hloop_WQ_A(ntryL,G1H8(164),ex2(:),G1H4(2),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(179),n2h4(86))
  call Hloop_AV_Q(ntryL,G1H8(165),ex5(:),G1H4(2),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(180),n2h4(87))
call HGT_OLR(G1H8(166),1,1,8)
call HGT_invQ_OLR(G1H8(166),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(166),-8,0,G2H8(21),n2h8(124))
  call Hloop_QA_V(ntryL,G2H8(21),ex4(:),G2H4(181),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_AV_Q(ntryL,G1H8(169),ex5(:),G1H4(2),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(182),n2h4(88))
  call Hloop_AV_Q(ntryL,G1H8(170),ex5(:),G1H4(2),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(183),n2h4(89))
  call Hloop_AV_Q(ntryL,G1H8(171),ex5(:),G1H4(2),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(184),n2h4(90))
call HGT_OLR(G1H8(172),1,1,8)
call HGT_invQ_OLR(G1H8(172),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(172),-8,0,G2H8(22),n2h8(125))
  call Hloop_QA_Z(ntryL,G2H8(22),ex4(:),G2H4(185),ngZl,m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_AV_Q(ntryL,G1H8(175),ex5(:),G1H4(2),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(186),n2h4(91))
  call Hloop_AV_Q(ntryL,G1H8(176),ex5(:),G1H4(2),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(187),n2h4(92))
  call Hloop_AV_Q(ntryL,G1H8(177),ex5(:),G1H4(2),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(188),n2h4(93))
call HGT_OLR(G1H8(178),1,1,8)
call HGT_invQ_OLR(G1H8(178),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(178),-8,0,G2H8(23),n2h8(126))
  call Hloop_QA_V(ntryL,G2H8(23),ex4(:),G2H4(189),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_AV_Q(ntryL,G1H8(181),ex5(:),G1H4(2),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(190),n2h4(94))
  call Hloop_AV_Q(ntryL,G1H8(182),ex5(:),G1H4(2),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(191),n2h4(95))
  call Hloop_AV_Q(ntryL,G1H8(183),ex5(:),G1H4(2),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(192),n2h4(96))
call HGT_OLR(G1H8(184),1,1,8)
call HGT_invQ_OLR(G1H8(184),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(184),-8,0,G2H8(24),n2h8(127))
  call Hloop_QA_Z(ntryL,G2H8(24),ex4(:),G2H4(193),ngZl,m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_AV_Q(ntryL,G1H8(187),ex5(:),G1H4(2),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(194),n2h4(97))
  call Hloop_AV_Q(ntryL,G1H8(188),ex5(:),G1H4(2),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_A_Q(ntryL,G1H4(2),53,0,G2H4(195),n2h4(98))
  call Hloop_UW_V(ntryL,G1H8(189),37,ex5(:),16,G2H4(196),m3h2x4(:,197),heltab2x8(:,:,197))
call HGT_raise_alpha_OLR(G1H8(190),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(190),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(190),ex4(:),G1H4(2),m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_UW_V(ntryL,G1H8(193),37,ex5(:),16,G2H4(197),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_UW_V(ntryL,G1H8(194),37,ex5(:),16,G2H4(198),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_WA_Q(ntryL,G1H8(7),ex4(:),G1H4(3),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_A_Q(ntryL,G1H4(3),46,0,G2H4(199),n2h4(99))
call HGT_raise_alpha_OLR(G1H8(195),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(195),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(195),-16,ex5(:),16,G2H4(200),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_WA_Q(ntryL,G1H8(198),ex4(:),G1H4(3),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(3),46,0,G2H4(201),n2h4(100))
  call Hloop_WA_Q(ntryL,G1H8(199),ex4(:),G1H4(3),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(3),46,0,G2H4(202),n2h4(101))
  call Hloop_AV_Q(ntryL,G1H8(200),ex5(:),G1H4(3),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(203),n2h4(102))
call HGT_OLR(G1H8(201),1,1,8)
call HGT_invQ_OLR(G1H8(201),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(201),-8,0,G2H8(25),n2h8(130))
  call Hloop_QA_V(ntryL,G2H8(25),ex4(:),G2H4(204),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_AV_Q(ntryL,G1H8(204),ex5(:),G1H4(3),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(205),n2h4(103))
  call Hloop_AV_Q(ntryL,G1H8(205),ex5(:),G1H4(3),m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(206),n2h4(104))
  call Hloop_AV_Q(ntryL,G1H8(206),ex5(:),G1H4(3),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(207),n2h4(105))
call HGT_OLR(G1H8(207),1,1,8)
call HGT_invQ_OLR(G1H8(207),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(207),-8,0,G2H8(26),n2h8(131))
  call Hloop_QA_V(ntryL,G2H8(26),ex4(:),G2H4(208),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_AV_Q(ntryL,G1H8(210),ex5(:),G1H4(3),m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(209),n2h4(106))
  call Hloop_AV_Q(ntryL,G1H8(211),ex5(:),G1H4(3),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(210),n2h4(107))
  call Hloop_AV_Q(ntryL,G1H8(212),ex5(:),G1H4(3),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(211),n2h4(108))
call HGT_OLR(G1H8(213),1,1,8)
call HGT_invQ_OLR(G1H8(213),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(213),-8,0,G2H8(27),n2h8(132))
  call Hloop_QA_Z(ntryL,G2H8(27),ex4(:),G2H4(212),ngZl,m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_AV_Q(ntryL,G1H8(216),ex5(:),G1H4(3),m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(213),n2h4(109))
  call Hloop_AV_Q(ntryL,G1H8(217),ex5(:),G1H4(3),m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(214),n2h4(110))
  call Hloop_AV_Q(ntryL,G1H8(218),ex5(:),G1H4(3),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(215),n2h4(111))
call HGT_OLR(G1H8(219),1,1,8)
call HGT_invQ_OLR(G1H8(219),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(219),-8,0,G2H8(28),n2h8(133))
  call Hloop_QA_Z(ntryL,G2H8(28),ex4(:),G2H4(216),ngZl,m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_AV_Q(ntryL,G1H8(222),ex5(:),G1H4(3),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(217),n2h4(112))
  call Hloop_AV_Q(ntryL,G1H8(223),ex5(:),G1H4(3),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_A_Q(ntryL,G1H4(3),54,0,G2H4(218),n2h4(113))
  call Hloop_UW_V(ntryL,G1H8(224),38,ex5(:),16,G2H4(219),m3h2x4(:,221),heltab2x8(:,:,221))
call HGT_raise_alpha_OLR(G1H8(225),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(225),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(225),ex4(:),G1H4(3),m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_UW_V(ntryL,G1H8(228),38,ex5(:),16,G2H4(220),m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_UW_V(ntryL,G1H8(229),38,ex5(:),16,G2H4(221),m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_WQ_A(ntryL,G1H8(8),ex2(:),G1H4(4),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G1H4(4),43,0,G2H4(222),n2h4(114))
call HGT_raise_alpha_OLR(G1H8(230),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(230),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(230),-16,ex5(:),16,G2H4(223),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_WQ_A(ntryL,G1H8(233),ex2(:),G1H4(4),m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G1H4(4),43,0,G2H4(224),n2h4(115))
  call Hloop_WQ_A(ntryL,G1H8(234),ex2(:),G1H4(4),m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_Q_A(ntryL,G1H4(4),43,0,G2H4(225),n2h4(116))
  call Hloop_AV_Q(ntryL,G1H8(235),ex5(:),G1H4(4),m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(226),n2h4(117))
call HGT_OLR(G1H8(236),1,1,8)
call HGT_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(236),-4,0,G2H8(29),n2h8(136))
  call Hloop_QA_V(ntryL,G2H8(29),ex3(:),G2H4(227),m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_AV_Q(ntryL,G1H8(239),ex5(:),G1H4(4),m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(228),n2h4(118))
  call Hloop_AV_Q(ntryL,G1H8(240),ex5(:),G1H4(4),m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(229),n2h4(119))
  call Hloop_AV_Q(ntryL,G1H8(241),ex5(:),G1H4(4),m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(230),n2h4(120))
call HGT_OLR(G1H8(242),1,1,8)
call HGT_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(242),-4,0,G2H8(30),n2h8(137))
  call Hloop_QA_Z(ntryL,G2H8(30),ex3(:),G2H4(231),ngZl,m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_AV_Q(ntryL,G1H8(245),ex5(:),G1H4(4),m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(232),n2h4(121))
  call Hloop_AV_Q(ntryL,G1H8(246),ex5(:),G1H4(4),m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(233),n2h4(122))
  call Hloop_AV_Q(ntryL,G1H8(247),ex5(:),G1H4(4),m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(234),n2h4(123))
call HGT_OLR(G1H8(248),1,1,8)
call HGT_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(248),-4,0,G2H8(31),n2h8(138))
  call Hloop_QA_V(ntryL,G2H8(31),ex3(:),G2H4(235),m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_AV_Q(ntryL,G1H8(251),ex5(:),G1H4(4),m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(236),n2h4(124))
  call Hloop_AV_Q(ntryL,G1H8(252),ex5(:),G1H4(4),m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(237),n2h4(125))
  call Hloop_AV_Q(ntryL,G1H8(253),ex5(:),G1H4(4),m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(238),n2h4(126))
call HGT_OLR(G1H8(254),1,1,8)
call HGT_invQ_OLR(G1H8(254),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(254),-4,0,G2H8(32),n2h8(139))
  call Hloop_QA_Z(ntryL,G2H8(32),ex3(:),G2H4(239),ngZl,m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_AV_Q(ntryL,G1H8(257),ex5(:),G1H4(4),m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(240),n2h4(127))
  call Hloop_AV_Q(ntryL,G1H8(258),ex5(:),G1H4(4),m3h2x4(:,244),heltab2x8(:,:,244))
  call Hloop_A_Q(ntryL,G1H4(4),57,0,G2H4(241),n2h4(128))
  call Hloop_UW_V(ntryL,G1H8(259),41,ex5(:),16,G2H4(242),m3h2x4(:,245),heltab2x8(:,:,245))
call HGT_raise_alpha_OLR(G1H8(260),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(260),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(260),ex3(:),G1H4(4),m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_UW_V(ntryL,G1H8(263),41,ex5(:),16,G2H4(243),m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_UW_V(ntryL,G1H8(264),41,ex5(:),16,G2H4(244),m3h2x4(:,248),heltab2x8(:,:,248))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(15),mass5set(:,1),  & 
G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(9),G1H4(10),4)
  call HG1shiftOLR(G1H4(6),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(15),mass5set(:,2),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(15),mass5set(:,5),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(15),mass5set(:,6),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(24),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(16),mass5set(:,1),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(30),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(16),mass5set(:,5),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(16),mass5set(:,2),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(42),16,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(16),mass5set(:,6),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(48),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(17),mass5set(:,1),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),16,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(17),mass5set(:,2),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(60),16,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(17),mass5set(:,5),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(17),mass5set(:,6),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(18),mass5set(:,1),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(78),16,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(18),mass5set(:,5),  & 
G1H4(83),G1H4(84),G1H4(85),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(84),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(18),mass5set(:,2),  & 
G1H4(89),G1H4(90),G1H4(91),G1H4(92),G1H4(93),G1H4(94),4)
  call HG1shiftOLR(G1H4(90),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(18),mass5set(:,6),  & 
G1H4(95),G1H4(96),G1H4(97),G1H4(98),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(96),16,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(19),mass5set(:,1),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(102),16,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(19),mass5set(:,2),  & 
G1H4(107),G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(108),16,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(19),mass5set(:,5),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(114),16,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(19),mass5set(:,6),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(120),16,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(20),mass5set(:,1),  & 
G1H4(125),G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(126),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(20),mass5set(:,2),  & 
G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(132),16,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(20),mass5set(:,5),  & 
G1H4(137),G1H4(138),G1H4(139),G1H4(140),G1H4(141),G1H4(142),4)
  call HG1shiftOLR(G1H4(138),16,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(20),mass5set(:,6),  & 
G1H4(143),G1H4(144),G1H4(145),G1H4(146),G1H4(147),G1H4(148),4)
  call HG1shiftOLR(G1H4(144),16,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(21),mass5set(:,1),  & 
G1H4(149),G1H4(150),G1H4(151),G1H4(152),G1H4(153),G1H4(154),4)
  call HG1shiftOLR(G1H4(150),16,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(21),mass5set(:,5),  & 
G1H4(155),G1H4(156),G1H4(157),G1H4(158),G1H4(159),G1H4(160),4)
  call HG1shiftOLR(G1H4(156),16,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(21),mass5set(:,2),  & 
G1H4(161),G1H4(162),G1H4(163),G1H4(164),G1H4(165),G1H4(166),4)
  call HG1shiftOLR(G1H4(162),16,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(21),mass5set(:,6),  & 
G1H4(167),G1H4(168),G1H4(169),G1H4(170),G1H4(171),G1H4(172),4)
  call HG1shiftOLR(G1H4(168),16,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(22),mass5set(:,1),  & 
G1H4(173),G1H4(174),G1H4(175),G1H4(176),G1H4(177),G1H4(178),4)
  call HG1shiftOLR(G1H4(174),16,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(22),mass5set(:,5),  & 
G1H4(179),G1H4(180),G1H4(181),G1H4(182),G1H4(183),G1H4(184),4)
  call HG1shiftOLR(G1H4(180),16,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(22),mass5set(:,2),  & 
G1H4(185),G1H4(186),G1H4(187),G1H4(188),G1H4(189),G1H4(190),4)
  call HG1shiftOLR(G1H4(186),16,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(22),mass5set(:,6),  & 
G1H4(191),G1H4(192),G1H4(193),G1H4(194),G1H4(195),G1H4(196),4)
  call HG1shiftOLR(G1H4(192),16,4)
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(3),mass5set(:,1),  & 
G1H4(197),G1H4(198),G1H4(199),G1H4(200),G1H4(201),G1H4(202),4)
  call HG1shiftOLR(G1H4(198),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(3),mass5set(:,5),  & 
G1H4(203),G1H4(204),G1H4(205),G1H4(206),G1H4(207),G1H4(208),4)
  call HG1shiftOLR(G1H4(204),16,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(3),mass5set(:,2),  & 
G1H4(209),G1H4(210),G1H4(211),G1H4(212),G1H4(213),G1H4(214),4)
  call HG1shiftOLR(G1H4(210),16,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(3),mass5set(:,6),  & 
G1H4(215),G1H4(216),G1H4(217),G1H4(218),G1H4(219),G1H4(220),4)
  call HG1shiftOLR(G1H4(216),16,4)
  call Hloop_AQ_W(ntryL,G2H4(37),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(4),mass5set(:,1),  & 
G1H4(221),G1H4(222),G1H4(223),G1H4(224),G1H4(225),G1H4(226),4)
  call HG1shiftOLR(G1H4(222),16,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(4),mass5set(:,2),  & 
G1H4(227),G1H4(228),G1H4(229),G1H4(230),G1H4(231),G1H4(232),4)
  call HG1shiftOLR(G1H4(228),16,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(4),mass5set(:,5),  & 
G1H4(233),G1H4(234),G1H4(235),G1H4(236),G1H4(237),G1H4(238),4)
  call HG1shiftOLR(G1H4(234),16,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(4),mass5set(:,6),  & 
G1H4(239),G1H4(240),G1H4(241),G1H4(242),G1H4(243),G1H4(244),4)
  call HG1shiftOLR(G1H4(240),16,4)
  call Hloop_QA_W(ntryL,G2H4(42),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(5),mass5set(:,1),  & 
G1H4(245),G1H4(246),G1H4(247),G1H4(248),G1H4(249),G1H4(250),4)
  call HG1shiftOLR(G1H4(246),16,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(5),mass5set(:,5),  & 
G1H4(251),G1H4(252),G1H4(253),G1H4(254),G1H4(255),G1H4(256),4)
  call HG1shiftOLR(G1H4(252),16,4)
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(5),mass5set(:,2),  & 
G1H4(257),G1H4(258),G1H4(259),G1H4(260),G1H4(261),G1H4(262),4)
  call HG1shiftOLR(G1H4(258),16,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(5),mass5set(:,6),  & 
G1H4(263),G1H4(264),G1H4(265),G1H4(266),G1H4(267),G1H4(268),4)
  call HG1shiftOLR(G1H4(264),16,4)
  call Hloop_AQ_W(ntryL,G2H4(47),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(6),mass5set(:,1),  & 
G1H4(269),G1H4(270),G1H4(271),G1H4(272),G1H4(273),G1H4(274),4)
  call HG1shiftOLR(G1H4(270),16,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(6),mass5set(:,2),  & 
G1H4(275),G1H4(276),G1H4(277),G1H4(278),G1H4(279),G1H4(280),4)
  call HG1shiftOLR(G1H4(276),16,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(6),mass5set(:,5),  & 
G1H4(281),G1H4(282),G1H4(283),G1H4(284),G1H4(285),G1H4(286),4)
  call HG1shiftOLR(G1H4(282),16,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(6),mass5set(:,6),  & 
G1H4(287),G1H4(288),G1H4(289),G1H4(290),G1H4(291),G1H4(292),4)
  call HG1shiftOLR(G1H4(288),16,4)
  call Hloop_QA_W(ntryL,G2H4(52),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(7),mass5set(:,1),  & 
G1H4(293),G1H4(294),G1H4(295),G1H4(296),G1H4(297),G1H4(298),4)
  call HG1shiftOLR(G1H4(294),16,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(7),mass5set(:,2),  & 
G1H4(299),G1H4(300),G1H4(301),G1H4(302),G1H4(303),G1H4(304),4)
  call HG1shiftOLR(G1H4(300),16,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(7),mass5set(:,5),  & 
G1H4(305),G1H4(306),G1H4(307),G1H4(308),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(306),16,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(7),mass5set(:,6),  & 
G1H4(311),G1H4(312),G1H4(313),G1H4(314),G1H4(315),G1H4(316),4)
  call HG1shiftOLR(G1H4(312),16,4)
  call Hloop_AQ_W(ntryL,G2H4(57),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(9),mass5set(:,1),  & 
G1H4(317),G1H4(318),G1H4(319),G1H4(320),G1H4(321),G1H4(322),4)
  call HG1shiftOLR(G1H4(318),16,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(9),mass5set(:,5),  & 
G1H4(323),G1H4(324),G1H4(325),G1H4(326),G1H4(327),G1H4(328),4)
  call HG1shiftOLR(G1H4(324),16,4)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(9),mass5set(:,2),  & 
G1H4(329),G1H4(330),G1H4(331),G1H4(332),G1H4(333),G1H4(334),4)
  call HG1shiftOLR(G1H4(330),16,4)
  call Hotf_5pt_reduction(G2H4(61),RedSet_5(9),mass5set(:,6),  & 
G1H4(335),G1H4(336),G1H4(337),G1H4(338),G1H4(339),G1H4(340),4)
  call HG1shiftOLR(G1H4(336),16,4)
  call Hloop_QA_W(ntryL,G2H4(62),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(11),mass5set(:,1),  & 
G1H4(341),G1H4(342),G1H4(343),G1H4(344),G1H4(345),G1H4(346),4)
  call HG1shiftOLR(G1H4(342),16,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(11),mass5set(:,2),  & 
G1H4(347),G1H4(348),G1H4(349),G1H4(350),G1H4(351),G1H4(352),4)
  call HG1shiftOLR(G1H4(348),16,4)
  call Hotf_5pt_reduction(G2H4(65),RedSet_5(11),mass5set(:,5),  & 
G1H4(353),G1H4(354),G1H4(355),G1H4(356),G1H4(357),G1H4(358),4)
  call HG1shiftOLR(G1H4(354),16,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(11),mass5set(:,6),  & 
G1H4(359),G1H4(360),G1H4(361),G1H4(362),G1H4(363),G1H4(364),4)
  call HG1shiftOLR(G1H4(360),16,4)
  call Hloop_AQ_W(ntryL,G2H4(67),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(13),mass5set(:,1),  & 
G1H4(365),G1H4(366),G1H4(367),G1H4(368),G1H4(369),G1H4(370),4)
  call HG1shiftOLR(G1H4(366),16,4)
  call Hotf_5pt_reduction(G2H4(69),RedSet_5(13),mass5set(:,5),  & 
G1H4(371),G1H4(372),G1H4(373),G1H4(374),G1H4(375),G1H4(376),4)
  call HG1shiftOLR(G1H4(372),16,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(13),mass5set(:,2),  & 
G1H4(377),G1H4(378),G1H4(379),G1H4(380),G1H4(381),G1H4(382),4)
  call HG1shiftOLR(G1H4(378),16,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(13),mass5set(:,6),  & 
G1H4(383),G1H4(384),G1H4(385),G1H4(386),G1H4(387),G1H4(388),4)
  call HG1shiftOLR(G1H4(384),16,4)
  call Hloop_QA_W(ntryL,G2H4(72),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(73),ex3(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(76),ex3(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_Z(ntryL,G2H4(77),ex3(:),G2H2(11),ngZl,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_Z(ntryL,G2H4(80),ex3(:),G2H2(12),ngZl,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_V(ntryL,G2H4(81),ex3(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(84),ex3(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_Z(ntryL,G2H4(85),ex3(:),G2H2(15),ngZl,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_Z(ntryL,G2H4(88),ex3(:),G2H2(16),ngZl,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(89),ex4(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(92),ex4(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_Z(ntryL,G2H4(93),ex4(:),G2H2(19),ngZl,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_Z(ntryL,G2H4(96),ex4(:),G2H2(20),ngZl,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_V(ntryL,G2H4(97),ex4(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_V(ntryL,G2H4(100),ex4(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_Z(ntryL,G2H4(101),ex4(:),G2H2(23),ngZl,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_Z(ntryL,G2H4(104),ex4(:),G2H2(24),ngZl,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(105),ex3(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(108),ex3(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_Z(ntryL,G2H4(109),ex3(:),G2H2(27),ngZl,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_Z(ntryL,G2H4(112),ex3(:),G2H2(28),ngZl,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G2H4(113),ex3(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_V(ntryL,G2H4(116),ex3(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_Z(ntryL,G2H4(117),ex3(:),G2H2(31),ngZl,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_Z(ntryL,G2H4(120),ex3(:),G2H2(32),ngZl,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QA_V(ntryL,G2H4(121),ex4(:),G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_V(ntryL,G2H4(124),ex4(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QA_Z(ntryL,G2H4(125),ex4(:),G2H2(35),ngZl,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_Z(ntryL,G2H4(128),ex4(:),G2H2(36),ngZl,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QA_V(ntryL,G2H4(129),ex4(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_V(ntryL,G2H4(132),ex4(:),G2H2(38),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QA_Z(ntryL,G2H4(133),ex4(:),G2H2(39),ngZl,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QA_Z(ntryL,G2H4(136),ex4(:),G2H2(40),ngZl,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_AQ_W(ntryL,G2H4(137),ex2(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_W(ntryL,G2H4(140),ex2(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_QA_W(ntryL,G2H4(141),ex4(:),G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_QA_W(ntryL,G2H4(144),ex4(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AQ_W(ntryL,G2H4(145),ex2(:),G2H2(45),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_W(ntryL,G2H4(148),ex2(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_QA_W(ntryL,G2H4(149),ex3(:),G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_QA_W(ntryL,G2H4(152),ex3(:),G2H2(48),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_W(ntryL,G2H4(153),ex1(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AQ_W(ntryL,G2H4(156),ex1(:),G2H2(50),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_AQ_V(ntryL,G2H4(157),ex1(:),G2H2(51),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_V(ntryL,G2H4(160),ex1(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AQ_V(ntryL,G2H4(161),ex1(:),G2H2(53),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_AQ_V(ntryL,G2H4(164),ex1(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AQ_Z(ntryL,G2H4(165),ex1(:),G2H2(55),ngZl,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_AQ_Z(ntryL,G2H4(168),ex1(:),G2H2(56),ngZl,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AQ_Z(ntryL,G2H4(169),ex1(:),G2H2(57),ngZl,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_AQ_Z(ntryL,G2H4(172),ex1(:),G2H2(58),ngZl,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hotf_5pt_reduction(G2H4(173),RedSet_5(8),mass5set(:,4),  & 
G1H4(389),G1H4(390),G1H4(391),G1H4(392),G1H4(393),G1H4(394),4)
  call HG1shiftOLR(G1H4(390),4,4)
  call Hotf_5pt_reduction(G2H4(175),RedSet_5(23),mass5set(:,3),  & 
G1H4(395),G1H4(396),G1H4(397),G1H4(398),G1H4(399),G1H4(400),4)
  call HG1shiftOLR(G1H4(396),4,4)
  call Hloop_QA_W(ntryL,G2H4(176),ex4(:),G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_QA_W(ntryL,G2H4(179),ex4(:),G2H2(60),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_AQ_V(ntryL,G2H4(180),ex2(:),G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_AQ_V(ntryL,G2H4(183),ex2(:),G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_AQ_Z(ntryL,G2H4(184),ex2(:),G2H2(63),ngZl,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_AQ_Z(ntryL,G2H4(187),ex2(:),G2H2(64),ngZl,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_AQ_V(ntryL,G2H4(188),ex2(:),G2H2(65),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_AQ_V(ntryL,G2H4(191),ex2(:),G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_AQ_Z(ntryL,G2H4(192),ex2(:),G2H2(67),ngZl,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_AQ_Z(ntryL,G2H4(195),ex2(:),G2H2(68),ngZl,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hotf_5pt_reduction(G2H4(196),RedSet_5(10),mass5set(:,4),  & 
G1H4(401),G1H4(402),G1H4(403),G1H4(404),G1H4(405),G1H4(406),4)
  call HG1shiftOLR(G1H4(402),8,4)
  call Hotf_5pt_reduction(G2H4(198),RedSet_5(24),mass5set(:,3),  & 
G1H4(407),G1H4(408),G1H4(409),G1H4(410),G1H4(411),G1H4(412),4)
  call HG1shiftOLR(G1H4(408),8,4)
  call Hloop_AQ_W(ntryL,G2H4(199),ex1(:),G2H2(69),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_AQ_W(ntryL,G2H4(202),ex1(:),G2H2(70),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_AQ_V(ntryL,G2H4(203),ex1(:),G2H2(71),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_AQ_V(ntryL,G2H4(206),ex1(:),G2H2(72),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_AQ_V(ntryL,G2H4(207),ex1(:),G2H2(73),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_AQ_V(ntryL,G2H4(210),ex1(:),G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_AQ_Z(ntryL,G2H4(211),ex1(:),G2H2(75),ngZl,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_AQ_Z(ntryL,G2H4(214),ex1(:),G2H2(76),ngZl,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_AQ_Z(ntryL,G2H4(215),ex1(:),G2H2(77),ngZl,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_AQ_Z(ntryL,G2H4(218),ex1(:),G2H2(78),ngZl,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hotf_5pt_reduction(G2H4(219),RedSet_5(12),mass5set(:,4),  & 
G1H4(413),G1H4(414),G1H4(415),G1H4(416),G1H4(417),G1H4(418),4)
  call HG1shiftOLR(G1H4(414),8,4)
  call Hotf_5pt_reduction(G2H4(221),RedSet_5(25),mass5set(:,3),  & 
G1H4(419),G1H4(420),G1H4(421),G1H4(422),G1H4(423),G1H4(424),4)
  call HG1shiftOLR(G1H4(420),8,4)
  call Hloop_QA_W(ntryL,G2H4(222),ex3(:),G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_QA_W(ntryL,G2H4(225),ex3(:),G2H2(80),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_AQ_V(ntryL,G2H4(226),ex2(:),G2H2(81),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_AQ_V(ntryL,G2H4(229),ex2(:),G2H2(82),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_AQ_Z(ntryL,G2H4(230),ex2(:),G2H2(83),ngZl,m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_AQ_Z(ntryL,G2H4(233),ex2(:),G2H2(84),ngZl,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_AQ_V(ntryL,G2H4(234),ex2(:),G2H2(85),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_AQ_V(ntryL,G2H4(237),ex2(:),G2H2(86),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_AQ_Z(ntryL,G2H4(238),ex2(:),G2H2(87),ngZl,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_AQ_Z(ntryL,G2H4(241),ex2(:),G2H2(88),ngZl,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hotf_5pt_reduction(G2H4(242),RedSet_5(14),mass5set(:,4),  & 
G1H4(425),G1H4(426),G1H4(427),G1H4(428),G1H4(429),G1H4(430),4)
  call HG1shiftOLR(G1H4(426),4,4)
  call Hotf_5pt_reduction(G2H4(244),RedSet_5(26),mass5set(:,3),  & 
G1H4(431),G1H4(432),G1H4(433),G1H4(434),G1H4(435),G1H4(436),4)
  call HG1shiftOLR(G1H4(432),4,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(395),[G1H4(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(407),[G1H4(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(419),[G1H4(418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(431),[G1H4(430)])
  call Hloop_VQ_A(ntryL,G1H4(5),ex2(:),G1H2(1),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(89),n2h2(1))
call HGT_OLR(G1H4(6),1,1,4)
call HGT_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(6),-16,0,G2H4(1),n2h4(129))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(90),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_VQ_A(ntryL,G1H4(10),ex2(:),G1H2(1),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(91),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(11),ex2(:),G1H2(1),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(92),n2h2(3))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(12),-16,0,G2H4(2),n2h4(130))
  call Hloop_AV_Q(ntryL,G2H4(2),ex5(:),G2H2(93),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_VQ_A(ntryL,G1H4(16),ex2(:),G1H2(1),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(94),n2h2(4))
  call Hloop_ZQ_A(ntryL,G1H4(17),ex2(:),G1H2(1),ngZl,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(95),n2h2(5))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(18),-16,0,G2H4(3),n2h4(131))
  call Hloop_AV_Q(ntryL,G2H4(3),ex5(:),G2H2(96),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_ZQ_A(ntryL,G1H4(22),ex2(:),G1H2(1),ngZl,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(97),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(23),ex2(:),G1H2(1),ngZl,m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(98),n2h2(7))
call HGT_OLR(G1H4(24),1,1,4)
call HGT_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(24),-16,0,G2H4(4),n2h4(132))
  call Hloop_AV_Q(ntryL,G2H4(4),ex5(:),G2H2(99),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_ZQ_A(ntryL,G1H4(28),ex2(:),G1H2(1),ngZl,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(100),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(29),ex4(:),G1H2(1),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(101),n2h2(9))
call HGT_OLR(G1H4(30),1,1,4)
call HGT_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(30),-16,0,G2H4(5),n2h4(133))
  call Hloop_QV_A(ntryL,G2H4(5),ex5(:),G2H2(102),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_VA_Q(ntryL,G1H4(34),ex4(:),G1H2(1),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(103),n2h2(10))
  call Hloop_ZA_Q(ntryL,G1H4(35),ex4(:),G1H2(1),ngZl,m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(104),n2h2(11))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(36),-16,0,G2H4(6),n2h4(134))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(105),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_ZA_Q(ntryL,G1H4(40),ex4(:),G1H2(1),ngZl,m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(106),n2h2(12))
  call Hloop_VA_Q(ntryL,G1H4(41),ex4(:),G1H2(1),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(107),n2h2(13))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(42),-16,0,G2H4(7),n2h4(135))
  call Hloop_QV_A(ntryL,G2H4(7),ex5(:),G2H2(108),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_VA_Q(ntryL,G1H4(46),ex4(:),G1H2(1),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(109),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(47),ex4(:),G1H2(1),ngZl,m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(110),n2h2(15))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(48),-16,0,G2H4(8),n2h4(136))
  call Hloop_QV_A(ntryL,G2H4(8),ex5(:),G2H2(111),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_ZA_Q(ntryL,G1H4(52),ex4(:),G1H2(1),ngZl,m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(112),n2h2(16))
  call Hloop_VQ_A(ntryL,G1H4(53),ex2(:),G1H2(1),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(113),n2h2(17))
call HGT_OLR(G1H4(54),1,1,4)
call HGT_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(54),-16,0,G2H4(9),n2h4(137))
  call Hloop_AV_Q(ntryL,G2H4(9),ex5(:),G2H2(114),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_VQ_A(ntryL,G1H4(58),ex2(:),G1H2(1),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(115),n2h2(18))
  call Hloop_VQ_A(ntryL,G1H4(59),ex2(:),G1H2(1),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(116),n2h2(19))
call HGT_OLR(G1H4(60),1,1,4)
call HGT_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(60),-16,0,G2H4(10),n2h4(138))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(117),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_VQ_A(ntryL,G1H4(64),ex2(:),G1H2(1),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(118),n2h2(20))
  call Hloop_ZQ_A(ntryL,G1H4(65),ex2(:),G1H2(1),ngZl,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(119),n2h2(21))
call HGT_OLR(G1H4(66),1,1,4)
call HGT_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(66),-16,0,G2H4(11),n2h4(139))
  call Hloop_AV_Q(ntryL,G2H4(11),ex5(:),G2H2(120),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_ZQ_A(ntryL,G1H4(70),ex2(:),G1H2(1),ngZl,m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(121),n2h2(22))
  call Hloop_ZQ_A(ntryL,G1H4(71),ex2(:),G1H2(1),ngZl,m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(122),n2h2(23))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(72),-16,0,G2H4(12),n2h4(140))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(123),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_ZQ_A(ntryL,G1H4(76),ex2(:),G1H2(1),ngZl,m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(124),n2h2(24))
  call Hloop_VA_Q(ntryL,G1H4(77),ex3(:),G1H2(1),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(125),n2h2(25))
call HGT_OLR(G1H4(78),1,1,4)
call HGT_invQ_OLR(G1H4(78),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(78),-16,0,G2H4(13),n2h4(141))
  call Hloop_QV_A(ntryL,G2H4(13),ex5(:),G2H2(126),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_VA_Q(ntryL,G1H4(82),ex3(:),G1H2(1),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(127),n2h2(26))
  call Hloop_ZA_Q(ntryL,G1H4(83),ex3(:),G1H2(1),ngZl,m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(128),n2h2(27))
call HGT_OLR(G1H4(84),1,1,4)
call HGT_invQ_OLR(G1H4(84),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(84),-16,0,G2H4(14),n2h4(142))
  call Hloop_QV_A(ntryL,G2H4(14),ex5(:),G2H2(129),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_ZA_Q(ntryL,G1H4(88),ex3(:),G1H2(1),ngZl,m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(130),n2h2(28))
  call Hloop_VA_Q(ntryL,G1H4(89),ex3(:),G1H2(1),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(131),n2h2(29))
call HGT_OLR(G1H4(90),1,1,4)
call HGT_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(90),-16,0,G2H4(15),n2h4(143))
  call Hloop_QV_A(ntryL,G2H4(15),ex5(:),G2H2(132),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_VA_Q(ntryL,G1H4(94),ex3(:),G1H2(1),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(133),n2h2(30))
  call Hloop_ZA_Q(ntryL,G1H4(95),ex3(:),G1H2(1),ngZl,m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(134),n2h2(31))
call HGT_OLR(G1H4(96),1,1,4)
call HGT_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(96),-16,0,G2H4(16),n2h4(144))
  call Hloop_QV_A(ntryL,G2H4(16),ex5(:),G2H2(135),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_ZA_Q(ntryL,G1H4(100),ex3(:),G1H2(1),ngZl,m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(136),n2h2(32))
  call Hloop_VQ_A(ntryL,G1H4(101),ex1(:),G1H2(1),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(137),n2h2(33))
call HGT_OLR(G1H4(102),1,1,4)
call HGT_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(102),-16,0,G2H4(17),n2h4(145))
  call Hloop_AV_Q(ntryL,G2H4(17),ex5(:),G2H2(138),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_VQ_A(ntryL,G1H4(106),ex1(:),G1H2(1),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(139),n2h2(34))
  call Hloop_VQ_A(ntryL,G1H4(107),ex1(:),G1H2(1),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(140),n2h2(35))
call HGT_OLR(G1H4(108),1,1,4)
call HGT_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(108),-16,0,G2H4(18),n2h4(146))
  call Hloop_AV_Q(ntryL,G2H4(18),ex5(:),G2H2(141),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_VQ_A(ntryL,G1H4(112),ex1(:),G1H2(1),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(142),n2h2(36))
  call Hloop_ZQ_A(ntryL,G1H4(113),ex1(:),G1H2(1),ngZl,m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(143),n2h2(37))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(114),-16,0,G2H4(19),n2h4(147))
  call Hloop_AV_Q(ntryL,G2H4(19),ex5(:),G2H2(144),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_ZQ_A(ntryL,G1H4(118),ex1(:),G1H2(1),ngZl,m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(145),n2h2(38))
  call Hloop_ZQ_A(ntryL,G1H4(119),ex1(:),G1H2(1),ngZl,m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(146),n2h2(39))
call HGT_OLR(G1H4(120),1,1,4)
call HGT_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(120),-16,0,G2H4(20),n2h4(148))
  call Hloop_AV_Q(ntryL,G2H4(20),ex5(:),G2H2(147),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_ZQ_A(ntryL,G1H4(124),ex1(:),G1H2(1),ngZl,m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(148),n2h2(40))
  call Hloop_VQ_A(ntryL,G1H4(125),ex1(:),G1H2(1),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(149),n2h2(41))
call HGT_OLR(G1H4(126),1,1,4)
call HGT_invQ_OLR(G1H4(126),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(126),-16,0,G2H4(21),n2h4(149))
  call Hloop_AV_Q(ntryL,G2H4(21),ex5(:),G2H2(150),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_VQ_A(ntryL,G1H4(130),ex1(:),G1H2(1),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(151),n2h2(42))
  call Hloop_VQ_A(ntryL,G1H4(131),ex1(:),G1H2(1),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(152),n2h2(43))
call HGT_OLR(G1H4(132),1,1,4)
call HGT_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(132),-16,0,G2H4(22),n2h4(150))
  call Hloop_AV_Q(ntryL,G2H4(22),ex5(:),G2H2(153),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_VQ_A(ntryL,G1H4(136),ex1(:),G1H2(1),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(154),n2h2(44))
  call Hloop_ZQ_A(ntryL,G1H4(137),ex1(:),G1H2(1),ngZl,m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(155),n2h2(45))
call HGT_OLR(G1H4(138),1,1,4)
call HGT_invQ_OLR(G1H4(138),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(138),-16,0,G2H4(23),n2h4(151))
  call Hloop_AV_Q(ntryL,G2H4(23),ex5(:),G2H2(156),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_ZQ_A(ntryL,G1H4(142),ex1(:),G1H2(1),ngZl,m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(157),n2h2(46))
  call Hloop_ZQ_A(ntryL,G1H4(143),ex1(:),G1H2(1),ngZl,m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(158),n2h2(47))
call HGT_OLR(G1H4(144),1,1,4)
call HGT_invQ_OLR(G1H4(144),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(144),-16,0,G2H4(24),n2h4(152))
  call Hloop_AV_Q(ntryL,G2H4(24),ex5(:),G2H2(159),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_ZQ_A(ntryL,G1H4(148),ex1(:),G1H2(1),ngZl,m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(160),n2h2(48))
  call Hloop_VA_Q(ntryL,G1H4(149),ex4(:),G1H2(1),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(161),n2h2(49))
call HGT_OLR(G1H4(150),1,1,4)
call HGT_invQ_OLR(G1H4(150),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(150),-16,0,G2H4(25),n2h4(153))
  call Hloop_QV_A(ntryL,G2H4(25),ex5(:),G2H2(162),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_VA_Q(ntryL,G1H4(154),ex4(:),G1H2(1),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(163),n2h2(50))
  call Hloop_ZA_Q(ntryL,G1H4(155),ex4(:),G1H2(1),ngZl,m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(164),n2h2(51))
call HGT_OLR(G1H4(156),1,1,4)
call HGT_invQ_OLR(G1H4(156),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(156),-16,0,G2H4(26),n2h4(154))
  call Hloop_QV_A(ntryL,G2H4(26),ex5(:),G2H2(165),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_ZA_Q(ntryL,G1H4(160),ex4(:),G1H2(1),ngZl,m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(166),n2h2(52))
  call Hloop_VA_Q(ntryL,G1H4(161),ex4(:),G1H2(1),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(167),n2h2(53))
call HGT_OLR(G1H4(162),1,1,4)
call HGT_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(162),-16,0,G2H4(27),n2h4(155))
  call Hloop_QV_A(ntryL,G2H4(27),ex5(:),G2H2(168),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_VA_Q(ntryL,G1H4(166),ex4(:),G1H2(1),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(169),n2h2(54))
  call Hloop_ZA_Q(ntryL,G1H4(167),ex4(:),G1H2(1),ngZl,m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(170),n2h2(55))
call HGT_OLR(G1H4(168),1,1,4)
call HGT_invQ_OLR(G1H4(168),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(168),-16,0,G2H4(28),n2h4(156))
  call Hloop_QV_A(ntryL,G2H4(28),ex5(:),G2H2(171),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_ZA_Q(ntryL,G1H4(172),ex4(:),G1H2(1),ngZl,m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(172),n2h2(56))
  call Hloop_VA_Q(ntryL,G1H4(173),ex3(:),G1H2(1),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(173),n2h2(57))
call HGT_OLR(G1H4(174),1,1,4)
call HGT_invQ_OLR(G1H4(174),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(174),-16,0,G2H4(29),n2h4(157))
  call Hloop_QV_A(ntryL,G2H4(29),ex5(:),G2H2(174),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_VA_Q(ntryL,G1H4(178),ex3(:),G1H2(1),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(175),n2h2(58))
  call Hloop_ZA_Q(ntryL,G1H4(179),ex3(:),G1H2(1),ngZl,m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(176),n2h2(59))
call HGT_OLR(G1H4(180),1,1,4)
call HGT_invQ_OLR(G1H4(180),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(180),-16,0,G2H4(30),n2h4(158))
  call Hloop_QV_A(ntryL,G2H4(30),ex5(:),G2H2(177),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_ZA_Q(ntryL,G1H4(184),ex3(:),G1H2(1),ngZl,m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(178),n2h2(60))
  call Hloop_VA_Q(ntryL,G1H4(185),ex3(:),G1H2(1),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(179),n2h2(61))
call HGT_OLR(G1H4(186),1,1,4)
call HGT_invQ_OLR(G1H4(186),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(186),-16,0,G2H4(31),n2h4(159))
  call Hloop_QV_A(ntryL,G2H4(31),ex5(:),G2H2(180),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_VA_Q(ntryL,G1H4(190),ex3(:),G1H2(1),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(181),n2h2(62))
  call Hloop_ZA_Q(ntryL,G1H4(191),ex3(:),G1H2(1),ngZl,m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(182),n2h2(63))
call HGT_OLR(G1H4(192),1,1,4)
call HGT_invQ_OLR(G1H4(192),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(192),-16,0,G2H4(32),n2h4(160))
  call Hloop_QV_A(ntryL,G2H4(32),ex5(:),G2H2(183),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_ZA_Q(ntryL,G1H4(196),ex3(:),G1H2(1),ngZl,m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(184),n2h2(64))
  call Hloop_VQ_A(ntryL,G1H4(197),ex2(:),G1H2(1),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(185),n2h2(65))
call HGT_OLR(G1H4(198),1,1,4)
call HGT_invQ_OLR(G1H4(198),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(198),-16,0,G2H4(33),n2h4(161))
  call Hloop_AV_Q(ntryL,G2H4(33),ex5(:),G2H2(186),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_VQ_A(ntryL,G1H4(202),ex2(:),G1H2(1),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(187),n2h2(66))
  call Hloop_ZQ_A(ntryL,G1H4(203),ex2(:),G1H2(1),ngZl,m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(188),n2h2(67))
call HGT_OLR(G1H4(204),1,1,4)
call HGT_invQ_OLR(G1H4(204),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(204),-16,0,G2H4(34),n2h4(162))
  call Hloop_AV_Q(ntryL,G2H4(34),ex5(:),G2H2(189),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_ZQ_A(ntryL,G1H4(208),ex2(:),G1H2(1),ngZl,m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(190),n2h2(68))
  call Hloop_VQ_A(ntryL,G1H4(209),ex2(:),G1H2(1),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(191),n2h2(69))
call HGT_OLR(G1H4(210),1,1,4)
call HGT_invQ_OLR(G1H4(210),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(210),-16,0,G2H4(35),n2h4(163))
  call Hloop_AV_Q(ntryL,G2H4(35),ex5(:),G2H2(192),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_VQ_A(ntryL,G1H4(214),ex2(:),G1H2(1),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(193),n2h2(70))
  call Hloop_ZQ_A(ntryL,G1H4(215),ex2(:),G1H2(1),ngZl,m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(194),n2h2(71))
call HGT_OLR(G1H4(216),1,1,4)
call HGT_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(216),-16,0,G2H4(36),n2h4(164))
  call Hloop_AV_Q(ntryL,G2H4(36),ex5(:),G2H2(195),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_ZQ_A(ntryL,G1H4(220),ex2(:),G1H2(1),ngZl,m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(196),n2h2(72))
  call Hloop_VA_Q(ntryL,G1H4(221),ex4(:),G1H2(1),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(197),n2h2(73))
call HGT_OLR(G1H4(222),1,1,4)
call HGT_invQ_OLR(G1H4(222),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(222),-16,0,G2H4(37),n2h4(165))
  call Hloop_QV_A(ntryL,G2H4(37),ex5(:),G2H2(198),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_VA_Q(ntryL,G1H4(226),ex4(:),G1H2(1),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(199),n2h2(74))
  call Hloop_VA_Q(ntryL,G1H4(227),ex4(:),G1H2(1),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(200),n2h2(75))
call HGT_OLR(G1H4(228),1,1,4)
call HGT_invQ_OLR(G1H4(228),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(228),-16,0,G2H4(38),n2h4(166))
  call Hloop_QV_A(ntryL,G2H4(38),ex5(:),G2H2(201),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_VA_Q(ntryL,G1H4(232),ex4(:),G1H2(1),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(202),n2h2(76))
  call Hloop_ZA_Q(ntryL,G1H4(233),ex4(:),G1H2(1),ngZl,m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(203),n2h2(77))
call HGT_OLR(G1H4(234),1,1,4)
call HGT_invQ_OLR(G1H4(234),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(234),-16,0,G2H4(39),n2h4(167))
  call Hloop_QV_A(ntryL,G2H4(39),ex5(:),G2H2(204),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_ZA_Q(ntryL,G1H4(238),ex4(:),G1H2(1),ngZl,m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(205),n2h2(78))
  call Hloop_ZA_Q(ntryL,G1H4(239),ex4(:),G1H2(1),ngZl,m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(206),n2h2(79))
call HGT_OLR(G1H4(240),1,1,4)
call HGT_invQ_OLR(G1H4(240),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(240),-16,0,G2H4(40),n2h4(168))
  call Hloop_QV_A(ntryL,G2H4(40),ex5(:),G2H2(207),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_ZA_Q(ntryL,G1H4(244),ex4(:),G1H2(1),ngZl,m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(208),n2h2(80))
  call Hloop_VQ_A(ntryL,G1H4(245),ex2(:),G1H2(1),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(209),n2h2(81))
call HGT_OLR(G1H4(246),1,1,4)
call HGT_invQ_OLR(G1H4(246),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(246),-16,0,G2H4(41),n2h4(169))
  call Hloop_AV_Q(ntryL,G2H4(41),ex5(:),G2H2(210),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_VQ_A(ntryL,G1H4(250),ex2(:),G1H2(1),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(211),n2h2(82))
  call Hloop_ZQ_A(ntryL,G1H4(251),ex2(:),G1H2(1),ngZl,m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(212),n2h2(83))
call HGT_OLR(G1H4(252),1,1,4)
call HGT_invQ_OLR(G1H4(252),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(252),-16,0,G2H4(42),n2h4(170))
  call Hloop_AV_Q(ntryL,G2H4(42),ex5(:),G2H2(213),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_ZQ_A(ntryL,G1H4(256),ex2(:),G1H2(1),ngZl,m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(214),n2h2(84))
  call Hloop_VQ_A(ntryL,G1H4(257),ex2(:),G1H2(1),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(215),n2h2(85))
call HGT_OLR(G1H4(258),1,1,4)
call HGT_invQ_OLR(G1H4(258),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(258),-16,0,G2H4(43),n2h4(171))
  call Hloop_AV_Q(ntryL,G2H4(43),ex5(:),G2H2(216),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_VQ_A(ntryL,G1H4(262),ex2(:),G1H2(1),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(217),n2h2(86))
  call Hloop_ZQ_A(ntryL,G1H4(263),ex2(:),G1H2(1),ngZl,m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(218),n2h2(87))
call HGT_OLR(G1H4(264),1,1,4)
call HGT_invQ_OLR(G1H4(264),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(264),-16,0,G2H4(44),n2h4(172))
  call Hloop_AV_Q(ntryL,G2H4(44),ex5(:),G2H2(219),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_ZQ_A(ntryL,G1H4(268),ex2(:),G1H2(1),ngZl,m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(220),n2h2(88))
  call Hloop_VA_Q(ntryL,G1H4(269),ex3(:),G1H2(1),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(221),n2h2(89))
call HGT_OLR(G1H4(270),1,1,4)
call HGT_invQ_OLR(G1H4(270),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(270),-16,0,G2H4(45),n2h4(173))
  call Hloop_QV_A(ntryL,G2H4(45),ex5(:),G2H2(222),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_VA_Q(ntryL,G1H4(274),ex3(:),G1H2(1),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(223),n2h2(90))
  call Hloop_VA_Q(ntryL,G1H4(275),ex3(:),G1H2(1),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(224),n2h2(91))
call HGT_OLR(G1H4(276),1,1,4)
call HGT_invQ_OLR(G1H4(276),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(276),-16,0,G2H4(46),n2h4(174))
  call Hloop_QV_A(ntryL,G2H4(46),ex5(:),G2H2(225),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_VA_Q(ntryL,G1H4(280),ex3(:),G1H2(1),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(226),n2h2(92))
  call Hloop_ZA_Q(ntryL,G1H4(281),ex3(:),G1H2(1),ngZl,m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(227),n2h2(93))
call HGT_OLR(G1H4(282),1,1,4)
call HGT_invQ_OLR(G1H4(282),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(282),-16,0,G2H4(47),n2h4(175))
  call Hloop_QV_A(ntryL,G2H4(47),ex5(:),G2H2(228),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_ZA_Q(ntryL,G1H4(286),ex3(:),G1H2(1),ngZl,m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(229),n2h2(94))
  call Hloop_ZA_Q(ntryL,G1H4(287),ex3(:),G1H2(1),ngZl,m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(230),n2h2(95))
call HGT_OLR(G1H4(288),1,1,4)
call HGT_invQ_OLR(G1H4(288),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(288),-16,0,G2H4(48),n2h4(176))
  call Hloop_QV_A(ntryL,G2H4(48),ex5(:),G2H2(231),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_ZA_Q(ntryL,G1H4(292),ex3(:),G1H2(1),ngZl,m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(232),n2h2(96))
  call Hloop_VQ_A(ntryL,G1H4(293),ex1(:),G1H2(1),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(233),n2h2(97))
call HGT_OLR(G1H4(294),1,1,4)
call HGT_invQ_OLR(G1H4(294),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(294),-16,0,G2H4(49),n2h4(177))
  call Hloop_AV_Q(ntryL,G2H4(49),ex5(:),G2H2(234),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_VQ_A(ntryL,G1H4(298),ex1(:),G1H2(1),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(235),n2h2(98))
  call Hloop_VQ_A(ntryL,G1H4(299),ex1(:),G1H2(1),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(236),n2h2(99))
call HGT_OLR(G1H4(300),1,1,4)
call HGT_invQ_OLR(G1H4(300),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(300),-16,0,G2H4(50),n2h4(178))
  call Hloop_AV_Q(ntryL,G2H4(50),ex5(:),G2H2(237),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_VQ_A(ntryL,G1H4(304),ex1(:),G1H2(1),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(238),n2h2(100))
  call Hloop_ZQ_A(ntryL,G1H4(305),ex1(:),G1H2(1),ngZl,m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(239),n2h2(101))
call HGT_OLR(G1H4(306),1,1,4)
call HGT_invQ_OLR(G1H4(306),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(306),-16,0,G2H4(51),n2h4(179))
  call Hloop_AV_Q(ntryL,G2H4(51),ex5(:),G2H2(240),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_ZQ_A(ntryL,G1H4(310),ex1(:),G1H2(1),ngZl,m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(241),n2h2(102))
  call Hloop_ZQ_A(ntryL,G1H4(311),ex1(:),G1H2(1),ngZl,m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(242),n2h2(103))
call HGT_OLR(G1H4(312),1,1,4)
call HGT_invQ_OLR(G1H4(312),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(312),-16,0,G2H4(52),n2h4(180))
  call Hloop_AV_Q(ntryL,G2H4(52),ex5(:),G2H2(243),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_ZQ_A(ntryL,G1H4(316),ex1(:),G1H2(1),ngZl,m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(244),n2h2(104))
  call Hloop_VA_Q(ntryL,G1H4(317),ex4(:),G1H2(1),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(245),n2h2(105))
call HGT_OLR(G1H4(318),1,1,4)
call HGT_invQ_OLR(G1H4(318),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(318),-16,0,G2H4(53),n2h4(181))
  call Hloop_QV_A(ntryL,G2H4(53),ex5(:),G2H2(246),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_VA_Q(ntryL,G1H4(322),ex4(:),G1H2(1),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(247),n2h2(106))
  call Hloop_ZA_Q(ntryL,G1H4(323),ex4(:),G1H2(1),ngZl,m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(248),n2h2(107))
call HGT_OLR(G1H4(324),1,1,4)
call HGT_invQ_OLR(G1H4(324),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(324),-16,0,G2H4(54),n2h4(182))
  call Hloop_QV_A(ntryL,G2H4(54),ex5(:),G2H2(249),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_ZA_Q(ntryL,G1H4(328),ex4(:),G1H2(1),ngZl,m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(250),n2h2(108))
  call Hloop_VA_Q(ntryL,G1H4(329),ex4(:),G1H2(1),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(251),n2h2(109))
call HGT_OLR(G1H4(330),1,1,4)
call HGT_invQ_OLR(G1H4(330),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(330),-16,0,G2H4(55),n2h4(183))
  call Hloop_QV_A(ntryL,G2H4(55),ex5(:),G2H2(252),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_VA_Q(ntryL,G1H4(334),ex4(:),G1H2(1),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(253),n2h2(110))
  call Hloop_ZA_Q(ntryL,G1H4(335),ex4(:),G1H2(1),ngZl,m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(254),n2h2(111))
call HGT_OLR(G1H4(336),1,1,4)
call HGT_invQ_OLR(G1H4(336),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(336),-16,0,G2H4(56),n2h4(184))
  call Hloop_QV_A(ntryL,G2H4(56),ex5(:),G2H2(255),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_ZA_Q(ntryL,G1H4(340),ex4(:),G1H2(1),ngZl,m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(256),n2h2(112))
  call Hloop_VQ_A(ntryL,G1H4(341),ex1(:),G1H2(1),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(257),n2h2(113))
call HGT_OLR(G1H4(342),1,1,4)
call HGT_invQ_OLR(G1H4(342),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(342),-16,0,G2H4(57),n2h4(185))
  call Hloop_AV_Q(ntryL,G2H4(57),ex5(:),G2H2(258),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_VQ_A(ntryL,G1H4(346),ex1(:),G1H2(1),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(259),n2h2(114))
  call Hloop_VQ_A(ntryL,G1H4(347),ex1(:),G1H2(1),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(260),n2h2(115))
call HGT_OLR(G1H4(348),1,1,4)
call HGT_invQ_OLR(G1H4(348),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(348),-16,0,G2H4(58),n2h4(186))
  call Hloop_AV_Q(ntryL,G2H4(58),ex5(:),G2H2(261),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_VQ_A(ntryL,G1H4(352),ex1(:),G1H2(1),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(262),n2h2(116))
  call Hloop_ZQ_A(ntryL,G1H4(353),ex1(:),G1H2(1),ngZl,m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(263),n2h2(117))
call HGT_OLR(G1H4(354),1,1,4)
call HGT_invQ_OLR(G1H4(354),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(354),-16,0,G2H4(59),n2h4(187))
  call Hloop_AV_Q(ntryL,G2H4(59),ex5(:),G2H2(264),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_ZQ_A(ntryL,G1H4(358),ex1(:),G1H2(1),ngZl,m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(265),n2h2(118))
  call Hloop_ZQ_A(ntryL,G1H4(359),ex1(:),G1H2(1),ngZl,m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(266),n2h2(119))
call HGT_OLR(G1H4(360),1,1,4)
call HGT_invQ_OLR(G1H4(360),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(360),-16,0,G2H4(60),n2h4(188))
  call Hloop_AV_Q(ntryL,G2H4(60),ex5(:),G2H2(267),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_ZQ_A(ntryL,G1H4(364),ex1(:),G1H2(1),ngZl,m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(268),n2h2(120))
  call Hloop_VA_Q(ntryL,G1H4(365),ex3(:),G1H2(1),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(269),n2h2(121))
call HGT_OLR(G1H4(366),1,1,4)
call HGT_invQ_OLR(G1H4(366),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(366),-16,0,G2H4(61),n2h4(189))
  call Hloop_QV_A(ntryL,G2H4(61),ex5(:),G2H2(270),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_VA_Q(ntryL,G1H4(370),ex3(:),G1H2(1),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(271),n2h2(122))
  call Hloop_ZA_Q(ntryL,G1H4(371),ex3(:),G1H2(1),ngZl,m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(272),n2h2(123))
call HGT_OLR(G1H4(372),1,1,4)
call HGT_invQ_OLR(G1H4(372),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(372),-16,0,G2H4(62),n2h4(190))
  call Hloop_QV_A(ntryL,G2H4(62),ex5(:),G2H2(273),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_ZA_Q(ntryL,G1H4(376),ex3(:),G1H2(1),ngZl,m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(274),n2h2(124))
  call Hloop_VA_Q(ntryL,G1H4(377),ex3(:),G1H2(1),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(275),n2h2(125))
call HGT_OLR(G1H4(378),1,1,4)
call HGT_invQ_OLR(G1H4(378),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(378),-16,0,G2H4(63),n2h4(191))
  call Hloop_QV_A(ntryL,G2H4(63),ex5(:),G2H2(276),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_VA_Q(ntryL,G1H4(382),ex3(:),G1H2(1),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(277),n2h2(126))
  call Hloop_ZA_Q(ntryL,G1H4(383),ex3(:),G1H2(1),ngZl,m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(278),n2h2(127))
call HGT_OLR(G1H4(384),1,1,4)
call HGT_invQ_OLR(G1H4(384),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(384),-16,0,G2H4(64),n2h4(192))
  call Hloop_QV_A(ntryL,G2H4(64),ex5(:),G2H2(279),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_ZA_Q(ntryL,G1H4(388),ex3(:),G1H2(1),ngZl,m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(280),n2h2(128))
  call Hloop_WQ_A(ntryL,G1H4(389),ex1(:),G1H2(1),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(281),n2h2(129))
call HGT_raise_alpha_OLR(G1H4(390),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(390),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(390),ex3(:),G1H2(1),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_WQ_A(ntryL,G1H4(395),ex1(:),G1H2(2),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(2),59,0,G2H2(282),n2h2(130))
call HGT_raise_alpha_OLR(G1H4(396),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(396),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(396),ex3(:),G1H2(2),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_WQ_A(ntryL,G1H4(400),ex1(:),G1H2(3),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(3),59,0,G2H2(283),n2h2(131))
  call Hloop_WQ_A(ntryL,G1H4(401),ex2(:),G1H2(3),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(284),n2h2(132))
call HGT_raise_alpha_OLR(G1H4(402),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(402),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(402),ex4(:),G1H2(3),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_WQ_A(ntryL,G1H4(407),ex2(:),G1H2(4),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_Q_A(ntryL,G1H2(4),55,0,G2H2(285),n2h2(133))
call HGT_raise_alpha_OLR(G1H4(408),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(408),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(408),ex4(:),G1H2(4),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_WQ_A(ntryL,G1H4(412),ex2(:),G1H2(5),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(286),n2h2(134))
  call Hloop_WQ_A(ntryL,G1H4(413),ex1(:),G1H2(5),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(287),n2h2(135))
call HGT_raise_alpha_OLR(G1H4(414),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(414),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(414),ex4(:),G1H2(5),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_WQ_A(ntryL,G1H4(419),ex1(:),G1H2(6),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(288),n2h2(136))
call HGT_raise_alpha_OLR(G1H4(420),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(420),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(420),ex4(:),G1H2(6),m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_WQ_A(ntryL,G1H4(424),ex1(:),G1H2(7),m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(7),55,0,G2H2(289),n2h2(137))
  call Hloop_WQ_A(ntryL,G1H4(425),ex2(:),G1H2(7),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_Q_A(ntryL,G1H2(7),59,0,G2H2(290),n2h2(138))
call HGT_raise_alpha_OLR(G1H4(426),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(426),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(426),ex3(:),G1H2(7),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_WQ_A(ntryL,G1H4(431),ex2(:),G1H2(8),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_Q_A(ntryL,G1H2(8),59,0,G2H2(291),n2h2(139))
call HGT_raise_alpha_OLR(G1H4(432),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(432),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(432),ex3(:),G1H2(8),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_WQ_A(ntryL,G1H4(436),ex2(:),G1H2(9),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_Q_A(ntryL,G1H2(9),59,0,G2H2(292),n2h2(140))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(4),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(5),ex5(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(6),ex5(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(7),ex5(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(8),ex5(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(1),mass5set(:,1),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(10),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(1),mass5set(:,1),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(16),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(1),mass5set(:,2),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(1),mass5set(:,2),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),8,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(1),mass5set(:,1),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),4,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(1),mass5set(:,1),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),4,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(1),mass5set(:,2),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),4,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(1),mass5set(:,2),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),4,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(2),mass5set(:,1),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),8,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(2),mass5set(:,1),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),8,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(2),mass5set(:,2),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(2),mass5set(:,2),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),8,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(2),mass5set(:,1),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(82),4,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(2),mass5set(:,1),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(88),4,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(2),mass5set(:,2),  & 
G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),G1H2(98),2)
  call HG1shiftOLR(G1H2(94),4,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(2),mass5set(:,2),  & 
G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(100),4,2)



end subroutine vamp_1

end module ol_vamp_1_ppllll_ew_eeexexaa_1_/**/REALKIND
