
module ol_colourmatrix_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 3]

  K2(1,:) = [ 3]

  KL(1,:) = [ 3]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND



module ol_forced_parameters_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 64 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(273)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,30), wf8(8,134), wf16(16,53), wf64(64,139)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(209), c(204)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*eQED**4)/3._/**/REALKIND
    f(  2) = CI*eQED**4
    f(  3) = (CI*countertermnorm*eQED**6)/9._/**/REALKIND
    f(  4) = (CI*countertermnorm*eQED**6)/3._/**/REALKIND
    f(  5) = CI*countertermnorm*eQED**6
    f(  6) = (CI*eQED**4*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(  7) = (CI*countertermnorm*eQED**6*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(  8) = (countertermnorm*eQED**6*MB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(  9) = (CI*countertermnorm*eQED**6*MB)/(cw**2*sw)
    f( 10) = (countertermnorm*eQED**6*MB)/(MW*sw*6._/**/REALKIND)
    f( 11) = (countertermnorm*eQED**6*MB)/(MW*sw*2._/**/REALKIND)
    f( 12) = (CI*countertermnorm*eQED**6*EWctHZA*MB)/(2._/**/REALKIND*MW*sw)
    f( 13) = (CI*countertermnorm*eQED**6*EWctHZZ*MB)/(2._/**/REALKIND*MW*sw)
    f( 14) = (eQED**6*integralnorm*SwB)/27._/**/REALKIND
    f( 15) = (eQED**6*integralnorm*SwB)/9._/**/REALKIND
    f( 16) = (eQED**6*integralnorm*SwB)/3._/**/REALKIND
    f( 17) = eQED**6*integralnorm*SwB
    f( 18) = (eQED**6*integralnorm*SwB)/(cw**2*2._/**/REALKIND)
    f( 19) = (eQED**6*integralnorm*MB*SwB)/(cw**2*4._/**/REALKIND)
    f( 20) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw**2*4._/**/REALKIND)
    f( 21) = (eQED**6*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 22) = eQED**6*integralnorm*MW**2*SwB
    f( 23) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 24) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f( 25) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 26) = (eQED**6*integralnorm*SwB)/(sw**6*8._/**/REALKIND)
    f( 27) = (eQED**6*integralnorm*MB*SwB)/(sw**6*8._/**/REALKIND)
    f( 28) = (cw*eQED**6*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f( 29) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 30) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**5*4._/**/REALKIND)
    f( 31) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**5*4._/**/REALKIND)
    f( 32) = (eQED**6*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f( 33) = (eQED**6*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 34) = (eQED**6*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 35) = (eQED**6*integralnorm*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 36) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 37) = (eQED**6*integralnorm*MB*SwB)/(sw**4*12._/**/REALKIND)
    f( 38) = (eQED**6*integralnorm*MB*SwB)/(sw**4*8._/**/REALKIND)
    f( 39) = (eQED**6*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f( 40) = (eQED**6*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f( 41) = (eQED**6*integralnorm*MB*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f( 42) = (eQED**6*integralnorm*MB*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 43) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f( 44) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 45) = (cw**2*eQED**6*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f( 46) = (cw**2*eQED**6*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f( 47) = (eQED**6*integralnorm*MB**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 48) = (3*eQED**6*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 49) = (eQED**6*integralnorm*MT*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 50) = (eQED**6*integralnorm*MB**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 51) = (eQED**6*integralnorm*MB**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 52) = (eQED**6*integralnorm*MB**3*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 53) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f( 54) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 55) = (3*eQED**6*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 56) = (eQED**6*integralnorm*MB**2*MH**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 57) = (3*eQED**6*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 58) = (eQED**6*integralnorm*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 59) = (eQED**6*integralnorm*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 60) = (9*eQED**6*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 61) = (eQED**6*integralnorm*MT*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f( 62) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f( 63) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*8._/**/REALKIND)
    f( 64) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*4._/**/REALKIND)
    f( 65) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f( 66) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f( 67) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f( 68) = (eQED**6*integralnorm*SwB)/(cw*sw**3*4._/**/REALKIND)
    f( 69) = (cw*eQED**6*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f( 70) = (cw*eQED**6*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f( 71) = (cw*eQED**6*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 72) = (cw**3*eQED**6*integralnorm*SwB)/sw**3
    f( 73) = (eQED**6*integralnorm*MB*SwB)/(cw**3*sw**3*12._/**/REALKIND)
    f( 74) = (eQED**6*integralnorm*MB*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f( 75) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**3*8._/**/REALKIND)
    f( 76) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**3*4._/**/REALKIND)
    f( 77) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**3*2._/**/REALKIND)
    f( 78) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*12._/**/REALKIND)
    f( 79) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*6._/**/REALKIND)
    f( 80) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f( 81) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f( 82) = (eQED**6*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f( 83) = (eQED**6*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 84) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f( 85) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 86) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f( 87) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3)
    f( 88) = (eQED**6*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f( 89) = (eQED**6*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f( 90) = (eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 91) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f( 92) = (eQED**6*integralnorm*SwB)/(cw**2*sw**2*12._/**/REALKIND)
    f( 93) = (eQED**6*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f( 94) = (cw**2*eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 95) = (cw**2*eQED**6*integralnorm*SwB)/sw**2
    f( 96) = (eQED**6*integralnorm*MB*SwB)/(sw**2*4._/**/REALKIND)
    f( 97) = (eQED**6*integralnorm*MB*SwB)/(sw**2*2._/**/REALKIND)
    f( 98) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**2*18._/**/REALKIND)
    f( 99) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(100) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(101) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(102) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(103) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(104) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(105) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(106) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(107) = (eQED**6*integralnorm*MB**2*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(108) = (eQED**6*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(109) = (eQED**6*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(110) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(111) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**2*3._/**/REALKIND)
    f(112) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(113) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(114) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(115) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(116) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2)
    f(117) = (eQED**6*integralnorm*SwB)/(cw*sw*6._/**/REALKIND)
    f(118) = (eQED**6*integralnorm*SwB)/(cw*sw*3._/**/REALKIND)
    f(119) = (eQED**6*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(120) = (cw*eQED**6*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(121) = (cw*eQED**6*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(122) = (cw*eQED**6*integralnorm*SwB)/sw
    f(123) = (eQED**6*integralnorm*MB*SwB)/(cw*sw*12._/**/REALKIND)
    f(124) = (eQED**6*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(125) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(126) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(127) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(128) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(129) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw*3._/**/REALKIND)
    f(130) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(131) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(132) = (eQED**6*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(133) = (eQED**6*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(134) = (eQED**6*integralnorm*MW**2*sw*SwB)/cw
    f(135) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(136) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(137) = (eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(138) = (eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(139) = -((eQED**6*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(140) = -((eQED**6*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(141) = -((eQED**6*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW**2*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(142) = -((eQED**6*integralnorm*MB*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**2*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(143) = -((eQED**6*integralnorm*MB*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(144) = (eQED**6*integralnorm*MB*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(145) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(146) = -((eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(147) = -((eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(148) = -((eQED**6*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(149) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(150) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*6._/**/REALKIND))
    f(151) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(152) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*2._/**/REALKIND))
    f(153) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND))
    f(154) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(155) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(156) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*18._/**/REALKIND))
    f(157) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(158) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(159) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(160) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(161) = (eQED**6*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(162) = (eQED**6*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(163) = (eQED**6*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(164) = (eQED**6*integralnorm*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND)
    f(165) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(166) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*2._/**/REALKIND))
    f(167) = -((eQED**6*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(168) = -((eQED**6*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(169) = -((eQED**6*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(170) = (eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(171) = (2*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(172) = (eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(173) = (4*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(174) = (2*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(175) = (8*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(176) = (eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(177) = (4*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(178) = (2*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(179) = eQED**6*integralnorm*SwF
    f(180) = (4*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(181) = 2*eQED**6*integralnorm*SwF
    f(182) = 3*eQED**6*integralnorm*SwF
    f(183) = (eQED**6*integralnorm*MB**3*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(184) = (eQED**6*integralnorm*MB*ML**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(185) = (eQED**6*integralnorm*MB*MT**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(186) = (eQED**6*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(187) = (eQED**6*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(188) = (eQED**6*integralnorm*MB*ML*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(189) = (eQED**6*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(190) = (eQED**6*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(191) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(192) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(193) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(194) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(195) = (2*eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(196) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2)
    f(197) = (3*eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(198) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(199) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(200) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(201) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(202) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(203) = (eQED**6*integralnorm*MB**2*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(204) = (eQED**6*integralnorm*MB**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(205) = (eQED**6*integralnorm*MB*ML*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(206) = (eQED**6*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(207) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(208) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(209) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)

  c = [ f(14), f(15), f(16), f(17), f(18), f(19), f(20), f(21), f(22), f(23), f(24), f(25), f(26), f(27), f(28), f(29), f(30) &
    , f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38), f(39), f(40), f(41), f(42), f(43), f(44), f(45), f(46), f(47), f(48) &
    , f(49), f(50), f(51), f(52), f(53), f(54), f(55), f(56), f(57), f(58), f(59), f(60), f(61), f(62), f(63), f(64), f(65), f(66) &
    , f(67), f(68), f(69), f(70), f(71), f(72), f(73), f(74), f(75), f(76), f(77), f(78), f(79), f(80), f(81), f(82), f(83), f(84) &
    , f(85), f(86), f(87), f(88), f(89), f(90), f(91), f(92), f(93), f(94), f(95), f(96), f(97), f(98), f(99), f(100), f(101) &
    , f(102), f(103), f(104), f(105), f(106), f(107), f(108), f(109), f(110), f(111), f(112), f(113), f(114), f(115), f(116) &
    , f(117), f(118), f(119), f(120), f(121), f(122), f(123), f(124), f(125), f(126), f(127), f(128), f(129), f(130), f(131) &
    , f(132), f(133), f(134), f(135), f(136), f(137), f(138), f(139), f(140), f(141), f(142), f(143), f(144), f(145), f(146) &
    , f(147), f(148), f(149), f(150), f(151), f(152), f(153), f(154), f(155), f(156), f(157), f(158), f(159), f(160), f(161) &
    , f(162), f(163), f(164), f(165), f(166), f(167), f(168), f(169), 3*f(170), 3*f(171), f(172), 3*f(172), 3*f(173), f(174) &
    , 3*f(174), 3*f(175), f(176), 3*f(176), 3*f(177), f(178), 3*f(178), f(179), 3*f(179), 3*f(180), f(181), 3*f(181), f(182) &
    , 3*f(183), f(184), 3*f(185), 3*f(186), 3*f(187), f(188), 3*f(189), 3*f(190), 3*f(191), 3*f(192), 3*f(193), f(194), 3*f(194) &
    , 3*f(195), f(196), 3*f(196), f(197), f(198), f(199), 3*f(200), 3*f(201), 3*f(202), 3*f(203), 3*f(204), f(205), f(206) &
    , 3*f(207), 3*f(208), 3*f(209) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(2) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(3) = 1 /((L(5,48) - MH2)+L(6,48))
  den(6) = 1 /((L(5,12))+L(6,12))
  den(7) = 1 /((L(5,19) - MB2)+L(6,19))
  den(11) = 1 /((L(5,28) - MB2)+L(6,28))
  den(16) = 1 /((L(5,48))+L(6,48))
  den(17) = 1 /((L(5,7))+L(6,7))
  den(20) = 1 /((L(5,48) - MZ2)+L(6,48))
  den(22) = 1 /((L(5,52))+L(6,52))
  den(27) = 1 /((L(5,13))+L(6,13))
  den(30) = 1 /((L(5,49))+L(6,49))
  den(35) = 1 /((L(5,35) - MB2)+L(6,35))
  den(39) = 1 /((L(5,44) - MB2)+L(6,44))
  den(44) = 1 /((L(5,11))+L(6,11))
  den(48) = 1 /((L(5,56))+L(6,56))
  den(55) = 1 /((L(5,50))+L(6,50))
  den(59) = 1 /((L(5,14))+L(6,14))
  den(63) = 1 /((L(5,3))+L(6,3))
  den(75) = 1 /((L(5,60) - MZ2)+L(6,60))
  den(79) = 1 /((L(5,51) - MZ2)+L(6,51))
  den(83) = 1 /((L(5,15) - MH2)+L(6,15))
  den(141) = 1 /((L(5,51) - MH2)+L(6,51))
  den(143) = 1 /((L(5,15))+L(6,15))
  den(145) = 1 /((L(5,15) - MZ2)+L(6,15))
  den(150) = 1 /((L(5,51))+L(6,51))
  den(157) = 1 /((L(5,60) - MH2)+L(6,60))
  den(163) = 1 /((L(5,60))+L(6,60))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(8) = den(1)*den(7)
  den(9) = den(6)*den(8)
  den(10) = den(2)*den(8)
  den(12) = den(6)*den(11)
  den(13) = den(1)*den(12)
  den(14) = den(2)*den(11)
  den(15) = den(1)*den(14)
  den(18) = den(1)*den(17)
  den(19) = den(16)*den(18)
  den(21) = den(18)*den(20)
  den(23) = den(16)*den(22)
  den(24) = den(1)*den(23)
  den(25) = den(20)*den(22)
  den(26) = den(1)*den(25)
  den(28) = den(2)*den(27)
  den(29) = den(20)*den(28)
  den(31) = den(20)*den(30)
  den(32) = den(2)*den(31)
  den(33) = den(1)*den(6)
  den(34) = den(3)*den(33)
  den(36) = den(1)*den(35)
  den(37) = den(6)*den(36)
  den(38) = den(2)*den(36)
  den(40) = den(6)*den(39)
  den(41) = den(1)*den(40)
  den(42) = den(2)*den(39)
  den(43) = den(1)*den(42)
  den(45) = den(1)*den(44)
  den(46) = den(16)*den(45)
  den(47) = den(20)*den(45)
  den(49) = den(16)*den(48)
  den(50) = den(1)*den(49)
  den(51) = den(20)*den(48)
  den(52) = den(1)*den(51)
  den(53) = den(16)*den(28)
  den(54) = den(6)*den(31)
  den(56) = den(20)*den(55)
  den(57) = den(6)*den(56)
  den(58) = den(2)*den(56)
  den(60) = den(2)*den(59)
  den(61) = den(16)*den(60)
  den(62) = den(20)*den(60)
  den(64) = den(7)*den(63)
  den(65) = den(6)*den(64)
  den(66) = den(2)*den(64)
  den(67) = den(12)*den(63)
  den(68) = den(14)*den(63)
  den(69) = den(17)*den(63)
  den(70) = den(16)*den(69)
  den(71) = den(20)*den(69)
  den(72) = den(23)*den(63)
  den(73) = den(25)*den(63)
  den(74) = den(2)*den(3)
  den(76) = den(74)*den(75)
  den(77) = den(1)*den(76)
  den(78) = den(1)*den(3)
  den(80) = den(78)*den(79)
  den(81) = den(6)*den(80)
  den(82) = den(2)*den(80)
  den(84) = den(4)*den(83)
  den(85) = den(3)*den(84)
  den(86) = den(1)**2
  den(87) = den(40)*den(86)
  den(88) = den(42)*den(86)
  den(89) = den(1)*den(63)
  den(90) = den(40)*den(89)
  den(91) = den(42)*den(89)
  den(92) = den(12)*den(86)
  den(93) = den(14)*den(86)
  den(94) = den(12)*den(89)
  den(95) = den(14)*den(89)
  den(96) = den(2)*den(6)
  den(97) = den(36)*den(96)
  den(98) = den(2)**2
  den(99) = den(36)*den(98)
  den(100) = den(6)**2
  den(101) = den(36)*den(100)
  den(102) = den(8)*den(96)
  den(103) = den(8)*den(98)
  den(104) = den(8)*den(100)
  den(105) = den(8)*den(40)
  den(106) = den(8)*den(42)
  den(107) = den(12)*den(36)
  den(108) = den(14)*den(36)
  den(109) = den(49)*den(89)
  den(110) = den(51)*den(89)
  den(111) = den(49)*den(86)
  den(112) = den(51)*den(86)
  den(113) = den(23)*den(89)
  den(114) = den(25)*den(89)
  den(115) = den(23)*den(86)
  den(116) = den(25)*den(86)
  den(117) = den(18)*den(49)
  den(118) = den(18)*den(51)
  den(119) = den(23)*den(45)
  den(120) = den(25)*den(45)
  den(121) = den(16)*den(20)
  den(122) = den(45)*den(121)
  den(123) = den(20)**2
  den(124) = den(45)*den(123)
  den(125) = den(16)**2
  den(126) = den(45)*den(125)
  den(127) = den(18)*den(121)
  den(128) = den(18)*den(123)
  den(129) = den(18)*den(125)
  den(130) = den(28)*den(56)
  den(131) = den(31)*den(60)
  den(132) = den(56)*den(96)
  den(133) = den(56)*den(98)
  den(134) = den(60)*den(123)
  den(135) = den(60)*den(121)
  den(136) = den(31)*den(96)
  den(137) = den(31)*den(98)
  den(138) = den(28)*den(123)
  den(139) = den(28)*den(121)
  den(140) = den(1)*den(20)
  den(142) = den(140)*den(141)
  den(144) = den(18)*den(143)
  den(146) = den(18)*den(145)
  den(147) = den(45)*den(143)
  den(148) = den(45)*den(145)
  den(149) = den(8)*den(141)
  den(151) = den(8)*den(150)
  den(152) = den(8)*den(79)
  den(153) = den(36)*den(141)
  den(154) = den(36)*den(150)
  den(155) = den(36)*den(79)
  den(156) = den(2)*den(20)
  den(158) = den(156)*den(157)
  den(159) = den(28)*den(145)
  den(160) = den(60)*den(145)
  den(161) = den(12)*den(157)
  den(162) = den(14)*den(157)
  den(164) = den(12)*den(163)
  den(165) = den(12)*den(75)
  den(166) = den(14)*den(163)
  den(167) = den(14)*den(75)
  den(168) = den(40)*den(157)
  den(169) = den(42)*den(157)
  den(170) = den(40)*den(163)
  den(171) = den(40)*den(75)
  den(172) = den(42)*den(163)
  den(173) = den(42)*den(75)
  den(174) = den(31)*den(79)
  den(175) = den(56)*den(79)
  den(176) = den(23)*den(163)
  den(177) = den(23)*den(75)
  den(178) = den(25)*den(163)
  den(179) = den(25)*den(75)
  den(180) = den(49)*den(163)
  den(181) = den(51)*den(163)
  den(182) = den(49)*den(75)
  den(183) = den(51)*den(75)
  den(184) = den(1)*den(16)
  den(185) = den(6)*den(16)
  den(186) = den(6)*den(20)
  den(187) = den(2)*den(16)
  den(188) = den(1)*den(3)*den(6)
  den(189) = den(1)*den(6)*den(20)
  den(190) = den(1)*den(2)*den(3)
  den(191) = den(1)*den(2)*den(20)
  den(192) = den(1)*den(6)*den(16)
  den(193) = den(1)*den(2)*den(16)
  den(194) = den(3)*den(18)
  den(195) = den(3)*den(45)
  den(196) = den(3)*den(28)
  den(197) = den(3)*den(60)
  den(198) = den(3)*den(6)
  den(199) = den(1)*den(198)
  den(200) = den(1)*den(186)
  den(201) = den(1)*den(74)
  den(202) = den(1)*den(156)
  den(203) = den(1)*den(185)
  den(204) = den(1)*den(187)
  den(205) = den(6)*den(78)
  den(206) = den(6)*den(140)
  den(207) = den(2)*den(78)
  den(208) = den(2)*den(140)
  den(209) = den(6)*den(184)
  den(210) = den(2)*den(184)
  den(211) = den(16)*den(33)
  den(212) = den(20)*den(33)
  den(213) = den(4)*den(16)
  den(214) = den(4)*den(20)
  den(215) = den(20)*den(84)
  den(216) = den(16)*den(84)
  den(217) = den(6)*den(142)
  den(218) = den(2)*den(142)
  den(219) = den(1)*den(158)
  den(220) = den(6)*den(149)
  den(221) = den(6)*den(152)
  den(222) = den(2)*den(149)
  den(223) = den(2)*den(152)
  den(224) = den(6)*den(151)
  den(225) = den(2)*den(151)
  den(226) = den(6)*den(153)
  den(227) = den(6)*den(155)
  den(228) = den(2)*den(153)
  den(229) = den(2)*den(155)
  den(230) = den(6)*den(154)
  den(231) = den(2)*den(154)
  den(232) = den(1)*den(161)
  den(233) = den(1)*den(165)
  den(234) = den(1)*den(162)
  den(235) = den(1)*den(167)
  den(236) = den(1)*den(164)
  den(237) = den(1)*den(166)
  den(238) = den(1)*den(168)
  den(239) = den(1)*den(171)
  den(240) = den(1)*den(169)
  den(241) = den(1)*den(173)
  den(242) = den(1)*den(170)
  den(243) = den(1)*den(172)
  den(244) = den(3)*den(144)
  den(245) = den(20)*den(144)
  den(246) = den(3)*den(146)
  den(247) = den(20)*den(146)
  den(248) = den(16)*den(144)
  den(249) = den(16)*den(146)
  den(250) = den(3)*den(147)
  den(251) = den(20)*den(147)
  den(252) = den(3)*den(148)
  den(253) = den(20)*den(148)
  den(254) = den(16)*den(147)
  den(255) = den(16)*den(148)
  den(256) = den(1)*den(176)
  den(257) = den(1)*den(177)
  den(258) = den(1)*den(178)
  den(259) = den(1)*den(179)
  den(260) = den(1)*den(180)
  den(261) = den(1)*den(181)
  den(262) = den(1)*den(182)
  den(263) = den(1)*den(183)
  den(264) = den(3)*den(159)
  den(265) = den(20)*den(159)
  den(266) = den(16)*den(159)
  den(267) = den(6)*den(174)
  den(268) = den(2)*den(174)
  den(269) = den(3)*den(160)
  den(270) = den(20)*den(160)
  den(271) = den(16)*den(160)
  den(272) = den(6)*den(175)
  den(273) = den(2)*den(175)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_nmnmxeexbbx_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,139))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppllll_ew_nmnmxeexbbx_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_mu anti-nu_mu e- e+ bottom anti-bottom -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppllll_ew_nmnmxeexbbx_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllll_ew_nmnmxeexbbx_1, only: &
    & external_perm_ppllll_ew_nmnmxeexbbx_1, &
    & external_perm_inv_ppllll_ew_nmnmxeexbbx_1, &
    & extcomb_perm_ppllll_ew_nmnmxeexbbx_1, &
    & average_factor_ppllll_ew_nmnmxeexbbx_1
  use ol_external_ppllll_ew_nmnmxeexbbx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppllll_ew_nmnmxeexbbx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 6 > 3
  integer :: ind_cc_comb(9)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(139)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,139))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, nMB, nMB ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppllll_ew_nmnmxeexbbx_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rMB, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rMB, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_Z(gZn,ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_Z(gZl,ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AQ_S(gH,ntry, ex6(:), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,2), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,4), n3(:,5), t3x4(:,:,4))
  call vert_ZQ_A(gZd,ntry, wf4(:,1), ex5(:), wf8(:,1), n3(:,6), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,4), wf8(:,2), n3(:,7), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 19, MB, 1_intkind1, wf8(:,3), n2(1))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,2), wf8(:,4), n3(:,8), t3x8(:,:,3))
  call vert_VQ_A(ntry, wf4(:,4), ex5(:), wf8(:,5), n3(:,9), t3x8(:,:,4))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,1), wf8(:,6), n3(:,10), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,5), 28, MB, 1_intkind1, wf8(:,7), n2(2))
  call vert_ZQ_A(gZd,ntry, wf4(:,2), ex5(:), wf8(:,8), n3(:,11), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,8), 28, MB, 1_intkind1, wf8(:,9), n2(3))
  call vert_QA_V(ntry, ex5(:), ex6(:), wf4(:,5), n3(:,12), t3x4(:,:,5))
  call vert_ZQ_A(gZl,ntry, wf4(:,1), ex3(:), wf8(:,10), n3(:,13), t3x8(:,:,7))
  call vert_AV_Q(ntry, ex4(:), wf4(:,5), wf8(:,11), n3(:,14), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,10), 7, ZERO, 0_intkind1, wf8(:,12), n2(4))
  call vert_QA_Z(gZd,ntry, ex5(:), ex6(:), wf4(:,6), n3(:,15), t3x4(:,:,6))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,6), wf8(:,13), n3(:,16), t3x8(:,:,9))
  call vert_VQ_A(ntry, wf4(:,5), ex3(:), wf8(:,14), n3(:,17), t3x8(:,:,10))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,1), wf8(:,15), n3(:,18), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,14), 52, ZERO, 0_intkind1, wf8(:,16), n2(5))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), ex3(:), wf8(:,17), n3(:,19), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,17), 52, ZERO, 0_intkind1, wf8(:,18), n2(6))
  call vert_ZQ_A(gZn,ntry, wf4(:,2), ex1(:), wf8(:,19), n3(:,20), t3x8(:,:,13))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,6), wf8(:,20), n3(:,21), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,19), 13, ZERO, 0_intkind1, wf8(:,21), n2(7))
  call vert_ZQ_A(gZn,ntry, wf4(:,6), ex1(:), wf8(:,22), n3(:,22), t3x8(:,:,15))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,2), wf8(:,23), n3(:,23), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,22), 49, ZERO, 0_intkind1, wf8(:,24), n2(8))
  call counter_VV_S(ntry, wf4(:,1), wf4(:,4), wf16(:,2), n3(:,24), t3x16(:,:,2))
  call counter_VV_S(ntry, wf4(:,1), wf4(:,2), wf16(:,3), n3(:,25), t3x16(:,:,3))
  call counter_AV_Q_LR(EWctAbb,ntry, ex6(:), wf4(:,4), wf8(:,25), n3(:,26), t3x8(:,:,17))
  call counter_AZ_Q(EWctVbb,ntry, ex6(:), wf4(:,2), wf8(:,26), n3(:,27), t3x8(:,:,18))
  call counter_AZ_Q(EWctVbb,ntry, ex6(:), wf4(:,1), wf8(:,27), n3(:,28), t3x8(:,:,19))
  call counter_VQ_A_LR(EWctAbb,ntry, wf4(:,4), ex5(:), wf8(:,28), n3(:,29), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,6), 35, MB, 1_intkind1, wf8(:,29), n2(9))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,2), ex5(:), wf8(:,30), n3(:,30), t3x8(:,:,21))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,1), ex5(:), wf8(:,31), n3(:,31), t3x8(:,:,22))
  call prop_A_Q(ntry, wf8(:,2), 44, MB, 1_intkind1, wf8(:,32), n2(10))
  call prop_A_Q(ntry, wf8(:,4), 44, MB, 1_intkind1, wf8(:,33), n2(11))
  call counter_AQ_S(EWctHbb,ntry, ex6(:), ex5(:), wf4(:,7), n3(:,32), t3x4(:,:,7))
  call counter_QA_V_LR(EWctAbb,ntry, ex5(:), ex6(:), wf4(:,8), n3(:,33), t3x4(:,:,8))
  call vert_AV_Q(ntry, ex4(:), wf4(:,8), wf8(:,34), n3(:,34), t3x8(:,:,23))
  call counter_QA_Z(EWctVbb,ntry, ex5(:), ex6(:), wf4(:,9), n3(:,35), t3x4(:,:,9))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,9), wf8(:,35), n3(:,36), t3x8(:,:,24))
  call vert_VQ_A(ntry, wf4(:,8), ex3(:), wf8(:,36), n3(:,37), t3x8(:,:,25))
  call prop_Q_A(ntry, wf8(:,36), 52, ZERO, 0_intkind1, wf8(:,37), n2(12))
  call vert_ZQ_A(gZl,ntry, wf4(:,9), ex3(:), wf8(:,38), n3(:,38), t3x8(:,:,26))
  call prop_Q_A(ntry, wf8(:,38), 52, ZERO, 0_intkind1, wf8(:,39), n2(13))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,5), wf8(:,40), n3(:,39), t3x8(:,:,27))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,6), wf8(:,41), n3(:,40), t3x8(:,:,28))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,1), wf8(:,42), n3(:,41), t3x8(:,:,29))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,5), ex3(:), wf8(:,43), n3(:,42), t3x8(:,:,30))
  call prop_A_Q(ntry, wf8(:,15), 11, ZERO, 0_intkind1, wf8(:,44), n2(14))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,6), ex3(:), wf8(:,45), n3(:,43), t3x8(:,:,31))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,1), ex3(:), wf8(:,46), n3(:,44), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,11), 56, ZERO, 0_intkind1, wf8(:,47), n2(15))
  call prop_A_Q(ntry, wf8(:,13), 56, ZERO, 0_intkind1, wf8(:,48), n2(16))
  call counter_QA_Z(EWctVee,ntry, ex3(:), ex4(:), wf4(:,10), n3(:,45), t3x4(:,:,10))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,10), wf16(:,4), n3(:,46), t3x16(:,:,4))
  call counter_QA_Z(EWctAee,ntry, ex3(:), ex4(:), wf4(:,11), n3(:,47), t3x4(:,:,11))
  call vert_AV_Q(ntry, ex6(:), wf4(:,11), wf8(:,49), n3(:,48), t3x8(:,:,33))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,10), wf8(:,50), n3(:,49), t3x8(:,:,34))
  call vert_VQ_A(ntry, wf4(:,11), ex5(:), wf8(:,51), n3(:,50), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,51), 28, MB, 1_intkind1, wf8(:,52), n2(17))
  call vert_ZQ_A(gZd,ntry, wf4(:,10), ex5(:), wf8(:,53), n3(:,51), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,53), 28, MB, 1_intkind1, wf8(:,54), n2(18))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,9), wf8(:,55), n3(:,52), t3x8(:,:,37))
  call vert_ZQ_A(gZn,ntry, wf4(:,9), ex1(:), wf8(:,56), n3(:,53), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,56), 49, ZERO, 0_intkind1, wf8(:,57), n2(19))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,10), wf8(:,58), n3(:,54), t3x8(:,:,39))
  call vert_ZQ_A(gZn,ntry, wf4(:,10), ex1(:), wf8(:,59), n3(:,55), t3x8(:,:,40))
  call prop_Q_A(ntry, wf8(:,59), 13, ZERO, 0_intkind1, wf8(:,60), n2(20))
  call counter_AZ_Q(EWctAnn,ntry, ex2(:), wf4(:,5), wf8(:,61), n3(:,56), t3x8(:,:,41))
  call counter_AZ_Q(EWctVnn,ntry, ex2(:), wf4(:,6), wf8(:,62), n3(:,57), t3x8(:,:,42))
  call counter_AZ_Q(EWctAnn,ntry, ex2(:), wf4(:,4), wf8(:,63), n3(:,58), t3x8(:,:,43))
  call counter_AZ_Q(EWctVnn,ntry, ex2(:), wf4(:,2), wf8(:,64), n3(:,59), t3x8(:,:,44))
  call counter_ZQ_A(EWctAnn,ntry, wf4(:,4), ex1(:), wf8(:,65), n3(:,60), t3x8(:,:,45))
  call prop_A_Q(ntry, wf8(:,20), 50, ZERO, 0_intkind1, wf8(:,66), n2(21))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,2), ex1(:), wf8(:,67), n3(:,61), t3x8(:,:,46))
  call counter_ZQ_A(EWctAnn,ntry, wf4(:,5), ex1(:), wf8(:,68), n3(:,62), t3x8(:,:,47))
  call prop_A_Q(ntry, wf8(:,23), 14, ZERO, 0_intkind1, wf8(:,69), n2(22))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,6), ex1(:), wf8(:,70), n3(:,63), t3x8(:,:,48))
  call counter_QA_Z(EWctVnn,ntry, ex1(:), ex2(:), wf4(:,12), n3(:,64), t3x4(:,:,12))
  call vert_VV_S(ntry, wf4(:,12), wf4(:,2), wf16(:,5), n3(:,65), t3x16(:,:,5))
  call counter_QA_Z(EWctAnn,ntry, ex1(:), ex2(:), wf4(:,13), n3(:,66), t3x4(:,:,13))
  call vert_VQ_A(ntry, wf4(:,13), ex5(:), wf8(:,71), n3(:,67), t3x8(:,:,49))
  call prop_Q_A(ntry, wf8(:,71), 19, MB, 1_intkind1, wf8(:,72), n2(23))
  call vert_ZQ_A(gZd,ntry, wf4(:,12), ex5(:), wf8(:,73), n3(:,68), t3x8(:,:,50))
  call prop_Q_A(ntry, wf8(:,73), 19, MB, 1_intkind1, wf8(:,74), n2(24))
  call vert_AV_Q(ntry, ex6(:), wf4(:,13), wf8(:,75), n3(:,69), t3x8(:,:,51))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,12), wf8(:,76), n3(:,70), t3x8(:,:,52))
  call vert_VQ_A(ntry, wf4(:,13), ex3(:), wf8(:,77), n3(:,71), t3x8(:,:,53))
  call prop_Q_A(ntry, wf8(:,77), 7, ZERO, 0_intkind1, wf8(:,78), n2(25))
  call vert_ZQ_A(gZl,ntry, wf4(:,12), ex3(:), wf8(:,79), n3(:,72), t3x8(:,:,54))
  call prop_Q_A(ntry, wf8(:,79), 7, ZERO, 0_intkind1, wf8(:,80), n2(26))
  call vert_AV_Q(ntry, ex4(:), wf4(:,13), wf8(:,81), n3(:,73), t3x8(:,:,55))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,12), wf8(:,82), n3(:,74), t3x8(:,:,56))
  call vert_TV_S(ntry, wf4(:,3), 48, wf4(:,2), 12, wf16(:,6), n3(:,75), t3x16(:,:,6))
  call counter_V_S(EWctXZ,ntry, wf4(:,1), 3, wf4(:,14), n2(27))
  call vert_SV_V(ntry, wf4(:,3), wf4(:,2), wf16(:,7), n3(:,76), t3x16(:,:,7))
  call counter_V_V(EWctZZ,ntry, wf4(:,1), 3, wf4(:,15), n2(28))
  call vert_TV_S(ntry, wf4(:,3), 48, wf4(:,1), 3, wf16(:,8), n3(:,77), t3x16(:,:,8))
  call counter_V_S(EWctXA,ntry, wf4(:,4), 12, wf4(:,16), n2(29))
  call counter_V_S(EWctXZ,ntry, wf4(:,2), 12, wf4(:,17), n2(30))
  call vert_SV_V(ntry, wf4(:,3), wf4(:,1), wf16(:,9), n3(:,78), t3x16(:,:,9))
  call counter_V_V(EWctAZ,ntry, wf4(:,4), 12, wf4(:,18), n2(31))
  call counter_V_V(EWctZZ,ntry, wf4(:,2), 12, wf4(:,19), n2(32))
  call counter_S_S(EWctHH,ntry, wf4(:,3), 48, wf4(:,20), n2(33))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,14), wf8(:,83), n3(:,79), t3x8(:,:,57))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 3, wf4(:,21), n2(34))
  call vert_VQ_A(ntry, wf4(:,21), ex5(:), wf8(:,84), n3(:,80), t3x8(:,:,58))
  call vert_ZQ_A(gZd,ntry, wf4(:,15), ex5(:), wf8(:,85), n3(:,81), t3x8(:,:,59))
  call vert_SA_Q(gX,ntry, wf4(:,14), ex6(:), wf8(:,86), n3(:,82), t3x8(:,:,60))
  call vert_AV_Q(ntry, ex6(:), wf4(:,21), wf8(:,87), n3(:,83), t3x8(:,:,61))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,15), wf8(:,88), n3(:,84), t3x8(:,:,62))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,16), wf8(:,89), n3(:,85), t3x8(:,:,63))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,17), wf8(:,90), n3(:,86), t3x8(:,:,64))
  call counter_V_V(EWctAA,ntry, wf4(:,4), 12, wf4(:,22), n2(35))
  call vert_VQ_A(ntry, wf4(:,22), ex5(:), wf8(:,91), n3(:,87), t3x8(:,:,65))
  call vert_ZQ_A(gZd,ntry, wf4(:,18), ex5(:), wf8(:,92), n3(:,88), t3x8(:,:,66))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 12, wf4(:,23), n2(36))
  call vert_VQ_A(ntry, wf4(:,23), ex5(:), wf8(:,93), n3(:,89), t3x8(:,:,67))
  call vert_ZQ_A(gZd,ntry, wf4(:,19), ex5(:), wf8(:,94), n3(:,90), t3x8(:,:,68))
  call vert_SA_Q(gX,ntry, wf4(:,16), ex6(:), wf8(:,95), n3(:,91), t3x8(:,:,69))
  call vert_SA_Q(gX,ntry, wf4(:,17), ex6(:), wf8(:,96), n3(:,92), t3x8(:,:,70))
  call vert_AV_Q(ntry, ex6(:), wf4(:,22), wf8(:,97), n3(:,93), t3x8(:,:,71))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,18), wf8(:,98), n3(:,94), t3x8(:,:,72))
  call vert_AV_Q(ntry, ex6(:), wf4(:,23), wf8(:,99), n3(:,95), t3x8(:,:,73))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,19), wf8(:,100), n3(:,96), t3x8(:,:,74))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,3), 19, wf8(:,101), n2(37))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,7), 28, wf8(:,102), n2(38))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,9), 28, wf8(:,103), n2(39))
  call vert_VQ_A(ntry, wf4(:,21), ex3(:), wf8(:,104), n3(:,97), t3x8(:,:,75))
  call vert_ZQ_A(gZl,ntry, wf4(:,15), ex3(:), wf8(:,105), n3(:,98), t3x8(:,:,76))
  call vert_AV_Q(ntry, ex4(:), wf4(:,21), wf8(:,106), n3(:,99), t3x8(:,:,77))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,15), wf8(:,107), n3(:,100), t3x8(:,:,78))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,12), 7, wf8(:,108), n2(40))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,16), 52, wf8(:,109), n2(41))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,18), 52, wf8(:,110), n2(42))
  call vert_AQ_S(gX,ntry, ex6(:), ex5(:), wf4(:,24), n3(:,101), t3x4(:,:,14))
  call counter_S_V(EWctXA,ntry, wf4(:,24), 48, wf4(:,25), n2(43))
  call vert_VQ_A(ntry, wf4(:,25), ex3(:), wf8(:,111), n3(:,102), t3x8(:,:,79))
  call counter_S_V(EWctXZ,ntry, wf4(:,24), 48, wf4(:,26), n2(44))
  call vert_ZQ_A(gZl,ntry, wf4(:,26), ex3(:), wf8(:,112), n3(:,103), t3x8(:,:,80))
  call counter_V_V(EWctAA,ntry, wf4(:,5), 48, wf4(:,27), n2(45))
  call vert_VQ_A(ntry, wf4(:,27), ex3(:), wf8(:,113), n3(:,104), t3x8(:,:,81))
  call counter_V_V(EWctAZ,ntry, wf4(:,6), 48, wf4(:,28), n2(46))
  call vert_VQ_A(ntry, wf4(:,28), ex3(:), wf8(:,114), n3(:,105), t3x8(:,:,82))
  call counter_V_V(EWctAZ,ntry, wf4(:,5), 48, wf4(:,29), n2(47))
  call vert_ZQ_A(gZl,ntry, wf4(:,29), ex3(:), wf8(:,115), n3(:,106), t3x8(:,:,83))
  call counter_V_V(EWctZZ,ntry, wf4(:,6), 48, wf4(:,30), n2(48))
  call vert_ZQ_A(gZl,ntry, wf4(:,30), ex3(:), wf8(:,116), n3(:,107), t3x8(:,:,84))
  call vert_AV_Q(ntry, ex4(:), wf4(:,25), wf8(:,117), n3(:,108), t3x8(:,:,85))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,26), wf8(:,118), n3(:,109), t3x8(:,:,86))
  call vert_AV_Q(ntry, ex4(:), wf4(:,27), wf8(:,119), n3(:,110), t3x8(:,:,87))
  call vert_AV_Q(ntry, ex4(:), wf4(:,28), wf8(:,120), n3(:,111), t3x8(:,:,88))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,29), wf8(:,121), n3(:,112), t3x8(:,:,89))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,30), wf8(:,122), n3(:,113), t3x8(:,:,90))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,21), 13, wf8(:,123), n2(49))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,24), 49, wf8(:,124), n2(50))
  call vert_ZQ_A(gZn,ntry, wf4(:,18), ex1(:), wf8(:,125), n3(:,114), t3x8(:,:,91))
  call vert_ZQ_A(gZn,ntry, wf4(:,19), ex1(:), wf8(:,126), n3(:,115), t3x8(:,:,92))
  call vert_ZQ_A(gZn,ntry, wf4(:,26), ex1(:), wf8(:,127), n3(:,116), t3x8(:,:,93))
  call vert_ZQ_A(gZn,ntry, wf4(:,29), ex1(:), wf8(:,128), n3(:,117), t3x8(:,:,94))
  call vert_ZQ_A(gZn,ntry, wf4(:,30), ex1(:), wf8(:,129), n3(:,118), t3x8(:,:,95))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,18), wf8(:,130), n3(:,119), t3x8(:,:,96))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,19), wf8(:,131), n3(:,120), t3x8(:,:,97))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,26), wf8(:,132), n3(:,121), t3x8(:,:,98))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,29), wf8(:,133), n3(:,122), t3x8(:,:,99))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,30), wf8(:,134), n3(:,123), t3x8(:,:,100))
  call vert_VS_T(ntry, wf4(:,1), 3, wf4(:,24), 48, wf16(:,10), n3(:,124), t3x16(:,:,10))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,6), wf16(:,11), n3(:,125), t3x16(:,:,11))
  call vert_QA_V(ntry, wf8(:,12), ex4(:), wf16(:,12), n3(:,126), t3x16(:,:,12))
  call vert_QA_Z(gZl,ntry, wf8(:,12), ex4(:), wf16(:,13), n3(:,127), t3x16(:,:,13))
  call vert_QA_V(ntry, ex3(:), wf8(:,44), wf16(:,14), n3(:,128), t3x16(:,:,14))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,44), wf16(:,15), n3(:,129), t3x16(:,:,15))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,3), wf16(:,16), n3(:,130), t3x16(:,:,16))
  call vert_QA_V(ntry, wf8(:,3), ex6(:), wf16(:,17), n3(:,131), t3x16(:,:,17))
  call vert_QA_Z(gZd,ntry, wf8(:,3), ex6(:), wf16(:,18), n3(:,132), t3x16(:,:,18))
  call vert_AQ_S(gH,ntry, wf8(:,29), ex5(:), wf16(:,19), n3(:,133), t3x16(:,:,19))
  call vert_QA_V(ntry, ex5(:), wf8(:,29), wf16(:,20), n3(:,134), t3x16(:,:,20))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,29), wf16(:,21), n3(:,135), t3x16(:,:,21))
  call vert_VS_T(ntry, wf4(:,2), 12, wf4(:,24), 48, wf16(:,22), n3(:,136), t3x16(:,:,22))
  call vert_VV_S(ntry, wf4(:,2), wf4(:,6), wf16(:,23), n3(:,137), t3x16(:,:,23))
  call vert_QA_Z(gZn,ntry, wf8(:,21), ex2(:), wf16(:,24), n3(:,138), t3x16(:,:,24))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,69), wf16(:,25), n3(:,139), t3x16(:,:,25))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,7), wf16(:,26), n3(:,140), t3x16(:,:,26))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,9), wf16(:,27), n3(:,141), t3x16(:,:,27))
  call vert_QA_V(ntry, wf8(:,7), ex6(:), wf16(:,28), n3(:,142), t3x16(:,:,28))
  call vert_QA_Z(gZd,ntry, wf8(:,7), ex6(:), wf16(:,29), n3(:,143), t3x16(:,:,29))
  call vert_QA_V(ntry, wf8(:,9), ex6(:), wf16(:,30), n3(:,144), t3x16(:,:,30))
  call vert_QA_Z(gZd,ntry, wf8(:,9), ex6(:), wf16(:,31), n3(:,145), t3x16(:,:,31))
  call vert_AQ_S(gH,ntry, wf8(:,32), ex5(:), wf16(:,32), n3(:,146), t3x16(:,:,32))
  call vert_AQ_S(gH,ntry, wf8(:,33), ex5(:), wf16(:,33), n3(:,147), t3x16(:,:,33))
  call vert_QA_V(ntry, ex5(:), wf8(:,32), wf16(:,34), n3(:,148), t3x16(:,:,34))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,32), wf16(:,35), n3(:,149), t3x16(:,:,35))
  call vert_QA_V(ntry, ex5(:), wf8(:,33), wf16(:,36), n3(:,150), t3x16(:,:,36))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,33), wf16(:,37), n3(:,151), t3x16(:,:,37))
  call vert_QA_Z(gZn,ntry, wf8(:,24), ex2(:), wf16(:,38), n3(:,152), t3x16(:,:,38))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,66), wf16(:,39), n3(:,153), t3x16(:,:,39))
  call vert_QA_V(ntry, wf8(:,16), ex4(:), wf16(:,40), n3(:,154), t3x16(:,:,40))
  call vert_QA_Z(gZl,ntry, wf8(:,16), ex4(:), wf16(:,41), n3(:,155), t3x16(:,:,41))
  call vert_QA_V(ntry, wf8(:,18), ex4(:), wf16(:,42), n3(:,156), t3x16(:,:,42))
  call vert_QA_Z(gZl,ntry, wf8(:,18), ex4(:), wf16(:,43), n3(:,157), t3x16(:,:,43))
  call vert_QA_V(ntry, ex3(:), wf8(:,47), wf16(:,44), n3(:,158), t3x16(:,:,44))
  call vert_QA_V(ntry, ex3(:), wf8(:,48), wf16(:,45), n3(:,159), t3x16(:,:,45))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,47), wf16(:,46), n3(:,160), t3x16(:,:,46))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,48), wf16(:,47), n3(:,161), t3x16(:,:,47))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,3), wf16(:,48), n3(:,162), t3x16(:,:,48))
  call vert_AQ_S(gX,ntry, wf8(:,29), ex5(:), wf16(:,49), n3(:,163), t3x16(:,:,49))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,7), wf16(:,50), n3(:,164), t3x16(:,:,50))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,9), wf16(:,51), n3(:,165), t3x16(:,:,51))
  call vert_AQ_S(gX,ntry, wf8(:,32), ex5(:), wf16(:,52), n3(:,166), t3x16(:,:,52))
  call vert_AQ_S(gX,ntry, wf8(:,33), ex5(:), wf16(:,53), n3(:,167), t3x16(:,:,53))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,3), wf16(:,1), A(:,1), n3(:,168), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,2), n3(:,169), t3x64(:,:,2), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,4), A(:,3), n3(:,170), t3x64(:,:,3), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,7), A(:,4), n3(:,171), t3x64(:,:,4), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,9), A(:,5), n3(:,172), t3x64(:,:,5), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,6), n3(:,173), t3x64(:,:,6), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,13), A(:,7), n3(:,174), t3x64(:,:,7), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,16), A(:,8), n3(:,175), t3x64(:,:,8), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,18), A(:,9), n3(:,176), t3x64(:,:,9), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,21), A(:,10), n3(:,177), t3x64(:,:,10), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,24), A(:,11), n3(:,178), t3x64(:,:,11), nhel, den(32))

    call Hcont_SS(nsync, wf4(:,3), wf16(:,2), A(:,12), n3(:,179), t3x64(:,:,12), nhel, den(34))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,3), A(:,13), n3(:,180), t3x64(:,:,13), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,25), A(:,14), n3(:,181), t3x64(:,:,14), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,26), A(:,15), n3(:,182), t3x64(:,:,15), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,27), A(:,16), n3(:,183), t3x64(:,:,16), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,27), A(:,17), n3(:,184), t3x64(:,:,17), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,29), A(:,18), n3(:,185), t3x64(:,:,18), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,30), A(:,19), n3(:,186), t3x64(:,:,19), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,32), A(:,20), n3(:,187), t3x64(:,:,20), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,33), A(:,21), n3(:,188), t3x64(:,:,21), nhel, den(43))
    call Hcont_SS(nsync, wf16(:,1), wf4(:,7), A(:,22), n3(:,189), t3x64(:,:,22), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,34), A(:,23), n3(:,190), t3x64(:,:,23), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,35), A(:,24), n3(:,191), t3x64(:,:,24), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,37), A(:,25), n3(:,192), t3x64(:,:,25), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,39), A(:,26), n3(:,193), t3x64(:,:,26), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,40), A(:,27), n3(:,194), t3x64(:,:,27), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,41), A(:,28), n3(:,195), t3x64(:,:,28), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,42), A(:,29), n3(:,196), t3x64(:,:,29), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,42), A(:,30), n3(:,197), t3x64(:,:,30), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,44), A(:,31), n3(:,198), t3x64(:,:,31), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,45), A(:,32), n3(:,199), t3x64(:,:,32), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,47), A(:,33), n3(:,200), t3x64(:,:,33), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,48), A(:,34), n3(:,201), t3x64(:,:,34), nhel, den(52))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,4), A(:,35), n3(:,202), t3x64(:,:,35), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,49), A(:,36), n3(:,203), t3x64(:,:,36), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,50), A(:,37), n3(:,204), t3x64(:,:,37), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,52), A(:,38), n3(:,205), t3x64(:,:,38), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,54), A(:,39), n3(:,206), t3x64(:,:,39), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,55), A(:,40), n3(:,207), t3x64(:,:,40), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,57), A(:,41), n3(:,208), t3x64(:,:,41), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,58), A(:,42), n3(:,209), t3x64(:,:,42), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,60), A(:,43), n3(:,210), t3x64(:,:,43), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,61), A(:,44), n3(:,211), t3x64(:,:,44), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,62), A(:,45), n3(:,212), t3x64(:,:,45), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,63), A(:,46), n3(:,213), t3x64(:,:,46), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,64), A(:,47), n3(:,214), t3x64(:,:,47), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,65), wf8(:,66), A(:,48), n3(:,215), t3x64(:,:,48), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,67), A(:,49), n3(:,216), t3x64(:,:,49), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,69), A(:,50), n3(:,217), t3x64(:,:,50), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,69), wf8(:,70), A(:,51), n3(:,218), t3x64(:,:,51), nhel, den(62))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,5), A(:,52), n3(:,219), t3x64(:,:,52), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,72), A(:,53), n3(:,220), t3x64(:,:,53), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,72), A(:,54), n3(:,221), t3x64(:,:,54), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,74), A(:,55), n3(:,222), t3x64(:,:,55), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,74), A(:,56), n3(:,223), t3x64(:,:,56), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,75), A(:,57), n3(:,224), t3x64(:,:,57), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,75), A(:,58), n3(:,225), t3x64(:,:,58), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,76), A(:,59), n3(:,226), t3x64(:,:,59), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,76), A(:,60), n3(:,227), t3x64(:,:,60), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,78), A(:,61), n3(:,228), t3x64(:,:,61), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,78), A(:,62), n3(:,229), t3x64(:,:,62), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,80), A(:,63), n3(:,230), t3x64(:,:,63), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,80), A(:,64), n3(:,231), t3x64(:,:,64), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,81), A(:,65), n3(:,232), t3x64(:,:,65), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,81), A(:,66), n3(:,233), t3x64(:,:,66), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,82), A(:,67), n3(:,234), t3x64(:,:,67), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,82), A(:,68), n3(:,235), t3x64(:,:,68), nhel, den(26))
    call Hcont_SS(nsync, wf16(:,6), wf4(:,14), A(:,69), n3(:,236), t3x64(:,:,69), nhel, den(77))
    call Hcont_VV(nsync, wf16(:,7), wf4(:,15), A(:,70), n3(:,237), t3x64(:,:,70), nhel, den(77))
    call Hcont_SS(nsync, wf16(:,8), wf4(:,16), A(:,71), n3(:,238), t3x64(:,:,71), nhel, den(81))
    call Hcont_SS(nsync, wf16(:,8), wf4(:,17), A(:,72), n3(:,239), t3x64(:,:,72), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,9), wf4(:,18), A(:,73), n3(:,240), t3x64(:,:,73), nhel, den(81))
    call Hcont_VV(nsync, wf16(:,9), wf4(:,19), A(:,74), n3(:,241), t3x64(:,:,74), nhel, den(82))
    call Hcont_SS(nsync, wf16(:,1), wf4(:,20), A(:,75), n3(:,242), t3x64(:,:,75), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,83), A(:,76), n3(:,243), t3x64(:,:,76), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,83), A(:,77), n3(:,244), t3x64(:,:,77), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,84), A(:,78), n3(:,245), t3x64(:,:,78), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,84), A(:,79), n3(:,246), t3x64(:,:,79), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,85), A(:,80), n3(:,247), t3x64(:,:,80), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,85), A(:,81), n3(:,248), t3x64(:,:,81), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,86), A(:,82), n3(:,249), t3x64(:,:,82), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,86), A(:,83), n3(:,250), t3x64(:,:,83), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,87), A(:,84), n3(:,251), t3x64(:,:,84), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,87), A(:,85), n3(:,252), t3x64(:,:,85), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,88), A(:,86), n3(:,253), t3x64(:,:,86), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,88), A(:,87), n3(:,254), t3x64(:,:,87), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,89), A(:,88), n3(:,255), t3x64(:,:,88), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,90), A(:,89), n3(:,256), t3x64(:,:,89), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,91), A(:,90), n3(:,257), t3x64(:,:,90), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,92), A(:,91), n3(:,258), t3x64(:,:,91), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,93), A(:,92), n3(:,259), t3x64(:,:,92), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,94), A(:,93), n3(:,260), t3x64(:,:,93), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,95), A(:,94), n3(:,261), t3x64(:,:,94), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,96), A(:,95), n3(:,262), t3x64(:,:,95), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,97), A(:,96), n3(:,263), t3x64(:,:,96), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,98), A(:,97), n3(:,264), t3x64(:,:,97), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,99), A(:,98), n3(:,265), t3x64(:,:,98), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,100), A(:,99), n3(:,266), t3x64(:,:,99), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,101), A(:,100), n3(:,267), t3x64(:,:,100), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,101), A(:,101), n3(:,268), t3x64(:,:,101), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,102), A(:,102), n3(:,269), t3x64(:,:,102), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,103), A(:,103), n3(:,270), t3x64(:,:,103), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,104), A(:,104), n3(:,271), t3x64(:,:,104), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,104), A(:,105), n3(:,272), t3x64(:,:,105), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,105), A(:,106), n3(:,273), t3x64(:,:,106), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,105), A(:,107), n3(:,274), t3x64(:,:,107), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,106), A(:,108), n3(:,275), t3x64(:,:,108), nhel, den(113))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,106), A(:,109), n3(:,276), t3x64(:,:,109), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,107), A(:,110), n3(:,277), t3x64(:,:,110), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,107), A(:,111), n3(:,278), t3x64(:,:,111), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,108), A(:,112), n3(:,279), t3x64(:,:,112), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,108), A(:,113), n3(:,280), t3x64(:,:,113), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,109), A(:,114), n3(:,281), t3x64(:,:,114), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,110), A(:,115), n3(:,282), t3x64(:,:,115), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,111), A(:,116), n3(:,283), t3x64(:,:,116), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,112), A(:,117), n3(:,284), t3x64(:,:,117), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,113), A(:,118), n3(:,285), t3x64(:,:,118), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,114), A(:,119), n3(:,286), t3x64(:,:,119), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,115), A(:,120), n3(:,287), t3x64(:,:,120), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,116), A(:,121), n3(:,288), t3x64(:,:,121), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,117), A(:,122), n3(:,289), t3x64(:,:,122), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,118), A(:,123), n3(:,290), t3x64(:,:,123), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,119), A(:,124), n3(:,291), t3x64(:,:,124), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,120), A(:,125), n3(:,292), t3x64(:,:,125), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,121), A(:,126), n3(:,293), t3x64(:,:,126), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,122), A(:,127), n3(:,294), t3x64(:,:,127), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,123), A(:,128), n3(:,295), t3x64(:,:,128), nhel, den(130))
    call Hcont_QA(nsync, wf8(:,69), wf8(:,124), A(:,129), n3(:,296), t3x64(:,:,129), nhel, den(131))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,125), A(:,130), n3(:,297), t3x64(:,:,130), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,126), A(:,131), n3(:,298), t3x64(:,:,131), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,69), wf8(:,127), A(:,132), n3(:,299), t3x64(:,:,132), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,69), wf8(:,128), A(:,133), n3(:,300), t3x64(:,:,133), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,69), wf8(:,129), A(:,134), n3(:,301), t3x64(:,:,134), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,130), A(:,135), n3(:,302), t3x64(:,:,135), nhel, den(136))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,131), A(:,136), n3(:,303), t3x64(:,:,136), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,132), A(:,137), n3(:,304), t3x64(:,:,137), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,133), A(:,138), n3(:,305), t3x64(:,:,138), nhel, den(139))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,134), A(:,139), n3(:,306), t3x64(:,:,139), nhel, den(138))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,2)%j+A(j,4)%j+A(j,6)%j+A(j,8)%j)*f(1)+(A(j,3)%j+A(j,5)%j+A(j,7)%j+A(j,9)%j+A(j,10)%j+A(j,11)%j)*f(2) &
       -A(j,1)%j*f(6)

  M2(1)%j = (A(j,53)%j+A(j,57)%j-A(j,78)%j-A(j,84)%j)*f(3)+(A(j,16)%j+A(j,20)%j+A(j,27)%j+A(j,29)%j+A(j,31)%j+A(j,33)%j+A(j,36)%j &
       +A(j,38)%j+A(j,44)%j+A(j,50)%j+A(j,54)%j+A(j,55)%j+A(j,58)%j+A(j,59)%j+A(j,61)%j+A(j,63)%j+A(j,65)%j+A(j,67)%j-A(j,79)%j &
       -A(j,80)%j-A(j,85)%j-A(j,86)%j-A(j,90)%j-A(j,92)%j-A(j,96)%j-A(j,98)%j-A(j,100)%j-A(j,102)%j-A(j,104)%j-A(j,106)%j &
       -A(j,108)%j-A(j,110)%j-A(j,112)%j-A(j,114)%j-A(j,118)%j-A(j,120)%j-A(j,124)%j-A(j,126)%j-A(j,133)%j-A(j,138)%j)*f(4) &
       +(A(j,14)%j+A(j,15)%j+A(j,17)%j+A(j,18)%j+A(j,19)%j+A(j,21)%j+A(j,23)%j+A(j,24)%j+A(j,25)%j+A(j,26)%j+A(j,28)%j+A(j,30)%j &
       +A(j,32)%j+A(j,34)%j+A(j,37)%j+A(j,39)%j+A(j,40)%j+A(j,41)%j+A(j,42)%j+A(j,43)%j+A(j,45)%j+A(j,46)%j+A(j,47)%j+A(j,48)%j &
       +A(j,49)%j+A(j,51)%j+A(j,56)%j+A(j,60)%j+A(j,62)%j+A(j,64)%j+A(j,66)%j+A(j,68)%j-A(j,81)%j-A(j,87)%j-A(j,91)%j-A(j,93)%j &
       -A(j,97)%j-A(j,99)%j-A(j,101)%j-A(j,103)%j-A(j,105)%j-A(j,107)%j-A(j,109)%j-A(j,111)%j-A(j,113)%j-A(j,115)%j-A(j,119)%j &
       -A(j,121)%j-A(j,125)%j-A(j,127)%j-A(j,128)%j-A(j,129)%j-A(j,130)%j-A(j,131)%j-A(j,134)%j-A(j,135)%j-A(j,136)%j &
       -A(j,139)%j)*f(5)+(-A(j,35)%j-A(j,52)%j+A(j,70)%j+A(j,73)%j+A(j,74)%j+A(j,75)%j)*f(7)+(A(j,69)%j+A(j,71)%j+A(j,72)%j)*f(8) &
       +A(j,22)%j*f(9)+(A(j,76)%j+A(j,82)%j)*f(10)+(A(j,77)%j+A(j,83)%j+A(j,88)%j+A(j,89)%j+A(j,94)%j+A(j,95)%j+A(j,116)%j &
       +A(j,117)%j+A(j,122)%j+A(j,123)%j+A(j,132)%j+A(j,137)%j)*f(11)-A(j,12)%j*f(12)-A(j,13)%j*f(13)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppllll_ew_nmnmxeexbbx_1_/**/REALKIND
