
module ol_colourmatrix_ppllll_ew_nexnmemxuux_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 3]

  K2(1,:) = [ 3]

  KL(1,:) = [ 3]


  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllll_ew_nexnmemxuux_2_/**/REALKIND



module ol_forced_parameters_ppllll_ew_nexnmemxuux_2_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllll_ew_nexnmemxuux_2_/**/REALKIND

module ol_loop_ppllll_ew_nexnmemxuux_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(129), c(120)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:121)
  ! denominators
  complex(REALKIND), save :: den(141)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,64), Mct(1,64), Mcol_loop(1,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*eQED**4)/(4._/**/REALKIND*sw**4)
    f(  2) = (CI*countertermnorm*eQED**6)/(4._/**/REALKIND*sw**4)
    f(  3) = (CI*countertermnorm*eQED**6*EWctVdu)/(4._/**/REALKIND*sw**4)
    f(  4) = (CI*countertermnorm*eQED**6*EWctVen)/(4._/**/REALKIND*sw**4)
    f(  5) = (CI*countertermnorm*eQED**6*EWctVne)/(4._/**/REALKIND*sw**4)
    f(  6) = (CI*countertermnorm*eQED**6*EWctVud)/(4._/**/REALKIND*sw**4)
    f(  7) = (CI*cw*eQED**4)/(2._/**/REALKIND*sw**3)
    f(  8) = (CI*countertermnorm*cw*eQED**6)/(3._/**/REALKIND*sw**3)
    f(  9) = (CI*countertermnorm*cw*eQED**6)/(2._/**/REALKIND*sw**3)
    f( 10) = (CI*countertermnorm*cw*eQED**6*EWctVen)/(2._/**/REALKIND*sw**3)
    f( 11) = (CI*countertermnorm*cw*eQED**6*EWctVne)/(2._/**/REALKIND*sw**3)
    f( 12) = (CI*eQED**4)/(3._/**/REALKIND*sw**2)
    f( 13) = (CI*eQED**4)/(2._/**/REALKIND*sw**2)
    f( 14) = (CI*countertermnorm*eQED**6)/(3._/**/REALKIND*sw**2)
    f( 15) = (CI*countertermnorm*eQED**6)/(2._/**/REALKIND*sw**2)
    f( 16) = (CI*countertermnorm*eQED**6*EWctAWW)/(3._/**/REALKIND*sw**2)
    f( 17) = (CI*countertermnorm*eQED**6*EWctVen)/(3._/**/REALKIND*sw**2)
    f( 18) = (CI*countertermnorm*eQED**6*EWctVen)/(2._/**/REALKIND*sw**2)
    f( 19) = (CI*countertermnorm*eQED**6*EWctVne)/(3._/**/REALKIND*sw**2)
    f( 20) = (CI*countertermnorm*eQED**6*EWctVne)/(2._/**/REALKIND*sw**2)
    f( 21) = (CI*countertermnorm*eQED**6*EWctZWW)/(2._/**/REALKIND*sw**2)
    f( 22) = (CI*countertermnorm*eQED**6*MW)/(3._/**/REALKIND*sw**2)
    f( 23) = (CI*countertermnorm*eQED**6*MW)/(2._/**/REALKIND*cw*sw)
    f( 24) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*3._/**/REALKIND)
    f( 25) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 26) = (eQED**6*integralnorm*SwB)/(sw**6*16._/**/REALKIND)
    f( 27) = (eQED**6*integralnorm*SwB)/(sw**6*8._/**/REALKIND)
    f( 28) = (eQED**6*integralnorm*SwB)/(sw**6*4._/**/REALKIND)
    f( 29) = (cw**2*eQED**6*integralnorm*SwB)/(sw**6*4._/**/REALKIND)
    f( 30) = (eQED**6*integralnorm*MW**2*SwB)/(sw**6*4._/**/REALKIND)
    f( 31) = (eQED**6*integralnorm*SwB)/(cw*sw**5*16._/**/REALKIND)
    f( 32) = (eQED**6*integralnorm*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 33) = (cw*eQED**6*integralnorm*SwB)/(sw**5*8._/**/REALKIND)
    f( 34) = (cw*eQED**6*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f( 35) = (cw*eQED**6*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f( 36) = (cw**3*eQED**6*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f( 37) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw**5*2._/**/REALKIND)
    f( 38) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**5*2._/**/REALKIND)
    f( 39) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**5*4._/**/REALKIND)
    f( 40) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**5*2._/**/REALKIND)
    f( 41) = (eQED**6*integralnorm*SwB)/(sw**4*36._/**/REALKIND)
    f( 42) = (eQED**6*integralnorm*SwB)/(sw**4*18._/**/REALKIND)
    f( 43) = (eQED**6*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f( 44) = (eQED**6*integralnorm*SwB)/(sw**4*9._/**/REALKIND)
    f( 45) = (eQED**6*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f( 46) = (eQED**6*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 47) = (eQED**6*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 48) = (eQED**6*integralnorm*SwB)/(sw**4*3._/**/REALKIND)
    f( 49) = (eQED**6*integralnorm*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f( 50) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*3._/**/REALKIND)
    f( 51) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 52) = (eQED**6*integralnorm*MH**2*SwB)/(sw**4*12._/**/REALKIND)
    f( 53) = (eQED**6*integralnorm*MH**2*SwB)/(sw**4*6._/**/REALKIND)
    f( 54) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*6._/**/REALKIND)
    f( 55) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f( 56) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*3._/**/REALKIND)
    f( 57) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f( 58) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**4*2._/**/REALKIND)
    f( 59) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f( 60) = (eQED**6*integralnorm*SwB)/(cw*sw**3*8._/**/REALKIND)
    f( 61) = (2*cw*eQED**6*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f( 62) = (cw*eQED**6*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f( 63) = (cw*eQED**6*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 64) = (eQED**6*integralnorm*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f( 65) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f( 66) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f( 67) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f( 68) = (4*eQED**6*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f( 69) = (2*eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 70) = (eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 71) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f( 72) = (2*eQED**6*integralnorm*MW**2*SwB)/(sw**2*9._/**/REALKIND)
    f( 73) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f( 74) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f( 75) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f( 76) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f( 77) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f( 78) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*16._/**/REALKIND))
    f( 79) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f( 80) = -((eQED**6*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f( 81) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**4*6._/**/REALKIND))
    f( 82) = -((eQED**6*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f( 83) = (eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f( 84) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**4*6._/**/REALKIND))
    f( 85) = (eQED**6*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f( 86) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*6._/**/REALKIND))
    f( 87) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f( 88) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f( 89) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f( 90) = (eQED**6*integralnorm*SwF)/(sw**6*8._/**/REALKIND)
    f( 91) = (eQED**6*integralnorm*SwF)/(sw**6*4._/**/REALKIND)
    f( 92) = (cw*eQED**6*integralnorm*SwF)/(sw**5*4._/**/REALKIND)
    f( 93) = (cw*eQED**6*integralnorm*SwF)/(sw**5*2._/**/REALKIND)
    f( 94) = (eQED**6*integralnorm*SwF)/(sw**4*18._/**/REALKIND)
    f( 95) = (eQED**6*integralnorm*SwF)/(sw**4*9._/**/REALKIND)
    f( 96) = (eQED**6*integralnorm*SwF)/(sw**4*6._/**/REALKIND)
    f( 97) = (2*eQED**6*integralnorm*SwF)/(sw**4*9._/**/REALKIND)
    f( 98) = (eQED**6*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f( 99) = (eQED**6*integralnorm*SwF)/(sw**4*3._/**/REALKIND)
    f(100) = (eQED**6*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(101) = (eQED**6*integralnorm*MB*SwF)/(sw**4*18._/**/REALKIND)
    f(102) = (eQED**6*integralnorm*MB*SwF)/(sw**4*4._/**/REALKIND)
    f(103) = (eQED**6*integralnorm*ML*SwF)/(sw**4*6._/**/REALKIND)
    f(104) = (eQED**6*integralnorm*ML*SwF)/(sw**4*4._/**/REALKIND)
    f(105) = (eQED**6*integralnorm*MT*SwF)/(sw**4*9._/**/REALKIND)
    f(106) = (eQED**6*integralnorm*MT*SwF)/(sw**4*4._/**/REALKIND)
    f(107) = (eQED**6*integralnorm*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(108) = (cw*eQED**6*integralnorm*SwF)/(sw**3*9._/**/REALKIND)
    f(109) = (2*cw*eQED**6*integralnorm*SwF)/(sw**3*9._/**/REALKIND)
    f(110) = (cw*eQED**6*integralnorm*SwF)/(sw**3*3._/**/REALKIND)
    f(111) = (4*cw*eQED**6*integralnorm*SwF)/(sw**3*9._/**/REALKIND)
    f(112) = (cw*eQED**6*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(113) = (2*cw*eQED**6*integralnorm*SwF)/(sw**3*3._/**/REALKIND)
    f(114) = (cw*eQED**6*integralnorm*SwF)/sw**3
    f(115) = (3*cw*eQED**6*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(116) = (eQED**6*integralnorm*ML*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(117) = (eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(118) = (2*eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(119) = (eQED**6*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(120) = (4*eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(121) = (eQED**6*integralnorm*SwF)/(sw**2*6._/**/REALKIND)
    f(122) = (2*eQED**6*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(123) = (8*eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(124) = (eQED**6*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(125) = (4*eQED**6*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(126) = (eQED**6*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(127) = (2*eQED**6*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(128) = (eQED**6*integralnorm*SwF)/sw**2
    f(129) = (3*eQED**6*integralnorm*SwF)/(sw**2*2._/**/REALKIND)

  c = [ f(24), f(25), f(26), f(27), f(28), f(29), f(30), f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38), f(39), f(40) &
    , f(41), f(42), f(43), f(44), f(45), f(46), f(47), f(48), f(49), f(50), f(51), f(52), f(53), f(54), f(55), f(56), f(57), f(58) &
    , f(59), f(60), f(61), f(62), f(63), f(64), f(65), f(66), f(67), f(68), f(69), f(70), f(71), f(72), f(73), f(74), f(75), f(76) &
    , f(77), f(78), f(79), f(80), f(81), f(82), f(83), f(84), f(85), f(86), f(87), f(88), f(89), f(90), 3*f(90), f(91), 3*f(91) &
    , f(92), 3*f(92), f(93), 3*f(93), 3*f(94), 3*f(95), f(96), 3*f(96), 3*f(97), f(98), 3*f(98), f(99), 3*f(99), f(100), 3*f(100) &
    , 3*f(101), 3*f(102), f(103), f(104), 3*f(105), 3*f(106), 3*f(107), 3*f(108), 3*f(109), f(110), 3*f(111), f(112), 3*f(112) &
    , f(113), f(114), 3*f(114), f(115), f(116), 3*f(117), 3*f(118), 3*f(119), 3*f(120), 3*f(121), 3*f(122), 3*f(123), f(124) &
    , 3*f(124), 3*f(125), f(126), 3*f(126), f(127), 3*f(127), f(128), 3*f(128), f(129) ]
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(86)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_A(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_Q(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_Q(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_Q(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_A(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_A(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_Q(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_Q(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_Q(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_A(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QA_W(wf(:,-2),wf(:,0),wf(:,1))
  call vert_QA_W(wf(:,-1),wf(:,-3),wf(:,2))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,3))
  call vert_UV_W(wf(:,2),Q(:,10),wf(:,1),Q(:,5),wf(:,4))
  call vert_QA_Z(gZu,wf(:,-4),wf(:,-5),wf(:,5))
  call vert_WQ_A(wf(:,1),wf(:,-4),wf(:,6))
  call vert_AW_Q(wf(:,-5),wf(:,2),wf(:,7))
  call prop_Q_A(wf(:,6),Q(:,21),ZERO,0_intkind1,wf(:,8))
  call vert_WQ_A(wf(:,1),wf(:,-1),wf(:,9))
  call vert_AV_Q(wf(:,-3),wf(:,3),wf(:,10))
  call prop_Q_A(wf(:,9),Q(:,7),ZERO,0_intkind1,wf(:,11))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,5),wf(:,12))
  call vert_ZQ_A(gZn,wf(:,5),wf(:,-1),wf(:,13))
  call vert_AW_Q(wf(:,-3),wf(:,1),wf(:,14))
  call prop_Q_A(wf(:,13),Q(:,50),ZERO,0_intkind1,wf(:,15))
  call vert_AW_Q(wf(:,0),wf(:,2),wf(:,16))
  call vert_VQ_A(wf(:,3),wf(:,-2),wf(:,17))
  call prop_A_Q(wf(:,16),Q(:,11),ZERO,0_intkind1,wf(:,18))
  call vert_ZQ_A(gZl,wf(:,5),wf(:,-2),wf(:,19))
  call vert_AZ_Q(gZn,wf(:,0),wf(:,5),wf(:,20))
  call vert_WQ_A(wf(:,2),wf(:,-2),wf(:,21))
  call prop_A_Q(wf(:,20),Q(:,49),ZERO,0_intkind1,wf(:,22))
  call counter_UV_W(wf(:,2),Q(:,10),wf(:,1),Q(:,5),wf(:,23))
  call counter_AW_Q(wf(:,-5),wf(:,2),wf(:,24))
  call counter_WQ_A(wf(:,1),wf(:,-4),wf(:,25))
  call prop_A_Q(wf(:,7),Q(:,42),ZERO,0_intkind1,wf(:,26))
  call counter_QA_V_LR(EWctAuu,wf(:,-4),wf(:,-5),wf(:,27))
  call counter_QA_Z(EWctVuu,wf(:,-4),wf(:,-5),wf(:,28))
  call vert_AV_Q(wf(:,-3),wf(:,27),wf(:,29))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,28),wf(:,30))
  call vert_ZQ_A(gZn,wf(:,28),wf(:,-1),wf(:,31))
  call prop_Q_A(wf(:,31),Q(:,50),ZERO,0_intkind1,wf(:,32))
  call counter_AZ_Q(EWctAee,wf(:,-3),wf(:,3),wf(:,33))
  call counter_AZ_Q(EWctVee,wf(:,-3),wf(:,5),wf(:,34))
  call counter_AW_Q(wf(:,-3),wf(:,1),wf(:,35))
  call vert_VQ_A(wf(:,27),wf(:,-2),wf(:,36))
  call vert_ZQ_A(gZl,wf(:,28),wf(:,-2),wf(:,37))
  call vert_AZ_Q(gZn,wf(:,0),wf(:,28),wf(:,38))
  call prop_A_Q(wf(:,38),Q(:,49),ZERO,0_intkind1,wf(:,39))
  call counter_ZQ_A(EWctAee,wf(:,3),wf(:,-2),wf(:,40))
  call counter_ZQ_A(EWctVee,wf(:,5),wf(:,-2),wf(:,41))
  call counter_WQ_A(wf(:,2),wf(:,-2),wf(:,42))
  call counter_ZQ_A(EWctAnn,wf(:,3),wf(:,-1),wf(:,43))
  call prop_A_Q(wf(:,14),Q(:,13),ZERO,0_intkind1,wf(:,44))
  call counter_ZQ_A(EWctVnn,wf(:,5),wf(:,-1),wf(:,45))
  call counter_WQ_A(wf(:,1),wf(:,-1),wf(:,46))
  call prop_A_Q(wf(:,10),Q(:,56),ZERO,0_intkind1,wf(:,47))
  call prop_A_Q(wf(:,12),Q(:,56),ZERO,0_intkind1,wf(:,48))
  call counter_QA_W(wf(:,-1),wf(:,-3),wf(:,49))
  call vert_UV_W(wf(:,49),Q(:,10),wf(:,1),Q(:,5),wf(:,50))
  call vert_AW_Q(wf(:,-5),wf(:,49),wf(:,51))
  call vert_WQ_A(wf(:,49),wf(:,-2),wf(:,52))
  call vert_AW_Q(wf(:,0),wf(:,49),wf(:,53))
  call prop_A_Q(wf(:,53),Q(:,11),ZERO,0_intkind1,wf(:,54))
  call counter_AW_Q(wf(:,0),wf(:,2),wf(:,55))
  call prop_Q_A(wf(:,17),Q(:,52),ZERO,0_intkind1,wf(:,56))
  call prop_Q_A(wf(:,19),Q(:,52),ZERO,0_intkind1,wf(:,57))
  call counter_AZ_Q(EWctAnn,wf(:,0),wf(:,3),wf(:,58))
  call prop_Q_A(wf(:,21),Q(:,14),ZERO,0_intkind1,wf(:,59))
  call counter_AZ_Q(EWctVnn,wf(:,0),wf(:,5),wf(:,60))
  call counter_QA_W(wf(:,-2),wf(:,0),wf(:,61))
  call vert_UV_W(wf(:,2),Q(:,10),wf(:,61),Q(:,5),wf(:,62))
  call vert_WQ_A(wf(:,61),wf(:,-4),wf(:,63))
  call prop_Q_A(wf(:,63),Q(:,21),ZERO,0_intkind1,wf(:,64))
  call vert_WQ_A(wf(:,61),wf(:,-1),wf(:,65))
  call prop_Q_A(wf(:,65),Q(:,7),ZERO,0_intkind1,wf(:,66))
  call vert_AW_Q(wf(:,-3),wf(:,61),wf(:,67))
  call vert_VV_S(wf(:,2),wf(:,3),wf(:,68))
  call counter_V_S(EWctPW,wf(:,1),Q(:,5),wf(:,69))
  call vert_VV_S(wf(:,2),wf(:,5),wf(:,70))
  call vert_UV_W(wf(:,3),Q(:,48),wf(:,2),Q(:,10),wf(:,71))
  call counter_V_V(EWctWW,wf(:,1),Q(:,5),wf(:,72))
  call vert_UV_W(wf(:,5),Q(:,48),wf(:,2),Q(:,10),wf(:,73))
  call vert_VV_S(wf(:,1),wf(:,3),wf(:,74))
  call counter_V_S(EWctPW,wf(:,2),Q(:,10),wf(:,75))
  call vert_VV_S(wf(:,1),wf(:,5),wf(:,76))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,3),Q(:,48),wf(:,77))
  call counter_V_V(EWctWW,wf(:,2),Q(:,10),wf(:,78))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,5),Q(:,48),wf(:,79))
  call counter_V_V(EWctAA,wf(:,3),Q(:,48),wf(:,80))
  call counter_V_V(EWctAZ,wf(:,3),Q(:,48),wf(:,81))
  call counter_V_V(EWctAZ,wf(:,5),Q(:,48),wf(:,82))
  call counter_V_V(EWctZZ,wf(:,5),Q(:,48),wf(:,83))
  call vert_WQ_A(wf(:,72),wf(:,-4),wf(:,84))
  call vert_AW_Q(wf(:,-5),wf(:,78),wf(:,85))
  call counter_Q_A_LR(EWctdd,wf(:,8),Q(:,21),wf(:,86))
  call vert_WQ_A(wf(:,72),wf(:,-1),wf(:,87))
  call vert_AW_Q(wf(:,-3),wf(:,72),wf(:,88))
  call counter_Q_A_LR(EWctee,wf(:,11),Q(:,7),wf(:,89))
  call counter_Q_A_LR(EWctnn,wf(:,15),Q(:,50),wf(:,90))
  call vert_ZQ_A(gZn,wf(:,81),wf(:,-1),wf(:,91))
  call vert_ZQ_A(gZn,wf(:,83),wf(:,-1),wf(:,92))
  call vert_AV_Q(wf(:,-3),wf(:,80),wf(:,93))
  call vert_AV_Q(wf(:,-3),wf(:,82),wf(:,94))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,81),wf(:,95))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,83),wf(:,96))
  call vert_AW_Q(wf(:,0),wf(:,78),wf(:,97))
  call counter_A_Q_LR(EWctee,wf(:,18),Q(:,11),wf(:,98))
  call counter_A_Q_LR(EWctnn,wf(:,22),Q(:,49),wf(:,99))
  call vert_AZ_Q(gZn,wf(:,0),wf(:,81),wf(:,100))
  call vert_AZ_Q(gZn,wf(:,0),wf(:,83),wf(:,101))
  call vert_WQ_A(wf(:,78),wf(:,-2),wf(:,102))
  call vert_VQ_A(wf(:,80),wf(:,-2),wf(:,103))
  call vert_VQ_A(wf(:,82),wf(:,-2),wf(:,104))
  call vert_ZQ_A(gZl,wf(:,81),wf(:,-2),wf(:,105))
  call vert_ZQ_A(gZl,wf(:,83),wf(:,-2),wf(:,106))
  call vert_VV_S(wf(:,1),wf(:,2),wf(:,107))
  call vert_QA_V(wf(:,11),wf(:,-3),wf(:,108))
  call vert_QA_Z(gZl,wf(:,11),wf(:,-3),wf(:,109))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,44),wf(:,110))
  call vert_QA_W(wf(:,8),wf(:,-5),wf(:,111))
  call vert_QA_V(wf(:,-2),wf(:,18),wf(:,112))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,18),wf(:,113))
  call vert_QA_Z(gZn,wf(:,59),wf(:,0),wf(:,114))
  call vert_QA_W(wf(:,-4),wf(:,26),wf(:,115))
  call vert_QA_W(wf(:,-2),wf(:,22),wf(:,116))
  call vert_QA_W(wf(:,56),wf(:,0),wf(:,117))
  call vert_QA_W(wf(:,57),wf(:,0),wf(:,118))
  call vert_QA_W(wf(:,15),wf(:,-3),wf(:,119))
  call vert_QA_W(wf(:,-1),wf(:,47),wf(:,120))
  call vert_QA_W(wf(:,-1),wf(:,48),wf(:,121))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5) - MW2)
  den(2) = 1 / (Q(5,10) - MW2)
  den(3) = 1 / (Q(5,48))
  den(6) = 1 / (Q(5,48) - MZ2)
  den(8) = 1 / (Q(5,21))
  den(11) = 1 / (Q(5,7))
  den(15) = 1 / (Q(5,50))
  den(18) = 1 / (Q(5,11))
  den(22) = 1 / (Q(5,49))
  den(25) = 1 / (Q(5,42))
  den(28) = 1 / (Q(5,13))
  den(32) = 1 / (Q(5,56))
  den(37) = 1 / (Q(5,52))
  den(42) = 1 / (Q(5,14))
  den(47) = 1 / (Q(5,58) - MW2)
  den(54) = 1 / (Q(5,53) - MW2)
  den(60) = 1 / (Q(5,15))
  den(63) = 1 / (Q(5,15) - MZ2)
  den(98) = 1 / (Q(5,15) - MH2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(4)*den(6)
  den(9) = den(1)*den(8)
  den(10) = den(2)*den(9)
  den(12) = den(1)*den(11)
  den(13) = den(3)*den(12)
  den(14) = den(6)*den(12)
  den(16) = den(6)*den(15)
  den(17) = den(1)*den(16)
  den(19) = den(2)*den(18)
  den(20) = den(3)*den(19)
  den(21) = den(6)*den(19)
  den(23) = den(6)*den(22)
  den(24) = den(2)*den(23)
  den(26) = den(2)*den(25)
  den(27) = den(1)*den(26)
  den(29) = den(1)*den(28)
  den(30) = den(3)*den(29)
  den(31) = den(6)*den(29)
  den(33) = den(3)*den(32)
  den(34) = den(1)*den(33)
  den(35) = den(6)*den(32)
  den(36) = den(1)*den(35)
  den(38) = den(3)*den(37)
  den(39) = den(2)*den(38)
  den(40) = den(6)*den(37)
  den(41) = den(2)*den(40)
  den(43) = den(2)*den(42)
  den(44) = den(3)*den(43)
  den(45) = den(6)*den(43)
  den(46) = den(2)*den(3)
  den(48) = den(46)*den(47)
  den(49) = den(1)*den(48)
  den(50) = den(2)*den(6)
  den(51) = den(47)*den(50)
  den(52) = den(1)*den(51)
  den(53) = den(1)*den(3)
  den(55) = den(53)*den(54)
  den(56) = den(2)*den(55)
  den(57) = den(1)*den(6)
  den(58) = den(54)*den(57)
  den(59) = den(2)*den(58)
  den(61) = den(4)*den(60)
  den(62) = den(3)*den(61)
  den(64) = den(4)*den(63)
  den(65) = den(3)*den(64)
  den(66) = den(6)*den(61)
  den(67) = den(6)*den(64)
  den(68) = den(1)**2
  den(69) = den(26)*den(68)
  den(70) = den(2)**2
  den(71) = den(9)*den(70)
  den(72) = den(9)*den(26)
  den(73) = den(33)*den(68)
  den(74) = den(35)*den(68)
  den(75) = den(16)*den(68)
  den(76) = den(12)*den(33)
  den(77) = den(12)*den(35)
  den(78) = den(16)*den(29)
  den(79) = den(3)*den(6)
  den(80) = den(29)*den(79)
  den(81) = den(6)**2
  den(82) = den(29)*den(81)
  den(83) = den(3)**2
  den(84) = den(12)*den(83)
  den(85) = den(12)*den(79)
  den(86) = den(12)*den(81)
  den(87) = den(38)*den(70)
  den(88) = den(40)*den(70)
  den(89) = den(19)*den(38)
  den(90) = den(19)*den(40)
  den(91) = den(23)*den(43)
  den(92) = den(43)*den(79)
  den(93) = den(43)*den(81)
  den(94) = den(23)*den(70)
  den(95) = den(19)*den(83)
  den(96) = den(19)*den(79)
  den(97) = den(19)*den(81)
  den(99) = den(4)*den(98)
  den(100) = den(12)*den(60)
  den(101) = den(12)*den(63)
  den(102) = den(29)*den(63)
  den(103) = den(9)*den(54)
  den(104) = den(19)*den(60)
  den(105) = den(19)*den(63)
  den(106) = den(43)*den(63)
  den(107) = den(26)*den(47)
  den(108) = den(23)*den(54)
  den(109) = den(38)*den(54)
  den(110) = den(40)*den(54)
  den(111) = den(16)*den(47)
  den(112) = den(33)*den(47)
  den(113) = den(35)*den(47)
  den(114) = den(1)*den(2)*den(3)
  den(115) = den(1)*den(2)*den(6)
  den(116) = den(1)*den(46)
  den(117) = den(1)*den(50)
  den(118) = den(2)*den(53)
  den(119) = den(2)*den(57)
  den(120) = den(3)*den(99)
  den(121) = den(6)*den(99)
  den(122) = den(2)*den(103)
  den(123) = den(1)*den(107)
  den(124) = den(3)*den(100)
  den(125) = den(6)*den(100)
  den(126) = den(3)*den(101)
  den(127) = den(6)*den(101)
  den(128) = den(3)*den(102)
  den(129) = den(6)*den(102)
  den(130) = den(1)*den(111)
  den(131) = den(1)*den(112)
  den(132) = den(1)*den(113)
  den(133) = den(3)*den(104)
  den(134) = den(6)*den(104)
  den(135) = den(3)*den(105)
  den(136) = den(6)*den(105)
  den(137) = den(2)*den(108)
  den(138) = den(3)*den(106)
  den(139) = den(6)*den(106)
  den(140) = den(2)*den(109)
  den(141) = den(2)*den(110)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(86)

  A(1) = cont_VV(wf(:,3),wf(:,4)) * den(5)
  A(2) = cont_VV(wf(:,4),wf(:,5)) * den(7)
  A(3) = cont_QA(wf(:,7),wf(:,8)) * den(10)
  A(4) = cont_QA(wf(:,10),wf(:,11)) * den(13)
  A(5) = cont_QA(wf(:,11),wf(:,12)) * den(14)
  A(6) = cont_QA(wf(:,14),wf(:,15)) * den(17)
  A(7) = cont_QA(wf(:,17),wf(:,18)) * den(20)
  A(8) = cont_QA(wf(:,18),wf(:,19)) * den(21)
  A(9) = cont_QA(wf(:,21),wf(:,22)) * den(24)

  A(10) = cont_VV(wf(:,3),wf(:,23)) * den(5)
  A(11) = cont_VV(wf(:,5),wf(:,23)) * den(7)
  A(12) = cont_QA(wf(:,8),wf(:,24)) * den(10)
  A(13) = cont_QA(wf(:,25),wf(:,26)) * den(27)
  A(14) = cont_VV(wf(:,4),wf(:,27)) * den(5)
  A(15) = cont_VV(wf(:,4),wf(:,28)) * den(7)
  A(16) = cont_QA(wf(:,11),wf(:,29)) * den(13)
  A(17) = cont_QA(wf(:,11),wf(:,30)) * den(14)
  A(18) = cont_QA(wf(:,14),wf(:,32)) * den(17)
  A(19) = cont_QA(wf(:,11),wf(:,33)) * den(13)
  A(20) = cont_QA(wf(:,11),wf(:,34)) * den(14)
  A(21) = cont_QA(wf(:,15),wf(:,35)) * den(17)
  A(22) = cont_QA(wf(:,18),wf(:,36)) * den(20)
  A(23) = cont_QA(wf(:,18),wf(:,37)) * den(21)
  A(24) = cont_QA(wf(:,21),wf(:,39)) * den(24)
  A(25) = cont_QA(wf(:,18),wf(:,40)) * den(20)
  A(26) = cont_QA(wf(:,18),wf(:,41)) * den(21)
  A(27) = cont_QA(wf(:,22),wf(:,42)) * den(24)
  A(28) = cont_QA(wf(:,43),wf(:,44)) * den(30)
  A(29) = cont_QA(wf(:,44),wf(:,45)) * den(31)
  A(30) = cont_QA(wf(:,46),wf(:,47)) * den(34)
  A(31) = cont_QA(wf(:,46),wf(:,48)) * den(36)
  A(32) = cont_VV(wf(:,3),wf(:,50)) * den(5)
  A(33) = cont_VV(wf(:,5),wf(:,50)) * den(7)
  A(34) = cont_QA(wf(:,8),wf(:,51)) * den(10)
  A(35) = cont_QA(wf(:,22),wf(:,52)) * den(24)
  A(36) = cont_QA(wf(:,17),wf(:,54)) * den(20)
  A(37) = cont_QA(wf(:,19),wf(:,54)) * den(21)
  A(38) = cont_QA(wf(:,55),wf(:,56)) * den(39)
  A(39) = cont_QA(wf(:,55),wf(:,57)) * den(41)
  A(40) = cont_QA(wf(:,58),wf(:,59)) * den(44)
  A(41) = cont_QA(wf(:,59),wf(:,60)) * den(45)
  A(42) = cont_VV(wf(:,3),wf(:,62)) * den(5)
  A(43) = cont_VV(wf(:,5),wf(:,62)) * den(7)
  A(44) = cont_QA(wf(:,7),wf(:,64)) * den(10)
  A(45) = cont_QA(wf(:,10),wf(:,66)) * den(13)
  A(46) = cont_QA(wf(:,12),wf(:,66)) * den(14)
  A(47) = cont_QA(wf(:,15),wf(:,67)) * den(17)
  A(48) = cont_SS(wf(:,68),wf(:,69)) * den(49)
  A(49) = cont_SS(wf(:,69),wf(:,70)) * den(52)
  A(50) = cont_VV(wf(:,71),wf(:,72)) * den(49)
  A(51) = cont_VV(wf(:,72),wf(:,73)) * den(52)
  A(52) = cont_SS(wf(:,74),wf(:,75)) * den(56)
  A(53) = cont_SS(wf(:,75),wf(:,76)) * den(59)
  A(54) = cont_VV(wf(:,77),wf(:,78)) * den(56)
  A(55) = cont_VV(wf(:,78),wf(:,79)) * den(59)
  A(56) = cont_VV(wf(:,4),wf(:,80)) * den(62)
  A(57) = cont_VV(wf(:,4),wf(:,81)) * den(65)
  A(58) = cont_VV(wf(:,4),wf(:,82)) * den(66)
  A(59) = cont_VV(wf(:,4),wf(:,83)) * den(67)
  A(60) = cont_QA(wf(:,26),wf(:,84)) * den(69)
  A(61) = cont_QA(wf(:,8),wf(:,85)) * den(71)
  A(62) = cont_QA(wf(:,26),wf(:,86)) * den(72)
  A(63) = cont_QA(wf(:,47),wf(:,87)) * den(73)
  A(64) = cont_QA(wf(:,48),wf(:,87)) * den(74)
  A(65) = cont_QA(wf(:,15),wf(:,88)) * den(75)
  A(66) = cont_QA(wf(:,47),wf(:,89)) * den(76)
  A(67) = cont_QA(wf(:,48),wf(:,89)) * den(77)
  A(68) = cont_QA(wf(:,44),wf(:,90)) * den(78)
  A(69) = cont_QA(wf(:,44),wf(:,91)) * den(80)
  A(70) = cont_QA(wf(:,44),wf(:,92)) * den(82)
  A(71) = cont_QA(wf(:,11),wf(:,93)) * den(84)
  A(72) = cont_QA(wf(:,11),wf(:,94)) * den(85)
  A(73) = cont_QA(wf(:,11),wf(:,95)) * den(85)
  A(74) = cont_QA(wf(:,11),wf(:,96)) * den(86)
  A(75) = cont_QA(wf(:,56),wf(:,97)) * den(87)
  A(76) = cont_QA(wf(:,57),wf(:,97)) * den(88)
  A(77) = cont_QA(wf(:,56),wf(:,98)) * den(89)
  A(78) = cont_QA(wf(:,57),wf(:,98)) * den(90)
  A(79) = cont_QA(wf(:,59),wf(:,99)) * den(91)
  A(80) = cont_QA(wf(:,59),wf(:,100)) * den(92)
  A(81) = cont_QA(wf(:,59),wf(:,101)) * den(93)
  A(82) = cont_QA(wf(:,22),wf(:,102)) * den(94)
  A(83) = cont_QA(wf(:,18),wf(:,103)) * den(95)
  A(84) = cont_QA(wf(:,18),wf(:,104)) * den(96)
  A(85) = cont_QA(wf(:,18),wf(:,105)) * den(96)
  A(86) = cont_QA(wf(:,18),wf(:,106)) * den(97)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(86)
  complex(REALKIND), intent(out) :: M1(1), M2(1)

  M1(1) = A(3)*f(1)+A(2)*f(7)+(A(1)-A(4)-A(7))*f(12)+(A(5)+A(6)+A(8)+A(9))*f(13)

  M2(1) = (-A(60)-A(61)-A(62))*f(2)+A(13)*f(3)+A(44)*f(4)+A(34)*f(5)+A(12)*f(6)+A(57)*f(8)+(A(15)-A(51)-A(55)-A(59))*f(9) &
       +A(43)*f(10)+A(33)*f(11)+(-A(19)-A(25)-A(28)-A(40)-A(50)-A(54)-A(56)+A(63)+A(66)+A(69)+A(71)+A(73)+A(75)+A(77)+A(80)+A(83) &
       +A(85))*f(14)+(-A(14)+A(16)+A(17)+A(18)+A(20)+A(22)+A(23)+A(24)+A(26)+A(29)+A(41)+A(58)-A(64)-A(65)-A(67)-A(68)-A(70)-A(72) &
       -A(74)-A(76)-A(78)-A(79)-A(81)-A(82)-A(84)-A(86))*f(15)+A(10)*f(16)+(-A(38)+A(42)-A(45))*f(17)+(A(27)+A(39)+A(46) &
       +A(47))*f(18)+(-A(30)+A(32)-A(36))*f(19)+(A(21)+A(31)+A(35)+A(37))*f(20)-A(11)*f(21)+(A(48)+A(52))*f(22)+(-A(49) &
       -A(53))*f(23)

end subroutine colourvectors

end module ol_loop_ppllll_ew_nexnmemxuux_2_/**/REALKIND
