
module ol_colourmatrix_ppllll_ew_eeexexbbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 3]

  K2(1,:) = [ 3]

  KL(1,:) = [ 3]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllll_ew_eeexexbbx_1_/**/REALKIND



module ol_forced_parameters_ppllll_ew_eeexexbbx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllll_ew_eeexexbbx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppllll_ew_eeexexbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 64 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(929)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,54), wf8(8,304), wf16(16,158), wf64(64,578)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(240), c(233)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppllll_ew_eeexexbbx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppllll_ew_eeexexbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllll_ew_eeexexbbx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*eQED**4)/9._/**/REALKIND
    f(  2) = (CI*eQED**4)/3._/**/REALKIND
    f(  3) = CI*eQED**4
    f(  4) = (CI*countertermnorm*eQED**6)/9._/**/REALKIND
    f(  5) = (CI*countertermnorm*eQED**6)/3._/**/REALKIND
    f(  6) = CI*countertermnorm*eQED**6
    f(  7) = (CI*eQED**4*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(  8) = (CI*countertermnorm*eQED**6*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(  9) = (countertermnorm*eQED**6*MB)/(cw*MW*sw**2*4._/**/REALKIND)
    f( 10) = (CI*countertermnorm*eQED**6*MB)/(cw**2*sw)
    f( 11) = (countertermnorm*eQED**6*MB)/(MW*sw*6._/**/REALKIND)
    f( 12) = (countertermnorm*eQED**6*MB)/(MW*sw*2._/**/REALKIND)
    f( 13) = (CI*countertermnorm*eQED**6*EWctHAA*MB)/(2._/**/REALKIND*MW*sw)
    f( 14) = (CI*countertermnorm*eQED**6*EWctHZA*MB)/(2._/**/REALKIND*MW*sw)
    f( 15) = (CI*countertermnorm*eQED**6*EWctHZZ*MB)/(2._/**/REALKIND*MW*sw)
    f( 16) = (eQED**6*integralnorm*SwB)/81._/**/REALKIND
    f( 17) = (eQED**6*integralnorm*SwB)/27._/**/REALKIND
    f( 18) = (eQED**6*integralnorm*SwB)/9._/**/REALKIND
    f( 19) = (eQED**6*integralnorm*SwB)/3._/**/REALKIND
    f( 20) = (2*eQED**6*integralnorm*SwB)/3._/**/REALKIND
    f( 21) = eQED**6*integralnorm*SwB
    f( 22) = (eQED**6*integralnorm*SwB)/(cw**2*2._/**/REALKIND)
    f( 23) = (eQED**6*integralnorm*MB*SwB)/(cw**2*4._/**/REALKIND)
    f( 24) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw**2*4._/**/REALKIND)
    f( 25) = (eQED**6*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f( 26) = (eQED**6*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 27) = eQED**6*integralnorm*MW**2*SwB
    f( 28) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 29) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f( 30) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 31) = (eQED**6*integralnorm*SwB)/(sw**6*8._/**/REALKIND)
    f( 32) = (eQED**6*integralnorm*MB*SwB)/(sw**6*8._/**/REALKIND)
    f( 33) = (cw*eQED**6*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f( 34) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 35) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**5*4._/**/REALKIND)
    f( 36) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**5*4._/**/REALKIND)
    f( 37) = (eQED**6*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f( 38) = (eQED**6*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 39) = (eQED**6*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 40) = (eQED**6*integralnorm*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 41) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 42) = (eQED**6*integralnorm*MB*SwB)/(sw**4*12._/**/REALKIND)
    f( 43) = (eQED**6*integralnorm*MB*SwB)/(sw**4*8._/**/REALKIND)
    f( 44) = (eQED**6*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f( 45) = (eQED**6*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f( 46) = (eQED**6*integralnorm*MB*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f( 47) = (eQED**6*integralnorm*MB*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 48) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f( 49) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 50) = (cw**2*eQED**6*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f( 51) = (cw**2*eQED**6*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f( 52) = (eQED**6*integralnorm*MB**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 53) = (3*eQED**6*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 54) = (eQED**6*integralnorm*MT*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 55) = (eQED**6*integralnorm*MB**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 56) = (eQED**6*integralnorm*MB**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 57) = (eQED**6*integralnorm*MB**3*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 58) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f( 59) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 60) = (3*eQED**6*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 61) = (eQED**6*integralnorm*MB**2*MH**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 62) = (3*eQED**6*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 63) = (eQED**6*integralnorm*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 64) = (eQED**6*integralnorm*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 65) = (9*eQED**6*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 66) = (eQED**6*integralnorm*MT*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f( 67) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f( 68) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*8._/**/REALKIND)
    f( 69) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*4._/**/REALKIND)
    f( 70) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f( 71) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f( 72) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f( 73) = (eQED**6*integralnorm*SwB)/(cw*sw**3*4._/**/REALKIND)
    f( 74) = (cw*eQED**6*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f( 75) = (cw*eQED**6*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f( 76) = (cw*eQED**6*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 77) = (cw**3*eQED**6*integralnorm*SwB)/sw**3
    f( 78) = (eQED**6*integralnorm*MB*SwB)/(cw**3*sw**3*12._/**/REALKIND)
    f( 79) = (eQED**6*integralnorm*MB*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f( 80) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**3*8._/**/REALKIND)
    f( 81) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**3*4._/**/REALKIND)
    f( 82) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**3*2._/**/REALKIND)
    f( 83) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*12._/**/REALKIND)
    f( 84) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*6._/**/REALKIND)
    f( 85) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f( 86) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f( 87) = (eQED**6*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f( 88) = (eQED**6*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 89) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f( 90) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 91) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f( 92) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3)
    f( 93) = (eQED**6*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f( 94) = (eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 95) = (eQED**6*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f( 96) = (2*eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 97) = (eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 98) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f( 99) = (eQED**6*integralnorm*SwB)/(cw**2*sw**2*12._/**/REALKIND)
    f(100) = (eQED**6*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(101) = (cw**2*eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(102) = (cw**2*eQED**6*integralnorm*SwB)/sw**2
    f(103) = (eQED**6*integralnorm*MB*SwB)/(sw**2*12._/**/REALKIND)
    f(104) = (eQED**6*integralnorm*MB*SwB)/(sw**2*6._/**/REALKIND)
    f(105) = (eQED**6*integralnorm*MB*SwB)/(sw**2*4._/**/REALKIND)
    f(106) = (eQED**6*integralnorm*MB*SwB)/(sw**2*2._/**/REALKIND)
    f(107) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**2*18._/**/REALKIND)
    f(108) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(109) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(110) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(111) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(112) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(113) = (eQED**6*integralnorm*MB*MH**2*SwB)/(sw**2*4._/**/REALKIND)
    f(114) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(115) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(116) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(117) = (2*eQED**6*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(118) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(119) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(120) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2)
    f(121) = (eQED**6*integralnorm*MB**2*SwB)/(MW**2*sw**2*36._/**/REALKIND)
    f(122) = (eQED**6*integralnorm*MB**2*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(123) = (eQED**6*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(124) = (eQED**6*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(125) = (eQED**6*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(126) = (eQED**6*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(127) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(128) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(129) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**2*3._/**/REALKIND)
    f(130) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(131) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(132) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(133) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(134) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2)
    f(135) = (eQED**6*integralnorm*MB*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(136) = (eQED**6*integralnorm*SwB)/(cw*sw*6._/**/REALKIND)
    f(137) = (eQED**6*integralnorm*SwB)/(cw*sw*3._/**/REALKIND)
    f(138) = (eQED**6*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(139) = (cw*eQED**6*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(140) = (cw*eQED**6*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(141) = (cw*eQED**6*integralnorm*SwB)/sw
    f(142) = (eQED**6*integralnorm*MB*SwB)/(cw*sw*12._/**/REALKIND)
    f(143) = (eQED**6*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(144) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(145) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(146) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(147) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(148) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw*3._/**/REALKIND)
    f(149) = (cw*eQED**6*integralnorm*MW**2*SwB)/sw
    f(150) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(151) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(152) = (eQED**6*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(153) = (eQED**6*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(154) = (eQED**6*integralnorm*MW**2*sw*SwB)/cw
    f(155) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(156) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(157) = (eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(158) = (eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(159) = -((eQED**6*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(160) = -((eQED**6*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(161) = -((eQED**6*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW**2*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(162) = -((eQED**6*integralnorm*MB*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**2*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(163) = -((eQED**6*integralnorm*MB*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(164) = (eQED**6*integralnorm*MB*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(165) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(166) = -((eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(167) = -((eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(168) = -((eQED**6*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(169) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(170) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*6._/**/REALKIND))
    f(171) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(172) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*2._/**/REALKIND))
    f(173) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND))
    f(174) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(175) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(176) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*18._/**/REALKIND))
    f(177) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(178) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(179) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(180) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(181) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(182) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(183) = (eQED**6*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(184) = (eQED**6*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(185) = (eQED**6*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(186) = (eQED**6*integralnorm*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND)
    f(187) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(188) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*2._/**/REALKIND))
    f(189) = -((eQED**6*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(190) = -((eQED**6*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(191) = -((eQED**6*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(192) = (eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(193) = (2*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(194) = (eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(195) = (4*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(196) = (2*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(197) = (8*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(198) = (eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(199) = (4*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(200) = (16*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(201) = (2*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(202) = (8*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(203) = (eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(204) = (4*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(205) = (2*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(206) = (8*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(207) = eQED**6*integralnorm*SwF
    f(208) = (4*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(209) = 2*eQED**6*integralnorm*SwF
    f(210) = 3*eQED**6*integralnorm*SwF
    f(211) = (eQED**6*integralnorm*MB**3*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(212) = (eQED**6*integralnorm*MB*ML**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(213) = (eQED**6*integralnorm*MB*MT**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(214) = (eQED**6*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(215) = (eQED**6*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(216) = (eQED**6*integralnorm*MB*ML*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(217) = (eQED**6*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(218) = (eQED**6*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(219) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(220) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(221) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(222) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(223) = (2*eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(224) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2)
    f(225) = (3*eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(226) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(227) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(228) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(229) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(230) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(231) = (eQED**6*integralnorm*MB**2*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(232) = (eQED**6*integralnorm*MB**2*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(233) = (eQED**6*integralnorm*MB**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(234) = (eQED**6*integralnorm*MB*ML*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(235) = (eQED**6*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(236) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(237) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(238) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*9._/**/REALKIND)
    f(239) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(240) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)

  c = [ f(16), f(17), f(18), f(19), f(20), f(21), f(22), f(23), f(24), f(25), f(26), f(27), f(28), f(29), f(30), f(31), f(32) &
    , f(33), f(34), f(35), f(36), f(37), f(38), f(39), f(40), f(41), f(42), f(43), f(44), f(45), f(46), f(47), f(48), f(49), f(50) &
    , f(51), f(52), f(53), f(54), f(55), f(56), f(57), f(58), f(59), f(60), f(61), f(62), f(63), f(64), f(65), f(66), f(67), f(68) &
    , f(69), f(70), f(71), f(72), f(73), f(74), f(75), f(76), f(77), f(78), f(79), f(80), f(81), f(82), f(83), f(84), f(85), f(86) &
    , f(87), f(88), f(89), f(90), f(91), f(92), f(93), f(94), f(95), f(96), f(97), f(98), f(99), f(100), f(101), f(102), f(103) &
    , f(104), f(105), f(106), f(107), f(108), f(109), f(110), f(111), f(112), f(113), f(114), f(115), f(116), f(117), f(118) &
    , f(119), f(120), f(121), f(122), f(123), f(124), f(125), f(126), f(127), f(128), f(129), f(130), f(131), f(132), f(133) &
    , f(134), f(135), f(136), f(137), f(138), f(139), f(140), f(141), f(142), f(143), f(144), f(145), f(146), f(147), f(148) &
    , f(149), f(150), f(151), f(152), f(153), f(154), f(155), f(156), f(157), f(158), f(159), f(160), f(161), f(162), f(163) &
    , f(164), f(165), f(166), f(167), f(168), f(169), f(170), f(171), f(172), f(173), f(174), f(175), f(176), f(177), f(178) &
    , f(179), f(180), f(181), f(182), f(183), f(184), f(185), f(186), f(187), f(188), f(189), f(190), f(191), 3*f(192), 3*f(193) &
    , 3*f(194), 3*f(195), 3*f(196), 3*f(197), f(198), 3*f(198), 3*f(199), 3*f(200), f(201), 3*f(201), 3*f(202), f(203), 3*f(203) &
    , 3*f(204), f(205), 3*f(205), 3*f(206), f(207), 3*f(207), 3*f(208), f(209), 3*f(209), f(210), 3*f(211), f(212), 3*f(213) &
    , 3*f(214), 3*f(215), f(216), 3*f(217), 3*f(218), 3*f(219), 3*f(220), 3*f(221), f(222), 3*f(222), 3*f(223), f(224), 3*f(224) &
    , f(225), f(226), f(227), 3*f(228), 3*f(229), 3*f(230), 3*f(231), 3*f(232), 3*f(233), f(234), f(235), 3*f(236), 3*f(237) &
    , 3*f(238), 3*f(239), 3*f(240) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MZ2)+L(6,5))
  den(2) = 1 /((L(5,10) - MZ2)+L(6,10))
  den(3) = 1 /((L(5,48) - MH2)+L(6,48))
  den(6) = 1 /((L(5,5))+L(6,5))
  den(7) = 1 /((L(5,10))+L(6,10))
  den(8) = 1 /((L(5,21) - MB2)+L(6,21))
  den(15) = 1 /((L(5,26) - MB2)+L(6,26))
  den(22) = 1 /((L(5,48))+L(6,48))
  den(23) = 1 /((L(5,7))+L(6,7))
  den(26) = 1 /((L(5,48) - MZ2)+L(6,48))
  den(31) = 1 /((L(5,50))+L(6,50))
  den(38) = 1 /((L(5,9) - MZ2)+L(6,9))
  den(39) = 1 /((L(5,6) - MZ2)+L(6,6))
  den(42) = 1 /((L(5,9))+L(6,9))
  den(43) = 1 /((L(5,6))+L(6,6))
  den(44) = 1 /((L(5,25) - MB2)+L(6,25))
  den(51) = 1 /((L(5,22) - MB2)+L(6,22))
  den(64) = 1 /((L(5,49))+L(6,49))
  den(71) = 1 /((L(5,11))+L(6,11))
  den(98) = 1 /((L(5,37) - MB2)+L(6,37))
  den(105) = 1 /((L(5,42) - MB2)+L(6,42))
  den(118) = 1 /((L(5,41) - MB2)+L(6,41))
  den(125) = 1 /((L(5,38) - MB2)+L(6,38))
  den(132) = 1 /((L(5,13))+L(6,13))
  den(139) = 1 /((L(5,56))+L(6,56))
  den(152) = 1 /((L(5,52))+L(6,52))
  den(163) = 1 /((L(5,14))+L(6,14))
  den(181) = 1 /((L(5,58) - MZ2)+L(6,58))
  den(186) = 1 /((L(5,53) - MZ2)+L(6,53))
  den(190) = 1 /((L(5,15) - MH2)+L(6,15))
  den(267) = 1 /((L(5,54) - MZ2)+L(6,54))
  den(272) = 1 /((L(5,57) - MZ2)+L(6,57))
  den(413) = 1 /((L(5,53) - MH2)+L(6,53))
  den(415) = 1 /((L(5,15))+L(6,15))
  den(417) = 1 /((L(5,15) - MZ2)+L(6,15))
  den(427) = 1 /((L(5,53))+L(6,53))
  den(439) = 1 /((L(5,54) - MH2)+L(6,54))
  den(451) = 1 /((L(5,54))+L(6,54))
  den(463) = 1 /((L(5,57) - MH2)+L(6,57))
  den(475) = 1 /((L(5,57))+L(6,57))
  den(487) = 1 /((L(5,58) - MH2)+L(6,58))
  den(499) = 1 /((L(5,58))+L(6,58))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(9) = den(6)*den(8)
  den(10) = den(7)*den(9)
  den(11) = den(2)*den(9)
  den(12) = den(1)*den(8)
  den(13) = den(7)*den(12)
  den(14) = den(2)*den(12)
  den(16) = den(7)*den(15)
  den(17) = den(6)*den(16)
  den(18) = den(2)*den(15)
  den(19) = den(6)*den(18)
  den(20) = den(1)*den(16)
  den(21) = den(1)*den(18)
  den(24) = den(6)*den(23)
  den(25) = den(22)*den(24)
  den(27) = den(24)*den(26)
  den(28) = den(1)*den(23)
  den(29) = den(22)*den(28)
  den(30) = den(26)*den(28)
  den(32) = den(22)*den(31)
  den(33) = den(6)*den(32)
  den(34) = den(26)*den(31)
  den(35) = den(6)*den(34)
  den(36) = den(1)*den(32)
  den(37) = den(1)*den(34)
  den(40) = den(38)*den(39)
  den(41) = den(3)*den(40)
  den(45) = den(42)*den(44)
  den(46) = den(43)*den(45)
  den(47) = den(39)*den(45)
  den(48) = den(38)*den(44)
  den(49) = den(43)*den(48)
  den(50) = den(39)*den(48)
  den(52) = den(43)*den(51)
  den(53) = den(42)*den(52)
  den(54) = den(39)*den(51)
  den(55) = den(42)*den(54)
  den(56) = den(38)*den(52)
  den(57) = den(38)*den(54)
  den(58) = den(23)*den(43)
  den(59) = den(22)*den(58)
  den(60) = den(26)*den(58)
  den(61) = den(23)*den(39)
  den(62) = den(22)*den(61)
  den(63) = den(26)*den(61)
  den(65) = den(22)*den(64)
  den(66) = den(43)*den(65)
  den(67) = den(39)*den(65)
  den(68) = den(26)*den(64)
  den(69) = den(43)*den(68)
  den(70) = den(39)*den(68)
  den(72) = den(42)*den(71)
  den(73) = den(22)*den(72)
  den(74) = den(26)*den(72)
  den(75) = den(38)*den(71)
  den(76) = den(22)*den(75)
  den(77) = den(26)*den(75)
  den(78) = den(32)*den(42)
  den(79) = den(34)*den(42)
  den(80) = den(32)*den(38)
  den(81) = den(34)*den(38)
  den(82) = den(7)*den(71)
  den(83) = den(22)*den(82)
  den(84) = den(26)*den(82)
  den(85) = den(2)*den(71)
  den(86) = den(22)*den(85)
  den(87) = den(26)*den(85)
  den(88) = den(7)*den(65)
  den(89) = den(2)*den(65)
  den(90) = den(7)*den(68)
  den(91) = den(2)*den(68)
  den(92) = den(6)*den(7)
  den(93) = den(3)*den(92)
  den(94) = den(2)*den(6)
  den(95) = den(3)*den(94)
  den(96) = den(1)*den(7)
  den(97) = den(3)*den(96)
  den(99) = den(6)*den(98)
  den(100) = den(7)*den(99)
  den(101) = den(2)*den(99)
  den(102) = den(1)*den(98)
  den(103) = den(7)*den(102)
  den(104) = den(2)*den(102)
  den(106) = den(7)*den(105)
  den(107) = den(6)*den(106)
  den(108) = den(2)*den(105)
  den(109) = den(6)*den(108)
  den(110) = den(1)*den(106)
  den(111) = den(1)*den(108)
  den(112) = den(42)*den(43)
  den(113) = den(3)*den(112)
  den(114) = den(39)*den(42)
  den(115) = den(3)*den(114)
  den(116) = den(38)*den(43)
  den(117) = den(3)*den(116)
  den(119) = den(42)*den(118)
  den(120) = den(43)*den(119)
  den(121) = den(39)*den(119)
  den(122) = den(38)*den(118)
  den(123) = den(43)*den(122)
  den(124) = den(39)*den(122)
  den(126) = den(43)*den(125)
  den(127) = den(42)*den(126)
  den(128) = den(39)*den(125)
  den(129) = den(42)*den(128)
  den(130) = den(38)*den(126)
  den(131) = den(38)*den(128)
  den(133) = den(6)*den(132)
  den(134) = den(22)*den(133)
  den(135) = den(26)*den(133)
  den(136) = den(1)*den(132)
  den(137) = den(22)*den(136)
  den(138) = den(26)*den(136)
  den(140) = den(22)*den(139)
  den(141) = den(6)*den(140)
  den(142) = den(26)*den(139)
  den(143) = den(6)*den(142)
  den(144) = den(1)*den(140)
  den(145) = den(1)*den(142)
  den(146) = den(42)*den(132)
  den(147) = den(22)*den(146)
  den(148) = den(26)*den(146)
  den(149) = den(38)*den(132)
  den(150) = den(22)*den(149)
  den(151) = den(26)*den(149)
  den(153) = den(22)*den(152)
  den(154) = den(42)*den(153)
  den(155) = den(26)*den(152)
  den(156) = den(42)*den(155)
  den(157) = den(38)*den(153)
  den(158) = den(38)*den(155)
  den(159) = den(43)*den(140)
  den(160) = den(43)*den(142)
  den(161) = den(39)*den(140)
  den(162) = den(39)*den(142)
  den(164) = den(43)*den(163)
  den(165) = den(22)*den(164)
  den(166) = den(39)*den(163)
  den(167) = den(22)*den(166)
  den(168) = den(26)*den(164)
  den(169) = den(26)*den(166)
  den(170) = den(7)*den(153)
  den(171) = den(7)*den(155)
  den(172) = den(2)*den(153)
  den(173) = den(2)*den(155)
  den(174) = den(7)*den(163)
  den(175) = den(22)*den(174)
  den(176) = den(2)*den(163)
  den(177) = den(22)*den(176)
  den(178) = den(26)*den(174)
  den(179) = den(26)*den(176)
  den(180) = den(2)*den(3)
  den(182) = den(180)*den(181)
  den(183) = den(6)*den(182)
  den(184) = den(1)*den(182)
  den(185) = den(1)*den(3)
  den(187) = den(185)*den(186)
  den(188) = den(7)*den(187)
  den(189) = den(2)*den(187)
  den(191) = den(4)*den(190)
  den(192) = den(3)*den(191)
  den(193) = den(1)*den(6)
  den(194) = den(106)*den(193)
  den(195) = den(108)*den(193)
  den(196) = den(1)**2
  den(197) = den(106)*den(196)
  den(198) = den(108)*den(196)
  den(199) = den(6)**2
  den(200) = den(106)*den(199)
  den(201) = den(108)*den(199)
  den(202) = den(16)*den(193)
  den(203) = den(18)*den(193)
  den(204) = den(16)*den(196)
  den(205) = den(18)*den(196)
  den(206) = den(16)*den(199)
  den(207) = den(18)*den(199)
  den(208) = den(2)*den(7)
  den(209) = den(99)*den(208)
  den(210) = den(102)*den(208)
  den(211) = den(2)**2
  den(212) = den(99)*den(211)
  den(213) = den(102)*den(211)
  den(214) = den(7)**2
  den(215) = den(99)*den(214)
  den(216) = den(102)*den(214)
  den(217) = den(9)*den(208)
  den(218) = den(12)*den(208)
  den(219) = den(9)*den(211)
  den(220) = den(12)*den(211)
  den(221) = den(9)*den(214)
  den(222) = den(12)*den(214)
  den(223) = den(9)*den(106)
  den(224) = den(9)*den(108)
  den(225) = den(12)*den(106)
  den(226) = den(12)*den(108)
  den(227) = den(16)*den(99)
  den(228) = den(18)*den(99)
  den(229) = den(16)*den(102)
  den(230) = den(18)*den(102)
  den(231) = den(140)*den(199)
  den(232) = den(142)*den(199)
  den(233) = den(140)*den(193)
  den(234) = den(142)*den(193)
  den(235) = den(140)*den(196)
  den(236) = den(142)*den(196)
  den(237) = den(32)*den(199)
  den(238) = den(34)*den(199)
  den(239) = den(32)*den(193)
  den(240) = den(34)*den(193)
  den(241) = den(32)*den(196)
  den(242) = den(34)*den(196)
  den(243) = den(24)*den(140)
  den(244) = den(24)*den(142)
  den(245) = den(28)*den(140)
  den(246) = den(28)*den(142)
  den(247) = den(32)*den(133)
  den(248) = den(34)*den(133)
  den(249) = den(32)*den(136)
  den(250) = den(34)*den(136)
  den(251) = den(22)*den(26)
  den(252) = den(133)*den(251)
  den(253) = den(136)*den(251)
  den(254) = den(26)**2
  den(255) = den(133)*den(254)
  den(256) = den(136)*den(254)
  den(257) = den(22)**2
  den(258) = den(133)*den(257)
  den(259) = den(136)*den(257)
  den(260) = den(24)*den(251)
  den(261) = den(28)*den(251)
  den(262) = den(24)*den(254)
  den(263) = den(28)*den(254)
  den(264) = den(24)*den(257)
  den(265) = den(28)*den(257)
  den(266) = den(3)*den(39)
  den(268) = den(266)*den(267)
  den(269) = den(42)*den(268)
  den(270) = den(38)*den(268)
  den(271) = den(3)*den(38)
  den(273) = den(271)*den(272)
  den(274) = den(43)*den(273)
  den(275) = den(39)*den(273)
  den(276) = den(40)*den(190)
  den(277) = den(3)*den(276)
  den(278) = den(38)*den(42)
  den(279) = den(126)*den(278)
  den(280) = den(128)*den(278)
  den(281) = den(38)**2
  den(282) = den(126)*den(281)
  den(283) = den(128)*den(281)
  den(284) = den(42)**2
  den(285) = den(126)*den(284)
  den(286) = den(128)*den(284)
  den(287) = den(52)*den(278)
  den(288) = den(54)*den(278)
  den(289) = den(52)*den(281)
  den(290) = den(54)*den(281)
  den(291) = den(52)*den(284)
  den(292) = den(54)*den(284)
  den(293) = den(39)*den(43)
  den(294) = den(119)*den(293)
  den(295) = den(122)*den(293)
  den(296) = den(39)**2
  den(297) = den(119)*den(296)
  den(298) = den(122)*den(296)
  den(299) = den(43)**2
  den(300) = den(119)*den(299)
  den(301) = den(122)*den(299)
  den(302) = den(45)*den(293)
  den(303) = den(48)*den(293)
  den(304) = den(45)*den(296)
  den(305) = den(48)*den(296)
  den(306) = den(45)*den(299)
  den(307) = den(48)*den(299)
  den(308) = den(45)*den(126)
  den(309) = den(45)*den(128)
  den(310) = den(48)*den(126)
  den(311) = den(48)*den(128)
  den(312) = den(52)*den(119)
  den(313) = den(54)*den(119)
  den(314) = den(52)*den(122)
  den(315) = den(54)*den(122)
  den(316) = den(140)*den(299)
  den(317) = den(142)*den(299)
  den(318) = den(140)*den(293)
  den(319) = den(142)*den(293)
  den(320) = den(140)*den(296)
  den(321) = den(142)*den(296)
  den(322) = den(58)*den(140)
  den(323) = den(58)*den(142)
  den(324) = den(61)*den(140)
  den(325) = den(61)*den(142)
  den(326) = den(65)*den(164)
  den(327) = den(65)*den(166)
  den(328) = den(68)*den(164)
  den(329) = den(68)*den(166)
  den(330) = den(164)*den(251)
  den(331) = den(166)*den(251)
  den(332) = den(164)*den(254)
  den(333) = den(166)*den(254)
  den(334) = den(164)*den(257)
  den(335) = den(166)*den(257)
  den(336) = den(65)*den(299)
  den(337) = den(68)*den(299)
  den(338) = den(65)*den(293)
  den(339) = den(68)*den(293)
  den(340) = den(65)*den(296)
  den(341) = den(68)*den(296)
  den(342) = den(58)*den(251)
  den(343) = den(61)*den(251)
  den(344) = den(58)*den(254)
  den(345) = den(61)*den(254)
  den(346) = den(58)*den(257)
  den(347) = den(61)*den(257)
  den(348) = den(153)*den(284)
  den(349) = den(155)*den(284)
  den(350) = den(153)*den(278)
  den(351) = den(155)*den(278)
  den(352) = den(153)*den(281)
  den(353) = den(155)*den(281)
  den(354) = den(32)*den(284)
  den(355) = den(34)*den(284)
  den(356) = den(32)*den(278)
  den(357) = den(34)*den(278)
  den(358) = den(32)*den(281)
  den(359) = den(34)*den(281)
  den(360) = den(72)*den(153)
  den(361) = den(72)*den(155)
  den(362) = den(75)*den(153)
  den(363) = den(75)*den(155)
  den(364) = den(32)*den(146)
  den(365) = den(34)*den(146)
  den(366) = den(32)*den(149)
  den(367) = den(34)*den(149)
  den(368) = den(146)*den(251)
  den(369) = den(149)*den(251)
  den(370) = den(146)*den(254)
  den(371) = den(149)*den(254)
  den(372) = den(146)*den(257)
  den(373) = den(149)*den(257)
  den(374) = den(72)*den(251)
  den(375) = den(75)*den(251)
  den(376) = den(72)*den(254)
  den(377) = den(75)*den(254)
  den(378) = den(72)*den(257)
  den(379) = den(75)*den(257)
  den(380) = den(153)*den(214)
  den(381) = den(155)*den(214)
  den(382) = den(153)*den(208)
  den(383) = den(155)*den(208)
  den(384) = den(153)*den(211)
  den(385) = den(155)*den(211)
  den(386) = den(82)*den(153)
  den(387) = den(82)*den(155)
  den(388) = den(85)*den(153)
  den(389) = den(85)*den(155)
  den(390) = den(65)*den(174)
  den(391) = den(65)*den(176)
  den(392) = den(68)*den(174)
  den(393) = den(68)*den(176)
  den(394) = den(174)*den(251)
  den(395) = den(176)*den(251)
  den(396) = den(174)*den(254)
  den(397) = den(176)*den(254)
  den(398) = den(174)*den(257)
  den(399) = den(176)*den(257)
  den(400) = den(65)*den(214)
  den(401) = den(68)*den(214)
  den(402) = den(65)*den(208)
  den(403) = den(68)*den(208)
  den(404) = den(65)*den(211)
  den(405) = den(68)*den(211)
  den(406) = den(82)*den(251)
  den(407) = den(85)*den(251)
  den(408) = den(82)*den(254)
  den(409) = den(85)*den(254)
  den(410) = den(82)*den(257)
  den(411) = den(85)*den(257)
  den(412) = den(1)*den(26)
  den(414) = den(412)*den(413)
  den(416) = den(24)*den(415)
  den(418) = den(24)*den(417)
  den(419) = den(28)*den(415)
  den(420) = den(28)*den(417)
  den(421) = den(133)*den(415)
  den(422) = den(133)*den(417)
  den(423) = den(136)*den(415)
  den(424) = den(136)*den(417)
  den(425) = den(9)*den(413)
  den(426) = den(12)*den(413)
  den(428) = den(9)*den(427)
  den(429) = den(9)*den(186)
  den(430) = den(12)*den(427)
  den(431) = den(12)*den(186)
  den(432) = den(99)*den(413)
  den(433) = den(102)*den(413)
  den(434) = den(99)*den(427)
  den(435) = den(99)*den(186)
  den(436) = den(102)*den(427)
  den(437) = den(102)*den(186)
  den(438) = den(26)*den(39)
  den(440) = den(438)*den(439)
  den(441) = den(58)*den(415)
  den(442) = den(58)*den(417)
  den(443) = den(61)*den(415)
  den(444) = den(61)*den(417)
  den(445) = den(164)*den(415)
  den(446) = den(166)*den(415)
  den(447) = den(164)*den(417)
  den(448) = den(166)*den(417)
  den(449) = den(52)*den(439)
  den(450) = den(54)*den(439)
  den(452) = den(52)*den(451)
  den(453) = den(52)*den(267)
  den(454) = den(54)*den(451)
  den(455) = den(54)*den(267)
  den(456) = den(126)*den(439)
  den(457) = den(128)*den(439)
  den(458) = den(126)*den(451)
  den(459) = den(126)*den(267)
  den(460) = den(128)*den(451)
  den(461) = den(128)*den(267)
  den(462) = den(26)*den(38)
  den(464) = den(462)*den(463)
  den(465) = den(72)*den(415)
  den(466) = den(72)*den(417)
  den(467) = den(75)*den(415)
  den(468) = den(75)*den(417)
  den(469) = den(146)*den(415)
  den(470) = den(146)*den(417)
  den(471) = den(149)*den(415)
  den(472) = den(149)*den(417)
  den(473) = den(45)*den(463)
  den(474) = den(48)*den(463)
  den(476) = den(45)*den(475)
  den(477) = den(45)*den(272)
  den(478) = den(48)*den(475)
  den(479) = den(48)*den(272)
  den(480) = den(119)*den(463)
  den(481) = den(122)*den(463)
  den(482) = den(119)*den(475)
  den(483) = den(119)*den(272)
  den(484) = den(122)*den(475)
  den(485) = den(122)*den(272)
  den(486) = den(2)*den(26)
  den(488) = den(486)*den(487)
  den(489) = den(82)*den(415)
  den(490) = den(82)*den(417)
  den(491) = den(85)*den(415)
  den(492) = den(85)*den(417)
  den(493) = den(174)*den(415)
  den(494) = den(176)*den(415)
  den(495) = den(174)*den(417)
  den(496) = den(176)*den(417)
  den(497) = den(16)*den(487)
  den(498) = den(18)*den(487)
  den(500) = den(16)*den(499)
  den(501) = den(16)*den(181)
  den(502) = den(18)*den(499)
  den(503) = den(18)*den(181)
  den(504) = den(106)*den(487)
  den(505) = den(108)*den(487)
  den(506) = den(106)*den(499)
  den(507) = den(106)*den(181)
  den(508) = den(108)*den(499)
  den(509) = den(108)*den(181)
  den(510) = den(65)*den(427)
  den(511) = den(65)*den(186)
  den(512) = den(68)*den(427)
  den(513) = den(68)*den(186)
  den(514) = den(153)*den(427)
  den(515) = den(155)*den(427)
  den(516) = den(153)*den(186)
  den(517) = den(155)*den(186)
  den(518) = den(65)*den(475)
  den(519) = den(65)*den(272)
  den(520) = den(68)*den(475)
  den(521) = den(68)*den(272)
  den(522) = den(140)*den(475)
  den(523) = den(142)*den(475)
  den(524) = den(140)*den(272)
  den(525) = den(142)*den(272)
  den(526) = den(32)*den(451)
  den(527) = den(32)*den(267)
  den(528) = den(34)*den(451)
  den(529) = den(34)*den(267)
  den(530) = den(153)*den(451)
  den(531) = den(155)*den(451)
  den(532) = den(153)*den(267)
  den(533) = den(155)*den(267)
  den(534) = den(32)*den(499)
  den(535) = den(32)*den(181)
  den(536) = den(34)*den(499)
  den(537) = den(34)*den(181)
  den(538) = den(140)*den(499)
  den(539) = den(142)*den(499)
  den(540) = den(140)*den(181)
  den(541) = den(142)*den(181)
  den(542) = den(6)*den(22)
  den(543) = den(6)*den(26)
  den(544) = den(1)*den(22)
  den(545) = den(22)*den(43)
  den(546) = den(26)*den(43)
  den(547) = den(22)*den(39)
  den(548) = den(22)*den(42)
  den(549) = den(26)*den(42)
  den(550) = den(22)*den(38)
  den(551) = den(7)*den(22)
  den(552) = den(7)*den(26)
  den(553) = den(2)*den(22)
  den(554) = den(3)*den(6)*den(7)
  den(555) = den(6)*den(7)*den(26)
  den(556) = den(2)*den(3)*den(6)
  den(557) = den(2)*den(6)*den(26)
  den(558) = den(1)*den(3)*den(7)
  den(559) = den(1)*den(7)*den(26)
  den(560) = den(1)*den(2)*den(3)
  den(561) = den(1)*den(2)*den(26)
  den(562) = den(6)*den(7)*den(22)
  den(563) = den(2)*den(6)*den(22)
  den(564) = den(1)*den(7)*den(22)
  den(565) = den(1)*den(2)*den(22)
  den(566) = den(3)*den(24)
  den(567) = den(3)*den(28)
  den(568) = den(3)*den(133)
  den(569) = den(3)*den(136)
  den(570) = den(3)*den(6)
  den(571) = den(3)*den(42)*den(43)
  den(572) = den(26)*den(42)*den(43)
  den(573) = den(3)*den(39)*den(42)
  den(574) = den(26)*den(39)*den(42)
  den(575) = den(3)*den(38)*den(43)
  den(576) = den(26)*den(38)*den(43)
  den(577) = den(3)*den(38)*den(39)
  den(578) = den(26)*den(38)*den(39)
  den(579) = den(22)*den(42)*den(43)
  den(580) = den(22)*den(39)*den(42)
  den(581) = den(22)*den(38)*den(43)
  den(582) = den(22)*den(38)*den(39)
  den(583) = den(3)*den(58)
  den(584) = den(3)*den(61)
  den(585) = den(3)*den(164)
  den(586) = den(3)*den(166)
  den(587) = den(3)*den(43)
  den(588) = den(3)*den(72)
  den(589) = den(3)*den(75)
  den(590) = den(3)*den(146)
  den(591) = den(3)*den(149)
  den(592) = den(3)*den(42)
  den(593) = den(3)*den(82)
  den(594) = den(3)*den(85)
  den(595) = den(3)*den(174)
  den(596) = den(3)*den(176)
  den(597) = den(3)*den(7)
  den(598) = den(6)*den(597)
  den(599) = den(6)*den(552)
  den(600) = den(6)*den(180)
  den(601) = den(6)*den(486)
  den(602) = den(1)*den(597)
  den(603) = den(1)*den(552)
  den(604) = den(1)*den(180)
  den(605) = den(1)*den(486)
  den(606) = den(6)*den(551)
  den(607) = den(6)*den(553)
  den(608) = den(1)*den(551)
  den(609) = den(1)*den(553)
  den(610) = den(7)*den(570)
  den(611) = den(7)*den(543)
  den(612) = den(2)*den(570)
  den(613) = den(2)*den(543)
  den(614) = den(7)*den(185)
  den(615) = den(7)*den(412)
  den(616) = den(2)*den(185)
  den(617) = den(2)*den(412)
  den(618) = den(7)*den(542)
  den(619) = den(2)*den(542)
  den(620) = den(7)*den(544)
  den(621) = den(2)*den(544)
  den(622) = den(22)*den(92)
  den(623) = den(26)*den(92)
  den(624) = den(22)*den(94)
  den(625) = den(26)*den(94)
  den(626) = den(22)*den(96)
  den(627) = den(26)*den(96)
  den(628) = den(4)*den(22)
  den(629) = den(4)*den(26)
  den(630) = den(42)*den(587)
  den(631) = den(42)*den(546)
  den(632) = den(42)*den(266)
  den(633) = den(42)*den(438)
  den(634) = den(38)*den(587)
  den(635) = den(38)*den(546)
  den(636) = den(38)*den(266)
  den(637) = den(38)*den(438)
  den(638) = den(42)*den(545)
  den(639) = den(42)*den(547)
  den(640) = den(38)*den(545)
  den(641) = den(38)*den(547)
  den(642) = den(43)*den(592)
  den(643) = den(43)*den(549)
  den(644) = den(39)*den(592)
  den(645) = den(39)*den(549)
  den(646) = den(43)*den(271)
  den(647) = den(43)*den(462)
  den(648) = den(39)*den(271)
  den(649) = den(39)*den(462)
  den(650) = den(43)*den(548)
  den(651) = den(39)*den(548)
  den(652) = den(43)*den(550)
  den(653) = den(39)*den(550)
  den(654) = den(22)*den(112)
  den(655) = den(26)*den(112)
  den(656) = den(22)*den(114)
  den(657) = den(26)*den(114)
  den(658) = den(22)*den(116)
  den(659) = den(26)*den(116)
  den(660) = den(22)*den(40)
  den(661) = den(26)*den(40)
  den(662) = den(26)*den(191)
  den(663) = den(22)*den(191)
  den(664) = den(7)*den(414)
  den(665) = den(2)*den(414)
  den(666) = den(6)*den(488)
  den(667) = den(1)*den(488)
  den(668) = den(7)*den(425)
  den(669) = den(7)*den(429)
  den(670) = den(2)*den(425)
  den(671) = den(2)*den(429)
  den(672) = den(7)*den(426)
  den(673) = den(7)*den(431)
  den(674) = den(2)*den(426)
  den(675) = den(2)*den(431)
  den(676) = den(7)*den(428)
  den(677) = den(2)*den(428)
  den(678) = den(7)*den(430)
  den(679) = den(2)*den(430)
  den(680) = den(7)*den(432)
  den(681) = den(7)*den(435)
  den(682) = den(2)*den(432)
  den(683) = den(2)*den(435)
  den(684) = den(7)*den(433)
  den(685) = den(7)*den(437)
  den(686) = den(2)*den(433)
  den(687) = den(2)*den(437)
  den(688) = den(7)*den(434)
  den(689) = den(2)*den(434)
  den(690) = den(7)*den(436)
  den(691) = den(2)*den(436)
  den(692) = den(6)*den(497)
  den(693) = den(6)*den(501)
  den(694) = den(6)*den(498)
  den(695) = den(6)*den(503)
  den(696) = den(1)*den(497)
  den(697) = den(1)*den(501)
  den(698) = den(1)*den(498)
  den(699) = den(1)*den(503)
  den(700) = den(6)*den(500)
  den(701) = den(6)*den(502)
  den(702) = den(1)*den(500)
  den(703) = den(1)*den(502)
  den(704) = den(6)*den(504)
  den(705) = den(6)*den(507)
  den(706) = den(6)*den(505)
  den(707) = den(6)*den(509)
  den(708) = den(1)*den(504)
  den(709) = den(1)*den(507)
  den(710) = den(1)*den(505)
  den(711) = den(1)*den(509)
  den(712) = den(6)*den(506)
  den(713) = den(6)*den(508)
  den(714) = den(1)*den(506)
  den(715) = den(1)*den(508)
  den(716) = den(3)*den(416)
  den(717) = den(26)*den(416)
  den(718) = den(3)*den(418)
  den(719) = den(26)*den(418)
  den(720) = den(3)*den(419)
  den(721) = den(26)*den(419)
  den(722) = den(3)*den(420)
  den(723) = den(26)*den(420)
  den(724) = den(22)*den(416)
  den(725) = den(22)*den(418)
  den(726) = den(22)*den(419)
  den(727) = den(22)*den(420)
  den(728) = den(3)*den(421)
  den(729) = den(26)*den(421)
  den(730) = den(3)*den(422)
  den(731) = den(26)*den(422)
  den(732) = den(3)*den(423)
  den(733) = den(26)*den(423)
  den(734) = den(3)*den(424)
  den(735) = den(26)*den(424)
  den(736) = den(22)*den(421)
  den(737) = den(22)*den(422)
  den(738) = den(22)*den(423)
  den(739) = den(22)*den(424)
  den(740) = den(6)*den(534)
  den(741) = den(6)*den(535)
  den(742) = den(6)*den(536)
  den(743) = den(6)*den(537)
  den(744) = den(1)*den(534)
  den(745) = den(1)*den(535)
  den(746) = den(1)*den(536)
  den(747) = den(1)*den(537)
  den(748) = den(6)*den(538)
  den(749) = den(6)*den(539)
  den(750) = den(6)*den(540)
  den(751) = den(6)*den(541)
  den(752) = den(1)*den(538)
  den(753) = den(1)*den(539)
  den(754) = den(1)*den(540)
  den(755) = den(1)*den(541)
  den(756) = den(26)*den(276)
  den(757) = den(22)*den(276)
  den(758) = den(43)*den(464)
  den(759) = den(39)*den(464)
  den(760) = den(42)*den(440)
  den(761) = den(38)*den(440)
  den(762) = den(43)*den(473)
  den(763) = den(43)*den(477)
  den(764) = den(39)*den(473)
  den(765) = den(39)*den(477)
  den(766) = den(43)*den(474)
  den(767) = den(43)*den(479)
  den(768) = den(39)*den(474)
  den(769) = den(39)*den(479)
  den(770) = den(43)*den(476)
  den(771) = den(39)*den(476)
  den(772) = den(43)*den(478)
  den(773) = den(39)*den(478)
  den(774) = den(43)*den(480)
  den(775) = den(43)*den(483)
  den(776) = den(39)*den(480)
  den(777) = den(39)*den(483)
  den(778) = den(43)*den(481)
  den(779) = den(43)*den(485)
  den(780) = den(39)*den(481)
  den(781) = den(39)*den(485)
  den(782) = den(43)*den(482)
  den(783) = den(39)*den(482)
  den(784) = den(43)*den(484)
  den(785) = den(39)*den(484)
  den(786) = den(42)*den(449)
  den(787) = den(42)*den(453)
  den(788) = den(42)*den(450)
  den(789) = den(42)*den(455)
  den(790) = den(38)*den(449)
  den(791) = den(38)*den(453)
  den(792) = den(38)*den(450)
  den(793) = den(38)*den(455)
  den(794) = den(42)*den(452)
  den(795) = den(42)*den(454)
  den(796) = den(38)*den(452)
  den(797) = den(38)*den(454)
  den(798) = den(42)*den(456)
  den(799) = den(42)*den(459)
  den(800) = den(42)*den(457)
  den(801) = den(42)*den(461)
  den(802) = den(38)*den(456)
  den(803) = den(38)*den(459)
  den(804) = den(38)*den(457)
  den(805) = den(38)*den(461)
  den(806) = den(42)*den(458)
  den(807) = den(42)*den(460)
  den(808) = den(38)*den(458)
  den(809) = den(38)*den(460)
  den(810) = den(3)*den(441)
  den(811) = den(26)*den(441)
  den(812) = den(3)*den(442)
  den(813) = den(26)*den(442)
  den(814) = den(3)*den(443)
  den(815) = den(26)*den(443)
  den(816) = den(3)*den(444)
  den(817) = den(26)*den(444)
  den(818) = den(22)*den(441)
  den(819) = den(22)*den(442)
  den(820) = den(22)*den(443)
  den(821) = den(22)*den(444)
  den(822) = den(43)*den(518)
  den(823) = den(43)*den(519)
  den(824) = den(39)*den(518)
  den(825) = den(39)*den(519)
  den(826) = den(43)*den(520)
  den(827) = den(43)*den(521)
  den(828) = den(39)*den(520)
  den(829) = den(39)*den(521)
  den(830) = den(3)*den(445)
  den(831) = den(26)*den(445)
  den(832) = den(3)*den(446)
  den(833) = den(26)*den(446)
  den(834) = den(3)*den(447)
  den(835) = den(26)*den(447)
  den(836) = den(3)*den(448)
  den(837) = den(26)*den(448)
  den(838) = den(22)*den(445)
  den(839) = den(22)*den(446)
  den(840) = den(22)*den(447)
  den(841) = den(22)*den(448)
  den(842) = den(43)*den(522)
  den(843) = den(43)*den(523)
  den(844) = den(39)*den(522)
  den(845) = den(39)*den(523)
  den(846) = den(43)*den(524)
  den(847) = den(43)*den(525)
  den(848) = den(39)*den(524)
  den(849) = den(39)*den(525)
  den(850) = den(3)*den(465)
  den(851) = den(26)*den(465)
  den(852) = den(3)*den(466)
  den(853) = den(26)*den(466)
  den(854) = den(3)*den(467)
  den(855) = den(26)*den(467)
  den(856) = den(3)*den(468)
  den(857) = den(26)*den(468)
  den(858) = den(22)*den(465)
  den(859) = den(22)*den(466)
  den(860) = den(22)*den(467)
  den(861) = den(22)*den(468)
  den(862) = den(3)*den(469)
  den(863) = den(26)*den(469)
  den(864) = den(3)*den(470)
  den(865) = den(26)*den(470)
  den(866) = den(3)*den(471)
  den(867) = den(26)*den(471)
  den(868) = den(3)*den(472)
  den(869) = den(26)*den(472)
  den(870) = den(22)*den(469)
  den(871) = den(22)*den(470)
  den(872) = den(22)*den(471)
  den(873) = den(22)*den(472)
  den(874) = den(42)*den(526)
  den(875) = den(42)*den(527)
  den(876) = den(42)*den(528)
  den(877) = den(42)*den(529)
  den(878) = den(38)*den(526)
  den(879) = den(38)*den(527)
  den(880) = den(38)*den(528)
  den(881) = den(38)*den(529)
  den(882) = den(42)*den(530)
  den(883) = den(42)*den(531)
  den(884) = den(42)*den(532)
  den(885) = den(42)*den(533)
  den(886) = den(38)*den(530)
  den(887) = den(38)*den(531)
  den(888) = den(38)*den(532)
  den(889) = den(38)*den(533)
  den(890) = den(3)*den(489)
  den(891) = den(26)*den(489)
  den(892) = den(3)*den(490)
  den(893) = den(26)*den(490)
  den(894) = den(3)*den(491)
  den(895) = den(26)*den(491)
  den(896) = den(3)*den(492)
  den(897) = den(26)*den(492)
  den(898) = den(22)*den(489)
  den(899) = den(22)*den(490)
  den(900) = den(22)*den(491)
  den(901) = den(22)*den(492)
  den(902) = den(7)*den(510)
  den(903) = den(7)*den(511)
  den(904) = den(2)*den(510)
  den(905) = den(2)*den(511)
  den(906) = den(7)*den(512)
  den(907) = den(7)*den(513)
  den(908) = den(2)*den(512)
  den(909) = den(2)*den(513)
  den(910) = den(3)*den(493)
  den(911) = den(26)*den(493)
  den(912) = den(3)*den(494)
  den(913) = den(26)*den(494)
  den(914) = den(3)*den(495)
  den(915) = den(26)*den(495)
  den(916) = den(3)*den(496)
  den(917) = den(26)*den(496)
  den(918) = den(22)*den(493)
  den(919) = den(22)*den(494)
  den(920) = den(22)*den(495)
  den(921) = den(22)*den(496)
  den(922) = den(7)*den(514)
  den(923) = den(7)*den(515)
  den(924) = den(2)*den(514)
  den(925) = den(2)*den(515)
  den(926) = den(7)*den(516)
  den(927) = den(7)*den(517)
  den(928) = den(2)*den(516)
  den(929) = den(2)*den(517)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_ew_eeexexbbx_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,578))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppllll_ew_eeexexbbx_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e- e+ e+ bottom anti-bottom -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppllll_ew_eeexexbbx_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllll_ew_eeexexbbx_1, only: &
    & external_perm_ppllll_ew_eeexexbbx_1, &
    & external_perm_inv_ppllll_ew_eeexexbbx_1, &
    & extcomb_perm_ppllll_ew_eeexexbbx_1, &
    & average_factor_ppllll_ew_eeexexbbx_1
  use ol_external_ppllll_ew_eeexexbbx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllll_ew_eeexexbbx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllll_ew_eeexexbbx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppllll_ew_eeexexbbx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 6 > 3
  integer :: ind_cc_comb(9)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(578)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,578))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, nMB, nMB ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppllll_ew_eeexexbbx_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rMB, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rMB, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_Z(gZl,ntry, ex1(:), ex3(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_Z(gZl,ntry, ex2(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AQ_S(gH,ntry, ex6(:), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,2), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_QA_V(ntry, ex1(:), ex3(:), wf4(:,4), n3(:,5), t3x4(:,:,4))
  call vert_QA_V(ntry, ex2(:), ex4(:), wf4(:,5), n3(:,6), t3x4(:,:,5))
  call vert_VQ_A(ntry, wf4(:,4), ex5(:), wf8(:,1), n3(:,7), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,5), wf8(:,2), n3(:,8), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 21, MB, 1_intkind1, wf8(:,3), n2(1))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,2), wf8(:,4), n3(:,9), t3x8(:,:,3))
  call vert_ZQ_A(gZd,ntry, wf4(:,1), ex5(:), wf8(:,5), n3(:,10), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,5), 21, MB, 1_intkind1, wf8(:,6), n2(2))
  call vert_VQ_A(ntry, wf4(:,5), ex5(:), wf8(:,7), n3(:,11), t3x8(:,:,5))
  call vert_AV_Q(ntry, ex6(:), wf4(:,4), wf8(:,8), n3(:,12), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), 26, MB, 1_intkind1, wf8(:,9), n2(3))
  call vert_ZQ_A(gZd,ntry, wf4(:,2), ex5(:), wf8(:,10), n3(:,13), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,10), 26, MB, 1_intkind1, wf8(:,11), n2(4))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,1), wf8(:,12), n3(:,14), t3x8(:,:,8))
  call vert_QA_V(ntry, ex5(:), ex6(:), wf4(:,6), n3(:,15), t3x4(:,:,6))
  call vert_VQ_A(ntry, wf4(:,4), ex2(:), wf8(:,13), n3(:,16), t3x8(:,:,9))
  call vert_AV_Q(ntry, ex4(:), wf4(:,6), wf8(:,14), n3(:,17), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,13), 7, ZERO, 0_intkind1, wf8(:,15), n2(5))
  call vert_QA_Z(gZd,ntry, ex5(:), ex6(:), wf4(:,7), n3(:,18), t3x4(:,:,7))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,7), wf8(:,16), n3(:,19), t3x8(:,:,11))
  call vert_ZQ_A(gZl,ntry, wf4(:,1), ex2(:), wf8(:,17), n3(:,20), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,17), 7, ZERO, 0_intkind1, wf8(:,18), n2(6))
  call vert_VQ_A(ntry, wf4(:,6), ex2(:), wf8(:,19), n3(:,21), t3x8(:,:,13))
  call vert_AV_Q(ntry, ex4(:), wf4(:,4), wf8(:,20), n3(:,22), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,19), 50, ZERO, 0_intkind1, wf8(:,21), n2(7))
  call vert_ZQ_A(gZl,ntry, wf4(:,7), ex2(:), wf8(:,22), n3(:,23), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,22), 50, ZERO, 0_intkind1, wf8(:,23), n2(8))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,1), wf8(:,24), n3(:,24), t3x8(:,:,16))
  call vert_QA_Z(gZl,ntry, ex1(:), ex4(:), wf4(:,8), n3(:,25), t3x4(:,:,8))
  call vert_QA_Z(gZl,ntry, ex2(:), ex3(:), wf4(:,9), n3(:,26), t3x4(:,:,9))
  call vert_VV_S(ntry, wf4(:,9), wf4(:,8), wf16(:,2), n3(:,27), t3x16(:,:,2))
  call vert_QA_V(ntry, ex1(:), ex4(:), wf4(:,10), n3(:,28), t3x4(:,:,10))
  call vert_QA_V(ntry, ex2(:), ex3(:), wf4(:,11), n3(:,29), t3x4(:,:,11))
  call vert_VQ_A(ntry, wf4(:,10), ex5(:), wf8(:,25), n3(:,30), t3x8(:,:,17))
  call vert_AV_Q(ntry, ex6(:), wf4(:,11), wf8(:,26), n3(:,31), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,25), 25, MB, 1_intkind1, wf8(:,27), n2(9))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,9), wf8(:,28), n3(:,32), t3x8(:,:,19))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), ex5(:), wf8(:,29), n3(:,33), t3x8(:,:,20))
  call prop_Q_A(ntry, wf8(:,29), 25, MB, 1_intkind1, wf8(:,30), n2(10))
  call vert_VQ_A(ntry, wf4(:,11), ex5(:), wf8(:,31), n3(:,34), t3x8(:,:,21))
  call vert_AV_Q(ntry, ex6(:), wf4(:,10), wf8(:,32), n3(:,35), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,31), 22, MB, 1_intkind1, wf8(:,33), n2(11))
  call vert_ZQ_A(gZd,ntry, wf4(:,9), ex5(:), wf8(:,34), n3(:,36), t3x8(:,:,23))
  call prop_Q_A(ntry, wf8(:,34), 22, MB, 1_intkind1, wf8(:,35), n2(12))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,8), wf8(:,36), n3(:,37), t3x8(:,:,24))
  call vert_VQ_A(ntry, wf4(:,11), ex1(:), wf8(:,37), n3(:,38), t3x8(:,:,25))
  call prop_Q_A(ntry, wf8(:,37), 7, ZERO, 0_intkind1, wf8(:,38), n2(13))
  call vert_ZQ_A(gZl,ntry, wf4(:,9), ex1(:), wf8(:,39), n3(:,39), t3x8(:,:,26))
  call prop_Q_A(ntry, wf8(:,39), 7, ZERO, 0_intkind1, wf8(:,40), n2(14))
  call vert_VQ_A(ntry, wf4(:,6), ex1(:), wf8(:,41), n3(:,40), t3x8(:,:,27))
  call vert_AV_Q(ntry, ex4(:), wf4(:,11), wf8(:,42), n3(:,41), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,41), 49, ZERO, 0_intkind1, wf8(:,43), n2(15))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,9), wf8(:,44), n3(:,42), t3x8(:,:,29))
  call vert_ZQ_A(gZl,ntry, wf4(:,7), ex1(:), wf8(:,45), n3(:,43), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,45), 49, ZERO, 0_intkind1, wf8(:,46), n2(16))
  call vert_VQ_A(ntry, wf4(:,10), ex2(:), wf8(:,47), n3(:,44), t3x8(:,:,31))
  call vert_AV_Q(ntry, ex3(:), wf4(:,6), wf8(:,48), n3(:,45), t3x8(:,:,32))
  call prop_Q_A(ntry, wf8(:,47), 11, ZERO, 0_intkind1, wf8(:,49), n2(17))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,7), wf8(:,50), n3(:,46), t3x8(:,:,33))
  call vert_ZQ_A(gZl,ntry, wf4(:,8), ex2(:), wf8(:,51), n3(:,47), t3x8(:,:,34))
  call prop_Q_A(ntry, wf8(:,51), 11, ZERO, 0_intkind1, wf8(:,52), n2(18))
  call vert_AV_Q(ntry, ex3(:), wf4(:,10), wf8(:,53), n3(:,48), t3x8(:,:,35))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,8), wf8(:,54), n3(:,49), t3x8(:,:,36))
  call vert_VQ_A(ntry, wf4(:,5), ex1(:), wf8(:,55), n3(:,50), t3x8(:,:,37))
  call prop_Q_A(ntry, wf8(:,55), 11, ZERO, 0_intkind1, wf8(:,56), n2(19))
  call vert_ZQ_A(gZl,ntry, wf4(:,2), ex1(:), wf8(:,57), n3(:,51), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,57), 11, ZERO, 0_intkind1, wf8(:,58), n2(20))
  call vert_AV_Q(ntry, ex3(:), wf4(:,5), wf8(:,59), n3(:,52), t3x8(:,:,39))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,2), wf8(:,60), n3(:,53), t3x8(:,:,40))
  call counter_VV_S(ntry, wf4(:,4), wf4(:,5), wf16(:,3), n3(:,54), t3x16(:,:,3))
  call counter_VV_S(ntry, wf4(:,4), wf4(:,2), wf16(:,4), n3(:,55), t3x16(:,:,4))
  call counter_VV_S(ntry, wf4(:,1), wf4(:,5), wf16(:,5), n3(:,56), t3x16(:,:,5))
  call counter_VV_S(ntry, wf4(:,1), wf4(:,2), wf16(:,6), n3(:,57), t3x16(:,:,6))
  call counter_AV_Q_LR(EWctAbb,ntry, ex6(:), wf4(:,5), wf8(:,61), n3(:,58), t3x8(:,:,41))
  call counter_AZ_Q(EWctVbb,ntry, ex6(:), wf4(:,2), wf8(:,62), n3(:,59), t3x8(:,:,42))
  call counter_AV_Q_LR(EWctAbb,ntry, ex6(:), wf4(:,4), wf8(:,63), n3(:,60), t3x8(:,:,43))
  call counter_AZ_Q(EWctVbb,ntry, ex6(:), wf4(:,1), wf8(:,64), n3(:,61), t3x8(:,:,44))
  call counter_VQ_A_LR(EWctAbb,ntry, wf4(:,5), ex5(:), wf8(:,65), n3(:,62), t3x8(:,:,45))
  call prop_A_Q(ntry, wf8(:,8), 37, MB, 1_intkind1, wf8(:,66), n2(21))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,2), ex5(:), wf8(:,67), n3(:,63), t3x8(:,:,46))
  call prop_A_Q(ntry, wf8(:,12), 37, MB, 1_intkind1, wf8(:,68), n2(22))
  call counter_VQ_A_LR(EWctAbb,ntry, wf4(:,4), ex5(:), wf8(:,69), n3(:,64), t3x8(:,:,47))
  call prop_A_Q(ntry, wf8(:,2), 42, MB, 1_intkind1, wf8(:,70), n2(23))
  call prop_A_Q(ntry, wf8(:,4), 42, MB, 1_intkind1, wf8(:,71), n2(24))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,1), ex5(:), wf8(:,72), n3(:,65), t3x8(:,:,48))
  call counter_AQ_S(EWctHbb,ntry, ex6(:), ex5(:), wf4(:,12), n3(:,66), t3x4(:,:,12))
  call counter_QA_V_LR(EWctAbb,ntry, ex5(:), ex6(:), wf4(:,13), n3(:,67), t3x4(:,:,13))
  call vert_AV_Q(ntry, ex4(:), wf4(:,13), wf8(:,73), n3(:,68), t3x8(:,:,49))
  call counter_QA_Z(EWctVbb,ntry, ex5(:), ex6(:), wf4(:,14), n3(:,69), t3x4(:,:,14))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,14), wf8(:,74), n3(:,70), t3x8(:,:,50))
  call vert_VQ_A(ntry, wf4(:,13), ex2(:), wf8(:,75), n3(:,71), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,75), 50, ZERO, 0_intkind1, wf8(:,76), n2(25))
  call vert_ZQ_A(gZl,ntry, wf4(:,14), ex2(:), wf8(:,77), n3(:,72), t3x8(:,:,52))
  call prop_Q_A(ntry, wf8(:,77), 50, ZERO, 0_intkind1, wf8(:,78), n2(26))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,6), wf8(:,79), n3(:,73), t3x8(:,:,53))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,7), wf8(:,80), n3(:,74), t3x8(:,:,54))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,4), wf8(:,81), n3(:,75), t3x8(:,:,55))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,1), wf8(:,82), n3(:,76), t3x8(:,:,56))
  call counter_VV_S(ntry, wf4(:,11), wf4(:,10), wf16(:,7), n3(:,77), t3x16(:,:,7))
  call counter_VV_S(ntry, wf4(:,9), wf4(:,10), wf16(:,8), n3(:,78), t3x16(:,:,8))
  call counter_VV_S(ntry, wf4(:,11), wf4(:,8), wf16(:,9), n3(:,79), t3x16(:,:,9))
  call counter_VV_S(ntry, wf4(:,9), wf4(:,8), wf16(:,10), n3(:,80), t3x16(:,:,10))
  call counter_AV_Q_LR(EWctAbb,ntry, ex6(:), wf4(:,11), wf8(:,83), n3(:,81), t3x8(:,:,57))
  call counter_AZ_Q(EWctVbb,ntry, ex6(:), wf4(:,9), wf8(:,84), n3(:,82), t3x8(:,:,58))
  call counter_AV_Q_LR(EWctAbb,ntry, ex6(:), wf4(:,10), wf8(:,85), n3(:,83), t3x8(:,:,59))
  call counter_AZ_Q(EWctVbb,ntry, ex6(:), wf4(:,8), wf8(:,86), n3(:,84), t3x8(:,:,60))
  call counter_VQ_A_LR(EWctAbb,ntry, wf4(:,11), ex5(:), wf8(:,87), n3(:,85), t3x8(:,:,61))
  call prop_A_Q(ntry, wf8(:,32), 41, MB, 1_intkind1, wf8(:,88), n2(27))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,9), ex5(:), wf8(:,89), n3(:,86), t3x8(:,:,62))
  call prop_A_Q(ntry, wf8(:,36), 41, MB, 1_intkind1, wf8(:,90), n2(28))
  call counter_VQ_A_LR(EWctAbb,ntry, wf4(:,10), ex5(:), wf8(:,91), n3(:,87), t3x8(:,:,63))
  call prop_A_Q(ntry, wf8(:,26), 38, MB, 1_intkind1, wf8(:,92), n2(29))
  call prop_A_Q(ntry, wf8(:,28), 38, MB, 1_intkind1, wf8(:,93), n2(30))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,8), ex5(:), wf8(:,94), n3(:,88), t3x8(:,:,64))
  call vert_VQ_A(ntry, wf4(:,13), ex1(:), wf8(:,95), n3(:,89), t3x8(:,:,65))
  call prop_Q_A(ntry, wf8(:,95), 49, ZERO, 0_intkind1, wf8(:,96), n2(31))
  call vert_ZQ_A(gZl,ntry, wf4(:,14), ex1(:), wf8(:,97), n3(:,90), t3x8(:,:,66))
  call prop_Q_A(ntry, wf8(:,97), 49, ZERO, 0_intkind1, wf8(:,98), n2(32))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,11), wf8(:,99), n3(:,91), t3x8(:,:,67))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,9), wf8(:,100), n3(:,92), t3x8(:,:,68))
  call vert_AV_Q(ntry, ex3(:), wf4(:,13), wf8(:,101), n3(:,93), t3x8(:,:,69))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,14), wf8(:,102), n3(:,94), t3x8(:,:,70))
  call counter_AZ_Q(EWctAee,ntry, ex3(:), wf4(:,6), wf8(:,103), n3(:,95), t3x8(:,:,71))
  call counter_AZ_Q(EWctVee,ntry, ex3(:), wf4(:,7), wf8(:,104), n3(:,96), t3x8(:,:,72))
  call counter_AZ_Q(EWctAee,ntry, ex3(:), wf4(:,10), wf8(:,105), n3(:,97), t3x8(:,:,73))
  call counter_AZ_Q(EWctVee,ntry, ex3(:), wf4(:,8), wf8(:,106), n3(:,98), t3x8(:,:,74))
  call counter_AZ_Q(EWctAee,ntry, ex3(:), wf4(:,5), wf8(:,107), n3(:,99), t3x8(:,:,75))
  call counter_AZ_Q(EWctVee,ntry, ex3(:), wf4(:,2), wf8(:,108), n3(:,100), t3x8(:,:,76))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,6), ex2(:), wf8(:,109), n3(:,101), t3x8(:,:,77))
  call prop_A_Q(ntry, wf8(:,20), 13, ZERO, 0_intkind1, wf8(:,110), n2(33))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,7), ex2(:), wf8(:,111), n3(:,102), t3x8(:,:,78))
  call prop_A_Q(ntry, wf8(:,24), 13, ZERO, 0_intkind1, wf8(:,112), n2(34))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,4), ex2(:), wf8(:,113), n3(:,103), t3x8(:,:,79))
  call prop_A_Q(ntry, wf8(:,14), 56, ZERO, 0_intkind1, wf8(:,114), n2(35))
  call prop_A_Q(ntry, wf8(:,16), 56, ZERO, 0_intkind1, wf8(:,115), n2(36))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,1), ex2(:), wf8(:,116), n3(:,104), t3x8(:,:,80))
  call counter_QA_Z(EWctVee,ntry, ex2(:), ex4(:), wf4(:,15), n3(:,105), t3x4(:,:,15))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,15), wf16(:,11), n3(:,106), t3x16(:,:,11))
  call counter_QA_Z(EWctAee,ntry, ex2(:), ex4(:), wf4(:,16), n3(:,107), t3x4(:,:,16))
  call vert_AV_Q(ntry, ex6(:), wf4(:,16), wf8(:,117), n3(:,108), t3x8(:,:,81))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,15), wf8(:,118), n3(:,109), t3x8(:,:,82))
  call vert_VQ_A(ntry, wf4(:,16), ex5(:), wf8(:,119), n3(:,110), t3x8(:,:,83))
  call prop_Q_A(ntry, wf8(:,119), 26, MB, 1_intkind1, wf8(:,120), n2(37))
  call vert_ZQ_A(gZd,ntry, wf4(:,15), ex5(:), wf8(:,121), n3(:,111), t3x8(:,:,84))
  call prop_Q_A(ntry, wf8(:,121), 26, MB, 1_intkind1, wf8(:,122), n2(38))
  call prop_A_Q(ntry, wf8(:,53), 13, ZERO, 0_intkind1, wf8(:,123), n2(39))
  call prop_A_Q(ntry, wf8(:,54), 13, ZERO, 0_intkind1, wf8(:,124), n2(40))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,10), ex2(:), wf8(:,125), n3(:,112), t3x8(:,:,85))
  call prop_A_Q(ntry, wf8(:,48), 52, ZERO, 0_intkind1, wf8(:,126), n2(41))
  call prop_A_Q(ntry, wf8(:,50), 52, ZERO, 0_intkind1, wf8(:,127), n2(42))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,8), ex2(:), wf8(:,128), n3(:,113), t3x8(:,:,86))
  call vert_AV_Q(ntry, ex3(:), wf4(:,16), wf8(:,129), n3(:,114), t3x8(:,:,87))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,15), wf8(:,130), n3(:,115), t3x8(:,:,88))
  call vert_VQ_A(ntry, wf4(:,16), ex1(:), wf8(:,131), n3(:,116), t3x8(:,:,89))
  call prop_Q_A(ntry, wf8(:,131), 11, ZERO, 0_intkind1, wf8(:,132), n2(43))
  call vert_ZQ_A(gZl,ntry, wf4(:,15), ex1(:), wf8(:,133), n3(:,117), t3x8(:,:,90))
  call prop_Q_A(ntry, wf8(:,133), 11, ZERO, 0_intkind1, wf8(:,134), n2(44))
  call counter_QA_Z(EWctVee,ntry, ex2(:), ex3(:), wf4(:,17), n3(:,118), t3x4(:,:,17))
  call vert_VV_S(ntry, wf4(:,17), wf4(:,8), wf16(:,12), n3(:,119), t3x16(:,:,12))
  call counter_QA_Z(EWctAee,ntry, ex2(:), ex3(:), wf4(:,18), n3(:,120), t3x4(:,:,18))
  call vert_AV_Q(ntry, ex6(:), wf4(:,18), wf8(:,135), n3(:,121), t3x8(:,:,91))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,17), wf8(:,136), n3(:,122), t3x8(:,:,92))
  call vert_VQ_A(ntry, wf4(:,18), ex5(:), wf8(:,137), n3(:,123), t3x8(:,:,93))
  call prop_Q_A(ntry, wf8(:,137), 22, MB, 1_intkind1, wf8(:,138), n2(45))
  call vert_ZQ_A(gZd,ntry, wf4(:,17), ex5(:), wf8(:,139), n3(:,124), t3x8(:,:,94))
  call prop_Q_A(ntry, wf8(:,139), 22, MB, 1_intkind1, wf8(:,140), n2(46))
  call vert_AV_Q(ntry, ex4(:), wf4(:,18), wf8(:,141), n3(:,125), t3x8(:,:,95))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,17), wf8(:,142), n3(:,126), t3x8(:,:,96))
  call vert_VQ_A(ntry, wf4(:,18), ex1(:), wf8(:,143), n3(:,127), t3x8(:,:,97))
  call prop_Q_A(ntry, wf8(:,143), 7, ZERO, 0_intkind1, wf8(:,144), n2(47))
  call vert_ZQ_A(gZl,ntry, wf4(:,17), ex1(:), wf8(:,145), n3(:,128), t3x8(:,:,98))
  call prop_Q_A(ntry, wf8(:,145), 7, ZERO, 0_intkind1, wf8(:,146), n2(48))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,11), ex1(:), wf8(:,147), n3(:,129), t3x8(:,:,99))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,9), ex1(:), wf8(:,148), n3(:,130), t3x8(:,:,100))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,6), ex1(:), wf8(:,149), n3(:,131), t3x8(:,:,101))
  call prop_A_Q(ntry, wf8(:,42), 14, ZERO, 0_intkind1, wf8(:,150), n2(49))
  call prop_A_Q(ntry, wf8(:,44), 14, ZERO, 0_intkind1, wf8(:,151), n2(50))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,7), ex1(:), wf8(:,152), n3(:,132), t3x8(:,:,102))
  call counter_QA_Z(EWctVee,ntry, ex1(:), ex4(:), wf4(:,19), n3(:,133), t3x4(:,:,19))
  call vert_VV_S(ntry, wf4(:,9), wf4(:,19), wf16(:,13), n3(:,134), t3x16(:,:,13))
  call counter_QA_Z(EWctAee,ntry, ex1(:), ex4(:), wf4(:,20), n3(:,135), t3x4(:,:,20))
  call vert_VQ_A(ntry, wf4(:,20), ex5(:), wf8(:,153), n3(:,136), t3x8(:,:,103))
  call prop_Q_A(ntry, wf8(:,153), 25, MB, 1_intkind1, wf8(:,154), n2(51))
  call vert_ZQ_A(gZd,ntry, wf4(:,19), ex5(:), wf8(:,155), n3(:,137), t3x8(:,:,104))
  call prop_Q_A(ntry, wf8(:,155), 25, MB, 1_intkind1, wf8(:,156), n2(52))
  call vert_AV_Q(ntry, ex6(:), wf4(:,20), wf8(:,157), n3(:,138), t3x8(:,:,105))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,19), wf8(:,158), n3(:,139), t3x8(:,:,106))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,5), ex1(:), wf8(:,159), n3(:,140), t3x8(:,:,107))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,2), ex1(:), wf8(:,160), n3(:,141), t3x8(:,:,108))
  call prop_A_Q(ntry, wf8(:,59), 14, ZERO, 0_intkind1, wf8(:,161), n2(53))
  call prop_A_Q(ntry, wf8(:,60), 14, ZERO, 0_intkind1, wf8(:,162), n2(54))
  call vert_VQ_A(ntry, wf4(:,20), ex2(:), wf8(:,163), n3(:,142), t3x8(:,:,109))
  call prop_Q_A(ntry, wf8(:,163), 11, ZERO, 0_intkind1, wf8(:,164), n2(55))
  call vert_ZQ_A(gZl,ntry, wf4(:,19), ex2(:), wf8(:,165), n3(:,143), t3x8(:,:,110))
  call prop_Q_A(ntry, wf8(:,165), 11, ZERO, 0_intkind1, wf8(:,166), n2(56))
  call vert_AV_Q(ntry, ex3(:), wf4(:,20), wf8(:,167), n3(:,144), t3x8(:,:,111))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,19), wf8(:,168), n3(:,145), t3x8(:,:,112))
  call counter_QA_Z(EWctVee,ntry, ex1(:), ex3(:), wf4(:,21), n3(:,146), t3x4(:,:,21))
  call vert_VV_S(ntry, wf4(:,21), wf4(:,2), wf16(:,14), n3(:,147), t3x16(:,:,14))
  call counter_QA_Z(EWctAee,ntry, ex1(:), ex3(:), wf4(:,22), n3(:,148), t3x4(:,:,22))
  call vert_VQ_A(ntry, wf4(:,22), ex5(:), wf8(:,169), n3(:,149), t3x8(:,:,113))
  call prop_Q_A(ntry, wf8(:,169), 21, MB, 1_intkind1, wf8(:,170), n2(57))
  call vert_ZQ_A(gZd,ntry, wf4(:,21), ex5(:), wf8(:,171), n3(:,150), t3x8(:,:,114))
  call prop_Q_A(ntry, wf8(:,171), 21, MB, 1_intkind1, wf8(:,172), n2(58))
  call vert_AV_Q(ntry, ex6(:), wf4(:,22), wf8(:,173), n3(:,151), t3x8(:,:,115))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,21), wf8(:,174), n3(:,152), t3x8(:,:,116))
  call vert_VQ_A(ntry, wf4(:,22), ex2(:), wf8(:,175), n3(:,153), t3x8(:,:,117))
  call prop_Q_A(ntry, wf8(:,175), 7, ZERO, 0_intkind1, wf8(:,176), n2(59))
  call vert_ZQ_A(gZl,ntry, wf4(:,21), ex2(:), wf8(:,177), n3(:,154), t3x8(:,:,118))
  call prop_Q_A(ntry, wf8(:,177), 7, ZERO, 0_intkind1, wf8(:,178), n2(60))
  call vert_AV_Q(ntry, ex4(:), wf4(:,22), wf8(:,179), n3(:,155), t3x8(:,:,119))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,21), wf8(:,180), n3(:,156), t3x8(:,:,120))
  call vert_TV_S(ntry, wf4(:,3), 48, wf4(:,2), 10, wf16(:,15), n3(:,157), t3x16(:,:,15))
  call counter_V_S(EWctXA,ntry, wf4(:,4), 5, wf4(:,23), n2(61))
  call counter_V_S(EWctXZ,ntry, wf4(:,1), 5, wf4(:,24), n2(62))
  call vert_SV_V(ntry, wf4(:,3), wf4(:,2), wf16(:,16), n3(:,158), t3x16(:,:,16))
  call counter_V_V(EWctAZ,ntry, wf4(:,4), 5, wf4(:,25), n2(63))
  call counter_V_V(EWctZZ,ntry, wf4(:,1), 5, wf4(:,26), n2(64))
  call vert_TV_S(ntry, wf4(:,3), 48, wf4(:,1), 5, wf16(:,17), n3(:,159), t3x16(:,:,17))
  call counter_V_S(EWctXA,ntry, wf4(:,5), 10, wf4(:,27), n2(65))
  call counter_V_S(EWctXZ,ntry, wf4(:,2), 10, wf4(:,28), n2(66))
  call vert_SV_V(ntry, wf4(:,3), wf4(:,1), wf16(:,18), n3(:,160), t3x16(:,:,18))
  call counter_V_V(EWctAZ,ntry, wf4(:,5), 10, wf4(:,29), n2(67))
  call counter_V_V(EWctZZ,ntry, wf4(:,2), 10, wf4(:,30), n2(68))
  call counter_S_S(EWctHH,ntry, wf4(:,3), 48, wf4(:,31), n2(69))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,23), wf8(:,181), n3(:,161), t3x8(:,:,121))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,24), wf8(:,182), n3(:,162), t3x8(:,:,122))
  call counter_V_V(EWctAA,ntry, wf4(:,4), 5, wf4(:,32), n2(70))
  call vert_VQ_A(ntry, wf4(:,32), ex5(:), wf8(:,183), n3(:,163), t3x8(:,:,123))
  call vert_ZQ_A(gZd,ntry, wf4(:,25), ex5(:), wf8(:,184), n3(:,164), t3x8(:,:,124))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 5, wf4(:,33), n2(71))
  call vert_VQ_A(ntry, wf4(:,33), ex5(:), wf8(:,185), n3(:,165), t3x8(:,:,125))
  call vert_ZQ_A(gZd,ntry, wf4(:,26), ex5(:), wf8(:,186), n3(:,166), t3x8(:,:,126))
  call vert_SA_Q(gX,ntry, wf4(:,23), ex6(:), wf8(:,187), n3(:,167), t3x8(:,:,127))
  call vert_SA_Q(gX,ntry, wf4(:,24), ex6(:), wf8(:,188), n3(:,168), t3x8(:,:,128))
  call vert_AV_Q(ntry, ex6(:), wf4(:,32), wf8(:,189), n3(:,169), t3x8(:,:,129))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,25), wf8(:,190), n3(:,170), t3x8(:,:,130))
  call vert_AV_Q(ntry, ex6(:), wf4(:,33), wf8(:,191), n3(:,171), t3x8(:,:,131))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,26), wf8(:,192), n3(:,172), t3x8(:,:,132))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,27), wf8(:,193), n3(:,173), t3x8(:,:,133))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,28), wf8(:,194), n3(:,174), t3x8(:,:,134))
  call counter_V_V(EWctAA,ntry, wf4(:,5), 10, wf4(:,34), n2(72))
  call vert_VQ_A(ntry, wf4(:,34), ex5(:), wf8(:,195), n3(:,175), t3x8(:,:,135))
  call vert_ZQ_A(gZd,ntry, wf4(:,29), ex5(:), wf8(:,196), n3(:,176), t3x8(:,:,136))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 10, wf4(:,35), n2(73))
  call vert_VQ_A(ntry, wf4(:,35), ex5(:), wf8(:,197), n3(:,177), t3x8(:,:,137))
  call vert_ZQ_A(gZd,ntry, wf4(:,30), ex5(:), wf8(:,198), n3(:,178), t3x8(:,:,138))
  call vert_SA_Q(gX,ntry, wf4(:,27), ex6(:), wf8(:,199), n3(:,179), t3x8(:,:,139))
  call vert_SA_Q(gX,ntry, wf4(:,28), ex6(:), wf8(:,200), n3(:,180), t3x8(:,:,140))
  call vert_AV_Q(ntry, ex6(:), wf4(:,34), wf8(:,201), n3(:,181), t3x8(:,:,141))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,29), wf8(:,202), n3(:,182), t3x8(:,:,142))
  call vert_AV_Q(ntry, ex6(:), wf4(:,35), wf8(:,203), n3(:,183), t3x8(:,:,143))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,30), wf8(:,204), n3(:,184), t3x8(:,:,144))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,3), 21, wf8(:,205), n2(74))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,6), 21, wf8(:,206), n2(75))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,9), 26, wf8(:,207), n2(76))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,11), 26, wf8(:,208), n2(77))
  call vert_VQ_A(ntry, wf4(:,32), ex2(:), wf8(:,209), n3(:,185), t3x8(:,:,145))
  call vert_ZQ_A(gZl,ntry, wf4(:,25), ex2(:), wf8(:,210), n3(:,186), t3x8(:,:,146))
  call vert_VQ_A(ntry, wf4(:,33), ex2(:), wf8(:,211), n3(:,187), t3x8(:,:,147))
  call vert_ZQ_A(gZl,ntry, wf4(:,26), ex2(:), wf8(:,212), n3(:,188), t3x8(:,:,148))
  call vert_AV_Q(ntry, ex4(:), wf4(:,32), wf8(:,213), n3(:,189), t3x8(:,:,149))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,25), wf8(:,214), n3(:,190), t3x8(:,:,150))
  call vert_AV_Q(ntry, ex4(:), wf4(:,33), wf8(:,215), n3(:,191), t3x8(:,:,151))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,26), wf8(:,216), n3(:,192), t3x8(:,:,152))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,15), 7, wf8(:,217), n2(78))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,18), 7, wf8(:,218), n2(79))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,21), 50, wf8(:,219), n2(80))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,23), 50, wf8(:,220), n2(81))
  call vert_AQ_S(gX,ntry, ex6(:), ex5(:), wf4(:,36), n3(:,193), t3x4(:,:,23))
  call counter_S_V(EWctXA,ntry, wf4(:,36), 48, wf4(:,37), n2(82))
  call vert_VQ_A(ntry, wf4(:,37), ex2(:), wf8(:,221), n3(:,194), t3x8(:,:,153))
  call counter_S_V(EWctXZ,ntry, wf4(:,36), 48, wf4(:,38), n2(83))
  call vert_ZQ_A(gZl,ntry, wf4(:,38), ex2(:), wf8(:,222), n3(:,195), t3x8(:,:,154))
  call counter_V_V(EWctAA,ntry, wf4(:,6), 48, wf4(:,39), n2(84))
  call vert_VQ_A(ntry, wf4(:,39), ex2(:), wf8(:,223), n3(:,196), t3x8(:,:,155))
  call counter_V_V(EWctAZ,ntry, wf4(:,7), 48, wf4(:,40), n2(85))
  call vert_VQ_A(ntry, wf4(:,40), ex2(:), wf8(:,224), n3(:,197), t3x8(:,:,156))
  call counter_V_V(EWctAZ,ntry, wf4(:,6), 48, wf4(:,41), n2(86))
  call vert_ZQ_A(gZl,ntry, wf4(:,41), ex2(:), wf8(:,225), n3(:,198), t3x8(:,:,157))
  call counter_V_V(EWctZZ,ntry, wf4(:,7), 48, wf4(:,42), n2(87))
  call vert_ZQ_A(gZl,ntry, wf4(:,42), ex2(:), wf8(:,226), n3(:,199), t3x8(:,:,158))
  call vert_AV_Q(ntry, ex4(:), wf4(:,37), wf8(:,227), n3(:,200), t3x8(:,:,159))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,38), wf8(:,228), n3(:,201), t3x8(:,:,160))
  call vert_AV_Q(ntry, ex4(:), wf4(:,39), wf8(:,229), n3(:,202), t3x8(:,:,161))
  call vert_AV_Q(ntry, ex4(:), wf4(:,40), wf8(:,230), n3(:,203), t3x8(:,:,162))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,41), wf8(:,231), n3(:,204), t3x8(:,:,163))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,42), wf8(:,232), n3(:,205), t3x8(:,:,164))
  call vert_TV_S(ntry, wf4(:,3), 48, wf4(:,9), 6, wf16(:,19), n3(:,206), t3x16(:,:,19))
  call counter_V_S(EWctXA,ntry, wf4(:,10), 9, wf4(:,43), n2(88))
  call counter_V_S(EWctXZ,ntry, wf4(:,8), 9, wf4(:,44), n2(89))
  call vert_SV_V(ntry, wf4(:,3), wf4(:,9), wf16(:,20), n3(:,207), t3x16(:,:,20))
  call counter_V_V(EWctAZ,ntry, wf4(:,10), 9, wf4(:,45), n2(90))
  call counter_V_V(EWctZZ,ntry, wf4(:,8), 9, wf4(:,46), n2(91))
  call vert_TV_S(ntry, wf4(:,3), 48, wf4(:,8), 9, wf16(:,21), n3(:,208), t3x16(:,:,21))
  call counter_V_S(EWctXA,ntry, wf4(:,11), 6, wf4(:,47), n2(92))
  call counter_V_S(EWctXZ,ntry, wf4(:,9), 6, wf4(:,48), n2(93))
  call vert_SV_V(ntry, wf4(:,3), wf4(:,8), wf16(:,22), n3(:,209), t3x16(:,:,22))
  call counter_V_V(EWctAZ,ntry, wf4(:,11), 6, wf4(:,49), n2(94))
  call counter_V_V(EWctZZ,ntry, wf4(:,9), 6, wf4(:,50), n2(95))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,43), wf8(:,233), n3(:,210), t3x8(:,:,165))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,44), wf8(:,234), n3(:,211), t3x8(:,:,166))
  call counter_V_V(EWctAA,ntry, wf4(:,10), 9, wf4(:,51), n2(96))
  call vert_VQ_A(ntry, wf4(:,51), ex5(:), wf8(:,235), n3(:,212), t3x8(:,:,167))
  call vert_ZQ_A(gZd,ntry, wf4(:,45), ex5(:), wf8(:,236), n3(:,213), t3x8(:,:,168))
  call counter_V_V(EWctAZ,ntry, wf4(:,8), 9, wf4(:,52), n2(97))
  call vert_VQ_A(ntry, wf4(:,52), ex5(:), wf8(:,237), n3(:,214), t3x8(:,:,169))
  call vert_ZQ_A(gZd,ntry, wf4(:,46), ex5(:), wf8(:,238), n3(:,215), t3x8(:,:,170))
  call vert_SA_Q(gX,ntry, wf4(:,43), ex6(:), wf8(:,239), n3(:,216), t3x8(:,:,171))
  call vert_SA_Q(gX,ntry, wf4(:,44), ex6(:), wf8(:,240), n3(:,217), t3x8(:,:,172))
  call vert_AV_Q(ntry, ex6(:), wf4(:,51), wf8(:,241), n3(:,218), t3x8(:,:,173))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,45), wf8(:,242), n3(:,219), t3x8(:,:,174))
  call vert_AV_Q(ntry, ex6(:), wf4(:,52), wf8(:,243), n3(:,220), t3x8(:,:,175))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,46), wf8(:,244), n3(:,221), t3x8(:,:,176))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,47), wf8(:,245), n3(:,222), t3x8(:,:,177))
  call vert_QS_A(gX,ntry, ex5(:), wf4(:,48), wf8(:,246), n3(:,223), t3x8(:,:,178))
  call counter_V_V(EWctAA,ntry, wf4(:,11), 6, wf4(:,53), n2(98))
  call vert_VQ_A(ntry, wf4(:,53), ex5(:), wf8(:,247), n3(:,224), t3x8(:,:,179))
  call vert_ZQ_A(gZd,ntry, wf4(:,49), ex5(:), wf8(:,248), n3(:,225), t3x8(:,:,180))
  call counter_V_V(EWctAZ,ntry, wf4(:,9), 6, wf4(:,54), n2(99))
  call vert_VQ_A(ntry, wf4(:,54), ex5(:), wf8(:,249), n3(:,226), t3x8(:,:,181))
  call vert_ZQ_A(gZd,ntry, wf4(:,50), ex5(:), wf8(:,250), n3(:,227), t3x8(:,:,182))
  call vert_SA_Q(gX,ntry, wf4(:,47), ex6(:), wf8(:,251), n3(:,228), t3x8(:,:,183))
  call vert_SA_Q(gX,ntry, wf4(:,48), ex6(:), wf8(:,252), n3(:,229), t3x8(:,:,184))
  call vert_AV_Q(ntry, ex6(:), wf4(:,53), wf8(:,253), n3(:,230), t3x8(:,:,185))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,49), wf8(:,254), n3(:,231), t3x8(:,:,186))
  call vert_AV_Q(ntry, ex6(:), wf4(:,54), wf8(:,255), n3(:,232), t3x8(:,:,187))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,50), wf8(:,256), n3(:,233), t3x8(:,:,188))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,27), 25, wf8(:,257), n2(100))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,30), 25, wf8(:,258), n2(101))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,33), 22, wf8(:,259), n2(102))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,35), 22, wf8(:,260), n2(103))
  call vert_VQ_A(ntry, wf4(:,53), ex1(:), wf8(:,261), n3(:,234), t3x8(:,:,189))
  call vert_VQ_A(ntry, wf4(:,54), ex1(:), wf8(:,262), n3(:,235), t3x8(:,:,190))
  call vert_ZQ_A(gZl,ntry, wf4(:,49), ex1(:), wf8(:,263), n3(:,236), t3x8(:,:,191))
  call vert_ZQ_A(gZl,ntry, wf4(:,50), ex1(:), wf8(:,264), n3(:,237), t3x8(:,:,192))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,38), 7, wf8(:,265), n2(104))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,40), 7, wf8(:,266), n2(105))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,43), 49, wf8(:,267), n2(106))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,46), 49, wf8(:,268), n2(107))
  call vert_VQ_A(ntry, wf4(:,37), ex1(:), wf8(:,269), n3(:,238), t3x8(:,:,193))
  call vert_ZQ_A(gZl,ntry, wf4(:,38), ex1(:), wf8(:,270), n3(:,239), t3x8(:,:,194))
  call vert_VQ_A(ntry, wf4(:,39), ex1(:), wf8(:,271), n3(:,240), t3x8(:,:,195))
  call vert_VQ_A(ntry, wf4(:,40), ex1(:), wf8(:,272), n3(:,241), t3x8(:,:,196))
  call vert_ZQ_A(gZl,ntry, wf4(:,41), ex1(:), wf8(:,273), n3(:,242), t3x8(:,:,197))
  call vert_ZQ_A(gZl,ntry, wf4(:,42), ex1(:), wf8(:,274), n3(:,243), t3x8(:,:,198))
  call vert_AV_Q(ntry, ex4(:), wf4(:,53), wf8(:,275), n3(:,244), t3x8(:,:,199))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,49), wf8(:,276), n3(:,245), t3x8(:,:,200))
  call vert_AV_Q(ntry, ex4(:), wf4(:,54), wf8(:,277), n3(:,246), t3x8(:,:,201))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,50), wf8(:,278), n3(:,247), t3x8(:,:,202))
  call vert_VQ_A(ntry, wf4(:,51), ex2(:), wf8(:,279), n3(:,248), t3x8(:,:,203))
  call vert_ZQ_A(gZl,ntry, wf4(:,45), ex2(:), wf8(:,280), n3(:,249), t3x8(:,:,204))
  call vert_VQ_A(ntry, wf4(:,52), ex2(:), wf8(:,281), n3(:,250), t3x8(:,:,205))
  call vert_ZQ_A(gZl,ntry, wf4(:,46), ex2(:), wf8(:,282), n3(:,251), t3x8(:,:,206))
  call vert_AV_Q(ntry, ex3(:), wf4(:,51), wf8(:,283), n3(:,252), t3x8(:,:,207))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,45), wf8(:,284), n3(:,253), t3x8(:,:,208))
  call vert_AV_Q(ntry, ex3(:), wf4(:,52), wf8(:,285), n3(:,254), t3x8(:,:,209))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,46), wf8(:,286), n3(:,255), t3x8(:,:,210))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,49), 11, wf8(:,287), n2(108))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,52), 11, wf8(:,288), n2(109))
  call vert_AV_Q(ntry, ex3(:), wf4(:,37), wf8(:,289), n3(:,256), t3x8(:,:,211))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,38), wf8(:,290), n3(:,257), t3x8(:,:,212))
  call vert_AV_Q(ntry, ex3(:), wf4(:,39), wf8(:,291), n3(:,258), t3x8(:,:,213))
  call vert_AV_Q(ntry, ex3(:), wf4(:,40), wf8(:,292), n3(:,259), t3x8(:,:,214))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,41), wf8(:,293), n3(:,260), t3x8(:,:,215))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,42), wf8(:,294), n3(:,261), t3x8(:,:,216))
  call vert_VQ_A(ntry, wf4(:,34), ex1(:), wf8(:,295), n3(:,262), t3x8(:,:,217))
  call vert_VQ_A(ntry, wf4(:,35), ex1(:), wf8(:,296), n3(:,263), t3x8(:,:,218))
  call vert_ZQ_A(gZl,ntry, wf4(:,29), ex1(:), wf8(:,297), n3(:,264), t3x8(:,:,219))
  call vert_ZQ_A(gZl,ntry, wf4(:,30), ex1(:), wf8(:,298), n3(:,265), t3x8(:,:,220))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,56), 11, wf8(:,299), n2(110))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,58), 11, wf8(:,300), n2(111))
  call vert_AV_Q(ntry, ex3(:), wf4(:,34), wf8(:,301), n3(:,266), t3x8(:,:,221))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,29), wf8(:,302), n3(:,267), t3x8(:,:,222))
  call vert_AV_Q(ntry, ex3(:), wf4(:,35), wf8(:,303), n3(:,268), t3x8(:,:,223))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,30), wf8(:,304), n3(:,269), t3x8(:,:,224))
  call vert_VS_T(ntry, wf4(:,1), 5, wf4(:,36), 48, wf16(:,23), n3(:,270), t3x16(:,:,23))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,7), wf16(:,24), n3(:,271), t3x16(:,:,24))
  call vert_QA_V(ntry, wf8(:,15), ex4(:), wf16(:,25), n3(:,272), t3x16(:,:,25))
  call vert_QA_Z(gZl,ntry, wf8(:,15), ex4(:), wf16(:,26), n3(:,273), t3x16(:,:,26))
  call vert_QA_V(ntry, wf8(:,18), ex4(:), wf16(:,27), n3(:,274), t3x16(:,:,27))
  call vert_QA_Z(gZl,ntry, wf8(:,18), ex4(:), wf16(:,28), n3(:,275), t3x16(:,:,28))
  call vert_QA_V(ntry, ex2(:), wf8(:,110), wf16(:,29), n3(:,276), t3x16(:,:,29))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,110), wf16(:,30), n3(:,277), t3x16(:,:,30))
  call vert_QA_V(ntry, ex2(:), wf8(:,112), wf16(:,31), n3(:,278), t3x16(:,:,31))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,112), wf16(:,32), n3(:,279), t3x16(:,:,32))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,3), wf16(:,33), n3(:,280), t3x16(:,:,33))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,6), wf16(:,34), n3(:,281), t3x16(:,:,34))
  call vert_QA_V(ntry, wf8(:,3), ex6(:), wf16(:,35), n3(:,282), t3x16(:,:,35))
  call vert_QA_Z(gZd,ntry, wf8(:,3), ex6(:), wf16(:,36), n3(:,283), t3x16(:,:,36))
  call vert_QA_V(ntry, wf8(:,6), ex6(:), wf16(:,37), n3(:,284), t3x16(:,:,37))
  call vert_QA_Z(gZd,ntry, wf8(:,6), ex6(:), wf16(:,38), n3(:,285), t3x16(:,:,38))
  call vert_AQ_S(gH,ntry, wf8(:,66), ex5(:), wf16(:,39), n3(:,286), t3x16(:,:,39))
  call vert_AQ_S(gH,ntry, wf8(:,68), ex5(:), wf16(:,40), n3(:,287), t3x16(:,:,40))
  call vert_QA_V(ntry, ex5(:), wf8(:,66), wf16(:,41), n3(:,288), t3x16(:,:,41))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,66), wf16(:,42), n3(:,289), t3x16(:,:,42))
  call vert_QA_V(ntry, ex5(:), wf8(:,68), wf16(:,43), n3(:,290), t3x16(:,:,43))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,68), wf16(:,44), n3(:,291), t3x16(:,:,44))
  call vert_VS_T(ntry, wf4(:,9), 6, wf4(:,36), 48, wf16(:,45), n3(:,292), t3x16(:,:,45))
  call vert_VV_S(ntry, wf4(:,9), wf4(:,7), wf16(:,46), n3(:,293), t3x16(:,:,46))
  call vert_QA_V(ntry, wf8(:,38), ex4(:), wf16(:,47), n3(:,294), t3x16(:,:,47))
  call vert_QA_Z(gZl,ntry, wf8(:,38), ex4(:), wf16(:,48), n3(:,295), t3x16(:,:,48))
  call vert_QA_V(ntry, wf8(:,40), ex4(:), wf16(:,49), n3(:,296), t3x16(:,:,49))
  call vert_QA_Z(gZl,ntry, wf8(:,40), ex4(:), wf16(:,50), n3(:,297), t3x16(:,:,50))
  call vert_QA_V(ntry, ex1(:), wf8(:,150), wf16(:,51), n3(:,298), t3x16(:,:,51))
  call vert_QA_V(ntry, ex1(:), wf8(:,151), wf16(:,52), n3(:,299), t3x16(:,:,52))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,150), wf16(:,53), n3(:,300), t3x16(:,:,53))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,151), wf16(:,54), n3(:,301), t3x16(:,:,54))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,33), wf16(:,55), n3(:,302), t3x16(:,:,55))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,35), wf16(:,56), n3(:,303), t3x16(:,:,56))
  call vert_QA_V(ntry, wf8(:,33), ex6(:), wf16(:,57), n3(:,304), t3x16(:,:,57))
  call vert_QA_Z(gZd,ntry, wf8(:,33), ex6(:), wf16(:,58), n3(:,305), t3x16(:,:,58))
  call vert_QA_V(ntry, wf8(:,35), ex6(:), wf16(:,59), n3(:,306), t3x16(:,:,59))
  call vert_QA_Z(gZd,ntry, wf8(:,35), ex6(:), wf16(:,60), n3(:,307), t3x16(:,:,60))
  call vert_AQ_S(gH,ntry, wf8(:,92), ex5(:), wf16(:,61), n3(:,308), t3x16(:,:,61))
  call vert_AQ_S(gH,ntry, wf8(:,93), ex5(:), wf16(:,62), n3(:,309), t3x16(:,:,62))
  call vert_QA_V(ntry, ex5(:), wf8(:,92), wf16(:,63), n3(:,310), t3x16(:,:,63))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,92), wf16(:,64), n3(:,311), t3x16(:,:,64))
  call vert_QA_V(ntry, ex5(:), wf8(:,93), wf16(:,65), n3(:,312), t3x16(:,:,65))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,93), wf16(:,66), n3(:,313), t3x16(:,:,66))
  call vert_VS_T(ntry, wf4(:,8), 9, wf4(:,36), 48, wf16(:,67), n3(:,314), t3x16(:,:,67))
  call vert_VV_S(ntry, wf4(:,8), wf4(:,7), wf16(:,68), n3(:,315), t3x16(:,:,68))
  call vert_QA_V(ntry, wf8(:,49), ex3(:), wf16(:,69), n3(:,316), t3x16(:,:,69))
  call vert_QA_Z(gZl,ntry, wf8(:,49), ex3(:), wf16(:,70), n3(:,317), t3x16(:,:,70))
  call vert_QA_V(ntry, wf8(:,52), ex3(:), wf16(:,71), n3(:,318), t3x16(:,:,71))
  call vert_QA_Z(gZl,ntry, wf8(:,52), ex3(:), wf16(:,72), n3(:,319), t3x16(:,:,72))
  call vert_QA_V(ntry, ex2(:), wf8(:,123), wf16(:,73), n3(:,320), t3x16(:,:,73))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,123), wf16(:,74), n3(:,321), t3x16(:,:,74))
  call vert_QA_V(ntry, ex2(:), wf8(:,124), wf16(:,75), n3(:,322), t3x16(:,:,75))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,124), wf16(:,76), n3(:,323), t3x16(:,:,76))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,27), wf16(:,77), n3(:,324), t3x16(:,:,77))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,30), wf16(:,78), n3(:,325), t3x16(:,:,78))
  call vert_QA_V(ntry, wf8(:,27), ex6(:), wf16(:,79), n3(:,326), t3x16(:,:,79))
  call vert_QA_Z(gZd,ntry, wf8(:,27), ex6(:), wf16(:,80), n3(:,327), t3x16(:,:,80))
  call vert_QA_V(ntry, wf8(:,30), ex6(:), wf16(:,81), n3(:,328), t3x16(:,:,81))
  call vert_QA_Z(gZd,ntry, wf8(:,30), ex6(:), wf16(:,82), n3(:,329), t3x16(:,:,82))
  call vert_AQ_S(gH,ntry, wf8(:,88), ex5(:), wf16(:,83), n3(:,330), t3x16(:,:,83))
  call vert_AQ_S(gH,ntry, wf8(:,90), ex5(:), wf16(:,84), n3(:,331), t3x16(:,:,84))
  call vert_QA_V(ntry, ex5(:), wf8(:,88), wf16(:,85), n3(:,332), t3x16(:,:,85))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,88), wf16(:,86), n3(:,333), t3x16(:,:,86))
  call vert_QA_V(ntry, ex5(:), wf8(:,90), wf16(:,87), n3(:,334), t3x16(:,:,87))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,90), wf16(:,88), n3(:,335), t3x16(:,:,88))
  call vert_VS_T(ntry, wf4(:,2), 10, wf4(:,36), 48, wf16(:,89), n3(:,336), t3x16(:,:,89))
  call vert_VV_S(ntry, wf4(:,2), wf4(:,7), wf16(:,90), n3(:,337), t3x16(:,:,90))
  call vert_QA_V(ntry, wf8(:,56), ex3(:), wf16(:,91), n3(:,338), t3x16(:,:,91))
  call vert_QA_Z(gZl,ntry, wf8(:,56), ex3(:), wf16(:,92), n3(:,339), t3x16(:,:,92))
  call vert_QA_V(ntry, wf8(:,58), ex3(:), wf16(:,93), n3(:,340), t3x16(:,:,93))
  call vert_QA_Z(gZl,ntry, wf8(:,58), ex3(:), wf16(:,94), n3(:,341), t3x16(:,:,94))
  call vert_QA_V(ntry, ex1(:), wf8(:,161), wf16(:,95), n3(:,342), t3x16(:,:,95))
  call vert_QA_V(ntry, ex1(:), wf8(:,162), wf16(:,96), n3(:,343), t3x16(:,:,96))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,161), wf16(:,97), n3(:,344), t3x16(:,:,97))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,162), wf16(:,98), n3(:,345), t3x16(:,:,98))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,9), wf16(:,99), n3(:,346), t3x16(:,:,99))
  call vert_AQ_S(gH,ntry, ex6(:), wf8(:,11), wf16(:,100), n3(:,347), t3x16(:,:,100))
  call vert_QA_V(ntry, wf8(:,9), ex6(:), wf16(:,101), n3(:,348), t3x16(:,:,101))
  call vert_QA_Z(gZd,ntry, wf8(:,9), ex6(:), wf16(:,102), n3(:,349), t3x16(:,:,102))
  call vert_QA_V(ntry, wf8(:,11), ex6(:), wf16(:,103), n3(:,350), t3x16(:,:,103))
  call vert_QA_Z(gZd,ntry, wf8(:,11), ex6(:), wf16(:,104), n3(:,351), t3x16(:,:,104))
  call vert_AQ_S(gH,ntry, wf8(:,70), ex5(:), wf16(:,105), n3(:,352), t3x16(:,:,105))
  call vert_AQ_S(gH,ntry, wf8(:,71), ex5(:), wf16(:,106), n3(:,353), t3x16(:,:,106))
  call vert_QA_V(ntry, ex5(:), wf8(:,70), wf16(:,107), n3(:,354), t3x16(:,:,107))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,70), wf16(:,108), n3(:,355), t3x16(:,:,108))
  call vert_QA_V(ntry, ex5(:), wf8(:,71), wf16(:,109), n3(:,356), t3x16(:,:,109))
  call vert_QA_Z(gZd,ntry, ex5(:), wf8(:,71), wf16(:,110), n3(:,357), t3x16(:,:,110))
  call vert_QA_V(ntry, wf8(:,43), ex3(:), wf16(:,111), n3(:,358), t3x16(:,:,111))
  call vert_QA_Z(gZl,ntry, wf8(:,43), ex3(:), wf16(:,112), n3(:,359), t3x16(:,:,112))
  call vert_QA_V(ntry, wf8(:,46), ex3(:), wf16(:,113), n3(:,360), t3x16(:,:,113))
  call vert_QA_Z(gZl,ntry, wf8(:,46), ex3(:), wf16(:,114), n3(:,361), t3x16(:,:,114))
  call vert_QA_V(ntry, ex1(:), wf8(:,126), wf16(:,115), n3(:,362), t3x16(:,:,115))
  call vert_QA_V(ntry, ex1(:), wf8(:,127), wf16(:,116), n3(:,363), t3x16(:,:,116))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,126), wf16(:,117), n3(:,364), t3x16(:,:,117))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,127), wf16(:,118), n3(:,365), t3x16(:,:,118))
  call vert_QA_V(ntry, wf8(:,43), ex4(:), wf16(:,119), n3(:,366), t3x16(:,:,119))
  call vert_QA_Z(gZl,ntry, wf8(:,43), ex4(:), wf16(:,120), n3(:,367), t3x16(:,:,120))
  call vert_QA_V(ntry, wf8(:,46), ex4(:), wf16(:,121), n3(:,368), t3x16(:,:,121))
  call vert_QA_Z(gZl,ntry, wf8(:,46), ex4(:), wf16(:,122), n3(:,369), t3x16(:,:,122))
  call vert_QA_V(ntry, ex1(:), wf8(:,114), wf16(:,123), n3(:,370), t3x16(:,:,123))
  call vert_QA_V(ntry, ex1(:), wf8(:,115), wf16(:,124), n3(:,371), t3x16(:,:,124))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,114), wf16(:,125), n3(:,372), t3x16(:,:,125))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,115), wf16(:,126), n3(:,373), t3x16(:,:,126))
  call vert_QA_V(ntry, wf8(:,21), ex3(:), wf16(:,127), n3(:,374), t3x16(:,:,127))
  call vert_QA_Z(gZl,ntry, wf8(:,21), ex3(:), wf16(:,128), n3(:,375), t3x16(:,:,128))
  call vert_QA_V(ntry, wf8(:,23), ex3(:), wf16(:,129), n3(:,376), t3x16(:,:,129))
  call vert_QA_Z(gZl,ntry, wf8(:,23), ex3(:), wf16(:,130), n3(:,377), t3x16(:,:,130))
  call vert_QA_V(ntry, ex2(:), wf8(:,126), wf16(:,131), n3(:,378), t3x16(:,:,131))
  call vert_QA_V(ntry, ex2(:), wf8(:,127), wf16(:,132), n3(:,379), t3x16(:,:,132))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,126), wf16(:,133), n3(:,380), t3x16(:,:,133))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,127), wf16(:,134), n3(:,381), t3x16(:,:,134))
  call vert_QA_V(ntry, wf8(:,21), ex4(:), wf16(:,135), n3(:,382), t3x16(:,:,135))
  call vert_QA_Z(gZl,ntry, wf8(:,21), ex4(:), wf16(:,136), n3(:,383), t3x16(:,:,136))
  call vert_QA_V(ntry, wf8(:,23), ex4(:), wf16(:,137), n3(:,384), t3x16(:,:,137))
  call vert_QA_Z(gZl,ntry, wf8(:,23), ex4(:), wf16(:,138), n3(:,385), t3x16(:,:,138))
  call vert_QA_V(ntry, ex2(:), wf8(:,114), wf16(:,139), n3(:,386), t3x16(:,:,139))
  call vert_QA_V(ntry, ex2(:), wf8(:,115), wf16(:,140), n3(:,387), t3x16(:,:,140))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,114), wf16(:,141), n3(:,388), t3x16(:,:,141))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,115), wf16(:,142), n3(:,389), t3x16(:,:,142))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,3), wf16(:,143), n3(:,390), t3x16(:,:,143))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,6), wf16(:,144), n3(:,391), t3x16(:,:,144))
  call vert_AQ_S(gX,ntry, wf8(:,66), ex5(:), wf16(:,145), n3(:,392), t3x16(:,:,145))
  call vert_AQ_S(gX,ntry, wf8(:,68), ex5(:), wf16(:,146), n3(:,393), t3x16(:,:,146))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,9), wf16(:,147), n3(:,394), t3x16(:,:,147))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,11), wf16(:,148), n3(:,395), t3x16(:,:,148))
  call vert_AQ_S(gX,ntry, wf8(:,70), ex5(:), wf16(:,149), n3(:,396), t3x16(:,:,149))
  call vert_AQ_S(gX,ntry, wf8(:,71), ex5(:), wf16(:,150), n3(:,397), t3x16(:,:,150))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,27), wf16(:,151), n3(:,398), t3x16(:,:,151))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,30), wf16(:,152), n3(:,399), t3x16(:,:,152))
  call vert_AQ_S(gX,ntry, wf8(:,88), ex5(:), wf16(:,153), n3(:,400), t3x16(:,:,153))
  call vert_AQ_S(gX,ntry, wf8(:,90), ex5(:), wf16(:,154), n3(:,401), t3x16(:,:,154))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,33), wf16(:,155), n3(:,402), t3x16(:,:,155))
  call vert_AQ_S(gX,ntry, ex6(:), wf8(:,35), wf16(:,156), n3(:,403), t3x16(:,:,156))
  call vert_AQ_S(gX,ntry, wf8(:,92), ex5(:), wf16(:,157), n3(:,404), t3x16(:,:,157))
  call vert_AQ_S(gX,ntry, wf8(:,93), ex5(:), wf16(:,158), n3(:,405), t3x16(:,:,158))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,3), wf16(:,1), A(:,1), n3(:,406), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,2), n3(:,407), t3x64(:,:,2), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,4), A(:,3), n3(:,408), t3x64(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,6), A(:,4), n3(:,409), t3x64(:,:,4), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,6), A(:,5), n3(:,410), t3x64(:,:,5), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,9), A(:,6), n3(:,411), t3x64(:,:,6), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,11), A(:,7), n3(:,412), t3x64(:,:,7), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,12), A(:,8), n3(:,413), t3x64(:,:,8), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,9), n3(:,414), t3x64(:,:,9), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,15), A(:,10), n3(:,415), t3x64(:,:,10), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,16), A(:,11), n3(:,416), t3x64(:,:,11), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,18), A(:,12), n3(:,417), t3x64(:,:,12), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,18), A(:,13), n3(:,418), t3x64(:,:,13), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,21), A(:,14), n3(:,419), t3x64(:,:,14), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,23), A(:,15), n3(:,420), t3x64(:,:,15), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,24), A(:,16), n3(:,421), t3x64(:,:,16), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,24), A(:,17), n3(:,422), t3x64(:,:,17), nhel, den(37))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,2), A(:,18), n3(:,423), t3x64(:,:,18), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,27), A(:,19), n3(:,424), t3x64(:,:,19), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,28), A(:,20), n3(:,425), t3x64(:,:,20), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,30), A(:,21), n3(:,426), t3x64(:,:,21), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,30), A(:,22), n3(:,427), t3x64(:,:,22), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,33), A(:,23), n3(:,428), t3x64(:,:,23), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,35), A(:,24), n3(:,429), t3x64(:,:,24), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,36), A(:,25), n3(:,430), t3x64(:,:,25), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,36), A(:,26), n3(:,431), t3x64(:,:,26), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,38), A(:,27), n3(:,432), t3x64(:,:,27), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,38), A(:,28), n3(:,433), t3x64(:,:,28), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,40), A(:,29), n3(:,434), t3x64(:,:,29), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,40), A(:,30), n3(:,435), t3x64(:,:,30), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,43), A(:,31), n3(:,436), t3x64(:,:,31), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,44), A(:,32), n3(:,437), t3x64(:,:,32), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,46), A(:,33), n3(:,438), t3x64(:,:,33), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,46), A(:,34), n3(:,439), t3x64(:,:,34), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,49), A(:,35), n3(:,440), t3x64(:,:,35), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,50), A(:,36), n3(:,441), t3x64(:,:,36), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,52), A(:,37), n3(:,442), t3x64(:,:,37), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,52), A(:,38), n3(:,443), t3x64(:,:,38), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,53), A(:,39), n3(:,444), t3x64(:,:,39), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,53), A(:,40), n3(:,445), t3x64(:,:,40), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,54), A(:,41), n3(:,446), t3x64(:,:,41), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,54), A(:,42), n3(:,447), t3x64(:,:,42), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,56), A(:,43), n3(:,448), t3x64(:,:,43), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,56), A(:,44), n3(:,449), t3x64(:,:,44), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,58), A(:,45), n3(:,450), t3x64(:,:,45), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,58), A(:,46), n3(:,451), t3x64(:,:,46), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,59), A(:,47), n3(:,452), t3x64(:,:,47), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,60), A(:,48), n3(:,453), t3x64(:,:,48), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,59), A(:,49), n3(:,454), t3x64(:,:,49), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,60), A(:,50), n3(:,455), t3x64(:,:,50), nhel, den(91))

    call Hcont_SS(nsync, wf4(:,3), wf16(:,3), A(:,51), n3(:,456), t3x64(:,:,51), nhel, den(93))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,4), A(:,52), n3(:,457), t3x64(:,:,52), nhel, den(95))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,5), A(:,53), n3(:,458), t3x64(:,:,53), nhel, den(97))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,6), A(:,54), n3(:,459), t3x64(:,:,54), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,61), A(:,55), n3(:,460), t3x64(:,:,55), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,62), A(:,56), n3(:,461), t3x64(:,:,56), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,61), A(:,57), n3(:,462), t3x64(:,:,57), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,62), A(:,58), n3(:,463), t3x64(:,:,58), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,63), A(:,59), n3(:,464), t3x64(:,:,59), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,63), A(:,60), n3(:,465), t3x64(:,:,60), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,64), A(:,61), n3(:,466), t3x64(:,:,61), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,64), A(:,62), n3(:,467), t3x64(:,:,62), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,65), wf8(:,66), A(:,63), n3(:,468), t3x64(:,:,63), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,67), A(:,64), n3(:,469), t3x64(:,:,64), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,65), wf8(:,68), A(:,65), n3(:,470), t3x64(:,:,65), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,67), wf8(:,68), A(:,66), n3(:,471), t3x64(:,:,66), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,69), wf8(:,70), A(:,67), n3(:,472), t3x64(:,:,67), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,69), wf8(:,71), A(:,68), n3(:,473), t3x64(:,:,68), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,72), A(:,69), n3(:,474), t3x64(:,:,69), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,72), A(:,70), n3(:,475), t3x64(:,:,70), nhel, den(111))
    call Hcont_SS(nsync, wf16(:,1), wf4(:,12), A(:,71), n3(:,476), t3x64(:,:,71), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,73), A(:,72), n3(:,477), t3x64(:,:,72), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,74), A(:,73), n3(:,478), t3x64(:,:,73), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,73), A(:,74), n3(:,479), t3x64(:,:,74), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,74), A(:,75), n3(:,480), t3x64(:,:,75), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,76), A(:,76), n3(:,481), t3x64(:,:,76), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,78), A(:,77), n3(:,482), t3x64(:,:,77), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,76), A(:,78), n3(:,483), t3x64(:,:,78), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,78), A(:,79), n3(:,484), t3x64(:,:,79), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,79), A(:,80), n3(:,485), t3x64(:,:,80), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,80), A(:,81), n3(:,486), t3x64(:,:,81), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,79), A(:,82), n3(:,487), t3x64(:,:,82), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,80), A(:,83), n3(:,488), t3x64(:,:,83), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,81), A(:,84), n3(:,489), t3x64(:,:,84), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,81), A(:,85), n3(:,490), t3x64(:,:,85), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,82), A(:,86), n3(:,491), t3x64(:,:,86), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,82), A(:,87), n3(:,492), t3x64(:,:,87), nhel, den(37))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,7), A(:,88), n3(:,493), t3x64(:,:,88), nhel, den(113))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,8), A(:,89), n3(:,494), t3x64(:,:,89), nhel, den(115))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,9), A(:,90), n3(:,495), t3x64(:,:,90), nhel, den(117))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,10), A(:,91), n3(:,496), t3x64(:,:,91), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,83), A(:,92), n3(:,497), t3x64(:,:,92), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,84), A(:,93), n3(:,498), t3x64(:,:,93), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,83), A(:,94), n3(:,499), t3x64(:,:,94), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,84), A(:,95), n3(:,500), t3x64(:,:,95), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,85), A(:,96), n3(:,501), t3x64(:,:,96), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,85), A(:,97), n3(:,502), t3x64(:,:,97), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,86), A(:,98), n3(:,503), t3x64(:,:,98), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,86), A(:,99), n3(:,504), t3x64(:,:,99), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,88), A(:,100), n3(:,505), t3x64(:,:,100), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,89), A(:,101), n3(:,506), t3x64(:,:,101), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,90), A(:,102), n3(:,507), t3x64(:,:,102), nhel, den(123))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,90), A(:,103), n3(:,508), t3x64(:,:,103), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,92), A(:,104), n3(:,509), t3x64(:,:,104), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,93), A(:,105), n3(:,510), t3x64(:,:,105), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,94), A(:,106), n3(:,511), t3x64(:,:,106), nhel, den(130))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,94), A(:,107), n3(:,512), t3x64(:,:,107), nhel, den(131))
    call Hcont_SS(nsync, wf16(:,2), wf4(:,12), A(:,108), n3(:,513), t3x64(:,:,108), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,73), A(:,109), n3(:,514), t3x64(:,:,109), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,74), A(:,110), n3(:,515), t3x64(:,:,110), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,73), A(:,111), n3(:,516), t3x64(:,:,111), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,74), A(:,112), n3(:,517), t3x64(:,:,112), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,96), A(:,113), n3(:,518), t3x64(:,:,113), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,96), A(:,114), n3(:,519), t3x64(:,:,114), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,98), A(:,115), n3(:,520), t3x64(:,:,115), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,98), A(:,116), n3(:,521), t3x64(:,:,116), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,79), A(:,117), n3(:,522), t3x64(:,:,117), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,80), A(:,118), n3(:,523), t3x64(:,:,118), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,79), A(:,119), n3(:,524), t3x64(:,:,119), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,80), A(:,120), n3(:,525), t3x64(:,:,120), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,99), A(:,121), n3(:,526), t3x64(:,:,121), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,100), A(:,122), n3(:,527), t3x64(:,:,122), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,99), A(:,123), n3(:,528), t3x64(:,:,123), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,100), A(:,124), n3(:,529), t3x64(:,:,124), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,101), A(:,125), n3(:,530), t3x64(:,:,125), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,102), A(:,126), n3(:,531), t3x64(:,:,126), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,101), A(:,127), n3(:,532), t3x64(:,:,127), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,102), A(:,128), n3(:,533), t3x64(:,:,128), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,76), A(:,129), n3(:,534), t3x64(:,:,129), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,78), A(:,130), n3(:,535), t3x64(:,:,130), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,76), A(:,131), n3(:,536), t3x64(:,:,131), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,78), A(:,132), n3(:,537), t3x64(:,:,132), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,101), A(:,133), n3(:,538), t3x64(:,:,133), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,102), A(:,134), n3(:,539), t3x64(:,:,134), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,101), A(:,135), n3(:,540), t3x64(:,:,135), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,102), A(:,136), n3(:,541), t3x64(:,:,136), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,96), A(:,137), n3(:,542), t3x64(:,:,137), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,96), A(:,138), n3(:,543), t3x64(:,:,138), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,98), A(:,139), n3(:,544), t3x64(:,:,139), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,98), A(:,140), n3(:,545), t3x64(:,:,140), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,103), A(:,141), n3(:,546), t3x64(:,:,141), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,104), A(:,142), n3(:,547), t3x64(:,:,142), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,103), A(:,143), n3(:,548), t3x64(:,:,143), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,104), A(:,144), n3(:,549), t3x64(:,:,144), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,105), A(:,145), n3(:,550), t3x64(:,:,145), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,105), A(:,146), n3(:,551), t3x64(:,:,146), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,106), A(:,147), n3(:,552), t3x64(:,:,147), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,106), A(:,148), n3(:,553), t3x64(:,:,148), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,103), A(:,149), n3(:,554), t3x64(:,:,149), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,104), A(:,150), n3(:,555), t3x64(:,:,150), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,103), A(:,151), n3(:,556), t3x64(:,:,151), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,104), A(:,152), n3(:,557), t3x64(:,:,152), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,107), A(:,153), n3(:,558), t3x64(:,:,153), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,108), A(:,154), n3(:,559), t3x64(:,:,154), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,107), A(:,155), n3(:,560), t3x64(:,:,155), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,108), A(:,156), n3(:,561), t3x64(:,:,156), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,109), wf8(:,110), A(:,157), n3(:,562), t3x64(:,:,157), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,110), wf8(:,111), A(:,158), n3(:,563), t3x64(:,:,158), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,109), wf8(:,112), A(:,159), n3(:,564), t3x64(:,:,159), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,111), wf8(:,112), A(:,160), n3(:,565), t3x64(:,:,160), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,113), wf8(:,114), A(:,161), n3(:,566), t3x64(:,:,161), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,113), wf8(:,115), A(:,162), n3(:,567), t3x64(:,:,162), nhel, den(143))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,116), A(:,163), n3(:,568), t3x64(:,:,163), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,116), A(:,164), n3(:,569), t3x64(:,:,164), nhel, den(145))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,11), A(:,165), n3(:,570), t3x64(:,:,165), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,117), A(:,166), n3(:,571), t3x64(:,:,166), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,118), A(:,167), n3(:,572), t3x64(:,:,167), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,117), A(:,168), n3(:,573), t3x64(:,:,168), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,118), A(:,169), n3(:,574), t3x64(:,:,169), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,120), A(:,170), n3(:,575), t3x64(:,:,170), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,122), A(:,171), n3(:,576), t3x64(:,:,171), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,120), A(:,172), n3(:,577), t3x64(:,:,172), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,122), A(:,173), n3(:,578), t3x64(:,:,173), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,109), wf8(:,123), A(:,174), n3(:,579), t3x64(:,:,174), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,111), wf8(:,123), A(:,175), n3(:,580), t3x64(:,:,175), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,109), wf8(:,124), A(:,176), n3(:,581), t3x64(:,:,176), nhel, den(150))
    call Hcont_QA(nsync, wf8(:,111), wf8(:,124), A(:,177), n3(:,582), t3x64(:,:,177), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,125), wf8(:,126), A(:,178), n3(:,583), t3x64(:,:,178), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,125), wf8(:,127), A(:,179), n3(:,584), t3x64(:,:,179), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,128), A(:,180), n3(:,585), t3x64(:,:,180), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,128), A(:,181), n3(:,586), t3x64(:,:,181), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,129), A(:,182), n3(:,587), t3x64(:,:,182), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,130), A(:,183), n3(:,588), t3x64(:,:,183), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,129), A(:,184), n3(:,589), t3x64(:,:,184), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,130), A(:,185), n3(:,590), t3x64(:,:,185), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,132), A(:,186), n3(:,591), t3x64(:,:,186), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,132), A(:,187), n3(:,592), t3x64(:,:,187), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,134), A(:,188), n3(:,593), t3x64(:,:,188), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,134), A(:,189), n3(:,594), t3x64(:,:,189), nhel, den(87))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,12), A(:,190), n3(:,595), t3x64(:,:,190), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,135), A(:,191), n3(:,596), t3x64(:,:,191), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,136), A(:,192), n3(:,597), t3x64(:,:,192), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,135), A(:,193), n3(:,598), t3x64(:,:,193), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,136), A(:,194), n3(:,599), t3x64(:,:,194), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,138), A(:,195), n3(:,600), t3x64(:,:,195), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,140), A(:,196), n3(:,601), t3x64(:,:,196), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,138), A(:,197), n3(:,602), t3x64(:,:,197), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,140), A(:,198), n3(:,603), t3x64(:,:,198), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,141), A(:,199), n3(:,604), t3x64(:,:,199), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,142), A(:,200), n3(:,605), t3x64(:,:,200), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,141), A(:,201), n3(:,606), t3x64(:,:,201), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,142), A(:,202), n3(:,607), t3x64(:,:,202), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,144), A(:,203), n3(:,608), t3x64(:,:,203), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,144), A(:,204), n3(:,609), t3x64(:,:,204), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,146), A(:,205), n3(:,610), t3x64(:,:,205), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,146), A(:,206), n3(:,611), t3x64(:,:,206), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,147), A(:,207), n3(:,612), t3x64(:,:,207), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,147), A(:,208), n3(:,613), t3x64(:,:,208), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,148), A(:,209), n3(:,614), t3x64(:,:,209), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,148), A(:,210), n3(:,615), t3x64(:,:,210), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,149), wf8(:,150), A(:,211), n3(:,616), t3x64(:,:,211), nhel, den(165))
    call Hcont_QA(nsync, wf8(:,149), wf8(:,151), A(:,212), n3(:,617), t3x64(:,:,212), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,152), A(:,213), n3(:,618), t3x64(:,:,213), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,152), A(:,214), n3(:,619), t3x64(:,:,214), nhel, den(169))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,13), A(:,215), n3(:,620), t3x64(:,:,215), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,154), A(:,216), n3(:,621), t3x64(:,:,216), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,154), A(:,217), n3(:,622), t3x64(:,:,217), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,156), A(:,218), n3(:,623), t3x64(:,:,218), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,156), A(:,219), n3(:,624), t3x64(:,:,219), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,157), A(:,220), n3(:,625), t3x64(:,:,220), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,157), A(:,221), n3(:,626), t3x64(:,:,221), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,158), A(:,222), n3(:,627), t3x64(:,:,222), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,158), A(:,223), n3(:,628), t3x64(:,:,223), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,159), A(:,224), n3(:,629), t3x64(:,:,224), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,159), A(:,225), n3(:,630), t3x64(:,:,225), nhel, den(171))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,160), A(:,226), n3(:,631), t3x64(:,:,226), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,160), A(:,227), n3(:,632), t3x64(:,:,227), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,149), wf8(:,161), A(:,228), n3(:,633), t3x64(:,:,228), nhel, den(175))
    call Hcont_QA(nsync, wf8(:,149), wf8(:,162), A(:,229), n3(:,634), t3x64(:,:,229), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,152), wf8(:,161), A(:,230), n3(:,635), t3x64(:,:,230), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,152), wf8(:,162), A(:,231), n3(:,636), t3x64(:,:,231), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,164), A(:,232), n3(:,637), t3x64(:,:,232), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,164), A(:,233), n3(:,638), t3x64(:,:,233), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,166), A(:,234), n3(:,639), t3x64(:,:,234), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,166), A(:,235), n3(:,640), t3x64(:,:,235), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,167), A(:,236), n3(:,641), t3x64(:,:,236), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,167), A(:,237), n3(:,642), t3x64(:,:,237), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,168), A(:,238), n3(:,643), t3x64(:,:,238), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,168), A(:,239), n3(:,644), t3x64(:,:,239), nhel, den(81))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,14), A(:,240), n3(:,645), t3x64(:,:,240), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,170), A(:,241), n3(:,646), t3x64(:,:,241), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,170), A(:,242), n3(:,647), t3x64(:,:,242), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,172), A(:,243), n3(:,648), t3x64(:,:,243), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,172), A(:,244), n3(:,649), t3x64(:,:,244), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,173), A(:,245), n3(:,650), t3x64(:,:,245), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,173), A(:,246), n3(:,651), t3x64(:,:,246), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,174), A(:,247), n3(:,652), t3x64(:,:,247), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,174), A(:,248), n3(:,653), t3x64(:,:,248), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,176), A(:,249), n3(:,654), t3x64(:,:,249), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,176), A(:,250), n3(:,655), t3x64(:,:,250), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,178), A(:,251), n3(:,656), t3x64(:,:,251), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,178), A(:,252), n3(:,657), t3x64(:,:,252), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,179), A(:,253), n3(:,658), t3x64(:,:,253), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,179), A(:,254), n3(:,659), t3x64(:,:,254), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,180), A(:,255), n3(:,660), t3x64(:,:,255), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,180), A(:,256), n3(:,661), t3x64(:,:,256), nhel, den(37))
    call Hcont_SS(nsync, wf16(:,15), wf4(:,23), A(:,257), n3(:,662), t3x64(:,:,257), nhel, den(183))
    call Hcont_SS(nsync, wf16(:,15), wf4(:,24), A(:,258), n3(:,663), t3x64(:,:,258), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,16), wf4(:,25), A(:,259), n3(:,664), t3x64(:,:,259), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,16), wf4(:,26), A(:,260), n3(:,665), t3x64(:,:,260), nhel, den(184))
    call Hcont_SS(nsync, wf16(:,17), wf4(:,27), A(:,261), n3(:,666), t3x64(:,:,261), nhel, den(188))
    call Hcont_SS(nsync, wf16(:,17), wf4(:,28), A(:,262), n3(:,667), t3x64(:,:,262), nhel, den(189))
    call Hcont_VV(nsync, wf16(:,18), wf4(:,29), A(:,263), n3(:,668), t3x64(:,:,263), nhel, den(188))
    call Hcont_VV(nsync, wf16(:,18), wf4(:,30), A(:,264), n3(:,669), t3x64(:,:,264), nhel, den(189))
    call Hcont_SS(nsync, wf16(:,1), wf4(:,31), A(:,265), n3(:,670), t3x64(:,:,265), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,181), A(:,266), n3(:,671), t3x64(:,:,266), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,181), A(:,267), n3(:,672), t3x64(:,:,267), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,182), A(:,268), n3(:,673), t3x64(:,:,268), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,182), A(:,269), n3(:,674), t3x64(:,:,269), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,183), A(:,270), n3(:,675), t3x64(:,:,270), nhel, den(200))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,183), A(:,271), n3(:,676), t3x64(:,:,271), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,184), A(:,272), n3(:,677), t3x64(:,:,272), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,184), A(:,273), n3(:,678), t3x64(:,:,273), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,185), A(:,274), n3(:,679), t3x64(:,:,274), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,185), A(:,275), n3(:,680), t3x64(:,:,275), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,186), A(:,276), n3(:,681), t3x64(:,:,276), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,186), A(:,277), n3(:,682), t3x64(:,:,277), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,187), A(:,278), n3(:,683), t3x64(:,:,278), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,187), A(:,279), n3(:,684), t3x64(:,:,279), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,188), A(:,280), n3(:,685), t3x64(:,:,280), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,188), A(:,281), n3(:,686), t3x64(:,:,281), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,189), A(:,282), n3(:,687), t3x64(:,:,282), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,189), A(:,283), n3(:,688), t3x64(:,:,283), nhel, den(207))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,190), A(:,284), n3(:,689), t3x64(:,:,284), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,190), A(:,285), n3(:,690), t3x64(:,:,285), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,191), A(:,286), n3(:,691), t3x64(:,:,286), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,191), A(:,287), n3(:,692), t3x64(:,:,287), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,192), A(:,288), n3(:,693), t3x64(:,:,288), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,192), A(:,289), n3(:,694), t3x64(:,:,289), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,193), A(:,290), n3(:,695), t3x64(:,:,290), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,193), A(:,291), n3(:,696), t3x64(:,:,291), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,194), A(:,292), n3(:,697), t3x64(:,:,292), nhel, den(212))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,194), A(:,293), n3(:,698), t3x64(:,:,293), nhel, den(213))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,195), A(:,294), n3(:,699), t3x64(:,:,294), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,195), A(:,295), n3(:,700), t3x64(:,:,295), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,196), A(:,296), n3(:,701), t3x64(:,:,296), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,196), A(:,297), n3(:,702), t3x64(:,:,297), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,197), A(:,298), n3(:,703), t3x64(:,:,298), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,197), A(:,299), n3(:,704), t3x64(:,:,299), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,198), A(:,300), n3(:,705), t3x64(:,:,300), nhel, den(212))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,198), A(:,301), n3(:,706), t3x64(:,:,301), nhel, den(213))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,199), A(:,302), n3(:,707), t3x64(:,:,302), nhel, den(217))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,199), A(:,303), n3(:,708), t3x64(:,:,303), nhel, den(218))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,200), A(:,304), n3(:,709), t3x64(:,:,304), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,200), A(:,305), n3(:,710), t3x64(:,:,305), nhel, den(220))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,201), A(:,306), n3(:,711), t3x64(:,:,306), nhel, den(221))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,201), A(:,307), n3(:,712), t3x64(:,:,307), nhel, den(222))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,202), A(:,308), n3(:,713), t3x64(:,:,308), nhel, den(217))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,202), A(:,309), n3(:,714), t3x64(:,:,309), nhel, den(218))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,203), A(:,310), n3(:,715), t3x64(:,:,310), nhel, den(217))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,203), A(:,311), n3(:,716), t3x64(:,:,311), nhel, den(218))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,204), A(:,312), n3(:,717), t3x64(:,:,312), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,204), A(:,313), n3(:,718), t3x64(:,:,313), nhel, den(220))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,205), A(:,314), n3(:,719), t3x64(:,:,314), nhel, den(223))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,205), A(:,315), n3(:,720), t3x64(:,:,315), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,206), A(:,316), n3(:,721), t3x64(:,:,316), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,206), A(:,317), n3(:,722), t3x64(:,:,317), nhel, den(226))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,207), A(:,318), n3(:,723), t3x64(:,:,318), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,208), A(:,319), n3(:,724), t3x64(:,:,319), nhel, den(228))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,207), A(:,320), n3(:,725), t3x64(:,:,320), nhel, den(229))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,208), A(:,321), n3(:,726), t3x64(:,:,321), nhel, den(230))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,209), A(:,322), n3(:,727), t3x64(:,:,322), nhel, den(231))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,209), A(:,323), n3(:,728), t3x64(:,:,323), nhel, den(232))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,210), A(:,324), n3(:,729), t3x64(:,:,324), nhel, den(233))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,210), A(:,325), n3(:,730), t3x64(:,:,325), nhel, den(234))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,211), A(:,326), n3(:,731), t3x64(:,:,326), nhel, den(233))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,211), A(:,327), n3(:,732), t3x64(:,:,327), nhel, den(234))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,212), A(:,328), n3(:,733), t3x64(:,:,328), nhel, den(235))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,212), A(:,329), n3(:,734), t3x64(:,:,329), nhel, den(236))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,213), A(:,330), n3(:,735), t3x64(:,:,330), nhel, den(237))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,213), A(:,331), n3(:,736), t3x64(:,:,331), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,214), A(:,332), n3(:,737), t3x64(:,:,332), nhel, den(239))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,214), A(:,333), n3(:,738), t3x64(:,:,333), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,215), A(:,334), n3(:,739), t3x64(:,:,334), nhel, den(239))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,215), A(:,335), n3(:,740), t3x64(:,:,335), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,216), A(:,336), n3(:,741), t3x64(:,:,336), nhel, den(241))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,216), A(:,337), n3(:,742), t3x64(:,:,337), nhel, den(242))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,217), A(:,338), n3(:,743), t3x64(:,:,338), nhel, den(243))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,217), A(:,339), n3(:,744), t3x64(:,:,339), nhel, den(244))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,218), A(:,340), n3(:,745), t3x64(:,:,340), nhel, den(245))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,218), A(:,341), n3(:,746), t3x64(:,:,341), nhel, den(246))
    call Hcont_QA(nsync, wf8(:,110), wf8(:,219), A(:,342), n3(:,747), t3x64(:,:,342), nhel, den(247))
    call Hcont_QA(nsync, wf8(:,110), wf8(:,220), A(:,343), n3(:,748), t3x64(:,:,343), nhel, den(248))
    call Hcont_QA(nsync, wf8(:,112), wf8(:,219), A(:,344), n3(:,749), t3x64(:,:,344), nhel, den(249))
    call Hcont_QA(nsync, wf8(:,112), wf8(:,220), A(:,345), n3(:,750), t3x64(:,:,345), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,110), wf8(:,221), A(:,346), n3(:,751), t3x64(:,:,346), nhel, den(252))
    call Hcont_QA(nsync, wf8(:,112), wf8(:,221), A(:,347), n3(:,752), t3x64(:,:,347), nhel, den(253))
    call Hcont_QA(nsync, wf8(:,110), wf8(:,222), A(:,348), n3(:,753), t3x64(:,:,348), nhel, den(255))
    call Hcont_QA(nsync, wf8(:,112), wf8(:,222), A(:,349), n3(:,754), t3x64(:,:,349), nhel, den(256))
    call Hcont_QA(nsync, wf8(:,110), wf8(:,223), A(:,350), n3(:,755), t3x64(:,:,350), nhel, den(258))
    call Hcont_QA(nsync, wf8(:,112), wf8(:,223), A(:,351), n3(:,756), t3x64(:,:,351), nhel, den(259))
    call Hcont_QA(nsync, wf8(:,110), wf8(:,224), A(:,352), n3(:,757), t3x64(:,:,352), nhel, den(252))
    call Hcont_QA(nsync, wf8(:,112), wf8(:,224), A(:,353), n3(:,758), t3x64(:,:,353), nhel, den(253))
    call Hcont_QA(nsync, wf8(:,110), wf8(:,225), A(:,354), n3(:,759), t3x64(:,:,354), nhel, den(252))
    call Hcont_QA(nsync, wf8(:,112), wf8(:,225), A(:,355), n3(:,760), t3x64(:,:,355), nhel, den(253))
    call Hcont_QA(nsync, wf8(:,110), wf8(:,226), A(:,356), n3(:,761), t3x64(:,:,356), nhel, den(255))
    call Hcont_QA(nsync, wf8(:,112), wf8(:,226), A(:,357), n3(:,762), t3x64(:,:,357), nhel, den(256))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,227), A(:,358), n3(:,763), t3x64(:,:,358), nhel, den(260))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,227), A(:,359), n3(:,764), t3x64(:,:,359), nhel, den(261))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,228), A(:,360), n3(:,765), t3x64(:,:,360), nhel, den(262))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,228), A(:,361), n3(:,766), t3x64(:,:,361), nhel, den(263))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,229), A(:,362), n3(:,767), t3x64(:,:,362), nhel, den(264))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,229), A(:,363), n3(:,768), t3x64(:,:,363), nhel, den(265))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,230), A(:,364), n3(:,769), t3x64(:,:,364), nhel, den(260))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,230), A(:,365), n3(:,770), t3x64(:,:,365), nhel, den(261))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,231), A(:,366), n3(:,771), t3x64(:,:,366), nhel, den(260))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,231), A(:,367), n3(:,772), t3x64(:,:,367), nhel, den(261))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,232), A(:,368), n3(:,773), t3x64(:,:,368), nhel, den(262))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,232), A(:,369), n3(:,774), t3x64(:,:,369), nhel, den(263))
    call Hcont_SS(nsync, wf16(:,19), wf4(:,43), A(:,370), n3(:,775), t3x64(:,:,370), nhel, den(269))
    call Hcont_SS(nsync, wf16(:,19), wf4(:,44), A(:,371), n3(:,776), t3x64(:,:,371), nhel, den(270))
    call Hcont_VV(nsync, wf16(:,20), wf4(:,45), A(:,372), n3(:,777), t3x64(:,:,372), nhel, den(269))
    call Hcont_VV(nsync, wf16(:,20), wf4(:,46), A(:,373), n3(:,778), t3x64(:,:,373), nhel, den(270))
    call Hcont_SS(nsync, wf16(:,21), wf4(:,47), A(:,374), n3(:,779), t3x64(:,:,374), nhel, den(274))
    call Hcont_SS(nsync, wf16(:,21), wf4(:,48), A(:,375), n3(:,780), t3x64(:,:,375), nhel, den(275))
    call Hcont_VV(nsync, wf16(:,22), wf4(:,49), A(:,376), n3(:,781), t3x64(:,:,376), nhel, den(274))
    call Hcont_VV(nsync, wf16(:,22), wf4(:,50), A(:,377), n3(:,782), t3x64(:,:,377), nhel, den(275))
    call Hcont_SS(nsync, wf16(:,2), wf4(:,31), A(:,378), n3(:,783), t3x64(:,:,378), nhel, den(277))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,233), A(:,379), n3(:,784), t3x64(:,:,379), nhel, den(279))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,233), A(:,380), n3(:,785), t3x64(:,:,380), nhel, den(280))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,234), A(:,381), n3(:,786), t3x64(:,:,381), nhel, den(282))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,234), A(:,382), n3(:,787), t3x64(:,:,382), nhel, den(283))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,235), A(:,383), n3(:,788), t3x64(:,:,383), nhel, den(285))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,235), A(:,384), n3(:,789), t3x64(:,:,384), nhel, den(286))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,236), A(:,385), n3(:,790), t3x64(:,:,385), nhel, den(279))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,236), A(:,386), n3(:,791), t3x64(:,:,386), nhel, den(280))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,237), A(:,387), n3(:,792), t3x64(:,:,387), nhel, den(279))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,237), A(:,388), n3(:,793), t3x64(:,:,388), nhel, den(280))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,238), A(:,389), n3(:,794), t3x64(:,:,389), nhel, den(282))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,238), A(:,390), n3(:,795), t3x64(:,:,390), nhel, den(283))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,239), A(:,391), n3(:,796), t3x64(:,:,391), nhel, den(287))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,239), A(:,392), n3(:,797), t3x64(:,:,392), nhel, den(288))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,240), A(:,393), n3(:,798), t3x64(:,:,393), nhel, den(289))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,240), A(:,394), n3(:,799), t3x64(:,:,394), nhel, den(290))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,241), A(:,395), n3(:,800), t3x64(:,:,395), nhel, den(291))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,241), A(:,396), n3(:,801), t3x64(:,:,396), nhel, den(292))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,242), A(:,397), n3(:,802), t3x64(:,:,397), nhel, den(287))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,242), A(:,398), n3(:,803), t3x64(:,:,398), nhel, den(288))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,243), A(:,399), n3(:,804), t3x64(:,:,399), nhel, den(287))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,243), A(:,400), n3(:,805), t3x64(:,:,400), nhel, den(288))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,244), A(:,401), n3(:,806), t3x64(:,:,401), nhel, den(289))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,244), A(:,402), n3(:,807), t3x64(:,:,402), nhel, den(290))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,245), A(:,403), n3(:,808), t3x64(:,:,403), nhel, den(294))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,245), A(:,404), n3(:,809), t3x64(:,:,404), nhel, den(295))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,246), A(:,405), n3(:,810), t3x64(:,:,405), nhel, den(297))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,246), A(:,406), n3(:,811), t3x64(:,:,406), nhel, den(298))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,247), A(:,407), n3(:,812), t3x64(:,:,407), nhel, den(300))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,247), A(:,408), n3(:,813), t3x64(:,:,408), nhel, den(301))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,248), A(:,409), n3(:,814), t3x64(:,:,409), nhel, den(294))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,248), A(:,410), n3(:,815), t3x64(:,:,410), nhel, den(295))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,249), A(:,411), n3(:,816), t3x64(:,:,411), nhel, den(294))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,249), A(:,412), n3(:,817), t3x64(:,:,412), nhel, den(295))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,250), A(:,413), n3(:,818), t3x64(:,:,413), nhel, den(297))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,250), A(:,414), n3(:,819), t3x64(:,:,414), nhel, den(298))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,251), A(:,415), n3(:,820), t3x64(:,:,415), nhel, den(302))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,251), A(:,416), n3(:,821), t3x64(:,:,416), nhel, den(303))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,252), A(:,417), n3(:,822), t3x64(:,:,417), nhel, den(304))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,252), A(:,418), n3(:,823), t3x64(:,:,418), nhel, den(305))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,253), A(:,419), n3(:,824), t3x64(:,:,419), nhel, den(306))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,253), A(:,420), n3(:,825), t3x64(:,:,420), nhel, den(307))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,254), A(:,421), n3(:,826), t3x64(:,:,421), nhel, den(302))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,254), A(:,422), n3(:,827), t3x64(:,:,422), nhel, den(303))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,255), A(:,423), n3(:,828), t3x64(:,:,423), nhel, den(302))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,255), A(:,424), n3(:,829), t3x64(:,:,424), nhel, den(303))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,256), A(:,425), n3(:,830), t3x64(:,:,425), nhel, den(304))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,256), A(:,426), n3(:,831), t3x64(:,:,426), nhel, den(305))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,257), A(:,427), n3(:,832), t3x64(:,:,427), nhel, den(308))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,257), A(:,428), n3(:,833), t3x64(:,:,428), nhel, den(309))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,258), A(:,429), n3(:,834), t3x64(:,:,429), nhel, den(310))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,258), A(:,430), n3(:,835), t3x64(:,:,430), nhel, den(311))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,259), A(:,431), n3(:,836), t3x64(:,:,431), nhel, den(312))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,260), A(:,432), n3(:,837), t3x64(:,:,432), nhel, den(313))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,259), A(:,433), n3(:,838), t3x64(:,:,433), nhel, den(314))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,260), A(:,434), n3(:,839), t3x64(:,:,434), nhel, den(315))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,261), A(:,435), n3(:,840), t3x64(:,:,435), nhel, den(316))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,261), A(:,436), n3(:,841), t3x64(:,:,436), nhel, den(317))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,262), A(:,437), n3(:,842), t3x64(:,:,437), nhel, den(318))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,262), A(:,438), n3(:,843), t3x64(:,:,438), nhel, den(319))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,263), A(:,439), n3(:,844), t3x64(:,:,439), nhel, den(318))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,263), A(:,440), n3(:,845), t3x64(:,:,440), nhel, den(319))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,264), A(:,441), n3(:,846), t3x64(:,:,441), nhel, den(320))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,264), A(:,442), n3(:,847), t3x64(:,:,442), nhel, den(321))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,265), A(:,443), n3(:,848), t3x64(:,:,443), nhel, den(322))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,265), A(:,444), n3(:,849), t3x64(:,:,444), nhel, den(323))
    call Hcont_QA(nsync, wf8(:,114), wf8(:,266), A(:,445), n3(:,850), t3x64(:,:,445), nhel, den(324))
    call Hcont_QA(nsync, wf8(:,115), wf8(:,266), A(:,446), n3(:,851), t3x64(:,:,446), nhel, den(325))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,267), A(:,447), n3(:,852), t3x64(:,:,447), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,267), A(:,448), n3(:,853), t3x64(:,:,448), nhel, den(327))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,268), A(:,449), n3(:,854), t3x64(:,:,449), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,268), A(:,450), n3(:,855), t3x64(:,:,450), nhel, den(329))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,269), A(:,451), n3(:,856), t3x64(:,:,451), nhel, den(330))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,269), A(:,452), n3(:,857), t3x64(:,:,452), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,270), A(:,453), n3(:,858), t3x64(:,:,453), nhel, den(332))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,270), A(:,454), n3(:,859), t3x64(:,:,454), nhel, den(333))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,271), A(:,455), n3(:,860), t3x64(:,:,455), nhel, den(334))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,271), A(:,456), n3(:,861), t3x64(:,:,456), nhel, den(335))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,272), A(:,457), n3(:,862), t3x64(:,:,457), nhel, den(330))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,272), A(:,458), n3(:,863), t3x64(:,:,458), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,273), A(:,459), n3(:,864), t3x64(:,:,459), nhel, den(330))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,273), A(:,460), n3(:,865), t3x64(:,:,460), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,274), A(:,461), n3(:,866), t3x64(:,:,461), nhel, den(332))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,274), A(:,462), n3(:,867), t3x64(:,:,462), nhel, den(333))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,275), A(:,463), n3(:,868), t3x64(:,:,463), nhel, den(336))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,275), A(:,464), n3(:,869), t3x64(:,:,464), nhel, den(337))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,276), A(:,465), n3(:,870), t3x64(:,:,465), nhel, den(338))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,276), A(:,466), n3(:,871), t3x64(:,:,466), nhel, den(339))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,277), A(:,467), n3(:,872), t3x64(:,:,467), nhel, den(338))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,277), A(:,468), n3(:,873), t3x64(:,:,468), nhel, den(339))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,278), A(:,469), n3(:,874), t3x64(:,:,469), nhel, den(340))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,278), A(:,470), n3(:,875), t3x64(:,:,470), nhel, den(341))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,227), A(:,471), n3(:,876), t3x64(:,:,471), nhel, den(342))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,227), A(:,472), n3(:,877), t3x64(:,:,472), nhel, den(343))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,228), A(:,473), n3(:,878), t3x64(:,:,473), nhel, den(344))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,228), A(:,474), n3(:,879), t3x64(:,:,474), nhel, den(345))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,229), A(:,475), n3(:,880), t3x64(:,:,475), nhel, den(346))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,229), A(:,476), n3(:,881), t3x64(:,:,476), nhel, den(347))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,230), A(:,477), n3(:,882), t3x64(:,:,477), nhel, den(342))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,230), A(:,478), n3(:,883), t3x64(:,:,478), nhel, den(343))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,231), A(:,479), n3(:,884), t3x64(:,:,479), nhel, den(342))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,231), A(:,480), n3(:,885), t3x64(:,:,480), nhel, den(343))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,232), A(:,481), n3(:,886), t3x64(:,:,481), nhel, den(344))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,232), A(:,482), n3(:,887), t3x64(:,:,482), nhel, den(345))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,279), A(:,483), n3(:,888), t3x64(:,:,483), nhel, den(348))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,279), A(:,484), n3(:,889), t3x64(:,:,484), nhel, den(349))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,280), A(:,485), n3(:,890), t3x64(:,:,485), nhel, den(350))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,280), A(:,486), n3(:,891), t3x64(:,:,486), nhel, den(351))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,281), A(:,487), n3(:,892), t3x64(:,:,487), nhel, den(350))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,281), A(:,488), n3(:,893), t3x64(:,:,488), nhel, den(351))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,282), A(:,489), n3(:,894), t3x64(:,:,489), nhel, den(352))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,282), A(:,490), n3(:,895), t3x64(:,:,490), nhel, den(353))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,283), A(:,491), n3(:,896), t3x64(:,:,491), nhel, den(354))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,283), A(:,492), n3(:,897), t3x64(:,:,492), nhel, den(355))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,284), A(:,493), n3(:,898), t3x64(:,:,493), nhel, den(356))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,284), A(:,494), n3(:,899), t3x64(:,:,494), nhel, den(357))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,285), A(:,495), n3(:,900), t3x64(:,:,495), nhel, den(356))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,285), A(:,496), n3(:,901), t3x64(:,:,496), nhel, den(357))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,286), A(:,497), n3(:,902), t3x64(:,:,497), nhel, den(358))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,286), A(:,498), n3(:,903), t3x64(:,:,498), nhel, den(359))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,287), A(:,499), n3(:,904), t3x64(:,:,499), nhel, den(360))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,287), A(:,500), n3(:,905), t3x64(:,:,500), nhel, den(361))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,288), A(:,501), n3(:,906), t3x64(:,:,501), nhel, den(362))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,288), A(:,502), n3(:,907), t3x64(:,:,502), nhel, den(363))
    call Hcont_QA(nsync, wf8(:,123), wf8(:,219), A(:,503), n3(:,908), t3x64(:,:,503), nhel, den(364))
    call Hcont_QA(nsync, wf8(:,123), wf8(:,220), A(:,504), n3(:,909), t3x64(:,:,504), nhel, den(365))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,219), A(:,505), n3(:,910), t3x64(:,:,505), nhel, den(366))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,220), A(:,506), n3(:,911), t3x64(:,:,506), nhel, den(367))
    call Hcont_QA(nsync, wf8(:,123), wf8(:,221), A(:,507), n3(:,912), t3x64(:,:,507), nhel, den(368))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,221), A(:,508), n3(:,913), t3x64(:,:,508), nhel, den(369))
    call Hcont_QA(nsync, wf8(:,123), wf8(:,222), A(:,509), n3(:,914), t3x64(:,:,509), nhel, den(370))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,222), A(:,510), n3(:,915), t3x64(:,:,510), nhel, den(371))
    call Hcont_QA(nsync, wf8(:,123), wf8(:,223), A(:,511), n3(:,916), t3x64(:,:,511), nhel, den(372))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,223), A(:,512), n3(:,917), t3x64(:,:,512), nhel, den(373))
    call Hcont_QA(nsync, wf8(:,123), wf8(:,224), A(:,513), n3(:,918), t3x64(:,:,513), nhel, den(368))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,224), A(:,514), n3(:,919), t3x64(:,:,514), nhel, den(369))
    call Hcont_QA(nsync, wf8(:,123), wf8(:,225), A(:,515), n3(:,920), t3x64(:,:,515), nhel, den(368))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,225), A(:,516), n3(:,921), t3x64(:,:,516), nhel, den(369))
    call Hcont_QA(nsync, wf8(:,123), wf8(:,226), A(:,517), n3(:,922), t3x64(:,:,517), nhel, den(370))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,226), A(:,518), n3(:,923), t3x64(:,:,518), nhel, den(371))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,289), A(:,519), n3(:,924), t3x64(:,:,519), nhel, den(374))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,289), A(:,520), n3(:,925), t3x64(:,:,520), nhel, den(375))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,290), A(:,521), n3(:,926), t3x64(:,:,521), nhel, den(376))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,290), A(:,522), n3(:,927), t3x64(:,:,522), nhel, den(377))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,291), A(:,523), n3(:,928), t3x64(:,:,523), nhel, den(378))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,291), A(:,524), n3(:,929), t3x64(:,:,524), nhel, den(379))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,292), A(:,525), n3(:,930), t3x64(:,:,525), nhel, den(374))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,292), A(:,526), n3(:,931), t3x64(:,:,526), nhel, den(375))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,293), A(:,527), n3(:,932), t3x64(:,:,527), nhel, den(374))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,293), A(:,528), n3(:,933), t3x64(:,:,528), nhel, den(375))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,294), A(:,529), n3(:,934), t3x64(:,:,529), nhel, den(376))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,294), A(:,530), n3(:,935), t3x64(:,:,530), nhel, den(377))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,295), A(:,531), n3(:,936), t3x64(:,:,531), nhel, den(380))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,295), A(:,532), n3(:,937), t3x64(:,:,532), nhel, den(381))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,296), A(:,533), n3(:,938), t3x64(:,:,533), nhel, den(382))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,296), A(:,534), n3(:,939), t3x64(:,:,534), nhel, den(383))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,297), A(:,535), n3(:,940), t3x64(:,:,535), nhel, den(382))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,297), A(:,536), n3(:,941), t3x64(:,:,536), nhel, den(383))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,298), A(:,537), n3(:,942), t3x64(:,:,537), nhel, den(384))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,298), A(:,538), n3(:,943), t3x64(:,:,538), nhel, den(385))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,299), A(:,539), n3(:,944), t3x64(:,:,539), nhel, den(386))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,299), A(:,540), n3(:,945), t3x64(:,:,540), nhel, den(387))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,300), A(:,541), n3(:,946), t3x64(:,:,541), nhel, den(388))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,300), A(:,542), n3(:,947), t3x64(:,:,542), nhel, den(389))
    call Hcont_QA(nsync, wf8(:,161), wf8(:,267), A(:,543), n3(:,948), t3x64(:,:,543), nhel, den(390))
    call Hcont_QA(nsync, wf8(:,162), wf8(:,267), A(:,544), n3(:,949), t3x64(:,:,544), nhel, den(391))
    call Hcont_QA(nsync, wf8(:,161), wf8(:,268), A(:,545), n3(:,950), t3x64(:,:,545), nhel, den(392))
    call Hcont_QA(nsync, wf8(:,162), wf8(:,268), A(:,546), n3(:,951), t3x64(:,:,546), nhel, den(393))
    call Hcont_QA(nsync, wf8(:,161), wf8(:,269), A(:,547), n3(:,952), t3x64(:,:,547), nhel, den(394))
    call Hcont_QA(nsync, wf8(:,162), wf8(:,269), A(:,548), n3(:,953), t3x64(:,:,548), nhel, den(395))
    call Hcont_QA(nsync, wf8(:,161), wf8(:,270), A(:,549), n3(:,954), t3x64(:,:,549), nhel, den(396))
    call Hcont_QA(nsync, wf8(:,162), wf8(:,270), A(:,550), n3(:,955), t3x64(:,:,550), nhel, den(397))
    call Hcont_QA(nsync, wf8(:,161), wf8(:,271), A(:,551), n3(:,956), t3x64(:,:,551), nhel, den(398))
    call Hcont_QA(nsync, wf8(:,162), wf8(:,271), A(:,552), n3(:,957), t3x64(:,:,552), nhel, den(399))
    call Hcont_QA(nsync, wf8(:,161), wf8(:,272), A(:,553), n3(:,958), t3x64(:,:,553), nhel, den(394))
    call Hcont_QA(nsync, wf8(:,162), wf8(:,272), A(:,554), n3(:,959), t3x64(:,:,554), nhel, den(395))
    call Hcont_QA(nsync, wf8(:,161), wf8(:,273), A(:,555), n3(:,960), t3x64(:,:,555), nhel, den(394))
    call Hcont_QA(nsync, wf8(:,162), wf8(:,273), A(:,556), n3(:,961), t3x64(:,:,556), nhel, den(395))
    call Hcont_QA(nsync, wf8(:,161), wf8(:,274), A(:,557), n3(:,962), t3x64(:,:,557), nhel, den(396))
    call Hcont_QA(nsync, wf8(:,162), wf8(:,274), A(:,558), n3(:,963), t3x64(:,:,558), nhel, den(397))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,301), A(:,559), n3(:,964), t3x64(:,:,559), nhel, den(400))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,301), A(:,560), n3(:,965), t3x64(:,:,560), nhel, den(401))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,302), A(:,561), n3(:,966), t3x64(:,:,561), nhel, den(402))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,302), A(:,562), n3(:,967), t3x64(:,:,562), nhel, den(403))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,303), A(:,563), n3(:,968), t3x64(:,:,563), nhel, den(402))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,303), A(:,564), n3(:,969), t3x64(:,:,564), nhel, den(403))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,304), A(:,565), n3(:,970), t3x64(:,:,565), nhel, den(404))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,304), A(:,566), n3(:,971), t3x64(:,:,566), nhel, den(405))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,289), A(:,567), n3(:,972), t3x64(:,:,567), nhel, den(406))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,289), A(:,568), n3(:,973), t3x64(:,:,568), nhel, den(407))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,290), A(:,569), n3(:,974), t3x64(:,:,569), nhel, den(408))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,290), A(:,570), n3(:,975), t3x64(:,:,570), nhel, den(409))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,291), A(:,571), n3(:,976), t3x64(:,:,571), nhel, den(410))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,291), A(:,572), n3(:,977), t3x64(:,:,572), nhel, den(411))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,292), A(:,573), n3(:,978), t3x64(:,:,573), nhel, den(406))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,292), A(:,574), n3(:,979), t3x64(:,:,574), nhel, den(407))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,293), A(:,575), n3(:,980), t3x64(:,:,575), nhel, den(406))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,293), A(:,576), n3(:,981), t3x64(:,:,576), nhel, den(407))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,294), A(:,577), n3(:,982), t3x64(:,:,577), nhel, den(408))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,294), A(:,578), n3(:,983), t3x64(:,:,578), nhel, den(409))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,2)%j-A(j,6)%j+A(j,19)%j+A(j,23)%j)*f(1)+(-A(j,3)%j-A(j,4)%j-A(j,7)%j-A(j,8)%j-A(j,10)%j-A(j,12)%j-A(j,14)%j &
       -A(j,16)%j+A(j,20)%j+A(j,21)%j+A(j,24)%j+A(j,25)%j+A(j,27)%j+A(j,29)%j+A(j,31)%j+A(j,32)%j+A(j,35)%j+A(j,37)%j+A(j,39)%j &
       +A(j,41)%j-A(j,43)%j-A(j,45)%j-A(j,47)%j-A(j,48)%j)*f(2)+(-A(j,5)%j-A(j,9)%j-A(j,11)%j-A(j,13)%j-A(j,15)%j-A(j,17)%j &
       +A(j,22)%j+A(j,26)%j+A(j,28)%j+A(j,30)%j+A(j,33)%j+A(j,34)%j+A(j,36)%j+A(j,38)%j+A(j,40)%j+A(j,42)%j-A(j,44)%j-A(j,46)%j &
       -A(j,49)%j-A(j,50)%j)*f(3)+(A(j,1)%j-A(j,18)%j)*f(7)

  M2(1)%j = (-A(j,166)%j-A(j,170)%j+A(j,191)%j+A(j,195)%j+A(j,216)%j+A(j,220)%j-A(j,241)%j-A(j,245)%j+A(j,270)%j+A(j,274)%j &
       +A(j,282)%j+A(j,286)%j+A(j,294)%j+A(j,298)%j+A(j,306)%j+A(j,310)%j+A(j,314)%j+A(j,318)%j-A(j,383)%j-A(j,387)%j-A(j,395)%j &
       -A(j,399)%j-A(j,407)%j-A(j,411)%j-A(j,419)%j-A(j,423)%j-A(j,427)%j-A(j,431)%j)*f(4)+(-A(j,55)%j-A(j,56)%j-A(j,59)%j &
       -A(j,61)%j-A(j,63)%j-A(j,64)%j-A(j,67)%j-A(j,69)%j-A(j,80)%j-A(j,82)%j-A(j,84)%j-A(j,86)%j+A(j,92)%j+A(j,93)%j+A(j,96)%j &
       +A(j,98)%j+A(j,100)%j+A(j,101)%j+A(j,104)%j+A(j,106)%j+A(j,117)%j+A(j,119)%j+A(j,121)%j+A(j,122)%j+A(j,141)%j+A(j,143)%j &
       +A(j,145)%j+A(j,147)%j-A(j,149)%j-A(j,151)%j-A(j,153)%j-A(j,154)%j-A(j,157)%j-A(j,159)%j-A(j,161)%j-A(j,163)%j-A(j,167)%j &
       -A(j,168)%j-A(j,171)%j-A(j,172)%j+A(j,174)%j+A(j,176)%j+A(j,178)%j+A(j,180)%j-A(j,182)%j-A(j,183)%j-A(j,186)%j-A(j,188)%j &
       +A(j,192)%j+A(j,193)%j+A(j,196)%j+A(j,197)%j+A(j,199)%j+A(j,200)%j+A(j,203)%j+A(j,205)%j+A(j,207)%j+A(j,209)%j+A(j,211)%j &
       +A(j,212)%j+A(j,217)%j+A(j,218)%j+A(j,221)%j+A(j,222)%j-A(j,224)%j-A(j,226)%j-A(j,228)%j-A(j,229)%j+A(j,232)%j+A(j,234)%j &
       +A(j,236)%j+A(j,238)%j-A(j,242)%j-A(j,243)%j-A(j,246)%j-A(j,247)%j-A(j,249)%j-A(j,251)%j-A(j,253)%j-A(j,255)%j+A(j,271)%j &
       +A(j,272)%j+A(j,275)%j+A(j,276)%j+A(j,283)%j+A(j,284)%j+A(j,287)%j+A(j,288)%j+A(j,295)%j+A(j,296)%j+A(j,299)%j+A(j,300)%j &
       +A(j,307)%j+A(j,308)%j+A(j,311)%j+A(j,312)%j+A(j,315)%j+A(j,316)%j+A(j,319)%j+A(j,320)%j+A(j,322)%j+A(j,324)%j+A(j,326)%j &
       +A(j,328)%j+A(j,330)%j+A(j,332)%j+A(j,334)%j+A(j,336)%j+A(j,338)%j+A(j,340)%j+A(j,342)%j+A(j,344)%j+A(j,350)%j+A(j,351)%j &
       +A(j,354)%j+A(j,355)%j+A(j,362)%j+A(j,363)%j+A(j,366)%j+A(j,367)%j-A(j,384)%j-A(j,385)%j-A(j,388)%j-A(j,389)%j-A(j,396)%j &
       -A(j,397)%j-A(j,400)%j-A(j,401)%j-A(j,408)%j-A(j,409)%j-A(j,412)%j-A(j,413)%j-A(j,420)%j-A(j,421)%j-A(j,424)%j-A(j,425)%j &
       -A(j,428)%j-A(j,429)%j-A(j,432)%j-A(j,433)%j-A(j,435)%j-A(j,437)%j-A(j,439)%j-A(j,441)%j-A(j,443)%j-A(j,445)%j-A(j,447)%j &
       -A(j,448)%j-A(j,455)%j-A(j,456)%j-A(j,459)%j-A(j,460)%j-A(j,463)%j-A(j,465)%j-A(j,467)%j-A(j,469)%j-A(j,475)%j-A(j,476)%j &
       -A(j,479)%j-A(j,480)%j-A(j,483)%j-A(j,485)%j-A(j,487)%j-A(j,489)%j-A(j,491)%j-A(j,493)%j-A(j,495)%j-A(j,497)%j-A(j,499)%j &
       -A(j,501)%j-A(j,503)%j-A(j,505)%j-A(j,511)%j-A(j,512)%j-A(j,515)%j-A(j,516)%j-A(j,523)%j-A(j,524)%j-A(j,527)%j-A(j,528)%j &
       +A(j,531)%j+A(j,533)%j+A(j,535)%j+A(j,537)%j+A(j,539)%j+A(j,541)%j+A(j,543)%j+A(j,544)%j+A(j,551)%j+A(j,552)%j+A(j,555)%j &
       +A(j,556)%j+A(j,559)%j+A(j,561)%j+A(j,563)%j+A(j,565)%j+A(j,571)%j+A(j,572)%j+A(j,575)%j+A(j,576)%j)*f(5)+(-A(j,57)%j &
       -A(j,58)%j-A(j,60)%j-A(j,62)%j-A(j,65)%j-A(j,66)%j-A(j,68)%j-A(j,70)%j-A(j,72)%j-A(j,73)%j-A(j,74)%j-A(j,75)%j-A(j,76)%j &
       -A(j,77)%j-A(j,78)%j-A(j,79)%j-A(j,81)%j-A(j,83)%j-A(j,85)%j-A(j,87)%j+A(j,94)%j+A(j,95)%j+A(j,97)%j+A(j,99)%j+A(j,102)%j &
       +A(j,103)%j+A(j,105)%j+A(j,107)%j+A(j,109)%j+A(j,110)%j+A(j,111)%j+A(j,112)%j+A(j,113)%j+A(j,114)%j+A(j,115)%j+A(j,116)%j &
       +A(j,118)%j+A(j,120)%j+A(j,123)%j+A(j,124)%j+A(j,125)%j+A(j,126)%j+A(j,127)%j+A(j,128)%j+A(j,129)%j+A(j,130)%j+A(j,131)%j &
       +A(j,132)%j-A(j,133)%j-A(j,134)%j-A(j,135)%j-A(j,136)%j-A(j,137)%j-A(j,138)%j-A(j,139)%j-A(j,140)%j+A(j,142)%j+A(j,144)%j &
       +A(j,146)%j+A(j,148)%j-A(j,150)%j-A(j,152)%j-A(j,155)%j-A(j,156)%j-A(j,158)%j-A(j,160)%j-A(j,162)%j-A(j,164)%j-A(j,169)%j &
       -A(j,173)%j+A(j,175)%j+A(j,177)%j+A(j,179)%j+A(j,181)%j-A(j,184)%j-A(j,185)%j-A(j,187)%j-A(j,189)%j+A(j,194)%j+A(j,198)%j &
       +A(j,201)%j+A(j,202)%j+A(j,204)%j+A(j,206)%j+A(j,208)%j+A(j,210)%j+A(j,213)%j+A(j,214)%j+A(j,219)%j+A(j,223)%j-A(j,225)%j &
       -A(j,227)%j-A(j,230)%j-A(j,231)%j+A(j,233)%j+A(j,235)%j+A(j,237)%j+A(j,239)%j-A(j,244)%j-A(j,248)%j-A(j,250)%j-A(j,252)%j &
       -A(j,254)%j-A(j,256)%j+A(j,273)%j+A(j,277)%j+A(j,285)%j+A(j,289)%j+A(j,297)%j+A(j,301)%j+A(j,309)%j+A(j,313)%j+A(j,317)%j &
       +A(j,321)%j+A(j,323)%j+A(j,325)%j+A(j,327)%j+A(j,329)%j+A(j,331)%j+A(j,333)%j+A(j,335)%j+A(j,337)%j+A(j,339)%j+A(j,341)%j &
       +A(j,343)%j+A(j,345)%j+A(j,352)%j+A(j,353)%j+A(j,356)%j+A(j,357)%j+A(j,364)%j+A(j,365)%j+A(j,368)%j+A(j,369)%j-A(j,386)%j &
       -A(j,390)%j-A(j,398)%j-A(j,402)%j-A(j,410)%j-A(j,414)%j-A(j,422)%j-A(j,426)%j-A(j,430)%j-A(j,434)%j-A(j,436)%j-A(j,438)%j &
       -A(j,440)%j-A(j,442)%j-A(j,444)%j-A(j,446)%j-A(j,449)%j-A(j,450)%j-A(j,457)%j-A(j,458)%j-A(j,461)%j-A(j,462)%j-A(j,464)%j &
       -A(j,466)%j-A(j,468)%j-A(j,470)%j-A(j,477)%j-A(j,478)%j-A(j,481)%j-A(j,482)%j-A(j,484)%j-A(j,486)%j-A(j,488)%j-A(j,490)%j &
       -A(j,492)%j-A(j,494)%j-A(j,496)%j-A(j,498)%j-A(j,500)%j-A(j,502)%j-A(j,504)%j-A(j,506)%j-A(j,513)%j-A(j,514)%j-A(j,517)%j &
       -A(j,518)%j-A(j,525)%j-A(j,526)%j-A(j,529)%j-A(j,530)%j+A(j,532)%j+A(j,534)%j+A(j,536)%j+A(j,538)%j+A(j,540)%j+A(j,542)%j &
       +A(j,545)%j+A(j,546)%j+A(j,553)%j+A(j,554)%j+A(j,557)%j+A(j,558)%j+A(j,560)%j+A(j,562)%j+A(j,564)%j+A(j,566)%j+A(j,573)%j &
       +A(j,574)%j+A(j,577)%j+A(j,578)%j)*f(6)+(A(j,165)%j-A(j,190)%j-A(j,215)%j+A(j,240)%j-A(j,259)%j-A(j,260)%j-A(j,263)%j &
       -A(j,264)%j-A(j,265)%j+A(j,372)%j+A(j,373)%j+A(j,376)%j+A(j,377)%j+A(j,378)%j)*f(8)+(-A(j,257)%j-A(j,258)%j-A(j,261)%j &
       -A(j,262)%j+A(j,370)%j+A(j,371)%j+A(j,374)%j+A(j,375)%j)*f(9)+(-A(j,71)%j+A(j,108)%j)*f(10)+(-A(j,266)%j-A(j,268)%j &
       -A(j,278)%j-A(j,280)%j-A(j,290)%j-A(j,292)%j-A(j,302)%j-A(j,304)%j+A(j,379)%j+A(j,381)%j+A(j,391)%j+A(j,393)%j+A(j,403)%j &
       +A(j,405)%j+A(j,415)%j+A(j,417)%j)*f(11)+(-A(j,267)%j-A(j,269)%j-A(j,279)%j-A(j,281)%j-A(j,291)%j-A(j,293)%j-A(j,303)%j &
       -A(j,305)%j-A(j,346)%j-A(j,347)%j-A(j,348)%j-A(j,349)%j-A(j,358)%j-A(j,359)%j-A(j,360)%j-A(j,361)%j+A(j,380)%j+A(j,382)%j &
       +A(j,392)%j+A(j,394)%j+A(j,404)%j+A(j,406)%j+A(j,416)%j+A(j,418)%j+A(j,451)%j+A(j,452)%j+A(j,453)%j+A(j,454)%j+A(j,471)%j &
       +A(j,472)%j+A(j,473)%j+A(j,474)%j+A(j,507)%j+A(j,508)%j+A(j,509)%j+A(j,510)%j+A(j,519)%j+A(j,520)%j+A(j,521)%j+A(j,522)%j &
       -A(j,547)%j-A(j,548)%j-A(j,549)%j-A(j,550)%j-A(j,567)%j-A(j,568)%j-A(j,569)%j-A(j,570)%j)*f(12)+(A(j,51)%j-A(j,88)%j)*f(13) &
       +(A(j,52)%j+A(j,53)%j-A(j,89)%j-A(j,90)%j)*f(14)+(A(j,54)%j-A(j,91)%j)*f(15)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexbbx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexbbx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexbbx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexbbx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eeexexbbx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppllll_ew_eeexexbbx_1_/**/REALKIND
