
module ol_colourmatrix_ppllll_ew_neeexexuxd_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 3]

  K2(1,:) = [ 3]

  KL(1,:) = [ 3]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllll_ew_neeexexuxd_1_/**/REALKIND



module ol_forced_parameters_ppllll_ew_neeexexuxd_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllll_ew_neeexexuxd_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppllll_ew_neeexexuxd_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(290)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,28), wf8(8,153), wf16(16,64), wf64(64,188)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(138), c(129)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(1,64)

end module ol_loop_storage_ppllll_ew_neeexexuxd_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppllll_ew_neeexexuxd_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllll_ew_neeexexuxd_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*eQED**4)/(4._/**/REALKIND*sw**4)
    f(  2) = (CI*countertermnorm*eQED**6)/(4._/**/REALKIND*sw**4)
    f(  3) = (CI*countertermnorm*eQED**6*EWctVen)/(4._/**/REALKIND*sw**4)
    f(  4) = (CI*countertermnorm*eQED**6*EWctVne)/(4._/**/REALKIND*sw**4)
    f(  5) = (CI*countertermnorm*eQED**6*EWctVud)/(4._/**/REALKIND*sw**4)
    f(  6) = (CI*cw*eQED**4)/(2._/**/REALKIND*sw**3)
    f(  7) = (CI*countertermnorm*cw*eQED**6)/(2._/**/REALKIND*sw**3)
    f(  8) = (CI*countertermnorm*cw*eQED**6*EWctVne)/(2._/**/REALKIND*sw**3)
    f(  9) = (CI*countertermnorm*cw*eQED**6*EWctVud)/(2._/**/REALKIND*sw**3)
    f( 10) = (CI*eQED**4)/(6._/**/REALKIND*sw**2)
    f( 11) = (CI*eQED**4)/(3._/**/REALKIND*sw**2)
    f( 12) = (CI*eQED**4)/(2._/**/REALKIND*sw**2)
    f( 13) = (CI*countertermnorm*eQED**6)/(6._/**/REALKIND*sw**2)
    f( 14) = (CI*countertermnorm*eQED**6)/(3._/**/REALKIND*sw**2)
    f( 15) = (CI*countertermnorm*eQED**6)/(2._/**/REALKIND*sw**2)
    f( 16) = (CI*countertermnorm*eQED**6*EWctAWW)/(2._/**/REALKIND*sw**2)
    f( 17) = (CI*countertermnorm*eQED**6*EWctVne)/(6._/**/REALKIND*sw**2)
    f( 18) = (CI*countertermnorm*eQED**6*EWctVne)/(3._/**/REALKIND*sw**2)
    f( 19) = (CI*countertermnorm*eQED**6*EWctVne)/(2._/**/REALKIND*sw**2)
    f( 20) = (CI*countertermnorm*eQED**6*EWctVud)/(6._/**/REALKIND*sw**2)
    f( 21) = (CI*countertermnorm*eQED**6*EWctVud)/(3._/**/REALKIND*sw**2)
    f( 22) = (CI*countertermnorm*eQED**6*EWctVud)/(2._/**/REALKIND*sw**2)
    f( 23) = (CI*countertermnorm*eQED**6*EWctZWW)/(2._/**/REALKIND*sw**2)
    f( 24) = (CI*countertermnorm*eQED**6*MW)/(2._/**/REALKIND*sw**2)
    f( 25) = (CI*countertermnorm*eQED**6*MW)/(2._/**/REALKIND*cw*sw)
    f( 26) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*6._/**/REALKIND)
    f( 27) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*3._/**/REALKIND)
    f( 28) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 29) = (eQED**6*integralnorm*SwB)/(sw**6*16._/**/REALKIND)
    f( 30) = (eQED**6*integralnorm*SwB)/(sw**6*8._/**/REALKIND)
    f( 31) = (eQED**6*integralnorm*SwB)/(sw**6*4._/**/REALKIND)
    f( 32) = (cw**2*eQED**6*integralnorm*SwB)/(sw**6*4._/**/REALKIND)
    f( 33) = (eQED**6*integralnorm*MW**2*SwB)/(sw**6*4._/**/REALKIND)
    f( 34) = (eQED**6*integralnorm*SwB)/(cw*sw**5*16._/**/REALKIND)
    f( 35) = (eQED**6*integralnorm*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 36) = (cw*eQED**6*integralnorm*SwB)/(sw**5*8._/**/REALKIND)
    f( 37) = (cw*eQED**6*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f( 38) = (cw*eQED**6*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f( 39) = (cw**3*eQED**6*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f( 40) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw**5*2._/**/REALKIND)
    f( 41) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**5*2._/**/REALKIND)
    f( 42) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**5*4._/**/REALKIND)
    f( 43) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**5*2._/**/REALKIND)
    f( 44) = (eQED**6*integralnorm*SwB)/(sw**4*24._/**/REALKIND)
    f( 45) = (eQED**6*integralnorm*SwB)/(sw**4*18._/**/REALKIND)
    f( 46) = (eQED**6*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f( 47) = (eQED**6*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f( 48) = (eQED**6*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 49) = (eQED**6*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 50) = (eQED**6*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 51) = (eQED**6*integralnorm*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f( 52) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 53) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*3._/**/REALKIND)
    f( 54) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 55) = (eQED**6*integralnorm*MH**2*SwB)/(sw**4*8._/**/REALKIND)
    f( 56) = (eQED**6*integralnorm*MH**2*SwB)/(sw**4*4._/**/REALKIND)
    f( 57) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*6._/**/REALKIND)
    f( 58) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f( 59) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*3._/**/REALKIND)
    f( 60) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f( 61) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**4*2._/**/REALKIND)
    f( 62) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f( 63) = (eQED**6*integralnorm*SwB)/(cw*sw**3*8._/**/REALKIND)
    f( 64) = (cw*eQED**6*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f( 65) = (cw*eQED**6*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f( 66) = (cw*eQED**6*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f( 67) = (cw*eQED**6*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 68) = (eQED**6*integralnorm*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f( 69) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f( 70) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f( 71) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f( 72) = (eQED**6*integralnorm*SwB)/(sw**2*54._/**/REALKIND)
    f( 73) = (eQED**6*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f( 74) = (eQED**6*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f( 75) = (2*eQED**6*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f( 76) = (eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 77) = (4*eQED**6*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f( 78) = (eQED**6*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f( 79) = (2*eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 80) = (eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 81) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f( 82) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f( 83) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f( 84) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f( 85) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f( 86) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f( 87) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f( 88) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f( 89) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*16._/**/REALKIND))
    f( 90) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f( 91) = -((eQED**6*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f( 92) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f( 93) = -((eQED**6*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f( 94) = (eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f( 95) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f( 96) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f( 97) = (eQED**6*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f( 98) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*6._/**/REALKIND))
    f( 99) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(100) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(101) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(102) = (eQED**6*integralnorm*SwF)/(sw**6*8._/**/REALKIND)
    f(103) = (eQED**6*integralnorm*SwF)/(sw**6*4._/**/REALKIND)
    f(104) = (cw*eQED**6*integralnorm*SwF)/(sw**5*4._/**/REALKIND)
    f(105) = (cw*eQED**6*integralnorm*SwF)/(sw**5*2._/**/REALKIND)
    f(106) = (eQED**6*integralnorm*SwF)/(sw**4*12._/**/REALKIND)
    f(107) = (eQED**6*integralnorm*SwF)/(sw**4*6._/**/REALKIND)
    f(108) = (eQED**6*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(109) = (eQED**6*integralnorm*SwF)/(sw**4*3._/**/REALKIND)
    f(110) = (eQED**6*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(111) = (eQED**6*integralnorm*MB*SwF)/(sw**4*12._/**/REALKIND)
    f(112) = (eQED**6*integralnorm*MB*SwF)/(sw**4*4._/**/REALKIND)
    f(113) = (eQED**6*integralnorm*ML*SwF)/(sw**4*4._/**/REALKIND)
    f(114) = (eQED**6*integralnorm*MT*SwF)/(sw**4*6._/**/REALKIND)
    f(115) = (eQED**6*integralnorm*MT*SwF)/(sw**4*4._/**/REALKIND)
    f(116) = (eQED**6*integralnorm*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(117) = (cw*eQED**6*integralnorm*SwF)/(sw**3*6._/**/REALKIND)
    f(118) = (cw*eQED**6*integralnorm*SwF)/(sw**3*3._/**/REALKIND)
    f(119) = (cw*eQED**6*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(120) = (2*cw*eQED**6*integralnorm*SwF)/(sw**3*3._/**/REALKIND)
    f(121) = (cw*eQED**6*integralnorm*SwF)/sw**3
    f(122) = (3*cw*eQED**6*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(123) = (eQED**6*integralnorm*ML*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(124) = (eQED**6*integralnorm*SwF)/(sw**2*54._/**/REALKIND)
    f(125) = (eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(126) = (eQED**6*integralnorm*SwF)/(sw**2*18._/**/REALKIND)
    f(127) = (2*eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(128) = (eQED**6*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(129) = (4*eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(130) = (eQED**6*integralnorm*SwF)/(sw**2*6._/**/REALKIND)
    f(131) = (2*eQED**6*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(132) = (8*eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(133) = (eQED**6*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(134) = (4*eQED**6*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(135) = (eQED**6*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(136) = (2*eQED**6*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(137) = (eQED**6*integralnorm*SwF)/sw**2
    f(138) = (3*eQED**6*integralnorm*SwF)/(sw**2*2._/**/REALKIND)

  c = [ f(26), f(27), f(28), f(29), f(30), f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38), f(39), f(40), f(41), f(42) &
    , f(43), f(44), f(45), f(46), f(47), f(48), f(49), f(50), f(51), f(52), f(53), f(54), f(55), f(56), f(57), f(58), f(59), f(60) &
    , f(61), f(62), f(63), f(64), f(65), f(66), f(67), f(68), f(69), f(70), f(71), f(72), f(73), f(74), f(75), f(76), f(77), f(78) &
    , f(79), f(80), f(81), f(82), f(83), f(84), f(85), f(86), f(87), f(88), f(89), f(90), f(91), f(92), f(93), f(94), f(95), f(96) &
    , f(97), f(98), f(99), f(100), f(101), f(102), 3*f(102), f(103), 3*f(103), f(104), 3*f(104), f(105), 3*f(105), f(106) &
    , 3*f(106), f(107), 3*f(107), f(108), 3*f(108), f(109), 3*f(109), f(110), 3*f(110), 3*f(111), 3*f(112), f(113), 3*f(114) &
    , 3*f(115), 3*f(116), 3*f(117), 3*f(118), f(119), 3*f(119), 3*f(120), f(121), 3*f(121), f(122), f(123), 3*f(124), 3*f(125) &
    , 3*f(126), 3*f(127), 3*f(128), 3*f(129), f(130), 3*f(130), 3*f(131), 3*f(132), f(133), 3*f(133), 3*f(134), f(135), 3*f(135) &
    , f(136), 3*f(136), f(137), 3*f(137), f(138) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MW2)+L(6,5))
  den(2) = 1 /((L(5,10))+L(6,10))
  den(3) = 1 /((L(5,48) - MW2)+L(6,48))
  den(6) = 1 /((L(5,10) - MZ2)+L(6,10))
  den(9) = 1 /((L(5,21))+L(6,21))
  den(13) = 1 /((L(5,26))+L(6,26))
  den(18) = 1 /((L(5,7))+L(6,7))
  den(21) = 1 /((L(5,9) - MW2)+L(6,9))
  den(22) = 1 /((L(5,6))+L(6,6))
  den(25) = 1 /((L(5,6) - MZ2)+L(6,6))
  den(28) = 1 /((L(5,25))+L(6,25))
  den(32) = 1 /((L(5,22))+L(6,22))
  den(39) = 1 /((L(5,49))+L(6,49))
  den(43) = 1 /((L(5,11))+L(6,11))
  den(50) = 1 /((L(5,37))+L(6,37))
  den(54) = 1 /((L(5,42))+L(6,42))
  den(59) = 1 /((L(5,41))+L(6,41))
  den(63) = 1 /((L(5,38))+L(6,38))
  den(68) = 1 /((L(5,56))+L(6,56))
  den(71) = 1 /((L(5,52))+L(6,52))
  den(76) = 1 /((L(5,14))+L(6,14))
  den(88) = 1 /((L(5,58) - MW2)+L(6,58))
  den(95) = 1 /((L(5,53))+L(6,53))
  den(98) = 1 /((L(5,53) - MZ2)+L(6,53))
  den(103) = 1 /((L(5,15) - MW2)+L(6,15))
  den(131) = 1 /((L(5,54) - MW2)+L(6,54))
  den(138) = 1 /((L(5,57))+L(6,57))
  den(141) = 1 /((L(5,57) - MZ2)+L(6,57))
  den(193) = 1 /((L(5,53) - MH2)+L(6,53))
  den(207) = 1 /((L(5,57) - MH2)+L(6,57))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(2)*den(10)
  den(12) = den(6)*den(10)
  den(14) = den(2)*den(13)
  den(15) = den(1)*den(14)
  den(16) = den(6)*den(13)
  den(17) = den(1)*den(16)
  den(19) = den(1)*den(18)
  den(20) = den(3)*den(19)
  den(23) = den(21)*den(22)
  den(24) = den(3)*den(23)
  den(26) = den(21)*den(25)
  den(27) = den(3)*den(26)
  den(29) = den(21)*den(28)
  den(30) = den(22)*den(29)
  den(31) = den(25)*den(29)
  den(33) = den(22)*den(32)
  den(34) = den(21)*den(33)
  den(35) = den(25)*den(32)
  den(36) = den(21)*den(35)
  den(37) = den(18)*den(25)
  den(38) = den(3)*den(37)
  den(40) = den(3)*den(39)
  den(41) = den(22)*den(40)
  den(42) = den(25)*den(40)
  den(44) = den(21)*den(43)
  den(45) = den(3)*den(44)
  den(46) = den(6)*den(43)
  den(47) = den(3)*den(46)
  den(48) = den(2)*den(40)
  den(49) = den(6)*den(40)
  den(51) = den(1)*den(50)
  den(52) = den(2)*den(51)
  den(53) = den(6)*den(51)
  den(55) = den(2)*den(54)
  den(56) = den(1)*den(55)
  den(57) = den(6)*den(54)
  den(58) = den(1)*den(57)
  den(60) = den(21)*den(59)
  den(61) = den(22)*den(60)
  den(62) = den(25)*den(60)
  den(64) = den(22)*den(63)
  den(65) = den(21)*den(64)
  den(66) = den(25)*den(63)
  den(67) = den(21)*den(66)
  den(69) = den(3)*den(68)
  den(70) = den(1)*den(69)
  den(72) = den(3)*den(71)
  den(73) = den(21)*den(72)
  den(74) = den(22)*den(69)
  den(75) = den(25)*den(69)
  den(77) = den(22)*den(76)
  den(78) = den(3)*den(77)
  den(79) = den(25)*den(76)
  den(80) = den(3)*den(79)
  den(81) = den(2)*den(72)
  den(82) = den(6)*den(72)
  den(83) = den(2)*den(76)
  den(84) = den(3)*den(83)
  den(85) = den(6)*den(76)
  den(86) = den(3)*den(85)
  den(87) = den(2)*den(3)
  den(89) = den(87)*den(88)
  den(90) = den(1)*den(89)
  den(91) = den(3)*den(6)
  den(92) = den(88)*den(91)
  den(93) = den(1)*den(92)
  den(94) = den(1)*den(3)
  den(96) = den(94)*den(95)
  den(97) = den(2)*den(96)
  den(99) = den(94)*den(98)
  den(100) = den(2)*den(99)
  den(101) = den(6)*den(96)
  den(102) = den(6)*den(99)
  den(104) = den(4)*den(103)
  den(105) = den(3)*den(104)
  den(106) = den(7)*den(103)
  den(107) = den(3)*den(106)
  den(108) = den(1)**2
  den(109) = den(55)*den(108)
  den(110) = den(57)*den(108)
  den(111) = den(14)*den(108)
  den(112) = den(16)*den(108)
  den(113) = den(2)**2
  den(114) = den(51)*den(113)
  den(115) = den(2)*den(6)
  den(116) = den(51)*den(115)
  den(117) = den(6)**2
  den(118) = den(51)*den(117)
  den(119) = den(10)*den(113)
  den(120) = den(10)*den(115)
  den(121) = den(10)*den(117)
  den(122) = den(10)*den(55)
  den(123) = den(10)*den(57)
  den(124) = den(14)*den(51)
  den(125) = den(16)*den(51)
  den(126) = den(69)*den(108)
  den(127) = den(19)*den(69)
  den(128) = den(3)**2
  den(129) = den(19)*den(128)
  den(130) = den(3)*den(22)
  den(132) = den(130)*den(131)
  den(133) = den(21)*den(132)
  den(134) = den(3)*den(25)
  den(135) = den(131)*den(134)
  den(136) = den(21)*den(135)
  den(137) = den(3)*den(21)
  den(139) = den(137)*den(138)
  den(140) = den(22)*den(139)
  den(142) = den(137)*den(141)
  den(143) = den(22)*den(142)
  den(144) = den(25)*den(139)
  den(145) = den(25)*den(142)
  den(146) = den(23)*den(103)
  den(147) = den(3)*den(146)
  den(148) = den(26)*den(103)
  den(149) = den(3)*den(148)
  den(150) = den(21)**2
  den(151) = den(64)*den(150)
  den(152) = den(66)*den(150)
  den(153) = den(33)*den(150)
  den(154) = den(35)*den(150)
  den(155) = den(22)**2
  den(156) = den(60)*den(155)
  den(157) = den(22)*den(25)
  den(158) = den(60)*den(157)
  den(159) = den(25)**2
  den(160) = den(60)*den(159)
  den(161) = den(29)*den(155)
  den(162) = den(29)*den(157)
  den(163) = den(29)*den(159)
  den(164) = den(29)*den(64)
  den(165) = den(29)*den(66)
  den(166) = den(33)*den(60)
  den(167) = den(35)*den(60)
  den(168) = den(69)*den(157)
  den(169) = den(69)*den(159)
  den(170) = den(37)*den(69)
  den(171) = den(40)*den(77)
  den(172) = den(40)*den(79)
  den(173) = den(77)*den(128)
  den(174) = den(79)*den(128)
  den(175) = den(40)*den(155)
  den(176) = den(40)*den(157)
  den(177) = den(40)*den(159)
  den(178) = den(37)*den(128)
  den(179) = den(72)*den(150)
  den(180) = den(44)*den(72)
  den(181) = den(44)*den(128)
  den(182) = den(72)*den(115)
  den(183) = den(72)*den(117)
  den(184) = den(46)*den(72)
  den(185) = den(40)*den(83)
  den(186) = den(40)*den(85)
  den(187) = den(83)*den(128)
  den(188) = den(85)*den(128)
  den(189) = den(40)*den(113)
  den(190) = den(40)*den(115)
  den(191) = den(40)*den(117)
  den(192) = den(46)*den(128)
  den(194) = den(94)*den(193)
  den(195) = den(19)*den(103)
  den(196) = den(10)*den(95)
  den(197) = den(10)*den(98)
  den(198) = den(51)*den(95)
  den(199) = den(51)*den(98)
  den(200) = den(37)*den(103)
  den(201) = den(77)*den(103)
  den(202) = den(79)*den(103)
  den(203) = den(33)*den(131)
  den(204) = den(35)*den(131)
  den(205) = den(64)*den(131)
  den(206) = den(66)*den(131)
  den(208) = den(137)*den(207)
  den(209) = den(44)*den(103)
  den(210) = den(29)*den(138)
  den(211) = den(29)*den(141)
  den(212) = den(60)*den(138)
  den(213) = den(60)*den(141)
  den(214) = den(46)*den(103)
  den(215) = den(83)*den(103)
  den(216) = den(85)*den(103)
  den(217) = den(14)*den(88)
  den(218) = den(16)*den(88)
  den(219) = den(55)*den(88)
  den(220) = den(57)*den(88)
  den(221) = den(40)*den(95)
  den(222) = den(40)*den(98)
  den(223) = den(72)*den(98)
  den(224) = den(40)*den(138)
  den(225) = den(40)*den(141)
  den(226) = den(69)*den(141)
  den(227) = den(72)*den(131)
  den(228) = den(69)*den(88)
  den(229) = den(1)*den(2)*den(3)
  den(230) = den(1)*den(3)*den(6)
  den(231) = den(3)*den(21)*den(22)
  den(232) = den(3)*den(21)*den(25)
  den(233) = den(1)*den(87)
  den(234) = den(1)*den(91)
  den(235) = den(2)*den(94)
  den(236) = den(6)*den(94)
  den(237) = den(21)*den(130)
  den(238) = den(21)*den(134)
  den(239) = den(22)*den(137)
  den(240) = den(25)*den(137)
  den(241) = den(2)*den(194)
  den(242) = den(6)*den(194)
  den(243) = den(2)*den(196)
  den(244) = den(2)*den(197)
  den(245) = den(6)*den(196)
  den(246) = den(6)*den(197)
  den(247) = den(2)*den(198)
  den(248) = den(2)*den(199)
  den(249) = den(6)*den(198)
  den(250) = den(6)*den(199)
  den(251) = den(1)*den(217)
  den(252) = den(1)*den(218)
  den(253) = den(1)*den(219)
  den(254) = den(1)*den(220)
  den(255) = den(3)*den(195)
  den(256) = den(1)*den(228)
  den(257) = den(22)*den(208)
  den(258) = den(25)*den(208)
  den(259) = den(22)*den(210)
  den(260) = den(22)*den(211)
  den(261) = den(25)*den(210)
  den(262) = den(25)*den(211)
  den(263) = den(22)*den(212)
  den(264) = den(22)*den(213)
  den(265) = den(25)*den(212)
  den(266) = den(25)*den(213)
  den(267) = den(21)*den(203)
  den(268) = den(21)*den(204)
  den(269) = den(21)*den(205)
  den(270) = den(21)*den(206)
  den(271) = den(3)*den(200)
  den(272) = den(22)*den(224)
  den(273) = den(22)*den(225)
  den(274) = den(25)*den(224)
  den(275) = den(25)*den(225)
  den(276) = den(3)*den(201)
  den(277) = den(3)*den(202)
  den(278) = den(22)*den(226)
  den(279) = den(25)*den(226)
  den(280) = den(3)*den(209)
  den(281) = den(21)*den(227)
  den(282) = den(3)*den(214)
  den(283) = den(2)*den(221)
  den(284) = den(2)*den(222)
  den(285) = den(6)*den(221)
  den(286) = den(6)*den(222)
  den(287) = den(3)*den(215)
  den(288) = den(3)*den(216)
  den(289) = den(2)*den(223)
  den(290) = den(6)*den(223)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppllll_ew_neeexexuxd_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e e- e+ e+ anti-up down -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllll_ew_neeexexuxd_1, only: external_perm_ppllll_ew_neeexexuxd_1, &
    & external_perm_inv_ppllll_ew_neeexexuxd_1, extcomb_perm_ppllll_ew_neeexexuxd_1, &
    & average_factor_ppllll_ew_neeexexuxd_1
  use ol_external_ppllll_ew_neeexexuxd_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllll_ew_neeexexuxd_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllll_ew_neeexexuxd_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppllll_ew_neeexexuxd_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1) 
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,64)
  type(Hpolcont) :: M1helarray_ct(1,64)

  type(Hpolcont) :: A(64,188)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(188)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppllll_ew_neeexexuxd_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_A(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_Q(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex1(:), ex3(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex2(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_QA_W(ntry, ex6(:), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_UV_W(ntry, wf4(:,2), 10, wf4(:,1), 5, wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_QA_Z(gZl,ntry, ex2(:), ex4(:), wf4(:,4), n3(:,5), t3x4(:,:,4))
  call vert_UV_W(ntry, wf4(:,4), 10, wf4(:,1), 5, wf16(:,2), n3(:,6), t3x16(:,:,2))
  call vert_AW_Q(ntry, ex5(:), wf4(:,1), wf8(:,1), n3(:,7), t3x8(:,:,1))
  call vert_VQ_A(ntry, wf4(:,2), ex6(:), wf8(:,2), n3(:,8), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,1), 21, ZERO, 0_intkind1, wf8(:,3), n2(1))
  call vert_ZQ_A(gZd,ntry, wf4(:,4), ex6(:), wf8(:,4), n3(:,9), t3x8(:,:,3))
  call vert_AV_Q(ntry, ex5(:), wf4(:,2), wf8(:,5), n3(:,10), t3x8(:,:,4))
  call vert_WQ_A(ntry, wf4(:,1), ex6(:), wf8(:,6), n3(:,11), t3x8(:,:,5))
  call prop_A_Q(ntry, wf8(:,5), 26, ZERO, 0_intkind1, wf8(:,7), n2(2))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,4), wf8(:,8), n3(:,12), t3x8(:,:,6))
  call prop_A_Q(ntry, wf8(:,8), 26, ZERO, 0_intkind1, wf8(:,9), n2(3))
  call vert_WQ_A(ntry, wf4(:,1), ex2(:), wf8(:,10), n3(:,13), t3x8(:,:,7))
  call vert_AW_Q(ntry, ex4(:), wf4(:,3), wf8(:,11), n3(:,14), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,10), 7, ZERO, 0_intkind1, wf8(:,12), n2(4))
  call vert_QA_W(ntry, ex1(:), ex4(:), wf4(:,5), n3(:,15), t3x4(:,:,5))
  call vert_QA_V(ntry, ex2(:), ex3(:), wf4(:,6), n3(:,16), t3x4(:,:,6))
  call vert_UV_W(ntry, wf4(:,6), 6, wf4(:,5), 9, wf16(:,3), n3(:,17), t3x16(:,:,3))
  call vert_QA_Z(gZl,ntry, ex2(:), ex3(:), wf4(:,7), n3(:,18), t3x4(:,:,7))
  call vert_UV_W(ntry, wf4(:,7), 6, wf4(:,5), 9, wf16(:,4), n3(:,19), t3x16(:,:,4))
  call vert_AW_Q(ntry, ex5(:), wf4(:,5), wf8(:,13), n3(:,20), t3x8(:,:,9))
  call vert_VQ_A(ntry, wf4(:,6), ex6(:), wf8(:,14), n3(:,21), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,13), 25, ZERO, 0_intkind1, wf8(:,15), n2(5))
  call vert_ZQ_A(gZd,ntry, wf4(:,7), ex6(:), wf8(:,16), n3(:,22), t3x8(:,:,11))
  call vert_AV_Q(ntry, ex5(:), wf4(:,6), wf8(:,17), n3(:,23), t3x8(:,:,12))
  call vert_WQ_A(ntry, wf4(:,5), ex6(:), wf8(:,18), n3(:,24), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,17), 22, ZERO, 0_intkind1, wf8(:,19), n2(6))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,7), wf8(:,20), n3(:,25), t3x8(:,:,14))
  call prop_A_Q(ntry, wf8(:,20), 22, ZERO, 0_intkind1, wf8(:,21), n2(7))
  call vert_ZQ_A(gZn,ntry, wf4(:,7), ex1(:), wf8(:,22), n3(:,26), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,22), 7, ZERO, 0_intkind1, wf8(:,23), n2(8))
  call vert_WQ_A(ntry, wf4(:,3), ex1(:), wf8(:,24), n3(:,27), t3x8(:,:,16))
  call vert_AV_Q(ntry, ex4(:), wf4(:,6), wf8(:,25), n3(:,28), t3x8(:,:,17))
  call prop_Q_A(ntry, wf8(:,24), 49, ZERO, 0_intkind1, wf8(:,26), n2(9))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,7), wf8(:,27), n3(:,29), t3x8(:,:,18))
  call vert_WQ_A(ntry, wf4(:,5), ex2(:), wf8(:,28), n3(:,30), t3x8(:,:,19))
  call vert_AW_Q(ntry, ex3(:), wf4(:,3), wf8(:,29), n3(:,31), t3x8(:,:,20))
  call prop_Q_A(ntry, wf8(:,28), 11, ZERO, 0_intkind1, wf8(:,30), n2(10))
  call vert_ZQ_A(gZn,ntry, wf4(:,4), ex1(:), wf8(:,31), n3(:,32), t3x8(:,:,21))
  call prop_Q_A(ntry, wf8(:,31), 11, ZERO, 0_intkind1, wf8(:,32), n2(11))
  call vert_AV_Q(ntry, ex3(:), wf4(:,2), wf8(:,33), n3(:,33), t3x8(:,:,22))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,4), wf8(:,34), n3(:,34), t3x8(:,:,23))
  call counter_UV_W(ntry, wf4(:,2), 10, wf4(:,1), 5, wf16(:,5), n3(:,35), t3x16(:,:,5))
  call counter_UV_W(ntry, wf4(:,4), 10, wf4(:,1), 5, wf16(:,6), n3(:,36), t3x16(:,:,6))
  call counter_VQ_A_LR(EWctAdd,ntry, wf4(:,2), ex6(:), wf8(:,35), n3(:,37), t3x8(:,:,24))
  call counter_ZQ_A(EWctVdd,ntry, wf4(:,4), ex6(:), wf8(:,36), n3(:,38), t3x8(:,:,25))
  call counter_WQ_A(ntry, wf4(:,1), ex6(:), wf8(:,37), n3(:,39), t3x8(:,:,26))
  call counter_AV_Q_LR(EWctAuu,ntry, ex5(:), wf4(:,2), wf8(:,38), n3(:,40), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,6), 37, ZERO, 0_intkind1, wf8(:,39), n2(12))
  call counter_AZ_Q(EWctVuu,ntry, ex5(:), wf4(:,4), wf8(:,40), n3(:,41), t3x8(:,:,28))
  call counter_AW_Q(ntry, ex5(:), wf4(:,1), wf8(:,41), n3(:,42), t3x8(:,:,29))
  call prop_Q_A(ntry, wf8(:,2), 42, ZERO, 0_intkind1, wf8(:,42), n2(13))
  call prop_Q_A(ntry, wf8(:,4), 42, ZERO, 0_intkind1, wf8(:,43), n2(14))
  call counter_QA_W(ntry, ex6(:), ex5(:), wf4(:,8), n3(:,43), t3x4(:,:,8))
  call vert_AW_Q(ntry, ex4(:), wf4(:,8), wf8(:,44), n3(:,44), t3x8(:,:,30))
  call counter_AW_Q(ntry, ex4(:), wf4(:,3), wf8(:,45), n3(:,45), t3x8(:,:,31))
  call counter_UV_W(ntry, wf4(:,6), 6, wf4(:,5), 9, wf16(:,7), n3(:,46), t3x16(:,:,7))
  call counter_UV_W(ntry, wf4(:,7), 6, wf4(:,5), 9, wf16(:,8), n3(:,47), t3x16(:,:,8))
  call counter_VQ_A_LR(EWctAdd,ntry, wf4(:,6), ex6(:), wf8(:,46), n3(:,48), t3x8(:,:,32))
  call counter_ZQ_A(EWctVdd,ntry, wf4(:,7), ex6(:), wf8(:,47), n3(:,49), t3x8(:,:,33))
  call counter_WQ_A(ntry, wf4(:,5), ex6(:), wf8(:,48), n3(:,50), t3x8(:,:,34))
  call counter_AV_Q_LR(EWctAuu,ntry, ex5(:), wf4(:,6), wf8(:,49), n3(:,51), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,18), 41, ZERO, 0_intkind1, wf8(:,50), n2(15))
  call counter_AZ_Q(EWctVuu,ntry, ex5(:), wf4(:,7), wf8(:,51), n3(:,52), t3x8(:,:,36))
  call counter_AW_Q(ntry, ex5(:), wf4(:,5), wf8(:,52), n3(:,53), t3x8(:,:,37))
  call prop_Q_A(ntry, wf8(:,14), 38, ZERO, 0_intkind1, wf8(:,53), n2(16))
  call prop_Q_A(ntry, wf8(:,16), 38, ZERO, 0_intkind1, wf8(:,54), n2(17))
  call vert_WQ_A(ntry, wf4(:,8), ex1(:), wf8(:,55), n3(:,54), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,55), 49, ZERO, 0_intkind1, wf8(:,56), n2(18))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,6), wf8(:,57), n3(:,55), t3x8(:,:,39))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,7), wf8(:,58), n3(:,56), t3x8(:,:,40))
  call vert_AW_Q(ntry, ex3(:), wf4(:,8), wf8(:,59), n3(:,57), t3x8(:,:,41))
  call counter_AW_Q(ntry, ex3(:), wf4(:,3), wf8(:,60), n3(:,58), t3x8(:,:,42))
  call counter_AZ_Q(EWctAee,ntry, ex3(:), wf4(:,2), wf8(:,61), n3(:,59), t3x8(:,:,43))
  call counter_AZ_Q(EWctVee,ntry, ex3(:), wf4(:,4), wf8(:,62), n3(:,60), t3x8(:,:,44))
  call counter_WQ_A(ntry, wf4(:,1), ex2(:), wf8(:,63), n3(:,61), t3x8(:,:,45))
  call prop_A_Q(ntry, wf8(:,11), 56, ZERO, 0_intkind1, wf8(:,64), n2(19))
  call counter_QA_Z(EWctAee,ntry, ex2(:), ex4(:), wf4(:,9), n3(:,62), t3x4(:,:,9))
  call vert_UV_W(ntry, wf4(:,9), 10, wf4(:,1), 5, wf16(:,9), n3(:,63), t3x16(:,:,9))
  call counter_QA_Z(EWctVee,ntry, ex2(:), ex4(:), wf4(:,10), n3(:,64), t3x4(:,:,10))
  call vert_UV_W(ntry, wf4(:,10), 10, wf4(:,1), 5, wf16(:,10), n3(:,65), t3x16(:,:,10))
  call vert_VQ_A(ntry, wf4(:,9), ex6(:), wf8(:,65), n3(:,66), t3x8(:,:,46))
  call vert_ZQ_A(gZd,ntry, wf4(:,10), ex6(:), wf8(:,66), n3(:,67), t3x8(:,:,47))
  call vert_AV_Q(ntry, ex5(:), wf4(:,9), wf8(:,67), n3(:,68), t3x8(:,:,48))
  call prop_A_Q(ntry, wf8(:,67), 26, ZERO, 0_intkind1, wf8(:,68), n2(20))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,10), wf8(:,69), n3(:,69), t3x8(:,:,49))
  call prop_A_Q(ntry, wf8(:,69), 26, ZERO, 0_intkind1, wf8(:,70), n2(21))
  call counter_WQ_A(ntry, wf4(:,5), ex2(:), wf8(:,71), n3(:,70), t3x8(:,:,50))
  call prop_A_Q(ntry, wf8(:,29), 52, ZERO, 0_intkind1, wf8(:,72), n2(22))
  call vert_AV_Q(ntry, ex3(:), wf4(:,9), wf8(:,73), n3(:,71), t3x8(:,:,51))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,10), wf8(:,74), n3(:,72), t3x8(:,:,52))
  call vert_ZQ_A(gZn,ntry, wf4(:,10), ex1(:), wf8(:,75), n3(:,73), t3x8(:,:,53))
  call prop_Q_A(ntry, wf8(:,75), 11, ZERO, 0_intkind1, wf8(:,76), n2(23))
  call counter_QA_Z(EWctAee,ntry, ex2(:), ex3(:), wf4(:,11), n3(:,74), t3x4(:,:,11))
  call vert_UV_W(ntry, wf4(:,11), 6, wf4(:,5), 9, wf16(:,11), n3(:,75), t3x16(:,:,11))
  call counter_QA_Z(EWctVee,ntry, ex2(:), ex3(:), wf4(:,12), n3(:,76), t3x4(:,:,12))
  call vert_UV_W(ntry, wf4(:,12), 6, wf4(:,5), 9, wf16(:,12), n3(:,77), t3x16(:,:,12))
  call vert_VQ_A(ntry, wf4(:,11), ex6(:), wf8(:,77), n3(:,78), t3x8(:,:,54))
  call vert_ZQ_A(gZd,ntry, wf4(:,12), ex6(:), wf8(:,78), n3(:,79), t3x8(:,:,55))
  call vert_AV_Q(ntry, ex5(:), wf4(:,11), wf8(:,79), n3(:,80), t3x8(:,:,56))
  call prop_A_Q(ntry, wf8(:,79), 22, ZERO, 0_intkind1, wf8(:,80), n2(24))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,12), wf8(:,81), n3(:,81), t3x8(:,:,57))
  call prop_A_Q(ntry, wf8(:,81), 22, ZERO, 0_intkind1, wf8(:,82), n2(25))
  call vert_AV_Q(ntry, ex4(:), wf4(:,11), wf8(:,83), n3(:,82), t3x8(:,:,58))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,12), wf8(:,84), n3(:,83), t3x8(:,:,59))
  call vert_ZQ_A(gZn,ntry, wf4(:,12), ex1(:), wf8(:,85), n3(:,84), t3x8(:,:,60))
  call prop_Q_A(ntry, wf8(:,85), 7, ZERO, 0_intkind1, wf8(:,86), n2(26))
  call counter_ZQ_A(EWctAnn,ntry, wf4(:,6), ex1(:), wf8(:,87), n3(:,85), t3x8(:,:,61))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,7), ex1(:), wf8(:,88), n3(:,86), t3x8(:,:,62))
  call counter_WQ_A(ntry, wf4(:,3), ex1(:), wf8(:,89), n3(:,87), t3x8(:,:,63))
  call prop_A_Q(ntry, wf8(:,25), 14, ZERO, 0_intkind1, wf8(:,90), n2(27))
  call prop_A_Q(ntry, wf8(:,27), 14, ZERO, 0_intkind1, wf8(:,91), n2(28))
  call counter_QA_W(ntry, ex1(:), ex4(:), wf4(:,13), n3(:,88), t3x4(:,:,13))
  call vert_UV_W(ntry, wf4(:,6), 6, wf4(:,13), 9, wf16(:,13), n3(:,89), t3x16(:,:,13))
  call vert_UV_W(ntry, wf4(:,7), 6, wf4(:,13), 9, wf16(:,14), n3(:,90), t3x16(:,:,14))
  call vert_AW_Q(ntry, ex5(:), wf4(:,13), wf8(:,92), n3(:,91), t3x8(:,:,64))
  call prop_A_Q(ntry, wf8(:,92), 25, ZERO, 0_intkind1, wf8(:,93), n2(29))
  call vert_WQ_A(ntry, wf4(:,13), ex6(:), wf8(:,94), n3(:,92), t3x8(:,:,65))
  call counter_ZQ_A(EWctAnn,ntry, wf4(:,2), ex1(:), wf8(:,95), n3(:,93), t3x8(:,:,66))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,4), ex1(:), wf8(:,96), n3(:,94), t3x8(:,:,67))
  call prop_A_Q(ntry, wf8(:,33), 14, ZERO, 0_intkind1, wf8(:,97), n2(30))
  call prop_A_Q(ntry, wf8(:,34), 14, ZERO, 0_intkind1, wf8(:,98), n2(31))
  call vert_WQ_A(ntry, wf4(:,13), ex2(:), wf8(:,99), n3(:,95), t3x8(:,:,68))
  call prop_Q_A(ntry, wf8(:,99), 11, ZERO, 0_intkind1, wf8(:,100), n2(32))
  call counter_QA_W(ntry, ex1(:), ex3(:), wf4(:,14), n3(:,96), t3x4(:,:,14))
  call vert_UV_W(ntry, wf4(:,2), 10, wf4(:,14), 5, wf16(:,15), n3(:,97), t3x16(:,:,15))
  call vert_UV_W(ntry, wf4(:,4), 10, wf4(:,14), 5, wf16(:,16), n3(:,98), t3x16(:,:,16))
  call vert_AW_Q(ntry, ex5(:), wf4(:,14), wf8(:,101), n3(:,99), t3x8(:,:,69))
  call prop_A_Q(ntry, wf8(:,101), 21, ZERO, 0_intkind1, wf8(:,102), n2(33))
  call vert_WQ_A(ntry, wf4(:,14), ex6(:), wf8(:,103), n3(:,100), t3x8(:,:,70))
  call vert_WQ_A(ntry, wf4(:,14), ex2(:), wf8(:,104), n3(:,101), t3x8(:,:,71))
  call prop_Q_A(ntry, wf8(:,104), 7, ZERO, 0_intkind1, wf8(:,105), n2(34))
  call vert_VV_S(ntry, wf4(:,2), wf4(:,3), wf16(:,17), n3(:,102), t3x16(:,:,17))
  call counter_V_S(EWctPW,ntry, wf4(:,1), 5, wf4(:,15), n2(35))
  call vert_VV_S(ntry, wf4(:,4), wf4(:,3), wf16(:,18), n3(:,103), t3x16(:,:,18))
  call vert_UV_W(ntry, wf4(:,3), 48, wf4(:,2), 10, wf16(:,19), n3(:,104), t3x16(:,:,19))
  call counter_V_V(EWctWW,ntry, wf4(:,1), 5, wf4(:,16), n2(36))
  call vert_UV_W(ntry, wf4(:,3), 48, wf4(:,4), 10, wf16(:,20), n3(:,105), t3x16(:,:,20))
  call vert_UV_W(ntry, wf4(:,1), 5, wf4(:,3), 48, wf16(:,21), n3(:,106), t3x16(:,:,21))
  call counter_V_V(EWctAA,ntry, wf4(:,2), 10, wf4(:,17), n2(37))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 10, wf4(:,18), n2(38))
  call counter_V_V(EWctAZ,ntry, wf4(:,4), 10, wf4(:,19), n2(39))
  call counter_V_V(EWctZZ,ntry, wf4(:,4), 10, wf4(:,20), n2(40))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,2), wf16(:,22), n3(:,107), t3x16(:,:,22))
  call counter_V_S(EWctPW,ntry, wf4(:,3), 48, wf4(:,21), n2(41))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,4), wf16(:,23), n3(:,108), t3x16(:,:,23))
  call counter_V_V(EWctWW,ntry, wf4(:,3), 48, wf4(:,22), n2(42))
  call vert_AW_Q(ntry, ex5(:), wf4(:,16), wf8(:,106), n3(:,109), t3x8(:,:,72))
  call vert_WQ_A(ntry, wf4(:,16), ex6(:), wf8(:,107), n3(:,110), t3x8(:,:,73))
  call vert_AV_Q(ntry, ex5(:), wf4(:,17), wf8(:,108), n3(:,111), t3x8(:,:,74))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,18), wf8(:,109), n3(:,112), t3x8(:,:,75))
  call vert_AV_Q(ntry, ex5(:), wf4(:,19), wf8(:,110), n3(:,113), t3x8(:,:,76))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,20), wf8(:,111), n3(:,114), t3x8(:,:,77))
  call vert_VQ_A(ntry, wf4(:,17), ex6(:), wf8(:,112), n3(:,115), t3x8(:,:,78))
  call vert_ZQ_A(gZd,ntry, wf4(:,18), ex6(:), wf8(:,113), n3(:,116), t3x8(:,:,79))
  call vert_VQ_A(ntry, wf4(:,19), ex6(:), wf8(:,114), n3(:,117), t3x8(:,:,80))
  call vert_ZQ_A(gZd,ntry, wf4(:,20), ex6(:), wf8(:,115), n3(:,118), t3x8(:,:,81))
  call counter_A_Q_LR(EWctdd,ntry, wf8(:,3), 21, wf8(:,116), n2(43))
  call counter_A_Q_LR(EWctuu,ntry, wf8(:,7), 26, wf8(:,117), n2(44))
  call counter_A_Q_LR(EWctuu,ntry, wf8(:,9), 26, wf8(:,118), n2(45))
  call vert_WQ_A(ntry, wf4(:,16), ex2(:), wf8(:,119), n3(:,119), t3x8(:,:,82))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,12), 7, wf8(:,120), n2(46))
  call vert_AW_Q(ntry, ex4(:), wf4(:,22), wf8(:,121), n3(:,120), t3x8(:,:,83))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,3), wf16(:,24), n3(:,121), t3x16(:,:,24))
  call counter_V_S(EWctPW,ntry, wf4(:,5), 9, wf4(:,23), n2(47))
  call vert_VV_S(ntry, wf4(:,7), wf4(:,3), wf16(:,25), n3(:,122), t3x16(:,:,25))
  call vert_UV_W(ntry, wf4(:,3), 48, wf4(:,6), 6, wf16(:,26), n3(:,123), t3x16(:,:,26))
  call counter_V_V(EWctWW,ntry, wf4(:,5), 9, wf4(:,24), n2(48))
  call vert_UV_W(ntry, wf4(:,3), 48, wf4(:,7), 6, wf16(:,27), n3(:,124), t3x16(:,:,27))
  call vert_UV_W(ntry, wf4(:,5), 9, wf4(:,3), 48, wf16(:,28), n3(:,125), t3x16(:,:,28))
  call counter_V_V(EWctAA,ntry, wf4(:,6), 6, wf4(:,25), n2(49))
  call counter_V_V(EWctAZ,ntry, wf4(:,6), 6, wf4(:,26), n2(50))
  call counter_V_V(EWctAZ,ntry, wf4(:,7), 6, wf4(:,27), n2(51))
  call counter_V_V(EWctZZ,ntry, wf4(:,7), 6, wf4(:,28), n2(52))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,5), wf16(:,29), n3(:,126), t3x16(:,:,29))
  call vert_VV_S(ntry, wf4(:,7), wf4(:,5), wf16(:,30), n3(:,127), t3x16(:,:,30))
  call vert_AW_Q(ntry, ex5(:), wf4(:,24), wf8(:,122), n3(:,128), t3x8(:,:,84))
  call vert_WQ_A(ntry, wf4(:,24), ex6(:), wf8(:,123), n3(:,129), t3x8(:,:,85))
  call vert_AV_Q(ntry, ex5(:), wf4(:,25), wf8(:,124), n3(:,130), t3x8(:,:,86))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,26), wf8(:,125), n3(:,131), t3x8(:,:,87))
  call vert_AV_Q(ntry, ex5(:), wf4(:,27), wf8(:,126), n3(:,132), t3x8(:,:,88))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,28), wf8(:,127), n3(:,133), t3x8(:,:,89))
  call vert_VQ_A(ntry, wf4(:,25), ex6(:), wf8(:,128), n3(:,134), t3x8(:,:,90))
  call vert_ZQ_A(gZd,ntry, wf4(:,26), ex6(:), wf8(:,129), n3(:,135), t3x8(:,:,91))
  call vert_VQ_A(ntry, wf4(:,27), ex6(:), wf8(:,130), n3(:,136), t3x8(:,:,92))
  call vert_ZQ_A(gZd,ntry, wf4(:,28), ex6(:), wf8(:,131), n3(:,137), t3x8(:,:,93))
  call counter_A_Q_LR(EWctdd,ntry, wf8(:,15), 25, wf8(:,132), n2(53))
  call counter_A_Q_LR(EWctuu,ntry, wf8(:,19), 22, wf8(:,133), n2(54))
  call counter_A_Q_LR(EWctuu,ntry, wf8(:,21), 22, wf8(:,134), n2(55))
  call vert_ZQ_A(gZn,ntry, wf4(:,26), ex1(:), wf8(:,135), n3(:,138), t3x8(:,:,94))
  call vert_ZQ_A(gZn,ntry, wf4(:,28), ex1(:), wf8(:,136), n3(:,139), t3x8(:,:,95))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,23), 7, wf8(:,137), n2(56))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,26), 49, wf8(:,138), n2(57))
  call vert_WQ_A(ntry, wf4(:,22), ex1(:), wf8(:,139), n3(:,140), t3x8(:,:,96))
  call vert_AV_Q(ntry, ex4(:), wf4(:,25), wf8(:,140), n3(:,141), t3x8(:,:,97))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,26), wf8(:,141), n3(:,142), t3x8(:,:,98))
  call vert_AV_Q(ntry, ex4(:), wf4(:,27), wf8(:,142), n3(:,143), t3x8(:,:,99))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,28), wf8(:,143), n3(:,144), t3x8(:,:,100))
  call vert_WQ_A(ntry, wf4(:,24), ex2(:), wf8(:,144), n3(:,145), t3x8(:,:,101))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,30), 11, wf8(:,145), n2(58))
  call vert_AW_Q(ntry, ex3(:), wf4(:,22), wf8(:,146), n3(:,146), t3x8(:,:,102))
  call vert_ZQ_A(gZn,ntry, wf4(:,18), ex1(:), wf8(:,147), n3(:,147), t3x8(:,:,103))
  call vert_ZQ_A(gZn,ntry, wf4(:,20), ex1(:), wf8(:,148), n3(:,148), t3x8(:,:,104))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,32), 11, wf8(:,149), n2(59))
  call vert_AV_Q(ntry, ex3(:), wf4(:,17), wf8(:,150), n3(:,149), t3x8(:,:,105))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,18), wf8(:,151), n3(:,150), t3x8(:,:,106))
  call vert_AV_Q(ntry, ex3(:), wf4(:,19), wf8(:,152), n3(:,151), t3x8(:,:,107))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,20), wf8(:,153), n3(:,152), t3x8(:,:,108))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,3), wf16(:,31), n3(:,153), t3x16(:,:,31))
  call vert_QA_W(ntry, wf8(:,12), ex4(:), wf16(:,32), n3(:,154), t3x16(:,:,32))
  call vert_QA_V(ntry, ex6(:), wf8(:,3), wf16(:,33), n3(:,155), t3x16(:,:,33))
  call vert_QA_Z(gZd,ntry, ex6(:), wf8(:,3), wf16(:,34), n3(:,156), t3x16(:,:,34))
  call vert_QA_V(ntry, wf8(:,39), ex5(:), wf16(:,35), n3(:,157), t3x16(:,:,35))
  call vert_QA_Z(gZu,ntry, wf8(:,39), ex5(:), wf16(:,36), n3(:,158), t3x16(:,:,36))
  call vert_QA_W(ntry, wf8(:,23), ex4(:), wf16(:,37), n3(:,159), t3x16(:,:,37))
  call vert_QA_W(ntry, ex1(:), wf8(:,90), wf16(:,38), n3(:,160), t3x16(:,:,38))
  call vert_QA_W(ntry, ex1(:), wf8(:,91), wf16(:,39), n3(:,161), t3x16(:,:,39))
  call vert_QA_W(ntry, ex6(:), wf8(:,19), wf16(:,40), n3(:,162), t3x16(:,:,40))
  call vert_QA_W(ntry, ex6(:), wf8(:,21), wf16(:,41), n3(:,163), t3x16(:,:,41))
  call vert_QA_W(ntry, wf8(:,53), ex5(:), wf16(:,42), n3(:,164), t3x16(:,:,42))
  call vert_QA_W(ntry, wf8(:,54), ex5(:), wf16(:,43), n3(:,165), t3x16(:,:,43))
  call vert_VV_S(ntry, wf4(:,5), wf4(:,3), wf16(:,44), n3(:,166), t3x16(:,:,44))
  call vert_QA_W(ntry, wf8(:,30), ex3(:), wf16(:,45), n3(:,167), t3x16(:,:,45))
  call vert_QA_V(ntry, ex6(:), wf8(:,15), wf16(:,46), n3(:,168), t3x16(:,:,46))
  call vert_QA_Z(gZd,ntry, ex6(:), wf8(:,15), wf16(:,47), n3(:,169), t3x16(:,:,47))
  call vert_QA_V(ntry, wf8(:,50), ex5(:), wf16(:,48), n3(:,170), t3x16(:,:,48))
  call vert_QA_Z(gZu,ntry, wf8(:,50), ex5(:), wf16(:,49), n3(:,171), t3x16(:,:,49))
  call vert_QA_W(ntry, wf8(:,32), ex3(:), wf16(:,50), n3(:,172), t3x16(:,:,50))
  call vert_QA_W(ntry, ex1(:), wf8(:,97), wf16(:,51), n3(:,173), t3x16(:,:,51))
  call vert_QA_W(ntry, ex1(:), wf8(:,98), wf16(:,52), n3(:,174), t3x16(:,:,52))
  call vert_QA_W(ntry, ex6(:), wf8(:,7), wf16(:,53), n3(:,175), t3x16(:,:,53))
  call vert_QA_W(ntry, ex6(:), wf8(:,9), wf16(:,54), n3(:,176), t3x16(:,:,54))
  call vert_QA_W(ntry, wf8(:,42), ex5(:), wf16(:,55), n3(:,177), t3x16(:,:,55))
  call vert_QA_W(ntry, wf8(:,43), ex5(:), wf16(:,56), n3(:,178), t3x16(:,:,56))
  call vert_QA_V(ntry, wf8(:,26), ex3(:), wf16(:,57), n3(:,179), t3x16(:,:,57))
  call vert_QA_Z(gZl,ntry, wf8(:,26), ex3(:), wf16(:,58), n3(:,180), t3x16(:,:,58))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,72), wf16(:,59), n3(:,181), t3x16(:,:,59))
  call vert_QA_V(ntry, wf8(:,26), ex4(:), wf16(:,60), n3(:,182), t3x16(:,:,60))
  call vert_QA_Z(gZl,ntry, wf8(:,26), ex4(:), wf16(:,61), n3(:,183), t3x16(:,:,61))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,64), wf16(:,62), n3(:,184), t3x16(:,:,62))
  call vert_QA_W(ntry, ex2(:), wf8(:,72), wf16(:,63), n3(:,185), t3x16(:,:,63))
  call vert_QA_W(ntry, ex2(:), wf8(:,64), wf16(:,64), n3(:,186), t3x16(:,:,64))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,3), wf16(:,1), A(:,1), n3(:,187), t3x64(:,:,1), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,2), A(:,2), n3(:,188), t3x64(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,3), n3(:,189), t3x64(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,4), A(:,4), n3(:,190), t3x64(:,:,4), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,7), A(:,5), n3(:,191), t3x64(:,:,5), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,9), A(:,6), n3(:,192), t3x64(:,:,6), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,7), n3(:,193), t3x64(:,:,7), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,3), A(:,8), n3(:,194), t3x64(:,:,8), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,4), A(:,9), n3(:,195), t3x64(:,:,9), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,15), A(:,10), n3(:,196), t3x64(:,:,10), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,16), A(:,11), n3(:,197), t3x64(:,:,11), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,19), A(:,12), n3(:,198), t3x64(:,:,12), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,21), A(:,13), n3(:,199), t3x64(:,:,13), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,23), A(:,14), n3(:,200), t3x64(:,:,14), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,26), A(:,15), n3(:,201), t3x64(:,:,15), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,27), A(:,16), n3(:,202), t3x64(:,:,16), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,30), A(:,17), n3(:,203), t3x64(:,:,17), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,32), A(:,18), n3(:,204), t3x64(:,:,18), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,33), A(:,19), n3(:,205), t3x64(:,:,19), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,34), A(:,20), n3(:,206), t3x64(:,:,20), nhel, den(49))

    call Hcont_VV(nsync, wf4(:,3), wf16(:,5), A(:,21), n3(:,207), t3x64(:,:,21), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,6), A(:,22), n3(:,208), t3x64(:,:,22), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,35), A(:,23), n3(:,209), t3x64(:,:,23), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,36), A(:,24), n3(:,210), t3x64(:,:,24), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,37), A(:,25), n3(:,211), t3x64(:,:,25), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,37), A(:,26), n3(:,212), t3x64(:,:,26), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,39), A(:,27), n3(:,213), t3x64(:,:,27), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,40), A(:,28), n3(:,214), t3x64(:,:,28), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,42), A(:,29), n3(:,215), t3x64(:,:,29), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,43), A(:,30), n3(:,216), t3x64(:,:,30), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,8), A(:,31), n3(:,217), t3x64(:,:,31), nhel, den(5))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,8), A(:,32), n3(:,218), t3x64(:,:,32), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,44), A(:,33), n3(:,219), t3x64(:,:,33), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,45), A(:,34), n3(:,220), t3x64(:,:,34), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,7), A(:,35), n3(:,221), t3x64(:,:,35), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,8), A(:,36), n3(:,222), t3x64(:,:,36), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,46), A(:,37), n3(:,223), t3x64(:,:,37), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,47), A(:,38), n3(:,224), t3x64(:,:,38), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,48), A(:,39), n3(:,225), t3x64(:,:,39), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,48), A(:,40), n3(:,226), t3x64(:,:,40), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,50), A(:,41), n3(:,227), t3x64(:,:,41), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,51), A(:,42), n3(:,228), t3x64(:,:,42), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,53), A(:,43), n3(:,229), t3x64(:,:,43), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,54), A(:,44), n3(:,230), t3x64(:,:,44), nhel, den(67))
    call Hcont_VV(nsync, wf16(:,3), wf4(:,8), A(:,45), n3(:,231), t3x64(:,:,45), nhel, den(24))
    call Hcont_VV(nsync, wf16(:,4), wf4(:,8), A(:,46), n3(:,232), t3x64(:,:,46), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,44), A(:,47), n3(:,233), t3x64(:,:,47), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,56), A(:,48), n3(:,234), t3x64(:,:,48), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,56), A(:,49), n3(:,235), t3x64(:,:,49), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,45), A(:,50), n3(:,236), t3x64(:,:,50), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,57), A(:,51), n3(:,237), t3x64(:,:,51), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,58), A(:,52), n3(:,238), t3x64(:,:,52), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,59), A(:,53), n3(:,239), t3x64(:,:,53), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,59), A(:,54), n3(:,240), t3x64(:,:,54), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,56), A(:,55), n3(:,241), t3x64(:,:,55), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,56), A(:,56), n3(:,242), t3x64(:,:,56), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,60), A(:,57), n3(:,243), t3x64(:,:,57), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,60), A(:,58), n3(:,244), t3x64(:,:,58), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,61), A(:,59), n3(:,245), t3x64(:,:,59), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,62), A(:,60), n3(:,246), t3x64(:,:,60), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,64), A(:,61), n3(:,247), t3x64(:,:,61), nhel, den(70))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,9), A(:,62), n3(:,248), t3x64(:,:,62), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,10), A(:,63), n3(:,249), t3x64(:,:,63), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,65), A(:,64), n3(:,250), t3x64(:,:,64), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,66), A(:,65), n3(:,251), t3x64(:,:,65), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,68), A(:,66), n3(:,252), t3x64(:,:,66), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,70), A(:,67), n3(:,253), t3x64(:,:,67), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,72), A(:,68), n3(:,254), t3x64(:,:,68), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,73), A(:,69), n3(:,255), t3x64(:,:,69), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,74), A(:,70), n3(:,256), t3x64(:,:,70), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,76), A(:,71), n3(:,257), t3x64(:,:,71), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,11), A(:,72), n3(:,258), t3x64(:,:,72), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,12), A(:,73), n3(:,259), t3x64(:,:,73), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,77), A(:,74), n3(:,260), t3x64(:,:,74), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,78), A(:,75), n3(:,261), t3x64(:,:,75), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,80), A(:,76), n3(:,262), t3x64(:,:,76), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,82), A(:,77), n3(:,263), t3x64(:,:,77), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,83), A(:,78), n3(:,264), t3x64(:,:,78), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,84), A(:,79), n3(:,265), t3x64(:,:,79), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,86), A(:,80), n3(:,266), t3x64(:,:,80), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,87), A(:,81), n3(:,267), t3x64(:,:,81), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,88), A(:,82), n3(:,268), t3x64(:,:,82), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,90), A(:,83), n3(:,269), t3x64(:,:,83), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,91), A(:,84), n3(:,270), t3x64(:,:,84), nhel, den(80))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,13), A(:,85), n3(:,271), t3x64(:,:,85), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,14), A(:,86), n3(:,272), t3x64(:,:,86), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,93), A(:,87), n3(:,273), t3x64(:,:,87), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,93), A(:,88), n3(:,274), t3x64(:,:,88), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,94), A(:,89), n3(:,275), t3x64(:,:,89), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,94), A(:,90), n3(:,276), t3x64(:,:,90), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,95), A(:,91), n3(:,277), t3x64(:,:,91), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,96), A(:,92), n3(:,278), t3x64(:,:,92), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,97), A(:,93), n3(:,279), t3x64(:,:,93), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,98), A(:,94), n3(:,280), t3x64(:,:,94), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,100), A(:,95), n3(:,281), t3x64(:,:,95), nhel, den(45))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,15), A(:,96), n3(:,282), t3x64(:,:,96), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,16), A(:,97), n3(:,283), t3x64(:,:,97), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,102), A(:,98), n3(:,284), t3x64(:,:,98), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,102), A(:,99), n3(:,285), t3x64(:,:,99), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,103), A(:,100), n3(:,286), t3x64(:,:,100), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,103), A(:,101), n3(:,287), t3x64(:,:,101), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,105), A(:,102), n3(:,288), t3x64(:,:,102), nhel, den(20))
    call Hcont_SS(nsync, wf16(:,17), wf4(:,15), A(:,103), n3(:,289), t3x64(:,:,103), nhel, den(90))
    call Hcont_SS(nsync, wf4(:,15), wf16(:,18), A(:,104), n3(:,290), t3x64(:,:,104), nhel, den(93))
    call Hcont_VV(nsync, wf16(:,19), wf4(:,16), A(:,105), n3(:,291), t3x64(:,:,105), nhel, den(90))
    call Hcont_VV(nsync, wf4(:,16), wf16(:,20), A(:,106), n3(:,292), t3x64(:,:,106), nhel, den(93))
    call Hcont_VV(nsync, wf16(:,21), wf4(:,17), A(:,107), n3(:,293), t3x64(:,:,107), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,21), wf4(:,18), A(:,108), n3(:,294), t3x64(:,:,108), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,21), wf4(:,19), A(:,109), n3(:,295), t3x64(:,:,109), nhel, den(101))
    call Hcont_VV(nsync, wf16(:,21), wf4(:,20), A(:,110), n3(:,296), t3x64(:,:,110), nhel, den(102))
    call Hcont_SS(nsync, wf16(:,22), wf4(:,21), A(:,111), n3(:,297), t3x64(:,:,111), nhel, den(105))
    call Hcont_SS(nsync, wf4(:,21), wf16(:,23), A(:,112), n3(:,298), t3x64(:,:,112), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,22), A(:,113), n3(:,299), t3x64(:,:,113), nhel, den(105))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,22), A(:,114), n3(:,300), t3x64(:,:,114), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,106), A(:,115), n3(:,301), t3x64(:,:,115), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,106), A(:,116), n3(:,302), t3x64(:,:,116), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,107), A(:,117), n3(:,303), t3x64(:,:,117), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,107), A(:,118), n3(:,304), t3x64(:,:,118), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,108), A(:,119), n3(:,305), t3x64(:,:,119), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,109), A(:,120), n3(:,306), t3x64(:,:,120), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,110), A(:,121), n3(:,307), t3x64(:,:,121), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,111), A(:,122), n3(:,308), t3x64(:,:,122), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,112), A(:,123), n3(:,309), t3x64(:,:,123), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,113), A(:,124), n3(:,310), t3x64(:,:,124), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,114), A(:,125), n3(:,311), t3x64(:,:,125), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,115), A(:,126), n3(:,312), t3x64(:,:,126), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,116), A(:,127), n3(:,313), t3x64(:,:,127), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,116), A(:,128), n3(:,314), t3x64(:,:,128), nhel, den(123))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,117), A(:,129), n3(:,315), t3x64(:,:,129), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,118), A(:,130), n3(:,316), t3x64(:,:,130), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,119), A(:,131), n3(:,317), t3x64(:,:,131), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,120), A(:,132), n3(:,318), t3x64(:,:,132), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,121), A(:,133), n3(:,319), t3x64(:,:,133), nhel, den(129))
    call Hcont_SS(nsync, wf16(:,24), wf4(:,23), A(:,134), n3(:,320), t3x64(:,:,134), nhel, den(133))
    call Hcont_SS(nsync, wf4(:,23), wf16(:,25), A(:,135), n3(:,321), t3x64(:,:,135), nhel, den(136))
    call Hcont_VV(nsync, wf16(:,26), wf4(:,24), A(:,136), n3(:,322), t3x64(:,:,136), nhel, den(133))
    call Hcont_VV(nsync, wf4(:,24), wf16(:,27), A(:,137), n3(:,323), t3x64(:,:,137), nhel, den(136))
    call Hcont_VV(nsync, wf16(:,28), wf4(:,25), A(:,138), n3(:,324), t3x64(:,:,138), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,28), wf4(:,26), A(:,139), n3(:,325), t3x64(:,:,139), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,28), wf4(:,27), A(:,140), n3(:,326), t3x64(:,:,140), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,28), wf4(:,28), A(:,141), n3(:,327), t3x64(:,:,141), nhel, den(145))
    call Hcont_SS(nsync, wf4(:,21), wf16(:,29), A(:,142), n3(:,328), t3x64(:,:,142), nhel, den(147))
    call Hcont_SS(nsync, wf4(:,21), wf16(:,30), A(:,143), n3(:,329), t3x64(:,:,143), nhel, den(149))
    call Hcont_VV(nsync, wf16(:,3), wf4(:,22), A(:,144), n3(:,330), t3x64(:,:,144), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,4), wf4(:,22), A(:,145), n3(:,331), t3x64(:,:,145), nhel, den(149))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,122), A(:,146), n3(:,332), t3x64(:,:,146), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,122), A(:,147), n3(:,333), t3x64(:,:,147), nhel, den(152))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,123), A(:,148), n3(:,334), t3x64(:,:,148), nhel, den(153))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,123), A(:,149), n3(:,335), t3x64(:,:,149), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,124), A(:,150), n3(:,336), t3x64(:,:,150), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,125), A(:,151), n3(:,337), t3x64(:,:,151), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,126), A(:,152), n3(:,338), t3x64(:,:,152), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,127), A(:,153), n3(:,339), t3x64(:,:,153), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,128), A(:,154), n3(:,340), t3x64(:,:,154), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,129), A(:,155), n3(:,341), t3x64(:,:,155), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,130), A(:,156), n3(:,342), t3x64(:,:,156), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,131), A(:,157), n3(:,343), t3x64(:,:,157), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,132), A(:,158), n3(:,344), t3x64(:,:,158), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,132), A(:,159), n3(:,345), t3x64(:,:,159), nhel, den(165))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,133), A(:,160), n3(:,346), t3x64(:,:,160), nhel, den(166))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,134), A(:,161), n3(:,347), t3x64(:,:,161), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,135), A(:,162), n3(:,348), t3x64(:,:,162), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,136), A(:,163), n3(:,349), t3x64(:,:,163), nhel, den(169))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,137), A(:,164), n3(:,350), t3x64(:,:,164), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,138), A(:,165), n3(:,351), t3x64(:,:,165), nhel, den(171))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,138), A(:,166), n3(:,352), t3x64(:,:,166), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,139), A(:,167), n3(:,353), t3x64(:,:,167), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,139), A(:,168), n3(:,354), t3x64(:,:,168), nhel, den(174))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,140), A(:,169), n3(:,355), t3x64(:,:,169), nhel, den(175))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,141), A(:,170), n3(:,356), t3x64(:,:,170), nhel, den(176))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,142), A(:,171), n3(:,357), t3x64(:,:,171), nhel, den(176))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,143), A(:,172), n3(:,358), t3x64(:,:,172), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,121), A(:,173), n3(:,359), t3x64(:,:,173), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,144), A(:,174), n3(:,360), t3x64(:,:,174), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,145), A(:,175), n3(:,361), t3x64(:,:,175), nhel, den(180))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,146), A(:,176), n3(:,362), t3x64(:,:,176), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,147), A(:,177), n3(:,363), t3x64(:,:,177), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,148), A(:,178), n3(:,364), t3x64(:,:,178), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,149), A(:,179), n3(:,365), t3x64(:,:,179), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,97), wf8(:,138), A(:,180), n3(:,366), t3x64(:,:,180), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,98), wf8(:,138), A(:,181), n3(:,367), t3x64(:,:,181), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,97), wf8(:,139), A(:,182), n3(:,368), t3x64(:,:,182), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,98), wf8(:,139), A(:,183), n3(:,369), t3x64(:,:,183), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,150), A(:,184), n3(:,370), t3x64(:,:,184), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,151), A(:,185), n3(:,371), t3x64(:,:,185), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,152), A(:,186), n3(:,372), t3x64(:,:,186), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,153), A(:,187), n3(:,373), t3x64(:,:,187), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,146), A(:,188), n3(:,374), t3x64(:,:,188), nhel, den(192))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,64)
  integer :: empty(0), i

  M1(1)%j = (A(j,7)%j-A(j,17)%j)*f(1)+(A(j,2)%j-A(j,9)%j)*f(6)+(A(j,3)%j-A(j,10)%j)*f(10)+(-A(j,5)%j+A(j,12)%j)*f(11)+(-A(j,1)%j &
       +A(j,4)%j+A(j,6)%j+A(j,8)%j-A(j,11)%j-A(j,13)%j-A(j,14)%j-A(j,15)%j-A(j,16)%j+A(j,18)%j+A(j,19)%j+A(j,20)%j)*f(12)

  M2(1)%j = (-A(j,131)%j-A(j,132)%j-A(j,133)%j+A(j,174)%j+A(j,175)%j+A(j,176)%j)*f(2)+(A(j,61)%j-A(j,68)%j)*f(3)+(A(j,34)%j &
       -A(j,57)%j-A(j,95)%j+A(j,102)%j)*f(4)+(A(j,33)%j-A(j,53)%j)*f(5)+(A(j,63)%j-A(j,73)%j-A(j,106)%j-A(j,108)%j-A(j,110)%j &
       -A(j,114)%j+A(j,137)%j+A(j,139)%j+A(j,141)%j+A(j,145)%j)*f(7)+(-A(j,86)%j+A(j,97)%j)*f(8)+(A(j,32)%j-A(j,46)%j)*f(9) &
       +(A(j,64)%j-A(j,74)%j-A(j,115)%j-A(j,123)%j-A(j,125)%j-A(j,127)%j+A(j,146)%j+A(j,154)%j+A(j,156)%j+A(j,158)%j)*f(13)+( &
       -A(j,66)%j+A(j,76)%j+A(j,117)%j+A(j,119)%j+A(j,121)%j+A(j,129)%j-A(j,148)%j-A(j,150)%j-A(j,152)%j-A(j,160)%j)*f(14) &
       +(A(j,23)%j+A(j,24)%j+A(j,27)%j+A(j,28)%j-A(j,37)%j-A(j,38)%j-A(j,41)%j-A(j,42)%j-A(j,51)%j-A(j,52)%j+A(j,59)%j+A(j,60)%j &
       -A(j,62)%j+A(j,65)%j+A(j,67)%j+A(j,69)%j+A(j,70)%j+A(j,71)%j+A(j,72)%j-A(j,75)%j-A(j,77)%j-A(j,78)%j-A(j,79)%j-A(j,80)%j &
       -A(j,81)%j-A(j,82)%j+A(j,91)%j+A(j,92)%j+A(j,105)%j+A(j,107)%j+A(j,109)%j+A(j,113)%j-A(j,116)%j-A(j,118)%j-A(j,120)%j &
       -A(j,122)%j-A(j,124)%j-A(j,126)%j-A(j,128)%j-A(j,130)%j-A(j,136)%j-A(j,138)%j-A(j,140)%j-A(j,144)%j+A(j,147)%j+A(j,149)%j &
       +A(j,151)%j+A(j,153)%j+A(j,155)%j+A(j,157)%j+A(j,159)%j+A(j,161)%j+A(j,162)%j+A(j,163)%j+A(j,164)%j+A(j,165)%j+A(j,166)%j &
       +A(j,167)%j+A(j,168)%j+A(j,169)%j+A(j,170)%j+A(j,171)%j+A(j,172)%j+A(j,173)%j-A(j,177)%j-A(j,178)%j-A(j,179)%j-A(j,180)%j &
       -A(j,181)%j-A(j,182)%j-A(j,183)%j-A(j,184)%j-A(j,185)%j-A(j,186)%j-A(j,187)%j-A(j,188)%j)*f(15)+(-A(j,21)%j &
       +A(j,35)%j)*f(16)+(-A(j,87)%j+A(j,98)%j)*f(17)+(A(j,89)%j-A(j,100)%j)*f(18)+(-A(j,50)%j+A(j,58)%j-A(j,83)%j-A(j,84)%j &
       +A(j,85)%j-A(j,88)%j-A(j,90)%j+A(j,93)%j+A(j,94)%j-A(j,96)%j+A(j,99)%j+A(j,101)%j)*f(19)+(A(j,29)%j-A(j,43)%j)*f(20)+( &
       -A(j,25)%j+A(j,39)%j)*f(21)+(A(j,26)%j+A(j,30)%j-A(j,31)%j-A(j,40)%j-A(j,44)%j+A(j,45)%j-A(j,47)%j-A(j,48)%j-A(j,49)%j &
       +A(j,54)%j+A(j,55)%j+A(j,56)%j)*f(22)+(-A(j,22)%j+A(j,36)%j)*f(23)+(-A(j,103)%j-A(j,111)%j+A(j,134)%j+A(j,142)%j)*f(24)+( &
       -A(j,104)%j-A(j,112)%j+A(j,135)%j+A(j,143)%j)*f(25)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_neeexexuxd_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_neeexexuxd_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 1
      do j = 1, 1
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_neeexexuxd_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_neeexexuxd_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_neeexexuxd_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer :: i, j


  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppllll_ew_neeexexuxd_1_/**/REALKIND
