
module ol_colourmatrix_ppllll_ew_eexmmxddxa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 0]
  K1(24,:) = [ 0]
  K1(25,:) = [ 0]
  K1(26,:) = [ 0]
  K1(27,:) = [ 0]
  K1(28,:) = [ 0]
  K1(29,:) = [ 0]
  K1(30,:) = [ 3]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllll_ew_eexmmxddxa_1_/**/REALKIND



module ol_forced_parameters_ppllll_ew_eexmmxddxa_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllll_ew_eexmmxddxa_1_/**/REALKIND

module ol_tree_ppllll_ew_eexmmxddxa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(4)
  complex(REALKIND), save :: den(258)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 128 ! number of helicity configurations
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(128) ! physical helicity states
  complex(DREALKIND) :: M1helarr(1,128) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = (CI*eQED**5)/27._/**/REALKIND
    f(2) = (CI*eQED**5)/9._/**/REALKIND
    f(3) = (CI*eQED**5)/3._/**/REALKIND
    f(4) = CI*eQED**5

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none

  ! propagators

  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12))+L(6,12))
  den(3) = 1 /((L(5,80))+L(6,80))
  den(5) = 1 /((L(5,35))+L(6,35))
  den(8) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(11) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(16) = 1 /((L(5,44))+L(6,44))
  den(24) = 1 /((L(5,96))+L(6,96))
  den(26) = 1 /((L(5,19))+L(6,19))
  den(35) = 1 /((L(5,28))+L(6,28))
  den(51) = 1 /((L(5,68))+L(6,68))
  den(52) = 1 /((L(5,48))+L(6,48))
  den(54) = 1 /((L(5,11))+L(6,11))
  den(57) = 1 /((L(5,48) - MZ2)+L(6,48))
  den(64) = 1 /((L(5,56))+L(6,56))
  den(72) = 1 /((L(5,72))+L(6,72))
  den(74) = 1 /((L(5,7))+L(6,7))
  den(83) = 1 /((L(5,52))+L(6,52))
  den(99) = 1 /((L(5,76))+L(6,76))
  den(102) = 1 /((L(5,76) - MZ2)+L(6,76))
  den(121) = 1 /((L(5,112))+L(6,112))
  den(124) = 1 /((L(5,112) - MZ2)+L(6,112))
  den(143) = 1 /((L(5,65))+L(6,65))
  den(145) = 1 /((L(5,14))+L(6,14))
  den(154) = 1 /((L(5,50))+L(6,50))
  den(162) = 1 /((L(5,66))+L(6,66))
  den(164) = 1 /((L(5,13))+L(6,13))
  den(173) = 1 /((L(5,49))+L(6,49))
  den(189) = 1 /((L(5,67))+L(6,67))
  den(193) = 1 /((L(5,67) - MZ2)+L(6,67))

  ! denominators

  den(4) = den(2)*den(3)
  den(6) = den(1)*den(5)
  den(7) = den(4)*den(6)
  den(9) = den(3)*den(8)
  den(10) = den(6)*den(9)
  den(12) = den(5)*den(11)
  den(13) = den(4)*den(12)
  den(14) = den(9)*den(12)
  den(15) = den(1)*den(3)
  den(17) = den(2)*den(16)
  den(18) = den(15)*den(17)
  den(19) = den(8)*den(16)
  den(20) = den(15)*den(19)
  den(21) = den(3)*den(11)
  den(22) = den(17)*den(21)
  den(23) = den(19)*den(21)
  den(25) = den(2)*den(24)
  den(27) = den(1)*den(26)
  den(28) = den(25)*den(27)
  den(29) = den(8)*den(24)
  den(30) = den(27)*den(29)
  den(31) = den(11)*den(26)
  den(32) = den(25)*den(31)
  den(33) = den(29)*den(31)
  den(34) = den(1)*den(24)
  den(36) = den(2)*den(35)
  den(37) = den(34)*den(36)
  den(38) = den(8)*den(35)
  den(39) = den(34)*den(38)
  den(40) = den(11)*den(24)
  den(41) = den(36)*den(40)
  den(42) = den(38)*den(40)
  den(43) = den(17)*den(27)
  den(44) = den(19)*den(27)
  den(45) = den(17)*den(31)
  den(46) = den(19)*den(31)
  den(47) = den(6)*den(36)
  den(48) = den(6)*den(38)
  den(49) = den(12)*den(36)
  den(50) = den(12)*den(38)
  den(53) = den(51)*den(52)
  den(55) = den(1)*den(54)
  den(56) = den(53)*den(55)
  den(58) = den(51)*den(57)
  den(59) = den(55)*den(58)
  den(60) = den(11)*den(54)
  den(61) = den(53)*den(60)
  den(62) = den(58)*den(60)
  den(63) = den(1)*den(51)
  den(65) = den(52)*den(64)
  den(66) = den(63)*den(65)
  den(67) = den(57)*den(64)
  den(68) = den(63)*den(67)
  den(69) = den(11)*den(51)
  den(70) = den(65)*den(69)
  den(71) = den(67)*den(69)
  den(73) = den(52)*den(72)
  den(75) = den(1)*den(74)
  den(76) = den(73)*den(75)
  den(77) = den(57)*den(72)
  den(78) = den(75)*den(77)
  den(79) = den(11)*den(74)
  den(80) = den(73)*den(79)
  den(81) = den(77)*den(79)
  den(82) = den(1)*den(72)
  den(84) = den(52)*den(83)
  den(85) = den(82)*den(84)
  den(86) = den(57)*den(83)
  den(87) = den(82)*den(86)
  den(88) = den(11)*den(72)
  den(89) = den(84)*den(88)
  den(90) = den(86)*den(88)
  den(91) = den(65)*den(75)
  den(92) = den(67)*den(75)
  den(93) = den(65)*den(79)
  den(94) = den(67)*den(79)
  den(95) = den(55)*den(84)
  den(96) = den(55)*den(86)
  den(97) = den(60)*den(84)
  den(98) = den(60)*den(86)
  den(100) = den(51)*den(99)
  den(101) = den(27)*den(100)
  den(103) = den(51)*den(102)
  den(104) = den(27)*den(103)
  den(105) = den(31)*den(100)
  den(106) = den(31)*den(103)
  den(107) = den(6)*den(100)
  den(108) = den(6)*den(103)
  den(109) = den(12)*den(100)
  den(110) = den(12)*den(103)
  den(111) = den(72)*den(99)
  den(112) = den(27)*den(111)
  den(113) = den(72)*den(102)
  den(114) = den(27)*den(113)
  den(115) = den(31)*den(111)
  den(116) = den(31)*den(113)
  den(117) = den(6)*den(111)
  den(118) = den(6)*den(113)
  den(119) = den(12)*den(111)
  den(120) = den(12)*den(113)
  den(122) = den(3)*den(121)
  den(123) = den(75)*den(122)
  den(125) = den(3)*den(124)
  den(126) = den(75)*den(125)
  den(127) = den(79)*den(122)
  den(128) = den(79)*den(125)
  den(129) = den(55)*den(122)
  den(130) = den(55)*den(125)
  den(131) = den(60)*den(122)
  den(132) = den(60)*den(125)
  den(133) = den(24)*den(121)
  den(134) = den(75)*den(133)
  den(135) = den(24)*den(124)
  den(136) = den(75)*den(135)
  den(137) = den(79)*den(133)
  den(138) = den(79)*den(135)
  den(139) = den(55)*den(133)
  den(140) = den(55)*den(135)
  den(141) = den(60)*den(133)
  den(142) = den(60)*den(135)
  den(144) = den(52)*den(143)
  den(146) = den(2)*den(145)
  den(147) = den(144)*den(146)
  den(148) = den(57)*den(143)
  den(149) = den(146)*den(148)
  den(150) = den(8)*den(145)
  den(151) = den(144)*den(150)
  den(152) = den(148)*den(150)
  den(153) = den(2)*den(143)
  den(155) = den(52)*den(154)
  den(156) = den(153)*den(155)
  den(157) = den(8)*den(143)
  den(158) = den(155)*den(157)
  den(159) = den(57)*den(154)
  den(160) = den(153)*den(159)
  den(161) = den(157)*den(159)
  den(163) = den(52)*den(162)
  den(165) = den(2)*den(164)
  den(166) = den(163)*den(165)
  den(167) = den(57)*den(162)
  den(168) = den(165)*den(167)
  den(169) = den(8)*den(164)
  den(170) = den(163)*den(169)
  den(171) = den(167)*den(169)
  den(172) = den(2)*den(162)
  den(174) = den(52)*den(173)
  den(175) = den(172)*den(174)
  den(176) = den(8)*den(162)
  den(177) = den(174)*den(176)
  den(178) = den(57)*den(173)
  den(179) = den(172)*den(178)
  den(180) = den(176)*den(178)
  den(181) = den(155)*den(165)
  den(182) = den(159)*den(165)
  den(183) = den(155)*den(169)
  den(184) = den(159)*den(169)
  den(185) = den(146)*den(174)
  den(186) = den(150)*den(174)
  den(187) = den(146)*den(178)
  den(188) = den(150)*den(178)
  den(190) = den(143)*den(189)
  den(191) = den(17)*den(190)
  den(192) = den(19)*den(190)
  den(194) = den(143)*den(193)
  den(195) = den(17)*den(194)
  den(196) = den(19)*den(194)
  den(197) = den(36)*den(190)
  den(198) = den(38)*den(190)
  den(199) = den(36)*den(194)
  den(200) = den(38)*den(194)
  den(201) = den(162)*den(189)
  den(202) = den(17)*den(201)
  den(203) = den(19)*den(201)
  den(204) = den(162)*den(193)
  den(205) = den(17)*den(204)
  den(206) = den(19)*den(204)
  den(207) = den(36)*den(201)
  den(208) = den(38)*den(201)
  den(209) = den(36)*den(204)
  den(210) = den(38)*den(204)
  den(211) = den(122)*den(165)
  den(212) = den(125)*den(165)
  den(213) = den(122)*den(169)
  den(214) = den(125)*den(169)
  den(215) = den(122)*den(146)
  den(216) = den(122)*den(150)
  den(217) = den(125)*den(146)
  den(218) = den(125)*den(150)
  den(219) = den(133)*den(165)
  den(220) = den(135)*den(165)
  den(221) = den(133)*den(169)
  den(222) = den(135)*den(169)
  den(223) = den(133)*den(146)
  den(224) = den(133)*den(150)
  den(225) = den(135)*den(146)
  den(226) = den(135)*den(150)
  den(227) = den(65)*den(190)
  den(228) = den(67)*den(190)
  den(229) = den(65)*den(194)
  den(230) = den(67)*den(194)
  den(231) = den(84)*den(190)
  den(232) = den(86)*den(190)
  den(233) = den(84)*den(194)
  den(234) = den(86)*den(194)
  den(235) = den(65)*den(201)
  den(236) = den(67)*den(201)
  den(237) = den(65)*den(204)
  den(238) = den(67)*den(204)
  den(239) = den(84)*den(201)
  den(240) = den(86)*den(201)
  den(241) = den(84)*den(204)
  den(242) = den(86)*den(204)
  den(243) = den(100)*den(155)
  den(244) = den(100)*den(159)
  den(245) = den(103)*den(155)
  den(246) = den(103)*den(159)
  den(247) = den(100)*den(174)
  den(248) = den(103)*den(174)
  den(249) = den(100)*den(178)
  den(250) = den(103)*den(178)
  den(251) = den(111)*den(155)
  den(252) = den(111)*den(159)
  den(253) = den(113)*den(155)
  den(254) = den(113)*den(159)
  den(255) = den(111)*den(174)
  den(256) = den(113)*den(174)
  den(257) = den(111)*den(178)
  den(258) = den(113)*den(178)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_ppllll_ew_eexmmxddxa_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_ppllll_ew_eexmmxddxa_1_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ mu- mu+ down anti-down gamma -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: L
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppllll_ew_eexmmxddxa_1, only: &
    & external_perm_ppllll_ew_eexmmxddxa_1, &
    & external_perm_inv_ppllll_ew_eexmmxddxa_1, &
    & extcomb_perm_ppllll_ew_eexmmxddxa_1, &
    & average_factor_ppllll_ew_eexmmxddxa_1
  use ol_external_ppllll_ew_eexmmxddxa_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllll_ew_eexmmxddxa_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllll_ew_eexmmxddxa_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_ppllll_ew_eexmmxddxa_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,7)
  integer           :: extmasses2(7)
  real(REALKIND)    :: M2add(0:30-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(1), M1helarray(1,128)
  real(REALKIND)    :: P_scatt_intern(0:3,7)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,18), wf8(8,60), wf16(16,84), wf128(128,168)

  type(polcont) :: A(128,168)
  complex(REALKIND) :: Aj(168)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppllll_ew_eexmmxddxa_1, 7,.false.)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_ppllll_ew_eexmmxddxa_1(I)
  else if (I < 0) then
    JBmunu = external_perm_ppllll_ew_eexmmxddxa_1(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppllll_ew_eexmmxddxa_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1))
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2))
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3))
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4))
  call pol_wf_Q(P(:,5), rZERO, H5, ex5, POLSEL(5))
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6))
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_Q(P(:,1), rZERO, H1, ex1, 0)
      call pol_wf_A(P(:,2), rZERO, H2, ex2, 0)
      call pol_wf_Q(P(:,3), rZERO, H3, ex3, 0)
      call pol_wf_A(P(:,4), rZERO, H4, ex4, 0)
      call pol_wf_Q(P(:,5), rZERO, H5, ex5, 0)
      call pol_wf_A(P(:,6), rZERO, H6, ex6, 0)
      call pol_wf_V(P(:,7), rZERO, H7, ex7, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)
    call helbookkeeping_flip(H7, 7, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H7, ex7, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1, ex2, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3, ex4, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, ex7, ex5, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_Q_A(ntry, wf4(:,3), 80, ZERO, 0_intkind1, wf4(:,4), n2(1))
  call vert_AV_Q(ntry, ex6, wf4(:,1), wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,4), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call prop_A_Q(ntry, wf8(:,1), 35, ZERO, 0_intkind1, wf8(:,2), n2(2))
  call vert_QA_Z(gZl,ntry, ex3, ex4, wf4(:,5), n3(:,6), t3x4(:,:,4))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), wf4(:,4), wf16(:,2), n3(:,7), t3x16(:,:,2))
  call vert_QA_Z(gZl,ntry, ex1, ex2, wf4(:,6), n3(:,8), t3x4(:,:,5))
  call vert_AZ_Q(gZd,ntry, ex6, wf4(:,6), wf8(:,3), n3(:,9), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 35, ZERO, 0_intkind1, wf8(:,4), n2(3))
  call vert_AV_Q(ntry, ex6, wf4(:,2), wf8(:,5), n3(:,10), t3x8(:,:,3))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,3), n3(:,11), t3x16(:,:,3))
  call prop_A_Q(ntry, wf8(:,5), 44, ZERO, 0_intkind1, wf8(:,6), n2(4))
  call vert_AZ_Q(gZd,ntry, ex6, wf4(:,5), wf8(:,7), n3(:,12), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,7), 44, ZERO, 0_intkind1, wf8(:,8), n2(5))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,4), wf16(:,4), n3(:,13), t3x16(:,:,4))
  call vert_AV_Q(ntry, ex6, ex7, wf4(:,7), n3(:,14), t3x4(:,:,6))
  call prop_A_Q(ntry, wf4(:,7), 96, ZERO, 0_intkind1, wf4(:,8), n2(6))
  call vert_VQ_A(ntry, wf4(:,1), ex5, wf8(:,9), n3(:,15), t3x8(:,:,5))
  call vert_AV_Q(ntry, wf4(:,8), wf4(:,2), wf16(:,5), n3(:,16), t3x16(:,:,5))
  call prop_Q_A(ntry, wf8(:,9), 19, ZERO, 0_intkind1, wf8(:,10), n2(7))
  call vert_AZ_Q(gZd,ntry, wf4(:,8), wf4(:,5), wf16(:,6), n3(:,17), t3x16(:,:,6))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), ex5, wf8(:,11), n3(:,18), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,11), 19, ZERO, 0_intkind1, wf8(:,12), n2(8))
  call vert_VQ_A(ntry, wf4(:,2), ex5, wf8(:,13), n3(:,19), t3x8(:,:,7))
  call vert_AV_Q(ntry, wf4(:,8), wf4(:,1), wf16(:,7), n3(:,20), t3x16(:,:,7))
  call prop_Q_A(ntry, wf8(:,13), 28, ZERO, 0_intkind1, wf8(:,14), n2(9))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), ex5, wf8(:,15), n3(:,21), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,15), 28, ZERO, 0_intkind1, wf8(:,16), n2(10))
  call vert_AZ_Q(gZd,ntry, wf4(:,8), wf4(:,6), wf16(:,8), n3(:,22), t3x16(:,:,8))
  call vert_VQ_A(ntry, ex7, wf8(:,10), wf16(:,9), n3(:,23), t3x16(:,:,9))
  call vert_VQ_A(ntry, ex7, wf8(:,12), wf16(:,10), n3(:,24), t3x16(:,:,10))
  call vert_VQ_A(ntry, ex7, wf8(:,14), wf16(:,11), n3(:,25), t3x16(:,:,11))
  call vert_VQ_A(ntry, ex7, wf8(:,16), wf16(:,12), n3(:,26), t3x16(:,:,12))
  call vert_VQ_A(ntry, ex7, ex3, wf4(:,9), n3(:,27), t3x4(:,:,7))
  call vert_QA_V(ntry, ex5, ex6, wf4(:,10), n3(:,28), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,9), 68, ZERO, 0_intkind1, wf4(:,11), n2(11))
  call vert_AV_Q(ntry, ex4, wf4(:,1), wf8(:,17), n3(:,29), t3x8(:,:,9))
  call vert_VQ_A(ntry, wf4(:,10), wf4(:,11), wf16(:,13), n3(:,30), t3x16(:,:,13))
  call prop_A_Q(ntry, wf8(:,17), 11, ZERO, 0_intkind1, wf8(:,18), n2(12))
  call vert_QA_Z(gZd,ntry, ex5, ex6, wf4(:,12), n3(:,31), t3x4(:,:,9))
  call vert_ZQ_A(gZl,ntry, wf4(:,12), wf4(:,11), wf16(:,14), n3(:,32), t3x16(:,:,14))
  call vert_AZ_Q(gZl,ntry, ex4, wf4(:,6), wf8(:,19), n3(:,33), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,19), 11, ZERO, 0_intkind1, wf8(:,20), n2(13))
  call vert_AV_Q(ntry, ex4, wf4(:,10), wf8(:,21), n3(:,34), t3x8(:,:,11))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,11), wf16(:,15), n3(:,35), t3x16(:,:,15))
  call prop_A_Q(ntry, wf8(:,21), 56, ZERO, 0_intkind1, wf8(:,22), n2(14))
  call vert_AZ_Q(gZl,ntry, ex4, wf4(:,12), wf8(:,23), n3(:,36), t3x8(:,:,12))
  call prop_A_Q(ntry, wf8(:,23), 56, ZERO, 0_intkind1, wf8(:,24), n2(15))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), wf4(:,11), wf16(:,16), n3(:,37), t3x16(:,:,16))
  call vert_AV_Q(ntry, ex4, ex7, wf4(:,13), n3(:,38), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,13), 72, ZERO, 0_intkind1, wf4(:,14), n2(16))
  call vert_VQ_A(ntry, wf4(:,1), ex3, wf8(:,25), n3(:,39), t3x8(:,:,13))
  call vert_AV_Q(ntry, wf4(:,14), wf4(:,10), wf16(:,17), n3(:,40), t3x16(:,:,17))
  call prop_Q_A(ntry, wf8(:,25), 7, ZERO, 0_intkind1, wf8(:,26), n2(17))
  call vert_AZ_Q(gZl,ntry, wf4(:,14), wf4(:,12), wf16(:,18), n3(:,41), t3x16(:,:,18))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), ex3, wf8(:,27), n3(:,42), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,27), 7, ZERO, 0_intkind1, wf8(:,28), n2(18))
  call vert_VQ_A(ntry, wf4(:,10), ex3, wf8(:,29), n3(:,43), t3x8(:,:,15))
  call vert_AV_Q(ntry, wf4(:,14), wf4(:,1), wf16(:,19), n3(:,44), t3x16(:,:,19))
  call prop_Q_A(ntry, wf8(:,29), 52, ZERO, 0_intkind1, wf8(:,30), n2(19))
  call vert_ZQ_A(gZl,ntry, wf4(:,12), ex3, wf8(:,31), n3(:,45), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,31), 52, ZERO, 0_intkind1, wf8(:,32), n2(20))
  call vert_AZ_Q(gZl,ntry, wf4(:,14), wf4(:,6), wf16(:,20), n3(:,46), t3x16(:,:,20))
  call vert_VQ_A(ntry, ex7, wf8(:,26), wf16(:,21), n3(:,47), t3x16(:,:,21))
  call vert_VQ_A(ntry, ex7, wf8(:,28), wf16(:,22), n3(:,48), t3x16(:,:,22))
  call vert_VQ_A(ntry, ex7, wf8(:,30), wf16(:,23), n3(:,49), t3x16(:,:,23))
  call vert_VQ_A(ntry, ex7, wf8(:,32), wf16(:,24), n3(:,50), t3x16(:,:,24))
  call vert_QA_V(ntry, wf4(:,11), ex4, wf8(:,33), n3(:,51), t3x8(:,:,17))
  call vert_AV_Q(ntry, ex6, wf8(:,33), wf16(:,25), n3(:,52), t3x16(:,:,25))
  call vert_QA_Z(gZl,ntry, wf4(:,11), ex4, wf8(:,34), n3(:,53), t3x8(:,:,18))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,34), wf16(:,26), n3(:,54), t3x16(:,:,26))
  call vert_VQ_A(ntry, wf8(:,33), ex5, wf16(:,27), n3(:,55), t3x16(:,:,27))
  call vert_ZQ_A(gZd,ntry, wf8(:,34), ex5, wf16(:,28), n3(:,56), t3x16(:,:,28))
  call vert_QA_V(ntry, ex3, wf4(:,14), wf8(:,35), n3(:,57), t3x8(:,:,19))
  call vert_AV_Q(ntry, ex6, wf8(:,35), wf16(:,29), n3(:,58), t3x16(:,:,29))
  call vert_QA_Z(gZl,ntry, ex3, wf4(:,14), wf8(:,36), n3(:,59), t3x8(:,:,20))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,36), wf16(:,30), n3(:,60), t3x16(:,:,30))
  call vert_VQ_A(ntry, wf8(:,35), ex5, wf16(:,31), n3(:,61), t3x16(:,:,31))
  call vert_ZQ_A(gZd,ntry, wf8(:,36), ex5, wf16(:,32), n3(:,62), t3x16(:,:,32))
  call vert_QA_V(ntry, wf4(:,4), ex6, wf8(:,37), n3(:,63), t3x8(:,:,21))
  call vert_QA_V(ntry, wf8(:,26), ex4, wf16(:,33), n3(:,64), t3x16(:,:,33))
  call vert_QA_Z(gZd,ntry, wf4(:,4), ex6, wf8(:,38), n3(:,65), t3x8(:,:,22))
  call vert_QA_Z(gZl,ntry, wf8(:,26), ex4, wf16(:,34), n3(:,66), t3x16(:,:,34))
  call vert_QA_V(ntry, wf8(:,28), ex4, wf16(:,35), n3(:,67), t3x16(:,:,35))
  call vert_QA_Z(gZl,ntry, wf8(:,28), ex4, wf16(:,36), n3(:,68), t3x16(:,:,36))
  call vert_QA_V(ntry, ex3, wf8(:,18), wf16(:,37), n3(:,69), t3x16(:,:,37))
  call vert_QA_Z(gZl,ntry, ex3, wf8(:,18), wf16(:,38), n3(:,70), t3x16(:,:,38))
  call vert_QA_V(ntry, ex3, wf8(:,20), wf16(:,39), n3(:,71), t3x16(:,:,39))
  call vert_QA_Z(gZl,ntry, ex3, wf8(:,20), wf16(:,40), n3(:,72), t3x16(:,:,40))
  call vert_QA_V(ntry, ex5, wf4(:,8), wf8(:,39), n3(:,73), t3x8(:,:,23))
  call vert_QA_Z(gZd,ntry, ex5, wf4(:,8), wf8(:,40), n3(:,74), t3x8(:,:,24))
  call vert_VQ_A(ntry, ex7, ex1, wf4(:,15), n3(:,75), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,15), 65, ZERO, 0_intkind1, wf4(:,16), n2(21))
  call vert_AV_Q(ntry, ex2, wf4(:,2), wf8(:,41), n3(:,76), t3x8(:,:,25))
  call vert_VQ_A(ntry, wf4(:,10), wf4(:,16), wf16(:,41), n3(:,77), t3x16(:,:,41))
  call prop_A_Q(ntry, wf8(:,41), 14, ZERO, 0_intkind1, wf8(:,42), n2(22))
  call vert_ZQ_A(gZl,ntry, wf4(:,12), wf4(:,16), wf16(:,42), n3(:,78), t3x16(:,:,42))
  call vert_AZ_Q(gZl,ntry, ex2, wf4(:,5), wf8(:,43), n3(:,79), t3x8(:,:,26))
  call prop_A_Q(ntry, wf8(:,43), 14, ZERO, 0_intkind1, wf8(:,44), n2(23))
  call vert_AV_Q(ntry, ex2, wf4(:,10), wf8(:,45), n3(:,80), t3x8(:,:,27))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,16), wf16(:,43), n3(:,81), t3x16(:,:,43))
  call prop_A_Q(ntry, wf8(:,45), 50, ZERO, 0_intkind1, wf8(:,46), n2(24))
  call vert_ZQ_A(gZl,ntry, wf4(:,5), wf4(:,16), wf16(:,44), n3(:,82), t3x16(:,:,44))
  call vert_AZ_Q(gZl,ntry, ex2, wf4(:,12), wf8(:,47), n3(:,83), t3x8(:,:,28))
  call prop_A_Q(ntry, wf8(:,47), 50, ZERO, 0_intkind1, wf8(:,48), n2(25))
  call vert_AV_Q(ntry, ex2, ex7, wf4(:,17), n3(:,84), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,17), 66, ZERO, 0_intkind1, wf4(:,18), n2(26))
  call vert_VQ_A(ntry, wf4(:,2), ex1, wf8(:,49), n3(:,85), t3x8(:,:,29))
  call vert_AV_Q(ntry, wf4(:,18), wf4(:,10), wf16(:,45), n3(:,86), t3x16(:,:,45))
  call prop_Q_A(ntry, wf8(:,49), 13, ZERO, 0_intkind1, wf8(:,50), n2(27))
  call vert_AZ_Q(gZl,ntry, wf4(:,18), wf4(:,12), wf16(:,46), n3(:,87), t3x16(:,:,46))
  call vert_ZQ_A(gZl,ntry, wf4(:,5), ex1, wf8(:,51), n3(:,88), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,51), 13, ZERO, 0_intkind1, wf8(:,52), n2(28))
  call vert_VQ_A(ntry, wf4(:,10), ex1, wf8(:,53), n3(:,89), t3x8(:,:,31))
  call vert_AV_Q(ntry, wf4(:,18), wf4(:,2), wf16(:,47), n3(:,90), t3x16(:,:,47))
  call prop_Q_A(ntry, wf8(:,53), 49, ZERO, 0_intkind1, wf8(:,54), n2(29))
  call vert_AZ_Q(gZl,ntry, wf4(:,18), wf4(:,5), wf16(:,48), n3(:,91), t3x16(:,:,48))
  call vert_ZQ_A(gZl,ntry, wf4(:,12), ex1, wf8(:,55), n3(:,92), t3x8(:,:,32))
  call prop_Q_A(ntry, wf8(:,55), 49, ZERO, 0_intkind1, wf8(:,56), n2(30))
  call vert_VQ_A(ntry, ex7, wf8(:,50), wf16(:,49), n3(:,93), t3x16(:,:,49))
  call vert_VQ_A(ntry, ex7, wf8(:,52), wf16(:,50), n3(:,94), t3x16(:,:,50))
  call vert_VQ_A(ntry, ex7, wf8(:,54), wf16(:,51), n3(:,95), t3x16(:,:,51))
  call vert_VQ_A(ntry, ex7, wf8(:,56), wf16(:,52), n3(:,96), t3x16(:,:,52))
  call vert_QA_V(ntry, wf4(:,16), ex2, wf8(:,57), n3(:,97), t3x8(:,:,33))
  call vert_VQ_A(ntry, wf8(:,57), ex5, wf16(:,53), n3(:,98), t3x16(:,:,53))
  call vert_QA_Z(gZl,ntry, wf4(:,16), ex2, wf8(:,58), n3(:,99), t3x8(:,:,34))
  call vert_ZQ_A(gZd,ntry, wf8(:,58), ex5, wf16(:,54), n3(:,100), t3x16(:,:,54))
  call vert_AV_Q(ntry, ex6, wf8(:,57), wf16(:,55), n3(:,101), t3x16(:,:,55))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,58), wf16(:,56), n3(:,102), t3x16(:,:,56))
  call vert_QA_V(ntry, ex1, wf4(:,18), wf8(:,59), n3(:,103), t3x8(:,:,35))
  call vert_VQ_A(ntry, wf8(:,59), ex5, wf16(:,57), n3(:,104), t3x16(:,:,57))
  call vert_QA_Z(gZl,ntry, ex1, wf4(:,18), wf8(:,60), n3(:,105), t3x8(:,:,36))
  call vert_ZQ_A(gZd,ntry, wf8(:,60), ex5, wf16(:,58), n3(:,106), t3x16(:,:,58))
  call vert_AV_Q(ntry, ex6, wf8(:,59), wf16(:,59), n3(:,107), t3x16(:,:,59))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,60), wf16(:,60), n3(:,108), t3x16(:,:,60))
  call vert_QA_V(ntry, wf8(:,50), ex2, wf16(:,61), n3(:,109), t3x16(:,:,61))
  call vert_QA_Z(gZl,ntry, wf8(:,50), ex2, wf16(:,62), n3(:,110), t3x16(:,:,62))
  call vert_QA_V(ntry, wf8(:,52), ex2, wf16(:,63), n3(:,111), t3x16(:,:,63))
  call vert_QA_Z(gZl,ntry, wf8(:,52), ex2, wf16(:,64), n3(:,112), t3x16(:,:,64))
  call vert_QA_V(ntry, ex1, wf8(:,42), wf16(:,65), n3(:,113), t3x16(:,:,65))
  call vert_QA_V(ntry, ex1, wf8(:,44), wf16(:,66), n3(:,114), t3x16(:,:,66))
  call vert_QA_Z(gZl,ntry, ex1, wf8(:,42), wf16(:,67), n3(:,115), t3x16(:,:,67))
  call vert_QA_Z(gZl,ntry, ex1, wf8(:,44), wf16(:,68), n3(:,116), t3x16(:,:,68))
  call vert_VQ_A(ntry, wf8(:,57), ex3, wf16(:,69), n3(:,117), t3x16(:,:,69))
  call vert_ZQ_A(gZl,ntry, wf8(:,58), ex3, wf16(:,70), n3(:,118), t3x16(:,:,70))
  call vert_AV_Q(ntry, ex4, wf8(:,57), wf16(:,71), n3(:,119), t3x16(:,:,71))
  call vert_AZ_Q(gZl,ntry, ex4, wf8(:,58), wf16(:,72), n3(:,120), t3x16(:,:,72))
  call vert_VQ_A(ntry, wf8(:,59), ex3, wf16(:,73), n3(:,121), t3x16(:,:,73))
  call vert_ZQ_A(gZl,ntry, wf8(:,60), ex3, wf16(:,74), n3(:,122), t3x16(:,:,74))
  call vert_AV_Q(ntry, ex4, wf8(:,59), wf16(:,75), n3(:,123), t3x16(:,:,75))
  call vert_AZ_Q(gZl,ntry, ex4, wf8(:,60), wf16(:,76), n3(:,124), t3x16(:,:,76))
  call vert_QA_V(ntry, ex1, wf8(:,46), wf16(:,77), n3(:,125), t3x16(:,:,77))
  call vert_QA_V(ntry, ex1, wf8(:,48), wf16(:,78), n3(:,126), t3x16(:,:,78))
  call vert_QA_Z(gZl,ntry, ex1, wf8(:,46), wf16(:,79), n3(:,127), t3x16(:,:,79))
  call vert_QA_Z(gZl,ntry, ex1, wf8(:,48), wf16(:,80), n3(:,128), t3x16(:,:,80))
  call vert_QA_V(ntry, wf8(:,54), ex2, wf16(:,81), n3(:,129), t3x16(:,:,81))
  call vert_QA_Z(gZl,ntry, wf8(:,54), ex2, wf16(:,82), n3(:,130), t3x16(:,:,82))
  call vert_QA_V(ntry, wf8(:,56), ex2, wf16(:,83), n3(:,131), t3x16(:,:,83))
  call vert_QA_Z(gZl,ntry, wf8(:,56), ex2, wf16(:,84), n3(:,132), t3x16(:,:,84))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
      if (any(POLSEL /= 0)) then
        ntry = 2
        goto 42
      end if
    end if
  end do

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  if ( JBmunu /= 0 ) then ! POWHEG's Bmunu helicity correlation
    P_scatt_intern = P_scatt
    M2munu = 0
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it doesn't vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_ppllll_ew_eexmmxddxa_1
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppllll_ew_eexmmxddxa_1

  do k = 0, 30-1
    M2(k) = M2add(extcomb_perm_ppllll_ew_eexmmxddxa_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*7-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_QA(nsync, wf16(:,1), wf8(:,2), A(:,1), n3(:,133), t3x128(:,:,1), nhel, den(7))
    call cont_QA(nsync, wf8(:,2), wf16(:,2), A(:,2), n3(:,134), t3x128(:,:,2), nhel, den(10))
    call cont_QA(nsync, wf16(:,1), wf8(:,4), A(:,3), n3(:,135), t3x128(:,:,3), nhel, den(13))
    call cont_QA(nsync, wf16(:,2), wf8(:,4), A(:,4), n3(:,136), t3x128(:,:,4), nhel, den(14))
    call cont_QA(nsync, wf16(:,3), wf8(:,6), A(:,5), n3(:,137), t3x128(:,:,5), nhel, den(18))
    call cont_QA(nsync, wf16(:,3), wf8(:,8), A(:,6), n3(:,138), t3x128(:,:,6), nhel, den(20))
    call cont_QA(nsync, wf8(:,6), wf16(:,4), A(:,7), n3(:,139), t3x128(:,:,7), nhel, den(22))
    call cont_QA(nsync, wf8(:,8), wf16(:,4), A(:,8), n3(:,140), t3x128(:,:,8), nhel, den(23))
    call cont_QA(nsync, wf16(:,5), wf8(:,10), A(:,9), n3(:,141), t3x128(:,:,9), nhel, den(28))
    call cont_QA(nsync, wf8(:,10), wf16(:,6), A(:,10), n3(:,142), t3x128(:,:,10), nhel, den(30))
    call cont_QA(nsync, wf16(:,5), wf8(:,12), A(:,11), n3(:,143), t3x128(:,:,11), nhel, den(32))
    call cont_QA(nsync, wf16(:,6), wf8(:,12), A(:,12), n3(:,144), t3x128(:,:,12), nhel, den(33))
    call cont_QA(nsync, wf16(:,7), wf8(:,14), A(:,13), n3(:,145), t3x128(:,:,13), nhel, den(37))
    call cont_QA(nsync, wf16(:,7), wf8(:,16), A(:,14), n3(:,146), t3x128(:,:,14), nhel, den(39))
    call cont_QA(nsync, wf8(:,14), wf16(:,8), A(:,15), n3(:,147), t3x128(:,:,15), nhel, den(41))
    call cont_QA(nsync, wf8(:,16), wf16(:,8), A(:,16), n3(:,148), t3x128(:,:,16), nhel, den(42))
    call cont_QA(nsync, wf8(:,6), wf16(:,9), A(:,17), n3(:,149), t3x128(:,:,17), nhel, den(43))
    call cont_QA(nsync, wf8(:,8), wf16(:,9), A(:,18), n3(:,150), t3x128(:,:,18), nhel, den(44))
    call cont_QA(nsync, wf8(:,6), wf16(:,10), A(:,19), n3(:,151), t3x128(:,:,19), nhel, den(45))
    call cont_QA(nsync, wf8(:,8), wf16(:,10), A(:,20), n3(:,152), t3x128(:,:,20), nhel, den(46))
    call cont_QA(nsync, wf8(:,2), wf16(:,11), A(:,21), n3(:,153), t3x128(:,:,21), nhel, den(47))
    call cont_QA(nsync, wf8(:,2), wf16(:,12), A(:,22), n3(:,154), t3x128(:,:,22), nhel, den(48))
    call cont_QA(nsync, wf8(:,4), wf16(:,11), A(:,23), n3(:,155), t3x128(:,:,23), nhel, den(49))
    call cont_QA(nsync, wf8(:,4), wf16(:,12), A(:,24), n3(:,156), t3x128(:,:,24), nhel, den(50))
    call cont_QA(nsync, wf16(:,13), wf8(:,18), A(:,25), n3(:,157), t3x128(:,:,25), nhel, den(56))
    call cont_QA(nsync, wf8(:,18), wf16(:,14), A(:,26), n3(:,158), t3x128(:,:,26), nhel, den(59))
    call cont_QA(nsync, wf16(:,13), wf8(:,20), A(:,27), n3(:,159), t3x128(:,:,27), nhel, den(61))
    call cont_QA(nsync, wf16(:,14), wf8(:,20), A(:,28), n3(:,160), t3x128(:,:,28), nhel, den(62))
    call cont_QA(nsync, wf16(:,15), wf8(:,22), A(:,29), n3(:,161), t3x128(:,:,29), nhel, den(66))
    call cont_QA(nsync, wf16(:,15), wf8(:,24), A(:,30), n3(:,162), t3x128(:,:,30), nhel, den(68))
    call cont_QA(nsync, wf8(:,22), wf16(:,16), A(:,31), n3(:,163), t3x128(:,:,31), nhel, den(70))
    call cont_QA(nsync, wf8(:,24), wf16(:,16), A(:,32), n3(:,164), t3x128(:,:,32), nhel, den(71))
    call cont_QA(nsync, wf16(:,17), wf8(:,26), A(:,33), n3(:,165), t3x128(:,:,33), nhel, den(76))
    call cont_QA(nsync, wf8(:,26), wf16(:,18), A(:,34), n3(:,166), t3x128(:,:,34), nhel, den(78))
    call cont_QA(nsync, wf16(:,17), wf8(:,28), A(:,35), n3(:,167), t3x128(:,:,35), nhel, den(80))
    call cont_QA(nsync, wf16(:,18), wf8(:,28), A(:,36), n3(:,168), t3x128(:,:,36), nhel, den(81))
    call cont_QA(nsync, wf16(:,19), wf8(:,30), A(:,37), n3(:,169), t3x128(:,:,37), nhel, den(85))
    call cont_QA(nsync, wf16(:,19), wf8(:,32), A(:,38), n3(:,170), t3x128(:,:,38), nhel, den(87))
    call cont_QA(nsync, wf8(:,30), wf16(:,20), A(:,39), n3(:,171), t3x128(:,:,39), nhel, den(89))
    call cont_QA(nsync, wf8(:,32), wf16(:,20), A(:,40), n3(:,172), t3x128(:,:,40), nhel, den(90))
    call cont_QA(nsync, wf8(:,22), wf16(:,21), A(:,41), n3(:,173), t3x128(:,:,41), nhel, den(91))
    call cont_QA(nsync, wf8(:,24), wf16(:,21), A(:,42), n3(:,174), t3x128(:,:,42), nhel, den(92))
    call cont_QA(nsync, wf8(:,22), wf16(:,22), A(:,43), n3(:,175), t3x128(:,:,43), nhel, den(93))
    call cont_QA(nsync, wf8(:,24), wf16(:,22), A(:,44), n3(:,176), t3x128(:,:,44), nhel, den(94))
    call cont_QA(nsync, wf8(:,18), wf16(:,23), A(:,45), n3(:,177), t3x128(:,:,45), nhel, den(95))
    call cont_QA(nsync, wf8(:,18), wf16(:,24), A(:,46), n3(:,178), t3x128(:,:,46), nhel, den(96))
    call cont_QA(nsync, wf8(:,20), wf16(:,23), A(:,47), n3(:,179), t3x128(:,:,47), nhel, den(97))
    call cont_QA(nsync, wf8(:,20), wf16(:,24), A(:,48), n3(:,180), t3x128(:,:,48), nhel, den(98))
    call cont_QA(nsync, wf8(:,10), wf16(:,25), A(:,49), n3(:,181), t3x128(:,:,49), nhel, den(101))
    call cont_QA(nsync, wf8(:,10), wf16(:,26), A(:,50), n3(:,182), t3x128(:,:,50), nhel, den(104))
    call cont_QA(nsync, wf8(:,12), wf16(:,25), A(:,51), n3(:,183), t3x128(:,:,51), nhel, den(105))
    call cont_QA(nsync, wf8(:,12), wf16(:,26), A(:,52), n3(:,184), t3x128(:,:,52), nhel, den(106))
    call cont_QA(nsync, wf8(:,2), wf16(:,27), A(:,53), n3(:,185), t3x128(:,:,53), nhel, den(107))
    call cont_QA(nsync, wf8(:,2), wf16(:,28), A(:,54), n3(:,186), t3x128(:,:,54), nhel, den(108))
    call cont_QA(nsync, wf8(:,4), wf16(:,27), A(:,55), n3(:,187), t3x128(:,:,55), nhel, den(109))
    call cont_QA(nsync, wf8(:,4), wf16(:,28), A(:,56), n3(:,188), t3x128(:,:,56), nhel, den(110))
    call cont_QA(nsync, wf8(:,10), wf16(:,29), A(:,57), n3(:,189), t3x128(:,:,57), nhel, den(112))
    call cont_QA(nsync, wf8(:,10), wf16(:,30), A(:,58), n3(:,190), t3x128(:,:,58), nhel, den(114))
    call cont_QA(nsync, wf8(:,12), wf16(:,29), A(:,59), n3(:,191), t3x128(:,:,59), nhel, den(115))
    call cont_QA(nsync, wf8(:,12), wf16(:,30), A(:,60), n3(:,192), t3x128(:,:,60), nhel, den(116))
    call cont_QA(nsync, wf8(:,2), wf16(:,31), A(:,61), n3(:,193), t3x128(:,:,61), nhel, den(117))
    call cont_QA(nsync, wf8(:,2), wf16(:,32), A(:,62), n3(:,194), t3x128(:,:,62), nhel, den(118))
    call cont_QA(nsync, wf8(:,4), wf16(:,31), A(:,63), n3(:,195), t3x128(:,:,63), nhel, den(119))
    call cont_QA(nsync, wf8(:,4), wf16(:,32), A(:,64), n3(:,196), t3x128(:,:,64), nhel, den(120))
    call cont_VV(nsync, wf8(:,37), wf16(:,33), A(:,65), n3(:,197), t3x128(:,:,65), nhel, den(123))
    call cont_VV(nsync, wf8(:,38), wf16(:,34), A(:,66), n3(:,198), t3x128(:,:,66), nhel, den(126))
    call cont_VV(nsync, wf8(:,37), wf16(:,35), A(:,67), n3(:,199), t3x128(:,:,67), nhel, den(127))
    call cont_VV(nsync, wf8(:,38), wf16(:,36), A(:,68), n3(:,200), t3x128(:,:,68), nhel, den(128))
    call cont_VV(nsync, wf8(:,37), wf16(:,37), A(:,69), n3(:,201), t3x128(:,:,69), nhel, den(129))
    call cont_VV(nsync, wf8(:,38), wf16(:,38), A(:,70), n3(:,202), t3x128(:,:,70), nhel, den(130))
    call cont_VV(nsync, wf8(:,37), wf16(:,39), A(:,71), n3(:,203), t3x128(:,:,71), nhel, den(131))
    call cont_VV(nsync, wf8(:,38), wf16(:,40), A(:,72), n3(:,204), t3x128(:,:,72), nhel, den(132))
    call cont_VV(nsync, wf16(:,33), wf8(:,39), A(:,73), n3(:,205), t3x128(:,:,73), nhel, den(134))
    call cont_VV(nsync, wf16(:,34), wf8(:,40), A(:,74), n3(:,206), t3x128(:,:,74), nhel, den(136))
    call cont_VV(nsync, wf16(:,35), wf8(:,39), A(:,75), n3(:,207), t3x128(:,:,75), nhel, den(137))
    call cont_VV(nsync, wf16(:,36), wf8(:,40), A(:,76), n3(:,208), t3x128(:,:,76), nhel, den(138))
    call cont_VV(nsync, wf16(:,37), wf8(:,39), A(:,77), n3(:,209), t3x128(:,:,77), nhel, den(139))
    call cont_VV(nsync, wf16(:,38), wf8(:,40), A(:,78), n3(:,210), t3x128(:,:,78), nhel, den(140))
    call cont_VV(nsync, wf16(:,39), wf8(:,39), A(:,79), n3(:,211), t3x128(:,:,79), nhel, den(141))
    call cont_VV(nsync, wf16(:,40), wf8(:,40), A(:,80), n3(:,212), t3x128(:,:,80), nhel, den(142))
    call cont_QA(nsync, wf16(:,41), wf8(:,42), A(:,81), n3(:,213), t3x128(:,:,81), nhel, den(147))
    call cont_QA(nsync, wf8(:,42), wf16(:,42), A(:,82), n3(:,214), t3x128(:,:,82), nhel, den(149))
    call cont_QA(nsync, wf16(:,41), wf8(:,44), A(:,83), n3(:,215), t3x128(:,:,83), nhel, den(151))
    call cont_QA(nsync, wf16(:,42), wf8(:,44), A(:,84), n3(:,216), t3x128(:,:,84), nhel, den(152))
    call cont_QA(nsync, wf16(:,43), wf8(:,46), A(:,85), n3(:,217), t3x128(:,:,85), nhel, den(156))
    call cont_QA(nsync, wf8(:,46), wf16(:,44), A(:,86), n3(:,218), t3x128(:,:,86), nhel, den(158))
    call cont_QA(nsync, wf16(:,43), wf8(:,48), A(:,87), n3(:,219), t3x128(:,:,87), nhel, den(160))
    call cont_QA(nsync, wf16(:,44), wf8(:,48), A(:,88), n3(:,220), t3x128(:,:,88), nhel, den(161))
    call cont_QA(nsync, wf16(:,45), wf8(:,50), A(:,89), n3(:,221), t3x128(:,:,89), nhel, den(166))
    call cont_QA(nsync, wf8(:,50), wf16(:,46), A(:,90), n3(:,222), t3x128(:,:,90), nhel, den(168))
    call cont_QA(nsync, wf16(:,45), wf8(:,52), A(:,91), n3(:,223), t3x128(:,:,91), nhel, den(170))
    call cont_QA(nsync, wf16(:,46), wf8(:,52), A(:,92), n3(:,224), t3x128(:,:,92), nhel, den(171))
    call cont_QA(nsync, wf16(:,47), wf8(:,54), A(:,93), n3(:,225), t3x128(:,:,93), nhel, den(175))
    call cont_QA(nsync, wf8(:,54), wf16(:,48), A(:,94), n3(:,226), t3x128(:,:,94), nhel, den(177))
    call cont_QA(nsync, wf16(:,47), wf8(:,56), A(:,95), n3(:,227), t3x128(:,:,95), nhel, den(179))
    call cont_QA(nsync, wf16(:,48), wf8(:,56), A(:,96), n3(:,228), t3x128(:,:,96), nhel, den(180))
    call cont_QA(nsync, wf8(:,46), wf16(:,49), A(:,97), n3(:,229), t3x128(:,:,97), nhel, den(181))
    call cont_QA(nsync, wf8(:,48), wf16(:,49), A(:,98), n3(:,230), t3x128(:,:,98), nhel, den(182))
    call cont_QA(nsync, wf8(:,46), wf16(:,50), A(:,99), n3(:,231), t3x128(:,:,99), nhel, den(183))
    call cont_QA(nsync, wf8(:,48), wf16(:,50), A(:,100), n3(:,232), t3x128(:,:,100), nhel, den(184))
    call cont_QA(nsync, wf8(:,42), wf16(:,51), A(:,101), n3(:,233), t3x128(:,:,101), nhel, den(185))
    call cont_QA(nsync, wf8(:,44), wf16(:,51), A(:,102), n3(:,234), t3x128(:,:,102), nhel, den(186))
    call cont_QA(nsync, wf8(:,42), wf16(:,52), A(:,103), n3(:,235), t3x128(:,:,103), nhel, den(187))
    call cont_QA(nsync, wf8(:,44), wf16(:,52), A(:,104), n3(:,236), t3x128(:,:,104), nhel, den(188))
    call cont_QA(nsync, wf8(:,6), wf16(:,53), A(:,105), n3(:,237), t3x128(:,:,105), nhel, den(191))
    call cont_QA(nsync, wf8(:,8), wf16(:,53), A(:,106), n3(:,238), t3x128(:,:,106), nhel, den(192))
    call cont_QA(nsync, wf8(:,6), wf16(:,54), A(:,107), n3(:,239), t3x128(:,:,107), nhel, den(195))
    call cont_QA(nsync, wf8(:,8), wf16(:,54), A(:,108), n3(:,240), t3x128(:,:,108), nhel, den(196))
    call cont_QA(nsync, wf8(:,14), wf16(:,55), A(:,109), n3(:,241), t3x128(:,:,109), nhel, den(197))
    call cont_QA(nsync, wf8(:,16), wf16(:,55), A(:,110), n3(:,242), t3x128(:,:,110), nhel, den(198))
    call cont_QA(nsync, wf8(:,14), wf16(:,56), A(:,111), n3(:,243), t3x128(:,:,111), nhel, den(199))
    call cont_QA(nsync, wf8(:,16), wf16(:,56), A(:,112), n3(:,244), t3x128(:,:,112), nhel, den(200))
    call cont_QA(nsync, wf8(:,6), wf16(:,57), A(:,113), n3(:,245), t3x128(:,:,113), nhel, den(202))
    call cont_QA(nsync, wf8(:,8), wf16(:,57), A(:,114), n3(:,246), t3x128(:,:,114), nhel, den(203))
    call cont_QA(nsync, wf8(:,6), wf16(:,58), A(:,115), n3(:,247), t3x128(:,:,115), nhel, den(205))
    call cont_QA(nsync, wf8(:,8), wf16(:,58), A(:,116), n3(:,248), t3x128(:,:,116), nhel, den(206))
    call cont_QA(nsync, wf8(:,14), wf16(:,59), A(:,117), n3(:,249), t3x128(:,:,117), nhel, den(207))
    call cont_QA(nsync, wf8(:,16), wf16(:,59), A(:,118), n3(:,250), t3x128(:,:,118), nhel, den(208))
    call cont_QA(nsync, wf8(:,14), wf16(:,60), A(:,119), n3(:,251), t3x128(:,:,119), nhel, den(209))
    call cont_QA(nsync, wf8(:,16), wf16(:,60), A(:,120), n3(:,252), t3x128(:,:,120), nhel, den(210))
    call cont_VV(nsync, wf8(:,37), wf16(:,61), A(:,121), n3(:,253), t3x128(:,:,121), nhel, den(211))
    call cont_VV(nsync, wf8(:,38), wf16(:,62), A(:,122), n3(:,254), t3x128(:,:,122), nhel, den(212))
    call cont_VV(nsync, wf8(:,37), wf16(:,63), A(:,123), n3(:,255), t3x128(:,:,123), nhel, den(213))
    call cont_VV(nsync, wf8(:,38), wf16(:,64), A(:,124), n3(:,256), t3x128(:,:,124), nhel, den(214))
    call cont_VV(nsync, wf8(:,37), wf16(:,65), A(:,125), n3(:,257), t3x128(:,:,125), nhel, den(215))
    call cont_VV(nsync, wf8(:,37), wf16(:,66), A(:,126), n3(:,258), t3x128(:,:,126), nhel, den(216))
    call cont_VV(nsync, wf8(:,38), wf16(:,67), A(:,127), n3(:,259), t3x128(:,:,127), nhel, den(217))
    call cont_VV(nsync, wf8(:,38), wf16(:,68), A(:,128), n3(:,260), t3x128(:,:,128), nhel, den(218))
    call cont_VV(nsync, wf8(:,39), wf16(:,61), A(:,129), n3(:,261), t3x128(:,:,129), nhel, den(219))
    call cont_VV(nsync, wf8(:,40), wf16(:,62), A(:,130), n3(:,262), t3x128(:,:,130), nhel, den(220))
    call cont_VV(nsync, wf8(:,39), wf16(:,63), A(:,131), n3(:,263), t3x128(:,:,131), nhel, den(221))
    call cont_VV(nsync, wf8(:,40), wf16(:,64), A(:,132), n3(:,264), t3x128(:,:,132), nhel, den(222))
    call cont_VV(nsync, wf8(:,39), wf16(:,65), A(:,133), n3(:,265), t3x128(:,:,133), nhel, den(223))
    call cont_VV(nsync, wf8(:,39), wf16(:,66), A(:,134), n3(:,266), t3x128(:,:,134), nhel, den(224))
    call cont_VV(nsync, wf8(:,40), wf16(:,67), A(:,135), n3(:,267), t3x128(:,:,135), nhel, den(225))
    call cont_VV(nsync, wf8(:,40), wf16(:,68), A(:,136), n3(:,268), t3x128(:,:,136), nhel, den(226))
    call cont_QA(nsync, wf8(:,22), wf16(:,69), A(:,137), n3(:,269), t3x128(:,:,137), nhel, den(227))
    call cont_QA(nsync, wf8(:,24), wf16(:,69), A(:,138), n3(:,270), t3x128(:,:,138), nhel, den(228))
    call cont_QA(nsync, wf8(:,22), wf16(:,70), A(:,139), n3(:,271), t3x128(:,:,139), nhel, den(229))
    call cont_QA(nsync, wf8(:,24), wf16(:,70), A(:,140), n3(:,272), t3x128(:,:,140), nhel, den(230))
    call cont_QA(nsync, wf8(:,30), wf16(:,71), A(:,141), n3(:,273), t3x128(:,:,141), nhel, den(231))
    call cont_QA(nsync, wf8(:,32), wf16(:,71), A(:,142), n3(:,274), t3x128(:,:,142), nhel, den(232))
    call cont_QA(nsync, wf8(:,30), wf16(:,72), A(:,143), n3(:,275), t3x128(:,:,143), nhel, den(233))
    call cont_QA(nsync, wf8(:,32), wf16(:,72), A(:,144), n3(:,276), t3x128(:,:,144), nhel, den(234))
    call cont_QA(nsync, wf8(:,22), wf16(:,73), A(:,145), n3(:,277), t3x128(:,:,145), nhel, den(235))
    call cont_QA(nsync, wf8(:,24), wf16(:,73), A(:,146), n3(:,278), t3x128(:,:,146), nhel, den(236))
    call cont_QA(nsync, wf8(:,22), wf16(:,74), A(:,147), n3(:,279), t3x128(:,:,147), nhel, den(237))
    call cont_QA(nsync, wf8(:,24), wf16(:,74), A(:,148), n3(:,280), t3x128(:,:,148), nhel, den(238))
    call cont_QA(nsync, wf8(:,30), wf16(:,75), A(:,149), n3(:,281), t3x128(:,:,149), nhel, den(239))
    call cont_QA(nsync, wf8(:,32), wf16(:,75), A(:,150), n3(:,282), t3x128(:,:,150), nhel, den(240))
    call cont_QA(nsync, wf8(:,30), wf16(:,76), A(:,151), n3(:,283), t3x128(:,:,151), nhel, den(241))
    call cont_QA(nsync, wf8(:,32), wf16(:,76), A(:,152), n3(:,284), t3x128(:,:,152), nhel, den(242))
    call cont_VV(nsync, wf8(:,33), wf16(:,77), A(:,153), n3(:,285), t3x128(:,:,153), nhel, den(243))
    call cont_VV(nsync, wf8(:,33), wf16(:,78), A(:,154), n3(:,286), t3x128(:,:,154), nhel, den(244))
    call cont_VV(nsync, wf8(:,34), wf16(:,79), A(:,155), n3(:,287), t3x128(:,:,155), nhel, den(245))
    call cont_VV(nsync, wf8(:,34), wf16(:,80), A(:,156), n3(:,288), t3x128(:,:,156), nhel, den(246))
    call cont_VV(nsync, wf8(:,33), wf16(:,81), A(:,157), n3(:,289), t3x128(:,:,157), nhel, den(247))
    call cont_VV(nsync, wf8(:,34), wf16(:,82), A(:,158), n3(:,290), t3x128(:,:,158), nhel, den(248))
    call cont_VV(nsync, wf8(:,33), wf16(:,83), A(:,159), n3(:,291), t3x128(:,:,159), nhel, den(249))
    call cont_VV(nsync, wf8(:,34), wf16(:,84), A(:,160), n3(:,292), t3x128(:,:,160), nhel, den(250))
    call cont_VV(nsync, wf8(:,35), wf16(:,77), A(:,161), n3(:,293), t3x128(:,:,161), nhel, den(251))
    call cont_VV(nsync, wf8(:,35), wf16(:,78), A(:,162), n3(:,294), t3x128(:,:,162), nhel, den(252))
    call cont_VV(nsync, wf8(:,36), wf16(:,79), A(:,163), n3(:,295), t3x128(:,:,163), nhel, den(253))
    call cont_VV(nsync, wf8(:,36), wf16(:,80), A(:,164), n3(:,296), t3x128(:,:,164), nhel, den(254))
    call cont_VV(nsync, wf8(:,35), wf16(:,81), A(:,165), n3(:,297), t3x128(:,:,165), nhel, den(255))
    call cont_VV(nsync, wf8(:,36), wf16(:,82), A(:,166), n3(:,298), t3x128(:,:,166), nhel, den(256))
    call cont_VV(nsync, wf8(:,35), wf16(:,83), A(:,167), n3(:,299), t3x128(:,:,167), nhel, den(257))
    call cont_VV(nsync, wf8(:,36), wf16(:,84), A(:,168), n3(:,300), t3x128(:,:,168), nhel, den(258))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(1) ! M1helarray(1,128)
  integer :: empty(0)

  M1(1) = (-A(j,1)%j-A(j,5)%j-A(j,9)%j-A(j,13)%j-A(j,17)%j-A(j,21)%j)*f(1)+(-A(j,2)%j-A(j,3)%j-A(j,6)%j-A(j,7)%j-A(j,10)%j &
       -A(j,11)%j-A(j,14)%j-A(j,15)%j-A(j,18)%j-A(j,19)%j-A(j,22)%j-A(j,23)%j-A(j,49)%j-A(j,53)%j-A(j,57)%j-A(j,61)%j-A(j,65)%j &
       -A(j,67)%j-A(j,69)%j-A(j,71)%j-A(j,73)%j-A(j,75)%j-A(j,77)%j-A(j,79)%j-A(j,105)%j-A(j,109)%j-A(j,113)%j-A(j,117)%j &
       -A(j,121)%j-A(j,123)%j-A(j,125)%j-A(j,126)%j-A(j,129)%j-A(j,131)%j-A(j,133)%j-A(j,134)%j)*f(2)+(-A(j,4)%j-A(j,8)%j &
       -A(j,12)%j-A(j,16)%j-A(j,20)%j-A(j,24)%j-A(j,25)%j-A(j,27)%j-A(j,29)%j-A(j,31)%j-A(j,33)%j-A(j,35)%j-A(j,37)%j-A(j,39)%j &
       -A(j,41)%j-A(j,43)%j-A(j,45)%j-A(j,47)%j-A(j,50)%j-A(j,51)%j-A(j,54)%j-A(j,55)%j-A(j,58)%j-A(j,59)%j-A(j,62)%j-A(j,63)%j &
       -A(j,66)%j-A(j,68)%j-A(j,70)%j-A(j,72)%j-A(j,74)%j-A(j,76)%j-A(j,78)%j-A(j,80)%j-A(j,81)%j-A(j,83)%j-A(j,85)%j-A(j,86)%j &
       -A(j,89)%j-A(j,91)%j-A(j,93)%j-A(j,94)%j-A(j,97)%j-A(j,99)%j-A(j,101)%j-A(j,102)%j-A(j,106)%j-A(j,107)%j-A(j,110)%j &
       -A(j,111)%j-A(j,114)%j-A(j,115)%j-A(j,118)%j-A(j,119)%j-A(j,122)%j-A(j,124)%j-A(j,127)%j-A(j,128)%j-A(j,130)%j-A(j,132)%j &
       -A(j,135)%j-A(j,136)%j-A(j,137)%j-A(j,139)%j-A(j,141)%j-A(j,143)%j-A(j,145)%j-A(j,147)%j-A(j,149)%j-A(j,151)%j-A(j,153)%j &
       -A(j,155)%j-A(j,157)%j-A(j,158)%j-A(j,161)%j-A(j,163)%j-A(j,165)%j-A(j,166)%j)*f(3)+(-A(j,26)%j-A(j,28)%j-A(j,30)%j &
       -A(j,32)%j-A(j,34)%j-A(j,36)%j-A(j,38)%j-A(j,40)%j-A(j,42)%j-A(j,44)%j-A(j,46)%j-A(j,48)%j-A(j,52)%j-A(j,56)%j-A(j,60)%j &
       -A(j,64)%j-A(j,82)%j-A(j,84)%j-A(j,87)%j-A(j,88)%j-A(j,90)%j-A(j,92)%j-A(j,95)%j-A(j,96)%j-A(j,98)%j-A(j,100)%j-A(j,103)%j &
       -A(j,104)%j-A(j,108)%j-A(j,112)%j-A(j,116)%j-A(j,120)%j-A(j,138)%j-A(j,140)%j-A(j,142)%j-A(j,144)%j-A(j,146)%j-A(j,148)%j &
       -A(j,150)%j-A(j,152)%j-A(j,154)%j-A(j,156)%j-A(j,159)%j-A(j,160)%j-A(j,162)%j-A(j,164)%j-A(j,167)%j-A(j,168)%j)*f(4)

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eexmmxddxa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint(0:30-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 1*extcomb
    do i = 1, 1
      do j = 1, 1
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eexmmxddxa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(1), M2(1)
  real(REALKIND),    intent(out) :: M2colint(0:30-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 1*extcomb
    do i = 1, 1
      do j = 1, 1
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllll_ew_eexmmxddxa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_ppllll_ew_eexmmxddxa_1")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(1,128)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppllll_ew_eexmmxddxa_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppllll_ew_eexmmxddxa_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppllll_ew_eexmmxddxa_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    30, [ (k, k = 0, 30-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppllll_ew_eexmmxddxa_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppllll_ew_eexmmxddxa_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(7)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(7)
  do J = 1, 7
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 7,extcombs, M2munu)
  do J = 1, 7
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppllll_ew_eexmmxddxa_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppllll_ew_eexmmxddxa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppllll_ew_eexmmxddxa_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(0:30-1)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(0:30-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppllll_ew_eexmmxddxa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppllll_ew_eexmmxddxa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(7)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(7)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_ppllll_ew_eexmmxddxa_1_/**/REALKIND
