
module ol_vamp_1_ppllll_nmeexmxuxd_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_nmeexmxuxd_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_nmeexmxuxd_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_momenta_decl_/**/QREALKIND, only: Q
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_nmeexmxuxd_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_nmeexmxuxd_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppllll_nmeexmxuxd_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_nmeexmxuxd_1_/**/DREALKIND, only: ntry, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(1,64)


#ifndef PRECISION_dp
  if (ntry==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntry==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,6,9,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,4))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(1),n2h32(1))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,6,9,16],[0,0,0,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(2),n2h32(2))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,9,6,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,2))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(3),n2h32(3))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,9,6,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,7))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(4),n2h32(4))
  call Hloop_QV_A(ntry,G1H32(1),wf4(:,2),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntry,G1H8(1),38,0,G2H8(1),n2h8(1))
  call Hloop_QZ_A(ntry,G1H32(2),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntry,G1H8(1),38,0,G2H8(2),n2h8(2))
  call Hloop_QW_A(ntry,G1H32(3),wf4(:,4),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntry,G1H8(1),41,0,G2H8(3),n2h8(3))
  call Hloop_QW_A(ntry,G1H32(4),wf4(:,4),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntry,G1H8(1),41,0,G2H8(4),n2h8(4))
  call ol_merge(ntry,G2H8(2),[G2H8(1)])
call Hotf_4pt_reduction(G2H8(2),RedSet_4(1),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),8)
call HG1shiftOLR(G1H8(2),16,8)
call Hotf_4pt_reduction(G2H8(3),RedSet_4(2),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
call HG1shiftOLR(G1H8(7),16,8)
call Hotf_4pt_reduction(G2H8(4),RedSet_4(2),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
call HG1shiftOLR(G1H8(12),16,8)
  call Hloop_QW_A(ntry,G1H8(1),wf4(:,4),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntry,G1H8(2),ex5(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_QW_A(ntry,G1H8(4),wf4(:,4),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(2),n2h2(2))
  call Hloop_QW_A(ntry,G1H8(5),wf4(:,4),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(3),n2h2(3))
  call Hloop_QV_A(ntry,G1H8(6),wf4(:,2),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,5))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(4),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VA_Q(ntry,G1H8(7),ex5(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,6))
  call Hloop_QV_A(ntry,G1H8(9),wf4(:,2),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,7))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(5),n2h2(5))
  call Hloop_QV_A(ntry,G1H8(10),wf4(:,2),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,8))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(6),n2h2(6))
  call Hloop_QZ_A(ntry,G1H8(11),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,7),heltab2x8(:,:,9))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(7),n2h2(7))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VA_Q(ntry,G1H8(12),ex5(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,10))
  call Hloop_QZ_A(ntry,G1H8(14),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,8),heltab2x8(:,:,11))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(8),n2h2(8))
  call Hloop_QZ_A(ntry,G1H8(15),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,9),heltab2x8(:,:,12))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(9),n2h2(9))
  call ol_merge(ntry,G2H2(7),[G2H2(4)])
  call ol_merge(ntry,G2H2(9),[G2H2(6)])
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(1),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(3),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(7),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(9),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
call G_TensorShift(G1tensor(2),16)
call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
call G_TensorShift(G1tensor(7),16)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(11)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,6,25],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(1),n2h32(5))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,6,25],[0,0,0],3,2,wf4(:,7),wf8(:,3))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(2),n2h32(6))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(30)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[41,6,16],[0,0,0],3,2,wf8(:,24),wf4(:,2))
  call Hloop_VQ_A(ntry,G0H64(1),wf8(:,24),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,7))
  call Hloop_Q_A(ntry,G0H8(1),41,0,G1H8(1),n2h8(8))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[41,6,16],[0,0,0],3,2,wf8(:,24),wf4(:,7))
  call Hloop_VQ_A(ntry,G0H64(1),wf8(:,24),G0H8(1),m3h8x8(:,2),heltab2x64(:,:,8))
  call Hloop_Q_A(ntry,G0H8(1),41,0,G1H8(2),n2h8(9))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(15)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,9,22],[0,0,0],3,2,wf4(:,4),wf8(:,7))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,9))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(3),n2h32(7))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,9,22],[0,0,0],3,2,wf4(:,4),wf8(:,9))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,10))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(4),n2h32(8))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(34)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[38,9,16],[0,0,0],3,2,wf8(:,27),wf4(:,4))
  call Hloop_VQ_A(ntry,G0H64(1),wf8(:,27),G0H8(1),m3h8x8(:,3),heltab2x64(:,:,11))
  call Hloop_Q_A(ntry,G0H8(1),38,0,G1H8(4),n2h8(10))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(36)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[38,9,16],[0,0,0],3,2,wf8(:,28),wf4(:,4))
  call Hloop_VQ_A(ntry,G0H64(1),wf8(:,28),G0H8(1),m3h8x8(:,4),heltab2x64(:,:,12))
  call Hloop_Q_A(ntry,G0H8(1),38,0,G1H8(5),n2h8(11))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(42)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,15,16],[0,0,0],3,1,wf16(:,3))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,13))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(5),n2h32(9))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(43)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,15,16],[0,0,0],3,1,wf16(:,4))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,14))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(6),n2h32(10))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(44)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,15,16],[0,0,0],3,1,wf16(:,6))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,15))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(7),n2h32(11))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(47)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,15,16],[0,0,0],3,1,wf16(:,8))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,16))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(8),n2h32(12))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(49)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,15,16],[0,0,0],3,1,wf16(:,10))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,17))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(9),n2h32(13))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,15,16],[0,0,0],3,1,wf16(:,12))
  call Hloop_VQ_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,18))
  call Hloop_Q_A(ntry,G0H32(1),32,0,G1H32(10),n2h32(14))
  call ol_merge(ntry,G1H8(5),[G1H8(4),G1H8(3)])
  call ol_merge(ntry,G1H8(1),[G1H8(8)])
  call ol_merge(ntry,G1H8(2),[G1H8(13)])
  call Hloop_QW_A(ntry,G1H8(5),wf4(:,4),G1H2(1),m3h4x2(:,10),heltab2x8(:,:,13))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(4),n2h2(10))
  call Hloop_QV_A(ntry,G1H8(1),wf4(:,2),G1H2(1),m3h4x2(:,11),heltab2x8(:,:,14))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(6),n2h2(11))
  call Hloop_QZ_A(ntry,G1H8(2),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,12),heltab2x8(:,:,15))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(1),n2h2(12))
  call Hloop_QV_A(ntry,G1H32(1),wf4(:,2),G1H8(6),m3h4x8(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntry,G1H8(6),38,0,G2H8(1),n2h8(12))
  call Hloop_QZ_A(ntry,G1H32(2),wf4(:,7),G1H8(7),ngZd,m3h4x8(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntry,G1H8(7),38,0,G2H8(2),n2h8(13))
  call Hloop_QW_A(ntry,G1H32(3),wf4(:,4),G1H8(9),m3h4x8(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntry,G1H8(9),41,0,G2H8(3),n2h8(14))
  call Hloop_QW_A(ntry,G1H32(4),wf4(:,4),G1H8(10),m3h4x8(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntry,G1H8(10),41,0,G2H8(4),n2h8(15))
  call Hloop_QW_A(ntry,G1H32(5),wf16(:,3),G1H2(1),m3h16x2(:,1),heltab2x32(:,:,9))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(3),n2h2(13))
  call Hloop_QW_A(ntry,G1H32(6),wf16(:,4),G1H2(1),m3h16x2(:,2),heltab2x32(:,:,10))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(7),n2h2(14))
  call Hloop_QW_A(ntry,G1H32(7),wf16(:,6),G1H2(1),m3h16x2(:,3),heltab2x32(:,:,11))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(9),n2h2(15))
  call Hloop_QW_A(ntry,G1H32(8),wf16(:,8),G1H2(1),m3h16x2(:,4),heltab2x32(:,:,12))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(10),n2h2(16))
  call Hloop_QW_A(ntry,G1H32(9),wf16(:,10),G1H2(1),m3h16x2(:,5),heltab2x32(:,:,13))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(11),n2h2(17))
  call Hloop_QW_A(ntry,G1H32(10),wf16(:,12),G1H2(1),m3h16x2(:,6),heltab2x32(:,:,14))
  call Hloop_Q_A(ntry,G1H2(1),47,0,G2H2(12),n2h2(18))
  call ol_merge(ntry,G2H2(12),[G2H2(11),G2H2(10),G2H2(9),G2H2(7),G2H2(3),G2H2(8),G2H2(5),G2H2(2)])
  call ol_merge(ntry,G2H2(1),[G2H2(6)])
  call ol_merge(ntry,G2H8(2),[G2H8(1)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_QW_A(ntry,G1H4(1),wf4(:,4),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,1))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(12),ex5(:),G2tensor(3),m3h2x1(:,5),heltab2x2(:,:,5))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_QV_A(ntry,G1H4(2),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,2))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(2))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_QZ_A(ntry,G1H4(3),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,3),heltab2x4(:,:,3))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(3))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(4),ex5(:),G2tensor(7),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(1),ex5(:),G2tensor(8),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_V(ntry,l_switch,G2H8(2),wf8(:,3),G2tensor(9),m3h8x1(:,1),heltab2x8(:,:,16))
  call Hcheck_last_QA_V(ntry,l_switch,G2H8(3),wf8(:,7),G2tensor(10),m3h8x1(:,2),heltab2x8(:,:,17))
  call Hcheck_last_QA_V(ntry,l_switch,G2H8(4),wf8(:,9),G2tensor(11),m3h8x1(:,3),heltab2x8(:,:,18))
  call ol_merge_tensors(G2tensor(9),[G2tensor(2),G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(10),G2tensor(4),G1tensor(10),G0tensor(10)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2),G0tensor(2)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(3),G0tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(9),G1tensor(4),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(5),G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(8),G0tensor(8)])
call TI_triangle_red(G2tensor(9),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(5),G0tensor(10),M2L1R1)
call TI_triangle_red(G2tensor(11),RedBasis(4),mass3set(:,1),G0tensor(2),G0tensor(3),G0tensor(9),G0tensor(4),M2L1R1)
call TI_triangle_red(G2tensor(1),RedBasis(6),mass3set(:,1),G0tensor(7),G0tensor(8),G0tensor(11),G0tensor(12),M2L1R1)
call TI_triangle_red(G2tensor(7),RedBasis(3),mass3set(:,1),G0tensor(13),G0tensor(14),G0tensor(15),G0tensor(16),M2L1R1)
call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,1),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20),M2L1R1)
call TI_triangle_red(G2tensor(6),RedBasis(7),mass3set(:,1),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),M2L1R1)
call TI_triangle_red(G2tensor(8),RedBasis(5),mass3set(:,1),G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),M2L1R1)
call ol_merge_tensors(T0sum(3),[G0tensor(1)])
call ol_merge_tensors(T0sum(4),[G0tensor(2)])
call ol_merge_tensors(T0sum(5),[G0tensor(7)])
call ol_merge_tensors(T0sum(6),[G0tensor(13)])
call ol_merge_tensors(T0sum(7),[G0tensor(17)])
call ol_merge_tensors(T0sum(8),[G0tensor(21)])
call ol_merge_tensors(T0sum(9),[G0tensor(25)])
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(37)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[38,25],[0,0],2,2,wf8(:,27),wf8(:,3))
  call Hloop_VQ_A(ntry,G0H64(1),wf8(:,27),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,19))
  call Hloop_Q_A(ntry,G0H8(1),38,0,G1H8(11),n2h8(16))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(38)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[38,25],[0,0],2,2,wf8(:,28),wf8(:,3))
  call Hloop_VQ_A(ntry,G0H64(1),wf8(:,28),G0H8(1),m3h8x8(:,6),heltab2x64(:,:,20))
  call Hloop_Q_A(ntry,G0H8(1),38,0,G1H8(12),n2h8(17))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(39)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[41,22],[0,0],2,2,wf8(:,24),wf8(:,7))
  call Hloop_VQ_A(ntry,G0H64(1),wf8(:,24),G0H8(1),m3h8x8(:,7),heltab2x64(:,:,21))
  call Hloop_Q_A(ntry,G0H8(1),41,0,G1H8(14),n2h8(18))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(40)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[41,22],[0,0],2,2,wf8(:,24),wf8(:,9))
  call Hloop_VQ_A(ntry,G0H64(1),wf8(:,24),G0H8(1),m3h8x8(:,8),heltab2x64(:,:,22))
  call Hloop_Q_A(ntry,G0H8(1),41,0,G1H8(15),n2h8(19))
  call ol_merge(ntry,G1H8(12),[G1H8(11)])
  call Hcheck_last_QA_V(ntry,l_switch,G1H8(12),wf8(:,3),G1tensor(1),m3h8x1(:,4),heltab2x8(:,:,19))
  call Hcheck_last_QA_V(ntry,l_switch,G1H8(14),wf8(:,7),G1tensor(6),m3h8x1(:,5),heltab2x8(:,:,20))
  call Hcheck_last_QA_V(ntry,l_switch,G1H8(15),wf8(:,9),G1tensor(5),m3h8x1(:,6),heltab2x8(:,:,21))
  call ol_merge_tensors(G0tensor(26),[G0tensor(23),G0tensor(8),G0tensor(6)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(16),G0tensor(5)])
  call ol_merge_tensors(G0tensor(20),[G0tensor(4),G0tensor(10)])
  call ol_merge_tensors(G0tensor(22),[G0tensor(14),G0tensor(11),G0tensor(3)])
  call ol_merge_tensors(G1tensor(5),[G1tensor(6),G0tensor(28),G0tensor(9)])
  call ol_merge_tensors(G0tensor(24),[G0tensor(18),G0tensor(12)])
  call ol_merge_tensors(G0tensor(27),[G0tensor(19),G0tensor(15)])
call TI_bubble_red(G1tensor(1),38,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(5),41,mass2set(:,1),G0tensor(2),M2L1R1)
call ol_merge_tensors(T0sum(10),[G0tensor(26)])
call ol_merge_tensors(T0sum(11),[G0tensor(1)])
call ol_merge_tensors(T0sum(12),[G0tensor(20)])
call ol_merge_tensors(T0sum(13),[G0tensor(22)])
call ol_merge_tensors(T0sum(14),[G0tensor(2)])
call ol_merge_tensors(T0sum(15),[G0tensor(24)])
call ol_merge_tensors(T0sum(16),[G0tensor(27)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppllll_nmeexmxuxd_1_/**/REALKIND
