
module ol_vamp_1_ppllll_eexmmxuux_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_eexmmxuux_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_eexmmxuux_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_momenta_decl_/**/QREALKIND, only: Q
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_eexmmxuux_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_eexmmxuux_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppllll_eexmmxuux_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_eexmmxuux_1_/**/DREALKIND, only: ntry, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(1,64)


#ifndef PRECISION_dp
  if (ntry==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntry==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(95)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(1),n2h32(1))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(96)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,12,3,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(2),n2h32(2))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(97)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(3),n2h32(3))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(98)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,12,3,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(4),n2h32(4))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(95)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(5),n2h32(5))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(96)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(6),n2h32(6))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(97)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,2))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(7),n2h32(7))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(98)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,3,12,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(8),n2h32(8))
  call Hloop_AV_Q(ntry,G1H32(1),wf4(:,2),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntry,G1H8(1),44,0,G2H8(1),n2h8(1))
  call Hloop_AZ_Q(ntry,G1H32(2),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntry,G1H8(1),44,0,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntry,G1H32(3),wf4(:,2),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntry,G1H8(1),44,0,G2H8(3),n2h8(3))
  call Hloop_AZ_Q(ntry,G1H32(4),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntry,G1H8(1),44,0,G2H8(4),n2h8(4))
  call Hloop_AV_Q(ntry,G1H32(5),wf4(:,1),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntry,G1H8(1),35,0,G2H8(5),n2h8(5))
  call Hloop_AV_Q(ntry,G1H32(6),wf4(:,1),G1H8(1),m3h4x8(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntry,G1H8(1),35,0,G2H8(6),n2h8(6))
  call Hloop_AZ_Q(ntry,G1H32(7),wf4(:,6),G1H8(1),ngZu,m3h4x8(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntry,G1H8(1),35,0,G2H8(7),n2h8(7))
  call Hloop_AZ_Q(ntry,G1H32(8),wf4(:,6),G1H8(1),ngZu,m3h4x8(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntry,G1H8(1),35,0,G2H8(8),n2h8(8))
  call ol_merge(ntry,G2H8(2),[G2H8(1)])
  call ol_merge(ntry,G2H8(4),[G2H8(3)])
  call ol_merge(ntry,G2H8(7),[G2H8(5)])
  call ol_merge(ntry,G2H8(8),[G2H8(6)])
call Hotf_4pt_reduction(G2H8(2),RedSet_4(1),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),8)
call HG1shiftOLR(G1H8(2),16,8)
call Hotf_4pt_reduction(G2H8(4),RedSet_4(1),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
call HG1shiftOLR(G1H8(7),16,8)
call Hotf_4pt_reduction(G2H8(7),RedSet_4(2),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
call HG1shiftOLR(G1H8(12),16,8)
call Hotf_4pt_reduction(G2H8(8),RedSet_4(2),mass4set(:,1),  & 
G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
call HG1shiftOLR(G1H8(17),16,8)
  call Hloop_AV_Q(ntry,G1H8(1),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(2),ex5(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_AV_Q(ntry,G1H8(4),wf4(:,1),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(2),n2h2(2))
  call Hloop_AV_Q(ntry,G1H8(5),wf4(:,1),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(3),n2h2(3))
  call Hloop_AZ_Q(ntry,G1H8(6),wf4(:,6),G1H2(1),ngZu,m3h4x2(:,4),heltab2x8(:,:,5))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(4),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(7),ex5(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,6))
  call Hloop_AZ_Q(ntry,G1H8(9),wf4(:,6),G1H2(1),ngZu,m3h4x2(:,5),heltab2x8(:,:,7))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(5),n2h2(5))
  call Hloop_AZ_Q(ntry,G1H8(10),wf4(:,6),G1H2(1),ngZu,m3h4x2(:,6),heltab2x8(:,:,8))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(6),n2h2(6))
  call Hloop_AV_Q(ntry,G1H8(11),wf4(:,2),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,9))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(7),n2h2(7))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(12),ex5(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,10))
  call Hloop_AV_Q(ntry,G1H8(14),wf4(:,2),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,11))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(8),n2h2(8))
  call Hloop_AV_Q(ntry,G1H8(15),wf4(:,2),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,12))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(9),n2h2(9))
  call Hloop_AZ_Q(ntry,G1H8(16),wf4(:,4),G1H2(1),ngZu,m3h4x2(:,10),heltab2x8(:,:,13))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(10),n2h2(10))
call HGT_raise_alpha_OLR(G1H8(17),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(17),ex5(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,14))
  call Hloop_AZ_Q(ntry,G1H8(19),wf4(:,4),G1H2(1),ngZu,m3h4x2(:,11),heltab2x8(:,:,15))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(11),n2h2(11))
  call Hloop_AZ_Q(ntry,G1H8(20),wf4(:,4),G1H2(1),ngZu,m3h4x2(:,12),heltab2x8(:,:,16))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(12),n2h2(12))
  call ol_merge(ntry,G2H2(4),[G2H2(1)])
  call ol_merge(ntry,G2H2(6),[G2H2(3)])
  call ol_merge(ntry,G2H2(10),[G2H2(7)])
  call ol_merge(ntry,G2H2(12),[G2H2(9)])
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(4),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(6),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(10),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(12),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
call G_TensorShift(G1tensor(2),16)
call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
call G_TensorShift(G1tensor(7),16)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(1),n2h32(9))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,12,19],[0,0,0],3,2,wf4(:,4),wf8(:,3))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(2),n2h32(10))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(10)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(3),n2h32(11))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(11)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,12,19],[0,0,0],3,2,wf4(:,4),wf8(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(4),n2h32(12))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(51)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[35,12,16],[0,0,0],3,2,wf8(:,42),wf4(:,2))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,42),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,13))
  call Hloop_A_Q(ntry,G0H8(1),35,0,G1H8(1),n2h8(13))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[35,12,16],[0,0,0],3,2,wf8(:,42),wf4(:,4))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,42),G0H8(1),m3h8x8(:,2),heltab2x64(:,:,14))
  call Hloop_A_Q(ntry,G0H8(1),35,0,G1H8(2),n2h8(14))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(54)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[35,12,16],[0,0,0],3,2,wf8(:,44),wf4(:,2))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,44),G0H8(1),m3h8x8(:,3),heltab2x64(:,:,15))
  call Hloop_A_Q(ntry,G0H8(1),35,0,G1H8(4),n2h8(15))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(55)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[35,12,16],[0,0,0],3,2,wf8(:,44),wf4(:,4))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,44),G0H8(1),m3h8x8(:,4),heltab2x64(:,:,16))
  call Hloop_A_Q(ntry,G0H8(1),35,0,G1H8(5),n2h8(16))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,9))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,17))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(5),n2h32(13))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(16)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,11))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,18))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(6),n2h32(14))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,3,28],[0,0,0],3,2,wf4(:,6),wf8(:,9))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,19))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(7),n2h32(15))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(18)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,3,28],[0,0,0],3,2,wf4(:,6),wf8(:,11))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,20))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(8),n2h32(16))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[44,3,16],[0,0,0],3,2,wf8(:,46),wf4(:,1))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,46),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,21))
  call Hloop_A_Q(ntry,G0H8(1),44,0,G1H8(6),n2h8(17))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(60)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[44,3,16],[0,0,0],3,2,wf8(:,47),wf4(:,1))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,47),G0H8(1),m3h8x8(:,6),heltab2x64(:,:,22))
  call Hloop_A_Q(ntry,G0H8(1),44,0,G1H8(7),n2h8(18))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(61)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[44,3,16],[0,0,0],3,2,wf8(:,46),wf4(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,46),G0H8(1),m3h8x8(:,7),heltab2x64(:,:,23))
  call Hloop_A_Q(ntry,G0H8(1),44,0,G1H8(9),n2h8(19))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(62)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[44,3,16],[0,0,0],3,2,wf8(:,47),wf4(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,47),G0H8(1),m3h8x8(:,8),heltab2x64(:,:,24))
  call Hloop_A_Q(ntry,G0H8(1),44,0,G1H8(10),n2h8(20))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(72)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,15,16],[0,0,0],3,1,wf16(:,1))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,25))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(9),n2h32(17))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(74)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,15,16],[0,0,0],3,1,wf16(:,3))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,26))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(10),n2h32(18))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(75)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,15,16],[0,0,0],3,1,wf16(:,4))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,27))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(11),n2h32(19))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(76)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,15,16],[0,0,0],3,1,wf16(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,28))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(12),n2h32(20))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(79)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,15,16],[0,0,0],3,1,wf16(:,7))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,29))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(13),n2h32(21))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(80)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,15,16],[0,0,0],3,1,wf16(:,9))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,30))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(14),n2h32(22))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(82)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,15,16],[0,0,0],3,1,wf16(:,10))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,31))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(15),n2h32(23))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(83)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,15,16],[0,0,0],3,1,wf16(:,12))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,32))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(16),n2h32(24))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(84)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,15,16],[0,0,0],3,1,wf16(:,13))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,33))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(17),n2h32(25))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(85)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,15,16],[0,0,0],3,1,wf16(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,34))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(18),n2h32(26))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(86)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,15,16],[0,0,0],3,1,wf16(:,16))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,35))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(19),n2h32(27))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(87)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,15,16],[0,0,0],3,1,wf16(:,18))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,36))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(20),n2h32(28))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(90)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,15,16],[0,0,0],3,1,wf16(:,19))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,37))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(21),n2h32(29))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(92)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,15,16],[0,0,0],3,1,wf16(:,20))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,38))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(22),n2h32(30))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(93)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,15,16],[0,0,0],3,1,wf16(:,22))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,39))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(23),n2h32(31))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(94)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,15,16],[0,0,0],3,1,wf16(:,24))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,40))
  call Hloop_A_Q(ntry,G0H32(1),32,0,G1H32(24),n2h32(32))
  call ol_merge(ntry,G1H8(7),[G1H8(6),G1H8(3)])
  call ol_merge(ntry,G1H8(10),[G1H8(9),G1H8(8)])
  call ol_merge(ntry,G1H8(4),[G1H8(1),G1H8(13)])
  call ol_merge(ntry,G1H8(5),[G1H8(2),G1H8(18)])
  call Hloop_AV_Q(ntry,G1H8(7),wf4(:,1),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,17))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(1),n2h2(13))
  call Hloop_AZ_Q(ntry,G1H8(10),wf4(:,6),G1H2(1),ngZu,m3h4x2(:,14),heltab2x8(:,:,18))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(3),n2h2(14))
  call Hloop_AV_Q(ntry,G1H8(4),wf4(:,2),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,19))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(7),n2h2(15))
  call Hloop_AZ_Q(ntry,G1H8(5),wf4(:,4),G1H2(1),ngZu,m3h4x2(:,16),heltab2x8(:,:,20))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(9),n2h2(16))
  call Hloop_AV_Q(ntry,G1H32(1),wf4(:,2),G1H8(11),m3h4x8(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntry,G1H8(11),44,0,G2H8(1),n2h8(21))
  call Hloop_AZ_Q(ntry,G1H32(2),wf4(:,4),G1H8(12),ngZu,m3h4x8(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntry,G1H8(12),44,0,G2H8(3),n2h8(22))
  call Hloop_AV_Q(ntry,G1H32(3),wf4(:,2),G1H8(14),m3h4x8(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntry,G1H8(14),44,0,G2H8(5),n2h8(23))
  call Hloop_AZ_Q(ntry,G1H32(4),wf4(:,4),G1H8(15),ngZu,m3h4x8(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntry,G1H8(15),44,0,G2H8(6),n2h8(24))
  call Hloop_AV_Q(ntry,G1H32(5),wf4(:,1),G1H8(16),m3h4x8(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntry,G1H8(16),35,0,G2H8(2),n2h8(25))
  call Hloop_AV_Q(ntry,G1H32(6),wf4(:,1),G1H8(17),m3h4x8(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntry,G1H8(17),35,0,G2H8(4),n2h8(26))
  call Hloop_AZ_Q(ntry,G1H32(7),wf4(:,6),G1H8(19),ngZu,m3h4x8(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntry,G1H8(19),35,0,G2H8(7),n2h8(27))
  call Hloop_AZ_Q(ntry,G1H32(8),wf4(:,6),G1H8(20),ngZu,m3h4x8(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntry,G1H8(20),35,0,G2H8(8),n2h8(28))
  call Hloop_AV_Q(ntry,G1H32(9),wf16(:,1),G1H2(1),m3h16x2(:,1),heltab2x32(:,:,17))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(4),n2h2(17))
  call Hloop_AZ_Q(ntry,G1H32(10),wf16(:,3),G1H2(1),ngZu,m3h16x2(:,2),heltab2x32(:,:,18))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(6),n2h2(18))
  call Hloop_AV_Q(ntry,G1H32(11),wf16(:,4),G1H2(1),m3h16x2(:,3),heltab2x32(:,:,19))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(10),n2h2(19))
  call Hloop_AZ_Q(ntry,G1H32(12),wf16(:,6),G1H2(1),ngZu,m3h16x2(:,4),heltab2x32(:,:,20))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(12),n2h2(20))
  call Hloop_AV_Q(ntry,G1H32(13),wf16(:,7),G1H2(1),m3h16x2(:,5),heltab2x32(:,:,21))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(13),n2h2(21))
  call Hloop_AZ_Q(ntry,G1H32(14),wf16(:,9),G1H2(1),ngZu,m3h16x2(:,6),heltab2x32(:,:,22))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(14),n2h2(22))
  call Hloop_AV_Q(ntry,G1H32(15),wf16(:,10),G1H2(1),m3h16x2(:,7),heltab2x32(:,:,23))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(15),n2h2(23))
  call Hloop_AZ_Q(ntry,G1H32(16),wf16(:,12),G1H2(1),ngZu,m3h16x2(:,8),heltab2x32(:,:,24))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(16),n2h2(24))
  call Hloop_AV_Q(ntry,G1H32(17),wf16(:,13),G1H2(1),m3h16x2(:,9),heltab2x32(:,:,25))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(17),n2h2(25))
  call Hloop_AZ_Q(ntry,G1H32(18),wf16(:,15),G1H2(1),ngZu,m3h16x2(:,10),heltab2x32(:,:,26))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(18),n2h2(26))
  call Hloop_AV_Q(ntry,G1H32(19),wf16(:,16),G1H2(1),m3h16x2(:,11),heltab2x32(:,:,27))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(19),n2h2(27))
  call Hloop_AZ_Q(ntry,G1H32(20),wf16(:,18),G1H2(1),ngZu,m3h16x2(:,12),heltab2x32(:,:,28))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(20),n2h2(28))
  call Hloop_AV_Q(ntry,G1H32(21),wf16(:,19),G1H2(1),m3h16x2(:,13),heltab2x32(:,:,29))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(21),n2h2(29))
  call Hloop_AV_Q(ntry,G1H32(22),wf16(:,20),G1H2(1),m3h16x2(:,14),heltab2x32(:,:,30))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(22),n2h2(30))
  call Hloop_AZ_Q(ntry,G1H32(23),wf16(:,22),G1H2(1),ngZu,m3h16x2(:,15),heltab2x32(:,:,31))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(23),n2h2(31))
  call Hloop_AZ_Q(ntry,G1H32(24),wf16(:,24),G1H2(1),ngZu,m3h16x2(:,16),heltab2x32(:,:,32))
  call Hloop_A_Q(ntry,G1H2(1),47,0,G2H2(24),n2h2(32))
  call ol_merge(ntry,G2H2(24),[G2H2(23),G2H2(22),G2H2(21),G2H2(20),G2H2(19),G2H2(18),G2H2(17),G2H2(16),G2H2(15),G2H2(14),G2H2(13) &
    ,G2H2(12),G2H2(10),G2H2(6),G2H2(4),G2H2(11),G2H2(8),G2H2(5),G2H2(2)])
  call ol_merge(ntry,G2H2(3),[G2H2(1)])
  call ol_merge(ntry,G2H2(9),[G2H2(7)])
  call ol_merge(ntry,G2H8(3),[G2H8(1)])
  call ol_merge(ntry,G2H8(6),[G2H8(5)])
  call ol_merge(ntry,G2H8(7),[G2H8(2)])
  call ol_merge(ntry,G2H8(8),[G2H8(4)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_AV_Q(ntry,G1H4(1),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,1))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(24),ex5(:),G2tensor(3),m3h2x1(:,5),heltab2x2(:,:,5))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_AZ_Q(ntry,G1H4(2),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,2),heltab2x4(:,:,2))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(2))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_AV_Q(ntry,G1H4(3),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,3))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(3))
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_AZ_Q(ntry,G1H4(4),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,4),heltab2x4(:,:,4))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(4))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(3),ex5(:),G2tensor(8),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(9),ex5(:),G2tensor(9),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(3),wf8(:,3),G2tensor(10),m3h8x1(:,1),heltab2x8(:,:,21))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(6),wf8(:,6),G2tensor(11),m3h8x1(:,2),heltab2x8(:,:,22))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(7),wf8(:,9),G2tensor(12),m3h8x1(:,3),heltab2x8(:,:,23))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(8),wf8(:,11),G2tensor(13),m3h8x1(:,4),heltab2x8(:,:,24))
  call ol_merge_tensors(G2tensor(11),[G2tensor(10),G2tensor(2),G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(12),G2tensor(4),G1tensor(10),G0tensor(10)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(1),G1tensor(2),G0tensor(2)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(3),G0tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(9),G1tensor(4),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(6),G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(8),G0tensor(8)])
call TI_triangle_red(G2tensor(11),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(5),G0tensor(10),M2L1R1)
call TI_triangle_red(G2tensor(13),RedBasis(4),mass3set(:,1),G0tensor(2),G0tensor(3),G0tensor(9),G0tensor(4),M2L1R1)
call TI_triangle_red(G2tensor(5),RedBasis(6),mass3set(:,1),G0tensor(7),G0tensor(8),G0tensor(11),G0tensor(12),M2L1R1)
call TI_triangle_red(G2tensor(8),RedBasis(3),mass3set(:,1),G0tensor(13),G0tensor(14),G0tensor(15),G0tensor(16),M2L1R1)
call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,1),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20),M2L1R1)
call TI_triangle_red(G2tensor(7),RedBasis(7),mass3set(:,1),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),M2L1R1)
call TI_triangle_red(G2tensor(9),RedBasis(5),mass3set(:,1),G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),M2L1R1)
call ol_merge_tensors(T0sum(3),[G0tensor(1)])
call ol_merge_tensors(T0sum(4),[G0tensor(2)])
call ol_merge_tensors(T0sum(5),[G0tensor(7)])
call ol_merge_tensors(T0sum(6),[G0tensor(13)])
call ol_merge_tensors(T0sum(7),[G0tensor(17)])
call ol_merge_tensors(T0sum(8),[G0tensor(21)])
call ol_merge_tensors(T0sum(9),[G0tensor(25)])
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[44,19],[0,0],2,2,wf8(:,46),wf8(:,3))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,46),G0H8(1),m3h8x8(:,9),heltab2x64(:,:,41))
  call Hloop_A_Q(ntry,G0H8(1),44,0,G1H8(6),n2h8(29))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(64)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[44,19],[0,0],2,2,wf8(:,47),wf8(:,3))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,47),G0H8(1),m3h8x8(:,10),heltab2x64(:,:,42))
  call Hloop_A_Q(ntry,G0H8(1),44,0,G1H8(3),n2h8(30))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(65)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[44,19],[0,0],2,2,wf8(:,46),wf8(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,46),G0H8(1),m3h8x8(:,11),heltab2x64(:,:,43))
  call Hloop_A_Q(ntry,G0H8(1),44,0,G1H8(9),n2h8(31))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(66)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[44,19],[0,0],2,2,wf8(:,47),wf8(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,47),G0H8(1),m3h8x8(:,12),heltab2x64(:,:,44))
  call Hloop_A_Q(ntry,G0H8(1),44,0,G1H8(8),n2h8(32))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(67)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[35,28],[0,0],2,2,wf8(:,42),wf8(:,9))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,42),G0H8(1),m3h8x8(:,13),heltab2x64(:,:,45))
  call Hloop_A_Q(ntry,G0H8(1),35,0,G1H8(1),n2h8(33))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(68)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[35,28],[0,0],2,2,wf8(:,42),wf8(:,11))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,42),G0H8(1),m3h8x8(:,14),heltab2x64(:,:,46))
  call Hloop_A_Q(ntry,G0H8(1),35,0,G1H8(13),n2h8(34))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(69)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[35,28],[0,0],2,2,wf8(:,44),wf8(:,9))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,44),G0H8(1),m3h8x8(:,15),heltab2x64(:,:,47))
  call Hloop_A_Q(ntry,G0H8(1),35,0,G1H8(2),n2h8(35))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(70)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[35,28],[0,0],2,2,wf8(:,44),wf8(:,11))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,44),G0H8(1),m3h8x8(:,16),heltab2x64(:,:,48))
  call Hloop_A_Q(ntry,G0H8(1),35,0,G1H8(18),n2h8(36))
  call ol_merge(ntry,G1H8(3),[G1H8(6)])
  call ol_merge(ntry,G1H8(8),[G1H8(9)])
  call ol_merge(ntry,G1H8(2),[G1H8(1)])
  call ol_merge(ntry,G1H8(18),[G1H8(13)])
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(3),wf8(:,3),G1tensor(1),m3h8x1(:,5),heltab2x8(:,:,25))
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(8),wf8(:,6),G1tensor(6),m3h8x1(:,6),heltab2x8(:,:,26))
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(2),wf8(:,9),G1tensor(5),m3h8x1(:,7),heltab2x8(:,:,27))
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(18),wf8(:,11),G1tensor(10),m3h8x1(:,8),heltab2x8(:,:,28))
  call ol_merge_tensors(G0tensor(26),[G0tensor(23),G0tensor(8),G0tensor(6)])
  call ol_merge_tensors(G1tensor(6),[G1tensor(1),G0tensor(16),G0tensor(5)])
  call ol_merge_tensors(G0tensor(20),[G0tensor(4),G0tensor(10)])
  call ol_merge_tensors(G0tensor(22),[G0tensor(14),G0tensor(11),G0tensor(3)])
  call ol_merge_tensors(G1tensor(10),[G1tensor(5),G0tensor(28),G0tensor(9)])
  call ol_merge_tensors(G0tensor(24),[G0tensor(18),G0tensor(12)])
  call ol_merge_tensors(G0tensor(27),[G0tensor(19),G0tensor(15)])
call TI_bubble_red(G1tensor(6),44,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(10),35,mass2set(:,1),G0tensor(2),M2L1R1)
call ol_merge_tensors(T0sum(10),[G0tensor(26)])
call ol_merge_tensors(T0sum(11),[G0tensor(1)])
call ol_merge_tensors(T0sum(12),[G0tensor(20)])
call ol_merge_tensors(T0sum(13),[G0tensor(22)])
call ol_merge_tensors(T0sum(14),[G0tensor(2)])
call ol_merge_tensors(T0sum(15),[G0tensor(24)])
call ol_merge_tensors(T0sum(16),[G0tensor(27)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppllll_eexmmxuux_1_/**/REALKIND
