
module ol_vamp_1_ppllll_eeexexbbx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll_eeexexbbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll_eeexexbbx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_momenta_decl_/**/QREALKIND, only: Q
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllll_eeexexbbx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllll_eeexexbbx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppllll_eeexexbbx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllll_eeexexbbx_1_/**/DREALKIND, only: ntry, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(1,64)


#ifndef PRECISION_dp
  if (ntry==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntry==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(183)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,10,5,16],[nMB,nMB,nMB,0],4,2,wf4(:,7),wf4(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(1),n2h32(1))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(184)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,10,5,16],[nMB,nMB,nMB,0],4,2,wf4(:,5),wf4(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(2),n2h32(2))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,10,5,16],[nMB,nMB,nMB,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(3),n2h32(3))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,10,5,16],[nMB,nMB,nMB,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(4),n2h32(4))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(183)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,5,10,16],[nMB,nMB,nMB,0],4,2,wf4(:,6),wf4(:,7))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(5),n2h32(5))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(184)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,5,10,16],[nMB,nMB,nMB,0],4,2,wf4(:,6),wf4(:,5))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(6),n2h32(6))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,5,10,16],[nMB,nMB,nMB,0],4,2,wf4(:,4),wf4(:,7))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(7),n2h32(7))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,5,10,16],[nMB,nMB,nMB,0],4,2,wf4(:,4),wf4(:,5))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(8),n2h32(8))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(186)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,6,9,16],[nMB,nMB,nMB,0],4,2,wf4(:,16),wf4(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(9),n2h32(9))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(187)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,6,9,16],[nMB,nMB,nMB,0],4,2,wf4(:,14),wf4(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(10),n2h32(10))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(188)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,6,9,16],[nMB,nMB,nMB,0],4,2,wf4(:,16),wf4(:,13))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(11),n2h32(11))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(40)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,6,9,16],[nMB,nMB,nMB,0],4,2,wf4(:,14),wf4(:,13))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(12),n2h32(12))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(186)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,9,6,16],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf4(:,16))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(13),n2h32(13))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(187)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,9,6,16],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf4(:,14))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(14),n2h32(14))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(188)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,9,6,16],[nMB,nMB,nMB,0],4,2,wf4(:,13),wf4(:,16))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(15),n2h32(15))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(40)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,9,6,16],[nMB,nMB,nMB,0],4,2,wf4(:,13),wf4(:,14))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(16),n2h32(16))
  call Hloop_AV_Q(ntry,G1H32(1),wf4(:,7),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntry,G1H8(1),42,nMB,G2H8(1),n2h8(1))
  call Hloop_AZ_Q(ntry,G1H32(2),wf4(:,5),G1H8(1),ngZd,m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntry,G1H8(1),42,nMB,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntry,G1H32(3),wf4(:,7),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntry,G1H8(1),42,nMB,G2H8(3),n2h8(3))
  call Hloop_AZ_Q(ntry,G1H32(4),wf4(:,5),G1H8(1),ngZd,m3h4x8(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntry,G1H8(1),42,nMB,G2H8(4),n2h8(4))
  call Hloop_AV_Q(ntry,G1H32(5),wf4(:,6),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntry,G1H8(1),37,nMB,G2H8(5),n2h8(5))
  call Hloop_AV_Q(ntry,G1H32(6),wf4(:,6),G1H8(1),m3h4x8(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntry,G1H8(1),37,nMB,G2H8(6),n2h8(6))
  call Hloop_AZ_Q(ntry,G1H32(7),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntry,G1H8(1),37,nMB,G2H8(7),n2h8(7))
  call Hloop_AZ_Q(ntry,G1H32(8),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntry,G1H8(1),37,nMB,G2H8(8),n2h8(8))
  call Hloop_AV_Q(ntry,G1H32(9),wf4(:,16),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntry,G1H8(1),38,nMB,G2H8(9),n2h8(9))
  call Hloop_AZ_Q(ntry,G1H32(10),wf4(:,14),G1H8(1),ngZd,m3h4x8(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntry,G1H8(1),38,nMB,G2H8(10),n2h8(10))
  call Hloop_AV_Q(ntry,G1H32(11),wf4(:,16),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntry,G1H8(1),38,nMB,G2H8(11),n2h8(11))
  call Hloop_AZ_Q(ntry,G1H32(12),wf4(:,14),G1H8(1),ngZd,m3h4x8(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntry,G1H8(1),38,nMB,G2H8(12),n2h8(12))
  call Hloop_AV_Q(ntry,G1H32(13),wf4(:,15),G1H8(1),m3h4x8(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntry,G1H8(1),41,nMB,G2H8(13),n2h8(13))
  call Hloop_AV_Q(ntry,G1H32(14),wf4(:,15),G1H8(1),m3h4x8(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntry,G1H8(1),41,nMB,G2H8(14),n2h8(14))
  call Hloop_AZ_Q(ntry,G1H32(15),wf4(:,13),G1H8(1),ngZd,m3h4x8(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntry,G1H8(1),41,nMB,G2H8(15),n2h8(15))
  call Hloop_AZ_Q(ntry,G1H32(16),wf4(:,13),G1H8(1),ngZd,m3h4x8(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntry,G1H8(1),41,nMB,G2H8(16),n2h8(16))
  call ol_merge(ntry,G2H8(2),[G2H8(1)])
  call ol_merge(ntry,G2H8(4),[G2H8(3)])
  call ol_merge(ntry,G2H8(7),[G2H8(5)])
  call ol_merge(ntry,G2H8(8),[G2H8(6)])
  call ol_merge(ntry,G2H8(10),[G2H8(9)])
  call ol_merge(ntry,G2H8(12),[G2H8(11)])
  call ol_merge(ntry,G2H8(15),[G2H8(13)])
  call ol_merge(ntry,G2H8(16),[G2H8(14)])
call Hotf_4pt_reduction(G2H8(2),RedSet_4(1),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),8)
call HG1shiftOLR(G1H8(2),16,8)
call Hotf_4pt_reduction(G2H8(4),RedSet_4(1),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
call HG1shiftOLR(G1H8(7),16,8)
call Hotf_4pt_reduction(G2H8(7),RedSet_4(2),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
call HG1shiftOLR(G1H8(12),16,8)
call Hotf_4pt_reduction(G2H8(8),RedSet_4(2),mass4set(:,1),  & 
G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
call HG1shiftOLR(G1H8(17),16,8)
call Hotf_4pt_reduction(G2H8(10),RedSet_4(3),mass4set(:,1),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),8)
call HG1shiftOLR(G1H8(22),16,8)
call Hotf_4pt_reduction(G2H8(12),RedSet_4(3),mass4set(:,1),  & 
G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
call HG1shiftOLR(G1H8(27),16,8)
call Hotf_4pt_reduction(G2H8(15),RedSet_4(4),mass4set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),8)
call HG1shiftOLR(G1H8(32),16,8)
call Hotf_4pt_reduction(G2H8(16),RedSet_4(4),mass4set(:,1),  & 
G1H8(36),G1H8(37),G1H8(38),G1H8(39),G1H8(40),8)
call HG1shiftOLR(G1H8(37),16,8)
  call Hloop_AV_Q(ntry,G1H8(1),wf4(:,6),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(2),ex5(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_AV_Q(ntry,G1H8(4),wf4(:,6),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(2),n2h2(2))
  call Hloop_AV_Q(ntry,G1H8(5),wf4(:,6),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(3),n2h2(3))
  call Hloop_AZ_Q(ntry,G1H8(6),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,4),heltab2x8(:,:,5))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(4),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(7),ex5(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,6))
  call Hloop_AZ_Q(ntry,G1H8(9),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,5),heltab2x8(:,:,7))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(5),n2h2(5))
  call Hloop_AZ_Q(ntry,G1H8(10),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,6),heltab2x8(:,:,8))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(6),n2h2(6))
  call Hloop_AV_Q(ntry,G1H8(11),wf4(:,7),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,9))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(7),n2h2(7))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(12),ex5(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,10))
  call Hloop_AV_Q(ntry,G1H8(14),wf4(:,7),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,11))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(8),n2h2(8))
  call Hloop_AV_Q(ntry,G1H8(15),wf4(:,7),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,12))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(9),n2h2(9))
  call Hloop_AZ_Q(ntry,G1H8(16),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,10),heltab2x8(:,:,13))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(10),n2h2(10))
call HGT_raise_alpha_OLR(G1H8(17),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(17),ex5(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,14))
  call Hloop_AZ_Q(ntry,G1H8(19),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,11),heltab2x8(:,:,15))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(11),n2h2(11))
  call Hloop_AZ_Q(ntry,G1H8(20),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,12),heltab2x8(:,:,16))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(12),n2h2(12))
  call Hloop_AV_Q(ntry,G1H8(21),wf4(:,15),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,17))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(13),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(22),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(22),ex5(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,18))
  call Hloop_AV_Q(ntry,G1H8(24),wf4(:,15),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,19))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(14),n2h2(14))
  call Hloop_AV_Q(ntry,G1H8(25),wf4(:,15),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,20))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(15),n2h2(15))
  call Hloop_AZ_Q(ntry,G1H8(26),wf4(:,13),G1H2(1),ngZd,m3h4x2(:,16),heltab2x8(:,:,21))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(16),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(27),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(27),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(27),ex5(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,22))
  call Hloop_AZ_Q(ntry,G1H8(29),wf4(:,13),G1H2(1),ngZd,m3h4x2(:,17),heltab2x8(:,:,23))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(17),n2h2(17))
  call Hloop_AZ_Q(ntry,G1H8(30),wf4(:,13),G1H2(1),ngZd,m3h4x2(:,18),heltab2x8(:,:,24))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(18),n2h2(18))
  call Hloop_AV_Q(ntry,G1H8(31),wf4(:,16),G1H2(1),m3h4x2(:,19),heltab2x8(:,:,25))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(19),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(32),ex5(:),G1H4(7),m3h2x4(:,7),heltab2x8(:,:,26))
  call Hloop_AV_Q(ntry,G1H8(34),wf4(:,16),G1H2(1),m3h4x2(:,20),heltab2x8(:,:,27))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(20),n2h2(20))
  call Hloop_AV_Q(ntry,G1H8(35),wf4(:,16),G1H2(1),m3h4x2(:,21),heltab2x8(:,:,28))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(21),n2h2(21))
  call Hloop_AZ_Q(ntry,G1H8(36),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,22),heltab2x8(:,:,29))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(22),n2h2(22))
call HGT_raise_alpha_OLR(G1H8(37),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(37),ex5(:),G1H4(8),m3h2x4(:,8),heltab2x8(:,:,30))
  call Hloop_AZ_Q(ntry,G1H8(39),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,23),heltab2x8(:,:,31))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(23),n2h2(23))
  call Hloop_AZ_Q(ntry,G1H8(40),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,24),heltab2x8(:,:,32))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(24),n2h2(24))
  call ol_merge(ntry,G2H2(4),[G2H2(1)])
  call ol_merge(ntry,G2H2(6),[G2H2(3)])
  call ol_merge(ntry,G2H2(10),[G2H2(7)])
  call ol_merge(ntry,G2H2(12),[G2H2(9)])
  call ol_merge(ntry,G2H2(16),[G2H2(13)])
  call ol_merge(ntry,G2H2(18),[G2H2(15)])
  call ol_merge(ntry,G2H2(22),[G2H2(19)])
  call ol_merge(ntry,G2H2(24),[G2H2(21)])
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(4),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(6),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(10),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(12),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(16),ex5(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(18),ex5(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(22),ex5(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(24),ex5(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
call G_TensorShift(G1tensor(2),16)
call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
call G_TensorShift(G1tensor(7),16)
call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(3),mass4set(:,1),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
call G_TensorShift(G1tensor(12),16)
call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(4),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
call G_TensorShift(G1tensor(17),16)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(4),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
call ol_merge_tensors(T0sum(4),[G0tensor(16)])
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,10,21],[nMB,nMB,0],3,2,wf4(:,7),wf8(:,3))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(1),n2h32(17))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(11)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,10,21],[nMB,nMB,0],3,2,wf4(:,5),wf8(:,3))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(2),n2h32(18))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,10,21],[nMB,nMB,0],3,2,wf4(:,7),wf8(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(3),n2h32(19))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(14)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,10,21],[nMB,nMB,0],3,2,wf4(:,5),wf8(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(4),n2h32(20))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(94)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[37,10,16],[nMB,nMB,0],3,2,wf8(:,66),wf4(:,7))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,66),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,21))
  call Hloop_A_Q(ntry,G0H8(1),37,nMB,G1H8(1),n2h8(25))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(95)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[37,10,16],[nMB,nMB,0],3,2,wf8(:,66),wf4(:,5))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,66),G0H8(1),m3h8x8(:,2),heltab2x64(:,:,22))
  call Hloop_A_Q(ntry,G0H8(1),37,nMB,G1H8(2),n2h8(26))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(97)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[37,10,16],[nMB,nMB,0],3,2,wf8(:,68),wf4(:,7))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,68),G0H8(1),m3h8x8(:,3),heltab2x64(:,:,23))
  call Hloop_A_Q(ntry,G0H8(1),37,nMB,G1H8(4),n2h8(27))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(98)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[37,10,16],[nMB,nMB,0],3,2,wf8(:,68),wf4(:,5))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,68),G0H8(1),m3h8x8(:,4),heltab2x64(:,:,24))
  call Hloop_A_Q(ntry,G0H8(1),37,nMB,G1H8(5),n2h8(28))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,5,26],[nMB,nMB,0],3,2,wf4(:,6),wf8(:,9))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,25))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(5),n2h32(21))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(19)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,5,26],[nMB,nMB,0],3,2,wf4(:,6),wf8(:,11))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,26))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(6),n2h32(22))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(20)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,5,26],[nMB,nMB,0],3,2,wf4(:,4),wf8(:,9))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,27))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(7),n2h32(23))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(21)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,5,26],[nMB,nMB,0],3,2,wf4(:,4),wf8(:,11))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,28))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(8),n2h32(24))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(101)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[42,5,16],[nMB,nMB,0],3,2,wf8(:,70),wf4(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,70),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,29))
  call Hloop_A_Q(ntry,G0H8(1),42,nMB,G1H8(6),n2h8(29))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(103)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[42,5,16],[nMB,nMB,0],3,2,wf8(:,71),wf4(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,71),G0H8(1),m3h8x8(:,6),heltab2x64(:,:,30))
  call Hloop_A_Q(ntry,G0H8(1),42,nMB,G1H8(7),n2h8(30))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(104)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[42,5,16],[nMB,nMB,0],3,2,wf8(:,70),wf4(:,4))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,70),G0H8(1),m3h8x8(:,7),heltab2x64(:,:,31))
  call Hloop_A_Q(ntry,G0H8(1),42,nMB,G1H8(9),n2h8(31))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(105)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[42,5,16],[nMB,nMB,0],3,2,wf8(:,71),wf4(:,4))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,71),G0H8(1),m3h8x8(:,8),heltab2x64(:,:,32))
  call Hloop_A_Q(ntry,G0H8(1),42,nMB,G1H8(10),n2h8(32))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(137)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,15,16],[nMB,nMB,0],3,1,wf16(:,1))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,33))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(9),n2h32(25))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(139)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,15,16],[nMB,nMB,0],3,1,wf16(:,3))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,34))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(10),n2h32(26))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(141)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,15,16],[nMB,nMB,0],3,1,wf16(:,5))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,35))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(11),n2h32(27))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(142)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,15,16],[nMB,nMB,0],3,1,wf16(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,36))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(12),n2h32(28))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(143)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,15,16],[nMB,nMB,0],3,1,wf16(:,8))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,37))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(13),n2h32(29))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(146)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,15,16],[nMB,nMB,0],3,1,wf16(:,9))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,38))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(14),n2h32(30))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(147)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,15,16],[nMB,nMB,0],3,1,wf16(:,11))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,39))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(15),n2h32(31))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(149)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,15,16],[nMB,nMB,0],3,1,wf16(:,12))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,40))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(16),n2h32(32))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(150)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,15,16],[nMB,nMB,0],3,1,wf16(:,14))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,41))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(17),n2h32(33))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,6,25],[nMB,nMB,0],3,2,wf4(:,16),wf8(:,27))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,42))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(18),n2h32(34))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(47)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,6,25],[nMB,nMB,0],3,2,wf4(:,14),wf8(:,27))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,43))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(19),n2h32(35))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(49)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,6,25],[nMB,nMB,0],3,2,wf4(:,16),wf8(:,30))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,44))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(20),n2h32(36))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,6,25],[nMB,nMB,0],3,2,wf4(:,14),wf8(:,30))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,45))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(21),n2h32(37))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(108)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[41,6,16],[nMB,nMB,0],3,2,wf8(:,84),wf4(:,16))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,84),G0H8(1),m3h8x8(:,9),heltab2x64(:,:,46))
  call Hloop_A_Q(ntry,G0H8(1),41,nMB,G1H8(11),n2h8(33))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(109)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[41,6,16],[nMB,nMB,0],3,2,wf8(:,84),wf4(:,14))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,84),G0H8(1),m3h8x8(:,10),heltab2x64(:,:,47))
  call Hloop_A_Q(ntry,G0H8(1),41,nMB,G1H8(12),n2h8(34))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(111)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[41,6,16],[nMB,nMB,0],3,2,wf8(:,86),wf4(:,16))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,86),G0H8(1),m3h8x8(:,11),heltab2x64(:,:,48))
  call Hloop_A_Q(ntry,G0H8(1),41,nMB,G1H8(14),n2h8(35))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(112)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[41,6,16],[nMB,nMB,0],3,2,wf8(:,86),wf4(:,14))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,86),G0H8(1),m3h8x8(:,12),heltab2x64(:,:,49))
  call Hloop_A_Q(ntry,G0H8(1),41,nMB,G1H8(15),n2h8(36))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(53)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,9,22],[nMB,nMB,0],3,2,wf4(:,15),wf8(:,33))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,38),heltab2x64(:,:,50))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(22),n2h32(38))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(55)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,9,22],[nMB,nMB,0],3,2,wf4(:,15),wf8(:,35))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,51))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(23),n2h32(39))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(56)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,9,22],[nMB,nMB,0],3,2,wf4(:,13),wf8(:,33))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,40),heltab2x64(:,:,52))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(24),n2h32(40))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(57)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,9,22],[nMB,nMB,0],3,2,wf4(:,13),wf8(:,35))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,53))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(25),n2h32(41))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(115)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[38,9,16],[nMB,nMB,0],3,2,wf8(:,88),wf4(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,88),G0H8(1),m3h8x8(:,13),heltab2x64(:,:,54))
  call Hloop_A_Q(ntry,G0H8(1),38,nMB,G1H8(16),n2h8(37))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(117)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[38,9,16],[nMB,nMB,0],3,2,wf8(:,89),wf4(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,89),G0H8(1),m3h8x8(:,14),heltab2x64(:,:,55))
  call Hloop_A_Q(ntry,G0H8(1),38,nMB,G1H8(17),n2h8(38))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(118)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[38,9,16],[nMB,nMB,0],3,2,wf8(:,88),wf4(:,13))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,88),G0H8(1),m3h8x8(:,15),heltab2x64(:,:,56))
  call Hloop_A_Q(ntry,G0H8(1),38,nMB,G1H8(19),n2h8(39))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(119)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[38,9,16],[nMB,nMB,0],3,2,wf8(:,89),wf4(:,13))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,89),G0H8(1),m3h8x8(:,16),heltab2x64(:,:,57))
  call Hloop_A_Q(ntry,G0H8(1),38,nMB,G1H8(20),n2h8(40))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(151)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,15,16],[nMB,nMB,0],3,1,wf16(:,2))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,58))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(26),n2h32(42))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(152)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,15,16],[nMB,nMB,0],3,1,wf16(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,59))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(27),n2h32(43))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(153)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,15,16],[nMB,nMB,0],3,1,wf16(:,17))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,60))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(28),n2h32(44))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(154)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,15,16],[nMB,nMB,0],3,1,wf16(:,18))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,61))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(29),n2h32(45))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(155)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,15,16],[nMB,nMB,0],3,1,wf16(:,20))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,46),heltab2x64(:,:,62))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(30),n2h32(46))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(158)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,15,16],[nMB,nMB,0],3,1,wf16(:,21))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,63))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(31),n2h32(47))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(160)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,15,16],[nMB,nMB,0],3,1,wf16(:,22))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,64))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(32),n2h32(48))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(161)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,15,16],[nMB,nMB,0],3,1,wf16(:,24))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,65))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(33),n2h32(49))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(162)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,15,16],[nMB,nMB,0],3,1,wf16(:,26))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,66))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(34),n2h32(50))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(163)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,15,16],[nMB,nMB,0],3,1,wf16(:,27))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,67))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(35),n2h32(51))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(164)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,15,16],[nMB,nMB,0],3,1,wf16(:,29))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,68))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(36),n2h32(52))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(165)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,15,16],[nMB,nMB,0],3,1,wf16(:,30))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,69))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(37),n2h32(53))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(166)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,15,16],[nMB,nMB,0],3,1,wf16(:,32))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,54),heltab2x64(:,:,70))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(38),n2h32(54))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(168)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,15,16],[nMB,nMB,0],3,1,wf16(:,33))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,71))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(39),n2h32(55))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(169)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,15,16],[nMB,nMB,0],3,1,wf16(:,35))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,72))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(40),n2h32(56))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(171)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,15,16],[nMB,nMB,0],3,1,wf16(:,36))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,73))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(41),n2h32(57))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(172)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,15,16],[nMB,nMB,0],3,1,wf16(:,38))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,74))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(42),n2h32(58))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(173)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,15,16],[nMB,nMB,0],3,1,wf16(:,39))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,75))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(43),n2h32(59))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(174)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,15,16],[nMB,nMB,0],3,1,wf16(:,41))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,60),heltab2x64(:,:,76))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(44),n2h32(60))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(175)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,15,16],[nMB,nMB,0],3,1,wf16(:,42))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,61),heltab2x64(:,:,77))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(45),n2h32(61))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(176)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,15,16],[nMB,nMB,0],3,1,wf16(:,44))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,78))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(46),n2h32(62))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(178)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,15,16],[nMB,nMB,0],3,1,wf16(:,45))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,63),heltab2x64(:,:,79))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(47),n2h32(63))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(180)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,15,16],[nMB,nMB,0],3,1,wf16(:,46))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,64),heltab2x64(:,:,80))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(48),n2h32(64))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(181)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,15,16],[nMB,nMB,0],3,1,wf16(:,48))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,81))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(49),n2h32(65))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(182)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,15,16],[nMB,nMB,0],3,1,wf16(:,50))
  call Hloop_VA_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,66),heltab2x64(:,:,82))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(50),n2h32(66))
  call ol_merge(ntry,G1H8(7),[G1H8(6),G1H8(3)])
  call ol_merge(ntry,G1H8(10),[G1H8(9),G1H8(8)])
  call ol_merge(ntry,G1H8(4),[G1H8(1),G1H8(13)])
  call ol_merge(ntry,G1H8(5),[G1H8(2),G1H8(18)])
  call ol_merge(ntry,G1H8(17),[G1H8(16),G1H8(23)])
  call ol_merge(ntry,G1H8(20),[G1H8(19),G1H8(28)])
  call ol_merge(ntry,G1H8(14),[G1H8(11),G1H8(33)])
  call ol_merge(ntry,G1H8(15),[G1H8(12),G1H8(38)])
  call Hloop_AV_Q(ntry,G1H8(7),wf4(:,6),G1H2(1),m3h4x2(:,25),heltab2x8(:,:,33))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(1),n2h2(25))
  call Hloop_AZ_Q(ntry,G1H8(10),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,26),heltab2x8(:,:,34))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(3),n2h2(26))
  call Hloop_AV_Q(ntry,G1H8(4),wf4(:,7),G1H2(1),m3h4x2(:,27),heltab2x8(:,:,35))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(7),n2h2(27))
  call Hloop_AZ_Q(ntry,G1H8(5),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,28),heltab2x8(:,:,36))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(9),n2h2(28))
  call Hloop_AV_Q(ntry,G1H8(17),wf4(:,15),G1H2(1),m3h4x2(:,29),heltab2x8(:,:,37))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(13),n2h2(29))
  call Hloop_AZ_Q(ntry,G1H8(20),wf4(:,13),G1H2(1),ngZd,m3h4x2(:,30),heltab2x8(:,:,38))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(15),n2h2(30))
  call Hloop_AV_Q(ntry,G1H8(14),wf4(:,16),G1H2(1),m3h4x2(:,31),heltab2x8(:,:,39))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(19),n2h2(31))
  call Hloop_AZ_Q(ntry,G1H8(15),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,32),heltab2x8(:,:,40))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(21),n2h2(32))
  call Hloop_AV_Q(ntry,G1H32(1),wf4(:,7),G1H8(21),m3h4x8(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntry,G1H8(21),42,nMB,G2H8(1),n2h8(41))
  call Hloop_AZ_Q(ntry,G1H32(2),wf4(:,5),G1H8(22),ngZd,m3h4x8(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntry,G1H8(22),42,nMB,G2H8(3),n2h8(42))
  call Hloop_AV_Q(ntry,G1H32(3),wf4(:,7),G1H8(24),m3h4x8(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntry,G1H8(24),42,nMB,G2H8(5),n2h8(43))
  call Hloop_AZ_Q(ntry,G1H32(4),wf4(:,5),G1H8(25),ngZd,m3h4x8(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntry,G1H8(25),42,nMB,G2H8(6),n2h8(44))
  call Hloop_AV_Q(ntry,G1H32(5),wf4(:,6),G1H8(26),m3h4x8(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntry,G1H8(26),37,nMB,G2H8(9),n2h8(45))
  call Hloop_AV_Q(ntry,G1H32(6),wf4(:,6),G1H8(27),m3h4x8(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntry,G1H8(27),37,nMB,G2H8(11),n2h8(46))
  call Hloop_AZ_Q(ntry,G1H32(7),wf4(:,4),G1H8(29),ngZd,m3h4x8(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntry,G1H8(29),37,nMB,G2H8(13),n2h8(47))
  call Hloop_AZ_Q(ntry,G1H32(8),wf4(:,4),G1H8(30),ngZd,m3h4x8(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntry,G1H8(30),37,nMB,G2H8(14),n2h8(48))
  call Hloop_AS_Q(ntry,G1H32(9),wf16(:,1),G1H2(1),ngH,m3h16x2(:,1),heltab2x32(:,:,25))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(4),n2h2(33))
  call Hloop_AV_Q(ntry,G1H32(10),wf16(:,3),G1H2(1),m3h16x2(:,2),heltab2x32(:,:,26))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(6),n2h2(34))
  call Hloop_AZ_Q(ntry,G1H32(11),wf16(:,5),G1H2(1),ngZd,m3h16x2(:,3),heltab2x32(:,:,27))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(10),n2h2(35))
  call Hloop_AV_Q(ntry,G1H32(12),wf16(:,6),G1H2(1),m3h16x2(:,4),heltab2x32(:,:,28))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(12),n2h2(36))
  call Hloop_AZ_Q(ntry,G1H32(13),wf16(:,8),G1H2(1),ngZd,m3h16x2(:,5),heltab2x32(:,:,29))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(16),n2h2(37))
  call Hloop_AV_Q(ntry,G1H32(14),wf16(:,9),G1H2(1),m3h16x2(:,6),heltab2x32(:,:,30))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(18),n2h2(38))
  call Hloop_AZ_Q(ntry,G1H32(15),wf16(:,11),G1H2(1),ngZd,m3h16x2(:,7),heltab2x32(:,:,31))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(22),n2h2(39))
  call Hloop_AV_Q(ntry,G1H32(16),wf16(:,12),G1H2(1),m3h16x2(:,8),heltab2x32(:,:,32))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(24),n2h2(40))
  call Hloop_AZ_Q(ntry,G1H32(17),wf16(:,14),G1H2(1),ngZd,m3h16x2(:,9),heltab2x32(:,:,33))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(25),n2h2(41))
  call Hloop_AV_Q(ntry,G1H32(18),wf4(:,16),G1H8(31),m3h4x8(:,25),heltab2x32(:,:,34))
  call Hloop_A_Q(ntry,G1H8(31),38,nMB,G2H8(2),n2h8(49))
  call Hloop_AZ_Q(ntry,G1H32(19),wf4(:,14),G1H8(32),ngZd,m3h4x8(:,26),heltab2x32(:,:,35))
  call Hloop_A_Q(ntry,G1H8(32),38,nMB,G2H8(4),n2h8(50))
  call Hloop_AV_Q(ntry,G1H32(20),wf4(:,16),G1H8(34),m3h4x8(:,27),heltab2x32(:,:,36))
  call Hloop_A_Q(ntry,G1H8(34),38,nMB,G2H8(7),n2h8(51))
  call Hloop_AZ_Q(ntry,G1H32(21),wf4(:,14),G1H8(35),ngZd,m3h4x8(:,28),heltab2x32(:,:,37))
  call Hloop_A_Q(ntry,G1H8(35),38,nMB,G2H8(8),n2h8(52))
  call Hloop_AV_Q(ntry,G1H32(22),wf4(:,15),G1H8(36),m3h4x8(:,29),heltab2x32(:,:,38))
  call Hloop_A_Q(ntry,G1H8(36),41,nMB,G2H8(10),n2h8(53))
  call Hloop_AV_Q(ntry,G1H32(23),wf4(:,15),G1H8(37),m3h4x8(:,30),heltab2x32(:,:,39))
  call Hloop_A_Q(ntry,G1H8(37),41,nMB,G2H8(12),n2h8(54))
  call Hloop_AZ_Q(ntry,G1H32(24),wf4(:,13),G1H8(39),ngZd,m3h4x8(:,31),heltab2x32(:,:,40))
  call Hloop_A_Q(ntry,G1H8(39),41,nMB,G2H8(15),n2h8(55))
  call Hloop_AZ_Q(ntry,G1H32(25),wf4(:,13),G1H8(40),ngZd,m3h4x8(:,32),heltab2x32(:,:,41))
  call Hloop_A_Q(ntry,G1H8(40),41,nMB,G2H8(16),n2h8(56))
  call Hloop_AS_Q(ntry,G1H32(26),wf16(:,2),G1H2(1),ngH,m3h16x2(:,10),heltab2x32(:,:,42))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(26),n2h2(42))
  call Hloop_AV_Q(ntry,G1H32(27),wf16(:,15),G1H2(1),m3h16x2(:,11),heltab2x32(:,:,43))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(27),n2h2(43))
  call Hloop_AZ_Q(ntry,G1H32(28),wf16(:,17),G1H2(1),ngZd,m3h16x2(:,12),heltab2x32(:,:,44))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(28),n2h2(44))
  call Hloop_AV_Q(ntry,G1H32(29),wf16(:,18),G1H2(1),m3h16x2(:,13),heltab2x32(:,:,45))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(29),n2h2(45))
  call Hloop_AZ_Q(ntry,G1H32(30),wf16(:,20),G1H2(1),ngZd,m3h16x2(:,14),heltab2x32(:,:,46))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(30),n2h2(46))
  call Hloop_AV_Q(ntry,G1H32(31),wf16(:,21),G1H2(1),m3h16x2(:,15),heltab2x32(:,:,47))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(31),n2h2(47))
  call Hloop_AV_Q(ntry,G1H32(32),wf16(:,22),G1H2(1),m3h16x2(:,16),heltab2x32(:,:,48))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(32),n2h2(48))
  call Hloop_AZ_Q(ntry,G1H32(33),wf16(:,24),G1H2(1),ngZd,m3h16x2(:,17),heltab2x32(:,:,49))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(33),n2h2(49))
  call Hloop_AZ_Q(ntry,G1H32(34),wf16(:,26),G1H2(1),ngZd,m3h16x2(:,18),heltab2x32(:,:,50))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(34),n2h2(50))
  call Hloop_AV_Q(ntry,G1H32(35),wf16(:,27),G1H2(1),m3h16x2(:,19),heltab2x32(:,:,51))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(35),n2h2(51))
  call Hloop_AZ_Q(ntry,G1H32(36),wf16(:,29),G1H2(1),ngZd,m3h16x2(:,20),heltab2x32(:,:,52))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(36),n2h2(52))
  call Hloop_AV_Q(ntry,G1H32(37),wf16(:,30),G1H2(1),m3h16x2(:,21),heltab2x32(:,:,53))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(37),n2h2(53))
  call Hloop_AZ_Q(ntry,G1H32(38),wf16(:,32),G1H2(1),ngZd,m3h16x2(:,22),heltab2x32(:,:,54))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(38),n2h2(54))
  call Hloop_AV_Q(ntry,G1H32(39),wf16(:,33),G1H2(1),m3h16x2(:,23),heltab2x32(:,:,55))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(39),n2h2(55))
  call Hloop_AZ_Q(ntry,G1H32(40),wf16(:,35),G1H2(1),ngZd,m3h16x2(:,24),heltab2x32(:,:,56))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(40),n2h2(56))
  call Hloop_AV_Q(ntry,G1H32(41),wf16(:,36),G1H2(1),m3h16x2(:,25),heltab2x32(:,:,57))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(41),n2h2(57))
  call Hloop_AZ_Q(ntry,G1H32(42),wf16(:,38),G1H2(1),ngZd,m3h16x2(:,26),heltab2x32(:,:,58))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(42),n2h2(58))
  call Hloop_AV_Q(ntry,G1H32(43),wf16(:,39),G1H2(1),m3h16x2(:,27),heltab2x32(:,:,59))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(43),n2h2(59))
  call Hloop_AZ_Q(ntry,G1H32(44),wf16(:,41),G1H2(1),ngZd,m3h16x2(:,28),heltab2x32(:,:,60))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(44),n2h2(60))
  call Hloop_AV_Q(ntry,G1H32(45),wf16(:,42),G1H2(1),m3h16x2(:,29),heltab2x32(:,:,61))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(45),n2h2(61))
  call Hloop_AZ_Q(ntry,G1H32(46),wf16(:,44),G1H2(1),ngZd,m3h16x2(:,30),heltab2x32(:,:,62))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(46),n2h2(62))
  call Hloop_AV_Q(ntry,G1H32(47),wf16(:,45),G1H2(1),m3h16x2(:,31),heltab2x32(:,:,63))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(47),n2h2(63))
  call Hloop_AV_Q(ntry,G1H32(48),wf16(:,46),G1H2(1),m3h16x2(:,32),heltab2x32(:,:,64))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(48),n2h2(64))
  call Hloop_AZ_Q(ntry,G1H32(49),wf16(:,48),G1H2(1),ngZd,m3h16x2(:,33),heltab2x32(:,:,65))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(49),n2h2(65))
  call Hloop_AZ_Q(ntry,G1H32(50),wf16(:,50),G1H2(1),ngZd,m3h16x2(:,34),heltab2x32(:,:,66))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(50),n2h2(66))
  call ol_merge(ntry,G2H2(50),[G2H2(49),G2H2(48),G2H2(47),G2H2(46),G2H2(45),G2H2(44),G2H2(43),G2H2(42),G2H2(41),G2H2(40),G2H2(39) &
    ,G2H2(38),G2H2(37),G2H2(36),G2H2(35),G2H2(34),G2H2(33),G2H2(32),G2H2(31),G2H2(30),G2H2(29),G2H2(28),G2H2(27),G2H2(26),G2H2(25) &
    ,G2H2(24),G2H2(22),G2H2(18),G2H2(16),G2H2(12),G2H2(10),G2H2(6),G2H2(4),G2H2(23),G2H2(20),G2H2(17),G2H2(14),G2H2(11),G2H2(8) &
    ,G2H2(5),G2H2(2)])
  call ol_merge(ntry,G2H2(3),[G2H2(1)])
  call ol_merge(ntry,G2H2(9),[G2H2(7)])
  call ol_merge(ntry,G2H2(15),[G2H2(13)])
  call ol_merge(ntry,G2H2(21),[G2H2(19)])
  call ol_merge(ntry,G2H8(3),[G2H8(1)])
  call ol_merge(ntry,G2H8(6),[G2H8(5)])
  call ol_merge(ntry,G2H8(13),[G2H8(9)])
  call ol_merge(ntry,G2H8(14),[G2H8(11)])
  call ol_merge(ntry,G2H8(4),[G2H8(2)])
  call ol_merge(ntry,G2H8(8),[G2H8(7)])
  call ol_merge(ntry,G2H8(15),[G2H8(10)])
  call ol_merge(ntry,G2H8(16),[G2H8(12)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_AV_Q(ntry,G1H4(1),wf4(:,6),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,1))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(1),n2h1(1))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(50),ex5(:),G2tensor(3),m3h2x1(:,9),heltab2x2(:,:,9))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_AZ_Q(ntry,G1H4(2),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,2),heltab2x4(:,:,2))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(5),n2h1(2))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_AV_Q(ntry,G1H4(3),wf4(:,7),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,3))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(7),n2h1(3))
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_AZ_Q(ntry,G1H4(4),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,4),heltab2x4(:,:,4))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(9),n2h1(4))
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_AV_Q(ntry,G1H4(5),wf4(:,15),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,5))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(10),n2h1(5))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_AZ_Q(ntry,G1H4(6),wf4(:,13),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,6))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(11),n2h1(6))
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call Hloop_AV_Q(ntry,G1H4(7),wf4(:,16),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,7))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(12),n2h1(7))
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_AZ_Q(ntry,G1H4(8),wf4(:,14),G1H1(1),ngZd,m3h4x1(:,8),heltab2x4(:,:,8))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(13),n2h1(8))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(3),ex5(:),G2tensor(14),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(9),ex5(:),G2tensor(15),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(15),ex5(:),G2tensor(16),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(21),ex5(:),G2tensor(17),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(3),wf8(:,3),G2tensor(18),m3h8x1(:,1),heltab2x8(:,:,41))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(6),wf8(:,6),G2tensor(19),m3h8x1(:,2),heltab2x8(:,:,42))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(13),wf8(:,9),G2tensor(20),m3h8x1(:,3),heltab2x8(:,:,43))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(14),wf8(:,11),G2tensor(21),m3h8x1(:,4),heltab2x8(:,:,44))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(4),wf8(:,27),G2tensor(22),m3h8x1(:,5),heltab2x8(:,:,45))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(8),wf8(:,30),G2tensor(23),m3h8x1(:,6),heltab2x8(:,:,46))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(15),wf8(:,33),G2tensor(24),m3h8x1(:,7),heltab2x8(:,:,47))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H8(16),wf8(:,35),G2tensor(25),m3h8x1(:,8),heltab2x8(:,:,48))
  call ol_merge_tensors(G2tensor(19),[G2tensor(18),G2tensor(2),G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(20),G2tensor(4),G1tensor(10),G0tensor(10)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(22),G2tensor(6),G1tensor(15),G0tensor(15)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(24),G2tensor(8),G1tensor(20),G0tensor(20)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(1),G1tensor(2),G0tensor(2)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(3),G0tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(19),G1tensor(14),G1tensor(9),G1tensor(4),G0tensor(19),G0tensor(14),G0tensor(9) &
    ,G0tensor(4)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(7),G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(8),G0tensor(8)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(10),G1tensor(12),G0tensor(12)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(13),G0tensor(13)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(12),G1tensor(17),G0tensor(17)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(18),G0tensor(18)])
call TI_triangle_red(G2tensor(19),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMB], &
    G0tensor(5))
call TI_triangle_red(G2tensor(21),RedBasis(4),mass3set(:,1),G0tensor(10),G0tensor(15),G0tensor(20),G0tensor(2),M2L1R1,[nMB], &
    G0tensor(3))
call TI_triangle_red(G2tensor(23),RedBasis(6),mass3set(:,1),G0tensor(19),G0tensor(14),G0tensor(9),G0tensor(4),M2L1R1,[nMB], &
    G0tensor(7))
call TI_triangle_red(G2tensor(25),RedBasis(8),mass3set(:,1),G0tensor(8),G0tensor(12),G0tensor(13),G0tensor(17),M2L1R1,[nMB], &
    G0tensor(18))
call TI_triangle_red(G2tensor(5),RedBasis(10),mass3set(:,2),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),M2L1R1,[nMB], &
    G0tensor(25))
call TI_triangle_red(G2tensor(14),RedBasis(3),mass3set(:,1),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),M2L1R1,[nMB], &
    G0tensor(30))
call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,1),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),M2L1R1,[nMB], &
    G0tensor(35))
call TI_triangle_red(G2tensor(9),RedBasis(11),mass3set(:,2),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),M2L1R1,[nMB], &
    G0tensor(40))
call TI_triangle_red(G2tensor(15),RedBasis(5),mass3set(:,1),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),M2L1R1,[nMB], &
    G0tensor(45))
call TI_triangle_red(G2tensor(11),RedBasis(12),mass3set(:,2),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),M2L1R1,[nMB], &
    G0tensor(50))
call TI_triangle_red(G2tensor(16),RedBasis(7),mass3set(:,1),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),M2L1R1,[nMB], &
    G0tensor(55))
call TI_triangle_red(G2tensor(13),RedBasis(13),mass3set(:,2),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),M2L1R1,[nMB], &
    G0tensor(60))
call TI_triangle_red(G2tensor(17),RedBasis(9),mass3set(:,1),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),M2L1R1,[nMB], &
    G0tensor(65))
call ol_merge_tensors(T0sum(5),[G0tensor(1)])
call ol_merge_tensors(T0sum(6),[G0tensor(10)])
call ol_merge_tensors(T0sum(7),[G0tensor(19)])
call ol_merge_tensors(T0sum(8),[G0tensor(8)])
call ol_merge_tensors(T0sum(9),[G0tensor(21)])
call ol_merge_tensors(T0sum(10),[G0tensor(26)])
call ol_merge_tensors(T0sum(11),[G0tensor(31)])
call ol_merge_tensors(T0sum(12),[G0tensor(36)])
call ol_merge_tensors(T0sum(13),[G0tensor(41)])
call ol_merge_tensors(T0sum(14),[G0tensor(46)])
call ol_merge_tensors(T0sum(15),[G0tensor(51)])
call ol_merge_tensors(T0sum(16),[G0tensor(56)])
call ol_merge_tensors(T0sum(17),[G0tensor(61)])
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(120)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[42,21],[nMB,0],2,2,wf8(:,70),wf8(:,3))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,70),G0H8(1),m3h8x8(:,17),heltab2x64(:,:,83))
  call Hloop_A_Q(ntry,G0H8(1),42,nMB,G1H8(6),n2h8(57))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(121)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[42,21],[nMB,0],2,2,wf8(:,71),wf8(:,3))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,71),G0H8(1),m3h8x8(:,18),heltab2x64(:,:,84))
  call Hloop_A_Q(ntry,G0H8(1),42,nMB,G1H8(3),n2h8(58))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(122)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[42,21],[nMB,0],2,2,wf8(:,70),wf8(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,70),G0H8(1),m3h8x8(:,19),heltab2x64(:,:,85))
  call Hloop_A_Q(ntry,G0H8(1),42,nMB,G1H8(9),n2h8(59))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(123)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[42,21],[nMB,0],2,2,wf8(:,71),wf8(:,6))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,71),G0H8(1),m3h8x8(:,20),heltab2x64(:,:,86))
  call Hloop_A_Q(ntry,G0H8(1),42,nMB,G1H8(8),n2h8(60))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(124)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[37,26],[nMB,0],2,2,wf8(:,66),wf8(:,9))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,66),G0H8(1),m3h8x8(:,21),heltab2x64(:,:,87))
  call Hloop_A_Q(ntry,G0H8(1),37,nMB,G1H8(1),n2h8(61))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(125)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[37,26],[nMB,0],2,2,wf8(:,66),wf8(:,11))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,66),G0H8(1),m3h8x8(:,22),heltab2x64(:,:,88))
  call Hloop_A_Q(ntry,G0H8(1),37,nMB,G1H8(13),n2h8(62))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(126)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[37,26],[nMB,0],2,2,wf8(:,68),wf8(:,9))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,68),G0H8(1),m3h8x8(:,23),heltab2x64(:,:,89))
  call Hloop_A_Q(ntry,G0H8(1),37,nMB,G1H8(2),n2h8(63))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(127)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[37,26],[nMB,0],2,2,wf8(:,68),wf8(:,11))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,68),G0H8(1),m3h8x8(:,24),heltab2x64(:,:,90))
  call Hloop_A_Q(ntry,G0H8(1),37,nMB,G1H8(18),n2h8(64))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(128)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[38,25],[nMB,0],2,2,wf8(:,88),wf8(:,27))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,88),G0H8(1),m3h8x8(:,25),heltab2x64(:,:,91))
  call Hloop_A_Q(ntry,G0H8(1),38,nMB,G1H8(16),n2h8(65))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(129)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[38,25],[nMB,0],2,2,wf8(:,89),wf8(:,27))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,89),G0H8(1),m3h8x8(:,26),heltab2x64(:,:,92))
  call Hloop_A_Q(ntry,G0H8(1),38,nMB,G1H8(23),n2h8(66))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(130)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[38,25],[nMB,0],2,2,wf8(:,88),wf8(:,30))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,88),G0H8(1),m3h8x8(:,27),heltab2x64(:,:,93))
  call Hloop_A_Q(ntry,G0H8(1),38,nMB,G1H8(19),n2h8(67))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(131)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[38,25],[nMB,0],2,2,wf8(:,89),wf8(:,30))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,89),G0H8(1),m3h8x8(:,28),heltab2x64(:,:,94))
  call Hloop_A_Q(ntry,G0H8(1),38,nMB,G1H8(28),n2h8(68))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(132)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[41,22],[nMB,0],2,2,wf8(:,84),wf8(:,33))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,84),G0H8(1),m3h8x8(:,29),heltab2x64(:,:,95))
  call Hloop_A_Q(ntry,G0H8(1),41,nMB,G1H8(11),n2h8(69))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(133)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[41,22],[nMB,0],2,2,wf8(:,84),wf8(:,35))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,84),G0H8(1),m3h8x8(:,30),heltab2x64(:,:,96))
  call Hloop_A_Q(ntry,G0H8(1),41,nMB,G1H8(33),n2h8(70))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(134)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[41,22],[nMB,0],2,2,wf8(:,86),wf8(:,33))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,86),G0H8(1),m3h8x8(:,31),heltab2x64(:,:,97))
  call Hloop_A_Q(ntry,G0H8(1),41,nMB,G1H8(12),n2h8(71))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(135)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[41,22],[nMB,0],2,2,wf8(:,86),wf8(:,35))
  call Hloop_VA_Q(ntry,G0H64(1),wf8(:,86),G0H8(1),m3h8x8(:,32),heltab2x64(:,:,98))
  call Hloop_A_Q(ntry,G0H8(1),41,nMB,G1H8(38),n2h8(72))
  call ol_merge(ntry,G1H8(3),[G1H8(6)])
  call ol_merge(ntry,G1H8(8),[G1H8(9)])
  call ol_merge(ntry,G1H8(2),[G1H8(1)])
  call ol_merge(ntry,G1H8(18),[G1H8(13)])
  call ol_merge(ntry,G1H8(23),[G1H8(16)])
  call ol_merge(ntry,G1H8(28),[G1H8(19)])
  call ol_merge(ntry,G1H8(12),[G1H8(11)])
  call ol_merge(ntry,G1H8(38),[G1H8(33)])
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(3),wf8(:,3),G1tensor(1),m3h8x1(:,9),heltab2x8(:,:,49))
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(8),wf8(:,6),G1tensor(6),m3h8x1(:,10),heltab2x8(:,:,50))
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(2),wf8(:,9),G1tensor(11),m3h8x1(:,11),heltab2x8(:,:,51))
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(18),wf8(:,11),G1tensor(16),m3h8x1(:,12),heltab2x8(:,:,52))
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(23),wf8(:,27),G1tensor(5),m3h8x1(:,13),heltab2x8(:,:,53))
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(28),wf8(:,30),G1tensor(10),m3h8x1(:,14),heltab2x8(:,:,54))
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(12),wf8(:,33),G1tensor(15),m3h8x1(:,15),heltab2x8(:,:,55))
  call Hcheck_last_AQ_V(ntry,l_switch,G1H8(38),wf8(:,35),G1tensor(20),m3h8x1(:,16),heltab2x8(:,:,56))
  call ol_merge_tensors(G0tensor(42),[G0tensor(38),G0tensor(22),G0tensor(6)])
  call ol_merge_tensors(G1tensor(6),[G1tensor(1),G0tensor(29),G0tensor(11)])
  call ol_merge_tensors(G0tensor(34),[G0tensor(17),G0tensor(4),G0tensor(2),G0tensor(16)])
  call ol_merge_tensors(G0tensor(65),[G0tensor(60),G0tensor(55),G0tensor(50),G0tensor(45),G0tensor(40),G0tensor(35),G0tensor(30) &
    ,G0tensor(25),G0tensor(18),G0tensor(7),G0tensor(3),G0tensor(5)])
  call ol_merge_tensors(G0tensor(37),[G0tensor(27),G0tensor(23),G0tensor(15)])
  call ol_merge_tensors(G1tensor(16),[G1tensor(11),G0tensor(44),G0tensor(20)])
  call ol_merge_tensors(G0tensor(62),[G0tensor(58),G0tensor(47),G0tensor(14)])
  call ol_merge_tensors(G1tensor(10),[G1tensor(5),G0tensor(54),G0tensor(9)])
  call ol_merge_tensors(G0tensor(57),[G0tensor(52),G0tensor(48),G0tensor(12)])
  call ol_merge_tensors(G1tensor(20),[G1tensor(15),G0tensor(64),G0tensor(13)])
  call ol_merge_tensors(G0tensor(59),[G0tensor(49),G0tensor(39),G0tensor(32),G0tensor(24)])
  call ol_merge_tensors(G0tensor(63),[G0tensor(53),G0tensor(43),G0tensor(33),G0tensor(28)])
call TI_bubble_red(G1tensor(6),42,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(10))
call TI_bubble_red(G1tensor(16),37,mass2set(:,1),G0tensor(19),M2L1R1,G0tensor(8))
call TI_bubble_red(G1tensor(10),38,mass2set(:,1),G0tensor(21),M2L1R1,G0tensor(26))
call TI_bubble_red(G1tensor(20),41,mass2set(:,1),G0tensor(31),M2L1R1,G0tensor(36))
  call ol_merge_tensors(G0tensor(36),[G0tensor(26),G0tensor(8),G0tensor(65),G0tensor(10)])
call ol_merge_tensors(T0sum(18),[G0tensor(42)])
call ol_merge_tensors(T0sum(19),[G0tensor(1)])
call ol_merge_tensors(T0sum(20),[G0tensor(36)])
call ol_merge_tensors(T0sum(21),[G0tensor(34)])
call ol_merge_tensors(T0sum(22),[G0tensor(37)])
call ol_merge_tensors(T0sum(23),[G0tensor(19)])
call ol_merge_tensors(T0sum(24),[G0tensor(62)])
call ol_merge_tensors(T0sum(25),[G0tensor(21)])
call ol_merge_tensors(T0sum(26),[G0tensor(57)])
call ol_merge_tensors(T0sum(27),[G0tensor(31)])
call ol_merge_tensors(T0sum(28),[G0tensor(59)])
call ol_merge_tensors(T0sum(29),[G0tensor(63)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppllll_eeexexbbx_1_/**/REALKIND
