
module ol_vamp_1_ppllll2_nf5_nexnmemxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll2_nf5_nexnmemxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll2_nf5_nexnmemxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllll2_nf5_nexnmemxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllll2_nf5_nexnmemxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,7) :: G0
  complex(REALKIND), dimension(4,5,4,14) :: G1
  complex(REALKIND), dimension(4,15,4,32) :: G2
  complex(REALKIND), dimension(4,35,4,12) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,18,64))
    allocate(G4tensorhel(70,6,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MB,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,48),MB,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,7),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MB,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,10),G2(:,:,:,3))
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),MB,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,23),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MB,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,24),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MB,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,26),G2(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MB,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,29),G2(:,:,:,7),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),MB,G3tensor(:,6))
  call loop_AV_Q(G2(:,:,:,1),wf(:,30),G2(:,:,:,8))
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MB,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,32),G2(:,:,:,9),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),MB,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,35),G2(:,:,:,10),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),MB,G3tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MB,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,-5),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,48),MB,G2(:,:,:,11))
  call loop_QS_A(G2(:,:,:,11),wf(:,7),G2(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),MB,G3tensor(:,10))
  call loop_QV_A(G2(:,:,:,11),wf(:,10),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,63),MB,G3tensor(:,11))
  call loop_QZ_A(G2(:,:,:,11),wf(:,23),G2(:,:,:,14),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MB,G3tensor(:,12))
  call loop_QV_A(G2(:,:,:,11),wf(:,24),G2(:,:,:,15))
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,63),MB,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,11),wf(:,26),G2(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),MB,G3tensor(:,14))
  call loop_QZ_A(G2(:,:,:,11),wf(:,29),G2(:,:,:,17),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,63),MB,G3tensor(:,15))
  call loop_QV_A(G2(:,:,:,11),wf(:,30),G2(:,:,:,18))
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),MB,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,11),wf(:,32),G2(:,:,:,19),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,63),MB,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,11),wf(:,35),G2(:,:,:,20),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MB,G3tensor(:,18))
  call loop_QW_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,10),ZERO,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,-5),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,42),ZERO,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,-4),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,58),ZERO,G3(:,:,:,1))
  call loop_QW_A(G3(:,:,:,1),wf(:,3),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),ZERO,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,5),wf(:,-4),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,26),ZERO,G2(:,:,:,23))
  call loop_QV_A(G2(:,:,:,23),wf(:,-5),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,58),ZERO,G3(:,:,:,3))
  call loop_QW_A(G3(:,:,:,3),wf(:,3),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),ZERO,G4tensor(:,2))
  call loop_AW_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,10),ZERO,G1(:,:,:,8))
  call loop_AV_Q(G1(:,:,:,8),wf(:,-5),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,42),ZERO,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-4),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,58),ZERO,G3(:,:,:,5))
  call loop_AW_Q(G3(:,:,:,5),wf(:,3),G3(:,:,:,6))
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),ZERO,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,8),wf(:,-4),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,26),ZERO,G2(:,:,:,27))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-5),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,58),ZERO,G3(:,:,:,7))
  call loop_AW_Q(G3(:,:,:,7),wf(:,3),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),ZERO,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,16),ZERO,G1(:,:,:,11))
  call loop_AW_Q(G1(:,:,:,11),wf(:,4),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,26),ZERO,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-5),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,58),ZERO,G3(:,:,:,9))
  call loop_AW_Q(G3(:,:,:,9),wf(:,3),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),ZERO,G4tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,16),ZERO,G1(:,:,:,13))
  call loop_QW_A(G1(:,:,:,13),wf(:,4),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,26),ZERO,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,-5),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,58),ZERO,G3(:,:,:,11))
  call loop_QW_A(G3(:,:,:,11),wf(:,3),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),ZERO,G4tensor(:,6))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(9) * den(21)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(9) * den(21)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(6) * den(23)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(6) * den(23)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-f(5) * den(25)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-f(5) * den(25)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,4),T4sum(1:70,2))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,5),T4sum(1:70,3))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,6),T4sum(1:70,3))
  M(1) = M(1) + (-f(6) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(30)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(30)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(31)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(31)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,1))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllll2_nf5_nexnmemxgg_1_/**/REALKIND
