
module ol_vamp_1_ppllll2_nf5_nenenexnexgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll2_nf5_nenenexnexgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll2_nf5_nenenexnexgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllll2_nf5_nenenexnexgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllll2_nf5_nenenexnexgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,17) :: G0
  complex(REALKIND), dimension(4,5,4,54) :: G1
  complex(REALKIND), dimension(4,15,4,94) :: G2
  complex(REALKIND), dimension(4,35,4,72) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,20,64))
    allocate(G4tensorhel(70,36,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MB,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,48),MB,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,12),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MB,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,35),G2(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),MB,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,38),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MB,G3tensor(:,3))
  call loop_AS_Q(G2(:,:,:,1),wf(:,21),G2(:,:,:,5),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MB,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,40),G2(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MB,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,43),G2(:,:,:,7),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),MB,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,45),G2(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MB,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,48),G2(:,:,:,9),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),MB,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,50),G2(:,:,:,10),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),MB,G3tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,53),G2(:,:,:,11),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,63),MB,G3tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,4),G1(:,:,:,3),gZd)
  call loop_A_Q(G1(:,:,:,3),Q(:,26),MB,G2(:,:,:,12))
  call loop_AV_Q(G2(:,:,:,12),wf(:,-5),G2(:,:,:,13))
  call loop_A_Q(G2(:,:,:,13),Q(:,58),MB,G3(:,:,:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,3),G3(:,:,:,2),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MB,G4tensor(:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,8),G1(:,:,:,4),gZd)
  call loop_A_Q(G1(:,:,:,4),Q(:,25),MB,G2(:,:,:,14))
  call loop_AV_Q(G2(:,:,:,14),wf(:,-5),G2(:,:,:,15))
  call loop_A_Q(G2(:,:,:,15),Q(:,57),MB,G3(:,:,:,3))
  call loop_AZ_Q(G3(:,:,:,3),wf(:,9),G3(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),MB,G4tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MB,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,-5),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,48),MB,G2(:,:,:,16))
  call loop_QS_A(G2(:,:,:,16),wf(:,12),G2(:,:,:,17),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,63),MB,G3tensor(:,11))
  call loop_QZ_A(G2(:,:,:,16),wf(:,35),G2(:,:,:,18),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),MB,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,16),wf(:,38),G2(:,:,:,19),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,63),MB,G3tensor(:,13))
  call loop_QS_A(G2(:,:,:,16),wf(:,21),G2(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MB,G3tensor(:,14))
  call loop_QZ_A(G2(:,:,:,16),wf(:,40),G2(:,:,:,21),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,21),Q(:,63),MB,G3tensor(:,15))
  call loop_QZ_A(G2(:,:,:,16),wf(:,43),G2(:,:,:,22),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,63),MB,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,16),wf(:,45),G2(:,:,:,23),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,23),Q(:,63),MB,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,16),wf(:,48),G2(:,:,:,24),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,63),MB,G3tensor(:,18))
  call loop_QZ_A(G2(:,:,:,16),wf(:,50),G2(:,:,:,25),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,63),MB,G3tensor(:,19))
  call loop_QZ_A(G2(:,:,:,16),wf(:,53),G2(:,:,:,26),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,63),MB,G3tensor(:,20))
  call loop_QZ_A(G1(:,:,:,5),wf(:,4),G1(:,:,:,7),gZd)
  call loop_Q_A(G1(:,:,:,7),Q(:,26),MB,G2(:,:,:,27))
  call loop_QV_A(G2(:,:,:,27),wf(:,-5),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,58),MB,G3(:,:,:,5))
  call loop_QZ_A(G3(:,:,:,5),wf(:,3),G3(:,:,:,6),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MB,G4tensor(:,3))
  call loop_QZ_A(G1(:,:,:,5),wf(:,8),G1(:,:,:,8),gZd)
  call loop_Q_A(G1(:,:,:,8),Q(:,25),MB,G2(:,:,:,29))
  call loop_QV_A(G2(:,:,:,29),wf(:,-5),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,57),MB,G3(:,:,:,7))
  call loop_QZ_A(G3(:,:,:,7),wf(:,9),G3(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,4))
  call loop_QZ_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,4),gZu)
  call loop_Q_A(G0(:,:,:,4),Q(:,10),ZERO,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,-5),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,42),ZERO,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,-4),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,58),ZERO,G3(:,:,:,9))
  call loop_QZ_A(G3(:,:,:,9),wf(:,3),G3(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),ZERO,G4tensor(:,5))
  call loop_QV_A(G1(:,:,:,9),wf(:,-4),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,26),ZERO,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,-5),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,58),ZERO,G3(:,:,:,11))
  call loop_QZ_A(G3(:,:,:,11),wf(:,3),G3(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),ZERO,G4tensor(:,6))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,5),gZu)
  call loop_A_Q(G0(:,:,:,5),Q(:,10),ZERO,G1(:,:,:,12))
  call loop_AV_Q(G1(:,:,:,12),wf(:,-5),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,42),ZERO,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,-4),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,58),ZERO,G3(:,:,:,13))
  call loop_AZ_Q(G3(:,:,:,13),wf(:,3),G3(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),ZERO,G4tensor(:,7))
  call loop_AV_Q(G1(:,:,:,12),wf(:,-4),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,26),ZERO,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,-5),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,58),ZERO,G3(:,:,:,15))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,3),G3(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),ZERO,G4tensor(:,8))
  call loop_QZ_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,6),gZd)
  call loop_Q_A(G0(:,:,:,6),Q(:,10),ZERO,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,-5),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,42),ZERO,G2(:,:,:,39))
  call loop_QV_A(G2(:,:,:,39),wf(:,-4),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,58),ZERO,G3(:,:,:,17))
  call loop_QZ_A(G3(:,:,:,17),wf(:,3),G3(:,:,:,18),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),ZERO,G4tensor(:,9))
  call loop_QV_A(G1(:,:,:,15),wf(:,-4),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,26),ZERO,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,-5),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,58),ZERO,G3(:,:,:,19))
  call loop_QZ_A(G3(:,:,:,19),wf(:,3),G3(:,:,:,20),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),ZERO,G4tensor(:,10))
  call loop_QZ_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,7),gZd)
  call loop_Q_A(G0(:,:,:,7),Q(:,10),MB,G1(:,:,:,18))
  call loop_QV_A(G1(:,:,:,18),wf(:,-5),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,42),MB,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,-4),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,58),MB,G3(:,:,:,21))
  call loop_QZ_A(G3(:,:,:,21),wf(:,3),G3(:,:,:,22),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),MB,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,18),wf(:,-4),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,26),MB,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,-5),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,58),MB,G3(:,:,:,23))
  call loop_QZ_A(G3(:,:,:,23),wf(:,3),G3(:,:,:,24),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),MB,G4tensor(:,12))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,8),gZd)
  call loop_A_Q(G0(:,:,:,8),Q(:,10),ZERO,G1(:,:,:,21))
  call loop_AV_Q(G1(:,:,:,21),wf(:,-5),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,42),ZERO,G2(:,:,:,47))
  call loop_AV_Q(G2(:,:,:,47),wf(:,-4),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,58),ZERO,G3(:,:,:,25))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,3),G3(:,:,:,26),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,63),ZERO,G4tensor(:,13))
  call loop_AV_Q(G1(:,:,:,21),wf(:,-4),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,26),ZERO,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-5),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,58),ZERO,G3(:,:,:,27))
  call loop_AZ_Q(G3(:,:,:,27),wf(:,3),G3(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,63),ZERO,G4tensor(:,14))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,9),gZd)
  call loop_A_Q(G0(:,:,:,9),Q(:,10),MB,G1(:,:,:,24))
  call loop_AV_Q(G1(:,:,:,24),wf(:,-5),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,42),MB,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-4),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,58),MB,G3(:,:,:,29))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,3),G3(:,:,:,30),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,63),MB,G4tensor(:,15))
  call loop_AV_Q(G1(:,:,:,24),wf(:,-4),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,26),MB,G2(:,:,:,53))
  call loop_AV_Q(G2(:,:,:,53),wf(:,-5),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,58),MB,G3(:,:,:,31))
  call loop_AZ_Q(G3(:,:,:,31),wf(:,3),G3(:,:,:,32),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MB,G4tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,16),ZERO,G1(:,:,:,27))
  call loop_QZ_A(G1(:,:,:,27),wf(:,4),G1(:,:,:,28),gZu)
  call loop_Q_A(G1(:,:,:,28),Q(:,26),ZERO,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,-5),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,58),ZERO,G3(:,:,:,33))
  call loop_QZ_A(G3(:,:,:,33),wf(:,3),G3(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,63),ZERO,G4tensor(:,17))
  call loop_QZ_A(G1(:,:,:,27),wf(:,4),G1(:,:,:,29),gZd)
  call loop_Q_A(G1(:,:,:,29),Q(:,26),ZERO,G2(:,:,:,57))
  call loop_QV_A(G2(:,:,:,57),wf(:,-5),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,58),ZERO,G3(:,:,:,35))
  call loop_QZ_A(G3(:,:,:,35),wf(:,3),G3(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,63),ZERO,G4tensor(:,18))
  call loop_QZ_A(G1(:,:,:,27),wf(:,8),G1(:,:,:,30),gZu)
  call loop_Q_A(G1(:,:,:,30),Q(:,25),ZERO,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,-5),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,57),ZERO,G3(:,:,:,37))
  call loop_QZ_A(G3(:,:,:,37),wf(:,9),G3(:,:,:,38),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,63),ZERO,G4tensor(:,19))
  call loop_QZ_A(G1(:,:,:,27),wf(:,8),G1(:,:,:,31),gZd)
  call loop_Q_A(G1(:,:,:,31),Q(:,25),ZERO,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,-5),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,57),ZERO,G3(:,:,:,39))
  call loop_QZ_A(G3(:,:,:,39),wf(:,9),G3(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),ZERO,G4tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,16),ZERO,G1(:,:,:,32))
  call loop_AZ_Q(G1(:,:,:,32),wf(:,4),G1(:,:,:,33),gZu)
  call loop_A_Q(G1(:,:,:,33),Q(:,26),ZERO,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-5),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,58),ZERO,G3(:,:,:,41))
  call loop_AZ_Q(G3(:,:,:,41),wf(:,3),G3(:,:,:,42),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,63),ZERO,G4tensor(:,21))
  call loop_AZ_Q(G1(:,:,:,32),wf(:,4),G1(:,:,:,34),gZd)
  call loop_A_Q(G1(:,:,:,34),Q(:,26),ZERO,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-5),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,58),ZERO,G3(:,:,:,43))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,3),G3(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,63),ZERO,G4tensor(:,22))
  call loop_AZ_Q(G1(:,:,:,32),wf(:,8),G1(:,:,:,35),gZu)
  call loop_A_Q(G1(:,:,:,35),Q(:,25),ZERO,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,-5),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,57),ZERO,G3(:,:,:,45))
  call loop_AZ_Q(G3(:,:,:,45),wf(:,9),G3(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,63),ZERO,G4tensor(:,23))
  call loop_AZ_Q(G1(:,:,:,32),wf(:,8),G1(:,:,:,36),gZd)
  call loop_A_Q(G1(:,:,:,36),Q(:,25),ZERO,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-5),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,57),ZERO,G3(:,:,:,47))
  call loop_AZ_Q(G3(:,:,:,47),wf(:,9),G3(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,63),ZERO,G4tensor(:,24))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,12),gZu)
  call loop_A_Q(G0(:,:,:,12),Q(:,9),ZERO,G1(:,:,:,37))
  call loop_AV_Q(G1(:,:,:,37),wf(:,-4),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,25),ZERO,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,-5),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,57),ZERO,G3(:,:,:,49))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,9),G3(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,63),ZERO,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,37),wf(:,-5),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,41),ZERO,G2(:,:,:,73))
  call loop_AV_Q(G2(:,:,:,73),wf(:,-4),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,57),ZERO,G3(:,:,:,51))
  call loop_AZ_Q(G3(:,:,:,51),wf(:,9),G3(:,:,:,52),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,63),ZERO,G4tensor(:,26))
  call loop_QZ_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,13),gZu)
  call loop_Q_A(G0(:,:,:,13),Q(:,9),ZERO,G1(:,:,:,40))
  call loop_QV_A(G1(:,:,:,40),wf(:,-4),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,25),ZERO,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,-5),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,57),ZERO,G3(:,:,:,53))
  call loop_QZ_A(G3(:,:,:,53),wf(:,9),G3(:,:,:,54),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,63),ZERO,G4tensor(:,27))
  call loop_QV_A(G1(:,:,:,40),wf(:,-5),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,41),ZERO,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,-4),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,57),ZERO,G3(:,:,:,55))
  call loop_QZ_A(G3(:,:,:,55),wf(:,9),G3(:,:,:,56),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,56),Q(:,63),ZERO,G4tensor(:,28))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,14),gZd)
  call loop_A_Q(G0(:,:,:,14),Q(:,9),ZERO,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-4),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,25),ZERO,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-5),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,57),ZERO,G3(:,:,:,57))
  call loop_AZ_Q(G3(:,:,:,57),wf(:,9),G3(:,:,:,58),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,63),ZERO,G4tensor(:,29))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-5),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,41),ZERO,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-4),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,57),ZERO,G3(:,:,:,59))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,9),G3(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,63),ZERO,G4tensor(:,30))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,15),gZd)
  call loop_A_Q(G0(:,:,:,15),Q(:,9),MB,G1(:,:,:,46))
  call loop_AV_Q(G1(:,:,:,46),wf(:,-4),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,25),MB,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-5),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,57),MB,G3(:,:,:,61))
  call loop_AZ_Q(G3(:,:,:,61),wf(:,9),G3(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,63),MB,G4tensor(:,31))
  call loop_AV_Q(G1(:,:,:,46),wf(:,-5),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,41),MB,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-4),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,57),MB,G3(:,:,:,63))
  call loop_AZ_Q(G3(:,:,:,63),wf(:,9),G3(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,63),MB,G4tensor(:,32))
  call loop_QZ_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,16),gZd)
  call loop_Q_A(G0(:,:,:,16),Q(:,9),ZERO,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,-4),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,25),ZERO,G2(:,:,:,87))
  call loop_QV_A(G2(:,:,:,87),wf(:,-5),G2(:,:,:,88))
  call loop_Q_A(G2(:,:,:,88),Q(:,57),ZERO,G3(:,:,:,65))
  call loop_QZ_A(G3(:,:,:,65),wf(:,9),G3(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),ZERO,G4tensor(:,33))
  call loop_QV_A(G1(:,:,:,49),wf(:,-5),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,41),ZERO,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,-4),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,57),ZERO,G3(:,:,:,67))
  call loop_QZ_A(G3(:,:,:,67),wf(:,9),G3(:,:,:,68),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,63),ZERO,G4tensor(:,34))
  call loop_QZ_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,17),gZd)
  call loop_Q_A(G0(:,:,:,17),Q(:,9),MB,G1(:,:,:,52))
  call loop_QV_A(G1(:,:,:,52),wf(:,-4),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,25),MB,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,-5),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,57),MB,G3(:,:,:,69))
  call loop_QZ_A(G3(:,:,:,69),wf(:,9),G3(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,63),MB,G4tensor(:,35))
  call loop_QV_A(G1(:,:,:,52),wf(:,-5),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,41),MB,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,-4),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,57),MB,G3(:,:,:,71))
  call loop_QZ_A(G3(:,:,:,71),wf(:,9),G3(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,63),MB,G4tensor(:,36))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-f(6) * den(30)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(30)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,5),T4sum(1:70,1))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (f(3) * den(3)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,11),T4sum(1:70,2))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,13),T4sum(1:70,1))
  M(1) = M(1) + (f(3) * den(3)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,15),T4sum(1:70,2))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,8),T4sum(1:70,3))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,6),T4sum(1:70,3))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,14),T4sum(1:70,3))
  M(1) = M(1) + (f(3) * den(3)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,16),T4sum(1:70,4))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,10),T4sum(1:70,3))
  M(1) = M(1) + (f(3) * den(3)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,12),T4sum(1:70,4))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,17),T4sum(1:70,5))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,21),T4sum(1:70,5))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,18),T4sum(1:70,5))
  M(1) = M(1) + (f(3) * den(3)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,3),T4sum(1:70,6))
  M(1) = M(1) + (f(4) * den(3)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,22),T4sum(1:70,5))
  M(1) = M(1) + (f(3) * den(3)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,1),T4sum(1:70,6))
  M(1) = M(1) + (f(3) * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(3) * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (f(3) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (f(3) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (f(6) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(6) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,25),T4sum(1:70,7))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,27),T4sum(1:70,7))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,29),T4sum(1:70,7))
  M(1) = M(1) + (-f(3) * den(6)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,31),T4sum(1:70,8))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,33),T4sum(1:70,7))
  M(1) = M(1) + (-f(3) * den(6)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,35),T4sum(1:70,8))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,28),T4sum(1:70,9))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,26),T4sum(1:70,9))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,34),T4sum(1:70,9))
  M(1) = M(1) + (-f(3) * den(6)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,36),T4sum(1:70,10))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,30),T4sum(1:70,9))
  M(1) = M(1) + (-f(3) * den(6)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,32),T4sum(1:70,10))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,23),T4sum(1:70,11))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,19),T4sum(1:70,11))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,24),T4sum(1:70,11))
  M(1) = M(1) + (-f(3) * den(6)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,2),T4sum(1:70,12))
  M(1) = M(1) + (-f(4) * den(6)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,20),T4sum(1:70,11))
  M(1) = M(1) + (-f(3) * den(6)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,4),T4sum(1:70,12))
  M(1) = M(1) + (-f(3) * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-f(3) * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-f(3) * den(40)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-f(3) * den(40)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-f(3) * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-f(3) * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-f(3) * den(43)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-f(3) * den(43)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (f(3) * den(44)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (f(3) * den(44)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (f(3) * den(46)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(3) * den(46)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,1))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllll2_nf5_nenenexnexgg_1_/**/REALKIND
