
module ol_vamp_1_ppllll2_nf5_eexmmxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll2_nf5_eexmmxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll2_nf5_eexmmxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllll2_nf5_eexmmxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllll2_nf5_eexmmxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,15) :: G0
  complex(REALKIND), dimension(4,5,4,46) :: G1
  complex(REALKIND), dimension(4,15,4,96) :: G2
  complex(REALKIND), dimension(4,35,4,96) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,34,64))
    allocate(G4tensorhel(70,66,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MB,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,48),MB,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,10),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MB,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,31),G2(:,:,:,3))
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),MB,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,33),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MB,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,34),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MB,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,36),G2(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MB,G3tensor(:,5))
  call loop_AV_Q(G2(:,:,:,1),wf(:,38),G2(:,:,:,7))
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),MB,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,40),G2(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MB,G3tensor(:,7))
  call loop_AV_Q(G2(:,:,:,1),wf(:,42),G2(:,:,:,9))
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),MB,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,44),G2(:,:,:,10),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),MB,G3tensor(:,9))
  call loop_AV_Q(G2(:,:,:,1),wf(:,45),G2(:,:,:,11))
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,63),MB,G3tensor(:,10))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,47),G2(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,63),MB,G3tensor(:,11))
  call loop_AV_Q(G2(:,:,:,1),wf(:,48),G2(:,:,:,13))
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,63),MB,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,50),G2(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,63),MB,G3tensor(:,13))
  call loop_AV_Q(G2(:,:,:,1),wf(:,52),G2(:,:,:,15))
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,63),MB,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,1),wf(:,54),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,63),MB,G3tensor(:,15))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,56),G2(:,:,:,17),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,63),MB,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,58),G2(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,63),MB,G3tensor(:,17))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,28),MB,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-5),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,60),MB,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MB,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,7),G3(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,63),MB,G4tensor(:,2))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,5),G1(:,:,:,4),gZd)
  call loop_A_Q(G1(:,:,:,4),Q(:,28),MB,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-5),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,60),MB,G3(:,:,:,4))
  call loop_AV_Q(G3(:,:,:,4),wf(:,1),G3(:,:,:,5))
  call check_last_A_Q(l_switch,G3(:,:,:,5),Q(:,63),MB,G4tensor(:,3))
  call loop_AZ_Q(G3(:,:,:,4),wf(:,7),G3(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),MB,G4tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MB,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,-5),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,48),MB,G2(:,:,:,23))
  call loop_QS_A(G2(:,:,:,23),wf(:,10),G2(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,63),MB,G3tensor(:,18))
  call loop_QV_A(G2(:,:,:,23),wf(:,31),G2(:,:,:,25))
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,63),MB,G3tensor(:,19))
  call loop_QZ_A(G2(:,:,:,23),wf(:,33),G2(:,:,:,26),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,63),MB,G3tensor(:,20))
  call loop_QV_A(G2(:,:,:,23),wf(:,34),G2(:,:,:,27))
  call check_last_Q_A(l_switch,G2(:,:,:,27),Q(:,63),MB,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,23),wf(:,36),G2(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,63),MB,G3tensor(:,22))
  call loop_QV_A(G2(:,:,:,23),wf(:,38),G2(:,:,:,29))
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,63),MB,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,23),wf(:,40),G2(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,63),MB,G3tensor(:,24))
  call loop_QV_A(G2(:,:,:,23),wf(:,42),G2(:,:,:,31))
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,63),MB,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,23),wf(:,44),G2(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,63),MB,G3tensor(:,26))
  call loop_QV_A(G2(:,:,:,23),wf(:,45),G2(:,:,:,33))
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,63),MB,G3tensor(:,27))
  call loop_QZ_A(G2(:,:,:,23),wf(:,47),G2(:,:,:,34),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,63),MB,G3tensor(:,28))
  call loop_QV_A(G2(:,:,:,23),wf(:,48),G2(:,:,:,35))
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,63),MB,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,23),wf(:,50),G2(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,63),MB,G3tensor(:,30))
  call loop_QV_A(G2(:,:,:,23),wf(:,52),G2(:,:,:,37))
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,63),MB,G3tensor(:,31))
  call loop_QV_A(G2(:,:,:,23),wf(:,54),G2(:,:,:,38))
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,63),MB,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,23),wf(:,56),G2(:,:,:,39),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,39),Q(:,63),MB,G3tensor(:,33))
  call loop_QZ_A(G2(:,:,:,23),wf(:,58),G2(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,63),MB,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,5),wf(:,2),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,28),MB,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,-5),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,60),MB,G3(:,:,:,7))
  call loop_QV_A(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,5))
  call loop_QZ_A(G3(:,:,:,7),wf(:,7),G3(:,:,:,9),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,9),Q(:,63),MB,G4tensor(:,6))
  call loop_QZ_A(G1(:,:,:,5),wf(:,5),G1(:,:,:,8),gZd)
  call loop_Q_A(G1(:,:,:,8),Q(:,28),MB,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,-5),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,60),MB,G3(:,:,:,10))
  call loop_QV_A(G3(:,:,:,10),wf(:,1),G3(:,:,:,11))
  call check_last_Q_A(l_switch,G3(:,:,:,11),Q(:,63),MB,G4tensor(:,7))
  call loop_QZ_A(G3(:,:,:,10),wf(:,7),G3(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MB,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,12),ZERO,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,-5),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,44),ZERO,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,-4),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,60),ZERO,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,63),ZERO,G4tensor(:,9))
  call loop_QZ_A(G3(:,:,:,13),wf(:,7),G3(:,:,:,15),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,63),ZERO,G4tensor(:,10))
  call loop_QZ_A(G3(:,:,:,13),wf(:,7),G3(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,63),ZERO,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,9),wf(:,-4),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,28),ZERO,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,60),ZERO,G3(:,:,:,17))
  call loop_QV_A(G3(:,:,:,17),wf(:,1),G3(:,:,:,18))
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),ZERO,G4tensor(:,12))
  call loop_QZ_A(G3(:,:,:,17),wf(:,7),G3(:,:,:,19),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,19),Q(:,63),ZERO,G4tensor(:,13))
  call loop_QZ_A(G3(:,:,:,17),wf(:,7),G3(:,:,:,20),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),ZERO,G4tensor(:,14))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,12),ZERO,G1(:,:,:,12))
  call loop_AV_Q(G1(:,:,:,12),wf(:,-5),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,44),ZERO,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-4),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,60),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,1),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),ZERO,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,7),G3(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,63),ZERO,G4tensor(:,16))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,7),G3(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),ZERO,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,12),wf(:,-4),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,28),ZERO,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-5),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,60),ZERO,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,1),G3(:,:,:,26))
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,63),ZERO,G4tensor(:,18))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,7),G3(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,63),ZERO,G4tensor(:,19))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,7),G3(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,63),ZERO,G4tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,12),MB,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,-5),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,44),MB,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,60),MB,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,1),G3(:,:,:,30))
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,63),MB,G4tensor(:,21))
  call loop_QZ_A(G3(:,:,:,29),wf(:,7),G3(:,:,:,31),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,31),Q(:,63),MB,G4tensor(:,22))
  call loop_QV_A(G1(:,:,:,15),wf(:,-4),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,28),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,-5),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,60),MB,G3(:,:,:,32))
  call loop_QV_A(G3(:,:,:,32),wf(:,1),G3(:,:,:,33))
  call check_last_Q_A(l_switch,G3(:,:,:,33),Q(:,63),MB,G4tensor(:,23))
  call loop_QZ_A(G3(:,:,:,32),wf(:,7),G3(:,:,:,34),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,63),MB,G4tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,12),MB,G1(:,:,:,18))
  call loop_AV_Q(G1(:,:,:,18),wf(:,-5),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,44),MB,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,60),MB,G3(:,:,:,35))
  call loop_AV_Q(G3(:,:,:,35),wf(:,1),G3(:,:,:,36))
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,63),MB,G4tensor(:,25))
  call loop_AZ_Q(G3(:,:,:,35),wf(:,7),G3(:,:,:,37),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,37),Q(:,63),MB,G4tensor(:,26))
  call loop_AV_Q(G1(:,:,:,18),wf(:,-4),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,28),MB,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-5),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,60),MB,G3(:,:,:,38))
  call loop_AV_Q(G3(:,:,:,38),wf(:,1),G3(:,:,:,39))
  call check_last_A_Q(l_switch,G3(:,:,:,39),Q(:,63),MB,G4tensor(:,27))
  call loop_AZ_Q(G3(:,:,:,38),wf(:,7),G3(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,63),MB,G4tensor(:,28))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,8),gZu)
  call loop_Q_A(G0(:,:,:,8),Q(:,12),ZERO,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,-5),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,44),ZERO,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,-4),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,60),ZERO,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,1),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),ZERO,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,41),wf(:,7),G3(:,:,:,43),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,43),Q(:,63),ZERO,G4tensor(:,30))
  call loop_QV_A(G1(:,:,:,21),wf(:,-4),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,28),ZERO,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,-5),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,60),ZERO,G3(:,:,:,44))
  call loop_QV_A(G3(:,:,:,44),wf(:,1),G3(:,:,:,45))
  call check_last_Q_A(l_switch,G3(:,:,:,45),Q(:,63),ZERO,G4tensor(:,31))
  call loop_QZ_A(G3(:,:,:,44),wf(:,7),G3(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,63),ZERO,G4tensor(:,32))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,9),gZu)
  call loop_A_Q(G0(:,:,:,9),Q(:,12),ZERO,G1(:,:,:,24))
  call loop_AV_Q(G1(:,:,:,24),wf(:,-5),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,44),ZERO,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-4),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,60),ZERO,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,1),G3(:,:,:,48))
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,63),ZERO,G4tensor(:,33))
  call loop_AZ_Q(G3(:,:,:,47),wf(:,7),G3(:,:,:,49),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,49),Q(:,63),ZERO,G4tensor(:,34))
  call loop_AV_Q(G1(:,:,:,24),wf(:,-4),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,28),ZERO,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,-5),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,60),ZERO,G3(:,:,:,50))
  call loop_AV_Q(G3(:,:,:,50),wf(:,1),G3(:,:,:,51))
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,63),ZERO,G4tensor(:,35))
  call loop_AZ_Q(G3(:,:,:,50),wf(:,7),G3(:,:,:,52),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,63),ZERO,G4tensor(:,36))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,10),gZd)
  call loop_Q_A(G0(:,:,:,10),Q(:,12),ZERO,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,-5),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,44),ZERO,G2(:,:,:,69))
  call loop_QV_A(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,60),ZERO,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,1),G3(:,:,:,54))
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,63),ZERO,G4tensor(:,37))
  call loop_QZ_A(G3(:,:,:,53),wf(:,7),G3(:,:,:,55),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,55),Q(:,63),ZERO,G4tensor(:,38))
  call loop_QV_A(G1(:,:,:,27),wf(:,-4),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,28),ZERO,G2(:,:,:,71))
  call loop_QV_A(G2(:,:,:,71),wf(:,-5),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,60),ZERO,G3(:,:,:,56))
  call loop_QV_A(G3(:,:,:,56),wf(:,1),G3(:,:,:,57))
  call check_last_Q_A(l_switch,G3(:,:,:,57),Q(:,63),ZERO,G4tensor(:,39))
  call loop_QZ_A(G3(:,:,:,56),wf(:,7),G3(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,63),ZERO,G4tensor(:,40))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,11),gZd)
  call loop_Q_A(G0(:,:,:,11),Q(:,12),MB,G1(:,:,:,30))
  call loop_QV_A(G1(:,:,:,30),wf(:,-5),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,44),MB,G2(:,:,:,73))
  call loop_QV_A(G2(:,:,:,73),wf(:,-4),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,60),MB,G3(:,:,:,59))
  call loop_QV_A(G3(:,:,:,59),wf(:,1),G3(:,:,:,60))
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,63),MB,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,59),wf(:,7),G3(:,:,:,61),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,61),Q(:,63),MB,G4tensor(:,42))
  call loop_QV_A(G1(:,:,:,30),wf(:,-4),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,28),MB,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,-5),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,60),MB,G3(:,:,:,62))
  call loop_QV_A(G3(:,:,:,62),wf(:,1),G3(:,:,:,63))
  call check_last_Q_A(l_switch,G3(:,:,:,63),Q(:,63),MB,G4tensor(:,43))
  call loop_QZ_A(G3(:,:,:,62),wf(:,7),G3(:,:,:,64),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),MB,G4tensor(:,44))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,12),gZd)
  call loop_A_Q(G0(:,:,:,12),Q(:,12),ZERO,G1(:,:,:,33))
  call loop_AV_Q(G1(:,:,:,33),wf(:,-5),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,44),ZERO,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,-4),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,60),ZERO,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,1),G3(:,:,:,66))
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,63),ZERO,G4tensor(:,45))
  call loop_AZ_Q(G3(:,:,:,65),wf(:,7),G3(:,:,:,67),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,67),Q(:,63),ZERO,G4tensor(:,46))
  call loop_AV_Q(G1(:,:,:,33),wf(:,-4),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,28),ZERO,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-5),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,60),ZERO,G3(:,:,:,68))
  call loop_AV_Q(G3(:,:,:,68),wf(:,1),G3(:,:,:,69))
  call check_last_A_Q(l_switch,G3(:,:,:,69),Q(:,63),ZERO,G4tensor(:,47))
  call loop_AZ_Q(G3(:,:,:,68),wf(:,7),G3(:,:,:,70),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,63),ZERO,G4tensor(:,48))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,13),gZd)
  call loop_A_Q(G0(:,:,:,13),Q(:,12),MB,G1(:,:,:,36))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-5),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,44),MB,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-4),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,60),MB,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,1),G3(:,:,:,72))
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,63),MB,G4tensor(:,49))
  call loop_AZ_Q(G3(:,:,:,71),wf(:,7),G3(:,:,:,73),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,73),Q(:,63),MB,G4tensor(:,50))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-4),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,28),MB,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-5),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,60),MB,G3(:,:,:,74))
  call loop_AV_Q(G3(:,:,:,74),wf(:,1),G3(:,:,:,75))
  call check_last_A_Q(l_switch,G3(:,:,:,75),Q(:,63),MB,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,74),wf(:,7),G3(:,:,:,76),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,63),MB,G4tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,16),ZERO,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,2),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,28),ZERO,G2(:,:,:,85))
  call loop_QV_A(G2(:,:,:,85),wf(:,-5),G2(:,:,:,86))
  call loop_Q_A(G2(:,:,:,86),Q(:,60),ZERO,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,1),G3(:,:,:,78))
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,63),ZERO,G4tensor(:,53))
  call loop_QZ_A(G3(:,:,:,77),wf(:,7),G3(:,:,:,79),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,79),Q(:,63),ZERO,G4tensor(:,54))
  call loop_QZ_A(G3(:,:,:,77),wf(:,7),G3(:,:,:,80),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,63),ZERO,G4tensor(:,55))
  call loop_QZ_A(G1(:,:,:,39),wf(:,5),G1(:,:,:,41),gZu)
  call loop_Q_A(G1(:,:,:,41),Q(:,28),ZERO,G2(:,:,:,87))
  call loop_QV_A(G2(:,:,:,87),wf(:,-5),G2(:,:,:,88))
  call loop_Q_A(G2(:,:,:,88),Q(:,60),ZERO,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,1),G3(:,:,:,82))
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,63),ZERO,G4tensor(:,56))
  call loop_QZ_A(G3(:,:,:,81),wf(:,7),G3(:,:,:,83),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,83),Q(:,63),ZERO,G4tensor(:,57))
  call loop_QZ_A(G1(:,:,:,39),wf(:,5),G1(:,:,:,42),gZd)
  call loop_Q_A(G1(:,:,:,42),Q(:,28),ZERO,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,-5),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,60),ZERO,G3(:,:,:,84))
  call loop_QV_A(G3(:,:,:,84),wf(:,1),G3(:,:,:,85))
  call check_last_Q_A(l_switch,G3(:,:,:,85),Q(:,63),ZERO,G4tensor(:,58))
  call loop_QZ_A(G3(:,:,:,84),wf(:,7),G3(:,:,:,86),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,63),ZERO,G4tensor(:,59))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,16),ZERO,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,2),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,28),ZERO,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-5),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,60),ZERO,G3(:,:,:,87))
  call loop_AV_Q(G3(:,:,:,87),wf(:,1),G3(:,:,:,88))
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,63),ZERO,G4tensor(:,60))
  call loop_AZ_Q(G3(:,:,:,87),wf(:,7),G3(:,:,:,89),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,89),Q(:,63),ZERO,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,87),wf(:,7),G3(:,:,:,90),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,63),ZERO,G4tensor(:,62))
  call loop_AZ_Q(G1(:,:,:,43),wf(:,5),G1(:,:,:,45),gZu)
  call loop_A_Q(G1(:,:,:,45),Q(:,28),ZERO,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-5),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,60),ZERO,G3(:,:,:,91))
  call loop_AV_Q(G3(:,:,:,91),wf(:,1),G3(:,:,:,92))
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,63),ZERO,G4tensor(:,63))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,7),G3(:,:,:,93),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,93),Q(:,63),ZERO,G4tensor(:,64))
  call loop_AZ_Q(G1(:,:,:,43),wf(:,5),G1(:,:,:,46),gZd)
  call loop_A_Q(G1(:,:,:,46),Q(:,28),ZERO,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,-5),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,60),ZERO,G3(:,:,:,94))
  call loop_AV_Q(G3(:,:,:,94),wf(:,1),G3(:,:,:,95))
  call check_last_A_Q(l_switch,G3(:,:,:,95),Q(:,63),ZERO,G4tensor(:,65))
  call loop_AZ_Q(G3(:,:,:,94),wf(:,7),G3(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,63),ZERO,G4tensor(:,66))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(14) * den(31)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(14) * den(31)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(3)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (-f(9) * den(3)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,15),T4sum(1:70,1))
  M(1) = M(1) + (-f(6) * den(3)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,21),T4sum(1:70,2))
  M(1) = M(1) + (-f(6) * den(3)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,15),T4sum(1:70,1))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,25),T4sum(1:70,2))
  M(1) = M(1) + (f(11) * den(5)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,29),T4sum(1:70,1))
  M(1) = M(1) + (f(11) * den(5)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,33),T4sum(1:70,1))
  M(1) = M(1) + (-f(8) * den(5)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,37),T4sum(1:70,1))
  M(1) = M(1) + (-f(7) * den(5)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,41),T4sum(1:70,2))
  M(1) = M(1) + (-f(8) * den(5)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,45),T4sum(1:70,1))
  M(1) = M(1) + (-f(7) * den(5)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,49),T4sum(1:70,2))
  M(1) = M(1) + (f(11) * den(7)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,10),T4sum(1:70,1))
  M(1) = M(1) + (f(11) * den(7)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,16),T4sum(1:70,1))
  M(1) = M(1) + (-f(8) * den(7)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,11),T4sum(1:70,1))
  M(1) = M(1) + (-f(7) * den(7)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,22),T4sum(1:70,2))
  M(1) = M(1) + (-f(8) * den(7)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,17),T4sum(1:70,1))
  M(1) = M(1) + (-f(7) * den(7)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,26),T4sum(1:70,2))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,30),T4sum(1:70,1))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,34),T4sum(1:70,1))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,38),T4sum(1:70,1))
  M(1) = M(1) + (-f(10) * den(8)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,42),T4sum(1:70,2))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,46),T4sum(1:70,1))
  M(1) = M(1) + (-f(10) * den(8)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,50),T4sum(1:70,2))
  M(1) = M(1) + (-f(9) * den(3)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,18),T4sum(1:70,3))
  M(1) = M(1) + (-f(9) * den(3)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,12),T4sum(1:70,3))
  M(1) = M(1) + (-f(6) * den(3)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,18),T4sum(1:70,3))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,27),T4sum(1:70,4))
  M(1) = M(1) + (-f(6) * den(3)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,12),T4sum(1:70,3))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,23),T4sum(1:70,4))
  M(1) = M(1) + (f(11) * den(5)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,35),T4sum(1:70,3))
  M(1) = M(1) + (f(11) * den(5)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,31),T4sum(1:70,3))
  M(1) = M(1) + (-f(8) * den(5)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,47),T4sum(1:70,3))
  M(1) = M(1) + (-f(7) * den(5)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,51),T4sum(1:70,4))
  M(1) = M(1) + (-f(8) * den(5)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,39),T4sum(1:70,3))
  M(1) = M(1) + (-f(7) * den(5)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,43),T4sum(1:70,4))
  M(1) = M(1) + (f(11) * den(7)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,19),T4sum(1:70,3))
  M(1) = M(1) + (f(11) * den(7)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,13),T4sum(1:70,3))
  M(1) = M(1) + (-f(8) * den(7)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,20),T4sum(1:70,3))
  M(1) = M(1) + (-f(7) * den(7)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,28),T4sum(1:70,4))
  M(1) = M(1) + (-f(8) * den(7)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,14),T4sum(1:70,3))
  M(1) = M(1) + (-f(7) * den(7)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,24),T4sum(1:70,4))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,36),T4sum(1:70,3))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,32),T4sum(1:70,3))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,48),T4sum(1:70,3))
  M(1) = M(1) + (-f(10) * den(8)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,52),T4sum(1:70,4))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,40),T4sum(1:70,3))
  M(1) = M(1) + (-f(10) * den(8)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,44),T4sum(1:70,4))
  M(1) = M(1) + (-f(9) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,53),T4sum(1:70,5))
  M(1) = M(1) + (-f(9) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,60),T4sum(1:70,5))
  M(1) = M(1) + (-f(6) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,53),T4sum(1:70,5))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,5),T4sum(1:70,6))
  M(1) = M(1) + (-f(6) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,60),T4sum(1:70,5))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,1),T4sum(1:70,6))
  M(1) = M(1) + (f(11) * den(5)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,56),T4sum(1:70,5))
  M(1) = M(1) + (f(11) * den(5)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,63),T4sum(1:70,5))
  M(1) = M(1) + (-f(8) * den(5)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,58),T4sum(1:70,5))
  M(1) = M(1) + (-f(7) * den(5)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,7),T4sum(1:70,6))
  M(1) = M(1) + (-f(8) * den(5)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,65),T4sum(1:70,5))
  M(1) = M(1) + (-f(7) * den(5)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,3),T4sum(1:70,6))
  M(1) = M(1) + (f(11) * den(7)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,54),T4sum(1:70,5))
  M(1) = M(1) + (f(11) * den(7)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,61),T4sum(1:70,5))
  M(1) = M(1) + (-f(8) * den(7)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,55),T4sum(1:70,5))
  M(1) = M(1) + (-f(7) * den(7)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,6),T4sum(1:70,6))
  M(1) = M(1) + (-f(8) * den(7)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,62),T4sum(1:70,5))
  M(1) = M(1) + (-f(7) * den(7)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,2),T4sum(1:70,6))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,57),T4sum(1:70,5))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,64),T4sum(1:70,5))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,59),T4sum(1:70,5))
  M(1) = M(1) + (-f(10) * den(8)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,8),T4sum(1:70,6))
  M(1) = M(1) + (-f(12) * den(8)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,66),T4sum(1:70,5))
  M(1) = M(1) + (-f(10) * den(8)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,4),T4sum(1:70,6))
  M(1) = M(1) + (-f(7) * den(33)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(33)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(40)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(40)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(43)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(43)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(44)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(44)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(46)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(46)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(47)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(47)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(48)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(48)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(51)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(51)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(53)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(53)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(54)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(54)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(55)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(55)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,1))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllll2_nf5_eexmmxgg_1_/**/REALKIND
