
module ol_vamp_1_ppllll2_nf5_eeexexgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll2_nf5_eeexexgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll2_nf5_eeexexgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllll2_nf5_eeexexgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllll2_nf5_eeexexgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,25) :: G0
  complex(REALKIND), dimension(4,5,4,86) :: G1
  complex(REALKIND), dimension(4,15,4,190) :: G2
  complex(REALKIND), dimension(4,35,4,192) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,68,64))
    allocate(G4tensorhel(70,132,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MB,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,48),MB,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,18),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MB,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,52),G2(:,:,:,3))
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),MB,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,54),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MB,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,55),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MB,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,57),G2(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MB,G3tensor(:,5))
  call loop_AV_Q(G2(:,:,:,1),wf(:,59),G2(:,:,:,7))
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),MB,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,61),G2(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MB,G3tensor(:,7))
  call loop_AV_Q(G2(:,:,:,1),wf(:,63),G2(:,:,:,9))
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),MB,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,65),G2(:,:,:,10),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),MB,G3tensor(:,9))
  call loop_AS_Q(G2(:,:,:,1),wf(:,30),G2(:,:,:,11),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,63),MB,G3tensor(:,10))
  call loop_AV_Q(G2(:,:,:,1),wf(:,66),G2(:,:,:,12))
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,63),MB,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,68),G2(:,:,:,13),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,63),MB,G3tensor(:,12))
  call loop_AV_Q(G2(:,:,:,1),wf(:,69),G2(:,:,:,14))
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,63),MB,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,71),G2(:,:,:,15),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,63),MB,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,1),wf(:,73),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,63),MB,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,1),wf(:,75),G2(:,:,:,17))
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,63),MB,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,77),G2(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,63),MB,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,79),G2(:,:,:,19),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,63),MB,G3tensor(:,18))
  call loop_AV_Q(G2(:,:,:,1),wf(:,80),G2(:,:,:,20))
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,63),MB,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,82),G2(:,:,:,21),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,63),MB,G3tensor(:,20))
  call loop_AV_Q(G2(:,:,:,1),wf(:,83),G2(:,:,:,22))
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MB,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,85),G2(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,63),MB,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,1),wf(:,87),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MB,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,89),G2(:,:,:,25),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,63),MB,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,1),wf(:,91),G2(:,:,:,26))
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,63),MB,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,93),G2(:,:,:,27),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,63),MB,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,1),wf(:,94),G2(:,:,:,28))
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,63),MB,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,96),G2(:,:,:,29),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,63),MB,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,1),wf(:,97),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,63),MB,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,99),G2(:,:,:,31),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,63),MB,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,1),wf(:,101),G2(:,:,:,32))
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),MB,G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,1),wf(:,103),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,63),MB,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,105),G2(:,:,:,34),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MB,G3tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,107),G2(:,:,:,35),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,63),MB,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,26),MB,G2(:,:,:,36))
  call loop_AV_Q(G2(:,:,:,36),wf(:,-5),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,58),MB,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MB,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,7),G3(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,63),MB,G4tensor(:,2))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,5),G1(:,:,:,4),gZd)
  call loop_A_Q(G1(:,:,:,4),Q(:,26),MB,G2(:,:,:,38))
  call loop_AV_Q(G2(:,:,:,38),wf(:,-5),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,58),MB,G3(:,:,:,4))
  call loop_AV_Q(G3(:,:,:,4),wf(:,1),G3(:,:,:,5))
  call check_last_A_Q(l_switch,G3(:,:,:,5),Q(:,63),MB,G4tensor(:,3))
  call loop_AZ_Q(G3(:,:,:,4),wf(:,7),G3(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),MB,G4tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,9),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,25),MB,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-5),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,57),MB,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,10),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,13),G3(:,:,:,9),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,63),MB,G4tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,15),G1(:,:,:,6),gZd)
  call loop_A_Q(G1(:,:,:,6),Q(:,25),MB,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,-5),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,57),MB,G3(:,:,:,10))
  call loop_AV_Q(G3(:,:,:,10),wf(:,10),G3(:,:,:,11))
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,63),MB,G4tensor(:,7))
  call loop_AZ_Q(G3(:,:,:,10),wf(:,13),G3(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,63),MB,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MB,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-5),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,48),MB,G2(:,:,:,44))
  call loop_QS_A(G2(:,:,:,44),wf(:,18),G2(:,:,:,45),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,45),Q(:,63),MB,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,44),wf(:,52),G2(:,:,:,46))
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,63),MB,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,44),wf(:,54),G2(:,:,:,47),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,63),MB,G3tensor(:,37))
  call loop_QV_A(G2(:,:,:,44),wf(:,55),G2(:,:,:,48))
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,63),MB,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,44),wf(:,57),G2(:,:,:,49),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,63),MB,G3tensor(:,39))
  call loop_QV_A(G2(:,:,:,44),wf(:,59),G2(:,:,:,50))
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,63),MB,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,44),wf(:,61),G2(:,:,:,51),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,63),MB,G3tensor(:,41))
  call loop_QV_A(G2(:,:,:,44),wf(:,63),G2(:,:,:,52))
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,63),MB,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,44),wf(:,65),G2(:,:,:,53),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,63),MB,G3tensor(:,43))
  call loop_QS_A(G2(:,:,:,44),wf(:,30),G2(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,63),MB,G3tensor(:,44))
  call loop_QV_A(G2(:,:,:,44),wf(:,66),G2(:,:,:,55))
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,63),MB,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,44),wf(:,68),G2(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,63),MB,G3tensor(:,46))
  call loop_QV_A(G2(:,:,:,44),wf(:,69),G2(:,:,:,57))
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,63),MB,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,44),wf(:,71),G2(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,63),MB,G3tensor(:,48))
  call loop_QV_A(G2(:,:,:,44),wf(:,73),G2(:,:,:,59))
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,63),MB,G3tensor(:,49))
  call loop_QV_A(G2(:,:,:,44),wf(:,75),G2(:,:,:,60))
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,63),MB,G3tensor(:,50))
  call loop_QZ_A(G2(:,:,:,44),wf(:,77),G2(:,:,:,61),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,63),MB,G3tensor(:,51))
  call loop_QZ_A(G2(:,:,:,44),wf(:,79),G2(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,63),MB,G3tensor(:,52))
  call loop_QV_A(G2(:,:,:,44),wf(:,80),G2(:,:,:,63))
  call check_last_Q_A(l_switch,G2(:,:,:,63),Q(:,63),MB,G3tensor(:,53))
  call loop_QZ_A(G2(:,:,:,44),wf(:,82),G2(:,:,:,64),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,64),Q(:,63),MB,G3tensor(:,54))
  call loop_QV_A(G2(:,:,:,44),wf(:,83),G2(:,:,:,65))
  call check_last_Q_A(l_switch,G2(:,:,:,65),Q(:,63),MB,G3tensor(:,55))
  call loop_QZ_A(G2(:,:,:,44),wf(:,85),G2(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,63),MB,G3tensor(:,56))
  call loop_QV_A(G2(:,:,:,44),wf(:,87),G2(:,:,:,67))
  call check_last_Q_A(l_switch,G2(:,:,:,67),Q(:,63),MB,G3tensor(:,57))
  call loop_QZ_A(G2(:,:,:,44),wf(:,89),G2(:,:,:,68),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,63),MB,G3tensor(:,58))
  call loop_QV_A(G2(:,:,:,44),wf(:,91),G2(:,:,:,69))
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,63),MB,G3tensor(:,59))
  call loop_QZ_A(G2(:,:,:,44),wf(:,93),G2(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,63),MB,G3tensor(:,60))
  call loop_QV_A(G2(:,:,:,44),wf(:,94),G2(:,:,:,71))
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,63),MB,G3tensor(:,61))
  call loop_QZ_A(G2(:,:,:,44),wf(:,96),G2(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,63),MB,G3tensor(:,62))
  call loop_QV_A(G2(:,:,:,44),wf(:,97),G2(:,:,:,73))
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,63),MB,G3tensor(:,63))
  call loop_QZ_A(G2(:,:,:,44),wf(:,99),G2(:,:,:,74),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,63),MB,G3tensor(:,64))
  call loop_QV_A(G2(:,:,:,44),wf(:,101),G2(:,:,:,75))
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,63),MB,G3tensor(:,65))
  call loop_QV_A(G2(:,:,:,44),wf(:,103),G2(:,:,:,76))
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,63),MB,G3tensor(:,66))
  call loop_QZ_A(G2(:,:,:,44),wf(:,105),G2(:,:,:,77),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,63),MB,G3tensor(:,67))
  call loop_QZ_A(G2(:,:,:,44),wf(:,107),G2(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,63),MB,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,7),wf(:,2),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,26),MB,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,-5),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,58),MB,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,63),MB,G4tensor(:,9))
  call loop_QZ_A(G3(:,:,:,13),wf(:,7),G3(:,:,:,15),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,63),MB,G4tensor(:,10))
  call loop_QZ_A(G1(:,:,:,7),wf(:,5),G1(:,:,:,10),gZd)
  call loop_Q_A(G1(:,:,:,10),Q(:,26),MB,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,-5),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,58),MB,G3(:,:,:,16))
  call loop_QV_A(G3(:,:,:,16),wf(:,1),G3(:,:,:,17))
  call check_last_Q_A(l_switch,G3(:,:,:,17),Q(:,63),MB,G4tensor(:,11))
  call loop_QZ_A(G3(:,:,:,16),wf(:,7),G3(:,:,:,18),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),MB,G4tensor(:,12))
  call loop_QV_A(G1(:,:,:,7),wf(:,9),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,25),MB,G2(:,:,:,83))
  call loop_QV_A(G2(:,:,:,83),wf(:,-5),G2(:,:,:,84))
  call loop_Q_A(G2(:,:,:,84),Q(:,57),MB,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,10),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),MB,G4tensor(:,13))
  call loop_QZ_A(G3(:,:,:,19),wf(:,13),G3(:,:,:,21),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,21),Q(:,63),MB,G4tensor(:,14))
  call loop_QZ_A(G1(:,:,:,7),wf(:,15),G1(:,:,:,12),gZd)
  call loop_Q_A(G1(:,:,:,12),Q(:,25),MB,G2(:,:,:,85))
  call loop_QV_A(G2(:,:,:,85),wf(:,-5),G2(:,:,:,86))
  call loop_Q_A(G2(:,:,:,86),Q(:,57),MB,G3(:,:,:,22))
  call loop_QV_A(G3(:,:,:,22),wf(:,10),G3(:,:,:,23))
  call check_last_Q_A(l_switch,G3(:,:,:,23),Q(:,63),MB,G4tensor(:,15))
  call loop_QZ_A(G3(:,:,:,22),wf(:,13),G3(:,:,:,24),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),MB,G4tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,10),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,-5),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,42),ZERO,G2(:,:,:,87))
  call loop_QV_A(G2(:,:,:,87),wf(:,-4),G2(:,:,:,88))
  call loop_Q_A(G2(:,:,:,88),Q(:,58),ZERO,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,1),G3(:,:,:,26))
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,63),ZERO,G4tensor(:,17))
  call loop_QZ_A(G3(:,:,:,25),wf(:,7),G3(:,:,:,27),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,27),Q(:,63),ZERO,G4tensor(:,18))
  call loop_QZ_A(G3(:,:,:,25),wf(:,7),G3(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,63),ZERO,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,13),wf(:,-4),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,26),ZERO,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,-5),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,58),ZERO,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,1),G3(:,:,:,30))
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,63),ZERO,G4tensor(:,20))
  call loop_QZ_A(G3(:,:,:,29),wf(:,7),G3(:,:,:,31),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,31),Q(:,63),ZERO,G4tensor(:,21))
  call loop_QZ_A(G3(:,:,:,29),wf(:,7),G3(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,63),ZERO,G4tensor(:,22))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,10),ZERO,G1(:,:,:,16))
  call loop_AV_Q(G1(:,:,:,16),wf(:,-5),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,42),ZERO,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-4),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,58),ZERO,G3(:,:,:,33))
  call loop_AV_Q(G3(:,:,:,33),wf(:,1),G3(:,:,:,34))
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),ZERO,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,33),wf(:,7),G3(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,63),ZERO,G4tensor(:,24))
  call loop_AZ_Q(G3(:,:,:,33),wf(:,7),G3(:,:,:,36),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,63),ZERO,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,16),wf(:,-4),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,26),ZERO,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-5),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,58),ZERO,G3(:,:,:,37))
  call loop_AV_Q(G3(:,:,:,37),wf(:,1),G3(:,:,:,38))
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,63),ZERO,G4tensor(:,26))
  call loop_AZ_Q(G3(:,:,:,37),wf(:,7),G3(:,:,:,39),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,39),Q(:,63),ZERO,G4tensor(:,27))
  call loop_AZ_Q(G3(:,:,:,37),wf(:,7),G3(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,63),ZERO,G4tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,10),MB,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,-5),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,42),MB,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,-4),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,58),MB,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,1),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),MB,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,41),wf(:,7),G3(:,:,:,43),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,43),Q(:,63),MB,G4tensor(:,30))
  call loop_QV_A(G1(:,:,:,19),wf(:,-4),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,26),MB,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,-5),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,58),MB,G3(:,:,:,44))
  call loop_QV_A(G3(:,:,:,44),wf(:,1),G3(:,:,:,45))
  call check_last_Q_A(l_switch,G3(:,:,:,45),Q(:,63),MB,G4tensor(:,31))
  call loop_QZ_A(G3(:,:,:,44),wf(:,7),G3(:,:,:,46),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,63),MB,G4tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,10),MB,G1(:,:,:,22))
  call loop_AV_Q(G1(:,:,:,22),wf(:,-5),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,42),MB,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-4),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,58),MB,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,1),G3(:,:,:,48))
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,63),MB,G4tensor(:,33))
  call loop_AZ_Q(G3(:,:,:,47),wf(:,7),G3(:,:,:,49),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,49),Q(:,63),MB,G4tensor(:,34))
  call loop_AV_Q(G1(:,:,:,22),wf(:,-4),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,26),MB,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,-5),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,58),MB,G3(:,:,:,50))
  call loop_AV_Q(G3(:,:,:,50),wf(:,1),G3(:,:,:,51))
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,63),MB,G4tensor(:,35))
  call loop_AZ_Q(G3(:,:,:,50),wf(:,7),G3(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,63),MB,G4tensor(:,36))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,8),gZu)
  call loop_Q_A(G0(:,:,:,8),Q(:,10),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,-5),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,42),ZERO,G2(:,:,:,103))
  call loop_QV_A(G2(:,:,:,103),wf(:,-4),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,58),ZERO,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,1),G3(:,:,:,54))
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,63),ZERO,G4tensor(:,37))
  call loop_QZ_A(G3(:,:,:,53),wf(:,7),G3(:,:,:,55),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,55),Q(:,63),ZERO,G4tensor(:,38))
  call loop_QV_A(G1(:,:,:,25),wf(:,-4),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,26),ZERO,G2(:,:,:,105))
  call loop_QV_A(G2(:,:,:,105),wf(:,-5),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,58),ZERO,G3(:,:,:,56))
  call loop_QV_A(G3(:,:,:,56),wf(:,1),G3(:,:,:,57))
  call check_last_Q_A(l_switch,G3(:,:,:,57),Q(:,63),ZERO,G4tensor(:,39))
  call loop_QZ_A(G3(:,:,:,56),wf(:,7),G3(:,:,:,58),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,63),ZERO,G4tensor(:,40))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,9),gZu)
  call loop_A_Q(G0(:,:,:,9),Q(:,10),ZERO,G1(:,:,:,28))
  call loop_AV_Q(G1(:,:,:,28),wf(:,-5),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,42),ZERO,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,-4),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,58),ZERO,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,1),G3(:,:,:,60))
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,63),ZERO,G4tensor(:,41))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,7),G3(:,:,:,61),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,61),Q(:,63),ZERO,G4tensor(:,42))
  call loop_AV_Q(G1(:,:,:,28),wf(:,-4),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,26),ZERO,G2(:,:,:,109))
  call loop_AV_Q(G2(:,:,:,109),wf(:,-5),G2(:,:,:,110))
  call loop_A_Q(G2(:,:,:,110),Q(:,58),ZERO,G3(:,:,:,62))
  call loop_AV_Q(G3(:,:,:,62),wf(:,1),G3(:,:,:,63))
  call check_last_A_Q(l_switch,G3(:,:,:,63),Q(:,63),ZERO,G4tensor(:,43))
  call loop_AZ_Q(G3(:,:,:,62),wf(:,7),G3(:,:,:,64),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,63),ZERO,G4tensor(:,44))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,10),gZd)
  call loop_Q_A(G0(:,:,:,10),Q(:,10),ZERO,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,-5),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,42),ZERO,G2(:,:,:,111))
  call loop_QV_A(G2(:,:,:,111),wf(:,-4),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,58),ZERO,G3(:,:,:,65))
  call loop_QV_A(G3(:,:,:,65),wf(:,1),G3(:,:,:,66))
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),ZERO,G4tensor(:,45))
  call loop_QZ_A(G3(:,:,:,65),wf(:,7),G3(:,:,:,67),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,67),Q(:,63),ZERO,G4tensor(:,46))
  call loop_QV_A(G1(:,:,:,31),wf(:,-4),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,26),ZERO,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,-5),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,58),ZERO,G3(:,:,:,68))
  call loop_QV_A(G3(:,:,:,68),wf(:,1),G3(:,:,:,69))
  call check_last_Q_A(l_switch,G3(:,:,:,69),Q(:,63),ZERO,G4tensor(:,47))
  call loop_QZ_A(G3(:,:,:,68),wf(:,7),G3(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,63),ZERO,G4tensor(:,48))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,11),gZd)
  call loop_Q_A(G0(:,:,:,11),Q(:,10),MB,G1(:,:,:,34))
  call loop_QV_A(G1(:,:,:,34),wf(:,-5),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,42),MB,G2(:,:,:,115))
  call loop_QV_A(G2(:,:,:,115),wf(:,-4),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,58),MB,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,1),G3(:,:,:,72))
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,63),MB,G4tensor(:,49))
  call loop_QZ_A(G3(:,:,:,71),wf(:,7),G3(:,:,:,73),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,73),Q(:,63),MB,G4tensor(:,50))
  call loop_QV_A(G1(:,:,:,34),wf(:,-4),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,26),MB,G2(:,:,:,117))
  call loop_QV_A(G2(:,:,:,117),wf(:,-5),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,58),MB,G3(:,:,:,74))
  call loop_QV_A(G3(:,:,:,74),wf(:,1),G3(:,:,:,75))
  call check_last_Q_A(l_switch,G3(:,:,:,75),Q(:,63),MB,G4tensor(:,51))
  call loop_QZ_A(G3(:,:,:,74),wf(:,7),G3(:,:,:,76),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,63),MB,G4tensor(:,52))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,12),gZd)
  call loop_A_Q(G0(:,:,:,12),Q(:,10),ZERO,G1(:,:,:,37))
  call loop_AV_Q(G1(:,:,:,37),wf(:,-5),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,42),ZERO,G2(:,:,:,119))
  call loop_AV_Q(G2(:,:,:,119),wf(:,-4),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,58),ZERO,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,1),G3(:,:,:,78))
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,63),ZERO,G4tensor(:,53))
  call loop_AZ_Q(G3(:,:,:,77),wf(:,7),G3(:,:,:,79),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,79),Q(:,63),ZERO,G4tensor(:,54))
  call loop_AV_Q(G1(:,:,:,37),wf(:,-4),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,26),ZERO,G2(:,:,:,121))
  call loop_AV_Q(G2(:,:,:,121),wf(:,-5),G2(:,:,:,122))
  call loop_A_Q(G2(:,:,:,122),Q(:,58),ZERO,G3(:,:,:,80))
  call loop_AV_Q(G3(:,:,:,80),wf(:,1),G3(:,:,:,81))
  call check_last_A_Q(l_switch,G3(:,:,:,81),Q(:,63),ZERO,G4tensor(:,55))
  call loop_AZ_Q(G3(:,:,:,80),wf(:,7),G3(:,:,:,82),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,63),ZERO,G4tensor(:,56))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,13),gZd)
  call loop_A_Q(G0(:,:,:,13),Q(:,10),MB,G1(:,:,:,40))
  call loop_AV_Q(G1(:,:,:,40),wf(:,-5),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,42),MB,G2(:,:,:,123))
  call loop_AV_Q(G2(:,:,:,123),wf(:,-4),G2(:,:,:,124))
  call loop_A_Q(G2(:,:,:,124),Q(:,58),MB,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,1),G3(:,:,:,84))
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,63),MB,G4tensor(:,57))
  call loop_AZ_Q(G3(:,:,:,83),wf(:,7),G3(:,:,:,85),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,85),Q(:,63),MB,G4tensor(:,58))
  call loop_AV_Q(G1(:,:,:,40),wf(:,-4),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,26),MB,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,-5),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,58),MB,G3(:,:,:,86))
  call loop_AV_Q(G3(:,:,:,86),wf(:,1),G3(:,:,:,87))
  call check_last_A_Q(l_switch,G3(:,:,:,87),Q(:,63),MB,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,86),wf(:,7),G3(:,:,:,88),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,63),MB,G4tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,16),ZERO,G1(:,:,:,43))
  call loop_QV_A(G1(:,:,:,43),wf(:,2),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,26),ZERO,G2(:,:,:,127))
  call loop_QV_A(G2(:,:,:,127),wf(:,-5),G2(:,:,:,128))
  call loop_Q_A(G2(:,:,:,128),Q(:,58),ZERO,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,1),G3(:,:,:,90))
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,63),ZERO,G4tensor(:,61))
  call loop_QZ_A(G3(:,:,:,89),wf(:,7),G3(:,:,:,91),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,91),Q(:,63),ZERO,G4tensor(:,62))
  call loop_QZ_A(G3(:,:,:,89),wf(:,7),G3(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,63),ZERO,G4tensor(:,63))
  call loop_QZ_A(G1(:,:,:,43),wf(:,5),G1(:,:,:,45),gZu)
  call loop_Q_A(G1(:,:,:,45),Q(:,26),ZERO,G2(:,:,:,129))
  call loop_QV_A(G2(:,:,:,129),wf(:,-5),G2(:,:,:,130))
  call loop_Q_A(G2(:,:,:,130),Q(:,58),ZERO,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,1),G3(:,:,:,94))
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,63),ZERO,G4tensor(:,64))
  call loop_QZ_A(G3(:,:,:,93),wf(:,7),G3(:,:,:,95),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,95),Q(:,63),ZERO,G4tensor(:,65))
  call loop_QZ_A(G1(:,:,:,43),wf(:,5),G1(:,:,:,46),gZd)
  call loop_Q_A(G1(:,:,:,46),Q(:,26),ZERO,G2(:,:,:,131))
  call loop_QV_A(G2(:,:,:,131),wf(:,-5),G2(:,:,:,132))
  call loop_Q_A(G2(:,:,:,132),Q(:,58),ZERO,G3(:,:,:,96))
  call loop_QV_A(G3(:,:,:,96),wf(:,1),G3(:,:,:,97))
  call check_last_Q_A(l_switch,G3(:,:,:,97),Q(:,63),ZERO,G4tensor(:,66))
  call loop_QZ_A(G3(:,:,:,96),wf(:,7),G3(:,:,:,98),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,63),ZERO,G4tensor(:,67))
  call loop_QV_A(G1(:,:,:,43),wf(:,9),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,25),ZERO,G2(:,:,:,133))
  call loop_QV_A(G2(:,:,:,133),wf(:,-5),G2(:,:,:,134))
  call loop_Q_A(G2(:,:,:,134),Q(:,57),ZERO,G3(:,:,:,99))
  call loop_QV_A(G3(:,:,:,99),wf(:,10),G3(:,:,:,100))
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,63),ZERO,G4tensor(:,68))
  call loop_QZ_A(G3(:,:,:,99),wf(:,13),G3(:,:,:,101),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,101),Q(:,63),ZERO,G4tensor(:,69))
  call loop_QZ_A(G3(:,:,:,99),wf(:,13),G3(:,:,:,102),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,63),ZERO,G4tensor(:,70))
  call loop_QZ_A(G1(:,:,:,43),wf(:,15),G1(:,:,:,48),gZu)
  call loop_Q_A(G1(:,:,:,48),Q(:,25),ZERO,G2(:,:,:,135))
  call loop_QV_A(G2(:,:,:,135),wf(:,-5),G2(:,:,:,136))
  call loop_Q_A(G2(:,:,:,136),Q(:,57),ZERO,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,10),G3(:,:,:,104))
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,63),ZERO,G4tensor(:,71))
  call loop_QZ_A(G3(:,:,:,103),wf(:,13),G3(:,:,:,105),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,105),Q(:,63),ZERO,G4tensor(:,72))
  call loop_QZ_A(G1(:,:,:,43),wf(:,15),G1(:,:,:,49),gZd)
  call loop_Q_A(G1(:,:,:,49),Q(:,25),ZERO,G2(:,:,:,137))
  call loop_QV_A(G2(:,:,:,137),wf(:,-5),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,57),ZERO,G3(:,:,:,106))
  call loop_QV_A(G3(:,:,:,106),wf(:,10),G3(:,:,:,107))
  call check_last_Q_A(l_switch,G3(:,:,:,107),Q(:,63),ZERO,G4tensor(:,73))
  call loop_QZ_A(G3(:,:,:,106),wf(:,13),G3(:,:,:,108),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,63),ZERO,G4tensor(:,74))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,16),ZERO,G1(:,:,:,50))
  call loop_AV_Q(G1(:,:,:,50),wf(:,2),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,26),ZERO,G2(:,:,:,139))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-5),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,58),ZERO,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,1),G3(:,:,:,110))
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,63),ZERO,G4tensor(:,75))
  call loop_AZ_Q(G3(:,:,:,109),wf(:,7),G3(:,:,:,111),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,111),Q(:,63),ZERO,G4tensor(:,76))
  call loop_AZ_Q(G3(:,:,:,109),wf(:,7),G3(:,:,:,112),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,112),Q(:,63),ZERO,G4tensor(:,77))
  call loop_AZ_Q(G1(:,:,:,50),wf(:,5),G1(:,:,:,52),gZu)
  call loop_A_Q(G1(:,:,:,52),Q(:,26),ZERO,G2(:,:,:,141))
  call loop_AV_Q(G2(:,:,:,141),wf(:,-5),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,58),ZERO,G3(:,:,:,113))
  call loop_AV_Q(G3(:,:,:,113),wf(:,1),G3(:,:,:,114))
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,63),ZERO,G4tensor(:,78))
  call loop_AZ_Q(G3(:,:,:,113),wf(:,7),G3(:,:,:,115),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,115),Q(:,63),ZERO,G4tensor(:,79))
  call loop_AZ_Q(G1(:,:,:,50),wf(:,5),G1(:,:,:,53),gZd)
  call loop_A_Q(G1(:,:,:,53),Q(:,26),ZERO,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-5),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,58),ZERO,G3(:,:,:,116))
  call loop_AV_Q(G3(:,:,:,116),wf(:,1),G3(:,:,:,117))
  call check_last_A_Q(l_switch,G3(:,:,:,117),Q(:,63),ZERO,G4tensor(:,80))
  call loop_AZ_Q(G3(:,:,:,116),wf(:,7),G3(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,118),Q(:,63),ZERO,G4tensor(:,81))
  call loop_AV_Q(G1(:,:,:,50),wf(:,9),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,25),ZERO,G2(:,:,:,145))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-5),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,57),ZERO,G3(:,:,:,119))
  call loop_AV_Q(G3(:,:,:,119),wf(:,10),G3(:,:,:,120))
  call check_last_A_Q(l_switch,G3(:,:,:,120),Q(:,63),ZERO,G4tensor(:,82))
  call loop_AZ_Q(G3(:,:,:,119),wf(:,13),G3(:,:,:,121),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,121),Q(:,63),ZERO,G4tensor(:,83))
  call loop_AZ_Q(G3(:,:,:,119),wf(:,13),G3(:,:,:,122),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,63),ZERO,G4tensor(:,84))
  call loop_AZ_Q(G1(:,:,:,50),wf(:,15),G1(:,:,:,55),gZu)
  call loop_A_Q(G1(:,:,:,55),Q(:,25),ZERO,G2(:,:,:,147))
  call loop_AV_Q(G2(:,:,:,147),wf(:,-5),G2(:,:,:,148))
  call loop_A_Q(G2(:,:,:,148),Q(:,57),ZERO,G3(:,:,:,123))
  call loop_AV_Q(G3(:,:,:,123),wf(:,10),G3(:,:,:,124))
  call check_last_A_Q(l_switch,G3(:,:,:,124),Q(:,63),ZERO,G4tensor(:,85))
  call loop_AZ_Q(G3(:,:,:,123),wf(:,13),G3(:,:,:,125),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,125),Q(:,63),ZERO,G4tensor(:,86))
  call loop_AZ_Q(G1(:,:,:,50),wf(:,15),G1(:,:,:,56),gZd)
  call loop_A_Q(G1(:,:,:,56),Q(:,25),ZERO,G2(:,:,:,149))
  call loop_AV_Q(G2(:,:,:,149),wf(:,-5),G2(:,:,:,150))
  call loop_A_Q(G2(:,:,:,150),Q(:,57),ZERO,G3(:,:,:,126))
  call loop_AV_Q(G3(:,:,:,126),wf(:,10),G3(:,:,:,127))
  call check_last_A_Q(l_switch,G3(:,:,:,127),Q(:,63),ZERO,G4tensor(:,87))
  call loop_AZ_Q(G3(:,:,:,126),wf(:,13),G3(:,:,:,128),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,128),Q(:,63),ZERO,G4tensor(:,88))
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,9),ZERO,G1(:,:,:,57))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-4),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,25),ZERO,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-5),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,57),ZERO,G3(:,:,:,129))
  call loop_AV_Q(G3(:,:,:,129),wf(:,10),G3(:,:,:,130))
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,63),ZERO,G4tensor(:,89))
  call loop_AZ_Q(G3(:,:,:,129),wf(:,13),G3(:,:,:,131),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,131),Q(:,63),ZERO,G4tensor(:,90))
  call loop_AZ_Q(G3(:,:,:,129),wf(:,13),G3(:,:,:,132),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,63),ZERO,G4tensor(:,91))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-5),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,41),ZERO,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-4),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,57),ZERO,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,10),G3(:,:,:,134))
  call check_last_A_Q(l_switch,G3(:,:,:,134),Q(:,63),ZERO,G4tensor(:,92))
  call loop_AZ_Q(G3(:,:,:,133),wf(:,13),G3(:,:,:,135),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,135),Q(:,63),ZERO,G4tensor(:,93))
  call loop_AZ_Q(G3(:,:,:,133),wf(:,13),G3(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,63),ZERO,G4tensor(:,94))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,9),ZERO,G1(:,:,:,60))
  call loop_QV_A(G1(:,:,:,60),wf(:,-4),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,25),ZERO,G2(:,:,:,155))
  call loop_QV_A(G2(:,:,:,155),wf(:,-5),G2(:,:,:,156))
  call loop_Q_A(G2(:,:,:,156),Q(:,57),ZERO,G3(:,:,:,137))
  call loop_QV_A(G3(:,:,:,137),wf(:,10),G3(:,:,:,138))
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,63),ZERO,G4tensor(:,95))
  call loop_QZ_A(G3(:,:,:,137),wf(:,13),G3(:,:,:,139),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,139),Q(:,63),ZERO,G4tensor(:,96))
  call loop_QZ_A(G3(:,:,:,137),wf(:,13),G3(:,:,:,140),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,63),ZERO,G4tensor(:,97))
  call loop_QV_A(G1(:,:,:,60),wf(:,-5),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,41),ZERO,G2(:,:,:,157))
  call loop_QV_A(G2(:,:,:,157),wf(:,-4),G2(:,:,:,158))
  call loop_Q_A(G2(:,:,:,158),Q(:,57),ZERO,G3(:,:,:,141))
  call loop_QV_A(G3(:,:,:,141),wf(:,10),G3(:,:,:,142))
  call check_last_Q_A(l_switch,G3(:,:,:,142),Q(:,63),ZERO,G4tensor(:,98))
  call loop_QZ_A(G3(:,:,:,141),wf(:,13),G3(:,:,:,143),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,143),Q(:,63),ZERO,G4tensor(:,99))
  call loop_QZ_A(G3(:,:,:,141),wf(:,13),G3(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,144),Q(:,63),ZERO,G4tensor(:,100))
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,9),MB,G1(:,:,:,63))
  call loop_AV_Q(G1(:,:,:,63),wf(:,-4),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,25),MB,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-5),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,57),MB,G3(:,:,:,145))
  call loop_AV_Q(G3(:,:,:,145),wf(:,10),G3(:,:,:,146))
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,63),MB,G4tensor(:,101))
  call loop_AZ_Q(G3(:,:,:,145),wf(:,13),G3(:,:,:,147),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,147),Q(:,63),MB,G4tensor(:,102))
  call loop_AV_Q(G1(:,:,:,63),wf(:,-5),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,41),MB,G2(:,:,:,161))
  call loop_AV_Q(G2(:,:,:,161),wf(:,-4),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,57),MB,G3(:,:,:,148))
  call loop_AV_Q(G3(:,:,:,148),wf(:,10),G3(:,:,:,149))
  call check_last_A_Q(l_switch,G3(:,:,:,149),Q(:,63),MB,G4tensor(:,103))
  call loop_AZ_Q(G3(:,:,:,148),wf(:,13),G3(:,:,:,150),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,150),Q(:,63),MB,G4tensor(:,104))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,9),MB,G1(:,:,:,66))
  call loop_QV_A(G1(:,:,:,66),wf(:,-4),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,25),MB,G2(:,:,:,163))
  call loop_QV_A(G2(:,:,:,163),wf(:,-5),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,57),MB,G3(:,:,:,151))
  call loop_QV_A(G3(:,:,:,151),wf(:,10),G3(:,:,:,152))
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,63),MB,G4tensor(:,105))
  call loop_QZ_A(G3(:,:,:,151),wf(:,13),G3(:,:,:,153),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,153),Q(:,63),MB,G4tensor(:,106))
  call loop_QV_A(G1(:,:,:,66),wf(:,-5),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,41),MB,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,-4),G2(:,:,:,166))
  call loop_Q_A(G2(:,:,:,166),Q(:,57),MB,G3(:,:,:,154))
  call loop_QV_A(G3(:,:,:,154),wf(:,10),G3(:,:,:,155))
  call check_last_Q_A(l_switch,G3(:,:,:,155),Q(:,63),MB,G4tensor(:,107))
  call loop_QZ_A(G3(:,:,:,154),wf(:,13),G3(:,:,:,156),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,63),MB,G4tensor(:,108))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,20),gZu)
  call loop_A_Q(G0(:,:,:,20),Q(:,9),ZERO,G1(:,:,:,69))
  call loop_AV_Q(G1(:,:,:,69),wf(:,-4),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,25),ZERO,G2(:,:,:,167))
  call loop_AV_Q(G2(:,:,:,167),wf(:,-5),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,57),ZERO,G3(:,:,:,157))
  call loop_AV_Q(G3(:,:,:,157),wf(:,10),G3(:,:,:,158))
  call check_last_A_Q(l_switch,G3(:,:,:,158),Q(:,63),ZERO,G4tensor(:,109))
  call loop_AZ_Q(G3(:,:,:,157),wf(:,13),G3(:,:,:,159),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,159),Q(:,63),ZERO,G4tensor(:,110))
  call loop_AV_Q(G1(:,:,:,69),wf(:,-5),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,41),ZERO,G2(:,:,:,169))
  call loop_AV_Q(G2(:,:,:,169),wf(:,-4),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,57),ZERO,G3(:,:,:,160))
  call loop_AV_Q(G3(:,:,:,160),wf(:,10),G3(:,:,:,161))
  call check_last_A_Q(l_switch,G3(:,:,:,161),Q(:,63),ZERO,G4tensor(:,111))
  call loop_AZ_Q(G3(:,:,:,160),wf(:,13),G3(:,:,:,162),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,63),ZERO,G4tensor(:,112))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,21),gZu)
  call loop_Q_A(G0(:,:,:,21),Q(:,9),ZERO,G1(:,:,:,72))
  call loop_QV_A(G1(:,:,:,72),wf(:,-4),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,25),ZERO,G2(:,:,:,171))
  call loop_QV_A(G2(:,:,:,171),wf(:,-5),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,57),ZERO,G3(:,:,:,163))
  call loop_QV_A(G3(:,:,:,163),wf(:,10),G3(:,:,:,164))
  call check_last_Q_A(l_switch,G3(:,:,:,164),Q(:,63),ZERO,G4tensor(:,113))
  call loop_QZ_A(G3(:,:,:,163),wf(:,13),G3(:,:,:,165),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,165),Q(:,63),ZERO,G4tensor(:,114))
  call loop_QV_A(G1(:,:,:,72),wf(:,-5),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,41),ZERO,G2(:,:,:,173))
  call loop_QV_A(G2(:,:,:,173),wf(:,-4),G2(:,:,:,174))
  call loop_Q_A(G2(:,:,:,174),Q(:,57),ZERO,G3(:,:,:,166))
  call loop_QV_A(G3(:,:,:,166),wf(:,10),G3(:,:,:,167))
  call check_last_Q_A(l_switch,G3(:,:,:,167),Q(:,63),ZERO,G4tensor(:,115))
  call loop_QZ_A(G3(:,:,:,166),wf(:,13),G3(:,:,:,168),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,63),ZERO,G4tensor(:,116))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,22),gZd)
  call loop_A_Q(G0(:,:,:,22),Q(:,9),ZERO,G1(:,:,:,75))
  call loop_AV_Q(G1(:,:,:,75),wf(:,-4),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,25),ZERO,G2(:,:,:,175))
  call loop_AV_Q(G2(:,:,:,175),wf(:,-5),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,57),ZERO,G3(:,:,:,169))
  call loop_AV_Q(G3(:,:,:,169),wf(:,10),G3(:,:,:,170))
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,63),ZERO,G4tensor(:,117))
  call loop_AZ_Q(G3(:,:,:,169),wf(:,13),G3(:,:,:,171),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,171),Q(:,63),ZERO,G4tensor(:,118))
  call loop_AV_Q(G1(:,:,:,75),wf(:,-5),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,41),ZERO,G2(:,:,:,177))
  call loop_AV_Q(G2(:,:,:,177),wf(:,-4),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,57),ZERO,G3(:,:,:,172))
  call loop_AV_Q(G3(:,:,:,172),wf(:,10),G3(:,:,:,173))
  call check_last_A_Q(l_switch,G3(:,:,:,173),Q(:,63),ZERO,G4tensor(:,119))
  call loop_AZ_Q(G3(:,:,:,172),wf(:,13),G3(:,:,:,174),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,174),Q(:,63),ZERO,G4tensor(:,120))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,23),gZd)
  call loop_A_Q(G0(:,:,:,23),Q(:,9),MB,G1(:,:,:,78))
  call loop_AV_Q(G1(:,:,:,78),wf(:,-4),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,25),MB,G2(:,:,:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,-5),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,57),MB,G3(:,:,:,175))
  call loop_AV_Q(G3(:,:,:,175),wf(:,10),G3(:,:,:,176))
  call check_last_A_Q(l_switch,G3(:,:,:,176),Q(:,63),MB,G4tensor(:,121))
  call loop_AZ_Q(G3(:,:,:,175),wf(:,13),G3(:,:,:,177),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,177),Q(:,63),MB,G4tensor(:,122))
  call loop_AV_Q(G1(:,:,:,78),wf(:,-5),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,41),MB,G2(:,:,:,181))
  call loop_AV_Q(G2(:,:,:,181),wf(:,-4),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,57),MB,G3(:,:,:,178))
  call loop_AV_Q(G3(:,:,:,178),wf(:,10),G3(:,:,:,179))
  call check_last_A_Q(l_switch,G3(:,:,:,179),Q(:,63),MB,G4tensor(:,123))
  call loop_AZ_Q(G3(:,:,:,178),wf(:,13),G3(:,:,:,180),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,180),Q(:,63),MB,G4tensor(:,124))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,24),gZd)
  call loop_Q_A(G0(:,:,:,24),Q(:,9),ZERO,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,-4),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,25),ZERO,G2(:,:,:,183))
  call loop_QV_A(G2(:,:,:,183),wf(:,-5),G2(:,:,:,184))
  call loop_Q_A(G2(:,:,:,184),Q(:,57),ZERO,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,10),G3(:,:,:,182))
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,63),ZERO,G4tensor(:,125))
  call loop_QZ_A(G3(:,:,:,181),wf(:,13),G3(:,:,:,183),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,183),Q(:,63),ZERO,G4tensor(:,126))
  call loop_QV_A(G1(:,:,:,81),wf(:,-5),G1(:,:,:,83))
  call loop_Q_A(G1(:,:,:,83),Q(:,41),ZERO,G2(:,:,:,185))
  call loop_QV_A(G2(:,:,:,185),wf(:,-4),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,57),ZERO,G3(:,:,:,184))
  call loop_QV_A(G3(:,:,:,184),wf(:,10),G3(:,:,:,185))
  call check_last_Q_A(l_switch,G3(:,:,:,185),Q(:,63),ZERO,G4tensor(:,127))
  call loop_QZ_A(G3(:,:,:,184),wf(:,13),G3(:,:,:,186),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,63),ZERO,G4tensor(:,128))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,25),gZd)
  call loop_Q_A(G0(:,:,:,25),Q(:,9),MB,G1(:,:,:,84))
  call loop_QV_A(G1(:,:,:,84),wf(:,-4),G1(:,:,:,85))
  call loop_Q_A(G1(:,:,:,85),Q(:,25),MB,G2(:,:,:,187))
  call loop_QV_A(G2(:,:,:,187),wf(:,-5),G2(:,:,:,188))
  call loop_Q_A(G2(:,:,:,188),Q(:,57),MB,G3(:,:,:,187))
  call loop_QV_A(G3(:,:,:,187),wf(:,10),G3(:,:,:,188))
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,63),MB,G4tensor(:,129))
  call loop_QZ_A(G3(:,:,:,187),wf(:,13),G3(:,:,:,189),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,189),Q(:,63),MB,G4tensor(:,130))
  call loop_QV_A(G1(:,:,:,84),wf(:,-5),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,41),MB,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,-4),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,57),MB,G3(:,:,:,190))
  call loop_QV_A(G3(:,:,:,190),wf(:,10),G3(:,:,:,191))
  call check_last_Q_A(l_switch,G3(:,:,:,191),Q(:,63),MB,G4tensor(:,131))
  call loop_QZ_A(G3(:,:,:,190),wf(:,13),G3(:,:,:,192),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,192),Q(:,63),MB,G4tensor(:,132))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-f(14) * den(52)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-f(14) * den(52)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,1))
  M(1) = M(1) + (f(9) * den(3)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,17),T4sum(1:70,1))
  M(1) = M(1) + (f(9) * den(3)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,23),T4sum(1:70,1))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,17),T4sum(1:70,1))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,29),T4sum(1:70,2))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,23),T4sum(1:70,1))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,33),T4sum(1:70,2))
  M(1) = M(1) + (-f(11) * den(5)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,37),T4sum(1:70,1))
  M(1) = M(1) + (-f(11) * den(5)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,41),T4sum(1:70,1))
  M(1) = M(1) + (f(8) * den(5)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,45),T4sum(1:70,1))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,49),T4sum(1:70,2))
  M(1) = M(1) + (f(8) * den(5)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,53),T4sum(1:70,1))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,57),T4sum(1:70,2))
  M(1) = M(1) + (-f(11) * den(7)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,18),T4sum(1:70,1))
  M(1) = M(1) + (-f(11) * den(7)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,24),T4sum(1:70,1))
  M(1) = M(1) + (f(8) * den(7)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,19),T4sum(1:70,1))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,30),T4sum(1:70,2))
  M(1) = M(1) + (f(8) * den(7)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,25),T4sum(1:70,1))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,34),T4sum(1:70,2))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,38),T4sum(1:70,1))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,42),T4sum(1:70,1))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,46),T4sum(1:70,1))
  M(1) = M(1) + (f(10) * den(8)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,50),T4sum(1:70,2))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,54),T4sum(1:70,1))
  M(1) = M(1) + (f(10) * den(8)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,58),T4sum(1:70,2))
  M(1) = M(1) + (f(9) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,26),T4sum(1:70,3))
  M(1) = M(1) + (f(9) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,20),T4sum(1:70,3))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,26),T4sum(1:70,3))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,35),T4sum(1:70,4))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,20),T4sum(1:70,3))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,31),T4sum(1:70,4))
  M(1) = M(1) + (-f(11) * den(5)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,43),T4sum(1:70,3))
  M(1) = M(1) + (-f(11) * den(5)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,39),T4sum(1:70,3))
  M(1) = M(1) + (f(8) * den(5)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,55),T4sum(1:70,3))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,59),T4sum(1:70,4))
  M(1) = M(1) + (f(8) * den(5)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,47),T4sum(1:70,3))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,51),T4sum(1:70,4))
  M(1) = M(1) + (-f(11) * den(7)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,27),T4sum(1:70,3))
  M(1) = M(1) + (-f(11) * den(7)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,21),T4sum(1:70,3))
  M(1) = M(1) + (f(8) * den(7)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,28),T4sum(1:70,3))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,36),T4sum(1:70,4))
  M(1) = M(1) + (f(8) * den(7)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,22),T4sum(1:70,3))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,32),T4sum(1:70,4))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,44),T4sum(1:70,3))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,40),T4sum(1:70,3))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,56),T4sum(1:70,3))
  M(1) = M(1) + (f(10) * den(8)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,60),T4sum(1:70,4))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,48),T4sum(1:70,3))
  M(1) = M(1) + (f(10) * den(8)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,52),T4sum(1:70,4))
  M(1) = M(1) + (f(9) * den(3)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,61),T4sum(1:70,5))
  M(1) = M(1) + (f(9) * den(3)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,75),T4sum(1:70,5))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,61),T4sum(1:70,5))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,9),T4sum(1:70,6))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,75),T4sum(1:70,5))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,1),T4sum(1:70,6))
  M(1) = M(1) + (-f(11) * den(5)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,64),T4sum(1:70,5))
  M(1) = M(1) + (-f(11) * den(5)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,78),T4sum(1:70,5))
  M(1) = M(1) + (f(8) * den(5)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,66),T4sum(1:70,5))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,11),T4sum(1:70,6))
  M(1) = M(1) + (f(8) * den(5)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,80),T4sum(1:70,5))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,3),T4sum(1:70,6))
  M(1) = M(1) + (-f(11) * den(7)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,62),T4sum(1:70,5))
  M(1) = M(1) + (-f(11) * den(7)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,76),T4sum(1:70,5))
  M(1) = M(1) + (f(8) * den(7)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,63),T4sum(1:70,5))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,10),T4sum(1:70,6))
  M(1) = M(1) + (f(8) * den(7)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,77),T4sum(1:70,5))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,2),T4sum(1:70,6))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,65),T4sum(1:70,5))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,79),T4sum(1:70,5))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,67),T4sum(1:70,5))
  M(1) = M(1) + (f(10) * den(8)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,12),T4sum(1:70,6))
  M(1) = M(1) + (f(12) * den(8)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,81),T4sum(1:70,5))
  M(1) = M(1) + (f(10) * den(8)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,4),T4sum(1:70,6))
  M(1) = M(1) + (f(7) * den(54)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(54)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(57)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(57)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(58)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(58)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(64)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(64)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,1))
  M(1) = M(1) + (f(14) * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(14) * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(11)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,89),T4sum(1:70,7))
  M(1) = M(1) + (-f(9) * den(11)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,95),T4sum(1:70,7))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,89),T4sum(1:70,7))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,101),T4sum(1:70,8))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,95),T4sum(1:70,7))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,105),T4sum(1:70,8))
  M(1) = M(1) + (f(11) * den(13)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,90),T4sum(1:70,7))
  M(1) = M(1) + (f(11) * den(13)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,96),T4sum(1:70,7))
  M(1) = M(1) + (-f(8) * den(13)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,91),T4sum(1:70,7))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,102),T4sum(1:70,8))
  M(1) = M(1) + (-f(8) * den(13)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,97),T4sum(1:70,7))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,106),T4sum(1:70,8))
  M(1) = M(1) + (f(11) * den(15)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,109),T4sum(1:70,7))
  M(1) = M(1) + (f(11) * den(15)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,113),T4sum(1:70,7))
  M(1) = M(1) + (-f(8) * den(15)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,117),T4sum(1:70,7))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,121),T4sum(1:70,8))
  M(1) = M(1) + (-f(8) * den(15)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,125),T4sum(1:70,7))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,129),T4sum(1:70,8))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,110),T4sum(1:70,7))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,114),T4sum(1:70,7))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,118),T4sum(1:70,7))
  M(1) = M(1) + (-f(10) * den(16)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,122),T4sum(1:70,8))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,126),T4sum(1:70,7))
  M(1) = M(1) + (-f(10) * den(16)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,130),T4sum(1:70,8))
  M(1) = M(1) + (-f(9) * den(11)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,98),T4sum(1:70,9))
  M(1) = M(1) + (-f(9) * den(11)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,92),T4sum(1:70,9))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,98),T4sum(1:70,9))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,107),T4sum(1:70,10))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,92),T4sum(1:70,9))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,103),T4sum(1:70,10))
  M(1) = M(1) + (f(11) * den(13)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,99),T4sum(1:70,9))
  M(1) = M(1) + (f(11) * den(13)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,93),T4sum(1:70,9))
  M(1) = M(1) + (-f(8) * den(13)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,100),T4sum(1:70,9))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,108),T4sum(1:70,10))
  M(1) = M(1) + (-f(8) * den(13)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,94),T4sum(1:70,9))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,104),T4sum(1:70,10))
  M(1) = M(1) + (f(11) * den(15)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,115),T4sum(1:70,9))
  M(1) = M(1) + (f(11) * den(15)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,111),T4sum(1:70,9))
  M(1) = M(1) + (-f(8) * den(15)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,127),T4sum(1:70,9))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,131),T4sum(1:70,10))
  M(1) = M(1) + (-f(8) * den(15)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,119),T4sum(1:70,9))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,123),T4sum(1:70,10))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,116),T4sum(1:70,9))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,112),T4sum(1:70,9))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,128),T4sum(1:70,9))
  M(1) = M(1) + (-f(10) * den(16)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,132),T4sum(1:70,10))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,120),T4sum(1:70,9))
  M(1) = M(1) + (-f(10) * den(16)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,124),T4sum(1:70,10))
  M(1) = M(1) + (-f(9) * den(11)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,82),T4sum(1:70,11))
  M(1) = M(1) + (-f(9) * den(11)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,68),T4sum(1:70,11))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,82),T4sum(1:70,11))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,5),T4sum(1:70,12))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,68),T4sum(1:70,11))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,13),T4sum(1:70,12))
  M(1) = M(1) + (f(11) * den(13)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,83),T4sum(1:70,11))
  M(1) = M(1) + (f(11) * den(13)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,69),T4sum(1:70,11))
  M(1) = M(1) + (-f(8) * den(13)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,84),T4sum(1:70,11))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,6),T4sum(1:70,12))
  M(1) = M(1) + (-f(8) * den(13)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,70),T4sum(1:70,11))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,14),T4sum(1:70,12))
  M(1) = M(1) + (f(11) * den(15)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,85),T4sum(1:70,11))
  M(1) = M(1) + (f(11) * den(15)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,71),T4sum(1:70,11))
  M(1) = M(1) + (-f(8) * den(15)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,87),T4sum(1:70,11))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,7),T4sum(1:70,12))
  M(1) = M(1) + (-f(8) * den(15)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,73),T4sum(1:70,11))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,15),T4sum(1:70,12))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,86),T4sum(1:70,11))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,72),T4sum(1:70,11))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,88),T4sum(1:70,11))
  M(1) = M(1) + (-f(10) * den(16)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,8),T4sum(1:70,12))
  M(1) = M(1) + (-f(12) * den(16)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,74),T4sum(1:70,11))
  M(1) = M(1) + (-f(10) * den(16)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,16),T4sum(1:70,12))
  M(1) = M(1) + (-f(7) * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(68)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(68)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,46),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(69)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(69)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,47),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,48),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,49),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(75)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(75)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,50),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,51),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(77)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(77)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,52),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,53),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,54),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,55),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(81)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(81)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,56),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(83)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(83)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,57),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(84)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(84)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,58),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,59),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,1))
  M(1) = M(1) + (-f(10) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,60),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,61),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(89)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(89)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,62),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(90)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(90)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,63),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(91)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(91)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,64),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(93)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(93)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,65),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(95)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(95)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,66),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(96)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(96)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,67),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(97)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,1))
  M(1) = M(1) + (f(10) * den(97)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,68),T3sum(1:35,1))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllll2_nf5_eeexexgg_1_/**/REALKIND
