
module ol_vamp_1_ppllll2_nexnmemxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll2_nexnmemxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll2_nexnmemxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllll2_nexnmemxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllll2_nexnmemxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,11) :: G0
  complex(REALKIND), dimension(4,5,4,26) :: G1
  complex(REALKIND), dimension(4,15,4,64) :: G2
  complex(REALKIND), dimension(4,35,4,24) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,36,64))
    allocate(G4tensorhel(70,12,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,48),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,7),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,10),G2(:,:,:,3))
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),MT,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,23),G2(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,24),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MT,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,26),G2(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,29),G2(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),MT,G3tensor(:,6))
  call loop_AV_Q(G2(:,:,:,1),wf(:,30),G2(:,:,:,8))
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,32),G2(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),MT,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,35),G2(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,9))
  call loop_AW_Q(G1(:,:,:,1),wf(:,4),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,26),MB,G2(:,:,:,11))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-5),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,58),MB,G3(:,:,:,1))
  call loop_AW_Q(G3(:,:,:,1),wf(:,3),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,-5),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,48),MT,G2(:,:,:,13))
  call loop_QS_A(G2(:,:,:,13),wf(:,7),G2(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G2(:,:,:,13),wf(:,10),G2(:,:,:,15))
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,63),MT,G3tensor(:,11))
  call loop_QZ_A(G2(:,:,:,13),wf(:,23),G2(:,:,:,16),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,12))
  call loop_QV_A(G2(:,:,:,13),wf(:,24),G2(:,:,:,17))
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,63),MT,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,13),wf(:,26),G2(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),MT,G3tensor(:,14))
  call loop_QZ_A(G2(:,:,:,13),wf(:,29),G2(:,:,:,19),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,63),MT,G3tensor(:,15))
  call loop_QV_A(G2(:,:,:,13),wf(:,30),G2(:,:,:,20))
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MT,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,13),wf(:,32),G2(:,:,:,21),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,21),Q(:,63),MT,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,13),wf(:,35),G2(:,:,:,22),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,18))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,16),MB,G1(:,:,:,6))
  call loop_AV_Q(G1(:,:,:,6),wf(:,-5),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,48),MB,G2(:,:,:,23))
  call loop_AS_Q(G2(:,:,:,23),wf(:,7),G2(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MB,G3tensor(:,19))
  call loop_AV_Q(G2(:,:,:,23),wf(:,10),G2(:,:,:,25))
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,63),MB,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,23),G2(:,:,:,26),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,63),MB,G3tensor(:,21))
  call loop_AV_Q(G2(:,:,:,23),wf(:,24),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,63),MB,G3tensor(:,22))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,26),G2(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,63),MB,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,29),G2(:,:,:,29),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,63),MB,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,23),wf(:,30),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,63),MB,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,32),G2(:,:,:,31),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,63),MB,G3tensor(:,26))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,35),G2(:,:,:,32),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),MB,G3tensor(:,27))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,16),MB,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,-5),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,48),MB,G2(:,:,:,33))
  call loop_QS_A(G2(:,:,:,33),wf(:,7),G2(:,:,:,34),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,63),MB,G3tensor(:,28))
  call loop_QV_A(G2(:,:,:,33),wf(:,10),G2(:,:,:,35))
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,63),MB,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,33),wf(:,23),G2(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,63),MB,G3tensor(:,30))
  call loop_QV_A(G2(:,:,:,33),wf(:,24),G2(:,:,:,37))
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,63),MB,G3tensor(:,31))
  call loop_QZ_A(G2(:,:,:,33),wf(:,26),G2(:,:,:,38),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,63),MB,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,33),wf(:,29),G2(:,:,:,39),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,39),Q(:,63),MB,G3tensor(:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,30),G2(:,:,:,40))
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,63),MB,G3tensor(:,34))
  call loop_QZ_A(G2(:,:,:,33),wf(:,32),G2(:,:,:,41),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,41),Q(:,63),MB,G3tensor(:,35))
  call loop_QZ_A(G2(:,:,:,33),wf(:,35),G2(:,:,:,42),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,63),MB,G3tensor(:,36))
  call loop_QW_A(G1(:,:,:,8),wf(:,4),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,26),MT,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,-5),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,58),MT,G3(:,:,:,3))
  call loop_QW_A(G3(:,:,:,3),wf(:,3),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MB,G4tensor(:,2))
  call loop_QW_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,10),ZERO,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,-5),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,42),ZERO,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,-4),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,58),ZERO,G3(:,:,:,5))
  call loop_QW_A(G3(:,:,:,5),wf(:,3),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),ZERO,G4tensor(:,3))
  call loop_QV_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,26),ZERO,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,58),ZERO,G3(:,:,:,7))
  call loop_QW_A(G3(:,:,:,7),wf(:,3),G3(:,:,:,8))
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),ZERO,G4tensor(:,4))
  call loop_QW_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,10),MT,G1(:,:,:,14))
  call loop_QV_A(G1(:,:,:,14),wf(:,-5),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,42),MT,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,-4),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,58),MT,G3(:,:,:,9))
  call loop_QW_A(G3(:,:,:,9),wf(:,3),G3(:,:,:,10))
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),MB,G4tensor(:,5))
  call loop_QV_A(G1(:,:,:,14),wf(:,-4),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,26),MT,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-5),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,58),MT,G3(:,:,:,11))
  call loop_QW_A(G3(:,:,:,11),wf(:,3),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MB,G4tensor(:,6))
  call loop_AW_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,10),ZERO,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-5),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,42),ZERO,G2(:,:,:,53))
  call loop_AV_Q(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,58),ZERO,G3(:,:,:,13))
  call loop_AW_Q(G3(:,:,:,13),wf(:,3),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),ZERO,G4tensor(:,7))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-4),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,26),ZERO,G2(:,:,:,55))
  call loop_AV_Q(G2(:,:,:,55),wf(:,-5),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,58),ZERO,G3(:,:,:,15))
  call loop_AW_Q(G3(:,:,:,15),wf(:,3),G3(:,:,:,16))
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),ZERO,G4tensor(:,8))
  call loop_AW_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,10),MB,G1(:,:,:,20))
  call loop_AV_Q(G1(:,:,:,20),wf(:,-5),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,42),MB,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,58),MB,G3(:,:,:,17))
  call loop_AW_Q(G3(:,:,:,17),wf(:,3),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,20),wf(:,-4),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,26),MB,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-5),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,58),MB,G3(:,:,:,19))
  call loop_AW_Q(G3(:,:,:,19),wf(:,3),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,16),ZERO,G1(:,:,:,23))
  call loop_AW_Q(G1(:,:,:,23),wf(:,4),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,26),ZERO,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-5),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,58),ZERO,G3(:,:,:,21))
  call loop_AW_Q(G3(:,:,:,21),wf(:,3),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),ZERO,G4tensor(:,11))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,16),ZERO,G1(:,:,:,25))
  call loop_QW_A(G1(:,:,:,25),wf(:,4),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,26),ZERO,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,-5),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,58),ZERO,G3(:,:,:,23))
  call loop_QW_A(G3(:,:,:,23),wf(:,3),G3(:,:,:,24))
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),ZERO,G4tensor(:,12))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(13) * den(21)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(13) * den(21)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(21)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(21)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(1) = M(1) + (-f(8) * den(23)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-f(8) * den(23)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(23)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (f(7) * den(23)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(1) = M(1) + (-f(6) * den(25)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(25)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-f(6) * den(25)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(1) = M(1) + (-f(6) * den(25)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_3,masses2_7,G4tensor(:,3),T4sum(1:70,1))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,5),T4sum(1:70,2))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_3,masses2_7,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,9),T4sum(1:70,3))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_2,masses2_7,G4tensor(:,4),T4sum(1:70,4))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,6),T4sum(1:70,5))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_2,masses2_7,G4tensor(:,8),T4sum(1:70,4))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,10),T4sum(1:70,6))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_4,masses2_7,G4tensor(:,11),T4sum(1:70,7))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,1),T4sum(1:70,8))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_4,masses2_7,G4tensor(:,12),T4sum(1:70,7))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,2),T4sum(1:70,9))
  M(1) = M(1) + (f(8) * den(26)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(8) * den(26)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(27)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(27)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(30)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(30)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(30)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(30)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (f(8) * den(31)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (f(8) * den(31)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(31)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(31)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(32)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(32)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(32)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(35)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(35)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllll2_nexnmemxgg_1_/**/REALKIND
