
module ol_vamp_1_ppllll2_eeexexgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll2_eeexexgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll2_eeexexgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllll2_eeexexgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllll2_eeexexgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,35) :: G0
  complex(REALKIND), dimension(4,5,4,122) :: G1
  complex(REALKIND), dimension(4,15,4,308) :: G2
  complex(REALKIND), dimension(4,35,4,264) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,136,64))
    allocate(G4tensorhel(70,180,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,48),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,18),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,52),G2(:,:,:,3))
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),MT,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,54),G2(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,55),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MT,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,57),G2(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,5))
  call loop_AV_Q(G2(:,:,:,1),wf(:,59),G2(:,:,:,7))
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),MT,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,61),G2(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,7))
  call loop_AV_Q(G2(:,:,:,1),wf(:,63),G2(:,:,:,9))
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),MT,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,65),G2(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,9))
  call loop_AS_Q(G2(:,:,:,1),wf(:,30),G2(:,:,:,11),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,63),MT,G3tensor(:,10))
  call loop_AV_Q(G2(:,:,:,1),wf(:,66),G2(:,:,:,12))
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,63),MT,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,68),G2(:,:,:,13),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,63),MT,G3tensor(:,12))
  call loop_AV_Q(G2(:,:,:,1),wf(:,69),G2(:,:,:,14))
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,71),G2(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,63),MT,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,1),wf(:,73),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,1),wf(:,75),G2(:,:,:,17))
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,63),MT,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,77),G2(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,63),MT,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,79),G2(:,:,:,19),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,63),MT,G3tensor(:,18))
  call loop_AV_Q(G2(:,:,:,1),wf(:,80),G2(:,:,:,20))
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,63),MT,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,82),G2(:,:,:,21),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,63),MT,G3tensor(:,20))
  call loop_AV_Q(G2(:,:,:,1),wf(:,83),G2(:,:,:,22))
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,85),G2(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,63),MT,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,1),wf(:,87),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MT,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,89),G2(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,63),MT,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,1),wf(:,91),G2(:,:,:,26))
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,63),MT,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,93),G2(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,63),MT,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,1),wf(:,94),G2(:,:,:,28))
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,63),MT,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,96),G2(:,:,:,29),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,63),MT,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,1),wf(:,97),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,63),MT,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,99),G2(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,63),MT,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,1),wf(:,101),G2(:,:,:,32))
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),MT,G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,1),wf(:,103),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,63),MT,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,105),G2(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MT,G3tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,107),G2(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,63),MT,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,26),MT,G2(:,:,:,36))
  call loop_AV_Q(G2(:,:,:,36),wf(:,-5),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,58),MT,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,7),G3(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,63),MT,G4tensor(:,2))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,5),G1(:,:,:,4),gZu)
  call loop_A_Q(G1(:,:,:,4),Q(:,26),MT,G2(:,:,:,38))
  call loop_AV_Q(G2(:,:,:,38),wf(:,-5),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,58),MT,G3(:,:,:,4))
  call loop_AV_Q(G3(:,:,:,4),wf(:,1),G3(:,:,:,5))
  call check_last_A_Q(l_switch,G3(:,:,:,5),Q(:,63),MT,G4tensor(:,3))
  call loop_AZ_Q(G3(:,:,:,4),wf(:,7),G3(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,9),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,25),MT,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-5),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,57),MT,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,10),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,13),G3(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,63),MT,G4tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,15),G1(:,:,:,6),gZu)
  call loop_A_Q(G1(:,:,:,6),Q(:,25),MT,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,-5),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,57),MT,G3(:,:,:,10))
  call loop_AV_Q(G3(:,:,:,10),wf(:,10),G3(:,:,:,11))
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,63),MT,G4tensor(:,7))
  call loop_AZ_Q(G3(:,:,:,10),wf(:,13),G3(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,63),MT,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-5),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,48),MT,G2(:,:,:,44))
  call loop_QS_A(G2(:,:,:,44),wf(:,18),G2(:,:,:,45),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,45),Q(:,63),MT,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,44),wf(:,52),G2(:,:,:,46))
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,63),MT,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,44),wf(:,54),G2(:,:,:,47),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,63),MT,G3tensor(:,37))
  call loop_QV_A(G2(:,:,:,44),wf(:,55),G2(:,:,:,48))
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,63),MT,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,44),wf(:,57),G2(:,:,:,49),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,63),MT,G3tensor(:,39))
  call loop_QV_A(G2(:,:,:,44),wf(:,59),G2(:,:,:,50))
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,63),MT,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,44),wf(:,61),G2(:,:,:,51),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,63),MT,G3tensor(:,41))
  call loop_QV_A(G2(:,:,:,44),wf(:,63),G2(:,:,:,52))
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,63),MT,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,44),wf(:,65),G2(:,:,:,53),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,63),MT,G3tensor(:,43))
  call loop_QS_A(G2(:,:,:,44),wf(:,30),G2(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,63),MT,G3tensor(:,44))
  call loop_QV_A(G2(:,:,:,44),wf(:,66),G2(:,:,:,55))
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,63),MT,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,44),wf(:,68),G2(:,:,:,56),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,63),MT,G3tensor(:,46))
  call loop_QV_A(G2(:,:,:,44),wf(:,69),G2(:,:,:,57))
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,63),MT,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,44),wf(:,71),G2(:,:,:,58),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,63),MT,G3tensor(:,48))
  call loop_QV_A(G2(:,:,:,44),wf(:,73),G2(:,:,:,59))
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,63),MT,G3tensor(:,49))
  call loop_QV_A(G2(:,:,:,44),wf(:,75),G2(:,:,:,60))
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,63),MT,G3tensor(:,50))
  call loop_QZ_A(G2(:,:,:,44),wf(:,77),G2(:,:,:,61),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,63),MT,G3tensor(:,51))
  call loop_QZ_A(G2(:,:,:,44),wf(:,79),G2(:,:,:,62),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,63),MT,G3tensor(:,52))
  call loop_QV_A(G2(:,:,:,44),wf(:,80),G2(:,:,:,63))
  call check_last_Q_A(l_switch,G2(:,:,:,63),Q(:,63),MT,G3tensor(:,53))
  call loop_QZ_A(G2(:,:,:,44),wf(:,82),G2(:,:,:,64),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,64),Q(:,63),MT,G3tensor(:,54))
  call loop_QV_A(G2(:,:,:,44),wf(:,83),G2(:,:,:,65))
  call check_last_Q_A(l_switch,G2(:,:,:,65),Q(:,63),MT,G3tensor(:,55))
  call loop_QZ_A(G2(:,:,:,44),wf(:,85),G2(:,:,:,66),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,63),MT,G3tensor(:,56))
  call loop_QV_A(G2(:,:,:,44),wf(:,87),G2(:,:,:,67))
  call check_last_Q_A(l_switch,G2(:,:,:,67),Q(:,63),MT,G3tensor(:,57))
  call loop_QZ_A(G2(:,:,:,44),wf(:,89),G2(:,:,:,68),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,63),MT,G3tensor(:,58))
  call loop_QV_A(G2(:,:,:,44),wf(:,91),G2(:,:,:,69))
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,63),MT,G3tensor(:,59))
  call loop_QZ_A(G2(:,:,:,44),wf(:,93),G2(:,:,:,70),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,63),MT,G3tensor(:,60))
  call loop_QV_A(G2(:,:,:,44),wf(:,94),G2(:,:,:,71))
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,63),MT,G3tensor(:,61))
  call loop_QZ_A(G2(:,:,:,44),wf(:,96),G2(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,63),MT,G3tensor(:,62))
  call loop_QV_A(G2(:,:,:,44),wf(:,97),G2(:,:,:,73))
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,63),MT,G3tensor(:,63))
  call loop_QZ_A(G2(:,:,:,44),wf(:,99),G2(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,63),MT,G3tensor(:,64))
  call loop_QV_A(G2(:,:,:,44),wf(:,101),G2(:,:,:,75))
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,63),MT,G3tensor(:,65))
  call loop_QV_A(G2(:,:,:,44),wf(:,103),G2(:,:,:,76))
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,63),MT,G3tensor(:,66))
  call loop_QZ_A(G2(:,:,:,44),wf(:,105),G2(:,:,:,77),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,63),MT,G3tensor(:,67))
  call loop_QZ_A(G2(:,:,:,44),wf(:,107),G2(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,63),MT,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,7),wf(:,2),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,26),MT,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,-5),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,58),MT,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,9))
  call loop_QZ_A(G3(:,:,:,13),wf(:,7),G3(:,:,:,15),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,63),MT,G4tensor(:,10))
  call loop_QZ_A(G1(:,:,:,7),wf(:,5),G1(:,:,:,10),gZu)
  call loop_Q_A(G1(:,:,:,10),Q(:,26),MT,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,-5),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,58),MT,G3(:,:,:,16))
  call loop_QV_A(G3(:,:,:,16),wf(:,1),G3(:,:,:,17))
  call check_last_Q_A(l_switch,G3(:,:,:,17),Q(:,63),MT,G4tensor(:,11))
  call loop_QZ_A(G3(:,:,:,16),wf(:,7),G3(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,12))
  call loop_QV_A(G1(:,:,:,7),wf(:,9),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,25),MT,G2(:,:,:,83))
  call loop_QV_A(G2(:,:,:,83),wf(:,-5),G2(:,:,:,84))
  call loop_Q_A(G2(:,:,:,84),Q(:,57),MT,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,10),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,13))
  call loop_QZ_A(G3(:,:,:,19),wf(:,13),G3(:,:,:,21),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,21),Q(:,63),MT,G4tensor(:,14))
  call loop_QZ_A(G1(:,:,:,7),wf(:,15),G1(:,:,:,12),gZu)
  call loop_Q_A(G1(:,:,:,12),Q(:,25),MT,G2(:,:,:,85))
  call loop_QV_A(G2(:,:,:,85),wf(:,-5),G2(:,:,:,86))
  call loop_Q_A(G2(:,:,:,86),Q(:,57),MT,G3(:,:,:,22))
  call loop_QV_A(G3(:,:,:,22),wf(:,10),G3(:,:,:,23))
  call check_last_Q_A(l_switch,G3(:,:,:,23),Q(:,63),MT,G4tensor(:,15))
  call loop_QZ_A(G3(:,:,:,22),wf(:,13),G3(:,:,:,24),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,16),MB,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-5),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,48),MB,G2(:,:,:,87))
  call loop_AS_Q(G2(:,:,:,87),wf(:,18),G2(:,:,:,88),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,63),MB,G3tensor(:,69))
  call loop_AV_Q(G2(:,:,:,87),wf(:,52),G2(:,:,:,89))
  call check_last_A_Q(l_switch,G2(:,:,:,89),Q(:,63),MB,G3tensor(:,70))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,54),G2(:,:,:,90),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,63),MB,G3tensor(:,71))
  call loop_AV_Q(G2(:,:,:,87),wf(:,55),G2(:,:,:,91))
  call check_last_A_Q(l_switch,G2(:,:,:,91),Q(:,63),MB,G3tensor(:,72))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,57),G2(:,:,:,92),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,92),Q(:,63),MB,G3tensor(:,73))
  call loop_AV_Q(G2(:,:,:,87),wf(:,59),G2(:,:,:,93))
  call check_last_A_Q(l_switch,G2(:,:,:,93),Q(:,63),MB,G3tensor(:,74))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,61),G2(:,:,:,94),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,94),Q(:,63),MB,G3tensor(:,75))
  call loop_AV_Q(G2(:,:,:,87),wf(:,63),G2(:,:,:,95))
  call check_last_A_Q(l_switch,G2(:,:,:,95),Q(:,63),MB,G3tensor(:,76))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,65),G2(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,63),MB,G3tensor(:,77))
  call loop_AS_Q(G2(:,:,:,87),wf(:,30),G2(:,:,:,97),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,97),Q(:,63),MB,G3tensor(:,78))
  call loop_AV_Q(G2(:,:,:,87),wf(:,66),G2(:,:,:,98))
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,63),MB,G3tensor(:,79))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,68),G2(:,:,:,99),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,99),Q(:,63),MB,G3tensor(:,80))
  call loop_AV_Q(G2(:,:,:,87),wf(:,69),G2(:,:,:,100))
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,63),MB,G3tensor(:,81))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,71),G2(:,:,:,101),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,101),Q(:,63),MB,G3tensor(:,82))
  call loop_AV_Q(G2(:,:,:,87),wf(:,73),G2(:,:,:,102))
  call check_last_A_Q(l_switch,G2(:,:,:,102),Q(:,63),MB,G3tensor(:,83))
  call loop_AV_Q(G2(:,:,:,87),wf(:,75),G2(:,:,:,103))
  call check_last_A_Q(l_switch,G2(:,:,:,103),Q(:,63),MB,G3tensor(:,84))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,77),G2(:,:,:,104),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,104),Q(:,63),MB,G3tensor(:,85))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,79),G2(:,:,:,105),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,105),Q(:,63),MB,G3tensor(:,86))
  call loop_AV_Q(G2(:,:,:,87),wf(:,80),G2(:,:,:,106))
  call check_last_A_Q(l_switch,G2(:,:,:,106),Q(:,63),MB,G3tensor(:,87))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,82),G2(:,:,:,107),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,107),Q(:,63),MB,G3tensor(:,88))
  call loop_AV_Q(G2(:,:,:,87),wf(:,83),G2(:,:,:,108))
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,63),MB,G3tensor(:,89))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,85),G2(:,:,:,109),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,109),Q(:,63),MB,G3tensor(:,90))
  call loop_AV_Q(G2(:,:,:,87),wf(:,87),G2(:,:,:,110))
  call check_last_A_Q(l_switch,G2(:,:,:,110),Q(:,63),MB,G3tensor(:,91))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,89),G2(:,:,:,111),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,111),Q(:,63),MB,G3tensor(:,92))
  call loop_AV_Q(G2(:,:,:,87),wf(:,91),G2(:,:,:,112))
  call check_last_A_Q(l_switch,G2(:,:,:,112),Q(:,63),MB,G3tensor(:,93))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,93),G2(:,:,:,113),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,113),Q(:,63),MB,G3tensor(:,94))
  call loop_AV_Q(G2(:,:,:,87),wf(:,94),G2(:,:,:,114))
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,63),MB,G3tensor(:,95))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,96),G2(:,:,:,115),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,115),Q(:,63),MB,G3tensor(:,96))
  call loop_AV_Q(G2(:,:,:,87),wf(:,97),G2(:,:,:,116))
  call check_last_A_Q(l_switch,G2(:,:,:,116),Q(:,63),MB,G3tensor(:,97))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,99),G2(:,:,:,117),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,117),Q(:,63),MB,G3tensor(:,98))
  call loop_AV_Q(G2(:,:,:,87),wf(:,101),G2(:,:,:,118))
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,63),MB,G3tensor(:,99))
  call loop_AV_Q(G2(:,:,:,87),wf(:,103),G2(:,:,:,119))
  call check_last_A_Q(l_switch,G2(:,:,:,119),Q(:,63),MB,G3tensor(:,100))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,105),G2(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,120),Q(:,63),MB,G3tensor(:,101))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,107),G2(:,:,:,121),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,121),Q(:,63),MB,G3tensor(:,102))
  call loop_AV_Q(G1(:,:,:,13),wf(:,2),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,26),MB,G2(:,:,:,122))
  call loop_AV_Q(G2(:,:,:,122),wf(:,-5),G2(:,:,:,123))
  call loop_A_Q(G2(:,:,:,123),Q(:,58),MB,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,1),G3(:,:,:,26))
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,63),MB,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,7),G3(:,:,:,27),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,63),MB,G4tensor(:,18))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,5),G1(:,:,:,16),gZd)
  call loop_A_Q(G1(:,:,:,16),Q(:,26),MB,G2(:,:,:,124))
  call loop_AV_Q(G2(:,:,:,124),wf(:,-5),G2(:,:,:,125))
  call loop_A_Q(G2(:,:,:,125),Q(:,58),MB,G3(:,:,:,28))
  call loop_AV_Q(G3(:,:,:,28),wf(:,1),G3(:,:,:,29))
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,63),MB,G4tensor(:,19))
  call loop_AZ_Q(G3(:,:,:,28),wf(:,7),G3(:,:,:,30),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,63),MB,G4tensor(:,20))
  call loop_AV_Q(G1(:,:,:,13),wf(:,9),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,25),MB,G2(:,:,:,126))
  call loop_AV_Q(G2(:,:,:,126),wf(:,-5),G2(:,:,:,127))
  call loop_A_Q(G2(:,:,:,127),Q(:,57),MB,G3(:,:,:,31))
  call loop_AV_Q(G3(:,:,:,31),wf(:,10),G3(:,:,:,32))
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MB,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,31),wf(:,13),G3(:,:,:,33),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,63),MB,G4tensor(:,22))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,15),G1(:,:,:,18),gZd)
  call loop_A_Q(G1(:,:,:,18),Q(:,25),MB,G2(:,:,:,128))
  call loop_AV_Q(G2(:,:,:,128),wf(:,-5),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,57),MB,G3(:,:,:,34))
  call loop_AV_Q(G3(:,:,:,34),wf(:,10),G3(:,:,:,35))
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,63),MB,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,34),wf(:,13),G3(:,:,:,36),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,63),MB,G4tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,16),MB,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,-5),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,48),MB,G2(:,:,:,130))
  call loop_QS_A(G2(:,:,:,130),wf(:,18),G2(:,:,:,131),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,63),MB,G3tensor(:,103))
  call loop_QV_A(G2(:,:,:,130),wf(:,52),G2(:,:,:,132))
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,63),MB,G3tensor(:,104))
  call loop_QZ_A(G2(:,:,:,130),wf(:,54),G2(:,:,:,133),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,133),Q(:,63),MB,G3tensor(:,105))
  call loop_QV_A(G2(:,:,:,130),wf(:,55),G2(:,:,:,134))
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,63),MB,G3tensor(:,106))
  call loop_QZ_A(G2(:,:,:,130),wf(:,57),G2(:,:,:,135),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,63),MB,G3tensor(:,107))
  call loop_QV_A(G2(:,:,:,130),wf(:,59),G2(:,:,:,136))
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,63),MB,G3tensor(:,108))
  call loop_QZ_A(G2(:,:,:,130),wf(:,61),G2(:,:,:,137),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,137),Q(:,63),MB,G3tensor(:,109))
  call loop_QV_A(G2(:,:,:,130),wf(:,63),G2(:,:,:,138))
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,63),MB,G3tensor(:,110))
  call loop_QZ_A(G2(:,:,:,130),wf(:,65),G2(:,:,:,139),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,63),MB,G3tensor(:,111))
  call loop_QS_A(G2(:,:,:,130),wf(:,30),G2(:,:,:,140),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,140),Q(:,63),MB,G3tensor(:,112))
  call loop_QV_A(G2(:,:,:,130),wf(:,66),G2(:,:,:,141))
  call check_last_Q_A(l_switch,G2(:,:,:,141),Q(:,63),MB,G3tensor(:,113))
  call loop_QZ_A(G2(:,:,:,130),wf(:,68),G2(:,:,:,142),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,142),Q(:,63),MB,G3tensor(:,114))
  call loop_QV_A(G2(:,:,:,130),wf(:,69),G2(:,:,:,143))
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,63),MB,G3tensor(:,115))
  call loop_QZ_A(G2(:,:,:,130),wf(:,71),G2(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,144),Q(:,63),MB,G3tensor(:,116))
  call loop_QV_A(G2(:,:,:,130),wf(:,73),G2(:,:,:,145))
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,63),MB,G3tensor(:,117))
  call loop_QV_A(G2(:,:,:,130),wf(:,75),G2(:,:,:,146))
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,63),MB,G3tensor(:,118))
  call loop_QZ_A(G2(:,:,:,130),wf(:,77),G2(:,:,:,147),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,63),MB,G3tensor(:,119))
  call loop_QZ_A(G2(:,:,:,130),wf(:,79),G2(:,:,:,148),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,63),MB,G3tensor(:,120))
  call loop_QV_A(G2(:,:,:,130),wf(:,80),G2(:,:,:,149))
  call check_last_Q_A(l_switch,G2(:,:,:,149),Q(:,63),MB,G3tensor(:,121))
  call loop_QZ_A(G2(:,:,:,130),wf(:,82),G2(:,:,:,150),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,63),MB,G3tensor(:,122))
  call loop_QV_A(G2(:,:,:,130),wf(:,83),G2(:,:,:,151))
  call check_last_Q_A(l_switch,G2(:,:,:,151),Q(:,63),MB,G3tensor(:,123))
  call loop_QZ_A(G2(:,:,:,130),wf(:,85),G2(:,:,:,152),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,152),Q(:,63),MB,G3tensor(:,124))
  call loop_QV_A(G2(:,:,:,130),wf(:,87),G2(:,:,:,153))
  call check_last_Q_A(l_switch,G2(:,:,:,153),Q(:,63),MB,G3tensor(:,125))
  call loop_QZ_A(G2(:,:,:,130),wf(:,89),G2(:,:,:,154),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,154),Q(:,63),MB,G3tensor(:,126))
  call loop_QV_A(G2(:,:,:,130),wf(:,91),G2(:,:,:,155))
  call check_last_Q_A(l_switch,G2(:,:,:,155),Q(:,63),MB,G3tensor(:,127))
  call loop_QZ_A(G2(:,:,:,130),wf(:,93),G2(:,:,:,156),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,156),Q(:,63),MB,G3tensor(:,128))
  call loop_QV_A(G2(:,:,:,130),wf(:,94),G2(:,:,:,157))
  call check_last_Q_A(l_switch,G2(:,:,:,157),Q(:,63),MB,G3tensor(:,129))
  call loop_QZ_A(G2(:,:,:,130),wf(:,96),G2(:,:,:,158),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,158),Q(:,63),MB,G3tensor(:,130))
  call loop_QV_A(G2(:,:,:,130),wf(:,97),G2(:,:,:,159))
  call check_last_Q_A(l_switch,G2(:,:,:,159),Q(:,63),MB,G3tensor(:,131))
  call loop_QZ_A(G2(:,:,:,130),wf(:,99),G2(:,:,:,160),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,160),Q(:,63),MB,G3tensor(:,132))
  call loop_QV_A(G2(:,:,:,130),wf(:,101),G2(:,:,:,161))
  call check_last_Q_A(l_switch,G2(:,:,:,161),Q(:,63),MB,G3tensor(:,133))
  call loop_QV_A(G2(:,:,:,130),wf(:,103),G2(:,:,:,162))
  call check_last_Q_A(l_switch,G2(:,:,:,162),Q(:,63),MB,G3tensor(:,134))
  call loop_QZ_A(G2(:,:,:,130),wf(:,105),G2(:,:,:,163),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,163),Q(:,63),MB,G3tensor(:,135))
  call loop_QZ_A(G2(:,:,:,130),wf(:,107),G2(:,:,:,164),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,164),Q(:,63),MB,G3tensor(:,136))
  call loop_QV_A(G1(:,:,:,19),wf(:,2),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,26),MB,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,-5),G2(:,:,:,166))
  call loop_Q_A(G2(:,:,:,166),Q(:,58),MB,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,1),G3(:,:,:,38))
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,63),MB,G4tensor(:,25))
  call loop_QZ_A(G3(:,:,:,37),wf(:,7),G3(:,:,:,39),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,39),Q(:,63),MB,G4tensor(:,26))
  call loop_QZ_A(G1(:,:,:,19),wf(:,5),G1(:,:,:,22),gZd)
  call loop_Q_A(G1(:,:,:,22),Q(:,26),MB,G2(:,:,:,167))
  call loop_QV_A(G2(:,:,:,167),wf(:,-5),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,58),MB,G3(:,:,:,40))
  call loop_QV_A(G3(:,:,:,40),wf(:,1),G3(:,:,:,41))
  call check_last_Q_A(l_switch,G3(:,:,:,41),Q(:,63),MB,G4tensor(:,27))
  call loop_QZ_A(G3(:,:,:,40),wf(:,7),G3(:,:,:,42),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),MB,G4tensor(:,28))
  call loop_QV_A(G1(:,:,:,19),wf(:,9),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,25),MB,G2(:,:,:,169))
  call loop_QV_A(G2(:,:,:,169),wf(:,-5),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,57),MB,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,10),G3(:,:,:,44))
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),MB,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,43),wf(:,13),G3(:,:,:,45),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,45),Q(:,63),MB,G4tensor(:,30))
  call loop_QZ_A(G1(:,:,:,19),wf(:,15),G1(:,:,:,24),gZd)
  call loop_Q_A(G1(:,:,:,24),Q(:,25),MB,G2(:,:,:,171))
  call loop_QV_A(G2(:,:,:,171),wf(:,-5),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,57),MB,G3(:,:,:,46))
  call loop_QV_A(G3(:,:,:,46),wf(:,10),G3(:,:,:,47))
  call check_last_Q_A(l_switch,G3(:,:,:,47),Q(:,63),MB,G4tensor(:,31))
  call loop_QZ_A(G3(:,:,:,46),wf(:,13),G3(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MB,G4tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,10),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,-5),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,42),ZERO,G2(:,:,:,173))
  call loop_QV_A(G2(:,:,:,173),wf(:,-4),G2(:,:,:,174))
  call loop_Q_A(G2(:,:,:,174),Q(:,58),ZERO,G3(:,:,:,49))
  call loop_QV_A(G3(:,:,:,49),wf(:,1),G3(:,:,:,50))
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,63),ZERO,G4tensor(:,33))
  call loop_QZ_A(G3(:,:,:,49),wf(:,7),G3(:,:,:,51),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,51),Q(:,63),ZERO,G4tensor(:,34))
  call loop_QZ_A(G3(:,:,:,49),wf(:,7),G3(:,:,:,52),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,63),ZERO,G4tensor(:,35))
  call loop_QV_A(G1(:,:,:,25),wf(:,-4),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,26),ZERO,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,-5),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,58),ZERO,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,1),G3(:,:,:,54))
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,63),ZERO,G4tensor(:,36))
  call loop_QZ_A(G3(:,:,:,53),wf(:,7),G3(:,:,:,55),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,55),Q(:,63),ZERO,G4tensor(:,37))
  call loop_QZ_A(G3(:,:,:,53),wf(:,7),G3(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,56),Q(:,63),ZERO,G4tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,10),MT,G1(:,:,:,28))
  call loop_QV_A(G1(:,:,:,28),wf(:,-5),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,42),MT,G2(:,:,:,177))
  call loop_QV_A(G2(:,:,:,177),wf(:,-4),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,58),MT,G3(:,:,:,57))
  call loop_QV_A(G3(:,:,:,57),wf(:,1),G3(:,:,:,58))
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,63),MT,G4tensor(:,39))
  call loop_QZ_A(G3(:,:,:,57),wf(:,7),G3(:,:,:,59),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,59),Q(:,63),MT,G4tensor(:,40))
  call loop_QV_A(G1(:,:,:,28),wf(:,-4),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,26),MT,G2(:,:,:,179))
  call loop_QV_A(G2(:,:,:,179),wf(:,-5),G2(:,:,:,180))
  call loop_Q_A(G2(:,:,:,180),Q(:,58),MT,G3(:,:,:,60))
  call loop_QV_A(G3(:,:,:,60),wf(:,1),G3(:,:,:,61))
  call check_last_Q_A(l_switch,G3(:,:,:,61),Q(:,63),MT,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,60),wf(:,7),G3(:,:,:,62),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),MT,G4tensor(:,42))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,10),ZERO,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-5),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,42),ZERO,G2(:,:,:,181))
  call loop_AV_Q(G2(:,:,:,181),wf(:,-4),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,58),ZERO,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,1),G3(:,:,:,64))
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,63),ZERO,G4tensor(:,43))
  call loop_AZ_Q(G3(:,:,:,63),wf(:,7),G3(:,:,:,65),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,65),Q(:,63),ZERO,G4tensor(:,44))
  call loop_AZ_Q(G3(:,:,:,63),wf(:,7),G3(:,:,:,66),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,63),ZERO,G4tensor(:,45))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-4),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,26),ZERO,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-5),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,58),ZERO,G3(:,:,:,67))
  call loop_AV_Q(G3(:,:,:,67),wf(:,1),G3(:,:,:,68))
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,63),ZERO,G4tensor(:,46))
  call loop_AZ_Q(G3(:,:,:,67),wf(:,7),G3(:,:,:,69),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,69),Q(:,63),ZERO,G4tensor(:,47))
  call loop_AZ_Q(G3(:,:,:,67),wf(:,7),G3(:,:,:,70),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,63),ZERO,G4tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,10),MT,G1(:,:,:,34))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-5),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,42),MT,G2(:,:,:,185))
  call loop_AV_Q(G2(:,:,:,185),wf(:,-4),G2(:,:,:,186))
  call loop_A_Q(G2(:,:,:,186),Q(:,58),MT,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,1),G3(:,:,:,72))
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,63),MT,G4tensor(:,49))
  call loop_AZ_Q(G3(:,:,:,71),wf(:,7),G3(:,:,:,73),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,73),Q(:,63),MT,G4tensor(:,50))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-4),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,26),MT,G2(:,:,:,187))
  call loop_AV_Q(G2(:,:,:,187),wf(:,-5),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,58),MT,G3(:,:,:,74))
  call loop_AV_Q(G3(:,:,:,74),wf(:,1),G3(:,:,:,75))
  call check_last_A_Q(l_switch,G3(:,:,:,75),Q(:,63),MT,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,74),wf(:,7),G3(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,63),MT,G4tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,10),MB,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,-5),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,42),MB,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,-4),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,58),MB,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,1),G3(:,:,:,78))
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,63),MB,G4tensor(:,53))
  call loop_QZ_A(G3(:,:,:,77),wf(:,7),G3(:,:,:,79),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,79),Q(:,63),MB,G4tensor(:,54))
  call loop_QV_A(G1(:,:,:,37),wf(:,-4),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,26),MB,G2(:,:,:,191))
  call loop_QV_A(G2(:,:,:,191),wf(:,-5),G2(:,:,:,192))
  call loop_Q_A(G2(:,:,:,192),Q(:,58),MB,G3(:,:,:,80))
  call loop_QV_A(G3(:,:,:,80),wf(:,1),G3(:,:,:,81))
  call check_last_Q_A(l_switch,G3(:,:,:,81),Q(:,63),MB,G4tensor(:,55))
  call loop_QZ_A(G3(:,:,:,80),wf(:,7),G3(:,:,:,82),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,63),MB,G4tensor(:,56))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,10),MB,G1(:,:,:,40))
  call loop_AV_Q(G1(:,:,:,40),wf(:,-5),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,42),MB,G2(:,:,:,193))
  call loop_AV_Q(G2(:,:,:,193),wf(:,-4),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,58),MB,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,1),G3(:,:,:,84))
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,63),MB,G4tensor(:,57))
  call loop_AZ_Q(G3(:,:,:,83),wf(:,7),G3(:,:,:,85),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,85),Q(:,63),MB,G4tensor(:,58))
  call loop_AV_Q(G1(:,:,:,40),wf(:,-4),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,26),MB,G2(:,:,:,195))
  call loop_AV_Q(G2(:,:,:,195),wf(:,-5),G2(:,:,:,196))
  call loop_A_Q(G2(:,:,:,196),Q(:,58),MB,G3(:,:,:,86))
  call loop_AV_Q(G3(:,:,:,86),wf(:,1),G3(:,:,:,87))
  call check_last_A_Q(l_switch,G3(:,:,:,87),Q(:,63),MB,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,86),wf(:,7),G3(:,:,:,88),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,63),MB,G4tensor(:,60))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,12),gZu)
  call loop_Q_A(G0(:,:,:,12),Q(:,10),ZERO,G1(:,:,:,43))
  call loop_QV_A(G1(:,:,:,43),wf(:,-5),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,42),ZERO,G2(:,:,:,197))
  call loop_QV_A(G2(:,:,:,197),wf(:,-4),G2(:,:,:,198))
  call loop_Q_A(G2(:,:,:,198),Q(:,58),ZERO,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,1),G3(:,:,:,90))
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,63),ZERO,G4tensor(:,61))
  call loop_QZ_A(G3(:,:,:,89),wf(:,7),G3(:,:,:,91),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,91),Q(:,63),ZERO,G4tensor(:,62))
  call loop_QV_A(G1(:,:,:,43),wf(:,-4),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,26),ZERO,G2(:,:,:,199))
  call loop_QV_A(G2(:,:,:,199),wf(:,-5),G2(:,:,:,200))
  call loop_Q_A(G2(:,:,:,200),Q(:,58),ZERO,G3(:,:,:,92))
  call loop_QV_A(G3(:,:,:,92),wf(:,1),G3(:,:,:,93))
  call check_last_Q_A(l_switch,G3(:,:,:,93),Q(:,63),ZERO,G4tensor(:,63))
  call loop_QZ_A(G3(:,:,:,92),wf(:,7),G3(:,:,:,94),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,63),ZERO,G4tensor(:,64))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,13),gZu)
  call loop_Q_A(G0(:,:,:,13),Q(:,10),MT,G1(:,:,:,46))
  call loop_QV_A(G1(:,:,:,46),wf(:,-5),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,42),MT,G2(:,:,:,201))
  call loop_QV_A(G2(:,:,:,201),wf(:,-4),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,58),MT,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,1),G3(:,:,:,96))
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,63),MT,G4tensor(:,65))
  call loop_QZ_A(G3(:,:,:,95),wf(:,7),G3(:,:,:,97),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,97),Q(:,63),MT,G4tensor(:,66))
  call loop_QV_A(G1(:,:,:,46),wf(:,-4),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,26),MT,G2(:,:,:,203))
  call loop_QV_A(G2(:,:,:,203),wf(:,-5),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,58),MT,G3(:,:,:,98))
  call loop_QV_A(G3(:,:,:,98),wf(:,1),G3(:,:,:,99))
  call check_last_Q_A(l_switch,G3(:,:,:,99),Q(:,63),MT,G4tensor(:,67))
  call loop_QZ_A(G3(:,:,:,98),wf(:,7),G3(:,:,:,100),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,63),MT,G4tensor(:,68))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,10),ZERO,G1(:,:,:,49))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-5),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,42),ZERO,G2(:,:,:,205))
  call loop_AV_Q(G2(:,:,:,205),wf(:,-4),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,58),ZERO,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,1),G3(:,:,:,102))
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,63),ZERO,G4tensor(:,69))
  call loop_AZ_Q(G3(:,:,:,101),wf(:,7),G3(:,:,:,103),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,103),Q(:,63),ZERO,G4tensor(:,70))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-4),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,26),ZERO,G2(:,:,:,207))
  call loop_AV_Q(G2(:,:,:,207),wf(:,-5),G2(:,:,:,208))
  call loop_A_Q(G2(:,:,:,208),Q(:,58),ZERO,G3(:,:,:,104))
  call loop_AV_Q(G3(:,:,:,104),wf(:,1),G3(:,:,:,105))
  call check_last_A_Q(l_switch,G3(:,:,:,105),Q(:,63),ZERO,G4tensor(:,71))
  call loop_AZ_Q(G3(:,:,:,104),wf(:,7),G3(:,:,:,106),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,63),ZERO,G4tensor(:,72))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,15),gZu)
  call loop_A_Q(G0(:,:,:,15),Q(:,10),MT,G1(:,:,:,52))
  call loop_AV_Q(G1(:,:,:,52),wf(:,-5),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,42),MT,G2(:,:,:,209))
  call loop_AV_Q(G2(:,:,:,209),wf(:,-4),G2(:,:,:,210))
  call loop_A_Q(G2(:,:,:,210),Q(:,58),MT,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,1),G3(:,:,:,108))
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,63),MT,G4tensor(:,73))
  call loop_AZ_Q(G3(:,:,:,107),wf(:,7),G3(:,:,:,109),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,109),Q(:,63),MT,G4tensor(:,74))
  call loop_AV_Q(G1(:,:,:,52),wf(:,-4),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,26),MT,G2(:,:,:,211))
  call loop_AV_Q(G2(:,:,:,211),wf(:,-5),G2(:,:,:,212))
  call loop_A_Q(G2(:,:,:,212),Q(:,58),MT,G3(:,:,:,110))
  call loop_AV_Q(G3(:,:,:,110),wf(:,1),G3(:,:,:,111))
  call check_last_A_Q(l_switch,G3(:,:,:,111),Q(:,63),MT,G4tensor(:,75))
  call loop_AZ_Q(G3(:,:,:,110),wf(:,7),G3(:,:,:,112),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,112),Q(:,63),MT,G4tensor(:,76))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,16),gZd)
  call loop_Q_A(G0(:,:,:,16),Q(:,10),ZERO,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,-5),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,42),ZERO,G2(:,:,:,213))
  call loop_QV_A(G2(:,:,:,213),wf(:,-4),G2(:,:,:,214))
  call loop_Q_A(G2(:,:,:,214),Q(:,58),ZERO,G3(:,:,:,113))
  call loop_QV_A(G3(:,:,:,113),wf(:,1),G3(:,:,:,114))
  call check_last_Q_A(l_switch,G3(:,:,:,114),Q(:,63),ZERO,G4tensor(:,77))
  call loop_QZ_A(G3(:,:,:,113),wf(:,7),G3(:,:,:,115),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,115),Q(:,63),ZERO,G4tensor(:,78))
  call loop_QV_A(G1(:,:,:,55),wf(:,-4),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,26),ZERO,G2(:,:,:,215))
  call loop_QV_A(G2(:,:,:,215),wf(:,-5),G2(:,:,:,216))
  call loop_Q_A(G2(:,:,:,216),Q(:,58),ZERO,G3(:,:,:,116))
  call loop_QV_A(G3(:,:,:,116),wf(:,1),G3(:,:,:,117))
  call check_last_Q_A(l_switch,G3(:,:,:,117),Q(:,63),ZERO,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,116),wf(:,7),G3(:,:,:,118),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,118),Q(:,63),ZERO,G4tensor(:,80))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,17),gZd)
  call loop_Q_A(G0(:,:,:,17),Q(:,10),MB,G1(:,:,:,58))
  call loop_QV_A(G1(:,:,:,58),wf(:,-5),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,42),MB,G2(:,:,:,217))
  call loop_QV_A(G2(:,:,:,217),wf(:,-4),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,58),MB,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,1),G3(:,:,:,120))
  call check_last_Q_A(l_switch,G3(:,:,:,120),Q(:,63),MB,G4tensor(:,81))
  call loop_QZ_A(G3(:,:,:,119),wf(:,7),G3(:,:,:,121),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,121),Q(:,63),MB,G4tensor(:,82))
  call loop_QV_A(G1(:,:,:,58),wf(:,-4),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,26),MB,G2(:,:,:,219))
  call loop_QV_A(G2(:,:,:,219),wf(:,-5),G2(:,:,:,220))
  call loop_Q_A(G2(:,:,:,220),Q(:,58),MB,G3(:,:,:,122))
  call loop_QV_A(G3(:,:,:,122),wf(:,1),G3(:,:,:,123))
  call check_last_Q_A(l_switch,G3(:,:,:,123),Q(:,63),MB,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,122),wf(:,7),G3(:,:,:,124),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,63),MB,G4tensor(:,84))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,18),gZd)
  call loop_A_Q(G0(:,:,:,18),Q(:,10),ZERO,G1(:,:,:,61))
  call loop_AV_Q(G1(:,:,:,61),wf(:,-5),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,42),ZERO,G2(:,:,:,221))
  call loop_AV_Q(G2(:,:,:,221),wf(:,-4),G2(:,:,:,222))
  call loop_A_Q(G2(:,:,:,222),Q(:,58),ZERO,G3(:,:,:,125))
  call loop_AV_Q(G3(:,:,:,125),wf(:,1),G3(:,:,:,126))
  call check_last_A_Q(l_switch,G3(:,:,:,126),Q(:,63),ZERO,G4tensor(:,85))
  call loop_AZ_Q(G3(:,:,:,125),wf(:,7),G3(:,:,:,127),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,127),Q(:,63),ZERO,G4tensor(:,86))
  call loop_AV_Q(G1(:,:,:,61),wf(:,-4),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,26),ZERO,G2(:,:,:,223))
  call loop_AV_Q(G2(:,:,:,223),wf(:,-5),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,58),ZERO,G3(:,:,:,128))
  call loop_AV_Q(G3(:,:,:,128),wf(:,1),G3(:,:,:,129))
  call check_last_A_Q(l_switch,G3(:,:,:,129),Q(:,63),ZERO,G4tensor(:,87))
  call loop_AZ_Q(G3(:,:,:,128),wf(:,7),G3(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,63),ZERO,G4tensor(:,88))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,19),gZd)
  call loop_A_Q(G0(:,:,:,19),Q(:,10),MB,G1(:,:,:,64))
  call loop_AV_Q(G1(:,:,:,64),wf(:,-5),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,42),MB,G2(:,:,:,225))
  call loop_AV_Q(G2(:,:,:,225),wf(:,-4),G2(:,:,:,226))
  call loop_A_Q(G2(:,:,:,226),Q(:,58),MB,G3(:,:,:,131))
  call loop_AV_Q(G3(:,:,:,131),wf(:,1),G3(:,:,:,132))
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,63),MB,G4tensor(:,89))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,7),G3(:,:,:,133),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,133),Q(:,63),MB,G4tensor(:,90))
  call loop_AV_Q(G1(:,:,:,64),wf(:,-4),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,26),MB,G2(:,:,:,227))
  call loop_AV_Q(G2(:,:,:,227),wf(:,-5),G2(:,:,:,228))
  call loop_A_Q(G2(:,:,:,228),Q(:,58),MB,G3(:,:,:,134))
  call loop_AV_Q(G3(:,:,:,134),wf(:,1),G3(:,:,:,135))
  call check_last_A_Q(l_switch,G3(:,:,:,135),Q(:,63),MB,G4tensor(:,91))
  call loop_AZ_Q(G3(:,:,:,134),wf(:,7),G3(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,63),MB,G4tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,16),ZERO,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,2),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,26),ZERO,G2(:,:,:,229))
  call loop_QV_A(G2(:,:,:,229),wf(:,-5),G2(:,:,:,230))
  call loop_Q_A(G2(:,:,:,230),Q(:,58),ZERO,G3(:,:,:,137))
  call loop_QV_A(G3(:,:,:,137),wf(:,1),G3(:,:,:,138))
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,63),ZERO,G4tensor(:,93))
  call loop_QZ_A(G3(:,:,:,137),wf(:,7),G3(:,:,:,139),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,139),Q(:,63),ZERO,G4tensor(:,94))
  call loop_QZ_A(G3(:,:,:,137),wf(:,7),G3(:,:,:,140),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,63),ZERO,G4tensor(:,95))
  call loop_QZ_A(G1(:,:,:,67),wf(:,5),G1(:,:,:,69),gZu)
  call loop_Q_A(G1(:,:,:,69),Q(:,26),ZERO,G2(:,:,:,231))
  call loop_QV_A(G2(:,:,:,231),wf(:,-5),G2(:,:,:,232))
  call loop_Q_A(G2(:,:,:,232),Q(:,58),ZERO,G3(:,:,:,141))
  call loop_QV_A(G3(:,:,:,141),wf(:,1),G3(:,:,:,142))
  call check_last_Q_A(l_switch,G3(:,:,:,142),Q(:,63),ZERO,G4tensor(:,96))
  call loop_QZ_A(G3(:,:,:,141),wf(:,7),G3(:,:,:,143),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,143),Q(:,63),ZERO,G4tensor(:,97))
  call loop_QZ_A(G1(:,:,:,67),wf(:,5),G1(:,:,:,70),gZd)
  call loop_Q_A(G1(:,:,:,70),Q(:,26),ZERO,G2(:,:,:,233))
  call loop_QV_A(G2(:,:,:,233),wf(:,-5),G2(:,:,:,234))
  call loop_Q_A(G2(:,:,:,234),Q(:,58),ZERO,G3(:,:,:,144))
  call loop_QV_A(G3(:,:,:,144),wf(:,1),G3(:,:,:,145))
  call check_last_Q_A(l_switch,G3(:,:,:,145),Q(:,63),ZERO,G4tensor(:,98))
  call loop_QZ_A(G3(:,:,:,144),wf(:,7),G3(:,:,:,146),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,63),ZERO,G4tensor(:,99))
  call loop_QV_A(G1(:,:,:,67),wf(:,9),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,25),ZERO,G2(:,:,:,235))
  call loop_QV_A(G2(:,:,:,235),wf(:,-5),G2(:,:,:,236))
  call loop_Q_A(G2(:,:,:,236),Q(:,57),ZERO,G3(:,:,:,147))
  call loop_QV_A(G3(:,:,:,147),wf(:,10),G3(:,:,:,148))
  call check_last_Q_A(l_switch,G3(:,:,:,148),Q(:,63),ZERO,G4tensor(:,100))
  call loop_QZ_A(G3(:,:,:,147),wf(:,13),G3(:,:,:,149),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,149),Q(:,63),ZERO,G4tensor(:,101))
  call loop_QZ_A(G3(:,:,:,147),wf(:,13),G3(:,:,:,150),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,150),Q(:,63),ZERO,G4tensor(:,102))
  call loop_QZ_A(G1(:,:,:,67),wf(:,15),G1(:,:,:,72),gZu)
  call loop_Q_A(G1(:,:,:,72),Q(:,25),ZERO,G2(:,:,:,237))
  call loop_QV_A(G2(:,:,:,237),wf(:,-5),G2(:,:,:,238))
  call loop_Q_A(G2(:,:,:,238),Q(:,57),ZERO,G3(:,:,:,151))
  call loop_QV_A(G3(:,:,:,151),wf(:,10),G3(:,:,:,152))
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,63),ZERO,G4tensor(:,103))
  call loop_QZ_A(G3(:,:,:,151),wf(:,13),G3(:,:,:,153),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,153),Q(:,63),ZERO,G4tensor(:,104))
  call loop_QZ_A(G1(:,:,:,67),wf(:,15),G1(:,:,:,73),gZd)
  call loop_Q_A(G1(:,:,:,73),Q(:,25),ZERO,G2(:,:,:,239))
  call loop_QV_A(G2(:,:,:,239),wf(:,-5),G2(:,:,:,240))
  call loop_Q_A(G2(:,:,:,240),Q(:,57),ZERO,G3(:,:,:,154))
  call loop_QV_A(G3(:,:,:,154),wf(:,10),G3(:,:,:,155))
  call check_last_Q_A(l_switch,G3(:,:,:,155),Q(:,63),ZERO,G4tensor(:,105))
  call loop_QZ_A(G3(:,:,:,154),wf(:,13),G3(:,:,:,156),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,63),ZERO,G4tensor(:,106))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,16),ZERO,G1(:,:,:,74))
  call loop_AV_Q(G1(:,:,:,74),wf(:,2),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,26),ZERO,G2(:,:,:,241))
  call loop_AV_Q(G2(:,:,:,241),wf(:,-5),G2(:,:,:,242))
  call loop_A_Q(G2(:,:,:,242),Q(:,58),ZERO,G3(:,:,:,157))
  call loop_AV_Q(G3(:,:,:,157),wf(:,1),G3(:,:,:,158))
  call check_last_A_Q(l_switch,G3(:,:,:,158),Q(:,63),ZERO,G4tensor(:,107))
  call loop_AZ_Q(G3(:,:,:,157),wf(:,7),G3(:,:,:,159),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,159),Q(:,63),ZERO,G4tensor(:,108))
  call loop_AZ_Q(G3(:,:,:,157),wf(:,7),G3(:,:,:,160),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,160),Q(:,63),ZERO,G4tensor(:,109))
  call loop_AZ_Q(G1(:,:,:,74),wf(:,5),G1(:,:,:,76),gZu)
  call loop_A_Q(G1(:,:,:,76),Q(:,26),ZERO,G2(:,:,:,243))
  call loop_AV_Q(G2(:,:,:,243),wf(:,-5),G2(:,:,:,244))
  call loop_A_Q(G2(:,:,:,244),Q(:,58),ZERO,G3(:,:,:,161))
  call loop_AV_Q(G3(:,:,:,161),wf(:,1),G3(:,:,:,162))
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,63),ZERO,G4tensor(:,110))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,7),G3(:,:,:,163),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,163),Q(:,63),ZERO,G4tensor(:,111))
  call loop_AZ_Q(G1(:,:,:,74),wf(:,5),G1(:,:,:,77),gZd)
  call loop_A_Q(G1(:,:,:,77),Q(:,26),ZERO,G2(:,:,:,245))
  call loop_AV_Q(G2(:,:,:,245),wf(:,-5),G2(:,:,:,246))
  call loop_A_Q(G2(:,:,:,246),Q(:,58),ZERO,G3(:,:,:,164))
  call loop_AV_Q(G3(:,:,:,164),wf(:,1),G3(:,:,:,165))
  call check_last_A_Q(l_switch,G3(:,:,:,165),Q(:,63),ZERO,G4tensor(:,112))
  call loop_AZ_Q(G3(:,:,:,164),wf(:,7),G3(:,:,:,166),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,166),Q(:,63),ZERO,G4tensor(:,113))
  call loop_AV_Q(G1(:,:,:,74),wf(:,9),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,25),ZERO,G2(:,:,:,247))
  call loop_AV_Q(G2(:,:,:,247),wf(:,-5),G2(:,:,:,248))
  call loop_A_Q(G2(:,:,:,248),Q(:,57),ZERO,G3(:,:,:,167))
  call loop_AV_Q(G3(:,:,:,167),wf(:,10),G3(:,:,:,168))
  call check_last_A_Q(l_switch,G3(:,:,:,168),Q(:,63),ZERO,G4tensor(:,114))
  call loop_AZ_Q(G3(:,:,:,167),wf(:,13),G3(:,:,:,169),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,169),Q(:,63),ZERO,G4tensor(:,115))
  call loop_AZ_Q(G3(:,:,:,167),wf(:,13),G3(:,:,:,170),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,63),ZERO,G4tensor(:,116))
  call loop_AZ_Q(G1(:,:,:,74),wf(:,15),G1(:,:,:,79),gZu)
  call loop_A_Q(G1(:,:,:,79),Q(:,25),ZERO,G2(:,:,:,249))
  call loop_AV_Q(G2(:,:,:,249),wf(:,-5),G2(:,:,:,250))
  call loop_A_Q(G2(:,:,:,250),Q(:,57),ZERO,G3(:,:,:,171))
  call loop_AV_Q(G3(:,:,:,171),wf(:,10),G3(:,:,:,172))
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,63),ZERO,G4tensor(:,117))
  call loop_AZ_Q(G3(:,:,:,171),wf(:,13),G3(:,:,:,173),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,173),Q(:,63),ZERO,G4tensor(:,118))
  call loop_AZ_Q(G1(:,:,:,74),wf(:,15),G1(:,:,:,80),gZd)
  call loop_A_Q(G1(:,:,:,80),Q(:,25),ZERO,G2(:,:,:,251))
  call loop_AV_Q(G2(:,:,:,251),wf(:,-5),G2(:,:,:,252))
  call loop_A_Q(G2(:,:,:,252),Q(:,57),ZERO,G3(:,:,:,174))
  call loop_AV_Q(G3(:,:,:,174),wf(:,10),G3(:,:,:,175))
  call check_last_A_Q(l_switch,G3(:,:,:,175),Q(:,63),ZERO,G4tensor(:,119))
  call loop_AZ_Q(G3(:,:,:,174),wf(:,13),G3(:,:,:,176),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,176),Q(:,63),ZERO,G4tensor(:,120))
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,9),ZERO,G1(:,:,:,81))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-4),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,25),ZERO,G2(:,:,:,253))
  call loop_AV_Q(G2(:,:,:,253),wf(:,-5),G2(:,:,:,254))
  call loop_A_Q(G2(:,:,:,254),Q(:,57),ZERO,G3(:,:,:,177))
  call loop_AV_Q(G3(:,:,:,177),wf(:,10),G3(:,:,:,178))
  call check_last_A_Q(l_switch,G3(:,:,:,178),Q(:,63),ZERO,G4tensor(:,121))
  call loop_AZ_Q(G3(:,:,:,177),wf(:,13),G3(:,:,:,179),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,179),Q(:,63),ZERO,G4tensor(:,122))
  call loop_AZ_Q(G3(:,:,:,177),wf(:,13),G3(:,:,:,180),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,180),Q(:,63),ZERO,G4tensor(:,123))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-5),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,41),ZERO,G2(:,:,:,255))
  call loop_AV_Q(G2(:,:,:,255),wf(:,-4),G2(:,:,:,256))
  call loop_A_Q(G2(:,:,:,256),Q(:,57),ZERO,G3(:,:,:,181))
  call loop_AV_Q(G3(:,:,:,181),wf(:,10),G3(:,:,:,182))
  call check_last_A_Q(l_switch,G3(:,:,:,182),Q(:,63),ZERO,G4tensor(:,124))
  call loop_AZ_Q(G3(:,:,:,181),wf(:,13),G3(:,:,:,183),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,183),Q(:,63),ZERO,G4tensor(:,125))
  call loop_AZ_Q(G3(:,:,:,181),wf(:,13),G3(:,:,:,184),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,184),Q(:,63),ZERO,G4tensor(:,126))
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,9),MT,G1(:,:,:,84))
  call loop_AV_Q(G1(:,:,:,84),wf(:,-4),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,25),MT,G2(:,:,:,257))
  call loop_AV_Q(G2(:,:,:,257),wf(:,-5),G2(:,:,:,258))
  call loop_A_Q(G2(:,:,:,258),Q(:,57),MT,G3(:,:,:,185))
  call loop_AV_Q(G3(:,:,:,185),wf(:,10),G3(:,:,:,186))
  call check_last_A_Q(l_switch,G3(:,:,:,186),Q(:,63),MT,G4tensor(:,127))
  call loop_AZ_Q(G3(:,:,:,185),wf(:,13),G3(:,:,:,187),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,187),Q(:,63),MT,G4tensor(:,128))
  call loop_AV_Q(G1(:,:,:,84),wf(:,-5),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,41),MT,G2(:,:,:,259))
  call loop_AV_Q(G2(:,:,:,259),wf(:,-4),G2(:,:,:,260))
  call loop_A_Q(G2(:,:,:,260),Q(:,57),MT,G3(:,:,:,188))
  call loop_AV_Q(G3(:,:,:,188),wf(:,10),G3(:,:,:,189))
  call check_last_A_Q(l_switch,G3(:,:,:,189),Q(:,63),MT,G4tensor(:,129))
  call loop_AZ_Q(G3(:,:,:,188),wf(:,13),G3(:,:,:,190),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,190),Q(:,63),MT,G4tensor(:,130))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,9),ZERO,G1(:,:,:,87))
  call loop_QV_A(G1(:,:,:,87),wf(:,-4),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,25),ZERO,G2(:,:,:,261))
  call loop_QV_A(G2(:,:,:,261),wf(:,-5),G2(:,:,:,262))
  call loop_Q_A(G2(:,:,:,262),Q(:,57),ZERO,G3(:,:,:,191))
  call loop_QV_A(G3(:,:,:,191),wf(:,10),G3(:,:,:,192))
  call check_last_Q_A(l_switch,G3(:,:,:,192),Q(:,63),ZERO,G4tensor(:,131))
  call loop_QZ_A(G3(:,:,:,191),wf(:,13),G3(:,:,:,193),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,193),Q(:,63),ZERO,G4tensor(:,132))
  call loop_QZ_A(G3(:,:,:,191),wf(:,13),G3(:,:,:,194),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,63),ZERO,G4tensor(:,133))
  call loop_QV_A(G1(:,:,:,87),wf(:,-5),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,41),ZERO,G2(:,:,:,263))
  call loop_QV_A(G2(:,:,:,263),wf(:,-4),G2(:,:,:,264))
  call loop_Q_A(G2(:,:,:,264),Q(:,57),ZERO,G3(:,:,:,195))
  call loop_QV_A(G3(:,:,:,195),wf(:,10),G3(:,:,:,196))
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,63),ZERO,G4tensor(:,134))
  call loop_QZ_A(G3(:,:,:,195),wf(:,13),G3(:,:,:,197),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,197),Q(:,63),ZERO,G4tensor(:,135))
  call loop_QZ_A(G3(:,:,:,195),wf(:,13),G3(:,:,:,198),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,198),Q(:,63),ZERO,G4tensor(:,136))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,9),MT,G1(:,:,:,90))
  call loop_QV_A(G1(:,:,:,90),wf(:,-4),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,25),MT,G2(:,:,:,265))
  call loop_QV_A(G2(:,:,:,265),wf(:,-5),G2(:,:,:,266))
  call loop_Q_A(G2(:,:,:,266),Q(:,57),MT,G3(:,:,:,199))
  call loop_QV_A(G3(:,:,:,199),wf(:,10),G3(:,:,:,200))
  call check_last_Q_A(l_switch,G3(:,:,:,200),Q(:,63),MT,G4tensor(:,137))
  call loop_QZ_A(G3(:,:,:,199),wf(:,13),G3(:,:,:,201),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,201),Q(:,63),MT,G4tensor(:,138))
  call loop_QV_A(G1(:,:,:,90),wf(:,-5),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,41),MT,G2(:,:,:,267))
  call loop_QV_A(G2(:,:,:,267),wf(:,-4),G2(:,:,:,268))
  call loop_Q_A(G2(:,:,:,268),Q(:,57),MT,G3(:,:,:,202))
  call loop_QV_A(G3(:,:,:,202),wf(:,10),G3(:,:,:,203))
  call check_last_Q_A(l_switch,G3(:,:,:,203),Q(:,63),MT,G4tensor(:,139))
  call loop_QZ_A(G3(:,:,:,202),wf(:,13),G3(:,:,:,204),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,204),Q(:,63),MT,G4tensor(:,140))
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,9),MB,G1(:,:,:,93))
  call loop_AV_Q(G1(:,:,:,93),wf(:,-4),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,25),MB,G2(:,:,:,269))
  call loop_AV_Q(G2(:,:,:,269),wf(:,-5),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,57),MB,G3(:,:,:,205))
  call loop_AV_Q(G3(:,:,:,205),wf(:,10),G3(:,:,:,206))
  call check_last_A_Q(l_switch,G3(:,:,:,206),Q(:,63),MB,G4tensor(:,141))
  call loop_AZ_Q(G3(:,:,:,205),wf(:,13),G3(:,:,:,207),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,207),Q(:,63),MB,G4tensor(:,142))
  call loop_AV_Q(G1(:,:,:,93),wf(:,-5),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,41),MB,G2(:,:,:,271))
  call loop_AV_Q(G2(:,:,:,271),wf(:,-4),G2(:,:,:,272))
  call loop_A_Q(G2(:,:,:,272),Q(:,57),MB,G3(:,:,:,208))
  call loop_AV_Q(G3(:,:,:,208),wf(:,10),G3(:,:,:,209))
  call check_last_A_Q(l_switch,G3(:,:,:,209),Q(:,63),MB,G4tensor(:,143))
  call loop_AZ_Q(G3(:,:,:,208),wf(:,13),G3(:,:,:,210),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,210),Q(:,63),MB,G4tensor(:,144))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,9),MB,G1(:,:,:,96))
  call loop_QV_A(G1(:,:,:,96),wf(:,-4),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,25),MB,G2(:,:,:,273))
  call loop_QV_A(G2(:,:,:,273),wf(:,-5),G2(:,:,:,274))
  call loop_Q_A(G2(:,:,:,274),Q(:,57),MB,G3(:,:,:,211))
  call loop_QV_A(G3(:,:,:,211),wf(:,10),G3(:,:,:,212))
  call check_last_Q_A(l_switch,G3(:,:,:,212),Q(:,63),MB,G4tensor(:,145))
  call loop_QZ_A(G3(:,:,:,211),wf(:,13),G3(:,:,:,213),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,213),Q(:,63),MB,G4tensor(:,146))
  call loop_QV_A(G1(:,:,:,96),wf(:,-5),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,41),MB,G2(:,:,:,275))
  call loop_QV_A(G2(:,:,:,275),wf(:,-4),G2(:,:,:,276))
  call loop_Q_A(G2(:,:,:,276),Q(:,57),MB,G3(:,:,:,214))
  call loop_QV_A(G3(:,:,:,214),wf(:,10),G3(:,:,:,215))
  call check_last_Q_A(l_switch,G3(:,:,:,215),Q(:,63),MB,G4tensor(:,147))
  call loop_QZ_A(G3(:,:,:,214),wf(:,13),G3(:,:,:,216),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,216),Q(:,63),MB,G4tensor(:,148))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,28),gZu)
  call loop_A_Q(G0(:,:,:,28),Q(:,9),ZERO,G1(:,:,:,99))
  call loop_AV_Q(G1(:,:,:,99),wf(:,-4),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,25),ZERO,G2(:,:,:,277))
  call loop_AV_Q(G2(:,:,:,277),wf(:,-5),G2(:,:,:,278))
  call loop_A_Q(G2(:,:,:,278),Q(:,57),ZERO,G3(:,:,:,217))
  call loop_AV_Q(G3(:,:,:,217),wf(:,10),G3(:,:,:,218))
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,63),ZERO,G4tensor(:,149))
  call loop_AZ_Q(G3(:,:,:,217),wf(:,13),G3(:,:,:,219),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,219),Q(:,63),ZERO,G4tensor(:,150))
  call loop_AV_Q(G1(:,:,:,99),wf(:,-5),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,41),ZERO,G2(:,:,:,279))
  call loop_AV_Q(G2(:,:,:,279),wf(:,-4),G2(:,:,:,280))
  call loop_A_Q(G2(:,:,:,280),Q(:,57),ZERO,G3(:,:,:,220))
  call loop_AV_Q(G3(:,:,:,220),wf(:,10),G3(:,:,:,221))
  call check_last_A_Q(l_switch,G3(:,:,:,221),Q(:,63),ZERO,G4tensor(:,151))
  call loop_AZ_Q(G3(:,:,:,220),wf(:,13),G3(:,:,:,222),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,222),Q(:,63),ZERO,G4tensor(:,152))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,29),gZu)
  call loop_A_Q(G0(:,:,:,29),Q(:,9),MT,G1(:,:,:,102))
  call loop_AV_Q(G1(:,:,:,102),wf(:,-4),G1(:,:,:,103))
  call loop_A_Q(G1(:,:,:,103),Q(:,25),MT,G2(:,:,:,281))
  call loop_AV_Q(G2(:,:,:,281),wf(:,-5),G2(:,:,:,282))
  call loop_A_Q(G2(:,:,:,282),Q(:,57),MT,G3(:,:,:,223))
  call loop_AV_Q(G3(:,:,:,223),wf(:,10),G3(:,:,:,224))
  call check_last_A_Q(l_switch,G3(:,:,:,224),Q(:,63),MT,G4tensor(:,153))
  call loop_AZ_Q(G3(:,:,:,223),wf(:,13),G3(:,:,:,225),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,225),Q(:,63),MT,G4tensor(:,154))
  call loop_AV_Q(G1(:,:,:,102),wf(:,-5),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,41),MT,G2(:,:,:,283))
  call loop_AV_Q(G2(:,:,:,283),wf(:,-4),G2(:,:,:,284))
  call loop_A_Q(G2(:,:,:,284),Q(:,57),MT,G3(:,:,:,226))
  call loop_AV_Q(G3(:,:,:,226),wf(:,10),G3(:,:,:,227))
  call check_last_A_Q(l_switch,G3(:,:,:,227),Q(:,63),MT,G4tensor(:,155))
  call loop_AZ_Q(G3(:,:,:,226),wf(:,13),G3(:,:,:,228),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,228),Q(:,63),MT,G4tensor(:,156))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,30),gZu)
  call loop_Q_A(G0(:,:,:,30),Q(:,9),ZERO,G1(:,:,:,105))
  call loop_QV_A(G1(:,:,:,105),wf(:,-4),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,25),ZERO,G2(:,:,:,285))
  call loop_QV_A(G2(:,:,:,285),wf(:,-5),G2(:,:,:,286))
  call loop_Q_A(G2(:,:,:,286),Q(:,57),ZERO,G3(:,:,:,229))
  call loop_QV_A(G3(:,:,:,229),wf(:,10),G3(:,:,:,230))
  call check_last_Q_A(l_switch,G3(:,:,:,230),Q(:,63),ZERO,G4tensor(:,157))
  call loop_QZ_A(G3(:,:,:,229),wf(:,13),G3(:,:,:,231),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,231),Q(:,63),ZERO,G4tensor(:,158))
  call loop_QV_A(G1(:,:,:,105),wf(:,-5),G1(:,:,:,107))
  call loop_Q_A(G1(:,:,:,107),Q(:,41),ZERO,G2(:,:,:,287))
  call loop_QV_A(G2(:,:,:,287),wf(:,-4),G2(:,:,:,288))
  call loop_Q_A(G2(:,:,:,288),Q(:,57),ZERO,G3(:,:,:,232))
  call loop_QV_A(G3(:,:,:,232),wf(:,10),G3(:,:,:,233))
  call check_last_Q_A(l_switch,G3(:,:,:,233),Q(:,63),ZERO,G4tensor(:,159))
  call loop_QZ_A(G3(:,:,:,232),wf(:,13),G3(:,:,:,234),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,234),Q(:,63),ZERO,G4tensor(:,160))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,31),gZu)
  call loop_Q_A(G0(:,:,:,31),Q(:,9),MT,G1(:,:,:,108))
  call loop_QV_A(G1(:,:,:,108),wf(:,-4),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,25),MT,G2(:,:,:,289))
  call loop_QV_A(G2(:,:,:,289),wf(:,-5),G2(:,:,:,290))
  call loop_Q_A(G2(:,:,:,290),Q(:,57),MT,G3(:,:,:,235))
  call loop_QV_A(G3(:,:,:,235),wf(:,10),G3(:,:,:,236))
  call check_last_Q_A(l_switch,G3(:,:,:,236),Q(:,63),MT,G4tensor(:,161))
  call loop_QZ_A(G3(:,:,:,235),wf(:,13),G3(:,:,:,237),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,237),Q(:,63),MT,G4tensor(:,162))
  call loop_QV_A(G1(:,:,:,108),wf(:,-5),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,41),MT,G2(:,:,:,291))
  call loop_QV_A(G2(:,:,:,291),wf(:,-4),G2(:,:,:,292))
  call loop_Q_A(G2(:,:,:,292),Q(:,57),MT,G3(:,:,:,238))
  call loop_QV_A(G3(:,:,:,238),wf(:,10),G3(:,:,:,239))
  call check_last_Q_A(l_switch,G3(:,:,:,239),Q(:,63),MT,G4tensor(:,163))
  call loop_QZ_A(G3(:,:,:,238),wf(:,13),G3(:,:,:,240),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,240),Q(:,63),MT,G4tensor(:,164))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,32),gZd)
  call loop_A_Q(G0(:,:,:,32),Q(:,9),ZERO,G1(:,:,:,111))
  call loop_AV_Q(G1(:,:,:,111),wf(:,-4),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,25),ZERO,G2(:,:,:,293))
  call loop_AV_Q(G2(:,:,:,293),wf(:,-5),G2(:,:,:,294))
  call loop_A_Q(G2(:,:,:,294),Q(:,57),ZERO,G3(:,:,:,241))
  call loop_AV_Q(G3(:,:,:,241),wf(:,10),G3(:,:,:,242))
  call check_last_A_Q(l_switch,G3(:,:,:,242),Q(:,63),ZERO,G4tensor(:,165))
  call loop_AZ_Q(G3(:,:,:,241),wf(:,13),G3(:,:,:,243),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,243),Q(:,63),ZERO,G4tensor(:,166))
  call loop_AV_Q(G1(:,:,:,111),wf(:,-5),G1(:,:,:,113))
  call loop_A_Q(G1(:,:,:,113),Q(:,41),ZERO,G2(:,:,:,295))
  call loop_AV_Q(G2(:,:,:,295),wf(:,-4),G2(:,:,:,296))
  call loop_A_Q(G2(:,:,:,296),Q(:,57),ZERO,G3(:,:,:,244))
  call loop_AV_Q(G3(:,:,:,244),wf(:,10),G3(:,:,:,245))
  call check_last_A_Q(l_switch,G3(:,:,:,245),Q(:,63),ZERO,G4tensor(:,167))
  call loop_AZ_Q(G3(:,:,:,244),wf(:,13),G3(:,:,:,246),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,246),Q(:,63),ZERO,G4tensor(:,168))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,33),gZd)
  call loop_A_Q(G0(:,:,:,33),Q(:,9),MB,G1(:,:,:,114))
  call loop_AV_Q(G1(:,:,:,114),wf(:,-4),G1(:,:,:,115))
  call loop_A_Q(G1(:,:,:,115),Q(:,25),MB,G2(:,:,:,297))
  call loop_AV_Q(G2(:,:,:,297),wf(:,-5),G2(:,:,:,298))
  call loop_A_Q(G2(:,:,:,298),Q(:,57),MB,G3(:,:,:,247))
  call loop_AV_Q(G3(:,:,:,247),wf(:,10),G3(:,:,:,248))
  call check_last_A_Q(l_switch,G3(:,:,:,248),Q(:,63),MB,G4tensor(:,169))
  call loop_AZ_Q(G3(:,:,:,247),wf(:,13),G3(:,:,:,249),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,249),Q(:,63),MB,G4tensor(:,170))
  call loop_AV_Q(G1(:,:,:,114),wf(:,-5),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,41),MB,G2(:,:,:,299))
  call loop_AV_Q(G2(:,:,:,299),wf(:,-4),G2(:,:,:,300))
  call loop_A_Q(G2(:,:,:,300),Q(:,57),MB,G3(:,:,:,250))
  call loop_AV_Q(G3(:,:,:,250),wf(:,10),G3(:,:,:,251))
  call check_last_A_Q(l_switch,G3(:,:,:,251),Q(:,63),MB,G4tensor(:,171))
  call loop_AZ_Q(G3(:,:,:,250),wf(:,13),G3(:,:,:,252),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,252),Q(:,63),MB,G4tensor(:,172))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,34),gZd)
  call loop_Q_A(G0(:,:,:,34),Q(:,9),ZERO,G1(:,:,:,117))
  call loop_QV_A(G1(:,:,:,117),wf(:,-4),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,25),ZERO,G2(:,:,:,301))
  call loop_QV_A(G2(:,:,:,301),wf(:,-5),G2(:,:,:,302))
  call loop_Q_A(G2(:,:,:,302),Q(:,57),ZERO,G3(:,:,:,253))
  call loop_QV_A(G3(:,:,:,253),wf(:,10),G3(:,:,:,254))
  call check_last_Q_A(l_switch,G3(:,:,:,254),Q(:,63),ZERO,G4tensor(:,173))
  call loop_QZ_A(G3(:,:,:,253),wf(:,13),G3(:,:,:,255),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,255),Q(:,63),ZERO,G4tensor(:,174))
  call loop_QV_A(G1(:,:,:,117),wf(:,-5),G1(:,:,:,119))
  call loop_Q_A(G1(:,:,:,119),Q(:,41),ZERO,G2(:,:,:,303))
  call loop_QV_A(G2(:,:,:,303),wf(:,-4),G2(:,:,:,304))
  call loop_Q_A(G2(:,:,:,304),Q(:,57),ZERO,G3(:,:,:,256))
  call loop_QV_A(G3(:,:,:,256),wf(:,10),G3(:,:,:,257))
  call check_last_Q_A(l_switch,G3(:,:,:,257),Q(:,63),ZERO,G4tensor(:,175))
  call loop_QZ_A(G3(:,:,:,256),wf(:,13),G3(:,:,:,258),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,258),Q(:,63),ZERO,G4tensor(:,176))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,35),gZd)
  call loop_Q_A(G0(:,:,:,35),Q(:,9),MB,G1(:,:,:,120))
  call loop_QV_A(G1(:,:,:,120),wf(:,-4),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,25),MB,G2(:,:,:,305))
  call loop_QV_A(G2(:,:,:,305),wf(:,-5),G2(:,:,:,306))
  call loop_Q_A(G2(:,:,:,306),Q(:,57),MB,G3(:,:,:,259))
  call loop_QV_A(G3(:,:,:,259),wf(:,10),G3(:,:,:,260))
  call check_last_Q_A(l_switch,G3(:,:,:,260),Q(:,63),MB,G4tensor(:,177))
  call loop_QZ_A(G3(:,:,:,259),wf(:,13),G3(:,:,:,261),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,261),Q(:,63),MB,G4tensor(:,178))
  call loop_QV_A(G1(:,:,:,120),wf(:,-5),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,41),MB,G2(:,:,:,307))
  call loop_QV_A(G2(:,:,:,307),wf(:,-4),G2(:,:,:,308))
  call loop_Q_A(G2(:,:,:,308),Q(:,57),MB,G3(:,:,:,262))
  call loop_QV_A(G3(:,:,:,262),wf(:,10),G3(:,:,:,263))
  call check_last_Q_A(l_switch,G3(:,:,:,263),Q(:,63),MB,G4tensor(:,179))
  call loop_QZ_A(G3(:,:,:,262),wf(:,13),G3(:,:,:,264),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,264),Q(:,63),MB,G4tensor(:,180))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-f(17) * den(52)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-f(17) * den(52)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,35),T3sum(1:35,1))
  M(1) = M(1) + (-f(15) * den(52)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,69),T3sum(1:35,2))
  M(1) = M(1) + (-f(15) * den(52)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,103),T3sum(1:35,2))
  M(1) = M(1) + (f(10) * den(3)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,33),T4sum(1:70,1))
  M(1) = M(1) + (f(8) * den(3)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,39),T4sum(1:70,2))
  M(1) = M(1) + (f(10) * den(3)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,43),T4sum(1:70,1))
  M(1) = M(1) + (f(8) * den(3)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,49),T4sum(1:70,2))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,33),T4sum(1:70,1))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,53),T4sum(1:70,3))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,43),T4sum(1:70,1))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,57),T4sum(1:70,3))
  M(1) = M(1) + (-f(12) * den(5)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,61),T4sum(1:70,1))
  M(1) = M(1) + (-f(9) * den(5)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,65),T4sum(1:70,2))
  M(1) = M(1) + (-f(12) * den(5)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,69),T4sum(1:70,1))
  M(1) = M(1) + (-f(9) * den(5)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,73),T4sum(1:70,2))
  M(1) = M(1) + (f(9) * den(5)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,77),T4sum(1:70,1))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,81),T4sum(1:70,3))
  M(1) = M(1) + (f(9) * den(5)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,85),T4sum(1:70,1))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,89),T4sum(1:70,3))
  M(1) = M(1) + (-f(12) * den(7)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,34),T4sum(1:70,1))
  M(1) = M(1) + (-f(9) * den(7)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,40),T4sum(1:70,2))
  M(1) = M(1) + (-f(12) * den(7)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,44),T4sum(1:70,1))
  M(1) = M(1) + (-f(9) * den(7)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,50),T4sum(1:70,2))
  M(1) = M(1) + (f(9) * den(7)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,35),T4sum(1:70,1))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,54),T4sum(1:70,3))
  M(1) = M(1) + (f(9) * den(7)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,45),T4sum(1:70,1))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,58),T4sum(1:70,3))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,62),T4sum(1:70,1))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,66),T4sum(1:70,2))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,70),T4sum(1:70,1))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,74),T4sum(1:70,2))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,78),T4sum(1:70,1))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,82),T4sum(1:70,3))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,86),T4sum(1:70,1))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,90),T4sum(1:70,3))
  M(1) = M(1) + (f(10) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,46),T4sum(1:70,4))
  M(1) = M(1) + (f(8) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,51),T4sum(1:70,5))
  M(1) = M(1) + (f(10) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,36),T4sum(1:70,4))
  M(1) = M(1) + (f(8) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,41),T4sum(1:70,5))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,46),T4sum(1:70,4))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,59),T4sum(1:70,6))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,36),T4sum(1:70,4))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,55),T4sum(1:70,6))
  M(1) = M(1) + (-f(12) * den(5)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,71),T4sum(1:70,4))
  M(1) = M(1) + (-f(9) * den(5)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,75),T4sum(1:70,5))
  M(1) = M(1) + (-f(12) * den(5)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,63),T4sum(1:70,4))
  M(1) = M(1) + (-f(9) * den(5)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,67),T4sum(1:70,5))
  M(1) = M(1) + (f(9) * den(5)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,87),T4sum(1:70,4))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,91),T4sum(1:70,6))
  M(1) = M(1) + (f(9) * den(5)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,79),T4sum(1:70,4))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,83),T4sum(1:70,6))
  M(1) = M(1) + (-f(12) * den(7)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,47),T4sum(1:70,4))
  M(1) = M(1) + (-f(9) * den(7)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,52),T4sum(1:70,5))
  M(1) = M(1) + (-f(12) * den(7)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,37),T4sum(1:70,4))
  M(1) = M(1) + (-f(9) * den(7)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,42),T4sum(1:70,5))
  M(1) = M(1) + (f(9) * den(7)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,48),T4sum(1:70,4))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,60),T4sum(1:70,6))
  M(1) = M(1) + (f(9) * den(7)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,38),T4sum(1:70,4))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,56),T4sum(1:70,6))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,72),T4sum(1:70,4))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,76),T4sum(1:70,5))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,64),T4sum(1:70,4))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,68),T4sum(1:70,5))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,88),T4sum(1:70,4))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,92),T4sum(1:70,6))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,80),T4sum(1:70,4))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,84),T4sum(1:70,6))
  M(1) = M(1) + (f(10) * den(3)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,93),T4sum(1:70,7))
  M(1) = M(1) + (f(8) * den(3)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,9),T4sum(1:70,8))
  M(1) = M(1) + (f(10) * den(3)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,107),T4sum(1:70,7))
  M(1) = M(1) + (f(8) * den(3)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,1),T4sum(1:70,8))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,93),T4sum(1:70,7))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,25),T4sum(1:70,9))
  M(1) = M(1) + (f(6) * den(3)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,107),T4sum(1:70,7))
  M(1) = M(1) + (f(5) * den(3)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,17),T4sum(1:70,9))
  M(1) = M(1) + (-f(12) * den(5)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,96),T4sum(1:70,7))
  M(1) = M(1) + (-f(9) * den(5)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,11),T4sum(1:70,8))
  M(1) = M(1) + (-f(12) * den(5)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,110),T4sum(1:70,7))
  M(1) = M(1) + (-f(9) * den(5)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,3),T4sum(1:70,8))
  M(1) = M(1) + (f(9) * den(5)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,98),T4sum(1:70,7))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,27),T4sum(1:70,9))
  M(1) = M(1) + (f(9) * den(5)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,112),T4sum(1:70,7))
  M(1) = M(1) + (f(7) * den(5)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,19),T4sum(1:70,9))
  M(1) = M(1) + (-f(12) * den(7)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,94),T4sum(1:70,7))
  M(1) = M(1) + (-f(9) * den(7)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,10),T4sum(1:70,8))
  M(1) = M(1) + (-f(12) * den(7)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,108),T4sum(1:70,7))
  M(1) = M(1) + (-f(9) * den(7)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,2),T4sum(1:70,8))
  M(1) = M(1) + (f(9) * den(7)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,95),T4sum(1:70,7))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,26),T4sum(1:70,9))
  M(1) = M(1) + (f(9) * den(7)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,109),T4sum(1:70,7))
  M(1) = M(1) + (f(7) * den(7)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,18),T4sum(1:70,9))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,97),T4sum(1:70,7))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,12),T4sum(1:70,8))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,111),T4sum(1:70,7))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,4),T4sum(1:70,8))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,99),T4sum(1:70,7))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,28),T4sum(1:70,9))
  M(1) = M(1) + (f(13) * den(8)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,113),T4sum(1:70,7))
  M(1) = M(1) + (f(11) * den(8)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,20),T4sum(1:70,9))
  M(1) = M(1) + (-f(9) * den(54)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(54)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,36),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(54)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,70),T3sum(1:35,2))
  M(1) = M(1) + (f(7) * den(54)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,104),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(56)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(56)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,37),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,71),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,105),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(57)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(57)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,38),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(57)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,72),T3sum(1:35,2))
  M(1) = M(1) + (f(7) * den(57)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,106),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(58)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(58)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,39),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(58)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,73),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(58)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,107),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(61)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(61)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,40),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,74),T3sum(1:35,2))
  M(1) = M(1) + (f(7) * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,108),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(62)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(62)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,41),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,75),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(62)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,109),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(64)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(64)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,42),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(64)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,76),T3sum(1:35,2))
  M(1) = M(1) + (f(7) * den(64)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,110),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(65)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(65)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,43),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,77),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,111),T3sum(1:35,2))
  M(1) = M(1) + (f(17) * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(17) * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,44),T3sum(1:35,1))
  M(1) = M(1) + (f(15) * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,78),T3sum(1:35,2))
  M(1) = M(1) + (f(15) * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,112),T3sum(1:35,2))
  M(1) = M(1) + (-f(10) * den(11)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,121),T4sum(1:70,10))
  M(1) = M(1) + (-f(8) * den(11)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,127),T4sum(1:70,11))
  M(1) = M(1) + (-f(10) * den(11)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,131),T4sum(1:70,10))
  M(1) = M(1) + (-f(8) * den(11)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,137),T4sum(1:70,11))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,121),T4sum(1:70,10))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,141),T4sum(1:70,12))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,131),T4sum(1:70,10))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,145),T4sum(1:70,12))
  M(1) = M(1) + (f(12) * den(13)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,122),T4sum(1:70,10))
  M(1) = M(1) + (f(9) * den(13)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,128),T4sum(1:70,11))
  M(1) = M(1) + (f(12) * den(13)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,132),T4sum(1:70,10))
  M(1) = M(1) + (f(9) * den(13)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,138),T4sum(1:70,11))
  M(1) = M(1) + (-f(9) * den(13)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,123),T4sum(1:70,10))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,142),T4sum(1:70,12))
  M(1) = M(1) + (-f(9) * den(13)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,133),T4sum(1:70,10))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,146),T4sum(1:70,12))
  M(1) = M(1) + (f(12) * den(15)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,149),T4sum(1:70,10))
  M(1) = M(1) + (f(9) * den(15)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,153),T4sum(1:70,11))
  M(1) = M(1) + (f(12) * den(15)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,157),T4sum(1:70,10))
  M(1) = M(1) + (f(9) * den(15)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,161),T4sum(1:70,11))
  M(1) = M(1) + (-f(9) * den(15)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,165),T4sum(1:70,10))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,169),T4sum(1:70,12))
  M(1) = M(1) + (-f(9) * den(15)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,173),T4sum(1:70,10))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,177),T4sum(1:70,12))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,150),T4sum(1:70,10))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,154),T4sum(1:70,11))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,158),T4sum(1:70,10))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,162),T4sum(1:70,11))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,166),T4sum(1:70,10))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,170),T4sum(1:70,12))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,174),T4sum(1:70,10))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_2,masses2_3,G4tensor(:,178),T4sum(1:70,12))
  M(1) = M(1) + (-f(10) * den(11)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,134),T4sum(1:70,13))
  M(1) = M(1) + (-f(8) * den(11)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,139),T4sum(1:70,14))
  M(1) = M(1) + (-f(10) * den(11)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,124),T4sum(1:70,13))
  M(1) = M(1) + (-f(8) * den(11)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,129),T4sum(1:70,14))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,134),T4sum(1:70,13))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,147),T4sum(1:70,15))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,124),T4sum(1:70,13))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,143),T4sum(1:70,15))
  M(1) = M(1) + (f(12) * den(13)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,135),T4sum(1:70,13))
  M(1) = M(1) + (f(9) * den(13)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,140),T4sum(1:70,14))
  M(1) = M(1) + (f(12) * den(13)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,125),T4sum(1:70,13))
  M(1) = M(1) + (f(9) * den(13)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,130),T4sum(1:70,14))
  M(1) = M(1) + (-f(9) * den(13)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,136),T4sum(1:70,13))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,148),T4sum(1:70,15))
  M(1) = M(1) + (-f(9) * den(13)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,126),T4sum(1:70,13))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,144),T4sum(1:70,15))
  M(1) = M(1) + (f(12) * den(15)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,159),T4sum(1:70,13))
  M(1) = M(1) + (f(9) * den(15)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,163),T4sum(1:70,14))
  M(1) = M(1) + (f(12) * den(15)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,151),T4sum(1:70,13))
  M(1) = M(1) + (f(9) * den(15)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,155),T4sum(1:70,14))
  M(1) = M(1) + (-f(9) * den(15)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,175),T4sum(1:70,13))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,179),T4sum(1:70,15))
  M(1) = M(1) + (-f(9) * den(15)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,167),T4sum(1:70,13))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,171),T4sum(1:70,15))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,160),T4sum(1:70,13))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,164),T4sum(1:70,14))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,152),T4sum(1:70,13))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,156),T4sum(1:70,14))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,176),T4sum(1:70,13))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,180),T4sum(1:70,15))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,168),T4sum(1:70,13))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_3,masses2_3,G4tensor(:,172),T4sum(1:70,15))
  M(1) = M(1) + (-f(10) * den(11)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,114),T4sum(1:70,16))
  M(1) = M(1) + (-f(8) * den(11)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,5),T4sum(1:70,17))
  M(1) = M(1) + (-f(10) * den(11)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,100),T4sum(1:70,16))
  M(1) = M(1) + (-f(8) * den(11)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,13),T4sum(1:70,17))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,114),T4sum(1:70,16))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,21),T4sum(1:70,18))
  M(1) = M(1) + (-f(6) * den(11)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,100),T4sum(1:70,16))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,29),T4sum(1:70,18))
  M(1) = M(1) + (f(12) * den(13)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,115),T4sum(1:70,16))
  M(1) = M(1) + (f(9) * den(13)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,6),T4sum(1:70,17))
  M(1) = M(1) + (f(12) * den(13)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,101),T4sum(1:70,16))
  M(1) = M(1) + (f(9) * den(13)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,14),T4sum(1:70,17))
  M(1) = M(1) + (-f(9) * den(13)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,116),T4sum(1:70,16))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,22),T4sum(1:70,18))
  M(1) = M(1) + (-f(9) * den(13)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,102),T4sum(1:70,16))
  M(1) = M(1) + (-f(7) * den(13)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,30),T4sum(1:70,18))
  M(1) = M(1) + (f(12) * den(15)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,117),T4sum(1:70,16))
  M(1) = M(1) + (f(9) * den(15)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,7),T4sum(1:70,17))
  M(1) = M(1) + (f(12) * den(15)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,103),T4sum(1:70,16))
  M(1) = M(1) + (f(9) * den(15)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,15),T4sum(1:70,17))
  M(1) = M(1) + (-f(9) * den(15)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,119),T4sum(1:70,16))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,23),T4sum(1:70,18))
  M(1) = M(1) + (-f(9) * den(15)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,105),T4sum(1:70,16))
  M(1) = M(1) + (-f(7) * den(15)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,31),T4sum(1:70,18))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,118),T4sum(1:70,16))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,8),T4sum(1:70,17))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,104),T4sum(1:70,16))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,16),T4sum(1:70,17))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,120),T4sum(1:70,16))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,24),T4sum(1:70,18))
  M(1) = M(1) + (-f(13) * den(16)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,106),T4sum(1:70,16))
  M(1) = M(1) + (-f(11) * den(16)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,32),T4sum(1:70,18))
  M(1) = M(1) + (f(9) * den(67)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (f(9) * den(67)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,45),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,79),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(67)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,113),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(68)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(68)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,46),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(68)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,80),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(68)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,114),T3sum(1:35,2))
  M(1) = M(1) + (f(9) * den(69)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (f(9) * den(69)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,47),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(69)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,81),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(69)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,115),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(70)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(70)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,48),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,82),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(70)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,116),T3sum(1:35,2))
  M(1) = M(1) + (f(9) * den(73)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (f(9) * den(73)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,49),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,83),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,117),T3sum(1:35,2))
  M(1) = M(1) + (f(9) * den(75)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (f(9) * den(75)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,50),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(75)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,84),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(75)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,118),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(76)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(76)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,51),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,85),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(76)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,119),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(77)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(77)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,52),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(77)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,86),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(77)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,120),T3sum(1:35,2))
  M(1) = M(1) + (f(9) * den(78)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (f(9) * den(78)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,53),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,87),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,121),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,54),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,88),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,122),T3sum(1:35,2))
  M(1) = M(1) + (f(9) * den(80)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (f(9) * den(80)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,55),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,89),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,123),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(81)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(81)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,56),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(81)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,90),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(81)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,124),T3sum(1:35,2))
  M(1) = M(1) + (f(9) * den(83)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(1) = M(1) + (f(9) * den(83)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,57),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(83)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,91),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(83)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,125),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(84)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(84)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,58),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(84)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,92),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(84)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,126),T3sum(1:35,2))
  M(1) = M(1) + (f(9) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,25),T3sum(1:35,1))
  M(1) = M(1) + (f(9) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,59),T3sum(1:35,1))
  M(1) = M(1) + (-f(7) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,93),T3sum(1:35,2))
  M(1) = M(1) + (-f(7) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,127),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,26),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,60),T3sum(1:35,1))
  M(1) = M(1) + (-f(11) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,94),T3sum(1:35,2))
  M(1) = M(1) + (-f(11) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,128),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(88)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,27),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(88)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,61),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,95),T3sum(1:35,2))
  M(1) = M(1) + (f(7) * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,129),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(89)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,28),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(89)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,62),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(89)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,96),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(89)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,130),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(90)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,29),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(90)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,63),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(90)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,97),T3sum(1:35,2))
  M(1) = M(1) + (f(7) * den(90)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,131),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(91)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,30),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(91)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,64),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(91)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,98),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(91)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,132),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(93)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,31),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(93)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,65),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(93)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,99),T3sum(1:35,2))
  M(1) = M(1) + (f(7) * den(93)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,133),T3sum(1:35,2))
  M(1) = M(1) + (-f(9) * den(95)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,32),T3sum(1:35,1))
  M(1) = M(1) + (-f(9) * den(95)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,66),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(95)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,100),T3sum(1:35,2))
  M(1) = M(1) + (f(7) * den(95)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,134),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(96)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,33),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(96)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,67),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(96)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,101),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(96)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,135),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(97)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,34),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(97)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,68),T3sum(1:35,1))
  M(1) = M(1) + (f(11) * den(97)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,102),T3sum(1:35,2))
  M(1) = M(1) + (f(11) * den(97)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,136),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllll2_eeexexgg_1_/**/REALKIND
