
module ol_colourmatrix_pplljjj_eexddxssxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(120,4), K2(4,4), KL(4,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  36,  12,  12,   0]
  K1(  2,:) = [  12,  36,   0,  12]
  K1(  3,:) = [  12,   0,  36,  12]
  K1(  4,:) = [   0,  12,  12,  36]
  K1(  5,:) = [   0,   0,   0,   0]
  K1(  6,:) = [   0,   0,   0,   0]
  K1(  7,:) = [   0,   0,   0,   0]
  K1(  8,:) = [   0,   0,   0,   0]
  K1(  9,:) = [   0,   0,   0,   0]
  K1( 10,:) = [   0,   0,   0,   0]
  K1( 11,:) = [   0,   0,   0,   0]
  K1( 12,:) = [   0,   0,   0,   0]
  K1( 13,:) = [   0,   0,   0,   0]
  K1( 14,:) = [   0,   0,   0,   0]
  K1( 15,:) = [   0,   0,   0,   0]
  K1( 16,:) = [   0,   0,   0,   0]
  K1( 17,:) = [   0,   0,   0,   0]
  K1( 18,:) = [   0,   0,   0,   0]
  K1( 19,:) = [   0,   0,   0,   0]
  K1( 20,:) = [   0,   0,   0,   0]
  K1( 21,:) = [   0,   0,   0,   0]
  K1( 22,:) = [   0,   0,   0,   0]
  K1( 23,:) = [   0,   0,   0,   0]
  K1( 24,:) = [   0,   0,   0,   0]
  K1( 25,:) = [  48,  16,  16,   0]
  K1( 26,:) = [  16,  48,   0,  16]
  K1( 27,:) = [  16,   0,  48,  16]
  K1( 28,:) = [   0,  16,  16,  48]
  K1( 29,:) = [   0,   0,   0,   0]
  K1( 30,:) = [   0,   0,   0,   0]
  K1( 31,:) = [   0,   0,   0,   0]
  K1( 32,:) = [   0,   0,   0,   0]
  K1( 33,:) = [   0,   0,   0,   0]
  K1( 34,:) = [   0,   0,   0,   0]
  K1( 35,:) = [   0,   0,   0,   0]
  K1( 36,:) = [   0,   0,   0,   0]
  K1( 37,:) = [   6,   2,   2,   0]
  K1( 38,:) = [   2,   0,  -6, -16]
  K1( 39,:) = [   2,  -6,   0, -16]
  K1( 40,:) = [   0, -16, -16, -48]
  K1( 41,:) = [  48,  16,  16,   0]
  K1( 42,:) = [  16,  48,   0,  16]
  K1( 43,:) = [  16,   0,  48,  16]
  K1( 44,:) = [   0,  16,  16,  48]
  K1( 45,:) = [   0,   0,   0,   0]
  K1( 46,:) = [   0,   0,   0,   0]
  K1( 47,:) = [   0,   0,   0,   0]
  K1( 48,:) = [   0,   0,   0,   0]
  K1( 49,:) = [   0,   0,   0,   0]
  K1( 50,:) = [   0,   0,   0,   0]
  K1( 51,:) = [   0,   0,   0,   0]
  K1( 52,:) = [   0,   0,   0,   0]
  K1( 53,:) = [   0,  16,  -2,   6]
  K1( 54,:) = [  16,   0,   6,  -2]
  K1( 55,:) = [  -2,   6,   0,  16]
  K1( 56,:) = [   6,  -2,  16,   0]
  K1( 57,:) = [   0,   2, -16,  -6]
  K1( 58,:) = [   2,   6,   0,   2]
  K1( 59,:) = [ -16,   0, -48, -16]
  K1( 60,:) = [  -6,   2, -16,   0]
  K1( 61,:) = [  48,  16,  16,   0]
  K1( 62,:) = [  16,  48,   0,  16]
  K1( 63,:) = [  16,   0,  48,  16]
  K1( 64,:) = [   0,  16,  16,  48]
  K1( 65,:) = [   0,   0,   0,   0]
  K1( 66,:) = [   0,   0,   0,   0]
  K1( 67,:) = [   0,   0,   0,   0]
  K1( 68,:) = [   0,   0,   0,   0]
  K1( 69,:) = [   0,   0,   0,   0]
  K1( 70,:) = [   0,   0,   0,   0]
  K1( 71,:) = [   0,   0,   0,   0]
  K1( 72,:) = [   0,   0,   0,   0]
  K1( 73,:) = [   0, -16,   2,  -6]
  K1( 74,:) = [ -16, -48,   0, -16]
  K1( 75,:) = [   2,   0,   6,   2]
  K1( 76,:) = [  -6, -16,   2,   0]
  K1( 77,:) = [   0,  -2,  16,   6]
  K1( 78,:) = [  -2,   0,   6,  16]
  K1( 79,:) = [  16,   6,   0,  -2]
  K1( 80,:) = [   6,  16,  -2,   0]
  K1( 81,:) = [ -48, -16, -16,   0]
  K1( 82,:) = [ -16,   0,  -6,   2]
  K1( 83,:) = [ -16,  -6,   0,   2]
  K1( 84,:) = [   0,   2,   2,   6]
  K1( 85,:) = [  48,  16,  16,   0]
  K1( 86,:) = [  16,  48,   0,  16]
  K1( 87,:) = [  16,   0,  48,  16]
  K1( 88,:) = [   0,  16,  16,  48]
  K1( 89,:) = [   0,   0,   0,   0]
  K1( 90,:) = [   0,   0,   0,   0]
  K1( 91,:) = [   0,   0,   0,   0]
  K1( 92,:) = [   0,   0,   0,   0]
  K1( 93,:) = [   0,   0,   0,   0]
  K1( 94,:) = [   0,   0,   0,   0]
  K1( 95,:) = [   0,   0,   0,   0]
  K1( 96,:) = [   0,   0,   0,   0]
  K1( 97,:) = [ -54, -18, -18,   0]
  K1( 98,:) = [ -18,   0,   0,  18]
  K1( 99,:) = [ -18,   0, -54, -18]
  K1(100,:) = [   0,  18, -18,   0]
  K1(101,:) = [ -54, -18, -18,   0]
  K1(102,:) = [ -18, -54,   0, -18]
  K1(103,:) = [ -18,   0,   0,  18]
  K1(104,:) = [   0, -18,  18,   0]
  K1(105,:) = [   0, -18,  18,   0]
  K1(106,:) = [ -18, -54,   0, -18]
  K1(107,:) = [  18,   0,   0, -18]
  K1(108,:) = [   0, -18, -18, -54]
  K1(109,:) = [   0,  18, -18,   0]
  K1(110,:) = [  18,   0,   0, -18]
  K1(111,:) = [ -18,   0, -54, -18]
  K1(112,:) = [   0, -18, -18, -54]
  K1(113,:) = [ 108,  36,  36,   0]
  K1(114,:) = [  36, 108,   0,  36]
  K1(115,:) = [  36,   0, 108,  36]
  K1(116,:) = [   0,  36,  36, 108]
  K1(117,:) = [   0,   0,   0,   0]
  K1(118,:) = [   0,   0,   0,   0]
  K1(119,:) = [   0,   0,   0,   0]
  K1(120,:) = [   0,   0,   0,   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 12,  4,  4,  0]
  K2(2,:) = [  4, 12,  0,  4]
  K2(3,:) = [  4,  0, 12,  4]
  K2(4,:) = [  0,  4,  4, 12]

  KL(1,:) = [ 12,  4,  4,  0]
  KL(2,:) = [  4, 12,  0,  4]
  KL(3,:) = [  4,  0, 12,  4]
  KL(4,:) = [  0,  4,  4, 12]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pplljjj_eexddxssxg_1_/**/REALKIND



module ol_forced_parameters_pplljjj_eexddxssxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pplljjj_eexddxssxg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_pplljjj_eexddxssxg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 128 ! number of helicity configurations
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(128) ! physical helicity states
#endif

  complex(REALKIND), save :: den(665)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,33), wf8(8,107), wf16(16,169), wf32(32,108), wf128(128,399)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(38), c(55)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(4,128)

end module ol_loop_storage_pplljjj_eexddxssxg_1_/**/REALKIND






! **********************************************************************
module ol_loop_pplljjj_eexddxssxg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pplljjj_eexddxssxg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2*gQCD**3)/3._/**/REALKIND
    f( 2) = CI*eQED**2*gQCD**3
    f( 3) = (eQED**2*gQCD**3)/3._/**/REALKIND
    f( 4) = eQED**2*gQCD**3
    f( 5) = (CI*countertermnorm*eQED**2*gQCD**5)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**2*gQCD**5
    f( 7) = (countertermnorm*eQED**2*gQCD**5)/3._/**/REALKIND
    f( 8) = countertermnorm*eQED**2*gQCD**5
    f( 9) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**5)/3._/**/REALKIND
    f(10) = CI*countertermnorm*ctGqq*eQED**2*gQCD**5
    f(11) = (countertermnorm*ctGqq*eQED**2*gQCD**5)/3._/**/REALKIND
    f(12) = countertermnorm*ctGqq*eQED**2*gQCD**5
    f(13) = (CI*countertermnorm*ctVqq*eQED**2*gQCD**5)/3._/**/REALKIND
    f(14) = CI*countertermnorm*ctVqq*eQED**2*gQCD**5
    f(15) = (countertermnorm*ctVqq*eQED**2*gQCD**5)/3._/**/REALKIND
    f(16) = countertermnorm*ctVqq*eQED**2*gQCD**5
    f(17) = (countertermnorm*ctVVV*eQED**2*gQCD**5)/3._/**/REALKIND
    f(18) = countertermnorm*ctVVV*eQED**2*gQCD**5
    f(19) = CI*countertermnorm*ctZGG*eQED**2*gQCD**5
    f(20) = countertermnorm*ctZGG*eQED**2*gQCD**5
    f(21) = (CI*eQED**2*gQCD**5*integralnorm*SwB)/6._/**/REALKIND
    f(22) = (CI*eQED**2*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(23) = (CI*eQED**2*gQCD**5*integralnorm*SwB)/2._/**/REALKIND
    f(24) = CI*eQED**2*gQCD**5*integralnorm*SwB
    f(25) = (eQED**2*gQCD**5*integralnorm*SwB)/6._/**/REALKIND
    f(26) = (eQED**2*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(27) = (eQED**2*gQCD**5*integralnorm*SwB)/2._/**/REALKIND
    f(28) = eQED**2*gQCD**5*integralnorm*SwB
    f(29) = (CI*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(30) = (2*CI*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(31) = CI*eQED**2*gQCD**5*integralnorm*SwF
    f(32) = (4*CI*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(33) = 2*CI*eQED**2*gQCD**5*integralnorm*SwF
    f(34) = (eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(35) = (2*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(36) = eQED**2*gQCD**5*integralnorm*SwF
    f(37) = (4*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(38) = 2*eQED**2*gQCD**5*integralnorm*SwF

  c = [ 27*CI*f(21), 54*CI*f(21), 3*CI*f(22), 9*CI*f(22), 24*CI*f(22), 27*CI*f(22), 54*CI*f(22), 27*CI*f(23), 54*CI*f(23) &
    , 3*CI*f(24), 9*CI*f(24), 24*CI*f(24), 27*CI*f(24), 54*CI*f(24), 18*f(25), 54*f(25), f(26), 3*f(26), 6*f(26), 8*f(26), 9*f(26) &
    , 10*f(26), 18*f(26), 21*f(26), 24*f(26), 27*f(26), 54*f(26), 18*f(27), 54*f(27), f(28), 3*f(28), 6*f(28), 8*f(28), 9*f(28) &
    , 10*f(28), 18*f(28), 21*f(28), 24*f(28), 27*f(28), 54*f(28), 9*CI*f(29), 9*CI*f(30), 9*CI*f(31), 9*CI*f(32), 9*CI*f(33) &
    , 3*f(34), 9*f(34), 3*f(35), 9*f(35), 3*f(36), 9*f(36), 3*f(37), 9*f(37), 3*f(38), 9*f(38) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12))+L(6,12))
  den(3) = 1 /((L(5,80))+L(6,80))
  den(5) = 1 /((L(5,35))+L(6,35))
  den(8) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(12) = 1 /((L(5,44))+L(6,44))
  den(17) = 1 /((L(5,96))+L(6,96))
  den(19) = 1 /((L(5,19))+L(6,19))
  den(25) = 1 /((L(5,28))+L(6,28))
  den(32) = 1 /((L(5,76))+L(6,76))
  den(40) = 1 /((L(5,68))+L(6,68))
  den(41) = 1 /((L(5,48))+L(6,48))
  den(43) = 1 /((L(5,11))+L(6,11))
  den(49) = 1 /((L(5,56))+L(6,56))
  den(54) = 1 /((L(5,72))+L(6,72))
  den(56) = 1 /((L(5,7))+L(6,7))
  den(62) = 1 /((L(5,52))+L(6,52))
  den(67) = 1 /((L(5,112))+L(6,112))
  den(105) = 1 /((L(5,60))+L(6,60))
  den(110) = 1 /((L(5,67))+L(6,67))
  den(114) = 1 /((L(5,83))+L(6,83))
  den(119) = 1 /((L(5,92))+L(6,92))
  den(123) = 1 /((L(5,99))+L(6,99))
  den(128) = 1 /((L(5,108))+L(6,108))
  den(136) = 1 /((L(5,71))+L(6,71))
  den(141) = 1 /((L(5,116))+L(6,116))
  den(145) = 1 /((L(5,75))+L(6,75))
  den(150) = 1 /((L(5,120))+L(6,120))
  den(196) = 1 /((L(5,51))+L(6,51))
  den(279) = 1 /((L(5,15))+L(6,15))
  den(365) = 1 /((L(5,31))+L(6,31))
  den(370) = 1 /((L(5,47))+L(6,47))
  den(385) = 1 /((L(5,55))+L(6,55))
  den(390) = 1 /((L(5,59))+L(6,59))
  den(405) = 1 /((L(5,79))+L(6,79))
  den(418) = 1 /((L(5,115))+L(6,115))

  ! denominators
  den(4) = den(2)*den(3)
  den(6) = den(1)*den(5)
  den(7) = den(4)*den(6)
  den(9) = den(5)*den(8)
  den(10) = den(4)*den(9)
  den(11) = den(1)*den(3)
  den(13) = den(2)*den(12)
  den(14) = den(11)*den(13)
  den(15) = den(3)*den(8)
  den(16) = den(13)*den(15)
  den(18) = den(2)*den(17)
  den(20) = den(1)*den(19)
  den(21) = den(18)*den(20)
  den(22) = den(8)*den(19)
  den(23) = den(18)*den(22)
  den(24) = den(1)*den(17)
  den(26) = den(2)*den(25)
  den(27) = den(24)*den(26)
  den(28) = den(8)*den(17)
  den(29) = den(26)*den(28)
  den(30) = den(13)*den(20)
  den(31) = den(13)*den(22)
  den(33) = den(2)*den(32)
  den(34) = den(20)*den(33)
  den(35) = den(22)*den(33)
  den(36) = den(6)*den(26)
  den(37) = den(9)*den(26)
  den(38) = den(6)*den(33)
  den(39) = den(9)*den(33)
  den(42) = den(40)*den(41)
  den(44) = den(1)*den(43)
  den(45) = den(42)*den(44)
  den(46) = den(8)*den(43)
  den(47) = den(42)*den(46)
  den(48) = den(1)*den(40)
  den(50) = den(41)*den(49)
  den(51) = den(48)*den(50)
  den(52) = den(8)*den(40)
  den(53) = den(50)*den(52)
  den(55) = den(41)*den(54)
  den(57) = den(1)*den(56)
  den(58) = den(55)*den(57)
  den(59) = den(8)*den(56)
  den(60) = den(55)*den(59)
  den(61) = den(1)*den(54)
  den(63) = den(41)*den(62)
  den(64) = den(61)*den(63)
  den(65) = den(8)*den(54)
  den(66) = den(63)*den(65)
  den(68) = den(41)*den(67)
  den(69) = den(57)*den(68)
  den(70) = den(59)*den(68)
  den(71) = den(50)*den(57)
  den(72) = den(50)*den(59)
  den(73) = den(44)*den(68)
  den(74) = den(46)*den(68)
  den(75) = den(44)*den(63)
  den(76) = den(46)*den(63)
  den(77) = den(32)*den(40)
  den(78) = den(20)*den(77)
  den(79) = den(22)*den(77)
  den(80) = den(6)*den(77)
  den(81) = den(9)*den(77)
  den(82) = den(32)*den(54)
  den(83) = den(20)*den(82)
  den(84) = den(22)*den(82)
  den(85) = den(6)*den(82)
  den(86) = den(9)*den(82)
  den(87) = den(3)*den(67)
  den(88) = den(57)*den(87)
  den(89) = den(59)*den(87)
  den(90) = den(44)*den(87)
  den(91) = den(46)*den(87)
  den(92) = den(17)*den(67)
  den(93) = den(57)*den(92)
  den(94) = den(59)*den(92)
  den(95) = den(44)*den(92)
  den(96) = den(46)*den(92)
  den(97) = den(1)*den(2)
  den(98) = den(41)*den(97)
  den(99) = den(2)*den(8)
  den(100) = den(41)*den(99)
  den(101) = den(8)*den(41)
  den(102) = den(33)*den(101)
  den(103) = den(68)*den(99)
  den(104) = den(2)*den(41)
  den(106) = den(104)*den(105)
  den(107) = den(8)*den(106)
  den(108) = den(87)*den(99)
  den(109) = den(92)*den(99)
  den(111) = den(8)*den(110)
  den(112) = den(26)*den(111)
  den(113) = den(13)*den(111)
  den(115) = den(11)*den(114)
  den(116) = den(2)*den(115)
  den(117) = den(15)*den(114)
  den(118) = den(2)*den(117)
  den(120) = den(4)*den(119)
  den(121) = den(1)*den(120)
  den(122) = den(8)*den(120)
  den(124) = den(24)*den(123)
  den(125) = den(2)*den(124)
  den(126) = den(28)*den(123)
  den(127) = den(2)*den(126)
  den(129) = den(18)*den(128)
  den(130) = den(1)*den(129)
  den(131) = den(8)*den(129)
  den(132) = den(77)*den(101)
  den(133) = den(82)*den(101)
  den(134) = den(63)*den(111)
  den(135) = den(50)*den(111)
  den(137) = den(48)*den(136)
  den(138) = den(41)*den(137)
  den(139) = den(52)*den(136)
  den(140) = den(41)*den(139)
  den(142) = den(42)*den(141)
  den(143) = den(1)*den(142)
  den(144) = den(8)*den(142)
  den(146) = den(61)*den(145)
  den(147) = den(41)*den(146)
  den(148) = den(65)*den(145)
  den(149) = den(41)*den(148)
  den(151) = den(55)*den(150)
  den(152) = den(1)*den(151)
  den(153) = den(8)*den(151)
  den(154) = den(2)**2
  den(155) = den(115)*den(154)
  den(156) = den(117)*den(154)
  den(157) = den(3)*den(154)
  den(158) = den(6)*den(157)
  den(159) = den(9)*den(157)
  den(160) = den(3)**2
  den(161) = den(2)*den(160)
  den(162) = den(6)*den(161)
  den(163) = den(9)*den(161)
  den(164) = den(1)*den(160)
  den(165) = den(13)*den(164)
  den(166) = den(8)*den(160)
  den(167) = den(13)*den(166)
  den(168) = den(6)*den(120)
  den(169) = den(9)*den(120)
  den(170) = den(13)*den(115)
  den(171) = den(13)*den(117)
  den(172) = den(124)*den(154)
  den(173) = den(126)*den(154)
  den(174) = den(20)*den(154)
  den(175) = den(17)*den(174)
  den(176) = den(22)*den(154)
  den(177) = den(17)*den(176)
  den(178) = den(20)*den(129)
  den(179) = den(22)*den(129)
  den(180) = den(26)*den(124)
  den(181) = den(26)*den(126)
  den(182) = den(17)**2
  den(183) = den(2)*den(182)
  den(184) = den(20)*den(183)
  den(185) = den(22)*den(183)
  den(186) = den(1)*den(182)
  den(187) = den(26)*den(186)
  den(188) = den(8)*den(182)
  den(189) = den(26)*den(188)
  den(190) = den(25)*den(154)
  den(191) = den(6)*den(190)
  den(192) = den(9)*den(190)
  den(193) = den(12)*den(154)
  den(194) = den(20)*den(193)
  den(195) = den(22)*den(193)
  den(197) = den(20)*den(196)
  den(198) = den(154)*den(197)
  den(199) = den(22)*den(196)
  den(200) = den(154)*den(199)
  den(201) = den(6)*den(196)
  den(202) = den(154)*den(201)
  den(203) = den(9)*den(196)
  den(204) = den(154)*den(203)
  den(205) = den(33)*den(128)
  den(206) = den(20)*den(205)
  den(207) = den(22)*den(205)
  den(208) = den(33)*den(119)
  den(209) = den(6)*den(208)
  den(210) = den(9)*den(208)
  den(211) = den(13)*den(128)
  den(212) = den(20)*den(211)
  den(213) = den(22)*den(211)
  den(214) = den(6)*den(123)
  den(215) = den(26)*den(214)
  den(216) = den(9)*den(123)
  den(217) = den(26)*den(216)
  den(218) = den(33)*den(201)
  den(219) = den(33)*den(203)
  den(220) = den(20)*den(114)
  den(221) = den(13)*den(220)
  den(222) = den(22)*den(114)
  den(223) = den(13)*den(222)
  den(224) = den(33)*den(197)
  den(225) = den(33)*den(199)
  den(226) = den(26)*den(119)
  den(227) = den(6)*den(226)
  den(228) = den(9)*den(226)
  den(229) = den(40)**2
  den(230) = den(44)*den(229)
  den(231) = den(41)*den(230)
  den(232) = den(46)*den(229)
  den(233) = den(41)*den(232)
  den(234) = den(1)*den(229)
  den(235) = den(50)*den(234)
  den(236) = den(8)*den(229)
  den(237) = den(50)*den(236)
  den(238) = den(41)**2
  den(239) = den(137)*den(238)
  den(240) = den(139)*den(238)
  den(241) = den(44)*den(142)
  den(242) = den(46)*den(142)
  den(243) = den(50)*den(137)
  den(244) = den(50)*den(139)
  den(245) = den(40)*den(238)
  den(246) = den(44)*den(245)
  den(247) = den(46)*den(245)
  den(248) = den(146)*den(238)
  den(249) = den(148)*den(238)
  den(250) = den(57)*den(151)
  den(251) = den(59)*den(151)
  den(252) = den(63)*den(146)
  den(253) = den(63)*den(148)
  den(254) = den(54)**2
  den(255) = den(57)*den(254)
  den(256) = den(41)*den(255)
  den(257) = den(59)*den(254)
  den(258) = den(41)*den(257)
  den(259) = den(1)*den(254)
  den(260) = den(63)*den(259)
  den(261) = den(8)*den(254)
  den(262) = den(63)*den(261)
  den(263) = den(57)*den(238)
  den(264) = den(54)*den(263)
  den(265) = den(59)*den(238)
  den(266) = den(54)*den(265)
  den(267) = den(68)*den(150)
  den(268) = den(57)*den(267)
  den(269) = den(59)*den(267)
  den(270) = den(68)*den(141)
  den(271) = den(44)*den(270)
  den(272) = den(46)*den(270)
  den(273) = den(62)*den(238)
  den(274) = den(44)*den(273)
  den(275) = den(46)*den(273)
  den(276) = den(50)*den(150)
  den(277) = den(57)*den(276)
  den(278) = den(59)*den(276)
  den(280) = den(44)*den(279)
  den(281) = den(68)*den(280)
  den(282) = den(46)*den(279)
  den(283) = den(68)*den(282)
  den(284) = den(44)*den(145)
  den(285) = den(63)*den(284)
  den(286) = den(46)*den(145)
  den(287) = den(63)*den(286)
  den(288) = den(49)*den(238)
  den(289) = den(57)*den(288)
  den(290) = den(59)*den(288)
  den(291) = den(57)*den(279)
  den(292) = den(68)*den(291)
  den(293) = den(59)*den(279)
  den(294) = den(68)*den(293)
  den(295) = den(57)*den(136)
  den(296) = den(50)*den(295)
  den(297) = den(59)*den(136)
  den(298) = den(50)*den(297)
  den(299) = den(63)*den(141)
  den(300) = den(44)*den(299)
  den(301) = den(46)*den(299)
  den(302) = den(238)*den(291)
  den(303) = den(238)*den(293)
  den(304) = den(238)*den(280)
  den(305) = den(238)*den(282)
  den(306) = den(32)*den(229)
  den(307) = den(20)*den(306)
  den(308) = den(22)*den(306)
  den(309) = den(6)*den(306)
  den(310) = den(9)*den(306)
  den(311) = den(77)*den(201)
  den(312) = den(77)*den(203)
  den(313) = den(77)*den(197)
  den(314) = den(77)*den(199)
  den(315) = den(77)*den(128)
  den(316) = den(20)*den(315)
  den(317) = den(22)*den(315)
  den(318) = den(77)*den(119)
  den(319) = den(6)*den(318)
  den(320) = den(9)*den(318)
  den(321) = den(32)*den(254)
  den(322) = den(20)*den(321)
  den(323) = den(22)*den(321)
  den(324) = den(6)*den(321)
  den(325) = den(9)*den(321)
  den(326) = den(82)*den(201)
  den(327) = den(82)*den(203)
  den(328) = den(82)*den(197)
  den(329) = den(82)*den(199)
  den(330) = den(82)*den(128)
  den(331) = den(20)*den(330)
  den(332) = den(22)*den(330)
  den(333) = den(82)*den(119)
  den(334) = den(6)*den(333)
  den(335) = den(9)*den(333)
  den(336) = den(87)*den(150)
  den(337) = den(57)*den(336)
  den(338) = den(59)*den(336)
  den(339) = den(87)*den(141)
  den(340) = den(44)*den(339)
  den(341) = den(46)*den(339)
  den(342) = den(87)*den(280)
  den(343) = den(87)*den(282)
  den(344) = den(87)*den(291)
  den(345) = den(87)*den(293)
  den(346) = den(160)*den(291)
  den(347) = den(160)*den(293)
  den(348) = den(160)*den(280)
  den(349) = den(160)*den(282)
  den(350) = den(92)*den(150)
  den(351) = den(57)*den(350)
  den(352) = den(59)*den(350)
  den(353) = den(92)*den(141)
  den(354) = den(44)*den(353)
  den(355) = den(46)*den(353)
  den(356) = den(92)*den(280)
  den(357) = den(92)*den(282)
  den(358) = den(92)*den(291)
  den(359) = den(92)*den(293)
  den(360) = den(182)*den(291)
  den(361) = den(182)*den(293)
  den(362) = den(182)*den(280)
  den(363) = den(182)*den(282)
  den(364) = den(2)*den(20)
  den(366) = den(364)*den(365)
  den(367) = den(2)*den(22)
  den(368) = den(365)*den(367)
  den(369) = den(2)*den(6)
  den(371) = den(369)*den(370)
  den(372) = den(2)*den(9)
  den(373) = den(370)*den(372)
  den(374) = den(26)*den(105)
  den(375) = den(1)*den(26)
  den(376) = den(365)*den(375)
  den(377) = den(8)*den(26)
  den(378) = den(365)*den(377)
  den(379) = den(13)*den(105)
  den(380) = den(1)*den(13)
  den(381) = den(370)*den(380)
  den(382) = den(8)*den(13)
  den(383) = den(370)*den(382)
  den(384) = den(41)*den(57)
  den(386) = den(384)*den(385)
  den(387) = den(41)*den(59)
  den(388) = den(385)*den(387)
  den(389) = den(41)*den(44)
  den(391) = den(389)*den(390)
  den(392) = den(41)*den(46)
  den(393) = den(390)*den(392)
  den(394) = den(63)*den(105)
  den(395) = den(50)*den(105)
  den(396) = den(1)*den(63)
  den(397) = den(385)*den(396)
  den(398) = den(8)*den(63)
  den(399) = den(385)*den(398)
  den(400) = den(1)*den(50)
  den(401) = den(390)*den(400)
  den(402) = den(8)*den(50)
  den(403) = den(390)*den(402)
  den(404) = den(40)*den(44)
  den(406) = den(404)*den(405)
  den(407) = den(40)*den(46)
  den(408) = den(405)*den(407)
  den(409) = den(137)*den(405)
  den(410) = den(139)*den(405)
  den(411) = den(54)*den(57)
  den(412) = den(405)*den(411)
  den(413) = den(54)*den(59)
  den(414) = den(405)*den(413)
  den(415) = den(146)*den(405)
  den(416) = den(148)*den(405)
  den(417) = den(3)*den(6)
  den(419) = den(417)*den(418)
  den(420) = den(3)*den(9)
  den(421) = den(418)*den(420)
  den(422) = den(115)*den(418)
  den(423) = den(117)*den(418)
  den(424) = den(17)*den(20)
  den(425) = den(418)*den(424)
  den(426) = den(17)*den(22)
  den(427) = den(418)*den(426)
  den(428) = den(124)*den(418)
  den(429) = den(126)*den(418)
  den(430) = den(291)*den(365)
  den(431) = den(293)*den(365)
  den(432) = den(291)*den(370)
  den(433) = den(293)*den(370)
  den(434) = den(291)*den(405)
  den(435) = den(293)*den(405)
  den(436) = den(295)*den(405)
  den(437) = den(297)*den(405)
  den(438) = den(280)*den(365)
  den(439) = den(282)*den(365)
  den(440) = den(280)*den(370)
  den(441) = den(282)*den(370)
  den(442) = den(280)*den(405)
  den(443) = den(282)*den(405)
  den(444) = den(284)*den(405)
  den(445) = den(286)*den(405)
  den(446) = den(197)*den(385)
  den(447) = den(199)*den(385)
  den(448) = den(197)*den(390)
  den(449) = den(199)*den(390)
  den(450) = den(197)*den(418)
  den(451) = den(199)*den(418)
  den(452) = den(220)*den(418)
  den(453) = den(222)*den(418)
  den(454) = den(201)*den(385)
  den(455) = den(203)*den(385)
  den(456) = den(201)*den(390)
  den(457) = den(203)*den(390)
  den(458) = den(201)*den(418)
  den(459) = den(203)*den(418)
  den(460) = den(214)*den(418)
  den(461) = den(216)*den(418)
  den(462) = den(1)*den(41)
  den(463) = den(1)*den(33)*den(41)
  den(464) = den(8)*den(33)*den(41)
  den(465) = den(1)*den(2)*den(68)
  den(466) = den(2)*den(8)*den(68)
  den(467) = den(1)*den(106)
  den(468) = den(1)*den(2)*den(41)
  den(469) = den(2)*den(8)*den(41)
  den(470) = den(2)*den(3)*den(6)
  den(471) = den(2)*den(3)*den(9)
  den(472) = den(1)*den(3)*den(13)
  den(473) = den(3)*den(8)*den(13)
  den(474) = den(1)*den(2)*den(87)
  den(475) = den(2)*den(8)*den(87)
  den(476) = den(1)*den(2)*den(3)
  den(477) = den(2)*den(3)*den(8)
  den(478) = den(2)*den(17)*den(20)
  den(479) = den(2)*den(17)*den(22)
  den(480) = den(1)*den(17)*den(26)
  den(481) = den(8)*den(17)*den(26)
  den(482) = den(1)*den(2)*den(92)
  den(483) = den(2)*den(8)*den(92)
  den(484) = den(1)*den(2)*den(17)
  den(485) = den(2)*den(8)*den(17)
  den(486) = den(2)*den(197)
  den(487) = den(2)*den(199)
  den(488) = den(2)*den(220)
  den(489) = den(2)*den(222)
  den(490) = den(2)*den(201)
  den(491) = den(2)*den(203)
  den(492) = den(2)*den(214)
  den(493) = den(2)*den(216)
  den(494) = den(1)*den(374)
  den(495) = den(8)*den(374)
  den(496) = den(1)*den(226)
  den(497) = den(8)*den(226)
  den(498) = den(1)*den(379)
  den(499) = den(8)*den(379)
  den(500) = den(1)*den(211)
  den(501) = den(8)*den(211)
  den(502) = den(1)*den(208)
  den(503) = den(8)*den(208)
  den(504) = den(1)*den(205)
  den(505) = den(8)*den(205)
  den(506) = den(1)*den(33)
  den(507) = den(8)*den(33)
  den(508) = den(40)*den(41)*den(44)
  den(509) = den(40)*den(41)*den(46)
  den(510) = den(1)*den(41)*den(77)
  den(511) = den(8)*den(41)*den(77)
  den(512) = den(1)*den(40)*den(50)
  den(513) = den(8)*den(40)*den(50)
  den(514) = den(1)*den(40)*den(41)
  den(515) = den(8)*den(40)*den(41)
  den(516) = den(41)*den(54)*den(57)
  den(517) = den(41)*den(54)*den(59)
  den(518) = den(1)*den(41)*den(82)
  den(519) = den(8)*den(41)*den(82)
  den(520) = den(1)*den(54)*den(63)
  den(521) = den(8)*den(54)*den(63)
  den(522) = den(1)*den(41)*den(54)
  den(523) = den(8)*den(41)*den(54)
  den(524) = den(41)*den(291)
  den(525) = den(41)*den(293)
  den(526) = den(41)*den(295)
  den(527) = den(41)*den(297)
  den(528) = den(41)*den(280)
  den(529) = den(41)*den(282)
  den(530) = den(41)*den(284)
  den(531) = den(41)*den(286)
  den(532) = den(1)*den(394)
  den(533) = den(8)*den(394)
  den(534) = den(1)*den(395)
  den(535) = den(8)*den(395)
  den(536) = den(1)*den(299)
  den(537) = den(8)*den(299)
  den(538) = den(1)*den(270)
  den(539) = den(8)*den(270)
  den(540) = den(1)*den(276)
  den(541) = den(8)*den(276)
  den(542) = den(1)*den(267)
  den(543) = den(8)*den(267)
  den(544) = den(1)*den(68)
  den(545) = den(8)*den(68)
  den(546) = den(40)*den(197)
  den(547) = den(40)*den(199)
  den(548) = den(20)*den(40)
  den(549) = den(22)*den(40)
  den(550) = den(40)*den(201)
  den(551) = den(40)*den(203)
  den(552) = den(6)*den(40)
  den(553) = den(9)*den(40)
  den(554) = den(1)*den(318)
  den(555) = den(8)*den(318)
  den(556) = den(1)*den(315)
  den(557) = den(8)*den(315)
  den(558) = den(1)*den(77)
  den(559) = den(8)*den(77)
  den(560) = den(54)*den(197)
  den(561) = den(54)*den(199)
  den(562) = den(20)*den(54)
  den(563) = den(22)*den(54)
  den(564) = den(54)*den(201)
  den(565) = den(54)*den(203)
  den(566) = den(6)*den(54)
  den(567) = den(9)*den(54)
  den(568) = den(1)*den(333)
  den(569) = den(8)*den(333)
  den(570) = den(1)*den(330)
  den(571) = den(8)*den(330)
  den(572) = den(1)*den(82)
  den(573) = den(8)*den(82)
  den(574) = den(3)*den(291)
  den(575) = den(3)*den(293)
  den(576) = den(3)*den(57)
  den(577) = den(3)*den(59)
  den(578) = den(3)*den(280)
  den(579) = den(3)*den(282)
  den(580) = den(3)*den(44)
  den(581) = den(3)*den(46)
  den(582) = den(1)*den(339)
  den(583) = den(8)*den(339)
  den(584) = den(1)*den(336)
  den(585) = den(8)*den(336)
  den(586) = den(1)*den(87)
  den(587) = den(8)*den(87)
  den(588) = den(17)*den(291)
  den(589) = den(17)*den(293)
  den(590) = den(17)*den(57)
  den(591) = den(17)*den(59)
  den(592) = den(17)*den(280)
  den(593) = den(17)*den(282)
  den(594) = den(17)*den(44)
  den(595) = den(17)*den(46)
  den(596) = den(1)*den(353)
  den(597) = den(8)*den(353)
  den(598) = den(1)*den(350)
  den(599) = den(8)*den(350)
  den(600) = den(1)*den(92)
  den(601) = den(8)*den(92)
  den(602) = den(3)*den(371)
  den(603) = den(3)*den(373)
  den(604) = den(2)*den(419)
  den(605) = den(2)*den(421)
  den(606) = den(3)*den(381)
  den(607) = den(3)*den(383)
  den(608) = den(2)*den(422)
  den(609) = den(2)*den(423)
  den(610) = den(17)*den(366)
  den(611) = den(17)*den(368)
  den(612) = den(2)*den(425)
  den(613) = den(2)*den(427)
  den(614) = den(17)*den(376)
  den(615) = den(17)*den(378)
  den(616) = den(2)*den(428)
  den(617) = den(2)*den(429)
  den(618) = den(2)*den(450)
  den(619) = den(2)*den(451)
  den(620) = den(2)*den(452)
  den(621) = den(2)*den(453)
  den(622) = den(2)*den(458)
  den(623) = den(2)*den(459)
  den(624) = den(2)*den(460)
  den(625) = den(2)*den(461)
  den(626) = den(41)*den(406)
  den(627) = den(41)*den(408)
  den(628) = den(40)*den(391)
  den(629) = den(40)*den(393)
  den(630) = den(41)*den(409)
  den(631) = den(41)*den(410)
  den(632) = den(40)*den(401)
  den(633) = den(40)*den(403)
  den(634) = den(41)*den(412)
  den(635) = den(41)*den(414)
  den(636) = den(54)*den(386)
  den(637) = den(54)*den(388)
  den(638) = den(54)*den(397)
  den(639) = den(54)*den(399)
  den(640) = den(41)*den(415)
  den(641) = den(41)*den(416)
  den(642) = den(41)*den(434)
  den(643) = den(41)*den(435)
  den(644) = den(41)*den(436)
  den(645) = den(41)*den(437)
  den(646) = den(41)*den(442)
  den(647) = den(41)*den(443)
  den(648) = den(41)*den(444)
  den(649) = den(41)*den(445)
  den(650) = den(40)*den(448)
  den(651) = den(40)*den(449)
  den(652) = den(40)*den(456)
  den(653) = den(40)*den(457)
  den(654) = den(54)*den(446)
  den(655) = den(54)*den(447)
  den(656) = den(54)*den(454)
  den(657) = den(54)*den(455)
  den(658) = den(3)*den(432)
  den(659) = den(3)*den(433)
  den(660) = den(3)*den(440)
  den(661) = den(3)*den(441)
  den(662) = den(17)*den(430)
  den(663) = den(17)*den(431)
  den(664) = den(17)*den(438)
  den(665) = den(17)*den(439)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pplljjj_eexddxssxg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ down anti-down strange anti-strange glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pplljjj_eexddxssxg_1, only: external_perm_pplljjj_eexddxssxg_1, &
    & external_perm_inv_pplljjj_eexddxssxg_1, extcomb_perm_pplljjj_eexddxssxg_1, &
    & average_factor_pplljjj_eexddxssxg_1
  use ol_external_pplljjj_eexddxssxg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pplljjj_eexddxssxg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pplljjj_eexddxssxg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_pplljjj_eexddxssxg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(29)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,7)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,7)
#endif
  integer           :: extmasses2(7)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(29)
  complex(REALKIND) :: M1(4), M2(4) 
  real(REALKIND)    :: P_scatt_intern(0:3,7)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(4,128)
  type(Hpolcont) :: M1helarray_ct(4,128)

  type(Hpolcont) :: A(128,399)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(399)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_pplljjj_eexddxssxg_1, 7, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6),6)
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7),7)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, ex7(:), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_Q_A(ntry, wf4(:,3), 80, ZERO, 0_intkind1, wf4(:,4), n2(1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,4), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call prop_A_Q(ntry, wf8(:,1), 35, ZERO, 0_intkind1, wf8(:,2), n2(2))
  call vert_QA_Z(gZl,ntry, ex1(:), ex2(:), wf4(:,5), n3(:,6), t3x4(:,:,4))
  call prop_W_W(ntry, wf4(:,5), 3, MZ, 1_intkind1, wf4(:,6), n2(3))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,6), wf8(:,3), n3(:,7), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 35, ZERO, 0_intkind1, wf8(:,4), n2(4))
  call vert_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,5), n3(:,8), t3x8(:,:,3))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,2), n3(:,9), t3x16(:,:,2))
  call prop_A_Q(ntry, wf8(:,5), 44, ZERO, 0_intkind1, wf8(:,6), n2(5))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,4), wf16(:,3), n3(:,10), t3x16(:,:,3))
  call vert_AV_Q(ntry, ex6(:), ex7(:), wf4(:,7), n3(:,11), t3x4(:,:,5))
  call prop_A_Q(ntry, wf4(:,7), 96, ZERO, 0_intkind1, wf4(:,8), n2(6))
  call vert_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,7), n3(:,12), t3x8(:,:,4))
  call vert_AV_Q(ntry, wf4(:,8), wf4(:,2), wf16(:,4), n3(:,13), t3x16(:,:,4))
  call prop_Q_A(ntry, wf8(:,7), 19, ZERO, 0_intkind1, wf8(:,8), n2(7))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), ex5(:), wf8(:,9), n3(:,14), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,9), 19, ZERO, 0_intkind1, wf8(:,10), n2(8))
  call vert_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,11), n3(:,15), t3x8(:,:,6))
  call vert_AV_Q(ntry, wf4(:,8), wf4(:,1), wf16(:,5), n3(:,16), t3x16(:,:,5))
  call prop_Q_A(ntry, wf8(:,11), 28, ZERO, 0_intkind1, wf8(:,12), n2(9))
  call vert_AZ_Q(gZd,ntry, wf4(:,8), wf4(:,6), wf16(:,6), n3(:,17), t3x16(:,:,6))
  call vert_VQ_A(ntry, ex7(:), wf8(:,8), wf16(:,7), n3(:,18), t3x16(:,:,7))
  call vert_VQ_A(ntry, ex7(:), wf8(:,10), wf16(:,8), n3(:,19), t3x16(:,:,8))
  call vert_UV_W(ntry, wf4(:,2), 12, ex7(:), 64, wf8(:,13), n3(:,20), t3x8(:,:,7))
  call vert_QA_V(ntry, wf8(:,8), ex6(:), wf16(:,9), n3(:,21), t3x16(:,:,9))
  call vert_QA_V(ntry, wf8(:,10), ex6(:), wf16(:,10), n3(:,22), t3x16(:,:,10))
  call vert_VQ_A(ntry, ex7(:), wf8(:,12), wf16(:,11), n3(:,23), t3x16(:,:,11))
  call vert_QA_V(ntry, ex5(:), wf8(:,2), wf16(:,12), n3(:,24), t3x16(:,:,12))
  call vert_QA_V(ntry, ex5(:), wf8(:,4), wf16(:,13), n3(:,25), t3x16(:,:,13))
  call vert_VQ_A(ntry, ex7(:), ex3(:), wf4(:,9), n3(:,26), t3x4(:,:,6))
  call vert_QA_V(ntry, ex5(:), ex6(:), wf4(:,10), n3(:,27), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,9), 68, ZERO, 0_intkind1, wf4(:,11), n2(10))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,14), n3(:,28), t3x8(:,:,8))
  call vert_VQ_A(ntry, wf4(:,10), wf4(:,11), wf16(:,14), n3(:,29), t3x16(:,:,14))
  call prop_A_Q(ntry, wf8(:,14), 11, ZERO, 0_intkind1, wf8(:,15), n2(11))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,6), wf8(:,16), n3(:,30), t3x8(:,:,9))
  call prop_A_Q(ntry, wf8(:,16), 11, ZERO, 0_intkind1, wf8(:,17), n2(12))
  call vert_AV_Q(ntry, ex4(:), wf4(:,10), wf8(:,18), n3(:,31), t3x8(:,:,10))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,11), wf16(:,15), n3(:,32), t3x16(:,:,15))
  call prop_A_Q(ntry, wf8(:,18), 56, ZERO, 0_intkind1, wf8(:,19), n2(13))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,11), wf16(:,16), n3(:,33), t3x16(:,:,16))
  call vert_AV_Q(ntry, ex4(:), ex7(:), wf4(:,12), n3(:,34), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,12), 72, ZERO, 0_intkind1, wf4(:,13), n2(14))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,20), n3(:,35), t3x8(:,:,11))
  call vert_AV_Q(ntry, wf4(:,13), wf4(:,10), wf16(:,17), n3(:,36), t3x16(:,:,17))
  call prop_Q_A(ntry, wf8(:,20), 7, ZERO, 0_intkind1, wf8(:,21), n2(15))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), ex3(:), wf8(:,22), n3(:,37), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,22), 7, ZERO, 0_intkind1, wf8(:,23), n2(16))
  call vert_VQ_A(ntry, wf4(:,10), ex3(:), wf8(:,24), n3(:,38), t3x8(:,:,13))
  call vert_AV_Q(ntry, wf4(:,13), wf4(:,1), wf16(:,18), n3(:,39), t3x16(:,:,18))
  call prop_Q_A(ntry, wf8(:,24), 52, ZERO, 0_intkind1, wf8(:,25), n2(17))
  call vert_AZ_Q(gZd,ntry, wf4(:,13), wf4(:,6), wf16(:,19), n3(:,40), t3x16(:,:,19))
  call vert_UV_W(ntry, wf4(:,10), 48, ex7(:), 64, wf8(:,26), n3(:,41), t3x8(:,:,14))
  call vert_QA_V(ntry, wf8(:,21), ex4(:), wf16(:,20), n3(:,42), t3x16(:,:,20))
  call vert_QA_V(ntry, wf8(:,23), ex4(:), wf16(:,21), n3(:,43), t3x16(:,:,21))
  call vert_VQ_A(ntry, ex7(:), wf8(:,21), wf16(:,22), n3(:,44), t3x16(:,:,22))
  call vert_VQ_A(ntry, ex7(:), wf8(:,23), wf16(:,23), n3(:,45), t3x16(:,:,23))
  call vert_QA_V(ntry, ex3(:), wf8(:,15), wf16(:,24), n3(:,46), t3x16(:,:,24))
  call vert_QA_V(ntry, ex3(:), wf8(:,17), wf16(:,25), n3(:,47), t3x16(:,:,25))
  call vert_VQ_A(ntry, ex7(:), wf8(:,25), wf16(:,26), n3(:,48), t3x16(:,:,26))
  call vert_QA_V(ntry, wf4(:,11), ex4(:), wf8(:,27), n3(:,49), t3x8(:,:,15))
  call vert_AV_Q(ntry, ex6(:), wf8(:,27), wf16(:,27), n3(:,50), t3x16(:,:,27))
  call vert_VQ_A(ntry, wf8(:,27), ex5(:), wf16(:,28), n3(:,51), t3x16(:,:,28))
  call vert_QA_V(ntry, ex3(:), wf4(:,13), wf8(:,28), n3(:,52), t3x8(:,:,16))
  call vert_AV_Q(ntry, ex6(:), wf8(:,28), wf16(:,29), n3(:,53), t3x16(:,:,29))
  call vert_VQ_A(ntry, wf8(:,28), ex5(:), wf16(:,30), n3(:,54), t3x16(:,:,30))
  call vert_QA_V(ntry, wf4(:,4), ex6(:), wf8(:,29), n3(:,55), t3x8(:,:,17))
  call vert_QA_V(ntry, ex5(:), wf4(:,8), wf8(:,30), n3(:,56), t3x8(:,:,18))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), wf4(:,2), ex7(:), wf32(:,1), n4(:,1), t4x32(:,:,1))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), ex7(:), wf4(:,2), wf32(:,2), n4(:,2), t4x32(:,:,2))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,6), wf4(:,2), ex7(:), wf32(:,3), n4(:,3), t4x32(:,:,3))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,6), ex7(:), wf4(:,2), wf32(:,4), n4(:,4), t4x32(:,:,4))
  call counter_VG_G(ntry, wf4(:,6), wf4(:,10), 48, wf16(:,31), 51, n3(:,57), t3x16(:,:,31))
  call counter_VG_G(ntry, wf4(:,6), wf4(:,2), 12, wf16(:,32), 15, n3(:,58), t3x16(:,:,32))
  call vert_UV_W(ntry, wf4(:,2), 12, wf4(:,10), 48, wf16(:,33), n3(:,59), t3x16(:,:,33))
  call counter_VG_G(ntry, wf4(:,6), ex7(:), 64, wf8(:,31), 67, n3(:,60), t3x8(:,:,19))
  call counter_VQ_A(ntry, wf4(:,2), wf4(:,4), wf16(:,34), n3(:,61), t3x16(:,:,34))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,35), n3(:,62), t3x16(:,:,35))
  call counter_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,4), wf16(:,36), n3(:,63), t3x16(:,:,36))
  call counter_AV_Q(ntry, wf4(:,8), wf4(:,2), wf16(:,37), n3(:,64), t3x16(:,:,37))
  call counter_AV_Q(ntry, wf4(:,8), wf4(:,1), wf16(:,38), n3(:,65), t3x16(:,:,38))
  call counter_AZ_Q(gZd,ntry, wf4(:,8), wf4(:,6), wf16(:,39), n3(:,66), t3x16(:,:,39))
  call counter_VQ_A(ntry, ex7(:), wf8(:,8), wf16(:,40), n3(:,67), t3x16(:,:,40))
  call counter_VQ_A(ntry, ex7(:), wf8(:,10), wf16(:,41), n3(:,68), t3x16(:,:,41))
  call counter_UV_W(ntry, wf4(:,2), 12, ex7(:), 64, wf8(:,32), n3(:,69), t3x8(:,:,20))
  call counter_VQ_A(ntry, ex7(:), wf8(:,12), wf16(:,42), n3(:,70), t3x16(:,:,42))
  call vert_QA_V(ntry, wf8(:,12), ex6(:), wf16(:,43), n3(:,71), t3x16(:,:,43))
  call vert_QA_V(ntry, ex5(:), wf8(:,6), wf16(:,44), n3(:,72), t3x16(:,:,44))
  call counter_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,33), n3(:,73), t3x8(:,:,21))
  call prop_Q_A(ntry, wf16(:,2), 83, ZERO, 0_intkind1, wf16(:,45), n2(18))
  call prop_Q_A(ntry, wf16(:,3), 83, ZERO, 0_intkind1, wf16(:,46), n2(19))
  call counter_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,34), n3(:,74), t3x8(:,:,22))
  call prop_Q_A(ntry, wf16(:,1), 92, ZERO, 0_intkind1, wf16(:,47), n2(20))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,6), wf8(:,35), n3(:,75), t3x8(:,:,23))
  call counter_QA_V(ntry, wf8(:,8), ex6(:), wf16(:,48), n3(:,76), t3x16(:,:,45))
  call counter_QA_V(ntry, wf8(:,10), ex6(:), wf16(:,49), n3(:,77), t3x16(:,:,46))
  call prop_A_Q(ntry, wf8(:,33), 44, ZERO, 0_intkind1, wf8(:,36), n2(21))
  call prop_A_Q(ntry, wf8(:,34), 35, ZERO, 0_intkind1, wf8(:,37), n2(22))
  call prop_A_Q(ntry, wf8(:,35), 35, ZERO, 0_intkind1, wf8(:,38), n2(23))
  call vert_QA_V(ntry, ex5(:), wf8(:,37), wf16(:,50), n3(:,78), t3x16(:,:,47))
  call vert_QA_V(ntry, ex5(:), wf8(:,38), wf16(:,51), n3(:,79), t3x16(:,:,48))
  call counter_AV_Q(ntry, ex6(:), ex7(:), wf4(:,14), n3(:,80), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,14), 96, ZERO, 0_intkind1, wf4(:,15), n2(24))
  call vert_AV_Q(ntry, wf4(:,15), wf4(:,2), wf16(:,52), n3(:,81), t3x16(:,:,49))
  call vert_AV_Q(ntry, wf4(:,15), wf4(:,1), wf16(:,53), n3(:,82), t3x16(:,:,50))
  call vert_AZ_Q(gZd,ntry, wf4(:,15), wf4(:,6), wf16(:,54), n3(:,83), t3x16(:,:,51))
  call counter_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,39), n3(:,84), t3x8(:,:,24))
  call prop_A_Q(ntry, wf16(:,5), 99, ZERO, 0_intkind1, wf16(:,55), n2(25))
  call prop_A_Q(ntry, wf16(:,6), 99, ZERO, 0_intkind1, wf16(:,56), n2(26))
  call counter_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,40), n3(:,85), t3x8(:,:,25))
  call prop_A_Q(ntry, wf16(:,4), 108, ZERO, 0_intkind1, wf16(:,57), n2(27))
  call counter_ZQ_A(gZd,ntry, wf4(:,6), ex5(:), wf8(:,41), n3(:,86), t3x8(:,:,26))
  call counter_QA_V(ntry, ex5(:), wf8(:,2), wf16(:,58), n3(:,87), t3x16(:,:,52))
  call counter_QA_V(ntry, ex5(:), wf8(:,4), wf16(:,59), n3(:,88), t3x16(:,:,53))
  call prop_Q_A(ntry, wf8(:,39), 28, ZERO, 0_intkind1, wf8(:,42), n2(28))
  call vert_VQ_A(ntry, ex7(:), wf8(:,42), wf16(:,60), n3(:,89), t3x16(:,:,54))
  call prop_Q_A(ntry, wf8(:,40), 19, ZERO, 0_intkind1, wf8(:,43), n2(29))
  call vert_VQ_A(ntry, ex7(:), wf8(:,43), wf16(:,61), n3(:,90), t3x16(:,:,55))
  call prop_Q_A(ntry, wf8(:,41), 19, ZERO, 0_intkind1, wf8(:,44), n2(30))
  call vert_VQ_A(ntry, ex7(:), wf8(:,44), wf16(:,62), n3(:,91), t3x16(:,:,56))
  call vert_QA_V(ntry, wf8(:,43), ex6(:), wf16(:,63), n3(:,92), t3x16(:,:,57))
  call vert_QA_V(ntry, wf8(:,44), ex6(:), wf16(:,64), n3(:,93), t3x16(:,:,58))
  call counter_VQ_A(ntry, ex7(:), ex5(:), wf4(:,16), n3(:,94), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,16), 80, ZERO, 0_intkind1, wf4(:,17), n2(31))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,17), wf16(:,65), n3(:,95), t3x16(:,:,59))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,17), wf16(:,66), n3(:,96), t3x16(:,:,60))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,17), wf16(:,67), n3(:,97), t3x16(:,:,61))
  call counter_VQ_A(ntry, wf4(:,10), wf4(:,11), wf16(:,68), n3(:,98), t3x16(:,:,62))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,11), wf16(:,69), n3(:,99), t3x16(:,:,63))
  call counter_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,11), wf16(:,70), n3(:,100), t3x16(:,:,64))
  call counter_AV_Q(ntry, wf4(:,13), wf4(:,10), wf16(:,71), n3(:,101), t3x16(:,:,65))
  call counter_AV_Q(ntry, wf4(:,13), wf4(:,1), wf16(:,72), n3(:,102), t3x16(:,:,66))
  call counter_AZ_Q(gZd,ntry, wf4(:,13), wf4(:,6), wf16(:,73), n3(:,103), t3x16(:,:,67))
  call counter_UV_W(ntry, wf4(:,10), 48, ex7(:), 64, wf8(:,45), n3(:,104), t3x8(:,:,27))
  call counter_VQ_A(ntry, ex7(:), wf8(:,21), wf16(:,74), n3(:,105), t3x16(:,:,68))
  call counter_VQ_A(ntry, ex7(:), wf8(:,23), wf16(:,75), n3(:,106), t3x16(:,:,69))
  call counter_VQ_A(ntry, ex7(:), wf8(:,25), wf16(:,76), n3(:,107), t3x16(:,:,70))
  call vert_QA_V(ntry, wf8(:,25), ex4(:), wf16(:,77), n3(:,108), t3x16(:,:,71))
  call vert_QA_V(ntry, ex3(:), wf8(:,19), wf16(:,78), n3(:,109), t3x16(:,:,72))
  call counter_AV_Q(ntry, ex6(:), wf8(:,27), wf16(:,79), n3(:,110), t3x16(:,:,73))
  call counter_AV_Q(ntry, ex6(:), wf8(:,28), wf16(:,80), n3(:,111), t3x16(:,:,74))
  call counter_QA_V(ntry, wf4(:,4), ex6(:), wf8(:,46), n3(:,112), t3x8(:,:,28))
  call vert_QA_V(ntry, ex5(:), wf4(:,15), wf8(:,47), n3(:,113), t3x8(:,:,29))
  call counter_VQ_A(ntry, wf8(:,27), ex5(:), wf16(:,81), n3(:,114), t3x16(:,:,75))
  call counter_VQ_A(ntry, wf8(:,28), ex5(:), wf16(:,82), n3(:,115), t3x16(:,:,76))
  call counter_QA_V(ntry, ex5(:), wf4(:,8), wf8(:,48), n3(:,116), t3x8(:,:,30))
  call vert_QA_V(ntry, wf4(:,17), ex6(:), wf8(:,49), n3(:,117), t3x8(:,:,31))
  call counter_QA_V(ntry, ex5(:), ex6(:), wf4(:,18), n3(:,118), t3x4(:,:,11))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,11), wf16(:,83), n3(:,119), t3x16(:,:,77))
  call vert_AV_Q(ntry, ex4(:), wf4(:,18), wf8(:,50), n3(:,120), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,50), 56, ZERO, 0_intkind1, wf8(:,51), n2(32))
  call vert_AV_Q(ntry, wf4(:,13), wf4(:,18), wf16(:,84), n3(:,121), t3x16(:,:,78))
  call vert_VQ_A(ntry, wf4(:,18), ex3(:), wf8(:,52), n3(:,122), t3x8(:,:,33))
  call prop_Q_A(ntry, wf8(:,52), 52, ZERO, 0_intkind1, wf8(:,53), n2(33))
  call vert_UV_W(ntry, wf4(:,18), 48, ex7(:), 64, wf8(:,54), n3(:,123), t3x8(:,:,34))
  call vert_VQ_A(ntry, ex7(:), wf8(:,53), wf16(:,85), n3(:,124), t3x16(:,:,79))
  call counter_AV_Q(ntry, ex4(:), wf4(:,10), wf8(:,55), n3(:,125), t3x8(:,:,35))
  call prop_Q_A(ntry, wf16(:,15), 71, ZERO, 0_intkind1, wf16(:,86), n2(34))
  call prop_Q_A(ntry, wf16(:,16), 71, ZERO, 0_intkind1, wf16(:,87), n2(35))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,56), n3(:,126), t3x8(:,:,36))
  call prop_Q_A(ntry, wf16(:,14), 116, ZERO, 0_intkind1, wf16(:,88), n2(36))
  call counter_AZ_Q(gZd,ntry, ex4(:), wf4(:,6), wf8(:,57), n3(:,127), t3x8(:,:,37))
  call prop_A_Q(ntry, wf8(:,55), 56, ZERO, 0_intkind1, wf8(:,58), n2(37))
  call counter_QA_V(ntry, wf8(:,21), ex4(:), wf16(:,89), n3(:,128), t3x16(:,:,80))
  call counter_QA_V(ntry, wf8(:,23), ex4(:), wf16(:,90), n3(:,129), t3x16(:,:,81))
  call prop_A_Q(ntry, wf8(:,56), 11, ZERO, 0_intkind1, wf8(:,59), n2(38))
  call prop_A_Q(ntry, wf8(:,57), 11, ZERO, 0_intkind1, wf8(:,60), n2(39))
  call vert_QA_V(ntry, ex3(:), wf8(:,59), wf16(:,91), n3(:,130), t3x16(:,:,82))
  call vert_QA_V(ntry, ex3(:), wf8(:,60), wf16(:,92), n3(:,131), t3x16(:,:,83))
  call counter_AV_Q(ntry, ex4(:), ex7(:), wf4(:,19), n3(:,132), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,19), 72, ZERO, 0_intkind1, wf4(:,20), n2(40))
  call vert_AV_Q(ntry, wf4(:,20), wf4(:,10), wf16(:,93), n3(:,133), t3x16(:,:,84))
  call vert_AV_Q(ntry, wf4(:,20), wf4(:,1), wf16(:,94), n3(:,134), t3x16(:,:,85))
  call vert_AZ_Q(gZd,ntry, wf4(:,20), wf4(:,6), wf16(:,95), n3(:,135), t3x16(:,:,86))
  call counter_QA_V(ntry, wf4(:,11), ex4(:), wf8(:,61), n3(:,136), t3x8(:,:,38))
  call vert_AV_Q(ntry, ex6(:), wf8(:,61), wf16(:,96), n3(:,137), t3x16(:,:,87))
  call vert_VQ_A(ntry, wf8(:,61), ex5(:), wf16(:,97), n3(:,138), t3x16(:,:,88))
  call vert_QA_V(ntry, ex3(:), wf4(:,20), wf8(:,62), n3(:,139), t3x8(:,:,39))
  call vert_AV_Q(ntry, ex6(:), wf8(:,62), wf16(:,98), n3(:,140), t3x16(:,:,89))
  call vert_VQ_A(ntry, wf8(:,62), ex5(:), wf16(:,99), n3(:,141), t3x16(:,:,90))
  call counter_VQ_A(ntry, wf4(:,10), ex3(:), wf8(:,63), n3(:,142), t3x8(:,:,40))
  call prop_A_Q(ntry, wf16(:,18), 75, ZERO, 0_intkind1, wf16(:,100), n2(41))
  call prop_A_Q(ntry, wf16(:,19), 75, ZERO, 0_intkind1, wf16(:,101), n2(42))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,64), n3(:,143), t3x8(:,:,41))
  call prop_A_Q(ntry, wf16(:,17), 120, ZERO, 0_intkind1, wf16(:,102), n2(43))
  call counter_ZQ_A(gZd,ntry, wf4(:,6), ex3(:), wf8(:,65), n3(:,144), t3x8(:,:,42))
  call counter_QA_V(ntry, ex3(:), wf8(:,15), wf16(:,103), n3(:,145), t3x16(:,:,91))
  call counter_QA_V(ntry, ex3(:), wf8(:,17), wf16(:,104), n3(:,146), t3x16(:,:,92))
  call prop_Q_A(ntry, wf8(:,63), 52, ZERO, 0_intkind1, wf8(:,66), n2(44))
  call vert_VQ_A(ntry, ex7(:), wf8(:,66), wf16(:,105), n3(:,147), t3x16(:,:,93))
  call prop_Q_A(ntry, wf8(:,64), 7, ZERO, 0_intkind1, wf8(:,67), n2(45))
  call vert_QA_V(ntry, wf8(:,67), ex4(:), wf16(:,106), n3(:,148), t3x16(:,:,94))
  call prop_Q_A(ntry, wf8(:,65), 7, ZERO, 0_intkind1, wf8(:,68), n2(46))
  call vert_QA_V(ntry, wf8(:,68), ex4(:), wf16(:,107), n3(:,149), t3x16(:,:,95))
  call vert_VQ_A(ntry, ex7(:), wf8(:,67), wf16(:,108), n3(:,150), t3x16(:,:,96))
  call vert_VQ_A(ntry, ex7(:), wf8(:,68), wf16(:,109), n3(:,151), t3x16(:,:,97))
  call counter_VQ_A(ntry, ex7(:), ex3(:), wf4(:,21), n3(:,152), t3x4(:,:,13))
  call prop_Q_A(ntry, wf4(:,21), 68, ZERO, 0_intkind1, wf4(:,22), n2(47))
  call vert_VQ_A(ntry, wf4(:,10), wf4(:,22), wf16(:,110), n3(:,153), t3x16(:,:,98))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,22), wf16(:,111), n3(:,154), t3x16(:,:,99))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,22), wf16(:,112), n3(:,155), t3x16(:,:,100))
  call counter_QA_V(ntry, ex3(:), wf4(:,13), wf8(:,69), n3(:,156), t3x8(:,:,43))
  call vert_AV_Q(ntry, ex6(:), wf8(:,69), wf16(:,113), n3(:,157), t3x16(:,:,101))
  call vert_VQ_A(ntry, wf8(:,69), ex5(:), wf16(:,114), n3(:,158), t3x16(:,:,102))
  call vert_QA_V(ntry, wf4(:,22), ex4(:), wf8(:,70), n3(:,159), t3x8(:,:,44))
  call vert_AV_Q(ntry, ex6(:), wf8(:,70), wf16(:,115), n3(:,160), t3x16(:,:,103))
  call vert_VQ_A(ntry, wf8(:,70), ex5(:), wf16(:,116), n3(:,161), t3x16(:,:,104))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,23), n3(:,162), t3x4(:,:,14))
  call vert_VQ_A(ntry, wf4(:,23), wf4(:,4), wf16(:,117), n3(:,163), t3x16(:,:,105))
  call vert_AV_Q(ntry, ex6(:), wf4(:,23), wf8(:,71), n3(:,164), t3x8(:,:,45))
  call prop_A_Q(ntry, wf8(:,71), 44, ZERO, 0_intkind1, wf8(:,72), n2(48))
  call vert_AV_Q(ntry, wf4(:,8), wf4(:,23), wf16(:,118), n3(:,165), t3x16(:,:,106))
  call vert_VQ_A(ntry, wf4(:,23), ex5(:), wf8(:,73), n3(:,166), t3x8(:,:,46))
  call prop_Q_A(ntry, wf8(:,73), 28, ZERO, 0_intkind1, wf8(:,74), n2(49))
  call vert_UV_W(ntry, wf4(:,23), 12, ex7(:), 64, wf8(:,75), n3(:,167), t3x8(:,:,47))
  call vert_VQ_A(ntry, ex7(:), wf8(:,74), wf16(:,119), n3(:,168), t3x16(:,:,107))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 12, wf4(:,24), n2(50))
  call vert_AV_Q(ntry, ex6(:), wf4(:,24), wf8(:,76), n3(:,169), t3x8(:,:,48))
  call vert_VQ_A(ntry, wf4(:,24), wf4(:,4), wf16(:,120), n3(:,170), t3x16(:,:,108))
  call counter_Q_A(ctqq,3,ntry, wf4(:,4), 80, wf4(:,25), n2(51))
  call prop_Q_A(ntry, wf4(:,25), 80, ZERO, 0_intkind1, wf4(:,26), n2(52))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,26), wf16(:,121), n3(:,171), t3x16(:,:,109))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,26), wf16(:,122), n3(:,172), t3x16(:,:,110))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,26), wf16(:,123), n3(:,173), t3x16(:,:,111))
  call counter_A_Q(ctqq,3,ntry, wf8(:,2), 35, wf8(:,77), n2(53))
  call counter_A_Q(ctqq,3,ntry, wf8(:,4), 35, wf8(:,78), n2(54))
  call counter_A_Q(ctqq,3,ntry, wf8(:,6), 44, wf8(:,79), n2(55))
  call vert_VQ_A(ntry, wf4(:,24), ex5(:), wf8(:,80), n3(:,174), t3x8(:,:,49))
  call vert_VQ_A(ntry, wf4(:,24), wf8(:,8), wf32(:,5), n3(:,175), t3x32(:,:,1))
  call vert_VQ_A(ntry, wf4(:,24), wf8(:,10), wf32(:,6), n3(:,176), t3x32(:,:,2))
  call counter_Q_A(ctqq,3,ntry, wf8(:,8), 19, wf8(:,81), n2(56))
  call counter_Q_A(ctqq,3,ntry, wf8(:,10), 19, wf8(:,82), n2(57))
  call counter_Q_A(ctqq,3,ntry, wf8(:,12), 28, wf8(:,83), n2(58))
  call counter_A_Q(ctqq,3,ntry, wf4(:,8), 96, wf4(:,27), n2(59))
  call prop_A_Q(ntry, wf4(:,27), 96, ZERO, 0_intkind1, wf4(:,28), n2(60))
  call vert_AV_Q(ntry, wf4(:,28), wf4(:,2), wf16(:,124), n3(:,177), t3x16(:,:,112))
  call vert_AV_Q(ntry, wf4(:,28), wf4(:,1), wf16(:,125), n3(:,178), t3x16(:,:,113))
  call vert_AZ_Q(gZd,ntry, wf4(:,28), wf4(:,6), wf16(:,126), n3(:,179), t3x16(:,:,114))
  call vert_AV_Q(ntry, wf8(:,2), ex7(:), wf16(:,127), n3(:,180), t3x16(:,:,115))
  call prop_Q_A(ntry, wf8(:,80), 28, ZERO, 0_intkind1, wf8(:,84), n2(61))
  call vert_AV_Q(ntry, wf8(:,4), ex7(:), wf16(:,128), n3(:,181), t3x16(:,:,116))
  call prop_A_Q(ntry, wf8(:,76), 44, ZERO, 0_intkind1, wf8(:,85), n2(62))
  call vert_UV_W(ntry, wf4(:,24), 12, ex7(:), 64, wf8(:,86), n3(:,182), t3x8(:,:,50))
  call vert_AV_Q(ntry, ex6(:), wf8(:,13), wf16(:,129), n3(:,183), t3x16(:,:,117))
  call prop_A_Q(ntry, wf16(:,129), 108, ZERO, 0_intkind1, wf16(:,130), n2(63))
  call vert_VQ_A(ntry, wf8(:,13), ex5(:), wf16(:,131), n3(:,184), t3x16(:,:,118))
  call prop_Q_A(ntry, wf16(:,131), 92, ZERO, 0_intkind1, wf16(:,132), n2(64))
  call vert_AV_Q(ntry, wf8(:,6), ex7(:), wf16(:,133), n3(:,185), t3x16(:,:,119))
  call prop_A_Q(ntry, wf16(:,133), 108, ZERO, 0_intkind1, wf16(:,134), n2(65))
  call prop_A_Q(ntry, wf16(:,127), 99, ZERO, 0_intkind1, wf16(:,135), n2(66))
  call prop_A_Q(ntry, wf16(:,128), 99, ZERO, 0_intkind1, wf16(:,136), n2(67))
  call counter_V_V(ctGG,21,ntry, wf8(:,13), 76, wf8(:,87), n2(68))
  call prop_Q_A(ntry, wf16(:,7), 83, ZERO, 0_intkind1, wf16(:,137), n2(69))
  call prop_Q_A(ntry, wf16(:,8), 83, ZERO, 0_intkind1, wf16(:,138), n2(70))
  call prop_Q_A(ntry, wf16(:,11), 92, ZERO, 0_intkind1, wf16(:,139), n2(71))
  call counter_Q_A(ctqq,1,ntry, wf4(:,11), 68, wf4(:,29), n2(72))
  call prop_Q_A(ntry, wf4(:,29), 68, ZERO, 0_intkind1, wf4(:,30), n2(73))
  call vert_QA_V(ntry, wf4(:,30), wf8(:,15), wf32(:,7), n3(:,186), t3x32(:,:,3))
  call vert_QA_V(ntry, wf4(:,30), wf8(:,17), wf32(:,8), n3(:,187), t3x32(:,:,4))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,30), wf16(:,140), n3(:,188), t3x16(:,:,120))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,30), wf16(:,141), n3(:,189), t3x16(:,:,121))
  call counter_V_V(ctGG,21,ntry, wf4(:,10), 48, wf4(:,31), n2(74))
  call vert_AV_Q(ntry, ex4(:), wf4(:,31), wf8(:,88), n3(:,190), t3x8(:,:,51))
  call counter_A_Q(ctqq,1,ntry, wf8(:,15), 11, wf8(:,89), n2(75))
  call counter_A_Q(ctqq,1,ntry, wf8(:,17), 11, wf8(:,90), n2(76))
  call counter_A_Q(ctqq,1,ntry, wf8(:,19), 56, wf8(:,91), n2(77))
  call vert_VQ_A(ntry, wf4(:,31), wf4(:,11), wf16(:,142), n3(:,191), t3x16(:,:,122))
  call vert_VQ_A(ntry, wf4(:,31), ex3(:), wf8(:,92), n3(:,192), t3x8(:,:,52))
  call counter_Q_A(ctqq,1,ntry, wf8(:,21), 7, wf8(:,93), n2(78))
  call counter_Q_A(ctqq,1,ntry, wf8(:,23), 7, wf8(:,94), n2(79))
  call counter_Q_A(ctqq,1,ntry, wf8(:,25), 52, wf8(:,95), n2(80))
  call counter_A_Q(ctqq,1,ntry, wf4(:,13), 72, wf4(:,32), n2(81))
  call prop_A_Q(ntry, wf4(:,32), 72, ZERO, 0_intkind1, wf4(:,33), n2(82))
  call vert_QA_V(ntry, wf8(:,21), wf4(:,33), wf32(:,9), n3(:,193), t3x32(:,:,5))
  call vert_QA_V(ntry, wf8(:,23), wf4(:,33), wf32(:,10), n3(:,194), t3x32(:,:,6))
  call vert_AV_Q(ntry, wf4(:,33), wf4(:,1), wf16(:,143), n3(:,195), t3x16(:,:,123))
  call vert_AZ_Q(gZd,ntry, wf4(:,33), wf4(:,6), wf16(:,144), n3(:,196), t3x16(:,:,124))
  call vert_VQ_A(ntry, wf4(:,31), wf8(:,21), wf32(:,11), n3(:,197), t3x32(:,:,7))
  call vert_VQ_A(ntry, wf4(:,31), wf8(:,23), wf32(:,12), n3(:,198), t3x32(:,:,8))
  call vert_AV_Q(ntry, ex4(:), wf8(:,26), wf16(:,145), n3(:,199), t3x16(:,:,125))
  call prop_A_Q(ntry, wf16(:,145), 120, ZERO, 0_intkind1, wf16(:,146), n2(83))
  call vert_VQ_A(ntry, wf8(:,26), ex3(:), wf16(:,147), n3(:,200), t3x16(:,:,126))
  call prop_Q_A(ntry, wf16(:,147), 116, ZERO, 0_intkind1, wf16(:,148), n2(84))
  call vert_AV_Q(ntry, wf8(:,15), ex7(:), wf16(:,149), n3(:,201), t3x16(:,:,127))
  call prop_Q_A(ntry, wf8(:,92), 52, ZERO, 0_intkind1, wf8(:,96), n2(85))
  call vert_AV_Q(ntry, wf8(:,17), ex7(:), wf16(:,150), n3(:,202), t3x16(:,:,128))
  call vert_AV_Q(ntry, wf8(:,19), ex7(:), wf16(:,151), n3(:,203), t3x16(:,:,129))
  call prop_A_Q(ntry, wf16(:,151), 120, ZERO, 0_intkind1, wf16(:,152), n2(86))
  call counter_V_V(ctGG,21,ntry, wf8(:,26), 112, wf8(:,97), n2(87))
  call prop_A_Q(ntry, wf16(:,149), 75, ZERO, 0_intkind1, wf16(:,153), n2(88))
  call prop_A_Q(ntry, wf16(:,150), 75, ZERO, 0_intkind1, wf16(:,154), n2(89))
  call prop_A_Q(ntry, wf8(:,88), 56, ZERO, 0_intkind1, wf8(:,98), n2(90))
  call prop_Q_A(ntry, wf16(:,22), 71, ZERO, 0_intkind1, wf16(:,155), n2(91))
  call prop_Q_A(ntry, wf16(:,23), 71, ZERO, 0_intkind1, wf16(:,156), n2(92))
  call prop_Q_A(ntry, wf16(:,26), 116, ZERO, 0_intkind1, wf16(:,157), n2(93))
  call vert_UV_W(ntry, wf4(:,31), 48, ex7(:), 64, wf8(:,99), n3(:,204), t3x8(:,:,53))
  call vert_QA_V(ntry, wf4(:,30), ex4(:), wf8(:,100), n3(:,205), t3x8(:,:,54))
  call counter_V_V(ctGG,21,ntry, wf8(:,27), 76, wf8(:,101), n2(94))
  call prop_A_Q(ntry, wf16(:,27), 108, ZERO, 0_intkind1, wf16(:,158), n2(95))
  call prop_Q_A(ntry, wf16(:,28), 92, ZERO, 0_intkind1, wf16(:,159), n2(96))
  call vert_QA_V(ntry, ex3(:), wf4(:,33), wf8(:,102), n3(:,206), t3x8(:,:,55))
  call counter_V_V(ctGG,21,ntry, wf8(:,28), 76, wf8(:,103), n2(97))
  call prop_A_Q(ntry, wf16(:,29), 108, ZERO, 0_intkind1, wf16(:,160), n2(98))
  call prop_Q_A(ntry, wf16(:,30), 92, ZERO, 0_intkind1, wf16(:,161), n2(99))
  call vert_AV_Q(ntry, ex4(:), wf8(:,29), wf16(:,162), n3(:,207), t3x16(:,:,130))
  call prop_A_Q(ntry, wf16(:,162), 120, ZERO, 0_intkind1, wf16(:,163), n2(100))
  call vert_VQ_A(ntry, wf8(:,29), ex3(:), wf16(:,164), n3(:,208), t3x16(:,:,131))
  call prop_Q_A(ntry, wf16(:,164), 116, ZERO, 0_intkind1, wf16(:,165), n2(101))
  call counter_V_V(ctGG,21,ntry, wf8(:,29), 112, wf8(:,104), n2(102))
  call vert_QA_V(ntry, wf4(:,26), ex6(:), wf8(:,105), n3(:,209), t3x8(:,:,56))
  call vert_AV_Q(ntry, ex4(:), wf8(:,30), wf16(:,166), n3(:,210), t3x16(:,:,132))
  call prop_A_Q(ntry, wf16(:,166), 120, ZERO, 0_intkind1, wf16(:,167), n2(103))
  call vert_VQ_A(ntry, wf8(:,30), ex3(:), wf16(:,168), n3(:,211), t3x16(:,:,133))
  call prop_Q_A(ntry, wf16(:,168), 116, ZERO, 0_intkind1, wf16(:,169), n2(104))
  call counter_V_V(ctGG,21,ntry, wf8(:,30), 112, wf8(:,106), n2(105))
  call vert_QA_V(ntry, ex5(:), wf4(:,28), wf8(:,107), n3(:,212), t3x8(:,:,57))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,8), wf32(:,13), n3(:,213), t3x32(:,:,9))
  call prop_Q_A(ntry, wf32(:,13), 31, ZERO, 0_intkind1, wf32(:,14), n2(106))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,10), wf32(:,15), n3(:,214), t3x32(:,:,10))
  call prop_Q_A(ntry, wf32(:,15), 31, ZERO, 0_intkind1, wf32(:,16), n2(107))
  call vert_AV_Q(ntry, wf8(:,2), wf4(:,2), wf32(:,17), n3(:,215), t3x32(:,:,11))
  call prop_A_Q(ntry, wf32(:,17), 47, ZERO, 0_intkind1, wf32(:,18), n2(108))
  call vert_AV_Q(ntry, wf8(:,4), wf4(:,2), wf32(:,19), n3(:,216), t3x32(:,:,12))
  call prop_A_Q(ntry, wf32(:,19), 47, ZERO, 0_intkind1, wf32(:,20), n2(109))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,12), wf32(:,21), n3(:,217), t3x32(:,:,13))
  call prop_Q_A(ntry, wf32(:,21), 31, ZERO, 0_intkind1, wf32(:,22), n2(110))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf8(:,12), wf32(:,23), n3(:,218), t3x32(:,:,14))
  call prop_Q_A(ntry, wf32(:,23), 31, ZERO, 0_intkind1, wf32(:,24), n2(111))
  call vert_AV_Q(ntry, wf8(:,6), wf4(:,1), wf32(:,25), n3(:,219), t3x32(:,:,15))
  call prop_A_Q(ntry, wf32(:,25), 47, ZERO, 0_intkind1, wf32(:,26), n2(112))
  call vert_AZ_Q(gZd,ntry, wf8(:,6), wf4(:,6), wf32(:,27), n3(:,220), t3x32(:,:,16))
  call prop_A_Q(ntry, wf32(:,27), 47, ZERO, 0_intkind1, wf32(:,28), n2(113))
  call vert_VQ_A(ntry, wf4(:,10), wf8(:,21), wf32(:,29), n3(:,221), t3x32(:,:,17))
  call prop_Q_A(ntry, wf32(:,29), 55, ZERO, 0_intkind1, wf32(:,30), n2(114))
  call vert_VQ_A(ntry, wf4(:,10), wf8(:,23), wf32(:,31), n3(:,222), t3x32(:,:,18))
  call prop_Q_A(ntry, wf32(:,31), 55, ZERO, 0_intkind1, wf32(:,32), n2(115))
  call vert_AV_Q(ntry, wf8(:,15), wf4(:,10), wf32(:,33), n3(:,223), t3x32(:,:,19))
  call prop_A_Q(ntry, wf32(:,33), 59, ZERO, 0_intkind1, wf32(:,34), n2(116))
  call vert_AV_Q(ntry, wf8(:,17), wf4(:,10), wf32(:,35), n3(:,224), t3x32(:,:,20))
  call prop_A_Q(ntry, wf32(:,35), 59, ZERO, 0_intkind1, wf32(:,36), n2(117))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,25), wf32(:,37), n3(:,225), t3x32(:,:,21))
  call prop_Q_A(ntry, wf32(:,37), 55, ZERO, 0_intkind1, wf32(:,38), n2(118))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf8(:,25), wf32(:,39), n3(:,226), t3x32(:,:,22))
  call prop_Q_A(ntry, wf32(:,39), 55, ZERO, 0_intkind1, wf32(:,40), n2(119))
  call vert_AV_Q(ntry, wf8(:,19), wf4(:,1), wf32(:,41), n3(:,227), t3x32(:,:,23))
  call prop_A_Q(ntry, wf32(:,41), 59, ZERO, 0_intkind1, wf32(:,42), n2(120))
  call vert_AZ_Q(gZd,ntry, wf8(:,19), wf4(:,6), wf32(:,43), n3(:,228), t3x32(:,:,24))
  call prop_A_Q(ntry, wf32(:,43), 59, ZERO, 0_intkind1, wf32(:,44), n2(121))
  call vert_QA_V(ntry, wf4(:,11), wf8(:,15), wf32(:,45), n3(:,229), t3x32(:,:,25))
  call vert_QA_V(ntry, wf4(:,11), wf8(:,17), wf32(:,46), n3(:,230), t3x32(:,:,26))
  call vert_QA_V(ntry, wf16(:,86), ex4(:), wf32(:,47), n3(:,231), t3x32(:,:,27))
  call vert_QA_V(ntry, wf16(:,87), ex4(:), wf32(:,48), n3(:,232), t3x32(:,:,28))
  call vert_QA_V(ntry, wf8(:,21), wf4(:,13), wf32(:,49), n3(:,233), t3x32(:,:,29))
  call vert_QA_V(ntry, wf8(:,23), wf4(:,13), wf32(:,50), n3(:,234), t3x32(:,:,30))
  call vert_QA_V(ntry, ex3(:), wf16(:,100), wf32(:,51), n3(:,235), t3x32(:,:,31))
  call vert_QA_V(ntry, ex3(:), wf16(:,101), wf32(:,52), n3(:,236), t3x32(:,:,32))
  call vert_QA_V(ntry, wf4(:,4), wf8(:,2), wf32(:,53), n3(:,237), t3x32(:,:,33))
  call vert_QA_V(ntry, wf4(:,4), wf8(:,4), wf32(:,54), n3(:,238), t3x32(:,:,34))
  call vert_QA_V(ntry, wf16(:,45), ex6(:), wf32(:,55), n3(:,239), t3x32(:,:,35))
  call vert_QA_V(ntry, wf16(:,46), ex6(:), wf32(:,56), n3(:,240), t3x32(:,:,36))
  call vert_QA_V(ntry, wf8(:,8), wf4(:,8), wf32(:,57), n3(:,241), t3x32(:,:,37))
  call vert_QA_V(ntry, wf8(:,10), wf4(:,8), wf32(:,58), n3(:,242), t3x32(:,:,38))
  call vert_QA_V(ntry, ex5(:), wf16(:,55), wf32(:,59), n3(:,243), t3x32(:,:,39))
  call vert_QA_V(ntry, ex5(:), wf16(:,56), wf32(:,60), n3(:,244), t3x32(:,:,40))
  call vert_VQ_A(ntry, wf16(:,20), ex5(:), wf32(:,61), n3(:,245), t3x32(:,:,41))
  call prop_Q_A(ntry, wf32(:,61), 31, ZERO, 0_intkind1, wf32(:,62), n2(122))
  call vert_VQ_A(ntry, wf16(:,21), ex5(:), wf32(:,63), n3(:,246), t3x32(:,:,42))
  call prop_Q_A(ntry, wf32(:,63), 31, ZERO, 0_intkind1, wf32(:,64), n2(123))
  call vert_AV_Q(ntry, ex6(:), wf16(:,20), wf32(:,65), n3(:,247), t3x32(:,:,43))
  call prop_A_Q(ntry, wf32(:,65), 47, ZERO, 0_intkind1, wf32(:,66), n2(124))
  call vert_AV_Q(ntry, ex6(:), wf16(:,21), wf32(:,67), n3(:,248), t3x32(:,:,44))
  call prop_A_Q(ntry, wf32(:,67), 47, ZERO, 0_intkind1, wf32(:,68), n2(125))
  call vert_UV_W(ntry, wf16(:,20), 15, ex7(:), 64, wf32(:,69), n3(:,249), t3x32(:,:,45))
  call vert_UV_W(ntry, wf16(:,21), 15, ex7(:), 64, wf32(:,70), n3(:,250), t3x32(:,:,46))
  call vert_QA_V(ntry, wf16(:,155), ex4(:), wf32(:,71), n3(:,251), t3x32(:,:,47))
  call vert_QA_V(ntry, wf16(:,156), ex4(:), wf32(:,72), n3(:,252), t3x32(:,:,48))
  call vert_VQ_A(ntry, wf16(:,24), ex5(:), wf32(:,73), n3(:,253), t3x32(:,:,49))
  call prop_Q_A(ntry, wf32(:,73), 31, ZERO, 0_intkind1, wf32(:,74), n2(126))
  call vert_VQ_A(ntry, wf16(:,25), ex5(:), wf32(:,75), n3(:,254), t3x32(:,:,50))
  call prop_Q_A(ntry, wf32(:,75), 31, ZERO, 0_intkind1, wf32(:,76), n2(127))
  call vert_AV_Q(ntry, ex6(:), wf16(:,24), wf32(:,77), n3(:,255), t3x32(:,:,51))
  call prop_A_Q(ntry, wf32(:,77), 47, ZERO, 0_intkind1, wf32(:,78), n2(128))
  call vert_AV_Q(ntry, ex6(:), wf16(:,25), wf32(:,79), n3(:,256), t3x32(:,:,52))
  call prop_A_Q(ntry, wf32(:,79), 47, ZERO, 0_intkind1, wf32(:,80), n2(129))
  call vert_UV_W(ntry, wf16(:,24), 15, ex7(:), 64, wf32(:,81), n3(:,257), t3x32(:,:,53))
  call vert_UV_W(ntry, wf16(:,25), 15, ex7(:), 64, wf32(:,82), n3(:,258), t3x32(:,:,54))
  call vert_QA_V(ntry, ex3(:), wf16(:,153), wf32(:,83), n3(:,259), t3x32(:,:,55))
  call vert_QA_V(ntry, ex3(:), wf16(:,154), wf32(:,84), n3(:,260), t3x32(:,:,56))
  call vert_VQ_A(ntry, wf16(:,9), ex3(:), wf32(:,85), n3(:,261), t3x32(:,:,57))
  call prop_Q_A(ntry, wf32(:,85), 55, ZERO, 0_intkind1, wf32(:,86), n2(130))
  call vert_VQ_A(ntry, wf16(:,10), ex3(:), wf32(:,87), n3(:,262), t3x32(:,:,58))
  call prop_Q_A(ntry, wf32(:,87), 55, ZERO, 0_intkind1, wf32(:,88), n2(131))
  call vert_AV_Q(ntry, ex4(:), wf16(:,9), wf32(:,89), n3(:,263), t3x32(:,:,59))
  call prop_A_Q(ntry, wf32(:,89), 59, ZERO, 0_intkind1, wf32(:,90), n2(132))
  call vert_AV_Q(ntry, ex4(:), wf16(:,10), wf32(:,91), n3(:,264), t3x32(:,:,60))
  call prop_A_Q(ntry, wf32(:,91), 59, ZERO, 0_intkind1, wf32(:,92), n2(133))
  call vert_UV_W(ntry, wf16(:,9), 51, ex7(:), 64, wf32(:,93), n3(:,265), t3x32(:,:,61))
  call vert_UV_W(ntry, wf16(:,10), 51, ex7(:), 64, wf32(:,94), n3(:,266), t3x32(:,:,62))
  call vert_QA_V(ntry, wf16(:,137), ex6(:), wf32(:,95), n3(:,267), t3x32(:,:,63))
  call vert_QA_V(ntry, wf16(:,138), ex6(:), wf32(:,96), n3(:,268), t3x32(:,:,64))
  call vert_VQ_A(ntry, wf16(:,12), ex3(:), wf32(:,97), n3(:,269), t3x32(:,:,65))
  call prop_Q_A(ntry, wf32(:,97), 55, ZERO, 0_intkind1, wf32(:,98), n2(134))
  call vert_VQ_A(ntry, wf16(:,13), ex3(:), wf32(:,99), n3(:,270), t3x32(:,:,66))
  call prop_Q_A(ntry, wf32(:,99), 55, ZERO, 0_intkind1, wf32(:,100), n2(135))
  call vert_AV_Q(ntry, ex4(:), wf16(:,12), wf32(:,101), n3(:,271), t3x32(:,:,67))
  call prop_A_Q(ntry, wf32(:,101), 59, ZERO, 0_intkind1, wf32(:,102), n2(136))
  call vert_AV_Q(ntry, ex4(:), wf16(:,13), wf32(:,103), n3(:,272), t3x32(:,:,68))
  call prop_A_Q(ntry, wf32(:,103), 59, ZERO, 0_intkind1, wf32(:,104), n2(137))
  call vert_UV_W(ntry, wf16(:,12), 51, ex7(:), 64, wf32(:,105), n3(:,273), t3x32(:,:,69))
  call vert_UV_W(ntry, wf16(:,13), 51, ex7(:), 64, wf32(:,106), n3(:,274), t3x32(:,:,70))
  call vert_QA_V(ntry, ex5(:), wf16(:,135), wf32(:,107), n3(:,275), t3x32(:,:,71))
  call vert_QA_V(ntry, ex5(:), wf16(:,136), wf32(:,108), n3(:,276), t3x32(:,:,72))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_exwf(ex7)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)
  call init_hybrid_wf(wf32)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6,i7
integer :: n

n=0

do i7= 1, 2
do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2) .OR. (ex7(i7)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf + ex7(i7)%hf
 end if
end do
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf16(:,1), wf8(:,2), A(:,1), n3(:,277), t3x128(:,:,1), nhel, den(7))
    call Hcont_QA(nsync, wf16(:,1), wf8(:,4), A(:,2), n3(:,278), t3x128(:,:,2), nhel, den(10))
    call Hcont_QA(nsync, wf16(:,2), wf8(:,6), A(:,3), n3(:,279), t3x128(:,:,3), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,3), A(:,4), n3(:,280), t3x128(:,:,4), nhel, den(16))
    call Hcont_QA(nsync, wf16(:,4), wf8(:,8), A(:,5), n3(:,281), t3x128(:,:,5), nhel, den(21))
    call Hcont_QA(nsync, wf16(:,4), wf8(:,10), A(:,6), n3(:,282), t3x128(:,:,6), nhel, den(23))
    call Hcont_QA(nsync, wf16(:,5), wf8(:,12), A(:,7), n3(:,283), t3x128(:,:,7), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,6), A(:,8), n3(:,284), t3x128(:,:,8), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,7), A(:,9), n3(:,285), t3x128(:,:,9), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,8), A(:,10), n3(:,286), t3x128(:,:,10), nhel, den(31))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,9), A(:,11), n3(:,287), t3x128(:,:,11), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,10), A(:,12), n3(:,288), t3x128(:,:,12), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,11), A(:,13), n3(:,289), t3x128(:,:,13), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,11), A(:,14), n3(:,290), t3x128(:,:,14), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,12), A(:,15), n3(:,291), t3x128(:,:,15), nhel, den(38))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,13), A(:,16), n3(:,292), t3x128(:,:,16), nhel, den(39))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,15), A(:,17), n3(:,293), t3x128(:,:,17), nhel, den(45))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,17), A(:,18), n3(:,294), t3x128(:,:,18), nhel, den(47))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,19), A(:,19), n3(:,295), t3x128(:,:,19), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,16), A(:,20), n3(:,296), t3x128(:,:,20), nhel, den(53))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,21), A(:,21), n3(:,297), t3x128(:,:,21), nhel, den(58))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,23), A(:,22), n3(:,298), t3x128(:,:,22), nhel, den(60))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,25), A(:,23), n3(:,299), t3x128(:,:,23), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,19), A(:,24), n3(:,300), t3x128(:,:,24), nhel, den(66))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,20), A(:,25), n3(:,301), t3x128(:,:,25), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,21), A(:,26), n3(:,302), t3x128(:,:,26), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,22), A(:,27), n3(:,303), t3x128(:,:,27), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,23), A(:,28), n3(:,304), t3x128(:,:,28), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,24), A(:,29), n3(:,305), t3x128(:,:,29), nhel, den(73))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,25), A(:,30), n3(:,306), t3x128(:,:,30), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,26), A(:,31), n3(:,307), t3x128(:,:,31), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,26), A(:,32), n3(:,308), t3x128(:,:,32), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,27), A(:,33), n3(:,309), t3x128(:,:,33), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,27), A(:,34), n3(:,310), t3x128(:,:,34), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,28), A(:,35), n3(:,311), t3x128(:,:,35), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,28), A(:,36), n3(:,312), t3x128(:,:,36), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,29), A(:,37), n3(:,313), t3x128(:,:,37), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,29), A(:,38), n3(:,314), t3x128(:,:,38), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,30), A(:,39), n3(:,315), t3x128(:,:,39), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,30), A(:,40), n3(:,316), t3x128(:,:,40), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,29), A(:,41), n3(:,317), t3x128(:,:,41), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,29), A(:,42), n3(:,318), t3x128(:,:,42), nhel, den(89))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,29), A(:,43), n3(:,319), t3x128(:,:,43), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,29), A(:,44), n3(:,320), t3x128(:,:,44), nhel, den(91))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,30), A(:,45), n3(:,321), t3x128(:,:,45), nhel, den(93))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,30), A(:,46), n3(:,322), t3x128(:,:,46), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,30), A(:,47), n3(:,323), t3x128(:,:,47), nhel, den(95))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,30), A(:,48), n3(:,324), t3x128(:,:,48), nhel, den(96))

    call Hcont_VV(nsync, wf4(:,10), wf32(:,1), A(:,49), n3(:,325), t3x128(:,:,49), nhel, den(98))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,2), A(:,50), n3(:,326), t3x128(:,:,50), nhel, den(98))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,3), A(:,51), n3(:,327), t3x128(:,:,51), nhel, den(100))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,4), A(:,52), n3(:,328), t3x128(:,:,52), nhel, den(100))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,31), A(:,53), n3(:,329), t3x128(:,:,53), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,32), A(:,54), n3(:,330), t3x128(:,:,54), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,33), wf8(:,31), A(:,55), n3(:,331), t3x128(:,:,55), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,34), A(:,56), n3(:,332), t3x128(:,:,56), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,34), A(:,57), n3(:,333), t3x128(:,:,57), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,35), A(:,58), n3(:,334), t3x128(:,:,58), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,36), A(:,59), n3(:,335), t3x128(:,:,59), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,29), wf16(:,32), A(:,60), n3(:,336), t3x128(:,:,60), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,37), A(:,61), n3(:,337), t3x128(:,:,61), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,37), A(:,62), n3(:,338), t3x128(:,:,62), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,38), A(:,63), n3(:,339), t3x128(:,:,63), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,39), A(:,64), n3(:,340), t3x128(:,:,64), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,32), A(:,65), n3(:,341), t3x128(:,:,65), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,40), A(:,66), n3(:,342), t3x128(:,:,66), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,41), A(:,67), n3(:,343), t3x128(:,:,67), nhel, den(31))
    call Hcont_VV(nsync, wf16(:,9), wf8(:,32), A(:,68), n3(:,344), t3x128(:,:,68), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,10), wf8(:,32), A(:,69), n3(:,345), t3x128(:,:,69), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,42), A(:,70), n3(:,346), t3x128(:,:,70), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,42), A(:,71), n3(:,347), t3x128(:,:,71), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,12), wf8(:,32), A(:,72), n3(:,348), t3x128(:,:,72), nhel, den(38))
    call Hcont_VV(nsync, wf16(:,13), wf8(:,32), A(:,73), n3(:,349), t3x128(:,:,73), nhel, den(39))
    call Hcont_VV(nsync, wf8(:,31), wf16(:,43), A(:,74), n3(:,350), t3x128(:,:,74), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,31), wf16(:,44), A(:,75), n3(:,351), t3x128(:,:,75), nhel, den(113))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,45), A(:,76), n3(:,352), t3x128(:,:,76), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,46), A(:,77), n3(:,353), t3x128(:,:,77), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,47), A(:,78), n3(:,354), t3x128(:,:,78), nhel, den(121))
    call Hcont_QA(nsync, wf16(:,47), wf8(:,35), A(:,79), n3(:,355), t3x128(:,:,79), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,48), A(:,80), n3(:,356), t3x128(:,:,80), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,49), A(:,81), n3(:,357), t3x128(:,:,81), nhel, den(35))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,36), A(:,82), n3(:,358), t3x128(:,:,82), nhel, den(30))
    call Hcont_QA(nsync, wf16(:,8), wf8(:,36), A(:,83), n3(:,359), t3x128(:,:,83), nhel, den(31))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,37), A(:,84), n3(:,360), t3x128(:,:,84), nhel, den(36))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,38), A(:,85), n3(:,361), t3x128(:,:,85), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,50), A(:,86), n3(:,362), t3x128(:,:,86), nhel, den(38))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,51), A(:,87), n3(:,363), t3x128(:,:,87), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,52), A(:,88), n3(:,364), t3x128(:,:,88), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,52), A(:,89), n3(:,365), t3x128(:,:,89), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,53), A(:,90), n3(:,366), t3x128(:,:,90), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,54), A(:,91), n3(:,367), t3x128(:,:,91), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,55), A(:,92), n3(:,368), t3x128(:,:,92), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,56), A(:,93), n3(:,369), t3x128(:,:,93), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,57), A(:,94), n3(:,370), t3x128(:,:,94), nhel, den(130))
    call Hcont_QA(nsync, wf16(:,57), wf8(:,41), A(:,95), n3(:,371), t3x128(:,:,95), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,58), A(:,96), n3(:,372), t3x128(:,:,96), nhel, den(38))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,59), A(:,97), n3(:,373), t3x128(:,:,97), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,60), A(:,98), n3(:,374), t3x128(:,:,98), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,60), A(:,99), n3(:,375), t3x128(:,:,99), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,61), A(:,100), n3(:,376), t3x128(:,:,100), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,62), A(:,101), n3(:,377), t3x128(:,:,101), nhel, den(31))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,63), A(:,102), n3(:,378), t3x128(:,:,102), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,13), wf16(:,64), A(:,103), n3(:,379), t3x128(:,:,103), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,65), A(:,104), n3(:,380), t3x128(:,:,104), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,65), A(:,105), n3(:,381), t3x128(:,:,105), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,66), A(:,106), n3(:,382), t3x128(:,:,106), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,67), A(:,107), n3(:,383), t3x128(:,:,107), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,68), A(:,108), n3(:,384), t3x128(:,:,108), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,68), A(:,109), n3(:,385), t3x128(:,:,109), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,27), wf16(:,31), A(:,110), n3(:,386), t3x128(:,:,110), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,69), A(:,111), n3(:,387), t3x128(:,:,111), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,70), A(:,112), n3(:,388), t3x128(:,:,112), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,71), A(:,113), n3(:,389), t3x128(:,:,113), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,71), A(:,114), n3(:,390), t3x128(:,:,114), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,28), wf16(:,31), A(:,115), n3(:,391), t3x128(:,:,115), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,72), A(:,116), n3(:,392), t3x128(:,:,116), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,73), A(:,117), n3(:,393), t3x128(:,:,117), nhel, den(66))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,45), A(:,118), n3(:,394), t3x128(:,:,118), nhel, den(69))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,45), A(:,119), n3(:,395), t3x128(:,:,119), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,74), A(:,120), n3(:,396), t3x128(:,:,120), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,75), A(:,121), n3(:,397), t3x128(:,:,121), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,45), A(:,122), n3(:,398), t3x128(:,:,122), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,45), A(:,123), n3(:,399), t3x128(:,:,123), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,76), A(:,124), n3(:,400), t3x128(:,:,124), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,76), A(:,125), n3(:,401), t3x128(:,:,125), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,31), wf16(:,77), A(:,126), n3(:,402), t3x128(:,:,126), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,31), wf16(:,78), A(:,127), n3(:,403), t3x128(:,:,127), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,79), A(:,128), n3(:,404), t3x128(:,:,128), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,79), A(:,129), n3(:,405), t3x128(:,:,129), nhel, den(79))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,37), A(:,130), n3(:,406), t3x128(:,:,130), nhel, den(80))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,38), A(:,131), n3(:,407), t3x128(:,:,131), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,80), A(:,132), n3(:,408), t3x128(:,:,132), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,80), A(:,133), n3(:,409), t3x128(:,:,133), nhel, den(84))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,37), A(:,134), n3(:,410), t3x128(:,:,134), nhel, den(85))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,38), A(:,135), n3(:,411), t3x128(:,:,135), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,46), A(:,136), n3(:,412), t3x128(:,:,136), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,46), A(:,137), n3(:,413), t3x128(:,:,137), nhel, den(89))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,46), A(:,138), n3(:,414), t3x128(:,:,138), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,46), A(:,139), n3(:,415), t3x128(:,:,139), nhel, den(91))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,47), A(:,140), n3(:,416), t3x128(:,:,140), nhel, den(93))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,47), A(:,141), n3(:,417), t3x128(:,:,141), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,47), A(:,142), n3(:,418), t3x128(:,:,142), nhel, den(95))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,47), A(:,143), n3(:,419), t3x128(:,:,143), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,81), A(:,144), n3(:,420), t3x128(:,:,144), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,81), A(:,145), n3(:,421), t3x128(:,:,145), nhel, den(81))
    call Hcont_QA(nsync, wf16(:,27), wf8(:,43), A(:,146), n3(:,422), t3x128(:,:,146), nhel, den(78))
    call Hcont_QA(nsync, wf16(:,27), wf8(:,44), A(:,147), n3(:,423), t3x128(:,:,147), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,82), A(:,148), n3(:,424), t3x128(:,:,148), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,82), A(:,149), n3(:,425), t3x128(:,:,149), nhel, den(86))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,43), A(:,150), n3(:,426), t3x128(:,:,150), nhel, den(83))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,44), A(:,151), n3(:,427), t3x128(:,:,151), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,48), A(:,152), n3(:,428), t3x128(:,:,152), nhel, den(93))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,48), A(:,153), n3(:,429), t3x128(:,:,153), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,48), A(:,154), n3(:,430), t3x128(:,:,154), nhel, den(95))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,48), A(:,155), n3(:,431), t3x128(:,:,155), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,49), A(:,156), n3(:,432), t3x128(:,:,156), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,49), A(:,157), n3(:,433), t3x128(:,:,157), nhel, den(89))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,49), A(:,158), n3(:,434), t3x128(:,:,158), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,49), A(:,159), n3(:,435), t3x128(:,:,159), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,83), A(:,160), n3(:,436), t3x128(:,:,160), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,83), A(:,161), n3(:,437), t3x128(:,:,161), nhel, den(47))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,51), A(:,162), n3(:,438), t3x128(:,:,162), nhel, den(51))
    call Hcont_QA(nsync, wf16(:,16), wf8(:,51), A(:,163), n3(:,439), t3x128(:,:,163), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,84), A(:,164), n3(:,440), t3x128(:,:,164), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,84), A(:,165), n3(:,441), t3x128(:,:,165), nhel, den(60))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,53), A(:,166), n3(:,442), t3x128(:,:,166), nhel, den(64))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,53), A(:,167), n3(:,443), t3x128(:,:,167), nhel, den(66))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,54), A(:,168), n3(:,444), t3x128(:,:,168), nhel, den(69))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,54), A(:,169), n3(:,445), t3x128(:,:,169), nhel, den(70))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,51), A(:,170), n3(:,446), t3x128(:,:,170), nhel, den(71))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,51), A(:,171), n3(:,447), t3x128(:,:,171), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,54), A(:,172), n3(:,448), t3x128(:,:,172), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,54), A(:,173), n3(:,449), t3x128(:,:,173), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,85), A(:,174), n3(:,450), t3x128(:,:,174), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,85), A(:,175), n3(:,451), t3x128(:,:,175), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,55), wf16(:,86), A(:,176), n3(:,452), t3x128(:,:,176), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,55), wf16(:,87), A(:,177), n3(:,453), t3x128(:,:,177), nhel, den(140))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,88), A(:,178), n3(:,454), t3x128(:,:,178), nhel, den(143))
    call Hcont_QA(nsync, wf16(:,88), wf8(:,57), A(:,179), n3(:,455), t3x128(:,:,179), nhel, den(144))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,58), A(:,180), n3(:,456), t3x128(:,:,180), nhel, den(71))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,58), A(:,181), n3(:,457), t3x128(:,:,181), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,89), A(:,182), n3(:,458), t3x128(:,:,182), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,90), A(:,183), n3(:,459), t3x128(:,:,183), nhel, den(70))
    call Hcont_QA(nsync, wf16(:,26), wf8(:,59), A(:,184), n3(:,460), t3x128(:,:,184), nhel, den(75))
    call Hcont_QA(nsync, wf16(:,26), wf8(:,60), A(:,185), n3(:,461), t3x128(:,:,185), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,91), A(:,186), n3(:,462), t3x128(:,:,186), nhel, den(73))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,92), A(:,187), n3(:,463), t3x128(:,:,187), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,93), A(:,188), n3(:,464), t3x128(:,:,188), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,93), A(:,189), n3(:,465), t3x128(:,:,189), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,94), A(:,190), n3(:,466), t3x128(:,:,190), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,95), A(:,191), n3(:,467), t3x128(:,:,191), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,96), A(:,192), n3(:,468), t3x128(:,:,192), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,96), A(:,193), n3(:,469), t3x128(:,:,193), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,97), A(:,194), n3(:,470), t3x128(:,:,194), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,97), A(:,195), n3(:,471), t3x128(:,:,195), nhel, den(81))
    call Hcont_VV(nsync, wf8(:,29), wf16(:,89), A(:,196), n3(:,472), t3x128(:,:,196), nhel, den(88))
    call Hcont_VV(nsync, wf8(:,29), wf16(:,90), A(:,197), n3(:,473), t3x128(:,:,197), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,29), wf16(:,91), A(:,198), n3(:,474), t3x128(:,:,198), nhel, den(90))
    call Hcont_VV(nsync, wf8(:,29), wf16(:,92), A(:,199), n3(:,475), t3x128(:,:,199), nhel, den(91))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,89), A(:,200), n3(:,476), t3x128(:,:,200), nhel, den(93))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,90), A(:,201), n3(:,477), t3x128(:,:,201), nhel, den(94))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,91), A(:,202), n3(:,478), t3x128(:,:,202), nhel, den(95))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,92), A(:,203), n3(:,479), t3x128(:,:,203), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,98), A(:,204), n3(:,480), t3x128(:,:,204), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,98), A(:,205), n3(:,481), t3x128(:,:,205), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,99), A(:,206), n3(:,482), t3x128(:,:,206), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,99), A(:,207), n3(:,483), t3x128(:,:,207), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,63), wf16(:,100), A(:,208), n3(:,484), t3x128(:,:,208), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,63), wf16(:,101), A(:,209), n3(:,485), t3x128(:,:,209), nhel, den(149))
    call Hcont_QA(nsync, wf8(:,64), wf16(:,102), A(:,210), n3(:,486), t3x128(:,:,210), nhel, den(152))
    call Hcont_QA(nsync, wf16(:,102), wf8(:,65), A(:,211), n3(:,487), t3x128(:,:,211), nhel, den(153))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,103), A(:,212), n3(:,488), t3x128(:,:,212), nhel, den(73))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,104), A(:,213), n3(:,489), t3x128(:,:,213), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,105), A(:,214), n3(:,490), t3x128(:,:,214), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,105), A(:,215), n3(:,491), t3x128(:,:,215), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,106), A(:,216), n3(:,492), t3x128(:,:,216), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,107), A(:,217), n3(:,493), t3x128(:,:,217), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,108), A(:,218), n3(:,494), t3x128(:,:,218), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,109), A(:,219), n3(:,495), t3x128(:,:,219), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,110), A(:,220), n3(:,496), t3x128(:,:,220), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,110), A(:,221), n3(:,497), t3x128(:,:,221), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,111), A(:,222), n3(:,498), t3x128(:,:,222), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,112), A(:,223), n3(:,499), t3x128(:,:,223), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,113), A(:,224), n3(:,500), t3x128(:,:,224), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,113), A(:,225), n3(:,501), t3x128(:,:,225), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,114), A(:,226), n3(:,502), t3x128(:,:,226), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,114), A(:,227), n3(:,503), t3x128(:,:,227), nhel, den(86))
    call Hcont_VV(nsync, wf8(:,29), wf16(:,103), A(:,228), n3(:,504), t3x128(:,:,228), nhel, den(90))
    call Hcont_VV(nsync, wf8(:,29), wf16(:,104), A(:,229), n3(:,505), t3x128(:,:,229), nhel, den(91))
    call Hcont_VV(nsync, wf8(:,29), wf16(:,106), A(:,230), n3(:,506), t3x128(:,:,230), nhel, den(88))
    call Hcont_VV(nsync, wf8(:,29), wf16(:,107), A(:,231), n3(:,507), t3x128(:,:,231), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,103), A(:,232), n3(:,508), t3x128(:,:,232), nhel, den(95))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,104), A(:,233), n3(:,509), t3x128(:,:,233), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,106), A(:,234), n3(:,510), t3x128(:,:,234), nhel, den(93))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,107), A(:,235), n3(:,511), t3x128(:,:,235), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,115), A(:,236), n3(:,512), t3x128(:,:,236), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,115), A(:,237), n3(:,513), t3x128(:,:,237), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,116), A(:,238), n3(:,514), t3x128(:,:,238), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,116), A(:,239), n3(:,515), t3x128(:,:,239), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,117), A(:,240), n3(:,516), t3x128(:,:,240), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,117), A(:,241), n3(:,517), t3x128(:,:,241), nhel, den(10))
    call Hcont_QA(nsync, wf16(:,2), wf8(:,72), A(:,242), n3(:,518), t3x128(:,:,242), nhel, den(14))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,72), A(:,243), n3(:,519), t3x128(:,:,243), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,118), A(:,244), n3(:,520), t3x128(:,:,244), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,118), A(:,245), n3(:,521), t3x128(:,:,245), nhel, den(23))
    call Hcont_QA(nsync, wf16(:,5), wf8(:,74), A(:,246), n3(:,522), t3x128(:,:,246), nhel, den(27))
    call Hcont_QA(nsync, wf16(:,6), wf8(:,74), A(:,247), n3(:,523), t3x128(:,:,247), nhel, den(29))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,72), A(:,248), n3(:,524), t3x128(:,:,248), nhel, den(30))
    call Hcont_QA(nsync, wf16(:,8), wf8(:,72), A(:,249), n3(:,525), t3x128(:,:,249), nhel, den(31))
    call Hcont_VV(nsync, wf16(:,9), wf8(:,75), A(:,250), n3(:,526), t3x128(:,:,250), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,10), wf8(:,75), A(:,251), n3(:,527), t3x128(:,:,251), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,119), A(:,252), n3(:,528), t3x128(:,:,252), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,119), A(:,253), n3(:,529), t3x128(:,:,253), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,12), wf8(:,75), A(:,254), n3(:,530), t3x128(:,:,254), nhel, den(38))
    call Hcont_VV(nsync, wf16(:,13), wf8(:,75), A(:,255), n3(:,531), t3x128(:,:,255), nhel, den(39))
    call Hcont_QA(nsync, wf16(:,45), wf8(:,76), A(:,256), n3(:,532), t3x128(:,:,256), nhel, den(155))
    call Hcont_QA(nsync, wf16(:,46), wf8(:,76), A(:,257), n3(:,533), t3x128(:,:,257), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,120), A(:,258), n3(:,534), t3x128(:,:,258), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,120), A(:,259), n3(:,535), t3x128(:,:,259), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,121), A(:,260), n3(:,536), t3x128(:,:,260), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,121), A(:,261), n3(:,537), t3x128(:,:,261), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,122), A(:,262), n3(:,538), t3x128(:,:,262), nhel, den(165))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,123), A(:,263), n3(:,539), t3x128(:,:,263), nhel, den(167))
    call Hcont_QA(nsync, wf16(:,47), wf8(:,77), A(:,264), n3(:,540), t3x128(:,:,264), nhel, den(168))
    call Hcont_QA(nsync, wf16(:,47), wf8(:,78), A(:,265), n3(:,541), t3x128(:,:,265), nhel, den(169))
    call Hcont_QA(nsync, wf16(:,45), wf8(:,79), A(:,266), n3(:,542), t3x128(:,:,266), nhel, den(170))
    call Hcont_QA(nsync, wf16(:,46), wf8(:,79), A(:,267), n3(:,543), t3x128(:,:,267), nhel, den(171))
    call Hcont_QA(nsync, wf16(:,55), wf8(:,80), A(:,268), n3(:,544), t3x128(:,:,268), nhel, den(172))
    call Hcont_QA(nsync, wf16(:,56), wf8(:,80), A(:,269), n3(:,545), t3x128(:,:,269), nhel, den(173))
    call Hcont_QA(nsync, wf4(:,8), wf32(:,5), A(:,270), n3(:,546), t3x128(:,:,270), nhel, den(175))
    call Hcont_QA(nsync, wf4(:,8), wf32(:,6), A(:,271), n3(:,547), t3x128(:,:,271), nhel, den(177))
    call Hcont_QA(nsync, wf16(:,57), wf8(:,81), A(:,272), n3(:,548), t3x128(:,:,272), nhel, den(178))
    call Hcont_QA(nsync, wf16(:,57), wf8(:,82), A(:,273), n3(:,549), t3x128(:,:,273), nhel, den(179))
    call Hcont_QA(nsync, wf16(:,55), wf8(:,83), A(:,274), n3(:,550), t3x128(:,:,274), nhel, den(180))
    call Hcont_QA(nsync, wf16(:,56), wf8(:,83), A(:,275), n3(:,551), t3x128(:,:,275), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,124), A(:,276), n3(:,552), t3x128(:,:,276), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,124), A(:,277), n3(:,553), t3x128(:,:,277), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,125), A(:,278), n3(:,554), t3x128(:,:,278), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,126), A(:,279), n3(:,555), t3x128(:,:,279), nhel, den(189))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,84), A(:,280), n3(:,556), t3x128(:,:,280), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,128), A(:,281), n3(:,557), t3x128(:,:,281), nhel, den(192))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,85), A(:,282), n3(:,558), t3x128(:,:,282), nhel, den(194))
    call Hcont_QA(nsync, wf16(:,8), wf8(:,85), A(:,283), n3(:,559), t3x128(:,:,283), nhel, den(195))
    call Hcont_VV(nsync, wf16(:,9), wf8(:,86), A(:,284), n3(:,560), t3x128(:,:,284), nhel, den(198))
    call Hcont_VV(nsync, wf16(:,10), wf8(:,86), A(:,285), n3(:,561), t3x128(:,:,285), nhel, den(200))
    call Hcont_VV(nsync, wf16(:,12), wf8(:,86), A(:,286), n3(:,562), t3x128(:,:,286), nhel, den(202))
    call Hcont_VV(nsync, wf16(:,13), wf8(:,86), A(:,287), n3(:,563), t3x128(:,:,287), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,81), wf16(:,130), A(:,288), n3(:,564), t3x128(:,:,288), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,82), wf16(:,130), A(:,289), n3(:,565), t3x128(:,:,289), nhel, den(207))
    call Hcont_QA(nsync, wf8(:,77), wf16(:,132), A(:,290), n3(:,566), t3x128(:,:,290), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,78), wf16(:,132), A(:,291), n3(:,567), t3x128(:,:,291), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,81), wf16(:,134), A(:,292), n3(:,568), t3x128(:,:,292), nhel, den(212))
    call Hcont_QA(nsync, wf8(:,82), wf16(:,134), A(:,293), n3(:,569), t3x128(:,:,293), nhel, den(213))
    call Hcont_QA(nsync, wf8(:,83), wf16(:,135), A(:,294), n3(:,570), t3x128(:,:,294), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,83), wf16(:,136), A(:,295), n3(:,571), t3x128(:,:,295), nhel, den(217))
    call Hcont_VV(nsync, wf16(:,12), wf8(:,87), A(:,296), n3(:,572), t3x128(:,:,296), nhel, den(218))
    call Hcont_VV(nsync, wf16(:,13), wf8(:,87), A(:,297), n3(:,573), t3x128(:,:,297), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,79), wf16(:,137), A(:,298), n3(:,574), t3x128(:,:,298), nhel, den(221))
    call Hcont_QA(nsync, wf8(:,79), wf16(:,138), A(:,299), n3(:,575), t3x128(:,:,299), nhel, den(223))
    call Hcont_VV(nsync, wf16(:,9), wf8(:,87), A(:,300), n3(:,576), t3x128(:,:,300), nhel, den(224))
    call Hcont_VV(nsync, wf16(:,10), wf8(:,87), A(:,301), n3(:,577), t3x128(:,:,301), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,77), wf16(:,139), A(:,302), n3(:,578), t3x128(:,:,302), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,78), wf16(:,139), A(:,303), n3(:,579), t3x128(:,:,303), nhel, den(228))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,7), A(:,304), n3(:,580), t3x128(:,:,304), nhel, den(231))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,8), A(:,305), n3(:,581), t3x128(:,:,305), nhel, den(233))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,140), A(:,306), n3(:,582), t3x128(:,:,306), nhel, den(235))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,141), A(:,307), n3(:,583), t3x128(:,:,307), nhel, den(237))
    call Hcont_QA(nsync, wf16(:,86), wf8(:,88), A(:,308), n3(:,584), t3x128(:,:,308), nhel, den(239))
    call Hcont_QA(nsync, wf16(:,87), wf8(:,88), A(:,309), n3(:,585), t3x128(:,:,309), nhel, den(240))
    call Hcont_QA(nsync, wf16(:,88), wf8(:,89), A(:,310), n3(:,586), t3x128(:,:,310), nhel, den(241))
    call Hcont_QA(nsync, wf16(:,88), wf8(:,90), A(:,311), n3(:,587), t3x128(:,:,311), nhel, den(242))
    call Hcont_QA(nsync, wf16(:,86), wf8(:,91), A(:,312), n3(:,588), t3x128(:,:,312), nhel, den(243))
    call Hcont_QA(nsync, wf16(:,87), wf8(:,91), A(:,313), n3(:,589), t3x128(:,:,313), nhel, den(244))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,142), A(:,314), n3(:,590), t3x128(:,:,314), nhel, den(246))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,142), A(:,315), n3(:,591), t3x128(:,:,315), nhel, den(247))
    call Hcont_QA(nsync, wf16(:,100), wf8(:,92), A(:,316), n3(:,592), t3x128(:,:,316), nhel, den(248))
    call Hcont_QA(nsync, wf16(:,101), wf8(:,92), A(:,317), n3(:,593), t3x128(:,:,317), nhel, den(249))
    call Hcont_QA(nsync, wf16(:,102), wf8(:,93), A(:,318), n3(:,594), t3x128(:,:,318), nhel, den(250))
    call Hcont_QA(nsync, wf16(:,102), wf8(:,94), A(:,319), n3(:,595), t3x128(:,:,319), nhel, den(251))
    call Hcont_QA(nsync, wf16(:,100), wf8(:,95), A(:,320), n3(:,596), t3x128(:,:,320), nhel, den(252))
    call Hcont_QA(nsync, wf16(:,101), wf8(:,95), A(:,321), n3(:,597), t3x128(:,:,321), nhel, den(253))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,9), A(:,322), n3(:,598), t3x128(:,:,322), nhel, den(256))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,10), A(:,323), n3(:,599), t3x128(:,:,323), nhel, den(258))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,143), A(:,324), n3(:,600), t3x128(:,:,324), nhel, den(260))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,144), A(:,325), n3(:,601), t3x128(:,:,325), nhel, den(262))
    call Hcont_QA(nsync, wf4(:,13), wf32(:,11), A(:,326), n3(:,602), t3x128(:,:,326), nhel, den(264))
    call Hcont_QA(nsync, wf4(:,13), wf32(:,12), A(:,327), n3(:,603), t3x128(:,:,327), nhel, den(266))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,146), A(:,328), n3(:,604), t3x128(:,:,328), nhel, den(268))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,146), A(:,329), n3(:,605), t3x128(:,:,329), nhel, den(269))
    call Hcont_QA(nsync, wf8(:,89), wf16(:,148), A(:,330), n3(:,606), t3x128(:,:,330), nhel, den(271))
    call Hcont_QA(nsync, wf8(:,90), wf16(:,148), A(:,331), n3(:,607), t3x128(:,:,331), nhel, den(272))
    call Hcont_QA(nsync, wf16(:,149), wf8(:,96), A(:,332), n3(:,608), t3x128(:,:,332), nhel, den(274))
    call Hcont_QA(nsync, wf8(:,96), wf16(:,150), A(:,333), n3(:,609), t3x128(:,:,333), nhel, den(275))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,152), A(:,334), n3(:,610), t3x128(:,:,334), nhel, den(277))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,152), A(:,335), n3(:,611), t3x128(:,:,335), nhel, den(278))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,97), A(:,336), n3(:,612), t3x128(:,:,336), nhel, den(281))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,97), A(:,337), n3(:,613), t3x128(:,:,337), nhel, den(283))
    call Hcont_QA(nsync, wf8(:,95), wf16(:,153), A(:,338), n3(:,614), t3x128(:,:,338), nhel, den(285))
    call Hcont_QA(nsync, wf8(:,95), wf16(:,154), A(:,339), n3(:,615), t3x128(:,:,339), nhel, den(287))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,98), A(:,340), n3(:,616), t3x128(:,:,340), nhel, den(289))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,98), A(:,341), n3(:,617), t3x128(:,:,341), nhel, den(290))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,97), A(:,342), n3(:,618), t3x128(:,:,342), nhel, den(292))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,97), A(:,343), n3(:,619), t3x128(:,:,343), nhel, den(294))
    call Hcont_QA(nsync, wf8(:,91), wf16(:,155), A(:,344), n3(:,620), t3x128(:,:,344), nhel, den(296))
    call Hcont_QA(nsync, wf8(:,91), wf16(:,156), A(:,345), n3(:,621), t3x128(:,:,345), nhel, den(298))
    call Hcont_QA(nsync, wf8(:,89), wf16(:,157), A(:,346), n3(:,622), t3x128(:,:,346), nhel, den(300))
    call Hcont_QA(nsync, wf8(:,90), wf16(:,157), A(:,347), n3(:,623), t3x128(:,:,347), nhel, den(301))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,99), A(:,348), n3(:,624), t3x128(:,:,348), nhel, den(302))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,99), A(:,349), n3(:,625), t3x128(:,:,349), nhel, den(303))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,99), A(:,350), n3(:,626), t3x128(:,:,350), nhel, den(304))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,99), A(:,351), n3(:,627), t3x128(:,:,351), nhel, den(305))
    call Hcont_VV(nsync, wf16(:,9), wf8(:,100), A(:,352), n3(:,628), t3x128(:,:,352), nhel, den(307))
    call Hcont_VV(nsync, wf16(:,10), wf8(:,100), A(:,353), n3(:,629), t3x128(:,:,353), nhel, den(308))
    call Hcont_VV(nsync, wf16(:,12), wf8(:,100), A(:,354), n3(:,630), t3x128(:,:,354), nhel, den(309))
    call Hcont_VV(nsync, wf16(:,13), wf8(:,100), A(:,355), n3(:,631), t3x128(:,:,355), nhel, den(310))
    call Hcont_VV(nsync, wf16(:,12), wf8(:,101), A(:,356), n3(:,632), t3x128(:,:,356), nhel, den(311))
    call Hcont_VV(nsync, wf16(:,13), wf8(:,101), A(:,357), n3(:,633), t3x128(:,:,357), nhel, den(312))
    call Hcont_VV(nsync, wf16(:,9), wf8(:,101), A(:,358), n3(:,634), t3x128(:,:,358), nhel, den(313))
    call Hcont_VV(nsync, wf16(:,10), wf8(:,101), A(:,359), n3(:,635), t3x128(:,:,359), nhel, den(314))
    call Hcont_QA(nsync, wf8(:,81), wf16(:,158), A(:,360), n3(:,636), t3x128(:,:,360), nhel, den(316))
    call Hcont_QA(nsync, wf8(:,82), wf16(:,158), A(:,361), n3(:,637), t3x128(:,:,361), nhel, den(317))
    call Hcont_QA(nsync, wf8(:,77), wf16(:,159), A(:,362), n3(:,638), t3x128(:,:,362), nhel, den(319))
    call Hcont_QA(nsync, wf8(:,78), wf16(:,159), A(:,363), n3(:,639), t3x128(:,:,363), nhel, den(320))
    call Hcont_VV(nsync, wf16(:,9), wf8(:,102), A(:,364), n3(:,640), t3x128(:,:,364), nhel, den(322))
    call Hcont_VV(nsync, wf16(:,10), wf8(:,102), A(:,365), n3(:,641), t3x128(:,:,365), nhel, den(323))
    call Hcont_VV(nsync, wf16(:,12), wf8(:,102), A(:,366), n3(:,642), t3x128(:,:,366), nhel, den(324))
    call Hcont_VV(nsync, wf16(:,13), wf8(:,102), A(:,367), n3(:,643), t3x128(:,:,367), nhel, den(325))
    call Hcont_VV(nsync, wf16(:,12), wf8(:,103), A(:,368), n3(:,644), t3x128(:,:,368), nhel, den(326))
    call Hcont_VV(nsync, wf16(:,13), wf8(:,103), A(:,369), n3(:,645), t3x128(:,:,369), nhel, den(327))
    call Hcont_VV(nsync, wf16(:,9), wf8(:,103), A(:,370), n3(:,646), t3x128(:,:,370), nhel, den(328))
    call Hcont_VV(nsync, wf16(:,10), wf8(:,103), A(:,371), n3(:,647), t3x128(:,:,371), nhel, den(329))
    call Hcont_QA(nsync, wf8(:,81), wf16(:,160), A(:,372), n3(:,648), t3x128(:,:,372), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,82), wf16(:,160), A(:,373), n3(:,649), t3x128(:,:,373), nhel, den(332))
    call Hcont_QA(nsync, wf8(:,77), wf16(:,161), A(:,374), n3(:,650), t3x128(:,:,374), nhel, den(334))
    call Hcont_QA(nsync, wf8(:,78), wf16(:,161), A(:,375), n3(:,651), t3x128(:,:,375), nhel, den(335))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,163), A(:,376), n3(:,652), t3x128(:,:,376), nhel, den(337))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,163), A(:,377), n3(:,653), t3x128(:,:,377), nhel, den(338))
    call Hcont_QA(nsync, wf8(:,89), wf16(:,165), A(:,378), n3(:,654), t3x128(:,:,378), nhel, den(340))
    call Hcont_QA(nsync, wf8(:,90), wf16(:,165), A(:,379), n3(:,655), t3x128(:,:,379), nhel, den(341))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,104), A(:,380), n3(:,656), t3x128(:,:,380), nhel, den(342))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,104), A(:,381), n3(:,657), t3x128(:,:,381), nhel, den(343))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,104), A(:,382), n3(:,658), t3x128(:,:,382), nhel, den(344))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,104), A(:,383), n3(:,659), t3x128(:,:,383), nhel, den(345))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,105), A(:,384), n3(:,660), t3x128(:,:,384), nhel, den(346))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,105), A(:,385), n3(:,661), t3x128(:,:,385), nhel, den(347))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,105), A(:,386), n3(:,662), t3x128(:,:,386), nhel, den(348))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,105), A(:,387), n3(:,663), t3x128(:,:,387), nhel, den(349))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,167), A(:,388), n3(:,664), t3x128(:,:,388), nhel, den(351))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,167), A(:,389), n3(:,665), t3x128(:,:,389), nhel, den(352))
    call Hcont_QA(nsync, wf8(:,89), wf16(:,169), A(:,390), n3(:,666), t3x128(:,:,390), nhel, den(354))
    call Hcont_QA(nsync, wf8(:,90), wf16(:,169), A(:,391), n3(:,667), t3x128(:,:,391), nhel, den(355))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,106), A(:,392), n3(:,668), t3x128(:,:,392), nhel, den(356))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,106), A(:,393), n3(:,669), t3x128(:,:,393), nhel, den(357))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,106), A(:,394), n3(:,670), t3x128(:,:,394), nhel, den(358))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,106), A(:,395), n3(:,671), t3x128(:,:,395), nhel, den(359))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,107), A(:,396), n3(:,672), t3x128(:,:,396), nhel, den(360))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,107), A(:,397), n3(:,673), t3x128(:,:,397), nhel, den(361))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,107), A(:,398), n3(:,674), t3x128(:,:,398), nhel, den(362))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,107), A(:,399), n3(:,675), t3x128(:,:,399), nhel, den(363))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(4), M2(4) ! M1helarray(4,128)
  integer :: empty(0), i

  M1(1)%j = ((-A(j,17)%j-A(j,19)%j-A(j,21)%j-A(j,23)%j-A(j,27)%j-A(j,31)%j-A(j,33)%j-A(j,35)%j-A(j,37)%j &
       -A(j,39)%j)*f(1))/6._/**/REALKIND+((-A(j,18)%j-A(j,20)%j-A(j,22)%j-A(j,24)%j-A(j,28)%j-A(j,32)%j-A(j,34)%j-A(j,36)%j &
       -A(j,38)%j-A(j,40)%j)*f(2))/6._/**/REALKIND
  M1(2)%j = ((A(j,1)%j+A(j,3)%j+A(j,9)%j+A(j,21)%j+A(j,23)%j+A(j,31)%j+A(j,37)%j+A(j,39)%j+A(j,41)%j &
       +A(j,43)%j)*f(1))/2._/**/REALKIND+((A(j,2)%j+A(j,4)%j+A(j,10)%j+A(j,22)%j+A(j,24)%j+A(j,32)%j+A(j,38)%j+A(j,40)%j+A(j,42)%j &
       +A(j,44)%j)*f(2))/2._/**/REALKIND+(CI*(A(j,11)%j+A(j,15)%j-A(j,25)%j-A(j,29)%j)*f(3))/2._/**/REALKIND+(CI*(A(j,12)%j &
       +A(j,16)%j-A(j,26)%j-A(j,30)%j)*f(4))/2._/**/REALKIND
  M1(3)%j = ((A(j,5)%j+A(j,7)%j+A(j,13)%j+A(j,17)%j+A(j,19)%j+A(j,27)%j+A(j,33)%j+A(j,35)%j+A(j,45)%j &
       +A(j,47)%j)*f(1))/2._/**/REALKIND+((A(j,6)%j+A(j,8)%j+A(j,14)%j+A(j,18)%j+A(j,20)%j+A(j,28)%j+A(j,34)%j+A(j,36)%j+A(j,46)%j &
       +A(j,48)%j)*f(2))/2._/**/REALKIND+(CI*(-A(j,11)%j-A(j,15)%j+A(j,25)%j+A(j,29)%j)*f(3))/2._/**/REALKIND+(CI*(-A(j,12)%j &
       -A(j,16)%j+A(j,26)%j+A(j,30)%j)*f(4))/2._/**/REALKIND
  M1(4)%j = ((-A(j,1)%j-A(j,3)%j-A(j,5)%j-A(j,7)%j-A(j,9)%j-A(j,13)%j-A(j,41)%j-A(j,43)%j-A(j,45)%j &
       -A(j,47)%j)*f(1))/6._/**/REALKIND+((-A(j,2)%j-A(j,4)%j-A(j,6)%j-A(j,8)%j-A(j,10)%j-A(j,14)%j-A(j,42)%j-A(j,44)%j-A(j,46)%j &
       -A(j,48)%j)*f(2))/6._/**/REALKIND

  M2(1)%j = ((A(j,304)%j+A(j,306)%j+A(j,308)%j+A(j,310)%j+A(j,312)%j+A(j,314)%j+A(j,316)%j+A(j,318)%j+A(j,320)%j+A(j,322)%j &
       +A(j,324)%j+A(j,326)%j+A(j,332)%j+A(j,334)%j+A(j,338)%j+A(j,340)%j+A(j,344)%j+A(j,346)%j+A(j,352)%j+A(j,354)%j+A(j,356)%j &
       +A(j,358)%j+A(j,360)%j+A(j,362)%j+A(j,364)%j+A(j,366)%j+A(j,368)%j+A(j,370)%j+A(j,372)%j+A(j,374)%j)*f(5))/6._/**/REALKIND &
       +((-A(j,49)%j-A(j,50)%j-A(j,51)%j-A(j,52)%j)*f(6))/12._/**/REALKIND+((A(j,305)%j+A(j,307)%j+A(j,309)%j+A(j,311)%j &
       +A(j,313)%j+A(j,315)%j+A(j,317)%j+A(j,319)%j+A(j,321)%j+A(j,323)%j+A(j,325)%j+A(j,327)%j+A(j,333)%j+A(j,335)%j+A(j,339)%j &
       +A(j,341)%j+A(j,345)%j+A(j,347)%j+A(j,353)%j+A(j,355)%j+A(j,357)%j+A(j,359)%j+A(j,361)%j+A(j,363)%j+A(j,365)%j+A(j,367)%j &
       +A(j,369)%j+A(j,371)%j+A(j,373)%j+A(j,375)%j)*f(6))/6._/**/REALKIND+((-A(j,108)%j-A(j,113)%j-A(j,120)%j-A(j,124)%j &
       -A(j,128)%j-A(j,132)%j-A(j,144)%j-A(j,148)%j-A(j,160)%j-A(j,162)%j-A(j,164)%j-A(j,166)%j-A(j,170)%j-A(j,174)%j-A(j,176)%j &
       -A(j,180)%j-A(j,188)%j-A(j,190)%j-A(j,192)%j-A(j,194)%j-A(j,204)%j-A(j,206)%j-A(j,208)%j-A(j,214)%j-A(j,220)%j-A(j,222)%j &
       -A(j,224)%j-A(j,226)%j-A(j,236)%j-A(j,238)%j)*f(9))/6._/**/REALKIND+((-A(j,109)%j-A(j,114)%j-A(j,121)%j-A(j,125)%j &
       -A(j,129)%j-A(j,133)%j-A(j,145)%j-A(j,149)%j-A(j,161)%j-A(j,163)%j-A(j,165)%j-A(j,167)%j-A(j,171)%j-A(j,175)%j-A(j,177)%j &
       -A(j,181)%j-A(j,189)%j-A(j,191)%j-A(j,193)%j-A(j,195)%j-A(j,205)%j-A(j,207)%j-A(j,209)%j-A(j,215)%j-A(j,221)%j-A(j,223)%j &
       -A(j,225)%j-A(j,227)%j-A(j,237)%j-A(j,239)%j)*f(10))/6._/**/REALKIND+((-A(j,111)%j-A(j,116)%j-A(j,130)%j-A(j,134)%j &
       -A(j,146)%j-A(j,150)%j-A(j,178)%j-A(j,184)%j-A(j,210)%j-A(j,218)%j)*f(13))/6._/**/REALKIND+((-A(j,112)%j-A(j,117)%j &
       -A(j,131)%j-A(j,135)%j-A(j,147)%j-A(j,151)%j-A(j,179)%j-A(j,185)%j-A(j,211)%j-A(j,219)%j)*f(14))/6._/**/REALKIND &
       +((A(j,110)%j+A(j,115)%j+A(j,126)%j+A(j,127)%j)*f(20))/6._/**/REALKIND
  M2(2)%j = ((-A(j,256)%j-A(j,258)%j-A(j,260)%j-A(j,262)%j-A(j,264)%j-A(j,266)%j-A(j,282)%j-A(j,292)%j-A(j,298)%j-A(j,316)%j &
       -A(j,318)%j-A(j,320)%j-A(j,322)%j-A(j,324)%j-A(j,326)%j-A(j,332)%j-A(j,338)%j-A(j,346)%j-A(j,364)%j-A(j,366)%j-A(j,368)%j &
       -A(j,370)%j-A(j,372)%j-A(j,374)%j-A(j,376)%j-A(j,378)%j-A(j,380)%j-A(j,382)%j-A(j,384)%j-A(j,386)%j)*f(5))/2._/**/REALKIND &
       +((A(j,49)%j+A(j,51)%j)*f(6))/4._/**/REALKIND+((-A(j,257)%j-A(j,259)%j-A(j,261)%j-A(j,263)%j-A(j,265)%j-A(j,267)%j &
       -A(j,283)%j-A(j,293)%j-A(j,299)%j-A(j,317)%j-A(j,319)%j-A(j,321)%j-A(j,323)%j-A(j,325)%j-A(j,327)%j-A(j,333)%j-A(j,339)%j &
       -A(j,347)%j-A(j,365)%j-A(j,367)%j-A(j,369)%j-A(j,371)%j-A(j,373)%j-A(j,375)%j-A(j,377)%j-A(j,379)%j-A(j,381)%j-A(j,383)%j &
       -A(j,385)%j-A(j,387)%j)*f(6))/2._/**/REALKIND+(CI*(-A(j,284)%j-A(j,286)%j-A(j,288)%j-A(j,290)%j-A(j,296)%j-A(j,300)%j &
       +A(j,328)%j+A(j,330)%j+A(j,336)%j+A(j,342)%j+A(j,348)%j+A(j,350)%j)*f(7))/2._/**/REALKIND+(CI*(-A(j,285)%j-A(j,287)%j &
       -A(j,289)%j-A(j,291)%j-A(j,297)%j-A(j,301)%j+A(j,329)%j+A(j,331)%j+A(j,337)%j+A(j,343)%j+A(j,349)%j &
       +A(j,351)%j)*f(8))/2._/**/REALKIND+((A(j,56)%j+A(j,66)%j+A(j,76)%j+A(j,82)%j+A(j,104)%j+A(j,106)%j+A(j,113)%j+A(j,124)%j &
       +A(j,132)%j+A(j,136)%j+A(j,138)%j+A(j,148)%j+A(j,156)%j+A(j,158)%j+A(j,164)%j+A(j,166)%j+A(j,174)%j+A(j,188)%j+A(j,190)%j &
       +A(j,196)%j+A(j,204)%j+A(j,206)%j+A(j,208)%j+A(j,214)%j+A(j,224)%j+A(j,226)%j+A(j,228)%j+A(j,240)%j+A(j,242)%j &
       +A(j,248)%j)*f(9))/2._/**/REALKIND+((A(j,57)%j+A(j,67)%j+A(j,77)%j+A(j,83)%j+A(j,105)%j+A(j,107)%j+A(j,114)%j+A(j,125)%j &
       +A(j,133)%j+A(j,137)%j+A(j,139)%j+A(j,149)%j+A(j,157)%j+A(j,159)%j+A(j,165)%j+A(j,167)%j+A(j,175)%j+A(j,189)%j+A(j,191)%j &
       +A(j,197)%j+A(j,205)%j+A(j,207)%j+A(j,209)%j+A(j,215)%j+A(j,225)%j+A(j,227)%j+A(j,229)%j+A(j,241)%j+A(j,243)%j &
       +A(j,249)%j)*f(10))/2._/**/REALKIND+(CI*(A(j,80)%j+A(j,96)%j-A(j,168)%j-A(j,172)%j-A(j,182)%j-A(j,212)%j+A(j,250)%j &
       +A(j,254)%j)*f(11))/2._/**/REALKIND+(CI*(A(j,81)%j+A(j,97)%j-A(j,169)%j-A(j,173)%j-A(j,183)%j-A(j,213)%j+A(j,251)%j &
       +A(j,255)%j)*f(12))/2._/**/REALKIND+((A(j,58)%j+A(j,78)%j+A(j,100)%j+A(j,116)%j+A(j,134)%j+A(j,150)%j+A(j,184)%j+A(j,198)%j &
       +A(j,210)%j+A(j,230)%j)*f(13))/2._/**/REALKIND+((A(j,59)%j+A(j,79)%j+A(j,101)%j+A(j,117)%j+A(j,135)%j+A(j,151)%j+A(j,185)%j &
       +A(j,199)%j+A(j,211)%j+A(j,231)%j)*f(14))/2._/**/REALKIND+(CI*(A(j,86)%j+A(j,102)%j-A(j,186)%j &
       -A(j,216)%j)*f(15))/2._/**/REALKIND+(CI*(A(j,87)%j+A(j,103)%j-A(j,187)%j-A(j,217)%j)*f(16))/2._/**/REALKIND+(CI*(A(j,68)%j &
       +A(j,72)%j-A(j,118)%j-A(j,122)%j)*f(17))/2._/**/REALKIND+(CI*(A(j,69)%j+A(j,73)%j-A(j,119)%j &
       -A(j,123)%j)*f(18))/2._/**/REALKIND+(CI*(A(j,53)%j-A(j,54)%j-A(j,55)%j)*f(19))/2._/**/REALKIND+((-A(j,60)%j-A(j,75)%j &
       -A(j,115)%j-A(j,126)%j)*f(20))/2._/**/REALKIND
  M2(3)%j = ((-A(j,268)%j-A(j,270)%j-A(j,272)%j-A(j,274)%j-A(j,276)%j-A(j,278)%j-A(j,280)%j-A(j,294)%j-A(j,302)%j-A(j,304)%j &
       -A(j,306)%j-A(j,308)%j-A(j,310)%j-A(j,312)%j-A(j,314)%j-A(j,334)%j-A(j,340)%j-A(j,344)%j-A(j,352)%j-A(j,354)%j-A(j,356)%j &
       -A(j,358)%j-A(j,360)%j-A(j,362)%j-A(j,388)%j-A(j,390)%j-A(j,392)%j-A(j,394)%j-A(j,396)%j-A(j,398)%j)*f(5))/2._/**/REALKIND &
       +((A(j,50)%j+A(j,52)%j)*f(6))/4._/**/REALKIND+((-A(j,269)%j-A(j,271)%j-A(j,273)%j-A(j,275)%j-A(j,277)%j-A(j,279)%j &
       -A(j,281)%j-A(j,295)%j-A(j,303)%j-A(j,305)%j-A(j,307)%j-A(j,309)%j-A(j,311)%j-A(j,313)%j-A(j,315)%j-A(j,335)%j-A(j,341)%j &
       -A(j,345)%j-A(j,353)%j-A(j,355)%j-A(j,357)%j-A(j,359)%j-A(j,361)%j-A(j,363)%j-A(j,389)%j-A(j,391)%j-A(j,393)%j-A(j,395)%j &
       -A(j,397)%j-A(j,399)%j)*f(6))/2._/**/REALKIND+(CI*(A(j,284)%j+A(j,286)%j+A(j,288)%j+A(j,290)%j+A(j,296)%j+A(j,300)%j &
       -A(j,328)%j-A(j,330)%j-A(j,336)%j-A(j,342)%j-A(j,348)%j-A(j,350)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,285)%j+A(j,287)%j &
       +A(j,289)%j+A(j,291)%j+A(j,297)%j+A(j,301)%j-A(j,329)%j-A(j,331)%j-A(j,337)%j-A(j,343)%j-A(j,349)%j &
       -A(j,351)%j)*f(8))/2._/**/REALKIND+((A(j,61)%j+A(j,70)%j+A(j,88)%j+A(j,90)%j+A(j,92)%j+A(j,98)%j+A(j,108)%j+A(j,120)%j &
       +A(j,128)%j+A(j,140)%j+A(j,142)%j+A(j,144)%j+A(j,152)%j+A(j,154)%j+A(j,160)%j+A(j,162)%j+A(j,170)%j+A(j,176)%j+A(j,180)%j &
       +A(j,192)%j+A(j,194)%j+A(j,200)%j+A(j,220)%j+A(j,222)%j+A(j,232)%j+A(j,236)%j+A(j,238)%j+A(j,244)%j+A(j,246)%j &
       +A(j,252)%j)*f(9))/2._/**/REALKIND+((A(j,62)%j+A(j,71)%j+A(j,89)%j+A(j,91)%j+A(j,93)%j+A(j,99)%j+A(j,109)%j+A(j,121)%j &
       +A(j,129)%j+A(j,141)%j+A(j,143)%j+A(j,145)%j+A(j,153)%j+A(j,155)%j+A(j,161)%j+A(j,163)%j+A(j,171)%j+A(j,177)%j+A(j,181)%j &
       +A(j,193)%j+A(j,195)%j+A(j,201)%j+A(j,221)%j+A(j,223)%j+A(j,233)%j+A(j,237)%j+A(j,239)%j+A(j,245)%j+A(j,247)%j &
       +A(j,253)%j)*f(10))/2._/**/REALKIND+(CI*(-A(j,80)%j-A(j,96)%j+A(j,168)%j+A(j,172)%j+A(j,182)%j+A(j,212)%j-A(j,250)%j &
       -A(j,254)%j)*f(11))/2._/**/REALKIND+(CI*(-A(j,81)%j-A(j,97)%j+A(j,169)%j+A(j,173)%j+A(j,183)%j+A(j,213)%j-A(j,251)%j &
       -A(j,255)%j)*f(12))/2._/**/REALKIND+((A(j,63)%j+A(j,84)%j+A(j,94)%j+A(j,111)%j+A(j,130)%j+A(j,146)%j+A(j,178)%j+A(j,202)%j &
       +A(j,218)%j+A(j,234)%j)*f(13))/2._/**/REALKIND+((A(j,64)%j+A(j,85)%j+A(j,95)%j+A(j,112)%j+A(j,131)%j+A(j,147)%j+A(j,179)%j &
       +A(j,203)%j+A(j,219)%j+A(j,235)%j)*f(14))/2._/**/REALKIND+(CI*(-A(j,86)%j-A(j,102)%j+A(j,186)%j &
       +A(j,216)%j)*f(15))/2._/**/REALKIND+(CI*(-A(j,87)%j-A(j,103)%j+A(j,187)%j+A(j,217)%j)*f(16))/2._/**/REALKIND+(CI*( &
       -A(j,68)%j-A(j,72)%j+A(j,118)%j+A(j,122)%j)*f(17))/2._/**/REALKIND+(CI*(-A(j,69)%j-A(j,73)%j+A(j,119)%j &
       +A(j,123)%j)*f(18))/2._/**/REALKIND+(CI*(-A(j,53)%j+A(j,54)%j+A(j,55)%j)*f(19))/2._/**/REALKIND+((-A(j,65)%j-A(j,74)%j &
       -A(j,110)%j-A(j,127)%j)*f(20))/2._/**/REALKIND
  M2(4)%j = ((A(j,256)%j+A(j,258)%j+A(j,260)%j+A(j,262)%j+A(j,264)%j+A(j,266)%j+A(j,268)%j+A(j,270)%j+A(j,272)%j+A(j,274)%j &
       +A(j,276)%j+A(j,278)%j+A(j,280)%j+A(j,282)%j+A(j,292)%j+A(j,294)%j+A(j,298)%j+A(j,302)%j+A(j,376)%j+A(j,378)%j+A(j,380)%j &
       +A(j,382)%j+A(j,384)%j+A(j,386)%j+A(j,388)%j+A(j,390)%j+A(j,392)%j+A(j,394)%j+A(j,396)%j+A(j,398)%j)*f(5))/6._/**/REALKIND &
       +((-A(j,49)%j-A(j,50)%j-A(j,51)%j-A(j,52)%j)*f(6))/12._/**/REALKIND+((A(j,257)%j+A(j,259)%j+A(j,261)%j+A(j,263)%j &
       +A(j,265)%j+A(j,267)%j+A(j,269)%j+A(j,271)%j+A(j,273)%j+A(j,275)%j+A(j,277)%j+A(j,279)%j+A(j,281)%j+A(j,283)%j+A(j,293)%j &
       +A(j,295)%j+A(j,299)%j+A(j,303)%j+A(j,377)%j+A(j,379)%j+A(j,381)%j+A(j,383)%j+A(j,385)%j+A(j,387)%j+A(j,389)%j+A(j,391)%j &
       +A(j,393)%j+A(j,395)%j+A(j,397)%j+A(j,399)%j)*f(6))/6._/**/REALKIND+((-A(j,56)%j-A(j,61)%j-A(j,66)%j-A(j,70)%j-A(j,76)%j &
       -A(j,82)%j-A(j,88)%j-A(j,90)%j-A(j,92)%j-A(j,98)%j-A(j,104)%j-A(j,106)%j-A(j,136)%j-A(j,138)%j-A(j,140)%j-A(j,142)%j &
       -A(j,152)%j-A(j,154)%j-A(j,156)%j-A(j,158)%j-A(j,196)%j-A(j,200)%j-A(j,228)%j-A(j,232)%j-A(j,240)%j-A(j,242)%j-A(j,244)%j &
       -A(j,246)%j-A(j,248)%j-A(j,252)%j)*f(9))/6._/**/REALKIND+((-A(j,57)%j-A(j,62)%j-A(j,67)%j-A(j,71)%j-A(j,77)%j-A(j,83)%j &
       -A(j,89)%j-A(j,91)%j-A(j,93)%j-A(j,99)%j-A(j,105)%j-A(j,107)%j-A(j,137)%j-A(j,139)%j-A(j,141)%j-A(j,143)%j-A(j,153)%j &
       -A(j,155)%j-A(j,157)%j-A(j,159)%j-A(j,197)%j-A(j,201)%j-A(j,229)%j-A(j,233)%j-A(j,241)%j-A(j,243)%j-A(j,245)%j-A(j,247)%j &
       -A(j,249)%j-A(j,253)%j)*f(10))/6._/**/REALKIND+((-A(j,58)%j-A(j,63)%j-A(j,78)%j-A(j,84)%j-A(j,94)%j-A(j,100)%j-A(j,198)%j &
       -A(j,202)%j-A(j,230)%j-A(j,234)%j)*f(13))/6._/**/REALKIND+((-A(j,59)%j-A(j,64)%j-A(j,79)%j-A(j,85)%j-A(j,95)%j-A(j,101)%j &
       -A(j,199)%j-A(j,203)%j-A(j,231)%j-A(j,235)%j)*f(14))/6._/**/REALKIND+((A(j,60)%j+A(j,65)%j+A(j,74)%j &
       +A(j,75)%j)*f(20))/6._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplljjj_eexddxssxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 4
      do j = 1, 4
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplljjj_eexddxssxg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(4), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 4
      do j = 1, 4
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pplljjj_eexddxssxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2IRadd(29)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 30-1
    colmatpos = 4*k
    do i = 1, 4
      do j = 1, 4
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplljjj_eexddxssxg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pplljjj_eexddxssxg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(4)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer :: i, j


  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 4 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pplljjj_eexddxssxg_1_/**/REALKIND
