
module ol_vamp_2_pplljj2_eexuuxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplljj2_eexuuxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplljj2_eexuuxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pplljj2_eexuuxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pplljj2_eexuuxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(3)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,4) :: G0
  complex(REALKIND), dimension(4,5,4,16) :: G1
  complex(REALKIND), pointer :: G2tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G2tensorhel(15,16,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G2tensor => G2tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),ZERO,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,117),G1(:,:,:,2))
  call check_last_Q_A(l_switch,G1(:,:,:,2),Q(:,63),ZERO,G2tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,118),G1(:,:,:,3))
  call check_last_Q_A(l_switch,G1(:,:,:,3),Q(:,63),ZERO,G2tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,127),G1(:,:,:,4))
  call check_last_Q_A(l_switch,G1(:,:,:,4),Q(:,63),ZERO,G2tensor(:,3))
  call loop_QV_A(G1(:,:,:,1),wf(:,128),G1(:,:,:,5))
  call check_last_Q_A(l_switch,G1(:,:,:,5),Q(:,63),ZERO,G2tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,6))
  call loop_QV_A(G1(:,:,:,6),wf(:,117),G1(:,:,:,7))
  call check_last_Q_A(l_switch,G1(:,:,:,7),Q(:,63),MT,G2tensor(:,5))
  call loop_QV_A(G1(:,:,:,6),wf(:,118),G1(:,:,:,8))
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,63),MT,G2tensor(:,6))
  call loop_QV_A(G1(:,:,:,6),wf(:,127),G1(:,:,:,9))
  call check_last_Q_A(l_switch,G1(:,:,:,9),Q(:,63),MT,G2tensor(:,7))
  call loop_QV_A(G1(:,:,:,6),wf(:,128),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,63),MT,G2tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,117),G1(:,:,:,12))
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,63),MB,G2tensor(:,9))
  call loop_QV_A(G1(:,:,:,11),wf(:,118),G1(:,:,:,13))
  call check_last_Q_A(l_switch,G1(:,:,:,13),Q(:,63),MB,G2tensor(:,10))
  call loop_QV_A(G1(:,:,:,11),wf(:,127),G1(:,:,:,14))
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,63),MB,G2tensor(:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,128),G1(:,:,:,15))
  call check_last_Q_A(l_switch,G1(:,:,:,15),Q(:,63),MB,G2tensor(:,12))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,28),Q(:,48),G1(:,:,:,16))
  call check_last_CV_D(l_switch,G1(:,:,:,16),Q(:,48),wf(:,117),Q(:,15),G2tensor(:,13))
  call check_last_CV_D(l_switch,G1(:,:,:,16),Q(:,48),wf(:,118),Q(:,15),G2tensor(:,14))
  call check_last_CV_D(l_switch,G1(:,:,:,16),Q(:,48),wf(:,127),Q(:,15),G2tensor(:,15))
  call check_last_CV_D(l_switch,G1(:,:,:,16),Q(:,48),wf(:,128),Q(:,15),G2tensor(:,16))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(30))/2._/**/REALKIND * den(160)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,1),T2sum(1:15,25))
  M(2) = M(2) + ((CI*f(30))/2._/**/REALKIND * den(160)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,1),T2sum(1:15,25))
  M(1) = M(1) + (-(CI*f(28))/2._/**/REALKIND * den(160)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,5),T2sum(1:15,26))
  M(2) = M(2) + ((CI*f(28))/2._/**/REALKIND * den(160)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,5),T2sum(1:15,26))
  M(1) = M(1) + (-(CI*f(30))/2._/**/REALKIND * den(160)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,1),T2sum(1:15,25))
  M(2) = M(2) + ((CI*f(30))/2._/**/REALKIND * den(160)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,1),T2sum(1:15,25))
  M(1) = M(1) + (-(CI*f(28))/2._/**/REALKIND * den(160)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,9),T2sum(1:15,27))
  M(2) = M(2) + ((CI*f(28))/2._/**/REALKIND * den(160)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,9),T2sum(1:15,27))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(161)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,2),T2sum(1:15,25))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(161)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,2),T2sum(1:15,25))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(161)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,6),T2sum(1:15,26))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(161)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,6),T2sum(1:15,26))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(161)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,2),T2sum(1:15,25))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(161)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,2),T2sum(1:15,25))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(161)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,10),T2sum(1:15,27))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(161)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,10),T2sum(1:15,27))
  M(1) = M(1) + (-3*CI*f(23) * den(160)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,13),T2sum(1:15,25))
  M(2) = M(2) + (3*CI*f(23) * den(160)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,13),T2sum(1:15,25))
  M(1) = M(1) + (3*CI*f(24) * den(161)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,14),T2sum(1:15,25))
  M(2) = M(2) + (-3*CI*f(24) * den(161)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,14),T2sum(1:15,25))
  M(1) = M(1) + (-(CI*f(30))/2._/**/REALKIND * den(162)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,3),T2sum(1:15,25))
  M(2) = M(2) + ((CI*f(30))/2._/**/REALKIND * den(162)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,3),T2sum(1:15,25))
  M(1) = M(1) + (-(CI*f(28))/2._/**/REALKIND * den(162)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,7),T2sum(1:15,26))
  M(2) = M(2) + ((CI*f(28))/2._/**/REALKIND * den(162)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,7),T2sum(1:15,26))
  M(1) = M(1) + (-(CI*f(30))/2._/**/REALKIND * den(162)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,3),T2sum(1:15,25))
  M(2) = M(2) + ((CI*f(30))/2._/**/REALKIND * den(162)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,3),T2sum(1:15,25))
  M(1) = M(1) + (-(CI*f(28))/2._/**/REALKIND * den(162)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,11),T2sum(1:15,27))
  M(2) = M(2) + ((CI*f(28))/2._/**/REALKIND * den(162)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,11),T2sum(1:15,27))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(163)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,4),T2sum(1:15,25))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(163)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,4),T2sum(1:15,25))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(163)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,8),T2sum(1:15,26))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(163)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,8),T2sum(1:15,26))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(163)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,4),T2sum(1:15,25))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(163)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,4),T2sum(1:15,25))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(163)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,12),T2sum(1:15,27))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(163)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,12),T2sum(1:15,27))
  M(1) = M(1) + (-3*CI*f(23) * den(162)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,15),T2sum(1:15,25))
  M(2) = M(2) + (3*CI*f(23) * den(162)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,15),T2sum(1:15,25))
  M(1) = M(1) + (3*CI*f(24) * den(163)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,16),T2sum(1:15,25))
  M(2) = M(2) + (-3*CI*f(24) * den(163)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,16),T2sum(1:15,25))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G2tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_2_pplljj2_eexuuxgg_1_/**/REALKIND
