
module ol_vamp_1_pplljj2_nenexddxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplljj2_nenexddxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplljj2_nenexddxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pplljj2_nenexddxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pplljj2_nenexddxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(3)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,69) :: G0
  complex(REALKIND), dimension(4,5,4,187) :: G1
  complex(REALKIND), dimension(4,15,4,239) :: G2
  complex(REALKIND), dimension(4,35,4,87) :: G3
  complex(REALKIND), dimension(4,70,4,12) :: G4
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G1tensorhel(5,38,64))
    allocate(G2tensorhel(15,49,64))
    allocate(G3tensorhel(35,101,64))
    allocate(G4tensorhel(70,36,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,-4),G0(:,:,:,2))
  call loop_VA_Q(G0(:,:,:,2),wf(:,-3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,56),ZERO,G1(:,:,:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,1),wf(:,18),G1tensor(:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,4),G1(:,:,:,2),gZd)
  call loop_A_Q(G1(:,:,:,2),Q(:,59),ZERO,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,-2),G2tensor(:,1))
  call loop_VA_Q(G0(:,:,:,2),wf(:,10),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,59),ZERO,G1(:,:,:,3))
  call check_last_AQ_V(l_switch,G1(:,:,:,3),wf(:,-2),G1tensor(:,2))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,48),wf(:,94),Q(:,15),G1tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,48),wf(:,99),Q(:,15),G1tensor(:,4))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,-5),G0(:,:,:,5))
  call loop_VA_Q(G0(:,:,:,5),wf(:,-3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,56),ZERO,G1(:,:,:,4))
  call check_last_AQ_V(l_switch,G1(:,:,:,4),wf(:,18),G1tensor(:,5))
  call loop_AZ_Q(G1(:,:,:,4),wf(:,4),G1(:,:,:,5),gZd)
  call loop_A_Q(G1(:,:,:,5),Q(:,59),ZERO,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,-2),G2tensor(:,2))
  call loop_VA_Q(G0(:,:,:,5),wf(:,10),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,59),ZERO,G1(:,:,:,6))
  call check_last_AQ_V(l_switch,G1(:,:,:,6),wf(:,-2),G1tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,48),wf(:,94),Q(:,15),G1tensor(:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,48),wf(:,99),Q(:,15),G1tensor(:,8))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,-4),G0(:,:,:,8))
  call loop_VA_Q(G0(:,:,:,8),wf(:,-3),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,56),ZERO,G1(:,:,:,7))
  call check_last_AQ_V(l_switch,G1(:,:,:,7),wf(:,18),G1tensor(:,9))
  call loop_AZ_Q(G1(:,:,:,7),wf(:,4),G1(:,:,:,8),gZd)
  call loop_A_Q(G1(:,:,:,8),Q(:,59),ZERO,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,-2),G2tensor(:,3))
  call loop_VA_Q(G0(:,:,:,8),wf(:,10),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,59),ZERO,G1(:,:,:,9))
  call check_last_AQ_V(l_switch,G1(:,:,:,9),wf(:,-2),G1tensor(:,10))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,48),wf(:,94),Q(:,15),G1tensor(:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,48),wf(:,99),Q(:,15),G1tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,25),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,12),ZERO,G1(:,:,:,10))
  call loop_AV_Q(G1(:,:,:,10),wf(:,21),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,60),ZERO,G2(:,:,:,4))
  call loop_AZ_Q(G2(:,:,:,4),wf(:,4),G2(:,:,:,5),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,4),wf(:,4),G2(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),ZERO,G3tensor(:,2))
  call loop_AV_Q(G1(:,:,:,10),wf(:,-5),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,44),ZERO,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-4),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,60),ZERO,G3(:,:,:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,4),G3(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),ZERO,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,4),G3(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,63),ZERO,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,10),wf(:,-4),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,28),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-5),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,60),ZERO,G3(:,:,:,4))
  call loop_AZ_Q(G3(:,:,:,4),wf(:,4),G3(:,:,:,5),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,5),Q(:,63),ZERO,G4tensor(:,3))
  call loop_AZ_Q(G3(:,:,:,4),wf(:,4),G3(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),ZERO,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,25),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,12),MT,G1(:,:,:,14))
  call loop_AV_Q(G1(:,:,:,14),wf(:,21),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,60),MT,G2(:,:,:,11))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,4),G2(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,63),MT,G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,14),wf(:,-5),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,44),MT,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-4),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,60),MT,G3(:,:,:,7))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,4),G3(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,5))
  call loop_AV_Q(G1(:,:,:,14),wf(:,-4),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,28),MT,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-5),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,60),MT,G3(:,:,:,9))
  call loop_AZ_Q(G3(:,:,:,9),wf(:,4),G3(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,12),ZERO,G1(:,:,:,18))
  call loop_QV_A(G1(:,:,:,18),wf(:,21),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,60),ZERO,G2(:,:,:,17))
  call loop_QZ_A(G2(:,:,:,17),wf(:,4),G2(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),ZERO,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,17),wf(:,4),G2(:,:,:,19),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,63),ZERO,G3tensor(:,5))
  call loop_QV_A(G1(:,:,:,18),wf(:,-5),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,44),ZERO,G2(:,:,:,20))
  call loop_QV_A(G2(:,:,:,20),wf(:,-4),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,60),ZERO,G3(:,:,:,11))
  call loop_QZ_A(G3(:,:,:,11),wf(:,4),G3(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),ZERO,G4tensor(:,7))
  call loop_QZ_A(G3(:,:,:,11),wf(:,4),G3(:,:,:,13),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,13),Q(:,63),ZERO,G4tensor(:,8))
  call loop_QV_A(G1(:,:,:,18),wf(:,-4),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,28),ZERO,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,-5),G2(:,:,:,23))
  call loop_Q_A(G2(:,:,:,23),Q(:,60),ZERO,G3(:,:,:,14))
  call loop_QZ_A(G3(:,:,:,14),wf(:,4),G3(:,:,:,15),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,63),ZERO,G4tensor(:,9))
  call loop_QZ_A(G3(:,:,:,14),wf(:,4),G3(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,63),ZERO,G4tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,12),MT,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,21),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,60),MT,G2(:,:,:,24))
  call loop_QZ_A(G2(:,:,:,24),wf(:,4),G2(:,:,:,25),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,63),MT,G3tensor(:,6))
  call loop_QV_A(G1(:,:,:,22),wf(:,-5),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,44),MT,G2(:,:,:,26))
  call loop_QV_A(G2(:,:,:,26),wf(:,-4),G2(:,:,:,27))
  call loop_Q_A(G2(:,:,:,27),Q(:,60),MT,G3(:,:,:,17))
  call loop_QZ_A(G3(:,:,:,17),wf(:,4),G3(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,22),wf(:,-4),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,28),MT,G2(:,:,:,28))
  call loop_QV_A(G2(:,:,:,28),wf(:,-5),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,60),MT,G3(:,:,:,19))
  call loop_QZ_A(G3(:,:,:,19),wf(:,4),G3(:,:,:,20),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,25),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,12),MB,G1(:,:,:,26))
  call loop_AV_Q(G1(:,:,:,26),wf(:,21),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,60),MB,G2(:,:,:,30))
  call loop_AZ_Q(G2(:,:,:,30),wf(:,4),G2(:,:,:,31),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,63),MB,G3tensor(:,7))
  call loop_AV_Q(G1(:,:,:,26),wf(:,-5),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,44),MB,G2(:,:,:,32))
  call loop_AV_Q(G2(:,:,:,32),wf(:,-4),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,60),MB,G3(:,:,:,21))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,4),G3(:,:,:,22),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),MB,G4tensor(:,13))
  call loop_AV_Q(G1(:,:,:,26),wf(:,-4),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,28),MB,G2(:,:,:,34))
  call loop_AV_Q(G2(:,:,:,34),wf(:,-5),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,60),MB,G3(:,:,:,23))
  call loop_AZ_Q(G3(:,:,:,23),wf(:,4),G3(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MB,G4tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,12),MB,G1(:,:,:,30))
  call loop_QV_A(G1(:,:,:,30),wf(:,21),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,60),MB,G2(:,:,:,36))
  call loop_QZ_A(G2(:,:,:,36),wf(:,4),G2(:,:,:,37),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,63),MB,G3tensor(:,8))
  call loop_QV_A(G1(:,:,:,30),wf(:,-5),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,44),MB,G2(:,:,:,38))
  call loop_QV_A(G2(:,:,:,38),wf(:,-4),G2(:,:,:,39))
  call loop_Q_A(G2(:,:,:,39),Q(:,60),MB,G3(:,:,:,25))
  call loop_QZ_A(G3(:,:,:,25),wf(:,4),G3(:,:,:,26),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,63),MB,G4tensor(:,15))
  call loop_QV_A(G1(:,:,:,30),wf(:,-4),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,28),MB,G2(:,:,:,40))
  call loop_QV_A(G2(:,:,:,40),wf(:,-5),G2(:,:,:,41))
  call loop_Q_A(G2(:,:,:,41),Q(:,60),MB,G3(:,:,:,27))
  call loop_QZ_A(G3(:,:,:,27),wf(:,4),G3(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,63),MB,G4tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,28),ZERO,G1(:,:,:,34))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-5),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,60),ZERO,G2(:,:,:,42))
  call loop_AZ_Q(G2(:,:,:,42),wf(:,4),G2(:,:,:,43),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,63),ZERO,G3tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,42),wf(:,4),G2(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,63),ZERO,G3tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,28),MT,G1(:,:,:,36))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-5),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,60),MT,G2(:,:,:,45))
  call loop_AZ_Q(G2(:,:,:,45),wf(:,4),G2(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,63),MT,G3tensor(:,11))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,28),ZERO,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,-5),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,60),ZERO,G2(:,:,:,47))
  call loop_QZ_A(G2(:,:,:,47),wf(:,4),G2(:,:,:,48),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,63),ZERO,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,47),wf(:,4),G2(:,:,:,49),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,63),ZERO,G3tensor(:,13))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,28),MT,G1(:,:,:,40))
  call loop_QV_A(G1(:,:,:,40),wf(:,-5),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,60),MT,G2(:,:,:,50))
  call loop_QZ_A(G2(:,:,:,50),wf(:,4),G2(:,:,:,51),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,63),MT,G3tensor(:,14))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,28),MB,G1(:,:,:,42))
  call loop_AV_Q(G1(:,:,:,42),wf(:,-5),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,60),MB,G2(:,:,:,52))
  call loop_AZ_Q(G2(:,:,:,52),wf(:,4),G2(:,:,:,53),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,63),MB,G3tensor(:,15))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,28),MB,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,-5),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,60),MB,G2(:,:,:,54))
  call loop_QZ_A(G2(:,:,:,54),wf(:,4),G2(:,:,:,55),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,63),MB,G3tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,16),ZERO,G1(:,:,:,46))
  call loop_QV_A(G1(:,:,:,46),wf(:,31),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,60),ZERO,G2(:,:,:,56))
  call loop_QZ_A(G2(:,:,:,56),wf(:,4),G2(:,:,:,57),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,63),ZERO,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,56),wf(:,4),G2(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,63),ZERO,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,46),wf(:,25),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,28),ZERO,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,-5),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,60),ZERO,G3(:,:,:,29))
  call loop_QZ_A(G3(:,:,:,29),wf(:,4),G3(:,:,:,30),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,63),ZERO,G4tensor(:,17))
  call loop_QZ_A(G3(:,:,:,29),wf(:,4),G3(:,:,:,31),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,31),Q(:,63),ZERO,G4tensor(:,18))
  call loop_QV_A(G1(:,:,:,46),wf(:,40),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,60),ZERO,G2(:,:,:,61))
  call loop_QZ_A(G2(:,:,:,61),wf(:,4),G2(:,:,:,62),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,63),ZERO,G3tensor(:,19))
  call loop_QZ_A(G2(:,:,:,61),wf(:,4),G2(:,:,:,63),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,63),Q(:,63),ZERO,G3tensor(:,20))
  call loop_QV_A(G1(:,:,:,46),wf(:,42),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,60),ZERO,G2(:,:,:,64))
  call loop_QZ_A(G2(:,:,:,64),wf(:,4),G2(:,:,:,65),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,65),Q(:,63),ZERO,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,64),wf(:,4),G2(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,63),ZERO,G3tensor(:,22))
  call loop_QV_A(G1(:,:,:,46),wf(:,-5),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,48),ZERO,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,94),G2(:,:,:,68))
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,63),ZERO,G3tensor(:,23))
  call loop_QV_A(G2(:,:,:,67),wf(:,99),G2(:,:,:,69))
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,63),ZERO,G3tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,16),MT,G1(:,:,:,52))
  call loop_QV_A(G1(:,:,:,52),wf(:,31),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,60),MT,G2(:,:,:,70))
  call loop_QZ_A(G2(:,:,:,70),wf(:,4),G2(:,:,:,71),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,63),MT,G3tensor(:,25))
  call loop_QV_A(G1(:,:,:,52),wf(:,25),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,28),MT,G2(:,:,:,72))
  call loop_QV_A(G2(:,:,:,72),wf(:,-5),G2(:,:,:,73))
  call loop_Q_A(G2(:,:,:,73),Q(:,60),MT,G3(:,:,:,32))
  call loop_QZ_A(G3(:,:,:,32),wf(:,4),G3(:,:,:,33),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,33),Q(:,63),MT,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,52),wf(:,40),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,60),MT,G2(:,:,:,74))
  call loop_QZ_A(G2(:,:,:,74),wf(:,4),G2(:,:,:,75),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,63),MT,G3tensor(:,26))
  call loop_QV_A(G1(:,:,:,52),wf(:,42),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,60),MT,G2(:,:,:,76))
  call loop_QZ_A(G2(:,:,:,76),wf(:,4),G2(:,:,:,77),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,63),MT,G3tensor(:,27))
  call loop_QV_A(G1(:,:,:,52),wf(:,-5),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,48),MT,G2(:,:,:,78))
  call loop_QV_A(G2(:,:,:,78),wf(:,94),G2(:,:,:,79))
  call check_last_Q_A(l_switch,G2(:,:,:,79),Q(:,63),MT,G3tensor(:,28))
  call loop_QV_A(G2(:,:,:,78),wf(:,99),G2(:,:,:,80))
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,63),MT,G3tensor(:,29))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,16),ZERO,G1(:,:,:,58))
  call loop_AV_Q(G1(:,:,:,58),wf(:,31),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,60),ZERO,G2(:,:,:,81))
  call loop_AZ_Q(G2(:,:,:,81),wf(:,4),G2(:,:,:,82),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,63),ZERO,G3tensor(:,30))
  call loop_AZ_Q(G2(:,:,:,81),wf(:,4),G2(:,:,:,83),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,83),Q(:,63),ZERO,G3tensor(:,31))
  call loop_AV_Q(G1(:,:,:,58),wf(:,25),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,28),ZERO,G2(:,:,:,84))
  call loop_AV_Q(G2(:,:,:,84),wf(:,-5),G2(:,:,:,85))
  call loop_A_Q(G2(:,:,:,85),Q(:,60),ZERO,G3(:,:,:,34))
  call loop_AZ_Q(G3(:,:,:,34),wf(:,4),G3(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,63),ZERO,G4tensor(:,20))
  call loop_AZ_Q(G3(:,:,:,34),wf(:,4),G3(:,:,:,36),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,63),ZERO,G4tensor(:,21))
  call loop_AV_Q(G1(:,:,:,58),wf(:,40),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,60),ZERO,G2(:,:,:,86))
  call loop_AZ_Q(G2(:,:,:,86),wf(:,4),G2(:,:,:,87),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,87),Q(:,63),ZERO,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,86),wf(:,4),G2(:,:,:,88),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,63),ZERO,G3tensor(:,33))
  call loop_AV_Q(G1(:,:,:,58),wf(:,42),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,60),ZERO,G2(:,:,:,89))
  call loop_AZ_Q(G2(:,:,:,89),wf(:,4),G2(:,:,:,90),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,63),ZERO,G3tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,89),wf(:,4),G2(:,:,:,91),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,91),Q(:,63),ZERO,G3tensor(:,35))
  call loop_AV_Q(G1(:,:,:,58),wf(:,-5),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,48),ZERO,G2(:,:,:,92))
  call loop_AV_Q(G2(:,:,:,92),wf(:,94),G2(:,:,:,93))
  call check_last_A_Q(l_switch,G2(:,:,:,93),Q(:,63),ZERO,G3tensor(:,36))
  call loop_AV_Q(G2(:,:,:,92),wf(:,99),G2(:,:,:,94))
  call check_last_A_Q(l_switch,G2(:,:,:,94),Q(:,63),ZERO,G3tensor(:,37))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,16),MT,G1(:,:,:,64))
  call loop_AV_Q(G1(:,:,:,64),wf(:,31),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,60),MT,G2(:,:,:,95))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,4),G2(:,:,:,96),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,63),MT,G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,64),wf(:,25),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,28),MT,G2(:,:,:,97))
  call loop_AV_Q(G2(:,:,:,97),wf(:,-5),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,60),MT,G3(:,:,:,37))
  call loop_AZ_Q(G3(:,:,:,37),wf(:,4),G3(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,63),MT,G4tensor(:,22))
  call loop_AV_Q(G1(:,:,:,64),wf(:,40),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,60),MT,G2(:,:,:,99))
  call loop_AZ_Q(G2(:,:,:,99),wf(:,4),G2(:,:,:,100),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,63),MT,G3tensor(:,39))
  call loop_AV_Q(G1(:,:,:,64),wf(:,42),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,60),MT,G2(:,:,:,101))
  call loop_AZ_Q(G2(:,:,:,101),wf(:,4),G2(:,:,:,102),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,102),Q(:,63),MT,G3tensor(:,40))
  call loop_AV_Q(G1(:,:,:,64),wf(:,-5),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,48),MT,G2(:,:,:,103))
  call loop_AV_Q(G2(:,:,:,103),wf(:,94),G2(:,:,:,104))
  call check_last_A_Q(l_switch,G2(:,:,:,104),Q(:,63),MT,G3tensor(:,41))
  call loop_AV_Q(G2(:,:,:,103),wf(:,99),G2(:,:,:,105))
  call check_last_A_Q(l_switch,G2(:,:,:,105),Q(:,63),MT,G3tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,16),MB,G1(:,:,:,70))
  call loop_QV_A(G1(:,:,:,70),wf(:,31),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,60),MB,G2(:,:,:,106))
  call loop_QZ_A(G2(:,:,:,106),wf(:,4),G2(:,:,:,107),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,107),Q(:,63),MB,G3tensor(:,43))
  call loop_QV_A(G1(:,:,:,70),wf(:,25),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,28),MB,G2(:,:,:,108))
  call loop_QV_A(G2(:,:,:,108),wf(:,-5),G2(:,:,:,109))
  call loop_Q_A(G2(:,:,:,109),Q(:,60),MB,G3(:,:,:,39))
  call loop_QZ_A(G3(:,:,:,39),wf(:,4),G3(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),MB,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,70),wf(:,40),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,60),MB,G2(:,:,:,110))
  call loop_QZ_A(G2(:,:,:,110),wf(:,4),G2(:,:,:,111),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,111),Q(:,63),MB,G3tensor(:,44))
  call loop_QV_A(G1(:,:,:,70),wf(:,42),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,60),MB,G2(:,:,:,112))
  call loop_QZ_A(G2(:,:,:,112),wf(:,4),G2(:,:,:,113),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,113),Q(:,63),MB,G3tensor(:,45))
  call loop_QV_A(G1(:,:,:,70),wf(:,-5),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,48),MB,G2(:,:,:,114))
  call loop_QV_A(G2(:,:,:,114),wf(:,94),G2(:,:,:,115))
  call check_last_Q_A(l_switch,G2(:,:,:,115),Q(:,63),MB,G3tensor(:,46))
  call loop_QV_A(G2(:,:,:,114),wf(:,99),G2(:,:,:,116))
  call check_last_Q_A(l_switch,G2(:,:,:,116),Q(:,63),MB,G3tensor(:,47))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,16),MB,G1(:,:,:,76))
  call loop_AV_Q(G1(:,:,:,76),wf(:,31),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,60),MB,G2(:,:,:,117))
  call loop_AZ_Q(G2(:,:,:,117),wf(:,4),G2(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,63),MB,G3tensor(:,48))
  call loop_AV_Q(G1(:,:,:,76),wf(:,25),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,28),MB,G2(:,:,:,119))
  call loop_AV_Q(G2(:,:,:,119),wf(:,-5),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,60),MB,G3(:,:,:,41))
  call loop_AZ_Q(G3(:,:,:,41),wf(:,4),G3(:,:,:,42),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,63),MB,G4tensor(:,24))
  call loop_AV_Q(G1(:,:,:,76),wf(:,40),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,60),MB,G2(:,:,:,121))
  call loop_AZ_Q(G2(:,:,:,121),wf(:,4),G2(:,:,:,122),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,122),Q(:,63),MB,G3tensor(:,49))
  call loop_AV_Q(G1(:,:,:,76),wf(:,42),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,60),MB,G2(:,:,:,123))
  call loop_AZ_Q(G2(:,:,:,123),wf(:,4),G2(:,:,:,124),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,124),Q(:,63),MB,G3tensor(:,50))
  call loop_AV_Q(G1(:,:,:,76),wf(:,-5),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,48),MB,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,94),G2(:,:,:,126))
  call check_last_A_Q(l_switch,G2(:,:,:,126),Q(:,63),MB,G3tensor(:,51))
  call loop_AV_Q(G2(:,:,:,125),wf(:,99),G2(:,:,:,127))
  call check_last_A_Q(l_switch,G2(:,:,:,127),Q(:,63),MB,G3tensor(:,52))
  call loop_VA_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,40),ZERO,G1(:,:,:,82))
  call loop_AZ_Q(G1(:,:,:,82),wf(:,4),G1(:,:,:,83),gZd)
  call loop_A_Q(G1(:,:,:,83),Q(:,43),ZERO,G2(:,:,:,128))
  call check_last_AQ_V(l_switch,G2(:,:,:,128),wf(:,5),G2tensor(:,4))
  call loop_AV_Q(G2(:,:,:,128),wf(:,-4),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,59),ZERO,G3(:,:,:,43))
  call check_last_AQ_V(l_switch,G3(:,:,:,43),wf(:,-2),G3tensor(:,53))
  call loop_AV_Q(G1(:,:,:,82),wf(:,-4),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,56),ZERO,G2(:,:,:,130))
  call check_last_AQ_V(l_switch,G2(:,:,:,130),wf(:,18),G2tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,4),G2(:,:,:,131),gZd)
  call loop_A_Q(G2(:,:,:,131),Q(:,59),ZERO,G3(:,:,:,44))
  call check_last_AQ_V(l_switch,G3(:,:,:,44),wf(:,-2),G3tensor(:,54))
  call check_last_AQ_V(l_switch,G1(:,:,:,82),wf(:,74),G1tensor(:,13))
  call check_last_AQ_V(l_switch,G1(:,:,:,82),wf(:,96),G1tensor(:,14))
  call loop_VQ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,20),ZERO,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,-5),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,52),ZERO,G2(:,:,:,132))
  call check_last_QA_V(l_switch,G2(:,:,:,132),wf(:,10),G2tensor(:,6))
  call loop_QZ_A(G2(:,:,:,132),wf(:,4),G2(:,:,:,133),gZd)
  call loop_Q_A(G2(:,:,:,133),Q(:,55),ZERO,G3(:,:,:,45))
  call check_last_QA_V(l_switch,G3(:,:,:,45),wf(:,-3),G3tensor(:,55))
  call loop_QZ_A(G1(:,:,:,85),wf(:,4),G1(:,:,:,87),gZd)
  call loop_Q_A(G1(:,:,:,87),Q(:,23),ZERO,G2(:,:,:,134))
  call loop_QV_A(G2(:,:,:,134),wf(:,-5),G2(:,:,:,135))
  call loop_Q_A(G2(:,:,:,135),Q(:,55),ZERO,G3(:,:,:,46))
  call check_last_QA_V(l_switch,G3(:,:,:,46),wf(:,-3),G3tensor(:,56))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-5),Q(:,32),G1(:,:,:,88))
  call loop_VQ_A(G1(:,:,:,88),wf(:,5),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,52),ZERO,G2(:,:,:,136))
  call check_last_QA_V(l_switch,G2(:,:,:,136),wf(:,10),G2tensor(:,7))
  call loop_QZ_A(G2(:,:,:,136),wf(:,4),G2(:,:,:,137),gZd)
  call loop_Q_A(G2(:,:,:,137),Q(:,55),ZERO,G3(:,:,:,47))
  call check_last_QA_V(l_switch,G3(:,:,:,47),wf(:,-3),G3tensor(:,57))
  call loop_VQ_A(G1(:,:,:,88),wf(:,74),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,55),ZERO,G2(:,:,:,138))
  call check_last_QA_V(l_switch,G2(:,:,:,138),wf(:,-3),G2tensor(:,8))
  call loop_VA_Q(G1(:,:,:,88),wf(:,14),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,56),ZERO,G2(:,:,:,139))
  call check_last_AQ_V(l_switch,G2(:,:,:,139),wf(:,18),G2tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,139),wf(:,4),G2(:,:,:,140),gZd)
  call loop_A_Q(G2(:,:,:,140),Q(:,59),ZERO,G3(:,:,:,48))
  call check_last_AQ_V(l_switch,G3(:,:,:,48),wf(:,-2),G3tensor(:,58))
  call loop_VA_Q(G1(:,:,:,88),wf(:,80),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,59),ZERO,G2(:,:,:,141))
  call check_last_AQ_V(l_switch,G2(:,:,:,141),wf(:,-2),G2tensor(:,10))
  call loop_VQ_A(G1(:,:,:,88),wf(:,96),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,55),ZERO,G2(:,:,:,142))
  call check_last_QA_V(l_switch,G2(:,:,:,142),wf(:,-3),G2tensor(:,11))
  call loop_VA_Q(G1(:,:,:,88),wf(:,-3),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,40),ZERO,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-4),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,56),ZERO,G3(:,:,:,49))
  call check_last_AQ_V(l_switch,G3(:,:,:,49),wf(:,18),G3tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,4),G3(:,:,:,50),gZd)
  call loop_A_Q(G3(:,:,:,50),Q(:,59),ZERO,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,-2),G4tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,143),wf(:,4),G2(:,:,:,145),gZd)
  call loop_A_Q(G2(:,:,:,145),Q(:,43),ZERO,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,-4),G3(:,:,:,52))
  call loop_A_Q(G3(:,:,:,52),Q(:,59),ZERO,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,-2),G4tensor(:,26))
  call loop_UV_W(G1(:,:,:,88),Q(:,32),wf(:,-4),Q(:,16),G2(:,:,:,146))
  call loop_VA_Q(G2(:,:,:,146),wf(:,-3),G2(:,:,:,147))
  call loop_A_Q(G2(:,:,:,147),Q(:,56),ZERO,G3(:,:,:,53))
  call check_last_AQ_V(l_switch,G3(:,:,:,53),wf(:,18),G3tensor(:,60))
  call loop_AZ_Q(G3(:,:,:,53),wf(:,4),G3(:,:,:,54),gZd)
  call loop_A_Q(G3(:,:,:,54),Q(:,59),ZERO,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,-2),G4tensor(:,27))
  call loop_VA_Q(G2(:,:,:,146),wf(:,10),G2(:,:,:,148))
  call loop_A_Q(G2(:,:,:,148),Q(:,59),ZERO,G3(:,:,:,55))
  call check_last_AQ_V(l_switch,G3(:,:,:,55),wf(:,-2),G3tensor(:,61))
  call loop_VA_Q(G1(:,:,:,88),wf(:,101),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,59),ZERO,G2(:,:,:,149))
  call check_last_AQ_V(l_switch,G2(:,:,:,149),wf(:,-2),G2tensor(:,12))
  call loop_VA_Q(G1(:,:,:,88),wf(:,10),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,43),ZERO,G2(:,:,:,150))
  call loop_AV_Q(G2(:,:,:,150),wf(:,-4),G2(:,:,:,151))
  call loop_A_Q(G2(:,:,:,151),Q(:,59),ZERO,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,-2),G3tensor(:,62))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,88),wf(:,-4),wf(:,94),G1tensor(:,15))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,88),wf(:,94),wf(:,-4),G1tensor(:,16))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,88),wf(:,-4),wf(:,94),G1tensor(:,17))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,88),wf(:,-4),wf(:,99),G1tensor(:,18))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,88),wf(:,99),wf(:,-4),G1tensor(:,19))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,88),wf(:,-4),wf(:,99),G1tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,35),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,28),ZERO,G1(:,:,:,97))
  call loop_AV_Q(G1(:,:,:,97),wf(:,-5),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,60),ZERO,G2(:,:,:,152))
  call loop_AZ_Q(G2(:,:,:,152),wf(:,4),G2(:,:,:,153),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,153),Q(:,63),ZERO,G3tensor(:,63))
  call loop_AZ_Q(G2(:,:,:,152),wf(:,4),G2(:,:,:,154),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,154),Q(:,63),ZERO,G3tensor(:,64))
  call loop_AV_Q(G0(:,:,:,1),wf(:,35),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,28),MT,G1(:,:,:,99))
  call loop_AV_Q(G1(:,:,:,99),wf(:,-5),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,60),MT,G2(:,:,:,155))
  call loop_AZ_Q(G2(:,:,:,155),wf(:,4),G2(:,:,:,156),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,156),Q(:,63),MT,G3tensor(:,65))
  call loop_QV_A(G0(:,:,:,1),wf(:,35),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,28),ZERO,G1(:,:,:,101))
  call loop_QV_A(G1(:,:,:,101),wf(:,-5),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,60),ZERO,G2(:,:,:,157))
  call loop_QZ_A(G2(:,:,:,157),wf(:,4),G2(:,:,:,158),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,158),Q(:,63),ZERO,G3tensor(:,66))
  call loop_QZ_A(G2(:,:,:,157),wf(:,4),G2(:,:,:,159),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,159),Q(:,63),ZERO,G3tensor(:,67))
  call loop_QV_A(G0(:,:,:,1),wf(:,35),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,28),MT,G1(:,:,:,103))
  call loop_QV_A(G1(:,:,:,103),wf(:,-5),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,60),MT,G2(:,:,:,160))
  call loop_QZ_A(G2(:,:,:,160),wf(:,4),G2(:,:,:,161),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,161),Q(:,63),MT,G3tensor(:,68))
  call loop_AV_Q(G0(:,:,:,1),wf(:,35),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,28),MB,G1(:,:,:,105))
  call loop_AV_Q(G1(:,:,:,105),wf(:,-5),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,60),MB,G2(:,:,:,162))
  call loop_AZ_Q(G2(:,:,:,162),wf(:,4),G2(:,:,:,163),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,163),Q(:,63),MB,G3tensor(:,69))
  call loop_QV_A(G0(:,:,:,1),wf(:,35),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,28),MB,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,-5),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,60),MB,G2(:,:,:,164))
  call loop_QZ_A(G2(:,:,:,164),wf(:,4),G2(:,:,:,165),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,165),Q(:,63),MB,G3tensor(:,70))
  call loop_VQ_A(G0(:,:,:,1),wf(:,48),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,52),ZERO,G1(:,:,:,109))
  call loop_QZ_A(G1(:,:,:,109),wf(:,4),G1(:,:,:,110),gZd)
  call loop_Q_A(G1(:,:,:,110),Q(:,55),ZERO,G2(:,:,:,166))
  call check_last_QA_V(l_switch,G2(:,:,:,166),wf(:,-3),G2tensor(:,13))
  call check_last_QA_V(l_switch,G1(:,:,:,109),wf(:,10),G1tensor(:,21))
  call loop_VQ_A(G0(:,:,:,1),wf(:,74),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,23),ZERO,G1(:,:,:,111))
  call loop_QV_A(G1(:,:,:,111),wf(:,-5),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,55),ZERO,G2(:,:,:,167))
  call check_last_QA_V(l_switch,G2(:,:,:,167),wf(:,-3),G2tensor(:,14))
  call loop_VQ_A(G0(:,:,:,1),wf(:,13),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,36),ZERO,G1(:,:,:,113))
  call loop_QZ_A(G1(:,:,:,113),wf(:,4),G1(:,:,:,114),gZd)
  call loop_Q_A(G1(:,:,:,114),Q(:,39),ZERO,G2(:,:,:,168))
  call check_last_QA_V(l_switch,G2(:,:,:,168),wf(:,14),G2tensor(:,15))
  call loop_QV_A(G2(:,:,:,168),wf(:,-4),G2(:,:,:,169))
  call loop_Q_A(G2(:,:,:,169),Q(:,55),ZERO,G3(:,:,:,57))
  call check_last_QA_V(l_switch,G3(:,:,:,57),wf(:,-3),G3tensor(:,71))
  call loop_QV_A(G1(:,:,:,113),wf(:,-4),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,52),ZERO,G2(:,:,:,170))
  call check_last_QA_V(l_switch,G2(:,:,:,170),wf(:,10),G2tensor(:,16))
  call loop_QZ_A(G2(:,:,:,170),wf(:,4),G2(:,:,:,171),gZd)
  call loop_Q_A(G2(:,:,:,171),Q(:,55),ZERO,G3(:,:,:,58))
  call check_last_QA_V(l_switch,G3(:,:,:,58),wf(:,-3),G3tensor(:,72))
  call check_last_QA_V(l_switch,G1(:,:,:,113),wf(:,80),G1tensor(:,22))
  call check_last_QA_V(l_switch,G1(:,:,:,113),wf(:,101),G1tensor(:,23))
  call loop_VA_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,40))
  call loop_A_Q(G0(:,:,:,40),Q(:,24),ZERO,G1(:,:,:,116))
  call loop_AV_Q(G1(:,:,:,116),wf(:,-5),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,56),ZERO,G2(:,:,:,172))
  call check_last_AQ_V(l_switch,G2(:,:,:,172),wf(:,18),G2tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,172),wf(:,4),G2(:,:,:,173),gZd)
  call loop_A_Q(G2(:,:,:,173),Q(:,59),ZERO,G3(:,:,:,59))
  call check_last_AQ_V(l_switch,G3(:,:,:,59),wf(:,-2),G3tensor(:,73))
  call loop_AZ_Q(G1(:,:,:,116),wf(:,4),G1(:,:,:,118),gZd)
  call loop_A_Q(G1(:,:,:,118),Q(:,27),ZERO,G2(:,:,:,174))
  call loop_AV_Q(G2(:,:,:,174),wf(:,-5),G2(:,:,:,175))
  call loop_A_Q(G2(:,:,:,175),Q(:,59),ZERO,G3(:,:,:,60))
  call check_last_AQ_V(l_switch,G3(:,:,:,60),wf(:,-2),G3tensor(:,74))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,41))
  call loop_A_Q(G0(:,:,:,41),Q(:,28),ZERO,G1(:,:,:,119))
  call loop_AV_Q(G1(:,:,:,119),wf(:,-5),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,60),ZERO,G2(:,:,:,176))
  call loop_AZ_Q(G2(:,:,:,176),wf(:,4),G2(:,:,:,177),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,177),Q(:,63),ZERO,G3tensor(:,75))
  call loop_AZ_Q(G2(:,:,:,176),wf(:,4),G2(:,:,:,178),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,178),Q(:,63),ZERO,G3tensor(:,76))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,28),MT,G1(:,:,:,121))
  call loop_AV_Q(G1(:,:,:,121),wf(:,-5),G1(:,:,:,122))
  call loop_A_Q(G1(:,:,:,122),Q(:,60),MT,G2(:,:,:,179))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,4),G2(:,:,:,180),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,180),Q(:,63),MT,G3tensor(:,77))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,28),ZERO,G1(:,:,:,123))
  call loop_QV_A(G1(:,:,:,123),wf(:,-5),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,60),ZERO,G2(:,:,:,181))
  call loop_QZ_A(G2(:,:,:,181),wf(:,4),G2(:,:,:,182),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,182),Q(:,63),ZERO,G3tensor(:,78))
  call loop_QZ_A(G2(:,:,:,181),wf(:,4),G2(:,:,:,183),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,183),Q(:,63),ZERO,G3tensor(:,79))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,44))
  call loop_Q_A(G0(:,:,:,44),Q(:,28),MT,G1(:,:,:,125))
  call loop_QV_A(G1(:,:,:,125),wf(:,-5),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,60),MT,G2(:,:,:,184))
  call loop_QZ_A(G2(:,:,:,184),wf(:,4),G2(:,:,:,185),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,185),Q(:,63),MT,G3tensor(:,80))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,28),MB,G1(:,:,:,127))
  call loop_AV_Q(G1(:,:,:,127),wf(:,-5),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,60),MB,G2(:,:,:,186))
  call loop_AZ_Q(G2(:,:,:,186),wf(:,4),G2(:,:,:,187),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,187),Q(:,63),MB,G3tensor(:,81))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,28),MB,G1(:,:,:,129))
  call loop_QV_A(G1(:,:,:,129),wf(:,-5),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,60),MB,G2(:,:,:,188))
  call loop_QZ_A(G2(:,:,:,188),wf(:,4),G2(:,:,:,189),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,189),Q(:,63),MB,G3tensor(:,82))
  call loop_VA_Q(G0(:,:,:,1),wf(:,58),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,56),ZERO,G1(:,:,:,131))
  call loop_AZ_Q(G1(:,:,:,131),wf(:,4),G1(:,:,:,132),gZd)
  call loop_A_Q(G1(:,:,:,132),Q(:,59),ZERO,G2(:,:,:,190))
  call check_last_AQ_V(l_switch,G2(:,:,:,190),wf(:,-2),G2tensor(:,18))
  call check_last_AQ_V(l_switch,G1(:,:,:,131),wf(:,18),G1tensor(:,24))
  call loop_VA_Q(G0(:,:,:,1),wf(:,80),G0(:,:,:,48))
  call loop_A_Q(G0(:,:,:,48),Q(:,27),ZERO,G1(:,:,:,133))
  call loop_AV_Q(G1(:,:,:,133),wf(:,-5),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,59),ZERO,G2(:,:,:,191))
  call check_last_AQ_V(l_switch,G2(:,:,:,191),wf(:,-2),G2tensor(:,19))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,135))
  call loop_VQ_A(G1(:,:,:,135),wf(:,13),G1(:,:,:,136))
  call loop_Q_A(G1(:,:,:,136),Q(:,52),ZERO,G2(:,:,:,192))
  call check_last_QA_V(l_switch,G2(:,:,:,192),wf(:,10),G2tensor(:,20))
  call loop_QZ_A(G2(:,:,:,192),wf(:,4),G2(:,:,:,193),gZd)
  call loop_Q_A(G2(:,:,:,193),Q(:,55),ZERO,G3(:,:,:,61))
  call check_last_QA_V(l_switch,G3(:,:,:,61),wf(:,-3),G3tensor(:,83))
  call loop_VQ_A(G1(:,:,:,135),wf(:,82),G1(:,:,:,137))
  call loop_Q_A(G1(:,:,:,137),Q(:,55),ZERO,G2(:,:,:,194))
  call check_last_QA_V(l_switch,G2(:,:,:,194),wf(:,-3),G2tensor(:,21))
  call loop_VA_Q(G1(:,:,:,135),wf(:,6),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,56),ZERO,G2(:,:,:,195))
  call check_last_AQ_V(l_switch,G2(:,:,:,195),wf(:,18),G2tensor(:,22))
  call loop_AZ_Q(G2(:,:,:,195),wf(:,4),G2(:,:,:,196),gZd)
  call loop_A_Q(G2(:,:,:,196),Q(:,59),ZERO,G3(:,:,:,62))
  call check_last_AQ_V(l_switch,G3(:,:,:,62),wf(:,-2),G3tensor(:,84))
  call loop_VA_Q(G1(:,:,:,135),wf(:,72),G1(:,:,:,139))
  call loop_A_Q(G1(:,:,:,139),Q(:,59),ZERO,G2(:,:,:,197))
  call check_last_AQ_V(l_switch,G2(:,:,:,197),wf(:,-2),G2tensor(:,23))
  call loop_UV_W(G1(:,:,:,135),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,198))
  call check_last_UV_W(l_switch,G2(:,:,:,198),Q(:,48),wf(:,94),Q(:,15),G3tensor(:,85))
  call loop_VA_Q(G2(:,:,:,198),wf(:,-3),G2(:,:,:,199))
  call loop_A_Q(G2(:,:,:,199),Q(:,56),ZERO,G3(:,:,:,63))
  call check_last_AQ_V(l_switch,G3(:,:,:,63),wf(:,18),G3tensor(:,86))
  call loop_AZ_Q(G3(:,:,:,63),wf(:,4),G3(:,:,:,64),gZd)
  call loop_A_Q(G3(:,:,:,64),Q(:,59),ZERO,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,-2),G4tensor(:,28))
  call check_last_UV_W(l_switch,G2(:,:,:,198),Q(:,48),wf(:,99),Q(:,15),G3tensor(:,87))
  call loop_VA_Q(G2(:,:,:,198),wf(:,10),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,59),ZERO,G3(:,:,:,65))
  call check_last_AQ_V(l_switch,G3(:,:,:,65),wf(:,-2),G3tensor(:,88))
  call loop_VQ_A(G1(:,:,:,135),wf(:,98),G1(:,:,:,140))
  call loop_Q_A(G1(:,:,:,140),Q(:,55),ZERO,G2(:,:,:,201))
  call check_last_QA_V(l_switch,G2(:,:,:,201),wf(:,-3),G2tensor(:,24))
  call loop_VA_Q(G1(:,:,:,135),wf(:,-3),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,24),ZERO,G2(:,:,:,202))
  call loop_AV_Q(G2(:,:,:,202),wf(:,-5),G2(:,:,:,203))
  call loop_A_Q(G2(:,:,:,203),Q(:,56),ZERO,G3(:,:,:,66))
  call check_last_AQ_V(l_switch,G3(:,:,:,66),wf(:,18),G3tensor(:,89))
  call loop_AZ_Q(G3(:,:,:,66),wf(:,4),G3(:,:,:,67),gZd)
  call loop_A_Q(G3(:,:,:,67),Q(:,59),ZERO,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,-2),G4tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,202),wf(:,4),G2(:,:,:,204),gZd)
  call loop_A_Q(G2(:,:,:,204),Q(:,27),ZERO,G3(:,:,:,68))
  call loop_AV_Q(G3(:,:,:,68),wf(:,-5),G3(:,:,:,69))
  call loop_A_Q(G3(:,:,:,69),Q(:,59),ZERO,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,-2),G4tensor(:,30))
  call loop_VA_Q(G1(:,:,:,135),wf(:,103),G1(:,:,:,142))
  call loop_A_Q(G1(:,:,:,142),Q(:,59),ZERO,G2(:,:,:,205))
  call check_last_AQ_V(l_switch,G2(:,:,:,205),wf(:,-2),G2tensor(:,25))
  call loop_VA_Q(G1(:,:,:,135),wf(:,10),G1(:,:,:,143))
  call loop_A_Q(G1(:,:,:,143),Q(:,27),ZERO,G2(:,:,:,206))
  call loop_AV_Q(G2(:,:,:,206),wf(:,-5),G2(:,:,:,207))
  call loop_A_Q(G2(:,:,:,207),Q(:,59),ZERO,G3(:,:,:,70))
  call check_last_AQ_V(l_switch,G3(:,:,:,70),wf(:,-2),G3tensor(:,90))
  call loop_VQ_A(G0(:,:,:,1),wf(:,51),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,52),ZERO,G1(:,:,:,144))
  call loop_QZ_A(G1(:,:,:,144),wf(:,4),G1(:,:,:,145),gZd)
  call loop_Q_A(G1(:,:,:,145),Q(:,55),ZERO,G2(:,:,:,208))
  call check_last_QA_V(l_switch,G2(:,:,:,208),wf(:,-3),G2tensor(:,26))
  call check_last_QA_V(l_switch,G1(:,:,:,144),wf(:,10),G1tensor(:,25))
  call loop_VQ_A(G0(:,:,:,1),wf(:,82),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,39),ZERO,G1(:,:,:,146))
  call loop_QV_A(G1(:,:,:,146),wf(:,-4),G1(:,:,:,147))
  call loop_Q_A(G1(:,:,:,147),Q(:,55),ZERO,G2(:,:,:,209))
  call check_last_QA_V(l_switch,G2(:,:,:,209),wf(:,-3),G2tensor(:,27))
  call check_last_QA_V(l_switch,G1(:,:,:,146),wf(:,14),G1tensor(:,26))
  call loop_VA_Q(G0(:,:,:,1),wf(:,62),G0(:,:,:,51))
  call loop_A_Q(G0(:,:,:,51),Q(:,56),ZERO,G1(:,:,:,148))
  call loop_AZ_Q(G1(:,:,:,148),wf(:,4),G1(:,:,:,149),gZd)
  call loop_A_Q(G1(:,:,:,149),Q(:,59),ZERO,G2(:,:,:,210))
  call check_last_AQ_V(l_switch,G2(:,:,:,210),wf(:,-2),G2tensor(:,28))
  call check_last_AQ_V(l_switch,G1(:,:,:,148),wf(:,18),G1tensor(:,27))
  call loop_VA_Q(G0(:,:,:,1),wf(:,72),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,43),ZERO,G1(:,:,:,150))
  call loop_AV_Q(G1(:,:,:,150),wf(:,-4),G1(:,:,:,151))
  call loop_A_Q(G1(:,:,:,151),Q(:,59),ZERO,G2(:,:,:,211))
  call check_last_AQ_V(l_switch,G2(:,:,:,211),wf(:,-2),G2tensor(:,29))
  call check_last_AQ_V(l_switch,G1(:,:,:,150),wf(:,5),G1tensor(:,28))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,8),ZERO,G1(:,:,:,152))
  call loop_AV_Q(G1(:,:,:,152),wf(:,21),G1(:,:,:,153))
  call loop_A_Q(G1(:,:,:,153),Q(:,56),ZERO,G2(:,:,:,212))
  call check_last_AQ_V(l_switch,G2(:,:,:,212),wf(:,18),G2tensor(:,30))
  call loop_AZ_Q(G2(:,:,:,212),wf(:,4),G2(:,:,:,213),gZd)
  call loop_A_Q(G2(:,:,:,213),Q(:,59),ZERO,G3(:,:,:,71))
  call check_last_AQ_V(l_switch,G3(:,:,:,71),wf(:,-2),G3tensor(:,91))
  call loop_AZ_Q(G1(:,:,:,152),wf(:,4),G1(:,:,:,154),gZd)
  call loop_A_Q(G1(:,:,:,154),Q(:,11),ZERO,G2(:,:,:,214))
  call loop_AV_Q(G2(:,:,:,214),wf(:,21),G2(:,:,:,215))
  call loop_A_Q(G2(:,:,:,215),Q(:,59),ZERO,G3(:,:,:,72))
  call check_last_AQ_V(l_switch,G3(:,:,:,72),wf(:,-2),G3tensor(:,92))
  call loop_AV_Q(G2(:,:,:,214),wf(:,-5),G2(:,:,:,216))
  call loop_A_Q(G2(:,:,:,216),Q(:,43),ZERO,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,-4),G3(:,:,:,74))
  call loop_A_Q(G3(:,:,:,74),Q(:,59),ZERO,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,-2),G4tensor(:,31))
  call loop_AV_Q(G2(:,:,:,214),wf(:,-4),G2(:,:,:,217))
  call loop_A_Q(G2(:,:,:,217),Q(:,27),ZERO,G3(:,:,:,75))
  call loop_AV_Q(G3(:,:,:,75),wf(:,-5),G3(:,:,:,76))
  call loop_A_Q(G3(:,:,:,76),Q(:,59),ZERO,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,-2),G4tensor(:,32))
  call loop_AV_Q(G1(:,:,:,152),wf(:,-4),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,24),ZERO,G2(:,:,:,218))
  call loop_AV_Q(G2(:,:,:,218),wf(:,-5),G2(:,:,:,219))
  call loop_A_Q(G2(:,:,:,219),Q(:,56),ZERO,G3(:,:,:,77))
  call check_last_AQ_V(l_switch,G3(:,:,:,77),wf(:,18),G3tensor(:,93))
  call loop_AZ_Q(G3(:,:,:,77),wf(:,4),G3(:,:,:,78),gZd)
  call loop_A_Q(G3(:,:,:,78),Q(:,59),ZERO,G4(:,:,:,9))
  call check_last_AQ_V(l_switch,G4(:,:,:,9),wf(:,-2),G4tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,218),wf(:,4),G2(:,:,:,220),gZd)
  call loop_A_Q(G2(:,:,:,220),Q(:,27),ZERO,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-5),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,59),ZERO,G4(:,:,:,10))
  call check_last_AQ_V(l_switch,G4(:,:,:,10),wf(:,-2),G4tensor(:,34))
  call loop_AV_Q(G1(:,:,:,152),wf(:,-5),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,40),ZERO,G2(:,:,:,221))
  call loop_AV_Q(G2(:,:,:,221),wf(:,-4),G2(:,:,:,222))
  call loop_A_Q(G2(:,:,:,222),Q(:,56),ZERO,G3(:,:,:,81))
  call check_last_AQ_V(l_switch,G3(:,:,:,81),wf(:,18),G3tensor(:,94))
  call loop_AZ_Q(G3(:,:,:,81),wf(:,4),G3(:,:,:,82),gZd)
  call loop_A_Q(G3(:,:,:,82),Q(:,59),ZERO,G4(:,:,:,11))
  call check_last_AQ_V(l_switch,G4(:,:,:,11),wf(:,-2),G4tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,221),wf(:,4),G2(:,:,:,223),gZd)
  call loop_A_Q(G2(:,:,:,223),Q(:,43),ZERO,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,-4),G3(:,:,:,84))
  call loop_A_Q(G3(:,:,:,84),Q(:,59),ZERO,G4(:,:,:,12))
  call check_last_AQ_V(l_switch,G4(:,:,:,12),wf(:,-2),G4tensor(:,36))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,21),Q(:,48),G1(:,:,:,157))
  call loop_VA_Q(G1(:,:,:,157),wf(:,-3),G1(:,:,:,158))
  call loop_A_Q(G1(:,:,:,158),Q(:,56),ZERO,G2(:,:,:,224))
  call check_last_AQ_V(l_switch,G2(:,:,:,224),wf(:,18),G2tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,224),wf(:,4),G2(:,:,:,225),gZd)
  call loop_A_Q(G2(:,:,:,225),Q(:,59),ZERO,G3(:,:,:,85))
  call check_last_AQ_V(l_switch,G3(:,:,:,85),wf(:,-2),G3tensor(:,95))
  call loop_VA_Q(G1(:,:,:,157),wf(:,10),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,59),ZERO,G2(:,:,:,226))
  call check_last_AQ_V(l_switch,G2(:,:,:,226),wf(:,-2),G2tensor(:,32))
  call check_last_UV_W(l_switch,G1(:,:,:,157),Q(:,48),wf(:,94),Q(:,15),G2tensor(:,33))
  call check_last_UV_W(l_switch,G1(:,:,:,157),Q(:,48),wf(:,99),Q(:,15),G2tensor(:,34))
  call loop_VA_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,54))
  call loop_A_Q(G0(:,:,:,54),Q(:,11),ZERO,G1(:,:,:,160))
  call loop_AV_Q(G1(:,:,:,160),wf(:,21),G1(:,:,:,161))
  call loop_A_Q(G1(:,:,:,161),Q(:,59),ZERO,G2(:,:,:,227))
  call check_last_AQ_V(l_switch,G2(:,:,:,227),wf(:,-2),G2tensor(:,35))
  call loop_AV_Q(G1(:,:,:,160),wf(:,-5),G1(:,:,:,162))
  call loop_A_Q(G1(:,:,:,162),Q(:,43),ZERO,G2(:,:,:,228))
  call loop_AV_Q(G2(:,:,:,228),wf(:,-4),G2(:,:,:,229))
  call loop_A_Q(G2(:,:,:,229),Q(:,59),ZERO,G3(:,:,:,86))
  call check_last_AQ_V(l_switch,G3(:,:,:,86),wf(:,-2),G3tensor(:,96))
  call loop_AV_Q(G1(:,:,:,160),wf(:,-4),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,27),ZERO,G2(:,:,:,230))
  call loop_AV_Q(G2(:,:,:,230),wf(:,-5),G2(:,:,:,231))
  call loop_A_Q(G2(:,:,:,231),Q(:,59),ZERO,G3(:,:,:,87))
  call check_last_AQ_V(l_switch,G3(:,:,:,87),wf(:,-2),G3tensor(:,97))
  call loop_VQ_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,52),ZERO,G1(:,:,:,164))
  call loop_QZ_A(G1(:,:,:,164),wf(:,4),G1(:,:,:,165),gZd)
  call loop_Q_A(G1(:,:,:,165),Q(:,55),ZERO,G2(:,:,:,232))
  call check_last_QA_V(l_switch,G2(:,:,:,232),wf(:,-3),G2tensor(:,36))
  call check_last_QA_V(l_switch,G1(:,:,:,164),wf(:,10),G1tensor(:,29))
  call loop_VA_Q(G0(:,:,:,1),wf(:,64),G0(:,:,:,56))
  call loop_A_Q(G0(:,:,:,56),Q(:,56),ZERO,G1(:,:,:,166))
  call loop_AZ_Q(G1(:,:,:,166),wf(:,4),G1(:,:,:,167),gZd)
  call loop_A_Q(G1(:,:,:,167),Q(:,59),ZERO,G2(:,:,:,233))
  call check_last_AQ_V(l_switch,G2(:,:,:,233),wf(:,-2),G2tensor(:,37))
  call check_last_AQ_V(l_switch,G1(:,:,:,166),wf(:,18),G1tensor(:,30))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,-4),G1(:,:,:,168))
  call loop_DV_C(G1(:,:,:,168),Q(:,16),wf(:,-5),G2(:,:,:,234))
  call check_last_DV_C(l_switch,G2(:,:,:,234),Q(:,48),wf(:,94),G3tensor(:,98))
  call check_last_DV_C(l_switch,G2(:,:,:,234),Q(:,48),wf(:,99),G3tensor(:,99))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,169))
  call loop_CV_D(G1(:,:,:,169),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,235))
  call check_last_CV_D(l_switch,G2(:,:,:,235),Q(:,48),wf(:,94),Q(:,15),G3tensor(:,100))
  call check_last_CV_D(l_switch,G2(:,:,:,235),Q(:,48),wf(:,99),Q(:,15),G3tensor(:,101))
  call loop_VQ_A(G0(:,:,:,1),wf(:,96),G0(:,:,:,57))
  call loop_Q_A(G0(:,:,:,57),Q(:,23),ZERO,G1(:,:,:,170))
  call loop_QV_A(G1(:,:,:,170),wf(:,-5),G1(:,:,:,171))
  call loop_Q_A(G1(:,:,:,171),Q(:,55),ZERO,G2(:,:,:,236))
  call check_last_QA_V(l_switch,G2(:,:,:,236),wf(:,-3),G2tensor(:,38))
  call loop_VQ_A(G0(:,:,:,1),wf(:,98),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,39),ZERO,G1(:,:,:,172))
  call loop_QV_A(G1(:,:,:,172),wf(:,-4),G1(:,:,:,173))
  call loop_Q_A(G1(:,:,:,173),Q(:,55),ZERO,G2(:,:,:,237))
  call check_last_QA_V(l_switch,G2(:,:,:,237),wf(:,-3),G2tensor(:,39))
  call check_last_QA_V(l_switch,G1(:,:,:,172),wf(:,14),G1tensor(:,31))
  call loop_VA_Q(G0(:,:,:,1),wf(:,101),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,27),ZERO,G1(:,:,:,174))
  call loop_AV_Q(G1(:,:,:,174),wf(:,-5),G1(:,:,:,175))
  call loop_A_Q(G1(:,:,:,175),Q(:,59),ZERO,G2(:,:,:,238))
  call check_last_AQ_V(l_switch,G2(:,:,:,238),wf(:,-2),G2tensor(:,40))
  call loop_VA_Q(G0(:,:,:,1),wf(:,103),G0(:,:,:,60))
  call loop_A_Q(G0(:,:,:,60),Q(:,43),ZERO,G1(:,:,:,176))
  call loop_AV_Q(G1(:,:,:,176),wf(:,-4),G1(:,:,:,177))
  call loop_A_Q(G1(:,:,:,177),Q(:,59),ZERO,G2(:,:,:,239))
  call check_last_AQ_V(l_switch,G2(:,:,:,239),wf(:,-2),G2tensor(:,41))
  call check_last_AQ_V(l_switch,G1(:,:,:,176),wf(:,5),G1tensor(:,32))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,94),G0(:,:,:,61))
  call check_last_UV_W(l_switch,G0(:,:,:,61),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,33))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,94),wf(:,-5),G0(:,:,:,62))
  call check_last_UV_W(l_switch,G0(:,:,:,62),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,34))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,94),G0(:,:,:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,63),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,35))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,99),G0(:,:,:,64))
  call check_last_UV_W(l_switch,G0(:,:,:,64),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,36))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,99),wf(:,-5),G0(:,:,:,65))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,37))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,99),G0(:,:,:,66))
  call check_last_UV_W(l_switch,G0(:,:,:,66),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,67))
  call loop_Q_A(G0(:,:,:,67),Q(:,48),ZERO,G1(:,:,:,178))
  call loop_QV_A(G1(:,:,:,178),wf(:,94),G1(:,:,:,179))
  call check_last_Q_A(l_switch,G1(:,:,:,179),Q(:,63),ZERO,G2tensor(:,42))
  call loop_QV_A(G1(:,:,:,178),wf(:,99),G1(:,:,:,180))
  call check_last_Q_A(l_switch,G1(:,:,:,180),Q(:,63),ZERO,G2tensor(:,43))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,48),MT,G1(:,:,:,181))
  call loop_QV_A(G1(:,:,:,181),wf(:,94),G1(:,:,:,182))
  call check_last_Q_A(l_switch,G1(:,:,:,182),Q(:,63),MT,G2tensor(:,44))
  call loop_QV_A(G1(:,:,:,181),wf(:,99),G1(:,:,:,183))
  call check_last_Q_A(l_switch,G1(:,:,:,183),Q(:,63),MT,G2tensor(:,45))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,69))
  call loop_Q_A(G0(:,:,:,69),Q(:,48),MB,G1(:,:,:,184))
  call loop_QV_A(G1(:,:,:,184),wf(:,94),G1(:,:,:,185))
  call check_last_Q_A(l_switch,G1(:,:,:,185),Q(:,63),MB,G2tensor(:,46))
  call loop_QV_A(G1(:,:,:,184),wf(:,99),G1(:,:,:,186))
  call check_last_Q_A(l_switch,G1(:,:,:,186),Q(:,63),MB,G2tensor(:,47))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,21),Q(:,48),G1(:,:,:,187))
  call check_last_CV_D(l_switch,G1(:,:,:,187),Q(:,48),wf(:,94),Q(:,15),G2tensor(:,48))
  call check_last_CV_D(l_switch,G1(:,:,:,187),Q(:,48),wf(:,99),Q(:,15),G2tensor(:,49))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + ((3*f(14))/2._/**/REALKIND * den(14)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,1),T2sum(1:5,1))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(14)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,1),T2sum(1:5,1))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(14)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,5),T2sum(1:5,1))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(14)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,5),T2sum(1:5,1))
  M(1) = M(1) + ((-3*f(14))/2._/**/REALKIND * den(14)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,9),T2sum(1:5,1))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(14)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,9),T2sum(1:5,1))
  M(1) = M(1) + ((3*f(14))/2._/**/REALKIND * den(7)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,2),T2sum(1:5,2))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(7)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,2),T2sum(1:5,2))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(7)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,6),T2sum(1:5,2))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(7)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,6),T2sum(1:5,2))
  M(1) = M(1) + ((-3*f(14))/2._/**/REALKIND * den(7)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,10),T2sum(1:5,2))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(7)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,10),T2sum(1:5,2))
  M(1) = M(1) + ((3*f(14))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,1),T3sum(1:15,1))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,1),T3sum(1:15,1))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,2),T3sum(1:15,1))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,2),T3sum(1:15,1))
  M(1) = M(1) + ((-3*f(14))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,3),T3sum(1:15,1))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,3),T3sum(1:15,1))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,1),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,1),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,3),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,3),T3sum(1:35,3))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,4),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,4),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,6),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,6),T3sum(1:35,3))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,2),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,2),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,7),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,7),T3sum(1:35,4))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,5),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,5),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,8),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,8),T3sum(1:35,4))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,9),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,9),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,11),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,11),T3sum(1:35,6))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,12),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,12),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,14),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,14),T3sum(1:35,6))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,10),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,10),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,15),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,15),T3sum(1:35,7))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,13),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,13),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,16),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(28)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,16),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(16))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,17),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(16))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,17),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,25),T3sum(1:35,9))
  M(2) = M(2) + ((CI*f(15))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,25),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(16))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,30),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(16))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,30),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,38),T3sum(1:35,9))
  M(2) = M(2) + ((CI*f(15))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,38),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(16))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,18),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(16))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,18),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,43),T3sum(1:35,10))
  M(2) = M(2) + ((CI*f(15))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,43),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(16))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,31),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(16))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,31),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,48),T3sum(1:35,10))
  M(2) = M(2) + ((CI*f(15))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,48),T3sum(1:35,10))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,7),T4sum(1:70,1))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,11),T4sum(1:70,2))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,11),T4sum(1:70,2))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,1),T4sum(1:70,1))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,1),T4sum(1:70,1))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,5),T4sum(1:70,2))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,5),T4sum(1:70,2))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,8),T4sum(1:70,1))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,8),T4sum(1:70,1))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,15),T4sum(1:70,3))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,15),T4sum(1:70,3))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,2),T4sum(1:70,1))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,2),T4sum(1:70,1))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,13),T4sum(1:70,3))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,13),T4sum(1:70,3))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,3),T4sum(1:70,4))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,3),T4sum(1:70,4))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,6),T4sum(1:70,5))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,6),T4sum(1:70,5))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,9),T4sum(1:70,4))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,9),T4sum(1:70,4))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,12),T4sum(1:70,5))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,12),T4sum(1:70,5))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,4),T4sum(1:70,4))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,4),T4sum(1:70,4))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,14),T4sum(1:70,6))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,14),T4sum(1:70,6))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,10),T4sum(1:70,4))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,10),T4sum(1:70,4))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,16),T4sum(1:70,6))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,16),T4sum(1:70,6))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,17),T4sum(1:70,7))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,17),T4sum(1:70,7))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,19),T4sum(1:70,8))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,19),T4sum(1:70,8))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,20),T4sum(1:70,7))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,20),T4sum(1:70,7))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,22),T4sum(1:70,8))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,22),T4sum(1:70,8))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,18),T4sum(1:70,7))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,18),T4sum(1:70,7))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,23),T4sum(1:70,9))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,23),T4sum(1:70,9))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,21),T4sum(1:70,7))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,21),T4sum(1:70,7))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(24)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,24),T4sum(1:70,9))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(24)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,24),T4sum(1:70,9))
  M(2) = M(2) + ((4*f(14))/3._/**/REALKIND * den(91)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,4),T2sum(1:15,3))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(8)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,6),T2sum(1:15,4))
  M(2) = M(2) + ((-3*CI*f(13))/2._/**/REALKIND * den(8)) * TI2_call(2,momenta_24,masses2_6,G2tensor(:,7),T2sum(1:15,5))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(33)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,63),T3sum(1:35,5))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(33)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,65),T3sum(1:35,6))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(33)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,66),T3sum(1:35,5))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(33)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,68),T3sum(1:35,6))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(33)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,64),T3sum(1:35,5))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(33)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,69),T3sum(1:35,7))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(33)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,67),T3sum(1:35,5))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(33)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,70),T3sum(1:35,7))
  M(2) = M(2) + ((4*f(14))/3._/**/REALKIND * den(41)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,13),T2sum(1:15,6))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(57)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,14),T2sum(1:15,7))
  M(2) = M(2) + ((-3*CI*f(13))/2._/**/REALKIND * den(57)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,8),T2sum(1:15,8))
  M(2) = M(2) + ((-3*CI*f(13))/2._/**/REALKIND * den(4)) * TI2_call(3,momenta_61,masses2_9,G3tensor(:,57),T3sum(1:35,11))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(4)) * TI2_call(3,momenta_53,masses2_9,G3tensor(:,56),T3sum(1:35,12))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(4)) * TI2_call(3,momenta_54,masses2_9,G3tensor(:,55),T3sum(1:35,13))
  M(1) = M(1) + ((4*f(14))/3._/**/REALKIND * den(92)) * TI2_call(2,momenta_28,masses2_6,G2tensor(:,15),T2sum(1:15,9))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(15)) * TI2_call(2,momenta_21,masses2_6,G2tensor(:,17),T2sum(1:15,10))
  M(1) = M(1) + ((3*CI*f(13))/2._/**/REALKIND * den(15)) * TI2_call(2,momenta_26,masses2_6,G2tensor(:,9),T2sum(1:15,11))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(35)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,75),T3sum(1:35,5))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(35)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,77),T3sum(1:35,6))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(35)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,78),T3sum(1:35,5))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(35)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,80),T3sum(1:35,6))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(35)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,76),T3sum(1:35,5))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(35)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,81),T3sum(1:35,7))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(35)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,79),T3sum(1:35,5))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(35)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,82),T3sum(1:35,7))
  M(1) = M(1) + ((4*f(14))/3._/**/REALKIND * den(46)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,18),T2sum(1:15,12))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(64)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,19),T2sum(1:15,13))
  M(1) = M(1) + ((3*CI*f(13))/2._/**/REALKIND * den(64)) * TI2_call(2,momenta_27,masses2_6,G2tensor(:,10),T2sum(1:15,14))
  M(1) = M(1) + ((3*CI*f(13))/2._/**/REALKIND * den(62)) * TI2_call(3,momenta_62,masses2_9,G3tensor(:,58),T3sum(1:35,14))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(62)) * TI2_call(3,momenta_55,masses2_9,G3tensor(:,74),T3sum(1:35,15))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(62)) * TI2_call(3,momenta_56,masses2_9,G3tensor(:,73),T3sum(1:35,16))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(16)) * TI2_call(2,momenta_29,masses2_6,G2tensor(:,16),T2sum(1:15,15))
  M(1) = M(1) + ((-3*CI*f(13))/2._/**/REALKIND * den(16)) * TI2_call(2,momenta_14,masses2_6,G2tensor(:,20),T2sum(1:15,16))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,19),T3sum(1:35,8))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,26),T3sum(1:35,9))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,32),T3sum(1:35,8))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,39),T3sum(1:35,9))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,20),T3sum(1:35,8))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,44),T3sum(1:35,10))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,33),T3sum(1:35,8))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,49),T3sum(1:35,10))
  M(1) = M(1) + ((4*f(14))/3._/**/REALKIND * den(43)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,26),T2sum(1:15,6))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(67)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,27),T2sum(1:15,17))
  M(1) = M(1) + ((-3*CI*f(13))/2._/**/REALKIND * den(67)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,21),T2sum(1:15,18))
  M(1) = M(1) + ((-3*CI*f(13))/2._/**/REALKIND * den(11)) * TI2_call(3,momenta_51,masses2_9,G3tensor(:,83),T3sum(1:35,17))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(11)) * TI2_call(3,momenta_63,masses2_9,G3tensor(:,71),T3sum(1:35,18))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(11)) * TI2_call(3,momenta_64,masses2_9,G3tensor(:,72),T3sum(1:35,19))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(17)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,5),T2sum(1:15,19))
  M(2) = M(2) + ((3*CI*f(13))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_16,masses2_6,G2tensor(:,22),T2sum(1:15,20))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,21),T3sum(1:35,8))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,27),T3sum(1:35,9))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,34),T3sum(1:35,8))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,40),T3sum(1:35,9))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,22),T3sum(1:35,8))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,45),T3sum(1:35,10))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,35),T3sum(1:35,8))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,50),T3sum(1:35,10))
  M(2) = M(2) + ((4*f(14))/3._/**/REALKIND * den(48)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,28),T2sum(1:15,12))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(54)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,29),T2sum(1:15,21))
  M(2) = M(2) + ((3*CI*f(13))/2._/**/REALKIND * den(54)) * TI2_call(2,momenta_17,masses2_6,G2tensor(:,23),T2sum(1:15,22))
  M(2) = M(2) + ((3*CI*f(13))/2._/**/REALKIND * den(52)) * TI2_call(3,momenta_52,masses2_9,G3tensor(:,84),T3sum(1:35,20))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(52)) * TI2_call(3,momenta_65,masses2_9,G3tensor(:,53),T3sum(1:35,21))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(52)) * TI2_call(3,momenta_66,masses2_9,G3tensor(:,54),T3sum(1:35,22))
  M(1) = M(1) + ((CI*f(13))/6._/**/REALKIND * den(19)) * TI2_call(2,momenta_10,masses2_6,G2tensor(:,30),T2sum(1:15,23))
  M(2) = M(2) + (-(CI*f(13))/6._/**/REALKIND * den(19)) * TI2_call(2,momenta_10,masses2_6,G2tensor(:,30),T2sum(1:15,23))
  M(1) = M(1) + ((-3*f(14))/2._/**/REALKIND * den(19)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,31),T2sum(1:15,1))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(19)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,31),T2sum(1:15,1))
  M(1) = M(1) + ((CI*f(13))/6._/**/REALKIND * den(49)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,35),T2sum(1:15,24))
  M(2) = M(2) + (-(CI*f(13))/6._/**/REALKIND * den(49)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,35),T2sum(1:15,24))
  M(1) = M(1) + ((-3*f(14))/2._/**/REALKIND * den(49)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,32),T2sum(1:15,2))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(49)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,32),T2sum(1:15,2))
  M(1) = M(1) + ((-4*CI*f(13))/3._/**/REALKIND * den(22)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,36),T2sum(1:15,6))
  M(2) = M(2) + ((4*CI*f(13))/3._/**/REALKIND * den(22)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,36),T2sum(1:15,6))
  M(1) = M(1) + ((-4*CI*f(13))/3._/**/REALKIND * den(51)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,37),T2sum(1:15,12))
  M(2) = M(2) + ((4*CI*f(13))/3._/**/REALKIND * den(51)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,37),T2sum(1:15,12))
  M(1) = M(1) + ((CI*f(13))/6._/**/REALKIND * den(93)) * TI2_call(3,momenta_41,masses2_9,G3tensor(:,91),T3sum(1:35,23))
  M(2) = M(2) + (-(CI*f(13))/6._/**/REALKIND * den(93)) * TI2_call(3,momenta_41,masses2_9,G3tensor(:,91),T3sum(1:35,23))
  M(1) = M(1) + ((CI*f(13))/6._/**/REALKIND * den(93)) * TI2_call(3,momenta_38,masses2_9,G3tensor(:,92),T3sum(1:35,24))
  M(2) = M(2) + (-(CI*f(13))/6._/**/REALKIND * den(93)) * TI2_call(3,momenta_38,masses2_9,G3tensor(:,92),T3sum(1:35,24))
  M(1) = M(1) + ((-3*f(14))/2._/**/REALKIND * den(93)) * TI2_call(3,momenta_67,masses2_9,G3tensor(:,95),T3sum(1:35,1))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(93)) * TI2_call(3,momenta_67,masses2_9,G3tensor(:,95),T3sum(1:35,1))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,36),T3sum(1:35,25))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,36),T3sum(1:35,25))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,41),T3sum(1:35,26))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,41),T3sum(1:35,26))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,23),T3sum(1:35,25))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,23),T3sum(1:35,25))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,28),T3sum(1:35,26))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,28),T3sum(1:35,26))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,36),T3sum(1:35,25))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,36),T3sum(1:35,25))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,51),T3sum(1:35,27))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,51),T3sum(1:35,27))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,23),T3sum(1:35,25))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,23),T3sum(1:35,25))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,46),T3sum(1:35,27))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,46),T3sum(1:35,27))
  M(1) = M(1) + ((3*CI*f(13))/2._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,98),T3sum(1:35,25))
  M(2) = M(2) + ((-3*CI*f(13))/2._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,98),T3sum(1:35,25))
  M(1) = M(1) + ((-3*CI*f(13))/2._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,100),T3sum(1:35,25))
  M(2) = M(2) + ((3*CI*f(13))/2._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,100),T3sum(1:35,25))
  M(1) = M(1) + ((-3*CI*f(13))/2._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,85),T3sum(1:35,25))
  M(2) = M(2) + ((3*CI*f(13))/2._/**/REALKIND * den(84)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,85),T3sum(1:35,25))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(85)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,38),T2sum(1:15,7))
  M(2) = M(2) + ((-3*CI*f(13))/2._/**/REALKIND * den(85)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,11),T2sum(1:15,8))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(86)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,39),T2sum(1:15,17))
  M(1) = M(1) + ((-3*CI*f(13))/2._/**/REALKIND * den(86)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,24),T2sum(1:15,18))
  M(3) = M(3) + (-(CI*f(13))/2._/**/REALKIND * den(14)) * TI2_call(3,momenta_57,masses2_9,G3tensor(:,59),T3sum(1:35,28))
  M(3) = M(3) + (-(CI*f(13))/2._/**/REALKIND * den(14)) * TI2_call(3,momenta_46,masses2_9,G3tensor(:,89),T3sum(1:35,29))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(14)) * TI2_call(3,momenta_39,masses2_9,G3tensor(:,93),T3sum(1:35,30))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(14)) * TI2_call(3,momenta_39,masses2_9,G3tensor(:,93),T3sum(1:35,30))
  M(1) = M(1) + ((3*f(14))/2._/**/REALKIND * den(14)) * TI2_call(3,momenta_59,masses2_9,G3tensor(:,60),T3sum(1:35,31))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(14)) * TI2_call(3,momenta_59,masses2_9,G3tensor(:,60),T3sum(1:35,31))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(14)) * TI2_call(3,momenta_40,masses2_9,G3tensor(:,94),T3sum(1:35,32))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(14)) * TI2_call(3,momenta_40,masses2_9,G3tensor(:,94),T3sum(1:35,32))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(14)) * TI2_call(3,momenta_49,masses2_9,G3tensor(:,86),T3sum(1:35,33))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(14)) * TI2_call(3,momenta_49,masses2_9,G3tensor(:,86),T3sum(1:35,33))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,37),T3sum(1:35,25))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,37),T3sum(1:35,25))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,42),T3sum(1:35,26))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,42),T3sum(1:35,26))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,24),T3sum(1:35,25))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,24),T3sum(1:35,25))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,29),T3sum(1:35,26))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,29),T3sum(1:35,26))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,37),T3sum(1:35,25))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,37),T3sum(1:35,25))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,52),T3sum(1:35,27))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,52),T3sum(1:35,27))
  M(2) = M(2) + (-(f(18)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,24),T3sum(1:35,25))
  M(3) = M(3) + (f(18)/6._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,24),T3sum(1:35,25))
  M(2) = M(2) + (-(f(17)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,47),T3sum(1:35,27))
  M(3) = M(3) + (f(17)/6._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,47),T3sum(1:35,27))
  M(1) = M(1) + ((3*CI*f(13))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,99),T3sum(1:35,25))
  M(2) = M(2) + ((-3*CI*f(13))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,99),T3sum(1:35,25))
  M(1) = M(1) + ((-3*CI*f(13))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,101),T3sum(1:35,25))
  M(2) = M(2) + ((3*CI*f(13))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,101),T3sum(1:35,25))
  M(1) = M(1) + ((-3*CI*f(13))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,87),T3sum(1:35,25))
  M(2) = M(2) + ((3*CI*f(13))/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,87),T3sum(1:35,25))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(88)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,40),T2sum(1:15,13))
  M(1) = M(1) + ((3*CI*f(13))/2._/**/REALKIND * den(88)) * TI2_call(2,momenta_27,masses2_6,G2tensor(:,12),T2sum(1:15,14))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(89)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,41),T2sum(1:15,21))
  M(2) = M(2) + ((3*CI*f(13))/2._/**/REALKIND * den(89)) * TI2_call(2,momenta_17,masses2_6,G2tensor(:,25),T2sum(1:15,22))
  M(3) = M(3) + (-(CI*f(13))/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_58,masses2_9,G3tensor(:,62),T3sum(1:35,34))
  M(3) = M(3) + (-(CI*f(13))/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_47,masses2_9,G3tensor(:,90),T3sum(1:35,35))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(7)) * TI2_call(3,momenta_43,masses2_9,G3tensor(:,96),T3sum(1:35,36))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_43,masses2_9,G3tensor(:,96),T3sum(1:35,36))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_50,masses2_9,G3tensor(:,88),T3sum(1:35,37))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_50,masses2_9,G3tensor(:,88),T3sum(1:35,37))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(7)) * TI2_call(3,momenta_42,masses2_9,G3tensor(:,97),T3sum(1:35,38))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_42,masses2_9,G3tensor(:,97),T3sum(1:35,38))
  M(1) = M(1) + ((3*f(14))/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_60,masses2_9,G3tensor(:,61),T3sum(1:35,39))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_60,masses2_9,G3tensor(:,61),T3sum(1:35,39))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(1)) * TI2_call(4,momenta_72,masses2_10,G4tensor(:,36),T4sum(1:70,10))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_72,masses2_10,G4tensor(:,36),T4sum(1:70,10))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(1)) * TI2_call(4,momenta_69,masses2_10,G4tensor(:,31),T4sum(1:70,11))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_69,masses2_10,G4tensor(:,31),T4sum(1:70,11))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(1)) * TI2_call(4,momenta_70,masses2_10,G4tensor(:,34),T4sum(1:70,12))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_70,masses2_10,G4tensor(:,34),T4sum(1:70,12))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(1)) * TI2_call(4,momenta_68,masses2_10,G4tensor(:,32),T4sum(1:70,13))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_68,masses2_10,G4tensor(:,32),T4sum(1:70,13))
  M(1) = M(1) + (-(f(14)/6._/**/REALKIND) * den(1)) * TI2_call(4,momenta_71,masses2_10,G4tensor(:,33),T4sum(1:70,14))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_71,masses2_10,G4tensor(:,33),T4sum(1:70,14))
  M(2) = M(2) + (-(f(14)/6._/**/REALKIND) * den(1)) * TI2_call(4,momenta_73,masses2_10,G4tensor(:,35),T4sum(1:70,15))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_73,masses2_10,G4tensor(:,35),T4sum(1:70,15))
  M(3) = M(3) + (-(CI*f(13))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_74,masses2_10,G4tensor(:,30),T4sum(1:70,16))
  M(3) = M(3) + (-(CI*f(13))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_77,masses2_10,G4tensor(:,26),T4sum(1:70,17))
  M(3) = M(3) + (-(CI*f(13))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_75,masses2_10,G4tensor(:,29),T4sum(1:70,18))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_76,masses2_10,G4tensor(:,28),T4sum(1:70,19))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_76,masses2_10,G4tensor(:,28),T4sum(1:70,19))
  M(3) = M(3) + (-(CI*f(13))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_78,masses2_10,G4tensor(:,25),T4sum(1:70,20))
  M(1) = M(1) + ((3*f(14))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_79,masses2_10,G4tensor(:,27),T4sum(1:70,21))
  M(3) = M(3) + (f(14)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_79,masses2_10,G4tensor(:,27),T4sum(1:70,21))
  M(1) = M(1) + ((-3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,33),T1sum(1:5,1))
  M(2) = M(2) + ((3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,33),T1sum(1:5,1))
  M(1) = M(1) + ((3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,34),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,34),T1sum(1:5,1))
  M(1) = M(1) + (3*CI*f(12) * den(84)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,35),T1sum(1:5,1))
  M(2) = M(2) + (-3*CI*f(12) * den(84)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,35),T1sum(1:5,1))
  M(1) = M(1) + ((-3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,36),T1sum(1:5,1))
  M(2) = M(2) + ((3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,36),T1sum(1:5,1))
  M(1) = M(1) + ((3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,37),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,37),T1sum(1:5,1))
  M(1) = M(1) + (3*CI*f(12) * den(87)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,38),T1sum(1:5,1))
  M(2) = M(2) + (-3*CI*f(12) * den(87)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,38),T1sum(1:5,1))
  M(1) = M(1) + ((3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,15),T1sum(1:5,2))
  M(2) = M(2) + ((-3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,15),T1sum(1:5,2))
  M(1) = M(1) + ((-3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,16),T1sum(1:5,2))
  M(2) = M(2) + ((3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,16),T1sum(1:5,2))
  M(1) = M(1) + (-3*CI*f(12) * den(84)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,17),T1sum(1:5,2))
  M(2) = M(2) + (3*CI*f(12) * den(84)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,17),T1sum(1:5,2))
  M(1) = M(1) + ((3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,18),T1sum(1:5,2))
  M(2) = M(2) + ((-3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,18),T1sum(1:5,2))
  M(1) = M(1) + ((-3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,19),T1sum(1:5,2))
  M(2) = M(2) + ((3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,19),T1sum(1:5,2))
  M(1) = M(1) + (-3*CI*f(12) * den(87)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,20),T1sum(1:5,2))
  M(2) = M(2) + (3*CI*f(12) * den(87)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,20),T1sum(1:5,2))
  M(1) = M(1) + ((3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,3),T2sum(1:5,25))
  M(2) = M(2) + ((-3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,3),T2sum(1:5,25))
  M(1) = M(1) + ((-3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,7),T2sum(1:5,25))
  M(2) = M(2) + ((3*CI*f(12))/2._/**/REALKIND * den(84)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,7),T2sum(1:5,25))
  M(1) = M(1) + (-3*CI*f(12) * den(84)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,11),T2sum(1:5,25))
  M(2) = M(2) + (3*CI*f(12) * den(84)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,11),T2sum(1:5,25))
  M(1) = M(1) + ((3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,4),T2sum(1:5,25))
  M(2) = M(2) + ((-3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,4),T2sum(1:5,25))
  M(1) = M(1) + ((-3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,8),T2sum(1:5,25))
  M(2) = M(2) + ((3*CI*f(12))/2._/**/REALKIND * den(87)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,8),T2sum(1:5,25))
  M(1) = M(1) + (-3*CI*f(12) * den(87)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,12),T2sum(1:5,25))
  M(2) = M(2) + (3*CI*f(12) * den(87)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,12),T2sum(1:5,25))
  M(2) = M(2) + ((4*f(14))/3._/**/REALKIND * den(58)) * TI2_call(1,momenta_4,masses2_3,G1tensor(:,13),T1sum(1:5,3))
  M(2) = M(2) + ((4*f(14))/3._/**/REALKIND * den(55)) * TI2_call(1,momenta_5,masses2_3,G1tensor(:,28),T1sum(1:5,4))
  M(2) = M(2) + ((4*f(14))/3._/**/REALKIND * den(61)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,21),T1sum(1:5,5))
  M(2) = M(2) + ((4*f(14))/3._/**/REALKIND * den(94)) * TI2_call(1,momenta_5,masses2_3,G1tensor(:,32),T1sum(1:5,4))
  M(1) = M(1) + ((4*f(14))/3._/**/REALKIND * den(68)) * TI2_call(1,momenta_3,masses2_3,G1tensor(:,26),T1sum(1:5,6))
  M(1) = M(1) + ((4*f(14))/3._/**/REALKIND * den(65)) * TI2_call(1,momenta_2,masses2_3,G1tensor(:,22),T1sum(1:5,7))
  M(1) = M(1) + ((4*f(14))/3._/**/REALKIND * den(95)) * TI2_call(1,momenta_3,masses2_3,G1tensor(:,31),T1sum(1:5,6))
  M(1) = M(1) + ((4*f(14))/3._/**/REALKIND * den(69)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,24),T1sum(1:5,8))
  M(1) = M(1) + ((4*f(14))/3._/**/REALKIND * den(74)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,25),T1sum(1:5,5))
  M(1) = M(1) + ((4*f(14))/3._/**/REALKIND * den(96)) * TI2_call(1,momenta_2,masses2_3,G1tensor(:,23),T1sum(1:5,7))
  M(2) = M(2) + ((4*f(14))/3._/**/REALKIND * den(97)) * TI2_call(1,momenta_4,masses2_3,G1tensor(:,14),T1sum(1:5,3))
  M(2) = M(2) + ((4*f(14))/3._/**/REALKIND * den(75)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,27),T1sum(1:5,8))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(98)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,42),T2sum(1:15,25))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(98)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,42),T2sum(1:15,25))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(98)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,44),T2sum(1:15,26))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(98)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,44),T2sum(1:15,26))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(98)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,42),T2sum(1:15,25))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(98)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,42),T2sum(1:15,25))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(98)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,46),T2sum(1:15,27))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(98)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,46),T2sum(1:15,27))
  M(1) = M(1) + (3*CI*f(13) * den(98)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,48),T2sum(1:15,25))
  M(2) = M(2) + (-3*CI*f(13) * den(98)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,48),T2sum(1:15,25))
  M(1) = M(1) + (-3*CI*f(12) * den(98)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,33),T2sum(1:15,25))
  M(2) = M(2) + (3*CI*f(12) * den(98)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,33),T2sum(1:15,25))
  M(1) = M(1) + ((-4*CI*f(13))/3._/**/REALKIND * den(78)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,30),T1sum(1:5,8))
  M(2) = M(2) + ((4*CI*f(13))/3._/**/REALKIND * den(78)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,30),T1sum(1:5,8))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(99)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,43),T2sum(1:15,25))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(99)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,43),T2sum(1:15,25))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(99)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,45),T2sum(1:15,26))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(99)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,45),T2sum(1:15,26))
  M(1) = M(1) + ((CI*f(16))/2._/**/REALKIND * den(99)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,43),T2sum(1:15,25))
  M(2) = M(2) + (-(CI*f(16))/2._/**/REALKIND * den(99)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,43),T2sum(1:15,25))
  M(1) = M(1) + ((CI*f(15))/2._/**/REALKIND * den(99)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,47),T2sum(1:15,27))
  M(2) = M(2) + (-(CI*f(15))/2._/**/REALKIND * den(99)) * TI2_call(2,momenta_7,masses2_1,G2tensor(:,47),T2sum(1:15,27))
  M(1) = M(1) + (3*CI*f(13) * den(99)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,49),T2sum(1:15,25))
  M(2) = M(2) + (-3*CI*f(13) * den(99)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,49),T2sum(1:15,25))
  M(1) = M(1) + (-3*CI*f(12) * den(99)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,34),T2sum(1:15,25))
  M(2) = M(2) + (3*CI*f(12) * den(99)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,34),T2sum(1:15,25))
  M(1) = M(1) + ((-4*CI*f(13))/3._/**/REALKIND * den(79)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,29),T1sum(1:5,5))
  M(2) = M(2) + ((4*CI*f(13))/3._/**/REALKIND * den(79)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,29),T1sum(1:5,5))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pplljj2_nenexddxgg_1_/**/REALKIND
