
module ol_vamp_1_pplljj2_nenexdddxdx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplljj2_nenexdddxdx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplljj2_nenexdddxdx_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pplljj2_nenexdddxdx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pplljj2_nenexdddxdx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,43) :: G0
  complex(REALKIND), dimension(4,5,4,165) :: G1
  complex(REALKIND), dimension(4,15,4,109) :: G2
  complex(REALKIND), dimension(4,35,4,20) :: G3
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G1tensorhel(5,8,64))
    allocate(G2tensorhel(15,96,64))
    allocate(G3tensorhel(35,36,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,20),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,21),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,60),ZERO,G2(:,:,:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,3),G2(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,3),G2(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),ZERO,G3tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,20),MT,G1(:,:,:,3))
  call loop_AV_Q(G1(:,:,:,3),wf(:,21),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,60),MT,G2(:,:,:,4))
  call loop_AZ_Q(G2(:,:,:,4),wf(:,3),G2(:,:,:,5),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,20),ZERO,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,21),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,60),ZERO,G2(:,:,:,6))
  call loop_QZ_A(G2(:,:,:,6),wf(:,3),G2(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,63),ZERO,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,6),wf(:,3),G2(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),ZERO,G3tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,20),MT,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,21),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,60),MT,G2(:,:,:,9))
  call loop_QZ_A(G2(:,:,:,9),wf(:,3),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,20),MB,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,21),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,60),MB,G2(:,:,:,11))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,3),G2(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,63),MB,G3tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,20),MB,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,21),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,60),MB,G2(:,:,:,13))
  call loop_QZ_A(G2(:,:,:,13),wf(:,3),G2(:,:,:,14),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MB,G3tensor(:,8))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,32),ZERO,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,2),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,52),ZERO,G2(:,:,:,15))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,6),G2tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,3),G2(:,:,:,16),gZd)
  call loop_A_Q(G2(:,:,:,16),Q(:,55),ZERO,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,-3),G3tensor(:,9))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,3),G1(:,:,:,15),gZd)
  call loop_A_Q(G1(:,:,:,15),Q(:,35),ZERO,G2(:,:,:,17))
  call check_last_AQ_V(l_switch,G2(:,:,:,17),wf(:,9),G2tensor(:,2))
  call loop_AV_Q(G2(:,:,:,17),wf(:,2),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,55),ZERO,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,-3),G3tensor(:,10))
  call check_last_AQ_V(l_switch,G2(:,:,:,17),wf(:,15),G2tensor(:,3))
  call loop_AV_Q(G2(:,:,:,17),wf(:,10),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,59),ZERO,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-2),G3tensor(:,11))
  call loop_AQ_V(G2(:,:,:,17),wf(:,-3),G2(:,:,:,20))
  call loop_VA_Q(G2(:,:,:,20),wf(:,-4),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,59),ZERO,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,-2),G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,13),wf(:,10),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,56),ZERO,G2(:,:,:,22))
  call check_last_AQ_V(l_switch,G2(:,:,:,22),wf(:,13),G2tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,3),G2(:,:,:,23),gZd)
  call loop_A_Q(G2(:,:,:,23),Q(:,59),ZERO,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,-2),G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,79),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,55),ZERO,G2(:,:,:,24))
  call check_last_AQ_V(l_switch,G2(:,:,:,24),wf(:,-3),G2tensor(:,5))
  call loop_AQ_V(G1(:,:,:,13),wf(:,-3),G1(:,:,:,18))
  call loop_VA_Q(G1(:,:,:,18),wf(:,-4),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,56),ZERO,G2(:,:,:,25))
  call check_last_AQ_V(l_switch,G2(:,:,:,25),wf(:,13),G2tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,3),G2(:,:,:,26),gZd)
  call loop_A_Q(G2(:,:,:,26),Q(:,59),ZERO,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,-2),G3tensor(:,14))
  call loop_VA_Q(G1(:,:,:,18),wf(:,38),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,59),ZERO,G2(:,:,:,27))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,-2),G2tensor(:,7))
  call loop_AV_Q(G1(:,:,:,13),wf(:,81),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,59),ZERO,G2(:,:,:,28))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,-2),G2tensor(:,8))
  call loop_AQ_V(G1(:,:,:,13),wf(:,6),G1(:,:,:,22))
  call loop_VA_Q(G1(:,:,:,22),wf(:,-4),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,59),ZERO,G2(:,:,:,29))
  call check_last_AQ_V(l_switch,G2(:,:,:,29),wf(:,-2),G2tensor(:,9))
  call loop_AV_Q(G1(:,:,:,13),wf(:,83),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,55),ZERO,G2(:,:,:,30))
  call check_last_AQ_V(l_switch,G2(:,:,:,30),wf(:,-3),G2tensor(:,10))
  call loop_AV_Q(G1(:,:,:,13),wf(:,84),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,59),ZERO,G2(:,:,:,31))
  call check_last_AQ_V(l_switch,G2(:,:,:,31),wf(:,-2),G2tensor(:,11))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,20),G1(:,:,:,26))
  call loop_VA_Q(G1(:,:,:,26),wf(:,-5),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,52),ZERO,G2(:,:,:,32))
  call check_last_AQ_V(l_switch,G2(:,:,:,32),wf(:,6),G2tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,32),wf(:,3),G2(:,:,:,33),gZd)
  call loop_A_Q(G2(:,:,:,33),Q(:,55),ZERO,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,-3),G3tensor(:,15))
  call loop_VA_Q(G1(:,:,:,26),wf(:,34),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,55),ZERO,G2(:,:,:,34))
  call check_last_AQ_V(l_switch,G2(:,:,:,34),wf(:,-3),G2tensor(:,13))
  call loop_VA_Q(G0(:,:,:,1),wf(:,34),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,35),ZERO,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,2),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,55),ZERO,G2(:,:,:,35))
  call check_last_AQ_V(l_switch,G2(:,:,:,35),wf(:,-3),G2tensor(:,14))
  call loop_AV_Q(G1(:,:,:,29),wf(:,10),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,59),ZERO,G2(:,:,:,36))
  call check_last_AQ_V(l_switch,G2(:,:,:,36),wf(:,-2),G2tensor(:,15))
  call loop_AQ_V(G1(:,:,:,29),wf(:,-3),G1(:,:,:,32))
  call loop_VA_Q(G1(:,:,:,32),wf(:,-4),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,59),ZERO,G2(:,:,:,37))
  call check_last_AQ_V(l_switch,G2(:,:,:,37),wf(:,-2),G2tensor(:,16))
  call check_last_AQ_V(l_switch,G1(:,:,:,29),wf(:,9),G1tensor(:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,29),wf(:,15),G1tensor(:,2))
  call loop_VA_Q(G0(:,:,:,1),wf(:,36),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,52),ZERO,G1(:,:,:,34))
  call loop_AZ_Q(G1(:,:,:,34),wf(:,3),G1(:,:,:,35),gZd)
  call loop_A_Q(G1(:,:,:,35),Q(:,55),ZERO,G2(:,:,:,38))
  call check_last_AQ_V(l_switch,G2(:,:,:,38),wf(:,-3),G2tensor(:,17))
  call check_last_AQ_V(l_switch,G1(:,:,:,34),wf(:,6),G1tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,24),ZERO,G1(:,:,:,36))
  call loop_QV_A(G1(:,:,:,36),wf(:,16),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,60),ZERO,G2(:,:,:,39))
  call loop_QZ_A(G2(:,:,:,39),wf(:,3),G2(:,:,:,40),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,63),ZERO,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,39),wf(:,3),G2(:,:,:,41),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,41),Q(:,63),ZERO,G3tensor(:,17))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,24),MT,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,16),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,60),MT,G2(:,:,:,42))
  call loop_QZ_A(G2(:,:,:,42),wf(:,3),G2(:,:,:,43),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,43),Q(:,63),MT,G3tensor(:,18))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,24),ZERO,G1(:,:,:,40))
  call loop_AV_Q(G1(:,:,:,40),wf(:,16),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,60),ZERO,G2(:,:,:,44))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,3),G2(:,:,:,45),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,63),ZERO,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,3),G2(:,:,:,46),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,63),ZERO,G3tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,24),MT,G1(:,:,:,42))
  call loop_AV_Q(G1(:,:,:,42),wf(:,16),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,60),MT,G2(:,:,:,47))
  call loop_AZ_Q(G2(:,:,:,47),wf(:,3),G2(:,:,:,48),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,63),MT,G3tensor(:,21))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,24),MB,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,16),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,60),MB,G2(:,:,:,49))
  call loop_QZ_A(G2(:,:,:,49),wf(:,3),G2(:,:,:,50),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,63),MB,G3tensor(:,22))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,24),MB,G1(:,:,:,46))
  call loop_AV_Q(G1(:,:,:,46),wf(:,16),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,60),MB,G2(:,:,:,51))
  call loop_AZ_Q(G2(:,:,:,51),wf(:,3),G2(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,63),MB,G3tensor(:,23))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,24),G1(:,:,:,48))
  call loop_VA_Q(G1(:,:,:,48),wf(:,-5),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,56),ZERO,G2(:,:,:,53))
  call check_last_AQ_V(l_switch,G2(:,:,:,53),wf(:,13),G2tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,53),wf(:,3),G2(:,:,:,54),gZd)
  call loop_A_Q(G2(:,:,:,54),Q(:,59),ZERO,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,-2),G3tensor(:,24))
  call loop_VA_Q(G1(:,:,:,48),wf(:,34),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,59),ZERO,G2(:,:,:,55))
  call check_last_AQ_V(l_switch,G2(:,:,:,55),wf(:,-2),G2tensor(:,19))
  call loop_VA_Q(G0(:,:,:,1),wf(:,50),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,56),ZERO,G1(:,:,:,51))
  call loop_AZ_Q(G1(:,:,:,51),wf(:,3),G1(:,:,:,52),gZd)
  call loop_A_Q(G1(:,:,:,52),Q(:,59),ZERO,G2(:,:,:,56))
  call check_last_AQ_V(l_switch,G2(:,:,:,56),wf(:,-2),G2tensor(:,20))
  call check_last_AQ_V(l_switch,G1(:,:,:,51),wf(:,13),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,16),ZERO,G1(:,:,:,53))
  call loop_AV_Q(G1(:,:,:,53),wf(:,16),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,52),ZERO,G2(:,:,:,57))
  call check_last_AQ_V(l_switch,G2(:,:,:,57),wf(:,6),G2tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,57),wf(:,3),G2(:,:,:,58),gZd)
  call loop_A_Q(G2(:,:,:,58),Q(:,55),ZERO,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,-3),G3tensor(:,25))
  call loop_AZ_Q(G1(:,:,:,53),wf(:,3),G1(:,:,:,55),gZd)
  call loop_A_Q(G1(:,:,:,55),Q(:,19),ZERO,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,16),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,55),ZERO,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,-3),G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,59),wf(:,21),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,59),ZERO,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,-2),G3tensor(:,27))
  call loop_AQ_V(G2(:,:,:,59),wf(:,-3),G2(:,:,:,62))
  call loop_VA_Q(G2(:,:,:,62),wf(:,-5),G2(:,:,:,63))
  call loop_A_Q(G2(:,:,:,63),Q(:,59),ZERO,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,-2),G3tensor(:,28))
  call loop_AV_Q(G1(:,:,:,53),wf(:,21),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,56),ZERO,G2(:,:,:,64))
  call check_last_AQ_V(l_switch,G2(:,:,:,64),wf(:,13),G2tensor(:,22))
  call loop_AZ_Q(G2(:,:,:,64),wf(:,3),G2(:,:,:,65),gZd)
  call loop_A_Q(G2(:,:,:,65),Q(:,59),ZERO,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,-2),G3tensor(:,29))
  call loop_AV_Q(G1(:,:,:,53),wf(:,80),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,55),ZERO,G2(:,:,:,66))
  call check_last_AQ_V(l_switch,G2(:,:,:,66),wf(:,-3),G2tensor(:,23))
  call loop_AQ_V(G1(:,:,:,53),wf(:,-3),G1(:,:,:,58))
  call loop_VA_Q(G1(:,:,:,58),wf(:,-5),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,56),ZERO,G2(:,:,:,67))
  call check_last_AQ_V(l_switch,G2(:,:,:,67),wf(:,13),G2tensor(:,24))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,3),G2(:,:,:,68),gZd)
  call loop_A_Q(G2(:,:,:,68),Q(:,59),ZERO,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,-2),G3tensor(:,30))
  call loop_VA_Q(G1(:,:,:,58),wf(:,34),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,59),ZERO,G2(:,:,:,69))
  call check_last_AQ_V(l_switch,G2(:,:,:,69),wf(:,-2),G2tensor(:,25))
  call loop_AV_Q(G1(:,:,:,53),wf(:,82),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,59),ZERO,G2(:,:,:,70))
  call check_last_AQ_V(l_switch,G2(:,:,:,70),wf(:,-2),G2tensor(:,26))
  call loop_AQ_V(G1(:,:,:,53),wf(:,6),G1(:,:,:,62))
  call loop_VA_Q(G1(:,:,:,62),wf(:,-5),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,59),ZERO,G2(:,:,:,71))
  call check_last_AQ_V(l_switch,G2(:,:,:,71),wf(:,-2),G2tensor(:,27))
  call loop_AV_Q(G1(:,:,:,53),wf(:,85),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,55),ZERO,G2(:,:,:,72))
  call check_last_AQ_V(l_switch,G2(:,:,:,72),wf(:,-3),G2tensor(:,28))
  call loop_AV_Q(G1(:,:,:,53),wf(:,86),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,59),ZERO,G2(:,:,:,73))
  call check_last_AQ_V(l_switch,G2(:,:,:,73),wf(:,-2),G2tensor(:,29))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,36),G1(:,:,:,66))
  call loop_VA_Q(G1(:,:,:,66),wf(:,-4),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,52),ZERO,G2(:,:,:,74))
  call check_last_AQ_V(l_switch,G2(:,:,:,74),wf(:,6),G2tensor(:,30))
  call loop_AZ_Q(G2(:,:,:,74),wf(:,3),G2(:,:,:,75),gZd)
  call loop_A_Q(G2(:,:,:,75),Q(:,55),ZERO,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,-3),G3tensor(:,31))
  call loop_VA_Q(G1(:,:,:,66),wf(:,38),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,55),ZERO,G2(:,:,:,76))
  call check_last_AQ_V(l_switch,G2(:,:,:,76),wf(:,-3),G2tensor(:,31))
  call check_last_UV_W(l_switch,G1(:,:,:,66),Q(:,36),wf(:,81),Q(:,27),G2tensor(:,32))
  call check_last_UV_W(l_switch,G1(:,:,:,66),Q(:,36),wf(:,84),Q(:,27),G2tensor(:,33))
  call loop_VA_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,19),ZERO,G1(:,:,:,69))
  call loop_AV_Q(G1(:,:,:,69),wf(:,16),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,55),ZERO,G2(:,:,:,77))
  call check_last_AQ_V(l_switch,G2(:,:,:,77),wf(:,-3),G2tensor(:,34))
  call loop_AV_Q(G1(:,:,:,69),wf(:,21),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,59),ZERO,G2(:,:,:,78))
  call check_last_AQ_V(l_switch,G2(:,:,:,78),wf(:,-2),G2tensor(:,35))
  call loop_AQ_V(G1(:,:,:,69),wf(:,-3),G1(:,:,:,72))
  call loop_VA_Q(G1(:,:,:,72),wf(:,-5),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,59),ZERO,G2(:,:,:,79))
  call check_last_AQ_V(l_switch,G2(:,:,:,79),wf(:,-2),G2tensor(:,36))
  call loop_VQ_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,44),ZERO,G1(:,:,:,74))
  call loop_QZ_A(G1(:,:,:,74),wf(:,3),G1(:,:,:,75),gZd)
  call loop_Q_A(G1(:,:,:,75),Q(:,47),ZERO,G2(:,:,:,80))
  call check_last_QA_V(l_switch,G2(:,:,:,80),wf(:,-4),G2tensor(:,37))
  call check_last_QA_V(l_switch,G1(:,:,:,74),wf(:,38),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,1),wf(:,39),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,52),ZERO,G1(:,:,:,76))
  call loop_AZ_Q(G1(:,:,:,76),wf(:,3),G1(:,:,:,77),gZd)
  call loop_A_Q(G1(:,:,:,77),Q(:,55),ZERO,G2(:,:,:,81))
  call check_last_AQ_V(l_switch,G2(:,:,:,81),wf(:,-3),G2tensor(:,38))
  call check_last_AQ_V(l_switch,G1(:,:,:,76),wf(:,6),G1tensor(:,6))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,21),Q(:,40),G1(:,:,:,78))
  call loop_VA_Q(G1(:,:,:,78),wf(:,-4),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,56),ZERO,G2(:,:,:,82))
  call check_last_AQ_V(l_switch,G2(:,:,:,82),wf(:,13),G2tensor(:,39))
  call loop_AZ_Q(G2(:,:,:,82),wf(:,3),G2(:,:,:,83),gZd)
  call loop_A_Q(G2(:,:,:,83),Q(:,59),ZERO,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,-2),G3tensor(:,32))
  call loop_VA_Q(G1(:,:,:,78),wf(:,38),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,59),ZERO,G2(:,:,:,84))
  call check_last_AQ_V(l_switch,G2(:,:,:,84),wf(:,-2),G2tensor(:,40))
  call check_last_UV_W(l_switch,G1(:,:,:,78),Q(:,40),wf(:,79),Q(:,23),G2tensor(:,41))
  call check_last_UV_W(l_switch,G1(:,:,:,78),Q(:,40),wf(:,83),Q(:,23),G2tensor(:,42))
  call loop_VQ_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,44),ZERO,G1(:,:,:,81))
  call loop_QZ_A(G1(:,:,:,81),wf(:,3),G1(:,:,:,82),gZd)
  call loop_Q_A(G1(:,:,:,82),Q(:,47),ZERO,G2(:,:,:,85))
  call check_last_QA_V(l_switch,G2(:,:,:,85),wf(:,-4),G2tensor(:,43))
  call check_last_QA_V(l_switch,G1(:,:,:,81),wf(:,38),G1tensor(:,7))
  call loop_VA_Q(G0(:,:,:,1),wf(:,52),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,56),ZERO,G1(:,:,:,83))
  call loop_AZ_Q(G1(:,:,:,83),wf(:,3),G1(:,:,:,84),gZd)
  call loop_A_Q(G1(:,:,:,84),Q(:,59),ZERO,G2(:,:,:,86))
  call check_last_AQ_V(l_switch,G2(:,:,:,86),wf(:,-2),G2tensor(:,44))
  call check_last_AQ_V(l_switch,G1(:,:,:,83),wf(:,13),G1tensor(:,8))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,79),Q(:,23),G1(:,:,:,85))
  call loop_VA_Q(G1(:,:,:,85),wf(:,-5),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,55),ZERO,G2(:,:,:,87))
  call check_last_AQ_V(l_switch,G2(:,:,:,87),wf(:,-3),G2tensor(:,45))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,80),Q(:,39),G1(:,:,:,87))
  call loop_VA_Q(G1(:,:,:,87),wf(:,-4),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,55),ZERO,G2(:,:,:,88))
  call check_last_AQ_V(l_switch,G2(:,:,:,88),wf(:,-3),G2tensor(:,46))
  call check_last_UV_W(l_switch,G1(:,:,:,87),Q(:,39),wf(:,10),Q(:,24),G2tensor(:,47))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,8),ZERO,G1(:,:,:,89))
  call loop_QA_V(G1(:,:,:,89),wf(:,-4),G1(:,:,:,90))
  call loop_VA_Q(G1(:,:,:,90),wf(:,-5),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,56),ZERO,G2(:,:,:,89))
  call check_last_AQ_V(l_switch,G2(:,:,:,89),wf(:,13),G2tensor(:,48))
  call loop_AZ_Q(G2(:,:,:,89),wf(:,3),G2(:,:,:,90),gZd)
  call loop_A_Q(G2(:,:,:,90),Q(:,59),ZERO,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,-2),G3tensor(:,33))
  call loop_VA_Q(G1(:,:,:,90),wf(:,34),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,59),ZERO,G2(:,:,:,91))
  call check_last_AQ_V(l_switch,G2(:,:,:,91),wf(:,-2),G2tensor(:,49))
  call loop_QA_V(G1(:,:,:,89),wf(:,-5),G1(:,:,:,93))
  call loop_VA_Q(G1(:,:,:,93),wf(:,-4),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,56),ZERO,G2(:,:,:,92))
  call check_last_AQ_V(l_switch,G2(:,:,:,92),wf(:,13),G2tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,92),wf(:,3),G2(:,:,:,93),gZd)
  call loop_A_Q(G2(:,:,:,93),Q(:,59),ZERO,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,-2),G3tensor(:,34))
  call loop_VA_Q(G1(:,:,:,93),wf(:,38),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,59),ZERO,G2(:,:,:,94))
  call check_last_AQ_V(l_switch,G2(:,:,:,94),wf(:,-2),G2tensor(:,51))
  call loop_QA_V(G1(:,:,:,89),wf(:,38),G1(:,:,:,96))
  call loop_VA_Q(G1(:,:,:,96),wf(:,-5),G1(:,:,:,97))
  call loop_A_Q(G1(:,:,:,97),Q(:,59),ZERO,G2(:,:,:,95))
  call check_last_AQ_V(l_switch,G2(:,:,:,95),wf(:,-2),G2tensor(:,52))
  call loop_QA_V(G1(:,:,:,89),wf(:,34),G1(:,:,:,98))
  call loop_VA_Q(G1(:,:,:,98),wf(:,-4),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,59),ZERO,G2(:,:,:,96))
  call check_last_AQ_V(l_switch,G2(:,:,:,96),wf(:,-2),G2tensor(:,53))
  call loop_QZ_A(G1(:,:,:,89),wf(:,3),G1(:,:,:,100),gZd)
  call loop_Q_A(G1(:,:,:,100),Q(:,11),ZERO,G2(:,:,:,97))
  call loop_QA_V(G2(:,:,:,97),wf(:,-5),G2(:,:,:,98))
  call loop_VA_Q(G2(:,:,:,98),wf(:,-4),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,59),ZERO,G3(:,:,:,19))
  call check_last_AQ_V(l_switch,G3(:,:,:,19),wf(:,-2),G3tensor(:,35))
  call loop_QA_V(G2(:,:,:,97),wf(:,-4),G2(:,:,:,100))
  call loop_VA_Q(G2(:,:,:,100),wf(:,-5),G2(:,:,:,101))
  call loop_A_Q(G2(:,:,:,101),Q(:,59),ZERO,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,-2),G3tensor(:,36))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,81),Q(:,27),G1(:,:,:,101))
  call loop_VA_Q(G1(:,:,:,101),wf(:,-5),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,59),ZERO,G2(:,:,:,102))
  call check_last_AQ_V(l_switch,G2(:,:,:,102),wf(:,-2),G2tensor(:,54))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,82),Q(:,43),G1(:,:,:,103))
  call loop_VA_Q(G1(:,:,:,103),wf(:,-4),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,59),ZERO,G2(:,:,:,103))
  call check_last_AQ_V(l_switch,G2(:,:,:,103),wf(:,-2),G2tensor(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,103),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,56))
  call loop_VQ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,11),ZERO,G1(:,:,:,105))
  call loop_QA_V(G1(:,:,:,105),wf(:,-5),G1(:,:,:,106))
  call loop_VA_Q(G1(:,:,:,106),wf(:,-4),G1(:,:,:,107))
  call loop_A_Q(G1(:,:,:,107),Q(:,59),ZERO,G2(:,:,:,104))
  call check_last_AQ_V(l_switch,G2(:,:,:,104),wf(:,-2),G2tensor(:,57))
  call loop_QA_V(G1(:,:,:,105),wf(:,-4),G1(:,:,:,108))
  call loop_VA_Q(G1(:,:,:,108),wf(:,-5),G1(:,:,:,109))
  call loop_A_Q(G1(:,:,:,109),Q(:,59),ZERO,G2(:,:,:,105))
  call check_last_AQ_V(l_switch,G2(:,:,:,105),wf(:,-2),G2tensor(:,58))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,83),Q(:,23),G1(:,:,:,110))
  call loop_VA_Q(G1(:,:,:,110),wf(:,-5),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,55),ZERO,G2(:,:,:,106))
  call check_last_AQ_V(l_switch,G2(:,:,:,106),wf(:,-3),G2tensor(:,59))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,84),Q(:,27),G1(:,:,:,112))
  call loop_VA_Q(G1(:,:,:,112),wf(:,-5),G1(:,:,:,113))
  call loop_A_Q(G1(:,:,:,113),Q(:,59),ZERO,G2(:,:,:,107))
  call check_last_AQ_V(l_switch,G2(:,:,:,107),wf(:,-2),G2tensor(:,60))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,85),Q(:,39),G1(:,:,:,114))
  call loop_VA_Q(G1(:,:,:,114),wf(:,-4),G1(:,:,:,115))
  call loop_A_Q(G1(:,:,:,115),Q(:,55),ZERO,G2(:,:,:,108))
  call check_last_AQ_V(l_switch,G2(:,:,:,108),wf(:,-3),G2tensor(:,61))
  call check_last_UV_W(l_switch,G1(:,:,:,114),Q(:,39),wf(:,10),Q(:,24),G2tensor(:,62))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,86),Q(:,43),G1(:,:,:,116))
  call loop_VA_Q(G1(:,:,:,116),wf(:,-4),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,59),ZERO,G2(:,:,:,109))
  call check_last_AQ_V(l_switch,G2(:,:,:,109),wf(:,-2),G2tensor(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,116),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,82),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,43),ZERO,G1(:,:,:,118))
  call loop_QV_A(G1(:,:,:,118),wf(:,2),G1(:,:,:,119))
  call check_last_Q_A(l_switch,G1(:,:,:,119),Q(:,63),ZERO,G2tensor(:,65))
  call loop_QV_A(G0(:,:,:,1),wf(:,82),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,43),MT,G1(:,:,:,120))
  call loop_QV_A(G1(:,:,:,120),wf(:,2),G1(:,:,:,121))
  call check_last_Q_A(l_switch,G1(:,:,:,121),Q(:,63),MT,G2tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,82),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,43),MB,G1(:,:,:,122))
  call loop_QV_A(G1(:,:,:,122),wf(:,2),G1(:,:,:,123))
  call check_last_Q_A(l_switch,G1(:,:,:,123),Q(:,63),MB,G2tensor(:,67))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,82),Q(:,43),G1(:,:,:,124))
  call check_last_CV_D(l_switch,G1(:,:,:,124),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,86),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,43),ZERO,G1(:,:,:,125))
  call loop_QV_A(G1(:,:,:,125),wf(:,2),G1(:,:,:,126))
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,63),ZERO,G2tensor(:,69))
  call loop_QV_A(G0(:,:,:,1),wf(:,86),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,43),MT,G1(:,:,:,127))
  call loop_QV_A(G1(:,:,:,127),wf(:,2),G1(:,:,:,128))
  call check_last_Q_A(l_switch,G1(:,:,:,128),Q(:,63),MT,G2tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,86),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,43),MB,G1(:,:,:,129))
  call loop_QV_A(G1(:,:,:,129),wf(:,2),G1(:,:,:,130))
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,63),MB,G2tensor(:,71))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,86),Q(:,43),G1(:,:,:,131))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,80),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,39),ZERO,G1(:,:,:,132))
  call loop_QV_A(G1(:,:,:,132),wf(:,10),G1(:,:,:,133))
  call check_last_Q_A(l_switch,G1(:,:,:,133),Q(:,63),ZERO,G2tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,80),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,39),MT,G1(:,:,:,134))
  call loop_QV_A(G1(:,:,:,134),wf(:,10),G1(:,:,:,135))
  call check_last_Q_A(l_switch,G1(:,:,:,135),Q(:,63),MT,G2tensor(:,74))
  call loop_QV_A(G0(:,:,:,1),wf(:,80),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,39),MB,G1(:,:,:,136))
  call loop_QV_A(G1(:,:,:,136),wf(:,10),G1(:,:,:,137))
  call check_last_Q_A(l_switch,G1(:,:,:,137),Q(:,63),MB,G2tensor(:,75))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,80),Q(:,39),G1(:,:,:,138))
  call check_last_CV_D(l_switch,G1(:,:,:,138),Q(:,39),wf(:,10),Q(:,24),G2tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,85),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,39),ZERO,G1(:,:,:,139))
  call loop_QV_A(G1(:,:,:,139),wf(:,10),G1(:,:,:,140))
  call check_last_Q_A(l_switch,G1(:,:,:,140),Q(:,63),ZERO,G2tensor(:,77))
  call loop_QV_A(G0(:,:,:,1),wf(:,85),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,39),MT,G1(:,:,:,141))
  call loop_QV_A(G1(:,:,:,141),wf(:,10),G1(:,:,:,142))
  call check_last_Q_A(l_switch,G1(:,:,:,142),Q(:,63),MT,G2tensor(:,78))
  call loop_QV_A(G0(:,:,:,1),wf(:,85),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,39),MB,G1(:,:,:,143))
  call loop_QV_A(G1(:,:,:,143),wf(:,10),G1(:,:,:,144))
  call check_last_Q_A(l_switch,G1(:,:,:,144),Q(:,63),MB,G2tensor(:,79))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,85),Q(:,39),G1(:,:,:,145))
  call check_last_CV_D(l_switch,G1(:,:,:,145),Q(:,39),wf(:,10),Q(:,24),G2tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,16),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,36),ZERO,G1(:,:,:,146))
  call loop_QV_A(G1(:,:,:,146),wf(:,81),G1(:,:,:,147))
  call check_last_Q_A(l_switch,G1(:,:,:,147),Q(:,63),ZERO,G2tensor(:,81))
  call loop_QV_A(G1(:,:,:,146),wf(:,84),G1(:,:,:,148))
  call check_last_Q_A(l_switch,G1(:,:,:,148),Q(:,63),ZERO,G2tensor(:,82))
  call loop_QV_A(G0(:,:,:,1),wf(:,16),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,36),MT,G1(:,:,:,149))
  call loop_QV_A(G1(:,:,:,149),wf(:,81),G1(:,:,:,150))
  call check_last_Q_A(l_switch,G1(:,:,:,150),Q(:,63),MT,G2tensor(:,83))
  call loop_QV_A(G1(:,:,:,149),wf(:,84),G1(:,:,:,151))
  call check_last_Q_A(l_switch,G1(:,:,:,151),Q(:,63),MT,G2tensor(:,84))
  call loop_QV_A(G0(:,:,:,1),wf(:,16),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,36),MB,G1(:,:,:,152))
  call loop_QV_A(G1(:,:,:,152),wf(:,81),G1(:,:,:,153))
  call check_last_Q_A(l_switch,G1(:,:,:,153),Q(:,63),MB,G2tensor(:,85))
  call loop_QV_A(G1(:,:,:,152),wf(:,84),G1(:,:,:,154))
  call check_last_Q_A(l_switch,G1(:,:,:,154),Q(:,63),MB,G2tensor(:,86))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,36),G1(:,:,:,155))
  call check_last_CV_D(l_switch,G1(:,:,:,155),Q(:,36),wf(:,81),Q(:,27),G2tensor(:,87))
  call check_last_CV_D(l_switch,G1(:,:,:,155),Q(:,36),wf(:,84),Q(:,27),G2tensor(:,88))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,40),ZERO,G1(:,:,:,156))
  call loop_QV_A(G1(:,:,:,156),wf(:,79),G1(:,:,:,157))
  call check_last_Q_A(l_switch,G1(:,:,:,157),Q(:,63),ZERO,G2tensor(:,89))
  call loop_QV_A(G1(:,:,:,156),wf(:,83),G1(:,:,:,158))
  call check_last_Q_A(l_switch,G1(:,:,:,158),Q(:,63),ZERO,G2tensor(:,90))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,42))
  call loop_Q_A(G0(:,:,:,42),Q(:,40),MT,G1(:,:,:,159))
  call loop_QV_A(G1(:,:,:,159),wf(:,79),G1(:,:,:,160))
  call check_last_Q_A(l_switch,G1(:,:,:,160),Q(:,63),MT,G2tensor(:,91))
  call loop_QV_A(G1(:,:,:,159),wf(:,83),G1(:,:,:,161))
  call check_last_Q_A(l_switch,G1(:,:,:,161),Q(:,63),MT,G2tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,40),MB,G1(:,:,:,162))
  call loop_QV_A(G1(:,:,:,162),wf(:,79),G1(:,:,:,163))
  call check_last_Q_A(l_switch,G1(:,:,:,163),Q(:,63),MB,G2tensor(:,93))
  call loop_QV_A(G1(:,:,:,162),wf(:,83),G1(:,:,:,164))
  call check_last_Q_A(l_switch,G1(:,:,:,164),Q(:,63),MB,G2tensor(:,94))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,21),Q(:,40),G1(:,:,:,165))
  call check_last_CV_D(l_switch,G1(:,:,:,165),Q(:,40),wf(:,79),Q(:,23),G2tensor(:,95))
  call check_last_CV_D(l_switch,G1(:,:,:,165),Q(:,40),wf(:,83),Q(:,23),G2tensor(:,96))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(78)) * TI2_call(3,momenta_17,masses2_6,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(78)) * TI2_call(3,momenta_17,masses2_6,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(78)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,3),T3sum(1:35,2))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(78)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,3),T3sum(1:35,2))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(78)) * TI2_call(3,momenta_17,masses2_6,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(78)) * TI2_call(3,momenta_17,masses2_6,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(78)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,6),T3sum(1:35,2))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(78)) * TI2_call(3,momenta_17,masses2_5,G3tensor(:,6),T3sum(1:35,2))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(78)) * TI2_call(3,momenta_17,masses2_6,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(78)) * TI2_call(3,momenta_17,masses2_6,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(78)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,7),T3sum(1:35,3))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(78)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,7),T3sum(1:35,3))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(78)) * TI2_call(3,momenta_17,masses2_6,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(78)) * TI2_call(3,momenta_17,masses2_6,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(78)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,8),T3sum(1:35,3))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(78)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,8),T3sum(1:35,3))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(5)) * TI2_call(2,momenta_24,masses2_6,G2tensor(:,1),T2sum(1:15,1))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(5)) * TI2_call(2,momenta_24,masses2_6,G2tensor(:,1),T2sum(1:15,1))
  M(1) = M(1) + ((-3*CI*f(6))/4._/**/REALKIND * den(5)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,12),T2sum(1:15,2))
  M(2) = M(2) + ((CI*f(6))/4._/**/REALKIND * den(5)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,12),T2sum(1:15,2))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(30)) * TI2_call(2,momenta_28,masses2_6,G2tensor(:,14),T2sum(1:15,3))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(30)) * TI2_call(2,momenta_28,masses2_6,G2tensor(:,14),T2sum(1:15,3))
  M(1) = M(1) + ((-3*CI*f(6))/4._/**/REALKIND * den(30)) * TI2_call(2,momenta_16,masses2_6,G2tensor(:,13),T2sum(1:15,4))
  M(2) = M(2) + ((CI*f(6))/4._/**/REALKIND * den(30)) * TI2_call(2,momenta_16,masses2_6,G2tensor(:,13),T2sum(1:15,4))
  M(1) = M(1) + ((-2*f(8))/3._/**/REALKIND * den(8)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,2),T2sum(1:15,5))
  M(2) = M(2) + ((2*f(8))/9._/**/REALKIND * den(8)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,2),T2sum(1:15,5))
  M(1) = M(1) + ((-2*f(8))/3._/**/REALKIND * den(33)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,17),T2sum(1:15,6))
  M(2) = M(2) + ((2*f(8))/9._/**/REALKIND * den(33)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,17),T2sum(1:15,6))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(24)) * TI2_call(3,momenta_62,masses2_7,G3tensor(:,9),T3sum(1:35,4))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(24)) * TI2_call(3,momenta_62,masses2_7,G3tensor(:,9),T3sum(1:35,4))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(24)) * TI2_call(3,momenta_57,masses2_7,G3tensor(:,10),T3sum(1:35,5))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(24)) * TI2_call(3,momenta_57,masses2_7,G3tensor(:,10),T3sum(1:35,5))
  M(1) = M(1) + ((-3*CI*f(6))/4._/**/REALKIND * den(24)) * TI2_call(3,momenta_55,masses2_7,G3tensor(:,15),T3sum(1:35,6))
  M(2) = M(2) + ((CI*f(6))/4._/**/REALKIND * den(24)) * TI2_call(3,momenta_55,masses2_7,G3tensor(:,15),T3sum(1:35,6))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(79)) * TI2_call(3,momenta_21,masses2_6,G3tensor(:,16),T3sum(1:35,7))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(79)) * TI2_call(3,momenta_21,masses2_6,G3tensor(:,16),T3sum(1:35,7))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(79)) * TI2_call(3,momenta_21,masses2_5,G3tensor(:,18),T3sum(1:35,8))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(79)) * TI2_call(3,momenta_21,masses2_5,G3tensor(:,18),T3sum(1:35,8))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(79)) * TI2_call(3,momenta_21,masses2_6,G3tensor(:,19),T3sum(1:35,7))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(79)) * TI2_call(3,momenta_21,masses2_6,G3tensor(:,19),T3sum(1:35,7))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(79)) * TI2_call(3,momenta_21,masses2_5,G3tensor(:,21),T3sum(1:35,8))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(79)) * TI2_call(3,momenta_21,masses2_5,G3tensor(:,21),T3sum(1:35,8))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(79)) * TI2_call(3,momenta_21,masses2_6,G3tensor(:,17),T3sum(1:35,7))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(79)) * TI2_call(3,momenta_21,masses2_6,G3tensor(:,17),T3sum(1:35,7))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(79)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,22),T3sum(1:35,9))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(79)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,22),T3sum(1:35,9))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(79)) * TI2_call(3,momenta_21,masses2_6,G3tensor(:,20),T3sum(1:35,7))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(79)) * TI2_call(3,momenta_21,masses2_6,G3tensor(:,20),T3sum(1:35,7))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(79)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,23),T3sum(1:35,9))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(79)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,23),T3sum(1:35,9))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(12)) * TI2_call(2,momenta_26,masses2_6,G2tensor(:,4),T2sum(1:15,7))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(12)) * TI2_call(2,momenta_26,masses2_6,G2tensor(:,4),T2sum(1:15,7))
  M(1) = M(1) + (-(CI*f(6))/4._/**/REALKIND * den(12)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,18),T2sum(1:15,8))
  M(2) = M(2) + ((3*CI*f(6))/4._/**/REALKIND * den(12)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,18),T2sum(1:15,8))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(39)) * TI2_call(2,momenta_29,masses2_6,G2tensor(:,15),T2sum(1:15,9))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(39)) * TI2_call(2,momenta_29,masses2_6,G2tensor(:,15),T2sum(1:15,9))
  M(1) = M(1) + (-(CI*f(6))/4._/**/REALKIND * den(39)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,19),T2sum(1:15,10))
  M(2) = M(2) + ((3*CI*f(6))/4._/**/REALKIND * den(39)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,19),T2sum(1:15,10))
  M(1) = M(1) + ((-2*f(8))/9._/**/REALKIND * den(14)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,3),T2sum(1:15,5))
  M(2) = M(2) + ((2*f(8))/3._/**/REALKIND * den(14)) * TI2_call(2,momenta_23,masses2_6,G2tensor(:,3),T2sum(1:15,5))
  M(1) = M(1) + ((-2*f(8))/9._/**/REALKIND * den(42)) * TI2_call(2,momenta_38,masses2_6,G2tensor(:,20),T2sum(1:15,11))
  M(2) = M(2) + ((2*f(8))/3._/**/REALKIND * den(42)) * TI2_call(2,momenta_38,masses2_6,G2tensor(:,20),T2sum(1:15,11))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(80)) * TI2_call(3,momenta_63,masses2_7,G3tensor(:,13),T3sum(1:35,10))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(80)) * TI2_call(3,momenta_63,masses2_7,G3tensor(:,13),T3sum(1:35,10))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(80)) * TI2_call(3,momenta_58,masses2_7,G3tensor(:,11),T3sum(1:35,11))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(80)) * TI2_call(3,momenta_58,masses2_7,G3tensor(:,11),T3sum(1:35,11))
  M(1) = M(1) + (-(CI*f(6))/4._/**/REALKIND * den(80)) * TI2_call(3,momenta_56,masses2_7,G3tensor(:,24),T3sum(1:35,12))
  M(2) = M(2) + ((3*CI*f(6))/4._/**/REALKIND * den(80)) * TI2_call(3,momenta_56,masses2_7,G3tensor(:,24),T3sum(1:35,12))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(16)) * TI2_call(2,momenta_9,masses2_6,G2tensor(:,21),T2sum(1:15,12))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(16)) * TI2_call(2,momenta_9,masses2_6,G2tensor(:,21),T2sum(1:15,12))
  M(1) = M(1) + (-(CI*f(6))/4._/**/REALKIND * den(16)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,30),T2sum(1:15,13))
  M(2) = M(2) + ((3*CI*f(6))/4._/**/REALKIND * den(16)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,30),T2sum(1:15,13))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(36)) * TI2_call(2,momenta_13,masses2_6,G2tensor(:,34),T2sum(1:15,14))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(36)) * TI2_call(2,momenta_13,masses2_6,G2tensor(:,34),T2sum(1:15,14))
  M(1) = M(1) + (-(CI*f(6))/4._/**/REALKIND * den(36)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,31),T2sum(1:15,15))
  M(2) = M(2) + ((3*CI*f(6))/4._/**/REALKIND * den(36)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,31),T2sum(1:15,15))
  M(1) = M(1) + ((-2*f(8))/9._/**/REALKIND * den(19)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,37),T2sum(1:15,16))
  M(2) = M(2) + ((2*f(8))/3._/**/REALKIND * den(19)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,37),T2sum(1:15,16))
  M(1) = M(1) + ((-2*f(8))/9._/**/REALKIND * den(38)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,38),T2sum(1:15,6))
  M(2) = M(2) + ((2*f(8))/3._/**/REALKIND * den(38)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,38),T2sum(1:15,6))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(26)) * TI2_call(3,momenta_52,masses2_7,G3tensor(:,25),T3sum(1:35,13))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(26)) * TI2_call(3,momenta_52,masses2_7,G3tensor(:,25),T3sum(1:35,13))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(26)) * TI2_call(3,momenta_47,masses2_7,G3tensor(:,26),T3sum(1:35,14))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(26)) * TI2_call(3,momenta_47,masses2_7,G3tensor(:,26),T3sum(1:35,14))
  M(1) = M(1) + (-(CI*f(6))/4._/**/REALKIND * den(26)) * TI2_call(3,momenta_65,masses2_7,G3tensor(:,31),T3sum(1:35,15))
  M(2) = M(2) + ((3*CI*f(6))/4._/**/REALKIND * den(26)) * TI2_call(3,momenta_65,masses2_7,G3tensor(:,31),T3sum(1:35,15))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(21)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,22),T2sum(1:15,17))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(21)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,22),T2sum(1:15,17))
  M(1) = M(1) + ((-3*CI*f(6))/4._/**/REALKIND * den(21)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,39),T2sum(1:15,18))
  M(2) = M(2) + ((CI*f(6))/4._/**/REALKIND * den(21)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,39),T2sum(1:15,18))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(43)) * TI2_call(2,momenta_14,masses2_6,G2tensor(:,35),T2sum(1:15,19))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(43)) * TI2_call(2,momenta_14,masses2_6,G2tensor(:,35),T2sum(1:15,19))
  M(1) = M(1) + ((-3*CI*f(6))/4._/**/REALKIND * den(43)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,40),T2sum(1:15,20))
  M(2) = M(2) + ((CI*f(6))/4._/**/REALKIND * den(43)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,40),T2sum(1:15,20))
  M(1) = M(1) + ((-2*f(8))/3._/**/REALKIND * den(23)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,43),T2sum(1:15,16))
  M(2) = M(2) + ((2*f(8))/9._/**/REALKIND * den(23)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,43),T2sum(1:15,16))
  M(1) = M(1) + ((-2*f(8))/3._/**/REALKIND * den(45)) * TI2_call(2,momenta_38,masses2_6,G2tensor(:,44),T2sum(1:15,11))
  M(2) = M(2) + ((2*f(8))/9._/**/REALKIND * den(45)) * TI2_call(2,momenta_38,masses2_6,G2tensor(:,44),T2sum(1:15,11))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(81)) * TI2_call(3,momenta_53,masses2_7,G3tensor(:,29),T3sum(1:35,16))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(81)) * TI2_call(3,momenta_53,masses2_7,G3tensor(:,29),T3sum(1:35,16))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(81)) * TI2_call(3,momenta_48,masses2_7,G3tensor(:,27),T3sum(1:35,17))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(81)) * TI2_call(3,momenta_48,masses2_7,G3tensor(:,27),T3sum(1:35,17))
  M(1) = M(1) + ((-3*CI*f(6))/4._/**/REALKIND * den(81)) * TI2_call(3,momenta_66,masses2_7,G3tensor(:,32),T3sum(1:35,18))
  M(2) = M(2) + ((CI*f(6))/4._/**/REALKIND * den(81)) * TI2_call(3,momenta_66,masses2_7,G3tensor(:,32),T3sum(1:35,18))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(67)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,5),T2sum(1:15,21))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(67)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,5),T2sum(1:15,21))
  M(1) = M(1) + ((-3*CI*f(6))/4._/**/REALKIND * den(67)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,45),T2sum(1:15,22))
  M(2) = M(2) + ((CI*f(6))/4._/**/REALKIND * den(67)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,45),T2sum(1:15,22))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(69)) * TI2_call(2,momenta_10,masses2_6,G2tensor(:,23),T2sum(1:15,23))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(69)) * TI2_call(2,momenta_10,masses2_6,G2tensor(:,23),T2sum(1:15,23))
  M(1) = M(1) + (-(CI*f(6))/4._/**/REALKIND * den(69)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,46),T2sum(1:15,24))
  M(2) = M(2) + ((3*CI*f(6))/4._/**/REALKIND * den(69)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,46),T2sum(1:15,24))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(11)) * TI2_call(2,momenta_49,masses2_7,G2tensor(:,24),T2sum(1:15,25))
  M(2) = M(2) + ((7*f(8))/12._/**/REALKIND * den(11)) * TI2_call(2,momenta_49,masses2_7,G2tensor(:,24),T2sum(1:15,25))
  M(1) = M(1) + ((-7*f(8))/12._/**/REALKIND * den(11)) * TI2_call(2,momenta_59,masses2_7,G2tensor(:,6),T2sum(1:15,26))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(11)) * TI2_call(2,momenta_59,masses2_7,G2tensor(:,6),T2sum(1:15,26))
  M(1) = M(1) + ((5*f(8))/18._/**/REALKIND * den(11)) * TI2_call(2,momenta_39,masses2_7,G2tensor(:,48),T2sum(1:15,27))
  M(2) = M(2) + (-(f(8)/6._/**/REALKIND) * den(11)) * TI2_call(2,momenta_39,masses2_7,G2tensor(:,48),T2sum(1:15,27))
  M(1) = M(1) + (f(8)/6._/**/REALKIND * den(11)) * TI2_call(2,momenta_42,masses2_7,G2tensor(:,50),T2sum(1:15,28))
  M(2) = M(2) + ((-5*f(8))/18._/**/REALKIND * den(11)) * TI2_call(2,momenta_42,masses2_7,G2tensor(:,50),T2sum(1:15,28))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(71)) * TI2_call(2,momenta_27,masses2_6,G2tensor(:,8),T2sum(1:15,29))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(71)) * TI2_call(2,momenta_27,masses2_6,G2tensor(:,8),T2sum(1:15,29))
  M(1) = M(1) + (-(CI*f(6))/4._/**/REALKIND * den(71)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,54),T2sum(1:15,30))
  M(2) = M(2) + ((3*CI*f(6))/4._/**/REALKIND * den(71)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,54),T2sum(1:15,30))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(73)) * TI2_call(2,momenta_12,masses2_6,G2tensor(:,26),T2sum(1:15,31))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(73)) * TI2_call(2,momenta_12,masses2_6,G2tensor(:,26),T2sum(1:15,31))
  M(1) = M(1) + ((-3*CI*f(6))/4._/**/REALKIND * den(73)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,55),T2sum(1:15,32))
  M(2) = M(2) + ((CI*f(6))/4._/**/REALKIND * den(73)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,55),T2sum(1:15,32))
  M(1) = M(1) + ((-7*f(8))/12._/**/REALKIND * den(4)) * TI2_call(2,momenta_61,masses2_7,G2tensor(:,9),T2sum(1:15,33))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(4)) * TI2_call(2,momenta_61,masses2_7,G2tensor(:,9),T2sum(1:15,33))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(4)) * TI2_call(2,momenta_51,masses2_7,G2tensor(:,27),T2sum(1:15,34))
  M(2) = M(2) + ((7*f(8))/12._/**/REALKIND * den(4)) * TI2_call(2,momenta_51,masses2_7,G2tensor(:,27),T2sum(1:15,34))
  M(1) = M(1) + (f(8)/6._/**/REALKIND * den(4)) * TI2_call(2,momenta_46,masses2_7,G2tensor(:,57),T2sum(1:15,35))
  M(2) = M(2) + ((-5*f(8))/18._/**/REALKIND * den(4)) * TI2_call(2,momenta_46,masses2_7,G2tensor(:,57),T2sum(1:15,35))
  M(1) = M(1) + ((5*f(8))/18._/**/REALKIND * den(4)) * TI2_call(2,momenta_45,masses2_7,G2tensor(:,58),T2sum(1:15,36))
  M(2) = M(2) + (-(f(8)/6._/**/REALKIND) * den(4)) * TI2_call(2,momenta_45,masses2_7,G2tensor(:,58),T2sum(1:15,36))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(74)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,10),T2sum(1:15,21))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(74)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,10),T2sum(1:15,21))
  M(1) = M(1) + ((-3*CI*f(6))/4._/**/REALKIND * den(74)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,59),T2sum(1:15,22))
  M(2) = M(2) + ((CI*f(6))/4._/**/REALKIND * den(74)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,59),T2sum(1:15,22))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(75)) * TI2_call(2,momenta_27,masses2_6,G2tensor(:,11),T2sum(1:15,29))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(75)) * TI2_call(2,momenta_27,masses2_6,G2tensor(:,11),T2sum(1:15,29))
  M(1) = M(1) + (-(CI*f(6))/4._/**/REALKIND * den(75)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,60),T2sum(1:15,30))
  M(2) = M(2) + ((3*CI*f(6))/4._/**/REALKIND * den(75)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,60),T2sum(1:15,30))
  M(1) = M(1) + ((5*f(8))/18._/**/REALKIND * den(35)) * TI2_call(2,momenta_41,masses2_7,G2tensor(:,52),T2sum(1:15,37))
  M(2) = M(2) + (-(f(8)/6._/**/REALKIND) * den(35)) * TI2_call(2,momenta_41,masses2_7,G2tensor(:,52),T2sum(1:15,37))
  M(1) = M(1) + (f(8)/6._/**/REALKIND * den(35)) * TI2_call(2,momenta_43,masses2_7,G2tensor(:,51),T2sum(1:15,38))
  M(2) = M(2) + ((-5*f(8))/18._/**/REALKIND * den(35)) * TI2_call(2,momenta_43,masses2_7,G2tensor(:,51),T2sum(1:15,38))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(35)) * TI2_call(2,momenta_54,masses2_7,G2tensor(:,36),T2sum(1:15,39))
  M(2) = M(2) + ((7*f(8))/12._/**/REALKIND * den(35)) * TI2_call(2,momenta_54,masses2_7,G2tensor(:,36),T2sum(1:15,39))
  M(1) = M(1) + ((-7*f(8))/12._/**/REALKIND * den(35)) * TI2_call(2,momenta_60,masses2_7,G2tensor(:,7),T2sum(1:15,40))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(35)) * TI2_call(2,momenta_60,masses2_7,G2tensor(:,7),T2sum(1:15,40))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(76)) * TI2_call(2,momenta_10,masses2_6,G2tensor(:,28),T2sum(1:15,23))
  M(2) = M(2) + (-(f(8)/12._/**/REALKIND) * den(76)) * TI2_call(2,momenta_10,masses2_6,G2tensor(:,28),T2sum(1:15,23))
  M(1) = M(1) + (-(CI*f(6))/4._/**/REALKIND * den(76)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,61),T2sum(1:15,24))
  M(2) = M(2) + ((3*CI*f(6))/4._/**/REALKIND * den(76)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,61),T2sum(1:15,24))
  M(1) = M(1) + (f(8)/12._/**/REALKIND * den(77)) * TI2_call(2,momenta_12,masses2_6,G2tensor(:,29),T2sum(1:15,31))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(77)) * TI2_call(2,momenta_12,masses2_6,G2tensor(:,29),T2sum(1:15,31))
  M(1) = M(1) + ((-3*CI*f(6))/4._/**/REALKIND * den(77)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,63),T2sum(1:15,32))
  M(2) = M(2) + ((CI*f(6))/4._/**/REALKIND * den(77)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,63),T2sum(1:15,32))
  M(1) = M(1) + (f(8)/6._/**/REALKIND * den(29)) * TI2_call(2,momenta_44,masses2_7,G2tensor(:,53),T2sum(1:15,41))
  M(2) = M(2) + ((-5*f(8))/18._/**/REALKIND * den(29)) * TI2_call(2,momenta_44,masses2_7,G2tensor(:,53),T2sum(1:15,41))
  M(1) = M(1) + ((5*f(8))/18._/**/REALKIND * den(29)) * TI2_call(2,momenta_40,masses2_7,G2tensor(:,49),T2sum(1:15,42))
  M(2) = M(2) + (-(f(8)/6._/**/REALKIND) * den(29)) * TI2_call(2,momenta_40,masses2_7,G2tensor(:,49),T2sum(1:15,42))
  M(1) = M(1) + ((-7*f(8))/12._/**/REALKIND * den(29)) * TI2_call(2,momenta_64,masses2_7,G2tensor(:,16),T2sum(1:15,43))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(29)) * TI2_call(2,momenta_64,masses2_7,G2tensor(:,16),T2sum(1:15,43))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(29)) * TI2_call(2,momenta_50,masses2_7,G2tensor(:,25),T2sum(1:15,44))
  M(2) = M(2) + ((7*f(8))/12._/**/REALKIND * den(29)) * TI2_call(2,momenta_50,masses2_7,G2tensor(:,25),T2sum(1:15,44))
  M(1) = M(1) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(3,momenta_68,masses2_8,G3tensor(:,35),T3sum(1:35,19))
  M(2) = M(2) + ((-5*f(8))/18._/**/REALKIND * den(1)) * TI2_call(3,momenta_68,masses2_8,G3tensor(:,35),T3sum(1:35,19))
  M(1) = M(1) + ((5*f(8))/18._/**/REALKIND * den(1)) * TI2_call(3,momenta_67,masses2_8,G3tensor(:,36),T3sum(1:35,20))
  M(2) = M(2) + (-(f(8)/6._/**/REALKIND) * den(1)) * TI2_call(3,momenta_67,masses2_8,G3tensor(:,36),T3sum(1:35,20))
  M(1) = M(1) + ((5*f(8))/18._/**/REALKIND * den(1)) * TI2_call(3,momenta_69,masses2_8,G3tensor(:,33),T3sum(1:35,21))
  M(2) = M(2) + (-(f(8)/6._/**/REALKIND) * den(1)) * TI2_call(3,momenta_69,masses2_8,G3tensor(:,33),T3sum(1:35,21))
  M(1) = M(1) + (f(8)/6._/**/REALKIND * den(1)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,34),T3sum(1:35,22))
  M(2) = M(2) + ((-5*f(8))/18._/**/REALKIND * den(1)) * TI2_call(3,momenta_70,masses2_8,G3tensor(:,34),T3sum(1:35,22))
  M(1) = M(1) + ((-7*f(8))/12._/**/REALKIND * den(1)) * TI2_call(3,momenta_73,masses2_8,G3tensor(:,12),T3sum(1:35,23))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(1)) * TI2_call(3,momenta_73,masses2_8,G3tensor(:,12),T3sum(1:35,23))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(1)) * TI2_call(3,momenta_71,masses2_8,G3tensor(:,28),T3sum(1:35,24))
  M(2) = M(2) + ((7*f(8))/12._/**/REALKIND * den(1)) * TI2_call(3,momenta_71,masses2_8,G3tensor(:,28),T3sum(1:35,24))
  M(1) = M(1) + (f(8)/36._/**/REALKIND * den(1)) * TI2_call(3,momenta_72,masses2_8,G3tensor(:,30),T3sum(1:35,25))
  M(2) = M(2) + ((7*f(8))/12._/**/REALKIND * den(1)) * TI2_call(3,momenta_72,masses2_8,G3tensor(:,30),T3sum(1:35,25))
  M(1) = M(1) + ((-7*f(8))/12._/**/REALKIND * den(1)) * TI2_call(3,momenta_74,masses2_8,G3tensor(:,14),T3sum(1:35,26))
  M(2) = M(2) + (-(f(8)/36._/**/REALKIND) * den(1)) * TI2_call(3,momenta_74,masses2_8,G3tensor(:,14),T3sum(1:35,26))
  M(1) = M(1) + ((-2*f(8))/3._/**/REALKIND * den(49)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,3),T1sum(1:5,1))
  M(2) = M(2) + ((2*f(8))/9._/**/REALKIND * den(49)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,3),T1sum(1:5,1))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(82)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,65),T2sum(1:15,45))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(82)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,65),T2sum(1:15,45))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(82)) * TI2_call(2,momenta_5,masses2_2,G2tensor(:,66),T2sum(1:15,46))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(82)) * TI2_call(2,momenta_5,masses2_2,G2tensor(:,66),T2sum(1:15,46))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(82)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,65),T2sum(1:15,45))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(82)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,65),T2sum(1:15,45))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(82)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,67),T2sum(1:15,47))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(82)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,67),T2sum(1:15,47))
  M(1) = M(1) + ((3*f(8))/2._/**/REALKIND * den(82)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,68),T2sum(1:15,45))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(82)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,68),T2sum(1:15,45))
  M(1) = M(1) + ((-3*f(7))/2._/**/REALKIND * den(82)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,56),T2sum(1:15,45))
  M(2) = M(2) + (f(7)/2._/**/REALKIND * den(82)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,56),T2sum(1:15,45))
  M(1) = M(1) + ((-2*f(8))/3._/**/REALKIND * den(50)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,1),T1sum(1:5,2))
  M(2) = M(2) + ((2*f(8))/9._/**/REALKIND * den(50)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,1),T1sum(1:5,2))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(83)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,69),T2sum(1:15,45))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(83)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,69),T2sum(1:15,45))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(83)) * TI2_call(2,momenta_5,masses2_2,G2tensor(:,70),T2sum(1:15,46))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(83)) * TI2_call(2,momenta_5,masses2_2,G2tensor(:,70),T2sum(1:15,46))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(83)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,69),T2sum(1:15,45))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(83)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,69),T2sum(1:15,45))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(83)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,71),T2sum(1:15,47))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(83)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,71),T2sum(1:15,47))
  M(1) = M(1) + ((3*f(8))/2._/**/REALKIND * den(83)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,72),T2sum(1:15,45))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(83)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,72),T2sum(1:15,45))
  M(1) = M(1) + ((-3*f(7))/2._/**/REALKIND * den(83)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,64),T2sum(1:15,45))
  M(2) = M(2) + (f(7)/2._/**/REALKIND * den(83)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,64),T2sum(1:15,45))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(84)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,73),T2sum(1:15,48))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(84)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,73),T2sum(1:15,48))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(84)) * TI2_call(2,momenta_3,masses2_2,G2tensor(:,74),T2sum(1:15,49))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(84)) * TI2_call(2,momenta_3,masses2_2,G2tensor(:,74),T2sum(1:15,49))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(84)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,73),T2sum(1:15,48))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(84)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,73),T2sum(1:15,48))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(84)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,75),T2sum(1:15,50))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(84)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,75),T2sum(1:15,50))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(84)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,76),T2sum(1:15,48))
  M(2) = M(2) + ((-3*f(8))/2._/**/REALKIND * den(84)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,76),T2sum(1:15,48))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(84)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,47),T2sum(1:15,48))
  M(2) = M(2) + ((3*f(7))/2._/**/REALKIND * den(84)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,47),T2sum(1:15,48))
  M(1) = M(1) + ((-2*f(8))/9._/**/REALKIND * den(53)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,4),T1sum(1:5,3))
  M(2) = M(2) + ((2*f(8))/3._/**/REALKIND * den(53)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,4),T1sum(1:5,3))
  M(1) = M(1) + ((-2*f(8))/9._/**/REALKIND * den(54)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,2),T1sum(1:5,2))
  M(2) = M(2) + ((2*f(8))/3._/**/REALKIND * den(54)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,2),T1sum(1:5,2))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(85)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,77),T2sum(1:15,48))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(85)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,77),T2sum(1:15,48))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(85)) * TI2_call(2,momenta_3,masses2_2,G2tensor(:,78),T2sum(1:15,49))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(85)) * TI2_call(2,momenta_3,masses2_2,G2tensor(:,78),T2sum(1:15,49))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(85)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,77),T2sum(1:15,48))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(85)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,77),T2sum(1:15,48))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(85)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,79),T2sum(1:15,50))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(85)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,79),T2sum(1:15,50))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(85)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,80),T2sum(1:15,48))
  M(2) = M(2) + ((-3*f(8))/2._/**/REALKIND * den(85)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,80),T2sum(1:15,48))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(85)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,62),T2sum(1:15,48))
  M(2) = M(2) + ((3*f(7))/2._/**/REALKIND * den(85)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,62),T2sum(1:15,48))
  M(1) = M(1) + ((-2*f(8))/9._/**/REALKIND * den(59)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,6),T1sum(1:5,1))
  M(2) = M(2) + ((2*f(8))/3._/**/REALKIND * den(59)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,6),T1sum(1:5,1))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(86)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,81),T2sum(1:15,51))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(86)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,81),T2sum(1:15,51))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(86)) * TI2_call(2,momenta_2,masses2_2,G2tensor(:,83),T2sum(1:15,52))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(86)) * TI2_call(2,momenta_2,masses2_2,G2tensor(:,83),T2sum(1:15,52))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(86)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,81),T2sum(1:15,51))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(86)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,81),T2sum(1:15,51))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(86)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,85),T2sum(1:15,53))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(86)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,85),T2sum(1:15,53))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(86)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,87),T2sum(1:15,51))
  M(2) = M(2) + ((-3*f(8))/2._/**/REALKIND * den(86)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,87),T2sum(1:15,51))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(86)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,32),T2sum(1:15,51))
  M(2) = M(2) + ((3*f(7))/2._/**/REALKIND * den(86)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,32),T2sum(1:15,51))
  M(1) = M(1) + ((-2*f(8))/9._/**/REALKIND * den(60)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,5),T1sum(1:5,4))
  M(2) = M(2) + ((2*f(8))/3._/**/REALKIND * den(60)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,5),T1sum(1:5,4))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(87)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,82),T2sum(1:15,51))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(87)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,82),T2sum(1:15,51))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(87)) * TI2_call(2,momenta_2,masses2_2,G2tensor(:,84),T2sum(1:15,52))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(87)) * TI2_call(2,momenta_2,masses2_2,G2tensor(:,84),T2sum(1:15,52))
  M(1) = M(1) + (f(10)/12._/**/REALKIND * den(87)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,82),T2sum(1:15,51))
  M(2) = M(2) + (-(f(10)/4._/**/REALKIND) * den(87)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,82),T2sum(1:15,51))
  M(1) = M(1) + (f(9)/12._/**/REALKIND * den(87)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,86),T2sum(1:15,53))
  M(2) = M(2) + (-(f(9)/4._/**/REALKIND) * den(87)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,86),T2sum(1:15,53))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(87)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,88),T2sum(1:15,51))
  M(2) = M(2) + ((-3*f(8))/2._/**/REALKIND * den(87)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,88),T2sum(1:15,51))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(87)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,33),T2sum(1:15,51))
  M(2) = M(2) + ((3*f(7))/2._/**/REALKIND * den(87)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,33),T2sum(1:15,51))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(88)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,89),T2sum(1:15,54))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(88)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,89),T2sum(1:15,54))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(88)) * TI2_call(2,momenta_4,masses2_2,G2tensor(:,91),T2sum(1:15,55))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(88)) * TI2_call(2,momenta_4,masses2_2,G2tensor(:,91),T2sum(1:15,55))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(88)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,89),T2sum(1:15,54))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(88)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,89),T2sum(1:15,54))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(88)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,93),T2sum(1:15,56))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(88)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,93),T2sum(1:15,56))
  M(1) = M(1) + ((3*f(8))/2._/**/REALKIND * den(88)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,95),T2sum(1:15,54))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(88)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,95),T2sum(1:15,54))
  M(1) = M(1) + ((-3*f(7))/2._/**/REALKIND * den(88)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,41),T2sum(1:15,54))
  M(2) = M(2) + (f(7)/2._/**/REALKIND * den(88)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,41),T2sum(1:15,54))
  M(1) = M(1) + ((-2*f(8))/3._/**/REALKIND * den(63)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,8),T1sum(1:5,3))
  M(2) = M(2) + ((2*f(8))/9._/**/REALKIND * den(63)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,8),T1sum(1:5,3))
  M(1) = M(1) + ((-2*f(8))/3._/**/REALKIND * den(64)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,7),T1sum(1:5,4))
  M(2) = M(2) + ((2*f(8))/9._/**/REALKIND * den(64)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,7),T1sum(1:5,4))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(89)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,90),T2sum(1:15,54))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(89)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,90),T2sum(1:15,54))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(89)) * TI2_call(2,momenta_4,masses2_2,G2tensor(:,92),T2sum(1:15,55))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(89)) * TI2_call(2,momenta_4,masses2_2,G2tensor(:,92),T2sum(1:15,55))
  M(1) = M(1) + (f(10)/4._/**/REALKIND * den(89)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,90),T2sum(1:15,54))
  M(2) = M(2) + (-(f(10)/12._/**/REALKIND) * den(89)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,90),T2sum(1:15,54))
  M(1) = M(1) + (f(9)/4._/**/REALKIND * den(89)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,94),T2sum(1:15,56))
  M(2) = M(2) + (-(f(9)/12._/**/REALKIND) * den(89)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,94),T2sum(1:15,56))
  M(1) = M(1) + ((3*f(8))/2._/**/REALKIND * den(89)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,96),T2sum(1:15,54))
  M(2) = M(2) + (-(f(8)/2._/**/REALKIND) * den(89)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,96),T2sum(1:15,54))
  M(1) = M(1) + ((-3*f(7))/2._/**/REALKIND * den(89)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,42),T2sum(1:15,54))
  M(2) = M(2) + (f(7)/2._/**/REALKIND * den(89)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,42),T2sum(1:15,54))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pplljj2_nenexdddxdx_1_/**/REALKIND
