
module ol_vamp_1_pplljj2_eexuuxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplljj2_eexuuxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplljj2_eexuuxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pplljj2_eexuuxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pplljj2_eexuuxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(3)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,84) :: G0
  complex(REALKIND), dimension(4,5,4,225) :: G1
  complex(REALKIND), dimension(4,15,4,356) :: G2
  complex(REALKIND), dimension(4,35,4,144) :: G3
  complex(REALKIND), dimension(4,70,4,24) :: G4
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G1tensorhel(5,76,64))
    allocate(G2tensorhel(15,82,64))
    allocate(G3tensorhel(35,188,64))
    allocate(G4tensorhel(70,66,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,-4),G0(:,:,:,2))
  call loop_VA_Q(G0(:,:,:,2),wf(:,-3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,56),ZERO,G1(:,:,:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,1),wf(:,23),G1tensor(:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,1),wf(:,25),G1tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,1),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,59),ZERO,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,-2),G2tensor(:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,8),G1(:,:,:,3),gZu)
  call loop_A_Q(G1(:,:,:,3),Q(:,59),ZERO,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,-2),G2tensor(:,2))
  call loop_VA_Q(G0(:,:,:,2),wf(:,12),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,59),ZERO,G1(:,:,:,4))
  call check_last_AQ_V(l_switch,G1(:,:,:,4),wf(:,-2),G1tensor(:,3))
  call loop_VA_Q(G0(:,:,:,2),wf(:,14),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,59),ZERO,G1(:,:,:,5))
  call check_last_AQ_V(l_switch,G1(:,:,:,5),wf(:,-2),G1tensor(:,4))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,48),wf(:,117),Q(:,15),G1tensor(:,5))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,48),wf(:,118),Q(:,15),G1tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,48),wf(:,127),Q(:,15),G1tensor(:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,48),wf(:,128),Q(:,15),G1tensor(:,8))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,-5),G0(:,:,:,6))
  call loop_VA_Q(G0(:,:,:,6),wf(:,-3),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,56),ZERO,G1(:,:,:,6))
  call check_last_AQ_V(l_switch,G1(:,:,:,6),wf(:,23),G1tensor(:,9))
  call check_last_AQ_V(l_switch,G1(:,:,:,6),wf(:,25),G1tensor(:,10))
  call loop_AV_Q(G1(:,:,:,6),wf(:,1),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,59),ZERO,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,-2),G2tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,6),wf(:,8),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,59),ZERO,G2(:,:,:,4))
  call check_last_AQ_V(l_switch,G2(:,:,:,4),wf(:,-2),G2tensor(:,4))
  call loop_VA_Q(G0(:,:,:,6),wf(:,12),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,59),ZERO,G1(:,:,:,9))
  call check_last_AQ_V(l_switch,G1(:,:,:,9),wf(:,-2),G1tensor(:,11))
  call loop_VA_Q(G0(:,:,:,6),wf(:,14),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,59),ZERO,G1(:,:,:,10))
  call check_last_AQ_V(l_switch,G1(:,:,:,10),wf(:,-2),G1tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,48),wf(:,117),Q(:,15),G1tensor(:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,48),wf(:,118),Q(:,15),G1tensor(:,14))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,48),wf(:,127),Q(:,15),G1tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,48),wf(:,128),Q(:,15),G1tensor(:,16))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,-4),G0(:,:,:,10))
  call loop_VA_Q(G0(:,:,:,10),wf(:,-3),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,56),ZERO,G1(:,:,:,11))
  call check_last_AQ_V(l_switch,G1(:,:,:,11),wf(:,23),G1tensor(:,17))
  call check_last_AQ_V(l_switch,G1(:,:,:,11),wf(:,25),G1tensor(:,18))
  call loop_AV_Q(G1(:,:,:,11),wf(:,1),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,59),ZERO,G2(:,:,:,5))
  call check_last_AQ_V(l_switch,G2(:,:,:,5),wf(:,-2),G2tensor(:,5))
  call loop_AZ_Q(G1(:,:,:,11),wf(:,8),G1(:,:,:,13),gZu)
  call loop_A_Q(G1(:,:,:,13),Q(:,59),ZERO,G2(:,:,:,6))
  call check_last_AQ_V(l_switch,G2(:,:,:,6),wf(:,-2),G2tensor(:,6))
  call loop_VA_Q(G0(:,:,:,10),wf(:,12),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,59),ZERO,G1(:,:,:,14))
  call check_last_AQ_V(l_switch,G1(:,:,:,14),wf(:,-2),G1tensor(:,19))
  call loop_VA_Q(G0(:,:,:,10),wf(:,14),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,59),ZERO,G1(:,:,:,15))
  call check_last_AQ_V(l_switch,G1(:,:,:,15),wf(:,-2),G1tensor(:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,48),wf(:,117),Q(:,15),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,48),wf(:,118),Q(:,15),G1tensor(:,22))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,48),wf(:,127),Q(:,15),G1tensor(:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,48),wf(:,128),Q(:,15),G1tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,32),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,12),ZERO,G1(:,:,:,16))
  call loop_AV_Q(G1(:,:,:,16),wf(:,28),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,60),ZERO,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,1),G2(:,:,:,8))
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,7),wf(:,8),G2(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,7),wf(:,8),G2(:,:,:,10),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),ZERO,G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,16),wf(:,-5),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,44),ZERO,G2(:,:,:,11))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-4),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,60),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),ZERO,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,8),G3(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,63),ZERO,G4tensor(:,2))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,8),G3(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),ZERO,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,16),wf(:,-4),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,28),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-5),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,60),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),ZERO,G4tensor(:,4))
  call loop_AZ_Q(G3(:,:,:,5),wf(:,8),G3(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,7),Q(:,63),ZERO,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,5),wf(:,8),G3(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),ZERO,G4tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,32),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,12),MT,G1(:,:,:,20))
  call loop_AV_Q(G1(:,:,:,20),wf(:,28),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,60),MT,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,1),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,8),G2(:,:,:,17),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,63),MT,G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,20),wf(:,-5),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,44),MT,G2(:,:,:,18))
  call loop_AV_Q(G2(:,:,:,18),wf(:,-4),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,60),MT,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,7))
  call loop_AZ_Q(G3(:,:,:,9),wf(:,8),G3(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,63),MT,G4tensor(:,8))
  call loop_AV_Q(G1(:,:,:,20),wf(:,-4),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,28),MT,G2(:,:,:,20))
  call loop_AV_Q(G2(:,:,:,20),wf(:,-5),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,60),MT,G3(:,:,:,12))
  call loop_AV_Q(G3(:,:,:,12),wf(:,1),G3(:,:,:,13))
  call check_last_A_Q(l_switch,G3(:,:,:,13),Q(:,63),MT,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,12),wf(:,8),G3(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,12),ZERO,G1(:,:,:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,28),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,60),ZERO,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,1),G2(:,:,:,23))
  call check_last_Q_A(l_switch,G2(:,:,:,23),Q(:,63),ZERO,G3tensor(:,6))
  call loop_QZ_A(G2(:,:,:,22),wf(:,8),G2(:,:,:,24),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,63),ZERO,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,22),wf(:,8),G2(:,:,:,25),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,63),ZERO,G3tensor(:,8))
  call loop_QV_A(G1(:,:,:,24),wf(:,-5),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,44),ZERO,G2(:,:,:,26))
  call loop_QV_A(G2(:,:,:,26),wf(:,-4),G2(:,:,:,27))
  call loop_Q_A(G2(:,:,:,27),Q(:,60),ZERO,G3(:,:,:,15))
  call loop_QV_A(G3(:,:,:,15),wf(:,1),G3(:,:,:,16))
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,63),ZERO,G4tensor(:,11))
  call loop_QZ_A(G3(:,:,:,15),wf(:,8),G3(:,:,:,17),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,17),Q(:,63),ZERO,G4tensor(:,12))
  call loop_QZ_A(G3(:,:,:,15),wf(:,8),G3(:,:,:,18),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),ZERO,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,24),wf(:,-4),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,28),ZERO,G2(:,:,:,28))
  call loop_QV_A(G2(:,:,:,28),wf(:,-5),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,60),ZERO,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,1),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),ZERO,G4tensor(:,14))
  call loop_QZ_A(G3(:,:,:,19),wf(:,8),G3(:,:,:,21),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,21),Q(:,63),ZERO,G4tensor(:,15))
  call loop_QZ_A(G3(:,:,:,19),wf(:,8),G3(:,:,:,22),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),ZERO,G4tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,12),MT,G1(:,:,:,28))
  call loop_QV_A(G1(:,:,:,28),wf(:,28),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,60),MT,G2(:,:,:,30))
  call loop_QV_A(G2(:,:,:,30),wf(:,1),G2(:,:,:,31))
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,63),MT,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,30),wf(:,8),G2(:,:,:,32),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,28),wf(:,-5),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,44),MT,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,-4),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,60),MT,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,1),G3(:,:,:,24))
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,17))
  call loop_QZ_A(G3(:,:,:,23),wf(:,8),G3(:,:,:,25),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,25),Q(:,63),MT,G4tensor(:,18))
  call loop_QV_A(G1(:,:,:,28),wf(:,-4),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,28),MT,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,-5),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,60),MT,G3(:,:,:,26))
  call loop_QV_A(G3(:,:,:,26),wf(:,1),G3(:,:,:,27))
  call check_last_Q_A(l_switch,G3(:,:,:,27),Q(:,63),MT,G4tensor(:,19))
  call loop_QZ_A(G3(:,:,:,26),wf(:,8),G3(:,:,:,28),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,63),MT,G4tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,32),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,12),MB,G1(:,:,:,32))
  call loop_AV_Q(G1(:,:,:,32),wf(:,28),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,60),MB,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,1),G2(:,:,:,38))
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,63),MB,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,8),G2(:,:,:,39),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,63),MB,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-5),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,44),MB,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-4),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,60),MB,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,1),G3(:,:,:,30))
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,63),MB,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,8),G3(:,:,:,31),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,63),MB,G4tensor(:,22))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-4),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,28),MB,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,-5),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,60),MB,G3(:,:,:,32))
  call loop_AV_Q(G3(:,:,:,32),wf(:,1),G3(:,:,:,33))
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,63),MB,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,32),wf(:,8),G3(:,:,:,34),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),MB,G4tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,12),MB,G1(:,:,:,36))
  call loop_QV_A(G1(:,:,:,36),wf(:,28),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,60),MB,G2(:,:,:,44))
  call loop_QV_A(G2(:,:,:,44),wf(:,1),G2(:,:,:,45))
  call check_last_Q_A(l_switch,G2(:,:,:,45),Q(:,63),MB,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,44),wf(:,8),G2(:,:,:,46),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,63),MB,G3tensor(:,14))
  call loop_QV_A(G1(:,:,:,36),wf(:,-5),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,44),MB,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,-4),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,60),MB,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,1),G3(:,:,:,36))
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,63),MB,G4tensor(:,25))
  call loop_QZ_A(G3(:,:,:,35),wf(:,8),G3(:,:,:,37),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,37),Q(:,63),MB,G4tensor(:,26))
  call loop_QV_A(G1(:,:,:,36),wf(:,-4),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,28),MB,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,-5),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,60),MB,G3(:,:,:,38))
  call loop_QV_A(G3(:,:,:,38),wf(:,1),G3(:,:,:,39))
  call check_last_Q_A(l_switch,G3(:,:,:,39),Q(:,63),MB,G4tensor(:,27))
  call loop_QZ_A(G3(:,:,:,38),wf(:,8),G3(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),MB,G4tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,28),ZERO,G1(:,:,:,40))
  call loop_AV_Q(G1(:,:,:,40),wf(:,-5),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,60),ZERO,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,1),G2(:,:,:,52))
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,63),ZERO,G3tensor(:,15))
  call loop_AZ_Q(G2(:,:,:,51),wf(:,8),G2(:,:,:,53),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,63),ZERO,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,51),wf(:,8),G2(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,63),ZERO,G3tensor(:,17))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,28),MT,G1(:,:,:,42))
  call loop_AV_Q(G1(:,:,:,42),wf(:,-5),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,60),MT,G2(:,:,:,55))
  call loop_AV_Q(G2(:,:,:,55),wf(:,1),G2(:,:,:,56))
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,63),MT,G3tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,8),G2(:,:,:,57),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,57),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,28),ZERO,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,-5),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,60),ZERO,G2(:,:,:,58))
  call loop_QV_A(G2(:,:,:,58),wf(:,1),G2(:,:,:,59))
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,63),ZERO,G3tensor(:,20))
  call loop_QZ_A(G2(:,:,:,58),wf(:,8),G2(:,:,:,60),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,63),ZERO,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,58),wf(:,8),G2(:,:,:,61),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,63),ZERO,G3tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,28),MT,G1(:,:,:,46))
  call loop_QV_A(G1(:,:,:,46),wf(:,-5),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,60),MT,G2(:,:,:,62))
  call loop_QV_A(G2(:,:,:,62),wf(:,1),G2(:,:,:,63))
  call check_last_Q_A(l_switch,G2(:,:,:,63),Q(:,63),MT,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,62),wf(:,8),G2(:,:,:,64),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,64),Q(:,63),MT,G3tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,28),MB,G1(:,:,:,48))
  call loop_AV_Q(G1(:,:,:,48),wf(:,-5),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,60),MB,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,1),G2(:,:,:,66))
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,63),MB,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,8),G2(:,:,:,67),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,63),MB,G3tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,28),MB,G1(:,:,:,50))
  call loop_QV_A(G1(:,:,:,50),wf(:,-5),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,60),MB,G2(:,:,:,68))
  call loop_QV_A(G2(:,:,:,68),wf(:,1),G2(:,:,:,69))
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,63),MB,G3tensor(:,27))
  call loop_QZ_A(G2(:,:,:,68),wf(:,8),G2(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,63),MB,G3tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,16),ZERO,G1(:,:,:,52))
  call loop_QV_A(G1(:,:,:,52),wf(:,40),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,60),ZERO,G2(:,:,:,71))
  call loop_QV_A(G2(:,:,:,71),wf(:,1),G2(:,:,:,72))
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,63),ZERO,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,71),wf(:,8),G2(:,:,:,73),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,63),ZERO,G3tensor(:,30))
  call loop_QZ_A(G2(:,:,:,71),wf(:,8),G2(:,:,:,74),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,63),ZERO,G3tensor(:,31))
  call loop_QV_A(G1(:,:,:,52),wf(:,32),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,28),ZERO,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,-5),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,60),ZERO,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,1),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),ZERO,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,41),wf(:,8),G3(:,:,:,43),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,43),Q(:,63),ZERO,G4tensor(:,30))
  call loop_QZ_A(G3(:,:,:,41),wf(:,8),G3(:,:,:,44),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),ZERO,G4tensor(:,31))
  call loop_QV_A(G1(:,:,:,52),wf(:,51),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,60),ZERO,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,1),G2(:,:,:,78))
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,63),ZERO,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,77),wf(:,8),G2(:,:,:,79),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,79),Q(:,63),ZERO,G3tensor(:,33))
  call loop_QZ_A(G2(:,:,:,77),wf(:,8),G2(:,:,:,80),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,63),ZERO,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,52),wf(:,53),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,60),ZERO,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,1),G2(:,:,:,82))
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,63),ZERO,G3tensor(:,35))
  call loop_QZ_A(G2(:,:,:,81),wf(:,8),G2(:,:,:,83),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,83),Q(:,63),ZERO,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,81),wf(:,8),G2(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,63),ZERO,G3tensor(:,37))
  call loop_QV_A(G1(:,:,:,52),wf(:,-5),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,48),ZERO,G2(:,:,:,85))
  call loop_QV_A(G2(:,:,:,85),wf(:,117),G2(:,:,:,86))
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,63),ZERO,G3tensor(:,38))
  call loop_QV_A(G2(:,:,:,85),wf(:,118),G2(:,:,:,87))
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,63),ZERO,G3tensor(:,39))
  call loop_QV_A(G2(:,:,:,85),wf(:,127),G2(:,:,:,88))
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,63),ZERO,G3tensor(:,40))
  call loop_QV_A(G2(:,:,:,85),wf(:,128),G2(:,:,:,89))
  call check_last_Q_A(l_switch,G2(:,:,:,89),Q(:,63),ZERO,G3tensor(:,41))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,16),MT,G1(:,:,:,58))
  call loop_QV_A(G1(:,:,:,58),wf(:,40),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,60),MT,G2(:,:,:,90))
  call loop_QV_A(G2(:,:,:,90),wf(:,1),G2(:,:,:,91))
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,63),MT,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,90),wf(:,8),G2(:,:,:,92),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,63),MT,G3tensor(:,43))
  call loop_QV_A(G1(:,:,:,58),wf(:,32),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,28),MT,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,-5),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,60),MT,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,1),G3(:,:,:,46))
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,63),MT,G4tensor(:,32))
  call loop_QZ_A(G3(:,:,:,45),wf(:,8),G3(:,:,:,47),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,47),Q(:,63),MT,G4tensor(:,33))
  call loop_QV_A(G1(:,:,:,58),wf(:,51),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,60),MT,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,1),G2(:,:,:,96))
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,63),MT,G3tensor(:,44))
  call loop_QZ_A(G2(:,:,:,95),wf(:,8),G2(:,:,:,97),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,97),Q(:,63),MT,G3tensor(:,45))
  call loop_QV_A(G1(:,:,:,58),wf(:,53),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,60),MT,G2(:,:,:,98))
  call loop_QV_A(G2(:,:,:,98),wf(:,1),G2(:,:,:,99))
  call check_last_Q_A(l_switch,G2(:,:,:,99),Q(:,63),MT,G3tensor(:,46))
  call loop_QZ_A(G2(:,:,:,98),wf(:,8),G2(:,:,:,100),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,100),Q(:,63),MT,G3tensor(:,47))
  call loop_QV_A(G1(:,:,:,58),wf(:,-5),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,48),MT,G2(:,:,:,101))
  call loop_QV_A(G2(:,:,:,101),wf(:,117),G2(:,:,:,102))
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,63),MT,G3tensor(:,48))
  call loop_QV_A(G2(:,:,:,101),wf(:,118),G2(:,:,:,103))
  call check_last_Q_A(l_switch,G2(:,:,:,103),Q(:,63),MT,G3tensor(:,49))
  call loop_QV_A(G2(:,:,:,101),wf(:,127),G2(:,:,:,104))
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,63),MT,G3tensor(:,50))
  call loop_QV_A(G2(:,:,:,101),wf(:,128),G2(:,:,:,105))
  call check_last_Q_A(l_switch,G2(:,:,:,105),Q(:,63),MT,G3tensor(:,51))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,16),ZERO,G1(:,:,:,64))
  call loop_AV_Q(G1(:,:,:,64),wf(:,40),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,60),ZERO,G2(:,:,:,106))
  call loop_AV_Q(G2(:,:,:,106),wf(:,1),G2(:,:,:,107))
  call check_last_A_Q(l_switch,G2(:,:,:,107),Q(:,63),ZERO,G3tensor(:,52))
  call loop_AZ_Q(G2(:,:,:,106),wf(:,8),G2(:,:,:,108),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,63),ZERO,G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,106),wf(:,8),G2(:,:,:,109),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,109),Q(:,63),ZERO,G3tensor(:,54))
  call loop_AV_Q(G1(:,:,:,64),wf(:,32),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,28),ZERO,G2(:,:,:,110))
  call loop_AV_Q(G2(:,:,:,110),wf(:,-5),G2(:,:,:,111))
  call loop_A_Q(G2(:,:,:,111),Q(:,60),ZERO,G3(:,:,:,48))
  call loop_AV_Q(G3(:,:,:,48),wf(:,1),G3(:,:,:,49))
  call check_last_A_Q(l_switch,G3(:,:,:,49),Q(:,63),ZERO,G4tensor(:,34))
  call loop_AZ_Q(G3(:,:,:,48),wf(:,8),G3(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,63),ZERO,G4tensor(:,35))
  call loop_AZ_Q(G3(:,:,:,48),wf(:,8),G3(:,:,:,51),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,63),ZERO,G4tensor(:,36))
  call loop_AV_Q(G1(:,:,:,64),wf(:,51),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,60),ZERO,G2(:,:,:,112))
  call loop_AV_Q(G2(:,:,:,112),wf(:,1),G2(:,:,:,113))
  call check_last_A_Q(l_switch,G2(:,:,:,113),Q(:,63),ZERO,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,112),wf(:,8),G2(:,:,:,114),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,63),ZERO,G3tensor(:,56))
  call loop_AZ_Q(G2(:,:,:,112),wf(:,8),G2(:,:,:,115),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,115),Q(:,63),ZERO,G3tensor(:,57))
  call loop_AV_Q(G1(:,:,:,64),wf(:,53),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,60),ZERO,G2(:,:,:,116))
  call loop_AV_Q(G2(:,:,:,116),wf(:,1),G2(:,:,:,117))
  call check_last_A_Q(l_switch,G2(:,:,:,117),Q(:,63),ZERO,G3tensor(:,58))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,8),G2(:,:,:,118),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,63),ZERO,G3tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,8),G2(:,:,:,119),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,119),Q(:,63),ZERO,G3tensor(:,60))
  call loop_AV_Q(G1(:,:,:,64),wf(:,-5),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,48),ZERO,G2(:,:,:,120))
  call loop_AV_Q(G2(:,:,:,120),wf(:,117),G2(:,:,:,121))
  call check_last_A_Q(l_switch,G2(:,:,:,121),Q(:,63),ZERO,G3tensor(:,61))
  call loop_AV_Q(G2(:,:,:,120),wf(:,118),G2(:,:,:,122))
  call check_last_A_Q(l_switch,G2(:,:,:,122),Q(:,63),ZERO,G3tensor(:,62))
  call loop_AV_Q(G2(:,:,:,120),wf(:,127),G2(:,:,:,123))
  call check_last_A_Q(l_switch,G2(:,:,:,123),Q(:,63),ZERO,G3tensor(:,63))
  call loop_AV_Q(G2(:,:,:,120),wf(:,128),G2(:,:,:,124))
  call check_last_A_Q(l_switch,G2(:,:,:,124),Q(:,63),ZERO,G3tensor(:,64))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,16),MT,G1(:,:,:,70))
  call loop_AV_Q(G1(:,:,:,70),wf(:,40),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,60),MT,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,1),G2(:,:,:,126))
  call check_last_A_Q(l_switch,G2(:,:,:,126),Q(:,63),MT,G3tensor(:,65))
  call loop_AZ_Q(G2(:,:,:,125),wf(:,8),G2(:,:,:,127),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,127),Q(:,63),MT,G3tensor(:,66))
  call loop_AV_Q(G1(:,:,:,70),wf(:,32),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,28),MT,G2(:,:,:,128))
  call loop_AV_Q(G2(:,:,:,128),wf(:,-5),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,60),MT,G3(:,:,:,52))
  call loop_AV_Q(G3(:,:,:,52),wf(:,1),G3(:,:,:,53))
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,63),MT,G4tensor(:,37))
  call loop_AZ_Q(G3(:,:,:,52),wf(:,8),G3(:,:,:,54),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,63),MT,G4tensor(:,38))
  call loop_AV_Q(G1(:,:,:,70),wf(:,51),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,60),MT,G2(:,:,:,130))
  call loop_AV_Q(G2(:,:,:,130),wf(:,1),G2(:,:,:,131))
  call check_last_A_Q(l_switch,G2(:,:,:,131),Q(:,63),MT,G3tensor(:,67))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,8),G2(:,:,:,132),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,63),MT,G3tensor(:,68))
  call loop_AV_Q(G1(:,:,:,70),wf(:,53),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,60),MT,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,1),G2(:,:,:,134))
  call check_last_A_Q(l_switch,G2(:,:,:,134),Q(:,63),MT,G3tensor(:,69))
  call loop_AZ_Q(G2(:,:,:,133),wf(:,8),G2(:,:,:,135),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,135),Q(:,63),MT,G3tensor(:,70))
  call loop_AV_Q(G1(:,:,:,70),wf(:,-5),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,48),MT,G2(:,:,:,136))
  call loop_AV_Q(G2(:,:,:,136),wf(:,117),G2(:,:,:,137))
  call check_last_A_Q(l_switch,G2(:,:,:,137),Q(:,63),MT,G3tensor(:,71))
  call loop_AV_Q(G2(:,:,:,136),wf(:,118),G2(:,:,:,138))
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,63),MT,G3tensor(:,72))
  call loop_AV_Q(G2(:,:,:,136),wf(:,127),G2(:,:,:,139))
  call check_last_A_Q(l_switch,G2(:,:,:,139),Q(:,63),MT,G3tensor(:,73))
  call loop_AV_Q(G2(:,:,:,136),wf(:,128),G2(:,:,:,140))
  call check_last_A_Q(l_switch,G2(:,:,:,140),Q(:,63),MT,G3tensor(:,74))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,16),MB,G1(:,:,:,76))
  call loop_QV_A(G1(:,:,:,76),wf(:,40),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,60),MB,G2(:,:,:,141))
  call loop_QV_A(G2(:,:,:,141),wf(:,1),G2(:,:,:,142))
  call check_last_Q_A(l_switch,G2(:,:,:,142),Q(:,63),MB,G3tensor(:,75))
  call loop_QZ_A(G2(:,:,:,141),wf(:,8),G2(:,:,:,143),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,63),MB,G3tensor(:,76))
  call loop_QV_A(G1(:,:,:,76),wf(:,32),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,28),MB,G2(:,:,:,144))
  call loop_QV_A(G2(:,:,:,144),wf(:,-5),G2(:,:,:,145))
  call loop_Q_A(G2(:,:,:,145),Q(:,60),MB,G3(:,:,:,55))
  call loop_QV_A(G3(:,:,:,55),wf(:,1),G3(:,:,:,56))
  call check_last_Q_A(l_switch,G3(:,:,:,56),Q(:,63),MB,G4tensor(:,39))
  call loop_QZ_A(G3(:,:,:,55),wf(:,8),G3(:,:,:,57),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,57),Q(:,63),MB,G4tensor(:,40))
  call loop_QV_A(G1(:,:,:,76),wf(:,51),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,60),MB,G2(:,:,:,146))
  call loop_QV_A(G2(:,:,:,146),wf(:,1),G2(:,:,:,147))
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,63),MB,G3tensor(:,77))
  call loop_QZ_A(G2(:,:,:,146),wf(:,8),G2(:,:,:,148),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,63),MB,G3tensor(:,78))
  call loop_QV_A(G1(:,:,:,76),wf(:,53),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,60),MB,G2(:,:,:,149))
  call loop_QV_A(G2(:,:,:,149),wf(:,1),G2(:,:,:,150))
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,63),MB,G3tensor(:,79))
  call loop_QZ_A(G2(:,:,:,149),wf(:,8),G2(:,:,:,151),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,151),Q(:,63),MB,G3tensor(:,80))
  call loop_QV_A(G1(:,:,:,76),wf(:,-5),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,48),MB,G2(:,:,:,152))
  call loop_QV_A(G2(:,:,:,152),wf(:,117),G2(:,:,:,153))
  call check_last_Q_A(l_switch,G2(:,:,:,153),Q(:,63),MB,G3tensor(:,81))
  call loop_QV_A(G2(:,:,:,152),wf(:,118),G2(:,:,:,154))
  call check_last_Q_A(l_switch,G2(:,:,:,154),Q(:,63),MB,G3tensor(:,82))
  call loop_QV_A(G2(:,:,:,152),wf(:,127),G2(:,:,:,155))
  call check_last_Q_A(l_switch,G2(:,:,:,155),Q(:,63),MB,G3tensor(:,83))
  call loop_QV_A(G2(:,:,:,152),wf(:,128),G2(:,:,:,156))
  call check_last_Q_A(l_switch,G2(:,:,:,156),Q(:,63),MB,G3tensor(:,84))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,16),MB,G1(:,:,:,82))
  call loop_AV_Q(G1(:,:,:,82),wf(:,40),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,60),MB,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,1),G2(:,:,:,158))
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,63),MB,G3tensor(:,85))
  call loop_AZ_Q(G2(:,:,:,157),wf(:,8),G2(:,:,:,159),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,159),Q(:,63),MB,G3tensor(:,86))
  call loop_AV_Q(G1(:,:,:,82),wf(:,32),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,28),MB,G2(:,:,:,160))
  call loop_AV_Q(G2(:,:,:,160),wf(:,-5),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,60),MB,G3(:,:,:,58))
  call loop_AV_Q(G3(:,:,:,58),wf(:,1),G3(:,:,:,59))
  call check_last_A_Q(l_switch,G3(:,:,:,59),Q(:,63),MB,G4tensor(:,41))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,8),G3(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,63),MB,G4tensor(:,42))
  call loop_AV_Q(G1(:,:,:,82),wf(:,51),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,60),MB,G2(:,:,:,162))
  call loop_AV_Q(G2(:,:,:,162),wf(:,1),G2(:,:,:,163))
  call check_last_A_Q(l_switch,G2(:,:,:,163),Q(:,63),MB,G3tensor(:,87))
  call loop_AZ_Q(G2(:,:,:,162),wf(:,8),G2(:,:,:,164),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,164),Q(:,63),MB,G3tensor(:,88))
  call loop_AV_Q(G1(:,:,:,82),wf(:,53),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,60),MB,G2(:,:,:,165))
  call loop_AV_Q(G2(:,:,:,165),wf(:,1),G2(:,:,:,166))
  call check_last_A_Q(l_switch,G2(:,:,:,166),Q(:,63),MB,G3tensor(:,89))
  call loop_AZ_Q(G2(:,:,:,165),wf(:,8),G2(:,:,:,167),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,167),Q(:,63),MB,G3tensor(:,90))
  call loop_AV_Q(G1(:,:,:,82),wf(:,-5),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,48),MB,G2(:,:,:,168))
  call loop_AV_Q(G2(:,:,:,168),wf(:,117),G2(:,:,:,169))
  call check_last_A_Q(l_switch,G2(:,:,:,169),Q(:,63),MB,G3tensor(:,91))
  call loop_AV_Q(G2(:,:,:,168),wf(:,118),G2(:,:,:,170))
  call check_last_A_Q(l_switch,G2(:,:,:,170),Q(:,63),MB,G3tensor(:,92))
  call loop_AV_Q(G2(:,:,:,168),wf(:,127),G2(:,:,:,171))
  call check_last_A_Q(l_switch,G2(:,:,:,171),Q(:,63),MB,G3tensor(:,93))
  call loop_AV_Q(G2(:,:,:,168),wf(:,128),G2(:,:,:,172))
  call check_last_A_Q(l_switch,G2(:,:,:,172),Q(:,63),MB,G3tensor(:,94))
  call loop_VA_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,40),ZERO,G1(:,:,:,88))
  call loop_AV_Q(G1(:,:,:,88),wf(:,1),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,43),ZERO,G2(:,:,:,173))
  call check_last_AQ_V(l_switch,G2(:,:,:,173),wf(:,4),G2tensor(:,7))
  call loop_AV_Q(G2(:,:,:,173),wf(:,-4),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,59),ZERO,G3(:,:,:,61))
  call check_last_AQ_V(l_switch,G3(:,:,:,61),wf(:,-2),G3tensor(:,95))
  call loop_AZ_Q(G1(:,:,:,88),wf(:,8),G1(:,:,:,90),gZu)
  call loop_A_Q(G1(:,:,:,90),Q(:,43),ZERO,G2(:,:,:,175))
  call check_last_AQ_V(l_switch,G2(:,:,:,175),wf(:,4),G2tensor(:,8))
  call loop_AV_Q(G2(:,:,:,175),wf(:,-4),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,59),ZERO,G3(:,:,:,62))
  call check_last_AQ_V(l_switch,G3(:,:,:,62),wf(:,-2),G3tensor(:,96))
  call loop_AV_Q(G1(:,:,:,88),wf(:,-4),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,56),ZERO,G2(:,:,:,177))
  call check_last_AQ_V(l_switch,G2(:,:,:,177),wf(:,23),G2tensor(:,9))
  call check_last_AQ_V(l_switch,G2(:,:,:,177),wf(:,25),G2tensor(:,10))
  call loop_AV_Q(G2(:,:,:,177),wf(:,1),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,59),ZERO,G3(:,:,:,63))
  call check_last_AQ_V(l_switch,G3(:,:,:,63),wf(:,-2),G3tensor(:,97))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,8),G2(:,:,:,179),gZu)
  call loop_A_Q(G2(:,:,:,179),Q(:,59),ZERO,G3(:,:,:,64))
  call check_last_AQ_V(l_switch,G3(:,:,:,64),wf(:,-2),G3tensor(:,98))
  call check_last_AQ_V(l_switch,G1(:,:,:,88),wf(:,91),G1tensor(:,25))
  call check_last_AQ_V(l_switch,G1(:,:,:,88),wf(:,92),G1tensor(:,26))
  call check_last_AQ_V(l_switch,G1(:,:,:,88),wf(:,120),G1tensor(:,27))
  call check_last_AQ_V(l_switch,G1(:,:,:,88),wf(:,122),G1tensor(:,28))
  call loop_VQ_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,20),ZERO,G1(:,:,:,92))
  call loop_QV_A(G1(:,:,:,92),wf(:,-5),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,52),ZERO,G2(:,:,:,180))
  call check_last_QA_V(l_switch,G2(:,:,:,180),wf(:,12),G2tensor(:,11))
  call check_last_QA_V(l_switch,G2(:,:,:,180),wf(:,14),G2tensor(:,12))
  call loop_QV_A(G2(:,:,:,180),wf(:,1),G2(:,:,:,181))
  call loop_Q_A(G2(:,:,:,181),Q(:,55),ZERO,G3(:,:,:,65))
  call check_last_QA_V(l_switch,G3(:,:,:,65),wf(:,-3),G3tensor(:,99))
  call loop_QZ_A(G2(:,:,:,180),wf(:,8),G2(:,:,:,182),gZu)
  call loop_Q_A(G2(:,:,:,182),Q(:,55),ZERO,G3(:,:,:,66))
  call check_last_QA_V(l_switch,G3(:,:,:,66),wf(:,-3),G3tensor(:,100))
  call loop_QV_A(G1(:,:,:,92),wf(:,1),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,23),ZERO,G2(:,:,:,183))
  call loop_QV_A(G2(:,:,:,183),wf(:,-5),G2(:,:,:,184))
  call loop_Q_A(G2(:,:,:,184),Q(:,55),ZERO,G3(:,:,:,67))
  call check_last_QA_V(l_switch,G3(:,:,:,67),wf(:,-3),G3tensor(:,101))
  call loop_QZ_A(G1(:,:,:,92),wf(:,8),G1(:,:,:,95),gZu)
  call loop_Q_A(G1(:,:,:,95),Q(:,23),ZERO,G2(:,:,:,185))
  call loop_QV_A(G2(:,:,:,185),wf(:,-5),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,55),ZERO,G3(:,:,:,68))
  call check_last_QA_V(l_switch,G3(:,:,:,68),wf(:,-3),G3tensor(:,102))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-5),Q(:,32),G1(:,:,:,96))
  call loop_VQ_A(G1(:,:,:,96),wf(:,4),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,52),ZERO,G2(:,:,:,187))
  call check_last_QA_V(l_switch,G2(:,:,:,187),wf(:,12),G2tensor(:,13))
  call check_last_QA_V(l_switch,G2(:,:,:,187),wf(:,14),G2tensor(:,14))
  call loop_QV_A(G2(:,:,:,187),wf(:,1),G2(:,:,:,188))
  call loop_Q_A(G2(:,:,:,188),Q(:,55),ZERO,G3(:,:,:,69))
  call check_last_QA_V(l_switch,G3(:,:,:,69),wf(:,-3),G3tensor(:,103))
  call loop_QZ_A(G2(:,:,:,187),wf(:,8),G2(:,:,:,189),gZu)
  call loop_Q_A(G2(:,:,:,189),Q(:,55),ZERO,G3(:,:,:,70))
  call check_last_QA_V(l_switch,G3(:,:,:,70),wf(:,-3),G3tensor(:,104))
  call loop_VQ_A(G1(:,:,:,96),wf(:,91),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,55),ZERO,G2(:,:,:,190))
  call check_last_QA_V(l_switch,G2(:,:,:,190),wf(:,-3),G2tensor(:,15))
  call loop_VQ_A(G1(:,:,:,96),wf(:,92),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,55),ZERO,G2(:,:,:,191))
  call check_last_QA_V(l_switch,G2(:,:,:,191),wf(:,-3),G2tensor(:,16))
  call loop_VA_Q(G1(:,:,:,96),wf(:,18),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,56),ZERO,G2(:,:,:,192))
  call check_last_AQ_V(l_switch,G2(:,:,:,192),wf(:,23),G2tensor(:,17))
  call check_last_AQ_V(l_switch,G2(:,:,:,192),wf(:,25),G2tensor(:,18))
  call loop_AV_Q(G2(:,:,:,192),wf(:,1),G2(:,:,:,193))
  call loop_A_Q(G2(:,:,:,193),Q(:,59),ZERO,G3(:,:,:,71))
  call check_last_AQ_V(l_switch,G3(:,:,:,71),wf(:,-2),G3tensor(:,105))
  call loop_AZ_Q(G2(:,:,:,192),wf(:,8),G2(:,:,:,194),gZu)
  call loop_A_Q(G2(:,:,:,194),Q(:,59),ZERO,G3(:,:,:,72))
  call check_last_AQ_V(l_switch,G3(:,:,:,72),wf(:,-2),G3tensor(:,106))
  call loop_VA_Q(G1(:,:,:,96),wf(:,99),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,59),ZERO,G2(:,:,:,195))
  call check_last_AQ_V(l_switch,G2(:,:,:,195),wf(:,-2),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,96),wf(:,101),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,59),ZERO,G2(:,:,:,196))
  call check_last_AQ_V(l_switch,G2(:,:,:,196),wf(:,-2),G2tensor(:,20))
  call loop_VQ_A(G1(:,:,:,96),wf(:,120),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,55),ZERO,G2(:,:,:,197))
  call check_last_QA_V(l_switch,G2(:,:,:,197),wf(:,-3),G2tensor(:,21))
  call loop_VQ_A(G1(:,:,:,96),wf(:,122),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,55),ZERO,G2(:,:,:,198))
  call check_last_QA_V(l_switch,G2(:,:,:,198),wf(:,-3),G2tensor(:,22))
  call loop_VA_Q(G1(:,:,:,96),wf(:,-3),G1(:,:,:,105))
  call loop_A_Q(G1(:,:,:,105),Q(:,40),ZERO,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,-4),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,56),ZERO,G3(:,:,:,73))
  call check_last_AQ_V(l_switch,G3(:,:,:,73),wf(:,23),G3tensor(:,107))
  call check_last_AQ_V(l_switch,G3(:,:,:,73),wf(:,25),G3tensor(:,108))
  call loop_AV_Q(G3(:,:,:,73),wf(:,1),G3(:,:,:,74))
  call loop_A_Q(G3(:,:,:,74),Q(:,59),ZERO,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,-2),G4tensor(:,43))
  call loop_AZ_Q(G3(:,:,:,73),wf(:,8),G3(:,:,:,75),gZu)
  call loop_A_Q(G3(:,:,:,75),Q(:,59),ZERO,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,-2),G4tensor(:,44))
  call loop_AV_Q(G2(:,:,:,199),wf(:,1),G2(:,:,:,201))
  call loop_A_Q(G2(:,:,:,201),Q(:,43),ZERO,G3(:,:,:,76))
  call loop_AV_Q(G3(:,:,:,76),wf(:,-4),G3(:,:,:,77))
  call loop_A_Q(G3(:,:,:,77),Q(:,59),ZERO,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,-2),G4tensor(:,45))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,8),G2(:,:,:,202),gZu)
  call loop_A_Q(G2(:,:,:,202),Q(:,43),ZERO,G3(:,:,:,78))
  call loop_AV_Q(G3(:,:,:,78),wf(:,-4),G3(:,:,:,79))
  call loop_A_Q(G3(:,:,:,79),Q(:,59),ZERO,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,-2),G4tensor(:,46))
  call loop_UV_W(G1(:,:,:,96),Q(:,32),wf(:,-4),Q(:,16),G2(:,:,:,203))
  call loop_VA_Q(G2(:,:,:,203),wf(:,-3),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,56),ZERO,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,23),G3tensor(:,109))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,25),G3tensor(:,110))
  call loop_AV_Q(G3(:,:,:,80),wf(:,1),G3(:,:,:,81))
  call loop_A_Q(G3(:,:,:,81),Q(:,59),ZERO,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,-2),G4tensor(:,47))
  call loop_AZ_Q(G3(:,:,:,80),wf(:,8),G3(:,:,:,82),gZu)
  call loop_A_Q(G3(:,:,:,82),Q(:,59),ZERO,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,-2),G4tensor(:,48))
  call loop_VA_Q(G2(:,:,:,203),wf(:,12),G2(:,:,:,205))
  call loop_A_Q(G2(:,:,:,205),Q(:,59),ZERO,G3(:,:,:,83))
  call check_last_AQ_V(l_switch,G3(:,:,:,83),wf(:,-2),G3tensor(:,111))
  call loop_VA_Q(G2(:,:,:,203),wf(:,14),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,59),ZERO,G3(:,:,:,84))
  call check_last_AQ_V(l_switch,G3(:,:,:,84),wf(:,-2),G3tensor(:,112))
  call loop_VA_Q(G1(:,:,:,96),wf(:,130),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,59),ZERO,G2(:,:,:,207))
  call check_last_AQ_V(l_switch,G2(:,:,:,207),wf(:,-2),G2tensor(:,23))
  call loop_VA_Q(G1(:,:,:,96),wf(:,132),G1(:,:,:,107))
  call loop_A_Q(G1(:,:,:,107),Q(:,59),ZERO,G2(:,:,:,208))
  call check_last_AQ_V(l_switch,G2(:,:,:,208),wf(:,-2),G2tensor(:,24))
  call loop_VA_Q(G1(:,:,:,96),wf(:,12),G1(:,:,:,108))
  call loop_A_Q(G1(:,:,:,108),Q(:,43),ZERO,G2(:,:,:,209))
  call loop_AV_Q(G2(:,:,:,209),wf(:,-4),G2(:,:,:,210))
  call loop_A_Q(G2(:,:,:,210),Q(:,59),ZERO,G3(:,:,:,85))
  call check_last_AQ_V(l_switch,G3(:,:,:,85),wf(:,-2),G3tensor(:,113))
  call loop_VA_Q(G1(:,:,:,96),wf(:,14),G1(:,:,:,109))
  call loop_A_Q(G1(:,:,:,109),Q(:,43),ZERO,G2(:,:,:,211))
  call loop_AV_Q(G2(:,:,:,211),wf(:,-4),G2(:,:,:,212))
  call loop_A_Q(G2(:,:,:,212),Q(:,59),ZERO,G3(:,:,:,86))
  call check_last_AQ_V(l_switch,G3(:,:,:,86),wf(:,-2),G3tensor(:,114))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,96),wf(:,-4),wf(:,117),G1tensor(:,29))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,96),wf(:,117),wf(:,-4),G1tensor(:,30))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,96),wf(:,-4),wf(:,117),G1tensor(:,31))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,96),wf(:,-4),wf(:,118),G1tensor(:,32))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,96),wf(:,118),wf(:,-4),G1tensor(:,33))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,96),wf(:,-4),wf(:,118),G1tensor(:,34))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,96),wf(:,-4),wf(:,127),G1tensor(:,35))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,96),wf(:,127),wf(:,-4),G1tensor(:,36))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,96),wf(:,-4),wf(:,127),G1tensor(:,37))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,96),wf(:,-4),wf(:,128),G1tensor(:,38))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,96),wf(:,128),wf(:,-4),G1tensor(:,39))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,96),wf(:,-4),wf(:,128),G1tensor(:,40))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,28),ZERO,G1(:,:,:,110))
  call loop_AV_Q(G1(:,:,:,110),wf(:,-5),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,60),ZERO,G2(:,:,:,213))
  call loop_AV_Q(G2(:,:,:,213),wf(:,1),G2(:,:,:,214))
  call check_last_A_Q(l_switch,G2(:,:,:,214),Q(:,63),ZERO,G3tensor(:,115))
  call loop_AZ_Q(G2(:,:,:,213),wf(:,8),G2(:,:,:,215),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,215),Q(:,63),ZERO,G3tensor(:,116))
  call loop_AZ_Q(G2(:,:,:,213),wf(:,8),G2(:,:,:,216),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,216),Q(:,63),ZERO,G3tensor(:,117))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,28),MT,G1(:,:,:,112))
  call loop_AV_Q(G1(:,:,:,112),wf(:,-5),G1(:,:,:,113))
  call loop_A_Q(G1(:,:,:,113),Q(:,60),MT,G2(:,:,:,217))
  call loop_AV_Q(G2(:,:,:,217),wf(:,1),G2(:,:,:,218))
  call check_last_A_Q(l_switch,G2(:,:,:,218),Q(:,63),MT,G3tensor(:,118))
  call loop_AZ_Q(G2(:,:,:,217),wf(:,8),G2(:,:,:,219),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,219),Q(:,63),MT,G3tensor(:,119))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,28),ZERO,G1(:,:,:,114))
  call loop_QV_A(G1(:,:,:,114),wf(:,-5),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,60),ZERO,G2(:,:,:,220))
  call loop_QV_A(G2(:,:,:,220),wf(:,1),G2(:,:,:,221))
  call check_last_Q_A(l_switch,G2(:,:,:,221),Q(:,63),ZERO,G3tensor(:,120))
  call loop_QZ_A(G2(:,:,:,220),wf(:,8),G2(:,:,:,222),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,222),Q(:,63),ZERO,G3tensor(:,121))
  call loop_QZ_A(G2(:,:,:,220),wf(:,8),G2(:,:,:,223),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,223),Q(:,63),ZERO,G3tensor(:,122))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,28),MT,G1(:,:,:,116))
  call loop_QV_A(G1(:,:,:,116),wf(:,-5),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,60),MT,G2(:,:,:,224))
  call loop_QV_A(G2(:,:,:,224),wf(:,1),G2(:,:,:,225))
  call check_last_Q_A(l_switch,G2(:,:,:,225),Q(:,63),MT,G3tensor(:,123))
  call loop_QZ_A(G2(:,:,:,224),wf(:,8),G2(:,:,:,226),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,226),Q(:,63),MT,G3tensor(:,124))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,28),MB,G1(:,:,:,118))
  call loop_AV_Q(G1(:,:,:,118),wf(:,-5),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,60),MB,G2(:,:,:,227))
  call loop_AV_Q(G2(:,:,:,227),wf(:,1),G2(:,:,:,228))
  call check_last_A_Q(l_switch,G2(:,:,:,228),Q(:,63),MB,G3tensor(:,125))
  call loop_AZ_Q(G2(:,:,:,227),wf(:,8),G2(:,:,:,229),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,229),Q(:,63),MB,G3tensor(:,126))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,28),MB,G1(:,:,:,120))
  call loop_QV_A(G1(:,:,:,120),wf(:,-5),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,60),MB,G2(:,:,:,230))
  call loop_QV_A(G2(:,:,:,230),wf(:,1),G2(:,:,:,231))
  call check_last_Q_A(l_switch,G2(:,:,:,231),Q(:,63),MB,G3tensor(:,127))
  call loop_QZ_A(G2(:,:,:,230),wf(:,8),G2(:,:,:,232),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,232),Q(:,63),MB,G3tensor(:,128))
  call loop_VQ_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,52),ZERO,G1(:,:,:,122))
  call loop_QV_A(G1(:,:,:,122),wf(:,1),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,55),ZERO,G2(:,:,:,233))
  call check_last_QA_V(l_switch,G2(:,:,:,233),wf(:,-3),G2tensor(:,25))
  call loop_QZ_A(G1(:,:,:,122),wf(:,8),G1(:,:,:,124),gZu)
  call loop_Q_A(G1(:,:,:,124),Q(:,55),ZERO,G2(:,:,:,234))
  call check_last_QA_V(l_switch,G2(:,:,:,234),wf(:,-3),G2tensor(:,26))
  call check_last_QA_V(l_switch,G1(:,:,:,122),wf(:,12),G1tensor(:,41))
  call check_last_QA_V(l_switch,G1(:,:,:,122),wf(:,14),G1tensor(:,42))
  call loop_VQ_A(G0(:,:,:,1),wf(:,91),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,23),ZERO,G1(:,:,:,125))
  call loop_QV_A(G1(:,:,:,125),wf(:,-5),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,55),ZERO,G2(:,:,:,235))
  call check_last_QA_V(l_switch,G2(:,:,:,235),wf(:,-3),G2tensor(:,27))
  call loop_VQ_A(G0(:,:,:,1),wf(:,92),G0(:,:,:,42))
  call loop_Q_A(G0(:,:,:,42),Q(:,23),ZERO,G1(:,:,:,127))
  call loop_QV_A(G1(:,:,:,127),wf(:,-5),G1(:,:,:,128))
  call loop_Q_A(G1(:,:,:,128),Q(:,55),ZERO,G2(:,:,:,236))
  call check_last_QA_V(l_switch,G2(:,:,:,236),wf(:,-3),G2tensor(:,28))
  call loop_VQ_A(G0(:,:,:,1),wf(:,17),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,36),ZERO,G1(:,:,:,129))
  call loop_QV_A(G1(:,:,:,129),wf(:,1),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,39),ZERO,G2(:,:,:,237))
  call check_last_QA_V(l_switch,G2(:,:,:,237),wf(:,18),G2tensor(:,29))
  call loop_QV_A(G2(:,:,:,237),wf(:,-4),G2(:,:,:,238))
  call loop_Q_A(G2(:,:,:,238),Q(:,55),ZERO,G3(:,:,:,87))
  call check_last_QA_V(l_switch,G3(:,:,:,87),wf(:,-3),G3tensor(:,129))
  call loop_QZ_A(G1(:,:,:,129),wf(:,8),G1(:,:,:,131),gZu)
  call loop_Q_A(G1(:,:,:,131),Q(:,39),ZERO,G2(:,:,:,239))
  call check_last_QA_V(l_switch,G2(:,:,:,239),wf(:,18),G2tensor(:,30))
  call loop_QV_A(G2(:,:,:,239),wf(:,-4),G2(:,:,:,240))
  call loop_Q_A(G2(:,:,:,240),Q(:,55),ZERO,G3(:,:,:,88))
  call check_last_QA_V(l_switch,G3(:,:,:,88),wf(:,-3),G3tensor(:,130))
  call loop_QV_A(G1(:,:,:,129),wf(:,-4),G1(:,:,:,132))
  call loop_Q_A(G1(:,:,:,132),Q(:,52),ZERO,G2(:,:,:,241))
  call check_last_QA_V(l_switch,G2(:,:,:,241),wf(:,12),G2tensor(:,31))
  call check_last_QA_V(l_switch,G2(:,:,:,241),wf(:,14),G2tensor(:,32))
  call loop_QV_A(G2(:,:,:,241),wf(:,1),G2(:,:,:,242))
  call loop_Q_A(G2(:,:,:,242),Q(:,55),ZERO,G3(:,:,:,89))
  call check_last_QA_V(l_switch,G3(:,:,:,89),wf(:,-3),G3tensor(:,131))
  call loop_QZ_A(G2(:,:,:,241),wf(:,8),G2(:,:,:,243),gZu)
  call loop_Q_A(G2(:,:,:,243),Q(:,55),ZERO,G3(:,:,:,90))
  call check_last_QA_V(l_switch,G3(:,:,:,90),wf(:,-3),G3tensor(:,132))
  call check_last_QA_V(l_switch,G1(:,:,:,129),wf(:,99),G1tensor(:,43))
  call check_last_QA_V(l_switch,G1(:,:,:,129),wf(:,101),G1tensor(:,44))
  call check_last_QA_V(l_switch,G1(:,:,:,129),wf(:,130),G1tensor(:,45))
  call check_last_QA_V(l_switch,G1(:,:,:,129),wf(:,132),G1tensor(:,46))
  call loop_VA_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,44))
  call loop_A_Q(G0(:,:,:,44),Q(:,24),ZERO,G1(:,:,:,133))
  call loop_AV_Q(G1(:,:,:,133),wf(:,-5),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,56),ZERO,G2(:,:,:,244))
  call check_last_AQ_V(l_switch,G2(:,:,:,244),wf(:,23),G2tensor(:,33))
  call check_last_AQ_V(l_switch,G2(:,:,:,244),wf(:,25),G2tensor(:,34))
  call loop_AV_Q(G2(:,:,:,244),wf(:,1),G2(:,:,:,245))
  call loop_A_Q(G2(:,:,:,245),Q(:,59),ZERO,G3(:,:,:,91))
  call check_last_AQ_V(l_switch,G3(:,:,:,91),wf(:,-2),G3tensor(:,133))
  call loop_AZ_Q(G2(:,:,:,244),wf(:,8),G2(:,:,:,246),gZu)
  call loop_A_Q(G2(:,:,:,246),Q(:,59),ZERO,G3(:,:,:,92))
  call check_last_AQ_V(l_switch,G3(:,:,:,92),wf(:,-2),G3tensor(:,134))
  call loop_AV_Q(G1(:,:,:,133),wf(:,1),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,27),ZERO,G2(:,:,:,247))
  call loop_AV_Q(G2(:,:,:,247),wf(:,-5),G2(:,:,:,248))
  call loop_A_Q(G2(:,:,:,248),Q(:,59),ZERO,G3(:,:,:,93))
  call check_last_AQ_V(l_switch,G3(:,:,:,93),wf(:,-2),G3tensor(:,135))
  call loop_AZ_Q(G1(:,:,:,133),wf(:,8),G1(:,:,:,136),gZu)
  call loop_A_Q(G1(:,:,:,136),Q(:,27),ZERO,G2(:,:,:,249))
  call loop_AV_Q(G2(:,:,:,249),wf(:,-5),G2(:,:,:,250))
  call loop_A_Q(G2(:,:,:,250),Q(:,59),ZERO,G3(:,:,:,94))
  call check_last_AQ_V(l_switch,G3(:,:,:,94),wf(:,-2),G3tensor(:,136))
  call loop_AV_Q(G0(:,:,:,1),wf(:,49),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,28),ZERO,G1(:,:,:,137))
  call loop_AV_Q(G1(:,:,:,137),wf(:,-5),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,60),ZERO,G2(:,:,:,251))
  call loop_AV_Q(G2(:,:,:,251),wf(:,1),G2(:,:,:,252))
  call check_last_A_Q(l_switch,G2(:,:,:,252),Q(:,63),ZERO,G3tensor(:,137))
  call loop_AZ_Q(G2(:,:,:,251),wf(:,8),G2(:,:,:,253),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,253),Q(:,63),ZERO,G3tensor(:,138))
  call loop_AZ_Q(G2(:,:,:,251),wf(:,8),G2(:,:,:,254),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,254),Q(:,63),ZERO,G3tensor(:,139))
  call loop_AV_Q(G0(:,:,:,1),wf(:,49),G0(:,:,:,46))
  call loop_A_Q(G0(:,:,:,46),Q(:,28),MT,G1(:,:,:,139))
  call loop_AV_Q(G1(:,:,:,139),wf(:,-5),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,60),MT,G2(:,:,:,255))
  call loop_AV_Q(G2(:,:,:,255),wf(:,1),G2(:,:,:,256))
  call check_last_A_Q(l_switch,G2(:,:,:,256),Q(:,63),MT,G3tensor(:,140))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,8),G2(:,:,:,257),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,257),Q(:,63),MT,G3tensor(:,141))
  call loop_QV_A(G0(:,:,:,1),wf(:,49),G0(:,:,:,47))
  call loop_Q_A(G0(:,:,:,47),Q(:,28),ZERO,G1(:,:,:,141))
  call loop_QV_A(G1(:,:,:,141),wf(:,-5),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,60),ZERO,G2(:,:,:,258))
  call loop_QV_A(G2(:,:,:,258),wf(:,1),G2(:,:,:,259))
  call check_last_Q_A(l_switch,G2(:,:,:,259),Q(:,63),ZERO,G3tensor(:,142))
  call loop_QZ_A(G2(:,:,:,258),wf(:,8),G2(:,:,:,260),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,260),Q(:,63),ZERO,G3tensor(:,143))
  call loop_QZ_A(G2(:,:,:,258),wf(:,8),G2(:,:,:,261),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,261),Q(:,63),ZERO,G3tensor(:,144))
  call loop_QV_A(G0(:,:,:,1),wf(:,49),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,28),MT,G1(:,:,:,143))
  call loop_QV_A(G1(:,:,:,143),wf(:,-5),G1(:,:,:,144))
  call loop_Q_A(G1(:,:,:,144),Q(:,60),MT,G2(:,:,:,262))
  call loop_QV_A(G2(:,:,:,262),wf(:,1),G2(:,:,:,263))
  call check_last_Q_A(l_switch,G2(:,:,:,263),Q(:,63),MT,G3tensor(:,145))
  call loop_QZ_A(G2(:,:,:,262),wf(:,8),G2(:,:,:,264),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,264),Q(:,63),MT,G3tensor(:,146))
  call loop_AV_Q(G0(:,:,:,1),wf(:,49),G0(:,:,:,49))
  call loop_A_Q(G0(:,:,:,49),Q(:,28),MB,G1(:,:,:,145))
  call loop_AV_Q(G1(:,:,:,145),wf(:,-5),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,60),MB,G2(:,:,:,265))
  call loop_AV_Q(G2(:,:,:,265),wf(:,1),G2(:,:,:,266))
  call check_last_A_Q(l_switch,G2(:,:,:,266),Q(:,63),MB,G3tensor(:,147))
  call loop_AZ_Q(G2(:,:,:,265),wf(:,8),G2(:,:,:,267),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,267),Q(:,63),MB,G3tensor(:,148))
  call loop_QV_A(G0(:,:,:,1),wf(:,49),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,28),MB,G1(:,:,:,147))
  call loop_QV_A(G1(:,:,:,147),wf(:,-5),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,60),MB,G2(:,:,:,268))
  call loop_QV_A(G2(:,:,:,268),wf(:,1),G2(:,:,:,269))
  call check_last_Q_A(l_switch,G2(:,:,:,269),Q(:,63),MB,G3tensor(:,149))
  call loop_QZ_A(G2(:,:,:,268),wf(:,8),G2(:,:,:,270),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,270),Q(:,63),MB,G3tensor(:,150))
  call loop_VA_Q(G0(:,:,:,1),wf(:,70),G0(:,:,:,51))
  call loop_A_Q(G0(:,:,:,51),Q(:,56),ZERO,G1(:,:,:,149))
  call loop_AV_Q(G1(:,:,:,149),wf(:,1),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,59),ZERO,G2(:,:,:,271))
  call check_last_AQ_V(l_switch,G2(:,:,:,271),wf(:,-2),G2tensor(:,35))
  call loop_AZ_Q(G1(:,:,:,149),wf(:,8),G1(:,:,:,151),gZu)
  call loop_A_Q(G1(:,:,:,151),Q(:,59),ZERO,G2(:,:,:,272))
  call check_last_AQ_V(l_switch,G2(:,:,:,272),wf(:,-2),G2tensor(:,36))
  call check_last_AQ_V(l_switch,G1(:,:,:,149),wf(:,23),G1tensor(:,47))
  call check_last_AQ_V(l_switch,G1(:,:,:,149),wf(:,25),G1tensor(:,48))
  call loop_VA_Q(G0(:,:,:,1),wf(:,99),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,27),ZERO,G1(:,:,:,152))
  call loop_AV_Q(G1(:,:,:,152),wf(:,-5),G1(:,:,:,153))
  call loop_A_Q(G1(:,:,:,153),Q(:,59),ZERO,G2(:,:,:,273))
  call check_last_AQ_V(l_switch,G2(:,:,:,273),wf(:,-2),G2tensor(:,37))
  call loop_VA_Q(G0(:,:,:,1),wf(:,101),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,27),ZERO,G1(:,:,:,154))
  call loop_AV_Q(G1(:,:,:,154),wf(:,-5),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,59),ZERO,G2(:,:,:,274))
  call check_last_AQ_V(l_switch,G2(:,:,:,274),wf(:,-2),G2tensor(:,38))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,156))
  call loop_VQ_A(G1(:,:,:,156),wf(:,17),G1(:,:,:,157))
  call loop_Q_A(G1(:,:,:,157),Q(:,52),ZERO,G2(:,:,:,275))
  call check_last_QA_V(l_switch,G2(:,:,:,275),wf(:,12),G2tensor(:,39))
  call check_last_QA_V(l_switch,G2(:,:,:,275),wf(:,14),G2tensor(:,40))
  call loop_QV_A(G2(:,:,:,275),wf(:,1),G2(:,:,:,276))
  call loop_Q_A(G2(:,:,:,276),Q(:,55),ZERO,G3(:,:,:,95))
  call check_last_QA_V(l_switch,G3(:,:,:,95),wf(:,-3),G3tensor(:,151))
  call loop_QZ_A(G2(:,:,:,275),wf(:,8),G2(:,:,:,277),gZu)
  call loop_Q_A(G2(:,:,:,277),Q(:,55),ZERO,G3(:,:,:,96))
  call check_last_QA_V(l_switch,G3(:,:,:,96),wf(:,-3),G3tensor(:,152))
  call loop_VQ_A(G1(:,:,:,156),wf(:,103),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,55),ZERO,G2(:,:,:,278))
  call check_last_QA_V(l_switch,G2(:,:,:,278),wf(:,-3),G2tensor(:,41))
  call loop_VQ_A(G1(:,:,:,156),wf(:,104),G1(:,:,:,159))
  call loop_Q_A(G1(:,:,:,159),Q(:,55),ZERO,G2(:,:,:,279))
  call check_last_QA_V(l_switch,G2(:,:,:,279),wf(:,-3),G2tensor(:,42))
  call loop_VA_Q(G1(:,:,:,156),wf(:,5),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,56),ZERO,G2(:,:,:,280))
  call check_last_AQ_V(l_switch,G2(:,:,:,280),wf(:,23),G2tensor(:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,280),wf(:,25),G2tensor(:,44))
  call loop_AV_Q(G2(:,:,:,280),wf(:,1),G2(:,:,:,281))
  call loop_A_Q(G2(:,:,:,281),Q(:,59),ZERO,G3(:,:,:,97))
  call check_last_AQ_V(l_switch,G3(:,:,:,97),wf(:,-2),G3tensor(:,153))
  call loop_AZ_Q(G2(:,:,:,280),wf(:,8),G2(:,:,:,282),gZu)
  call loop_A_Q(G2(:,:,:,282),Q(:,59),ZERO,G3(:,:,:,98))
  call check_last_AQ_V(l_switch,G3(:,:,:,98),wf(:,-2),G3tensor(:,154))
  call loop_VA_Q(G1(:,:,:,156),wf(:,87),G1(:,:,:,161))
  call loop_A_Q(G1(:,:,:,161),Q(:,59),ZERO,G2(:,:,:,283))
  call check_last_AQ_V(l_switch,G2(:,:,:,283),wf(:,-2),G2tensor(:,45))
  call loop_VA_Q(G1(:,:,:,156),wf(:,89),G1(:,:,:,162))
  call loop_A_Q(G1(:,:,:,162),Q(:,59),ZERO,G2(:,:,:,284))
  call check_last_AQ_V(l_switch,G2(:,:,:,284),wf(:,-2),G2tensor(:,46))
  call loop_UV_W(G1(:,:,:,156),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,285))
  call check_last_UV_W(l_switch,G2(:,:,:,285),Q(:,48),wf(:,117),Q(:,15),G3tensor(:,155))
  call check_last_UV_W(l_switch,G2(:,:,:,285),Q(:,48),wf(:,118),Q(:,15),G3tensor(:,156))
  call loop_VA_Q(G2(:,:,:,285),wf(:,-3),G2(:,:,:,286))
  call loop_A_Q(G2(:,:,:,286),Q(:,56),ZERO,G3(:,:,:,99))
  call check_last_AQ_V(l_switch,G3(:,:,:,99),wf(:,23),G3tensor(:,157))
  call check_last_AQ_V(l_switch,G3(:,:,:,99),wf(:,25),G3tensor(:,158))
  call loop_AV_Q(G3(:,:,:,99),wf(:,1),G3(:,:,:,100))
  call loop_A_Q(G3(:,:,:,100),Q(:,59),ZERO,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,-2),G4tensor(:,49))
  call loop_AZ_Q(G3(:,:,:,99),wf(:,8),G3(:,:,:,101),gZu)
  call loop_A_Q(G3(:,:,:,101),Q(:,59),ZERO,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,-2),G4tensor(:,50))
  call check_last_UV_W(l_switch,G2(:,:,:,285),Q(:,48),wf(:,127),Q(:,15),G3tensor(:,159))
  call check_last_UV_W(l_switch,G2(:,:,:,285),Q(:,48),wf(:,128),Q(:,15),G3tensor(:,160))
  call loop_VA_Q(G2(:,:,:,285),wf(:,12),G2(:,:,:,287))
  call loop_A_Q(G2(:,:,:,287),Q(:,59),ZERO,G3(:,:,:,102))
  call check_last_AQ_V(l_switch,G3(:,:,:,102),wf(:,-2),G3tensor(:,161))
  call loop_VA_Q(G2(:,:,:,285),wf(:,14),G2(:,:,:,288))
  call loop_A_Q(G2(:,:,:,288),Q(:,59),ZERO,G3(:,:,:,103))
  call check_last_AQ_V(l_switch,G3(:,:,:,103),wf(:,-2),G3tensor(:,162))
  call loop_VQ_A(G1(:,:,:,156),wf(:,124),G1(:,:,:,163))
  call loop_Q_A(G1(:,:,:,163),Q(:,55),ZERO,G2(:,:,:,289))
  call check_last_QA_V(l_switch,G2(:,:,:,289),wf(:,-3),G2tensor(:,47))
  call loop_VQ_A(G1(:,:,:,156),wf(:,126),G1(:,:,:,164))
  call loop_Q_A(G1(:,:,:,164),Q(:,55),ZERO,G2(:,:,:,290))
  call check_last_QA_V(l_switch,G2(:,:,:,290),wf(:,-3),G2tensor(:,48))
  call loop_VA_Q(G1(:,:,:,156),wf(:,-3),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,24),ZERO,G2(:,:,:,291))
  call loop_AV_Q(G2(:,:,:,291),wf(:,-5),G2(:,:,:,292))
  call loop_A_Q(G2(:,:,:,292),Q(:,56),ZERO,G3(:,:,:,104))
  call check_last_AQ_V(l_switch,G3(:,:,:,104),wf(:,23),G3tensor(:,163))
  call check_last_AQ_V(l_switch,G3(:,:,:,104),wf(:,25),G3tensor(:,164))
  call loop_AV_Q(G3(:,:,:,104),wf(:,1),G3(:,:,:,105))
  call loop_A_Q(G3(:,:,:,105),Q(:,59),ZERO,G4(:,:,:,9))
  call check_last_AQ_V(l_switch,G4(:,:,:,9),wf(:,-2),G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,104),wf(:,8),G3(:,:,:,106),gZu)
  call loop_A_Q(G3(:,:,:,106),Q(:,59),ZERO,G4(:,:,:,10))
  call check_last_AQ_V(l_switch,G4(:,:,:,10),wf(:,-2),G4tensor(:,52))
  call loop_AV_Q(G2(:,:,:,291),wf(:,1),G2(:,:,:,293))
  call loop_A_Q(G2(:,:,:,293),Q(:,27),ZERO,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-5),G3(:,:,:,108))
  call loop_A_Q(G3(:,:,:,108),Q(:,59),ZERO,G4(:,:,:,11))
  call check_last_AQ_V(l_switch,G4(:,:,:,11),wf(:,-2),G4tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,291),wf(:,8),G2(:,:,:,294),gZu)
  call loop_A_Q(G2(:,:,:,294),Q(:,27),ZERO,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,-5),G3(:,:,:,110))
  call loop_A_Q(G3(:,:,:,110),Q(:,59),ZERO,G4(:,:,:,12))
  call check_last_AQ_V(l_switch,G4(:,:,:,12),wf(:,-2),G4tensor(:,54))
  call loop_VA_Q(G1(:,:,:,156),wf(:,134),G1(:,:,:,166))
  call loop_A_Q(G1(:,:,:,166),Q(:,59),ZERO,G2(:,:,:,295))
  call check_last_AQ_V(l_switch,G2(:,:,:,295),wf(:,-2),G2tensor(:,49))
  call loop_VA_Q(G1(:,:,:,156),wf(:,136),G1(:,:,:,167))
  call loop_A_Q(G1(:,:,:,167),Q(:,59),ZERO,G2(:,:,:,296))
  call check_last_AQ_V(l_switch,G2(:,:,:,296),wf(:,-2),G2tensor(:,50))
  call loop_VA_Q(G1(:,:,:,156),wf(:,12),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,27),ZERO,G2(:,:,:,297))
  call loop_AV_Q(G2(:,:,:,297),wf(:,-5),G2(:,:,:,298))
  call loop_A_Q(G2(:,:,:,298),Q(:,59),ZERO,G3(:,:,:,111))
  call check_last_AQ_V(l_switch,G3(:,:,:,111),wf(:,-2),G3tensor(:,165))
  call loop_VA_Q(G1(:,:,:,156),wf(:,14),G1(:,:,:,169))
  call loop_A_Q(G1(:,:,:,169),Q(:,27),ZERO,G2(:,:,:,299))
  call loop_AV_Q(G2(:,:,:,299),wf(:,-5),G2(:,:,:,300))
  call loop_A_Q(G2(:,:,:,300),Q(:,59),ZERO,G3(:,:,:,112))
  call check_last_AQ_V(l_switch,G3(:,:,:,112),wf(:,-2),G3tensor(:,166))
  call loop_VQ_A(G0(:,:,:,1),wf(:,63),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,52),ZERO,G1(:,:,:,170))
  call loop_QV_A(G1(:,:,:,170),wf(:,1),G1(:,:,:,171))
  call loop_Q_A(G1(:,:,:,171),Q(:,55),ZERO,G2(:,:,:,301))
  call check_last_QA_V(l_switch,G2(:,:,:,301),wf(:,-3),G2tensor(:,51))
  call loop_QZ_A(G1(:,:,:,170),wf(:,8),G1(:,:,:,172),gZu)
  call loop_Q_A(G1(:,:,:,172),Q(:,55),ZERO,G2(:,:,:,302))
  call check_last_QA_V(l_switch,G2(:,:,:,302),wf(:,-3),G2tensor(:,52))
  call check_last_QA_V(l_switch,G1(:,:,:,170),wf(:,12),G1tensor(:,49))
  call check_last_QA_V(l_switch,G1(:,:,:,170),wf(:,14),G1tensor(:,50))
  call loop_VQ_A(G0(:,:,:,1),wf(:,103),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,39),ZERO,G1(:,:,:,173))
  call loop_QV_A(G1(:,:,:,173),wf(:,-4),G1(:,:,:,174))
  call loop_Q_A(G1(:,:,:,174),Q(:,55),ZERO,G2(:,:,:,303))
  call check_last_QA_V(l_switch,G2(:,:,:,303),wf(:,-3),G2tensor(:,53))
  call check_last_QA_V(l_switch,G1(:,:,:,173),wf(:,18),G1tensor(:,51))
  call loop_VQ_A(G0(:,:,:,1),wf(:,104),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,39),ZERO,G1(:,:,:,175))
  call loop_QV_A(G1(:,:,:,175),wf(:,-4),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,55),ZERO,G2(:,:,:,304))
  call check_last_QA_V(l_switch,G2(:,:,:,304),wf(:,-3),G2tensor(:,54))
  call check_last_QA_V(l_switch,G1(:,:,:,175),wf(:,18),G1tensor(:,52))
  call loop_VA_Q(G0(:,:,:,1),wf(:,76),G0(:,:,:,57))
  call loop_A_Q(G0(:,:,:,57),Q(:,56),ZERO,G1(:,:,:,177))
  call loop_AV_Q(G1(:,:,:,177),wf(:,1),G1(:,:,:,178))
  call loop_A_Q(G1(:,:,:,178),Q(:,59),ZERO,G2(:,:,:,305))
  call check_last_AQ_V(l_switch,G2(:,:,:,305),wf(:,-2),G2tensor(:,55))
  call loop_AZ_Q(G1(:,:,:,177),wf(:,8),G1(:,:,:,179),gZu)
  call loop_A_Q(G1(:,:,:,179),Q(:,59),ZERO,G2(:,:,:,306))
  call check_last_AQ_V(l_switch,G2(:,:,:,306),wf(:,-2),G2tensor(:,56))
  call check_last_AQ_V(l_switch,G1(:,:,:,177),wf(:,23),G1tensor(:,53))
  call check_last_AQ_V(l_switch,G1(:,:,:,177),wf(:,25),G1tensor(:,54))
  call loop_VA_Q(G0(:,:,:,1),wf(:,87),G0(:,:,:,58))
  call loop_A_Q(G0(:,:,:,58),Q(:,43),ZERO,G1(:,:,:,180))
  call loop_AV_Q(G1(:,:,:,180),wf(:,-4),G1(:,:,:,181))
  call loop_A_Q(G1(:,:,:,181),Q(:,59),ZERO,G2(:,:,:,307))
  call check_last_AQ_V(l_switch,G2(:,:,:,307),wf(:,-2),G2tensor(:,57))
  call check_last_AQ_V(l_switch,G1(:,:,:,180),wf(:,4),G1tensor(:,55))
  call loop_VA_Q(G0(:,:,:,1),wf(:,89),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,43),ZERO,G1(:,:,:,182))
  call loop_AV_Q(G1(:,:,:,182),wf(:,-4),G1(:,:,:,183))
  call loop_A_Q(G1(:,:,:,183),Q(:,59),ZERO,G2(:,:,:,308))
  call check_last_AQ_V(l_switch,G2(:,:,:,308),wf(:,-2),G2tensor(:,58))
  call check_last_AQ_V(l_switch,G1(:,:,:,182),wf(:,4),G1tensor(:,56))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,60))
  call loop_A_Q(G0(:,:,:,60),Q(:,8),ZERO,G1(:,:,:,184))
  call loop_AV_Q(G1(:,:,:,184),wf(:,28),G1(:,:,:,185))
  call loop_A_Q(G1(:,:,:,185),Q(:,56),ZERO,G2(:,:,:,309))
  call check_last_AQ_V(l_switch,G2(:,:,:,309),wf(:,23),G2tensor(:,59))
  call check_last_AQ_V(l_switch,G2(:,:,:,309),wf(:,25),G2tensor(:,60))
  call loop_AV_Q(G2(:,:,:,309),wf(:,1),G2(:,:,:,310))
  call loop_A_Q(G2(:,:,:,310),Q(:,59),ZERO,G3(:,:,:,113))
  call check_last_AQ_V(l_switch,G3(:,:,:,113),wf(:,-2),G3tensor(:,167))
  call loop_AZ_Q(G2(:,:,:,309),wf(:,8),G2(:,:,:,311),gZu)
  call loop_A_Q(G2(:,:,:,311),Q(:,59),ZERO,G3(:,:,:,114))
  call check_last_AQ_V(l_switch,G3(:,:,:,114),wf(:,-2),G3tensor(:,168))
  call loop_AV_Q(G1(:,:,:,184),wf(:,1),G1(:,:,:,186))
  call loop_A_Q(G1(:,:,:,186),Q(:,11),ZERO,G2(:,:,:,312))
  call loop_AV_Q(G2(:,:,:,312),wf(:,28),G2(:,:,:,313))
  call loop_A_Q(G2(:,:,:,313),Q(:,59),ZERO,G3(:,:,:,115))
  call check_last_AQ_V(l_switch,G3(:,:,:,115),wf(:,-2),G3tensor(:,169))
  call loop_AV_Q(G2(:,:,:,312),wf(:,-5),G2(:,:,:,314))
  call loop_A_Q(G2(:,:,:,314),Q(:,43),ZERO,G3(:,:,:,116))
  call loop_AV_Q(G3(:,:,:,116),wf(:,-4),G3(:,:,:,117))
  call loop_A_Q(G3(:,:,:,117),Q(:,59),ZERO,G4(:,:,:,13))
  call check_last_AQ_V(l_switch,G4(:,:,:,13),wf(:,-2),G4tensor(:,55))
  call loop_AV_Q(G2(:,:,:,312),wf(:,-4),G2(:,:,:,315))
  call loop_A_Q(G2(:,:,:,315),Q(:,27),ZERO,G3(:,:,:,118))
  call loop_AV_Q(G3(:,:,:,118),wf(:,-5),G3(:,:,:,119))
  call loop_A_Q(G3(:,:,:,119),Q(:,59),ZERO,G4(:,:,:,14))
  call check_last_AQ_V(l_switch,G4(:,:,:,14),wf(:,-2),G4tensor(:,56))
  call loop_AZ_Q(G1(:,:,:,184),wf(:,8),G1(:,:,:,187),gZu)
  call loop_A_Q(G1(:,:,:,187),Q(:,11),ZERO,G2(:,:,:,316))
  call loop_AV_Q(G2(:,:,:,316),wf(:,28),G2(:,:,:,317))
  call loop_A_Q(G2(:,:,:,317),Q(:,59),ZERO,G3(:,:,:,120))
  call check_last_AQ_V(l_switch,G3(:,:,:,120),wf(:,-2),G3tensor(:,170))
  call loop_AV_Q(G2(:,:,:,316),wf(:,-5),G2(:,:,:,318))
  call loop_A_Q(G2(:,:,:,318),Q(:,43),ZERO,G3(:,:,:,121))
  call loop_AV_Q(G3(:,:,:,121),wf(:,-4),G3(:,:,:,122))
  call loop_A_Q(G3(:,:,:,122),Q(:,59),ZERO,G4(:,:,:,15))
  call check_last_AQ_V(l_switch,G4(:,:,:,15),wf(:,-2),G4tensor(:,57))
  call loop_AV_Q(G2(:,:,:,316),wf(:,-4),G2(:,:,:,319))
  call loop_A_Q(G2(:,:,:,319),Q(:,27),ZERO,G3(:,:,:,123))
  call loop_AV_Q(G3(:,:,:,123),wf(:,-5),G3(:,:,:,124))
  call loop_A_Q(G3(:,:,:,124),Q(:,59),ZERO,G4(:,:,:,16))
  call check_last_AQ_V(l_switch,G4(:,:,:,16),wf(:,-2),G4tensor(:,58))
  call loop_AV_Q(G1(:,:,:,184),wf(:,-4),G1(:,:,:,188))
  call loop_A_Q(G1(:,:,:,188),Q(:,24),ZERO,G2(:,:,:,320))
  call loop_AV_Q(G2(:,:,:,320),wf(:,-5),G2(:,:,:,321))
  call loop_A_Q(G2(:,:,:,321),Q(:,56),ZERO,G3(:,:,:,125))
  call check_last_AQ_V(l_switch,G3(:,:,:,125),wf(:,23),G3tensor(:,171))
  call check_last_AQ_V(l_switch,G3(:,:,:,125),wf(:,25),G3tensor(:,172))
  call loop_AV_Q(G3(:,:,:,125),wf(:,1),G3(:,:,:,126))
  call loop_A_Q(G3(:,:,:,126),Q(:,59),ZERO,G4(:,:,:,17))
  call check_last_AQ_V(l_switch,G4(:,:,:,17),wf(:,-2),G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,125),wf(:,8),G3(:,:,:,127),gZu)
  call loop_A_Q(G3(:,:,:,127),Q(:,59),ZERO,G4(:,:,:,18))
  call check_last_AQ_V(l_switch,G4(:,:,:,18),wf(:,-2),G4tensor(:,60))
  call loop_AV_Q(G2(:,:,:,320),wf(:,1),G2(:,:,:,322))
  call loop_A_Q(G2(:,:,:,322),Q(:,27),ZERO,G3(:,:,:,128))
  call loop_AV_Q(G3(:,:,:,128),wf(:,-5),G3(:,:,:,129))
  call loop_A_Q(G3(:,:,:,129),Q(:,59),ZERO,G4(:,:,:,19))
  call check_last_AQ_V(l_switch,G4(:,:,:,19),wf(:,-2),G4tensor(:,61))
  call loop_AZ_Q(G2(:,:,:,320),wf(:,8),G2(:,:,:,323),gZu)
  call loop_A_Q(G2(:,:,:,323),Q(:,27),ZERO,G3(:,:,:,130))
  call loop_AV_Q(G3(:,:,:,130),wf(:,-5),G3(:,:,:,131))
  call loop_A_Q(G3(:,:,:,131),Q(:,59),ZERO,G4(:,:,:,20))
  call check_last_AQ_V(l_switch,G4(:,:,:,20),wf(:,-2),G4tensor(:,62))
  call loop_AV_Q(G1(:,:,:,184),wf(:,-5),G1(:,:,:,189))
  call loop_A_Q(G1(:,:,:,189),Q(:,40),ZERO,G2(:,:,:,324))
  call loop_AV_Q(G2(:,:,:,324),wf(:,-4),G2(:,:,:,325))
  call loop_A_Q(G2(:,:,:,325),Q(:,56),ZERO,G3(:,:,:,132))
  call check_last_AQ_V(l_switch,G3(:,:,:,132),wf(:,23),G3tensor(:,173))
  call check_last_AQ_V(l_switch,G3(:,:,:,132),wf(:,25),G3tensor(:,174))
  call loop_AV_Q(G3(:,:,:,132),wf(:,1),G3(:,:,:,133))
  call loop_A_Q(G3(:,:,:,133),Q(:,59),ZERO,G4(:,:,:,21))
  call check_last_AQ_V(l_switch,G4(:,:,:,21),wf(:,-2),G4tensor(:,63))
  call loop_AZ_Q(G3(:,:,:,132),wf(:,8),G3(:,:,:,134),gZu)
  call loop_A_Q(G3(:,:,:,134),Q(:,59),ZERO,G4(:,:,:,22))
  call check_last_AQ_V(l_switch,G4(:,:,:,22),wf(:,-2),G4tensor(:,64))
  call loop_AV_Q(G2(:,:,:,324),wf(:,1),G2(:,:,:,326))
  call loop_A_Q(G2(:,:,:,326),Q(:,43),ZERO,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,-4),G3(:,:,:,136))
  call loop_A_Q(G3(:,:,:,136),Q(:,59),ZERO,G4(:,:,:,23))
  call check_last_AQ_V(l_switch,G4(:,:,:,23),wf(:,-2),G4tensor(:,65))
  call loop_AZ_Q(G2(:,:,:,324),wf(:,8),G2(:,:,:,327),gZu)
  call loop_A_Q(G2(:,:,:,327),Q(:,43),ZERO,G3(:,:,:,137))
  call loop_AV_Q(G3(:,:,:,137),wf(:,-4),G3(:,:,:,138))
  call loop_A_Q(G3(:,:,:,138),Q(:,59),ZERO,G4(:,:,:,24))
  call check_last_AQ_V(l_switch,G4(:,:,:,24),wf(:,-2),G4tensor(:,66))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,28),Q(:,48),G1(:,:,:,190))
  call loop_VA_Q(G1(:,:,:,190),wf(:,-3),G1(:,:,:,191))
  call loop_A_Q(G1(:,:,:,191),Q(:,56),ZERO,G2(:,:,:,328))
  call check_last_AQ_V(l_switch,G2(:,:,:,328),wf(:,23),G2tensor(:,61))
  call check_last_AQ_V(l_switch,G2(:,:,:,328),wf(:,25),G2tensor(:,62))
  call loop_AV_Q(G2(:,:,:,328),wf(:,1),G2(:,:,:,329))
  call loop_A_Q(G2(:,:,:,329),Q(:,59),ZERO,G3(:,:,:,139))
  call check_last_AQ_V(l_switch,G3(:,:,:,139),wf(:,-2),G3tensor(:,175))
  call loop_AZ_Q(G2(:,:,:,328),wf(:,8),G2(:,:,:,330),gZu)
  call loop_A_Q(G2(:,:,:,330),Q(:,59),ZERO,G3(:,:,:,140))
  call check_last_AQ_V(l_switch,G3(:,:,:,140),wf(:,-2),G3tensor(:,176))
  call loop_VA_Q(G1(:,:,:,190),wf(:,12),G1(:,:,:,192))
  call loop_A_Q(G1(:,:,:,192),Q(:,59),ZERO,G2(:,:,:,331))
  call check_last_AQ_V(l_switch,G2(:,:,:,331),wf(:,-2),G2tensor(:,63))
  call loop_VA_Q(G1(:,:,:,190),wf(:,14),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,59),ZERO,G2(:,:,:,332))
  call check_last_AQ_V(l_switch,G2(:,:,:,332),wf(:,-2),G2tensor(:,64))
  call check_last_UV_W(l_switch,G1(:,:,:,190),Q(:,48),wf(:,117),Q(:,15),G2tensor(:,65))
  call check_last_UV_W(l_switch,G1(:,:,:,190),Q(:,48),wf(:,118),Q(:,15),G2tensor(:,66))
  call check_last_UV_W(l_switch,G1(:,:,:,190),Q(:,48),wf(:,127),Q(:,15),G2tensor(:,67))
  call check_last_UV_W(l_switch,G1(:,:,:,190),Q(:,48),wf(:,128),Q(:,15),G2tensor(:,68))
  call loop_VA_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,61))
  call loop_A_Q(G0(:,:,:,61),Q(:,11),ZERO,G1(:,:,:,194))
  call loop_AV_Q(G1(:,:,:,194),wf(:,28),G1(:,:,:,195))
  call loop_A_Q(G1(:,:,:,195),Q(:,59),ZERO,G2(:,:,:,333))
  call check_last_AQ_V(l_switch,G2(:,:,:,333),wf(:,-2),G2tensor(:,69))
  call loop_AV_Q(G1(:,:,:,194),wf(:,-5),G1(:,:,:,196))
  call loop_A_Q(G1(:,:,:,196),Q(:,43),ZERO,G2(:,:,:,334))
  call loop_AV_Q(G2(:,:,:,334),wf(:,-4),G2(:,:,:,335))
  call loop_A_Q(G2(:,:,:,335),Q(:,59),ZERO,G3(:,:,:,141))
  call check_last_AQ_V(l_switch,G3(:,:,:,141),wf(:,-2),G3tensor(:,177))
  call loop_AV_Q(G1(:,:,:,194),wf(:,-4),G1(:,:,:,197))
  call loop_A_Q(G1(:,:,:,197),Q(:,27),ZERO,G2(:,:,:,336))
  call loop_AV_Q(G2(:,:,:,336),wf(:,-5),G2(:,:,:,337))
  call loop_A_Q(G2(:,:,:,337),Q(:,59),ZERO,G3(:,:,:,142))
  call check_last_AQ_V(l_switch,G3(:,:,:,142),wf(:,-2),G3tensor(:,178))
  call loop_VA_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,62))
  call loop_A_Q(G0(:,:,:,62),Q(:,11),ZERO,G1(:,:,:,198))
  call loop_AV_Q(G1(:,:,:,198),wf(:,28),G1(:,:,:,199))
  call loop_A_Q(G1(:,:,:,199),Q(:,59),ZERO,G2(:,:,:,338))
  call check_last_AQ_V(l_switch,G2(:,:,:,338),wf(:,-2),G2tensor(:,70))
  call loop_AV_Q(G1(:,:,:,198),wf(:,-5),G1(:,:,:,200))
  call loop_A_Q(G1(:,:,:,200),Q(:,43),ZERO,G2(:,:,:,339))
  call loop_AV_Q(G2(:,:,:,339),wf(:,-4),G2(:,:,:,340))
  call loop_A_Q(G2(:,:,:,340),Q(:,59),ZERO,G3(:,:,:,143))
  call check_last_AQ_V(l_switch,G3(:,:,:,143),wf(:,-2),G3tensor(:,179))
  call loop_AV_Q(G1(:,:,:,198),wf(:,-4),G1(:,:,:,201))
  call loop_A_Q(G1(:,:,:,201),Q(:,27),ZERO,G2(:,:,:,341))
  call loop_AV_Q(G2(:,:,:,341),wf(:,-5),G2(:,:,:,342))
  call loop_A_Q(G2(:,:,:,342),Q(:,59),ZERO,G3(:,:,:,144))
  call check_last_AQ_V(l_switch,G3(:,:,:,144),wf(:,-2),G3tensor(:,180))
  call loop_VQ_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,52),ZERO,G1(:,:,:,202))
  call loop_QV_A(G1(:,:,:,202),wf(:,1),G1(:,:,:,203))
  call loop_Q_A(G1(:,:,:,203),Q(:,55),ZERO,G2(:,:,:,343))
  call check_last_QA_V(l_switch,G2(:,:,:,343),wf(:,-3),G2tensor(:,71))
  call loop_QZ_A(G1(:,:,:,202),wf(:,8),G1(:,:,:,204),gZu)
  call loop_Q_A(G1(:,:,:,204),Q(:,55),ZERO,G2(:,:,:,344))
  call check_last_QA_V(l_switch,G2(:,:,:,344),wf(:,-3),G2tensor(:,72))
  call check_last_QA_V(l_switch,G1(:,:,:,202),wf(:,12),G1tensor(:,57))
  call check_last_QA_V(l_switch,G1(:,:,:,202),wf(:,14),G1tensor(:,58))
  call loop_VA_Q(G0(:,:,:,1),wf(:,78),G0(:,:,:,64))
  call loop_A_Q(G0(:,:,:,64),Q(:,56),ZERO,G1(:,:,:,205))
  call loop_AV_Q(G1(:,:,:,205),wf(:,1),G1(:,:,:,206))
  call loop_A_Q(G1(:,:,:,206),Q(:,59),ZERO,G2(:,:,:,345))
  call check_last_AQ_V(l_switch,G2(:,:,:,345),wf(:,-2),G2tensor(:,73))
  call loop_AZ_Q(G1(:,:,:,205),wf(:,8),G1(:,:,:,207),gZu)
  call loop_A_Q(G1(:,:,:,207),Q(:,59),ZERO,G2(:,:,:,346))
  call check_last_AQ_V(l_switch,G2(:,:,:,346),wf(:,-2),G2tensor(:,74))
  call check_last_AQ_V(l_switch,G1(:,:,:,205),wf(:,23),G1tensor(:,59))
  call check_last_AQ_V(l_switch,G1(:,:,:,205),wf(:,25),G1tensor(:,60))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,-4),G1(:,:,:,208))
  call loop_DV_C(G1(:,:,:,208),Q(:,16),wf(:,-5),G2(:,:,:,347))
  call check_last_DV_C(l_switch,G2(:,:,:,347),Q(:,48),wf(:,117),G3tensor(:,181))
  call check_last_DV_C(l_switch,G2(:,:,:,347),Q(:,48),wf(:,118),G3tensor(:,182))
  call check_last_DV_C(l_switch,G2(:,:,:,347),Q(:,48),wf(:,127),G3tensor(:,183))
  call check_last_DV_C(l_switch,G2(:,:,:,347),Q(:,48),wf(:,128),G3tensor(:,184))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,209))
  call loop_CV_D(G1(:,:,:,209),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,348))
  call check_last_CV_D(l_switch,G2(:,:,:,348),Q(:,48),wf(:,117),Q(:,15),G3tensor(:,185))
  call check_last_CV_D(l_switch,G2(:,:,:,348),Q(:,48),wf(:,118),Q(:,15),G3tensor(:,186))
  call check_last_CV_D(l_switch,G2(:,:,:,348),Q(:,48),wf(:,127),Q(:,15),G3tensor(:,187))
  call check_last_CV_D(l_switch,G2(:,:,:,348),Q(:,48),wf(:,128),Q(:,15),G3tensor(:,188))
  call loop_VQ_A(G0(:,:,:,1),wf(:,120),G0(:,:,:,65))
  call loop_Q_A(G0(:,:,:,65),Q(:,23),ZERO,G1(:,:,:,210))
  call loop_QV_A(G1(:,:,:,210),wf(:,-5),G1(:,:,:,211))
  call loop_Q_A(G1(:,:,:,211),Q(:,55),ZERO,G2(:,:,:,349))
  call check_last_QA_V(l_switch,G2(:,:,:,349),wf(:,-3),G2tensor(:,75))
  call loop_VQ_A(G0(:,:,:,1),wf(:,122),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,23),ZERO,G1(:,:,:,212))
  call loop_QV_A(G1(:,:,:,212),wf(:,-5),G1(:,:,:,213))
  call loop_Q_A(G1(:,:,:,213),Q(:,55),ZERO,G2(:,:,:,350))
  call check_last_QA_V(l_switch,G2(:,:,:,350),wf(:,-3),G2tensor(:,76))
  call loop_VQ_A(G0(:,:,:,1),wf(:,124),G0(:,:,:,67))
  call loop_Q_A(G0(:,:,:,67),Q(:,39),ZERO,G1(:,:,:,214))
  call loop_QV_A(G1(:,:,:,214),wf(:,-4),G1(:,:,:,215))
  call loop_Q_A(G1(:,:,:,215),Q(:,55),ZERO,G2(:,:,:,351))
  call check_last_QA_V(l_switch,G2(:,:,:,351),wf(:,-3),G2tensor(:,77))
  call check_last_QA_V(l_switch,G1(:,:,:,214),wf(:,18),G1tensor(:,61))
  call loop_VQ_A(G0(:,:,:,1),wf(:,126),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,39),ZERO,G1(:,:,:,216))
  call loop_QV_A(G1(:,:,:,216),wf(:,-4),G1(:,:,:,217))
  call loop_Q_A(G1(:,:,:,217),Q(:,55),ZERO,G2(:,:,:,352))
  call check_last_QA_V(l_switch,G2(:,:,:,352),wf(:,-3),G2tensor(:,78))
  call check_last_QA_V(l_switch,G1(:,:,:,216),wf(:,18),G1tensor(:,62))
  call loop_VA_Q(G0(:,:,:,1),wf(:,130),G0(:,:,:,69))
  call loop_A_Q(G0(:,:,:,69),Q(:,27),ZERO,G1(:,:,:,218))
  call loop_AV_Q(G1(:,:,:,218),wf(:,-5),G1(:,:,:,219))
  call loop_A_Q(G1(:,:,:,219),Q(:,59),ZERO,G2(:,:,:,353))
  call check_last_AQ_V(l_switch,G2(:,:,:,353),wf(:,-2),G2tensor(:,79))
  call loop_VA_Q(G0(:,:,:,1),wf(:,132),G0(:,:,:,70))
  call loop_A_Q(G0(:,:,:,70),Q(:,27),ZERO,G1(:,:,:,220))
  call loop_AV_Q(G1(:,:,:,220),wf(:,-5),G1(:,:,:,221))
  call loop_A_Q(G1(:,:,:,221),Q(:,59),ZERO,G2(:,:,:,354))
  call check_last_AQ_V(l_switch,G2(:,:,:,354),wf(:,-2),G2tensor(:,80))
  call loop_VA_Q(G0(:,:,:,1),wf(:,134),G0(:,:,:,71))
  call loop_A_Q(G0(:,:,:,71),Q(:,43),ZERO,G1(:,:,:,222))
  call loop_AV_Q(G1(:,:,:,222),wf(:,-4),G1(:,:,:,223))
  call loop_A_Q(G1(:,:,:,223),Q(:,59),ZERO,G2(:,:,:,355))
  call check_last_AQ_V(l_switch,G2(:,:,:,355),wf(:,-2),G2tensor(:,81))
  call check_last_AQ_V(l_switch,G1(:,:,:,222),wf(:,4),G1tensor(:,63))
  call loop_VA_Q(G0(:,:,:,1),wf(:,136),G0(:,:,:,72))
  call loop_A_Q(G0(:,:,:,72),Q(:,43),ZERO,G1(:,:,:,224))
  call loop_AV_Q(G1(:,:,:,224),wf(:,-4),G1(:,:,:,225))
  call loop_A_Q(G1(:,:,:,225),Q(:,59),ZERO,G2(:,:,:,356))
  call check_last_AQ_V(l_switch,G2(:,:,:,356),wf(:,-2),G2tensor(:,82))
  call check_last_AQ_V(l_switch,G1(:,:,:,224),wf(:,4),G1tensor(:,64))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,117),G0(:,:,:,73))
  call check_last_UV_W(l_switch,G0(:,:,:,73),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,65))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,117),wf(:,-5),G0(:,:,:,74))
  call check_last_UV_W(l_switch,G0(:,:,:,74),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,66))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,117),G0(:,:,:,75))
  call check_last_UV_W(l_switch,G0(:,:,:,75),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,67))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,118),G0(:,:,:,76))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,68))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,118),wf(:,-5),G0(:,:,:,77))
  call check_last_UV_W(l_switch,G0(:,:,:,77),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,69))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,118),G0(:,:,:,78))
  call check_last_UV_W(l_switch,G0(:,:,:,78),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,70))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,127),G0(:,:,:,79))
  call check_last_UV_W(l_switch,G0(:,:,:,79),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,71))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,127),wf(:,-5),G0(:,:,:,80))
  call check_last_UV_W(l_switch,G0(:,:,:,80),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,72))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,127),G0(:,:,:,81))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,73))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,128),G0(:,:,:,82))
  call check_last_UV_W(l_switch,G0(:,:,:,82),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,74))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,128),wf(:,-5),G0(:,:,:,83))
  call check_last_UV_W(l_switch,G0(:,:,:,83),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,75))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,128),G0(:,:,:,84))
  call check_last_UV_W(l_switch,G0(:,:,:,84),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,76))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + ((-3*f(25))/2._/**/REALKIND * den(21)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,1),T2sum(1:5,1))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(21)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,1),T2sum(1:5,1))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(21)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,9),T2sum(1:5,1))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(21)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,9),T2sum(1:5,1))
  M(1) = M(1) + ((3*f(25))/2._/**/REALKIND * den(21)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,17),T2sum(1:5,1))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(21)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,17),T2sum(1:5,1))
  M(1) = M(1) + ((3*f(26))/2._/**/REALKIND * den(23)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,2),T2sum(1:5,1))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(23)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,2),T2sum(1:5,1))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(23)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,10),T2sum(1:5,1))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(23)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,10),T2sum(1:5,1))
  M(1) = M(1) + ((-3*f(26))/2._/**/REALKIND * den(23)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,18),T2sum(1:5,1))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(23)) * TI2_call(1,momenta_34,masses2_6,G1tensor(:,18),T2sum(1:5,1))
  M(1) = M(1) + ((-3*f(25))/2._/**/REALKIND * den(10)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,3),T2sum(1:5,2))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(10)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,3),T2sum(1:5,2))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(10)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,11),T2sum(1:5,2))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(10)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,11),T2sum(1:5,2))
  M(1) = M(1) + ((3*f(25))/2._/**/REALKIND * den(10)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,19),T2sum(1:5,2))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(10)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,19),T2sum(1:5,2))
  M(1) = M(1) + ((3*f(26))/2._/**/REALKIND * den(12)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,4),T2sum(1:5,2))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(12)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,4),T2sum(1:5,2))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(12)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,12),T2sum(1:5,2))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(12)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,12),T2sum(1:5,2))
  M(1) = M(1) + ((-3*f(26))/2._/**/REALKIND * den(12)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,20),T2sum(1:5,2))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(12)) * TI2_call(1,momenta_35,masses2_6,G1tensor(:,20),T2sum(1:5,2))
  M(1) = M(1) + ((-3*f(25))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,1),T3sum(1:15,1))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,1),T3sum(1:15,1))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,3),T3sum(1:15,1))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,3),T3sum(1:15,1))
  M(1) = M(1) + ((3*f(25))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,5),T3sum(1:15,1))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(1)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,5),T3sum(1:15,1))
  M(1) = M(1) + ((3*f(26))/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,2),T3sum(1:15,1))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,2),T3sum(1:15,1))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,4),T3sum(1:15,1))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,4),T3sum(1:15,1))
  M(1) = M(1) + ((-3*f(26))/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,6),T3sum(1:15,1))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(6)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,6),T3sum(1:15,1))
  M(1) = M(1) + (-(CI*f(30))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,1),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(30))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,1),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(28))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,4),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(28))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,4),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(30))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,6),T3sum(1:35,2))
  M(2) = M(2) + ((CI*f(30))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,6),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(28))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,9),T3sum(1:35,3))
  M(2) = M(2) + ((CI*f(28))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,9),T3sum(1:35,3))
  M(1) = M(1) + ((CI*f(28))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,1),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(28))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,1),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(27))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,11),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(27))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,11),T3sum(1:35,4))
  M(1) = M(1) + ((CI*f(28))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,6),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(28))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,6),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(27))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,13),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(27))/2._/**/REALKIND * den(138)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,13),T3sum(1:35,4))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,2),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,2),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,5),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,5),T3sum(1:35,3))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,7),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,7),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,10),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_5,G3tensor(:,10),T3sum(1:35,3))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,3),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,3),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,12),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,12),T3sum(1:35,4))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,8),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_6,G3tensor(:,8),T3sum(1:35,2))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,14),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(139)) * TI2_call(3,momenta_12,masses2_4,G3tensor(:,14),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(30))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,15),T3sum(1:35,5))
  M(2) = M(2) + ((CI*f(30))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,15),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(28))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,18),T3sum(1:35,6))
  M(2) = M(2) + ((CI*f(28))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,18),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(30))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,20),T3sum(1:35,5))
  M(2) = M(2) + ((CI*f(30))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,20),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(28))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,23),T3sum(1:35,6))
  M(2) = M(2) + ((CI*f(28))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,23),T3sum(1:35,6))
  M(1) = M(1) + ((CI*f(28))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,15),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(28))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,15),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(27))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,25),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(27))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,25),T3sum(1:35,7))
  M(1) = M(1) + ((CI*f(28))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,20),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(28))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,20),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(27))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,27),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(27))/2._/**/REALKIND * den(140)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,27),T3sum(1:35,7))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,16),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,16),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,19),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,19),T3sum(1:35,6))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,21),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,21),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,24),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,24),T3sum(1:35,6))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,17),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,17),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,26),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,26),T3sum(1:35,7))
  M(1) = M(1) + ((CI*f(31))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,22),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(31))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,22),T3sum(1:35,5))
  M(1) = M(1) + ((CI*f(29))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,28),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(29))/2._/**/REALKIND * den(42)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,28),T3sum(1:35,7))
  M(1) = M(1) + ((CI*f(30))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,29),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(30))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,29),T3sum(1:35,8))
  M(1) = M(1) + ((CI*f(28))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,42),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(28))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,42),T3sum(1:35,9))
  M(1) = M(1) + ((CI*f(30))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,52),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(30))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,52),T3sum(1:35,8))
  M(1) = M(1) + ((CI*f(28))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,65),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(28))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,65),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(28))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,29),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(28))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,29),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(27))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,75),T3sum(1:35,10))
  M(2) = M(2) + ((CI*f(27))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,75),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(28))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,52),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(28))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,52),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(27))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,85),T3sum(1:35,10))
  M(2) = M(2) + ((CI*f(27))/2._/**/REALKIND * den(141)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,85),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(31))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,30),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(31))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,30),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(29))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,43),T3sum(1:35,9))
  M(2) = M(2) + ((CI*f(29))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,43),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(31))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,53),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(31))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,53),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(29))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,66),T3sum(1:35,9))
  M(2) = M(2) + ((CI*f(29))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,66),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(31))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,31),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(31))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,31),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(29))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,76),T3sum(1:35,10))
  M(2) = M(2) + ((CI*f(29))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,76),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(31))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,54),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(31))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,54),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(29))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,86),T3sum(1:35,10))
  M(2) = M(2) + ((CI*f(29))/2._/**/REALKIND * den(45)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,86),T3sum(1:35,10))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,11),T4sum(1:70,1))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,11),T4sum(1:70,1))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,17),T4sum(1:70,2))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,17),T4sum(1:70,2))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,1),T4sum(1:70,1))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,1),T4sum(1:70,1))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,7),T4sum(1:70,2))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,7),T4sum(1:70,2))
  M(1) = M(1) + (-(f(33)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,11),T4sum(1:70,1))
  M(3) = M(3) + (f(33)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,11),T4sum(1:70,1))
  M(1) = M(1) + (-(f(32)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,25),T4sum(1:70,3))
  M(3) = M(3) + (f(32)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,25),T4sum(1:70,3))
  M(2) = M(2) + (-(f(33)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,1),T4sum(1:70,1))
  M(3) = M(3) + (f(33)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,1),T4sum(1:70,1))
  M(2) = M(2) + (-(f(32)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,21),T4sum(1:70,3))
  M(3) = M(3) + (f(32)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,21),T4sum(1:70,3))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,12),T4sum(1:70,1))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,12),T4sum(1:70,1))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,18),T4sum(1:70,2))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,18),T4sum(1:70,2))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,2),T4sum(1:70,1))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,2),T4sum(1:70,1))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,8),T4sum(1:70,2))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_45,masses2_8,G4tensor(:,8),T4sum(1:70,2))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,13),T4sum(1:70,1))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,13),T4sum(1:70,1))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,26),T4sum(1:70,3))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,26),T4sum(1:70,3))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,3),T4sum(1:70,1))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_45,masses2_9,G4tensor(:,3),T4sum(1:70,1))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,22),T4sum(1:70,3))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_45,masses2_7,G4tensor(:,22),T4sum(1:70,3))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,4),T4sum(1:70,4))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,4),T4sum(1:70,4))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,9),T4sum(1:70,5))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,9),T4sum(1:70,5))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,14),T4sum(1:70,4))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,14),T4sum(1:70,4))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,19),T4sum(1:70,5))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,19),T4sum(1:70,5))
  M(1) = M(1) + (-(f(33)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,4),T4sum(1:70,4))
  M(3) = M(3) + (f(33)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,4),T4sum(1:70,4))
  M(1) = M(1) + (-(f(32)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,23),T4sum(1:70,6))
  M(3) = M(3) + (f(32)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,23),T4sum(1:70,6))
  M(2) = M(2) + (-(f(33)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,14),T4sum(1:70,4))
  M(3) = M(3) + (f(33)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,14),T4sum(1:70,4))
  M(2) = M(2) + (-(f(32)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,27),T4sum(1:70,6))
  M(3) = M(3) + (f(32)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,27),T4sum(1:70,6))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,5),T4sum(1:70,4))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,5),T4sum(1:70,4))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,10),T4sum(1:70,5))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,10),T4sum(1:70,5))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,15),T4sum(1:70,4))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,15),T4sum(1:70,4))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,20),T4sum(1:70,5))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_44,masses2_8,G4tensor(:,20),T4sum(1:70,5))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,6),T4sum(1:70,4))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,6),T4sum(1:70,4))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,24),T4sum(1:70,6))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,24),T4sum(1:70,6))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,16),T4sum(1:70,4))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_44,masses2_9,G4tensor(:,16),T4sum(1:70,4))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,28),T4sum(1:70,6))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_44,masses2_7,G4tensor(:,28),T4sum(1:70,6))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,29),T4sum(1:70,7))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,29),T4sum(1:70,7))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,32),T4sum(1:70,8))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,32),T4sum(1:70,8))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,34),T4sum(1:70,7))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,34),T4sum(1:70,7))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(37)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,37),T4sum(1:70,8))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(37)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,37),T4sum(1:70,8))
  M(1) = M(1) + (-(f(33)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,29),T4sum(1:70,7))
  M(3) = M(3) + (f(33)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,29),T4sum(1:70,7))
  M(1) = M(1) + (-(f(32)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,39),T4sum(1:70,9))
  M(3) = M(3) + (f(32)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,39),T4sum(1:70,9))
  M(2) = M(2) + (-(f(33)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,34),T4sum(1:70,7))
  M(3) = M(3) + (f(33)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,34),T4sum(1:70,7))
  M(2) = M(2) + (-(f(32)/2._/**/REALKIND) * den(37)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,41),T4sum(1:70,9))
  M(3) = M(3) + (f(32)/6._/**/REALKIND * den(37)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,41),T4sum(1:70,9))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,30),T4sum(1:70,7))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,30),T4sum(1:70,7))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,33),T4sum(1:70,8))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,33),T4sum(1:70,8))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,35),T4sum(1:70,7))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,35),T4sum(1:70,7))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,38),T4sum(1:70,8))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_48,masses2_8,G4tensor(:,38),T4sum(1:70,8))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,31),T4sum(1:70,7))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,31),T4sum(1:70,7))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,40),T4sum(1:70,9))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,40),T4sum(1:70,9))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,36),T4sum(1:70,7))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_48,masses2_9,G4tensor(:,36),T4sum(1:70,7))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(38)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,42),T4sum(1:70,9))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(38)) * TI2_call(4,momenta_48,masses2_7,G4tensor(:,42),T4sum(1:70,9))
  M(2) = M(2) + ((-4*f(25))/3._/**/REALKIND * den(142)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,7),T2sum(1:15,3))
  M(2) = M(2) + ((4*f(26))/3._/**/REALKIND * den(143)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,8),T2sum(1:15,3))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(11)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,11),T2sum(1:15,4))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(13)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,12),T2sum(1:15,4))
  M(2) = M(2) + ((3*CI*f(23))/2._/**/REALKIND * den(11)) * TI2_call(2,momenta_24,masses2_6,G2tensor(:,13),T2sum(1:15,5))
  M(2) = M(2) + ((-3*CI*f(24))/2._/**/REALKIND * den(13)) * TI2_call(2,momenta_24,masses2_6,G2tensor(:,14),T2sum(1:15,5))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(144)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,115),T3sum(1:35,5))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(144)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,118),T3sum(1:35,6))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(144)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,120),T3sum(1:35,5))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(144)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,123),T3sum(1:35,6))
  M(2) = M(2) + (-(f(33)/2._/**/REALKIND) * den(144)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,115),T3sum(1:35,5))
  M(2) = M(2) + (-(f(32)/2._/**/REALKIND) * den(144)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,125),T3sum(1:35,7))
  M(2) = M(2) + (-(f(33)/2._/**/REALKIND) * den(144)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,120),T3sum(1:35,5))
  M(2) = M(2) + (-(f(32)/2._/**/REALKIND) * den(144)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,127),T3sum(1:35,7))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(47)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,116),T3sum(1:35,5))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(47)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,119),T3sum(1:35,6))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(47)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,121),T3sum(1:35,5))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(47)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,124),T3sum(1:35,6))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(47)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,117),T3sum(1:35,5))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(47)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,126),T3sum(1:35,7))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(47)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,122),T3sum(1:35,5))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(47)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,128),T3sum(1:35,7))
  M(2) = M(2) + ((-4*f(25))/3._/**/REALKIND * den(55)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,25),T2sum(1:15,6))
  M(2) = M(2) + ((4*f(26))/3._/**/REALKIND * den(56)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,26),T2sum(1:15,6))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(80)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,27),T2sum(1:15,7))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(82)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,28),T2sum(1:15,7))
  M(2) = M(2) + ((3*CI*f(23))/2._/**/REALKIND * den(80)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,15),T2sum(1:15,8))
  M(2) = M(2) + ((-3*CI*f(24))/2._/**/REALKIND * den(82)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,16),T2sum(1:15,8))
  M(2) = M(2) + ((3*CI*f(23))/2._/**/REALKIND * den(4)) * TI2_call(3,momenta_61,masses2_9,G3tensor(:,103),T3sum(1:35,11))
  M(2) = M(2) + ((-3*CI*f(24))/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_61,masses2_9,G3tensor(:,104),T3sum(1:35,11))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(4)) * TI2_call(3,momenta_53,masses2_9,G3tensor(:,101),T3sum(1:35,12))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(7)) * TI2_call(3,momenta_53,masses2_9,G3tensor(:,102),T3sum(1:35,12))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(4)) * TI2_call(3,momenta_54,masses2_9,G3tensor(:,99),T3sum(1:35,13))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(7)) * TI2_call(3,momenta_54,masses2_9,G3tensor(:,100),T3sum(1:35,13))
  M(1) = M(1) + ((-4*f(25))/3._/**/REALKIND * den(145)) * TI2_call(2,momenta_28,masses2_6,G2tensor(:,29),T2sum(1:15,9))
  M(1) = M(1) + ((4*f(26))/3._/**/REALKIND * den(146)) * TI2_call(2,momenta_28,masses2_6,G2tensor(:,30),T2sum(1:15,9))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(22)) * TI2_call(2,momenta_21,masses2_6,G2tensor(:,33),T2sum(1:15,10))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(24)) * TI2_call(2,momenta_21,masses2_6,G2tensor(:,34),T2sum(1:15,10))
  M(1) = M(1) + ((-3*CI*f(23))/2._/**/REALKIND * den(22)) * TI2_call(2,momenta_26,masses2_6,G2tensor(:,17),T2sum(1:15,11))
  M(1) = M(1) + ((3*CI*f(24))/2._/**/REALKIND * den(24)) * TI2_call(2,momenta_26,masses2_6,G2tensor(:,18),T2sum(1:15,11))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(147)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,137),T3sum(1:35,5))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(147)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,140),T3sum(1:35,6))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(147)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,142),T3sum(1:35,5))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(147)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,145),T3sum(1:35,6))
  M(1) = M(1) + (-(f(33)/2._/**/REALKIND) * den(147)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,137),T3sum(1:35,5))
  M(1) = M(1) + (-(f(32)/2._/**/REALKIND) * den(147)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,147),T3sum(1:35,7))
  M(1) = M(1) + (-(f(33)/2._/**/REALKIND) * den(147)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,142),T3sum(1:35,5))
  M(1) = M(1) + (-(f(32)/2._/**/REALKIND) * den(147)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,149),T3sum(1:35,7))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(49)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,138),T3sum(1:35,5))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(49)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,141),T3sum(1:35,6))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(49)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,143),T3sum(1:35,5))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(49)) * TI2_call(3,momenta_23,masses2_5,G3tensor(:,146),T3sum(1:35,6))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(49)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,139),T3sum(1:35,5))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(49)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,148),T3sum(1:35,7))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(49)) * TI2_call(3,momenta_23,masses2_6,G3tensor(:,144),T3sum(1:35,5))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(49)) * TI2_call(3,momenta_23,masses2_4,G3tensor(:,150),T3sum(1:35,7))
  M(1) = M(1) + ((-4*f(25))/3._/**/REALKIND * den(62)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,35),T2sum(1:15,12))
  M(1) = M(1) + ((4*f(26))/3._/**/REALKIND * den(63)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,36),T2sum(1:15,12))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(91)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,37),T2sum(1:15,13))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(94)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,38),T2sum(1:15,13))
  M(1) = M(1) + ((-3*CI*f(23))/2._/**/REALKIND * den(91)) * TI2_call(2,momenta_27,masses2_6,G2tensor(:,19),T2sum(1:15,14))
  M(1) = M(1) + ((3*CI*f(24))/2._/**/REALKIND * den(94)) * TI2_call(2,momenta_27,masses2_6,G2tensor(:,20),T2sum(1:15,14))
  M(1) = M(1) + ((-3*CI*f(23))/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_62,masses2_9,G3tensor(:,105),T3sum(1:35,14))
  M(1) = M(1) + ((3*CI*f(24))/2._/**/REALKIND * den(93)) * TI2_call(3,momenta_62,masses2_9,G3tensor(:,106),T3sum(1:35,14))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(89)) * TI2_call(3,momenta_55,masses2_9,G3tensor(:,135),T3sum(1:35,15))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(93)) * TI2_call(3,momenta_55,masses2_9,G3tensor(:,136),T3sum(1:35,15))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(89)) * TI2_call(3,momenta_56,masses2_9,G3tensor(:,133),T3sum(1:35,16))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(93)) * TI2_call(3,momenta_56,masses2_9,G3tensor(:,134),T3sum(1:35,16))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(25)) * TI2_call(2,momenta_29,masses2_6,G2tensor(:,31),T2sum(1:15,15))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(26)) * TI2_call(2,momenta_29,masses2_6,G2tensor(:,32),T2sum(1:15,15))
  M(1) = M(1) + ((3*CI*f(23))/2._/**/REALKIND * den(25)) * TI2_call(2,momenta_14,masses2_6,G2tensor(:,39),T2sum(1:15,16))
  M(1) = M(1) + ((-3*CI*f(24))/2._/**/REALKIND * den(26)) * TI2_call(2,momenta_14,masses2_6,G2tensor(:,40),T2sum(1:15,16))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,32),T3sum(1:35,8))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,44),T3sum(1:35,9))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,55),T3sum(1:35,8))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(148)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,67),T3sum(1:35,9))
  M(1) = M(1) + (-(f(33)/2._/**/REALKIND) * den(148)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,32),T3sum(1:35,8))
  M(1) = M(1) + (-(f(32)/2._/**/REALKIND) * den(148)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,77),T3sum(1:35,10))
  M(1) = M(1) + (-(f(33)/2._/**/REALKIND) * den(148)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,55),T3sum(1:35,8))
  M(1) = M(1) + (-(f(32)/2._/**/REALKIND) * den(148)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,87),T3sum(1:35,10))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,33),T3sum(1:35,8))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,45),T3sum(1:35,9))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,56),T3sum(1:35,8))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,68),T3sum(1:35,9))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,34),T3sum(1:35,8))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,78),T3sum(1:35,10))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,57),T3sum(1:35,8))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(51)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,88),T3sum(1:35,10))
  M(1) = M(1) + ((-4*f(25))/3._/**/REALKIND * den(58)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,51),T2sum(1:15,6))
  M(1) = M(1) + ((4*f(26))/3._/**/REALKIND * den(59)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,52),T2sum(1:15,6))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(97)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,53),T2sum(1:15,17))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(99)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,54),T2sum(1:15,17))
  M(1) = M(1) + ((3*CI*f(23))/2._/**/REALKIND * den(97)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,41),T2sum(1:15,18))
  M(1) = M(1) + ((-3*CI*f(24))/2._/**/REALKIND * den(99)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,42),T2sum(1:15,18))
  M(1) = M(1) + ((3*CI*f(23))/2._/**/REALKIND * den(16)) * TI2_call(3,momenta_51,masses2_9,G3tensor(:,151),T3sum(1:35,17))
  M(1) = M(1) + ((-3*CI*f(24))/2._/**/REALKIND * den(18)) * TI2_call(3,momenta_51,masses2_9,G3tensor(:,152),T3sum(1:35,17))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(16)) * TI2_call(3,momenta_63,masses2_9,G3tensor(:,129),T3sum(1:35,18))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(18)) * TI2_call(3,momenta_63,masses2_9,G3tensor(:,130),T3sum(1:35,18))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(16)) * TI2_call(3,momenta_64,masses2_9,G3tensor(:,131),T3sum(1:35,19))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(18)) * TI2_call(3,momenta_64,masses2_9,G3tensor(:,132),T3sum(1:35,19))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(27)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,9),T2sum(1:15,19))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(28)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,10),T2sum(1:15,19))
  M(2) = M(2) + ((-3*CI*f(23))/2._/**/REALKIND * den(27)) * TI2_call(2,momenta_16,masses2_6,G2tensor(:,43),T2sum(1:15,20))
  M(2) = M(2) + ((3*CI*f(24))/2._/**/REALKIND * den(28)) * TI2_call(2,momenta_16,masses2_6,G2tensor(:,44),T2sum(1:15,20))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,35),T3sum(1:35,8))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,46),T3sum(1:35,9))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,58),T3sum(1:35,8))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(149)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,69),T3sum(1:35,9))
  M(2) = M(2) + (-(f(33)/2._/**/REALKIND) * den(149)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,35),T3sum(1:35,8))
  M(2) = M(2) + (-(f(32)/2._/**/REALKIND) * den(149)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,79),T3sum(1:35,10))
  M(2) = M(2) + (-(f(33)/2._/**/REALKIND) * den(149)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,58),T3sum(1:35,8))
  M(2) = M(2) + (-(f(32)/2._/**/REALKIND) * den(149)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,89),T3sum(1:35,10))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,36),T3sum(1:35,8))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,47),T3sum(1:35,9))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,59),T3sum(1:35,8))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_18,masses2_5,G3tensor(:,70),T3sum(1:35,9))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,37),T3sum(1:35,8))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,80),T3sum(1:35,10))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_18,masses2_6,G3tensor(:,60),T3sum(1:35,8))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(53)) * TI2_call(3,momenta_18,masses2_4,G3tensor(:,90),T3sum(1:35,10))
  M(2) = M(2) + ((-4*f(25))/3._/**/REALKIND * den(65)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,55),T2sum(1:15,12))
  M(2) = M(2) + ((4*f(26))/3._/**/REALKIND * den(66)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,56),T2sum(1:15,12))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(74)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,57),T2sum(1:15,21))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(77)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,58),T2sum(1:15,21))
  M(2) = M(2) + ((-3*CI*f(23))/2._/**/REALKIND * den(74)) * TI2_call(2,momenta_17,masses2_6,G2tensor(:,45),T2sum(1:15,22))
  M(2) = M(2) + ((3*CI*f(24))/2._/**/REALKIND * den(77)) * TI2_call(2,momenta_17,masses2_6,G2tensor(:,46),T2sum(1:15,22))
  M(2) = M(2) + ((-3*CI*f(23))/2._/**/REALKIND * den(72)) * TI2_call(3,momenta_52,masses2_9,G3tensor(:,153),T3sum(1:35,20))
  M(2) = M(2) + ((3*CI*f(24))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_52,masses2_9,G3tensor(:,154),T3sum(1:35,20))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(72)) * TI2_call(3,momenta_65,masses2_9,G3tensor(:,95),T3sum(1:35,21))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(76)) * TI2_call(3,momenta_65,masses2_9,G3tensor(:,96),T3sum(1:35,21))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(72)) * TI2_call(3,momenta_66,masses2_9,G3tensor(:,97),T3sum(1:35,22))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(76)) * TI2_call(3,momenta_66,masses2_9,G3tensor(:,98),T3sum(1:35,22))
  M(1) = M(1) + (-(CI*f(23))/6._/**/REALKIND * den(30)) * TI2_call(2,momenta_10,masses2_6,G2tensor(:,59),T2sum(1:15,23))
  M(2) = M(2) + ((CI*f(23))/6._/**/REALKIND * den(30)) * TI2_call(2,momenta_10,masses2_6,G2tensor(:,59),T2sum(1:15,23))
  M(1) = M(1) + ((CI*f(24))/6._/**/REALKIND * den(31)) * TI2_call(2,momenta_10,masses2_6,G2tensor(:,60),T2sum(1:15,23))
  M(2) = M(2) + (-(CI*f(24))/6._/**/REALKIND * den(31)) * TI2_call(2,momenta_10,masses2_6,G2tensor(:,60),T2sum(1:15,23))
  M(1) = M(1) + ((3*f(25))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,61),T2sum(1:15,1))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(30)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,61),T2sum(1:15,1))
  M(1) = M(1) + ((-3*f(26))/2._/**/REALKIND * den(31)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,62),T2sum(1:15,1))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(31)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,62),T2sum(1:15,1))
  M(1) = M(1) + (-(CI*f(23))/6._/**/REALKIND * den(67)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,69),T2sum(1:15,24))
  M(2) = M(2) + ((CI*f(23))/6._/**/REALKIND * den(67)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,69),T2sum(1:15,24))
  M(1) = M(1) + ((CI*f(24))/6._/**/REALKIND * den(68)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,70),T2sum(1:15,24))
  M(2) = M(2) + (-(CI*f(24))/6._/**/REALKIND * den(68)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,70),T2sum(1:15,24))
  M(1) = M(1) + ((3*f(25))/2._/**/REALKIND * den(67)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,63),T2sum(1:15,2))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(67)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,63),T2sum(1:15,2))
  M(1) = M(1) + ((-3*f(26))/2._/**/REALKIND * den(68)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,64),T2sum(1:15,2))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(68)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,64),T2sum(1:15,2))
  M(1) = M(1) + ((4*CI*f(23))/3._/**/REALKIND * den(34)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,71),T2sum(1:15,6))
  M(2) = M(2) + ((-4*CI*f(23))/3._/**/REALKIND * den(34)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,71),T2sum(1:15,6))
  M(1) = M(1) + ((-4*CI*f(24))/3._/**/REALKIND * den(35)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,72),T2sum(1:15,6))
  M(2) = M(2) + ((4*CI*f(24))/3._/**/REALKIND * den(35)) * TI2_call(2,momenta_36,masses2_6,G2tensor(:,72),T2sum(1:15,6))
  M(1) = M(1) + ((4*CI*f(23))/3._/**/REALKIND * den(70)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,73),T2sum(1:15,12))
  M(2) = M(2) + ((-4*CI*f(23))/3._/**/REALKIND * den(70)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,73),T2sum(1:15,12))
  M(1) = M(1) + ((-4*CI*f(24))/3._/**/REALKIND * den(71)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,74),T2sum(1:15,12))
  M(2) = M(2) + ((4*CI*f(24))/3._/**/REALKIND * den(71)) * TI2_call(2,momenta_37,masses2_6,G2tensor(:,74),T2sum(1:15,12))
  M(1) = M(1) + (-(CI*f(23))/6._/**/REALKIND * den(150)) * TI2_call(3,momenta_41,masses2_9,G3tensor(:,167),T3sum(1:35,23))
  M(2) = M(2) + ((CI*f(23))/6._/**/REALKIND * den(150)) * TI2_call(3,momenta_41,masses2_9,G3tensor(:,167),T3sum(1:35,23))
  M(1) = M(1) + ((CI*f(24))/6._/**/REALKIND * den(151)) * TI2_call(3,momenta_41,masses2_9,G3tensor(:,168),T3sum(1:35,23))
  M(2) = M(2) + (-(CI*f(24))/6._/**/REALKIND * den(151)) * TI2_call(3,momenta_41,masses2_9,G3tensor(:,168),T3sum(1:35,23))
  M(1) = M(1) + (-(CI*f(23))/6._/**/REALKIND * den(150)) * TI2_call(3,momenta_38,masses2_9,G3tensor(:,169),T3sum(1:35,24))
  M(2) = M(2) + ((CI*f(23))/6._/**/REALKIND * den(150)) * TI2_call(3,momenta_38,masses2_9,G3tensor(:,169),T3sum(1:35,24))
  M(1) = M(1) + ((CI*f(24))/6._/**/REALKIND * den(151)) * TI2_call(3,momenta_38,masses2_9,G3tensor(:,170),T3sum(1:35,24))
  M(2) = M(2) + (-(CI*f(24))/6._/**/REALKIND * den(151)) * TI2_call(3,momenta_38,masses2_9,G3tensor(:,170),T3sum(1:35,24))
  M(1) = M(1) + ((3*f(25))/2._/**/REALKIND * den(150)) * TI2_call(3,momenta_67,masses2_9,G3tensor(:,175),T3sum(1:35,1))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(150)) * TI2_call(3,momenta_67,masses2_9,G3tensor(:,175),T3sum(1:35,1))
  M(1) = M(1) + ((-3*f(26))/2._/**/REALKIND * den(151)) * TI2_call(3,momenta_67,masses2_9,G3tensor(:,176),T3sum(1:35,1))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(151)) * TI2_call(3,momenta_67,masses2_9,G3tensor(:,176),T3sum(1:35,1))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,61),T3sum(1:35,25))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,61),T3sum(1:35,25))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,71),T3sum(1:35,26))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(126)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,71),T3sum(1:35,26))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,38),T3sum(1:35,25))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,38),T3sum(1:35,25))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,48),T3sum(1:35,26))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(126)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,48),T3sum(1:35,26))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,61),T3sum(1:35,25))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,61),T3sum(1:35,25))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,91),T3sum(1:35,27))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(126)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,91),T3sum(1:35,27))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,38),T3sum(1:35,25))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,38),T3sum(1:35,25))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,81),T3sum(1:35,27))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(126)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,81),T3sum(1:35,27))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,62),T3sum(1:35,25))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,62),T3sum(1:35,25))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,72),T3sum(1:35,26))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,72),T3sum(1:35,26))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,39),T3sum(1:35,25))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,39),T3sum(1:35,25))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,49),T3sum(1:35,26))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,49),T3sum(1:35,26))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,62),T3sum(1:35,25))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,62),T3sum(1:35,25))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,92),T3sum(1:35,27))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,92),T3sum(1:35,27))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,39),T3sum(1:35,25))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,39),T3sum(1:35,25))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(127)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,82),T3sum(1:35,27))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,82),T3sum(1:35,27))
  M(1) = M(1) + ((-3*CI*f(23))/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,181),T3sum(1:35,25))
  M(2) = M(2) + ((3*CI*f(23))/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,181),T3sum(1:35,25))
  M(1) = M(1) + ((3*CI*f(23))/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,185),T3sum(1:35,25))
  M(2) = M(2) + ((-3*CI*f(23))/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,185),T3sum(1:35,25))
  M(1) = M(1) + ((3*CI*f(24))/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,182),T3sum(1:35,25))
  M(2) = M(2) + ((-3*CI*f(24))/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,182),T3sum(1:35,25))
  M(1) = M(1) + ((-3*CI*f(24))/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,186),T3sum(1:35,25))
  M(2) = M(2) + ((3*CI*f(24))/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,186),T3sum(1:35,25))
  M(1) = M(1) + ((3*CI*f(23))/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,155),T3sum(1:35,25))
  M(2) = M(2) + ((-3*CI*f(23))/2._/**/REALKIND * den(126)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,155),T3sum(1:35,25))
  M(1) = M(1) + ((-3*CI*f(24))/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,156),T3sum(1:35,25))
  M(2) = M(2) + ((3*CI*f(24))/2._/**/REALKIND * den(127)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,156),T3sum(1:35,25))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(128)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,75),T2sum(1:15,7))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(129)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,76),T2sum(1:15,7))
  M(2) = M(2) + ((3*CI*f(23))/2._/**/REALKIND * den(128)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,21),T2sum(1:15,8))
  M(2) = M(2) + ((-3*CI*f(24))/2._/**/REALKIND * den(129)) * TI2_call(2,momenta_25,masses2_6,G2tensor(:,22),T2sum(1:15,8))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(130)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,77),T2sum(1:15,17))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(131)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,78),T2sum(1:15,17))
  M(1) = M(1) + ((3*CI*f(23))/2._/**/REALKIND * den(130)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,47),T2sum(1:15,18))
  M(1) = M(1) + ((-3*CI*f(24))/2._/**/REALKIND * den(131)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,48),T2sum(1:15,18))
  M(3) = M(3) + ((CI*f(23))/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_57,masses2_9,G3tensor(:,107),T3sum(1:35,28))
  M(3) = M(3) + (-(CI*f(24))/2._/**/REALKIND * den(23)) * TI2_call(3,momenta_57,masses2_9,G3tensor(:,108),T3sum(1:35,28))
  M(3) = M(3) + ((CI*f(23))/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_46,masses2_9,G3tensor(:,163),T3sum(1:35,29))
  M(3) = M(3) + (-(CI*f(24))/2._/**/REALKIND * den(23)) * TI2_call(3,momenta_46,masses2_9,G3tensor(:,164),T3sum(1:35,29))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(21)) * TI2_call(3,momenta_39,masses2_9,G3tensor(:,171),T3sum(1:35,30))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(21)) * TI2_call(3,momenta_39,masses2_9,G3tensor(:,171),T3sum(1:35,30))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(23)) * TI2_call(3,momenta_39,masses2_9,G3tensor(:,172),T3sum(1:35,30))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(23)) * TI2_call(3,momenta_39,masses2_9,G3tensor(:,172),T3sum(1:35,30))
  M(1) = M(1) + ((-3*f(25))/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_59,masses2_9,G3tensor(:,109),T3sum(1:35,31))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(21)) * TI2_call(3,momenta_59,masses2_9,G3tensor(:,109),T3sum(1:35,31))
  M(1) = M(1) + ((3*f(26))/2._/**/REALKIND * den(23)) * TI2_call(3,momenta_59,masses2_9,G3tensor(:,110),T3sum(1:35,31))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(23)) * TI2_call(3,momenta_59,masses2_9,G3tensor(:,110),T3sum(1:35,31))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(21)) * TI2_call(3,momenta_40,masses2_9,G3tensor(:,173),T3sum(1:35,32))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(21)) * TI2_call(3,momenta_40,masses2_9,G3tensor(:,173),T3sum(1:35,32))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(23)) * TI2_call(3,momenta_40,masses2_9,G3tensor(:,174),T3sum(1:35,32))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(23)) * TI2_call(3,momenta_40,masses2_9,G3tensor(:,174),T3sum(1:35,32))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_49,masses2_9,G3tensor(:,157),T3sum(1:35,33))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(21)) * TI2_call(3,momenta_49,masses2_9,G3tensor(:,157),T3sum(1:35,33))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(23)) * TI2_call(3,momenta_49,masses2_9,G3tensor(:,158),T3sum(1:35,33))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(23)) * TI2_call(3,momenta_49,masses2_9,G3tensor(:,158),T3sum(1:35,33))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,63),T3sum(1:35,25))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,63),T3sum(1:35,25))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,73),T3sum(1:35,26))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(132)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,73),T3sum(1:35,26))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,40),T3sum(1:35,25))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,40),T3sum(1:35,25))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,50),T3sum(1:35,26))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(132)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,50),T3sum(1:35,26))
  M(1) = M(1) + (f(35)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,63),T3sum(1:35,25))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,63),T3sum(1:35,25))
  M(1) = M(1) + (f(33)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,93),T3sum(1:35,27))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(132)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,93),T3sum(1:35,27))
  M(2) = M(2) + (f(35)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,40),T3sum(1:35,25))
  M(3) = M(3) + (-(f(35)/6._/**/REALKIND) * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,40),T3sum(1:35,25))
  M(2) = M(2) + (f(33)/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,83),T3sum(1:35,27))
  M(3) = M(3) + (-(f(33)/6._/**/REALKIND) * den(132)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,83),T3sum(1:35,27))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,64),T3sum(1:35,25))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,64),T3sum(1:35,25))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,74),T3sum(1:35,26))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,74),T3sum(1:35,26))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,41),T3sum(1:35,25))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,41),T3sum(1:35,25))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,51),T3sum(1:35,26))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_5,G3tensor(:,51),T3sum(1:35,26))
  M(1) = M(1) + (-(f(36)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,64),T3sum(1:35,25))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,64),T3sum(1:35,25))
  M(1) = M(1) + (-(f(34)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,94),T3sum(1:35,27))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,94),T3sum(1:35,27))
  M(2) = M(2) + (-(f(36)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,41),T3sum(1:35,25))
  M(3) = M(3) + (f(36)/6._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,41),T3sum(1:35,25))
  M(2) = M(2) + (-(f(34)/2._/**/REALKIND) * den(133)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,84),T3sum(1:35,27))
  M(3) = M(3) + (f(34)/6._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_4,G3tensor(:,84),T3sum(1:35,27))
  M(1) = M(1) + ((-3*CI*f(23))/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,183),T3sum(1:35,25))
  M(2) = M(2) + ((3*CI*f(23))/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,183),T3sum(1:35,25))
  M(1) = M(1) + ((3*CI*f(23))/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,187),T3sum(1:35,25))
  M(2) = M(2) + ((-3*CI*f(23))/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,187),T3sum(1:35,25))
  M(1) = M(1) + ((3*CI*f(24))/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,184),T3sum(1:35,25))
  M(2) = M(2) + ((-3*CI*f(24))/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,184),T3sum(1:35,25))
  M(1) = M(1) + ((-3*CI*f(24))/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,188),T3sum(1:35,25))
  M(2) = M(2) + ((3*CI*f(24))/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,188),T3sum(1:35,25))
  M(1) = M(1) + ((3*CI*f(23))/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,159),T3sum(1:35,25))
  M(2) = M(2) + ((-3*CI*f(23))/2._/**/REALKIND * den(132)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,159),T3sum(1:35,25))
  M(1) = M(1) + ((-3*CI*f(24))/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,160),T3sum(1:35,25))
  M(2) = M(2) + ((3*CI*f(24))/2._/**/REALKIND * den(133)) * TI2_call(3,momenta_13,masses2_6,G3tensor(:,160),T3sum(1:35,25))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(134)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,79),T2sum(1:15,13))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(135)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,80),T2sum(1:15,13))
  M(1) = M(1) + ((-3*CI*f(23))/2._/**/REALKIND * den(134)) * TI2_call(2,momenta_27,masses2_6,G2tensor(:,23),T2sum(1:15,14))
  M(1) = M(1) + ((3*CI*f(24))/2._/**/REALKIND * den(135)) * TI2_call(2,momenta_27,masses2_6,G2tensor(:,24),T2sum(1:15,14))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(136)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,81),T2sum(1:15,21))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(137)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,82),T2sum(1:15,21))
  M(2) = M(2) + ((-3*CI*f(23))/2._/**/REALKIND * den(136)) * TI2_call(2,momenta_17,masses2_6,G2tensor(:,49),T2sum(1:15,22))
  M(2) = M(2) + ((3*CI*f(24))/2._/**/REALKIND * den(137)) * TI2_call(2,momenta_17,masses2_6,G2tensor(:,50),T2sum(1:15,22))
  M(3) = M(3) + ((CI*f(23))/2._/**/REALKIND * den(10)) * TI2_call(3,momenta_58,masses2_9,G3tensor(:,113),T3sum(1:35,34))
  M(3) = M(3) + (-(CI*f(24))/2._/**/REALKIND * den(12)) * TI2_call(3,momenta_58,masses2_9,G3tensor(:,114),T3sum(1:35,34))
  M(3) = M(3) + ((CI*f(23))/2._/**/REALKIND * den(10)) * TI2_call(3,momenta_47,masses2_9,G3tensor(:,165),T3sum(1:35,35))
  M(3) = M(3) + (-(CI*f(24))/2._/**/REALKIND * den(12)) * TI2_call(3,momenta_47,masses2_9,G3tensor(:,166),T3sum(1:35,35))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(10)) * TI2_call(3,momenta_43,masses2_9,G3tensor(:,177),T3sum(1:35,36))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(10)) * TI2_call(3,momenta_43,masses2_9,G3tensor(:,177),T3sum(1:35,36))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(12)) * TI2_call(3,momenta_43,masses2_9,G3tensor(:,179),T3sum(1:35,36))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(12)) * TI2_call(3,momenta_43,masses2_9,G3tensor(:,179),T3sum(1:35,36))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(10)) * TI2_call(3,momenta_50,masses2_9,G3tensor(:,161),T3sum(1:35,37))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(10)) * TI2_call(3,momenta_50,masses2_9,G3tensor(:,161),T3sum(1:35,37))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(12)) * TI2_call(3,momenta_50,masses2_9,G3tensor(:,162),T3sum(1:35,37))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(12)) * TI2_call(3,momenta_50,masses2_9,G3tensor(:,162),T3sum(1:35,37))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(10)) * TI2_call(3,momenta_42,masses2_9,G3tensor(:,178),T3sum(1:35,38))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(10)) * TI2_call(3,momenta_42,masses2_9,G3tensor(:,178),T3sum(1:35,38))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(12)) * TI2_call(3,momenta_42,masses2_9,G3tensor(:,180),T3sum(1:35,38))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(12)) * TI2_call(3,momenta_42,masses2_9,G3tensor(:,180),T3sum(1:35,38))
  M(1) = M(1) + ((-3*f(25))/2._/**/REALKIND * den(10)) * TI2_call(3,momenta_60,masses2_9,G3tensor(:,111),T3sum(1:35,39))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(10)) * TI2_call(3,momenta_60,masses2_9,G3tensor(:,111),T3sum(1:35,39))
  M(1) = M(1) + ((3*f(26))/2._/**/REALKIND * den(12)) * TI2_call(3,momenta_60,masses2_9,G3tensor(:,112),T3sum(1:35,39))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(12)) * TI2_call(3,momenta_60,masses2_9,G3tensor(:,112),T3sum(1:35,39))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(1)) * TI2_call(4,momenta_72,masses2_10,G4tensor(:,65),T4sum(1:70,10))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_72,masses2_10,G4tensor(:,65),T4sum(1:70,10))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(6)) * TI2_call(4,momenta_72,masses2_10,G4tensor(:,66),T4sum(1:70,10))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_72,masses2_10,G4tensor(:,66),T4sum(1:70,10))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(1)) * TI2_call(4,momenta_69,masses2_10,G4tensor(:,55),T4sum(1:70,11))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_69,masses2_10,G4tensor(:,55),T4sum(1:70,11))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(6)) * TI2_call(4,momenta_69,masses2_10,G4tensor(:,57),T4sum(1:70,11))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_69,masses2_10,G4tensor(:,57),T4sum(1:70,11))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(1)) * TI2_call(4,momenta_70,masses2_10,G4tensor(:,61),T4sum(1:70,12))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_70,masses2_10,G4tensor(:,61),T4sum(1:70,12))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(6)) * TI2_call(4,momenta_70,masses2_10,G4tensor(:,62),T4sum(1:70,12))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_70,masses2_10,G4tensor(:,62),T4sum(1:70,12))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(1)) * TI2_call(4,momenta_68,masses2_10,G4tensor(:,56),T4sum(1:70,13))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_68,masses2_10,G4tensor(:,56),T4sum(1:70,13))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(6)) * TI2_call(4,momenta_68,masses2_10,G4tensor(:,58),T4sum(1:70,13))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_68,masses2_10,G4tensor(:,58),T4sum(1:70,13))
  M(1) = M(1) + (f(25)/6._/**/REALKIND * den(1)) * TI2_call(4,momenta_71,masses2_10,G4tensor(:,59),T4sum(1:70,14))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_71,masses2_10,G4tensor(:,59),T4sum(1:70,14))
  M(1) = M(1) + (-(f(26)/6._/**/REALKIND) * den(6)) * TI2_call(4,momenta_71,masses2_10,G4tensor(:,60),T4sum(1:70,14))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_71,masses2_10,G4tensor(:,60),T4sum(1:70,14))
  M(2) = M(2) + (f(25)/6._/**/REALKIND * den(1)) * TI2_call(4,momenta_73,masses2_10,G4tensor(:,63),T4sum(1:70,15))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_73,masses2_10,G4tensor(:,63),T4sum(1:70,15))
  M(2) = M(2) + (-(f(26)/6._/**/REALKIND) * den(6)) * TI2_call(4,momenta_73,masses2_10,G4tensor(:,64),T4sum(1:70,15))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_73,masses2_10,G4tensor(:,64),T4sum(1:70,15))
  M(3) = M(3) + ((CI*f(23))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_74,masses2_10,G4tensor(:,53),T4sum(1:70,16))
  M(3) = M(3) + (-(CI*f(24))/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_74,masses2_10,G4tensor(:,54),T4sum(1:70,16))
  M(3) = M(3) + ((CI*f(23))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_77,masses2_10,G4tensor(:,45),T4sum(1:70,17))
  M(3) = M(3) + (-(CI*f(24))/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_77,masses2_10,G4tensor(:,46),T4sum(1:70,17))
  M(3) = M(3) + ((CI*f(23))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_75,masses2_10,G4tensor(:,51),T4sum(1:70,18))
  M(3) = M(3) + (-(CI*f(24))/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_75,masses2_10,G4tensor(:,52),T4sum(1:70,18))
  M(2) = M(2) + ((-3*f(25))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_76,masses2_10,G4tensor(:,49),T4sum(1:70,19))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_76,masses2_10,G4tensor(:,49),T4sum(1:70,19))
  M(2) = M(2) + ((3*f(26))/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_76,masses2_10,G4tensor(:,50),T4sum(1:70,19))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_76,masses2_10,G4tensor(:,50),T4sum(1:70,19))
  M(3) = M(3) + ((CI*f(23))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_78,masses2_10,G4tensor(:,43),T4sum(1:70,20))
  M(3) = M(3) + (-(CI*f(24))/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_78,masses2_10,G4tensor(:,44),T4sum(1:70,20))
  M(1) = M(1) + ((-3*f(25))/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_79,masses2_10,G4tensor(:,47),T4sum(1:70,21))
  M(3) = M(3) + (-(f(25)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_79,masses2_10,G4tensor(:,47),T4sum(1:70,21))
  M(1) = M(1) + ((3*f(26))/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_79,masses2_10,G4tensor(:,48),T4sum(1:70,21))
  M(3) = M(3) + (f(26)/2._/**/REALKIND * den(6)) * TI2_call(4,momenta_79,masses2_10,G4tensor(:,48),T4sum(1:70,21))
  M(1) = M(1) + ((3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,65),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,65),T1sum(1:5,1))
  M(1) = M(1) + ((-3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,66),T1sum(1:5,1))
  M(2) = M(2) + ((3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,66),T1sum(1:5,1))
  M(1) = M(1) + (-3*CI*f(21) * den(126)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,67),T1sum(1:5,1))
  M(2) = M(2) + (3*CI*f(21) * den(126)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,67),T1sum(1:5,1))
  M(1) = M(1) + ((-3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,68),T1sum(1:5,1))
  M(2) = M(2) + ((3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,68),T1sum(1:5,1))
  M(1) = M(1) + ((3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,69),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,69),T1sum(1:5,1))
  M(1) = M(1) + (3*CI*f(22) * den(127)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,70),T1sum(1:5,1))
  M(2) = M(2) + (-3*CI*f(22) * den(127)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,70),T1sum(1:5,1))
  M(1) = M(1) + ((3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,71),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,71),T1sum(1:5,1))
  M(1) = M(1) + ((-3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,72),T1sum(1:5,1))
  M(2) = M(2) + ((3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,72),T1sum(1:5,1))
  M(1) = M(1) + (-3*CI*f(21) * den(132)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,73),T1sum(1:5,1))
  M(2) = M(2) + (3*CI*f(21) * den(132)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,73),T1sum(1:5,1))
  M(1) = M(1) + ((-3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,74),T1sum(1:5,1))
  M(2) = M(2) + ((3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,74),T1sum(1:5,1))
  M(1) = M(1) + ((3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,75),T1sum(1:5,1))
  M(2) = M(2) + ((-3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,75),T1sum(1:5,1))
  M(1) = M(1) + (3*CI*f(22) * den(133)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,76),T1sum(1:5,1))
  M(2) = M(2) + (-3*CI*f(22) * den(133)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,76),T1sum(1:5,1))
  M(1) = M(1) + ((-3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,29),T1sum(1:5,2))
  M(2) = M(2) + ((3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,29),T1sum(1:5,2))
  M(1) = M(1) + ((3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,30),T1sum(1:5,2))
  M(2) = M(2) + ((-3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,30),T1sum(1:5,2))
  M(1) = M(1) + (3*CI*f(21) * den(126)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,31),T1sum(1:5,2))
  M(2) = M(2) + (-3*CI*f(21) * den(126)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,31),T1sum(1:5,2))
  M(1) = M(1) + ((3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,32),T1sum(1:5,2))
  M(2) = M(2) + ((-3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,32),T1sum(1:5,2))
  M(1) = M(1) + ((-3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,33),T1sum(1:5,2))
  M(2) = M(2) + ((3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,33),T1sum(1:5,2))
  M(1) = M(1) + (-3*CI*f(22) * den(127)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,34),T1sum(1:5,2))
  M(2) = M(2) + (3*CI*f(22) * den(127)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,34),T1sum(1:5,2))
  M(1) = M(1) + ((-3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,35),T1sum(1:5,2))
  M(2) = M(2) + ((3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,35),T1sum(1:5,2))
  M(1) = M(1) + ((3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,36),T1sum(1:5,2))
  M(2) = M(2) + ((-3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,36),T1sum(1:5,2))
  M(1) = M(1) + (3*CI*f(21) * den(132)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,37),T1sum(1:5,2))
  M(2) = M(2) + (-3*CI*f(21) * den(132)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,37),T1sum(1:5,2))
  M(1) = M(1) + ((3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,38),T1sum(1:5,2))
  M(2) = M(2) + ((-3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,38),T1sum(1:5,2))
  M(1) = M(1) + ((-3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,39),T1sum(1:5,2))
  M(2) = M(2) + ((3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,39),T1sum(1:5,2))
  M(1) = M(1) + (-3*CI*f(22) * den(133)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,40),T1sum(1:5,2))
  M(2) = M(2) + (3*CI*f(22) * den(133)) * TI2_call(1,momenta_1,masses2_3,G1tensor(:,40),T1sum(1:5,2))
  M(1) = M(1) + ((-3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,5),T2sum(1:5,25))
  M(2) = M(2) + ((3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,5),T2sum(1:5,25))
  M(1) = M(1) + ((3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,13),T2sum(1:5,25))
  M(2) = M(2) + ((-3*CI*f(21))/2._/**/REALKIND * den(126)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,13),T2sum(1:5,25))
  M(1) = M(1) + (3*CI*f(21) * den(126)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,21),T2sum(1:5,25))
  M(2) = M(2) + (-3*CI*f(21) * den(126)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,21),T2sum(1:5,25))
  M(1) = M(1) + ((3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,6),T2sum(1:5,25))
  M(2) = M(2) + ((-3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,6),T2sum(1:5,25))
  M(1) = M(1) + ((-3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,14),T2sum(1:5,25))
  M(2) = M(2) + ((3*CI*f(22))/2._/**/REALKIND * den(127)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,14),T2sum(1:5,25))
  M(1) = M(1) + (-3*CI*f(22) * den(127)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,22),T2sum(1:5,25))
  M(2) = M(2) + (3*CI*f(22) * den(127)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,22),T2sum(1:5,25))
  M(1) = M(1) + ((-3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,7),T2sum(1:5,25))
  M(2) = M(2) + ((3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,7),T2sum(1:5,25))
  M(1) = M(1) + ((3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,15),T2sum(1:5,25))
  M(2) = M(2) + ((-3*CI*f(21))/2._/**/REALKIND * den(132)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,15),T2sum(1:5,25))
  M(1) = M(1) + (3*CI*f(21) * den(132)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,23),T2sum(1:5,25))
  M(2) = M(2) + (-3*CI*f(21) * den(132)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,23),T2sum(1:5,25))
  M(1) = M(1) + ((3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,8),T2sum(1:5,25))
  M(2) = M(2) + ((-3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,8),T2sum(1:5,25))
  M(1) = M(1) + ((-3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,16),T2sum(1:5,25))
  M(2) = M(2) + ((3*CI*f(22))/2._/**/REALKIND * den(133)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,16),T2sum(1:5,25))
  M(1) = M(1) + (-3*CI*f(22) * den(133)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,24),T2sum(1:5,25))
  M(2) = M(2) + (3*CI*f(22) * den(133)) * TI2_call(1,momenta_7,masses2_3,G1tensor(:,24),T2sum(1:5,25))
  M(2) = M(2) + ((-4*f(25))/3._/**/REALKIND * den(81)) * TI2_call(1,momenta_4,masses2_3,G1tensor(:,25),T1sum(1:5,3))
  M(2) = M(2) + ((4*f(26))/3._/**/REALKIND * den(83)) * TI2_call(1,momenta_4,masses2_3,G1tensor(:,26),T1sum(1:5,3))
  M(2) = M(2) + ((-4*f(25))/3._/**/REALKIND * den(75)) * TI2_call(1,momenta_5,masses2_3,G1tensor(:,55),T1sum(1:5,4))
  M(2) = M(2) + ((4*f(26))/3._/**/REALKIND * den(78)) * TI2_call(1,momenta_5,masses2_3,G1tensor(:,56),T1sum(1:5,4))
  M(2) = M(2) + ((-4*f(25))/3._/**/REALKIND * den(87)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,41),T1sum(1:5,5))
  M(2) = M(2) + ((4*f(26))/3._/**/REALKIND * den(88)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,42),T1sum(1:5,5))
  M(2) = M(2) + ((-4*f(25))/3._/**/REALKIND * den(152)) * TI2_call(1,momenta_5,masses2_3,G1tensor(:,63),T1sum(1:5,4))
  M(2) = M(2) + ((4*f(26))/3._/**/REALKIND * den(153)) * TI2_call(1,momenta_5,masses2_3,G1tensor(:,64),T1sum(1:5,4))
  M(1) = M(1) + ((-4*f(25))/3._/**/REALKIND * den(98)) * TI2_call(1,momenta_3,masses2_3,G1tensor(:,51),T1sum(1:5,6))
  M(1) = M(1) + ((4*f(26))/3._/**/REALKIND * den(100)) * TI2_call(1,momenta_3,masses2_3,G1tensor(:,52),T1sum(1:5,6))
  M(1) = M(1) + ((-4*f(25))/3._/**/REALKIND * den(92)) * TI2_call(1,momenta_2,masses2_3,G1tensor(:,43),T1sum(1:5,7))
  M(1) = M(1) + ((4*f(26))/3._/**/REALKIND * den(95)) * TI2_call(1,momenta_2,masses2_3,G1tensor(:,44),T1sum(1:5,7))
  M(1) = M(1) + ((-4*f(25))/3._/**/REALKIND * den(154)) * TI2_call(1,momenta_3,masses2_3,G1tensor(:,61),T1sum(1:5,6))
  M(1) = M(1) + ((4*f(26))/3._/**/REALKIND * den(155)) * TI2_call(1,momenta_3,masses2_3,G1tensor(:,62),T1sum(1:5,6))
  M(1) = M(1) + ((-4*f(25))/3._/**/REALKIND * den(101)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,47),T1sum(1:5,8))
  M(1) = M(1) + ((4*f(26))/3._/**/REALKIND * den(102)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,48),T1sum(1:5,8))
  M(1) = M(1) + ((-4*f(25))/3._/**/REALKIND * den(109)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,49),T1sum(1:5,5))
  M(1) = M(1) + ((4*f(26))/3._/**/REALKIND * den(110)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,50),T1sum(1:5,5))
  M(1) = M(1) + ((-4*f(25))/3._/**/REALKIND * den(156)) * TI2_call(1,momenta_2,masses2_3,G1tensor(:,45),T1sum(1:5,7))
  M(1) = M(1) + ((4*f(26))/3._/**/REALKIND * den(157)) * TI2_call(1,momenta_2,masses2_3,G1tensor(:,46),T1sum(1:5,7))
  M(2) = M(2) + ((-4*f(25))/3._/**/REALKIND * den(158)) * TI2_call(1,momenta_4,masses2_3,G1tensor(:,27),T1sum(1:5,3))
  M(2) = M(2) + ((4*f(26))/3._/**/REALKIND * den(159)) * TI2_call(1,momenta_4,masses2_3,G1tensor(:,28),T1sum(1:5,3))
  M(2) = M(2) + ((-4*f(25))/3._/**/REALKIND * den(111)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,53),T1sum(1:5,8))
  M(2) = M(2) + ((4*f(26))/3._/**/REALKIND * den(112)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,54),T1sum(1:5,8))
  M(1) = M(1) + (3*CI*f(21) * den(160)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,65),T2sum(1:15,25))
  M(2) = M(2) + (-3*CI*f(21) * den(160)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,65),T2sum(1:15,25))
  M(1) = M(1) + (-3*CI*f(22) * den(161)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,66),T2sum(1:15,25))
  M(2) = M(2) + (3*CI*f(22) * den(161)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,66),T2sum(1:15,25))
  M(1) = M(1) + ((4*CI*f(23))/3._/**/REALKIND * den(116)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,59),T1sum(1:5,8))
  M(2) = M(2) + ((-4*CI*f(23))/3._/**/REALKIND * den(116)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,59),T1sum(1:5,8))
  M(1) = M(1) + ((-4*CI*f(24))/3._/**/REALKIND * den(117)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,60),T1sum(1:5,8))
  M(2) = M(2) + ((4*CI*f(24))/3._/**/REALKIND * den(117)) * TI2_call(1,momenta_9,masses2_3,G1tensor(:,60),T1sum(1:5,8))
  M(1) = M(1) + (3*CI*f(21) * den(162)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,67),T2sum(1:15,25))
  M(2) = M(2) + (-3*CI*f(21) * den(162)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,67),T2sum(1:15,25))
  M(1) = M(1) + (-3*CI*f(22) * den(163)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,68),T2sum(1:15,25))
  M(2) = M(2) + (3*CI*f(22) * den(163)) * TI2_call(2,momenta_7,masses2_3,G2tensor(:,68),T2sum(1:15,25))
  M(1) = M(1) + ((4*CI*f(23))/3._/**/REALKIND * den(118)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,57),T1sum(1:5,5))
  M(2) = M(2) + ((-4*CI*f(23))/3._/**/REALKIND * den(118)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,57),T1sum(1:5,5))
  M(1) = M(1) + ((-4*CI*f(24))/3._/**/REALKIND * den(119)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,58),T1sum(1:5,5))
  M(2) = M(2) + ((4*CI*f(24))/3._/**/REALKIND * den(119)) * TI2_call(1,momenta_8,masses2_3,G1tensor(:,58),T1sum(1:5,5))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pplljj2_eexuuxgg_1_/**/REALKIND
