
module ol_vamp_1_pplljj2_eexuuxbbx_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplljj2_eexuuxbbx_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplljj2_eexuuxbbx_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pplljj2_eexuuxbbx_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pplljj2_eexuuxbbx_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,27) :: G0
  complex(REALKIND), dimension(4,5,4,113) :: G1
  complex(REALKIND), dimension(4,15,4,83) :: G2
  complex(REALKIND), dimension(4,35,4,18) :: G3
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G1tensorhel(5,8,64))
    allocate(G2tensorhel(15,88,64))
    allocate(G3tensorhel(35,30,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,14),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,60),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,7),G2(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,7),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),ZERO,G3tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,12),ZERO,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,14),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,60),ZERO,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),ZERO,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,5),wf(:,7),G2(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,63),ZERO,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,5),wf(:,7),G2(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),ZERO,G3tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,12),MB,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,14),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,60),MB,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,1),G2(:,:,:,10))
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),MB,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,7),G2(:,:,:,11),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,63),MB,G3tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MB,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,14),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,60),MB,G2(:,:,:,12))
  call loop_QV_A(G2(:,:,:,12),wf(:,1),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,63),MB,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,12),wf(:,7),G2(:,:,:,14),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MB,G3tensor(:,10))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,32),MB,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,2),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,44),MB,G2(:,:,:,15))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,5),G2tensor(:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,9),G2tensor(:,2))
  call loop_AV_Q(G2(:,:,:,15),wf(:,1),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,47),MB,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,-4),G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,7),G2(:,:,:,17),gZd)
  call loop_A_Q(G2(:,:,:,17),Q(:,47),MB,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,-4),G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,9),wf(:,1),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,35),MB,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,12),G2tensor(:,3))
  call loop_AV_Q(G2(:,:,:,18),wf(:,2),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,47),MB,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-4),G3tensor(:,13))
  call loop_AQ_V(G2(:,:,:,18),wf(:,-4),G2(:,:,:,20))
  call loop_VA_Q(G2(:,:,:,20),wf(:,-3),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,59),ZERO,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,-2),G3tensor(:,14))
  call loop_AZ_Q(G1(:,:,:,9),wf(:,7),G1(:,:,:,12),gZd)
  call loop_A_Q(G1(:,:,:,12),Q(:,35),MB,G2(:,:,:,22))
  call check_last_AQ_V(l_switch,G2(:,:,:,22),wf(:,12),G2tensor(:,4))
  call loop_AV_Q(G2(:,:,:,22),wf(:,2),G2(:,:,:,23))
  call loop_A_Q(G2(:,:,:,23),Q(:,47),MB,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,-4),G3tensor(:,15))
  call loop_AQ_V(G2(:,:,:,22),wf(:,-4),G2(:,:,:,24))
  call loop_VA_Q(G2(:,:,:,24),wf(:,-3),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,59),ZERO,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,-2),G3tensor(:,16))
  call loop_AV_Q(G1(:,:,:,9),wf(:,63),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,47),MB,G2(:,:,:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,26),wf(:,-4),G2tensor(:,5))
  call loop_AV_Q(G1(:,:,:,9),wf(:,64),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,47),MB,G2(:,:,:,27))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,-4),G2tensor(:,6))
  call loop_AQ_V(G1(:,:,:,9),wf(:,-4),G1(:,:,:,15))
  call loop_VA_Q(G1(:,:,:,15),wf(:,-3),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,56),ZERO,G2(:,:,:,28))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,17),G2tensor(:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,19),G2tensor(:,8))
  call loop_AV_Q(G2(:,:,:,28),wf(:,1),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,59),ZERO,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,-2),G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,28),wf(:,7),G2(:,:,:,30),gZu)
  call loop_A_Q(G2(:,:,:,30),Q(:,59),ZERO,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,-2),G3tensor(:,18))
  call loop_VA_Q(G1(:,:,:,15),wf(:,42),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,59),ZERO,G2(:,:,:,31))
  call check_last_AQ_V(l_switch,G2(:,:,:,31),wf(:,-2),G2tensor(:,9))
  call loop_VA_Q(G1(:,:,:,15),wf(:,43),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,59),ZERO,G2(:,:,:,32))
  call check_last_AQ_V(l_switch,G2(:,:,:,32),wf(:,-2),G2tensor(:,10))
  call loop_AV_Q(G1(:,:,:,9),wf(:,65),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,47),MB,G2(:,:,:,33))
  call check_last_AQ_V(l_switch,G2(:,:,:,33),wf(:,-4),G2tensor(:,11))
  call loop_AV_Q(G1(:,:,:,9),wf(:,66),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,47),MB,G2(:,:,:,34))
  call check_last_AQ_V(l_switch,G2(:,:,:,34),wf(:,-4),G2tensor(:,12))
  call loop_AQ_V(G1(:,:,:,9),wf(:,5),G1(:,:,:,21))
  call loop_VA_Q(G1(:,:,:,21),wf(:,-3),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,59),ZERO,G2(:,:,:,35))
  call check_last_AQ_V(l_switch,G2(:,:,:,35),wf(:,-2),G2tensor(:,13))
  call loop_AQ_V(G1(:,:,:,9),wf(:,9),G1(:,:,:,23))
  call loop_VA_Q(G1(:,:,:,23),wf(:,-3),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,59),ZERO,G2(:,:,:,36))
  call check_last_AQ_V(l_switch,G2(:,:,:,36),wf(:,-2),G2tensor(:,14))
  call loop_VQ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,19),MB,G1(:,:,:,25))
  call loop_QA_V(G1(:,:,:,25),wf(:,-5),G1(:,:,:,26))
  call check_last_UV_W(l_switch,G1(:,:,:,26),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,15))
  call loop_VA_Q(G1(:,:,:,26),wf(:,-3),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,59),ZERO,G2(:,:,:,37))
  call check_last_AQ_V(l_switch,G2(:,:,:,37),wf(:,-2),G2tensor(:,16))
  call loop_VQ_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,19),MB,G1(:,:,:,28))
  call loop_QA_V(G1(:,:,:,28),wf(:,-5),G1(:,:,:,29))
  call check_last_UV_W(l_switch,G1(:,:,:,29),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,17))
  call loop_VA_Q(G1(:,:,:,29),wf(:,-3),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,59),ZERO,G2(:,:,:,38))
  call check_last_AQ_V(l_switch,G2(:,:,:,38),wf(:,-2),G2tensor(:,18))
  call loop_VA_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,35),MB,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,2),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,47),MB,G2(:,:,:,39))
  call check_last_AQ_V(l_switch,G2(:,:,:,39),wf(:,-4),G2tensor(:,19))
  call loop_AQ_V(G1(:,:,:,31),wf(:,-4),G1(:,:,:,33))
  call loop_VA_Q(G1(:,:,:,33),wf(:,-3),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,59),ZERO,G2(:,:,:,40))
  call check_last_AQ_V(l_switch,G2(:,:,:,40),wf(:,-2),G2tensor(:,20))
  call check_last_AQ_V(l_switch,G1(:,:,:,31),wf(:,12),G1tensor(:,1))
  call loop_VA_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,35),MB,G1(:,:,:,35))
  call loop_AV_Q(G1(:,:,:,35),wf(:,2),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,47),MB,G2(:,:,:,41))
  call check_last_AQ_V(l_switch,G2(:,:,:,41),wf(:,-4),G2tensor(:,21))
  call loop_AQ_V(G1(:,:,:,35),wf(:,-4),G1(:,:,:,37))
  call loop_VA_Q(G1(:,:,:,37),wf(:,-3),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,59),ZERO,G2(:,:,:,42))
  call check_last_AQ_V(l_switch,G2(:,:,:,42),wf(:,-2),G2tensor(:,22))
  call check_last_AQ_V(l_switch,G1(:,:,:,35),wf(:,12),G1tensor(:,2))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,16),MB,G1(:,:,:,39))
  call loop_QA_V(G1(:,:,:,39),wf(:,29),G1(:,:,:,40))
  call check_last_UV_W(l_switch,G1(:,:,:,40),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,23))
  call loop_VA_Q(G1(:,:,:,40),wf(:,-3),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,59),ZERO,G2(:,:,:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,-2),G2tensor(:,24))
  call loop_QA_V(G1(:,:,:,39),wf(:,30),G1(:,:,:,42))
  call check_last_UV_W(l_switch,G1(:,:,:,42),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,25))
  call loop_VA_Q(G1(:,:,:,42),wf(:,-3),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,59),ZERO,G2(:,:,:,44))
  call check_last_AQ_V(l_switch,G2(:,:,:,44),wf(:,-2),G2tensor(:,26))
  call loop_QV_A(G1(:,:,:,39),wf(:,1),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,19),MB,G2(:,:,:,45))
  call loop_QA_V(G2(:,:,:,45),wf(:,-5),G2(:,:,:,46))
  call check_last_UV_W(l_switch,G2(:,:,:,46),Q(:,51),wf(:,2),Q(:,12),G3tensor(:,19))
  call loop_VA_Q(G2(:,:,:,46),wf(:,-3),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,59),ZERO,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,-2),G3tensor(:,20))
  call loop_QZ_A(G1(:,:,:,39),wf(:,7),G1(:,:,:,45),gZd)
  call loop_Q_A(G1(:,:,:,45),Q(:,19),MB,G2(:,:,:,48))
  call loop_QA_V(G2(:,:,:,48),wf(:,-5),G2(:,:,:,49))
  call check_last_UV_W(l_switch,G2(:,:,:,49),Q(:,51),wf(:,2),Q(:,12),G3tensor(:,21))
  call loop_VA_Q(G2(:,:,:,49),wf(:,-3),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,59),ZERO,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,-2),G3tensor(:,22))
  call loop_QA_V(G1(:,:,:,39),wf(:,-5),G1(:,:,:,46))
  call check_last_UV_W(l_switch,G1(:,:,:,46),Q(:,48),wf(:,63),Q(:,15),G2tensor(:,27))
  call check_last_UV_W(l_switch,G1(:,:,:,46),Q(:,48),wf(:,64),Q(:,15),G2tensor(:,28))
  call loop_VA_Q(G1(:,:,:,46),wf(:,-3),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,56),ZERO,G2(:,:,:,51))
  call check_last_AQ_V(l_switch,G2(:,:,:,51),wf(:,17),G2tensor(:,29))
  call check_last_AQ_V(l_switch,G2(:,:,:,51),wf(:,19),G2tensor(:,30))
  call loop_AV_Q(G2(:,:,:,51),wf(:,1),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,59),ZERO,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,-2),G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,51),wf(:,7),G2(:,:,:,53),gZu)
  call loop_A_Q(G2(:,:,:,53),Q(:,59),ZERO,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,-2),G3tensor(:,24))
  call check_last_UV_W(l_switch,G1(:,:,:,46),Q(:,48),wf(:,65),Q(:,15),G2tensor(:,31))
  call check_last_UV_W(l_switch,G1(:,:,:,46),Q(:,48),wf(:,66),Q(:,15),G2tensor(:,32))
  call loop_VA_Q(G1(:,:,:,46),wf(:,42),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,59),ZERO,G2(:,:,:,54))
  call check_last_AQ_V(l_switch,G2(:,:,:,54),wf(:,-2),G2tensor(:,33))
  call loop_VA_Q(G1(:,:,:,46),wf(:,43),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,59),ZERO,G2(:,:,:,55))
  call check_last_AQ_V(l_switch,G2(:,:,:,55),wf(:,-2),G2tensor(:,34))
  call loop_VA_Q(G0(:,:,:,1),wf(:,32),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,44),MB,G1(:,:,:,50))
  call loop_AV_Q(G1(:,:,:,50),wf(:,1),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,47),MB,G2(:,:,:,56))
  call check_last_AQ_V(l_switch,G2(:,:,:,56),wf(:,-4),G2tensor(:,35))
  call loop_AZ_Q(G1(:,:,:,50),wf(:,7),G1(:,:,:,52),gZd)
  call loop_A_Q(G1(:,:,:,52),Q(:,47),MB,G2(:,:,:,57))
  call check_last_AQ_V(l_switch,G2(:,:,:,57),wf(:,-4),G2tensor(:,36))
  call check_last_AQ_V(l_switch,G1(:,:,:,50),wf(:,5),G1tensor(:,3))
  call check_last_AQ_V(l_switch,G1(:,:,:,50),wf(:,9),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,8),ZERO,G1(:,:,:,53))
  call loop_AV_Q(G1(:,:,:,53),wf(:,14),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,56),ZERO,G2(:,:,:,58))
  call check_last_AQ_V(l_switch,G2(:,:,:,58),wf(:,17),G2tensor(:,37))
  call check_last_AQ_V(l_switch,G2(:,:,:,58),wf(:,19),G2tensor(:,38))
  call loop_AV_Q(G2(:,:,:,58),wf(:,1),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,59),ZERO,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,-2),G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,58),wf(:,7),G2(:,:,:,60),gZu)
  call loop_A_Q(G2(:,:,:,60),Q(:,59),ZERO,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,-2),G3tensor(:,26))
  call loop_AV_Q(G1(:,:,:,53),wf(:,1),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,11),ZERO,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,14),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,59),ZERO,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,-2),G3tensor(:,27))
  call loop_AZ_Q(G1(:,:,:,53),wf(:,7),G1(:,:,:,56),gZu)
  call loop_A_Q(G1(:,:,:,56),Q(:,11),ZERO,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,14),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,59),ZERO,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,-2),G3tensor(:,28))
  call loop_AV_Q(G1(:,:,:,53),wf(:,67),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,59),ZERO,G2(:,:,:,65))
  call check_last_AQ_V(l_switch,G2(:,:,:,65),wf(:,-2),G2tensor(:,39))
  call loop_AV_Q(G1(:,:,:,53),wf(:,68),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,59),ZERO,G2(:,:,:,66))
  call check_last_AQ_V(l_switch,G2(:,:,:,66),wf(:,-2),G2tensor(:,40))
  call loop_AV_Q(G1(:,:,:,53),wf(:,69),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,59),ZERO,G2(:,:,:,67))
  call check_last_AQ_V(l_switch,G2(:,:,:,67),wf(:,-2),G2tensor(:,41))
  call loop_AV_Q(G1(:,:,:,53),wf(:,70),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,59),ZERO,G2(:,:,:,68))
  call check_last_AQ_V(l_switch,G2(:,:,:,68),wf(:,-2),G2tensor(:,42))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,48),G1(:,:,:,61))
  call loop_VA_Q(G1(:,:,:,61),wf(:,-3),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,56),ZERO,G2(:,:,:,69))
  call check_last_AQ_V(l_switch,G2(:,:,:,69),wf(:,17),G2tensor(:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,69),wf(:,19),G2tensor(:,44))
  call loop_AV_Q(G2(:,:,:,69),wf(:,1),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,59),ZERO,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,-2),G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,69),wf(:,7),G2(:,:,:,71),gZu)
  call loop_A_Q(G2(:,:,:,71),Q(:,59),ZERO,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,-2),G3tensor(:,30))
  call loop_VA_Q(G1(:,:,:,61),wf(:,42),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,59),ZERO,G2(:,:,:,72))
  call check_last_AQ_V(l_switch,G2(:,:,:,72),wf(:,-2),G2tensor(:,45))
  call loop_VA_Q(G1(:,:,:,61),wf(:,43),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,59),ZERO,G2(:,:,:,73))
  call check_last_AQ_V(l_switch,G2(:,:,:,73),wf(:,-2),G2tensor(:,46))
  call check_last_UV_W(l_switch,G1(:,:,:,61),Q(:,48),wf(:,63),Q(:,15),G2tensor(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,61),Q(:,48),wf(:,64),Q(:,15),G2tensor(:,48))
  call check_last_UV_W(l_switch,G1(:,:,:,61),Q(:,48),wf(:,65),Q(:,15),G2tensor(:,49))
  call check_last_UV_W(l_switch,G1(:,:,:,61),Q(:,48),wf(:,66),Q(:,15),G2tensor(:,50))
  call loop_VA_Q(G0(:,:,:,1),wf(:,42),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,11),ZERO,G1(:,:,:,65))
  call loop_AV_Q(G1(:,:,:,65),wf(:,14),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,59),ZERO,G2(:,:,:,74))
  call check_last_AQ_V(l_switch,G2(:,:,:,74),wf(:,-2),G2tensor(:,51))
  call loop_VA_Q(G0(:,:,:,1),wf(:,43),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,11),ZERO,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,14),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,59),ZERO,G2(:,:,:,75))
  call check_last_AQ_V(l_switch,G2(:,:,:,75),wf(:,-2),G2tensor(:,52))
  call loop_VQ_A(G0(:,:,:,1),wf(:,22),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,52),ZERO,G1(:,:,:,69))
  call loop_QV_A(G1(:,:,:,69),wf(:,1),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,55),ZERO,G2(:,:,:,76))
  call check_last_QA_V(l_switch,G2(:,:,:,76),wf(:,-3),G2tensor(:,53))
  call loop_QZ_A(G1(:,:,:,69),wf(:,7),G1(:,:,:,71),gZu)
  call loop_Q_A(G1(:,:,:,71),Q(:,55),ZERO,G2(:,:,:,77))
  call check_last_QA_V(l_switch,G2(:,:,:,77),wf(:,-3),G2tensor(:,54))
  call check_last_QA_V(l_switch,G1(:,:,:,69),wf(:,42),G1tensor(:,5))
  call check_last_QA_V(l_switch,G1(:,:,:,69),wf(:,43),G1tensor(:,6))
  call loop_VA_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,56),ZERO,G1(:,:,:,72))
  call loop_AV_Q(G1(:,:,:,72),wf(:,1),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,59),ZERO,G2(:,:,:,78))
  call check_last_AQ_V(l_switch,G2(:,:,:,78),wf(:,-2),G2tensor(:,55))
  call loop_AZ_Q(G1(:,:,:,72),wf(:,7),G1(:,:,:,74),gZu)
  call loop_A_Q(G1(:,:,:,74),Q(:,59),ZERO,G2(:,:,:,79))
  call check_last_AQ_V(l_switch,G2(:,:,:,79),wf(:,-2),G2tensor(:,56))
  call check_last_AQ_V(l_switch,G1(:,:,:,72),wf(:,17),G1tensor(:,7))
  call check_last_AQ_V(l_switch,G1(:,:,:,72),wf(:,19),G1tensor(:,8))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,67),Q(:,51),G1(:,:,:,75))
  call loop_VA_Q(G1(:,:,:,75),wf(:,-3),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,59),ZERO,G2(:,:,:,80))
  call check_last_AQ_V(l_switch,G2(:,:,:,80),wf(:,-2),G2tensor(:,57))
  call check_last_UV_W(l_switch,G1(:,:,:,75),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,58))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,68),Q(:,51),G1(:,:,:,77))
  call loop_VA_Q(G1(:,:,:,77),wf(:,-3),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,59),ZERO,G2(:,:,:,81))
  call check_last_AQ_V(l_switch,G2(:,:,:,81),wf(:,-2),G2tensor(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,77),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,60))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,69),Q(:,51),G1(:,:,:,79))
  call loop_VA_Q(G1(:,:,:,79),wf(:,-3),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,59),ZERO,G2(:,:,:,82))
  call check_last_AQ_V(l_switch,G2(:,:,:,82),wf(:,-2),G2tensor(:,61))
  call check_last_UV_W(l_switch,G1(:,:,:,79),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,62))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,70),Q(:,51),G1(:,:,:,81))
  call loop_VA_Q(G1(:,:,:,81),wf(:,-3),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,59),ZERO,G2(:,:,:,83))
  call check_last_AQ_V(l_switch,G2(:,:,:,83),wf(:,-2),G2tensor(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,81),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,67),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,51),ZERO,G1(:,:,:,83))
  call loop_QV_A(G1(:,:,:,83),wf(:,2),G1(:,:,:,84))
  call check_last_Q_A(l_switch,G1(:,:,:,84),Q(:,63),ZERO,G2tensor(:,65))
  call loop_QV_A(G0(:,:,:,1),wf(:,67),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,51),MB,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,2),G1(:,:,:,86))
  call check_last_Q_A(l_switch,G1(:,:,:,86),Q(:,63),MB,G2tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,68),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,51),ZERO,G1(:,:,:,87))
  call loop_QV_A(G1(:,:,:,87),wf(:,2),G1(:,:,:,88))
  call check_last_Q_A(l_switch,G1(:,:,:,88),Q(:,63),ZERO,G2tensor(:,67))
  call loop_QV_A(G0(:,:,:,1),wf(:,68),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,51),MB,G1(:,:,:,89))
  call loop_QV_A(G1(:,:,:,89),wf(:,2),G1(:,:,:,90))
  call check_last_Q_A(l_switch,G1(:,:,:,90),Q(:,63),MB,G2tensor(:,68))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,67),Q(:,51),G1(:,:,:,91))
  call check_last_CV_D(l_switch,G1(:,:,:,91),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,69))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,68),Q(:,51),G1(:,:,:,92))
  call check_last_CV_D(l_switch,G1(:,:,:,92),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,51),ZERO,G1(:,:,:,93))
  call loop_QV_A(G1(:,:,:,93),wf(:,2),G1(:,:,:,94))
  call check_last_Q_A(l_switch,G1(:,:,:,94),Q(:,63),ZERO,G2tensor(:,71))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,51),MB,G1(:,:,:,95))
  call loop_QV_A(G1(:,:,:,95),wf(:,2),G1(:,:,:,96))
  call check_last_Q_A(l_switch,G1(:,:,:,96),Q(:,63),MB,G2tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,70),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,51),ZERO,G1(:,:,:,97))
  call loop_QV_A(G1(:,:,:,97),wf(:,2),G1(:,:,:,98))
  call check_last_Q_A(l_switch,G1(:,:,:,98),Q(:,63),ZERO,G2tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,70),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,51),MB,G1(:,:,:,99))
  call loop_QV_A(G1(:,:,:,99),wf(:,2),G1(:,:,:,100))
  call check_last_Q_A(l_switch,G1(:,:,:,100),Q(:,63),MB,G2tensor(:,74))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,69),Q(:,51),G1(:,:,:,101))
  call check_last_CV_D(l_switch,G1(:,:,:,101),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,75))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,70),Q(:,51),G1(:,:,:,102))
  call check_last_CV_D(l_switch,G1(:,:,:,102),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,48),ZERO,G1(:,:,:,103))
  call loop_QV_A(G1(:,:,:,103),wf(:,63),G1(:,:,:,104))
  call check_last_Q_A(l_switch,G1(:,:,:,104),Q(:,63),ZERO,G2tensor(:,77))
  call loop_QV_A(G1(:,:,:,103),wf(:,64),G1(:,:,:,105))
  call check_last_Q_A(l_switch,G1(:,:,:,105),Q(:,63),ZERO,G2tensor(:,78))
  call loop_QV_A(G1(:,:,:,103),wf(:,65),G1(:,:,:,106))
  call check_last_Q_A(l_switch,G1(:,:,:,106),Q(:,63),ZERO,G2tensor(:,79))
  call loop_QV_A(G1(:,:,:,103),wf(:,66),G1(:,:,:,107))
  call check_last_Q_A(l_switch,G1(:,:,:,107),Q(:,63),ZERO,G2tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,48),MB,G1(:,:,:,108))
  call loop_QV_A(G1(:,:,:,108),wf(:,63),G1(:,:,:,109))
  call check_last_Q_A(l_switch,G1(:,:,:,109),Q(:,63),MB,G2tensor(:,81))
  call loop_QV_A(G1(:,:,:,108),wf(:,64),G1(:,:,:,110))
  call check_last_Q_A(l_switch,G1(:,:,:,110),Q(:,63),MB,G2tensor(:,82))
  call loop_QV_A(G1(:,:,:,108),wf(:,65),G1(:,:,:,111))
  call check_last_Q_A(l_switch,G1(:,:,:,111),Q(:,63),MB,G2tensor(:,83))
  call loop_QV_A(G1(:,:,:,108),wf(:,66),G1(:,:,:,112))
  call check_last_Q_A(l_switch,G1(:,:,:,112),Q(:,63),MB,G2tensor(:,84))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,48),G1(:,:,:,113))
  call check_last_CV_D(l_switch,G1(:,:,:,113),Q(:,48),wf(:,63),Q(:,15),G2tensor(:,85))
  call check_last_CV_D(l_switch,G1(:,:,:,113),Q(:,48),wf(:,64),Q(:,15),G2tensor(:,86))
  call check_last_CV_D(l_switch,G1(:,:,:,113),Q(:,48),wf(:,65),Q(:,15),G2tensor(:,87))
  call check_last_CV_D(l_switch,G1(:,:,:,113),Q(:,48),wf(:,66),Q(:,15),G2tensor(:,88))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(29)/4._/**/REALKIND * den(71)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (-(f(29)/12._/**/REALKIND) * den(71)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(29)/4._/**/REALKIND * den(71)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (-(f(29)/12._/**/REALKIND) * den(71)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(27)/4._/**/REALKIND) * den(71)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (f(27)/12._/**/REALKIND * den(71)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(26)/4._/**/REALKIND) * den(71)) * TI2_call(3,momenta_10,masses2_4,G3tensor(:,7),T3sum(1:35,2))
  M(2) = M(2) + (f(26)/12._/**/REALKIND * den(71)) * TI2_call(3,momenta_10,masses2_4,G3tensor(:,7),T3sum(1:35,2))
  M(1) = M(1) + (-(f(27)/4._/**/REALKIND) * den(71)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (f(27)/12._/**/REALKIND * den(71)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(26)/4._/**/REALKIND) * den(71)) * TI2_call(3,momenta_10,masses2_4,G3tensor(:,9),T3sum(1:35,2))
  M(2) = M(2) + (f(26)/12._/**/REALKIND * den(71)) * TI2_call(3,momenta_10,masses2_4,G3tensor(:,9),T3sum(1:35,2))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(72)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(72)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(72)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(72)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(72)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(72)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(28)/4._/**/REALKIND) * den(72)) * TI2_call(3,momenta_10,masses2_4,G3tensor(:,8),T3sum(1:35,2))
  M(2) = M(2) + (f(28)/12._/**/REALKIND * den(72)) * TI2_call(3,momenta_10,masses2_4,G3tensor(:,8),T3sum(1:35,2))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(72)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(72)) * TI2_call(3,momenta_10,masses2_7,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(f(28)/4._/**/REALKIND) * den(72)) * TI2_call(3,momenta_10,masses2_4,G3tensor(:,10),T3sum(1:35,2))
  M(2) = M(2) + (f(28)/12._/**/REALKIND * den(72)) * TI2_call(3,momenta_10,masses2_4,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (-(f(22)/12._/**/REALKIND) * den(5)) * TI2_call(2,momenta_15,masses2_5,G2tensor(:,1),T2sum(1:15,1))
  M(2) = M(2) + (f(22)/36._/**/REALKIND * den(5)) * TI2_call(2,momenta_15,masses2_5,G2tensor(:,1),T2sum(1:15,1))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(8)) * TI2_call(2,momenta_15,masses2_5,G2tensor(:,2),T2sum(1:15,1))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(8)) * TI2_call(2,momenta_15,masses2_5,G2tensor(:,2),T2sum(1:15,1))
  M(1) = M(1) + ((-3*CI*f(18))/4._/**/REALKIND * den(5)) * TI2_call(2,momenta_13,masses2_6,G2tensor(:,15),T2sum(1:15,2))
  M(2) = M(2) + ((CI*f(18))/4._/**/REALKIND * den(5)) * TI2_call(2,momenta_13,masses2_6,G2tensor(:,15),T2sum(1:15,2))
  M(1) = M(1) + ((-3*CI*f(20))/4._/**/REALKIND * den(8)) * TI2_call(2,momenta_13,masses2_6,G2tensor(:,17),T2sum(1:15,2))
  M(2) = M(2) + ((CI*f(20))/4._/**/REALKIND * den(8)) * TI2_call(2,momenta_13,masses2_6,G2tensor(:,17),T2sum(1:15,2))
  M(1) = M(1) + (-(f(22)/12._/**/REALKIND) * den(27)) * TI2_call(2,momenta_17,masses2_5,G2tensor(:,19),T2sum(1:15,3))
  M(2) = M(2) + (f(22)/36._/**/REALKIND * den(27)) * TI2_call(2,momenta_17,masses2_5,G2tensor(:,19),T2sum(1:15,3))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(29)) * TI2_call(2,momenta_17,masses2_5,G2tensor(:,21),T2sum(1:15,3))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(29)) * TI2_call(2,momenta_17,masses2_5,G2tensor(:,21),T2sum(1:15,3))
  M(1) = M(1) + ((-3*CI*f(18))/4._/**/REALKIND * den(27)) * TI2_call(2,momenta_12,masses2_6,G2tensor(:,23),T2sum(1:15,4))
  M(2) = M(2) + ((CI*f(18))/4._/**/REALKIND * den(27)) * TI2_call(2,momenta_12,masses2_6,G2tensor(:,23),T2sum(1:15,4))
  M(1) = M(1) + ((-3*CI*f(20))/4._/**/REALKIND * den(29)) * TI2_call(2,momenta_12,masses2_6,G2tensor(:,25),T2sum(1:15,4))
  M(2) = M(2) + ((CI*f(20))/4._/**/REALKIND * den(29)) * TI2_call(2,momenta_12,masses2_6,G2tensor(:,25),T2sum(1:15,4))
  M(1) = M(1) + ((2*f(22))/3._/**/REALKIND * den(11)) * TI2_call(2,momenta_14,masses2_5,G2tensor(:,3),T2sum(1:15,5))
  M(2) = M(2) + ((-2*f(22))/9._/**/REALKIND * den(11)) * TI2_call(2,momenta_14,masses2_5,G2tensor(:,3),T2sum(1:15,5))
  M(1) = M(1) + ((2*f(25))/3._/**/REALKIND * den(12)) * TI2_call(2,momenta_14,masses2_5,G2tensor(:,4),T2sum(1:15,5))
  M(2) = M(2) + ((-2*f(25))/9._/**/REALKIND * den(12)) * TI2_call(2,momenta_14,masses2_5,G2tensor(:,4),T2sum(1:15,5))
  M(1) = M(1) + ((2*f(22))/3._/**/REALKIND * den(32)) * TI2_call(2,momenta_18,masses2_5,G2tensor(:,35),T2sum(1:15,6))
  M(2) = M(2) + ((-2*f(22))/9._/**/REALKIND * den(32)) * TI2_call(2,momenta_18,masses2_5,G2tensor(:,35),T2sum(1:15,6))
  M(1) = M(1) + ((2*f(25))/3._/**/REALKIND * den(33)) * TI2_call(2,momenta_18,masses2_5,G2tensor(:,36),T2sum(1:15,6))
  M(2) = M(2) + ((-2*f(25))/9._/**/REALKIND * den(33)) * TI2_call(2,momenta_18,masses2_5,G2tensor(:,36),T2sum(1:15,6))
  M(1) = M(1) + (-(f(22)/12._/**/REALKIND) * den(73)) * TI2_call(3,momenta_32,masses2_8,G3tensor(:,11),T3sum(1:35,3))
  M(2) = M(2) + (f(22)/36._/**/REALKIND * den(73)) * TI2_call(3,momenta_32,masses2_8,G3tensor(:,11),T3sum(1:35,3))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(23)) * TI2_call(3,momenta_32,masses2_8,G3tensor(:,12),T3sum(1:35,3))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(23)) * TI2_call(3,momenta_32,masses2_8,G3tensor(:,12),T3sum(1:35,3))
  M(1) = M(1) + (-(f(22)/12._/**/REALKIND) * den(73)) * TI2_call(3,momenta_31,masses2_8,G3tensor(:,13),T3sum(1:35,4))
  M(2) = M(2) + (f(22)/36._/**/REALKIND * den(73)) * TI2_call(3,momenta_31,masses2_8,G3tensor(:,13),T3sum(1:35,4))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(23)) * TI2_call(3,momenta_31,masses2_8,G3tensor(:,15),T3sum(1:35,4))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(23)) * TI2_call(3,momenta_31,masses2_8,G3tensor(:,15),T3sum(1:35,4))
  M(1) = M(1) + ((-3*CI*f(18))/4._/**/REALKIND * den(73)) * TI2_call(3,momenta_26,masses2_9,G3tensor(:,19),T3sum(1:35,5))
  M(2) = M(2) + ((CI*f(18))/4._/**/REALKIND * den(73)) * TI2_call(3,momenta_26,masses2_9,G3tensor(:,19),T3sum(1:35,5))
  M(1) = M(1) + ((-3*CI*f(20))/4._/**/REALKIND * den(23)) * TI2_call(3,momenta_26,masses2_9,G3tensor(:,21),T3sum(1:35,5))
  M(2) = M(2) + ((CI*f(20))/4._/**/REALKIND * den(23)) * TI2_call(3,momenta_26,masses2_9,G3tensor(:,21),T3sum(1:35,5))
  M(1) = M(1) + (f(24)/12._/**/REALKIND * den(16)) * TI2_call(2,momenta_7,masses2_7,G2tensor(:,37),T2sum(1:15,7))
  M(2) = M(2) + (-(f(24)/36._/**/REALKIND) * den(16)) * TI2_call(2,momenta_7,masses2_7,G2tensor(:,37),T2sum(1:15,7))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(18)) * TI2_call(2,momenta_7,masses2_7,G2tensor(:,38),T2sum(1:15,7))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(18)) * TI2_call(2,momenta_7,masses2_7,G2tensor(:,38),T2sum(1:15,7))
  M(1) = M(1) + ((-3*CI*f(19))/4._/**/REALKIND * den(16)) * TI2_call(2,momenta_19,masses2_7,G2tensor(:,43),T2sum(1:15,8))
  M(2) = M(2) + ((CI*f(19))/4._/**/REALKIND * den(16)) * TI2_call(2,momenta_19,masses2_7,G2tensor(:,43),T2sum(1:15,8))
  M(1) = M(1) + ((3*CI*f(20))/4._/**/REALKIND * den(18)) * TI2_call(2,momenta_19,masses2_7,G2tensor(:,44),T2sum(1:15,8))
  M(2) = M(2) + (-(CI*f(20))/4._/**/REALKIND * den(18)) * TI2_call(2,momenta_19,masses2_7,G2tensor(:,44),T2sum(1:15,8))
  M(1) = M(1) + (f(24)/12._/**/REALKIND * den(36)) * TI2_call(2,momenta_9,masses2_7,G2tensor(:,51),T2sum(1:15,9))
  M(2) = M(2) + (-(f(24)/36._/**/REALKIND) * den(36)) * TI2_call(2,momenta_9,masses2_7,G2tensor(:,51),T2sum(1:15,9))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(38)) * TI2_call(2,momenta_9,masses2_7,G2tensor(:,52),T2sum(1:15,9))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(38)) * TI2_call(2,momenta_9,masses2_7,G2tensor(:,52),T2sum(1:15,9))
  M(1) = M(1) + ((-3*CI*f(19))/4._/**/REALKIND * den(36)) * TI2_call(2,momenta_20,masses2_7,G2tensor(:,45),T2sum(1:15,10))
  M(2) = M(2) + ((CI*f(19))/4._/**/REALKIND * den(36)) * TI2_call(2,momenta_20,masses2_7,G2tensor(:,45),T2sum(1:15,10))
  M(1) = M(1) + ((3*CI*f(20))/4._/**/REALKIND * den(38)) * TI2_call(2,momenta_20,masses2_7,G2tensor(:,46),T2sum(1:15,10))
  M(2) = M(2) + (-(CI*f(20))/4._/**/REALKIND * den(38)) * TI2_call(2,momenta_20,masses2_7,G2tensor(:,46),T2sum(1:15,10))
  M(1) = M(1) + ((-2*f(24))/3._/**/REALKIND * den(21)) * TI2_call(2,momenta_22,masses2_7,G2tensor(:,53),T2sum(1:15,11))
  M(2) = M(2) + ((2*f(24))/9._/**/REALKIND * den(21)) * TI2_call(2,momenta_22,masses2_7,G2tensor(:,53),T2sum(1:15,11))
  M(1) = M(1) + ((2*f(25))/3._/**/REALKIND * den(22)) * TI2_call(2,momenta_22,masses2_7,G2tensor(:,54),T2sum(1:15,11))
  M(2) = M(2) + ((-2*f(25))/9._/**/REALKIND * den(22)) * TI2_call(2,momenta_22,masses2_7,G2tensor(:,54),T2sum(1:15,11))
  M(1) = M(1) + ((-2*f(24))/3._/**/REALKIND * den(41)) * TI2_call(2,momenta_23,masses2_7,G2tensor(:,55),T2sum(1:15,12))
  M(2) = M(2) + ((2*f(24))/9._/**/REALKIND * den(41)) * TI2_call(2,momenta_23,masses2_7,G2tensor(:,55),T2sum(1:15,12))
  M(1) = M(1) + ((2*f(25))/3._/**/REALKIND * den(42)) * TI2_call(2,momenta_23,masses2_7,G2tensor(:,56),T2sum(1:15,12))
  M(2) = M(2) + ((-2*f(25))/9._/**/REALKIND * den(42)) * TI2_call(2,momenta_23,masses2_7,G2tensor(:,56),T2sum(1:15,12))
  M(1) = M(1) + (f(24)/12._/**/REALKIND * den(74)) * TI2_call(3,momenta_25,masses2_11,G3tensor(:,25),T3sum(1:35,6))
  M(2) = M(2) + (-(f(24)/36._/**/REALKIND) * den(74)) * TI2_call(3,momenta_25,masses2_11,G3tensor(:,25),T3sum(1:35,6))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(75)) * TI2_call(3,momenta_25,masses2_11,G3tensor(:,26),T3sum(1:35,6))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(75)) * TI2_call(3,momenta_25,masses2_11,G3tensor(:,26),T3sum(1:35,6))
  M(1) = M(1) + (f(24)/12._/**/REALKIND * den(74)) * TI2_call(3,momenta_24,masses2_11,G3tensor(:,27),T3sum(1:35,7))
  M(2) = M(2) + (-(f(24)/36._/**/REALKIND) * den(74)) * TI2_call(3,momenta_24,masses2_11,G3tensor(:,27),T3sum(1:35,7))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(75)) * TI2_call(3,momenta_24,masses2_11,G3tensor(:,28),T3sum(1:35,7))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(75)) * TI2_call(3,momenta_24,masses2_11,G3tensor(:,28),T3sum(1:35,7))
  M(1) = M(1) + ((-3*CI*f(19))/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_37,masses2_11,G3tensor(:,29),T3sum(1:35,8))
  M(2) = M(2) + ((CI*f(19))/4._/**/REALKIND * den(74)) * TI2_call(3,momenta_37,masses2_11,G3tensor(:,29),T3sum(1:35,8))
  M(1) = M(1) + ((3*CI*f(20))/4._/**/REALKIND * den(75)) * TI2_call(3,momenta_37,masses2_11,G3tensor(:,30),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(20))/4._/**/REALKIND * den(75)) * TI2_call(3,momenta_37,masses2_11,G3tensor(:,30),T3sum(1:35,8))
  M(1) = M(1) + (f(24)/12._/**/REALKIND * den(62)) * TI2_call(2,momenta_16,masses2_5,G2tensor(:,5),T2sum(1:15,13))
  M(2) = M(2) + (-(f(24)/36._/**/REALKIND) * den(62)) * TI2_call(2,momenta_16,masses2_5,G2tensor(:,5),T2sum(1:15,13))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(63)) * TI2_call(2,momenta_16,masses2_5,G2tensor(:,6),T2sum(1:15,13))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(63)) * TI2_call(2,momenta_16,masses2_5,G2tensor(:,6),T2sum(1:15,13))
  M(1) = M(1) + ((3*CI*f(19))/4._/**/REALKIND * den(62)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,27),T2sum(1:15,14))
  M(2) = M(2) + (-(CI*f(19))/4._/**/REALKIND * den(62)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,27),T2sum(1:15,14))
  M(1) = M(1) + ((-3*CI*f(20))/4._/**/REALKIND * den(63)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,28),T2sum(1:15,14))
  M(2) = M(2) + ((CI*f(20))/4._/**/REALKIND * den(63)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,28),T2sum(1:15,14))
  M(1) = M(1) + ((-7*f(24))/12._/**/REALKIND * den(15)) * TI2_call(2,momenta_33,masses2_10,G2tensor(:,7),T2sum(1:15,15))
  M(2) = M(2) + (-(f(24)/36._/**/REALKIND) * den(15)) * TI2_call(2,momenta_33,masses2_10,G2tensor(:,7),T2sum(1:15,15))
  M(1) = M(1) + ((7*f(25))/12._/**/REALKIND * den(17)) * TI2_call(2,momenta_33,masses2_10,G2tensor(:,8),T2sum(1:15,15))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(17)) * TI2_call(2,momenta_33,masses2_10,G2tensor(:,8),T2sum(1:15,15))
  M(1) = M(1) + (f(24)/6._/**/REALKIND * den(15)) * TI2_call(2,momenta_27,masses2_10,G2tensor(:,29),T2sum(1:15,16))
  M(2) = M(2) + ((-5*f(24))/18._/**/REALKIND * den(15)) * TI2_call(2,momenta_27,masses2_10,G2tensor(:,29),T2sum(1:15,16))
  M(1) = M(1) + (-(f(25)/6._/**/REALKIND) * den(17)) * TI2_call(2,momenta_27,masses2_10,G2tensor(:,30),T2sum(1:15,16))
  M(2) = M(2) + ((5*f(25))/18._/**/REALKIND * den(17)) * TI2_call(2,momenta_27,masses2_10,G2tensor(:,30),T2sum(1:15,16))
  M(1) = M(1) + (f(24)/12._/**/REALKIND * den(64)) * TI2_call(2,momenta_16,masses2_5,G2tensor(:,11),T2sum(1:15,13))
  M(2) = M(2) + (-(f(24)/36._/**/REALKIND) * den(64)) * TI2_call(2,momenta_16,masses2_5,G2tensor(:,11),T2sum(1:15,13))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(65)) * TI2_call(2,momenta_16,masses2_5,G2tensor(:,12),T2sum(1:15,13))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(65)) * TI2_call(2,momenta_16,masses2_5,G2tensor(:,12),T2sum(1:15,13))
  M(1) = M(1) + ((3*CI*f(19))/4._/**/REALKIND * den(64)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,31),T2sum(1:15,14))
  M(2) = M(2) + (-(CI*f(19))/4._/**/REALKIND * den(64)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,31),T2sum(1:15,14))
  M(1) = M(1) + ((-3*CI*f(20))/4._/**/REALKIND * den(65)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,32),T2sum(1:15,14))
  M(2) = M(2) + ((CI*f(20))/4._/**/REALKIND * den(65)) * TI2_call(2,momenta_11,masses2_6,G2tensor(:,32),T2sum(1:15,14))
  M(1) = M(1) + (f(24)/6._/**/REALKIND * den(35)) * TI2_call(2,momenta_28,masses2_10,G2tensor(:,33),T2sum(1:15,17))
  M(2) = M(2) + ((-5*f(24))/18._/**/REALKIND * den(35)) * TI2_call(2,momenta_28,masses2_10,G2tensor(:,33),T2sum(1:15,17))
  M(1) = M(1) + (-(f(25)/6._/**/REALKIND) * den(37)) * TI2_call(2,momenta_28,masses2_10,G2tensor(:,34),T2sum(1:15,17))
  M(2) = M(2) + ((5*f(25))/18._/**/REALKIND * den(37)) * TI2_call(2,momenta_28,masses2_10,G2tensor(:,34),T2sum(1:15,17))
  M(1) = M(1) + ((-7*f(24))/12._/**/REALKIND * den(35)) * TI2_call(2,momenta_34,masses2_10,G2tensor(:,9),T2sum(1:15,18))
  M(2) = M(2) + (-(f(24)/36._/**/REALKIND) * den(35)) * TI2_call(2,momenta_34,masses2_10,G2tensor(:,9),T2sum(1:15,18))
  M(1) = M(1) + ((7*f(25))/12._/**/REALKIND * den(37)) * TI2_call(2,momenta_34,masses2_10,G2tensor(:,10),T2sum(1:15,18))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(37)) * TI2_call(2,momenta_34,masses2_10,G2tensor(:,10),T2sum(1:15,18))
  M(1) = M(1) + (-(f(22)/12._/**/REALKIND) * den(67)) * TI2_call(2,momenta_8,masses2_7,G2tensor(:,39),T2sum(1:15,19))
  M(2) = M(2) + (f(22)/36._/**/REALKIND * den(67)) * TI2_call(2,momenta_8,masses2_7,G2tensor(:,39),T2sum(1:15,19))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(68)) * TI2_call(2,momenta_8,masses2_7,G2tensor(:,40),T2sum(1:15,19))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(68)) * TI2_call(2,momenta_8,masses2_7,G2tensor(:,40),T2sum(1:15,19))
  M(1) = M(1) + ((3*CI*f(18))/4._/**/REALKIND * den(67)) * TI2_call(2,momenta_21,masses2_7,G2tensor(:,57),T2sum(1:15,20))
  M(2) = M(2) + (-(CI*f(18))/4._/**/REALKIND * den(67)) * TI2_call(2,momenta_21,masses2_7,G2tensor(:,57),T2sum(1:15,20))
  M(1) = M(1) + ((3*CI*f(20))/4._/**/REALKIND * den(68)) * TI2_call(2,momenta_21,masses2_7,G2tensor(:,59),T2sum(1:15,20))
  M(2) = M(2) + (-(CI*f(20))/4._/**/REALKIND * den(68)) * TI2_call(2,momenta_21,masses2_7,G2tensor(:,59),T2sum(1:15,20))
  M(1) = M(1) + ((7*f(22))/12._/**/REALKIND * den(4)) * TI2_call(2,momenta_35,masses2_10,G2tensor(:,13),T2sum(1:15,21))
  M(2) = M(2) + (f(22)/36._/**/REALKIND * den(4)) * TI2_call(2,momenta_35,masses2_10,G2tensor(:,13),T2sum(1:15,21))
  M(1) = M(1) + ((7*f(25))/12._/**/REALKIND * den(7)) * TI2_call(2,momenta_35,masses2_10,G2tensor(:,14),T2sum(1:15,21))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(7)) * TI2_call(2,momenta_35,masses2_10,G2tensor(:,14),T2sum(1:15,21))
  M(1) = M(1) + (-(f(22)/6._/**/REALKIND) * den(4)) * TI2_call(2,momenta_30,masses2_10,G2tensor(:,16),T2sum(1:15,22))
  M(2) = M(2) + ((5*f(22))/18._/**/REALKIND * den(4)) * TI2_call(2,momenta_30,masses2_10,G2tensor(:,16),T2sum(1:15,22))
  M(1) = M(1) + (-(f(25)/6._/**/REALKIND) * den(7)) * TI2_call(2,momenta_30,masses2_10,G2tensor(:,18),T2sum(1:15,22))
  M(2) = M(2) + ((5*f(25))/18._/**/REALKIND * den(7)) * TI2_call(2,momenta_30,masses2_10,G2tensor(:,18),T2sum(1:15,22))
  M(1) = M(1) + (-(f(22)/12._/**/REALKIND) * den(69)) * TI2_call(2,momenta_8,masses2_7,G2tensor(:,41),T2sum(1:15,19))
  M(2) = M(2) + (f(22)/36._/**/REALKIND * den(69)) * TI2_call(2,momenta_8,masses2_7,G2tensor(:,41),T2sum(1:15,19))
  M(1) = M(1) + (-(f(25)/12._/**/REALKIND) * den(70)) * TI2_call(2,momenta_8,masses2_7,G2tensor(:,42),T2sum(1:15,19))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(70)) * TI2_call(2,momenta_8,masses2_7,G2tensor(:,42),T2sum(1:15,19))
  M(1) = M(1) + ((3*CI*f(18))/4._/**/REALKIND * den(69)) * TI2_call(2,momenta_21,masses2_7,G2tensor(:,61),T2sum(1:15,20))
  M(2) = M(2) + (-(CI*f(18))/4._/**/REALKIND * den(69)) * TI2_call(2,momenta_21,masses2_7,G2tensor(:,61),T2sum(1:15,20))
  M(1) = M(1) + ((3*CI*f(20))/4._/**/REALKIND * den(70)) * TI2_call(2,momenta_21,masses2_7,G2tensor(:,63),T2sum(1:15,20))
  M(2) = M(2) + (-(CI*f(20))/4._/**/REALKIND * den(70)) * TI2_call(2,momenta_21,masses2_7,G2tensor(:,63),T2sum(1:15,20))
  M(1) = M(1) + (-(f(22)/6._/**/REALKIND) * den(26)) * TI2_call(2,momenta_29,masses2_10,G2tensor(:,24),T2sum(1:15,23))
  M(2) = M(2) + ((5*f(22))/18._/**/REALKIND * den(26)) * TI2_call(2,momenta_29,masses2_10,G2tensor(:,24),T2sum(1:15,23))
  M(1) = M(1) + (-(f(25)/6._/**/REALKIND) * den(28)) * TI2_call(2,momenta_29,masses2_10,G2tensor(:,26),T2sum(1:15,23))
  M(2) = M(2) + ((5*f(25))/18._/**/REALKIND * den(28)) * TI2_call(2,momenta_29,masses2_10,G2tensor(:,26),T2sum(1:15,23))
  M(1) = M(1) + ((7*f(22))/12._/**/REALKIND * den(26)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,20),T2sum(1:15,24))
  M(2) = M(2) + (f(22)/36._/**/REALKIND * den(26)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,20),T2sum(1:15,24))
  M(1) = M(1) + ((7*f(25))/12._/**/REALKIND * den(28)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,22),T2sum(1:15,24))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(28)) * TI2_call(2,momenta_36,masses2_10,G2tensor(:,22),T2sum(1:15,24))
  M(1) = M(1) + (-(f(22)/6._/**/REALKIND) * den(1)) * TI2_call(3,momenta_38,masses2_12,G3tensor(:,20),T3sum(1:35,9))
  M(2) = M(2) + ((5*f(22))/18._/**/REALKIND * den(1)) * TI2_call(3,momenta_38,masses2_12,G3tensor(:,20),T3sum(1:35,9))
  M(1) = M(1) + (-(f(25)/6._/**/REALKIND) * den(6)) * TI2_call(3,momenta_38,masses2_12,G3tensor(:,22),T3sum(1:35,9))
  M(2) = M(2) + ((5*f(25))/18._/**/REALKIND * den(6)) * TI2_call(3,momenta_38,masses2_12,G3tensor(:,22),T3sum(1:35,9))
  M(1) = M(1) + ((7*f(22))/12._/**/REALKIND * den(1)) * TI2_call(3,momenta_40,masses2_12,G3tensor(:,14),T3sum(1:35,10))
  M(2) = M(2) + (f(22)/36._/**/REALKIND * den(1)) * TI2_call(3,momenta_40,masses2_12,G3tensor(:,14),T3sum(1:35,10))
  M(1) = M(1) + ((7*f(25))/12._/**/REALKIND * den(6)) * TI2_call(3,momenta_40,masses2_12,G3tensor(:,16),T3sum(1:35,10))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(6)) * TI2_call(3,momenta_40,masses2_12,G3tensor(:,16),T3sum(1:35,10))
  M(1) = M(1) + (f(24)/6._/**/REALKIND * den(1)) * TI2_call(3,momenta_39,masses2_13,G3tensor(:,23),T3sum(1:35,11))
  M(2) = M(2) + ((-5*f(24))/18._/**/REALKIND * den(1)) * TI2_call(3,momenta_39,masses2_13,G3tensor(:,23),T3sum(1:35,11))
  M(1) = M(1) + (-(f(25)/6._/**/REALKIND) * den(6)) * TI2_call(3,momenta_39,masses2_13,G3tensor(:,24),T3sum(1:35,11))
  M(2) = M(2) + ((5*f(25))/18._/**/REALKIND * den(6)) * TI2_call(3,momenta_39,masses2_13,G3tensor(:,24),T3sum(1:35,11))
  M(1) = M(1) + ((-7*f(24))/12._/**/REALKIND * den(1)) * TI2_call(3,momenta_41,masses2_13,G3tensor(:,17),T3sum(1:35,12))
  M(2) = M(2) + (-(f(24)/36._/**/REALKIND) * den(1)) * TI2_call(3,momenta_41,masses2_13,G3tensor(:,17),T3sum(1:35,12))
  M(1) = M(1) + ((7*f(25))/12._/**/REALKIND * den(6)) * TI2_call(3,momenta_41,masses2_13,G3tensor(:,18),T3sum(1:35,12))
  M(2) = M(2) + (f(25)/36._/**/REALKIND * den(6)) * TI2_call(3,momenta_41,masses2_13,G3tensor(:,18),T3sum(1:35,12))
  M(1) = M(1) + ((2*f(22))/3._/**/REALKIND * den(48)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,3),T1sum(1:5,1))
  M(2) = M(2) + ((-2*f(22))/9._/**/REALKIND * den(48)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,3),T1sum(1:5,1))
  M(1) = M(1) + ((2*f(25))/3._/**/REALKIND * den(49)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,4),T1sum(1:5,1))
  M(2) = M(2) + ((-2*f(25))/9._/**/REALKIND * den(49)) * TI2_call(1,momenta_2,masses2_2,G1tensor(:,4),T1sum(1:5,1))
  M(1) = M(1) + (-(f(27)/4._/**/REALKIND) * den(76)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,65),T2sum(1:15,25))
  M(2) = M(2) + (f(27)/12._/**/REALKIND * den(76)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,65),T2sum(1:15,25))
  M(1) = M(1) + (-(f(27)/4._/**/REALKIND) * den(76)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,65),T2sum(1:15,25))
  M(2) = M(2) + (f(27)/12._/**/REALKIND * den(76)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,65),T2sum(1:15,25))
  M(1) = M(1) + (-(f(26)/4._/**/REALKIND) * den(76)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,66),T2sum(1:15,26))
  M(2) = M(2) + (f(26)/12._/**/REALKIND * den(76)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,66),T2sum(1:15,26))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(77)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,67),T2sum(1:15,25))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(77)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,67),T2sum(1:15,25))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(77)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,67),T2sum(1:15,25))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(77)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,67),T2sum(1:15,25))
  M(1) = M(1) + (-(f(28)/4._/**/REALKIND) * den(77)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,68),T2sum(1:15,26))
  M(2) = M(2) + (f(28)/12._/**/REALKIND * den(77)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,68),T2sum(1:15,26))
  M(1) = M(1) + ((-3*f(22))/2._/**/REALKIND * den(76)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,69),T2sum(1:15,25))
  M(2) = M(2) + (f(22)/2._/**/REALKIND * den(76)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,69),T2sum(1:15,25))
  M(1) = M(1) + ((-3*f(25))/2._/**/REALKIND * den(77)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,70),T2sum(1:15,25))
  M(2) = M(2) + (f(25)/2._/**/REALKIND * den(77)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,70),T2sum(1:15,25))
  M(1) = M(1) + ((3*f(21))/2._/**/REALKIND * den(76)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,58),T2sum(1:15,25))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(76)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,58),T2sum(1:15,25))
  M(1) = M(1) + ((3*f(23))/2._/**/REALKIND * den(77)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,60),T2sum(1:15,25))
  M(2) = M(2) + (-(f(23)/2._/**/REALKIND) * den(77)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,60),T2sum(1:15,25))
  M(1) = M(1) + ((2*f(22))/3._/**/REALKIND * den(50)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,1),T1sum(1:5,2))
  M(2) = M(2) + ((-2*f(22))/9._/**/REALKIND * den(50)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,1),T1sum(1:5,2))
  M(1) = M(1) + ((2*f(25))/3._/**/REALKIND * den(51)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,2),T1sum(1:5,2))
  M(2) = M(2) + ((-2*f(25))/9._/**/REALKIND * den(51)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,2),T1sum(1:5,2))
  M(1) = M(1) + (-(f(27)/4._/**/REALKIND) * den(78)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,71),T2sum(1:15,25))
  M(2) = M(2) + (f(27)/12._/**/REALKIND * den(78)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,71),T2sum(1:15,25))
  M(1) = M(1) + (-(f(27)/4._/**/REALKIND) * den(78)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,71),T2sum(1:15,25))
  M(2) = M(2) + (f(27)/12._/**/REALKIND * den(78)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,71),T2sum(1:15,25))
  M(1) = M(1) + (-(f(26)/4._/**/REALKIND) * den(78)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,72),T2sum(1:15,26))
  M(2) = M(2) + (f(26)/12._/**/REALKIND * den(78)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,72),T2sum(1:15,26))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(79)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,73),T2sum(1:15,25))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(79)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,73),T2sum(1:15,25))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(79)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,73),T2sum(1:15,25))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(79)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,73),T2sum(1:15,25))
  M(1) = M(1) + (-(f(28)/4._/**/REALKIND) * den(79)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,74),T2sum(1:15,26))
  M(2) = M(2) + (f(28)/12._/**/REALKIND * den(79)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,74),T2sum(1:15,26))
  M(1) = M(1) + ((-3*f(22))/2._/**/REALKIND * den(78)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,75),T2sum(1:15,25))
  M(2) = M(2) + (f(22)/2._/**/REALKIND * den(78)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,75),T2sum(1:15,25))
  M(1) = M(1) + ((-3*f(25))/2._/**/REALKIND * den(79)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,76),T2sum(1:15,25))
  M(2) = M(2) + (f(25)/2._/**/REALKIND * den(79)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,76),T2sum(1:15,25))
  M(1) = M(1) + ((3*f(21))/2._/**/REALKIND * den(78)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,62),T2sum(1:15,25))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(78)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,62),T2sum(1:15,25))
  M(1) = M(1) + ((3*f(23))/2._/**/REALKIND * den(79)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,64),T2sum(1:15,25))
  M(2) = M(2) + (-(f(23)/2._/**/REALKIND) * den(79)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,64),T2sum(1:15,25))
  M(1) = M(1) + (f(29)/4._/**/REALKIND * den(80)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,77),T2sum(1:15,27))
  M(2) = M(2) + (-(f(29)/12._/**/REALKIND) * den(80)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,77),T2sum(1:15,27))
  M(1) = M(1) + (f(29)/4._/**/REALKIND * den(80)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,77),T2sum(1:15,27))
  M(2) = M(2) + (-(f(29)/12._/**/REALKIND) * den(80)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,77),T2sum(1:15,27))
  M(1) = M(1) + (f(27)/4._/**/REALKIND * den(80)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,81),T2sum(1:15,28))
  M(2) = M(2) + (-(f(27)/12._/**/REALKIND) * den(80)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,81),T2sum(1:15,28))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(81)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,78),T2sum(1:15,27))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(81)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,78),T2sum(1:15,27))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(81)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,78),T2sum(1:15,27))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(81)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,78),T2sum(1:15,27))
  M(1) = M(1) + (-(f(28)/4._/**/REALKIND) * den(81)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,82),T2sum(1:15,28))
  M(2) = M(2) + (f(28)/12._/**/REALKIND * den(81)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,82),T2sum(1:15,28))
  M(1) = M(1) + ((3*f(24))/2._/**/REALKIND * den(80)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,85),T2sum(1:15,27))
  M(2) = M(2) + (-(f(24)/2._/**/REALKIND) * den(80)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,85),T2sum(1:15,27))
  M(1) = M(1) + ((-3*f(25))/2._/**/REALKIND * den(81)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,86),T2sum(1:15,27))
  M(2) = M(2) + (f(25)/2._/**/REALKIND * den(81)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,86),T2sum(1:15,27))
  M(1) = M(1) + ((-3*f(22))/2._/**/REALKIND * den(80)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,47),T2sum(1:15,27))
  M(2) = M(2) + (f(22)/2._/**/REALKIND * den(80)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,47),T2sum(1:15,27))
  M(1) = M(1) + ((3*f(23))/2._/**/REALKIND * den(81)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,48),T2sum(1:15,27))
  M(2) = M(2) + (-(f(23)/2._/**/REALKIND) * den(81)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,48),T2sum(1:15,27))
  M(1) = M(1) + ((-2*f(24))/3._/**/REALKIND * den(52)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,7),T1sum(1:5,3))
  M(2) = M(2) + ((2*f(24))/9._/**/REALKIND * den(52)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,7),T1sum(1:5,3))
  M(1) = M(1) + ((2*f(25))/3._/**/REALKIND * den(53)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,8),T1sum(1:5,3))
  M(2) = M(2) + ((-2*f(25))/9._/**/REALKIND * den(53)) * TI2_call(1,momenta_6,masses2_3,G1tensor(:,8),T1sum(1:5,3))
  M(1) = M(1) + (f(29)/4._/**/REALKIND * den(82)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,79),T2sum(1:15,27))
  M(2) = M(2) + (-(f(29)/12._/**/REALKIND) * den(82)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,79),T2sum(1:15,27))
  M(1) = M(1) + (f(29)/4._/**/REALKIND * den(82)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,79),T2sum(1:15,27))
  M(2) = M(2) + (-(f(29)/12._/**/REALKIND) * den(82)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,79),T2sum(1:15,27))
  M(1) = M(1) + (f(27)/4._/**/REALKIND * den(82)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,83),T2sum(1:15,28))
  M(2) = M(2) + (-(f(27)/12._/**/REALKIND) * den(82)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,83),T2sum(1:15,28))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(83)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,80),T2sum(1:15,27))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(83)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,80),T2sum(1:15,27))
  M(1) = M(1) + (-(f(30)/4._/**/REALKIND) * den(83)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,80),T2sum(1:15,27))
  M(2) = M(2) + (f(30)/12._/**/REALKIND * den(83)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,80),T2sum(1:15,27))
  M(1) = M(1) + (-(f(28)/4._/**/REALKIND) * den(83)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,84),T2sum(1:15,28))
  M(2) = M(2) + (f(28)/12._/**/REALKIND * den(83)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,84),T2sum(1:15,28))
  M(1) = M(1) + ((3*f(24))/2._/**/REALKIND * den(82)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,87),T2sum(1:15,27))
  M(2) = M(2) + (-(f(24)/2._/**/REALKIND) * den(82)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,87),T2sum(1:15,27))
  M(1) = M(1) + ((-3*f(25))/2._/**/REALKIND * den(83)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,88),T2sum(1:15,27))
  M(2) = M(2) + (f(25)/2._/**/REALKIND * den(83)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,88),T2sum(1:15,27))
  M(1) = M(1) + ((-3*f(22))/2._/**/REALKIND * den(82)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,49),T2sum(1:15,27))
  M(2) = M(2) + (f(22)/2._/**/REALKIND * den(82)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,49),T2sum(1:15,27))
  M(1) = M(1) + ((3*f(23))/2._/**/REALKIND * den(83)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,50),T2sum(1:15,27))
  M(2) = M(2) + (-(f(23)/2._/**/REALKIND) * den(83)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,50),T2sum(1:15,27))
  M(1) = M(1) + ((-2*f(24))/3._/**/REALKIND * den(54)) * TI2_call(1,momenta_5,masses2_3,G1tensor(:,5),T1sum(1:5,4))
  M(2) = M(2) + ((2*f(24))/9._/**/REALKIND * den(54)) * TI2_call(1,momenta_5,masses2_3,G1tensor(:,5),T1sum(1:5,4))
  M(1) = M(1) + ((2*f(25))/3._/**/REALKIND * den(55)) * TI2_call(1,momenta_5,masses2_3,G1tensor(:,6),T1sum(1:5,4))
  M(2) = M(2) + ((-2*f(25))/9._/**/REALKIND * den(55)) * TI2_call(1,momenta_5,masses2_3,G1tensor(:,6),T1sum(1:5,4))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pplljj2_eexuuxbbx_2_/**/REALKIND
