
module ol_vamp_1_pplljj2_eexbbbxbx_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplljj2_eexbbbxbx_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplljj2_eexbbbxbx_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pplljj2_eexbbbxbx_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pplljj2_eexbbbxbx_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,44) :: G0
  complex(REALKIND), dimension(4,5,4,235) :: G1
  complex(REALKIND), dimension(4,15,4,178) :: G2
  complex(REALKIND), dimension(4,35,4,40) :: G3
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G1tensorhel(5,16,64))
    allocate(G2tensorhel(15,176,64))
    allocate(G3tensorhel(35,60,64))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,20),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,28),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,60),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,7),G2(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,7),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),ZERO,G3tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,20),ZERO,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,28),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,60),ZERO,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),ZERO,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,5),wf(:,7),G2(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,63),ZERO,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,5),wf(:,7),G2(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),ZERO,G3tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,20),MB,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,28),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,60),MB,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,1),G2(:,:,:,10))
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),MB,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,7),G2(:,:,:,11),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,63),MB,G3tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,20),MB,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,28),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,60),MB,G2(:,:,:,12))
  call loop_QV_A(G2(:,:,:,12),wf(:,1),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,63),MB,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,12),wf(:,7),G2(:,:,:,14),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MB,G3tensor(:,10))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,32),MB,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,2),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,52),MB,G2(:,:,:,15))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,5),G2tensor(:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,9),G2tensor(:,2))
  call loop_AV_Q(G2(:,:,:,15),wf(:,1),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,55),MB,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,-3),G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,7),G2(:,:,:,17),gZd)
  call loop_A_Q(G2(:,:,:,17),Q(:,55),MB,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,-3),G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,9),wf(:,1),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,35),MB,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,12),G2tensor(:,3))
  call loop_AV_Q(G2(:,:,:,18),wf(:,2),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,55),MB,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-3),G3tensor(:,13))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,21),G2tensor(:,4))
  call loop_AV_Q(G2(:,:,:,18),wf(:,14),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,59),MB,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,-2),G3tensor(:,14))
  call loop_AQ_V(G2(:,:,:,18),wf(:,-3),G2(:,:,:,21))
  call loop_VA_Q(G2(:,:,:,21),wf(:,-4),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,59),MB,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,-2),G3tensor(:,15))
  call loop_AZ_Q(G1(:,:,:,9),wf(:,7),G1(:,:,:,12),gZd)
  call loop_A_Q(G1(:,:,:,12),Q(:,35),MB,G2(:,:,:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,12),G2tensor(:,5))
  call loop_AV_Q(G2(:,:,:,23),wf(:,2),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,55),MB,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,-3),G3tensor(:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,21),G2tensor(:,6))
  call loop_AV_Q(G2(:,:,:,23),wf(:,14),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,59),MB,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,-2),G3tensor(:,17))
  call loop_AQ_V(G2(:,:,:,23),wf(:,-3),G2(:,:,:,26))
  call loop_VA_Q(G2(:,:,:,26),wf(:,-4),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,59),MB,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,-2),G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,9),wf(:,14),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,56),MB,G2(:,:,:,28))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,17),G2tensor(:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,19),G2tensor(:,8))
  call loop_AV_Q(G2(:,:,:,28),wf(:,1),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,59),MB,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,-2),G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,28),wf(:,7),G2(:,:,:,30),gZd)
  call loop_A_Q(G2(:,:,:,30),Q(:,59),MB,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,-2),G3tensor(:,20))
  call loop_AV_Q(G1(:,:,:,9),wf(:,94),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,55),MB,G2(:,:,:,31))
  call check_last_AQ_V(l_switch,G2(:,:,:,31),wf(:,-3),G2tensor(:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,95),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,55),MB,G2(:,:,:,32))
  call check_last_AQ_V(l_switch,G2(:,:,:,32),wf(:,-3),G2tensor(:,10))
  call loop_AQ_V(G1(:,:,:,9),wf(:,-3),G1(:,:,:,16))
  call loop_VA_Q(G1(:,:,:,16),wf(:,-4),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,56),MB,G2(:,:,:,33))
  call check_last_AQ_V(l_switch,G2(:,:,:,33),wf(:,17),G2tensor(:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,33),wf(:,19),G2tensor(:,12))
  call loop_AV_Q(G2(:,:,:,33),wf(:,1),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,59),MB,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,-2),G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,33),wf(:,7),G2(:,:,:,35),gZd)
  call loop_A_Q(G2(:,:,:,35),Q(:,59),MB,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,-2),G3tensor(:,22))
  call loop_VA_Q(G1(:,:,:,16),wf(:,49),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,59),MB,G2(:,:,:,36))
  call check_last_AQ_V(l_switch,G2(:,:,:,36),wf(:,-2),G2tensor(:,13))
  call loop_VA_Q(G1(:,:,:,16),wf(:,50),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,59),MB,G2(:,:,:,37))
  call check_last_AQ_V(l_switch,G2(:,:,:,37),wf(:,-2),G2tensor(:,14))
  call loop_AV_Q(G1(:,:,:,9),wf(:,98),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,59),MB,G2(:,:,:,38))
  call check_last_AQ_V(l_switch,G2(:,:,:,38),wf(:,-2),G2tensor(:,15))
  call loop_AV_Q(G1(:,:,:,9),wf(:,99),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,59),MB,G2(:,:,:,39))
  call check_last_AQ_V(l_switch,G2(:,:,:,39),wf(:,-2),G2tensor(:,16))
  call loop_AQ_V(G1(:,:,:,9),wf(:,5),G1(:,:,:,22))
  call loop_VA_Q(G1(:,:,:,22),wf(:,-4),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,59),MB,G2(:,:,:,40))
  call check_last_AQ_V(l_switch,G2(:,:,:,40),wf(:,-2),G2tensor(:,17))
  call loop_AQ_V(G1(:,:,:,9),wf(:,9),G1(:,:,:,24))
  call loop_VA_Q(G1(:,:,:,24),wf(:,-4),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,59),MB,G2(:,:,:,41))
  call check_last_AQ_V(l_switch,G2(:,:,:,41),wf(:,-2),G2tensor(:,18))
  call loop_AV_Q(G1(:,:,:,9),wf(:,102),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,55),MB,G2(:,:,:,42))
  call check_last_AQ_V(l_switch,G2(:,:,:,42),wf(:,-3),G2tensor(:,19))
  call loop_AV_Q(G1(:,:,:,9),wf(:,103),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,55),MB,G2(:,:,:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,-3),G2tensor(:,20))
  call loop_AV_Q(G1(:,:,:,9),wf(:,104),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,59),MB,G2(:,:,:,44))
  call check_last_AQ_V(l_switch,G2(:,:,:,44),wf(:,-2),G2tensor(:,21))
  call loop_AV_Q(G1(:,:,:,9),wf(:,105),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,59),MB,G2(:,:,:,45))
  call check_last_AQ_V(l_switch,G2(:,:,:,45),wf(:,-2),G2tensor(:,22))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,20),G1(:,:,:,30))
  call loop_VA_Q(G1(:,:,:,30),wf(:,-5),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,52),MB,G2(:,:,:,46))
  call check_last_AQ_V(l_switch,G2(:,:,:,46),wf(:,5),G2tensor(:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,46),wf(:,9),G2tensor(:,24))
  call loop_AV_Q(G2(:,:,:,46),wf(:,1),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,55),MB,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,-3),G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,7),G2(:,:,:,48),gZd)
  call loop_A_Q(G2(:,:,:,48),Q(:,55),MB,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,-3),G3tensor(:,24))
  call loop_VA_Q(G1(:,:,:,30),wf(:,43),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,55),MB,G2(:,:,:,49))
  call check_last_AQ_V(l_switch,G2(:,:,:,49),wf(:,-3),G2tensor(:,25))
  call loop_VA_Q(G1(:,:,:,30),wf(:,44),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,55),MB,G2(:,:,:,50))
  call check_last_AQ_V(l_switch,G2(:,:,:,50),wf(:,-3),G2tensor(:,26))
  call loop_VA_Q(G0(:,:,:,1),wf(:,43),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,35),MB,G1(:,:,:,34))
  call loop_AV_Q(G1(:,:,:,34),wf(:,2),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,55),MB,G2(:,:,:,51))
  call check_last_AQ_V(l_switch,G2(:,:,:,51),wf(:,-3),G2tensor(:,27))
  call loop_AV_Q(G1(:,:,:,34),wf(:,14),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,59),MB,G2(:,:,:,52))
  call check_last_AQ_V(l_switch,G2(:,:,:,52),wf(:,-2),G2tensor(:,28))
  call loop_AQ_V(G1(:,:,:,34),wf(:,-3),G1(:,:,:,37))
  call loop_VA_Q(G1(:,:,:,37),wf(:,-4),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,59),MB,G2(:,:,:,53))
  call check_last_AQ_V(l_switch,G2(:,:,:,53),wf(:,-2),G2tensor(:,29))
  call check_last_AQ_V(l_switch,G1(:,:,:,34),wf(:,12),G1tensor(:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,34),wf(:,21),G1tensor(:,2))
  call loop_VA_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,35),MB,G1(:,:,:,39))
  call loop_AV_Q(G1(:,:,:,39),wf(:,2),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,55),MB,G2(:,:,:,54))
  call check_last_AQ_V(l_switch,G2(:,:,:,54),wf(:,-3),G2tensor(:,30))
  call loop_AV_Q(G1(:,:,:,39),wf(:,14),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,59),MB,G2(:,:,:,55))
  call check_last_AQ_V(l_switch,G2(:,:,:,55),wf(:,-2),G2tensor(:,31))
  call loop_AQ_V(G1(:,:,:,39),wf(:,-3),G1(:,:,:,42))
  call loop_VA_Q(G1(:,:,:,42),wf(:,-4),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,59),MB,G2(:,:,:,56))
  call check_last_AQ_V(l_switch,G2(:,:,:,56),wf(:,-2),G2tensor(:,32))
  call check_last_AQ_V(l_switch,G1(:,:,:,39),wf(:,12),G1tensor(:,3))
  call check_last_AQ_V(l_switch,G1(:,:,:,39),wf(:,21),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,46),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,52),MB,G1(:,:,:,44))
  call loop_AV_Q(G1(:,:,:,44),wf(:,1),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,55),MB,G2(:,:,:,57))
  call check_last_AQ_V(l_switch,G2(:,:,:,57),wf(:,-3),G2tensor(:,33))
  call loop_AZ_Q(G1(:,:,:,44),wf(:,7),G1(:,:,:,46),gZd)
  call loop_A_Q(G1(:,:,:,46),Q(:,55),MB,G2(:,:,:,58))
  call check_last_AQ_V(l_switch,G2(:,:,:,58),wf(:,-3),G2tensor(:,34))
  call check_last_AQ_V(l_switch,G1(:,:,:,44),wf(:,5),G1tensor(:,5))
  call check_last_AQ_V(l_switch,G1(:,:,:,44),wf(:,9),G1tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,24),ZERO,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,22),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,60),ZERO,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,1),G2(:,:,:,60))
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,63),ZERO,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,59),wf(:,7),G2(:,:,:,61),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,63),ZERO,G3tensor(:,26))
  call loop_QZ_A(G2(:,:,:,59),wf(:,7),G2(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,63),ZERO,G3tensor(:,27))
  call loop_AV_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,24),ZERO,G1(:,:,:,49))
  call loop_AV_Q(G1(:,:,:,49),wf(:,22),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,60),ZERO,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,1),G2(:,:,:,64))
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,63),ZERO,G3tensor(:,28))
  call loop_AZ_Q(G2(:,:,:,63),wf(:,7),G2(:,:,:,65),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,63),ZERO,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,63),wf(:,7),G2(:,:,:,66),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,63),ZERO,G3tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,24),MB,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,22),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,60),MB,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,1),G2(:,:,:,68))
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,63),MB,G3tensor(:,31))
  call loop_QZ_A(G2(:,:,:,67),wf(:,7),G2(:,:,:,69),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,63),MB,G3tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,24),MB,G1(:,:,:,53))
  call loop_AV_Q(G1(:,:,:,53),wf(:,22),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,60),MB,G2(:,:,:,70))
  call loop_AV_Q(G2(:,:,:,70),wf(:,1),G2(:,:,:,71))
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,63),MB,G3tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,70),wf(:,7),G2(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,63),MB,G3tensor(:,34))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,24),G1(:,:,:,55))
  call loop_VA_Q(G1(:,:,:,55),wf(:,-5),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,56),MB,G2(:,:,:,73))
  call check_last_AQ_V(l_switch,G2(:,:,:,73),wf(:,17),G2tensor(:,35))
  call check_last_AQ_V(l_switch,G2(:,:,:,73),wf(:,19),G2tensor(:,36))
  call loop_AV_Q(G2(:,:,:,73),wf(:,1),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,59),MB,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,-2),G3tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,7),G2(:,:,:,75),gZd)
  call loop_A_Q(G2(:,:,:,75),Q(:,59),MB,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,-2),G3tensor(:,36))
  call loop_VA_Q(G1(:,:,:,55),wf(:,43),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,59),MB,G2(:,:,:,76))
  call check_last_AQ_V(l_switch,G2(:,:,:,76),wf(:,-2),G2tensor(:,37))
  call loop_VA_Q(G1(:,:,:,55),wf(:,44),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,59),MB,G2(:,:,:,77))
  call check_last_AQ_V(l_switch,G2(:,:,:,77),wf(:,-2),G2tensor(:,38))
  call loop_VA_Q(G0(:,:,:,1),wf(:,62),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,56),MB,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,1),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,59),MB,G2(:,:,:,78))
  call check_last_AQ_V(l_switch,G2(:,:,:,78),wf(:,-2),G2tensor(:,39))
  call loop_AZ_Q(G1(:,:,:,59),wf(:,7),G1(:,:,:,61),gZd)
  call loop_A_Q(G1(:,:,:,61),Q(:,59),MB,G2(:,:,:,79))
  call check_last_AQ_V(l_switch,G2(:,:,:,79),wf(:,-2),G2tensor(:,40))
  call check_last_AQ_V(l_switch,G1(:,:,:,59),wf(:,17),G1tensor(:,7))
  call check_last_AQ_V(l_switch,G1(:,:,:,59),wf(:,19),G1tensor(:,8))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,16),MB,G1(:,:,:,62))
  call loop_AV_Q(G1(:,:,:,62),wf(:,22),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,52),MB,G2(:,:,:,80))
  call check_last_AQ_V(l_switch,G2(:,:,:,80),wf(:,5),G2tensor(:,41))
  call check_last_AQ_V(l_switch,G2(:,:,:,80),wf(:,9),G2tensor(:,42))
  call loop_AV_Q(G2(:,:,:,80),wf(:,1),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,55),MB,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,-3),G3tensor(:,37))
  call loop_AZ_Q(G2(:,:,:,80),wf(:,7),G2(:,:,:,82),gZd)
  call loop_A_Q(G2(:,:,:,82),Q(:,55),MB,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,-3),G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,62),wf(:,1),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,19),MB,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,22),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,55),MB,G3(:,:,:,19))
  call check_last_AQ_V(l_switch,G3(:,:,:,19),wf(:,-3),G3tensor(:,39))
  call loop_AV_Q(G2(:,:,:,83),wf(:,28),G2(:,:,:,85))
  call loop_A_Q(G2(:,:,:,85),Q(:,59),MB,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,-2),G3tensor(:,40))
  call loop_AQ_V(G2(:,:,:,83),wf(:,-3),G2(:,:,:,86))
  call loop_VA_Q(G2(:,:,:,86),wf(:,-5),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,59),MB,G3(:,:,:,21))
  call check_last_AQ_V(l_switch,G3(:,:,:,21),wf(:,-2),G3tensor(:,41))
  call loop_AZ_Q(G1(:,:,:,62),wf(:,7),G1(:,:,:,65),gZd)
  call loop_A_Q(G1(:,:,:,65),Q(:,19),MB,G2(:,:,:,88))
  call loop_AV_Q(G2(:,:,:,88),wf(:,22),G2(:,:,:,89))
  call loop_A_Q(G2(:,:,:,89),Q(:,55),MB,G3(:,:,:,22))
  call check_last_AQ_V(l_switch,G3(:,:,:,22),wf(:,-3),G3tensor(:,42))
  call loop_AV_Q(G2(:,:,:,88),wf(:,28),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,59),MB,G3(:,:,:,23))
  call check_last_AQ_V(l_switch,G3(:,:,:,23),wf(:,-2),G3tensor(:,43))
  call loop_AQ_V(G2(:,:,:,88),wf(:,-3),G2(:,:,:,91))
  call loop_VA_Q(G2(:,:,:,91),wf(:,-5),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,59),MB,G3(:,:,:,24))
  call check_last_AQ_V(l_switch,G3(:,:,:,24),wf(:,-2),G3tensor(:,44))
  call loop_AV_Q(G1(:,:,:,62),wf(:,28),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,56),MB,G2(:,:,:,93))
  call check_last_AQ_V(l_switch,G2(:,:,:,93),wf(:,17),G2tensor(:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,93),wf(:,19),G2tensor(:,44))
  call loop_AV_Q(G2(:,:,:,93),wf(:,1),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,59),MB,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,-2),G3tensor(:,45))
  call loop_AZ_Q(G2(:,:,:,93),wf(:,7),G2(:,:,:,95),gZd)
  call loop_A_Q(G2(:,:,:,95),Q(:,59),MB,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,-2),G3tensor(:,46))
  call loop_AV_Q(G1(:,:,:,62),wf(:,96),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,55),MB,G2(:,:,:,96))
  call check_last_AQ_V(l_switch,G2(:,:,:,96),wf(:,-3),G2tensor(:,45))
  call loop_AV_Q(G1(:,:,:,62),wf(:,97),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,55),MB,G2(:,:,:,97))
  call check_last_AQ_V(l_switch,G2(:,:,:,97),wf(:,-3),G2tensor(:,46))
  call loop_AQ_V(G1(:,:,:,62),wf(:,-3),G1(:,:,:,69))
  call loop_VA_Q(G1(:,:,:,69),wf(:,-5),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,56),MB,G2(:,:,:,98))
  call check_last_AQ_V(l_switch,G2(:,:,:,98),wf(:,17),G2tensor(:,47))
  call check_last_AQ_V(l_switch,G2(:,:,:,98),wf(:,19),G2tensor(:,48))
  call loop_AV_Q(G2(:,:,:,98),wf(:,1),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,59),MB,G3(:,:,:,27))
  call check_last_AQ_V(l_switch,G3(:,:,:,27),wf(:,-2),G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,98),wf(:,7),G2(:,:,:,100),gZd)
  call loop_A_Q(G2(:,:,:,100),Q(:,59),MB,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,-2),G3tensor(:,48))
  call loop_VA_Q(G1(:,:,:,69),wf(:,43),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,59),MB,G2(:,:,:,101))
  call check_last_AQ_V(l_switch,G2(:,:,:,101),wf(:,-2),G2tensor(:,49))
  call loop_VA_Q(G1(:,:,:,69),wf(:,44),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,59),MB,G2(:,:,:,102))
  call check_last_AQ_V(l_switch,G2(:,:,:,102),wf(:,-2),G2tensor(:,50))
  call loop_AV_Q(G1(:,:,:,62),wf(:,100),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,59),MB,G2(:,:,:,103))
  call check_last_AQ_V(l_switch,G2(:,:,:,103),wf(:,-2),G2tensor(:,51))
  call loop_AV_Q(G1(:,:,:,62),wf(:,101),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,59),MB,G2(:,:,:,104))
  call check_last_AQ_V(l_switch,G2(:,:,:,104),wf(:,-2),G2tensor(:,52))
  call loop_AQ_V(G1(:,:,:,62),wf(:,5),G1(:,:,:,75))
  call loop_VA_Q(G1(:,:,:,75),wf(:,-5),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,59),MB,G2(:,:,:,105))
  call check_last_AQ_V(l_switch,G2(:,:,:,105),wf(:,-2),G2tensor(:,53))
  call loop_AQ_V(G1(:,:,:,62),wf(:,9),G1(:,:,:,77))
  call loop_VA_Q(G1(:,:,:,77),wf(:,-5),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,59),MB,G2(:,:,:,106))
  call check_last_AQ_V(l_switch,G2(:,:,:,106),wf(:,-2),G2tensor(:,54))
  call loop_AV_Q(G1(:,:,:,62),wf(:,106),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,55),MB,G2(:,:,:,107))
  call check_last_AQ_V(l_switch,G2(:,:,:,107),wf(:,-3),G2tensor(:,55))
  call loop_AV_Q(G1(:,:,:,62),wf(:,107),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,55),MB,G2(:,:,:,108))
  call check_last_AQ_V(l_switch,G2(:,:,:,108),wf(:,-3),G2tensor(:,56))
  call loop_AV_Q(G1(:,:,:,62),wf(:,108),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,59),MB,G2(:,:,:,109))
  call check_last_AQ_V(l_switch,G2(:,:,:,109),wf(:,-2),G2tensor(:,57))
  call loop_AV_Q(G1(:,:,:,62),wf(:,109),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,59),MB,G2(:,:,:,110))
  call check_last_AQ_V(l_switch,G2(:,:,:,110),wf(:,-2),G2tensor(:,58))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,22),Q(:,36),G1(:,:,:,83))
  call loop_VA_Q(G1(:,:,:,83),wf(:,-4),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,52),MB,G2(:,:,:,111))
  call check_last_AQ_V(l_switch,G2(:,:,:,111),wf(:,5),G2tensor(:,59))
  call check_last_AQ_V(l_switch,G2(:,:,:,111),wf(:,9),G2tensor(:,60))
  call loop_AV_Q(G2(:,:,:,111),wf(:,1),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,55),MB,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,-3),G3tensor(:,49))
  call loop_AZ_Q(G2(:,:,:,111),wf(:,7),G2(:,:,:,113),gZd)
  call loop_A_Q(G2(:,:,:,113),Q(:,55),MB,G3(:,:,:,30))
  call check_last_AQ_V(l_switch,G3(:,:,:,30),wf(:,-3),G3tensor(:,50))
  call loop_VA_Q(G1(:,:,:,83),wf(:,49),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,55),MB,G2(:,:,:,114))
  call check_last_AQ_V(l_switch,G2(:,:,:,114),wf(:,-3),G2tensor(:,61))
  call loop_VA_Q(G1(:,:,:,83),wf(:,50),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,55),MB,G2(:,:,:,115))
  call check_last_AQ_V(l_switch,G2(:,:,:,115),wf(:,-3),G2tensor(:,62))
  call check_last_UV_W(l_switch,G1(:,:,:,83),Q(:,36),wf(:,98),Q(:,27),G2tensor(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,83),Q(:,36),wf(:,99),Q(:,27),G2tensor(:,64))
  call check_last_UV_W(l_switch,G1(:,:,:,83),Q(:,36),wf(:,104),Q(:,27),G2tensor(:,65))
  call check_last_UV_W(l_switch,G1(:,:,:,83),Q(:,36),wf(:,105),Q(:,27),G2tensor(:,66))
  call loop_VA_Q(G0(:,:,:,1),wf(:,49),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,19),MB,G1(:,:,:,87))
  call loop_AV_Q(G1(:,:,:,87),wf(:,22),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,55),MB,G2(:,:,:,116))
  call check_last_AQ_V(l_switch,G2(:,:,:,116),wf(:,-3),G2tensor(:,67))
  call loop_AV_Q(G1(:,:,:,87),wf(:,28),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,59),MB,G2(:,:,:,117))
  call check_last_AQ_V(l_switch,G2(:,:,:,117),wf(:,-2),G2tensor(:,68))
  call loop_AQ_V(G1(:,:,:,87),wf(:,-3),G1(:,:,:,90))
  call loop_VA_Q(G1(:,:,:,90),wf(:,-5),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,59),MB,G2(:,:,:,118))
  call check_last_AQ_V(l_switch,G2(:,:,:,118),wf(:,-2),G2tensor(:,69))
  call loop_VA_Q(G0(:,:,:,1),wf(:,50),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,19),MB,G1(:,:,:,92))
  call loop_AV_Q(G1(:,:,:,92),wf(:,22),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,55),MB,G2(:,:,:,119))
  call check_last_AQ_V(l_switch,G2(:,:,:,119),wf(:,-3),G2tensor(:,70))
  call loop_AV_Q(G1(:,:,:,92),wf(:,28),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,59),MB,G2(:,:,:,120))
  call check_last_AQ_V(l_switch,G2(:,:,:,120),wf(:,-2),G2tensor(:,71))
  call loop_AQ_V(G1(:,:,:,92),wf(:,-3),G1(:,:,:,95))
  call loop_VA_Q(G1(:,:,:,95),wf(:,-5),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,59),MB,G2(:,:,:,121))
  call check_last_AQ_V(l_switch,G2(:,:,:,121),wf(:,-2),G2tensor(:,72))
  call loop_VQ_A(G0(:,:,:,1),wf(:,26),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,44),MB,G1(:,:,:,97))
  call loop_QV_A(G1(:,:,:,97),wf(:,1),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,47),MB,G2(:,:,:,122))
  call check_last_QA_V(l_switch,G2(:,:,:,122),wf(:,-4),G2tensor(:,73))
  call loop_QZ_A(G1(:,:,:,97),wf(:,7),G1(:,:,:,99),gZd)
  call loop_Q_A(G1(:,:,:,99),Q(:,47),MB,G2(:,:,:,123))
  call check_last_QA_V(l_switch,G2(:,:,:,123),wf(:,-4),G2tensor(:,74))
  call check_last_QA_V(l_switch,G1(:,:,:,97),wf(:,49),G1tensor(:,9))
  call check_last_QA_V(l_switch,G1(:,:,:,97),wf(:,50),G1tensor(:,10))
  call loop_VA_Q(G0(:,:,:,1),wf(:,51),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,52),MB,G1(:,:,:,100))
  call loop_AV_Q(G1(:,:,:,100),wf(:,1),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,55),MB,G2(:,:,:,124))
  call check_last_AQ_V(l_switch,G2(:,:,:,124),wf(:,-3),G2tensor(:,75))
  call loop_AZ_Q(G1(:,:,:,100),wf(:,7),G1(:,:,:,102),gZd)
  call loop_A_Q(G1(:,:,:,102),Q(:,55),MB,G2(:,:,:,125))
  call check_last_AQ_V(l_switch,G2(:,:,:,125),wf(:,-3),G2tensor(:,76))
  call check_last_AQ_V(l_switch,G1(:,:,:,100),wf(:,5),G1tensor(:,11))
  call check_last_AQ_V(l_switch,G1(:,:,:,100),wf(:,9),G1tensor(:,12))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,28),Q(:,40),G1(:,:,:,103))
  call loop_VA_Q(G1(:,:,:,103),wf(:,-4),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,56),MB,G2(:,:,:,126))
  call check_last_AQ_V(l_switch,G2(:,:,:,126),wf(:,17),G2tensor(:,77))
  call check_last_AQ_V(l_switch,G2(:,:,:,126),wf(:,19),G2tensor(:,78))
  call loop_AV_Q(G2(:,:,:,126),wf(:,1),G2(:,:,:,127))
  call loop_A_Q(G2(:,:,:,127),Q(:,59),MB,G3(:,:,:,31))
  call check_last_AQ_V(l_switch,G3(:,:,:,31),wf(:,-2),G3tensor(:,51))
  call loop_AZ_Q(G2(:,:,:,126),wf(:,7),G2(:,:,:,128),gZd)
  call loop_A_Q(G2(:,:,:,128),Q(:,59),MB,G3(:,:,:,32))
  call check_last_AQ_V(l_switch,G3(:,:,:,32),wf(:,-2),G3tensor(:,52))
  call loop_VA_Q(G1(:,:,:,103),wf(:,49),G1(:,:,:,105))
  call loop_A_Q(G1(:,:,:,105),Q(:,59),MB,G2(:,:,:,129))
  call check_last_AQ_V(l_switch,G2(:,:,:,129),wf(:,-2),G2tensor(:,79))
  call loop_VA_Q(G1(:,:,:,103),wf(:,50),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,59),MB,G2(:,:,:,130))
  call check_last_AQ_V(l_switch,G2(:,:,:,130),wf(:,-2),G2tensor(:,80))
  call check_last_UV_W(l_switch,G1(:,:,:,103),Q(:,40),wf(:,94),Q(:,23),G2tensor(:,81))
  call check_last_UV_W(l_switch,G1(:,:,:,103),Q(:,40),wf(:,95),Q(:,23),G2tensor(:,82))
  call check_last_UV_W(l_switch,G1(:,:,:,103),Q(:,40),wf(:,102),Q(:,23),G2tensor(:,83))
  call check_last_UV_W(l_switch,G1(:,:,:,103),Q(:,40),wf(:,103),Q(:,23),G2tensor(:,84))
  call loop_VQ_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,44),MB,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,1),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,47),MB,G2(:,:,:,131))
  call check_last_QA_V(l_switch,G2(:,:,:,131),wf(:,-4),G2tensor(:,85))
  call loop_QZ_A(G1(:,:,:,107),wf(:,7),G1(:,:,:,109),gZd)
  call loop_Q_A(G1(:,:,:,109),Q(:,47),MB,G2(:,:,:,132))
  call check_last_QA_V(l_switch,G2(:,:,:,132),wf(:,-4),G2tensor(:,86))
  call check_last_QA_V(l_switch,G1(:,:,:,107),wf(:,49),G1tensor(:,13))
  call check_last_QA_V(l_switch,G1(:,:,:,107),wf(:,50),G1tensor(:,14))
  call loop_VA_Q(G0(:,:,:,1),wf(:,65),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,56),MB,G1(:,:,:,110))
  call loop_AV_Q(G1(:,:,:,110),wf(:,1),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,59),MB,G2(:,:,:,133))
  call check_last_AQ_V(l_switch,G2(:,:,:,133),wf(:,-2),G2tensor(:,87))
  call loop_AZ_Q(G1(:,:,:,110),wf(:,7),G1(:,:,:,112),gZd)
  call loop_A_Q(G1(:,:,:,112),Q(:,59),MB,G2(:,:,:,134))
  call check_last_AQ_V(l_switch,G2(:,:,:,134),wf(:,-2),G2tensor(:,88))
  call check_last_AQ_V(l_switch,G1(:,:,:,110),wf(:,17),G1tensor(:,15))
  call check_last_AQ_V(l_switch,G1(:,:,:,110),wf(:,19),G1tensor(:,16))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,94),Q(:,23),G1(:,:,:,113))
  call loop_VA_Q(G1(:,:,:,113),wf(:,-5),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,55),MB,G2(:,:,:,135))
  call check_last_AQ_V(l_switch,G2(:,:,:,135),wf(:,-3),G2tensor(:,89))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,95),Q(:,23),G1(:,:,:,115))
  call loop_VA_Q(G1(:,:,:,115),wf(:,-5),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,55),MB,G2(:,:,:,136))
  call check_last_AQ_V(l_switch,G2(:,:,:,136),wf(:,-3),G2tensor(:,90))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,96),Q(:,39),G1(:,:,:,117))
  call loop_VA_Q(G1(:,:,:,117),wf(:,-4),G1(:,:,:,118))
  call loop_A_Q(G1(:,:,:,118),Q(:,55),MB,G2(:,:,:,137))
  call check_last_AQ_V(l_switch,G2(:,:,:,137),wf(:,-3),G2tensor(:,91))
  call check_last_UV_W(l_switch,G1(:,:,:,117),Q(:,39),wf(:,14),Q(:,24),G2tensor(:,92))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,97),Q(:,39),G1(:,:,:,119))
  call loop_VA_Q(G1(:,:,:,119),wf(:,-4),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,55),MB,G2(:,:,:,138))
  call check_last_AQ_V(l_switch,G2(:,:,:,138),wf(:,-3),G2tensor(:,93))
  call check_last_UV_W(l_switch,G1(:,:,:,119),Q(:,39),wf(:,14),Q(:,24),G2tensor(:,94))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,8),MB,G1(:,:,:,121))
  call loop_QA_V(G1(:,:,:,121),wf(:,-4),G1(:,:,:,122))
  call loop_VA_Q(G1(:,:,:,122),wf(:,-5),G1(:,:,:,123))
  call loop_A_Q(G1(:,:,:,123),Q(:,56),MB,G2(:,:,:,139))
  call check_last_AQ_V(l_switch,G2(:,:,:,139),wf(:,17),G2tensor(:,95))
  call check_last_AQ_V(l_switch,G2(:,:,:,139),wf(:,19),G2tensor(:,96))
  call loop_AV_Q(G2(:,:,:,139),wf(:,1),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,59),MB,G3(:,:,:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,33),wf(:,-2),G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,139),wf(:,7),G2(:,:,:,141),gZd)
  call loop_A_Q(G2(:,:,:,141),Q(:,59),MB,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,-2),G3tensor(:,54))
  call loop_VA_Q(G1(:,:,:,122),wf(:,43),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,59),MB,G2(:,:,:,142))
  call check_last_AQ_V(l_switch,G2(:,:,:,142),wf(:,-2),G2tensor(:,97))
  call loop_VA_Q(G1(:,:,:,122),wf(:,44),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,59),MB,G2(:,:,:,143))
  call check_last_AQ_V(l_switch,G2(:,:,:,143),wf(:,-2),G2tensor(:,98))
  call loop_QA_V(G1(:,:,:,121),wf(:,-5),G1(:,:,:,126))
  call loop_VA_Q(G1(:,:,:,126),wf(:,-4),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,56),MB,G2(:,:,:,144))
  call check_last_AQ_V(l_switch,G2(:,:,:,144),wf(:,17),G2tensor(:,99))
  call check_last_AQ_V(l_switch,G2(:,:,:,144),wf(:,19),G2tensor(:,100))
  call loop_AV_Q(G2(:,:,:,144),wf(:,1),G2(:,:,:,145))
  call loop_A_Q(G2(:,:,:,145),Q(:,59),MB,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,-2),G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,144),wf(:,7),G2(:,:,:,146),gZd)
  call loop_A_Q(G2(:,:,:,146),Q(:,59),MB,G3(:,:,:,36))
  call check_last_AQ_V(l_switch,G3(:,:,:,36),wf(:,-2),G3tensor(:,56))
  call loop_VA_Q(G1(:,:,:,126),wf(:,49),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,59),MB,G2(:,:,:,147))
  call check_last_AQ_V(l_switch,G2(:,:,:,147),wf(:,-2),G2tensor(:,101))
  call loop_VA_Q(G1(:,:,:,126),wf(:,50),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,59),MB,G2(:,:,:,148))
  call check_last_AQ_V(l_switch,G2(:,:,:,148),wf(:,-2),G2tensor(:,102))
  call loop_QA_V(G1(:,:,:,121),wf(:,49),G1(:,:,:,130))
  call loop_VA_Q(G1(:,:,:,130),wf(:,-5),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,59),MB,G2(:,:,:,149))
  call check_last_AQ_V(l_switch,G2(:,:,:,149),wf(:,-2),G2tensor(:,103))
  call loop_QA_V(G1(:,:,:,121),wf(:,50),G1(:,:,:,132))
  call loop_VA_Q(G1(:,:,:,132),wf(:,-5),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,59),MB,G2(:,:,:,150))
  call check_last_AQ_V(l_switch,G2(:,:,:,150),wf(:,-2),G2tensor(:,104))
  call loop_QA_V(G1(:,:,:,121),wf(:,43),G1(:,:,:,134))
  call loop_VA_Q(G1(:,:,:,134),wf(:,-4),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,59),MB,G2(:,:,:,151))
  call check_last_AQ_V(l_switch,G2(:,:,:,151),wf(:,-2),G2tensor(:,105))
  call loop_QA_V(G1(:,:,:,121),wf(:,44),G1(:,:,:,136))
  call loop_VA_Q(G1(:,:,:,136),wf(:,-4),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,59),MB,G2(:,:,:,152))
  call check_last_AQ_V(l_switch,G2(:,:,:,152),wf(:,-2),G2tensor(:,106))
  call loop_QV_A(G1(:,:,:,121),wf(:,1),G1(:,:,:,138))
  call loop_Q_A(G1(:,:,:,138),Q(:,11),MB,G2(:,:,:,153))
  call loop_QA_V(G2(:,:,:,153),wf(:,-5),G2(:,:,:,154))
  call loop_VA_Q(G2(:,:,:,154),wf(:,-4),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,59),MB,G3(:,:,:,37))
  call check_last_AQ_V(l_switch,G3(:,:,:,37),wf(:,-2),G3tensor(:,57))
  call loop_QA_V(G2(:,:,:,153),wf(:,-4),G2(:,:,:,156))
  call loop_VA_Q(G2(:,:,:,156),wf(:,-5),G2(:,:,:,157))
  call loop_A_Q(G2(:,:,:,157),Q(:,59),MB,G3(:,:,:,38))
  call check_last_AQ_V(l_switch,G3(:,:,:,38),wf(:,-2),G3tensor(:,58))
  call loop_QZ_A(G1(:,:,:,121),wf(:,7),G1(:,:,:,139),gZd)
  call loop_Q_A(G1(:,:,:,139),Q(:,11),MB,G2(:,:,:,158))
  call loop_QA_V(G2(:,:,:,158),wf(:,-5),G2(:,:,:,159))
  call loop_VA_Q(G2(:,:,:,159),wf(:,-4),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,59),MB,G3(:,:,:,39))
  call check_last_AQ_V(l_switch,G3(:,:,:,39),wf(:,-2),G3tensor(:,59))
  call loop_QA_V(G2(:,:,:,158),wf(:,-4),G2(:,:,:,161))
  call loop_VA_Q(G2(:,:,:,161),wf(:,-5),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,59),MB,G3(:,:,:,40))
  call check_last_AQ_V(l_switch,G3(:,:,:,40),wf(:,-2),G3tensor(:,60))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,98),Q(:,27),G1(:,:,:,140))
  call loop_VA_Q(G1(:,:,:,140),wf(:,-5),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,59),MB,G2(:,:,:,163))
  call check_last_AQ_V(l_switch,G2(:,:,:,163),wf(:,-2),G2tensor(:,107))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,99),Q(:,27),G1(:,:,:,142))
  call loop_VA_Q(G1(:,:,:,142),wf(:,-5),G1(:,:,:,143))
  call loop_A_Q(G1(:,:,:,143),Q(:,59),MB,G2(:,:,:,164))
  call check_last_AQ_V(l_switch,G2(:,:,:,164),wf(:,-2),G2tensor(:,108))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,100),Q(:,43),G1(:,:,:,144))
  call loop_VA_Q(G1(:,:,:,144),wf(:,-4),G1(:,:,:,145))
  call loop_A_Q(G1(:,:,:,145),Q(:,59),MB,G2(:,:,:,165))
  call check_last_AQ_V(l_switch,G2(:,:,:,165),wf(:,-2),G2tensor(:,109))
  call check_last_UV_W(l_switch,G1(:,:,:,144),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,110))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,101),Q(:,43),G1(:,:,:,146))
  call loop_VA_Q(G1(:,:,:,146),wf(:,-4),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,59),MB,G2(:,:,:,166))
  call check_last_AQ_V(l_switch,G2(:,:,:,166),wf(:,-2),G2tensor(:,111))
  call check_last_UV_W(l_switch,G1(:,:,:,146),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,112))
  call loop_VQ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,11),MB,G1(:,:,:,148))
  call loop_QA_V(G1(:,:,:,148),wf(:,-5),G1(:,:,:,149))
  call loop_VA_Q(G1(:,:,:,149),wf(:,-4),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,59),MB,G2(:,:,:,167))
  call check_last_AQ_V(l_switch,G2(:,:,:,167),wf(:,-2),G2tensor(:,113))
  call loop_QA_V(G1(:,:,:,148),wf(:,-4),G1(:,:,:,151))
  call loop_VA_Q(G1(:,:,:,151),wf(:,-5),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,59),MB,G2(:,:,:,168))
  call check_last_AQ_V(l_switch,G2(:,:,:,168),wf(:,-2),G2tensor(:,114))
  call loop_VQ_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,11),MB,G1(:,:,:,153))
  call loop_QA_V(G1(:,:,:,153),wf(:,-5),G1(:,:,:,154))
  call loop_VA_Q(G1(:,:,:,154),wf(:,-4),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,59),MB,G2(:,:,:,169))
  call check_last_AQ_V(l_switch,G2(:,:,:,169),wf(:,-2),G2tensor(:,115))
  call loop_QA_V(G1(:,:,:,153),wf(:,-4),G1(:,:,:,156))
  call loop_VA_Q(G1(:,:,:,156),wf(:,-5),G1(:,:,:,157))
  call loop_A_Q(G1(:,:,:,157),Q(:,59),MB,G2(:,:,:,170))
  call check_last_AQ_V(l_switch,G2(:,:,:,170),wf(:,-2),G2tensor(:,116))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,102),Q(:,23),G1(:,:,:,158))
  call loop_VA_Q(G1(:,:,:,158),wf(:,-5),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,55),MB,G2(:,:,:,171))
  call check_last_AQ_V(l_switch,G2(:,:,:,171),wf(:,-3),G2tensor(:,117))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,103),Q(:,23),G1(:,:,:,160))
  call loop_VA_Q(G1(:,:,:,160),wf(:,-5),G1(:,:,:,161))
  call loop_A_Q(G1(:,:,:,161),Q(:,55),MB,G2(:,:,:,172))
  call check_last_AQ_V(l_switch,G2(:,:,:,172),wf(:,-3),G2tensor(:,118))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,104),Q(:,27),G1(:,:,:,162))
  call loop_VA_Q(G1(:,:,:,162),wf(:,-5),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,59),MB,G2(:,:,:,173))
  call check_last_AQ_V(l_switch,G2(:,:,:,173),wf(:,-2),G2tensor(:,119))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,105),Q(:,27),G1(:,:,:,164))
  call loop_VA_Q(G1(:,:,:,164),wf(:,-5),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,59),MB,G2(:,:,:,174))
  call check_last_AQ_V(l_switch,G2(:,:,:,174),wf(:,-2),G2tensor(:,120))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,106),Q(:,39),G1(:,:,:,166))
  call loop_VA_Q(G1(:,:,:,166),wf(:,-4),G1(:,:,:,167))
  call loop_A_Q(G1(:,:,:,167),Q(:,55),MB,G2(:,:,:,175))
  call check_last_AQ_V(l_switch,G2(:,:,:,175),wf(:,-3),G2tensor(:,121))
  call check_last_UV_W(l_switch,G1(:,:,:,166),Q(:,39),wf(:,14),Q(:,24),G2tensor(:,122))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,107),Q(:,39),G1(:,:,:,168))
  call loop_VA_Q(G1(:,:,:,168),wf(:,-4),G1(:,:,:,169))
  call loop_A_Q(G1(:,:,:,169),Q(:,55),MB,G2(:,:,:,176))
  call check_last_AQ_V(l_switch,G2(:,:,:,176),wf(:,-3),G2tensor(:,123))
  call check_last_UV_W(l_switch,G1(:,:,:,168),Q(:,39),wf(:,14),Q(:,24),G2tensor(:,124))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,108),Q(:,43),G1(:,:,:,170))
  call loop_VA_Q(G1(:,:,:,170),wf(:,-4),G1(:,:,:,171))
  call loop_A_Q(G1(:,:,:,171),Q(:,59),MB,G2(:,:,:,177))
  call check_last_AQ_V(l_switch,G2(:,:,:,177),wf(:,-2),G2tensor(:,125))
  call check_last_UV_W(l_switch,G1(:,:,:,170),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,126))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,109),Q(:,43),G1(:,:,:,172))
  call loop_VA_Q(G1(:,:,:,172),wf(:,-4),G1(:,:,:,173))
  call loop_A_Q(G1(:,:,:,173),Q(:,59),MB,G2(:,:,:,178))
  call check_last_AQ_V(l_switch,G2(:,:,:,178),wf(:,-2),G2tensor(:,127))
  call check_last_UV_W(l_switch,G1(:,:,:,172),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,128))
  call loop_QV_A(G0(:,:,:,1),wf(:,100),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,43),ZERO,G1(:,:,:,174))
  call loop_QV_A(G1(:,:,:,174),wf(:,2),G1(:,:,:,175))
  call check_last_Q_A(l_switch,G1(:,:,:,175),Q(:,63),ZERO,G2tensor(:,129))
  call loop_QV_A(G0(:,:,:,1),wf(:,100),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,43),MB,G1(:,:,:,176))
  call loop_QV_A(G1(:,:,:,176),wf(:,2),G1(:,:,:,177))
  call check_last_Q_A(l_switch,G1(:,:,:,177),Q(:,63),MB,G2tensor(:,130))
  call loop_QV_A(G0(:,:,:,1),wf(:,101),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,43),ZERO,G1(:,:,:,178))
  call loop_QV_A(G1(:,:,:,178),wf(:,2),G1(:,:,:,179))
  call check_last_Q_A(l_switch,G1(:,:,:,179),Q(:,63),ZERO,G2tensor(:,131))
  call loop_QV_A(G0(:,:,:,1),wf(:,101),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,43),MB,G1(:,:,:,180))
  call loop_QV_A(G1(:,:,:,180),wf(:,2),G1(:,:,:,181))
  call check_last_Q_A(l_switch,G1(:,:,:,181),Q(:,63),MB,G2tensor(:,132))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,100),Q(:,43),G1(:,:,:,182))
  call check_last_CV_D(l_switch,G1(:,:,:,182),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,133))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,101),Q(:,43),G1(:,:,:,183))
  call check_last_CV_D(l_switch,G1(:,:,:,183),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,134))
  call loop_QV_A(G0(:,:,:,1),wf(:,108),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,43),ZERO,G1(:,:,:,184))
  call loop_QV_A(G1(:,:,:,184),wf(:,2),G1(:,:,:,185))
  call check_last_Q_A(l_switch,G1(:,:,:,185),Q(:,63),ZERO,G2tensor(:,135))
  call loop_QV_A(G0(:,:,:,1),wf(:,108),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,43),MB,G1(:,:,:,186))
  call loop_QV_A(G1(:,:,:,186),wf(:,2),G1(:,:,:,187))
  call check_last_Q_A(l_switch,G1(:,:,:,187),Q(:,63),MB,G2tensor(:,136))
  call loop_QV_A(G0(:,:,:,1),wf(:,109),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,43),ZERO,G1(:,:,:,188))
  call loop_QV_A(G1(:,:,:,188),wf(:,2),G1(:,:,:,189))
  call check_last_Q_A(l_switch,G1(:,:,:,189),Q(:,63),ZERO,G2tensor(:,137))
  call loop_QV_A(G0(:,:,:,1),wf(:,109),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,43),MB,G1(:,:,:,190))
  call loop_QV_A(G1(:,:,:,190),wf(:,2),G1(:,:,:,191))
  call check_last_Q_A(l_switch,G1(:,:,:,191),Q(:,63),MB,G2tensor(:,138))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,108),Q(:,43),G1(:,:,:,192))
  call check_last_CV_D(l_switch,G1(:,:,:,192),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,139))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,109),Q(:,43),G1(:,:,:,193))
  call check_last_CV_D(l_switch,G1(:,:,:,193),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,140))
  call loop_QV_A(G0(:,:,:,1),wf(:,96),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,39),ZERO,G1(:,:,:,194))
  call loop_QV_A(G1(:,:,:,194),wf(:,14),G1(:,:,:,195))
  call check_last_Q_A(l_switch,G1(:,:,:,195),Q(:,63),ZERO,G2tensor(:,141))
  call loop_QV_A(G0(:,:,:,1),wf(:,96),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,39),MB,G1(:,:,:,196))
  call loop_QV_A(G1(:,:,:,196),wf(:,14),G1(:,:,:,197))
  call check_last_Q_A(l_switch,G1(:,:,:,197),Q(:,63),MB,G2tensor(:,142))
  call loop_QV_A(G0(:,:,:,1),wf(:,97),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,39),ZERO,G1(:,:,:,198))
  call loop_QV_A(G1(:,:,:,198),wf(:,14),G1(:,:,:,199))
  call check_last_Q_A(l_switch,G1(:,:,:,199),Q(:,63),ZERO,G2tensor(:,143))
  call loop_QV_A(G0(:,:,:,1),wf(:,97),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,39),MB,G1(:,:,:,200))
  call loop_QV_A(G1(:,:,:,200),wf(:,14),G1(:,:,:,201))
  call check_last_Q_A(l_switch,G1(:,:,:,201),Q(:,63),MB,G2tensor(:,144))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,96),Q(:,39),G1(:,:,:,202))
  call check_last_CV_D(l_switch,G1(:,:,:,202),Q(:,39),wf(:,14),Q(:,24),G2tensor(:,145))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,97),Q(:,39),G1(:,:,:,203))
  call check_last_CV_D(l_switch,G1(:,:,:,203),Q(:,39),wf(:,14),Q(:,24),G2tensor(:,146))
  call loop_QV_A(G0(:,:,:,1),wf(:,106),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,39),ZERO,G1(:,:,:,204))
  call loop_QV_A(G1(:,:,:,204),wf(:,14),G1(:,:,:,205))
  call check_last_Q_A(l_switch,G1(:,:,:,205),Q(:,63),ZERO,G2tensor(:,147))
  call loop_QV_A(G0(:,:,:,1),wf(:,106),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,39),MB,G1(:,:,:,206))
  call loop_QV_A(G1(:,:,:,206),wf(:,14),G1(:,:,:,207))
  call check_last_Q_A(l_switch,G1(:,:,:,207),Q(:,63),MB,G2tensor(:,148))
  call loop_QV_A(G0(:,:,:,1),wf(:,107),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,39),ZERO,G1(:,:,:,208))
  call loop_QV_A(G1(:,:,:,208),wf(:,14),G1(:,:,:,209))
  call check_last_Q_A(l_switch,G1(:,:,:,209),Q(:,63),ZERO,G2tensor(:,149))
  call loop_QV_A(G0(:,:,:,1),wf(:,107),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,39),MB,G1(:,:,:,210))
  call loop_QV_A(G1(:,:,:,210),wf(:,14),G1(:,:,:,211))
  call check_last_Q_A(l_switch,G1(:,:,:,211),Q(:,63),MB,G2tensor(:,150))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,106),Q(:,39),G1(:,:,:,212))
  call check_last_CV_D(l_switch,G1(:,:,:,212),Q(:,39),wf(:,14),Q(:,24),G2tensor(:,151))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,107),Q(:,39),G1(:,:,:,213))
  call check_last_CV_D(l_switch,G1(:,:,:,213),Q(:,39),wf(:,14),Q(:,24),G2tensor(:,152))
  call loop_QV_A(G0(:,:,:,1),wf(:,22),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,36),ZERO,G1(:,:,:,214))
  call loop_QV_A(G1(:,:,:,214),wf(:,98),G1(:,:,:,215))
  call check_last_Q_A(l_switch,G1(:,:,:,215),Q(:,63),ZERO,G2tensor(:,153))
  call loop_QV_A(G1(:,:,:,214),wf(:,99),G1(:,:,:,216))
  call check_last_Q_A(l_switch,G1(:,:,:,216),Q(:,63),ZERO,G2tensor(:,154))
  call loop_QV_A(G1(:,:,:,214),wf(:,104),G1(:,:,:,217))
  call check_last_Q_A(l_switch,G1(:,:,:,217),Q(:,63),ZERO,G2tensor(:,155))
  call loop_QV_A(G1(:,:,:,214),wf(:,105),G1(:,:,:,218))
  call check_last_Q_A(l_switch,G1(:,:,:,218),Q(:,63),ZERO,G2tensor(:,156))
  call loop_QV_A(G0(:,:,:,1),wf(:,22),G0(:,:,:,42))
  call loop_Q_A(G0(:,:,:,42),Q(:,36),MB,G1(:,:,:,219))
  call loop_QV_A(G1(:,:,:,219),wf(:,98),G1(:,:,:,220))
  call check_last_Q_A(l_switch,G1(:,:,:,220),Q(:,63),MB,G2tensor(:,157))
  call loop_QV_A(G1(:,:,:,219),wf(:,99),G1(:,:,:,221))
  call check_last_Q_A(l_switch,G1(:,:,:,221),Q(:,63),MB,G2tensor(:,158))
  call loop_QV_A(G1(:,:,:,219),wf(:,104),G1(:,:,:,222))
  call check_last_Q_A(l_switch,G1(:,:,:,222),Q(:,63),MB,G2tensor(:,159))
  call loop_QV_A(G1(:,:,:,219),wf(:,105),G1(:,:,:,223))
  call check_last_Q_A(l_switch,G1(:,:,:,223),Q(:,63),MB,G2tensor(:,160))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,22),Q(:,36),G1(:,:,:,224))
  call check_last_CV_D(l_switch,G1(:,:,:,224),Q(:,36),wf(:,98),Q(:,27),G2tensor(:,161))
  call check_last_CV_D(l_switch,G1(:,:,:,224),Q(:,36),wf(:,99),Q(:,27),G2tensor(:,162))
  call check_last_CV_D(l_switch,G1(:,:,:,224),Q(:,36),wf(:,104),Q(:,27),G2tensor(:,163))
  call check_last_CV_D(l_switch,G1(:,:,:,224),Q(:,36),wf(:,105),Q(:,27),G2tensor(:,164))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,40),ZERO,G1(:,:,:,225))
  call loop_QV_A(G1(:,:,:,225),wf(:,94),G1(:,:,:,226))
  call check_last_Q_A(l_switch,G1(:,:,:,226),Q(:,63),ZERO,G2tensor(:,165))
  call loop_QV_A(G1(:,:,:,225),wf(:,95),G1(:,:,:,227))
  call check_last_Q_A(l_switch,G1(:,:,:,227),Q(:,63),ZERO,G2tensor(:,166))
  call loop_QV_A(G1(:,:,:,225),wf(:,102),G1(:,:,:,228))
  call check_last_Q_A(l_switch,G1(:,:,:,228),Q(:,63),ZERO,G2tensor(:,167))
  call loop_QV_A(G1(:,:,:,225),wf(:,103),G1(:,:,:,229))
  call check_last_Q_A(l_switch,G1(:,:,:,229),Q(:,63),ZERO,G2tensor(:,168))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,44))
  call loop_Q_A(G0(:,:,:,44),Q(:,40),MB,G1(:,:,:,230))
  call loop_QV_A(G1(:,:,:,230),wf(:,94),G1(:,:,:,231))
  call check_last_Q_A(l_switch,G1(:,:,:,231),Q(:,63),MB,G2tensor(:,169))
  call loop_QV_A(G1(:,:,:,230),wf(:,95),G1(:,:,:,232))
  call check_last_Q_A(l_switch,G1(:,:,:,232),Q(:,63),MB,G2tensor(:,170))
  call loop_QV_A(G1(:,:,:,230),wf(:,102),G1(:,:,:,233))
  call check_last_Q_A(l_switch,G1(:,:,:,233),Q(:,63),MB,G2tensor(:,171))
  call loop_QV_A(G1(:,:,:,230),wf(:,103),G1(:,:,:,234))
  call check_last_Q_A(l_switch,G1(:,:,:,234),Q(:,63),MB,G2tensor(:,172))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,28),Q(:,40),G1(:,:,:,235))
  call check_last_CV_D(l_switch,G1(:,:,:,235),Q(:,40),wf(:,94),Q(:,23),G2tensor(:,173))
  call check_last_CV_D(l_switch,G1(:,:,:,235),Q(:,40),wf(:,95),Q(:,23),G2tensor(:,174))
  call check_last_CV_D(l_switch,G1(:,:,:,235),Q(:,40),wf(:,102),Q(:,23),G2tensor(:,175))
  call check_last_CV_D(l_switch,G1(:,:,:,235),Q(:,40),wf(:,103),Q(:,23),G2tensor(:,176))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(f(19)/4._/**/REALKIND) * den(123)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(123)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(19)/4._/**/REALKIND) * den(123)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (f(19)/12._/**/REALKIND * den(123)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(123)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(123)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(16)/4._/**/REALKIND * den(123)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,7),T3sum(1:35,2))
  M(2) = M(2) + (-(f(16)/12._/**/REALKIND) * den(123)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,7),T3sum(1:35,2))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(123)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(123)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(16)/4._/**/REALKIND * den(123)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,9),T3sum(1:35,2))
  M(2) = M(2) + (-(f(16)/12._/**/REALKIND) * den(123)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,9),T3sum(1:35,2))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(124)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(124)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(124)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(124)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(124)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(124)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (f(18)/4._/**/REALKIND * den(124)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,8),T3sum(1:35,2))
  M(2) = M(2) + (-(f(18)/12._/**/REALKIND) * den(124)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,8),T3sum(1:35,2))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(124)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(124)) * TI2_call(3,momenta_17,masses2_7,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(18)/4._/**/REALKIND * den(124)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,10),T3sum(1:35,2))
  M(2) = M(2) + (-(f(18)/12._/**/REALKIND) * den(124)) * TI2_call(3,momenta_17,masses2_4,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(5)) * TI2_call(2,momenta_24,masses2_5,G2tensor(:,1),T2sum(1:15,1))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(5)) * TI2_call(2,momenta_24,masses2_5,G2tensor(:,1),T2sum(1:15,1))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(8)) * TI2_call(2,momenta_24,masses2_5,G2tensor(:,2),T2sum(1:15,1))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(8)) * TI2_call(2,momenta_24,masses2_5,G2tensor(:,2),T2sum(1:15,1))
  M(1) = M(1) + ((-3*CI*f(10))/4._/**/REALKIND * den(5)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,23),T2sum(1:15,2))
  M(2) = M(2) + ((CI*f(10))/4._/**/REALKIND * den(5)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,23),T2sum(1:15,2))
  M(1) = M(1) + ((-3*CI*f(11))/4._/**/REALKIND * den(8)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,24),T2sum(1:15,2))
  M(2) = M(2) + ((CI*f(11))/4._/**/REALKIND * den(8)) * TI2_call(2,momenta_15,masses2_6,G2tensor(:,24),T2sum(1:15,2))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(41)) * TI2_call(2,momenta_28,masses2_5,G2tensor(:,27),T2sum(1:15,3))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(41)) * TI2_call(2,momenta_28,masses2_5,G2tensor(:,27),T2sum(1:15,3))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(43)) * TI2_call(2,momenta_28,masses2_5,G2tensor(:,30),T2sum(1:15,3))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(43)) * TI2_call(2,momenta_28,masses2_5,G2tensor(:,30),T2sum(1:15,3))
  M(1) = M(1) + ((-3*CI*f(10))/4._/**/REALKIND * den(41)) * TI2_call(2,momenta_16,masses2_6,G2tensor(:,25),T2sum(1:15,4))
  M(2) = M(2) + ((CI*f(10))/4._/**/REALKIND * den(41)) * TI2_call(2,momenta_16,masses2_6,G2tensor(:,25),T2sum(1:15,4))
  M(1) = M(1) + ((-3*CI*f(11))/4._/**/REALKIND * den(43)) * TI2_call(2,momenta_16,masses2_6,G2tensor(:,26),T2sum(1:15,4))
  M(2) = M(2) + ((CI*f(11))/4._/**/REALKIND * den(43)) * TI2_call(2,momenta_16,masses2_6,G2tensor(:,26),T2sum(1:15,4))
  M(1) = M(1) + ((-2*f(13))/3._/**/REALKIND * den(11)) * TI2_call(2,momenta_23,masses2_5,G2tensor(:,3),T2sum(1:15,5))
  M(2) = M(2) + ((2*f(13))/9._/**/REALKIND * den(11)) * TI2_call(2,momenta_23,masses2_5,G2tensor(:,3),T2sum(1:15,5))
  M(1) = M(1) + ((-2*f(15))/3._/**/REALKIND * den(12)) * TI2_call(2,momenta_23,masses2_5,G2tensor(:,5),T2sum(1:15,5))
  M(2) = M(2) + ((2*f(15))/9._/**/REALKIND * den(12)) * TI2_call(2,momenta_23,masses2_5,G2tensor(:,5),T2sum(1:15,5))
  M(1) = M(1) + ((-2*f(13))/3._/**/REALKIND * den(46)) * TI2_call(2,momenta_37,masses2_5,G2tensor(:,33),T2sum(1:15,6))
  M(2) = M(2) + ((2*f(13))/9._/**/REALKIND * den(46)) * TI2_call(2,momenta_37,masses2_5,G2tensor(:,33),T2sum(1:15,6))
  M(1) = M(1) + ((-2*f(15))/3._/**/REALKIND * den(47)) * TI2_call(2,momenta_37,masses2_5,G2tensor(:,34),T2sum(1:15,6))
  M(2) = M(2) + ((2*f(15))/9._/**/REALKIND * den(47)) * TI2_call(2,momenta_37,masses2_5,G2tensor(:,34),T2sum(1:15,6))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(125)) * TI2_call(3,momenta_62,masses2_8,G3tensor(:,11),T3sum(1:35,3))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(125)) * TI2_call(3,momenta_62,masses2_8,G3tensor(:,11),T3sum(1:35,3))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(35)) * TI2_call(3,momenta_62,masses2_8,G3tensor(:,12),T3sum(1:35,3))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(35)) * TI2_call(3,momenta_62,masses2_8,G3tensor(:,12),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(125)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,13),T3sum(1:35,4))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(125)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,13),T3sum(1:35,4))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(35)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,16),T3sum(1:35,4))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(35)) * TI2_call(3,momenta_57,masses2_8,G3tensor(:,16),T3sum(1:35,4))
  M(1) = M(1) + ((-3*CI*f(10))/4._/**/REALKIND * den(125)) * TI2_call(3,momenta_55,masses2_10,G3tensor(:,23),T3sum(1:35,5))
  M(2) = M(2) + ((CI*f(10))/4._/**/REALKIND * den(125)) * TI2_call(3,momenta_55,masses2_10,G3tensor(:,23),T3sum(1:35,5))
  M(1) = M(1) + ((-3*CI*f(11))/4._/**/REALKIND * den(35)) * TI2_call(3,momenta_55,masses2_10,G3tensor(:,24),T3sum(1:35,5))
  M(2) = M(2) + ((CI*f(11))/4._/**/REALKIND * den(35)) * TI2_call(3,momenta_55,masses2_10,G3tensor(:,24),T3sum(1:35,5))
  M(1) = M(1) + (-(f(19)/12._/**/REALKIND) * den(126)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,25),T3sum(1:35,6))
  M(2) = M(2) + (f(19)/4._/**/REALKIND * den(126)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,25),T3sum(1:35,6))
  M(1) = M(1) + (-(f(19)/12._/**/REALKIND) * den(126)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,28),T3sum(1:35,6))
  M(2) = M(2) + (f(19)/4._/**/REALKIND * den(126)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,28),T3sum(1:35,6))
  M(1) = M(1) + (f(17)/12._/**/REALKIND * den(126)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,25),T3sum(1:35,6))
  M(2) = M(2) + (-(f(17)/4._/**/REALKIND) * den(126)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,25),T3sum(1:35,6))
  M(1) = M(1) + (f(16)/12._/**/REALKIND * den(126)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,31),T3sum(1:35,7))
  M(2) = M(2) + (-(f(16)/4._/**/REALKIND) * den(126)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,31),T3sum(1:35,7))
  M(1) = M(1) + (f(17)/12._/**/REALKIND * den(126)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,28),T3sum(1:35,6))
  M(2) = M(2) + (-(f(17)/4._/**/REALKIND) * den(126)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,28),T3sum(1:35,6))
  M(1) = M(1) + (f(16)/12._/**/REALKIND * den(126)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,33),T3sum(1:35,7))
  M(2) = M(2) + (-(f(16)/4._/**/REALKIND) * den(126)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,33),T3sum(1:35,7))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(127)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,26),T3sum(1:35,6))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(127)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,26),T3sum(1:35,6))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(127)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,29),T3sum(1:35,6))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(127)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,29),T3sum(1:35,6))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(127)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,27),T3sum(1:35,6))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(127)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,27),T3sum(1:35,6))
  M(1) = M(1) + (f(18)/12._/**/REALKIND * den(127)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,32),T3sum(1:35,7))
  M(2) = M(2) + (-(f(18)/4._/**/REALKIND) * den(127)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,32),T3sum(1:35,7))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(127)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,30),T3sum(1:35,6))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(127)) * TI2_call(3,momenta_21,masses2_7,G3tensor(:,30),T3sum(1:35,6))
  M(1) = M(1) + (f(18)/12._/**/REALKIND * den(127)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,34),T3sum(1:35,7))
  M(2) = M(2) + (-(f(18)/4._/**/REALKIND) * den(127)) * TI2_call(3,momenta_21,masses2_4,G3tensor(:,34),T3sum(1:35,7))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(16)) * TI2_call(2,momenta_26,masses2_5,G2tensor(:,7),T2sum(1:15,7))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(16)) * TI2_call(2,momenta_26,masses2_5,G2tensor(:,7),T2sum(1:15,7))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(18)) * TI2_call(2,momenta_26,masses2_5,G2tensor(:,8),T2sum(1:15,7))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(18)) * TI2_call(2,momenta_26,masses2_5,G2tensor(:,8),T2sum(1:15,7))
  M(1) = M(1) + (-(CI*f(10))/4._/**/REALKIND * den(16)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,35),T2sum(1:15,8))
  M(2) = M(2) + ((3*CI*f(10))/4._/**/REALKIND * den(16)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,35),T2sum(1:15,8))
  M(1) = M(1) + (-(CI*f(11))/4._/**/REALKIND * den(18)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,36),T2sum(1:15,8))
  M(2) = M(2) + ((3*CI*f(11))/4._/**/REALKIND * den(18)) * TI2_call(2,momenta_19,masses2_6,G2tensor(:,36),T2sum(1:15,8))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(56)) * TI2_call(2,momenta_29,masses2_5,G2tensor(:,28),T2sum(1:15,9))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(56)) * TI2_call(2,momenta_29,masses2_5,G2tensor(:,28),T2sum(1:15,9))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(57)) * TI2_call(2,momenta_29,masses2_5,G2tensor(:,31),T2sum(1:15,9))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(57)) * TI2_call(2,momenta_29,masses2_5,G2tensor(:,31),T2sum(1:15,9))
  M(1) = M(1) + (-(CI*f(10))/4._/**/REALKIND * den(56)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,37),T2sum(1:15,10))
  M(2) = M(2) + ((3*CI*f(10))/4._/**/REALKIND * den(56)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,37),T2sum(1:15,10))
  M(1) = M(1) + (-(CI*f(11))/4._/**/REALKIND * den(57)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,38),T2sum(1:15,10))
  M(2) = M(2) + ((3*CI*f(11))/4._/**/REALKIND * den(57)) * TI2_call(2,momenta_20,masses2_6,G2tensor(:,38),T2sum(1:15,10))
  M(1) = M(1) + ((-2*f(13))/9._/**/REALKIND * den(20)) * TI2_call(2,momenta_23,masses2_5,G2tensor(:,4),T2sum(1:15,5))
  M(2) = M(2) + ((2*f(13))/3._/**/REALKIND * den(20)) * TI2_call(2,momenta_23,masses2_5,G2tensor(:,4),T2sum(1:15,5))
  M(1) = M(1) + ((-2*f(15))/9._/**/REALKIND * den(21)) * TI2_call(2,momenta_23,masses2_5,G2tensor(:,6),T2sum(1:15,5))
  M(2) = M(2) + ((2*f(15))/3._/**/REALKIND * den(21)) * TI2_call(2,momenta_23,masses2_5,G2tensor(:,6),T2sum(1:15,5))
  M(1) = M(1) + ((-2*f(13))/9._/**/REALKIND * den(60)) * TI2_call(2,momenta_38,masses2_5,G2tensor(:,39),T2sum(1:15,11))
  M(2) = M(2) + ((2*f(13))/3._/**/REALKIND * den(60)) * TI2_call(2,momenta_38,masses2_5,G2tensor(:,39),T2sum(1:15,11))
  M(1) = M(1) + ((-2*f(15))/9._/**/REALKIND * den(61)) * TI2_call(2,momenta_38,masses2_5,G2tensor(:,40),T2sum(1:15,11))
  M(2) = M(2) + ((2*f(15))/3._/**/REALKIND * den(61)) * TI2_call(2,momenta_38,masses2_5,G2tensor(:,40),T2sum(1:15,11))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(128)) * TI2_call(3,momenta_63,masses2_8,G3tensor(:,19),T3sum(1:35,8))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(128)) * TI2_call(3,momenta_63,masses2_8,G3tensor(:,19),T3sum(1:35,8))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(129)) * TI2_call(3,momenta_63,masses2_8,G3tensor(:,20),T3sum(1:35,8))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(129)) * TI2_call(3,momenta_63,masses2_8,G3tensor(:,20),T3sum(1:35,8))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(128)) * TI2_call(3,momenta_58,masses2_8,G3tensor(:,14),T3sum(1:35,9))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(128)) * TI2_call(3,momenta_58,masses2_8,G3tensor(:,14),T3sum(1:35,9))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(129)) * TI2_call(3,momenta_58,masses2_8,G3tensor(:,17),T3sum(1:35,9))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(129)) * TI2_call(3,momenta_58,masses2_8,G3tensor(:,17),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(10))/4._/**/REALKIND * den(128)) * TI2_call(3,momenta_56,masses2_10,G3tensor(:,35),T3sum(1:35,10))
  M(2) = M(2) + ((3*CI*f(10))/4._/**/REALKIND * den(128)) * TI2_call(3,momenta_56,masses2_10,G3tensor(:,35),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(11))/4._/**/REALKIND * den(129)) * TI2_call(3,momenta_56,masses2_10,G3tensor(:,36),T3sum(1:35,10))
  M(2) = M(2) + ((3*CI*f(11))/4._/**/REALKIND * den(129)) * TI2_call(3,momenta_56,masses2_10,G3tensor(:,36),T3sum(1:35,10))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(23)) * TI2_call(2,momenta_9,masses2_5,G2tensor(:,41),T2sum(1:15,12))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(23)) * TI2_call(2,momenta_9,masses2_5,G2tensor(:,41),T2sum(1:15,12))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(24)) * TI2_call(2,momenta_9,masses2_5,G2tensor(:,42),T2sum(1:15,12))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(24)) * TI2_call(2,momenta_9,masses2_5,G2tensor(:,42),T2sum(1:15,12))
  M(1) = M(1) + (-(CI*f(10))/4._/**/REALKIND * den(23)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,59),T2sum(1:15,13))
  M(2) = M(2) + ((3*CI*f(10))/4._/**/REALKIND * den(23)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,59),T2sum(1:15,13))
  M(1) = M(1) + (-(CI*f(11))/4._/**/REALKIND * den(24)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,60),T2sum(1:15,13))
  M(2) = M(2) + ((3*CI*f(11))/4._/**/REALKIND * den(24)) * TI2_call(2,momenta_30,masses2_6,G2tensor(:,60),T2sum(1:15,13))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(50)) * TI2_call(2,momenta_13,masses2_5,G2tensor(:,67),T2sum(1:15,14))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(50)) * TI2_call(2,momenta_13,masses2_5,G2tensor(:,67),T2sum(1:15,14))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(52)) * TI2_call(2,momenta_13,masses2_5,G2tensor(:,70),T2sum(1:15,14))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(52)) * TI2_call(2,momenta_13,masses2_5,G2tensor(:,70),T2sum(1:15,14))
  M(1) = M(1) + (-(CI*f(10))/4._/**/REALKIND * den(50)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,61),T2sum(1:15,15))
  M(2) = M(2) + ((3*CI*f(10))/4._/**/REALKIND * den(50)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,61),T2sum(1:15,15))
  M(1) = M(1) + (-(CI*f(11))/4._/**/REALKIND * den(52)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,62),T2sum(1:15,15))
  M(2) = M(2) + ((3*CI*f(11))/4._/**/REALKIND * den(52)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,62),T2sum(1:15,15))
  M(1) = M(1) + ((-2*f(13))/9._/**/REALKIND * den(27)) * TI2_call(2,momenta_36,masses2_5,G2tensor(:,73),T2sum(1:15,16))
  M(2) = M(2) + ((2*f(13))/3._/**/REALKIND * den(27)) * TI2_call(2,momenta_36,masses2_5,G2tensor(:,73),T2sum(1:15,16))
  M(1) = M(1) + ((-2*f(15))/9._/**/REALKIND * den(28)) * TI2_call(2,momenta_36,masses2_5,G2tensor(:,74),T2sum(1:15,16))
  M(2) = M(2) + ((2*f(15))/3._/**/REALKIND * den(28)) * TI2_call(2,momenta_36,masses2_5,G2tensor(:,74),T2sum(1:15,16))
  M(1) = M(1) + ((-2*f(13))/9._/**/REALKIND * den(54)) * TI2_call(2,momenta_37,masses2_5,G2tensor(:,75),T2sum(1:15,6))
  M(2) = M(2) + ((2*f(13))/3._/**/REALKIND * den(54)) * TI2_call(2,momenta_37,masses2_5,G2tensor(:,75),T2sum(1:15,6))
  M(1) = M(1) + ((-2*f(15))/9._/**/REALKIND * den(55)) * TI2_call(2,momenta_37,masses2_5,G2tensor(:,76),T2sum(1:15,6))
  M(2) = M(2) + ((2*f(15))/3._/**/REALKIND * den(55)) * TI2_call(2,momenta_37,masses2_5,G2tensor(:,76),T2sum(1:15,6))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(130)) * TI2_call(3,momenta_52,masses2_8,G3tensor(:,37),T3sum(1:35,11))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(130)) * TI2_call(3,momenta_52,masses2_8,G3tensor(:,37),T3sum(1:35,11))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(37)) * TI2_call(3,momenta_52,masses2_8,G3tensor(:,38),T3sum(1:35,11))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(37)) * TI2_call(3,momenta_52,masses2_8,G3tensor(:,38),T3sum(1:35,11))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(130)) * TI2_call(3,momenta_47,masses2_8,G3tensor(:,39),T3sum(1:35,12))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(130)) * TI2_call(3,momenta_47,masses2_8,G3tensor(:,39),T3sum(1:35,12))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(37)) * TI2_call(3,momenta_47,masses2_8,G3tensor(:,42),T3sum(1:35,12))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(37)) * TI2_call(3,momenta_47,masses2_8,G3tensor(:,42),T3sum(1:35,12))
  M(1) = M(1) + (-(CI*f(10))/4._/**/REALKIND * den(130)) * TI2_call(3,momenta_65,masses2_10,G3tensor(:,49),T3sum(1:35,13))
  M(2) = M(2) + ((3*CI*f(10))/4._/**/REALKIND * den(130)) * TI2_call(3,momenta_65,masses2_10,G3tensor(:,49),T3sum(1:35,13))
  M(1) = M(1) + (-(CI*f(11))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_65,masses2_10,G3tensor(:,50),T3sum(1:35,13))
  M(2) = M(2) + ((3*CI*f(11))/4._/**/REALKIND * den(37)) * TI2_call(3,momenta_65,masses2_10,G3tensor(:,50),T3sum(1:35,13))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(30)) * TI2_call(2,momenta_11,masses2_5,G2tensor(:,43),T2sum(1:15,17))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(30)) * TI2_call(2,momenta_11,masses2_5,G2tensor(:,43),T2sum(1:15,17))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(31)) * TI2_call(2,momenta_11,masses2_5,G2tensor(:,44),T2sum(1:15,17))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(31)) * TI2_call(2,momenta_11,masses2_5,G2tensor(:,44),T2sum(1:15,17))
  M(1) = M(1) + ((-3*CI*f(10))/4._/**/REALKIND * den(30)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,77),T2sum(1:15,18))
  M(2) = M(2) + ((CI*f(10))/4._/**/REALKIND * den(30)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,77),T2sum(1:15,18))
  M(1) = M(1) + ((-3*CI*f(11))/4._/**/REALKIND * den(31)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,78),T2sum(1:15,18))
  M(2) = M(2) + ((CI*f(11))/4._/**/REALKIND * den(31)) * TI2_call(2,momenta_33,masses2_6,G2tensor(:,78),T2sum(1:15,18))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(62)) * TI2_call(2,momenta_14,masses2_5,G2tensor(:,68),T2sum(1:15,19))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(62)) * TI2_call(2,momenta_14,masses2_5,G2tensor(:,68),T2sum(1:15,19))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(63)) * TI2_call(2,momenta_14,masses2_5,G2tensor(:,71),T2sum(1:15,19))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(63)) * TI2_call(2,momenta_14,masses2_5,G2tensor(:,71),T2sum(1:15,19))
  M(1) = M(1) + ((-3*CI*f(10))/4._/**/REALKIND * den(62)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,79),T2sum(1:15,20))
  M(2) = M(2) + ((CI*f(10))/4._/**/REALKIND * den(62)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,79),T2sum(1:15,20))
  M(1) = M(1) + ((-3*CI*f(11))/4._/**/REALKIND * den(63)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,80),T2sum(1:15,20))
  M(2) = M(2) + ((CI*f(11))/4._/**/REALKIND * den(63)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,80),T2sum(1:15,20))
  M(1) = M(1) + ((-2*f(13))/3._/**/REALKIND * den(33)) * TI2_call(2,momenta_36,masses2_5,G2tensor(:,85),T2sum(1:15,16))
  M(2) = M(2) + ((2*f(13))/9._/**/REALKIND * den(33)) * TI2_call(2,momenta_36,masses2_5,G2tensor(:,85),T2sum(1:15,16))
  M(1) = M(1) + ((-2*f(15))/3._/**/REALKIND * den(34)) * TI2_call(2,momenta_36,masses2_5,G2tensor(:,86),T2sum(1:15,16))
  M(2) = M(2) + ((2*f(15))/9._/**/REALKIND * den(34)) * TI2_call(2,momenta_36,masses2_5,G2tensor(:,86),T2sum(1:15,16))
  M(1) = M(1) + ((-2*f(13))/3._/**/REALKIND * den(65)) * TI2_call(2,momenta_38,masses2_5,G2tensor(:,87),T2sum(1:15,11))
  M(2) = M(2) + ((2*f(13))/9._/**/REALKIND * den(65)) * TI2_call(2,momenta_38,masses2_5,G2tensor(:,87),T2sum(1:15,11))
  M(1) = M(1) + ((-2*f(15))/3._/**/REALKIND * den(66)) * TI2_call(2,momenta_38,masses2_5,G2tensor(:,88),T2sum(1:15,11))
  M(2) = M(2) + ((2*f(15))/9._/**/REALKIND * den(66)) * TI2_call(2,momenta_38,masses2_5,G2tensor(:,88),T2sum(1:15,11))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(131)) * TI2_call(3,momenta_53,masses2_8,G3tensor(:,45),T3sum(1:35,14))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(131)) * TI2_call(3,momenta_53,masses2_8,G3tensor(:,45),T3sum(1:35,14))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(132)) * TI2_call(3,momenta_53,masses2_8,G3tensor(:,46),T3sum(1:35,14))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(132)) * TI2_call(3,momenta_53,masses2_8,G3tensor(:,46),T3sum(1:35,14))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(131)) * TI2_call(3,momenta_48,masses2_8,G3tensor(:,40),T3sum(1:35,15))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(131)) * TI2_call(3,momenta_48,masses2_8,G3tensor(:,40),T3sum(1:35,15))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(132)) * TI2_call(3,momenta_48,masses2_8,G3tensor(:,43),T3sum(1:35,15))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(132)) * TI2_call(3,momenta_48,masses2_8,G3tensor(:,43),T3sum(1:35,15))
  M(1) = M(1) + ((-3*CI*f(10))/4._/**/REALKIND * den(131)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,51),T3sum(1:35,16))
  M(2) = M(2) + ((CI*f(10))/4._/**/REALKIND * den(131)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,51),T3sum(1:35,16))
  M(1) = M(1) + ((-3*CI*f(11))/4._/**/REALKIND * den(132)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,52),T3sum(1:35,16))
  M(2) = M(2) + ((CI*f(11))/4._/**/REALKIND * den(132)) * TI2_call(3,momenta_66,masses2_10,G3tensor(:,52),T3sum(1:35,16))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(104)) * TI2_call(2,momenta_25,masses2_5,G2tensor(:,9),T2sum(1:15,21))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(104)) * TI2_call(2,momenta_25,masses2_5,G2tensor(:,9),T2sum(1:15,21))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(105)) * TI2_call(2,momenta_25,masses2_5,G2tensor(:,10),T2sum(1:15,21))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(105)) * TI2_call(2,momenta_25,masses2_5,G2tensor(:,10),T2sum(1:15,21))
  M(1) = M(1) + ((-3*CI*f(10))/4._/**/REALKIND * den(104)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,89),T2sum(1:15,22))
  M(2) = M(2) + ((CI*f(10))/4._/**/REALKIND * den(104)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,89),T2sum(1:15,22))
  M(1) = M(1) + ((-3*CI*f(11))/4._/**/REALKIND * den(105)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,90),T2sum(1:15,22))
  M(2) = M(2) + ((CI*f(11))/4._/**/REALKIND * den(105)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,90),T2sum(1:15,22))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(107)) * TI2_call(2,momenta_10,masses2_5,G2tensor(:,45),T2sum(1:15,23))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(107)) * TI2_call(2,momenta_10,masses2_5,G2tensor(:,45),T2sum(1:15,23))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(108)) * TI2_call(2,momenta_10,masses2_5,G2tensor(:,46),T2sum(1:15,23))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(108)) * TI2_call(2,momenta_10,masses2_5,G2tensor(:,46),T2sum(1:15,23))
  M(1) = M(1) + (-(CI*f(10))/4._/**/REALKIND * den(107)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,91),T2sum(1:15,24))
  M(2) = M(2) + ((3*CI*f(10))/4._/**/REALKIND * den(107)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,91),T2sum(1:15,24))
  M(1) = M(1) + (-(CI*f(11))/4._/**/REALKIND * den(108)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,93),T2sum(1:15,24))
  M(2) = M(2) + ((3*CI*f(11))/4._/**/REALKIND * den(108)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,93),T2sum(1:15,24))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(15)) * TI2_call(2,momenta_49,masses2_9,G2tensor(:,47),T2sum(1:15,25))
  M(2) = M(2) + ((7*f(13))/12._/**/REALKIND * den(15)) * TI2_call(2,momenta_49,masses2_9,G2tensor(:,47),T2sum(1:15,25))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(17)) * TI2_call(2,momenta_49,masses2_9,G2tensor(:,48),T2sum(1:15,25))
  M(2) = M(2) + ((7*f(15))/12._/**/REALKIND * den(17)) * TI2_call(2,momenta_49,masses2_9,G2tensor(:,48),T2sum(1:15,25))
  M(1) = M(1) + ((-7*f(13))/12._/**/REALKIND * den(15)) * TI2_call(2,momenta_59,masses2_9,G2tensor(:,11),T2sum(1:15,26))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(15)) * TI2_call(2,momenta_59,masses2_9,G2tensor(:,11),T2sum(1:15,26))
  M(1) = M(1) + ((-7*f(15))/12._/**/REALKIND * den(17)) * TI2_call(2,momenta_59,masses2_9,G2tensor(:,12),T2sum(1:15,26))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(17)) * TI2_call(2,momenta_59,masses2_9,G2tensor(:,12),T2sum(1:15,26))
  M(1) = M(1) + ((5*f(13))/18._/**/REALKIND * den(15)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,95),T2sum(1:15,27))
  M(2) = M(2) + (-(f(13)/6._/**/REALKIND) * den(15)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,95),T2sum(1:15,27))
  M(1) = M(1) + ((5*f(15))/18._/**/REALKIND * den(17)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,96),T2sum(1:15,27))
  M(2) = M(2) + (-(f(15)/6._/**/REALKIND) * den(17)) * TI2_call(2,momenta_39,masses2_9,G2tensor(:,96),T2sum(1:15,27))
  M(1) = M(1) + (f(13)/6._/**/REALKIND * den(15)) * TI2_call(2,momenta_42,masses2_9,G2tensor(:,99),T2sum(1:15,28))
  M(2) = M(2) + ((-5*f(13))/18._/**/REALKIND * den(15)) * TI2_call(2,momenta_42,masses2_9,G2tensor(:,99),T2sum(1:15,28))
  M(1) = M(1) + (f(15)/6._/**/REALKIND * den(17)) * TI2_call(2,momenta_42,masses2_9,G2tensor(:,100),T2sum(1:15,28))
  M(2) = M(2) + ((-5*f(15))/18._/**/REALKIND * den(17)) * TI2_call(2,momenta_42,masses2_9,G2tensor(:,100),T2sum(1:15,28))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(110)) * TI2_call(2,momenta_27,masses2_5,G2tensor(:,15),T2sum(1:15,29))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(110)) * TI2_call(2,momenta_27,masses2_5,G2tensor(:,15),T2sum(1:15,29))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(111)) * TI2_call(2,momenta_27,masses2_5,G2tensor(:,16),T2sum(1:15,29))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(111)) * TI2_call(2,momenta_27,masses2_5,G2tensor(:,16),T2sum(1:15,29))
  M(1) = M(1) + (-(CI*f(10))/4._/**/REALKIND * den(110)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,107),T2sum(1:15,30))
  M(2) = M(2) + ((3*CI*f(10))/4._/**/REALKIND * den(110)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,107),T2sum(1:15,30))
  M(1) = M(1) + (-(CI*f(11))/4._/**/REALKIND * den(111)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,108),T2sum(1:15,30))
  M(2) = M(2) + ((3*CI*f(11))/4._/**/REALKIND * den(111)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,108),T2sum(1:15,30))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(113)) * TI2_call(2,momenta_12,masses2_5,G2tensor(:,51),T2sum(1:15,31))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(113)) * TI2_call(2,momenta_12,masses2_5,G2tensor(:,51),T2sum(1:15,31))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(114)) * TI2_call(2,momenta_12,masses2_5,G2tensor(:,52),T2sum(1:15,31))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(114)) * TI2_call(2,momenta_12,masses2_5,G2tensor(:,52),T2sum(1:15,31))
  M(1) = M(1) + ((-3*CI*f(10))/4._/**/REALKIND * den(113)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,109),T2sum(1:15,32))
  M(2) = M(2) + ((CI*f(10))/4._/**/REALKIND * den(113)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,109),T2sum(1:15,32))
  M(1) = M(1) + ((-3*CI*f(11))/4._/**/REALKIND * den(114)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,111),T2sum(1:15,32))
  M(2) = M(2) + ((CI*f(11))/4._/**/REALKIND * den(114)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,111),T2sum(1:15,32))
  M(1) = M(1) + ((-7*f(13))/12._/**/REALKIND * den(4)) * TI2_call(2,momenta_61,masses2_9,G2tensor(:,17),T2sum(1:15,33))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(4)) * TI2_call(2,momenta_61,masses2_9,G2tensor(:,17),T2sum(1:15,33))
  M(1) = M(1) + ((-7*f(15))/12._/**/REALKIND * den(7)) * TI2_call(2,momenta_61,masses2_9,G2tensor(:,18),T2sum(1:15,33))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(7)) * TI2_call(2,momenta_61,masses2_9,G2tensor(:,18),T2sum(1:15,33))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(4)) * TI2_call(2,momenta_51,masses2_9,G2tensor(:,53),T2sum(1:15,34))
  M(2) = M(2) + ((7*f(13))/12._/**/REALKIND * den(4)) * TI2_call(2,momenta_51,masses2_9,G2tensor(:,53),T2sum(1:15,34))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(7)) * TI2_call(2,momenta_51,masses2_9,G2tensor(:,54),T2sum(1:15,34))
  M(2) = M(2) + ((7*f(15))/12._/**/REALKIND * den(7)) * TI2_call(2,momenta_51,masses2_9,G2tensor(:,54),T2sum(1:15,34))
  M(1) = M(1) + (f(13)/6._/**/REALKIND * den(4)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,113),T2sum(1:15,35))
  M(2) = M(2) + ((-5*f(13))/18._/**/REALKIND * den(4)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,113),T2sum(1:15,35))
  M(1) = M(1) + (f(15)/6._/**/REALKIND * den(7)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,115),T2sum(1:15,35))
  M(2) = M(2) + ((-5*f(15))/18._/**/REALKIND * den(7)) * TI2_call(2,momenta_46,masses2_9,G2tensor(:,115),T2sum(1:15,35))
  M(1) = M(1) + ((5*f(13))/18._/**/REALKIND * den(4)) * TI2_call(2,momenta_45,masses2_9,G2tensor(:,114),T2sum(1:15,36))
  M(2) = M(2) + (-(f(13)/6._/**/REALKIND) * den(4)) * TI2_call(2,momenta_45,masses2_9,G2tensor(:,114),T2sum(1:15,36))
  M(1) = M(1) + ((5*f(15))/18._/**/REALKIND * den(7)) * TI2_call(2,momenta_45,masses2_9,G2tensor(:,116),T2sum(1:15,36))
  M(2) = M(2) + (-(f(15)/6._/**/REALKIND) * den(7)) * TI2_call(2,momenta_45,masses2_9,G2tensor(:,116),T2sum(1:15,36))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(115)) * TI2_call(2,momenta_25,masses2_5,G2tensor(:,19),T2sum(1:15,21))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(115)) * TI2_call(2,momenta_25,masses2_5,G2tensor(:,19),T2sum(1:15,21))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(116)) * TI2_call(2,momenta_25,masses2_5,G2tensor(:,20),T2sum(1:15,21))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(116)) * TI2_call(2,momenta_25,masses2_5,G2tensor(:,20),T2sum(1:15,21))
  M(1) = M(1) + ((-3*CI*f(10))/4._/**/REALKIND * den(115)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,117),T2sum(1:15,22))
  M(2) = M(2) + ((CI*f(10))/4._/**/REALKIND * den(115)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,117),T2sum(1:15,22))
  M(1) = M(1) + ((-3*CI*f(11))/4._/**/REALKIND * den(116)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,118),T2sum(1:15,22))
  M(2) = M(2) + ((CI*f(11))/4._/**/REALKIND * den(116)) * TI2_call(2,momenta_18,masses2_6,G2tensor(:,118),T2sum(1:15,22))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(117)) * TI2_call(2,momenta_27,masses2_5,G2tensor(:,21),T2sum(1:15,29))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(117)) * TI2_call(2,momenta_27,masses2_5,G2tensor(:,21),T2sum(1:15,29))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(118)) * TI2_call(2,momenta_27,masses2_5,G2tensor(:,22),T2sum(1:15,29))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(118)) * TI2_call(2,momenta_27,masses2_5,G2tensor(:,22),T2sum(1:15,29))
  M(1) = M(1) + (-(CI*f(10))/4._/**/REALKIND * den(117)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,119),T2sum(1:15,30))
  M(2) = M(2) + ((3*CI*f(10))/4._/**/REALKIND * den(117)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,119),T2sum(1:15,30))
  M(1) = M(1) + (-(CI*f(11))/4._/**/REALKIND * den(118)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,120),T2sum(1:15,30))
  M(2) = M(2) + ((3*CI*f(11))/4._/**/REALKIND * den(118)) * TI2_call(2,momenta_22,masses2_6,G2tensor(:,120),T2sum(1:15,30))
  M(1) = M(1) + ((5*f(13))/18._/**/REALKIND * den(49)) * TI2_call(2,momenta_41,masses2_9,G2tensor(:,103),T2sum(1:15,37))
  M(2) = M(2) + (-(f(13)/6._/**/REALKIND) * den(49)) * TI2_call(2,momenta_41,masses2_9,G2tensor(:,103),T2sum(1:15,37))
  M(1) = M(1) + ((5*f(15))/18._/**/REALKIND * den(51)) * TI2_call(2,momenta_41,masses2_9,G2tensor(:,104),T2sum(1:15,37))
  M(2) = M(2) + (-(f(15)/6._/**/REALKIND) * den(51)) * TI2_call(2,momenta_41,masses2_9,G2tensor(:,104),T2sum(1:15,37))
  M(1) = M(1) + (f(13)/6._/**/REALKIND * den(49)) * TI2_call(2,momenta_43,masses2_9,G2tensor(:,101),T2sum(1:15,38))
  M(2) = M(2) + ((-5*f(13))/18._/**/REALKIND * den(49)) * TI2_call(2,momenta_43,masses2_9,G2tensor(:,101),T2sum(1:15,38))
  M(1) = M(1) + (f(15)/6._/**/REALKIND * den(51)) * TI2_call(2,momenta_43,masses2_9,G2tensor(:,102),T2sum(1:15,38))
  M(2) = M(2) + ((-5*f(15))/18._/**/REALKIND * den(51)) * TI2_call(2,momenta_43,masses2_9,G2tensor(:,102),T2sum(1:15,38))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(49)) * TI2_call(2,momenta_54,masses2_9,G2tensor(:,69),T2sum(1:15,39))
  M(2) = M(2) + ((7*f(13))/12._/**/REALKIND * den(49)) * TI2_call(2,momenta_54,masses2_9,G2tensor(:,69),T2sum(1:15,39))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(51)) * TI2_call(2,momenta_54,masses2_9,G2tensor(:,72),T2sum(1:15,39))
  M(2) = M(2) + ((7*f(15))/12._/**/REALKIND * den(51)) * TI2_call(2,momenta_54,masses2_9,G2tensor(:,72),T2sum(1:15,39))
  M(1) = M(1) + ((-7*f(13))/12._/**/REALKIND * den(49)) * TI2_call(2,momenta_60,masses2_9,G2tensor(:,13),T2sum(1:15,40))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(49)) * TI2_call(2,momenta_60,masses2_9,G2tensor(:,13),T2sum(1:15,40))
  M(1) = M(1) + ((-7*f(15))/12._/**/REALKIND * den(51)) * TI2_call(2,momenta_60,masses2_9,G2tensor(:,14),T2sum(1:15,40))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(51)) * TI2_call(2,momenta_60,masses2_9,G2tensor(:,14),T2sum(1:15,40))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(119)) * TI2_call(2,momenta_10,masses2_5,G2tensor(:,55),T2sum(1:15,23))
  M(2) = M(2) + (-(f(13)/12._/**/REALKIND) * den(119)) * TI2_call(2,momenta_10,masses2_5,G2tensor(:,55),T2sum(1:15,23))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(120)) * TI2_call(2,momenta_10,masses2_5,G2tensor(:,56),T2sum(1:15,23))
  M(2) = M(2) + (-(f(15)/12._/**/REALKIND) * den(120)) * TI2_call(2,momenta_10,masses2_5,G2tensor(:,56),T2sum(1:15,23))
  M(1) = M(1) + (-(CI*f(10))/4._/**/REALKIND * den(119)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,121),T2sum(1:15,24))
  M(2) = M(2) + ((3*CI*f(10))/4._/**/REALKIND * den(119)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,121),T2sum(1:15,24))
  M(1) = M(1) + (-(CI*f(11))/4._/**/REALKIND * den(120)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,123),T2sum(1:15,24))
  M(2) = M(2) + ((3*CI*f(11))/4._/**/REALKIND * den(120)) * TI2_call(2,momenta_32,masses2_6,G2tensor(:,123),T2sum(1:15,24))
  M(1) = M(1) + (f(13)/12._/**/REALKIND * den(121)) * TI2_call(2,momenta_12,masses2_5,G2tensor(:,57),T2sum(1:15,31))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(121)) * TI2_call(2,momenta_12,masses2_5,G2tensor(:,57),T2sum(1:15,31))
  M(1) = M(1) + (f(15)/12._/**/REALKIND * den(122)) * TI2_call(2,momenta_12,masses2_5,G2tensor(:,58),T2sum(1:15,31))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(122)) * TI2_call(2,momenta_12,masses2_5,G2tensor(:,58),T2sum(1:15,31))
  M(1) = M(1) + ((-3*CI*f(10))/4._/**/REALKIND * den(121)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,125),T2sum(1:15,32))
  M(2) = M(2) + ((CI*f(10))/4._/**/REALKIND * den(121)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,125),T2sum(1:15,32))
  M(1) = M(1) + ((-3*CI*f(11))/4._/**/REALKIND * den(122)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,127),T2sum(1:15,32))
  M(2) = M(2) + ((CI*f(11))/4._/**/REALKIND * den(122)) * TI2_call(2,momenta_35,masses2_6,G2tensor(:,127),T2sum(1:15,32))
  M(1) = M(1) + (f(13)/6._/**/REALKIND * den(40)) * TI2_call(2,momenta_44,masses2_9,G2tensor(:,105),T2sum(1:15,41))
  M(2) = M(2) + ((-5*f(13))/18._/**/REALKIND * den(40)) * TI2_call(2,momenta_44,masses2_9,G2tensor(:,105),T2sum(1:15,41))
  M(1) = M(1) + (f(15)/6._/**/REALKIND * den(42)) * TI2_call(2,momenta_44,masses2_9,G2tensor(:,106),T2sum(1:15,41))
  M(2) = M(2) + ((-5*f(15))/18._/**/REALKIND * den(42)) * TI2_call(2,momenta_44,masses2_9,G2tensor(:,106),T2sum(1:15,41))
  M(1) = M(1) + ((5*f(13))/18._/**/REALKIND * den(40)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,97),T2sum(1:15,42))
  M(2) = M(2) + (-(f(13)/6._/**/REALKIND) * den(40)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,97),T2sum(1:15,42))
  M(1) = M(1) + ((5*f(15))/18._/**/REALKIND * den(42)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,98),T2sum(1:15,42))
  M(2) = M(2) + (-(f(15)/6._/**/REALKIND) * den(42)) * TI2_call(2,momenta_40,masses2_9,G2tensor(:,98),T2sum(1:15,42))
  M(1) = M(1) + ((-7*f(13))/12._/**/REALKIND * den(40)) * TI2_call(2,momenta_64,masses2_9,G2tensor(:,29),T2sum(1:15,43))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(40)) * TI2_call(2,momenta_64,masses2_9,G2tensor(:,29),T2sum(1:15,43))
  M(1) = M(1) + ((-7*f(15))/12._/**/REALKIND * den(42)) * TI2_call(2,momenta_64,masses2_9,G2tensor(:,32),T2sum(1:15,43))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(42)) * TI2_call(2,momenta_64,masses2_9,G2tensor(:,32),T2sum(1:15,43))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(40)) * TI2_call(2,momenta_50,masses2_9,G2tensor(:,49),T2sum(1:15,44))
  M(2) = M(2) + ((7*f(13))/12._/**/REALKIND * den(40)) * TI2_call(2,momenta_50,masses2_9,G2tensor(:,49),T2sum(1:15,44))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(42)) * TI2_call(2,momenta_50,masses2_9,G2tensor(:,50),T2sum(1:15,44))
  M(2) = M(2) + ((7*f(15))/12._/**/REALKIND * den(42)) * TI2_call(2,momenta_50,masses2_9,G2tensor(:,50),T2sum(1:15,44))
  M(1) = M(1) + (f(13)/6._/**/REALKIND * den(1)) * TI2_call(3,momenta_68,masses2_11,G3tensor(:,57),T3sum(1:35,17))
  M(2) = M(2) + ((-5*f(13))/18._/**/REALKIND * den(1)) * TI2_call(3,momenta_68,masses2_11,G3tensor(:,57),T3sum(1:35,17))
  M(1) = M(1) + (f(15)/6._/**/REALKIND * den(6)) * TI2_call(3,momenta_68,masses2_11,G3tensor(:,59),T3sum(1:35,17))
  M(2) = M(2) + ((-5*f(15))/18._/**/REALKIND * den(6)) * TI2_call(3,momenta_68,masses2_11,G3tensor(:,59),T3sum(1:35,17))
  M(1) = M(1) + ((5*f(13))/18._/**/REALKIND * den(1)) * TI2_call(3,momenta_67,masses2_11,G3tensor(:,58),T3sum(1:35,18))
  M(2) = M(2) + (-(f(13)/6._/**/REALKIND) * den(1)) * TI2_call(3,momenta_67,masses2_11,G3tensor(:,58),T3sum(1:35,18))
  M(1) = M(1) + ((5*f(15))/18._/**/REALKIND * den(6)) * TI2_call(3,momenta_67,masses2_11,G3tensor(:,60),T3sum(1:35,18))
  M(2) = M(2) + (-(f(15)/6._/**/REALKIND) * den(6)) * TI2_call(3,momenta_67,masses2_11,G3tensor(:,60),T3sum(1:35,18))
  M(1) = M(1) + ((5*f(13))/18._/**/REALKIND * den(1)) * TI2_call(3,momenta_69,masses2_12,G3tensor(:,53),T3sum(1:35,19))
  M(2) = M(2) + (-(f(13)/6._/**/REALKIND) * den(1)) * TI2_call(3,momenta_69,masses2_12,G3tensor(:,53),T3sum(1:35,19))
  M(1) = M(1) + ((5*f(15))/18._/**/REALKIND * den(6)) * TI2_call(3,momenta_69,masses2_12,G3tensor(:,54),T3sum(1:35,19))
  M(2) = M(2) + (-(f(15)/6._/**/REALKIND) * den(6)) * TI2_call(3,momenta_69,masses2_12,G3tensor(:,54),T3sum(1:35,19))
  M(1) = M(1) + (f(13)/6._/**/REALKIND * den(1)) * TI2_call(3,momenta_70,masses2_12,G3tensor(:,55),T3sum(1:35,20))
  M(2) = M(2) + ((-5*f(13))/18._/**/REALKIND * den(1)) * TI2_call(3,momenta_70,masses2_12,G3tensor(:,55),T3sum(1:35,20))
  M(1) = M(1) + (f(15)/6._/**/REALKIND * den(6)) * TI2_call(3,momenta_70,masses2_12,G3tensor(:,56),T3sum(1:35,20))
  M(2) = M(2) + ((-5*f(15))/18._/**/REALKIND * den(6)) * TI2_call(3,momenta_70,masses2_12,G3tensor(:,56),T3sum(1:35,20))
  M(1) = M(1) + ((-7*f(13))/12._/**/REALKIND * den(1)) * TI2_call(3,momenta_73,masses2_11,G3tensor(:,15),T3sum(1:35,21))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(1)) * TI2_call(3,momenta_73,masses2_11,G3tensor(:,15),T3sum(1:35,21))
  M(1) = M(1) + ((-7*f(15))/12._/**/REALKIND * den(6)) * TI2_call(3,momenta_73,masses2_11,G3tensor(:,18),T3sum(1:35,21))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(6)) * TI2_call(3,momenta_73,masses2_11,G3tensor(:,18),T3sum(1:35,21))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(1)) * TI2_call(3,momenta_71,masses2_11,G3tensor(:,41),T3sum(1:35,22))
  M(2) = M(2) + ((7*f(13))/12._/**/REALKIND * den(1)) * TI2_call(3,momenta_71,masses2_11,G3tensor(:,41),T3sum(1:35,22))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(6)) * TI2_call(3,momenta_71,masses2_11,G3tensor(:,44),T3sum(1:35,22))
  M(2) = M(2) + ((7*f(15))/12._/**/REALKIND * den(6)) * TI2_call(3,momenta_71,masses2_11,G3tensor(:,44),T3sum(1:35,22))
  M(1) = M(1) + (f(13)/36._/**/REALKIND * den(1)) * TI2_call(3,momenta_72,masses2_12,G3tensor(:,47),T3sum(1:35,23))
  M(2) = M(2) + ((7*f(13))/12._/**/REALKIND * den(1)) * TI2_call(3,momenta_72,masses2_12,G3tensor(:,47),T3sum(1:35,23))
  M(1) = M(1) + (f(15)/36._/**/REALKIND * den(6)) * TI2_call(3,momenta_72,masses2_12,G3tensor(:,48),T3sum(1:35,23))
  M(2) = M(2) + ((7*f(15))/12._/**/REALKIND * den(6)) * TI2_call(3,momenta_72,masses2_12,G3tensor(:,48),T3sum(1:35,23))
  M(1) = M(1) + ((-7*f(13))/12._/**/REALKIND * den(1)) * TI2_call(3,momenta_74,masses2_12,G3tensor(:,21),T3sum(1:35,24))
  M(2) = M(2) + (-(f(13)/36._/**/REALKIND) * den(1)) * TI2_call(3,momenta_74,masses2_12,G3tensor(:,21),T3sum(1:35,24))
  M(1) = M(1) + ((-7*f(15))/12._/**/REALKIND * den(6)) * TI2_call(3,momenta_74,masses2_12,G3tensor(:,22),T3sum(1:35,24))
  M(2) = M(2) + (-(f(15)/36._/**/REALKIND) * den(6)) * TI2_call(3,momenta_74,masses2_12,G3tensor(:,22),T3sum(1:35,24))
  M(1) = M(1) + ((-2*f(13))/3._/**/REALKIND * den(72)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,5),T1sum(1:5,1))
  M(2) = M(2) + ((2*f(13))/9._/**/REALKIND * den(72)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,5),T1sum(1:5,1))
  M(1) = M(1) + ((-2*f(15))/3._/**/REALKIND * den(73)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,6),T1sum(1:5,1))
  M(2) = M(2) + ((2*f(15))/9._/**/REALKIND * den(73)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,6),T1sum(1:5,1))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(133)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,129),T2sum(1:15,45))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(133)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,129),T2sum(1:15,45))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(133)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,129),T2sum(1:15,45))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(133)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,129),T2sum(1:15,45))
  M(1) = M(1) + (f(16)/4._/**/REALKIND * den(133)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,130),T2sum(1:15,46))
  M(2) = M(2) + (-(f(16)/12._/**/REALKIND) * den(133)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,130),T2sum(1:15,46))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(134)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,131),T2sum(1:15,45))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(134)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,131),T2sum(1:15,45))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(134)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,131),T2sum(1:15,45))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(134)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,131),T2sum(1:15,45))
  M(1) = M(1) + (f(18)/4._/**/REALKIND * den(134)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,132),T2sum(1:15,46))
  M(2) = M(2) + (-(f(18)/12._/**/REALKIND) * den(134)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,132),T2sum(1:15,46))
  M(1) = M(1) + ((3*f(13))/2._/**/REALKIND * den(133)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,133),T2sum(1:15,45))
  M(2) = M(2) + (-(f(13)/2._/**/REALKIND) * den(133)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,133),T2sum(1:15,45))
  M(1) = M(1) + ((3*f(15))/2._/**/REALKIND * den(134)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,134),T2sum(1:15,45))
  M(2) = M(2) + (-(f(15)/2._/**/REALKIND) * den(134)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,134),T2sum(1:15,45))
  M(1) = M(1) + ((-3*f(12))/2._/**/REALKIND * den(133)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,110),T2sum(1:15,45))
  M(2) = M(2) + (f(12)/2._/**/REALKIND * den(133)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,110),T2sum(1:15,45))
  M(1) = M(1) + ((-3*f(14))/2._/**/REALKIND * den(134)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,112),T2sum(1:15,45))
  M(2) = M(2) + (f(14)/2._/**/REALKIND * den(134)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,112),T2sum(1:15,45))
  M(1) = M(1) + ((-2*f(13))/3._/**/REALKIND * den(74)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,1),T1sum(1:5,2))
  M(2) = M(2) + ((2*f(13))/9._/**/REALKIND * den(74)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,1),T1sum(1:5,2))
  M(1) = M(1) + ((-2*f(15))/3._/**/REALKIND * den(75)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,3),T1sum(1:5,2))
  M(2) = M(2) + ((2*f(15))/9._/**/REALKIND * den(75)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,3),T1sum(1:5,2))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(135)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,135),T2sum(1:15,45))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(135)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,135),T2sum(1:15,45))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(135)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,135),T2sum(1:15,45))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(135)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,135),T2sum(1:15,45))
  M(1) = M(1) + (f(16)/4._/**/REALKIND * den(135)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,136),T2sum(1:15,46))
  M(2) = M(2) + (-(f(16)/12._/**/REALKIND) * den(135)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,136),T2sum(1:15,46))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(136)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,137),T2sum(1:15,45))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(136)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,137),T2sum(1:15,45))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(136)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,137),T2sum(1:15,45))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(136)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,137),T2sum(1:15,45))
  M(1) = M(1) + (f(18)/4._/**/REALKIND * den(136)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,138),T2sum(1:15,46))
  M(2) = M(2) + (-(f(18)/12._/**/REALKIND) * den(136)) * TI2_call(2,momenta_5,masses2_1,G2tensor(:,138),T2sum(1:15,46))
  M(1) = M(1) + ((3*f(13))/2._/**/REALKIND * den(135)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,139),T2sum(1:15,45))
  M(2) = M(2) + (-(f(13)/2._/**/REALKIND) * den(135)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,139),T2sum(1:15,45))
  M(1) = M(1) + ((3*f(15))/2._/**/REALKIND * den(136)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,140),T2sum(1:15,45))
  M(2) = M(2) + (-(f(15)/2._/**/REALKIND) * den(136)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,140),T2sum(1:15,45))
  M(1) = M(1) + ((-3*f(12))/2._/**/REALKIND * den(135)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,126),T2sum(1:15,45))
  M(2) = M(2) + (f(12)/2._/**/REALKIND * den(135)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,126),T2sum(1:15,45))
  M(1) = M(1) + ((-3*f(14))/2._/**/REALKIND * den(136)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,128),T2sum(1:15,45))
  M(2) = M(2) + (f(14)/2._/**/REALKIND * den(136)) * TI2_call(2,momenta_5,masses2_3,G2tensor(:,128),T2sum(1:15,45))
  M(1) = M(1) + (f(17)/12._/**/REALKIND * den(137)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,141),T2sum(1:15,47))
  M(2) = M(2) + (-(f(17)/4._/**/REALKIND) * den(137)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,141),T2sum(1:15,47))
  M(1) = M(1) + (f(17)/12._/**/REALKIND * den(137)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,141),T2sum(1:15,47))
  M(2) = M(2) + (-(f(17)/4._/**/REALKIND) * den(137)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,141),T2sum(1:15,47))
  M(1) = M(1) + (f(16)/12._/**/REALKIND * den(137)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,142),T2sum(1:15,48))
  M(2) = M(2) + (-(f(16)/4._/**/REALKIND) * den(137)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,142),T2sum(1:15,48))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(138)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,143),T2sum(1:15,47))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(138)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,143),T2sum(1:15,47))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(138)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,143),T2sum(1:15,47))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(138)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,143),T2sum(1:15,47))
  M(1) = M(1) + (f(18)/12._/**/REALKIND * den(138)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,144),T2sum(1:15,48))
  M(2) = M(2) + (-(f(18)/4._/**/REALKIND) * den(138)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,144),T2sum(1:15,48))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(137)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,145),T2sum(1:15,47))
  M(2) = M(2) + ((-3*f(13))/2._/**/REALKIND * den(137)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,145),T2sum(1:15,47))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(138)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,146),T2sum(1:15,47))
  M(2) = M(2) + ((-3*f(15))/2._/**/REALKIND * den(138)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,146),T2sum(1:15,47))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(137)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,92),T2sum(1:15,47))
  M(2) = M(2) + ((3*f(12))/2._/**/REALKIND * den(137)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,92),T2sum(1:15,47))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(138)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,94),T2sum(1:15,47))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(138)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,94),T2sum(1:15,47))
  M(1) = M(1) + ((-2*f(13))/9._/**/REALKIND * den(79)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,7),T1sum(1:5,3))
  M(2) = M(2) + ((2*f(13))/3._/**/REALKIND * den(79)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,7),T1sum(1:5,3))
  M(1) = M(1) + ((-2*f(15))/9._/**/REALKIND * den(80)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,8),T1sum(1:5,3))
  M(2) = M(2) + ((2*f(15))/3._/**/REALKIND * den(80)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,8),T1sum(1:5,3))
  M(1) = M(1) + ((-2*f(13))/9._/**/REALKIND * den(81)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,2),T1sum(1:5,2))
  M(2) = M(2) + ((2*f(13))/3._/**/REALKIND * den(81)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,2),T1sum(1:5,2))
  M(1) = M(1) + ((-2*f(15))/9._/**/REALKIND * den(82)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,4),T1sum(1:5,2))
  M(2) = M(2) + ((2*f(15))/3._/**/REALKIND * den(82)) * TI2_call(1,momenta_1,masses2_2,G1tensor(:,4),T1sum(1:5,2))
  M(1) = M(1) + (f(17)/12._/**/REALKIND * den(139)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,147),T2sum(1:15,47))
  M(2) = M(2) + (-(f(17)/4._/**/REALKIND) * den(139)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,147),T2sum(1:15,47))
  M(1) = M(1) + (f(17)/12._/**/REALKIND * den(139)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,147),T2sum(1:15,47))
  M(2) = M(2) + (-(f(17)/4._/**/REALKIND) * den(139)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,147),T2sum(1:15,47))
  M(1) = M(1) + (f(16)/12._/**/REALKIND * den(139)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,148),T2sum(1:15,48))
  M(2) = M(2) + (-(f(16)/4._/**/REALKIND) * den(139)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,148),T2sum(1:15,48))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(140)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,149),T2sum(1:15,47))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(140)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,149),T2sum(1:15,47))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(140)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,149),T2sum(1:15,47))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(140)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,149),T2sum(1:15,47))
  M(1) = M(1) + (f(18)/12._/**/REALKIND * den(140)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,150),T2sum(1:15,48))
  M(2) = M(2) + (-(f(18)/4._/**/REALKIND) * den(140)) * TI2_call(2,momenta_3,masses2_1,G2tensor(:,150),T2sum(1:15,48))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(139)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,151),T2sum(1:15,47))
  M(2) = M(2) + ((-3*f(13))/2._/**/REALKIND * den(139)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,151),T2sum(1:15,47))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(140)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,152),T2sum(1:15,47))
  M(2) = M(2) + ((-3*f(15))/2._/**/REALKIND * den(140)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,152),T2sum(1:15,47))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(139)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,122),T2sum(1:15,47))
  M(2) = M(2) + ((3*f(12))/2._/**/REALKIND * den(139)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,122),T2sum(1:15,47))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(140)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,124),T2sum(1:15,47))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(140)) * TI2_call(2,momenta_3,masses2_3,G2tensor(:,124),T2sum(1:15,47))
  M(1) = M(1) + ((-2*f(13))/9._/**/REALKIND * den(90)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,11),T1sum(1:5,1))
  M(2) = M(2) + ((2*f(13))/3._/**/REALKIND * den(90)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,11),T1sum(1:5,1))
  M(1) = M(1) + ((-2*f(15))/9._/**/REALKIND * den(91)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,12),T1sum(1:5,1))
  M(2) = M(2) + ((2*f(15))/3._/**/REALKIND * den(91)) * TI2_call(1,momenta_7,masses2_2,G1tensor(:,12),T1sum(1:5,1))
  M(1) = M(1) + (f(17)/12._/**/REALKIND * den(141)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,153),T2sum(1:15,49))
  M(2) = M(2) + (-(f(17)/4._/**/REALKIND) * den(141)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,153),T2sum(1:15,49))
  M(1) = M(1) + (f(17)/12._/**/REALKIND * den(141)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,153),T2sum(1:15,49))
  M(2) = M(2) + (-(f(17)/4._/**/REALKIND) * den(141)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,153),T2sum(1:15,49))
  M(1) = M(1) + (f(16)/12._/**/REALKIND * den(141)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,157),T2sum(1:15,50))
  M(2) = M(2) + (-(f(16)/4._/**/REALKIND) * den(141)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,157),T2sum(1:15,50))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(142)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,154),T2sum(1:15,49))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(142)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,154),T2sum(1:15,49))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(142)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,154),T2sum(1:15,49))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(142)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,154),T2sum(1:15,49))
  M(1) = M(1) + (f(18)/12._/**/REALKIND * den(142)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,158),T2sum(1:15,50))
  M(2) = M(2) + (-(f(18)/4._/**/REALKIND) * den(142)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,158),T2sum(1:15,50))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(141)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,161),T2sum(1:15,49))
  M(2) = M(2) + ((-3*f(13))/2._/**/REALKIND * den(141)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,161),T2sum(1:15,49))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(142)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,162),T2sum(1:15,49))
  M(2) = M(2) + ((-3*f(15))/2._/**/REALKIND * den(142)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,162),T2sum(1:15,49))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(141)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,63),T2sum(1:15,49))
  M(2) = M(2) + ((3*f(12))/2._/**/REALKIND * den(141)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,63),T2sum(1:15,49))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(142)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,64),T2sum(1:15,49))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(142)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,64),T2sum(1:15,49))
  M(1) = M(1) + ((-2*f(13))/9._/**/REALKIND * den(92)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,9),T1sum(1:5,4))
  M(2) = M(2) + ((2*f(13))/3._/**/REALKIND * den(92)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,9),T1sum(1:5,4))
  M(1) = M(1) + ((-2*f(15))/9._/**/REALKIND * den(93)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,10),T1sum(1:5,4))
  M(2) = M(2) + ((2*f(15))/3._/**/REALKIND * den(93)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,10),T1sum(1:5,4))
  M(1) = M(1) + (f(17)/12._/**/REALKIND * den(143)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,155),T2sum(1:15,49))
  M(2) = M(2) + (-(f(17)/4._/**/REALKIND) * den(143)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,155),T2sum(1:15,49))
  M(1) = M(1) + (f(17)/12._/**/REALKIND * den(143)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,155),T2sum(1:15,49))
  M(2) = M(2) + (-(f(17)/4._/**/REALKIND) * den(143)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,155),T2sum(1:15,49))
  M(1) = M(1) + (f(16)/12._/**/REALKIND * den(143)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,159),T2sum(1:15,50))
  M(2) = M(2) + (-(f(16)/4._/**/REALKIND) * den(143)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,159),T2sum(1:15,50))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(144)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,156),T2sum(1:15,49))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(144)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,156),T2sum(1:15,49))
  M(1) = M(1) + (f(20)/12._/**/REALKIND * den(144)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,156),T2sum(1:15,49))
  M(2) = M(2) + (-(f(20)/4._/**/REALKIND) * den(144)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,156),T2sum(1:15,49))
  M(1) = M(1) + (f(18)/12._/**/REALKIND * den(144)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,160),T2sum(1:15,50))
  M(2) = M(2) + (-(f(18)/4._/**/REALKIND) * den(144)) * TI2_call(2,momenta_2,masses2_1,G2tensor(:,160),T2sum(1:15,50))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(143)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,163),T2sum(1:15,49))
  M(2) = M(2) + ((-3*f(13))/2._/**/REALKIND * den(143)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,163),T2sum(1:15,49))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(144)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,164),T2sum(1:15,49))
  M(2) = M(2) + ((-3*f(15))/2._/**/REALKIND * den(144)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,164),T2sum(1:15,49))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(143)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,65),T2sum(1:15,49))
  M(2) = M(2) + ((3*f(12))/2._/**/REALKIND * den(143)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,65),T2sum(1:15,49))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(144)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,66),T2sum(1:15,49))
  M(2) = M(2) + ((3*f(14))/2._/**/REALKIND * den(144)) * TI2_call(2,momenta_2,masses2_3,G2tensor(:,66),T2sum(1:15,49))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(145)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,165),T2sum(1:15,51))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(145)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,165),T2sum(1:15,51))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(145)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,165),T2sum(1:15,51))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(145)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,165),T2sum(1:15,51))
  M(1) = M(1) + (f(16)/4._/**/REALKIND * den(145)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,169),T2sum(1:15,52))
  M(2) = M(2) + (-(f(16)/12._/**/REALKIND) * den(145)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,169),T2sum(1:15,52))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(146)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,166),T2sum(1:15,51))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(146)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,166),T2sum(1:15,51))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(146)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,166),T2sum(1:15,51))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(146)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,166),T2sum(1:15,51))
  M(1) = M(1) + (f(18)/4._/**/REALKIND * den(146)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,170),T2sum(1:15,52))
  M(2) = M(2) + (-(f(18)/12._/**/REALKIND) * den(146)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,170),T2sum(1:15,52))
  M(1) = M(1) + ((3*f(13))/2._/**/REALKIND * den(145)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,173),T2sum(1:15,51))
  M(2) = M(2) + (-(f(13)/2._/**/REALKIND) * den(145)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,173),T2sum(1:15,51))
  M(1) = M(1) + ((3*f(15))/2._/**/REALKIND * den(146)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,174),T2sum(1:15,51))
  M(2) = M(2) + (-(f(15)/2._/**/REALKIND) * den(146)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,174),T2sum(1:15,51))
  M(1) = M(1) + ((-3*f(12))/2._/**/REALKIND * den(145)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,81),T2sum(1:15,51))
  M(2) = M(2) + (f(12)/2._/**/REALKIND * den(145)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,81),T2sum(1:15,51))
  M(1) = M(1) + ((-3*f(14))/2._/**/REALKIND * den(146)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,82),T2sum(1:15,51))
  M(2) = M(2) + (f(14)/2._/**/REALKIND * den(146)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,82),T2sum(1:15,51))
  M(1) = M(1) + ((-2*f(13))/3._/**/REALKIND * den(97)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,15),T1sum(1:5,3))
  M(2) = M(2) + ((2*f(13))/9._/**/REALKIND * den(97)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,15),T1sum(1:5,3))
  M(1) = M(1) + ((-2*f(15))/3._/**/REALKIND * den(98)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,16),T1sum(1:5,3))
  M(2) = M(2) + ((2*f(15))/9._/**/REALKIND * den(98)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,16),T1sum(1:5,3))
  M(1) = M(1) + ((-2*f(13))/3._/**/REALKIND * den(99)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,13),T1sum(1:5,4))
  M(2) = M(2) + ((2*f(13))/9._/**/REALKIND * den(99)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,13),T1sum(1:5,4))
  M(1) = M(1) + ((-2*f(15))/3._/**/REALKIND * den(100)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,14),T1sum(1:5,4))
  M(2) = M(2) + ((2*f(15))/9._/**/REALKIND * den(100)) * TI2_call(1,momenta_6,masses2_2,G1tensor(:,14),T1sum(1:5,4))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(147)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,167),T2sum(1:15,51))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(147)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,167),T2sum(1:15,51))
  M(1) = M(1) + (f(17)/4._/**/REALKIND * den(147)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,167),T2sum(1:15,51))
  M(2) = M(2) + (-(f(17)/12._/**/REALKIND) * den(147)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,167),T2sum(1:15,51))
  M(1) = M(1) + (f(16)/4._/**/REALKIND * den(147)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,171),T2sum(1:15,52))
  M(2) = M(2) + (-(f(16)/12._/**/REALKIND) * den(147)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,171),T2sum(1:15,52))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(148)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,168),T2sum(1:15,51))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(148)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,168),T2sum(1:15,51))
  M(1) = M(1) + (f(20)/4._/**/REALKIND * den(148)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,168),T2sum(1:15,51))
  M(2) = M(2) + (-(f(20)/12._/**/REALKIND) * den(148)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,168),T2sum(1:15,51))
  M(1) = M(1) + (f(18)/4._/**/REALKIND * den(148)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,172),T2sum(1:15,52))
  M(2) = M(2) + (-(f(18)/12._/**/REALKIND) * den(148)) * TI2_call(2,momenta_4,masses2_1,G2tensor(:,172),T2sum(1:15,52))
  M(1) = M(1) + ((3*f(13))/2._/**/REALKIND * den(147)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,175),T2sum(1:15,51))
  M(2) = M(2) + (-(f(13)/2._/**/REALKIND) * den(147)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,175),T2sum(1:15,51))
  M(1) = M(1) + ((3*f(15))/2._/**/REALKIND * den(148)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,176),T2sum(1:15,51))
  M(2) = M(2) + (-(f(15)/2._/**/REALKIND) * den(148)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,176),T2sum(1:15,51))
  M(1) = M(1) + ((-3*f(12))/2._/**/REALKIND * den(147)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,83),T2sum(1:15,51))
  M(2) = M(2) + (f(12)/2._/**/REALKIND * den(147)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,83),T2sum(1:15,51))
  M(1) = M(1) + ((-3*f(14))/2._/**/REALKIND * den(148)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,84),T2sum(1:15,51))
  M(2) = M(2) + (f(14)/2._/**/REALKIND * den(148)) * TI2_call(2,momenta_4,masses2_3,G2tensor(:,84),T2sum(1:15,51))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pplljj2_eexbbbxbx_2_/**/REALKIND
