
module ol_vamp_1_ppllj_ew_eexbbxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj_ew_eexbbxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj_ew_eexbbxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllj_ew_eexbbxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllj_ew_eexbbxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllj_ew_eexbbxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllj_ew_eexbbxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,0,0,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMB,0,0,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,nMZ,0,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMB,nMZ,0,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,2,1,8],[nMB,0,0,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,2,1,8],[nMB,nMZ,0,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,2,1,8],[nMB,0,0,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,2,1,8],[nMB,nMZ,0,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[nMT,nMW,0,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(9))
  call Hloop_AQ_V(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G1H16(2),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex3(:),G1H8(3),ngZd,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex3(:),G1H8(4),ngZd,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_V(ntryL,G1H16(5),ex3(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_Z(ntryL,G1H16(6),ex3(:),G1H8(6),ngZd,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_V(ntryL,G1H16(7),ex3(:),G1H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H16(8),ex3(:),G1H8(8),ngZd,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_W(ntryL,G1H16(9),ex3(:),G1H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(1),n2h4(1))
  call Hloop_VQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(2),n2h4(2))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngZl,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(3),n2h4(3))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngZl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(4),n2h4(4))
  call Hloop_VA_Q(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(5),n2h4(5))
  call Hloop_ZA_Q(ntryL,G1H8(6),ex2(:),G1H4(1),ngZl,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(6),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(7),n2h4(7))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),ngZl,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(8),n2h4(8))
  call Hloop_WA_Q(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(9),n2h4(9))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_Z(ntryL,G2H4(2),ex2(:),G2H2(2),ngZl,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(3),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_Z(ntryL,G2H4(4),ex2(:),G2H2(4),ngZl,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(5),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(6),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_Z(ntryL,G2H4(7),ex1(:),G2H2(7),ngZl,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_Z(ntryL,G2H4(8),ex1(:),G2H2(8),ngZl,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_W(ntryL,G2H4(9),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,3),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(1),mass5set(:,4),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(2),mass5set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(2),mass5set(:,3),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(2),mass5set(:,2),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(2),mass5set(:,4),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(2),mass5set(:,5),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(2),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(3))
  call Hloop_ZA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),ngZd,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(4),n2h1(4))
  call Hloop_ZA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),ngZd,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(5),n2h1(5))
  call Hloop_ZA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),ngZd,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(8),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(9))
  call Hloop_ZA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(10),n2h1(10))
  call Hloop_ZA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),ngZd,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(11),n2h1(11))
  call Hloop_ZA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),ngZd,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(12),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(13),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(14),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(15),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(16),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(17),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(18),n2h1(18))
  call Hloop_ZA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),ngZd,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(19))
  call Hloop_ZA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),ngZd,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(20),n2h1(20))
  call Hloop_ZA_Q(ntryL,G1H2(42),ex4(:),G1H1(1),ngZd,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(21),n2h1(21))
  call Hloop_ZA_Q(ntryL,G1H2(43),ex4(:),G1H1(1),ngZd,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(22),n2h1(22))
  call Hloop_ZA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),ngZd,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(23),n2h1(23))
  call Hloop_ZA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),ngZd,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(24),n2h1(24))
  call Hloop_WA_Q(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(25),n2h1(25))
  call Hloop_WA_Q(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(26),n2h1(26))
  call Hloop_WA_Q(ntryL,G1H2(54),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(27),n2h1(27))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(1),mass5set(:,4),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(2),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(2),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(2),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(2),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(2),mass5set(:,5),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,3,8,4],[nMB,nMB,nMH,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(10))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(11))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(3),n2h16(12))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,3,8,4],[nMB,nMB,nMH,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(13))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(14))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(6),n2h16(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(16))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(17))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(18))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(19))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(11),n2h16(20))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(12),n2h16(21))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,3,4,8],[nMB,nMB,nMH,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(13),n2h16(22))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(14),n2h16(23))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(15),n2h16(24))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,3,4,8],[nMB,nMB,nMH,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(16),n2h16(25))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(26))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(18),n2h16(27))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(28))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(29))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(21),n2h16(30))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(31))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(23),n2h16(32))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(33))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(25),n2h16(34))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,4,3,8],[nMB,nMH,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(35))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,4,3,8],[nMB,nMZ,nMH,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(27),n2h16(36))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(28),n2h16(37))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(29),n2h16(38))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,4,3,8],[nMB,nMH,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(30),n2h16(39))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(31),n2h16(40))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(32),n2h16(41))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,4,3,8],[nMB,nMZ,nMH,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(33),n2h16(42))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(34),n2h16(43))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(35),n2h16(44))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(36),n2h16(45))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[20,2,1,8],[0,0,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,46))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[20,2,1,8],[nMZ,0,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(2),ngZd,m3h4x8(:,2),heltab2x32(:,:,47))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[20,2,1,8],[0,0,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,3),heltab2x32(:,:,48))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[20,2,1,8],[nMZ,0,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(4),ngZd,m3h4x8(:,4),heltab2x32(:,:,49))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[20,2,1,8],[nMW,0,nMW,nMT],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,5),heltab2x32(:,:,50))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[20,1,2,8],[0,0,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,6),heltab2x32(:,:,51))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[20,1,2,8],[0,0,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(7),m3h4x8(:,7),heltab2x32(:,:,52))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[20,1,2,8],[nMZ,0,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(8),ngZd,m3h4x8(:,8),heltab2x32(:,:,53))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[20,1,2,8],[nMZ,0,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(9),ngZd,m3h4x8(:,9),heltab2x32(:,:,54))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[24,2,1,4],[0,0,0,nMB],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(10),m3h4x8(:,10),heltab2x32(:,:,55))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[24,2,1,4],[nMZ,0,0,nMB],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(11),ngZd,m3h4x8(:,11),heltab2x32(:,:,56))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[24,2,1,4],[0,0,nMZ,nMB],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(12),m3h4x8(:,12),heltab2x32(:,:,57))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[24,2,1,4],[nMZ,0,nMZ,nMB],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(13),ngZd,m3h4x8(:,13),heltab2x32(:,:,58))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[24,1,2,4],[0,0,0,nMB],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(14),m3h4x8(:,14),heltab2x32(:,:,59))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[24,1,2,4],[0,0,nMZ,nMB],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,15),heltab2x32(:,:,60))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[24,1,2,4],[nMZ,0,0,nMB],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(16),ngZd,m3h4x8(:,16),heltab2x32(:,:,61))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[24,1,2,4],[nMZ,0,nMZ,nMB],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(17),ngZd,m3h4x8(:,17),heltab2x32(:,:,62))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[24,1,2,4],[nMW,0,nMW,nMT],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(18),m3h4x8(:,18),heltab2x32(:,:,63))
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(1),n2h4(10))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(2),n2h4(11))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(3),n2h4(12))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,4),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(4),n2h4(13))
  call Hloop_QZ_A(ntryL,G1H16(5),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,5),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(5),n2h4(14))
  call Hloop_QZ_A(ntryL,G1H16(6),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,6),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(6),n2h4(15))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,1),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(7),n2h4(16))
  call Hloop_QV_A(ntryL,G1H16(8),wf4(:,1),G1H4(1),m3h4x4(:,8),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(8),n2h4(17))
  call Hloop_QV_A(ntryL,G1H16(9),wf4(:,1),G1H4(1),m3h4x4(:,9),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(9),n2h4(18))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,10),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(10),n2h4(19))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,11),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(11),n2h4(20))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,12),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(12),n2h4(21))
  call Hloop_AV_Q(ntryL,G1H16(13),wf4(:,1),G1H4(1),m3h4x4(:,13),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(13),n2h4(22))
  call Hloop_AV_Q(ntryL,G1H16(14),wf4(:,1),G1H4(1),m3h4x4(:,14),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(14),n2h4(23))
  call Hloop_AV_Q(ntryL,G1H16(15),wf4(:,1),G1H4(1),m3h4x4(:,15),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(15),n2h4(24))
  call Hloop_AZ_Q(ntryL,G1H16(16),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,16),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(16),n2h4(25))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,17),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(17),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,18),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(18),n2h4(27))
  call Hloop_AV_Q(ntryL,G1H16(19),wf4(:,1),G1H4(1),m3h4x4(:,19),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(19),n2h4(28))
  call Hloop_AV_Q(ntryL,G1H16(20),wf4(:,1),G1H4(1),m3h4x4(:,20),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(20),n2h4(29))
  call Hloop_AV_Q(ntryL,G1H16(21),wf4(:,1),G1H4(1),m3h4x4(:,21),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(21),n2h4(30))
  call Hloop_AZ_Q(ntryL,G1H16(22),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,22),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(22),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,23),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(23),n2h4(32))
  call Hloop_AZ_Q(ntryL,G1H16(24),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,24),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(24),n2h4(33))
  call Hloop_AQ_S(ntryL,G1H16(25),ex3(:),G1H8(1),ngPtb,m3h2x8(:,10),heltab2x16(:,:,34))
  call Hloop_AQ_S(ntryL,G1H16(26),ex3(:),G1H8(2),ngH,m3h2x8(:,11),heltab2x16(:,:,35))
  call Hloop_AQ_S(ntryL,G1H16(27),ex3(:),G1H8(3),ngX,m3h2x8(:,12),heltab2x16(:,:,36))
  call Hloop_AQ_S(ntryL,G1H16(28),ex3(:),G1H8(4),ngPtb,m3h2x8(:,13),heltab2x16(:,:,37))
  call Hloop_AQ_S(ntryL,G1H16(29),ex3(:),G1H8(5),ngPtb,m3h2x8(:,14),heltab2x16(:,:,38))
  call Hloop_AQ_S(ntryL,G1H16(30),ex3(:),G1H8(6),ngH,m3h2x8(:,15),heltab2x16(:,:,39))
  call Hloop_AQ_S(ntryL,G1H16(31),ex3(:),G1H8(7),ngPtb,m3h2x8(:,16),heltab2x16(:,:,40))
  call Hloop_AQ_W(ntryL,G1H16(32),ex3(:),G1H8(8),m3h2x8(:,17),heltab2x16(:,:,41))
  call Hloop_AQ_Z(ntryL,G1H16(33),ex3(:),G1H8(9),ngZd,m3h2x8(:,18),heltab2x16(:,:,42))
  call Hloop_AQ_W(ntryL,G1H16(34),ex3(:),G1H8(10),m3h2x8(:,19),heltab2x16(:,:,43))
  call Hloop_AQ_W(ntryL,G1H16(35),ex3(:),G1H8(11),m3h2x8(:,20),heltab2x16(:,:,44))
  call Hloop_AQ_W(ntryL,G1H16(36),ex3(:),G1H8(12),m3h2x8(:,21),heltab2x16(:,:,45))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(1),n2h4(34))
  call Hloop_ZA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),ngZl,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(2),n2h4(35))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(3),n2h4(36))
  call Hloop_ZA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),ngZl,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(4),n2h4(37))
  call Hloop_WA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(5),n2h4(38))
  call Hloop_VQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(6),n2h4(39))
  call Hloop_VQ_A(ntryL,G0H8(7),ex1(:),G0H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(7),n2h4(40))
  call Hloop_ZQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),ngZl,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(8),n2h4(41))
  call Hloop_ZQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),ngZl,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(9),n2h4(42))
  call Hloop_VA_Q(ntryL,G0H8(10),ex2(:),G0H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(10),n2h4(43))
  call Hloop_ZA_Q(ntryL,G0H8(11),ex2(:),G0H4(1),ngZl,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(11),n2h4(44))
  call Hloop_VA_Q(ntryL,G0H8(12),ex2(:),G0H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(12),n2h4(45))
  call Hloop_ZA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),ngZl,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(13),n2h4(46))
  call Hloop_VQ_A(ntryL,G0H8(14),ex1(:),G0H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(14),n2h4(47))
  call Hloop_VQ_A(ntryL,G0H8(15),ex1(:),G0H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(15),n2h4(48))
  call Hloop_ZQ_A(ntryL,G0H8(16),ex1(:),G0H4(1),ngZl,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(16),n2h4(49))
  call Hloop_ZQ_A(ntryL,G0H8(17),ex1(:),G0H4(1),ngZl,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(17),n2h4(50))
  call Hloop_WQ_A(ntryL,G0H8(18),ex1(:),G0H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(18),n2h4(51))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(21)])
  call Hloop_QA_S(ntryL,G2H4(4),ex4(:),G2H2(1),ngH,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_S(ntryL,G2H4(5),ex4(:),G2H2(2),ngX,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_S(ntryL,G2H4(6),ex4(:),G2H2(3),ngPbt,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_V(ntryL,G2H4(10),ex4(:),G2H2(4),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_Z(ntryL,G2H4(11),ex4(:),G2H2(5),ngZd,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_W(ntryL,G2H4(12),ex4(:),G2H2(6),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_S(ntryL,G2H4(16),ex3(:),G2H2(7),ngH,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_S(ntryL,G2H4(17),ex3(:),G2H2(8),ngX,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_S(ntryL,G2H4(18),ex3(:),G2H2(9),ngPtb,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_V(ntryL,G2H4(22),ex3(:),G2H2(10),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_Z(ntryL,G2H4(23),ex3(:),G2H2(11),ngZd,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_W(ntryL,G2H4(24),ex3(:),G2H2(12),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_TV_S(ntryL,G1H8(1),20,wf4(:,1),3,G2H2(13),m3h4x2(:,1),heltab2x8(:,:,28))
  call Hloop_TV_S(ntryL,G1H8(2),20,wf4(:,4),3,G2H2(14),m3h4x2(:,2),heltab2x8(:,:,29))
  call Hloop_SV_T(ntryL,G1H8(3),20,wf4(:,4),3,G2H2(15),m3h4x2(:,3),heltab2x8(:,:,30))
  call Hloop_TV_S(ntryL,G1H8(4),20,wf4(:,4),3,G2H2(16),m3h4x2(:,4),heltab2x8(:,:,31))
  call Hloop_SV_V(ntryL,G1H8(5),wf4(:,1),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,32))
  call Hloop_SV_V(ntryL,G1H8(6),wf4(:,4),G1H2(2),m3h4x2(:,6),heltab2x8(:,:,33))
  call Hloop_SV_V(ntryL,G1H8(7),wf4(:,4),G1H2(6),m3h4x2(:,7),heltab2x8(:,:,34))
  call Hloop_VV_S(ntryL,G1H8(8),wf4(:,1),G1H2(7),m3h4x2(:,8),heltab2x8(:,:,35))
  call Hloop_VV_S(ntryL,G1H8(9),wf4(:,4),G1H2(8),m3h4x2(:,9),heltab2x8(:,:,36))
  call Hloop_VV_S(ntryL,G1H8(10),wf4(:,4),G1H2(12),m3h4x2(:,10),heltab2x8(:,:,37))
  call Hloop_UV_W(ntryL,G1H8(11),20,wf4(:,1),3,G2H2(17),m3h4x2(:,11),heltab2x8(:,:,38))
  call Hloop_UV_W(ntryL,G1H8(12),20,wf4(:,4),3,G2H2(18),m3h4x2(:,12),heltab2x8(:,:,39))
  call Hloop_AQ_V(ntryL,G1H4(1),ex1(:),G1H2(13),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_V(ntryL,G1H4(2),ex1(:),G1H2(14),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_Z(ntryL,G1H4(3),ex1(:),G1H2(18),ngZl,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_Z(ntryL,G1H4(4),ex1(:),G1H2(19),ngZl,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_W(ntryL,G1H4(5),ex1(:),G1H2(20),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_V(ntryL,G1H4(6),ex2(:),G1H2(24),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_Z(ntryL,G1H4(7),ex2(:),G1H2(25),ngZl,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G1H4(8),ex2(:),G1H2(26),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_Z(ntryL,G1H4(9),ex2(:),G1H2(30),ngZl,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_AQ_V(ntryL,G1H4(10),ex1(:),G1H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_AQ_V(ntryL,G1H4(11),ex1(:),G1H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_Z(ntryL,G1H4(12),ex1(:),G1H2(36),ngZl,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_Z(ntryL,G1H4(13),ex1(:),G1H2(37),ngZl,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QA_V(ntryL,G1H4(14),ex2(:),G1H2(38),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_Z(ntryL,G1H4(15),ex2(:),G1H2(42),ngZl,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QA_V(ntryL,G1H4(16),ex2(:),G1H2(43),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_Z(ntryL,G1H4(17),ex2(:),G1H2(44),ngZl,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QA_W(ntryL,G1H4(18),ex2(:),G1H2(48),m3h2x2(:,39),heltab2x4(:,:,39))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(25),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(47),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(34),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(17),G1H2(6),G1H2(1),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(13),G1H2(12),G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(8)])
  call Hloop_VA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(4),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(30))
  call Hloop_ZA_Q(ntryL,G1H2(25),ex4(:),G1H1(1),ngZd,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(10),n2h1(31))
  call Hloop_ZA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),ngZd,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(13),n2h1(32))
  call Hloop_ZA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),ngZd,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(16),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(34))
  call Hloop_VA_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(22),n2h1(35))
  call Hloop_ZA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),ngZd,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(25),n2h1(36))
  call Hloop_ZA_Q(ntryL,G1H2(47),ex4(:),G1H1(1),ngZd,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(28),n2h1(37))
  call Hloop_VA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(29),n2h1(38))
  call Hloop_VA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(30),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(31),n2h1(40))
  call Hloop_ZA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),ngZd,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(32),n2h1(41))
  call Hloop_ZA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),ngZd,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(33),n2h1(42))
  call Hloop_ZA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),ngZd,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(34),n2h1(43))
  call Hloop_WA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(35),n2h1(44))
  call Hloop_WA_Q(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(36),n2h1(45))
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(3),mass4set(:,1),  & 
G1H2(49),G1H2(50),G1H2(54),G1H2(3),G1H2(4),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(10),mass4set(:,2),  & 
G1H2(5),G1H2(9),G1H2(10),G1H2(11),G1H2(15),2)
  call HG1shiftOLR(G1H2(9),4,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(10),mass4set(:,3),  & 
G1H2(17),G1H2(21),G1H2(23),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(21),4,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(10),mass4set(:,4),  & 
G1H2(33),G1H2(39),G1H2(40),G1H2(45),G1H2(51),2)
  call HG1shiftOLR(G1H2(39),4,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(10),mass4set(:,5),  & 
G1H2(6),G1H2(1),G1H2(53),G1H2(12),G1H2(7),2)
  call HG1shiftOLR(G1H2(1),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(10),mass4set(:,3),  & 
G1H2(8),G1H2(24),G1H2(16),G1H2(29),G1H2(25),2)
  call HG1shiftOLR(G1H2(24),4,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(10),mass4set(:,4),  & 
G1H2(22),G1H2(41),G1H2(26),G1H2(35),G1H2(30),2)
  call HG1shiftOLR(G1H2(41),4,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(11),mass4set(:,2),  & 
G1H2(47),G1H2(13),G1H2(34),G1H2(14),G1H2(18),2)
  call HG1shiftOLR(G1H2(13),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(11),mass4set(:,3),  & 
G1H2(46),G1H2(19),G1H2(20),G1H2(52),G1H2(55),2)
  call HG1shiftOLR(G1H2(19),8,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(11),mass4set(:,4),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(57),8,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(11),mass4set(:,5),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),2)
  call HG1shiftOLR(G1H2(62),8,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(11),mass4set(:,3),  & 
G1H2(66),G1H2(67),G1H2(68),G1H2(69),G1H2(70),2)
  call HG1shiftOLR(G1H2(67),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(11),mass4set(:,4),  & 
G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),2)
  call HG1shiftOLR(G1H2(72),8,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(3),mass4set(:,1),  & 
G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(77),8,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(3),mass4set(:,6),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),2)
  call HG1shiftOLR(G1H2(82),8,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(3),mass4set(:,7),  & 
G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(87),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),ngZd,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(37),n2h1(46))
  call Hloop_VQ_A(ntryL,G1H2(31),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(38),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(32),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(48))
  call Hloop_ZQ_A(ntryL,G1H2(36),ex3(:),G1H1(1),ngZd,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(40),n2h1(49))
  call Hloop_ZQ_A(ntryL,G1H2(37),ex3(:),G1H1(1),ngZd,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(42),n2h1(51))
  call Hloop_ZQ_A(ntryL,G1H2(42),ex3(:),G1H1(1),ngZd,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(43),n2h1(52))
  call Hloop_VQ_A(ntryL,G1H2(43),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(44),n2h1(53))
  call Hloop_ZQ_A(ntryL,G1H2(44),ex3(:),G1H1(1),ngZd,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(45),n2h1(54))
  call Hloop_WQ_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(46),n2h1(55))
  call Hloop_WA_Q(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(47),n2h1(56))
  call Hloop_WA_Q(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(48),n2h1(57))
  call Hloop_WA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(49),n2h1(58))
  call Hloop_SQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),ngH,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(50),n2h1(59))
  call Hloop_SQ_A(ntryL,G1H2(9),ex3(:),G1H1(1),ngH,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(51),n2h1(60))
  call Hloop_SQ_A(ntryL,G1H2(15),ex3(:),G1H1(1),ngH,m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(52),n2h1(61))
  call Hloop_SQ_A(ntryL,G1H2(17),ex3(:),G1H1(1),ngX,m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(53),n2h1(62))
  call Hloop_SQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),ngX,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(54),n2h1(63))
  call Hloop_SQ_A(ntryL,G1H2(28),ex3(:),G1H1(1),ngX,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(64))
  call Hloop_SQ_A(ntryL,G1H2(33),ex3(:),G1H1(1),ngPtb,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(56),n2h1(65))
  call Hloop_SQ_A(ntryL,G1H2(39),ex3(:),G1H1(1),ngPtb,m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(57),n2h1(66))
  call Hloop_SQ_A(ntryL,G1H2(51),ex3(:),G1H1(1),ngPtb,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(58),n2h1(67))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(60),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(61),n2h1(70))
  call Hloop_ZQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),ngZd,m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(62),n2h1(71))
  call Hloop_ZQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),ngZd,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(63),n2h1(72))
  call Hloop_ZQ_A(ntryL,G1H2(25),ex3(:),G1H1(1),ngZd,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(64),n2h1(73))
  call Hloop_WQ_A(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(65),n2h1(74))
  call Hloop_WQ_A(ntryL,G1H2(41),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(66),n2h1(75))
  call Hloop_WQ_A(ntryL,G1H2(30),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(67),n2h1(76))
  call Hloop_SA_Q(ntryL,G1H2(47),ex4(:),G1H1(1),ngH,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(68),n2h1(77))
  call Hloop_SA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),ngH,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(69),n2h1(78))
  call Hloop_SA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),ngH,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(70),n2h1(79))
  call Hloop_SA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),ngX,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(80))
  call Hloop_SA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),ngX,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(72),n2h1(81))
  call Hloop_SA_Q(ntryL,G1H2(55),ex4(:),G1H1(1),ngX,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(73),n2h1(82))
  call Hloop_SA_Q(ntryL,G1H2(56),ex4(:),G1H1(1),ngPbt,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(74),n2h1(83))
  call Hloop_SA_Q(ntryL,G1H2(57),ex4(:),G1H1(1),ngPbt,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(75),n2h1(84))
  call Hloop_SA_Q(ntryL,G1H2(60),ex4(:),G1H1(1),ngPbt,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(76),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(77),n2h1(86))
  call Hloop_VA_Q(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(78),n2h1(87))
  call Hloop_VA_Q(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(79),n2h1(88))
  call Hloop_ZA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),ngZd,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(80),n2h1(89))
  call Hloop_ZA_Q(ntryL,G1H2(67),ex4(:),G1H1(1),ngZd,m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(81),n2h1(90))
  call Hloop_ZA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),ngZd,m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(82),n2h1(91))
  call Hloop_WA_Q(ntryL,G1H2(71),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(83),n2h1(92))
  call Hloop_WA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(84),n2h1(93))
  call Hloop_WA_Q(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(85),n2h1(94))
  call Hloop_SA_Q(ntryL,G1H2(76),ex4(:),G1H1(1),ngPbt,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(86),n2h1(95))
  call Hloop_SA_Q(ntryL,G1H2(77),ex4(:),G1H1(1),ngPbt,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(87),n2h1(96))
  call Hloop_SA_Q(ntryL,G1H2(80),ex4(:),G1H1(1),ngPbt,m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(88),n2h1(97))
  call Hloop_SA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),ngX,m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(89),n2h1(98))
  call Hloop_SA_Q(ntryL,G1H2(82),ex4(:),G1H1(1),ngX,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(90),n2h1(99))
  call Hloop_SA_Q(ntryL,G1H2(85),ex4(:),G1H1(1),ngX,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(91),n2h1(100))
  call Hloop_SA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),ngH,m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(92),n2h1(101))
  call Hloop_SA_Q(ntryL,G1H2(87),ex4(:),G1H1(1),ngH,m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(93),n2h1(102))
  call Hloop_SA_Q(ntryL,G1H2(90),ex4(:),G1H1(1),ngH,m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(94),n2h1(103))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(3),G1tensor(12),G1tensor(6)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(9),G1tensor(24),G1tensor(18)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(15),G1tensor(42),G1tensor(30)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(18),G1tensor(48),G1tensor(36)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(16),G1tensor(4)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(29),G1tensor(5)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(22),G1tensor(10)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(41),G1tensor(11)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(35),G1tensor(17)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(47),G1tensor(23)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(34),G1tensor(28)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(46),G1tensor(40)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(47),G1tensor(53)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(37)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(53)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(56)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(71)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(74)])
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(12),mass4set(:,8),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(4),mass4set(:,9),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(2))
  call G_TensorShift(G1tensor(37),10)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(12),mass4set(:,10),  & 
G1tensor(12),G1tensor(6),G1tensor(8),G1tensor(14),G1tensor(24))
  call G_TensorShift(G1tensor(6),2)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(12),mass4set(:,11),  & 
G1tensor(18),G1tensor(20),G1tensor(26),G1tensor(42),G1tensor(30))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(4),mass4set(:,12),  & 
G1tensor(32),G1tensor(48),G1tensor(36),G1tensor(38),G1tensor(44))
  call G_TensorShift(G1tensor(48),10)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(12),mass4set(:,13),  & 
G1tensor(50),G1tensor(54),G1tensor(3),G1tensor(16),G1tensor(4))
  call G_TensorShift(G1tensor(54),2)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(13),mass4set(:,8),  & 
G1tensor(29),G1tensor(5),G1tensor(9),G1tensor(22),G1tensor(10))
  call G_TensorShift(G1tensor(5),1)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(8),mass4set(:,9),  & 
G1tensor(41),G1tensor(11),G1tensor(15),G1tensor(35),G1tensor(17))
  call G_TensorShift(G1tensor(11),9)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(13),mass4set(:,11),  & 
G1tensor(21),G1tensor(47),G1tensor(23),G1tensor(27),G1tensor(34))
  call G_TensorShift(G1tensor(47),1)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(8),mass4set(:,12),  & 
G1tensor(28),G1tensor(33),G1tensor(39),G1tensor(46),G1tensor(40))
  call G_TensorShift(G1tensor(33),9)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(13),mass4set(:,10),  & 
G1tensor(45),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(55))
  call G_TensorShift(G1tensor(51),1)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(13),mass4set(:,13),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),1)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(13),mass4set(:,14),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),1)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(8),mass4set(:,15),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),9)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,16),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,9),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),8)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(3),mass4set(:,9),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),8)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(1),mass4set(:,17),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),8)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(2),mass4set(:,18),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(3),mass4set(:,18),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),8)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(1),mass4set(:,19),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),8)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(3),mass4set(:,12),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),8)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(1),mass4set(:,20),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),8)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(3),mass4set(:,21),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),8)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(6),mass4set(:,16),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(7),mass4set(:,9),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),8)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(6),mass4set(:,19),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),8)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(6),mass4set(:,17),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),8)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(7),mass4set(:,18),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),8)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(6),mass4set(:,20),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),8)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(6),mass4set(:,22),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(7),mass4set(:,23),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),8)
  call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(3),mass4set(:,1),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),8)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(3),mass4set(:,6),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),8)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(14),mass4set(:,16),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),4)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(14),mass4set(:,19),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),4)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(14),mass4set(:,17),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(14),mass4set(:,20),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),4)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(15),mass4set(:,16),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),4)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(15),mass4set(:,17),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),4)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(15),mass4set(:,19),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),4)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(15),mass4set(:,20),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),4)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(15),mass4set(:,22),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(10),mass4set(:,2),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),4)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(10),mass4set(:,3),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),4)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(10),mass4set(:,4),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),4)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(10),mass4set(:,5),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),4)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(11),mass4set(:,2),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(237),8)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(11),mass4set(:,3),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(11),mass4set(:,4),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(247),8)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(11),mass4set(:,5),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
  call G_TensorShift(G1tensor(252),8)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(3),mass4set(:,7),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
  call G_TensorShift(G1tensor(257),8)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(12),mass4set(:,8),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(4),mass4set(:,9),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(12),mass4set(:,10),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(18),RedSet_4(12),mass4set(:,11),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(32),RedSet_4(4),mass4set(:,12),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(12),mass4set(:,13),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(13),mass4set(:,8),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(8),mass4set(:,9),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(13),mass4set(:,11),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(8),mass4set(:,12),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(45),RedSet_4(13),mass4set(:,10),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(13),mass4set(:,13),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(13),mass4set(:,14),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(8),mass4set(:,15),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(1),mass4set(:,16),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(2),mass4set(:,9),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(3),mass4set(:,9),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(1),mass4set(:,17),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(2),mass4set(:,18),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(3),mass4set(:,18),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(1),mass4set(:,19),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(3),mass4set(:,12),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(1),mass4set(:,20),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(3),mass4set(:,21),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(6),mass4set(:,16),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(7),mass4set(:,9),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(6),mass4set(:,19),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(6),mass4set(:,17),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(7),mass4set(:,18),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(6),mass4set(:,20),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(6),mass4set(:,22),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(7),mass4set(:,23),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(3),mass4set(:,1),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(3),mass4set(:,6),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(14),mass4set(:,16),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(14),mass4set(:,19),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(14),mass4set(:,17),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(14),mass4set(:,20),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(15),mass4set(:,16),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(15),mass4set(:,17),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(15),mass4set(:,19),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(15),mass4set(:,20),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(15),mass4set(:,22),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(10),mass4set(:,2),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(10),mass4set(:,3),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(10),mass4set(:,4),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(10),mass4set(:,5),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(11),mass4set(:,2),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(11),mass4set(:,3),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(11),mass4set(:,4),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(11),mass4set(:,5),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(3),mass4set(:,7),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[20,3,8],[nMB,nMB,nMH],3,2,wf4(:,3),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngH,m3h4x8(:,19),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMB,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(2),ngX,m3h4x8(:,20),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G0H8(2),20,nMB,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(3),ngPtb,m3h4x8(:,21),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H8(3),20,nMT,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[20,3,8],[nMB,nMB,nMH],3,2,wf4(:,3),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(4),ngH,m3h4x8(:,22),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H8(4),20,nMB,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(5),ngX,m3h4x8(:,23),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H8(5),20,nMB,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(6),ngPtb,m3h4x8(:,24),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H8(6),20,nMT,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(7),ngPtb,m3h4x8(:,25),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[20,3,8],[nMZ,nMH,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(8),ngX,m3h4x8(:,26),heltab2x32(:,:,71))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[20,3,8],[nMH,nMZ,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(9),ngH,m3h4x8(:,27),heltab2x32(:,:,72))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(10),ngPtb,m3h4x8(:,28),heltab2x32(:,:,73))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[20,3,8],[nMB,nMB,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(11),m3h4x8(:,29),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G0H8(11),20,nMB,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(12),ngZd,m3h4x8(:,30),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G0H8(12),20,nMB,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(13),m3h4x8(:,31),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G0H8(13),20,nMT,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[20,3,8],[nMB,nMB,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(14),m3h4x8(:,32),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G0H8(14),20,nMB,G1H8(10),n2h8(10))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(15),ngZd,m3h4x8(:,33),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G0H8(15),20,nMB,G1H8(11),n2h8(11))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(16),m3h4x8(:,34),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G0H8(16),20,nMT,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(17),m3h4x8(:,35),heltab2x32(:,:,80))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[20,3,8],[nMZ,nMH,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(18),ngZd,m3h4x8(:,36),heltab2x32(:,:,81))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,37),heltab2x32(:,:,82))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(2),ngPtb,m3h4x8(:,38),heltab2x32(:,:,83))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[20,3,8],[nMH,nMZ,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(3),ngH,m3h4x8(:,39),heltab2x32(:,:,84))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(4),ngPtb,m3h4x8(:,40),heltab2x32(:,:,85))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,41),heltab2x32(:,:,86))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,42),heltab2x32(:,:,87))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[24,3,4],[nMB,nMB,nMH],3,2,wf4(:,6),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(11),ngH,m3h4x8(:,43),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G0H8(11),24,nMB,G1H8(13),n2h8(13))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,6),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(12),ngX,m3h4x8(:,44),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G0H8(12),24,nMB,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,6),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),ngPbt,m3h4x8(:,45),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G0H8(13),24,nMT,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[24,3,4],[nMB,nMB,nMH],3,2,wf4(:,6),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(14),ngH,m3h4x8(:,46),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G0H8(14),24,nMB,G1H8(16),n2h8(16))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,6),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),ngX,m3h4x8(:,47),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G0H8(15),24,nMB,G1H8(17),n2h8(17))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,6),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(16),ngPbt,m3h4x8(:,48),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H8(16),24,nMT,G1H8(18),n2h8(18))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(11),ngPbt,m3h4x8(:,49),heltab2x32(:,:,94))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[24,3,4],[nMZ,nMH,nMB],3,2,wf4(:,6),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(12),ngX,m3h4x8(:,50),heltab2x32(:,:,95))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[24,3,4],[nMH,nMZ,nMB],3,2,wf4(:,6),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(13),ngH,m3h4x8(:,51),heltab2x32(:,:,96))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(14),ngPbt,m3h4x8(:,52),heltab2x32(:,:,97))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[24,3,4],[nMB,nMB,0],3,2,wf4(:,6),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,53),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G0H8(15),24,nMB,G1H8(19),n2h8(19))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,6),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(16),ngZd,m3h4x8(:,54),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H8(16),24,nMB,G1H8(20),n2h8(20))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,6),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,55),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H8(15),24,nMT,G1H8(21),n2h8(21))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[24,3,4],[nMB,nMB,0],3,2,wf4(:,6),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(16),m3h4x8(:,56),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H8(16),24,nMB,G1H8(22),n2h8(22))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,6),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),ngZd,m3h4x8(:,57),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H8(15),24,nMB,G1H8(23),n2h8(23))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,6),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(16),m3h4x8(:,58),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H8(16),24,nMT,G1H8(24),n2h8(24))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,59),heltab2x32(:,:,104))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[24,3,4],[nMZ,nMH,nMB],3,2,wf4(:,6),wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(16),ngZd,m3h4x8(:,60),heltab2x32(:,:,105))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(19),m3h4x8(:,61),heltab2x32(:,:,106))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(20),ngPbt,m3h4x8(:,62),heltab2x32(:,:,107))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[24,3,4],[nMH,nMZ,nMB],3,2,wf4(:,6),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(21),ngH,m3h4x8(:,63),heltab2x32(:,:,108))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(22),ngPbt,m3h4x8(:,64),heltab2x32(:,:,109))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(23),m3h4x8(:,65),heltab2x32(:,:,110))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,6),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(24),m3h4x8(:,66),heltab2x32(:,:,111))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,7,8],[nMB,nMH,nMB],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(46))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(47))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(3),n2h16(48))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,7,8],[nMB,nMH,nMB],3,1,wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(49))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(50))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(6),n2h16(51))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,7,8],[nMB,0,nMB],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(52))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(53))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(54))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,7,8],[nMB,0,nMB],3,1,wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(55))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(11),n2h16(56))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(12),n2h16(57))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,4,11],[nMB,nMH,nMB],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(13),n2h16(58))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(14),n2h16(59))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(15),n2h16(60))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,4,11],[nMB,nMH,nMB],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(16),n2h16(61))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(62))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(18),n2h16(63))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,4,11],[nMB,0,nMB],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(64))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(65))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(21),n2h16(66))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,4,11],[nMB,0,nMB],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(67))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(23),n2h16(68))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(69))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[28,1,2],[nMZ,0,nMZ],3,1,wf8(:,23))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,23),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,136))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[28,1,2],[nMW,0,nMW],3,1,wf8(:,23))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,23),G0H4(2),m3h8x4(:,2),heltab2x32(:,:,137))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[28,1,2],[0,0,0],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,14),G0H4(3),m3h8x4(:,3),heltab2x32(:,:,138))
  call Hloop_A_Q(ntryL,G0H4(3),28,0,G1H4(1),n2h4(52))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[28,1,2],[0,nMZ,0],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,14),G0H4(3),m3h8x4(:,4),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G0H4(3),28,0,G1H4(2),n2h4(53))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[28,1,2],[0,0,0],3,1,wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,15),G0H4(3),ngZl,m3h8x4(:,5),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G0H4(3),28,0,G1H4(3),n2h4(54))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[28,1,2],[0,nMZ,0],3,1,wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,15),G0H4(3),ngZl,m3h8x4(:,6),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G0H4(3),28,0,G1H4(4),n2h4(55))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[28,1,2],[0,nMW,0],3,1,wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,15),G0H4(3),ngZn,m3h8x4(:,7),heltab2x32(:,:,142))
  call Hloop_A_Q(ntryL,G0H4(3),28,0,G1H4(5),n2h4(56))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[28,1,2],[nMW,0,nMW],3,1,wf8(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(6),m3h8x4(:,8),heltab2x32(:,:,143))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[28,1,2],[nMW,0,nMW],3,1,wf8(:,15))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(7),m3h8x4(:,9),heltab2x32(:,:,144))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[28,1,2],[nMZ,0,nMZ],3,1,wf8(:,24))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,24),G0H4(3),m3h8x4(:,10),heltab2x32(:,:,145))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[28,1,2],[nMW,0,nMW],3,1,wf8(:,24))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,24),G0H4(4),m3h8x4(:,11),heltab2x32(:,:,146))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[28,1,2],[0,0,0],3,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(5),m3h8x4(:,12),heltab2x32(:,:,147))
  call Hloop_A_Q(ntryL,G0H4(5),28,0,G1H4(8),n2h4(57))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[28,1,2],[0,nMZ,0],3,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(5),m3h8x4(:,13),heltab2x32(:,:,148))
  call Hloop_A_Q(ntryL,G0H4(5),28,0,G1H4(9),n2h4(58))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[28,1,2],[0,0,0],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,20),G0H4(5),ngZl,m3h8x4(:,14),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G0H4(5),28,0,G1H4(10),n2h4(59))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[28,1,2],[0,nMZ,0],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,20),G0H4(5),ngZl,m3h8x4(:,15),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G0H4(5),28,0,G1H4(11),n2h4(60))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[28,1,2],[0,nMW,0],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,20),G0H4(5),ngZn,m3h8x4(:,16),heltab2x32(:,:,151))
  call Hloop_A_Q(ntryL,G0H4(5),28,0,G1H4(12),n2h4(61))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[28,1,2],[nMW,0,nMW],3,1,wf8(:,19))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(13),m3h8x4(:,17),heltab2x32(:,:,152))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[28,1,2],[nMW,0,nMW],3,1,wf8(:,20))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(14),m3h8x4(:,18),heltab2x32(:,:,153))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(3),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(13),G1H4(7),G1H4(6),G0H4(4),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(8),G1H4(3),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(9),G1H4(4),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(5)])
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(2),m3h4x2(:,13),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMB,G2H2(17),n2h2(1))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,1),G1H2(31),m3h4x2(:,14),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(31),23,nMB,G2H2(13),n2h2(2))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,1),G1H2(32),m3h4x2(:,15),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(32),23,nMT,G2H2(18),n2h2(3))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,4),G1H2(36),ngZd,m3h4x2(:,16),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMB,G2H2(1),n2h2(4))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,4),G1H2(37),ngZd,m3h4x2(:,17),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(37),23,nMB,G2H2(2),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,4),G1H2(38),ngZu,m3h4x2(:,18),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(38),23,nMT,G2H2(3),n2h2(6))
  call Hloop_TV_S(ntryL,G0H8(7),20,wf4(:,1),3,G1H2(42),m3h4x2(:,19),heltab2x8(:,:,46))
  call Hloop_SV_T(ntryL,G0H8(8),20,wf4(:,4),3,G1H2(43),m3h4x2(:,20),heltab2x8(:,:,47))
  call Hloop_TV_S(ntryL,G0H8(9),20,wf4(:,4),3,G1H2(44),m3h4x2(:,21),heltab2x8(:,:,48))
  call Hloop_TV_S(ntryL,G0H8(10),20,wf4(:,4),3,G1H2(48),m3h4x2(:,22),heltab2x8(:,:,49))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,1),G1H2(49),m3h4x2(:,23),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(49),23,nMB,G2H2(4),n2h2(7))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,1),G1H2(50),m3h4x2(:,24),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(50),23,nMB,G2H2(5),n2h2(8))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,1),G1H2(4),m3h4x2(:,25),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMT,G2H2(6),n2h2(9))
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,4),G1H2(5),ngZd,m3h4x2(:,26),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(7),n2h2(10))
  call Hloop_QZ_A(ntryL,G1H8(11),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,27),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(9),23,nMB,G2H2(8),n2h2(11))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,4),G1H2(15),ngZu,m3h4x2(:,28),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(15),23,nMT,G2H2(9),n2h2(12))
  call Hloop_VV_S(ntryL,G0H8(17),wf4(:,1),G0H2(1),m3h4x2(:,29),heltab2x8(:,:,56))
  call Hloop_VV_S(ntryL,G0H8(18),wf4(:,4),G0H2(2),m3h4x2(:,30),heltab2x8(:,:,57))
  call Hloop_VV_S(ntryL,G0H8(1),wf4(:,4),G0H2(3),m3h4x2(:,31),heltab2x8(:,:,58))
  call Hloop_SV_V(ntryL,G0H8(2),wf4(:,1),G0H2(4),m3h4x2(:,32),heltab2x8(:,:,59))
  call Hloop_SV_V(ntryL,G0H8(3),wf4(:,4),G0H2(5),m3h4x2(:,33),heltab2x8(:,:,60))
  call Hloop_SV_V(ntryL,G0H8(4),wf4(:,4),G0H2(6),m3h4x2(:,34),heltab2x8(:,:,61))
  call Hloop_UV_W(ntryL,G0H8(5),20,wf4(:,1),3,G1H2(17),m3h4x2(:,35),heltab2x8(:,:,62))
  call Hloop_UV_W(ntryL,G0H8(6),20,wf4(:,4),3,G1H2(21),m3h4x2(:,36),heltab2x8(:,:,63))
  call Hloop_AV_Q(ntryL,G1H8(13),wf4(:,1),G1H2(28),m3h4x2(:,37),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(28),27,nMB,G2H2(10),n2h2(13))
  call Hloop_AV_Q(ntryL,G1H8(14),wf4(:,1),G1H2(33),m3h4x2(:,38),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(33),27,nMB,G2H2(11),n2h2(14))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,1),G1H2(39),m3h4x2(:,39),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(39),27,nMT,G2H2(12),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H8(16),wf4(:,4),G1H2(51),ngZd,m3h4x2(:,40),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(51),27,nMB,G2H2(16),n2h2(16))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,4),G1H2(6),ngZd,m3h4x2(:,41),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(6),27,nMB,G2H2(14),n2h2(17))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,4),G1H2(1),ngZu,m3h4x2(:,42),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(15),n2h2(18))
  call Hloop_SV_T(ntryL,G0H8(11),24,wf4(:,1),3,G1H2(7),m3h4x2(:,43),heltab2x8(:,:,70))
  call Hloop_SV_T(ntryL,G0H8(12),24,wf4(:,4),3,G1H2(8),m3h4x2(:,44),heltab2x8(:,:,71))
  call Hloop_TV_S(ntryL,G0H8(13),24,wf4(:,4),3,G1H2(24),m3h4x2(:,45),heltab2x8(:,:,72))
  call Hloop_SV_T(ntryL,G0H8(14),24,wf4(:,4),3,G1H2(25),m3h4x2(:,46),heltab2x8(:,:,73))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,1),G1H2(22),m3h4x2(:,47),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(22),27,nMB,G2H2(19),n2h2(19))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,1),G1H2(41),m3h4x2(:,48),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(41),27,nMB,G2H2(20),n2h2(20))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,1),G1H2(30),m3h4x2(:,49),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(30),27,nMT,G2H2(21),n2h2(21))
  call Hloop_AZ_Q(ntryL,G1H8(22),wf4(:,4),G1H2(47),ngZd,m3h4x2(:,50),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(47),27,nMB,G2H2(22),n2h2(22))
  call Hloop_AZ_Q(ntryL,G1H8(23),wf4(:,4),G1H2(13),ngZd,m3h4x2(:,51),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(13),27,nMB,G2H2(23),n2h2(23))
  call Hloop_AZ_Q(ntryL,G1H8(24),wf4(:,4),G1H2(18),ngZu,m3h4x2(:,52),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(18),27,nMT,G2H2(24),n2h2(24))
  call Hloop_VV_S(ntryL,G0H8(15),wf4(:,1),G0H2(7),m3h4x2(:,53),heltab2x8(:,:,80))
  call Hloop_VV_S(ntryL,G0H8(16),wf4(:,4),G0H2(8),m3h4x2(:,54),heltab2x8(:,:,81))
  call Hloop_VV_S(ntryL,G0H8(19),wf4(:,4),G0H2(9),m3h4x2(:,55),heltab2x8(:,:,82))
  call Hloop_SV_V(ntryL,G0H8(20),wf4(:,1),G0H2(10),m3h4x2(:,56),heltab2x8(:,:,83))
  call Hloop_SV_V(ntryL,G0H8(21),wf4(:,4),G0H2(11),m3h4x2(:,57),heltab2x8(:,:,84))
  call Hloop_SV_V(ntryL,G0H8(22),wf4(:,4),G0H2(12),m3h4x2(:,58),heltab2x8(:,:,85))
  call Hloop_UW_V(ntryL,G0H8(23),24,wf4(:,1),3,G1H2(46),m3h4x2(:,59),heltab2x8(:,:,86))
  call Hloop_UW_V(ntryL,G0H8(24),24,wf4(:,4),3,G1H2(19),m3h4x2(:,60),heltab2x8(:,:,87))
  call Hloop_AQ_S(ntryL,G1H16(1),wf8(:,21),G1H2(55),ngH,m3h8x2(:,1),heltab2x16(:,:,46))
  call Hloop_AQ_S(ntryL,G1H16(2),wf8(:,21),G1H2(56),ngX,m3h8x2(:,2),heltab2x16(:,:,47))
  call Hloop_AQ_S(ntryL,G1H16(3),wf8(:,21),G1H2(57),ngPtb,m3h8x2(:,3),heltab2x16(:,:,48))
  call Hloop_AQ_S(ntryL,G1H16(4),wf8(:,22),G1H2(60),ngH,m3h8x2(:,4),heltab2x16(:,:,49))
  call Hloop_AQ_S(ntryL,G1H16(5),wf8(:,22),G1H2(61),ngX,m3h8x2(:,5),heltab2x16(:,:,50))
  call Hloop_AQ_S(ntryL,G1H16(6),wf8(:,22),G1H2(62),ngPtb,m3h8x2(:,6),heltab2x16(:,:,51))
  call Hloop_AQ_V(ntryL,G1H16(7),wf8(:,21),G1H2(65),m3h8x2(:,7),heltab2x16(:,:,52))
  call Hloop_AQ_Z(ntryL,G1H16(8),wf8(:,21),G1H2(66),ngZd,m3h8x2(:,8),heltab2x16(:,:,53))
  call Hloop_AQ_W(ntryL,G1H16(9),wf8(:,21),G1H2(67),m3h8x2(:,9),heltab2x16(:,:,54))
  call Hloop_AQ_V(ntryL,G1H16(10),wf8(:,22),G1H2(70),m3h8x2(:,10),heltab2x16(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H16(11),wf8(:,22),G1H2(71),ngZd,m3h8x2(:,11),heltab2x16(:,:,56))
  call Hloop_AQ_W(ntryL,G1H16(12),wf8(:,22),G1H2(72),m3h8x2(:,12),heltab2x16(:,:,57))
  call Hloop_AQ_S(ntryL,G1H16(13),ex3(:),G1H8(1),ngH,m3h2x8(:,22),heltab2x16(:,:,58))
  call Hloop_AQ_S(ntryL,G1H16(14),ex3(:),G1H8(2),ngX,m3h2x8(:,23),heltab2x16(:,:,59))
  call Hloop_AQ_S(ntryL,G1H16(15),ex3(:),G1H8(3),ngPtb,m3h2x8(:,24),heltab2x16(:,:,60))
  call Hloop_AQ_S(ntryL,G1H16(16),ex3(:),G1H8(4),ngH,m3h2x8(:,25),heltab2x16(:,:,61))
  call Hloop_AQ_S(ntryL,G1H16(17),ex3(:),G1H8(5),ngX,m3h2x8(:,26),heltab2x16(:,:,62))
  call Hloop_AQ_S(ntryL,G1H16(18),ex3(:),G1H8(6),ngPtb,m3h2x8(:,27),heltab2x16(:,:,63))
  call Hloop_AQ_V(ntryL,G1H16(19),ex3(:),G1H8(7),m3h2x8(:,28),heltab2x16(:,:,64))
  call Hloop_AQ_Z(ntryL,G1H16(20),ex3(:),G1H8(8),ngZd,m3h2x8(:,29),heltab2x16(:,:,65))
  call Hloop_AQ_W(ntryL,G1H16(21),ex3(:),G1H8(9),m3h2x8(:,30),heltab2x16(:,:,66))
  call Hloop_AQ_V(ntryL,G1H16(22),ex3(:),G1H8(10),m3h2x8(:,31),heltab2x16(:,:,67))
  call Hloop_AQ_Z(ntryL,G1H16(23),ex3(:),G1H8(11),ngZd,m3h2x8(:,32),heltab2x16(:,:,68))
  call Hloop_AQ_W(ntryL,G1H16(24),ex3(:),G1H8(12),m3h2x8(:,33),heltab2x16(:,:,69))
  call Hloop_ZQ_A(ntryL,G0H4(3),ex1(:),G0H2(13),ngZl,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G0H2(13),29,0,G1H2(75),n2h2(25))
  call Hloop_WQ_A(ntryL,G1H4(14),ex1(:),G1H2(76),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(76),29,0,G2H2(25),n2h2(26))
  call Hloop_AQ_V(ntryL,G1H4(10),ex1(:),G1H2(77),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AQ_Z(ntryL,G1H4(11),ex1(:),G1H2(80),ngZl,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_W(ntryL,G1H4(12),ex1(:),G1H2(81),m3h2x2(:,44),heltab2x4(:,:,44))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(17),G1H2(54),G0H2(6),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(67),G1H2(74),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(60),[G1H2(55),G1H2(89),G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(61),[G1H2(56),G1H2(84),G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(57),G1H2(79),G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(70),[G1H2(65),G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(66),G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(42),G1H2(78),G0H2(3),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(88),G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(25),[G1H2(7),G0H2(9),G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G0H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(46),G0H2(12),G0H2(10)])
  call Hloop_WA_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(3),n2h1(104))
  call Hloop_WA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(9),n2h1(105))
  call Hloop_SQ_A(ntryL,G1H2(10),ex3(:),G1H1(1),ngH,m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(15),n2h1(106))
  call Hloop_SQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),ngH,m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(18),n2h1(107))
  call Hloop_SQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),ngX,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(47),n2h1(108))
  call Hloop_SQ_A(ntryL,G1H2(27),ex3(:),G1H1(1),ngX,m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(37),n2h1(109))
  call Hloop_SQ_A(ntryL,G1H2(40),ex3(:),G1H1(1),ngPtb,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(53),n2h1(110))
  call Hloop_SQ_A(ntryL,G1H2(45),ex3(:),G1H1(1),ngPtb,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(56),n2h1(111))
  call Hloop_VQ_A(ntryL,G1H2(53),ex3(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(112))
  call Hloop_VQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(74),n2h1(113))
  call Hloop_ZQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),ngZd,m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(2),n2h1(114))
  call Hloop_ZQ_A(ntryL,G1H2(29),ex3(:),G1H1(1),ngZd,m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(115))
  call Hloop_WQ_A(ntryL,G1H2(26),ex3(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(5),n2h1(116))
  call Hloop_WQ_A(ntryL,G1H2(35),ex3(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(8),n2h1(117))
  call Hloop_SA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),ngH,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(12),n2h1(118))
  call Hloop_SA_Q(ntryL,G1H2(60),ex4(:),G1H1(1),ngH,m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(11),n2h1(119))
  call Hloop_SA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),ngX,m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(120))
  call Hloop_SA_Q(ntryL,G1H2(61),ex4(:),G1H1(1),ngX,m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(21),n2h1(121))
  call Hloop_SA_Q(ntryL,G1H2(58),ex4(:),G1H1(1),ngPbt,m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(17),n2h1(122))
  call Hloop_SA_Q(ntryL,G1H2(62),ex4(:),G1H1(1),ngPbt,m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(24),n2h1(123))
  call Hloop_VA_Q(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(20),n2h1(124))
  call Hloop_VA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(23),n2h1(125))
  call Hloop_ZA_Q(ntryL,G1H2(68),ex4(:),G1H1(1),ngZd,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(26),n2h1(126))
  call Hloop_ZA_Q(ntryL,G1H2(71),ex4(:),G1H1(1),ngZd,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(27),n2h1(127))
  call Hloop_WA_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(1),n2h1(128))
  call Hloop_SA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),ngPbt,m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(4),n2h1(129))
  call Hloop_SA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),ngX,m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(130))
  call Hloop_SA_Q(ntryL,G1H2(43),ex4(:),G1H1(1),ngH,m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(10),n2h1(131))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(13),ngH,m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(16),ngX,m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(19),ngPbt,m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(22),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(25),ngZd,m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(28),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hloop_ZA_Q(ntryL,G0H2(5),ex4(:),G0H1(1),ngZd,m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(1),n2h1(132))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(29),ngH,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(30),ngX,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(31),ngPtb,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hloop_SQ_A(ntryL,G1H2(25),ex3(:),G1H1(1),ngPtb,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(32),n2h1(133))
  call Hloop_SQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),ngH,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(33),n2h1(134))
  call Hloop_SQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),ngX,m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(34),n2h1(135))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(35),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(36),ngZd,m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(24),ex3(:),G2tensor(86),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hloop_WQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(89),n2h1(136))
  call Hloop_ZQ_A(ntryL,G0H2(11),ex3(:),G0H1(1),ngZd,m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(31),n2h1(137))
  call Hloop_SA_Q(ntryL,G1H8(1),wf8(:,16),G1H1(1),ngH,m3h8x1(:,1),heltab2x8(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(38),n2h1(138))
  call Hloop_SA_Q(ntryL,G1H8(2),wf8(:,16),G1H1(1),ngX,m3h8x1(:,2),heltab2x8(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(139))
  call Hloop_SA_Q(ntryL,G1H8(3),wf8(:,16),G1H1(1),ngPbt,m3h8x1(:,3),heltab2x8(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(40),n2h1(140))
  call Hloop_SA_Q(ntryL,G1H8(4),wf8(:,17),G1H1(1),ngH,m3h8x1(:,4),heltab2x8(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(141))
  call Hloop_SA_Q(ntryL,G1H8(5),wf8(:,17),G1H1(1),ngX,m3h8x1(:,5),heltab2x8(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(42),n2h1(142))
  call Hloop_SA_Q(ntryL,G1H8(6),wf8(:,17),G1H1(1),ngPbt,m3h8x1(:,6),heltab2x8(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(43),n2h1(143))
  call Hloop_VA_Q(ntryL,G1H8(7),wf8(:,16),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(44),n2h1(144))
  call Hloop_ZA_Q(ntryL,G1H8(8),wf8(:,16),G1H1(1),ngZd,m3h8x1(:,8),heltab2x8(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(45),n2h1(145))
  call Hloop_WA_Q(ntryL,G1H8(9),wf8(:,16),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(46),n2h1(146))
  call Hloop_VA_Q(ntryL,G1H8(10),wf8(:,17),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(50),n2h1(147))
  call Hloop_ZA_Q(ntryL,G1H8(11),wf8(:,17),G1H1(1),ngZd,m3h8x1(:,11),heltab2x8(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(62),n2h1(148))
  call Hloop_WA_Q(ntryL,G1H8(12),wf8(:,17),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(65),n2h1(149))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(75),ex2(:),G1tensor(12),ngZl,m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(25),ex2(:),G2tensor(59),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hloop_VA_Q(ntryL,G1H2(77),ex2(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(150))
  call Hloop_ZA_Q(ntryL,G1H2(80),ex2(:),G1H1(1),ngZl,m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(151))
  call Hloop_WA_Q(ntryL,G1H2(81),ex2(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(152))
  call ol_merge_tensors(G2tensor(87),[G2tensor(48),G1tensor(162),G1tensor(65),G0tensor(162),G0tensor(65)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(46),G2tensor(43),G2tensor(40),G2tensor(88),G2tensor(49),G1tensor(165),G1tensor(70) &
    ,G0tensor(165),G0tensor(70)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(51),G1tensor(217),G0tensor(217)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(79),G2tensor(73),G2tensor(70),G2tensor(64),G2tensor(61),G2tensor(55),G2tensor(52) &
    ,G1tensor(255),G1tensor(245),G1tensor(240),G1tensor(235),G1tensor(225),G1tensor(220),G0tensor(255),G0tensor(245),G0tensor(240) &
    ,G0tensor(235),G0tensor(225),G0tensor(220)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(16),G2tensor(63),G2tensor(54),G1tensor(222),G0tensor(222)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(19),G2tensor(66),G2tensor(57),G1tensor(227),G0tensor(227)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(76),G2tensor(67),G2tensor(58),G1tensor(250),G1tensor(230),G0tensor(250) &
    ,G0tensor(230)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(60),G1tensor(232),G0tensor(232)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(69),G1tensor(237),G0tensor(237)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(30),G2tensor(81),G2tensor(72),G1tensor(242),G0tensor(242)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(31),G2tensor(84),G2tensor(75),G1tensor(247),G0tensor(247)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(78),G1tensor(252),G0tensor(252)])
  call ol_merge_tensors(G2tensor(90),[G1tensor(167),G0tensor(167)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(38),G2tensor(91),G1tensor(170),G0tensor(170)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(257),G0tensor(257)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(45),G2tensor(42),G2tensor(39),G2tensor(94),G1tensor(260),G1tensor(120) &
    ,G1tensor(110),G1tensor(40),G1tensor(44),G0tensor(260),G0tensor(120),G0tensor(110),G0tensor(50),G0tensor(25)])
  call ol_merge_tensors(G1tensor(6),[G1tensor(37),G1tensor(7),G0tensor(12),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(192),G1tensor(72),G1tensor(13),G0tensor(192),G0tensor(72),G0tensor(3)])
  call ol_merge_tensors(G1tensor(77),[G1tensor(42),G1tensor(19),G0tensor(77),G0tensor(19),G0tensor(4)])
  call ol_merge_tensors(G1tensor(82),[G1tensor(10),G1tensor(25),G0tensor(82),G0tensor(35),G0tensor(5)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(75),G1tensor(43),G0tensor(90),G0tensor(75),G0tensor(8)])
  call ol_merge_tensors(G1tensor(95),[G1tensor(80),G1tensor(38),G1tensor(49),G0tensor(95),G0tensor(80),G0tensor(24),G0tensor(9)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(44),G1tensor(100),G1tensor(85),G1tensor(17),G1tensor(2),G0tensor(100),G0tensor(85) &
    ,G0tensor(40),G0tensor(10)])
  call ol_merge_tensors(G1tensor(197),[G1tensor(87),G1tensor(8),G0tensor(197),G0tensor(87),G0tensor(13)])
  call ol_merge_tensors(G1tensor(92),[G1tensor(16),G1tensor(14),G0tensor(92),G0tensor(29),G0tensor(14)])
  call ol_merge_tensors(G1tensor(97),[G1tensor(55),G1tensor(24),G0tensor(97),G0tensor(55),G0tensor(15)])
  call ol_merge_tensors(G1tensor(54),[G1tensor(48),G1tensor(20),G0tensor(27),G0tensor(22),G0tensor(17)])
  call ol_merge_tensors(G1tensor(202),[G1tensor(102),G1tensor(26),G0tensor(202),G0tensor(102),G0tensor(18)])
  call ol_merge_tensors(G1tensor(107),[G1tensor(34),G1tensor(30),G0tensor(107),G0tensor(45),G0tensor(20)])
  call ol_merge_tensors(G1tensor(115),[G1tensor(105),G1tensor(36),G0tensor(115),G0tensor(105),G0tensor(23)])
  call ol_merge_tensors(G1tensor(12),[G1tensor(207),G1tensor(112),G1tensor(3),G0tensor(207),G0tensor(112),G0tensor(28)])
  call ol_merge_tensors(G1tensor(117),[G1tensor(60),G1tensor(4),G0tensor(117),G0tensor(60),G0tensor(30)])
  call ol_merge_tensors(G1tensor(51),[G1tensor(11),G1tensor(5),G0tensor(52),G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G1tensor(172),[G1tensor(122),G1tensor(9),G0tensor(172),G0tensor(122),G0tensor(33)])
  call ol_merge_tensors(G1tensor(127),[G1tensor(27),G1tensor(22),G0tensor(127),G0tensor(44),G0tensor(34)])
  call ol_merge_tensors(G1tensor(140),[G1tensor(125),G1tensor(15),G0tensor(140),G0tensor(125),G0tensor(38)])
  call ol_merge_tensors(G1tensor(145),[G1tensor(130),G1tensor(46),G1tensor(35),G0tensor(145),G0tensor(130),G0tensor(49) &
    ,G0tensor(39)])
  call ol_merge_tensors(G1tensor(57),[G1tensor(33),G1tensor(47),G0tensor(57),G0tensor(47),G0tensor(42)])
  call ol_merge_tensors(G1tensor(177),[G1tensor(132),G1tensor(23),G0tensor(177),G0tensor(132),G0tensor(43)])
  call ol_merge_tensors(G1tensor(150),[G1tensor(135),G1tensor(39),G0tensor(150),G0tensor(135),G0tensor(48)])
  call ol_merge_tensors(G1tensor(182),[G1tensor(137),G1tensor(52),G0tensor(182),G0tensor(137),G0tensor(53)])
  call ol_merge_tensors(G1tensor(142),[G1tensor(59),G1tensor(53),G0tensor(142),G0tensor(59),G0tensor(54)])
  call ol_merge_tensors(G1tensor(187),[G1tensor(147),G1tensor(58),G0tensor(187),G0tensor(147),G0tensor(58)])
  call ol_merge_tensors(G1tensor(67),[G1tensor(62),G0tensor(67),G0tensor(62)])
  call ol_merge_tensors(G1tensor(152),[G1tensor(63),G0tensor(152),G0tensor(63)])
  call ol_merge_tensors(G1tensor(157),[G1tensor(64),G0tensor(157),G0tensor(64)])
  call ol_merge_tensors(G1tensor(155),[G1tensor(68),G0tensor(155),G0tensor(68)])
  call ol_merge_tensors(G1tensor(160),[G1tensor(69),G0tensor(160),G0tensor(69)])
  call ol_merge_tensors(G1tensor(103),[G1tensor(78),G1tensor(73),G0tensor(103),G0tensor(78),G0tensor(73)])
  call ol_merge_tensors(G1tensor(124),[G1tensor(83),G1tensor(74),G0tensor(124),G0tensor(83),G0tensor(74)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(254),G1tensor(129),G1tensor(109),G1tensor(84),G1tensor(79),G0tensor(254) &
    ,G0tensor(129),G0tensor(109),G0tensor(84),G0tensor(79)])
  call ol_merge_tensors(G1tensor(113),[G1tensor(93),G1tensor(88),G0tensor(113),G0tensor(93),G0tensor(88)])
  call ol_merge_tensors(G1tensor(139),[G1tensor(98),G1tensor(89),G0tensor(139),G0tensor(98),G0tensor(89)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(21),G1tensor(244),G1tensor(169),G1tensor(144),G1tensor(119),G1tensor(99) &
    ,G1tensor(94),G0tensor(244),G0tensor(169),G0tensor(144),G0tensor(119),G0tensor(99),G0tensor(94)])
  call ol_merge_tensors(G1tensor(134),[G1tensor(108),G1tensor(104),G0tensor(134),G0tensor(108),G0tensor(104)])
  call ol_merge_tensors(G1tensor(149),[G1tensor(118),G1tensor(114),G0tensor(149),G0tensor(118),G0tensor(114)])
  call ol_merge_tensors(G1tensor(133),[G1tensor(128),G1tensor(123),G0tensor(133),G0tensor(128),G0tensor(123)])
  call ol_merge_tensors(G1tensor(148),[G1tensor(143),G1tensor(138),G0tensor(148),G0tensor(143),G0tensor(138)])
  call ol_merge_tensors(G1tensor(158),[G1tensor(153),G0tensor(158),G0tensor(153)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(3),G1tensor(163),G1tensor(154),G0tensor(163),G0tensor(154)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(9),G1tensor(249),G1tensor(164),G1tensor(159),G0tensor(249),G0tensor(164) &
    ,G0tensor(159)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(1),G1tensor(168),G0tensor(168)])
  call ol_merge_tensors(G1tensor(178),[G1tensor(173),G0tensor(178),G0tensor(173)])
  call ol_merge_tensors(G1tensor(194),[G1tensor(174),G0tensor(194),G0tensor(174)])
  call ol_merge_tensors(G1tensor(185),[G1tensor(175),G0tensor(185),G0tensor(175)])
  call ol_merge_tensors(G1tensor(204),[G1tensor(179),G0tensor(204),G0tensor(179)])
  call ol_merge_tensors(G1tensor(190),[G1tensor(180),G0tensor(190),G0tensor(180)])
  call ol_merge_tensors(G1tensor(188),[G1tensor(183),G0tensor(188),G0tensor(183)])
  call ol_merge_tensors(G1tensor(199),[G1tensor(184),G0tensor(199),G0tensor(184)])
  call ol_merge_tensors(G1tensor(209),[G1tensor(189),G0tensor(209),G0tensor(189)])
  call ol_merge_tensors(G1tensor(203),[G1tensor(193),G0tensor(203),G0tensor(193)])
  call ol_merge_tensors(G1tensor(200),[G1tensor(195),G0tensor(200),G0tensor(195)])
  call ol_merge_tensors(G1tensor(208),[G1tensor(198),G0tensor(208),G0tensor(198)])
  call ol_merge_tensors(G1tensor(210),[G1tensor(205),G0tensor(210),G0tensor(205)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(212),G0tensor(212)])
  call ol_merge_tensors(G1tensor(213),[G0tensor(213)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(32),G1tensor(214),G0tensor(214)])
  call ol_merge_tensors(G1tensor(215),[G0tensor(215)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(218),G0tensor(218)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(219),G0tensor(219)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(47),G1tensor(223),G0tensor(223)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(37),G1tensor(224),G0tensor(224)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(53),G1tensor(228),G0tensor(228)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(56),G1tensor(229),G0tensor(229)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(233),G0tensor(233)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(234),G0tensor(234)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(238),G0tensor(238)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(259),G1tensor(239),G0tensor(259),G0tensor(239)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(14),G1tensor(243),G0tensor(243)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(17),G1tensor(248),G0tensor(248)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(253),G0tensor(253)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(258),G0tensor(258)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(31)])
  call TI_triangle_red(G2tensor(87),RedBasis(19),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMW,nMT], &
    G0tensor(21),G0tensor(26))
  call TI_triangle_red(G2tensor(65),RedBasis(1),mass3set(:,2),G0tensor(31),G0tensor(36),G0tensor(41), &
    G0tensor(46),M2L1R1,[nMT,nMW],G0tensor(51),G0tensor(56))
  call TI_triangle_red(G2tensor(13),RedBasis(5),mass3set(:,3),G0tensor(61),G0tensor(66),G0tensor(71), &
    G0tensor(76),M2L1R1,[nMH,nMB],G0tensor(81),G0tensor(86))
  call TI_triangle_red(G2tensor(82),RedBasis(15),mass3set(:,4),G0tensor(91),G0tensor(96),G0tensor(101),G0tensor(106),M2L1R1,[nMB], &
    G0tensor(111))
  call TI_triangle_red(G2tensor(25),RedBasis(5),mass3set(:,5),G0tensor(116),G0tensor(121),G0tensor(126), &
    G0tensor(131),M2L1R1,[nMZ,nMB],G0tensor(136),G0tensor(141))
  call TI_triangle_red(G2tensor(28),RedBasis(5),mass3set(:,6),G0tensor(146),G0tensor(151),G0tensor(156), &
    G0tensor(161),M2L1R1,[nMW,nMT],G0tensor(166),G0tensor(171))
  call TI_triangle_red(G2tensor(85),RedBasis(15),mass3set(:,7),G0tensor(176),G0tensor(181),G0tensor(186), &
    G0tensor(191),M2L1R1,[nMT],G0tensor(196))
  call TI_triangle_red(G2tensor(22),RedBasis(5),mass3set(:,8),G0tensor(201),G0tensor(206),G0tensor(211), &
    G0tensor(216),M2L1R1,[nMB],G0tensor(221))
  call TI_triangle_red(G2tensor(29),RedBasis(25),mass3set(:,3),G0tensor(226),G0tensor(231),G0tensor(236), &
    G0tensor(241),M2L1R1,[nMH,nMB],G0tensor(246),G0tensor(251))
  call TI_triangle_red(G2tensor(36),RedBasis(25),mass3set(:,5),G0tensor(256),G0tensor(162),G0tensor(65), &
    G0tensor(165),M2L1R1,[nMZ,nMB],G0tensor(70),G0tensor(217))
  call TI_triangle_red(G2tensor(86),RedBasis(25),mass3set(:,6),G0tensor(255),G0tensor(245),G0tensor(240), &
    G0tensor(235),M2L1R1,[nMW,nMT],G0tensor(225),G0tensor(220))
  call TI_triangle_red(G2tensor(35),RedBasis(25),mass3set(:,8),G0tensor(222),G0tensor(227),G0tensor(250), &
    G0tensor(230),M2L1R1,[nMB],G0tensor(232))
  call TI_triangle_red(G2tensor(90),RedBasis(19),mass3set(:,9),G0tensor(237),G0tensor(242),G0tensor(247), &
    G0tensor(252),M2L1R1,[nMZ,nMB,nMH],G0tensor(167),G0tensor(170),G0tensor(257))
  call TI_triangle_red(G2tensor(41),RedBasis(1),mass3set(:,10),G0tensor(260),G0tensor(120),G0tensor(110), &
    G0tensor(50),M2L1R1,[nMB,nMH],G0tensor(25),G0tensor(12))
  call TI_triangle_red(G2tensor(93),RedBasis(19),mass3set(:,11),G0tensor(7),G0tensor(2),G0tensor(192), &
    G0tensor(72),M2L1R1,[nMH,nMB,nMZ],G0tensor(3),G0tensor(77),G0tensor(19))
  call TI_triangle_red(G2tensor(62),RedBasis(1),mass3set(:,12),G0tensor(4),G0tensor(82),G0tensor(35),G0tensor(5),M2L1R1,[nMB,nMZ], &
    G0tensor(90),G0tensor(75))
  call TI_triangle_red(G2tensor(68),RedBasis(21),mass3set(:,13),G0tensor(8),G0tensor(95),G0tensor(80),G0tensor(24),M2L1R1)
  call TI_triangle_red(G2tensor(50),RedBasis(1),mass3set(:,14),G0tensor(9),G0tensor(100),G0tensor(85),G0tensor(40),M2L1R1,[nMB], &
    G0tensor(10))
  call TI_triangle_red(G2tensor(23),RedBasis(3),mass3set(:,14),G0tensor(197),G0tensor(87),G0tensor(13),G0tensor(92),M2L1R1,[nMB], &
    G0tensor(29))
  call TI_triangle_red(G2tensor(27),RedBasis(3),mass3set(:,12),G0tensor(14),G0tensor(97),G0tensor(55), &
    G0tensor(15),M2L1R1,[nMB,nMZ],G0tensor(27),G0tensor(22))
  call TI_triangle_red(G2tensor(4),RedBasis(5),mass3set(:,15),G0tensor(17),G0tensor(202),G0tensor(102), &
    G0tensor(18),M2L1R1,[nMT,nMW],G0tensor(107),G0tensor(45))
  call TI_triangle_red(G2tensor(24),RedBasis(3),mass3set(:,2),G0tensor(20),G0tensor(115),G0tensor(105), &
    G0tensor(23),M2L1R1,[nMT,nMW],G0tensor(207),G0tensor(112))
  call TI_triangle_red(G2tensor(7),RedBasis(5),mass3set(:,16),G0tensor(28),G0tensor(117),G0tensor(60), &
    G0tensor(30),M2L1R1,[nMB,nMH,nMZ],G0tensor(52),G0tensor(37),G0tensor(32))
  call TI_triangle_red(G2tensor(59),RedBasis(21),mass3set(:,17),G0tensor(172),G0tensor(122),G0tensor(33), &
    G0tensor(127),M2L1R1,[nMW],G0tensor(44))
  call TI_triangle_red(G2tensor(89),RedBasis(25),mass3set(:,15),G0tensor(34),G0tensor(140),G0tensor(125), &
    G0tensor(38),M2L1R1,[nMT,nMW],G0tensor(145),G0tensor(130))
  call TI_triangle_red(G2tensor(15),RedBasis(17),mass3set(:,10),G0tensor(49),G0tensor(39),G0tensor(57), &
    G0tensor(47),M2L1R1,[nMB,nMH],G0tensor(42),G0tensor(177))
  call TI_triangle_red(G2tensor(18),RedBasis(16),mass3set(:,10),G0tensor(132),G0tensor(43),G0tensor(150), &
    G0tensor(135),M2L1R1,[nMB,nMH],G0tensor(48),G0tensor(182))
  call TI_triangle_red(G2tensor(2),RedBasis(17),mass3set(:,12),G0tensor(137),G0tensor(53),G0tensor(142), &
    G0tensor(59),M2L1R1,[nMB,nMZ],G0tensor(54),G0tensor(187))
  call TI_triangle_red(G2tensor(6),RedBasis(16),mass3set(:,12),G0tensor(147),G0tensor(58),G0tensor(67), &
    G0tensor(62),M2L1R1,[nMB,nMZ],G0tensor(152),G0tensor(63))
  call TI_triangle_red(G2tensor(5),RedBasis(17),mass3set(:,2),G0tensor(157),G0tensor(64),G0tensor(155), &
    G0tensor(68),M2L1R1,[nMT,nMW],G0tensor(160),G0tensor(69))
  call TI_triangle_red(G2tensor(8),RedBasis(16),mass3set(:,2),G0tensor(103),G0tensor(78),G0tensor(73), &
    G0tensor(124),M2L1R1,[nMT,nMW],G0tensor(83),G0tensor(74))
  call TI_triangle_red(G2tensor(71),RedBasis(17),mass3set(:,14),G0tensor(254),G0tensor(129),G0tensor(109), &
    G0tensor(84),M2L1R1,[nMB],G0tensor(79))
  call TI_triangle_red(G2tensor(74),RedBasis(16),mass3set(:,14),G0tensor(113),G0tensor(93),G0tensor(88), &
    G0tensor(139),M2L1R1,[nMB],G0tensor(98))
  call TI_triangle_red(G2tensor(12),RedBasis(18),mass3set(:,10),G0tensor(89),G0tensor(244),G0tensor(169), &
    G0tensor(144),M2L1R1,[nMB,nMH],G0tensor(119),G0tensor(99))
  call TI_triangle_red(G2tensor(11),RedBasis(3),mass3set(:,10),G0tensor(94),G0tensor(134),G0tensor(108), &
    G0tensor(104),M2L1R1,[nMB,nMH],G0tensor(149),G0tensor(118))
  call TI_triangle_red(G2tensor(26),RedBasis(18),mass3set(:,12),G0tensor(114),G0tensor(133),G0tensor(128), &
    G0tensor(123),M2L1R1,[nMB,nMZ],G0tensor(148),G0tensor(143))
  call TI_triangle_red(G2tensor(1),RedBasis(18),mass3set(:,2),G0tensor(138),G0tensor(158),G0tensor(153), &
    G0tensor(163),M2L1R1,[nMT,nMW],G0tensor(154),G0tensor(249))
  call TI_triangle_red(G2tensor(20),RedBasis(18),mass3set(:,14),G0tensor(164),G0tensor(159),G0tensor(168), &
    G0tensor(178),M2L1R1,[nMB],G0tensor(173))
  call TI_triangle_red(G2tensor(10),RedBasis(5),mass3set(:,18),G0tensor(194),G0tensor(174),G0tensor(185), &
    G0tensor(175),M2L1R1,[nMB,nMZ,nMH],G0tensor(204),G0tensor(179),G0tensor(190))
  call TI_triangle_red(G2tensor(33),RedBasis(25),mass3set(:,18),G0tensor(180),G0tensor(188),G0tensor(183), &
    G0tensor(199),M2L1R1,[nMB,nMZ,nMH],G0tensor(184),G0tensor(209),G0tensor(189))
  call TI_triangle_red(G2tensor(34),RedBasis(25),mass3set(:,16),G0tensor(203),G0tensor(193),G0tensor(200), &
    G0tensor(195),M2L1R1,[nMB,nMH,nMZ],G0tensor(208),G0tensor(198),G0tensor(210))
  call TI_triangle_red(G2tensor(80),RedBasis(21),mass3set(:,19),G0tensor(205),G0tensor(212),G0tensor(213), &
    G0tensor(214),M2L1R1,[nMZ],G0tensor(215))
  call TI_triangle_red(G2tensor(83),RedBasis(21),mass3set(:,20),G0tensor(218),G0tensor(219),G0tensor(223), &
    G0tensor(224),M2L1R1,[nMW],G0tensor(228))
  call TI_triangle_red(G1tensor(6),RedBasis(29),mass3set(:,21),G0tensor(229),G0tensor(233),G0tensor(234), &
    G0tensor(238),M2L1R1,[nMB],G0tensor(259))
  call TI_triangle_red(G1tensor(77),RedBasis(20),mass3set(:,21),G0tensor(239),G0tensor(243),G0tensor(248), &
    G0tensor(253),M2L1R1,[nMB],G0tensor(258))
  call TI_triangle_red(G1tensor(82),RedBasis(19),mass3set(:,21),G0tensor(261),G0tensor(262),G0tensor(263), &
    G0tensor(264),M2L1R1,[nMB],G0tensor(265))
  call TI_triangle_red(G1tensor(90),RedBasis(4),mass3set(:,22),G0tensor(266),G0tensor(267),G0tensor(268), &
    G0tensor(269),M2L1R1,[nMB],G0tensor(270))
  call TI_triangle_red(G1tensor(95),RedBasis(2),mass3set(:,14),G0tensor(271),G0tensor(272),G0tensor(273), &
    G0tensor(274),M2L1R1,[nMB],G0tensor(275))
  call TI_triangle_red(G1tensor(197),RedBasis(21),mass3set(:,23),G0tensor(276),G0tensor(277),G0tensor(278), &
    G0tensor(279),M2L1R1,[nMZ],G0tensor(280))
  call TI_triangle_red(G1tensor(92),RedBasis(20),mass3set(:,24),G0tensor(281),G0tensor(282),G0tensor(283), &
    G0tensor(284),M2L1R1,[nMZ,nMB],G0tensor(285),G0tensor(286))
  call TI_triangle_red(G1tensor(97),RedBasis(19),mass3set(:,24),G0tensor(287),G0tensor(288),G0tensor(289), &
    G0tensor(290),M2L1R1,[nMZ,nMB],G0tensor(291),G0tensor(292))
  call TI_triangle_red(G1tensor(54),RedBasis(29),mass3set(:,25),G0tensor(293),G0tensor(294),G0tensor(295), &
    G0tensor(296),M2L1R1,[nMB,nMZ],G0tensor(297),G0tensor(298))
  call TI_triangle_red(G1tensor(202),RedBasis(21),mass3set(:,26),G0tensor(299),G0tensor(300),G0tensor(301), &
    G0tensor(302),M2L1R1,[nMZ],G0tensor(303))
  call TI_triangle_red(G1tensor(107),RedBasis(19),mass3set(:,25),G0tensor(304),G0tensor(305),G0tensor(306), &
    G0tensor(307),M2L1R1,[nMB,nMZ],G0tensor(308),G0tensor(309))
  call TI_triangle_red(G1tensor(115),RedBasis(4),mass3set(:,27),G0tensor(310),G0tensor(311),G0tensor(312), &
    G0tensor(313),M2L1R1,[nMB,nMZ],G0tensor(314),G0tensor(315))
  call TI_triangle_red(G1tensor(12),RedBasis(21),mass3set(:,28),G0tensor(316),G0tensor(317),G0tensor(318), &
    G0tensor(319),M2L1R1,[nMZ],G0tensor(320))
  call TI_triangle_red(G1tensor(117),RedBasis(19),mass3set(:,29),G0tensor(321),G0tensor(322),G0tensor(323), &
    G0tensor(324),M2L1R1,[nMZ,nMB],G0tensor(325),G0tensor(326))
  call TI_triangle_red(G1tensor(51),RedBasis(30),mass3set(:,21),G0tensor(327),G0tensor(328),G0tensor(329), &
    G0tensor(330),M2L1R1,[nMB],G0tensor(331))
  call TI_triangle_red(G1tensor(172),RedBasis(23),mass3set(:,13),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335),M2L1R1)
  call TI_triangle_red(G1tensor(127),RedBasis(22),mass3set(:,21),G0tensor(336),G0tensor(337),G0tensor(338), &
    G0tensor(339),M2L1R1,[nMB],G0tensor(340))
  call TI_triangle_red(G1tensor(140),RedBasis(8),mass3set(:,22),G0tensor(341),G0tensor(342),G0tensor(343), &
    G0tensor(344),M2L1R1,[nMB],G0tensor(345))
  call TI_triangle_red(G1tensor(145),RedBasis(7),mass3set(:,14),G0tensor(346),G0tensor(347),G0tensor(348), &
    G0tensor(349),M2L1R1,[nMB],G0tensor(350))
  call TI_triangle_red(G1tensor(57),RedBasis(30),mass3set(:,25),G0tensor(351),G0tensor(352),G0tensor(353), &
    G0tensor(354),M2L1R1,[nMB,nMZ],G0tensor(355),G0tensor(356))
  call TI_triangle_red(G1tensor(177),RedBasis(23),mass3set(:,26),G0tensor(357),G0tensor(358),G0tensor(359), &
    G0tensor(360),M2L1R1,[nMZ],G0tensor(361))
  call TI_triangle_red(G1tensor(150),RedBasis(8),mass3set(:,27),G0tensor(362),G0tensor(363),G0tensor(364), &
    G0tensor(365),M2L1R1,[nMB,nMZ],G0tensor(366),G0tensor(367))
  call TI_triangle_red(G1tensor(182),RedBasis(23),mass3set(:,23),G0tensor(368),G0tensor(369),G0tensor(370), &
    G0tensor(371),M2L1R1,[nMZ],G0tensor(372))
  call TI_triangle_red(G1tensor(142),RedBasis(22),mass3set(:,24),G0tensor(373),G0tensor(374),G0tensor(375), &
    G0tensor(376),M2L1R1,[nMZ,nMB],G0tensor(377),G0tensor(378))
  call TI_triangle_red(G1tensor(187),RedBasis(23),mass3set(:,28),G0tensor(379),G0tensor(380),G0tensor(381), &
    G0tensor(382),M2L1R1,[nMZ],G0tensor(383))
  call TI_triangle_red(G1tensor(67),RedBasis(30),mass3set(:,30),G0tensor(384),G0tensor(385),G0tensor(386), &
    G0tensor(387),M2L1R1,[nMT,nMW],G0tensor(388),G0tensor(389))
  call TI_triangle_red(G1tensor(152),RedBasis(23),mass3set(:,17),G0tensor(390),G0tensor(391),G0tensor(392), &
    G0tensor(393),M2L1R1,[nMW],G0tensor(394))
  call TI_triangle_red(G1tensor(157),RedBasis(22),mass3set(:,31),G0tensor(395),G0tensor(396),G0tensor(397), &
    G0tensor(398),M2L1R1,[nMW,nMT],G0tensor(399),G0tensor(400))
  call TI_triangle_red(G1tensor(155),RedBasis(8),mass3set(:,32),G0tensor(401),G0tensor(402),G0tensor(403), &
    G0tensor(404),M2L1R1,[nMT,nMW],G0tensor(405),G0tensor(406))
  call TI_triangle_red(G1tensor(160),RedBasis(7),mass3set(:,33),G0tensor(407),G0tensor(408),G0tensor(409), &
    G0tensor(410),M2L1R1,[nMT],G0tensor(411))
  call TI_triangle_red(G1tensor(103),RedBasis(6),mass3set(:,22),G0tensor(412),G0tensor(413),G0tensor(414), &
    G0tensor(415),M2L1R1,[nMB],G0tensor(416))
  call TI_triangle_red(G1tensor(124),RedBasis(5),mass3set(:,22),G0tensor(417),G0tensor(418),G0tensor(419), &
    G0tensor(420),M2L1R1,[nMB],G0tensor(421))
  call TI_triangle_red(G1tensor(113),RedBasis(6),mass3set(:,34),G0tensor(422),G0tensor(423),G0tensor(424), &
    G0tensor(425),M2L1R1,[nMB,nMZ],G0tensor(426),G0tensor(427))
  call TI_triangle_red(G1tensor(139),RedBasis(5),mass3set(:,34),G0tensor(428),G0tensor(429),G0tensor(430), &
    G0tensor(431),M2L1R1,[nMB,nMZ],G0tensor(432),G0tensor(433))
  call TI_triangle_red(G1tensor(134),RedBasis(5),mass3set(:,27),G0tensor(434),G0tensor(435),G0tensor(436), &
    G0tensor(437),M2L1R1,[nMB,nMZ],G0tensor(438),G0tensor(439))
  call TI_triangle_red(G1tensor(149),RedBasis(5),mass3set(:,35),G0tensor(440),G0tensor(441),G0tensor(442), &
    G0tensor(443),M2L1R1,[nMB,nMZ],G0tensor(444),G0tensor(445))
  call TI_triangle_red(G1tensor(133),RedBasis(9),mass3set(:,22),G0tensor(446),G0tensor(447),G0tensor(448), &
    G0tensor(449),M2L1R1,[nMB],G0tensor(450))
  call TI_triangle_red(G1tensor(148),RedBasis(9),mass3set(:,34),G0tensor(451),G0tensor(452),G0tensor(453), &
    G0tensor(454),M2L1R1,[nMB,nMZ],G0tensor(455),G0tensor(456))
  call TI_triangle_red(G1tensor(158),RedBasis(9),mass3set(:,36),G0tensor(457),G0tensor(458),G0tensor(459), &
    G0tensor(460),M2L1R1,[nMT,nMW],G0tensor(461),G0tensor(462))
  call TI_triangle_red(G1tensor(178),RedBasis(26),mass3set(:,22),G0tensor(463),G0tensor(464),G0tensor(465), &
    G0tensor(466),M2L1R1,[nMB],G0tensor(467))
  call TI_triangle_red(G1tensor(194),RedBasis(25),mass3set(:,22),G0tensor(468),G0tensor(469),G0tensor(470), &
    G0tensor(471),M2L1R1,[nMB],G0tensor(472))
  call TI_triangle_red(G1tensor(185),RedBasis(24),mass3set(:,22),G0tensor(473),G0tensor(474),G0tensor(475), &
    G0tensor(476),M2L1R1,[nMB],G0tensor(477))
  call TI_triangle_red(G1tensor(204),RedBasis(25),mass3set(:,27),G0tensor(478),G0tensor(479),G0tensor(480), &
    G0tensor(481),M2L1R1,[nMB,nMZ],G0tensor(482),G0tensor(483))
  call TI_triangle_red(G1tensor(190),RedBasis(24),mass3set(:,27),G0tensor(484),G0tensor(485),G0tensor(486), &
    G0tensor(487),M2L1R1,[nMB,nMZ],G0tensor(488),G0tensor(489))
  call TI_triangle_red(G1tensor(188),RedBasis(26),mass3set(:,34),G0tensor(490),G0tensor(491),G0tensor(492), &
    G0tensor(493),M2L1R1,[nMB,nMZ],G0tensor(494),G0tensor(495))
  call TI_triangle_red(G1tensor(199),RedBasis(25),mass3set(:,34),G0tensor(496),G0tensor(497),G0tensor(498), &
    G0tensor(499),M2L1R1,[nMB,nMZ],G0tensor(500),G0tensor(501))
  call TI_triangle_red(G1tensor(209),RedBasis(25),mass3set(:,35),G0tensor(502),G0tensor(503),G0tensor(504), &
    G0tensor(505),M2L1R1,[nMB,nMZ],G0tensor(506),G0tensor(507))
  call TI_triangle_red(G1tensor(203),RedBasis(28),mass3set(:,22),G0tensor(508),G0tensor(509),G0tensor(510), &
    G0tensor(511),M2L1R1,[nMB],G0tensor(512))
  call TI_triangle_red(G1tensor(200),RedBasis(27),mass3set(:,22),G0tensor(513),G0tensor(514),G0tensor(515), &
    G0tensor(516),M2L1R1,[nMB],G0tensor(517))
  call TI_triangle_red(G1tensor(208),RedBasis(28),mass3set(:,34),G0tensor(518),G0tensor(519),G0tensor(520), &
    G0tensor(521),M2L1R1,[nMB,nMZ],G0tensor(522),G0tensor(523))
  call TI_triangle_red(G1tensor(210),RedBasis(27),mass3set(:,27),G0tensor(524),G0tensor(525),G0tensor(526), &
    G0tensor(527),M2L1R1,[nMB,nMZ],G0tensor(528),G0tensor(529))
  call TI_triangle_red(G1tensor(213),RedBasis(28),mass3set(:,36),G0tensor(530),G0tensor(531),G0tensor(532), &
    G0tensor(533),M2L1R1,[nMT,nMW],G0tensor(534),G0tensor(535))
  call TI_triangle_red(G1tensor(215),RedBasis(27),mass3set(:,32),G0tensor(536),G0tensor(537),G0tensor(538), &
    G0tensor(539),M2L1R1,[nMT,nMW],G0tensor(540),G0tensor(541))
  call ol_merge_tensors(T0sum(53),[G0tensor(1)])
  call ol_merge_tensors(T0sum(54),[G0tensor(31)])
  call ol_merge_tensors(T0sum(55),[G0tensor(61)])
  call ol_merge_tensors(T0sum(56),[G0tensor(91)])
  call ol_merge_tensors(T0sum(57),[G0tensor(116)])
  call ol_merge_tensors(T0sum(58),[G0tensor(146)])
  call ol_merge_tensors(T0sum(59),[G0tensor(176)])
  call ol_merge_tensors(T0sum(60),[G0tensor(201)])
  call ol_merge_tensors(T0sum(61),[G0tensor(226)])
  call ol_merge_tensors(T0sum(62),[G0tensor(256)])
  call ol_merge_tensors(T0sum(63),[G0tensor(255)])
  call ol_merge_tensors(T0sum(64),[G0tensor(222)])
  call ol_merge_tensors(T0sum(65),[G0tensor(237)])
  call ol_merge_tensors(T0sum(66),[G0tensor(260)])
  call ol_merge_tensors(T0sum(67),[G0tensor(7)])
  call ol_merge_tensors(T0sum(68),[G0tensor(4)])
  call ol_merge_tensors(T0sum(69),[G0tensor(229)])
  call ol_merge_tensors(T0sum(70),[G0tensor(8)])
  call ol_merge_tensors(T0sum(71),[G0tensor(239)])
  call ol_merge_tensors(T0sum(72),[G0tensor(261)])
  call ol_merge_tensors(T0sum(73),[G0tensor(266)])
  call ol_merge_tensors(T0sum(74),[G0tensor(271)])
  call ol_merge_tensors(T0sum(75),[G0tensor(9)])
  call ol_merge_tensors(T0sum(76),[G0tensor(276)])
  call ol_merge_tensors(T0sum(77),[G0tensor(281)])
  call ol_merge_tensors(T0sum(78),[G0tensor(287)])
  call ol_merge_tensors(T0sum(79),[G0tensor(293)])
  call ol_merge_tensors(T0sum(80),[G0tensor(299)])
  call ol_merge_tensors(T0sum(81),[G0tensor(304)])
  call ol_merge_tensors(T0sum(82),[G0tensor(310)])
  call ol_merge_tensors(T0sum(83),[G0tensor(316)])
  call ol_merge_tensors(T0sum(84),[G0tensor(321)])
  call ol_merge_tensors(T0sum(85),[G0tensor(327)])
  call ol_merge_tensors(T0sum(86),[G0tensor(332)])
  call ol_merge_tensors(T0sum(87),[G0tensor(336)])
  call ol_merge_tensors(T0sum(88),[G0tensor(341)])
  call ol_merge_tensors(T0sum(89),[G0tensor(346)])
  call ol_merge_tensors(T0sum(90),[G0tensor(351)])
  call ol_merge_tensors(T0sum(91),[G0tensor(357)])
  call ol_merge_tensors(T0sum(92),[G0tensor(362)])
  call ol_merge_tensors(T0sum(93),[G0tensor(368)])
  call ol_merge_tensors(T0sum(94),[G0tensor(373)])
  call ol_merge_tensors(T0sum(95),[G0tensor(379)])
  call ol_merge_tensors(T0sum(96),[G0tensor(384)])
  call ol_merge_tensors(T0sum(97),[G0tensor(390)])
  call ol_merge_tensors(T0sum(98),[G0tensor(395)])
  call ol_merge_tensors(T0sum(99),[G0tensor(401)])
  call ol_merge_tensors(T0sum(100),[G0tensor(407)])
  call ol_merge_tensors(T0sum(101),[G0tensor(412)])
  call ol_merge_tensors(T0sum(102),[G0tensor(417)])
  call ol_merge_tensors(T0sum(103),[G0tensor(197)])
  call ol_merge_tensors(T0sum(104),[G0tensor(422)])
  call ol_merge_tensors(T0sum(105),[G0tensor(428)])
  call ol_merge_tensors(T0sum(106),[G0tensor(14)])
  call ol_merge_tensors(T0sum(107),[G0tensor(434)])
  call ol_merge_tensors(T0sum(108),[G0tensor(440)])
  call ol_merge_tensors(T0sum(109),[G0tensor(446)])
  call ol_merge_tensors(T0sum(110),[G0tensor(451)])
  call ol_merge_tensors(T0sum(111),[G0tensor(457)])
  call ol_merge_tensors(T0sum(112),[G0tensor(17)])
  call ol_merge_tensors(T0sum(113),[G0tensor(20)])
  call ol_merge_tensors(T0sum(114),[G0tensor(28)])
  call ol_merge_tensors(T0sum(115),[G0tensor(463)])
  call ol_merge_tensors(T0sum(116),[G0tensor(468)])
  call ol_merge_tensors(T0sum(117),[G0tensor(473)])
  call ol_merge_tensors(T0sum(118),[G0tensor(478)])
  call ol_merge_tensors(T0sum(119),[G0tensor(484)])
  call ol_merge_tensors(T0sum(120),[G0tensor(490)])
  call ol_merge_tensors(T0sum(121),[G0tensor(496)])
  call ol_merge_tensors(T0sum(122),[G0tensor(502)])
  call ol_merge_tensors(T0sum(123),[G0tensor(508)])
  call ol_merge_tensors(T0sum(124),[G0tensor(513)])
  call ol_merge_tensors(T0sum(125),[G0tensor(518)])
  call ol_merge_tensors(T0sum(126),[G0tensor(524)])
  call ol_merge_tensors(T0sum(127),[G0tensor(172)])
  call ol_merge_tensors(T0sum(128),[G0tensor(530)])
  call ol_merge_tensors(T0sum(129),[G0tensor(34)])
  call ol_merge_tensors(T0sum(130),[G0tensor(536)])
  call ol_merge_tensors(T0sum(131),[G0tensor(49)])
  call ol_merge_tensors(T0sum(132),[G0tensor(132)])
  call ol_merge_tensors(T0sum(133),[G0tensor(137)])
  call ol_merge_tensors(T0sum(134),[G0tensor(147)])
  call ol_merge_tensors(T0sum(135),[G0tensor(157)])
  call ol_merge_tensors(T0sum(136),[G0tensor(103)])
  call ol_merge_tensors(T0sum(137),[G0tensor(254)])
  call ol_merge_tensors(T0sum(138),[G0tensor(113)])
  call ol_merge_tensors(T0sum(139),[G0tensor(89)])
  call ol_merge_tensors(T0sum(140),[G0tensor(94)])
  call ol_merge_tensors(T0sum(141),[G0tensor(114)])
  call ol_merge_tensors(T0sum(142),[G0tensor(138)])
  call ol_merge_tensors(T0sum(143),[G0tensor(164)])
  call ol_merge_tensors(T0sum(144),[G0tensor(194)])
  call ol_merge_tensors(T0sum(145),[G0tensor(180)])
  call ol_merge_tensors(T0sum(146),[G0tensor(203)])
  call ol_merge_tensors(T0sum(147),[G0tensor(205)])
  call ol_merge_tensors(T0sum(148),[G0tensor(218)])
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[20,11],[nMH,nMB],2,2,wf4(:,3),wf8(:,16))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(7),ngH,m3h4x8(:,67),heltab2x32(:,:,154))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[20,11],[nMZ,nMB],2,2,wf4(:,3),wf8(:,16))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(8),ngX,m3h4x8(:,68),heltab2x32(:,:,155))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[20,11],[nMW,nMT],2,2,wf4(:,3),wf8(:,16))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(9),ngPtb,m3h4x8(:,69),heltab2x32(:,:,156))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[20,11],[nMH,nMB],2,2,wf4(:,3),wf8(:,17))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(10),ngH,m3h4x8(:,70),heltab2x32(:,:,157))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[20,11],[nMZ,nMB],2,2,wf4(:,3),wf8(:,17))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(17),ngX,m3h4x8(:,71),heltab2x32(:,:,158))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[20,11],[nMW,nMT],2,2,wf4(:,3),wf8(:,17))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(18),ngPtb,m3h4x8(:,72),heltab2x32(:,:,159))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[20,11],[0,nMB],2,2,wf4(:,3),wf8(:,16))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,73),heltab2x32(:,:,160))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[20,11],[nMZ,nMB],2,2,wf4(:,3),wf8(:,16))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(2),ngZd,m3h4x8(:,74),heltab2x32(:,:,161))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[20,11],[nMW,nMT],2,2,wf4(:,3),wf8(:,16))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,75),heltab2x32(:,:,162))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[20,11],[0,nMB],2,2,wf4(:,3),wf8(:,17))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,76),heltab2x32(:,:,163))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[20,11],[nMZ,nMB],2,2,wf4(:,3),wf8(:,17))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(5),ngZd,m3h4x8(:,77),heltab2x32(:,:,164))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[20,11],[nMW,nMT],2,2,wf4(:,3),wf8(:,17))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,78),heltab2x32(:,:,165))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[28,3],[nMM,nMM],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(5),ngH,m3h8x4(:,19),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G0H4(5),28,nMM,G1H4(15),n2h4(62))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[28,3],[nML,nML],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(1),ngH,m3h8x4(:,20),heltab2x32(:,:,167))
  call Hloop_Q_A(ntryL,G0H4(1),28,nML,G1H4(16),n2h4(63))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[28,3],[nMT,nMT],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(4),ngH,m3h8x4(:,21),heltab2x32(:,:,168))
  call Hloop_Q_A(ntryL,G0H4(4),28,nMT,G1H4(17),n2h4(64))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[28,3],[nMB,nMB],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(2),ngH,m3h8x4(:,22),heltab2x32(:,:,169))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMB,G1H4(18),n2h4(65))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[28,3],[nMM,nMM],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(3),ngX,m3h8x4(:,23),heltab2x32(:,:,170))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMM,G1H4(13),n2h4(66))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[28,3],[nML,nML],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(5),ngX,m3h8x4(:,24),heltab2x32(:,:,171))
  call Hloop_Q_A(ntryL,G0H4(5),28,nML,G1H4(7),n2h4(67))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[28,3],[nMT,nMT],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(1),ngX,m3h8x4(:,25),heltab2x32(:,:,172))
  call Hloop_Q_A(ntryL,G0H4(1),28,nMT,G1H4(6),n2h4(68))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[28,3],[nMB,nMB],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(4),ngX,m3h8x4(:,26),heltab2x32(:,:,173))
  call Hloop_Q_A(ntryL,G0H4(4),28,nMB,G1H4(8),n2h4(69))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[28,3],[nMM,nMM],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(2),ngH,m3h8x4(:,27),heltab2x32(:,:,174))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMM,G1H4(3),n2h4(70))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[28,3],[nML,nML],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(3),ngH,m3h8x4(:,28),heltab2x32(:,:,175))
  call Hloop_Q_A(ntryL,G0H4(3),28,nML,G1H4(1),n2h4(71))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[28,3],[nMT,nMT],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(5),ngH,m3h8x4(:,29),heltab2x32(:,:,176))
  call Hloop_Q_A(ntryL,G0H4(5),28,nMT,G1H4(9),n2h4(72))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[28,3],[nMB,nMB],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(1),ngH,m3h8x4(:,30),heltab2x32(:,:,177))
  call Hloop_Q_A(ntryL,G0H4(1),28,nMB,G1H4(4),n2h4(73))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[28,3],[nMM,nMM],2,2,wf8(:,13),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(4),ngX,m3h8x4(:,31),heltab2x32(:,:,178))
  call Hloop_Q_A(ntryL,G0H4(4),28,nMM,G1H4(2),n2h4(74))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[28,3],[nML,nML],2,2,wf8(:,13),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(2),ngX,m3h8x4(:,32),heltab2x32(:,:,179))
  call Hloop_Q_A(ntryL,G0H4(2),28,nML,G1H4(5),n2h4(75))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[28,3],[nMT,nMT],2,2,wf8(:,13),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(3),ngX,m3h8x4(:,33),heltab2x32(:,:,180))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMT,G1H4(14),n2h4(76))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[28,3],[nMB,nMB],2,2,wf8(:,13),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(5),ngX,m3h8x4(:,34),heltab2x32(:,:,181))
  call Hloop_Q_A(ntryL,G0H4(5),28,nMB,G1H4(10),n2h4(77))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(1),m3h8x4(:,35),heltab2x32(:,:,182))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(4),m3h8x4(:,36),heltab2x32(:,:,183))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[28,3],[nMH,nMZ],2,2,wf8(:,13),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(2),m3h8x4(:,37),heltab2x32(:,:,184))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(3),m3h8x4(:,38),heltab2x32(:,:,185))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(5),m3h8x4(:,39),heltab2x32(:,:,186))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(6),m3h8x4(:,40),heltab2x32(:,:,187))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(7),m3h8x4(:,41),heltab2x32(:,:,188))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(8),m3h8x4(:,42),heltab2x32(:,:,189))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(9),m3h8x4(:,43),heltab2x32(:,:,190))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(10),m3h8x4(:,44),heltab2x32(:,:,191))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(11),m3h8x4(:,45),heltab2x32(:,:,192))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,23),G0H4(12),m3h8x4(:,46),heltab2x32(:,:,193))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,23),G0H4(13),m3h8x4(:,47),heltab2x32(:,:,194))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(11),m3h8x4(:,48),heltab2x32(:,:,195))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(12),m3h8x4(:,49),heltab2x32(:,:,196))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(19),m3h8x4(:,50),heltab2x32(:,:,197))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(20),m3h8x4(:,51),heltab2x32(:,:,198))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(21),m3h8x4(:,52),heltab2x32(:,:,199))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(22),m3h8x4(:,53),heltab2x32(:,:,200))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[28,3],[nMH,nMZ],2,2,wf8(:,13),wf4(:,4))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(23),m3h8x4(:,54),heltab2x32(:,:,201))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(24),m3h8x4(:,55),heltab2x32(:,:,202))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(25),m3h8x4(:,56),heltab2x32(:,:,203))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[28,3],[0,0],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,57),heltab2x32(:,:,204))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(26),n2h4(78))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[28,3],[nMM,nMM],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,58),heltab2x32(:,:,205))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMM,G1H4(27),n2h4(79))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[28,3],[nML,nML],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,59),heltab2x32(:,:,206))
  call Hloop_Q_A(ntryL,G0H4(14),28,nML,G1H4(28),n2h4(80))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[28,3],[0,0],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,60),heltab2x32(:,:,207))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(29),n2h4(81))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[28,3],[nMT,nMT],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,61),heltab2x32(:,:,208))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMT,G1H4(30),n2h4(82))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[28,3],[0,0],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,62),heltab2x32(:,:,209))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(31),n2h4(83))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[28,3],[nMB,nMB],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,63),heltab2x32(:,:,210))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMB,G1H4(32),n2h4(84))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[28,3],[0,0],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZl,m3h8x4(:,64),heltab2x32(:,:,211))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(33),n2h4(85))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[28,3],[nMM,nMM],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZl,m3h8x4(:,65),heltab2x32(:,:,212))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMM,G1H4(34),n2h4(86))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[28,3],[nML,nML],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZl,m3h8x4(:,66),heltab2x32(:,:,213))
  call Hloop_Q_A(ntryL,G0H4(14),28,nML,G1H4(35),n2h4(87))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[28,3],[0,0],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZu,m3h8x4(:,67),heltab2x32(:,:,214))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(36),n2h4(88))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[28,3],[nMT,nMT],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZu,m3h8x4(:,68),heltab2x32(:,:,215))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMT,G1H4(37),n2h4(89))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[28,3],[0,0],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZd,m3h8x4(:,69),heltab2x32(:,:,216))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(38),n2h4(90))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[28,3],[nMB,nMB],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZd,m3h8x4(:,70),heltab2x32(:,:,217))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMB,G1H4(39),n2h4(91))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[28,3],[0,0],2,2,wf8(:,14),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,71),heltab2x32(:,:,218))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(40),n2h4(92))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[28,3],[nMM,nMM],2,2,wf8(:,14),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,72),heltab2x32(:,:,219))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMM,G1H4(41),n2h4(93))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[28,3],[nML,nML],2,2,wf8(:,14),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,73),heltab2x32(:,:,220))
  call Hloop_Q_A(ntryL,G0H4(14),28,nML,G1H4(42),n2h4(94))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[28,3],[0,0],2,2,wf8(:,14),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,74),heltab2x32(:,:,221))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(43),n2h4(95))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[28,3],[nMT,nMT],2,2,wf8(:,14),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,75),heltab2x32(:,:,222))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMT,G1H4(44),n2h4(96))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[28,3],[0,0],2,2,wf8(:,14),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,76),heltab2x32(:,:,223))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(45),n2h4(97))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[28,3],[nMB,nMB],2,2,wf8(:,14),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,77),heltab2x32(:,:,224))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMB,G1H4(46),n2h4(98))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[28,3],[0,0],2,2,wf8(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZn,m3h8x4(:,78),heltab2x32(:,:,225))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(47),n2h4(99))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[28,3],[0,0],2,2,wf8(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZl,m3h8x4(:,79),heltab2x32(:,:,226))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(48),n2h4(100))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[28,3],[nMM,nMM],2,2,wf8(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZl,m3h8x4(:,80),heltab2x32(:,:,227))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMM,G1H4(49),n2h4(101))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[28,3],[nML,nML],2,2,wf8(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZl,m3h8x4(:,81),heltab2x32(:,:,228))
  call Hloop_Q_A(ntryL,G0H4(14),28,nML,G1H4(50),n2h4(102))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[28,3],[0,0],2,2,wf8(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZu,m3h8x4(:,82),heltab2x32(:,:,229))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(51),n2h4(103))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[28,3],[nMT,nMT],2,2,wf8(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZu,m3h8x4(:,83),heltab2x32(:,:,230))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMT,G1H4(52),n2h4(104))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[28,3],[0,0],2,2,wf8(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZd,m3h8x4(:,84),heltab2x32(:,:,231))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(53),n2h4(105))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[28,3],[nMB,nMB],2,2,wf8(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,15),G0H4(14),ngZd,m3h8x4(:,85),heltab2x32(:,:,232))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMB,G1H4(54),n2h4(106))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(55),m3h8x4(:,86),heltab2x32(:,:,233))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(56),m3h8x4(:,87),heltab2x32(:,:,234))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(57),m3h8x4(:,88),heltab2x32(:,:,235))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[28,3],[nMH,nMZ],2,2,wf8(:,15),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(58),m3h8x4(:,89),heltab2x32(:,:,236))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(59),m3h8x4(:,90),heltab2x32(:,:,237))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(60),m3h8x4(:,91),heltab2x32(:,:,238))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(61),m3h8x4(:,92),heltab2x32(:,:,239))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(62),m3h8x4(:,93),heltab2x32(:,:,240))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(63),m3h8x4(:,94),heltab2x32(:,:,241))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(64),m3h8x4(:,95),heltab2x32(:,:,242))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(65),m3h8x4(:,96),heltab2x32(:,:,243))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(66),m3h8x4(:,97),heltab2x32(:,:,244))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(67),m3h8x4(:,98),heltab2x32(:,:,245))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(68),m3h8x4(:,99),heltab2x32(:,:,246))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(69),m3h8x4(:,100),heltab2x32(:,:,247))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(70),m3h8x4(:,101),heltab2x32(:,:,248))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(71),m3h8x4(:,102),heltab2x32(:,:,249))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,14),G0H4(14),m3h8x4(:,103),heltab2x32(:,:,250))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,14),G0H4(15),m3h8x4(:,104),heltab2x32(:,:,251))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,15),G0H4(16),m3h8x4(:,105),heltab2x32(:,:,252))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,15),G0H4(17),m3h8x4(:,106),heltab2x32(:,:,253))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,14),G0H4(18),m3h8x4(:,107),heltab2x32(:,:,254))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,14),G0H4(19),m3h8x4(:,108),heltab2x32(:,:,255))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[28,3],[nMH,nMZ],2,2,wf8(:,15),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,15),G0H4(20),m3h8x4(:,109),heltab2x32(:,:,256))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,15),G0H4(21),m3h8x4(:,110),heltab2x32(:,:,257))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,15),G0H4(22),m3h8x4(:,111),heltab2x32(:,:,258))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[24,7],[nMB,nMH],2,2,wf4(:,6),wf8(:,21))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(11),ngH,m3h4x8(:,79),heltab2x32(:,:,259))
  call Hloop_A_Q(ntryL,G0H8(11),24,nMB,G1H8(13),n2h8(25))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[24,7],[nMB,nMZ],2,2,wf4(:,6),wf8(:,21))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(12),ngX,m3h4x8(:,80),heltab2x32(:,:,260))
  call Hloop_A_Q(ntryL,G0H8(12),24,nMB,G1H8(14),n2h8(26))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[24,7],[nMT,nMW],2,2,wf4(:,6),wf8(:,21))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),ngPbt,m3h4x8(:,81),heltab2x32(:,:,261))
  call Hloop_A_Q(ntryL,G0H8(13),24,nMT,G1H8(15),n2h8(27))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[24,7],[nMB,nMH],2,2,wf4(:,6),wf8(:,22))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(14),ngH,m3h4x8(:,82),heltab2x32(:,:,262))
  call Hloop_A_Q(ntryL,G0H8(14),24,nMB,G1H8(16),n2h8(28))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[24,7],[nMB,nMZ],2,2,wf4(:,6),wf8(:,22))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),ngX,m3h4x8(:,83),heltab2x32(:,:,263))
  call Hloop_A_Q(ntryL,G0H8(15),24,nMB,G1H8(17),n2h8(29))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[24,7],[nMT,nMW],2,2,wf4(:,6),wf8(:,22))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(16),ngPbt,m3h4x8(:,84),heltab2x32(:,:,264))
  call Hloop_A_Q(ntryL,G0H8(16),24,nMT,G1H8(18),n2h8(30))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[24,7],[nMB,0],2,2,wf4(:,6),wf8(:,21))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(19),m3h4x8(:,85),heltab2x32(:,:,265))
  call Hloop_A_Q(ntryL,G0H8(19),24,nMB,G1H8(19),n2h8(31))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[24,7],[nMB,nMZ],2,2,wf4(:,6),wf8(:,21))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(20),ngZd,m3h4x8(:,86),heltab2x32(:,:,266))
  call Hloop_A_Q(ntryL,G0H8(20),24,nMB,G1H8(20),n2h8(32))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[24,7],[nMT,nMW],2,2,wf4(:,6),wf8(:,21))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(21),m3h4x8(:,87),heltab2x32(:,:,267))
  call Hloop_A_Q(ntryL,G0H8(21),24,nMT,G1H8(21),n2h8(33))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[24,7],[nMB,0],2,2,wf4(:,6),wf8(:,22))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(22),m3h4x8(:,88),heltab2x32(:,:,268))
  call Hloop_A_Q(ntryL,G0H8(22),24,nMB,G1H8(22),n2h8(34))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[24,7],[nMB,nMZ],2,2,wf4(:,6),wf8(:,22))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(23),ngZd,m3h4x8(:,89),heltab2x32(:,:,269))
  call Hloop_A_Q(ntryL,G0H8(23),24,nMB,G1H8(23),n2h8(35))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[24,7],[nMT,nMW],2,2,wf4(:,6),wf8(:,22))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(24),m3h4x8(:,90),heltab2x32(:,:,270))
  call Hloop_A_Q(ntryL,G0H8(24),24,nMT,G1H8(24),n2h8(36))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[28,3],[nMM,nMM],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,24),G0H4(23),ngH,m3h8x4(:,112),heltab2x32(:,:,271))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMM,G1H4(72),n2h4(107))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[28,3],[nML,nML],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,24),G0H4(23),ngH,m3h8x4(:,113),heltab2x32(:,:,272))
  call Hloop_Q_A(ntryL,G0H4(23),28,nML,G1H4(73),n2h4(108))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[28,3],[nMT,nMT],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,24),G0H4(23),ngH,m3h8x4(:,114),heltab2x32(:,:,273))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMT,G1H4(74),n2h4(109))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[28,3],[nMB,nMB],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,24),G0H4(23),ngH,m3h8x4(:,115),heltab2x32(:,:,274))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMB,G1H4(75),n2h4(110))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[28,3],[nMM,nMM],2,2,wf8(:,18),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(23),ngX,m3h8x4(:,116),heltab2x32(:,:,275))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMM,G1H4(76),n2h4(111))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[28,3],[nML,nML],2,2,wf8(:,18),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(23),ngX,m3h8x4(:,117),heltab2x32(:,:,276))
  call Hloop_Q_A(ntryL,G0H4(23),28,nML,G1H4(77),n2h4(112))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[28,3],[nMT,nMT],2,2,wf8(:,18),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(23),ngX,m3h8x4(:,118),heltab2x32(:,:,277))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMT,G1H4(78),n2h4(113))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[28,3],[nMB,nMB],2,2,wf8(:,18),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(23),ngX,m3h8x4(:,119),heltab2x32(:,:,278))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMB,G1H4(79),n2h4(114))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[28,3],[nMM,nMM],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,24),G0H4(23),ngH,m3h8x4(:,120),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMM,G1H4(80),n2h4(115))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[28,3],[nML,nML],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,24),G0H4(23),ngH,m3h8x4(:,121),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H4(23),28,nML,G1H4(81),n2h4(116))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[28,3],[nMT,nMT],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,24),G0H4(23),ngH,m3h8x4(:,122),heltab2x32(:,:,281))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMT,G1H4(82),n2h4(117))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[28,3],[nMB,nMB],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,24),G0H4(23),ngH,m3h8x4(:,123),heltab2x32(:,:,282))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMB,G1H4(83),n2h4(118))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[28,3],[nMM,nMM],2,2,wf8(:,18),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(23),ngX,m3h8x4(:,124),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMM,G1H4(84),n2h4(119))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[28,3],[nML,nML],2,2,wf8(:,18),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(23),ngX,m3h8x4(:,125),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G0H4(23),28,nML,G1H4(85),n2h4(120))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[28,3],[nMT,nMT],2,2,wf8(:,18),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(23),ngX,m3h8x4(:,126),heltab2x32(:,:,285))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMT,G1H4(86),n2h4(121))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[28,3],[nMB,nMB],2,2,wf8(:,18),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(23),ngX,m3h8x4(:,127),heltab2x32(:,:,286))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMB,G1H4(87),n2h4(122))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,24),G0H4(23),m3h8x4(:,128),heltab2x32(:,:,287))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,24),G0H4(24),m3h8x4(:,129),heltab2x32(:,:,288))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[28,3],[nMH,nMZ],2,2,wf8(:,18),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(25),m3h8x4(:,130),heltab2x32(:,:,289))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,24),G0H4(26),m3h8x4(:,131),heltab2x32(:,:,290))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,24),G0H4(27),m3h8x4(:,132),heltab2x32(:,:,291))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[28,3],[nMW,nMW],2,2,wf8(:,18),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(28),m3h8x4(:,133),heltab2x32(:,:,292))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[28,3],[nMW,nMW],2,2,wf8(:,18),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(29),m3h8x4(:,134),heltab2x32(:,:,293))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,24),G0H4(30),m3h8x4(:,135),heltab2x32(:,:,294))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,24),G0H4(31),m3h8x4(:,136),heltab2x32(:,:,295))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[28,3],[nMW,nMW],2,2,wf8(:,18),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(32),m3h8x4(:,137),heltab2x32(:,:,296))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[28,3],[nMW,nMW],2,2,wf8(:,18),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(33),m3h8x4(:,138),heltab2x32(:,:,297))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,24),G0H4(34),m3h8x4(:,139),heltab2x32(:,:,298))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,24),G0H4(35),m3h8x4(:,140),heltab2x32(:,:,299))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(88),m3h8x4(:,141),heltab2x32(:,:,300))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(89),m3h8x4(:,142),heltab2x32(:,:,301))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[28,3],[nMW,nMW],2,2,wf8(:,18),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),28,G1H4(90),m3h8x4(:,143),heltab2x32(:,:,302))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[28,3],[nMW,nMW],2,2,wf8(:,18),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),28,G1H4(91),m3h8x4(:,144),heltab2x32(:,:,303))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(92),m3h8x4(:,145),heltab2x32(:,:,304))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(93),m3h8x4(:,146),heltab2x32(:,:,305))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[28,3],[nMH,nMZ],2,2,wf8(:,18),wf4(:,4))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,18),28,G1H4(94),m3h8x4(:,147),heltab2x32(:,:,306))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[28,3],[nMW,nMW],2,2,wf8(:,18),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),28,G1H4(95),m3h8x4(:,148),heltab2x32(:,:,307))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[28,3],[nMW,nMW],2,2,wf8(:,18),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),28,G1H4(96),m3h8x4(:,149),heltab2x32(:,:,308))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[28,3],[0,0],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,150),heltab2x32(:,:,309))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(97),n2h4(123))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[28,3],[nMM,nMM],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,151),heltab2x32(:,:,310))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMM,G1H4(98),n2h4(124))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[28,3],[nML,nML],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,152),heltab2x32(:,:,311))
  call Hloop_Q_A(ntryL,G0H4(36),28,nML,G1H4(99),n2h4(125))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[28,3],[0,0],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,153),heltab2x32(:,:,312))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(100),n2h4(126))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[28,3],[nMT,nMT],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,154),heltab2x32(:,:,313))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMT,G1H4(101),n2h4(127))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[28,3],[0,0],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,155),heltab2x32(:,:,314))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(102),n2h4(128))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[28,3],[nMB,nMB],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,156),heltab2x32(:,:,315))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMB,G1H4(103),n2h4(129))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[28,3],[0,0],2,2,wf8(:,20),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZl,m3h8x4(:,157),heltab2x32(:,:,316))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(104),n2h4(130))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[28,3],[nMM,nMM],2,2,wf8(:,20),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZl,m3h8x4(:,158),heltab2x32(:,:,317))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMM,G1H4(105),n2h4(131))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[28,3],[nML,nML],2,2,wf8(:,20),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZl,m3h8x4(:,159),heltab2x32(:,:,318))
  call Hloop_Q_A(ntryL,G0H4(36),28,nML,G1H4(106),n2h4(132))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[28,3],[0,0],2,2,wf8(:,20),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZu,m3h8x4(:,160),heltab2x32(:,:,319))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(107),n2h4(133))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[28,3],[nMT,nMT],2,2,wf8(:,20),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZu,m3h8x4(:,161),heltab2x32(:,:,320))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMT,G1H4(108),n2h4(134))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[28,3],[0,0],2,2,wf8(:,20),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZd,m3h8x4(:,162),heltab2x32(:,:,321))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(109),n2h4(135))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[28,3],[nMB,nMB],2,2,wf8(:,20),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZd,m3h8x4(:,163),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMB,G1H4(110),n2h4(136))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[28,3],[0,0],2,2,wf8(:,19),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,164),heltab2x32(:,:,323))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(111),n2h4(137))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[28,3],[nMM,nMM],2,2,wf8(:,19),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,165),heltab2x32(:,:,324))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMM,G1H4(112),n2h4(138))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[28,3],[nML,nML],2,2,wf8(:,19),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,166),heltab2x32(:,:,325))
  call Hloop_Q_A(ntryL,G0H4(36),28,nML,G1H4(113),n2h4(139))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[28,3],[0,0],2,2,wf8(:,19),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,167),heltab2x32(:,:,326))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(114),n2h4(140))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[28,3],[nMT,nMT],2,2,wf8(:,19),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,168),heltab2x32(:,:,327))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMT,G1H4(115),n2h4(141))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[28,3],[0,0],2,2,wf8(:,19),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,169),heltab2x32(:,:,328))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(116),n2h4(142))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[28,3],[nMB,nMB],2,2,wf8(:,19),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,170),heltab2x32(:,:,329))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMB,G1H4(117),n2h4(143))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[28,3],[0,0],2,2,wf8(:,20),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZn,m3h8x4(:,171),heltab2x32(:,:,330))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(118),n2h4(144))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[28,3],[0,0],2,2,wf8(:,20),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZl,m3h8x4(:,172),heltab2x32(:,:,331))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(119),n2h4(145))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[28,3],[nMM,nMM],2,2,wf8(:,20),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZl,m3h8x4(:,173),heltab2x32(:,:,332))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMM,G1H4(120),n2h4(146))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[28,3],[nML,nML],2,2,wf8(:,20),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZl,m3h8x4(:,174),heltab2x32(:,:,333))
  call Hloop_Q_A(ntryL,G0H4(36),28,nML,G1H4(121),n2h4(147))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[28,3],[0,0],2,2,wf8(:,20),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZu,m3h8x4(:,175),heltab2x32(:,:,334))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(122),n2h4(148))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[28,3],[nMT,nMT],2,2,wf8(:,20),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZu,m3h8x4(:,176),heltab2x32(:,:,335))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMT,G1H4(123),n2h4(149))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[28,3],[0,0],2,2,wf8(:,20),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZd,m3h8x4(:,177),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(124),n2h4(150))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[28,3],[nMB,nMB],2,2,wf8(:,20),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,20),G0H4(36),ngZd,m3h8x4(:,178),heltab2x32(:,:,337))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMB,G1H4(125),n2h4(151))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(126),m3h8x4(:,179),heltab2x32(:,:,338))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(127),m3h8x4(:,180),heltab2x32(:,:,339))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(128),m3h8x4(:,181),heltab2x32(:,:,340))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[28,3],[nMH,nMZ],2,2,wf8(:,20),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(129),m3h8x4(:,182),heltab2x32(:,:,341))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(130),m3h8x4(:,183),heltab2x32(:,:,342))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(131),m3h8x4(:,184),heltab2x32(:,:,343))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(132),m3h8x4(:,185),heltab2x32(:,:,344))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(133),m3h8x4(:,186),heltab2x32(:,:,345))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(134),m3h8x4(:,187),heltab2x32(:,:,346))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(135),m3h8x4(:,188),heltab2x32(:,:,347))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(136),m3h8x4(:,189),heltab2x32(:,:,348))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(137),m3h8x4(:,190),heltab2x32(:,:,349))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(138),m3h8x4(:,191),heltab2x32(:,:,350))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(139),m3h8x4(:,192),heltab2x32(:,:,351))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(140),m3h8x4(:,193),heltab2x32(:,:,352))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(141),m3h8x4(:,194),heltab2x32(:,:,353))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(142),m3h8x4(:,195),heltab2x32(:,:,354))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,19),G0H4(36),m3h8x4(:,196),heltab2x32(:,:,355))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,19),G0H4(37),m3h8x4(:,197),heltab2x32(:,:,356))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(38),m3h8x4(:,198),heltab2x32(:,:,357))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(39),m3h8x4(:,199),heltab2x32(:,:,358))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,19),G0H4(40),m3h8x4(:,200),heltab2x32(:,:,359))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,19),G0H4(41),m3h8x4(:,201),heltab2x32(:,:,360))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[28,3],[nMH,nMZ],2,2,wf8(:,20),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(42),m3h8x4(:,202),heltab2x32(:,:,361))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(43),m3h8x4(:,203),heltab2x32(:,:,362))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(44),m3h8x4(:,204),heltab2x32(:,:,363))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(98),G1H4(76),G1H4(72),G1H4(34),G1H4(27) &
    ,G1H4(13),G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(99),G1H4(77),G1H4(73),G1H4(35),G1H4(28) &
    ,G1H4(7),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(101),G1H4(78),G1H4(74),G1H4(37),G1H4(30) &
    ,G1H4(6),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(110),[G1H4(103),G1H4(79),G1H4(75),G1H4(39),G1H4(32) &
    ,G1H4(8),G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(112),G1H4(84),G1H4(80),G1H4(49),G1H4(41) &
    ,G1H4(2),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(113),G1H4(85),G1H4(81),G1H4(50),G1H4(42) &
    ,G1H4(5),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(115),G1H4(86),G1H4(82),G1H4(52),G1H4(44) &
    ,G1H4(14),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(117),G1H4(87),G1H4(83),G1H4(54),G1H4(46) &
    ,G1H4(10),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(126),G1H4(56),G1H4(55),G0H4(23),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(128),G1H4(59),G1H4(57),G0H4(24),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(58),G0H4(25),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(133),G1H4(132),G1H4(131),G1H4(63),G1H4(62) &
    ,G1H4(61),G1H4(60),G0H4(29),G0H4(28),G0H4(27),G0H4(26),G0H4(7),G0H4(6),G0H4(5),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(137),G1H4(136),G1H4(135),G1H4(67),G1H4(66) &
    ,G1H4(65),G1H4(64),G0H4(33),G0H4(32),G0H4(31),G0H4(30),G0H4(11),G0H4(10),G0H4(9),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(140),[G1H4(139),G1H4(69),G1H4(68),G0H4(34),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(142),[G1H4(141),G1H4(71),G1H4(70),G0H4(35),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(90),G1H4(89),G1H4(88),G1H4(20),G1H4(19) &
    ,G1H4(12),G1H4(11),G0H4(39),G0H4(38),G0H4(37),G0H4(36),G0H4(17),G0H4(16),G0H4(15),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(95),G1H4(93),G1H4(92),G1H4(25),G1H4(24) &
    ,G1H4(22),G1H4(21),G0H4(44),G0H4(43),G0H4(41),G0H4(40),G0H4(22),G0H4(21),G0H4(19),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(23),G0H4(42),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(107),G1H4(104),G1H4(102),G1H4(100),G1H4(97) &
    ,G1H4(38),G1H4(36),G1H4(33),G1H4(31),G1H4(29),G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(111),G1H4(48),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(114),G1H4(51),G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(116),G1H4(53),G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(47)])
  call Hloop_SA_Q(ntryL,G0H8(7),wf8(:,16),G0H1(1),ngH,m3h8x1(:,13),heltab2x8(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(18),n2h1(153))
  call Hloop_SA_Q(ntryL,G0H8(8),wf8(:,16),G0H1(1),ngX,m3h8x1(:,14),heltab2x8(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(32),n2h1(154))
  call Hloop_SA_Q(ntryL,G0H8(9),wf8(:,16),G0H1(1),ngPbt,m3h8x1(:,15),heltab2x8(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(50),n2h1(155))
  call Hloop_SA_Q(ntryL,G0H8(10),wf8(:,17),G0H1(1),ngH,m3h8x1(:,16),heltab2x8(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(29),n2h1(156))
  call Hloop_SA_Q(ntryL,G0H8(17),wf8(:,17),G0H1(1),ngX,m3h8x1(:,17),heltab2x8(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(41),n2h1(157))
  call Hloop_SA_Q(ntryL,G0H8(18),wf8(:,17),G0H1(1),ngPbt,m3h8x1(:,18),heltab2x8(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(21),n2h1(158))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,16),G0H1(1),m3h8x1(:,19),heltab2x8(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(28),n2h1(159))
  call Hloop_ZA_Q(ntryL,G0H8(2),wf8(:,16),G0H1(1),ngZd,m3h8x1(:,20),heltab2x8(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(45),n2h1(160))
  call Hloop_WA_Q(ntryL,G0H8(3),wf8(:,16),G0H1(1),m3h8x1(:,21),heltab2x8(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(56),n2h1(161))
  call Hloop_VA_Q(ntryL,G0H8(4),wf8(:,17),G0H1(1),m3h8x1(:,22),heltab2x8(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(61),n2h1(162))
  call Hloop_ZA_Q(ntryL,G0H8(5),wf8(:,17),G0H1(1),ngZd,m3h8x1(:,23),heltab2x8(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(66),n2h1(163))
  call Hloop_WA_Q(ntryL,G0H8(6),wf8(:,17),G0H1(1),m3h8x1(:,24),heltab2x8(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(71),n2h1(164))
  call Hloop_QV_A(ntryL,G1H4(105),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(77),n2h1(165))
  call Hloop_QV_A(ntryL,G1H4(106),wf4(:,1),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(92),n2h1(166))
  call Hloop_QV_A(ntryL,G1H4(108),wf4(:,1),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(48),n2h1(167))
  call Hloop_QV_A(ntryL,G1H4(110),wf4(:,1),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(46),n2h1(168))
  call Hloop_QZ_A(ntryL,G1H4(120),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,5),heltab2x4(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(43),n2h1(169))
  call Hloop_QZ_A(ntryL,G1H4(121),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,6),heltab2x4(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(40),n2h1(170))
  call Hloop_QZ_A(ntryL,G1H4(123),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,7),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(88),n2h1(171))
  call Hloop_QZ_A(ntryL,G1H4(125),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,8),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(49),n2h1(172))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(127),28,wf4(:,1),3,G2tensor(51),m3h4x1(:,9),heltab2x4(:,:,53))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(130),28,wf4(:,4),3,G2tensor(79),m3h4x1(:,10),heltab2x4(:,:,54))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(129),28,wf4(:,4),3,G2tensor(73),m3h4x1(:,11),heltab2x4(:,:,55))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(134),28,wf4(:,1),3,G2tensor(70),m3h4x1(:,12),heltab2x4(:,:,56))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(138),28,wf4(:,4),3,G2tensor(64),m3h4x1(:,13),heltab2x4(:,:,57))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(140),28,wf4(:,1),3,G2tensor(61),m3h4x1(:,14),heltab2x4(:,:,58))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(142),28,wf4(:,4),3,G2tensor(55),m3h4x1(:,15),heltab2x4(:,:,59))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(91),wf4(:,1),G1tensor(76),m3h4x1(:,16),heltab2x4(:,:,60))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(96),wf4(:,4),G1tensor(81),m3h4x1(:,17),heltab2x4(:,:,61))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(94),wf4(:,4),G1tensor(86),m3h4x1(:,18),heltab2x4(:,:,62))
  call Hloop_QV_A(ntryL,G1H4(109),wf4(:,1),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(173))
  call Hloop_QZ_A(ntryL,G1H4(119),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,20),heltab2x4(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(174))
  call Hloop_QZ_A(ntryL,G1H4(122),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,21),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(175))
  call Hloop_QZ_A(ntryL,G1H4(124),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,22),heltab2x4(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(54),n2h1(176))
  call Hloop_QZ_A(ntryL,G1H4(118),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,23),heltab2x4(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(177))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(13),wf8(:,21),G1tensor(91),ngH,m3h8x1(:,25),heltab2x8(:,:,112))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(14),wf8(:,21),G1tensor(96),ngX,m3h8x1(:,26),heltab2x8(:,:,113))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(15),wf8(:,21),G1tensor(101),ngPtb,m3h8x1(:,27),heltab2x8(:,:,114))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(16),wf8(:,22),G1tensor(106),ngH,m3h8x1(:,28),heltab2x8(:,:,115))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(17),wf8(:,22),G1tensor(111),ngX,m3h8x1(:,29),heltab2x8(:,:,116))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(18),wf8(:,22),G1tensor(116),ngPtb,m3h8x1(:,30),heltab2x8(:,:,117))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(19),wf8(:,21),G1tensor(121),m3h8x1(:,31),heltab2x8(:,:,118))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(20),wf8(:,21),G1tensor(126),ngZd,m3h8x1(:,32),heltab2x8(:,:,119))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(21),wf8(:,21),G1tensor(131),m3h8x1(:,33),heltab2x8(:,:,120))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(22),wf8(:,22),G1tensor(136),m3h8x1(:,34),heltab2x8(:,:,121))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(23),wf8(:,22),G1tensor(141),ngZd,m3h8x1(:,35),heltab2x8(:,:,122))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(24),wf8(:,22),G1tensor(146),m3h8x1(:,36),heltab2x8(:,:,123))
  call ol_merge_tensors(G0tensor(385),[G0tensor(158),G0tensor(240),G0tensor(36),G0tensor(6)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(61),G2tensor(64),G2tensor(70),G2tensor(79),G2tensor(51),G1tensor(81),G1tensor(76) &
    ,G0tensor(393),G0tensor(140),G0tensor(127),G0tensor(202),G0tensor(11)])
  call ol_merge_tensors(G1tensor(146),[G1tensor(131),G1tensor(116),G1tensor(101),G0tensor(398),G0tensor(115),G0tensor(235) &
    ,G0tensor(16)])
  call ol_merge_tensors(G0tensor(541),[G0tensor(535),G0tensor(462),G0tensor(406),G0tensor(399),G0tensor(394),G0tensor(389) &
    ,G0tensor(228),G0tensor(249),G0tensor(74),G0tensor(69),G0tensor(130),G0tensor(44),G0tensor(112),G0tensor(45),G0tensor(225) &
    ,G0tensor(166),G0tensor(56),G0tensor(21)])
  call ol_merge_tensors(G0tensor(540),[G0tensor(534),G0tensor(461),G0tensor(411),G0tensor(405),G0tensor(400),G0tensor(388) &
    ,G0tensor(154),G0tensor(83),G0tensor(160),G0tensor(145),G0tensor(207),G0tensor(107),G0tensor(220),G0tensor(196),G0tensor(171) &
    ,G0tensor(51),G0tensor(26)])
  call ol_merge_tensors(G1tensor(71),[G1tensor(56),G1tensor(21),G1tensor(50),G0tensor(404),G0tensor(18),G0tensor(41)])
  call ol_merge_tensors(G0tensor(410),[G0tensor(124),G0tensor(23),G0tensor(191),G0tensor(46)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(46),G0tensor(227),G0tensor(162),G0tensor(231),G0tensor(206),G0tensor(121) &
    ,G0tensor(96),G0tensor(66)])
  call ol_merge_tensors(G0tensor(39),[G0tensor(71)])
  call ol_merge_tensors(G0tensor(43),[G0tensor(76)])
  call ol_merge_tensors(G0tensor(198),[G0tensor(189),G0tensor(190),G0tensor(118),G0tensor(99),G0tensor(182),G0tensor(177) &
    ,G0tensor(37),G0tensor(3),G0tensor(12),G0tensor(257),G0tensor(246),G0tensor(81)])
  call ol_merge_tensors(G0tensor(528),[G0tensor(522),G0tensor(517),G0tensor(512),G0tensor(506),G0tensor(500),G0tensor(494) &
    ,G0tensor(488),G0tensor(482),G0tensor(477),G0tensor(472),G0tensor(467),G0tensor(455),G0tensor(450),G0tensor(444),G0tensor(438) &
    ,G0tensor(432),G0tensor(426),G0tensor(421),G0tensor(416),G0tensor(378),G0tensor(366),G0tensor(355),G0tensor(350),G0tensor(345) &
    ,G0tensor(340),G0tensor(331),G0tensor(326),G0tensor(314),G0tensor(308),G0tensor(297),G0tensor(292),G0tensor(286),G0tensor(275) &
    ,G0tensor(270),G0tensor(265),G0tensor(258),G0tensor(259),G0tensor(208),G0tensor(184),G0tensor(204),G0tensor(173),G0tensor(148) &
    ,G0tensor(149),G0tensor(119),G0tensor(98),G0tensor(79),G0tensor(152),G0tensor(54),G0tensor(48),G0tensor(42),G0tensor(52) &
    ,G0tensor(27),G0tensor(29),G0tensor(10),G0tensor(90),G0tensor(77),G0tensor(25),G0tensor(170),G0tensor(232),G0tensor(217) &
    ,G0tensor(251),G0tensor(221),G0tensor(141),G0tensor(111),G0tensor(86)])
  call ol_merge_tensors(G0tensor(178),[G0tensor(123),G0tensor(144),G0tensor(84),G0tensor(59),G0tensor(47),G0tensor(101)])
  call ol_merge_tensors(G0tensor(349),[G0tensor(274),G0tensor(104),G0tensor(139),G0tensor(62),G0tensor(135),G0tensor(15) &
    ,G0tensor(92),G0tensor(40),G0tensor(5),G0tensor(50),G0tensor(106)])
  call ol_merge_tensors(G0tensor(53),[G0tensor(126)])
  call ol_merge_tensors(G0tensor(58),[G0tensor(131)])
  call ol_merge_tensors(G0tensor(529),[G0tensor(523),G0tensor(507),G0tensor(501),G0tensor(495),G0tensor(489),G0tensor(483) &
    ,G0tensor(456),G0tensor(445),G0tensor(439),G0tensor(433),G0tensor(427),G0tensor(383),G0tensor(377),G0tensor(372),G0tensor(367) &
    ,G0tensor(361),G0tensor(356),G0tensor(325),G0tensor(320),G0tensor(315),G0tensor(309),G0tensor(303),G0tensor(298),G0tensor(291) &
    ,G0tensor(285),G0tensor(280),G0tensor(215),G0tensor(210),G0tensor(209),G0tensor(179),G0tensor(143),G0tensor(63),G0tensor(187) &
    ,G0tensor(32),G0tensor(22),G0tensor(75),G0tensor(19),G0tensor(167),G0tensor(70),G0tensor(136)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(48),G0tensor(245),G0tensor(181),G0tensor(151)])
  call ol_merge_tensors(G0tensor(64),[G0tensor(156)])
  call ol_merge_tensors(G0tensor(78),[G0tensor(161)])
  call ol_merge_tensors(G0tensor(163),[G0tensor(68),G0tensor(186)])
  call ol_merge_tensors(G0tensor(129),[G0tensor(211)])
  call ol_merge_tensors(G0tensor(93),[G0tensor(216)])
  call ol_merge_tensors(G0tensor(244),[G0tensor(120),G0tensor(242),G0tensor(236)])
  call ol_merge_tensors(G1tensor(106),[G1tensor(91),G0tensor(134),G0tensor(72),G0tensor(241)])
  call ol_merge_tensors(G0tensor(352),[G0tensor(322),G0tensor(305),G0tensor(294),G0tensor(133),G0tensor(82),G0tensor(2) &
    ,G0tensor(65)])
  call ol_merge_tensors(G1tensor(141),[G1tensor(126),G1tensor(111),G1tensor(96),G0tensor(376),G0tensor(324),G0tensor(290) &
    ,G0tensor(284),G0tensor(97),G0tensor(252),G0tensor(165)])
  call ol_merge_tensors(G0tensor(328),[G0tensor(288),G0tensor(262),G0tensor(233),G0tensor(159),G0tensor(100),G0tensor(250)])
  call ol_merge_tensors(G1tensor(136),[G1tensor(121),G0tensor(339),G0tensor(307),G0tensor(264),G0tensor(253),G0tensor(87) &
    ,G0tensor(230)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(86),G0tensor(193),G0tensor(117),G0tensor(247)])
  call ol_merge_tensors(G1tensor(29),[G1tensor(18),G0tensor(30),G0tensor(110)])
  call ol_merge_tensors(G0tensor(188),[G0tensor(174),G0tensor(192)])
  call ol_merge_tensors(G1tensor(66),[G1tensor(45),G1tensor(41),G1tensor(32),G0tensor(443),G0tensor(437),G0tensor(365) &
    ,G0tensor(313),G0tensor(175),G0tensor(35)])
  call ol_merge_tensors(G0tensor(514),[G0tensor(464),G0tensor(447),G0tensor(359),G0tensor(338),G0tensor(334),G0tensor(277) &
    ,G0tensor(267),G0tensor(234),G0tensor(95)])
  call ol_merge_tensors(G0tensor(509),[G0tensor(474),G0tensor(413),G0tensor(369),G0tensor(342),G0tensor(333),G0tensor(329) &
    ,G0tensor(301),G0tensor(248),G0tensor(80)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(54),G2tensor(63),G2tensor(16),G2tensor(52),G0tensor(469),G0tensor(418) &
    ,G0tensor(335),G0tensor(263),G0tensor(224),G0tensor(214),G0tensor(24)])
  call ol_merge_tensors(G1tensor(61),[G1tensor(28),G0tensor(431),G0tensor(420),G0tensor(344),G0tensor(269),G0tensor(85)])
  call ol_merge_tensors(G0tensor(448),[G0tensor(436),G0tensor(419),G0tensor(414),G0tensor(168),G0tensor(13)])
  call ol_merge_tensors(G0tensor(453),[G0tensor(442),G0tensor(430),G0tensor(424),G0tensor(128),G0tensor(60),G0tensor(55)])
  call ol_merge_tensors(G0tensor(459),[G0tensor(153),G0tensor(105),G0tensor(102)])
  call ol_merge_tensors(G0tensor(537),[G0tensor(122)])
  call ol_merge_tensors(G0tensor(531),[G0tensor(33)])
  call ol_merge_tensors(G0tensor(532),[G0tensor(73),G0tensor(155),G0tensor(125)])
  call ol_merge_tensors(G0tensor(539),[G0tensor(38)])
  call ol_merge_tensors(G0tensor(183),[G0tensor(150),G0tensor(57)])
  call ol_merge_tensors(G0tensor(520),[G0tensor(504),G0tensor(498),G0tensor(492),G0tensor(200),G0tensor(67),G0tensor(142)])
  call ol_merge_tensors(G0tensor(510),[G0tensor(480),G0tensor(470),G0tensor(465),G0tensor(88),G0tensor(109)])
  call ol_merge_tensors(G0tensor(185),[G0tensor(108),G0tensor(169)])
  call ol_merge_tensors(G0tensor(527),[G0tensor(505),G0tensor(487),G0tensor(481),G0tensor(199)])
  call ol_merge_tensors(G0tensor(491),[G0tensor(452),G0tensor(381),G0tensor(375),G0tensor(370),G0tensor(212)])
  call ol_merge_tensors(G0tensor(485),[G0tensor(380),G0tensor(363),G0tensor(358),G0tensor(353),G0tensor(213)])
  call ol_merge_tensors(G0tensor(458),[G0tensor(397),G0tensor(392),G0tensor(219)])
  call ol_merge_tensors(G0tensor(402),[G0tensor(391),G0tensor(386),G0tensor(223)])
  call ol_merge_tensors(G0tensor(296),[G0tensor(282),G0tensor(272),G0tensor(243),G0tensor(238)])
  call ol_merge_tensors(G0tensor(425),[G0tensor(415),G0tensor(312),G0tensor(273),G0tensor(268)])
  call ol_merge_tensors(G0tensor(519),[G0tensor(423),G0tensor(318),G0tensor(283),G0tensor(278)])
  call ol_merge_tensors(G0tensor(497),[G0tensor(429),G0tensor(371),G0tensor(289),G0tensor(279)])
  call ol_merge_tensors(G0tensor(525),[G0tensor(317),G0tensor(311),G0tensor(300),G0tensor(295)])
  call ol_merge_tensors(G0tensor(479),[G0tensor(435),G0tensor(360),G0tensor(306),G0tensor(302)])
  call ol_merge_tensors(G0tensor(503),[G0tensor(441),G0tensor(382),G0tensor(323),G0tensor(319)])
  call ol_merge_tensors(G0tensor(374),[G0tensor(354),G0tensor(347),G0tensor(337),G0tensor(330)])
  call ol_merge_tensors(G0tensor(454),[G0tensor(449),G0tensor(364),G0tensor(348),G0tensor(343)])
  call ol_merge_tensors(G0tensor(408),[G0tensor(396),G0tensor(387)])
  call ol_merge_tensors(G0tensor(460),[G0tensor(409),G0tensor(403)])
  call ol_merge_tensors(G0tensor(493),[G0tensor(486),G0tensor(475),G0tensor(466)])
  call ol_merge_tensors(G0tensor(516),[G0tensor(499),G0tensor(476),G0tensor(471)])
  call ol_merge_tensors(G0tensor(526),[G0tensor(521),G0tensor(515),G0tensor(511)])
  call ol_merge_tensors(G0tensor(538),[G0tensor(533)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(77)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(92)])
call TI_bubble_red(G2tensor(55),28,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(31))
call TI_bubble_red(G2tensor(49),28,mass2set(:,2),G0tensor(61),M2L1R1,G0tensor(91))
call TI_bubble_red(G2tensor(88),28,mass2set(:,3),G0tensor(116),M2L1R1,G0tensor(146))
call TI_bubble_red(G2tensor(73),28,mass2set(:,4),G0tensor(176),M2L1R1,G0tensor(201),G0tensor(226))
call TI_bubble_red(G2tensor(19),28,mass2set(:,5),G0tensor(256),M2L1R1)
call TI_bubble_red(G2tensor(43),28,mass2set(:,6),G0tensor(255),M2L1R1,G0tensor(222))
call TI_bubble_red(G2tensor(40),28,mass2set(:,7),G0tensor(237),M2L1R1,G0tensor(260))
  call ol_merge_tensors(G0tensor(541),[G0tensor(31)])
  call ol_merge_tensors(G0tensor(146),[G0tensor(540)])
  call ol_merge_tensors(G0tensor(528),[G0tensor(91)])
  call ol_merge_tensors(G0tensor(226),[G0tensor(198)])
  call ol_merge_tensors(G0tensor(201),[G0tensor(529)])
call TI_bubble_red(G1tensor(146),24,mass2set(:,8),G0tensor(7),M2L1R1,G0tensor(4),G0tensor(229))
call TI_bubble_red(G1tensor(71),20,mass2set(:,9),G0tensor(8),M2L1R1,G0tensor(239),G0tensor(261))
call TI_bubble_red(G1tensor(106),24,mass2set(:,10),G0tensor(266),M2L1R1,G0tensor(271),G0tensor(9))
call TI_bubble_red(G1tensor(141),24,mass2set(:,11),G0tensor(276),M2L1R1,G0tensor(281),G0tensor(287))
call TI_bubble_red(G1tensor(136),24,mass2set(:,12),G0tensor(293),M2L1R1,G0tensor(299))
call TI_bubble_red(G1tensor(29),20,mass2set(:,13),G0tensor(304),M2L1R1,G0tensor(310),G0tensor(316))
call TI_bubble_red(G1tensor(66),20,mass2set(:,14),G0tensor(321),M2L1R1,G0tensor(327),G0tensor(332))
call TI_bubble_red(G1tensor(61),20,mass2set(:,15),G0tensor(336),M2L1R1,G0tensor(341))
  call ol_merge_tensors(G0tensor(261),[G0tensor(4),G0tensor(541)])
  call ol_merge_tensors(G0tensor(239),[G0tensor(146),G0tensor(229)])
  call ol_merge_tensors(G0tensor(341),[G0tensor(327),G0tensor(310),G0tensor(299),G0tensor(287),G0tensor(9),G0tensor(528)])
  call ol_merge_tensors(G0tensor(316),[G0tensor(271),G0tensor(226)])
  call ol_merge_tensors(G0tensor(332),[G0tensor(281),G0tensor(201)])
  call ol_merge_tensors(T0sum(149),[G0tensor(385)])
  call ol_merge_tensors(T0sum(150),[G0tensor(1)])
  call ol_merge_tensors(T0sum(151),[G0tensor(261)])
  call ol_merge_tensors(T0sum(152),[G0tensor(7)])
  call ol_merge_tensors(T0sum(153),[G0tensor(239)])
  call ol_merge_tensors(T0sum(154),[G0tensor(8)])
  call ol_merge_tensors(T0sum(155),[G0tensor(410)])
  call ol_merge_tensors(T0sum(156),[G0tensor(61)])
  call ol_merge_tensors(T0sum(157),[G0tensor(341)])
  call ol_merge_tensors(T0sum(158),[G0tensor(39)])
  call ol_merge_tensors(T0sum(159),[G0tensor(43)])
  call ol_merge_tensors(T0sum(160),[G0tensor(316)])
  call ol_merge_tensors(T0sum(161),[G0tensor(178)])
  call ol_merge_tensors(T0sum(162),[G0tensor(349)])
  call ol_merge_tensors(T0sum(163),[G0tensor(53)])
  call ol_merge_tensors(T0sum(164),[G0tensor(58)])
  call ol_merge_tensors(T0sum(165),[G0tensor(332)])
  call ol_merge_tensors(T0sum(166),[G0tensor(116)])
  call ol_merge_tensors(T0sum(167),[G0tensor(64)])
  call ol_merge_tensors(T0sum(168),[G0tensor(78)])
  call ol_merge_tensors(T0sum(169),[G0tensor(163)])
  call ol_merge_tensors(T0sum(170),[G0tensor(129)])
  call ol_merge_tensors(T0sum(171),[G0tensor(93)])
  call ol_merge_tensors(T0sum(172),[G0tensor(244)])
  call ol_merge_tensors(T0sum(173),[G0tensor(266)])
  call ol_merge_tensors(T0sum(174),[G0tensor(352)])
  call ol_merge_tensors(T0sum(175),[G0tensor(276)])
  call ol_merge_tensors(T0sum(176),[G0tensor(328)])
  call ol_merge_tensors(T0sum(177),[G0tensor(293)])
  call ol_merge_tensors(T0sum(178),[G0tensor(176)])
  call ol_merge_tensors(T0sum(179),[G0tensor(304)])
  call ol_merge_tensors(T0sum(180),[G0tensor(188)])
  call ol_merge_tensors(T0sum(181),[G0tensor(321)])
  call ol_merge_tensors(T0sum(182),[G0tensor(514)])
  call ol_merge_tensors(T0sum(183),[G0tensor(509)])
  call ol_merge_tensors(T0sum(184),[G0tensor(256)])
  call ol_merge_tensors(T0sum(185),[G0tensor(336)])
  call ol_merge_tensors(T0sum(186),[G0tensor(448)])
  call ol_merge_tensors(T0sum(187),[G0tensor(453)])
  call ol_merge_tensors(T0sum(188),[G0tensor(459)])
  call ol_merge_tensors(T0sum(189),[G0tensor(537)])
  call ol_merge_tensors(T0sum(190),[G0tensor(531)])
  call ol_merge_tensors(T0sum(191),[G0tensor(532)])
  call ol_merge_tensors(T0sum(192),[G0tensor(539)])
  call ol_merge_tensors(T0sum(193),[G0tensor(183)])
  call ol_merge_tensors(T0sum(194),[G0tensor(520)])
  call ol_merge_tensors(T0sum(195),[G0tensor(510)])
  call ol_merge_tensors(T0sum(196),[G0tensor(185)])
  call ol_merge_tensors(T0sum(197),[G0tensor(527)])
  call ol_merge_tensors(T0sum(198),[G0tensor(195)])
  call ol_merge_tensors(T0sum(199),[G0tensor(491)])
  call ol_merge_tensors(T0sum(200),[G0tensor(485)])
  call ol_merge_tensors(T0sum(201),[G0tensor(458)])
  call ol_merge_tensors(T0sum(202),[G0tensor(402)])
  call ol_merge_tensors(T0sum(203),[G0tensor(296)])
  call ol_merge_tensors(T0sum(204),[G0tensor(425)])
  call ol_merge_tensors(T0sum(205),[G0tensor(519)])
  call ol_merge_tensors(T0sum(206),[G0tensor(497)])
  call ol_merge_tensors(T0sum(207),[G0tensor(525)])
  call ol_merge_tensors(T0sum(208),[G0tensor(479)])
  call ol_merge_tensors(T0sum(209),[G0tensor(503)])
  call ol_merge_tensors(T0sum(210),[G0tensor(374)])
  call ol_merge_tensors(T0sum(211),[G0tensor(454)])
  call ol_merge_tensors(T0sum(212),[G0tensor(408)])
  call ol_merge_tensors(T0sum(213),[G0tensor(460)])
  call ol_merge_tensors(T0sum(214),[G0tensor(493)])
  call ol_merge_tensors(T0sum(215),[G0tensor(516)])
  call ol_merge_tensors(T0sum(216),[G0tensor(526)])
  call ol_merge_tensors(T0sum(217),[G0tensor(538)])
  call ol_merge_tensors(T0sum(218),[G0tensor(255)])
  call ol_merge_tensors(T0sum(219),[G0tensor(222)])
  call ol_merge_tensors(T0sum(220),[G0tensor(237)])
  call ol_merge_tensors(T0sum(221),[G0tensor(260)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 20, 21, 23 ],masses2_63,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 23 ],masses2_66,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 20, 23 ],masses2_66,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 20, 21 ],masses2_66,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_63,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 20, 21, 23 ],masses2_64,RedSet_4(1),ScalarBoxes(6))
  call compute_scalar_box([ 16, 21, 23 ],masses2_68,RedSet_4(2),ScalarBoxes(7))
  call compute_scalar_box([ 16, 20, 23 ],masses2_68,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 4, 5, 7 ],masses2_64,RedSet_4(5),ScalarBoxes(9))
  call compute_scalar_box([ 20, 21, 23 ],masses2_84,RedSet_4(1),ScalarBoxes(10))
  call compute_scalar_box([ 16, 20, 23 ],masses2_74,RedSet_4(3),ScalarBoxes(11))
  call compute_scalar_box([ 16, 20, 21 ],masses2_74,RedSet_4(4),ScalarBoxes(12))
  call compute_scalar_box([ 4, 5, 7 ],masses2_84,RedSet_4(5),ScalarBoxes(13))
  call compute_scalar_box([ 20, 21, 23 ],masses2_85,RedSet_4(1),ScalarBoxes(14))
  call compute_scalar_box([ 16, 20, 23 ],masses2_77,RedSet_4(3),ScalarBoxes(15))
  call compute_scalar_box([ 4, 5, 7 ],masses2_85,RedSet_4(5),ScalarBoxes(16))
  call compute_scalar_box([ 20, 22, 23 ],masses2_63,RedSet_4(6),ScalarBoxes(17))
  call compute_scalar_box([ 16, 22, 23 ],masses2_66,RedSet_4(7),ScalarBoxes(18))
  call compute_scalar_box([ 16, 20, 22 ],masses2_66,RedSet_4(8),ScalarBoxes(19))
  call compute_scalar_box([ 4, 6, 7 ],masses2_63,RedSet_4(9),ScalarBoxes(20))
  call compute_scalar_box([ 20, 22, 23 ],masses2_84,RedSet_4(6),ScalarBoxes(21))
  call compute_scalar_box([ 16, 20, 22 ],masses2_74,RedSet_4(8),ScalarBoxes(22))
  call compute_scalar_box([ 4, 6, 7 ],masses2_84,RedSet_4(9),ScalarBoxes(23))
  call compute_scalar_box([ 20, 22, 23 ],masses2_64,RedSet_4(6),ScalarBoxes(24))
  call compute_scalar_box([ 16, 22, 23 ],masses2_68,RedSet_4(7),ScalarBoxes(25))
  call compute_scalar_box([ 4, 6, 7 ],masses2_64,RedSet_4(9),ScalarBoxes(26))
  call compute_scalar_box([ 20, 22, 23 ],masses2_85,RedSet_4(6),ScalarBoxes(27))
  call compute_scalar_box([ 4, 6, 7 ],masses2_85,RedSet_4(9),ScalarBoxes(28))
  call compute_scalar_box([ 20, 22, 23 ],masses2_83,RedSet_4(6),ScalarBoxes(29))
  call compute_scalar_box([ 16, 22, 23 ],masses2_78,RedSet_4(7),ScalarBoxes(30))
  call compute_scalar_box([ 16, 20, 23 ],masses2_82,RedSet_4(3),ScalarBoxes(31))
  call compute_scalar_box([ 16, 20, 22 ],masses2_80,RedSet_4(8),ScalarBoxes(32))
  call compute_scalar_box([ 4, 6, 7 ],masses2_83,RedSet_4(9),ScalarBoxes(33))
! end of process

! end do

end subroutine vamp_1

end module ol_vamp_1_ppllj_ew_eexbbxg_1_/**/REALKIND
