
module ol_vamp_1_ppllj_ew_llxbbx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj_ew_llxbbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj_ew_llxbbx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllj_ew_llxbbx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllj_ew_llxbbx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppllj_ew_llxbbx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllj_ew_llxbbx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(23)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[nMH,nML,nMH,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(1),ngH,m3h2x8(:,1),heltab2x16(:,:,1))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[nMZ,nML,nMH,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(2),ngX,m3h2x8(:,2),heltab2x16(:,:,2))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[nMH,nML,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(3),ngH,m3h2x8(:,3),heltab2x16(:,:,3))
  Gcoeff(:)%j = (c(23)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,2,1,4],[nMZ,nML,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(4),ngX,m3h2x8(:,4),heltab2x16(:,:,4))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,2,1,4],[0,nML,nMH,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (c(64)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,2,1,4],[0,nML,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,2,1,4],[nMZ,nML,nMH,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(7),ngZd,m3h2x8(:,7),heltab2x16(:,:,7))
  Gcoeff(:)%j = (c(65)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,2,1,4],[nMZ,nML,nMZ,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(8),ngZd,m3h2x8(:,8),heltab2x16(:,:,8))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,2,1,4],[nMH,nML,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(9),ngH,m3h2x8(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (c(64)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,2,1,4],[nMZ,nML,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(10),ngX,m3h2x8(:,10),heltab2x16(:,:,10))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,2,1,4],[nMH,nML,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(11),ngH,m3h2x8(:,11),heltab2x16(:,:,11))
  Gcoeff(:)%j = (c(65)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,2,1,4],[nMZ,nML,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(12),ngX,m3h2x8(:,12),heltab2x16(:,:,12))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,2,1,4],[0,nML,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  Gcoeff(:)%j = (c(3)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,2,1,4],[nMZ,nML,0,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(14),ngZd,m3h2x8(:,14),heltab2x16(:,:,14))
  Gcoeff(:)%j = (c(3)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[8,2,1,4],[0,nML,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(15),m3h2x8(:,15),heltab2x16(:,:,15))
  Gcoeff(:)%j = (c(4)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,2,1,4],[nMZ,nML,nMZ,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(16),ngZd,m3h2x8(:,16),heltab2x16(:,:,16))
  Gcoeff(:)%j = (c(23)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,1,2,4],[nMH,nML,nMH,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(17),ngH,m3h2x8(:,17),heltab2x16(:,:,17))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[8,1,2,4],[nMH,nML,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(18),ngH,m3h2x8(:,18),heltab2x16(:,:,18))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[8,1,2,4],[nMZ,nML,nMH,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(19),ngX,m3h2x8(:,19),heltab2x16(:,:,19))
  Gcoeff(:)%j = (c(23)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[8,1,2,4],[nMZ,nML,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(20),ngX,m3h2x8(:,20),heltab2x16(:,:,20))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[8,1,2,4],[nMW,0,nMW,nMT],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(21),ngPbt,m3h2x8(:,21),heltab2x16(:,:,21))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[8,1,2,4],[nMH,nML,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(22),ngH,m3h2x8(:,22),heltab2x16(:,:,22))
  Gcoeff(:)%j = (c(64)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[8,1,2,4],[nMZ,nML,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(23),ngX,m3h2x8(:,23),heltab2x16(:,:,23))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[8,1,2,4],[nMH,nML,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(24),ngH,m3h2x8(:,24),heltab2x16(:,:,24))
  Gcoeff(:)%j = (c(65)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[8,1,2,4],[nMZ,nML,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(25),ngX,m3h2x8(:,25),heltab2x16(:,:,25))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[8,1,2,4],[nMW,0,nMW,nMT],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(26),ngPbt,m3h2x8(:,26),heltab2x16(:,:,26))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[8,1,2,4],[0,nML,nMH,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(27),m3h2x8(:,27),heltab2x16(:,:,27))
  Gcoeff(:)%j = (c(64)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[8,1,2,4],[0,nML,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(28),m3h2x8(:,28),heltab2x16(:,:,28))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[8,1,2,4],[nMZ,nML,nMH,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(29),ngZd,m3h2x8(:,29),heltab2x16(:,:,29))
  Gcoeff(:)%j = (c(65)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[8,1,2,4],[nMZ,nML,nMZ,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(30),ngZd,m3h2x8(:,30),heltab2x16(:,:,30))
  Gcoeff(:)%j = (c(30)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[8,1,2,4],[nMW,0,nMW,nMT],4,0)
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(31),m3h2x8(:,31),heltab2x16(:,:,31))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[8,1,2,4],[0,nML,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(32),m3h2x8(:,32),heltab2x16(:,:,32))
  Gcoeff(:)%j = (c(3)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[8,1,2,4],[0,nML,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(33),m3h2x8(:,33),heltab2x16(:,:,33))
  Gcoeff(:)%j = (c(3)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[8,1,2,4],[nMZ,nML,0,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(34),ngZd,m3h2x8(:,34),heltab2x16(:,:,34))
  Gcoeff(:)%j = (c(4)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[8,1,2,4],[nMZ,nML,nMZ,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(35),ngZd,m3h2x8(:,35),heltab2x16(:,:,35))
  Gcoeff(:)%j = (c(8)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[8,1,2,4],[nMW,0,nMW,nMT],4,0)
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(36),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_SA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(1),n2h4(1))
  call Hloop_SA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(2),n2h4(2))
  call Hloop_SA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),ngH,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(3),n2h4(3))
  call Hloop_SA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),ngX,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(4),n2h4(4))
  call Hloop_VA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(5),n2h4(5))
  call Hloop_VA_Q(ntryL,G0H8(6),ex2(:),G0H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(6),n2h4(6))
  call Hloop_ZA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),ngZl,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(7),n2h4(7))
  call Hloop_ZA_Q(ntryL,G0H8(8),ex2(:),G0H4(1),ngZl,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(8),n2h4(8))
  call Hloop_SA_Q(ntryL,G0H8(9),ex2(:),G0H4(1),ngH,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(9),n2h4(9))
  call Hloop_SA_Q(ntryL,G0H8(10),ex2(:),G0H4(1),ngX,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(10),n2h4(10))
  call Hloop_SA_Q(ntryL,G0H8(11),ex2(:),G0H4(1),ngH,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(11),n2h4(11))
  call Hloop_SA_Q(ntryL,G0H8(12),ex2(:),G0H4(1),ngX,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(12),n2h4(12))
  call Hloop_VA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(13),n2h4(13))
  call Hloop_ZA_Q(ntryL,G0H8(14),ex2(:),G0H4(1),ngZl,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(14),n2h4(14))
  call Hloop_VA_Q(ntryL,G0H8(15),ex2(:),G0H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(15),n2h4(15))
  call Hloop_ZA_Q(ntryL,G0H8(16),ex2(:),G0H4(1),ngZl,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(16),n2h4(16))
  call Hloop_SQ_A(ntryL,G0H8(17),ex1(:),G0H4(1),ngH,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(17),n2h4(17))
  call Hloop_SQ_A(ntryL,G0H8(18),ex1(:),G0H4(1),ngH,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(18),n2h4(18))
  call Hloop_SQ_A(ntryL,G0H8(19),ex1(:),G0H4(1),ngX,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(19),n2h4(19))
  call Hloop_SQ_A(ntryL,G0H8(20),ex1(:),G0H4(1),ngX,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(20),n2h4(20))
  call Hloop_SQ_A(ntryL,G0H8(21),ex1(:),G0H4(1),ngPnl,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(21),n2h4(21))
  call Hloop_SQ_A(ntryL,G0H8(22),ex1(:),G0H4(1),ngH,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(22),n2h4(22))
  call Hloop_SQ_A(ntryL,G0H8(23),ex1(:),G0H4(1),ngX,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(23),n2h4(23))
  call Hloop_SQ_A(ntryL,G0H8(24),ex1(:),G0H4(1),ngH,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(24),n2h4(24))
  call Hloop_SQ_A(ntryL,G0H8(25),ex1(:),G0H4(1),ngX,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(25),n2h4(25))
  call Hloop_SQ_A(ntryL,G0H8(26),ex1(:),G0H4(1),ngPnl,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(26),n2h4(26))
  call Hloop_VQ_A(ntryL,G0H8(27),ex1(:),G0H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(27),n2h4(27))
  call Hloop_VQ_A(ntryL,G0H8(28),ex1(:),G0H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(28),n2h4(28))
  call Hloop_ZQ_A(ntryL,G0H8(29),ex1(:),G0H4(1),ngZl,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(29),n2h4(29))
  call Hloop_ZQ_A(ntryL,G0H8(30),ex1(:),G0H4(1),ngZl,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(30),n2h4(30))
  call Hloop_WQ_A(ntryL,G0H8(31),ex1(:),G0H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(31),n2h4(31))
  call Hloop_VQ_A(ntryL,G0H8(32),ex1(:),G0H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(32),n2h4(32))
  call Hloop_VQ_A(ntryL,G0H8(33),ex1(:),G0H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(33),n2h4(33))
  call Hloop_ZQ_A(ntryL,G0H8(34),ex1(:),G0H4(1),ngZl,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(34),n2h4(34))
  call Hloop_ZQ_A(ntryL,G0H8(35),ex1(:),G0H4(1),ngZl,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(35),n2h4(35))
  call Hloop_WQ_A(ntryL,G0H8(36),ex1(:),G0H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(36),n2h4(36))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(26)])
  call Hloop_AQ_S(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_S(ntryL,G1H4(7),ex1(:),G1H2(2),ngH,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_S(ntryL,G1H4(3),ex1(:),G1H2(3),ngX,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_S(ntryL,G1H4(8),ex1(:),G1H2(4),ngX,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_S(ntryL,G1H4(5),ex1(:),G1H2(5),ngH,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_S(ntryL,G1H4(6),ex1(:),G1H2(6),ngX,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G1H4(9),ex1(:),G1H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G1H4(14),ex1(:),G1H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_Z(ntryL,G1H4(11),ex1(:),G1H2(9),ngZl,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_Z(ntryL,G1H4(16),ex1(:),G1H2(10),ngZl,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G1H4(13),ex1(:),G1H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H4(15),ex1(:),G1H2(12),ngZl,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_S(ntryL,G1H4(17),ex2(:),G1H2(13),ngH,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_S(ntryL,G1H4(18),ex2(:),G1H2(14),ngX,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_S(ntryL,G1H4(29),ex2(:),G1H2(15),ngH,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_S(ntryL,G1H4(30),ex2(:),G1H2(16),ngX,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_S(ntryL,G1H4(31),ex2(:),G1H2(17),ngPln,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G1H4(22),ex2(:),G1H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_V(ntryL,G1H4(34),ex2(:),G1H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_Z(ntryL,G1H4(24),ex2(:),G1H2(20),ngZl,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_Z(ntryL,G1H4(35),ex2(:),G1H2(21),ngZl,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_W(ntryL,G1H4(36),ex2(:),G1H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_S(ntryL,G1H4(27),ex2(:),G1H2(23),ngH,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_S(ntryL,G1H4(28),ex2(:),G1H2(24),ngX,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G1H4(32),ex2(:),G1H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_Z(ntryL,G1H4(33),ex2(:),G1H2(26),ngZl,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_SQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),ngH,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(1),n2h1(1))
  call Hloop_SQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngH,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(2),n2h1(2))
  call Hloop_SQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),ngX,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(3),n2h1(3))
  call Hloop_SQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),ngX,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(4),n2h1(4))
  call Hloop_SQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),ngH,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(5),n2h1(5))
  call Hloop_SQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),ngX,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(6),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(7),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(8),n2h1(8))
  call Hloop_ZQ_A(ntryL,G1H2(9),ex3(:),G1H1(1),ngZd,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(9),n2h1(9))
  call Hloop_ZQ_A(ntryL,G1H2(10),ex3(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(10),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(11),n2h1(11))
  call Hloop_ZQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),ngZd,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(12),n2h1(12))
  call Hloop_SQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),ngH,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(13),n2h1(13))
  call Hloop_SQ_A(ntryL,G1H2(14),ex3(:),G1H1(1),ngX,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(14),n2h1(14))
  call Hloop_SQ_A(ntryL,G1H2(15),ex3(:),G1H1(1),ngH,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(15),n2h1(15))
  call Hloop_SQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),ngX,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(16),n2h1(16))
  call Hloop_SQ_A(ntryL,G1H2(17),ex3(:),G1H1(1),ngPtb,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(17),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(18),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(19),n2h1(19))
  call Hloop_ZQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),ngZd,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(20),n2h1(20))
  call Hloop_ZQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),ngZd,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(21),n2h1(21))
  call Hloop_WQ_A(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(22),n2h1(22))
  call Hloop_SQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),ngH,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(23),n2h1(23))
  call Hloop_SQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),ngX,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(24),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(25),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(25),n2h1(25))
  call Hloop_ZQ_A(ntryL,G1H2(26),ex3(:),G1H1(1),ngZd,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(26),n2h1(26))
  call ol_merge_tensors(G2tensor(9),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(6)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(14)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(16)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(17)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(24)])
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(1),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(1),mass4set(:,4),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(1),mass4set(:,5),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(1),mass4set(:,6),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(1),mass4set(:,7),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(1),mass4set(:,8),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(1),mass4set(:,9),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(2),mass4set(:,1),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),4)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(2),mass4set(:,3),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(2),mass4set(:,2),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),4)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(2),mass4set(:,4),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(2),mass4set(:,10),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),4)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(2),mass4set(:,7),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),4)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(2),mass4set(:,8),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),4)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(2),mass4set(:,5),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(2),mass4set(:,6),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),4)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(2),mass4set(:,9),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(1),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(1),mass4set(:,4),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(1),mass4set(:,5),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(1),mass4set(:,6),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,7),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(1),mass4set(:,8),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(1),mass4set(:,9),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(2),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(2),mass4set(:,3),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(2),mass4set(:,2),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(2),mass4set(:,4),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(2),mass4set(:,10),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(2),mass4set(:,7),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(2),mass4set(:,8),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(2),mass4set(:,5),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(2),mass4set(:,6),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(2),mass4set(:,9),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[8,3,4],[nMB,nMB,nMH],3,1,wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngH,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(2),ngX,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G0H8(2),8,nMB,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(3),ngPbt,m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G0H8(3),8,nMT,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[8,3,4],[nMB,nMB,nMH],3,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(4),ngH,m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G0H8(4),8,nMB,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),ngX,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMB,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(6),ngPbt,m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G0H8(6),8,nMT,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[8,3,4],[nMH,nMH,nMB],3,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(7),ngH,m3h2x8(:,43),heltab2x16(:,:,43))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[8,3,4],[nMZ,nMZ,nMB],3,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(8),ngX,m3h2x8(:,44),heltab2x16(:,:,44))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(9),ngPbt,m3h2x8(:,45),heltab2x16(:,:,45))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[8,3,4],[nMZ,nMH,nMB],3,1,wf4(:,3))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(10),ngX,m3h2x8(:,46),heltab2x16(:,:,46))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[8,3,4],[nMH,nMZ,nMB],3,1,wf4(:,3))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(11),ngH,m3h2x8(:,47),heltab2x16(:,:,47))
  Gcoeff(:)%j = (-(c(63)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[8,3,4],[nMB,nMB,0],3,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(12),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G0H8(12),8,nMB,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(13),ngZd,m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G0H8(13),8,nMB,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(14),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G0H8(14),8,nMT,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[8,3,4],[nMB,nMB,0],3,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(15),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G0H8(15),8,nMB,G1H8(10),n2h8(10))
  Gcoeff(:)%j = (c(63)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[8,3,4],[nMB,nMB,0],3,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(16),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G0H8(16),8,nMB,G1H8(11),n2h8(11))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(17),ngZd,m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G0H8(17),8,nMB,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(18),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G0H8(18),8,nMT,G1H8(13),n2h8(13))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[8,3,4],[nMB,nMB,0],3,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(19),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G0H8(19),8,nMB,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[8,3,4],[nMZ,nMZ,nMB],3,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(20),ngZd,m3h2x8(:,56),heltab2x16(:,:,56))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(21),m3h2x8(:,57),heltab2x16(:,:,57))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[8,3,4],[nMZ,nMH,nMB],3,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(22),ngZd,m3h2x8(:,58),heltab2x16(:,:,58))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(23),m3h2x8(:,59),heltab2x16(:,:,59))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[8,3,4],[nMZ,nMZ,nMB],3,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(24),ngX,m3h2x8(:,60),heltab2x16(:,:,60))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(61),h0tab(:,61),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(25),ngPbt,m3h2x8(:,61),heltab2x16(:,:,61))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(62),h0tab(:,62),[8,3,4],[nMH,nMZ,nMB],3,1,wf4(:,3))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(26),ngH,m3h2x8(:,62),heltab2x16(:,:,62))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(63),h0tab(:,63),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,3))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(27),ngPbt,m3h2x8(:,63),heltab2x16(:,:,63))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(64),h0tab(:,64),[8,3,4],[nMZ,nMZ,nMB],3,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(28),ngZd,m3h2x8(:,64),heltab2x16(:,:,64))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(65),h0tab(:,65),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(29),m3h2x8(:,65),heltab2x16(:,:,65))
  Gcoeff(:)%j = (-(c(60)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(66),h0tab(:,66),[8,3,4],[nMB,nMB,nMH],3,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(30),ngH,m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G0H8(30),8,nMB,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (c(60)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(67),h0tab(:,67),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),ngX,m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMB,G1H8(16),n2h8(16))
  Gcoeff(:)%j = (-(c(58)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(68),h0tab(:,68),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),ngPbt,m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMT,G1H8(17),n2h8(17))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(69),h0tab(:,69),[8,3,4],[nMB,nMB,nMH],3,1,wf4(:,7))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(33),ngH,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G0H8(33),8,nMB,G1H8(18),n2h8(18))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(70),h0tab(:,70),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,7))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(34),ngX,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G0H8(34),8,nMB,G1H8(19),n2h8(19))
  Gcoeff(:)%j = (c(59)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(71),h0tab(:,71),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,7))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(35),ngPbt,m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G0H8(35),8,nMT,G1H8(20),n2h8(20))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(72),h0tab(:,72),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(36),ngPbt,m3h2x8(:,72),heltab2x16(:,:,72))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(73),h0tab(:,73),[8,3,4],[nMZ,nMH,nMB],3,1,wf4(:,7))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(1),ngX,m3h2x8(:,73),heltab2x16(:,:,73))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(74),h0tab(:,74),[8,3,4],[nMH,nMZ,nMB],3,1,wf4(:,7))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(2),ngH,m3h2x8(:,74),heltab2x16(:,:,74))
  Gcoeff(:)%j = (-(c(82)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(75),h0tab(:,75),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,7))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(3),ngPbt,m3h2x8(:,75),heltab2x16(:,:,75))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(76),h0tab(:,76),[8,3,4],[nMB,nMB,0],3,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G0H8(4),8,nMB,G1H8(21),n2h8(21))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(77),h0tab(:,77),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,5))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),ngZd,m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMB,G1H8(22),n2h8(22))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(78),h0tab(:,78),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G0H8(6),8,nMT,G1H8(23),n2h8(23))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(79),h0tab(:,79),[8,3,4],[nMB,nMB,0],3,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(12),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H8(12),8,nMB,G1H8(24),n2h8(24))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(80),h0tab(:,80),[8,3,4],[nMB,nMB,0],3,1,wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(13),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G0H8(13),8,nMB,G1H8(25),n2h8(25))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(81),h0tab(:,81),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,7))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(14),ngZd,m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G0H8(14),8,nMB,G1H8(26),n2h8(26))
  Gcoeff(:)%j = (c(49)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(82),h0tab(:,82),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,7))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(15),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G0H8(15),8,nMT,G1H8(27),n2h8(27))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(83),h0tab(:,83),[8,3,4],[nMB,nMB,0],3,1,wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(16),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G0H8(16),8,nMB,G1H8(28),n2h8(28))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(84),h0tab(:,84),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,84),heltab2x16(:,:,84))
  Gcoeff(:)%j = (-(c(54)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(85),h0tab(:,85),[8,3,4],[nMZ,nMH,nMB],3,1,wf4(:,7))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(18),ngZd,m3h2x8(:,85),heltab2x16(:,:,85))
  Gcoeff(:)%j = (-(c(73)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(86),h0tab(:,86),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,7))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(19),m3h2x8(:,86),heltab2x16(:,:,86))
  Gcoeff(:)%j = (c(49)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(87),h0tab(:,87),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(30),ngPbt,m3h2x8(:,87),heltab2x16(:,:,87))
  Gcoeff(:)%j = (-(c(54)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(88),h0tab(:,88),[8,3,4],[nMH,nMZ,nMB],3,1,wf4(:,7))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(31),ngH,m3h2x8(:,88),heltab2x16(:,:,88))
  Gcoeff(:)%j = (c(73)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(89),h0tab(:,89),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,7))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(32),ngPbt,m3h2x8(:,89),heltab2x16(:,:,89))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(90),h0tab(:,90),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(33),m3h2x8(:,90),heltab2x16(:,:,90))
  Gcoeff(:)%j = (c(35)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(91),h0tab(:,91),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,7))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(34),m3h2x8(:,91),heltab2x16(:,:,91))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(92),h0tab(:,92),[12,1,2],[nML,nMH,nML],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),ngH,m3h4x4(:,1),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G0H4(1),12,nML,G1H4(2),n2h4(37))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(93),h0tab(:,93),[12,1,2],[nML,nMZ,nML],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),ngH,m3h4x4(:,2),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G0H4(1),12,nML,G1H4(4),n2h4(38))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(94),h0tab(:,94),[12,1,2],[nML,nMH,nML],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngX,m3h4x4(:,3),heltab2x16(:,:,94))
  call Hloop_A_Q(ntryL,G0H4(1),12,nML,G1H4(10),n2h4(39))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(95),h0tab(:,95),[12,1,2],[nML,nMZ,nML],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngX,m3h4x4(:,4),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G0H4(1),12,nML,G1H4(12),n2h4(40))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(96),h0tab(:,96),[12,1,2],[nMH,nML,nMH],3,1,wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,5),heltab2x16(:,:,96))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(97),h0tab(:,97),[12,1,2],[nMZ,nML,nMZ],3,1,wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(2),m3h4x4(:,6),heltab2x16(:,:,97))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(98),h0tab(:,98),[12,1,2],[nMW,0,nMW],3,1,wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(3),m3h4x4(:,7),heltab2x16(:,:,98))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(99),h0tab(:,99),[12,1,2],[nMH,nML,nMZ],3,1,wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(4),m3h4x4(:,8),heltab2x16(:,:,99))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(100),h0tab(:,100),[12,1,2],[nMZ,nML,nMH],3,1,wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(5),m3h4x4(:,9),heltab2x16(:,:,100))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(101),h0tab(:,101),[12,1,2],[nML,0,nML],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(6),ngH,m3h4x4(:,10),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G0H4(6),12,nML,G1H4(19),n2h4(41))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(102),h0tab(:,102),[12,1,2],[nML,nMZ,nML],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(6),ngH,m3h4x4(:,11),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G0H4(6),12,nML,G1H4(20),n2h4(42))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(103),h0tab(:,103),[12,1,2],[nML,0,nML],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(6),ngX,m3h4x4(:,12),heltab2x16(:,:,103))
  call Hloop_A_Q(ntryL,G0H4(6),12,nML,G1H4(21),n2h4(43))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(104),h0tab(:,104),[12,1,2],[nML,nMZ,nML],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(6),ngX,m3h4x4(:,13),heltab2x16(:,:,104))
  call Hloop_A_Q(ntryL,G0H4(6),12,nML,G1H4(23),n2h4(44))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(105),h0tab(:,105),[12,1,2],[nMZ,nML,nMZ],3,1,wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(25),m3h4x4(:,14),heltab2x16(:,:,105))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(106),h0tab(:,106),[12,1,2],[nMW,0,nMW],3,1,wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(26),m3h4x4(:,15),heltab2x16(:,:,106))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(107),h0tab(:,107),[12,1,2],[nMH,nML,nMZ],3,1,wf4(:,4))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(1),m3h4x4(:,16),heltab2x16(:,:,107))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(108),h0tab(:,108),[12,1,2],[nMW,0,nMW],3,1,wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(7),m3h4x4(:,17),heltab2x16(:,:,108))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(109),h0tab(:,109),[12,1,2],[nMZ,nML,nMZ],3,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(3),m3h4x4(:,18),heltab2x16(:,:,109))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(110),h0tab(:,110),[12,1,2],[nMW,0,nMW],3,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(8),m3h4x4(:,19),heltab2x16(:,:,110))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(111),h0tab(:,111),[12,1,2],[nMZ,nML,nMH],3,1,wf4(:,4))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(5),m3h4x4(:,20),heltab2x16(:,:,111))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(112),h0tab(:,112),[12,1,2],[nMW,0,nMW],3,1,wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(6),m3h4x4(:,21),heltab2x16(:,:,112))
  Gcoeff(:)%j = (-(c(54)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(113),h0tab(:,113),[12,1,2],[nMZ,nML,nMZ],3,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(6),m3h4x4(:,22),heltab2x16(:,:,113))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(114),h0tab(:,114),[12,1,2],[nMW,0,nMW],3,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(7),m3h4x4(:,23),heltab2x16(:,:,114))
  Gcoeff(:)%j = (-(c(68)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(115),h0tab(:,115),[12,1,2],[nML,nMH,nML],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(8),m3h4x4(:,24),heltab2x16(:,:,115))
  call Hloop_A_Q(ntryL,G0H4(8),12,nML,G1H4(9),n2h4(45))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(116),h0tab(:,116),[12,1,2],[nML,nMZ,nML],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(8),m3h4x4(:,25),heltab2x16(:,:,116))
  call Hloop_A_Q(ntryL,G0H4(8),12,nML,G1H4(14),n2h4(46))
  Gcoeff(:)%j = (-(c(70)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(117),h0tab(:,117),[12,1,2],[nML,nMH,nML],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(8),ngZl,m3h4x4(:,26),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G0H4(8),12,nML,G1H4(11),n2h4(47))
  Gcoeff(:)%j = (c(70)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(118),h0tab(:,118),[12,1,2],[nML,nMZ,nML],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(8),ngZl,m3h4x4(:,27),heltab2x16(:,:,118))
  call Hloop_A_Q(ntryL,G0H4(8),12,nML,G1H4(16),n2h4(48))
  Gcoeff(:)%j = (-(c(71)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(119),h0tab(:,119),[12,1,2],[0,nMW,0],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(8),ngZn,m3h4x4(:,28),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G0H4(8),12,0,G1H4(13),n2h4(49))
  Gcoeff(:)%j = (c(69)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(120),h0tab(:,120),[12,1,2],[nMW,0,nMW],3,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(15),m3h4x4(:,29),heltab2x16(:,:,120))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(121),h0tab(:,121),[12,1,2],[nMH,nML,nMZ],3,1,wf4(:,8))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(17),m3h4x4(:,30),heltab2x16(:,:,121))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(122),h0tab(:,122),[12,1,2],[nMZ,nML,nMH],3,1,wf4(:,8))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(18),m3h4x4(:,31),heltab2x16(:,:,122))
  Gcoeff(:)%j = (c(85)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(123),h0tab(:,123),[12,1,2],[nMW,0,nMW],3,1,wf4(:,8))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(29),m3h4x4(:,32),heltab2x16(:,:,123))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(124),h0tab(:,124),[12,1,2],[nML,0,nML],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(8),m3h4x4(:,33),heltab2x16(:,:,124))
  call Hloop_A_Q(ntryL,G0H4(8),12,nML,G1H4(30),n2h4(50))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(125),h0tab(:,125),[12,1,2],[nML,nMZ,nML],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(8),m3h4x4(:,34),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G0H4(8),12,nML,G1H4(31),n2h4(51))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(126),h0tab(:,126),[12,1,2],[nML,0,nML],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(8),ngZl,m3h4x4(:,35),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G0H4(8),12,nML,G1H4(22),n2h4(52))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(127),h0tab(:,127),[12,1,2],[nML,nMZ,nML],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(8),ngZl,m3h4x4(:,36),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G0H4(8),12,nML,G1H4(34),n2h4(53))
  Gcoeff(:)%j = (c(49)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(128),h0tab(:,128),[12,1,2],[0,nMW,0],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(8),ngZn,m3h4x4(:,37),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G0H4(8),12,0,G1H4(24),n2h4(54))
  Gcoeff(:)%j = (c(56)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(129),h0tab(:,129),[12,1,2],[nMW,0,nMW],3,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(8),m3h4x4(:,38),heltab2x16(:,:,129))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(130),h0tab(:,130),[12,1,2],[nMH,nML,nMZ],3,1,wf4(:,8))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(9),m3h4x4(:,39),heltab2x16(:,:,130))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(131),h0tab(:,131),[12,1,2],[nMW,0,nMW],3,1,wf4(:,8))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(10),m3h4x4(:,40),heltab2x16(:,:,131))
  Gcoeff(:)%j = (c(56)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(132),h0tab(:,132),[12,1,2],[nMW,0,nMW],3,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,6),G0H4(11),m3h4x4(:,41),heltab2x16(:,:,132))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(133),h0tab(:,133),[12,1,2],[nMZ,nML,nMH],3,1,wf4(:,8))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,8),G0H4(12),m3h4x4(:,42),heltab2x16(:,:,133))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(134),h0tab(:,134),[12,1,2],[nMW,0,nMW],3,1,wf4(:,8))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,8),G0H4(13),m3h4x4(:,43),heltab2x16(:,:,134))
  Gcoeff(:)%j = (-(c(47)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(135),h0tab(:,135),[12,1,2],[nMW,0,nMW],3,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(35),m3h4x4(:,44),heltab2x16(:,:,135))
  Gcoeff(:)%j = (c(35)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(136),h0tab(:,136),[12,1,2],[nMW,0,nMW],3,1,wf4(:,8))
  call Hloop_UW_V(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(36),m3h4x4(:,45),heltab2x16(:,:,136))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(9),G1H4(10),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(14),G1H4(12),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(15),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(30),G1H4(21),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(31),G1H4(23),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(26),G0H4(10),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(8),G0H4(13),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(35),G0H4(7)])
  call Hloop_AS_Q(ntryL,G1H8(1),wf4(:,1),G1H2(1),ngH,m3h4x2(:,1),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(1),11,nMB,G2H2(1),n2h2(1))
  call Hloop_AS_Q(ntryL,G1H8(2),wf4(:,1),G1H2(2),ngH,m3h4x2(:,2),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(2),11,nMB,G2H2(2),n2h2(2))
  call Hloop_AS_Q(ntryL,G1H8(3),wf4(:,1),G1H2(3),ngH,m3h4x2(:,3),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(3),11,nMT,G2H2(3),n2h2(3))
  call Hloop_AS_Q(ntryL,G1H8(4),wf4(:,3),G1H2(4),ngX,m3h4x2(:,4),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(4),11,nMB,G2H2(4),n2h2(4))
  call Hloop_AS_Q(ntryL,G1H8(5),wf4(:,3),G1H2(5),ngX,m3h4x2(:,5),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(5),11,nMB,G2H2(5),n2h2(5))
  call Hloop_AS_Q(ntryL,G1H8(6),wf4(:,3),G1H2(6),ngX,m3h4x2(:,6),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(6),11,nMT,G2H2(6),n2h2(6))
  call Hloop_SS_S(ntryL,G0H8(7),wf4(:,1),G0H2(1),m3h4x2(:,7),heltab2x8(:,:,43))
  call Hloop_SS_S(ntryL,G0H8(8),wf4(:,1),G0H2(2),m3h4x2(:,8),heltab2x8(:,:,44))
  call Hloop_SS_S(ntryL,G0H8(9),wf4(:,1),G0H2(3),m3h4x2(:,9),heltab2x8(:,:,45))
  call Hloop_SS_S(ntryL,G0H8(10),wf4(:,3),G0H2(4),m3h4x2(:,10),heltab2x8(:,:,46))
  call Hloop_SS_S(ntryL,G0H8(11),wf4(:,3),G0H2(5),m3h4x2(:,11),heltab2x8(:,:,47))
  call Hloop_AS_Q(ntryL,G1H8(10),wf4(:,1),G1H2(7),ngH,m3h4x2(:,12),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(7),11,nMB,G2H2(7),n2h2(7))
  call Hloop_AS_Q(ntryL,G1H8(8),wf4(:,1),G1H2(8),ngH,m3h4x2(:,13),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(8),11,nMB,G2H2(8),n2h2(8))
  call Hloop_AS_Q(ntryL,G1H8(9),wf4(:,1),G1H2(9),ngH,m3h4x2(:,14),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(9),11,nMT,G2H2(9),n2h2(9))
  call Hloop_AS_Q(ntryL,G1H8(14),wf4(:,3),G1H2(10),ngX,m3h4x2(:,15),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(10),11,nMB,G2H2(10),n2h2(10))
  call Hloop_AS_Q(ntryL,G1H8(12),wf4(:,3),G1H2(11),ngX,m3h4x2(:,16),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(11),11,nMB,G2H2(11),n2h2(11))
  call Hloop_AS_Q(ntryL,G1H8(13),wf4(:,3),G1H2(12),ngX,m3h4x2(:,17),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(12),11,nMT,G2H2(12),n2h2(12))
  call Hloop_VT_S(ntryL,G0H8(20),8,wf4(:,1),3,G1H2(13),m3h4x2(:,18),heltab2x8(:,:,54))
  call Hloop_VT_S(ntryL,G0H8(21),8,wf4(:,1),3,G1H2(14),m3h4x2(:,19),heltab2x8(:,:,55))
  call Hloop_VS_T(ntryL,G0H8(22),8,wf4(:,3),3,G1H2(15),m3h4x2(:,20),heltab2x8(:,:,56))
  call Hloop_VT_S(ntryL,G0H8(23),8,wf4(:,3),3,G1H2(16),m3h4x2(:,21),heltab2x8(:,:,57))
  call Hloop_ST_V(ntryL,G0H8(24),8,wf4(:,1),3,G1H2(17),m3h4x2(:,22),heltab2x8(:,:,58))
  call Hloop_ST_V(ntryL,G0H8(25),8,wf4(:,1),3,G1H2(18),m3h4x2(:,23),heltab2x8(:,:,59))
  call Hloop_TS_V(ntryL,G0H8(26),8,wf4(:,3),3,G1H2(19),m3h4x2(:,24),heltab2x8(:,:,60))
  call Hloop_ST_V(ntryL,G0H8(27),8,wf4(:,3),3,G1H2(20),m3h4x2(:,25),heltab2x8(:,:,61))
  call Hloop_VS_V(ntryL,G0H8(28),wf4(:,1),G0H2(6),m3h4x2(:,26),heltab2x8(:,:,62))
  call Hloop_VS_V(ntryL,G0H8(29),wf4(:,1),G0H2(7),m3h4x2(:,27),heltab2x8(:,:,63))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,5),G1H2(21),m3h4x2(:,28),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(21),11,nMB,G2H2(13),n2h2(13))
  call Hloop_AV_Q(ntryL,G1H8(16),wf4(:,5),G1H2(22),m3h4x2(:,29),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(22),11,nMB,G2H2(14),n2h2(14))
  call Hloop_AV_Q(ntryL,G1H8(17),wf4(:,5),G1H2(23),m3h4x2(:,30),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(23),11,nMT,G2H2(15),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,7),G1H2(24),ngZd,m3h4x2(:,31),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(24),11,nMB,G2H2(16),n2h2(16))
  call Hloop_AZ_Q(ntryL,G1H8(19),wf4(:,7),G1H2(25),ngZd,m3h4x2(:,32),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMB,G2H2(17),n2h2(17))
  call Hloop_AZ_Q(ntryL,G1H8(20),wf4(:,7),G1H2(26),ngZu,m3h4x2(:,33),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(26),11,nMT,G2H2(18),n2h2(18))
  call Hloop_SV_T(ntryL,G0H8(36),8,wf4(:,5),3,G1H2(1),m3h4x2(:,34),heltab2x8(:,:,70))
  call Hloop_SV_T(ntryL,G0H8(1),8,wf4(:,7),3,G1H2(2),m3h4x2(:,35),heltab2x8(:,:,71))
  call Hloop_TV_S(ntryL,G0H8(2),8,wf4(:,7),3,G1H2(3),m3h4x2(:,36),heltab2x8(:,:,72))
  call Hloop_SV_T(ntryL,G0H8(3),8,wf4(:,7),3,G1H2(4),m3h4x2(:,37),heltab2x8(:,:,73))
  call Hloop_AV_Q(ntryL,G1H8(24),wf4(:,5),G1H2(5),m3h4x2(:,38),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(5),11,nMB,G2H2(19),n2h2(19))
  call Hloop_AV_Q(ntryL,G1H8(22),wf4(:,5),G1H2(6),m3h4x2(:,39),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(6),11,nMB,G2H2(20),n2h2(20))
  call Hloop_AV_Q(ntryL,G1H8(23),wf4(:,5),G1H2(7),m3h4x2(:,40),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(7),11,nMT,G2H2(21),n2h2(21))
  call Hloop_AZ_Q(ntryL,G1H8(28),wf4(:,7),G1H2(8),ngZd,m3h4x2(:,41),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(8),11,nMB,G2H2(22),n2h2(22))
  call Hloop_AZ_Q(ntryL,G1H8(26),wf4(:,7),G1H2(9),ngZd,m3h4x2(:,42),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(9),11,nMB,G2H2(23),n2h2(23))
  call Hloop_AZ_Q(ntryL,G1H8(27),wf4(:,7),G1H2(10),ngZu,m3h4x2(:,43),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(10),11,nMT,G2H2(24),n2h2(24))
  call Hloop_VV_S(ntryL,G0H8(17),wf4(:,5),G0H2(8),m3h4x2(:,44),heltab2x8(:,:,80))
  call Hloop_VV_S(ntryL,G0H8(18),wf4(:,7),G0H2(9),m3h4x2(:,45),heltab2x8(:,:,81))
  call Hloop_VV_S(ntryL,G0H8(19),wf4(:,7),G0H2(10),m3h4x2(:,46),heltab2x8(:,:,82))
  call Hloop_SV_V(ntryL,G0H8(30),wf4(:,5),G0H2(11),m3h4x2(:,47),heltab2x8(:,:,83))
  call Hloop_SV_V(ntryL,G0H8(31),wf4(:,7),G0H2(12),m3h4x2(:,48),heltab2x8(:,:,84))
  call Hloop_SV_V(ntryL,G0H8(32),wf4(:,7),G0H2(13),m3h4x2(:,49),heltab2x8(:,:,85))
  call Hloop_UW_V(ntryL,G0H8(33),8,wf4(:,5),3,G1H2(11),m3h4x2(:,50),heltab2x8(:,:,86))
  call Hloop_UW_V(ntryL,G0H8(34),8,wf4(:,7),3,G1H2(12),m3h4x2(:,51),heltab2x8(:,:,87))
  call Hloop_AQ_S(ntryL,G1H4(11),ex1(:),G1H2(21),ngH,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AQ_S(ntryL,G1H4(16),ex1(:),G1H2(22),ngX,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_SQ_A(ntryL,G0H4(1),ex1(:),G0H2(14),ngH,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G0H2(14),13,nML,G1H2(23),n2h2(25))
  call Hloop_SQ_A(ntryL,G0H4(2),ex1(:),G0H2(14),ngX,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G0H2(14),13,nML,G1H2(24),n2h2(26))
  call Hloop_SQ_A(ntryL,G1H4(29),ex1(:),G1H2(25),ngPnl,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(25),13,0,G2H2(25),n2h2(27))
  call Hloop_SQ_A(ntryL,G1H4(17),ex1(:),G1H2(26),ngH,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(26),13,nML,G2H2(26),n2h2(28))
  call Hloop_SQ_A(ntryL,G1H4(18),ex1(:),G1H2(5),ngX,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(5),13,nML,G2H2(27),n2h2(29))
  call Hloop_AQ_V(ntryL,G1H4(22),ex1(:),G1H2(6),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H4(34),ex1(:),G1H2(7),ngZl,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_SQ_A(ntryL,G1H4(25),ex1(:),G1H2(8),ngX,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(8),13,nML,G2H2(28),n2h2(30))
  call Hloop_SQ_A(ntryL,G1H4(7),ex1(:),G1H2(9),ngPnl,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(9),13,0,G2H2(29),n2h2(31))
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(10),ngH,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(10),13,nML,G2H2(30),n2h2(32))
  call Hloop_ZQ_A(ntryL,G1H4(3),ex1(:),G1H2(25),ngZl,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(25),13,nML,G2H2(31),n2h2(33))
  call Hloop_WQ_A(ntryL,G1H4(6),ex1(:),G1H2(26),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(26),13,0,G2H2(32),n2h2(34))
  call Hloop_ZQ_A(ntryL,G1H4(5),ex1(:),G1H2(5),ngZl,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(5),13,nML,G2H2(33),n2h2(35))
  call Hloop_ZQ_A(ntryL,G0H4(6),ex1(:),G0H2(14),ngZl,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G0H2(14),13,nML,G1H2(8),n2h2(36))
  call Hloop_WQ_A(ntryL,G1H4(36),ex1(:),G1H2(9),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(9),13,0,G2H2(34),n2h2(37))
  call Hloop_AQ_S(ntryL,G1H4(13),ex1(:),G1H2(10),ngPnl,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AQ_W(ntryL,G1H4(24),ex1(:),G1H2(25),m3h2x2(:,45),heltab2x4(:,:,45))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(13),G2H2(4),G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(14),G2H2(5),G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(15),G2H2(6),G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(1),G1H2(16),G1H2(14),G0H2(10),G0H2(8),G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(15),G0H2(9),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G0H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(19),G2H2(10),G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(20),G2H2(11),G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(21),G2H2(12),G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G0H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(11),G1H2(20),G1H2(18),G0H2(13),G0H2(11) &
    ,G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G0H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(29)])
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(3),ngH,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(4),ngX,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(6),ngPtb,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hloop_SQ_A(ntryL,G0H2(1),ex3(:),G0H1(1),ngH,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),15,nMB,G1tensor(1),n2h1(27))
  call Hloop_SQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),ngX,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(14),n2h1(28))
  call Hloop_SQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),ngPtb,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(16),n2h1(29))
  call Hloop_SQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngH,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(17),n2h1(30))
  call Hloop_SQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),ngX,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(24),n2h1(31))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(2),ngZd,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(24),ex3(:),G2tensor(9),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex3(:),G1H1(1),ngZd,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(10),n2h1(32))
  call Hloop_WQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(5),n2h1(33))
  call Hloop_ZQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),ngZd,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(12),n2h1(34))
  call Hloop_SA_Q(ntryL,G1H2(21),ex2(:),G1H1(1),ngH,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nML,G2tensor(7),n2h1(35))
  call Hloop_SA_Q(ntryL,G1H2(22),ex2(:),G1H1(1),ngX,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nML,G2tensor(8),n2h1(36))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H2(23),ex2(:),G1tensor(6),ngH,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(31),ex2(:),G2tensor(11),ngX,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(32),ex2(:),G2tensor(13),ngPln,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(26),ex2(:),G2tensor(20),ngX,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(33),ex2(:),G2tensor(15),ngH,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hloop_VA_Q(ntryL,G1H2(6),ex2(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nML,G2tensor(21),n2h1(37))
  call Hloop_ZA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),ngZl,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nML,G2tensor(22),n2h1(38))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(28),ex2(:),G2tensor(18),ngZl,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(34),ex2(:),G2tensor(19),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(30),ex2(:),G2tensor(23),ngZl,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hloop_SA_Q(ntryL,G1H2(10),ex2(:),G1H1(1),ngPln,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(26),n2h1(39))
  call Hloop_WA_Q(ntryL,G1H2(25),ex2(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(25),n2h1(40))
  call ol_merge_tensors(G1tensor(2),[G0tensor(2)])
  call ol_merge_tensors(G1tensor(23),[G1tensor(8),G1tensor(3),G0tensor(23),G0tensor(8),G0tensor(3)])
  call ol_merge_tensors(G1tensor(1),[G1tensor(49),G1tensor(4),G0tensor(49),G0tensor(4)])
  call ol_merge_tensors(G1tensor(35),[G1tensor(15),G1tensor(5),G0tensor(35),G0tensor(15),G0tensor(5)])
  call ol_merge_tensors(G1tensor(7),[G0tensor(7)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(59),G1tensor(9),G0tensor(59),G0tensor(9)])
  call ol_merge_tensors(G1tensor(40),[G1tensor(20),G1tensor(10),G0tensor(40),G0tensor(20),G0tensor(10)])
  call ol_merge_tensors(G1tensor(12),[G0tensor(12)])
  call ol_merge_tensors(G1tensor(28),[G1tensor(18),G1tensor(13),G0tensor(28),G0tensor(18),G0tensor(13)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(24),G1tensor(54),G1tensor(14),G0tensor(54),G0tensor(14)])
  call ol_merge_tensors(G1tensor(17),[G0tensor(17)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(14),G1tensor(64),G1tensor(19),G0tensor(64),G0tensor(19)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(22)])
  call ol_merge_tensors(G1tensor(84),[G1tensor(24),G0tensor(84),G0tensor(24)])
  call ol_merge_tensors(G1tensor(45),[G1tensor(30),G1tensor(25),G0tensor(45),G0tensor(30),G0tensor(25)])
  call ol_merge_tensors(G1tensor(27),[G0tensor(27)])
  call ol_merge_tensors(G1tensor(89),[G1tensor(29),G0tensor(89),G0tensor(29)])
  call ol_merge_tensors(G1tensor(32),[G0tensor(32)])
  call ol_merge_tensors(G1tensor(43),[G1tensor(38),G1tensor(33),G0tensor(43),G0tensor(38),G0tensor(33)])
  call ol_merge_tensors(G1tensor(74),[G1tensor(34),G0tensor(74),G0tensor(34)])
  call ol_merge_tensors(G1tensor(37),[G0tensor(37)])
  call ol_merge_tensors(G1tensor(79),[G1tensor(39),G0tensor(79),G0tensor(39)])
  call ol_merge_tensors(G1tensor(42),[G0tensor(42)])
  call ol_merge_tensors(G1tensor(94),[G1tensor(44),G0tensor(94),G0tensor(44)])
  call ol_merge_tensors(G1tensor(6),[G1tensor(47),G0tensor(47)])
  call ol_merge_tensors(G1tensor(83),[G1tensor(58),G1tensor(48),G0tensor(83),G0tensor(58),G0tensor(48)])
  call ol_merge_tensors(G1tensor(75),[G1tensor(55),G1tensor(50),G0tensor(75),G0tensor(55),G0tensor(50)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(20),G1tensor(52),G0tensor(52)])
  call ol_merge_tensors(G1tensor(88),[G1tensor(63),G1tensor(53),G0tensor(88),G0tensor(63),G0tensor(53)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(57),G0tensor(57)])
  call ol_merge_tensors(G1tensor(80),[G1tensor(65),G1tensor(60),G0tensor(80),G0tensor(65),G0tensor(60)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(11),G1tensor(62),G0tensor(62)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(13),G1tensor(67),G0tensor(67)])
  call ol_merge_tensors(G1tensor(68),[G0tensor(68)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(16),G1tensor(69),G0tensor(69)])
  call ol_merge_tensors(G1tensor(70),[G0tensor(70)])
  call ol_merge_tensors(G1tensor(72),[G0tensor(72)])
  call ol_merge_tensors(G1tensor(93),[G1tensor(78),G1tensor(73),G0tensor(93),G0tensor(78),G0tensor(73)])
  call ol_merge_tensors(G1tensor(77),[G0tensor(77)])
  call ol_merge_tensors(G1tensor(82),[G0tensor(82)])
  call ol_merge_tensors(G1tensor(95),[G1tensor(90),G1tensor(85),G0tensor(95),G0tensor(90),G0tensor(85)])
  call ol_merge_tensors(G1tensor(87),[G0tensor(87)])
  call ol_merge_tensors(G1tensor(92),[G0tensor(92)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(6)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(8)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(26)])
  call TI_triangle_red(G2tensor(17),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11), &
    G0tensor(16),M2L1R1,[nMB,nMZ,nMH],G0tensor(21),G0tensor(26),G0tensor(31))
  call TI_triangle_red(G2tensor(12),RedBasis(2),mass3set(:,2),G0tensor(36),G0tensor(41),G0tensor(46), &
    G0tensor(51),M2L1R1,[nMB,nMH,nMZ],G0tensor(56),G0tensor(61),G0tensor(66))
  call TI_triangle_red(G2tensor(10),RedBasis(2),mass3set(:,3),G0tensor(71),G0tensor(76),G0tensor(81), &
    G0tensor(86),M2L1R1,[nMB,nMZ],G0tensor(91),G0tensor(2))
  call TI_triangle_red(G2tensor(23),RedBasis(6),mass3set(:,4),G0tensor(23),G0tensor(8),G0tensor(3), &
    G0tensor(49),M2L1R1,[nMZ,nMH,nML],G0tensor(4),G0tensor(35),G0tensor(15))
  call TI_triangle_red(G2tensor(15),RedBasis(6),mass3set(:,5),G0tensor(5),G0tensor(7),G0tensor(59), &
    G0tensor(9),M2L1R1,[nMH,nMZ,nML],G0tensor(40),G0tensor(20),G0tensor(10))
  call TI_triangle_red(G2tensor(18),RedBasis(6),mass3set(:,6),G0tensor(12),G0tensor(28),G0tensor(18), &
    G0tensor(13),M2L1R1,[nMZ,nML],G0tensor(54),G0tensor(14))
  call TI_triangle_red(G2tensor(19),RedBasis(6),mass3set(:,7),G0tensor(17),G0tensor(64),G0tensor(19),G0tensor(22),M2L1R1,[nMW], &
    G0tensor(84))
  call TI_triangle_red(G2tensor(5),RedBasis(2),mass3set(:,8),G0tensor(24),G0tensor(45),G0tensor(30),G0tensor(25),M2L1R1,[nMT,nMW], &
    G0tensor(27),G0tensor(89))
  call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,9),G0tensor(29),G0tensor(32),G0tensor(43),G0tensor(38),M2L1R1,[nMH,nMB], &
    G0tensor(33),G0tensor(74))
  call TI_triangle_red(G2tensor(2),RedBasis(2),mass3set(:,10),G0tensor(34),G0tensor(37),G0tensor(79), &
    G0tensor(39),M2L1R1,[nMZ,nMB],G0tensor(42),G0tensor(94))
  call TI_triangle_red(G2tensor(9),RedBasis(2),mass3set(:,11),G0tensor(44),G0tensor(47),G0tensor(83), &
    G0tensor(58),M2L1R1,[nMW,nMT],G0tensor(48),G0tensor(75))
  call TI_triangle_red(G2tensor(1),RedBasis(2),mass3set(:,12),G0tensor(55),G0tensor(50),G0tensor(52),G0tensor(88),M2L1R1,[nMB], &
    G0tensor(63))
  call TI_triangle_red(G2tensor(7),RedBasis(6),mass3set(:,13),G0tensor(53),G0tensor(57),G0tensor(80), &
    G0tensor(65),M2L1R1,[nML,nMH],G0tensor(60),G0tensor(62))
  call TI_triangle_red(G2tensor(22),RedBasis(6),mass3set(:,14),G0tensor(67),G0tensor(68),G0tensor(69), &
    G0tensor(70),M2L1R1,[nML,nMZ],G0tensor(72),G0tensor(93))
  call TI_triangle_red(G2tensor(21),RedBasis(6),mass3set(:,15),G0tensor(78),G0tensor(73),G0tensor(77),G0tensor(82),M2L1R1,[nML], &
    G0tensor(95))
  call TI_triangle_red(G2tensor(25),RedBasis(6),mass3set(:,16),G0tensor(90),G0tensor(85),G0tensor(87),G0tensor(92),M2L1R1,[nMW], &
    G0tensor(96))
  call TI_triangle_red(G1tensor(2),RedBasis(7),mass3set(:,17),G0tensor(97),G0tensor(98),G0tensor(99), &
    G0tensor(100),M2L1R1,[nMH,nML],G0tensor(101),G0tensor(102))
  call TI_triangle_red(G1tensor(23),RedBasis(3),mass3set(:,18),G0tensor(103),G0tensor(104),G0tensor(105), &
    G0tensor(106),M2L1R1,[nMB,nML,nMH],G0tensor(107),G0tensor(108),G0tensor(109))
  call TI_triangle_red(G1tensor(1),RedBasis(2),mass3set(:,19),G0tensor(110),G0tensor(111),G0tensor(112), &
    G0tensor(113),M2L1R1,[nMB,nMH],G0tensor(114),G0tensor(115))
  call TI_triangle_red(G1tensor(35),RedBasis(1),mass3set(:,20),G0tensor(116),G0tensor(117),G0tensor(118), &
    G0tensor(119),M2L1R1,[nMB,nMH,nML],G0tensor(120),G0tensor(121),G0tensor(122))
  call TI_triangle_red(G1tensor(7),RedBasis(7),mass3set(:,5),G0tensor(123),G0tensor(124),G0tensor(125), &
    G0tensor(126),M2L1R1,[nMH,nMZ,nML],G0tensor(127),G0tensor(128),G0tensor(129))
  call TI_triangle_red(G1tensor(40),RedBasis(1),mass3set(:,21),G0tensor(130),G0tensor(131),G0tensor(132), &
    G0tensor(133),M2L1R1,[nMB,nMZ,nML],G0tensor(134),G0tensor(135),G0tensor(136))
  call TI_triangle_red(G1tensor(12),RedBasis(7),mass3set(:,4),G0tensor(137),G0tensor(138),G0tensor(139), &
    G0tensor(140),M2L1R1,[nMZ,nMH,nML],G0tensor(141),G0tensor(142),G0tensor(143))
  call TI_triangle_red(G1tensor(28),RedBasis(3),mass3set(:,22),G0tensor(144),G0tensor(145),G0tensor(146), &
    G0tensor(147),M2L1R1,[nMB,nML,nMZ],G0tensor(148),G0tensor(149),G0tensor(150))
  call TI_triangle_red(G1tensor(17),RedBasis(7),mass3set(:,6),G0tensor(151),G0tensor(152),G0tensor(153), &
    G0tensor(154),M2L1R1,[nMZ,nML],G0tensor(155),G0tensor(156))
  call TI_triangle_red(G1tensor(22),RedBasis(7),mass3set(:,23),G0tensor(157),G0tensor(158),G0tensor(159), &
    G0tensor(160),M2L1R1,[nMH,nML],G0tensor(161),G0tensor(162))
  call TI_triangle_red(G1tensor(84),RedBasis(2),mass3set(:,24),G0tensor(163),G0tensor(164),G0tensor(165), &
    G0tensor(166),M2L1R1,[nMB,nMH],G0tensor(167),G0tensor(168))
  call TI_triangle_red(G1tensor(45),RedBasis(1),mass3set(:,25),G0tensor(169),G0tensor(170),G0tensor(171), &
    G0tensor(172),M2L1R1,[nMB,nML],G0tensor(173),G0tensor(174))
  call TI_triangle_red(G1tensor(27),RedBasis(7),mass3set(:,26),G0tensor(175),G0tensor(176),G0tensor(177), &
    G0tensor(178),M2L1R1,[nMZ,nML],G0tensor(179),G0tensor(180))
  call TI_triangle_red(G1tensor(89),RedBasis(2),mass3set(:,27),G0tensor(181),G0tensor(182),G0tensor(183), &
    G0tensor(184),M2L1R1,[nMB,nMZ],G0tensor(185),G0tensor(186))
  call TI_triangle_red(G1tensor(32),RedBasis(7),mass3set(:,28),G0tensor(187),G0tensor(188),G0tensor(189), &
    G0tensor(190),M2L1R1,[nMH,nML],G0tensor(191),G0tensor(192))
  call TI_triangle_red(G1tensor(43),RedBasis(3),mass3set(:,29),G0tensor(193),G0tensor(194),G0tensor(195), &
    G0tensor(196),M2L1R1,[nMB,nML],G0tensor(197),G0tensor(198))
  call TI_triangle_red(G1tensor(74),RedBasis(2),mass3set(:,30),G0tensor(199),G0tensor(200),G0tensor(201), &
    G0tensor(202),M2L1R1,[nMB,nMH],G0tensor(203),G0tensor(204))
  call TI_triangle_red(G1tensor(37),RedBasis(7),mass3set(:,31),G0tensor(205),G0tensor(206),G0tensor(207), &
    G0tensor(208),M2L1R1,[nMZ,nML],G0tensor(209),G0tensor(210))
  call TI_triangle_red(G1tensor(79),RedBasis(2),mass3set(:,32),G0tensor(211),G0tensor(212),G0tensor(213), &
    G0tensor(214),M2L1R1,[nMB,nMZ],G0tensor(215),G0tensor(216))
  call TI_triangle_red(G1tensor(42),RedBasis(7),mass3set(:,33),G0tensor(217),G0tensor(218),G0tensor(219), &
    G0tensor(220),M2L1R1,[nML],G0tensor(221))
  call TI_triangle_red(G1tensor(94),RedBasis(2),mass3set(:,34),G0tensor(222),G0tensor(223),G0tensor(224), &
    G0tensor(225),M2L1R1,[nMB],G0tensor(226))
  call TI_triangle_red(G1tensor(6),RedBasis(6),mass3set(:,17),G0tensor(227),G0tensor(228),G0tensor(229), &
    G0tensor(230),M2L1R1,[nMH,nML],G0tensor(231),G0tensor(232))
  call TI_triangle_red(G1tensor(83),RedBasis(5),mass3set(:,18),G0tensor(233),G0tensor(234),G0tensor(235), &
    G0tensor(236),M2L1R1,[nMB,nML,nMH],G0tensor(237),G0tensor(238),G0tensor(239))
  call TI_triangle_red(G1tensor(75),RedBasis(4),mass3set(:,20),G0tensor(240),G0tensor(241),G0tensor(242), &
    G0tensor(243),M2L1R1,[nMB,nMH,nML],G0tensor(244),G0tensor(245),G0tensor(246))
  call TI_triangle_red(G1tensor(88),RedBasis(5),mass3set(:,22),G0tensor(247),G0tensor(248),G0tensor(249), &
    G0tensor(250),M2L1R1,[nMB,nML,nMZ],G0tensor(251),G0tensor(252),G0tensor(253))
  call TI_triangle_red(G1tensor(80),RedBasis(4),mass3set(:,21),G0tensor(254),G0tensor(255),G0tensor(256), &
    G0tensor(257),M2L1R1,[nMB,nMZ,nML],G0tensor(258),G0tensor(259),G0tensor(260))
  call TI_triangle_red(G1tensor(68),RedBasis(5),mass3set(:,35),G0tensor(261),G0tensor(262),G0tensor(263), &
    G0tensor(264),M2L1R1,[nMT,nMW],G0tensor(265),G0tensor(266))
  call TI_triangle_red(G1tensor(70),RedBasis(4),mass3set(:,36),G0tensor(267),G0tensor(268),G0tensor(269), &
    G0tensor(270),M2L1R1,[nMT,nMW],G0tensor(271),G0tensor(272))
  call TI_triangle_red(G1tensor(72),RedBasis(6),mass3set(:,28),G0tensor(273),G0tensor(274),G0tensor(275), &
    G0tensor(276),M2L1R1,[nMH,nML],G0tensor(277),G0tensor(278))
  call TI_triangle_red(G1tensor(93),RedBasis(5),mass3set(:,29),G0tensor(279),G0tensor(280),G0tensor(281), &
    G0tensor(282),M2L1R1,[nMB,nML],G0tensor(283),G0tensor(284))
  call TI_triangle_red(G1tensor(77),RedBasis(6),mass3set(:,31),G0tensor(285),G0tensor(286),G0tensor(287), &
    G0tensor(288),M2L1R1,[nMZ,nML],G0tensor(289),G0tensor(290))
  call TI_triangle_red(G1tensor(82),RedBasis(6),mass3set(:,23),G0tensor(291),G0tensor(292),G0tensor(293), &
    G0tensor(294),M2L1R1,[nMH,nML],G0tensor(295),G0tensor(296))
  call TI_triangle_red(G1tensor(95),RedBasis(4),mass3set(:,25),G0tensor(297),G0tensor(298),G0tensor(299), &
    G0tensor(300),M2L1R1,[nMB,nML],G0tensor(301),G0tensor(302))
  call TI_triangle_red(G1tensor(87),RedBasis(6),mass3set(:,26),G0tensor(303),G0tensor(304),G0tensor(305), &
    G0tensor(306),M2L1R1,[nMZ,nML],G0tensor(307),G0tensor(308))
  call TI_triangle_red(G1tensor(92),RedBasis(6),mass3set(:,33),G0tensor(309),G0tensor(310),G0tensor(311), &
    G0tensor(312),M2L1R1,[nML],G0tensor(313))
  call ol_merge_tensors(T0sum(20),[G0tensor(97)])
  call ol_merge_tensors(T0sum(21),[G0tensor(103)])
  call ol_merge_tensors(T0sum(22),[G0tensor(110)])
  call ol_merge_tensors(T0sum(23),[G0tensor(116)])
  call ol_merge_tensors(T0sum(24),[G0tensor(123)])
  call ol_merge_tensors(T0sum(25),[G0tensor(1)])
  call ol_merge_tensors(T0sum(26),[G0tensor(130)])
  call ol_merge_tensors(T0sum(27),[G0tensor(137)])
  call ol_merge_tensors(T0sum(28),[G0tensor(144)])
  call ol_merge_tensors(T0sum(29),[G0tensor(36)])
  call ol_merge_tensors(T0sum(30),[G0tensor(151)])
  call ol_merge_tensors(T0sum(31),[G0tensor(71)])
  call ol_merge_tensors(T0sum(32),[G0tensor(157)])
  call ol_merge_tensors(T0sum(33),[G0tensor(163)])
  call ol_merge_tensors(T0sum(34),[G0tensor(169)])
  call ol_merge_tensors(T0sum(35),[G0tensor(175)])
  call ol_merge_tensors(T0sum(36),[G0tensor(181)])
  call ol_merge_tensors(T0sum(37),[G0tensor(187)])
  call ol_merge_tensors(T0sum(38),[G0tensor(193)])
  call ol_merge_tensors(T0sum(39),[G0tensor(199)])
  call ol_merge_tensors(T0sum(40),[G0tensor(205)])
  call ol_merge_tensors(T0sum(41),[G0tensor(211)])
  call ol_merge_tensors(T0sum(42),[G0tensor(217)])
  call ol_merge_tensors(T0sum(43),[G0tensor(222)])
  call ol_merge_tensors(T0sum(44),[G0tensor(227)])
  call ol_merge_tensors(T0sum(45),[G0tensor(233)])
  call ol_merge_tensors(T0sum(46),[G0tensor(240)])
  call ol_merge_tensors(T0sum(47),[G0tensor(23)])
  call ol_merge_tensors(T0sum(48),[G0tensor(247)])
  call ol_merge_tensors(T0sum(49),[G0tensor(5)])
  call ol_merge_tensors(T0sum(50),[G0tensor(254)])
  call ol_merge_tensors(T0sum(51),[G0tensor(12)])
  call ol_merge_tensors(T0sum(52),[G0tensor(17)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(24)])
  call ol_merge_tensors(T0sum(55),[G0tensor(267)])
  call ol_merge_tensors(T0sum(56),[G0tensor(273)])
  call ol_merge_tensors(T0sum(57),[G0tensor(279)])
  call ol_merge_tensors(T0sum(58),[G0tensor(285)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(297)])
  call ol_merge_tensors(T0sum(61),[G0tensor(303)])
  call ol_merge_tensors(T0sum(62),[G0tensor(309)])
  call ol_merge_tensors(T0sum(63),[G0tensor(29)])
  call ol_merge_tensors(T0sum(64),[G0tensor(34)])
  call ol_merge_tensors(T0sum(65),[G0tensor(44)])
  call ol_merge_tensors(T0sum(66),[G0tensor(55)])
  call ol_merge_tensors(T0sum(67),[G0tensor(53)])
  call ol_merge_tensors(T0sum(68),[G0tensor(67)])
  call ol_merge_tensors(T0sum(69),[G0tensor(78)])
  call ol_merge_tensors(T0sum(70),[G0tensor(90)])
  Gcoeff(:)%j = (-(c(105)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(137),h0tab(:,137),[12,3],[nME,nME],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(3),ngH,m3h4x4(:,46),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G0H4(3),12,nME,G1H4(27),n2h4(55))
  Gcoeff(:)%j = (-(c(107)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(138),h0tab(:,138),[12,3],[nMM,nMM],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(4),ngH,m3h4x4(:,47),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G0H4(4),12,nMM,G1H4(28),n2h4(56))
  Gcoeff(:)%j = (-(c(106)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(139),h0tab(:,139),[12,3],[nML,nML],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(5),ngH,m3h4x4(:,48),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G0H4(5),12,nML,G1H4(32),n2h4(57))
  Gcoeff(:)%j = (-(c(108)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(140),h0tab(:,140),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,49),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMT,G1H4(33),n2h4(58))
  Gcoeff(:)%j = (-(c(104)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(141),h0tab(:,141),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(8),ngH,m3h4x4(:,50),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G0H4(8),12,nMB,G1H4(9),n2h4(59))
  Gcoeff(:)%j = (c(105)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(142),h0tab(:,142),[12,3],[nME,nME],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(9),ngX,m3h4x4(:,51),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G0H4(9),12,nME,G1H4(10),n2h4(60))
  Gcoeff(:)%j = (c(107)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(143),h0tab(:,143),[12,3],[nMM,nMM],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(13),ngX,m3h4x4(:,52),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G0H4(13),12,nMM,G1H4(2),n2h4(61))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(144),h0tab(:,144),[12,3],[nML,nML],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(11),ngX,m3h4x4(:,53),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G0H4(11),12,nML,G1H4(14),n2h4(62))
  Gcoeff(:)%j = (-(c(108)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(145),h0tab(:,145),[12,3],[nMT,nMT],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(12),ngX,m3h4x4(:,54),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G0H4(12),12,nMT,G1H4(12),n2h4(63))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(146),h0tab(:,146),[12,3],[nMB,nMB],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(7),ngX,m3h4x4(:,55),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G0H4(7),12,nMB,G1H4(4),n2h4(64))
  Gcoeff(:)%j = (c(105)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(147),h0tab(:,147),[12,3],[nME,nME],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),ngH,m3h4x4(:,56),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G0H4(1),12,nME,G1H4(15),n2h4(65))
  Gcoeff(:)%j = (c(107)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(148),h0tab(:,148),[12,3],[nMM,nMM],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(2),ngH,m3h4x4(:,57),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G0H4(2),12,nMM,G1H4(30),n2h4(66))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(149),h0tab(:,149),[12,3],[nML,nML],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(6),ngH,m3h4x4(:,58),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G0H4(6),12,nML,G1H4(21),n2h4(67))
  Gcoeff(:)%j = (-(c(108)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(150),h0tab(:,150),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(3),ngH,m3h4x4(:,59),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G0H4(3),12,nMT,G1H4(19),n2h4(68))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(151),h0tab(:,151),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(4),ngH,m3h4x4(:,60),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G0H4(4),12,nMB,G1H4(31),n2h4(69))
  Gcoeff(:)%j = (-(c(105)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(152),h0tab(:,152),[12,3],[nME,nME],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(5),ngX,m3h4x4(:,61),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G0H4(5),12,nME,G1H4(23),n2h4(70))
  Gcoeff(:)%j = (-(c(107)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(153),h0tab(:,153),[12,3],[nMM,nMM],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,62),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMM,G1H4(20),n2h4(71))
  Gcoeff(:)%j = (-(c(106)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(154),h0tab(:,154),[12,3],[nML,nML],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(8),ngX,m3h4x4(:,63),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G0H4(8),12,nML,G1H4(26),n2h4(72))
  Gcoeff(:)%j = (-(c(108)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(155),h0tab(:,155),[12,3],[nMT,nMT],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(9),ngX,m3h4x4(:,64),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G0H4(9),12,nMT,G1H4(8),n2h4(73))
  Gcoeff(:)%j = (-(c(104)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(156),h0tab(:,156),[12,3],[nMB,nMB],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(13),ngX,m3h4x4(:,65),heltab2x16(:,:,156))
  call Hloop_Q_A(ntryL,G0H4(13),12,nMB,G1H4(35),n2h4(74))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(157),h0tab(:,157),[12,3],[nMH,nMH],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(11),m3h4x4(:,66),heltab2x16(:,:,157))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(158),h0tab(:,158),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(12),m3h4x4(:,67),heltab2x16(:,:,158))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(159),h0tab(:,159),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(7),m3h4x4(:,68),heltab2x16(:,:,159))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(160),h0tab(:,160),[12,3],[nMH,nMZ],2,2,wf4(:,4),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(1),m3h4x4(:,69),heltab2x16(:,:,160))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(161),h0tab(:,161),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(2),m3h4x4(:,70),heltab2x16(:,:,161))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(162),h0tab(:,162),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(6),m3h4x4(:,71),heltab2x16(:,:,162))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(163),h0tab(:,163),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(3),m3h4x4(:,72),heltab2x16(:,:,163))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(164),h0tab(:,164),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(4),m3h4x4(:,73),heltab2x16(:,:,164))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(165),h0tab(:,165),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(5),m3h4x4(:,74),heltab2x16(:,:,165))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(166),h0tab(:,166),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(10),m3h4x4(:,75),heltab2x16(:,:,166))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(167),h0tab(:,167),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(8),m3h4x4(:,76),heltab2x16(:,:,167))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(168),h0tab(:,168),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(9),m3h4x4(:,77),heltab2x16(:,:,168))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(169),h0tab(:,169),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(13),m3h4x4(:,78),heltab2x16(:,:,169))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(170),h0tab(:,170),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(14),m3h4x4(:,79),heltab2x16(:,:,170))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(171),h0tab(:,171),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(15),m3h4x4(:,80),heltab2x16(:,:,171))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(172),h0tab(:,172),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(11),m3h4x4(:,81),heltab2x16(:,:,172))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(173),h0tab(:,173),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(16),m3h4x4(:,82),heltab2x16(:,:,173))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(174),h0tab(:,174),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(29),m3h4x4(:,83),heltab2x16(:,:,174))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(175),h0tab(:,175),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(17),m3h4x4(:,84),heltab2x16(:,:,175))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(176),h0tab(:,176),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(18),m3h4x4(:,85),heltab2x16(:,:,176))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(177),h0tab(:,177),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(22),m3h4x4(:,86),heltab2x16(:,:,177))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(178),h0tab(:,178),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(34),m3h4x4(:,87),heltab2x16(:,:,178))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(179),h0tab(:,179),[12,3],[nMH,nMZ],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(25),m3h4x4(:,88),heltab2x16(:,:,179))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(180),h0tab(:,180),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(7),m3h4x4(:,89),heltab2x16(:,:,180))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(181),h0tab(:,181),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(1),m3h4x4(:,90),heltab2x16(:,:,181))
  Gcoeff(:)%j = (c(115)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(182),h0tab(:,182),[12,3],[nME,nME],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,91),heltab2x16(:,:,182))
  call Hloop_Q_A(ntryL,G0H4(16),12,nME,G1H4(3),n2h4(75))
  Gcoeff(:)%j = (c(120)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(183),h0tab(:,183),[12,3],[nMM,nMM],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,92),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMM,G1H4(6),n2h4(76))
  Gcoeff(:)%j = (c(117)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(184),h0tab(:,184),[12,3],[nML,nML],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,93),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G0H4(16),12,nML,G1H4(5),n2h4(77))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(185),h0tab(:,185),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,94),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMT,G1H4(36),n2h4(78))
  Gcoeff(:)%j = (c(112)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(186),h0tab(:,186),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,95),heltab2x16(:,:,186))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMB,G1H4(13),n2h4(79))
  Gcoeff(:)%j = (c(116)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(187),h0tab(:,187),[12,3],[nME,nME],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(16),ngZl,m3h4x4(:,96),heltab2x16(:,:,187))
  call Hloop_Q_A(ntryL,G0H4(16),12,nME,G1H4(24),n2h4(80))
  Gcoeff(:)%j = (c(121)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(188),h0tab(:,188),[12,3],[nMM,nMM],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(16),ngZl,m3h4x4(:,97),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMM,G1H4(37),n2h4(81))
  Gcoeff(:)%j = (c(118)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(189),h0tab(:,189),[12,3],[nML,nML],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(16),ngZl,m3h4x4(:,98),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G0H4(16),12,nML,G1H4(38),n2h4(82))
  Gcoeff(:)%j = (c(125)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(190),h0tab(:,190),[12,3],[nMT,nMT],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(16),ngZu,m3h4x4(:,99),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMT,G1H4(39),n2h4(83))
  Gcoeff(:)%j = (c(114)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(191),h0tab(:,191),[12,3],[nMB,nMB],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(16),ngZd,m3h4x4(:,100),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMB,G1H4(40),n2h4(84))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(192),h0tab(:,192),[12,3],[nME,nME],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,101),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G0H4(16),12,nME,G1H4(41),n2h4(85))
  Gcoeff(:)%j = (-(c(120)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(193),h0tab(:,193),[12,3],[nMM,nMM],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,102),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMM,G1H4(42),n2h4(86))
  Gcoeff(:)%j = (-(c(117)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(194),h0tab(:,194),[12,3],[nML,nML],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,103),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G0H4(16),12,nML,G1H4(43),n2h4(87))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(195),h0tab(:,195),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,104),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMT,G1H4(44),n2h4(88))
  Gcoeff(:)%j = (-(c(112)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(196),h0tab(:,196),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,105),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMB,G1H4(45),n2h4(89))
  Gcoeff(:)%j = (-(c(116)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(197),h0tab(:,197),[12,3],[nME,nME],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(16),ngZl,m3h4x4(:,106),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G0H4(16),12,nME,G1H4(46),n2h4(90))
  Gcoeff(:)%j = (-(c(121)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(198),h0tab(:,198),[12,3],[nMM,nMM],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(16),ngZl,m3h4x4(:,107),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMM,G1H4(47),n2h4(91))
  Gcoeff(:)%j = (-(c(118)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(199),h0tab(:,199),[12,3],[nML,nML],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(16),ngZl,m3h4x4(:,108),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G0H4(16),12,nML,G1H4(48),n2h4(92))
  Gcoeff(:)%j = (c(125)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(200),h0tab(:,200),[12,3],[nMT,nMT],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(16),ngZu,m3h4x4(:,109),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMT,G1H4(49),n2h4(93))
  Gcoeff(:)%j = (-(c(114)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(201),h0tab(:,201),[12,3],[nMB,nMB],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(16),ngZd,m3h4x4(:,110),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMB,G1H4(50),n2h4(94))
  Gcoeff(:)%j = (c(67)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(202),h0tab(:,202),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(51),m3h4x4(:,111),heltab2x16(:,:,202))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(203),h0tab(:,203),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(52),m3h4x4(:,112),heltab2x16(:,:,203))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(204),h0tab(:,204),[12,3],[nMH,nMZ],2,2,wf4(:,8),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(53),m3h4x4(:,113),heltab2x16(:,:,204))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(205),h0tab(:,205),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(54),m3h4x4(:,114),heltab2x16(:,:,205))
  Gcoeff(:)%j = (-(c(55)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(206),h0tab(:,206),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(55),m3h4x4(:,115),heltab2x16(:,:,206))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(207),h0tab(:,207),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(56),m3h4x4(:,116),heltab2x16(:,:,207))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(208),h0tab(:,208),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(57),m3h4x4(:,117),heltab2x16(:,:,208))
  Gcoeff(:)%j = (-(c(55)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(209),h0tab(:,209),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(58),m3h4x4(:,118),heltab2x16(:,:,209))
  Gcoeff(:)%j = (-(c(55)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(210),h0tab(:,210),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(59),m3h4x4(:,119),heltab2x16(:,:,210))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(211),h0tab(:,211),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(60),m3h4x4(:,120),heltab2x16(:,:,211))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(212),h0tab(:,212),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(61),m3h4x4(:,121),heltab2x16(:,:,212))
  Gcoeff(:)%j = (c(56)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(213),h0tab(:,213),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(62),m3h4x4(:,122),heltab2x16(:,:,213))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(214),h0tab(:,214),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(63),m3h4x4(:,123),heltab2x16(:,:,214))
  Gcoeff(:)%j = (-(c(55)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(215),h0tab(:,215),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(16),m3h4x4(:,124),heltab2x16(:,:,215))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(216),h0tab(:,216),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(17),m3h4x4(:,125),heltab2x16(:,:,216))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(217),h0tab(:,217),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(18),m3h4x4(:,126),heltab2x16(:,:,217))
  Gcoeff(:)%j = (c(77)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(218),h0tab(:,218),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(19),m3h4x4(:,127),heltab2x16(:,:,218))
  Gcoeff(:)%j = (-(c(55)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(219),h0tab(:,219),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(20),m3h4x4(:,128),heltab2x16(:,:,219))
  Gcoeff(:)%j = (-(c(55)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(220),h0tab(:,220),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(21),m3h4x4(:,129),heltab2x16(:,:,220))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(221),h0tab(:,221),[12,3],[nMH,nMZ],2,2,wf4(:,8),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(22),m3h4x4(:,130),heltab2x16(:,:,221))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(222),h0tab(:,222),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(23),m3h4x4(:,131),heltab2x16(:,:,222))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(223),h0tab(:,223),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(24),m3h4x4(:,132),heltab2x16(:,:,223))
  Gcoeff(:)%j = (c(111)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(224),h0tab(:,224),[12,3],[nME,nME],2,2,wf4(:,2),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,133),heltab2x16(:,:,224))
  call Hloop_Q_A(ntryL,G0H4(25),12,nME,G1H4(64),n2h4(95))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(225),h0tab(:,225),[12,3],[nMM,nMM],2,2,wf4(:,2),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,134),heltab2x16(:,:,225))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMM,G1H4(65),n2h4(96))
  Gcoeff(:)%j = (c(113)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(226),h0tab(:,226),[12,3],[nML,nML],2,2,wf4(:,2),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,135),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G0H4(25),12,nML,G1H4(66),n2h4(97))
  Gcoeff(:)%j = (-(c(122)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(227),h0tab(:,227),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,136),heltab2x16(:,:,227))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMT,G1H4(67),n2h4(98))
  Gcoeff(:)%j = (c(109)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(228),h0tab(:,228),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,137),heltab2x16(:,:,228))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMB,G1H4(68),n2h4(99))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(229),h0tab(:,229),[12,3],[nME,nME],2,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),ngX,m3h4x4(:,138),heltab2x16(:,:,229))
  call Hloop_Q_A(ntryL,G0H4(25),12,nME,G1H4(69),n2h4(100))
  Gcoeff(:)%j = (-(c(119)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(230),h0tab(:,230),[12,3],[nMM,nMM],2,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),ngX,m3h4x4(:,139),heltab2x16(:,:,230))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMM,G1H4(70),n2h4(101))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(231),h0tab(:,231),[12,3],[nML,nML],2,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),ngX,m3h4x4(:,140),heltab2x16(:,:,231))
  call Hloop_Q_A(ntryL,G0H4(25),12,nML,G1H4(71),n2h4(102))
  Gcoeff(:)%j = (-(c(122)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(232),h0tab(:,232),[12,3],[nMT,nMT],2,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),ngX,m3h4x4(:,141),heltab2x16(:,:,232))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMT,G1H4(72),n2h4(103))
  Gcoeff(:)%j = (-(c(109)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(233),h0tab(:,233),[12,3],[nMB,nMB],2,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),ngX,m3h4x4(:,142),heltab2x16(:,:,233))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMB,G1H4(73),n2h4(104))
  Gcoeff(:)%j = (c(111)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(234),h0tab(:,234),[12,3],[nME,nME],2,2,wf4(:,2),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,143),heltab2x16(:,:,234))
  call Hloop_Q_A(ntryL,G0H4(25),12,nME,G1H4(74),n2h4(105))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(235),h0tab(:,235),[12,3],[nMM,nMM],2,2,wf4(:,2),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,144),heltab2x16(:,:,235))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMM,G1H4(75),n2h4(106))
  Gcoeff(:)%j = (c(113)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(236),h0tab(:,236),[12,3],[nML,nML],2,2,wf4(:,2),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,145),heltab2x16(:,:,236))
  call Hloop_Q_A(ntryL,G0H4(25),12,nML,G1H4(76),n2h4(107))
  Gcoeff(:)%j = (c(123)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(237),h0tab(:,237),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,146),heltab2x16(:,:,237))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMT,G1H4(77),n2h4(108))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(238),h0tab(:,238),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,147),heltab2x16(:,:,238))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMB,G1H4(78),n2h4(109))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(239),h0tab(:,239),[12,3],[nME,nME],2,2,wf4(:,4),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),ngX,m3h4x4(:,148),heltab2x16(:,:,239))
  call Hloop_Q_A(ntryL,G0H4(25),12,nME,G1H4(79),n2h4(110))
  Gcoeff(:)%j = (-(c(119)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(240),h0tab(:,240),[12,3],[nMM,nMM],2,2,wf4(:,4),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),ngX,m3h4x4(:,149),heltab2x16(:,:,240))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMM,G1H4(80),n2h4(111))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(241),h0tab(:,241),[12,3],[nML,nML],2,2,wf4(:,4),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),ngX,m3h4x4(:,150),heltab2x16(:,:,241))
  call Hloop_Q_A(ntryL,G0H4(25),12,nML,G1H4(81),n2h4(112))
  Gcoeff(:)%j = (c(123)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(242),h0tab(:,242),[12,3],[nMT,nMT],2,2,wf4(:,4),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),ngX,m3h4x4(:,151),heltab2x16(:,:,242))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMT,G1H4(82),n2h4(113))
  Gcoeff(:)%j = (-(c(110)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(243),h0tab(:,243),[12,3],[nMB,nMB],2,2,wf4(:,4),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),ngX,m3h4x4(:,152),heltab2x16(:,:,243))
  call Hloop_Q_A(ntryL,G0H4(25),12,nMB,G1H4(83),n2h4(114))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(244),h0tab(:,244),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(25),m3h4x4(:,153),heltab2x16(:,:,244))
  Gcoeff(:)%j = (c(83)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(245),h0tab(:,245),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(26),m3h4x4(:,154),heltab2x16(:,:,245))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(246),h0tab(:,246),[12,3],[nMH,nMZ],2,2,wf4(:,4),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(27),m3h4x4(:,155),heltab2x16(:,:,246))
  Gcoeff(:)%j = (c(52)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(247),h0tab(:,247),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(28),m3h4x4(:,156),heltab2x16(:,:,247))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(248),h0tab(:,248),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(29),m3h4x4(:,157),heltab2x16(:,:,248))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(249),h0tab(:,249),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(30),m3h4x4(:,158),heltab2x16(:,:,249))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(250),h0tab(:,250),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(31),m3h4x4(:,159),heltab2x16(:,:,250))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(251),h0tab(:,251),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(32),m3h4x4(:,160),heltab2x16(:,:,251))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(252),h0tab(:,252),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(33),m3h4x4(:,161),heltab2x16(:,:,252))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(253),h0tab(:,253),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(34),m3h4x4(:,162),heltab2x16(:,:,253))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(254),h0tab(:,254),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(35),m3h4x4(:,163),heltab2x16(:,:,254))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(255),h0tab(:,255),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(36),m3h4x4(:,164),heltab2x16(:,:,255))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(256),h0tab(:,256),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(37),m3h4x4(:,165),heltab2x16(:,:,256))
  Gcoeff(:)%j = (c(52)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(257),h0tab(:,257),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(84),m3h4x4(:,166),heltab2x16(:,:,257))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(258),h0tab(:,258),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(85),m3h4x4(:,167),heltab2x16(:,:,258))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(259),h0tab(:,259),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(86),m3h4x4(:,168),heltab2x16(:,:,259))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(260),h0tab(:,260),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(87),m3h4x4(:,169),heltab2x16(:,:,260))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(261),h0tab(:,261),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(88),m3h4x4(:,170),heltab2x16(:,:,261))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(262),h0tab(:,262),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(89),m3h4x4(:,171),heltab2x16(:,:,262))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(263),h0tab(:,263),[12,3],[nMH,nMZ],2,2,wf4(:,4),wf4(:,7))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(90),m3h4x4(:,172),heltab2x16(:,:,263))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(264),h0tab(:,264),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(91),m3h4x4(:,173),heltab2x16(:,:,264))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(265),h0tab(:,265),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(92),m3h4x4(:,174),heltab2x16(:,:,265))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(266),h0tab(:,266),[12,3],[nME,nME],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,175),heltab2x16(:,:,266))
  call Hloop_Q_A(ntryL,G0H4(38),12,nME,G1H4(93),n2h4(115))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(267),h0tab(:,267),[12,3],[nMM,nMM],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,176),heltab2x16(:,:,267))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMM,G1H4(94),n2h4(116))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(268),h0tab(:,268),[12,3],[nML,nML],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,177),heltab2x16(:,:,268))
  call Hloop_Q_A(ntryL,G0H4(38),12,nML,G1H4(95),n2h4(117))
  Gcoeff(:)%j = (-(c(94)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(269),h0tab(:,269),[12,3],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,178),heltab2x16(:,:,269))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(96),n2h4(118))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(270),h0tab(:,270),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,179),heltab2x16(:,:,270))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMT,G1H4(97),n2h4(119))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(271),h0tab(:,271),[12,3],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,180),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(98),n2h4(120))
  Gcoeff(:)%j = (-(c(89)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(272),h0tab(:,272),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,181),heltab2x16(:,:,272))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMB,G1H4(99),n2h4(121))
  Gcoeff(:)%j = (-(c(99)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(273),h0tab(:,273),[12,3],[nME,nME],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,182),heltab2x16(:,:,273))
  call Hloop_Q_A(ntryL,G0H4(38),12,nME,G1H4(100),n2h4(122))
  Gcoeff(:)%j = (-(c(99)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(274),h0tab(:,274),[12,3],[nMM,nMM],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,183),heltab2x16(:,:,274))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMM,G1H4(101),n2h4(123))
  Gcoeff(:)%j = (-(c(99)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(275),h0tab(:,275),[12,3],[nML,nML],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,184),heltab2x16(:,:,275))
  call Hloop_Q_A(ntryL,G0H4(38),12,nML,G1H4(102),n2h4(124))
  Gcoeff(:)%j = (c(101)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(276),h0tab(:,276),[12,3],[0,0],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZu,m3h4x4(:,185),heltab2x16(:,:,276))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(103),n2h4(125))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(277),h0tab(:,277),[12,3],[nMT,nMT],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZu,m3h4x4(:,186),heltab2x16(:,:,277))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMT,G1H4(104),n2h4(126))
  Gcoeff(:)%j = (-(c(98)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(278),h0tab(:,278),[12,3],[0,0],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZd,m3h4x4(:,187),heltab2x16(:,:,278))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(105),n2h4(127))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(279),h0tab(:,279),[12,3],[nMB,nMB],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZd,m3h4x4(:,188),heltab2x16(:,:,279))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMB,G1H4(106),n2h4(128))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(280),h0tab(:,280),[12,3],[nME,nME],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,189),heltab2x16(:,:,280))
  call Hloop_Q_A(ntryL,G0H4(38),12,nME,G1H4(107),n2h4(129))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(281),h0tab(:,281),[12,3],[nMM,nMM],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,190),heltab2x16(:,:,281))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMM,G1H4(108),n2h4(130))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(282),h0tab(:,282),[12,3],[nML,nML],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,191),heltab2x16(:,:,282))
  call Hloop_Q_A(ntryL,G0H4(38),12,nML,G1H4(109),n2h4(131))
  Gcoeff(:)%j = (c(97)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(283),h0tab(:,283),[12,3],[0,0],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,192),heltab2x16(:,:,283))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(110),n2h4(132))
  Gcoeff(:)%j = (c(93)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(284),h0tab(:,284),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,193),heltab2x16(:,:,284))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMT,G1H4(111),n2h4(133))
  Gcoeff(:)%j = (-(c(93)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(285),h0tab(:,285),[12,3],[0,0],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,194),heltab2x16(:,:,285))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(112),n2h4(134))
  Gcoeff(:)%j = (-(c(91)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(286),h0tab(:,286),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,195),heltab2x16(:,:,286))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMB,G1H4(113),n2h4(135))
  Gcoeff(:)%j = (-(c(103)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(287),h0tab(:,287),[12,3],[0,0],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZn,m3h4x4(:,196),heltab2x16(:,:,287))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(114),n2h4(136))
  Gcoeff(:)%j = (-(c(99)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(288),h0tab(:,288),[12,3],[nME,nME],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,197),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G0H4(38),12,nME,G1H4(115),n2h4(137))
  Gcoeff(:)%j = (-(c(99)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(289),h0tab(:,289),[12,3],[nMM,nMM],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,198),heltab2x16(:,:,289))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMM,G1H4(116),n2h4(138))
  Gcoeff(:)%j = (-(c(99)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(290),h0tab(:,290),[12,3],[nML,nML],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,199),heltab2x16(:,:,290))
  call Hloop_Q_A(ntryL,G0H4(38),12,nML,G1H4(117),n2h4(139))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(291),h0tab(:,291),[12,3],[0,0],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZu,m3h4x4(:,200),heltab2x16(:,:,291))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(118),n2h4(140))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(292),h0tab(:,292),[12,3],[nMT,nMT],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZu,m3h4x4(:,201),heltab2x16(:,:,292))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMT,G1H4(119),n2h4(141))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(293),h0tab(:,293),[12,3],[0,0],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZd,m3h4x4(:,202),heltab2x16(:,:,293))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(120),n2h4(142))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(294),h0tab(:,294),[12,3],[nMB,nMB],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZd,m3h4x4(:,203),heltab2x16(:,:,294))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMB,G1H4(121),n2h4(143))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(295),h0tab(:,295),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(122),m3h4x4(:,204),heltab2x16(:,:,295))
  Gcoeff(:)%j = (c(87)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(296),h0tab(:,296),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(123),m3h4x4(:,205),heltab2x16(:,:,296))
  Gcoeff(:)%j = (c(86)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(297),h0tab(:,297),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(124),m3h4x4(:,206),heltab2x16(:,:,297))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(298),h0tab(:,298),[12,3],[nMH,nMZ],2,2,wf4(:,8),wf4(:,7))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(125),m3h4x4(:,207),heltab2x16(:,:,298))
  Gcoeff(:)%j = (c(88)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(299),h0tab(:,299),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(126),m3h4x4(:,208),heltab2x16(:,:,299))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(300),h0tab(:,300),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(127),m3h4x4(:,209),heltab2x16(:,:,300))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(301),h0tab(:,301),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(128),m3h4x4(:,210),heltab2x16(:,:,301))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(302),h0tab(:,302),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(129),m3h4x4(:,211),heltab2x16(:,:,302))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(303),h0tab(:,303),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(130),m3h4x4(:,212),heltab2x16(:,:,303))
  Gcoeff(:)%j = (c(74)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(304),h0tab(:,304),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(131),m3h4x4(:,213),heltab2x16(:,:,304))
  Gcoeff(:)%j = (c(74)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(305),h0tab(:,305),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(132),m3h4x4(:,214),heltab2x16(:,:,305))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(306),h0tab(:,306),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(133),m3h4x4(:,215),heltab2x16(:,:,306))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(307),h0tab(:,307),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(134),m3h4x4(:,216),heltab2x16(:,:,307))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(308),h0tab(:,308),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(135),m3h4x4(:,217),heltab2x16(:,:,308))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(309),h0tab(:,309),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(136),m3h4x4(:,218),heltab2x16(:,:,309))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(310),h0tab(:,310),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(137),m3h4x4(:,219),heltab2x16(:,:,310))
  Gcoeff(:)%j = (c(51)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(311),h0tab(:,311),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(138),m3h4x4(:,220),heltab2x16(:,:,311))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(312),h0tab(:,312),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,221),heltab2x16(:,:,312))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(313),h0tab(:,313),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(39),m3h4x4(:,222),heltab2x16(:,:,313))
  Gcoeff(:)%j = (-(c(80)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(314),h0tab(:,314),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(40),m3h4x4(:,223),heltab2x16(:,:,314))
  Gcoeff(:)%j = (-(c(80)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(315),h0tab(:,315),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(41),m3h4x4(:,224),heltab2x16(:,:,315))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(316),h0tab(:,316),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(42),m3h4x4(:,225),heltab2x16(:,:,316))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(317),h0tab(:,317),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(43),m3h4x4(:,226),heltab2x16(:,:,317))
  Gcoeff(:)%j = (-(c(72)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(318),h0tab(:,318),[12,3],[nMH,nMZ],2,2,wf4(:,8),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(44),m3h4x4(:,227),heltab2x16(:,:,318))
  Gcoeff(:)%j = (-(c(81)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(319),h0tab(:,319),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(45),m3h4x4(:,228),heltab2x16(:,:,319))
  Gcoeff(:)%j = (-(c(81)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(320),h0tab(:,320),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(46),m3h4x4(:,229),heltab2x16(:,:,320))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(3),G1H4(10),G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(6),G1H4(2),G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(5),G1H4(14),G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(36),G1H4(12),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(13),G1H4(4),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(41),G1H4(23),G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(42),G1H4(20),G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(43),G1H4(26),G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(44),G1H4(8),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(45),G1H4(35),G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(51),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(56),G1H4(55),G1H4(54),G0H4(5),G0H4(4),G0H4(3) &
    ,G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(60),G1H4(59),G1H4(58),G0H4(13),G0H4(9),G0H4(8) &
    ,G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(62),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(17),G1H4(29),G1H4(16),G0H4(19),G0H4(18) &
    ,G0H4(17),G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(7),G1H4(34),G1H4(22),G0H4(24),G0H4(23),G0H4(21) &
    ,G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G1H4(93),G1H4(69),G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(101),[G1H4(94),G1H4(70),G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(95),G1H4(71),G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(104),[G1H4(97),G1H4(72),G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(99),G1H4(73),G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(107),G1H4(79),G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(108),G1H4(80),G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(109),G1H4(81),G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(111),G1H4(82),G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(113),G1H4(83),G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(122),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(124),G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(129),G1H4(128),G1H4(127),G0H4(31),G0H4(30) &
    ,G0H4(29),G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(133),G1H4(132),G1H4(131),G0H4(35),G0H4(34) &
    ,G0H4(33),G0H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(135),G0H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(137),G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(86),G1H4(85),G1H4(84),G0H4(41),G0H4(40) &
    ,G0H4(39),G0H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(91),G1H4(89),G1H4(88),G0H4(46),G0H4(45) &
    ,G0H4(43),G0H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G0H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(103),G1H4(98),G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(112)])
  call Hloop_QS_A(ntryL,G1H4(24),wf4(:,1),G1H1(1),ngH,m3h4x1(:,1),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(24),n2h1(41))
  call Hloop_QS_A(ntryL,G1H4(37),wf4(:,1),G1H1(1),ngH,m3h4x1(:,2),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(14),n2h1(42))
  call Hloop_QS_A(ntryL,G1H4(38),wf4(:,1),G1H1(1),ngH,m3h4x1(:,3),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(20),n2h1(43))
  call Hloop_QS_A(ntryL,G1H4(39),wf4(:,1),G1H1(1),ngH,m3h4x1(:,4),heltab2x4(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(11),n2h1(44))
  call Hloop_QS_A(ntryL,G1H4(40),wf4(:,1),G1H1(1),ngH,m3h4x1(:,5),heltab2x4(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(13),n2h1(45))
  call Hloop_QS_A(ntryL,G1H4(46),wf4(:,3),G1H1(1),ngX,m3h4x1(:,6),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(16),n2h1(46))
  call Hloop_QS_A(ntryL,G1H4(47),wf4(:,3),G1H1(1),ngX,m3h4x1(:,7),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(4),n2h1(47))
  call Hloop_QS_A(ntryL,G1H4(48),wf4(:,3),G1H1(1),ngX,m3h4x1(:,8),heltab2x4(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(6),n2h1(48))
  call Hloop_QS_A(ntryL,G1H4(49),wf4(:,3),G1H1(1),ngX,m3h4x1(:,9),heltab2x4(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(8),n2h1(49))
  call Hloop_QS_A(ntryL,G1H4(50),wf4(:,3),G1H1(1),ngX,m3h4x1(:,10),heltab2x4(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(26),n2h1(50))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(11),wf4(:,1),G0tensor(97),m3h4x1(:,11),heltab2x4(:,:,56))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(12),wf4(:,1),G0tensor(103),m3h4x1(:,12),heltab2x4(:,:,57))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(52),wf4(:,1),G1tensor(11),m3h4x1(:,13),heltab2x4(:,:,58))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(53),wf4(:,3),G1tensor(16),m3h4x1(:,14),heltab2x4(:,:,59))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(2),wf4(:,1),G0tensor(110),m3h4x1(:,15),heltab2x4(:,:,60))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(57),wf4(:,1),G1tensor(21),m3h4x1(:,16),heltab2x4(:,:,61))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(61),wf4(:,3),G1tensor(26),m3h4x1(:,17),heltab2x4(:,:,62))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H4(14),wf4(:,1),G0tensor(116),m3h4x1(:,18),heltab2x4(:,:,63))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(63),wf4(:,1),G1tensor(31),m3h4x1(:,19),heltab2x4(:,:,64))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(11),12,wf4(:,1),3,G2tensor(17),m3h4x1(:,20),heltab2x4(:,:,65))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(18),12,wf4(:,1),3,G2tensor(12),m3h4x1(:,21),heltab2x4(:,:,66))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(1),12,wf4(:,3),3,G2tensor(10),m3h4x1(:,22),heltab2x4(:,:,67))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(25),12,wf4(:,3),3,G2tensor(23),m3h4x1(:,23),heltab2x4(:,:,68))
  call Hloop_QV_A(ntryL,G1H4(100),wf4(:,5),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(15),n2h1(51))
  call Hloop_QV_A(ntryL,G1H4(101),wf4(:,5),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(18),n2h1(52))
  call Hloop_QV_A(ntryL,G1H4(102),wf4(:,5),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(19),n2h1(53))
  call Hloop_QV_A(ntryL,G1H4(104),wf4(:,5),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(5),n2h1(54))
  call Hloop_QV_A(ntryL,G1H4(106),wf4(:,5),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(3),n2h1(55))
  call Hloop_QZ_A(ntryL,G1H4(115),wf4(:,7),G1H1(1),ngZl,m3h4x1(:,29),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(2),n2h1(56))
  call Hloop_QZ_A(ntryL,G1H4(116),wf4(:,7),G1H1(1),ngZl,m3h4x1(:,30),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(9),n2h1(57))
  call Hloop_QZ_A(ntryL,G1H4(117),wf4(:,7),G1H1(1),ngZl,m3h4x1(:,31),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(1),n2h1(58))
  call Hloop_QZ_A(ntryL,G1H4(119),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,32),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(7),n2h1(59))
  call Hloop_QZ_A(ntryL,G1H4(121),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,33),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(22),n2h1(60))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(123),12,wf4(:,5),3,G2tensor(21),m3h4x1(:,34),heltab2x4(:,:,79))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(126),12,wf4(:,7),3,G2tensor(25),m3h4x1(:,35),heltab2x4(:,:,80))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(125),12,wf4(:,7),3,G2tensor(27),m3h4x1(:,36),heltab2x4(:,:,81))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(130),12,wf4(:,5),3,G2tensor(28),m3h4x1(:,37),heltab2x4(:,:,82))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(134),12,wf4(:,7),3,G2tensor(29),m3h4x1(:,38),heltab2x4(:,:,83))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(136),12,wf4(:,5),3,G2tensor(30),m3h4x1(:,39),heltab2x4(:,:,84))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(138),12,wf4(:,7),3,G2tensor(31),m3h4x1(:,40),heltab2x4(:,:,85))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(87),wf4(:,5),G1tensor(36),m3h4x1(:,41),heltab2x4(:,:,86))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(92),wf4(:,7),G1tensor(41),m3h4x1(:,42),heltab2x4(:,:,87))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(90),wf4(:,7),G1tensor(46),m3h4x1(:,43),heltab2x4(:,:,88))
  call Hloop_QV_A(ntryL,G1H4(105),wf4(:,5),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(32),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H4(118),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,45),heltab2x4(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(33),n2h1(62))
  call Hloop_QZ_A(ntryL,G1H4(120),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,46),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(34),n2h1(63))
  call Hloop_QZ_A(ntryL,G1H4(114),wf4(:,7),G1H1(1),ngZn,m3h4x1(:,47),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(35),n2h1(64))
  call ol_merge_tensors(G0tensor(126),[G0tensor(9),G0tensor(6)])
  call ol_merge_tensors(G0tensor(235),[G0tensor(165),G0tensor(112),G0tensor(105),G0tensor(11)])
  call ol_merge_tensors(G0tensor(257),[G0tensor(214),G0tensor(133),G0tensor(86),G0tensor(16)])
  call ol_merge_tensors(G0tensor(301),[G0tensor(283),G0tensor(258),G0tensor(251),G0tensor(244),G0tensor(237),G0tensor(226) &
    ,G0tensor(215),G0tensor(203),G0tensor(197),G0tensor(185),G0tensor(173),G0tensor(167),G0tensor(148),G0tensor(134),G0tensor(120) &
    ,G0tensor(114),G0tensor(107),G0tensor(63),G0tensor(94),G0tensor(74),G0tensor(91),G0tensor(56),G0tensor(21)])
  call ol_merge_tensors(G0tensor(307),[G0tensor(289),G0tensor(259),G0tensor(253),G0tensor(216),G0tensor(209),G0tensor(186) &
    ,G0tensor(179),G0tensor(155),G0tensor(150),G0tensor(141),G0tensor(135),G0tensor(128),G0tensor(93),G0tensor(42),G0tensor(54) &
    ,G0tensor(20),G0tensor(4),G0tensor(2),G0tensor(66),G0tensor(26)])
  call ol_merge_tensors(G0tensor(295),[G0tensor(277),G0tensor(245),G0tensor(239),G0tensor(231),G0tensor(204),G0tensor(191) &
    ,G0tensor(168),G0tensor(161),G0tensor(142),G0tensor(127),G0tensor(121),G0tensor(115),G0tensor(109),G0tensor(101),G0tensor(62) &
    ,G0tensor(33),G0tensor(40),G0tensor(35),G0tensor(61),G0tensor(31)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(23),G1tensor(46),G1tensor(16),G0tensor(140),G0tensor(49),G0tensor(41)])
  call ol_merge_tensors(G0tensor(249),[G0tensor(183),G0tensor(146),G0tensor(81),G0tensor(46)])
  call ol_merge_tensors(G0tensor(243),[G0tensor(202),G0tensor(119),G0tensor(113),G0tensor(51)])
  call ol_merge_tensors(G2tensor(17),[G0tensor(116),G0tensor(110),G0tensor(103),G0tensor(154),G0tensor(13),G0tensor(76)])
  call ol_merge_tensors(G0tensor(274),[G0tensor(241),G0tensor(228),G0tensor(8)])
  call ol_merge_tensors(G0tensor(305),[G0tensor(248),G0tensor(18),G0tensor(3)])
  call ol_merge_tensors(G0tensor(313),[G0tensor(308),G0tensor(302),G0tensor(296),G0tensor(290),G0tensor(284),G0tensor(278) &
    ,G0tensor(260),G0tensor(252),G0tensor(246),G0tensor(238),G0tensor(232),G0tensor(221),G0tensor(210),G0tensor(198),G0tensor(192) &
    ,G0tensor(180),G0tensor(174),G0tensor(162),G0tensor(156),G0tensor(149),G0tensor(143),G0tensor(136),G0tensor(129),G0tensor(122) &
    ,G0tensor(108),G0tensor(102),G0tensor(95),G0tensor(72),G0tensor(60),G0tensor(14),G0tensor(10),G0tensor(15)])
  call ol_merge_tensors(G0tensor(286),[G0tensor(255),G0tensor(28),G0tensor(7)])
  call ol_merge_tensors(G0tensor(293),[G0tensor(234),G0tensor(229),G0tensor(59)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(64)])
  call ol_merge_tensors(G0tensor(262),[G0tensor(19)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(30),G2tensor(29),G2tensor(28),G2tensor(25),G2tensor(21),G2tensor(10),G2tensor(12) &
    ,G1tensor(41),G1tensor(36),G1tensor(31),G1tensor(26),G1tensor(21),G1tensor(11),G0tensor(45),G0tensor(22)])
  call ol_merge_tensors(G0tensor(272),[G0tensor(266),G0tensor(96),G0tensor(48),G0tensor(89),G0tensor(84)])
  call ol_merge_tensors(G0tensor(263),[G0tensor(30)])
  call ol_merge_tensors(G0tensor(270),[G0tensor(25)])
  call ol_merge_tensors(G0tensor(271),[G0tensor(265),G0tensor(75),G0tensor(27)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(3),G2tensor(26),G2tensor(13),G0tensor(50),G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(5),G2tensor(8),G2tensor(11),G0tensor(47)])
  call ol_merge_tensors(G0tensor(159),[G0tensor(125),G0tensor(104),G0tensor(99),G0tensor(57)])
  call ol_merge_tensors(G0tensor(188),[G0tensor(138),G0tensor(117),G0tensor(98),G0tensor(80)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(19),G2tensor(6),G2tensor(20),G0tensor(82),G0tensor(70),G0tensor(65)])
  call ol_merge_tensors(G0tensor(177),[G0tensor(153),G0tensor(145),G0tensor(139),G0tensor(68)])
  call ol_merge_tensors(G0tensor(206),[G0tensor(152),G0tensor(131),G0tensor(124),G0tensor(69)])
  call ol_merge_tensors(G0tensor(219),[G0tensor(207),G0tensor(194),G0tensor(189),G0tensor(73)])
  call ol_merge_tensors(G0tensor(218),[G0tensor(176),G0tensor(170),G0tensor(158),G0tensor(77)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(34),G2tensor(33),G2tensor(32),G0tensor(312),G0tensor(223),G0tensor(220) &
    ,G0tensor(92)])
  call ol_merge_tensors(G0tensor(97),[G0tensor(230),G0tensor(111),G0tensor(100)])
  call ol_merge_tensors(G0tensor(196),[G0tensor(171),G0tensor(147),G0tensor(132),G0tensor(118),G0tensor(106)])
  call ol_merge_tensors(G0tensor(294),[G0tensor(164),G0tensor(160)])
  call ol_merge_tensors(G0tensor(300),[G0tensor(225),G0tensor(184),G0tensor(172),G0tensor(166)])
  call ol_merge_tensors(G0tensor(306),[G0tensor(182),G0tensor(178)])
  call ol_merge_tensors(G0tensor(276),[G0tensor(200),G0tensor(190)])
  call ol_merge_tensors(G0tensor(281),[G0tensor(224),G0tensor(213),G0tensor(201),G0tensor(195)])
  call ol_merge_tensors(G0tensor(288),[G0tensor(212),G0tensor(208)])
  call ol_merge_tensors(G0tensor(299),[G0tensor(282),G0tensor(256),G0tensor(250),G0tensor(242),G0tensor(236)])
  call ol_merge_tensors(G0tensor(269),[G0tensor(264)])
  call ol_merge_tensors(G0tensor(311),[G0tensor(287),G0tensor(280),G0tensor(275)])
  call ol_merge_tensors(G0tensor(310),[G0tensor(304),G0tensor(298),G0tensor(292)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(15),G2tensor(16),G2tensor(24)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(18),G2tensor(4),G2tensor(14)])
call TI_bubble_red(G2tensor(27),12,mass2set(:,1),G0tensor(123),M2L1R1,G0tensor(1),G0tensor(130))
call TI_bubble_red(G2tensor(17),12,mass2set(:,2),G0tensor(137),M2L1R1,G0tensor(144))
call TI_bubble_red(G2tensor(31),12,mass2set(:,3),G0tensor(36),M2L1R1,G0tensor(151))
call TI_bubble_red(G2tensor(22),12,mass2set(:,4),G0tensor(71),M2L1R1,G0tensor(157))
call TI_bubble_red(G2tensor(7),12,mass2set(:,5),G0tensor(163),M2L1R1,G0tensor(169))
call TI_bubble_red(G2tensor(1),12,mass2set(:,6),G0tensor(175),M2L1R1,G0tensor(181))
call TI_bubble_red(G2tensor(35),12,mass2set(:,7),G0tensor(187),M2L1R1)
call TI_bubble_red(G2tensor(2),12,mass2set(:,8),G0tensor(193),M2L1R1,G0tensor(199))
call TI_bubble_red(G2tensor(9),12,mass2set(:,9),G0tensor(205),M2L1R1,G0tensor(211))
  call ol_merge_tensors(G0tensor(157),[G0tensor(301)])
  call ol_merge_tensors(G0tensor(144),[G0tensor(1),G0tensor(307)])
  call ol_merge_tensors(G0tensor(130),[G0tensor(295)])
  call ol_merge_tensors(G0tensor(181),[G0tensor(313)])
  call ol_merge_tensors(G0tensor(272),[G0tensor(151)])
  call ol_merge_tensors(G0tensor(169),[G0tensor(271)])
  call ol_merge_tensors(T0sum(71),[G0tensor(126)])
  call ol_merge_tensors(T0sum(72),[G0tensor(235)])
  call ol_merge_tensors(T0sum(73),[G0tensor(257)])
  call ol_merge_tensors(T0sum(74),[G0tensor(157)])
  call ol_merge_tensors(T0sum(75),[G0tensor(144)])
  call ol_merge_tensors(T0sum(76),[G0tensor(130)])
  call ol_merge_tensors(T0sum(77),[G0tensor(123)])
  call ol_merge_tensors(T0sum(78),[G0tensor(249)])
  call ol_merge_tensors(T0sum(79),[G0tensor(243)])
  call ol_merge_tensors(T0sum(80),[G0tensor(137)])
  call ol_merge_tensors(T0sum(81),[G0tensor(274)])
  call ol_merge_tensors(T0sum(82),[G0tensor(305)])
  call ol_merge_tensors(T0sum(83),[G0tensor(181)])
  call ol_merge_tensors(T0sum(84),[G0tensor(286)])
  call ol_merge_tensors(T0sum(85),[G0tensor(293)])
  call ol_merge_tensors(T0sum(86),[G0tensor(268)])
  call ol_merge_tensors(T0sum(87),[G0tensor(262)])
  call ol_merge_tensors(T0sum(88),[G0tensor(36)])
  call ol_merge_tensors(T0sum(89),[G0tensor(272)])
  call ol_merge_tensors(T0sum(90),[G0tensor(263)])
  call ol_merge_tensors(T0sum(91),[G0tensor(270)])
  call ol_merge_tensors(T0sum(92),[G0tensor(169)])
  call ol_merge_tensors(T0sum(93),[G0tensor(71)])
  call ol_merge_tensors(T0sum(94),[G0tensor(43)])
  call ol_merge_tensors(T0sum(95),[G0tensor(38)])
  call ol_merge_tensors(T0sum(96),[G0tensor(79)])
  call ol_merge_tensors(T0sum(97),[G0tensor(39)])
  call ol_merge_tensors(T0sum(98),[G0tensor(163)])
  call ol_merge_tensors(T0sum(99),[G0tensor(83)])
  call ol_merge_tensors(T0sum(100),[G0tensor(58)])
  call ol_merge_tensors(T0sum(101),[G0tensor(52)])
  call ol_merge_tensors(T0sum(102),[G0tensor(88)])
  call ol_merge_tensors(T0sum(103),[G0tensor(159)])
  call ol_merge_tensors(T0sum(104),[G0tensor(188)])
  call ol_merge_tensors(T0sum(105),[G0tensor(175)])
  call ol_merge_tensors(T0sum(106),[G0tensor(177)])
  call ol_merge_tensors(T0sum(107),[G0tensor(206)])
  call ol_merge_tensors(T0sum(108),[G0tensor(219)])
  call ol_merge_tensors(T0sum(109),[G0tensor(218)])
  call ol_merge_tensors(T0sum(110),[G0tensor(85)])
  call ol_merge_tensors(T0sum(111),[G0tensor(87)])
  call ol_merge_tensors(T0sum(112),[G0tensor(187)])
  call ol_merge_tensors(T0sum(113),[G0tensor(97)])
  call ol_merge_tensors(T0sum(114),[G0tensor(196)])
  call ol_merge_tensors(T0sum(115),[G0tensor(294)])
  call ol_merge_tensors(T0sum(116),[G0tensor(300)])
  call ol_merge_tensors(T0sum(117),[G0tensor(306)])
  call ol_merge_tensors(T0sum(118),[G0tensor(276)])
  call ol_merge_tensors(T0sum(119),[G0tensor(281)])
  call ol_merge_tensors(T0sum(120),[G0tensor(288)])
  call ol_merge_tensors(T0sum(121),[G0tensor(299)])
  call ol_merge_tensors(T0sum(122),[G0tensor(269)])
  call ol_merge_tensors(T0sum(123),[G0tensor(311)])
  call ol_merge_tensors(T0sum(124),[G0tensor(310)])
  call ol_merge_tensors(T0sum(125),[G0tensor(193)])
  call ol_merge_tensors(T0sum(126),[G0tensor(199)])
  call ol_merge_tensors(T0sum(127),[G0tensor(205)])
  call ol_merge_tensors(T0sum(128),[G0tensor(211)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppllj_ew_llxbbx_1_/**/REALKIND
