
module ol_vamp_1_ppllj_ew_eexddx_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj_ew_eexddx_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj_ew_eexddx_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllj_ew_eexddx_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppllj_ew_eexddx_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppllj_ew_eexddx_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllj_ew_eexddx_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[nMZ,0,0,0],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(2),ngZd,m3h2x8(:,2),heltab2x16(:,:,2))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[0,0,nMZ,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,1,2,4],[0,0,nMZ,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,1,2,4],[nMZ,0,0,0],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(6),ngZd,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(1),n2h4(1))
  call Hloop_ZA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),ngZl,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(2),n2h4(2))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(3),n2h4(3))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(4),n2h4(4))
  call Hloop_VQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(5),n2h4(5))
  call Hloop_ZQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),ngZl,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(6),n2h4(6))
  call Hloop_AQ_V(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G1H4(2),ex1(:),G1H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H4(3),ex1(:),G1H2(3),ngZl,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G1H4(4),ex2(:),G1H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_Z(ntryL,G1H4(5),ex2(:),G1H2(5),ngZl,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G1H4(6),ex2(:),G1H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(2),n2h1(2))
  call Hloop_ZQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),ngZd,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(4),n2h1(4))
  call Hloop_ZQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),ngZd,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(5),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(6),n2h1(6))
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(1),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(2),mass4set(:,3),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,2),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(1),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(2),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(2),mass4set(:,3),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,2),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,3,4],[0,0,0],3,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(2),8,0,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[12,1,2],[0,0,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,1),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G0H4(1),12,0,G1H4(1),n2h4(7))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[12,1,2],[0,0,0],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZl,m3h4x4(:,2),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G0H4(1),12,0,G1H4(2),n2h4(8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(1)])
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(1),11,0,G2H2(1),n2h2(1))
  call Hloop_AZ_Q(ntryL,G1H8(2),wf4(:,3),G1H2(2),ngZd,m3h4x2(:,2),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(2),11,0,G2H2(2),n2h2(2))
  call Hloop_AQ_V(ntryL,G1H4(2),ex1(:),G1H2(3),m3h2x2(:,7),heltab2x4(:,:,7))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(1)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hloop_VA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(2),n2h1(7))
  call ol_merge_tensors(G1tensor(2),[G0tensor(2)])
  call ol_merge_tensors(G1tensor(8),[G1tensor(3),G0tensor(8),G0tensor(3)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(19),G1tensor(4),G0tensor(19),G0tensor(4)])
  call ol_merge_tensors(G1tensor(15),[G1tensor(5),G0tensor(15),G0tensor(5)])
  call ol_merge_tensors(G1tensor(7),[G0tensor(7)])
  call ol_merge_tensors(G1tensor(29),[G1tensor(9),G0tensor(29),G0tensor(9)])
  call ol_merge_tensors(G1tensor(10),[G0tensor(10)])
  call ol_merge_tensors(G1tensor(12),[G0tensor(12)])
  call ol_merge_tensors(G1tensor(13),[G0tensor(13)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(14),G0tensor(24),G0tensor(14)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(17),G0tensor(17)])
  call ol_merge_tensors(G1tensor(28),[G1tensor(18),G0tensor(28),G0tensor(18)])
  call ol_merge_tensors(G1tensor(25),[G1tensor(20),G0tensor(25),G0tensor(20)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(22)])
  call ol_merge_tensors(G1tensor(23),[G0tensor(23)])
  call ol_merge_tensors(G1tensor(27),[G0tensor(27)])
  call ol_merge_tensors(G1tensor(30),[G0tensor(30)])
  call TI_triangle_red(G2tensor(1),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(2),RedBasis(6),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(2),G0tensor(8),M2L1R1)
  call TI_triangle_red(G1tensor(2),RedBasis(7),mass3set(:,1),G0tensor(3),G0tensor(19),G0tensor(4),G0tensor(15),M2L1R1)
  call TI_triangle_red(G1tensor(8),RedBasis(3),mass3set(:,1),G0tensor(5),G0tensor(7),G0tensor(29),G0tensor(9),M2L1R1)
  call TI_triangle_red(G1tensor(15),RedBasis(1),mass3set(:,1),G0tensor(10),G0tensor(12),G0tensor(13),G0tensor(24),M2L1R1)
  call TI_triangle_red(G1tensor(7),RedBasis(7),mass3set(:,2),G0tensor(14),G0tensor(17),G0tensor(28),G0tensor(18),M2L1R1,[nMZ], &
    G0tensor(25))
  call TI_triangle_red(G1tensor(29),RedBasis(2),mass3set(:,2),G0tensor(20),G0tensor(22),G0tensor(23),G0tensor(27),M2L1R1,[nMZ], &
    G0tensor(30))
  call TI_triangle_red(G1tensor(10),RedBasis(1),mass3set(:,2),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),M2L1R1,[nMZ], &
    G0tensor(35))
  call TI_triangle_red(G1tensor(12),RedBasis(7),mass3set(:,3),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),M2L1R1,[nMZ], &
    G0tensor(40))
  call TI_triangle_red(G1tensor(13),RedBasis(3),mass3set(:,4),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),M2L1R1,[nMZ], &
    G0tensor(45))
  call TI_triangle_red(G1tensor(24),RedBasis(2),mass3set(:,4),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),M2L1R1,[nMZ], &
    G0tensor(50))
  call TI_triangle_red(G1tensor(28),RedBasis(5),mass3set(:,1),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),M2L1R1)
  call TI_triangle_red(G1tensor(25),RedBasis(4),mass3set(:,1),G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),M2L1R1)
  call TI_triangle_red(G1tensor(22),RedBasis(6),mass3set(:,3),G0tensor(59),G0tensor(60),G0tensor(61),G0tensor(62),M2L1R1,[nMZ], &
    G0tensor(63))
  call TI_triangle_red(G1tensor(23),RedBasis(5),mass3set(:,4),G0tensor(64),G0tensor(65),G0tensor(66),G0tensor(67),M2L1R1,[nMZ], &
    G0tensor(68))
  call TI_triangle_red(G1tensor(27),RedBasis(6),mass3set(:,2),G0tensor(69),G0tensor(70),G0tensor(71),G0tensor(72),M2L1R1,[nMZ], &
    G0tensor(73))
  call TI_triangle_red(G1tensor(30),RedBasis(4),mass3set(:,2),G0tensor(74),G0tensor(75),G0tensor(76),G0tensor(77),M2L1R1,[nMZ], &
    G0tensor(78))
  call ol_merge_tensors(T0sum(7),[G0tensor(3)])
  call ol_merge_tensors(T0sum(8),[G0tensor(5)])
  call ol_merge_tensors(T0sum(9),[G0tensor(1)])
  call ol_merge_tensors(T0sum(10),[G0tensor(10)])
  call ol_merge_tensors(T0sum(11),[G0tensor(14)])
  call ol_merge_tensors(T0sum(12),[G0tensor(20)])
  call ol_merge_tensors(T0sum(13),[G0tensor(31)])
  call ol_merge_tensors(T0sum(14),[G0tensor(36)])
  call ol_merge_tensors(T0sum(15),[G0tensor(41)])
  call ol_merge_tensors(T0sum(16),[G0tensor(46)])
  call ol_merge_tensors(T0sum(17),[G0tensor(21)])
  call ol_merge_tensors(T0sum(18),[G0tensor(51)])
  call ol_merge_tensors(T0sum(19),[G0tensor(55)])
  call ol_merge_tensors(T0sum(20),[G0tensor(59)])
  call ol_merge_tensors(T0sum(21),[G0tensor(64)])
  call ol_merge_tensors(T0sum(22),[G0tensor(69)])
  call ol_merge_tensors(T0sum(23),[G0tensor(74)])
  call ol_merge_tensors(G0tensor(15),[G0tensor(8),G0tensor(6)])
  call ol_merge_tensors(G0tensor(53),[G0tensor(23),G0tensor(29),G0tensor(11)])
  call ol_merge_tensors(G0tensor(58),[G0tensor(49),G0tensor(24),G0tensor(16)])
  call ol_merge_tensors(G0tensor(60),[G0tensor(56),G0tensor(28),G0tensor(7),G0tensor(4),G0tensor(26)])
  call ol_merge_tensors(G0tensor(71),[G0tensor(52),G0tensor(37),G0tensor(12),G0tensor(19),G0tensor(2)])
  call ol_merge_tensors(G0tensor(44),[G0tensor(33),G0tensor(13),G0tensor(9)])
  call ol_merge_tensors(G0tensor(32),[G0tensor(17)])
  call ol_merge_tensors(G0tensor(72),[G0tensor(22),G0tensor(18)])
  call ol_merge_tensors(G0tensor(78),[G0tensor(73),G0tensor(68),G0tensor(63),G0tensor(50),G0tensor(45),G0tensor(40),G0tensor(35) &
    ,G0tensor(30),G0tensor(25)])
  call ol_merge_tensors(G0tensor(77),[G0tensor(34),G0tensor(27)])
  call ol_merge_tensors(G0tensor(42),[G0tensor(38)])
  call ol_merge_tensors(G0tensor(62),[G0tensor(47),G0tensor(39)])
  call ol_merge_tensors(G0tensor(66),[G0tensor(48),G0tensor(43)])
  call ol_merge_tensors(G0tensor(76),[G0tensor(67),G0tensor(57),G0tensor(54)])
  call ol_merge_tensors(G0tensor(65),[G0tensor(61)])
  call ol_merge_tensors(G0tensor(75),[G0tensor(70)])
  call ol_merge_tensors(T0sum(24),[G0tensor(15)])
  call ol_merge_tensors(T0sum(25),[G0tensor(53)])
  call ol_merge_tensors(T0sum(26),[G0tensor(58)])
  call ol_merge_tensors(T0sum(27),[G0tensor(60)])
  call ol_merge_tensors(T0sum(28),[G0tensor(71)])
  call ol_merge_tensors(T0sum(29),[G0tensor(44)])
  call ol_merge_tensors(T0sum(30),[G0tensor(32)])
  call ol_merge_tensors(T0sum(31),[G0tensor(72)])
  call ol_merge_tensors(T0sum(32),[G0tensor(78)])
  call ol_merge_tensors(T0sum(33),[G0tensor(77)])
  call ol_merge_tensors(T0sum(34),[G0tensor(42)])
  call ol_merge_tensors(T0sum(35),[G0tensor(62)])
  call ol_merge_tensors(T0sum(36),[G0tensor(66)])
  call ol_merge_tensors(T0sum(37),[G0tensor(76)])
  call ol_merge_tensors(T0sum(38),[G0tensor(65)])
  call ol_merge_tensors(T0sum(39),[G0tensor(75)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppllj_ew_eexddx_2_/**/REALKIND
