
! **********************************************************************
module ol_tables_storage_ppllj_ew_eexuuxg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(32,243)
integer(intkind2), save :: heltab2x2(2,2,102)
integer(intkind2), save :: heltab2x4(2,4,68)
integer(intkind2), save :: heltab2x8(2,8,73)
integer(intkind2), save :: heltab2x16(2,16,55)
integer(intkind2), save :: heltab2x32(2,32,243)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(243)
integer(intkind2), save :: m3h2x1(3,102)
integer(intkind2), save :: m3h4x1(3,31)
integer(intkind2), save :: m3h8x1(3,20)
integer(intkind2), save :: m3h2x2(3,37)
integer(intkind2), save :: m3h4x2(3,24)
integer(intkind2), save :: m3h8x2(3,8)
integer(intkind2), save :: m3h2x4(3,29)
integer(intkind2), save :: m3h4x4(3,26)
integer(intkind2), save :: m3h8x4(3,124)
integer(intkind2), save :: m3h2x8(3,21)
integer(intkind2), save :: m3h4x8(3,54)
integer(intkind2), save :: m3h2x16(3,65)

integer(intkind2), save :: n2h1(125)
integer(intkind2), save :: n2h2(21)
integer(intkind2), save :: n2h4(121)
integer(intkind2), save :: n2h8(30)
integer(intkind2), save :: n2h16(59)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppllj_ew_eexuuxg_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppllj_ew_eexuuxg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G2H1(1)
  type(hol), save :: G1H2(54)
  type(hol), save :: G2H2(17)
  type(hol), save :: G0H4(18)
  type(hol), save :: G1H4(92)
  type(hol), save :: G2H4(14)
  type(hol), save :: G0H8(18)
  type(hol), save :: G1H8(18)
  type(hol), save :: G2H8(2)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(36)
  type(hol), save :: G0H32(1)
  type(hcl), save, dimension(380) :: G0tensor
  type(hcl), save, dimension(240) :: G1tensor
  type(hcl), save, dimension(68) :: G2tensor
  type(hcl), save, dimension(6) :: G3tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(30)
type (redset4),    save :: RedSet_4(15)
type (redset5),    save :: RedSet_5(2)
integer, save :: mass2set(0:1,11)
integer, save :: mass3set(0:2,15)
integer, save :: mass4set(0:3,13)
integer, save :: mass5set(0:4,5)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(3)
  integer, save :: momenta_16(3)
  integer, save :: momenta_17(3)
  integer, save :: momenta_18(3)
  integer, save :: momenta_19(3)
  integer, save :: momenta_20(3)
  integer, save :: momenta_21(3)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(4)
  integer, save :: momenta_41(4)
  integer, save :: momenta_42(4)
  integer, save :: momenta_43(4)
  integer, save :: momenta_44(4)
  integer, save :: momenta_45(4)
  integer, save :: momenta_46(4)
  integer, save :: momenta_47(4)
  integer, save :: momenta_48(4)
  integer, save :: momenta_49(4)
  integer, save :: momenta_50(4)
  integer, save :: momenta_51(4)
  integer, save :: momenta_52(4)
  integer, save :: momenta_53(5)
  integer, save :: momenta_54(5)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(2)
  integer, save :: masses2_9(2)
  integer, save :: masses2_10(2)
  integer, save :: masses2_11(2)
  integer, save :: masses2_12(2)
  integer, save :: masses2_13(2)
  integer, save :: masses2_14(2)
  integer, save :: masses2_15(2)
  integer, save :: masses2_16(2)
  integer, save :: masses2_17(2)
  integer, save :: masses2_18(3)
  integer, save :: masses2_19(3)
  integer, save :: masses2_20(3)
  integer, save :: masses2_21(3)
  integer, save :: masses2_22(3)
  integer, save :: masses2_23(3)
  integer, save :: masses2_24(3)
  integer, save :: masses2_25(3)
  integer, save :: masses2_26(3)
  integer, save :: masses2_27(3)
  integer, save :: masses2_28(3)
  integer, save :: masses2_29(3)
  integer, save :: masses2_30(3)
  integer, save :: masses2_31(3)
  integer, save :: masses2_32(3)
  integer, save :: masses2_33(4)
  integer, save :: masses2_34(4)
  integer, save :: masses2_35(4)
  integer, save :: masses2_36(4)
  integer, save :: masses2_37(4)
  integer, save :: masses2_38(4)
  integer, save :: masses2_39(4)
  integer, save :: masses2_40(4)
  integer, save :: masses2_41(4)
  integer, save :: masses2_42(4)
  integer, save :: masses2_43(4)
  integer, save :: masses2_44(4)
  integer, save :: masses2_45(4)
  integer, save :: masses2_46(5)
  integer, save :: masses2_47(5)
  integer, save :: masses2_48(5)
  integer, save :: masses2_49(5)
  integer, save :: masses2_50(5)

type(scalarbox), save :: ScalarBoxes(33)

integer, save :: sbarray_1(5)
integer, save :: sbarray_2(5)
integer, save :: sbarray_3(5)
integer, save :: sbarray_4(5)
integer, save :: sbarray_5(5)
integer, save :: sbarray_6(5)
integer, save :: sbarray_7(5)
integer, save :: sbarray_8(5)
integer, save :: sbarray_9(5)

  type(hcl), save, dimension(186) :: T0sum
  type(hcl), save, dimension(9) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllj_ew_eexuuxg_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,15,4,1,G2H1,1)
  call hol_allocation(4,5,4,2,G1H2,54)
  call hol_allocation(4,15,4,2,G2H2,17)
  call hol_allocation(4,1,4,4,G0H4,18)
  call hol_allocation(4,5,4,4,G1H4,92)
  call hol_allocation(4,15,4,4,G2H4,14)
  call hol_allocation(4,1,4,8,G0H8,18)
  call hol_allocation(4,5,4,8,G1H8,18)
  call hol_allocation(4,15,4,8,G2H8,2)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,36)
  call hol_allocation(4,1,4,32,G0H32,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllj_ew_eexuuxg_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,15,4,min(nhel,1),G2H1,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,54)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,17)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,18)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,92)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,14)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,18)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,18)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,2)
  call hol_allocation(4,1,4,min(nhel,16),G0H16,1)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,36)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G2H1,1,dmode)
  call hol_deallocation(G1H2,54,dmode)
  call hol_deallocation(G2H2,17,dmode)
  call hol_deallocation(G0H4,18,dmode)
  call hol_deallocation(G1H4,92,dmode)
  call hol_deallocation(G2H4,14,dmode)
  call hol_deallocation(G0H8,18,dmode)
  call hol_deallocation(G1H8,18,dmode)
  call hol_deallocation(G2H8,2,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,36,dmode)
  call hol_deallocation(G0H32,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 380)
call hcl_allocation(5,G1tensor, 240)
call hcl_allocation(15,G2tensor, 68)
call hcl_allocation(35,G3tensor, 6)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 380,dmode)
call hcl_deallocation(G1tensor, 240,dmode)
call hcl_deallocation(G2tensor, 68,dmode)
call hcl_deallocation(G3tensor, 6,dmode)

    call hcl_deallocation(T0sum,186,dmode)
  call hcl_deallocation(T1sum,9,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,186)
  call hcl_allocation(5,T1sum,9)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppllj_ew_eexuuxg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppllj_ew_eexuuxg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,186
    call init_hcl(T0sum(i))
  end do
  do i = 1,9
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T1sum(4)%cmp, 4)
  call scale_one_tsum(T1sum(5)%cmp, 4)
  call scale_one_tsum(T1sum(6)%cmp, 4)
  call scale_one_tsum(T1sum(7)%cmp, 4)
  call scale_one_tsum(T1sum(8)%cmp, 4)
  call scale_one_tsum(T1sum(9)%cmp, 4)
  call scale_one_tsum(T0sum(1)%cmp, 2)
  call scale_one_tsum(T0sum(2)%cmp, 2)
  call scale_one_tsum(T0sum(3)%cmp, 2)
  call scale_one_tsum(T0sum(4)%cmp, 2)
  call scale_one_tsum(T0sum(5)%cmp, 2)
  call scale_one_tsum(T0sum(6)%cmp, 2)
  call scale_one_tsum(T0sum(7)%cmp, 2)
  call scale_one_tsum(T0sum(8)%cmp, 2)
  call scale_one_tsum(T0sum(9)%cmp, 2)
  call scale_one_tsum(T0sum(10)%cmp, 2)
  call scale_one_tsum(T0sum(11)%cmp, 2)
  call scale_one_tsum(T0sum(12)%cmp, 2)
  call scale_one_tsum(T0sum(13)%cmp, 2)
  call scale_one_tsum(T0sum(14)%cmp, 2)
  call scale_one_tsum(T0sum(15)%cmp, 2)
  call scale_one_tsum(T0sum(16)%cmp, 2)
  call scale_one_tsum(T0sum(17)%cmp, 2)
  call scale_one_tsum(T0sum(18)%cmp, 2)
  call scale_one_tsum(T0sum(19)%cmp, 2)
  call scale_one_tsum(T0sum(20)%cmp, 2)
  call scale_one_tsum(T0sum(21)%cmp, 2)
  call scale_one_tsum(T0sum(22)%cmp, 2)
  call scale_one_tsum(T0sum(23)%cmp, 2)
  call scale_one_tsum(T0sum(24)%cmp, 2)
  call scale_one_tsum(T0sum(25)%cmp, 2)
  call scale_one_tsum(T0sum(26)%cmp, 2)
  call scale_one_tsum(T0sum(27)%cmp, 2)
  call scale_one_tsum(T0sum(28)%cmp, 2)
  call scale_one_tsum(T0sum(29)%cmp, 2)
  call scale_one_tsum(T0sum(30)%cmp, 2)
  call scale_one_tsum(T0sum(31)%cmp, 2)
  call scale_one_tsum(T0sum(32)%cmp, 2)
  call scale_one_tsum(T0sum(33)%cmp, 2)
  call scale_one_tsum(T0sum(34)%cmp, 2)
  call scale_one_tsum(T0sum(35)%cmp, 2)
  call scale_one_tsum(T0sum(36)%cmp, 2)
  call scale_one_tsum(T0sum(37)%cmp, 2)
  call scale_one_tsum(T0sum(38)%cmp, 2)
  call scale_one_tsum(T0sum(39)%cmp, 2)
  call scale_one_tsum(T0sum(40)%cmp, 2)
  call scale_one_tsum(T0sum(41)%cmp, 2)
  call scale_one_tsum(T0sum(42)%cmp, 2)
  call scale_one_tsum(T0sum(43)%cmp, 2)
  call scale_one_tsum(T0sum(44)%cmp, 2)
  call scale_one_tsum(T0sum(45)%cmp, 2)
  call scale_one_tsum(T0sum(46)%cmp, 2)
  call scale_one_tsum(T0sum(47)%cmp, 2)
  call scale_one_tsum(T0sum(48)%cmp, 2)
  call scale_one_tsum(T0sum(49)%cmp, 0)
  call scale_one_tsum(T0sum(50)%cmp, 0)
  call scale_one_tsum(T0sum(51)%cmp, 0)
  call scale_one_tsum(T0sum(52)%cmp, 0)
  call scale_one_tsum(T0sum(53)%cmp, 0)
  call scale_one_tsum(T0sum(54)%cmp, 0)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, 0)
  call scale_one_tsum(T0sum(58)%cmp, 0)
  call scale_one_tsum(T0sum(59)%cmp, 0)
  call scale_one_tsum(T0sum(60)%cmp, 0)
  call scale_one_tsum(T0sum(61)%cmp, 0)
  call scale_one_tsum(T0sum(62)%cmp, 0)
  call scale_one_tsum(T0sum(63)%cmp, 0)
  call scale_one_tsum(T0sum(64)%cmp, 0)
  call scale_one_tsum(T0sum(65)%cmp, 0)
  call scale_one_tsum(T0sum(66)%cmp, 0)
  call scale_one_tsum(T0sum(67)%cmp, 0)
  call scale_one_tsum(T0sum(68)%cmp, 0)
  call scale_one_tsum(T0sum(69)%cmp, 0)
  call scale_one_tsum(T0sum(70)%cmp, 0)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, 0)
  call scale_one_tsum(T0sum(108)%cmp, 0)
  call scale_one_tsum(T0sum(109)%cmp, 0)
  call scale_one_tsum(T0sum(110)%cmp, 0)
  call scale_one_tsum(T0sum(111)%cmp, 0)
  call scale_one_tsum(T0sum(112)%cmp, 0)
  call scale_one_tsum(T0sum(113)%cmp, 0)
  call scale_one_tsum(T0sum(114)%cmp, 0)
  call scale_one_tsum(T0sum(115)%cmp, 0)
  call scale_one_tsum(T0sum(116)%cmp, 0)
  call scale_one_tsum(T0sum(117)%cmp, 0)
  call scale_one_tsum(T0sum(118)%cmp, 0)
  call scale_one_tsum(T0sum(119)%cmp, 0)
  call scale_one_tsum(T0sum(120)%cmp, 0)
  call scale_one_tsum(T0sum(121)%cmp, 0)
  call scale_one_tsum(T0sum(122)%cmp, 0)
  call scale_one_tsum(T0sum(123)%cmp, 0)
  call scale_one_tsum(T0sum(124)%cmp, 0)
  call scale_one_tsum(T0sum(125)%cmp, 0)
  call scale_one_tsum(T0sum(126)%cmp, 0)
  call scale_one_tsum(T0sum(127)%cmp, 0)
  call scale_one_tsum(T0sum(128)%cmp, 0)
  call scale_one_tsum(T0sum(129)%cmp, 0)
  call scale_one_tsum(T0sum(130)%cmp, -2)
  call scale_one_tsum(T0sum(131)%cmp, -2)
  call scale_one_tsum(T0sum(132)%cmp, -2)
  call scale_one_tsum(T0sum(133)%cmp, -2)
  call scale_one_tsum(T0sum(134)%cmp, -2)
  call scale_one_tsum(T0sum(135)%cmp, -2)
  call scale_one_tsum(T0sum(136)%cmp, -2)
  call scale_one_tsum(T0sum(137)%cmp, -2)
  call scale_one_tsum(T0sum(138)%cmp, -2)
  call scale_one_tsum(T0sum(139)%cmp, -2)
  call scale_one_tsum(T0sum(140)%cmp, -2)
  call scale_one_tsum(T0sum(141)%cmp, -2)
  call scale_one_tsum(T0sum(142)%cmp, -2)
  call scale_one_tsum(T0sum(143)%cmp, -2)
  call scale_one_tsum(T0sum(144)%cmp, -2)
  call scale_one_tsum(T0sum(145)%cmp, -2)
  call scale_one_tsum(T0sum(146)%cmp, -2)
  call scale_one_tsum(T0sum(147)%cmp, -2)
  call scale_one_tsum(T0sum(148)%cmp, -2)
  call scale_one_tsum(T0sum(149)%cmp, -2)
  call scale_one_tsum(T0sum(150)%cmp, -2)
  call scale_one_tsum(T0sum(151)%cmp, -2)
  call scale_one_tsum(T0sum(152)%cmp, -2)
  call scale_one_tsum(T0sum(153)%cmp, -2)
  call scale_one_tsum(T0sum(154)%cmp, -2)
  call scale_one_tsum(T0sum(155)%cmp, -2)
  call scale_one_tsum(T0sum(156)%cmp, -2)
  call scale_one_tsum(T0sum(157)%cmp, -2)
  call scale_one_tsum(T0sum(158)%cmp, -2)
  call scale_one_tsum(T0sum(159)%cmp, -2)
  call scale_one_tsum(T0sum(160)%cmp, -2)
  call scale_one_tsum(T0sum(161)%cmp, -2)
  call scale_one_tsum(T0sum(162)%cmp, -2)
  call scale_one_tsum(T0sum(163)%cmp, -2)
  call scale_one_tsum(T0sum(164)%cmp, -2)
  call scale_one_tsum(T0sum(165)%cmp, -2)
  call scale_one_tsum(T0sum(166)%cmp, -2)
  call scale_one_tsum(T0sum(167)%cmp, -2)
  call scale_one_tsum(T0sum(168)%cmp, -2)
  call scale_one_tsum(T0sum(169)%cmp, -2)
  call scale_one_tsum(T0sum(170)%cmp, -2)
  call scale_one_tsum(T0sum(171)%cmp, -2)
  call scale_one_tsum(T0sum(172)%cmp, -2)
  call scale_one_tsum(T0sum(173)%cmp, -2)
  call scale_one_tsum(T0sum(174)%cmp, -2)
  call scale_one_tsum(T0sum(175)%cmp, -2)
  call scale_one_tsum(T0sum(176)%cmp, -2)
  call scale_one_tsum(T0sum(177)%cmp, -2)
  call scale_one_tsum(T0sum(178)%cmp, -2)
  call scale_one_tsum(T0sum(179)%cmp, -2)
  call scale_one_tsum(T0sum(180)%cmp, -2)
  call scale_one_tsum(T0sum(181)%cmp, -2)
  call scale_one_tsum(T0sum(182)%cmp, -2)
  call scale_one_tsum(T0sum(183)%cmp, -2)
  call scale_one_tsum(T0sum(184)%cmp, -2)
  call scale_one_tsum(T0sum(185)%cmp, -2)
  call scale_one_tsum(T0sum(186)%cmp, -2)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 16, 15 ]
  momenta_3 = [ 19, 12 ]
  momenta_4 = [ 20, 11 ]
  momenta_5 = [ 21, 10 ]
  momenta_6 = [ 22, 9 ]
  momenta_7 = [ 23, 8 ]
  momenta_8 = [ 24, 7 ]
  momenta_9 = [ 25, 6 ]
  momenta_10 = [ 26, 5 ]
  momenta_11 = [ 27, 4 ]
  momenta_12 = [ 28, 3 ]
  momenta_13 = [ 29, 2 ]
  momenta_14 = [ 30, 1 ]
  momenta_15 = [ 16, 3, 12 ]
  momenta_16 = [ 16, 4, 11 ]
  momenta_17 = [ 16, 5, 10 ]
  momenta_18 = [ 16, 6, 9 ]
  momenta_19 = [ 16, 7, 8 ]
  momenta_20 = [ 16, 11, 4 ]
  momenta_21 = [ 19, 4, 8 ]
  momenta_22 = [ 19, 8, 4 ]
  momenta_23 = [ 20, 1, 10 ]
  momenta_24 = [ 20, 2, 9 ]
  momenta_25 = [ 20, 3, 8 ]
  momenta_26 = [ 21, 2, 8 ]
  momenta_27 = [ 22, 1, 8 ]
  momenta_28 = [ 24, 1, 6 ]
  momenta_29 = [ 24, 2, 5 ]
  momenta_30 = [ 24, 3, 4 ]
  momenta_31 = [ 24, 4, 3 ]
  momenta_32 = [ 24, 5, 2 ]
  momenta_33 = [ 24, 6, 1 ]
  momenta_34 = [ 25, 2, 4 ]
  momenta_35 = [ 25, 4, 2 ]
  momenta_36 = [ 26, 1, 4 ]
  momenta_37 = [ 26, 4, 1 ]
  momenta_38 = [ 28, 1, 2 ]
  momenta_39 = [ 28, 2, 1 ]
  momenta_40 = [ 16, 3, 4, 8 ]
  momenta_41 = [ 16, 3, 8, 4 ]
  momenta_42 = [ 16, 4, 1, 10 ]
  momenta_43 = [ 16, 4, 2, 9 ]
  momenta_44 = [ 16, 4, 3, 8 ]
  momenta_45 = [ 16, 5, 2, 8 ]
  momenta_46 = [ 16, 6, 1, 8 ]
  momenta_47 = [ 20, 1, 2, 8 ]
  momenta_48 = [ 20, 2, 1, 8 ]
  momenta_49 = [ 24, 1, 2, 4 ]
  momenta_50 = [ 24, 2, 1, 4 ]
  momenta_51 = [ 24, 4, 1, 2 ]
  momenta_52 = [ 24, 4, 2, 1 ]
  momenta_53 = [ 16, 4, 1, 2, 8 ]
  momenta_54 = [ 16, 4, 2, 1, 8 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMH, 0 ]
  masses2_4 = [ nML, 0 ]
  masses2_5 = [ nMM, 0 ]
  masses2_6 = [ nMT, 0 ]
  masses2_7 = [ nMW, 0 ]
  masses2_8 = [ nMZ, 0 ]
  masses2_9 = [ nMB, nMB ]
  masses2_10 = [ nMZ, nMH ]
  masses2_11 = [ nML, nML ]
  masses2_12 = [ nMM, nMM ]
  masses2_13 = [ nMT, nMT ]
  masses2_14 = [ 0, nMW ]
  masses2_15 = [ nMW, nMW ]
  masses2_16 = [ 0, nMZ ]
  masses2_17 = [ nMZ, nMZ ]
  masses2_18 = [ 0, 0, 0 ]
  masses2_19 = [ nMW, 0, 0 ]
  masses2_20 = [ nMZ, 0, 0 ]
  masses2_21 = [ 0, 0, nMW ]
  masses2_22 = [ nMW, 0, nMW ]
  masses2_23 = [ 0, 0, nMZ ]
  masses2_24 = [ nMZ, 0, nMZ ]
  masses2_25 = [ nMB, nMB, nMB ]
  masses2_26 = [ nMT, nMT, nMT ]
  masses2_27 = [ 0, nMW, 0 ]
  masses2_28 = [ nMW, nMW, 0 ]
  masses2_29 = [ 0, nMW, nMW ]
  masses2_30 = [ 0, nMZ, 0 ]
  masses2_31 = [ nMZ, nMZ, 0 ]
  masses2_32 = [ 0, nMZ, nMZ ]
  masses2_33 = [ 0, 0, 0, 0 ]
  masses2_34 = [ nMZ, 0, 0, 0 ]
  masses2_35 = [ 0, 0, 0, nMW ]
  masses2_36 = [ 0, 0, 0, nMZ ]
  masses2_37 = [ 0, 0, nMW, 0 ]
  masses2_38 = [ nMW, 0, nMW, 0 ]
  masses2_39 = [ 0, 0, nMW, nMW ]
  masses2_40 = [ 0, 0, nMZ, 0 ]
  masses2_41 = [ nMZ, 0, nMZ, 0 ]
  masses2_42 = [ 0, 0, nMZ, nMZ ]
  masses2_43 = [ 0, nMW, 0, nMW ]
  masses2_44 = [ 0, nMZ, 0, 0 ]
  masses2_45 = [ 0, nMZ, 0, nMZ ]
  masses2_46 = [ 0, 0, 0, 0, 0 ]
  masses2_47 = [ 0, 0, 0, 0, nMZ ]
  masses2_48 = [ 0, 0, nMW, 0, nMW ]
  masses2_49 = [ 0, 0, nMZ, 0, 0 ]
  masses2_50 = [ 0, 0, nMZ, 0, nMZ ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5]
sbarray_2 = [6, 7, 8, 4, 9]
sbarray_3 = [10, 2, 11, 12, 13]
sbarray_4 = [14, 7, 15, 12, 16]
sbarray_5 = [17, 18, 19, 20, 21]
sbarray_6 = [22, 23, 3, 24, 25]
sbarray_7 = [26, 23, 11, 27, 28]
sbarray_8 = [29, 30, 8, 24, 31]
sbarray_9 = [32, 30, 15, 27, 33]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_51, masses2_33, T0sum(1), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_42, masses2_33, T0sum(2), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_51, masses2_34, T0sum(3), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_51, masses2_40, T0sum(4), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_42, masses2_40, T0sum(5), M2,[12], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_51, masses2_41, T0sum(6), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_51, masses2_38, T0sum(7), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_42, masses2_37, T0sum(8), M2,[20], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_52, masses2_33, T0sum(9), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_43, masses2_33, T0sum(10), M2,[24], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_52, masses2_40, T0sum(11), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_43, masses2_40, T0sum(12), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_52, masses2_34, T0sum(13), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_52, masses2_41, T0sum(14), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_47, masses2_33, T0sum(15), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_45, masses2_33, T0sum(16), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_44, masses2_33, T0sum(17), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_47, masses2_36, T0sum(18), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_45, masses2_36, T0sum(19), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_44, masses2_36, T0sum(20), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_47, masses2_44, T0sum(21), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_44, masses2_40, T0sum(22), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_47, masses2_45, T0sum(23), M2,[14], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_44, masses2_42, T0sum(24), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_47, masses2_43, T0sum(25), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_45, masses2_35, T0sum(26), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_44, masses2_39, T0sum(27), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_48, masses2_33, T0sum(28), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_46, masses2_33, T0sum(29), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_48, masses2_44, T0sum(30), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_48, masses2_36, T0sum(31), M2,[29], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_46, masses2_36, T0sum(32), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_48, masses2_45, T0sum(33), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_50, masses2_33, T0sum(34), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_50, masses2_44, T0sum(35), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_50, masses2_36, T0sum(36), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_50, masses2_45, T0sum(37), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_50, masses2_43, T0sum(38), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_49, masses2_33, T0sum(39), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_49, masses2_36, T0sum(40), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_49, masses2_44, T0sum(41), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_49, masses2_45, T0sum(42), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_41, masses2_33, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_41, masses2_36, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_41, masses2_35, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_40, masses2_33, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_40, masses2_36, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_40, masses2_35, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_16, masses2_18, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_31, masses2_22, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_16, masses2_21, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_25, masses2_18, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_15, masses2_18, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_25, masses2_20, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_25, masses2_19, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_30, masses2_18, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_30, masses2_20, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_30, masses2_19, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_37, masses2_18, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_38, masses2_18, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_32, masses2_18, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_31, masses2_18, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_23, masses2_18, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_17, masses2_18, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_38, masses2_20, T0sum(65), M2)
  call TI_call_OL(0,0, momenta_32, masses2_20, T0sum(66), M2)
  call TI_call_OL(0,0, momenta_31, masses2_20, T0sum(67), M2)
  call TI_call_OL(0,0, momenta_37, masses2_23, T0sum(68), M2)
  call TI_call_OL(0,0, momenta_38, masses2_30, T0sum(69), M2)
  call TI_call_OL(0,0, momenta_31, masses2_23, T0sum(70), M2)
  call TI_call_OL(0,0, momenta_23, masses2_30, T0sum(71), M2)
  call TI_call_OL(0,0, momenta_16, masses2_23, T0sum(72), M2)
  call TI_call_OL(0,0, momenta_38, masses2_31, T0sum(73), M2)
  call TI_call_OL(0,0, momenta_31, masses2_24, T0sum(74), M2)
  call TI_call_OL(0,0, momenta_37, masses2_21, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_38, masses2_28, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_32, masses2_19, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_23, masses2_27, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_35, masses2_18, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_39, masses2_18, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_33, masses2_18, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_24, masses2_18, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_18, masses2_18, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_35, masses2_23, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_39, masses2_30, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_24, masses2_30, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_39, masses2_20, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_33, masses2_20, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_39, masses2_31, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_26, masses2_18, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_19, masses2_18, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_26, masses2_23, T0sum(92), M2)
  call TI_call_OL(0,0, momenta_25, masses2_23, T0sum(93), M2)
  call TI_call_OL(0,0, momenta_19, masses2_23, T0sum(94), M2)
  call TI_call_OL(0,0, momenta_25, masses2_30, T0sum(95), M2)
  call TI_call_OL(0,0, momenta_25, masses2_32, T0sum(96), M2)
  call TI_call_OL(0,0, momenta_26, masses2_21, T0sum(97), M2)
  call TI_call_OL(0,0, momenta_25, masses2_29, T0sum(98), M2)
  call TI_call_OL(0,0, momenta_19, masses2_21, T0sum(99), M2)
  call TI_call_OL(0,0, momenta_27, masses2_18, T0sum(100), M2)
  call TI_call_OL(0,0, momenta_27, masses2_23, T0sum(101), M2)
  call TI_call_OL(0,0, momenta_36, masses2_18, T0sum(102), M2)
  call TI_call_OL(0,0, momenta_29, masses2_18, T0sum(103), M2)
  call TI_call_OL(0,0, momenta_30, masses2_30, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_29, masses2_30, T0sum(105), M2)
  call TI_call_OL(0,0, momenta_36, masses2_23, T0sum(106), M2)
  call TI_call_OL(0,0, momenta_30, masses2_23, T0sum(107), M2)
  call TI_call_OL(0,0, momenta_30, masses2_32, T0sum(108), M2)
  call TI_call_OL(0,0, momenta_39, masses2_28, T0sum(109), M2)
  call TI_call_OL(0,0, momenta_36, masses2_21, T0sum(110), M2)
  call TI_call_OL(0,0, momenta_30, masses2_29, T0sum(111), M2)
  call TI_call_OL(0,0, momenta_29, masses2_27, T0sum(112), M2)
  call TI_call_OL(0,0, momenta_34, masses2_18, T0sum(113), M2)
  call TI_call_OL(0,0, momenta_28, masses2_18, T0sum(114), M2)
  call TI_call_OL(0,0, momenta_34, masses2_23, T0sum(115), M2)
  call TI_call_OL(0,0, momenta_28, masses2_30, T0sum(116), M2)
  call TI_call_OL(0,0, momenta_22, masses2_18, T0sum(117), M2)
  call TI_call_OL(0,0, momenta_20, masses2_18, T0sum(118), M2)
  call TI_call_OL(0,0, momenta_22, masses2_23, T0sum(119), M2)
  call TI_call_OL(0,0, momenta_20, masses2_23, T0sum(120), M2)
  call TI_call_OL(0,0, momenta_22, masses2_21, T0sum(121), M2)
  call TI_call_OL(0,0, momenta_20, masses2_21, T0sum(122), M2)
  call TI_call_OL(0,0, momenta_21, masses2_18, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_21, masses2_23, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_21, masses2_21, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_15, masses2_26, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_15, masses2_25, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_38, masses2_23, T0sum(128), M2)
  call TI_call_OL(0,0, momenta_38, masses2_21, T0sum(129), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(130), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(131), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(132), M2)
  call TI_call_OL(0,0, momenta_11, masses2_7, T0sum(133), M2)
  call TI_call_OL(0,0, momenta_12, masses2_15, T0sum(134), M2)
  call TI_call_OL(0,0, momenta_1, masses2_7, T0sum(135), M2)
  call TI_call_OL(0,0, momenta_8, masses2_7, T0sum(136), M2)
  call TI_call_OL(0,0, momenta_4, masses2_14, T0sum(137), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(138), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(139), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(140), M2)
  call TI_call_OL(0,0, momenta_7, masses2_8, T0sum(141), M2)
  call TI_call_OL(0,0, momenta_4, masses2_8, T0sum(142), M2)
  call TI_call_OL(0,0, momenta_1, masses2_8, T0sum(143), M2)
  call TI_call_OL(0,0, momenta_7, masses2_7, T0sum(144), M2)
  call TI_call_OL(0,0, momenta_4, masses2_7, T0sum(145), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(146), M2)
  call TI_call_OL(0,0, momenta_11, masses2_8, T0sum(147), M2)
  call TI_call_OL(0,0, momenta_8, masses2_8, T0sum(148), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(149), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(150), M2)
  call TI_call_OL(0,0, momenta_4, masses2_16, T0sum(151), M2)
  call TI_call_OL(0,0, momenta_14, masses2_14, T0sum(152), M2)
  call TI_call_OL(0,0, momenta_13, masses2_7, T0sum(153), M2)
  call TI_call_OL(0,0, momenta_7, masses2_16, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_7, masses2_14, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_11, masses2_14, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_8, masses2_14, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_11, masses2_16, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_12, masses2_13, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_1, masses2_6, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_3, masses2_13, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_2, masses2_13, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_12, masses2_9, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_3, masses2_9, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_2, masses2_9, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_14, masses2_8, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_13, masses2_16, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_14, masses2_7, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_13, masses2_14, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_13, masses2_8, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_12, masses2_8, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_14, masses2_16, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_12, masses2_16, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_12, masses2_17, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_8, masses2_16, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_12, masses2_12, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_1, masses2_5, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_12, masses2_11, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_1, masses2_4, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_12, masses2_10, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(186), M2)

  call TI_call_OL(0,1, momenta_53, masses2_46, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_53, masses2_47, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_53, masses2_49, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_53, masses2_50, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_53, masses2_48, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_54, masses2_46, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_54, masses2_49, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_54, masses2_47, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_54, masses2_50, T1sum(9), M2,sbarray_9, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppllj_ew_eexuuxg_1_/**/REALKIND
