
! **********************************************************************
module ol_tables_storage_ppllj_ew_eexddxg_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(32,16)
integer(intkind2), save :: heltab2x2(2,2,26)
integer(intkind2), save :: heltab2x4(2,4,9)
integer(intkind2), save :: heltab2x8(2,8,11)
integer(intkind2), save :: heltab2x16(2,16,6)
integer(intkind2), save :: heltab2x32(2,32,16)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(16)
integer(intkind2), save :: m3h2x1(3,26)
integer(intkind2), save :: m3h8x1(3,3)
integer(intkind2), save :: m3h2x2(3,9)
integer(intkind2), save :: m3h4x2(3,2)
integer(intkind2), save :: m3h8x2(3,1)
integer(intkind2), save :: m3h2x4(3,6)
integer(intkind2), save :: m3h4x4(3,2)
integer(intkind2), save :: m3h8x4(3,2)
integer(intkind2), save :: m3h2x8(3,3)
integer(intkind2), save :: m3h4x8(3,8)
integer(intkind2), save :: m3h2x16(3,6)

integer(intkind2), save :: n2h1(26)
integer(intkind2), save :: n2h2(2)
integer(intkind2), save :: n2h4(10)
integer(intkind2), save :: n2h8(3)
integer(intkind2), save :: n2h16(6)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppllj_ew_eexddxg_3_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppllj_ew_eexddxg_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(12)
  type(hol), save :: G2H2(2)
  type(hol), save :: G0H4(1)
  type(hol), save :: G1H4(4)
  type(hol), save :: G2H4(2)
  type(hol), save :: G0H8(4)
  type(hol), save :: G1H8(2)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(2)
  type(hol), save :: G0H32(1)
  type(hcl), save, dimension(100) :: G0tensor
  type(hcl), save, dimension(65) :: G1tensor
  type(hcl), save, dimension(17) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(30)
type (redset4),    save :: RedSet_4(15)
type (redset5),    save :: RedSet_5(2)
integer, save :: mass2set(0:1,1)
integer, save :: mass3set(0:2,1)
integer, save :: mass4set(0:3,1)
integer, save :: mass5set(0:4,1)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(3)
  integer, save :: momenta_15(3)
  integer, save :: momenta_16(3)
  integer, save :: momenta_17(3)
  integer, save :: momenta_18(3)
  integer, save :: momenta_19(3)
  integer, save :: momenta_20(3)
  integer, save :: momenta_21(3)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(4)
  integer, save :: momenta_40(4)
  integer, save :: momenta_41(4)
  integer, save :: momenta_42(4)
  integer, save :: momenta_43(4)
  integer, save :: momenta_44(4)
  integer, save :: momenta_45(4)
  integer, save :: momenta_46(4)
  integer, save :: momenta_47(4)
  integer, save :: momenta_48(4)
  integer, save :: momenta_49(4)
  integer, save :: momenta_50(4)
  integer, save :: momenta_51(4)
  integer, save :: momenta_52(5)
  integer, save :: momenta_53(5)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(3)
  integer, save :: masses2_3(4)
  integer, save :: masses2_4(5)

type(scalarbox), save :: ScalarBoxes(9)

integer, save :: sbarray_1(5)
integer, save :: sbarray_2(5)

  type(hcl), save, dimension(51) :: T0sum
  type(hcl), save, dimension(2) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllj_ew_eexddxg_3_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,12)
  call hol_allocation(4,15,4,2,G2H2,2)
  call hol_allocation(4,1,4,4,G0H4,1)
  call hol_allocation(4,5,4,4,G1H4,4)
  call hol_allocation(4,15,4,4,G2H4,2)
  call hol_allocation(4,1,4,8,G0H8,4)
  call hol_allocation(4,5,4,8,G1H8,2)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,2)
  call hol_allocation(4,1,4,32,G0H32,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllj_ew_eexddxg_3_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,12)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,2)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,1)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,4)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,2)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,4)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,2)
  call hol_allocation(4,1,4,min(nhel,16),G0H16,1)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,2)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,12,dmode)
  call hol_deallocation(G2H2,2,dmode)
  call hol_deallocation(G0H4,1,dmode)
  call hol_deallocation(G1H4,4,dmode)
  call hol_deallocation(G2H4,2,dmode)
  call hol_deallocation(G0H8,4,dmode)
  call hol_deallocation(G1H8,2,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,2,dmode)
  call hol_deallocation(G0H32,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 100)
call hcl_allocation(5,G1tensor, 65)
call hcl_allocation(15,G2tensor, 17)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 100,dmode)
call hcl_deallocation(G1tensor, 65,dmode)
call hcl_deallocation(G2tensor, 17,dmode)

    call hcl_deallocation(T0sum,51,dmode)
  call hcl_deallocation(T1sum,2,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,51)
  call hcl_allocation(5,T1sum,2)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppllj_ew_eexddxg_3")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppllj_ew_eexddxg_3")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,51
    call init_hcl(T0sum(i))
  end do
  do i = 1,2
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T0sum(1)%cmp, 2)
  call scale_one_tsum(T0sum(2)%cmp, 2)
  call scale_one_tsum(T0sum(3)%cmp, 2)
  call scale_one_tsum(T0sum(4)%cmp, 2)
  call scale_one_tsum(T0sum(5)%cmp, 2)
  call scale_one_tsum(T0sum(6)%cmp, 2)
  call scale_one_tsum(T0sum(7)%cmp, 2)
  call scale_one_tsum(T0sum(8)%cmp, 2)
  call scale_one_tsum(T0sum(9)%cmp, 2)
  call scale_one_tsum(T0sum(10)%cmp, 2)
  call scale_one_tsum(T0sum(11)%cmp, 2)
  call scale_one_tsum(T0sum(12)%cmp, 2)
  call scale_one_tsum(T0sum(13)%cmp, 2)
  call scale_one_tsum(T0sum(14)%cmp, 0)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, -2)
  call scale_one_tsum(T0sum(40)%cmp, -2)
  call scale_one_tsum(T0sum(41)%cmp, -2)
  call scale_one_tsum(T0sum(42)%cmp, -2)
  call scale_one_tsum(T0sum(43)%cmp, -2)
  call scale_one_tsum(T0sum(44)%cmp, -2)
  call scale_one_tsum(T0sum(45)%cmp, -2)
  call scale_one_tsum(T0sum(46)%cmp, -2)
  call scale_one_tsum(T0sum(47)%cmp, -2)
  call scale_one_tsum(T0sum(48)%cmp, -2)
  call scale_one_tsum(T0sum(49)%cmp, -2)
  call scale_one_tsum(T0sum(50)%cmp, -2)
  call scale_one_tsum(T0sum(51)%cmp, -2)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 16, 15 ]
  momenta_2 = [ 19, 12 ]
  momenta_3 = [ 20, 11 ]
  momenta_4 = [ 21, 10 ]
  momenta_5 = [ 22, 9 ]
  momenta_6 = [ 23, 8 ]
  momenta_7 = [ 24, 7 ]
  momenta_8 = [ 25, 6 ]
  momenta_9 = [ 26, 5 ]
  momenta_10 = [ 27, 4 ]
  momenta_11 = [ 28, 3 ]
  momenta_12 = [ 29, 2 ]
  momenta_13 = [ 30, 1 ]
  momenta_14 = [ 16, 3, 12 ]
  momenta_15 = [ 16, 4, 11 ]
  momenta_16 = [ 16, 5, 10 ]
  momenta_17 = [ 16, 6, 9 ]
  momenta_18 = [ 16, 7, 8 ]
  momenta_19 = [ 16, 11, 4 ]
  momenta_20 = [ 19, 4, 8 ]
  momenta_21 = [ 19, 8, 4 ]
  momenta_22 = [ 20, 1, 10 ]
  momenta_23 = [ 20, 2, 9 ]
  momenta_24 = [ 20, 3, 8 ]
  momenta_25 = [ 21, 2, 8 ]
  momenta_26 = [ 22, 1, 8 ]
  momenta_27 = [ 24, 1, 6 ]
  momenta_28 = [ 24, 2, 5 ]
  momenta_29 = [ 24, 3, 4 ]
  momenta_30 = [ 24, 4, 3 ]
  momenta_31 = [ 24, 5, 2 ]
  momenta_32 = [ 24, 6, 1 ]
  momenta_33 = [ 25, 2, 4 ]
  momenta_34 = [ 25, 4, 2 ]
  momenta_35 = [ 26, 1, 4 ]
  momenta_36 = [ 26, 4, 1 ]
  momenta_37 = [ 28, 1, 2 ]
  momenta_38 = [ 28, 2, 1 ]
  momenta_39 = [ 16, 3, 4, 8 ]
  momenta_40 = [ 16, 3, 8, 4 ]
  momenta_41 = [ 16, 4, 1, 10 ]
  momenta_42 = [ 16, 4, 2, 9 ]
  momenta_43 = [ 16, 4, 3, 8 ]
  momenta_44 = [ 16, 5, 2, 8 ]
  momenta_45 = [ 16, 6, 1, 8 ]
  momenta_46 = [ 20, 1, 2, 8 ]
  momenta_47 = [ 20, 2, 1, 8 ]
  momenta_48 = [ 24, 1, 2, 4 ]
  momenta_49 = [ 24, 2, 1, 4 ]
  momenta_50 = [ 24, 4, 1, 2 ]
  momenta_51 = [ 24, 4, 2, 1 ]
  momenta_52 = [ 16, 4, 1, 2, 8 ]
  momenta_53 = [ 16, 4, 2, 1, 8 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ 0, 0, 0 ]
  masses2_3 = [ 0, 0, 0, 0 ]
  masses2_4 = [ 0, 0, 0, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5]
sbarray_2 = [6, 7, 3, 8, 9]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_50, masses2_3, T0sum(1), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_41, masses2_3, T0sum(2), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_51, masses2_3, T0sum(3), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_42, masses2_3, T0sum(4), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_46, masses2_3, T0sum(5), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_44, masses2_3, T0sum(6), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_43, masses2_3, T0sum(7), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_47, masses2_3, T0sum(8), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_45, masses2_3, T0sum(9), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_49, masses2_3, T0sum(10), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_48, masses2_3, T0sum(11), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_40, masses2_3, T0sum(12), M2)
  call TI_call_OL(0,0, momenta_39, masses2_3, T0sum(13), M2)
  call TI_call_OL(0,0, momenta_24, masses2_2, T0sum(14), M2)
  call TI_call_OL(0,0, momenta_14, masses2_2, T0sum(15), M2)
  call TI_call_OL(0,0, momenta_29, masses2_2, T0sum(16), M2)
  call TI_call_OL(0,0, momenta_36, masses2_2, T0sum(17), M2)
  call TI_call_OL(0,0, momenta_37, masses2_2, T0sum(18), M2)
  call TI_call_OL(0,0, momenta_31, masses2_2, T0sum(19), M2)
  call TI_call_OL(0,0, momenta_30, masses2_2, T0sum(20), M2)
  call TI_call_OL(0,0, momenta_22, masses2_2, T0sum(21), M2)
  call TI_call_OL(0,0, momenta_16, masses2_2, T0sum(22), M2)
  call TI_call_OL(0,0, momenta_15, masses2_2, T0sum(23), M2)
  call TI_call_OL(0,0, momenta_34, masses2_2, T0sum(24), M2)
  call TI_call_OL(0,0, momenta_38, masses2_2, T0sum(25), M2)
  call TI_call_OL(0,0, momenta_32, masses2_2, T0sum(26), M2)
  call TI_call_OL(0,0, momenta_23, masses2_2, T0sum(27), M2)
  call TI_call_OL(0,0, momenta_17, masses2_2, T0sum(28), M2)
  call TI_call_OL(0,0, momenta_25, masses2_2, T0sum(29), M2)
  call TI_call_OL(0,0, momenta_18, masses2_2, T0sum(30), M2)
  call TI_call_OL(0,0, momenta_26, masses2_2, T0sum(31), M2)
  call TI_call_OL(0,0, momenta_35, masses2_2, T0sum(32), M2)
  call TI_call_OL(0,0, momenta_28, masses2_2, T0sum(33), M2)
  call TI_call_OL(0,0, momenta_33, masses2_2, T0sum(34), M2)
  call TI_call_OL(0,0, momenta_27, masses2_2, T0sum(35), M2)
  call TI_call_OL(0,0, momenta_21, masses2_2, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_19, masses2_2, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_20, masses2_2, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_1, masses2_1, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(51), M2)

  call TI_call_OL(0,1, momenta_52, masses2_4, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_53, masses2_4, T1sum(2), M2,sbarray_2, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppllj_ew_eexddxg_3_/**/REALKIND
