
module ol_vamp_6_ppllj_ew_llxaaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_6(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj_ew_llxaaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj_ew_llxaaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllj_ew_llxaaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllj_ew_llxaaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllj_ew_llxaaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllj_ew_llxaaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,27),G0H4(48),ngZl,m3h8x4(:,29),heltab2x32(:,:,1485))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1598),h0tab(:,1598),[26,1,4],[0,nMW,nMW],3,1,wf8(:,27))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(49),m3h8x4(:,30),heltab2x32(:,:,1486))
  call Hloop_A_Q(ntryL,G0H4(49),26,0,G1H4(167),n2h4(310))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1599),h0tab(:,1599),[26,1,4],[0,nMW,nMW],3,1,wf8(:,27))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(49),ngPln,m3h8x4(:,31),heltab2x32(:,:,1487))
  call Hloop_A_Q(ntryL,G0H4(49),26,0,G1H4(159),n2h4(311))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1600),h0tab(:,1600),[26,1,4],[0,nMW,nMW],3,1,wf8(:,27))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(49),m3h8x4(:,32),heltab2x32(:,:,1488))
  call Hloop_A_Q(ntryL,G0H4(49),26,0,G1H4(128),n2h4(312))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1601),h0tab(:,1601),[19,4,8],[nME,nME,nME],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,33),heltab2x32(:,:,1489))
  call Hloop_A_Q(ntryL,G0H4(49),19,nME,G1H4(133),n2h4(313))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1602),h0tab(:,1602),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,34),heltab2x32(:,:,1490))
  call Hloop_A_Q(ntryL,G0H4(49),19,nMM,G1H4(89),n2h4(314))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1603),h0tab(:,1603),[19,4,8],[nML,nML,nML],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,35),heltab2x32(:,:,1491))
  call Hloop_A_Q(ntryL,G0H4(49),19,nML,G1H4(87),n2h4(315))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1604),h0tab(:,1604),[19,4,8],[nME,nME,nME],3,1,wf8(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,36),heltab2x32(:,:,1492))
  call Hloop_Q_A(ntryL,G0H4(49),19,nME,G1H4(134),n2h4(316))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1605),h0tab(:,1605),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,37),heltab2x32(:,:,1493))
  call Hloop_Q_A(ntryL,G0H4(49),19,nMM,G1H4(139),n2h4(317))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1606),h0tab(:,1606),[19,4,8],[nML,nML,nML],3,1,wf8(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,38),heltab2x32(:,:,1494))
  call Hloop_Q_A(ntryL,G0H4(49),19,nML,G1H4(158),n2h4(318))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1607),h0tab(:,1607),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,39),heltab2x32(:,:,1495))
  call Hloop_A_Q(ntryL,G0H4(49),19,nMT,G1H4(146),n2h4(319))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1608),h0tab(:,1608),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,40),heltab2x32(:,:,1496))
  call Hloop_Q_A(ntryL,G0H4(49),19,nMT,G1H4(106),n2h4(320))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1609),h0tab(:,1609),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,41),heltab2x32(:,:,1497))
  call Hloop_A_Q(ntryL,G0H4(49),19,nMB,G1H4(145),n2h4(321))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1610),h0tab(:,1610),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,42),heltab2x32(:,:,1498))
  call Hloop_Q_A(ntryL,G0H4(49),19,nMB,G1H4(151),n2h4(322))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1611),h0tab(:,1611),[19,4,8],[nME,nME,nME],3,1,wf8(:,56))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,43),heltab2x32(:,:,1499))
  call Hloop_A_Q(ntryL,G0H4(49),19,nME,G1H4(9),n2h4(323))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1612),h0tab(:,1612),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,56))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,44),heltab2x32(:,:,1500))
  call Hloop_A_Q(ntryL,G0H4(49),19,nMM,G1H4(209),n2h4(324))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1613),h0tab(:,1613),[19,4,8],[nML,nML,nML],3,1,wf8(:,56))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,45),heltab2x32(:,:,1501))
  call Hloop_A_Q(ntryL,G0H4(49),19,nML,G1H4(152),n2h4(325))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1614),h0tab(:,1614),[19,4,8],[nME,nME,nME],3,1,wf8(:,56))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,46),heltab2x32(:,:,1502))
  call Hloop_Q_A(ntryL,G0H4(49),19,nME,G1H4(157),n2h4(326))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1615),h0tab(:,1615),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,56))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,47),heltab2x32(:,:,1503))
  call Hloop_Q_A(ntryL,G0H4(49),19,nMM,G1H4(163),n2h4(327))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1616),h0tab(:,1616),[19,4,8],[nML,nML,nML],3,1,wf8(:,56))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,48),heltab2x32(:,:,1504))
  call Hloop_Q_A(ntryL,G0H4(49),19,nML,G1H4(123),n2h4(328))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1617),h0tab(:,1617),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,56))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,49),heltab2x32(:,:,1505))
  call Hloop_A_Q(ntryL,G0H4(49),19,nMT,G1H4(113),n2h4(329))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1618),h0tab(:,1618),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,56))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,50),heltab2x32(:,:,1506))
  call Hloop_Q_A(ntryL,G0H4(49),19,nMT,G1H4(111),n2h4(330))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1619),h0tab(:,1619),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,56))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,51),heltab2x32(:,:,1507))
  call Hloop_A_Q(ntryL,G0H4(49),19,nMB,G1H4(164),n2h4(331))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1620),h0tab(:,1620),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,56))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,52),heltab2x32(:,:,1508))
  call Hloop_Q_A(ntryL,G0H4(49),19,nMB,G1H4(203),n2h4(332))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1621),h0tab(:,1621),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(49),m3h8x4(:,53),heltab2x32(:,:,1509))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1622),h0tab(:,1622),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(50),m3h8x4(:,54),heltab2x32(:,:,1510))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1623),h0tab(:,1623),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(51),m3h8x4(:,55),heltab2x32(:,:,1511))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1624),h0tab(:,1624),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(52),m3h8x4(:,56),heltab2x32(:,:,1512))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1625),h0tab(:,1625),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(53),m3h8x4(:,57),heltab2x32(:,:,1513))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1626),h0tab(:,1626),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(54),m3h8x4(:,58),heltab2x32(:,:,1514))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1627),h0tab(:,1627),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,56),G0H4(55),m3h8x4(:,59),heltab2x32(:,:,1515))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1628),h0tab(:,1628),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,56),G0H4(56),m3h8x4(:,60),heltab2x32(:,:,1516))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1629),h0tab(:,1629),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,56),G0H4(57),m3h8x4(:,61),heltab2x32(:,:,1517))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1630),h0tab(:,1630),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,56),G0H4(58),m3h8x4(:,62),heltab2x32(:,:,1518))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1631),h0tab(:,1631),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,18),G0H4(59),m3h8x4(:,63),heltab2x32(:,:,1519))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1632),h0tab(:,1632),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,18),G0H4(60),m3h8x4(:,64),heltab2x32(:,:,1520))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1633),h0tab(:,1633),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(201),m3h8x4(:,65),heltab2x32(:,:,1521))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1634),h0tab(:,1634),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(191),m3h8x4(:,66),heltab2x32(:,:,1522))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1635),h0tab(:,1635),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(189),m3h8x4(:,67),heltab2x32(:,:,1523))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1636),h0tab(:,1636),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(175),m3h8x4(:,68),heltab2x32(:,:,1524))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1637),h0tab(:,1637),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(35),m3h8x4(:,69),heltab2x32(:,:,1525))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1638),h0tab(:,1638),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(33),m3h8x4(:,70),heltab2x32(:,:,1526))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1639),h0tab(:,1639),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(219),m3h8x4(:,71),heltab2x32(:,:,1527))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1640),h0tab(:,1640),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(181),m3h8x4(:,72),heltab2x32(:,:,1528))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1641),h0tab(:,1641),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(61),m3h8x4(:,73),heltab2x32(:,:,1529))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1642),h0tab(:,1642),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(62),m3h8x4(:,74),heltab2x32(:,:,1530))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1643),h0tab(:,1643),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,18),G0H4(63),m3h8x4(:,75),heltab2x32(:,:,1531))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1644),h0tab(:,1644),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,18),G0H4(64),m3h8x4(:,76),heltab2x32(:,:,1532))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1645),h0tab(:,1645),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(200),m3h8x4(:,77),heltab2x32(:,:,1533))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1646),h0tab(:,1646),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(188),m3h8x4(:,78),heltab2x32(:,:,1534))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1647),h0tab(:,1647),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(182),m3h8x4(:,79),heltab2x32(:,:,1535))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1648),h0tab(:,1648),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(187),m3h8x4(:,80),heltab2x32(:,:,1536))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1649),h0tab(:,1649),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(193),m3h8x4(:,81),heltab2x32(:,:,1537))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1650),h0tab(:,1650),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(76),m3h8x4(:,82),heltab2x32(:,:,1538))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1651),h0tab(:,1651),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(72),m3h8x4(:,83),heltab2x32(:,:,1539))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1652),h0tab(:,1652),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(194),m3h8x4(:,84),heltab2x32(:,:,1540))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1653),h0tab(:,1653),[19,4,8],[nME,nME,nME],3,1,wf8(:,57))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,85),heltab2x32(:,:,1541))
  call Hloop_A_Q(ntryL,G0H4(65),19,nME,G1H4(199),n2h4(333))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1654),h0tab(:,1654),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,57))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,86),heltab2x32(:,:,1542))
  call Hloop_A_Q(ntryL,G0H4(65),19,nMM,G1H4(205),n2h4(334))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1655),h0tab(:,1655),[19,4,8],[nML,nML,nML],3,1,wf8(:,57))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,87),heltab2x32(:,:,1543))
  call Hloop_A_Q(ntryL,G0H4(65),19,nML,G1H4(154),n2h4(335))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1656),h0tab(:,1656),[19,4,8],[nME,nME,nME],3,1,wf8(:,57))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,88),heltab2x32(:,:,1544))
  call Hloop_Q_A(ntryL,G0H4(65),19,nME,G1H4(142),n2h4(336))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1657),h0tab(:,1657),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,57))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,89),heltab2x32(:,:,1545))
  call Hloop_Q_A(ntryL,G0H4(65),19,nMM,G1H4(138),n2h4(337))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1658),h0tab(:,1658),[19,4,8],[nML,nML,nML],3,1,wf8(:,57))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,90),heltab2x32(:,:,1546))
  call Hloop_Q_A(ntryL,G0H4(65),19,nML,G1H4(206),n2h4(338))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1659),h0tab(:,1659),[19,4,8],[0,0,0],3,1,wf8(:,57))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,91),heltab2x32(:,:,1547))
  call Hloop_A_Q(ntryL,G0H4(65),19,0,G1H4(211),n2h4(339))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1660),h0tab(:,1660),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,57))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,92),heltab2x32(:,:,1548))
  call Hloop_A_Q(ntryL,G0H4(65),19,nMT,G1H4(168),n2h4(340))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1661),h0tab(:,1661),[19,4,8],[0,0,0],3,1,wf8(:,57))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,93),heltab2x32(:,:,1549))
  call Hloop_Q_A(ntryL,G0H4(65),19,0,G1H4(160),n2h4(341))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1662),h0tab(:,1662),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,57))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,94),heltab2x32(:,:,1550))
  call Hloop_Q_A(ntryL,G0H4(65),19,nMT,G1H4(156),n2h4(342))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1663),h0tab(:,1663),[19,4,8],[0,0,0],3,1,wf8(:,57))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,95),heltab2x32(:,:,1551))
  call Hloop_A_Q(ntryL,G0H4(65),19,0,G1H4(212),n2h4(343))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1664),h0tab(:,1664),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,57))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,96),heltab2x32(:,:,1552))
  call Hloop_A_Q(ntryL,G0H4(65),19,nMB,G1H4(90),n2h4(344))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1665),h0tab(:,1665),[19,4,8],[0,0,0],3,1,wf8(:,57))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,97),heltab2x32(:,:,1553))
  call Hloop_Q_A(ntryL,G0H4(65),19,0,G1H4(88),n2h4(345))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1666),h0tab(:,1666),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,57))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,98),heltab2x32(:,:,1554))
  call Hloop_Q_A(ntryL,G0H4(65),19,nMB,G1H4(70),n2h4(346))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1667),h0tab(:,1667),[19,4,8],[nME,nME,nME],3,1,wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZl,m3h8x4(:,99),heltab2x32(:,:,1555))
  call Hloop_A_Q(ntryL,G0H4(65),19,nME,G1H4(218),n2h4(347))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1668),h0tab(:,1668),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZl,m3h8x4(:,100),heltab2x32(:,:,1556))
  call Hloop_A_Q(ntryL,G0H4(65),19,nMM,G1H4(63),n2h4(348))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1669),h0tab(:,1669),[19,4,8],[nML,nML,nML],3,1,wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZl,m3h8x4(:,101),heltab2x32(:,:,1557))
  call Hloop_A_Q(ntryL,G0H4(65),19,nML,G1H4(66),n2h4(349))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1670),h0tab(:,1670),[19,4,8],[nME,nME,nME],3,1,wf8(:,58))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZl,m3h8x4(:,102),heltab2x32(:,:,1558))
  call Hloop_Q_A(ntryL,G0H4(65),19,nME,G1H4(64),n2h4(350))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1671),h0tab(:,1671),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,58))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZl,m3h8x4(:,103),heltab2x32(:,:,1559))
  call Hloop_Q_A(ntryL,G0H4(65),19,nMM,G1H4(147),n2h4(351))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1672),h0tab(:,1672),[19,4,8],[nML,nML,nML],3,1,wf8(:,58))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZl,m3h8x4(:,104),heltab2x32(:,:,1560))
  call Hloop_Q_A(ntryL,G0H4(65),19,nML,G1H4(135),n2h4(352))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1673),h0tab(:,1673),[19,4,8],[0,0,0],3,1,wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZu,m3h8x4(:,105),heltab2x32(:,:,1561))
  call Hloop_A_Q(ntryL,G0H4(65),19,0,G1H4(131),n2h4(353))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1674),h0tab(:,1674),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZu,m3h8x4(:,106),heltab2x32(:,:,1562))
  call Hloop_A_Q(ntryL,G0H4(65),19,nMT,G1H4(148),n2h4(354))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1675),h0tab(:,1675),[19,4,8],[0,0,0],3,1,wf8(:,58))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZu,m3h8x4(:,107),heltab2x32(:,:,1563))
  call Hloop_Q_A(ntryL,G0H4(65),19,0,G1H4(144),n2h4(355))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1676),h0tab(:,1676),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,58))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZu,m3h8x4(:,108),heltab2x32(:,:,1564))
  call Hloop_Q_A(ntryL,G0H4(65),19,nMT,G1H4(132),n2h4(356))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1677),h0tab(:,1677),[19,4,8],[0,0,0],3,1,wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZd,m3h8x4(:,109),heltab2x32(:,:,1565))
  call Hloop_A_Q(ntryL,G0H4(65),19,0,G1H4(83),n2h4(357))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1678),h0tab(:,1678),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZd,m3h8x4(:,110),heltab2x32(:,:,1566))
  call Hloop_A_Q(ntryL,G0H4(65),19,nMB,G1H4(82),n2h4(358))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1679),h0tab(:,1679),[19,4,8],[0,0,0],3,1,wf8(:,58))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZd,m3h8x4(:,111),heltab2x32(:,:,1567))
  call Hloop_Q_A(ntryL,G0H4(65),19,0,G1H4(77),n2h4(359))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1680),h0tab(:,1680),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,58))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZd,m3h8x4(:,112),heltab2x32(:,:,1568))
  call Hloop_Q_A(ntryL,G0H4(65),19,nMB,G1H4(81),n2h4(360))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1681),h0tab(:,1681),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(78),m3h8x4(:,113),heltab2x32(:,:,1569))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1682),h0tab(:,1682),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(177),m3h8x4(:,114),heltab2x32(:,:,1570))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1683),h0tab(:,1683),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(173),m3h8x4(:,115),heltab2x32(:,:,1571))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1684),h0tab(:,1684),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(161),m3h8x4(:,116),heltab2x32(:,:,1572))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1685),h0tab(:,1685),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,57),G1H4(178),m3h8x4(:,117),heltab2x32(:,:,1573))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1686),h0tab(:,1686),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(174),m3h8x4(:,118),heltab2x32(:,:,1574))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1687),h0tab(:,1687),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,57),G1H4(166),m3h8x4(:,119),heltab2x32(:,:,1575))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1688),h0tab(:,1688),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(215),m3h8x4(:,120),heltab2x32(:,:,1576))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1689),h0tab(:,1689),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,58),G1H4(213),m3h8x4(:,121),heltab2x32(:,:,1577))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1690),h0tab(:,1690),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(216),m3h8x4(:,122),heltab2x32(:,:,1578))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1691),h0tab(:,1691),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,58),G1H4(214),m3h8x4(:,123),heltab2x32(:,:,1579))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1692),h0tab(:,1692),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(129),m3h8x4(:,124),heltab2x32(:,:,1580))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1693),h0tab(:,1693),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(119),m3h8x4(:,125),heltab2x32(:,:,1581))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1694),h0tab(:,1694),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(117),m3h8x4(:,126),heltab2x32(:,:,1582))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1695),h0tab(:,1695),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(180),m3h8x4(:,127),heltab2x32(:,:,1583))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1696),h0tab(:,1696),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(120),m3h8x4(:,128),heltab2x32(:,:,1584))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1697),h0tab(:,1697),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,129),heltab2x32(:,:,1585))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1698),h0tab(:,1698),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(66),m3h8x4(:,130),heltab2x32(:,:,1586))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1699),h0tab(:,1699),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,58),G0H4(67),m3h8x4(:,131),heltab2x32(:,:,1587))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1700),h0tab(:,1700),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,58),G0H4(68),m3h8x4(:,132),heltab2x32(:,:,1588))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1701),h0tab(:,1701),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(69),m3h8x4(:,133),heltab2x32(:,:,1589))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1702),h0tab(:,1702),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(70),m3h8x4(:,134),heltab2x32(:,:,1590))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1703),h0tab(:,1703),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,58),G0H4(71),m3h8x4(:,135),heltab2x32(:,:,1591))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1704),h0tab(:,1704),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,58),G0H4(72),m3h8x4(:,136),heltab2x32(:,:,1592))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1705),h0tab(:,1705),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(118),m3h8x4(:,137),heltab2x32(:,:,1593))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1706),h0tab(:,1706),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(29),m3h8x4(:,138),heltab2x32(:,:,1594))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1707),h0tab(:,1707),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(16),m3h8x4(:,139),heltab2x32(:,:,1595))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1708),h0tab(:,1708),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(30),m3h8x4(:,140),heltab2x32(:,:,1596))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1709),h0tab(:,1709),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(15),m3h8x4(:,141),heltab2x32(:,:,1597))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1710),h0tab(:,1710),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(12),m3h8x4(:,142),heltab2x32(:,:,1598))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1711),h0tab(:,1711),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(197),m3h8x4(:,143),heltab2x32(:,:,1599))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1712),h0tab(:,1712),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(185),m3h8x4(:,144),heltab2x32(:,:,1600))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1713),h0tab(:,1713),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(73),m3h8x4(:,145),heltab2x32(:,:,1601))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1714),h0tab(:,1714),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(74),m3h8x4(:,146),heltab2x32(:,:,1602))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1715),h0tab(:,1715),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,58),G0H4(75),m3h8x4(:,147),heltab2x32(:,:,1603))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1716),h0tab(:,1716),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,58),G0H4(76),m3h8x4(:,148),heltab2x32(:,:,1604))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1717),h0tab(:,1717),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(77),m3h8x4(:,149),heltab2x32(:,:,1605))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1718),h0tab(:,1718),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(78),m3h8x4(:,150),heltab2x32(:,:,1606))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1719),h0tab(:,1719),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,58),G0H4(79),m3h8x4(:,151),heltab2x32(:,:,1607))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1720),h0tab(:,1720),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,58),G0H4(80),m3h8x4(:,152),heltab2x32(:,:,1608))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1721),h0tab(:,1721),[21,2,8],[nMH,nML,nML],3,1,wf8(:,43))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,43),G0H4(81),ngH,m3h8x4(:,153),heltab2x32(:,:,1609))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1722),h0tab(:,1722),[21,2,8],[nMZ,nML,nML],3,1,wf8(:,43))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,43),G0H4(82),ngX,m3h8x4(:,154),heltab2x32(:,:,1610))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1723),h0tab(:,1723),[21,2,8],[0,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(83),ngPnl,m3h8x4(:,155),heltab2x32(:,:,1611))
  call Hloop_Q_A(ntryL,G0H4(83),21,0,G1H4(183),n2h4(361))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1724),h0tab(:,1724),[21,2,8],[0,nML,nML],3,1,wf8(:,43))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,43),G0H4(83),m3h8x4(:,156),heltab2x32(:,:,1612))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1725),h0tab(:,1725),[21,2,8],[nMZ,nML,nML],3,1,wf8(:,43))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,43),G0H4(84),ngZl,m3h8x4(:,157),heltab2x32(:,:,1613))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1726),h0tab(:,1726),[21,2,8],[0,nMW,nMW],3,1,wf8(:,43))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,158),heltab2x32(:,:,1614))
  call Hloop_Q_A(ntryL,G0H4(85),21,0,G1H4(198),n2h4(362))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1727),h0tab(:,1727),[21,2,8],[0,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),ngPnl,m3h8x4(:,159),heltab2x32(:,:,1615))
  call Hloop_Q_A(ntryL,G0H4(85),21,0,G1H4(196),n2h4(363))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1728),h0tab(:,1728),[21,2,8],[0,nMW,nMW],3,1,wf8(:,43))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,160),heltab2x32(:,:,1616))
  call Hloop_Q_A(ntryL,G0H4(85),21,0,G1H4(184),n2h4(364))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1729),h0tab(:,1729),[25,2,4],[nMH,nML,nML],3,1,wf8(:,37))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,37),G0H4(85),ngH,m3h8x4(:,161),heltab2x32(:,:,1617))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1730),h0tab(:,1730),[25,2,4],[nMZ,nML,nML],3,1,wf8(:,37))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,37),G0H4(86),ngX,m3h8x4(:,162),heltab2x32(:,:,1618))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1731),h0tab(:,1731),[25,2,4],[0,nMW,nMW],3,1,wf8(:,37))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(87),ngPnl,m3h8x4(:,163),heltab2x32(:,:,1619))
  call Hloop_Q_A(ntryL,G0H4(87),25,0,G1H4(1),n2h4(365))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1732),h0tab(:,1732),[25,2,4],[0,nML,nML],3,1,wf8(:,37))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,37),G0H4(87),m3h8x4(:,164),heltab2x32(:,:,1620))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1733),h0tab(:,1733),[25,2,4],[nMZ,nML,nML],3,1,wf8(:,37))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,37),G0H4(88),ngZl,m3h8x4(:,165),heltab2x32(:,:,1621))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1734),h0tab(:,1734),[25,2,4],[0,nMW,nMW],3,1,wf8(:,37))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(89),m3h8x4(:,166),heltab2x32(:,:,1622))
  call Hloop_Q_A(ntryL,G0H4(89),25,0,G1H4(2),n2h4(366))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1735),h0tab(:,1735),[25,2,4],[0,nMW,nMW],3,1,wf8(:,37))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(89),ngPnl,m3h8x4(:,167),heltab2x32(:,:,1623))
  call Hloop_Q_A(ntryL,G0H4(89),25,0,G1H4(3),n2h4(367))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1736),h0tab(:,1736),[25,2,4],[0,nMW,nMW],3,1,wf8(:,37))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(89),m3h8x4(:,168),heltab2x32(:,:,1624))
  call Hloop_Q_A(ntryL,G0H4(89),25,0,G1H4(7),n2h4(368))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1737),h0tab(:,1737),[19,4,8],[nME,nME,nME],3,1,wf8(:,19))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,169),heltab2x32(:,:,1625))
  call Hloop_A_Q(ntryL,G0H4(89),19,nME,G1H4(207),n2h4(369))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1738),h0tab(:,1738),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,19))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,170),heltab2x32(:,:,1626))
  call Hloop_A_Q(ntryL,G0H4(89),19,nMM,G1H4(13),n2h4(370))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1739),h0tab(:,1739),[19,4,8],[nML,nML,nML],3,1,wf8(:,19))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,171),heltab2x32(:,:,1627))
  call Hloop_A_Q(ntryL,G0H4(89),19,nML,G1H4(208),n2h4(371))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1740),h0tab(:,1740),[19,4,8],[nME,nME,nME],3,1,wf8(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,172),heltab2x32(:,:,1628))
  call Hloop_Q_A(ntryL,G0H4(89),19,nME,G1H4(40),n2h4(372))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1741),h0tab(:,1741),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,173),heltab2x32(:,:,1629))
  call Hloop_Q_A(ntryL,G0H4(89),19,nMM,G1H4(25),n2h4(373))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1742),h0tab(:,1742),[19,4,8],[nML,nML,nML],3,1,wf8(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,174),heltab2x32(:,:,1630))
  call Hloop_Q_A(ntryL,G0H4(89),19,nML,G1H4(41),n2h4(374))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1743),h0tab(:,1743),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,19))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,175),heltab2x32(:,:,1631))
  call Hloop_A_Q(ntryL,G0H4(89),19,nMT,G1H4(233),n2h4(375))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1744),h0tab(:,1744),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,176),heltab2x32(:,:,1632))
  call Hloop_Q_A(ntryL,G0H4(89),19,nMT,G1H4(235),n2h4(376))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1745),h0tab(:,1745),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,19))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,177),heltab2x32(:,:,1633))
  call Hloop_A_Q(ntryL,G0H4(89),19,nMB,G1H4(236),n2h4(377))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1746),h0tab(:,1746),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,178),heltab2x32(:,:,1634))
  call Hloop_Q_A(ntryL,G0H4(89),19,nMB,G1H4(238),n2h4(378))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1747),h0tab(:,1747),[19,4,8],[nME,nME,nME],3,1,wf8(:,59))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,179),heltab2x32(:,:,1635))
  call Hloop_A_Q(ntryL,G0H4(89),19,nME,G1H4(243),n2h4(379))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1748),h0tab(:,1748),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,59))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,180),heltab2x32(:,:,1636))
  call Hloop_A_Q(ntryL,G0H4(89),19,nMM,G1H4(73),n2h4(380))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1749),h0tab(:,1749),[19,4,8],[nML,nML,nML],3,1,wf8(:,59))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,181),heltab2x32(:,:,1637))
  call Hloop_A_Q(ntryL,G0H4(89),19,nML,G1H4(53),n2h4(381))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1750),h0tab(:,1750),[19,4,8],[nME,nME,nME],3,1,wf8(:,59))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,182),heltab2x32(:,:,1638))
  call Hloop_Q_A(ntryL,G0H4(89),19,nME,G1H4(79),n2h4(382))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1751),h0tab(:,1751),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,59))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,183),heltab2x32(:,:,1639))
  call Hloop_Q_A(ntryL,G0H4(89),19,nMM,G1H4(54),n2h4(383))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1752),h0tab(:,1752),[19,4,8],[nML,nML,nML],3,1,wf8(:,59))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,184),heltab2x32(:,:,1640))
  call Hloop_Q_A(ntryL,G0H4(89),19,nML,G1H4(58),n2h4(384))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1753),h0tab(:,1753),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,59))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,185),heltab2x32(:,:,1641))
  call Hloop_A_Q(ntryL,G0H4(89),19,nMT,G1H4(91),n2h4(385))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1754),h0tab(:,1754),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,59))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,186),heltab2x32(:,:,1642))
  call Hloop_Q_A(ntryL,G0H4(89),19,nMT,G1H4(93),n2h4(386))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1755),h0tab(:,1755),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,59))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,187),heltab2x32(:,:,1643))
  call Hloop_A_Q(ntryL,G0H4(89),19,nMB,G1H4(245),n2h4(387))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1756),h0tab(:,1756),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,59))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,188),heltab2x32(:,:,1644))
  call Hloop_Q_A(ntryL,G0H4(89),19,nMB,G1H4(247),n2h4(388))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1757),h0tab(:,1757),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(89),m3h8x4(:,189),heltab2x32(:,:,1645))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1758),h0tab(:,1758),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(90),m3h8x4(:,190),heltab2x32(:,:,1646))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1759),h0tab(:,1759),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(91),m3h8x4(:,191),heltab2x32(:,:,1647))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1760),h0tab(:,1760),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(92),m3h8x4(:,192),heltab2x32(:,:,1648))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1761),h0tab(:,1761),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(93),m3h8x4(:,193),heltab2x32(:,:,1649))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1762),h0tab(:,1762),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(94),m3h8x4(:,194),heltab2x32(:,:,1650))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1763),h0tab(:,1763),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,59),G0H4(95),m3h8x4(:,195),heltab2x32(:,:,1651))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1764),h0tab(:,1764),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,59),G0H4(96),m3h8x4(:,196),heltab2x32(:,:,1652))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1765),h0tab(:,1765),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,59),G0H4(97),m3h8x4(:,197),heltab2x32(:,:,1653))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1766),h0tab(:,1766),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,59),G0H4(98),m3h8x4(:,198),heltab2x32(:,:,1654))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1767),h0tab(:,1767),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,19),G0H4(99),m3h8x4(:,199),heltab2x32(:,:,1655))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1768),h0tab(:,1768),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,19),G0H4(100),m3h8x4(:,200),heltab2x32(:,:,1656))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1769),h0tab(:,1769),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(248),m3h8x4(:,201),heltab2x32(:,:,1657))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1770),h0tab(:,1770),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(250),m3h8x4(:,202),heltab2x32(:,:,1658))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1771),h0tab(:,1771),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(255),m3h8x4(:,203),heltab2x32(:,:,1659))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1772),h0tab(:,1772),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(105),m3h8x4(:,204),heltab2x32(:,:,1660))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1773),h0tab(:,1773),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(39),m3h8x4(:,205),heltab2x32(:,:,1661))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1774),h0tab(:,1774),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(107),m3h8x4(:,206),heltab2x32(:,:,1662))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1775),h0tab(:,1775),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(108),m3h8x4(:,207),heltab2x32(:,:,1663))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1776),h0tab(:,1776),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(99),m3h8x4(:,208),heltab2x32(:,:,1664))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1777),h0tab(:,1777),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(101),m3h8x4(:,209),heltab2x32(:,:,1665))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1778),h0tab(:,1778),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(102),m3h8x4(:,210),heltab2x32(:,:,1666))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1779),h0tab(:,1779),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,19),G0H4(103),m3h8x4(:,211),heltab2x32(:,:,1667))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1780),h0tab(:,1780),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,19),G0H4(104),m3h8x4(:,212),heltab2x32(:,:,1668))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1781),h0tab(:,1781),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(102),m3h8x4(:,213),heltab2x32(:,:,1669))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1782),h0tab(:,1782),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(221),m3h8x4(:,214),heltab2x32(:,:,1670))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1783),h0tab(:,1783),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(225),m3h8x4(:,215),heltab2x32(:,:,1671))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1784),h0tab(:,1784),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(224),m3h8x4(:,216),heltab2x32(:,:,1672))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1785),h0tab(:,1785),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(226),m3h8x4(:,217),heltab2x32(:,:,1673))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1786),h0tab(:,1786),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(231),m3h8x4(:,218),heltab2x32(:,:,1674))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1787),h0tab(:,1787),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(232),m3h8x4(:,219),heltab2x32(:,:,1675))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1788),h0tab(:,1788),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(18),m3h8x4(:,220),heltab2x32(:,:,1676))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1789),h0tab(:,1789),[19,4,8],[nME,nME,nME],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,221),heltab2x32(:,:,1677))
  call Hloop_A_Q(ntryL,G0H4(105),19,nME,G1H4(21),n2h4(389))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1790),h0tab(:,1790),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,222),heltab2x32(:,:,1678))
  call Hloop_A_Q(ntryL,G0H4(105),19,nMM,G1H4(22),n2h4(390))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1791),h0tab(:,1791),[19,4,8],[nML,nML,nML],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,223),heltab2x32(:,:,1679))
  call Hloop_A_Q(ntryL,G0H4(105),19,nML,G1H4(23),n2h4(391))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1792),h0tab(:,1792),[19,4,8],[nME,nME,nME],3,1,wf8(:,60))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,224),heltab2x32(:,:,1680))
  call Hloop_Q_A(ntryL,G0H4(105),19,nME,G1H4(27),n2h4(392))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1793),h0tab(:,1793),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,60))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,225),heltab2x32(:,:,1681))
  call Hloop_Q_A(ntryL,G0H4(105),19,nMM,G1H4(28),n2h4(393))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1794),h0tab(:,1794),[19,4,8],[nML,nML,nML],3,1,wf8(:,60))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,226),heltab2x32(:,:,1682))
  call Hloop_Q_A(ntryL,G0H4(105),19,nML,G1H4(96),n2h4(394))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1795),h0tab(:,1795),[19,4,8],[0,0,0],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,227),heltab2x32(:,:,1683))
  call Hloop_A_Q(ntryL,G0H4(105),19,0,G1H4(227),n2h4(395))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1796),h0tab(:,1796),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,228),heltab2x32(:,:,1684))
  call Hloop_A_Q(ntryL,G0H4(105),19,nMT,G1H4(228),n2h4(396))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1797),h0tab(:,1797),[19,4,8],[0,0,0],3,1,wf8(:,60))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,229),heltab2x32(:,:,1685))
  call Hloop_Q_A(ntryL,G0H4(105),19,0,G1H4(229),n2h4(397))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1798),h0tab(:,1798),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,60))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,230),heltab2x32(:,:,1686))
  call Hloop_Q_A(ntryL,G0H4(105),19,nMT,G1H4(230),n2h4(398))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1799),h0tab(:,1799),[19,4,8],[0,0,0],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,231),heltab2x32(:,:,1687))
  call Hloop_A_Q(ntryL,G0H4(105),19,0,G1H4(239),n2h4(399))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1800),h0tab(:,1800),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,232),heltab2x32(:,:,1688))
  call Hloop_A_Q(ntryL,G0H4(105),19,nMB,G1H4(240),n2h4(400))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1801),h0tab(:,1801),[19,4,8],[0,0,0],3,1,wf8(:,60))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,233),heltab2x32(:,:,1689))
  call Hloop_Q_A(ntryL,G0H4(105),19,0,G1H4(241),n2h4(401))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1802),h0tab(:,1802),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,60))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,234),heltab2x32(:,:,1690))
  call Hloop_Q_A(ntryL,G0H4(105),19,nMB,G1H4(242),n2h4(402))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1803),h0tab(:,1803),[19,4,8],[nME,nME,nME],3,1,wf8(:,61))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZl,m3h8x4(:,235),heltab2x32(:,:,1691))
  call Hloop_A_Q(ntryL,G0H4(105),19,nME,G1H4(251),n2h4(403))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1804),h0tab(:,1804),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,61))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZl,m3h8x4(:,236),heltab2x32(:,:,1692))
  call Hloop_A_Q(ntryL,G0H4(105),19,nMM,G1H4(252),n2h4(404))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1805),h0tab(:,1805),[19,4,8],[nML,nML,nML],3,1,wf8(:,61))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZl,m3h8x4(:,237),heltab2x32(:,:,1693))
  call Hloop_A_Q(ntryL,G0H4(105),19,nML,G1H4(253),n2h4(405))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1806),h0tab(:,1806),[19,4,8],[nME,nME,nME],3,1,wf8(:,61))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZl,m3h8x4(:,238),heltab2x32(:,:,1694))
  call Hloop_Q_A(ntryL,G0H4(105),19,nME,G1H4(254),n2h4(406))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1807),h0tab(:,1807),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,61))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZl,m3h8x4(:,239),heltab2x32(:,:,1695))
  call Hloop_Q_A(ntryL,G0H4(105),19,nMM,G1H4(42),n2h4(407))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1808),h0tab(:,1808),[19,4,8],[nML,nML,nML],3,1,wf8(:,61))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZl,m3h8x4(:,240),heltab2x32(:,:,1696))
  call Hloop_Q_A(ntryL,G0H4(105),19,nML,G1H4(94),n2h4(408))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1809),h0tab(:,1809),[19,4,8],[0,0,0],3,1,wf8(:,61))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZu,m3h8x4(:,241),heltab2x32(:,:,1697))
  call Hloop_A_Q(ntryL,G0H4(105),19,0,G1H4(100),n2h4(409))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1810),h0tab(:,1810),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,61))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZu,m3h8x4(:,242),heltab2x32(:,:,1698))
  call Hloop_A_Q(ntryL,G0H4(105),19,nMT,G1H4(95),n2h4(410))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1811),h0tab(:,1811),[19,4,8],[0,0,0],3,1,wf8(:,61))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZu,m3h8x4(:,243),heltab2x32(:,:,1699))
  call Hloop_Q_A(ntryL,G0H4(105),19,0,G1H4(20),n2h4(411))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1812),h0tab(:,1812),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,61))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZu,m3h8x4(:,244),heltab2x32(:,:,1700))
  call Hloop_Q_A(ntryL,G0H4(105),19,nMT,G1H4(26),n2h4(412))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1813),h0tab(:,1813),[19,4,8],[0,0,0],3,1,wf8(:,61))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZd,m3h8x4(:,245),heltab2x32(:,:,1701))
  call Hloop_A_Q(ntryL,G0H4(105),19,0,G1H4(50),n2h4(413))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1814),h0tab(:,1814),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,61))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZd,m3h8x4(:,246),heltab2x32(:,:,1702))
  call Hloop_A_Q(ntryL,G0H4(105),19,nMB,G1H4(234),n2h4(414))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1815),h0tab(:,1815),[19,4,8],[0,0,0],3,1,wf8(:,61))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZd,m3h8x4(:,247),heltab2x32(:,:,1703))
  call Hloop_Q_A(ntryL,G0H4(105),19,0,G1H4(43),n2h4(415))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1816),h0tab(:,1816),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,61))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZd,m3h8x4(:,248),heltab2x32(:,:,1704))
  call Hloop_Q_A(ntryL,G0H4(105),19,nMB,G1H4(10),n2h4(416))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1817),h0tab(:,1817),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(49),m3h8x4(:,249),heltab2x32(:,:,1705))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1818),h0tab(:,1818),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(55),m3h8x4(:,250),heltab2x32(:,:,1706))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1819),h0tab(:,1819),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(126),m3h8x4(:,251),heltab2x32(:,:,1707))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1820),h0tab(:,1820),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(56),m3h8x4(:,252),heltab2x32(:,:,1708))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1821),h0tab(:,1821),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,60),G1H4(61),m3h8x4(:,253),heltab2x32(:,:,1709))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1822),h0tab(:,1822),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(204),m3h8x4(:,254),heltab2x32(:,:,1710))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1823),h0tab(:,1823),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,60),G1H4(62),m3h8x4(:,255),heltab2x32(:,:,1711))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1824),h0tab(:,1824),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(67),m3h8x4(:,256),heltab2x32(:,:,1712))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1825),h0tab(:,1825),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,61),G1H4(34),m3h8x4(:,257),heltab2x32(:,:,1713))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1826),h0tab(:,1826),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(74),m3h8x4(:,258),heltab2x32(:,:,1714))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1827),h0tab(:,1827),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,61),G1H4(86),m3h8x4(:,259),heltab2x32(:,:,1715))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1828),h0tab(:,1828),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(92),m3h8x4(:,260),heltab2x32(:,:,1716))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1829),h0tab(:,1829),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(98),m3h8x4(:,261),heltab2x32(:,:,1717))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1830),h0tab(:,1830),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(258),m3h8x4(:,262),heltab2x32(:,:,1718))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1831),h0tab(:,1831),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(259),m3h8x4(:,263),heltab2x32(:,:,1719))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1832),h0tab(:,1832),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(260),m3h8x4(:,264),heltab2x32(:,:,1720))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1833),h0tab(:,1833),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,265),heltab2x32(:,:,1721))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1834),h0tab(:,1834),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,60),G0H4(106),m3h8x4(:,266),heltab2x32(:,:,1722))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1835),h0tab(:,1835),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,61),G0H4(107),m3h8x4(:,267),heltab2x32(:,:,1723))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1836),h0tab(:,1836),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,61),G0H4(108),m3h8x4(:,268),heltab2x32(:,:,1724))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1837),h0tab(:,1837),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,60),G0H4(109),m3h8x4(:,269),heltab2x32(:,:,1725))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1838),h0tab(:,1838),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,60),G0H4(110),m3h8x4(:,270),heltab2x32(:,:,1726))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1839),h0tab(:,1839),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,61),G0H4(111),m3h8x4(:,271),heltab2x32(:,:,1727))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1840),h0tab(:,1840),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,61),G0H4(112),m3h8x4(:,272),heltab2x32(:,:,1728))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1841),h0tab(:,1841),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(261),m3h8x4(:,273),heltab2x32(:,:,1729))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1842),h0tab(:,1842),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(262),m3h8x4(:,274),heltab2x32(:,:,1730))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1843),h0tab(:,1843),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(263),m3h8x4(:,275),heltab2x32(:,:,1731))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1844),h0tab(:,1844),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(264),m3h8x4(:,276),heltab2x32(:,:,1732))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1845),h0tab(:,1845),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(265),m3h8x4(:,277),heltab2x32(:,:,1733))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1846),h0tab(:,1846),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(266),m3h8x4(:,278),heltab2x32(:,:,1734))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1847),h0tab(:,1847),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(267),m3h8x4(:,279),heltab2x32(:,:,1735))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1848),h0tab(:,1848),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(268),m3h8x4(:,280),heltab2x32(:,:,1736))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1849),h0tab(:,1849),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,60),G0H4(113),m3h8x4(:,281),heltab2x32(:,:,1737))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1850),h0tab(:,1850),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,60),G0H4(114),m3h8x4(:,282),heltab2x32(:,:,1738))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1851),h0tab(:,1851),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,61),G0H4(115),m3h8x4(:,283),heltab2x32(:,:,1739))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1852),h0tab(:,1852),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,61),G0H4(116),m3h8x4(:,284),heltab2x32(:,:,1740))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1853),h0tab(:,1853),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,60),G0H4(117),m3h8x4(:,285),heltab2x32(:,:,1741))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1854),h0tab(:,1854),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,60),G0H4(118),m3h8x4(:,286),heltab2x32(:,:,1742))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1855),h0tab(:,1855),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,61),G0H4(119),m3h8x4(:,287),heltab2x32(:,:,1743))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1856),h0tab(:,1856),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,61),G0H4(120),m3h8x4(:,288),heltab2x32(:,:,1744))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1857),h0tab(:,1857),[22,1,8],[nMH,nML,nML],3,1,wf8(:,39))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,39),G0H4(121),ngH,m3h8x4(:,289),heltab2x32(:,:,1745))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1858),h0tab(:,1858),[22,1,8],[nMZ,nML,nML],3,1,wf8(:,39))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,39),G0H4(122),ngX,m3h8x4(:,290),heltab2x32(:,:,1746))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1859),h0tab(:,1859),[22,1,8],[0,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(123),ngPln,m3h8x4(:,291),heltab2x32(:,:,1747))
  call Hloop_A_Q(ntryL,G0H4(123),22,0,G1H4(269),n2h4(417))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1860),h0tab(:,1860),[22,1,8],[0,nML,nML],3,1,wf8(:,39))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,39),G0H4(123),m3h8x4(:,292),heltab2x32(:,:,1748))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1861),h0tab(:,1861),[22,1,8],[nMZ,nML,nML],3,1,wf8(:,39))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,39),G0H4(124),ngZl,m3h8x4(:,293),heltab2x32(:,:,1749))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1862),h0tab(:,1862),[22,1,8],[0,nMW,nMW],3,1,wf8(:,39))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(125),m3h8x4(:,294),heltab2x32(:,:,1750))
  call Hloop_A_Q(ntryL,G0H4(125),22,0,G1H4(270),n2h4(418))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1863),h0tab(:,1863),[22,1,8],[0,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(125),ngPln,m3h8x4(:,295),heltab2x32(:,:,1751))
  call Hloop_A_Q(ntryL,G0H4(125),22,0,G1H4(271),n2h4(419))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1864),h0tab(:,1864),[22,1,8],[0,nMW,nMW],3,1,wf8(:,39))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(125),m3h8x4(:,296),heltab2x32(:,:,1752))
  call Hloop_A_Q(ntryL,G0H4(125),22,0,G1H4(272),n2h4(420))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1865),h0tab(:,1865),[26,1,4],[nMH,nML,nML],3,1,wf8(:,30))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,30),G0H4(125),ngH,m3h8x4(:,297),heltab2x32(:,:,1753))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1866),h0tab(:,1866),[26,1,4],[nMZ,nML,nML],3,1,wf8(:,30))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,30),G0H4(126),ngX,m3h8x4(:,298),heltab2x32(:,:,1754))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1867),h0tab(:,1867),[26,1,4],[0,nMW,nMW],3,1,wf8(:,30))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,30),G0H4(127),ngPln,m3h8x4(:,299),heltab2x32(:,:,1755))
  call Hloop_A_Q(ntryL,G0H4(127),26,0,G1H4(273),n2h4(421))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1868),h0tab(:,1868),[26,1,4],[0,nML,nML],3,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,30),G0H4(127),m3h8x4(:,300),heltab2x32(:,:,1756))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1869),h0tab(:,1869),[26,1,4],[nMZ,nML,nML],3,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,30),G0H4(128),ngZl,m3h8x4(:,301),heltab2x32(:,:,1757))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1870),h0tab(:,1870),[26,1,4],[0,nMW,nMW],3,1,wf8(:,30))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,30),G0H4(129),m3h8x4(:,302),heltab2x32(:,:,1758))
  call Hloop_A_Q(ntryL,G0H4(129),26,0,G1H4(274),n2h4(422))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1871),h0tab(:,1871),[26,1,4],[0,nMW,nMW],3,1,wf8(:,30))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,30),G0H4(129),ngPln,m3h8x4(:,303),heltab2x32(:,:,1759))
  call Hloop_A_Q(ntryL,G0H4(129),26,0,G1H4(275),n2h4(423))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1872),h0tab(:,1872),[26,1,4],[0,nMW,nMW],3,1,wf8(:,30))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,30),G0H4(129),m3h8x4(:,304),heltab2x32(:,:,1760))
  call Hloop_A_Q(ntryL,G0H4(129),26,0,G1H4(276),n2h4(424))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(96),G1H4(58),G1H4(41),G1H4(135),G1H4(206) &
    ,G1H4(123),G1H4(158),G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(55),G1H4(161),G1H4(177),G1H4(114),G0H4(90) &
    ,G0H4(50),G0H4(29),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(250),G1H4(175),G1H4(191),G1H4(202),G0H4(108) &
    ,G0H4(106),G0H4(68),G0H4(66),G0H4(25),G0H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(231),G1H4(194),G1H4(76),G1H4(36),G0H4(120) &
    ,G0H4(118),G0H4(80),G0H4(78),G0H4(7),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(260),[G1H4(258),G1H4(120),G1H4(117),G1H4(80),G0H4(100) &
    ,G0H4(60),G0H4(37),G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(253),[G1H4(23),G1H4(53),G1H4(208),G1H4(66),G1H4(154) &
    ,G1H4(152),G1H4(87),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(49),G1H4(173),G1H4(78),G1H4(140),G0H4(89) &
    ,G0H4(49),G0H4(31),G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(255),[G1H4(248),G1H4(189),G1H4(201),G1H4(5),G0H4(107) &
    ,G0H4(105),G0H4(67),G0H4(65),G0H4(33),G0H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(232),[G1H4(226),G1H4(72),G1H4(193),G1H4(125),G0H4(119) &
    ,G0H4(117),G0H4(79),G0H4(77),G0H4(1),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(259),[G1H4(98),G1H4(180),G1H4(119),G1H4(169),G0H4(99) &
    ,G0H4(59),G0H4(39),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(251),[G1H4(21),G1H4(243),G1H4(207),G1H4(218),G1H4(199) &
    ,G1H4(9),G1H4(133),G1H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(252),[G1H4(22),G1H4(73),G1H4(13),G1H4(63),G1H4(205) &
    ,G1H4(209),G1H4(89),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(254),[G1H4(27),G1H4(79),G1H4(40),G1H4(64),G1H4(142) &
    ,G1H4(157),G1H4(134),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(28),G1H4(54),G1H4(25),G1H4(147),G1H4(138) &
    ,G1H4(163),G1H4(139),G1H4(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(228),G1H4(91),G1H4(233),G1H4(148),G1H4(168) &
    ,G1H4(113),G1H4(146),G1H4(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(230),G1H4(93),G1H4(235),G1H4(132),G1H4(156) &
    ,G1H4(111),G1H4(106),G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(234),[G1H4(240),G1H4(245),G1H4(236),G1H4(82),G1H4(90) &
    ,G1H4(164),G1H4(145),G1H4(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(242),G1H4(247),G1H4(238),G1H4(81),G1H4(70) &
    ,G1H4(203),G1H4(151),G1H4(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(34),G1H4(62),G1H4(61),G1H4(214),G1H4(213) &
    ,G1H4(166),G1H4(178),G1H4(46),G0H4(97),G0H4(95),G0H4(93),G0H4(91),G0H4(57),G0H4(55),G0H4(53),G0H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(74),G1H4(67),G1H4(204),G1H4(129),G1H4(216) &
    ,G1H4(215),G1H4(174),G1H4(223),G0H4(98),G0H4(96),G0H4(94),G0H4(92),G0H4(58),G0H4(56),G0H4(54),G0H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(100),G1H4(239),G1H4(227),G1H4(83),G1H4(131) &
    ,G1H4(212),G1H4(211),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(20),G1H4(241),G1H4(229),G1H4(77),G1H4(144) &
    ,G1H4(88),G1H4(160),G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(149),[G0H8(13),G0H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(154),[G0H8(6),G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(58),[G0H8(37),G0H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G0H8(39),G0H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(289),[G0H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(294),[G0H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(299),[G0H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(304),[G0H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(329),[G0H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(334),[G0H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(339),[G0H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(344),[G0H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(77),[G0H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G0H8(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(87),[G0H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G0H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(39),G1H4(219),G1H4(35),G0H4(111),G0H4(109) &
    ,G0H4(71),G0H4(69),G0H4(32),G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(99),[G1H4(107),G1H4(181),G1H4(33),G0H4(112),G0H4(110) &
    ,G0H4(72),G0H4(70),G0H4(30),G0H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(225),[G1H4(102),G1H4(182),G1H4(200),G0H4(115),G0H4(113) &
    ,G0H4(75),G0H4(73),G0H4(40),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(224),[G1H4(221),G1H4(187),G1H4(188),G0H4(116),G0H4(114) &
    ,G0H4(76),G0H4(74),G0H4(38),G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(264),[G1H4(263),G1H4(262),G1H4(261),G1H4(30),G1H4(16) &
    ,G1H4(29),G1H4(118),G0H4(102),G0H4(101),G0H4(62),G0H4(61),G0H4(8),G0H4(2),G0H4(10),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(268),[G1H4(267),G1H4(266),G1H4(265),G1H4(185),G1H4(197) &
    ,G1H4(12),G1H4(15),G0H4(104),G0H4(103),G0H4(64),G0H4(63),G0H4(4),G0H4(3),G0H4(18),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(51),[G1H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(65),[G1H16(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(71),[G0H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(75),[G0H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(99),[G0H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(103),[G0H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(21),[G0H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(23),[G0H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(25),[G0H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(27),[G0H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(12),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(10),[G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(3),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(5),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(171),[G1H16(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(185),[G1H16(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(210),[G1H16(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(214),[G1H16(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(2),[G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(4),[G0H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(26),[G0H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(28),[G0H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(50),[G0H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(52),[G0H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(54),[G0H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(56),[G0H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(330),[G1H16(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(334),[G1H16(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(30),[G0H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(32),[G0H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(36),[G0H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(40),[G0H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(42),[G0H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(44),[G0H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(46),[G0H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(48),[G0H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(44),[G1H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(45),[G1H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(48),[G1H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(54),[G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(56),[G1H16(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(64),[G0H16(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(66),[G0H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(58),[G1H16(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(73),[G1H16(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(75),[G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(101),[G1H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(102),[G1H16(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(105),[G1H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(106),[G1H16(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(112),[G1H16(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(114),[G1H16(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(116),[G1H16(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(118),[G1H16(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(81),[G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(82),[G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(83),[G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(84),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(198),[G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(196),[G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(184),[G1H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(159),[G1H16(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(160),[G1H16(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(164),[G1H16(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(165),[G1H16(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(169),[G1H16(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(172),[G1H16(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(168),[G0H16(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(170),[G0H16(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(174),[G1H16(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(176),[G1H16(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(188),[G1H16(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(191),[G1H16(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(217),[G1H16(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(218),[G1H16(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(221),[G1H16(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(222),[G1H16(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(228),[G1H16(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(230),[G1H16(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(232),[G1H16(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(234),[G1H16(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(121),[G0H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(122),[G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(269),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(123),[G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(124),[G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(270),[G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(271),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(272),[G1H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(265),[G1H16(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(266),[G1H16(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(273),[G1H16(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(274),[G1H16(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(278),[G1H16(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(280),[G1H16(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(96),[G0H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(100),[G0H16(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(282),[G1H16(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(284),[G1H16(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(297),[G1H16(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(299),[G1H16(295)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(323),[G1H16(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(324),[G1H16(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(327),[G1H16(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(328),[G1H16(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(338),[G1H16(337)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(340),[G1H16(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(342),[G1H16(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(344),[G1H16(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(85),[G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(86),[G0H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(87),[G0H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(88),[G0H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(375),[G1H16(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(376),[G1H16(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(379),[G1H16(377)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(380),[G1H16(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(384),[G1H16(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(386),[G1H16(385)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(86),[G0H16(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(88),[G0H16(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(388),[G1H16(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(390),[G1H16(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(401),[G1H16(397)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(403),[G1H16(399)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(425),[G1H16(423)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(426),[G1H16(424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(429),[G1H16(427)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(430),[G1H16(428)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(436),[G1H16(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(438),[G1H16(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(440),[G1H16(439)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(442),[G1H16(441)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(125),[G0H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(126),[G0H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(273),[G1H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(127),[G0H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(128),[G0H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(274),[G1H4(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(275),[G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(276),[G1H4(128)])
  call Hloop_SQ_A(ntryL,G1H4(45),ex1(:),G1H2(275),ngPnl,m3h2x2(:,513),heltab2x4(:,:,545))
  call Hloop_Q_A(ntryL,G1H2(275),29,0,G2H2(542),n2h2(401))
  call Hloop_WQ_A(ntryL,G1H4(101),ex1(:),G1H2(184),m3h2x2(:,514),heltab2x4(:,:,546))
  call Hloop_Q_A(ntryL,G1H2(184),29,0,G2H2(132),n2h2(402))
  call Hloop_SA_Q(ntryL,G1H4(31),ex2(:),G1H2(210),ngPln,m3h2x2(:,515),heltab2x4(:,:,547))
  call Hloop_A_Q(ntryL,G1H2(210),30,0,G2H2(128),n2h2(403))
  call Hloop_WA_Q(ntryL,G1H4(37),ex2(:),G1H2(281),m3h2x2(:,516),heltab2x4(:,:,548))
  call Hloop_A_Q(ntryL,G1H2(281),30,0,G2H2(106),n2h2(404))
  call Hloop_QV_A(ntryL,G1H4(94),ex3(:),G1H2(307),m3h2x2(:,517),heltab2x4(:,:,549))
  call Hloop_Q_A(ntryL,G1H2(307),23,nML,G2H2(25),n2h2(405))
  call Hloop_TV_S(ntryL,G1H4(56),19,ex3(:),4,G2H2(449),m3h2x2(:,518),heltab2x4(:,:,550))
  call Hloop_TV_S(ntryL,G1H4(105),19,ex3(:),4,G2H2(169),m3h2x2(:,519),heltab2x4(:,:,551))
  call Hloop_UV_W(ntryL,G1H4(18),19,ex3(:),4,G2H2(166),m3h2x2(:,520),heltab2x4(:,:,552))
  call Hloop_UV_W(ntryL,G1H4(260),19,ex3(:),4,G2H2(163),m3h2x2(:,521),heltab2x4(:,:,553))
  call Hloop_QV_A(ntryL,G1H4(104),ex4(:),G1H2(20),m3h2x2(:,522),heltab2x4(:,:,554))
  call Hloop_Q_A(ntryL,G1H2(20),27,nML,G2H2(162),n2h2(406))
  call Hloop_TV_S(ntryL,G1H4(75),19,ex4(:),8,G2H2(150),m3h2x2(:,523),heltab2x4(:,:,555))
  call Hloop_TV_S(ntryL,G1H4(121),19,ex4(:),8,G2H2(146),m3h2x2(:,524),heltab2x4(:,:,556))
  call Hloop_UV_W(ntryL,G1H4(122),19,ex4(:),8,G2H2(35),m3h2x2(:,525),heltab2x4(:,:,557))
  call Hloop_UV_W(ntryL,G1H4(155),19,ex4(:),8,G2H2(27),m3h2x2(:,526),heltab2x4(:,:,558))
  call Hloop_AV_Q(ntryL,G1H4(253),ex3(:),G1H2(38),m3h2x2(:,527),heltab2x4(:,:,559))
  call Hloop_A_Q(ntryL,G1H2(38),23,nML,G2H2(455),n2h2(407))
  call Hloop_SV_T(ntryL,G1H4(126),19,ex3(:),4,G2H2(176),m3h2x2(:,528),heltab2x4(:,:,560))
  call Hloop_SV_T(ntryL,G1H4(255),19,ex3(:),4,G2H2(172),m3h2x2(:,529),heltab2x4(:,:,561))
  call Hloop_UW_V(ntryL,G1H4(232),19,ex3(:),4,G2H2(158),m3h2x2(:,530),heltab2x4(:,:,562))
  call Hloop_UW_V(ntryL,G1H4(259),19,ex3(:),4,G2H2(155),m3h2x2(:,531),heltab2x4(:,:,563))
  call Hloop_AV_Q(ntryL,G1H4(170),ex4(:),G1H2(9),m3h2x2(:,532),heltab2x4(:,:,564))
  call Hloop_A_Q(ntryL,G1H2(9),27,nML,G2H2(154),n2h2(408))
  call Hloop_SV_T(ntryL,G1H4(176),19,ex4(:),8,G2H2(151),m3h2x2(:,533),heltab2x4(:,:,565))
  call Hloop_SV_T(ntryL,G1H4(222),19,ex4(:),8,G2H2(37),m3h2x2(:,534),heltab2x4(:,:,566))
  call Hloop_UW_V(ntryL,G1H4(60),19,ex4(:),8,G2H2(29),m3h2x2(:,535),heltab2x4(:,:,567))
  call Hloop_UW_V(ntryL,G1H4(150),19,ex4(:),8,G2H2(566),m3h2x2(:,536),heltab2x4(:,:,568))
  call Hloop_QV_A(ntryL,G1H4(172),ex4(:),G1H2(10),m3h2x2(:,537),heltab2x4(:,:,569))
  call Hloop_Q_A(ntryL,G1H2(10),27,nME,G2H2(143),n2h2(409))
  call Hloop_QV_A(ntryL,G1H4(217),ex4(:),G1H2(70),m3h2x2(:,538),heltab2x4(:,:,570))
  call Hloop_Q_A(ntryL,G1H2(70),27,nMM,G2H2(137),n2h2(410))
  call Hloop_AV_Q(ntryL,G1H4(65),ex4(:),G1H2(134),m3h2x2(:,539),heltab2x4(:,:,571))
  call Hloop_A_Q(ntryL,G1H2(134),27,nME,G2H2(124),n2h2(411))
  call Hloop_AV_Q(ntryL,G1H4(143),ex4(:),G1H2(39),m3h2x2(:,540),heltab2x4(:,:,572))
  call Hloop_A_Q(ntryL,G1H2(39),27,nMM,G2H2(31),n2h2(412))
  call Hloop_QV_A(ntryL,G1H4(136),ex4(:),G1H2(172),m3h2x2(:,541),heltab2x4(:,:,573))
  call Hloop_Q_A(ntryL,G1H2(172),27,nMT,G2H2(539),n2h2(413))
  call Hloop_AV_Q(ntryL,G1H4(84),ex4(:),G1H2(28),m3h2x2(:,542),heltab2x4(:,:,574))
  call Hloop_A_Q(ntryL,G1H2(28),27,nMT,G2H2(129),n2h2(414))
  call Hloop_QV_A(ntryL,G1H4(165),ex4(:),G1H2(46),m3h2x2(:,543),heltab2x4(:,:,575))
  call Hloop_Q_A(ntryL,G1H2(46),27,nMB,G2H2(125),n2h2(415))
  call Hloop_AV_Q(ntryL,G1H4(162),ex4(:),G1H2(91),m3h2x2(:,544),heltab2x4(:,:,576))
  call Hloop_A_Q(ntryL,G1H2(91),27,nMB,G2H2(103),n2h2(416))
  call Hloop_CV_D(ntryL,G1H4(179),19,ex4(:),8,G2H2(33),m3h2x2(:,545),heltab2x4(:,:,577))
  call Hloop_DV_C(ntryL,G1H4(130),19,ex4(:),G2H2(563),m3h2x2(:,546),heltab2x4(:,:,578))
  call Hloop_QV_A(ntryL,G1H4(11),ex4(:),G1H2(33),m3h2x2(:,547),heltab2x4(:,:,579))
  call Hloop_Q_A(ntryL,G1H2(33),27,0,G2H2(140),n2h2(417))
  call Hloop_AV_Q(ntryL,G1H4(195),ex4(:),G1H2(37),m3h2x2(:,548),heltab2x4(:,:,580))
  call Hloop_A_Q(ntryL,G1H2(37),27,0,G2H2(136),n2h2(418))
  call Hloop_AV_Q(ntryL,G1H4(251),ex3(:),G1H2(43),m3h2x2(:,549),heltab2x4(:,:,581))
  call Hloop_A_Q(ntryL,G1H2(43),23,nME,G2H2(120),n2h2(419))
  call Hloop_AV_Q(ntryL,G1H4(252),ex3(:),G1H2(127),m3h2x2(:,550),heltab2x4(:,:,582))
  call Hloop_A_Q(ntryL,G1H2(127),23,nMM,G2H2(39),n2h2(420))
  call Hloop_QV_A(ntryL,G1H4(254),ex3(:),G1H2(116),m3h2x2(:,551),heltab2x4(:,:,583))
  call Hloop_Q_A(ntryL,G1H2(116),23,nME,G2H2(476),n2h2(421))
  call Hloop_QV_A(ntryL,G1H4(42),ex3(:),G1H2(149),m3h2x2(:,552),heltab2x4(:,:,584))
  call Hloop_Q_A(ntryL,G1H2(149),23,nMM,G2H2(434),n2h2(422))
  call Hloop_AV_Q(ntryL,G1H4(95),ex3(:),G1H2(1),m3h2x2(:,553),heltab2x4(:,:,585))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(404),n2h2(423))
  call Hloop_QV_A(ntryL,G1H4(26),ex3(:),G1H2(81),m3h2x2(:,554),heltab2x4(:,:,586))
  call Hloop_Q_A(ntryL,G1H2(81),23,nMT,G2H2(55),n2h2(424))
  call Hloop_AV_Q(ntryL,G1H4(234),ex3(:),G1H2(2),m3h2x2(:,555),heltab2x4(:,:,587))
  call Hloop_A_Q(ntryL,G1H2(2),23,nMB,G2H2(51),n2h2(425))
  call Hloop_QV_A(ntryL,G1H4(10),ex3(:),G1H2(86),m3h2x2(:,556),heltab2x4(:,:,588))
  call Hloop_Q_A(ntryL,G1H2(86),23,nMB,G2H2(47),n2h2(426))
  call Hloop_DV_C(ntryL,G1H4(86),19,ex3(:),G2H2(43),m3h2x2(:,557),heltab2x4(:,:,589))
  call Hloop_CV_D(ntryL,G1H4(92),19,ex3(:),4,G2H2(59),m3h2x2(:,558),heltab2x4(:,:,590))
  call Hloop_AV_Q(ntryL,G1H4(50),ex3(:),G1H2(31),m3h2x2(:,559),heltab2x4(:,:,591))
  call Hloop_A_Q(ntryL,G1H2(31),23,0,G2H2(178),n2h2(427))
  call Hloop_QV_A(ntryL,G1H4(43),ex3(:),G1H2(181),m3h2x2(:,560),heltab2x4(:,:,592))
  call Hloop_Q_A(ntryL,G1H2(181),23,0,G2H2(63),n2h2(428))
  call Hloop_QS_A(ntryL,G1H8(23),wf4(:,36),G1H2(179),ngH,m3h4x2(:,319),heltab2x8(:,:,577))
  call Hloop_Q_A(ntryL,G1H2(179),23,nME,G2H2(67),n2h2(429))
  call Hloop_QS_A(ntryL,G1H8(30),wf4(:,36),G1H2(214),ngH,m3h4x2(:,320),heltab2x8(:,:,578))
  call Hloop_Q_A(ntryL,G1H2(214),23,nMM,G2H2(71),n2h2(430))
  call Hloop_QS_A(ntryL,G1H8(43),wf4(:,36),G1H2(3),ngH,m3h4x2(:,321),heltab2x8(:,:,579))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(74),n2h2(431))
  call Hloop_AS_Q(ntryL,G1H8(56),wf4(:,36),G1H2(35),ngH,m3h4x2(:,322),heltab2x8(:,:,580))
  call Hloop_A_Q(ntryL,G1H2(35),23,nME,G2H2(77),n2h2(432))
  call Hloop_AS_Q(ntryL,G1H8(14),wf4(:,36),G1H2(49),ngH,m3h4x2(:,323),heltab2x8(:,:,581))
  call Hloop_A_Q(ntryL,G1H2(49),23,nMM,G2H2(81),n2h2(433))
  call Hloop_AS_Q(ntryL,G1H8(20),wf4(:,36),G1H2(4),ngH,m3h4x2(:,324),heltab2x8(:,:,582))
  call Hloop_A_Q(ntryL,G1H2(4),23,nML,G2H2(467),n2h2(434))
  call Hloop_QS_A(ntryL,G1H8(34),wf4(:,36),G1H2(41),ngH,m3h4x2(:,325),heltab2x8(:,:,583))
  call Hloop_Q_A(ntryL,G1H2(41),23,nMT,G2H2(425),n2h2(435))
  call Hloop_AS_Q(ntryL,G1H8(45),wf4(:,36),G1H2(55),ngH,m3h4x2(:,326),heltab2x8(:,:,584))
  call Hloop_A_Q(ntryL,G1H2(55),23,nMT,G2H2(395),n2h2(436))
  call Hloop_QS_A(ntryL,G1H8(33),wf4(:,36),G1H2(5),ngH,m3h4x2(:,327),heltab2x8(:,:,585))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(97),n2h2(437))
  call Hloop_AS_Q(ntryL,G1H8(3),wf4(:,36),G1H2(21),ngH,m3h4x2(:,328),heltab2x8(:,:,586))
  call Hloop_A_Q(ntryL,G1H2(21),23,nMB,G2H2(93),n2h2(438))
  call Hloop_QS_A(ntryL,G1H8(9),wf4(:,37),G1H2(61),ngX,m3h4x2(:,329),heltab2x8(:,:,587))
  call Hloop_Q_A(ntryL,G1H2(61),23,nME,G2H2(89),n2h2(439))
  call Hloop_QS_A(ntryL,G1H8(67),wf4(:,37),G1H2(27),ngX,m3h4x2(:,330),heltab2x8(:,:,588))
  call Hloop_Q_A(ntryL,G1H2(27),23,nMM,G2H2(85),n2h2(440))
  call Hloop_QS_A(ntryL,G1H8(72),wf4(:,37),G1H2(67),ngX,m3h4x2(:,331),heltab2x8(:,:,589))
  call Hloop_Q_A(ntryL,G1H2(67),23,nML,G2H2(73),n2h2(441))
  call Hloop_AS_Q(ntryL,G1H8(95),wf4(:,37),G1H2(103),ngX,m3h4x2(:,332),heltab2x8(:,:,590))
  call Hloop_A_Q(ntryL,G1H2(103),23,nME,G2H2(101),n2h2(442))
  call Hloop_AS_Q(ntryL,G1H8(105),wf4(:,37),G1H2(311),ngX,m3h4x2(:,333),heltab2x8(:,:,591))
  call Hloop_A_Q(ntryL,G1H2(311),23,nMM,G2H2(10),n2h2(443))
  call Hloop_AS_Q(ntryL,G1H8(115),wf4(:,37),G1H2(7),ngX,m3h4x2(:,334),heltab2x8(:,:,592))
  call Hloop_A_Q(ntryL,G1H2(7),23,nML,G2H2(107),n2h2(444))
  call Hloop_QS_A(ntryL,G1H8(130),wf4(:,37),G1H2(11),ngX,m3h4x2(:,335),heltab2x8(:,:,593))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMT,G2H2(194),n2h2(445))
  call Hloop_AS_Q(ntryL,G1H8(134),wf4(:,37),G1H2(327),ngX,m3h4x2(:,336),heltab2x8(:,:,594))
  call Hloop_A_Q(ntryL,G1H2(327),23,nMT,G2H2(105),n2h2(446))
  call Hloop_QS_A(ntryL,G1H8(139),wf4(:,37),G1H2(8),ngX,m3h4x2(:,337),heltab2x8(:,:,595))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMB,G2H2(61),n2h2(447))
  call Hloop_AS_Q(ntryL,G1H8(144),wf4(:,37),G1H2(17),ngX,m3h4x2(:,338),heltab2x8(:,:,596))
  call Hloop_A_Q(ntryL,G1H2(17),23,nMB,G2H2(109),n2h2(448))
  call Hloop_ST_V(ntryL,G1H8(149),20,wf4(:,36),3,G2H2(12),m3h4x2(:,339),heltab2x8(:,:,597))
  call Hloop_ST_V(ntryL,G1H8(154),20,wf4(:,37),3,G2H2(113),m3h4x2(:,340),heltab2x8(:,:,598))
  call Hloop_VT_S(ntryL,G1H8(58),20,wf4(:,36),3,G2H2(116),m3h4x2(:,341),heltab2x8(:,:,599))
  call Hloop_VT_S(ntryL,G1H8(64),20,wf4(:,37),3,G2H2(69),m3h4x2(:,342),heltab2x8(:,:,600))
  call Hloop_QV_A(ntryL,G1H8(159),wf4(:,13),G1H2(18),m3h4x2(:,343),heltab2x8(:,:,601))
  call Hloop_Q_A(ntryL,G1H2(18),23,nME,G2H2(119),n2h2(449))
  call Hloop_QV_A(ntryL,G1H8(164),wf4(:,13),G1H2(113),m3h4x2(:,344),heltab2x8(:,:,602))
  call Hloop_Q_A(ntryL,G1H2(113),23,nMM,G2H2(123),n2h2(450))
  call Hloop_QV_A(ntryL,G1H8(169),wf4(:,13),G1H2(23),m3h4x2(:,345),heltab2x8(:,:,603))
  call Hloop_Q_A(ntryL,G1H2(23),23,nML,G2H2(127),n2h2(451))
  call Hloop_AV_Q(ntryL,G1H8(174),wf4(:,13),G1H2(29),m3h4x2(:,346),heltab2x8(:,:,604))
  call Hloop_A_Q(ntryL,G1H2(29),23,nME,G2H2(186),n2h2(452))
  call Hloop_AV_Q(ntryL,G1H8(179),wf4(:,13),G1H2(30),m3h4x2(:,347),heltab2x8(:,:,605))
  call Hloop_A_Q(ntryL,G1H2(30),23,nMM,G2H2(131),n2h2(453))
  call Hloop_AV_Q(ntryL,G1H8(184),wf4(:,13),G1H2(36),m3h4x2(:,348),heltab2x8(:,:,606))
  call Hloop_A_Q(ntryL,G1H2(36),23,nML,G2H2(135),n2h2(454))
  call Hloop_QV_A(ntryL,G1H8(189),wf4(:,13),G1H2(47),m3h4x2(:,349),heltab2x8(:,:,607))
  call Hloop_Q_A(ntryL,G1H2(47),23,0,G2H2(139),n2h2(455))
  call Hloop_QV_A(ntryL,G1H8(194),wf4(:,13),G1H2(48),m3h4x2(:,350),heltab2x8(:,:,608))
  call Hloop_Q_A(ntryL,G1H2(48),23,nMT,G2H2(142),n2h2(456))
  call Hloop_AV_Q(ntryL,G1H8(199),wf4(:,13),G1H2(129),m3h4x2(:,351),heltab2x8(:,:,609))
  call Hloop_A_Q(ntryL,G1H2(129),23,0,G2H2(145),n2h2(457))
  call Hloop_AV_Q(ntryL,G1H8(204),wf4(:,13),G1H2(87),m3h4x2(:,352),heltab2x8(:,:,610))
  call Hloop_A_Q(ntryL,G1H2(87),23,nMT,G2H2(149),n2h2(458))
  call Hloop_QV_A(ntryL,G1H8(209),wf4(:,13),G1H2(59),m3h4x2(:,353),heltab2x8(:,:,611))
  call Hloop_Q_A(ntryL,G1H2(59),23,nMB,G2H2(21),n2h2(459))
  call Hloop_AV_Q(ntryL,G1H8(214),wf4(:,13),G1H2(60),m3h4x2(:,354),heltab2x8(:,:,612))
  call Hloop_A_Q(ntryL,G1H2(60),23,nMB,G2H2(153),n2h2(460))
  call Hloop_QZ_A(ntryL,G1H8(219),wf4(:,14),G1H2(66),ngZl,m3h4x2(:,355),heltab2x8(:,:,613))
  call Hloop_Q_A(ntryL,G1H2(66),23,nME,G2H2(23),n2h2(461))
  call Hloop_QZ_A(ntryL,G1H8(224),wf4(:,14),G1H2(102),ngZl,m3h4x2(:,356),heltab2x8(:,:,614))
  call Hloop_Q_A(ntryL,G1H2(102),23,nMM,G2H2(87),n2h2(462))
  call Hloop_QZ_A(ntryL,G1H8(229),wf4(:,14),G1H2(71),ngZl,m3h4x2(:,357),heltab2x8(:,:,615))
  call Hloop_Q_A(ntryL,G1H2(71),23,nML,G2H2(202),n2h2(463))
  call Hloop_AZ_Q(ntryL,G1H8(234),wf4(:,14),G1H2(77),ngZl,m3h4x2(:,358),heltab2x8(:,:,616))
  call Hloop_A_Q(ntryL,G1H2(77),23,nME,G2H2(157),n2h2(464))
  call Hloop_AZ_Q(ntryL,G1H8(239),wf4(:,14),G1H2(78),ngZl,m3h4x2(:,359),heltab2x8(:,:,617))
  call Hloop_A_Q(ntryL,G1H2(78),23,nMM,G2H2(49),n2h2(465))
  call Hloop_AZ_Q(ntryL,G1H8(244),wf4(:,14),G1H2(85),ngZl,m3h4x2(:,360),heltab2x8(:,:,618))
  call Hloop_A_Q(ntryL,G1H2(85),23,nML,G2H2(161),n2h2(466))
  call Hloop_QZ_A(ntryL,G1H8(249),wf4(:,14),G1H2(100),ngZu,m3h4x2(:,361),heltab2x8(:,:,619))
  call Hloop_Q_A(ntryL,G1H2(100),23,0,G2H2(45),n2h2(467))
  call Hloop_QZ_A(ntryL,G1H8(254),wf4(:,14),G1H2(104),ngZu,m3h4x2(:,362),heltab2x8(:,:,620))
  call Hloop_Q_A(ntryL,G1H2(104),23,nMT,G2H2(165),n2h2(468))
  call Hloop_AZ_Q(ntryL,G1H8(259),wf4(:,14),G1H2(133),ngZu,m3h4x2(:,363),heltab2x8(:,:,621))
  call Hloop_A_Q(ntryL,G1H2(133),23,0,G2H2(168),n2h2(469))
  call Hloop_AZ_Q(ntryL,G1H8(264),wf4(:,14),G1H2(115),ngZu,m3h4x2(:,364),heltab2x8(:,:,622))
  call Hloop_A_Q(ntryL,G1H2(115),23,nMT,G2H2(60),n2h2(470))
  call Hloop_QZ_A(ntryL,G1H8(269),wf4(:,14),G1H2(126),ngZd,m3h4x2(:,365),heltab2x8(:,:,623))
  call Hloop_Q_A(ntryL,G1H2(126),23,0,G2H2(171),n2h2(471))
  call Hloop_QZ_A(ntryL,G1H8(274),wf4(:,14),G1H2(136),ngZd,m3h4x2(:,366),heltab2x8(:,:,624))
  call Hloop_Q_A(ntryL,G1H2(136),23,nMB,G2H2(175),n2h2(472))
  call Hloop_AZ_Q(ntryL,G1H8(279),wf4(:,14),G1H2(137),ngZd,m3h4x2(:,367),heltab2x8(:,:,625))
  call Hloop_A_Q(ntryL,G1H2(137),23,0,G2H2(98),n2h2(473))
  call Hloop_AZ_Q(ntryL,G1H8(284),wf4(:,14),G1H2(170),ngZd,m3h4x2(:,368),heltab2x8(:,:,626))
  call Hloop_A_Q(ntryL,G1H2(170),23,nMB,G2H2(102),n2h2(474))
  call Hloop_TV_S(ntryL,G1H8(289),20,wf4(:,13),3,G2H2(72),m3h4x2(:,369),heltab2x8(:,:,627))
  call Hloop_SV_T(ntryL,G1H8(294),20,wf4(:,13),3,G2H2(83),m3h4x2(:,370),heltab2x8(:,:,628))
  call Hloop_TV_S(ntryL,G1H8(299),20,wf4(:,14),3,G2H2(95),m3h4x2(:,371),heltab2x8(:,:,629))
  call Hloop_SV_T(ntryL,G1H8(304),20,wf4(:,14),3,G2H2(99),m3h4x2(:,372),heltab2x8(:,:,630))
  call Hloop_CV_D(ntryL,G1H8(309),20,wf4(:,13),3,G2H2(75),m3h4x2(:,373),heltab2x8(:,:,631))
  call Hloop_DV_C(ntryL,G1H8(314),20,wf4(:,13),G2H2(86),m3h4x2(:,374),heltab2x8(:,:,632))
  call Hloop_CV_D(ntryL,G1H8(319),20,wf4(:,14),3,G2H2(544),m3h4x2(:,375),heltab2x8(:,:,633))
  call Hloop_DV_C(ntryL,G1H8(324),20,wf4(:,14),G2H2(568),m3h4x2(:,376),heltab2x8(:,:,634))
  call Hloop_UV_W(ntryL,G1H8(329),20,wf4(:,13),3,G2H2(541),m3h4x2(:,377),heltab2x8(:,:,635))
  call Hloop_UW_V(ntryL,G1H8(334),20,wf4(:,13),3,G2H2(565),m3h4x2(:,378),heltab2x8(:,:,636))
  call Hloop_UV_W(ntryL,G1H8(339),20,wf4(:,14),3,G2H2(478),m3h4x2(:,379),heltab2x8(:,:,637))
  call Hloop_UW_V(ntryL,G1H8(344),20,wf4(:,14),3,G2H2(436),m3h4x2(:,380),heltab2x8(:,:,638))
  call Hloop_SA_Q(ntryL,G1H8(77),ex2(:),G1H4(96),ngPln,m3h2x4(:,259),heltab2x8(:,:,639))
  call Hloop_A_Q(ntryL,G1H4(96),22,0,G2H4(135),n2h4(425))
  call Hloop_WA_Q(ntryL,G1H8(82),ex2(:),G1H4(58),m3h2x4(:,260),heltab2x8(:,:,640))
  call Hloop_A_Q(ntryL,G1H4(58),22,0,G2H4(136),n2h4(426))
  call Hloop_SQ_A(ntryL,G1H8(87),ex1(:),G1H4(41),ngPnl,m3h2x4(:,261),heltab2x8(:,:,641))
  call Hloop_Q_A(ntryL,G1H4(41),21,0,G2H4(157),n2h4(427))
  call Hloop_WQ_A(ntryL,G1H8(92),ex1(:),G1H4(135),m3h2x4(:,262),heltab2x8(:,:,642))
  call Hloop_Q_A(ntryL,G1H4(135),21,0,G2H4(145),n2h4(428))
  call Hloop_VV_S(ntryL,G1H4(108),ex3(:),G1H2(154),m3h2x2(:,561),heltab2x4(:,:,593))
  call Hloop_VV_S(ntryL,G1H4(99),ex3(:),G1H2(159),m3h2x2(:,562),heltab2x4(:,:,594))
  call Hloop_SV_V(ntryL,G1H4(225),ex3(:),G1H2(163),m3h2x2(:,563),heltab2x4(:,:,595))
  call Hloop_SV_V(ntryL,G1H4(224),ex3(:),G1H2(175),m3h2x2(:,564),heltab2x4(:,:,596))
  call Hloop_SV_V(ntryL,G1H4(264),ex3(:),G1H2(198),m3h2x2(:,565),heltab2x4(:,:,597))
  call Hloop_VV_S(ntryL,G1H4(268),ex3(:),G1H2(187),m3h2x2(:,566),heltab2x4(:,:,598))
  call Hloop_TV_S(ntryL,G0H16(33),16,ex3(:),4,G1H8(28),m3h2x8(:,357),heltab2x16(:,:,693))
  call Hloop_SV_T(ntryL,G0H16(35),16,ex3(:),4,G1H8(29),m3h2x8(:,358),heltab2x16(:,:,694))
  call Hloop_TV_S(ntryL,G0H16(37),16,ex3(:),4,G1H8(31),m3h2x8(:,359),heltab2x16(:,:,695))
  call Hloop_SV_T(ntryL,G0H16(39),16,ex3(:),4,G1H8(32),m3h2x8(:,360),heltab2x16(:,:,696))
  call Hloop_SV_V(ntryL,G1H16(28),ex3(:),G1H8(41),m3h2x8(:,361),heltab2x16(:,:,697))
  call Hloop_SV_V(ntryL,G1H16(32),ex3(:),G1H8(42),m3h2x8(:,362),heltab2x16(:,:,698))
  call Hloop_VV_S(ntryL,G1H16(51),ex3(:),G1H8(44),m3h2x8(:,363),heltab2x16(:,:,699))
  call Hloop_VV_S(ntryL,G1H16(65),ex3(:),G1H8(53),m3h2x8(:,364),heltab2x16(:,:,700))
  call Hloop_UV_W(ntryL,G0H16(5),16,ex3(:),4,G1H8(54),m3h2x8(:,365),heltab2x16(:,:,701))
  call Hloop_UW_V(ntryL,G0H16(7),16,ex3(:),4,G1H8(55),m3h2x8(:,366),heltab2x16(:,:,702))
  call Hloop_UV_W(ntryL,G0H16(9),16,ex3(:),4,G1H8(65),m3h2x8(:,367),heltab2x16(:,:,703))
  call Hloop_UW_V(ntryL,G0H16(11),16,ex3(:),4,G1H8(1),m3h2x8(:,368),heltab2x16(:,:,704))
  call Hloop_TV_S(ntryL,G1H16(89),16,ex3(:),4,G2H8(42),m3h2x8(:,369),heltab2x16(:,:,705))
  call Hloop_SV_T(ntryL,G1H16(90),16,ex3(:),4,G2H8(43),m3h2x8(:,370),heltab2x16(:,:,706))
  call Hloop_TV_S(ntryL,G1H16(93),16,ex3(:),4,G2H8(46),m3h2x8(:,371),heltab2x16(:,:,707))
  call Hloop_SV_T(ntryL,G1H16(94),16,ex3(:),4,G2H8(47),m3h2x8(:,372),heltab2x16(:,:,708))
  call Hloop_UV_W(ntryL,G1H16(147),16,ex3(:),4,G2H8(44),m3h2x8(:,373),heltab2x16(:,:,709))
  call Hloop_UW_V(ntryL,G1H16(148),16,ex3(:),4,G2H8(48),m3h2x8(:,374),heltab2x16(:,:,710))
  call Hloop_UV_W(ntryL,G1H16(151),16,ex3(:),4,G2H8(49),m3h2x8(:,375),heltab2x16(:,:,711))
  call Hloop_UW_V(ntryL,G1H16(152),16,ex3(:),4,G2H8(50),m3h2x8(:,376),heltab2x16(:,:,712))
  call Hloop_VV_S(ntryL,G0H16(71),ex3(:),G0H8(13),m3h2x8(:,377),heltab2x16(:,:,713))
  call Hloop_VV_S(ntryL,G0H16(75),ex3(:),G0H8(36),m3h2x8(:,378),heltab2x16(:,:,714))
  call Hloop_SV_V(ntryL,G0H16(99),ex3(:),G0H8(6),m3h2x8(:,379),heltab2x16(:,:,715))
  call Hloop_SV_V(ntryL,G0H16(103),ex3(:),G0H8(14),m3h2x8(:,380),heltab2x16(:,:,716))
  call Hloop_SS_S(ntryL,G0H8(41),wf4(:,36),G0H2(1),m3h4x2(:,381),heltab2x8(:,:,643))
  call Hloop_SS_S(ntryL,G0H8(17),wf4(:,36),G0H2(2),m3h4x2(:,382),heltab2x8(:,:,644))
  call Hloop_VS_V(ntryL,G0H8(18),wf4(:,36),G0H2(3),m3h4x2(:,383),heltab2x8(:,:,645))
  call Hloop_VS_V(ntryL,G0H8(19),wf4(:,36),G0H2(4),m3h4x2(:,384),heltab2x8(:,:,646))
  call Hloop_ST_V(ntryL,G0H8(21),24,wf4(:,36),3,G1H2(191),m3h4x2(:,385),heltab2x8(:,:,647))
  call Hloop_ST_V(ntryL,G0H8(23),24,wf4(:,37),3,G1H2(240),m3h4x2(:,386),heltab2x8(:,:,648))
  call Hloop_VT_S(ntryL,G0H8(25),24,wf4(:,36),3,G1H2(224),m3h4x2(:,387),heltab2x8(:,:,649))
  call Hloop_VT_S(ntryL,G0H8(27),24,wf4(:,37),3,G1H2(213),m3h4x2(:,388),heltab2x8(:,:,650))
  call Hloop_TV_S(ntryL,G0H8(28),24,wf4(:,13),3,G1H2(219),m3h4x2(:,389),heltab2x8(:,:,651))
  call Hloop_SV_T(ntryL,G0H8(29),24,wf4(:,13),3,G1H2(223),m3h4x2(:,390),heltab2x8(:,:,652))
  call Hloop_TV_S(ntryL,G0H8(30),24,wf4(:,14),3,G1H2(235),m3h4x2(:,391),heltab2x8(:,:,653))
  call Hloop_SV_T(ntryL,G0H8(31),24,wf4(:,14),3,G1H2(255),m3h4x2(:,392),heltab2x8(:,:,654))
  call Hloop_UV_W(ntryL,G0H8(32),24,wf4(:,13),3,G1H2(283),m3h4x2(:,393),heltab2x8(:,:,655))
  call Hloop_UW_V(ntryL,G0H8(16),24,wf4(:,13),3,G1H2(267),m3h4x2(:,394),heltab2x8(:,:,656))
  call Hloop_UV_W(ntryL,G0H8(8),24,wf4(:,14),3,G1H2(273),m3h4x2(:,395),heltab2x8(:,:,657))
  call Hloop_UW_V(ntryL,G0H8(1),24,wf4(:,14),3,G1H2(262),m3h4x2(:,396),heltab2x8(:,:,658))
  call Hloop_SV_V(ntryL,G0H8(12),wf4(:,13),G0H2(5),m3h4x2(:,397),heltab2x8(:,:,659))
  call Hloop_SV_V(ntryL,G0H8(10),wf4(:,14),G0H2(6),m3h4x2(:,398),heltab2x8(:,:,660))
  call Hloop_VV_S(ntryL,G0H8(3),wf4(:,13),G0H2(7),m3h4x2(:,399),heltab2x8(:,:,661))
  call Hloop_VV_S(ntryL,G0H8(5),wf4(:,14),G0H2(8),m3h4x2(:,400),heltab2x8(:,:,662))
  call Hloop_VVS_S(ntryL,G0H16(125),ex3(:),wf4(:,36),G0H2(9),m4h2x4x2(:,1),heltab3x16(:,:,1))
  call Hloop_VVS_S(ntryL,G0H16(127),ex3(:),wf4(:,36),G0H2(10),m4h2x4x2(:,2),heltab3x16(:,:,2))
  call Hloop_VVS_S(ntryL,G0H16(129),ex3(:),wf4(:,37),G0H2(11),m4h2x4x2(:,3),heltab3x16(:,:,3))
  call Hloop_VVS_S(ntryL,G0H16(131),ex3(:),wf4(:,37),G0H2(12),m4h2x4x2(:,4),heltab3x16(:,:,4))
  call Hloop_SSV_V(ntryL,G1H16(171),wf4(:,36),ex3(:),G1H2(266),m4h4x2x2(:,1),heltab3x16(:,:,5))
  call Hloop_SSV_V(ntryL,G1H16(185),wf4(:,37),ex3(:),G1H2(294),m4h4x2x2(:,2),heltab3x16(:,:,6))
  call Hloop_VVS_S(ntryL,G1H16(210),ex3(:),wf4(:,36),G1H2(298),m4h2x4x2(:,5),heltab3x16(:,:,7))
  call Hloop_VVS_S(ntryL,G1H16(214),ex3(:),wf4(:,37),G1H2(326),m4h2x4x2(:,6),heltab3x16(:,:,8))
  call Hloop_SSV_V(ntryL,G0H16(153),wf4(:,36),ex3(:),G0H2(13),m4h4x2x2(:,3),heltab3x16(:,:,9))
  call Hloop_SSV_V(ntryL,G0H16(155),wf4(:,36),ex3(:),G0H2(14),m4h4x2x2(:,4),heltab3x16(:,:,10))
  call Hloop_SSV_V(ntryL,G0H16(157),wf4(:,37),ex3(:),G0H2(15),m4h4x2x2(:,5),heltab3x16(:,:,11))
  call Hloop_SSV_V(ntryL,G0H16(159),wf4(:,37),ex3(:),G0H2(16),m4h4x2x2(:,6),heltab3x16(:,:,12))
  call Hloop_SVV_S(ntryL,G1H16(267),ex3(:),wf4(:,13),G1H2(332),m4h2x4x2(:,7),heltab3x16(:,:,13))
  call Hloop_SVV_S(ntryL,G1H16(268),ex3(:),wf4(:,13),G1H2(316),m4h2x4x2(:,8),heltab3x16(:,:,14))
  call Hloop_SVV_S(ntryL,G1H16(271),ex3(:),wf4(:,14),G1H2(305),m4h2x4x2(:,9),heltab3x16(:,:,15))
  call Hloop_SVV_S(ntryL,G1H16(272),ex3(:),wf4(:,14),G1H2(325),m4h2x4x2(:,10),heltab3x16(:,:,16))
  call Hloop_VWW_V(ntryL,G1H16(285),ex3(:),wf4(:,13),G1H2(337),m4h2x4x2(:,11),heltab3x16(:,:,17))
  call Hloop_VWW_V(ntryL,G1H16(287),ex3(:),wf4(:,13),G1H2(119),m4h2x4x2(:,12),heltab3x16(:,:,18))
  call Hloop_VWW_V(ntryL,G1H16(303),ex3(:),wf4(:,14),G1H2(123),m4h2x4x2(:,13),heltab3x16(:,:,19))
  call Hloop_VWW_V(ntryL,G1H16(305),ex3(:),wf4(:,14),G1H2(97),m4h2x4x2(:,14),heltab3x16(:,:,20))
  call Hloop_SVV_S(ntryL,G0H16(2),ex3(:),wf4(:,13),G0H2(17),m4h2x4x2(:,15),heltab3x16(:,:,21))
  call Hloop_SVV_S(ntryL,G0H16(4),ex3(:),wf4(:,14),G0H2(18),m4h2x4x2(:,16),heltab3x16(:,:,22))
  call Hloop_VWW_V(ntryL,G0H16(26),ex3(:),wf4(:,13),G0H2(19),m4h2x4x2(:,17),heltab3x16(:,:,23))
  call Hloop_VWW_V(ntryL,G0H16(28),ex3(:),wf4(:,14),G0H2(20),m4h2x4x2(:,18),heltab3x16(:,:,24))
  call Hloop_SS_S(ntryL,G0H8(7),wf4(:,36),G0H2(21),m3h4x2(:,401),heltab2x8(:,:,663))
  call Hloop_SS_S(ntryL,G0H8(15),wf4(:,36),G0H2(22),m3h4x2(:,402),heltab2x8(:,:,664))
  call Hloop_VS_V(ntryL,G0H8(34),wf4(:,36),G0H2(23),m3h4x2(:,403),heltab2x8(:,:,665))
  call Hloop_VS_V(ntryL,G0H8(35),wf4(:,36),G0H2(24),m3h4x2(:,404),heltab2x8(:,:,666))
  call Hloop_SV_V(ntryL,G0H8(50),wf4(:,13),G0H2(25),m3h4x2(:,405),heltab2x8(:,:,667))
  call Hloop_SV_V(ntryL,G0H8(52),wf4(:,14),G0H2(26),m3h4x2(:,406),heltab2x8(:,:,668))
  call Hloop_VV_S(ntryL,G0H8(54),wf4(:,13),G0H2(27),m3h4x2(:,407),heltab2x8(:,:,669))
  call Hloop_VV_S(ntryL,G0H8(56),wf4(:,14),G0H2(28),m3h4x2(:,408),heltab2x8(:,:,670))
  call Hloop_SS_S(ntryL,G1H16(330),wf4(:,36),G1H4(206),m3h4x4(:,337),heltab2x16(:,:,717))
  call Hloop_VS_V(ntryL,G1H16(334),wf4(:,36),G1H4(123),m3h4x4(:,338),heltab2x16(:,:,718))
  call Hloop_VT_S(ntryL,G0H16(30),16,wf4(:,36),3,G1H4(158),m3h4x4(:,339),heltab2x16(:,:,719))
  call Hloop_VT_S(ntryL,G0H16(32),16,wf4(:,37),3,G1H4(44),m3h4x4(:,340),heltab2x16(:,:,720))
  call Hloop_ST_V(ntryL,G0H16(36),16,wf4(:,36),3,G1H4(55),m3h4x4(:,341),heltab2x16(:,:,721))
  call Hloop_ST_V(ntryL,G0H16(40),16,wf4(:,37),3,G1H4(161),m3h4x4(:,342),heltab2x16(:,:,722))
  call Hloop_SV_T(ntryL,G1H16(1),16,wf4(:,13),3,G2H4(159),m3h4x4(:,343),heltab2x16(:,:,723))
  call Hloop_TV_S(ntryL,G1H16(2),16,wf4(:,13),3,G2H4(147),m3h4x4(:,344),heltab2x16(:,:,724))
  call Hloop_SV_T(ntryL,G1H16(3),16,wf4(:,14),3,G2H4(66),m3h4x4(:,345),heltab2x16(:,:,725))
  call Hloop_TV_S(ntryL,G1H16(4),16,wf4(:,14),3,G2H4(185),m3h4x4(:,346),heltab2x16(:,:,726))
  call Hloop_UW_V(ntryL,G1H16(5),16,wf4(:,13),3,G2H4(186),m3h4x4(:,347),heltab2x16(:,:,727))
  call Hloop_UV_W(ntryL,G1H16(6),16,wf4(:,13),3,G2H4(187),m3h4x4(:,348),heltab2x16(:,:,728))
  call Hloop_UW_V(ntryL,G1H16(7),16,wf4(:,14),3,G2H4(79),m3h4x4(:,349),heltab2x16(:,:,729))
  call Hloop_UV_W(ntryL,G1H16(8),16,wf4(:,14),3,G2H4(188),m3h4x4(:,350),heltab2x16(:,:,730))
  call Hloop_VV_S(ntryL,G0H16(42),wf4(:,13),G0H4(129),m3h4x4(:,351),heltab2x16(:,:,731))
  call Hloop_VV_S(ntryL,G0H16(44),wf4(:,14),G0H4(90),m3h4x4(:,352),heltab2x16(:,:,732))
  call Hloop_SV_V(ntryL,G0H16(46),wf4(:,13),G0H4(50),m3h4x4(:,353),heltab2x16(:,:,733))
  call Hloop_SV_V(ntryL,G0H16(48),wf4(:,14),G0H4(29),m3h4x4(:,354),heltab2x16(:,:,734))
  call Hloop_SA_Q(ntryL,G0H8(57),ex2(:),G0H4(17),ngPln,m3h2x4(:,263),heltab2x8(:,:,671))
  call Hloop_A_Q(ntryL,G0H4(17),26,0,G1H4(177),n2h4(429))
  call Hloop_WA_Q(ntryL,G0H8(58),ex2(:),G0H4(108),m3h2x4(:,264),heltab2x8(:,:,672))
  call Hloop_A_Q(ntryL,G0H4(108),26,0,G1H4(114),n2h4(430))
  call Hloop_SQ_A(ntryL,G0H8(59),ex1(:),G0H4(106),ngPnl,m3h2x4(:,265),heltab2x8(:,:,673))
  call Hloop_Q_A(ntryL,G0H4(106),25,0,G1H4(250),n2h4(431))
  call Hloop_WQ_A(ntryL,G0H8(60),ex1(:),G0H4(68),m3h2x4(:,266),heltab2x8(:,:,674))
  call Hloop_Q_A(ntryL,G0H4(68),25,0,G1H4(175),n2h4(432))
  call Hloop_QA_S(ntryL,G1H8(99),ex2(:),G1H4(191),ngPln,m3h2x4(:,267),heltab2x8(:,:,675))
  call Hloop_QA_W(ntryL,G1H8(100),ex2(:),G1H4(202),m3h2x4(:,268),heltab2x8(:,:,676))
  call Hloop_AQ_S(ntryL,G1H8(101),ex1(:),G1H4(231),ngPnl,m3h2x4(:,269),heltab2x8(:,:,677))
  call Hloop_AQ_W(ntryL,G1H8(102),ex1(:),G1H4(194),m3h2x4(:,270),heltab2x8(:,:,678))
  call Hloop_AQ_S(ntryL,G1H16(9),wf4(:,3),G1H4(76),ngH,m3h4x4(:,355),heltab2x16(:,:,735))
  call Hloop_AQ_S(ntryL,G1H16(10),wf4(:,3),G1H4(36),ngX,m3h4x4(:,356),heltab2x16(:,:,736))
  call Hloop_SQ_A(ntryL,G1H16(11),wf4(:,3),G1H4(258),ngPnl,m3h4x4(:,357),heltab2x16(:,:,737))
  call Hloop_Q_A(ntryL,G1H4(258),21,0,G2H4(84),n2h4(433))
  call Hloop_AQ_V(ntryL,G1H16(12),wf4(:,3),G1H4(120),m3h4x4(:,358),heltab2x16(:,:,738))
  call Hloop_AQ_Z(ntryL,G1H16(13),wf4(:,3),G1H4(117),ngZl,m3h4x4(:,359),heltab2x16(:,:,739))
  call Hloop_SQ_A(ntryL,G0H16(17),wf4(:,3),G0H4(66),ngPnl,m3h4x4(:,360),heltab2x16(:,:,740))
  call Hloop_Q_A(ntryL,G0H4(66),21,0,G1H4(80),n2h4(434))
  call Hloop_WQ_A(ntryL,G0H16(18),wf4(:,3),G0H4(25),m3h4x4(:,361),heltab2x16(:,:,741))
  call Hloop_Q_A(ntryL,G0H4(25),21,0,G1H4(23),n2h4(435))
  call Hloop_WQ_A(ntryL,G1H16(14),wf4(:,3),G1H4(53),m3h4x4(:,362),heltab2x16(:,:,742))
  call Hloop_Q_A(ntryL,G1H4(53),21,0,G2H4(189),n2h4(436))
  call Hloop_SQ_A(ntryL,G0H8(65),wf4(:,3),G0H2(29),ngH,m3h4x2(:,409),heltab2x8(:,:,679))
  call Hloop_Q_A(ntryL,G0H2(29),23,nML,G1H2(82),n2h2(475))
  call Hloop_SQ_A(ntryL,G0H8(66),wf4(:,3),G0H2(29),ngX,m3h4x2(:,410),heltab2x8(:,:,680))
  call Hloop_Q_A(ntryL,G0H2(29),23,nML,G1H2(324),n2h2(476))
  call Hloop_AQ_S(ntryL,G1H8(109),wf4(:,3),G1H2(312),ngPnl,m3h4x2(:,411),heltab2x8(:,:,681))
  call Hloop_VQ_A(ntryL,G0H8(67),wf4(:,3),G0H2(29),m3h4x2(:,412),heltab2x8(:,:,682))
  call Hloop_Q_A(ntryL,G0H2(29),23,nML,G1H2(228),n2h2(477))
  call Hloop_ZQ_A(ntryL,G0H8(68),wf4(:,3),G0H2(29),ngZl,m3h4x2(:,413),heltab2x8(:,:,683))
  call Hloop_Q_A(ntryL,G0H2(29),23,nML,G1H2(259),n2h2(478))
  call Hloop_AQ_S(ntryL,G1H8(110),wf4(:,3),G1H2(68),ngPnl,m3h4x2(:,414),heltab2x8(:,:,684))
  call Hloop_AQ_W(ntryL,G1H8(111),wf4(:,3),G1H2(63),m3h4x2(:,415),heltab2x8(:,:,685))
  call Hloop_AQ_W(ntryL,G1H8(112),wf4(:,3),G1H2(318),m3h4x2(:,416),heltab2x8(:,:,686))
  call Hloop_AS_Q(ntryL,G1H16(15),wf8(:,10),G1H2(303),ngH,m3h8x2(:,1),heltab2x16(:,:,743))
  call Hloop_A_Q(ntryL,G1H2(303),23,nME,G2H2(406),n2h2(479))
  call Hloop_AS_Q(ntryL,G1H16(16),wf8(:,10),G1H2(285),ngH,m3h8x2(:,2),heltab2x16(:,:,744))
  call Hloop_A_Q(ntryL,G1H2(285),23,nMM,G2H2(24),n2h2(480))
  call Hloop_AS_Q(ntryL,G1H16(17),wf8(:,10),G1H2(232),ngH,m3h8x2(:,3),heltab2x16(:,:,745))
  call Hloop_A_Q(ntryL,G1H2(232),23,nML,G2H2(469),n2h2(481))
  call Hloop_QS_A(ntryL,G1H16(18),wf8(:,10),G1H2(168),ngH,m3h8x2(:,4),heltab2x16(:,:,746))
  call Hloop_Q_A(ntryL,G1H2(168),23,nME,G2H2(427),n2h2(482))
  call Hloop_QS_A(ntryL,G1H16(19),wf8(:,10),G1H2(14),ngH,m3h8x2(:,5),heltab2x16(:,:,747))
  call Hloop_Q_A(ntryL,G1H2(14),23,nMM,G2H2(397),n2h2(483))
  call Hloop_QS_A(ntryL,G1H16(20),wf8(:,10),G1H2(44),ngH,m3h8x2(:,6),heltab2x16(:,:,748))
  call Hloop_Q_A(ntryL,G1H2(44),23,nML,G2H2(11),n2h2(484))
  call Hloop_AS_Q(ntryL,G1H16(21),wf8(:,10),G1H2(206),ngH,m3h8x2(:,7),heltab2x16(:,:,749))
  call Hloop_A_Q(ntryL,G1H2(206),23,nMT,G2H2(6),n2h2(485))
  call Hloop_QS_A(ntryL,G1H16(22),wf8(:,10),G1H2(233),ngH,m3h8x2(:,8),heltab2x16(:,:,750))
  call Hloop_Q_A(ntryL,G1H2(233),23,nMT,G2H2(8),n2h2(486))
  call Hloop_AS_Q(ntryL,G1H16(23),wf8(:,10),G1H2(280),ngH,m3h8x2(:,9),heltab2x16(:,:,751))
  call Hloop_A_Q(ntryL,G1H2(280),23,nMB,G2H2(16),n2h2(487))
  call Hloop_QS_A(ntryL,G1H16(24),wf8(:,10),G1H2(182),ngH,m3h8x2(:,10),heltab2x16(:,:,752))
  call Hloop_Q_A(ntryL,G1H2(182),23,nMB,G2H2(18),n2h2(488))
  call Hloop_AS_Q(ntryL,G1H16(25),wf8(:,44),G1H2(296),ngX,m3h8x2(:,11),heltab2x16(:,:,753))
  call Hloop_A_Q(ntryL,G1H2(296),23,nME,G2H2(250),n2h2(489))
  call Hloop_AS_Q(ntryL,G1H16(26),wf8(:,44),G1H2(177),ngX,m3h8x2(:,12),heltab2x16(:,:,754))
  call Hloop_A_Q(ntryL,G1H2(177),23,nMM,G2H2(78),n2h2(490))
  call Hloop_AS_Q(ntryL,G1H16(29),wf8(:,44),G1H2(64),ngX,m3h8x2(:,13),heltab2x16(:,:,755))
  call Hloop_A_Q(ntryL,G1H2(64),23,nML,G2H2(247),n2h2(491))
  call Hloop_QS_A(ntryL,G1H16(30),wf8(:,44),G1H2(292),ngX,m3h8x2(:,14),heltab2x16(:,:,756))
  call Hloop_Q_A(ntryL,G1H2(292),23,nME,G2H2(82),n2h2(492))
  call Hloop_QS_A(ntryL,G1H16(33),wf8(:,44),G1H2(183),ngX,m3h8x2(:,15),heltab2x16(:,:,757))
  call Hloop_Q_A(ntryL,G1H2(183),23,nMM,G2H2(232),n2h2(493))
  call Hloop_QS_A(ntryL,G1H16(34),wf8(:,44),G1H2(253),ngX,m3h8x2(:,16),heltab2x16(:,:,758))
  call Hloop_Q_A(ntryL,G1H2(253),23,nML,G2H2(91),n2h2(494))
  call Hloop_AS_Q(ntryL,G1H16(35),wf8(:,44),G1H2(276),ngX,m3h8x2(:,17),heltab2x16(:,:,759))
  call Hloop_A_Q(ntryL,G1H2(276),23,nMT,G2H2(229),n2h2(495))
  call Hloop_QS_A(ntryL,G1H16(36),wf8(:,44),G1H2(339),ngX,m3h8x2(:,18),heltab2x16(:,:,760))
  call Hloop_Q_A(ntryL,G1H2(339),23,nMT,G2H2(94),n2h2(496))
  call Hloop_AS_Q(ntryL,G1H16(37),wf8(:,44),G1H2(340),ngX,m3h8x2(:,19),heltab2x16(:,:,761))
  call Hloop_A_Q(ntryL,G1H2(340),23,nMB,G2H2(551),n2h2(497))
  call Hloop_QS_A(ntryL,G1H16(38),wf8(:,44),G1H2(341),ngX,m3h8x2(:,20),heltab2x16(:,:,762))
  call Hloop_Q_A(ntryL,G1H2(341),23,nMB,G2H2(114),n2h2(498))
  call Hloop_SS_S(ntryL,G1H16(39),wf8(:,10),G1H2(344),m3h8x2(:,21),heltab2x16(:,:,763))
  call Hloop_SS_S(ntryL,G1H16(40),wf8(:,10),G1H2(345),m3h8x2(:,22),heltab2x16(:,:,764))
  call Hloop_SS_S(ntryL,G1H16(44),wf8(:,10),G1H2(346),m3h8x2(:,23),heltab2x16(:,:,765))
  call Hloop_SS_S(ntryL,G1H16(45),wf8(:,10),G1H2(349),m3h8x2(:,24),heltab2x16(:,:,766))
  call Hloop_SS_S(ntryL,G1H16(48),wf8(:,44),G1H2(350),m3h8x2(:,25),heltab2x16(:,:,767))
  call Hloop_SS_S(ntryL,G1H16(49),wf8(:,44),G1H2(351),m3h8x2(:,26),heltab2x16(:,:,768))
  call Hloop_VS_V(ntryL,G1H16(50),wf8(:,10),G1H2(354),m3h8x2(:,27),heltab2x16(:,:,769))
  call Hloop_VS_V(ntryL,G1H16(52),wf8(:,10),G1H2(355),m3h8x2(:,28),heltab2x16(:,:,770))
  call Hloop_VT_S(ntryL,G0H16(59),16,wf8(:,10),7,G1H2(356),m3h8x2(:,29),heltab2x16(:,:,771))
  call Hloop_VT_S(ntryL,G0H16(60),16,wf8(:,10),7,G1H2(359),m3h8x2(:,30),heltab2x16(:,:,772))
  call Hloop_VT_S(ntryL,G0H16(61),16,wf8(:,44),7,G1H2(360),m3h8x2(:,31),heltab2x16(:,:,773))
  call Hloop_VT_S(ntryL,G0H16(62),16,wf8(:,44),7,G1H2(361),m3h8x2(:,32),heltab2x16(:,:,774))
  call Hloop_ST_V(ntryL,G1H16(54),16,wf8(:,10),7,G2H2(110),m3h8x2(:,33),heltab2x16(:,:,775))
  call Hloop_ST_V(ntryL,G1H16(56),16,wf8(:,44),7,G2H2(554),m3h8x2(:,34),heltab2x16(:,:,776))
  call Hloop_SS_S(ntryL,G0H16(64),wf8(:,10),G0H2(29),m3h8x2(:,35),heltab2x16(:,:,777))
  call Hloop_VS_V(ntryL,G0H16(66),wf8(:,10),G0H2(30),m3h8x2(:,36),heltab2x16(:,:,778))
  call Hloop_VT_S(ntryL,G1H16(58),16,wf8(:,10),7,G2H2(117),m3h8x2(:,37),heltab2x16(:,:,779))
  call Hloop_VT_S(ntryL,G1H16(60),16,wf8(:,44),7,G2H2(111),m3h8x2(:,38),heltab2x16(:,:,780))
  call Hloop_ST_V(ntryL,G0H16(67),16,wf8(:,10),7,G1H2(364),m3h8x2(:,39),heltab2x16(:,:,781))
  call Hloop_ST_V(ntryL,G0H16(68),16,wf8(:,10),7,G1H2(365),m3h8x2(:,40),heltab2x16(:,:,782))
  call Hloop_ST_V(ntryL,G0H16(70),16,wf8(:,44),7,G1H2(366),m3h8x2(:,41),heltab2x16(:,:,783))
  call Hloop_ST_V(ntryL,G0H16(72),16,wf8(:,44),7,G1H2(369),m3h8x2(:,42),heltab2x16(:,:,784))
  call Hloop_AV_Q(ntryL,G1H16(61),wf8(:,45),G1H2(370),m3h8x2(:,43),heltab2x16(:,:,785))
  call Hloop_A_Q(ntryL,G1H2(370),23,nME,G2H2(231),n2h2(499))
  call Hloop_AV_Q(ntryL,G1H16(62),wf8(:,45),G1H2(371),m3h8x2(:,44),heltab2x16(:,:,786))
  call Hloop_A_Q(ntryL,G1H2(371),23,nMM,G2H2(234),n2h2(500))
  call Hloop_AV_Q(ntryL,G1H16(67),wf8(:,45),G1H2(374),m3h8x2(:,45),heltab2x16(:,:,787))
  call Hloop_A_Q(ntryL,G1H2(374),23,nML,G2H2(249),n2h2(501))
  call Hloop_QV_A(ntryL,G1H16(64),wf8(:,45),G1H2(375),m3h8x2(:,46),heltab2x16(:,:,788))
  call Hloop_Q_A(ntryL,G1H2(375),23,nME,G2H2(252),n2h2(502))
  call Hloop_QV_A(ntryL,G1H16(69),wf8(:,45),G1H2(376),m3h8x2(:,47),heltab2x16(:,:,789))
  call Hloop_Q_A(ntryL,G1H2(376),23,nMM,G2H2(461),n2h2(503))
  call Hloop_QV_A(ntryL,G1H16(66),wf8(:,45),G1H2(379),m3h8x2(:,48),heltab2x16(:,:,790))
  call Hloop_Q_A(ntryL,G1H2(379),23,nML,G2H2(419),n2h2(504))
  call Hloop_AV_Q(ntryL,G1H16(73),wf8(:,45),G1H2(380),m3h8x2(:,49),heltab2x16(:,:,791))
  call Hloop_A_Q(ntryL,G1H2(380),23,0,G2H2(389),n2h2(505))
  call Hloop_AV_Q(ntryL,G1H16(70),wf8(:,45),G1H2(381),m3h8x2(:,50),heltab2x16(:,:,792))
  call Hloop_A_Q(ntryL,G1H2(381),23,nMT,G2H2(463),n2h2(506))
  call Hloop_QV_A(ntryL,G1H16(75),wf8(:,45),G1H2(384),m3h8x2(:,51),heltab2x16(:,:,793))
  call Hloop_Q_A(ntryL,G1H2(384),23,0,G2H2(421),n2h2(507))
  call Hloop_QV_A(ntryL,G1H16(72),wf8(:,45),G1H2(385),m3h8x2(:,52),heltab2x16(:,:,794))
  call Hloop_Q_A(ntryL,G1H2(385),23,nMT,G2H2(391),n2h2(508))
  call Hloop_AV_Q(ntryL,G1H16(74),wf8(:,45),G1H2(386),m3h8x2(:,53),heltab2x16(:,:,795))
  call Hloop_A_Q(ntryL,G1H2(386),23,nMB,G2H2(464),n2h2(509))
  call Hloop_QV_A(ntryL,G1H16(76),wf8(:,45),G1H2(389),m3h8x2(:,54),heltab2x16(:,:,796))
  call Hloop_Q_A(ntryL,G1H2(389),23,nMB,G2H2(422),n2h2(510))
  call Hloop_AZ_Q(ntryL,G1H16(77),wf8(:,46),G1H2(390),ngZl,m3h8x2(:,55),heltab2x16(:,:,797))
  call Hloop_A_Q(ntryL,G1H2(390),23,nME,G2H2(392),n2h2(511))
  call Hloop_AZ_Q(ntryL,G1H16(78),wf8(:,46),G1H2(391),ngZl,m3h8x2(:,56),heltab2x16(:,:,798))
  call Hloop_A_Q(ntryL,G1H2(391),23,nMM,G2H2(466),n2h2(512))
  call Hloop_AZ_Q(ntryL,G1H16(79),wf8(:,46),G1H2(394),ngZl,m3h8x2(:,57),heltab2x16(:,:,799))
  call Hloop_A_Q(ntryL,G1H2(394),23,nML,G2H2(424),n2h2(513))
  call Hloop_QZ_A(ntryL,G1H16(80),wf8(:,46),G1H2(395),ngZl,m3h8x2(:,58),heltab2x16(:,:,800))
  call Hloop_Q_A(ntryL,G1H2(395),23,nME,G2H2(394),n2h2(514))
  call Hloop_QZ_A(ntryL,G1H16(81),wf8(:,46),G1H2(396),ngZl,m3h8x2(:,59),heltab2x16(:,:,801))
  call Hloop_Q_A(ntryL,G1H2(396),23,nMM,G2H2(470),n2h2(515))
  call Hloop_QZ_A(ntryL,G1H16(82),wf8(:,46),G1H2(399),ngZl,m3h8x2(:,60),heltab2x16(:,:,802))
  call Hloop_Q_A(ntryL,G1H2(399),23,nML,G2H2(428),n2h2(516))
  call Hloop_AZ_Q(ntryL,G1H16(83),wf8(:,46),G1H2(400),ngZu,m3h8x2(:,61),heltab2x16(:,:,803))
  call Hloop_A_Q(ntryL,G1H2(400),23,0,G2H2(398),n2h2(517))
  call Hloop_AZ_Q(ntryL,G1H16(84),wf8(:,46),G1H2(401),ngZu,m3h8x2(:,62),heltab2x16(:,:,804))
  call Hloop_A_Q(ntryL,G1H2(401),23,nMT,G2H2(472),n2h2(518))
  call Hloop_QZ_A(ntryL,G1H16(85),wf8(:,46),G1H2(404),ngZu,m3h8x2(:,63),heltab2x16(:,:,805))
  call Hloop_Q_A(ntryL,G1H2(404),23,0,G2H2(430),n2h2(519))
  call Hloop_QZ_A(ntryL,G1H16(86),wf8(:,46),G1H2(405),ngZu,m3h8x2(:,64),heltab2x16(:,:,806))
  call Hloop_Q_A(ntryL,G1H2(405),23,nMT,G2H2(400),n2h2(520))
  call Hloop_AZ_Q(ntryL,G1H16(87),wf8(:,46),G1H2(406),ngZd,m3h8x2(:,65),heltab2x16(:,:,807))
  call Hloop_A_Q(ntryL,G1H2(406),23,0,G2H2(473),n2h2(521))
  call Hloop_AZ_Q(ntryL,G1H16(88),wf8(:,46),G1H2(409),ngZd,m3h8x2(:,66),heltab2x16(:,:,808))
  call Hloop_A_Q(ntryL,G1H2(409),23,nMB,G2H2(431),n2h2(522))
  call Hloop_QZ_A(ntryL,G1H16(91),wf8(:,46),G1H2(410),ngZd,m3h8x2(:,67),heltab2x16(:,:,809))
  call Hloop_Q_A(ntryL,G1H2(410),23,0,G2H2(401),n2h2(523))
  call Hloop_QZ_A(ntryL,G1H16(92),wf8(:,46),G1H2(411),ngZd,m3h8x2(:,68),heltab2x16(:,:,810))
  call Hloop_Q_A(ntryL,G1H2(411),23,nMB,G2H2(475),n2h2(524))
  call Hloop_SV_T(ntryL,G1H16(95),16,wf8(:,45),7,G2H2(433),m3h8x2(:,69),heltab2x16(:,:,811))
  call Hloop_TV_S(ntryL,G1H16(96),16,wf8(:,45),7,G2H2(403),m3h8x2(:,70),heltab2x16(:,:,812))
  call Hloop_SV_T(ntryL,G1H16(97),16,wf8(:,46),7,G2H2(482),m3h8x2(:,71),heltab2x16(:,:,813))
  call Hloop_TV_S(ntryL,G1H16(98),16,wf8(:,46),7,G2H2(437),m3h8x2(:,72),heltab2x16(:,:,814))
  call Hloop_DV_C(ntryL,G1H16(101),16,wf8(:,45),G2H2(407),m3h8x2(:,73),heltab2x16(:,:,815))
  call Hloop_CV_D(ntryL,G1H16(102),16,wf8(:,45),7,G2H2(484),m3h8x2(:,74),heltab2x16(:,:,816))
  call Hloop_DV_C(ntryL,G1H16(105),16,wf8(:,46),G2H2(439),m3h8x2(:,75),heltab2x16(:,:,817))
  call Hloop_CV_D(ntryL,G1H16(106),16,wf8(:,46),7,G2H2(409),m3h8x2(:,76),heltab2x16(:,:,818))
  call Hloop_UW_V(ntryL,G1H16(107),16,wf8(:,45),7,G2H2(488),m3h8x2(:,77),heltab2x16(:,:,819))
  call Hloop_UV_W(ntryL,G1H16(108),16,wf8(:,45),7,G2H2(440),m3h8x2(:,78),heltab2x16(:,:,820))
  call Hloop_UW_V(ntryL,G1H16(109),16,wf8(:,46),7,G2H2(410),m3h8x2(:,79),heltab2x16(:,:,821))
  call Hloop_UV_W(ntryL,G1H16(110),16,wf8(:,46),7,G2H2(490),m3h8x2(:,80),heltab2x16(:,:,822))
  call Hloop_VV_S(ntryL,G0H16(107),wf8(:,45),G0H2(31),m3h8x2(:,81),heltab2x16(:,:,823))
  call Hloop_VV_S(ntryL,G0H16(108),wf8(:,45),G0H2(32),m3h8x2(:,82),heltab2x16(:,:,824))
  call Hloop_VV_S(ntryL,G0H16(109),wf8(:,46),G0H2(33),m3h8x2(:,83),heltab2x16(:,:,825))
  call Hloop_VV_S(ntryL,G0H16(110),wf8(:,46),G0H2(34),m3h8x2(:,84),heltab2x16(:,:,826))
  call Hloop_SV_V(ntryL,G1H16(112),wf8(:,45),G1H2(414),m3h8x2(:,85),heltab2x16(:,:,827))
  call Hloop_SV_V(ntryL,G1H16(114),wf8(:,46),G1H2(415),m3h8x2(:,86),heltab2x16(:,:,828))
  call Hloop_SV_T(ntryL,G0H16(111),16,wf8(:,45),7,G1H2(416),m3h8x2(:,87),heltab2x16(:,:,829))
  call Hloop_TV_S(ntryL,G0H16(112),16,wf8(:,45),7,G1H2(419),m3h8x2(:,88),heltab2x16(:,:,830))
  call Hloop_SV_T(ntryL,G0H16(113),16,wf8(:,46),7,G1H2(420),m3h8x2(:,89),heltab2x16(:,:,831))
  call Hloop_TV_S(ntryL,G0H16(114),16,wf8(:,46),7,G1H2(421),m3h8x2(:,90),heltab2x16(:,:,832))
  call Hloop_UW_V(ntryL,G0H16(115),16,wf8(:,45),7,G1H2(424),m3h8x2(:,91),heltab2x16(:,:,833))
  call Hloop_UV_W(ntryL,G0H16(116),16,wf8(:,45),7,G1H2(425),m3h8x2(:,92),heltab2x16(:,:,834))
  call Hloop_UW_V(ntryL,G0H16(117),16,wf8(:,46),7,G1H2(426),m3h8x2(:,93),heltab2x16(:,:,835))
  call Hloop_UV_W(ntryL,G0H16(118),16,wf8(:,46),7,G1H2(429),m3h8x2(:,94),heltab2x16(:,:,836))
  call Hloop_VV_S(ntryL,G1H16(116),wf8(:,45),G1H2(430),m3h8x2(:,95),heltab2x16(:,:,837))
  call Hloop_VV_S(ntryL,G1H16(118),wf8(:,46),G1H2(431),m3h8x2(:,96),heltab2x16(:,:,838))
  call Hloop_SV_V(ntryL,G0H16(119),wf8(:,45),G0H2(35),m3h8x2(:,97),heltab2x16(:,:,839))
  call Hloop_SV_V(ntryL,G0H16(120),wf8(:,45),G0H2(36),m3h8x2(:,98),heltab2x16(:,:,840))
  call Hloop_SV_V(ntryL,G0H16(121),wf8(:,46),G0H2(37),m3h8x2(:,99),heltab2x16(:,:,841))
  call Hloop_SV_V(ntryL,G0H16(122),wf8(:,46),G0H2(38),m3h8x2(:,100),heltab2x16(:,:,842))
  call Hloop_QA_S(ntryL,G1H16(119),ex2(:),G1H8(4),ngH,m3h2x8(:,381),heltab2x16(:,:,843))
  call Hloop_QA_S(ntryL,G1H16(120),ex2(:),G1H8(6),ngX,m3h2x8(:,382),heltab2x16(:,:,844))
  call Hloop_SA_Q(ntryL,G1H16(121),ex2(:),G1H8(13),ngPln,m3h2x8(:,383),heltab2x16(:,:,845))
  call Hloop_A_Q(ntryL,G1H8(13),18,0,G2H8(51),n2h8(293))
  call Hloop_QA_V(ntryL,G1H16(122),ex2(:),G1H8(16),m3h2x8(:,384),heltab2x16(:,:,846))
  call Hloop_QA_Z(ntryL,G1H16(123),ex2(:),G1H8(15),ngZl,m3h2x8(:,385),heltab2x16(:,:,847))
  call Hloop_SA_Q(ntryL,G0H16(130),ex2(:),G0H8(37),ngPln,m3h2x8(:,386),heltab2x16(:,:,848))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(17),n2h8(294))
  call Hloop_WA_Q(ntryL,G0H16(132),ex2(:),G0H8(33),m3h2x8(:,387),heltab2x16(:,:,849))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(19),n2h8(295))
  call Hloop_WA_Q(ntryL,G1H16(124),ex2(:),G1H8(21),m3h2x8(:,388),heltab2x16(:,:,850))
  call Hloop_A_Q(ntryL,G1H8(21),18,0,G2H8(52),n2h8(296))
  call Hloop_SA_Q(ntryL,G0H4(81),ex2(:),G0H2(39),ngH,m3h2x2(:,567),heltab2x4(:,:,599))
  call Hloop_A_Q(ntryL,G0H2(39),23,nML,G1H2(434),n2h2(525))
  call Hloop_SA_Q(ntryL,G0H4(82),ex2(:),G0H2(39),ngX,m3h2x2(:,568),heltab2x4(:,:,600))
  call Hloop_A_Q(ntryL,G0H2(39),23,nML,G1H2(435),n2h2(526))
  call Hloop_QA_S(ntryL,G1H4(183),ex2(:),G1H2(436),ngPln,m3h2x2(:,569),heltab2x4(:,:,601))
  call Hloop_VA_Q(ntryL,G0H4(83),ex2(:),G0H2(39),m3h2x2(:,570),heltab2x4(:,:,602))
  call Hloop_A_Q(ntryL,G0H2(39),23,nML,G1H2(439),n2h2(527))
  call Hloop_ZA_Q(ntryL,G0H4(84),ex2(:),G0H2(39),ngZl,m3h2x2(:,571),heltab2x4(:,:,603))
  call Hloop_A_Q(ntryL,G0H2(39),23,nML,G1H2(440),n2h2(528))
  call Hloop_QA_S(ntryL,G1H4(198),ex2(:),G1H2(441),ngPln,m3h2x2(:,572),heltab2x4(:,:,604))
  call Hloop_QA_W(ntryL,G1H4(196),ex2(:),G1H2(444),m3h2x2(:,573),heltab2x4(:,:,605))
  call Hloop_QA_W(ntryL,G1H4(184),ex2(:),G1H2(445),m3h2x2(:,574),heltab2x4(:,:,606))
  call Hloop_QA_S(ntryL,G1H16(125),wf4(:,10),G1H4(208),ngH,m3h4x4(:,363),heltab2x16(:,:,851))
  call Hloop_QA_S(ntryL,G1H16(126),wf4(:,10),G1H4(66),ngX,m3h4x4(:,364),heltab2x16(:,:,852))
  call Hloop_SA_Q(ntryL,G1H16(127),wf4(:,10),G1H4(154),ngPln,m3h4x4(:,365),heltab2x16(:,:,853))
  call Hloop_A_Q(ntryL,G1H4(154),22,0,G2H4(190),n2h4(437))
  call Hloop_QA_V(ntryL,G1H16(128),wf4(:,10),G1H4(152),m3h4x4(:,366),heltab2x16(:,:,854))
  call Hloop_QA_Z(ntryL,G1H16(129),wf4(:,10),G1H4(87),ngZl,m3h4x4(:,367),heltab2x16(:,:,855))
  call Hloop_WA_Q(ntryL,G0H16(137),wf4(:,10),G0H4(34),m3h4x4(:,368),heltab2x16(:,:,856))
  call Hloop_A_Q(ntryL,G0H4(34),22,0,G1H4(69),n2h4(438))
  call Hloop_SA_Q(ntryL,G0H16(138),wf4(:,10),G0H4(120),ngPln,m3h4x4(:,369),heltab2x16(:,:,857))
  call Hloop_A_Q(ntryL,G0H4(120),22,0,G1H4(49),n2h4(439))
  call Hloop_WA_Q(ntryL,G1H16(130),wf4(:,10),G1H4(173),m3h4x4(:,370),heltab2x16(:,:,858))
  call Hloop_A_Q(ntryL,G1H4(173),22,0,G2H4(191),n2h4(440))
  call Hloop_SA_Q(ntryL,G0H8(69),wf4(:,10),G0H2(39),ngH,m3h4x2(:,417),heltab2x8(:,:,687))
  call Hloop_A_Q(ntryL,G0H2(39),23,nML,G1H2(446),n2h2(529))
  call Hloop_SA_Q(ntryL,G0H8(70),wf4(:,10),G0H2(39),ngX,m3h4x2(:,418),heltab2x8(:,:,688))
  call Hloop_A_Q(ntryL,G0H2(39),23,nML,G1H2(449),n2h2(530))
  call Hloop_QA_S(ntryL,G1H8(113),wf4(:,10),G1H2(450),ngPln,m3h4x2(:,419),heltab2x8(:,:,689))
  call Hloop_VA_Q(ntryL,G0H8(71),wf4(:,10),G0H2(39),m3h4x2(:,420),heltab2x8(:,:,690))
  call Hloop_A_Q(ntryL,G0H2(39),23,nML,G1H2(451),n2h2(531))
  call Hloop_ZA_Q(ntryL,G0H8(72),wf4(:,10),G0H2(39),ngZl,m3h4x2(:,421),heltab2x8(:,:,691))
  call Hloop_A_Q(ntryL,G0H2(39),23,nML,G1H2(454),n2h2(532))
  call Hloop_QA_W(ntryL,G1H8(114),wf4(:,10),G1H2(455),m3h4x2(:,422),heltab2x8(:,:,692))
  call Hloop_QA_S(ntryL,G1H8(121),wf4(:,10),G1H2(456),ngPln,m3h4x2(:,423),heltab2x8(:,:,693))
  call Hloop_QA_W(ntryL,G1H8(122),wf4(:,10),G1H2(459),m3h4x2(:,424),heltab2x8(:,:,694))
  call Hloop_AS_Q(ntryL,G1H16(131),wf8(:,13),G1H2(460),ngH,m3h8x2(:,101),heltab2x16(:,:,859))
  call Hloop_A_Q(ntryL,G1H2(460),23,nME,G2H2(442),n2h2(533))
  call Hloop_AS_Q(ntryL,G1H16(132),wf8(:,13),G1H2(461),ngH,m3h8x2(:,102),heltab2x16(:,:,860))
  call Hloop_A_Q(ntryL,G1H2(461),23,nMM,G2H2(412),n2h2(534))
  call Hloop_AS_Q(ntryL,G1H16(133),wf8(:,13),G1H2(464),ngH,m3h8x2(:,103),heltab2x16(:,:,861))
  call Hloop_A_Q(ntryL,G1H2(464),23,nML,G2H2(491),n2h2(535))
  call Hloop_QS_A(ntryL,G1H16(134),wf8(:,13),G1H2(465),ngH,m3h8x2(:,104),heltab2x16(:,:,862))
  call Hloop_Q_A(ntryL,G1H2(465),23,nME,G2H2(443),n2h2(536))
  call Hloop_QS_A(ntryL,G1H16(135),wf8(:,13),G1H2(466),ngH,m3h8x2(:,105),heltab2x16(:,:,863))
  call Hloop_Q_A(ntryL,G1H2(466),23,nMM,G2H2(413),n2h2(537))
  call Hloop_QS_A(ntryL,G1H16(136),wf8(:,13),G1H2(469),ngH,m3h8x2(:,106),heltab2x16(:,:,864))
  call Hloop_Q_A(ntryL,G1H2(469),23,nML,G2H2(493),n2h2(538))
  call Hloop_AS_Q(ntryL,G1H16(137),wf8(:,13),G1H2(470),ngH,m3h8x2(:,107),heltab2x16(:,:,865))
  call Hloop_A_Q(ntryL,G1H2(470),23,nMT,G2H2(445),n2h2(539))
  call Hloop_QS_A(ntryL,G1H16(138),wf8(:,13),G1H2(471),ngH,m3h8x2(:,108),heltab2x16(:,:,866))
  call Hloop_Q_A(ntryL,G1H2(471),23,nMT,G2H2(415),n2h2(540))
  call Hloop_AS_Q(ntryL,G1H16(139),wf8(:,13),G1H2(474),ngH,m3h8x2(:,109),heltab2x16(:,:,867))
  call Hloop_A_Q(ntryL,G1H2(474),23,nMB,G2H2(494),n2h2(541))
  call Hloop_QS_A(ntryL,G1H16(140),wf8(:,13),G1H2(475),ngH,m3h8x2(:,110),heltab2x16(:,:,868))
  call Hloop_Q_A(ntryL,G1H2(475),23,nMB,G2H2(446),n2h2(542))
  call Hloop_AS_Q(ntryL,G1H16(141),wf8(:,47),G1H2(476),ngX,m3h8x2(:,111),heltab2x16(:,:,869))
  call Hloop_A_Q(ntryL,G1H2(476),23,nME,G2H2(416),n2h2(543))
  call Hloop_AS_Q(ntryL,G1H16(142),wf8(:,47),G1H2(479),ngX,m3h8x2(:,112),heltab2x16(:,:,870))
  call Hloop_A_Q(ntryL,G1H2(479),23,nMM,G2H2(496),n2h2(544))
  call Hloop_AS_Q(ntryL,G1H16(143),wf8(:,47),G1H2(480),ngX,m3h8x2(:,113),heltab2x16(:,:,871))
  call Hloop_A_Q(ntryL,G1H2(480),23,nML,G2H2(448),n2h2(545))
  call Hloop_QS_A(ntryL,G1H16(144),wf8(:,47),G1H2(481),ngX,m3h8x2(:,114),heltab2x16(:,:,872))
  call Hloop_Q_A(ntryL,G1H2(481),23,nME,G2H2(418),n2h2(546))
  call Hloop_QS_A(ntryL,G1H16(145),wf8(:,47),G1H2(484),ngX,m3h8x2(:,115),heltab2x16(:,:,873))
  call Hloop_Q_A(ntryL,G1H2(484),23,nMM,G2H2(451),n2h2(547))
  call Hloop_QS_A(ntryL,G1H16(146),wf8(:,47),G1H2(485),ngX,m3h8x2(:,116),heltab2x16(:,:,874))
  call Hloop_Q_A(ntryL,G1H2(485),23,nML,G2H2(457),n2h2(548))
  call Hloop_AS_Q(ntryL,G1H16(149),wf8(:,47),G1H2(486),ngX,m3h8x2(:,117),heltab2x16(:,:,875))
  call Hloop_A_Q(ntryL,G1H2(486),23,nMT,G2H2(515),n2h2(549))
  call Hloop_QS_A(ntryL,G1H16(150),wf8(:,47),G1H2(489),ngX,m3h8x2(:,118),heltab2x16(:,:,876))
  call Hloop_Q_A(ntryL,G1H2(489),23,nMT,G2H2(479),n2h2(550))
  call Hloop_AS_Q(ntryL,G1H16(153),wf8(:,47),G1H2(490),ngX,m3h8x2(:,119),heltab2x16(:,:,877))
  call Hloop_A_Q(ntryL,G1H2(490),23,nMB,G2H2(517),n2h2(551))
  call Hloop_QS_A(ntryL,G1H16(154),wf8(:,47),G1H2(491),ngX,m3h8x2(:,120),heltab2x16(:,:,878))
  call Hloop_Q_A(ntryL,G1H2(491),23,nMB,G2H2(481),n2h2(552))
  call Hloop_SS_S(ntryL,G1H16(155),wf8(:,13),G1H2(494),m3h8x2(:,121),heltab2x16(:,:,879))
  call Hloop_SS_S(ntryL,G1H16(156),wf8(:,13),G1H2(495),m3h8x2(:,122),heltab2x16(:,:,880))
  call Hloop_SS_S(ntryL,G1H16(159),wf8(:,13),G1H2(496),m3h8x2(:,123),heltab2x16(:,:,881))
  call Hloop_SS_S(ntryL,G1H16(160),wf8(:,13),G1H2(499),m3h8x2(:,124),heltab2x16(:,:,882))
  call Hloop_SS_S(ntryL,G1H16(164),wf8(:,47),G1H2(500),m3h8x2(:,125),heltab2x16(:,:,883))
  call Hloop_SS_S(ntryL,G1H16(165),wf8(:,47),G1H2(501),m3h8x2(:,126),heltab2x16(:,:,884))
  call Hloop_VS_V(ntryL,G1H16(166),wf8(:,13),G1H2(504),m3h8x2(:,127),heltab2x16(:,:,885))
  call Hloop_VS_V(ntryL,G1H16(167),wf8(:,13),G1H2(83),m3h8x2(:,128),heltab2x16(:,:,886))
  call Hloop_VT_S(ntryL,G0H16(163),16,wf8(:,13),7,G1H2(84),m3h8x2(:,129),heltab2x16(:,:,887))
  call Hloop_VT_S(ntryL,G0H16(164),16,wf8(:,13),7,G1H2(93),m3h8x2(:,130),heltab2x16(:,:,888))
  call Hloop_VT_S(ntryL,G0H16(165),16,wf8(:,47),7,G1H2(94),m3h8x2(:,131),heltab2x16(:,:,889))
  call Hloop_VT_S(ntryL,G0H16(166),16,wf8(:,47),7,G1H2(98),m3h8x2(:,132),heltab2x16(:,:,890))
  call Hloop_ST_V(ntryL,G1H16(169),16,wf8(:,13),7,G2H2(521),m3h8x2(:,133),heltab2x16(:,:,891))
  call Hloop_ST_V(ntryL,G1H16(172),16,wf8(:,47),7,G2H2(485),m3h8x2(:,134),heltab2x16(:,:,892))
  call Hloop_SS_S(ntryL,G0H16(168),wf8(:,13),G0H2(39),m3h8x2(:,135),heltab2x16(:,:,893))
  call Hloop_VS_V(ntryL,G0H16(170),wf8(:,13),G0H2(40),m3h8x2(:,136),heltab2x16(:,:,894))
  call Hloop_VT_S(ntryL,G1H16(174),16,wf8(:,13),7,G2H2(523),m3h8x2(:,137),heltab2x16(:,:,895))
  call Hloop_VT_S(ntryL,G1H16(176),16,wf8(:,47),7,G2H2(487),m3h8x2(:,138),heltab2x16(:,:,896))
  call Hloop_ST_V(ntryL,G0H16(171),16,wf8(:,13),7,G1H2(110),m3h8x2(:,139),heltab2x16(:,:,897))
  call Hloop_ST_V(ntryL,G0H16(172),16,wf8(:,13),7,G1H2(120),m3h8x2(:,140),heltab2x16(:,:,898))
  call Hloop_ST_V(ntryL,G0H16(173),16,wf8(:,47),7,G1H2(121),m3h8x2(:,141),heltab2x16(:,:,899))
  call Hloop_ST_V(ntryL,G0H16(174),16,wf8(:,47),7,G1H2(507),m3h8x2(:,142),heltab2x16(:,:,900))
  call Hloop_AV_Q(ntryL,G1H16(177),wf8(:,48),G1H2(131),m3h8x2(:,143),heltab2x16(:,:,901))
  call Hloop_A_Q(ntryL,G1H2(131),23,nME,G2H2(553),n2h2(553))
  call Hloop_AV_Q(ntryL,G1H16(178),wf8(:,48),G1H2(132),m3h8x2(:,144),heltab2x16(:,:,902))
  call Hloop_A_Q(ntryL,G1H2(132),23,nMM,G2H2(556),n2h2(554))
  call Hloop_AV_Q(ntryL,G1H16(179),wf8(:,48),G1H2(510),m3h8x2(:,145),heltab2x16(:,:,903))
  call Hloop_A_Q(ntryL,G1H2(510),23,nML,G2H2(548),n2h2(555))
  call Hloop_QV_A(ntryL,G1H16(180),wf8(:,48),G1H2(511),m3h8x2(:,146),heltab2x16(:,:,904))
  call Hloop_Q_A(ntryL,G1H2(511),23,nME,G2H2(452),n2h2(556))
  call Hloop_QV_A(ntryL,G1H16(181),wf8(:,48),G1H2(512),m3h8x2(:,147),heltab2x16(:,:,905))
  call Hloop_Q_A(ntryL,G1H2(512),23,nMM,G2H2(458),n2h2(557))
  call Hloop_QV_A(ntryL,G1H16(182),wf8(:,48),G1H2(515),m3h8x2(:,148),heltab2x16(:,:,906))
  call Hloop_Q_A(ntryL,G1H2(515),23,nML,G2H2(572),n2h2(558))
  call Hloop_AV_Q(ntryL,G1H16(188),wf8(:,48),G1H2(142),m3h8x2(:,149),heltab2x16(:,:,907))
  call Hloop_A_Q(ntryL,G1H2(142),23,0,G2H2(545),n2h2(559))
  call Hloop_AV_Q(ntryL,G1H16(184),wf8(:,48),G1H2(144),m3h8x2(:,150),heltab2x16(:,:,908))
  call Hloop_A_Q(ntryL,G1H2(144),23,nMT,G2H2(569),n2h2(560))
  call Hloop_QV_A(ntryL,G1H16(191),wf8(:,48),G1H2(518),m3h8x2(:,151),heltab2x16(:,:,909))
  call Hloop_Q_A(ntryL,G1H2(518),23,0,G2H2(42),n2h2(561))
  call Hloop_QV_A(ntryL,G1H16(186),wf8(:,48),G1H2(153),m3h8x2(:,152),heltab2x16(:,:,910))
  call Hloop_Q_A(ntryL,G1H2(153),23,nMT,G2H2(512),n2h2(562))
  call Hloop_AV_Q(ntryL,G1H16(190),wf8(:,48),G1H2(155),m3h8x2(:,153),heltab2x16(:,:,911))
  call Hloop_A_Q(ntryL,G1H2(155),23,nMB,G2H2(46),n2h2(563))
  call Hloop_QV_A(ntryL,G1H16(192),wf8(:,48),G1H2(519),m3h8x2(:,154),heltab2x16(:,:,912))
  call Hloop_Q_A(ntryL,G1H2(519),23,nMB,G2H2(50),n2h2(564))
  call Hloop_AZ_Q(ntryL,G1H16(193),wf8(:,49),G1H2(169),ngZl,m3h8x2(:,155),heltab2x16(:,:,913))
  call Hloop_A_Q(ntryL,G1H2(169),23,nME,G2H2(54),n2h2(565))
  call Hloop_AZ_Q(ntryL,G1H16(194),wf8(:,49),G1H2(171),ngZl,m3h8x2(:,156),heltab2x16(:,:,914))
  call Hloop_A_Q(ntryL,G1H2(171),23,nMM,G2H2(58),n2h2(566))
  call Hloop_AZ_Q(ntryL,G1H16(195),wf8(:,49),G1H2(520),ngZl,m3h8x2(:,157),heltab2x16(:,:,915))
  call Hloop_A_Q(ntryL,G1H2(520),23,nML,G2H2(177),n2h2(567))
  call Hloop_QZ_A(ntryL,G1H16(196),wf8(:,49),G1H2(185),ngZl,m3h8x2(:,158),heltab2x16(:,:,916))
  call Hloop_Q_A(ntryL,G1H2(185),23,nME,G2H2(62),n2h2(568))
  call Hloop_QZ_A(ntryL,G1H16(197),wf8(:,49),G1H2(186),ngZl,m3h8x2(:,159),heltab2x16(:,:,917))
  call Hloop_Q_A(ntryL,G1H2(186),23,nMM,G2H2(181),n2h2(569))
  call Hloop_QZ_A(ntryL,G1H16(198),wf8(:,49),G1H2(523),ngZl,m3h8x2(:,160),heltab2x16(:,:,918))
  call Hloop_Q_A(ntryL,G1H2(523),23,nML,G2H2(66),n2h2(570))
  call Hloop_AZ_Q(ntryL,G1H16(199),wf8(:,49),G1H2(196),ngZu,m3h8x2(:,161),heltab2x16(:,:,919))
  call Hloop_A_Q(ntryL,G1H2(196),23,0,G2H2(179),n2h2(571))
  call Hloop_AZ_Q(ntryL,G1H16(200),wf8(:,49),G1H2(197),ngZu,m3h8x2(:,162),heltab2x16(:,:,920))
  call Hloop_A_Q(ntryL,G1H2(197),23,nMT,G2H2(70),n2h2(572))
  call Hloop_QZ_A(ntryL,G1H16(201),wf8(:,49),G1H2(526),ngZu,m3h8x2(:,163),heltab2x16(:,:,921))
  call Hloop_Q_A(ntryL,G1H2(526),23,0,G2H2(180),n2h2(573))
  call Hloop_QZ_A(ntryL,G1H16(202),wf8(:,49),G1H2(207),ngZu,m3h8x2(:,164),heltab2x16(:,:,922))
  call Hloop_Q_A(ntryL,G1H2(207),23,nMT,G2H2(183),n2h2(574))
  call Hloop_AZ_Q(ntryL,G1H16(203),wf8(:,49),G1H2(208),ngZd,m3h8x2(:,165),heltab2x16(:,:,923))
  call Hloop_A_Q(ntryL,G1H2(208),23,0,G2H2(80),n2h2(575))
  call Hloop_AZ_Q(ntryL,G1H16(204),wf8(:,49),G1H2(529),ngZd,m3h8x2(:,166),heltab2x16(:,:,924))
  call Hloop_A_Q(ntryL,G1H2(529),23,nMB,G2H2(182),n2h2(576))
  call Hloop_QZ_A(ntryL,G1H16(205),wf8(:,49),G1H2(530),ngZd,m3h8x2(:,167),heltab2x16(:,:,925))
  call Hloop_Q_A(ntryL,G1H2(530),23,0,G2H2(184),n2h2(577))
  call Hloop_QZ_A(ntryL,G1H16(206),wf8(:,49),G1H2(531),ngZd,m3h8x2(:,168),heltab2x16(:,:,926))
  call Hloop_Q_A(ntryL,G1H2(531),23,nMB,G2H2(84),n2h2(578))
  call Hloop_SV_T(ntryL,G1H16(207),16,wf8(:,48),7,G2H2(503),m3h8x2(:,169),heltab2x16(:,:,927))
  call Hloop_TV_S(ntryL,G1H16(208),16,wf8(:,48),7,G2H2(88),m3h8x2(:,170),heltab2x16(:,:,928))
  call Hloop_SV_T(ntryL,G1H16(211),16,wf8(:,49),7,G2H2(92),m3h8x2(:,171),heltab2x16(:,:,929))
  call Hloop_TV_S(ntryL,G1H16(212),16,wf8(:,49),7,G2H2(96),m3h8x2(:,172),heltab2x16(:,:,930))
  call Hloop_DV_C(ntryL,G1H16(217),16,wf8(:,48),G2H2(100),m3h8x2(:,173),heltab2x16(:,:,931))
  call Hloop_CV_D(ntryL,G1H16(218),16,wf8(:,48),7,G2H2(193),m3h8x2(:,174),heltab2x16(:,:,932))
  call Hloop_DV_C(ntryL,G1H16(221),16,wf8(:,49),G2H2(104),m3h8x2(:,175),heltab2x16(:,:,933))
  call Hloop_CV_D(ntryL,G1H16(222),16,wf8(:,49),7,G2H2(197),m3h8x2(:,176),heltab2x16(:,:,934))
  call Hloop_UW_V(ntryL,G1H16(223),16,wf8(:,48),7,G2H2(108),m3h8x2(:,177),heltab2x16(:,:,935))
  call Hloop_UV_W(ntryL,G1H16(224),16,wf8(:,48),7,G2H2(195),m3h8x2(:,178),heltab2x16(:,:,936))
  call Hloop_UW_V(ntryL,G1H16(225),16,wf8(:,49),7,G2H2(112),m3h8x2(:,179),heltab2x16(:,:,937))
  call Hloop_UV_W(ntryL,G1H16(226),16,wf8(:,49),7,G2H2(196),m3h8x2(:,180),heltab2x16(:,:,938))
  call Hloop_VV_S(ntryL,G0H16(203),wf8(:,48),G0H2(41),m3h8x2(:,181),heltab2x16(:,:,939))
  call Hloop_VV_S(ntryL,G0H16(204),wf8(:,48),G0H2(42),m3h8x2(:,182),heltab2x16(:,:,940))
  call Hloop_VV_S(ntryL,G0H16(13),wf8(:,49),G0H2(43),m3h8x2(:,183),heltab2x16(:,:,941))
  call Hloop_VV_S(ntryL,G0H16(14),wf8(:,49),G0H2(44),m3h8x2(:,184),heltab2x16(:,:,942))
  call Hloop_SV_V(ntryL,G1H16(228),wf8(:,48),G1H2(534),m3h8x2(:,185),heltab2x16(:,:,943))
  call Hloop_SV_V(ntryL,G1H16(230),wf8(:,49),G1H2(218),m3h8x2(:,186),heltab2x16(:,:,944))
  call Hloop_SV_T(ntryL,G0H16(15),16,wf8(:,48),7,G1H2(220),m3h8x2(:,187),heltab2x16(:,:,945))
  call Hloop_TV_S(ntryL,G0H16(16),16,wf8(:,48),7,G1H2(537),m3h8x2(:,188),heltab2x16(:,:,946))
  call Hloop_SV_T(ntryL,G0H16(19),16,wf8(:,49),7,G1H2(229),m3h8x2(:,189),heltab2x16(:,:,947))
  call Hloop_TV_S(ntryL,G0H16(20),16,wf8(:,49),7,G1H2(231),m3h8x2(:,190),heltab2x16(:,:,948))
  call Hloop_UW_V(ntryL,G0H16(21),16,wf8(:,48),7,G1H2(538),m3h8x2(:,191),heltab2x16(:,:,949))
  call Hloop_UV_W(ntryL,G0H16(22),16,wf8(:,48),7,G1H2(245),m3h8x2(:,192),heltab2x16(:,:,950))
  call Hloop_UW_V(ntryL,G0H16(23),16,wf8(:,49),7,G1H2(247),m3h8x2(:,193),heltab2x16(:,:,951))
  call Hloop_UV_W(ntryL,G0H16(24),16,wf8(:,49),7,G1H2(539),m3h8x2(:,194),heltab2x16(:,:,952))
  call Hloop_VV_S(ntryL,G1H16(232),wf8(:,48),G1H2(540),m3h8x2(:,195),heltab2x16(:,:,953))
  call Hloop_VV_S(ntryL,G1H16(234),wf8(:,49),G1H2(541),m3h8x2(:,196),heltab2x16(:,:,954))
  call Hloop_SV_V(ntryL,G0H16(6),wf8(:,48),G0H2(45),m3h8x2(:,197),heltab2x16(:,:,955))
  call Hloop_SV_V(ntryL,G0H16(8),wf8(:,48),G0H2(46),m3h8x2(:,198),heltab2x16(:,:,956))
  call Hloop_SV_V(ntryL,G0H16(10),wf8(:,49),G0H2(47),m3h8x2(:,199),heltab2x16(:,:,957))
  call Hloop_SV_V(ntryL,G0H16(12),wf8(:,49),G0H2(48),m3h8x2(:,200),heltab2x16(:,:,958))
  call Hloop_AQ_S(ntryL,G1H16(235),ex1(:),G1H8(25),ngH,m3h2x8(:,389),heltab2x16(:,:,959))
  call Hloop_AQ_S(ntryL,G1H16(236),ex1(:),G1H8(26),ngX,m3h2x8(:,390),heltab2x16(:,:,960))
  call Hloop_SQ_A(ntryL,G1H16(237),ex1(:),G1H8(36),ngPnl,m3h2x8(:,391),heltab2x16(:,:,961))
  call Hloop_Q_A(ntryL,G1H8(36),17,0,G2H8(53),n2h8(297))
  call Hloop_AQ_V(ntryL,G1H16(238),ex1(:),G1H8(35),m3h2x8(:,392),heltab2x16(:,:,962))
  call Hloop_AQ_Z(ntryL,G1H16(239),ex1(:),G1H8(39),ngZl,m3h2x8(:,393),heltab2x16(:,:,963))
  call Hloop_SQ_A(ntryL,G0H16(53),ex1(:),G0H8(39),ngPnl,m3h2x8(:,394),heltab2x16(:,:,964))
  call Hloop_Q_A(ntryL,G0H8(39),17,0,G1H8(46),n2h8(298))
  call Hloop_WQ_A(ntryL,G0H16(54),ex1(:),G0H8(38),m3h2x8(:,395),heltab2x16(:,:,965))
  call Hloop_Q_A(ntryL,G0H8(38),17,0,G1H8(38),n2h8(299))
  call Hloop_WQ_A(ntryL,G1H16(240),ex1(:),G1H8(51),m3h2x8(:,396),heltab2x16(:,:,966))
  call Hloop_Q_A(ntryL,G1H8(51),17,0,G2H8(54),n2h8(300))
  call Hloop_SQ_A(ntryL,G0H4(121),ex1(:),G0H2(49),ngH,m3h2x2(:,575),heltab2x4(:,:,607))
  call Hloop_Q_A(ntryL,G0H2(49),23,nML,G1H2(544),n2h2(579))
  call Hloop_SQ_A(ntryL,G0H4(122),ex1(:),G0H2(49),ngX,m3h2x2(:,576),heltab2x4(:,:,608))
  call Hloop_Q_A(ntryL,G0H2(49),23,nML,G1H2(261),n2h2(580))
  call Hloop_AQ_S(ntryL,G1H4(269),ex1(:),G1H2(263),ngPnl,m3h2x2(:,577),heltab2x4(:,:,609))
  call Hloop_VQ_A(ntryL,G0H4(123),ex1(:),G0H2(49),m3h2x2(:,578),heltab2x4(:,:,610))
  call Hloop_Q_A(ntryL,G0H2(49),23,nML,G1H2(547),n2h2(581))
  call Hloop_ZQ_A(ntryL,G0H4(124),ex1(:),G0H2(49),ngZl,m3h2x2(:,579),heltab2x4(:,:,611))
  call Hloop_Q_A(ntryL,G0H2(49),23,nML,G1H2(272),n2h2(582))
  call Hloop_AQ_S(ntryL,G1H4(270),ex1(:),G1H2(274),ngPnl,m3h2x2(:,580),heltab2x4(:,:,612))
  call Hloop_AQ_W(ntryL,G1H4(271),ex1(:),G1H2(548),m3h2x2(:,581),heltab2x4(:,:,613))
  call Hloop_AQ_W(ntryL,G1H4(272),ex1(:),G1H2(288),m3h2x2(:,582),heltab2x4(:,:,614))
  call Hloop_AV_Q(ntryL,G1H8(123),ex3(:),G1H4(78),m3h2x4(:,271),heltab2x8(:,:,695))
  call Hloop_A_Q(ntryL,G1H4(78),22,nML,G2H4(97),n2h4(441))
  call Hloop_AV_Q(ntryL,G1H8(124),ex3(:),G1H4(140),m3h2x4(:,272),heltab2x8(:,:,696))
  call Hloop_A_Q(ntryL,G1H4(140),22,nML,G2H4(192),n2h4(442))
  call Hloop_SV_T(ntryL,G0H8(73),18,ex3(:),4,G1H4(248),m3h2x4(:,273),heltab2x8(:,:,697))
  call Hloop_AV_Q(ntryL,G1H8(125),ex3(:),G1H4(189),m3h2x4(:,274),heltab2x8(:,:,698))
  call Hloop_A_Q(ntryL,G1H4(189),22,nML,G2H4(156),n2h4(443))
  call Hloop_AV_Q(ntryL,G1H8(126),ex3(:),G1H4(201),m3h2x4(:,275),heltab2x8(:,:,699))
  call Hloop_A_Q(ntryL,G1H4(201),22,nML,G2H4(168),n2h4(444))
  call Hloop_VV_S(ntryL,G0H8(74),ex3(:),G0H4(118),m3h2x4(:,276),heltab2x8(:,:,700))
  call Hloop_SV_V(ntryL,G0H8(75),ex3(:),G0H4(80),m3h2x4(:,277),heltab2x8(:,:,701))
  call Hloop_UW_V(ntryL,G0H8(76),18,ex3(:),4,G1H4(5),m3h2x4(:,278),heltab2x8(:,:,702))
  call Hloop_QV_A(ntryL,G1H16(241),ex3(:),G1H8(60),m3h2x8(:,397),heltab2x16(:,:,967))
  call Hloop_Q_A(ntryL,G1H8(60),20,nME,G2H8(55),n2h8(301))
  call Hloop_QV_A(ntryL,G1H16(242),ex3(:),G1H8(8),m3h2x8(:,398),heltab2x16(:,:,968))
  call Hloop_Q_A(ntryL,G1H8(8),20,nMM,G2H8(56),n2h8(302))
  call Hloop_QV_A(ntryL,G1H16(243),ex3(:),G1H8(37),m3h2x8(:,399),heltab2x16(:,:,969))
  call Hloop_Q_A(ntryL,G1H8(37),20,nML,G2H8(57),n2h8(303))
  call Hloop_AV_Q(ntryL,G1H16(244),ex3(:),G1H8(40),m3h2x8(:,400),heltab2x16(:,:,970))
  call Hloop_A_Q(ntryL,G1H8(40),20,nME,G2H8(58),n2h8(304))
  call Hloop_AV_Q(ntryL,G1H16(245),ex3(:),G1H8(49),m3h2x8(:,401),heltab2x16(:,:,971))
  call Hloop_A_Q(ntryL,G1H8(49),20,nMM,G2H8(59),n2h8(305))
  call Hloop_AV_Q(ntryL,G1H16(246),ex3(:),G1H8(50),m3h2x8(:,402),heltab2x16(:,:,972))
  call Hloop_A_Q(ntryL,G1H8(50),20,nML,G2H8(60),n2h8(306))
  call Hloop_QV_A(ntryL,G1H16(247),ex3(:),G1H8(47),m3h2x8(:,403),heltab2x16(:,:,973))
  call Hloop_Q_A(ntryL,G1H8(47),20,nMT,G2H8(61),n2h8(307))
  call Hloop_AV_Q(ntryL,G1H16(248),ex3(:),G1H8(18),m3h2x8(:,404),heltab2x16(:,:,974))
  call Hloop_A_Q(ntryL,G1H8(18),20,nMT,G2H8(62),n2h8(308))
  call Hloop_QV_A(ntryL,G1H16(249),ex3(:),G1H8(22),m3h2x8(:,405),heltab2x16(:,:,975))
  call Hloop_Q_A(ntryL,G1H8(22),20,nMB,G2H8(63),n2h8(309))
  call Hloop_AV_Q(ntryL,G1H16(250),ex3(:),G1H8(7),m3h2x8(:,406),heltab2x16(:,:,976))
  call Hloop_A_Q(ntryL,G1H8(7),20,nMB,G2H8(64),n2h8(310))
  call Hloop_QV_A(ntryL,G1H16(251),ex3(:),G1H8(10),m3h2x8(:,407),heltab2x16(:,:,977))
  call Hloop_Q_A(ntryL,G1H8(10),20,nME,G2H8(65),n2h8(311))
  call Hloop_QV_A(ntryL,G1H16(252),ex3(:),G1H8(11),m3h2x8(:,408),heltab2x16(:,:,978))
  call Hloop_Q_A(ntryL,G1H8(11),20,nMM,G2H8(66),n2h8(312))
  call Hloop_QV_A(ntryL,G1H16(253),ex3(:),G1H8(2),m3h2x8(:,409),heltab2x16(:,:,979))
  call Hloop_Q_A(ntryL,G1H8(2),20,nML,G2H8(67),n2h8(313))
  call Hloop_AV_Q(ntryL,G1H16(254),ex3(:),G1H8(66),m3h2x8(:,410),heltab2x16(:,:,980))
  call Hloop_A_Q(ntryL,G1H8(66),20,nME,G2H8(68),n2h8(314))
  call Hloop_AV_Q(ntryL,G1H16(255),ex3(:),G1H8(68),m3h2x8(:,411),heltab2x16(:,:,981))
  call Hloop_A_Q(ntryL,G1H8(68),20,nMM,G2H8(69),n2h8(315))
  call Hloop_AV_Q(ntryL,G1H16(256),ex3(:),G1H8(69),m3h2x8(:,412),heltab2x16(:,:,982))
  call Hloop_A_Q(ntryL,G1H8(69),20,nML,G2H8(70),n2h8(316))
  call Hloop_QV_A(ntryL,G1H16(257),ex3(:),G1H8(70),m3h2x8(:,413),heltab2x16(:,:,983))
  call Hloop_Q_A(ntryL,G1H8(70),20,nMT,G2H8(71),n2h8(317))
  call Hloop_AV_Q(ntryL,G1H16(258),ex3(:),G1H8(71),m3h2x8(:,414),heltab2x16(:,:,984))
  call Hloop_A_Q(ntryL,G1H8(71),20,nMT,G2H8(72),n2h8(318))
  call Hloop_QV_A(ntryL,G1H16(259),ex3(:),G1H8(73),m3h2x8(:,415),heltab2x16(:,:,985))
  call Hloop_Q_A(ntryL,G1H8(73),20,nMB,G2H8(73),n2h8(319))
  call Hloop_AV_Q(ntryL,G1H16(260),ex3(:),G1H8(74),m3h2x8(:,416),heltab2x16(:,:,986))
  call Hloop_A_Q(ntryL,G1H8(74),20,nMB,G2H8(74),n2h8(320))
  call Hloop_TV_S(ntryL,G1H16(261),16,ex3(:),4,G2H8(75),m3h2x8(:,417),heltab2x16(:,:,987))
  call Hloop_SV_T(ntryL,G1H16(262),16,ex3(:),4,G2H8(76),m3h2x8(:,418),heltab2x16(:,:,988))
  call Hloop_CV_D(ntryL,G1H16(265),16,ex3(:),4,G2H8(77),m3h2x8(:,419),heltab2x16(:,:,989))
  call Hloop_DV_C(ntryL,G1H16(266),16,ex3(:),G2H8(78),m3h2x8(:,420),heltab2x16(:,:,990))
  call Hloop_CV_D(ntryL,G1H16(273),16,ex3(:),4,G2H8(80),m3h2x8(:,421),heltab2x16(:,:,991))
  call Hloop_DV_C(ntryL,G1H16(274),16,ex3(:),G2H8(82),m3h2x8(:,422),heltab2x16(:,:,992))
  call Hloop_UV_W(ntryL,G1H16(275),16,ex3(:),4,G2H8(84),m3h2x8(:,423),heltab2x16(:,:,993))
  call Hloop_UW_V(ntryL,G1H16(276),16,ex3(:),4,G2H8(86),m3h2x8(:,424),heltab2x16(:,:,994))
  call Hloop_TV_S(ntryL,G0H16(91),16,ex3(:),4,G1H8(96),m3h2x8(:,425),heltab2x16(:,:,995))
  call Hloop_SV_T(ntryL,G0H16(92),16,ex3(:),4,G1H8(98),m3h2x8(:,426),heltab2x16(:,:,996))
  call Hloop_TV_S(ntryL,G0H16(93),16,ex3(:),4,G1H8(97),m3h2x8(:,427),heltab2x16(:,:,997))
  call Hloop_SV_T(ntryL,G0H16(94),16,ex3(:),4,G1H8(104),m3h2x8(:,428),heltab2x16(:,:,998))
  call Hloop_SV_V(ntryL,G1H16(278),ex3(:),G1H8(106),m3h2x8(:,429),heltab2x16(:,:,999))
  call Hloop_SV_V(ntryL,G1H16(280),ex3(:),G1H8(103),m3h2x8(:,430),heltab2x16(:,:,1000))
  call Hloop_VV_S(ntryL,G0H16(96),ex3(:),G0H8(40),m3h2x8(:,431),heltab2x16(:,:,1001))
  call Hloop_SV_V(ntryL,G0H16(100),ex3(:),G0H8(42),m3h2x8(:,432),heltab2x16(:,:,1002))
  call Hloop_VV_S(ntryL,G1H16(282),ex3(:),G1H8(107),m3h2x8(:,433),heltab2x16(:,:,1003))
  call Hloop_VV_S(ntryL,G1H16(284),ex3(:),G1H8(108),m3h2x8(:,434),heltab2x16(:,:,1004))
  call Hloop_UV_W(ntryL,G0H16(102),16,ex3(:),4,G1H8(116),m3h2x8(:,435),heltab2x16(:,:,1005))
  call Hloop_UW_V(ntryL,G0H16(104),16,ex3(:),4,G1H8(118),m3h2x8(:,436),heltab2x16(:,:,1006))
  call Hloop_UV_W(ntryL,G0H16(105),16,ex3(:),4,G1H8(117),m3h2x8(:,437),heltab2x16(:,:,1007))
  call Hloop_UW_V(ntryL,G0H16(106),16,ex3(:),4,G1H8(119),m3h2x8(:,438),heltab2x16(:,:,1008))
  call Hloop_QV_A(ntryL,G1H16(286),ex3(:),G1H8(120),m3h2x8(:,439),heltab2x16(:,:,1009))
  call Hloop_Q_A(ntryL,G1H8(120),20,nME,G2H8(87),n2h8(321))
  call Hloop_QV_A(ntryL,G1H16(288),ex3(:),G1H8(128),m3h2x8(:,440),heltab2x16(:,:,1010))
  call Hloop_Q_A(ntryL,G1H8(128),20,nMM,G2H8(88),n2h8(322))
  call Hloop_QV_A(ntryL,G1H16(289),ex3(:),G1H8(127),m3h2x8(:,441),heltab2x16(:,:,1011))
  call Hloop_Q_A(ntryL,G1H8(127),20,nML,G2H8(89),n2h8(323))
  call Hloop_AV_Q(ntryL,G1H16(290),ex3(:),G1H8(129),m3h2x8(:,442),heltab2x16(:,:,1012))
  call Hloop_A_Q(ntryL,G1H8(129),20,nME,G2H8(90),n2h8(324))
  call Hloop_AV_Q(ntryL,G1H16(291),ex3(:),G1H8(132),m3h2x8(:,443),heltab2x16(:,:,1013))
  call Hloop_A_Q(ntryL,G1H8(132),20,nMM,G2H8(91),n2h8(325))
  call Hloop_AV_Q(ntryL,G1H16(292),ex3(:),G1H8(133),m3h2x8(:,444),heltab2x16(:,:,1014))
  call Hloop_A_Q(ntryL,G1H8(133),20,nML,G2H8(92),n2h8(326))
  call Hloop_QV_A(ntryL,G1H16(297),ex3(:),G1H8(135),m3h2x8(:,445),heltab2x16(:,:,1015))
  call Hloop_Q_A(ntryL,G1H8(135),20,0,G2H8(93),n2h8(327))
  call Hloop_QV_A(ntryL,G1H16(294),ex3(:),G1H8(136),m3h2x8(:,446),heltab2x16(:,:,1016))
  call Hloop_Q_A(ntryL,G1H8(136),20,nMT,G2H8(94),n2h8(328))
  call Hloop_AV_Q(ntryL,G1H16(299),ex3(:),G1H8(137),m3h2x8(:,447),heltab2x16(:,:,1017))
  call Hloop_A_Q(ntryL,G1H8(137),20,0,G2H8(95),n2h8(329))
  call Hloop_AV_Q(ntryL,G1H16(296),ex3(:),G1H8(138),m3h2x8(:,448),heltab2x16(:,:,1018))
  call Hloop_A_Q(ntryL,G1H8(138),20,nMT,G2H8(96),n2h8(330))
  call Hloop_QV_A(ntryL,G1H16(298),ex3(:),G1H8(140),m3h2x8(:,449),heltab2x16(:,:,1019))
  call Hloop_Q_A(ntryL,G1H8(140),20,nMB,G2H8(97),n2h8(331))
  call Hloop_AV_Q(ntryL,G1H16(300),ex3(:),G1H8(141),m3h2x8(:,450),heltab2x16(:,:,1020))
  call Hloop_A_Q(ntryL,G1H8(141),20,nMB,G2H8(98),n2h8(332))
  call Hloop_QV_A(ntryL,G1H16(301),ex3(:),G1H8(142),m3h2x8(:,451),heltab2x16(:,:,1021))
  call Hloop_Q_A(ntryL,G1H8(142),20,nME,G2H8(99),n2h8(333))
  call Hloop_QV_A(ntryL,G1H16(302),ex3(:),G1H8(143),m3h2x8(:,452),heltab2x16(:,:,1022))
  call Hloop_Q_A(ntryL,G1H8(143),20,nMM,G2H8(100),n2h8(334))
  call Hloop_QV_A(ntryL,G1H16(307),ex3(:),G1H8(145),m3h2x8(:,453),heltab2x16(:,:,1023))
  call Hloop_Q_A(ntryL,G1H8(145),20,nML,G2H8(101),n2h8(335))
  call Hloop_AV_Q(ntryL,G1H16(304),ex3(:),G1H8(146),m3h2x8(:,454),heltab2x16(:,:,1024))
  call Hloop_A_Q(ntryL,G1H8(146),20,nME,G2H8(102),n2h8(336))
  call Hloop_AV_Q(ntryL,G1H16(309),ex3(:),G1H8(147),m3h2x8(:,455),heltab2x16(:,:,1025))
  call Hloop_A_Q(ntryL,G1H8(147),20,nMM,G2H8(103),n2h8(337))
  call Hloop_AV_Q(ntryL,G1H16(306),ex3(:),G1H8(148),m3h2x8(:,456),heltab2x16(:,:,1026))
  call Hloop_A_Q(ntryL,G1H8(148),20,nML,G2H8(104),n2h8(338))
  call Hloop_QV_A(ntryL,G1H16(308),ex3(:),G1H8(150),m3h2x8(:,457),heltab2x16(:,:,1027))
  call Hloop_Q_A(ntryL,G1H8(150),20,0,G2H8(105),n2h8(339))
  call Hloop_QV_A(ntryL,G1H16(310),ex3(:),G1H8(151),m3h2x8(:,458),heltab2x16(:,:,1028))
  call Hloop_Q_A(ntryL,G1H8(151),20,nMT,G2H8(106),n2h8(340))
  call Hloop_AV_Q(ntryL,G1H16(311),ex3(:),G1H8(152),m3h2x8(:,459),heltab2x16(:,:,1029))
  call Hloop_A_Q(ntryL,G1H8(152),20,0,G2H8(107),n2h8(341))
  call Hloop_AV_Q(ntryL,G1H16(312),ex3(:),G1H8(153),m3h2x8(:,460),heltab2x16(:,:,1030))
  call Hloop_A_Q(ntryL,G1H8(153),20,nMT,G2H8(108),n2h8(342))
  call Hloop_QV_A(ntryL,G1H16(313),ex3(:),G1H8(155),m3h2x8(:,461),heltab2x16(:,:,1031))
  call Hloop_Q_A(ntryL,G1H8(155),20,0,G2H8(109),n2h8(343))
  call Hloop_QV_A(ntryL,G1H16(314),ex3(:),G1H8(156),m3h2x8(:,462),heltab2x16(:,:,1032))
  call Hloop_Q_A(ntryL,G1H8(156),20,nMB,G2H8(110),n2h8(344))
  call Hloop_AV_Q(ntryL,G1H16(315),ex3(:),G1H8(48),m3h2x8(:,463),heltab2x16(:,:,1033))
  call Hloop_A_Q(ntryL,G1H8(48),20,0,G2H8(111),n2h8(345))
  call Hloop_AV_Q(ntryL,G1H16(316),ex3(:),G1H8(52),m3h2x8(:,464),heltab2x16(:,:,1034))
  call Hloop_A_Q(ntryL,G1H8(52),20,nMB,G2H8(112),n2h8(346))
  call Hloop_TV_S(ntryL,G1H16(317),16,ex3(:),4,G2H8(113),m3h2x8(:,465),heltab2x16(:,:,1035))
  call Hloop_SV_T(ntryL,G1H16(318),16,ex3(:),4,G2H8(114),m3h2x8(:,466),heltab2x16(:,:,1036))
  call Hloop_TV_S(ntryL,G1H16(319),16,ex3(:),4,G2H8(33),m3h2x8(:,467),heltab2x16(:,:,1037))
  call Hloop_SV_T(ntryL,G1H16(320),16,ex3(:),4,G2H8(34),m3h2x8(:,468),heltab2x16(:,:,1038))
  call Hloop_CV_D(ntryL,G1H16(323),16,ex3(:),4,G2H8(38),m3h2x8(:,469),heltab2x16(:,:,1039))
  call Hloop_DV_C(ntryL,G1H16(324),16,ex3(:),G2H8(36),m3h2x8(:,470),heltab2x16(:,:,1040))
  call Hloop_CV_D(ntryL,G1H16(327),16,ex3(:),4,G2H8(79),m3h2x8(:,471),heltab2x16(:,:,1041))
  call Hloop_DV_C(ntryL,G1H16(328),16,ex3(:),G2H8(81),m3h2x8(:,472),heltab2x16(:,:,1042))
  call Hloop_UV_W(ntryL,G1H16(331),16,ex3(:),4,G2H8(83),m3h2x8(:,473),heltab2x16(:,:,1043))
  call Hloop_UW_V(ntryL,G1H16(332),16,ex3(:),4,G2H8(85),m3h2x8(:,474),heltab2x16(:,:,1044))
  call Hloop_UV_W(ntryL,G1H16(335),16,ex3(:),4,G2H8(1),m3h2x8(:,475),heltab2x16(:,:,1045))
  call Hloop_UW_V(ntryL,G1H16(336),16,ex3(:),4,G2H8(2),m3h2x8(:,476),heltab2x16(:,:,1046))
  call Hloop_TV_S(ntryL,G0H16(175),16,ex3(:),4,G1H8(57),m3h2x8(:,477),heltab2x16(:,:,1047))
  call Hloop_SV_T(ntryL,G0H16(176),16,ex3(:),4,G1H8(61),m3h2x8(:,478),heltab2x16(:,:,1048))
  call Hloop_TV_S(ntryL,G0H16(177),16,ex3(:),4,G1H8(62),m3h2x8(:,479),heltab2x16(:,:,1049))
  call Hloop_SV_T(ntryL,G0H16(178),16,ex3(:),4,G1H8(59),m3h2x8(:,480),heltab2x16(:,:,1050))
  call Hloop_SV_V(ntryL,G1H16(338),ex3(:),G1H8(63),m3h2x8(:,481),heltab2x16(:,:,1051))
  call Hloop_SV_V(ntryL,G1H16(340),ex3(:),G1H8(5),m3h2x8(:,482),heltab2x16(:,:,1052))
  call Hloop_VV_S(ntryL,G0H16(179),ex3(:),G0H8(43),m3h2x8(:,483),heltab2x16(:,:,1053))
  call Hloop_VV_S(ntryL,G0H16(180),ex3(:),G0H8(44),m3h2x8(:,484),heltab2x16(:,:,1054))
  call Hloop_VV_S(ntryL,G0H16(181),ex3(:),G0H8(45),m3h2x8(:,485),heltab2x16(:,:,1055))
  call Hloop_VV_S(ntryL,G0H16(182),ex3(:),G0H8(46),m3h2x8(:,486),heltab2x16(:,:,1056))
  call Hloop_SV_V(ntryL,G0H16(183),ex3(:),G0H8(47),m3h2x8(:,487),heltab2x16(:,:,1057))
  call Hloop_SV_V(ntryL,G0H16(184),ex3(:),G0H8(48),m3h2x8(:,488),heltab2x16(:,:,1058))
  call Hloop_SV_V(ntryL,G0H16(185),ex3(:),G0H8(61),m3h2x8(:,489),heltab2x16(:,:,1059))
  call Hloop_SV_V(ntryL,G0H16(186),ex3(:),G0H8(62),m3h2x8(:,490),heltab2x16(:,:,1060))
  call Hloop_VV_S(ntryL,G1H16(342),ex3(:),G1H8(157),m3h2x8(:,491),heltab2x16(:,:,1061))
  call Hloop_VV_S(ntryL,G1H16(344),ex3(:),G1H8(158),m3h2x8(:,492),heltab2x16(:,:,1062))
  call Hloop_UV_W(ntryL,G0H16(187),16,ex3(:),4,G1H8(160),m3h2x8(:,493),heltab2x16(:,:,1063))
  call Hloop_UW_V(ntryL,G0H16(188),16,ex3(:),4,G1H8(161),m3h2x8(:,494),heltab2x16(:,:,1064))
  call Hloop_UV_W(ntryL,G0H16(189),16,ex3(:),4,G1H8(162),m3h2x8(:,495),heltab2x16(:,:,1065))
  call Hloop_UW_V(ntryL,G0H16(190),16,ex3(:),4,G1H8(163),m3h2x8(:,496),heltab2x16(:,:,1066))
  call Hloop_QA_S(ntryL,G1H16(345),ex2(:),G1H8(165),ngH,m3h2x8(:,497),heltab2x16(:,:,1067))
  call Hloop_QA_S(ntryL,G1H16(346),ex2(:),G1H8(166),ngX,m3h2x8(:,498),heltab2x16(:,:,1068))
  call Hloop_SA_Q(ntryL,G1H16(347),ex2(:),G1H8(167),ngPln,m3h2x8(:,499),heltab2x16(:,:,1069))
  call Hloop_A_Q(ntryL,G1H8(167),18,0,G2H8(3),n2h8(347))
  call Hloop_QA_V(ntryL,G1H16(348),ex2(:),G1H8(168),m3h2x8(:,500),heltab2x16(:,:,1070))
  call Hloop_QA_Z(ntryL,G1H16(349),ex2(:),G1H8(170),ngZl,m3h2x8(:,501),heltab2x16(:,:,1071))
  call Hloop_SA_Q(ntryL,G0H16(195),ex2(:),G0H8(63),ngPln,m3h2x8(:,502),heltab2x16(:,:,1072))
  call Hloop_A_Q(ntryL,G0H8(63),18,0,G1H8(171),n2h8(348))
  call Hloop_WA_Q(ntryL,G0H16(196),ex2(:),G0H8(64),m3h2x8(:,503),heltab2x16(:,:,1073))
  call Hloop_A_Q(ntryL,G0H8(64),18,0,G1H8(172),n2h8(349))
  call Hloop_WA_Q(ntryL,G1H16(350),ex2(:),G1H8(173),m3h2x8(:,504),heltab2x16(:,:,1074))
  call Hloop_A_Q(ntryL,G1H8(173),18,0,G2H8(4),n2h8(350))
  call Hloop_SA_Q(ntryL,G0H4(85),ex2(:),G0H2(49),ngH,m3h2x2(:,583),heltab2x4(:,:,615))
  call Hloop_A_Q(ntryL,G0H2(49),27,nML,G1H2(290),n2h2(583))
  call Hloop_SA_Q(ntryL,G0H4(86),ex2(:),G0H2(49),ngX,m3h2x2(:,584),heltab2x4(:,:,616))
  call Hloop_A_Q(ntryL,G0H2(49),27,nML,G1H2(549),n2h2(584))
  call Hloop_QA_S(ntryL,G1H4(1),ex2(:),G1H2(550),ngPln,m3h2x2(:,585),heltab2x4(:,:,617))
  call Hloop_VA_Q(ntryL,G0H4(87),ex2(:),G0H2(49),m3h2x2(:,586),heltab2x4(:,:,618))
  call Hloop_A_Q(ntryL,G0H2(49),27,nML,G1H2(551),n2h2(585))
  call Hloop_ZA_Q(ntryL,G0H4(88),ex2(:),G0H2(49),ngZl,m3h2x2(:,587),heltab2x4(:,:,619))
  call Hloop_A_Q(ntryL,G0H2(49),27,nML,G1H2(554),n2h2(586))
  call Hloop_QA_S(ntryL,G1H4(2),ex2(:),G1H2(304),ngPln,m3h2x2(:,588),heltab2x4(:,:,620))
  call Hloop_QA_W(ntryL,G1H4(3),ex2(:),G1H2(306),m3h2x2(:,589),heltab2x4(:,:,621))
  call Hloop_QA_W(ntryL,G1H4(7),ex2(:),G1H2(557),m3h2x2(:,590),heltab2x4(:,:,622))
  call Hloop_QV_A(ntryL,G1H8(131),ex3(:),G1H4(226),m3h2x4(:,279),heltab2x8(:,:,703))
  call Hloop_Q_A(ntryL,G1H4(226),21,nML,G2H4(130),n2h4(445))
  call Hloop_QV_A(ntryL,G1H8(12),ex3(:),G1H4(72),m3h2x4(:,280),heltab2x8(:,:,704))
  call Hloop_Q_A(ntryL,G1H4(72),21,nML,G2H4(134),n2h4(446))
  call Hloop_TV_S(ntryL,G0H8(77),17,ex3(:),4,G1H4(193),m3h2x4(:,281),heltab2x8(:,:,705))
  call Hloop_QV_A(ntryL,G1H8(24),ex3(:),G1H4(125),m3h2x4(:,282),heltab2x8(:,:,706))
  call Hloop_Q_A(ntryL,G1H4(125),21,nML,G2H4(176),n2h4(447))
  call Hloop_QV_A(ntryL,G1H8(27),ex3(:),G1H4(98),m3h2x4(:,283),heltab2x8(:,:,707))
  call Hloop_Q_A(ntryL,G1H4(98),21,nML,G2H4(81),n2h4(448))
  call Hloop_SV_V(ntryL,G0H8(78),ex3(:),G0H4(78),m3h2x4(:,284),heltab2x8(:,:,708))
  call Hloop_VV_S(ntryL,G0H8(79),ex3(:),G0H4(7),m3h2x4(:,285),heltab2x8(:,:,709))
  call Hloop_UV_W(ntryL,G0H8(80),17,ex3(:),4,G1H4(180),m3h2x4(:,286),heltab2x8(:,:,710))
  call Hloop_QV_A(ntryL,G1H16(351),ex3(:),G1H8(175),m3h2x8(:,505),heltab2x16(:,:,1075))
  call Hloop_Q_A(ntryL,G1H8(175),20,nME,G2H8(5),n2h8(351))
  call Hloop_QV_A(ntryL,G1H16(352),ex3(:),G1H8(176),m3h2x8(:,506),heltab2x16(:,:,1076))
  call Hloop_Q_A(ntryL,G1H8(176),20,nMM,G2H8(6),n2h8(352))
  call Hloop_QV_A(ntryL,G1H16(353),ex3(:),G1H8(177),m3h2x8(:,507),heltab2x16(:,:,1077))
  call Hloop_Q_A(ntryL,G1H8(177),20,nML,G2H8(7),n2h8(353))
  call Hloop_AV_Q(ntryL,G1H16(354),ex3(:),G1H8(178),m3h2x8(:,508),heltab2x16(:,:,1078))
  call Hloop_A_Q(ntryL,G1H8(178),20,nME,G2H8(8),n2h8(354))
  call Hloop_AV_Q(ntryL,G1H16(355),ex3(:),G1H8(180),m3h2x8(:,509),heltab2x16(:,:,1079))
  call Hloop_A_Q(ntryL,G1H8(180),20,nMM,G2H8(9),n2h8(355))
  call Hloop_AV_Q(ntryL,G1H16(356),ex3(:),G1H8(181),m3h2x8(:,510),heltab2x16(:,:,1080))
  call Hloop_A_Q(ntryL,G1H8(181),20,nML,G2H8(12),n2h8(356))
  call Hloop_QV_A(ntryL,G1H16(357),ex3(:),G1H8(182),m3h2x8(:,511),heltab2x16(:,:,1081))
  call Hloop_Q_A(ntryL,G1H8(182),20,nMT,G2H8(10),n2h8(357))
  call Hloop_AV_Q(ntryL,G1H16(358),ex3(:),G1H8(183),m3h2x8(:,512),heltab2x16(:,:,1082))
  call Hloop_A_Q(ntryL,G1H8(183),20,nMT,G2H8(11),n2h8(358))
  call Hloop_QV_A(ntryL,G1H16(359),ex3(:),G1H8(185),m3h2x8(:,513),heltab2x16(:,:,1083))
  call Hloop_Q_A(ntryL,G1H8(185),20,nMB,G2H8(14),n2h8(359))
  call Hloop_AV_Q(ntryL,G1H16(360),ex3(:),G1H8(186),m3h2x8(:,514),heltab2x16(:,:,1084))
  call Hloop_A_Q(ntryL,G1H8(186),20,nMB,G2H8(15),n2h8(360))
  call Hloop_QV_A(ntryL,G1H16(361),ex3(:),G1H8(187),m3h2x8(:,515),heltab2x16(:,:,1085))
  call Hloop_Q_A(ntryL,G1H8(187),20,nME,G2H8(13),n2h8(361))
  call Hloop_QV_A(ntryL,G1H16(362),ex3(:),G1H8(188),m3h2x8(:,516),heltab2x16(:,:,1086))
  call Hloop_Q_A(ntryL,G1H8(188),20,nMM,G2H8(16),n2h8(362))
  call Hloop_QV_A(ntryL,G1H16(363),ex3(:),G1H8(190),m3h2x8(:,517),heltab2x16(:,:,1087))
  call Hloop_Q_A(ntryL,G1H8(190),20,nML,G2H8(17),n2h8(363))
  call Hloop_AV_Q(ntryL,G1H16(364),ex3(:),G1H8(191),m3h2x8(:,518),heltab2x16(:,:,1088))
  call Hloop_A_Q(ntryL,G1H8(191),20,nME,G2H8(18),n2h8(364))
  call Hloop_AV_Q(ntryL,G1H16(365),ex3(:),G1H8(192),m3h2x8(:,519),heltab2x16(:,:,1089))
  call Hloop_A_Q(ntryL,G1H8(192),20,nMM,G2H8(19),n2h8(365))
  call Hloop_AV_Q(ntryL,G1H16(366),ex3(:),G1H8(193),m3h2x8(:,520),heltab2x16(:,:,1090))
  call Hloop_A_Q(ntryL,G1H8(193),20,nML,G2H8(20),n2h8(366))
  call Hloop_QV_A(ntryL,G1H16(367),ex3(:),G1H8(195),m3h2x8(:,521),heltab2x16(:,:,1091))
  call Hloop_Q_A(ntryL,G1H8(195),20,nMT,G2H8(21),n2h8(367))
  call Hloop_AV_Q(ntryL,G1H16(368),ex3(:),G1H8(196),m3h2x8(:,522),heltab2x16(:,:,1092))
  call Hloop_A_Q(ntryL,G1H8(196),20,nMT,G2H8(22),n2h8(368))
  call Hloop_QV_A(ntryL,G1H16(369),ex3(:),G1H8(197),m3h2x8(:,523),heltab2x16(:,:,1093))
  call Hloop_Q_A(ntryL,G1H8(197),20,nMB,G2H8(23),n2h8(369))
  call Hloop_AV_Q(ntryL,G1H16(370),ex3(:),G1H8(198),m3h2x8(:,524),heltab2x16(:,:,1094))
  call Hloop_A_Q(ntryL,G1H8(198),20,nMB,G2H8(24),n2h8(370))
  call Hloop_TV_S(ntryL,G1H16(371),16,ex3(:),4,G2H8(25),m3h2x8(:,525),heltab2x16(:,:,1095))
  call Hloop_SV_T(ntryL,G1H16(372),16,ex3(:),4,G2H8(28),m3h2x8(:,526),heltab2x16(:,:,1096))
  call Hloop_CV_D(ntryL,G1H16(375),16,ex3(:),4,G2H8(26),m3h2x8(:,527),heltab2x16(:,:,1097))
  call Hloop_DV_C(ntryL,G1H16(376),16,ex3(:),G2H8(27),m3h2x8(:,528),heltab2x16(:,:,1098))
  call Hloop_CV_D(ntryL,G1H16(379),16,ex3(:),4,G2H8(30),m3h2x8(:,529),heltab2x16(:,:,1099))
  call Hloop_DV_C(ntryL,G1H16(380),16,ex3(:),G2H8(31),m3h2x8(:,530),heltab2x16(:,:,1100))
  call Hloop_UV_W(ntryL,G1H16(381),16,ex3(:),4,G2H8(29),m3h2x8(:,531),heltab2x16(:,:,1101))
  call Hloop_UW_V(ntryL,G1H16(382),16,ex3(:),4,G2H8(32),m3h2x8(:,532),heltab2x16(:,:,1102))
  call Hloop_TV_S(ntryL,G0H16(81),16,ex3(:),4,G1H8(200),m3h2x8(:,533),heltab2x16(:,:,1103))
  call Hloop_SV_T(ntryL,G0H16(82),16,ex3(:),4,G1H8(201),m3h2x8(:,534),heltab2x16(:,:,1104))
  call Hloop_TV_S(ntryL,G0H16(83),16,ex3(:),4,G1H8(202),m3h2x8(:,535),heltab2x16(:,:,1105))
  call Hloop_SV_T(ntryL,G0H16(84),16,ex3(:),4,G1H8(203),m3h2x8(:,536),heltab2x16(:,:,1106))
  call Hloop_SV_V(ntryL,G1H16(384),ex3(:),G1H8(205),m3h2x8(:,537),heltab2x16(:,:,1107))
  call Hloop_SV_V(ntryL,G1H16(386),ex3(:),G1H8(206),m3h2x8(:,538),heltab2x16(:,:,1108))
  call Hloop_VV_S(ntryL,G0H16(86),ex3(:),G0H8(20),m3h2x8(:,539),heltab2x16(:,:,1109))
  call Hloop_SV_V(ntryL,G0H16(88),ex3(:),G0H8(22),m3h2x8(:,540),heltab2x16(:,:,1110))
  call Hloop_VV_S(ntryL,G1H16(388),ex3(:),G1H8(207),m3h2x8(:,541),heltab2x16(:,:,1111))
  call Hloop_VV_S(ntryL,G1H16(390),ex3(:),G1H8(208),m3h2x8(:,542),heltab2x16(:,:,1112))
  call Hloop_UV_W(ntryL,G0H16(89),16,ex3(:),4,G1H8(210),m3h2x8(:,543),heltab2x16(:,:,1113))
  call Hloop_UW_V(ntryL,G0H16(90),16,ex3(:),4,G1H8(211),m3h2x8(:,544),heltab2x16(:,:,1114))
  call Hloop_UV_W(ntryL,G0H16(123),16,ex3(:),4,G1H8(212),m3h2x8(:,545),heltab2x16(:,:,1115))
  call Hloop_UW_V(ntryL,G0H16(124),16,ex3(:),4,G1H8(213),m3h2x8(:,546),heltab2x16(:,:,1116))
  call Hloop_QV_A(ntryL,G1H16(391),ex3(:),G1H8(215),m3h2x8(:,547),heltab2x16(:,:,1117))
  call Hloop_Q_A(ntryL,G1H8(215),20,nME,G2H8(37),n2h8(371))
  call Hloop_QV_A(ntryL,G1H16(392),ex3(:),G1H8(216),m3h2x8(:,548),heltab2x16(:,:,1118))
  call Hloop_Q_A(ntryL,G1H8(216),20,nMM,G2H8(35),n2h8(372))
  call Hloop_QV_A(ntryL,G1H16(393),ex3(:),G1H8(217),m3h2x8(:,549),heltab2x16(:,:,1119))
  call Hloop_Q_A(ntryL,G1H8(217),20,nML,G2H8(39),n2h8(373))
  call Hloop_AV_Q(ntryL,G1H16(394),ex3(:),G1H8(218),m3h2x8(:,550),heltab2x16(:,:,1120))
  call Hloop_A_Q(ntryL,G1H8(218),20,nME,G2H8(40),n2h8(374))
  call Hloop_AV_Q(ntryL,G1H16(395),ex3(:),G1H8(220),m3h2x8(:,551),heltab2x16(:,:,1121))
  call Hloop_A_Q(ntryL,G1H8(220),20,nMM,G2H8(41),n2h8(375))
  call Hloop_AV_Q(ntryL,G1H16(396),ex3(:),G1H8(221),m3h2x8(:,552),heltab2x16(:,:,1122))
  call Hloop_A_Q(ntryL,G1H8(221),20,nML,G2H8(45),n2h8(376))
  call Hloop_QV_A(ntryL,G1H16(401),ex3(:),G1H8(222),m3h2x8(:,553),heltab2x16(:,:,1123))
  call Hloop_Q_A(ntryL,G1H8(222),20,0,G2H8(115),n2h8(377))
  call Hloop_QV_A(ntryL,G1H16(398),ex3(:),G1H8(223),m3h2x8(:,554),heltab2x16(:,:,1124))
  call Hloop_Q_A(ntryL,G1H8(223),20,nMT,G2H8(116),n2h8(378))
  call Hloop_AV_Q(ntryL,G1H16(403),ex3(:),G1H8(225),m3h2x8(:,555),heltab2x16(:,:,1125))
  call Hloop_A_Q(ntryL,G1H8(225),20,0,G2H8(117),n2h8(379))
  call Hloop_AV_Q(ntryL,G1H16(400),ex3(:),G1H8(226),m3h2x8(:,556),heltab2x16(:,:,1126))
  call Hloop_A_Q(ntryL,G1H8(226),20,nMT,G2H8(118),n2h8(380))
  call Hloop_QV_A(ntryL,G1H16(402),ex3(:),G1H8(227),m3h2x8(:,557),heltab2x16(:,:,1127))
  call Hloop_Q_A(ntryL,G1H8(227),20,nMB,G2H8(119),n2h8(381))
  call Hloop_AV_Q(ntryL,G1H16(404),ex3(:),G1H8(228),m3h2x8(:,558),heltab2x16(:,:,1128))
  call Hloop_A_Q(ntryL,G1H8(228),20,nMB,G2H8(120),n2h8(382))
  call Hloop_QV_A(ntryL,G1H16(405),ex3(:),G1H8(230),m3h2x8(:,559),heltab2x16(:,:,1129))
  call Hloop_Q_A(ntryL,G1H8(230),20,nME,G2H8(121),n2h8(383))
  call Hloop_QV_A(ntryL,G1H16(406),ex3(:),G1H8(231),m3h2x8(:,560),heltab2x16(:,:,1130))
  call Hloop_Q_A(ntryL,G1H8(231),20,nMM,G2H8(122),n2h8(384))
  call Hloop_QV_A(ntryL,G1H16(407),ex3(:),G1H8(232),m3h2x8(:,561),heltab2x16(:,:,1131))
  call Hloop_Q_A(ntryL,G1H8(232),20,nML,G2H8(123),n2h8(385))
  call Hloop_AV_Q(ntryL,G1H16(408),ex3(:),G1H8(233),m3h2x8(:,562),heltab2x16(:,:,1132))
  call Hloop_A_Q(ntryL,G1H8(233),20,nME,G2H8(124),n2h8(386))
  call Hloop_AV_Q(ntryL,G1H16(409),ex3(:),G1H8(235),m3h2x8(:,563),heltab2x16(:,:,1133))
  call Hloop_A_Q(ntryL,G1H8(235),20,nMM,G2H8(125),n2h8(387))
  call Hloop_AV_Q(ntryL,G1H16(410),ex3(:),G1H8(236),m3h2x8(:,564),heltab2x16(:,:,1134))
  call Hloop_A_Q(ntryL,G1H8(236),20,nML,G2H8(126),n2h8(388))
  call Hloop_QV_A(ntryL,G1H16(411),ex3(:),G1H8(237),m3h2x8(:,565),heltab2x16(:,:,1135))
  call Hloop_Q_A(ntryL,G1H8(237),20,0,G2H8(127),n2h8(389))
  call Hloop_QV_A(ntryL,G1H16(412),ex3(:),G1H8(238),m3h2x8(:,566),heltab2x16(:,:,1136))
  call Hloop_Q_A(ntryL,G1H8(238),20,nMT,G2H8(128),n2h8(390))
  call Hloop_AV_Q(ntryL,G1H16(413),ex3(:),G1H8(240),m3h2x8(:,567),heltab2x16(:,:,1137))
  call Hloop_A_Q(ntryL,G1H8(240),20,0,G2H8(129),n2h8(391))
  call Hloop_AV_Q(ntryL,G1H16(414),ex3(:),G1H8(241),m3h2x8(:,568),heltab2x16(:,:,1138))
  call Hloop_A_Q(ntryL,G1H8(241),20,nMT,G2H8(130),n2h8(392))
  call Hloop_QV_A(ntryL,G1H16(415),ex3(:),G1H8(242),m3h2x8(:,569),heltab2x16(:,:,1139))
  call Hloop_Q_A(ntryL,G1H8(242),20,0,G2H8(131),n2h8(393))
  call Hloop_QV_A(ntryL,G1H16(416),ex3(:),G1H8(243),m3h2x8(:,570),heltab2x16(:,:,1140))
  call Hloop_Q_A(ntryL,G1H8(243),20,nMB,G2H8(132),n2h8(394))
  call Hloop_AV_Q(ntryL,G1H16(417),ex3(:),G1H8(245),m3h2x8(:,571),heltab2x16(:,:,1141))
  call Hloop_A_Q(ntryL,G1H8(245),20,0,G2H8(133),n2h8(395))
  call Hloop_AV_Q(ntryL,G1H16(418),ex3(:),G1H8(246),m3h2x8(:,572),heltab2x16(:,:,1142))
  call Hloop_A_Q(ntryL,G1H8(246),20,nMB,G2H8(134),n2h8(396))
  call Hloop_TV_S(ntryL,G1H16(419),16,ex3(:),4,G2H8(135),m3h2x8(:,573),heltab2x16(:,:,1143))
  call Hloop_SV_T(ntryL,G1H16(420),16,ex3(:),4,G2H8(136),m3h2x8(:,574),heltab2x16(:,:,1144))
  call Hloop_TV_S(ntryL,G1H16(421),16,ex3(:),4,G2H8(137),m3h2x8(:,575),heltab2x16(:,:,1145))
  call Hloop_SV_T(ntryL,G1H16(422),16,ex3(:),4,G2H8(138),m3h2x8(:,576),heltab2x16(:,:,1146))
  call Hloop_CV_D(ntryL,G1H16(425),16,ex3(:),4,G2H8(139),m3h2x8(:,577),heltab2x16(:,:,1147))
  call Hloop_DV_C(ntryL,G1H16(426),16,ex3(:),G2H8(140),m3h2x8(:,578),heltab2x16(:,:,1148))
  call Hloop_CV_D(ntryL,G1H16(429),16,ex3(:),4,G2H8(141),m3h2x8(:,579),heltab2x16(:,:,1149))
  call Hloop_DV_C(ntryL,G1H16(430),16,ex3(:),G2H8(142),m3h2x8(:,580),heltab2x16(:,:,1150))
  call Hloop_UV_W(ntryL,G1H16(431),16,ex3(:),4,G2H8(143),m3h2x8(:,581),heltab2x16(:,:,1151))
  call Hloop_UW_V(ntryL,G1H16(432),16,ex3(:),4,G2H8(144),m3h2x8(:,582),heltab2x16(:,:,1152))
  call Hloop_UV_W(ntryL,G1H16(433),16,ex3(:),4,G2H8(145),m3h2x8(:,583),heltab2x16(:,:,1153))
  call Hloop_UW_V(ntryL,G1H16(434),16,ex3(:),4,G2H8(146),m3h2x8(:,584),heltab2x16(:,:,1154))
  call Hloop_TV_S(ntryL,G0H16(193),16,ex3(:),4,G1H8(247),m3h2x8(:,585),heltab2x16(:,:,1155))
  call Hloop_SV_T(ntryL,G0H16(194),16,ex3(:),4,G1H8(248),m3h2x8(:,586),heltab2x16(:,:,1156))
  call Hloop_TV_S(ntryL,G0H16(197),16,ex3(:),4,G1H8(250),m3h2x8(:,587),heltab2x16(:,:,1157))
  call Hloop_SV_T(ntryL,G0H16(198),16,ex3(:),4,G1H8(251),m3h2x8(:,588),heltab2x16(:,:,1158))
  call Hloop_SV_V(ntryL,G1H16(436),ex3(:),G1H8(252),m3h2x8(:,589),heltab2x16(:,:,1159))
  call Hloop_SV_V(ntryL,G1H16(438),ex3(:),G1H8(253),m3h2x8(:,590),heltab2x16(:,:,1160))
  call Hloop_VV_S(ntryL,G0H16(199),ex3(:),G0H8(24),m3h2x8(:,591),heltab2x16(:,:,1161))
  call Hloop_VV_S(ntryL,G0H16(200),ex3(:),G0H8(26),m3h2x8(:,592),heltab2x16(:,:,1162))
  call Hloop_VV_S(ntryL,G0H16(201),ex3(:),G0H8(2),m3h2x8(:,593),heltab2x16(:,:,1163))
  call Hloop_VV_S(ntryL,G0H16(202),ex3(:),G0H8(9),m3h2x8(:,594),heltab2x16(:,:,1164))
  call Hloop_SV_V(ntryL,G0H16(49),ex3(:),G0H8(11),m3h2x8(:,595),heltab2x16(:,:,1165))
  call Hloop_SV_V(ntryL,G0H16(50),ex3(:),G0H8(4),m3h2x8(:,596),heltab2x16(:,:,1166))
  call Hloop_SV_V(ntryL,G0H16(51),ex3(:),G0H8(49),m3h2x8(:,597),heltab2x16(:,:,1167))
  call Hloop_SV_V(ntryL,G0H16(52),ex3(:),G0H8(51),m3h2x8(:,598),heltab2x16(:,:,1168))
  call Hloop_VV_S(ntryL,G1H16(440),ex3(:),G1H8(255),m3h2x8(:,599),heltab2x16(:,:,1169))
  call Hloop_VV_S(ntryL,G1H16(442),ex3(:),G1H8(256),m3h2x8(:,600),heltab2x16(:,:,1170))
  call Hloop_UV_W(ntryL,G0H16(55),16,ex3(:),4,G1H8(257),m3h2x8(:,601),heltab2x16(:,:,1171))
  call Hloop_UW_V(ntryL,G0H16(56),16,ex3(:),4,G1H8(258),m3h2x8(:,602),heltab2x16(:,:,1172))
  call Hloop_UV_W(ntryL,G0H16(57),16,ex3(:),4,G1H8(260),m3h2x8(:,603),heltab2x16(:,:,1173))
  call Hloop_UW_V(ntryL,G0H16(58),16,ex3(:),4,G1H8(261),m3h2x8(:,604),heltab2x16(:,:,1174))
  call Hloop_AQ_S(ntryL,G1H16(443),ex1(:),G1H8(262),ngH,m3h2x8(:,605),heltab2x16(:,:,1175))
  call Hloop_AQ_S(ntryL,G1H16(444),ex1(:),G1H8(263),ngX,m3h2x8(:,606),heltab2x16(:,:,1176))
  call Hloop_SQ_A(ntryL,G1H16(445),ex1(:),G1H8(265),ngPnl,m3h2x8(:,607),heltab2x16(:,:,1177))
  call Hloop_Q_A(ntryL,G1H8(265),17,0,G2H8(147),n2h8(397))
  call Hloop_AQ_V(ntryL,G1H16(446),ex1(:),G1H8(266),m3h2x8(:,608),heltab2x16(:,:,1178))
  call Hloop_AQ_Z(ntryL,G1H16(447),ex1(:),G1H8(267),ngZl,m3h2x8(:,609),heltab2x16(:,:,1179))
  call Hloop_SQ_A(ntryL,G0H16(79),ex1(:),G0H8(53),ngPnl,m3h2x8(:,610),heltab2x16(:,:,1180))
  call Hloop_Q_A(ntryL,G0H8(53),17,0,G1H8(268),n2h8(398))
  call Hloop_WQ_A(ntryL,G0H16(80),ex1(:),G0H8(55),m3h2x8(:,611),heltab2x16(:,:,1181))
  call Hloop_Q_A(ntryL,G0H8(55),17,0,G1H8(270),n2h8(399))
  call Hloop_WQ_A(ntryL,G1H16(448),ex1(:),G1H8(271),m3h2x8(:,612),heltab2x16(:,:,1182))
  call Hloop_Q_A(ntryL,G1H8(271),17,0,G2H8(148),n2h8(400))
  call Hloop_SQ_A(ntryL,G0H4(125),ex1(:),G0H2(49),ngH,m3h2x2(:,591),heltab2x4(:,:,623))
  call Hloop_Q_A(ntryL,G0H2(49),27,nML,G1H2(315),n2h2(587))
  call Hloop_SQ_A(ntryL,G0H4(126),ex1(:),G0H2(49),ngX,m3h2x2(:,592),heltab2x4(:,:,624))
  call Hloop_Q_A(ntryL,G0H2(49),27,nML,G1H2(317),n2h2(588))
  call Hloop_AQ_S(ntryL,G1H4(273),ex1(:),G1H2(558),ngPnl,m3h2x2(:,593),heltab2x4(:,:,625))
  call Hloop_VQ_A(ntryL,G0H4(127),ex1(:),G0H2(49),m3h2x2(:,594),heltab2x4(:,:,626))
  call Hloop_Q_A(ntryL,G0H2(49),27,nML,G1H2(331),n2h2(589))
  call Hloop_ZQ_A(ntryL,G0H4(128),ex1(:),G0H2(49),ngZl,m3h2x2(:,595),heltab2x4(:,:,627))
  call Hloop_Q_A(ntryL,G0H2(49),27,nML,G1H2(333),n2h2(590))
  call Hloop_AQ_S(ntryL,G1H4(274),ex1(:),G1H2(15),ngPnl,m3h2x2(:,596),heltab2x4(:,:,628))
  call Hloop_AQ_W(ntryL,G1H4(275),ex1(:),G1H2(16),m3h2x2(:,597),heltab2x4(:,:,629))
  call Hloop_AQ_W(ntryL,G1H4(276),ex1(:),G1H2(22),m3h2x2(:,598),heltab2x4(:,:,630))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(204),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(226),[G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(139),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(124),[G1H2(114),G1H2(268)])
call HGT_OLR(G2H2(222),1,1,2)
call HGT_invQ_OLR(G2H2(222),2,5,2)
call HGT_OLR(G2H2(222),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(222),[G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(572),G2H2(457),G2H2(493),G2H2(428),G2H2(419) &
    ,G2H2(91),G2H2(11),G2H2(504),G2H2(468),G2H2(426),G2H2(396),G2H2(223),G1H2(525),G1H2(522),G1H2(176),G1H2(514),G1H2(111) &
    ,G1H2(54),G1H2(125),G1H2(6)])
call ol_merge_last(G1H2(195), G1H2(195)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G1H2(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(235),[G1H2(219),G1H2(12),G0H2(1)])
call HGT_OLR(G2H2(226),1,1,2)
call HGT_invQ_OLR(G2H2(226),2,5,2)
call HGT_OLR(G2H2(226),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G1H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G2H2(88),G2H2(437),G2H2(403),G2H2(546),G2H2(540) &
    ,G2H2(227),G1H2(98),G1H2(93),G1H2(495),G1H2(361),G1H2(359),G1H2(345),G1H2(325),G1H2(316),G1H2(438),G1H2(423),G1H2(118) &
    ,G1H2(19),G0H2(44),G0H2(42),G0H2(34),G0H2(32),G0H2(12),G0H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(487),[G2H2(523),G2H2(111),G2H2(117),G2H2(459),G2H2(456) &
    ,G2H2(266),G2H2(230),G1H2(541),G1H2(540),G1H2(231),G1H2(229),G1H2(537),G1H2(220),G1H2(431),G1H2(430),G1H2(421),G1H2(420) &
    ,G1H2(419),G1H2(416),G1H2(326),G1H2(298),G0H2(39),G0H2(29),G0H2(18),G0H2(17)])
call ol_merge_last(G2H2(236), G2H2(236)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(236),[G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(273),[G1H2(283),G1H2(65),G0H2(3)])
call HGT_lower_alpha_w2_OLR(G2H2(236),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(236),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(236),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(236),[G1H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(485),[G2H2(521),G2H2(554),G2H2(110),G2H2(453),G2H2(450) &
    ,G2H2(269),G2H2(233),G1H2(539),G1H2(247),G1H2(245),G1H2(538),G1H2(218),G1H2(534),G1H2(429),G1H2(426),G1H2(425),G1H2(424) &
    ,G1H2(415),G1H2(414),G1H2(294),G1H2(266),G0H2(40),G0H2(30),G0H2(20),G0H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(196),[G2H2(195),G2H2(490),G2H2(440),G2H2(570),G2H2(564) &
    ,G2H2(237),G1H2(507),G1H2(120),G1H2(83),G1H2(369),G1H2(365),G1H2(355),G1H2(97),G1H2(119),G1H2(443),G1H2(433),G1H2(107) &
    ,G1H2(40),G0H2(48),G0H2(46),G0H2(38),G0H2(36),G0H2(16),G0H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(202),[G2H2(127),G2H2(73),G2H2(74),G1H2(321),G1H2(251) &
    ,G1H2(212),G1H2(122)])
call HGT_OLR(G2H2(240),1,1,2)
call HGT_invQ_OLR(G2H2(240),2,5,2)
call HGT_OLR(G2H2(240),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(240),[G2H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(241),[G1H2(533),G1H2(130),G1H2(289),G1H2(230)])
call ol_merge_last(G1H2(217), G1H2(217)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(244),[G1H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(72),G1H2(282),G1H2(96),G0H2(21)])
call HGT_OLR(G2H2(244),1,1,2)
call HGT_invQ_OLR(G2H2(244),2,5,2)
call HGT_OLR(G2H2(244),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(244),[G2H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(245),[G1H2(453),G1H2(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(284),[G2H2(248)])
call ol_merge_last(G2H2(254), G2H2(254)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(254),[G1H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(478),[G2H2(541),G1H2(101),G1H2(45),G0H2(23)])
call HGT_lower_alpha_w2_OLR(G2H2(254),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(254),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(254),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(254),[G2H2(478)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(287),[G2H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(255),[G1H2(463),G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(314),[G1H2(188),G1H2(193)])
call HGT_OLR(G2H2(258),1,1,2)
call HGT_invQ_OLR(G2H2(258),2,5,2)
call HGT_OLR(G2H2(258),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(258),[G1H2(314)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(177),[G2H2(548),G2H2(448),G2H2(491),G2H2(424),G2H2(249) &
    ,G2H2(247),G2H2(469),G2H2(513),G2H2(477),G2H2(435),G2H2(405),G2H2(259),G1H2(543),G1H2(506),G1H2(109),G1H2(89),G1H2(343) &
    ,G1H2(254),G1H2(319),G1H2(165)])



end subroutine vamp_6

end module ol_vamp_6_ppllj_ew_llxaaa_1_/**/REALKIND
