
module ol_vamp_5_ppllj_ew_llxaaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_5(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj_ew_llxaaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj_ew_llxaaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllj_ew_llxaaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllj_ew_llxaaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllj_ew_llxaaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllj_ew_llxaaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hotf_4pt_reduction_last(G1tensor(336),RedSet_4(16),mass4set(:,17),  & 
G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360),G0tensor(361))
  call Hotf_4pt_reduction_last(G1tensor(341),RedSet_4(17),mass4set(:,9),  & 
G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365),G0tensor(366))
  call Hotf_4pt_reduction_last(G1tensor(346),RedSet_4(18),mass4set(:,5),  & 
G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370),G0tensor(371))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(16),mass4set(:,18),  & 
G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375),G0tensor(376))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(18),mass4set(:,6),  & 
G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380),G0tensor(381))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(16),mass4set(:,19),  & 
G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385),G0tensor(386))
  call Hotf_4pt_reduction_last(G1tensor(366),RedSet_4(18),mass4set(:,8),  & 
G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390),G0tensor(391))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(20),mass4set(:,17),  & 
G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395),G0tensor(396))
  call Hotf_4pt_reduction_last(G1tensor(376),RedSet_4(21),mass4set(:,5),  & 
G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400),G0tensor(401))
  call Hotf_4pt_reduction_last(G1tensor(381),RedSet_4(20),mass4set(:,18),  & 
G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405),G0tensor(406))
  call Hotf_4pt_reduction_last(G1tensor(386),RedSet_4(21),mass4set(:,6),  & 
G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410),G0tensor(411))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(20),mass4set(:,19),  & 
G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415),G0tensor(416))
  call Hotf_4pt_reduction_last(G1tensor(396),RedSet_4(21),mass4set(:,8),  & 
G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420),G0tensor(421))
  call Hotf_4pt_reduction_last(G1tensor(401),RedSet_4(23),mass4set(:,17),  & 
G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425),G0tensor(426))
  call Hotf_4pt_reduction_last(G1tensor(406),RedSet_4(24),mass4set(:,5),  & 
G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430),G0tensor(431))
  call Hotf_4pt_reduction_last(G1tensor(411),RedSet_4(23),mass4set(:,18),  & 
G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435),G0tensor(436))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(24),mass4set(:,6),  & 
G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440),G0tensor(441))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(23),mass4set(:,19),  & 
G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445),G0tensor(446))
  call Hotf_4pt_reduction_last(G1tensor(426),RedSet_4(24),mass4set(:,8),  & 
G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450),G0tensor(451))
  call Hotf_4pt_reduction_last(G1tensor(431),RedSet_4(17),mass4set(:,11),  & 
G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455),G0tensor(456))
  call Hotf_4pt_reduction_last(G1tensor(520),RedSet_4(17),mass4set(:,12),  & 
G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460),G0tensor(461))
  call Hotf_4pt_reduction_last(G1tensor(525),RedSet_4(17),mass4set(:,13),  & 
G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465),G0tensor(466))
  call Hotf_4pt_reduction_last(G1tensor(530),RedSet_4(17),mass4set(:,14),  & 
G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470),G0tensor(471))
  call Hotf_4pt_reduction_last(G1tensor(535),RedSet_4(17),mass4set(:,15),  & 
G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475),G0tensor(476))
  call Hotf_4pt_reduction_last(G1tensor(540),RedSet_4(10),mass4set(:,11),  & 
G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480),G0tensor(481))
  call Hotf_4pt_reduction_last(G1tensor(545),RedSet_4(10),mass4set(:,12),  & 
G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485),G0tensor(486))
  call Hotf_4pt_reduction_last(G1tensor(550),RedSet_4(10),mass4set(:,13),  & 
G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490),G0tensor(491))
  call Hotf_4pt_reduction_last(G1tensor(555),RedSet_4(10),mass4set(:,14),  & 
G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495),G0tensor(496))
  call Hotf_4pt_reduction_last(G1tensor(560),RedSet_4(10),mass4set(:,15),  & 
G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500),G0tensor(501))
  call Hotf_4pt_reduction_last(G1tensor(565),RedSet_4(7),mass4set(:,11),  & 
G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505),G0tensor(506))
  call Hotf_4pt_reduction_last(G1tensor(570),RedSet_4(7),mass4set(:,12),  & 
G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510),G0tensor(511))
  call Hotf_4pt_reduction_last(G1tensor(575),RedSet_4(7),mass4set(:,13),  & 
G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515),G0tensor(516))
  call Hotf_4pt_reduction_last(G1tensor(580),RedSet_4(7),mass4set(:,14),  & 
G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520),G0tensor(521))
  call Hotf_4pt_reduction_last(G1tensor(585),RedSet_4(7),mass4set(:,15),  & 
G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525),G0tensor(526))
  call ol_merge_tensors(T0sum(1),[G0tensor(22)])
  call ol_merge_tensors(T0sum(2),[G0tensor(27)])
  call ol_merge_tensors(T0sum(3),[G0tensor(32)])
  call ol_merge_tensors(T0sum(4),[G0tensor(37)])
  call ol_merge_tensors(T0sum(5),[G0tensor(42)])
  call ol_merge_tensors(T0sum(6),[G0tensor(47)])
  call ol_merge_tensors(T0sum(7),[G0tensor(52)])
  call ol_merge_tensors(T0sum(8),[G0tensor(57)])
  call ol_merge_tensors(T0sum(9),[G0tensor(62)])
  call ol_merge_tensors(T0sum(10),[G0tensor(67)])
  call ol_merge_tensors(T0sum(11),[G0tensor(72)])
  call ol_merge_tensors(T0sum(12),[G0tensor(77)])
  call ol_merge_tensors(T0sum(13),[G0tensor(82)])
  call ol_merge_tensors(T0sum(14),[G0tensor(87)])
  call ol_merge_tensors(T0sum(15),[G0tensor(92)])
  call ol_merge_tensors(T0sum(16),[G0tensor(97)])
  call ol_merge_tensors(T0sum(17),[G0tensor(102)])
  call ol_merge_tensors(T0sum(18),[G0tensor(107)])
  call ol_merge_tensors(T0sum(19),[G0tensor(112)])
  call ol_merge_tensors(T0sum(20),[G0tensor(117)])
  call ol_merge_tensors(T0sum(21),[G0tensor(122)])
  call ol_merge_tensors(T0sum(22),[G0tensor(127)])
  call ol_merge_tensors(T0sum(23),[G0tensor(132)])
  call ol_merge_tensors(T0sum(24),[G0tensor(137)])
  call ol_merge_tensors(T0sum(25),[G0tensor(142)])
  call ol_merge_tensors(T0sum(26),[G0tensor(147)])
  call ol_merge_tensors(T0sum(27),[G0tensor(152)])
  call ol_merge_tensors(T0sum(28),[G0tensor(157)])
  call ol_merge_tensors(T0sum(29),[G0tensor(162)])
  call ol_merge_tensors(T0sum(30),[G0tensor(167)])
  call ol_merge_tensors(T0sum(31),[G0tensor(172)])
  call ol_merge_tensors(T0sum(32),[G0tensor(177)])
  call ol_merge_tensors(T0sum(33),[G0tensor(182)])
  call ol_merge_tensors(T0sum(34),[G0tensor(187)])
  call ol_merge_tensors(T0sum(35),[G0tensor(192)])
  call ol_merge_tensors(T0sum(36),[G0tensor(197)])
  call ol_merge_tensors(T0sum(37),[G0tensor(202)])
  call ol_merge_tensors(T0sum(38),[G0tensor(207)])
  call ol_merge_tensors(T0sum(39),[G0tensor(212)])
  call ol_merge_tensors(T0sum(40),[G0tensor(217)])
  call ol_merge_tensors(T0sum(41),[G0tensor(222)])
  call ol_merge_tensors(T0sum(42),[G0tensor(227)])
  call ol_merge_tensors(T0sum(43),[G0tensor(232)])
  call ol_merge_tensors(T0sum(44),[G0tensor(237)])
  call ol_merge_tensors(T0sum(45),[G0tensor(242)])
  call ol_merge_tensors(T0sum(46),[G0tensor(247)])
  call ol_merge_tensors(T0sum(47),[G0tensor(252)])
  call ol_merge_tensors(T0sum(48),[G0tensor(257)])
  call ol_merge_tensors(T0sum(49),[G0tensor(262)])
  call ol_merge_tensors(T0sum(50),[G0tensor(267)])
  call ol_merge_tensors(T0sum(51),[G0tensor(272)])
  call ol_merge_tensors(T0sum(52),[G0tensor(277)])
  call ol_merge_tensors(T0sum(53),[G0tensor(282)])
  call ol_merge_tensors(T0sum(54),[G0tensor(287)])
  call ol_merge_tensors(T0sum(55),[G0tensor(292)])
  call ol_merge_tensors(T0sum(56),[G0tensor(297)])
  call ol_merge_tensors(T0sum(57),[G0tensor(302)])
  call ol_merge_tensors(T0sum(58),[G0tensor(307)])
  call ol_merge_tensors(T0sum(59),[G0tensor(312)])
  call ol_merge_tensors(T0sum(60),[G0tensor(317)])
  call ol_merge_tensors(T0sum(61),[G0tensor(322)])
  call ol_merge_tensors(T0sum(62),[G0tensor(327)])
  call ol_merge_tensors(T0sum(63),[G0tensor(332)])
  call ol_merge_tensors(T0sum(64),[G0tensor(337)])
  call ol_merge_tensors(T0sum(65),[G0tensor(342)])
  call ol_merge_tensors(T0sum(66),[G0tensor(347)])
  call ol_merge_tensors(T0sum(67),[G0tensor(352)])
  call ol_merge_tensors(T0sum(68),[G0tensor(357)])
  call ol_merge_tensors(T0sum(69),[G0tensor(362)])
  call ol_merge_tensors(T0sum(70),[G0tensor(367)])
  call ol_merge_tensors(T0sum(71),[G0tensor(372)])
  call ol_merge_tensors(T0sum(72),[G0tensor(377)])
  call ol_merge_tensors(T0sum(73),[G0tensor(382)])
  call ol_merge_tensors(T0sum(74),[G0tensor(387)])
  call ol_merge_tensors(T0sum(75),[G0tensor(392)])
  call ol_merge_tensors(T0sum(76),[G0tensor(397)])
  call ol_merge_tensors(T0sum(77),[G0tensor(402)])
  call ol_merge_tensors(T0sum(78),[G0tensor(407)])
  call ol_merge_tensors(T0sum(79),[G0tensor(412)])
  call ol_merge_tensors(T0sum(80),[G0tensor(417)])
  call ol_merge_tensors(T0sum(81),[G0tensor(422)])
  call ol_merge_tensors(T0sum(82),[G0tensor(427)])
  call ol_merge_tensors(T0sum(83),[G0tensor(432)])
  call ol_merge_tensors(T0sum(84),[G0tensor(437)])
  call ol_merge_tensors(T0sum(85),[G0tensor(442)])
  call ol_merge_tensors(T0sum(86),[G0tensor(447)])
  call ol_merge_tensors(T0sum(87),[G0tensor(1)])
  call ol_merge_tensors(T0sum(88),[G0tensor(2)])
  call ol_merge_tensors(T0sum(89),[G0tensor(3)])
  call ol_merge_tensors(T0sum(90),[G0tensor(4)])
  call ol_merge_tensors(T0sum(91),[G0tensor(5)])
  call ol_merge_tensors(T0sum(92),[G0tensor(6)])
  call ol_merge_tensors(T0sum(93),[G0tensor(7)])
  call ol_merge_tensors(T0sum(94),[G0tensor(8)])
  call ol_merge_tensors(T0sum(95),[G0tensor(9)])
  call ol_merge_tensors(T0sum(96),[G0tensor(10)])
  call ol_merge_tensors(T0sum(97),[G0tensor(11)])
  call ol_merge_tensors(T0sum(98),[G0tensor(12)])
  call ol_merge_tensors(T0sum(99),[G0tensor(13)])
  call ol_merge_tensors(T0sum(100),[G0tensor(14)])
  call ol_merge_tensors(T0sum(101),[G0tensor(15)])
  call ol_merge_tensors(T0sum(102),[G0tensor(16)])
  call ol_merge_tensors(T0sum(103),[G0tensor(17)])
  call ol_merge_tensors(T0sum(104),[G0tensor(18)])
  call ol_merge_tensors(T0sum(105),[G0tensor(19)])
  call ol_merge_tensors(T0sum(106),[G0tensor(20)])
  call ol_merge_tensors(T0sum(107),[G0tensor(21)])
  call ol_merge_tensors(T0sum(108),[G0tensor(452)])
  call ol_merge_tensors(T0sum(109),[G0tensor(457)])
  call ol_merge_tensors(T0sum(110),[G0tensor(462)])
  call ol_merge_tensors(T0sum(111),[G0tensor(467)])
  call ol_merge_tensors(T0sum(112),[G0tensor(472)])
  call ol_merge_tensors(T0sum(113),[G0tensor(477)])
  call ol_merge_tensors(T0sum(114),[G0tensor(482)])
  call ol_merge_tensors(T0sum(115),[G0tensor(487)])
  call ol_merge_tensors(T0sum(116),[G0tensor(492)])
  call ol_merge_tensors(T0sum(117),[G0tensor(497)])
  call ol_merge_tensors(T0sum(118),[G0tensor(502)])
  call ol_merge_tensors(T0sum(119),[G0tensor(507)])
  call ol_merge_tensors(T0sum(120),[G0tensor(512)])
  call ol_merge_tensors(T0sum(121),[G0tensor(517)])
  call ol_merge_tensors(T0sum(122),[G0tensor(522)])
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(817),h0tab(:,817),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,36),G0H4(35),m4h2x4x4(:,1),heltab3x32(:,:,17))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(818),h0tab(:,818),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,36),G0H4(34),m4h2x4x4(:,2),heltab3x32(:,:,18))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(819),h0tab(:,819),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,37),G0H4(33),m4h2x4x4(:,3),heltab3x32(:,:,19))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(820),h0tab(:,820),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,37),G0H4(25),m4h2x4x4(:,4),heltab3x32(:,:,20))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(821),h0tab(:,821),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,36),ex5(:),G0H4(26),m4h4x2x4(:,1),heltab3x32(:,:,21))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(822),h0tab(:,822),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,36),ex5(:),G0H4(41),m4h4x2x4(:,2),heltab3x32(:,:,22))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(823),h0tab(:,823),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,37),ex5(:),G0H4(32),m4h4x2x4(:,3),heltab3x32(:,:,23))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(824),h0tab(:,824),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,37),ex5(:),G0H4(30),m4h4x2x4(:,4),heltab3x32(:,:,24))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(825),h0tab(:,825),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,36),G0H4(22),m4h2x4x4(:,5),heltab3x32(:,:,25))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(826),h0tab(:,826),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,36),G0H4(28),m4h2x4x4(:,6),heltab3x32(:,:,26))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(827),h0tab(:,827),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,37),G0H4(40),m4h2x4x4(:,7),heltab3x32(:,:,27))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(828),h0tab(:,828),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,37),G0H4(38),m4h2x4x4(:,8),heltab3x32(:,:,28))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(829),h0tab(:,829),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,36),ex5(:),G0H4(11),m4h4x2x4(:,5),heltab3x32(:,:,29))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(830),h0tab(:,830),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,36),ex5(:),G0H4(9),m4h4x2x4(:,6),heltab3x32(:,:,30))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(831),h0tab(:,831),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,37),ex5(:),G0H4(1),m4h4x2x4(:,7),heltab3x32(:,:,31))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(832),h0tab(:,832),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,37),ex5(:),G0H4(7),m4h4x2x4(:,8),heltab3x32(:,:,32))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(833),h0tab(:,833),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(19),m4h2x4x4(:,9),heltab3x32(:,:,33))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(834),h0tab(:,834),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(17),m4h2x4x4(:,10),heltab3x32(:,:,34))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(835),h0tab(:,835),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(31),m4h2x4x4(:,11),heltab3x32(:,:,35))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(836),h0tab(:,836),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(29),m4h2x4x4(:,12),heltab3x32(:,:,36))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(837),h0tab(:,837),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(21),m4h2x4x4(:,13),heltab3x32(:,:,37))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(838),h0tab(:,838),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(27),m4h2x4x4(:,14),heltab3x32(:,:,38))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(839),h0tab(:,839),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(39),m4h2x4x4(:,15),heltab3x32(:,:,39))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(840),h0tab(:,840),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(37),m4h2x4x4(:,16),heltab3x32(:,:,40))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(841),h0tab(:,841),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(12),m4h2x4x4(:,17),heltab3x32(:,:,41))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(842),h0tab(:,842),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(10),m4h2x4x4(:,18),heltab3x32(:,:,42))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(843),h0tab(:,843),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(2),m4h2x4x4(:,19),heltab3x32(:,:,43))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(844),h0tab(:,844),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(8),m4h2x4x4(:,20),heltab3x32(:,:,44))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(845),h0tab(:,845),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(20),m4h2x4x4(:,21),heltab3x32(:,:,45))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(846),h0tab(:,846),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(18),m4h2x4x4(:,22),heltab3x32(:,:,46))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(847),h0tab(:,847),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(3),m4h2x4x4(:,23),heltab3x32(:,:,47))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(848),h0tab(:,848),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(4),m4h2x4x4(:,24),heltab3x32(:,:,48))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(849),h0tab(:,849),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,753),heltab2x32(:,:,801))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(850),h0tab(:,850),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,754),heltab2x32(:,:,802))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(851),h0tab(:,851),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,755),heltab2x32(:,:,803))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(852),h0tab(:,852),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,756),heltab2x32(:,:,804))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(853),h0tab(:,853),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,757),heltab2x32(:,:,805))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(854),h0tab(:,854),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(28),m3h2x16(:,758),heltab2x32(:,:,806))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(855),h0tab(:,855),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,759),heltab2x32(:,:,807))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(856),h0tab(:,856),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,760),heltab2x32(:,:,808))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(857),h0tab(:,857),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,761),heltab2x32(:,:,809))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(858),h0tab(:,858),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,762),heltab2x32(:,:,810))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(859),h0tab(:,859),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,763),heltab2x32(:,:,811))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(860),h0tab(:,860),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,764),heltab2x32(:,:,812))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(861),h0tab(:,861),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,765),heltab2x32(:,:,813))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(862),h0tab(:,862),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,766),heltab2x32(:,:,814))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(863),h0tab(:,863),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,767),heltab2x32(:,:,815))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(864),h0tab(:,864),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,768),heltab2x32(:,:,816))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(865),h0tab(:,865),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(89),m3h2x16(:,769),heltab2x32(:,:,817))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(866),h0tab(:,866),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(90),m3h2x16(:,770),heltab2x32(:,:,818))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(867),h0tab(:,867),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(93),m3h2x16(:,771),heltab2x32(:,:,819))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(868),h0tab(:,868),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(94),m3h2x16(:,772),heltab2x32(:,:,820))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(869),h0tab(:,869),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(147),m3h2x16(:,773),heltab2x32(:,:,821))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(870),h0tab(:,870),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(148),m3h2x16(:,774),heltab2x32(:,:,822))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(871),h0tab(:,871),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(151),m3h2x16(:,775),heltab2x32(:,:,823))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(872),h0tab(:,872),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(152),m3h2x16(:,776),heltab2x32(:,:,824))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(873),h0tab(:,873),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,777),heltab2x32(:,:,825))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(874),h0tab(:,874),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(71),m3h2x16(:,778),heltab2x32(:,:,826))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(875),h0tab(:,875),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(73),m3h2x16(:,779),heltab2x32(:,:,827))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(876),h0tab(:,876),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(75),m3h2x16(:,780),heltab2x32(:,:,828))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(877),h0tab(:,877),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,781),heltab2x32(:,:,829))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(878),h0tab(:,878),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,782),heltab2x32(:,:,830))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(879),h0tab(:,879),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,783),heltab2x32(:,:,831))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(880),h0tab(:,880),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,784),heltab2x32(:,:,832))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(881),h0tab(:,881),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(41),m4h2x2x8(:,17),heltab3x32(:,:,49))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(882),h0tab(:,882),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(17),m4h2x2x8(:,18),heltab3x32(:,:,50))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(883),h0tab(:,883),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(18),m4h2x2x8(:,19),heltab3x32(:,:,51))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(884),h0tab(:,884),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(19),m4h2x2x8(:,20),heltab3x32(:,:,52))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(885),h0tab(:,885),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(20),m4h2x2x8(:,21),heltab3x32(:,:,53))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(886),h0tab(:,886),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(21),m4h2x2x8(:,22),heltab3x32(:,:,54))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(887),h0tab(:,887),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(22),m4h2x2x8(:,23),heltab3x32(:,:,55))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(888),h0tab(:,888),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(23),m4h2x2x8(:,24),heltab3x32(:,:,56))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(889),h0tab(:,889),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(24),m4h2x2x8(:,25),heltab3x32(:,:,57))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(890),h0tab(:,890),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(25),m4h2x2x8(:,26),heltab3x32(:,:,58))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(891),h0tab(:,891),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(26),m4h2x2x8(:,27),heltab3x32(:,:,59))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(892),h0tab(:,892),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(27),m4h2x2x8(:,28),heltab3x32(:,:,60))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(893),h0tab(:,893),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(28),m4h2x2x8(:,29),heltab3x32(:,:,61))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(894),h0tab(:,894),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(29),m4h2x2x8(:,30),heltab3x32(:,:,62))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(895),h0tab(:,895),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(30),m4h2x2x8(:,31),heltab3x32(:,:,63))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(896),h0tab(:,896),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(31),m4h2x2x8(:,32),heltab3x32(:,:,64))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(897),h0tab(:,897),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(32),m4h2x2x8(:,33),heltab3x32(:,:,65))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(898),h0tab(:,898),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(16),m4h2x2x8(:,34),heltab3x32(:,:,66))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(899),h0tab(:,899),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(8),m4h2x2x8(:,35),heltab3x32(:,:,67))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(900),h0tab(:,900),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(1),m4h2x2x8(:,36),heltab3x32(:,:,68))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(901),h0tab(:,901),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(2),m4h2x2x8(:,37),heltab3x32(:,:,69))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(902),h0tab(:,902),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(12),m4h2x2x8(:,38),heltab3x32(:,:,70))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(903),h0tab(:,903),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(9),m4h2x2x8(:,39),heltab3x32(:,:,71))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(904),h0tab(:,904),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(10),m4h2x2x8(:,40),heltab3x32(:,:,72))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(905),h0tab(:,905),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(11),m4h2x2x8(:,41),heltab3x32(:,:,73))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(906),h0tab(:,906),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,42),heltab3x32(:,:,74))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(907),h0tab(:,907),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,43),heltab3x32(:,:,75))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(908),h0tab(:,908),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(5),m4h2x2x8(:,44),heltab3x32(:,:,76))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(909),h0tab(:,909),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(125),m3h2x16(:,785),heltab2x32(:,:,833))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(910),h0tab(:,910),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(127),m3h2x16(:,786),heltab2x32(:,:,834))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(911),h0tab(:,911),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(129),m3h2x16(:,787),heltab2x32(:,:,835))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(912),h0tab(:,912),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(131),m3h2x16(:,788),heltab2x32(:,:,836))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(913),h0tab(:,913),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(161),m3h2x16(:,789),heltab2x32(:,:,837))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(914),h0tab(:,914),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(171),m3h2x16(:,790),heltab2x32(:,:,838))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(915),h0tab(:,915),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(183),m3h2x16(:,791),heltab2x32(:,:,839))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(916),h0tab(:,916),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(185),m3h2x16(:,792),heltab2x32(:,:,840))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(917),h0tab(:,917),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(209),m3h2x16(:,793),heltab2x32(:,:,841))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(918),h0tab(:,918),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(210),m3h2x16(:,794),heltab2x32(:,:,842))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(919),h0tab(:,919),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(213),m3h2x16(:,795),heltab2x32(:,:,843))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(920),h0tab(:,920),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(214),m3h2x16(:,796),heltab2x32(:,:,844))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(921),h0tab(:,921),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(153),m3h2x16(:,797),heltab2x32(:,:,845))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(922),h0tab(:,922),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(155),m3h2x16(:,798),heltab2x32(:,:,846))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(923),h0tab(:,923),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(157),m3h2x16(:,799),heltab2x32(:,:,847))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(924),h0tab(:,924),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(159),m3h2x16(:,800),heltab2x32(:,:,848))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(925),h0tab(:,925),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(267),m3h2x16(:,801),heltab2x32(:,:,849))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(926),h0tab(:,926),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(268),m3h2x16(:,802),heltab2x32(:,:,850))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(927),h0tab(:,927),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(271),m3h2x16(:,803),heltab2x32(:,:,851))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(928),h0tab(:,928),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(272),m3h2x16(:,804),heltab2x32(:,:,852))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(929),h0tab(:,929),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(285),m3h2x16(:,805),heltab2x32(:,:,853))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(930),h0tab(:,930),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(287),m3h2x16(:,806),heltab2x32(:,:,854))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(931),h0tab(:,931),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(303),m3h2x16(:,807),heltab2x32(:,:,855))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(932),h0tab(:,932),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(305),m3h2x16(:,808),heltab2x32(:,:,856))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(933),h0tab(:,933),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,809),heltab2x32(:,:,857))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(934),h0tab(:,934),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,810),heltab2x32(:,:,858))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(935),h0tab(:,935),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,811),heltab2x32(:,:,859))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(936),h0tab(:,936),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,812),heltab2x32(:,:,860))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(937),h0tab(:,937),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,813),heltab2x32(:,:,861))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(938),h0tab(:,938),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,814),heltab2x32(:,:,862))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(939),h0tab(:,939),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,815),heltab2x32(:,:,863))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(940),h0tab(:,940),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,816),heltab2x32(:,:,864))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(941),h0tab(:,941),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(7),m4h2x2x8(:,45),heltab3x32(:,:,77))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(942),h0tab(:,942),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(15),m4h2x2x8(:,46),heltab3x32(:,:,78))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(943),h0tab(:,943),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(34),m4h2x2x8(:,47),heltab3x32(:,:,79))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(944),h0tab(:,944),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(35),m4h2x2x8(:,48),heltab3x32(:,:,80))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(945),h0tab(:,945),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(36),m4h2x2x8(:,49),heltab3x32(:,:,81))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(946),h0tab(:,946),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(13),m4h2x2x8(:,50),heltab3x32(:,:,82))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(947),h0tab(:,947),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(14),m4h2x2x8(:,51),heltab3x32(:,:,83))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(948),h0tab(:,948),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(6),m4h2x2x8(:,52),heltab3x32(:,:,84))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(949),h0tab(:,949),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(33),m4h2x2x8(:,53),heltab3x32(:,:,85))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(950),h0tab(:,950),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(37),m4h2x2x8(:,54),heltab3x32(:,:,86))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(951),h0tab(:,951),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(38),m4h2x2x8(:,55),heltab3x32(:,:,87))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(952),h0tab(:,952),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(39),m4h2x2x8(:,56),heltab3x32(:,:,88))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(953),h0tab(:,953),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(40),m4h2x2x8(:,57),heltab3x32(:,:,89))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(954),h0tab(:,954),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(42),m4h2x2x8(:,58),heltab3x32(:,:,90))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(955),h0tab(:,955),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(43),m4h2x2x8(:,59),heltab3x32(:,:,91))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(956),h0tab(:,956),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(44),m4h2x2x8(:,60),heltab3x32(:,:,92))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(957),h0tab(:,957),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(45),m4h2x2x8(:,61),heltab3x32(:,:,93))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(958),h0tab(:,958),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(46),m4h2x2x8(:,62),heltab3x32(:,:,94))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(959),h0tab(:,959),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(47),m4h2x2x8(:,63),heltab3x32(:,:,95))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(960),h0tab(:,960),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(48),m4h2x2x8(:,64),heltab3x32(:,:,96))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(961),h0tab(:,961),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(49),m4h2x2x8(:,65),heltab3x32(:,:,97))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(962),h0tab(:,962),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(50),m4h2x2x8(:,66),heltab3x32(:,:,98))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(963),h0tab(:,963),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(51),m4h2x2x8(:,67),heltab3x32(:,:,99))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(964),h0tab(:,964),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(52),m4h2x2x8(:,68),heltab3x32(:,:,100))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(965),h0tab(:,965),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(53),m4h2x2x8(:,69),heltab3x32(:,:,101))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(966),h0tab(:,966),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(54),m4h2x2x8(:,70),heltab3x32(:,:,102))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(967),h0tab(:,967),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(55),m4h2x2x8(:,71),heltab3x32(:,:,103))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(968),h0tab(:,968),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(56),m4h2x2x8(:,72),heltab3x32(:,:,104))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(969),h0tab(:,969),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(329),m3h2x16(:,817),heltab2x32(:,:,865))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(970),h0tab(:,970),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(330),m3h2x16(:,818),heltab2x32(:,:,866))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(971),h0tab(:,971),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(333),m3h2x16(:,819),heltab2x32(:,:,867))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(972),h0tab(:,972),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(334),m3h2x16(:,820),heltab2x32(:,:,868))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(973),h0tab(:,973),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,821),heltab2x32(:,:,869))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(974),h0tab(:,974),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,822),heltab2x32(:,:,870))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(975),h0tab(:,975),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,823),heltab2x32(:,:,871))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(976),h0tab(:,976),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,824),heltab2x32(:,:,872))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(977),h0tab(:,977),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,825),heltab2x32(:,:,873))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(978),h0tab(:,978),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,826),heltab2x32(:,:,874))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(979),h0tab(:,979),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,827),heltab2x32(:,:,875))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(980),h0tab(:,980),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,828),heltab2x32(:,:,876))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(981),h0tab(:,981),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,829),heltab2x32(:,:,877))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(982),h0tab(:,982),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,830),heltab2x32(:,:,878))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(983),h0tab(:,983),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,831),heltab2x32(:,:,879))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(984),h0tab(:,984),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,832),heltab2x32(:,:,880))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(985),h0tab(:,985),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,833),heltab2x32(:,:,881))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(986),h0tab(:,986),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,834),heltab2x32(:,:,882))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(987),h0tab(:,987),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,835),heltab2x32(:,:,883))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(988),h0tab(:,988),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,836),heltab2x32(:,:,884))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(989),h0tab(:,989),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,837),heltab2x32(:,:,885))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(990),h0tab(:,990),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,838),heltab2x32(:,:,886))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(991),h0tab(:,991),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,839),heltab2x32(:,:,887))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(992),h0tab(:,992),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,840),heltab2x32(:,:,888))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(993),h0tab(:,993),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,841),heltab2x32(:,:,889))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(994),h0tab(:,994),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,842),heltab2x32(:,:,890))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(995),h0tab(:,995),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,843),heltab2x32(:,:,891))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(996),h0tab(:,996),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,844),heltab2x32(:,:,892))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(997),h0tab(:,997),[24,2,5],[nMW,0,nMW],4,1,wf4(:,3))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(57),m4h2x2x8(:,73),heltab3x32(:,:,105))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(998),h0tab(:,998),[24,2,5],[nMW,0,nMW],4,1,wf4(:,3))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(58),m4h2x2x8(:,74),heltab3x32(:,:,106))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(999),h0tab(:,999),[24,1,6],[nMW,0,nMW],4,1,wf4(:,10))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(59),m4h2x2x8(:,75),heltab3x32(:,:,107))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1000),h0tab(:,1000),[24,1,6],[nMW,0,nMW],4,1,wf4(:,10))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(60),m4h2x2x8(:,76),heltab3x32(:,:,108))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1001),h0tab(:,1001),[20,2,9],[nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(61),m4h2x2x8(:,77),heltab3x32(:,:,109))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1002),h0tab(:,1002),[20,2,9],[nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(62),m4h2x2x8(:,78),heltab3x32(:,:,110))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1003),h0tab(:,1003),[20,1,10],[nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(63),m4h2x2x8(:,79),heltab3x32(:,:,111))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1004),h0tab(:,1004),[20,1,10],[nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(64),m4h2x2x8(:,80),heltab3x32(:,:,112))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1005),h0tab(:,1005),[17,2,12],[0,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(65),ngPnl,m3h4x8(:,49),heltab2x32(:,:,893))
  call Hloop_Q_A(ntryL,G0H8(65),17,0,G1H8(99),n2h8(273))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1006),h0tab(:,1006),[17,2,12],[0,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(65),m3h4x8(:,50),heltab2x32(:,:,894))
  call Hloop_Q_A(ntryL,G0H8(65),17,0,G1H8(100),n2h8(274))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1007),h0tab(:,1007),[18,1,12],[0,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(65),ngPln,m3h4x8(:,51),heltab2x32(:,:,895))
  call Hloop_A_Q(ntryL,G0H8(65),18,0,G1H8(101),n2h8(275))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1008),h0tab(:,1008),[18,1,12],[0,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(65),m3h4x8(:,52),heltab2x32(:,:,896))
  call Hloop_A_Q(ntryL,G0H8(65),18,0,G1H8(102),n2h8(276))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1009),h0tab(:,1009),[16,5,10],[nML,nMH,nML],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,845),heltab2x32(:,:,897))
  call Hloop_A_Q(ntryL,G0H16(13),16,nML,G1H16(9),n2h16(201))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1010),h0tab(:,1010),[16,5,10],[nML,nMZ,nML],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,846),heltab2x32(:,:,898))
  call Hloop_A_Q(ntryL,G0H16(14),16,nML,G1H16(10),n2h16(202))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1011),h0tab(:,1011),[16,5,10],[nMW,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,847),heltab2x32(:,:,899))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1012),h0tab(:,1012),[16,5,10],[nML,0,nML],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,848),heltab2x32(:,:,900))
  call Hloop_A_Q(ntryL,G0H16(15),16,nML,G1H16(12),n2h16(203))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1013),h0tab(:,1013),[16,5,10],[nML,nMZ,nML],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,849),heltab2x32(:,:,901))
  call Hloop_A_Q(ntryL,G0H16(16),16,nML,G1H16(13),n2h16(204))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1014),h0tab(:,1014),[16,5,10],[nMW,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,850),heltab2x32(:,:,902))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1015),h0tab(:,1015),[16,5,10],[nMW,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,851),heltab2x32(:,:,903))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1016),h0tab(:,1016),[16,5,10],[nMW,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,852),heltab2x32(:,:,904))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1017),h0tab(:,1017),[18,5,8],[nMH,nML,nML],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(65),ngH,m3h4x8(:,53),heltab2x32(:,:,905))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1018),h0tab(:,1018),[18,5,8],[nMZ,nML,nML],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(66),ngX,m3h4x8(:,54),heltab2x32(:,:,906))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1019),h0tab(:,1019),[18,5,8],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(67),ngPln,m3h4x8(:,55),heltab2x32(:,:,907))
  call Hloop_A_Q(ntryL,G0H8(67),18,0,G1H8(109),n2h8(277))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1020),h0tab(:,1020),[18,5,8],[0,nML,nML],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(67),m3h4x8(:,56),heltab2x32(:,:,908))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1021),h0tab(:,1021),[18,5,8],[nMZ,nML,nML],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(68),ngZl,m3h4x8(:,57),heltab2x32(:,:,909))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1022),h0tab(:,1022),[18,5,8],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(69),m3h4x8(:,58),heltab2x32(:,:,910))
  call Hloop_A_Q(ntryL,G0H8(69),18,0,G1H8(110),n2h8(278))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1023),h0tab(:,1023),[18,5,8],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(69),ngPln,m3h4x8(:,59),heltab2x32(:,:,911))
  call Hloop_A_Q(ntryL,G0H8(69),18,0,G1H8(111),n2h8(279))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1024),h0tab(:,1024),[18,5,8],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(69),m3h4x8(:,60),heltab2x32(:,:,912))
  call Hloop_A_Q(ntryL,G0H8(69),18,0,G1H8(112),n2h8(280))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1025),h0tab(:,1025),[16,7,8],[nME,nME,nME],3,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,853),heltab2x32(:,:,913))
  call Hloop_A_Q(ntryL,G0H16(19),16,nME,G1H16(15),n2h16(205))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1026),h0tab(:,1026),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,854),heltab2x32(:,:,914))
  call Hloop_A_Q(ntryL,G0H16(20),16,nMM,G1H16(16),n2h16(206))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1027),h0tab(:,1027),[16,7,8],[nML,nML,nML],3,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,855),heltab2x32(:,:,915))
  call Hloop_A_Q(ntryL,G0H16(21),16,nML,G1H16(17),n2h16(207))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1028),h0tab(:,1028),[16,7,8],[nME,nME,nME],3,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,856),heltab2x32(:,:,916))
  call Hloop_Q_A(ntryL,G0H16(22),16,nME,G1H16(18),n2h16(208))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1029),h0tab(:,1029),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,857),heltab2x32(:,:,917))
  call Hloop_Q_A(ntryL,G0H16(23),16,nMM,G1H16(19),n2h16(209))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1030),h0tab(:,1030),[16,7,8],[nML,nML,nML],3,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,858),heltab2x32(:,:,918))
  call Hloop_Q_A(ntryL,G0H16(24),16,nML,G1H16(20),n2h16(210))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1031),h0tab(:,1031),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,859),heltab2x32(:,:,919))
  call Hloop_A_Q(ntryL,G0H16(6),16,nMT,G1H16(21),n2h16(211))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1032),h0tab(:,1032),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,860),heltab2x32(:,:,920))
  call Hloop_Q_A(ntryL,G0H16(8),16,nMT,G1H16(22),n2h16(212))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1033),h0tab(:,1033),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,861),heltab2x32(:,:,921))
  call Hloop_A_Q(ntryL,G0H16(10),16,nMB,G1H16(23),n2h16(213))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1034),h0tab(:,1034),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,862),heltab2x32(:,:,922))
  call Hloop_Q_A(ntryL,G0H16(12),16,nMB,G1H16(24),n2h16(214))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1035),h0tab(:,1035),[16,7,8],[nME,nME,nME],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,863),heltab2x32(:,:,923))
  call Hloop_A_Q(ntryL,G0H16(49),16,nME,G1H16(25),n2h16(215))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1036),h0tab(:,1036),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,864),heltab2x32(:,:,924))
  call Hloop_A_Q(ntryL,G0H16(50),16,nMM,G1H16(26),n2h16(216))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1037),h0tab(:,1037),[16,7,8],[nML,nML,nML],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,865),heltab2x32(:,:,925))
  call Hloop_A_Q(ntryL,G0H16(51),16,nML,G1H16(29),n2h16(217))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1038),h0tab(:,1038),[16,7,8],[nME,nME,nME],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,866),heltab2x32(:,:,926))
  call Hloop_Q_A(ntryL,G0H16(52),16,nME,G1H16(30),n2h16(218))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1039),h0tab(:,1039),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,867),heltab2x32(:,:,927))
  call Hloop_Q_A(ntryL,G0H16(53),16,nMM,G1H16(33),n2h16(219))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1040),h0tab(:,1040),[16,7,8],[nML,nML,nML],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,868),heltab2x32(:,:,928))
  call Hloop_Q_A(ntryL,G0H16(54),16,nML,G1H16(34),n2h16(220))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1041),h0tab(:,1041),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,869),heltab2x32(:,:,929))
  call Hloop_A_Q(ntryL,G0H16(55),16,nMT,G1H16(35),n2h16(221))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1042),h0tab(:,1042),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,870),heltab2x32(:,:,930))
  call Hloop_Q_A(ntryL,G0H16(56),16,nMT,G1H16(36),n2h16(222))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1043),h0tab(:,1043),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,871),heltab2x32(:,:,931))
  call Hloop_A_Q(ntryL,G0H16(57),16,nMB,G1H16(37),n2h16(223))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1044),h0tab(:,1044),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,872),heltab2x32(:,:,932))
  call Hloop_Q_A(ntryL,G0H16(58),16,nMB,G1H16(38),n2h16(224))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1045),h0tab(:,1045),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,873),heltab2x32(:,:,933))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1046),h0tab(:,1046),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,874),heltab2x32(:,:,934))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1047),h0tab(:,1047),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(42),m3h2x16(:,875),heltab2x32(:,:,935))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1048),h0tab(:,1048),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,876),heltab2x32(:,:,936))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1049),h0tab(:,1049),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(44),m3h2x16(:,877),heltab2x32(:,:,937))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1050),h0tab(:,1050),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,878),heltab2x32(:,:,938))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1051),h0tab(:,1051),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(46),m3h2x16(:,879),heltab2x32(:,:,939))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1052),h0tab(:,1052),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,880),heltab2x32(:,:,940))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1053),h0tab(:,1053),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(48),m3h2x16(:,881),heltab2x32(:,:,941))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1054),h0tab(:,1054),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,882),heltab2x32(:,:,942))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1055),h0tab(:,1055),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,883),heltab2x32(:,:,943))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1056),h0tab(:,1056),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,884),heltab2x32(:,:,944))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1057),h0tab(:,1057),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,885),heltab2x32(:,:,945))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1058),h0tab(:,1058),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,886),heltab2x32(:,:,946))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1059),h0tab(:,1059),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,887),heltab2x32(:,:,947))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1060),h0tab(:,1060),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,888),heltab2x32(:,:,948))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1061),h0tab(:,1061),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,889),heltab2x32(:,:,949))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1062),h0tab(:,1062),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,890),heltab2x32(:,:,950))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1063),h0tab(:,1063),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,891),heltab2x32(:,:,951))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1064),h0tab(:,1064),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,892),heltab2x32(:,:,952))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1065),h0tab(:,1065),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,893),heltab2x32(:,:,953))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1066),h0tab(:,1066),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,894),heltab2x32(:,:,954))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1067),h0tab(:,1067),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,895),heltab2x32(:,:,955))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1068),h0tab(:,1068),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(66),m3h2x16(:,896),heltab2x32(:,:,956))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1069),h0tab(:,1069),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,897),heltab2x32(:,:,957))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1070),h0tab(:,1070),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,898),heltab2x32(:,:,958))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1071),h0tab(:,1071),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,899),heltab2x32(:,:,959))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1072),h0tab(:,1072),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,900),heltab2x32(:,:,960))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1073),h0tab(:,1073),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,901),heltab2x32(:,:,961))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1074),h0tab(:,1074),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,902),heltab2x32(:,:,962))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1075),h0tab(:,1075),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(70),m3h2x16(:,903),heltab2x32(:,:,963))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1076),h0tab(:,1076),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(72),m3h2x16(:,904),heltab2x32(:,:,964))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1077),h0tab(:,1077),[16,7,8],[nME,nME,nME],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,905),heltab2x32(:,:,965))
  call Hloop_A_Q(ntryL,G0H16(74),16,nME,G1H16(61),n2h16(225))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1078),h0tab(:,1078),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,906),heltab2x32(:,:,966))
  call Hloop_A_Q(ntryL,G0H16(76),16,nMM,G1H16(62),n2h16(226))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1079),h0tab(:,1079),[16,7,8],[nML,nML,nML],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,907),heltab2x32(:,:,967))
  call Hloop_A_Q(ntryL,G0H16(77),16,nML,G1H16(67),n2h16(227))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1080),h0tab(:,1080),[16,7,8],[nME,nME,nME],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,908),heltab2x32(:,:,968))
  call Hloop_Q_A(ntryL,G0H16(78),16,nME,G1H16(64),n2h16(228))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1081),h0tab(:,1081),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,909),heltab2x32(:,:,969))
  call Hloop_Q_A(ntryL,G0H16(79),16,nMM,G1H16(69),n2h16(229))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1082),h0tab(:,1082),[16,7,8],[nML,nML,nML],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,910),heltab2x32(:,:,970))
  call Hloop_Q_A(ntryL,G0H16(80),16,nML,G1H16(66),n2h16(230))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1083),h0tab(:,1083),[16,7,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(81),m3h2x16(:,911),heltab2x32(:,:,971))
  call Hloop_A_Q(ntryL,G0H16(81),16,0,G1H16(68),n2h16(231))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1084),h0tab(:,1084),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,912),heltab2x32(:,:,972))
  call Hloop_A_Q(ntryL,G0H16(82),16,nMT,G1H16(70),n2h16(232))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1085),h0tab(:,1085),[16,7,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,913),heltab2x32(:,:,973))
  call Hloop_Q_A(ntryL,G0H16(83),16,0,G1H16(71),n2h16(233))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1086),h0tab(:,1086),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,914),heltab2x32(:,:,974))
  call Hloop_Q_A(ntryL,G0H16(84),16,nMT,G1H16(72),n2h16(234))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1087),h0tab(:,1087),[16,7,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,915),heltab2x32(:,:,975))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(73),n2h16(235))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1088),h0tab(:,1088),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,916),heltab2x32(:,:,976))
  call Hloop_A_Q(ntryL,G0H16(86),16,nMB,G1H16(74),n2h16(236))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1089),h0tab(:,1089),[16,7,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,917),heltab2x32(:,:,977))
  call Hloop_Q_A(ntryL,G0H16(87),16,0,G1H16(75),n2h16(237))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1090),h0tab(:,1090),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,918),heltab2x32(:,:,978))
  call Hloop_Q_A(ntryL,G0H16(88),16,nMB,G1H16(76),n2h16(238))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1091),h0tab(:,1091),[16,7,8],[nME,nME,nME],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,919),heltab2x32(:,:,979))
  call Hloop_A_Q(ntryL,G0H16(89),16,nME,G1H16(77),n2h16(239))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1092),h0tab(:,1092),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,920),heltab2x32(:,:,980))
  call Hloop_A_Q(ntryL,G0H16(90),16,nMM,G1H16(78),n2h16(240))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1093),h0tab(:,1093),[16,7,8],[nML,nML,nML],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,921),heltab2x32(:,:,981))
  call Hloop_A_Q(ntryL,G0H16(91),16,nML,G1H16(79),n2h16(241))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1094),h0tab(:,1094),[16,7,8],[nME,nME,nME],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,922),heltab2x32(:,:,982))
  call Hloop_Q_A(ntryL,G0H16(92),16,nME,G1H16(80),n2h16(242))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1095),h0tab(:,1095),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(93),m3h2x16(:,923),heltab2x32(:,:,983))
  call Hloop_Q_A(ntryL,G0H16(93),16,nMM,G1H16(81),n2h16(243))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1096),h0tab(:,1096),[16,7,8],[nML,nML,nML],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(94),m3h2x16(:,924),heltab2x32(:,:,984))
  call Hloop_Q_A(ntryL,G0H16(94),16,nML,G1H16(82),n2h16(244))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1097),h0tab(:,1097),[16,7,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,925),heltab2x32(:,:,985))
  call Hloop_A_Q(ntryL,G0H16(95),16,0,G1H16(83),n2h16(245))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1098),h0tab(:,1098),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,926),heltab2x32(:,:,986))
  call Hloop_A_Q(ntryL,G0H16(96),16,nMT,G1H16(84),n2h16(246))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1099),h0tab(:,1099),[16,7,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,927),heltab2x32(:,:,987))
  call Hloop_Q_A(ntryL,G0H16(98),16,0,G1H16(85),n2h16(247))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1100),h0tab(:,1100),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,928),heltab2x32(:,:,988))
  call Hloop_Q_A(ntryL,G0H16(100),16,nMT,G1H16(86),n2h16(248))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1101),h0tab(:,1101),[16,7,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,929),heltab2x32(:,:,989))
  call Hloop_A_Q(ntryL,G0H16(102),16,0,G1H16(87),n2h16(249))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1102),h0tab(:,1102),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,930),heltab2x32(:,:,990))
  call Hloop_A_Q(ntryL,G0H16(104),16,nMB,G1H16(88),n2h16(250))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1103),h0tab(:,1103),[16,7,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(105),m3h2x16(:,931),heltab2x32(:,:,991))
  call Hloop_Q_A(ntryL,G0H16(105),16,0,G1H16(91),n2h16(251))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1104),h0tab(:,1104),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(106),m3h2x16(:,932),heltab2x32(:,:,992))
  call Hloop_Q_A(ntryL,G0H16(106),16,nMB,G1H16(92),n2h16(252))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1105),h0tab(:,1105),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(95),m3h2x16(:,933),heltab2x32(:,:,993))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1106),h0tab(:,1106),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(96),m3h2x16(:,934),heltab2x32(:,:,994))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1107),h0tab(:,1107),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,935),heltab2x32(:,:,995))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1108),h0tab(:,1108),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(98),m3h2x16(:,936),heltab2x32(:,:,996))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1109),h0tab(:,1109),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(99),m3h2x16(:,937),heltab2x32(:,:,997))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1110),h0tab(:,1110),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,938),heltab2x32(:,:,998))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1111),h0tab(:,1111),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(101),m3h2x16(:,939),heltab2x32(:,:,999))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1112),h0tab(:,1112),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,940),heltab2x32(:,:,1000))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1113),h0tab(:,1113),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(103),m3h2x16(:,941),heltab2x32(:,:,1001))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1114),h0tab(:,1114),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(104),m3h2x16(:,942),heltab2x32(:,:,1002))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1115),h0tab(:,1115),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(105),m3h2x16(:,943),heltab2x32(:,:,1003))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1116),h0tab(:,1116),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(106),m3h2x16(:,944),heltab2x32(:,:,1004))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1117),h0tab(:,1117),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(107),m3h2x16(:,945),heltab2x32(:,:,1005))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1118),h0tab(:,1118),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,946),heltab2x32(:,:,1006))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1119),h0tab(:,1119),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(109),m3h2x16(:,947),heltab2x32(:,:,1007))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1120),h0tab(:,1120),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(110),m3h2x16(:,948),heltab2x32(:,:,1008))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1121),h0tab(:,1121),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(107),m3h2x16(:,949),heltab2x32(:,:,1009))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1122),h0tab(:,1122),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(108),m3h2x16(:,950),heltab2x32(:,:,1010))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1123),h0tab(:,1123),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(109),m3h2x16(:,951),heltab2x32(:,:,1011))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1124),h0tab(:,1124),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(110),m3h2x16(:,952),heltab2x32(:,:,1012))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1125),h0tab(:,1125),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,953),heltab2x32(:,:,1013))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1126),h0tab(:,1126),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(112),m3h2x16(:,954),heltab2x32(:,:,1014))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1127),h0tab(:,1127),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(113),m3h2x16(:,955),heltab2x32(:,:,1015))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1128),h0tab(:,1128),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(114),m3h2x16(:,956),heltab2x32(:,:,1016))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1129),h0tab(:,1129),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(111),m3h2x16(:,957),heltab2x32(:,:,1017))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1130),h0tab(:,1130),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(112),m3h2x16(:,958),heltab2x32(:,:,1018))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1131),h0tab(:,1131),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(113),m3h2x16(:,959),heltab2x32(:,:,1019))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1132),h0tab(:,1132),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(114),m3h2x16(:,960),heltab2x32(:,:,1020))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1133),h0tab(:,1133),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(115),m3h2x16(:,961),heltab2x32(:,:,1021))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1134),h0tab(:,1134),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(116),m3h2x16(:,962),heltab2x32(:,:,1022))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1135),h0tab(:,1135),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,963),heltab2x32(:,:,1023))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1136),h0tab(:,1136),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(118),m3h2x16(:,964),heltab2x32(:,:,1024))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1137),h0tab(:,1137),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(115),m3h2x16(:,965),heltab2x32(:,:,1025))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1138),h0tab(:,1138),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(116),m3h2x16(:,966),heltab2x32(:,:,1026))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1139),h0tab(:,1139),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(117),m3h2x16(:,967),heltab2x32(:,:,1027))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1140),h0tab(:,1140),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(118),m3h2x16(:,968),heltab2x32(:,:,1028))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1141),h0tab(:,1141),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(119),m3h2x16(:,969),heltab2x32(:,:,1029))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1142),h0tab(:,1142),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(120),m3h2x16(:,970),heltab2x32(:,:,1030))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1143),h0tab(:,1143),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(121),m3h2x16(:,971),heltab2x32(:,:,1031))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1144),h0tab(:,1144),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(122),m3h2x16(:,972),heltab2x32(:,:,1032))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1145),h0tab(:,1145),[16,2,13],[nML,nMH,nML],3,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(123),m3h2x16(:,973),heltab2x32(:,:,1033))
  call Hloop_Q_A(ntryL,G0H16(123),16,nML,G1H16(119),n2h16(253))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1146),h0tab(:,1146),[16,2,13],[nML,nMZ,nML],3,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(124),m3h2x16(:,974),heltab2x32(:,:,1034))
  call Hloop_Q_A(ntryL,G0H16(124),16,nML,G1H16(120),n2h16(254))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1147),h0tab(:,1147),[16,2,13],[nMW,0,nMW],3,1,wf8(:,31))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,975),heltab2x32(:,:,1035))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1148),h0tab(:,1148),[16,2,13],[nML,0,nML],3,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(126),m3h2x16(:,976),heltab2x32(:,:,1036))
  call Hloop_Q_A(ntryL,G0H16(126),16,nML,G1H16(122),n2h16(255))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1149),h0tab(:,1149),[16,2,13],[nML,nMZ,nML],3,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(128),m3h2x16(:,977),heltab2x32(:,:,1037))
  call Hloop_Q_A(ntryL,G0H16(128),16,nML,G1H16(123),n2h16(256))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1150),h0tab(:,1150),[16,2,13],[nMW,0,nMW],3,1,wf8(:,31))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(130),m3h2x16(:,978),heltab2x32(:,:,1038))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1151),h0tab(:,1151),[16,2,13],[nMW,0,nMW],3,1,wf8(:,31))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(132),m3h2x16(:,979),heltab2x32(:,:,1039))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1152),h0tab(:,1152),[16,2,13],[nMW,0,nMW],3,1,wf8(:,31))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(124),m3h2x16(:,980),heltab2x32(:,:,1040))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1153),h0tab(:,1153),[21,2,8],[nMH,nML,nML],3,1,wf8(:,28))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,28),G0H4(16),ngH,m3h8x4(:,1),heltab2x32(:,:,1041))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1154),h0tab(:,1154),[21,2,8],[nMZ,nML,nML],3,1,wf8(:,28))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,28),G0H4(15),ngX,m3h8x4(:,2),heltab2x32(:,:,1042))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1155),h0tab(:,1155),[21,2,8],[0,nMW,nMW],3,1,wf8(:,28))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(14),ngPnl,m3h8x4(:,3),heltab2x32(:,:,1043))
  call Hloop_Q_A(ntryL,G0H4(14),21,0,G1H4(246),n2h4(297))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1156),h0tab(:,1156),[21,2,8],[0,nML,nML],3,1,wf8(:,28))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,28),G0H4(13),m3h8x4(:,4),heltab2x32(:,:,1044))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1157),h0tab(:,1157),[21,2,8],[nMZ,nML,nML],3,1,wf8(:,28))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,28),G0H4(5),ngZl,m3h8x4(:,5),heltab2x32(:,:,1045))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1158),h0tab(:,1158),[21,2,8],[0,nMW,nMW],3,1,wf8(:,28))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(6),m3h8x4(:,6),heltab2x32(:,:,1046))
  call Hloop_Q_A(ntryL,G0H4(6),21,0,G1H4(103),n2h4(298))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1159),h0tab(:,1159),[21,2,8],[0,nMW,nMW],3,1,wf8(:,28))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(23),ngPnl,m3h8x4(:,7),heltab2x32(:,:,1047))
  call Hloop_Q_A(ntryL,G0H4(23),21,0,G1H4(109),n2h4(299))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1160),h0tab(:,1160),[21,2,8],[0,nMW,nMW],3,1,wf8(:,28))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(24),m3h8x4(:,8),heltab2x32(:,:,1048))
  call Hloop_Q_A(ntryL,G0H4(24),21,0,G1H4(71),n2h4(300))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1161),h0tab(:,1161),[16,6,9],[nML,nMH,nML],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(133),m3h2x16(:,981),heltab2x32(:,:,1049))
  call Hloop_Q_A(ntryL,G0H16(133),16,nML,G1H16(125),n2h16(257))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1162),h0tab(:,1162),[16,6,9],[nML,nMZ,nML],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(134),m3h2x16(:,982),heltab2x32(:,:,1050))
  call Hloop_Q_A(ntryL,G0H16(134),16,nML,G1H16(126),n2h16(258))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1163),h0tab(:,1163),[16,6,9],[nMW,0,nMW],3,2,wf4(:,10),wf4(:,9))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(127),m3h2x16(:,983),heltab2x32(:,:,1051))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1164),h0tab(:,1164),[16,6,9],[nML,0,nML],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(135),m3h2x16(:,984),heltab2x32(:,:,1052))
  call Hloop_Q_A(ntryL,G0H16(135),16,nML,G1H16(128),n2h16(259))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1165),h0tab(:,1165),[16,6,9],[nML,nMZ,nML],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(136),m3h2x16(:,985),heltab2x32(:,:,1053))
  call Hloop_Q_A(ntryL,G0H16(136),16,nML,G1H16(129),n2h16(260))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1166),h0tab(:,1166),[16,6,9],[nMW,0,nMW],3,2,wf4(:,10),wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(137),m3h2x16(:,986),heltab2x32(:,:,1054))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1167),h0tab(:,1167),[16,6,9],[nMW,0,nMW],3,2,wf4(:,10),wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(138),m3h2x16(:,987),heltab2x32(:,:,1055))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1168),h0tab(:,1168),[16,6,9],[nMW,0,nMW],3,2,wf4(:,10),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(130),m3h2x16(:,988),heltab2x32(:,:,1056))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1169),h0tab(:,1169),[17,6,8],[nMH,nML,nML],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(69),ngH,m3h4x8(:,61),heltab2x32(:,:,1057))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1170),h0tab(:,1170),[17,6,8],[nMZ,nML,nML],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(70),ngX,m3h4x8(:,62),heltab2x32(:,:,1058))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1171),h0tab(:,1171),[17,6,8],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(71),ngPnl,m3h4x8(:,63),heltab2x32(:,:,1059))
  call Hloop_Q_A(ntryL,G0H8(71),17,0,G1H8(113),n2h8(281))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1172),h0tab(:,1172),[17,6,8],[0,nML,nML],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(71),m3h4x8(:,64),heltab2x32(:,:,1060))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1173),h0tab(:,1173),[17,6,8],[nMZ,nML,nML],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(72),ngZl,m3h4x8(:,65),heltab2x32(:,:,1061))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1174),h0tab(:,1174),[17,6,8],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(73),ngPnl,m3h4x8(:,66),heltab2x32(:,:,1062))
  call Hloop_Q_A(ntryL,G0H8(73),17,0,G1H8(114),n2h8(282))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1175),h0tab(:,1175),[17,6,8],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(73),m3h4x8(:,67),heltab2x32(:,:,1063))
  call Hloop_Q_A(ntryL,G0H8(73),17,0,G1H8(121),n2h8(283))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1176),h0tab(:,1176),[17,6,8],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(73),m3h4x8(:,68),heltab2x32(:,:,1064))
  call Hloop_Q_A(ntryL,G0H8(73),17,0,G1H8(122),n2h8(284))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1177),h0tab(:,1177),[16,7,8],[nME,nME,nME],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(139),m3h2x16(:,989),heltab2x32(:,:,1065))
  call Hloop_A_Q(ntryL,G0H16(139),16,nME,G1H16(131),n2h16(261))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1178),h0tab(:,1178),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(140),m3h2x16(:,990),heltab2x32(:,:,1066))
  call Hloop_A_Q(ntryL,G0H16(140),16,nMM,G1H16(132),n2h16(262))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1179),h0tab(:,1179),[16,7,8],[nML,nML,nML],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,991),heltab2x32(:,:,1067))
  call Hloop_A_Q(ntryL,G0H16(141),16,nML,G1H16(133),n2h16(263))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1180),h0tab(:,1180),[16,7,8],[nME,nME,nME],3,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(142),m3h2x16(:,992),heltab2x32(:,:,1068))
  call Hloop_Q_A(ntryL,G0H16(142),16,nME,G1H16(134),n2h16(264))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1181),h0tab(:,1181),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(143),m3h2x16(:,993),heltab2x32(:,:,1069))
  call Hloop_Q_A(ntryL,G0H16(143),16,nMM,G1H16(135),n2h16(265))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1182),h0tab(:,1182),[16,7,8],[nML,nML,nML],3,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(144),m3h2x16(:,994),heltab2x32(:,:,1070))
  call Hloop_Q_A(ntryL,G0H16(144),16,nML,G1H16(136),n2h16(266))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1183),h0tab(:,1183),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(145),m3h2x16(:,995),heltab2x32(:,:,1071))
  call Hloop_A_Q(ntryL,G0H16(145),16,nMT,G1H16(137),n2h16(267))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1184),h0tab(:,1184),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(146),m3h2x16(:,996),heltab2x32(:,:,1072))
  call Hloop_Q_A(ntryL,G0H16(146),16,nMT,G1H16(138),n2h16(268))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1185),h0tab(:,1185),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(147),m3h2x16(:,997),heltab2x32(:,:,1073))
  call Hloop_A_Q(ntryL,G0H16(147),16,nMB,G1H16(139),n2h16(269))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1186),h0tab(:,1186),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(148),m3h2x16(:,998),heltab2x32(:,:,1074))
  call Hloop_Q_A(ntryL,G0H16(148),16,nMB,G1H16(140),n2h16(270))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1187),h0tab(:,1187),[16,7,8],[nME,nME,nME],3,1,wf8(:,47))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(149),m3h2x16(:,999),heltab2x32(:,:,1075))
  call Hloop_A_Q(ntryL,G0H16(149),16,nME,G1H16(141),n2h16(271))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1188),h0tab(:,1188),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,47))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(150),m3h2x16(:,1000),heltab2x32(:,:,1076))
  call Hloop_A_Q(ntryL,G0H16(150),16,nMM,G1H16(142),n2h16(272))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1189),h0tab(:,1189),[16,7,8],[nML,nML,nML],3,1,wf8(:,47))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(151),m3h2x16(:,1001),heltab2x32(:,:,1077))
  call Hloop_A_Q(ntryL,G0H16(151),16,nML,G1H16(143),n2h16(273))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1190),h0tab(:,1190),[16,7,8],[nME,nME,nME],3,1,wf8(:,47))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(152),m3h2x16(:,1002),heltab2x32(:,:,1078))
  call Hloop_Q_A(ntryL,G0H16(152),16,nME,G1H16(144),n2h16(274))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1191),h0tab(:,1191),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,47))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(154),m3h2x16(:,1003),heltab2x32(:,:,1079))
  call Hloop_Q_A(ntryL,G0H16(154),16,nMM,G1H16(145),n2h16(275))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1192),h0tab(:,1192),[16,7,8],[nML,nML,nML],3,1,wf8(:,47))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(156),m3h2x16(:,1004),heltab2x32(:,:,1080))
  call Hloop_Q_A(ntryL,G0H16(156),16,nML,G1H16(146),n2h16(276))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1193),h0tab(:,1193),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,47))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(158),m3h2x16(:,1005),heltab2x32(:,:,1081))
  call Hloop_A_Q(ntryL,G0H16(158),16,nMT,G1H16(149),n2h16(277))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1194),h0tab(:,1194),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,47))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(160),m3h2x16(:,1006),heltab2x32(:,:,1082))
  call Hloop_Q_A(ntryL,G0H16(160),16,nMT,G1H16(150),n2h16(278))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1195),h0tab(:,1195),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,47))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(161),m3h2x16(:,1007),heltab2x32(:,:,1083))
  call Hloop_A_Q(ntryL,G0H16(161),16,nMB,G1H16(153),n2h16(279))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1196),h0tab(:,1196),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,47))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(162),m3h2x16(:,1008),heltab2x32(:,:,1084))
  call Hloop_Q_A(ntryL,G0H16(162),16,nMB,G1H16(154),n2h16(280))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1197),h0tab(:,1197),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(155),m3h2x16(:,1009),heltab2x32(:,:,1085))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1198),h0tab(:,1198),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(156),m3h2x16(:,1010),heltab2x32(:,:,1086))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1199),h0tab(:,1199),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(157),m3h2x16(:,1011),heltab2x32(:,:,1087))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1200),h0tab(:,1200),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(158),m3h2x16(:,1012),heltab2x32(:,:,1088))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1201),h0tab(:,1201),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(159),m3h2x16(:,1013),heltab2x32(:,:,1089))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1202),h0tab(:,1202),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(160),m3h2x16(:,1014),heltab2x32(:,:,1090))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1203),h0tab(:,1203),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(162),m3h2x16(:,1015),heltab2x32(:,:,1091))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1204),h0tab(:,1204),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(163),m3h2x16(:,1016),heltab2x32(:,:,1092))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1205),h0tab(:,1205),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(164),m3h2x16(:,1017),heltab2x32(:,:,1093))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1206),h0tab(:,1206),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(165),m3h2x16(:,1018),heltab2x32(:,:,1094))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1207),h0tab(:,1207),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(166),m3h2x16(:,1019),heltab2x32(:,:,1095))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1208),h0tab(:,1208),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(167),m3h2x16(:,1020),heltab2x32(:,:,1096))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1209),h0tab(:,1209),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(163),m3h2x16(:,1021),heltab2x32(:,:,1097))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1210),h0tab(:,1210),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(164),m3h2x16(:,1022),heltab2x32(:,:,1098))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1211),h0tab(:,1211),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(165),m3h2x16(:,1023),heltab2x32(:,:,1099))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1212),h0tab(:,1212),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(166),m3h2x16(:,1024),heltab2x32(:,:,1100))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1213),h0tab(:,1213),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(168),m3h2x16(:,1025),heltab2x32(:,:,1101))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1214),h0tab(:,1214),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(169),m3h2x16(:,1026),heltab2x32(:,:,1102))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1215),h0tab(:,1215),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(170),m3h2x16(:,1027),heltab2x32(:,:,1103))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1216),h0tab(:,1216),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(172),m3h2x16(:,1028),heltab2x32(:,:,1104))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1217),h0tab(:,1217),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(167),m3h2x16(:,1029),heltab2x32(:,:,1105))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1218),h0tab(:,1218),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(168),m3h2x16(:,1030),heltab2x32(:,:,1106))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1219),h0tab(:,1219),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(169),m3h2x16(:,1031),heltab2x32(:,:,1107))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1220),h0tab(:,1220),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(170),m3h2x16(:,1032),heltab2x32(:,:,1108))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1221),h0tab(:,1221),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(173),m3h2x16(:,1033),heltab2x32(:,:,1109))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1222),h0tab(:,1222),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(174),m3h2x16(:,1034),heltab2x32(:,:,1110))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1223),h0tab(:,1223),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(175),m3h2x16(:,1035),heltab2x32(:,:,1111))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1224),h0tab(:,1224),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(176),m3h2x16(:,1036),heltab2x32(:,:,1112))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1225),h0tab(:,1225),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(171),m3h2x16(:,1037),heltab2x32(:,:,1113))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1226),h0tab(:,1226),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(172),m3h2x16(:,1038),heltab2x32(:,:,1114))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1227),h0tab(:,1227),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,1039),heltab2x32(:,:,1115))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1228),h0tab(:,1228),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(174),m3h2x16(:,1040),heltab2x32(:,:,1116))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1229),h0tab(:,1229),[16,7,8],[nME,nME,nME],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,1041),heltab2x32(:,:,1117))
  call Hloop_A_Q(ntryL,G0H16(175),16,nME,G1H16(177),n2h16(281))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1230),h0tab(:,1230),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(176),m3h2x16(:,1042),heltab2x32(:,:,1118))
  call Hloop_A_Q(ntryL,G0H16(176),16,nMM,G1H16(178),n2h16(282))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1231),h0tab(:,1231),[16,7,8],[nML,nML,nML],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,1043),heltab2x32(:,:,1119))
  call Hloop_A_Q(ntryL,G0H16(177),16,nML,G1H16(179),n2h16(283))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1232),h0tab(:,1232),[16,7,8],[nME,nME,nME],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(178),m3h2x16(:,1044),heltab2x32(:,:,1120))
  call Hloop_Q_A(ntryL,G0H16(178),16,nME,G1H16(180),n2h16(284))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1233),h0tab(:,1233),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,1045),heltab2x32(:,:,1121))
  call Hloop_Q_A(ntryL,G0H16(179),16,nMM,G1H16(181),n2h16(285))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1234),h0tab(:,1234),[16,7,8],[nML,nML,nML],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(180),m3h2x16(:,1046),heltab2x32(:,:,1122))
  call Hloop_Q_A(ntryL,G0H16(180),16,nML,G1H16(182),n2h16(286))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1235),h0tab(:,1235),[16,7,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,1047),heltab2x32(:,:,1123))
  call Hloop_A_Q(ntryL,G0H16(181),16,0,G1H16(187),n2h16(287))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1236),h0tab(:,1236),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(182),m3h2x16(:,1048),heltab2x32(:,:,1124))
  call Hloop_A_Q(ntryL,G0H16(182),16,nMT,G1H16(184),n2h16(288))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1237),h0tab(:,1237),[16,7,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(183),m3h2x16(:,1049),heltab2x32(:,:,1125))
  call Hloop_Q_A(ntryL,G0H16(183),16,0,G1H16(189),n2h16(289))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1238),h0tab(:,1238),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(184),m3h2x16(:,1050),heltab2x32(:,:,1126))
  call Hloop_Q_A(ntryL,G0H16(184),16,nMT,G1H16(186),n2h16(290))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1239),h0tab(:,1239),[16,7,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,1051),heltab2x32(:,:,1127))
  call Hloop_A_Q(ntryL,G0H16(185),16,0,G1H16(188),n2h16(291))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1240),h0tab(:,1240),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(186),m3h2x16(:,1052),heltab2x32(:,:,1128))
  call Hloop_A_Q(ntryL,G0H16(186),16,nMB,G1H16(190),n2h16(292))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1241),h0tab(:,1241),[16,7,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(187),m3h2x16(:,1053),heltab2x32(:,:,1129))
  call Hloop_Q_A(ntryL,G0H16(187),16,0,G1H16(191),n2h16(293))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1242),h0tab(:,1242),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(188),m3h2x16(:,1054),heltab2x32(:,:,1130))
  call Hloop_Q_A(ntryL,G0H16(188),16,nMB,G1H16(192),n2h16(294))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1243),h0tab(:,1243),[16,7,8],[nME,nME,nME],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,1055),heltab2x32(:,:,1131))
  call Hloop_A_Q(ntryL,G0H16(189),16,nME,G1H16(193),n2h16(295))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1244),h0tab(:,1244),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(190),m3h2x16(:,1056),heltab2x32(:,:,1132))
  call Hloop_A_Q(ntryL,G0H16(190),16,nMM,G1H16(194),n2h16(296))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1245),h0tab(:,1245),[16,7,8],[nML,nML,nML],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(191),m3h2x16(:,1057),heltab2x32(:,:,1133))
  call Hloop_A_Q(ntryL,G0H16(191),16,nML,G1H16(195),n2h16(297))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1246),h0tab(:,1246),[16,7,8],[nME,nME,nME],3,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(192),m3h2x16(:,1058),heltab2x32(:,:,1134))
  call Hloop_Q_A(ntryL,G0H16(192),16,nME,G1H16(196),n2h16(298))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1247),h0tab(:,1247),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,1059),heltab2x32(:,:,1135))
  call Hloop_Q_A(ntryL,G0H16(193),16,nMM,G1H16(197),n2h16(299))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1248),h0tab(:,1248),[16,7,8],[nML,nML,nML],3,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(194),m3h2x16(:,1060),heltab2x32(:,:,1136))
  call Hloop_Q_A(ntryL,G0H16(194),16,nML,G1H16(198),n2h16(300))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1249),h0tab(:,1249),[16,7,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,1061),heltab2x32(:,:,1137))
  call Hloop_A_Q(ntryL,G0H16(195),16,0,G1H16(199),n2h16(301))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1250),h0tab(:,1250),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(196),m3h2x16(:,1062),heltab2x32(:,:,1138))
  call Hloop_A_Q(ntryL,G0H16(196),16,nMT,G1H16(200),n2h16(302))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1251),h0tab(:,1251),[16,7,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,1063),heltab2x32(:,:,1139))
  call Hloop_Q_A(ntryL,G0H16(197),16,0,G1H16(201),n2h16(303))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1252),h0tab(:,1252),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(198),m3h2x16(:,1064),heltab2x32(:,:,1140))
  call Hloop_Q_A(ntryL,G0H16(198),16,nMT,G1H16(202),n2h16(304))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1253),h0tab(:,1253),[16,7,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,1065),heltab2x32(:,:,1141))
  call Hloop_A_Q(ntryL,G0H16(199),16,0,G1H16(203),n2h16(305))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1254),h0tab(:,1254),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(200),m3h2x16(:,1066),heltab2x32(:,:,1142))
  call Hloop_A_Q(ntryL,G0H16(200),16,nMB,G1H16(204),n2h16(306))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1255),h0tab(:,1255),[16,7,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,1067),heltab2x32(:,:,1143))
  call Hloop_Q_A(ntryL,G0H16(201),16,0,G1H16(205),n2h16(307))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1256),h0tab(:,1256),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(202),m3h2x16(:,1068),heltab2x32(:,:,1144))
  call Hloop_Q_A(ntryL,G0H16(202),16,nMB,G1H16(206),n2h16(308))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1257),h0tab(:,1257),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(207),m3h2x16(:,1069),heltab2x32(:,:,1145))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1258),h0tab(:,1258),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(208),m3h2x16(:,1070),heltab2x32(:,:,1146))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1259),h0tab(:,1259),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(211),m3h2x16(:,1071),heltab2x32(:,:,1147))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1260),h0tab(:,1260),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(212),m3h2x16(:,1072),heltab2x32(:,:,1148))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1261),h0tab(:,1261),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(215),m3h2x16(:,1073),heltab2x32(:,:,1149))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1262),h0tab(:,1262),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(216),m3h2x16(:,1074),heltab2x32(:,:,1150))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1263),h0tab(:,1263),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(217),m3h2x16(:,1075),heltab2x32(:,:,1151))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1264),h0tab(:,1264),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(218),m3h2x16(:,1076),heltab2x32(:,:,1152))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1265),h0tab(:,1265),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(219),m3h2x16(:,1077),heltab2x32(:,:,1153))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1266),h0tab(:,1266),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(220),m3h2x16(:,1078),heltab2x32(:,:,1154))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1267),h0tab(:,1267),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(221),m3h2x16(:,1079),heltab2x32(:,:,1155))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1268),h0tab(:,1268),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(222),m3h2x16(:,1080),heltab2x32(:,:,1156))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1269),h0tab(:,1269),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(223),m3h2x16(:,1081),heltab2x32(:,:,1157))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1270),h0tab(:,1270),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(224),m3h2x16(:,1082),heltab2x32(:,:,1158))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1271),h0tab(:,1271),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(225),m3h2x16(:,1083),heltab2x32(:,:,1159))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1272),h0tab(:,1272),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(226),m3h2x16(:,1084),heltab2x32(:,:,1160))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1273),h0tab(:,1273),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(203),m3h2x16(:,1085),heltab2x32(:,:,1161))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1274),h0tab(:,1274),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(204),m3h2x16(:,1086),heltab2x32(:,:,1162))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1275),h0tab(:,1275),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,1087),heltab2x32(:,:,1163))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1276),h0tab(:,1276),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,1088),heltab2x32(:,:,1164))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1277),h0tab(:,1277),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(227),m3h2x16(:,1089),heltab2x32(:,:,1165))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1278),h0tab(:,1278),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(228),m3h2x16(:,1090),heltab2x32(:,:,1166))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1279),h0tab(:,1279),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(229),m3h2x16(:,1091),heltab2x32(:,:,1167))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1280),h0tab(:,1280),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(230),m3h2x16(:,1092),heltab2x32(:,:,1168))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1281),h0tab(:,1281),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,1093),heltab2x32(:,:,1169))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1282),h0tab(:,1282),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,1094),heltab2x32(:,:,1170))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1283),h0tab(:,1283),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,1095),heltab2x32(:,:,1171))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1284),h0tab(:,1284),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,1096),heltab2x32(:,:,1172))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1285),h0tab(:,1285),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,1097),heltab2x32(:,:,1173))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1286),h0tab(:,1286),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,1098),heltab2x32(:,:,1174))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1287),h0tab(:,1287),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,1099),heltab2x32(:,:,1175))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1288),h0tab(:,1288),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,1100),heltab2x32(:,:,1176))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1289),h0tab(:,1289),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(231),m3h2x16(:,1101),heltab2x32(:,:,1177))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1290),h0tab(:,1290),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(232),m3h2x16(:,1102),heltab2x32(:,:,1178))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1291),h0tab(:,1291),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(233),m3h2x16(:,1103),heltab2x32(:,:,1179))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1292),h0tab(:,1292),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(234),m3h2x16(:,1104),heltab2x32(:,:,1180))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1293),h0tab(:,1293),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,1105),heltab2x32(:,:,1181))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1294),h0tab(:,1294),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,1106),heltab2x32(:,:,1182))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1295),h0tab(:,1295),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,1107),heltab2x32(:,:,1183))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1296),h0tab(:,1296),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,1108),heltab2x32(:,:,1184))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1297),h0tab(:,1297),[16,1,14],[nML,nMH,nML],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,1109),heltab2x32(:,:,1185))
  call Hloop_A_Q(ntryL,G0H16(49),16,nML,G1H16(235),n2h16(309))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1298),h0tab(:,1298),[16,1,14],[nML,nMZ,nML],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,1110),heltab2x32(:,:,1186))
  call Hloop_A_Q(ntryL,G0H16(50),16,nML,G1H16(236),n2h16(310))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1299),h0tab(:,1299),[16,1,14],[nMW,0,nMW],3,1,wf8(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(237),m3h2x16(:,1111),heltab2x32(:,:,1187))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1300),h0tab(:,1300),[16,1,14],[nML,0,nML],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,1112),heltab2x32(:,:,1188))
  call Hloop_A_Q(ntryL,G0H16(51),16,nML,G1H16(238),n2h16(311))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1301),h0tab(:,1301),[16,1,14],[nML,nMZ,nML],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,1113),heltab2x32(:,:,1189))
  call Hloop_A_Q(ntryL,G0H16(52),16,nML,G1H16(239),n2h16(312))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1302),h0tab(:,1302),[16,1,14],[nMW,0,nMW],3,1,wf8(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,1114),heltab2x32(:,:,1190))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1303),h0tab(:,1303),[16,1,14],[nMW,0,nMW],3,1,wf8(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,1115),heltab2x32(:,:,1191))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1304),h0tab(:,1304),[16,1,14],[nMW,0,nMW],3,1,wf8(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(240),m3h2x16(:,1116),heltab2x32(:,:,1192))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1305),h0tab(:,1305),[22,1,8],[nMH,nML,nML],3,1,wf8(:,33))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,33),G0H4(36),ngH,m3h8x4(:,9),heltab2x32(:,:,1193))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1306),h0tab(:,1306),[22,1,8],[nMZ,nML,nML],3,1,wf8(:,33))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,33),G0H4(14),ngX,m3h8x4(:,10),heltab2x32(:,:,1194))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1307),h0tab(:,1307),[22,1,8],[0,nMW,nMW],3,1,wf8(:,33))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(6),ngPln,m3h8x4(:,11),heltab2x32(:,:,1195))
  call Hloop_A_Q(ntryL,G0H4(6),22,0,G1H4(59),n2h4(301))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1308),h0tab(:,1308),[22,1,8],[0,nML,nML],3,1,wf8(:,33))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,33),G0H4(23),m3h8x4(:,12),heltab2x32(:,:,1196))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1309),h0tab(:,1309),[22,1,8],[nMZ,nML,nML],3,1,wf8(:,33))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,33),G0H4(24),ngZl,m3h8x4(:,13),heltab2x32(:,:,1197))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1310),h0tab(:,1310),[22,1,8],[0,nMW,nMW],3,1,wf8(:,33))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(6),m3h8x4(:,14),heltab2x32(:,:,1198))
  call Hloop_A_Q(ntryL,G0H4(6),22,0,G1H4(110),n2h4(302))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1311),h0tab(:,1311),[22,1,8],[0,nMW,nMW],3,1,wf8(:,33))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(6),ngPln,m3h8x4(:,15),heltab2x32(:,:,1199))
  call Hloop_A_Q(ntryL,G0H4(6),22,0,G1H4(115),n2h4(303))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1312),h0tab(:,1312),[22,1,8],[0,nMW,nMW],3,1,wf8(:,33))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(6),m3h8x4(:,16),heltab2x32(:,:,1200))
  call Hloop_A_Q(ntryL,G0H4(6),22,0,G1H4(153),n2h4(304))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1313),h0tab(:,1313),[18,4,9],[nML,nML,nMH],3,2,wf4(:,6),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(73),ngH,m3h4x8(:,69),heltab2x32(:,:,1201))
  call Hloop_A_Q(ntryL,G0H8(73),18,nML,G1H8(123),n2h8(285))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1314),h0tab(:,1314),[18,4,9],[nML,nML,nMZ],3,2,wf4(:,6),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(73),ngX,m3h4x8(:,70),heltab2x32(:,:,1202))
  call Hloop_A_Q(ntryL,G0H8(73),18,nML,G1H8(124),n2h8(286))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1315),h0tab(:,1315),[18,4,9],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(73),ngPln,m3h4x8(:,71),heltab2x32(:,:,1203))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1316),h0tab(:,1316),[18,4,9],[nML,nML,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(74),m3h4x8(:,72),heltab2x32(:,:,1204))
  call Hloop_A_Q(ntryL,G0H8(74),18,nML,G1H8(125),n2h8(287))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1317),h0tab(:,1317),[18,4,9],[nML,nML,nMZ],3,2,wf4(:,6),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(74),ngZl,m3h4x8(:,73),heltab2x32(:,:,1205))
  call Hloop_A_Q(ntryL,G0H8(74),18,nML,G1H8(126),n2h8(288))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1318),h0tab(:,1318),[18,4,9],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(74),m3h4x8(:,74),heltab2x32(:,:,1206))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1319),h0tab(:,1319),[18,4,9],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(75),ngPln,m3h4x8(:,75),heltab2x32(:,:,1207))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1320),h0tab(:,1320),[18,4,9],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(76),m3h4x8(:,76),heltab2x32(:,:,1208))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1321),h0tab(:,1321),[16,4,11],[nME,nME,nME],3,1,wf8(:,15))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,1117),heltab2x32(:,:,1209))
  call Hloop_Q_A(ntryL,G0H16(55),16,nME,G1H16(241),n2h16(313))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1322),h0tab(:,1322),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,15))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,1118),heltab2x32(:,:,1210))
  call Hloop_Q_A(ntryL,G0H16(56),16,nMM,G1H16(242),n2h16(314))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1323),h0tab(:,1323),[16,4,11],[nML,nML,nML],3,1,wf8(:,15))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,1119),heltab2x32(:,:,1211))
  call Hloop_Q_A(ntryL,G0H16(57),16,nML,G1H16(243),n2h16(315))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1324),h0tab(:,1324),[16,4,11],[nME,nME,nME],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,1120),heltab2x32(:,:,1212))
  call Hloop_A_Q(ntryL,G0H16(58),16,nME,G1H16(244),n2h16(316))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1325),h0tab(:,1325),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,1121),heltab2x32(:,:,1213))
  call Hloop_A_Q(ntryL,G0H16(74),16,nMM,G1H16(245),n2h16(317))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1326),h0tab(:,1326),[16,4,11],[nML,nML,nML],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,1122),heltab2x32(:,:,1214))
  call Hloop_A_Q(ntryL,G0H16(76),16,nML,G1H16(246),n2h16(318))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1327),h0tab(:,1327),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,15))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,1123),heltab2x32(:,:,1215))
  call Hloop_Q_A(ntryL,G0H16(77),16,nMT,G1H16(247),n2h16(319))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1328),h0tab(:,1328),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,1124),heltab2x32(:,:,1216))
  call Hloop_A_Q(ntryL,G0H16(78),16,nMT,G1H16(248),n2h16(320))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1329),h0tab(:,1329),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,15))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,1125),heltab2x32(:,:,1217))
  call Hloop_Q_A(ntryL,G0H16(79),16,nMB,G1H16(249),n2h16(321))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1330),h0tab(:,1330),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,1126),heltab2x32(:,:,1218))
  call Hloop_A_Q(ntryL,G0H16(80),16,nMB,G1H16(250),n2h16(322))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1331),h0tab(:,1331),[16,4,11],[nME,nME,nME],3,1,wf8(:,50))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(81),m3h2x16(:,1127),heltab2x32(:,:,1219))
  call Hloop_Q_A(ntryL,G0H16(81),16,nME,G1H16(251),n2h16(323))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1332),h0tab(:,1332),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,50))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,1128),heltab2x32(:,:,1220))
  call Hloop_Q_A(ntryL,G0H16(82),16,nMM,G1H16(252),n2h16(324))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1333),h0tab(:,1333),[16,4,11],[nML,nML,nML],3,1,wf8(:,50))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,1129),heltab2x32(:,:,1221))
  call Hloop_Q_A(ntryL,G0H16(83),16,nML,G1H16(253),n2h16(325))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1334),h0tab(:,1334),[16,4,11],[nME,nME,nME],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,1130),heltab2x32(:,:,1222))
  call Hloop_A_Q(ntryL,G0H16(84),16,nME,G1H16(254),n2h16(326))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1335),h0tab(:,1335),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,1131),heltab2x32(:,:,1223))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMM,G1H16(255),n2h16(327))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1336),h0tab(:,1336),[16,4,11],[nML,nML,nML],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,1132),heltab2x32(:,:,1224))
  call Hloop_A_Q(ntryL,G0H16(86),16,nML,G1H16(256),n2h16(328))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1337),h0tab(:,1337),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,50))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,1133),heltab2x32(:,:,1225))
  call Hloop_Q_A(ntryL,G0H16(87),16,nMT,G1H16(257),n2h16(329))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1338),h0tab(:,1338),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,1134),heltab2x32(:,:,1226))
  call Hloop_A_Q(ntryL,G0H16(88),16,nMT,G1H16(258),n2h16(330))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1339),h0tab(:,1339),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,50))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,1135),heltab2x32(:,:,1227))
  call Hloop_Q_A(ntryL,G0H16(89),16,nMB,G1H16(259),n2h16(331))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1340),h0tab(:,1340),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,1136),heltab2x32(:,:,1228))
  call Hloop_A_Q(ntryL,G0H16(90),16,nMB,G1H16(260),n2h16(332))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1341),h0tab(:,1341),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(261),m3h2x16(:,1137),heltab2x32(:,:,1229))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1342),h0tab(:,1342),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(262),m3h2x16(:,1138),heltab2x32(:,:,1230))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1343),h0tab(:,1343),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(263),m3h2x16(:,1139),heltab2x32(:,:,1231))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1344),h0tab(:,1344),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(264),m3h2x16(:,1140),heltab2x32(:,:,1232))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1345),h0tab(:,1345),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(265),m3h2x16(:,1141),heltab2x32(:,:,1233))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1346),h0tab(:,1346),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(266),m3h2x16(:,1142),heltab2x32(:,:,1234))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1347),h0tab(:,1347),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(269),m3h2x16(:,1143),heltab2x32(:,:,1235))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1348),h0tab(:,1348),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(270),m3h2x16(:,1144),heltab2x32(:,:,1236))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1349),h0tab(:,1349),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(273),m3h2x16(:,1145),heltab2x32(:,:,1237))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1350),h0tab(:,1350),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(274),m3h2x16(:,1146),heltab2x32(:,:,1238))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1351),h0tab(:,1351),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(275),m3h2x16(:,1147),heltab2x32(:,:,1239))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1352),h0tab(:,1352),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(276),m3h2x16(:,1148),heltab2x32(:,:,1240))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1353),h0tab(:,1353),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,1149),heltab2x32(:,:,1241))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1354),h0tab(:,1354),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,1150),heltab2x32(:,:,1242))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1355),h0tab(:,1355),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(93),m3h2x16(:,1151),heltab2x32(:,:,1243))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1356),h0tab(:,1356),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(94),m3h2x16(:,1152),heltab2x32(:,:,1244))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1357),h0tab(:,1357),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(277),m3h2x16(:,1153),heltab2x32(:,:,1245))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1358),h0tab(:,1358),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(278),m3h2x16(:,1154),heltab2x32(:,:,1246))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1359),h0tab(:,1359),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(279),m3h2x16(:,1155),heltab2x32(:,:,1247))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1360),h0tab(:,1360),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(280),m3h2x16(:,1156),heltab2x32(:,:,1248))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1361),h0tab(:,1361),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,1157),heltab2x32(:,:,1249))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1362),h0tab(:,1362),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,1158),heltab2x32(:,:,1250))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1363),h0tab(:,1363),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,1159),heltab2x32(:,:,1251))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1364),h0tab(:,1364),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,1160),heltab2x32(:,:,1252))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1365),h0tab(:,1365),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(281),m3h2x16(:,1161),heltab2x32(:,:,1253))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1366),h0tab(:,1366),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(282),m3h2x16(:,1162),heltab2x32(:,:,1254))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1367),h0tab(:,1367),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(283),m3h2x16(:,1163),heltab2x32(:,:,1255))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1368),h0tab(:,1368),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(284),m3h2x16(:,1164),heltab2x32(:,:,1256))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1369),h0tab(:,1369),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,1165),heltab2x32(:,:,1257))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1370),h0tab(:,1370),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,1166),heltab2x32(:,:,1258))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1371),h0tab(:,1371),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(105),m3h2x16(:,1167),heltab2x32(:,:,1259))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1372),h0tab(:,1372),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(106),m3h2x16(:,1168),heltab2x32(:,:,1260))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1373),h0tab(:,1373),[16,4,11],[nME,nME,nME],3,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(123),m3h2x16(:,1169),heltab2x32(:,:,1261))
  call Hloop_Q_A(ntryL,G0H16(123),16,nME,G1H16(286),n2h16(333))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1374),h0tab(:,1374),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(124),m3h2x16(:,1170),heltab2x32(:,:,1262))
  call Hloop_Q_A(ntryL,G0H16(124),16,nMM,G1H16(288),n2h16(334))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1375),h0tab(:,1375),[16,4,11],[nML,nML,nML],3,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(126),m3h2x16(:,1171),heltab2x32(:,:,1263))
  call Hloop_Q_A(ntryL,G0H16(126),16,nML,G1H16(289),n2h16(335))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1376),h0tab(:,1376),[16,4,11],[nME,nME,nME],3,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(128),m3h2x16(:,1172),heltab2x32(:,:,1264))
  call Hloop_A_Q(ntryL,G0H16(128),16,nME,G1H16(290),n2h16(336))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1377),h0tab(:,1377),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(133),m3h2x16(:,1173),heltab2x32(:,:,1265))
  call Hloop_A_Q(ntryL,G0H16(133),16,nMM,G1H16(291),n2h16(337))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1378),h0tab(:,1378),[16,4,11],[nML,nML,nML],3,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(134),m3h2x16(:,1174),heltab2x32(:,:,1266))
  call Hloop_A_Q(ntryL,G0H16(134),16,nML,G1H16(292),n2h16(338))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1379),h0tab(:,1379),[16,4,11],[0,0,0],3,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(135),m3h2x16(:,1175),heltab2x32(:,:,1267))
  call Hloop_Q_A(ntryL,G0H16(135),16,0,G1H16(293),n2h16(339))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1380),h0tab(:,1380),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(136),m3h2x16(:,1176),heltab2x32(:,:,1268))
  call Hloop_Q_A(ntryL,G0H16(136),16,nMT,G1H16(294),n2h16(340))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1381),h0tab(:,1381),[16,4,11],[0,0,0],3,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(139),m3h2x16(:,1177),heltab2x32(:,:,1269))
  call Hloop_A_Q(ntryL,G0H16(139),16,0,G1H16(295),n2h16(341))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1382),h0tab(:,1382),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(140),m3h2x16(:,1178),heltab2x32(:,:,1270))
  call Hloop_A_Q(ntryL,G0H16(140),16,nMT,G1H16(296),n2h16(342))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1383),h0tab(:,1383),[16,4,11],[0,0,0],3,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,1179),heltab2x32(:,:,1271))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(297),n2h16(343))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1384),h0tab(:,1384),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(142),m3h2x16(:,1180),heltab2x32(:,:,1272))
  call Hloop_Q_A(ntryL,G0H16(142),16,nMB,G1H16(298),n2h16(344))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1385),h0tab(:,1385),[16,4,11],[0,0,0],3,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(143),m3h2x16(:,1181),heltab2x32(:,:,1273))
  call Hloop_A_Q(ntryL,G0H16(143),16,0,G1H16(299),n2h16(345))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1386),h0tab(:,1386),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(144),m3h2x16(:,1182),heltab2x32(:,:,1274))
  call Hloop_A_Q(ntryL,G0H16(144),16,nMB,G1H16(300),n2h16(346))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1387),h0tab(:,1387),[16,4,11],[nME,nME,nME],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(145),m3h2x16(:,1183),heltab2x32(:,:,1275))
  call Hloop_Q_A(ntryL,G0H16(145),16,nME,G1H16(301),n2h16(347))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1388),h0tab(:,1388),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(146),m3h2x16(:,1184),heltab2x32(:,:,1276))
  call Hloop_Q_A(ntryL,G0H16(146),16,nMM,G1H16(302),n2h16(348))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1389),h0tab(:,1389),[16,4,11],[nML,nML,nML],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(147),m3h2x16(:,1185),heltab2x32(:,:,1277))
  call Hloop_Q_A(ntryL,G0H16(147),16,nML,G1H16(307),n2h16(349))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1390),h0tab(:,1390),[16,4,11],[nME,nME,nME],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(148),m3h2x16(:,1186),heltab2x32(:,:,1278))
  call Hloop_A_Q(ntryL,G0H16(148),16,nME,G1H16(304),n2h16(350))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1391),h0tab(:,1391),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(149),m3h2x16(:,1187),heltab2x32(:,:,1279))
  call Hloop_A_Q(ntryL,G0H16(149),16,nMM,G1H16(309),n2h16(351))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1392),h0tab(:,1392),[16,4,11],[nML,nML,nML],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(150),m3h2x16(:,1188),heltab2x32(:,:,1280))
  call Hloop_A_Q(ntryL,G0H16(150),16,nML,G1H16(306),n2h16(352))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1393),h0tab(:,1393),[16,4,11],[0,0,0],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(151),m3h2x16(:,1189),heltab2x32(:,:,1281))
  call Hloop_Q_A(ntryL,G0H16(151),16,0,G1H16(308),n2h16(353))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1394),h0tab(:,1394),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(152),m3h2x16(:,1190),heltab2x32(:,:,1282))
  call Hloop_Q_A(ntryL,G0H16(152),16,nMT,G1H16(310),n2h16(354))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1395),h0tab(:,1395),[16,4,11],[0,0,0],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(154),m3h2x16(:,1191),heltab2x32(:,:,1283))
  call Hloop_A_Q(ntryL,G0H16(154),16,0,G1H16(311),n2h16(355))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1396),h0tab(:,1396),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(156),m3h2x16(:,1192),heltab2x32(:,:,1284))
  call Hloop_A_Q(ntryL,G0H16(156),16,nMT,G1H16(312),n2h16(356))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1397),h0tab(:,1397),[16,4,11],[0,0,0],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(158),m3h2x16(:,1193),heltab2x32(:,:,1285))
  call Hloop_Q_A(ntryL,G0H16(158),16,0,G1H16(313),n2h16(357))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1398),h0tab(:,1398),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(160),m3h2x16(:,1194),heltab2x32(:,:,1286))
  call Hloop_Q_A(ntryL,G0H16(160),16,nMB,G1H16(314),n2h16(358))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1399),h0tab(:,1399),[16,4,11],[0,0,0],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(161),m3h2x16(:,1195),heltab2x32(:,:,1287))
  call Hloop_A_Q(ntryL,G0H16(161),16,0,G1H16(315),n2h16(359))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1400),h0tab(:,1400),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(162),m3h2x16(:,1196),heltab2x32(:,:,1288))
  call Hloop_A_Q(ntryL,G0H16(162),16,nMB,G1H16(316),n2h16(360))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1401),h0tab(:,1401),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(317),m3h2x16(:,1197),heltab2x32(:,:,1289))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1402),h0tab(:,1402),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(318),m3h2x16(:,1198),heltab2x32(:,:,1290))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1403),h0tab(:,1403),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(319),m3h2x16(:,1199),heltab2x32(:,:,1291))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1404),h0tab(:,1404),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(320),m3h2x16(:,1200),heltab2x32(:,:,1292))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1405),h0tab(:,1405),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(321),m3h2x16(:,1201),heltab2x32(:,:,1293))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1406),h0tab(:,1406),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(322),m3h2x16(:,1202),heltab2x32(:,:,1294))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1407),h0tab(:,1407),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(323),m3h2x16(:,1203),heltab2x32(:,:,1295))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1408),h0tab(:,1408),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(324),m3h2x16(:,1204),heltab2x32(:,:,1296))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1409),h0tab(:,1409),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(325),m3h2x16(:,1205),heltab2x32(:,:,1297))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1410),h0tab(:,1410),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(326),m3h2x16(:,1206),heltab2x32(:,:,1298))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1411),h0tab(:,1411),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(327),m3h2x16(:,1207),heltab2x32(:,:,1299))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1412),h0tab(:,1412),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(328),m3h2x16(:,1208),heltab2x32(:,:,1300))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1413),h0tab(:,1413),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(331),m3h2x16(:,1209),heltab2x32(:,:,1301))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1414),h0tab(:,1414),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(332),m3h2x16(:,1210),heltab2x32(:,:,1302))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1415),h0tab(:,1415),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(335),m3h2x16(:,1211),heltab2x32(:,:,1303))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1416),h0tab(:,1416),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(336),m3h2x16(:,1212),heltab2x32(:,:,1304))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1417),h0tab(:,1417),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,1213),heltab2x32(:,:,1305))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1418),h0tab(:,1418),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(176),m3h2x16(:,1214),heltab2x32(:,:,1306))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1419),h0tab(:,1419),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,1215),heltab2x32(:,:,1307))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1420),h0tab(:,1420),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(178),m3h2x16(:,1216),heltab2x32(:,:,1308))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1421),h0tab(:,1421),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(337),m3h2x16(:,1217),heltab2x32(:,:,1309))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1422),h0tab(:,1422),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(338),m3h2x16(:,1218),heltab2x32(:,:,1310))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1423),h0tab(:,1423),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(339),m3h2x16(:,1219),heltab2x32(:,:,1311))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1424),h0tab(:,1424),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(340),m3h2x16(:,1220),heltab2x32(:,:,1312))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1425),h0tab(:,1425),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,1221),heltab2x32(:,:,1313))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1426),h0tab(:,1426),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(180),m3h2x16(:,1222),heltab2x32(:,:,1314))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1427),h0tab(:,1427),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,1223),heltab2x32(:,:,1315))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1428),h0tab(:,1428),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(182),m3h2x16(:,1224),heltab2x32(:,:,1316))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1429),h0tab(:,1429),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(183),m3h2x16(:,1225),heltab2x32(:,:,1317))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1430),h0tab(:,1430),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(184),m3h2x16(:,1226),heltab2x32(:,:,1318))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1431),h0tab(:,1431),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,1227),heltab2x32(:,:,1319))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1432),h0tab(:,1432),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(186),m3h2x16(:,1228),heltab2x32(:,:,1320))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1433),h0tab(:,1433),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(341),m3h2x16(:,1229),heltab2x32(:,:,1321))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1434),h0tab(:,1434),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(342),m3h2x16(:,1230),heltab2x32(:,:,1322))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1435),h0tab(:,1435),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(343),m3h2x16(:,1231),heltab2x32(:,:,1323))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1436),h0tab(:,1436),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(344),m3h2x16(:,1232),heltab2x32(:,:,1324))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1437),h0tab(:,1437),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(187),m3h2x16(:,1233),heltab2x32(:,:,1325))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1438),h0tab(:,1438),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(188),m3h2x16(:,1234),heltab2x32(:,:,1326))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1439),h0tab(:,1439),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,1235),heltab2x32(:,:,1327))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1440),h0tab(:,1440),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(190),m3h2x16(:,1236),heltab2x32(:,:,1328))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1441),h0tab(:,1441),[16,2,13],[nML,nMH,nML],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(191),m3h2x16(:,1237),heltab2x32(:,:,1329))
  call Hloop_Q_A(ntryL,G0H16(191),16,nML,G1H16(345),n2h16(361))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1442),h0tab(:,1442),[16,2,13],[nML,nMZ,nML],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(192),m3h2x16(:,1238),heltab2x32(:,:,1330))
  call Hloop_Q_A(ntryL,G0H16(192),16,nML,G1H16(346),n2h16(362))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1443),h0tab(:,1443),[16,2,13],[nMW,0,nMW],3,1,wf8(:,40))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(347),m3h2x16(:,1239),heltab2x32(:,:,1331))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1444),h0tab(:,1444),[16,2,13],[nML,0,nML],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,1240),heltab2x32(:,:,1332))
  call Hloop_Q_A(ntryL,G0H16(193),16,nML,G1H16(348),n2h16(363))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1445),h0tab(:,1445),[16,2,13],[nML,nMZ,nML],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(194),m3h2x16(:,1241),heltab2x32(:,:,1333))
  call Hloop_Q_A(ntryL,G0H16(194),16,nML,G1H16(349),n2h16(364))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1446),h0tab(:,1446),[16,2,13],[nMW,0,nMW],3,1,wf8(:,40))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,1242),heltab2x32(:,:,1334))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1447),h0tab(:,1447),[16,2,13],[nMW,0,nMW],3,1,wf8(:,40))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(196),m3h2x16(:,1243),heltab2x32(:,:,1335))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1448),h0tab(:,1448),[16,2,13],[nMW,0,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(350),m3h2x16(:,1244),heltab2x32(:,:,1336))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1449),h0tab(:,1449),[25,2,4],[nMH,nML,nML],3,1,wf8(:,34))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,34),G0H4(6),ngH,m3h8x4(:,17),heltab2x32(:,:,1337))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1450),h0tab(:,1450),[25,2,4],[nMZ,nML,nML],3,1,wf8(:,34))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,34),G0H4(42),ngX,m3h8x4(:,18),heltab2x32(:,:,1338))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1451),h0tab(:,1451),[25,2,4],[0,nMW,nMW],3,1,wf8(:,34))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(43),ngPnl,m3h8x4(:,19),heltab2x32(:,:,1339))
  call Hloop_Q_A(ntryL,G0H4(43),25,0,G1H4(149),n2h4(305))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1452),h0tab(:,1452),[25,2,4],[0,nML,nML],3,1,wf8(:,34))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,34),G0H4(43),m3h8x4(:,20),heltab2x32(:,:,1340))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1453),h0tab(:,1453),[25,2,4],[nMZ,nML,nML],3,1,wf8(:,34))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,34),G0H4(44),ngZl,m3h8x4(:,21),heltab2x32(:,:,1341))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1454),h0tab(:,1454),[25,2,4],[0,nMW,nMW],3,1,wf8(:,34))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(45),m3h8x4(:,22),heltab2x32(:,:,1342))
  call Hloop_Q_A(ntryL,G0H4(45),25,0,G1H4(141),n2h4(306))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1455),h0tab(:,1455),[25,2,4],[0,nMW,nMW],3,1,wf8(:,34))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(45),ngPnl,m3h8x4(:,23),heltab2x32(:,:,1343))
  call Hloop_Q_A(ntryL,G0H4(45),25,0,G1H4(137),n2h4(307))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1456),h0tab(:,1456),[25,2,4],[0,nMW,nMW],3,1,wf8(:,34))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(45),m3h8x4(:,24),heltab2x32(:,:,1344))
  call Hloop_Q_A(ntryL,G0H4(45),25,0,G1H4(127),n2h4(308))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1457),h0tab(:,1457),[17,4,10],[nML,nML,nMH],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(77),ngH,m3h4x8(:,77),heltab2x32(:,:,1345))
  call Hloop_Q_A(ntryL,G0H8(77),17,nML,G1H8(131),n2h8(289))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1458),h0tab(:,1458),[17,4,10],[nML,nML,nMZ],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(77),ngX,m3h4x8(:,78),heltab2x32(:,:,1346))
  call Hloop_Q_A(ntryL,G0H8(77),17,nML,G1H8(12),n2h8(290))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1459),h0tab(:,1459),[17,4,10],[nMW,nMW,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(77),ngPnl,m3h4x8(:,79),heltab2x32(:,:,1347))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1460),h0tab(:,1460),[17,4,10],[nML,nML,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(78),m3h4x8(:,80),heltab2x32(:,:,1348))
  call Hloop_Q_A(ntryL,G0H8(78),17,nML,G1H8(24),n2h8(291))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1461),h0tab(:,1461),[17,4,10],[nML,nML,nMZ],3,2,wf4(:,12),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(78),ngZl,m3h4x8(:,81),heltab2x32(:,:,1349))
  call Hloop_Q_A(ntryL,G0H8(78),17,nML,G1H8(27),n2h8(292))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1462),h0tab(:,1462),[17,4,10],[nMW,nMW,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(78),ngPnl,m3h4x8(:,82),heltab2x32(:,:,1350))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1463),h0tab(:,1463),[17,4,10],[nMW,nMW,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(79),m3h4x8(:,83),heltab2x32(:,:,1351))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1464),h0tab(:,1464),[17,4,10],[nMW,nMW,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(80),m3h4x8(:,84),heltab2x32(:,:,1352))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1465),h0tab(:,1465),[16,4,11],[nME,nME,nME],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,1245),heltab2x32(:,:,1353))
  call Hloop_Q_A(ntryL,G0H16(197),16,nME,G1H16(351),n2h16(365))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1466),h0tab(:,1466),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(198),m3h2x16(:,1246),heltab2x32(:,:,1354))
  call Hloop_Q_A(ntryL,G0H16(198),16,nMM,G1H16(352),n2h16(366))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1467),h0tab(:,1467),[16,4,11],[nML,nML,nML],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,1247),heltab2x32(:,:,1355))
  call Hloop_Q_A(ntryL,G0H16(199),16,nML,G1H16(353),n2h16(367))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1468),h0tab(:,1468),[16,4,11],[nME,nME,nME],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(200),m3h2x16(:,1248),heltab2x32(:,:,1356))
  call Hloop_A_Q(ntryL,G0H16(200),16,nME,G1H16(354),n2h16(368))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1469),h0tab(:,1469),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,1249),heltab2x32(:,:,1357))
  call Hloop_A_Q(ntryL,G0H16(201),16,nMM,G1H16(355),n2h16(369))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1470),h0tab(:,1470),[16,4,11],[nML,nML,nML],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(202),m3h2x16(:,1250),heltab2x32(:,:,1358))
  call Hloop_A_Q(ntryL,G0H16(202),16,nML,G1H16(356),n2h16(370))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1471),h0tab(:,1471),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,1251),heltab2x32(:,:,1359))
  call Hloop_Q_A(ntryL,G0H16(49),16,nMT,G1H16(357),n2h16(371))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1472),h0tab(:,1472),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,1252),heltab2x32(:,:,1360))
  call Hloop_A_Q(ntryL,G0H16(50),16,nMT,G1H16(358),n2h16(372))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1473),h0tab(:,1473),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,1253),heltab2x32(:,:,1361))
  call Hloop_Q_A(ntryL,G0H16(51),16,nMB,G1H16(359),n2h16(373))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1474),h0tab(:,1474),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,1254),heltab2x32(:,:,1362))
  call Hloop_A_Q(ntryL,G0H16(52),16,nMB,G1H16(360),n2h16(374))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1475),h0tab(:,1475),[16,4,11],[nME,nME,nME],3,1,wf8(:,53))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,1255),heltab2x32(:,:,1363))
  call Hloop_Q_A(ntryL,G0H16(55),16,nME,G1H16(361),n2h16(375))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1476),h0tab(:,1476),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,53))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,1256),heltab2x32(:,:,1364))
  call Hloop_Q_A(ntryL,G0H16(56),16,nMM,G1H16(362),n2h16(376))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1477),h0tab(:,1477),[16,4,11],[nML,nML,nML],3,1,wf8(:,53))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,1257),heltab2x32(:,:,1365))
  call Hloop_Q_A(ntryL,G0H16(57),16,nML,G1H16(363),n2h16(377))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1478),h0tab(:,1478),[16,4,11],[nME,nME,nME],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,1258),heltab2x32(:,:,1366))
  call Hloop_A_Q(ntryL,G0H16(58),16,nME,G1H16(364),n2h16(378))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1479),h0tab(:,1479),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,1259),heltab2x32(:,:,1367))
  call Hloop_A_Q(ntryL,G0H16(74),16,nMM,G1H16(365),n2h16(379))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1480),h0tab(:,1480),[16,4,11],[nML,nML,nML],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,1260),heltab2x32(:,:,1368))
  call Hloop_A_Q(ntryL,G0H16(76),16,nML,G1H16(366),n2h16(380))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1481),h0tab(:,1481),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,53))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,1261),heltab2x32(:,:,1369))
  call Hloop_Q_A(ntryL,G0H16(77),16,nMT,G1H16(367),n2h16(381))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1482),h0tab(:,1482),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,1262),heltab2x32(:,:,1370))
  call Hloop_A_Q(ntryL,G0H16(78),16,nMT,G1H16(368),n2h16(382))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1483),h0tab(:,1483),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,53))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,1263),heltab2x32(:,:,1371))
  call Hloop_Q_A(ntryL,G0H16(79),16,nMB,G1H16(369),n2h16(383))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1484),h0tab(:,1484),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,1264),heltab2x32(:,:,1372))
  call Hloop_A_Q(ntryL,G0H16(80),16,nMB,G1H16(370),n2h16(384))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1485),h0tab(:,1485),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(371),m3h2x16(:,1265),heltab2x32(:,:,1373))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1486),h0tab(:,1486),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(372),m3h2x16(:,1266),heltab2x32(:,:,1374))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1487),h0tab(:,1487),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(373),m3h2x16(:,1267),heltab2x32(:,:,1375))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1488),h0tab(:,1488),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(374),m3h2x16(:,1268),heltab2x32(:,:,1376))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1489),h0tab(:,1489),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(375),m3h2x16(:,1269),heltab2x32(:,:,1377))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1490),h0tab(:,1490),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(376),m3h2x16(:,1270),heltab2x32(:,:,1378))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1491),h0tab(:,1491),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(377),m3h2x16(:,1271),heltab2x32(:,:,1379))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1492),h0tab(:,1492),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(378),m3h2x16(:,1272),heltab2x32(:,:,1380))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1493),h0tab(:,1493),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(379),m3h2x16(:,1273),heltab2x32(:,:,1381))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1494),h0tab(:,1494),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(380),m3h2x16(:,1274),heltab2x32(:,:,1382))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1495),h0tab(:,1495),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(381),m3h2x16(:,1275),heltab2x32(:,:,1383))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1496),h0tab(:,1496),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(382),m3h2x16(:,1276),heltab2x32(:,:,1384))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1497),h0tab(:,1497),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(81),m3h2x16(:,1277),heltab2x32(:,:,1385))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1498),h0tab(:,1498),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,1278),heltab2x32(:,:,1386))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1499),h0tab(:,1499),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,1279),heltab2x32(:,:,1387))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1500),h0tab(:,1500),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,1280),heltab2x32(:,:,1388))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1501),h0tab(:,1501),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(383),m3h2x16(:,1281),heltab2x32(:,:,1389))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1502),h0tab(:,1502),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(384),m3h2x16(:,1282),heltab2x32(:,:,1390))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1503),h0tab(:,1503),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(385),m3h2x16(:,1283),heltab2x32(:,:,1391))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1504),h0tab(:,1504),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(386),m3h2x16(:,1284),heltab2x32(:,:,1392))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1505),h0tab(:,1505),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,1285),heltab2x32(:,:,1393))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1506),h0tab(:,1506),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,1286),heltab2x32(:,:,1394))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1507),h0tab(:,1507),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,1287),heltab2x32(:,:,1395))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1508),h0tab(:,1508),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,1288),heltab2x32(:,:,1396))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1509),h0tab(:,1509),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(387),m3h2x16(:,1289),heltab2x32(:,:,1397))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1510),h0tab(:,1510),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(388),m3h2x16(:,1290),heltab2x32(:,:,1398))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1511),h0tab(:,1511),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(389),m3h2x16(:,1291),heltab2x32(:,:,1399))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1512),h0tab(:,1512),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(390),m3h2x16(:,1292),heltab2x32(:,:,1400))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1513),h0tab(:,1513),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,1293),heltab2x32(:,:,1401))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1514),h0tab(:,1514),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,1294),heltab2x32(:,:,1402))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1515),h0tab(:,1515),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(123),m3h2x16(:,1295),heltab2x32(:,:,1403))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1516),h0tab(:,1516),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(124),m3h2x16(:,1296),heltab2x32(:,:,1404))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1517),h0tab(:,1517),[16,4,11],[nME,nME,nME],3,1,wf8(:,54))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(126),m3h2x16(:,1297),heltab2x32(:,:,1405))
  call Hloop_Q_A(ntryL,G0H16(126),16,nME,G1H16(391),n2h16(385))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1518),h0tab(:,1518),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,54))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(128),m3h2x16(:,1298),heltab2x32(:,:,1406))
  call Hloop_Q_A(ntryL,G0H16(128),16,nMM,G1H16(392),n2h16(386))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1519),h0tab(:,1519),[16,4,11],[nML,nML,nML],3,1,wf8(:,54))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(133),m3h2x16(:,1299),heltab2x32(:,:,1407))
  call Hloop_Q_A(ntryL,G0H16(133),16,nML,G1H16(393),n2h16(387))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1520),h0tab(:,1520),[16,4,11],[nME,nME,nME],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(134),m3h2x16(:,1300),heltab2x32(:,:,1408))
  call Hloop_A_Q(ntryL,G0H16(134),16,nME,G1H16(394),n2h16(388))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1521),h0tab(:,1521),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(135),m3h2x16(:,1301),heltab2x32(:,:,1409))
  call Hloop_A_Q(ntryL,G0H16(135),16,nMM,G1H16(395),n2h16(389))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1522),h0tab(:,1522),[16,4,11],[nML,nML,nML],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(136),m3h2x16(:,1302),heltab2x32(:,:,1410))
  call Hloop_A_Q(ntryL,G0H16(136),16,nML,G1H16(396),n2h16(390))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1523),h0tab(:,1523),[16,4,11],[0,0,0],3,1,wf8(:,54))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(139),m3h2x16(:,1303),heltab2x32(:,:,1411))
  call Hloop_Q_A(ntryL,G0H16(139),16,0,G1H16(397),n2h16(391))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1524),h0tab(:,1524),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,54))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(140),m3h2x16(:,1304),heltab2x32(:,:,1412))
  call Hloop_Q_A(ntryL,G0H16(140),16,nMT,G1H16(398),n2h16(392))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1525),h0tab(:,1525),[16,4,11],[0,0,0],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,1305),heltab2x32(:,:,1413))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(399),n2h16(393))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1526),h0tab(:,1526),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(142),m3h2x16(:,1306),heltab2x32(:,:,1414))
  call Hloop_A_Q(ntryL,G0H16(142),16,nMT,G1H16(400),n2h16(394))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1527),h0tab(:,1527),[16,4,11],[0,0,0],3,1,wf8(:,54))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(143),m3h2x16(:,1307),heltab2x32(:,:,1415))
  call Hloop_Q_A(ntryL,G0H16(143),16,0,G1H16(401),n2h16(395))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1528),h0tab(:,1528),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,54))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(144),m3h2x16(:,1308),heltab2x32(:,:,1416))
  call Hloop_Q_A(ntryL,G0H16(144),16,nMB,G1H16(402),n2h16(396))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1529),h0tab(:,1529),[16,4,11],[0,0,0],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(145),m3h2x16(:,1309),heltab2x32(:,:,1417))
  call Hloop_A_Q(ntryL,G0H16(145),16,0,G1H16(403),n2h16(397))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1530),h0tab(:,1530),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(146),m3h2x16(:,1310),heltab2x32(:,:,1418))
  call Hloop_A_Q(ntryL,G0H16(146),16,nMB,G1H16(404),n2h16(398))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1531),h0tab(:,1531),[16,4,11],[nME,nME,nME],3,1,wf8(:,55))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(147),m3h2x16(:,1311),heltab2x32(:,:,1419))
  call Hloop_Q_A(ntryL,G0H16(147),16,nME,G1H16(405),n2h16(399))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1532),h0tab(:,1532),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,55))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(148),m3h2x16(:,1312),heltab2x32(:,:,1420))
  call Hloop_Q_A(ntryL,G0H16(148),16,nMM,G1H16(406),n2h16(400))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1533),h0tab(:,1533),[16,4,11],[nML,nML,nML],3,1,wf8(:,55))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(149),m3h2x16(:,1313),heltab2x32(:,:,1421))
  call Hloop_Q_A(ntryL,G0H16(149),16,nML,G1H16(407),n2h16(401))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1534),h0tab(:,1534),[16,4,11],[nME,nME,nME],3,1,wf8(:,55))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(150),m3h2x16(:,1314),heltab2x32(:,:,1422))
  call Hloop_A_Q(ntryL,G0H16(150),16,nME,G1H16(408),n2h16(402))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1535),h0tab(:,1535),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,55))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(151),m3h2x16(:,1315),heltab2x32(:,:,1423))
  call Hloop_A_Q(ntryL,G0H16(151),16,nMM,G1H16(409),n2h16(403))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1536),h0tab(:,1536),[16,4,11],[nML,nML,nML],3,1,wf8(:,55))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(152),m3h2x16(:,1316),heltab2x32(:,:,1424))
  call Hloop_A_Q(ntryL,G0H16(152),16,nML,G1H16(410),n2h16(404))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1537),h0tab(:,1537),[16,4,11],[0,0,0],3,1,wf8(:,55))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(154),m3h2x16(:,1317),heltab2x32(:,:,1425))
  call Hloop_Q_A(ntryL,G0H16(154),16,0,G1H16(411),n2h16(405))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1538),h0tab(:,1538),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,55))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(156),m3h2x16(:,1318),heltab2x32(:,:,1426))
  call Hloop_Q_A(ntryL,G0H16(156),16,nMT,G1H16(412),n2h16(406))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1539),h0tab(:,1539),[16,4,11],[0,0,0],3,1,wf8(:,55))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(158),m3h2x16(:,1319),heltab2x32(:,:,1427))
  call Hloop_A_Q(ntryL,G0H16(158),16,0,G1H16(413),n2h16(407))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1540),h0tab(:,1540),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,55))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(160),m3h2x16(:,1320),heltab2x32(:,:,1428))
  call Hloop_A_Q(ntryL,G0H16(160),16,nMT,G1H16(414),n2h16(408))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1541),h0tab(:,1541),[16,4,11],[0,0,0],3,1,wf8(:,55))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(161),m3h2x16(:,1321),heltab2x32(:,:,1429))
  call Hloop_Q_A(ntryL,G0H16(161),16,0,G1H16(415),n2h16(409))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1542),h0tab(:,1542),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,55))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(162),m3h2x16(:,1322),heltab2x32(:,:,1430))
  call Hloop_Q_A(ntryL,G0H16(162),16,nMB,G1H16(416),n2h16(410))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1543),h0tab(:,1543),[16,4,11],[0,0,0],3,1,wf8(:,55))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(191),m3h2x16(:,1323),heltab2x32(:,:,1431))
  call Hloop_A_Q(ntryL,G0H16(191),16,0,G1H16(417),n2h16(411))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1544),h0tab(:,1544),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,55))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(192),m3h2x16(:,1324),heltab2x32(:,:,1432))
  call Hloop_A_Q(ntryL,G0H16(192),16,nMB,G1H16(418),n2h16(412))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1545),h0tab(:,1545),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(419),m3h2x16(:,1325),heltab2x32(:,:,1433))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1546),h0tab(:,1546),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(420),m3h2x16(:,1326),heltab2x32(:,:,1434))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1547),h0tab(:,1547),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(421),m3h2x16(:,1327),heltab2x32(:,:,1435))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1548),h0tab(:,1548),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(422),m3h2x16(:,1328),heltab2x32(:,:,1436))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1549),h0tab(:,1549),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(423),m3h2x16(:,1329),heltab2x32(:,:,1437))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1550),h0tab(:,1550),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(424),m3h2x16(:,1330),heltab2x32(:,:,1438))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1551),h0tab(:,1551),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(425),m3h2x16(:,1331),heltab2x32(:,:,1439))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1552),h0tab(:,1552),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(426),m3h2x16(:,1332),heltab2x32(:,:,1440))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1553),h0tab(:,1553),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(427),m3h2x16(:,1333),heltab2x32(:,:,1441))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1554),h0tab(:,1554),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(428),m3h2x16(:,1334),heltab2x32(:,:,1442))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1555),h0tab(:,1555),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(429),m3h2x16(:,1335),heltab2x32(:,:,1443))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1556),h0tab(:,1556),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(430),m3h2x16(:,1336),heltab2x32(:,:,1444))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1557),h0tab(:,1557),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(431),m3h2x16(:,1337),heltab2x32(:,:,1445))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1558),h0tab(:,1558),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(432),m3h2x16(:,1338),heltab2x32(:,:,1446))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1559),h0tab(:,1559),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(433),m3h2x16(:,1339),heltab2x32(:,:,1447))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1560),h0tab(:,1560),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(434),m3h2x16(:,1340),heltab2x32(:,:,1448))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1561),h0tab(:,1561),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,1341),heltab2x32(:,:,1449))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1562),h0tab(:,1562),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(194),m3h2x16(:,1342),heltab2x32(:,:,1450))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1563),h0tab(:,1563),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,1343),heltab2x32(:,:,1451))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1564),h0tab(:,1564),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(198),m3h2x16(:,1344),heltab2x32(:,:,1452))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1565),h0tab(:,1565),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(435),m3h2x16(:,1345),heltab2x32(:,:,1453))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1566),h0tab(:,1566),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(436),m3h2x16(:,1346),heltab2x32(:,:,1454))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1567),h0tab(:,1567),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(437),m3h2x16(:,1347),heltab2x32(:,:,1455))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1568),h0tab(:,1568),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(438),m3h2x16(:,1348),heltab2x32(:,:,1456))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1569),h0tab(:,1569),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,1349),heltab2x32(:,:,1457))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1570),h0tab(:,1570),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(200),m3h2x16(:,1350),heltab2x32(:,:,1458))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1571),h0tab(:,1571),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,1351),heltab2x32(:,:,1459))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1572),h0tab(:,1572),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(202),m3h2x16(:,1352),heltab2x32(:,:,1460))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1573),h0tab(:,1573),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,1353),heltab2x32(:,:,1461))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1574),h0tab(:,1574),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,1354),heltab2x32(:,:,1462))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1575),h0tab(:,1575),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,1355),heltab2x32(:,:,1463))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1576),h0tab(:,1576),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,1356),heltab2x32(:,:,1464))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1577),h0tab(:,1577),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(439),m3h2x16(:,1357),heltab2x32(:,:,1465))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1578),h0tab(:,1578),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(440),m3h2x16(:,1358),heltab2x32(:,:,1466))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1579),h0tab(:,1579),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(441),m3h2x16(:,1359),heltab2x32(:,:,1467))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1580),h0tab(:,1580),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(442),m3h2x16(:,1360),heltab2x32(:,:,1468))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1581),h0tab(:,1581),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,1361),heltab2x32(:,:,1469))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1582),h0tab(:,1582),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,1362),heltab2x32(:,:,1470))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1583),h0tab(:,1583),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,1363),heltab2x32(:,:,1471))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1584),h0tab(:,1584),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,1364),heltab2x32(:,:,1472))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1585),h0tab(:,1585),[16,1,14],[nML,nMH,nML],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,1365),heltab2x32(:,:,1473))
  call Hloop_A_Q(ntryL,G0H16(74),16,nML,G1H16(443),n2h16(413))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1586),h0tab(:,1586),[16,1,14],[nML,nMZ,nML],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,1366),heltab2x32(:,:,1474))
  call Hloop_A_Q(ntryL,G0H16(76),16,nML,G1H16(444),n2h16(414))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1587),h0tab(:,1587),[16,1,14],[nMW,0,nMW],3,1,wf8(:,42))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(445),m3h2x16(:,1367),heltab2x32(:,:,1475))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1588),h0tab(:,1588),[16,1,14],[nML,0,nML],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,1368),heltab2x32(:,:,1476))
  call Hloop_A_Q(ntryL,G0H16(77),16,nML,G1H16(446),n2h16(415))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1589),h0tab(:,1589),[16,1,14],[nML,nMZ,nML],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,1369),heltab2x32(:,:,1477))
  call Hloop_A_Q(ntryL,G0H16(78),16,nML,G1H16(447),n2h16(416))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1590),h0tab(:,1590),[16,1,14],[nMW,0,nMW],3,1,wf8(:,42))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,1370),heltab2x32(:,:,1478))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1591),h0tab(:,1591),[16,1,14],[nMW,0,nMW],3,1,wf8(:,42))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,1371),heltab2x32(:,:,1479))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1592),h0tab(:,1592),[16,1,14],[nMW,0,nMW],3,1,wf8(:,42))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(448),m3h2x16(:,1372),heltab2x32(:,:,1480))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1593),h0tab(:,1593),[26,1,4],[nMH,nML,nML],3,1,wf8(:,27))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,27),G0H4(45),ngH,m3h8x4(:,25),heltab2x32(:,:,1481))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1594),h0tab(:,1594),[26,1,4],[nMZ,nML,nML],3,1,wf8(:,27))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,27),G0H4(46),ngX,m3h8x4(:,26),heltab2x32(:,:,1482))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1595),h0tab(:,1595),[26,1,4],[0,nMW,nMW],3,1,wf8(:,27))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(47),ngPln,m3h8x4(:,27),heltab2x32(:,:,1483))
  call Hloop_A_Q(ntryL,G0H4(47),26,0,G1H4(171),n2h4(309))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1596),h0tab(:,1596),[26,1,4],[0,nML,nML],3,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,27),G0H4(47),m3h8x4(:,28),heltab2x32(:,:,1484))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1597),h0tab(:,1597),[26,1,4],[nMZ,nML,nML],3,1,wf8(:,27))



end subroutine vamp_5

end module ol_vamp_5_ppllj_ew_llxaaa_1_/**/REALKIND
