
module ol_vamp_1_ppllj_ew_nllxuxd_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj_ew_nllxuxd_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj_ew_nllxuxd_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllj_ew_nllxuxd_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllj_ew_nllxuxd_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppllj_ew_nllxuxd_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllj_ew_nllxuxd_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(10)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,nML,nMW,0],4,0)
  call Hloop_AQ_V(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[nMW,0,nMZ,0],4,0)
  call Hloop_AQ_W(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[nMZ,nML,nMW,0],4,0)
  call Hloop_AQ_Z(ntryL,G0H16(1),ex4(:),G0H8(3),ngZd,m3h2x8(:,3),heltab2x16(:,:,3))
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,1,2,4],[nMW,nML,0,0],4,0)
  call Hloop_AQ_W(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,1,2,4],[nMW,nML,nMZ,0],4,0)
  call Hloop_AQ_W(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,1,2,4],[nMZ,0,nMW,0],4,0)
  call Hloop_AQ_Z(ntryL,G0H16(1),ex4(:),G0H8(6),ngZd,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(1),n2h4(1))
  call Hloop_WA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(2),n2h4(2))
  call Hloop_ZA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),ngZl,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),10,nML,G1H4(3),n2h4(3))
  call Hloop_WQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(4),n2h4(4))
  call Hloop_WQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G0H4(1),9,nML,G1H4(5),n2h4(5))
  call Hloop_ZQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),ngZn,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(6),n2h4(6))
  call Hloop_AQ_W(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H4(2),ex1(:),G1H2(2),ngZn,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_W(ntryL,G1H4(3),ex1(:),G1H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G1H4(4),ex2(:),G1H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_Z(ntryL,G1H4(5),ex2(:),G1H2(5),ngZl,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_W(ntryL,G1H4(6),ex2(:),G1H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_WA_Q(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(1))
  call Hloop_ZA_Q(ntryL,G1H2(2),ex3(:),G1H1(1),ngZu,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(2),n2h1(2))
  call Hloop_WA_Q(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(4),n2h1(4))
  call Hloop_ZA_Q(ntryL,G1H2(5),ex3(:),G1H1(1),ngZu,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(5),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(6),n2h1(6))
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(1),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,4),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(2),mass4set(:,5),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,6),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(1),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(2),mass4set(:,4),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(2),mass4set(:,5),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,6),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,3,4],[nMW,0,0],3,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,3,4],[0,nMW,0],3,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,8),heltab2x16(:,:,8))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,3,4],[nMW,nMZ,0],3,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,3,4],[nMZ,nMW,0],3,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H16(1),ex4(:),G0H8(4),ngZd,m3h2x8(:,10),heltab2x16(:,:,10))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G0H8(5),8,0,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,3,4],[0,0,nMZ],3,1,wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H16(1),ex4(:),G0H8(6),ngZd,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G0H8(6),8,0,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G0H8(5),8,0,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,3,4],[nMW,0,0],3,1,wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,14),heltab2x16(:,:,14))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[8,3,4],[0,nMW,0],3,1,wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,15),heltab2x16(:,:,15))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,3,4],[nMW,nMZ,0],3,1,wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H16(1),ex4(:),G0H8(7),m3h2x8(:,16),heltab2x16(:,:,16))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,3,4],[nMZ,nMW,0],3,1,wf4(:,1))
  call Hloop_AQ_Z(ntryL,G0H16(1),ex4(:),G0H8(8),ngZd,m3h2x8(:,17),heltab2x16(:,:,17))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[12,1,2],[nMW,nML,nMH],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(1),m3h4x4(:,1),heltab2x16(:,:,18))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[12,1,2],[nMW,nML,nMZ],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(2),m3h4x4(:,2),heltab2x16(:,:,19))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[12,1,2],[0,nMZ,nML],3,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,3),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G0H4(1),12,0,G1H4(3),n2h4(7))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[12,1,2],[nMW,nML,0],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,4),heltab2x16(:,:,21))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[12,1,2],[nMW,nML,nMZ],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(2),m3h4x4(:,5),heltab2x16(:,:,22))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[12,1,2],[nMZ,0,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,2),G0H4(3),m3h4x4(:,6),heltab2x16(:,:,23))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[12,1,2],[nMW,nML,nMH],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,7),heltab2x16(:,:,24))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[12,1,2],[nMW,nML,0],3,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(4),m3h4x4(:,8),heltab2x16(:,:,25))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[12,1,2],[nMZ,0,nMW],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(5),m3h4x4(:,9),heltab2x16(:,:,26))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[12,1,2],[nMW,nML,nMZ],3,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(6),m3h4x4(:,10),heltab2x16(:,:,27))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(1)])
  call Hloop_VS_V(ntryL,G0H8(1),wf4(:,3),G0H2(1),m3h4x2(:,1),heltab2x8(:,:,7))
  call Hloop_VS_V(ntryL,G0H8(2),wf4(:,3),G0H2(2),m3h4x2(:,2),heltab2x8(:,:,8))
  call Hloop_VS_V(ntryL,G0H8(3),wf4(:,3),G0H2(3),m3h4x2(:,3),heltab2x8(:,:,9))
  call Hloop_VS_V(ntryL,G0H8(4),wf4(:,3),G0H2(4),m3h4x2(:,4),heltab2x8(:,:,10))
  call Hloop_QW_A(ntryL,G1H8(3),wf4(:,1),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(1),n2h2(1))
  call Hloop_QW_A(ntryL,G1H8(2),wf4(:,1),G1H2(2),m3h4x2(:,6),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(2),11,0,G2H2(2),n2h2(2))
  call Hloop_UW_V(ntryL,G0H8(6),8,wf4(:,1),3,G1H2(3),m3h4x2(:,7),heltab2x8(:,:,13))
  call Hloop_UV_W(ntryL,G0H8(5),8,wf4(:,1),3,G1H2(4),m3h4x2(:,8),heltab2x8(:,:,14))
  call Hloop_UW_V(ntryL,G0H8(7),8,wf4(:,1),3,G1H2(5),m3h4x2(:,9),heltab2x8(:,:,15))
  call Hloop_UV_W(ntryL,G0H8(8),8,wf4(:,1),3,G1H2(6),m3h4x2(:,10),heltab2x8(:,:,16))
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),ngPln,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),13,nML,G2H2(3),n2h2(3))
  call Hloop_SQ_A(ntryL,G1H4(2),ex1(:),G1H2(2),ngPln,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(2),13,nML,G2H2(4),n2h2(4))
  call Hloop_AQ_Z(ntryL,G1H4(3),ex1(:),G1H2(1),ngZn,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_SQ_A(ntryL,G0H4(1),ex1(:),G0H2(5),ngPln,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G0H2(5),13,nML,G1H2(2),n2h2(5))
  call Hloop_SQ_A(ntryL,G0H4(2),ex1(:),G0H2(5),ngPln,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G0H2(5),13,nML,G1H2(7),n2h2(6))
  call Hloop_ZQ_A(ntryL,G0H4(3),ex1(:),G0H2(5),ngZn,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G0H2(5),13,0,G1H2(8),n2h2(7))
  call Hloop_WQ_A(ntryL,G0H4(4),ex1(:),G0H2(5),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G0H2(5),13,nML,G1H2(9),n2h2(8))
  call Hloop_WQ_A(ntryL,G1H4(4),ex1(:),G1H2(10),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(10),13,nML,G2H2(5),n2h2(9))
  call Hloop_ZQ_A(ntryL,G1H4(5),ex1(:),G1H2(10),ngZn,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(10),13,0,G2H2(6),n2h2(10))
  call Hloop_WQ_A(ntryL,G1H4(6),ex1(:),G1H2(10),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(10),13,nML,G2H2(7),n2h2(11))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(5),[G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(6),[G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(7)])
  call Hloop_VA_Q(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(7))
  call Hloop_WA_Q(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(2),n2h1(8))
  call Hloop_ZA_Q(ntryL,G1H2(5),ex3(:),G1H1(1),ngZu,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(9))
  call Hloop_WA_Q(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(4),n2h1(10))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(5),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(6),ngZu,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(7),ngH,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(8),ngX,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hloop_ZA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngZl,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nML,G2tensor(9),n2h1(11))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(10),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(11),ngZl,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H2(8),ex2(:),G1tensor(1),ngPln,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(12),m3h2x1(:,19),heltab2x2(:,:,19))
  call ol_merge_tensors(G1tensor(2),[G0tensor(2)])
  call ol_merge_tensors(G1tensor(13),[G1tensor(3),G0tensor(13),G0tensor(3)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(4),G0tensor(4)])
  call ol_merge_tensors(G1tensor(5),[G0tensor(5)])
  call ol_merge_tensors(G1tensor(7),[G0tensor(7)])
  call ol_merge_tensors(G1tensor(8),[G0tensor(8)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(24),G1tensor(9),G0tensor(24),G0tensor(9)])
  call ol_merge_tensors(G1tensor(10),[G0tensor(10)])
  call ol_merge_tensors(G1tensor(12),[G0tensor(12)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(29),G1tensor(14),G0tensor(29),G0tensor(14)])
  call ol_merge_tensors(G1tensor(15),[G0tensor(15)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(17),G0tensor(17)])
  call ol_merge_tensors(G1tensor(18),[G0tensor(18)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(19),G0tensor(19)])
  call ol_merge_tensors(G1tensor(25),[G1tensor(20),G0tensor(25),G0tensor(20)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(8),G1tensor(22),G0tensor(22)])
  call ol_merge_tensors(G1tensor(23),[G0tensor(23)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(1),G1tensor(27),G0tensor(27)])
  call ol_merge_tensors(G1tensor(28),[G0tensor(28)])
  call ol_merge_tensors(G1tensor(30),[G0tensor(30)])
  call TI_triangle_red(G2tensor(2),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMW], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,2),G0tensor(26),G0tensor(2),G0tensor(13),G0tensor(3),M2L1R1,[nMW,nMZ], &
    G0tensor(4),G0tensor(5))
  call TI_triangle_red(G2tensor(4),RedBasis(2),mass3set(:,3),G0tensor(7),G0tensor(8),G0tensor(24),G0tensor(9),M2L1R1,[nMZ,nMW], &
    G0tensor(10),G0tensor(12))
  call TI_triangle_red(G2tensor(10),RedBasis(6),mass3set(:,4),G0tensor(29),G0tensor(14),G0tensor(15), &
    G0tensor(17),M2L1R1,[nMW,nML],G0tensor(18),G0tensor(19))
  call TI_triangle_red(G2tensor(1),RedBasis(2),mass3set(:,5),G0tensor(25),G0tensor(20),G0tensor(22),G0tensor(23),M2L1R1,[nMW], &
    G0tensor(27))
  call TI_triangle_red(G2tensor(11),RedBasis(6),mass3set(:,6),G0tensor(28),G0tensor(30),G0tensor(31), &
    G0tensor(32),M2L1R1,[nMZ,nMW,nML],G0tensor(33),G0tensor(34),G0tensor(35))
  call TI_triangle_red(G2tensor(12),RedBasis(6),mass3set(:,7),G0tensor(36),G0tensor(37),G0tensor(38), &
    G0tensor(39),M2L1R1,[nMW,nMZ],G0tensor(40),G0tensor(41))
  call TI_triangle_red(G2tensor(5),RedBasis(2),mass3set(:,8),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45),M2L1R1)
  call TI_triangle_red(G2tensor(6),RedBasis(2),mass3set(:,9),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),M2L1R1,[nMZ], &
    G0tensor(50))
  call TI_triangle_red(G2tensor(7),RedBasis(6),mass3set(:,10),G0tensor(51),G0tensor(52),G0tensor(53), &
    G0tensor(54),M2L1R1,[nMH,nMW,nML],G0tensor(55),G0tensor(56),G0tensor(57))
  call TI_triangle_red(G2tensor(9),RedBasis(6),mass3set(:,11),G0tensor(58),G0tensor(59),G0tensor(60), &
    G0tensor(61),M2L1R1,[nML,nMZ],G0tensor(62),G0tensor(63))
  call TI_triangle_red(G1tensor(2),RedBasis(7),mass3set(:,12),G0tensor(64),G0tensor(65),G0tensor(66), &
    G0tensor(67),M2L1R1,[nMW,nML],G0tensor(68),G0tensor(69))
  call TI_triangle_red(G1tensor(13),RedBasis(3),mass3set(:,13),G0tensor(70),G0tensor(71),G0tensor(72), &
    G0tensor(73),M2L1R1,[nML,nMW],G0tensor(74),G0tensor(75))
  call TI_triangle_red(G1tensor(5),RedBasis(1),mass3set(:,14),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),M2L1R1,[nML], &
    G0tensor(80))
  call TI_triangle_red(G1tensor(7),RedBasis(7),mass3set(:,15),G0tensor(81),G0tensor(82),G0tensor(83), &
    G0tensor(84),M2L1R1,[nMZ,nMW],G0tensor(85),G0tensor(86))
  call TI_triangle_red(G1tensor(8),RedBasis(3),mass3set(:,16),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90),M2L1R1,[nMZ], &
    G0tensor(91))
  call TI_triangle_red(G1tensor(10),RedBasis(1),mass3set(:,5),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95),M2L1R1,[nMW], &
    G0tensor(96))
  call TI_triangle_red(G1tensor(12),RedBasis(7),mass3set(:,17),G0tensor(97),G0tensor(98),G0tensor(99), &
    G0tensor(100),M2L1R1,[nMW,nMZ,nML],G0tensor(101),G0tensor(102),G0tensor(103))
  call TI_triangle_red(G1tensor(15),RedBasis(1),mass3set(:,18),G0tensor(104),G0tensor(105),G0tensor(106), &
    G0tensor(107),M2L1R1,[nMZ,nML],G0tensor(108),G0tensor(109))
  call TI_triangle_red(G1tensor(18),RedBasis(5),mass3set(:,19),G0tensor(110),G0tensor(111),G0tensor(112), &
    G0tensor(113),M2L1R1,[nML],G0tensor(114))
  call TI_triangle_red(G1tensor(25),RedBasis(4),mass3set(:,4),G0tensor(115),G0tensor(116),G0tensor(117), &
    G0tensor(118),M2L1R1,[nMW,nML],G0tensor(119),G0tensor(120))
  call TI_triangle_red(G1tensor(23),RedBasis(5),mass3set(:,20),G0tensor(121),G0tensor(122),G0tensor(123), &
    G0tensor(124),M2L1R1,[nML,nMZ],G0tensor(125),G0tensor(126))
  call TI_triangle_red(G1tensor(28),RedBasis(5),mass3set(:,1),G0tensor(127),G0tensor(128),G0tensor(129), &
    G0tensor(130),M2L1R1,[nMW],G0tensor(131))
  call TI_triangle_red(G1tensor(30),RedBasis(4),mass3set(:,21),G0tensor(132),G0tensor(133),G0tensor(134), &
    G0tensor(135),M2L1R1,[nMZ],G0tensor(136))
  call ol_merge_tensors(T0sum(7),[G0tensor(64)])
  call ol_merge_tensors(T0sum(8),[G0tensor(70)])
  call ol_merge_tensors(T0sum(9),[G0tensor(1)])
  call ol_merge_tensors(T0sum(10),[G0tensor(76)])
  call ol_merge_tensors(T0sum(11),[G0tensor(81)])
  call ol_merge_tensors(T0sum(12),[G0tensor(87)])
  call ol_merge_tensors(T0sum(13),[G0tensor(26)])
  call ol_merge_tensors(T0sum(14),[G0tensor(92)])
  call ol_merge_tensors(T0sum(15),[G0tensor(97)])
  call ol_merge_tensors(T0sum(16),[G0tensor(7)])
  call ol_merge_tensors(T0sum(17),[G0tensor(104)])
  call ol_merge_tensors(T0sum(18),[G0tensor(29)])
  call ol_merge_tensors(T0sum(19),[G0tensor(110)])
  call ol_merge_tensors(T0sum(20),[G0tensor(25)])
  call ol_merge_tensors(T0sum(21),[G0tensor(115)])
  call ol_merge_tensors(T0sum(22),[G0tensor(28)])
  call ol_merge_tensors(T0sum(23),[G0tensor(121)])
  call ol_merge_tensors(T0sum(24),[G0tensor(36)])
  call ol_merge_tensors(T0sum(25),[G0tensor(127)])
  call ol_merge_tensors(T0sum(26),[G0tensor(132)])
  call ol_merge_tensors(T0sum(27),[G0tensor(42)])
  call ol_merge_tensors(T0sum(28),[G0tensor(46)])
  call ol_merge_tensors(T0sum(29),[G0tensor(51)])
  call ol_merge_tensors(T0sum(30),[G0tensor(58)])
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[12,3],[0,nME],2,2,wf4(:,2),wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,11),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H4(1),12,0,G1H4(1),n2h4(8))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[12,3],[0,nMM],2,2,wf4(:,2),wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,2),G0H4(2),m3h4x4(:,12),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G0H4(2),12,0,G1H4(2),n2h4(9))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[12,3],[0,nML],2,2,wf4(:,2),wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,2),G0H4(3),m3h4x4(:,13),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H4(3),12,0,G1H4(3),n2h4(10))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[12,3],[nMT,nMB],2,2,wf4(:,2),wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,14),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G0H4(4),12,nMT,G1H4(4),n2h4(11))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[12,3],[nMH,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(5),m3h4x4(:,15),heltab2x16(:,:,32))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[12,3],[nMZ,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,2),G1H4(6),m3h4x4(:,16),heltab2x16(:,:,33))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[12,3],[0,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(7),m3h4x4(:,17),heltab2x16(:,:,34))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[12,3],[nMZ,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(8),m3h4x4(:,18),heltab2x16(:,:,35))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[12,3],[0,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(9),m3h4x4(:,19),heltab2x16(:,:,36))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[12,3],[nMZ,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(10),m3h4x4(:,20),heltab2x16(:,:,37))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[12,3],[nMW,0],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,21),heltab2x16(:,:,38))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[12,3],[nMW,nMZ],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(2),m3h4x4(:,22),heltab2x16(:,:,39))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[12,3],[nMH,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(3),m3h4x4(:,23),heltab2x16(:,:,40))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[12,3],[0,nME],2,2,wf4(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,24),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G0H4(4),12,0,G1H4(11),n2h4(12))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[12,3],[0,nMM],2,2,wf4(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,25),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G0H4(4),12,0,G1H4(12),n2h4(13))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[12,3],[0,nML],2,2,wf4(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,26),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(4),12,0,G1H4(13),n2h4(14))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,27),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G0H4(4),12,0,G1H4(14),n2h4(15))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[12,3],[nMT,nMB],2,2,wf4(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,28),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G0H4(4),12,nMT,G1H4(15),n2h4(16))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[12,3],[nMH,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(16),m3h4x4(:,29),heltab2x16(:,:,46))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[12,3],[nMZ,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(17),m3h4x4(:,30),heltab2x16(:,:,47))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[12,3],[0,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,2),G1H4(18),m3h4x4(:,31),heltab2x16(:,:,48))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[12,3],[nMZ,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,2),G1H4(19),m3h4x4(:,32),heltab2x16(:,:,49))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[12,3],[0,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(20),m3h4x4(:,33),heltab2x16(:,:,50))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[12,3],[nMZ,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(21),m3h4x4(:,34),heltab2x16(:,:,51))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[12,3],[0,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(22),m3h4x4(:,35),heltab2x16(:,:,52))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[12,3],[nMZ,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(23),m3h4x4(:,36),heltab2x16(:,:,53))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[12,3],[nMW,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,37),heltab2x16(:,:,54))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[12,3],[nMW,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(5),m3h4x4(:,38),heltab2x16(:,:,55))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[12,3],[nMH,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(6),m3h4x4(:,39),heltab2x16(:,:,56))
  call Hloop_AS_Q(ntryL,G1H4(1),wf4(:,3),G1H1(1),ngPnl,m3h4x1(:,1),heltab2x4(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(8),n2h1(12))
  call Hloop_AS_Q(ntryL,G1H4(2),wf4(:,3),G1H1(1),ngPnl,m3h4x1(:,2),heltab2x4(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(2),n2h1(13))
  call Hloop_AS_Q(ntryL,G1H4(3),wf4(:,3),G1H1(1),ngPnl,m3h4x1(:,3),heltab2x4(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nML,G2tensor(3),n2h1(14))
  call Hloop_AS_Q(ntryL,G1H4(4),wf4(:,3),G1H1(1),ngPtb,m3h4x1(:,4),heltab2x4(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(4),n2h1(15))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(5),wf4(:,3),G1tensor(6),m3h4x1(:,5),heltab2x4(:,:,21))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(6),wf4(:,3),G1tensor(11),m3h4x1(:,6),heltab2x4(:,:,22))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(7),wf4(:,3),G1tensor(16),m3h4x1(:,7),heltab2x4(:,:,23))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(8),wf4(:,3),G1tensor(21),m3h4x1(:,8),heltab2x4(:,:,24))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(9),wf4(:,3),G1tensor(26),m3h4x1(:,9),heltab2x4(:,:,25))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(10),wf4(:,3),G1tensor(3),m3h4x1(:,10),heltab2x4(:,:,26))
  call Hcheck_last_TS_V(ntryL,l_switch,G0H4(1),12,wf4(:,3),3,G1tensor(4),m3h4x1(:,11),heltab2x4(:,:,27))
  call Hcheck_last_TS_V(ntryL,l_switch,G0H4(2),12,wf4(:,3),3,G1tensor(24),m3h4x1(:,12),heltab2x4(:,:,28))
  call Hcheck_last_TS_V(ntryL,l_switch,G0H4(3),12,wf4(:,3),3,G1tensor(9),m3h4x1(:,13),heltab2x4(:,:,29))
  call Hloop_AW_Q(ntryL,G1H4(11),wf4(:,1),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(10),n2h1(16))
  call Hloop_AW_Q(ntryL,G1H4(12),wf4(:,1),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(1),n2h1(17))
  call Hloop_AW_Q(ntryL,G1H4(13),wf4(:,1),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nML,G2tensor(11),n2h1(18))
  call Hloop_AW_Q(ntryL,G1H4(14),wf4(:,1),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(12),n2h1(19))
  call Hloop_AW_Q(ntryL,G1H4(15),wf4(:,1),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(5),n2h1(20))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(16),12,wf4(:,1),3,G2tensor(6),m3h4x1(:,19),heltab2x4(:,:,35))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(17),12,wf4(:,1),3,G2tensor(7),m3h4x1(:,20),heltab2x4(:,:,36))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(18),12,wf4(:,1),G2tensor(9),m3h4x1(:,21),heltab2x4(:,:,37))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(19),12,wf4(:,1),G2tensor(13),m3h4x1(:,22),heltab2x4(:,:,38))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(20),12,wf4(:,1),3,G2tensor(14),m3h4x1(:,23),heltab2x4(:,:,39))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(21),12,wf4(:,1),3,G2tensor(15),m3h4x1(:,24),heltab2x4(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(22),12,wf4(:,1),3,G2tensor(16),m3h4x1(:,25),heltab2x4(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(23),12,wf4(:,1),3,G2tensor(17),m3h4x1(:,26),heltab2x4(:,:,42))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(4),wf4(:,1),G0tensor(64),m3h4x1(:,27),heltab2x4(:,:,43))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(5),wf4(:,1),G0tensor(70),m3h4x1(:,28),heltab2x4(:,:,44))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(6),wf4(:,1),G0tensor(1),m3h4x1(:,29),heltab2x4(:,:,45))
  call ol_merge_tensors(G2tensor(16),[G2tensor(14),G2tensor(9),G1tensor(26),G1tensor(16),G0tensor(67),G0tensor(6)])
  call ol_merge_tensors(G0tensor(129),[G0tensor(72),G0tensor(24),G0tensor(11)])
  call ol_merge_tensors(G0tensor(79),[G0tensor(45),G0tensor(16)])
  call ol_merge_tensors(G0tensor(131),[G0tensor(119),G0tensor(101),G0tensor(96),G0tensor(86),G0tensor(75),G0tensor(68) &
    ,G0tensor(56),G0tensor(40),G0tensor(34),G0tensor(27),G0tensor(18),G0tensor(12),G0tensor(4),G0tensor(21)])
  call ol_merge_tensors(G1tensor(24),[G0tensor(70),G0tensor(84),G0tensor(32),G0tensor(2)])
  call ol_merge_tensors(G0tensor(123),[G0tensor(89),G0tensor(13)])
  call ol_merge_tensors(G0tensor(118),[G0tensor(95),G0tensor(23),G0tensor(3)])
  call ol_merge_tensors(G0tensor(136),[G0tensor(126),G0tensor(108),G0tensor(102),G0tensor(91),G0tensor(85),G0tensor(63) &
    ,G0tensor(50),G0tensor(41),G0tensor(33),G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(15),G2tensor(13),G2tensor(7),G1tensor(3),G1tensor(21),G1tensor(11),G0tensor(100) &
    ,G0tensor(39),G0tensor(8)])
  call ol_merge_tensors(G0tensor(135),[G0tensor(107),G0tensor(9)])
  call ol_merge_tensors(G0tensor(116),[G0tensor(52),G0tensor(30),G0tensor(14)])
  call ol_merge_tensors(G0tensor(111),[G0tensor(15)])
  call ol_merge_tensors(G1tensor(4),[G0tensor(64),G0tensor(20),G0tensor(17)])
  call ol_merge_tensors(G0tensor(125),[G0tensor(120),G0tensor(114),G0tensor(109),G0tensor(103),G0tensor(80),G0tensor(74) &
    ,G0tensor(69),G0tensor(62),G0tensor(57),G0tensor(35),G0tensor(19)])
  call ol_merge_tensors(G0tensor(112),[G0tensor(44),G0tensor(22)])
  call ol_merge_tensors(G0tensor(122),[G0tensor(31)])
  call ol_merge_tensors(G0tensor(133),[G0tensor(37)])
  call ol_merge_tensors(G0tensor(128),[G0tensor(38)])
  call ol_merge_tensors(G2tensor(12),[G0tensor(47),G0tensor(43)])
  call ol_merge_tensors(G0tensor(88),[G0tensor(83),G0tensor(59)])
  call ol_merge_tensors(G0tensor(105),[G0tensor(98),G0tensor(60)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(3),G0tensor(61)])
  call ol_merge_tensors(G0tensor(77),[G0tensor(65)])
  call ol_merge_tensors(G0tensor(99),[G0tensor(71),G0tensor(66)])
  call ol_merge_tensors(G0tensor(106),[G0tensor(78),G0tensor(73)])
  call ol_merge_tensors(G0tensor(93),[G0tensor(82)])
  call ol_merge_tensors(G0tensor(94),[G0tensor(90)])
  call ol_merge_tensors(G0tensor(124),[G0tensor(117),G0tensor(113)])
  call ol_merge_tensors(G0tensor(134),[G0tensor(130)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(8)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(9),G1tensor(6),G0tensor(1)])
call TI_bubble_red(G2tensor(16),12,mass2set(:,1),G0tensor(76),M2L1R1,G0tensor(81))
call TI_bubble_red(G2tensor(17),12,mass2set(:,2),G0tensor(87),M2L1R1,G0tensor(26),G0tensor(92))
call TI_bubble_red(G2tensor(12),12,mass2set(:,3),G0tensor(97),M2L1R1)
call TI_bubble_red(G2tensor(11),12,mass2set(:,4),G0tensor(7),M2L1R1,G0tensor(104))
call TI_bubble_red(G2tensor(10),12,mass2set(:,5),G0tensor(29),M2L1R1,G0tensor(110))
call TI_bubble_red(G2tensor(1),12,mass2set(:,6),G0tensor(25),M2L1R1,G0tensor(115))
call TI_bubble_red(G2tensor(5),12,mass2set(:,7),G0tensor(28),M2L1R1,G0tensor(121),G0tensor(36))
call TI_bubble_red(G2tensor(6),12,mass2set(:,8),G0tensor(127),M2L1R1,G0tensor(132),G0tensor(42))
  call ol_merge_tensors(G0tensor(132),[G0tensor(26),G0tensor(131),G0tensor(81)])
  call ol_merge_tensors(G0tensor(92),[G0tensor(136)])
  call ol_merge_tensors(G0tensor(104),[G0tensor(125)])
  call ol_merge_tensors(G0tensor(42),[G0tensor(55)])
call TI_bubble_red(G1tensor(24),12,mass2set(:,9),G0tensor(46),M2L1R1,G0tensor(51),G0tensor(58))
call TI_bubble_red(G1tensor(4),12,mass2set(:,10),G0tensor(67),M2L1R1,G0tensor(6))
  call ol_merge_tensors(G0tensor(6),[G0tensor(58),G0tensor(132)])
  call ol_merge_tensors(G0tensor(92),[G0tensor(51)])
  call ol_merge_tensors(T0sum(31),[G0tensor(76)])
  call ol_merge_tensors(T0sum(32),[G0tensor(6)])
  call ol_merge_tensors(T0sum(33),[G0tensor(129)])
  call ol_merge_tensors(T0sum(34),[G0tensor(79)])
  call ol_merge_tensors(T0sum(35),[G0tensor(46)])
  call ol_merge_tensors(T0sum(36),[G0tensor(92)])
  call ol_merge_tensors(T0sum(37),[G0tensor(123)])
  call ol_merge_tensors(T0sum(38),[G0tensor(118)])
  call ol_merge_tensors(T0sum(39),[G0tensor(87)])
  call ol_merge_tensors(T0sum(40),[G0tensor(135)])
  call ol_merge_tensors(T0sum(41),[G0tensor(116)])
  call ol_merge_tensors(T0sum(42),[G0tensor(111)])
  call ol_merge_tensors(T0sum(43),[G0tensor(67)])
  call ol_merge_tensors(T0sum(44),[G0tensor(104)])
  call ol_merge_tensors(T0sum(45),[G0tensor(112)])
  call ol_merge_tensors(T0sum(46),[G0tensor(122)])
  call ol_merge_tensors(T0sum(47),[G0tensor(133)])
  call ol_merge_tensors(T0sum(48),[G0tensor(128)])
  call ol_merge_tensors(T0sum(49),[G0tensor(97)])
  call ol_merge_tensors(T0sum(50),[G0tensor(48)])
  call ol_merge_tensors(T0sum(51),[G0tensor(49)])
  call ol_merge_tensors(T0sum(52),[G0tensor(53)])
  call ol_merge_tensors(T0sum(53),[G0tensor(54)])
  call ol_merge_tensors(T0sum(54),[G0tensor(42)])
  call ol_merge_tensors(T0sum(55),[G0tensor(88)])
  call ol_merge_tensors(T0sum(56),[G0tensor(105)])
  call ol_merge_tensors(T0sum(57),[G0tensor(7)])
  call ol_merge_tensors(T0sum(58),[G0tensor(77)])
  call ol_merge_tensors(T0sum(59),[G0tensor(99)])
  call ol_merge_tensors(T0sum(60),[G0tensor(106)])
  call ol_merge_tensors(T0sum(61),[G0tensor(93)])
  call ol_merge_tensors(T0sum(62),[G0tensor(94)])
  call ol_merge_tensors(T0sum(63),[G0tensor(124)])
  call ol_merge_tensors(T0sum(64),[G0tensor(134)])
  call ol_merge_tensors(T0sum(65),[G0tensor(29)])
  call ol_merge_tensors(T0sum(66),[G0tensor(110)])
  call ol_merge_tensors(T0sum(67),[G0tensor(25)])
  call ol_merge_tensors(T0sum(68),[G0tensor(115)])
  call ol_merge_tensors(T0sum(69),[G0tensor(28)])
  call ol_merge_tensors(T0sum(70),[G0tensor(121)])
  call ol_merge_tensors(T0sum(71),[G0tensor(36)])
  call ol_merge_tensors(T0sum(72),[G0tensor(127)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppllj_ew_nllxuxd_1_/**/REALKIND
