
module ol_vamp_1_ppllj_ew_nenexddxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj_ew_nenexddxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj_ew_nenexddxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllj_ew_nenexddxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllj_ew_nenexddxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllj_ew_nenexddxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllj_ew_nenexddxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,nMZ,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(6)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,nMW,nME,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[0,nMZ,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(3))
  call Hloop_AQ_Z(ntryL,G1H16(1),ex3(:),G1H8(1),ngZd,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_W(ntryL,G1H16(2),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex3(:),G1H8(3),ngZd,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(1),n2h4(1))
  call Hloop_WQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),21,nME,G2H4(2),n2h4(2))
  call Hloop_ZA_Q(ntryL,G1H8(3),ex2(:),G1H4(1),ngZn,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(3),n2h4(3))
  call Hloop_QA_Z(ntryL,G2H4(1),ex2(:),G2H2(1),ngZn,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_W(ntryL,G2H4(2),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_Z(ntryL,G2H4(3),ex1(:),G2H2(3),ngZn,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(2),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),ngZd,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(1))
  call Hloop_ZA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),ngZd,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(2),n2h1(2))
  call Hloop_ZA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),ngZd,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(3))
  call Hloop_WA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(4))
  call Hloop_WA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(5),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(6))
  call Hloop_ZA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),ngZd,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(7))
  call Hloop_ZA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),ngZd,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(8),n2h1(8))
  call Hloop_ZA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),ngZd,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(9))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(1),n2h16(4))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,3,8,4],[0,0,nMZ,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(2),n2h16(5))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,3,8,4],[0,0,nMW,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(6))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(4),n2h16(7))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(5),n2h16(8))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,3,4,8],[0,0,nMZ,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(6),n2h16(9))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,3,4,8],[0,0,nMW,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(7),n2h16(10))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(8),n2h16(11))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,4,3,8],[0,nMW,nMW,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(9),n2h16(12))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,13),heltab2x32(:,:,13))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[20,2,1,8],[nMZ,0,nMZ,0],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngZd,m3h4x8(:,1),heltab2x32(:,:,14))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[20,1,2,8],[nMZ,0,nMZ,0],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(2),ngZd,m3h4x8(:,2),heltab2x32(:,:,15))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[20,1,2,8],[nMW,nME,nMW,0],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,3),heltab2x32(:,:,16))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[24,2,1,4],[nMZ,0,nMZ,0],4,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,5),G0H8(4),ngZd,m3h4x8(:,4),heltab2x32(:,:,17))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[24,2,1,4],[nMW,nME,nMW,0],4,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,5),G0H8(5),m3h4x8(:,5),heltab2x32(:,:,18))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[24,1,2,4],[nMZ,0,nMZ,0],4,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,5),G0H8(6),ngZd,m3h4x8(:,6),heltab2x32(:,:,19))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(5)])
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,1),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(1),n2h4(4))
  call Hloop_QZ_A(ntryL,G1H16(2),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,2),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(2),n2h4(5))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,3),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(3),n2h4(6))
  call Hloop_AZ_Q(ntryL,G1H16(8),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,4),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(4),n2h4(7))
  call Hloop_AZ_Q(ntryL,G1H16(6),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,5),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(5),n2h4(8))
  call Hloop_AZ_Q(ntryL,G1H16(7),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,6),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(6),n2h4(9))
  call Hloop_AQ_W(ntryL,G1H16(9),ex3(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,10))
  call Hloop_VQ_A(ntryL,G1H16(10),ex3(:),G1H8(2),m3h2x8(:,5),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(2),20,0,G2H8(1),n2h8(1))
  call Hloop_ZA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),ngZn,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(1),n2h4(10))
  call Hloop_ZQ_A(ntryL,G0H8(2),ex1(:),G0H4(1),ngZn,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(2),n2h4(11))
  call Hloop_WQ_A(ntryL,G0H8(3),ex1(:),G0H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G0H4(1),21,nME,G1H4(3),n2h4(12))
  call Hloop_ZA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),ngZn,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(4),n2h4(13))
  call Hloop_WA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G0H4(1),26,nME,G1H4(5),n2h4(14))
  call Hloop_ZQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),ngZn,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(6),n2h4(15))
  call Hloop_QA_V(ntryL,G2H4(1),ex4(:),G2H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_Z(ntryL,G2H4(2),ex4(:),G2H2(2),ngZd,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_W(ntryL,G2H4(3),ex4(:),G2H2(3),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(4),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_Z(ntryL,G2H4(5),ex3(:),G2H2(5),ngZd,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_W(ntryL,G2H4(6),ex3(:),G2H2(6),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_UV_W(ntryL,G1H8(1),20,wf4(:,1),3,G2H2(7),m3h4x2(:,1),heltab2x8(:,:,10))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(3),mass4set(:,1),  & 
G1H8(3),G1H8(2),G1H8(1),G1H8(4),G1H8(5),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hloop_AQ_Z(ntryL,G1H4(1),ex1(:),G1H2(1),ngZn,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_Z(ntryL,G1H4(2),ex2(:),G1H2(2),ngZn,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_W(ntryL,G1H4(3),ex2(:),G1H2(6),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H4(4),ex1(:),G1H2(7),ngZn,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_W(ntryL,G1H4(5),ex1(:),G1H2(8),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_Z(ntryL,G1H4(6),ex2(:),G1H2(12),ngZn,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QZ_A(ntryL,G1H8(3),wf4(:,1),G1H2(13),ngZd,m3h4x2(:,2),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(13),23,0,G2H2(8),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex4(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,12))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,1),G1H2(14),ngZd,m3h4x2(:,3),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(14),23,0,G2H2(9),n2h2(2))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,1),G1H2(18),ngZd,m3h4x2(:,4),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(18),23,0,G2H2(10),n2h2(3))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(6),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(15)])
  call Hloop_ZA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(10))
  call Hloop_ZA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),ngZd,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(11))
  call Hloop_ZA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),ngZd,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(12))
  call Hloop_WA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(13))
  call Hloop_WA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(14))
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(3),mass4set(:,2),  & 
G1H2(13),G1H2(14),G1H2(18),G1H2(3),G1H2(5),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),ngZd,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(15))
  call Hloop_ZA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),ngZd,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(16))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(10),mass4set(:,1),  & 
G1H2(9),G1H2(11),G1H2(15),G1H2(2),G1H2(4),2)
  call HG1shiftOLR(G1H2(11),4,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(10),mass4set(:,3),  & 
G1H2(17),G1H2(6),G1H2(10),G1H2(1),G1H2(16),2)
  call HG1shiftOLR(G1H2(6),4,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(10),mass4set(:,4),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),2)
  call HG1shiftOLR(G1H2(20),4,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(11),mass4set(:,1),  & 
G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(25),8,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(11),mass4set(:,3),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(11),mass4set(:,4),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(35),8,2)
  call Hloop_ZQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),ngZd,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(17))
  call Hloop_WQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(18))
  call Hloop_ZQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),ngZd,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(19))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(17),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex4(:),G2tensor(18),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hloop_WA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(20))
  call Hloop_WA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(20),n2h1(21))
  call Hloop_WA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(23),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(25))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex3(:),G1H1(1),ngZd,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(26))
  call Hloop_ZQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),ngZd,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(26),n2h1(27))
  call Hloop_ZQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),ngZd,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(28))
  call Hloop_WQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(29))
  call Hloop_WQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(29),n2h1(30))
  call Hloop_WQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(30),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(32),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(28),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(34))
  call Hloop_ZA_Q(ntryL,G1H2(29),ex4(:),G1H1(1),ngZd,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(35))
  call Hloop_ZA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),ngZd,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(35),n2h1(36))
  call Hloop_ZA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),ngZd,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(37))
  call Hloop_WA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(38))
  call Hloop_WA_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(38),n2h1(39))
  call Hloop_WA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(40))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(17),G1tensor(5)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(16)])
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(12),mass4set(:,5),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(2),G1tensor(6))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(4),mass4set(:,6),  & 
G1tensor(8),G1tensor(12),G1tensor(14),G1tensor(18),G1tensor(3))
  call G_TensorShift(G1tensor(12),10)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(12),mass4set(:,7),  & 
G1tensor(4),G1tensor(17),G1tensor(5),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(17),2)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(4),mass4set(:,8),  & 
G1tensor(11),G1tensor(15),G1tensor(16),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(15),10)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(13),mass4set(:,5),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),1)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(8),mass4set(:,6),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),9)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,9),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,3),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),8)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(3),mass4set(:,10),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),8)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(1),mass4set(:,11),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),8)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(2),mass4set(:,12),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),8)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(3),mass4set(:,2),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),8)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(6),mass4set(:,9),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(7),mass4set(:,3),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(14),mass4set(:,9),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),4)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(14),mass4set(:,11),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),4)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(15),mass4set(:,9),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(3),mass4set(:,1),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),8)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(10),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(10),mass4set(:,3),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),4)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(10),mass4set(:,4),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),4)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(11),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),8)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(11),mass4set(:,3),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),8)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(11),mass4set(:,4),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),8)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(12),mass4set(:,5),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(4),mass4set(:,6),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(12),mass4set(:,7),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(4),mass4set(:,8),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(13),mass4set(:,5),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(8),mass4set(:,6),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,9),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(2),mass4set(:,3),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(3),mass4set(:,10),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(1),mass4set(:,11),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(2),mass4set(:,12),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(3),mass4set(:,2),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(6),mass4set(:,9),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(7),mass4set(:,3),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(14),mass4set(:,9),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(14),mass4set(:,11),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(15),mass4set(:,9),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(3),mass4set(:,1),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(10),mass4set(:,1),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(10),mass4set(:,3),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(10),mass4set(:,4),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(11),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(11),mass4set(:,3),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(11),mass4set(:,4),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(13))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(5),n2h16(14))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(4),n2h16(15))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(16))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(17))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(18))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(6),n2h16(19))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(20))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,7),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[20,3,8],[0,0,nMZ],3,2,wf4(:,3),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(2),ngZd,m3h4x8(:,8),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H8(2),20,0,G1H8(2),n2h8(4))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[20,3,8],[0,0,nMW],3,2,wf4(:,3),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,9),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G0H8(3),20,0,G1H8(4),n2h8(5))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,10),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H8(4),20,0,G1H8(5),n2h8(6))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[20,3,8],[nMW,nMW,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,11),heltab2x32(:,:,32))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[24,3,4],[0,0,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(6),m3h4x8(:,12),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(6),24,0,G1H8(6),n2h8(7))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[24,3,4],[0,0,nMZ],3,2,wf4(:,5),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(1),ngZd,m3h4x8(:,13),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H8(1),24,0,G1H8(7),n2h8(8))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[24,3,4],[0,0,nMW],3,2,wf4(:,5),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(2),m3h4x8(:,14),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(2),24,0,G1H8(8),n2h8(9))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[24,3,4],[0,0,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(3),m3h4x8(:,15),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H8(3),24,0,G1H8(9),n2h8(10))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[24,3,4],[nMW,nMW,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,5),G0H8(4),m3h4x8(:,16),heltab2x32(:,:,37))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,7,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(9),n2h16(21))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,7,8],[0,nMZ,0],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(10),n2h16(22))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,7,8],[0,nMW,0],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(11),n2h16(23))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,7,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(12),n2h16(24))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,7,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,26),heltab2x32(:,:,42))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,4,11],[0,0,0],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(14),n2h16(25))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,4,11],[0,nMZ,0],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(15),n2h16(26))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,4,11],[0,nMW,0],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(16),n2h16(27))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,4,11],[0,0,0],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(17),n2h16(28))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,4,11],[0,0,0],3,1,wf8(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(18),m3h2x16(:,31),heltab2x32(:,:,47))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[28,1,2],[nME,nMW,nME],3,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,12),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H4(1),28,nME,G1H4(2),n2h4(16))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[28,1,2],[nME,nMW,nME],3,1,wf8(:,13))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,13),G0H4(1),ngZl,m3h8x4(:,2),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H4(1),28,nME,G1H4(3),n2h4(17))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,12))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,12),28,G1H4(4),m3h8x4(:,3),heltab2x32(:,:,50))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(5),m3h8x4(:,4),heltab2x32(:,:,51))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[28,1,2],[nME,nMW,nME],3,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,12),G0H4(1),m3h8x4(:,5),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H4(1),28,nME,G1H4(6),n2h4(18))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[28,1,2],[0,nMZ,0],3,1,wf8(:,13))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,13),G0H4(1),ngZn,m3h8x4(:,6),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(7),n2h4(19))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[28,1,2],[nME,nMW,nME],3,1,wf8(:,13))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,13),G0H4(1),ngZl,m3h8x4(:,7),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H4(1),28,nME,G1H4(8),n2h4(20))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,12))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,12),G0H4(1),m3h8x4(:,8),heltab2x32(:,:,55))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,13),G0H4(2),m3h8x4(:,9),heltab2x32(:,:,56))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,12))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,12),G0H4(3),m3h8x4(:,10),heltab2x32(:,:,57))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,13),G0H4(4),m3h8x4(:,11),heltab2x32(:,:,58))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,12),28,G1H4(9),m3h8x4(:,12),heltab2x32(:,:,59))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(10),m3h8x4(:,13),heltab2x32(:,:,60))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[28,1,2],[nME,nMW,nME],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,15),G0H4(5),m3h8x4(:,14),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H4(5),28,nME,G1H4(11),n2h4(21))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[28,1,2],[nME,nMW,nME],3,1,wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,16),G0H4(5),ngZl,m3h8x4(:,15),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H4(5),28,nME,G1H4(12),n2h4(22))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,15))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(13),m3h8x4(:,16),heltab2x32(:,:,63))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,16))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(14),m3h8x4(:,17),heltab2x32(:,:,64))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[28,1,2],[nME,nMW,nME],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,15),G0H4(5),m3h8x4(:,18),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H4(5),28,nME,G1H4(15),n2h4(23))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[28,1,2],[0,nMZ,0],3,1,wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,16),G0H4(5),ngZn,m3h8x4(:,19),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H4(5),28,0,G1H4(16),n2h4(24))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[28,1,2],[nME,nMW,nME],3,1,wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,16),G0H4(5),ngZl,m3h8x4(:,20),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H4(5),28,nME,G1H4(17),n2h4(25))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,15))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,15),G0H4(5),m3h8x4(:,21),heltab2x32(:,:,68))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,16))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,16),G0H4(6),m3h8x4(:,22),heltab2x32(:,:,69))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,15))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,15),G0H4(7),m3h8x4(:,23),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,16))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,16),G0H4(8),m3h8x4(:,24),heltab2x32(:,:,71))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(18),m3h8x4(:,25),heltab2x32(:,:,72))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[28,1,2],[nMW,nME,nMW],3,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(19),m3h8x4(:,26),heltab2x32(:,:,73))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(3),G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(17),[G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(11),G1H4(3),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(13),G1H4(5),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(15),G1H4(8),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(6),[G0H4(5),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(8),[G0H4(7),G0H4(4),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(18),G1H4(10),G1H4(9)])
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,1),G1H2(7),ngZd,m3h4x2(:,5),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(7),23,0,G2H2(7),n2h2(4))
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,1),G1H4(11),ngZu,m3h4x4(:,7),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(11),19,0,G2H4(1),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,1),G1H4(3),ngZu,m3h4x4(:,8),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(3),19,nMT,G2H4(2),n2h4(27))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,1),G1H4(2),ngZu,m3h4x4(:,9),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(2),19,0,G2H4(3),n2h4(28))
  call Hloop_QZ_A(ntryL,G1H16(2),wf4(:,1),G1H4(13),ngZu,m3h4x4(:,10),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(13),19,nMT,G2H4(4),n2h4(29))
  call Hloop_AZ_Q(ntryL,G1H16(3),wf4(:,1),G1H4(5),ngZd,m3h4x4(:,11),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(5),19,0,G2H4(5),n2h4(30))
  call Hloop_AZ_Q(ntryL,G1H16(8),wf4(:,1),G1H4(4),ngZd,m3h4x4(:,12),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(4),19,nMB,G2H4(6),n2h4(31))
  call Hloop_QZ_A(ntryL,G1H16(6),wf4(:,1),G1H4(15),ngZd,m3h4x4(:,13),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(15),19,0,G2H4(7),n2h4(32))
  call Hloop_QZ_A(ntryL,G1H16(7),wf4(:,1),G1H4(8),ngZd,m3h4x4(:,14),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(8),19,nMB,G2H4(8),n2h4(33))
  call Hloop_QZ_A(ntryL,G1H8(2),wf4(:,1),G1H2(8),ngZd,m3h4x2(:,6),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(8),23,0,G2H2(1),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,1),G1H2(12),ngZu,m3h4x2(:,7),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(12),23,0,G2H2(2),n2h2(6))
  call Hloop_UV_W(ntryL,G0H8(5),20,wf4(:,1),3,G1H2(13),m3h4x2(:,8),heltab2x8(:,:,18))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf4(:,1),G1H2(14),ngZd,m3h4x2(:,9),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(14),27,0,G2H2(3),n2h2(7))
  call Hloop_AZ_Q(ntryL,G1H8(7),wf4(:,1),G1H2(5),ngZd,m3h4x2(:,10),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(4),n2h2(8))
  call Hloop_AZ_Q(ntryL,G1H8(8),wf4(:,1),G1H2(9),ngZu,m3h4x2(:,11),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(9),27,0,G2H2(5),n2h2(9))
  call Hloop_UW_V(ntryL,G0H8(4),24,wf4(:,1),3,G1H2(11),m3h4x2(:,12),heltab2x8(:,:,22))
  call Hloop_AQ_V(ntryL,G1H16(12),wf8(:,17),G1H2(4),m3h8x2(:,1),heltab2x16(:,:,20))
  call Hloop_AQ_Z(ntryL,G1H16(10),wf8(:,17),G1H2(17),ngZd,m3h8x2(:,2),heltab2x16(:,:,21))
  call Hloop_AQ_W(ntryL,G1H16(11),wf8(:,17),G1H2(6),m3h8x2(:,3),heltab2x16(:,:,22))
  call Hloop_VQ_A(ntryL,G1H16(13),wf8(:,17),G1H2(16),m3h8x2(:,4),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(16),23,0,G2H2(6),n2h2(10))
  call Hloop_AQ_V(ntryL,G1H16(17),ex3(:),G1H8(3),m3h2x8(:,6),heltab2x16(:,:,24))
  call Hloop_AQ_Z(ntryL,G1H16(15),ex3(:),G1H8(1),ngZd,m3h2x8(:,7),heltab2x16(:,:,25))
  call Hloop_AQ_W(ntryL,G1H16(16),ex3(:),G1H8(6),m3h2x8(:,8),heltab2x16(:,:,26))
  call Hloop_VQ_A(ntryL,G1H16(18),ex3(:),G1H8(5),m3h2x8(:,9),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(5),20,0,G2H8(1),n2h8(11))
  call Hloop_AQ_S(ntryL,G1H4(12),ex1(:),G1H2(19),ngPln,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_SQ_A(ntryL,G1H4(14),ex1(:),G1H2(20),ngPln,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(20),29,nME,G2H2(8),n2h2(11))
  call Hloop_AQ_W(ntryL,G1H4(17),ex1(:),G1H2(23),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_Z(ntryL,G1H4(16),ex1(:),G1H2(24),ngZn,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_SQ_A(ntryL,G0H4(6),ex1(:),G0H2(1),ngPln,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G0H2(1),29,nME,G1H2(25),n2h2(12))
  call Hloop_WQ_A(ntryL,G0H4(8),ex1(:),G0H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G0H2(1),29,nME,G1H2(28),n2h2(13))
  call Hloop_WQ_A(ntryL,G1H4(19),ex1(:),G1H2(29),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(29),29,nME,G2H2(10),n2h2(14))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(6),[G1H2(37),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(25)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,1),heltab2x4(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(2),n2h1(41))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(3),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hloop_WA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(42))
  call Hloop_WA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(45))
  call Hloop_ZQ_A(ntryL,G1H2(10),ex3(:),G1H1(1),ngZd,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(46))
  call Hloop_ZQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),ngZd,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(47))
  call Hloop_WQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(48))
  call Hloop_WQ_A(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(50))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(51))
  call Hloop_ZA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),ngZd,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(52))
  call Hloop_ZA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),ngZd,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(53))
  call Hloop_WA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(54))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(15),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hloop_AV_Q(ntryL,G2H4(5),wf4(:,6),G2H1(1),m3h4x1(:,2),heltab2x4(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(1),n2h1(55))
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,6),G2H1(1),m3h4x1(:,3),heltab2x4(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(2),n2h1(56))
  call Hloop_QV_A(ntryL,G2H4(7),wf4(:,6),G2H1(1),m3h4x1(:,4),heltab2x4(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(3),n2h1(57))
  call Hloop_QV_A(ntryL,G2H4(4),wf4(:,6),G2H1(1),m3h4x1(:,5),heltab2x4(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(4),n2h1(58))
  call Hloop_AV_Q(ntryL,G2H4(6),wf4(:,6),G2H1(1),m3h4x1(:,6),heltab2x4(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(5),n2h1(59))
  call Hloop_QV_A(ntryL,G2H4(8),wf4(:,6),G2H1(1),m3h4x1(:,7),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(6),n2h1(60))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(16),ngZd,m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(17),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(22),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(25),ngZd,m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(28),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hloop_WQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(61))
  call Hloop_VA_Q(ntryL,G1H8(3),wf8(:,14),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(62))
  call Hloop_ZA_Q(ntryL,G1H8(1),wf8(:,14),G1H1(1),ngZd,m3h8x1(:,2),heltab2x8(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(63))
  call Hloop_WA_Q(ntryL,G1H8(6),wf8(:,14),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(1),wf8(:,14),G2tensor(41),m3h8x1(:,4),heltab2x8(:,:,26))
  call Hloop_SA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),ngPnl,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(42),n2h1(65))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(43),ngPnl,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hloop_WA_Q(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(44),n2h1(66))
  call Hloop_ZA_Q(ntryL,G1H2(24),ex2(:),G1H1(1),ngZn,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(67))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(46),m3h2x1(:,68),heltab2x2(:,:,68))
  call ol_merge_tensors(G2tensor(41),[G2tensor(34),G2tensor(18),G1tensor(90),G0tensor(90)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(57),G1tensor(10),G0tensor(57),G0tensor(15)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(21),G1tensor(60),G1tensor(20),G0tensor(60),G0tensor(20)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(23),G1tensor(92),G1tensor(88),G0tensor(92),G0tensor(88)])
  call ol_merge_tensors(G3tensor(3),[G3tensor(1),G2tensor(39),G2tensor(36),G2tensor(33),G2tensor(30),G2tensor(27),G2tensor(24) &
    ,G1tensor(120),G1tensor(115),G1tensor(110),G1tensor(105),G1tensor(100),G1tensor(95),G0tensor(120),G0tensor(115),G0tensor(110) &
    ,G0tensor(105),G0tensor(100),G0tensor(95)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(26),G1tensor(97),G0tensor(97)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(29),G1tensor(102),G0tensor(102)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(32),G1tensor(107),G0tensor(107)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(35),G1tensor(112),G0tensor(112)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(38),G1tensor(117),G0tensor(117)])
  call ol_merge_tensors(G1tensor(12),[G1tensor(7),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G1tensor(82),[G1tensor(32),G1tensor(13),G0tensor(82),G0tensor(32),G0tensor(3)])
  call ol_merge_tensors(G1tensor(37),[G1tensor(2),G0tensor(37),G0tensor(4)])
  call ol_merge_tensors(G1tensor(42),[G1tensor(25),G1tensor(6),G0tensor(42),G0tensor(25),G0tensor(5)])
  call ol_merge_tensors(G1tensor(35),[G1tensor(14),G0tensor(35),G0tensor(8)])
  call ol_merge_tensors(G1tensor(40),[G1tensor(18),G0tensor(40),G0tensor(9)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(45),G1tensor(30),G1tensor(3),G0tensor(45),G0tensor(30),G0tensor(10)])
  call ol_merge_tensors(G1tensor(15),[G1tensor(17),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(43),G1tensor(47),G1tensor(5),G0tensor(47),G0tensor(13)])
  call ol_merge_tensors(G1tensor(52),[G1tensor(9),G0tensor(52),G0tensor(14)])
  call ol_merge_tensors(G1tensor(50),[G1tensor(16),G0tensor(50),G0tensor(18)])
  call ol_merge_tensors(G1tensor(55),[G1tensor(19),G0tensor(55),G0tensor(19)])
  call ol_merge_tensors(G1tensor(27),[G1tensor(22),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G1tensor(72),[G1tensor(62),G1tensor(23),G0tensor(72),G0tensor(62),G0tensor(23)])
  call ol_merge_tensors(G1tensor(67),[G1tensor(24),G0tensor(67),G0tensor(24)])
  call ol_merge_tensors(G1tensor(65),[G1tensor(28),G0tensor(65),G0tensor(28)])
  call ol_merge_tensors(G1tensor(70),[G1tensor(29),G0tensor(70),G0tensor(29)])
  call ol_merge_tensors(G1tensor(38),[G1tensor(33),G0tensor(38),G0tensor(33)])
  call ol_merge_tensors(G1tensor(64),[G1tensor(43),G1tensor(34),G0tensor(64),G0tensor(43),G0tensor(34)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(114),G1tensor(69),G1tensor(44),G1tensor(39),G0tensor(114),G0tensor(69),G0tensor(44) &
    ,G0tensor(39)])
  call ol_merge_tensors(G1tensor(53),[G1tensor(48),G0tensor(53),G0tensor(48)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(58),G1tensor(49),G0tensor(58),G0tensor(49)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(119),G1tensor(59),G1tensor(54),G0tensor(119),G0tensor(59),G0tensor(54)])
  call ol_merge_tensors(G1tensor(68),[G1tensor(63),G0tensor(68),G0tensor(63)])
  call ol_merge_tensors(G1tensor(73),[G0tensor(73)])
  call ol_merge_tensors(G1tensor(84),[G1tensor(74),G0tensor(84),G0tensor(74)])
  call ol_merge_tensors(G1tensor(75),[G0tensor(75)])
  call ol_merge_tensors(G1tensor(77),[G0tensor(77)])
  call ol_merge_tensors(G1tensor(78),[G0tensor(78)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(79),G0tensor(79)])
  call ol_merge_tensors(G1tensor(80),[G0tensor(80)])
  call ol_merge_tensors(G1tensor(83),[G0tensor(83)])
  call ol_merge_tensors(G1tensor(85),[G0tensor(85)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(87),G0tensor(87)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(3),G1tensor(109),G1tensor(89),G0tensor(109),G0tensor(89)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(93),G0tensor(93)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(94),G0tensor(94)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(98),G0tensor(98)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(99),G0tensor(99)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(103),G0tensor(103)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(104),G0tensor(104)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(108),G0tensor(108)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(113),G0tensor(113)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(118),G0tensor(118)])
  call ol_merge_tensors(G3tensor(4),[G3tensor(2)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(5)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(42)])
  call TI_triangle_red(G2tensor(41),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(20),RedBasis(19),mass3set(:,2),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1,[nMW], &
    G0tensor(41))
  call TI_triangle_red(G2tensor(40),RedBasis(1),mass3set(:,3),G0tensor(46),G0tensor(51),G0tensor(56),G0tensor(61),M2L1R1,[nMW], &
    G0tensor(66))
  call TI_triangle_red(G2tensor(15),RedBasis(5),mass3set(:,1),G0tensor(71),G0tensor(76),G0tensor(81),G0tensor(86),M2L1R1)
  call TI_triangle_red(G3tensor(3),RedBasis(15),mass3set(:,1),G0tensor(91),G0tensor(96),G0tensor(101),G0tensor(106),M2L1R1)
  call TI_triangle_red(G2tensor(16),RedBasis(5),mass3set(:,4),G0tensor(111),G0tensor(116),G0tensor(90),G0tensor(57),M2L1R1,[nMZ], &
    G0tensor(15))
  call TI_triangle_red(G2tensor(17),RedBasis(5),mass3set(:,5),G0tensor(60),G0tensor(20),G0tensor(92),G0tensor(88),M2L1R1,[nMW], &
    G0tensor(120))
  call TI_triangle_red(G2tensor(22),RedBasis(25),mass3set(:,1),G0tensor(115),G0tensor(110),G0tensor(105),G0tensor(100),M2L1R1)
  call TI_triangle_red(G2tensor(25),RedBasis(25),mass3set(:,4),G0tensor(95),G0tensor(97),G0tensor(102),G0tensor(107),M2L1R1,[nMZ], &
    G0tensor(112))
  call TI_triangle_red(G2tensor(28),RedBasis(25),mass3set(:,5),G0tensor(117),G0tensor(7),G0tensor(2),G0tensor(82),M2L1R1,[nMW], &
    G0tensor(32))
  call TI_triangle_red(G2tensor(37),RedBasis(1),mass3set(:,6),G0tensor(3),G0tensor(37),G0tensor(4),G0tensor(42),M2L1R1,[nMZ], &
    G0tensor(25))
  call TI_triangle_red(G2tensor(46),RedBasis(21),mass3set(:,7),G0tensor(5),G0tensor(35),G0tensor(8),G0tensor(40),M2L1R1,[nMW,nME], &
    G0tensor(9),G0tensor(45))
  call TI_triangle_red(G2tensor(13),RedBasis(3),mass3set(:,6),G0tensor(30),G0tensor(10),G0tensor(17),G0tensor(12),M2L1R1,[nMZ], &
    G0tensor(47))
  call TI_triangle_red(G2tensor(5),RedBasis(5),mass3set(:,8),G0tensor(13),G0tensor(52),G0tensor(14),G0tensor(50),M2L1R1,[nMW], &
    G0tensor(18))
  call TI_triangle_red(G2tensor(6),RedBasis(3),mass3set(:,3),G0tensor(55),G0tensor(19),G0tensor(27),G0tensor(22),M2L1R1,[nMW], &
    G0tensor(72))
  call TI_triangle_red(G2tensor(31),RedBasis(25),mass3set(:,8),G0tensor(62),G0tensor(23),G0tensor(67),G0tensor(24),M2L1R1,[nMW], &
    G0tensor(65))
  call TI_triangle_red(G2tensor(2),RedBasis(19),mass3set(:,1),G0tensor(28),G0tensor(70),G0tensor(29),G0tensor(38),M2L1R1)
  call TI_triangle_red(G2tensor(19),RedBasis(3),mass3set(:,1),G0tensor(33),G0tensor(64),G0tensor(43),G0tensor(34),M2L1R1)
  call TI_triangle_red(G2tensor(8),RedBasis(17),mass3set(:,1),G0tensor(114),G0tensor(69),G0tensor(44),G0tensor(39),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(16),mass3set(:,1),G0tensor(53),G0tensor(48),G0tensor(58),G0tensor(49),M2L1R1)
  call TI_triangle_red(G2tensor(1),RedBasis(17),mass3set(:,6),G0tensor(119),G0tensor(59),G0tensor(54),G0tensor(68),M2L1R1,[nMZ], &
    G0tensor(63))
  call TI_triangle_red(G2tensor(4),RedBasis(16),mass3set(:,6),G0tensor(73),G0tensor(84),G0tensor(74),G0tensor(75),M2L1R1,[nMZ], &
    G0tensor(77))
  call TI_triangle_red(G2tensor(7),RedBasis(17),mass3set(:,3),G0tensor(78),G0tensor(79),G0tensor(80),G0tensor(83),M2L1R1,[nMW], &
    G0tensor(85))
  call TI_triangle_red(G2tensor(10),RedBasis(16),mass3set(:,3),G0tensor(87),G0tensor(109),G0tensor(89),G0tensor(93),M2L1R1,[nMW], &
    G0tensor(94))
  call TI_triangle_red(G2tensor(11),RedBasis(18),mass3set(:,1),G0tensor(98),G0tensor(99),G0tensor(103),G0tensor(104),M2L1R1)
  call TI_triangle_red(G2tensor(12),RedBasis(18),mass3set(:,6),G0tensor(108),G0tensor(113),G0tensor(118), &
    G0tensor(121),M2L1R1,[nMZ],G0tensor(122))
  call TI_triangle_red(G2tensor(14),RedBasis(18),mass3set(:,3),G0tensor(123),G0tensor(124),G0tensor(125), &
    G0tensor(126),M2L1R1,[nMW],G0tensor(127))
  call TI_triangle_red(G3tensor(4),RedBasis(15),mass3set(:,9),G0tensor(128),G0tensor(129),G0tensor(130), &
    G0tensor(131),M2L1R1,[nMT],G0tensor(132))
  call TI_triangle_red(G3tensor(6),RedBasis(15),mass3set(:,10),G0tensor(133),G0tensor(134),G0tensor(135), &
    G0tensor(136),M2L1R1,[nMB],G0tensor(137))
  call TI_triangle_red(G2tensor(44),RedBasis(21),mass3set(:,11),G0tensor(138),G0tensor(139),G0tensor(140), &
    G0tensor(141),M2L1R1,[nME,nMW],G0tensor(142),G0tensor(143))
  call TI_triangle_red(G2tensor(45),RedBasis(21),mass3set(:,6),G0tensor(144),G0tensor(145),G0tensor(146), &
    G0tensor(147),M2L1R1,[nMZ],G0tensor(148))
  call TI_triangle_red(G1tensor(12),RedBasis(29),mass3set(:,6),G0tensor(149),G0tensor(150),G0tensor(151), &
    G0tensor(152),M2L1R1,[nMZ],G0tensor(153))
  call TI_triangle_red(G1tensor(82),RedBasis(21),mass3set(:,12),G0tensor(154),G0tensor(155),G0tensor(156), &
    G0tensor(157),M2L1R1,[nMZ],G0tensor(158))
  call TI_triangle_red(G1tensor(37),RedBasis(20),mass3set(:,4),G0tensor(159),G0tensor(160),G0tensor(161), &
    G0tensor(162),M2L1R1,[nMZ],G0tensor(163))
  call TI_triangle_red(G1tensor(42),RedBasis(19),mass3set(:,13),G0tensor(164),G0tensor(165),G0tensor(166), &
    G0tensor(167),M2L1R1,[nMZ],G0tensor(168))
  call TI_triangle_red(G1tensor(35),RedBasis(4),mass3set(:,14),G0tensor(169),G0tensor(170),G0tensor(171), &
    G0tensor(172),M2L1R1,[nMZ],G0tensor(173))
  call TI_triangle_red(G1tensor(40),RedBasis(2),mass3set(:,1),G0tensor(174),G0tensor(175),G0tensor(176),G0tensor(177),M2L1R1)
  call TI_triangle_red(G1tensor(15),RedBasis(29),mass3set(:,15),G0tensor(178),G0tensor(179),G0tensor(180), &
    G0tensor(181),M2L1R1,[nME,nMW],G0tensor(182),G0tensor(183))
  call TI_triangle_red(G1tensor(52),RedBasis(20),mass3set(:,16),G0tensor(184),G0tensor(185),G0tensor(186), &
    G0tensor(187),M2L1R1,[nMW,nME],G0tensor(188),G0tensor(189))
  call TI_triangle_red(G1tensor(50),RedBasis(4),mass3set(:,17),G0tensor(190),G0tensor(191),G0tensor(192), &
    G0tensor(193),M2L1R1,[nMW,nME],G0tensor(194),G0tensor(195))
  call TI_triangle_red(G1tensor(55),RedBasis(2),mass3set(:,18),G0tensor(196),G0tensor(197),G0tensor(198), &
    G0tensor(199),M2L1R1,[nME],G0tensor(200))
  call TI_triangle_red(G1tensor(27),RedBasis(30),mass3set(:,6),G0tensor(201),G0tensor(202),G0tensor(203), &
    G0tensor(204),M2L1R1,[nMZ],G0tensor(205))
  call TI_triangle_red(G1tensor(72),RedBasis(23),mass3set(:,12),G0tensor(206),G0tensor(207),G0tensor(208), &
    G0tensor(209),M2L1R1,[nMZ],G0tensor(210))
  call TI_triangle_red(G1tensor(67),RedBasis(22),mass3set(:,4),G0tensor(211),G0tensor(212),G0tensor(213), &
    G0tensor(214),M2L1R1,[nMZ],G0tensor(215))
  call TI_triangle_red(G1tensor(65),RedBasis(8),mass3set(:,14),G0tensor(216),G0tensor(217),G0tensor(218), &
    G0tensor(219),M2L1R1,[nMZ],G0tensor(220))
  call TI_triangle_red(G1tensor(70),RedBasis(7),mass3set(:,1),G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),M2L1R1)
  call TI_triangle_red(G1tensor(38),RedBasis(6),mass3set(:,6),G0tensor(225),G0tensor(226),G0tensor(227), &
    G0tensor(228),M2L1R1,[nMZ],G0tensor(229))
  call TI_triangle_red(G1tensor(64),RedBasis(5),mass3set(:,19),G0tensor(230),G0tensor(231),G0tensor(232), &
    G0tensor(233),M2L1R1,[nMZ],G0tensor(234))
  call TI_triangle_red(G1tensor(53),RedBasis(6),mass3set(:,20),G0tensor(235),G0tensor(236),G0tensor(237), &
    G0tensor(238),M2L1R1,[nME,nMW],G0tensor(239),G0tensor(240))
  call TI_triangle_red(G1tensor(68),RedBasis(9),mass3set(:,6),G0tensor(241),G0tensor(242),G0tensor(243), &
    G0tensor(244),M2L1R1,[nMZ],G0tensor(245))
  call TI_triangle_red(G1tensor(73),RedBasis(26),mass3set(:,6),G0tensor(246),G0tensor(247),G0tensor(248), &
    G0tensor(249),M2L1R1,[nMZ],G0tensor(250))
  call TI_triangle_red(G1tensor(84),RedBasis(25),mass3set(:,19),G0tensor(251),G0tensor(252),G0tensor(253), &
    G0tensor(254),M2L1R1,[nMZ],G0tensor(255))
  call TI_triangle_red(G1tensor(75),RedBasis(24),mass3set(:,14),G0tensor(256),G0tensor(257),G0tensor(258), &
    G0tensor(259),M2L1R1,[nMZ],G0tensor(260))
  call TI_triangle_red(G1tensor(77),RedBasis(23),mass3set(:,7),G0tensor(261),G0tensor(262),G0tensor(263), &
    G0tensor(264),M2L1R1,[nMW,nME],G0tensor(265),G0tensor(266))
  call TI_triangle_red(G1tensor(78),RedBasis(26),mass3set(:,20),G0tensor(267),G0tensor(268),G0tensor(269), &
    G0tensor(270),M2L1R1,[nME,nMW],G0tensor(271),G0tensor(272))
  call TI_triangle_red(G1tensor(80),RedBasis(24),mass3set(:,17),G0tensor(273),G0tensor(274),G0tensor(275), &
    G0tensor(276),M2L1R1,[nMW,nME],G0tensor(277),G0tensor(278))
  call TI_triangle_red(G1tensor(83),RedBasis(28),mass3set(:,6),G0tensor(279),G0tensor(280),G0tensor(281), &
    G0tensor(282),M2L1R1,[nMZ],G0tensor(283))
  call TI_triangle_red(G1tensor(85),RedBasis(27),mass3set(:,14),G0tensor(284),G0tensor(285),G0tensor(286), &
    G0tensor(287),M2L1R1,[nMZ],G0tensor(288))
  call ol_merge_tensors(T0sum(25),[G0tensor(1)])
  call ol_merge_tensors(T0sum(26),[G0tensor(21)])
  call ol_merge_tensors(T0sum(27),[G0tensor(46)])
  call ol_merge_tensors(T0sum(28),[G0tensor(71)])
  call ol_merge_tensors(T0sum(29),[G0tensor(91)])
  call ol_merge_tensors(T0sum(30),[G0tensor(111)])
  call ol_merge_tensors(T0sum(31),[G0tensor(60)])
  call ol_merge_tensors(T0sum(32),[G0tensor(115)])
  call ol_merge_tensors(T0sum(33),[G0tensor(95)])
  call ol_merge_tensors(T0sum(34),[G0tensor(117)])
  call ol_merge_tensors(T0sum(35),[G0tensor(149)])
  call ol_merge_tensors(T0sum(36),[G0tensor(154)])
  call ol_merge_tensors(T0sum(37),[G0tensor(159)])
  call ol_merge_tensors(T0sum(38),[G0tensor(164)])
  call ol_merge_tensors(T0sum(39),[G0tensor(169)])
  call ol_merge_tensors(T0sum(40),[G0tensor(174)])
  call ol_merge_tensors(T0sum(41),[G0tensor(3)])
  call ol_merge_tensors(T0sum(42),[G0tensor(178)])
  call ol_merge_tensors(T0sum(43),[G0tensor(5)])
  call ol_merge_tensors(T0sum(44),[G0tensor(184)])
  call ol_merge_tensors(T0sum(45),[G0tensor(190)])
  call ol_merge_tensors(T0sum(46),[G0tensor(196)])
  call ol_merge_tensors(T0sum(47),[G0tensor(201)])
  call ol_merge_tensors(T0sum(48),[G0tensor(206)])
  call ol_merge_tensors(T0sum(49),[G0tensor(211)])
  call ol_merge_tensors(T0sum(50),[G0tensor(216)])
  call ol_merge_tensors(T0sum(51),[G0tensor(221)])
  call ol_merge_tensors(T0sum(52),[G0tensor(225)])
  call ol_merge_tensors(T0sum(53),[G0tensor(230)])
  call ol_merge_tensors(T0sum(54),[G0tensor(30)])
  call ol_merge_tensors(T0sum(55),[G0tensor(235)])
  call ol_merge_tensors(T0sum(56),[G0tensor(13)])
  call ol_merge_tensors(T0sum(57),[G0tensor(55)])
  call ol_merge_tensors(T0sum(58),[G0tensor(241)])
  call ol_merge_tensors(T0sum(59),[G0tensor(246)])
  call ol_merge_tensors(T0sum(60),[G0tensor(251)])
  call ol_merge_tensors(T0sum(61),[G0tensor(256)])
  call ol_merge_tensors(T0sum(62),[G0tensor(261)])
  call ol_merge_tensors(T0sum(63),[G0tensor(267)])
  call ol_merge_tensors(T0sum(64),[G0tensor(62)])
  call ol_merge_tensors(T0sum(65),[G0tensor(273)])
  call ol_merge_tensors(T0sum(66),[G0tensor(279)])
  call ol_merge_tensors(T0sum(67),[G0tensor(284)])
  call ol_merge_tensors(T0sum(68),[G0tensor(28)])
  call ol_merge_tensors(T0sum(69),[G0tensor(33)])
  call ol_merge_tensors(T0sum(70),[G0tensor(114)])
  call ol_merge_tensors(T0sum(71),[G0tensor(53)])
  call ol_merge_tensors(T0sum(72),[G0tensor(119)])
  call ol_merge_tensors(T0sum(73),[G0tensor(73)])
  call ol_merge_tensors(T0sum(74),[G0tensor(78)])
  call ol_merge_tensors(T0sum(75),[G0tensor(87)])
  call ol_merge_tensors(T0sum(76),[G0tensor(98)])
  call ol_merge_tensors(T0sum(77),[G0tensor(108)])
  call ol_merge_tensors(T0sum(78),[G0tensor(123)])
  call ol_merge_tensors(T0sum(79),[G0tensor(128)])
  call ol_merge_tensors(T0sum(80),[G0tensor(133)])
  call ol_merge_tensors(T0sum(81),[G0tensor(138)])
  call ol_merge_tensors(T0sum(82),[G0tensor(144)])
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[20,11],[0,0],2,2,wf4(:,3),wf8(:,14))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,17),heltab2x32(:,:,74))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[20,11],[nMZ,0],2,2,wf4(:,3),wf8(:,14))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngZd,m3h4x8(:,18),heltab2x32(:,:,75))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[20,11],[nMW,0],2,2,wf4(:,3),wf8(:,14))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,19),heltab2x32(:,:,76))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[20,11],[0,0],2,2,wf4(:,3),wf8(:,14))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,20),heltab2x32(:,:,77))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[28,3],[nME,nME],2,2,wf8(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,12),G0H4(5),m3h8x4(:,27),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G0H4(5),28,nME,G1H4(6),n2h4(34))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[28,3],[nMM,nMM],2,2,wf8(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,12),G0H4(2),m3h8x4(:,28),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMM,G1H4(7),n2h4(35))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[28,3],[nML,nML],2,2,wf8(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,12),G0H4(1),m3h8x4(:,29),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G0H4(1),28,nML,G1H4(18),n2h4(36))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[28,3],[0,0],2,2,wf8(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,12),G0H4(7),m3h8x4(:,30),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H4(7),28,0,G1H4(10),n2h4(37))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[28,3],[nMT,nMT],2,2,wf8(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,12),G0H4(4),m3h8x4(:,31),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G0H4(4),28,nMT,G1H4(9),n2h4(38))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[28,3],[0,0],2,2,wf8(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,12),G0H4(3),m3h8x4(:,32),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(11),n2h4(39))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[28,3],[nMB,nMB],2,2,wf8(:,12),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,12),G0H4(6),m3h8x4(:,33),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H4(6),28,nMB,G1H4(3),n2h4(40))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[28,3],[0,0],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,13),G0H4(8),ngZn,m3h8x4(:,34),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H4(8),28,0,G1H4(2),n2h4(41))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[28,3],[nME,nME],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,13),G0H4(5),ngZl,m3h8x4(:,35),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G0H4(5),28,nME,G1H4(13),n2h4(42))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[28,3],[nMM,nMM],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,13),G0H4(2),ngZl,m3h8x4(:,36),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMM,G1H4(5),n2h4(43))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[28,3],[nML,nML],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,13),G0H4(1),ngZl,m3h8x4(:,37),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G0H4(1),28,nML,G1H4(4),n2h4(44))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[28,3],[0,0],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,13),G0H4(7),ngZu,m3h8x4(:,38),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G0H4(7),28,0,G1H4(15),n2h4(45))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[28,3],[nMT,nMT],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,13),G0H4(4),ngZu,m3h8x4(:,39),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G0H4(4),28,nMT,G1H4(8),n2h4(46))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[28,3],[0,0],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,13),G0H4(3),ngZd,m3h8x4(:,40),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(12),n2h4(47))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[28,3],[nMB,nMB],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,13),G0H4(6),ngZd,m3h8x4(:,41),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G0H4(6),28,nMB,G1H4(14),n2h4(48))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[28,3],[nMW,nMW],2,2,wf8(:,12),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,12),28,G1H4(17),m3h8x4(:,42),heltab2x32(:,:,93))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[28,3],[nMH,nMZ],2,2,wf8(:,13),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(16),m3h8x4(:,43),heltab2x32(:,:,94))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(19),m3h8x4(:,44),heltab2x32(:,:,95))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[28,3],[nMW,nMW],2,2,wf8(:,12),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,12),28,G1H4(1),m3h8x4(:,45),heltab2x32(:,:,96))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[28,3],[nMW,nMW],2,2,wf8(:,12),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,12),28,G1H4(20),m3h8x4(:,46),heltab2x32(:,:,97))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(21),m3h8x4(:,47),heltab2x32(:,:,98))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(22),m3h8x4(:,48),heltab2x32(:,:,99))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[28,3],[nMW,nMW],2,2,wf8(:,12),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,12),28,G1H4(23),m3h8x4(:,49),heltab2x32(:,:,100))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(24),m3h8x4(:,50),heltab2x32(:,:,101))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[28,3],[nMW,nMW],2,2,wf8(:,12),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,12),G0H4(8),m3h8x4(:,51),heltab2x32(:,:,102))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[28,3],[nMW,nMW],2,2,wf8(:,12),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,12),G0H4(5),m3h8x4(:,52),heltab2x32(:,:,103))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[28,3],[nMH,nMZ],2,2,wf8(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,13),G0H4(2),m3h8x4(:,53),heltab2x32(:,:,104))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,13),G0H4(1),m3h8x4(:,54),heltab2x32(:,:,105))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,13),G0H4(7),m3h8x4(:,55),heltab2x32(:,:,106))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[24,7],[0,0],2,2,wf4(:,5),wf8(:,17))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(5),m3h4x8(:,21),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H8(5),24,0,G1H8(2),n2h8(12))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[24,7],[0,nMZ],2,2,wf4(:,5),wf8(:,17))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(4),ngZd,m3h4x8(:,22),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G0H8(4),24,0,G1H8(4),n2h8(13))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[24,7],[0,nMW],2,2,wf4(:,5),wf8(:,17))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(5),m3h4x8(:,23),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G0H8(5),24,0,G1H8(9),n2h8(14))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[24,7],[0,0],2,2,wf4(:,5),wf8(:,17))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(4),m3h4x8(:,24),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G0H8(4),24,0,G1H8(7),n2h8(15))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[28,3],[nME,nME],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,15),G0H4(4),m3h8x4(:,56),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G0H4(4),28,nME,G1H4(25),n2h4(49))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[28,3],[nMM,nMM],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,15),G0H4(3),m3h8x4(:,57),heltab2x32(:,:,112))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMM,G1H4(26),n2h4(50))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[28,3],[nML,nML],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,15),G0H4(6),m3h8x4(:,58),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G0H4(6),28,nML,G1H4(27),n2h4(51))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[28,3],[0,0],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,15),G0H4(4),m3h8x4(:,59),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H4(4),28,0,G1H4(28),n2h4(52))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[28,3],[nMT,nMT],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,15),G0H4(3),m3h8x4(:,60),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMT,G1H4(29),n2h4(53))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[28,3],[0,0],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,15),G0H4(6),m3h8x4(:,61),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G0H4(6),28,0,G1H4(30),n2h4(54))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[28,3],[nMB,nMB],2,2,wf8(:,15),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,15),G0H4(4),m3h8x4(:,62),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G0H4(4),28,nMB,G1H4(31),n2h4(55))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[28,3],[0,0],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,16),G0H4(3),ngZn,m3h8x4(:,63),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(32),n2h4(56))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[28,3],[nME,nME],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,16),G0H4(6),ngZl,m3h8x4(:,64),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G0H4(6),28,nME,G1H4(33),n2h4(57))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[28,3],[nMM,nMM],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,16),G0H4(4),ngZl,m3h8x4(:,65),heltab2x32(:,:,120))
  call Hloop_Q_A(ntryL,G0H4(4),28,nMM,G1H4(34),n2h4(58))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[28,3],[nML,nML],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,16),G0H4(3),ngZl,m3h8x4(:,66),heltab2x32(:,:,121))
  call Hloop_Q_A(ntryL,G0H4(3),28,nML,G1H4(35),n2h4(59))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[28,3],[0,0],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,16),G0H4(6),ngZu,m3h8x4(:,67),heltab2x32(:,:,122))
  call Hloop_Q_A(ntryL,G0H4(6),28,0,G1H4(36),n2h4(60))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[28,3],[nMT,nMT],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,16),G0H4(4),ngZu,m3h8x4(:,68),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G0H4(4),28,nMT,G1H4(37),n2h4(61))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[28,3],[0,0],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,16),G0H4(3),ngZd,m3h8x4(:,69),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(38),n2h4(62))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[28,3],[nMB,nMB],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,16),G0H4(6),ngZd,m3h8x4(:,70),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G0H4(6),28,nMB,G1H4(39),n2h4(63))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(40),m3h8x4(:,71),heltab2x32(:,:,126))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[28,3],[nMH,nMZ],2,2,wf8(:,16),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(41),m3h8x4(:,72),heltab2x32(:,:,127))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(42),m3h8x4(:,73),heltab2x32(:,:,128))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(43),m3h8x4(:,74),heltab2x32(:,:,129))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(44),m3h8x4(:,75),heltab2x32(:,:,130))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(45),m3h8x4(:,76),heltab2x32(:,:,131))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(46),m3h8x4(:,77),heltab2x32(:,:,132))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,15),28,G1H4(47),m3h8x4(:,78),heltab2x32(:,:,133))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(48),m3h8x4(:,79),heltab2x32(:,:,134))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,15),G0H4(4),m3h8x4(:,80),heltab2x32(:,:,135))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[28,3],[nMW,nMW],2,2,wf8(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,15),G0H4(3),m3h8x4(:,81),heltab2x32(:,:,136))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[28,3],[nMH,nMZ],2,2,wf8(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,16),G0H4(6),m3h8x4(:,82),heltab2x32(:,:,137))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,16),G0H4(9),m3h8x4(:,83),heltab2x32(:,:,138))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,16),G0H4(10),m3h8x4(:,84),heltab2x32(:,:,139))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(3),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(25),G1H4(13),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(26),G1H4(5),G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(27),G1H4(4),G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(28),G1H4(15),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(29),G1H4(8),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(30),G1H4(12),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(31),G1H4(14),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(40),G1H4(19),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(45),G1H4(44),G1H4(43),G1H4(22),G1H4(21) &
    ,G1H4(20),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(47),G1H4(24),G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(10),[G0H4(9),G0H4(3),G0H4(4),G0H4(7),G0H4(1),G0H4(5) &
    ,G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(6),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(2)])
  call Hloop_VA_Q(ntryL,G0H8(3),wf8(:,14),G0H1(1),m3h8x1(:,5),heltab2x8(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(1),n2h1(68))
  call Hloop_ZA_Q(ntryL,G0H8(1),wf8(:,14),G0H1(1),ngZd,m3h8x1(:,6),heltab2x8(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(8),n2h1(69))
  call Hloop_WA_Q(ntryL,G0H8(2),wf8(:,14),G0H1(1),m3h8x1(:,7),heltab2x8(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(4),n2h1(70))
  call Hloop_QZ_A(ntryL,G1H4(33),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,8),heltab2x4(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(34),n2h1(71))
  call Hloop_QZ_A(ntryL,G1H4(34),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,9),heltab2x4(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(18),n2h1(72))
  call Hloop_QZ_A(ntryL,G1H4(35),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,10),heltab2x4(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(21),n2h1(73))
  call Hloop_QZ_A(ntryL,G1H4(36),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,11),heltab2x4(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(74))
  call Hloop_QZ_A(ntryL,G1H4(37),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,12),heltab2x4(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(39),n2h1(75))
  call Hloop_QZ_A(ntryL,G1H4(38),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,13),heltab2x4(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(76))
  call Hloop_QZ_A(ntryL,G1H4(39),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,14),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(33),n2h1(77))
  call Hloop_QZ_A(ntryL,G1H4(32),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,15),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(30),n2h1(78))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(42),28,wf4(:,1),3,G2tensor(27),m3h4x1(:,16),heltab2x4(:,:,38))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(41),28,wf4(:,1),3,G2tensor(24),m3h4x1(:,17),heltab2x4(:,:,39))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(46),28,wf4(:,1),3,G2tensor(26),m3h4x1(:,18),heltab2x4(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(48),28,wf4(:,1),3,G2tensor(29),m3h4x1(:,19),heltab2x4(:,:,41))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(10),wf4(:,1),G0tensor(1),m3h4x1(:,20),heltab2x4(:,:,42))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(6),wf4(:,1),G0tensor(21),m3h4x1(:,21),heltab2x4(:,:,43))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(7),wf8(:,17),G1tensor(11),m3h8x1(:,8),heltab2x8(:,:,30))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(4),wf8(:,17),G1tensor(21),ngZd,m3h8x1(:,9),heltab2x8(:,:,31))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(9),wf8(:,17),G1tensor(26),m3h8x1(:,10),heltab2x8(:,:,32))
  call ol_merge_tensors(G0tensor(99),[G0tensor(58),G0tensor(44),G0tensor(70),G0tensor(105),G0tensor(6)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(48),G0tensor(86),G0tensor(11)])
  call ol_merge_tensors(G0tensor(224),[G0tensor(199),G0tensor(177),G0tensor(93),G0tensor(75),G0tensor(49),G0tensor(34) &
    ,G0tensor(22),G0tensor(12),G0tensor(42),G0tensor(106),G0tensor(61),G0tensor(16)])
  call ol_merge_tensors(G0tensor(179),[G0tensor(124),G0tensor(2),G0tensor(51),G0tensor(26)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(26),G2tensor(27),G0tensor(1),G0tensor(264),G0tensor(23),G0tensor(52),G0tensor(40) &
    ,G0tensor(31)])
  call ol_merge_tensors(G1tensor(26),[G0tensor(187),G0tensor(19),G0tensor(82),G0tensor(36)])
  call ol_merge_tensors(G0tensor(277),[G0tensor(272),G0tensor(265),G0tensor(240),G0tensor(194),G0tensor(188),G0tensor(183) &
    ,G0tensor(143),G0tensor(127),G0tensor(94),G0tensor(85),G0tensor(65),G0tensor(72),G0tensor(18),G0tensor(9),G0tensor(32) &
    ,G0tensor(120),G0tensor(66),G0tensor(41)])
  call ol_merge_tensors(G1tensor(4),[G0tensor(193),G0tensor(50),G0tensor(56)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(36),G2tensor(23),G0tensor(147),G0tensor(29),G0tensor(7),G0tensor(97),G0tensor(110) &
    ,G0tensor(20),G0tensor(116),G0tensor(96),G0tensor(76)])
  call ol_merge_tensors(G0tensor(103),[G0tensor(69),G0tensor(43),G0tensor(81)])
  call ol_merge_tensors(G0tensor(126),[G0tensor(121),G0tensor(104),G0tensor(83),G0tensor(68),G0tensor(39),G0tensor(101)])
  call ol_merge_tensors(G0tensor(59),[G0tensor(90)])
  call ol_merge_tensors(G0tensor(84),[G0tensor(57)])
  call ol_merge_tensors(G0tensor(288),[G0tensor(283),G0tensor(260),G0tensor(255),G0tensor(250),G0tensor(245),G0tensor(234) &
    ,G0tensor(229),G0tensor(220),G0tensor(215),G0tensor(210),G0tensor(205),G0tensor(173),G0tensor(168),G0tensor(163),G0tensor(158) &
    ,G0tensor(153),G0tensor(148),G0tensor(122),G0tensor(77),G0tensor(63),G0tensor(47),G0tensor(25),G0tensor(112),G0tensor(15)])
  call ol_merge_tensors(G0tensor(79),[G0tensor(92)])
  call ol_merge_tensors(G0tensor(109),[G0tensor(88)])
  call ol_merge_tensors(G1tensor(11),[G0tensor(64),G0tensor(38),G0tensor(100)])
  call ol_merge_tensors(G0tensor(202),[G0tensor(165),G0tensor(150),G0tensor(113),G0tensor(37),G0tensor(102)])
  call ol_merge_tensors(G1tensor(21),[G0tensor(214),G0tensor(167),G0tensor(162),G0tensor(10),G0tensor(107)])
  call ol_merge_tensors(G1tensor(8),[G0tensor(233),G0tensor(219),G0tensor(172),G0tensor(4)])
  call ol_merge_tensors(G0tensor(191),[G0tensor(180),G0tensor(35)])
  call ol_merge_tensors(G0tensor(236),[G0tensor(186),G0tensor(8)])
  call ol_merge_tensors(G0tensor(278),[G0tensor(271),G0tensor(266),G0tensor(239),G0tensor(200),G0tensor(195),G0tensor(189) &
    ,G0tensor(182),G0tensor(142),G0tensor(45)])
  call ol_merge_tensors(G0tensor(243),[G0tensor(232),G0tensor(227),G0tensor(118),G0tensor(17)])
  call ol_merge_tensors(G0tensor(237),[G0tensor(125),G0tensor(27),G0tensor(14)])
  call ol_merge_tensors(G0tensor(269),[G0tensor(89),G0tensor(80),G0tensor(67)])
  call ol_merge_tensors(G0tensor(276),[G0tensor(24)])
  call ol_merge_tensors(G0tensor(281),[G0tensor(253),G0tensor(248),G0tensor(74),G0tensor(54)])
  call ol_merge_tensors(G2tensor(39),[G0tensor(129)])
  call ol_merge_tensors(G2tensor(33),[G0tensor(134)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(263),G0tensor(139)])
  call ol_merge_tensors(G0tensor(274),[G0tensor(262),G0tensor(140)])
  call ol_merge_tensors(G2tensor(34),[G0tensor(141)])
  call ol_merge_tensors(G0tensor(247),[G0tensor(242),G0tensor(213),G0tensor(208),G0tensor(145)])
  call ol_merge_tensors(G0tensor(257),[G0tensor(217),G0tensor(207),G0tensor(203),G0tensor(146)])
  call ol_merge_tensors(G0tensor(285),[G0tensor(170),G0tensor(155),G0tensor(151)])
  call ol_merge_tensors(G0tensor(258),[G0tensor(249),G0tensor(175),G0tensor(160),G0tensor(152)])
  call ol_merge_tensors(G0tensor(280),[G0tensor(226),G0tensor(161),G0tensor(156)])
  call ol_merge_tensors(G0tensor(252),[G0tensor(231),G0tensor(209),G0tensor(166),G0tensor(157)])
  call ol_merge_tensors(G0tensor(228),[G0tensor(176),G0tensor(171)])
  call ol_merge_tensors(G0tensor(197),[G0tensor(185),G0tensor(181)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(198),G0tensor(192)])
  call ol_merge_tensors(G0tensor(286),[G0tensor(282),G0tensor(222),G0tensor(212),G0tensor(204)])
  call ol_merge_tensors(G0tensor(244),[G0tensor(223),G0tensor(218)])
  call ol_merge_tensors(G0tensor(287),[G0tensor(259),G0tensor(254)])
  call ol_merge_tensors(G0tensor(275),[G0tensor(270)])
  call ol_merge_tensors(G2tensor(24),[G0tensor(21)])
call TI_bubble_red(G2tensor(29),28,mass2set(:,1),G0tensor(46),M2L1R1,G0tensor(71))
call TI_bubble_red(G2tensor(30),28,mass2set(:,2),G0tensor(91),M2L1R1)
call TI_bubble_red(G2tensor(39),28,mass2set(:,3),G0tensor(111),M2L1R1,G0tensor(60))
call TI_bubble_red(G2tensor(33),28,mass2set(:,4),G0tensor(115),M2L1R1,G0tensor(95))
call TI_bubble_red(G2tensor(34),28,mass2set(:,5),G0tensor(117),M2L1R1,G0tensor(149))
call TI_bubble_red(G2tensor(18),28,mass2set(:,6),G0tensor(154),M2L1R1,G0tensor(159))
call TI_bubble_red(G2tensor(21),28,mass2set(:,7),G0tensor(164),M2L1R1,G0tensor(169))
call TI_bubble_red(G2tensor(24),28,mass2set(:,8),G0tensor(174),M2L1R1,G0tensor(3),G0tensor(178))
  call ol_merge_tensors(G0tensor(277),[G0tensor(71)])
  call ol_merge_tensors(G0tensor(3),[G0tensor(288)])
  call ol_merge_tensors(G0tensor(149),[G0tensor(278)])
  call ol_merge_tensors(G0tensor(132),[G0tensor(60)])
  call ol_merge_tensors(G0tensor(137),[G0tensor(95)])
call TI_bubble_red(G1tensor(1),20,mass2set(:,2),G0tensor(5),M2L1R1)
call TI_bubble_red(G1tensor(26),24,mass2set(:,9),G0tensor(184),M2L1R1,G0tensor(190))
call TI_bubble_red(G1tensor(4),20,mass2set(:,10),G0tensor(196),M2L1R1,G0tensor(201))
call TI_bubble_red(G1tensor(11),24,mass2set(:,2),G0tensor(206),M2L1R1)
call TI_bubble_red(G1tensor(21),24,mass2set(:,11),G0tensor(211),M2L1R1,G0tensor(216))
call TI_bubble_red(G1tensor(8),20,mass2set(:,12),G0tensor(221),M2L1R1,G0tensor(225))
  call ol_merge_tensors(G0tensor(201),[G0tensor(190),G0tensor(277)])
  call ol_merge_tensors(G0tensor(225),[G0tensor(216),G0tensor(3)])
  call ol_merge_tensors(T0sum(83),[G0tensor(99)])
  call ol_merge_tensors(T0sum(84),[G0tensor(5)])
  call ol_merge_tensors(T0sum(85),[G0tensor(224)])
  call ol_merge_tensors(T0sum(86),[G0tensor(179)])
  call ol_merge_tensors(T0sum(87),[G0tensor(46)])
  call ol_merge_tensors(T0sum(88),[G0tensor(201)])
  call ol_merge_tensors(T0sum(89),[G0tensor(184)])
  call ol_merge_tensors(T0sum(90),[G0tensor(196)])
  call ol_merge_tensors(T0sum(91),[G0tensor(91)])
  call ol_merge_tensors(T0sum(92),[G0tensor(103)])
  call ol_merge_tensors(T0sum(93),[G0tensor(126)])
  call ol_merge_tensors(T0sum(94),[G0tensor(59)])
  call ol_merge_tensors(T0sum(95),[G0tensor(84)])
  call ol_merge_tensors(T0sum(96),[G0tensor(225)])
  call ol_merge_tensors(T0sum(97),[G0tensor(79)])
  call ol_merge_tensors(T0sum(98),[G0tensor(109)])
  call ol_merge_tensors(T0sum(99),[G0tensor(206)])
  call ol_merge_tensors(T0sum(100),[G0tensor(202)])
  call ol_merge_tensors(T0sum(101),[G0tensor(211)])
  call ol_merge_tensors(T0sum(102),[G0tensor(221)])
  call ol_merge_tensors(T0sum(103),[G0tensor(191)])
  call ol_merge_tensors(T0sum(104),[G0tensor(236)])
  call ol_merge_tensors(T0sum(105),[G0tensor(149)])
  call ol_merge_tensors(T0sum(106),[G0tensor(243)])
  call ol_merge_tensors(T0sum(107),[G0tensor(237)])
  call ol_merge_tensors(T0sum(108),[G0tensor(269)])
  call ol_merge_tensors(T0sum(109),[G0tensor(276)])
  call ol_merge_tensors(T0sum(110),[G0tensor(281)])
  call ol_merge_tensors(T0sum(111),[G0tensor(111)])
  call ol_merge_tensors(T0sum(112),[G0tensor(132)])
  call ol_merge_tensors(T0sum(113),[G0tensor(130)])
  call ol_merge_tensors(T0sum(114),[G0tensor(131)])
  call ol_merge_tensors(T0sum(115),[G0tensor(115)])
  call ol_merge_tensors(T0sum(116),[G0tensor(137)])
  call ol_merge_tensors(T0sum(117),[G0tensor(135)])
  call ol_merge_tensors(T0sum(118),[G0tensor(136)])
  call ol_merge_tensors(T0sum(119),[G0tensor(268)])
  call ol_merge_tensors(T0sum(120),[G0tensor(274)])
  call ol_merge_tensors(T0sum(121),[G0tensor(117)])
  call ol_merge_tensors(T0sum(122),[G0tensor(247)])
  call ol_merge_tensors(T0sum(123),[G0tensor(257)])
  call ol_merge_tensors(T0sum(124),[G0tensor(285)])
  call ol_merge_tensors(T0sum(125),[G0tensor(258)])
  call ol_merge_tensors(T0sum(126),[G0tensor(280)])
  call ol_merge_tensors(T0sum(127),[G0tensor(252)])
  call ol_merge_tensors(T0sum(128),[G0tensor(228)])
  call ol_merge_tensors(T0sum(129),[G0tensor(197)])
  call ol_merge_tensors(T0sum(130),[G0tensor(238)])
  call ol_merge_tensors(T0sum(131),[G0tensor(286)])
  call ol_merge_tensors(T0sum(132),[G0tensor(244)])
  call ol_merge_tensors(T0sum(133),[G0tensor(287)])
  call ol_merge_tensors(T0sum(134),[G0tensor(275)])
  call ol_merge_tensors(T0sum(135),[G0tensor(154)])
  call ol_merge_tensors(T0sum(136),[G0tensor(159)])
  call ol_merge_tensors(T0sum(137),[G0tensor(164)])
  call ol_merge_tensors(T0sum(138),[G0tensor(169)])
  call ol_merge_tensors(T0sum(139),[G0tensor(174)])
  call ol_merge_tensors(T0sum(140),[G0tensor(178)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 20, 21, 23 ],masses2_54,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 23 ],masses2_45,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 20, 23 ],masses2_52,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 20, 21 ],masses2_50,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_54,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 20, 21, 23 ],masses2_53,RedSet_4(1),ScalarBoxes(6))
  call compute_scalar_box([ 16, 21, 23 ],masses2_46,RedSet_4(2),ScalarBoxes(7))
  call compute_scalar_box([ 16, 20, 23 ],masses2_49,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 16, 20, 21 ],masses2_47,RedSet_4(4),ScalarBoxes(9))
  call compute_scalar_box([ 4, 5, 7 ],masses2_53,RedSet_4(5),ScalarBoxes(10))
  call compute_scalar_box([ 20, 22, 23 ],masses2_54,RedSet_4(6),ScalarBoxes(11))
  call compute_scalar_box([ 16, 22, 23 ],masses2_45,RedSet_4(7),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 22 ],masses2_50,RedSet_4(8),ScalarBoxes(13))
  call compute_scalar_box([ 4, 6, 7 ],masses2_54,RedSet_4(9),ScalarBoxes(14))
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppllj_ew_nenexddxg_1_/**/REALKIND
