
! **********************************************************************
module ol_tables_storage_ppllj_ew_llxbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(16,320)
integer(intkind2), save :: heltab2x2(2,2,54)
integer(intkind2), save :: heltab2x4(2,4,92)
integer(intkind2), save :: heltab2x8(2,8,87)
integer(intkind2), save :: heltab2x16(2,16,320)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(320)
integer(intkind2), save :: m3h2x1(3,54)
integer(intkind2), save :: m3h4x1(3,47)
integer(intkind2), save :: m3h2x2(3,45)
integer(intkind2), save :: m3h4x2(3,51)
integer(intkind2), save :: m3h2x4(3,36)
integer(intkind2), save :: m3h4x4(3,229)
integer(intkind2), save :: m3h2x8(3,91)

integer(intkind2), save :: n2h1(64)
integer(intkind2), save :: n2h2(37)
integer(intkind2), save :: n2h4(143)
integer(intkind2), save :: n2h8(28)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppllj_ew_llxbbx_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppllj_ew_llxbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G0H2(14)
  type(hol), save :: G1H2(26)
  type(hol), save :: G2H2(34)
  type(hol), save :: G0H4(46)
  type(hol), save :: G1H4(138)
  type(hol), save :: G0H8(36)
  type(hol), save :: G1H8(28)
  type(hol), save :: G0H16(1)
  type(hcl), save, dimension(313) :: G0tensor
  type(hcl), save, dimension(95) :: G1tensor
  type(hcl), save, dimension(35) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(7)
type (redset4),    save :: RedSet_4(2)
integer, save :: mass2set(0:1,9)
integer, save :: mass3set(0:2,36)
integer, save :: mass4set(0:3,10)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(3)
  integer, save :: momenta_10(3)
  integer, save :: momenta_11(3)
  integer, save :: momenta_12(3)
  integer, save :: momenta_13(3)
  integer, save :: momenta_14(3)
  integer, save :: momenta_15(3)
  integer, save :: momenta_16(4)
  integer, save :: momenta_17(4)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(2)
  integer, save :: masses2_9(2)
  integer, save :: masses2_10(2)
  integer, save :: masses2_11(2)
  integer, save :: masses2_12(2)
  integer, save :: masses2_13(2)
  integer, save :: masses2_14(2)
  integer, save :: masses2_15(2)
  integer, save :: masses2_16(2)
  integer, save :: masses2_17(2)
  integer, save :: masses2_18(2)
  integer, save :: masses2_19(2)
  integer, save :: masses2_20(2)
  integer, save :: masses2_21(2)
  integer, save :: masses2_22(2)
  integer, save :: masses2_23(2)
  integer, save :: masses2_24(2)
  integer, save :: masses2_25(2)
  integer, save :: masses2_26(2)
  integer, save :: masses2_27(2)
  integer, save :: masses2_28(2)
  integer, save :: masses2_29(2)
  integer, save :: masses2_30(2)
  integer, save :: masses2_31(2)
  integer, save :: masses2_32(2)
  integer, save :: masses2_33(2)
  integer, save :: masses2_34(2)
  integer, save :: masses2_35(2)
  integer, save :: masses2_36(3)
  integer, save :: masses2_37(3)
  integer, save :: masses2_38(3)
  integer, save :: masses2_39(3)
  integer, save :: masses2_40(3)
  integer, save :: masses2_41(3)
  integer, save :: masses2_42(3)
  integer, save :: masses2_43(3)
  integer, save :: masses2_44(3)
  integer, save :: masses2_45(3)
  integer, save :: masses2_46(3)
  integer, save :: masses2_47(3)
  integer, save :: masses2_48(3)
  integer, save :: masses2_49(3)
  integer, save :: masses2_50(3)
  integer, save :: masses2_51(3)
  integer, save :: masses2_52(3)
  integer, save :: masses2_53(3)
  integer, save :: masses2_54(3)
  integer, save :: masses2_55(3)
  integer, save :: masses2_56(3)
  integer, save :: masses2_57(3)
  integer, save :: masses2_58(3)
  integer, save :: masses2_59(3)
  integer, save :: masses2_60(3)
  integer, save :: masses2_61(3)
  integer, save :: masses2_62(3)
  integer, save :: masses2_63(3)
  integer, save :: masses2_64(3)
  integer, save :: masses2_65(3)
  integer, save :: masses2_66(3)
  integer, save :: masses2_67(3)
  integer, save :: masses2_68(3)
  integer, save :: masses2_69(3)
  integer, save :: masses2_70(3)
  integer, save :: masses2_71(3)
  integer, save :: masses2_72(4)
  integer, save :: masses2_73(4)
  integer, save :: masses2_74(4)
  integer, save :: masses2_75(4)
  integer, save :: masses2_76(4)
  integer, save :: masses2_77(4)
  integer, save :: masses2_78(4)
  integer, save :: masses2_79(4)
  integer, save :: masses2_80(4)
  integer, save :: masses2_81(4)



  type(hcl), save, dimension(128) :: T0sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllj_ew_llxbbx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,1,4,2,G0H2,14)
  call hol_allocation(4,5,4,2,G1H2,26)
  call hol_allocation(4,15,4,2,G2H2,34)
  call hol_allocation(4,1,4,4,G0H4,46)
  call hol_allocation(4,5,4,4,G1H4,138)
  call hol_allocation(4,1,4,8,G0H8,36)
  call hol_allocation(4,5,4,8,G1H8,28)
  call hol_allocation(4,1,4,16,G0H16,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllj_ew_llxbbx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,1,4,min(nhel,2),G0H2,14)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,26)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,34)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,46)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,138)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,36)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,28)
  call hol_allocation(4,1,4,min(nhel,16),G0H16,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G0H2,14,dmode)
  call hol_deallocation(G1H2,26,dmode)
  call hol_deallocation(G2H2,34,dmode)
  call hol_deallocation(G0H4,46,dmode)
  call hol_deallocation(G1H4,138,dmode)
  call hol_deallocation(G0H8,36,dmode)
  call hol_deallocation(G1H8,28,dmode)
  call hol_deallocation(G0H16,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 313)
call hcl_allocation(5,G1tensor, 95)
call hcl_allocation(15,G2tensor, 35)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 313,dmode)
call hcl_deallocation(G1tensor, 95,dmode)
call hcl_deallocation(G2tensor, 35,dmode)

    call hcl_deallocation(T0sum,128,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,128)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppllj_ew_llxbbx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 4
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppllj_ew_llxbbx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 0
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,128
    call init_hcl(T0sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T0sum(1)%cmp, 4)
  call scale_one_tsum(T0sum(2)%cmp, 4)
  call scale_one_tsum(T0sum(3)%cmp, 4)
  call scale_one_tsum(T0sum(4)%cmp, 4)
  call scale_one_tsum(T0sum(5)%cmp, 4)
  call scale_one_tsum(T0sum(6)%cmp, 4)
  call scale_one_tsum(T0sum(7)%cmp, 4)
  call scale_one_tsum(T0sum(8)%cmp, 4)
  call scale_one_tsum(T0sum(9)%cmp, 4)
  call scale_one_tsum(T0sum(10)%cmp, 4)
  call scale_one_tsum(T0sum(11)%cmp, 4)
  call scale_one_tsum(T0sum(12)%cmp, 4)
  call scale_one_tsum(T0sum(13)%cmp, 4)
  call scale_one_tsum(T0sum(14)%cmp, 4)
  call scale_one_tsum(T0sum(15)%cmp, 4)
  call scale_one_tsum(T0sum(16)%cmp, 4)
  call scale_one_tsum(T0sum(17)%cmp, 4)
  call scale_one_tsum(T0sum(18)%cmp, 4)
  call scale_one_tsum(T0sum(19)%cmp, 4)
  call scale_one_tsum(T0sum(20)%cmp, 2)
  call scale_one_tsum(T0sum(21)%cmp, 2)
  call scale_one_tsum(T0sum(22)%cmp, 2)
  call scale_one_tsum(T0sum(23)%cmp, 2)
  call scale_one_tsum(T0sum(24)%cmp, 2)
  call scale_one_tsum(T0sum(25)%cmp, 2)
  call scale_one_tsum(T0sum(26)%cmp, 2)
  call scale_one_tsum(T0sum(27)%cmp, 2)
  call scale_one_tsum(T0sum(28)%cmp, 2)
  call scale_one_tsum(T0sum(29)%cmp, 2)
  call scale_one_tsum(T0sum(30)%cmp, 2)
  call scale_one_tsum(T0sum(31)%cmp, 2)
  call scale_one_tsum(T0sum(32)%cmp, 2)
  call scale_one_tsum(T0sum(33)%cmp, 2)
  call scale_one_tsum(T0sum(34)%cmp, 2)
  call scale_one_tsum(T0sum(35)%cmp, 2)
  call scale_one_tsum(T0sum(36)%cmp, 2)
  call scale_one_tsum(T0sum(37)%cmp, 2)
  call scale_one_tsum(T0sum(38)%cmp, 2)
  call scale_one_tsum(T0sum(39)%cmp, 2)
  call scale_one_tsum(T0sum(40)%cmp, 2)
  call scale_one_tsum(T0sum(41)%cmp, 2)
  call scale_one_tsum(T0sum(42)%cmp, 2)
  call scale_one_tsum(T0sum(43)%cmp, 2)
  call scale_one_tsum(T0sum(44)%cmp, 2)
  call scale_one_tsum(T0sum(45)%cmp, 2)
  call scale_one_tsum(T0sum(46)%cmp, 2)
  call scale_one_tsum(T0sum(47)%cmp, 2)
  call scale_one_tsum(T0sum(48)%cmp, 2)
  call scale_one_tsum(T0sum(49)%cmp, 2)
  call scale_one_tsum(T0sum(50)%cmp, 2)
  call scale_one_tsum(T0sum(51)%cmp, 2)
  call scale_one_tsum(T0sum(52)%cmp, 2)
  call scale_one_tsum(T0sum(53)%cmp, 2)
  call scale_one_tsum(T0sum(54)%cmp, 2)
  call scale_one_tsum(T0sum(55)%cmp, 2)
  call scale_one_tsum(T0sum(56)%cmp, 2)
  call scale_one_tsum(T0sum(57)%cmp, 2)
  call scale_one_tsum(T0sum(58)%cmp, 2)
  call scale_one_tsum(T0sum(59)%cmp, 2)
  call scale_one_tsum(T0sum(60)%cmp, 2)
  call scale_one_tsum(T0sum(61)%cmp, 2)
  call scale_one_tsum(T0sum(62)%cmp, 2)
  call scale_one_tsum(T0sum(63)%cmp, 2)
  call scale_one_tsum(T0sum(64)%cmp, 2)
  call scale_one_tsum(T0sum(65)%cmp, 2)
  call scale_one_tsum(T0sum(66)%cmp, 2)
  call scale_one_tsum(T0sum(67)%cmp, 2)
  call scale_one_tsum(T0sum(68)%cmp, 2)
  call scale_one_tsum(T0sum(69)%cmp, 2)
  call scale_one_tsum(T0sum(70)%cmp, 2)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, 0)
  call scale_one_tsum(T0sum(108)%cmp, 0)
  call scale_one_tsum(T0sum(109)%cmp, 0)
  call scale_one_tsum(T0sum(110)%cmp, 0)
  call scale_one_tsum(T0sum(111)%cmp, 0)
  call scale_one_tsum(T0sum(112)%cmp, 0)
  call scale_one_tsum(T0sum(113)%cmp, 0)
  call scale_one_tsum(T0sum(114)%cmp, 0)
  call scale_one_tsum(T0sum(115)%cmp, 0)
  call scale_one_tsum(T0sum(116)%cmp, 0)
  call scale_one_tsum(T0sum(117)%cmp, 0)
  call scale_one_tsum(T0sum(118)%cmp, 0)
  call scale_one_tsum(T0sum(119)%cmp, 0)
  call scale_one_tsum(T0sum(120)%cmp, 0)
  call scale_one_tsum(T0sum(121)%cmp, 0)
  call scale_one_tsum(T0sum(122)%cmp, 0)
  call scale_one_tsum(T0sum(123)%cmp, 0)
  call scale_one_tsum(T0sum(124)%cmp, 0)
  call scale_one_tsum(T0sum(125)%cmp, 0)
  call scale_one_tsum(T0sum(126)%cmp, 0)
  call scale_one_tsum(T0sum(127)%cmp, 0)
  call scale_one_tsum(T0sum(128)%cmp, 0)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 8, 7 ]
  momenta_3 = [ 9, 6 ]
  momenta_4 = [ 10, 5 ]
  momenta_5 = [ 11, 4 ]
  momenta_6 = [ 12, 3 ]
  momenta_7 = [ 13, 2 ]
  momenta_8 = [ 14, 1 ]
  momenta_9 = [ 8, 1, 6 ]
  momenta_10 = [ 8, 2, 5 ]
  momenta_11 = [ 8, 3, 4 ]
  momenta_12 = [ 9, 2, 4 ]
  momenta_13 = [ 10, 1, 4 ]
  momenta_14 = [ 12, 1, 2 ]
  momenta_15 = [ 12, 2, 1 ]
  momenta_16 = [ 8, 1, 2, 4 ]
  momenta_17 = [ 8, 2, 1, 4 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nME, 0 ]
  masses2_4 = [ nMH, 0 ]
  masses2_5 = [ nML, 0 ]
  masses2_6 = [ nMM, 0 ]
  masses2_7 = [ nMT, 0 ]
  masses2_8 = [ nMW, 0 ]
  masses2_9 = [ nMZ, 0 ]
  masses2_10 = [ 0, nMB ]
  masses2_11 = [ nMB, nMB ]
  masses2_12 = [ nMH, nMB ]
  masses2_13 = [ nMZ, nMB ]
  masses2_14 = [ nME, nME ]
  masses2_15 = [ 0, nMH ]
  masses2_16 = [ nMB, nMH ]
  masses2_17 = [ nMH, nMH ]
  masses2_18 = [ nML, nMH ]
  masses2_19 = [ nMZ, nMH ]
  masses2_20 = [ 0, nML ]
  masses2_21 = [ nMB, nML ]
  masses2_22 = [ nMH, nML ]
  masses2_23 = [ nML, nML ]
  masses2_24 = [ nMZ, nML ]
  masses2_25 = [ nMM, nMM ]
  masses2_26 = [ nMT, nMT ]
  masses2_27 = [ nMW, nMT ]
  masses2_28 = [ 0, nMW ]
  masses2_29 = [ nMT, nMW ]
  masses2_30 = [ nMW, nMW ]
  masses2_31 = [ 0, nMZ ]
  masses2_32 = [ nMB, nMZ ]
  masses2_33 = [ nMH, nMZ ]
  masses2_34 = [ nML, nMZ ]
  masses2_35 = [ nMZ, nMZ ]
  masses2_36 = [ nMB, 0, 0 ]
  masses2_37 = [ nMB, 0, nMH ]
  masses2_38 = [ 0, 0, nML ]
  masses2_39 = [ nMB, 0, nML ]
  masses2_40 = [ nMH, 0, nML ]
  masses2_41 = [ nMZ, 0, nML ]
  masses2_42 = [ 0, 0, nMW ]
  masses2_43 = [ nMT, 0, nMW ]
  masses2_44 = [ nMB, 0, nMZ ]
  masses2_45 = [ 0, nMB, nMB ]
  masses2_46 = [ nMH, nMB, nMB ]
  masses2_47 = [ nMZ, nMB, nMB ]
  masses2_48 = [ nMB, nMH, 0 ]
  masses2_49 = [ nMB, nMH, nMH ]
  masses2_50 = [ 0, nMH, nML ]
  masses2_51 = [ nMB, nMH, nML ]
  masses2_52 = [ nMH, nMH, nML ]
  masses2_53 = [ nMZ, nMH, nML ]
  masses2_54 = [ nMB, nMH, nMZ ]
  masses2_55 = [ nMB, nML, 0 ]
  masses2_56 = [ nML, nML, 0 ]
  masses2_57 = [ nMB, nML, nMH ]
  masses2_58 = [ nML, nML, nMH ]
  masses2_59 = [ nMB, nML, nMZ ]
  masses2_60 = [ nML, nML, nMZ ]
  masses2_61 = [ nMW, nMT, nMT ]
  masses2_62 = [ nMT, nMW, 0 ]
  masses2_63 = [ nMW, nMW, 0 ]
  masses2_64 = [ nMT, nMW, nMW ]
  masses2_65 = [ nMB, nMZ, 0 ]
  masses2_66 = [ nMB, nMZ, nMH ]
  masses2_67 = [ 0, nMZ, nML ]
  masses2_68 = [ nMB, nMZ, nML ]
  masses2_69 = [ nMH, nMZ, nML ]
  masses2_70 = [ nMZ, nMZ, nML ]
  masses2_71 = [ nMB, nMZ, nMZ ]
  masses2_72 = [ nMB, 0, nML, 0 ]
  masses2_73 = [ nMB, 0, nML, nMH ]
  masses2_74 = [ nMB, 0, nML, nMZ ]
  masses2_75 = [ nMB, nMH, nML, 0 ]
  masses2_76 = [ nMB, nMH, nML, nMH ]
  masses2_77 = [ nMB, nMH, nML, nMZ ]
  masses2_78 = [ nMT, nMW, 0, nMW ]
  masses2_79 = [ nMB, nMZ, nML, 0 ]
  masses2_80 = [ nMB, nMZ, nML, nMH ]
  masses2_81 = [ nMB, nMZ, nML, nMZ ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)



#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_17, masses2_76, T0sum(1), M2)
  call TI_call_OL(0,0, momenta_17, masses2_80, T0sum(2), M2)
  call TI_call_OL(0,0, momenta_17, masses2_77, T0sum(3), M2)
  call TI_call_OL(0,0, momenta_17, masses2_81, T0sum(4), M2)
  call TI_call_OL(0,0, momenta_17, masses2_73, T0sum(5), M2)
  call TI_call_OL(0,0, momenta_17, masses2_74, T0sum(6), M2)
  call TI_call_OL(0,0, momenta_17, masses2_75, T0sum(7), M2)
  call TI_call_OL(0,0, momenta_17, masses2_79, T0sum(8), M2)
  call TI_call_OL(0,0, momenta_17, masses2_72, T0sum(9), M2)
  call TI_call_OL(0,0, momenta_16, masses2_76, T0sum(10), M2)
  call TI_call_OL(0,0, momenta_16, masses2_77, T0sum(11), M2)
  call TI_call_OL(0,0, momenta_16, masses2_80, T0sum(12), M2)
  call TI_call_OL(0,0, momenta_16, masses2_81, T0sum(13), M2)
  call TI_call_OL(0,0, momenta_16, masses2_78, T0sum(14), M2)
  call TI_call_OL(0,0, momenta_16, masses2_75, T0sum(15), M2)
  call TI_call_OL(0,0, momenta_16, masses2_79, T0sum(16), M2)
  call TI_call_OL(0,0, momenta_16, masses2_73, T0sum(17), M2)
  call TI_call_OL(0,0, momenta_16, masses2_74, T0sum(18), M2)
  call TI_call_OL(0,0, momenta_16, masses2_72, T0sum(19), M2)
  call TI_call_OL(0,0, momenta_15, masses2_52, T0sum(20), M2)
  call TI_call_OL(0,0, momenta_13, masses2_57, T0sum(21), M2)
  call TI_call_OL(0,0, momenta_11, masses2_49, T0sum(22), M2)
  call TI_call_OL(0,0, momenta_10, masses2_51, T0sum(23), M2)
  call TI_call_OL(0,0, momenta_15, masses2_69, T0sum(24), M2)
  call TI_call_OL(0,0, momenta_11, masses2_66, T0sum(25), M2)
  call TI_call_OL(0,0, momenta_10, masses2_68, T0sum(26), M2)
  call TI_call_OL(0,0, momenta_15, masses2_53, T0sum(27), M2)
  call TI_call_OL(0,0, momenta_13, masses2_59, T0sum(28), M2)
  call TI_call_OL(0,0, momenta_11, masses2_54, T0sum(29), M2)
  call TI_call_OL(0,0, momenta_15, masses2_70, T0sum(30), M2)
  call TI_call_OL(0,0, momenta_11, masses2_71, T0sum(31), M2)
  call TI_call_OL(0,0, momenta_15, masses2_40, T0sum(32), M2)
  call TI_call_OL(0,0, momenta_11, masses2_37, T0sum(33), M2)
  call TI_call_OL(0,0, momenta_10, masses2_39, T0sum(34), M2)
  call TI_call_OL(0,0, momenta_15, masses2_41, T0sum(35), M2)
  call TI_call_OL(0,0, momenta_11, masses2_44, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_15, masses2_50, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_13, masses2_55, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_11, masses2_48, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_15, masses2_67, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_11, masses2_65, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_15, masses2_38, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_11, masses2_36, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_14, masses2_52, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_12, masses2_57, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_9, masses2_51, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_14, masses2_53, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_12, masses2_59, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_14, masses2_69, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_9, masses2_68, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_14, masses2_70, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_14, masses2_63, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_12, masses2_43, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_11, masses2_64, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_9, masses2_62, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_14, masses2_50, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_12, masses2_55, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_14, masses2_67, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_14, masses2_40, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_9, masses2_39, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_14, masses2_41, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_14, masses2_38, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_11, masses2_46, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_11, masses2_47, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_11, masses2_61, T0sum(65), M2)
  call TI_call_OL(0,0, momenta_11, masses2_45, T0sum(66), M2)
  call TI_call_OL(0,0, momenta_14, masses2_58, T0sum(67), M2)
  call TI_call_OL(0,0, momenta_14, masses2_60, T0sum(68), M2)
  call TI_call_OL(0,0, momenta_14, masses2_56, T0sum(69), M2)
  call TI_call_OL(0,0, momenta_14, masses2_42, T0sum(70), M2)
  call TI_call_OL(0,0, momenta_6, masses2_33, T0sum(71), M2)
  call TI_call_OL(0,0, momenta_5, masses2_16, T0sum(72), M2)
  call TI_call_OL(0,0, momenta_2, masses2_32, T0sum(73), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(74), M2)
  call TI_call_OL(0,0, momenta_1, masses2_9, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_1, masses2_4, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_6, masses2_19, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_5, masses2_32, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_2, masses2_16, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_6, masses2_35, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_8, masses2_18, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_7, masses2_24, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_1, masses2_5, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_8, masses2_34, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_7, masses2_22, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_8, masses2_28, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_7, masses2_8, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_6, masses2_30, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_1, masses2_8, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_5, masses2_29, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_2, masses2_29, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_1, masses2_7, T0sum(92), M2)
  call TI_call_OL(0,0, momenta_6, masses2_11, T0sum(93), M2)
  call TI_call_OL(0,0, momenta_5, masses2_12, T0sum(94), M2)
  call TI_call_OL(0,0, momenta_2, masses2_12, T0sum(95), M2)
  call TI_call_OL(0,0, momenta_5, masses2_13, T0sum(96), M2)
  call TI_call_OL(0,0, momenta_2, masses2_13, T0sum(97), M2)
  call TI_call_OL(0,0, momenta_6, masses2_26, T0sum(98), M2)
  call TI_call_OL(0,0, momenta_5, masses2_27, T0sum(99), M2)
  call TI_call_OL(0,0, momenta_2, masses2_27, T0sum(100), M2)
  call TI_call_OL(0,0, momenta_5, masses2_10, T0sum(101), M2)
  call TI_call_OL(0,0, momenta_2, masses2_10, T0sum(102), M2)
  call TI_call_OL(0,0, momenta_8, masses2_22, T0sum(103), M2)
  call TI_call_OL(0,0, momenta_7, masses2_18, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_6, masses2_23, T0sum(105), M2)
  call TI_call_OL(0,0, momenta_8, masses2_24, T0sum(106), M2)
  call TI_call_OL(0,0, momenta_7, masses2_34, T0sum(107), M2)
  call TI_call_OL(0,0, momenta_8, masses2_20, T0sum(108), M2)
  call TI_call_OL(0,0, momenta_7, masses2_5, T0sum(109), M2)
  call TI_call_OL(0,0, momenta_8, masses2_8, T0sum(110), M2)
  call TI_call_OL(0,0, momenta_7, masses2_28, T0sum(111), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(112), M2)
  call TI_call_OL(0,0, momenta_6, masses2_17, T0sum(113), M2)
  call TI_call_OL(0,0, momenta_4, masses2_21, T0sum(114), M2)
  call TI_call_OL(0,0, momenta_6, masses2_4, T0sum(115), M2)
  call TI_call_OL(0,0, momenta_2, masses2_2, T0sum(116), M2)
  call TI_call_OL(0,0, momenta_6, masses2_9, T0sum(117), M2)
  call TI_call_OL(0,0, momenta_6, masses2_15, T0sum(118), M2)
  call TI_call_OL(0,0, momenta_5, masses2_2, T0sum(119), M2)
  call TI_call_OL(0,0, momenta_6, masses2_31, T0sum(120), M2)
  call TI_call_OL(0,0, momenta_3, masses2_21, T0sum(121), M2)
  call TI_call_OL(0,0, momenta_3, masses2_7, T0sum(122), M2)
  call TI_call_OL(0,0, momenta_7, masses2_20, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_8, masses2_5, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_6, masses2_14, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_6, masses2_25, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_1, masses2_6, T0sum(128), M2)

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppllj_ew_llxbbx_1_/**/REALKIND
