
module ol_vamp_2_ppllj_ew_llxuuxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj_ew_llxuuxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj_ew_llxuuxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllj_ew_llxuuxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllj_ew_llxuuxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllj_ew_llxuuxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllj_ew_llxuuxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(73),m3h8x4(:,126),heltab2x32(:,:,251))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(74),m3h8x4(:,127),heltab2x32(:,:,252))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(75),m3h8x4(:,128),heltab2x32(:,:,253))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(76),m3h8x4(:,129),heltab2x32(:,:,254))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(77),m3h8x4(:,130),heltab2x32(:,:,255))
  Gcoeff(:)%j = (c(34)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(78),m3h8x4(:,131),heltab2x32(:,:,256))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,20),28,G1H4(79),m3h8x4(:,132),heltab2x32(:,:,257))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,19),G0H4(5),m3h8x4(:,133),heltab2x32(:,:,258))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,19),G0H4(6),m3h8x4(:,134),heltab2x32(:,:,259))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(4),m3h8x4(:,135),heltab2x32(:,:,260))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(13),m3h8x4(:,136),heltab2x32(:,:,261))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,19),G0H4(14),m3h8x4(:,137),heltab2x32(:,:,262))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[28,3],[nMW,nMW],2,2,wf8(:,19),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,19),G0H4(15),m3h8x4(:,138),heltab2x32(:,:,263))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[28,3],[nMH,nMZ],2,2,wf8(:,20),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(16),m3h8x4(:,139),heltab2x32(:,:,264))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(17),m3h8x4(:,140),heltab2x32(:,:,265))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[28,3],[nMW,nMW],2,2,wf8(:,20),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(18),m3h8x4(:,141),heltab2x32(:,:,266))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[24,7],[0,0],2,2,wf4(:,6),wf8(:,25))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(5),m3h4x8(:,51),heltab2x32(:,:,267))
  call Hloop_A_Q(ntryL,G0H8(5),24,0,G1H8(8),n2h8(23))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[24,7],[0,nMZ],2,2,wf4(:,6),wf8(:,25))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(6),ngZu,m3h4x8(:,52),heltab2x32(:,:,268))
  call Hloop_A_Q(ntryL,G0H8(6),24,0,G1H8(5),n2h8(24))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[24,7],[0,nMW],2,2,wf4(:,6),wf8(:,25))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(1),m3h4x8(:,53),heltab2x32(:,:,269))
  call Hloop_A_Q(ntryL,G0H8(1),24,0,G1H8(2),n2h8(25))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[24,7],[0,0],2,2,wf4(:,6),wf8(:,25))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(2),m3h4x8(:,54),heltab2x32(:,:,270))
  call Hloop_A_Q(ntryL,G0H8(2),24,0,G1H8(4),n2h8(26))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[24,7],[0,0],2,2,wf4(:,6),wf8(:,26))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,55),heltab2x32(:,:,271))
  call Hloop_A_Q(ntryL,G0H8(11),24,0,G1H8(14),n2h8(27))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[24,7],[0,nMZ],2,2,wf4(:,6),wf8(:,26))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(12),ngZu,m3h4x8(:,56),heltab2x32(:,:,272))
  call Hloop_A_Q(ntryL,G0H8(12),24,0,G1H8(12),n2h8(28))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[24,7],[0,nMW],2,2,wf4(:,6),wf8(:,26))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),m3h4x8(:,57),heltab2x32(:,:,273))
  call Hloop_A_Q(ntryL,G0H8(13),24,0,G1H8(13),n2h8(29))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[24,7],[0,0],2,2,wf4(:,6),wf8(:,26))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(14),m3h4x8(:,58),heltab2x32(:,:,274))
  call Hloop_A_Q(ntryL,G0H8(14),24,0,G1H8(18),n2h8(30))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[28,3],[nME,nME],2,2,wf8(:,23),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,142),heltab2x32(:,:,275))
  call Hloop_Q_A(ntryL,G0H4(19),28,nME,G1H4(80),n2h4(131))
  Gcoeff(:)%j = (-(c(73)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[28,3],[nMM,nMM],2,2,wf8(:,23),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,143),heltab2x32(:,:,276))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMM,G1H4(81),n2h4(132))
  Gcoeff(:)%j = (-(c(71)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[28,3],[nML,nML],2,2,wf8(:,23),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,144),heltab2x32(:,:,277))
  call Hloop_Q_A(ntryL,G0H4(19),28,nML,G1H4(82),n2h4(133))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[28,3],[nMT,nMT],2,2,wf8(:,23),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,145),heltab2x32(:,:,278))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMT,G1H4(83),n2h4(134))
  Gcoeff(:)%j = (-(c(66)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[28,3],[nMB,nMB],2,2,wf8(:,23),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,146),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMB,G1H4(84),n2h4(135))
  Gcoeff(:)%j = (c(70)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[28,3],[nME,nME],2,2,wf8(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(19),ngZl,m3h8x4(:,147),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H4(19),28,nME,G1H4(85),n2h4(136))
  Gcoeff(:)%j = (c(74)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[28,3],[nMM,nMM],2,2,wf8(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(19),ngZl,m3h8x4(:,148),heltab2x32(:,:,281))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMM,G1H4(86),n2h4(137))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[28,3],[nML,nML],2,2,wf8(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(19),ngZl,m3h8x4(:,149),heltab2x32(:,:,282))
  call Hloop_Q_A(ntryL,G0H4(19),28,nML,G1H4(87),n2h4(138))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[28,3],[nMT,nMT],2,2,wf8(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(19),ngZu,m3h8x4(:,150),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMT,G1H4(88),n2h4(139))
  Gcoeff(:)%j = (c(67)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[28,3],[nMB,nMB],2,2,wf8(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(19),ngZd,m3h8x4(:,151),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMB,G1H4(89),n2h4(140))
  Gcoeff(:)%j = (c(69)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[28,3],[nME,nME],2,2,wf8(:,23),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,152),heltab2x32(:,:,285))
  call Hloop_Q_A(ntryL,G0H4(19),28,nME,G1H4(90),n2h4(141))
  Gcoeff(:)%j = (c(73)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[28,3],[nMM,nMM],2,2,wf8(:,23),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,153),heltab2x32(:,:,286))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMM,G1H4(91),n2h4(142))
  Gcoeff(:)%j = (c(71)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[28,3],[nML,nML],2,2,wf8(:,23),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,154),heltab2x32(:,:,287))
  call Hloop_Q_A(ntryL,G0H4(19),28,nML,G1H4(92),n2h4(143))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[28,3],[nMT,nMT],2,2,wf8(:,23),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,155),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMT,G1H4(93),n2h4(144))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[28,3],[nMB,nMB],2,2,wf8(:,23),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,156),heltab2x32(:,:,289))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMB,G1H4(94),n2h4(145))
  Gcoeff(:)%j = (-(c(70)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[28,3],[nME,nME],2,2,wf8(:,24),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(19),ngZl,m3h8x4(:,157),heltab2x32(:,:,290))
  call Hloop_Q_A(ntryL,G0H4(19),28,nME,G1H4(95),n2h4(146))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[28,3],[nMM,nMM],2,2,wf8(:,24),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(19),ngZl,m3h8x4(:,158),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMM,G1H4(96),n2h4(147))
  Gcoeff(:)%j = (-(c(72)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[28,3],[nML,nML],2,2,wf8(:,24),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(19),ngZl,m3h8x4(:,159),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H4(19),28,nML,G1H4(97),n2h4(148))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[28,3],[nMT,nMT],2,2,wf8(:,24),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(19),ngZu,m3h8x4(:,160),heltab2x32(:,:,293))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMT,G1H4(98),n2h4(149))
  Gcoeff(:)%j = (-(c(67)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[28,3],[nMB,nMB],2,2,wf8(:,24),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(19),ngZd,m3h8x4(:,161),heltab2x32(:,:,294))
  call Hloop_Q_A(ntryL,G0H4(19),28,nMB,G1H4(99),n2h4(150))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(100),m3h8x4(:,162),heltab2x32(:,:,295))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(101),m3h8x4(:,163),heltab2x32(:,:,296))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[28,3],[nMH,nMZ],2,2,wf8(:,24),wf4(:,19))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(102),m3h8x4(:,164),heltab2x32(:,:,297))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(103),m3h8x4(:,165),heltab2x32(:,:,298))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(104),m3h8x4(:,166),heltab2x32(:,:,299))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(105),m3h8x4(:,167),heltab2x32(:,:,300))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(106),m3h8x4(:,168),heltab2x32(:,:,301))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(107),m3h8x4(:,169),heltab2x32(:,:,302))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(108),m3h8x4(:,170),heltab2x32(:,:,303))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(109),m3h8x4(:,171),heltab2x32(:,:,304))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(110),m3h8x4(:,172),heltab2x32(:,:,305))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(111),m3h8x4(:,173),heltab2x32(:,:,306))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(112),m3h8x4(:,174),heltab2x32(:,:,307))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,23),G0H4(19),m3h8x4(:,175),heltab2x32(:,:,308))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,23),G0H4(20),m3h8x4(:,176),heltab2x32(:,:,309))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(21),m3h8x4(:,177),heltab2x32(:,:,310))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(22),m3h8x4(:,178),heltab2x32(:,:,311))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,19))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,23),G0H4(23),m3h8x4(:,179),heltab2x32(:,:,312))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,19))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,23),G0H4(24),m3h8x4(:,180),heltab2x32(:,:,313))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[28,3],[nMH,nMZ],2,2,wf8(:,24),wf4(:,19))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(25),m3h8x4(:,181),heltab2x32(:,:,314))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,19))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(26),m3h8x4(:,182),heltab2x32(:,:,315))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,19))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(27),m3h8x4(:,183),heltab2x32(:,:,316))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[28,3],[nME,nME],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,184),heltab2x32(:,:,317))
  call Hloop_Q_A(ntryL,G0H4(28),28,nME,G1H4(113),n2h4(151))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[28,3],[nMM,nMM],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,185),heltab2x32(:,:,318))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMM,G1H4(114),n2h4(152))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[28,3],[nML,nML],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,186),heltab2x32(:,:,319))
  call Hloop_Q_A(ntryL,G0H4(28),28,nML,G1H4(115),n2h4(153))
  Gcoeff(:)%j = (c(52)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[28,3],[0,0],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,187),heltab2x32(:,:,320))
  call Hloop_Q_A(ntryL,G0H4(28),28,0,G1H4(116),n2h4(154))
  Gcoeff(:)%j = (c(49)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[28,3],[nMT,nMT],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,188),heltab2x32(:,:,321))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMT,G1H4(117),n2h4(155))
  Gcoeff(:)%j = (c(47)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[28,3],[0,0],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,189),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G0H4(28),28,0,G1H4(118),n2h4(156))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[28,3],[nMB,nMB],2,2,wf8(:,23),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,190),heltab2x32(:,:,323))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMB,G1H4(119),n2h4(157))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[28,3],[nME,nME],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZl,m3h8x4(:,191),heltab2x32(:,:,324))
  call Hloop_Q_A(ntryL,G0H4(28),28,nME,G1H4(120),n2h4(158))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[28,3],[nMM,nMM],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZl,m3h8x4(:,192),heltab2x32(:,:,325))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMM,G1H4(121),n2h4(159))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[28,3],[nML,nML],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZl,m3h8x4(:,193),heltab2x32(:,:,326))
  call Hloop_Q_A(ntryL,G0H4(28),28,nML,G1H4(122),n2h4(160))
  Gcoeff(:)%j = (c(58)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[28,3],[0,0],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZu,m3h8x4(:,194),heltab2x32(:,:,327))
  call Hloop_Q_A(ntryL,G0H4(28),28,0,G1H4(123),n2h4(161))
  Gcoeff(:)%j = (c(54)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[28,3],[nMT,nMT],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZu,m3h8x4(:,195),heltab2x32(:,:,328))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMT,G1H4(124),n2h4(162))
  Gcoeff(:)%j = (-(c(54)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[28,3],[0,0],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZd,m3h8x4(:,196),heltab2x32(:,:,329))
  call Hloop_Q_A(ntryL,G0H4(28),28,0,G1H4(125),n2h4(163))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[28,3],[nMB,nMB],2,2,wf8(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZd,m3h8x4(:,197),heltab2x32(:,:,330))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMB,G1H4(126),n2h4(164))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[28,3],[nME,nME],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,198),heltab2x32(:,:,331))
  call Hloop_Q_A(ntryL,G0H4(28),28,nME,G1H4(127),n2h4(165))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[28,3],[nMM,nMM],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,199),heltab2x32(:,:,332))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMM,G1H4(128),n2h4(166))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[28,3],[nML,nML],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,200),heltab2x32(:,:,333))
  call Hloop_Q_A(ntryL,G0H4(28),28,nML,G1H4(129),n2h4(167))
  Gcoeff(:)%j = (-(c(55)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[28,3],[0,0],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,201),heltab2x32(:,:,334))
  call Hloop_Q_A(ntryL,G0H4(28),28,0,G1H4(130),n2h4(168))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[28,3],[nMT,nMT],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,202),heltab2x32(:,:,335))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMT,G1H4(131),n2h4(169))
  Gcoeff(:)%j = (c(51)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[28,3],[0,0],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,203),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G0H4(28),28,0,G1H4(132),n2h4(170))
  Gcoeff(:)%j = (c(48)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[28,3],[nMB,nMB],2,2,wf8(:,23),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,204),heltab2x32(:,:,337))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMB,G1H4(133),n2h4(171))
  Gcoeff(:)%j = (-(c(60)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[28,3],[0,0],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZn,m3h8x4(:,205),heltab2x32(:,:,338))
  call Hloop_Q_A(ntryL,G0H4(28),28,0,G1H4(134),n2h4(172))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[28,3],[nME,nME],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZl,m3h8x4(:,206),heltab2x32(:,:,339))
  call Hloop_Q_A(ntryL,G0H4(28),28,nME,G1H4(135),n2h4(173))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[28,3],[nMM,nMM],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZl,m3h8x4(:,207),heltab2x32(:,:,340))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMM,G1H4(136),n2h4(174))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[28,3],[nML,nML],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZl,m3h8x4(:,208),heltab2x32(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(28),28,nML,G1H4(137),n2h4(175))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[28,3],[0,0],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZu,m3h8x4(:,209),heltab2x32(:,:,342))
  call Hloop_Q_A(ntryL,G0H4(28),28,0,G1H4(138),n2h4(176))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[28,3],[nMT,nMT],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZu,m3h8x4(:,210),heltab2x32(:,:,343))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMT,G1H4(139),n2h4(177))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[28,3],[0,0],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZd,m3h8x4(:,211),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G0H4(28),28,0,G1H4(140),n2h4(178))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[28,3],[nMB,nMB],2,2,wf8(:,24),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,24),G0H4(28),ngZd,m3h8x4(:,212),heltab2x32(:,:,345))
  call Hloop_Q_A(ntryL,G0H4(28),28,nMB,G1H4(141),n2h4(179))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(142),m3h8x4(:,213),heltab2x32(:,:,346))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(143),m3h8x4(:,214),heltab2x32(:,:,347))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(144),m3h8x4(:,215),heltab2x32(:,:,348))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[28,3],[nMH,nMZ],2,2,wf8(:,24),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(145),m3h8x4(:,216),heltab2x32(:,:,349))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(146),m3h8x4(:,217),heltab2x32(:,:,350))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(147),m3h8x4(:,218),heltab2x32(:,:,351))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(148),m3h8x4(:,219),heltab2x32(:,:,352))
  Gcoeff(:)%j = (c(35)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(149),m3h8x4(:,220),heltab2x32(:,:,353))
  Gcoeff(:)%j = (c(35)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(150),m3h8x4(:,221),heltab2x32(:,:,354))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(151),m3h8x4(:,222),heltab2x32(:,:,355))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(152),m3h8x4(:,223),heltab2x32(:,:,356))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(153),m3h8x4(:,224),heltab2x32(:,:,357))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(154),m3h8x4(:,225),heltab2x32(:,:,358))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(155),m3h8x4(:,226),heltab2x32(:,:,359))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(156),m3h8x4(:,227),heltab2x32(:,:,360))
  Gcoeff(:)%j = (c(34)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,23),28,G1H4(157),m3h8x4(:,228),heltab2x32(:,:,361))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),28,G1H4(158),m3h8x4(:,229),heltab2x32(:,:,362))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,23),G0H4(28),m3h8x4(:,230),heltab2x32(:,:,363))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,23),G0H4(29),m3h8x4(:,231),heltab2x32(:,:,364))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(30),m3h8x4(:,232),heltab2x32(:,:,365))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(31),m3h8x4(:,233),heltab2x32(:,:,366))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,23),G0H4(32),m3h8x4(:,234),heltab2x32(:,:,367))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[28,3],[nMW,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,23),G0H4(33),m3h8x4(:,235),heltab2x32(:,:,368))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[28,3],[nMH,nMZ],2,2,wf8(:,24),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(34),m3h8x4(:,236),heltab2x32(:,:,369))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(35),m3h8x4(:,237),heltab2x32(:,:,370))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[28,3],[nMW,nMW],2,2,wf8(:,24),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(36),m3h8x4(:,238),heltab2x32(:,:,371))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(16),[G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(4),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(80),G1H4(4),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(81),G1H4(7),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(82),G1H4(24),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(83),G1H4(11),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(84),G1H4(8),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(90),G1H4(29),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(91),G1H4(15),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(92),G1H4(13),G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(98),[G1H4(93),G1H4(16),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(99),[G1H4(94),G1H4(33),G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(101),[G1H4(100),G1H4(17),G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(105),G1H4(104),G1H4(103),G1H4(25),G1H4(27) &
    ,G1H4(23),G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(110),[G1H4(109),G1H4(108),G1H4(107),G1H4(32),G1H4(31) &
    ,G1H4(30),G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(111),G1H4(1),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(22),[G0H4(21),G0H4(20),G0H4(19),G0H4(11),G0H4(12),G0H4(8) &
    ,G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(27),[G0H4(26),G0H4(24),G0H4(23),G0H4(10),G0H4(2),G0H4(3) &
    ,G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(25),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(113),G1H4(41),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(114),G1H4(42),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(115),G1H4(43),G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(123),G1H4(118),G1H4(116),G1H4(46),G1H4(44) &
    ,G1H4(39),G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(117),G1H4(45),G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(119),G1H4(47),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(127),G1H4(56),G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(128),G1H4(57),G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(137),[G1H4(129),G1H4(58),G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(130),G1H4(59),G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(131),G1H4(60),G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(140),[G1H4(132),G1H4(61),G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(141),[G1H4(133),G1H4(62),G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(143),[G1H4(142),G1H4(64),G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(146),[G1H4(144),G1H4(67),G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(145),[G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(150),[G1H4(149),G1H4(148),G1H4(147),G1H4(71),G1H4(70) &
    ,G1H4(69),G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G1H4(153),G1H4(152),G1H4(151),G1H4(75),G1H4(74) &
    ,G1H4(73),G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(156),[G1H4(155),G1H4(77),G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G1H4(157),G1H4(79),G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(31),[G0H4(30),G0H4(29),G0H4(28),G0H4(13),G0H4(4),G0H4(6) &
    ,G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(36),[G0H4(35),G0H4(33),G0H4(32),G0H4(18),G0H4(17) &
    ,G0H4(15),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(34),[G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(14)])
  call Hloop_VA_Q(ntryL,G0H8(16),wf8(:,21),G0H1(1),m3h8x1(:,9),heltab2x8(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(18),n2h1(112))
  call Hloop_ZA_Q(ntryL,G0H8(10),wf8(:,21),G0H1(1),ngZu,m3h8x1(:,10),heltab2x8(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(48),n2h1(113))
  call Hloop_WA_Q(ntryL,G0H8(15),wf8(:,21),G0H1(1),m3h8x1(:,11),heltab2x8(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(44),n2h1(114))
  call Hloop_VA_Q(ntryL,G0H8(4),wf8(:,22),G0H1(1),m3h8x1(:,12),heltab2x8(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(35),n2h1(115))
  call Hloop_ZA_Q(ntryL,G0H8(18),wf8(:,22),G0H1(1),ngZu,m3h8x1(:,13),heltab2x8(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(47),n2h1(116))
  call Hloop_WA_Q(ntryL,G0H8(3),wf8(:,22),G0H1(1),m3h8x1(:,14),heltab2x8(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(21),n2h1(117))
  call Hloop_QS_A(ntryL,G1H4(85),wf4(:,7),G1H1(1),ngH,m3h4x1(:,9),heltab2x4(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(40),n2h1(118))
  call Hloop_QS_A(ntryL,G1H4(86),wf4(:,7),G1H1(1),ngH,m3h4x1(:,10),heltab2x4(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(41),n2h1(119))
  call Hloop_QS_A(ntryL,G1H4(87),wf4(:,7),G1H1(1),ngH,m3h4x1(:,11),heltab2x4(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(42),n2h1(120))
  call Hloop_QS_A(ntryL,G1H4(88),wf4(:,7),G1H1(1),ngH,m3h4x1(:,12),heltab2x4(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(43),n2h1(121))
  call Hloop_QS_A(ntryL,G1H4(89),wf4(:,7),G1H1(1),ngH,m3h4x1(:,13),heltab2x4(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(44),n2h1(122))
  call Hloop_QS_A(ntryL,G1H4(95),wf4(:,19),G1H1(1),ngX,m3h4x1(:,14),heltab2x4(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(45),n2h1(123))
  call Hloop_QS_A(ntryL,G1H4(96),wf4(:,19),G1H1(1),ngX,m3h4x1(:,15),heltab2x4(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(51),n2h1(124))
  call Hloop_QS_A(ntryL,G1H4(97),wf4(:,19),G1H1(1),ngX,m3h4x1(:,16),heltab2x4(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(54),n2h1(125))
  call Hloop_QS_A(ntryL,G1H4(98),wf4(:,19),G1H1(1),ngX,m3h4x1(:,17),heltab2x4(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(57),n2h1(126))
  call Hloop_QS_A(ntryL,G1H4(99),wf4(:,19),G1H1(1),ngX,m3h4x1(:,18),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(60),n2h1(127))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(101),wf4(:,7),G1tensor(29),m3h4x1(:,19),heltab2x4(:,:,66))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(102),wf4(:,19),G1tensor(45),m3h4x1(:,20),heltab2x4(:,:,67))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(106),wf4(:,7),G1tensor(56),m3h4x1(:,21),heltab2x4(:,:,68))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(110),wf4(:,19),G1tensor(61),m3h4x1(:,22),heltab2x4(:,:,69))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(112),wf4(:,7),G1tensor(66),m3h4x1(:,23),heltab2x4(:,:,70))
  call Hcheck_last_ST_V(ntryL,l_switch,G0H4(22),28,wf4(:,7),3,G1tensor(71),m3h4x1(:,24),heltab2x4(:,:,71))
  call Hcheck_last_ST_V(ntryL,l_switch,G0H4(27),28,wf4(:,19),3,G1tensor(76),m3h4x1(:,25),heltab2x4(:,:,72))
  call Hcheck_last_TS_V(ntryL,l_switch,G0H4(25),28,wf4(:,19),3,G1tensor(81),m3h4x1(:,26),heltab2x4(:,:,73))
  call Hloop_QV_A(ntryL,G1H4(120),wf4(:,1),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(63),n2h1(128))
  call Hloop_QV_A(ntryL,G1H4(121),wf4(:,1),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(66),n2h1(129))
  call Hloop_QV_A(ntryL,G1H4(122),wf4(:,1),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(29),n2h1(130))
  call Hloop_QV_A(ntryL,G1H4(125),wf4(:,1),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(131))
  call Hloop_QV_A(ntryL,G1H4(124),wf4(:,1),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(13),n2h1(132))
  call Hloop_QV_A(ntryL,G1H4(126),wf4(:,1),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(47),n2h1(133))
  call Hloop_QZ_A(ntryL,G1H4(135),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,33),heltab2x4(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(19),n2h1(134))
  call Hloop_QZ_A(ntryL,G1H4(136),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,34),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(50),n2h1(135))
  call Hloop_QZ_A(ntryL,G1H4(137),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,35),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(52),n2h1(136))
  call Hloop_QZ_A(ntryL,G1H4(138),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,36),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(137))
  call Hloop_QZ_A(ntryL,G1H4(139),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,37),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(65),n2h1(138))
  call Hloop_QZ_A(ntryL,G1H4(140),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,38),heltab2x4(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(139))
  call Hloop_QZ_A(ntryL,G1H4(141),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,39),heltab2x4(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(140))
  call Hloop_QZ_A(ntryL,G1H4(134),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,40),heltab2x4(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(56),n2h1(141))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(143),28,wf4(:,1),3,G2tensor(53),m3h4x1(:,41),heltab2x4(:,:,88))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(146),28,wf4(:,4),3,G2tensor(55),m3h4x1(:,42),heltab2x4(:,:,89))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(145),28,wf4(:,4),3,G2tensor(58),m3h4x1(:,43),heltab2x4(:,:,90))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(150),28,wf4(:,1),3,G2tensor(61),m3h4x1(:,44),heltab2x4(:,:,91))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(154),28,wf4(:,4),3,G2tensor(64),m3h4x1(:,45),heltab2x4(:,:,92))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(156),28,wf4(:,1),3,G2tensor(67),m3h4x1(:,46),heltab2x4(:,:,93))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(158),28,wf4(:,4),3,G2tensor(3),m3h4x1(:,47),heltab2x4(:,:,94))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(31),wf4(:,1),G0tensor(1),m3h4x1(:,48),heltab2x4(:,:,95))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(36),wf4(:,4),G0tensor(21),m3h4x1(:,49),heltab2x4(:,:,96))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(34),wf4(:,4),G0tensor(46),m3h4x1(:,50),heltab2x4(:,:,97))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(4),wf8(:,25),G1tensor(86),m3h8x1(:,15),heltab2x8(:,:,74))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(5),wf8(:,25),G1tensor(91),ngZu,m3h8x1(:,16),heltab2x8(:,:,75))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(2),wf8(:,25),G1tensor(96),m3h8x1(:,17),heltab2x8(:,:,76))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(18),wf8(:,26),G1tensor(101),m3h8x1(:,18),heltab2x8(:,:,77))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(12),wf8(:,26),G1tensor(106),ngZu,m3h8x1(:,19),heltab2x8(:,:,78))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(13),wf8(:,26),G1tensor(111),m3h8x1(:,20),heltab2x8(:,:,79))
  call ol_merge_tensors(G0tensor(425),[G0tensor(383),G0tensor(373),G0tensor(269),G0tensor(174),G0tensor(84),G0tensor(120) &
    ,G0tensor(24),G0tensor(75),G0tensor(236),G0tensor(171),G0tensor(6)])
  call ol_merge_tensors(G1tensor(35),[G1tensor(18),G0tensor(343),G0tensor(286),G0tensor(118),G0tensor(80),G0tensor(86) &
    ,G0tensor(11)])
  call ol_merge_tensors(G0tensor(291),[G0tensor(267),G0tensor(124),G0tensor(115),G0tensor(15),G0tensor(9),G0tensor(72) &
    ,G0tensor(222),G0tensor(225),G0tensor(35),G0tensor(106),G0tensor(61),G0tensor(16)])
  call ol_merge_tensors(G0tensor(250),[G0tensor(30),G0tensor(216),G0tensor(51),G0tensor(26)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(67),G2tensor(64),G2tensor(61),G2tensor(55),G2tensor(53),G1tensor(76),G1tensor(71) &
    ,G1tensor(66),G1tensor(61),G1tensor(56),G1tensor(29),G0tensor(21),G0tensor(1),G0tensor(411),G0tensor(19),G0tensor(169) &
    ,G0tensor(83),G0tensor(31)])
  call ol_merge_tensors(G1tensor(111),[G1tensor(96),G0tensor(257),G0tensor(2),G0tensor(221),G0tensor(36)])
  call ol_merge_tensors(G0tensor(422),[G0tensor(417),G0tensor(412),G0tensor(359),G0tensor(263),G0tensor(258),G0tensor(253) &
    ,G0tensor(172),G0tensor(122),G0tensor(105),G0tensor(18),G0tensor(45),G0tensor(3),G0tensor(12),G0tensor(74),G0tensor(226) &
    ,G0tensor(156),G0tensor(66),G0tensor(41)])
  call ol_merge_tensors(G1tensor(21),[G1tensor(44),G0tensor(262),G0tensor(237),G0tensor(56)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(62),G2tensor(68),G2tensor(22),G0tensor(276),G0tensor(89),G0tensor(52),G0tensor(100) &
    ,G0tensor(211),G0tensor(186),G0tensor(166),G0tensor(141),G0tensor(116),G0tensor(96),G0tensor(76)])
  call ol_merge_tensors(G0tensor(362),[G0tensor(347),G0tensor(331),G0tensor(110),G0tensor(90),G0tensor(230),G0tensor(81)])
  call ol_merge_tensors(G0tensor(32),[G0tensor(28),G0tensor(60),G0tensor(102),G0tensor(92),G0tensor(8),G0tensor(101)])
  call ol_merge_tensors(G0tensor(87),[G0tensor(121)])
  call ol_merge_tensors(G0tensor(97),[G0tensor(126)])
  call ol_merge_tensors(G0tensor(443),[G0tensor(438),G0tensor(407),G0tensor(402),G0tensor(397),G0tensor(390),G0tensor(385) &
    ,G0tensor(370),G0tensor(354),G0tensor(349),G0tensor(344),G0tensor(339),G0tensor(327),G0tensor(321),G0tensor(315),G0tensor(309) &
    ,G0tensor(303),G0tensor(298),G0tensor(248),G0tensor(242),G0tensor(223),G0tensor(205),G0tensor(193),G0tensor(187),G0tensor(183) &
    ,G0tensor(180),G0tensor(138),G0tensor(162),G0tensor(58),G0tensor(59),G0tensor(117),G0tensor(27),G0tensor(29),G0tensor(227) &
    ,G0tensor(135),G0tensor(201),G0tensor(131)])
  call ol_merge_tensors(G0tensor(17),[G0tensor(146)])
  call ol_merge_tensors(G0tensor(55),[G0tensor(151)])
  call ol_merge_tensors(G1tensor(101),[G1tensor(86),G0tensor(431),G0tensor(401),G0tensor(379),G0tensor(281),G0tensor(210) &
    ,G0tensor(94),G0tensor(235),G0tensor(85),G0tensor(176)])
  call ol_merge_tensors(G0tensor(294),[G0tensor(245),G0tensor(208),G0tensor(199),G0tensor(207),G0tensor(10),G0tensor(191)])
  call ol_merge_tensors(G1tensor(106),[G1tensor(91),G0tensor(320),G0tensor(247),G0tensor(175),G0tensor(168),G0tensor(215) &
    ,G0tensor(196)])
  call ol_merge_tensors(G1tensor(47),[G1tensor(48),G0tensor(353),G0tensor(348),G0tensor(308),G0tensor(219),G0tensor(132)])
  call ol_merge_tensors(G0tensor(260),[G0tensor(251),G0tensor(212)])
  call ol_merge_tensors(G0tensor(356),[G0tensor(256),G0tensor(139)])
  call ol_merge_tensors(G0tensor(367),[G0tensor(352),G0tensor(342),G0tensor(336),G0tensor(112),G0tensor(217)])
  call ol_merge_tensors(G0tensor(357),[G0tensor(37),G0tensor(192),G0tensor(232)])
  call ol_merge_tensors(G0tensor(415),[G0tensor(20),G0tensor(202),G0tensor(4)])
  call ol_merge_tensors(G0tensor(421),[G0tensor(82)])
  call ol_merge_tensors(G0tensor(435),[G0tensor(405),G0tensor(400),G0tensor(394),G0tensor(65),G0tensor(13)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(13),G2tensor(57),G2tensor(43),G0tensor(127)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(47),G2tensor(60),G2tensor(44),G0tensor(39)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(29),G2tensor(54),G2tensor(42),G0tensor(229),G0tensor(160),G0tensor(142)])
  call ol_merge_tensors(G0tensor(444),[G0tensor(437),G0tensor(432),G0tensor(427),G0tensor(396),G0tensor(391),G0tensor(380) &
    ,G0tensor(375),G0tensor(369),G0tensor(364),G0tensor(338),G0tensor(333),G0tensor(328),G0tensor(322),G0tensor(316),G0tensor(310) &
    ,G0tensor(304),G0tensor(297),G0tensor(292),G0tensor(287),G0tensor(282),G0tensor(277),G0tensor(272),G0tensor(243),G0tensor(224) &
    ,G0tensor(200),G0tensor(184),G0tensor(170),G0tensor(163),G0tensor(239),G0tensor(114),G0tensor(149),G0tensor(234),G0tensor(93) &
    ,G0tensor(144),G0tensor(68),G0tensor(152),G0tensor(145),G0tensor(54)])
  call ol_merge_tensors(G0tensor(182),[G0tensor(177),G0tensor(44)])
  call ol_merge_tensors(G0tensor(393),[G0tensor(366),G0tensor(325),G0tensor(319),G0tensor(313),G0tensor(140)])
  call ol_merge_tensors(G0tensor(387),[G0tensor(324),G0tensor(306),G0tensor(300),G0tensor(295),G0tensor(48)])
  call ol_merge_tensors(G0tensor(414),[G0tensor(410),G0tensor(67)])
  call ol_merge_tensors(G0tensor(419),[G0tensor(409),G0tensor(57)])
  call ol_merge_tensors(G0tensor(434),[G0tensor(335),G0tensor(238),G0tensor(173),G0tensor(148),G0tensor(165)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(81),G1tensor(45),G0tensor(46),G0tensor(150)])
  call ol_merge_tensors(G0tensor(440),[G0tensor(233),G0tensor(214),G0tensor(189),G0tensor(179),G0tensor(157)])
  call ol_merge_tensors(G0tensor(372),[G0tensor(361),G0tensor(301),G0tensor(280),G0tensor(275),G0tensor(78)])
  call ol_merge_tensors(G0tensor(377),[G0tensor(312),G0tensor(284),G0tensor(274),G0tensor(270),G0tensor(73)])
  call ol_merge_tensors(G0tensor(429),[G0tensor(129),G0tensor(104),G0tensor(154),G0tensor(79)])
  call ol_merge_tensors(G0tensor(209),[G0tensor(153),G0tensor(123),G0tensor(119),G0tensor(113)])
  call ol_merge_tensors(G0tensor(424),[G0tensor(330),G0tensor(190),G0tensor(99),G0tensor(98)])
  call ol_merge_tensors(G0tensor(337),[G0tensor(332),G0tensor(218),G0tensor(133),G0tensor(164)])
  call ol_merge_tensors(G0tensor(399),[G0tensor(341),G0tensor(314),G0tensor(185),G0tensor(143)])
  call ol_merge_tensors(G0tensor(382),[G0tensor(346),G0tensor(302),G0tensor(198),G0tensor(203)])
  call ol_merge_tensors(G0tensor(404),[G0tensor(351),G0tensor(326),G0tensor(246),G0tensor(241)])
  call ol_merge_tensors(G0tensor(420),[G0tensor(416),G0tensor(265),G0tensor(255),G0tensor(252)])
  call ol_merge_tensors(G0tensor(358),[G0tensor(266),G0tensor(261)])
  call ol_merge_tensors(G0tensor(318),[G0tensor(296),G0tensor(289),G0tensor(279),G0tensor(271)])
  call ol_merge_tensors(G0tensor(368),[G0tensor(363),G0tensor(307),G0tensor(290),G0tensor(285)])
  call ol_merge_tensors(G0tensor(395),[G0tensor(388),G0tensor(378),G0tensor(374)])
  call ol_merge_tensors(G0tensor(442),[G0tensor(406),G0tensor(389),G0tensor(384)])
  call ol_merge_tensors(G0tensor(441),[G0tensor(436),G0tensor(430),G0tensor(426)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(63),G2tensor(45),G2tensor(40)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(66),G2tensor(51),G2tensor(41)])
call TI_bubble_red(G2tensor(3),28,mass2set(:,1),G0tensor(71),M2L1R1,G0tensor(91))
call TI_bubble_red(G2tensor(56),28,mass2set(:,2),G0tensor(111),M2L1R1)
call TI_bubble_red(G2tensor(65),28,mass2set(:,3),G0tensor(136),M2L1R1,G0tensor(161))
call TI_bubble_red(G2tensor(59),28,mass2set(:,4),G0tensor(181),M2L1R1,G0tensor(206))
call TI_bubble_red(G2tensor(52),28,mass2set(:,5),G0tensor(109),M2L1R1,G0tensor(88))
call TI_bubble_red(G2tensor(58),28,mass2set(:,6),G0tensor(159),M2L1R1,G0tensor(231),G0tensor(108))
call TI_bubble_red(G2tensor(19),28,mass2set(:,7),G0tensor(128),M2L1R1,G0tensor(134))
call TI_bubble_red(G2tensor(50),28,mass2set(:,8),G0tensor(158),M2L1R1,G0tensor(204))
  call ol_merge_tensors(G0tensor(422),[G0tensor(91)])
  call ol_merge_tensors(G0tensor(231),[G0tensor(443)])
  call ol_merge_tensors(G0tensor(38),[G0tensor(161)])
  call ol_merge_tensors(G0tensor(42),[G0tensor(206)])
  call ol_merge_tensors(G0tensor(444),[G0tensor(88)])
  call ol_merge_tensors(G0tensor(108),[G0tensor(182)])
call TI_bubble_red(G1tensor(35),20,mass2set(:,2),G0tensor(178),M2L1R1)
call TI_bubble_red(G1tensor(111),24,mass2set(:,9),G0tensor(188),M2L1R1,G0tensor(195))
call TI_bubble_red(G1tensor(21),20,mass2set(:,10),G0tensor(213),M2L1R1,G0tensor(50))
call TI_bubble_red(G1tensor(101),24,mass2set(:,2),G0tensor(228),M2L1R1)
call TI_bubble_red(G1tensor(106),24,mass2set(:,11),G0tensor(244),M2L1R1,G0tensor(249))
call TI_bubble_red(G1tensor(47),20,mass2set(:,12),G0tensor(40),M2L1R1,G0tensor(254))
  call ol_merge_tensors(G0tensor(50),[G0tensor(195),G0tensor(422)])
  call ol_merge_tensors(G0tensor(254),[G0tensor(249),G0tensor(231)])
  call ol_merge_tensors(T0sum(135),[G0tensor(425)])
  call ol_merge_tensors(T0sum(136),[G0tensor(178)])
  call ol_merge_tensors(T0sum(137),[G0tensor(291)])
  call ol_merge_tensors(T0sum(138),[G0tensor(250)])
  call ol_merge_tensors(T0sum(139),[G0tensor(71)])
  call ol_merge_tensors(T0sum(140),[G0tensor(50)])
  call ol_merge_tensors(T0sum(141),[G0tensor(188)])
  call ol_merge_tensors(T0sum(142),[G0tensor(213)])
  call ol_merge_tensors(T0sum(143),[G0tensor(111)])
  call ol_merge_tensors(T0sum(144),[G0tensor(362)])
  call ol_merge_tensors(T0sum(145),[G0tensor(32)])
  call ol_merge_tensors(T0sum(146),[G0tensor(87)])
  call ol_merge_tensors(T0sum(147),[G0tensor(97)])
  call ol_merge_tensors(T0sum(148),[G0tensor(254)])
  call ol_merge_tensors(T0sum(149),[G0tensor(17)])
  call ol_merge_tensors(T0sum(150),[G0tensor(55)])
  call ol_merge_tensors(T0sum(151),[G0tensor(228)])
  call ol_merge_tensors(T0sum(152),[G0tensor(294)])
  call ol_merge_tensors(T0sum(153),[G0tensor(244)])
  call ol_merge_tensors(T0sum(154),[G0tensor(40)])
  call ol_merge_tensors(T0sum(155),[G0tensor(260)])
  call ol_merge_tensors(T0sum(156),[G0tensor(356)])
  call ol_merge_tensors(T0sum(157),[G0tensor(367)])
  call ol_merge_tensors(T0sum(158),[G0tensor(357)])
  call ol_merge_tensors(T0sum(159),[G0tensor(415)])
  call ol_merge_tensors(T0sum(160),[G0tensor(421)])
  call ol_merge_tensors(T0sum(161),[G0tensor(435)])
  call ol_merge_tensors(T0sum(162),[G0tensor(136)])
  call ol_merge_tensors(T0sum(163),[G0tensor(38)])
  call ol_merge_tensors(T0sum(164),[G0tensor(34)])
  call ol_merge_tensors(T0sum(165),[G0tensor(125)])
  call ol_merge_tensors(T0sum(166),[G0tensor(181)])
  call ol_merge_tensors(T0sum(167),[G0tensor(42)])
  call ol_merge_tensors(T0sum(168),[G0tensor(62)])
  call ol_merge_tensors(T0sum(169),[G0tensor(47)])
  call ol_merge_tensors(T0sum(170),[G0tensor(137)])
  call ol_merge_tensors(T0sum(171),[G0tensor(43)])
  call ol_merge_tensors(T0sum(172),[G0tensor(109)])
  call ol_merge_tensors(T0sum(173),[G0tensor(444)])
  call ol_merge_tensors(T0sum(174),[G0tensor(108)])
  call ol_merge_tensors(T0sum(175),[G0tensor(393)])
  call ol_merge_tensors(T0sum(176),[G0tensor(387)])
  call ol_merge_tensors(T0sum(177),[G0tensor(414)])
  call ol_merge_tensors(T0sum(178),[G0tensor(419)])
  call ol_merge_tensors(T0sum(179),[G0tensor(53)])
  call ol_merge_tensors(T0sum(180),[G0tensor(434)])
  call ol_merge_tensors(T0sum(181),[G0tensor(159)])
  call ol_merge_tensors(T0sum(182),[G0tensor(440)])
  call ol_merge_tensors(T0sum(183),[G0tensor(69)])
  call ol_merge_tensors(T0sum(184),[G0tensor(64)])
  call ol_merge_tensors(T0sum(185),[G0tensor(372)])
  call ol_merge_tensors(T0sum(186),[G0tensor(377)])
  call ol_merge_tensors(T0sum(187),[G0tensor(429)])
  call ol_merge_tensors(T0sum(188),[G0tensor(209)])
  call ol_merge_tensors(T0sum(189),[G0tensor(424)])
  call ol_merge_tensors(T0sum(190),[G0tensor(337)])
  call ol_merge_tensors(T0sum(191),[G0tensor(399)])
  call ol_merge_tensors(T0sum(192),[G0tensor(382)])
  call ol_merge_tensors(T0sum(193),[G0tensor(404)])
  call ol_merge_tensors(T0sum(194),[G0tensor(420)])
  call ol_merge_tensors(T0sum(195),[G0tensor(358)])
  call ol_merge_tensors(T0sum(196),[G0tensor(318)])
  call ol_merge_tensors(T0sum(197),[G0tensor(368)])
  call ol_merge_tensors(T0sum(198),[G0tensor(395)])
  call ol_merge_tensors(T0sum(199),[G0tensor(442)])
  call ol_merge_tensors(T0sum(200),[G0tensor(441)])
  call ol_merge_tensors(T0sum(201),[G0tensor(128)])
  call ol_merge_tensors(T0sum(202),[G0tensor(134)])
  call ol_merge_tensors(T0sum(203),[G0tensor(158)])
  call ol_merge_tensors(T0sum(204),[G0tensor(204)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 20, 21, 23 ],masses2_58,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 23 ],masses2_58,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 20, 23 ],masses2_53,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 20, 21 ],masses2_54,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_58,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 20, 21, 23 ],masses2_59,RedSet_4(1),ScalarBoxes(6))
  call compute_scalar_box([ 16, 21, 23 ],masses2_59,RedSet_4(2),ScalarBoxes(7))
  call compute_scalar_box([ 16, 20, 23 ],masses2_57,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 4, 5, 7 ],masses2_59,RedSet_4(5),ScalarBoxes(9))
  call compute_scalar_box([ 20, 21, 23 ],masses2_68,RedSet_4(1),ScalarBoxes(10))
  call compute_scalar_box([ 16, 20, 23 ],masses2_63,RedSet_4(3),ScalarBoxes(11))
  call compute_scalar_box([ 16, 20, 21 ],masses2_64,RedSet_4(4),ScalarBoxes(12))
  call compute_scalar_box([ 4, 5, 7 ],masses2_68,RedSet_4(5),ScalarBoxes(13))
  call compute_scalar_box([ 20, 21, 23 ],masses2_69,RedSet_4(1),ScalarBoxes(14))
  call compute_scalar_box([ 16, 20, 23 ],masses2_66,RedSet_4(3),ScalarBoxes(15))
  call compute_scalar_box([ 4, 5, 7 ],masses2_69,RedSet_4(5),ScalarBoxes(16))
  call compute_scalar_box([ 20, 21, 23 ],masses2_67,RedSet_4(1),ScalarBoxes(17))
  call compute_scalar_box([ 16, 21, 23 ],masses2_56,RedSet_4(2),ScalarBoxes(18))
  call compute_scalar_box([ 16, 20, 23 ],masses2_62,RedSet_4(3),ScalarBoxes(19))
  call compute_scalar_box([ 16, 20, 21 ],masses2_60,RedSet_4(4),ScalarBoxes(20))
  call compute_scalar_box([ 4, 5, 7 ],masses2_67,RedSet_4(5),ScalarBoxes(21))
  call compute_scalar_box([ 20, 22, 23 ],masses2_58,RedSet_4(6),ScalarBoxes(22))
  call compute_scalar_box([ 16, 22, 23 ],masses2_58,RedSet_4(7),ScalarBoxes(23))
  call compute_scalar_box([ 16, 20, 22 ],masses2_54,RedSet_4(8),ScalarBoxes(24))
  call compute_scalar_box([ 4, 6, 7 ],masses2_58,RedSet_4(9),ScalarBoxes(25))
  call compute_scalar_box([ 20, 22, 23 ],masses2_68,RedSet_4(6),ScalarBoxes(26))
  call compute_scalar_box([ 16, 20, 22 ],masses2_64,RedSet_4(8),ScalarBoxes(27))
  call compute_scalar_box([ 4, 6, 7 ],masses2_68,RedSet_4(9),ScalarBoxes(28))
  call compute_scalar_box([ 20, 22, 23 ],masses2_59,RedSet_4(6),ScalarBoxes(29))
  call compute_scalar_box([ 16, 22, 23 ],masses2_59,RedSet_4(7),ScalarBoxes(30))
  call compute_scalar_box([ 4, 6, 7 ],masses2_59,RedSet_4(9),ScalarBoxes(31))
  call compute_scalar_box([ 20, 22, 23 ],masses2_69,RedSet_4(6),ScalarBoxes(32))
  call compute_scalar_box([ 4, 6, 7 ],masses2_69,RedSet_4(9),ScalarBoxes(33))
! end of process


end subroutine vamp_2

end module ol_vamp_2_ppllj_ew_llxuuxg_1_/**/REALKIND
