
module ol_vamp_2_ppllj_ew_llxaaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj_ew_llxaaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj_ew_llxaaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllj_ew_llxaaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllj_ew_llxaaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllj_ew_llxaaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllj_ew_llxaaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(117),m3h2x16(:,289),heltab2x32(:,:,289))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(118),m3h2x16(:,290),heltab2x32(:,:,290))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(119),m3h2x16(:,291),heltab2x32(:,:,291))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,292),heltab2x32(:,:,292))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,293),heltab2x32(:,:,293))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,294),heltab2x32(:,:,294))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,295),heltab2x32(:,:,295))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,296),heltab2x32(:,:,296))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,297),heltab2x32(:,:,297))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,298),heltab2x32(:,:,298))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,299),heltab2x32(:,:,299))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(124),m3h2x16(:,300),heltab2x32(:,:,300))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,301),heltab2x32(:,:,301))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,302),heltab2x32(:,:,302))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,303),heltab2x32(:,:,303))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,304),heltab2x32(:,:,304))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,305),heltab2x32(:,:,305))
  call Hloop_A_Q(ntryL,G0H16(61),16,nME,G1H16(125),n2h16(73))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,306),heltab2x32(:,:,306))
  call Hloop_A_Q(ntryL,G0H16(61),16,nMM,G1H16(126),n2h16(74))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,307),heltab2x32(:,:,307))
  call Hloop_A_Q(ntryL,G0H16(61),16,nML,G1H16(127),n2h16(75))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,308),heltab2x32(:,:,308))
  call Hloop_Q_A(ntryL,G0H16(61),16,nME,G1H16(128),n2h16(76))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,309),heltab2x32(:,:,309))
  call Hloop_Q_A(ntryL,G0H16(61),16,nMM,G1H16(129),n2h16(77))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,310),heltab2x32(:,:,310))
  call Hloop_Q_A(ntryL,G0H16(61),16,nML,G1H16(130),n2h16(78))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,311),heltab2x32(:,:,311))
  call Hloop_A_Q(ntryL,G0H16(61),16,nMT,G1H16(131),n2h16(79))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,312),heltab2x32(:,:,312))
  call Hloop_Q_A(ntryL,G0H16(61),16,nMT,G1H16(132),n2h16(80))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,313),heltab2x32(:,:,313))
  call Hloop_A_Q(ntryL,G0H16(61),16,nMB,G1H16(133),n2h16(81))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,314),heltab2x32(:,:,314))
  call Hloop_Q_A(ntryL,G0H16(61),16,nMB,G1H16(134),n2h16(82))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,315),heltab2x32(:,:,315))
  call Hloop_A_Q(ntryL,G0H16(61),16,nME,G1H16(135),n2h16(83))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,316),heltab2x32(:,:,316))
  call Hloop_A_Q(ntryL,G0H16(61),16,nMM,G1H16(136),n2h16(84))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,317),heltab2x32(:,:,317))
  call Hloop_A_Q(ntryL,G0H16(61),16,nML,G1H16(137),n2h16(85))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,318),heltab2x32(:,:,318))
  call Hloop_Q_A(ntryL,G0H16(61),16,nME,G1H16(138),n2h16(86))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,319),heltab2x32(:,:,319))
  call Hloop_Q_A(ntryL,G0H16(61),16,nMM,G1H16(139),n2h16(87))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,320),heltab2x32(:,:,320))
  call Hloop_Q_A(ntryL,G0H16(61),16,nML,G1H16(140),n2h16(88))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,321),heltab2x32(:,:,321))
  call Hloop_A_Q(ntryL,G0H16(61),16,nMT,G1H16(141),n2h16(89))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,322),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G0H16(61),16,nMT,G1H16(142),n2h16(90))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,323),heltab2x32(:,:,323))
  call Hloop_A_Q(ntryL,G0H16(61),16,nMB,G1H16(143),n2h16(91))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,324),heltab2x32(:,:,324))
  call Hloop_Q_A(ntryL,G0H16(61),16,nMB,G1H16(144),n2h16(92))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(145),m3h2x16(:,325),heltab2x32(:,:,325))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(146),m3h2x16(:,326),heltab2x32(:,:,326))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(147),m3h2x16(:,327),heltab2x32(:,:,327))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(148),m3h2x16(:,328),heltab2x32(:,:,328))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(149),m3h2x16(:,329),heltab2x32(:,:,329))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(150),m3h2x16(:,330),heltab2x32(:,:,330))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(151),m3h2x16(:,331),heltab2x32(:,:,331))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(152),m3h2x16(:,332),heltab2x32(:,:,332))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(153),m3h2x16(:,333),heltab2x32(:,:,333))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(154),m3h2x16(:,334),heltab2x32(:,:,334))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(155),m3h2x16(:,335),heltab2x32(:,:,335))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(156),m3h2x16(:,336),heltab2x32(:,:,336))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,337),heltab2x32(:,:,337))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,338),heltab2x32(:,:,338))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,339),heltab2x32(:,:,339))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,340),heltab2x32(:,:,340))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,341),heltab2x32(:,:,341))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(66),m3h2x16(:,342),heltab2x32(:,:,342))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(157),m3h2x16(:,343),heltab2x32(:,:,343))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(158),m3h2x16(:,344),heltab2x32(:,:,344))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(159),m3h2x16(:,345),heltab2x32(:,:,345))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(160),m3h2x16(:,346),heltab2x32(:,:,346))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(161),m3h2x16(:,347),heltab2x32(:,:,347))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(162),m3h2x16(:,348),heltab2x32(:,:,348))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(163),m3h2x16(:,349),heltab2x32(:,:,349))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(164),m3h2x16(:,350),heltab2x32(:,:,350))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(165),m3h2x16(:,351),heltab2x32(:,:,351))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(166),m3h2x16(:,352),heltab2x32(:,:,352))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,353),heltab2x32(:,:,353))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,354),heltab2x32(:,:,354))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,355),heltab2x32(:,:,355))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(70),m3h2x16(:,356),heltab2x32(:,:,356))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(71),m3h2x16(:,357),heltab2x32(:,:,357))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(72),m3h2x16(:,358),heltab2x32(:,:,358))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(73),m3h2x16(:,359),heltab2x32(:,:,359))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,360),heltab2x32(:,:,360))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(75),m3h2x16(:,361),heltab2x32(:,:,361))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,362),heltab2x32(:,:,362))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,363),heltab2x32(:,:,363))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,364),heltab2x32(:,:,364))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(167),m3h2x16(:,365),heltab2x32(:,:,365))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(168),m3h2x16(:,366),heltab2x32(:,:,366))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(169),m3h2x16(:,367),heltab2x32(:,:,367))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(170),m3h2x16(:,368),heltab2x32(:,:,368))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(171),m3h2x16(:,369),heltab2x32(:,:,369))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(172),m3h2x16(:,370),heltab2x32(:,:,370))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(173),m3h2x16(:,371),heltab2x32(:,:,371))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(174),m3h2x16(:,372),heltab2x32(:,:,372))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(175),m3h2x16(:,373),heltab2x32(:,:,373))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(176),m3h2x16(:,374),heltab2x32(:,:,374))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,375),heltab2x32(:,:,375))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,376),heltab2x32(:,:,376))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(81),m3h2x16(:,377),heltab2x32(:,:,377))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,378),heltab2x32(:,:,378))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,379),heltab2x32(:,:,379))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,380),heltab2x32(:,:,380))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,381),heltab2x32(:,:,381))
  call Hloop_A_Q(ntryL,G0H16(85),16,nME,G1H16(177),n2h16(93))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,382),heltab2x32(:,:,382))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMM,G1H16(178),n2h16(94))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,383),heltab2x32(:,:,383))
  call Hloop_A_Q(ntryL,G0H16(85),16,nML,G1H16(179),n2h16(95))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,384),heltab2x32(:,:,384))
  call Hloop_Q_A(ntryL,G0H16(85),16,nME,G1H16(180),n2h16(96))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,385),heltab2x32(:,:,385))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMM,G1H16(181),n2h16(97))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,386),heltab2x32(:,:,386))
  call Hloop_Q_A(ntryL,G0H16(85),16,nML,G1H16(182),n2h16(98))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,387),heltab2x32(:,:,387))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(183),n2h16(99))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,388),heltab2x32(:,:,388))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMT,G1H16(184),n2h16(100))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,389),heltab2x32(:,:,389))
  call Hloop_Q_A(ntryL,G0H16(85),16,0,G1H16(185),n2h16(101))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,390),heltab2x32(:,:,390))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMT,G1H16(186),n2h16(102))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,391),heltab2x32(:,:,391))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(187),n2h16(103))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,392),heltab2x32(:,:,392))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMB,G1H16(188),n2h16(104))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,393),heltab2x32(:,:,393))
  call Hloop_Q_A(ntryL,G0H16(85),16,0,G1H16(189),n2h16(105))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,394),heltab2x32(:,:,394))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMB,G1H16(190),n2h16(106))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,395),heltab2x32(:,:,395))
  call Hloop_A_Q(ntryL,G0H16(85),16,nME,G1H16(191),n2h16(107))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,396),heltab2x32(:,:,396))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMM,G1H16(192),n2h16(108))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,397),heltab2x32(:,:,397))
  call Hloop_A_Q(ntryL,G0H16(85),16,nML,G1H16(193),n2h16(109))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,398),heltab2x32(:,:,398))
  call Hloop_Q_A(ntryL,G0H16(85),16,nME,G1H16(194),n2h16(110))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,399),heltab2x32(:,:,399))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMM,G1H16(195),n2h16(111))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,400),heltab2x32(:,:,400))
  call Hloop_Q_A(ntryL,G0H16(85),16,nML,G1H16(196),n2h16(112))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,401),heltab2x32(:,:,401))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(197),n2h16(113))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,402),heltab2x32(:,:,402))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMT,G1H16(198),n2h16(114))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,403),heltab2x32(:,:,403))
  call Hloop_Q_A(ntryL,G0H16(85),16,0,G1H16(199),n2h16(115))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,404),heltab2x32(:,:,404))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMT,G1H16(200),n2h16(116))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,405),heltab2x32(:,:,405))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(201),n2h16(117))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,406),heltab2x32(:,:,406))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMB,G1H16(202),n2h16(118))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,407),heltab2x32(:,:,407))
  call Hloop_Q_A(ntryL,G0H16(85),16,0,G1H16(203),n2h16(119))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,408),heltab2x32(:,:,408))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMB,G1H16(204),n2h16(120))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(205),m3h2x16(:,409),heltab2x32(:,:,409))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(206),m3h2x16(:,410),heltab2x32(:,:,410))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(207),m3h2x16(:,411),heltab2x32(:,:,411))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(208),m3h2x16(:,412),heltab2x32(:,:,412))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(209),m3h2x16(:,413),heltab2x32(:,:,413))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(210),m3h2x16(:,414),heltab2x32(:,:,414))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(211),m3h2x16(:,415),heltab2x32(:,:,415))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(212),m3h2x16(:,416),heltab2x32(:,:,416))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(213),m3h2x16(:,417),heltab2x32(:,:,417))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(214),m3h2x16(:,418),heltab2x32(:,:,418))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(215),m3h2x16(:,419),heltab2x32(:,:,419))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(216),m3h2x16(:,420),heltab2x32(:,:,420))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(217),m3h2x16(:,421),heltab2x32(:,:,421))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(218),m3h2x16(:,422),heltab2x32(:,:,422))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(219),m3h2x16(:,423),heltab2x32(:,:,423))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(220),m3h2x16(:,424),heltab2x32(:,:,424))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,425),heltab2x32(:,:,425))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,426),heltab2x32(:,:,426))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,427),heltab2x32(:,:,427))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,428),heltab2x32(:,:,428))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,429),heltab2x32(:,:,429))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,430),heltab2x32(:,:,430))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,431),heltab2x32(:,:,431))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,432),heltab2x32(:,:,432))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(221),m3h2x16(:,433),heltab2x32(:,:,433))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(222),m3h2x16(:,434),heltab2x32(:,:,434))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(223),m3h2x16(:,435),heltab2x32(:,:,435))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(224),m3h2x16(:,436),heltab2x32(:,:,436))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(225),m3h2x16(:,437),heltab2x32(:,:,437))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(226),m3h2x16(:,438),heltab2x32(:,:,438))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(227),m3h2x16(:,439),heltab2x32(:,:,439))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(228),m3h2x16(:,440),heltab2x32(:,:,440))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(229),m3h2x16(:,441),heltab2x32(:,:,441))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(230),m3h2x16(:,442),heltab2x32(:,:,442))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(231),m3h2x16(:,443),heltab2x32(:,:,443))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(232),m3h2x16(:,444),heltab2x32(:,:,444))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(93),m3h2x16(:,445),heltab2x32(:,:,445))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(94),m3h2x16(:,446),heltab2x32(:,:,446))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,447),heltab2x32(:,:,447))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,448),heltab2x32(:,:,448))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,449),heltab2x32(:,:,449))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,450),heltab2x32(:,:,450))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,451),heltab2x32(:,:,451))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,452),heltab2x32(:,:,452))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,453),heltab2x32(:,:,453))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,454),heltab2x32(:,:,454))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,455),heltab2x32(:,:,455))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,456),heltab2x32(:,:,456))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(105),m3h2x16(:,457),heltab2x32(:,:,457))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(106),m3h2x16(:,458),heltab2x32(:,:,458))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(107),m3h2x16(:,459),heltab2x32(:,:,459))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(108),m3h2x16(:,460),heltab2x32(:,:,460))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(233),m3h2x16(:,461),heltab2x32(:,:,461))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(234),m3h2x16(:,462),heltab2x32(:,:,462))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(235),m3h2x16(:,463),heltab2x32(:,:,463))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(236),m3h2x16(:,464),heltab2x32(:,:,464))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(237),m3h2x16(:,465),heltab2x32(:,:,465))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(238),m3h2x16(:,466),heltab2x32(:,:,466))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(239),m3h2x16(:,467),heltab2x32(:,:,467))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(240),m3h2x16(:,468),heltab2x32(:,:,468))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(241),m3h2x16(:,469),heltab2x32(:,:,469))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(242),m3h2x16(:,470),heltab2x32(:,:,470))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(243),m3h2x16(:,471),heltab2x32(:,:,471))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(244),m3h2x16(:,472),heltab2x32(:,:,472))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(109),m3h2x16(:,473),heltab2x32(:,:,473))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(110),m3h2x16(:,474),heltab2x32(:,:,474))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(111),m3h2x16(:,475),heltab2x32(:,:,475))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(112),m3h2x16(:,476),heltab2x32(:,:,476))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(113),m3h2x16(:,477),heltab2x32(:,:,477))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(114),m3h2x16(:,478),heltab2x32(:,:,478))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(115),m3h2x16(:,479),heltab2x32(:,:,479))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(116),m3h2x16(:,480),heltab2x32(:,:,480))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,481),heltab2x32(:,:,481))
  call Hloop_Q_A(ntryL,G0H16(117),16,nME,G1H16(245),n2h16(121))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,482),heltab2x32(:,:,482))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMM,G1H16(246),n2h16(122))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,483),heltab2x32(:,:,483))
  call Hloop_Q_A(ntryL,G0H16(117),16,nML,G1H16(247),n2h16(123))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,484),heltab2x32(:,:,484))
  call Hloop_A_Q(ntryL,G0H16(117),16,nME,G1H16(248),n2h16(124))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,485),heltab2x32(:,:,485))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMM,G1H16(249),n2h16(125))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,486),heltab2x32(:,:,486))
  call Hloop_A_Q(ntryL,G0H16(117),16,nML,G1H16(250),n2h16(126))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,487),heltab2x32(:,:,487))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMT,G1H16(251),n2h16(127))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,488),heltab2x32(:,:,488))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMT,G1H16(252),n2h16(128))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,489),heltab2x32(:,:,489))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMB,G1H16(253),n2h16(129))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,490),heltab2x32(:,:,490))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMB,G1H16(254),n2h16(130))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,491),heltab2x32(:,:,491))
  call Hloop_Q_A(ntryL,G0H16(117),16,nME,G1H16(255),n2h16(131))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,492),heltab2x32(:,:,492))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMM,G1H16(256),n2h16(132))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,493),heltab2x32(:,:,493))
  call Hloop_Q_A(ntryL,G0H16(117),16,nML,G1H16(257),n2h16(133))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,494),heltab2x32(:,:,494))
  call Hloop_A_Q(ntryL,G0H16(117),16,nME,G1H16(258),n2h16(134))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,495),heltab2x32(:,:,495))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMM,G1H16(259),n2h16(135))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,496),heltab2x32(:,:,496))
  call Hloop_A_Q(ntryL,G0H16(117),16,nML,G1H16(260),n2h16(136))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,497),heltab2x32(:,:,497))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMT,G1H16(261),n2h16(137))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,498),heltab2x32(:,:,498))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMT,G1H16(262),n2h16(138))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,499),heltab2x32(:,:,499))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMB,G1H16(263),n2h16(139))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,500),heltab2x32(:,:,500))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMB,G1H16(264),n2h16(140))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(265),m3h2x16(:,501),heltab2x32(:,:,501))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(266),m3h2x16(:,502),heltab2x32(:,:,502))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(267),m3h2x16(:,503),heltab2x32(:,:,503))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(268),m3h2x16(:,504),heltab2x32(:,:,504))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(269),m3h2x16(:,505),heltab2x32(:,:,505))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(270),m3h2x16(:,506),heltab2x32(:,:,506))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(271),m3h2x16(:,507),heltab2x32(:,:,507))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(272),m3h2x16(:,508),heltab2x32(:,:,508))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(273),m3h2x16(:,509),heltab2x32(:,:,509))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(274),m3h2x16(:,510),heltab2x32(:,:,510))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(275),m3h2x16(:,511),heltab2x32(:,:,511))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(276),m3h2x16(:,512),heltab2x32(:,:,512))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(277),m3h2x16(:,513),heltab2x32(:,:,513))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(278),m3h2x16(:,514),heltab2x32(:,:,514))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(279),m3h2x16(:,515),heltab2x32(:,:,515))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(280),m3h2x16(:,516),heltab2x32(:,:,516))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,517),heltab2x32(:,:,517))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(118),m3h2x16(:,518),heltab2x32(:,:,518))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(281),m3h2x16(:,519),heltab2x32(:,:,519))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(282),m3h2x16(:,520),heltab2x32(:,:,520))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(283),m3h2x16(:,521),heltab2x32(:,:,521))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(284),m3h2x16(:,522),heltab2x32(:,:,522))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(119),m3h2x16(:,523),heltab2x32(:,:,523))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(120),m3h2x16(:,524),heltab2x32(:,:,524))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(121),m3h2x16(:,525),heltab2x32(:,:,525))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(122),m3h2x16(:,526),heltab2x32(:,:,526))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(123),m3h2x16(:,527),heltab2x32(:,:,527))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(124),m3h2x16(:,528),heltab2x32(:,:,528))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(285),m3h2x16(:,529),heltab2x32(:,:,529))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(286),m3h2x16(:,530),heltab2x32(:,:,530))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(125),m3h2x16(:,531),heltab2x32(:,:,531))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(126),m3h2x16(:,532),heltab2x32(:,:,532))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(127),m3h2x16(:,533),heltab2x32(:,:,533))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(128),m3h2x16(:,534),heltab2x32(:,:,534))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(129),m3h2x16(:,535),heltab2x32(:,:,535))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(130),m3h2x16(:,536),heltab2x32(:,:,536))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(131),m3h2x16(:,537),heltab2x32(:,:,537))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(132),m3h2x16(:,538),heltab2x32(:,:,538))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(287),m3h2x16(:,539),heltab2x32(:,:,539))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(288),m3h2x16(:,540),heltab2x32(:,:,540))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(133),m3h2x16(:,541),heltab2x32(:,:,541))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(134),m3h2x16(:,542),heltab2x32(:,:,542))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(135),m3h2x16(:,543),heltab2x32(:,:,543))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(136),m3h2x16(:,544),heltab2x32(:,:,544))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(137),m3h2x16(:,545),heltab2x32(:,:,545))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(138),m3h2x16(:,546),heltab2x32(:,:,546))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(289),m3h2x16(:,547),heltab2x32(:,:,547))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(290),m3h2x16(:,548),heltab2x32(:,:,548))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(291),m3h2x16(:,549),heltab2x32(:,:,549))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(292),m3h2x16(:,550),heltab2x32(:,:,550))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(139),m3h2x16(:,551),heltab2x32(:,:,551))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(140),m3h2x16(:,552),heltab2x32(:,:,552))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(293),m3h2x16(:,553),heltab2x32(:,:,553))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(294),m3h2x16(:,554),heltab2x32(:,:,554))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(295),m3h2x16(:,555),heltab2x32(:,:,555))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(296),m3h2x16(:,556),heltab2x32(:,:,556))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,557),heltab2x32(:,:,557))
  call Hloop_Q_A(ntryL,G0H16(141),16,nME,G1H16(297),n2h16(141))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,558),heltab2x32(:,:,558))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMM,G1H16(298),n2h16(142))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,559),heltab2x32(:,:,559))
  call Hloop_Q_A(ntryL,G0H16(141),16,nML,G1H16(299),n2h16(143))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,560),heltab2x32(:,:,560))
  call Hloop_A_Q(ntryL,G0H16(141),16,nME,G1H16(300),n2h16(144))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,561),heltab2x32(:,:,561))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMM,G1H16(301),n2h16(145))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,562),heltab2x32(:,:,562))
  call Hloop_A_Q(ntryL,G0H16(141),16,nML,G1H16(302),n2h16(146))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,563),heltab2x32(:,:,563))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(303),n2h16(147))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,564),heltab2x32(:,:,564))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMT,G1H16(304),n2h16(148))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,565),heltab2x32(:,:,565))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(305),n2h16(149))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,566),heltab2x32(:,:,566))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMT,G1H16(306),n2h16(150))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,567),heltab2x32(:,:,567))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(307),n2h16(151))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,568),heltab2x32(:,:,568))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMB,G1H16(308),n2h16(152))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,569),heltab2x32(:,:,569))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(309),n2h16(153))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,570),heltab2x32(:,:,570))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMB,G1H16(310),n2h16(154))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,571),heltab2x32(:,:,571))
  call Hloop_Q_A(ntryL,G0H16(141),16,nME,G1H16(311),n2h16(155))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,572),heltab2x32(:,:,572))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMM,G1H16(312),n2h16(156))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,573),heltab2x32(:,:,573))
  call Hloop_Q_A(ntryL,G0H16(141),16,nML,G1H16(313),n2h16(157))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,574),heltab2x32(:,:,574))
  call Hloop_A_Q(ntryL,G0H16(141),16,nME,G1H16(314),n2h16(158))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,575),heltab2x32(:,:,575))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMM,G1H16(315),n2h16(159))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,576),heltab2x32(:,:,576))
  call Hloop_A_Q(ntryL,G0H16(141),16,nML,G1H16(316),n2h16(160))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,577),heltab2x32(:,:,577))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(317),n2h16(161))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,578),heltab2x32(:,:,578))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMT,G1H16(318),n2h16(162))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,579),heltab2x32(:,:,579))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(319),n2h16(163))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,580),heltab2x32(:,:,580))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMT,G1H16(320),n2h16(164))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,581),heltab2x32(:,:,581))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(321),n2h16(165))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,582),heltab2x32(:,:,582))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMB,G1H16(322),n2h16(166))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,583),heltab2x32(:,:,583))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(323),n2h16(167))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,584),heltab2x32(:,:,584))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMB,G1H16(324),n2h16(168))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(325),m3h2x16(:,585),heltab2x32(:,:,585))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(326),m3h2x16(:,586),heltab2x32(:,:,586))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(327),m3h2x16(:,587),heltab2x32(:,:,587))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(328),m3h2x16(:,588),heltab2x32(:,:,588))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(329),m3h2x16(:,589),heltab2x32(:,:,589))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(330),m3h2x16(:,590),heltab2x32(:,:,590))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(331),m3h2x16(:,591),heltab2x32(:,:,591))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(332),m3h2x16(:,592),heltab2x32(:,:,592))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(333),m3h2x16(:,593),heltab2x32(:,:,593))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(334),m3h2x16(:,594),heltab2x32(:,:,594))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(335),m3h2x16(:,595),heltab2x32(:,:,595))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(336),m3h2x16(:,596),heltab2x32(:,:,596))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(337),m3h2x16(:,597),heltab2x32(:,:,597))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(338),m3h2x16(:,598),heltab2x32(:,:,598))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(339),m3h2x16(:,599),heltab2x32(:,:,599))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(340),m3h2x16(:,600),heltab2x32(:,:,600))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(341),m3h2x16(:,601),heltab2x32(:,:,601))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(342),m3h2x16(:,602),heltab2x32(:,:,602))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(343),m3h2x16(:,603),heltab2x32(:,:,603))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(344),m3h2x16(:,604),heltab2x32(:,:,604))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,605),heltab2x32(:,:,605))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(142),m3h2x16(:,606),heltab2x32(:,:,606))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(143),m3h2x16(:,607),heltab2x32(:,:,607))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(144),m3h2x16(:,608),heltab2x32(:,:,608))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(345),m3h2x16(:,609),heltab2x32(:,:,609))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(346),m3h2x16(:,610),heltab2x32(:,:,610))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(627),h0tab(:,627),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(347),m3h2x16(:,611),heltab2x32(:,:,611))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(628),h0tab(:,628),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(348),m3h2x16(:,612),heltab2x32(:,:,612))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(629),h0tab(:,629),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(145),m3h2x16(:,613),heltab2x32(:,:,613))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(630),h0tab(:,630),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(146),m3h2x16(:,614),heltab2x32(:,:,614))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(631),h0tab(:,631),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(147),m3h2x16(:,615),heltab2x32(:,:,615))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(632),h0tab(:,632),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(148),m3h2x16(:,616),heltab2x32(:,:,616))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(633),h0tab(:,633),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(149),m3h2x16(:,617),heltab2x32(:,:,617))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(634),h0tab(:,634),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(150),m3h2x16(:,618),heltab2x32(:,:,618))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(635),h0tab(:,635),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(151),m3h2x16(:,619),heltab2x32(:,:,619))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(636),h0tab(:,636),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(152),m3h2x16(:,620),heltab2x32(:,:,620))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(637),h0tab(:,637),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(349),m3h2x16(:,621),heltab2x32(:,:,621))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(638),h0tab(:,638),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(350),m3h2x16(:,622),heltab2x32(:,:,622))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(639),h0tab(:,639),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(351),m3h2x16(:,623),heltab2x32(:,:,623))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(640),h0tab(:,640),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(352),m3h2x16(:,624),heltab2x32(:,:,624))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(641),h0tab(:,641),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(153),m3h2x16(:,625),heltab2x32(:,:,625))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(642),h0tab(:,642),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(154),m3h2x16(:,626),heltab2x32(:,:,626))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(643),h0tab(:,643),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(155),m3h2x16(:,627),heltab2x32(:,:,627))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(644),h0tab(:,644),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(156),m3h2x16(:,628),heltab2x32(:,:,628))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(645),h0tab(:,645),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(157),m3h2x16(:,629),heltab2x32(:,:,629))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(646),h0tab(:,646),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(158),m3h2x16(:,630),heltab2x32(:,:,630))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(647),h0tab(:,647),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(159),m3h2x16(:,631),heltab2x32(:,:,631))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(648),h0tab(:,648),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(160),m3h2x16(:,632),heltab2x32(:,:,632))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(649),h0tab(:,649),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(353),m3h2x16(:,633),heltab2x32(:,:,633))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(650),h0tab(:,650),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(354),m3h2x16(:,634),heltab2x32(:,:,634))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(651),h0tab(:,651),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(355),m3h2x16(:,635),heltab2x32(:,:,635))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(652),h0tab(:,652),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(356),m3h2x16(:,636),heltab2x32(:,:,636))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(653),h0tab(:,653),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(161),m3h2x16(:,637),heltab2x32(:,:,637))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(654),h0tab(:,654),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(162),m3h2x16(:,638),heltab2x32(:,:,638))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(655),h0tab(:,655),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(163),m3h2x16(:,639),heltab2x32(:,:,639))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(656),h0tab(:,656),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(164),m3h2x16(:,640),heltab2x32(:,:,640))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(657),h0tab(:,657),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(165),m3h2x16(:,641),heltab2x32(:,:,641))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(658),h0tab(:,658),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(166),m3h2x16(:,642),heltab2x32(:,:,642))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(659),h0tab(:,659),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(167),m3h2x16(:,643),heltab2x32(:,:,643))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(660),h0tab(:,660),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(168),m3h2x16(:,644),heltab2x32(:,:,644))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(661),h0tab(:,661),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(357),m3h2x16(:,645),heltab2x32(:,:,645))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(662),h0tab(:,662),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(358),m3h2x16(:,646),heltab2x32(:,:,646))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(663),h0tab(:,663),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(359),m3h2x16(:,647),heltab2x32(:,:,647))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(664),h0tab(:,664),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(360),m3h2x16(:,648),heltab2x32(:,:,648))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(665),h0tab(:,665),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(169),m3h2x16(:,649),heltab2x32(:,:,649))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(666),h0tab(:,666),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(170),m3h2x16(:,650),heltab2x32(:,:,650))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(667),h0tab(:,667),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(171),m3h2x16(:,651),heltab2x32(:,:,651))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(668),h0tab(:,668),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(172),m3h2x16(:,652),heltab2x32(:,:,652))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(669),h0tab(:,669),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(361),m3h2x16(:,653),heltab2x32(:,:,653))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(670),h0tab(:,670),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(362),m3h2x16(:,654),heltab2x32(:,:,654))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(671),h0tab(:,671),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(363),m3h2x16(:,655),heltab2x32(:,:,655))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(672),h0tab(:,672),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(364),m3h2x16(:,656),heltab2x32(:,:,656))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(673),h0tab(:,673),[16,5,2,8],[nML,nMH,nML,nML],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,657),heltab2x32(:,:,657))
  call Hloop_A_Q(ntryL,G0H16(173),16,nML,G1H16(365),n2h16(169))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(674),h0tab(:,674),[16,5,2,8],[nML,nMZ,nML,nML],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,658),heltab2x32(:,:,658))
  call Hloop_A_Q(ntryL,G0H16(173),16,nML,G1H16(366),n2h16(170))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(675),h0tab(:,675),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(367),m3h2x16(:,659),heltab2x32(:,:,659))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(676),h0tab(:,676),[16,5,2,8],[nML,0,nML,nML],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,660),heltab2x32(:,:,660))
  call Hloop_A_Q(ntryL,G0H16(173),16,nML,G1H16(368),n2h16(171))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(677),h0tab(:,677),[16,5,2,8],[nML,nMZ,nML,nML],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,661),heltab2x32(:,:,661))
  call Hloop_A_Q(ntryL,G0H16(173),16,nML,G1H16(369),n2h16(172))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(678),h0tab(:,678),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,662),heltab2x32(:,:,662))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(679),h0tab(:,679),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(174),m3h2x16(:,663),heltab2x32(:,:,663))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(680),h0tab(:,680),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(370),m3h2x16(:,664),heltab2x32(:,:,664))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(681),h0tab(:,681),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(371),m3h2x16(:,665),heltab2x32(:,:,665))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(682),h0tab(:,682),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,666),heltab2x32(:,:,666))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(683),h0tab(:,683),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(176),m3h2x16(:,667),heltab2x32(:,:,667))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(684),h0tab(:,684),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(372),m3h2x16(:,668),heltab2x32(:,:,668))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(685),h0tab(:,685),[16,2,5,8],[nML,nMH,nML,nML],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,669),heltab2x32(:,:,669))
  call Hloop_Q_A(ntryL,G0H16(177),16,nML,G1H16(373),n2h16(173))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(686),h0tab(:,686),[16,2,5,8],[nML,nMZ,nML,nML],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,670),heltab2x32(:,:,670))
  call Hloop_Q_A(ntryL,G0H16(177),16,nML,G1H16(374),n2h16(174))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(687),h0tab(:,687),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(375),m3h2x16(:,671),heltab2x32(:,:,671))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(688),h0tab(:,688),[16,2,5,8],[nML,0,nML,nML],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,672),heltab2x32(:,:,672))
  call Hloop_Q_A(ntryL,G0H16(177),16,nML,G1H16(376),n2h16(175))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(689),h0tab(:,689),[16,2,5,8],[nML,nMZ,nML,nML],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,673),heltab2x32(:,:,673))
  call Hloop_Q_A(ntryL,G0H16(177),16,nML,G1H16(377),n2h16(176))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(690),h0tab(:,690),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(378),m3h2x16(:,674),heltab2x32(:,:,674))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(691),h0tab(:,691),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,675),heltab2x32(:,:,675))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(692),h0tab(:,692),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(178),m3h2x16(:,676),heltab2x32(:,:,676))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(693),h0tab(:,693),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,677),heltab2x32(:,:,677))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(694),h0tab(:,694),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(180),m3h2x16(:,678),heltab2x32(:,:,678))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(695),h0tab(:,695),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(379),m3h2x16(:,679),heltab2x32(:,:,679))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(696),h0tab(:,696),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(380),m3h2x16(:,680),heltab2x32(:,:,680))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(697),h0tab(:,697),[16,6,1,8],[nML,nMH,nML,nML],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,681),heltab2x32(:,:,681))
  call Hloop_Q_A(ntryL,G0H16(181),16,nML,G1H16(381),n2h16(177))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(698),h0tab(:,698),[16,6,1,8],[nML,nMZ,nML,nML],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,682),heltab2x32(:,:,682))
  call Hloop_Q_A(ntryL,G0H16(181),16,nML,G1H16(382),n2h16(178))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(699),h0tab(:,699),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(383),m3h2x16(:,683),heltab2x32(:,:,683))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(700),h0tab(:,700),[16,6,1,8],[nML,0,nML,nML],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,684),heltab2x32(:,:,684))
  call Hloop_Q_A(ntryL,G0H16(181),16,nML,G1H16(384),n2h16(179))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(701),h0tab(:,701),[16,6,1,8],[nML,nMZ,nML,nML],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,685),heltab2x32(:,:,685))
  call Hloop_Q_A(ntryL,G0H16(181),16,nML,G1H16(385),n2h16(180))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(702),h0tab(:,702),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,686),heltab2x32(:,:,686))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(703),h0tab(:,703),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(182),m3h2x16(:,687),heltab2x32(:,:,687))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(704),h0tab(:,704),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(386),m3h2x16(:,688),heltab2x32(:,:,688))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(705),h0tab(:,705),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(387),m3h2x16(:,689),heltab2x32(:,:,689))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(706),h0tab(:,706),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(183),m3h2x16(:,690),heltab2x32(:,:,690))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(707),h0tab(:,707),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(184),m3h2x16(:,691),heltab2x32(:,:,691))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(708),h0tab(:,708),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(388),m3h2x16(:,692),heltab2x32(:,:,692))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(709),h0tab(:,709),[16,1,6,8],[nML,nMH,nML,nML],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,693),heltab2x32(:,:,693))
  call Hloop_A_Q(ntryL,G0H16(185),16,nML,G1H16(389),n2h16(181))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(710),h0tab(:,710),[16,1,6,8],[nML,nMZ,nML,nML],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,694),heltab2x32(:,:,694))
  call Hloop_A_Q(ntryL,G0H16(185),16,nML,G1H16(390),n2h16(182))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(711),h0tab(:,711),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(391),m3h2x16(:,695),heltab2x32(:,:,695))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(712),h0tab(:,712),[16,1,6,8],[nML,0,nML,nML],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,696),heltab2x32(:,:,696))
  call Hloop_A_Q(ntryL,G0H16(185),16,nML,G1H16(392),n2h16(183))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(713),h0tab(:,713),[16,1,6,8],[nML,nMZ,nML,nML],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,697),heltab2x32(:,:,697))
  call Hloop_A_Q(ntryL,G0H16(185),16,nML,G1H16(393),n2h16(184))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(714),h0tab(:,714),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(394),m3h2x16(:,698),heltab2x32(:,:,698))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(715),h0tab(:,715),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,699),heltab2x32(:,:,699))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(716),h0tab(:,716),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(186),m3h2x16(:,700),heltab2x32(:,:,700))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(717),h0tab(:,717),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(187),m3h2x16(:,701),heltab2x32(:,:,701))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(718),h0tab(:,718),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(188),m3h2x16(:,702),heltab2x32(:,:,702))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(719),h0tab(:,719),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(395),m3h2x16(:,703),heltab2x32(:,:,703))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(720),h0tab(:,720),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(396),m3h2x16(:,704),heltab2x32(:,:,704))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(721),h0tab(:,721),[16,4,2,9],[nML,nML,nMH,nML],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,705),heltab2x32(:,:,705))
  call Hloop_Q_A(ntryL,G0H16(189),16,nML,G1H16(397),n2h16(185))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(722),h0tab(:,722),[16,4,2,9],[nML,nML,nMZ,nML],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,706),heltab2x32(:,:,706))
  call Hloop_Q_A(ntryL,G0H16(189),16,nML,G1H16(398),n2h16(186))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(723),h0tab(:,723),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(399),m3h2x16(:,707),heltab2x32(:,:,707))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(724),h0tab(:,724),[16,4,2,9],[nML,nML,0,nML],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,708),heltab2x32(:,:,708))
  call Hloop_Q_A(ntryL,G0H16(189),16,nML,G1H16(400),n2h16(187))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(725),h0tab(:,725),[16,4,2,9],[nML,nML,nMZ,nML],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,709),heltab2x32(:,:,709))
  call Hloop_Q_A(ntryL,G0H16(189),16,nML,G1H16(401),n2h16(188))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(726),h0tab(:,726),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,710),heltab2x32(:,:,710))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(727),h0tab(:,727),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(190),m3h2x16(:,711),heltab2x32(:,:,711))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(728),h0tab(:,728),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(402),m3h2x16(:,712),heltab2x32(:,:,712))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(729),h0tab(:,729),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(403),m3h2x16(:,713),heltab2x32(:,:,713))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(730),h0tab(:,730),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(191),m3h2x16(:,714),heltab2x32(:,:,714))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(731),h0tab(:,731),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(192),m3h2x16(:,715),heltab2x32(:,:,715))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(732),h0tab(:,732),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(404),m3h2x16(:,716),heltab2x32(:,:,716))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(733),h0tab(:,733),[16,2,9,4],[nML,nMH,nML,nML],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,717),heltab2x32(:,:,717))
  call Hloop_Q_A(ntryL,G0H16(193),16,nML,G1H16(405),n2h16(189))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(734),h0tab(:,734),[16,2,9,4],[nML,nMZ,nML,nML],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,718),heltab2x32(:,:,718))
  call Hloop_Q_A(ntryL,G0H16(193),16,nML,G1H16(406),n2h16(190))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(735),h0tab(:,735),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(407),m3h2x16(:,719),heltab2x32(:,:,719))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(736),h0tab(:,736),[16,2,9,4],[nML,0,nML,nML],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,720),heltab2x32(:,:,720))
  call Hloop_Q_A(ntryL,G0H16(193),16,nML,G1H16(408),n2h16(191))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(737),h0tab(:,737),[16,2,9,4],[nML,nMZ,nML,nML],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,721),heltab2x32(:,:,721))
  call Hloop_Q_A(ntryL,G0H16(193),16,nML,G1H16(409),n2h16(192))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(738),h0tab(:,738),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(410),m3h2x16(:,722),heltab2x32(:,:,722))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(739),h0tab(:,739),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,723),heltab2x32(:,:,723))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(740),h0tab(:,740),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(194),m3h2x16(:,724),heltab2x32(:,:,724))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(741),h0tab(:,741),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,725),heltab2x32(:,:,725))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(742),h0tab(:,742),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(196),m3h2x16(:,726),heltab2x32(:,:,726))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(743),h0tab(:,743),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(411),m3h2x16(:,727),heltab2x32(:,:,727))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(744),h0tab(:,744),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(412),m3h2x16(:,728),heltab2x32(:,:,728))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(745),h0tab(:,745),[16,4,1,10],[nML,nML,nMH,nML],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,729),heltab2x32(:,:,729))
  call Hloop_A_Q(ntryL,G0H16(197),16,nML,G1H16(413),n2h16(193))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(746),h0tab(:,746),[16,4,1,10],[nML,nML,nMZ,nML],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,730),heltab2x32(:,:,730))
  call Hloop_A_Q(ntryL,G0H16(197),16,nML,G1H16(414),n2h16(194))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(747),h0tab(:,747),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(415),m3h2x16(:,731),heltab2x32(:,:,731))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(748),h0tab(:,748),[16,4,1,10],[nML,nML,0,nML],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,732),heltab2x32(:,:,732))
  call Hloop_A_Q(ntryL,G0H16(197),16,nML,G1H16(416),n2h16(195))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(749),h0tab(:,749),[16,4,1,10],[nML,nML,nMZ,nML],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,733),heltab2x32(:,:,733))
  call Hloop_A_Q(ntryL,G0H16(197),16,nML,G1H16(417),n2h16(196))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(750),h0tab(:,750),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,734),heltab2x32(:,:,734))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(751),h0tab(:,751),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(198),m3h2x16(:,735),heltab2x32(:,:,735))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(752),h0tab(:,752),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(418),m3h2x16(:,736),heltab2x32(:,:,736))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(753),h0tab(:,753),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(419),m3h2x16(:,737),heltab2x32(:,:,737))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(754),h0tab(:,754),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,738),heltab2x32(:,:,738))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(755),h0tab(:,755),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(200),m3h2x16(:,739),heltab2x32(:,:,739))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(756),h0tab(:,756),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(420),m3h2x16(:,740),heltab2x32(:,:,740))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(757),h0tab(:,757),[16,1,10,4],[nML,nMH,nML,nML],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,741),heltab2x32(:,:,741))
  call Hloop_A_Q(ntryL,G0H16(201),16,nML,G1H16(421),n2h16(197))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(758),h0tab(:,758),[16,1,10,4],[nML,nMZ,nML,nML],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,742),heltab2x32(:,:,742))
  call Hloop_A_Q(ntryL,G0H16(201),16,nML,G1H16(422),n2h16(198))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(759),h0tab(:,759),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(423),m3h2x16(:,743),heltab2x32(:,:,743))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(760),h0tab(:,760),[16,1,10,4],[nML,0,nML,nML],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,744),heltab2x32(:,:,744))
  call Hloop_A_Q(ntryL,G0H16(201),16,nML,G1H16(424),n2h16(199))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(761),h0tab(:,761),[16,1,10,4],[nML,nMZ,nML,nML],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,745),heltab2x32(:,:,745))
  call Hloop_A_Q(ntryL,G0H16(201),16,nML,G1H16(425),n2h16(200))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(762),h0tab(:,762),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(426),m3h2x16(:,746),heltab2x32(:,:,746))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(763),h0tab(:,763),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,747),heltab2x32(:,:,747))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(764),h0tab(:,764),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(202),m3h2x16(:,748),heltab2x32(:,:,748))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(765),h0tab(:,765),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(203),m3h2x16(:,749),heltab2x32(:,:,749))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(766),h0tab(:,766),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(204),m3h2x16(:,750),heltab2x32(:,:,750))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(767),h0tab(:,767),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(427),m3h2x16(:,751),heltab2x32(:,:,751))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(768),h0tab(:,768),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(428),m3h2x16(:,752),heltab2x32(:,:,752))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(769),h0tab(:,769),[17,2,4,8],[nMH,nML,nML,nML],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(17),ngH,m3h4x8(:,1),heltab2x32(:,:,753))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(770),h0tab(:,770),[17,2,4,8],[nMZ,nML,nML,nML],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(18),ngX,m3h4x8(:,2),heltab2x32(:,:,754))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(771),h0tab(:,771),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(19),ngPnl,m3h4x8(:,3),heltab2x32(:,:,755))
  call Hloop_Q_A(ntryL,G0H8(19),17,0,G1H8(12),n2h8(81))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(772),h0tab(:,772),[17,2,4,8],[0,nML,nML,nML],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(19),m3h4x8(:,4),heltab2x32(:,:,756))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(773),h0tab(:,773),[17,2,4,8],[nMZ,nML,nML,nML],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(20),ngZl,m3h4x8(:,5),heltab2x32(:,:,757))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(774),h0tab(:,774),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,6),heltab2x32(:,:,758))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(23),n2h8(82))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(775),h0tab(:,775),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngPnl,m3h4x8(:,7),heltab2x32(:,:,759))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(24),n2h8(83))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(776),h0tab(:,776),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngPnl,m3h4x8(:,8),heltab2x32(:,:,760))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(27),n2h8(84))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(777),h0tab(:,777),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,9),heltab2x32(:,:,761))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(28),n2h8(85))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(778),h0tab(:,778),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,10),heltab2x32(:,:,762))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(29),n2h8(86))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(779),h0tab(:,779),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngPnl,m3h4x8(:,11),heltab2x32(:,:,763))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(30),n2h8(87))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(780),h0tab(:,780),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,12),heltab2x32(:,:,764))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(31),n2h8(88))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(781),h0tab(:,781),[17,2,8,4],[nMH,nML,nML,nML],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngH,m3h4x8(:,13),heltab2x32(:,:,765))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(782),h0tab(:,782),[17,2,8,4],[nMZ,nML,nML,nML],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(22),ngX,m3h4x8(:,14),heltab2x32(:,:,766))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(783),h0tab(:,783),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(23),ngPnl,m3h4x8(:,15),heltab2x32(:,:,767))
  call Hloop_Q_A(ntryL,G0H8(23),17,0,G1H8(32),n2h8(89))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(784),h0tab(:,784),[17,2,8,4],[0,nML,nML,nML],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(23),m3h4x8(:,16),heltab2x32(:,:,768))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(785),h0tab(:,785),[17,2,8,4],[nMZ,nML,nML,nML],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(24),ngZl,m3h4x8(:,17),heltab2x32(:,:,769))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(786),h0tab(:,786),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),m3h4x8(:,18),heltab2x32(:,:,770))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(41),n2h8(90))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(787),h0tab(:,787),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),ngPnl,m3h4x8(:,19),heltab2x32(:,:,771))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(42),n2h8(91))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(788),h0tab(:,788),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),ngPnl,m3h4x8(:,20),heltab2x32(:,:,772))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(43),n2h8(92))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(789),h0tab(:,789),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),m3h4x8(:,21),heltab2x32(:,:,773))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(44),n2h8(93))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(790),h0tab(:,790),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),m3h4x8(:,22),heltab2x32(:,:,774))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(53),n2h8(94))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(791),h0tab(:,791),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),ngPnl,m3h4x8(:,23),heltab2x32(:,:,775))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(54),n2h8(95))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(792),h0tab(:,792),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),m3h4x8(:,24),heltab2x32(:,:,776))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(55),n2h8(96))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(793),h0tab(:,793),[18,1,4,8],[nMH,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(25),ngH,m3h4x8(:,25),heltab2x32(:,:,777))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(794),h0tab(:,794),[18,1,4,8],[nMZ,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(26),ngX,m3h4x8(:,26),heltab2x32(:,:,778))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(795),h0tab(:,795),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(27),ngPln,m3h4x8(:,27),heltab2x32(:,:,779))
  call Hloop_A_Q(ntryL,G0H8(27),18,0,G1H8(56),n2h8(97))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(796),h0tab(:,796),[18,1,4,8],[0,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(27),m3h4x8(:,28),heltab2x32(:,:,780))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(797),h0tab(:,797),[18,1,4,8],[nMZ,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(28),ngZl,m3h4x8(:,29),heltab2x32(:,:,781))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(798),h0tab(:,798),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,30),heltab2x32(:,:,782))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(65),n2h8(98))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(799),h0tab(:,799),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngPln,m3h4x8(:,31),heltab2x32(:,:,783))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(1),n2h8(99))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(800),h0tab(:,800),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngPln,m3h4x8(:,32),heltab2x32(:,:,784))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(4),n2h8(100))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(801),h0tab(:,801),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,33),heltab2x32(:,:,785))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(6),n2h8(101))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(802),h0tab(:,802),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,34),heltab2x32(:,:,786))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(14),n2h8(102))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(803),h0tab(:,803),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngPln,m3h4x8(:,35),heltab2x32(:,:,787))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(13),n2h8(103))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(804),h0tab(:,804),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,36),heltab2x32(:,:,788))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(16),n2h8(104))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(805),h0tab(:,805),[18,1,8,4],[nMH,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngH,m3h4x8(:,37),heltab2x32(:,:,789))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(806),h0tab(:,806),[18,1,8,4],[nMZ,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(30),ngX,m3h4x8(:,38),heltab2x32(:,:,790))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(807),h0tab(:,807),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(31),ngPln,m3h4x8(:,39),heltab2x32(:,:,791))
  call Hloop_A_Q(ntryL,G0H8(31),18,0,G1H8(15),n2h8(105))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(808),h0tab(:,808),[18,1,8,4],[0,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(31),m3h4x8(:,40),heltab2x32(:,:,792))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(809),h0tab(:,809),[18,1,8,4],[nMZ,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(32),ngZl,m3h4x8(:,41),heltab2x32(:,:,793))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(810),h0tab(:,810),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,42),heltab2x32(:,:,794))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(17),n2h8(106))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(811),h0tab(:,811),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),ngPln,m3h4x8(:,43),heltab2x32(:,:,795))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(20),n2h8(107))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(812),h0tab(:,812),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),ngPln,m3h4x8(:,44),heltab2x32(:,:,796))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(19),n2h8(108))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(813),h0tab(:,813),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,45),heltab2x32(:,:,797))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(21),n2h8(109))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(814),h0tab(:,814),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,46),heltab2x32(:,:,798))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(25),n2h8(110))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(815),h0tab(:,815),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),ngPln,m3h4x8(:,47),heltab2x32(:,:,799))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(26),n2h8(111))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(816),h0tab(:,816),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,48),heltab2x32(:,:,800))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(34),n2h8(112))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(51),[G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(33),[G1H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(34),[G0H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(36),[G0H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(38),[G0H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(40),[G0H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G1H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(67),[G1H16(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(69),[G1H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(91),[G1H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(92),[G1H16(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(95),[G1H16(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(96),[G1H16(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(6),[G0H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(8),[G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(10),[G0H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(12),[G0H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(149),[G1H16(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(150),[G1H16(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(153),[G1H16(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(154),[G1H16(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(162),[G1H16(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(70),[G0H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(72),[G0H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(74),[G0H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(76),[G0H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(172),[G1H16(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(187),[G1H16(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(189),[G1H16(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(211),[G1H16(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(212),[G1H16(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(215),[G1H16(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(216),[G1H16(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(98),[G0H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(100),[G0H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(102),[G0H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(104),[G0H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(269),[G1H16(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(270),[G1H16(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(273),[G1H16(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(274),[G1H16(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(286),[G1H16(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(126),[G0H16(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(128),[G0H16(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(130),[G0H16(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(132),[G0H16(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(288),[G1H16(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(307),[G1H16(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(309),[G1H16(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(331),[G1H16(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(332),[G1H16(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(335),[G1H16(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(336),[G1H16(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(154),[G0H16(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(156),[G0H16(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(158),[G0H16(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(160),[G0H16(159)])
  call Hloop_SQ_A(ntryL,G1H8(2),ex1(:),G1H4(5),ngPnl,m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(5),21,0,G2H4(9),n2h4(93))
  call Hloop_SQ_A(ntryL,G1H8(18),ex1(:),G1H4(6),ngPnl,m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(6),21,0,G2H4(13),n2h4(94))
  call Hloop_WQ_A(ntryL,G1H8(22),ex1(:),G1H4(9),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(11),n2h4(95))
  call Hloop_WQ_A(ntryL,G1H8(38),ex1(:),G1H4(10),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(10),21,0,G2H4(12),n2h4(96))
  call Hloop_SA_Q(ntryL,G1H8(45),ex2(:),G1H4(11),ngPln,m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(11),22,0,G2H4(14),n2h4(97))
  call Hloop_SA_Q(ntryL,G1H8(51),ex2(:),G1H4(12),ngPln,m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(12),22,0,G2H4(15),n2h4(98))
  call Hloop_WA_Q(ntryL,G1H8(60),ex2(:),G1H4(15),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(15),22,0,G2H4(16),n2h4(99))
  call Hloop_WA_Q(ntryL,G1H8(8),ex2(:),G1H4(16),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(16),22,0,G2H4(17),n2h4(100))
  call Hloop_SA_Q(ntryL,G0H8(9),ex2(:),G0H4(1),ngPln,m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(17),n2h4(101))
  call Hloop_SA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),ngPln,m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(18),n2h4(102))
  call Hloop_WA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(21),n2h4(103))
  call Hloop_WA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(22),n2h4(104))
  call Hloop_SQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),ngPnl,m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(23),n2h4(105))
  call Hloop_SQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),ngPnl,m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(24),n2h4(106))
  call Hloop_WQ_A(ntryL,G0H8(7),ex1(:),G0H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(27),n2h4(107))
  call Hloop_WQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(28),n2h4(108))
  call Hloop_SQ_A(ntryL,G1H16(1),ex1(:),G1H8(33),ngPnl,m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G1H8(33),17,0,G2H8(1),n2h8(113))
  call Hloop_WQ_A(ntryL,G0H16(1),ex1(:),G0H8(33),m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G0H8(33),17,0,G1H8(36),n2h8(114))
  call Hloop_SQ_A(ntryL,G0H16(2),ex1(:),G0H8(13),ngPnl,m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G0H8(13),17,0,G1H8(35),n2h8(115))
  call Hloop_WQ_A(ntryL,G1H16(2),ex1(:),G1H8(37),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(37),17,0,G2H8(2),n2h8(116))
  call Hloop_SA_Q(ntryL,G1H16(3),ex2(:),G1H8(40),ngPln,m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(40),18,0,G2H8(3),n2h8(117))
  call Hloop_WA_Q(ntryL,G0H16(3),ex2(:),G0H8(14),m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G0H8(14),18,0,G1H8(39),n2h8(118))
  call Hloop_SA_Q(ntryL,G0H16(4),ex2(:),G0H8(15),ngPln,m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G0H8(15),18,0,G1H8(46),n2h8(119))
  call Hloop_WA_Q(ntryL,G1H16(4),ex2(:),G1H8(49),m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(49),18,0,G2H8(4),n2h8(120))
  call Hloop_QS_A(ntryL,G1H16(5),wf4(:,36),G1H4(29),ngH,m3h4x4(:,1),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(29),19,nME,G2H4(18),n2h4(109))
  call Hloop_QS_A(ntryL,G1H16(6),wf4(:,36),G1H4(30),ngH,m3h4x4(:,2),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(30),19,nMM,G2H4(19),n2h4(110))
  call Hloop_QS_A(ntryL,G1H16(7),wf4(:,36),G1H4(33),ngH,m3h4x4(:,3),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(33),19,nML,G2H4(20),n2h4(111))
  call Hloop_AS_Q(ntryL,G1H16(8),wf4(:,36),G1H4(34),ngH,m3h4x4(:,4),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(34),19,nME,G2H4(21),n2h4(112))
  call Hloop_AS_Q(ntryL,G1H16(9),wf4(:,36),G1H4(35),ngH,m3h4x4(:,5),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(35),19,nMM,G2H4(22),n2h4(113))
  call Hloop_AS_Q(ntryL,G1H16(10),wf4(:,36),G1H4(36),ngH,m3h4x4(:,6),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(36),19,nML,G2H4(23),n2h4(114))
  call Hloop_QS_A(ntryL,G1H16(11),wf4(:,36),G1H4(39),ngH,m3h4x4(:,7),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(39),19,nMT,G2H4(24),n2h4(115))
  call Hloop_AS_Q(ntryL,G1H16(12),wf4(:,36),G1H4(40),ngH,m3h4x4(:,8),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(40),19,nMT,G2H4(92),n2h4(116))
  call Hloop_QS_A(ntryL,G1H16(13),wf4(:,36),G1H4(41),ngH,m3h4x4(:,9),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(41),19,nMB,G2H4(83),n2h4(117))
  call Hloop_AS_Q(ntryL,G1H16(14),wf4(:,36),G1H4(42),ngH,m3h4x4(:,10),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(42),19,nMB,G2H4(96),n2h4(118))
  call Hloop_QS_A(ntryL,G1H16(15),wf4(:,37),G1H4(45),ngX,m3h4x4(:,11),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(45),19,nME,G2H4(88),n2h4(119))
  call Hloop_QS_A(ntryL,G1H16(16),wf4(:,37),G1H4(46),ngX,m3h4x4(:,12),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(46),19,nMM,G2H4(29),n2h4(120))
  call Hloop_QS_A(ntryL,G1H16(17),wf4(:,37),G1H4(47),ngX,m3h4x4(:,13),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(47),19,nML,G2H4(33),n2h4(121))
  call Hloop_AS_Q(ntryL,G1H16(18),wf4(:,37),G1H4(48),ngX,m3h4x4(:,14),heltab2x16(:,:,142))
  call Hloop_A_Q(ntryL,G1H4(48),19,nME,G2H4(31),n2h4(122))
  call Hloop_AS_Q(ntryL,G1H16(19),wf4(:,37),G1H4(51),ngX,m3h4x4(:,15),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(51),19,nMM,G2H4(32),n2h4(123))
  call Hloop_AS_Q(ntryL,G1H16(20),wf4(:,37),G1H4(52),ngX,m3h4x4(:,16),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(52),19,nML,G2H4(34),n2h4(124))
  call Hloop_QS_A(ntryL,G1H16(21),wf4(:,37),G1H4(53),ngX,m3h4x4(:,17),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(53),19,nMT,G2H4(35),n2h4(125))
  call Hloop_AS_Q(ntryL,G1H16(22),wf4(:,37),G1H4(54),ngX,m3h4x4(:,18),heltab2x16(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(54),19,nMT,G2H4(36),n2h4(126))
  call Hloop_QS_A(ntryL,G1H16(23),wf4(:,37),G1H4(57),ngX,m3h4x4(:,19),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(57),19,nMB,G2H4(37),n2h4(127))
  call Hloop_AS_Q(ntryL,G1H16(24),wf4(:,37),G1H4(58),ngX,m3h4x4(:,20),heltab2x16(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(58),19,nMB,G2H4(38),n2h4(128))
  call Hloop_SS_S(ntryL,G1H16(25),wf4(:,36),G1H4(59),m3h4x4(:,21),heltab2x16(:,:,149))
  call Hloop_SS_S(ntryL,G1H16(26),wf4(:,36),G1H4(60),m3h4x4(:,22),heltab2x16(:,:,150))
  call Hloop_SS_S(ntryL,G1H16(29),wf4(:,36),G1H4(63),m3h4x4(:,23),heltab2x16(:,:,151))
  call Hloop_SS_S(ntryL,G1H16(30),wf4(:,36),G1H4(64),m3h4x4(:,24),heltab2x16(:,:,152))
  call Hloop_SS_S(ntryL,G1H16(33),wf4(:,37),G1H4(65),m3h4x4(:,25),heltab2x16(:,:,153))
  call Hloop_SS_S(ntryL,G1H16(34),wf4(:,37),G1H4(66),m3h4x4(:,26),heltab2x16(:,:,154))
  call Hloop_VS_V(ntryL,G1H16(35),wf4(:,36),G1H4(69),m3h4x4(:,27),heltab2x16(:,:,155))
  call Hloop_VS_V(ntryL,G1H16(36),wf4(:,36),G1H4(70),m3h4x4(:,28),heltab2x16(:,:,156))
  call Hloop_VT_S(ntryL,G0H16(25),16,wf4(:,36),3,G1H4(71),m3h4x4(:,29),heltab2x16(:,:,157))
  call Hloop_VT_S(ntryL,G0H16(26),16,wf4(:,36),3,G1H4(72),m3h4x4(:,30),heltab2x16(:,:,158))
  call Hloop_VT_S(ntryL,G0H16(27),16,wf4(:,37),3,G1H4(75),m3h4x4(:,31),heltab2x16(:,:,159))
  call Hloop_VT_S(ntryL,G0H16(28),16,wf4(:,37),3,G1H4(76),m3h4x4(:,32),heltab2x16(:,:,160))
  call Hloop_ST_V(ntryL,G1H16(37),16,wf4(:,36),3,G2H4(39),m3h4x4(:,33),heltab2x16(:,:,161))
  call Hloop_ST_V(ntryL,G1H16(38),16,wf4(:,36),3,G2H4(40),m3h4x4(:,34),heltab2x16(:,:,162))
  call Hloop_ST_V(ntryL,G1H16(39),16,wf4(:,37),3,G2H4(41),m3h4x4(:,35),heltab2x16(:,:,163))
  call Hloop_ST_V(ntryL,G1H16(40),16,wf4(:,37),3,G2H4(45),m3h4x4(:,36),heltab2x16(:,:,164))
  call Hloop_SS_S(ntryL,G0H16(29),wf4(:,36),G0H4(1),m3h4x4(:,37),heltab2x16(:,:,165))
  call Hloop_SS_S(ntryL,G0H16(30),wf4(:,36),G0H4(2),m3h4x4(:,38),heltab2x16(:,:,166))
  call Hloop_SS_S(ntryL,G1H16(42),wf4(:,36),G1H4(77),m3h4x4(:,39),heltab2x16(:,:,167))
  call Hloop_VS_V(ntryL,G0H16(31),wf4(:,36),G0H4(3),m3h4x4(:,40),heltab2x16(:,:,168))
  call Hloop_VS_V(ntryL,G0H16(32),wf4(:,36),G0H4(4),m3h4x4(:,41),heltab2x16(:,:,169))
  call Hloop_VT_S(ntryL,G1H16(43),16,wf4(:,36),3,G2H4(43),m3h4x4(:,42),heltab2x16(:,:,170))
  call Hloop_VT_S(ntryL,G1H16(44),16,wf4(:,36),3,G2H4(44),m3h4x4(:,43),heltab2x16(:,:,171))
  call Hloop_VT_S(ntryL,G1H16(45),16,wf4(:,37),3,G2H4(46),m3h4x4(:,44),heltab2x16(:,:,172))
  call Hloop_VT_S(ntryL,G1H16(46),16,wf4(:,37),3,G2H4(47),m3h4x4(:,45),heltab2x16(:,:,173))
  call Hloop_ST_V(ntryL,G0H16(34),16,wf4(:,36),3,G1H4(78),m3h4x4(:,46),heltab2x16(:,:,174))
  call Hloop_ST_V(ntryL,G0H16(36),16,wf4(:,37),3,G1H4(81),m3h4x4(:,47),heltab2x16(:,:,175))
  call Hloop_VT_S(ntryL,G0H16(38),16,wf4(:,36),3,G1H4(82),m3h4x4(:,48),heltab2x16(:,:,176))
  call Hloop_VT_S(ntryL,G0H16(40),16,wf4(:,37),3,G1H4(83),m3h4x4(:,49),heltab2x16(:,:,177))
  call Hloop_ST_V(ntryL,G1H16(47),16,wf4(:,36),3,G2H4(48),m3h4x4(:,50),heltab2x16(:,:,178))
  call Hloop_ST_V(ntryL,G1H16(48),16,wf4(:,36),3,G2H4(49),m3h4x4(:,51),heltab2x16(:,:,179))
  call Hloop_ST_V(ntryL,G1H16(49),16,wf4(:,37),3,G2H4(50),m3h4x4(:,52),heltab2x16(:,:,180))
  call Hloop_ST_V(ntryL,G1H16(50),16,wf4(:,37),3,G2H4(51),m3h4x4(:,53),heltab2x16(:,:,181))
  call Hloop_SS_S(ntryL,G0H16(41),wf4(:,36),G0H4(5),m3h4x4(:,54),heltab2x16(:,:,182))
  call Hloop_SS_S(ntryL,G0H16(42),wf4(:,36),G0H4(6),m3h4x4(:,55),heltab2x16(:,:,183))
  call Hloop_VS_V(ntryL,G1H16(52),wf4(:,36),G1H4(84),m3h4x4(:,56),heltab2x16(:,:,184))
  call Hloop_VS_V(ntryL,G0H16(43),wf4(:,36),G0H4(7),m3h4x4(:,57),heltab2x16(:,:,185))
  call Hloop_VS_V(ntryL,G0H16(44),wf4(:,36),G0H4(8),m3h4x4(:,58),heltab2x16(:,:,186))
  call Hloop_VT_S(ntryL,G1H16(53),16,wf4(:,36),3,G2H4(52),m3h4x4(:,59),heltab2x16(:,:,187))
  call Hloop_VT_S(ntryL,G1H16(54),16,wf4(:,36),3,G2H4(53),m3h4x4(:,60),heltab2x16(:,:,188))
  call Hloop_VT_S(ntryL,G1H16(55),16,wf4(:,37),3,G2H4(57),m3h4x4(:,61),heltab2x16(:,:,189))
  call Hloop_VT_S(ntryL,G1H16(56),16,wf4(:,37),3,G2H4(55),m3h4x4(:,62),heltab2x16(:,:,190))
  call Hloop_ST_V(ntryL,G0H16(45),16,wf4(:,36),3,G1H4(87),m3h4x4(:,63),heltab2x16(:,:,191))
  call Hloop_ST_V(ntryL,G0H16(46),16,wf4(:,36),3,G1H4(88),m3h4x4(:,64),heltab2x16(:,:,192))
  call Hloop_ST_V(ntryL,G0H16(47),16,wf4(:,37),3,G1H4(89),m3h4x4(:,65),heltab2x16(:,:,193))
  call Hloop_ST_V(ntryL,G0H16(48),16,wf4(:,37),3,G1H4(90),m3h4x4(:,66),heltab2x16(:,:,194))
  call Hloop_QV_A(ntryL,G1H16(57),wf4(:,13),G1H4(93),m3h4x4(:,67),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(93),19,nME,G2H4(56),n2h4(129))
  call Hloop_QV_A(ntryL,G1H16(58),wf4(:,13),G1H4(94),m3h4x4(:,68),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H4(94),19,nMM,G2H4(58),n2h4(130))
  call Hloop_QV_A(ntryL,G1H16(59),wf4(:,13),G1H4(95),m3h4x4(:,69),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G1H4(95),19,nML,G2H4(59),n2h4(131))
  call Hloop_AV_Q(ntryL,G1H16(60),wf4(:,13),G1H4(96),m3h4x4(:,70),heltab2x16(:,:,198))
  call Hloop_A_Q(ntryL,G1H4(96),19,nME,G2H4(60),n2h4(132))
  call Hloop_AV_Q(ntryL,G1H16(61),wf4(:,13),G1H4(99),m3h4x4(:,71),heltab2x16(:,:,199))
  call Hloop_A_Q(ntryL,G1H4(99),19,nMM,G2H4(61),n2h4(133))
  call Hloop_AV_Q(ntryL,G1H16(62),wf4(:,13),G1H4(100),m3h4x4(:,72),heltab2x16(:,:,200))
  call Hloop_A_Q(ntryL,G1H4(100),19,nML,G2H4(62),n2h4(134))
  call Hloop_QV_A(ntryL,G1H16(67),wf4(:,13),G1H4(101),m3h4x4(:,73),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H4(101),19,0,G2H4(63),n2h4(135))
  call Hloop_QV_A(ntryL,G1H16(64),wf4(:,13),G1H4(102),m3h4x4(:,74),heltab2x16(:,:,202))
  call Hloop_Q_A(ntryL,G1H4(102),19,nMT,G2H4(64),n2h4(136))
  call Hloop_AV_Q(ntryL,G1H16(69),wf4(:,13),G1H4(105),m3h4x4(:,75),heltab2x16(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(105),19,0,G2H4(68),n2h4(137))
  call Hloop_AV_Q(ntryL,G1H16(66),wf4(:,13),G1H4(106),m3h4x4(:,76),heltab2x16(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(106),19,nMT,G2H4(69),n2h4(138))
  call Hloop_QV_A(ntryL,G1H16(68),wf4(:,13),G1H4(107),m3h4x4(:,77),heltab2x16(:,:,205))
  call Hloop_Q_A(ntryL,G1H4(107),19,nMB,G2H4(72),n2h4(139))
  call Hloop_AV_Q(ntryL,G1H16(70),wf4(:,13),G1H4(108),m3h4x4(:,78),heltab2x16(:,:,206))
  call Hloop_A_Q(ntryL,G1H4(108),19,nMB,G2H4(73),n2h4(140))
  call Hloop_QZ_A(ntryL,G1H16(71),wf4(:,14),G1H4(111),ngZl,m3h4x4(:,79),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G1H4(111),19,nME,G2H4(76),n2h4(141))
  call Hloop_QZ_A(ntryL,G1H16(72),wf4(:,14),G1H4(112),ngZl,m3h4x4(:,80),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H4(112),19,nMM,G2H4(77),n2h4(142))
  call Hloop_QZ_A(ntryL,G1H16(73),wf4(:,14),G1H4(113),ngZl,m3h4x4(:,81),heltab2x16(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(113),19,nML,G2H4(81),n2h4(143))
  call Hloop_AZ_Q(ntryL,G1H16(74),wf4(:,14),G1H4(114),ngZl,m3h4x4(:,82),heltab2x16(:,:,210))
  call Hloop_A_Q(ntryL,G1H4(114),19,nME,G2H4(82),n2h4(144))
  call Hloop_AZ_Q(ntryL,G1H16(75),wf4(:,14),G1H4(117),ngZl,m3h4x4(:,83),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G1H4(117),19,nMM,G2H4(86),n2h4(145))
  call Hloop_AZ_Q(ntryL,G1H16(76),wf4(:,14),G1H4(118),ngZl,m3h4x4(:,84),heltab2x16(:,:,212))
  call Hloop_A_Q(ntryL,G1H4(118),19,nML,G2H4(87),n2h4(146))
  call Hloop_QZ_A(ntryL,G1H16(77),wf4(:,14),G1H4(119),ngZu,m3h4x4(:,85),heltab2x16(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(119),19,0,G2H4(90),n2h4(147))
  call Hloop_QZ_A(ntryL,G1H16(78),wf4(:,14),G1H4(120),ngZu,m3h4x4(:,86),heltab2x16(:,:,214))
  call Hloop_Q_A(ntryL,G1H4(120),19,nMT,G2H4(91),n2h4(148))
  call Hloop_AZ_Q(ntryL,G1H16(79),wf4(:,14),G1H4(123),ngZu,m3h4x4(:,87),heltab2x16(:,:,215))
  call Hloop_A_Q(ntryL,G1H4(123),19,0,G2H4(94),n2h4(149))
  call Hloop_AZ_Q(ntryL,G1H16(80),wf4(:,14),G1H4(124),ngZu,m3h4x4(:,88),heltab2x16(:,:,216))
  call Hloop_A_Q(ntryL,G1H4(124),19,nMT,G2H4(95),n2h4(150))
  call Hloop_QZ_A(ntryL,G1H16(81),wf4(:,14),G1H4(125),ngZd,m3h4x4(:,89),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(125),19,0,G2H4(99),n2h4(151))
  call Hloop_QZ_A(ntryL,G1H16(82),wf4(:,14),G1H4(126),ngZd,m3h4x4(:,90),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(126),19,nMB,G2H4(100),n2h4(152))
  call Hloop_AZ_Q(ntryL,G1H16(83),wf4(:,14),G1H4(129),ngZd,m3h4x4(:,91),heltab2x16(:,:,219))
  call Hloop_A_Q(ntryL,G1H4(129),19,0,G2H4(5),n2h4(153))
  call Hloop_AZ_Q(ntryL,G1H16(84),wf4(:,14),G1H4(130),ngZd,m3h4x4(:,92),heltab2x16(:,:,220))
  call Hloop_A_Q(ntryL,G1H4(130),19,nMB,G2H4(6),n2h4(154))
  call Hloop_TV_S(ntryL,G1H16(85),16,wf4(:,13),3,G2H4(7),m3h4x4(:,93),heltab2x16(:,:,221))
  call Hloop_SV_T(ntryL,G1H16(86),16,wf4(:,13),3,G2H4(8),m3h4x4(:,94),heltab2x16(:,:,222))
  call Hloop_TV_S(ntryL,G1H16(87),16,wf4(:,14),3,G2H4(10),m3h4x4(:,95),heltab2x16(:,:,223))
  call Hloop_SV_T(ntryL,G1H16(88),16,wf4(:,14),3,G2H4(25),m3h4x4(:,96),heltab2x16(:,:,224))
  call Hloop_CV_D(ntryL,G1H16(91),16,wf4(:,13),3,G2H4(26),m3h4x4(:,97),heltab2x16(:,:,225))
  call Hloop_DV_C(ntryL,G1H16(92),16,wf4(:,13),G2H4(27),m3h4x4(:,98),heltab2x16(:,:,226))
  call Hloop_CV_D(ntryL,G1H16(95),16,wf4(:,14),3,G2H4(28),m3h4x4(:,99),heltab2x16(:,:,227))
  call Hloop_DV_C(ntryL,G1H16(96),16,wf4(:,14),G2H4(30),m3h4x4(:,100),heltab2x16(:,:,228))
  call Hloop_UV_W(ntryL,G1H16(97),16,wf4(:,13),3,G2H4(42),m3h4x4(:,101),heltab2x16(:,:,229))
  call Hloop_UW_V(ntryL,G1H16(98),16,wf4(:,13),3,G2H4(54),m3h4x4(:,102),heltab2x16(:,:,230))
  call Hloop_UV_W(ntryL,G1H16(99),16,wf4(:,14),3,G2H4(1),m3h4x4(:,103),heltab2x16(:,:,231))
  call Hloop_UW_V(ntryL,G1H16(100),16,wf4(:,14),3,G2H4(2),m3h4x4(:,104),heltab2x16(:,:,232))
  call Hloop_VV_S(ntryL,G0H16(13),wf4(:,13),G0H4(9),m3h4x4(:,105),heltab2x16(:,:,233))
  call Hloop_VV_S(ntryL,G0H16(14),wf4(:,13),G0H4(10),m3h4x4(:,106),heltab2x16(:,:,234))
  call Hloop_VV_S(ntryL,G0H16(15),wf4(:,14),G0H4(11),m3h4x4(:,107),heltab2x16(:,:,235))
  call Hloop_VV_S(ntryL,G0H16(16),wf4(:,14),G0H4(12),m3h4x4(:,108),heltab2x16(:,:,236))
  call Hloop_SV_V(ntryL,G1H16(101),wf4(:,13),G1H4(131),m3h4x4(:,109),heltab2x16(:,:,237))
  call Hloop_SV_V(ntryL,G1H16(102),wf4(:,13),G1H4(132),m3h4x4(:,110),heltab2x16(:,:,238))
  call Hloop_SV_V(ntryL,G1H16(103),wf4(:,14),G1H4(135),m3h4x4(:,111),heltab2x16(:,:,239))
  call Hloop_SV_V(ntryL,G1H16(104),wf4(:,14),G1H4(136),m3h4x4(:,112),heltab2x16(:,:,240))
  call Hloop_TV_S(ntryL,G0H16(17),16,wf4(:,13),3,G1H4(137),m3h4x4(:,113),heltab2x16(:,:,241))
  call Hloop_SV_T(ntryL,G0H16(18),16,wf4(:,13),3,G1H4(138),m3h4x4(:,114),heltab2x16(:,:,242))
  call Hloop_TV_S(ntryL,G0H16(19),16,wf4(:,14),3,G1H4(141),m3h4x4(:,115),heltab2x16(:,:,243))
  call Hloop_SV_T(ntryL,G0H16(20),16,wf4(:,14),3,G1H4(142),m3h4x4(:,116),heltab2x16(:,:,244))
  call Hloop_TV_S(ntryL,G1H16(105),16,wf4(:,13),3,G2H4(3),m3h4x4(:,117),heltab2x16(:,:,245))
  call Hloop_SV_T(ntryL,G1H16(106),16,wf4(:,13),3,G2H4(4),m3h4x4(:,118),heltab2x16(:,:,246))
  call Hloop_TV_S(ntryL,G1H16(107),16,wf4(:,14),3,G2H4(74),m3h4x4(:,119),heltab2x16(:,:,247))
  call Hloop_SV_T(ntryL,G1H16(108),16,wf4(:,14),3,G2H4(65),m3h4x4(:,120),heltab2x16(:,:,248))
  call Hloop_UV_W(ntryL,G0H16(21),16,wf4(:,13),3,G1H4(143),m3h4x4(:,121),heltab2x16(:,:,249))
  call Hloop_UW_V(ntryL,G0H16(22),16,wf4(:,13),3,G1H4(144),m3h4x4(:,122),heltab2x16(:,:,250))
  call Hloop_UV_W(ntryL,G0H16(23),16,wf4(:,14),3,G1H4(147),m3h4x4(:,123),heltab2x16(:,:,251))
  call Hloop_UW_V(ntryL,G0H16(24),16,wf4(:,14),3,G1H4(148),m3h4x4(:,124),heltab2x16(:,:,252))
  call Hloop_VV_S(ntryL,G1H16(109),wf4(:,13),G1H4(149),m3h4x4(:,125),heltab2x16(:,:,253))
  call Hloop_VV_S(ntryL,G1H16(110),wf4(:,13),G1H4(150),m3h4x4(:,126),heltab2x16(:,:,254))
  call Hloop_VV_S(ntryL,G1H16(111),wf4(:,14),G1H4(153),m3h4x4(:,127),heltab2x16(:,:,255))
  call Hloop_VV_S(ntryL,G1H16(112),wf4(:,14),G1H4(154),m3h4x4(:,128),heltab2x16(:,:,256))
  call Hloop_SV_V(ntryL,G0H16(6),wf4(:,13),G0H4(13),m3h4x4(:,129),heltab2x16(:,:,257))
  call Hloop_SV_V(ntryL,G0H16(8),wf4(:,14),G0H4(14),m3h4x4(:,130),heltab2x16(:,:,258))
  call Hloop_VV_S(ntryL,G0H16(10),wf4(:,13),G0H4(15),m3h4x4(:,131),heltab2x16(:,:,259))
  call Hloop_VV_S(ntryL,G0H16(12),wf4(:,14),G0H4(16),m3h4x4(:,132),heltab2x16(:,:,260))
  call Hloop_SV_V(ntryL,G1H16(113),wf4(:,13),G1H4(155),m3h4x4(:,133),heltab2x16(:,:,261))
  call Hloop_SV_V(ntryL,G1H16(114),wf4(:,13),G1H4(156),m3h4x4(:,134),heltab2x16(:,:,262))
  call Hloop_SV_V(ntryL,G1H16(115),wf4(:,14),G1H4(159),m3h4x4(:,135),heltab2x16(:,:,263))
  call Hloop_SV_V(ntryL,G1H16(116),wf4(:,14),G1H4(160),m3h4x4(:,136),heltab2x16(:,:,264))
  call Hloop_TV_S(ntryL,G0H16(49),16,wf4(:,13),3,G1H4(161),m3h4x4(:,137),heltab2x16(:,:,265))
  call Hloop_SV_T(ntryL,G0H16(50),16,wf4(:,13),3,G1H4(162),m3h4x4(:,138),heltab2x16(:,:,266))
  call Hloop_TV_S(ntryL,G0H16(51),16,wf4(:,14),3,G1H4(165),m3h4x4(:,139),heltab2x16(:,:,267))
  call Hloop_SV_T(ntryL,G0H16(52),16,wf4(:,14),3,G1H4(166),m3h4x4(:,140),heltab2x16(:,:,268))
  call Hloop_UV_W(ntryL,G1H16(117),16,wf4(:,13),3,G2H4(78),m3h4x4(:,141),heltab2x16(:,:,269))
  call Hloop_UW_V(ntryL,G1H16(118),16,wf4(:,13),3,G2H4(70),m3h4x4(:,142),heltab2x16(:,:,270))
  call Hloop_UV_W(ntryL,G1H16(119),16,wf4(:,14),3,G2H4(101),m3h4x4(:,143),heltab2x16(:,:,271))
  call Hloop_UW_V(ntryL,G1H16(120),16,wf4(:,14),3,G2H4(102),m3h4x4(:,144),heltab2x16(:,:,272))
  call Hloop_UV_W(ntryL,G0H16(53),16,wf4(:,13),3,G1H4(167),m3h4x4(:,145),heltab2x16(:,:,273))
  call Hloop_UW_V(ntryL,G0H16(54),16,wf4(:,13),3,G1H4(168),m3h4x4(:,146),heltab2x16(:,:,274))
  call Hloop_UV_W(ntryL,G0H16(55),16,wf4(:,14),3,G1H4(171),m3h4x4(:,147),heltab2x16(:,:,275))
  call Hloop_UW_V(ntryL,G0H16(56),16,wf4(:,14),3,G1H4(172),m3h4x4(:,148),heltab2x16(:,:,276))
  call Hloop_VV_S(ntryL,G1H16(121),wf4(:,13),G1H4(173),m3h4x4(:,149),heltab2x16(:,:,277))
  call Hloop_VV_S(ntryL,G1H16(122),wf4(:,13),G1H4(174),m3h4x4(:,150),heltab2x16(:,:,278))
  call Hloop_VV_S(ntryL,G1H16(123),wf4(:,14),G1H4(177),m3h4x4(:,151),heltab2x16(:,:,279))
  call Hloop_VV_S(ntryL,G1H16(124),wf4(:,14),G1H4(178),m3h4x4(:,152),heltab2x16(:,:,280))
  call Hloop_SV_V(ntryL,G0H16(57),wf4(:,13),G0H4(17),m3h4x4(:,153),heltab2x16(:,:,281))
  call Hloop_SV_V(ntryL,G0H16(58),wf4(:,13),G0H4(18),m3h4x4(:,154),heltab2x16(:,:,282))
  call Hloop_SV_V(ntryL,G0H16(59),wf4(:,14),G0H4(19),m3h4x4(:,155),heltab2x16(:,:,283))
  call Hloop_SV_V(ntryL,G0H16(60),wf4(:,14),G0H4(20),m3h4x4(:,156),heltab2x16(:,:,284))
  call Hloop_AS_Q(ntryL,G1H16(125),wf4(:,36),G1H4(179),ngH,m3h4x4(:,157),heltab2x16(:,:,285))
  call Hloop_A_Q(ntryL,G1H4(179),19,nME,G2H4(103),n2h4(155))
  call Hloop_AS_Q(ntryL,G1H16(126),wf4(:,36),G1H4(180),ngH,m3h4x4(:,158),heltab2x16(:,:,286))
  call Hloop_A_Q(ntryL,G1H4(180),19,nMM,G2H4(104),n2h4(156))
  call Hloop_AS_Q(ntryL,G1H16(127),wf4(:,36),G1H4(183),ngH,m3h4x4(:,159),heltab2x16(:,:,287))
  call Hloop_A_Q(ntryL,G1H4(183),19,nML,G2H4(105),n2h4(157))
  call Hloop_QS_A(ntryL,G1H16(128),wf4(:,36),G1H4(184),ngH,m3h4x4(:,160),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G1H4(184),19,nME,G2H4(106),n2h4(158))
  call Hloop_QS_A(ntryL,G1H16(129),wf4(:,36),G1H4(185),ngH,m3h4x4(:,161),heltab2x16(:,:,289))
  call Hloop_Q_A(ntryL,G1H4(185),19,nMM,G2H4(107),n2h4(159))
  call Hloop_QS_A(ntryL,G1H16(130),wf4(:,36),G1H4(186),ngH,m3h4x4(:,162),heltab2x16(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(186),19,nML,G2H4(108),n2h4(160))
  call Hloop_AS_Q(ntryL,G1H16(131),wf4(:,36),G1H4(189),ngH,m3h4x4(:,163),heltab2x16(:,:,291))
  call Hloop_A_Q(ntryL,G1H4(189),19,nMT,G2H4(109),n2h4(161))
  call Hloop_QS_A(ntryL,G1H16(132),wf4(:,36),G1H4(190),ngH,m3h4x4(:,164),heltab2x16(:,:,292))
  call Hloop_Q_A(ntryL,G1H4(190),19,nMT,G2H4(110),n2h4(162))
  call Hloop_AS_Q(ntryL,G1H16(133),wf4(:,36),G1H4(191),ngH,m3h4x4(:,165),heltab2x16(:,:,293))
  call Hloop_A_Q(ntryL,G1H4(191),19,nMB,G2H4(111),n2h4(163))
  call Hloop_QS_A(ntryL,G1H16(134),wf4(:,36),G1H4(192),ngH,m3h4x4(:,166),heltab2x16(:,:,294))
  call Hloop_Q_A(ntryL,G1H4(192),19,nMB,G2H4(112),n2h4(164))
  call Hloop_AS_Q(ntryL,G1H16(135),wf4(:,37),G1H4(195),ngX,m3h4x4(:,167),heltab2x16(:,:,295))
  call Hloop_A_Q(ntryL,G1H4(195),19,nME,G2H4(113),n2h4(165))
  call Hloop_AS_Q(ntryL,G1H16(136),wf4(:,37),G1H4(196),ngX,m3h4x4(:,168),heltab2x16(:,:,296))
  call Hloop_A_Q(ntryL,G1H4(196),19,nMM,G2H4(114),n2h4(166))
  call Hloop_AS_Q(ntryL,G1H16(137),wf4(:,37),G1H4(197),ngX,m3h4x4(:,169),heltab2x16(:,:,297))
  call Hloop_A_Q(ntryL,G1H4(197),19,nML,G2H4(115),n2h4(167))
  call Hloop_QS_A(ntryL,G1H16(138),wf4(:,37),G1H4(198),ngX,m3h4x4(:,170),heltab2x16(:,:,298))
  call Hloop_Q_A(ntryL,G1H4(198),19,nME,G2H4(116),n2h4(168))
  call Hloop_QS_A(ntryL,G1H16(139),wf4(:,37),G1H4(201),ngX,m3h4x4(:,171),heltab2x16(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(201),19,nMM,G2H4(117),n2h4(169))
  call Hloop_QS_A(ntryL,G1H16(140),wf4(:,37),G1H4(202),ngX,m3h4x4(:,172),heltab2x16(:,:,300))
  call Hloop_Q_A(ntryL,G1H4(202),19,nML,G2H4(118),n2h4(170))
  call Hloop_AS_Q(ntryL,G1H16(141),wf4(:,37),G1H4(203),ngX,m3h4x4(:,173),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(203),19,nMT,G2H4(119),n2h4(171))
  call Hloop_QS_A(ntryL,G1H16(142),wf4(:,37),G1H4(204),ngX,m3h4x4(:,174),heltab2x16(:,:,302))
  call Hloop_Q_A(ntryL,G1H4(204),19,nMT,G2H4(120),n2h4(172))
  call Hloop_AS_Q(ntryL,G1H16(143),wf4(:,37),G1H4(207),ngX,m3h4x4(:,175),heltab2x16(:,:,303))
  call Hloop_A_Q(ntryL,G1H4(207),19,nMB,G2H4(121),n2h4(173))
  call Hloop_QS_A(ntryL,G1H16(144),wf4(:,37),G1H4(208),ngX,m3h4x4(:,176),heltab2x16(:,:,304))
  call Hloop_Q_A(ntryL,G1H4(208),19,nMB,G2H4(122),n2h4(174))
  call Hloop_SS_S(ntryL,G1H16(145),wf4(:,36),G1H4(209),m3h4x4(:,177),heltab2x16(:,:,305))
  call Hloop_SS_S(ntryL,G1H16(146),wf4(:,36),G1H4(210),m3h4x4(:,178),heltab2x16(:,:,306))
  call Hloop_SS_S(ntryL,G1H16(149),wf4(:,36),G1H4(213),m3h4x4(:,179),heltab2x16(:,:,307))
  call Hloop_SS_S(ntryL,G1H16(150),wf4(:,36),G1H4(214),m3h4x4(:,180),heltab2x16(:,:,308))
  call Hloop_SS_S(ntryL,G1H16(153),wf4(:,37),G1H4(215),m3h4x4(:,181),heltab2x16(:,:,309))
  call Hloop_SS_S(ntryL,G1H16(154),wf4(:,37),G1H4(216),m3h4x4(:,182),heltab2x16(:,:,310))
  call Hloop_VS_V(ntryL,G1H16(155),wf4(:,36),G1H4(219),m3h4x4(:,183),heltab2x16(:,:,311))
  call Hloop_VS_V(ntryL,G1H16(156),wf4(:,36),G1H4(220),m3h4x4(:,184),heltab2x16(:,:,312))
  call Hloop_VT_S(ntryL,G0H16(61),16,wf4(:,36),3,G1H4(5),m3h4x4(:,185),heltab2x16(:,:,313))
  call Hloop_VT_S(ntryL,G0H16(62),16,wf4(:,36),3,G1H4(6),m3h4x4(:,186),heltab2x16(:,:,314))
  call Hloop_VT_S(ntryL,G0H16(63),16,wf4(:,37),3,G1H4(9),m3h4x4(:,187),heltab2x16(:,:,315))
  call Hloop_VT_S(ntryL,G0H16(64),16,wf4(:,37),3,G1H4(10),m3h4x4(:,188),heltab2x16(:,:,316))
  call Hloop_SS_S(ntryL,G0H16(65),wf4(:,36),G0H4(21),m3h4x4(:,189),heltab2x16(:,:,317))
  call Hloop_SS_S(ntryL,G0H16(66),wf4(:,36),G0H4(22),m3h4x4(:,190),heltab2x16(:,:,318))
  call Hloop_ST_V(ntryL,G1H16(157),16,wf4(:,36),3,G2H4(123),m3h4x4(:,191),heltab2x16(:,:,319))
  call Hloop_ST_V(ntryL,G1H16(158),16,wf4(:,36),3,G2H4(124),m3h4x4(:,192),heltab2x16(:,:,320))
  call Hloop_ST_V(ntryL,G1H16(159),16,wf4(:,37),3,G2H4(125),m3h4x4(:,193),heltab2x16(:,:,321))
  call Hloop_ST_V(ntryL,G1H16(160),16,wf4(:,37),3,G2H4(126),m3h4x4(:,194),heltab2x16(:,:,322))
  call Hloop_SS_S(ntryL,G1H16(162),wf4(:,36),G1H4(11),m3h4x4(:,195),heltab2x16(:,:,323))
  call Hloop_VT_S(ntryL,G1H16(163),16,wf4(:,36),3,G2H4(127),m3h4x4(:,196),heltab2x16(:,:,324))
  call Hloop_VT_S(ntryL,G1H16(164),16,wf4(:,36),3,G2H4(128),m3h4x4(:,197),heltab2x16(:,:,325))
  call Hloop_VT_S(ntryL,G1H16(165),16,wf4(:,37),3,G2H4(129),m3h4x4(:,198),heltab2x16(:,:,326))
  call Hloop_VT_S(ntryL,G1H16(166),16,wf4(:,37),3,G2H4(130),m3h4x4(:,199),heltab2x16(:,:,327))
  call Hloop_VS_V(ntryL,G0H16(67),wf4(:,36),G0H4(23),m3h4x4(:,200),heltab2x16(:,:,328))
  call Hloop_VS_V(ntryL,G0H16(68),wf4(:,36),G0H4(24),m3h4x4(:,201),heltab2x16(:,:,329))
  call Hloop_ST_V(ntryL,G0H16(70),16,wf4(:,36),3,G1H4(12),m3h4x4(:,202),heltab2x16(:,:,330))
  call Hloop_ST_V(ntryL,G0H16(72),16,wf4(:,37),3,G1H4(15),m3h4x4(:,203),heltab2x16(:,:,331))
  call Hloop_VT_S(ntryL,G0H16(74),16,wf4(:,36),3,G1H4(16),m3h4x4(:,204),heltab2x16(:,:,332))
  call Hloop_VT_S(ntryL,G0H16(76),16,wf4(:,37),3,G1H4(29),m3h4x4(:,205),heltab2x16(:,:,333))
  call Hloop_SS_S(ntryL,G0H16(77),wf4(:,36),G0H4(25),m3h4x4(:,206),heltab2x16(:,:,334))
  call Hloop_SS_S(ntryL,G0H16(78),wf4(:,36),G0H4(26),m3h4x4(:,207),heltab2x16(:,:,335))
  call Hloop_ST_V(ntryL,G1H16(167),16,wf4(:,36),3,G2H4(131),m3h4x4(:,208),heltab2x16(:,:,336))
  call Hloop_ST_V(ntryL,G1H16(168),16,wf4(:,36),3,G2H4(132),m3h4x4(:,209),heltab2x16(:,:,337))
  call Hloop_ST_V(ntryL,G1H16(169),16,wf4(:,37),3,G2H4(133),m3h4x4(:,210),heltab2x16(:,:,338))
  call Hloop_ST_V(ntryL,G1H16(170),16,wf4(:,37),3,G2H4(134),m3h4x4(:,211),heltab2x16(:,:,339))
  call Hloop_VS_V(ntryL,G1H16(172),wf4(:,36),G1H4(30),m3h4x4(:,212),heltab2x16(:,:,340))
  call Hloop_VT_S(ntryL,G1H16(173),16,wf4(:,36),3,G2H4(135),m3h4x4(:,213),heltab2x16(:,:,341))
  call Hloop_VT_S(ntryL,G1H16(174),16,wf4(:,36),3,G2H4(136),m3h4x4(:,214),heltab2x16(:,:,342))
  call Hloop_VT_S(ntryL,G1H16(175),16,wf4(:,37),3,G2H4(137),m3h4x4(:,215),heltab2x16(:,:,343))
  call Hloop_VT_S(ntryL,G1H16(176),16,wf4(:,37),3,G2H4(138),m3h4x4(:,216),heltab2x16(:,:,344))
  call Hloop_VS_V(ntryL,G0H16(79),wf4(:,36),G0H4(27),m3h4x4(:,217),heltab2x16(:,:,345))
  call Hloop_VS_V(ntryL,G0H16(80),wf4(:,36),G0H4(28),m3h4x4(:,218),heltab2x16(:,:,346))
  call Hloop_ST_V(ntryL,G0H16(81),16,wf4(:,36),3,G1H4(33),m3h4x4(:,219),heltab2x16(:,:,347))
  call Hloop_ST_V(ntryL,G0H16(82),16,wf4(:,36),3,G1H4(34),m3h4x4(:,220),heltab2x16(:,:,348))
  call Hloop_ST_V(ntryL,G0H16(83),16,wf4(:,37),3,G1H4(35),m3h4x4(:,221),heltab2x16(:,:,349))
  call Hloop_ST_V(ntryL,G0H16(84),16,wf4(:,37),3,G1H4(36),m3h4x4(:,222),heltab2x16(:,:,350))
  call Hloop_AV_Q(ntryL,G1H16(177),wf4(:,13),G1H4(39),m3h4x4(:,223),heltab2x16(:,:,351))
  call Hloop_A_Q(ntryL,G1H4(39),19,nME,G2H4(139),n2h4(175))
  call Hloop_AV_Q(ntryL,G1H16(178),wf4(:,13),G1H4(40),m3h4x4(:,224),heltab2x16(:,:,352))
  call Hloop_A_Q(ntryL,G1H4(40),19,nMM,G2H4(140),n2h4(176))
  call Hloop_AV_Q(ntryL,G1H16(179),wf4(:,13),G1H4(41),m3h4x4(:,225),heltab2x16(:,:,353))
  call Hloop_A_Q(ntryL,G1H4(41),19,nML,G2H4(141),n2h4(177))
  call Hloop_QV_A(ntryL,G1H16(180),wf4(:,13),G1H4(42),m3h4x4(:,226),heltab2x16(:,:,354))
  call Hloop_Q_A(ntryL,G1H4(42),19,nME,G2H4(142),n2h4(178))
  call Hloop_QV_A(ntryL,G1H16(181),wf4(:,13),G1H4(45),m3h4x4(:,227),heltab2x16(:,:,355))
  call Hloop_Q_A(ntryL,G1H4(45),19,nMM,G2H4(143),n2h4(179))
  call Hloop_QV_A(ntryL,G1H16(182),wf4(:,13),G1H4(46),m3h4x4(:,228),heltab2x16(:,:,356))
  call Hloop_Q_A(ntryL,G1H4(46),19,nML,G2H4(144),n2h4(180))
  call Hloop_AV_Q(ntryL,G1H16(187),wf4(:,13),G1H4(47),m3h4x4(:,229),heltab2x16(:,:,357))
  call Hloop_A_Q(ntryL,G1H4(47),19,0,G2H4(145),n2h4(181))
  call Hloop_AV_Q(ntryL,G1H16(184),wf4(:,13),G1H4(48),m3h4x4(:,230),heltab2x16(:,:,358))
  call Hloop_A_Q(ntryL,G1H4(48),19,nMT,G2H4(146),n2h4(182))
  call Hloop_QV_A(ntryL,G1H16(189),wf4(:,13),G1H4(51),m3h4x4(:,231),heltab2x16(:,:,359))
  call Hloop_Q_A(ntryL,G1H4(51),19,0,G2H4(147),n2h4(183))
  call Hloop_QV_A(ntryL,G1H16(186),wf4(:,13),G1H4(52),m3h4x4(:,232),heltab2x16(:,:,360))
  call Hloop_Q_A(ntryL,G1H4(52),19,nMT,G2H4(148),n2h4(184))
  call Hloop_AV_Q(ntryL,G1H16(188),wf4(:,13),G1H4(53),m3h4x4(:,233),heltab2x16(:,:,361))
  call Hloop_A_Q(ntryL,G1H4(53),19,nMB,G2H4(149),n2h4(185))
  call Hloop_QV_A(ntryL,G1H16(190),wf4(:,13),G1H4(54),m3h4x4(:,234),heltab2x16(:,:,362))
  call Hloop_Q_A(ntryL,G1H4(54),19,nMB,G2H4(150),n2h4(186))
  call Hloop_AZ_Q(ntryL,G1H16(191),wf4(:,14),G1H4(57),ngZl,m3h4x4(:,235),heltab2x16(:,:,363))
  call Hloop_A_Q(ntryL,G1H4(57),19,nME,G2H4(151),n2h4(187))
  call Hloop_AZ_Q(ntryL,G1H16(192),wf4(:,14),G1H4(58),ngZl,m3h4x4(:,236),heltab2x16(:,:,364))
  call Hloop_A_Q(ntryL,G1H4(58),19,nMM,G2H4(152),n2h4(188))
  call Hloop_AZ_Q(ntryL,G1H16(193),wf4(:,14),G1H4(93),ngZl,m3h4x4(:,237),heltab2x16(:,:,365))
  call Hloop_A_Q(ntryL,G1H4(93),19,nML,G2H4(153),n2h4(189))
  call Hloop_QZ_A(ntryL,G1H16(194),wf4(:,14),G1H4(94),ngZl,m3h4x4(:,238),heltab2x16(:,:,366))
  call Hloop_Q_A(ntryL,G1H4(94),19,nME,G2H4(154),n2h4(190))
  call Hloop_QZ_A(ntryL,G1H16(195),wf4(:,14),G1H4(95),ngZl,m3h4x4(:,239),heltab2x16(:,:,367))
  call Hloop_Q_A(ntryL,G1H4(95),19,nMM,G2H4(155),n2h4(191))
  call Hloop_QZ_A(ntryL,G1H16(196),wf4(:,14),G1H4(96),ngZl,m3h4x4(:,240),heltab2x16(:,:,368))
  call Hloop_Q_A(ntryL,G1H4(96),19,nML,G2H4(156),n2h4(192))
  call Hloop_AZ_Q(ntryL,G1H16(197),wf4(:,14),G1H4(99),ngZu,m3h4x4(:,241),heltab2x16(:,:,369))
  call Hloop_A_Q(ntryL,G1H4(99),19,0,G2H4(157),n2h4(193))
  call Hloop_AZ_Q(ntryL,G1H16(198),wf4(:,14),G1H4(100),ngZu,m3h4x4(:,242),heltab2x16(:,:,370))
  call Hloop_A_Q(ntryL,G1H4(100),19,nMT,G2H4(158),n2h4(194))
  call Hloop_QZ_A(ntryL,G1H16(199),wf4(:,14),G1H4(101),ngZu,m3h4x4(:,243),heltab2x16(:,:,371))
  call Hloop_Q_A(ntryL,G1H4(101),19,0,G2H4(159),n2h4(195))
  call Hloop_QZ_A(ntryL,G1H16(200),wf4(:,14),G1H4(102),ngZu,m3h4x4(:,244),heltab2x16(:,:,372))
  call Hloop_Q_A(ntryL,G1H4(102),19,nMT,G2H4(160),n2h4(196))
  call Hloop_AZ_Q(ntryL,G1H16(201),wf4(:,14),G1H4(105),ngZd,m3h4x4(:,245),heltab2x16(:,:,373))
  call Hloop_A_Q(ntryL,G1H4(105),19,0,G2H4(161),n2h4(197))
  call Hloop_AZ_Q(ntryL,G1H16(202),wf4(:,14),G1H4(106),ngZd,m3h4x4(:,246),heltab2x16(:,:,374))
  call Hloop_A_Q(ntryL,G1H4(106),19,nMB,G2H4(162),n2h4(198))
  call Hloop_QZ_A(ntryL,G1H16(203),wf4(:,14),G1H4(107),ngZd,m3h4x4(:,247),heltab2x16(:,:,375))
  call Hloop_Q_A(ntryL,G1H4(107),19,0,G2H4(163),n2h4(199))
  call Hloop_QZ_A(ntryL,G1H16(204),wf4(:,14),G1H4(108),ngZd,m3h4x4(:,248),heltab2x16(:,:,376))
  call Hloop_Q_A(ntryL,G1H4(108),19,nMB,G2H4(164),n2h4(200))
  call Hloop_SV_T(ntryL,G1H16(205),16,wf4(:,13),3,G2H4(165),m3h4x4(:,249),heltab2x16(:,:,377))
  call Hloop_TV_S(ntryL,G1H16(206),16,wf4(:,13),3,G2H4(166),m3h4x4(:,250),heltab2x16(:,:,378))
  call Hloop_SV_T(ntryL,G1H16(207),16,wf4(:,14),3,G2H4(167),m3h4x4(:,251),heltab2x16(:,:,379))
  call Hloop_TV_S(ntryL,G1H16(208),16,wf4(:,14),3,G2H4(168),m3h4x4(:,252),heltab2x16(:,:,380))
  call Hloop_DV_C(ntryL,G1H16(211),16,wf4(:,13),G2H4(169),m3h4x4(:,253),heltab2x16(:,:,381))
  call Hloop_CV_D(ntryL,G1H16(212),16,wf4(:,13),3,G2H4(170),m3h4x4(:,254),heltab2x16(:,:,382))
  call Hloop_DV_C(ntryL,G1H16(215),16,wf4(:,14),G2H4(171),m3h4x4(:,255),heltab2x16(:,:,383))
  call Hloop_CV_D(ntryL,G1H16(216),16,wf4(:,14),3,G2H4(172),m3h4x4(:,256),heltab2x16(:,:,384))
  call Hloop_UW_V(ntryL,G1H16(217),16,wf4(:,13),3,G2H4(173),m3h4x4(:,257),heltab2x16(:,:,385))
  call Hloop_UV_W(ntryL,G1H16(218),16,wf4(:,13),3,G2H4(174),m3h4x4(:,258),heltab2x16(:,:,386))
  call Hloop_UW_V(ntryL,G1H16(219),16,wf4(:,14),3,G2H4(175),m3h4x4(:,259),heltab2x16(:,:,387))
  call Hloop_UV_W(ntryL,G1H16(220),16,wf4(:,14),3,G2H4(176),m3h4x4(:,260),heltab2x16(:,:,388))
  call Hloop_VV_S(ntryL,G0H16(85),wf4(:,13),G0H4(29),m3h4x4(:,261),heltab2x16(:,:,389))
  call Hloop_VV_S(ntryL,G0H16(86),wf4(:,13),G0H4(30),m3h4x4(:,262),heltab2x16(:,:,390))
  call Hloop_VV_S(ntryL,G0H16(87),wf4(:,14),G0H4(31),m3h4x4(:,263),heltab2x16(:,:,391))
  call Hloop_VV_S(ntryL,G0H16(88),wf4(:,14),G0H4(32),m3h4x4(:,264),heltab2x16(:,:,392))
  call Hloop_SV_T(ntryL,G0H16(89),16,wf4(:,13),3,G1H4(111),m3h4x4(:,265),heltab2x16(:,:,393))
  call Hloop_TV_S(ntryL,G0H16(90),16,wf4(:,13),3,G1H4(112),m3h4x4(:,266),heltab2x16(:,:,394))
  call Hloop_SV_T(ntryL,G0H16(91),16,wf4(:,14),3,G1H4(113),m3h4x4(:,267),heltab2x16(:,:,395))
  call Hloop_TV_S(ntryL,G0H16(92),16,wf4(:,14),3,G1H4(114),m3h4x4(:,268),heltab2x16(:,:,396))
  call Hloop_SV_V(ntryL,G1H16(221),wf4(:,13),G1H4(117),m3h4x4(:,269),heltab2x16(:,:,397))
  call Hloop_SV_V(ntryL,G1H16(222),wf4(:,13),G1H4(118),m3h4x4(:,270),heltab2x16(:,:,398))
  call Hloop_SV_V(ntryL,G1H16(223),wf4(:,14),G1H4(119),m3h4x4(:,271),heltab2x16(:,:,399))
  call Hloop_SV_V(ntryL,G1H16(224),wf4(:,14),G1H4(120),m3h4x4(:,272),heltab2x16(:,:,400))
  call Hloop_SV_T(ntryL,G1H16(225),16,wf4(:,13),3,G2H4(177),m3h4x4(:,273),heltab2x16(:,:,401))
  call Hloop_TV_S(ntryL,G1H16(226),16,wf4(:,13),3,G2H4(178),m3h4x4(:,274),heltab2x16(:,:,402))
  call Hloop_SV_T(ntryL,G1H16(227),16,wf4(:,14),3,G2H4(179),m3h4x4(:,275),heltab2x16(:,:,403))
  call Hloop_TV_S(ntryL,G1H16(228),16,wf4(:,14),3,G2H4(180),m3h4x4(:,276),heltab2x16(:,:,404))
  call Hloop_VV_S(ntryL,G1H16(229),wf4(:,13),G1H4(123),m3h4x4(:,277),heltab2x16(:,:,405))
  call Hloop_VV_S(ntryL,G1H16(230),wf4(:,13),G1H4(124),m3h4x4(:,278),heltab2x16(:,:,406))
  call Hloop_VV_S(ntryL,G1H16(231),wf4(:,14),G1H4(125),m3h4x4(:,279),heltab2x16(:,:,407))
  call Hloop_VV_S(ntryL,G1H16(232),wf4(:,14),G1H4(126),m3h4x4(:,280),heltab2x16(:,:,408))
  call Hloop_UW_V(ntryL,G0H16(93),16,wf4(:,13),3,G1H4(129),m3h4x4(:,281),heltab2x16(:,:,409))
  call Hloop_UV_W(ntryL,G0H16(94),16,wf4(:,13),3,G1H4(130),m3h4x4(:,282),heltab2x16(:,:,410))
  call Hloop_UW_V(ntryL,G0H16(95),16,wf4(:,14),3,G1H4(179),m3h4x4(:,283),heltab2x16(:,:,411))
  call Hloop_UV_W(ntryL,G0H16(96),16,wf4(:,14),3,G1H4(180),m3h4x4(:,284),heltab2x16(:,:,412))
  call Hloop_SV_V(ntryL,G0H16(98),wf4(:,13),G0H4(33),m3h4x4(:,285),heltab2x16(:,:,413))
  call Hloop_SV_V(ntryL,G0H16(100),wf4(:,14),G0H4(34),m3h4x4(:,286),heltab2x16(:,:,414))
  call Hloop_VV_S(ntryL,G0H16(102),wf4(:,13),G0H4(35),m3h4x4(:,287),heltab2x16(:,:,415))
  call Hloop_VV_S(ntryL,G0H16(104),wf4(:,14),G0H4(36),m3h4x4(:,288),heltab2x16(:,:,416))
  call Hloop_SV_T(ntryL,G0H16(105),16,wf4(:,13),3,G1H4(183),m3h4x4(:,289),heltab2x16(:,:,417))
  call Hloop_TV_S(ntryL,G0H16(106),16,wf4(:,13),3,G1H4(184),m3h4x4(:,290),heltab2x16(:,:,418))
  call Hloop_SV_T(ntryL,G0H16(107),16,wf4(:,14),3,G1H4(185),m3h4x4(:,291),heltab2x16(:,:,419))
  call Hloop_TV_S(ntryL,G0H16(108),16,wf4(:,14),3,G1H4(186),m3h4x4(:,292),heltab2x16(:,:,420))
  call Hloop_SV_V(ntryL,G1H16(233),wf4(:,13),G1H4(189),m3h4x4(:,293),heltab2x16(:,:,421))
  call Hloop_SV_V(ntryL,G1H16(234),wf4(:,13),G1H4(190),m3h4x4(:,294),heltab2x16(:,:,422))
  call Hloop_SV_V(ntryL,G1H16(235),wf4(:,14),G1H4(191),m3h4x4(:,295),heltab2x16(:,:,423))
  call Hloop_SV_V(ntryL,G1H16(236),wf4(:,14),G1H4(192),m3h4x4(:,296),heltab2x16(:,:,424))
  call Hloop_UW_V(ntryL,G1H16(237),16,wf4(:,13),3,G2H4(181),m3h4x4(:,297),heltab2x16(:,:,425))
  call Hloop_UV_W(ntryL,G1H16(238),16,wf4(:,13),3,G2H4(182),m3h4x4(:,298),heltab2x16(:,:,426))
  call Hloop_UW_V(ntryL,G1H16(239),16,wf4(:,14),3,G2H4(183),m3h4x4(:,299),heltab2x16(:,:,427))
  call Hloop_UV_W(ntryL,G1H16(240),16,wf4(:,14),3,G2H4(184),m3h4x4(:,300),heltab2x16(:,:,428))
  call Hloop_VV_S(ntryL,G1H16(241),wf4(:,13),G1H4(195),m3h4x4(:,301),heltab2x16(:,:,429))
  call Hloop_VV_S(ntryL,G1H16(242),wf4(:,13),G1H4(196),m3h4x4(:,302),heltab2x16(:,:,430))
  call Hloop_VV_S(ntryL,G1H16(243),wf4(:,14),G1H4(197),m3h4x4(:,303),heltab2x16(:,:,431))
  call Hloop_VV_S(ntryL,G1H16(244),wf4(:,14),G1H4(198),m3h4x4(:,304),heltab2x16(:,:,432))
  call Hloop_UW_V(ntryL,G0H16(109),16,wf4(:,13),3,G1H4(201),m3h4x4(:,305),heltab2x16(:,:,433))
  call Hloop_UV_W(ntryL,G0H16(110),16,wf4(:,13),3,G1H4(202),m3h4x4(:,306),heltab2x16(:,:,434))
  call Hloop_UW_V(ntryL,G0H16(111),16,wf4(:,14),3,G1H4(203),m3h4x4(:,307),heltab2x16(:,:,435))
  call Hloop_UV_W(ntryL,G0H16(112),16,wf4(:,14),3,G1H4(204),m3h4x4(:,308),heltab2x16(:,:,436))
  call Hloop_SV_V(ntryL,G0H16(113),wf4(:,13),G0H4(37),m3h4x4(:,309),heltab2x16(:,:,437))
  call Hloop_SV_V(ntryL,G0H16(114),wf4(:,13),G0H4(38),m3h4x4(:,310),heltab2x16(:,:,438))
  call Hloop_SV_V(ntryL,G0H16(115),wf4(:,14),G0H4(39),m3h4x4(:,311),heltab2x16(:,:,439))
  call Hloop_SV_V(ntryL,G0H16(116),wf4(:,14),G0H4(40),m3h4x4(:,312),heltab2x16(:,:,440))
  call Hloop_QV_A(ntryL,G1H16(245),ex3(:),G1H8(50),m3h2x8(:,129),heltab2x16(:,:,441))
  call Hloop_Q_A(ntryL,G1H8(50),20,nME,G2H8(5),n2h8(121))
  call Hloop_QV_A(ntryL,G1H16(246),ex3(:),G1H8(47),m3h2x8(:,130),heltab2x16(:,:,442))
  call Hloop_Q_A(ntryL,G1H8(47),20,nMM,G2H8(6),n2h8(122))
  call Hloop_QV_A(ntryL,G1H16(247),ex3(:),G1H8(48),m3h2x8(:,131),heltab2x16(:,:,443))
  call Hloop_Q_A(ntryL,G1H8(48),20,nML,G2H8(7),n2h8(123))
  call Hloop_AV_Q(ntryL,G1H16(248),ex3(:),G1H8(52),m3h2x8(:,132),heltab2x16(:,:,444))
  call Hloop_A_Q(ntryL,G1H8(52),20,nME,G2H8(8),n2h8(124))
  call Hloop_AV_Q(ntryL,G1H16(249),ex3(:),G1H8(58),m3h2x8(:,133),heltab2x16(:,:,445))
  call Hloop_A_Q(ntryL,G1H8(58),20,nMM,G2H8(9),n2h8(125))
  call Hloop_AV_Q(ntryL,G1H16(250),ex3(:),G1H8(57),m3h2x8(:,134),heltab2x16(:,:,446))
  call Hloop_A_Q(ntryL,G1H8(57),20,nML,G2H8(12),n2h8(126))
  call Hloop_QV_A(ntryL,G1H16(251),ex3(:),G1H8(61),m3h2x8(:,135),heltab2x16(:,:,447))
  call Hloop_Q_A(ntryL,G1H8(61),20,nMT,G2H8(10),n2h8(127))
  call Hloop_AV_Q(ntryL,G1H16(252),ex3(:),G1H8(62),m3h2x8(:,136),heltab2x16(:,:,448))
  call Hloop_A_Q(ntryL,G1H8(62),20,nMT,G2H8(11),n2h8(128))
  call Hloop_QV_A(ntryL,G1H16(253),ex3(:),G1H8(59),m3h2x8(:,137),heltab2x16(:,:,449))
  call Hloop_Q_A(ntryL,G1H8(59),20,nMB,G2H8(14),n2h8(129))
  call Hloop_AV_Q(ntryL,G1H16(254),ex3(:),G1H8(64),m3h2x8(:,138),heltab2x16(:,:,450))
  call Hloop_A_Q(ntryL,G1H8(64),20,nMB,G2H8(15),n2h8(130))
  call Hloop_QV_A(ntryL,G1H16(255),ex3(:),G1H8(63),m3h2x8(:,139),heltab2x16(:,:,451))
  call Hloop_Q_A(ntryL,G1H8(63),20,nME,G2H8(13),n2h8(131))
  call Hloop_QV_A(ntryL,G1H16(256),ex3(:),G1H8(3),m3h2x8(:,140),heltab2x16(:,:,452))
  call Hloop_Q_A(ntryL,G1H8(3),20,nMM,G2H8(16),n2h8(132))
  call Hloop_QV_A(ntryL,G1H16(257),ex3(:),G1H8(5),m3h2x8(:,141),heltab2x16(:,:,453))
  call Hloop_Q_A(ntryL,G1H8(5),20,nML,G2H8(17),n2h8(133))
  call Hloop_AV_Q(ntryL,G1H16(258),ex3(:),G1H8(7),m3h2x8(:,142),heltab2x16(:,:,454))
  call Hloop_A_Q(ntryL,G1H8(7),20,nME,G2H8(18),n2h8(134))
  call Hloop_AV_Q(ntryL,G1H16(259),ex3(:),G1H8(9),m3h2x8(:,143),heltab2x16(:,:,455))
  call Hloop_A_Q(ntryL,G1H8(9),20,nMM,G2H8(19),n2h8(135))
  call Hloop_AV_Q(ntryL,G1H16(260),ex3(:),G1H8(10),m3h2x8(:,144),heltab2x16(:,:,456))
  call Hloop_A_Q(ntryL,G1H8(10),20,nML,G2H8(20),n2h8(136))
  call Hloop_QV_A(ntryL,G1H16(261),ex3(:),G1H8(11),m3h2x8(:,145),heltab2x16(:,:,457))
  call Hloop_Q_A(ntryL,G1H8(11),20,nMT,G2H8(21),n2h8(137))
  call Hloop_AV_Q(ntryL,G1H16(262),ex3(:),G1H8(2),m3h2x8(:,146),heltab2x16(:,:,458))
  call Hloop_A_Q(ntryL,G1H8(2),20,nMT,G2H8(22),n2h8(138))
  call Hloop_QV_A(ntryL,G1H16(263),ex3(:),G1H8(18),m3h2x8(:,147),heltab2x16(:,:,459))
  call Hloop_Q_A(ntryL,G1H8(18),20,nMB,G2H8(23),n2h8(139))
  call Hloop_AV_Q(ntryL,G1H16(264),ex3(:),G1H8(22),m3h2x8(:,148),heltab2x16(:,:,460))
  call Hloop_A_Q(ntryL,G1H8(22),20,nMB,G2H8(24),n2h8(140))
  call Hloop_TV_S(ntryL,G1H16(265),16,ex3(:),4,G2H8(25),m3h2x8(:,149),heltab2x16(:,:,461))
  call Hloop_SV_T(ntryL,G1H16(266),16,ex3(:),4,G2H8(28),m3h2x8(:,150),heltab2x16(:,:,462))
  call Hloop_CV_D(ntryL,G1H16(269),16,ex3(:),4,G2H8(26),m3h2x8(:,151),heltab2x16(:,:,463))
  call Hloop_DV_C(ntryL,G1H16(270),16,ex3(:),G2H8(27),m3h2x8(:,152),heltab2x16(:,:,464))
  call Hloop_CV_D(ntryL,G1H16(273),16,ex3(:),4,G2H8(30),m3h2x8(:,153),heltab2x16(:,:,465))
  call Hloop_DV_C(ntryL,G1H16(274),16,ex3(:),G2H8(31),m3h2x8(:,154),heltab2x16(:,:,466))
  call Hloop_UV_W(ntryL,G1H16(275),16,ex3(:),4,G2H8(29),m3h2x8(:,155),heltab2x16(:,:,467))
  call Hloop_UW_V(ntryL,G1H16(276),16,ex3(:),4,G2H8(32),m3h2x8(:,156),heltab2x16(:,:,468))
  call Hloop_TV_S(ntryL,G1H16(277),16,ex3(:),4,G2H8(33),m3h2x8(:,157),heltab2x16(:,:,469))
  call Hloop_SV_T(ntryL,G1H16(278),16,ex3(:),4,G2H8(37),m3h2x8(:,158),heltab2x16(:,:,470))
  call Hloop_TV_S(ntryL,G1H16(279),16,ex3(:),4,G2H8(34),m3h2x8(:,159),heltab2x16(:,:,471))
  call Hloop_SV_T(ntryL,G1H16(280),16,ex3(:),4,G2H8(35),m3h2x8(:,160),heltab2x16(:,:,472))
  call Hloop_TV_S(ntryL,G0H16(117),16,ex3(:),4,G1H8(38),m3h2x8(:,161),heltab2x16(:,:,473))
  call Hloop_SV_T(ntryL,G0H16(118),16,ex3(:),4,G1H8(45),m3h2x8(:,162),heltab2x16(:,:,474))
  call Hloop_SV_V(ntryL,G1H16(281),ex3(:),G1H8(51),m3h2x8(:,163),heltab2x16(:,:,475))
  call Hloop_SV_V(ntryL,G1H16(282),ex3(:),G1H8(60),m3h2x8(:,164),heltab2x16(:,:,476))
  call Hloop_SV_V(ntryL,G1H16(283),ex3(:),G1H8(8),m3h2x8(:,165),heltab2x16(:,:,477))
  call Hloop_SV_V(ntryL,G1H16(284),ex3(:),G1H8(33),m3h2x8(:,166),heltab2x16(:,:,478))
  call Hloop_VV_S(ntryL,G0H16(119),ex3(:),G0H8(16),m3h2x8(:,167),heltab2x16(:,:,479))
  call Hloop_VV_S(ntryL,G0H16(120),ex3(:),G0H8(8),m3h2x8(:,168),heltab2x16(:,:,480))
  call Hloop_TV_S(ntryL,G0H16(121),16,ex3(:),4,G1H8(37),m3h2x8(:,169),heltab2x16(:,:,481))
  call Hloop_SV_T(ntryL,G0H16(122),16,ex3(:),4,G1H8(40),m3h2x8(:,170),heltab2x16(:,:,482))
  call Hloop_TV_S(ntryL,G0H16(123),16,ex3(:),4,G1H8(49),m3h2x8(:,171),heltab2x16(:,:,483))
  call Hloop_SV_T(ntryL,G0H16(124),16,ex3(:),4,G1H8(50),m3h2x8(:,172),heltab2x16(:,:,484))
  call Hloop_SV_V(ntryL,G1H16(286),ex3(:),G1H8(47),m3h2x8(:,173),heltab2x16(:,:,485))
  call Hloop_SV_V(ntryL,G0H16(126),ex3(:),G0H8(10),m3h2x8(:,174),heltab2x16(:,:,486))
  call Hloop_SV_V(ntryL,G0H16(128),ex3(:),G0H8(11),m3h2x8(:,175),heltab2x16(:,:,487))
  call Hloop_VV_S(ntryL,G0H16(130),ex3(:),G0H8(12),m3h2x8(:,176),heltab2x16(:,:,488))
  call Hloop_VV_S(ntryL,G0H16(132),ex3(:),G0H8(9),m3h2x8(:,177),heltab2x16(:,:,489))
  call Hloop_VV_S(ntryL,G1H16(288),ex3(:),G1H8(48),m3h2x8(:,178),heltab2x16(:,:,490))
  call Hloop_UV_W(ntryL,G0H16(133),16,ex3(:),4,G1H8(52),m3h2x8(:,179),heltab2x16(:,:,491))
  call Hloop_UW_V(ntryL,G0H16(134),16,ex3(:),4,G1H8(58),m3h2x8(:,180),heltab2x16(:,:,492))
  call Hloop_UV_W(ntryL,G0H16(135),16,ex3(:),4,G1H8(57),m3h2x8(:,181),heltab2x16(:,:,493))
  call Hloop_UW_V(ntryL,G0H16(136),16,ex3(:),4,G1H8(61),m3h2x8(:,182),heltab2x16(:,:,494))
  call Hloop_SV_V(ntryL,G0H16(137),ex3(:),G0H8(1),m3h2x8(:,183),heltab2x16(:,:,495))
  call Hloop_SV_V(ntryL,G0H16(138),ex3(:),G0H8(2),m3h2x8(:,184),heltab2x16(:,:,496))
  call Hloop_VV_S(ntryL,G1H16(289),ex3(:),G1H8(62),m3h2x8(:,185),heltab2x16(:,:,497))
  call Hloop_VV_S(ntryL,G1H16(290),ex3(:),G1H8(59),m3h2x8(:,186),heltab2x16(:,:,498))
  call Hloop_VV_S(ntryL,G1H16(291),ex3(:),G1H8(64),m3h2x8(:,187),heltab2x16(:,:,499))
  call Hloop_VV_S(ntryL,G1H16(292),ex3(:),G1H8(63),m3h2x8(:,188),heltab2x16(:,:,500))
  call Hloop_UV_W(ntryL,G0H16(139),16,ex3(:),4,G1H8(3),m3h2x8(:,189),heltab2x16(:,:,501))
  call Hloop_UW_V(ntryL,G0H16(140),16,ex3(:),4,G1H8(5),m3h2x8(:,190),heltab2x16(:,:,502))
  call Hloop_UV_W(ntryL,G1H16(293),16,ex3(:),4,G2H8(38),m3h2x8(:,191),heltab2x16(:,:,503))
  call Hloop_UW_V(ntryL,G1H16(294),16,ex3(:),4,G2H8(39),m3h2x8(:,192),heltab2x16(:,:,504))
  call Hloop_UV_W(ntryL,G1H16(295),16,ex3(:),4,G2H8(36),m3h2x8(:,193),heltab2x16(:,:,505))
  call Hloop_UW_V(ntryL,G1H16(296),16,ex3(:),4,G2H8(40),m3h2x8(:,194),heltab2x16(:,:,506))
  call Hloop_QV_A(ntryL,G1H16(297),ex3(:),G1H8(7),m3h2x8(:,195),heltab2x16(:,:,507))
  call Hloop_Q_A(ntryL,G1H8(7),20,nME,G2H8(41),n2h8(141))
  call Hloop_QV_A(ntryL,G1H16(298),ex3(:),G1H8(9),m3h2x8(:,196),heltab2x16(:,:,508))
  call Hloop_Q_A(ntryL,G1H8(9),20,nMM,G2H8(45),n2h8(142))
  call Hloop_QV_A(ntryL,G1H16(299),ex3(:),G1H8(10),m3h2x8(:,197),heltab2x16(:,:,509))
  call Hloop_Q_A(ntryL,G1H8(10),20,nML,G2H8(42),n2h8(143))
  call Hloop_AV_Q(ntryL,G1H16(300),ex3(:),G1H8(11),m3h2x8(:,198),heltab2x16(:,:,510))
  call Hloop_A_Q(ntryL,G1H8(11),20,nME,G2H8(43),n2h8(144))
  call Hloop_AV_Q(ntryL,G1H16(301),ex3(:),G1H8(2),m3h2x8(:,199),heltab2x16(:,:,511))
  call Hloop_A_Q(ntryL,G1H8(2),20,nMM,G2H8(46),n2h8(145))
  call Hloop_AV_Q(ntryL,G1H16(302),ex3(:),G1H8(18),m3h2x8(:,200),heltab2x16(:,:,512))
  call Hloop_A_Q(ntryL,G1H8(18),20,nML,G2H8(47),n2h8(146))
  call Hloop_QV_A(ntryL,G1H16(307),ex3(:),G1H8(22),m3h2x8(:,201),heltab2x16(:,:,513))
  call Hloop_Q_A(ntryL,G1H8(22),20,0,G2H8(44),n2h8(147))
  call Hloop_QV_A(ntryL,G1H16(304),ex3(:),G1H8(7),m3h2x8(:,202),heltab2x16(:,:,514))
  call Hloop_Q_A(ntryL,G1H8(7),20,nMT,G2H8(48),n2h8(148))
  call Hloop_AV_Q(ntryL,G1H16(309),ex3(:),G1H8(9),m3h2x8(:,203),heltab2x16(:,:,515))
  call Hloop_A_Q(ntryL,G1H8(9),20,0,G2H8(49),n2h8(149))
  call Hloop_AV_Q(ntryL,G1H16(306),ex3(:),G1H8(10),m3h2x8(:,204),heltab2x16(:,:,516))
  call Hloop_A_Q(ntryL,G1H8(10),20,nMT,G2H8(50),n2h8(150))
  call Hloop_QV_A(ntryL,G1H16(308),ex3(:),G1H8(11),m3h2x8(:,205),heltab2x16(:,:,517))
  call Hloop_Q_A(ntryL,G1H8(11),20,nMB,G2H8(51),n2h8(151))
  call Hloop_AV_Q(ntryL,G1H16(310),ex3(:),G1H8(2),m3h2x8(:,206),heltab2x16(:,:,518))
  call Hloop_A_Q(ntryL,G1H8(2),20,nMB,G2H8(52),n2h8(152))
  call Hloop_QV_A(ntryL,G1H16(311),ex3(:),G1H8(18),m3h2x8(:,207),heltab2x16(:,:,519))
  call Hloop_Q_A(ntryL,G1H8(18),20,nME,G2H8(53),n2h8(153))
  call Hloop_QV_A(ntryL,G1H16(312),ex3(:),G1H8(22),m3h2x8(:,208),heltab2x16(:,:,520))
  call Hloop_Q_A(ntryL,G1H8(22),20,nMM,G2H8(54),n2h8(154))
  call Hloop_QV_A(ntryL,G1H16(313),ex3(:),G1H8(7),m3h2x8(:,209),heltab2x16(:,:,521))
  call Hloop_Q_A(ntryL,G1H8(7),20,nML,G2H8(55),n2h8(155))
  call Hloop_AV_Q(ntryL,G1H16(314),ex3(:),G1H8(9),m3h2x8(:,210),heltab2x16(:,:,522))
  call Hloop_A_Q(ntryL,G1H8(9),20,nME,G2H8(56),n2h8(156))
  call Hloop_AV_Q(ntryL,G1H16(315),ex3(:),G1H8(10),m3h2x8(:,211),heltab2x16(:,:,523))
  call Hloop_A_Q(ntryL,G1H8(10),20,nMM,G2H8(57),n2h8(157))
  call Hloop_AV_Q(ntryL,G1H16(316),ex3(:),G1H8(11),m3h2x8(:,212),heltab2x16(:,:,524))
  call Hloop_A_Q(ntryL,G1H8(11),20,nML,G2H8(58),n2h8(158))
  call Hloop_QV_A(ntryL,G1H16(317),ex3(:),G1H8(2),m3h2x8(:,213),heltab2x16(:,:,525))
  call Hloop_Q_A(ntryL,G1H8(2),20,0,G2H8(59),n2h8(159))
  call Hloop_QV_A(ntryL,G1H16(318),ex3(:),G1H8(18),m3h2x8(:,214),heltab2x16(:,:,526))
  call Hloop_Q_A(ntryL,G1H8(18),20,nMT,G2H8(60),n2h8(160))
  call Hloop_AV_Q(ntryL,G1H16(319),ex3(:),G1H8(22),m3h2x8(:,215),heltab2x16(:,:,527))
  call Hloop_A_Q(ntryL,G1H8(22),20,0,G2H8(61),n2h8(161))
  call Hloop_AV_Q(ntryL,G1H16(320),ex3(:),G1H8(7),m3h2x8(:,216),heltab2x16(:,:,528))
  call Hloop_A_Q(ntryL,G1H8(7),20,nMT,G2H8(62),n2h8(162))
  call Hloop_QV_A(ntryL,G1H16(321),ex3(:),G1H8(9),m3h2x8(:,217),heltab2x16(:,:,529))
  call Hloop_Q_A(ntryL,G1H8(9),20,0,G2H8(63),n2h8(163))
  call Hloop_QV_A(ntryL,G1H16(322),ex3(:),G1H8(10),m3h2x8(:,218),heltab2x16(:,:,530))
  call Hloop_Q_A(ntryL,G1H8(10),20,nMB,G2H8(64),n2h8(164))
  call Hloop_AV_Q(ntryL,G1H16(323),ex3(:),G1H8(11),m3h2x8(:,219),heltab2x16(:,:,531))
  call Hloop_A_Q(ntryL,G1H8(11),20,0,G2H8(65),n2h8(165))
  call Hloop_AV_Q(ntryL,G1H16(324),ex3(:),G1H8(2),m3h2x8(:,220),heltab2x16(:,:,532))
  call Hloop_A_Q(ntryL,G1H8(2),20,nMB,G2H8(66),n2h8(166))
  call Hloop_TV_S(ntryL,G1H16(325),16,ex3(:),4,G2H8(67),m3h2x8(:,221),heltab2x16(:,:,533))
  call Hloop_SV_T(ntryL,G1H16(326),16,ex3(:),4,G2H8(68),m3h2x8(:,222),heltab2x16(:,:,534))
  call Hloop_TV_S(ntryL,G1H16(327),16,ex3(:),4,G2H8(69),m3h2x8(:,223),heltab2x16(:,:,535))
  call Hloop_SV_T(ntryL,G1H16(328),16,ex3(:),4,G2H8(70),m3h2x8(:,224),heltab2x16(:,:,536))
  call Hloop_CV_D(ntryL,G1H16(331),16,ex3(:),4,G2H8(71),m3h2x8(:,225),heltab2x16(:,:,537))
  call Hloop_DV_C(ntryL,G1H16(332),16,ex3(:),G2H8(72),m3h2x8(:,226),heltab2x16(:,:,538))
  call Hloop_CV_D(ntryL,G1H16(335),16,ex3(:),4,G2H8(73),m3h2x8(:,227),heltab2x16(:,:,539))
  call Hloop_DV_C(ntryL,G1H16(336),16,ex3(:),G2H8(74),m3h2x8(:,228),heltab2x16(:,:,540))
  call Hloop_UV_W(ntryL,G1H16(337),16,ex3(:),4,G2H8(75),m3h2x8(:,229),heltab2x16(:,:,541))
  call Hloop_UW_V(ntryL,G1H16(338),16,ex3(:),4,G2H8(76),m3h2x8(:,230),heltab2x16(:,:,542))
  call Hloop_UV_W(ntryL,G1H16(339),16,ex3(:),4,G2H8(77),m3h2x8(:,231),heltab2x16(:,:,543))
  call Hloop_UW_V(ntryL,G1H16(340),16,ex3(:),4,G2H8(78),m3h2x8(:,232),heltab2x16(:,:,544))
  call Hloop_TV_S(ntryL,G1H16(341),16,ex3(:),4,G2H8(79),m3h2x8(:,233),heltab2x16(:,:,545))
  call Hloop_SV_T(ntryL,G1H16(342),16,ex3(:),4,G2H8(80),m3h2x8(:,234),heltab2x16(:,:,546))
  call Hloop_TV_S(ntryL,G1H16(343),16,ex3(:),4,G2H8(81),m3h2x8(:,235),heltab2x16(:,:,547))
  call Hloop_SV_T(ntryL,G1H16(344),16,ex3(:),4,G2H8(82),m3h2x8(:,236),heltab2x16(:,:,548))
  call Hloop_TV_S(ntryL,G0H16(141),16,ex3(:),4,G1H8(18),m3h2x8(:,237),heltab2x16(:,:,549))
  call Hloop_SV_T(ntryL,G0H16(142),16,ex3(:),4,G1H8(22),m3h2x8(:,238),heltab2x16(:,:,550))
  call Hloop_TV_S(ntryL,G0H16(143),16,ex3(:),4,G1H8(7),m3h2x8(:,239),heltab2x16(:,:,551))
  call Hloop_SV_T(ntryL,G0H16(144),16,ex3(:),4,G1H8(9),m3h2x8(:,240),heltab2x16(:,:,552))
  call Hloop_SV_V(ntryL,G1H16(345),ex3(:),G1H8(10),m3h2x8(:,241),heltab2x16(:,:,553))
  call Hloop_SV_V(ntryL,G1H16(346),ex3(:),G1H8(11),m3h2x8(:,242),heltab2x16(:,:,554))
  call Hloop_SV_V(ntryL,G1H16(347),ex3(:),G1H8(2),m3h2x8(:,243),heltab2x16(:,:,555))
  call Hloop_SV_V(ntryL,G1H16(348),ex3(:),G1H8(66),m3h2x8(:,244),heltab2x16(:,:,556))
  call Hloop_VV_S(ntryL,G0H16(145),ex3(:),G0H8(3),m3h2x8(:,245),heltab2x16(:,:,557))
  call Hloop_VV_S(ntryL,G0H16(146),ex3(:),G0H8(4),m3h2x8(:,246),heltab2x16(:,:,558))
  call Hloop_VV_S(ntryL,G0H16(147),ex3(:),G0H8(5),m3h2x8(:,247),heltab2x16(:,:,559))
  call Hloop_VV_S(ntryL,G0H16(148),ex3(:),G0H8(7),m3h2x8(:,248),heltab2x16(:,:,560))
  call Hloop_TV_S(ntryL,G0H16(149),16,ex3(:),4,G1H8(67),m3h2x8(:,249),heltab2x16(:,:,561))
  call Hloop_SV_T(ntryL,G0H16(150),16,ex3(:),4,G1H8(68),m3h2x8(:,250),heltab2x16(:,:,562))
  call Hloop_TV_S(ntryL,G0H16(151),16,ex3(:),4,G1H8(69),m3h2x8(:,251),heltab2x16(:,:,563))
  call Hloop_SV_T(ntryL,G0H16(152),16,ex3(:),4,G1H8(70),m3h2x8(:,252),heltab2x16(:,:,564))
  call Hloop_SV_V(ntryL,G1H16(349),ex3(:),G1H8(71),m3h2x8(:,253),heltab2x16(:,:,565))
  call Hloop_SV_V(ntryL,G1H16(350),ex3(:),G1H8(72),m3h2x8(:,254),heltab2x16(:,:,566))
  call Hloop_SV_V(ntryL,G1H16(351),ex3(:),G1H8(73),m3h2x8(:,255),heltab2x16(:,:,567))
  call Hloop_SV_V(ntryL,G1H16(352),ex3(:),G1H8(74),m3h2x8(:,256),heltab2x16(:,:,568))
  call Hloop_SV_V(ntryL,G0H16(154),ex3(:),G0H8(6),m3h2x8(:,257),heltab2x16(:,:,569))
  call Hloop_SV_V(ntryL,G0H16(156),ex3(:),G0H8(33),m3h2x8(:,258),heltab2x16(:,:,570))
  call Hloop_VV_S(ntryL,G0H16(158),ex3(:),G0H8(13),m3h2x8(:,259),heltab2x16(:,:,571))
  call Hloop_VV_S(ntryL,G0H16(160),ex3(:),G0H8(14),m3h2x8(:,260),heltab2x16(:,:,572))
  call Hloop_VV_S(ntryL,G1H16(353),ex3(:),G1H8(75),m3h2x8(:,261),heltab2x16(:,:,573))
  call Hloop_VV_S(ntryL,G1H16(354),ex3(:),G1H8(76),m3h2x8(:,262),heltab2x16(:,:,574))
  call Hloop_VV_S(ntryL,G1H16(355),ex3(:),G1H8(77),m3h2x8(:,263),heltab2x16(:,:,575))
  call Hloop_VV_S(ntryL,G1H16(356),ex3(:),G1H8(78),m3h2x8(:,264),heltab2x16(:,:,576))
  call Hloop_UV_W(ntryL,G0H16(161),16,ex3(:),4,G1H8(79),m3h2x8(:,265),heltab2x16(:,:,577))
  call Hloop_UW_V(ntryL,G0H16(162),16,ex3(:),4,G1H8(80),m3h2x8(:,266),heltab2x16(:,:,578))
  call Hloop_UV_W(ntryL,G0H16(163),16,ex3(:),4,G1H8(81),m3h2x8(:,267),heltab2x16(:,:,579))
  call Hloop_UW_V(ntryL,G0H16(164),16,ex3(:),4,G1H8(82),m3h2x8(:,268),heltab2x16(:,:,580))
  call Hloop_SV_V(ntryL,G0H16(165),ex3(:),G0H8(15),m3h2x8(:,269),heltab2x16(:,:,581))
  call Hloop_SV_V(ntryL,G0H16(166),ex3(:),G0H8(34),m3h2x8(:,270),heltab2x16(:,:,582))
  call Hloop_SV_V(ntryL,G0H16(167),ex3(:),G0H8(35),m3h2x8(:,271),heltab2x16(:,:,583))
  call Hloop_SV_V(ntryL,G0H16(168),ex3(:),G0H8(36),m3h2x8(:,272),heltab2x16(:,:,584))
  call Hloop_VV_S(ntryL,G1H16(357),ex3(:),G1H8(83),m3h2x8(:,273),heltab2x16(:,:,585))
  call Hloop_VV_S(ntryL,G1H16(358),ex3(:),G1H8(84),m3h2x8(:,274),heltab2x16(:,:,586))
  call Hloop_VV_S(ntryL,G1H16(359),ex3(:),G1H8(85),m3h2x8(:,275),heltab2x16(:,:,587))
  call Hloop_VV_S(ntryL,G1H16(360),ex3(:),G1H8(86),m3h2x8(:,276),heltab2x16(:,:,588))
  call Hloop_UV_W(ntryL,G0H16(169),16,ex3(:),4,G1H8(87),m3h2x8(:,277),heltab2x16(:,:,589))
  call Hloop_UW_V(ntryL,G0H16(170),16,ex3(:),4,G1H8(88),m3h2x8(:,278),heltab2x16(:,:,590))
  call Hloop_UV_W(ntryL,G0H16(171),16,ex3(:),4,G1H8(89),m3h2x8(:,279),heltab2x16(:,:,591))
  call Hloop_UW_V(ntryL,G0H16(172),16,ex3(:),4,G1H8(90),m3h2x8(:,280),heltab2x16(:,:,592))
  call Hloop_UV_W(ntryL,G1H16(361),16,ex3(:),4,G2H8(83),m3h2x8(:,281),heltab2x16(:,:,593))
  call Hloop_UW_V(ntryL,G1H16(362),16,ex3(:),4,G2H8(84),m3h2x8(:,282),heltab2x16(:,:,594))
  call Hloop_UV_W(ntryL,G1H16(363),16,ex3(:),4,G2H8(85),m3h2x8(:,283),heltab2x16(:,:,595))
  call Hloop_UW_V(ntryL,G1H16(364),16,ex3(:),4,G2H8(86),m3h2x8(:,284),heltab2x16(:,:,596))
  call Hloop_AQ_S(ntryL,G1H16(365),wf4(:,3),G1H4(207),ngH,m3h4x4(:,313),heltab2x16(:,:,597))
  call Hloop_AQ_S(ntryL,G1H16(366),wf4(:,3),G1H4(208),ngX,m3h4x4(:,314),heltab2x16(:,:,598))
  call Hloop_SQ_A(ntryL,G1H16(367),wf4(:,3),G1H4(39),ngPnl,m3h4x4(:,315),heltab2x16(:,:,599))
  call Hloop_Q_A(ntryL,G1H4(39),21,0,G2H4(185),n2h4(201))
  call Hloop_AQ_V(ntryL,G1H16(368),wf4(:,3),G1H4(40),m3h4x4(:,316),heltab2x16(:,:,600))
  call Hloop_AQ_Z(ntryL,G1H16(369),wf4(:,3),G1H4(41),ngZl,m3h4x4(:,317),heltab2x16(:,:,601))
  call Hloop_WQ_A(ntryL,G0H16(173),wf4(:,3),G0H4(41),m3h4x4(:,318),heltab2x16(:,:,602))
  call Hloop_Q_A(ntryL,G0H4(41),21,0,G1H4(42),n2h4(202))
  call Hloop_SQ_A(ntryL,G0H16(174),wf4(:,3),G0H4(41),ngPnl,m3h4x4(:,319),heltab2x16(:,:,603))
  call Hloop_Q_A(ntryL,G0H4(41),21,0,G1H4(45),n2h4(203))
  call Hloop_SQ_A(ntryL,G1H16(370),wf4(:,3),G1H4(46),ngPnl,m3h4x4(:,320),heltab2x16(:,:,604))
  call Hloop_Q_A(ntryL,G1H4(46),21,0,G2H4(186),n2h4(204))
  call Hloop_WQ_A(ntryL,G1H16(371),wf4(:,3),G1H4(47),m3h4x4(:,321),heltab2x16(:,:,605))
  call Hloop_Q_A(ntryL,G1H4(47),21,0,G2H4(187),n2h4(205))
  call Hloop_WQ_A(ntryL,G0H16(175),wf4(:,3),G0H4(41),m3h4x4(:,322),heltab2x16(:,:,606))
  call Hloop_Q_A(ntryL,G0H4(41),21,0,G1H4(48),n2h4(206))
  call Hloop_SQ_A(ntryL,G0H16(176),wf4(:,3),G0H4(41),ngPnl,m3h4x4(:,323),heltab2x16(:,:,607))
  call Hloop_Q_A(ntryL,G0H4(41),21,0,G1H4(51),n2h4(207))
  call Hloop_WQ_A(ntryL,G1H16(372),wf4(:,3),G1H4(52),m3h4x4(:,324),heltab2x16(:,:,608))
  call Hloop_Q_A(ntryL,G1H4(52),21,0,G2H4(188),n2h4(208))
  call Hloop_QA_S(ntryL,G1H16(373),ex2(:),G1H8(91),ngH,m3h2x8(:,285),heltab2x16(:,:,609))
  call Hloop_QA_S(ntryL,G1H16(374),ex2(:),G1H8(92),ngX,m3h2x8(:,286),heltab2x16(:,:,610))
  call Hloop_SA_Q(ntryL,G1H16(375),ex2(:),G1H8(93),ngPln,m3h2x8(:,287),heltab2x16(:,:,611))
  call Hloop_A_Q(ntryL,G1H8(93),18,0,G2H8(87),n2h8(167))
  call Hloop_QA_V(ntryL,G1H16(376),ex2(:),G1H8(93),m3h2x8(:,288),heltab2x16(:,:,612))
  call Hloop_QA_Z(ntryL,G1H16(377),ex2(:),G1H8(94),ngZl,m3h2x8(:,289),heltab2x16(:,:,613))
  call Hloop_SA_Q(ntryL,G1H16(378),ex2(:),G1H8(95),ngPln,m3h2x8(:,290),heltab2x16(:,:,614))
  call Hloop_A_Q(ntryL,G1H8(95),18,0,G2H8(88),n2h8(168))
  call Hloop_SA_Q(ntryL,G0H16(177),ex2(:),G0H8(37),ngPln,m3h2x8(:,291),heltab2x16(:,:,615))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(95),n2h8(169))
  call Hloop_WA_Q(ntryL,G0H16(178),ex2(:),G0H8(37),m3h2x8(:,292),heltab2x16(:,:,616))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(96),n2h8(170))
  call Hloop_SA_Q(ntryL,G0H16(179),ex2(:),G0H8(37),ngPln,m3h2x8(:,293),heltab2x16(:,:,617))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(97),n2h8(171))
  call Hloop_WA_Q(ntryL,G0H16(180),ex2(:),G0H8(37),m3h2x8(:,294),heltab2x16(:,:,618))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(98),n2h8(172))
  call Hloop_WA_Q(ntryL,G1H16(379),ex2(:),G1H8(99),m3h2x8(:,295),heltab2x16(:,:,619))
  call Hloop_A_Q(ntryL,G1H8(99),18,0,G2H8(89),n2h8(173))
  call Hloop_WA_Q(ntryL,G1H16(380),ex2(:),G1H8(99),m3h2x8(:,296),heltab2x16(:,:,620))
  call Hloop_A_Q(ntryL,G1H8(99),18,0,G2H8(90),n2h8(174))
  call Hloop_QA_S(ntryL,G1H16(381),wf4(:,10),G1H4(53),ngH,m3h4x4(:,325),heltab2x16(:,:,621))
  call Hloop_QA_S(ntryL,G1H16(382),wf4(:,10),G1H4(54),ngX,m3h4x4(:,326),heltab2x16(:,:,622))
  call Hloop_SA_Q(ntryL,G1H16(383),wf4(:,10),G1H4(57),ngPln,m3h4x4(:,327),heltab2x16(:,:,623))
  call Hloop_A_Q(ntryL,G1H4(57),22,0,G2H4(189),n2h4(209))
  call Hloop_QA_V(ntryL,G1H16(384),wf4(:,10),G1H4(58),m3h4x4(:,328),heltab2x16(:,:,624))
  call Hloop_QA_Z(ntryL,G1H16(385),wf4(:,10),G1H4(93),ngZl,m3h4x4(:,329),heltab2x16(:,:,625))
  call Hloop_WA_Q(ntryL,G0H16(181),wf4(:,10),G0H4(41),m3h4x4(:,330),heltab2x16(:,:,626))
  call Hloop_A_Q(ntryL,G0H4(41),22,0,G1H4(94),n2h4(210))
  call Hloop_SA_Q(ntryL,G0H16(182),wf4(:,10),G0H4(41),ngPln,m3h4x4(:,331),heltab2x16(:,:,627))
  call Hloop_A_Q(ntryL,G0H4(41),22,0,G1H4(95),n2h4(211))
  call Hloop_SA_Q(ntryL,G1H16(386),wf4(:,10),G1H4(96),ngPln,m3h4x4(:,332),heltab2x16(:,:,628))
  call Hloop_A_Q(ntryL,G1H4(96),22,0,G2H4(190),n2h4(212))
  call Hloop_WA_Q(ntryL,G1H16(387),wf4(:,10),G1H4(99),m3h4x4(:,333),heltab2x16(:,:,629))
  call Hloop_A_Q(ntryL,G1H4(99),22,0,G2H4(191),n2h4(213))
  call Hloop_WA_Q(ntryL,G0H16(183),wf4(:,10),G0H4(41),m3h4x4(:,334),heltab2x16(:,:,630))
  call Hloop_A_Q(ntryL,G0H4(41),22,0,G1H4(100),n2h4(214))
  call Hloop_SA_Q(ntryL,G0H16(184),wf4(:,10),G0H4(41),ngPln,m3h4x4(:,335),heltab2x16(:,:,631))
  call Hloop_A_Q(ntryL,G0H4(41),22,0,G1H4(101),n2h4(215))
  call Hloop_WA_Q(ntryL,G1H16(388),wf4(:,10),G1H4(102),m3h4x4(:,336),heltab2x16(:,:,632))
  call Hloop_A_Q(ntryL,G1H4(102),22,0,G2H4(192),n2h4(216))
  call Hloop_AQ_S(ntryL,G1H16(389),ex1(:),G1H8(99),ngH,m3h2x8(:,297),heltab2x16(:,:,633))
  call Hloop_AQ_S(ntryL,G1H16(390),ex1(:),G1H8(100),ngX,m3h2x8(:,298),heltab2x16(:,:,634))
  call Hloop_SQ_A(ntryL,G1H16(391),ex1(:),G1H8(101),ngPnl,m3h2x8(:,299),heltab2x16(:,:,635))
  call Hloop_Q_A(ntryL,G1H8(101),17,0,G2H8(91),n2h8(175))
  call Hloop_AQ_V(ntryL,G1H16(392),ex1(:),G1H8(101),m3h2x8(:,300),heltab2x16(:,:,636))
  call Hloop_AQ_Z(ntryL,G1H16(393),ex1(:),G1H8(102),ngZl,m3h2x8(:,301),heltab2x16(:,:,637))
  call Hloop_SQ_A(ntryL,G1H16(394),ex1(:),G1H8(103),ngPnl,m3h2x8(:,302),heltab2x16(:,:,638))
  call Hloop_Q_A(ntryL,G1H8(103),17,0,G2H8(92),n2h8(176))
  call Hloop_SQ_A(ntryL,G0H16(185),ex1(:),G0H8(37),ngPnl,m3h2x8(:,303),heltab2x16(:,:,639))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(103),n2h8(177))
  call Hloop_WQ_A(ntryL,G0H16(186),ex1(:),G0H8(37),m3h2x8(:,304),heltab2x16(:,:,640))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(104),n2h8(178))
  call Hloop_SQ_A(ntryL,G0H16(187),ex1(:),G0H8(37),ngPnl,m3h2x8(:,305),heltab2x16(:,:,641))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(105),n2h8(179))
  call Hloop_WQ_A(ntryL,G0H16(188),ex1(:),G0H8(37),m3h2x8(:,306),heltab2x16(:,:,642))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(106),n2h8(180))
  call Hloop_WQ_A(ntryL,G1H16(395),ex1(:),G1H8(107),m3h2x8(:,307),heltab2x16(:,:,643))
  call Hloop_Q_A(ntryL,G1H8(107),17,0,G2H8(93),n2h8(181))
  call Hloop_WQ_A(ntryL,G1H16(396),ex1(:),G1H8(107),m3h2x8(:,308),heltab2x16(:,:,644))
  call Hloop_Q_A(ntryL,G1H8(107),17,0,G2H8(94),n2h8(182))
  call Hloop_QV_A(ntryL,G1H16(397),ex3(:),G1H8(107),m3h2x8(:,309),heltab2x16(:,:,645))
  call Hloop_Q_A(ntryL,G1H8(107),20,nML,G2H8(95),n2h8(183))
  call Hloop_QV_A(ntryL,G1H16(398),ex3(:),G1H8(107),m3h2x8(:,310),heltab2x16(:,:,646))
  call Hloop_Q_A(ntryL,G1H8(107),20,nML,G2H8(96),n2h8(184))
  call Hloop_TV_S(ntryL,G1H16(399),16,ex3(:),4,G2H8(97),m3h2x8(:,311),heltab2x16(:,:,647))
  call Hloop_QV_A(ntryL,G1H16(400),ex3(:),G1H8(107),m3h2x8(:,312),heltab2x16(:,:,648))
  call Hloop_Q_A(ntryL,G1H8(107),20,nML,G2H8(98),n2h8(185))
  call Hloop_QV_A(ntryL,G1H16(401),ex3(:),G1H8(107),m3h2x8(:,313),heltab2x16(:,:,649))
  call Hloop_Q_A(ntryL,G1H8(107),20,nML,G2H8(99),n2h8(186))
  call Hloop_TV_S(ntryL,G0H16(189),16,ex3(:),4,G1H8(107),m3h2x8(:,314),heltab2x16(:,:,650))
  call Hloop_VV_S(ntryL,G0H16(190),ex3(:),G0H8(37),m3h2x8(:,315),heltab2x16(:,:,651))
  call Hloop_SV_V(ntryL,G1H16(402),ex3(:),G1H8(108),m3h2x8(:,316),heltab2x16(:,:,652))
  call Hloop_VV_S(ntryL,G1H16(403),ex3(:),G1H8(109),m3h2x8(:,317),heltab2x16(:,:,653))
  call Hloop_SV_V(ntryL,G0H16(191),ex3(:),G0H8(38),m3h2x8(:,318),heltab2x16(:,:,654))



end subroutine vamp_2

end module ol_vamp_2_ppllj_ew_llxaaa_1_/**/REALKIND
