
module ol_vamp_1_ppllj_ew_llxaaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj_ew_llxaaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj_ew_llxaaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllj_ew_llxaaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllj_ew_llxaaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllj_ew_llxaaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllj_ew_llxaaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nML,nML,nMH,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nML,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nML,nML,nMZ,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nML,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nML,nML,0,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,nML,G1H16(4),n2h16(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nML,nML,nMZ,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nML,G1H16(5),n2h16(4))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,7),heltab2x32(:,:,7))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,8),heltab2x32(:,:,8))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,9),heltab2x32(:,:,9))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,10),heltab2x32(:,:,10))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,11),heltab2x32(:,:,11))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,12),heltab2x32(:,:,12))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,13),heltab2x32(:,:,13))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,14),heltab2x32(:,:,14))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,15),heltab2x32(:,:,15))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,16),heltab2x32(:,:,16))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,17),heltab2x32(:,:,17))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,18),heltab2x32(:,:,18))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,19),heltab2x32(:,:,19))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,20),heltab2x32(:,:,20))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,2,1,4,8],[nML,nMH,nML,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(9),16,nML,G1H16(13),n2h16(5))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,2,1,4,8],[nML,nMZ,nML,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(9),16,nML,G1H16(14),n2h16(6))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,23),heltab2x32(:,:,23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,2,1,4,8],[nML,0,nML,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(9),16,nML,G1H16(16),n2h16(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,2,1,4,8],[nML,nMZ,nML,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(9),16,nML,G1H16(17),n2h16(8))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,26),heltab2x32(:,:,26))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(18),m3h2x16(:,27),heltab2x32(:,:,27))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,28),heltab2x32(:,:,28))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,29),heltab2x32(:,:,29))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,30),heltab2x32(:,:,30))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,31),heltab2x32(:,:,31))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,32),heltab2x32(:,:,32))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,33),heltab2x32(:,:,33))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,34),heltab2x32(:,:,34))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,35),heltab2x32(:,:,35))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,36),heltab2x32(:,:,36))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,37),heltab2x32(:,:,37))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,38),heltab2x32(:,:,38))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,39),heltab2x32(:,:,39))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,40),heltab2x32(:,:,40))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,4,2,1,8],[nML,nML,nMH,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(17),16,nML,G1H16(25),n2h16(9))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,4,2,1,8],[nML,nML,nMZ,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G0H16(17),16,nML,G1H16(26),n2h16(10))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,43),heltab2x32(:,:,43))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,4,2,1,8],[nML,nML,0,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(17),16,nML,G1H16(28),n2h16(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,4,2,1,8],[nML,nML,nMZ,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G0H16(17),16,nML,G1H16(29),n2h16(12))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,46),heltab2x32(:,:,46))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,47),heltab2x32(:,:,47))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,48),heltab2x32(:,:,48))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,49),heltab2x32(:,:,49))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,50),heltab2x32(:,:,50))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,51),heltab2x32(:,:,51))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,52),heltab2x32(:,:,52))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,53),heltab2x32(:,:,53))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,54),heltab2x32(:,:,54))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,55),heltab2x32(:,:,55))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,56),heltab2x32(:,:,56))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,57),heltab2x32(:,:,57))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,58),heltab2x32(:,:,58))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,59),heltab2x32(:,:,59))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,60),heltab2x32(:,:,60))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,2,1,8,4],[nML,nMH,nML,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(25),16,nML,G1H16(37),n2h16(13))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,2,1,8,4],[nML,nMZ,nML,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(25),16,nML,G1H16(38),n2h16(14))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,63),heltab2x32(:,:,63))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,2,1,8,4],[nML,0,nML,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(25),16,nML,G1H16(40),n2h16(15))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,2,1,8,4],[nML,nMZ,nML,nML,nML],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(25),16,nML,G1H16(41),n2h16(16))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,66),heltab2x32(:,:,66))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,67),heltab2x32(:,:,67))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,68),heltab2x32(:,:,68))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,69),heltab2x32(:,:,69))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,70),heltab2x32(:,:,70))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,71),heltab2x32(:,:,71))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,72),heltab2x32(:,:,72))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,73),heltab2x32(:,:,73))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,74),heltab2x32(:,:,74))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,75),heltab2x32(:,:,75))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,76),heltab2x32(:,:,76))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,77),heltab2x32(:,:,77))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,78),heltab2x32(:,:,78))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,79),heltab2x32(:,:,79))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,80),heltab2x32(:,:,80))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,1,2,4,8],[nML,nMH,nML,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(33),16,nML,G1H16(49),n2h16(17))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,1,2,4,8],[nML,nMZ,nML,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(33),16,nML,G1H16(50),n2h16(18))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,83),heltab2x32(:,:,83))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,1,2,4,8],[nML,0,nML,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(33),16,nML,G1H16(52),n2h16(19))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,1,2,4,8],[nML,nMZ,nML,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G0H16(33),16,nML,G1H16(53),n2h16(20))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,86),heltab2x32(:,:,86))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,87),heltab2x32(:,:,87))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,88),heltab2x32(:,:,88))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,89),heltab2x32(:,:,89))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,90),heltab2x32(:,:,90))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,91),heltab2x32(:,:,91))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,92),heltab2x32(:,:,92))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,93),heltab2x32(:,:,93))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,94),heltab2x32(:,:,94))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,95),heltab2x32(:,:,95))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,96),heltab2x32(:,:,96))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,97),heltab2x32(:,:,97))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,98),heltab2x32(:,:,98))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,99),heltab2x32(:,:,99))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,100),heltab2x32(:,:,100))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,1,2,8,4],[nML,nMH,nML,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(41),16,nML,G1H16(61),n2h16(21))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,1,2,8,4],[nML,nMZ,nML,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(41),16,nML,G1H16(62),n2h16(22))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,103),heltab2x32(:,:,103))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,1,2,8,4],[nML,0,nML,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H16(41),16,nML,G1H16(64),n2h16(23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,1,2,8,4],[nML,nMZ,nML,nML,nML],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G0H16(41),16,nML,G1H16(65),n2h16(24))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,106),heltab2x32(:,:,106))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,107),heltab2x32(:,:,107))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(67),m3h2x16(:,108),heltab2x32(:,:,108))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,109),heltab2x32(:,:,109))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,110),heltab2x32(:,:,110))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,111),heltab2x32(:,:,111))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,112),heltab2x32(:,:,112))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,113),heltab2x32(:,:,113))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,114),heltab2x32(:,:,114))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,115),heltab2x32(:,:,115))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,116),heltab2x32(:,:,116))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,117),heltab2x32(:,:,117))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(71),m3h2x16(:,118),heltab2x32(:,:,118))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,119),heltab2x32(:,:,119))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(72),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,nML,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,nML,G2H8(2),n2h8(2))
  call Hloop_SV_T(ntryL,G1H16(3),16,ex3(:),4,G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AV_Q(ntryL,G1H16(4),ex3(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),20,nML,G2H8(4),n2h8(3))
  call Hloop_AV_Q(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),20,nML,G2H8(5),n2h8(4))
  call Hloop_SV_T(ntryL,G0H16(1),16,ex3(:),4,G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_VV_S(ntryL,G0H16(2),ex3(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_SV_T(ntryL,G1H16(6),16,ex3(:),4,G2H8(6),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_SV_V(ntryL,G1H16(7),ex3(:),G1H8(2),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_VV_S(ntryL,G1H16(8),ex3(:),G1H8(3),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_SV_T(ntryL,G0H16(3),16,ex3(:),4,G1H8(4),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_VV_S(ntryL,G0H16(4),ex3(:),G0H8(2),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_SV_V(ntryL,G0H16(5),ex3(:),G0H8(3),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_UW_V(ntryL,G0H16(6),16,ex3(:),4,G1H8(5),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_SV_V(ntryL,G1H16(9),ex3(:),G1H8(6),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_VV_S(ntryL,G1H16(10),ex3(:),G1H8(7),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_UW_V(ntryL,G1H16(11),16,ex3(:),4,G2H8(7),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_SV_V(ntryL,G0H16(7),ex3(:),G0H8(4),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_UW_V(ntryL,G0H16(8),16,ex3(:),4,G1H8(8),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_UW_V(ntryL,G1H16(12),16,ex3(:),4,G2H8(8),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_QA_S(ntryL,G1H16(13),ex2(:),G1H8(9),ngH,m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_QA_S(ntryL,G1H16(14),ex2(:),G1H8(10),ngX,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_SA_Q(ntryL,G1H16(15),ex2(:),G1H8(11),ngPln,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(11),18,0,G2H8(9),n2h8(5))
  call Hloop_QA_V(ntryL,G1H16(16),ex2(:),G1H8(11),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_QA_Z(ntryL,G1H16(17),ex2(:),G1H8(12),ngZl,m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_SA_Q(ntryL,G0H16(9),ex2(:),G0H8(5),ngPln,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(13),n2h8(6))
  call Hloop_SA_Q(ntryL,G1H16(18),ex2(:),G1H8(14),ngPln,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(14),18,0,G2H8(10),n2h8(7))
  call Hloop_WA_Q(ntryL,G0H16(10),ex2(:),G0H8(5),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(14),n2h8(8))
  call Hloop_SA_Q(ntryL,G1H16(19),ex2(:),G1H8(15),ngPln,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(15),18,0,G2H8(11),n2h8(9))
  call Hloop_SA_Q(ntryL,G0H16(11),ex2(:),G0H8(5),ngPln,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(15),n2h8(10))
  call Hloop_WA_Q(ntryL,G1H16(20),ex2(:),G1H8(16),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(16),18,0,G2H8(12),n2h8(11))
  call Hloop_WA_Q(ntryL,G0H16(12),ex2(:),G0H8(5),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(16),n2h8(12))
  call Hloop_SA_Q(ntryL,G0H16(13),ex2(:),G0H8(5),ngPln,m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(17),n2h8(13))
  call Hloop_SA_Q(ntryL,G1H16(21),ex2(:),G1H8(18),ngPln,m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(18),18,0,G2H8(13),n2h8(14))
  call Hloop_WA_Q(ntryL,G0H16(14),ex2(:),G0H8(5),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(18),n2h8(15))
  call Hloop_WA_Q(ntryL,G1H16(22),ex2(:),G1H8(19),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(19),18,0,G2H8(14),n2h8(16))
  call Hloop_SA_Q(ntryL,G0H16(15),ex2(:),G0H8(5),ngPln,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(19),n2h8(17))
  call Hloop_WA_Q(ntryL,G1H16(23),ex2(:),G1H8(20),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(20),18,0,G2H8(15),n2h8(18))
  call Hloop_WA_Q(ntryL,G0H16(16),ex2(:),G0H8(5),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(20),n2h8(19))
  call Hloop_WA_Q(ntryL,G1H16(24),ex2(:),G1H8(21),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(21),18,0,G2H8(16),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(25),ex3(:),G1H8(21),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(21),20,nML,G2H8(17),n2h8(21))
  call Hloop_QV_A(ntryL,G1H16(26),ex3(:),G1H8(21),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(21),20,nML,G2H8(18),n2h8(22))
  call Hloop_TV_S(ntryL,G1H16(27),16,ex3(:),4,G2H8(19),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_QV_A(ntryL,G1H16(28),ex3(:),G1H8(21),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(21),20,nML,G2H8(20),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(29),ex3(:),G1H8(21),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(21),20,nML,G2H8(21),n2h8(24))
  call Hloop_TV_S(ntryL,G0H16(17),16,ex3(:),4,G1H8(21),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_VV_S(ntryL,G0H16(18),ex3(:),G0H8(5),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_SV_V(ntryL,G1H16(30),ex3(:),G1H8(22),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_TV_S(ntryL,G1H16(31),16,ex3(:),4,G2H8(22),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_VV_S(ntryL,G1H16(32),ex3(:),G1H8(23),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_SV_V(ntryL,G0H16(19),ex3(:),G0H8(6),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_UV_W(ntryL,G0H16(20),16,ex3(:),4,G1H8(24),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_TV_S(ntryL,G0H16(21),16,ex3(:),4,G1H8(25),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_VV_S(ntryL,G0H16(22),ex3(:),G0H8(7),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_SV_V(ntryL,G1H16(33),ex3(:),G1H8(26),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_UV_W(ntryL,G1H16(34),16,ex3(:),4,G2H8(23),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_VV_S(ntryL,G1H16(35),ex3(:),G1H8(27),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_SV_V(ntryL,G0H16(23),ex3(:),G0H8(8),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_UV_W(ntryL,G0H16(24),16,ex3(:),4,G1H8(28),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_UV_W(ntryL,G1H16(36),16,ex3(:),4,G2H8(24),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_QA_S(ntryL,G1H16(37),ex2(:),G1H8(29),ngH,m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_QA_S(ntryL,G1H16(38),ex2(:),G1H8(30),ngX,m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_SA_Q(ntryL,G1H16(39),ex2(:),G1H8(31),ngPln,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(31),18,0,G2H8(25),n2h8(25))
  call Hloop_QA_V(ntryL,G1H16(40),ex2(:),G1H8(31),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_QA_Z(ntryL,G1H16(41),ex2(:),G1H8(32),ngZl,m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_SA_Q(ntryL,G0H16(25),ex2(:),G0H8(9),ngPln,m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(33),n2h8(26))
  call Hloop_SA_Q(ntryL,G1H16(42),ex2(:),G1H8(34),ngPln,m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(34),18,0,G2H8(26),n2h8(27))
  call Hloop_WA_Q(ntryL,G0H16(26),ex2(:),G0H8(9),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(34),n2h8(28))
  call Hloop_SA_Q(ntryL,G1H16(43),ex2(:),G1H8(35),ngPln,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(35),18,0,G2H8(27),n2h8(29))
  call Hloop_SA_Q(ntryL,G0H16(27),ex2(:),G0H8(9),ngPln,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(35),n2h8(30))
  call Hloop_WA_Q(ntryL,G1H16(44),ex2(:),G1H8(36),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(36),18,0,G2H8(28),n2h8(31))
  call Hloop_WA_Q(ntryL,G0H16(28),ex2(:),G0H8(9),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(36),n2h8(32))
  call Hloop_SA_Q(ntryL,G0H16(29),ex2(:),G0H8(9),ngPln,m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(37),n2h8(33))
  call Hloop_SA_Q(ntryL,G1H16(45),ex2(:),G1H8(38),ngPln,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(38),18,0,G2H8(29),n2h8(34))
  call Hloop_WA_Q(ntryL,G0H16(30),ex2(:),G0H8(9),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(38),n2h8(35))
  call Hloop_WA_Q(ntryL,G1H16(46),ex2(:),G1H8(39),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(39),18,0,G2H8(30),n2h8(36))
  call Hloop_SA_Q(ntryL,G0H16(31),ex2(:),G0H8(9),ngPln,m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(39),n2h8(37))
  call Hloop_WA_Q(ntryL,G1H16(47),ex2(:),G1H8(40),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(40),18,0,G2H8(31),n2h8(38))
  call Hloop_WA_Q(ntryL,G0H16(32),ex2(:),G0H8(9),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(40),n2h8(39))
  call Hloop_WA_Q(ntryL,G1H16(48),ex2(:),G1H8(41),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(41),18,0,G2H8(32),n2h8(40))
  call Hloop_AQ_S(ntryL,G1H16(49),ex1(:),G1H8(41),ngH,m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_AQ_S(ntryL,G1H16(50),ex1(:),G1H8(42),ngX,m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_SQ_A(ntryL,G1H16(51),ex1(:),G1H8(43),ngPnl,m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(43),17,0,G2H8(33),n2h8(41))
  call Hloop_AQ_V(ntryL,G1H16(52),ex1(:),G1H8(43),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_AQ_Z(ntryL,G1H16(53),ex1(:),G1H8(44),ngZl,m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_SQ_A(ntryL,G0H16(33),ex1(:),G0H8(9),ngPnl,m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(45),n2h8(42))
  call Hloop_SQ_A(ntryL,G1H16(54),ex1(:),G1H8(46),ngPnl,m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(46),17,0,G2H8(34),n2h8(43))
  call Hloop_SQ_A(ntryL,G1H16(55),ex1(:),G1H8(46),ngPnl,m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(46),17,0,G2H8(35),n2h8(44))
  call Hloop_WQ_A(ntryL,G0H16(34),ex1(:),G0H8(9),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(46),n2h8(45))
  call Hloop_SQ_A(ntryL,G0H16(35),ex1(:),G0H8(9),ngPnl,m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(47),n2h8(46))
  call Hloop_SQ_A(ntryL,G0H16(36),ex1(:),G0H8(9),ngPnl,m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(48),n2h8(47))
  call Hloop_SQ_A(ntryL,G1H16(56),ex1(:),G1H8(49),ngPnl,m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(49),17,0,G2H8(36),n2h8(48))
  call Hloop_WQ_A(ntryL,G1H16(57),ex1(:),G1H8(49),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(49),17,0,G2H8(37),n2h8(49))
  call Hloop_WQ_A(ntryL,G0H16(37),ex1(:),G0H8(9),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(49),n2h8(50))
  call Hloop_WQ_A(ntryL,G0H16(38),ex1(:),G0H8(9),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(50),n2h8(51))
  call Hloop_SQ_A(ntryL,G0H16(39),ex1(:),G0H8(9),ngPnl,m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(51),n2h8(52))
  call Hloop_WQ_A(ntryL,G1H16(58),ex1(:),G1H8(52),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(52),17,0,G2H8(38),n2h8(53))
  call Hloop_WQ_A(ntryL,G1H16(59),ex1(:),G1H8(52),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(52),17,0,G2H8(39),n2h8(54))
  call Hloop_WQ_A(ntryL,G0H16(40),ex1(:),G0H8(9),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(52),n2h8(55))
  call Hloop_WQ_A(ntryL,G1H16(60),ex1(:),G1H8(53),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(53),17,0,G2H8(40),n2h8(56))
  call Hloop_AQ_S(ntryL,G1H16(61),ex1(:),G1H8(53),ngH,m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_AQ_S(ntryL,G1H16(62),ex1(:),G1H8(54),ngX,m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_SQ_A(ntryL,G1H16(63),ex1(:),G1H8(55),ngPnl,m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(55),17,0,G2H8(41),n2h8(57))
  call Hloop_AQ_V(ntryL,G1H16(64),ex1(:),G1H8(55),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_AQ_Z(ntryL,G1H16(65),ex1(:),G1H8(56),ngZl,m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_SQ_A(ntryL,G0H16(41),ex1(:),G0H8(9),ngPnl,m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(57),n2h8(58))
  call Hloop_SQ_A(ntryL,G1H16(66),ex1(:),G1H8(58),ngPnl,m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(58),17,0,G2H8(42),n2h8(59))
  call Hloop_SQ_A(ntryL,G1H16(67),ex1(:),G1H8(58),ngPnl,m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(58),17,0,G2H8(43),n2h8(60))
  call Hloop_WQ_A(ntryL,G0H16(42),ex1(:),G0H8(9),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(58),n2h8(61))
  call Hloop_SQ_A(ntryL,G0H16(43),ex1(:),G0H8(9),ngPnl,m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(59),n2h8(62))
  call Hloop_SQ_A(ntryL,G0H16(44),ex1(:),G0H8(9),ngPnl,m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(60),n2h8(63))
  call Hloop_SQ_A(ntryL,G1H16(68),ex1(:),G1H8(61),ngPnl,m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(61),17,0,G2H8(44),n2h8(64))
  call Hloop_WQ_A(ntryL,G1H16(69),ex1(:),G1H8(61),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(61),17,0,G2H8(45),n2h8(65))
  call Hloop_WQ_A(ntryL,G0H16(45),ex1(:),G0H8(9),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(61),n2h8(66))
  call Hloop_WQ_A(ntryL,G0H16(46),ex1(:),G0H8(9),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(62),n2h8(67))
  call Hloop_SQ_A(ntryL,G0H16(47),ex1(:),G0H8(9),ngPnl,m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(63),n2h8(68))
  call Hloop_WQ_A(ntryL,G1H16(70),ex1(:),G1H8(64),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(64),17,0,G2H8(46),n2h8(69))
  call Hloop_WQ_A(ntryL,G1H16(71),ex1(:),G1H8(64),m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(64),17,0,G2H8(47),n2h8(70))
  call Hloop_WQ_A(ntryL,G0H16(48),ex1(:),G0H8(9),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(64),n2h8(71))
  call Hloop_WQ_A(ntryL,G1H16(72),ex1(:),G1H8(65),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(65),17,0,G2H8(48),n2h8(72))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(25),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(33),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(34),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(35),[G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(38),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G1H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(36),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G1H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G1H8(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(46),[G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(47),[G1H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G1H8(63)])
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(1),mass5set(:,1),  & 
G1H8(65),G1H8(1),G1H8(2),G1H8(4),G1H8(6),G1H8(14),8)
  call HG1shiftOLR(G1H8(1),8,8)
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex1(:),G2H4(4),ngZl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_SQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngPnl,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(5),n2h4(1))
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(1),mass5set(:,1),  & 
G1H8(13),G1H8(16),G1H8(18),G1H8(15),G1H8(17),G1H8(20),8)
  call HG1shiftOLR(G1H8(16),8,8)
  call Hloop_WQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(6),n2h4(2))
  call Hloop_SQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngPnl,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(7),n2h4(3))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(1),mass5set(:,1),  & 
G1H8(19),G1H8(21),G1H8(22),G1H8(25),G1H8(26),G1H8(34),8)
  call HG1shiftOLR(G1H8(21),8,8)
  call Hloop_WQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(8),n2h4(4))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(1),mass5set(:,1),  & 
G1H8(33),G1H8(36),G1H8(38),G1H8(35),G1H8(37),G1H8(40),8)
  call HG1shiftOLR(G1H8(36),8,8)
  call Hloop_SQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),ngH,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(9),n2h4(5))
  call Hloop_SQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),ngX,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(10),n2h4(6))
  call Hloop_AQ_S(ntryL,G2H8(9),ex1(:),G2H4(11),ngPnl,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_VQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(12),n2h4(7))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),ngZl,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(13),n2h4(8))
  call Hloop_AQ_S(ntryL,G2H8(12),ex1(:),G2H4(14),ngPnl,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_AQ_S(ntryL,G2H8(10),ex1(:),G2H4(15),ngPnl,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_W(ntryL,G2H8(11),ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_S(ntryL,G2H8(14),ex1(:),G2H4(17),ngPnl,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_W(ntryL,G2H8(15),ex1(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_W(ntryL,G2H8(13),ex1(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_W(ntryL,G2H8(16),ex1(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_QA_S(ntryL,G2H8(17),ex2(:),G2H4(21),ngH,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_S(ntryL,G2H8(18),ex2(:),G2H4(22),ngX,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(2),mass5set(:,1),  & 
G1H8(39),G1H8(46),G1H8(45),G1H8(49),G1H8(50),G1H8(47),8)
  call HG1shiftOLR(G1H8(46),8,8)
  call Hloop_QA_V(ntryL,G2H8(20),ex2(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_Z(ntryL,G2H8(21),ex2(:),G2H4(24),ngZl,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_SA_Q(ntryL,G1H8(23),ex2(:),G1H4(1),ngPln,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(25),n2h4(9))
  call Hloop_WA_Q(ntryL,G1H8(24),ex2(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(26),n2h4(10))
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(2),mass5set(:,1),  & 
G1H8(48),G1H8(52),G1H8(51),G1H8(58),G1H8(57),G1H8(61),8)
  call HG1shiftOLR(G1H8(52),8,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(2),mass5set(:,1),  & 
G1H8(62),G1H8(59),G1H8(60),G1H8(64),G1H8(63),G1H8(3),8)
  call HG1shiftOLR(G1H8(59),8,8)
  call Hloop_SA_Q(ntryL,G1H8(27),ex2(:),G1H4(1),ngPln,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(27),n2h4(11))
  call Hloop_WA_Q(ntryL,G1H8(28),ex2(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(28),n2h4(12))
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(2),mass5set(:,1),  & 
G1H8(5),G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),8)
  call HG1shiftOLR(G1H8(7),8,8)
  call Hloop_SQ_A(ntryL,G1H8(29),ex1(:),G1H4(1),ngH,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(29),n2h4(13))
  call Hloop_SQ_A(ntryL,G1H8(30),ex1(:),G1H4(1),ngX,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(30),n2h4(14))
  call Hloop_AQ_S(ntryL,G2H8(25),ex1(:),G2H4(31),ngPnl,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_VQ_A(ntryL,G1H8(31),ex1(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(32),n2h4(15))
  call Hloop_ZQ_A(ntryL,G1H8(32),ex1(:),G1H4(1),ngZl,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(33),n2h4(16))
  call Hloop_AQ_S(ntryL,G2H8(28),ex1(:),G2H4(34),ngPnl,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_S(ntryL,G2H8(26),ex1(:),G2H4(35),ngPnl,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_AQ_W(ntryL,G2H8(27),ex1(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_AQ_S(ntryL,G2H8(30),ex1(:),G2H4(37),ngPnl,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_AQ_W(ntryL,G2H8(31),ex1(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_AQ_W(ntryL,G2H8(29),ex1(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_AQ_W(ntryL,G2H8(32),ex1(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_SA_Q(ntryL,G1H8(41),ex2(:),G1H4(1),ngH,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(41),n2h4(17))
  call Hloop_SA_Q(ntryL,G1H8(42),ex2(:),G1H4(1),ngX,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(42),n2h4(18))
  call Hloop_QA_S(ntryL,G2H8(33),ex2(:),G2H4(43),ngPln,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_VA_Q(ntryL,G1H8(43),ex2(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(44),n2h4(19))
  call Hloop_ZA_Q(ntryL,G1H8(44),ex2(:),G1H4(1),ngZl,m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(45),n2h4(20))
  call Hloop_QA_S(ntryL,G2H8(37),ex2(:),G2H4(46),ngPln,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_QA_S(ntryL,G2H8(34),ex2(:),G2H4(47),ngPln,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_QA_W(ntryL,G2H8(35),ex2(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_QA_S(ntryL,G2H8(38),ex2(:),G2H4(49),ngPln,m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_QA_W(ntryL,G2H8(39),ex2(:),G2H4(50),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_QA_W(ntryL,G2H8(36),ex2(:),G2H4(51),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_QA_W(ntryL,G2H8(40),ex2(:),G2H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_SA_Q(ntryL,G1H8(53),ex2(:),G1H4(1),ngH,m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(53),n2h4(21))
  call Hloop_SA_Q(ntryL,G1H8(54),ex2(:),G1H4(1),ngX,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(54),n2h4(22))
  call Hloop_QA_S(ntryL,G2H8(41),ex2(:),G2H4(55),ngPln,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_VA_Q(ntryL,G1H8(55),ex2(:),G1H4(1),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(56),n2h4(23))
  call Hloop_ZA_Q(ntryL,G1H8(56),ex2(:),G1H4(1),ngZl,m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(57),n2h4(24))
  call Hloop_QA_S(ntryL,G2H8(45),ex2(:),G2H4(58),ngPln,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QA_S(ntryL,G2H8(42),ex2(:),G2H4(59),ngPln,m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_QA_W(ntryL,G2H8(43),ex2(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QA_S(ntryL,G2H8(46),ex2(:),G2H4(61),ngPln,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_QA_W(ntryL,G2H8(47),ex2(:),G2H4(62),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_QA_W(ntryL,G2H8(44),ex2(:),G2H4(63),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_QA_W(ntryL,G2H8(48),ex2(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_SQ_A(ntryL,G1H8(65),ex1(:),G1H4(1),ngPnl,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(65),n2h4(25))
call HGT_OLR(G1H8(1),1,1,8)
call HGT_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1),-8,ex4(:),8,G2H4(66),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_SQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngPnl,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(67),n2h4(26))
  call Hloop_SQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngPnl,m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(68),n2h4(27))
  call Hloop_SQ_A(ntryL,G1H8(14),ex1(:),G1H4(1),ngPnl,m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(69),n2h4(28))
  call Hloop_SQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),ngPnl,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(70),n2h4(29))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(16),ex4(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_SQ_A(ntryL,G1H8(15),ex1(:),G1H4(2),ngPnl,m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(71),n2h4(30))
  call Hloop_SQ_A(ntryL,G1H8(17),ex1(:),G1H4(2),ngPnl,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(72),n2h4(31))
  call Hloop_SQ_A(ntryL,G1H8(20),ex1(:),G1H4(2),ngPnl,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(73),n2h4(32))
  call Hloop_WQ_A(ntryL,G1H8(19),ex1(:),G1H4(2),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(74),n2h4(33))
call HGT_raise_alpha_OLR(G1H8(21),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(21),ex4(:),G1H4(2),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_WQ_A(ntryL,G1H8(25),ex1(:),G1H4(3),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(75),n2h4(34))
  call Hloop_WQ_A(ntryL,G1H8(26),ex1(:),G1H4(3),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(76),n2h4(35))
  call Hloop_WQ_A(ntryL,G1H8(34),ex1(:),G1H4(3),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(77),n2h4(36))
  call Hloop_WQ_A(ntryL,G1H8(33),ex1(:),G1H4(3),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(78),n2h4(37))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(36),-8,ex4(:),8,G2H4(79),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_WQ_A(ntryL,G1H8(35),ex1(:),G1H4(3),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(80),n2h4(38))
  call Hloop_WQ_A(ntryL,G1H8(37),ex1(:),G1H4(3),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(81),n2h4(39))
  call Hloop_WQ_A(ntryL,G1H8(40),ex1(:),G1H4(3),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(82),n2h4(40))
  call Hloop_SA_Q(ntryL,G1H8(39),ex2(:),G1H4(3),ngPln,m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(83),n2h4(41))
call HGT_OLR(G1H8(46),1,1,8)
call HGT_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(46),-8,ex4(:),8,G2H4(84),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_SA_Q(ntryL,G1H8(49),ex2(:),G1H4(3),ngPln,m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(85),n2h4(42))
  call Hloop_SA_Q(ntryL,G1H8(50),ex2(:),G1H4(3),ngPln,m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(86),n2h4(43))
  call Hloop_SA_Q(ntryL,G1H8(47),ex2(:),G1H4(3),ngPln,m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(87),n2h4(44))
  call Hloop_SA_Q(ntryL,G1H8(48),ex2(:),G1H4(3),ngPln,m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(88),n2h4(45))
call HGT_OLR(G1H8(52),1,1,8)
call HGT_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(52),ex4(:),G1H4(3),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_SA_Q(ntryL,G1H8(58),ex2(:),G1H4(4),ngPln,m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(4),22,0,G2H4(89),n2h4(46))
  call Hloop_SA_Q(ntryL,G1H8(57),ex2(:),G1H4(4),ngPln,m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(4),22,0,G2H4(90),n2h4(47))
  call Hloop_SA_Q(ntryL,G1H8(61),ex2(:),G1H4(4),ngPln,m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(4),22,0,G2H4(91),n2h4(48))
  call Hloop_WA_Q(ntryL,G1H8(62),ex2(:),G1H4(4),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(4),22,0,G2H4(92),n2h4(49))
call HGT_raise_alpha_OLR(G1H8(59),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(59),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(59),ex4(:),G1H4(4),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_WA_Q(ntryL,G1H8(64),ex2(:),G1H4(5),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(93),n2h4(50))
  call Hloop_WA_Q(ntryL,G1H8(63),ex2(:),G1H4(5),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(94),n2h4(51))
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(5),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(95),n2h4(52))
  call Hloop_WA_Q(ntryL,G1H8(5),ex2(:),G1H4(5),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(96),n2h4(53))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(7),-8,ex4(:),8,G2H4(97),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_WA_Q(ntryL,G1H8(9),ex2(:),G1H4(5),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(98),n2h4(54))
  call Hloop_WA_Q(ntryL,G1H8(10),ex2(:),G1H4(5),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(99),n2h4(55))
  call Hloop_WA_Q(ntryL,G1H8(11),ex2(:),G1H4(5),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(100),n2h4(56))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G2H4(54)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,2),  & 
G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(9),G1H4(10),4)
  call HG1shiftOLR(G1H4(6),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,3),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,4),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,3),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(24),8,4)
  call Hloop_QA_S(ntryL,G2H4(74),ex2(:),G2H2(1),ngPln,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_S(ntryL,G2H4(65),ex2(:),G2H2(2),ngPln,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_W(ntryL,G2H4(78),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_W(ntryL,G2H4(70),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(3),mass5set(:,5),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(30),8,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(3),mass5set(:,6),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(3),mass5set(:,7),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(42),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(3),mass5set(:,8),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(48),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(3),mass5set(:,7),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),8,4)
  call Hloop_SV_V(ntryL,G2H4(15),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_VV_S(ntryL,G2H4(16),ex3(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_SV_V(ntryL,G2H4(17),ex3(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_VV_S(ntryL,G2H4(18),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(3),mass5set(:,7),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(60),8,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(3),mass5set(:,7),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(2),mass5set(:,2),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),8,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(2),mass5set(:,3),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(78),8,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(2),mass5set(:,4),  & 
G1H4(83),G1H4(84),G1H4(85),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(84),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(2),mass5set(:,3),  & 
G1H4(89),G1H4(90),G1H4(91),G1H4(92),G1H4(93),G1H4(94),4)
  call HG1shiftOLR(G1H4(90),8,4)
  call Hloop_AQ_S(ntryL,G2H4(92),ex1(:),G2H2(9),ngPnl,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_S(ntryL,G2H4(83),ex1(:),G2H2(10),ngPnl,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_W(ntryL,G2H4(96),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_W(ntryL,G2H4(88),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(4),mass5set(:,5),  & 
G1H4(95),G1H4(96),G1H4(97),G1H4(98),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(96),4,4)
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(4),mass5set(:,6),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(102),4,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(4),mass5set(:,7),  & 
G1H4(107),G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(108),4,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(4),mass5set(:,8),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(114),4,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(4),mass5set(:,7),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(120),4,4)
  call Hloop_SV_V(ntryL,G2H4(35),ex4(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_VV_S(ntryL,G2H4(36),ex4(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_SV_V(ntryL,G2H4(37),ex4(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_VV_S(ntryL,G2H4(38),ex4(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(4),mass5set(:,7),  & 
G1H4(125),G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(126),4,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(4),mass5set(:,7),  & 
G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(132),4,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(5),mass5set(:,5),  & 
G1H4(137),G1H4(138),G1H4(139),G1H4(140),G1H4(141),G1H4(142),4)
  call HG1shiftOLR(G1H4(138),8,4)
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(5),mass5set(:,6),  & 
G1H4(143),G1H4(144),G1H4(145),G1H4(146),G1H4(147),G1H4(148),4)
  call HG1shiftOLR(G1H4(144),8,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(5),mass5set(:,7),  & 
G1H4(149),G1H4(150),G1H4(151),G1H4(152),G1H4(153),G1H4(154),4)
  call HG1shiftOLR(G1H4(150),8,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(5),mass5set(:,8),  & 
G1H4(155),G1H4(156),G1H4(157),G1H4(158),G1H4(159),G1H4(160),4)
  call HG1shiftOLR(G1H4(156),8,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(5),mass5set(:,7),  & 
G1H4(161),G1H4(162),G1H4(163),G1H4(164),G1H4(165),G1H4(166),4)
  call HG1shiftOLR(G1H4(162),8,4)
  call Hloop_SV_V(ntryL,G2H4(47),ex3(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_VV_S(ntryL,G2H4(48),ex3(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_SV_V(ntryL,G2H4(49),ex3(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VV_S(ntryL,G2H4(50),ex3(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(5),mass5set(:,7),  & 
G1H4(167),G1H4(168),G1H4(169),G1H4(170),G1H4(171),G1H4(172),4)
  call HG1shiftOLR(G1H4(168),8,4)
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(5),mass5set(:,7),  & 
G1H4(173),G1H4(174),G1H4(175),G1H4(176),G1H4(177),G1H4(178),4)
  call HG1shiftOLR(G1H4(174),8,4)
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(6),mass5set(:,5),  & 
G1H4(179),G1H4(180),G1H4(181),G1H4(182),G1H4(183),G1H4(184),4)
  call HG1shiftOLR(G1H4(180),4,4)
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(6),mass5set(:,6),  & 
G1H4(185),G1H4(186),G1H4(187),G1H4(188),G1H4(189),G1H4(190),4)
  call HG1shiftOLR(G1H4(186),4,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(6),mass5set(:,7),  & 
G1H4(191),G1H4(192),G1H4(193),G1H4(194),G1H4(195),G1H4(196),4)
  call HG1shiftOLR(G1H4(192),4,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(6),mass5set(:,8),  & 
G1H4(197),G1H4(198),G1H4(199),G1H4(200),G1H4(201),G1H4(202),4)
  call HG1shiftOLR(G1H4(198),4,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(6),mass5set(:,7),  & 
G1H4(203),G1H4(204),G1H4(205),G1H4(206),G1H4(207),G1H4(208),4)
  call HG1shiftOLR(G1H4(204),4,4)
  call Hloop_SV_V(ntryL,G2H4(59),ex4(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VV_S(ntryL,G2H4(60),ex4(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_SV_V(ntryL,G2H4(61),ex4(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_VV_S(ntryL,G2H4(62),ex4(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(6),mass5set(:,7),  & 
G1H4(209),G1H4(210),G1H4(211),G1H4(212),G1H4(213),G1H4(214),4)
  call HG1shiftOLR(G1H4(210),4,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(6),mass5set(:,7),  & 
G1H4(215),G1H4(216),G1H4(217),G1H4(218),G1H4(219),G1H4(220),4)
  call HG1shiftOLR(G1H4(216),4,4)
  call Hloop_QA_S(ntryL,G2H4(68),ex2(:),G2H2(25),ngPln,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_S(ntryL,G2H4(69),ex2(:),G2H2(26),ngPln,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_W(ntryL,G2H4(72),ex2(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_W(ntryL,G2H4(73),ex2(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_S(ntryL,G2H4(76),ex2(:),G2H2(29),ngPln,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_S(ntryL,G2H4(77),ex2(:),G2H2(30),ngPln,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_W(ntryL,G2H4(81),ex2(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_W(ntryL,G2H4(82),ex2(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_S(ntryL,G2H4(86),ex1(:),G2H2(33),ngPnl,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_S(ntryL,G2H4(87),ex1(:),G2H2(34),ngPnl,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_W(ntryL,G2H4(90),ex1(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_W(ntryL,G2H4(91),ex1(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_S(ntryL,G2H4(94),ex1(:),G2H2(37),ngPnl,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_S(ntryL,G2H4(95),ex1(:),G2H2(38),ngPnl,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_W(ntryL,G2H4(99),ex1(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_W(ntryL,G2H4(100),ex1(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_SA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),ngH,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(41),n2h2(1))
call HGT_OLR(G1H4(6),1,1,4)
call HGT_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(6),-8,nML,G2H4(5),n2h4(57))
  call Hloop_QV_A(ntryL,G2H4(5),ex4(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_SA_Q(ntryL,G1H4(9),ex2(:),G1H2(1),ngH,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(43),n2h2(2))
  call Hloop_SA_Q(ntryL,G1H4(10),ex2(:),G1H2(1),ngH,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(44),n2h2(3))
  call Hloop_SA_Q(ntryL,G1H4(11),ex2(:),G1H2(1),ngX,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(45),n2h2(4))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(12),-8,nML,G2H4(6),n2h4(58))
  call Hloop_QV_A(ntryL,G2H4(6),ex4(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_SA_Q(ntryL,G1H4(15),ex2(:),G1H2(1),ngX,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(47),n2h2(5))
  call Hloop_SA_Q(ntryL,G1H4(16),ex2(:),G1H2(1),ngX,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(48),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H4(17),ex2(:),G1H2(1),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(49),n2h2(7))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(18),-8,nML,G2H4(7),n2h4(59))
  call Hloop_QV_A(ntryL,G2H4(7),ex4(:),G2H2(50),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_VA_Q(ntryL,G1H4(21),ex2(:),G1H2(1),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(51),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(22),ex2(:),G1H2(1),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(52),n2h2(9))
  call Hloop_ZA_Q(ntryL,G1H4(23),ex2(:),G1H2(1),ngZl,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(53),n2h2(10))
call HGT_OLR(G1H4(24),1,1,4)
call HGT_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(24),-8,nML,G2H4(8),n2h4(60))
  call Hloop_QV_A(ntryL,G2H4(8),ex4(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_ZA_Q(ntryL,G1H4(27),ex2(:),G1H2(1),ngZl,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(55),n2h2(11))
  call Hloop_ZA_Q(ntryL,G1H4(28),ex2(:),G1H2(1),ngZl,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),23,nML,G2H2(56),n2h2(12))
  call Hloop_QV_A(ntryL,G1H4(29),ex3(:),G1H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),23,nML,G2H2(57),n2h2(13))
call HGT_OLR(G1H4(30),1,1,4)
call HGT_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(30),-8,nML,G2H4(10),n2h4(61))
  call Hloop_AV_Q(ntryL,G2H4(10),ex4(:),G2H2(58),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_QV_A(ntryL,G1H4(33),ex3(:),G1H2(1),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),23,nML,G2H2(59),n2h2(14))
  call Hloop_QV_A(ntryL,G1H4(34),ex3(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(1),23,nML,G2H2(60),n2h2(15))
  call Hloop_QV_A(ntryL,G1H4(35),ex3(:),G1H2(1),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(1),23,nML,G2H2(61),n2h2(16))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(36),-8,nML,G2H4(25),n2h4(62))
  call Hloop_AV_Q(ntryL,G2H4(25),ex4(:),G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_QV_A(ntryL,G1H4(39),ex3(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(1),23,nML,G2H2(63),n2h2(17))
  call Hloop_QV_A(ntryL,G1H4(40),ex3(:),G1H2(1),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(1),23,nML,G2H2(64),n2h2(18))
  call Hloop_TV_S(ntryL,G1H4(41),19,ex3(:),4,G2H2(65),m3h2x2(:,65),heltab2x4(:,:,65))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(42),-8,ex4(:),8,G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_TV_S(ntryL,G1H4(45),19,ex3(:),4,G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_TV_S(ntryL,G1H4(46),19,ex3(:),4,G2H2(68),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_QV_A(ntryL,G1H4(47),ex3(:),G1H2(1),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(1),23,nML,G2H2(69),n2h2(19))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(48),-8,nML,G2H4(26),n2h4(64))
  call Hloop_AV_Q(ntryL,G2H4(26),ex4(:),G2H2(70),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_QV_A(ntryL,G1H4(51),ex3(:),G1H2(1),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(1),23,nML,G2H2(71),n2h2(20))
  call Hloop_QV_A(ntryL,G1H4(52),ex3(:),G1H2(1),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(1),23,nML,G2H2(72),n2h2(21))
  call Hloop_TV_S(ntryL,G1H4(53),19,ex3(:),4,G2H2(73),m3h2x2(:,73),heltab2x4(:,:,73))
call HGT_raise_alpha_OLR(G1H4(54),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(54),ex4(:),G1H2(1),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_TV_S(ntryL,G1H4(57),19,ex3(:),4,G2H2(74),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_TV_S(ntryL,G1H4(58),19,ex3(:),4,G2H2(75),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_UV_W(ntryL,G1H4(59),19,ex3(:),4,G2H2(76),m3h2x2(:,77),heltab2x4(:,:,77))
call HGT_OLR(G1H4(60),1,1,4)
call HGT_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(60),ex4(:),G1H2(2),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_UV_W(ntryL,G1H4(63),19,ex3(:),4,G2H2(77),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_UV_W(ntryL,G1H4(64),19,ex3(:),4,G2H2(78),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_UV_W(ntryL,G1H4(65),19,ex3(:),4,G2H2(79),m3h2x2(:,81),heltab2x4(:,:,81))
call HGT_raise_alpha_OLR(G1H4(66),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(66),-8,ex4(:),8,G2H2(80),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_UV_W(ntryL,G1H4(69),19,ex3(:),4,G2H2(81),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_UV_W(ntryL,G1H4(70),19,ex3(:),4,G2H2(82),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_SQ_A(ntryL,G1H4(71),ex1(:),G1H2(3),ngH,m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(83),n2h2(22))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(72),-8,nML,G2H4(27),n2h4(68))
  call Hloop_AV_Q(ntryL,G2H4(27),ex4(:),G2H2(84),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_SQ_A(ntryL,G1H4(75),ex1(:),G1H2(3),ngH,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(85),n2h2(23))
  call Hloop_SQ_A(ntryL,G1H4(76),ex1(:),G1H2(3),ngH,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(86),n2h2(24))
  call Hloop_SQ_A(ntryL,G1H4(77),ex1(:),G1H2(3),ngX,m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(87),n2h2(25))
call HGT_OLR(G1H4(78),1,1,4)
call HGT_invQ_OLR(G1H4(78),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(78),-8,nML,G2H4(28),n2h4(69))
  call Hloop_AV_Q(ntryL,G2H4(28),ex4(:),G2H2(88),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_SQ_A(ntryL,G1H4(81),ex1(:),G1H2(3),ngX,m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(89),n2h2(26))
  call Hloop_SQ_A(ntryL,G1H4(82),ex1(:),G1H2(3),ngX,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(90),n2h2(27))
  call Hloop_VQ_A(ntryL,G1H4(83),ex1(:),G1H2(3),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(91),n2h2(28))
call HGT_OLR(G1H4(84),1,1,4)
call HGT_invQ_OLR(G1H4(84),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(84),-8,nML,G2H4(30),n2h4(70))
  call Hloop_AV_Q(ntryL,G2H4(30),ex4(:),G2H2(92),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_VQ_A(ntryL,G1H4(87),ex1(:),G1H2(3),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(93),n2h2(29))
  call Hloop_VQ_A(ntryL,G1H4(88),ex1(:),G1H2(3),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(94),n2h2(30))
  call Hloop_ZQ_A(ntryL,G1H4(89),ex1(:),G1H2(3),ngZl,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(95),n2h2(31))
call HGT_OLR(G1H4(90),1,1,4)
call HGT_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(90),-8,nML,G2H4(42),n2h4(71))
  call Hloop_AV_Q(ntryL,G2H4(42),ex4(:),G2H2(96),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_ZQ_A(ntryL,G1H4(93),ex1(:),G1H2(3),ngZl,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(97),n2h2(32))
  call Hloop_ZQ_A(ntryL,G1H4(94),ex1(:),G1H2(3),ngZl,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(3),23,nML,G2H2(98),n2h2(33))
  call Hloop_QV_A(ntryL,G1H4(95),ex4(:),G1H2(3),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(3),27,nML,G2H2(99),n2h2(34))
call HGT_OLR(G1H4(96),1,1,4)
call HGT_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(96),-4,nML,G2H4(54),n2h4(72))
  call Hloop_AV_Q(ntryL,G2H4(54),ex3(:),G2H2(100),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_QV_A(ntryL,G1H4(99),ex4(:),G1H2(3),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(3),27,nML,G2H2(101),n2h2(35))
  call Hloop_QV_A(ntryL,G1H4(100),ex4(:),G1H2(3),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(3),27,nML,G2H2(102),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(101),ex4(:),G1H2(3),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(3),27,nML,G2H2(103),n2h2(37))
call HGT_OLR(G1H4(102),1,1,4)
call HGT_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(102),-4,nML,G2H4(1),n2h4(73))
  call Hloop_AV_Q(ntryL,G2H4(1),ex3(:),G2H2(104),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_QV_A(ntryL,G1H4(105),ex4(:),G1H2(3),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(3),27,nML,G2H2(105),n2h2(38))
  call Hloop_QV_A(ntryL,G1H4(106),ex4(:),G1H2(3),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(3),27,nML,G2H2(106),n2h2(39))
  call Hloop_TV_S(ntryL,G1H4(107),19,ex4(:),8,G2H2(107),m3h2x2(:,109),heltab2x4(:,:,109))
call HGT_OLR(G1H4(108),1,1,4)
call HGT_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(108),-4,ex3(:),4,G2H2(108),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_TV_S(ntryL,G1H4(111),19,ex4(:),8,G2H2(109),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_TV_S(ntryL,G1H4(112),19,ex4(:),8,G2H2(110),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_QV_A(ntryL,G1H4(113),ex4(:),G1H2(3),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(3),27,nML,G2H2(111),n2h2(40))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(114),-4,nML,G2H4(2),n2h4(75))
  call Hloop_AV_Q(ntryL,G2H4(2),ex3(:),G2H2(112),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_QV_A(ntryL,G1H4(117),ex4(:),G1H2(3),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(3),27,nML,G2H2(113),n2h2(41))
  call Hloop_QV_A(ntryL,G1H4(118),ex4(:),G1H2(3),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(3),27,nML,G2H2(114),n2h2(42))
  call Hloop_TV_S(ntryL,G1H4(119),19,ex4(:),8,G2H2(115),m3h2x2(:,117),heltab2x4(:,:,117))
call HGT_raise_alpha_OLR(G1H4(120),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(120),ex3(:),G1H2(3),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_TV_S(ntryL,G1H4(123),19,ex4(:),8,G2H2(116),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_TV_S(ntryL,G1H4(124),19,ex4(:),8,G2H2(117),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_UV_W(ntryL,G1H4(125),19,ex4(:),8,G2H2(118),m3h2x2(:,121),heltab2x4(:,:,121))
call HGT_OLR(G1H4(126),1,1,4)
call HGT_invQ_OLR(G1H4(126),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(126),ex3(:),G1H2(4),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_UV_W(ntryL,G1H4(129),19,ex4(:),8,G2H2(119),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_UV_W(ntryL,G1H4(130),19,ex4(:),8,G2H2(120),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_UV_W(ntryL,G1H4(131),19,ex4(:),8,G2H2(121),m3h2x2(:,125),heltab2x4(:,:,125))
call HGT_raise_alpha_OLR(G1H4(132),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(132),-4,ex3(:),4,G2H2(122),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_UV_W(ntryL,G1H4(135),19,ex4(:),8,G2H2(123),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_UV_W(ntryL,G1H4(136),19,ex4(:),8,G2H2(124),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_AV_Q(ntryL,G1H4(137),ex3(:),G1H2(5),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(5),23,nML,G2H2(125),n2h2(43))
call HGT_OLR(G1H4(138),1,1,4)
call HGT_invQ_OLR(G1H4(138),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(138),-8,nML,G2H4(3),n2h4(79))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(126),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_AV_Q(ntryL,G1H4(141),ex3(:),G1H2(5),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(5),23,nML,G2H2(127),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H4(142),ex3(:),G1H2(5),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(5),23,nML,G2H2(128),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H4(143),ex3(:),G1H2(5),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(5),23,nML,G2H2(129),n2h2(46))
call HGT_OLR(G1H4(144),1,1,4)
call HGT_invQ_OLR(G1H4(144),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(144),-8,nML,G2H4(4),n2h4(80))
  call Hloop_QV_A(ntryL,G2H4(4),ex4(:),G2H2(130),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_AV_Q(ntryL,G1H4(147),ex3(:),G1H2(5),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(5),23,nML,G2H2(131),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H4(148),ex3(:),G1H2(5),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(5),23,nML,G2H2(132),n2h2(48))
  call Hloop_SV_T(ntryL,G1H4(149),19,ex3(:),4,G2H2(133),m3h2x2(:,137),heltab2x4(:,:,137))
call HGT_OLR(G1H4(150),1,1,4)
call HGT_invQ_OLR(G1H4(150),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(150),-8,ex4(:),8,G2H2(134),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_SV_T(ntryL,G1H4(153),19,ex3(:),4,G2H2(135),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_SV_T(ntryL,G1H4(154),19,ex3(:),4,G2H2(136),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_AV_Q(ntryL,G1H4(155),ex3(:),G1H2(5),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(5),23,nML,G2H2(137),n2h2(49))
call HGT_OLR(G1H4(156),1,1,4)
call HGT_invQ_OLR(G1H4(156),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(156),-8,nML,G2H4(74),n2h4(82))
  call Hloop_QV_A(ntryL,G2H4(74),ex4(:),G2H2(138),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_AV_Q(ntryL,G1H4(159),ex3(:),G1H2(5),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(5),23,nML,G2H2(139),n2h2(50))
  call Hloop_AV_Q(ntryL,G1H4(160),ex3(:),G1H2(5),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(5),23,nML,G2H2(140),n2h2(51))
  call Hloop_SV_T(ntryL,G1H4(161),19,ex3(:),4,G2H2(141),m3h2x2(:,145),heltab2x4(:,:,145))
call HGT_raise_alpha_OLR(G1H4(162),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(162),ex4(:),G1H2(5),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_SV_T(ntryL,G1H4(165),19,ex3(:),4,G2H2(142),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_SV_T(ntryL,G1H4(166),19,ex3(:),4,G2H2(143),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_UW_V(ntryL,G1H4(167),19,ex3(:),4,G2H2(144),m3h2x2(:,149),heltab2x4(:,:,149))
call HGT_OLR(G1H4(168),1,1,4)
call HGT_invQ_OLR(G1H4(168),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(168),ex4(:),G1H2(6),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_UW_V(ntryL,G1H4(171),19,ex3(:),4,G2H2(145),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_UW_V(ntryL,G1H4(172),19,ex3(:),4,G2H2(146),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_UW_V(ntryL,G1H4(173),19,ex3(:),4,G2H2(147),m3h2x2(:,153),heltab2x4(:,:,153))
call HGT_raise_alpha_OLR(G1H4(174),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(174),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(174),-8,ex4(:),8,G2H2(148),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_UW_V(ntryL,G1H4(177),19,ex3(:),4,G2H2(149),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_UW_V(ntryL,G1H4(178),19,ex3(:),4,G2H2(150),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_AV_Q(ntryL,G1H4(179),ex4(:),G1H2(7),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(7),27,nML,G2H2(151),n2h2(52))
call HGT_OLR(G1H4(180),1,1,4)
call HGT_invQ_OLR(G1H4(180),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(180),-4,nML,G2H4(65),n2h4(86))
  call Hloop_QV_A(ntryL,G2H4(65),ex3(:),G2H2(152),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_AV_Q(ntryL,G1H4(183),ex4(:),G1H2(7),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(7),27,nML,G2H2(153),n2h2(53))
  call Hloop_AV_Q(ntryL,G1H4(184),ex4(:),G1H2(7),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(7),27,nML,G2H2(154),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H4(185),ex4(:),G1H2(7),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(7),27,nML,G2H2(155),n2h2(55))
call HGT_OLR(G1H4(186),1,1,4)
call HGT_invQ_OLR(G1H4(186),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(186),-4,nML,G2H4(78),n2h4(87))
  call Hloop_QV_A(ntryL,G2H4(78),ex3(:),G2H2(156),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_AV_Q(ntryL,G1H4(189),ex4(:),G1H2(7),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(7),27,nML,G2H2(157),n2h2(56))
  call Hloop_AV_Q(ntryL,G1H4(190),ex4(:),G1H2(7),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(7),27,nML,G2H2(158),n2h2(57))
  call Hloop_SV_T(ntryL,G1H4(191),19,ex4(:),8,G2H2(159),m3h2x2(:,165),heltab2x4(:,:,165))
call HGT_OLR(G1H4(192),1,1,4)
call HGT_invQ_OLR(G1H4(192),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(192),-4,ex3(:),4,G2H2(160),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_SV_T(ntryL,G1H4(195),19,ex4(:),8,G2H2(161),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_SV_T(ntryL,G1H4(196),19,ex4(:),8,G2H2(162),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_AV_Q(ntryL,G1H4(197),ex4(:),G1H2(7),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(7),27,nML,G2H2(163),n2h2(58))
call HGT_OLR(G1H4(198),1,1,4)
call HGT_invQ_OLR(G1H4(198),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(198),-4,nML,G2H4(70),n2h4(89))
  call Hloop_QV_A(ntryL,G2H4(70),ex3(:),G2H2(164),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_AV_Q(ntryL,G1H4(201),ex4(:),G1H2(7),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(7),27,nML,G2H2(165),n2h2(59))
  call Hloop_AV_Q(ntryL,G1H4(202),ex4(:),G1H2(7),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(7),27,nML,G2H2(166),n2h2(60))
  call Hloop_SV_T(ntryL,G1H4(203),19,ex4(:),8,G2H2(167),m3h2x2(:,173),heltab2x4(:,:,173))
call HGT_raise_alpha_OLR(G1H4(204),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(204),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(204),ex3(:),G1H2(7),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_SV_T(ntryL,G1H4(207),19,ex4(:),8,G2H2(168),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_SV_T(ntryL,G1H4(208),19,ex4(:),8,G2H2(169),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_UW_V(ntryL,G1H4(209),19,ex4(:),8,G2H2(170),m3h2x2(:,177),heltab2x4(:,:,177))
call HGT_OLR(G1H4(210),1,1,4)
call HGT_invQ_OLR(G1H4(210),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(210),ex3(:),G1H2(8),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_UW_V(ntryL,G1H4(213),19,ex4(:),8,G2H2(171),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_UW_V(ntryL,G1H4(214),19,ex4(:),8,G2H2(172),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_UW_V(ntryL,G1H4(215),19,ex4(:),8,G2H2(173),m3h2x2(:,181),heltab2x4(:,:,181))
call HGT_raise_alpha_OLR(G1H4(216),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(216),-4,ex3(:),4,G2H2(174),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_UW_V(ntryL,G1H4(219),19,ex4(:),8,G2H2(175),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_UW_V(ntryL,G1H4(220),19,ex4(:),8,G2H2(176),m3h2x2(:,184),heltab2x4(:,:,184))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G2H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(173),[G2H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G2H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(90)])
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,1),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(10),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,1),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(16),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(76),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(3),mass5set(:,7),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(3),mass5set(:,7),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(73),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(2),mass5set(:,1),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(2),mass5set(:,1),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(118),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hotf_5pt_reduction(G2H2(107),RedSet_5(4),mass5set(:,7),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),4,2)
  call Hotf_5pt_reduction(G2H2(121),RedSet_5(4),mass5set(:,7),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(115),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(144),ex4(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hotf_5pt_reduction(G2H2(133),RedSet_5(5),mass5set(:,7),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),8,2)
  call Hotf_5pt_reduction(G2H2(147),RedSet_5(5),mass5set(:,7),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(141),ex4(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(170),ex3(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hotf_5pt_reduction(G2H2(159),RedSet_5(6),mass5set(:,7),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),4,2)
  call Hotf_5pt_reduction(G2H2(173),RedSet_5(6),mass5set(:,7),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(167),ex3(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(1),mass4set(:,1),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),2)
  call HG1shiftOLR(G1H2(82),10,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(28),ex4(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(30),ex4(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(1),mass4set(:,1),  & 
G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(87),10,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(2),mass4set(:,1),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(92),9,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(2),mass4set(:,1),  & 
G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(97),9,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(1),mass5set(:,2),  & 
G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(102),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(1),mass4set(:,2),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),2)
  call HG1shiftOLR(G1H2(108),10,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(1),mass5set(:,3),  & 
G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),2)
  call HG1shiftOLR(G1H2(113),8,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(1),mass4set(:,3),  & 
G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(119),10,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(1),mass5set(:,4),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(124),8,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(1),mass4set(:,4),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),2)
  call HG1shiftOLR(G1H2(130),10,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(3),mass5set(:,5),  & 
G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(135),8,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(3),mass4set(:,5),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(141),12,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(3),mass5set(:,6),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),8,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(3),mass4set(:,6),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),2)
  call HG1shiftOLR(G1H2(152),12,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(3),mass4set(:,7),  & 
G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(157),12,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(3),mass5set(:,8),  & 
G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(162),8,2)
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(3),mass4set(:,8),  & 
G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),2)
  call HG1shiftOLR(G1H2(168),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(75),ex4(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(78),ex4(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(3),mass4set(:,7),  & 
G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),2)
  call HG1shiftOLR(G1H2(173),12,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(2),mass5set(:,2),  & 
G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(178),8,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(2),mass4set(:,2),  & 
G1H2(183),G1H2(184),G1H2(185),G1H2(186),G1H2(187),2)
  call HG1shiftOLR(G1H2(184),9,2)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(2),mass5set(:,3),  & 
G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(189),8,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(2),mass4set(:,3),  & 
G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(195),9,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(2),mass5set(:,4),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),8,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(2),mass4set(:,4),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),2)
  call HG1shiftOLR(G1H2(206),9,2)
  call Hotf_5pt_reduction(G2H2(99),RedSet_5(4),mass5set(:,5),  & 
G1H2(210),G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),2)
  call HG1shiftOLR(G1H2(211),4,2)
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(3),mass4set(:,5),  & 
G1H2(216),G1H2(217),G1H2(218),G1H2(219),G1H2(220),2)
  call HG1shiftOLR(G1H2(217),12,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(4),mass5set(:,6),  & 
G1H2(221),G1H2(222),G1H2(223),G1H2(224),G1H2(225),G1H2(226),2)
  call HG1shiftOLR(G1H2(222),4,2)
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(3),mass4set(:,6),  & 
G1H2(227),G1H2(228),G1H2(229),G1H2(230),G1H2(231),2)
  call HG1shiftOLR(G1H2(228),12,2)
  call Hotf_4pt_reduction(G2H2(110),RedSet_4(3),mass4set(:,7),  & 
G1H2(232),G1H2(233),G1H2(234),G1H2(235),G1H2(236),2)
  call HG1shiftOLR(G1H2(233),12,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(4),mass5set(:,8),  & 
G1H2(237),G1H2(238),G1H2(239),G1H2(240),G1H2(241),G1H2(242),2)
  call HG1shiftOLR(G1H2(238),4,2)
  call Hotf_4pt_reduction(G2H2(114),RedSet_4(3),mass4set(:,8),  & 
G1H2(243),G1H2(244),G1H2(245),G1H2(246),G1H2(247),2)
  call HG1shiftOLR(G1H2(244),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(117),ex3(:),G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(120),ex3(:),G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hotf_4pt_reduction(G2H2(124),RedSet_4(3),mass4set(:,7),  & 
G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(249),12,2)
  call Hotf_5pt_reduction(G2H2(125),RedSet_5(5),mass5set(:,5),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(254),8,2)
  call Hotf_4pt_reduction(G2H2(128),RedSet_4(4),mass4set(:,5),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),2)
  call HG1shiftOLR(G1H2(260),12,2)
  call Hotf_5pt_reduction(G2H2(129),RedSet_5(5),mass5set(:,6),  & 
G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),2)
  call HG1shiftOLR(G1H2(265),8,2)
  call Hotf_4pt_reduction(G2H2(132),RedSet_4(4),mass4set(:,6),  & 
G1H2(270),G1H2(271),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(271),12,2)
  call Hotf_4pt_reduction(G2H2(136),RedSet_4(4),mass4set(:,7),  & 
G1H2(275),G1H2(276),G1H2(277),G1H2(278),G1H2(279),2)
  call HG1shiftOLR(G1H2(276),12,2)
  call Hotf_5pt_reduction(G2H2(137),RedSet_5(5),mass5set(:,8),  & 
G1H2(280),G1H2(281),G1H2(282),G1H2(283),G1H2(284),G1H2(285),2)
  call HG1shiftOLR(G1H2(281),8,2)
  call Hotf_4pt_reduction(G2H2(140),RedSet_4(4),mass4set(:,8),  & 
G1H2(286),G1H2(287),G1H2(288),G1H2(289),G1H2(290),2)
  call HG1shiftOLR(G1H2(287),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(143),ex4(:),G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(146),ex4(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hotf_4pt_reduction(G2H2(150),RedSet_4(4),mass4set(:,7),  & 
G1H2(291),G1H2(292),G1H2(293),G1H2(294),G1H2(295),2)
  call HG1shiftOLR(G1H2(292),12,2)
  call Hotf_5pt_reduction(G2H2(151),RedSet_5(6),mass5set(:,5),  & 
G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),G1H2(301),2)
  call HG1shiftOLR(G1H2(297),4,2)
  call Hotf_4pt_reduction(G2H2(154),RedSet_4(4),mass4set(:,5),  & 
G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),2)
  call HG1shiftOLR(G1H2(303),12,2)
  call Hotf_5pt_reduction(G2H2(155),RedSet_5(6),mass5set(:,6),  & 
G1H2(307),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),4,2)
  call Hotf_4pt_reduction(G2H2(158),RedSet_4(4),mass4set(:,6),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),2)
  call HG1shiftOLR(G1H2(314),12,2)
  call Hotf_4pt_reduction(G2H2(162),RedSet_4(4),mass4set(:,7),  & 
G1H2(318),G1H2(319),G1H2(320),G1H2(321),G1H2(322),2)
  call HG1shiftOLR(G1H2(319),12,2)
  call Hotf_5pt_reduction(G2H2(163),RedSet_5(6),mass5set(:,8),  & 
G1H2(323),G1H2(324),G1H2(325),G1H2(326),G1H2(327),G1H2(328),2)
  call HG1shiftOLR(G1H2(324),4,2)
  call Hotf_4pt_reduction(G2H2(166),RedSet_4(4),mass4set(:,8),  & 
G1H2(329),G1H2(330),G1H2(331),G1H2(332),G1H2(333),2)
  call HG1shiftOLR(G1H2(330),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(169),ex3(:),G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(172),ex3(:),G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hotf_4pt_reduction(G2H2(176),RedSet_4(4),mass4set(:,7),  & 
G1H2(334),G1H2(335),G1H2(336),G1H2(337),G1H2(338),2)
  call HG1shiftOLR(G1H2(335),12,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(81),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(86),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(156),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(172),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(96),[G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(232),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(248),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(275),[G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(291),[G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(318),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(334),[G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(107),[G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(118),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(140),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(151),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(167),[G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(183),[G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(194),[G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(205),[G1H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(216),[G1H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(227),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(259),[G1H2(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(270),[G1H2(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(286),[G1H2(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(302),[G1H2(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(313),[G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(329),[G1H2(328)])
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(9),23,ex4(:),8,G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(10),0,ex4(:),8,G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(81),23,ex4(:),8,G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(15),23,ex4(:),8,G2tensor(28),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(16),0,ex4(:),8,G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(86),23,ex4(:),8,G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(21),23,ex4(:),8,G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(22),0,ex4(:),8,G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(156),23,ex4(:),8,G2tensor(33),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(27),23,ex4(:),8,G2tensor(34),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(28),0,ex4(:),8,G2tensor(35),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(172),23,ex4(:),8,G2tensor(36),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(33),23,ex4(:),8,G2tensor(37),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(34),0,ex4(:),8,G2tensor(38),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(91),23,ex4(:),8,G2tensor(39),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(39),23,ex4(:),8,G2tensor(40),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(40),0,ex4(:),8,G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(96),23,ex4(:),8,G2tensor(42),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(45),27,ex3(:),4,G2tensor(43),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(46),0,ex3(:),4,G2tensor(44),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(232),27,ex3(:),4,G2tensor(45),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(51),27,ex3(:),4,G2tensor(46),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(52),0,ex3(:),4,G2tensor(47),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(248),27,ex3(:),4,G2tensor(48),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(57),23,ex4(:),8,G2tensor(49),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(58),0,ex4(:),8,G2tensor(50),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(275),23,ex4(:),8,G2tensor(51),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(63),23,ex4(:),8,G2tensor(52),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(64),0,ex4(:),8,G2tensor(53),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(291),23,ex4(:),8,G2tensor(54),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(69),27,ex3(:),4,G2tensor(55),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(70),0,ex3(:),4,G2tensor(56),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(318),27,ex3(:),4,G2tensor(57),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(75),27,ex3(:),4,G2tensor(58),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(76),0,ex3(:),4,G2tensor(59),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(334),27,ex3(:),4,G2tensor(60),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(82),2,ex4(:),8,G2tensor(61),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(87),2,ex4(:),8,G2tensor(62),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(92),1,ex4(:),8,G2tensor(63),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(97),1,ex4(:),8,G2tensor(64),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hloop_AV_Q(ntryL,G1H2(101),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(65),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nML,G2tensor(66),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(67),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(108),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nML,G2tensor(68),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(69),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nML,G2tensor(70),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(71),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(119),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nML,G2tensor(72),n2h1(24))
  call Hloop_AV_Q(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(73),n2h1(25))
  call Hloop_AV_Q(ntryL,G1H2(124),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nML,G2tensor(74),n2h1(26))
  call Hloop_AV_Q(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(75),n2h1(27))
  call Hloop_AV_Q(ntryL,G1H2(130),ex4(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nML,G2tensor(76),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(77),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(135),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nML,G2tensor(78),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(79),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(141),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nML,G2tensor(80),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(81),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nML,G2tensor(82),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(83),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nML,G2tensor(84),n2h1(36))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(157),4,ex4(:),8,G2tensor(85),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hloop_QV_A(ntryL,G1H2(161),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(86),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(162),ex4(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nML,G2tensor(87),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(167),ex4(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(88),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nML,G2tensor(89),n2h1(41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(173),4,ex4(:),8,G2tensor(90),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hloop_QV_A(ntryL,G1H2(177),ex4(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(91),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(178),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nML,G2tensor(92),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(183),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(93),n2h1(45))
  call Hloop_QV_A(ntryL,G1H2(184),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nML,G2tensor(94),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(188),ex4(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(95),n2h1(47))
  call Hloop_QV_A(ntryL,G1H2(189),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nML,G2tensor(96),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(97),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(195),ex4(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nML,G2tensor(98),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(199),ex4(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(99),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nML,G2tensor(100),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(205),ex4(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(101),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(206),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nML,G2tensor(102),n2h1(54))
  call Hloop_QV_A(ntryL,G1H2(210),ex3(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(103),n2h1(55))
  call Hloop_QV_A(ntryL,G1H2(211),ex3(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nML,G2tensor(104),n2h1(56))
  call Hloop_QV_A(ntryL,G1H2(216),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(105),n2h1(57))
  call Hloop_QV_A(ntryL,G1H2(217),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nML,G2tensor(106),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(221),ex3(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(107),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(222),ex3(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nML,G2tensor(108),n2h1(60))
  call Hloop_QV_A(ntryL,G1H2(227),ex3(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(109),n2h1(61))
  call Hloop_QV_A(ntryL,G1H2(228),ex3(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nML,G2tensor(110),n2h1(62))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(233),8,ex3(:),4,G2tensor(111),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hloop_QV_A(ntryL,G1H2(237),ex3(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(112),n2h1(64))
  call Hloop_QV_A(ntryL,G1H2(238),ex3(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nML,G2tensor(113),n2h1(65))
  call Hloop_QV_A(ntryL,G1H2(243),ex3(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(114),n2h1(66))
  call Hloop_QV_A(ntryL,G1H2(244),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nML,G2tensor(115),n2h1(67))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(249),8,ex3(:),4,G2tensor(116),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hloop_AV_Q(ntryL,G1H2(253),ex4(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(117),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(254),ex4(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nML,G2tensor(118),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H2(259),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(119),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(260),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nML,G2tensor(120),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H2(264),ex4(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(121),n2h1(73))
  call Hloop_AV_Q(ntryL,G1H2(265),ex4(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nML,G2tensor(122),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H2(270),ex4(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(123),n2h1(75))
  call Hloop_AV_Q(ntryL,G1H2(271),ex4(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nML,G2tensor(124),n2h1(76))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(276),4,ex4(:),8,G2tensor(125),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hloop_AV_Q(ntryL,G1H2(280),ex4(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(126),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(281),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nML,G2tensor(127),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(286),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(128),n2h1(80))
  call Hloop_AV_Q(ntryL,G1H2(287),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nML,G2tensor(129),n2h1(81))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(292),4,ex4(:),8,G2tensor(130),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hloop_AV_Q(ntryL,G1H2(296),ex3(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(131),n2h1(83))
  call Hloop_AV_Q(ntryL,G1H2(297),ex3(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nML,G2tensor(132),n2h1(84))
  call Hloop_AV_Q(ntryL,G1H2(302),ex3(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(133),n2h1(85))
  call Hloop_AV_Q(ntryL,G1H2(303),ex3(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nML,G2tensor(134),n2h1(86))
  call Hloop_AV_Q(ntryL,G1H2(307),ex3(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(135),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(308),ex3(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nML,G2tensor(136),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H2(313),ex3(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(137),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(314),ex3(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nML,G2tensor(138),n2h1(90))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(319),8,ex3(:),4,G2tensor(139),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hloop_AV_Q(ntryL,G1H2(323),ex3(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(140),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(324),ex3(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nML,G2tensor(141),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(329),ex3(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(142),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H2(330),ex3(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nML,G2tensor(143),n2h1(95))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(335),8,ex3(:),4,G2tensor(144),m3h2x1(:,144),heltab2x2(:,:,144))
  call ol_merge_tensors(G2tensor(28),[G2tensor(25),G2tensor(2),G2tensor(1)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(31),G2tensor(4),G2tensor(3)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(37),G2tensor(6),G2tensor(5)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(43),G2tensor(8),G2tensor(7)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(49),G2tensor(10),G2tensor(9)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(55),G2tensor(12),G2tensor(11)])
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(3),mass5set(:,7),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(4),mass5set(:,7),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(5),mass5set(:,7),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(6),mass5set(:,7),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(1),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(1),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(1),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(3),mass5set(:,5),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(3),mass5set(:,6),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(86),RedSet_5(3),mass5set(:,8),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(2),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(2),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(2),mass5set(:,4),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(4),mass5set(:,5),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(4),mass5set(:,6),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(4),mass5set(:,8),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(5),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(5),mass5set(:,6),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(126),RedSet_5(5),mass5set(:,8),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(6),mass5set(:,5),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(6),mass5set(:,6),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(140),RedSet_5(6),mass5set(:,8),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(9),m4h2x2x8(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(1),m4h2x2x8(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(2),m4h2x2x8(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(5),m4h2x2x8(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(7),m4h2x2x8(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(6),m4h2x2x8(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(8),m4h2x2x8(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(10),m4h2x2x8(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(11),m4h2x2x8(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(12),m4h2x2x8(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(13),m4h2x2x8(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(14),m4h2x2x8(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(15),m4h2x2x8(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(16),m4h2x2x8(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,121),heltab2x32(:,:,121))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,122),heltab2x32(:,:,122))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,123),heltab2x32(:,:,123))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,124),heltab2x32(:,:,124))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,125),heltab2x32(:,:,125))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,126),heltab2x32(:,:,126))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,127),heltab2x32(:,:,127))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,128),heltab2x32(:,:,128))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G0H16(5),16,nME,G1H16(5),n2h16(25))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_Q_A(ntryL,G0H16(6),16,nMM,G1H16(6),n2h16(26))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_Q_A(ntryL,G0H16(7),16,nML,G1H16(7),n2h16(27))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(8),16,nME,G1H16(8),n2h16(28))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMM,G1H16(9),n2h16(29))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,134),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(10),16,nML,G1H16(10),n2h16(30))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_Q_A(ntryL,G0H16(11),16,nMT,G1H16(11),n2h16(31))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G0H16(12),16,nMT,G1H16(12),n2h16(32))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,137),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G0H16(13),16,nMB,G1H16(13),n2h16(33))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,138),heltab2x32(:,:,138))
  call Hloop_A_Q(ntryL,G0H16(14),16,nMB,G1H16(14),n2h16(34))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,139),heltab2x32(:,:,139))
  call Hloop_Q_A(ntryL,G0H16(15),16,nME,G1H16(15),n2h16(35))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G0H16(16),16,nMM,G1H16(16),n2h16(36))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G0H16(17),16,nML,G1H16(17),n2h16(37))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_A_Q(ntryL,G0H16(18),16,nME,G1H16(18),n2h16(38))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_A_Q(ntryL,G0H16(19),16,nMM,G1H16(19),n2h16(39))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_A_Q(ntryL,G0H16(20),16,nML,G1H16(20),n2h16(40))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G0H16(21),16,nMT,G1H16(21),n2h16(41))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,146),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G0H16(22),16,nMT,G1H16(22),n2h16(42))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,147),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(23),16,nMB,G1H16(23),n2h16(43))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,148),heltab2x32(:,:,148))
  call Hloop_A_Q(ntryL,G0H16(24),16,nMB,G1H16(24),n2h16(44))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,149),heltab2x32(:,:,149))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,150),heltab2x32(:,:,150))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,151),heltab2x32(:,:,151))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(28),m3h2x16(:,152),heltab2x32(:,:,152))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,153),heltab2x32(:,:,153))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(30),m3h2x16(:,154),heltab2x32(:,:,154))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,155),heltab2x32(:,:,155))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(32),m3h2x16(:,156),heltab2x32(:,:,156))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,157),heltab2x32(:,:,157))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(34),m3h2x16(:,158),heltab2x32(:,:,158))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,159),heltab2x32(:,:,159))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,160),heltab2x32(:,:,160))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,161),heltab2x32(:,:,161))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,162),heltab2x32(:,:,162))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,163),heltab2x32(:,:,163))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,164),heltab2x32(:,:,164))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(37),m3h2x16(:,165),heltab2x32(:,:,165))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,166),heltab2x32(:,:,166))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,167),heltab2x32(:,:,167))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,168),heltab2x32(:,:,168))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,169),heltab2x32(:,:,169))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,170),heltab2x32(:,:,170))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,171),heltab2x32(:,:,171))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,172),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,173),heltab2x32(:,:,173))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,174),heltab2x32(:,:,174))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,175),heltab2x32(:,:,175))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,176),heltab2x32(:,:,176))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,177),heltab2x32(:,:,177))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,178),heltab2x32(:,:,178))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,179),heltab2x32(:,:,179))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,180),heltab2x32(:,:,180))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,181),heltab2x32(:,:,181))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,182),heltab2x32(:,:,182))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,183),heltab2x32(:,:,183))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,184),heltab2x32(:,:,184))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,185),heltab2x32(:,:,185))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,186),heltab2x32(:,:,186))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,187),heltab2x32(:,:,187))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,188),heltab2x32(:,:,188))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,189),heltab2x32(:,:,189))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,190),heltab2x32(:,:,190))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,191),heltab2x32(:,:,191))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,192),heltab2x32(:,:,192))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,193),heltab2x32(:,:,193))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,194),heltab2x32(:,:,194))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,195),heltab2x32(:,:,195))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,196),heltab2x32(:,:,196))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,197),heltab2x32(:,:,197))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,198),heltab2x32(:,:,198))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,199),heltab2x32(:,:,199))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,200),heltab2x32(:,:,200))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,201),heltab2x32(:,:,201))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,202),heltab2x32(:,:,202))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,203),heltab2x32(:,:,203))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,204),heltab2x32(:,:,204))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,205),heltab2x32(:,:,205))
  call Hloop_Q_A(ntryL,G0H16(5),16,nME,G1H16(57),n2h16(45))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,206),heltab2x32(:,:,206))
  call Hloop_Q_A(ntryL,G0H16(6),16,nMM,G1H16(58),n2h16(46))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,207),heltab2x32(:,:,207))
  call Hloop_Q_A(ntryL,G0H16(7),16,nML,G1H16(59),n2h16(47))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,208),heltab2x32(:,:,208))
  call Hloop_A_Q(ntryL,G0H16(8),16,nME,G1H16(60),n2h16(48))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,209),heltab2x32(:,:,209))
  call Hloop_A_Q(ntryL,G0H16(9),16,nMM,G1H16(61),n2h16(49))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,210),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G0H16(10),16,nML,G1H16(62),n2h16(50))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,211),heltab2x32(:,:,211))
  call Hloop_Q_A(ntryL,G0H16(11),16,0,G1H16(63),n2h16(51))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,212),heltab2x32(:,:,212))
  call Hloop_Q_A(ntryL,G0H16(12),16,nMT,G1H16(64),n2h16(52))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,213),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G0H16(13),16,0,G1H16(65),n2h16(53))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,214),heltab2x32(:,:,214))
  call Hloop_A_Q(ntryL,G0H16(14),16,nMT,G1H16(66),n2h16(54))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,215),heltab2x32(:,:,215))
  call Hloop_Q_A(ntryL,G0H16(15),16,0,G1H16(67),n2h16(55))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,216),heltab2x32(:,:,216))
  call Hloop_Q_A(ntryL,G0H16(16),16,nMB,G1H16(68),n2h16(56))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,217),heltab2x32(:,:,217))
  call Hloop_A_Q(ntryL,G0H16(17),16,0,G1H16(69),n2h16(57))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,218),heltab2x32(:,:,218))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMB,G1H16(70),n2h16(58))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,219),heltab2x32(:,:,219))
  call Hloop_Q_A(ntryL,G0H16(19),16,nME,G1H16(71),n2h16(59))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,220),heltab2x32(:,:,220))
  call Hloop_Q_A(ntryL,G0H16(20),16,nMM,G1H16(72),n2h16(60))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,221),heltab2x32(:,:,221))
  call Hloop_Q_A(ntryL,G0H16(21),16,nML,G1H16(73),n2h16(61))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,222),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G0H16(22),16,nME,G1H16(74),n2h16(62))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,223),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G0H16(23),16,nMM,G1H16(75),n2h16(63))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,224),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G0H16(24),16,nML,G1H16(76),n2h16(64))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,225),heltab2x32(:,:,225))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(77),n2h16(65))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,226),heltab2x32(:,:,226))
  call Hloop_Q_A(ntryL,G0H16(6),16,nMT,G1H16(78),n2h16(66))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,227),heltab2x32(:,:,227))
  call Hloop_A_Q(ntryL,G0H16(7),16,0,G1H16(79),n2h16(67))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,228),heltab2x32(:,:,228))
  call Hloop_A_Q(ntryL,G0H16(8),16,nMT,G1H16(80),n2h16(68))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,229),heltab2x32(:,:,229))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(81),n2h16(69))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,230),heltab2x32(:,:,230))
  call Hloop_Q_A(ntryL,G0H16(10),16,nMB,G1H16(82),n2h16(70))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,231),heltab2x32(:,:,231))
  call Hloop_A_Q(ntryL,G0H16(11),16,0,G1H16(83),n2h16(71))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,232),heltab2x32(:,:,232))
  call Hloop_A_Q(ntryL,G0H16(12),16,nMB,G1H16(84),n2h16(72))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(85),m3h2x16(:,233),heltab2x32(:,:,233))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(86),m3h2x16(:,234),heltab2x32(:,:,234))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(87),m3h2x16(:,235),heltab2x32(:,:,235))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(88),m3h2x16(:,236),heltab2x32(:,:,236))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(89),m3h2x16(:,237),heltab2x32(:,:,237))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(90),m3h2x16(:,238),heltab2x32(:,:,238))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(91),m3h2x16(:,239),heltab2x32(:,:,239))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(92),m3h2x16(:,240),heltab2x32(:,:,240))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(93),m3h2x16(:,241),heltab2x32(:,:,241))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(94),m3h2x16(:,242),heltab2x32(:,:,242))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(95),m3h2x16(:,243),heltab2x32(:,:,243))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(96),m3h2x16(:,244),heltab2x32(:,:,244))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,245),heltab2x32(:,:,245))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(98),m3h2x16(:,246),heltab2x32(:,:,246))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,247),heltab2x32(:,:,247))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,248),heltab2x32(:,:,248))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,249),heltab2x32(:,:,249))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,250),heltab2x32(:,:,250))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,251),heltab2x32(:,:,251))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,252),heltab2x32(:,:,252))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(101),m3h2x16(:,253),heltab2x32(:,:,253))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,254),heltab2x32(:,:,254))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(103),m3h2x16(:,255),heltab2x32(:,:,255))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(104),m3h2x16(:,256),heltab2x32(:,:,256))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,257),heltab2x32(:,:,257))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,258),heltab2x32(:,:,258))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,259),heltab2x32(:,:,259))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,260),heltab2x32(:,:,260))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(105),m3h2x16(:,261),heltab2x32(:,:,261))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(106),m3h2x16(:,262),heltab2x32(:,:,262))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(107),m3h2x16(:,263),heltab2x32(:,:,263))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,264),heltab2x32(:,:,264))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,265),heltab2x32(:,:,265))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,266),heltab2x32(:,:,266))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,267),heltab2x32(:,:,267))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,268),heltab2x32(:,:,268))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(109),m3h2x16(:,269),heltab2x32(:,:,269))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(110),m3h2x16(:,270),heltab2x32(:,:,270))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,271),heltab2x32(:,:,271))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(112),m3h2x16(:,272),heltab2x32(:,:,272))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,273),heltab2x32(:,:,273))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,274),heltab2x32(:,:,274))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,275),heltab2x32(:,:,275))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,276),heltab2x32(:,:,276))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,277),heltab2x32(:,:,277))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,278),heltab2x32(:,:,278))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,279),heltab2x32(:,:,279))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,280),heltab2x32(:,:,280))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(113),m3h2x16(:,281),heltab2x32(:,:,281))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(114),m3h2x16(:,282),heltab2x32(:,:,282))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(115),m3h2x16(:,283),heltab2x32(:,:,283))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(116),m3h2x16(:,284),heltab2x32(:,:,284))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,285),heltab2x32(:,:,285))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,286),heltab2x32(:,:,286))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,287),heltab2x32(:,:,287))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,288),heltab2x32(:,:,288))



end subroutine vamp_1

end module ol_vamp_1_ppllj_ew_llxaaa_1_/**/REALKIND
