
module ol_vamp_1_ppllj2_nenexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj2_nenexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj2_nenexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllj2_nenexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllj2_nenexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,19) :: G0
  complex(REALKIND), dimension(4,5,4,54) :: G1
  complex(REALKIND), dimension(4,15,4,78) :: G2
  complex(REALKIND), dimension(4,35,4,42) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,24,32))
    allocate(G4tensorhel(70,24,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,28),ZERO,G2(:,:,:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,3),G2(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,3),G2(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,31),ZERO,G3tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,12),MT,G1(:,:,:,3))
  call loop_AV_Q(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,28),MT,G2(:,:,:,4))
  call loop_AZ_Q(G2(:,:,:,4),wf(:,3),G2(:,:,:,5),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,31),MT,G3tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,12),ZERO,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,-4),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,28),ZERO,G2(:,:,:,6))
  call loop_QZ_A(G2(:,:,:,6),wf(:,3),G2(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,31),ZERO,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,6),wf(:,3),G2(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),ZERO,G3tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MT,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,28),MT,G2(:,:,:,9))
  call loop_QZ_A(G2(:,:,:,9),wf(:,3),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,31),MT,G3tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,12),MB,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,-4),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,28),MB,G2(:,:,:,11))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,3),G2(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,31),MB,G3tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,12),MB,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,28),MB,G2(:,:,:,13))
  call loop_QZ_A(G2(:,:,:,13),wf(:,3),G2(:,:,:,14),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,31),MB,G3tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,8),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,7),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,28),ZERO,G2(:,:,:,15))
  call loop_QZ_A(G2(:,:,:,15),wf(:,3),G2(:,:,:,16),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,31),ZERO,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,15),wf(:,3),G2(:,:,:,17),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,31),ZERO,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,13),wf(:,-2),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,12),ZERO,G2(:,:,:,18))
  call loop_QV_A(G2(:,:,:,18),wf(:,-4),G2(:,:,:,19))
  call loop_Q_A(G2(:,:,:,19),Q(:,28),ZERO,G3(:,:,:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,3),G3(:,:,:,2),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,31),ZERO,G4tensor(:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,3),G3(:,:,:,3),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,3),Q(:,31),ZERO,G4tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,8),MT,G1(:,:,:,16))
  call loop_QV_A(G1(:,:,:,16),wf(:,7),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,28),MT,G2(:,:,:,20))
  call loop_QZ_A(G2(:,:,:,20),wf(:,3),G2(:,:,:,21),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,21),Q(:,31),MT,G3tensor(:,11))
  call loop_QV_A(G1(:,:,:,16),wf(:,-2),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,12),MT,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,-4),G2(:,:,:,23))
  call loop_Q_A(G2(:,:,:,23),Q(:,28),MT,G3(:,:,:,4))
  call loop_QZ_A(G3(:,:,:,4),wf(:,3),G3(:,:,:,5),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,5),Q(:,31),MT,G4tensor(:,3))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,8),ZERO,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,7),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,28),ZERO,G2(:,:,:,24))
  call loop_AZ_Q(G2(:,:,:,24),wf(:,3),G2(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,31),ZERO,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,24),wf(:,3),G2(:,:,:,26),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,31),ZERO,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-2),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,12),ZERO,G2(:,:,:,27))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-4),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,28),ZERO,G3(:,:,:,6))
  call loop_AZ_Q(G3(:,:,:,6),wf(:,3),G3(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,7),Q(:,31),ZERO,G4tensor(:,4))
  call loop_AZ_Q(G3(:,:,:,6),wf(:,3),G3(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,31),ZERO,G4tensor(:,5))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,8),MT,G1(:,:,:,22))
  call loop_AV_Q(G1(:,:,:,22),wf(:,7),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,28),MT,G2(:,:,:,29))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,3),G2(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,31),MT,G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,22),wf(:,-2),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,12),MT,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,-4),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,28),MT,G3(:,:,:,9))
  call loop_AZ_Q(G3(:,:,:,9),wf(:,3),G3(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,31),MT,G4tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,8),MB,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,7),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,28),MB,G2(:,:,:,33))
  call loop_QZ_A(G2(:,:,:,33),wf(:,3),G2(:,:,:,34),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,31),MB,G3tensor(:,15))
  call loop_QV_A(G1(:,:,:,25),wf(:,-2),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,12),MB,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,-4),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,28),MB,G3(:,:,:,11))
  call loop_QZ_A(G3(:,:,:,11),wf(:,3),G3(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,31),MB,G4tensor(:,7))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,8),MB,G1(:,:,:,28))
  call loop_AV_Q(G1(:,:,:,28),wf(:,7),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,28),MB,G2(:,:,:,37))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,3),G2(:,:,:,38),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,31),MB,G3tensor(:,16))
  call loop_AV_Q(G1(:,:,:,28),wf(:,-2),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,12),MB,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-4),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,28),MB,G3(:,:,:,13))
  call loop_AZ_Q(G3(:,:,:,13),wf(:,3),G3(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,31),MB,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,4),ZERO,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,9),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,28),ZERO,G2(:,:,:,41))
  call loop_QZ_A(G2(:,:,:,41),wf(:,3),G2(:,:,:,42),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,31),ZERO,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,41),wf(:,3),G2(:,:,:,43),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,43),Q(:,31),ZERO,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,31),wf(:,-3),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,12),ZERO,G2(:,:,:,44))
  call loop_QV_A(G2(:,:,:,44),wf(:,-4),G2(:,:,:,45))
  call loop_Q_A(G2(:,:,:,45),Q(:,28),ZERO,G3(:,:,:,15))
  call loop_QZ_A(G3(:,:,:,15),wf(:,3),G3(:,:,:,16),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,31),ZERO,G4tensor(:,9))
  call loop_QZ_A(G3(:,:,:,15),wf(:,3),G3(:,:,:,17),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,17),Q(:,31),ZERO,G4tensor(:,10))
  call loop_QV_A(G1(:,:,:,31),wf(:,-4),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,20),ZERO,G2(:,:,:,46))
  call loop_QV_A(G2(:,:,:,46),wf(:,-3),G2(:,:,:,47))
  call loop_Q_A(G2(:,:,:,47),Q(:,28),ZERO,G3(:,:,:,18))
  call loop_QZ_A(G3(:,:,:,18),wf(:,3),G3(:,:,:,19),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,19),Q(:,31),ZERO,G4tensor(:,11))
  call loop_QZ_A(G3(:,:,:,18),wf(:,3),G3(:,:,:,20),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,31),ZERO,G4tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,4),MT,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,9),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,28),MT,G2(:,:,:,48))
  call loop_QZ_A(G2(:,:,:,48),wf(:,3),G2(:,:,:,49),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,31),MT,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,35),wf(:,-3),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,12),MT,G2(:,:,:,50))
  call loop_QV_A(G2(:,:,:,50),wf(:,-4),G2(:,:,:,51))
  call loop_Q_A(G2(:,:,:,51),Q(:,28),MT,G3(:,:,:,21))
  call loop_QZ_A(G3(:,:,:,21),wf(:,3),G3(:,:,:,22),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,31),MT,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,35),wf(:,-4),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,20),MT,G2(:,:,:,52))
  call loop_QV_A(G2(:,:,:,52),wf(:,-3),G2(:,:,:,53))
  call loop_Q_A(G2(:,:,:,53),Q(:,28),MT,G3(:,:,:,23))
  call loop_QZ_A(G3(:,:,:,23),wf(:,3),G3(:,:,:,24),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,31),MT,G4tensor(:,14))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,4),ZERO,G1(:,:,:,39))
  call loop_AV_Q(G1(:,:,:,39),wf(:,9),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,28),ZERO,G2(:,:,:,54))
  call loop_AZ_Q(G2(:,:,:,54),wf(:,3),G2(:,:,:,55),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,55),Q(:,31),ZERO,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,54),wf(:,3),G2(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,31),ZERO,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-3),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,12),ZERO,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,28),ZERO,G3(:,:,:,25))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,3),G3(:,:,:,26),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,31),ZERO,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,3),G3(:,:,:,27),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,31),ZERO,G4tensor(:,16))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-4),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,20),ZERO,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-3),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,28),ZERO,G3(:,:,:,28))
  call loop_AZ_Q(G3(:,:,:,28),wf(:,3),G3(:,:,:,29),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,31),ZERO,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,28),wf(:,3),G3(:,:,:,30),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,31),ZERO,G4tensor(:,18))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,4),MT,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,9),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,28),MT,G2(:,:,:,61))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,3),G2(:,:,:,62),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,31),MT,G3tensor(:,22))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-3),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,12),MT,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-4),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,28),MT,G3(:,:,:,31))
  call loop_AZ_Q(G3(:,:,:,31),wf(:,3),G3(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,31),MT,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-4),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,20),MT,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-3),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,28),MT,G3(:,:,:,33))
  call loop_AZ_Q(G3(:,:,:,33),wf(:,3),G3(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,31),MT,G4tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,4),MB,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,9),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,28),MB,G2(:,:,:,67))
  call loop_QZ_A(G2(:,:,:,67),wf(:,3),G2(:,:,:,68),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,31),MB,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,47),wf(:,-3),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,12),MB,G2(:,:,:,69))
  call loop_QV_A(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,28),MB,G3(:,:,:,35))
  call loop_QZ_A(G3(:,:,:,35),wf(:,3),G3(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,31),MB,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,47),wf(:,-4),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,20),MB,G2(:,:,:,71))
  call loop_QV_A(G2(:,:,:,71),wf(:,-3),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,28),MB,G3(:,:,:,37))
  call loop_QZ_A(G3(:,:,:,37),wf(:,3),G3(:,:,:,38),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,31),MB,G4tensor(:,22))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,4),MB,G1(:,:,:,51))
  call loop_AV_Q(G1(:,:,:,51),wf(:,9),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,28),MB,G2(:,:,:,73))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,3),G2(:,:,:,74),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,31),MB,G3tensor(:,24))
  call loop_AV_Q(G1(:,:,:,51),wf(:,-3),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,12),MB,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,-4),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,28),MB,G3(:,:,:,39))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,3),G3(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,31),MB,G4tensor(:,23))
  call loop_AV_Q(G1(:,:,:,51),wf(:,-4),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,20),MB,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,-3),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,28),MB,G3(:,:,:,41))
  call loop_AZ_Q(G3(:,:,:,41),wf(:,3),G3(:,:,:,42),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,31),MB,G4tensor(:,24))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(4) * den(3)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(4)) * den(3)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(3)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(4) * den(3)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(4)) * den(3)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(3)) * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(4) * den(3)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(4)) * den(3)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(4) * den(3)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(4)) * den(3)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3)) * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(4)) * den(5)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,9),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(4) * den(5)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,9),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3)) * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(3) * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(4)) * den(5)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,12),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(4) * den(5)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,12),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3)) * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(3) * den(5)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(4)) * den(5)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,10),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(4) * den(5)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,10),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3)) * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(3) * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(4)) * den(5)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,13),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(4) * den(5)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,13),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3)) * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(3) * den(5)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(4) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(4)) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(3) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(3)) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(4) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(4)) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(3) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(3)) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(4) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(4)) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(3) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(3)) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(4) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(4)) * den(7)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(3) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(3)) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,9))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (-f(5) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,3),T4sum(1:70,2))
  M(2) = M(2) + (-f(6) * den(1)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,4),T4sum(1:70,1))
  M(2) = M(2) + (-f(5) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,6),T4sum(1:70,2))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,2),T4sum(1:70,1))
  M(1) = M(1) + (-f(5) * den(1)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,7),T4sum(1:70,3))
  M(2) = M(2) + (-f(6) * den(1)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,5),T4sum(1:70,1))
  M(2) = M(2) + (-f(5) * den(1)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,8),T4sum(1:70,3))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,15),T4sum(1:70,4))
  M(1) = M(1) + (-f(5) * den(1)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,19),T4sum(1:70,5))
  M(2) = M(2) + (-f(6) * den(1)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,9),T4sum(1:70,4))
  M(2) = M(2) + (-f(5) * den(1)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,13),T4sum(1:70,5))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,16),T4sum(1:70,4))
  M(1) = M(1) + (-f(5) * den(1)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,23),T4sum(1:70,6))
  M(2) = M(2) + (-f(6) * den(1)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,10),T4sum(1:70,4))
  M(2) = M(2) + (-f(5) * den(1)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,21),T4sum(1:70,6))
  M(2) = M(2) + (-f(6) * den(1)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,17),T4sum(1:70,7))
  M(2) = M(2) + (-f(5) * den(1)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,20),T4sum(1:70,8))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,11),T4sum(1:70,7))
  M(1) = M(1) + (-f(5) * den(1)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,14),T4sum(1:70,8))
  M(2) = M(2) + (-f(6) * den(1)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,18),T4sum(1:70,7))
  M(2) = M(2) + (-f(5) * den(1)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,24),T4sum(1:70,9))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,12),T4sum(1:70,7))
  M(1) = M(1) + (-f(5) * den(1)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,22),T4sum(1:70,9))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllj2_nenexggg_1_/**/REALKIND
