
module ol_vamp_1_ppllj2_eexddxg_4_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj2_eexddxg_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj2_eexddxg_4.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllj2_eexddxg_4_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllj2_eexddxg_4_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,8) :: G0
  complex(REALKIND), dimension(4,5,4,22) :: G1
  complex(REALKIND), dimension(4,15,4,26) :: G2
  complex(REALKIND), dimension(4,35,4,6) :: G3
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G1tensorhel(5,4,32))
    allocate(G2tensorhel(15,12,32))
    allocate(G3tensorhel(35,12,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,28),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,6),G2(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,31),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,6),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,31),ZERO,G3tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,12),ZERO,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,28),ZERO,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,31),ZERO,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,5),wf(:,6),G2(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,31),ZERO,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,5),wf(:,6),G2(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),ZERO,G3tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,20),ZERO,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,1),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,23),ZERO,G2(:,:,:,9))
  call check_last_QA_V(l_switch,G2(:,:,:,9),wf(:,-3),G2tensor(:,1))
  call loop_QZ_A(G1(:,:,:,5),wf(:,6),G1(:,:,:,7),gZd)
  call loop_Q_A(G1(:,:,:,7),Q(:,23),ZERO,G2(:,:,:,10))
  call check_last_QA_V(l_switch,G2(:,:,:,10),wf(:,-3),G2tensor(:,2))
  call check_last_QA_V(l_switch,G1(:,:,:,5),wf(:,23),G1tensor(:,1))
  call check_last_QA_V(l_switch,G1(:,:,:,5),wf(:,24),G1tensor(:,2))
  call loop_VA_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,24),ZERO,G1(:,:,:,8))
  call loop_AV_Q(G1(:,:,:,8),wf(:,1),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,27),ZERO,G2(:,:,:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,11),wf(:,-2),G2tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,8),wf(:,6),G1(:,:,:,10),gZd)
  call loop_A_Q(G1(:,:,:,10),Q(:,27),ZERO,G2(:,:,:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,12),wf(:,-2),G2tensor(:,4))
  call check_last_AQ_V(l_switch,G1(:,:,:,8),wf(:,26),G1tensor(:,3))
  call check_last_AQ_V(l_switch,G1(:,:,:,8),wf(:,27),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,8),ZERO,G1(:,:,:,11))
  call loop_AV_Q(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,24),ZERO,G2(:,:,:,13))
  call check_last_AQ_V(l_switch,G2(:,:,:,13),wf(:,26),G2tensor(:,5))
  call check_last_AQ_V(l_switch,G2(:,:,:,13),wf(:,27),G2tensor(:,6))
  call loop_AV_Q(G2(:,:,:,13),wf(:,1),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,27),ZERO,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,-2),G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,6),G2(:,:,:,15),gZd)
  call loop_A_Q(G2(:,:,:,15),Q(:,27),ZERO,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,-2),G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,11),wf(:,1),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,11),ZERO,G2(:,:,:,16))
  call loop_AV_Q(G2(:,:,:,16),wf(:,-4),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,27),ZERO,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-2),G3tensor(:,9))
  call loop_AZ_Q(G1(:,:,:,11),wf(:,6),G1(:,:,:,14),gZd)
  call loop_A_Q(G1(:,:,:,14),Q(:,11),ZERO,G2(:,:,:,18))
  call loop_AV_Q(G2(:,:,:,18),wf(:,-4),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,27),ZERO,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,-2),G3tensor(:,10))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,15))
  call loop_VA_Q(G1(:,:,:,15),wf(:,-3),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,24),ZERO,G2(:,:,:,20))
  call check_last_AQ_V(l_switch,G2(:,:,:,20),wf(:,26),G2tensor(:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,20),wf(:,27),G2tensor(:,8))
  call loop_AV_Q(G2(:,:,:,20),wf(:,1),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,27),ZERO,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,-2),G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,20),wf(:,6),G2(:,:,:,22),gZd)
  call loop_A_Q(G2(:,:,:,22),Q(:,27),ZERO,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,-2),G3tensor(:,12))
  call loop_VA_Q(G1(:,:,:,15),wf(:,23),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,27),ZERO,G2(:,:,:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,-2),G2tensor(:,9))
  call loop_VA_Q(G1(:,:,:,15),wf(:,24),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,27),ZERO,G2(:,:,:,24))
  call check_last_AQ_V(l_switch,G2(:,:,:,24),wf(:,-2),G2tensor(:,10))
  call loop_VA_Q(G0(:,:,:,1),wf(:,23),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,11),ZERO,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-4),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,27),ZERO,G2(:,:,:,25))
  call check_last_AQ_V(l_switch,G2(:,:,:,25),wf(:,-2),G2tensor(:,11))
  call loop_VA_Q(G0(:,:,:,1),wf(:,24),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,11),ZERO,G1(:,:,:,21))
  call loop_AV_Q(G1(:,:,:,21),wf(:,-4),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,27),ZERO,G2(:,:,:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,26),wf(:,-2),G2tensor(:,12))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(21)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(21)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(16)/2._/**/REALKIND) * den(10)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(f(16)/2._/**/REALKIND) * den(10)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(10)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(10)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + ((4*f(12))/3._/**/REALKIND * den(3)) * TI2_call(2,momenta_8,masses2_2,G2tensor(:,1),T2sum(1:15,1))
  M(1) = M(1) + ((4*f(13))/3._/**/REALKIND * den(5)) * TI2_call(2,momenta_8,masses2_2,G2tensor(:,2),T2sum(1:15,1))
  M(1) = M(1) + ((4*f(12))/3._/**/REALKIND * den(7)) * TI2_call(2,momenta_9,masses2_2,G2tensor(:,3),T2sum(1:15,2))
  M(1) = M(1) + ((4*f(13))/3._/**/REALKIND * den(8)) * TI2_call(2,momenta_9,masses2_2,G2tensor(:,4),T2sum(1:15,2))
  M(1) = M(1) + (-(f(12)/6._/**/REALKIND) * den(17)) * TI2_call(2,momenta_3,masses2_2,G2tensor(:,5),T2sum(1:15,3))
  M(1) = M(1) + (-(f(13)/6._/**/REALKIND) * den(19)) * TI2_call(2,momenta_3,masses2_2,G2tensor(:,6),T2sum(1:15,3))
  M(1) = M(1) + ((3*CI*f(10))/2._/**/REALKIND * den(17)) * TI2_call(2,momenta_6,masses2_2,G2tensor(:,7),T2sum(1:15,4))
  M(1) = M(1) + ((3*CI*f(11))/2._/**/REALKIND * den(19)) * TI2_call(2,momenta_6,masses2_2,G2tensor(:,8),T2sum(1:15,4))
  M(1) = M(1) + (-(f(12)/6._/**/REALKIND) * den(12)) * TI2_call(2,momenta_4,masses2_2,G2tensor(:,11),T2sum(1:15,5))
  M(1) = M(1) + (-(f(13)/6._/**/REALKIND) * den(14)) * TI2_call(2,momenta_4,masses2_2,G2tensor(:,12),T2sum(1:15,5))
  M(1) = M(1) + ((3*CI*f(10))/2._/**/REALKIND * den(12)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,9),T2sum(1:15,6))
  M(1) = M(1) + ((3*CI*f(11))/2._/**/REALKIND * den(14)) * TI2_call(2,momenta_7,masses2_2,G2tensor(:,10),T2sum(1:15,6))
  M(1) = M(1) + (-(f(12)/6._/**/REALKIND) * den(1)) * TI2_call(3,momenta_10,masses2_3,G3tensor(:,9),T3sum(1:35,2))
  M(1) = M(1) + (-(f(13)/6._/**/REALKIND) * den(4)) * TI2_call(3,momenta_10,masses2_3,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (-(f(12)/6._/**/REALKIND) * den(1)) * TI2_call(3,momenta_11,masses2_3,G3tensor(:,7),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/6._/**/REALKIND) * den(4)) * TI2_call(3,momenta_11,masses2_3,G3tensor(:,8),T3sum(1:35,3))
  M(1) = M(1) + ((3*CI*f(10))/2._/**/REALKIND * den(1)) * TI2_call(3,momenta_12,masses2_3,G3tensor(:,11),T3sum(1:35,4))
  M(1) = M(1) + ((3*CI*f(11))/2._/**/REALKIND * den(4)) * TI2_call(3,momenta_12,masses2_3,G3tensor(:,12),T3sum(1:35,4))
  M(1) = M(1) + ((4*f(12))/3._/**/REALKIND * den(13)) * TI2_call(1,momenta_1,masses2_1,G1tensor(:,1),T1sum(1:5,1))
  M(1) = M(1) + ((4*f(13))/3._/**/REALKIND * den(15)) * TI2_call(1,momenta_1,masses2_1,G1tensor(:,2),T1sum(1:5,1))
  M(1) = M(1) + ((4*f(12))/3._/**/REALKIND * den(18)) * TI2_call(1,momenta_2,masses2_1,G1tensor(:,3),T1sum(1:5,2))
  M(1) = M(1) + ((4*f(13))/3._/**/REALKIND * den(20)) * TI2_call(1,momenta_2,masses2_1,G1tensor(:,4),T1sum(1:5,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllj2_eexddxg_4_/**/REALKIND
