
module ol_vamp_1_ppllj2_eexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllj2_eexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllj2_eexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllj2_eexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllj2_eexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,19) :: G0
  complex(REALKIND), dimension(4,5,4,36) :: G1
  complex(REALKIND), dimension(4,15,4,60) :: G2
  complex(REALKIND), pointer :: G3tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,42,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,28),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,6),G2(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,31),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,6),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,31),ZERO,G3tensor(:,3))
  call loop_AV_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,12),MT,G1(:,:,:,3))
  call loop_AV_Q(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,28),MT,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),MT,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,5),wf(:,6),G2(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,31),MT,G3tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,12),ZERO,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,-4),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,28),ZERO,G2(:,:,:,8))
  call loop_QV_A(G2(:,:,:,8),wf(:,1),G2(:,:,:,9))
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,31),ZERO,G3tensor(:,6))
  call loop_QZ_A(G2(:,:,:,8),wf(:,6),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,31),ZERO,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,8),wf(:,6),G2(:,:,:,11),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,31),ZERO,G3tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MT,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,28),MT,G2(:,:,:,12))
  call loop_QV_A(G2(:,:,:,12),wf(:,1),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,31),MT,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,12),wf(:,6),G2(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,31),MT,G3tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,12),MB,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,-4),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,28),MB,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,1),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,31),MB,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,6),G2(:,:,:,17),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,31),MB,G3tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,12),MB,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,28),MB,G2(:,:,:,18))
  call loop_QV_A(G2(:,:,:,18),wf(:,1),G2(:,:,:,19))
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,31),MB,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,18),wf(:,6),G2(:,:,:,20),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,31),MB,G3tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,8),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,10),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,28),ZERO,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,1),G2(:,:,:,22))
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,31),ZERO,G3tensor(:,15))
  call loop_QZ_A(G2(:,:,:,21),wf(:,6),G2(:,:,:,23),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,23),Q(:,31),ZERO,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,21),wf(:,6),G2(:,:,:,24),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,31),ZERO,G3tensor(:,17))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,8),MT,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,10),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,28),MT,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,1),G2(:,:,:,26))
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,31),MT,G3tensor(:,18))
  call loop_QZ_A(G2(:,:,:,25),wf(:,6),G2(:,:,:,27),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,27),Q(:,31),MT,G3tensor(:,19))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,8),ZERO,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,10),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,28),ZERO,G2(:,:,:,28))
  call loop_AV_Q(G2(:,:,:,28),wf(:,1),G2(:,:,:,29))
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,31),ZERO,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,28),wf(:,6),G2(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,31),ZERO,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,28),wf(:,6),G2(:,:,:,31),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,31),ZERO,G3tensor(:,22))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,8),MT,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,10),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,28),MT,G2(:,:,:,32))
  call loop_AV_Q(G2(:,:,:,32),wf(:,1),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,31),MT,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,32),wf(:,6),G2(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,31),MT,G3tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,8),MB,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,10),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,28),MB,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,1),G2(:,:,:,36))
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,31),MB,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,35),wf(:,6),G2(:,:,:,37),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,31),MB,G3tensor(:,26))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,8),MB,G1(:,:,:,23))
  call loop_AV_Q(G1(:,:,:,23),wf(:,10),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,28),MB,G2(:,:,:,38))
  call loop_AV_Q(G2(:,:,:,38),wf(:,1),G2(:,:,:,39))
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,31),MB,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,38),wf(:,6),G2(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,31),MB,G3tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,4),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,12),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,28),ZERO,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,1),G2(:,:,:,42))
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,31),ZERO,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,41),wf(:,6),G2(:,:,:,43),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,43),Q(:,31),ZERO,G3tensor(:,30))
  call loop_QZ_A(G2(:,:,:,41),wf(:,6),G2(:,:,:,44),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,44),Q(:,31),ZERO,G3tensor(:,31))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,4),MT,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,12),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,28),MT,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,1),G2(:,:,:,46))
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,31),MT,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,45),wf(:,6),G2(:,:,:,47),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,31),MT,G3tensor(:,33))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,4),ZERO,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,12),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,28),ZERO,G2(:,:,:,48))
  call loop_AV_Q(G2(:,:,:,48),wf(:,1),G2(:,:,:,49))
  call check_last_A_Q(l_switch,G2(:,:,:,49),Q(:,31),ZERO,G3tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,48),wf(:,6),G2(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,31),ZERO,G3tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,48),wf(:,6),G2(:,:,:,51),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,31),ZERO,G3tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,4),MT,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,12),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,28),MT,G2(:,:,:,52))
  call loop_AV_Q(G2(:,:,:,52),wf(:,1),G2(:,:,:,53))
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,31),MT,G3tensor(:,37))
  call loop_AZ_Q(G2(:,:,:,52),wf(:,6),G2(:,:,:,54),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,31),MT,G3tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,4),MB,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,12),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,28),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,1),G2(:,:,:,56))
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,31),MB,G3tensor(:,39))
  call loop_QZ_A(G2(:,:,:,55),wf(:,6),G2(:,:,:,57),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,31),MB,G3tensor(:,40))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,4),MB,G1(:,:,:,35))
  call loop_AV_Q(G1(:,:,:,35),wf(:,12),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,28),MB,G2(:,:,:,58))
  call loop_AV_Q(G2(:,:,:,58),wf(:,1),G2(:,:,:,59))
  call check_last_A_Q(l_switch,G2(:,:,:,59),Q(:,31),MB,G3tensor(:,41))
  call loop_AZ_Q(G2(:,:,:,58),wf(:,6),G2(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,31),MB,G3tensor(:,42))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(6)) * den(9)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(6) * den(9)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(4)) * den(9)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(4) * den(9)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(9)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(6) * den(9)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(4)) * den(9)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(4) * den(9)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(4) * den(9)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(4)) * den(9)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(3) * den(9)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3)) * den(9)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(4) * den(9)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(4)) * den(9)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(3) * den(9)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,13),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3)) * den(9)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,13),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(7) * den(4)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(7)) * den(4)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(5) * den(4)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(4)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(7) * den(4)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,7),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(7)) * den(4)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(5) * den(4)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(4)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(7) * den(4)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(7)) * den(4)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(5) * den(4)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(4)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(7) * den(4)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,8),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(7)) * den(4)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(5) * den(4)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,14),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(4)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,14),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(6) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,15),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(6)) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,15),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(4) * den(10)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(4)) * den(10)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,20),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(6)) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,20),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(4) * den(10)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(4)) * den(10)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(4)) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,15),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(4) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,15),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3)) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(3) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(4)) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,20),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(4) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,20),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3)) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(3) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(7)) * den(6)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,16),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(7) * den(6)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,16),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(5)) * den(6)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(6)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(7)) * den(6)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,21),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(7) * den(6)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,21),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(5)) * den(6)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(6)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(7)) * den(6)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,17),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(7) * den(6)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,17),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(5)) * den(6)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(6)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(7)) * den(6)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,22),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(7) * den(6)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,22),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(5)) * den(6)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(6)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(6)) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(4)) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,32),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(4) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,32),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(6)) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(4)) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,37),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(4) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,37),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(4) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(4)) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(3) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(3)) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(4) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(4)) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(3) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(3)) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(7) * den(8)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(7)) * den(8)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(8)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,33),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(5)) * den(8)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,33),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(7) * den(8)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,35),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(7)) * den(8)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,35),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(8)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,38),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(5)) * den(8)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,38),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(7) * den(8)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(7)) * den(8)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(8)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(8)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(7) * den(8)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,36),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(7)) * den(8)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,36),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(8)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(8)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,9))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllj2_eexggg_1_/**/REALKIND
